{-
    Kaya - My favourite toy language.
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU General
    Public Licence. See COPYING for licence.
-}

module Errors where

import AbsSyntax
import Portability

-- Represent errors as a datatype, so that they can be changed easily
-- TODO: Not used yet, but it would be nice if it was!

{-
data Error = CantUnify Type Type
           | NotCasable Type
           | NotPrintable Type
           | UndefName Name
           | AmbiguousName Name [(Name, Type)]
           | PrivateName Name
           | TooManyArgs
           | CantForLoop Type
           | NeedTypeDecl Name
           | Unknown Field Name Type
           | IsVoid Name
           | CantDoOp Op Type Type
           | CantDoUnOp Op Type
           | CantCoerce Type Type
           | DataDefined Name
           | TypeDefined Name
           | FunDefined Name
           | DupField Name Name
           | NotAllReturn Name
           | NotParameter Type
           | UndeclaredTyVar Name
           | Undefype Name
           | GenericTypeError
           | InfiniteType
           | LessGeneral Type Type
-}

reportError :: String -> IO ()
reportError err = do mcols <- environment "COLUMNS"
                     let cols = case mcols of
                                   Nothing -> 80
                                   Just x -> read x :: Int
                     putStrLn (format cols err)

format :: Int -> String -> String
format cols str = format' cols cols (words str)

format' :: Int -> Int -> [String] -> String
format' _ _ [] = ""
format' cols i (x:xs) 
    | (length x + 1) < i || ((length x + 1) >= cols && i == cols)
        = x ++ (if null xs then "" else
                " " ++ format' cols (i - (length x + 1)) xs)
    | otherwise = "\n" ++ format' cols cols (x:xs)
