module Portability5 where

import Lib
import System.IO
import System.Posix
import Data.FiniteMap

-- GHC 5.04 and above library incompatibilities.

environment :: String -> IO (Maybe String)
environment x = getEnv x

tempfile :: IO (FilePath, Handle)
tempfile = do env <- environment "TMPDIR"
	      let dir = case env of
		   Nothing -> tmpdir
		   (Just d) -> d
	      mkstemp $ tmpdir ++ "/kaya_XXXXXX"

type Dict k v = FiniteMap k v

dictInsert :: Ord k => k -> v -> Dict k v -> Dict k v
dictInsert k v d = addToFM d k v

dictElems = eltsFM
dictEmpty = emptyFM

dictLookup :: Ord k => k -> Dict k v -> Maybe v
dictLookup v d = lookupFM d v
