#***************************************************************************
# *   Copyright (C) 2003 by A Lynch                                  *
# *   aalynch@users.sourceforge.net                                        *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

from PyQt4 import QtGui, QtCore

import logging
l = logging.getLogger(__name__)

class EquationDraw(QtGui.QWidget):
    """ A widget that can draw an equation inside itself """
    def __init__(self, parent):
        QtGui.QWidget.__init__(self,parent)
        #self.setBackgroundMode(Qt.PaletteLight)

    def paintEvent(self, event):
        """ override default paint"""
        self.painter = QtGui.QPainter(self)
        self.drawContent()

    def setContents(self,contents):
        self.contents = contents
        self.repaint()

    def drawContent(self):
        #print "content is " + repr(self.contents)
        if "contents" in dir(self) and "textOnly" in dir(self.contents):
            if self.contents.textOnly == False:
                objectHeight = self.contents.node.h
                objectWidth = self.contents.node.w
                objectCentreHeight = self.contents.node.operatorcentreline
                viewH = self.size().height()
                viewW = self.size().width()
                # TODO why do I have to subtract 20 here? Why doesn't the height of the widget inside the splitter seem to be correct?
                self.contents.node = self.contents.node.layoutNode((viewW-objectWidth)/2.0,(viewH + objectHeight)/2.0 - objectCentreHeight - 20,\
                                                                   viewW, 14) 
                self.contents.node.drawNode(self.painter)
            else:
                self.painter.drawText(5,20,self.contents.text)

                
