How to contribute
=================

If you want to contribute to the libraries in any way such as adding new components
or fixing existing ones, you are more than welcome to submit a pull request on GitHub for
the relevant repository.

If you are new to GitHub, please check out this guide
[Contributing to Open Source on GitHub](https://guides.github.com/activities/contributing-to-open-source)
before you start.

When creating/editing/fixing a symbol or footprint a set of conventions (a.k.a rules)
should be followed. They are the
[KiCad Library Convention](https://github.com/KiCad/kicad-library/wiki/Kicad-Library-Convention),
or KLC for short. This convention aims to make symbols and footprints have a
unique standard which is valuable in many aspects. Please, read the KLC carefully and
make sure your pull request is compliant with it. Librarians often are very demanding
about respecting the KLC.

Note that the KLC is in some way a newcomer, this mean there are several symbols and
footprints in the KiCad repositories that are not KLC compliant yet. However,
there is an [effort](https://github.com/KiCad/kicad-library/wiki/Status-of-the-libraries)
to make all libraries KLC compliant. You can also help by doing some work in this
direction.

When possible, take an already existing KLC symbol/footprint as an example to
create/edit symbols and/or footprints. Furthermore, you can use the
[kicad-library-utils](https://github.com/KiCad/kicad-library-utils) scripts to help
you check/fix KLC issues. For more information about how to use the scripts
please look at the README.md file in the repository. It is important to know that the
scripts does not cover all KLC rules, which means that if you got no issues reported
by script, this does not imply your submission will be accepted or that it is not
violating the KLC rules.