// Do not edit this file, it is autogenerated by CMake from the .md file
_HKI( "### Top-level Clauses\n"
"\n"
"    (version <number>)\n"
"\n"
"    (rule <rule_name> <rule_clause> ...)\n"
"\n"
"\n"
"<br>\n"
"\n"
"### Rule Clauses\n"
"\n"
"    (constraint <constraint_type> ...)\n"
"\n"
"    (condition \"<expression>\")\n"
"\n"
"    (layer \"<layer_name>\")\n"
"\n"
"    (severity <severity_name>)\n"
"\n"
"\n"
"<br>\n"
"\n"
"### Constraint Types\n"
"\n"
" * annular\\_width\n"
" * assertion\n"
" * clearance\n"
" * connection\\_width\n"
" * courtyard_clearance\n"
" * diff\\_pair\\_gap\n"
" * diff\\_pair\\_uncoupled\n"
" * disallow\n"
" * edge\\_clearance\n"
" * length\n"
" * hole\\_clearance\n"
" * hole\\_size\n"
" * min\\_resolved\\_spokes\n"
" * physical\\_clearance\n"
" * physical\\_hole\\_clearance\n"
" * silk\\_clearance\n"
" * skew\n"
" * text\\_height\n"
" * text\\_thickness\n"
" * thermal\\_relief\\_gap\n"
" * thermal\\_spoke\\_width\n"
" * track\\_width\n"
" * via\\_count\n"
" * via\\_diameter\n"
" * zone\\_connection\n"
"\n"
"Note: `clearance` and `hole_clearance` rules are not run against items of the same net; `physical_clearance` and `physical_hole_clearance` rules are.\n"
"<br><br>\n"
"\n"
"### Items\n"
"\n"
" * `A` &nbsp;&nbsp; _the first (or only) item under test_\n"
" * `B` &nbsp;&nbsp; _the second item under test (for binary tests)_\n"
" * `L` &nbsp;&nbsp; _the layer currently under test_\n"
"\n"
"<br>\n"
"\n"
"### Item Types\n"
"\n"
" * buried\\_via\n"
" * graphic\n"
" * hole\n"
" * micro\\_via\n"
" * pad\n"
" * text\n"
" * track\n"
" * via\n"
" * zone\n"
"\n"
"<br>\n"
"\n"
"### Zone Connections\n"
"\n"
" * solid\n"
" * thermal\\_reliefs\n"
" * none\n"
"\n"
"<br>\n"
"\n"
"### Severity Names\n"
"\n"
" * warning\n"
" * error\n"
" * exclusion\n"
" * ignore\n"
"\n"
"<br>\n"
"\n"
"### Examples\n"
"\n"
"    (version 1)\n"
"\n"
"    (rule HV\n"
"       (constraint clearance (min 1.5mm))\n"
"       (condition \"A.NetClass == 'HV'\"))\n"
"\n"
"\n"
"    (rule HV\n"
"       (layer outer)\n"
"       (constraint clearance (min 1.5mm))\n"
"       (condition \"A.NetClass == 'HV'\"))\n"
"\n"
"\n"
"    (rule HV_HV\n"
"       # wider clearance between HV tracks\n"
"       (constraint clearance (min \"1.5mm + 2.0mm\"))\n"
"       (condition \"A.NetClass == 'HV' && B.NetClass == 'HV'\"))\n"
"\n"
"\n"
"    (rule HV_unshielded\n"
"       (constraint clearance (min 2mm))\n"
"       (condition \"A.NetClass == 'HV' && !A.enclosedByArea('Shield*')\"))\n"
"\n"
"\n"
"    (rule heavy_thermals\n"
"       (constraint thermal_spoke_width (min 0.5mm))\n"
"       (condition \"A.NetClass == 'HV'\"))\n"
"<br><br>\n"
"\n"
"### Notes\n"
"\n"
"Version clause must be the first clause.  It indicates the syntax version of the file so that \n"
"future rules parsers can perform automatic updates.  It should be\n"
"set to \"1\".\n"
"\n"
"Rules should be ordered by specificity.  Later rules take\n"
"precedence over earlier rules; once a matching rule is found\n"
"no further rules will be checked.\n"
"\n"
"Use Ctrl+/ to comment or uncomment line(s).\n"
"<br><br><br>\n"
"\n"
"### Expression functions\n"
"\n"
"All function parameters support simple wildcards (`*` and `?`).\n"
"<br><br>\n"
"\n"
"    A.intersectsCourtyard('<footprint_refdes>')\n"
"True if any part of `A` lies within the given footprint's principal courtyard.\n"
"<br><br>\n"
"\n"
"    A.intersectsFrontCourtyard('<footprint_refdes>')\n"
"True if any part of `A` lies within the given footprint's front courtyard.\n"
"<br><br>\n"
"\n"
"    A.intersectsBackCourtyard('<footprint_refdes>')\n"
"True if any part of `A` lies within the given footprint's back courtyard.\n"
"<br><br>\n"
"\n"
"    A.intersectsArea('<zone_name>')\n"
"True if any part of `A` lies within the given zone's outline.\n"
"<br><br>\n"
"\n"
"    A.enclosedByArea('<zone_name>')\n"
"True if all of `A` lies within the given zone's outline.  \n"
"\n"
"NB: this is potentially a more expensive call than `intersectsArea()`.  Use `intersectsArea()` \n"
"where possible.\n"
"<br><br>\n"
"\n"
"    A.isPlated()\n"
"True if `A` has a hole which is plated.\n"
"<br><br>\n"
"\n"
"    A.inDiffPair('<net_name>')\n"
"True if `A` has a net that is part of the specified differential pair.\n"
"`<net_name>` is the base name of the differential pair.  For example, `inDiffPair('/CLK')`\n"
"matches items in the `/CLK_P` and `/CLK_N` nets.\n"
"<br><br>\n"
"\n"
"    AB.isCoupledDiffPair()\n"
"True if `A` and `B` are members of the same diff pair.\n"
"<br><br>\n"
"\n"
"    A.memberOf('<group_name>')\n"
"True if `A` is a member of the given group. Includes nested membership.\n"
"<br><br>\n"
"\n"
"    A.existsOnLayer('<layer_name>')\n"
"True if `A` exists on the given layer.  The layer name can be\n"
"either the name assigned in Board Setup > Board Editor Layers or\n"
"the canonical name (ie: `F.Cu`).\n"
"\n"
"NB: this returns true if `A` is on the given layer, independently\n"
"of whether or not the rule is being evaluated for that layer.\n"
"For the latter use a `(layer \"layer_name\")` clause in the rule.\n"
"<br><br>\n"
"\n"
"    !!! A.insideCourtyard('<footprint_refdes>') !!!\n"
"Deprecated; use `intersectsCourtyard()` instead.\n"
"<br><br>\n"
"\n"
"    !!! A.insideFrontCourtyard('<footprint_refdes>') !!!\n"
"Deprecated; use `intersectsFrontCourtyard()` instead.\n"
"<br><br>\n"
"\n"
"    !!! A.insideBackCourtyard('<footprint_refdes>') !!!\n"
"Deprecated; use `intersectsBackCourtyard()` instead.\n"
"<br><br>\n"
"\n"
"    !!! A.insideArea('<zone_name>') !!!\n"
"Deprecated; use `intersectsArea()` instead.\n"
"<br><br><br>\n"
"\n"
"### More Examples\n"
"\n"
"    (rule \"copper keepout\"\n"
"       (constraint disallow track via zone)\n"
"       (condition \"A.intersectsArea('zone3')\"))\n"
"\n"
"\n"
"    (rule \"BGA neckdown\"\n"
"       (constraint track_width (min 0.2mm) (opt 0.25mm))\n"
"       (constraint clearance (min 0.05mm) (opt 0.08mm))\n"
"       (condition \"A.intersectsCourtyard('U3')\"))\n"
"\n"
"\n"
"    # prevent silk over tented vias\n"
"    (rule silk_over_via\n"
"       (constraint silk_clearance (min 0.2mm))\n"
"       (condition \"A.Type == '*Text' && B.Type == 'Via'\"))\n"
"\n"
"\n"
"    (rule \"Distance between Vias of Different Nets\"\n"
"        (constraint hole_to_hole (min 0.254mm))\n"
"        (condition \"A.Type == 'Via' && B.Type == 'Via' && A.Net != B.Net\"))\n"
"\n"
"    (rule \"Clearance between Pads of Different Nets\"\n"
"        (constraint clearance (min 3.0mm))\n"
"        (condition \"A.Type == 'Pad' && B.Type == 'Pad' && A.Net != B.Net\"))\n"
"\n"
"\n"
"    (rule \"Via Hole to Track Clearance\"\n"
"        (constraint hole_clearance (min 0.254mm))\n"
"        (condition \"A.Type == 'Via' && B.Type == 'Track'\"))\n"
"\n"
"    (rule \"Pad to Track Clearance\"\n"
"        (constraint clearance (min 0.2mm))\n"
"        (condition \"A.Type == 'Pad' && B.Type == 'Track'\"))\n"
"\n"
"\n"
"    (rule \"clearance-to-1mm-cutout\"\n"
"        (constraint clearance (min 0.8mm))\n"
"        (condition \"A.Layer == 'Edge.Cuts' && A.Thickness == 1.0mm\"))\n"
"\n"
"\n"
"    (rule \"Max Drill Hole Size Mechanical\"\n"
"        (constraint hole_size (max 6.3mm))\n"
"        (condition \"A.Pad_Type == 'NPTH, mechanical'\"))\n"
"\n"
"    (rule \"Max Drill Hole Size PTH\"\n"
"        (constraint hole_size (max 6.35mm))\n"
"        (condition \"A.Pad_Type == 'Through-hole'\"))\n"
"\n"
"\n"
"    # Specify an optimal gap for a particular diff-pair\n"
"    (rule \"dp clock gap\"\n"
"        (constraint diff_pair_gap (opt \"0.8mm\"))\n"
"        (condition \"A.inDiffPair('/CLK')\"))\n"
"\n"
"    # Specify a larger clearance around any diff-pair\n"
"    (rule \"dp clearance\"\n"
"        (constraint clearance (min \"1.5mm\"))\n"
"        (condition \"A.inDiffPair('*') && !AB.isCoupledDiffPair()\"))\n"
"\n"
"\n"
"    # Don't use thermal reliefs on heatsink pads\n"
"    (rule heat_sink_pad\n"
"        (constraint zone_connection solid)\n"
"        (condition \"A.Fabrication_Property == 'Heatsink pad'\"))\n"
"\n"
"    # Require all four thermal relief spokes to connect to parent zone\n"
"    (rule fully_spoked_pads\n"
"        (constraint min_resolved_spokes 4))\n"
"\n"
"    # Set thermal relief gap & spoke width for all zones\n"
"    (rule defined_relief\n"
"        (constraint thermal_relief_gap (min 10mil))\n"
"        (constraint thermal_spoke_width (min 12mil)))\n"
"\n"
"    # Override thermal relief gap & spoke width for GND and PWR zones\n"
"    (rule defined_relief_pwr\n"
"        (constraint thermal_relief_gap (min 10mil))\n"
"        (constraint thermal_spoke_width (min 12mil))\n"
"        (condition \"A.Name == 'zone_GND' || A.Name == 'zone_PWR'\"))\n"
"\n"
"\n"
"    # Prevent solder wicking from SMD pads\n"
"    (rule holes_in_pads\n"
"        (constraint physical_hole_clearance (min 0.2mm))\n"
"        (condition \"B.Pad_Type == 'SMD'\"))\n"
"\n"
"    # Disallow solder mask margin overrides\n"
"    (rule \"disallow solder mask margin overrides\"\n"
"        (constraint assertion \"A.Soldermask_Margin_Override == 0mm\")\n"
"        (condition \"A.Type == 'Pad'\"))\n"
"\n"
"\n"
"    # Enforce a mechanical clearance between components and board edge\n"
"    (rule front_mechanical_board_edge_clearance\n"
"        (layer \"F.Courtyard\")\n"
"        (constraint physical_clearance (min 3mm))\n"
"        (condition \"B.Layer == 'Edge.Cuts'\"))\n"
"\n"
"\n"
"    # Check current-carrying capacity\n"
"    (rule high-current\n"
"        (constraint track_width (min 1.0mm))\n"
"        (constraint connection_width (min 0.8mm))\n"
"        (condition \"A.NetClass == 'Power'\"))" );
