/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "dialog.h"
#include <QMouseEvent>
#include <QEvent>
#include <QDebug>

#include "ukui-wayland/ukui-decoration-manager.h"
#include "global/xatom-helper.h"
#include "global/global.h"

Dialog::Dialog(QWidget *parent):
    QDialog(parent)
{
    if(Global::isWayland)
        installEventFilter(this);
    else {
        MotifWmHints hints1;
        hints1.flags = MWM_HINTS_FUNCTIONS | MWM_HINTS_DECORATIONS;
        hints1.functions = MWM_FUNC_ALL;
        hints1.decorations = MWM_DECOR_BORDER;
        XAtomHelper::getInstance()->setWindowMotifHint(winId(), hints1);
    }
}

Dialog::~Dialog()
{

}

void Dialog::ukuiMove()
{
    if(Global::isWayland)
        UKUIDecorationManager::getInstance()->moveWindow(this->windowHandle());
}

bool Dialog::eventFilter(QObject *watched, QEvent *event)
{
    if(watched == this)
    {
        if (event->type() == QEvent::MouseButtonPress){
            auto mouseEvent = static_cast<QMouseEvent *>(event);
            if (mouseEvent->buttons() & Qt::LeftButton) {
                ukuiMove();
            }
        }
    }
    return false;
}

void Dialog::showEvent(QShowEvent *event)
{
    QDialog::showEvent(event);
    if(Global::isWayland)
        UKUIDecorationManager::getInstance()->removeHeaderBar(windowHandle());
}
