/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef FFUTIL_H
#define FFUTIL_H

#include <QObject>

#include <libffmpegthumbnailer/videothumbnailer.h>
using namespace ffmpegthumbnailer;

struct AVCodec;
struct AVCodecContext;
struct AVFormatContext;

class FFUtil : public QObject
{
    Q_OBJECT
public:
    explicit FFUtil(QObject *parent = nullptr);
    ~FFUtil();
    int open(QString _file);
    int getDuration();
    void close();
    void saveIFrame(QString _savePath);

private:
    QString m_fileName;
    VideoThumbnailer *m_videoTbr;
    AVFormatContext *pFormatCtx;
    AVCodecContext  *pCodecCtx;
    AVCodec         *pCodec;
    int videoStream;
    int videoDuration;

    int fitTime(int _duration);

signals:

};

#endif // FFUTIL_H
