/* Generated by wayland-scanner 1.18.0 */

/*
 * Copyright (C) 2015 The Qt Company Ltd.
 * Contact: http://www.qt.io/licensing/
 *
 * This file is part of the examples of the Qt Wayland module
 *
 * $QT_BEGIN_LICENSE:BSD$
 * You may use this file under the terms of the BSD license as follows:
 *
 * "Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * * Neither the name of The Qt Company Ltd nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 *
 * $QT_END_LICENSE$
 */

#include "ukui-decoration-manager.h"

#include "ukui-decoration-client.h"

#include <QApplication>
#include <qpa/qplatformnativeinterface.h>
#include <KWayland/Client/connection_thread.h>

static UKUIDecorationManager *global_instance = nullptr;

static wl_display *display = nullptr;
static ukui_decoration *ukui_decoration_manager = nullptr;

static void handle_global(void *data, struct wl_registry *registry,
                          uint32_t name, const char *interface, uint32_t version) {
    if (strcmp(interface, ukui_decoration_interface.name) == 0) {
        ukui_decoration_manager = (ukui_decoration *) wl_registry_bind(registry, name, &ukui_decoration_interface, version);
    }
}

static void handle_global_remove(void *data, struct wl_registry *registry,
                                 uint32_t name) {
    // Who cares
}

static const struct wl_registry_listener registry_listener = {
    .global = handle_global,
    .global_remove = handle_global_remove,
};

UKUIDecorationManager *UKUIDecorationManager::getInstance()
{
    if (!global_instance)
        global_instance = new UKUIDecorationManager;
    return global_instance;
}

bool UKUIDecorationManager::supportUKUIDecoration()
{
    return ukui_decoration_manager;
}

bool UKUIDecorationManager::moveWindow(QWindow *windowHandle)
{
    if (!supportUKUIDecoration())
        return false;

    auto nativeInterface = qApp->platformNativeInterface();
    wl_surface *surface = reinterpret_cast<wl_surface *>(nativeInterface->nativeResourceForWindow(QByteArrayLiteral("surface"), windowHandle));
    if (!surface)
        return false;

    ukui_decoration_move_surface(ukui_decoration_manager, surface);
    wl_surface_commit(surface);
    wl_display_roundtrip(display);
    return true;
}

bool UKUIDecorationManager::removeHeaderBar(QWindow *windowHandle)
{
    if (!supportUKUIDecoration())
        return false;

    auto nativeInterface = qApp->platformNativeInterface();
    wl_surface *surface = reinterpret_cast<wl_surface *>(nativeInterface->nativeResourceForWindow(QByteArrayLiteral("surface"), windowHandle));
    if (!surface)
        return false;

    ukui_decoration_set_ukui_decoration_mode(ukui_decoration_manager, surface, 1);
    wl_surface_commit(surface);
    wl_display_roundtrip(display);
    return true;
}

bool UKUIDecorationManager::setCornerRadius(QWindow *windowHandle, int topleft, int topright, int bottomleft, int bottomright)
{
    if (!supportUKUIDecoration())
        return false;

    auto nativeInterface = qApp->platformNativeInterface();
    wl_surface *surface = reinterpret_cast<wl_surface *>(nativeInterface->nativeResourceForWindow(QByteArrayLiteral("surface"), windowHandle));
    if (!surface)
        return false;

    ukui_decoration_set_unity_border_radius(ukui_decoration_manager, surface, topleft, topright, bottomleft, bottomright);
    wl_surface_commit(surface);
    wl_display_roundtrip(display);
    return true;
}

UKUIDecorationManager::UKUIDecorationManager()
{
    auto connectionThread = KWayland::Client::ConnectionThread::fromApplication(qApp);
    display = connectionThread->display();

    struct wl_registry *registry = wl_display_get_registry(display);

    // get ukui_decoration_manager
    wl_registry_add_listener(registry, &registry_listener, nullptr);
    wl_display_roundtrip(display);
}
