package tests::TestDlfAnalyserTestCaseTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::DlfAnalyser;
use Lire::Test::DlfAnalyserTestCase;

sub new {
    my $self = shift->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'analyser'} =
      new Class::Inner( 'parent' => 'Lire::DlfAnalyser',
                        methods =>
                        {
                         'new' => sub { bless {}, shift },
                         'name' => sub { 'myanalyser' },
                         'src_schema' => sub { 'test' },
                         'dst_schema' => sub { 'test-derived' },
                        } );

    $self->{'test'} =
      new Class::Inner( 'parent' => 'Lire::Test::DlfAnalyserTestCase',
                        'methods' =>
                        {
                         'new' => sub { bless {}, shift },
                         'create_analyser' => sub { $self->{'analyser'} }
                        } );
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_create_mock_process {
    my $self = $_[0];

    my $process = $self->{'test'}->create_mock_process();
    $self->assert_isa( 'Lire::Test::MockDlfAnalyserProcess', $process );
    $self->assert_str_equals( $self->{'analyser'},
                              $process->{'_analyser_instance'} );
    $self->assert_str_equals( $self->{'analyser'},
                              $process->analyser_instance() );
    $self->assert_num_equals( 0, $process->{'_dlf_count'} );
    $self->assert_num_equals( 0, $process->{'_error_count'} );
    $self->assert_deep_equals( [], $process->{'_errors'} );
    $self->assert_deep_equals( [], $process->{'_dlf'} );
    $self->assert_null( $process->dlf_source() );

    my $store = bless {}, 'Lire::DlfStore';
    $process = $self->{'test'}->create_mock_process( $store );
    $self->assert_str_equals( $store, $process->dlf_store() );
}

sub test_mock_process_error {
    my $self = $_[0];

    my $process = $self->{'test'}->create_mock_process();
    $self->assert_isa( 'Lire::Test::MockDlfAnalyserProcess', $process );
    $process->error( 'Test error' );
    $self->assert_deep_equals( [ 'Test error' ],
                               $process->{'_errors'} );

    $process->error( 'Another error' );
    $self->assert_deep_equals( [ 'Test error', 'Another error' ],
                               $process->errors() );
    $self->assert_num_equals( 2, $process->error_count() );
}

sub test_mock_process_write_dlf {
    my $self = $_[0];

    my $process = $self->{'test'}->create_mock_process();
    $self->assert_isa( 'Lire::Test::MockDlfAnalyserProcess', $process );

    my $dlf = { 'connection_id' => 'An id' };
    $process->write_dlf( $dlf );
    $self->assert_deep_equals( [ [ $dlf ] ], $process->{'_dlf'} );
    $self->assert_str_not_equals( $dlf, $process->{'_dlf'}[0][0] );

    $dlf->{'time_start'} = time;
    $process->write_dlf( $dlf, [ 1, 2, 3 ] );
    $self->assert_deep_equals( [ [{ 'connection_id' => 'An id' }], 
                                 [ $dlf, 1, 2, 3 ] ],
                                 $process->dlf()  );
    $self->assert_num_equals( 2, $process->dlf_count() );
}

1;
