/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.List;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.IArgument;
import org.lisaac.ldt.model.items.ICode;
import org.lisaac.ldt.model.items.ITMList;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.model.types.TypeBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITMBlock
implements ICode {
    protected ITMList list;
    protected IArgument argument;

    public ITMBlock(ITMList list, IArgument argument, Slot slot) {
        this.list = list;
        this.argument = argument;
        if (slot != null) {
            slot.addSubList(this);
        }
    }

    @Override
    public IType getType(Slot slot, Prototype prototype) {
        return TypeBlock.get(null, null);
    }

    @Override
    public void refactorRenamePrototype(String oldName, String newName, List<TextEdit> edits) {
        if (this.argument != null && this.list != null) {
            IType type = this.argument.getType();
            Position p = this.argument.getPosition();
            if (p != null && type.toString().compareTo(oldName) == 0) {
                LisaacParser parser = this.list.getOwner().getPrototype().openParser();
                parser.setPosition(p.offset + p.length);
                parser.readCharacter(':');
                parser.readSpace();
                int startOffset = parser.getOffset();
                edits.add((TextEdit)new DeleteEdit(startOffset, oldName.length()));
                edits.add((TextEdit)new InsertEdit(startOffset, newName));
            }
        }
        if (this.list != null) {
            this.list.refactorRenamePrototype(oldName, newName, edits);
        }
    }
}

