/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.ICode;
import org.lisaac.ldt.model.items.ITMLocal;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.outline.OutlineImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITMList
implements ICode {
    protected ICode[] code;
    protected ITMLocal[] localList;
    protected ITMLocal[] staticList;
    protected int startOffset;
    protected int endOffset;
    private Slot owner;

    public ITMList(Slot slot, int start) {
        this.endOffset = this.startOffset = start;
        this.owner = slot;
        if (slot != null) {
            slot.addSubList(this);
        }
    }

    public Slot getOwner() {
        return this.owner;
    }

    public void setEndOffset(int end) {
        this.endOffset = end;
    }

    public void setCode(ICode[] code) {
        this.code = code;
    }

    public void setLocalList(ITMLocal[] list) {
        this.localList = list;
    }

    public void setStaticList(ITMLocal[] list) {
        this.staticList = list;
    }

    public boolean hasVariableDefinition(String word) {
        return this.getLocal(word) != null;
    }

    public ITMLocal getLocal(String word) {
        int i;
        if (this.localList != null) {
            i = 0;
            while (i < this.localList.length) {
                if (this.localList[i].name.compareTo(word) == 0) {
                    return this.localList[i];
                }
                ++i;
            }
        }
        if (this.staticList != null) {
            i = 0;
            while (i < this.staticList.length) {
                if (this.staticList[i].name.compareTo(word) == 0) {
                    return this.staticList[i];
                }
                ++i;
            }
        }
        return null;
    }

    private List<String> getLocalMatches(String n) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        if (this.localList != null) {
            i = 0;
            while (i < this.localList.length) {
                if (this.localList[i].name.startsWith(n)) {
                    result.add(this.localList[i].name);
                }
                ++i;
            }
        }
        if (this.staticList != null) {
            i = 0;
            while (i < this.staticList.length) {
                if (this.staticList[i].name.startsWith(n)) {
                    result.add(this.staticList[i].name);
                }
                ++i;
            }
        }
        return result;
    }

    public void getMatchProposals(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        List<String> matches = this.getLocalMatches(n);
        int i = 0;
        while (i < matches.size()) {
            String match = matches.get(i);
            if (Slot.checkUnicity(matchList, match)) {
                Image image = OutlineImages.PRIVATE_NONSHARED;
                String partialMatch = match.substring(n.length());
                matchList.add((ICompletionProposal)new CompletionProposal(partialMatch, offset, length, partialMatch.length(), image, match, null, null));
            }
            ++i;
        }
    }

    @Override
    public IType getType(Slot slot, Prototype prototype) {
        if (this.code != null && this.code.length > 0) {
            return this.code[this.code.length - 1].getType(slot, prototype);
        }
        return null;
    }

    public boolean isInside(int offset) {
        return offset >= this.startOffset && offset <= this.endOffset;
    }

    @Override
    public void refactorRenamePrototype(String oldName, String newName, List<TextEdit> edits) {
        int i;
        if (this.localList != null && this.owner != null) {
            i = 0;
            while (i < this.localList.length) {
                this.createEdit(this.localList[i], oldName, newName, edits);
                ++i;
            }
        }
        if (this.staticList != null && this.owner != null) {
            i = 0;
            while (i < this.staticList.length) {
                this.createEdit(this.staticList[i], oldName, newName, edits);
                ++i;
            }
        }
        if (this.code != null) {
            i = 0;
            while (i < this.code.length) {
                this.code[i].refactorRenamePrototype(oldName, newName, edits);
                ++i;
            }
        }
    }

    private void createEdit(ITMLocal local, String oldName, String newName, List<TextEdit> edits) {
        IType type = local.getType();
        Position p = local.getPosition();
        if (p != null && type.toString().compareTo(oldName) == 0) {
            LisaacParser parser = this.owner.getPrototype().openParser();
            parser.setPosition(p.offset + p.length);
            parser.readCharacter(':');
            parser.readSpace();
            int startOffset = parser.getOffset();
            edits.add((TextEdit)new DeleteEdit(startOffset, oldName.length()));
            edits.add((TextEdit)new InsertEdit(startOffset, newName));
        }
    }
}

