/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.Emitter;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerProxy
extends Emitter
implements Locator {
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    protected Locator locator = this;
    private int depth = 0;
    protected boolean requireWellFormed = true;

    public void setUnderlyingContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public void setOutputProperties(Properties properties) {
        super.setOutputProperties(properties);
        if ("no".equals(properties.getProperty("{http://saxon.sf.net/}require-well-formed"))) {
            this.requireWellFormed = false;
        }
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setRequireWellFormed(boolean bl) {
        this.requireWellFormed = bl;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws TransformerException {
        if (this.handler == null) {
            throw new TransformerException("ContentHandlerProxy.startDocument(): no underlying handler provided");
        }
        try {
            this.handler.setDocumentLocator(this.locator);
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        this.depth = 0;
    }

    public void endDocument() throws TransformerException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        ++this.depth;
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                this.notifyNotWellFormed();
            }
            if (this.depth > 0 || !this.requireWellFormed) {
                int n3 = 0;
                while (n3 < n2) {
                    String string = this.namePool.getPrefixFromNamespaceCode(nArray[n3]);
                    String string2 = this.namePool.getURIFromNamespaceCode(nArray[n3]);
                    this.handler.startPrefixMapping(string, string2);
                    ++n3;
                }
                this.handler.startElement(this.namePool.getURI(n), this.namePool.getLocalName(n), this.namePool.getDisplayName(n), attributes);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void endElement(int n) throws TransformerException {
        if (this.depth > 0) {
            try {
                this.handler.endElement(this.namePool.getURI(n), this.namePool.getLocalName(n), this.namePool.getDisplayName(n));
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                boolean bl;
                boolean bl2 = bl = new String(cArray, n, n2).trim().length() == 0;
                if (!bl) {
                    this.notifyNotWellFormed();
                    if (!this.requireWellFormed) {
                        this.handler.characters(cArray, n, n2);
                    }
                }
            } else {
                this.handler.characters(cArray, n, n2);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    protected void notifyNotWellFormed() throws SAXException {
        try {
            this.handler.processingInstruction("saxon:warning", "Output suppressed because it is not well-formed");
        }
        catch (SAXException sAXException) {
            if (sAXException.getMessage().equals("continue")) {
                this.requireWellFormed = false;
            }
            throw sAXException;
        }
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
        try {
            this.handler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(cArray, n, n2);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void setEscaping(boolean bl) {
        try {
            this.handler.processingInstruction(bl ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }
}

