/*  Copyright (c) MediaArea.net SARL. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license that can
 *  be found in the License.html file in the root of the source tree.
 */

//---------------------------------------------------------------------------
#include "ZenLib/Conf.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
namespace MediaInfoLib
{
//---------------------------------------------------------------------------

//***************************************************************************
// Info
//***************************************************************************

//---------------------------------------------------------------------------
struct lang_map {
    const char* From;
    const char* To;
};
lang_map Pac_LangMap[] = {
    { "bgr", "bul"},
    { "cro", "hrv"},
    { "dnk", "dan"},
    { "esp", "spa"},
    { "grk", "ell"},
    { "huh", "hun"},
    { "poh", "pol"},
    { "prt", "por"},
    { "rom", "ron"},
    { "scg", "srp"},
    { "sle", "slv"},
    { "vnm", "vie"},
};

//---------------------------------------------------------------------------
struct metadata_map {
    const Char Separator;
    const Char* Lang;
};
metadata_map Pac_MetadataMap[] = {
    { __T(':'), __T("LANG")},
    { __T('\x25'), __T("\xB7\x41\xB9\xB0")},
};
size_t Pac_MetadataMap_Size = sizeof(Pac_MetadataMap) / sizeof(*Pac_MetadataMap);

//---------------------------------------------------------------------------
const int16u Pac_Cyrillic[] = {
    0,      // ' ',
    '!',
    0,      // 0x042D,
    '/',
    '?',
    ':',
    '.',
    0,      // 0x044D,
    '(',
    ')',
    0,
    '+',
    0,      // 0x0431,
    '-',
    0,      // 0x044E,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,      // 0x0416,
    0,      // 0x0436,
    '<',
    '=',
    '>',
    0,
    0,
    'A',    // Not sure
    0,      // 0x0418,
    0,      // 0x0421,
    0,      // 0x0412,
    0,      // 0x0423,
    'F',    // Note sure
    0,      // 0x041F,
    0,      // 0x0420,
    0,      // 0x0428,
    0,      // 0x041E,
    0,      // 0x041B,
    0,      // 0x0414,
    0,      // 0x042C,
    0,      // 0x0422,
    'O',    // Not sure
    0,      // 0x0417,
    'Q',    // Not sure
    0,      // 0x041A,
    0,      // 0x042B,
    0,      // 0x0415,
    0,      // 0x0413,
    0,      // 0x041C,
    0,      // 0x0426,
    0,      // 0x0427,
    0,      // 0x041D,
    0,      // 0x042F,
    0,      // 0x0445,
    0,
    0,      // 0x044A,
    ',',
    '-',
    0,
    0,      // 0x0444,
    0,      // 0x0438,
    0,      // 0x0441,
    0,      // 0x0432,
    0,      // 0x0443,
    0,      // 0x0430,
    0,      // 0x043F,
    0,      // 0x0440,
    0,      // 0x0448,
    0,      // 0x043E,
    0,      // 0x043B,
    0,      // 0x0434,
    0,      // 0x044C,
    0,      // 0x0442,
    0,      // 0x0449,
    0,      // 0x0437,
    0,
    0,      // 0x043A,
    0,      // 0x044B,
    0,      // 0x0435,
    0,      // 0x0433,
    0,      // 0x043C,
    0,      // 0x0446,
    0,      // 0x0447,
    0,      // 0x043D,
    0,      // 0x044F,
    0,      // 0x0425,
    0,
    0,      // 0x042A,
    0,
    0,
    0,      // 0x0411,
    0,      // 0x042E,
    0,      // 0x0402,
    0,      // 0x0403,
    0,      // 0x0404,
    0,      // 0x0405,
    0,      // 0x0406,
    0,      // 0x0407,
    0,      // 0x0408,
    0,      // 0x0409,
    0,      // 0x040A,
    0,      // 0x040B,
    0,      // 0x0490,
    0,      // 0x0491,
    0,
    0,      // 0x040F,
    0,      // 0x2116,
    0,
    0,      // 0x0452,
    0,      // 0x0453,
    0,      // 0x0454,
    0,      // 0x0455,
    0,      // 0x0456,
    0,      // 0x0457,
    0,      // 0x0458,
    0,      // 0x0459,
    0,      // 0x045A,
    0,
    0,      // 0x045B,
    0,
    0,      // 0xA7,
    0,
    0,      // 0x045F,
    0,
    0,
    '%',
    0,
    '&',
    0,
    0,
    0,
    0,
    0,
    0,
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    '\'',
    '"',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    '*',
    'W',
    'X',
    'Y',
    'Z',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    0,      // 0x2014,
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    0,      // 0x044D,
    0,      // 0x044E,
    'z',
};
const size_t Pac_Cyrillic_Size = sizeof(Pac_Cyrillic) / sizeof(*Pac_Cyrillic);

//---------------------------------------------------------------------------
const int16u Pac_Greek[] = {
    ' ',
    '!',
    '"',
    0,      // 0xA3,
    '$',
    '%',
    '&',
    0,
    '(',
    ')',
    '*',
    '+',
    0,
    '-',
    '.',
    '/',
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    ':',
    ';',
    '<',
    '=',
    '>',
    '?',
    '@',
    0,      // 0x0391,
    0,      // 0x0392,
    0,      // 0x0393,
    0,      // 0x0394,
    0,      // 0x0395,
    0,      // 0x0396,
    0,      // 0x0397,
    0,      // 0x0398,
    0,      // 0x0399,
    0,      // 0x039A,
    0,      // 0x039B,
    0,      // 0x039C,
    0,      // 0x039D,
    0,      // 0x039E,
    0,      // 0x039F,
    0,      // 0x03A0,
    0,      // 0x03A1,
    0,      // 0x03A2,
    0,      // 0x03A3,
    0,      // 0x03A4,
    0,      // 0x03A5,
    0,      // 0x03A6,
    0,      // 0x03A7,
    0,      // 0x03A8,
    0,      // 0x03A9,
    0,
    0,
    0,
    0,
    0,
    '-',
    0,
    0,      // 0x03B1,
    0,      // 0x03B2,
    0,      // 0x03B3,
    0,      // 0x03B4,
    0,      // 0x03B5,
    0,      // 0x03B6,
    0,      // 0x03B7,
    0,      // 0x03B8,
    0,      // 0x03B9,
    0,      // 0x03BA,
    0,      // 0x03BB,
    0,      // 0x03BC,
    0,      // 0x03BD,
    0,      // 0x03BE,
    0,      // 0x03BF,
    0,      // 0x03C0,
    0,      // 0x03C1,
    0,      // 0x03C2,
    0,      // 0x03C3,
    0,      // 0x03C4,
    0,      // 0x03C5,
    0,      // 0x03C6,
    0,      // 0x03C7,
    0,      // 0x03C8,
    0,      // 0x03C9,
    0,
    0,
    0,
    0,
    0,      // 0xA7,
    0,
    '#',
    0,      // 0xDF,
    0,      // 0xB2,
    0,      // 0xB3,
    0,      // 0xAB,
    0,      // 0xBB,
    0,      // 0xB1,
    0,      // 0xFE,
    0,      // 0xDE,
    0,      // 0xF0,
    0,
    0,
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z',
    0,
    0,
    0,
    0,      // 0xB0,
    0,
    0,      // 0xBD,
    'a',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    'x',
    'y',
    'z',
};
const size_t Pac_Greek_Size = sizeof(Pac_Greek) / sizeof(*Pac_Greek);

//---------------------------------------------------------------------------
struct codepage {
    const int16u* List;
    const size_t  Size;
    const char* const Name;
};
codepage Pac_CodePages[] = {
    {Pac_Cyrillic, Pac_Cyrillic_Size, "RUS"},
    {Pac_Greek, Pac_Greek_Size, "GRK"},
};
const size_t Pac_CodePages_Size = sizeof(Pac_CodePages) / sizeof(*Pac_CodePages);

//***************************************************************************
// C++
//***************************************************************************

} //NameSpace
