-- Test pile/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2,3/2,3/2,3/2,3/2,3/2,3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2,3/2,3/2,3/2,3/2,3/2,3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2,3/2,3/2,3/2,3/2,3/2,3/2},{-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2},{19/18,11/18,7/18,7/18,11/18,19/18,5/6,7/18,1/6,1/6,7/18,5/6,5/6,7/18,1/6,1/6,7/18,5/6,19/18,11/18,7/18,7/18,11/18,19/18,17/18,1/2,5/18,5/18,1/2,17/18,13/18,5/18,1/18,1/18,5/18,13/18,13/18,5/18,1/18,1/18,5/18,13/18,17/18,1/2,5/18,5/18,1/2,17/18,19/18,11/18,7/18,7/18,11/18,19/18,5/6,7/18,1/6,1/6,7/18,5/6,5/6,7/18,1/6,1/6,7/18,5/6,19/18,11/18,7/18,7/18,11/18,19/18}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1},{-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2},{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test face_lattice/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///


-- Test rel_int_point_cdd/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,1,0,0,1},{0,1,0,0,1,0},{1,0,0,1,0,0},{1,0,0,0,1,0},{0,0,0,1,0,1},{0,1,1,0,0,0},{0,1,0,1,0,0},{1,0,1,0,0,0},{0,0,0,0,1,1}};
desiredLP = matrix {{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0},{0,1,0,1,0,0},{1,0,0,0,0,1},{0,0,1,0,1,0},{1,0,1,0,0,0},{0,1,0,0,1,0},{0,0,0,1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test rel_int_point_cdd/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,1,0,0,1},{0,1,0,0,1,0},{1,0,0,1,0,0},{1,0,0,0,1,0},{0,0,0,1,0,1},{0,1,1,0,0,0},{0,1,0,1,0,0},{1,0,1,0,0,0},{0,0,0,0,1,1}};
desiredLP = matrix {{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0},{0,1,0,1,0,0},{1,0,0,0,0,1},{0,0,1,0,1,0},{1,0,1,0,0,0},{0,1,0,0,1,0},{0,0,0,1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test rel_int_point_cdd/4.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,1,0,0,1},{0,1,0,0,1,0},{1,0,0,1,0,0},{1,0,0,0,1,0},{0,0,0,1,0,1},{0,1,1,0,0,0},{0,1,0,1,0,0},{1,0,1,0,0,0},{0,0,0,0,1,1}};
desiredLP = matrix {{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0},{0,1,0,1,0,0},{1,0,0,0,0,1},{0,0,1,0,1,0},{1,0,1,0,0,0},{0,1,0,0,1,0},{0,0,0,1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test rel_int_point_cdd/3.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,1,0,0,1},{0,1,0,0,1,0},{1,0,0,1,0,0},{1,0,0,0,1,0},{0,0,0,1,0,1},{0,1,1,0,0,0},{0,1,0,1,0,0},{1,0,1,0,0,0},{0,0,0,0,1,1}};
desiredLP = matrix {{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0},{0,1,0,1,0,0},{1,0,0,0,0,1},{0,0,1,0,1,0},{1,0,1,0,0,0},{0,1,0,0,1,0},{0,0,0,1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///


-- Test TRIANGULATION_BOUNDARY/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test GALE/3.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test polyhedronFromHData/2-B.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test schlegel_transform/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test unirand/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-141107669636816/852499196892797,242204629003591/1107058290551282,44630442426268/257869071754123,59636831020547/819949493021808,190042602361641/732329581405274,77396499850483/592700394783092,129995915951581/386944372487040,6415357351317/86347832010262,152636081600261/792653602968322,124533588363182/845227810158513,-179333736783140/726690094215533,-175871070841811/946605133928333,-235983331587437/1051060227737314,-30781402590618/170840293363175,13428705700065/117005868283588,-250750931109671/839831780157461,199584473593991/648703017812436,84675642060140/796045561284077,-7840544963498/798611994829517,-144029025488557/539256313403543,-123147573126275/651924197036766,-104880674664035/661705399130448,39936676325872/931663354197177,-36516458869741/248134104104504,-114930606804473/619214483797836,32019259648079/730651758274049,-78205360464697/665649325096871,127994385490649/644260544936409,-97401627023455/390462501434113,223135133747833/898540741029911,-280144054234336/869997165696847,-242101447001546/506903457637433,39524632270770/563476664205757,-2675239748492/52224709301583},{-17212653813406/852499196892797,-20592069376333/553529145275641,-59967548241431/257869071754123,12012331978873/136658248836968,105411074365785/732329581405274,25205210974013/296350197391546,241987746737/16122682186960,-74261323897411/345391328041048,-58197415963312/396326801484161,37634649409996/845227810158513,176859170622062/726690094215533,170950390156010/946605133928333,-718811371226/525530113868657,25317875501163/683361173452700,12941859272209/468023473134352,30504945826574/839831780157461,-21058147025467/216234339270812,103587714824030/796045561284077,47283524903465/798611994829517,-95954628662133/539256313403543,26950725359311/325962098518383,-56713048958521/220568466376816,-2923878293687/931663354197177,31151225696801/248134104104504,-16863640757863/619214483797836,-153877127603299/730651758274049,201918514904464/665649325096871,-33438069709349/214753514978803,-2284358790857/390462501434113,-124227309021370/898540741029911,-155707328185941/869997165696847,137503900086458/506903457637433,9424707550377/563476664205757,-19076199383996/52224709301583},{36687461546604/852499196892797,141712696303345/1107058290551282,144293060365252/773607215262369,139848622502533/409974746510904,116243425674202/366164790702637,-135895991459319/296350197391546,15186640681011/128981457495680,34424519005823/172695664020524,59780189246667/396326801484161,-236987386080358/845227810158513,69269223394307/726690094215533,-222669213562825/946605133928333,-187585134227057/1051060227737314,62883127877829/341680586726350,-242932492938393/468023473134352,11582399709950/64602444627497,-17406994771836/54058584817703,-100325004149251/796045561284077,85915351715793/798611994829517,-39821943224486/539256313403543,107890743035485/325962098518383,25526499553279/165426349782612,-257414757684842/931663354197177,174971550708915/496268208209008,-105424492315163/619214483797836,-243463708308996/730651758274049,165234880889607/665649325096871,-28777686036253/214753514978803,278106977377713/780925002868226,29778400787664/128362963004273,-145967002618518/869997165696847,47775724887295/506903457637433,105950876817945/563476664205757,-3520718743567/44764036544214},{-209332956306847/852499196892797,-125100211857919/553529145275641,-210166785692498/773607215262369,12080446976163/273316497673936,-43648456549485/366164790702637,11595656960537/592700394783092,-14723104640533/193472186243520,23135793505241/86347832010262,138828518805721/792653602968322,-195118737654863/845227810158513,-121381178341474/726690094215533,233750289738925/946605133928333,-38296717266885/525530113868657,244150052984781/683361173452700,-5650805508839/58502934141794,-12345636517252/64602444627497,22440287478693/108117169635406,-156667595359458/796045561284077,-205625173411703/798611994829517,-105062021913097/539256313403543,-1275460892347/651924197036766,-21537510636667/165426349782612,-278919045887222/931663354197177,-106409434888547/496268208209008,-162141321164273/619214483797836,-176491005909273/730651758274049,-142759524570675/665649325096871,-42146662825256/214753514978803,-122436997511345/780925002868226,-228182104853282/898540741029911,180541496197356/869997165696847,67367763533538/506903457637433,281077018078255/563476664205757,-7069601768717/24103711985346}};
desiredLP = matrix {{0},{0},{0},{0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test unirand/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-70553834818408/321583120292975,-65041243453808/704784466955939,253774218055484/861277886511155,141712696303345/687155318502663,77526447775018/205060441795105,-258224033970472/760312662001261,190042602361641/645032668306304,58758250451871/534718127350102,-4140004316292/16617751384265,-59762842142214/113557570177715,45376458276352/273431998497845,-93875015566524/256948456535459,6415357351317/63212038505021,802849150513/60165594224876,138828518805721/642065767772423,-118493693040179/395318490729174,-1634970773405/7370603268746,-80877491656797/256911354362174,125274940162378/638534508150441,264271870111863/1051153529088350,15318686906754/70376476366309,62883127877829/332297701143427,-56613927026389/540529897243633,154260661960369/589080849047790,-199584473593991/514061292940278,-115725428345677/385251909233361,-156667595359458/639239300457749,217285353475376/426200527174267,-225973699917529/792573907676860,77194347057635/395227287914986,-123147573126275/650648736144419,197551219571435/671000577942099,-86150042546668/537429548519097,128707378842421/404392844307369,-39775926739231/595105156754916,109927211378032/504283876993363,32019259648079/554160752364776,209954867643863/567609787280452,-5710380982827/17488859230798,-89102468638626/596888044355651},{-112039613897281/321583120292975,-167243039815593/704784466955939,-149420838064159/861277886511155,-250200423715838/687155318502663,-144293060365252/615181325385315,-186150042097234/760312662001261,81978572240511/322516334153152,146206466821547/534718127350102,13632567363443/113000709413002,3316684173813/45423028071086,135895991459319/273431998497845,-88067309644836/256948456535459,84076362705759/505696308040168,-21805154514323/77355764003412,-215592286868467/642065767772423,-195118737654863/790636981458348,-69269223394307/405383179781030,71682084814381/770734063086522,-201434060641948/638534508150441,235983331587437/1051153529088350,-44344772009827/351882381831545,244150052984781/664595402286854,-242932492938393/540529897243633,-24751143226759/117816169809558,21209220503927/514061292940278,-42337821030070/385251909233361,92763024586519/639239300457749,17637754560562/426200527174267,-85915351715793/792573907676860,86574487859884/197613643957493,-182810563832898/650648736144419,104880674664035/671000577942099,78369443881260/179143182839699,-139459522943611/404392844307369,58323850236305/198368385584972,-126790852135895/504283876993363,62400328402201/554160752364776,-78205360464697/567609787280452,76091176659127/218610740384975,-134863094380837/596888044355651},{120645940803984/321583120292975,268628163629472/704784466955939,242204629003591/861277886511155,-53783623734892/229051772834221,210166785692498/615181325385315,279697245005066/760312662001261,58546070115237/645032668306304,-147951778645197/534718127350102,-53712337127274/282501773532505,104615570553391/454230280710860,11595656960537/546863996995690,-45559922043033/256948456535459,232599010500581/505696308040168,18945270867313/77355764003412,-124533588363182/642065767772423,-179197120939987/790636981458348,-60690589170737/202691589890515,222669213562825/770734063086522,-260780315467757/638534508150441,-274730352323299/1051153529088350,123125610362472/351882381831545,-240964270746155/664595402286854,45206444070712/540529897243633,-15057119622935/58908084904779,-42191830790164/257030646470139,-278982517269629/770503818466722,-132133150278052/639239300457749,-183436874174831/426200527174267,-205625173411703/792573907676860,19910971612243/197613643957493,128909113114276/650648736144419,99214768415533/671000577942099,-39936676325872/537429548519097,33236494550532/134797614769123,-106409434888547/595105156754916,-105424492315163/504283876993363,-54069364001375/138540188091194,120342018519089/283804893640226,466878432441/437221480769950,244928095845539/596888044355651},{-18343730773302/321583120292975,-203872020057066/704784466955939,-215878201387921/861277886511155,-44630442426268/229051772834221,9380712000837/205060441795105,36241340928489/760312662001261,-58121712837101/161258167076576,181801631431487/534718127350102,248655889239319/565003547065010,-77396499850483/454230280710860,-172723440563811/546863996995690,29446209281066/256948456535459,34424519005823/126424077010042,-27667969777535/60165594224876,163111373735053/642065767772423,44833434195785/197659245364587,-62404692753987/202691589890515,-233750289738925/770734063086522,51045191878358/638534508150441,276167975065751/1051153529088350,-107818564925476/351882381831545,26857411400130/332297701143427,11516296071067/31795876308449,-80246637362138/294540424523895,34813989543672/85676882156713,58464934148533/256834606155574,257675530233720/639239300457749,-7840544963498/426200527174267,-55011936526367/158514781535372,-105062021913097/395227287914986,-215781486070970/650648736144419,269353915291096/671000577942099,176234498002777/537429548519097,-36516458869741/404392844307369,91316081472741/198368385584972,162141321164273/504283876993363,-60865927077249/138540188091194,-19382761066857/283804893640226,-14181272444858/43722148076995,-127994385490649/596888044355651}};
desiredLP = matrix {{0},{0},{0},{0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test unirand/1-in.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test unirand/2-in.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test 2-face-sizes-simple/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{5/8,-5/8,0,0,0,0,0,0},{0,0,5/8,-5/8,0,0,0,0},{0,0,0,0,5/8,-5/8,0,0},{0,0,0,0,0,0,5/8,-5/8}};
desiredLP = matrix {{0},{0},{0},{0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test max_GC_rank/B4.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1/2,0,0,1/2,1/2,0,1/2,1/2,1,1,1,1,1,1,1/2,1/2,1/2,1/2,1/2,1/2,1/2,0,0,0},{0,0,1/2,1/2,0,1/2,0,1/2,1/2,0,1/2,1/2,1,1/2,1,1/2,0,1/2,1,1,1,1/2,1,1/2},{0,1/2,0,0,1/2,1/2,1/2,1,1/2,1/2,0,1/2,1/2,1,1/2,1,1,0,1,1/2,0,1/2,1/2,1},{1/2,1/2,1/2,0,0,0,1,0,1,1/2,1/2,0,1/2,1/2,1,1,1/2,1,1/2,0,1/2,1,1/2,1/2}};
desiredLP = matrix {{}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test volume/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test volume/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test volume/3.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},{1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0},{1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0},{0,1,0,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,0,1},{0,0,1,0,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1},{0,0,0,1,0,0,1,0,1,1,0,0,1,0,1,1,0,1,1,1}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test rand_vert/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,1,1,0,0,1,0,1,1,0,0,1,0,0,0,1,0,1,1},{1,0,0,0,0,1,0,1,0,1,1,0,0,1,0,1,1,0,1,1},{0,1,1,0,1,1,0,0,1,1,0,1,1,1,0,0,1,0,0,1},{0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1},{0,0,1,1,1,0,0,0,0,1,1,0,0,1,1,1,0,1,1,1},{1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1},{0,1,0,0,1,0,0,0,1,0,1,1,1,0,0,1,1,0,1,1},{1,1,0,1,0,0,1,1,0,1,0,0,0,0,1,0,1,1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test rand_vert/1-in.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1},{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test wythoff/24-cell.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,0,0,0,0,1,-1,1,0,1,0,1,0,-1,-1,0,-1,1,-1,0,0,0,0,-1},{0,1,0,0,-1,1,0,0,1,0,1,-1,-1,1,0,-1,0,0,-1,1,0,0,-1,0},{0,0,1,-1,0,0,0,1,1,-1,-1,0,1,0,1,-1,-1,0,0,0,1,-1,0,0},{-1,-1,-1,-1,-1,0,-1,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1},{-1,0,0,0,0,0,1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0,-1,0,0,0,1,-1,-1,-1,0,0,0,1,1,1,-1,0,0,0,1,0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0,0,-1,0,1,0,-1,0,1,-1,0,1,-1,0,1,0,-1,0,1,0,0,0,-1,0,1,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test wythoff/7.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{2,1,2,1,0,2,0,1,0,2,3,0,1,3,0,1,-1,3,0,2,-2,3,-1,0,1,0,3,-2,0,2,0,3,-1,0,3,1,0,3,-2,0,3,2,0,3,-1,2,0,3,1,0,-1,-2,1,0,3,2,0,-2,2,2,0,3,-3,-1,0,1,1,0,3,-3,-2,0,2,2,-3,0,-1,3,-1,3,1,1,-3,0,-2,3,-2,3,2,-1,2,-3,3,-1,-1,2,1,-2,1,-3,3,-2,-2,1,-3,2,-1,3,-3,0,-1,2,-3,1,-2,3,-3,0,-2,1,-3,3,-1,0,0,-1,2,-3,3,-2,0,0,-2,1,-3,-2,-1,0,0,2,2,-3,-1,-2,0,0,1,1,-3,-2,2,0,0,-3,-3,-1,1,0,0,-3,0,-2,2,0,-3,0,-1,1,0,-3,0,-2,2,-3,0,-1,1,-3,0,-3,-1,0,-3,-2,-1,0,-2,0,-1,-2,-1,-2},{1,2,0,0,2,0,1,0,2,-1,1,1,-2,2,-1,3,2,0,-2,3,1,0,0,-1,0,3,0,0,-2,0,3,0,0,1,2,0,3,-1,0,2,1,0,3,-2,-2,3,1,2,-3,-1,3,-1,3,2,1,-3,-2,3,1,3,-3,-1,1,0,-1,2,3,-3,-2,2,0,-2,1,-1,0,-3,3,-1,0,2,2,-2,0,-3,3,-2,0,1,-3,2,-1,0,0,3,-3,3,-3,1,-2,0,0,3,-3,3,2,-3,2,0,-1,3,-2,0,1,-3,1,0,-2,3,-1,0,2,-2,-3,3,2,-2,0,1,-1,-3,3,1,-1,0,-1,3,-3,-2,2,1,-3,-2,3,-3,-1,1,2,-3,-1,0,0,-2,-3,2,-2,0,0,-1,-3,1,2,0,0,-3,0,1,0,0,-3,0,2,-3,-1,0,1,-3,-2,0,-1,-2,2,-2,-1,1,0,-1,0,-2,0,0,-2,-1},{0,0,1,2,1,-1,2,-2,-1,0,0,-2,0,0,2,0,0,1,1,0,0,2,2,-2,3,1,-1,1,-1,3,2,-2,-2,3,1,-3,-1,0,-1,3,2,-3,-2,0,0,1,-3,-1,0,3,0,0,2,-3,-2,0,3,0,3,-1,1,2,0,3,-3,3,-2,2,1,0,3,-3,-3,3,1,-1,2,-2,-3,0,-3,3,2,-2,1,-1,-3,0,1,3,-3,-1,2,-2,0,0,2,3,-3,-2,1,-1,0,0,1,-1,-3,-2,0,2,3,3,2,-2,-3,-1,0,1,3,3,-1,0,2,-2,3,-3,-3,-2,0,1,-1,3,-3,-3,2,0,-2,3,-3,0,0,1,0,-1,3,-3,0,0,-2,3,1,-3,2,0,-1,3,2,-3,1,0,1,-3,-1,-2,2,2,-3,-2,-1,1,-1,0,0,-2,-2,0,0,-1,2,0,0,1,0,0,2,-2,1,-1,-2,-1,0,0},{-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-3,-3,-1,-3,-2,-3,-2,-3,-1,-3,-1,-3,-3,-2,-2,-2,-3,-3,-1,-1,-1,-3,-2,0,-2,-2,-2,-3,-1,0,-1,-1,-1,-3,0,-2,0,-2,-2,-2,-3,0,-1,0,-1,-1,-1,0,0,-2,0,-2,-2,-2,0,0,-1,0,-1,-1,-1,0,0,-2,-2,0,0,-2,1,0,0,-1,-1,0,0,-1,2,0,0,0,-2,1,0,-2,1,0,0,0,-1,2,0,-1,2,0,0,0,1,-2,1,0,1,0,0,0,2,-1,2,0,2,0,1,0,1,1,0,1,0,2,0,2,2,0,2,0,1,0,1,1,3,1,0,2,0,2,2,3,2,0,1,3,1,1,1,0,2,3,2,2,2,3,1,3,1,1,3,2,3,2,2,3,1,3,1,3,2,3,2,3,1,3,3,2,3,3,3,3,3,3,3,3,3}};
desiredLP = matrix {{-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2},{-1,0,0,0,1,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-1,0,0,0,1,-1,0,0,0,1,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-1,0,0,0,1,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-1,0,0,0,1,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-1,0,0,0,1,-1,0,0,0,1,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,-2,-1,-1,-1,0,0,0,0,0,1,1,1,2,-1,0,0,0,1},{0,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,0,0,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-1,0,1,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-1,0,1,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,0,0,-1,0,1,0,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-1,0,1,0,-1,0,1,-2,-1,0,1,2,-1,0,1,0,0,-1,0,1,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test N_FLAGS/4.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,1,0,0,0,0,1,1,1/2},{0,0,1,0,0,1,0,1,1/2},{0,0,0,1,0,1,1,0,1/2},{0,0,0,0,1,1,1,1,3/2}};
desiredLP = matrix {{0,0,0,0,0,1,1,1},{0,0,0,1,1,0,0,1},{0,0,1,0,1,0,1,0},{0,1,0,0,1,0,1,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test N_FLAGS/3.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,1,0,0,0,0,1,1,1/2,7/18},{0,0,1,0,0,1,0,1,1/2,7/18},{0,0,0,1,0,1,1,0,1/2,7/18},{0,0,0,0,1,1,1,1,3/2,11/18},{0,0,0,0,0,0,0,0,0,1}};
desiredLP = matrix {{0,0,0,0,0,1,1,1},{0,0,0,1,1,0,0,1},{0,0,1,0,1,0,1,0},{0,1,0,0,1,0,1,1},{0,0,0,0,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test N_FLAGS/5.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,1,0,0,0,0,0,0,0},{0,0,1,0,0,0,0,0,0},{0,0,0,1,0,0,0,0,0},{0,0,0,0,1,0,0,0,0},{0,0,0,0,0,1,0,0,0},{0,0,0,0,0,0,1,0,0},{0,0,0,0,0,0,0,1,0},{0,0,0,0,0,0,0,0,1}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,1},{0,0,0,0,0,0,0,1,0},{0,0,0,0,0,0,1,0,0},{0,0,0,0,0,1,0,0,0},{0,0,0,0,1,0,0,0,0},{0,0,0,1,0,0,0,0,0},{0,0,1,0,0,0,0,0,0},{0,1,0,0,0,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test N_FLAGS/6.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{23317/31250,-366203/1000000,177109/10000000,-306739/500000,208329/500000,29961/50000,-86293/500000,92747/500000,436199/1000000,213659/1000000,-445439/5000000,691657/10000000,305543/1000000,-483077/5000000},{44199/200000,-139403/1000000,-525737/10000000,-187543/2500000,380641/5000000,155533/10000000,-160979/2500000,60593/200000,281319/500000,-371801/1000000,288947/500000,-268571/5000000,-874143/10000000,-217887/1000000},{-346057/1000000,17637/31250,853023/10000000,39983/200000,-216667/5000000,20007/200000,-418873/10000000,112651/1000000,-11661/312500,414149/10000000,-205449/1000000,19989/200000,1083/10000,380389/1000000},{-131053/500000,-664937/1000000,120661/2500000,300961/5000000,-177507/1000000,323613/1000000,-111641/1000000,29173/200000,-5581/40000,44977/100000,-421899/1000000,-362799/10000000,182637/1000000,-899/4000},{-32179/125000,-281981/10000000,-59539/125000,19623/50000,179437/2500000,410753/10000000,-356231/100000000,93847/250000,244547/5000000,79077/1250000,-32047/250000,336007/1000000,95957/2000000,-212221/500000},{250339/1000000,-78211/500000,-102359/250000,38379/1250000,102139/5000000,408221/1000000,682889/1000000,-68861/125000,51789/1000000,-22297/200000,-250669/1000000,67621/250000,-415701/1000000,265077/500000},{-21889/200000,-6081/312500,383361/500000,-250527/1000000,749097/10000000,-46797/125000,160343/1000000,92671/250000,-908099/100000000,-185253/500000,310239/1000000,2617/20000,136769/500000,131663/1000000},{3983/15625,20249/100000,-195731/5000000,-220223/500000,-58871/100000,837/2000,91527/250000,289861/1000000,-113093/1000000,18537/100000,60743/125000,724323/1000000,78459/500000,-860287/10000000},{-168117/100000000,-240257/2500000,-17967/312500,386299/1000000,-205609/500000,-194651/2000000,131463/1000000,-97873/5000000,-30427/62500,246957/1000000,-552269/10000000,54849/500000,-451099/1000000,-70611/200000},{853709/100000000,-497801/5000000,102639/10000000,116089/1000000,-510249/1000000,-181267/1000000,-277701/500000,208347/500000,93243/200000,-602537/1000000,152277/1000000,-98217/200000,613083/1000000,-74131/200000}};
desiredLP = matrix {{}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test blending/1-inA.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///
-- Test CD_INDEX_COEFFICIENTS/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,1,0,0,0,0,0,0},{0,0,1,0,0,0,0,0},{0,0,0,1,0,0,0,0},{0,0,0,0,1,0,0,0},{0,0,0,0,0,1,0,0},{0,0,0,0,0,0,1,0},{0,0,0,0,0,0,0,1}};
desiredLP = matrix {{0,0,0,0,0,0,0,1},{0,0,0,0,0,0,1,0},{0,0,0,0,0,1,0,0},{0,0,0,0,1,0,0,0},{0,0,0,1,0,0,0,0},{0,0,1,0,0,0,0,0},{0,1,0,0,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test cross/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test cross/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{5/8,-5/8,0,0,0,0,0,0},{0,0,5/8,-5/8,0,0,0,0},{0,0,0,0,5/8,-5/8,0,0},{0,0,0,0,0,0,5/8,-5/8}};
desiredLP = matrix {{0},{0},{0},{0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test cross/1wG.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test facet/1-in.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test facet/2-in.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test COCUBICALITY/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0,0,0,0,0},{0,0,0,0,1,-1,0,0,0,0,0,0},{0,0,0,0,0,0,1,-1,0,0,0,0},{0,0,0,0,0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,0,0,0,0,1,0},{0,0,-1,0,0,0,0,0,0,0,1,0,0},{0,0,0,-1,0,0,0,0,0,1,0,0,0},{0,0,0,0,-1,0,0,0,1,0,0,0,0},{0,0,0,0,0,-1,0,1,0,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test h_vector/3.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,1,0,0,1,0},{0,0,1,0,0,1},{0,0,0,1,1,1},{0,0,0,0,0,0}};
desiredLP = matrix {{0,0,0,0,1,1},{0,0,1,1,0,0},{0,1,0,1,0,1},{0,0,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test BOUNDED/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredLP = matrix {{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test 4ti2/groeb2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,0,0,1,0,0},{0,1,0,0,1,0},{0,0,1,0,0,1},{0,1,1,0,0,0},{1,0,0,0,0,1},{0,0,0,1,1,0},{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0}};
desiredLP = matrix {{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0},{0,1,0,1,0,0},{1,0,0,0,0,1},{0,0,1,0,1,0},{1,0,1,0,0,0},{0,1,0,0,1,0},{0,0,0,1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test 4ti2/sparse.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,0,0,0,0,0},{0,1,0,0,0,0},{0,0,1,0,0,0},{0,0,0,1,0,0},{0,0,0,0,1,0}};
desiredLP = matrix {{0,1,0,0,0,0},{0,0,1,0,0,0},{0,0,0,1,0,0},{0,0,0,0,1,0},{0,0,0,0,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test SCHLEGEL_MIN_MAX_FACE/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredLP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test cell_from_subdivision/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1},{0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0},{0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0},{1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0,1},{1,1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0},{1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1},{0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0},{0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0},{1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0,1},{1,1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0},{1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test cell_from_subdivision/2.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,1,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,1,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test cell_from_subdivision/1-in.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test cyclic_caratheodory/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,1216652631687587/2251799813685248,-7496634952020485/18014398509481984,-4458529838789353/4503599627370496,-5887498334708929/9007199254740992,5110003651005145/18014398509481984,8648445090341621/9007199254740992,6790547823468567/9007199254740992,-1310547796085733/9007199254740992,-8206731815819627/9007199254740992},{0,3789648413623927/4503599627370496,4095111552621091/4503599627370496,5084384125703515/36028797018963968,-3408335435861847/4503599627370496,-8637222012098867/9007199254740992,-78648470848139/281474976710656,739701150294337/1125899906842624,8911346861657979/9007199254740992,7424066626269073/18014398509481984},{1,-7496634952020485/18014398509481984,-5887498334708929/9007199254740992,8648445090341621/9007199254740992,-1310547796085733/9007199254740992,-7557684451371807/9007199254740992,7600760748205539/9007199254740992,4926477479747821/36028797018963968,-2156457439366109/2251799813685248,371725260149319/562949953421312},{0,4095111552621091/4503599627370496,-3408335435861847/4503599627370496,-78648470848139/281474976710656,8911346861657979/9007199254740992,-2450053272283049/4503599627370496,-4833019187127717/9007199254740992,8922597835955781/9007199254740992,-648300634825759/2251799813685248,-3382145884720915/4503599627370496}};
desiredLP = matrix {{0,1},{0,0},{0,1},{0,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

-- Test rand01/1.poly
-- Checking latticePoints
TEST ///
verticesP = matrix {{1,0,0,1,0,1,1,0,0,1,0,1,0,1,1,0,1,0,1,0},{1,0,1,1,0,0,1,0,1,1,0,0,1,1,0,1,1,0,0,1},{1,0,0,0,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1},{0,1,0,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0},{1,1,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1}};
desiredLP = matrix {{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1},{0,0,1,1,1,0,0,0,1,1,0,1,1,1,0,0,0,1,1,1},{1,1,0,1,1,0,0,1,0,1,0,0,0,1,0,1,1,0,0,1},{0,1,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0}};
desiredLP = sort desiredLP;
P = convexHull(verticesP)
computedLP = sort matrix {latticePoints P};
assert(desiredLP == computedLP);
///

