simpleDocFrob = method(Options => {Limit => 0})
simpleDocFrob(ZZ, Matrix) := o -> (n, M) -> directSum(n:M)

docExample = "doc ///
  Key
     simpleDocFrob
    (simpleDocFrob, ZZ, Matrix)
    [simpleDocFrob, Limit]
  Headline
    a sample documentation node
  Usage
    x = simpleDocFrob(n,M)
  Inputs
    n:ZZ         -- positive
    M:Matrix     -- which is square
    Limit => ZZ  -- as an @TO Option@
     multiline descriptions
     are sometimes useful
  Outputs
    x:Matrix
      A block diagonal matrix with {\\tt n}
      copies of {\\tt M} along the diagonal
  Consequences
   Item
    The first side effect of the function, if any, is described here.
   Item
    The second side effect of the function is described here, and so on.
  Description
   Text
     Each paragraph of text begins with \"Text\".  The following
     line starts a sequence of Macaulay2 example input lines.

     The output in the following example was automatically generated at the time
     of package installation.
   Example
     M = matrix\"1,2;3,4\";
     simpleDocFrob(3,M)
   Text
     @SUBSECTION \"A new section\"@

     The following example was generated by the documentation author.
   CannedExample
      i1 : 4+
           4

      o1 = 8

      i1000 : 2+2

      o1000 = 4
   Text
     See @ TO \"docExample\" @ for the code used to create this documentation.

  Synopsis
   Heading
    a different way to use this method
   Usage
    simpleDocFrom_n M
   Inputs
    :ZZ
    :Matrix
   Outputs
    :Matrix
   Consequences
    Item
     There may be specific consequences.
   Description
    Text
     Paragraph specific to this usage.
     Itemized lists can be created with the \"Tree\" keyword:
    Tree
     :A heading
       \"Macaulay2Doc :: matrix(List)\"
       :A subheading containing @TT \"Hypertext\"@
         ZZ
	 Matrix
     :Another heading
       @TO2 {\"Macaulay2Doc :: matrix(List)\", \"A link with arbitrary headline\"}@.

  Acknowledgement
    Acknowledge funding sources or collaborators here.
  Contributors
    Acknowledge contributors who are not listed as authors here.
  References
    Provide references for further reading.
  Citation
    Here is how to cite this package.
  Caveat
    This is not a particularly useful function.
  SeeAlso
    matrix
    \"Macaulay2Doc :: directSum(List)\"
///"

testExample = "TEST /// -* test for simpleDocFrob *-
  assert(simpleDocFrob(2,matrix{{1,2}}) == matrix{{1,2,0,0},{0,0,1,2}})
///"
