
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file DotPolyShadingMethodAttributes.h
    \\brief Definition of DotPolyShadingMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "DotPolyShadingMethodWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



DotPolyShadingMethodWrapper::DotPolyShadingMethodWrapper(): dotpolyshadingmethod_(new DotPolyShadingMethod())


{


	
	PolyShadingMethodWrapper::object(dotpolyshadingmethod_);
	

}
DotPolyShadingMethodWrapper::DotPolyShadingMethodWrapper(DotPolyShadingMethod* dotpolyshadingmethod): dotpolyshadingmethod_(dotpolyshadingmethod)
{

	
	PolyShadingMethodWrapper::object(dotpolyshadingmethod_);
	
}

DotPolyShadingMethodWrapper::~DotPolyShadingMethodWrapper()
{

}

void DotPolyShadingMethodWrapper::set(const MagRequest& request)
{

	

	PolyShadingMethodWrapper::set(request);
	

	if  (request.countValues("CONTOUR_SHADE_DOT_SIZE") ) {
		double size_value = request("CONTOUR_SHADE_DOT_SIZE");
		dotpolyshadingmethod_->size_ = size_value;
		}
	if  (request.countValues("CONTOUR_SHADE_MAX_LEVEL_DENSITY") ) {
		double max_density_value = request("CONTOUR_SHADE_MAX_LEVEL_DENSITY");
		dotpolyshadingmethod_->max_density_ = max_density_value;
		}
	if  (request.countValues("CONTOUR_SHADE_MIN_LEVEL_DENSITY") ) {
		double min_density_value = request("CONTOUR_SHADE_MIN_LEVEL_DENSITY");
		dotpolyshadingmethod_->min_density_ = min_density_value;
		}
	
	
}

void DotPolyShadingMethodWrapper::print(ostream& out)  const
{
	out << "DotPolyShadingMethodWrapper[]";
}


