
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MarkerShadingTechniqueAttributes.h
    \\brief Definition of MarkerShadingTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MarkerShadingTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MarkerShadingTechniqueAttributes::MarkerShadingTechniqueAttributes():
	colour_(ParameterManager::getStringArray("contour_shade_colour_table")),
	height_(ParameterManager::getDoubleArray("contour_shade_height_table")),
	type_(ParameterManager::getString("contour_shade_marker_table_type")),
	marker_(ParameterManager::getIntArray("contour_shade_marker_table")),
	symbol_(ParameterManager::getStringArray("contour_shade_marker_name_table"))
	
	
{
}


MarkerShadingTechniqueAttributes::~MarkerShadingTechniqueAttributes()
{

}


void MarkerShadingTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	
	setAttribute(prefix, "contour_shade_colour_table", colour_, params);
	setAttribute(prefix, "contour_shade_height_table", height_, params);
	setAttribute(prefix, "contour_shade_marker_table_type", type_, params);
	setAttribute(prefix, "contour_shade_marker_table", marker_, params);
	setAttribute(prefix, "contour_shade_marker_name_table", symbol_, params);
	
	
}

void MarkerShadingTechniqueAttributes::copy(const MarkerShadingTechniqueAttributes& other)
{
	colour_ = other.colour_;
	height_ = other.height_;
	type_ = other.type_;
	marker_ = other.marker_;
	symbol_ = other.symbol_;
	
}


bool MarkerShadingTechniqueAttributes::accept(const string& node)
{

	if ( magCompare(node, "marker")  )
		return true;
	
	return false;
}

void MarkerShadingTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "marker")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void MarkerShadingTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " colour = " <<  colour_;
	out << " height = " <<  height_;
	out << " type = " <<  type_;
	out << " marker = " <<  marker_;
	out << " symbol = " <<  symbol_;
	
	out << "]" << "\n";
}

void MarkerShadingTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"marker\"";
	out << ", \"contour_shade_colour_table\":";
	niceprint(out,colour_);
	out << ", \"contour_shade_height_table\":";
	niceprint(out,height_);
	out << ", \"contour_shade_marker_table_type\":";
	niceprint(out,type_);
	out << ", \"contour_shade_marker_table\":";
	niceprint(out,marker_);
	out << ", \"contour_shade_marker_name_table\":";
	niceprint(out,symbol_);
	
}

static MagicsParameter<stringarray> contour_shade_colour_table("contour_shade_colour_table", stringarray());
static MagicsParameter<doublearray> contour_shade_height_table("contour_shade_height_table", floatarray());
static MagicsParameter<string> contour_shade_marker_table_type("contour_shade_marker_table_type", "index");
static MagicsParameter<intarray> contour_shade_marker_table("contour_shade_marker_table", intarray());
static MagicsParameter<stringarray> contour_shade_marker_name_table("contour_shade_marker_name_table", stringarray());
