
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CurveAttributes.h
    \\brief Definition of Curve Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "CurveWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



CurveWrapper::CurveWrapper(): curve_(new Curve())


{


	
	GraphWrapper::object(curve_);
	

}
CurveWrapper::CurveWrapper(Curve* curve): curve_(curve)
{

	
	GraphWrapper::object(curve_);
	
}

CurveWrapper::~CurveWrapper()
{

}

void CurveWrapper::set(const MagRequest& request)
{

	

	GraphWrapper::set(request);
	

	if  (request.countValues("GRAPH_LINE") ) {
		string line_value = request("GRAPH_LINE");
		
		curve_->line_ = MagTranslator<string, bool>()(line_value);
		
		}
	if  (request.countValues("GRAPH_LINE_THICKNESS") ) {
		int thickness_value = request("GRAPH_LINE_THICKNESS");
		curve_->thickness_ = thickness_value;
		}
	if  (request.countValues("GRAPH_SYMBOL") ) {
		string symbol_value = request("GRAPH_SYMBOL");
		
		curve_->symbol_ = MagTranslator<string, bool>()(symbol_value);
		
		}
	if  (request.countValues("GRAPH_SYMBOL_MARKER_INDEX") ) {
		int symbol_marker_value = request("GRAPH_SYMBOL_MARKER_INDEX");
		curve_->symbol_marker_ = symbol_marker_value;
		}
	if  (request.countValues("GRAPH_SYMBOL_HEIGHT") ) {
		double symbol_height_value = request("GRAPH_SYMBOL_HEIGHT");
		curve_->symbol_height_ = symbol_height_value;
		}
	if  (request.countValues("GRAPH_SYMBOL_OUTLINE") ) {
		string outline_value = request("GRAPH_SYMBOL_OUTLINE");
		
		curve_->outline_ = MagTranslator<string, bool>()(outline_value);
		
		}
	if  (request.countValues("GRAPH_SYMBOL_OUTLINE_THICKNESS") ) {
		int outline_thickness_value = request("GRAPH_SYMBOL_OUTLINE_THICKNESS");
		curve_->outline_thickness_ = outline_thickness_value;
		}
	if  (request.countValues("GRAPH_X_SUPPRESS_BELOW") ) {
		double x_below_value = request("GRAPH_X_SUPPRESS_BELOW");
		curve_->x_below_ = x_below_value;
		}
	if  (request.countValues("GRAPH_X_SUPPRESS_ABOVE") ) {
		double x_above_value = request("GRAPH_X_SUPPRESS_ABOVE");
		curve_->x_above_ = x_above_value;
		}
	if  (request.countValues("GRAPH_Y_SUPPRESS_BELOW") ) {
		double y_below_value = request("GRAPH_Y_SUPPRESS_BELOW");
		curve_->y_below_ = y_below_value;
		}
	if  (request.countValues("GRAPH_Y_SUPPRESS_ABOVE") ) {
		double y_above_value = request("GRAPH_Y_SUPPRESS_ABOVE");
		curve_->y_above_ = y_above_value;
		}
	if  (request.countValues("GRAPH_MISSING_DATA_MODE") ) {
		string missing_mode_value = request("GRAPH_MISSING_DATA_MODE");
		curve_->missing_mode_ = missing_mode_value;
		}
	if  (request.countValues("GRAPH_MISSING_DATA_THICKNESS") ) {
		int missing_thickness_value = request("GRAPH_MISSING_DATA_THICKNESS");
		curve_->missing_thickness_ = missing_thickness_value;
		}
	if  (request.countValues("GRAPH_CURVE_METHOD") ) {
		string plot_method_value = request("GRAPH_CURVE_METHOD");
		curve_->plot_method_ = plot_method_value;
		}
	if  (request.countValues("GRAPH_STYLE_SETTING") ) {
		string style_setting_value = request("GRAPH_STYLE_SETTING");
		curve_->style_setting_ = style_setting_value;
		}
	if  (request.countValues("GRAPH_LINE_STYLE_VARIABLE_NAME") ) {
		string style_key_value = request("GRAPH_LINE_STYLE_VARIABLE_NAME");
		curve_->style_key_ = style_key_value;
		}
	stringarray  style_keys_value;
	for (int i = 0; i < request.countValues("GRAPH_LINE_STYLE_VALUE_LIST"); i++)
		style_keys_value.push_back((string)request("GRAPH_LINE_STYLE_VALUE_LIST", i));
	if ( !style_keys_value.empty() )
		curve_->style_keys_ = style_keys_value;
	stringarray  style_list_value;
	for (int i = 0; i < request.countValues("GRAPH_LINE_STYLE_LIST"); i++)
		style_list_value.push_back((string)request("GRAPH_LINE_STYLE_LIST", i));
	if ( !style_list_value.empty() )
		curve_->style_list_ = style_list_value;
	if  (request.countValues("GRAPH_COLOUR_VARIABLE_NAME") ) {
		string colour_key_value = request("GRAPH_COLOUR_VARIABLE_NAME");
		curve_->colour_key_ = colour_key_value;
		}
	stringarray  colour_keys_value;
	for (int i = 0; i < request.countValues("GRAPH_COLOUR_VALUE_LIST"); i++)
		colour_keys_value.push_back((string)request("GRAPH_COLOUR_VALUE_LIST", i));
	if ( !colour_keys_value.empty() )
		curve_->colour_keys_ = colour_keys_value;
	stringarray  colour_list_value;
	for (int i = 0; i < request.countValues("GRAPH_COLOUR_LIST"); i++)
		colour_list_value.push_back((string)request("GRAPH_COLOUR_LIST", i));
	if ( !colour_list_value.empty() )
		curve_->colour_list_ = colour_list_value;
	if  (request.countValues("GRAPH_THICKNESS_VARIABLE_NAME") ) {
		string thickness_key_value = request("GRAPH_THICKNESS_VARIABLE_NAME");
		curve_->thickness_key_ = thickness_key_value;
		}
	stringarray  thickness_keys_value;
	for (int i = 0; i < request.countValues("GRAPH_THICKNESS_VALUE_LIST"); i++)
		thickness_keys_value.push_back((string)request("GRAPH_THICKNESS_VALUE_LIST", i));
	if ( !thickness_keys_value.empty() )
		curve_->thickness_keys_ = thickness_keys_value;
	intarray thickness_list_value;
	for (int i = 0; i < request.countValues("GRAPH_THICKNESS_LIST"); i++)
		thickness_list_value.push_back((int)request("GRAPH_THICKNESS_LIST", i));
	if ( !thickness_list_value.empty() )
		curve_->thickness_list_ = thickness_list_value;
	
	
	if  (request.countValues("GRAPH_LINE_STYLE") ) {
		string style_value = request("GRAPH_LINE_STYLE");
		curve_->style_ = MagTranslator<string, LineStyle>()(style_value);
	}
		
	if  (request.countValues("GRAPH_LINE_COLOUR") ) {
		string colour_value = request("GRAPH_LINE_COLOUR");
		curve_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	if  (request.countValues("GRAPH_SYMBOL_COLOUR") ) {
		string symbol_colour_value = request("GRAPH_SYMBOL_COLOUR");
		curve_->symbol_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(symbol_colour_value));
	}
		
	if  (request.countValues("GRAPH_SYMBOL_OUTLINE_COLOUR") ) {
		string outline_colour_value = request("GRAPH_SYMBOL_OUTLINE_COLOUR");
		curve_->outline_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(outline_colour_value));
	}
		
	
	if  (request.countValues("GRAPH_SYMBOL_OUTLINE_STYLE") ) {
		string outline_style_value = request("GRAPH_SYMBOL_OUTLINE_STYLE");
		curve_->outline_style_ = MagTranslator<string, LineStyle>()(outline_style_value);
	}
		
	
	if  (request.countValues("GRAPH_MISSING_DATA_STYLE") ) {
		string missing_style_value = request("GRAPH_MISSING_DATA_STYLE");
		curve_->missing_style_ = MagTranslator<string, LineStyle>()(missing_style_value);
	}
		
	if  (request.countValues("GRAPH_MISSING_DATA_COLOUR") ) {
		string missing_colour_value = request("GRAPH_MISSING_DATA_COLOUR");
		curve_->missing_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(missing_colour_value));
	}
		
	
	if  (request.countValues("GRAPH_LINE_STYLE_LIST_POLICY") ) {
		string style_policy_value = request("GRAPH_LINE_STYLE_LIST_POLICY");
		curve_->style_policy_ = MagTranslator<string, ListPolicy>()(style_policy_value);
	}
		
	
	if  (request.countValues("GRAPH_COLOUR_LIST_POLICY") ) {
		string colour_policy_value = request("GRAPH_COLOUR_LIST_POLICY");
		curve_->colour_policy_ = MagTranslator<string, ListPolicy>()(colour_policy_value);
	}
		
	
	if  (request.countValues("GRAPH_THICKNESS_LIST_POLICY") ) {
		string thickness_policy_value = request("GRAPH_THICKNESS_LIST_POLICY");
		curve_->thickness_policy_ = MagTranslator<string, ListPolicy>()(thickness_policy_value);
	}
		
	
}

void CurveWrapper::print(ostream& out)  const
{
	out << "CurveWrapper[]";
}












