
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsCloudAttributes.h
    \\brief Definition of EpsCloud Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "EpsCloudWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



EpsCloudWrapper::EpsCloudWrapper(): epscloud_(new EpsCloud())


{


	

}
EpsCloudWrapper::EpsCloudWrapper(EpsCloud* epscloud): epscloud_(epscloud)
{

	
}

EpsCloudWrapper::~EpsCloudWrapper()
{

}

void EpsCloudWrapper::set(const MagRequest& request)
{

	

	
	if  (request.countValues("EPS_ROSE_CLOUD_COLOUR") ) {
		string colour_value = request("EPS_ROSE_CLOUD_COLOUR");
		epscloud_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	if  (request.countValues("EPS_ROSE_CLOUD_BORDER_COLOUR") ) {
		string border_colour_value = request("EPS_ROSE_CLOUD_BORDER_COLOUR");
		epscloud_->border_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(border_colour_value));
	}
		
	
}

void EpsCloudWrapper::print(ostream& out)  const
{
	out << "EpsCloudWrapper[]";
}




