
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file HistogramLegendMethodAttributes.h
    \\brief Definition of HistogramLegendMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "HistogramLegendMethodAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

HistogramLegendMethodAttributes::HistogramLegendMethodAttributes():
	label_frequency_(ParameterManager::getInt("legend_label_frequency")),
	histo_border_(ParameterManager::getBool("legend_histogram_border")),
	histo_mean_(ParameterManager::getBool("legend_histogram_mean_value")),
	histo_mean_marker_(ParameterManager::getInt("legend_histogram_mean_value_marker")),
	histo_mean_size_(ParameterManager::getDouble("legend_histogram_mean_value_marker_size")),
	histo_max_(ParameterManager::getBool("legend_histogram_max_value")),
	histo_grid_thickness_(ParameterManager::getInt("legend_histogram_grid_thickness"))
	,
	histo_border_colour_(MagTranslator<string, Colour>().magics("legend_histogram_border_colour")),
	histo_mean_colour_(MagTranslator<string, Colour>().magics("legend_histogram_mean_value_marker_colour")),
	histo_grid_colour_(MagTranslator<string, Colour>().magics("legend_histogram_grid_colour")),
	histo_grid_style_(MagTranslator<string, LineStyle>().magics("legend_histogram_grid_line_style"))
	
{
}


HistogramLegendMethodAttributes::~HistogramLegendMethodAttributes()
{

}


void HistogramLegendMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "legend_label_frequency", label_frequency_, params);
	setAttribute(prefix, "legend_histogram_border", histo_border_, params);
	setAttribute(prefix, "legend_histogram_mean_value", histo_mean_, params);
	setAttribute(prefix, "legend_histogram_mean_value_marker", histo_mean_marker_, params);
	setAttribute(prefix, "legend_histogram_mean_value_marker_size", histo_mean_size_, params);
	setAttribute(prefix, "legend_histogram_max_value", histo_max_, params);
	setAttribute(prefix, "legend_histogram_grid_thickness", histo_grid_thickness_, params);
	
	setMember(prefix, "legend_histogram_border_colour", histo_border_colour_, params);
	setMember(prefix, "legend_histogram_mean_value_marker_colour", histo_mean_colour_, params);
	setMember(prefix, "legend_histogram_grid_colour", histo_grid_colour_, params);
	setAttribute(prefix, "legend_histogram_grid_line_style", histo_grid_style_, params);
	
}

void HistogramLegendMethodAttributes::copy(const HistogramLegendMethodAttributes& other)
{
	label_frequency_ = other.label_frequency_;
	histo_border_ = other.histo_border_;
	histo_mean_ = other.histo_mean_;
	histo_mean_marker_ = other.histo_mean_marker_;
	histo_mean_size_ = other.histo_mean_size_;
	histo_max_ = other.histo_max_;
	histo_grid_thickness_ = other.histo_grid_thickness_;
	histo_border_colour_ = unique_ptr<Colour>(other.histo_border_colour_->clone());
	histo_mean_colour_ = unique_ptr<Colour>(other.histo_mean_colour_->clone());
	histo_grid_colour_ = unique_ptr<Colour>(other.histo_grid_colour_->clone());
	histo_grid_style_ = other.histo_grid_style_;
	
}


bool HistogramLegendMethodAttributes::accept(const string& node)
{

	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void HistogramLegendMethodAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void HistogramLegendMethodAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " label_frequency = " <<  label_frequency_;
	out << " histo_border = " <<  histo_border_;
	out << " histo_mean = " <<  histo_mean_;
	out << " histo_mean_marker = " <<  histo_mean_marker_;
	out << " histo_mean_size = " <<  histo_mean_size_;
	out << " histo_max = " <<  histo_max_;
	out << " histo_grid_thickness = " <<  histo_grid_thickness_;
	out << " histo_border_colour = " <<  *histo_border_colour_;
	out << " histo_mean_colour = " <<  *histo_mean_colour_;
	out << " histo_grid_colour = " <<  *histo_grid_colour_;
	out << " histo_grid_style = " <<  histo_grid_style_;
	
	out << "]" << "\n";
}

void HistogramLegendMethodAttributes::toxml(ostream& out)  const
{
	out <<  "\"\"";
	out << ", \"legend_label_frequency\":";
	niceprint(out,label_frequency_);
	out << ", \"legend_histogram_border\":";
	niceprint(out,histo_border_);
	out << ", \"legend_histogram_mean_value\":";
	niceprint(out,histo_mean_);
	out << ", \"legend_histogram_mean_value_marker\":";
	niceprint(out,histo_mean_marker_);
	out << ", \"legend_histogram_mean_value_marker_size\":";
	niceprint(out,histo_mean_size_);
	out << ", \"legend_histogram_max_value\":";
	niceprint(out,histo_max_);
	out << ", \"legend_histogram_grid_thickness\":";
	niceprint(out,histo_grid_thickness_);
	out << ", \"legend_histogram_border_colour\":";
	niceprint(out, *histo_border_colour_);
	out << ", \"legend_histogram_mean_value_marker_colour\":";
	niceprint(out, *histo_mean_colour_);
	out << ", \"legend_histogram_grid_colour\":";
	niceprint(out, *histo_grid_colour_);
	out << ", \"legend_histogram_grid_line_style\":";
	niceprint(out, histo_grid_style_);
	
}

static MagicsParameter<int> legend_label_frequency("legend_label_frequency", 1);
static MagicsParameter<string> legend_histogram_border("legend_histogram_border", "on");
static MagicsParameter<string> legend_histogram_mean_value("legend_histogram_mean_value", "off");
static MagicsParameter<int> legend_histogram_mean_value_marker("legend_histogram_mean_value_marker", 15);
static MagicsParameter<double> legend_histogram_mean_value_marker_size("legend_histogram_mean_value_marker_size", 0.4);
static MagicsParameter<string> legend_histogram_max_value("legend_histogram_max_value", "on");
static MagicsParameter<int> legend_histogram_grid_thickness("legend_histogram_grid_thickness", 1);
static MagicsParameter<string> legend_histogram_border_colour("legend_histogram_border_colour", "black");
static MagicsParameter<string> legend_histogram_mean_value_marker_colour("legend_histogram_mean_value_marker_colour", "black");
static MagicsParameter<string> legend_histogram_grid_colour("legend_histogram_grid_colour", "black");
static MagicsParameter<string> legend_histogram_grid_line_style("legend_histogram_grid_line_style", "solid");
