# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright (C) 2009-2011 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA


import os
import re
import sys
import ldtp
import ooldtp
import shutil
from time import sleep
from magomaticconfig import get_data_file, get_data_path

class Magomatic:
    """
    """

    def __init__(self, launcher, main_window, child_window = None, \
                 overwrite = False, white_list=[]):
        self.launcher = launcher
        if child_window:
            appname = main_window
        else:
            appname = launcher
        self.appname = re.sub('\W', '_', appname.lower())
        self.overwrite = overwrite
        self.main_window = main_window
        self.child_window = child_window
        self.white_list = ["check_box", "check_menu_item", "combo_box", "entry",
                           "icon", "list", "menu", "menu_item", "page_tab",
                           "page_tab_list", "push_button", "radio_button",
                           "radio_menu_item", "scroll_bar", "spin_button",
                           "table", "text", "toggle_button", "tree", "tree_table"]
        self.app_folder = get_data_file(launcher)

    def _launchapp(self, progname):
        '''returns the window name while ldtp.launchapp returns the PID'''
        winlist=ldtp.getwindowlist()
        timeout=60
        ldtp.launchapp(progname)

        # Any way to get the window name from the app name ?
        # appundertest is not implemented in LDTPv2
        wincount=len(winlist)
        wincount_orig = wincount
        while wincount == wincount_orig and timeout > 0:
            winlist = ldtp.getwindowlist()
            wincount = len(winlist)
            timeout -= 1
            sleep(1)

        if timeout <= 0:
            print "Failed to identify window name for '%s'" % progname
            sys.exit(2)

        return(winlist[-1])

    def create_app_folder(self):
        return

        template = get_data_file("template")
        substitutions = (("name_application", self.appname),
                        ("NameApplication", self.appname.capitalize()),
                        ("Application Basics", self.appname.capitalize()),
                        )

        if self.child_window:
            leafs = ('application')
        else:
            leafs = ('application','test_suite', self.appname)
        for leaf in leafs:
            try:
                os.makedirs(os.path.join(self.app_folder, leaf))
            except OSError, e:
                if e.errno != 17: # File exists
                    raise OSError, e

        for dirpath, dirnames, filenames in os.walk(template):
            for filename in filenames:
                target_file = filename
                for pattern, sub in substitutions:
                    target_file = target_file.replace(pattern, sub)

                file_path = os.path.join(dirpath, filename)
                relpath = os.path.dirname(os.path.relpath(file_path, template))

                for pattern, sub in substitutions:
                    relpath = relpath.replace(pattern, sub)

                if self.child_window and (relpath == 'test_suite' or \
                                          relpath == self.appname):
                    continue

                file_des = open(file_path,'r')
                file_contents = file_des.read()

                for s in substitutions:
                    pattern, sub = s
                    file_contents = file_contents.replace(pattern,sub)

                target_path = os.path.join(self.app_folder, relpath + "/" + target_file)
                if (not self.overwrite) and os.path.exists(target_path):
                    print "Failed to add file to project\n cannot add: %s - this file already exists." % target_path
                    sys.exit(4)

                file_des = open(target_path, "w")
                file_des.write(file_contents)

    def discover_application(self, tree = False):
        """Dump the list of components of the application

        :param tree: If True, dump the component tree instead of the
                     application map
        """

        if self.launcher and not self.main_window:
            # Only launcher pass as argument  we try to guess the name of the main windows
            self.main_window = self._launchapp(self.launcher)
        elif not ldtp.guiexist(self.main_window):
            ldtp.launchapp(self.launcher)
        ldtp.waittillguiexist(self.main_window)
        app = ooldtp.context(self.main_window)

        if tree:
            self.walk_application(self.main_window)
        else:

            constants = ""
            if not self.child_window:
                # If main window, then added launcher
                constants += "launcher = '%s'\n" % self.launcher
                constants += "launcher_args = []\n"
            constants += "window_name = '%s'\n\n" % re.sub('\W', '*', self.main_window)

            objectlist = sorted(app.getobjectlist())
            for component in objectlist:
                role = ldtp.getobjectproperty(self.main_window, component, 'class')
                component = component.encode("UTF-8")

                constant = ""

                if role in self.white_list:
                    #constant = re.sub('\W', '_', component.upper())
                    #constant = constant[:3] + "_" + constant[3:] # Split prefix for clarity
                    #constants += "    " + constant +" = _('" + re.sub('\W', '*', component) + "')\n"
                    # All is commented by default
                    constants += '#%s = "%s"\n' % (re.sub('\W', '_', component), component)

            print constants
        #app_file = os.path.join(self.app_folder, "application/" + self.appname + ".py")

        #read_file = open(app_file, "r")
        #contents = read_file.read()

        #contents = contents.replace("CONSTANTS", constants)

        #write_file = open(app_file, "w")
        #write_file.write(contents)
        #write_file.close()

        #if 'mnuQuit' in objectlist:
        ldtp.closewindow(self.main_window)
        ldtp.waittillguinotexist (self.main_window)

    def walk_application(self, node = None, level = 1):
        """Walk the component tree of the application

        :param node: Name of the parent node
        :param level: Level of the node
        """

        if not node: return
        if level == 1: print node

        children = ldtp.getobjectproperty(self.main_window, node,
                                          'children').split(' ')

        for child in children:
            if not child: continue
            print "%s|__ %s" % ("|   " * (level - 1), child)
            self.walk_application(child, level + 1)
