/*-------------------------------------------------------------------------
 * Copyright (c) 2000 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * operators
 *
 * Synopsis:
 *   The operators defined in MathWars
 *
 * $Id: operators.c,v 1.1 2000/10/15 15:36:46 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>

#include "operators.h"

gint
operator_result (gint x1, gint x2, operator_type oper)
{
   gint result = 0.0;

   switch (oper)
      {
      case SUBTRACTION:
         result = x1 - x2;
         break;

      case ADDITION:
         result = x1 + x2;
         break;

      case MULTIPLICATION:
         result = x1 * x2;
         break;

      default:
         g_assert_not_reached ();
      }

   return result;
}


gchar
operator_symbol (operator_type oper)
{
   gchar  ch = ' ';

   switch (oper)
      {
      case ADDITION:
         ch = '+';
         break;

      case SUBTRACTION:
         ch = '-';
         break;

      case MULTIPLICATION:
         ch = 'x';
         break;

      default:
         g_assert_not_reached ();
      }

   return ch;
}
