# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class ArrayRename(PassInputTypeAlgorithm):
    r"""
    ArrayRename - Rename data arrays.
    
    Superclass: PassInputTypeAlgorithm
    
    This class takes any DataObject as input, shallow copies its
    content to
     the output and renames its data arrays.
    
    
     For each attributes type, array name should be unique.
    
    
     Supported attributes type are the following: POINT, CELL, FIELD,
    VERTEX, EDGE and ROW.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkArrayRename, obj, update, **traits)
    
    def get_array_new_name(self, *args):
        """
        get_array_new_name(self, attributeType:int, idx:int) -> str
        C++: const char *get_array_new_name(int attributeType, int idx)
        Get the new array name from idx in attributeType field data.
        """
        ret = self._wrap_call(self._vtk_obj.GetArrayNewName, *args)
        return ret

    def get_array_original_name(self, *args):
        """
        get_array_original_name(self, attributeType:int, idx:int) -> str
        C++: const char *get_array_original_name(int attributeType, int idx)
        Get the input array name from idx in attributeType field data.
        """
        ret = self._wrap_call(self._vtk_obj.GetArrayOriginalName, *args)
        return ret

    def get_cell_array_new_name(self, *args):
        """
        get_cell_array_new_name(self, idx:int) -> str
        C++: const char *get_cell_array_new_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayNewName, *args)
        return ret

    def get_cell_array_original_name(self, *args):
        """
        get_cell_array_original_name(self, idx:int) -> str
        C++: const char *get_cell_array_original_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayOriginalName, *args)
        return ret

    def get_edge_array_new_name(self, *args):
        """
        get_edge_array_new_name(self, idx:int) -> str
        C++: const char *get_edge_array_new_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetEdgeArrayNewName, *args)
        return ret

    def get_edge_array_original_name(self, *args):
        """
        get_edge_array_original_name(self, idx:int) -> str
        C++: const char *get_edge_array_original_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetEdgeArrayOriginalName, *args)
        return ret

    def get_field_array_new_name(self, *args):
        """
        get_field_array_new_name(self, idx:int) -> str
        C++: const char *get_field_array_new_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetFieldArrayNewName, *args)
        return ret

    def get_field_array_original_name(self, *args):
        """
        get_field_array_original_name(self, idx:int) -> str
        C++: const char *get_field_array_original_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetFieldArrayOriginalName, *args)
        return ret

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def get_number_of_arrays(self, *args):
        """
        get_number_of_arrays(self, attributeType:int) -> int
        C++: int get_number_of_arrays(int attributeType)
        Get number of arrays for specified attribute type.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfArrays, *args)
        return ret

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_edge_arrays(self):
        return self._vtk_obj.GetNumberOfEdgeArrays()
    number_of_edge_arrays = traits.Property(_get_number_of_edge_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_field_arrays(self):
        return self._vtk_obj.GetNumberOfFieldArrays()
    number_of_field_arrays = traits.Property(_get_number_of_field_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_row_arrays(self):
        return self._vtk_obj.GetNumberOfRowArrays()
    number_of_row_arrays = traits.Property(_get_number_of_row_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_vertex_arrays(self):
        return self._vtk_obj.GetNumberOfVertexArrays()
    number_of_vertex_arrays = traits.Property(_get_number_of_vertex_arrays, desc=\
        r"""
        
        """
    )

    def get_point_array_new_name(self, *args):
        """
        get_point_array_new_name(self, idx:int) -> str
        C++: const char *get_point_array_new_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayNewName, *args)
        return ret

    def get_point_array_original_name(self, *args):
        """
        get_point_array_original_name(self, idx:int) -> str
        C++: const char *get_point_array_original_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayOriginalName, *args)
        return ret

    def get_row_array_new_name(self, *args):
        """
        get_row_array_new_name(self, idx:int) -> str
        C++: const char *get_row_array_new_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetRowArrayNewName, *args)
        return ret

    def get_row_array_original_name(self, *args):
        """
        get_row_array_original_name(self, idx:int) -> str
        C++: const char *get_row_array_original_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetRowArrayOriginalName, *args)
        return ret

    def get_vertex_array_new_name(self, *args):
        """
        get_vertex_array_new_name(self, idx:int) -> str
        C++: const char *get_vertex_array_new_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetVertexArrayNewName, *args)
        return ret

    def get_vertex_array_original_name(self, *args):
        """
        get_vertex_array_original_name(self, idx:int) -> str
        C++: const char *get_vertex_array_original_name(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetVertexArrayOriginalName, *args)
        return ret

    def clear_all(self):
        """
        clear_all(self) -> None
        C++: void clear_all()
        Clear name mappings for all attribute types.
        """
        ret = self._vtk_obj.ClearAll()
        return ret
        

    def clear_cell_mapping(self):
        """
        clear_cell_mapping(self) -> None
        C++: void clear_cell_mapping()"""
        ret = self._vtk_obj.ClearCellMapping()
        return ret
        

    def clear_edge_mapping(self):
        """
        clear_edge_mapping(self) -> None
        C++: void clear_edge_mapping()"""
        ret = self._vtk_obj.ClearEdgeMapping()
        return ret
        

    def clear_field_mapping(self):
        """
        clear_field_mapping(self) -> None
        C++: void clear_field_mapping()"""
        ret = self._vtk_obj.ClearFieldMapping()
        return ret
        

    def clear_mapping(self, *args):
        """
        clear_mapping(self, attributeType:int) -> None
        C++: void clear_mapping(int attributeType)
        Clear mapping for the specified attribute type.
        """
        ret = self._wrap_call(self._vtk_obj.ClearMapping, *args)
        return ret

    def clear_point_mapping(self):
        """
        clear_point_mapping(self) -> None
        C++: void clear_point_mapping()"""
        ret = self._vtk_obj.ClearPointMapping()
        return ret
        

    def clear_row_mapping(self):
        """
        clear_row_mapping(self) -> None
        C++: void clear_row_mapping()"""
        ret = self._vtk_obj.ClearRowMapping()
        return ret
        

    def clear_vertex_mapping(self):
        """
        clear_vertex_mapping(self) -> None
        C++: void clear_vertex_mapping()"""
        ret = self._vtk_obj.ClearVertexMapping()
        return ret
        

    def set_array_name(self, *args):
        """
        set_array_name(self, attributeType:int, idx:int, newName:str)
            -> None
        C++: void set_array_name(int attributeType, int idx,
            const char *newName)
        set_array_name(self, attributeType:int, inputName:str, newName:str)
            -> None
        C++: void set_array_name(int attributeType, const char *inputName,
            const char *newName)
        Set the new array name from idx in attributeType field data.
        """
        ret = self._wrap_call(self._vtk_obj.SetArrayName, *args)
        return ret

    def set_cell_array_name(self, *args):
        """
        set_cell_array_name(self, idx:int, newName:str) -> None
        C++: void set_cell_array_name(int idx, const char *newName)
        set_cell_array_name(self, inputName:str, newName:str) -> None
        C++: void set_cell_array_name(const char *inputName,
            const char *newName)"""
        ret = self._wrap_call(self._vtk_obj.SetCellArrayName, *args)
        return ret

    def set_edge_array_name(self, *args):
        """
        set_edge_array_name(self, idx:int, newName:str) -> None
        C++: void set_edge_array_name(int idx, const char *newName)
        set_edge_array_name(self, inputName:str, newName:str) -> None
        C++: void set_edge_array_name(const char *inputName,
            const char *newName)"""
        ret = self._wrap_call(self._vtk_obj.SetEdgeArrayName, *args)
        return ret

    def set_field_array_name(self, *args):
        """
        set_field_array_name(self, idx:int, newName:str) -> None
        C++: void set_field_array_name(int idx, const char *newName)
        set_field_array_name(self, inputName:str, newName:str) -> None
        C++: void set_field_array_name(const char *inputName,
            const char *newName)"""
        ret = self._wrap_call(self._vtk_obj.SetFieldArrayName, *args)
        return ret

    def set_point_array_name(self, *args):
        """
        set_point_array_name(self, idx:int, newName:str) -> None
        C++: void set_point_array_name(int idx, const char *newName)
        set_point_array_name(self, inputName:str, newName:str) -> None
        C++: void set_point_array_name(const char *inputName,
            const char *newName)"""
        ret = self._wrap_call(self._vtk_obj.SetPointArrayName, *args)
        return ret

    def set_row_array_name(self, *args):
        """
        set_row_array_name(self, idx:int, newName:str) -> None
        C++: void set_row_array_name(int idx, const char *newName)
        set_row_array_name(self, inputName:str, newName:str) -> None
        C++: void set_row_array_name(const char *inputName,
            const char *newName)"""
        ret = self._wrap_call(self._vtk_obj.SetRowArrayName, *args)
        return ret

    def set_vertex_array_name(self, *args):
        """
        set_vertex_array_name(self, idx:int, newName:str) -> None
        C++: void set_vertex_array_name(int idx, const char *newName)
        set_vertex_array_name(self, inputName:str, newName:str) -> None
        C++: void set_vertex_array_name(const char *inputName,
            const char *newName)"""
        ret = self._wrap_call(self._vtk_obj.SetVertexArrayName, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ArrayRename, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ArrayRename properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit ArrayRename properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ArrayRename properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

