C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RA1 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=10)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4A1
C       PARAMETER (ISET=4)                                           
        DATA  DrI, FlI, AlI /             2.,   5.,  .1400 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                                 1.600,    5.000,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000D+01, .100000D+05,
     +  .160000D+01, .204474D+01, .267844D+01, .360520D+01, .500000D+01,
     +  .810220D+01, .140132D+02, .260970D+02, .528569D+02, .117758D+03,
     +  .292312D+03, .820365D+03, .264648D+04, .100000D+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000D-04,
     +  .000000D+00, .999983D-05, .124433D-04, .154836D-04, .192668D-04,
     +  .239740D-04, .298310D-04, .371184D-04, .461852D-04, .574656D-04,
     +  .714994D-04, .889575D-04, .110674D-03, .137686D-03, .171280D-03,
     +  .213055D-03, .264997D-03, .329564D-03, .409809D-03, .509508D-03,
     +  .633332D-03, .787053D-03, .977784D-03, .121428D-02, .150728D-02,
     +  .186993D-02, .231825D-02, .288037D-02, .356397D-02, .440443D-02,
     +  .543508D-02, .669508D-02, .822984D-02, .100851D-01, .123281D-01,
     +  .150167D-01, .182174D-01, .219985D-01, .264278D-01, .315720D-01,
     +  .374800D-01, .442088D-01, .517931D-01, .602576D-01, .696136D-01,
     +  .798586D-01, .909356D-01, .102935D+00, .115681D+00, .129293D+00,
     +  .143599D+00, .158606D+00, .174271D+00, .190550D+00, .207405D+00,
     +  .224796D+00, .242685D+00, .261038D+00, .279820D+00, .299001D+00,
     +  .318550D+00, .338442D+00, .358653D+00, .379067D+00, .399881D+00,
     +  .420953D+00, .442266D+00, .463806D+00, .485559D+00, .507513D+00,
     +  .529656D+00, .551978D+00, .574483D+00, .597187D+00, .619860D+00,
     +  .642828D+00, .665921D+00, .689135D+00, .712467D+00, .735911D+00,
     +  .759464D+00, .783080D+00, .806909D+00, .830741D+00, .854673D+00,
     +  .878696D+00, .902804D+00, .926992D+00, .951257D+00, .975603D+00,
     +  .100000D+01 /
C Parton Distribution Table:                                                     
        DATA (UPDI(I),I=1,52) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=365,416) /
     +  .222477D+06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .894965D+05,
     +  .682456D+05, .512150D+05, .384047D+05, .287820D+05,
     +  .215514D+05, .161271D+05, .120567D+05, .900747D+04,
     +  .672263D+04, .501359D+04, .373499D+04, .278018D+04 /
        DATA (UPDI(I),I=469,520) /
     +  .206705D+04, .153547D+04, .113916D+04, .844322D+03,
     +  .624942D+03, .462075D+03, .341153D+03, .251593D+03,
     +  .185256D+03, .136243D+03, .100033D+03, .733480D+02,
     +  .536956D+02, .392686D+02, .285382D+02, .208089D+02,
     +  .151474D+02, .110162D+02, .800026D+01, .580611D+01,
     +  .421375D+01, .305610D+01, .221623D+01, .160908D+01,
     +  .116915D+01, .851416D+00, .621104D+00, .454805D+00,
     +  .333946D+00, .246195D+00, .182125D+00, .135357D+00,
     +  .100946D+00, .757125D-01, .568411D-01, .429433D-01,
     +  .324522D-01, .246261D-01, .187090D-01, .142439D-01,
     +  .108467D-01, .826772D-02, .629381D-02, .478778D-02,
     +  .363272D-02, .275187D-02, .207585D-02, .156088D-02,
     +  .116692D-02, .867780D-03, .641584D-03, .469796D-03 /
        DATA (UPDI(I),I=521,572) /
     +  .340181D-03, .243566D-03, .171723D-03, .119066D-03,
     +  .806131D-04, .530792D-04, .334981D-04, .199258D-04,
     +  .106876D-04, .471897D-05, .941690D-06, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .202138D+06, .153766D+06,
     +  .115066D+06, .860373D+05, .642917D+05, .479989D+05,
     +  .358104D+05, .266912D+05, .198793D+05, .147906D+05,
     +  .109956D+05, .816519D+04, .605801D+04, .448925D+04,
     +  .332352D+04, .245731D+04, .181497D+04, .133865D+04,
     +  .986217D+03, .725475D+03, .533021D+03, .390994D+03,
     +  .286431D+03, .209475D+03, .152974D+03, .111524D+03 /
        DATA (UPDI(I),I=573,624) /
     +  .812129D+02, .587626D+02, .426567D+02, .309109D+02,
     +  .223753D+02, .161724D+02, .116792D+02, .843384D+01,
     +  .608507D+01, .438956D+01, .316961D+01, .229029D+01,
     +  .165835D+01, .120278D+01, .875503D+00, .638993D+00,
     +  .468188D+00, .344211D+00, .254206D+00, .188381D+00,
     +  .140382D+00, .104716D+00, .785942D-01, .590065D-01,
     +  .444808D-01, .335723D-01, .253906D-01, .192082D-01,
     +  .145438D-01, .109990D-01, .831237D-02, .626680D-02,
     +  .471714D-02, .353678D-02, .264387D-02, .196596D-02,
     +  .145496D-02, .107141D-02, .782336D-03, .565944D-03,
     +  .405842D-03, .287660D-03, .201595D-03, .139104D-03,
     +  .945296D-04, .628843D-04, .408416D-04, .256999D-04,
     +  .156732D-04, .903386D-05, .485191D-05, .229851D-05 /
        DATA (UPDI(I),I=625,676) /
     +  .845417D-06, .761225D-07, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .342047D+06, .259541D+06, .193647D+06,
     +  .144365D+06, .107552D+06, .800527D+05, .595403D+05,
     +  .442401D+05, .328452D+05, .243595D+05, .180503D+05,
     +  .133600D+05, .987903D+04, .729607D+04, .538289D+04,
     +  .396611D+04, .291895D+04, .214518D+04, .157461D+04,
     +  .115401D+04, .844654D+03, .617205D+03, .450366D+03,
     +  .328048D+03, .238586D+03, .173211D+03, .125593D+03,
     +  .904732D+02, .653818D+02, .471633D+02, .339795D+02,
     +  .244426D+02, .175647D+02, .126205D+02, .905856D+01,
     +  .650015D+01, .466806D+01, .335446D+01, .241508D+01 /
        DATA (UPDI(I),I=677,728) /
     +  .174158D+01, .126021D+01, .914300D+00, .665825D+00,
     +  .486524D+00, .357065D+00, .262953D+00, .194711D+00,
     +  .144324D+00, .107624D+00, .802842D-01, .601283D-01,
     +  .450918D-01, .338813D-01, .254667D-01, .191568D-01,
     +  .143944D-01, .108079D-01, .809639D-02, .605519D-02,
     +  .451164D-02, .335162D-02, .247731D-02, .182271D-02,
     +  .133483D-02, .969695D-03, .698427D-03, .499123D-03,
     +  .353073D-03, .247406D-03, .171199D-03, .117134D-03,
     +  .789416D-04, .524021D-04, .341849D-04, .220515D-04,
     +  .139230D-04, .867103D-05, .531484D-05, .323654D-05,
     +  .195687D-05, .119655D-05, .737660D-06, .463794D-06,
     +  .291915D-06, .181245D-06, .106016D-06, .555866D-07,
     +  .236760D-07, .638835D-08, .404436D-09, .000000D+00 /
        DATA (UPDI(I),I=729,780) /
     +  .513847D+06, .388891D+06, .289274D+06, .214997D+06,
     +  .159676D+06, .118477D+06, .878393D+05, .650582D+05,
     +  .481442D+05, .355888D+05, .262833D+05, .193882D+05,
     +  .142876D+05, .105155D+05, .773087D+04, .567587D+04,
     +  .416218D+04, .304766D+04, .222871D+04, .162722D+04,
     +  .118642D+04, .863557D+03, .627612D+03, .455304D+03,
     +  .329769D+03, .238397D+03, .172111D+03, .123432D+03,
     +  .887981D+02, .637620D+02, .457220D+02, .327320D+02,
     +  .234055D+02, .167331D+02, .119483D+02, .852868D+01,
     +  .609163D+01, .435341D+01, .311659D+01, .223464D+01,
     +  .160753D+01, .115940D+01, .839229D+00, .609527D+00,
     +  .444582D+00, .325383D+00, .239434D+00, .176368D+00,
     +  .130686D+00, .968734D-01, .720907D-01, .537225D-01 /
        DATA (UPDI(I),I=781,832) /
     +  .401091D-01, .299575D-01, .223908D-01, .167180D-01,
     +  .124728D-01, .928509D-02, .690030D-02, .510954D-02,
     +  .377227D-02, .277150D-02, .202707D-02, .147602D-02,
     +  .106638D-02, .764261D-03, .543777D-03, .383344D-03,
     +  .268007D-03, .185380D-03, .127084D-03, .861197D-04,
     +  .577598D-04, .383382D-04, .253741D-04, .166417D-04,
     +  .109196D-04, .717465D-05, .475713D-05, .317582D-05,
     +  .214639D-05, .145085D-05, .973555D-06, .635350D-06,
     +  .394926D-06, .225329D-06, .112522D-06, .447909D-07,
     +  .112585D-07, .744910D-09, .000000D+00, .722470D+06,
     +  .545336D+06, .404381D+06, .299605D+06, .221807D+06,
     +  .164050D+06, .121232D+06, .894970D+05, .660095D+05,
     +  .486318D+05, .357938D+05, .263133D+05, .193233D+05 /
        DATA (UPDI(I),I=833,884) /
     +  .141718D+05, .103817D+05, .759452D+04, .554869D+04,
     +  .404783D+04, .294892D+04, .214483D+04, .155772D+04,
     +  .112934D+04, .817469D+03, .590613D+03, .425989D+03,
     +  .306645D+03, .220421D+03, .157370D+03, .112702D+03,
     +  .805557D+02, .574919D+02, .409610D+02, .291454D+02,
     +  .207326D+02, .147278D+02, .104576D+02, .742912D+01,
     +  .528028D+01, .375896D+01, .267998D+01, .191672D+01,
     +  .137432D+01, .988869D+00, .713917D+00, .517558D+00,
     +  .376485D+00, .275334D+00, .201565D+00, .148426D+00,
     +  .109341D+00, .808598D-01, .598845D-01, .444300D-01,
     +  .329791D-01, .244947D-01, .181755D-01, .134757D-01,
     +  .997018D-02, .736359D-02, .541954D-02, .397683D-02,
     +  .290456D-02, .211196D-02, .152915D-02, .109872D-02 /
        DATA (UPDI(I),I=885,936) /
     +  .783500D-03, .554938D-03, .389754D-03, .271726D-03,
     +  .187710D-03, .128749D-03, .875290D-04, .591004D-04,
     +  .396774D-04, .266945D-04, .179153D-04, .121007D-04,
     +  .822950D-05, .565906D-05, .391611D-05, .272537D-05,
     +  .188174D-05, .127464D-05, .831561D-06, .511380D-06,
     +  .286394D-06, .139199D-06, .534385D-07, .129126D-07,
     +  .873516D-09, .000000D+00, .973101D+06, .732542D+06,
     +  .541474D+06, .399896D+06, .295097D+06, .217546D+06,
     +  .160235D+06, .117896D+06, .866624D+05, .636305D+05,
     +  .466718D+05, .341907D+05, .250195D+05, .182841D+05,
     +  .133457D+05, .972716D+04, .708046D+04, .514589D+04,
     +  .373459D+04, .270578D+04, .195741D+04, .141346D+04,
     +  .101898D+04, .733178D+03, .526602D+03, .377450D+03 /
        DATA (UPDI(I),I=937,988) /
     +  .270134D+03, .191998D+03, .136880D+03, .973881D+02,
     +  .691777D+02, .490510D+02, .347303D+02, .245824D+02,
     +  .173730D+02, .122716D+02, .867113D+01, .612964D+01,
     +  .433939D+01, .307644D+01, .218765D+01, .155951D+01,
     +  .111552D+01, .800597D+00, .576917D+00, .417142D+00,
     +  .303220D+00, .220633D+00, .161473D+00, .118226D+00,
     +  .868935D-01, .639617D-01, .471641D-01, .347956D-01,
     +  .256851D-01, .189431D-01, .139594D-01, .102660D-01,
     +  .753624D-02, .551376D-02, .402201D-02, .292067D-02,
     +  .211156D-02, .152047D-02, .108668D-02, .771135D-03,
     +  .543767D-03, .380510D-03, .264539D-03, .182487D-03,
     +  .125189D-03, .853209D-04, .579204D-04, .392345D-04,
     +  .267262D-04, .182356D-04, .125579D-04, .872320D-05 /
        DATA (UPDI(I),I=989,1040) /
     +  .612034D-05, .431011D-05, .303472D-05, .210783D-05,
     +  .142600D-05, .923915D-06, .560905D-06, .308595D-06,
     +  .146497D-06, .545479D-07, .127540D-07, .878519D-09,
     +  .000000D+00, .127109D+07, .954262D+06, .703093D+06,
     +  .517577D+06, .380687D+06, .279717D+06, .205339D+06,
     +  .150574D+06, .110306D+06, .807122D+05, .589947D+05,
     +  .430665D+05, .314023D+05, .228660D+05, .166293D+05,
     +  .120758D+05, .875721D+04, .634047D+04, .458389D+04,
     +  .330823D+04, .238379D+04, .171447D+04, .123096D+04,
     +  .882047D+03, .630868D+03, .450247D+03, .320829D+03,
     +  .227007D+03, .161108D+03, .114101D+03, .806692D+02,
     +  .569266D+02, .401096D+02, .282493D+02, .198627D+02,
     +  .139576D+02, .981015D+01, .689755D+01, .485620D+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .342371D+01, .242079D+01, .171584D+01, .122022D+01,
     +  .870632D+00, .623677D+00, .448280D+00, .323912D+00,
     +  .234281D+00, .170429D+00, .124034D+00, .906134D-01,
     +  .663016D-01, .485955D-01, .356377D-01, .261487D-01,
     +  .191705D-01, .140429D-01, .102668D-01, .749244D-02,
     +  .545006D-02, .395266D-02, .285429D-02, .205219D-02,
     +  .146988D-02, .104516D-02, .738225D-03, .518381D-03,
     +  .361501D-03, .250678D-03, .172711D-03, .118513D-03,
     +  .809626D-04, .552309D-04, .377034D-04, .259484D-04,
     +  .179353D-04, .125269D-04, .882649D-05, .626845D-05,
     +  .445494D-05, .314987D-05, .218739D-05, .147188D-05,
     +  .944708D-06, .565688D-06, .305799D-06, .141957D-06,
     +  .513814D-07, .116594D-07, .816494D-09, .000000D+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .162184D+07, .121426D+07, .891754D+06, .654316D+06,
     +  .479673D+06, .351277D+06, .257003D+06, .187820D+06,
     +  .137119D+06, .999846D+05, .728254D+05, .529751D+05,
     +  .384889D+05, .279251D+05, .202341D+05, .146392D+05,
     +  .105763D+05, .762852D+04, .549388D+04, .394955D+04,
     +  .283465D+04, .203058D+04, .145199D+04, .103614D+04,
     +  .737969D+03, .524431D+03, .372065D+03, .262082D+03,
     +  .185165D+03, .130540D+03, .918606D+02, .645169D+02,
     +  .452369D+02, .317037D+02, .221788D+02, .155053D+02,
     +  .108406D+02, .758154D+01, .530876D+01, .372220D+01,
     +  .261712D+01, .184452D+01, .130421D+01, .925213D+00,
     +  .658918D+00, .470844D+00, .338222D+00, .243193D+00,
     +  .175866D+00, .127236D+00, .924026D-01, .672145D-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .489744D-01, .357056D-01, .260446D-01, .189831D-01,
     +  .138249D-01, .100495D-01, .729182D-02, .527434D-02,
     +  .380387D-02, .273200D-02, .195382D-02, .139231D-02,
     +  .985199D-03, .692813D-03, .484598D-03, .336887D-03,
     +  .233087D-03, .160442D-03, .110152D-03, .754376D-04,
     +  .517050D-04, .355456D-04, .246812D-04, .172395D-04,
     +  .121704D-04, .866035D-05, .619602D-05, .442273D-05,
     +  .312754D-05, .216443D-05, .144553D-05, .917896D-06,
     +  .541854D-06, .287817D-06, .130725D-06, .460518D-07,
     +  .101611D-07, .722847D-09, .000000D+00, .203074D+07,
     +  .151624D+07, .110990D+07, .811705D+06, .593081D+06,
     +  .432878D+06, .315635D+06, .229884D+06, .167250D+06,
     +  .121532D+06, .882090D+05, .639382D+05, .462875D+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .334616D+05, .241568D+05, .174125D+05, .125327D+05,
     +  .900537D+04, .646050D+04, .462639D+04, .330731D+04,
     +  .235969D+04, .168048D+04, .119425D+04, .847025D+03,
     +  .599362D+03, .423385D+03, .296903D+03, .208829D+03,
     +  .146556D+03, .102652D+03, .717570D+02, .500712D+02,
     +  .349205D+02, .243069D+02, .169066D+02, .117590D+02,
     +  .818053D+01, .569744D+01, .397304D+01, .277806D+01,
     +  .194704D+01, .136893D+01, .965617D+00, .683752D+00,
     +  .485780D+00, .346939D+00, .248018D+00, .178314D+00,
     +  .128259D+00, .926058D-01, .669749D-01, .485182D-01,
     +  .351704D-01, .255068D-01, .184855D-01, .133862D-01,
     +  .967625D-02, .698182D-02, .502254D-02, .360271D-02,
     +  .257402D-02, .183142D-02, .129876D-02, .914775D-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .640647D-03, .446508D-03, .309545D-03, .213772D-03,
     +  .147064D-03, .101053D-03, .693919D-04, .477828D-04,
     +  .330634D-04, .231367D-04, .163007D-04, .116016D-04,
     +  .831161D-05, .597124D-05, .426764D-05, .301063D-05,
     +  .207226D-05, .137182D-05, .861107D-06, .500977D-06,
     +  .261471D-06, .116233D-06, .398873D-07, .857001D-08,
     +  .619013D-09, .000000D+00, .921232D+05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .272605D+05, .210963D+05, .161051D+05,
     +  .122869D+05, .937225D+04, .714394D+04, .544420D+04,
     +  .414574D+04, .315612D+04, .240078D+04, .182563D+04,
     +  .138705D+04, .105345D+04, .799320D+03, .606244D+03,
     +  .459329D+03, .347854D+03, .263136D+03, .198943D+03,
     +  .150229D+03, .113380D+03, .854601D+02, .643746D+02,
     +  .484268D+02, .364038D+02, .273320D+02, .205126D+02,
     +  .153106D+02, .114696D+02, .858093D+01, .641910D+01,
     +  .479705D+01, .358555D+01, .268087D+01, .200509D+01,
     +  .150002D+01, .112449D+01, .843845D+00, .635200D+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .479051D+00, .362898D+00, .275669D+00, .210372D+00,
     +  .161065D+00, .123945D+00, .956775D-01, .742899D-01,
     +  .577231D-01, .451368D-01, .352915D-01, .277081D-01,
     +  .217666D-01, .171372D-01, .134885D-01, .106282D-01,
     +  .835958D-02, .657108D-02, .515001D-02, .403105D-02,
     +  .314123D-02, .244117D-02, .188653D-02, .145136D-02,
     +  .111098D-02, .843556D-03, .634362D-03, .472917D-03,
     +  .348406D-03, .253796D-03, .181933D-03, .128379D-03,
     +  .885312D-04, .596090D-04, .386127D-04, .240844D-04,
     +  .139633D-04, .727183D-05, .298711D-05, .430861D-06,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .617732D+05, .476961D+05, .363164D+05, .276342D+05,
     +  .210220D+05, .159806D+05, .121444D+05, .922215D+04,
     +  .700055D+04, .530979D+04, .402575D+04, .304953D+04,
     +  .230898D+04, .174660D+04, .132051D+04, .997338D+03,
     +  .752825D+03, .567617D+03, .427700D+03, .321882D+03,
     +  .242081D+03, .181832D+03, .136475D+03, .102294D+03,
     +  .766102D+02, .573024D+02, .428382D+02, .318474D+02,
     +  .237609D+02, .177042D+02, .131877D+02, .981316D+01,
     +  .730214D+01, .543532D+01, .404617D+01, .301272D+01,
     +  .224737D+01, .167816D+01, .125673D+01, .942915D+00,
     +  .710474D+00, .536820D+00, .407406D+00, .310213D+00,
     +  .237373D+00, .182217D+00, .140677D+00, .108694D+00,
     +  .845038D-01, .656986D-01, .512847D-01, .400619D-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .313616D-01, .245469D-01, .192321D-01, .150434D-01,
     +  .117595D-01, .916710D-02, .713678D-02, .553294D-02,
     +  .427831D-02, .329071D-02, .252050D-02, .192170D-02,
     +  .145417D-02, .109088D-02, .812232D-03, .598683D-03,
     +  .437315D-03, .315429D-03, .224979D-03, .157981D-03,
     +  .109329D-03, .740306D-04, .494233D-04, .320536D-04,
     +  .202845D-04, .123845D-04, .728827D-05, .406326D-05,
     +  .213207D-05, .101530D-05, .421381D-06, .128646D-06,
     +  .921694D-08, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .104640D+06,
     +  .806100D+05, .612164D+05, .464589D+05, .352469D+05,
     +  .267217D+05, .202506D+05, .153349D+05, .116074D+05,
     +  .877876D+04, .663622D+04, .501212D+04, .378346D+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .285324D+04, .215045D+04, .161906D+04, .121819D+04,
     +  .915524D+03, .687559D+03, .515723D+03, .386537D+03,
     +  .289334D+03, .216392D+03, .161617D+03, .120595D+03,
     +  .898670D+02, .669265D+02, .495609D+02, .368296D+02,
     +  .273316D+02, .202743D+02, .150232D+02, .111303D+02,
     +  .824847D+01, .611224D+01, .453011D+01, .336307D+01,
     +  .249919D+01, .186220D+01, .139020D+01, .104206D+01,
     +  .783279D+00, .591276D+00, .447833D+00, .340813D+00,
     +  .260211D+00, .199786D+00, .153528D+00, .118698D+00,
     +  .917799D-01, .712471D-01, .553547D-01, .430948D-01,
     +  .335486D-01, .261404D-01, .203373D-01, .158115D-01,
     +  .122608D-01, .949406D-02, .732224D-02, .563226D-02,
     +  .431023D-02, .328487D-02, .249230D-02, .187704D-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .140200D-02, .103974D-02, .763820D-03, .556459D-03,
     +  .400776D-03, .285824D-03, .201148D-03, .139876D-03,
     +  .956234D-04, .647868D-04, .430205D-04, .282005D-04,
     +  .181485D-04, .115358D-04, .720217D-05, .446022D-05,
     +  .271903D-05, .164231D-05, .970012D-06, .557559D-06,
     +  .301299D-06, .147538D-06, .600685D-07, .160855D-07,
     +  .989852D-09, .000000D+00, .189601D+06, .120767D+06,
     +  .914701D+05, .692351D+05, .523843D+05, .396058D+05,
     +  .299311D+05, .226021D+05, .170593D+05, .128649D+05,
     +  .969657D+04, .730187D+04, .549526D+04, .413158D+04,
     +  .310425D+04, .232988D+04, .174741D+04, .130903D+04,
     +  .979850D+03, .732532D+03, .547173D+03, .408175D+03,
     +  .304202D+03, .226396D+03, .168320D+03, .124971D+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .927185D+02, .683952D+02, .506261D+02, .374215D+02,
     +  .276452D+02, .204002D+02, .150492D+02, .111046D+02,
     +  .819175D+01, .604387D+01, .446579D+01, .330297D+01,
     +  .244909D+01, .181937D+01, .135686D+01, .101474D+01,
     +  .762027D+00, .574180D+00, .434656D+00, .330120D+00,
     +  .252108D+00, .192714D+00, .148193D+00, .113979D+00,
     +  .880048D-01, .680148D-01, .526682D-01, .407863D-01,
     +  .316103D-01, .244642D-01, .189196D-01, .145952D-01,
     +  .112423D-01, .862624D-02, .660098D-02, .502615D-02,
     +  .381115D-02, .287726D-02, .215628D-02, .160305D-02,
     +  .118348D-02, .865835D-03, .628385D-03, .451171D-03,
     +  .320986D-03, .225627D-03, .156928D-03, .107566D-03,
     +  .732455D-04, .490863D-04, .326255D-04, .214274D-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .139971D-04, .905747D-05, .585535D-05, .374985D-05,
     +  .238171D-05, .147688D-05, .883222D-06, .491487D-06,
     +  .244137D-06, .991455D-07, .260481D-07, .165440D-08,
     +  .000000D+00, .243490D+06, .186583D+06, .140828D+06,
     +  .106224D+06, .800845D+05, .603331D+05, .454287D+05,
     +  .341795D+05, .257008D+05, .193091D+05, .144977D+05,
     +  .108752D+05, .815220D+04, .610496D+04, .456832D+04,
     +  .341481D+04, .255041D+04, .190261D+04, .141804D+04,
     +  .105556D+04, .784976D+03, .582970D+03, .432488D+03,
     +  .320394D+03, .237081D+03, .175184D+03, .129336D+03,
     +  .949279D+02, .699070D+02, .514087D+02, .377763D+02,
     +  .277272D+02, .203407D+02, .149256D+02, .109465D+02,
     +  .802921D+01, .589676D+01, .433487D+01, .319397D+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .235781D+01, .174700D+01, .129806D+01, .968285D+00,
     +  .724786D+00, .544948D+00, .411120D+00, .311828D+00,
     +  .236764D+00, .180818D+00, .138135D+00, .105924D+00,
     +  .813169D-01, .625390D-01, .481066D-01, .370284D-01,
     +  .284653D-01, .218631D-01, .167525D-01, .128143D-01,
     +  .976498D-02, .741896D-02, .560874D-02, .422090D-02,
     +  .316200D-02, .234987D-02, .173167D-02, .126607D-02,
     +  .916449D-03, .657005D-03, .465127D-03, .325352D-03,
     +  .224037D-03, .151843D-03, .100741D-03, .657771D-04,
     +  .417112D-04, .257569D-04, .153315D-04, .877376D-05,
     +  .474649D-05, .240702D-05, .110234D-05, .437137D-06,
     +  .125572D-06, .761066D-08, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .353055D+06, .269719D+06, .202857D+06, .152468D+06,
     +  .114533D+06, .859720D+05, .644946D+05, .483438D+05,
     +  .362139D+05, .271040D+05, .202713D+05, .151470D+05,
     +  .113092D+05, .843532D+04, .628641D+04, .467980D+04,
     +  .348058D+04, .258558D+04, .191879D+04, .142213D+04,
     +  .105290D+04, .778462D+03, .574887D+03, .423927D+03,
     +  .312219D+03, .229604D+03, .168687D+03, .123191D+03,
     +  .902618D+02, .660385D+02, .482714D+02, .352423D+02,
     +  .257121D+02, .187629D+02, .136821D+02, .997797D+01,
     +  .728434D+01, .532288D+01, .389777D+01, .285956D+01,
     +  .210531D+01, .155435D+01, .115193D+01, .856667D+00,
     +  .639850D+00, .479547D+00, .361309D+00, .272524D+00,
     +  .206732D+00, .156884D+00, .119496D+00, .911311D-01 /
        DATA (UPDI(I),I=1873,1924) /
     +  .696186D-01, .532000D-01, .406749D-01, .310630D-01,
     +  .236998D-01, .180413D-01, .137087D-01, .103787D-01,
     +  .783336D-02, .588398D-02, .439932D-02, .327470D-02,
     +  .241810D-02, .177110D-02, .128723D-02, .926661D-03,
     +  .660947D-03, .465942D-03, .324848D-03, .223328D-03,
     +  .151405D-03, .100857D-03, .664080D-04, .427815D-04,
     +  .271048D-04, .168194D-04, .102622D-04, .613375D-05,
     +  .362101D-05, .210343D-05, .121115D-05, .685231D-06,
     +  .379786D-06, .199397D-06, .954673D-07, .378164D-07,
     +  .973219D-08, .607511D-09, .000000D+00, .489941D+06,
     +  .373153D+06, .279650D+06, .209432D+06, .156752D+06,
     +  .117232D+06, .876187D+05, .654311D+05, .488277D+05,
     +  .364047D+05, .271217D+05, .201862D+05, .150118D+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .111520D+05, .827716D+04, .613644D+04, .454488D+04,
     +  .336196D+04, .248426D+04, .183326D+04, .135130D+04,
     +  .994632D+03, .731192D+03, .536712D+03, .393435D+03,
     +  .287954D+03, .210530D+03, .152982D+03, .111527D+03,
     +  .811826D+02, .590318D+02, .428709D+02, .311082D+02,
     +  .225763D+02, .163700D+02, .118701D+02, .861482D+01,
     +  .625786D+01, .455465D+01, .332108D+01, .242985D+01,
     +  .178271D+01, .131274D+01, .970044D+00, .719841D+00,
     +  .536015D+00, .401223D+00, .300666D+00, .226584D+00,
     +  .170830D+00, .129264D+00, .979434D-01, .743339D-01,
     +  .564363D-01, .428671D-01, .325259D-01, .246549D-01,
     +  .186483D-01, .140780D-01, .105905D-01, .794189D-02,
     +  .592794D-02, .440410D-02, .325780D-02, .239063D-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .174050D-02, .125764D-02, .900455D-03, .639015D-03,
     +  .448551D-03, .311647D-03, .213823D-03, .144921D-03,
     +  .968095D-04, .641434D-04, .418141D-04, .269893D-04,
     +  .172277D-04, .109335D-04, .689191D-05, .434554D-05,
     +  .272722D-05, .170125D-05, .103999D-05, .613080D-06,
     +  .336001D-06, .163486D-06, .641903D-07, .160856D-07,
     +  .104871D-08, .000000D+00, .658768D+06, .500202D+06,
     +  .373521D+06, .278724D+06, .207853D+06, .154877D+06,
     +  .115323D+06, .857958D+05, .637809D+05, .473708D+05,
     +  .351541D+05, .260618D+05, .193040D+05, .142830D+05,
     +  .105578D+05, .779502D+04, .574917D+04, .423486D+04,
     +  .311586D+04, .228939D+04, .168010D+04, .123114D+04,
     +  .900959D+03, .658294D+03, .480311D+03, .349870D+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .254563D+03, .184062D+03, .133515D+03, .966972D+02,
     +  .699496D+02, .505334D+02, .364715D+02, .263249D+02,
     +  .189816D+02, .136859D+02, .987521D+01, .713147D+01,
     +  .515946D+01, .373943D+01, .271912D+01, .198263D+01,
     +  .145080D+01, .106534D+01, .785528D+00, .581212D+00,
     +  .432274D+00, .321868D+00, .241000D+00, .180536D+00,
     +  .135731D+00, .102190D+00, .770601D-01, .581349D-01,
     +  .438746D-01, .330797D-01, .249154D-01, .187271D-01,
     +  .140480D-01, .105021D-01, .782619D-02, .580562D-02,
     +  .428656D-02, .315156D-02, .229866D-02, .166381D-02,
     +  .119546D-02, .851448D-03, .601303D-03, .420339D-03,
     +  .291082D-03, .199321D-03, .135053D-03, .904339D-04,
     +  .602397D-04, .396553D-04, .259752D-04, .169318D-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .110380D-04, .718890D-05, .469533D-05, .305297D-05,
     +  .196263D-05, .122780D-05, .732733D-06, .402506D-06,
     +  .194014D-06, .745897D-07, .181776D-07, .121184D-08,
     +  .000000D+00, .864469D+06, .654384D+06, .486900D+06,
     +  .362015D+06, .268978D+06, .199683D+06, .148131D+06,
     +  .109789D+06, .813065D+05, .601550D+05, .444675D+05,
     +  .328368D+05, .242255D+05, .178524D+05, .131425D+05,
     +  .966339D+04, .709745D+04, .520598D+04, .381401D+04,
     +  .279025D+04, .203867D+04, .148725D+04, .108348D+04,
     +  .788039D+03, .572307D+03, .414913D+03, .300438D+03,
     +  .216160D+03, .156022D+03, .112430D+03, .809134D+02,
     +  .581500D+02, .417454D+02, .299694D+02, .214902D+02,
     +  .154080D+02, .110542D+02, .793673D+01, .570820D+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .411255D+01, .297235D+01, .215407D+01, .156653D+01,
     +  .114321D+01, .837679D+00, .615923D+00, .455215D+00,
     +  .336821D+00, .250604D+00, .186550D+00, .139367D+00,
     +  .104273D+00, .781372D-01, .585803D-01, .439336D-01,
     +  .329185D-01, .246399D-01, .184061D-01, .137218D-01,
     +  .101956D-01, .755135D-02, .556807D-02, .408643D-02,
     +  .298664D-02, .216560D-02, .155870D-02, .111388D-02,
     +  .789370D-03, .554905D-03, .386412D-03, .266783D-03,
     +  .182372D-03, .123566D-03, .829416D-04, .555273D-04,
     +  .368729D-04, .244546D-04, .162075D-04, .107756D-04,
     +  .717325D-05, .478440D-05, .316888D-05, .206321D-05,
     +  .129945D-05, .774851D-06, .422462D-06, .200549D-06,
     +  .752923D-07, .178409D-07, .121130D-08, .000000D+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .111222D+07, .839366D+06, .622294D+06, .461010D+06,
     +  .341280D+06, .252425D+06, .186558D+06, .137750D+06,
     +  .101625D+06, .748994D+05, .551517D+05, .405668D+05,
     +  .298095D+05, .218793D+05, .160416D+05, .117467D+05,
     +  .859168D+04, .627552D+04, .457800D+04, .333475D+04,
     +  .242586D+04, .176189D+04, .127780D+04, .925146D+03,
     +  .668779D+03, .482575D+03, .347766D+03, .248985D+03,
     +  .178832D+03, .128225D+03, .918111D+02, .656416D+02,
     +  .468754D+02, .334730D+02, .238715D+02, .170207D+02,
     +  .121422D+02, .866816D+01, .619802D+01, .443924D+01,
     +  .318934D+01, .229746D+01, .166066D+01, .120453D+01,
     +  .877186D+00, .641003D+00, .470829D+00, .346222D+00,
     +  .256002D+00, .189389D+00, .140614D+00, .104560D+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .778701D-01, .580232D-01, .432483D-01, .322079D-01,
     +  .239613D-01, .177914D-01, .131833D-01, .973709D-02,
     +  .716872D-02, .525498D-02, .383409D-02, .278613D-02,
     +  .200879D-02, .143802D-02, .102235D-02, .721065D-03,
     +  .504722D-03, .350233D-03, .241170D-03, .164647D-03,
     +  .111596D-03, .751035D-04, .505304D-04, .338259D-04,
     +  .226781D-04, .152353D-04, .102810D-04, .694859D-05,
     +  .469456D-05, .313949D-05, .205309D-05, .129240D-05,
     +  .765788D-06, .412765D-06, .192536D-06, .705293D-07,
     +  .162583D-07, .112242D-08, .000000D+00, .140738D+07,
     +  .105890D+07, .782243D+06, .577416D+06, .425898D+06,
     +  .313854D+06, .231097D+06, .169997D+06, .124941D+06,
     +  .917311D+05, .672842D+05, .492976D+05, .360819D+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .263774D+05, .192613D+05, .140468D+05, .102316D+05,
     +  .744209D+04, .540602D+04, .392104D+04, .283997D+04,
     +  .205360D+04, .148272D+04, .106866D+04, .768985D+03,
     +  .552292D+03, .396124D+03, .282229D+03, .201721D+03,
     +  .143923D+03, .102532D+03, .729327D+02, .518107D+02,
     +  .368022D+02, .261042D+02, .185109D+02, .131317D+02,
     +  .932175D+01, .662716D+01, .471915D+01, .337053D+01,
     +  .241363D+01, .173421D+01, .125034D+01, .905040D+00,
     +  .657353D+00, .479912D+00, .350757D+00, .257776D+00,
     +  .189544D+00, .139874D+00, .103384D+00, .765290D-01,
     +  .566817D-01, .419941D-01, .310874D-01, .229899D-01,
     +  .169695D-01, .125000D-01, .917862D-02, .671828D-02,
     +  .489670D-02, .355240D-02, .256710D-02, .184079D-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .131094D-02, .927443D-03, .651221D-03, .454041D-03,
     +  .314078D-03, .215797D-03, .147196D-03, .998475D-04,
     +  .673913D-04, .455686D-04, .307350D-04, .208036D-04,
     +  .141329D-04, .964581D-05, .658809D-05, .448508D-05,
     +  .301231D-05, .196929D-05, .123409D-05, .724541D-06,
     +  .385303D-06, .176397D-06, .630359D-07, .141467D-07,
     +  .992279D-09, .000000D+00, .175535D+07, .131674D+07,
     +  .969260D+06, .712901D+06, .523927D+06, .384685D+06,
     +  .282205D+06, .206820D+06, .151431D+06, .110758D+06,
     +  .809277D+05, .590638D+05, .430602D+05, .313539D+05,
     +  .228034D+05, .165625D+05, .120144D+05, .870263D+04,
     +  .629512D+04, .454650D+04, .327879D+04, .236058D+04,
     +  .169682D+04, .121750D+04, .872103D+03, .623455D+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .445069D+03, .315574D+03, .224467D+03, .159369D+03,
     +  .112971D+03, .799521D+02, .565049D+02, .399276D+02,
     +  .281703D+02, .198682D+02, .140171D+02, .989498D+01,
     +  .699496D+01, .495265D+01, .351686D+01, .250375D+01,
     +  .178839D+01, .128180D+01, .922294D+00, .665895D+00,
     +  .483254D+00, .351089D+00, .256478D+00, .187463D+00,
     +  .137514D+00, .101039D+00, .743504D-01, .547440D-01,
     +  .403193D-01, .296731D-01, .218162D-01, .160101D-01,
     +  .117253D-01, .856080D-02, .623060D-02, .451606D-02,
     +  .325822D-02, .234190D-02, .167053D-02, .118382D-02,
     +  .833642D-03, .582935D-03, .404978D-03, .279373D-03,
     +  .191613D-03, .130646D-03, .887294D-04, .600764D-04,
     +  .408261D-04, .277306D-04, .189281D-04, .129768D-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .893262D-05, .614395D-05, .419934D-05, .282249D-05,
     +  .183906D-05, .114452D-05, .664657D-06, .348309D-06,
     +  .156409D-06, .545279D-07, .119237D-07, .849310D-09,
     +  .000000D+00, .216151D+07, .161660D+07, .118579D+07,
     +  .869056D+06, .636393D+06, .465568D+06, .340291D+06,
     +  .248467D+06, .181245D+06, .132064D+06, .961273D+05,
     +  .698868D+05, .507521D+05, .368094D+05, .266645D+05,
     +  .192890D+05, .139353D+05, .100524D+05, .724122D+04,
     +  .520776D+04, .373964D+04, .268073D+04, .191851D+04,
     +  .137046D+04, .977253D+03, .695426D+03, .494146D+03,
     +  .348703D+03, .246849D+03, .174413D+03, .123027D+03,
     +  .866348D+02, .609167D+02, .428238D+02, .300550D+02,
     +  .210847D+02, .147948D+02, .103867D+02, .730175D+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .514083D+01, .362972D+01, .256928D+01, .182458D+01,
     +  .130015D+01, .930035D+00, .667551D+00, .481622D+00,
     +  .347848D+00, .252619D+00, .183560D+00, .133864D+00,
     +  .977863D-01, .715388D-01, .523697D-01, .383478D-01,
     +  .280607D-01, .205130D-01, .149688D-01, .109009D-01,
     +  .791471D-02, .572863D-02, .412985D-02, .296369D-02,
     +  .211920D-02, .150410D-02, .106089D-02, .743834D-03,
     +  .518149D-03, .358815D-03, .246949D-03, .169150D-03,
     +  .115333D-03, .784561D-04, .532996D-04, .364002D-04,
     +  .248855D-04, .171100D-04, .118168D-04, .818469D-05,
     +  .565377D-05, .386917D-05, .259597D-05, .168238D-05,
     +  .103810D-05, .595637D-06, .307360D-06, .135331D-06,
     +  .460358D-07, .981700D-08, .709832D-09, .000000D+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .775341D+05, .460803D+05, .355832D+05, .274776D+05,
     +  .212185D+05, .163853D+05, .126532D+05, .977125D+04,
     +  .754586D+04, .582742D+04, .450044D+04, .347575D+04,
     +  .268447D+04, .207343D+04, .160157D+04, .123719D+04,
     +  .955793D+03, .738483D+03, .570658D+03, .441046D+03,
     +  .340943D+03, .263625D+03, .203904D+03, .157771D+03,
     +  .122131D+03, .945946D+02, .733157D+02, .566652D+02,
     +  .440022D+02, .342088D+02, .266318D+02, .207669D+02,
     +  .162245D+02, .127130D+02, .998121D+01, .786001D+01,
     +  .621024D+01, .492449D+01, .391987D+01, .313214D+01,
     +  .251312D+01, .202380D+01, .163537D+01, .132547D+01,
     +  .107695D+01, .876642D+00, .714973D+00, .582638D+00,
     +  .475242D+00, .386760D+00, .314446D+00, .255039D+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .206227D+00, .166143D+00, .133277D+00, .106390D+00,
     +  .844629D-01, .666506D-01, .522474D-01, .406623D-01,
     +  .313995D-01, .240421D-01, .182404D-01, .137203D-01,
     +  .101924D-01, .748393D-02, .542601D-02, .388006D-02,
     +  .273308D-02, .189364D-02, .128843D-02, .859270D-03,
     +  .560315D-03, .356142D-03, .221002D-03, .132492D-03,
     +  .766603D-04, .425813D-04, .225566D-04, .113015D-04,
     +  .529881D-05, .229603D-05, .896847D-06, .309982D-06,
     +  .908335D-07, .212466D-07, .358597D-08, .361347D-09,
     +  .142072D-10, .559081D-13, .000000D+00, .855431D+05,
     +  .666397D+05, .512734D+05, .394443D+05, .303433D+05,
     +  .233383D+05, .179498D+05, .138031D+05, .106139D+05,
     +  .816020D+04, .627349D+04, .482220D+04, .370651D+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .284849D+04, .218904D+04, .168201D+04, .129241D+04,
     +  .992925D+03, .762863D+03, .586056D+03, .450270D+03,
     +  .345940D+03, .265831D+03, .204292D+03, .157047D+03,
     +  .120761D+03, .929135D+02, .712580D+02, .549039D+02,
     +  .423387D+02, .326903D+02, .252742D+02, .195752D+02,
     +  .152021D+02, .118282D+02, .922858D+01, .722426D+01,
     +  .567465D+01, .447480D+01, .354187D+01, .281563D+01,
     +  .224656D+01, .179912D+01, .144535D+01, .116443D+01,
     +  .940029D+00, .760687D+00, .615146D+00, .498187D+00,
     +  .402627D+00, .325222D+00, .262137D+00, .210731D+00,
     +  .168829D+00, .134731D+00, .107020D+00, .845723D-01,
     +  .664453D-01, .518777D-01, .402216D-01, .309524D-01,
     +  .236248D-01, .178724D-01, .134095D-01, .993935D-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .728344D-02, .527182D-02, .376439D-02, .264877D-02,
     +  .183349D-02, .124664D-02, .830615D-03, .541079D-03,
     +  .343039D-03, .211982D-03, .125985D-03, .717091D-04,
     +  .385643D-04, .191566D-04, .837608D-05, .279051D-05,
     +  .208487D-06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .119395D+06, .927225D+05,
     +  .710854D+05, .544833D+05, .417548D+05, .319910D+05,
     +  .245079D+05, .187697D+05, .143735D+05, .110037D+05,
     +  .842297D+04, .644556D+04, .493179D+04, .377239D+04,
     +  .288523D+04, .220603D+04, .168655D+04, .128903D+04,
     +  .985123D+03, .752672D+03, .575062D+03, .439274D+03,
     +  .335567D+03, .256317D+03, .195815D+03, .149604D+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .114353D+03, .870989D+02, .666441D+02, .510238D+02,
     +  .391082D+02, .300082D+02, .230628D+02, .177694D+02,
     +  .137148D+02, .106127D+02, .823908D+01, .641732D+01,
     +  .501786D+01, .393803D+01, .310432D+01, .245622D+01,
     +  .195092D+01, .155465D+01, .124270D+01, .995549D+00,
     +  .799730D+00, .642088D+00, .516498D+00, .414683D+00,
     +  .332875D+00, .266697D+00, .213180D+00, .169863D+00,
     +  .134860D+00, .106596D+00, .838442D-01, .655804D-01,
     +  .509895D-01, .393766D-01, .301911D-01, .229650D-01,
     +  .173186D-01, .129573D-01, .958022D-02, .700487D-02,
     +  .506141D-02, .360962D-02, .253850D-02, .175756D-02,
     +  .119670D-02, .799621D-03, .523532D-03, .334548D-03,
     +  .209351D-03, .126865D-03, .745003D-04, .421358D-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .228458D-04, .117548D-04, .568594D-05, .253238D-05,
     +  .100413D-05, .326628D-06, .661236D-07, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .161621D+06, .125136D+06, .955990D+05,
     +  .730096D+05, .557492D+05, .425541D+05, .324765D+05,
     +  .247763D+05, .188983D+05, .144093D+05, .109844D+05,
     +  .837029D+04, .637700D+04, .485640D+04, .369765D+04,
     +  .281421D+04, .214143D+04, .162881D+04, .123869D+04,
     +  .941632D+03, .715726D+03, .543831D+03, .413190D+03,
     +  .313851D+03, .238401D+03, .181071D+03, .137579D+03,
     +  .104134D+03, .791751D+02, .602233D+02, .458520D+02,
     +  .349419D+02, .266666D+02, .203988D+02, .156292D+02,
     +  .120038D+02, .924859D+01, .714829D+01, .554628D+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .431889D+01, .337825D+01, .265237D+01, .209070D+01,
     +  .165355D+01, .131210D+01, .104362D+01, .832567D+00,
     +  .663933D+00, .530633D+00, .423359D+00, .337803D+00,
     +  .269081D+00, .213896D+00, .169529D+00, .133912D+00,
     +  .105330D+00, .824621D-01, .642104D-01, .497120D-01,
     +  .382335D-01, .292019D-01, .221317D-01, .166329D-01,
     +  .124046D-01, .914452D-02, .666820D-02, .480676D-02,
     +  .342118D-02, .240244D-02, .166188D-02, .113151D-02,
     +  .756846D-03, .496823D-03, .318968D-03, .201167D-03,
     +  .123427D-03, .739125D-04, .430828D-04, .244913D-04,
     +  .135650D-04, .737893D-05, .395570D-05, .211343D-05,
     +  .112869D-05, .602735D-06, .311563D-06, .149217D-06,
     +  .602331D-07, .160919D-07, .989881D-09, .000000D+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .175660D+06, .164807D+06, .125477D+06, .954959D+05,
     +  .726625D+05, .552652D+05, .420234D+05, .319403D+05,
     +  .242704D+05, .184338D+05, .139972D+05, .106232D+05,
     +  .806033D+04, .611274D+04, .463443D+04, .351185D+04,
     +  .266045D+04, .201442D+04, .152485D+04, .115369D+04,
     +  .872670D+03, .659800D+03, .498764D+03, .376886D+03,
     +  .284761D+03, .215103D+03, .162528D+03, .122305D+03,
     +  .924451D+02, .698934D+02, .528862D+02, .400474D+02,
     +  .303648D+02, .230741D+02, .175593D+02, .133931D+02,
     +  .102466D+02, .786329D+01, .605726D+01, .468272D+01,
     +  .363643D+01, .283454D+01, .221837D+01, .174217D+01,
     +  .137289D+01, .108458D+01, .859574D+00, .681059D+00,
     +  .540963D+00, .429000D+00, .340322D+00, .269569D+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .213130D+00, .168043D+00, .132075D+00, .103383D+00,
     +  .805613D-01, .624489D-01, .481400D-01, .368709D-01,
     +  .280495D-01, .211778D-01, .158582D-01, .117863D-01,
     +  .866048D-02, .629597D-02, .452582D-02, .321322D-02,
     +  .225170D-02, .155508D-02, .105778D-02, .707448D-03,
     +  .464908D-03, .299289D-03, .189705D-03, .117374D-03,
     +  .712266D-04, .423585D-04, .248044D-04, .143306D-04,
     +  .825707D-05, .476001D-05, .276342D-05, .160436D-05,
     +  .919177D-06, .499579D-06, .245447D-06, .992728D-07,
     +  .260530D-07, .165442D-08, .000000D+00, .299054D+06,
     +  .230002D+06, .174355D+06, .132115D+06, .100076D+06,
     +  .757714D+05, .573501D+05, .433857D+05, .328099D+05,
     +  .247992D+05, .187373D+05, .141495D+05, .106809D+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .805796D+04, .607672D+04, .457992D+04, .345040D+04,
     +  .259788D+04, .195520D+04, .147063D+04, .110574D+04,
     +  .830912D+03, .624178D+03, .468641D+03, .351767D+03,
     +  .263937D+03, .198058D+03, .147982D+03, .111046D+03,
     +  .833379D+02, .625816D+02, .470225D+02, .353698D+02,
     +  .266600D+02, .201197D+02, .152164D+02, .115414D+02,
     +  .877980D+01, .670362D+01, .513648D+01, .395334D+01,
     +  .305428D+01, .236926D+01, .184449D+01, .144104D+01,
     +  .112885D+01, .887321D+00, .697385D+00, .549627D+00,
     +  .432563D+00, .340628D+00, .267896D+00, .210348D+00,
     +  .164747D+00, .128649D+00, .100072D+00, .775083D-01,
     +  .597293D-01, .457805D-01, .348693D-01, .263835D-01,
     +  .198154D-01, .147611D-01, .109154D-01, .797979D-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .577167D-02, .412751D-02, .291487D-02, .203115D-02,
     +  .139419D-02, .941782D-03, .624714D-03, .406388D-03,
     +  .258191D-03, .160795D-03, .970491D-04, .568174D-04,
     +  .320507D-04, .173401D-04, .889283D-05, .427934D-05,
     +  .188284D-05, .729212D-06, .222139D-06, .345505D-07,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .407837D+06, .312526D+06,
     +  .235912D+06, .177994D+06, .134243D+06, .101193D+06,
     +  .762479D+05, .574200D+05, .432226D+05, .325165D+05,
     +  .244511D+05, .183749D+05, .138021D+05, .103606D+05,
     +  .777334D+04, .582829D+04, .436769D+04, .327087D+04,
     +  .244821D+04, .183119D+04, .136899D+04, .102276D+04,
     +  .763739D+03, .569956D+03, .425165D+03, .316990D+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .236332D+03, .175394D+03, .130724D+03, .974271D+02,
     +  .726421D+02, .541859D+02, .404548D+02, .302621D+02,
     +  .226607D+02, .170029D+02, .127926D+02, .965235D+01,
     +  .730898D+01, .555379D+01, .423885D+01, .324756D+01,
     +  .249823D+01, .192888D+01, .149470D+01, .116149D+01,
     +  .905814D+00, .706418D+00, .552566D+00, .431677D+00,
     +  .337497D+00, .263588D+00, .205564D+00, .159940D+00,
     +  .124094D+00, .959269D-01, .738449D-01, .565694D-01,
     +  .431079D-01, .326491D-01, .245682D-01, .183539D-01,
     +  .136012D-01, .100070D-01, .727969D-02, .524033D-02,
     +  .373052D-02, .262326D-02, .182074D-02, .124541D-02,
     +  .838861D-03, .555347D-03, .360989D-03, .229634D-03,
     +  .143593D-03, .874143D-04, .519707D-04, .301005D-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .170115D-04, .937265D-05, .507009D-05, .270168D-05,
     +  .143267D-05, .757660D-06, .399749D-06, .203785D-06,
     +  .961600D-07, .378823D-07, .973472D-08, .607524D-09,
     +  .000000D+00, .543953D+06, .415358D+06, .312239D+06,
     +  .234598D+06, .176185D+06, .132238D+06, .992062D+05,
     +  .743793D+05, .557375D+05, .417408D+05, .312423D+05,
     +  .233685D+05, .174693D+05, .130500D+05, .974293D+04,
     +  .726855D+04, .541929D+04, .403741D+04, .300603D+04,
     +  .223637D+04, .166277D+04, .123533D+04, .917235D+03,
     +  .680543D+03, .504657D+03, .373982D+03, .277103D+03,
     +  .204339D+03, .151316D+03, .112032D+03, .829683D+02,
     +  .614628D+02, .455641D+02, .338398D+02, .251536D+02,
     +  .187324D+02, .139865D+02, .104718D+02, .786748D+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .593111D+01, .449098D+01, .341347D+01, .260507D+01,
     +  .199557D+01, .153433D+01, .118312D+01, .915715D+00,
     +  .708816D+00, .550410D+00, .426919D+00, .331450D+00,
     +  .257104D+00, .199173D+00, .153963D+00, .118698D+00,
     +  .911869D-01, .697702D-01, .531314D-01, .402530D-01,
     +  .303140D-01, .226844D-01, .168549D-01, .124238D-01,
     +  .909340D-02, .658143D-02, .471436D-02, .334019D-02,
     +  .233824D-02, .161612D-02, .110132D-02, .739469D-03,
     +  .488436D-03, .317160D-03, .201934D-03, .126722D-03,
     +  .777418D-04, .468563D-04, .277563D-04, .162402D-04,
     +  .941663D-05, .546467D-05, .318477D-05, .186889D-05,
     +  .109419D-05, .627839D-06, .339204D-06, .163985D-06,
     +  .642372D-07, .160874D-07, .104872D-08, .000000D+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .712020D+06, .541813D+06, .405652D+06, .303536D+06,
     +  .227012D+06, .169671D+06, .126747D+06, .946178D+05,
     +  .705932D+05, .526315D+05, .392164D+05, .291990D+05,
     +  .217266D+05, .161540D+05, .120027D+05, .891094D+04,
     +  .661103D+04, .490057D+04, .363008D+04, .268664D+04,
     +  .198699D+04, .146827D+04, .108422D+04, .799943D+03,
     +  .589820D+03, .434549D+03, .320070D+03, .234575D+03,
     +  .172632D+03, .127008D+03, .934520D+02, .687735D+02,
     +  .506402D+02, .373522D+02, .275697D+02, .203853D+02,
     +  .151100D+02, .112297D+02, .837403D+01, .626555D+01,
     +  .470833D+01, .355155D+01, .268989D+01, .204502D+01,
     +  .156057D+01, .119443D+01, .917734D+00, .705252D+00,
     +  .543775D+00, .418836D+00, .322959D+00, .248849D+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .191519D+00, .147100D+00, .112695D+00, .860434D-01,
     +  .654377D-01, .495379D-01, .373126D-01, .279399D-01,
     +  .207911D-01, .153638D-01, .112637D-01, .820090D-02,
     +  .590475D-02, .420842D-02, .296729D-02, .206765D-02,
     +  .142297D-02, .965968D-03, .646490D-03, .426019D-03,
     +  .276327D-03, .176083D-03, .110875D-03, .685178D-04,
     +  .418161D-04, .252613D-04, .152019D-04, .915279D-05,
     +  .555782D-05, .340218D-05, .208923D-05, .126827D-05,
     +  .743622D-06, .404840D-06, .194373D-06, .746230D-07,
     +  .181788D-07, .121185D-08, .000000D+00, .916970D+06,
     +  .695410D+06, .518578D+06, .386477D+06, .287867D+06,
     +  .214269D+06, .159394D+06, .118486D+06, .880225D+05,
     +  .653412D+05, .484723D+05, .359295D+05, .266137D+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .196967D+05, .145667D+05, .107633D+05, .794692D+04,
     +  .586207D+04, .432075D+04, .318167D+04, .234104D+04,
     +  .172086D+04, .126398D+04, .927523D+03, .680115D+03,
     +  .498250D+03, .364883D+03, .265833D+03, .194468D+03,
     +  .142202D+03, .103982D+03, .760376D+02, .556262D+02,
     +  .407599D+02, .298822D+02, .219439D+02, .161519D+02,
     +  .119194D+02, .882469D+01, .655512D+01, .489014D+01,
     +  .366183D+01, .275318D+01, .207793D+01, .157423D+01,
     +  .119625D+01, .912637D+00, .696419D+00, .533272D+00,
     +  .407957D+00, .312475D+00, .239198D+00, .182909D+00,
     +  .139602D+00, .106288D+00, .806579D-01, .609749D-01,
     +  .458885D-01, .343639D-01, .255858D-01, .189330D-01,
     +  .139140D-01, .101457D-01, .734775D-02, .526290D-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .373200D-02, .261855D-02, .181621D-02, .124455D-02,
     +  .841614D-03, .561464D-03, .369150D-03, .239213D-03,
     +  .152583D-03, .964157D-04, .600121D-04, .370592D-04,
     +  .227835D-04, .140358D-04, .869763D-05, .544768D-05,
     +  .343482D-05, .215860D-05, .132961D-05, .782868D-06,
     +  .424158D-06, .200807D-06, .753159D-07, .178418D-07,
     +  .121130D-08, .000000D+00, .116399D+07, .879813D+06,
     +  .653527D+06, .485127D+06, .359903D+06, .266805D+06,
     +  .197662D+06, .146324D+06, .108246D+06, .800122D+05,
     +  .590997D+05, .436155D+05, .321636D+05, .236972D+05,
     +  .174454D+05, .128308D+05, .942889D+04, .692209D+04,
     +  .507734D+04, .372042D+04, .272374D+04, .199199D+04,
     +  .145555D+04, .106248D+04, .774895D+03, .564576D+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .411153D+03, .297819D+03, .216607D+03, .157459D+03,
     +  .114445D+03, .831762D+02, .604677D+02, .440260D+02,
     +  .320669D+02, .233928D+02, .171028D+02, .125352D+02,
     +  .921668D+01, .679872D+01, .503635D+01, .374480D+01,
     +  .279574D+01, .209524D+01, .157623D+01, .118944D+01,
     +  .901218D+00, .683013D+00, .519501D+00, .394784D+00,
     +  .300413D+00, .228491D+00, .173618D+00, .131689D+00,
     +  .996492D-01, .751654D-01, .564861D-01, .422626D-01,
     +  .314666D-01, .232962D-01, .171427D-01, .125294D-01,
     +  .908663D-02, .654594D-02, .466418D-02, .329074D-02,
     +  .229773D-02, .158639D-02, .108245D-02, .729262D-03,
     +  .485024D-03, .318232D-03, .206076D-03, .131615D-03,
     +  .834812D-04, .523385D-04, .326868D-04, .204159D-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .128283D-04, .812928D-05, .520353D-05, .334156D-05,
     +  .212482D-05, .131482D-05, .771678D-06, .413996D-06,
     +  .192721D-06, .705461D-07, .162589D-07, .112242D-08,
     +  .000000D+00, .145841D+07, .109877D+07, .813034D+06,
     +  .601193D+06, .444257D+06, .328032D+06, .242044D+06,
     +  .178450D+06, .131468D+06, .967713D+05, .711761D+05,
     +  .523029D+05, .384025D+05, .281693D+05, .206450D+05,
     +  .151153D+05, .110566D+05, .807923D+04, .589804D+04,
     +  .430100D+04, .313340D+04, .228022D+04, .165775D+04,
     +  .120386D+04, .873416D+03, .632962D+03, .458456D+03,
     +  .330225D+03, .238827D+03, .172618D+03, .124731D+03,
     +  .901135D+02, .651137D+02, .471171D+02, .341026D+02,
     +  .247190D+02, .179550D+02, .130733D+02, .954836D+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .699606D+01, .514744D+01, .380138D+01, .281862D+01,
     +  .209801D+01, .156760D+01, .117494D+01, .884283D+00,
     +  .665721D+00, .503032D+00, .379787D+00, .287154D+00,
     +  .217033D+00, .163888D+00, .123548D+00, .929246D-01,
     +  .696763D-01, .520541D-01, .387217D-01, .286657D-01,
     +  .211035D-01, .154431D-01, .112258D-01, .809742D-02,
     +  .580260D-02, .411314D-02, .288744D-02, .200647D-02,
     +  .137905D-02, .937090D-03, .629071D-03, .417197D-03,
     +  .273239D-03, .176882D-03, .113157D-03, .720686D-04,
     +  .455156D-04, .287344D-04, .182056D-04, .116318D-04,
     +  .750060D-05, .487481D-05, .316553D-05, .202310D-05,
     +  .125072D-05, .728859D-06, .386194D-06, .176529D-06,
     +  .630477D-07, .141472D-07, .992282D-09, .000000D+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .180566D+07, .135606D+07, .999617D+06, .736342D+06,
     +  .542026D+06, .398661D+06, .292997D+06, .215153D+06,
     +  .157866D+06, .115726D+06, .847641D+05, .620261D+05,
     +  .453475D+05, .331201D+05, .241671D+05, .176155D+05,
     +  .128275D+05, .933043D+04, .677987D+04, .492080D+04,
     +  .356781D+04, .258374D+04, .186914D+04, .135056D+04,
     +  .974858D+03, .702799D+03, .506349D+03, .362734D+03,
     +  .260903D+03, .187525D+03, .134733D+03, .967783D+02,
     +  .695180D+02, .500038D+02, .359713D+02, .259122D+02,
     +  .187032D+02, .135314D+02, .981916D+01, .714765D+01,
     +  .522446D+01, .383282D+01, .282313D+01, .208747D+01,
     +  .154943D+01, .115368D+01, .862630D+00, .645202D+00,
     +  .484406D+00, .363399D+00, .273041D+00, .205091D+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .153924D+00, .115338D+00, .862329D-01, .642790D-01,
     +  .477434D-01, .353120D-01, .259938D-01, .190299D-01,
     +  .138492D-01, .100128D-01, .718393D-02, .512114D-02,
     +  .361152D-02, .252280D-02, .174483D-02, .119396D-02,
     +  .808099D-03, .540648D-03, .357630D-03, .233883D-03,
     +  .151415D-03, .970649D-04, .620953D-04, .395075D-04,
     +  .251995D-04, .161720D-04, .104778D-04, .684770D-05,
     +  .449712D-05, .293842D-05, .187935D-05, .115684D-05,
     +  .667815D-06, .348953D-06, .156504D-06, .545362D-07,
     +  .119240D-07, .849312D-09, .000000D+00, .221111D+07,
     +  .165536D+07, .121571D+07, .892165D+06, .654237D+06,
     +  .479346D+06, .350929D+06, .256681D+06, .187588D+06,
     +  .136961D+06, .999088D+05, .728067D+05, .530066D+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .385501D+05, .280085D+05, .203267D+05, .147364D+05,
     +  .106710D+05, .771877D+04, .557645D+04, .402427D+04,
     +  .290046D+04, .208814D+04, .150141D+04, .107834D+04,
     +  .773447D+03, .554374D+03, .395027D+03, .282615D+03,
     +  .202030D+03, .144353D+03, .103106D+03, .736392D+02,
     +  .526608D+02, .376583D+02, .269644D+02, .193438D+02,
     +  .139084D+02, .100295D+02, .725466D+01, .526890D+01,
     +  .384066D+01, .281071D+01, .206492D+01, .152283D+01,
     +  .112660D+01, .837032D+00, .622082D+00, .464121D+00,
     +  .346011D+00, .258377D+00, .192898D+00, .143903D+00,
     +  .107189D+00, .796696D-01, .590423D-01, .436026D-01,
     +  .320670D-01, .234731D-01, .170898D-01, .123697D-01,
     +  .889531D-02, .634844D-02, .450223D-02, .315905D-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .219605D-02, .151188D-02, .103017D-02, .694601D-03,
     +  .463257D-03, .305738D-03, .199729D-03, .129366D-03,
     +  .831358D-04, .534372D-04, .342503D-04, .220591D-04,
     +  .143183D-04, .938439D-05, .619539D-05, .409622D-05,
     +  .268349D-05, .171248D-05, .104720D-05, .597944D-06,
     +  .307824D-06, .135398D-06, .460416D-07, .981722D-08,
     +  .709834D-09, .000000D+00, .628438D+05, .921917D+05,
     +  .711919D+05, .549760D+05, .424542D+05, .327849D+05,
     +  .253183D+05, .195525D+05, .151002D+05, .116620D+05,
     +  .900700D+04, .695673D+04, .537344D+04, .415076D+04,
     +  .320653D+04, .247733D+04, .191417D+04, .147923D+04,
     +  .114331D+04, .883853D+03, .683445D+03, .528635D+03,
     +  .409041D+03, .316643D+03, .245247D+03, .190073D+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .147427D+03, .114048D+03, .886548D+02, .690093D+02,
     +  .538042D+02, .420300D+02, .329067D+02, .258505D+02,
     +  .203582D+02, .160909D+02, .127698D+02, .101794D+02,
     +  .815337D+01, .656276D+01, .531066D+01, .431857D+01,
     +  .352850D+01, .289542D+01, .238479D+01, .197019D+01,
     +  .163248D+01, .135296D+01, .112315D+01, .930968D+00,
     +  .771268D+00, .637673D+00, .525749D+00, .431939D+00,
     +  .353364D+00, .287662D+00, .232874D+00, .187354D+00,
     +  .149706D+00, .118735D+00, .934124D-01, .728491D-01,
     +  .562764D-01, .430846D-01, .325695D-01, .243275D-01,
     +  .179366D-01, .130392D-01, .933427D-02, .657058D-02,
     +  .454060D-02, .307464D-02, .203510D-02, .131266D-02,
     +  .826287D-03, .502403D-03, .294741D-03, .165953D-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .890890D-04, .452234D-04, .214774D-04, .942422D-05,
     +  .372718D-05, .130400D-05, .386704D-06, .915220D-07,
     +  .156264D-07, .159261D-08, .633211D-10, .251936D-12,
     +  .000000D+00, .143864D+06, .112214D+06, .864673D+05,
     +  .666227D+05, .513316D+05, .395470D+05, .304673D+05,
     +  .234705D+05, .180802D+05, .139269D+05, .107276D+05,
     +  .826267D+04, .636417D+04, .490164D+04, .377531D+04,
     +  .290771D+04, .223962D+04, .172505D+04, .132884D+04,
     +  .102371D+04, .788780D+03, .607861D+03, .468574D+03,
     +  .361308D+03, .278723D+03, .215119D+03, .166152D+03,
     +  .127962D+03, .990248D+02, .767220D+02, .595335D+02,
     +  .462766D+02, .360491D+02, .281721D+02, .220690D+02,
     +  .173477D+02, .136908D+02, .108512D+02, .864120D+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .691419D+01, .556172D+01, .449535D+01, .365065D+01,
     +  .297731D+01, .243736D+01, .200135D+01, .164839D+01,
     +  .135793D+01, .112070D+01, .923532D+00, .760766D+00,
     +  .625472D+00, .512872D+00, .419101D+00, .341067D+00,
     +  .276225D+00, .222490D+00, .178116D+00, .141638D+00,
     +  .111804D+00, .875514D-01, .679701D-01, .522722D-01,
     +  .398452D-01, .299907D-01, .223057D-01, .163766D-01,
     +  .118554D-01, .845164D-02, .592455D-02, .407701D-02,
     +  .274873D-02, .181133D-02, .116244D-02, .727626D-03,
     +  .439310D-03, .255322D-03, .141796D-03, .744635D-04,
     +  .363851D-04, .160507D-04, .600714D-05, .151656D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .177055D+06, .137780D+06, .105880D+06, .813535D+05,
     +  .625050D+05, .480159D+05, .368834D+05, .283275D+05,
     +  .217551D+05, .167050D+05, .128265D+05, .984703D+04,
     +  .755931D+04, .580227D+04, .445350D+04, .341784D+04,
     +  .262302D+04, .201285D+04, .154468D+04, .118536D+04,
     +  .909727D+03, .698220D+03, .536004D+03, .411545D+03,
     +  .316101D+03, .242880D+03, .186749D+03, .143147D+03,
     +  .110251D+03, .850032D+02, .656322D+02, .507572D+02,
     +  .393342D+02, .305761D+02, .238227D+02, .186225D+02,
     +  .146144D+02, .115168D+02, .911818D+01, .725288D+01,
     +  .579970D+01, .465970D+01, .376151D+01, .304933D+01,
     +  .248146D+01, .202544D+01, .165849D+01, .135826D+01,
     +  .111458D+01, .913289D+00, .748161D+00, .611753D+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .498945D+00, .405584D+00, .328373D+00, .264604D+00,
     +  .212075D+00, .168953D+00, .133713D+00, .105054D+00,
     +  .818894D-01, .632904D-01, .484581D-01, .367792D-01,
     +  .275655D-01, .204167D-01, .149289D-01, .107649D-01,
     +  .764539D-02, .534025D-02, .366284D-02, .246229D-02,
     +  .161886D-02, .103727D-02, .649109D-03, .392536D-03,
     +  .229243D-03, .128592D-03, .688571D-04, .348963D-04,
     +  .165594D-04, .725065D-05, .284599D-05, .962267D-06,
     +  .251658D-06, .303135D-07, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .218641D+06,
     +  .169694D+06, .130007D+06, .995816D+05, .762690D+05,
     +  .584012D+05, .447147D+05, .342280D+05, .261980D+05,
     +  .200473D+05, .153391D+05, .117340D+05, .897534D+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .686375D+04, .524851D+04, .401257D+04, .306750D+04,
     +  .234460D+04, .179203D+04, .136951D+04, .104667D+04,
     +  .799895D+03, .611393D+03, .467346D+03, .357341D+03,
     +  .273299D+03, .209157D+03, .159546D+03, .122283D+03,
     +  .938096D+02, .720651D+02, .554438D+02, .427399D+02,
     +  .330455D+02, .256065D+02, .199059D+02, .155340D+02,
     +  .121716D+02, .958122D+01, .757684D+01, .602340D+01,
     +  .481102D+01, .386086D+01, .311149D+01, .251729D+01,
     +  .204276D+01, .166312D+01, .135428D+01, .110514D+01,
     +  .900544D+00, .733729D+00, .596759D+00, .484175D+00,
     +  .391559D+00, .315424D+00, .252914D+00, .201721D+00,
     +  .159937D+00, .125984D+00, .985257D-01, .764526D-01,
     +  .588266D-01, .448426D-01, .338893D-01, .252917D-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .186544D-01, .135845D-01, .975649D-02, .690255D-02,
     +  .480363D-02, .328341D-02, .220032D-02, .144287D-02,
     +  .922677D-03, .576897D-03, .349128D-03, .204593D-03,
     +  .115646D-03, .628572D-04, .327308D-04, .163181D-04,
     +  .780523D-05, .360354D-05, .163846D-05, .750090D-06,
     +  .345544D-06, .154855D-06, .607940D-07, .161141D-07,
     +  .989981D-09, .000000D+00, .161592D+06, .208879D+06,
     +  .159510D+06, .121778D+06, .929586D+05, .709395D+05,
     +  .541281D+05, .412889D+05, .314905D+05, .240104D+05,
     +  .183043D+05, .139503D+05, .106303D+05, .809821D+04,
     +  .616838D+04, .469715D+04, .357642D+04, .272240D+04,
     +  .207216D+04, .157689D+04, .120000D+04, .913063D+03,
     +  .694794D+03, .528695D+03, .402390D+03, .306310D+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .233308D+03, .177095D+03, .135065D+03, .103096D+03,
     +  .787950D+02, .603069D+02, .462436D+02, .355633D+02,
     +  .274078D+02, .211888D+02, .164429D+02, .128111D+02,
     +  .100273D+02, .788413D+01, .623171D+01, .494870D+01,
     +  .394848D+01, .316381D+01, .254503D+01, .205355D+01,
     +  .166257D+01, .134629D+01, .109265D+01, .885555D+00,
     +  .717699D+00, .580680D+00, .468721D+00, .377156D+00,
     +  .302322D+00, .241231D+00, .191484D+00, .151107D+00,
     +  .118477D+00, .922333D-01, .712494D-01, .545819D-01,
     +  .414255D-01, .311731D-01, .231659D-01, .170150D-01,
     +  .123398D-01, .882693D-02, .622054D-02, .431272D-02,
     +  .293737D-02, .196198D-02, .128297D-02, .818573D-03,
     +  .511150D-03, .309385D-03, .181750D-03, .103357D-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .568491D-04, .302319D-04, .156201D-04, .790711D-05,
     +  .397160D-05, .201414D-05, .103651D-05, .526376D-06,
     +  .249847D-06, .997067D-07, .260701D-07, .165450D-08,
     +  .000000D+00, .354658D+06, .273452D+06, .207908D+06,
     +  .158026D+06, .120086D+06, .912247D+05, .692842D+05,
     +  .526026D+05, .399282D+05, .302972D+05, .229838D+05,
     +  .174297D+05, .132147D+05, .100155D+05, .758905D+04,
     +  .574851D+04, .435345D+04, .329587D+04, .249478D+04,
     +  .188786D+04, .142844D+04, .108059D+04, .817427D+03,
     +  .618290D+03, .467716D+03, .353833D+03, .267816D+03,
     +  .201973D+03, .153038D+03, .116045D+03, .880974D+02,
     +  .669684D+02, .509964D+02, .389446D+02, .298006D+02,
     +  .228733D+02, .176213D+02, .136287D+02, .105886D+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .826376D+01, .648327D+01, .511025D+01, .404710D+01,
     +  .321891D+01, .257035D+01, .205890D+01, .165496D+01,
     +  .133056D+01, .107235D+01, .863091D+00, .694745D+00,
     +  .558359D+00, .447746D+00, .357957D+00, .285113D+00,
     +  .226081D+00, .178354D+00, .139894D+00, .109032D+00,
     +  .843802D-01, .648040D-01, .493598D-01, .372477D-01,
     +  .278708D-01, .205940D-01, .150399D-01, .108448D-01,
     +  .771248D-02, .540290D-02, .372287D-02, .251924D-02,
     +  .167100D-02, .108433D-02, .685698D-03, .423652D-03,
     +  .252970D-03, .145918D-03, .808572D-04, .427786D-04,
     +  .214129D-04, .100261D-04, .431683D-05, .165446D-05,
     +  .532743D-06, .122507D-06, .300405D-08, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .462658D+06, .355365D+06, .268993D+06, .203541D+06,
     +  .153972D+06, .116429D+06, .880141D+05, .665073D+05,
     +  .502408D+05, .379372D+05, .286378D+05, .216089D+05,
     +  .163002D+05, .122905D+05, .926440D+04, .698044D+04,
     +  .525803D+04, .395903D+04, .298018D+04, .224253D+04,
     +  .168713D+04, .126891D+04, .954245D+03, .717474D+03,
     +  .539456D+03, .405592D+03, .305078D+03, .228595D+03,
     +  .172094D+03, .129642D+03, .977670D+02, .738192D+02,
     +  .558294D+02, .423417D+02, .321734D+02, .245201D+02,
     +  .187552D+02, .144015D+02, .111080D+02, .860622D+01,
     +  .670285D+01, .524493D+01, .412361D+01, .325607D+01,
     +  .258137D+01, .205299D+01, .163861D+01, .130821D+01,
     +  .104710D+01, .837031D+00, .669259D+00, .534332D+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .425696D+00, .338154D+00, .267642D+00, .210909D+00,
     +  .165364D+00, .128921D+00, .998784D-01, .768404D-01,
     +  .586692D-01, .444300D-01, .333354D-01, .248024D-01,
     +  .182233D-01, .132342D-01, .948998D-02, .671217D-02,
     +  .467693D-02, .320580D-02, .215843D-02, .142492D-02,
     +  .920718D-03, .580181D-03, .357620D-03, .213443D-03,
     +  .123441D-03, .689395D-04, .370860D-04, .191664D-04,
     +  .952330D-05, .456933D-05, .213505D-05, .990797D-06,
     +  .464963D-06, .218325D-06, .984888D-07, .381069D-07,
     +  .974347D-08, .607570D-09, .000000D+00, .598003D+06,
     +  .457595D+06, .344856D+06, .259787D+06, .195636D+06,
     +  .147260D+06, .110807D+06, .833390D+05, .626571D+05,
     +  .470853D+05, .353703D+05, .265571D+05, .199323D+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .149528D+05, .112130D+05, .840449D+04, .629711D+04,
     +  .471588D+04, .353051D+04, .264191D+04, .197641D+04,
     +  .147799D+04, .110503D+04, .825956D+03, .617308D+03,
     +  .461303D+03, .344847D+03, .256756D+03, .192068D+03,
     +  .143757D+03, .107704D+03, .807839D+02, .606866D+02,
     +  .457139D+02, .344971D+02, .261089D+02, .198307D+02,
     +  .151201D+02, .115797D+02, .890794D+01, .688849D+01,
     +  .535187D+01, .417780D+01, .327556D+01, .257858D+01,
     +  .203646D+01, .161423D+01, .127989D+01, .101753D+01,
     +  .807950D+00, .641750D+00, .509041D+00, .402947D+00,
     +  .318060D+00, .250166D+00, .195923D+00, .152679D+00,
     +  .118315D+00, .911161D-01, .696866D-01, .528973D-01,
     +  .398282D-01, .297112D-01, .219805D-01, .160584D-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .115964D-01, .826929D-02, .581665D-02, .403106D-02,
     +  .274855D-02, .184121D-02, .120976D-02, .778398D-03,
     +  .488813D-03, .300644D-03, .179405D-03, .104068D-03,
     +  .585998D-04, .320489D-04, .170615D-04, .890811D-05,
     +  .461470D-05, .240090D-05, .126878D-05, .676080D-06,
     +  .349824D-06, .165663D-06, .643971D-07, .160936D-07,
     +  .104876D-08, .000000D+00, .765310D+06, .583457D+06,
     +  .437810D+06, .328370D+06, .246190D+06, .184482D+06,
     +  .138185D+06, .103452D+06, .774156D+05, .579009D+05,
     +  .432863D+05, .323428D+05, .241551D+05, .180301D+05,
     +  .134521D+05, .100309D+05, .747649D+04, .556949D+04,
     +  .414716D+04, .308644D+04, .229620D+04, .170748D+04,
     +  .126934D+04, .943275D+03, .700849D+03, .520601D+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .386820D+03, .286214D+03, .212770D+03, .158246D+03,
     +  .117799D+03, .877824D+02, .655100D+02, .490198D+02,
     +  .367430D+02, .276199D+02, .208347D+02, .157763D+02,
     +  .119985D+02, .916606D+01, .703882D+01, .543066D+01,
     +  .420988D+01, .327791D+01, .256268D+01, .201008D+01,
     +  .158256D+01, .124633D+01, .984289D+00, .776409D+00,
     +  .612696D+00, .482882D+00, .379820D+00, .297932D+00,
     +  .232886D+00, .181275D+00, .140410D+00, .108157D+00,
     +  .827999D-01, .629550D-01, .475099D-01, .355661D-01,
     +  .263795D-01, .194049D-01, .140963D-01, .101222D-01,
     +  .717774D-02, .502107D-02, .346090D-02, .234740D-02,
     +  .156457D-02, .102320D-02, .655652D-03, .410388D-03,
     +  .251923D-03, .150358D-03, .875208D-04, .497044D-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .276252D-04, .151077D-04, .821481D-05, .449463D-05,
     +  .249133D-05, .139874D-05, .779234D-06, .412580D-06,
     +  .195580D-06, .747367D-07, .181832D-07, .121187D-08,
     +  .000000D+00, .969512D+06, .736468D+06, .550285D+06,
     +  .410962D+06, .306776D+06, .228872D+06, .170671D+06,
     +  .127196D+06, .947491D+05, .705366D+05, .524850D+05,
     +  .390291D+05, .290080D+05, .215464D+05, .159957D+05,
     +  .118675D+05, .880019D+04, .652155D+04, .483053D+04,
     +  .357582D+04, .264585D+04, .195666D+04, .144645D+04,
     +  .106879D+04, .789536D+03, .583044D+03, .430647D+03,
     +  .316697D+03, .233994D+03, .172955D+03, .127940D+03,
     +  .947339D+02, .702425D+02, .522199D+02, .388841D+02,
     +  .290354D+02, .217560D+02, .163630D+02, .123606D+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .937865D+01, .715316D+01, .548141D+01, .422040D+01,
     +  .326391D+01, .253457D+01, .197472D+01, .154443D+01,
     +  .120827D+01, .948016D+00, .742953D+00, .582547D+00,
     +  .456221D+00, .356606D+00, .277993D+00, .215971D+00,
     +  .167090D+00, .128647D+00, .985074D-01, .749684D-01,
     +  .566678D-01, .425177D-01, .316463D-01, .233377D-01,
     +  .170699D-01, .123298D-01, .880389D-02, .620819D-02,
     +  .431899D-02, .296096D-02, .199784D-02, .132498D-02,
     +  .862557D-03, .550542D-03, .343560D-03, .210569D-03,
     +  .125759D-03, .734945D-04, .421133D-04, .237779D-04,
     +  .133261D-04, .749340D-05, .426761D-05, .246186D-05,
     +  .142690D-05, .809101D-06, .429788D-06, .201674D-06,
     +  .753966D-07, .178449D-07, .121132D-08, .000000D+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .121579D+07, .920294D+06, .684787D+06, .509268D+06,
     +  .378545D+06, .281203D+06, .208781D+06, .154912D+06,
     +  .114878D+06, .851346D+05, .630560D+05, .466715D+05,
     +  .345243D+05, .255209D+05, .188543D+05, .139194D+05,
     +  .102701D+05, .757225D+04, .557990D+04, .410897D+04,
     +  .302422D+04, .222443D+04, .163541D+04, .120171D+04,
     +  .882721D+03, .648122D+03, .475936D+03, .347914D+03,
     +  .255523D+03, .187726D+03, .138014D+03, .101559D+03,
     +  .748295D+02, .552773D+02, .408961D+02, .303401D+02,
     +  .225850D+02, .168750D+02, .126633D+02, .954467D+01,
     +  .723153D+01, .550472D+01, .421026D+01, .323455D+01,
     +  .249524D+01, .193132D+01, .150069D+01, .116644D+01,
     +  .909338D+00, .708098D+00, .551721D+00, .429387D+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .333559D+00, .258438D+00, .199562D+00, .153468D+00,
     +  .117456D+00, .894079D-01, .676451D-01, .508354D-01,
     +  .379219D-01, .280642D-01, .205779D-01, .149662D-01,
     +  .107491D-01, .763224D-02, .535215D-02, .370314D-02,
     +  .252522D-02, .169508D-02, .111873D-02, .725080D-03,
     +  .461079D-03, .286957D-03, .175676D-03, .105045D-03,
     +  .616712D-04, .356695D-04, .204513D-04, .117189D-04,
     +  .677517D-05, .397502D-05, .235303D-05, .138720D-05,
     +  .790961D-06, .418082D-06, .193342D-06, .706032D-07,
     +  .162611D-07, .112244D-08, .000000D+00, .150948D+07,
     +  .113868D+07, .843855D+06, .624994D+06, .462637D+06,
     +  .342226D+06, .253007D+06, .186917D+06, .138007D+06,
     +  .101822D+06, .750767D+05, .553159D+05, .407298D+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .299672D+05, .220341D+05, .161885D+05, .118860D+05,
     +  .872019D+04, .639347D+04, .468403D+04, .342959D+04,
     +  .250932D+04, .183501D+04, .134106D+04, .979661D+03,
     +  .715267D+03, .522264D+03, .379553D+03, .277135D+03,
     +  .202400D+03, .147911D+03, .108182D+03, .792199D+02,
     +  .581584D+02, .427578D+02, .315208D+02, .233143D+02,
     +  .173084D+02, .129048D+02, .966394D+01, .727452D+01,
     +  .550158D+01, .418061D+01, .319102D+01, .244579D+01,
     +  .188089D+01, .145220D+01, .112156D+01, .868851D+00,
     +  .672325D+00, .520598D+00, .402674D+00, .310900D+00,
     +  .239425D+00, .183771D+00, .140485D+00, .106885D+00,
     +  .808848D-01, .608407D-01, .454580D-01, .337162D-01,
     +  .248097D-01, .180882D-01, .130814D-01, .934253D-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .659654D-02, .460042D-02, .316582D-02, .214746D-02,
     +  .143424D-02, .942118D-03, .608039D-03, .385324D-03,
     +  .239253D-03, .146375D-03, .876807D-04, .517430D-04,
     +  .302169D-04, .175840D-04, .102785D-04, .607960D-05,
     +  .364631D-05, .219446D-05, .130446D-05, .743002D-06,
     +  .389154D-06, .176973D-06, .630880D-07, .141487D-07,
     +  .992292D-09, .000000D+00, .185601D+07, .139540D+07,
     +  .103000D+07, .759808D+06, .560148D+06, .412656D+06,
     +  .303805D+06, .223500D+06, .164312D+06, .120705D+06,
     +  .886097D+05, .649966D+05, .476420D+05, .348927D+05,
     +  .255365D+05, .186736D+05, .136451D+05, .996228D+04,
     +  .726824D+04, .529836D+04, .385975D+04, .280954D+04,
     +  .204383D+04, .148576D+04, .107953D+04, .783871D+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .569186D+03, .411297D+03, .298604D+03, .216822D+03,
     +  .157524D+03, .114532D+03, .833671D+02, .608337D+02,
     +  .444511D+02, .325671D+02, .239386D+02, .176608D+02,
     +  .130849D+02, .973706D+01, .728326D+01, .547336D+01,
     +  .413284D+01, .313463D+01, .238741D+01, .182443D+01,
     +  .139981D+01, .107433D+01, .827116D+00, .636075D+00,
     +  .489515D+00, .376334D+00, .288812D+00, .221086D+00,
     +  .168687D+00, .128194D+00, .969625D-01, .729499D-01,
     +  .545554D-01, .405281D-01, .298884D-01, .218686D-01,
     +  .158537D-01, .114012D-01, .809709D-02, .568555D-02,
     +  .394349D-02, .269926D-02, .182152D-02, .121056D-02,
     +  .791575D-03, .508844D-03, .321455D-03, .199214D-03,
     +  .121861D-03, .731695D-04, .434263D-04, .256102D-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .151154D-04, .899287D-05, .541871D-05, .330252D-05,
     +  .200774D-05, .119665D-05, .678168D-06, .351092D-06,
     +  .156821D-06, .545647D-07, .119251D-07, .849319D-09,
     +  .000000D+00, .226075D+07, .169415D+07, .124567D+07,
     +  .915300D+06, .672102D+06, .493143D+06, .361584D+06,
     +  .264910D+06, .193943D+06, .141870D+06, .103700D+06,
     +  .757352D+05, .552687D+05, .402976D+05, .293585D+05,
     +  .213698D+05, .155424D+05, .112938D+05, .820016D+04,
     +  .594859D+04, .431200D+04, .312299D+04, .226028D+04,
     +  .163461D+04, .118145D+04, .853293D+03, .616245D+03,
     +  .442828D+03, .319709D+03, .230842D+03, .166753D+03,
     +  .120543D+03, .872299D+02, .632779D+02, .459615D+02,
     +  .334713D+02, .244542D+02, .179314D+02, .132041D+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .976532D+01, .725937D+01, .542171D+01, .406852D+01,
     +  .306677D+01, .232129D+01, .176295D+01, .134434D+01,
     +  .102541D+01, .784649D+00, .599744D+00, .458771D+00,
     +  .350585D+00, .267449D+00, .203521D+00, .154372D+00,
     +  .116630D+00, .877041D-01, .656040D-01, .487804D-01,
     +  .360317D-01, .264219D-01, .192235D-01, .138579D-01,
     +  .991045D-02, .699933D-02, .488781D-02, .337192D-02,
     +  .229590D-02, .154148D-02, .101956D-02, .663773D-03,
     +  .425101D-03, .267804D-03, .165720D-03, .101411D-03,
     +  .610691D-04, .364682D-04, .217194D-04, .129902D-04,
     +  .784844D-05, .479968D-05, .295865D-05, .180847D-05,
     +  .107663D-05, .605505D-06, .309367D-06, .135624D-06,
     +  .460617D-07, .981798D-08, .709839D-09, .000000D+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .627884D+05, .921696D+05, .711720D+05, .549582D+05,
     +  .424382D+05, .327706D+05, .253054D+05, .195410D+05,
     +  .150899D+05, .116528D+05, .899870D+04, .694929D+04,
     +  .536677D+04, .414477D+04, .320116D+04, .247250D+04,
     +  .190984D+04, .147534D+04, .113982D+04, .880716D+03,
     +  .680623D+03, .526096D+03, .406753D+03, .314580D+03,
     +  .243384D+03, .188388D+03, .145900D+03, .112662D+03,
     +  .873925D+02, .678557D+02, .527461D+02, .410556D+02,
     +  .320053D+02, .250125D+02, .195754D+02, .153560D+02,
     +  .120766D+02, .952289D+01, .752952D+01, .596855D+01,
     +  .474402D+01, .377839D+01, .301440D+01, .240762D+01,
     +  .192394D+01, .153714D+01, .122803D+01, .978095D+00,
     +  .778234D+00, .616411D+00, .486791D+00, .382707D+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .299338D+00, .232779D+00, .179859D+00, .137990D+00,
     +  .105052D+00, .793069D-01, .593293D-01, .439499D-01,
     +  .322129D-01, .233401D-01, .167012D-01, .118085D-01,
     +  .820907D-02, .561474D-02, .377212D-02, .248439D-02,
     +  .160043D-02, .100563D-02, .614259D-03, .363188D-03,
     +  .206643D-03, .112215D-03, .579145D-04, .276818D-04,
     +  .119668D-04, .440972D-05, .115720D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .143837D+06,
     +  .112190D+06, .864459D+05, .666035D+05, .513144D+05,
     +  .395316D+05, .304535D+05, .234581D+05, .180691D+05,
     +  .139169D+05, .107186D+05, .825465D+04, .635698D+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .489520D+04, .376952D+04, .290252D+04, .223496D+04,
     +  .172087D+04, .132509D+04, .102033D+04, .785742D+03,
     +  .605127D+03, .466111D+03, .359088D+03, .276718D+03,
     +  .213306D+03, .164509D+03, .126473D+03, .976692D+02,
     +  .754844D+02, .583997D+02, .452341D+02, .350867D+02,
     +  .272795D+02, .212376D+02, .165699D+02, .129600D+02,
     +  .101621D+02, .798959D+01, .629688D+01, .497643D+01,
     +  .394077D+01, .312615D+01, .248284D+01, .197321D+01,
     +  .156804D+01, .124630D+01, .987643D+00, .782138D+00,
     +  .616690D+00, .484952D+00, .379743D+00, .295938D+00,
     +  .229370D+00, .176705D+00, .135221D+00, .102724D+00,
     +  .774183D-01, .578524D-01, .428326D-01, .314005D-01,
     +  .227748D-01, .163287D-01, .115813D-01, .808753D-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .556514D-02, .376907D-02, .250836D-02, .163793D-02,
     +  .104697D-02, .653752D-03, .397313D-03, .234188D-03,
     +  .132759D-03, .722971D-04, .367992D-04, .170271D-04,
     +  .651790D-05, .131766D-05, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .177026D+06, .137755D+06,
     +  .105857D+06, .813329D+05, .624865D+05, .479994D+05,
     +  .368686D+05, .283142D+05, .217432D+05, .166943D+05,
     +  .128169D+05, .983843D+04, .755160D+04, .579535D+04,
     +  .444730D+04, .341227D+04, .261802D+04, .200836D+04,
     +  .154065D+04, .118174D+04, .906471D+03, .695291D+03,
     +  .533365D+03, .409167D+03, .313955D+03, .240939D+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .184991D+03, .141555D+03, .108803D+03, .836825D+02,
     +  .644238D+02, .496480D+02, .383121D+02, .296303D+02,
     +  .229442D+02, .178033D+02, .138477D+02, .107969D+02,
     +  .844061D+01, .661425D+01, .519748D+01, .409235D+01,
     +  .322809D+01, .254950D+01, .201518D+01, .159283D+01,
     +  .125952D+01, .993089D+00, .782718D+00, .614311D+00,
     +  .480989D+00, .375094D+00, .291198D+00, .224895D+00,
     +  .172698D+00, .131769D+00, .998439D-01, .750822D-01,
     +  .560094D-01, .414150D-01, .303405D-01, .220054D-01,
     +  .157883D-01, .112163D-01, .785412D-02, .542621D-02,
     +  .369596D-02, .247883D-02, .163581D-02, .106039D-02,
     +  .674839D-03, .420790D-03, .256965D-03, .153086D-03,
     +  .895875D-04, .508997D-04, .282363D-04, .152079D-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .796313D-05, .400327D-05, .192328D-05, .849579D-06,
     +  .328276D-06, .871255D-07, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .218611D+06, .169666D+06, .129983D+06,
     +  .995595D+05, .762493D+05, .583835D+05, .446988D+05,
     +  .342138D+05, .261852D+05, .200359D+05, .153288D+05,
     +  .117248D+05, .896710D+04, .685636D+04, .524188D+04,
     +  .400662D+04, .306216D+04, .233981D+04, .178773D+04,
     +  .136564D+04, .104319D+04, .796768D+03, .608577D+03,
     +  .464809D+03, .355052D+03, .271230D+03, .207285D+03,
     +  .157851D+03, .120742D+03, .924064D+02, .707829D+02,
     +  .542688D+02, .416592D+02, .320480D+02, .246825D+02,
     +  .190470D+02, .147329D+02, .114226D+02, .887934D+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .691851D+01, .540582D+01, .423237D+01, .331990D+01,
     +  .260754D+01, .204994D+01, .161173D+01, .126796D+01,
     +  .994731D+00, .780282D+00, .609572D+00, .475187D+00,
     +  .369021D+00, .285357D+00, .219569D+00, .168031D+00,
     +  .127802D+00, .965601D-01, .724268D-01, .539100D-01,
     +  .397901D-01, .291105D-01, .210952D-01, .151307D-01,
     +  .107531D-01, .753862D-02, .521900D-02, .356632D-02,
     +  .240292D-02, .159590D-02, .104343D-02, .671712D-03,
     +  .425249D-03, .264974D-03, .162142D-03, .983173D-04,
     +  .586073D-04, .346961D-04, .204099D-04, .120479D-04,
     +  .713048D-05, .427968D-05, .258058D-05, .156595D-05,
     +  .936431D-06, .545769D-06, .298118D-06, .146936D-06,
     +  .600014D-07, .160826D-07, .989837D-09, .000000D+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .161524D+06, .208849D+06, .159484D+06, .121755D+06,
     +  .929375D+05, .709206D+05, .541111D+05, .412738D+05,
     +  .314769D+05, .239982D+05, .182934D+05, .139405D+05,
     +  .106216D+05, .809033D+04, .616131D+04, .469081D+04,
     +  .357073D+04, .271730D+04, .206757D+04, .157278D+04,
     +  .119630D+04, .909736D+03, .691799D+03, .525997D+03,
     +  .399958D+03, .304113D+03, .231322D+03, .175298D+03,
     +  .133433D+03, .101610D+03, .774398D+02, .590670D+02,
     +  .451054D+02, .345151D+02, .264395D+02, .202914D+02,
     +  .156090D+02, .120344D+02, .930262D+01, .720760D+01,
     +  .560022D+01, .436013D+01, .340124D+01, .265687D+01,
     +  .207757D+01, .162489D+01, .127184D+01, .992809D+00,
     +  .775074D+00, .602705D+00, .467761D+00, .361719D+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .278587D+00, .213545D+00, .162838D+00, .123437D+00,
     +  .929735D-01, .695388D-01, .516291D-01, .380217D-01,
     +  .277650D-01, .200909D-01, .143955D-01, .102253D-01,
     +  .716910D-02, .496685D-02, .339938D-02, .229631D-02,
     +  .153090D-02, .100623D-02, .652422D-03, .416977D-03,
     +  .263077D-03, .163618D-03, .101281D-03, .619973D-04,
     +  .379391D-04, .232402D-04, .143839D-04, .898028D-05,
     +  .569955D-05, .363412D-05, .231898D-05, .144967D-05,
     +  .873786D-06, .488971D-06, .243667D-06, .990936D-07,
     +  .260458D-07, .165439D-08, .000000D+00, .354622D+06,
     +  .273420D+06, .207880D+06, .158001D+06, .120064D+06,
     +  .912042D+05, .692658D+05, .525861D+05, .399135D+05,
     +  .302840D+05, .229720D+05, .174191D+05, .132051D+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .100069D+05, .758139D+04, .574164D+04, .434729D+04,
     +  .329034D+04, .248982D+04, .188340D+04, .142444D+04,
     +  .107699D+04, .814192D+03, .615378D+03, .465092D+03,
     +  .351465D+03, .265677D+03, .200040D+03, .151285D+03,
     +  .114452D+03, .866467D+02, .656440D+02, .497840D+02,
     +  .378313D+02, .287758D+02, .219274D+02, .167462D+02,
     +  .128178D+02, .983615D+01, .756551D+01, .583563D+01,
     +  .451064D+01, .349346D+01, .270968D+01, .210418D+01,
     +  .163453D+01, .127094D+01, .985700D+00, .764745D+00,
     +  .591083D+00, .456080D+00, .350725D+00, .268681D+00,
     +  .204908D+00, .155498D+00, .117336D+00, .879981D-01,
     +  .655538D-01, .484896D-01, .355883D-01, .259080D-01,
     +  .186963D-01, .133640D-01, .947333D-02, .663030D-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .458699D-02, .313559D-02, .211583D-02, .140887D-02,
     +  .924459D-03, .597719D-03, .380130D-03, .237759D-03,
     +  .145719D-03, .880551D-04, .518515D-04, .298652D-04,
     +  .166970D-04, .904190D-05, .466911D-05, .227887D-05,
     +  .101050D-05, .388364D-06, .104751D-06, .495941D-09,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .462620D+06, .355331D+06,
     +  .268962D+06, .203513D+06, .153947D+06, .116406D+06,
     +  .879942D+05, .664895D+05, .502248D+05, .379228D+05,
     +  .286250D+05, .215975D+05, .162899D+05, .122813D+05,
     +  .925612D+04, .697302D+04, .525138D+04, .395307D+04,
     +  .297483D+04, .223773D+04, .168282D+04, .126503D+04,
     +  .950762D+03, .714341D+03, .536635D+03, .403048D+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .302782D+03, .226523D+03, .170218D+03, .127940D+03,
     +  .962204D+02, .724105D+02, .545432D+02, .411644D+02,
     +  .310934D+02, .235273D+02, .178408D+02, .135583D+02,
     +  .103299D+02, .788835D+01, .604113D+01, .463627D+01,
     +  .356539D+01, .274620D+01, .211790D+01, .163409D+01,
     +  .126225D+01, .972634D+00, .749899D+00, .576077D+00,
     +  .441885D+00, .337878D+00, .257421D+00, .195287D+00,
     +  .147448D+00, .110724D+00, .826564D-01, .613059D-01,
     +  .451605D-01, .330175D-01, .239510D-01, .172283D-01,
     +  .122786D-01, .868193D-02, .606340D-02, .418792D-02,
     +  .285974D-02, .192902D-02, .128513D-02, .844636D-03,
     +  .547767D-03, .350100D-03, .220608D-03, .136754D-03,
     +  .840042D-04, .506899D-04, .302540D-04, .178353D-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .104415D-04, .605947D-05, .351629D-05, .203104D-05,
     +  .117352D-05, .669444D-06, .374477D-06, .198022D-06,
     +  .952173D-07, .377895D-07, .973103D-08, .607504D-09,
     +  .000000D+00, .597961D+06, .457557D+06, .344822D+06,
     +  .259757D+06, .195610D+06, .147236D+06, .110786D+06,
     +  .833197D+05, .626399D+05, .470699D+05, .353564D+05,
     +  .265447D+05, .199212D+05, .149428D+05, .112041D+05,
     +  .839650D+04, .628994D+04, .470946D+04, .352475D+04,
     +  .263675D+04, .197178D+04, .147383D+04, .110129D+04,
     +  .822595D+03, .614285D+03, .458580D+03, .342391D+03,
     +  .254543D+03, .190068D+03, .141946D+03, .106061D+03,
     +  .792912D+02, .593274D+02, .444736D+02, .333634D+02,
     +  .250708D+02, .188789D+02, .142467D+02, .107780D+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .817253D+01, .621473D+01, .473608D+01, .361680D+01,
     +  .276663D+01, .211917D+01, .162415D+01, .124638D+01,
     +  .954226D+00, .731118D+00, .558219D+00, .425650D+00,
     +  .323597D+00, .245168D+00, .184992D+00, .138948D+00,
     +  .103820D+00, .771286D-01, .569424D-01, .417614D-01,
     +  .304050D-01, .219690D-01, .157447D-01, .111828D-01,
     +  .788248D-02, .548965D-02, .378256D-02, .257797D-02,
     +  .173664D-02, .115624D-02, .760173D-03, .493741D-03,
     +  .316575D-03, .200548D-03, .125396D-03, .780089D-04,
     +  .479654D-04, .293952D-04, .179793D-04, .110497D-04,
     +  .682335D-05, .426045D-05, .267035D-05, .167230D-05,
     +  .102805D-05, .609128D-06, .334993D-06, .163305D-06,
     +  .641711D-07, .160848D-07, .104871D-08, .000000D+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .765265D+06, .583416D+06, .437774D+06, .328338D+06,
     +  .246161D+06, .184457D+06, .138162D+06, .103431D+06,
     +  .773970D+05, .578843D+05, .432714D+05, .323294D+05,
     +  .241431D+05, .180194D+05, .134425D+05, .100223D+05,
     +  .746880D+04, .556259D+04, .414098D+04, .308090D+04,
     +  .229123D+04, .170302D+04, .126534D+04, .939680D+03,
     +  .697617D+03, .517694D+03, .384202D+03, .283858D+03,
     +  .210643D+03, .156324D+03, .116059D+03, .862059D+02,
     +  .640785D+02, .477177D+02, .355570D+02, .265383D+02,
     +  .198474D+02, .148747D+02, .111754D+02, .841523D+01,
     +  .635505D+01, .480966D+01, .364782D+01, .277143D+01,
     +  .210862D+01, .160537D+01, .122400D+01, .931102D+00,
     +  .708965D+00, .538001D+00, .407798D+00, .308234D+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .232216D+00, .174263D+00, .130196D+00, .967808D-01,
     +  .715424D-01, .525656D-01, .383736D-01, .278152D-01,
     +  .200131D-01, .142858D-01, .101082D-01, .709994D-02,
     +  .492855D-02, .338608D-02, .230202D-02, .154770D-02,
     +  .102908D-02, .676270D-03, .439533D-03, .282435D-03,
     +  .179671D-03, .113148D-03, .711394D-04, .444269D-04,
     +  .278069D-04, .174845D-04, .111100D-04, .712740D-05,
     +  .462655D-05, .300844D-05, .194042D-05, .121879D-05,
     +  .729798D-06, .401769D-06, .193884D-06, .745760D-07,
     +  .181770D-07, .121184D-08, .000000D+00, .969464D+06,
     +  .736425D+06, .550246D+06, .410928D+06, .306744D+06,
     +  .228844D+06, .170646D+06, .127174D+06, .947291D+05,
     +  .705187D+05, .524690D+05, .390148D+05, .289951D+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .215349D+05, .159855D+05, .118583D+05, .879194D+04,
     +  .651416D+04, .482390D+04, .356989D+04, .264054D+04,
     +  .195190D+04, .144218D+04, .106496D+04, .786092D+03,
     +  .579949D+03, .427864D+03, .314196D+03, .231740D+03,
     +  .170922D+03, .126104D+03, .930743D+02, .687398D+02,
     +  .508575D+02, .376475D+02, .279124D+02, .207353D+02,
     +  .154355D+02, .115182D+02, .861453D+01, .646142D+01,
     +  .485706D+01, .365895D+01, .276132D+01, .208703D+01,
     +  .157855D+01, .119583D+01, .903911D+00, .684005D+00,
     +  .515900D+00, .388725D+00, .292116D+00, .218829D+00,
     +  .163313D+00, .121360D+00, .897415D-01, .660023D-01,
     +  .482569D-01, .350605D-01, .252971D-01, .181210D-01,
     +  .128807D-01, .907726D-02, .635153D-02, .439329D-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .300857D-02, .203953D-02, .136800D-02, .908021D-03,
     +  .596186D-03, .387561D-03, .249461D-03, .159277D-03,
     +  .100949D-03, .640744D-04, .405638D-04, .258441D-04,
     +  .166112D-04, .108172D-04, .711928D-05, .472909D-05,
     +  .313412D-05, .204621D-05, .129267D-05, .772676D-06,
     +  .421923D-06, .200456D-06, .752826D-07, .178405D-07,
     +  .121129D-08, .000000D+00, .121574D+07, .920247D+06,
     +  .684745D+06, .509231D+06, .378512D+06, .281173D+06,
     +  .208754D+06, .154888D+06, .114857D+06, .851153D+05,
     +  .630388D+05, .466561D+05, .345105D+05, .255086D+05,
     +  .188433D+05, .139095D+05, .102613D+05, .756435D+04,
     +  .557283D+04, .410264D+04, .301854D+04, .221934D+04,
     +  .163085D+04, .119762D+04, .879059D+03, .644834D+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .472984D+03, .345265D+03, .253141D+03, .185582D+03,
     +  .136083D+03, .998173D+02, .732569D+02, .538561D+02,
     +  .396110D+02, .291775D+02, .215331D+02, .159237D+02,
     +  .118037D+02, .876940D+01, .653381D+01, .487884D+01,
     +  .365101D+01, .273722D+01, .205533D+01, .154454D+01,
     +  .116265D+01, .873308D+00, .656789D+00, .492372D+00,
     +  .368800D+00, .275539D+00, .205241D+00, .152324D+00,
     +  .112581D+00, .828108D-01, .605917D-01, .440794D-01,
     +  .318696D-01, .228866D-01, .163197D-01, .115496D-01,
     +  .810495D-02, .564854D-02, .389231D-02, .265629D-02,
     +  .179519D-02, .120102D-02, .795633D-03, .521831D-03,
     +  .339232D-03, .218686D-03, .140115D-03, .893463D-04,
     +  .572161D-04, .366728D-04, .237283D-04, .155280D-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .103021D-04, .690203D-05, .465028D-05, .311244D-05,
     +  .204012D-05, .128731D-05, .764180D-06, .412373D-06,
     +  .192469D-06, .705225D-07, .162580D-07, .112242D-08,
     +  .000000D+00, .150943D+07, .113863D+07, .843810D+06,
     +  .624954D+06, .462602D+06, .342194D+06, .252978D+06,
     +  .186891D+06, .137984D+06, .101801D+06, .750583D+05,
     +  .552994D+05, .407151D+05, .299541D+05, .220223D+05,
     +  .161780D+05, .118765D+05, .871174D+04, .638591D+04,
     +  .467727D+04, .342354D+04, .250391D+04, .183016D+04,
     +  .133672D+04, .975775D+03, .711784D+03, .519141D+03,
     +  .376756D+03, .274624D+03, .200145D+03, .145884D+03,
     +  .106359D+03, .775788D+02, .566802D+02, .414260D+02,
     +  .303209D+02, .222336D+02, .163357D+02, .120305D+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .887965D+01, .657279D+01, .487594D+01, .362510D+01,
     +  .270021D+01, .201453D+01, .150424D+01, .112522D+01,
     +  .839936D+00, .627842D+00, .467839D+00, .348359D+00,
     +  .258764D+00, .191654D+00, .141452D+00, .103977D+00,
     +  .760757D-01, .553749D-01, .400805D-01, .288354D-01,
     +  .206085D-01, .146270D-01, .103054D-01, .720057D-02,
     +  .499762D-02, .343039D-02, .233270D-02, .157149D-02,
     +  .104855D-02, .693236D-03, .454166D-03, .295253D-03,
     +  .190632D-03, .122573D-03, .786304D-04, .507850D-04,
     +  .329244D-04, .215942D-04, .143433D-04, .965352D-05,
     +  .654847D-05, .444980D-05, .299133D-05, .195942D-05,
     +  .123027D-05, .723355D-06, .385018D-06, .176349D-06,
     +  .630310D-07, .141465D-07, .992277D-09, .000000D+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .185595D+07, .139535D+07, .102995D+07, .759764D+06,
     +  .560109D+06, .412621D+06, .303774D+06, .223472D+06,
     +  .164287D+06, .120683D+06, .885900D+05, .649789D+05,
     +  .476262D+05, .348786D+05, .255239D+05, .186623D+05,
     +  .136350D+05, .995328D+04, .726020D+04, .529117D+04,
     +  .385332D+04, .280379D+04, .203869D+04, .148116D+04,
     +  .107542D+04, .780189D+03, .565890D+03, .408350D+03,
     +  .295963D+03, .214456D+03, .155402D+03, .112629D+03,
     +  .816592D+02, .593004D+02, .430749D+02, .313322D+02,
     +  .228312D+02, .166690D+02, .121980D+02, .894588D+01,
     +  .657947D+01, .484966D+01, .358253D+01, .265153D+01,
     +  .196570D+01, .145857D+01, .108431D+01, .804413D+00,
     +  .597660D+00, .442688D+00, .327701D+00, .242019D+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .178239D+00, .130821D+00, .956403D-01, .696031D-01,
     +  .503994D-01, .362935D-01, .259810D-01, .184787D-01,
     +  .130538D-01, .915530D-02, .636891D-02, .440196D-02,
     +  .300960D-02, .203916D-02, .136934D-02, .911242D-03,
     +  .601267D-03, .393510D-03, .255862D-03, .165486D-03,
     +  .106799D-03, .689248D-04, .448859D-04, .294096D-04,
     +  .195208D-04, .131267D-04, .893192D-05, .611064D-05,
     +  .417135D-05, .280626D-05, .183156D-05, .114167D-05,
     +  .663784D-06, .348102D-06, .156375D-06, .545244D-07,
     +  .119235D-07, .849308D-09, .000000D+00, .226069D+07,
     +  .169409D+07, .124562D+07, .915253D+06, .672061D+06,
     +  .493107D+06, .361551D+06, .264881D+06, .193917D+06,
     +  .141846D+06, .103679D+06, .757163D+05, .552518D+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .402825D+05, .293451D+05, .213578D+05, .155317D+05,
     +  .112843D+05, .819161D+04, .594095D+04, .430517D+04,
     +  .311689D+04, .225483D+04, .162975D+04, .117710D+04,
     +  .849408D+03, .612773D+03, .439730D+03, .316939D+03,
     +  .228365D+03, .164538D+03, .118561D+03, .854572D+02,
     +  .616918D+02, .445432D+02, .322040D+02, .233228D+02,
     +  .169229D+02, .123069D+02, .896935D+01, .655541D+01,
     +  .480160D+01, .352478D+01, .259247D+01, .190995D+01,
     +  .140843D+01, .104064D+01, .767321D+00, .566696D+00,
     +  .417267D+00, .307086D+00, .225497D+00, .165137D+00,
     +  .120535D+00, .876415D-01, .634421D-01, .456986D-01,
     +  .327404D-01, .233204D-01, .165058D-01, .116050D-01,
     +  .810209D-02, .561139D-02, .386213D-02, .263009D-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .177561D-02, .118858D-02, .788908D-03, .519584D-03,
     +  .339760D-03, .220997D-03, .143221D-03, .927927D-04,
     +  .602499D-04, .395519D-04, .261692D-04, .175525D-04,
     +  .119225D-04, .817901D-05, .562605D-05, .384705D-05,
     +  .258345D-05, .167670D-05, .103598D-05, .594996D-06,
     +  .307210D-06, .135307D-06, .460333D-07, .981690D-08,
     +  .709831D-09, .000000D+00, .142938D+07, .111493D+07,
     +  .859155D+06, .662062D+06, .510185D+06, .393151D+06,
     +  .302967D+06, .233472D+06, .179920D+06, .138654D+06,
     +  .106854D+06, .823494D+05, .634661D+05, .489146D+05,
     +  .377010D+05, .290596D+05, .224004D+05, .172685D+05,
     +  .133136D+05, .102657D+05, .791672D+04, .610633D+04,
     +  .471097D+04, .363546D+04, .280641D+04, .216731D+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .167458D+04, .128994D+04, .998138D+03, .773036D+03,
     +  .599348D+03, .465291D+03, .361783D+03, .282038D+03,
     +  .220232D+03, .172443D+03, .135453D+03, .106783D+03,
     +  .845230D+02, .671951D+02, .536896D+02, .431115D+02,
     +  .347983D+02, .282362D+02, .230308D+02, .188798D+02,
     +  .155620D+02, .128684D+02, .106951D+02, .890964D+01,
     +  .744895D+01, .624249D+01, .524088D+01, .440537D+01,
     +  .370543D+01, .311690D+01, .262054D+01, .220091D+01,
     +  .184552D+01, .154420D+01, .128861D+01, .107182D+01,
     +  .888087D+00, .733242D+00, .601637D+00, .490829D+00,
     +  .397849D+00, .320151D+00, .255543D+00, .202130D+00,
     +  .158266D+00, .122520D+00, .936295D-01, .704946D-01,
     +  .523443D-01, .380811D-01, .271280D-01, .188611D-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .127470D-01, .833164D-02, .523259D-02, .313373D-02,
     +  .176267D-02, .920776D-03, .435213D-03, .179439D-03,
     +  .606945D-04, .150112D-04, .209650D-05, .723526D-07,
     +  .000000D+00, .219368D+07, .170558D+07, .130928D+07,
     +  .100478D+07, .771084D+06, .591574D+06, .453843D+06,
     +  .348075D+06, .266947D+06, .204666D+06, .156908D+06,
     +  .120256D+06, .921617D+05, .706077D+05, .540918D+05,
     +  .414257D+05, .317240D+05, .242867D+05, .185923D+05,
     +  .142288D+05, .108894D+05, .833150D+04, .637481D+04,
     +  .487674D+04, .373125D+04, .285453D+04, .218447D+04,
     +  .166568D+04, .127569D+04, .977422D+03, .749543D+03,
     +  .575283D+03, .442143D+03, .340571D+03, .262720D+03,
     +  .203153D+03, .157580D+03, .122642D+03, .958406D+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .752114D+02, .593279D+02, .470291D+02, .374815D+02,
     +  .300313D+02, .241932D+02, .195901D+02, .159551D+02,
     +  .130370D+02, .107103D+02, .882027D+01, .729184D+01,
     +  .604359D+01, .501900D+01, .417385D+01, .347376D+01,
     +  .289167D+01, .240618D+01, .200032D+01, .166036D+01,
     +  .137534D+01, .113622D+01, .935715D+00, .767574D+00,
     +  .627454D+00, .509663D+00, .411609D+00, .330237D+00,
     +  .263017D+00, .207749D+00, .162589D+00, .125927D+00,
     +  .964098D-01, .728478D-01, .542090D-01, .397691D-01,
     +  .285725D-01, .200887D-01, .137775D-01, .917714D-02,
     +  .590781D-02, .364940D-02, .214768D-02, .118483D-02,
     +  .606060D-03, .279728D-03, .112325D-03, .368364D-04,
     +  .879930D-05, .119188D-05, .408999D-07, .000000D+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .319571D+07, .247596D+07, .189289D+07, .144649D+07,
     +  .110526D+07, .844151D+06, .644652D+06, .492069D+06,
     +  .375551D+06, .286483D+06, .218506D+06, .166573D+06,
     +  .126962D+06, .967192D+05, .736668D+05, .560780D+05,
     +  .426806D+05, .324659D+05, .246912D+05, .187678D+05,
     +  .142630D+05, .108336D+05, .822771D+04, .624564D+04,
     +  .474078D+04, .359693D+04, .272938D+04, .206274D+04,
     +  .156561D+04, .118842D+04, .902678D+03, .686016D+03,
     +  .521956D+03, .397909D+03, .303727D+03, .232338D+03,
     +  .178258D+03, .137202D+03, .106026D+03, .822700D+02,
     +  .641677D+02, .502932D+02, .396345D+02, .314023D+02,
     +  .250186D+02, .200363D+02, .161428D+02, .130487D+02,
     +  .106071D+02, .864392D+01, .707254D+01, .580225D+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .477017D+01, .392751D+01, .323656D+01, .266796D+01,
     +  .219853D+01, .181012D+01, .148810D+01, .122092D+01,
     +  .999050D+00, .814967D+00, .662144D+00, .536121D+00,
     +  .431278D+00, .344928D+00, .274024D+00, .216084D+00,
     +  .168958D+00, .130877D+00, .100303D+00, .759702D-01,
     +  .567761D-01, .417702D-01, .302862D-01, .214950D-01,
     +  .149204D-01, .100970D-01, .663090D-02, .420535D-02,
     +  .255600D-02, .147854D-02, .800294D-03, .400969D-03,
     +  .180790D-03, .707254D-04, .224995D-04, .519440D-05,
     +  .682239D-06, .229118D-07, .000000D+00, .447253D+07,
     +  .345298D+07, .262898D+07, .200054D+07, .152203D+07,
     +  .115733D+07, .879836D+06, .668481D+06, .507778D+06,
     +  .385470D+06, .292545D+06, .221878D+06, .168233D+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .127471D+06, .965558D+05, .730866D+05, .553036D+05,
     +  .418171D+05, .316086D+05, .238746D+05, .180268D+05,
     +  .136014D+05, .102592D+05, .773290D+04, .582724D+04,
     +  .438818D+04, .330429D+04, .247727D+04, .186500D+04,
     +  .140387D+04, .105720D+04, .796394D+03, .600481D+03,
     +  .453560D+03, .342947D+03, .259821D+03, .197399D+03,
     +  .150430D+03, .115086D+03, .883986D+02, .682493D+02,
     +  .529485D+02, .413031D+02, .323926D+02, .255474D+02,
     +  .202544D+02, .161567D+02, .129305D+02, .104084D+02,
     +  .839961D+01, .680665D+01, .553101D+01, .450427D+01,
     +  .367389D+01, .299942D+01, .244966D+01, .200010D+01,
     +  .163170D+01, .132919D+01, .108062D+01, .876213D+00,
     +  .708280D+00, .570199D+00, .457457D+00, .364589D+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .288872D+00, .227324D+00, .177546D+00, .137477D+00,
     +  .105439D+00, .799908D-01, .599602D-01, .443378D-01,
     +  .322620D-01, .231287D-01, .162224D-01, .111224D-01,
     +  .743022D-02, .481347D-02, .300902D-02, .180065D-02,
     +  .102449D-02, .544515D-03, .267458D-03, .117941D-03,
     +  .450102D-04, .139166D-04, .311298D-05, .397051D-06,
     +  .127572D-07, .000000D+00, .606392D+07, .466532D+07,
     +  .353764D+07, .268088D+07, .203106D+07, .153775D+07,
     +  .116391D+07, .880353D+06, .665654D+06, .502957D+06,
     +  .379885D+06, .286713D+06, .216305D+06, .163059D+06,
     +  .122866D+06, .925041D+05, .696126D+05, .523411D+05,
     +  .393357D+05, .295357D+05, .221664D+05, .166209D+05,
     +  .124569D+05, .932808D+04, .698211D+04, .522150D+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .390396D+04, .290528D+04, .217091D+04, .162164D+04,
     +  .121160D+04, .905362D+03, .677010D+03, .507063D+03,
     +  .380099D+03, .285441D+03, .214926D+03, .162304D+03,
     +  .123032D+03, .936270D+02, .716125D+02, .550380D+02,
     +  .425303D+02, .330425D+02, .258161D+02, .202764D+02,
     +  .160247D+02, .127060D+02, .101342D+02, .810357D+01,
     +  .650732D+01, .524026D+01, .422936D+01, .341904D+01,
     +  .276668D+01, .223972D+01, .181266D+01, .146586D+01,
     +  .118367D+01, .953928D+00, .766739D+00, .614381D+00,
     +  .490254D+00, .389859D+00, .307942D+00, .241795D+00,
     +  .188545D+00, .145901D+00, .111915D+00, .850152D-01,
     +  .638669D-01, .473969D-01, .346902D-01, .249750D-01,
     +  .177102D-01, .122812D-01, .832066D-02, .548985D-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .351011D-02, .216403D-02, .127586D-02, .714474D-03,
     +  .373204D-03, .179883D-03, .776744D-04, .289597D-04,
     +  .871983D-05, .189457D-05, .234958D-06, .700346D-08,
     +  .000000D+00, .855736D+07, .655502D+07, .494537D+07,
     +  .372841D+07, .280982D+07, .211602D+07, .159285D+07,
     +  .119812D+07, .900792D+06, .676704D+06, .508103D+06,
     +  .381186D+06, .285813D+06, .214111D+06, .160302D+06,
     +  .119902D+06, .896277D+05, .669313D+05, .499492D+05,
     +  .372377D+05, .277421D+05, .206463D+05, .153551D+05,
     +  .114082D+05, .847026D+04, .628199D+04, .465711D+04,
     +  .343532D+04, .254412D+04, .188313D+04, .139382D+04,
     +  .103158D+04, .763835D+03, .566392D+03, .420230D+03,
     +  .312296D+03, .232654D+03, .173804D+03, .130313D+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .980763D+02, .741824D+02, .563764D+02, .430753D+02,
     +  .330898D+02, .255621D+02, .198510D+02, .155130D+02,
     +  .121621D+02, .959248D+01, .758497D+01, .602350D+01,
     +  .479726D+01, .382934D+01, .306185D+01, .245066D+01,
     +  .196235D+01, .157096D+01, .125666D+01, .100377D+01,
     +  .800196D+00, .636210D+00, .504261D+00, .397984D+00,
     +  .313021D+00, .244507D+00, .189838D+00, .146356D+00,
     +  .111956D+00, .848776D-01, .637131D-01, .472856D-01,
     +  .346587D-01, .250468D-01, .177968D-01, .124511D-01,
     +  .851394D-02, .568472D-02, .369398D-02, .232439D-02,
     +  .140903D-02, .815916D-03, .448250D-03, .229338D-03,
     +  .108089D-03, .455388D-04, .165249D-04, .482841D-05,
     +  .101536D-05, .121781D-06, .309468D-08, .000000D+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .117599D+08, .896936D+07, .673275D+07, .505003D+07,
     +  .378600D+07, .283613D+07, .212343D+07, .158849D+07,
     +  .118763D+07, .887144D+06, .662266D+06, .493929D+06,
     +  .368129D+06, .274098D+06, .203936D+06, .151574D+06,
     +  .112569D+06, .835092D+05, .619005D+05, .458303D+05,
     +  .339034D+05, .250506D+05, .184936D+05, .136368D+05,
     +  .100469D+05, .739254D+04, .543623D+04, .397650D+04,
     +  .292002D+04, .214271D+04, .157191D+04, .115288D+04,
     +  .845742D+03, .621223D+03, .456463D+03, .335894D+03,
     +  .247732D+03, .183192D+03, .135939D+03, .101247D+03,
     +  .757771D+02, .569803D+02, .430738D+02, .327361D+02,
     +  .250186D+02, .192211D+02, .148607D+02, .115259D+02,
     +  .899406D+01, .703599D+01, .552828D+01, .435634D+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .344071D+01, .272220D+01, .215593D+01, .170827D+01,
     +  .135323D+01, .107116D+01, .846641D+00, .667866D+00,
     +  .525423D+00, .412066D+00, .321766D+00, .250383D+00,
     +  .193470D+00, .148577D+00, .113284D+00, .856911D-01,
     +  .642289D-01, .476570D-01, .349531D-01, .253114D-01,
     +  .180667D-01, .126737D-01, .875126D-02, .590277D-02,
     +  .388564D-02, .248775D-02, .154122D-02, .919061D-03,
     +  .522987D-03, .282036D-03, .141433D-03, .652300D-04,
     +  .268390D-04, .948922D-05, .269431D-05, .549086D-06,
     +  .635704D-07, .119684D-08, .000000D+00, .157770D+08,
     +  .119827D+08, .895034D+07, .667986D+07, .498241D+07,
     +  .371314D+07, .276546D+07, .205779D+07, .153016D+07,
     +  .113672D+07, .843825D+06, .625758D+06, .463676D+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .343204D+06, .253815D+06, .187493D+06, .138375D+06,
     +  .102001D+06, .751157D+05, .552467D+05, .405926D+05,
     +  .297863D+05, .218346D+05, .159843D+05, .116896D+05,
     +  .853623D+04, .622888D+04, .451990D+04, .329226D+04,
     +  .239596D+04, .174286D+04, .126726D+04, .921444D+03,
     +  .670763D+03, .488337D+03, .355993D+03, .260057D+03,
     +  .190451D+03, .139942D+03, .103197D+03, .764646D+02,
     +  .569185D+02, .425906D+02, .320395D+02, .242361D+02,
     +  .184293D+02, .141032D+02, .108260D+02, .836179D+01,
     +  .647442D+01, .503523D+01, .392750D+01, .307053D+01,
     +  .240474D+01, .188525D+01, .147872D+01, .115957D+01,
     +  .908620D+00, .710924D+00, .555146D+00, .432327D+00,
     +  .335615D+00, .259391D+00, .199781D+00, .152770D+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .116095D+00, .875830D-01, .655415D-01, .485933D-01,
     +  .356582D-01, .258594D-01, .185119D-01, .130588D-01,
     +  .905024D-02, .617228D-02, .411000D-02, .266970D-02,
     +  .168575D-02, .102937D-02, .604597D-03, .338583D-03,
     +  .179531D-03, .884182D-04, .399995D-04, .161198D-04,
     +  .557285D-05, .154460D-05, .306658D-06, .343399D-07,
     +  .349511D-09, .000000D+00, .207163D+08, .156700D+08,
     +  .116482D+08, .865101D+07, .642072D+07, .476105D+07,
     +  .352783D+07, .261150D+07, .193168D+07, .142735D+07,
     +  .105380D+07, .777164D+06, .572628D+06, .421430D+06,
     +  .309853D+06, .227535D+06, .166913D+06, .122282D+06,
     +  .894869D+05, .653968D+05, .477371D+05, .347962D+05,
     +  .253338D+05, .184175D+05, .133735D+05, .969503D+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .702210D+04, .505642D+04, .365457D+04, .263864D+04,
     +  .190387D+04, .137292D+04, .989839D+03, .714369D+03,
     +  .515513D+03, .372447D+03, .269601D+03, .195618D+03,
     +  .142392D+03, .104009D+03, .763284D+02, .562691D+02,
     +  .416953D+02, .310599D+02, .232649D+02, .175169D+02,
     +  .132736D+02, .100886D+02, .771591D+01, .591552D+01,
     +  .455549D+01, .351857D+01, .272398D+01, .211256D+01,
     +  .164009D+01, .127394D+01, .989307D+00, .767694D+00,
     +  .594843D+00, .460001D+00, .354757D+00, .272721D+00,
     +  .208720D+00, .159183D+00, .120521D+00, .906749D-01,
     +  .677185D-01, .501616D-01, .368083D-01, .267289D-01,
     +  .191788D-01, .135817D-01, .947586D-02, .649314D-02,
     +  .437761D-02, .288044D-02, .184822D-02, .115233D-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .694464D-03, .402344D-03, .222121D-03, .116029D-03,
     +  .562498D-04, .250273D-04, .991080D-05, .336322D-05,
     +  .914225D-06, .177745D-06, .192974D-07, .000000D+00,
     +  .000000D+00, .266815D+08, .201021D+08, .148729D+08,
     +  .109936D+08, .812009D+07, .599182D+07, .441778D+07,
     +  .325388D+07, .239453D+07, .176020D+07, .129270D+07,
     +  .948248D+06, .694880D+06, .508576D+06, .371820D+06,
     +  .271477D+06, .197985D+06, .144185D+06, .104877D+06,
     +  .761716D+05, .552524D+05, .400161D+05, .289434D+05,
     +  .209011D+05, .150732D+05, .108508D+05, .780326D+04,
     +  .557744D+04, .400114D+04, .286692D+04, .205250D+04,
     +  .146838D+04, .105007D+04, .751592D+03, .537796D+03,
     +  .385211D+03, .276402D+03, .198775D+03, .143388D+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .103783D+03, .754619D+02, .551146D+02, .404581D+02,
     +  .298554D+02, .221519D+02, .165213D+02, .124011D+02,
     +  .933597D+01, .707297D+01, .537127D+01, .409739D+01,
     +  .313502D+01, .240429D+01, .184720D+01, .142070D+01,
     +  .109326D+01, .841106D+00, .646641D+00, .496406D+00,
     +  .380327D+00, .290598D+00, .221330D+00, .167815D+00,
     +  .126799D+00, .951028D-01, .708776D-01, .524320D-01,
     +  .384675D-01, .279554D-01, .201025D-01, .142822D-01,
     +  .100131D-01, .691528D-02, .468947D-02, .312847D-02,
     +  .203634D-02, .129222D-02, .796566D-03, .474484D-03,
     +  .271601D-03, .148088D-03, .763672D-04, .365305D-04,
     +  .160297D-04, .625748D-05, .209204D-05, .560100D-06,
     +  .107118D-06, .113044D-07, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .337691D+08, .253444D+08, .186659D+08, .137338D+08,
     +  .100965D+08, .741488D+07, .544067D+07, .398773D+07,
     +  .292000D+07, .213568D+07, .156042D+07, .113870D+07,
     +  .830037D+06, .604241D+06, .439348D+06, .319003D+06,
     +  .231331D+06, .167502D+06, .121123D+06, .874464D+05,
     +  .630447D+05, .453767D+05, .326129D+05, .233990D+05,
     +  .167633D+05, .119860D+05, .856032D+04, .607498D+04,
     +  .432677D+04, .307754D+04, .218678D+04, .155249D+04,
     +  .110154D+04, .782166D+03, .555121D+03, .394332D+03,
     +  .280564D+03, .200045D+03, .143053D+03, .102633D+03,
     +  .739642D+02, .535381D+02, .389470D+02, .284806D+02,
     +  .209400D+02, .154752D+02, .115106D+02, .858636D+01,
     +  .644610D+01, .485068D+01, .366679D+01, .278026D+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .211306D+01, .160891D+01, .122638D+01, .935342D+00,
     +  .713235D+00, .543491D+00, .413547D+00, .314061D+00,
     +  .237862D+00, .179578D+00, .134965D+00, .101087D+00,
     +  .751513D-01, .555145D-01, .407042D-01, .295981D-01,
     +  .213178D-01, .151918D-01, .106956D-01, .743007D-02,
     +  .508403D-02, .341532D-02, .225698D-02, .145494D-02,
     +  .914258D-03, .557973D-03, .328998D-03, .186374D-03,
     +  .100547D-03, .512914D-04, .242647D-04, .105271D-04,
     +  .406226D-05, .134207D-05, .355027D-06, .670044D-07,
     +  .689157D-08, .000000D+00, .000000D+00, .420656D+08,
     +  .314535D+08, .230625D+08, .168924D+08, .123619D+08,
     +  .903676D+07, .659964D+07, .481424D+07, .350821D+07,
     +  .255335D+07, .185632D+07, .134780D+07, .977420D+06 /
        DATA (UPDI(I),I=7385,7436) /
     +  .707830D+06, .511941D+06, .369713D+06, .266633D+06,
     +  .191989D+06, .138041D+06, .990848D+05, .710143D+05,
     +  .508061D+05, .362913D+05, .258755D+05, .184190D+05,
     +  .130838D+05, .928225D+04, .654193D+04, .462700D+04,
     +  .326779D+04, .230515D+04, .162444D+04, .114388D+04,
     +  .806003D+03, .567547D+03, .399940D+03, .282241D+03,
     +  .199581D+03, .141527D+03, .100679D+03, .719359D+02,
     +  .516214D+02, .372267D+02, .269854D+02, .196672D+02,
     +  .144072D+02, .106226D+02, .785438D+01, .584524D+01,
     +  .436012D+01, .326739D+01, .245604D+01, .185060D+01,
     +  .139703D+01, .105583D+01, .798451D+00, .603728D+00,
     +  .456197D+00, .344234D+00, .259256D+00, .194734D+00,
     +  .145809D+00, .108686D+00, .807408D-01, .595346D-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .436191D-01, .317212D-01, .228777D-01, .163428D-01,
     +  .115510D-01, .806560D-02, .555681D-02, .377075D-02,
     +  .251189D-02, .164609D-02, .105214D-02, .655499D-03,
     +  .396599D-03, .231810D-03, .130159D-03, .695940D-04,
     +  .351802D-04, .164901D-04, .708725D-05, .270901D-05,
     +  .886203D-06, .232086D-06, .433018D-07, .435133D-08,
     +  .000000D+00, .000000D+00, .516441D+08, .384760D+08,
     +  .280895D+08, .204845D+08, .149241D+08, .108607D+08,
     +  .789551D+07, .573293D+07, .415807D+07, .301194D+07,
     +  .217913D+07, .157443D+07, .113608D+07, .818568D+06,
     +  .588985D+06, .423129D+06, .303532D+06, .217375D+06,
     +  .155432D+06, .110943D+06, .790580D+05, .562314D+05,
     +  .399279D+05, .282959D+05, .200173D+05, .141291D+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .995920D+04, .697220D+04, .489817D+04, .343559D+04,
     +  .240653D+04, .168377D+04, .117699D+04, .823177D+03,
     +  .575237D+03, .402229D+03, .281626D+03, .197559D+03,
     +  .138961D+03, .980456D+02, .694763D+02, .494418D+02,
     +  .353565D+02, .254144D+02, .183663D+02, .133407D+02,
     +  .975378D+01, .715114D+01, .527747D+01, .390369D+01,
     +  .290110D+01, .216275D+01, .161628D+01, .121022D+01,
     +  .907266D+00, .680610D+00, .510537D+00, .382736D+00,
     +  .286543D+00, .214130D+00, .159599D+00, .118586D+00,
     +  .877204D-01, .646744D-01, .473283D-01, .344157D-01,
     +  .248413D-01, .177825D-01, .126089D-01, .884598D-02,
     +  .613122D-02, .419294D-02, .282429D-02, .186748D-02,
     +  .121481D-02, .770715D-03, .476603D-03, .286208D-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .166033D-03, .925205D-04, .490930D-04, .246249D-04,
     +  .114518D-04, .488211D-05, .185064D-05, .600062D-06,
     +  .155686D-06, .287322D-07, .282696D-08, .000000D+00,
     +  .000000D+00, .625619D+08, .464464D+08, .337653D+08,
     +  .245186D+08, .177858D+08, .128866D+08, .932660D+07,
     +  .674158D+07, .486728D+07, .350934D+07, .252705D+07,
     +  .181710D+07, .130482D+07, .935521D+06, .669766D+06,
     +  .478717D+06, .341630D+06, .243373D+06, .173088D+06,
     +  .122872D+06, .870723D+05, .615814D+05, .434743D+05,
     +  .306279D+05, .215368D+05, .151082D+05, .105828D+05,
     +  .736079D+04, .513746D+04, .357948D+04, .249028D+04,
     +  .173030D+04, .120096D+04, .833900D+03, .578446D+03,
     +  .401450D+03, .278943D+03, .194169D+03, .135509D+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .948552D+02, .666800D+02, .470711D+02, .333896D+02,
     +  .238064D+02, .170649D+02, .122949D+02, .891681D+01,
     +  .648467D+01, .474741D+01, .348358D+01, .256844D+01,
     +  .189975D+01, .140871D+01, .104668D+01, .778689D+00,
     +  .579749D+00, .431633D+00, .321194D+00, .238711D+00,
     +  .177095D+00, .131050D+00, .966839D-01, .710163D-01,
     +  .519960D-01, .377877D-01, .272900D-01, .195644D-01,
     +  .139108D-01, .979773D-02, .682815D-02, .470145D-02,
     +  .319406D-02, .213740D-02, .140405D-02, .907442D-03,
     +  .571965D-03, .351398D-03, .209641D-03, .120818D-03,
     +  .668768D-04, .352475D-04, .175580D-04, .810714D-05,
     +  .343035D-05, .129006D-05, .414666D-06, .106567D-06,
     +  .194493D-07, .187705D-08, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .627884D+05, .926274D+05, .715825D+05, .553262D+05,
     +  .427681D+05, .330664D+05, .255706D+05, .197788D+05,
     +  .153030D+05, .118439D+05, .917006D+04, .710294D+04,
     +  .550455D+04, .426833D+04, .331197D+04, .257189D+04,
     +  .199899D+04, .155532D+04, .121158D+04, .945115D+03,
     +  .738430D+03, .578001D+03, .453375D+03, .356472D+03,
     +  .281046D+03, .222267D+03, .176397D+03, .140099D+03,
     +  .112138D+03, .902005D+02, .729511D+02, .593551D+02,
     +  .486096D+02, .401145D+02, .333401D+02, .279349D+02,
     +  .236046D+02, .201194D+02, .172997D+02, .150041D+02,
     +  .131256D+02, .115743D+02, .102830D+02, .919818D+01,
     +  .827771D+01, .748846D+01, .680670D+01, .620541D+01,
     +  .567587D+01, .519894D+01, .476956D+01, .437818D+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .401879D+01, .368667D+01, .337819D+01, .309053D+01,
     +  .282153D+01, .256954D+01, .233330D+01, .211183D+01,
     +  .190439D+01, .171038D+01, .152931D+01, .136151D+01,
     +  .120488D+01, .106014D+01, .926955D+00, .804984D+00,
     +  .693876D+00, .593254D+00, .502717D+00, .421833D+00,
     +  .350099D+00, .286975D+00, .232470D+00, .185223D+00,
     +  .145071D+00, .111412D+00, .836365D-01, .611327D-01,
     +  .432895D-01, .295220D-01, .191640D-01, .117366D-01,
     +  .664583D-02, .338163D-02, .147408D-02, .503263D-03,
     +  .110033D-03, .809180D-05, .000000D+00, .144381D+06,
     +  .112678D+06, .868833D+05, .669956D+05, .516659D+05,
     +  .398466D+05, .307359D+05, .237112D+05, .182960D+05,
     +  .141203D+05, .109010D+05, .841813D+04, .650355D+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .502659D+04, .388733D+04, .300815D+04, .232969D+04,
     +  .180582D+04, .140128D+04, .108868D+04, .847074D+03,
     +  .660171D+03, .515528D+03, .403468D+03, .316593D+03,
     +  .249155D+03, .196758D+03, .155461D+03, .123792D+03,
     +  .990499D+02, .796860D+02, .644891D+02, .525347D+02,
     +  .431245D+02, .356553D+02, .297202D+02, .249862D+02,
     +  .211903D+02, .181315D+02, .156494D+02, .136253D+02,
     +  .119584D+02, .105751D+02, .941584D+01, .843492D+01,
     +  .759593D+01, .687327D+01, .623769D+01, .567986D+01,
     +  .517912D+01, .473014D+01, .432259D+01, .395010D+01,
     +  .360755D+01, .329104D+01, .299746D+01, .272446D+01,
     +  .247016D+01, .223314D+01, .201224D+01, .180654D+01,
     +  .161531D+01, .143785D+01, .127438D+01, .112267D+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .983296D+00, .855797D+00, .739722D+00, .634599D+00,
     +  .539960D+00, .455303D+00, .380124D+00, .313865D+00,
     +  .255904D+00, .206170D+00, .163334D+00, .127168D+00,
     +  .970569D-01, .723830D-01, .525429D-01, .369302D-01,
     +  .249857D-01, .160777D-01, .975241D-02, .546281D-02,
     +  .274567D-02, .117961D-02, .395788D-03, .850182D-04,
     +  .631405D-05, .000000D+00, .177604D+06, .138273D+06,
     +  .106322D+06, .817495D+05, .628599D+05, .483341D+05,
     +  .371685D+05, .285831D+05, .219841D+05, .169103D+05,
     +  .130105D+05, .100119D+05, .770707D+04, .593470D+04,
     +  .457220D+04, .352423D+04, .271839D+04, .209834D+04,
     +  .162133D+04, .125408D+04, .971353D+03, .753492D+03,
     +  .585591D+03, .456043D+03, .356047D+03, .278757D+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .218987D+03, .172088D+03, .136294D+03, .108457D+03,
     +  .867781D+02, .698437D+02, .565878D+02, .462015D+02,
     +  .379972D+02, .315069D+02, .263536D+02, .222382D+02,
     +  .189357D+02, .162654D+02, .140957D+02, .123144D+02,
     +  .108409D+02, .960933D+01, .857025D+01, .768389D+01,
     +  .692264D+01, .625508D+01, .567113D+01, .514873D+01,
     +  .468213D+01, .426029D+01, .387645D+01, .352510D+01,
     +  .320204D+01, .290391D+01, .262813D+01, .237261D+01,
     +  .213575D+01, .191621D+01, .171291D+01, .152498D+01,
     +  .135154D+01, .119267D+01, .104604D+01, .912094D+00,
     +  .790242D+00, .679932D+00, .580593D+00, .491669D+00,
     +  .412575D+00, .342743D+00, .281568D+00, .228363D+00,
     +  .182988D+00, .144152D+00, .111571D+00, .846278D-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .627017D-01, .452002D-01, .315311D-01, .211620D-01,
     +  .134968D-01, .810733D-02, .449140D-02, .222909D-02,
     +  .943435D-03, .310878D-03, .655548D-04, .491971D-05,
     +  .000000D+00, .219224D+06, .170216D+06, .130475D+06,
     +  .100001D+06, .766452D+05, .587382D+05, .450167D+05,
     +  .344986D+05, .264405D+05, .202646D+05, .155338D+05,
     +  .119085D+05, .913165D+04, .700380D+04, .537400D+04,
     +  .412501D+04, .316825D+04, .243488D+04, .187294D+04,
     +  .144202D+04, .111166D+04, .858158D+03, .663634D+03,
     +  .514198D+03, .399373D+03, .311024D+03, .243029D+03,
     +  .189928D+03, .149597D+03, .118383D+03, .941960D+02,
     +  .753944D+02, .607502D+02, .493315D+02, .403559D+02,
     +  .332882D+02, .277024D+02, .232605D+02, .197109D+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .168517D+02, .145372D+02, .126432D+02, .110814D+02,
     +  .977983D+01, .868492D+01, .775355D+01, .695599D+01,
     +  .625868D+01, .565067D+01, .510860D+01, .462624D+01,
     +  .419187D+01, .379830D+01, .343964D+01, .311141D+01,
     +  .280996D+01, .253250D+01, .227674D+01, .204088D+01,
     +  .182342D+01, .162311D+01, .143895D+01, .126987D+01,
     +  .111583D+01, .974412D+00, .845930D+00, .729675D+00,
     +  .625007D+00, .531260D+00, .447803D+00, .373981D+00,
     +  .309171D+00, .252725D+00, .203912D+00, .162530D+00,
     +  .127326D+00, .979780D-01, .738665D-01, .543777D-01,
     +  .389335D-01, .269604D-01, .179523D-01, .113505D-01,
     +  .675317D-02, .370096D-02, .181421D-02, .756699D-03,
     +  .245029D-03, .507674D-04, .384876D-05, .000000D+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .161524D+06, .209432D+06, .160006D+06, .122222D+06,
     +  .933564D+05, .712959D+05, .544474D+05, .415750D+05,
     +  .317468D+05, .242400D+05, .185100D+05, .141345D+05,
     +  .107954D+05, .824603D+04, .630079D+04, .481575D+04,
     +  .368265D+04, .281756D+04, .215740D+04, .165325D+04,
     +  .126841D+04, .974354D+03, .749719D+03, .577922D+03,
     +  .446524D+03, .345894D+03, .268822D+03, .208921D+03,
     +  .163650D+03, .128786D+03, .101905D+03, .811137D+02,
     +  .650009D+02, .524990D+02, .427200D+02, .350561D+02,
     +  .290272D+02, .242538D+02, .204553D+02, .174076D+02,
     +  .149495D+02, .129449D+02, .112972D+02, .992822D+01,
     +  .877996D+01, .780599D+01, .697439D+01, .624949D+01,
     +  .561946D+01, .505963D+01, .456328D+01, .411801D+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .371623D+01, .335164D+01, .301949D+01, .271586D+01,
     +  .243771D+01, .218258D+01, .194847D+01, .173371D+01,
     +  .153690D+01, .135689D+01, .119247D+01, .104343D+01,
     +  .907322D+00, .784308D+00, .673583D+00, .574418D+00,
     +  .486070D+00, .407841D+00, .339015D+00, .278923D+00,
     +  .226884D+00, .182131D+00, .144411D+00, .112514D+00,
     +  .860861D-01, .645130D-01, .471919D-01, .335623D-01,
     +  .230730D-01, .152449D-01, .955647D-02, .563240D-02,
     +  .305407D-02, .147902D-02, .608129D-03, .193612D-03,
     +  .394452D-04, .302013D-05, .000000D+00, .355321D+06,
     +  .274047D+06, .208441D+06, .158503D+06, .120514D+06,
     +  .916076D+05, .696272D+05, .529098D+05, .402033D+05,
     +  .305435D+05, .232044D+05, .176272D+05, .133915D+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .101738D+05, .773084D+04, .587544D+04, .446709D+04,
     +  .339761D+04, .258586D+04, .196939D+04, .150144D+04,
     +  .114594D+04, .875947D+03, .670694D+03, .514655D+03,
     +  .395892D+03, .305508D+03, .235711D+03, .183301D+03,
     +  .143204D+03, .112491D+03, .888928D+02, .707244D+02,
     +  .567204D+02, .458365D+02, .373606D+02, .307331D+02,
     +  .255166D+02, .213884D+02, .180935D+02, .154490D+02,
     +  .133023D+02, .115452D+02, .100913D+02, .887657D+01,
     +  .785017D+01, .697716D+01, .621919D+01, .556314D+01,
     +  .498276D+01, .447056D+01, .401335D+01, .360293D+01,
     +  .323255D+01, .289702D+01, .259211D+01, .231447D+01,
     +  .206139D+01, .183062D+01, .162028D+01, .142876D+01,
     +  .125473D+01, .109679D+01, .954565D+00, .825530D+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .709682D+00, .606101D+00, .513955D+00, .432413D+00,
     +  .360701D+00, .298040D+00, .243715D+00, .197007D+00,
     +  .157124D+00, .123756D+00, .957529D-01, .727328D-01,
     +  .540940D-01, .392552D-01, .276825D-01, .188586D-01,
     +  .123398D-01, .765344D-02, .445847D-02, .238617D-02,
     +  .113864D-02, .460236D-03, .143660D-03, .287208D-04,
     +  .222434D-05, .000000D+00, .463370D+06, .356004D+06,
     +  .269565D+06, .204053D+06, .154431D+06, .116839D+06,
     +  .883819D+05, .668366D+05, .505356D+05, .382011D+05,
     +  .288741D+05, .218204D+05, .164895D+05, .124599D+05,
     +  .941599D+04, .711608D+04, .537940D+04, .406762D+04,
     +  .307734D+04, .232944D+04, .176489D+04, .133847D+04,
     +  .101648D+04, .773151D+03, .589278D+03, .450188D+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .344997D+03, .264281D+03, .204061D+03, .158288D+03,
     +  .123454D+03, .968653D+02, .765268D+02, .609520D+02,
     +  .489235D+02, .396149D+02, .323798D+02, .267181D+02,
     +  .222619D+02, .187237D+02, .158976D+02, .136139D+02,
     +  .117525D+02, .102186D+02, .894180D+01, .786713D+01,
     +  .695652D+01, .616901D+01, .549016D+01, .489220D+01,
     +  .436687D+01, .390020D+01, .348340D+01, .310925D+01,
     +  .277216D+01, .246759D+01, .219188D+01, .194207D+01,
     +  .171566D+01, .151057D+01, .132501D+01, .115747D+01,
     +  .100636D+01, .871172D+00, .749303D+00, .640602D+00,
     +  .544044D+00, .458715D+00, .383708D+00, .318186D+00,
     +  .261325D+00, .212371D+00, .170582D+00, .135152D+00,
     +  .105730D+00, .812265D-01, .612420D-01, .451939D-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .325273D-01, .227379D-01, .153445D-01, .993907D-02,
     +  .609592D-02, .350766D-02, .185143D-02, .869559D-03,
     +  .345008D-03, .105381D-03, .206303D-04, .161844D-05,
     +  .000000D+00, .598767D+06, .458280D+06, .345469D+06,
     +  .260336D+06, .196128D+06, .147700D+06, .111201D+06,
     +  .836916D+05, .629727D+05, .473678D+05, .356230D+05,
     +  .267832D+05, .201346D+05, .151337D+05, .113749D+05,
     +  .854922D+04, .642653D+04, .483160D+04, .363398D+04,
     +  .273441D+04, .205910D+04, .155190D+04, .117110D+04,
     +  .885005D+03, .670092D+03, .508499D+03, .387043D+03,
     +  .294427D+03, .225765D+03, .173907D+03, .134693D+03,
     +  .104955D+03, .823513D+02, .651520D+02, .519512D+02,
     +  .417980D+02, .339527D+02, .278484D+02, .230694D+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .192943D+02, .162931D+02, .138787D+02, .119189D+02,
     +  .103103D+02, .897636D+01, .785781D+01, .691355D+01,
     +  .610008D+01, .540165D+01, .478905D+01, .425325D+01,
     +  .377953D+01, .335850D+01, .298253D+01, .264561D+01,
     +  .234288D+01, .207041D+01, .182497D+01, .160385D+01,
     +  .140478D+01, .122576D+01, .106512D+01, .921143D+00,
     +  .793136D+00, .678474D+00, .576854D+00, .487171D+00,
     +  .408432D+00, .339674D+00, .280011D+00, .228584D+00,
     +  .184614D+00, .147346D+00, .115972D+00, .901105D-01,
     +  .687352D-01, .514394D-01, .376642D-01, .268847D-01,
     +  .186289D-01, .124531D-01, .798443D-02, .484246D-02,
     +  .275216D-02, .143258D-02, .662229D-03, .257924D-03,
     +  .771060D-04, .147883D-04, .117519D-05, .000000D+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .766129D+06, .584191D+06, .438467D+06, .328959D+06,
     +  .246717D+06, .184954D+06, .138606D+06, .103829D+06,
     +  .777531D+05, .582028D+05, .435563D+05, .325842D+05,
     +  .243710D+05, .182231D+05, .136247D+05, .101851D+05,
     +  .761432D+04, .569264D+04, .425719D+04, .318473D+04,
     +  .238399D+04, .178589D+04, .133936D+04, .100579D+04,
     +  .756675D+03, .570461D+03, .431341D+03, .325905D+03,
     +  .248221D+03, .189915D+03, .146099D+03, .113080D+03,
     +  .881377D+02, .692772D+02, .548889D+02, .438886D+02,
     +  .354372D+02, .288978D+02, .238048D+02, .198016D+02,
     +  .166335D+02, .140960D+02, .120444D+02, .103670D+02,
     +  .898122D+01, .782339D+01, .684953D+01, .601375D+01,
     +  .529897D+01, .467466D+01, .413098D+01, .365254D+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .322936D+01, .285338D+01, .251822D+01, .221873D+01,
     +  .195068D+01, .171060D+01, .149558D+01, .130315D+01,
     +  .113114D+01, .977744D+00, .841084D+00, .720336D+00,
     +  .612851D+00, .518195D+00, .435190D+00, .362783D+00,
     +  .299967D+00, .245820D+00, .199460D+00, .160095D+00,
     +  .126964D+00, .992694D-01, .766083D-01, .580199D-01,
     +  .430972D-01, .313094D-01, .221640D-01, .152229D-01,
     +  .100800D-01, .639718D-02, .383641D-02, .215352D-02,
     +  .110545D-02, .502955D-03, .192312D-03, .562855D-04,
     +  .105830D-04, .851817D-06, .000000D+00, .970389D+06,
     +  .737254D+06, .550988D+06, .411592D+06, .307339D+06,
     +  .229376D+06, .171122D+06, .127599D+06, .951095D+05,
     +  .708589D+05, .527731D+05, .392866D+05, .292381D+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .217520D+05, .161795D+05, .120316D+05, .894677D+04,
     +  .665243D+04, .494737D+04, .368012D+04, .273893D+04,
     +  .203971D+04, .152054D+04, .113488D+04, .848483D+03,
     +  .635627D+03, .477538D+03, .358442D+03, .271222D+03,
     +  .206156D+03, .157556D+03, .121156D+03, .938268D+02,
     +  .732860D+02, .577080D+02, .458673D+02, .368207D+02,
     +  .298584D+02, .244632D+02, .202429D+02, .169178D+02,
     +  .142656D+02, .121297D+02, .103898D+02, .895755D+01,
     +  .776518D+01, .676588D+01, .591144D+01, .518352D+01,
     +  .455035D+01, .400133D+01, .352038D+01, .309701D+01,
     +  .272273D+01, .239083D+01, .209583D+01, .183325D+01,
     +  .159941D+01, .139117D+01, .120590D+01, .104128D+01,
     +  .895347D+00, .766119D+00, .652634D+00, .552238D+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .464376D+00, .387815D+00, .321457D+00, .264260D+00,
     +  .215279D+00, .173622D+00, .138492D+00, .109132D+00,
     +  .847618D-01, .649668D-01, .488519D-01, .360164D-01,
     +  .259601D-01, .182250D-01, .124070D-01, .813753D-02,
     +  .511169D-02, .303111D-02, .168045D-02, .850660D-03,
     +  .380933D-03, .143007D-03, .409901D-04, .756068D-05,
     +  .616305D-06, .000000D+00, .121673D+07, .921134D+06,
     +  .685539D+06, .509941D+06, .379147D+06, .281741D+06,
     +  .209262D+06, .155342D+06, .115263D+06, .854782D+05,
     +  .633631D+05, .469459D+05, .347694D+05, .257398D+05,
     +  .190497D+05, .140939D+05, .104258D+05, .771117D+04,
     +  .570382D+04, .421949D+04, .312276D+04, .231227D+04,
     +  .171369D+04, .127146D+04, .944865D+03, .703487D+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .525241D+03, .391742D+03, .294548D+03, .222469D+03,
     +  .168949D+03, .129103D+03, .993616D+02, .771391D+02,
     +  .603820D+02, .477167D+02, .380920D+02, .307233D+02,
     +  .250409D+02, .206165D+02, .171453D+02, .143878D+02,
     +  .121754D+02, .103798D+02, .890672D+01, .768466D+01,
     +  .666407D+01, .579461D+01, .505671D+01, .441746D+01,
     +  .386551D+01, .338418D+01, .296246D+01, .259148D+01,
     +  .226418D+01, .197481D+01, .171864D+01, .149177D+01,
     +  .129089D+01, .111320D+01, .956236D+00, .817915D+00,
     +  .696155D+00, .589872D+00, .496422D+00, .415145D+00,
     +  .344766D+00, .284151D+00, .232240D+00, .188075D+00,
     +  .150764D+00, .119511D+00, .935731D-01, .721951D-01,
     +  .549569D-01, .410290D-01, .300226D-01, .214696D-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .149471D-01, .100855D-01, .655193D-02, .407353D-02,
     +  .238833D-02, .130770D-02, .652782D-03, .287718D-03,
     +  .106061D-03, .297810D-04, .539226D-05, .445089D-06,
     +  .000000D+00, .151049D+07, .113958D+07, .844658D+06,
     +  .625713D+06, .463280D+06, .342801D+06, .253520D+06,
     +  .187376D+06, .138417D+06, .102188D+06, .754038D+05,
     +  .556079D+05, .409905D+05, .301999D+05, .222417D+05,
     +  .163738D+05, .120511D+05, .886744D+04, .652472D+04,
     +  .480099D+04, .353377D+04, .260210D+04, .191761D+04,
     +  .141457D+04, .104507D+04, .773471D+03, .574023D+03,
     +  .425491D+03, .317971D+03, .238693D+03, .180164D+03,
     +  .136841D+03, .104688D+03, .808007D+02, .628875D+02,
     +  .494221D+02, .392422D+02, .314875D+02, .255354D+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .209215D+02, .173164D+02, .144635D+02, .121829D+02,
     +  .103384D+02, .883029D+01, .758339D+01, .654565D+01,
     +  .566474D+01, .491993D+01, .427728D+01, .372472D+01,
     +  .324501D+01, .282665D+01, .246044D+01, .213896D+01,
     +  .185623D+01, .160727D+01, .138801D+01, .119496D+01,
     +  .102516D+01, .876038D+00, .745396D+00, .631071D+00,
     +  .531875D+00, .445184D+00, .370248D+00, .305763D+00,
     +  .250573D+00, .203609D+00, .163913D+00, .130598D+00,
     +  .102881D+00, .800362D-01, .613398D-01, .463738D-01,
     +  .343726D-01, .249629D-01, .177105D-01, .122272D-01,
     +  .817689D-02, .526134D-02, .323752D-02, .187676D-02,
     +  .101484D-02, .499556D-03, .216719D-03, .784532D-04,
     +  .215868D-04, .383923D-05, .320851D-06, .000000D+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .185708D+07, .139636D+07, .103086D+07, .760575D+06,
     +  .560833D+06, .413268D+06, .304352D+06, .223989D+06,
     +  .164749D+06, .121095D+06, .889577D+05, .653071D+05,
     +  .479190D+05, .351398D+05, .257569D+05, .188700D+05,
     +  .138201D+05, .101182D+05, .740710D+04, .542197D+04,
     +  .396976D+04, .290740D+04, .213086D+04, .156313D+04,
     +  .114829D+04, .844964D+03, .623435D+03, .459369D+03,
     +  .341264D+03, .254668D+03, .191091D+03, .144295D+03,
     +  .109757D+03, .842386D+02, .652043D+02, .509710D+02,
     +  .402644D+02, .321475D+02, .259453D+02, .211578D+02,
     +  .174317D+02, .144941D+02, .121537D+02, .102672D+02,
     +  .872991D+01, .746301D+01, .641219D+01, .552332D+01,
     +  .477457D+01, .413108D+01, .358011D+01, .310388D+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .269048D+01, .233035D+01, .201579D+01, .174058D+01,
     +  .149954D+01, .128840D+01, .110353D+01, .941848D+00,
     +  .800672D+00, .677706D+00, .570725D+00, .478450D+00,
     +  .398293D+00, .329427D+00, .270530D+00, .220439D+00,
     +  .178084D+00, .142514D+00, .112858D+00, .883510D-01,
     +  .682915D-01, .519894D-01, .390348D-01, .287245D-01,
     +  .207040D-01, .145726D-01, .997657D-02, .661235D-02,
     +  .421392D-02, .256627D-02, .147082D-02, .785434D-03,
     +  .381260D-03, .162801D-03, .578825D-04, .156118D-04,
     +  .272894D-05, .230878D-06, .000000D+00, .226189D+07,
     +  .169518D+07, .124658D+07, .916118D+06, .672833D+06,
     +  .493796D+06, .362167D+06, .265431D+06, .194408D+06,
     +  .142284D+06, .104070D+06, .760650D+05, .555628D+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .405597D+05, .295921D+05, .215778D+05, .157276D+05,
     +  .114588D+05, .834689D+04, .607908D+04, .442801D+04,
     +  .322608D+04, .235185D+04, .171592D+04, .125361D+04,
     +  .917323D+03, .673016D+03, .493052D+03, .364202D+03,
     +  .270239D+03, .201626D+03, .151398D+03, .114525D+03,
     +  .874251D+02, .673155D+02, .523541D+02, .411535D+02,
     +  .327012D+02, .262703D+02, .213263D+02, .174928D+02,
     +  .144810D+02, .120896D+02, .101682D+02, .860739D+01,
     +  .732524D+01, .626531D+01, .537183D+01, .462199D+01,
     +  .398009D+01, .343276D+01, .296175D+01, .255475D+01,
     +  .220190D+01, .189524D+01, .162831D+01, .139575D+01,
     +  .119315D+01, .101673D+01, .863296D+00, .730090D+00,
     +  .614731D+00, .514950D+00, .429391D+00, .355512D+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .292423D+00, .238799D+00, .193474D+00, .155392D+00,
     +  .123616D+00, .972963D-01, .756925D-01, .581306D-01,
     +  .439580D-01, .327774D-01, .239458D-01, .171292D-01,
     +  .119607D-01, .811970D-02, .533352D-02, .336632D-02,
     +  .202889D-02, .114964D-02, .606273D-03, .290203D-03,
     +  .121976D-03, .425986D-04, .112658D-04, .193663D-05,
     +  .165845D-06, .000000D+00, .628438D+05, .924424D+05,
     +  .714172D+05, .551785D+05, .426362D+05, .329485D+05,
     +  .254654D+05, .196849D+05, .152193D+05, .117692D+05,
     +  .910354D+04, .704368D+04, .545179D+04, .422137D+04,
     +  .327020D+04, .253477D+04, .196601D+04, .152604D+04,
     +  .118561D+04, .922089D+03, .718031D+03, .559940D+03,
     +  .437394D+03, .342341D+03, .268556D+03, .211230D+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .166647D+03, .131497D+03, .104532D+03, .834674D+02,
     +  .669805D+02, .540471D+02, .438743D+02, .358695D+02,
     +  .295137D+02, .244616D+02, .204258D+02, .171833D+02,
     +  .145610D+02, .124238D+02, .106702D+02, .921645D+01,
     +  .800076D+01, .697468D+01, .610074D+01, .535005D+01,
     +  .470245D+01, .413441D+01, .363935D+01, .320055D+01,
     +  .281410D+01, .247153D+01, .216737D+01, .189707D+01,
     +  .165681D+01, .144335D+01, .125389D+01, .108597D+01,
     +  .937421D+00, .806295D+00, .690837D+00, .589453D+00,
     +  .500691D+00, .423565D+00, .356080D+00, .297644D+00,
     +  .247254D+00, .204000D+00, .167059D+00, .135685D+00,
     +  .109202D+00, .870025D-01, .685251D-01, .532662D-01,
     +  .409010D-01, .308448D-01, .228335D-01, .165440D-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .116904D-01, .802018D-02, .531119D-02, .337220D-02,
     +  .202533D-02, .113917D-02, .586339D-03, .267345D-03,
     +  .102260D-03, .296290D-04, .517089D-05, .261159D-06,
     +  .000000D+00, .144162D+06, .112482D+06, .867083D+05,
     +  .668393D+05, .515263D+05, .397221D+05, .306248D+05,
     +  .236121D+05, .182076D+05, .140416D+05, .108308D+05,
     +  .835563D+04, .644792D+04, .497710D+04, .384333D+04,
     +  .296905D+04, .229496D+04, .177500D+04, .137395D+04,
     +  .106445D+04, .825608D+03, .641167D+03, .498711D+03,
     +  .388594D+03, .303442D+03, .237528D+03, .186479D+03,
     +  .146386D+03, .115759D+03, .919307D+02, .733643D+02,
     +  .588606D+02, .475054D+02, .386087D+02, .315785D+02,
     +  .260147D+02, .215917D+02, .180537D+02, .152066D+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .128966D+02, .110110D+02, .945510D+01, .816086D+01,
     +  .707400D+01, .615344D+01, .536698D+01, .469247D+01,
     +  .410414D+01, .359450D+01, .314539D+01, .275220D+01,
     +  .240569D+01, .209982D+01, .182956D+01, .159069D+01,
     +  .137963D+01, .119331D+01, .102906D+01, .884504D+00,
     +  .757566D+00, .646355D+00, .549202D+00, .464543D+00,
     +  .391347D+00, .327603D+00, .272675D+00, .225536D+00,
     +  .185270D+00, .151047D+00, .122125D+00, .978328D-01,
     +  .775727D-01, .608009D-01, .470217D-01, .359173D-01,
     +  .269380D-01, .198266D-01, .142787D-01, .100249D-01,
     +  .683089D-02, .449013D-02, .282838D-02, .168379D-02,
     +  .938069D-03, .477998D-03, .215438D-03, .812800D-04,
     +  .231745D-04, .398443D-05, .203913D-06, .000000D+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .177373D+06, .138066D+06, .106137D+06, .815846D+05,
     +  .627127D+05, .482027D+05, .370514D+05, .284786D+05,
     +  .218910D+05, .168273D+05, .129366D+05, .994611D+04,
     +  .764854D+04, .588265D+04, .452593D+04, .348313D+04,
     +  .268190D+04, .206596D+04, .159261D+04, .122863D+04,
     +  .948807D+03, .733531D+03, .567925D+03, .440415D+03,
     +  .342225D+03, .266532D+03, .208172D+03, .162534D+03,
     +  .127829D+03, .100948D+03, .801021D+02, .638926D+02,
     +  .512632D+02, .414145D+02, .336705D+02, .275707D+02,
     +  .227458D+02, .189046D+02, .158289D+02, .133453D+02,
     +  .113283D+02, .967213D+01, .830161D+01, .715655D+01,
     +  .619194D+01, .537221D+01, .467309D+01, .406662D+01,
     +  .354427D+01, .308651D+01, .268803D+01, .233880D+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .203224D+01, .176284D+01, .152601D+01, .131786D+01,
     +  .113505D+01, .974716D+00, .834320D+00, .711640D+00,
     +  .604681D+00, .511701D+00, .431049D+00, .361648D+00,
     +  .301489D+00, .249893D+00, .205820D+00, .168351D+00,
     +  .136656D+00, .109999D+00, .877175D-01, .692270D-01,
     +  .540005D-01, .415541D-01, .315780D-01, .235563D-01,
     +  .172399D-01, .123424D-01, .861115D-02, .582868D-02,
     +  .380381D-02, .237772D-02, .140354D-02, .774609D-03,
     +  .390232D-03, .173657D-03, .645654D-04, .181005D-04,
     +  .306326D-05, .158991D-06, .000000D+00, .218980D+06,
     +  .169998D+06, .130281D+06, .998275D+05, .764901D+05,
     +  .585999D+05, .448934D+05, .343887D+05, .263425D+05,
     +  .201773D+05, .154561D+05, .118393D+05, .907016D+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .694914D+04, .532543D+04, .408187D+04, .312996D+04,
     +  .240091D+04, .184282D+04, .141533D+04, .108802D+04,
     +  .837223D+03, .645106D+03, .497804D+03, .384869D+03,
     +  .298191D+03, .231671D+03, .179887D+03, .140694D+03,
     +  .110478D+03, .871614D+02, .691172D+02, .551279D+02,
     +  .442721D+02, .357791D+02, .291222D+02, .238831D+02,
     +  .197325D+02, .164258D+02, .137688D+02, .116217D+02,
     +  .986762D+01, .842339D+01, .722285D+01, .621681D+01,
     +  .536632D+01, .464485D+01, .402230D+01, .348905D+01,
     +  .302424D+01, .262180D+01, .227098D+01, .196467D+01,
     +  .169688D+01, .146269D+01, .125790D+01, .107893D+01,
     +  .922742D+00, .786632D+00, .668265D+00, .565551D+00,
     +  .476682D+00, .399940D+00, .334207D+00, .277484D+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .229058D+00, .187878D+00, .153032D+00, .123690D+00,
     +  .991294D-01, .786962D-01, .618225D-01, .479985D-01,
     +  .367545D-01, .277899D-01, .206209D-01, .150080D-01,
     +  .106822D-01, .740692D-02, .498088D-02, .322760D-02,
     +  .200235D-02, .117215D-02, .641048D-03, .319668D-03,
     +  .140637D-03, .515934D-04, .142471D-04, .238076D-05,
     +  .125422D-06, .000000D+00, .161592D+06, .209202D+06,
     +  .159801D+06, .122039D+06, .931933D+05, .711505D+05,
     +  .543178D+05, .414595D+05, .316439D+05, .241484D+05,
     +  .184285D+05, .140620D+05, .107309D+05, .818870D+04,
     +  .624986D+04, .477053D+04, .364252D+04, .278196D+04,
     +  .212584D+04, .162529D+04, .124364D+04, .952425D+03,
     +  .730310D+03, .560746D+03, .431325D+03, .332440D+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .256909D+03, .198384D+03, .154302D+03, .120479D+03,
     +  .945067D+02, .745066D+02, .590784D+02, .471655D+02,
     +  .378926D+02, .306607D+02, .249979D+02, .205338D+02,
     +  .169952D+02, .141658D+02, .118910D+02, .100416D+02,
     +  .852651D+01, .727339D+01, .622864D+01, .534990D+01,
     +  .460833D+01, .397172D+01, .342928D+01, .295892D+01,
     +  .255379D+01, .220244D+01, .189722D+01, .163174D+01,
     +  .140071D+01, .119968D+01, .102484D+01, .872973D+00,
     +  .741251D+00, .627231D+00, .528739D+00, .443914D+00,
     +  .370982D+00, .308791D+00, .255361D+00, .209949D+00,
     +  .171505D+00, .139119D+00, .111973D+00, .893539D-01,
     +  .706236D-01, .552304D-01, .426822D-01, .325258D-01,
     +  .244705D-01, .180632D-01, .130748D-01, .925277D-02 /
        DATA (UPDI(I),I=9361,9412) /
     +  .637686D-02, .426061D-02, .274166D-02, .168825D-02,
     +  .980201D-03, .531282D-03, .262284D-03, .114099D-03,
     +  .413214D-04, .112484D-04, .185747D-05, .993310D-07,
     +  .000000D+00, .355046D+06, .273802D+06, .208222D+06,
     +  .158308D+06, .120340D+06, .914525D+05, .694890D+05,
     +  .527867D+05, .400937D+05, .304460D+05, .231176D+05,
     +  .175500D+05, .133229D+05, .101129D+05, .767671D+04,
     +  .582740D+04, .442447D+04, .335981D+04, .255235D+04,
     +  .193971D+04, .147515D+04, .112267D+04, .855343D+03,
     +  .652459D+03, .498513D+03, .381599D+03, .292846D+03,
     +  .224504D+03, .173351D+03, .134356D+03, .104604D+03,
     +  .818443D+02, .644016D+02, .510231D+02, .406779D+02,
     +  .326637D+02, .264295D+02, .215475D+02, .177029D+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .146490D+02, .122094D+02, .102390D+02, .863519D+01,
     +  .731729D+01, .622566D+01, .531350D+01, .454876D+01,
     +  .389659D+01, .334456D+01, .286905D+01, .246216D+01,
     +  .211159D+01, .180900D+01, .154749D+01, .132134D+01,
     +  .112578D+01, .956733D+00, .810784D+00, .684945D+00,
     +  .576657D+00, .483661D+00, .404031D+00, .335949D+00,
     +  .278223D+00, .228907D+00, .187230D+00, .152148D+00,
     +  .122765D+00, .982774D-01, .779934D-01, .612965D-01,
     +  .476586D-01, .366119D-01, .277270D-01, .207269D-01,
     +  .151973D-01, .109231D-01, .767292D-02, .524663D-02,
     +  .347624D-02, .221675D-02, .135179D-02, .776442D-03,
     +  .415867D-03, .202562D-03, .867718D-04, .308729D-04,
     +  .822865D-05, .132995D-05, .720324D-07, .000000D+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .463077D+06, .355742D+06, .269332D+06, .203845D+06,
     +  .154245D+06, .116674D+06, .882348D+05, .667056D+05,
     +  .504190D+05, .380973D+05, .287818D+05, .217384D+05,
     +  .164166D+05, .123952D+05, .935851D+04, .706508D+04,
     +  .533416D+04, .402752D+04, .304179D+04, .229796D+04,
     +  .173700D+04, .131378D+04, .994625D+03, .753808D+03,
     +  .572152D+03, .435018D+03, .331553D+03, .252377D+03,
     +  .193487D+03, .148879D+03, .115063D+03, .893622D+02,
     +  .697932D+02, .548829D+02, .434285D+02, .346135D+02,
     +  .278010D+02, .225010D+02, .183539D+02, .150810D+02,
     +  .124830D+02, .103979D+02, .871133D+01, .733421D+01,
     +  .620068D+01, .525950D+01, .447542D+01, .381100D+01,
     +  .325218D+01, .277388D+01, .236719D+01, .201900D+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .172034D+01, .146383D+01, .124334D+01, .105383D+01,
     +  .890985D+00, .751221D+00, .631415D+00, .528912D+00,
     +  .441388D+00, .366870D+00, .303510D+00, .250089D+00,
     +  .204707D+00, .166570D+00, .134650D+00, .108067D+00,
     +  .860421D-01, .679049D-01, .530641D-01, .410167D-01,
     +  .313205D-01, .235713D-01, .175068D-01, .127494D-01,
     +  .909866D-02, .634374D-02, .430355D-02, .282750D-02,
     +  .178677D-02, .107905D-02, .613214D-03, .324634D-03,
     +  .156084D-03, .658980D-04, .230540D-04, .603299D-05,
     +  .960941D-06, .530437D-07, .000000D+00, .598455D+06,
     +  .458001D+06, .345221D+06, .260114D+06, .195931D+06,
     +  .147524D+06, .111045D+06, .835522D+05, .628487D+05,
     +  .472574D+05, .355249D+05, .266960D+05, .200572D+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .150650D+05, .113139D+05, .849512D+04, .637856D+04,
     +  .478908D+04, .359630D+04, .270104D+04, .202955D+04,
     +  .152574D+04, .114794D+04, .864505D+03, .651940D+03,
     +  .492416D+03, .372785D+03, .281798D+03, .214543D+03,
     +  .163919D+03, .125782D+03, .969842D+02, .751967D+02,
     +  .587038D+02, .461148D+02, .364896D+02, .290983D+02,
     +  .233849D+02, .189424D+02, .154584D+02, .127098D+02,
     +  .105175D+02, .875497D+01, .732465D+01, .615449D+01,
     +  .518882D+01, .438926D+01, .371588D+01, .315301D+01,
     +  .267421D+01, .226959D+01, .192529D+01, .163174D+01,
     +  .138114D+01, .116702D+01, .984056D+00, .827755D+00,
     +  .694382D+00, .580705D+00, .483999D+00, .401888D+00,
     +  .332371D+00, .273586D+00, .224297D+00, .182657D+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .147860D+00, .118899D+00, .949183D-01, .751630D-01,
     +  .589899D-01, .458350D-01, .352217D-01, .267338D-01,
     +  .199933D-01, .147534D-01, .106714D-01, .756155D-02,
     +  .523266D-02, .352175D-02, .229441D-02, .143679D-02,
     +  .859288D-03, .483142D-03, .252811D-03, .119988D-03,
     +  .499329D-04, .171886D-04, .442074D-05, .694850D-06,
     +  .391365D-07, .000000D+00, .765796D+06, .583894D+06,
     +  .438202D+06, .328723D+06, .246506D+06, .184766D+06,
     +  .138440D+06, .103681D+06, .776213D+05, .580856D+05,
     +  .434522D+05, .324917D+05, .242889D+05, .181502D+05,
     +  .135600D+05, .101278D+05, .756348D+04, .564759D+04,
     +  .421728D+04, .314939D+04, .235270D+04, .175819D+04,
     +  .131483D+04, .984086D+03, .737451D+03, .553425D+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .416237D+03, .312523D+03, .236328D+03, .179327D+03,
     +  .136652D+03, .104629D+03, .805529D+02, .624434D+02,
     +  .487073D+02, .382716D+02, .303079D+02, .241906D+02,
     +  .194631D+02, .157783D+02, .128887D+02, .105977D+02,
     +  .876660D+01, .728952D+01, .608819D+01, .510266D+01,
     +  .429148D+01, .361237D+01, .304808D+01, .257095D+01,
     +  .217013D+01, .183109D+01, .154374D+01, .129986D+01,
     +  .109268D+01, .916683D+00, .767185D+00, .640339D+00,
     +  .532833D+00, .441885D+00, .365093D+00, .300437D+00,
     +  .246059D+00, .200714D+00, .162618D+00, .130959D+00,
     +  .104757D+00, .831833D-01, .655127D-01, .511304D-01,
     +  .395017D-01, .301771D-01, .227669D-01, .169196D-01,
     +  .124044D-01, .891131D-02, .626943D-02, .430600D-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .287513D-02, .185735D-02, .115257D-02, .682618D-03,
     +  .379733D-03, .196398D-03, .920182D-04, .377473D-04,
     +  .127879D-04, .323341D-05, .501702D-06, .288276D-07,
     +  .000000D+00, .970035D+06, .736938D+06, .550706D+06,
     +  .411341D+06, .307115D+06, .229177D+06, .170945D+06,
     +  .127442D+06, .949696D+05, .707345D+05, .526627D+05,
     +  .391885D+05, .291511D+05, .216748D+05, .161110D+05,
     +  .119709D+05, .889292D+04, .660473D+04, .490512D+04,
     +  .364271D+04, .270581D+04, .201040D+04, .149460D+04,
     +  .111191D+04, .828142D+03, .617601D+03, .461555D+03,
     +  .344280D+03, .258635D+03, .194949D+03, .147558D+03,
     +  .112213D+03, .858034D+02, .660610D+02, .511781D+02,
     +  .399412D+02, .314180D+02, .249108D+02, .199119D+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .160387D+02, .130190D+02, .106387D+02, .874714D+01,
     +  .722999D+01, .600309D+01, .500233D+01, .418334D+01,
     +  .350162D+01, .293843D+01, .246500D+01, .206958D+01,
     +  .173705D+01, .145683D+01, .122036D+01, .102063D+01,
     +  .851901D+00, .709387D+00, .589141D+00, .487791D+00,
     +  .402523D+00, .330922D+00, .270964D+00, .220809D+00,
     +  .179212D+00, .144456D+00, .115733D+00, .920923D-01,
     +  .727368D-01, .569738D-01, .442187D-01, .339668D-01,
     +  .257965D-01, .193444D-01, .142855D-01, .104052D-01,
     +  .742414D-02, .518586D-02, .353503D-02, .234160D-02,
     +  .149991D-02, .922314D-03, .540939D-03, .297722D-03,
     +  .152199D-03, .703972D-04, .284684D-04, .949313D-05,
     +  .236056D-05, .361687D-06, .211973D-07, .000000D+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .121635D+07, .920798D+06, .685240D+06, .509674D+06,
     +  .378910D+06, .281529D+06, .209074D+06, .155175D+06,
     +  .115115D+06, .853463D+05, .632459D+05, .468419D+05,
     +  .346771D+05, .256579D+05, .189772D+05, .140295D+05,
     +  .103688D+05, .766069D+04, .565913D+04, .417992D+04,
     +  .308774D+04, .228128D+04, .168626D+04, .124718D+04,
     +  .923362D+03, .684431D+03, .508346D+03, .376772D+03,
     +  .281243D+03, .210626D+03, .158385D+03, .119658D+03,
     +  .908921D+02, .695185D+02, .535021D+02, .414820D+02,
     +  .324187D+02, .255399D+02, .202861D+02, .162388D+02,
     +  .131010D+02, .106415D+02, .869783D+01, .714750D+01,
     +  .590066D+01, .488924D+01, .406612D+01, .338478D+01,
     +  .282507D+01, .235721D+01, .196865D+01, .164373D+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .137146D+01, .114298D+01, .951076D+00, .789863D+00,
     +  .654444D+00, .540810D+00, .445556D+00, .365852D+00,
     +  .299285D+00, .243843D+00, .197713D+00, .159662D+00,
     +  .128041D+00, .102051D+00, .807799D-01, .634614D-01,
     +  .494378D-01, .381558D-01, .291419D-01, .220019D-01,
     +  .163989D-01, .120338D-01, .870809D-02, .617072D-02,
     +  .427946D-02, .289519D-02, .190250D-02, .120832D-02,
     +  .736260D-03, .427613D-03, .232849D-03, .117657D-03,
     +  .537260D-04, .214201D-04, .703199D-05, .172011D-05,
     +  .260346D-06, .155598D-07, .000000D+00, .151008D+07,
     +  .113922D+07, .844340D+06, .625429D+06, .463028D+06,
     +  .342576D+06, .253321D+06, .187198D+06, .138259D+06,
     +  .102048D+06, .752796D+05, .554977D+05, .408928D+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .301132D+05, .221648D+05, .163057D+05, .119908D+05,
     +  .881406D+04, .647747D+04, .475916D+04, .349676D+04,
     +  .256935D+04, .188863D+04, .138893D+04, .102236D+04,
     +  .753346D+03, .556183D+03, .409687D+03, .303928D+03,
     +  .226196D+03, .169021D+03, .126884D+03, .957664D+02,
     +  .727812D+02, .556570D+02, .428805D+02, .333020D+02,
     +  .260738D+02, .205840D+02, .163784D+02, .131356D+02,
     +  .106075D+02, .862024D+01, .704366D+01, .578245D+01,
     +  .476484D+01, .394114D+01, .326302D+01, .270898D+01,
     +  .224840D+01, .186800D+01, .155166D+01, .128803D+01,
     +  .106802D+01, .884232D+00, .730683D+00, .602404D+00,
     +  .495343D+00, .406082D+00, .331794D+00, .270083D+00,
     +  .218961D+00, .176650D+00, .141936D+00, .113245D+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .897917D-01, .707025D-01, .552476D-01, .428042D-01,
     +  .328514D-01, .249466D-01, .187234D-01, .138705D-01,
     +  .101140D-01, .727099D-02, .511703D-02, .352322D-02,
     +  .236556D-02, .154206D-02, .971081D-03, .586316D-03,
     +  .337206D-03, .181667D-03, .907331D-04, .409049D-04,
     +  .160796D-04, .519782D-05, .125112D-05, .187118D-06,
     +  .114021D-07, .000000D+00, .185666D+07, .139598D+07,
     +  .103052D+07, .760273D+06, .560565D+06, .413030D+06,
     +  .304141D+06, .223801D+06, .164582D+06, .120947D+06,
     +  .888261D+05, .651904D+05, .478156D+05, .350480D+05,
     +  .256756D+05, .187980D+05, .137564D+05, .100618D+05,
     +  .735717D+04, .537780D+04, .393067D+04, .287283D+04,
     +  .210027D+04, .153606D+04, .112432D+04, .823733D+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .604618D+03, .442705D+03, .326462D+03, .241501D+03,
     +  .179357D+03, .133818D+03, .100378D+03, .758183D+02,
     +  .576239D+02, .441256D+02, .340621D+02, .265101D+02,
     +  .208052D+02, .164583D+02, .131241D+02, .105383D+02,
     +  .851620D+01, .692025D+01, .565012D+01, .463062D+01,
     +  .380970D+01, .313742D+01, .259108D+01, .213934D+01,
     +  .176824D+01, .146129D+01, .120688D+01, .995703D+00,
     +  .820246D+00, .674444D+00, .553289D+00, .452714D+00,
     +  .369308D+00, .300261D+00, .243210D+00, .196197D+00,
     +  .157494D+00, .125909D+00, .999442D-01, .788355D-01,
     +  .617491D-01, .479929D-01, .369801D-01, .282225D-01,
     +  .213084D-01, .158982D-01, .117058D-01, .848124D-02,
     +  .605727D-02, .423353D-02, .289391D-02, .192831D-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .124696D-02, .778566D-03, .465793D-03, .265275D-03,
     +  .141395D-03, .698034D-04, .310704D-04, .120434D-04,
     +  .383406D-05, .908359D-06, .134289D-06, .834141D-08,
     +  .000000D+00, .226144D+07, .169477D+07, .124622D+07,
     +  .915798D+06, .672549D+06, .493544D+06, .361943D+06,
     +  .265231D+06, .194231D+06, .142127D+06, .103931D+06,
     +  .759415D+05, .554533D+05, .404627D+05, .295062D+05,
     +  .215017D+05, .156603D+05, .113992D+05, .829416D+04,
     +  .603245D+04, .438676D+04, .318960D+04, .231959D+04,
     +  .168737D+04, .122835D+04, .894947D+03, .653191D+03,
     +  .475503D+03, .348621D+03, .256388D+03, .189292D+03,
     +  .140394D+03, .104685D+03, .786034D+02, .593872D+02,
     +  .452089D+02, .346953D+02, .268475D+02, .209503D+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .164800D+02, .130685D+02, .104361D+02, .838772D+01,
     +  .677916D+01, .550536D+01, .448806D+01, .367307D+01,
     +  .300906D+01, .247224D+01, .203071D+01, .166990D+01,
     +  .137305D+01, .112830D+01, .926233D+00, .759231D+00,
     +  .621190D+00, .507092D+00, .412877D+00, .335155D+00,
     +  .271155D+00, .218551D+00, .175433D+00, .140121D+00,
     +  .111457D+00, .880204D-01, .690701D-01, .538153D-01,
     +  .416021D-01, .318801D-01, .241937D-01, .181613D-01,
     +  .134698D-01, .985711D-02, .709631D-02, .503486D-02,
     +  .349466D-02, .237160D-02, .156827D-02, .100600D-02,
     +  .622759D-03, .369177D-03, .208196D-03, .109792D-03,
     +  .535762D-04, .235463D-04, .900053D-05, .282241D-05,
     +  .658357D-06, .962403D-07, .609245D-08, .000000D+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
