C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RF4 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 4)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=14)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4F4                                          
        DATA  DrI, FlI, AlI /   2.,   4.,  .2920 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.600,    5.000,  180.000 /
C        DATA  NX,  NT, NfMx /    90,    13,     4 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000E+01, .100000E+05,
     +  .160000E+01, .206432E+01, .276700E+01, .387525E+01, .570827E+01,
     +  .891054E+01, .148687E+02, .267887E+02, .527144E+02, .114800E+03,
     +  .280922E+03, .786042E+03, .256591E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                   
C
        DATA (UPDI(I),I=1,52) /
     +  .686881E+05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .368694E+05,
     +  .284674E+05, .216760E+05, .164952E+05, .125494E+05,
     +  .954118E+04, .725186E+04, .550790E+04, .418189E+04,
     +  .317263E+04, .240599E+04, .182305E+04, .138073E+04 /
        DATA (UPDI(I),I=105,156) /
     +  .104474E+04, .790123E+03, .596940E+03, .450737E+03,
     +  .339956E+03, .256240E+03, .192902E+03, .145124E+03,
     +  .109035E+03, .818601E+02, .613719E+02, .459732E+02,
     +  .343928E+02, .257165E+02, .191205E+02, .142673E+02,
     +  .106305E+02, .791902E+01, .589238E+01, .438478E+01,
     +  .326362E+01, .242983E+01, .180938E+01, .135029E+01,
     +  .100877E+01, .756170E+00, .568034E+00, .428841E+00,
     +  .324802E+00, .247335E+00, .189089E+00, .145452E+00,
     +  .112333E+00, .873669E-01, .680634E-01, .534293E-01,
     +  .419785E-01, .331572E-01, .262271E-01, .208136E-01,
     +  .165249E-01, .131458E-01, .104451E-01, .829953E-02,
     +  .657821E-02, .520976E-02, .410890E-02, .323284E-02,
     +  .252987E-02, .197113E-02, .152825E-02, .117526E-02 /
        DATA (UPDI(I),I=157,208) /
     +  .895049E-03, .675518E-03, .503688E-03, .371118E-03,
     +  .268909E-03, .191566E-03, .133165E-03, .901556E-04,
     +  .584605E-04, .362800E-04, .206352E-04, .101771E-04,
     +  .345397E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .853587E+05, .657418E+05,
     +  .499129E+05, .378722E+05, .287264E+05, .217743E+05,
     +  .164984E+05, .124915E+05, .945376E+04, .714896E+04,
     +  .540347E+04, .408057E+04, .307990E+04, .232239E+04,
     +  .175015E+04, .131752E+04, .991185E+03, .744818E+03,
     +  .559277E+03, .419431E+03, .314309E+03, .235220E+03,
     +  .175880E+03, .131323E+03, .979608E+02, .729748E+02 /
        DATA (UPDI(I),I=209,260) /
     +  .543274E+02, .402132E+02, .298696E+02, .221544E+02,
     +  .164253E+02, .121635E+02, .900646E+01, .667028E+01,
     +  .494027E+01, .365960E+01, .271610E+01, .201804E+01,
     +  .150405E+01, .112339E+01, .843036E+00, .634704E+00,
     +  .480313E+00, .364934E+00, .278905E+00, .214022E+00,
     +  .165351E+00, .127974E+00, .997745E-01, .778650E-01,
     +  .610771E-01, .479844E-01, .378149E-01, .298180E-01,
     +  .235544E-01, .185871E-01, .146668E-01, .115469E-01,
     +  .908271E-02, .711685E-02, .556354E-02, .432724E-02,
     +  .335209E-02, .258504E-02, .197857E-02, .150124E-02,
     +  .113030E-02, .842325E-03, .621810E-03, .453076E-03,
     +  .326190E-03, .231024E-03, .161027E-03, .109614E-03,
     +  .734233E-04, .476083E-04, .299632E-04, .180638E-04 /
        DATA (UPDI(I),I=261,312) /
     +  .103725E-04, .553153E-05, .267179E-05, .107246E-05,
     +  .272796E-06, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .148107E+06, .113773E+06, .861192E+05,
     +  .651457E+05, .492603E+05, .372218E+05, .281128E+05,
     +  .212166E+05, .160041E+05, .120621E+05, .908610E+04,
     +  .683813E+04, .514318E+04, .386454E+04, .290182E+04,
     +  .217658E+04, .163138E+04, .122131E+04, .913562E+03,
     +  .682489E+03, .509419E+03, .379718E+03, .282766E+03,
     +  .210264E+03, .156186E+03, .115853E+03, .858708E+02,
     +  .632766E+02, .467864E+02, .345426E+02, .254882E+02,
     +  .187847E+02, .138400E+02, .101990E+02, .751452E+01,
     +  .553746E+01, .408743E+01, .302037E+01, .223830E+01 /
        DATA (UPDI(I),I=313,364) /
     +  .166230E+01, .124009E+01, .928118E+00, .698051E+00,
     +  .527136E+00, .400323E+00, .305265E+00, .234317E+00,
     +  .180189E+00, .139552E+00, .108194E+00, .842960E-01,
     +  .657889E-01, .514947E-01, .403341E-01, .316435E-01,
     +  .248024E-01, .194377E-01, .152009E-01, .118756E-01,
     +  .924368E-02, .717788E-02, .554662E-02, .426895E-02,
     +  .327132E-02, .248837E-02, .187721E-02, .140581E-02,
     +  .104277E-02, .766779E-03, .557264E-03, .400783E-03,
     +  .284298E-03, .199071E-03, .136893E-03, .932021E-04,
     +  .620931E-04, .407560E-04, .262210E-04, .166350E-04,
     +  .103578E-04, .640358E-05, .391197E-05, .238390E-05,
     +  .143653E-05, .854414E-06, .484689E-06, .252824E-06,
     +  .111553E-06, .328140E-07, .212496E-08, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .228288E+06, .174896E+06, .131972E+06, .995168E+05,
     +  .750090E+05, .564946E+05, .425286E+05, .319896E+05,
     +  .240488E+05, .180635E+05, .135595E+05, .101691E+05,
     +  .762117E+04, .570588E+04, .426873E+04, .319002E+04,
     +  .238196E+04, .177643E+04, .132365E+04, .984979E+03,
     +  .732261E+03, .543621E+03, .403152E+03, .298533E+03,
     +  .220810E+03, .163081E+03, .120342E+03, .882762E+02,
     +  .649714E+02, .477469E+02, .350630E+02, .257168E+02,
     +  .188531E+02, .138237E+02, .101321E+02, .742726E+01,
     +  .545258E+01, .400715E+01, .295278E+01, .218050E+01,
     +  .161712E+01, .120319E+01, .899456E+00, .675126E+00,
     +  .509515E+00, .386117E+00, .294492E+00, .225032E+00,
     +  .173146E+00, .133373E+00, .103229E+00, .800421E-01 /
        DATA (UPDI(I),I=417,468) /
     +  .622349E-01, .484268E-01, .377374E-01, .293832E-01,
     +  .228734E-01, .177699E-01, .137894E-01, .106628E-01,
     +  .822475E-02, .631426E-02, .482800E-02, .367586E-02,
     +  .277812E-02, .208294E-02, .155063E-02, .114387E-02,
     +  .836829E-03, .605561E-03, .434016E-03, .307266E-03,
     +  .215095E-03, .148331E-03, .101577E-03, .684317E-04,
     +  .457025E-04, .301778E-04, .198396E-04, .129519E-04,
     +  .847882E-05, .552794E-05, .359453E-05, .229740E-05,
     +  .142483E-05, .827106E-06, .431224E-06, .185452E-06,
     +  .521527E-07, .352292E-08, .000000E+00, .329545E+06,
     +  .251773E+06, .189370E+06, .142337E+06, .106931E+06,
     +  .802698E+05, .602226E+05, .451447E+05, .338211E+05,
     +  .253152E+05, .189357E+05, .141502E+05, .105663E+05 /
        DATA (UPDI(I),I=469,520) /
     +  .788185E+04, .587465E+04, .437362E+04, .325322E+04,
     +  .241684E+04, .179374E+04, .132950E+04, .984387E+03,
     +  .727810E+03, .537496E+03, .396338E+03, .291892E+03,
     +  .214638E+03, .157681E+03, .115137E+03, .843494E+02,
     +  .616986E+02, .450910E+02, .329114E+02, .240070E+02,
     +  .175141E+02, .127702E+02, .931189E+01, .679905E+01,
     +  .496940E+01, .364123E+01, .267368E+01, .197133E+01,
     +  .145816E+01, .108351E+01, .808403E+00, .606339E+00,
     +  .456666E+00, .346113E+00, .262823E+00, .200928E+00,
     +  .153787E+00, .118257E+00, .911072E-01, .703756E-01,
     +  .544070E-01, .421177E-01, .325800E-01, .251946E-01,
     +  .194460E-01, .149901E-01, .115161E-01, .882443E-02,
     +  .673095E-02, .511316E-02, .386793E-02, .290447E-02 /
        DATA (UPDI(I),I=521,572) /
     +  .216419E-02, .160136E-02, .117457E-02, .854626E-03,
     +  .615483E-03, .439298E-03, .310064E-03, .216678E-03,
     +  .149505E-03, .102649E-03, .695897E-04, .469466E-04,
     +  .314705E-04, .210976E-04, .141125E-04, .948273E-05,
     +  .634689E-05, .421755E-05, .273824E-05, .170872E-05,
     +  .989338E-06, .509223E-06, .213515E-06, .579768E-07,
     +  .400314E-08, .000000E+00, .455992E+06, .347398E+06,
     +  .260435E+06, .195103E+06, .146078E+06, .109285E+06,
     +  .817097E+05, .610398E+05, .455684E+05, .339871E+05,
     +  .253307E+05, .188603E+05, .140315E+05, .104278E+05,
     +  .774283E+04, .574248E+04, .425486E+04, .314860E+04,
     +  .232755E+04, .171822E+04, .126700E+04, .932892E+03,
     +  .686052E+03, .503729E+03, .369374E+03, .270417E+03 /
        DATA (UPDI(I),I=573,624) /
     +  .197766E+03, .143741E+03, .104815E+03, .763089E+02,
     +  .554998E+02, .403114E+02, .292576E+02, .212369E+02,
     +  .154039E+02, .111733E+02, .811393E+01, .589810E+01,
     +  .429747E+01, .313774E+01, .230009E+01, .169144E+01,
     +  .124937E+01, .926597E+00, .690751E+00, .517069E+00,
     +  .389462E+00, .293908E+00, .223271E+00, .169812E+00,
     +  .129744E+00, .993246E-01, .762290E-01, .585558E-01,
     +  .450345E-01, .346122E-01, .265923E-01, .203930E-01,
     +  .156177E-01, .119213E-01, .907565E-02, .687847E-02,
     +  .519167E-02, .390235E-02, .291169E-02, .215626E-02,
     +  .158591E-02, .115661E-02, .836997E-03, .599866E-03,
     +  .426324E-03, .299921E-03, .209152E-03, .144288E-03,
     +  .992227E-04, .675718E-04, .459198E-04, .311154E-04 /
        DATA (UPDI(I),I=625,676) /
     +  .211375E-04, .143612E-04, .979624E-05, .664652E-05,
     +  .445651E-05, .290532E-05, .180815E-05, .103790E-05,
     +  .525802E-06, .214949E-06, .565150E-07, .397152E-08,
     +  .000000E+00, .612213E+06, .465082E+06, .347492E+06,
     +  .259444E+06, .193590E+06, .144331E+06, .107536E+06,
     +  .800507E+05, .595476E+05, .442538E+05, .328623E+05,
     +  .243781E+05, .180689E+05, .133777E+05, .989525E+04,
     +  .731054E+04, .539551E+04, .397691E+04, .292805E+04,
     +  .215277E+04, .158088E+04, .115915E+04, .848833E+03,
     +  .620578E+03, .453072E+03, .330220E+03, .240412E+03,
     +  .173927E+03, .126236E+03, .914704E+02, .662053E+02,
     +  .478522E+02, .345564E+02, .249563E+02, .180074E+02,
     +  .129930E+02, .938440E+01, .678446E+01, .491567E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .356894E+01, .260111E+01, .190174E+01, .139640E+01,
     +  .102951E+01, .762833E+00, .567572E+00, .424879E+00,
     +  .318667E+00, .240566E+00, .181826E+00, .138047E+00,
     +  .105019E+00, .800875E-01, .611314E-01, .467141E-01,
     +  .356751E-01, .272334E-01, .207524E-01, .157909E-01,
     +  .119773E-01, .906006E-02, .682356E-02, .511767E-02,
     +  .382269E-02, .283445E-02, .208641E-02, .152551E-02,
     +  .110636E-02, .796403E-03, .568084E-03, .402070E-03,
     +  .281964E-03, .196237E-03, .135347E-03, .932030E-04,
     +  .637218E-04, .435704E-04, .297812E-04, .204362E-04,
     +  .140398E-04, .966927E-05, .660991E-05, .444600E-05,
     +  .289549E-05, .179037E-05, .101616E-05, .505954E-06,
     +  .201657E-06, .514218E-07, .367164E-08, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .803231E+06, .608433E+06, .453059E+06, .337109E+06,
     +  .250672E+06, .186239E+06, .138271E+06, .102564E+06,
     +  .760202E+05, .562905E+05, .416468E+05, .307800E+05,
     +  .227281E+05, .167634E+05, .123519E+05, .909003E+04,
     +  .668239E+04, .490584E+04, .359740E+04, .263409E+04,
     +  .192633E+04, .140653E+04, .102559E+04, .746574E+03,
     +  .542671E+03, .393762E+03, .285373E+03, .205494E+03,
     +  .148450E+03, .107059E+03, .771131E+02, .554634E+02,
     +  .398521E+02, .286352E+02, .205545E+02, .147529E+02,
     +  .105981E+02, .762027E+01, .549056E+01, .396401E+01,
     +  .287251E+01, .208807E+01, .152424E+01, .111715E+01,
     +  .822815E+00, .608527E+00, .452772E+00, .337520E+00,
     +  .253225E+00, .190213E+00, .143514E+00, .108503E+00 /
        DATA (UPDI(I),I=781,832) /
     +  .822259E-01, .623724E-01, .473611E-01, .359427E-01,
     +  .272646E-01, .206464E-01, .156110E-01, .117670E-01,
     +  .884517E-02, .662061E-02, .493464E-02, .366340E-02,
     +  .269979E-02, .197560E-02, .143625E-02, .103602E-02,
     +  .741993E-03, .526908E-03, .371492E-03, .259776E-03,
     +  .180493E-03, .124490E-03, .858605E-04, .589259E-04,
     +  .405185E-04, .279034E-04, .193042E-04, .133722E-04,
     +  .926695E-05, .635929E-05, .427636E-05, .277391E-05,
     +  .170040E-05, .952792E-06, .465847E-06, .181028E-06,
     +  .448248E-07, .324927E-08, .000000E+00, .103447E+07,
     +  .781317E+06, .579806E+06, .429936E+06, .318586E+06,
     +  .235866E+06, .174495E+06, .128970E+06, .952457E+05,
     +  .702687E+05, .517962E+05, .381382E+05, .280549E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .206133E+05, .151298E+05, .110909E+05, .812101E+04,
     +  .593817E+04, .433673E+04, .316244E+04, .230308E+04,
     +  .167455E+04, .121581E+04, .881214E+03, .637725E+03,
     +  .460667E+03, .332346E+03, .238205E+03, .171276E+03,
     +  .122936E+03, .881212E+02, .630710E+02, .450917E+02,
     +  .322363E+02, .230195E+02, .164355E+02, .117435E+02,
     +  .839815E+01, .601758E+01, .432030E+01, .311290E+01,
     +  .224987E+01, .163279E+01, .118973E+01, .871072E+00,
     +  .640383E+00, .473612E+00, .350926E+00, .261676E+00,
     +  .195361E+00, .146491E+00, .110077E+00, .829023E-01,
     +  .624983E-01, .471611E-01, .355698E-01, .268142E-01,
     +  .201803E-01, .151638E-01, .113599E-01, .848650E-02,
     +  .631367E-02, .467727E-02, .345157E-02, .252859E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .183979E-02, .133015E-02, .954551E-03, .680372E-03,
     +  .481143E-03, .338046E-03, .235809E-03, .163640E-03,
     +  .112911E-03, .780229E-04, .537554E-04, .371611E-04,
     +  .257615E-04, .179421E-04, .125054E-04, .869923E-05,
     +  .597726E-05, .400912E-05, .258504E-05, .156868E-05,
     +  .866873E-06, .415935E-06, .157602E-06, .379340E-07,
     +  .279017E-08, .000000E+00, .131168E+07, .987809E+06,
     +  .730525E+06, .539826E+06, .398617E+06, .294079E+06,
     +  .216785E+06, .159651E+06, .117475E+06, .863510E+05,
     +  .634143E+05, .465179E+05, .340893E+05, .249511E+05,
     +  .182427E+05, .133204E+05, .971482E+04, .707511E+04,
     +  .514606E+04, .373722E+04, .271034E+04, .196236E+04,
     +  .141868E+04, .102381E+04, .737664E+03, .530478E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .380975E+03, .271788E+03, .194511E+03, .138954E+03,
     +  .991228E+02, .705989E+02, .502221E+02, .357233E+02,
     +  .253778E+02, .180247E+02, .128103E+02, .911172E+01,
     +  .649303E+01, .463582E+01, .332141E+01, .238694E+01,
     +  .172227E+01, .124767E+01, .908120E+00, .663683E+00,
     +  .487927E+00, .359373E+00, .266358E+00, .197657E+00,
     +  .147312E+00, .110025E+00, .823574E-01, .617101E-01,
     +  .462806E-01, .346931E-01, .259934E-01, .194440E-01,
     +  .145214E-01, .108131E-01, .802923E-02, .593804E-02,
     +  .437287E-02, .320815E-02, .233675E-02, .169086E-02,
     +  .121603E-02, .868400E-03, .616201E-03, .434111E-03,
     +  .304071E-03, .211689E-03, .146795E-03, .101374E-03,
     +  .702101E-04, .485663E-04, .337453E-04, .235313E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .164784E-04, .115361E-04, .803985E-05, .552019E-05,
     +  .368663E-05, .235946E-05, .141588E-05, .771054E-06,
     +  .362895E-06, .134092E-06, .314040E-07, .234300E-08,
     +  .000000E+00, .164086E+07, .123212E+07, .908070E+06,
     +  .668703E+06, .492054E+06, .361731E+06, .265705E+06,
     +  .194974E+06, .142944E+06, .104686E+06, .765938E+05,
     +  .559751E+05, .408640E+05, .297952E+05, .216998E+05,
     +  .157827E+05, .114649E+05, .831624E+04, .602422E+04,
     +  .435701E+04, .314668E+04, .226869E+04, .163314E+04,
     +  .117349E+04, .841800E+03, .602666E+03, .430860E+03,
     +  .305949E+03, .217940E+03, .154958E+03, .110009E+03,
     +  .779716E+02, .551915E+02, .390614E+02, .276068E+02,
     +  .195061E+02, .137896E+02, .975583E+01, .691413E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .490933E+01, .349769E+01, .249946E+01, .179315E+01,
     +  .129156E+01, .934601E+00, .679048E+00, .496288E+00,
     +  .363371E+00, .267716E+00, .197479E+00, .146297E+00,
     +  .108615E+00, .808126E-01, .601895E-01, .448674E-01,
     +  .334320E-01, .248979E-01, .185135E-01, .137436E-01,
     +  .101734E-01, .750961E-02, .552154E-02, .404261E-02,
     +  .294909E-02, .213613E-02, .153753E-02, .110021E-02,
     +  .782084E-03, .552667E-03, .388029E-03, .271085E-03,
     +  .188444E-03, .130649E-03, .903400E-04, .627318E-04,
     +  .435697E-04, .304191E-04, .213205E-04, .149943E-04,
     +  .105273E-04, .733860E-05, .502695E-05, .333821E-05,
     +  .211819E-05, .125596E-05, .673611E-06, .310875E-06,
     +  .112040E-06, .255540E-07, .193341E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .202815E+07, .151854E+07, .111531E+07, .818474E+06,
     +  .600155E+06, .439646E+06, .321785E+06, .235278E+06,
     +  .171865E+06, .125405E+06, .914122E+05, .665544E+05,
     +  .484032E+05, .351573E+05, .255059E+05, .184785E+05,
     +  .133700E+05, .965934E+04, .696880E+04, .501955E+04,
     +  .361012E+04, .259190E+04, .185787E+04, .132921E+04,
     +  .949345E+03, .676639E+03, .481567E+03, .340375E+03,
     +  .241341E+03, .170793E+03, .120671E+03, .851153E+02,
     +  .599511E+02, .422186E+02, .296862E+02, .208672E+02,
     +  .146743E+02, .103266E+02, .727907E+01, .514027E+01,
     +  .364193E+01, .258800E+01, .184617E+01, .132219E+01,
     +  .951257E+00, .687154E+00, .499296E+00, .363435E+00,
     +  .266188E+00, .195195E+00, .143749E+00, .106095E+00 /
        DATA (UPDI(I),I=1145,1196) /
     +  .784694E-01, .580989E-01, .430514E-01, .318894E-01,
     +  .236088E-01, .174520E-01, .128795E-01, .947855E-02,
     +  .695624E-02, .508570E-02, .370255E-02, .268623E-02,
     +  .193532E-02, .138596E-02, .987050E-03, .698639E-03,
     +  .491846E-03, .344296E-03, .240019E-03, .166683E-03,
     +  .115594E-03, .800652E-04, .557570E-04, .388814E-04,
     +  .272661E-04, .191930E-04, .135408E-04, .952090E-05,
     +  .662929E-05, .452437E-05, .298413E-05, .187561E-05,
     +  .109817E-05, .579794E-06, .262317E-06, .922294E-07,
     +  .205041E-07, .157286E-08, .000000E+00, .247972E+07,
     +  .185130E+07, .135505E+07, .990983E+06, .724116E+06,
     +  .528591E+06, .385510E+06, .280861E+06, .204420E+06,
     +  .148614E+06, .107929E+06, .782869E+05, .567209E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .410418E+05, .296601E+05, .214045E+05, .154260E+05,
     +  .111004E+05, .797613E+04, .572171E+04, .409812E+04,
     +  .292998E+04, .209130E+04, .148981E+04, .105942E+04,
     +  .751758E+03, .532635E+03, .374741E+03, .264486E+03,
     +  .186301E+03, .131004E+03, .919604E+02, .644557E+02,
     +  .451665E+02, .315986E+02, .220978E+02, .154588E+02,
     +  .108214E+02, .758703E+01, .532879E+01, .375478E+01,
     +  .265344E+01, .188226E+01, .134045E+01, .958908E+00,
     +  .688722E+00, .497564E+00, .360080E+00, .262200E+00,
     +  .191152E+00, .139951E+00, .102691E+00, .755082E-01,
     +  .555809E-01, .409446E-01, .301528E-01, .221935E-01,
     +  .163114E-01, .119684E-01, .875807E-02, .639122E-02,
     +  .464683E-02, .336454E-02, .242809E-02, .174036E-02 /
        DATA (UPDI(I),I=1249,1300) /
     +  .124035E-02, .879409E-03, .619987E-03, .435000E-03,
     +  .303722E-03, .211379E-03, .146719E-03, .101822E-03,
     +  .706692E-04, .493632E-04, .345563E-04, .243286E-04,
     +  .171846E-04, .121488E-04, .854389E-05, .593480E-05,
     +  .403089E-05, .263824E-05, .164131E-05, .948443E-06,
     +  .492744E-06, .218514E-06, .749704E-07, .162597E-07,
     +  .126436E-08, .000000E+00, .572254E+05, .341333E+05,
     +  .265764E+05, .206927E+05, .161117E+05, .125449E+05,
     +  .976787E+04, .760566E+04, .592217E+04, .461140E+04,
     +  .359084E+04, .279621E+04, .217751E+04, .169578E+04,
     +  .132070E+04, .102864E+04, .801236E+03, .624166E+03,
     +  .486287E+03, .378922E+03, .295316E+03, .230208E+03,
     +  .179504E+03, .140014E+03, .109256E+03, .852966E+02 /
        DATA (UPDI(I),I=1301,1352) /
     +  .666312E+02, .519063E+02, .406167E+02, .318153E+02,
     +  .249516E+02, .195969E+02, .154174E+02, .121616E+02,
     +  .960965E+01, .761348E+01, .604982E+01, .482272E+01,
     +  .385754E+01, .309595E+01, .249388E+01, .201531E+01,
     +  .163345E+01, .132737E+01, .108087E+01, .881451E+00,
     +  .719967E+00, .587406E+00, .479567E+00, .390539E+00,
     +  .317656E+00, .257702E+00, .208388E+00, .167862E+00,
     +  .134614E+00, .107408E+00, .852188E-01, .671958E-01,
     +  .526269E-01, .409145E-01, .315562E-01, .241294E-01,
     +  .182792E-01, .137268E-01, .101787E-01, .745896E-02,
     +  .539619E-02, .384966E-02, .270475E-02, .186883E-02,
     +  .126775E-02, .842739E-03, .547607E-03, .346739E-03,
     +  .214284E-03, .127888E-03, .736332E-04, .406805E-04 /
        DATA (UPDI(I),I=1353,1404) /
     +  .214226E-04, .106633E-04, .496330E-05, .213317E-05,
     +  .825518E-06, .282305E-06, .816988E-07, .188268E-07,
     +  .311934E-08, .306839E-09, .116568E-10, .432277E-13,
     +  .000000E+00, .797247E+05, .622003E+05, .479404E+05,
     +  .369451E+05, .284718E+05, .219388E+05, .169049E+05,
     +  .130242E+05, .100344E+05, .772977E+04, .595450E+04,
     +  .458629E+04, .353251E+04, .272047E+04, .209516E+04,
     +  .161337E+04, .124242E+04, .956662E+03, .736687E+03,
     +  .567254E+03, .436853E+03, .336429E+03, .259148E+03,
     +  .199640E+03, .153848E+03, .118594E+03, .914753E+02,
     +  .703320E+02, .543255E+02, .419951E+02, .325040E+02,
     +  .251895E+02, .195547E+02, .152195E+02, .118668E+02,
     +  .927680E+01, .727531E+01, .572403E+01, .452036E+01 /
        DATA (UPDI(I),I=1405,1456) /
     +  .358237E+01, .285088E+01, .227661E+01, .182444E+01,
     +  .146639E+01, .118179E+01, .954216E+00, .772230E+00,
     +  .624443E+00, .505660E+00, .408576E+00, .329941E+00,
     +  .265850E+00, .213639E+00, .171088E+00, .136477E+00,
     +  .108358E+00, .855904E-01, .672132E-01, .524539E-01,
     +  .406499E-01, .312692E-01, .238575E-01, .180425E-01,
     +  .135338E-01, .100297E-01, .734864E-02, .531869E-02,
     +  .379781E-02, .267245E-02, .184991E-02, .125774E-02,
     +  .837656E-03, .545144E-03, .344731E-03, .212048E-03,
     +  .124833E-03, .697476E-04, .361272E-04, .165136E-04,
     +  .576418E-05, .361676E-06, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .127720E+06, .990853E+05, .758740E+05, .580860E+05,
     +  .444648E+05, .340287E+05, .260398E+05, .199209E+05,
     +  .152385E+05, .116533E+05, .891081E+04, .681173E+04,
     +  .520665E+04, .397860E+04, .303994E+04, .232205E+04,
     +  .177357E+04, .135425E+04, .103403E+04, .789322E+03,
     +  .602538E+03, .459863E+03, .351001E+03, .267881E+03,
     +  .204483E+03, .156100E+03, .119229E+03, .907409E+02,
     +  .693775E+02, .530739E+02, .406478E+02, .311637E+02,
     +  .239311E+02, .184219E+02, .142057E+02, .109818E+02,
     +  .851708E+01, .662655E+01, .517565E+01, .405692E+01,
     +  .319412E+01, .252399E+01, .200214E+01, .159331E+01,
     +  .127193E+01, .101761E+01, .816406E+00, .654627E+00,
     +  .525954E+00, .421769E+00, .338186E+00, .270657E+00 /
        DATA (UPDI(I),I=1509,1560) /
     +  .216129E+00, .172049E+00, .136480E+00, .107790E+00,
     +  .847248E-01, .662278E-01, .514682E-01, .397308E-01,
     +  .304563E-01, .231652E-01, .174719E-01, .130769E-01,
     +  .967463E-02, .707990E-02, .512161E-02, .365805E-02,
     +  .257759E-02, .178884E-02, .122156E-02, .819012E-03,
     +  .538394E-03, .345497E-03, .217281E-03, .132296E-03,
     +  .780237E-04, .442242E-04, .239317E-04, .121715E-04,
     +  .570738E-05, .235349E-05, .758465E-06, .933695E-07,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .189985E+06,
     +  .146736E+06, .111784E+06, .851286E+05, .648188E+05,
     +  .493361E+05, .375450E+05, .285609E+05, .217225E+05,
     +  .165148E+05, .125532E+05, .953789E+04, .724543E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .550163E+04, .417668E+04, .316945E+04, .240465E+04,
     +  .182361E+04, .138273E+04, .104800E+04, .794208E+03,
     +  .601657E+03, .455756E+03, .345138E+03, .261374E+03,
     +  .197916E+03, .149925E+03, .113127E+03, .857485E+02,
     +  .650201E+02, .493502E+02, .374891E+02, .285200E+02,
     +  .217467E+02, .166086E+02, .127145E+02, .976449E+01,
     +  .752230E+01, .581758E+01, .451543E+01, .352077E+01,
     +  .275556E+01, .216541E+01, .170750E+01, .135104E+01,
     +  .107162E+01, .852673E+00, .678242E+00, .540806E+00,
     +  .430504E+00, .342790E+00, .272515E+00, .216236E+00,
     +  .171095E+00, .134946E+00, .105996E+00, .828830E-01,
     +  .644691E-01, .498695E-01, .383281E-01, .292614E-01,
     +  .221721E-01, .166646E-01, .124333E-01, .917260E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .669602E-02, .483435E-02, .344791E-02, .242779E-02,
     +  .168509E-02, .115223E-02, .774754E-03, .511878E-03,
     +  .331149E-03, .210881E-03, .130888E-03, .795119E-04,
     +  .471571E-04, .273990E-04, .155848E-04, .877142E-05,
     +  .490180E-05, .275523E-05, .155952E-05, .888755E-06,
     +  .492324E-06, .254040E-06, .111669E-06, .328184E-07,
     +  .212498E-08, .000000E+00, .269691E+06, .207484E+06,
     +  .157345E+06, .119273E+06, .903907E+05, .684713E+05,
     +  .518536E+05, .392503E+05, .297020E+05, .224655E+05,
     +  .169870E+05, .128379E+05, .969933E+04, .732417E+04,
     +  .552891E+04, .417142E+04, .314625E+04, .237171E+04,
     +  .178731E+04, .134617E+04, .101366E+04, .762889E+03,
     +  .574034E+03, .431741E+03, .324675E+03, .244091E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .183554E+03, .137453E+03, .103390E+03, .777832E+02,
     +  .585649E+02, .441252E+02, .332879E+02, .251668E+02,
     +  .190543E+02, .144588E+02, .110054E+02, .840234E+01,
     +  .643976E+01, .495340E+01, .382777E+01, .296931E+01,
     +  .231301E+01, .180827E+01, .141881E+01, .111619E+01,
     +  .881151E+00, .695510E+00, .550500E+00, .435092E+00,
     +  .344072E+00, .271733E+00, .214253E+00, .168496E+00,
     +  .132122E+00, .103196E+00, .802594E-01, .621063E-01,
     +  .478048E-01, .365677E-01, .277920E-01, .209690E-01,
     +  .156965E-01, .116666E-01, .857642E-02, .624028E-02,
     +  .449215E-02, .319578E-02, .224578E-02, .155666E-02,
     +  .106392E-02, .715873E-03, .474074E-03, .308112E-03,
     +  .197726E-03, .124249E-03, .769182E-04, .469129E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .283747E-04, .170619E-04, .103237E-04, .629191E-05,
     +  .387815E-05, .239032E-05, .145047E-05, .832735E-06,
     +  .432109E-06, .185535E-06, .521558E-07, .352293E-08,
     +  .000000E+00, .370480E+06, .283993E+06, .214457E+06,
     +  .161870E+06, .122138E+06, .921108E+05, .694418E+05,
     +  .523231E+05, .394102E+05, .296670E+05, .223241E+05,
     +  .167886E+05, .126207E+05, .948160E+04, .712033E+04,
     +  .534368E+04, .400866E+04, .300518E+04, .225196E+04,
     +  .168642E+04, .126242E+04, .944431E+03, .706288E+03,
     +  .527891E+03, .394442E+03, .294599E+03, .220054E+03,
     +  .163641E+03, .122224E+03, .912933E+02, .682318E+02,
     +  .510228E+02, .381956E+02, .286517E+02, .215194E+02,
     +  .161970E+02, .122270E+02, .925746E+01, .703574E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .536641E+01, .411219E+01, .316338E+01, .244384E+01,
     +  .189504E+01, .147503E+01, .115136E+01, .902016E+00,
     +  .706689E+00, .555341E+00, .435852E+00, .342349E+00,
     +  .268609E+00, .210454E+00, .164501E+00, .128229E+00,
     +  .995846E-01, .770233E-01, .592846E-01, .453979E-01,
     +  .345539E-01, .261358E-01, .196287E-01, .146280E-01,
     +  .108263E-01, .792637E-02, .574518E-02, .412103E-02,
     +  .292231E-02, .204784E-02, .141624E-02, .966448E-03,
     +  .649920E-03, .430736E-03, .280709E-03, .181074E-03,
     +  .114800E-03, .720460E-04, .448245E-04, .278536E-04,
     +  .173386E-04, .109177E-04, .693551E-05, .443380E-05,
     +  .280832E-05, .172782E-05, .993482E-06, .509866E-06,
     +  .213575E-06, .579790E-07, .400316E-08, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .496465E+06, .379254E+06, .285238E+06, .214414E+06,
     +  .161114E+06, .120992E+06, .908245E+05, .681368E+05,
     +  .510940E+05, .382895E+05, .286806E+05, .214686E+05,
     +  .160624E+05, .120092E+05, .897417E+04, .670133E+04,
     +  .500152E+04, .373007E+04, .278037E+04, .207091E+04,
     +  .154170E+04, .114688E+04, .852765E+03, .633633E+03,
     +  .470613E+03, .349331E+03, .259300E+03, .191572E+03,
     +  .142146E+03, .105460E+03, .782779E+02, .581239E+02,
     +  .431984E+02, .321674E+02, .239790E+02, .179110E+02,
     +  .134163E+02, .100785E+02, .759927E+01, .575028E+01,
     +  .437136E+01, .333615E+01, .255704E+01, .196741E+01,
     +  .151963E+01, .117724E+01, .915517E+00, .712087E+00,
     +  .555664E+00, .433117E+00, .337938E+00, .263436E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .205105E+00, .159343E+00, .123471E+00, .953371E-01,
     +  .733245E-01, .561303E-01, .427544E-01, .323744E-01,
     +  .243647E-01, .182100E-01, .135067E-01, .995094E-02,
     +  .725328E-02, .523515E-02, .374022E-02, .264249E-02,
     +  .184559E-02, .127275E-02, .866629E-03, .582041E-03,
     +  .385729E-03, .251811E-03, .163061E-03, .104116E-03,
     +  .660594E-04, .417488E-04, .264740E-04, .168880E-04,
     +  .109100E-04, .709903E-05, .462105E-05, .295807E-05,
     +  .182235E-05, .104094E-05, .526268E-06, .214992E-06,
     +  .565166E-07, .397153E-08, .000000E+00, .652228E+06,
     +  .496578E+06, .372015E+06, .278538E+06, .208455E+06,
     +  .155906E+06, .116548E+06, .870671E+05, .650105E+05,
     +  .485072E+05, .361740E+05, .269566E+05, .200765E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .149409E+05, .111124E+05, .825828E+04, .613346E+04,
     +  .455155E+04, .337552E+04, .250124E+04, .185227E+04,
     +  .137053E+04, .101347E+04, .748838E+03, .553002E+03,
     +  .408088E+03, .301106E+03, .221083E+03, .163019E+03,
     +  .120176E+03, .886182E+02, .653636E+02, .482474E+02,
     +  .356779E+02, .264069E+02, .195821E+02, .145603E+02,
     +  .108567E+02, .812448E+01, .610127E+01, .460300E+01,
     +  .348634E+01, .265198E+01, .202521E+01, .155270E+01,
     +  .119409E+01, .921985E+00, .712068E+00, .551837E+00,
     +  .427237E+00, .331162E+00, .256503E+00, .198460E+00,
     +  .153242E+00, .118037E+00, .906125E-01, .692955E-01,
     +  .527528E-01, .399643E-01, .301021E-01, .225379E-01,
     +  .167602E-01, .123703E-01, .907016E-02, .658049E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .472831E-02, .336373E-02, .236702E-02, .164717E-02,
     +  .113233E-02, .769054E-03, .515651E-03, .341577E-03,
     +  .223267E-03, .145051E-03, .931928E-04, .596929E-04,
     +  .382284E-04, .246414E-04, .160140E-04, .105316E-04,
     +  .695693E-05, .457087E-05, .293508E-05, .180091E-05,
     +  .101839E-05, .506291E-06, .201687E-06, .514229E-07,
     +  .367165E-08, .000000E+00, .842794E+06, .639573E+06,
     +  .477304E+06, .355986E+06, .265370E+06, .197682E+06,
     +  .147181E+06, .109501E+06, .814208E+05, .604955E+05,
     +  .449206E+05, .333290E+05, .247127E+05, .183086E+05,
     +  .135549E+05, .100267E+05, .741169E+04, .547370E+04,
     +  .403954E+04, .297837E+04, .219441E+04, .161529E+04,
     +  .118816E+04, .873191E+03, .641291E+03, .470581E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .345225E+03, .251973E+03, .184684E+03, .135316E+03,
     +  .991580E+02, .726711E+02, .532909E+02, .391461E+02,
     +  .287769E+02, .211922E+02, .156467E+02, .115837E+02,
     +  .860613E+01, .641614E+01, .480527E+01, .361301E+01,
     +  .272833E+01, .206845E+01, .157448E+01, .120226E+01,
     +  .921830E+00, .707048E+00, .544257E+00, .418576E+00,
     +  .322346E+00, .248095E+00, .190763E+00, .146405E+00,
     +  .112100E+00, .855533E-01, .650531E-01, .492467E-01,
     +  .371035E-01, .277975E-01, .207030E-01, .153166E-01,
     +  .112478E-01, .820655E-02, .592527E-02, .423778E-02,
     +  .300141E-02, .210329E-02, .145806E-02, .998999E-03,
     +  .676677E-03, .452903E-03, .299845E-03, .196211E-03,
     +  .127870E-03, .826353E-04, .533934E-04, .345971E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .226095E-04, .149107E-04, .993284E-05, .662471E-05,
     +  .437088E-05, .280355E-05, .170820E-05, .954422E-06,
     +  .466091E-06, .181050E-06, .448256E-07, .324927E-08,
     +  .000000E+00, .107358E+07, .812104E+06, .603776E+06,
     +  .448599E+06, .333116E+06, .247179E+06, .183302E+06,
     +  .135828E+06, .100585E+06, .744255E+05, .550325E+05,
     +  .406579E+05, .300166E+05, .221405E+05, .163188E+05,
     +  .120166E+05, .884171E+04, .649927E+04, .477356E+04,
     +  .350254E+04, .256787E+04, .188070E+04, .137631E+04,
     +  .100619E+04, .735033E+03, .536435E+03, .391352E+03,
     +  .284001E+03, .206956E+03, .150741E+03, .109795E+03,
     +  .799723E+02, .582760E+02, .425345E+02, .310631E+02,
     +  .227239E+02, .166639E+02, .122524E+02, .903972E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .669230E+01, .497683E+01, .371565E+01, .278605E+01,
     +  .209741E+01, .158538E+01, .120222E+01, .915534E+00,
     +  .697485E+00, .533345E+00, .407508E+00, .311814E+00,
     +  .238485E+00, .182244E+00, .139023E+00, .105815E+00,
     +  .802862E-01, .606985E-01, .456923E-01, .342353E-01,
     +  .255098E-01, .188980E-01, .139084E-01, .101612E-01,
     +  .737664E-02, .529993E-02, .377261E-02, .265989E-02,
     +  .185608E-02, .128171E-02, .875227E-03, .591248E-03,
     +  .395039E-03, .261416E-03, .171276E-03, .111976E-03,
     +  .727816E-04, .474163E-04, .310519E-04, .205332E-04,
     +  .137012E-04, .921206E-05, .617970E-05, .408047E-05,
     +  .260717E-05, .157443E-05, .868061E-06, .416110E-06,
     +  .157617E-06, .379346E-07, .279017E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .135035E+07, .101825E+07, .754222E+06, .558276E+06,
     +  .412982E+06, .305262E+06, .225492E+06, .166431E+06,
     +  .122753E+06, .904601E+05, .666133E+05, .490085E+05,
     +  .360282E+05, .264606E+05, .194178E+05, .142352E+05,
     +  .104270E+05, .762949E+04, .557761E+04, .407315E+04,
     +  .297183E+04, .216590E+04, .157712E+04, .114713E+04,
     +  .833657E+03, .605190E+03, .439131E+03, .316899E+03,
     +  .229633E+03, .166304E+03, .120422E+03, .871910E+02,
     +  .631494E+02, .458067E+02, .332412E+02, .241609E+02,
     +  .176018E+02, .128563E+02, .942163E+01, .692787E+01,
     +  .511690E+01, .379412E+01, .282541E+01, .211254E+01,
     +  .158597E+01, .119456E+01, .903640E+00, .683872E+00,
     +  .519537E+00, .394406E+00, .299883E+00, .227937E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .173119E+00, .131269E+00, .993215E-01, .749214E-01,
     +  .563184E-01, .421566E-01, .314110E-01, .232779E-01,
     +  .171521E-01, .125573E-01, .912653E-02, .659201E-02,
     +  .471275E-02, .333867E-02, .234325E-02, .162821E-02,
     +  .112004E-02, .762315E-03, .513651E-03, .342659E-03,
     +  .226702E-03, .148753E-03, .975836E-04, .637956E-04,
     +  .418928E-04, .277016E-04, .185042E-04, .124629E-04,
     +  .843371E-05, .567417E-05, .374034E-05, .237593E-05,
     +  .142011E-05, .771918E-06, .363021E-06, .134104E-06,
     +  .314044E-07, .234300E-08, .000000E+00, .167909E+07,
     +  .126221E+07, .931497E+06, .686942E+06, .506254E+06,
     +  .372787E+06, .274312E+06, .201676E+06, .148161E+06,
     +  .108748E+06, .797557E+05, .584367E+05, .427803E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .312870E+05, .228611E+05, .166867E+05, .121686E+05,
     +  .886392E+04, .645050E+04, .468879E+04, .340489E+04,
     +  .246964E+04, .178951E+04, .129516E+04, .936473E+03,
     +  .676318E+03, .488162E+03, .350370E+03, .252501E+03,
     +  .181849E+03, .130931E+03, .942514E+02, .678596E+02,
     +  .489281E+02, .352884E+02, .254891E+02, .184516E+02,
     +  .133904E+02, .974919E+01, .712169E+01, .522523E+01,
     +  .384871E+01, .284696E+01, .211451E+01, .157692E+01,
     +  .117991E+01, .886737E+00, .666724E+00, .503271E+00,
     +  .379637E+00, .286853E+00, .216696E+00, .163585E+00,
     +  .123300E+00, .927427E-01, .695536E-01, .519848E-01,
     +  .386941E-01, .286711E-01, .211316E-01, .154870E-01,
     +  .112785E-01, .815456E-02, .586013E-02, .416877E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .293928E-02, .205364E-02, .142102E-02, .973843E-03,
     +  .660733E-03, .444152E-03, .295914E-03, .195793E-03,
     +  .128707E-03, .847457E-04, .557289E-04, .368755E-04,
     +  .245994E-04, .165740E-04, .112438E-04, .764028E-05,
     +  .514375E-05, .337853E-05, .213042E-05, .125907E-05,
     +  .674238E-06, .310965E-06, .112048E-06, .255543E-07,
     +  .193341E-08, .000000E+00, .206594E+07, .154828E+07,
     +  .113847E+07, .836505E+06, .614192E+06, .450575E+06,
     +  .330293E+06, .241901E+06, .177022E+06, .129420E+06,
     +  .945374E+05, .689873E+05, .502970E+05, .366314E+05,
     +  .266534E+05, .193716E+05, .140651E+05, .102003E+05,
     +  .738982E+04, .534718E+04, .386505E+04, .279024E+04,
     +  .201216E+04, .144924E+04, .104269E+04, .749226E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .538009E+03, .384101E+03, .275336E+03, .197220E+03,
     +  .141212E+03, .101080E+03, .723575E+02, .518668E+02,
     +  .371846E+02, .266960E+02, .192061E+02, .138510E+02,
     +  .100207E+02, .727332E+01, .530211E+01, .388007E+01,
     +  .285151E+01, .210415E+01, .155901E+01, .115898E+01,
     +  .865439E+00, .646560E+00, .484981E+00, .363556E+00,
     +  .273011E+00, .204988E+00, .153818E+00, .115253E+00,
     +  .861829E-01, .642617E-01, .477565E-01, .353478E-01,
     +  .260466E-01, .190928E-01, .139178E-01, .100824E-01,
     +  .725197E-02, .518521E-02, .367049E-02, .257579E-02,
     +  .179169E-02, .123472E-02, .843128E-03, .570365E-03,
     +  .382600E-03, .254660E-03, .168577E-03, .111058E-03,
     +  .734171E-04, .485652E-04, .323694E-04, .217643E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .147694E-04, .100733E-04, .685973E-05, .461272E-05,
     +  .301431E-05, .188467E-05, .110044E-05, .580247E-06,
     +  .262381E-06, .922350E-07, .205043E-07, .157287E-08,
     +  .000000E+00, .251708E+07, .188070E+07, .137794E+07,
     +  .100881E+07, .737992E+06, .539394E+06, .393920E+06,
     +  .287409E+06, .209516E+06, .152582E+06, .111018E+06,
     +  .806912E+05, .585923E+05, .424985E+05, .307939E+05,
     +  .222868E+05, .161127E+05, .116347E+05, .839190E+04,
     +  .604519E+04, .434976E+04, .312571E+04, .224353E+04,
     +  .160818E+04, .115144E+04, .823275E+03, .588212E+03,
     +  .417767E+03, .297910E+03, .212261E+03, .151160E+03,
     +  .107607E+03, .765981E+02, .545944E+02, .389126E+02,
     +  .277718E+02, .198601E+02, .142357E+02, .102356E+02 /
        DATA (UPDI(I),I=2497,2548) /
     +  .738305E+01, .534831E+01, .388918E+01, .284008E+01,
     +  .208242E+01, .153312E+01, .113252E+01, .840373E+00,
     +  .623899E+00, .465086E+00, .346496E+00, .258619E+00,
     +  .193017E+00, .143975E+00, .107245E+00, .797300E-01,
     +  .591100E-01, .436796E-01, .321501E-01, .235599E-01,
     +  .171764E-01, .124540E-01, .897483E-02, .642205E-02,
     +  .456884E-02, .321846E-02, .224814E-02, .155702E-02,
     +  .106879E-02, .727334E-03, .490709E-03, .328578E-03,
     +  .218573E-03, .144813E-03, .956462E-04, .634962E-04,
     +  .422497E-04, .283523E-04, .191959E-04, .131019E-04,
     +  .896867E-05, .611036E-05, .409755E-05, .266077E-05,
     +  .164800E-05, .950101E-06, .493071E-06, .218560E-06,
     +  .749743E-07, .162598E-07, .126436E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .456755E+05, .682926E+05, .531744E+05, .414034E+05,
     +  .322384E+05, .251025E+05, .195464E+05, .152204E+05,
     +  .118521E+05, .922947E+04, .718740E+04, .559739E+04,
     +  .435933E+04, .339531E+04, .264467E+04, .206015E+04,
     +  .160500E+04, .125056E+04, .974541E+03, .759587E+03,
     +  .592179E+03, .461794E+03, .360236E+03, .281127E+03,
     +  .219497E+03, .171478E+03, .134060E+03, .104533E+03,
     +  .818865E+02, .642252E+02, .504467E+02, .396929E+02,
     +  .312952E+02, .247503E+02, .196175E+02, .156001E+02,
     +  .124510E+02, .997779E+01, .803052E+01, .649199E+01,
     +  .527360E+01, .430281E+01, .352569E+01, .290002E+01,
     +  .239321E+01, .198016E+01, .164259E+01, .136242E+01,
     +  .113152E+01, .938069E+00, .777081E+00, .642266E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .529244E+00, .434482E+00, .355108E+00, .288756E+00,
     +  .233456E+00, .187548E+00, .149618E+00, .118454E+00,
     +  .930106E-01, .723840E-01, .557913E-01, .426109E-01,
     +  .321284E-01, .239321E-01, .175935E-01, .127501E-01,
     +  .909710E-02, .638112E-02, .439319E-02, .296298E-02,
     +  .195286E-02, .125388E-02, .785476E-03, .475095E-03,
     +  .277154E-03, .155101E-03, .827135E-04, .416838E-04,
     +  .196389E-04, .854155E-05, .334451E-05, .115693E-05,
     +  .338613E-06, .789000E-07, .132158E-07, .131399E-08,
     +  .504464E-10, .189021E-12, .000000E+00, .122611E+06,
     +  .959593E+05, .742265E+05, .574131E+05, .444094E+05,
     +  .343492E+05, .265688E+05, .205497E+05, .158947E+05,
     +  .122937E+05, .950886E+04, .735461E+04, .568871E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .440006E+04, .340357E+04, .263276E+04, .203672E+04,
     +  .157568E+04, .121918E+04, .943424E+03, .730203E+03,
     +  .565269E+03, .437730E+03, .339067E+03, .262766E+03,
     +  .203734E+03, .158082E+03, .122311E+03, .950810E+02,
     +  .739953E+02, .576707E+02, .450209E+02, .352175E+02,
     +  .276320E+02, .217287E+02, .171413E+02, .135730E+02,
     +  .107902E+02, .861583E+01, .691000E+01, .556939E+01,
     +  .450877E+01, .366612E+01, .299255E+01, .245118E+01,
     +  .201313E+01, .165798E+01, .136534E+01, .112616E+01,
     +  .927260E+00, .763054E+00, .626587E+00, .513075E+00,
     +  .418619E+00, .340100E+00, .274939E+00, .221021E+00,
     +  .176572E+00, .140103E+00, .110337E+00, .861953E-01,
     +  .667497E-01, .511996E-01, .389229E-01, .292141E-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .216647E-01, .158576E-01, .114435E-01, .813115E-02,
     +  .568016E-02, .389450E-02, .261524E-02, .171586E-02,
     +  .109554E-02, .681636E-03, .408311E-03, .234709E-03,
     +  .128182E-03, .654347E-04, .303242E-04, .118782E-04,
     +  .307820E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .170113E+06, .132455E+06,
     +  .101857E+06, .783180E+05, .602186E+05, .462960E+05,
     +  .355922E+05, .273596E+05, .210312E+05, .161646E+05,
     +  .124241E+05, .954810E+04, .733794E+04, .563878E+04,
     +  .433322E+04, .332965E+04, .255867E+04, .196610E+04,
     +  .151092E+04, .116112E+04, .892468E+03, .686028E+03,
     +  .527487E+03, .405666E+03, .312109E+03, .240223E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .185033E+03, .142086E+03, .109629E+03, .846718E+02,
     +  .654913E+02, .507341E+02, .393812E+02, .306597E+02,
     +  .239225E+02, .187246E+02, .147113E+02, .116036E+02,
     +  .919343E+01, .731594E+01, .585131E+01, .470077E+01,
     +  .379338E+01, .307325E+01, .249879E+01, .203732E+01,
     +  .166602E+01, .136230E+01, .111599E+01, .912696E+00,
     +  .746141E+00, .608755E+00, .495345E+00, .401670E+00,
     +  .324374E+00, .260687E+00, .208361E+00, .165522E+00,
     +  .130616E+00, .102314E+00, .795106E-01, .612615E-01,
     +  .467564E-01, .353753E-01, .264275E-01, .195097E-01,
     +  .142186E-01, .102188E-01, .723357E-02, .503596E-02,
     +  .344291E-02, .230701E-02, .151204E-02, .965709E-03,
     +  .602512E-03, .363184E-03, .211370E-03, .118058E-03 /
        DATA (UPDI(I),I=2809,2860) /
     +  .628452E-04, .315405E-04, .147047E-04, .620980E-05,
     +  .224301E-05, .597936E-06, .305384E-07, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .231894E+06, .179725E+06, .137470E+06,
     +  .105130E+06, .803928E+05, .614636E+05, .469884E+05,
     +  .359148E+05, .274491E+05, .209746E+05, .160264E+05,
     +  .122430E+05, .935237E+04, .714284E+04, .545517E+04,
     +  .416552E+04, .318076E+04, .242844E+04, .185414E+04,
     +  .141552E+04, .108079E+04, .825202E+03, .630189E+03,
     +  .481311E+03, .367733E+03, .281039E+03, .214938E+03,
     +  .163848E+03, .125503E+03, .962202E+02, .738736E+02,
     +  .568003E+02, .437584E+02, .338101E+02, .261802E+02,
     +  .203352E+02, .158547E+02, .124097E+02, .975709E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .770532E+01, .611621E+01, .487669E+01, .390610E+01,
     +  .314130E+01, .253563E+01, .205256E+01, .166674E+01,
     +  .135342E+01, .110124E+01, .894620E+00, .726601E+00,
     +  .589026E+00, .476295E+00, .383857E+00, .308132E+00,
     +  .246178E+00, .195629E+00, .154530E+00, .121267E+00,
     +  .944754E-01, .730291E-01, .559764E-01, .425049E-01,
     +  .319996E-01, .237894E-01, .174790E-01, .126803E-01,
     +  .907321E-02, .639609E-02, .443585E-02, .302232E-02,
     +  .201951E-02, .132111E-02, .843168E-03, .526724E-03,
     +  .318836E-03, .187246E-03, .106347E-03, .583381E-04,
     +  .308533E-04, .157980E-04, .788457E-05, .389127E-05,
     +  .194138E-05, .996919E-06, .516711E-06, .257979E-06,
     +  .112049E-06, .328328E-07, .212505E-08, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .311126E+06, .240100E+06, .182741E+06, .139048E+06,
     +  .105788E+06, .804613E+05, .611900E+05, .465209E+05,
     +  .353638E+05, .268747E+05, .204208E+05, .155124E+05,
     +  .117824E+05, .894674E+04, .679287E+04, .515616E+04,
     +  .391352E+04, .296964E+04, .225333E+04, .170948E+04,
     +  .129695E+04, .983855E+03, .746444E+03, .566326E+03,
     +  .429784E+03, .326227E+03, .247787E+03, .187555E+03,
     +  .142651E+03, .108588E+03, .827695E+02, .631777E+02,
     +  .483146E+02, .370553E+02, .284800E+02, .219564E+02,
     +  .169906E+02, .131991E+02, .103001E+02, .807342E+01,
     +  .636088E+01, .503438E+01, .400293E+01, .319589E+01,
     +  .256129E+01, .205871E+01, .166019E+01, .133885E+01,
     +  .108211E+01, .873268E+00, .704674E+00, .567623E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .456131E+00, .365361E+00, .291527E+00, .231540E+00,
     +  .182932E+00, .143679E+00, .112122E+00, .868716E-01,
     +  .667899E-01, .509243E-01, .384673E-01, .288127E-01,
     +  .213126E-01, .155823E-01, .112502E-01, .801276E-02,
     +  .562360E-02, .388392E-02, .263627E-02, .175582E-02,
     +  .114581E-02, .730281E-03, .456357E-03, .277053E-03,
     +  .163853E-03, .943059E-04, .529444E-04, .290836E-04,
     +  .158050E-04, .859640E-05, .474658E-05, .267901E-05,
     +  .153125E-05, .850723E-06, .434976E-06, .185809E-06,
     +  .521662E-07, .352298E-08, .000000E+00, .411447E+06,
     +  .316241E+06, .239566E+06, .181421E+06, .137362E+06,
     +  .103966E+06, .786728E+05, .595115E+05, .450079E+05,
     +  .340265E+05, .257192E+05, .194329E+05, .146802E+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .110858E+05, .836997E+04, .631726E+04, .476721E+04,
     +  .359631E+04, .271267E+04, .204557E+04, .154246E+04,
     +  .116285E+04, .876699E+03, .660905E+03, .498313E+03,
     +  .375756E+03, .283511E+03, .213129E+03, .160994E+03,
     +  .121704E+03, .921178E+02, .698160E+02, .530097E+02,
     +  .403641E+02, .307980E+02, .235703E+02, .181060E+02,
     +  .139625E+02, .108159E+02, .841568E+01, .658228E+01,
     +  .517191E+01, .408274E+01, .323643E+01, .257555E+01,
     +  .205578E+01, .164652E+01, .131883E+01, .105888E+01,
     +  .848919E+00, .680627E+00, .544793E+00, .435070E+00,
     +  .346367E+00, .274715E+00, .216900E+00, .170371E+00,
     +  .133049E+00, .103242E+00, .795490E-01, .608270E-01,
     +  .461296E-01, .346608E-01, .258267E-01, .190056E-01 /
        DATA (UPDI(I),I=3069,3120) /
     +  .138253E-01, .993241E-02, .704019E-02, .491821E-02,
     +  .338187E-02, .228623E-02, .151729E-02, .987375E-03,
     +  .628197E-03, .392490E-03, .238815E-03, .142075E-03,
     +  .827045E-04, .473309E-04, .267870E-04, .151860E-04,
     +  .871281E-05, .509652E-05, .302620E-05, .178805E-05,
     +  .100673E-05, .511950E-06, .213772E-06, .579864E-07,
     +  .400319E-08, .000000E+00, .536970E+06, .411138E+06,
     +  .310064E+06, .233746E+06, .176166E+06, .132713E+06,
     +  .999515E+05, .752442E+05, .566287E+05, .425997E+05,
     +  .320373E+05, .240830E+05, .180986E+05, .135952E+05,
     +  .102097E+05, .766387E+04, .575146E+04, .431447E+04,
     +  .323583E+04, .242595E+04, .181852E+04, .136278E+04,
     +  .102120E+04, .765088E+03, .573255E+03, .429516E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .321986E+03, .240447E+03, .180425E+03, .135476E+03,
     +  .101844E+03, .766567E+02, .577983E+02, .437021E+02,
     +  .331088E+02, .251583E+02, .191875E+02, .146904E+02,
     +  .112981E+02, .872786E+01, .677772E+01, .528765E+01,
     +  .414465E+01, .326253E+01, .257834E+01, .204391E+01,
     +  .162598E+01, .129367E+01, .103187E+01, .821888E+00,
     +  .654753E+00, .520794E+00, .413336E+00, .327064E+00,
     +  .257851E+00, .202384E+00, .158043E+00, .122714E+00,
     +  .946841E-01, .725478E-01, .551684E-01, .416116E-01,
     +  .310980E-01, .230495E-01, .168729E-01, .122106E-01,
     +  .872795E-02, .615595E-02, .428000E-02, .292969E-02,
     +  .197222E-02, .130402E-02, .846064E-03, .537243E-03,
     +  .335526E-03, .204555E-03, .122351E-03, .719609E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .418812E-04, .242978E-04, .142265E-04, .846672E-05,
     +  .512568E-05, .312215E-05, .186717E-05, .105068E-05,
     +  .527779E-06, .215133E-06, .565218E-07, .397155E-08,
     +  .000000E+00, .692277E+06, .528103E+06, .396561E+06,
     +  .297651E+06, .223338E+06, .167495E+06, .125572E+06,
     +  .940944E+05, .704827E+05, .527689E+05, .394928E+05,
     +  .295414E+05, .220897E+05, .165090E+05, .123339E+05,
     +  .920989E+04, .687487E+04, .512928E+04, .382577E+04,
     +  .285220E+04, .212590E+04, .158392E+04, .117994E+04,
     +  .878744E+03, .654420E+03, .487304E+03, .363022E+03,
     +  .269346E+03, .200808E+03, .149797E+03, .111864E+03,
     +  .836341E+02, .626312E+02, .470329E+02, .353860E+02,
     +  .267017E+02, .202222E+02, .153740E+02, .117408E+02 /
        DATA (UPDI(I),I=3225,3276) /
     +  .900618E+01, .694490E+01, .538032E+01, .418804E+01,
     +  .327402E+01, .256979E+01, .202337E+01, .159894E+01,
     +  .126373E+01, .100145E+01, .792524E+00, .627364E+00,
     +  .495897E+00, .391155E+00, .307636E+00, .241083E+00,
     +  .188106E+00, .146038E+00, .112740E+00, .864941E-01,
     +  .659007E-01, .498359E-01, .373840E-01, .277867E-01,
     +  .204849E-01, .149158E-01, .107376E-01, .763562E-02,
     +  .535846E-02, .370745E-02, .252604E-02, .169320E-02,
     +  .111529E-02, .721422E-03, .457198E-03, .285419E-03,
     +  .174350E-03, .104836E-03, .622674E-04, .367998E-04,
     +  .218109E-04, .131023E-04, .800679E-05, .495417E-05,
     +  .305834E-05, .183417E-05, .102553E-05, .507385E-06,
     +  .201788E-06, .514267E-07, .367167E-08, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .882391E+06, .670742E+06, .501573E+06, .374884E+06,
     +  .280084E+06, .209141E+06, .156103E+06, .116449E+06,
     +  .868313E+05, .647089E+05, .482019E+05, .358846E+05,
     +  .267031E+05, .198589E+05, .147625E+05, .109675E+05,
     +  .814465E+04, .604483E+04, .448462E+04, .332530E+04,
     +  .246486E+04, .182619E+04, .135267E+04, .100155E+04,
     +  .741490E+03, .548830E+03, .406371E+03, .299623E+03,
     +  .221980E+03, .164539E+03, .122080E+03, .906771E+02,
     +  .674565E+02, .503192E+02, .376031E+02, .281821E+02,
     +  .211975E+02, .160050E+02, .121387E+02, .924743E+01,
     +  .708202E+01, .544904E+01, .421266E+01, .327101E+01,
     +  .255020E+01, .199458E+01, .156583E+01, .122948E+01,
     +  .968045E+00, .761202E+00, .598783E+00, .470372E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .368749E+00, .288263E+00, .224552E+00, .174174E+00,
     +  .134433E+00, .103184E+00, .787113E-01, .596330E-01,
     +  .448449E-01, .334547E-01, .247300E-01, .181329E-01,
     +  .131323E-01, .940361E-02, .665220E-02, .464463E-02,
     +  .319780E-02, .216865E-02, .144738E-02, .949778E-03,
     +  .612535E-03, .387476E-03, .241839E-03, .148051E-03,
     +  .895062E-04, .536760E-04, .321795E-04, .194339E-04,
     +  .119202E-04, .742844E-05, .466124E-05, .289589E-05,
     +  .173282E-05, .959641E-06, .466880E-06, .181122E-06,
     +  .448283E-07, .324929E-08, .000000E+00, .111273E+07,
     +  .842921E+06, .627771E+06, .467283E+06, .347664E+06,
     +  .258508E+06, .192124E+06, .142697E+06, .105934E+06,
     +  .785913E+05, .582766E+05, .431845E+05, .319843E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .236732E+05, .175127E+05, .129467E+05, .956629E+04,
     +  .706385E+04, .521352E+04, .384544E+04, .283517E+04,
     +  .208913E+04, .153887E+04, .113301E+04, .834016E+03,
     +  .613717E+03, .451729E+03, .331037E+03, .243758E+03,
     +  .179564E+03, .132392E+03, .977110E+02, .722206E+02,
     +  .535232E+02, .397342E+02, .295821E+02, .221019E+02,
     +  .165762E+02, .124873E+02, .944906E+01, .718780E+01,
     +  .549336E+01, .421854E+01, .325381E+01, .252003E+01,
     +  .195806E+01, .152721E+01, .119140E+01, .932102E+00,
     +  .728305E+00, .569334E+00, .444485E+00, .346333E+00,
     +  .269110E+00, .208384E+00, .160682E+00, .123297E+00,
     +  .940907E-01, .713652E-01, .537620E-01, .402038E-01,
     +  .298264E-01, .219265E-01, .159899E-01, .115176E-01 /
        DATA (UPDI(I),I=3433,3484) /
     +  .820348E-02, .577287E-02, .401013E-02, .274739E-02,
     +  .185454E-02, .123247E-02, .805776E-03, .518200E-03,
     +  .327271E-03, .204280E-03, .125376E-03, .762308E-04,
     +  .461546E-04, .280460E-04, .172212E-04, .107442E-04,
     +  .679331E-05, .429982E-05, .267615E-05, .159261E-05,
     +  .871866E-06, .416679E-06, .157669E-06, .379365E-07,
     +  .279018E-08, .000000E+00, .138905E+07, .104871E+07,
     +  .777945E+06, .576748E+06, .427365E+06, .316462E+06,
     +  .234213E+06, .173222E+06, .128041E+06, .945785E+05,
     +  .698205E+05, .515063E+05, .379735E+05, .279758E+05,
     +  .205980E+05, .151546E+05, .111432E+05, .818756E+04,
     +  .601246E+04, .441206E+04, .323600E+04, .237187E+04,
     +  .173773E+04, .127243E+04, .931423E+03, .681505E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .498736E+03, .363318E+03, .265939E+03, .194724E+03,
     +  .142690E+03, .104659E+03, .768702E+02, .566085E+02,
     +  .417548E+02, .308854E+02, .229252E+02, .170811E+02,
     +  .127832E+02, .960927E+01, .726155E+01, .551325E+01,
     +  .420603E+01, .322299E+01, .247994E+01, .191445E+01,
     +  .148365E+01, .115004E+01, .894082E+00, .694223E+00,
     +  .539336E+00, .418491E+00, .324105E+00, .250330E+00,
     +  .192692E+00, .147709E+00, .112683E+00, .854958E-01,
     +  .644759E-01, .482975E-01, .359150E-01, .264969E-01,
     +  .193713E-01, .140495E-01, .100651E-01, .713059E-02,
     +  .499162E-02, .344980E-02, .235195E-02, .158033E-02,
     +  .104587E-02, .681369E-03, .437057E-03, .275666E-03,
     +  .172152E-03, .105972E-03, .648241E-04, .396252E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .243863E-04, .151946E-04, .961172E-05, .614132E-05,
     +  .390558E-05, .242731E-05, .143349E-05, .774684E-06,
     +  .363429E-06, .134140E-06, .314057E-07, .234301E-08,
     +  .000000E+00, .171735E+07, .129233E+07, .954950E+06,
     +  .705204E+06, .520474E+06, .383860E+06, .282934E+06,
     +  .208390E+06, .153390E+06, .112820E+06, .829264E+05,
     +  .609060E+05, .447034E+05, .327848E+05, .240278E+05,
     +  .175955E+05, .128765E+05, .941552E+04, .688028E+04,
     +  .502372E+04, .366593E+04, .267314E+04, .194819E+04,
     +  .141892E+04, .103302E+04, .751664E+03, .546993E+03,
     +  .396170E+03, .288307E+03, .209862E+03, .152867E+03,
     +  .111447E+03, .813537E+02, .595403E+02, .436422E+02,
     +  .320778E+02, .236587E+02, .175150E+02, .130236E+02 /
        DATA (UPDI(I),I=3589,3640) /
     +  .972699E+01, .730312E+01, .550908E+01, .417580E+01,
     +  .317930E+01, .243068E+01, .186448E+01, .143581E+01,
     +  .110595E+01, .854451E+00, .659337E+00, .509094E+00,
     +  .392628E+00, .302246E+00, .232056E+00, .177569E+00,
     +  .135320E+00, .102633E+00, .774228E-01, .580547E-01,
     +  .432418E-01, .319753E-01, .234594E-01, .170559E-01,
     +  .123027E-01, .876589E-02, .617708E-02, .430160E-02,
     +  .295790E-02, .200687E-02, .134241E-02, .884848E-03,
     +  .574552E-03, .367692E-03, .231702E-03, .144834E-03,
     +  .894653E-04, .550775E-04, .339882E-04, .211670E-04,
     +  .133581E-04, .854350E-05, .549840E-05, .350265E-05,
     +  .216859E-05, .126889E-05, .676243E-06, .311258E-06,
     +  .112073E-06, .255552E-07, .193341E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .210377E+07, .157806E+07, .116165E+07, .854558E+06,
     +  .628250E+06, .461521E+06, .338817E+06, .248539E+06,
     +  .182190E+06, .133445E+06, .976717E+05, .714283E+05,
     +  .521980E+05, .381121E+05, .278066E+05, .202699E+05,
     +  .147649E+05, .107455E+05, .781456E+04, .567815E+04,
     +  .412298E+04, .299130E+04, .216891E+04, .157146E+04,
     +  .113803E+04, .823602E+03, .596063E+03, .429277E+03,
     +  .310637E+03, .224823E+03, .162812E+03, .117999E+03,
     +  .856220E+02, .622867E+02, .453764E+02, .331470E+02,
     +  .242954E+02, .178740E+02, .132071E+02, .980190E+01,
     +  .731292E+01, .548163E+01, .412875E+01, .312367E+01,
     +  .237313E+01, .180891E+01, .138436E+01, .105968E+01,
     +  .813668E+00, .624012E+00, .478892E+00, .367112E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .280915E+00, .214400E+00, .163095E+00, .123565E+00,
     +  .931755E-01, .698854E-01, .521046E-01, .385909E-01,
     +  .283766E-01, .207036E-01, .149693E-01, .107388E-01,
     +  .761025E-02, .533429E-02, .369549E-02, .252844E-02,
     +  .170738E-02, .113710E-02, .746647E-03, .483333E-03,
     +  .308709E-03, .194438E-03, .121717E-03, .754820E-04,
     +  .467804E-04, .291380E-04, .183463E-04, .117053E-04,
     +  .755040E-05, .488123E-05, .310730E-05, .191294E-05,
     +  .110763E-05, .581697E-06, .262590E-06, .922531E-07,
     +  .205050E-07, .157287E-08, .000000E+00, .255448E+07,
     +  .191014E+07, .140087E+07, .102665E+07, .751888E+06,
     +  .550215E+06, .402346E+06, .293970E+06, .214626E+06,
     +  .156561E+06, .114116E+06, .831041E+05, .604714E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .439620E+05, .319337E+05, .231747E+05, .168043E+05,
     +  .121735E+05, .881162E+04, .637222E+04, .460460E+04,
     +  .332432E+04, .239833E+04, .172887E+04, .124556E+04,
     +  .896678E+03, .645486E+03, .462317E+03, .332704E+03,
     +  .239451E+03, .172422E+03, .124246E+03, .896299E+02,
     +  .648194E+02, .469400E+02, .340831E+02, .248299E+02,
     +  .181558E+02, .133330E+02, .983442E+01, .729183E+01,
     +  .543200E+01, .406601E+01, .305716E+01, .230823E+01,
     +  .174857E+01, .132998E+01, .101179E+01, .772174E+00,
     +  .588591E+00, .448990E+00, .342133E+00, .260248E+00,
     +  .197457E+00, .149328E+00, .112478E+00, .843271E-01,
     +  .628874E-01, .466211E-01, .343354E-01, .251065E-01,
     +  .182165E-01, .130985E-01, .934579E-02, .658749E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .459311E-02, .316575E-02, .215537E-02, .144873E-02,
     +  .960796E-03, .628608E-03, .405798E-03, .258776E-03,
     +  .162984E-03, .102225E-03, .636722E-04, .397332E-04,
     +  .249723E-04, .158803E-04, .102251E-04, .663709E-05,
     +  .430030E-05, .273024E-05, .166889E-05, .955351E-06,
     +  .494116E-06, .218709E-06, .749871E-07, .162603E-07,
     +  .126436E-08, .000000E+00, .456193E+05, .682704E+05,
     +  .531545E+05, .413855E+05, .322224E+05, .250882E+05,
     +  .195336E+05, .152089E+05, .118417E+05, .922018E+04,
     +  .717907E+04, .558991E+04, .435262E+04, .338930E+04,
     +  .263927E+04, .205531E+04, .160065E+04, .124665E+04,
     +  .971030E+03, .756431E+03, .589341E+03, .459239E+03,
     +  .357935E+03, .279051E+03, .217622E+03, .169782E+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .132523E+03, .103138E+03, .806157E+02, .630638E+02,
     +  .493815E+02, .387119E+02, .303877E+02, .239067E+02,
     +  .188295E+02, .148605E+02, .117535E+02, .931730E+01,
     +  .740302E+01, .589451E+01, .470410E+01, .376018E+01,
     +  .300956E+01, .241063E+01, .193122E+01, .154642E+01,
     +  .123790E+01, .987722E+00, .787168E+00, .624428E+00,
     +  .493822E+00, .388767E+00, .304489E+00, .237110E+00,
     +  .183466E+00, .140969E+00, .107493E+00, .812942E-01,
     +  .609358E-01, .452398E-01, .332416E-01, .241547E-01,
     +  .173414E-01, .123082E-01, .859515E-02, .591022E-02,
     +  .399590E-02, .265192E-02, .172424E-02, .109583E-02,
     +  .678922E-03, .408717E-03, .238049E-03, .133373E-03,
     +  .718489E-04, .365667E-04, .174436E-04, .765611E-05 /
        DATA (UPDI(I),I=3901,3952) /
     +  .299551E-05, .978679E-06, .218628E-06, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .122584E+06, .959348E+05, .742046E+05,
     +  .573934E+05, .443918E+05, .343335E+05, .265546E+05,
     +  .205370E+05, .158834E+05, .122835E+05, .949971E+04,
     +  .734640E+04, .568135E+04, .439345E+04, .339764E+04,
     +  .262744E+04, .203195E+04, .157139E+04, .121533E+04,
     +  .939964E+03, .727090E+03, .562468E+03, .435207E+03,
     +  .336793E+03, .260712E+03, .201877E+03, .156400E+03,
     +  .120786E+03, .936933E+02, .727288E+02, .565110E+02,
     +  .439552E+02, .342342E+02, .267208E+02, .208807E+02,
     +  .163488E+02, .128293E+02, .100899E+02, .795465E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .628467E+01, .497757E+01, .394908E+01, .313786E+01,
     +  .249560E+01, .198576E+01, .157965E+01, .125670E+01,
     +  .996717E+00, .789973E+00, .623376E+00, .490635E+00,
     +  .384555E+00, .300011E+00, .232814E+00, .179620E+00,
     +  .137686E+00, .104808E+00, .791765E-01, .593340E-01,
     +  .440761E-01, .324401E-01, .236390E-01, .170420E-01,
     +  .121662E-01, .856190E-02, .594540E-02, .407011E-02,
     +  .274328E-02, .181841E-02, .118304E-02, .754261E-03,
     +  .469664E-03, .284796E-03, .166718E-03, .941481E-04,
     +  .498422E-04, .239792E-04, .944761E-05, .175370E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .170083E+06, .132428E+06, .101833E+06, .782965E+05,
     +  .601993E+05, .462788E+05, .355767E+05, .273457E+05,
     +  .210188E+05, .161534E+05, .124141E+05, .953914E+04,
     +  .732990E+04, .563157E+04, .432675E+04, .332385E+04,
     +  .255346E+04, .196142E+04, .150672E+04, .115735E+04,
     +  .889075E+03, .682976E+03, .524739E+03, .403189E+03,
     +  .309874E+03, .238203E+03, .183205E+03, .140430E+03,
     +  .108124E+03, .833002E+02, .642375E+02, .495845E+02,
     +  .383232E+02, .296822E+02, .230162E+02, .178811E+02,
     +  .139235E+02, .108658E+02, .850083E+01, .666505E+01,
     +  .523943E+01, .412621E+01, .325503E+01, .257061E+01,
     +  .203160E+01, .160549E+01, .126929E+01, .100060E+01,
     +  .788564E+00, .618895E+00, .484654E+00, .378076E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .293683E+00, .227006E+00, .174529E+00, .133373E+00,
     +  .101263E+00, .763415E-01, .571278E-01, .424031E-01,
     +  .312087E-01, .227611E-01, .164394E-01, .117713E-01,
     +  .832058E-02, .581227E-02, .401072E-02, .273124E-02,
     +  .183488E-02, .121440E-02, .791710E-03, .507501E-03,
     +  .319807E-03, .197255E-03, .119892E-03, .708566E-04,
     +  .408402E-04, .227335E-04, .121483E-04, .608813E-05,
     +  .278390E-05, .106035E-05, .245676E-06, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .231862E+06,
     +  .179696E+06, .137444E+06, .105107E+06, .803719E+05,
     +  .614448E+05, .469716E+05, .358997E+05, .274356E+05,
     +  .209625E+05, .160155E+05, .122333E+05, .934363E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .713501E+04, .544814E+04, .415921E+04, .317510E+04,
     +  .242336E+04, .184958E+04, .141142E+04, .107711E+04,
     +  .821891E+03, .627209E+03, .478627E+03, .365312E+03,
     +  .278853E+03, .212962E+03, .162060E+03, .123879E+03,
     +  .947430E+02, .725258E+02, .555671E+02, .426265E+02,
     +  .327675E+02, .252169E+02, .194423E+02, .150246E+02,
     +  .116363E+02, .903515E+01, .703099E+01, .548639E+01,
     +  .428930E+01, .335959E+01, .263471E+01, .206822E+01,
     +  .162370E+01, .127562E+01, .999449E+00, .783124E+00,
     +  .611220E+00, .476146E+00, .369608E+00, .285785E+00,
     +  .219958E+00, .168449E+00, .128269E+00, .970797E-01,
     +  .729857E-01, .544922E-01, .403743E-01, .296795E-01,
     +  .216331E-01, .156260E-01, .111988E-01, .793001E-02 /
        DATA (UPDI(I),I=4161,4212) /
     +  .555483E-02, .384847E-02, .263498E-02, .178296E-02,
     +  .119097E-02, .785703E-03, .511340E-03, .328532E-03,
     +  .207808E-03, .130499E-03, .805886E-04, .493232E-04,
     +  .298569E-04, .179971E-04, .107751E-04, .648257E-05,
     +  .389954E-05, .236217E-05, .142376E-05, .849300E-06,
     +  .483211E-06, .252535E-06, .111520E-06, .328126E-07,
     +  .212495E-08, .000000E+00, .311091E+06, .240068E+06,
     +  .182712E+06, .139022E+06, .105766E+06, .804409E+05,
     +  .611717E+05, .465045E+05, .353491E+05, .268615E+05,
     +  .204090E+05, .155018E+05, .117729E+05, .893825E+04,
     +  .678525E+04, .514933E+04, .390739E+04, .296414E+04,
     +  .224840E+04, .170505E+04, .129297E+04, .980278E+03,
     +  .743226E+03, .563430E+03, .427174E+03, .323872E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .245659E+03, .185633E+03, .140908E+03, .107005E+03,
     +  .813275E+02, .618613E+02, .471094E+02, .359486E+02,
     +  .274610E+02, .210157E+02, .161200E+02, .123920E+02,
     +  .955086E+01, .737769E+01, .571513E+01, .443610E+01,
     +  .345010E+01, .268703E+01, .209512E+01, .163405E+01,
     +  .127567E+01, .993354E+00, .773804E+00, .600539E+00,
     +  .465317E+00, .359359E+00, .276520E+00, .211861E+00,
     +  .161560E+00, .122538E+00, .924055E-01, .692431E-01,
     +  .515469E-01, .380951E-01, .279452E-01, .203358E-01,
     +  .146722E-01, .105090E-01, .744178E-02, .521655E-02,
     +  .361964E-02, .248441E-02, .168708E-02, .113243E-02,
     +  .751918E-03, .493493E-03, .320527E-03, .205644E-03,
     +  .131476E-03, .831277E-04, .524417E-04, .330047E-04 /
        DATA (UPDI(I),I=4265,4316) /
     +  .208826E-04, .132639E-04, .853391E-05, .551601E-05,
     +  .357719E-05, .228755E-05, .142097E-05, .826009E-06,
     +  .431013E-06, .185428E-06, .521517E-07, .352291E-08,
     +  .000000E+00, .411409E+06, .316207E+06, .239535E+06,
     +  .181394E+06, .137338E+06, .103943E+06, .786530E+05,
     +  .594938E+05, .449921E+05, .340123E+05, .257064E+05,
     +  .194214E+05, .146699E+05, .110766E+05, .836175E+04,
     +  .630988E+04, .476059E+04, .359038E+04, .270735E+04,
     +  .204080E+04, .153817E+04, .115900E+04, .873237E+03,
     +  .657790E+03, .495509E+03, .373228E+03, .281230E+03,
     +  .211070E+03, .159130E+03, .120013E+03, .905813E+02,
     +  .684166E+02, .517319E+02, .391943E+02, .297247E+02,
     +  .225834E+02, .171967E+02, .131236E+02, .100413E+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .770055E+01, .592260E+01, .456464E+01, .352535E+01,
     +  .272688E+01, .211199E+01, .163648E+01, .126951E+01,
     +  .982470E+00, .760812E+00, .587078E+00, .452396E+00,
     +  .347548E+00, .266095E+00, .202903E+00, .154031E+00,
     +  .116331E+00, .873746E-01, .652304E-01, .483937E-01,
     +  .356538E-01, .260820E-01, .189343E-01, .136331E-01,
     +  .974880E-02, .689524E-02, .483011E-02, .335115E-02,
     +  .230142E-02, .156491E-02, .105281E-02, .701421E-03,
     +  .462559E-03, .302396E-03, .195744E-03, .126575E-03,
     +  .812453E-04, .522378E-04, .336638E-04, .218943E-04,
     +  .143450E-04, .952065E-05, .633594E-05, .420377E-05,
     +  .273066E-05, .170581E-05, .988525E-06, .509069E-06,
     +  .213498E-06, .579761E-07, .400314E-08, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .536929E+06, .411101E+06, .310030E+06, .233716E+06,
     +  .176140E+06, .132690E+06, .999301E+05, .752251E+05,
     +  .566115E+05, .425844E+05, .320235E+05, .240707E+05,
     +  .180876E+05, .135853E+05, .102008E+05, .765593E+04,
     +  .574434E+04, .430808E+04, .323010E+04, .242081E+04,
     +  .181391E+04, .135864E+04, .101748E+04, .761749E+03,
     +  .570251E+03, .426810E+03, .319547E+03, .238249E+03,
     +  .178439E+03, .133678E+03, .100213E+03, .751745E+02,
     +  .564485E+02, .424702E+02, .319825E+02, .241268E+02,
     +  .182413E+02, .138216E+02, .105002E+02, .799535E+01,
     +  .610606E+01, .467325E+01, .358439E+01, .275380E+01,
     +  .211871E+01, .163103E+01, .125732E+01, .967032E+00,
     +  .744409E+00, .571100E+00, .437636E+00, .334408E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .254716E+00, .193269E+00, .146025E+00, .109787E+00,
     +  .821071E-01, .610502E-01, .451202E-01, .331242E-01,
     +  .241521E-01, .174810E-01, .125526E-01, .895470E-02,
     +  .632053E-02, .442016E-02, .306299E-02, .210207E-02,
     +  .142923E-02, .962164E-03, .642033E-03, .424546E-03,
     +  .278700E-03, .181516E-03, .118328E-03, .767956E-04,
     +  .500644E-04, .328129E-04, .217444E-04, .145338E-04,
     +  .982190E-05, .663677E-05, .444562E-05, .289952E-05,
     +  .180596E-05, .103730E-05, .525689E-06, .214937E-06,
     +  .565144E-07, .397151E-08, .000000E+00, .692233E+06,
     +  .528063E+06, .396525E+06, .297619E+06, .223309E+06,
     +  .167469E+06, .125549E+06, .940738E+05, .704642E+05,
     +  .527523E+05, .394780E+05, .295282E+05, .220778E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .164984E+05, .123244E+05, .920136E+04, .686722E+04,
     +  .512243E+04, .381963E+04, .284670E+04, .212096E+04,
     +  .157949E+04, .117596E+04, .875174E+03, .651212E+03,
     +  .484417E+03, .360423E+03, .267007E+03, .198697E+03,
     +  .147889E+03, .110138E+03, .820693E+02, .612103E+02,
     +  .457401E+02, .342081E+02, .256272E+02, .192409E+02,
     +  .144774E+02, .109215E+02, .825830E+01, .626321E+01,
     +  .476061E+01, .362660E+01, .276759E+01, .211532E+01,
     +  .161791E+01, .123937E+01, .947349E+00, .724908E+00,
     +  .552900E+00, .421303E+00, .320175E+00, .242592E+00,
     +  .183136E+00, .137692E+00, .103036E+00, .767105E-01,
     +  .567922E-01, .418009E-01, .305681E-01, .222067E-01,
     +  .160179E-01, .114652E-01, .815479E-02, .574048E-02 /
        DATA (UPDI(I),I=4525,4576) /
     +  .400506E-02, .276986E-02, .189799E-02, .128917E-02,
     +  .867587E-03, .579197E-03, .383587E-03, .252538E-03,
     +  .165250E-03, .108423E-03, .710030E-04, .468086E-04,
     +  .310912E-04, .208970E-04, .141672E-04, .968626E-05,
     +  .660142E-05, .443742E-05, .289105E-05, .178873E-05,
     +  .101571E-05, .505872E-06, .201648E-06, .514214E-07,
     +  .367164E-08, .000000E+00, .882343E+06, .670699E+06,
     +  .501535E+06, .374849E+06, .280053E+06, .209113E+06,
     +  .156078E+06, .116427E+06, .868114E+05, .646912E+05,
     +  .481860E+05, .358703E+05, .266903E+05, .198475E+05,
     +  .147523E+05, .109584E+05, .813646E+04, .603749E+04,
     +  .447805E+04, .331940E+04, .245959E+04, .182146E+04,
     +  .134843E+04, .997746E+03, .738072E+03, .545758E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .403609E+03, .297141E+03, .219744E+03, .162522E+03,
     +  .120259E+03, .890303E+02, .659652E+02, .489667E+02,
     +  .363752E+02, .270665E+02, .201830E+02, .150825E+02,
     +  .113002E+02, .848620E+01, .639223E+01, .482582E+01,
     +  .365163E+01, .276827E+01, .210204E+01, .159745E+01,
     +  .121605E+01, .923795E+00, .702659E+00, .532793E+00,
     +  .403676E+00, .305089E+00, .229923E+00, .172673E+00,
     +  .129173E+00, .961916E-01, .712792E-01, .525333E-01,
     +  .384983E-01, .280362E-01, .202865E-01, .145780E-01,
     +  .103971E-01, .737033E-02, .517202E-02, .359823E-02,
     +  .248228E-02, .169740E-02, .115109E-02, .773939E-03,
     +  .516604E-03, .342448E-03, .225961E-03, .148450E-03,
     +  .979546E-04, .646586E-04, .430415E-04, .289114E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .196528E-04, .134658E-04, .927788E-05, .635204E-05,
     +  .426963E-05, .277053E-05, .169917E-05, .952467E-06,
     +  .465788E-06, .181022E-06, .448246E-07, .324926E-08,
     +  .000000E+00, .111268E+07, .842875E+06, .627730E+06,
     +  .467246E+06, .347631E+06, .258478E+06, .192097E+06,
     +  .142673E+06, .105913E+06, .785722E+05, .582595E+05,
     +  .431692E+05, .319707E+05, .236610E+05, .175018E+05,
     +  .129369E+05, .955752E+04, .705600E+04, .520649E+04,
     +  .383915E+04, .282954E+04, .208408E+04, .153435E+04,
     +  .112896E+04, .830382E+03, .610455E+03, .448800E+03,
     +  .328410E+03, .241395E+03, .177437E+03, .130476E+03,
     +  .959828E+02, .706601E+02, .521125E+02, .384581E+02,
     +  .284272E+02, .210563E+02, .156299E+02, .116317E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .867654E+01, .649185E+01, .486840E+01, .365949E+01,
     +  .275609E+01, .207929E+01, .157011E+01, .118779E+01,
     +  .896792E+00, .678042E+00, .511109E+00, .385035E+00,
     +  .289382E+00, .216905E+00, .162038E+00, .120595E+00,
     +  .893572E-01, .658952E-01, .483385E-01, .352640E-01,
     +  .255690E-01, .184238E-01, .131864E-01, .936842E-02,
     +  .661684E-02, .462727E-02, .320907E-02, .220753E-02,
     +  .150586E-02, .101922E-02, .684419E-03, .456646E-03,
     +  .302901E-03, .200268E-03, .132061E-03, .876077E-04,
     +  .582565E-04, .391211E-04, .265347E-04, .182049E-04,
     +  .125738E-04, .870598E-05, .597115E-05, .400387E-05,
     +  .258247E-05, .156777E-05, .866635E-06, .415892E-06,
     +  .157597E-06, .379338E-07, .279016E-08, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .138900E+07, .104866E+07, .777900E+06, .576708E+06,
     +  .427329E+06, .316431E+06, .234185E+06, .173196E+06,
     +  .128019E+06, .945580E+05, .698023E+05, .514899E+05,
     +  .379589E+05, .279627E+05, .205863E+05, .151442E+05,
     +  .111338E+05, .817918E+04, .600497E+04, .440535E+04,
     +  .323000E+04, .236650E+04, .173293E+04, .126812E+04,
     +  .927569E+03, .678050E+03, .495639E+03, .360544E+03,
     +  .263449E+03, .192487E+03, .140680E+03, .102851E+03,
     +  .752418E+02, .551412E+02, .404323E+02, .296933E+02,
     +  .218507E+02, .161133E+02, .119125E+02, .882751E+01,
     +  .656135E+01, .488826E+01, .365047E+01, .273155E+01,
     +  .204761E+01, .153644E+01, .115513E+01, .866799E+00,
     +  .651453E+00, .488183E+00, .365656E+00, .273280E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .203716E+00, .151374E+00, .112072E+00, .826210E-01,
     +  .606271E-01, .442609E-01, .321389E-01, .231981E-01,
     +  .166426E-01, .118616E-01, .839312E-02, .590514E-02,
     +  .411446E-02, .284380E-02, .195030E-02, .132691E-02,
     +  .896221E-03, .600988E-03, .400769E-03, .266002E-03,
     +  .176228E-03, .116640E-03, .777861E-04, .520906E-04,
     +  .352636E-04, .241225E-04, .166757E-04, .115857E-04,
     +  .804377E-05, .551512E-05, .368255E-05, .235751E-05,
     +  .141520E-05, .770880E-06, .362864E-06, .134089E-06,
     +  .314039E-07, .234300E-08, .000000E+00, .171729E+07,
     +  .129228E+07, .954903E+06, .705162E+06, .520436E+06,
     +  .383825E+06, .282903E+06, .208362E+06, .153365E+06,
     +  .112798E+06, .829068E+05, .608885E+05, .446878E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .327708E+05, .240153E+05, .175843E+05, .128665E+05,
     +  .940659E+04, .687230E+04, .501659E+04, .365956E+04,
     +  .266744E+04, .194309E+04, .141436E+04, .102894E+04,
     +  .748013E+03, .543724E+03, .393247E+03, .285688E+03,
     +  .207516E+03, .150762E+03, .109558E+03, .796589E+02,
     +  .580182E+02, .422754E+02, .308506E+02, .225575E+02,
     +  .165278E+02, .121401E+02, .893805E+01, .660056E+01,
     +  .488576E+01, .362516E+01, .269533E+01, .200770E+01,
     +  .149707E+01, .111863E+01, .834299E+00, .623297E+00,
     +  .464342E+00, .345804E+00, .256993E+00, .190522E+00,
     +  .140809E+00, .103702E+00, .760576E-01, .555312E-01,
     +  .403428E-01, .291544E-01, .209468E-01, .149601E-01,
     +  .106164E-01, .748064E-02, .524216E-02, .363868E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .250616E-02, .171334E-02, .116255E-02, .783531E-03,
     +  .524699E-03, .349737E-03, .232306E-03, .154239E-03,
     +  .102478E-03, .687040E-04, .463215E-04, .315919E-04,
     +  .217711E-04, .151420E-04, .105632E-04, .734066E-05,
     +  .502278E-05, .333506E-05, .211672E-05, .125546E-05,
     +  .673485E-06, .310853E-06, .112038E-06, .255539E-07,
     +  .193341E-08, .000000E+00, .210371E+07, .157800E+07,
     +  .116160E+07, .854513E+06, .628209E+06, .461485E+06,
     +  .338784E+06, .248510E+06, .182164E+06, .133421E+06,
     +  .976508E+05, .714096E+05, .521813E+05, .380972E+05,
     +  .277932E+05, .202580E+05, .147543E+05, .107360E+05,
     +  .780607E+04, .567057E+04, .411621E+04, .298525E+04,
     +  .216351E+04, .156664E+04, .113372E+04, .819750E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .592621E+03, .426205E+03, .307890E+03, .222367E+03,
     +  .160614E+03, .116033E+03, .838625E+02, .607119E+02,
     +  .439674E+02, .318872E+02, .231699E+02, .168699E+02,
     +  .123130E+02, .900786E+01, .660985E+01, .486160E+01,
     +  .358441E+01, .264827E+01, .196033E+01, .145270E+01,
     +  .107886E+01, .799779E+00, .593968E+00, .439904E+00,
     +  .325727E+00, .240713E+00, .177468E+00, .130453E+00,
     +  .955658E-01, .697275E-01, .506516E-01, .366160E-01,
     +  .263333E-01, .188311E-01, .133878E-01, .945884E-02,
     +  .663652E-02, .463172E-02, .320257E-02, .219798E-02,
     +  .149788E-02, .101363E-02, .681747E-03, .455966E-03,
     +  .303840E-03, .202017E-03, .134455E-03, .896912E-04,
     +  .604526E-04, .410243E-04, .281692E-04, .195354E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .136508E-04, .954659E-05, .663014E-05, .452097E-05,
     +  .298170E-05, .187451E-05, .109780E-05, .579702E-06,
     +  .262301E-06, .922279E-07, .205040E-07, .157286E-08,
     +  .000000E+00, .255441E+07, .191008E+07, .140081E+07,
     +  .102660E+07, .751845E+06, .550175E+06, .402311E+06,
     +  .293939E+06, .214598E+06, .156536E+06, .114094E+06,
     +  .830842E+05, .604536E+05, .439461E+05, .319196E+05,
     +  .231620E+05, .167930E+05, .121634E+05, .880261E+04,
     +  .636418E+04, .459743E+04, .331792E+04, .239263E+04,
     +  .172378E+04, .124101E+04, .892622E+03, .641868E+03,
     +  .459094E+03, .329829E+03, .236885E+03, .170132E+03,
     +  .122203E+03, .878078E+02, .631940E+02, .454912E+02,
     +  .327930E+02, .236825E+02, .171371E+02, .124306E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .903731E+01, .659009E+01, .481682E+01, .352925E+01,
     +  .259135E+01, .190636E+01, .140406E+01, .103645E+01,
     +  .763724E+00, .563851E+00, .415165E+00, .305651E+00,
     +  .224609E+00, .164682E+00, .120399E+00, .877313E-01,
     +  .636780E-01, .460212E-01, .331030E-01, .236909E-01,
     +  .168612E-01, .119320E-01, .839280E-02, .586319E-02,
     +  .407524E-02, .280689E-02, .191960E-02, .130408E-02,
     +  .880195E-03, .590853E-03, .394756E-03, .263045E-03,
     +  .175116E-03, .116866E-03, .782842E-04, .530455E-04,
     +  .362204E-04, .250221E-04, .174439E-04, .122304E-04,
     +  .856218E-05, .593490E-05, .402815E-05, .263637E-05,
     +  .164049E-05, .948170E-06, .492678E-06, .218503E-06,
     +  .749693E-07, .162596E-07, .126436E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .154104E+07, .119823E+07, .920026E+06, .706416E+06,
     +  .542404E+06, .416474E+06, .319784E+06, .245544E+06,
     +  .188542E+06, .144775E+06, .111170E+06, .853666E+05,
     +  .655544E+05, .503421E+05, .386614E+05, .296924E+05,
     +  .228056E+05, .175174E+05, .134567E+05, .103385E+05,
     +  .794393E+04, .610504E+04, .469281E+04, .360818E+04,
     +  .277511E+04, .213519E+04, .164361E+04, .126124E+04,
     +  .972212E+03, .750047E+03, .579240E+03, .447881E+03,
     +  .346827E+03, .269256E+03, .209360E+03, .163223E+03,
     +  .127652E+03, .100194E+03, .789653E+02, .625132E+02,
     +  .497505E+02, .398036E+02, .320272E+02, .259222E+02,
     +  .211066E+02, .172883E+02, .142536E+02, .118030E+02,
     +  .983555E+01, .822598E+01, .691360E+01, .583202E+01 /
        DATA (UPDI(I),I=5149,5200) /
     +  .493486E+01, .418599E+01, .355721E+01, .302640E+01,
     +  .257616E+01, .219265E+01, .186485E+01, .158390E+01,
     +  .134262E+01, .113513E+01, .956587E+00, .803644E+00,
     +  .671372E+00, .557927E+00, .460872E+00, .378116E+00,
     +  .307846E+00, .248481E+00, .198631E+00, .157064E+00,
     +  .122668E+00, .944481E-01, .717515E-01, .534542E-01,
     +  .390271E-01, .278367E-01, .193222E-01, .129890E-01,
     +  .840391E-02, .519522E-02, .302462E-02, .164049E-02,
     +  .808590E-03, .349739E-03, .125188E-03, .332227E-04,
     +  .510688E-05, .206459E-06, .000000E+00, .243956E+07,
     +  .189171E+07, .144771E+07, .110756E+07, .847330E+06,
     +  .648028E+06, .495600E+06, .378894E+06, .289665E+06,
     +  .221369E+06, .169170E+06, .129231E+06, .987174E+05 /
        DATA (UPDI(I),I=5201,5252) /
     +  .753793E+05, .575559E+05, .439296E+05, .335276E+05,
     +  .255787E+05, .195136E+05, .148809E+05, .113478E+05,
     +  .865052E+04, .659455E+04, .502576E+04, .383058E+04,
     +  .291897E+04, .222487E+04, .168941E+04, .128844E+04,
     +  .982907E+03, .750408E+03, .573299E+03, .438544E+03,
     +  .336153E+03, .258019E+03, .198491E+03, .153160E+03,
     +  .118570E+03, .921682E+02, .719501E+02, .564686E+02,
     +  .445480E+02, .353493E+02, .282145E+02, .226587E+02,
     +  .183052E+02, .148888E+02, .121621E+02, .100000E+02,
     +  .825218E+01, .684441E+01, .569808E+01, .475887E+01,
     +  .398449E+01, .334242E+01, .280726E+01, .235914E+01,
     +  .198243E+01, .166468E+01, .139603E+01, .116841E+01,
     +  .975424E+00, .811583E+00, .673215E+00, .555218E+00 /
        DATA (UPDI(I),I=5253,5304) /
     +  .455480E+00, .371365E+00, .300699E+00, .241567E+00,
     +  .192363E+00, .151656E+00, .118241E+00, .910296E-01,
     +  .690550E-01, .516661E-01, .378863E-01, .272063E-01,
     +  .190739E-01, .130001E-01, .857346E-02, .543294E-02,
     +  .328562E-02, .186688E-02, .986201E-03, .471792E-03,
     +  .197379E-03, .679390E-04, .172479E-04, .254796E-05,
     +  .105068E-06, .000000E+00, .370495E+07, .286253E+07,
     +  .218137E+07, .166147E+07, .126537E+07, .963204E+06,
     +  .733111E+06, .557684E+06, .424177E+06, .322450E+06,
     +  .245080E+06, .186165E+06, .141387E+06, .107313E+06,
     +  .814346E+05, .617573E+05, .468246E+05, .354792E+05,
     +  .268769E+05, .203467E+05, .153998E+05, .116480E+05,
     +  .880856E+04, .665725E+04, .503070E+04, .379930E+04 /
        DATA (UPDI(I),I=5305,5356) /
     +  .286942E+04, .215794E+04, .162975E+04, .123076E+04,
     +  .929922E+03, .702870E+03, .531790E+03, .403063E+03,
     +  .305838E+03, .232525E+03, .177295E+03, .135599E+03,
     +  .104125E+03, .802857E+02, .622354E+02, .484899E+02,
     +  .380018E+02, .299564E+02, .237614E+02, .189594E+02,
     +  .152326E+02, .122902E+02, .998251E+01, .813724E+01,
     +  .666728E+01, .548347E+01, .452433E+01, .374244E+01,
     +  .310155E+01, .257361E+01, .213675E+01, .177395E+01,
     +  .147167E+01, .121929E+01, .100815E+01, .831469E+00,
     +  .683366E+00, .559941E+00, .456080E+00, .369486E+00,
     +  .297448E+00, .237772E+00, .188534E+00, .148150E+00,
     +  .115222E+00, .885960E-01, .672453E-01, .502670E-01,
     +  .370444E-01, .267394E-01, .188874E-01, .130153E-01 /
        DATA (UPDI(I),I=5357,5408) /
     +  .871024E-02, .563456E-02, .349680E-02, .206816E-02,
     +  .114653E-02, .589589E-03, .273596E-03, .110607E-03,
     +  .365710E-04, .887052E-05, .125686E-05, .523806E-07,
     +  .000000E+00, .542400E+07, .417417E+07, .316626E+07,
     +  .240027E+07, .181921E+07, .137795E+07, .104348E+07,
     +  .789673E+06, .597441E+06, .451691E+06, .341397E+06,
     +  .257845E+06, .194678E+06, .146873E+06, .110767E+06,
     +  .834697E+05, .628753E+05, .473228E+05, .356028E+05,
     +  .267625E+05, .201089E+05, .150964E+05, .113290E+05,
     +  .849461E+04, .636711E+04, .476834E+04, .357042E+04,
     +  .266113E+04, .199158E+04, .149000E+04, .111504E+04,
     +  .834543E+03, .625075E+03, .468919E+03, .352082E+03,
     +  .264830E+03, .199738E+03, .151086E+03, .114729E+03 /
        DATA (UPDI(I),I=5409,5460) /
     +  .874709E+02, .670411E+02, .516429E+02, .400133E+02,
     +  .311836E+02, .244534E+02, .192895E+02, .153221E+02,
     +  .122212E+02, .981388E+01, .790851E+01, .640610E+01,
     +  .520868E+01, .424859E+01, .347425E+01, .284634E+01,
     +  .233479E+01, .191620E+01, .157254E+01, .128950E+01,
     +  .105598E+01, .862965E+00, .703419E+00, .571304E+00,
     +  .462585E+00, .372256E+00, .297921E+00, .236889E+00,
     +  .187005E+00, .146401E+00, .113558E+00, .871525E-01,
     +  .661094E-01, .494843E-01, .364604E-01, .264742E-01,
     +  .188161E-01, .130775E-01, .886034E-02, .582445E-02,
     +  .369701E-02, .224797E-02, .130083E-02, .704014E-03,
     +  .352636E-03, .158876E-03, .621330E-04, .197694E-04,
     +  .459399E-05, .625676E-06, .258753E-07, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .769526E+07, .589811E+07, .445281E+07, .335936E+07,
     +  .253362E+07, .190949E+07, .143860E+07, .108302E+07,
     +  .815013E+06, .612840E+06, .460621E+06, .345921E+06,
     +  .259661E+06, .194738E+06, .145974E+06, .109319E+06,
     +  .818241E+05, .611848E+05, .457253E+05, .341376E+05,
     +  .254712E+05, .189855E+05, .141429E+05, .105248E+05,
     +  .782796E+04, .581587E+04, .431946E+04, .319226E+04,
     +  .236868E+04, .175665E+04, .130281E+04, .966155E+03,
     +  .716862E+03, .532647E+03, .396026E+03, .294927E+03,
     +  .220192E+03, .164856E+03, .123891E+03, .934703E+02,
     +  .708861E+02, .540280E+02, .414165E+02, .319336E+02,
     +  .247742E+02, .193333E+02, .151928E+02, .119874E+02,
     +  .952278E+01, .759090E+01, .608229E+01, .489178E+01 /
        DATA (UPDI(I),I=5513,5564) /
     +  .394666E+01, .319213E+01, .258654E+01, .209836E+01,
     +  .170313E+01, .138218E+01, .112077E+01, .907537E+00,
     +  .733302E+00, .590962E+00, .474472E+00, .379766E+00,
     +  .302039E+00, .238870E+00, .187660E+00, .146342E+00,
     +  .113150E+00, .866595E-01, .656508E-01, .491423E-01,
     +  .362863E-01, .263609E-01, .188652E-01, .132064E-01,
     +  .903453E-02, .602047E-02, .388901E-02, .242315E-02,
     +  .144438E-02, .818203E-03, .432599E-03, .211232E-03,
     +  .924997E-04, .350416E-04, .107520E-04, .240058E-05,
     +  .314824E-06, .125795E-07, .000000E+00, .106260E+08,
     +  .811145E+07, .609483E+07, .457612E+07, .343439E+07,
     +  .257550E+07, .193052E+07, .144586E+07, .108233E+07,
     +  .809494E+06, .605100E+06, .451896E+06, .337279E+06 /
        DATA (UPDI(I),I=5565,5616) /
     +  .251486E+06, .187395E+06, .139493E+06, .103764E+06,
     +  .771026E+05, .572497E+05, .424606E+05, .314679E+05,
     +  .232940E+05, .172301E+05, .127300E+05, .939809E+04,
     +  .692955E+04, .510676E+04, .374382E+04, .275540E+04,
     +  .202653E+04, .149020E+04, .109555E+04, .805655E+03,
     +  .593231E+03, .437002E+03, .322396E+03, .238406E+03,
     +  .176773E+03, .131549E+03, .982701E+02, .737854E+02,
     +  .556758E+02, .422500E+02, .322474E+02, .247639E+02,
     +  .191284E+02, .148788E+02, .116188E+02, .913524E+01,
     +  .720657E+01, .571443E+01, .454809E+01, .363098E+01,
     +  .290595E+01, .232978E+01, .187002E+01, .150160E+01,
     +  .120556E+01, .967008E+00, .774532E+00, .618997E+00,
     +  .493359E+00, .391702E+00, .310012E+00, .243758E+00 /
        DATA (UPDI(I),I=5617,5668) /
     +  .190560E+00, .147960E+00, .114016E+00, .870923E-01,
     +  .658818E-01, .492825E-01, .364152E-01, .265335E-01,
     +  .190121E-01, .134149E-01, .925322E-02, .623341E-02,
     +  .408740E-02, .259586E-02, .158858E-02, .928875E-03,
     +  .515476E-03, .266500E-03, .126991E-03, .541283E-04,
     +  .198989E-04, .590333E-05, .127045E-05, .160672E-06,
     +  .596233E-08, .000000E+00, .143300E+08, .108953E+08,
     +  .814825E+07, .608886E+07, .454762E+07, .339363E+07,
     +  .253105E+07, .188602E+07, .140452E+07, .104495E+07,
     +  .776923E+06, .577060E+06, .428305E+06, .317556E+06,
     +  .235262E+06, .174098E+06, .128729E+06, .950693E+05,
     +  .701496E+05, .516973E+05, .380640E+05, .279899E+05,
     +  .205630E+05, .150871E+05, .110592E+05, .809507E+04 /
        DATA (UPDI(I),I=5669,5720) /
     +  .592144E+04, .430770E+04, .314579E+04, .229534E+04,
     +  .167417E+04, .122063E+04, .890040E+03, .649740E+03,
     +  .474422E+03, .346881E+03, .254184E+03, .186741E+03,
     +  .137673E+03, .101879E+03, .757693E+02, .566271E+02,
     +  .425584E+02, .321691E+02, .244636E+02, .187119E+02,
     +  .144125E+02, .111434E+02, .867494E+01, .677519E+01,
     +  .531866E+01, .419059E+01, .331176E+01, .262358E+01,
     +  .208191E+01, .165391E+01, .131435E+01, .104426E+01,
     +  .828868E+00, .656903E+00, .519425E+00, .409577E+00,
     +  .321670E+00, .251822E+00, .195816E+00, .151369E+00,
     +  .116198E+00, .885088E-01, .668161E-01, .499396E-01,
     +  .369010E-01, .269258E-01, .193677E-01, .136935E-01,
     +  .953075E-02, .648082E-02, .430138E-02, .277704E-02 /
        DATA (UPDI(I),I=5721,5772) /
     +  .173512E-02, .104368E-02, .599163E-03, .326062E-03,
     +  .165039E-03, .768599E-04, .319478E-04, .114243E-04,
     +  .328746E-05, .684544E-06, .835989E-07, .271306E-08,
     +  .000000E+00, .189252E+08, .143328E+08, .106696E+08,
     +  .793581E+07, .589889E+07, .438084E+07, .325131E+07,
     +  .241070E+07, .178616E+07, .132208E+07, .977819E+06,
     +  .722422E+06, .533290E+06, .393222E+06, .289684E+06,
     +  .213148E+06, .156685E+06, .115030E+06, .843645E+05,
     +  .617904E+05, .452088E+05, .330306E+05, .241069E+05,
     +  .175690E+05, .127902E+05, .929655E+04, .675172E+04,
     +  .487536E+04, .353375E+04, .255879E+04, .185179E+04,
     +  .133942E+04, .968723E+03, .701355E+03, .507792E+03,
     +  .368104E+03, .267387E+03, .194711E+03, .142265E+03 /
        DATA (UPDI(I),I=5773,5824) /
     +  .104328E+03, .768836E+02, .569326E+02, .423919E+02,
     +  .317452E+02, .239151E+02, .181201E+02, .138250E+02,
     +  .105871E+02, .816326E+01, .631409E+01, .490875E+01,
     +  .383004E+01, .299723E+01, .235108E+01, .184722E+01,
     +  .145288E+01, .114303E+01, .899016E+00, .706350E+00,
     +  .554097E+00, .433635E+00, .338391E+00, .262982E+00,
     +  .203712E+00, .156712E+00, .119829E+00, .909771E-01,
     +  .685264E-01, .511454E-01, .377861E-01, .275919E-01,
     +  .198908E-01, .141310E-01, .986374E-02, .677573E-02,
     +  .454492E-02, .297405E-02, .189194E-02, .116396E-02,
     +  .688826E-03, .388698E-03, .207702E-03, .103090E-03,
     +  .470104E-04, .191013E-04, .666391E-05, .186723E-05,
     +  .377849E-06, .446217E-07, .115020E-08, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .245304E+08, .185067E+08, .137144E+08, .101538E+08,
     +  .751242E+07, .555283E+07, .410135E+07, .302620E+07,
     +  .223110E+07, .164313E+07, .120906E+07, .888642E+06,
     +  .652528E+06, .478565E+06, .350628E+06, .256560E+06,
     +  .187528E+06, .136882E+06, .998004E+05, .726591E+05,
     +  .528361E+05, .383633E+05, .278210E+05, .201445E+05,
     +  .145679E+05, .105169E+05, .758528E+04, .543811E+04,
     +  .391323E+04, .281276E+04, .202029E+04, .145012E+04,
     +  .104057E+04, .747391E+03, .536725E+03, .385870E+03,
     +  .277940E+03, .200676E+03, .145361E+03, .105670E+03,
     +  .771877E+02, .566513E+02, .418052E+02, .310243E+02,
     +  .231604E+02, .173883E+02, .131455E+02, .997366E+01,
     +  .761920E+01, .583820E+01, .449627E+01, .347518E+01 /
        DATA (UPDI(I),I=5877,5928) /
     +  .269378E+01, .209293E+01, .162866E+01, .126865E+01,
     +  .988428E+00, .769847E+00, .598937E+00, .465207E+00,
     +  .360457E+00, .278476E+00, .214233E+00, .164267E+00,
     +  .125065E+00, .946344E-01, .710907E-01, .529747E-01,
     +  .391088E-01, .285743E-01, .206306E-01, .147015E-01,
     +  .103218E-01, .711764E-02, .482901E-02, .319764E-02,
     +  .206475E-02, .129545E-02, .785604E-03, .457971E-03,
     +  .254377E-03, .133686E-03, .651927E-04, .291777E-04,
     +  .116222E-04, .396952E-05, .108774E-05, .214922E-06,
     +  .245840E-07, .422054E-09, .000000E+00, .312620E+08,
     +  .234969E+08, .173353E+08, .127770E+08, .941008E+07,
     +  .692341E+07, .508965E+07, .373758E+07, .274225E+07,
     +  .200968E+07, .147140E+07, .107599E+07, .786027E+06 /
        DATA (UPDI(I),I=5929,5980) /
     +  .573462E+06, .417918E+06, .304145E+06, .221083E+06,
     +  .160471E+06, .116330E+06, .842015E+05, .608662E+05,
     +  .439269E+05, .316591E+05, .227795E+05, .163676E+05,
     +  .117385E+05, .840968E+04, .598740E+04, .427842E+04,
     +  .305339E+04, .217716E+04, .155115E+04, .110464E+04,
     +  .787313E+03, .560952E+03, .400070E+03, .285829E+03,
     +  .204676E+03, .147022E+03, .105976E+03, .767528E+02,
     +  .558485E+02, .408556E+02, .300553E+02, .222400E+02,
     +  .165497E+02, .124007E+02, .932420E+01, .705924E+01,
     +  .536015E+01, .409063E+01, .313283E+01, .240615E+01,
     +  .185224E+01, .142802E+01, .110201E+01, .850573E+00,
     +  .656255E+00, .505743E+00, .389092E+00, .298603E+00,
     +  .228474E+00, .174063E+00, .132168E+00, .996340E-01 /
        DATA (UPDI(I),I=5981,6032) /
     +  .746400E-01, .555062E-01, .409402E-01, .299123E-01,
     +  .216260E-01, .154478E-01, .108889E-01, .756057E-02,
     +  .515447E-02, .345681E-02, .226178E-02, .144259E-02,
     +  .893687E-03, .534898E-03, .307603E-03, .168457E-03,
     +  .872364E-04, .418904E-04, .184489E-04, .722649E-05,
     +  .242527E-05, .652774E-06, .126520E-06, .140456E-07,
     +  .100012E-09, .000000E+00, .392298E+08, .293780E+08,
     +  .215799E+08, .158356E+08, .116106E+08, .850387E+07,
     +  .622279E+07, .454846E+07, .332141E+07, .242247E+07,
     +  .176499E+07, .128431E+07, .933490E+06, .677575E+06,
     +  .491227E+06, .355612E+06, .257106E+06, .185600E+06,
     +  .133798E+06, .962969E+05, .692075E+05, .496535E+05,
     +  .355717E+05, .254383E+05, .181638E+05, .129435E+05 /
        DATA (UPDI(I),I=6033,6084) /
     +  .921271E+04, .651502E+04, .462392E+04, .327719E+04,
     +  .232025E+04, .164122E+04, .116020E+04, .820751E+03,
     +  .580320E+03, .410681E+03, .291101E+03, .206789E+03,
     +  .147338E+03, .105336E+03, .756589E+02, .545938E+02,
     +  .396018E+02, .288864E+02, .211929E+02, .156351E+02,
     +  .116148E+02, .865725E+01, .649739E+01, .489023E+01,
     +  .369920E+01, .280806E+01, .213760E+01, .163088E+01,
     +  .124613E+01, .953030E+00, .728966E+00, .557352E+00,
     +  .425630E+00, .324479E+00, .246741E+00, .187059E+00,
     +  .141194E+00, .106217E+00, .793207E-01, .588611E-01,
     +  .433555E-01, .316707E-01, .229150E-01, .164044E-01,
     +  .116013E-01, .809505E-02, .556309E-02, .375298E-02,
     +  .249029E-02, .161168E-02, .101655E-02, .622602E-03 /
        DATA (UPDI(I),I=6085,6136) /
     +  .368309E-03, .209269E-03, .113198E-03, .578795E-04,
     +  .274319E-04, .119197E-04, .460538E-05, .152398E-05,
     +  .404454E-06, .771972E-07, .833687E-08, .000000E+00,
     +  .000000E+00, .485341E+08, .362161E+08, .264897E+08,
     +  .193548E+08, .141288E+08, .103025E+08, .750506E+07,
     +  .546078E+07, .396917E+07, .288137E+07, .208934E+07,
     +  .151299E+07, .109431E+07, .790352E+06, .570083E+06,
     +  .410576E+06, .295288E+06, .212029E+06, .152021E+06,
     +  .108809E+06, .777599E+05, .554702E+05, .395066E+05,
     +  .280842E+05, .199311E+05, .141147E+05, .998280E+04,
     +  .701344E+04, .494488E+04, .348116E+04, .244776E+04,
     +  .171933E+04, .120674E+04, .847497E+03, .594795E+03,
     +  .417761E+03, .293856E+03, .207128E+03, .146421E+03 /
        DATA (UPDI(I),I=6137,6188) /
     +  .103849E+03, .739918E+02, .529586E+02, .381018E+02,
     +  .275638E+02, .200551E+02, .146725E+02, .108088E+02,
     +  .798855E+01, .594508E+01, .443652E+01, .332749E+01,
     +  .250438E+01, .189013E+01, .142973E+01, .108305E+01,
     +  .821182E+00, .622700E+00, .471990E+00, .357323E+00,
     +  .270041E+00, .203560E+00, .152978E+00, .114458E+00,
     +  .853512E-01, .631753E-01, .464640E-01, .339189E-01,
     +  .245549E-01, .176060E-01, .124889E-01, .875118E-02,
     +  .604963E-02, .411848E-02, .275197E-02, .180861E-02,
     +  .115909E-02, .723860E-03, .438884E-03, .256983E-03,
     +  .144500E-03, .773409E-04, .391223E-04, .183406E-04,
     +  .788164E-05, .301157E-05, .985359E-06, .258587E-06,
     +  .487384E-07, .513303E-08, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .592615E+08, .440670E+08, .320976E+08, .233534E+08,
     +  .169747E+08, .123241E+08, .893825E+07, .647465E+07,
     +  .468482E+07, .338532E+07, .244333E+07, .176100E+07,
     +  .126757E+07, .911036E+06, .653879E+06, .468560E+06,
     +  .335267E+06, .239484E+06, .170797E+06, .121591E+06,
     +  .864174E+05, .613020E+05, .434115E+05, .306810E+05,
     +  .216451E+05, .152357E+05, .107093E+05, .747592E+04,
     +  .523716E+04, .366285E+04, .255833E+04, .178479E+04,
     +  .124398E+04, .867502E+03, .604452E+03, .421440E+03,
     +  .294239E+03, .205836E+03, .144396E+03, .101622E+03,
     +  .718401E+02, .510139E+02, .364113E+02, .261305E+02,
     +  .188596E+02, .136863E+02, .100009E+02, .733102E+01,
     +  .541136E+01, .400509E+01, .297930E+01, .222392E+01 /
        DATA (UPDI(I),I=6241,6292) /
     +  .166467E+01, .124884E+01, .938241E+00, .705532E+00,
     +  .530602E+00, .398874E+00, .299487E+00, .224472E+00,
     +  .167819E+00, .125082E+00, .928156E-01, .686449E-01,
     +  .503902E-01, .367544E-01, .266088E-01, .191030E-01,
     +  .135830E-01, .955474E-02, .663908E-02, .455087E-02,
     +  .307194E-02, .203513E-02, .132610E-02, .842516E-03,
     +  .521585E-03, .313472E-03, .181932E-03, .101389E-03,
     +  .537819E-04, .269598E-04, .125242E-04, .533278E-05,
     +  .201896E-05, .654350E-06, .170081E-06, .317022E-07,
     +  .326404E-08, .000000E+00, .000000E+00, .714816E+08,
     +  .529733E+08, .384271E+08, .278430E+08, .201532E+08,
     +  .145697E+08, .105214E+08, .758827E+07, .546629E+07,
     +  .393232E+07, .282521E+07, .202683E+07, .145207E+07 /
        DATA (UPDI(I),I=6293,6344) /
     +  .103868E+07, .741887E+06, .529017E+06, .376633E+06,
     +  .267667E+06, .189910E+06, .134487E+06, .950709E+05,
     +  .670733E+05, .472345E+05, .331940E+05, .232827E+05,
     +  .162916E+05, .113828E+05, .789672E+04, .549739E+04,
     +  .382038E+04, .265102E+04, .183722E+04, .127187E+04,
     +  .880866E+03, .609462E+03, .421909E+03, .292436E+03,
     +  .203075E+03, .141401E+03, .987664E+02, .692919E+02,
     +  .488281E+02, .345825E+02, .246257E+02, .176350E+02,
     +  .126974E+02, .920576E+01, .669489E+01, .490300E+01,
     +  .360015E+01, .265696E+01, .196769E+01, .146128E+01,
     +  .108764E+01, .810723E+00, .604869E+00, .451345E+00,
     +  .336650E+00, .250805E+00, .186528E+00, .138375E+00,
     +  .102343E+00, .753587E-01, .553088E-01, .402900E-01 /
        DATA (UPDI(I),I=6345,6396) /
     +  .291629E-01, .209521E-01, .149276E-01, .105336E-01,
     +  .735349E-02, .507086E-02, .344957E-02, .231091E-02,
     +  .151932E-02, .982534E-03, .619491E-03, .380602E-03,
     +  .226998E-03, .130740E-03, .723022E-04, .380588E-04,
     +  .189304E-04, .872540E-05, .368565E-05, .138403E-05,
     +  .444712E-06, .114547E-06, .211237E-07, .213093E-08,
     +  .000000E+00, .000000E+00, .456193E+05, .686938E+05,
     +  .535342E+05, .417259E+05, .325276E+05, .253619E+05,
     +  .197790E+05, .154290E+05, .120391E+05, .939717E+04,
     +  .733781E+04, .573228E+04, .448032E+04, .350384E+04,
     +  .274203E+04, .214751E+04, .168338E+04, .132091E+04,
     +  .103769E+04, .816289E+03, .643106E+03, .507550E+03,
     +  .401364E+03, .318113E+03, .252778E+03, .201447E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .161068E+03, .128861E+03, .103859E+03, .840970E+02,
     +  .684460E+02, .560247E+02, .461436E+02, .382839E+02,
     +  .319805E+02, .269249E+02, .228554E+02, .195660E+02,
     +  .168945E+02, .147121E+02, .129205E+02, .114365E+02,
     +  .101977E+02, .915394E+01, .826565E+01, .750156E+01,
     +  .683931E+01, .625314E+01, .573502E+01, .526661E+01,
     +  .484331E+01, .445605E+01, .409917E+01, .376826E+01,
     +  .345992E+01, .317152E+01, .290107E+01, .264706E+01,
     +  .240832E+01, .218400E+01, .197340E+01, .177599E+01,
     +  .159135E+01, .141987E+01, .125944E+01, .111085E+01,
     +  .973794E+00, .847968E+00, .733046E+00, .628681E+00,
     +  .534496E+00, .450087E+00, .374969E+00, .308623E+00,
     +  .251106E+00, .201033E+00, .158277E+00, .122248E+00 /
        DATA (UPDI(I),I=6449,6500) /
     +  .923472E-01, .679678E-01, .485008E-01, .333620E-01,
     +  .218705E-01, .135457E-01, .777182E-02, .401746E-02,
     +  .178581E-02, .625443E-03, .141811E-03, .111060E-04,
     +  .000000E+00, .123095E+06, .963936E+05, .746159E+05,
     +  .577622E+05, .447225E+05, .346299E+05, .268204E+05,
     +  .207753E+05, .160970E+05, .124750E+05, .967147E+04,
     +  .750041E+04, .581946E+04, .451731E+04, .350873E+04,
     +  .272707E+04, .212133E+04, .165159E+04, .128730E+04,
     +  .100456E+04, .785084E+03, .614552E+03, .482005E+03,
     +  .378859E+03, .298549E+03, .235933E+03, .187078E+03,
     +  .148405E+03, .118625E+03, .952629E+02, .769099E+02,
     +  .624515E+02, .510391E+02, .420253E+02, .348499E+02,
     +  .291319E+02, .245602E+02, .208857E+02, .179190E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .155069E+02, .135365E+02, .119108E+02, .105592E+02,
     +  .942414E+01, .846166E+01, .763637E+01, .692370E+01,
     +  .629514E+01, .574194E+01, .524392E+01, .479616E+01,
     +  .438863E+01, .401528E+01, .367118E+01, .335261E+01,
     +  .305662E+01, .278096E+01, .252385E+01, .228391E+01,
     +  .206006E+01, .185141E+01, .165727E+01, .147694E+01,
     +  .131067E+01, .115621E+01, .101417E+01, .884077E+00,
     +  .765497E+00, .657959E+00, .560997E+00, .474113E+00,
     +  .396809E+00, .328534E+00, .268664E+00, .217154E+00,
     +  .172657E+00, .134961E+00, .103459E+00, .775357E-01,
     +  .565928E-01, .400223E-01, .272675E-01, .176873E-01,
     +  .108289E-01, .613262E-02, .312353E-02, .136442E-02,
     +  .467985E-03, .103869E-03, .822350E-05, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .170635E+06, .132924E+06, .102277E+06, .786949E+05,
     +  .605564E+05, .465989E+05, .358636E+05, .276029E+05,
     +  .212493E+05, .163601E+05, .125994E+05, .970523E+04,
     +  .747881E+04, .576506E+04, .444645E+04, .343117E+04,
     +  .264971E+04, .204773E+04, .158415E+04, .122681E+04,
     +  .951412E+03, .738930E+03, .574985E+03, .448326E+03,
     +  .350444E+03, .274692E+03, .216046E+03, .169968E+03,
     +  .134759E+03, .107344E+03, .859738E+02, .692623E+02,
     +  .561707E+02, .459041E+02, .377901E+02, .313669E+02,
     +  .262653E+02, .221889E+02, .189170E+02, .162700E+02,
     +  .141186E+02, .123509E+02, .108875E+02, .966295E+01,
     +  .862844E+01, .774446E+01, .698394E+01, .631569E+01,
     +  .573002E+01, .520505E+01, .473535E+01, .431004E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .392256E+01, .356749E+01, .324078E+01, .293912E+01,
     +  .266000E+01, .240138E+01, .216165E+01, .193951E+01,
     +  .173387E+01, .154384E+01, .136851E+01, .120796E+01,
     +  .105983E+01, .924544E+00, .801486E+00, .690090E+00,
     +  .589760E+00, .499927E+00, .419989E+00, .349370E+00,
     +  .287458E+00, .233553E+00, .187523E+00, .148063E+00,
     +  .114897E+00, .874089E-01, .649800E-01, .470229E-01,
     +  .329462E-01, .222239E-01, .142577E-01, .862386E-02,
     +  .481720E-02, .241514E-02, .103534E-02, .347111E-03,
     +  .752358E-04, .603022E-05, .000000E+00, .232457E+06,
     +  .180230E+06, .137923E+06, .105536E+06, .807566E+05,
     +  .617896E+05, .472806E+05, .361766E+05, .276838E+05,
     +  .211850E+05, .162149E+05, .124119E+05, .950377E+04 /
        DATA (UPDI(I),I=6657,6708) /
     +  .727853E+04, .557678E+04, .427451E+04, .327846E+04,
     +  .251602E+04, .193266E+04, .148592E+04, .114393E+04,
     +  .881832E+03, .681001E+03, .526916E+03, .408682E+03,
     +  .317830E+03, .248009E+03, .193548E+03, .152241E+03,
     +  .120313E+03, .956082E+02, .764296E+02, .615145E+02,
     +  .499005E+02, .407856E+02, .336179E+02, .279618E+02,
     +  .234693E+02, .198841E+02, .169987E+02, .146651E+02,
     +  .127562E+02, .111825E+02, .987061E+01, .876654E+01,
     +  .782655E+01, .702086E+01, .631564E+01, .570013E+01,
     +  .515081E+01, .466166E+01, .422093E+01, .382155E+01,
     +  .345763E+01, .312473E+01, .281921E+01, .253827E+01,
     +  .227961E+01, .204139E+01, .182208E+01, .162039E+01,
     +  .143525E+01, .126554E+01, .111117E+01, .969674E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .841311E+00, .725326E+00, .621038E+00, .527741E+00,
     +  .444773E+00, .371447E+00, .307122E+00, .251133E+00,
     +  .202728E+00, .161698E+00, .126791E+00, .976792E-01,
     +  .737474E-01, .543849E-01, .390213E-01, .270891E-01,
     +  .180931E-01, .114813E-01, .686132E-02, .378062E-02,
     +  .186597E-02, .785180E-03, .257438E-03, .545427E-04,
     +  .442477E-05, .000000E+00, .311732E+06, .240644E+06,
     +  .183228E+06, .139484E+06, .106179E+06, .808117E+05,
     +  .615040E+05, .468022E+05, .356158E+05, .271005E+05,
     +  .206232E+05, .156937E+05, .119448E+05, .909223E+04,
     +  .692322E+04, .527294E+04, .401815E+04, .306339E+04,
     +  .233734E+04, .178476E+04, .136442E+04, .104434E+04,
     +  .800675E+03, .614962E+03, .473419E+03, .365396E+03 /
        DATA (UPDI(I),I=6761,6812) /
     +  .282960E+03, .219109E+03, .171024E+03, .134119E+03,
     +  .105768E+03, .839140E+02, .670379E+02, .539880E+02,
     +  .438158E+02, .358691E+02, .296379E+02, .247182E+02,
     +  .208142E+02, .176888E+02, .151734E+02, .131249E+02,
     +  .114433E+02, .100469E+02, .887622E+01, .788318E+01,
     +  .703522E+01, .629588E+01, .565323E+01, .508217E+01,
     +  .457601E+01, .412221E+01, .371310E+01, .334235E+01,
     +  .300511E+01, .269743E+01, .241619E+01, .215884E+01,
     +  .192330E+01, .170783E+01, .151092E+01, .133134E+01,
     +  .116777E+01, .101994E+01, .885309E+00, .763971E+00,
     +  .655048E+00, .557755E+00, .471290E+00, .394913E+00,
     +  .327864E+00, .269452E+00, .218969E+00, .175629E+00,
     +  .139160E+00, .108365E+00, .828818E-01, .621018E-01 /
        DATA (UPDI(I),I=6813,6864) /
     +  .454303E-01, .323193E-01, .222307E-01, .147020E-01,
     +  .922808E-02, .544876E-02, .296169E-02, .143916E-02,
     +  .594528E-03, .190714E-03, .395322E-04, .324549E-05,
     +  .000000E+00, .412098E+06, .316825E+06, .240089E+06,
     +  .181890E+06, .137782E+06, .104342E+06, .790097E+05,
     +  .598133E+05, .452782E+05, .342686E+05, .259360E+05,
     +  .196270E+05, .148541E+05, .112416E+05, .850946E+04,
     +  .644216E+04, .487907E+04, .369648E+04, .280239E+04,
     +  .212592E+04, .161443E+04, .122732E+04, .934462E+03,
     +  .712666E+03, .544712E+03, .417368E+03, .320838E+03,
     +  .246575E+03, .191031E+03, .148694E+03, .116392E+03,
     +  .916657E+02, .727012E+02, .581356E+02, .468569E+02,
     +  .381026E+02, .312804E+02, .259260E+02, .217006E+02 /
        DATA (UPDI(I),I=6865,6916) /
     +  .183356E+02, .156403E+02, .134553E+02, .116690E+02,
     +  .101916E+02, .895760E+01, .791480E+01, .702768E+01,
     +  .625720E+01, .559020E+01, .500005E+01, .447935E+01,
     +  .401476E+01, .359805E+01, .322241E+01, .288261E+01,
     +  .257435E+01, .229423E+01, .203943E+01, .180764E+01,
     +  .159690E+01, .140551E+01, .123206E+01, .107504E+01,
     +  .934035E+00, .806428E+00, .692156E+00, .590234E+00,
     +  .499784E+00, .419927E+00, .349850E+00, .288742E+00,
     +  .235869E+00, .190493E+00, .151807E+00, .119491E+00,
     +  .924056E-01, .701647E-01, .521743E-01, .378619E-01,
     +  .267056E-01, .182006E-01, .119179E-01, .739921E-02,
     +  .431651E-02, .231452E-02, .110729E-02, .449126E-03,
     +  .141006E-03, .286189E-04, .237739E-05, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .537669E+06, .411765E+06, .310625E+06, .234248E+06,
     +  .176616E+06, .133117E+06, .100312E+06, .755675E+05,
     +  .569181E+05, .428589E+05, .322693E+05, .242907E+05,
     +  .182846E+05, .137617E+05, .103587E+05, .779727E+04,
     +  .587086E+04, .442133E+04, .333148E+04, .251156E+04,
     +  .189516E+04, .143138E+04, .108261E+04, .820074E+03,
     +  .622499E+03, .473635E+03, .361518E+03, .275825E+03,
     +  .212155E+03, .163946E+03, .127408E+03, .996261E+02,
     +  .784588E+02, .623085E+02, .498828E+02, .402992E+02,
     +  .328756E+02, .270830E+02, .225366E+02, .189345E+02,
     +  .160631E+02, .137456E+02, .118587E+02, .103043E+02,
     +  .901087E+01, .792190E+01, .699895E+01, .620045E+01,
     +  .551195E+01, .490540E+01, .437262E+01, .389951E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .347726E+01, .309861E+01, .275793E+01, .245060E+01,
     +  .217290E+01, .192179E+01, .169470E+01, .148948E+01,
     +  .130424E+01, .113739E+01, .987268E+00, .853287E+00,
     +  .732794E+00, .625572E+00, .530545E+00, .446753E+00,
     +  .373251E+00, .309173E+00, .253667E+00, .205965E+00,
     +  .165310E+00, .130890E+00, .102345E+00, .785971E-01,
     +  .592472E-01, .437206E-01, .314719E-01, .220085E-01,
     +  .148612E-01, .963479E-02, .591645E-02, .340998E-02,
     +  .180366E-02, .849541E-03, .338350E-03, .103998E-03,
     +  .206821E-04, .173825E-05, .000000E+00, .693026E+06,
     +  .528774E+06, .397162E+06, .298189E+06, .223820E+06,
     +  .167926E+06, .125958E+06, .944403E+05, .707924E+05,
     +  .530460E+05, .397408E+05, .297634E+05, .222883E+05 /
        DATA (UPDI(I),I=7021,7072) /
     +  .166868E+05, .124929E+05, .935217E+04, .700215E+04,
     +  .524314E+04, .392761E+04, .294330E+04, .220738E+04,
     +  .165680E+04, .124513E+04, .937058E+03, .706593E+03,
     +  .533998E+03, .404812E+03, .306697E+03, .234259E+03,
     +  .179765E+03, .138729E+03, .107729E+03, .842603E+02,
     +  .664693E+02, .528662E+02, .424391E+02, .344093E+02,
     +  .281793E+02, .233154E+02, .194812E+02, .164388E+02,
     +  .139942E+02, .120117E+02, .103850E+02, .903632E+01,
     +  .790505E+01, .694980E+01, .612651E+01, .541946E+01,
     +  .479921E+01, .425679E+01, .377739E+01, .335161E+01,
     +  .297175E+01, .263179E+01, .232678E+01, .205273E+01,
     +  .180633E+01, .158481E+01, .138579E+01, .120723E+01,
     +  .104736E+01, .904388E+00, .777565E+00, .664212E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .563972E+00, .475690E+00, .398338E+00, .330921E+00,
     +  .272528E+00, .222279E+00, .179386E+00, .143082E+00,
     +  .112558E+00, .874253E-01, .666720E-01, .498920E-01,
     +  .365355E-01, .260871E-01, .180860E-01, .120994E-01,
     +  .776615E-02, .471670E-02, .268565E-02, .140124E-02,
     +  .649766E-03, .254122E-03, .764908E-04, .149148E-04,
     +  .126813E-05, .000000E+00, .883193E+06, .671461E+06,
     +  .502217E+06, .375460E+06, .280600E+06, .209602E+06,
     +  .156516E+06, .116819E+06, .871622E+05, .650050E+05,
     +  .484668E+05, .361215E+05, .269150E+05, .200485E+05,
     +  .149320E+05, .111191E+05, .828016E+04, .616597E+04,
     +  .459291E+04, .342208E+04, .255137E+04, .190350E+04,
     +  .142176E+04, .106330E+04, .796677E+03, .598167E+03 /
        DATA (UPDI(I),I=7125,7176) /
     +  .450473E+03, .338986E+03, .257182E+03, .196026E+03,
     +  .150258E+03, .115901E+03, .900521E+02, .705787E+02,
     +  .557790E+02, .445025E+02, .358678E+02, .292056E+02,
     +  .240308E+02, .199717E+02, .167653E+02, .141998E+02,
     +  .121276E+02, .104337E+02, .903443E+01, .786500E+01,
     +  .688112E+01, .603639E+01, .531377E+01, .468252E+01,
     +  .413289E+01, .364938E+01, .322201E+01, .284266E+01,
     +  .250491E+01, .220353E+01, .193423E+01, .169348E+01,
     +  .147826E+01, .128604E+01, .111459E+01, .962005E+00,
     +  .826357E+00, .706755E+00, .600508E+00, .507131E+00,
     +  .425405E+00, .354248E+00, .292624E+00, .239593E+00,
     +  .194258E+00, .155819E+00, .123508E+00, .965286E-01,
     +  .744745E-01, .563980E-01, .418950E-01, .304434E-01 /
        DATA (UPDI(I),I=7177,7228) /
     +  .215606E-01, .148184E-01, .982121E-02, .624069E-02,
     +  .374847E-02, .210843E-02, .108508E-02, .495348E-03,
     +  .190249E-03, .560934E-04, .107307E-04, .922912E-06,
     +  .000000E+00, .111359E+07, .843690E+06, .628460E+06,
     +  .467899E+06, .348215E+06, .259001E+06, .192565E+06,
     +  .143092E+06, .106287E+06, .789072E+05, .585591E+05,
     +  .434371E+05, .322102E+05, .238751E+05, .176932E+05,
     +  .131080E+05, .971039E+04, .719259E+04, .532852E+04,
     +  .394815E+04, .292690E+04, .217103E+04, .161200E+04,
     +  .119830E+04, .892303E+03, .665764E+03, .498193E+03,
     +  .372451E+03, .280737E+03, .212586E+03, .161890E+03,
     +  .124065E+03, .957788E+02, .745972E+02, .585935E+02,
     +  .464701E+02, .372381E+02, .301531E+02, .246773E+02 /
        DATA (UPDI(I),I=7229,7280) /
     +  .204026E+02, .170405E+02, .143617E+02, .122062E+02,
     +  .104508E+02, .900588E+01, .780264E+01, .679395E+01,
     +  .593116E+01, .519597E+01, .455642E+01, .400197E+01,
     +  .351645E+01, .308935E+01, .271213E+01, .237802E+01,
     +  .208146E+01, .181792E+01, .158362E+01, .137536E+01,
     +  .119043E+01, .102643E+01, .881346E+00, .753121E+00,
     +  .640739E+00, .541510E+00, .454833E+00, .379441E+00,
     +  .314209E+00, .258074E+00, .210076E+00, .169312E+00,
     +  .134980E+00, .106318E+00, .825520E-01, .632637E-01,
     +  .475712E-01, .350780E-01, .252927E-01, .177663E-01,
     +  .121044E-01, .794736E-02, .499910E-02, .296945E-02,
     +  .164988E-02, .837469E-03, .376365E-03, .141963E-03,
     +  .410105E-04, .770141E-05, .669969E-06, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .138997E+07, .104954E+07, .778681E+06, .577406E+06,
     +  .427954E+06, .316989E+06, .234685E+06, .173643E+06,
     +  .128418E+06, .949154E+05, .701217E+05, .517754E+05,
     +  .382141E+05, .281907E+05, .207900E+05, .153261E+05,
     +  .112963E+05, .832422E+04, .613445E+04, .452092E+04,
     +  .333314E+04, .245852E+04, .181503E+04, .134136E+04,
     +  .992895E+03, .736329E+03, .547613E+03, .406818E+03,
     +  .304719E+03, .229295E+03, .173514E+03, .132143E+03,
     +  .101384E+03, .784859E+02, .612828E+02, .483240E+02,
     +  .385083E+02, .310143E+02, .252503E+02, .207713E+02,
     +  .172632E+02, .144794E+02, .122477E+02, .104369E+02,
     +  .895158E+01, .771901E+01, .668940E+01, .581199E+01,
     +  .506724E+01, .442203E+01, .386507E+01, .337959E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .295453E+01, .258098E+01, .225179E+01, .196115E+01,
     +  .170425E+01, .147713E+01, .127637E+01, .109912E+01,
     +  .942841E+00, .805384E+00, .684613E+00, .579391E+00,
     +  .487042E+00, .406865E+00, .337556E+00, .277959E+00,
     +  .226997E+00, .183701E+00, .147170E+00, .116608E+00,
     +  .912681E-01, .704015E-01, .535881E-01, .400106E-01,
     +  .292848E-01, .209513E-01, .145958E-01, .985719E-02,
     +  .641103E-02, .399183E-02, .234474E-02, .128680E-02,
     +  .644207E-03, .285001E-03, .105582E-03, .298917E-04,
     +  .551358E-05, .485099E-06, .000000E+00, .171833E+07,
     +  .129321E+07, .955737E+06, .705907E+06, .521103E+06,
     +  .384422E+06, .283437E+06, .208839E+06, .153791E+06,
     +  .113179E+06, .832471E+05, .611925E+05, .449593E+05 /
        DATA (UPDI(I),I=7385,7436) /
     +  .330133E+05, .242317E+05, .177775E+05, .130390E+05,
     +  .956042E+04, .700953E+04, .513897E+04, .376867E+04,
     +  .276470E+04, .202978E+04, .149160E+04, .109776E+04,
     +  .809327E+03, .598328E+03, .441788E+03, .328909E+03,
     +  .245994E+03, .185020E+03, .140056E+03, .106814E+03,
     +  .822076E+02, .638222E+02, .500478E+02, .396680E+02,
     +  .317828E+02, .257460E+02, .210758E+02, .174328E+02,
     +  .145532E+02, .122529E+02, .103930E+02, .887264E+01,
     +  .761533E+01, .656875E+01, .568014E+01, .492877E+01,
     +  .428050E+01, .372329E+01, .323978E+01, .281843E+01,
     +  .244996E+01, .212689E+01, .184314E+01, .159367E+01,
     +  .137432E+01, .118152E+01, .101224E+01, .863859E+00,
     +  .734096E+00, .620746E+00, .522572E+00, .436922E+00 /
        DATA (UPDI(I),I=7437,7488) /
     +  .363011E+00, .299508E+00, .245243E+00, .199132E+00,
     +  .160206E+00, .127578E+00, .100461E+00, .781321E-01,
     +  .598716E-01, .452640E-01, .335552E-01, .243772E-01,
     +  .173039E-01, .119552E-01, .800273E-02, .515566E-02,
     +  .317746E-02, .184550E-02, .100035E-02, .493900E-03,
     +  .215095E-03, .782686E-04, .217217E-04, .393756E-05,
     +  .350344E-06, .000000E+00, .210482E+07, .157900E+07,
     +  .116249E+07, .855309E+06, .628921E+06, .462121E+06,
     +  .339353E+06, .249018E+06, .182618E+06, .133827E+06,
     +  .980130E+05, .717330E+05, .524699E+05, .383548E+05,
     +  .280231E+05, .204630E+05, .149371E+05, .108990E+05,
     +  .795135E+04, .580001E+04, .423152E+04, .308793E+04,
     +  .225492E+04, .164800E+04, .120611E+04, .884163E+03 /
        DATA (UPDI(I),I=7489,7540) /
     +  .649900E+03, .477043E+03, .353078E+03, .262522E+03,
     +  .196294E+03, .147726E+03, .112017E+03, .857277E+02,
     +  .661891E+02, .516272E+02, .407083E+02, .324535E+02,
     +  .261619E+02, .213151E+02, .175491E+02, .145834E+02,
     +  .122226E+02, .103203E+02, .877036E+01, .749294E+01,
     +  .643332E+01, .553690E+01, .478181E+01, .413299E+01,
     +  .357767E+01, .309796E+01, .268188E+01, .231979E+01,
     +  .200391E+01, .172792E+01, .148655E+01, .127548E+01,
     +  .109098E+01, .929903E+00, .789505E+00, .667431E+00,
     +  .561412E+00, .470125E+00, .390957E+00, .323049E+00,
     +  .265061E+00, .215813E+00, .174227E+00, .139346E+00,
     +  .110297E+00, .863164E-01, .667036E-01, .507758E-01,
     +  .381257E-01, .280615E-01, .202337E-01, .142498E-01 /
        DATA (UPDI(I),I=7541,7592) /
     +  .976323E-02, .647757E-02, .413339E-02, .252133E-02,
     +  .144795E-02, .775146E-03, .377426E-03, .161804E-03,
     +  .578352E-04, .157383E-04, .280528E-05, .252390E-06,
     +  .000000E+00, .255560E+07, .191114E+07, .140176E+07,
     +  .102745E+07, .752604E+06, .550854E+06, .402917E+06,
     +  .294480E+06, .215081E+06, .156967E+06, .114479E+06,
     +  .834279E+05, .607602E+05, .442196E+05, .321634E+05,
     +  .233793E+05, .169866E+05, .123359E+05, .895624E+04,
     +  .650093E+04, .471912E+04, .342618E+04, .248889E+04,
     +  .180935E+04, .131706E+04, .960193E+03, .701864E+03,
     +  .512253E+03, .376997E+03, .278720E+03, .207227E+03,
     +  .155082E+03, .116944E+03, .890149E+02, .683639E+02,
     +  .530503E+02, .416225E+02, .330228E+02, .264962E+02 /
        DATA (UPDI(I),I=7593,7644) /
     +  .214890E+02, .176128E+02, .145712E+02, .121581E+02,
     +  .102201E+02, .864619E+01, .735331E+01, .628454E+01,
     +  .538361E+01, .462762E+01, .398064E+01, .342924E+01,
     +  .295506E+01, .254568E+01, .219115E+01, .188341E+01,
     +  .161592E+01, .138323E+01, .118084E+01, .100490E+01,
     +  .852149E+00, .719761E+00, .605309E+00, .506479E+00,
     +  .421878E+00, .348942E+00, .286754E+00, .233974E+00,
     +  .189424E+00, .152041E+00, .120884E+00, .951052E-01,
     +  .739649E-01, .567931E-01, .429443E-01, .320245E-01,
     +  .234015E-01, .167469E-01, .117009E-01, .794990E-02,
     +  .522753E-02, .330384E-02, .199456E-02, .113250E-02,
     +  .598745E-03, .287498E-03, .121327E-03, .426035E-04,
     +  .113706E-04, .199398E-05, .181384E-06, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .456755E+05, .685053E+05, .533659E+05, .415759E+05,
     +  .323938E+05, .252426E+05, .196727E+05, .153343E+05,
     +  .119549E+05, .932221E+04, .727115E+04, .567305E+04,
     +  .442773E+04, .345717E+04, .270064E+04, .211084E+04,
     +  .165092E+04, .129219E+04, .101231E+04, .793879E+03,
     +  .623336E+03, .490124E+03, .386016E+03, .304605E+03,
     +  .240898E+03, .191002E+03, .151887E+03, .120803E+03,
     +  .967693E+02, .778499E+02, .629298E+02, .511385E+02,
     +  .417966E+02, .343937E+02, .284754E+02, .237398E+02,
     +  .199326E+02, .168549E+02, .143513E+02, .122993E+02,
     +  .106067E+02, .919644E+01, .801143E+01, .700671E+01,
     +  .614733E+01, .540620E+01, .476445E+01, .419957E+01,
     +  .370564E+01, .326652E+01, .287865E+01, .253390E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .222701E+01, .195361E+01, .171002E+01, .149310E+01,
     +  .130012E+01, .112869E+01, .976688E+00, .842198E+00,
     +  .723492E+00, .618996E+00, .527272E+00, .447357E+00,
     +  .377233E+00, .316330E+00, .263648E+00, .218277E+00,
     +  .179394E+00, .146249E+00, .118165E+00, .945266E-01,
     +  .747688E-01, .583796E-01, .450363E-01, .341312E-01,
     +  .253983E-01, .185045E-01, .131533E-01, .908143E-02,
     +  .605567E-02, .387409E-02, .234648E-02, .133237E-02,
     +  .693303E-03, .320208E-03, .124422E-03, .367880E-04,
     +  .660636E-05, .350390E-06, .000000E+00, .122869E+06,
     +  .961918E+05, .744359E+05, .576017E+05, .445794E+05,
     +  .345024E+05, .267069E+05, .206742E+05, .160071E+05,
     +  .123951E+05, .960043E+04, .743732E+04, .576346E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .446763E+04, .346470E+04, .268808E+04, .208682E+04,
     +  .162106E+04, .126032E+04, .980742E+03, .764073E+03,
     +  .596029E+03, .465685E+03, .364488E+03, .285899E+03,
     +  .224800E+03, .177278E+03, .139791E+03, .111031E+03,
     +  .885573E+02, .709739E+02, .571793E+02, .463354E+02,
     +  .378041E+02, .310363E+02, .256589E+02, .213682E+02,
     +  .179231E+02, .151410E+02, .128759E+02, .110209E+02,
     +  .948540E+01, .820439E+01, .712552E+01, .620940E+01,
     +  .542476E+01, .475033E+01, .416081E+01, .364919E+01,
     +  .319753E+01, .280149E+01, .245195E+01, .214298E+01,
     +  .186962E+01, .162771E+01, .141371E+01, .122456E+01,
     +  .105760E+01, .910486E+00, .781123E+00, .667628E+00,
     +  .568333E+00, .481666E+00, .406605E+00, .341115E+00 /
        DATA (UPDI(I),I=7801,7852) /
     +  .284570E+00, .235938E+00, .194303E+00, .158829E+00,
     +  .128772E+00, .103456E+00, .822807E-01, .646970E-01,
     +  .502026E-01, .384815E-01, .289688E-01, .214055E-01,
     +  .154806E-01, .109177E-01, .747543E-02, .493970E-02,
     +  .312963E-02, .187573E-02, .105375E-02, .541606E-03,
     +  .246655E-03, .942605E-04, .273369E-04, .482158E-05,
     +  .259637E-06, .000000E+00, .170394E+06, .132709E+06,
     +  .102085E+06, .785235E+05, .604038E+05, .464629E+05,
     +  .357426E+05, .274953E+05, .211536E+05, .162750E+05,
     +  .125239E+05, .963814E+04, .741928E+04, .571229E+04,
     +  .439969E+04, .338977E+04, .261307E+04, .201534E+04,
     +  .155553E+04, .120154E+04, .929116E+03, .719270E+03,
     +  .557657E+03, .433059E+03, .336996E+03, .262845E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .205605E+03, .160777E+03, .126643E+03, .100165E+03,
     +  .796048E+02, .635931E+02, .511013E+02, .413449E+02,
     +  .336633E+02, .276031E+02, .228031E+02, .189756E+02,
     +  .159068E+02, .134250E+02, .114068E+02, .974729E+01,
     +  .837233E+01, .722206E+01, .625209E+01, .542694E+01,
     +  .472264E+01, .411119E+01, .358429E+01, .312232E+01,
     +  .272004E+01, .236737E+01, .205775E+01, .178562E+01,
     +  .154637E+01, .133607E+01, .115134E+01, .989299E+00,
     +  .847377E+00, .723329E+00, .615136E+00, .521042E+00,
     +  .439371E+00, .369046E+00, .308034E+00, .255657E+00,
     +  .210865E+00, .172741E+00, .140446E+00, .113245E+00,
     +  .904696E-01, .715369E-01, .559171E-01, .431221E-01,
     +  .328444E-01, .245608E-01, .180218E-01, .129382E-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .905393E-02, .614848E-02, .402678E-02, .252713E-02,
     +  .149838E-02, .831175E-03, .421211E-03, .188890E-03,
     +  .708845E-04, .201234E-04, .347820E-05, .190547E-06,
     +  .000000E+00, .232200E+06, .180000E+06, .137718E+06,
     +  .105353E+06, .805941E+05, .616449E+05, .471519E+05,
     +  .360621E+05, .275821E+05, .210946E+05, .161346E+05,
     +  .123407E+05, .944059E+04, .722253E+04, .552718E+04,
     +  .423061E+04, .323962E+04, .248168E+04, .190233E+04,
     +  .145914E+04, .112029E+04, .860988E+03, .662623E+03,
     +  .510716E+03, .394402E+03, .305239E+03, .236901E+03,
     +  .183758E+03, .143583E+03, .112641E+03, .887910E+02,
     +  .703507E+02, .560691E+02, .449952E+02, .363396E+02,
     +  .295595E+02, .242276E+02, .200053E+02, .166436E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .139432E+02, .117622E+02, .998067E+01, .851447E+01,
     +  .729597E+01, .627534E+01, .541283E+01, .468159E+01,
     +  .405097E+01, .351122E+01, .304112E+01, .263447E+01,
     +  .228032E+01, .197141E+01, .170164E+01, .146596E+01,
     +  .126008E+01, .108033E+01, .923605E+00, .787149E+00,
     +  .668577E+00, .565754E+00, .476849E+00, .400105E+00,
     +  .334398E+00, .277707E+00, .229315E+00, .188163E+00,
     +  .153337E+00, .124005E+00, .994439E-01, .790004E-01,
     +  .621095E-01, .482628E-01, .369909E-01, .279967E-01,
     +  .207971E-01, .151542E-01, .108003E-01, .749954E-02,
     +  .505130E-02, .327900E-02, .203845E-02, .119611E-02,
     +  .656007E-03, .328247E-03, .145055E-03, .535301E-04,
     +  .149212E-04, .254250E-05, .141990E-06, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .311457E+06, .240399E+06, .183009E+06, .139290E+06,
     +  .106006E+06, .806579E+05, .613671E+05, .466805E+05,
     +  .355077E+05, .270046E+05, .205380E+05, .156181E+05,
     +  .118778E+05, .903288E+04, .687066E+04, .522643E+04,
     +  .397701E+04, .302703E+04, .230522E+04, .175640E+04,
     +  .133939E+04, .102226E+04, .781200E+03, .597787E+03,
     +  .458271E+03, .352029E+03, .271157E+03, .208694E+03,
     +  .161802E+03, .125937E+03, .984861E+02, .774118E+02,
     +  .612055E+02, .487280E+02, .390443E+02, .315120E+02,
     +  .256297E+02, .210036E+02, .173453E+02, .144263E+02,
     +  .120843E+02, .101839E+02, .862995E+01, .734690E+01,
     +  .627918E+01, .538270E+01, .462761E+01, .398061E+01,
     +  .343045E+01, .295437E+01, .254521E+01, .219113E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .188422E+01, .161787E+01, .138659E+01, .118578E+01,
     +  .101150E+01, .860442E+00, .729676E+00, .616700E+00,
     +  .519285E+00, .435533E+00, .363631E+00, .302411E+00,
     +  .249883E+00, .205294E+00, .167587E+00, .135857E+00,
     +  .109285E+00, .871635E-01, .688586E-01, .538263E-01,
     +  .415808E-01, .316743E-01, .238216E-01, .175787E-01,
     +  .127202E-01, .899965E-02, .620108E-02, .414260E-02,
     +  .266544E-02, .164142E-02, .953181E-03, .516882E-03,
     +  .255384E-03, .111278E-03, .404150E-04, .110733E-04,
     +  .186237E-05, .106133E-06, .000000E+00, .411805E+06,
     +  .316564E+06, .239856E+06, .181683E+06, .137598E+06,
     +  .104178E+06, .788644E+05, .596842E+05, .451636E+05,
     +  .341668E+05, .258457E+05, .195470E+05, .147831E+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .111787E+05, .845381E+04, .639293E+04, .483553E+04,
     +  .365800E+04, .276840E+04, .209591E+04, .158794E+04,
     +  .120395E+04, .913840E+03, .694472E+03, .528655E+03,
     +  .403188E+03, .308308E+03, .235508E+03, .181221E+03,
     +  .139980E+03, .108630E+03, .847262E+02, .664705E+02,
     +  .525123E+02, .417537E+02, .334428E+02, .269966E+02,
     +  .219610E+02, .180054E+02, .148699E+02, .123705E+02,
     +  .103553E+02, .871794E+01, .737459E+01, .626374E+01,
     +  .533690E+01, .456116E+01, .390064E+01, .334254E+01,
     +  .286261E+01, .245270E+01, .210018E+01, .179650E+01,
     +  .153455E+01, .130844E+01, .111329E+01, .944906E+00,
     +  .799796E+00, .674896E+00, .567596E+00, .475593E+00,
     +  .396935E+00, .329770E+00, .272897E+00, .224366E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .183397E+00, .148944E+00, .120115E+00, .961080E-01,
     +  .762374E-01, .598913E-01, .465487E-01, .357475E-01,
     +  .270638E-01, .202257E-01, .148263E-01, .106541E-01,
     +  .748292E-02, .511625E-02, .338992E-02, .216191E-02,
     +  .131880E-02, .757915E-03, .406363E-03, .198264E-03,
     +  .851851E-04, .304537E-04, .820406E-05, .136211E-05,
     +  .791821E-07, .000000E+00, .537358E+06, .411487E+06,
     +  .310378E+06, .234029E+06, .176421E+06, .132943E+06,
     +  .100158E+06, .754305E+05, .567965E+05, .427510E+05,
     +  .321737E+05, .242059E+05, .182094E+05, .136952E+05,
     +  .102998E+05, .774518E+04, .582481E+04, .438064E+04,
     +  .329553E+04, .247982E+04, .186714E+04, .140665E+04,
     +  .106079E+04, .800813E+03, .605491E+03, .458606E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .348228E+03, .264078E+03, .201733E+03, .154680E+03,
     +  .119147E+03, .922352E+02, .718185E+02, .563133E+02,
     +  .444421E+02, .353333E+02, .283148E+02, .228684E+02,
     +  .186176E+02, .152700E+02, .126182E+02, .104935E+02,
     +  .877784E+01, .737897E+01, .622927E+01, .527590E+01,
     +  .448283E+01, .381169E+01, .324809E+01, .276639E+01,
     +  .235748E+01, .200794E+01, .170862E+01, .145196E+01,
     +  .123173E+01, .104275E+01, .880619E+00, .741691E+00,
     +  .622784E+00, .521200E+00, .434581E+00, .360931E+00,
     +  .298380E+00, .245702E+00, .200995E+00, .163462E+00,
     +  .132073E+00, .105953E+00, .843254E-01, .665269E-01,
     +  .519709E-01, .401612E-01, .306604E-01, .230698E-01,
     +  .171317E-01, .124748E-01, .890200E-02, .620660E-02 /
        DATA (UPDI(I),I=8269,8320) /
     +  .421079E-02, .276707E-02, .174911E-02, .105690E-02,
     +  .601117E-03, .318660E-03, .153530E-03, .650487E-04,
     +  .228942E-04, .606577E-05, .994388E-06, .589499E-07,
     +  .000000E+00, .692695E+06, .528480E+06, .396900E+06,
     +  .297956E+06, .223613E+06, .167742E+06, .125795E+06,
     +  .942951E+05, .706635E+05, .529317E+05, .396395E+05,
     +  .296736E+05, .222088E+05, .166164E+05, .124306E+05,
     +  .929709E+04, .695346E+04, .520012E+04, .388961E+04,
     +  .290974E+04, .217775E+04, .163065E+04, .122204E+04,
     +  .916678E+03, .688590E+03, .518081E+03, .390729E+03,
     +  .294240E+03, .223201E+03, .169928E+03, .129952E+03,
     +  .998722E+02, .771996E+02, .600941E+02, .470825E+02,
     +  .371641E+02, .295708E+02, .237165E+02, .191760E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .156226E+02, .128251E+02, .105974E+02, .880930E+01,
     +  .736015E+01, .617622E+01, .520032E+01, .439333E+01,
     +  .371448E+01, .314780E+01, .266637E+01, .226010E+01,
     +  .191488E+01, .162098E+01, .137044E+01, .115669E+01,
     +  .974316E+00, .818739E+00, .686172E+00, .573335E+00,
     +  .477467E+00, .396169E+00, .327419E+00, .269342E+00,
     +  .220696E+00, .179633E+00, .145348E+00, .116833E+00,
     +  .932363E-01, .738088E-01, .579122E-01, .449877E-01,
     +  .345647E-01, .262317E-01, .196158E-01, .144741E-01,
     +  .104693E-01, .741874E-02, .513448E-02, .345640E-02,
     +  .225260E-02, .141129E-02, .844685E-03, .475440E-03,
     +  .249190E-03, .118560E-03, .495373E-04, .171669E-04,
     +  .447448E-05, .724442E-06, .437879E-07, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .882842E+06, .671148E+06, .501938E+06, .375213E+06,
     +  .280380E+06, .209407E+06, .156343E+06, .116665E+06,
     +  .870257E+05, .648840E+05, .483596E+05, .360265E+05,
     +  .268309E+05, .199740E+05, .148662E+05, .110608E+05,
     +  .822870E+04, .612051E+04, .455276E+04, .338663E+04,
     +  .252007E+04, .187586E+04, .139736E+04, .104175E+04,
     +  .777633E+03, .581322E+03, .435561E+03, .325790E+03,
     +  .245463E+03, .185595E+03, .140947E+03, .107565E+03,
     +  .825606E+02, .638162E+02, .496476E+02, .389163E+02,
     +  .307519E+02, .244967E+02, .196750E+02, .159246E+02,
     +  .129896E+02, .106662E+02, .881227E+01, .731854E+01,
     +  .610523E+01, .511092E+01, .429346E+01, .360982E+01,
     +  .304243E+01, .256322E+01, .216117E+01, .182150E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .153400E+01, .129030E+01, .108357E+01, .908166E+00,
     +  .759371E+00, .633283E+00, .526548E+00, .436358E+00,
     +  .360290E+00, .296309E+00, .242547E+00, .197757E+00,
     +  .160153E+00, .128927E+00, .103099E+00, .818442E-01,
     +  .644436E-01, .502869E-01, .388445E-01, .296725E-01,
     +  .223851E-01, .166356E-01, .121967E-01, .876291E-02,
     +  .616597E-02, .423597E-02, .282932E-02, .182865E-02,
     +  .113549E-02, .673148E-03, .374953E-03, .194300E-03,
     +  .912913E-04, .376174E-04, .128377E-04, .329261E-05,
     +  .526634E-06, .324493E-07, .000000E+00, .111322E+07,
     +  .843358E+06, .628165E+06, .467637E+06, .347983E+06,
     +  .258794E+06, .192382E+06, .142929E+06, .106143E+06,
     +  .787792E+05, .584457E+05, .433366E+05, .321213E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .237965E+05, .176236E+05, .130464E+05, .965603E+04,
     +  .714456E+04, .528610E+04, .391070E+04, .289383E+04,
     +  .214183E+04, .158621E+04, .117552E+04, .872170E+03,
     +  .647951E+03, .482418E+03, .358486E+03, .268331E+03,
     +  .201541E+03, .152029E+03, .115237E+03, .878469E+02,
     +  .674409E+02, .521107E+02, .405715E+02, .318458E+02,
     +  .252013E+02, .201100E+02, .161734E+02, .131104E+02,
     +  .106998E+02, .878707E+01, .725478E+01, .601714E+01,
     +  .500862E+01, .418416E+01, .349856E+01, .293278E+01,
     +  .245765E+01, .206127E+01, .172831E+01, .144807E+01,
     +  .121186E+01, .101259E+01, .844454E+00, .702609E+00,
     +  .583065E+00, .482419E+00, .397833E+00, .326874E+00,
     +  .267509E+00, .217890E+00, .176772E+00, .142438E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .114081E+00, .907544E-01, .716653E-01, .561254E-01,
     +  .435551E-01, .334545E-01, .254068E-01, .190526E-01,
     +  .140709E-01, .102501E-01, .731475E-02, .511070E-02,
     +  .348498E-02, .230949E-02, .148025E-02, .910955E-03,
     +  .534879E-03, .294833E-03, .151052E-03, .700869E-04,
     +  .284830E-04, .957393E-05, .241688E-05, .381993E-06,
     +  .239900E-07, .000000E+00, .138957E+07, .104918E+07,
     +  .778368E+06, .577128E+06, .427707E+06, .316770E+06,
     +  .234490E+06, .173471E+06, .128265E+06, .947799E+05,
     +  .700017E+05, .516692E+05, .381200E+05, .281075E+05,
     +  .207164E+05, .152611E+05, .112389E+05, .827350E+04,
     +  .608966E+04, .448137E+04, .329822E+04, .242769E+04,
     +  .178779E+04, .131730E+04, .971624E+03, .717504E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .530939E+03, .392055E+03, .291601E+03, .217615E+03,
     +  .163089E+03, .122811E+03, .930036E+02, .709304E+02,
     +  .544462E+02, .421130E+02, .328418E+02, .258238E+02,
     +  .204772E+02, .163671E+02, .131870E+02, .106982E+02,
     +  .873434E+01, .716979E+01, .591298E+01, .489447E+01,
     +  .406641E+01, .338163E+01, .281966E+01, .235036E+01,
     +  .196103E+01, .163580E+01, .136358E+01, .113541E+01,
     +  .943965E+00, .783322E+00, .648532E+00, .535547E+00,
     +  .440933E+00, .361842E+00, .295847E+00, .240929E+00,
     +  .195269E+00, .157632E+00, .126373E+00, .100696E+00,
     +  .796907E-01, .625959E-01, .487580E-01, .376286E-01,
     +  .287386E-01, .216981E-01, .161737E-01, .118700E-01,
     +  .859108E-02, .608931E-02, .422436E-02, .285913E-02 /
        DATA (UPDI(I),I=8633,8684) /
     +  .187984E-02, .119479E-02, .728699E-03, .423765E-03,
     +  .231148E-03, .117081E-03, .536491E-04, .215042E-04,
     +  .712034E-05, .176965E-05, .276471E-06, .176944E-07,
     +  .000000E+00, .171791E+07, .129284E+07, .955405E+06,
     +  .705613E+06, .520841E+06, .384190E+06, .283231E+06,
     +  .208656E+06, .153630E+06, .113035E+06, .831202E+05,
     +  .610802E+05, .448599E+05, .329254E+05, .241541E+05,
     +  .177089E+05, .129783E+05, .950688E+04, .696225E+04,
     +  .509722E+04, .373181E+04, .273216E+04, .200103E+04,
     +  .146620E+04, .107530E+04, .789450E+03, .580721E+03,
     +  .426197E+03, .315056E+03, .233661E+03, .174014E+03,
     +  .130209E+03, .979773E+02, .742486E+02, .566303E+02,
     +  .435255E+02, .337306E+02, .263587E+02, .207739E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .165047E+02, .132193E+02, .106622E+02, .865509E+01,
     +  .706471E+01, .579393E+01, .476960E+01, .394129E+01,
     +  .325999E+01, .270390E+01, .224206E+01, .186101E+01,
     +  .154444E+01, .128091E+01, .106122E+01, .877891E+00,
     +  .724888E+00, .597199E+00, .490738E+00, .402062E+00,
     +  .328329E+00, .267132E+00, .216474E+00, .174578E+00,
     +  .140226E+00, .111850E+00, .886661E-01, .698042E-01,
     +  .545390E-01, .422519E-01, .324266E-01, .246245E-01,
     +  .184830E-01, .136940E-01, .998691E-02, .718133E-02,
     +  .505545E-02, .348217E-02, .233916E-02, .152581E-02,
     +  .961638E-03, .581230E-03, .334757E-03, .180688E-03,
     +  .904842E-04, .409469E-04, .161892E-04, .528131E-05,
     +  .129259E-05, .199670E-06, .130210E-07, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .210438E+07, .157860E+07, .116214E+07, .854997E+06,
     +  .628644E+06, .461875E+06, .339135E+06, .248825E+06,
     +  .182447E+06, .133675E+06, .978789E+05, .716143E+05,
     +  .523650E+05, .382620E+05, .279411E+05, .203906E+05,
     +  .148731E+05, .108425E+05, .790146E+04, .575597E+04,
     +  .419263E+04, .305359E+04, .222459E+04, .162120E+04,
     +  .118242E+04, .863191E+03, .631324E+03, .460595E+03,
     +  .338467E+03, .249518E+03, .184694E+03, .137355E+03,
     +  .102718E+03, .773623E+02, .586419E+02, .447961E+02,
     +  .345047E+02, .268021E+02, .209984E+02, .165858E+02,
     +  .132080E+02, .105927E+02, .855060E+01, .694089E+01,
     +  .566132E+01, .463526E+01, .380989E+01, .313460E+01,
     +  .258634E+01, .213345E+01, .176177E+01, .145466E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .120038E+01, .989527E+00, .814522E+00, .669244E+00,
     +  .548647E+00, .448631E+00, .365765E+00, .297226E+00,
     +  .240639E+00, .194045E+00, .155711E+00, .124447E+00,
     +  .987591E-01, .778854E-01, .609960E-01, .474029E-01,
     +  .365237E-01, .278741E-01, .210462E-01, .157042E-01,
     +  .115646E-01, .838069E-02, .598708E-02, .418592E-02,
     +  .286262E-02, .190852E-02, .123503E-02, .771812E-03,
     +  .462290E-03, .263688E-03, .140838E-03, .697281E-04,
     +  .311632E-04, .121540E-04, .390702E-05, .941899E-06,
     +  .143907E-06, .956067E-08, .000000E+00, .255513E+07,
     +  .191072E+07, .140139E+07, .102712E+07, .752310E+06,
     +  .550594E+06, .402686E+06, .294276E+06, .214900E+06,
     +  .156807E+06, .114337E+06, .833025E+05, .606494E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .441216E+05, .320768E+05, .233029E+05, .169191E+05,
     +  .122763E+05, .890361E+04, .645448E+04, .467811E+04,
     +  .338997E+04, .245692E+04, .178110E+04, .129208E+04,
     +  .938086E+03, .682285E+03, .494922E+03, .361605E+03,
     +  .265028E+03, .195021E+03, .144178E+03, .107177E+03,
     +  .802419E+02, .604627E+02, .459141E+02, .351583E+02,
     +  .271515E+02, .211502E+02, .166112E+02, .131542E+02,
     +  .104913E+02, .842242E+01, .679985E+01, .551655E+01,
     +  .449271E+01, .367335E+01, .300641E+01, .246777E+01,
     +  .202516E+01, .166384E+01, .136687E+01, .112227E+01,
     +  .920539E+00, .753985E+00, .616453E+00, .502888E+00,
     +  .409200E+00, .331984E+00, .268453E+00, .216277E+00,
     +  .173539E+00, .138562E+00, .110186E+00, .869960E-01 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
