/* config.h -- the main configuration file.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef CONFIG_H
#define CONFIG_H


#include <stdlib.h>
#include <stdio.h>

#ifdef __STDC__

#include <stdarg.h>

#define VA_LIST				...
#define VA_DECL				...
#define VA_START(args, last)		va_start (args, last)

#define AND				,

#define PROTO(list)			list
#define EXFUN(name, arg)		name arg
#define DEFUN(name, list, arg)		name (arg)
#define DEFUN_VAR(name, list, arg) 	name (arg)
#define DEFUN_VOID(name)		name (void)

#else /* !__STDC__ */

#include <vararg.h>

#define VA_LIST				va_alist
#define VA_DECL				va_dcl
#define VA_START(args, last)		va_start (args)

#define AND				;

#define PROTO(list)			()
#define EXFUN(name, arg)		name ()
#define DEFUN(name, list, arg)		name list arg;
#define DEFUN_VAR(name, list, arg)	name list arg
#define DEFUN_VOID(name)		name ()

#define const
#define volatile
#define inline

#endif /* !__STDC__ */


#ifndef FAX_PROG
#define FAX_PROG	"faxdvi2"
#endif

#define SIGNED		0
#define UNSIGNED	1

#define RELAX		0
#define CHECK		1


#endif /* !CONFIG_H */
