// Code generated by gocc; DO NOT EDIT.

package lexer

import (
	"io/ioutil"
	"unicode/utf8"

	"github.com/johnkerl/miller/internal/pkg/parsing/token"
)

const (
	NoState    = -1
	NumStates  = 322
	NumSymbols = 561
)

type Lexer struct {
	src     []byte
	pos     int
	line    int
	column  int
	Context token.Context
}

func NewLexer(src []byte) *Lexer {
	lexer := &Lexer{
		src:     src,
		pos:     0,
		line:    1,
		column:  1,
		Context: nil,
	}
	return lexer
}

// SourceContext is a simple instance of a token.Context which
// contains the name of the source file.
type SourceContext struct {
	Filepath string
}

func (s *SourceContext) Source() string {
	return s.Filepath
}

func NewLexerFile(fpath string) (*Lexer, error) {
	src, err := ioutil.ReadFile(fpath)
	if err != nil {
		return nil, err
	}
	lexer := NewLexer(src)
	lexer.Context = &SourceContext{Filepath: fpath}
	return lexer, nil
}

func (l *Lexer) Scan() (tok *token.Token) {
	tok = &token.Token{}
	if l.pos >= len(l.src) {
		tok.Type = token.EOF
		tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = l.pos, l.line, l.column
		tok.Pos.Context = l.Context
		return
	}
	start, startLine, startColumn, end := l.pos, l.line, l.column, 0
	tok.Type = token.INVALID
	state, rune1, size := 0, rune(-1), 0
	for state != -1 {
		if l.pos >= len(l.src) {
			rune1 = -1
		} else {
			rune1, size = utf8.DecodeRune(l.src[l.pos:])
			l.pos += size
		}

		nextState := -1
		if rune1 != -1 {
			nextState = TransTab[state](rune1)
		}
		state = nextState

		if state != -1 {

			switch rune1 {
			case '\n':
				l.line++
				l.column = 1
			case '\r':
				l.column = 1
			case '\t':
				l.column += 4
			default:
				l.column++
			}

			switch {
			case ActTab[state].Accept != -1:
				tok.Type = ActTab[state].Accept
				end = l.pos
			case ActTab[state].Ignore != "":
				start, startLine, startColumn = l.pos, l.line, l.column
				state = 0
				if start >= len(l.src) {
					tok.Type = token.EOF
				}

			}
		} else {
			if tok.Type == token.INVALID {
				end = l.pos
			}
		}
	}
	if end > start {
		l.pos = end
		tok.Lit = l.src[start:end]
	} else {
		tok.Lit = []byte{}
	}
	tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = start, startLine, startColumn
	tok.Pos.Context = l.Context

	return
}

func (l *Lexer) Reset() {
	l.pos = 0
}

/*
Lexer symbols:
0: '"'
1: '"'
2: '"'
3: '"'
4: 'i'
5: '0'
6: 'x'
7: '0'
8: 'b'
9: '.'
10: '.'
11: '-'
12: '.'
13: '.'
14: '-'
15: '.'
16: '.'
17: '-'
18: 'M'
19: '_'
20: 'P'
21: 'I'
22: 'M'
23: '_'
24: 'E'
25: 'n'
26: 'u'
27: 'l'
28: 'l'
29: 'I'
30: 'P'
31: 'S'
32: 'I'
33: 'F'
34: 'S'
35: 'I'
36: 'R'
37: 'S'
38: 'O'
39: 'P'
40: 'S'
41: 'O'
42: 'F'
43: 'S'
44: 'O'
45: 'R'
46: 'S'
47: 'F'
48: 'L'
49: 'A'
50: 'T'
51: 'S'
52: 'E'
53: 'P'
54: 'N'
55: 'F'
56: 'N'
57: 'R'
58: 'F'
59: 'N'
60: 'R'
61: 'F'
62: 'I'
63: 'L'
64: 'E'
65: 'N'
66: 'A'
67: 'M'
68: 'E'
69: 'F'
70: 'I'
71: 'L'
72: 'E'
73: 'N'
74: 'U'
75: 'M'
76: 'E'
77: 'N'
78: 'V'
79: 'b'
80: 'e'
81: 'g'
82: 'i'
83: 'n'
84: 'd'
85: 'o'
86: 'e'
87: 'l'
88: 'i'
89: 'f'
90: 'e'
91: 'l'
92: 's'
93: 'e'
94: 'e'
95: 'n'
96: 'd'
97: 'f'
98: 'i'
99: 'l'
100: 't'
101: 'e'
102: 'r'
103: 'f'
104: 'o'
105: 'r'
106: 'i'
107: 'f'
108: 'i'
109: 'n'
110: 'w'
111: 'h'
112: 'i'
113: 'l'
114: 'e'
115: 'b'
116: 'r'
117: 'e'
118: 'a'
119: 'k'
120: 'c'
121: 'o'
122: 'n'
123: 't'
124: 'i'
125: 'n'
126: 'u'
127: 'e'
128: 'r'
129: 'e'
130: 't'
131: 'u'
132: 'r'
133: 'n'
134: 'f'
135: 'u'
136: 'n'
137: 'c'
138: 's'
139: 'u'
140: 'b'
141: 'r'
142: 'c'
143: 'a'
144: 'l'
145: 'l'
146: 'a'
147: 'r'
148: 'r'
149: 'b'
150: 'o'
151: 'o'
152: 'l'
153: 'f'
154: 'l'
155: 'o'
156: 'a'
157: 't'
158: 'i'
159: 'n'
160: 't'
161: 'm'
162: 'a'
163: 'p'
164: 'n'
165: 'u'
166: 'm'
167: 's'
168: 't'
169: 'r'
170: 'v'
171: 'a'
172: 'r'
173: 'f'
174: 'u'
175: 'n'
176: 'c'
177: 't'
178: 'u'
179: 'n'
180: 's'
181: 'e'
182: 't'
183: 'd'
184: 'u'
185: 'm'
186: 'p'
187: 'e'
188: 'd'
189: 'u'
190: 'm'
191: 'p'
192: 'e'
193: 'm'
194: 'i'
195: 't'
196: '1'
197: 'e'
198: 'm'
199: 'i'
200: 't'
201: 'e'
202: 'm'
203: 'i'
204: 't'
205: 'p'
206: 'e'
207: 'm'
208: 'i'
209: 't'
210: 'f'
211: 'e'
212: 'p'
213: 'r'
214: 'i'
215: 'n'
216: 't'
217: 'e'
218: 'p'
219: 'r'
220: 'i'
221: 'n'
222: 't'
223: 'n'
224: 'p'
225: 'r'
226: 'i'
227: 'n'
228: 't'
229: 'p'
230: 'r'
231: 'i'
232: 'n'
233: 't'
234: 'n'
235: 't'
236: 'e'
237: 'e'
238: 's'
239: 't'
240: 'd'
241: 'o'
242: 'u'
243: 't'
244: 's'
245: 't'
246: 'd'
247: 'e'
248: 'r'
249: 'r'
250: '$'
251: '$'
252: '{'
253: '}'
254: '$'
255: '*'
256: '@'
257: '@'
258: '{'
259: '}'
260: '@'
261: '*'
262: 'a'
263: 'l'
264: 'l'
265: '%'
266: '%'
267: '%'
268: 'p'
269: 'a'
270: 'n'
271: 'i'
272: 'c'
273: '%'
274: '%'
275: '%'
276: ';'
277: '{'
278: '}'
279: '='
280: '>'
281: '>'
282: '>'
283: '|'
284: ','
285: '('
286: ')'
287: '$'
288: '['
289: ']'
290: '$'
291: '['
292: '['
293: '$'
294: '['
295: '['
296: '['
297: '@'
298: '['
299: '|'
300: '|'
301: '='
302: '^'
303: '^'
304: '='
305: '&'
306: '&'
307: '='
308: '?'
309: '?'
310: '='
311: '?'
312: '?'
313: '?'
314: '='
315: '|'
316: '='
317: '&'
318: '='
319: '^'
320: '='
321: '<'
322: '<'
323: '='
324: '>'
325: '>'
326: '='
327: '>'
328: '>'
329: '>'
330: '='
331: '+'
332: '='
333: '.'
334: '='
335: '-'
336: '='
337: '*'
338: '='
339: '/'
340: '='
341: '/'
342: '/'
343: '='
344: '%'
345: '='
346: '*'
347: '*'
348: '='
349: '?'
350: ':'
351: '|'
352: '|'
353: '^'
354: '^'
355: '&'
356: '&'
357: '?'
358: '?'
359: '?'
360: '?'
361: '?'
362: '='
363: '~'
364: '!'
365: '='
366: '~'
367: '='
368: '='
369: '!'
370: '='
371: '<'
372: '='
373: '>'
374: '>'
375: '='
376: '<'
377: '<'
378: '='
379: '^'
380: '&'
381: '<'
382: '<'
383: '>'
384: '>'
385: '>'
386: '+'
387: '-'
388: '.'
389: '+'
390: '.'
391: '-'
392: '*'
393: '/'
394: '/'
395: '/'
396: '%'
397: '.'
398: '*'
399: '.'
400: '/'
401: '.'
402: '/'
403: '/'
404: '.'
405: '!'
406: '~'
407: '*'
408: '*'
409: '['
410: '['
411: '['
412: '['
413: '['
414: '['
415: '_'
416: '_'
417: ' '
418: '!'
419: '#'
420: '$'
421: '%'
422: '&'
423: '''
424: '\'
425: '('
426: ')'
427: '*'
428: '+'
429: ','
430: '-'
431: '.'
432: '/'
433: ':'
434: ';'
435: '<'
436: '='
437: '>'
438: '?'
439: '@'
440: '['
441: ']'
442: '^'
443: '_'
444: '`'
445: '{'
446: '|'
447: '}'
448: '~'
449: '\'
450: '\'
451: '\'
452: '"'
453: '\'
454: '['
455: '\'
456: ']'
457: '\'
458: 'b'
459: '\'
460: 'f'
461: '\'
462: 'n'
463: '\'
464: 'r'
465: '\'
466: 't'
467: '\'
468: 'x'
469: '\'
470: '.'
471: '\'
472: '*'
473: '\'
474: '0'
475: '\'
476: '1'
477: '\'
478: '2'
479: '\'
480: '3'
481: '\'
482: '4'
483: '\'
484: '5'
485: '\'
486: '6'
487: '\'
488: '7'
489: '\'
490: '8'
491: '\'
492: '9'
493: 'e'
494: 'E'
495: 't'
496: 'r'
497: 'u'
498: 'e'
499: 'f'
500: 'a'
501: 'l'
502: 's'
503: 'e'
504: ' '
505: '!'
506: '#'
507: '$'
508: '%'
509: '&'
510: '''
511: '\'
512: '('
513: ')'
514: '*'
515: '+'
516: ','
517: '-'
518: '.'
519: '/'
520: ':'
521: ';'
522: '<'
523: '='
524: '>'
525: '?'
526: '@'
527: '['
528: ']'
529: '^'
530: '_'
531: '`'
532: '|'
533: '~'
534: '\'
535: '{'
536: '\'
537: '}'
538: ' '
539: '\t'
540: '\n'
541: '\r'
542: '#'
543: '\n'
544: 'a'-'z'
545: 'A'-'Z'
546: \u0100-\U0010ffff
547: '0'-'9'
548: '0'-'9'
549: 'a'-'f'
550: 'A'-'F'
551: '0'-'1'
552: 'A'-'Z'
553: 'a'-'z'
554: '0'-'9'
555: \u0100-\U0010ffff
556: 'A'-'Z'
557: 'a'-'z'
558: '0'-'9'
559: \u0100-\U0010ffff
560: .
*/
