<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings for media embedding.
 * @package core
 * @subpackage media
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['flashanimation'] = 'Flash animation';
$string['flashanimation_desc'] = 'Files with extension *.swf. For security reasons this format is only embedded within trusted text.';
$string['flashvideo'] = 'Flash video';
$string['flashvideo_desc'] = 'Files with extension *.flv and *.f4v. Plays video clips using Flowplayer, requires Flash plugin and javascript.';
$string['html5audio'] = 'HTML 5 audio';
$string['html5audio_desc'] = 'Audio files with extension *.ogg, *.aac and *.mp3. Used primarily for mobile devices. (Format support depends on browser.)';
$string['html5video'] = 'HTML 5 video';
$string['html5video_desc'] = 'Video files with extension *.webm, *.m4v, *.ogv, *.mp4 and others. Used primarily for mobile devices. (Format support depends on browser.)';
$string['mediaformats'] = 'Available players';
$string['mediaformats_desc'] = 'When players are enabled in these settings, files can be embedded using the media filter (if enabled) or using a File or URL resources with the Embed option. When not enabled, these formats are not embedded and users can manually download or follow links to these resources.

Where two players support the same format, enabling both increases compatibility across different devices such as mobile phones. It is possible to increase compatibility further by providing multiple files in different formats for a single audio or video clip.';
$string['mediasettings'] = 'Media embedding';
$string['mp3audio'] = 'MP3 audio';
$string['mp3audio_desc'] = 'Files with extension *.mp3. Plays audio using Flowplayer, requires Flash plugin.';
$string['legacyquicktime'] = 'QuickTime player';
$string['legacyquicktime_desc'] = 'Files with extension *.mov, *.mp4, *.m4a and *.mpg. Requires QuickTime player or codecs.';
$string['legacyreal'] = 'Real media player';
$string['legacyreal_desc'] = 'Files with extension *.rm, *.ra, *.ram, *.rp and *.rv. Requires RealPlayer.';
$string['legacywmp'] = 'Windows media player';
$string['legacywmp_desc'] = 'Files with extension *.avi and *.wmv. Fully compatible with Internet Explorer in Windows; may not work in other browsers or operating systems.';
$string['legacyheading'] = 'Legacy media players';
$string['legacyheading_desc'] = 'These players are not frequently used on the Web and require browser plugins that are less widely installed.';
$string['sitevimeo'] = 'Vimeo';
$string['sitevimeo_desc'] = 'Vimeo video sharing site.';
$string['siteyoutube'] = 'YouTube';
$string['siteyoutube_desc'] = 'YouTube video sharing site, video and playlist links supported.';
