/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

#ifndef BADDIMS_H_INCLUDED
#define BADDIMS_H_INCLUDED

/* *INDENT-OFF* */
DimsTestVal_t tests[] = {
    { 72, 2, { 9, 8 } },
    { 180, 2, { 15, 12 } },
    { 240, 2, { 16, 15 } },
    { 288, 2, { 18, 16 } },
    { 336, 2, { 21, 16 } },
    { 420, 2, { 21, 20 } },
    { 450, 2, { 25, 18 } },
    { 504, 2, { 24, 21 } },
    { 540, 2, { 27, 20 } },
    { 600, 2, { 25, 24 } },
    { 648, 2, { 27, 24 } },
    { 675, 2, { 27, 25 } },
    { 720, 2, { 30, 24 } },
    { 756, 2, { 28, 27 } },
    { 792, 2, { 33, 24 } },
    { 800, 2, { 32, 25 } },
    { 864, 2, { 32, 27 } },
    { 924, 2, { 33, 28 } },
    { 945, 2, { 35, 27 } },
    { 960, 2, { 32, 30 } },
    { 1050, 2, { 35, 30 } },
    { 1056, 2, { 33, 32 } },
    { 1092, 2, { 39, 28 } },
    { 1120, 2, { 35, 32 } },
    { 1152, 2, { 36, 32 } },
    { 1188, 2, { 36, 33 } },
    { 1248, 2, { 39, 32 } },
    { 1260, 2, { 36, 35 } },
    { 1320, 2, { 40, 33 } },
    { 1323, 2, { 49, 27 } },
    { 1344, 2, { 42, 32 } },
    { 1400, 2, { 40, 35 } },
    { 1404, 2, { 39, 36 } },
    { 1560, 2, { 40, 39 } },
    { 1568, 2, { 49, 32 } },
    { 1575, 2, { 45, 35 } },
    { 1620, 2, { 45, 36 } },
    { 1680, 2, { 42, 40 } },
    { 1716, 2, { 44, 39 } },
    { 1800, 2, { 45, 40 } },
    { 1836, 2, { 51, 36 } },
    { 1872, 2, { 48, 39 } },
    { 1960, 2, { 49, 40 } },
    { 1980, 2, { 45, 44 } },
    { 2016, 2, { 48, 42 } },
    { 2040, 2, { 51, 40 } },
    { 2160, 2, { 48, 45 } },
    { 2205, 2, { 49, 45 } },
    { 2244, 2, { 51, 44 } },
    { 2280, 2, { 57, 40 } },
    { 2310, 2, { 55, 42 } },
    { 2340, 2, { 52, 45 } },
    { 2352, 2, { 49, 48 } },
    { 2400, 2, { 50, 48 } },
    { 2448, 2, { 51, 48 } },
    { 2450, 2, { 50, 49 } },
    { 2475, 2, { 55, 45 } },
    { 2508, 2, { 57, 44 } },
    { 2520, 2, { 56, 45 } },
    { 2592, 2, { 54, 48 } },
    { 2640, 2, { 55, 48 } },
    { 2646, 2, { 54, 49 } },
    { 2652, 2, { 52, 51 } },
    { 2700, 2, { 54, 50 } },
    { 2730, 2, { 65, 42 } },
    { 2736, 2, { 57, 48 } },
    { 2772, 2, { 63, 44 } },
    { 2856, 2, { 56, 51 } },
    { 2880, 2, { 60, 48 } },
    { 2925, 2, { 65, 45 } },
    { 2940, 2, { 60, 49 } },
    { 2964, 2, { 57, 52 } },
    { 2970, 2, { 55, 54 } },
    { 3024, 2, { 56, 54 } },
    { 3060, 2, { 60, 51 } },
    { 3080, 2, { 56, 55 } },
    { 3168, 2, { 66, 48 } },
    { 3192, 2, { 57, 56 } },
    { 3200, 2, { 64, 50 } },
    { 3264, 2, { 64, 51 } },
    { 3276, 2, { 63, 52 } },
    { 3300, 2, { 60, 55 } },
    { 3312, 2, { 69, 48 } },
    { 3420, 2, { 60, 57 } },
    { 3456, 2, { 64, 54 } },
    { 3465, 2, { 63, 55 } },
    { 3510, 2, { 65, 54 } },
    { 3520, 2, { 64, 55 } },
    { 3528, 2, { 63, 56 } },
    { 3588, 2, { 69, 52 } },
    { 3640, 2, { 65, 56 } },
    { 3648, 2, { 64, 57 } },
    { 3675, 2, { 75, 49 } },
    { 3696, 2, { 66, 56 } },
    { 3780, 2, { 63, 60 } },
    { 3840, 2, { 64, 60 } },
    { 3864, 2, { 69, 56 } },
    { 3876, 2, { 68, 57 } },
    { 3900, 2, { 65, 60 } },
    { 4032, 2, { 64, 63 } },
    { 4050, 2, { 75, 54 } },
    { 4095, 2, { 65, 63 } },
    { 4104, 2, { 72, 57 } },
    { 4140, 2, { 69, 60 } },
    { 4160, 2, { 65, 64 } },
    { 4200, 2, { 70, 60 } },
    { 4224, 2, { 66, 64 } },
    { 4284, 2, { 68, 63 } },
    { 4290, 2, { 66, 65 } },
    { 4312, 2, { 77, 56 } },
    { 4368, 2, { 78, 56 } },
    { 4400, 2, { 80, 55 } },
    { 4416, 2, { 69, 64 } },
    { 4455, 2, { 81, 55 } },
    { 4480, 2, { 70, 64 } },
    { 4500, 2, { 75, 60 } },
    { 4536, 2, { 72, 63 } },
    { 4590, 2, { 85, 54 } },
    { 4608, 2, { 72, 64 } },
    { 4680, 2, { 72, 65 } },
    { 4692, 2, { 69, 68 } },
    { 4752, 2, { 72, 66 } },
    { 4788, 2, { 76, 63 } },
    { 4800, 2, { 75, 64 } },
    { 4851, 2, { 77, 63 } },
    { 4860, 2, { 81, 60 } },
    { 4928, 2, { 77, 64 } },
    { 4968, 2, { 72, 69 } },
    { 4992, 2, { 78, 64 } },
    { 5040, 2, { 72, 70 } },
    { 5096, 2, { 91, 56 } },
    { 5100, 2, { 75, 68 } },
    { 5200, 2, { 80, 65 } },
    { 5220, 2, { 87, 60 } },
    { 5244, 2, { 76, 69 } },
    { 5265, 2, { 81, 65 } },
    { 5280, 2, { 80, 66 } },
    { 5355, 2, { 85, 63 } },
    { 5376, 2, { 84, 64 } },
    { 5390, 2, { 77, 70 } },
    { 5400, 2, { 75, 72 } },
    { 5508, 2, { 81, 68 } },
    { 5520, 2, { 80, 69 } },
    { 5544, 2, { 77, 72 } },
    { 5568, 2, { 87, 64 } },
    { 5600, 2, { 80, 70 } },
    { 5610, 2, { 85, 66 } },
    { 5616, 2, { 78, 72 } },
    { 5670, 2, { 81, 70 } },
    { 5700, 2, { 76, 75 } },
    { 5720, 2, { 88, 65 } },
    { 5733, 2, { 91, 63 } },
    { 5775, 2, { 77, 75 } },
    { 5796, 2, { 84, 69 } },
    { 5824, 2, { 91, 64 } },
    { 5832, 2, { 81, 72 } },
    { 5916, 2, { 87, 68 } },
    { 5952, 2, { 93, 64 } },
    { 5985, 2, { 95, 63 } },
    { 6000, 2, { 80, 75 } },
    { 6072, 2, { 88, 69 } },
    { 6075, 2, { 81, 75 } },
    { 6120, 2, { 85, 72 } },
    { 6125, 2, { 125, 49 } },
    { 6156, 2, { 81, 76 } },
    { 6160, 2, { 80, 77 } },
    { 6237, 2, { 81, 77 } },
    { 6240, 2, { 80, 78 } },
    { 6264, 2, { 87, 72 } },
    { 6270, 2, { 95, 66 } },
    { 6272, 2, { 98, 64 } },
    { 6300, 2, { 84, 75 } },
    { 6324, 2, { 93, 68 } },
    { 6370, 2, { 91, 70 } },
    { 6435, 2, { 99, 65 } },
    { 6468, 2, { 84, 77 } },
    { 6480, 2, { 81, 80 } },
    { 6600, 2, { 88, 75 } },
    { 6612, 2, { 87, 76 } },
    { 6630, 2, { 85, 78 } },
    { 6696, 2, { 93, 72 } },
    { 6720, 2, { 84, 80 } },
    { 6732, 2, { 99, 68 } },
    { 6800, 2, { 85, 80 } },
    { 6804, 2, { 84, 81 } },
    { 6825, 2, { 91, 75 } },
    { 6864, 2, { 88, 78 } },
    { 6885, 2, { 85, 81 } },
    { 6900, 2, { 92, 75 } },
    { 6930, 2, { 90, 77 } },
    { 6960, 2, { 87, 80 } },
    { 7068, 2, { 93, 76 } },
    { 7128, 2, { 88, 81 } },
    { 7140, 2, { 85, 84 } },
    { 7200, 2, { 90, 80 } },
    { 7280, 2, { 91, 80 } },
    { 7308, 2, { 87, 84 } },
    { 7344, 2, { 102, 72 } },
    { 7350, 2, { 98, 75 } },
    { 7371, 2, { 91, 81 } },
    { 7410, 2, { 95, 78 } },
    { 7440, 2, { 93, 80 } },
    { 7452, 2, { 92, 81 } },
    { 7480, 2, { 88, 85 } },
    { 7488, 2, { 96, 78 } },
    { 7497, 2, { 119, 63 } },
    { 7524, 2, { 99, 76 } },
    { 7600, 2, { 95, 80 } },
    { 7644, 2, { 91, 84 } },
    { 7650, 2, { 90, 85 } },
    { 7656, 2, { 88, 87 } },
    { 7695, 2, { 95, 81 } },
    { 7700, 2, { 100, 77 } },
    { 7776, 2, { 96, 81 } },
    { 7812, 2, { 93, 84 } },
    { 7840, 2, { 98, 80 } },
    { 7920, 2, { 90, 88 } },
    { 7938, 2, { 98, 81 } },
    { 7980, 2, { 95, 84 } },
    { 8004, 2, { 92, 87 } },
    { 8008, 2, { 91, 88 } },
    { 8064, 2, { 96, 84 } },
    { 8085, 2, { 105, 77 } },
    { 8160, 2, { 96, 85 } },
    { 8184, 2, { 93, 88 } },
    { 8190, 2, { 91, 90 } },
    { 8316, 2, { 99, 84 } },
    { 8352, 2, { 96, 87 } },
    { 8360, 2, { 95, 88 } },
    { 8379, 2, { 133, 63 } },
    { 8415, 2, { 99, 85 } },
    { 8424, 2, { 104, 81 } },
    { 8436, 2, { 111, 76 } },
    { 8505, 2, { 105, 81 } },
    { 8550, 2, { 95, 90 } },
    { 8556, 2, { 93, 92 } },
    { 8640, 2, { 96, 90 } },
    { 8700, 2, { 100, 87 } },
    { 8712, 2, { 99, 88 } },
    { 8736, 2, { 96, 91 } },
    { 8820, 2, { 98, 90 } },
    { 8840, 2, { 104, 85 } },
    { 8880, 2, { 111, 80 } },
    { 8928, 2, { 96, 93 } },
    { 8970, 2, { 115, 78 } },
    { 8976, 2, { 102, 88 } },
    { 9009, 2, { 99, 91 } },
    { 9048, 2, { 104, 87 } },
    { 9075, 2, { 121, 75 } },
    { 9100, 2, { 100, 91 } },
    { 9108, 2, { 99, 92 } },
    { 9120, 2, { 96, 95 } },
    { 9240, 2, { 105, 88 } },
    { 9300, 2, { 100, 93 } },
    { 9315, 2, { 115, 81 } },
    { 9324, 2, { 111, 84 } },
    { 9360, 2, { 104, 90 } },
    { 9396, 2, { 108, 87 } },
    { 9405, 2, { 99, 95 } },
    { 9408, 2, { 98, 96 } },
    { 9450, 2, { 105, 90 } },
    { 9504, 2, { 99, 96 } },
    { 9520, 2, { 112, 85 } },
    { 9555, 2, { 105, 91 } },
    { 9600, 2, { 100, 96 } },
    { 9625, 2, { 125, 77 } },
    { 9639, 2, { 119, 81 } },
    { 9660, 2, { 105, 92 } },
    { 9672, 2, { 104, 93 } },
    { 9690, 2, { 102, 95 } },
    { 9744, 2, { 112, 87 } },
    { 9750, 2, { 125, 78 } },
    { 9768, 2, { 111, 88 } },
    { 9792, 2, { 102, 96 } },
    { 9800, 2, { 100, 98 } },
    { 9828, 2, { 108, 91 } },
    { 9880, 2, { 104, 95 } },
    { 9900, 2, { 100, 99 } },
    { 9945, 2, { 117, 85 } },
    { 10010, 2, { 110, 91 } },
    { 10032, 2, { 114, 88 } },
    { 10044, 2, { 108, 93 } },
    { 10080, 2, { 105, 96 } },
    { 10125, 2, { 125, 81 } },
    { 10164, 2, { 121, 84 } },
    { 10212, 2, { 111, 92 } },
    { 10260, 2, { 108, 95 } },
    { 10296, 2, { 104, 99 } },
    { 10332, 2, { 123, 84 } },
    { 10350, 2, { 115, 90 } },
    { 10368, 2, { 108, 96 } },
    { 10416, 2, { 112, 93 } },
    { 10472, 2, { 119, 88 } },
    { 10500, 2, { 105, 100 } },
    { 10560, 2, { 110, 96 } },
    { 10584, 2, { 108, 98 } },
    { 10608, 2, { 104, 102 } },
    { 10640, 2, { 112, 95 } },
    { 10656, 2, { 111, 96 } },
    { 10692, 2, { 108, 99 } },
    { 10725, 2, { 143, 75 } },
    { 10764, 2, { 117, 92 } },
    { 10773, 2, { 133, 81 } },
    { 10788, 2, { 116, 93 } },
    { 10800, 2, { 108, 100 } },
    { 10824, 2, { 123, 88 } },
    { 10880, 2, { 128, 85 } },
    { 10920, 2, { 105, 104 } },
    { 10944, 2, { 114, 96 } },
    { 11040, 2, { 115, 96 } },
    { 11088, 2, { 112, 99 } },
    { 11100, 2, { 111, 100 } },
    { 11115, 2, { 117, 95 } },
    { 11160, 2, { 120, 93 } },
    { 11250, 2, { 125, 90 } },
    { 11316, 2, { 123, 92 } },
    { 11340, 2, { 108, 105 } },
    { 11352, 2, { 129, 88 } },
    { 11375, 2, { 125, 91 } },
    { 11385, 2, { 115, 99 } },
    { 11424, 2, { 112, 102 } },
    { 11475, 2, { 135, 85 } },
    { 11484, 2, { 116, 99 } },
    { 11520, 2, { 120, 96 } },
    { 11544, 2, { 111, 104 } },
    { 11616, 2, { 121, 96 } },
    { 11700, 2, { 117, 100 } },
    { 11704, 2, { 133, 88 } },
    { 11730, 2, { 115, 102 } },
    { 11760, 2, { 112, 105 } },
    { 11781, 2, { 119, 99 } },
    { 11808, 2, { 123, 96 } },
    { 11856, 2, { 114, 104 } },
    { 11858, 2, { 121, 98 } },
    { 11868, 2, { 129, 92 } },
    { 11880, 2, { 110, 108 } },
    { 11900, 2, { 119, 100 } },
    { 11907, 2, { 147, 81 } },
    { 11960, 2, { 115, 104 } },
    { 11988, 2, { 111, 108 } },
    { 12012, 2, { 132, 91 } },
    { 12096, 2, { 112, 108 } },
    { 12160, 2, { 128, 95 } },
    { 12168, 2, { 117, 104 } },
    { 12180, 2, { 116, 105 } },
    { 12240, 2, { 120, 102 } },
    { 12250, 2, { 125, 98 } },
    { 12276, 2, { 124, 99 } },
    { 12300, 2, { 123, 100 } },
    { 12320, 2, { 112, 110 } },
    { 12375, 2, { 125, 99 } },
    { 12376, 2, { 119, 104 } },
    { 12384, 2, { 129, 96 } },
    { 12420, 2, { 115, 108 } },
    { 12432, 2, { 112, 111 } },
    { 12495, 2, { 119, 105 } },
    { 12600, 2, { 120, 105 } },
    { 12636, 2, { 117, 108 } },
    { 12672, 2, { 128, 99 } },
    { 12675, 2, { 169, 75 } },
    { 12705, 2, { 121, 105 } },
    { 12750, 2, { 125, 102 } },
    { 12768, 2, { 114, 112 } },
    { 12792, 2, { 123, 104 } },
    { 12800, 2, { 128, 100 } },
    { 12825, 2, { 135, 95 } },
    { 12852, 2, { 119, 108 } },
    { 12876, 2, { 116, 111 } },
    { 12880, 2, { 115, 112 } },
    { 12900, 2, { 129, 100 } },
    { 12920, 2, { 136, 95 } },
    { 13000, 2, { 125, 104 } },
    { 13020, 2, { 124, 105 } },
    { 13041, 2, { 161, 81 } },
    { 13050, 2, { 145, 90 } },
    { 13056, 2, { 128, 102 } },
    { 13068, 2, { 121, 108 } },
    { 13090, 2, { 119, 110 } },
    { 13104, 2, { 117, 112 } },
    { 13110, 2, { 115, 114 } },
    { 13167, 2, { 133, 99 } },
    { 13200, 2, { 120, 110 } },
    { 13248, 2, { 138, 96 } },
    { 13284, 2, { 123, 108 } },
    { 13300, 2, { 133, 100 } },
    { 13320, 2, { 120, 111 } },
    { 13328, 2, { 119, 112 } },
    { 13416, 2, { 129, 104 } },
    { 13455, 2, { 117, 115 } },
    { 13475, 2, { 175, 77 } },
    { 13500, 2, { 125, 108 } },
    { 13536, 2, { 141, 96 } },
    { 13552, 2, { 121, 112 } },
    { 13572, 2, { 117, 116 } },
    { 13680, 2, { 120, 114 } },
    { 13764, 2, { 124, 111 } },
    { 13776, 2, { 123, 112 } },
    { 13800, 2, { 120, 115 } },
    { 13824, 2, { 128, 108 } },
    { 13832, 2, { 133, 104 } },
    { 13860, 2, { 126, 110 } },
    { 13923, 2, { 119, 117 } },
    { 13932, 2, { 129, 108 } },
    { 13965, 2, { 133, 105 } },
    { 14000, 2, { 125, 112 } },
    { 14014, 2, { 143, 98 } },
    { 14040, 2, { 120, 117 } },
    { 14080, 2, { 128, 110 } },
    { 14100, 2, { 141, 100 } },
    { 14112, 2, { 126, 112 } },
    { 14175, 2, { 135, 105 } },
    { 14208, 2, { 128, 111 } },
    { 14250, 2, { 125, 114 } },
    { 14268, 2, { 123, 116 } },
    { 14280, 2, { 120, 119 } },
    { 14352, 2, { 138, 104 } },
    { 14355, 2, { 145, 99 } },
    { 14448, 2, { 129, 112 } },
    { 14490, 2, { 126, 115 } },
    { 14508, 2, { 124, 117 } },
    { 14520, 2, { 121, 120 } },
    { 14535, 2, { 153, 95 } },
    { 14560, 2, { 130, 112 } },
    { 14580, 2, { 135, 108 } },
    { 14592, 2, { 128, 114 } },
    { 14625, 2, { 125, 117 } },
    { 14630, 2, { 133, 110 } },
    { 14652, 2, { 132, 111 } },
    { 14664, 2, { 141, 104 } },
    { 14720, 2, { 128, 115 } },
    { 14760, 2, { 123, 120 } },
    { 14784, 2, { 132, 112 } },
    { 14790, 2, { 145, 102 } },
    { 14850, 2, { 135, 110 } },
    { 14875, 2, { 125, 119 } },
    { 14896, 2, { 133, 112 } },
    { 14964, 2, { 129, 116 } },
    { 14976, 2, { 128, 117 } },
    { 14994, 2, { 126, 119 } },
    { 15000, 2, { 125, 120 } },
    { 15015, 2, { 143, 105 } },
    { 15096, 2, { 136, 111 } },
    { 15120, 2, { 126, 120 } },
    { 15125, 2, { 125, 121 } },
    { 15180, 2, { 132, 115 } },
    { 15228, 2, { 141, 108 } },
    { 15232, 2, { 128, 119 } },
    { 15246, 2, { 126, 121 } },
    { 15252, 2, { 124, 123 } },
    { 15288, 2, { 147, 104 } },
    { 15345, 2, { 155, 99 } },
    { 15360, 2, { 128, 120 } },
    { 15444, 2, { 132, 117 } },
    { 15456, 2, { 138, 112 } },
    { 15470, 2, { 130, 119 } },
    { 15480, 2, { 129, 120 } },
    { 15488, 2, { 128, 121 } },
    { 15504, 2, { 136, 114 } },
    { 15525, 2, { 135, 115 } },
    { 15540, 2, { 140, 111 } },
    { 15561, 2, { 133, 117 } },
    { 15600, 2, { 130, 120 } },
    { 15640, 2, { 136, 115 } },
    { 15660, 2, { 135, 116 } },
    { 15708, 2, { 132, 119 } },
    { 15744, 2, { 128, 123 } },
    { 15750, 2, { 126, 125 } },
    { 15792, 2, { 141, 112 } },
    { 15810, 2, { 155, 102 } },
    { 15912, 2, { 136, 117 } },
    { 15925, 2, { 175, 91 } },
    { 15939, 2, { 161, 99 } },
    { 15960, 2, { 133, 120 } },
    { 15984, 2, { 144, 111 } },
    { 15996, 2, { 129, 124 } },
    { 16000, 2, { 128, 125 } },
    { 16016, 2, { 143, 112 } },
    { 16065, 2, { 135, 119 } },
    { 16128, 2, { 128, 126 } },
    { 16200, 2, { 135, 120 } },
    { 16236, 2, { 132, 123 } },
    { 16335, 2, { 135, 121 } },
    { 16356, 2, { 141, 116 } },
    { 16380, 2, { 130, 126 } },
    { 16416, 2, { 144, 114 } },
    { 16464, 2, { 147, 112 } },
    { 16500, 2, { 132, 125 } },
    { 16512, 2, { 129, 128 } },
    { 16524, 2, { 153, 108 } },
    { 16530, 2, { 145, 114 } },
    { 16560, 2, { 138, 120 } },
    { 16562, 2, { 169, 98 } },
    { 16625, 2, { 133, 125 } },
    { 16640, 2, { 130, 128 } },
    { 16660, 2, { 140, 119 } },
    { 16728, 2, { 136, 123 } },
    { 16740, 2, { 135, 124 } },
    { 16744, 2, { 161, 104 } },
    { 16758, 2, { 133, 126 } },
    { 16800, 2, { 140, 120 } },
    { 16848, 2, { 144, 117 } },
    { 16875, 2, { 135, 125 } },
    { 16896, 2, { 132, 128 } },
    { 16920, 2, { 141, 120 } },
    { 16940, 2, { 140, 121 } },
    { 16965, 2, { 145, 117 } },
    { 17000, 2, { 136, 125 } },
    { 17024, 2, { 133, 128 } },
    { 17028, 2, { 132, 129 } },
    { 17052, 2, { 147, 116 } },
    { 17136, 2, { 136, 126 } },
    { 17160, 2, { 132, 130 } },
    { 17172, 2, { 159, 108 } },
    { 17220, 2, { 140, 123 } },
    { 17248, 2, { 154, 112 } },
    { 17250, 2, { 138, 125 } },
    { 17280, 2, { 135, 128 } },
    { 17290, 2, { 133, 130 } },
    { 17316, 2, { 148, 117 } },
    { 17400, 2, { 145, 120 } },
    { 17472, 2, { 156, 112 } },
    { 17480, 2, { 152, 115 } },
    { 17484, 2, { 141, 124 } },
    { 17544, 2, { 136, 129 } },
    { 17550, 2, { 135, 130 } },
    { 17556, 2, { 133, 132 } },
    { 17595, 2, { 153, 115 } },
    { 17600, 2, { 160, 110 } },
    { 17664, 2, { 138, 128 } },
    { 17670, 2, { 155, 114 } },
    { 17712, 2, { 144, 123 } },
    { 17745, 2, { 169, 105 } },
    { 17748, 2, { 153, 116 } },
    { 17784, 2, { 152, 117 } },
    { 17787, 2, { 147, 121 } },
    { 17808, 2, { 159, 112 } },
    { 17820, 2, { 135, 132 } },
    { 17850, 2, { 150, 119 } },
    { 17875, 2, { 143, 125 } },
    { 17920, 2, { 140, 128 } },
    { 17955, 2, { 135, 133 } },
    { 18000, 2, { 144, 125 } },
    { 18018, 2, { 143, 126 } },
    { 18032, 2, { 161, 112 } },
    { 18048, 2, { 141, 128 } },
    { 18060, 2, { 140, 129 } },
    { 18088, 2, { 136, 133 } },
    { 18135, 2, { 155, 117 } },
    { 18144, 2, { 144, 126 } },
    { 18150, 2, { 150, 121 } },
    { 18204, 2, { 148, 123 } },
    { 18228, 2, { 147, 124 } },
    { 18270, 2, { 145, 126 } },
    { 18304, 2, { 143, 128 } },
    { 18360, 2, { 136, 135 } },
    { 18375, 2, { 147, 125 } },
    { 18400, 2, { 160, 115 } },
    { 18432, 2, { 144, 128 } },
    { 18444, 2, { 159, 116 } },
    { 18560, 2, { 145, 128 } },
    { 18564, 2, { 156, 119 } },
    { 18576, 2, { 144, 129 } },
    { 18612, 2, { 141, 132 } },
    { 18620, 2, { 140, 133 } },
    { 18696, 2, { 152, 123 } },
    { 18720, 2, { 144, 130 } },
    { 18768, 2, { 138, 136 } },
    { 18816, 2, { 147, 128 } },
    { 18837, 2, { 161, 117 } },
    { 18876, 2, { 143, 132 } },
    { 18900, 2, { 140, 135 } },
    { 18928, 2, { 169, 112 } },
    { 18972, 2, { 153, 124 } },
    { 19000, 2, { 152, 125 } },
    { 19008, 2, { 144, 132 } },
    { 19080, 2, { 159, 120 } },
    { 19092, 2, { 148, 129 } },
    { 19125, 2, { 153, 125 } },
    { 19140, 2, { 145, 132 } },
    { 19152, 2, { 144, 133 } },
    { 19176, 2, { 141, 136 } },
    { 19188, 2, { 156, 123 } },
    { 19200, 2, { 150, 128 } },
    { 19250, 2, { 154, 125 } },
    { 19305, 2, { 143, 135 } },
    { 19360, 2, { 160, 121 } },
    { 19404, 2, { 147, 132 } },
    { 19440, 2, { 144, 135 } },
    { 19530, 2, { 155, 126 } },
    { 19575, 2, { 145, 135 } },
    { 19602, 2, { 162, 121 } },
    { 19608, 2, { 152, 129 } },
    { 19635, 2, { 165, 119 } },
    { 19665, 2, { 171, 115 } },
    { 19680, 2, { 160, 123 } },
    { 19712, 2, { 154, 128 } },
    { 19716, 2, { 159, 124 } },
    { 19720, 2, { 145, 136 } },
    { 19740, 2, { 141, 140 } },
    { 19836, 2, { 171, 116 } },
    { 19840, 2, { 155, 128 } },
    { 19845, 2, { 147, 135 } },
    { 19872, 2, { 144, 138 } },
    { 19950, 2, { 150, 133 } },
    { 19968, 2, { 156, 128 } },
    { 19980, 2, { 148, 135 } },
    { 19992, 2, { 147, 136 } },
    { 20000, 2, { 160, 125 } },
    { 20010, 2, { 145, 138 } },
    { 20020, 2, { 143, 140 } },
    { 20097, 2, { 203, 99 } },
    { 20124, 2, { 156, 129 } },
    { 20125, 2, { 161, 125 } },
    { 20160, 2, { 144, 140 } },
    { 20196, 2, { 153, 132 } },
    { 20240, 2, { 176, 115 } },
    { 20304, 2, { 144, 141 } },
    { 20349, 2, { 153, 133 } },
    { 20352, 2, { 159, 128 } },
    { 20384, 2, { 182, 112 } },
    { 20400, 2, { 150, 136 } },
    { 20460, 2, { 155, 132 } },
    { 20475, 2, { 175, 117 } },
    { 20520, 2, { 152, 135 } },
    { 20580, 2, { 147, 140 } },
    { 20592, 2, { 144, 143 } },
    { 20608, 2, { 161, 128 } },
    { 20640, 2, { 160, 129 } },
    { 20748, 2, { 156, 133 } },
    { 20790, 2, { 154, 135 } },
    { 20800, 2, { 160, 130 } },
    { 20808, 2, { 153, 136 } },
    { 20825, 2, { 175, 119 } },
    { 20868, 2, { 148, 141 } },
    { 20880, 2, { 145, 144 } },
    { 20925, 2, { 155, 135 } },
    { 20930, 2, { 161, 130 } },
    { 20976, 2, { 152, 138 } },
    { 20988, 2, { 159, 132 } },
    { 21021, 2, { 147, 143 } },
    { 21060, 2, { 156, 135 } },
    { 21080, 2, { 155, 136 } },
    { 21090, 2, { 185, 114 } },
    { 21120, 2, { 160, 132 } },
    { 21125, 2, { 169, 125 } },
    { 21156, 2, { 164, 129 } },
    { 21168, 2, { 147, 144 } },
    { 21175, 2, { 175, 121 } },
    { 21204, 2, { 171, 124 } },
    { 21240, 2, { 177, 120 } },
    { 21294, 2, { 169, 126 } },
    { 21375, 2, { 171, 125 } },
    { 21390, 2, { 155, 138 } },
    { 21420, 2, { 153, 140 } },
    { 21432, 2, { 152, 141 } },
    { 21450, 2, { 150, 143 } },
    { 21483, 2, { 217, 99 } },
    { 21504, 2, { 168, 128 } },
    { 21546, 2, { 162, 133 } },
    { 21560, 2, { 154, 140 } },
    { 21600, 2, { 150, 144 } },
    { 21624, 2, { 159, 136 } },
    { 21632, 2, { 169, 128 } },
    { 21645, 2, { 185, 117 } },
    { 21672, 2, { 168, 129 } },
    { 21735, 2, { 161, 135 } },
    { 21750, 2, { 150, 145 } },
    { 21756, 2, { 148, 147 } },
    { 21780, 2, { 165, 132 } },
    { 21896, 2, { 161, 136 } },
    { 21945, 2, { 165, 133 } },
    { 21948, 2, { 177, 124 } },
    { 21996, 2, { 156, 141 } },
    { 22000, 2, { 176, 125 } },
    { 22022, 2, { 154, 143 } },
    { 22032, 2, { 153, 144 } },
    { 22040, 2, { 152, 145 } },
    { 22050, 2, { 150, 147 } },
    { 22080, 2, { 160, 138 } },
    { 22140, 2, { 164, 135 } },
    { 22176, 2, { 154, 144 } },
    { 22185, 2, { 153, 145 } },
    { 22260, 2, { 159, 140 } },
    { 22272, 2, { 174, 128 } },
    { 22275, 2, { 165, 135 } },
    { 22320, 2, { 155, 144 } },
    { 22344, 2, { 152, 147 } },
    { 22400, 2, { 160, 140 } },
    { 22440, 2, { 165, 136 } },
    { 22464, 2, { 156, 144 } },
    { 22540, 2, { 161, 140 } },
    { 22560, 2, { 160, 141 } },
    { 22572, 2, { 171, 132 } },
    { 22610, 2, { 170, 133 } },
    { 22620, 2, { 156, 145 } },
    { 22644, 2, { 153, 148 } },
    { 22656, 2, { 177, 128 } },
    { 22680, 2, { 162, 140 } },
    { 22692, 2, { 183, 124 } },
    { 22800, 2, { 152, 150 } },
    { 22815, 2, { 169, 135 } },
    { 22869, 2, { 189, 121 } },
    { 22880, 2, { 160, 143 } },
    { 22896, 2, { 159, 144 } },
    { 22932, 2, { 156, 147 } },
    { 23000, 2, { 184, 125 } },
    { 23100, 2, { 154, 150 } },
    { 23124, 2, { 164, 141 } },
    { 23166, 2, { 162, 143 } },
    { 23184, 2, { 161, 144 } },
    { 23200, 2, { 160, 145 } },
    { 23205, 2, { 195, 119 } },
    { 23220, 2, { 172, 135 } },
    { 23250, 2, { 155, 150 } },
    { 23256, 2, { 153, 152 } },
    { 23275, 2, { 175, 133 } },
    { 23296, 2, { 182, 128 } },
    { 23310, 2, { 185, 126 } },
    { 23328, 2, { 162, 144 } },
    { 23364, 2, { 177, 132 } },
    { 23375, 2, { 187, 125 } },
    { 23424, 2, { 183, 128 } },
    { 23490, 2, { 162, 145 } },
    { 23520, 2, { 160, 147 } },
    { 23532, 2, { 159, 148 } },
    { 23560, 2, { 155, 152 } },
    { 23595, 2, { 165, 143 } },
    { 23625, 2, { 175, 135 } },
    { 23660, 2, { 169, 140 } },
    { 23664, 2, { 174, 136 } },
    { 23688, 2, { 168, 141 } },
    { 23715, 2, { 155, 153 } },
    { 23751, 2, { 203, 117 } },
    { 23760, 2, { 165, 144 } },
    { 23808, 2, { 186, 128 } },
    { 23814, 2, { 162, 147 } },
    { 23868, 2, { 156, 153 } },
    { 23940, 2, { 171, 140 } },
    { 24000, 2, { 160, 150 } },
    { 24072, 2, { 177, 136 } },
    { 24108, 2, { 164, 147 } },
    { 24150, 2, { 161, 150 } },
    { 24156, 2, { 183, 132 } },
    { 24168, 2, { 159, 152 } },
    { 24180, 2, { 156, 155 } },
    { 24200, 2, { 200, 121 } },
    { 24252, 2, { 172, 141 } },
    { 24288, 2, { 176, 138 } },
    { 24300, 2, { 162, 150 } },
    { 24360, 2, { 168, 145 } },
    { 24420, 2, { 165, 148 } },
    { 24472, 2, { 161, 152 } },
    { 24480, 2, { 160, 153 } },
    { 24570, 2, { 182, 135 } },
    { 24624, 2, { 162, 152 } },
    { 24633, 2, { 161, 153 } },
    { 24640, 2, { 160, 154 } },
    { 24684, 2, { 187, 132 } },
    { 24696, 2, { 168, 147 } },
    { 24780, 2, { 177, 140 } },
    { 24795, 2, { 171, 145 } },
    { 24800, 2, { 160, 155 } },
    { 24804, 2, { 159, 156 } },
    { 24816, 2, { 176, 141 } },
    { 24843, 2, { 169, 147 } },
    { 24888, 2, { 183, 136 } },
    { 24948, 2, { 162, 154 } },
    { 24960, 2, { 160, 156 } },
    { 24975, 2, { 185, 135 } },
    { 25025, 2, { 175, 143 } },
    { 25056, 2, { 174, 144 } },
    { 25080, 2, { 165, 152 } },
    { 25088, 2, { 196, 128 } },
    { 25092, 2, { 164, 153 } },
    { 25110, 2, { 162, 155 } },
    { 25116, 2, { 161, 156 } },
    { 25168, 2, { 176, 143 } },
    { 25200, 2, { 168, 150 } },
    { 25284, 2, { 172, 147 } },
    { 25296, 2, { 186, 136 } },
    { 25308, 2, { 171, 148 } },
    { 25350, 2, { 169, 150 } },
    { 25380, 2, { 180, 141 } },
    { 25389, 2, { 217, 117 } },
    { 25440, 2, { 160, 159 } },
    { 25480, 2, { 182, 140 } },
    { 25488, 2, { 177, 144 } },
    { 25520, 2, { 176, 145 } },
    { 25530, 2, { 185, 138 } },
    { 25620, 2, { 183, 140 } },
    { 25704, 2, { 168, 153 } },
    { 25740, 2, { 165, 156 } },
    { 25760, 2, { 161, 160 } },
    { 25830, 2, { 205, 126 } },
    { 25872, 2, { 168, 154 } },
    { 25875, 2, { 207, 125 } },
    { 25920, 2, { 162, 160 } },
    { 25935, 2, { 195, 133 } },
    { 25944, 2, { 184, 141 } },
    { 25984, 2, { 203, 128 } },
    { 25992, 2, { 171, 152 } },
    { 26026, 2, { 169, 154 } },
    { 26040, 2, { 168, 155 } },
    { 26076, 2, { 164, 159 } },
    { 26082, 2, { 162, 161 } },
    { 26125, 2, { 209, 125 } },
    { 26196, 2, { 177, 148 } },
    { 26250, 2, { 175, 150 } },
    { 26316, 2, { 172, 153 } },
    { 26325, 2, { 195, 135 } },
    { 26352, 2, { 183, 144 } },
    { 26400, 2, { 165, 160 } },
    { 26448, 2, { 174, 152 } },
    { 26460, 2, { 180, 147 } },
    { 26505, 2, { 171, 155 } },
    { 26520, 2, { 170, 156 } },
    { 26565, 2, { 165, 161 } },
    { 26600, 2, { 175, 152 } },
    { 26676, 2, { 171, 156 } },
    { 26680, 2, { 184, 145 } },
    { 26712, 2, { 168, 159 } },
    { 26730, 2, { 165, 162 } },
    { 26775, 2, { 175, 153 } },
    { 26784, 2, { 186, 144 } },
    { 26880, 2, { 168, 160 } },
    { 26904, 2, { 177, 152 } },
    { 26928, 2, { 176, 153 } },
    { 26950, 2, { 175, 154 } },
    { 26970, 2, { 174, 155 } },
    { 27027, 2, { 189, 143 } },
    { 27040, 2, { 169, 160 } },
    { 27048, 2, { 168, 161 } },
    { 27060, 2, { 165, 164 } },
    { 27084, 2, { 183, 148 } },
    { 27132, 2, { 204, 133 } },
    { 27200, 2, { 170, 160 } },
    { 27216, 2, { 168, 162 } },
    { 27280, 2, { 176, 155 } },
    { 27300, 2, { 175, 156 } },
    { 27336, 2, { 201, 136 } },
    { 27348, 2, { 172, 159 } },
    { 27360, 2, { 171, 160 } },
    { 27370, 2, { 170, 161 } },
    { 27378, 2, { 169, 162 } },
    { 27405, 2, { 189, 145 } },
    { 27456, 2, { 176, 156 } },
    { 27489, 2, { 187, 147 } },
    { 27531, 2, { 171, 161 } },
    { 27540, 2, { 170, 162 } },
    { 27588, 2, { 209, 132 } },
    { 27600, 2, { 184, 150 } },
    { 27608, 2, { 203, 136 } },
    { 27612, 2, { 177, 156 } },
    { 27625, 2, { 221, 125 } },
    { 27636, 2, { 188, 147 } },
    { 27675, 2, { 205, 135 } },
    { 27720, 2, { 168, 165 } },
    { 27750, 2, { 185, 150 } },
    { 27776, 2, { 217, 128 } },
    { 27816, 2, { 183, 152 } },
    { 27840, 2, { 174, 160 } },
    { 27885, 2, { 169, 165 } },
    { 27900, 2, { 180, 155 } },
    { 27972, 2, { 189, 148 } },
    { 27984, 2, { 176, 159 } },
    { 28000, 2, { 175, 160 } },
    { 28044, 2, { 171, 164 } },
    { 28120, 2, { 185, 152 } },
    { 28140, 2, { 201, 140 } },
    { 28152, 2, { 184, 153 } },
    { 28175, 2, { 175, 161 } },
    { 28272, 2, { 186, 152 } },
    { 28290, 2, { 205, 138 } },
    { 28305, 2, { 185, 153 } },
    { 28314, 2, { 198, 143 } },
    { 28320, 2, { 177, 160 } },
    { 28336, 2, { 176, 161 } },
    { 28350, 2, { 175, 162 } },
    { 28380, 2, { 172, 165 } },
    { 28392, 2, { 169, 168 } },
    { 28512, 2, { 176, 162 } },
    { 28520, 2, { 184, 155 } },
    { 28548, 2, { 183, 156 } },
    { 28560, 2, { 170, 168 } },
    { 28600, 2, { 200, 143 } },
    { 28620, 2, { 180, 159 } },
    { 28728, 2, { 171, 168 } },
    { 28764, 2, { 188, 153 } },
    { 28798, 2, { 187, 154 } },
    { 28800, 2, { 180, 160 } },
    { 28860, 2, { 185, 156 } },
    { 28944, 2, { 201, 144 } },
    { 28980, 2, { 180, 161 } },
    { 29000, 2, { 200, 145 } },
    { 29025, 2, { 215, 135 } },
    { 29028, 2, { 177, 164 } },
    { 29040, 2, { 176, 165 } },
    { 29106, 2, { 189, 154 } },
    { 29120, 2, { 182, 160 } },
    { 29172, 2, { 187, 156 } },
    { 29232, 2, { 174, 168 } },
    { 29256, 2, { 184, 159 } },
    { 29280, 2, { 183, 160 } },
    { 29295, 2, { 189, 155 } },
    { 29376, 2, { 192, 153 } },
    { 29400, 2, { 175, 168 } },
    { 29403, 2, { 243, 121 } },
    { 29412, 2, { 172, 171 } },
    { 29484, 2, { 182, 162 } },
    { 29512, 2, { 217, 136 } },
    { 29575, 2, { 175, 169 } },
    { 29600, 2, { 185, 160 } },
    { 29640, 2, { 190, 156 } },
    { 29645, 2, { 245, 121 } },
    { 29670, 2, { 215, 138 } },
    { 29700, 2, { 180, 165 } },
    { 29736, 2, { 177, 168 } },
    { 29744, 2, { 176, 169 } },
    { 29748, 2, { 201, 148 } },
    { 29760, 2, { 186, 160 } },
    { 29808, 2, { 184, 162 } },
    { 29892, 2, { 188, 159 } },
    { 29920, 2, { 176, 170 } },
    { 29925, 2, { 175, 171 } },
    { 29952, 2, { 192, 156 } },
    { 29970, 2, { 185, 162 } },
    { 29988, 2, { 196, 153 } },
    { 30012, 2, { 183, 164 } },
    { 30015, 2, { 207, 145 } },
    { 30030, 2, { 182, 165 } },
    { 30096, 2, { 176, 171 } },
    { 30160, 2, { 208, 145 } },
    { 30250, 2, { 242, 125 } },
    { 30294, 2, { 187, 162 } },
    { 30303, 2, { 259, 117 } },
    { 30360, 2, { 184, 165 } },
    { 30400, 2, { 190, 160 } },
    { 30420, 2, { 180, 169 } },
    { 30429, 2, { 189, 161 } },
    { 30444, 2, { 177, 172 } },
    { 30450, 2, { 175, 174 } },
    { 30528, 2, { 192, 159 } },
    { 30552, 2, { 201, 152 } },
    { 30576, 2, { 182, 168 } },
    { 30590, 2, { 190, 161 } },
    { 30600, 2, { 180, 170 } },
    { 30624, 2, { 176, 174 } },
    { 30636, 2, { 207, 148 } },
    { 30672, 2, { 213, 144 } },
    { 30723, 2, { 209, 147 } },
    { 30744, 2, { 183, 168 } },
    { 30750, 2, { 205, 150 } },
    { 30780, 2, { 180, 171 } },
    { 30800, 2, { 176, 175 } },
    { 30855, 2, { 187, 165 } },
    { 30856, 2, { 203, 152 } },
    { 30875, 2, { 247, 125 } },
    { 30996, 2, { 189, 164 } },
    { 31000, 2, { 200, 155 } },
    { 31020, 2, { 188, 165 } },
    { 31059, 2, { 203, 153 } },
    { 31080, 2, { 185, 168 } },
    { 31104, 2, { 192, 162 } },
    { 31152, 2, { 177, 176 } },
    { 31164, 2, { 196, 159 } },
    { 31185, 2, { 189, 165 } },
    { 31200, 2, { 195, 160 } },
    { 31248, 2, { 186, 168 } },
    { 31356, 2, { 201, 156 } },
    { 31360, 2, { 196, 160 } },
    { 31365, 2, { 205, 153 } },
    { 31395, 2, { 195, 161 } },
    { 31416, 2, { 187, 168 } },
    { 31460, 2, { 220, 143 } },
    { 31464, 2, { 184, 171 } },
    { 31476, 2, { 183, 172 } },
    { 31500, 2, { 180, 175 } },
    { 31524, 2, { 213, 148 } },
    { 31590, 2, { 195, 162 } },
    { 31625, 2, { 253, 125 } },
    { 31635, 2, { 185, 171 } },
    { 31680, 2, { 180, 176 } },
    { 31752, 2, { 189, 168 } },
    { 31800, 2, { 200, 159 } },
    { 31850, 2, { 182, 175 } },
    { 31860, 2, { 180, 177 } },
    { 31878, 2, { 198, 161 } },
    { 31920, 2, { 190, 168 } },
    { 31941, 2, { 189, 169 } },
    { 31980, 2, { 195, 164 } },
    { 32016, 2, { 184, 174 } },
    { 32032, 2, { 182, 176 } },
    { 32085, 2, { 207, 155 } },
    { 32130, 2, { 189, 170 } },
    { 32148, 2, { 188, 171 } },
    { 32160, 2, { 201, 160 } },
    { 32186, 2, { 209, 154 } },
    { 32190, 2, { 185, 174 } },
    { 32200, 2, { 184, 175 } },
    { 32208, 2, { 183, 176 } },
    { 32240, 2, { 208, 155 } },
    { 32250, 2, { 215, 150 } },
    { 32256, 2, { 192, 168 } },
    { 32292, 2, { 207, 156 } },
    { 32340, 2, { 196, 165 } },
    { 32376, 2, { 213, 152 } },
    { 32412, 2, { 219, 148 } },
    { 32436, 2, { 204, 159 } },
    { 32448, 2, { 192, 169 } },
    { 32480, 2, { 203, 160 } },
    { 32487, 2, { 221, 147 } },
    { 32508, 2, { 189, 172 } },
    { 32550, 2, { 186, 175 } },
    { 32560, 2, { 185, 176 } },
    { 32568, 2, { 184, 177 } },
    { 32604, 2, { 209, 156 } },
    { 32625, 2, { 225, 145 } },
    { 32640, 2, { 192, 170 } },
    { 32725, 2, { 187, 175 } },
    { 32736, 2, { 186, 176 } },
    { 32760, 2, { 182, 180 } },
    { 32832, 2, { 192, 171 } },
    { 32844, 2, { 204, 161 } },
    { 32895, 2, { 215, 153 } },
    { 32912, 2, { 187, 176 } },
    { 32940, 2, { 183, 180 } },
    { 32964, 2, { 201, 164 } },
    { 32984, 2, { 217, 152 } },
    { 33000, 2, { 200, 165 } },
    { 33033, 2, { 231, 143 } },
    { 33072, 2, { 208, 159 } },
    { 33075, 2, { 189, 175 } },
    { 33201, 2, { 217, 153 } },
    { 33210, 2, { 205, 162 } },
    { 33228, 2, { 213, 156 } },
    { 33264, 2, { 189, 176 } },
    { 33276, 2, { 188, 177 } },
    { 33288, 2, { 219, 152 } },
    { 33300, 2, { 185, 180 } },
    { 33408, 2, { 192, 174 } },
    { 33440, 2, { 190, 176 } },
    { 33462, 2, { 198, 169 } },
    { 33495, 2, { 203, 165 } },
    { 33516, 2, { 196, 171 } },
    { 33540, 2, { 195, 172 } },
    { 33600, 2, { 192, 175 } },
    { 33660, 2, { 187, 180 } },
    { 33672, 2, { 184, 183 } },
    { 33696, 2, { 208, 162 } },
    { 33744, 2, { 222, 152 } },
    { 33768, 2, { 201, 168 } },
    { 33800, 2, { 200, 169 } },
    { 33810, 2, { 210, 161 } },
    { 33915, 2, { 255, 133 } },
    { 33948, 2, { 207, 164 } },
    { 33984, 2, { 192, 177 } },
    { 34020, 2, { 189, 180 } },
    { 34034, 2, { 187, 182 } },
    { 34040, 2, { 185, 184 } },
    { 34080, 2, { 213, 160 } },
    { 34164, 2, { 219, 156 } },
    { 34200, 2, { 190, 180 } },
    { 34224, 2, { 186, 184 } },
    { 34320, 2, { 195, 176 } },
    { 34398, 2, { 189, 182 } },
    { 34404, 2, { 188, 183 } },
    { 34410, 2, { 186, 185 } },
    { 34440, 2, { 205, 168 } },
    { 34485, 2, { 209, 165 } },
    { 34510, 2, { 203, 170 } },
    { 34560, 2, { 192, 180 } },
    { 34572, 2, { 201, 172 } },
    { 34650, 2, { 198, 175 } },
    { 34692, 2, { 196, 177 } },
    { 34713, 2, { 203, 171 } },
    { 34720, 2, { 217, 160 } },
    { 34749, 2, { 243, 143 } },
    { 34776, 2, { 189, 184 } },
    { 34800, 2, { 200, 174 } },
    { 34830, 2, { 215, 162 } },
    { 34848, 2, { 198, 176 } },
    { 34875, 2, { 225, 155 } },
    { 34884, 2, { 204, 171 } },
    { 34932, 2, { 213, 164 } },
    { 34944, 2, { 192, 182 } },
    { 34965, 2, { 189, 185 } },
    { 34980, 2, { 212, 165 } },
    { 35000, 2, { 200, 175 } },
    { 35035, 2, { 245, 143 } },
    { 35040, 2, { 219, 160 } },
    { 35055, 2, { 205, 171 } },
    { 35100, 2, { 195, 180 } },
    { 35112, 2, { 209, 168 } },
    { 35136, 2, { 192, 183 } },
    { 35235, 2, { 243, 145 } },
    { 35250, 2, { 235, 150 } },
    { 35280, 2, { 196, 180 } },
    { 35343, 2, { 189, 187 } },
    { 35360, 2, { 208, 170 } },
    { 35376, 2, { 201, 176 } },
    { 35400, 2, { 200, 177 } },
    { 35420, 2, { 220, 161 } },
    { 35520, 2, { 192, 185 } },
    { 35525, 2, { 203, 175 } },
    { 35532, 2, { 189, 188 } },
    { 35568, 2, { 208, 171 } },
    { 35604, 2, { 207, 172 } },
    { 35670, 2, { 205, 174 } },
    { 35700, 2, { 204, 175 } },
    { 35712, 2, { 192, 186 } },
    { 35728, 2, { 203, 176 } },
    { 35750, 2, { 250, 143 } },
    { 35784, 2, { 213, 168 } },
    { 35802, 2, { 221, 162 } },
    { 35805, 2, { 217, 165 } },
    { 35868, 2, { 196, 183 } },
    { 35880, 2, { 195, 184 } },
    { 35904, 2, { 192, 187 } },
    { 35910, 2, { 190, 189 } },
    { 35916, 2, { 219, 164 } },
    { 35955, 2, { 235, 153 } },
    { 35960, 2, { 232, 155 } },
    { 36036, 2, { 198, 182 } },
    { 36080, 2, { 205, 176 } },
    { 36108, 2, { 204, 177 } },
    { 36125, 2, { 289, 125 } },
    { 36180, 2, { 201, 180 } },
    { 36192, 2, { 208, 174 } },
    { 36225, 2, { 207, 175 } },
    { 36252, 2, { 212, 171 } },
    { 36288, 2, { 192, 189 } },
    { 36309, 2, { 247, 147 } },
    { 36400, 2, { 200, 182 } },
    { 36432, 2, { 198, 184 } },
    { 36450, 2, { 225, 162 } },
    { 36465, 2, { 195, 187 } },
    { 36480, 2, { 192, 190 } },
    { 36504, 2, { 216, 169 } },
    { 36540, 2, { 203, 180 } },
    { 36575, 2, { 209, 175 } },
    { 36600, 2, { 200, 183 } },
    { 36630, 2, { 198, 185 } },
    { 36636, 2, { 213, 172 } },
    { 36652, 2, { 196, 187 } },
    { 36660, 2, { 195, 188 } },
    { 36708, 2, { 228, 161 } },
    { 36765, 2, { 215, 171 } },
    { 36784, 2, { 209, 176 } },
    { 36792, 2, { 219, 168 } },
    { 36816, 2, { 208, 177 } },
    { 36855, 2, { 195, 189 } },
    { 36890, 2, { 217, 170 } },
    { 36900, 2, { 205, 180 } },
    { 36936, 2, { 216, 171 } },
    { 36960, 2, { 210, 176 } },
    { 36984, 2, { 201, 184 } },
    { 37000, 2, { 200, 185 } },
    { 37026, 2, { 198, 187 } },
    { 37044, 2, { 196, 189 } },
    { 37107, 2, { 217, 171 } },
    { 37180, 2, { 220, 169 } },
    { 37200, 2, { 200, 186 } },
    { 37260, 2, { 207, 180 } },
    { 37296, 2, { 222, 168 } },
    { 37332, 2, { 204, 183 } },
    { 37352, 2, { 203, 184 } },
    { 37375, 2, { 299, 125 } },
    { 37400, 2, { 200, 187 } },
    { 37410, 2, { 215, 174 } },
    { 37440, 2, { 195, 192 } },
    { 37485, 2, { 245, 153 } },
    { 37488, 2, { 213, 176 } },
    { 37524, 2, { 212, 177 } },
    { 37584, 2, { 216, 174 } },
    { 37620, 2, { 198, 190 } },
    { 37632, 2, { 196, 192 } },
    { 37665, 2, { 243, 155 } },
    { 37668, 2, { 219, 172 } },
    { 37720, 2, { 205, 184 } },
    { 37740, 2, { 204, 185 } },
    { 37788, 2, { 201, 188 } },
    { 37800, 2, { 200, 189 } },
    { 37840, 2, { 215, 176 } },
    { 37884, 2, { 231, 164 } },
    { 37920, 2, { 237, 160 } },
    { 37975, 2, { 217, 175 } },
    { 38016, 2, { 198, 192 } },
    { 38038, 2, { 209, 182 } },
    { 38064, 2, { 208, 183 } },
    { 38070, 2, { 235, 162 } },
    { 38080, 2, { 224, 170 } },
    { 38088, 2, { 207, 184 } },
    { 38130, 2, { 205, 186 } },
    { 38192, 2, { 217, 176 } },
    { 38220, 2, { 196, 195 } },
    { 38232, 2, { 216, 177 } },
    { 38295, 2, { 207, 185 } },
    { 38304, 2, { 224, 171 } },
    { 38340, 2, { 213, 180 } },
    { 38367, 2, { 203, 189 } },
    { 38400, 2, { 200, 192 } },
    { 38480, 2, { 208, 185 } },
    { 38544, 2, { 219, 176 } },
    { 38556, 2, { 204, 189 } },
    { 38570, 2, { 203, 190 } },
    { 38592, 2, { 201, 192 } },
    { 38610, 2, { 198, 195 } },
    { 38640, 2, { 210, 184 } },
    { 38675, 2, { 221, 175 } },
    { 38688, 2, { 208, 186 } },
    { 38700, 2, { 215, 180 } },
    { 38745, 2, { 205, 189 } },
    { 38760, 2, { 204, 190 } },
    { 38796, 2, { 212, 183 } },
    { 38850, 2, { 210, 185 } },
    { 38868, 2, { 237, 164 } },
    { 38896, 2, { 208, 187 } },
    { 38916, 2, { 207, 188 } },
    { 38940, 2, { 220, 177 } },
    { 38976, 2, { 203, 192 } },
    { 39000, 2, { 200, 195 } },
    { 39039, 2, { 231, 169 } },
    { 39072, 2, { 222, 176 } },
    { 39168, 2, { 204, 192 } },
    { 39192, 2, { 213, 184 } },
    { 39200, 2, { 200, 196 } },
    { 39270, 2, { 210, 187 } },
    { 39312, 2, { 208, 189 } },
    { 39325, 2, { 275, 143 } },
    { 39360, 2, { 205, 192 } },
    { 39368, 2, { 259, 152 } },
    { 39375, 2, { 225, 175 } },
    { 39396, 2, { 201, 196 } },
    { 39420, 2, { 219, 180 } },
    { 39468, 2, { 253, 156 } },
    { 39501, 2, { 209, 189 } },
    { 39520, 2, { 208, 190 } },
    { 39528, 2, { 216, 183 } },
    { 39560, 2, { 215, 184 } },
    { 39585, 2, { 203, 195 } },
    { 39600, 2, { 200, 198 } },
    { 39627, 2, { 259, 153 } },
    { 39648, 2, { 224, 177 } },
    { 39732, 2, { 231, 172 } },
    { 39744, 2, { 207, 192 } },
    { 39780, 2, { 204, 195 } },
    { 39816, 2, { 237, 168 } },
    { 39852, 2, { 243, 164 } },
    { 39928, 2, { 217, 184 } },
    { 39960, 2, { 216, 185 } },
    { 39990, 2, { 215, 186 } },
    { 40040, 2, { 220, 182 } },
    { 40044, 2, { 213, 188 } },
    { 40068, 2, { 212, 189 } },
    { 40095, 2, { 243, 165 } },
    { 40128, 2, { 209, 192 } },
    { 40176, 2, { 216, 186 } },
    { 40185, 2, { 235, 171 } },
    { 40194, 2, { 203, 198 } },
    { 40200, 2, { 201, 200 } },
    { 40222, 2, { 221, 182 } },
    { 40260, 2, { 220, 183 } },
    { 40296, 2, { 219, 184 } },
    { 40320, 2, { 210, 192 } },
    { 40356, 2, { 228, 177 } },
    { 40375, 2, { 323, 125 } },
    { 40425, 2, { 231, 175 } },
    { 40455, 2, { 261, 155 } },
    { 40500, 2, { 225, 180 } },
    { 40560, 2, { 208, 195 } },
    { 40572, 2, { 207, 196 } },
    { 40590, 2, { 205, 198 } },
    { 40600, 2, { 203, 200 } },
    { 40635, 2, { 215, 189 } },
    { 40656, 2, { 231, 176 } },
    { 40755, 2, { 209, 195 } },
    { 40764, 2, { 237, 172 } },
    { 40824, 2, { 216, 189 } },
    { 40848, 2, { 222, 184 } },
    { 40890, 2, { 235, 174 } },
    { 40896, 2, { 213, 192 } },
    { 40898, 2, { 242, 169 } },
    { 40964, 2, { 209, 196 } },
    { 40992, 2, { 224, 183 } },
    { 41000, 2, { 205, 200 } },
    { 41004, 2, { 204, 201 } },
    { 41013, 2, { 217, 189 } },
    { 41040, 2, { 216, 190 } },
    { 41055, 2, { 255, 161 } },
    { 41064, 2, { 232, 177 } },
    { 41067, 2, { 243, 169 } },
    { 41140, 2, { 220, 187 } },
    { 41172, 2, { 219, 188 } },
    { 41184, 2, { 208, 198 } },
    { 41230, 2, { 217, 190 } },
    { 41280, 2, { 215, 192 } },
    { 41310, 2, { 243, 170 } },
    { 41328, 2, { 246, 168 } },
    { 41340, 2, { 212, 195 } },
    { 41382, 2, { 209, 198 } },
    { 41400, 2, { 207, 200 } },
    { 41405, 2, { 245, 169 } },
    { 41412, 2, { 204, 203 } },
    { 41440, 2, { 224, 185 } },
    { 41472, 2, { 216, 192 } },
    { 41503, 2, { 343, 121 } },
    { 41625, 2, { 225, 185 } },
    { 41650, 2, { 238, 175 } },
    { 41664, 2, { 217, 192 } },
    { 41712, 2, { 237, 176 } },
    { 41724, 2, { 228, 183 } },
    { 41745, 2, { 253, 165 } },
    { 41748, 2, { 213, 196 } },
    { 41769, 2, { 221, 189 } },
    { 41796, 2, { 243, 172 } },
    { 41800, 2, { 209, 200 } },
    { 41808, 2, { 208, 201 } },
    { 41820, 2, { 205, 204 } },
    { 41832, 2, { 249, 168 } },
    { 41888, 2, { 224, 187 } },
    { 41895, 2, { 245, 171 } },
    { 42000, 2, { 210, 200 } },
    { 42021, 2, { 207, 203 } },
    { 42048, 2, { 219, 192 } },
    { 42075, 2, { 225, 187 } },
    { 42120, 2, { 216, 195 } },
    { 42224, 2, { 208, 203 } },
    { 42228, 2, { 207, 204 } },
    { 42240, 2, { 220, 192 } },
    { 42250, 2, { 250, 169 } },
    { 42300, 2, { 225, 188 } },
    { 42315, 2, { 217, 195 } },
    { 42336, 2, { 216, 196 } },
    { 42350, 2, { 242, 175 } },
    { 42432, 2, { 208, 204 } },
    { 42435, 2, { 207, 205 } },
    { 42456, 2, { 232, 183 } },
    { 42471, 2, { 297, 143 } },
    { 42483, 2, { 289, 147 } },
    { 42504, 2, { 231, 184 } },
    { 42560, 2, { 224, 190 } },
    { 42570, 2, { 215, 198 } },
    { 42600, 2, { 213, 200 } },
    { 42612, 2, { 212, 201 } },
    { 42624, 2, { 222, 192 } },
    { 42630, 2, { 210, 203 } },
    { 42636, 2, { 209, 204 } },
    { 42640, 2, { 208, 205 } },
    { 42660, 2, { 237, 180 } },
    { 42768, 2, { 216, 198 } },
    { 42828, 2, { 249, 172 } },
    { 42900, 2, { 220, 195 } },
    { 42920, 2, { 232, 185 } },
    { 42924, 2, { 219, 196 } },
    { 42930, 2, { 265, 162 } },
    { 42966, 2, { 217, 198 } },
    { 43000, 2, { 215, 200 } },
    { 43050, 2, { 210, 205 } },
    { 43056, 2, { 208, 207 } },
    { 43092, 2, { 228, 189 } },
    { 43095, 2, { 221, 195 } },
    { 43152, 2, { 232, 186 } },
    { 43188, 2, { 236, 183 } },
    { 43197, 2, { 231, 187 } },
    { 43200, 2, { 216, 200 } },
    { 43225, 2, { 247, 175 } },
    { 43296, 2, { 246, 176 } },
    { 43316, 2, { 221, 196 } },
    { 43400, 2, { 217, 200 } },
    { 43416, 2, { 216, 201 } },
    { 43428, 2, { 231, 188 } },
    { 43452, 2, { 213, 204 } },
    { 43472, 2, { 209, 208 } },
    { 43520, 2, { 256, 170 } },
    { 43608, 2, { 237, 184 } },
    { 43659, 2, { 231, 189 } },
    { 43680, 2, { 210, 208 } },
    { 43710, 2, { 235, 186 } },
    { 43740, 2, { 243, 180 } },
    { 43758, 2, { 221, 198 } },
    { 43776, 2, { 228, 192 } },
    { 43800, 2, { 219, 200 } },
    { 43824, 2, { 249, 176 } },
    { 43848, 2, { 216, 203 } },
    { 43860, 2, { 215, 204 } },
    { 43884, 2, { 212, 207 } },
    { 43890, 2, { 210, 209 } },
    { 43911, 2, { 287, 153 } },
    { 43920, 2, { 240, 183 } },
    { 44160, 2, { 230, 192 } },
    { 44200, 2, { 221, 200 } },
    { 44220, 2, { 220, 201 } },
    { 44268, 2, { 217, 204 } },
    { 44275, 2, { 253, 175 } },
    { 44280, 2, { 216, 205 } },
    { 44289, 2, { 259, 171 } },
    { 44304, 2, { 213, 208 } },
    { 44352, 2, { 224, 198 } },
    { 44400, 2, { 222, 200 } },
    { 44415, 2, { 235, 189 } },
    { 44460, 2, { 228, 195 } },
    { 44505, 2, { 215, 207 } },
    { 44556, 2, { 237, 188 } },
    { 44604, 2, { 236, 189 } },
    { 44616, 2, { 264, 169 } },
    { 44640, 2, { 240, 186 } },
    { 44660, 2, { 220, 203 } },
    { 44676, 2, { 219, 204 } },
    { 44712, 2, { 216, 207 } },
    { 44720, 2, { 215, 208 } },
    { 44820, 2, { 249, 180 } },
    { 44919, 2, { 217, 207 } },
    { 44954, 2, { 247, 182 } },
    { 44955, 2, { 243, 185 } },
    { 44982, 2, { 238, 189 } },
    { 45000, 2, { 225, 200 } },
    { 45024, 2, { 224, 201 } },
    { 45120, 2, { 235, 192 } },
    { 45125, 2, { 361, 125 } },
    { 45136, 2, { 217, 208 } },
    { 45144, 2, { 216, 209 } },
    { 45150, 2, { 215, 210 } },
    { 45156, 2, { 213, 212 } },
    { 45240, 2, { 232, 195 } },
    { 45264, 2, { 246, 184 } },
    { 45276, 2, { 231, 196 } },
    { 45315, 2, { 265, 171 } },
    { 45360, 2, { 216, 210 } },
    { 45408, 2, { 258, 176 } },
    { 45441, 2, { 243, 187 } },
    { 45472, 2, { 224, 203 } },
    { 45500, 2, { 250, 182 } },
    { 45504, 2, { 237, 192 } },
    { 45510, 2, { 222, 205 } },
    { 45540, 2, { 220, 207 } },
    { 45552, 2, { 219, 208 } },
    { 45570, 2, { 217, 210 } },
    { 45584, 2, { 259, 176 } },
    { 45675, 2, { 225, 203 } },
    { 45684, 2, { 243, 188 } },
    { 45696, 2, { 224, 204 } },
    { 45815, 2, { 245, 187 } },
    { 45816, 2, { 249, 184 } },
    { 45828, 2, { 228, 201 } },
    { 45880, 2, { 248, 185 } },
    { 45885, 2, { 285, 161 } },
    { 45900, 2, { 225, 204 } },
    { 45920, 2, { 224, 205 } },
    { 45936, 2, { 232, 198 } },
    { 45968, 2, { 221, 208 } },
    { 45980, 2, { 220, 209 } },
    { 46008, 2, { 216, 213 } },
    { 46020, 2, { 236, 195 } },
    { 46046, 2, { 253, 182 } },
    { 46053, 2, { 301, 153 } },
    { 46080, 2, { 240, 192 } },
    { 46110, 2, { 265, 174 } },
    { 46116, 2, { 244, 189 } },
    { 46125, 2, { 225, 205 } },
    { 46170, 2, { 243, 190 } },
    { 46176, 2, { 222, 208 } },
    { 46284, 2, { 228, 203 } },
    { 46305, 2, { 245, 189 } },
    { 46368, 2, { 224, 207 } },
    { 46410, 2, { 221, 210 } },
    { 46428, 2, { 219, 212 } },
    { 46440, 2, { 216, 215 } },
    { 46452, 2, { 237, 196 } },
    { 46464, 2, { 242, 192 } },
    { 46475, 2, { 275, 169 } },
    { 46530, 2, { 235, 198 } },
    { 46632, 2, { 232, 201 } },
    { 46683, 2, { 247, 189 } },
    { 46690, 2, { 230, 203 } },
    { 46740, 2, { 228, 205 } },
    { 46750, 2, { 250, 187 } },
    { 46800, 2, { 225, 208 } },
    { 46812, 2, { 249, 188 } },
    { 46816, 2, { 224, 209 } },
    { 46818, 2, { 289, 162 } },
    { 46860, 2, { 220, 213 } },
    { 46872, 2, { 217, 216 } },
    { 46920, 2, { 230, 204 } },
    { 46980, 2, { 261, 180 } },
    { 47000, 2, { 235, 200 } },
    { 47025, 2, { 225, 209 } },
    { 47040, 2, { 224, 210 } },
    { 47124, 2, { 231, 204 } },
    { 47196, 2, { 228, 207 } },
    { 47232, 2, { 246, 192 } },
    { 47304, 2, { 219, 216 } },
    { 47360, 2, { 256, 185 } },
    { 47385, 2, { 243, 195 } },
    { 47400, 2, { 237, 200 } },
    { 47424, 2, { 228, 208 } },
    { 47432, 2, { 242, 196 } },
    { 47436, 2, { 236, 201 } },
    { 47472, 2, { 258, 184 } },
    { 47481, 2, { 323, 147 } },
    { 47502, 2, { 234, 203 } },
    { 47520, 2, { 220, 216 } },
    { 47560, 2, { 232, 205 } },
    { 47580, 2, { 244, 195 } },
    { 47600, 2, { 238, 200 } },
    { 47628, 2, { 243, 196 } },
    { 47656, 2, { 259, 184 } },
    { 47700, 2, { 225, 212 } },
    { 47712, 2, { 224, 213 } },
    { 47730, 2, { 222, 215 } },
    { 47736, 2, { 221, 216 } },
    { 47740, 2, { 220, 217 } },
    { 47808, 2, { 249, 192 } },
    { 47840, 2, { 230, 208 } },
    { 47850, 2, { 275, 174 } },
    { 47872, 2, { 256, 187 } },
    { 47940, 2, { 235, 204 } },
    { 47952, 2, { 222, 216 } },
    { 47970, 2, { 234, 205 } },
    { 48024, 2, { 232, 207 } },
    { 48048, 2, { 231, 208 } },
    { 48060, 2, { 267, 180 } },
    { 48160, 2, { 224, 215 } },
    { 48165, 2, { 247, 195 } },
    { 48180, 2, { 220, 219 } },
    { 48195, 2, { 255, 189 } },
    { 48240, 2, { 240, 201 } },
    { 48279, 2, { 231, 209 } },
    { 48285, 2, { 261, 185 } },
    { 48348, 2, { 237, 204 } },
    { 48360, 2, { 248, 195 } },
    { 48375, 2, { 225, 215 } },
    { 48384, 2, { 224, 216 } },
    { 48412, 2, { 247, 196 } },
    { 48510, 2, { 231, 210 } },
    { 48564, 2, { 228, 213 } },
    { 48576, 2, { 253, 192 } },
    { 48600, 2, { 225, 216 } },
    { 48608, 2, { 224, 217 } },
    { 48620, 2, { 221, 220 } },
    { 48640, 2, { 256, 190 } },
    { 48645, 2, { 235, 207 } },
    { 48672, 2, { 234, 208 } },
    { 48720, 2, { 232, 210 } },
    { 48804, 2, { 249, 196 } },
    { 48825, 2, { 225, 217 } },
    { 48852, 2, { 236, 207 } },
    { 48875, 2, { 391, 125 } },
    { 48880, 2, { 235, 208 } },
    { 48906, 2, { 234, 209 } },
    { 48951, 2, { 259, 189 } },
    { 48960, 2, { 240, 204 } },
    { 48972, 2, { 231, 212 } },
    { 49000, 2, { 245, 200 } },
    { 49020, 2, { 228, 215 } },
    { 49044, 2, { 244, 201 } },
    { 49049, 2, { 343, 143 } },
    { 49056, 2, { 224, 219 } },
    { 49068, 2, { 261, 188 } },
    { 49077, 2, { 287, 171 } },
    { 49104, 2, { 248, 198 } },
    { 49128, 2, { 267, 184 } },
    { 49200, 2, { 240, 205 } },
    { 49210, 2, { 259, 190 } },
    { 49280, 2, { 224, 220 } },
    { 49290, 2, { 265, 186 } },
    { 49296, 2, { 237, 208 } },
    { 49329, 2, { 243, 203 } },
    { 49335, 2, { 253, 195 } },
    { 49350, 2, { 235, 210 } },
    { 49400, 2, { 247, 200 } },
    { 49416, 2, { 232, 213 } },
    { 49476, 2, { 228, 217 } },
    { 49500, 2, { 225, 220 } },
    { 49504, 2, { 224, 221 } },
    { 49536, 2, { 258, 192 } },
    { 49572, 2, { 243, 204 } },
    { 49588, 2, { 253, 196 } },
    { 49680, 2, { 230, 216 } },
    { 49725, 2, { 225, 221 } },
    { 49728, 2, { 224, 222 } },
    { 49742, 2, { 238, 209 } },
    { 49800, 2, { 249, 200 } },
    { 49815, 2, { 243, 205 } },
    { 49848, 2, { 248, 201 } },
    { 49880, 2, { 232, 215 } },
    { 49896, 2, { 231, 216 } },
    { 49910, 2, { 230, 217 } },
    { 49932, 2, { 228, 219 } },
    { 49980, 2, { 238, 210 } },
    { 50050, 2, { 275, 182 } },
    { 50085, 2, { 265, 189 } },
    { 50193, 2, { 297, 169 } },
    { 50196, 2, { 267, 188 } },
    { 50232, 2, { 273, 184 } },
    { 50244, 2, { 237, 212 } },
    { 50268, 2, { 236, 213 } },
    { 50274, 2, { 266, 189 } },
    { 50310, 2, { 234, 215 } },
    { 50320, 2, { 272, 185 } },
    { 50337, 2, { 329, 153 } },
    { 50344, 2, { 232, 217 } },
    { 50400, 2, { 225, 224 } },
    { 50490, 2, { 255, 198 } },
    { 50505, 2, { 259, 195 } },
    { 50508, 2, { 244, 207 } },
    { 50512, 2, { 287, 176 } },
    { 50544, 2, { 234, 216 } },
    { 50575, 2, { 289, 175 } },
    { 50652, 2, { 252, 201 } },
    { 50688, 2, { 256, 198 } },
    { 50715, 2, { 245, 207 } },
    { 50750, 2, { 250, 203 } },
    { 50760, 2, { 235, 216 } },
    { 50778, 2, { 234, 217 } },
    { 50787, 2, { 243, 209 } },
    { 50796, 2, { 249, 204 } },
    { 50808, 2, { 232, 219 } },
    { 50820, 2, { 231, 220 } },
    { 50840, 2, { 248, 205 } },
    { 50960, 2, { 245, 208 } },
    { 51000, 2, { 250, 204 } },
    { 51030, 2, { 243, 210 } },
    { 51051, 2, { 231, 221 } },
    { 51072, 2, { 228, 224 } },
    { 51120, 2, { 240, 213 } },
    { 51150, 2, { 275, 186 } },
    { 51156, 2, { 252, 203 } },
    { 51168, 2, { 246, 208 } },
    { 51192, 2, { 237, 216 } },
    { 51200, 2, { 256, 200 } },
    { 51205, 2, { 245, 209 } },
    { 51264, 2, { 267, 192 } },
    { 51300, 2, { 228, 225 } },
    { 51324, 2, { 273, 188 } },
    { 51336, 2, { 248, 207 } },
    { 51376, 2, { 247, 208 } },
    { 51408, 2, { 238, 216 } },
    { 51425, 2, { 275, 187 } },
    { 51450, 2, { 245, 210 } },
    { 51456, 2, { 256, 201 } },
    { 51471, 2, { 301, 171 } },
    { 51504, 2, { 232, 222 } },
    { 51516, 2, { 243, 212 } },
    { 51520, 2, { 230, 224 } },
    { 51597, 2, { 273, 189 } },
    { 51600, 2, { 240, 215 } },
    { 51612, 2, { 253, 204 } },
    { 51615, 2, { 279, 185 } },
    { 51680, 2, { 272, 190 } },
    { 51684, 2, { 236, 219 } },
    { 51714, 2, { 234, 221 } },
    { 51744, 2, { 231, 224 } },
    { 51765, 2, { 255, 203 } },
    { 51792, 2, { 249, 208 } },
    { 51800, 2, { 259, 200 } },
    { 51870, 2, { 247, 210 } },
    { 51972, 2, { 244, 213 } },
    { 51975, 2, { 231, 225 } },
    { 52000, 2, { 250, 208 } },
    { 52020, 2, { 255, 204 } },
    { 52080, 2, { 240, 217 } },
    { 52140, 2, { 237, 220 } },
    { 52164, 2, { 252, 207 } },
    { 52170, 2, { 235, 222 } },
    { 52200, 2, { 232, 225 } },
    { 52224, 2, { 256, 204 } },
    { 52245, 2, { 243, 215 } },
    { 52250, 2, { 250, 209 } },
    { 52260, 2, { 260, 201 } },
    { 52272, 2, { 242, 216 } },
    { 52325, 2, { 299, 175 } },
    { 52332, 2, { 267, 196 } },
    { 52360, 2, { 238, 220 } },
    { 52416, 2, { 234, 224 } },
    { 52440, 2, { 230, 228 } },
    { 52452, 2, { 279, 188 } },
    { 52470, 2, { 265, 198 } },
    { 52479, 2, { 343, 153 } },
    { 52480, 2, { 256, 205 } },
    { 52488, 2, { 243, 216 } },
    { 52560, 2, { 240, 219 } },
    { 52624, 2, { 253, 208 } },
    { 52635, 2, { 319, 165 } },
    { 52640, 2, { 235, 224 } },
    { 52668, 2, { 231, 228 } },
    { 52731, 2, { 243, 217 } },
    { 52780, 2, { 260, 203 } },
    { 52788, 2, { 249, 212 } },
    { 52800, 2, { 240, 220 } },
    { 52808, 2, { 287, 184 } },
    { 52824, 2, { 248, 213 } },
    { 52875, 2, { 235, 225 } },
    { 52890, 2, { 246, 215 } },
    { 52920, 2, { 245, 216 } },
    { 52976, 2, { 301, 176 } },
    { 52992, 2, { 256, 207 } },
    { 53040, 2, { 240, 221 } },
    { 53064, 2, { 264, 201 } },
    { 53067, 2, { 361, 147 } },
    { 53088, 2, { 237, 224 } },
    { 53100, 2, { 236, 225 } },
    { 53136, 2, { 246, 216 } },
    { 53200, 2, { 266, 200 } },
    { 53244, 2, { 261, 204 } },
    { 53280, 2, { 240, 222 } },
    { 53295, 2, { 255, 209 } },
    { 53312, 2, { 238, 224 } },
    { 53320, 2, { 248, 215 } },
    { 53400, 2, { 267, 200 } },
    { 53436, 2, { 244, 219 } },
    { 53460, 2, { 243, 220 } },
    { 53482, 2, { 242, 221 } },
    { 53504, 2, { 256, 209 } },
    { 53505, 2, { 261, 205 } },
    { 53508, 2, { 273, 196 } },
    { 53550, 2, { 238, 225 } },
    { 53580, 2, { 235, 228 } },
    { 53592, 2, { 232, 231 } },
    { 53613, 2, { 259, 207 } },
    { 53664, 2, { 258, 208 } },
    { 53676, 2, { 252, 213 } },
    { 53703, 2, { 243, 221 } },
    { 53784, 2, { 249, 216 } },
    { 53820, 2, { 234, 230 } },
    { 53865, 2, { 285, 189 } },
    { 53872, 2, { 259, 208 } },
    { 54000, 2, { 240, 225 } },
    { 54036, 2, { 237, 228 } },
    { 54060, 2, { 255, 212 } },
    { 54144, 2, { 282, 192 } },
    { 54145, 2, { 245, 221 } },
    { 54180, 2, { 252, 215 } },
    { 54208, 2, { 242, 224 } },
    { 54243, 2, { 287, 189 } },
    { 54250, 2, { 250, 217 } },
    { 54288, 2, { 234, 232 } },
    { 54312, 2, { 248, 219 } },
    { 54340, 2, { 247, 220 } },
    { 54390, 2, { 245, 222 } },
    { 54418, 2, { 299, 182 } },
    { 54432, 2, { 243, 224 } },
    { 54450, 2, { 242, 225 } },
    { 54468, 2, { 267, 204 } },
    { 54516, 2, { 236, 231 } },
    { 54520, 2, { 235, 232 } },
    { 54528, 2, { 256, 213 } },
    { 54621, 2, { 289, 189 } },
    { 54625, 2, { 437, 125 } },
    { 54648, 2, { 253, 216 } },
    { 54675, 2, { 243, 225 } },
    { 54684, 2, { 252, 217 } },
    { 54720, 2, { 240, 228 } },
    { 54780, 2, { 249, 220 } },
    { 54855, 2, { 265, 207 } },
    { 54870, 2, { 295, 186 } },
    { 54880, 2, { 245, 224 } },
    { 54900, 2, { 244, 225 } },
    { 54945, 2, { 297, 185 } },
    { 54984, 2, { 237, 232 } },
    { 54990, 2, { 235, 234 } },
    { 55040, 2, { 256, 215 } },
    { 55055, 2, { 385, 143 } },
    { 55056, 2, { 248, 222 } },
    { 55080, 2, { 255, 216 } },
    { 55104, 2, { 246, 224 } },
    { 55125, 2, { 245, 225 } },
    { 55188, 2, { 252, 219 } },
    { 55200, 2, { 240, 230 } },
    { 55250, 2, { 250, 221 } },
    { 55296, 2, { 256, 216 } },
    { 55328, 2, { 247, 224 } },
    { 55332, 2, { 261, 212 } },
    { 55335, 2, { 255, 217 } },
    { 55380, 2, { 260, 213 } },
    { 55384, 2, { 301, 184 } },
    { 55404, 2, { 243, 228 } },
    { 55440, 2, { 240, 231 } },
    { 55476, 2, { 268, 207 } },
    { 55536, 2, { 267, 208 } },
    { 55539, 2, { 297, 187 } },
    { 55575, 2, { 247, 225 } },
    { 55650, 2, { 265, 210 } },
    { 55692, 2, { 238, 234 } },
    { 55728, 2, { 258, 216 } },
    { 55755, 2, { 295, 189 } },
    { 55760, 2, { 272, 205 } },
    { 55776, 2, { 249, 224 } },
    { 55800, 2, { 248, 225 } },
    { 55825, 2, { 275, 203 } },
    { 55860, 2, { 245, 228 } },
    { 55890, 2, { 243, 230 } },
    { 55932, 2, { 237, 236 } },
    { 56000, 2, { 250, 224 } },
    { 56028, 2, { 276, 203 } },
    { 56056, 2, { 286, 196 } },
    { 56064, 2, { 256, 219 } },
    { 56100, 2, { 255, 220 } },
    { 56115, 2, { 261, 215 } },
    { 56133, 2, { 243, 231 } },
    { 56160, 2, { 240, 234 } },
    { 56232, 2, { 264, 213 } },
    { 56259, 2, { 329, 171 } },
    { 56265, 2, { 341, 165 } },
    { 56304, 2, { 272, 207 } },
    { 56320, 2, { 256, 220 } },
    { 56364, 2, { 244, 231 } },
    { 56376, 2, { 243, 232 } },
    { 56400, 2, { 240, 235 } },
    { 56420, 2, { 260, 217 } },
    { 56430, 2, { 270, 209 } },
    { 56448, 2, { 252, 224 } },
    { 56525, 2, { 323, 175 } },
    { 56576, 2, { 256, 221 } },
    { 56604, 2, { 267, 212 } },
    { 56637, 2, { 261, 217 } },
    { 56672, 2, { 253, 224 } },
    { 56700, 2, { 252, 225 } },
    { 56730, 2, { 305, 186 } },
    { 56772, 2, { 249, 228 } },
    { 56784, 2, { 273, 208 } },
    { 56832, 2, { 256, 222 } },
    { 56840, 2, { 245, 232 } },
    { 56848, 2, { 272, 209 } },
    { 56880, 2, { 240, 237 } },
    { 56889, 2, { 301, 189 } },
    { 56916, 2, { 279, 204 } },
    { 56925, 2, { 253, 225 } },
    { 56940, 2, { 260, 219 } },
    { 56980, 2, { 259, 220 } },
    { 57000, 2, { 250, 228 } },
    { 57036, 2, { 291, 196 } },
    { 57057, 2, { 247, 231 } },
    { 57072, 2, { 246, 232 } },
    { 57084, 2, { 268, 213 } },
    { 57105, 2, { 243, 235 } },
    { 57120, 2, { 240, 238 } },
    { 57195, 2, { 279, 205 } },
    { 57222, 2, { 289, 198 } },
    { 57240, 2, { 265, 216 } },
    { 57288, 2, { 248, 231 } },
    { 57330, 2, { 245, 234 } },
    { 57348, 2, { 243, 236 } },
    { 57400, 2, { 280, 205 } },
    { 57408, 2, { 276, 208 } },
    { 57420, 2, { 261, 220 } },
    { 57460, 2, { 260, 221 } },
    { 57475, 2, { 275, 209 } },
    { 57645, 2, { 305, 189 } },
    { 57672, 2, { 267, 216 } },
    { 57684, 2, { 253, 228 } },
    { 57750, 2, { 250, 231 } },
    { 57768, 2, { 249, 232 } },
    { 57792, 2, { 258, 224 } },
    { 57798, 2, { 247, 234 } },
    { 57800, 2, { 289, 200 } },
    { 57810, 2, { 246, 235 } },
    { 57816, 2, { 264, 219 } },
    { 57828, 2, { 244, 237 } },
    { 57834, 2, { 243, 238 } },
    { 57855, 2, { 285, 203 } },
    { 57876, 2, { 273, 212 } },
    { 57915, 2, { 297, 195 } },
    { 57936, 2, { 272, 213 } },
    { 57960, 2, { 252, 230 } },
    { 57967, 2, { 343, 169 } },
    { 58016, 2, { 259, 224 } },
    { 58032, 2, { 248, 234 } },
    { 58080, 2, { 242, 240 } },
    { 58140, 2, { 255, 228 } },
    { 58200, 2, { 291, 200 } },
    { 58212, 2, { 252, 231 } },
    { 58240, 2, { 260, 224 } },
    { 58275, 2, { 259, 225 } },
    { 58280, 2, { 248, 235 } },
    { 58305, 2, { 299, 195 } },
    { 58320, 2, { 243, 240 } },
    { 58344, 2, { 264, 221 } },
    { 58368, 2, { 256, 228 } },
    { 58410, 2, { 295, 198 } },
    { 58443, 2, { 253, 231 } },
    { 58480, 2, { 272, 215 } },
    { 58500, 2, { 250, 234 } },
    { 58520, 2, { 266, 220 } },
    { 58590, 2, { 270, 217 } },
    { 58604, 2, { 299, 196 } },
    { 58608, 2, { 264, 222 } },
    { 58653, 2, { 343, 171 } },
    { 58656, 2, { 282, 208 } },
    { 58692, 2, { 268, 219 } },
    { 58740, 2, { 267, 220 } },
    { 58764, 2, { 249, 236 } },
    { 58776, 2, { 248, 237 } },
    { 58786, 2, { 247, 238 } },
    { 58788, 2, { 276, 213 } },
    { 58800, 2, { 245, 240 } },
    { 58806, 2, { 243, 242 } },
    { 58830, 2, { 265, 222 } },
    { 58880, 2, { 256, 230 } },
    { 59040, 2, { 246, 240 } },
    { 59052, 2, { 259, 228 } },
    { 59136, 2, { 256, 231 } },
    { 59148, 2, { 279, 212 } },
    { 59160, 2, { 255, 232 } },
    { 59202, 2, { 253, 234 } },
    { 59220, 2, { 252, 235 } },
    { 59280, 2, { 247, 240 } },
    { 59290, 2, { 245, 242 } },
    { 59292, 2, { 244, 243 } },
    { 59360, 2, { 265, 224 } },
    { 59364, 2, { 291, 204 } },
    { 59400, 2, { 264, 225 } },
    { 59409, 2, { 287, 207 } },
    { 59500, 2, { 250, 238 } },
    { 59508, 2, { 261, 228 } },
    { 59535, 2, { 245, 243 } },
    { 59568, 2, { 272, 219 } },
    { 59570, 2, { 259, 230 } },
    { 59584, 2, { 266, 224 } },
    { 59625, 2, { 265, 225 } },
    { 59640, 2, { 280, 213 } },
    { 59670, 2, { 255, 234 } },
    { 59675, 2, { 275, 217 } },
    { 59696, 2, { 287, 208 } },
    { 59724, 2, { 252, 237 } },
    { 59760, 2, { 249, 240 } },
    { 59774, 2, { 247, 242 } },
    { 59808, 2, { 267, 224 } },
    { 59850, 2, { 266, 225 } },
    { 59856, 2, { 258, 232 } },
    { 59892, 2, { 276, 217 } },
    { 59904, 2, { 256, 234 } },
    { 59976, 2, { 252, 238 } },
    { 59985, 2, { 279, 215 } },
    { 60000, 2, { 250, 240 } },
    { 60021, 2, { 247, 243 } },
    { 60060, 2, { 260, 231 } },
    { 60088, 2, { 259, 232 } },
    { 60160, 2, { 256, 235 } },
    { 60180, 2, { 255, 236 } },
    { 60200, 2, { 280, 215 } },
    { 60214, 2, { 253, 238 } },
    { 60264, 2, { 248, 243 } },
    { 60270, 2, { 246, 245 } },
    { 60300, 2, { 268, 225 } },
    { 60333, 2, { 273, 221 } },
    { 60384, 2, { 272, 222 } },
    { 60390, 2, { 305, 198 } },
    { 60420, 2, { 265, 228 } },
    { 60444, 2, { 276, 219 } },
    { 60480, 2, { 252, 240 } },
    { 60500, 2, { 250, 242 } },
    { 60515, 2, { 247, 245 } },
    { 60528, 2, { 291, 208 } },
    { 60552, 2, { 261, 232 } },
    { 60588, 2, { 297, 204 } },
    { 60606, 2, { 259, 234 } },
    { 60630, 2, { 258, 235 } },
    { 60672, 2, { 256, 237 } },
    { 60680, 2, { 296, 205 } },
    { 60720, 2, { 253, 240 } },
    { 60750, 2, { 250, 243 } },
    { 60756, 2, { 249, 244 } },
    { 60760, 2, { 248, 245 } },
    { 60775, 2, { 275, 221 } },
    { 60876, 2, { 267, 228 } },
    { 60885, 2, { 297, 205 } },
    { 60912, 2, { 282, 216 } },
    { 60928, 2, { 256, 238 } },
    { 60984, 2, { 252, 242 } },
    { 61008, 2, { 248, 246 } },
    { 61047, 2, { 323, 189 } },
    { 61050, 2, { 275, 222 } },
    { 61065, 2, { 295, 207 } },
    { 61152, 2, { 273, 224 } },
    { 61200, 2, { 255, 240 } },
    { 61236, 2, { 252, 243 } },
    { 61250, 2, { 250, 245 } },
    { 61320, 2, { 280, 219 } },
    { 61335, 2, { 261, 235 } },
    { 61347, 2, { 363, 169 } },
    { 61380, 2, { 279, 220 } },
    { 61425, 2, { 273, 225 } },
    { 61440, 2, { 256, 240 } },
    { 61479, 2, { 253, 243 } },
    { 61480, 2, { 265, 232 } },
    { 61596, 2, { 261, 236 } },
    { 61600, 2, { 275, 224 } },
    { 61620, 2, { 260, 237 } },
    { 61692, 2, { 291, 212 } },
    { 61740, 2, { 252, 245 } },
    { 61750, 2, { 250, 247 } },
    { 61752, 2, { 249, 248 } },
    { 61776, 2, { 264, 234 } },
    { 61812, 2, { 303, 204 } },
    { 61824, 2, { 276, 224 } },
    { 61845, 2, { 285, 217 } },
    { 61875, 2, { 275, 225 } },
    { 61880, 2, { 260, 238 } },
    { 61908, 2, { 268, 231 } },
    { 61920, 2, { 258, 240 } },
    { 61944, 2, { 267, 232 } },
    { 61950, 2, { 295, 210 } },
    { 61952, 2, { 256, 242 } },
    { 61965, 2, { 255, 243 } },
    { 61985, 2, { 253, 245 } },
    { 62010, 2, { 265, 234 } },
    { 62016, 2, { 272, 228 } },
    { 62040, 2, { 264, 235 } },
    { 62073, 2, { 297, 209 } },
    { 62100, 2, { 270, 230 } },
    { 62160, 2, { 259, 240 } },
    { 62181, 2, { 329, 189 } },
    { 62192, 2, { 299, 208 } },
    { 62196, 2, { 284, 219 } },
    { 62205, 2, { 319, 195 } },
    { 62208, 2, { 256, 243 } },
    { 62220, 2, { 255, 244 } },
    { 62244, 2, { 252, 247 } },
    { 62307, 2, { 301, 207 } },
    { 62320, 2, { 304, 205 } },
    { 62370, 2, { 270, 231 } },
    { 62400, 2, { 260, 240 } },
    { 62424, 2, { 289, 216 } },
    { 62560, 2, { 272, 230 } },
    { 62568, 2, { 264, 237 } },
    { 62608, 2, { 301, 208 } },
    { 62640, 2, { 261, 240 } },
    { 62700, 2, { 275, 228 } },
    { 62720, 2, { 256, 245 } },
    { 62748, 2, { 252, 249 } },
    { 62832, 2, { 264, 238 } },
    { 62856, 2, { 291, 216 } },
    { 62930, 2, { 290, 217 } },
    { 62937, 2, { 259, 243 } },
    { 62964, 2, { 297, 212 } },
    { 62976, 2, { 256, 246 } },
    { 62985, 2, { 255, 247 } },
    { 63000, 2, { 252, 250 } },
    { 63012, 2, { 267, 236 } },
    { 63024, 2, { 303, 208 } },
    { 63072, 2, { 288, 219 } },
    { 63135, 2, { 305, 207 } },
    { 63140, 2, { 287, 220 } },
    { 63168, 2, { 282, 224 } },
    { 63175, 2, { 361, 175 } },
    { 63180, 2, { 260, 243 } },
    { 63206, 2, { 286, 221 } },
    { 63210, 2, { 258, 245 } },
    { 63232, 2, { 256, 247 } },
    { 63240, 2, { 255, 248 } },
    { 63250, 2, { 253, 250 } },
    { 63336, 2, { 273, 232 } },
    { 63441, 2, { 371, 171 } },
    { 63450, 2, { 270, 235 } },
    { 63516, 2, { 268, 237 } },
    { 63580, 2, { 289, 220 } },
    { 63600, 2, { 265, 240 } },
    { 63612, 2, { 279, 228 } },
    { 63640, 2, { 296, 215 } },
    { 63648, 2, { 272, 234 } },
    { 63684, 2, { 261, 244 } },
    { 63744, 2, { 256, 249 } },
    { 63756, 2, { 253, 252 } },
    { 63800, 2, { 275, 232 } },
    { 63840, 2, { 266, 240 } },
    { 63855, 2, { 297, 215 } },
    { 63900, 2, { 284, 225 } },
    { 63920, 2, { 272, 235 } },
    { 63936, 2, { 288, 222 } },
    { 63945, 2, { 261, 245 } },
    { 63954, 2, { 306, 209 } },
    { 63984, 2, { 258, 248 } },
    { 64000, 2, { 256, 250 } },
    { 64020, 2, { 291, 220 } },
    { 64050, 2, { 305, 210 } },
    { 64064, 2, { 286, 224 } },
    { 64080, 2, { 267, 240 } },
    { 64141, 2, { 343, 187 } },
    { 64152, 2, { 264, 243 } },
    { 64220, 2, { 260, 247 } },
    { 64232, 2, { 259, 248 } },
    { 64236, 2, { 303, 212 } },
    { 64260, 2, { 255, 252 } },
    { 64272, 2, { 309, 208 } },
    { 64288, 2, { 287, 224 } },
    { 64350, 2, { 275, 234 } },
    { 64395, 2, { 265, 243 } },
    { 64428, 2, { 273, 236 } },
    { 64464, 2, { 272, 237 } },
    { 64512, 2, { 256, 252 } },
    { 64515, 2, { 255, 253 } },
    { 64575, 2, { 287, 225 } },
    { 64600, 2, { 323, 200 } },
    { 64638, 2, { 266, 243 } },
    { 64680, 2, { 264, 245 } },
    { 64728, 2, { 261, 248 } },
    { 64740, 2, { 260, 249 } },
    { 64750, 2, { 259, 250 } },
    { 64768, 2, { 256, 253 } },
    { 64800, 2, { 270, 240 } },
    { 64827, 2, { 343, 189 } },
    { 64860, 2, { 276, 235 } },
    { 64944, 2, { 264, 246 } },
    { 64980, 2, { 285, 228 } },
    { 65065, 2, { 385, 169 } },
    { 65076, 2, { 319, 204 } },
    { 65100, 2, { 300, 217 } },
    { 65124, 2, { 268, 243 } },
    { 65148, 2, { 267, 244 } },
    { 65184, 2, { 291, 224 } },
    { 65190, 2, { 265, 246 } },
    { 65208, 2, { 264, 247 } },
    { 65268, 2, { 259, 252 } },
    { 65280, 2, { 256, 255 } },
    { 65340, 2, { 270, 242 } },
    { 65360, 2, { 304, 215 } },
    { 65412, 2, { 276, 237 } },
    { 65424, 2, { 282, 232 } },
    { 65448, 2, { 303, 216 } },
    { 65450, 2, { 275, 238 } },
    { 65490, 2, { 295, 222 } },
    { 65508, 2, { 309, 212 } },
    { 65520, 2, { 260, 252 } },
    { 65565, 2, { 279, 235 } },
    { 65600, 2, { 320, 205 } },
    { 65604, 2, { 284, 231 } },
    { 65637, 2, { 297, 221 } },
    { 65664, 2, { 288, 228 } },
    { 65700, 2, { 292, 225 } },
    { 65720, 2, { 265, 248 } },
    { 65736, 2, { 264, 249 } },
    { 65772, 2, { 261, 252 } },
    { 65780, 2, { 260, 253 } },
    { 65800, 2, { 280, 235 } },
    { 65844, 2, { 279, 236 } },
    { 65856, 2, { 294, 224 } },
    { 65975, 2, { 325, 203 } },
    { 66000, 2, { 264, 250 } },
    { 66010, 2, { 287, 230 } },
    { 66045, 2, { 259, 255 } },
    { 66048, 2, { 258, 256 } },
    { 66096, 2, { 272, 243 } },
    { 66120, 2, { 285, 232 } },
    { 66125, 2, { 529, 125 } },
    { 66150, 2, { 270, 245 } },
    { 66216, 2, { 267, 248 } },
    { 66220, 2, { 301, 220 } },
    { 66240, 2, { 276, 240 } },
    { 66248, 2, { 338, 196 } },
    { 66300, 2, { 260, 255 } },
    { 66304, 2, { 259, 256 } },
    { 66339, 2, { 273, 243 } },
    { 66348, 2, { 291, 228 } },
    { 66360, 2, { 280, 237 } },
    { 66375, 2, { 295, 225 } },
    { 66495, 2, { 341, 195 } },
    { 66500, 2, { 266, 250 } },
    { 66560, 2, { 260, 256 } },
    { 66584, 2, { 287, 232 } },
    { 66600, 2, { 296, 225 } },
    { 66612, 2, { 273, 244 } },
    { 66640, 2, { 272, 245 } },
    { 66660, 2, { 303, 220 } },
    { 66690, 2, { 270, 247 } },
    { 66732, 2, { 268, 249 } },
    { 66744, 2, { 309, 216 } },
    { 66759, 2, { 289, 231 } },
    { 66780, 2, { 265, 252 } },
    { 66792, 2, { 264, 253 } },
    { 66816, 2, { 261, 256 } },
    { 66825, 2, { 275, 243 } },
    { 66912, 2, { 272, 246 } },
    { 66960, 2, { 270, 248 } },
    { 66976, 2, { 299, 224 } },
    { 67032, 2, { 266, 252 } },
    { 67068, 2, { 276, 243 } },
    { 67184, 2, { 272, 247 } },
    { 67200, 2, { 280, 240 } },
    { 67260, 2, { 285, 236 } },
    { 67275, 2, { 299, 225 } },
    { 67284, 2, { 267, 252 } },
    { 67298, 2, { 266, 253 } },
    { 67308, 2, { 284, 237 } },
    { 67320, 2, { 264, 255 } },
    { 67340, 2, { 260, 259 } },
    { 67392, 2, { 288, 234 } },
    { 67424, 2, { 301, 224 } },
    { 67431, 2, { 273, 247 } },
    { 67452, 2, { 292, 231 } },
    { 67473, 2, { 357, 189 } },
    { 67500, 2, { 270, 250 } },
    { 67512, 2, { 291, 232 } },
    { 67584, 2, { 264, 256 } },
    { 67599, 2, { 261, 259 } },
    { 67620, 2, { 276, 245 } },
    { 67626, 2, { 289, 234 } },
    { 67650, 2, { 275, 246 } },
    { 67680, 2, { 282, 240 } },
    { 67704, 2, { 273, 248 } },
    { 67710, 2, { 305, 222 } },
    { 67716, 2, { 297, 228 } },
    { 67725, 2, { 301, 225 } },
    { 67728, 2, { 272, 249 } },
    { 67760, 2, { 280, 242 } },
    { 67830, 2, { 266, 255 } },
    { 67840, 2, { 265, 256 } },
    { 67860, 2, { 261, 260 } },
    { 67872, 2, { 303, 224 } },
    { 67925, 2, { 275, 247 } },
    { 67980, 2, { 309, 220 } },
    { 68000, 2, { 272, 250 } },
    { 68076, 2, { 279, 244 } },
    { 68096, 2, { 266, 256 } },
    { 68103, 2, { 329, 207 } },
    { 68112, 2, { 264, 258 } },
    { 68200, 2, { 275, 248 } },
    { 68208, 2, { 294, 232 } },
    { 68229, 2, { 361, 189 } },
    { 68250, 2, { 273, 250 } },
    { 68256, 2, { 288, 237 } },
    { 68265, 2, { 333, 205 } },
    { 68310, 2, { 270, 253 } },
    { 68340, 2, { 268, 255 } },
    { 68352, 2, { 267, 256 } },
    { 68355, 2, { 279, 245 } },
    { 68370, 2, { 265, 258 } },
    { 68376, 2, { 264, 259 } },
    { 68400, 2, { 285, 240 } },
    { 68425, 2, { 391, 175 } },
    { 68432, 2, { 329, 208 } },
    { 68544, 2, { 272, 252 } },
    { 68600, 2, { 280, 245 } },
    { 68625, 2, { 305, 225 } },
    { 68640, 2, { 264, 260 } },
    { 68676, 2, { 291, 236 } },
    { 68688, 2, { 318, 216 } },
    { 68724, 2, { 276, 249 } },
    { 68796, 2, { 273, 252 } },
    { 68800, 2, { 320, 215 } },
    { 68816, 2, { 272, 253 } },
    { 68850, 2, { 270, 255 } },
    { 68880, 2, { 280, 246 } },
    { 68904, 2, { 264, 261 } },
    { 68952, 2, { 312, 221 } },
    { 68992, 2, { 308, 224 } },
    { 69000, 2, { 276, 250 } },
    { 69012, 2, { 284, 243 } },
    { 69030, 2, { 295, 234 } },
    { 69069, 2, { 273, 253 } },
    { 69084, 2, { 303, 228 } },
    { 69090, 2, { 282, 245 } },
    { 69120, 2, { 270, 256 } },
    { 69160, 2, { 266, 260 } },
    { 69165, 2, { 265, 261 } },
    { 69192, 2, { 279, 248 } },
    { 69204, 2, { 292, 237 } },
    { 69216, 2, { 309, 224 } },
    { 69230, 2, { 301, 230 } },
    { 69255, 2, { 285, 243 } },
    { 69264, 2, { 296, 234 } },
    { 69300, 2, { 275, 252 } },
    { 69336, 2, { 321, 216 } },
    { 69345, 2, { 335, 207 } },
    { 69360, 2, { 272, 255 } },
    { 69420, 2, { 267, 260 } },
    { 69498, 2, { 286, 243 } },
    { 69540, 2, { 285, 244 } },
    { 69560, 2, { 296, 235 } },
    { 69564, 2, { 341, 204 } },
    { 69575, 2, { 275, 253 } },
    { 69600, 2, { 290, 240 } },
    { 69720, 2, { 280, 249 } },
    { 69741, 2, { 287, 243 } },
    { 69795, 2, { 297, 235 } },
    { 69832, 2, { 301, 232 } },
    { 69840, 2, { 291, 240 } },
    { 69888, 2, { 273, 256 } },
    { 69920, 2, { 304, 230 } },
    { 69930, 2, { 270, 259 } },
    { 69936, 2, { 282, 248 } },
    { 69938, 2, { 289, 242 } },
    { 69948, 2, { 268, 261 } },
    { 69960, 2, { 265, 264 } },
    { 69966, 2, { 299, 234 } },
    { 69984, 2, { 288, 243 } },
    { 70035, 2, { 345, 203 } },
    { 70070, 2, { 286, 245 } },
    { 70092, 2, { 297, 236 } },
    { 70119, 2, { 371, 189 } },
    { 70152, 2, { 296, 237 } },
    { 70176, 2, { 272, 258 } },
    { 70200, 2, { 270, 260 } },
    { 70224, 2, { 266, 264 } },
    { 70227, 2, { 289, 243 } },
    { 70296, 2, { 303, 232 } },
    { 70308, 2, { 279, 252 } },
    { 70350, 2, { 335, 210 } },
    { 70380, 2, { 276, 255 } },
    { 70400, 2, { 275, 256 } },
    { 70448, 2, { 272, 259 } },
    { 70452, 2, { 309, 228 } },
    { 70488, 2, { 267, 264 } },
    { 70520, 2, { 328, 215 } },
    { 70525, 2, { 325, 217 } },
    { 70620, 2, { 321, 220 } },
    { 70642, 2, { 286, 247 } },
    { 70656, 2, { 276, 256 } },
    { 70680, 2, { 285, 248 } },
    { 70686, 2, { 297, 238 } },
    { 70716, 2, { 284, 249 } },
    { 70800, 2, { 295, 240 } },
    { 70805, 2, { 289, 245 } },
    { 70840, 2, { 280, 253 } },
    { 70848, 2, { 288, 246 } },
    { 70950, 2, { 275, 258 } },
    { 70956, 2, { 292, 243 } },
    { 70980, 2, { 273, 260 } },
    { 70992, 2, { 272, 261 } },
    { 71001, 2, { 343, 207 } },
    { 71004, 2, { 291, 244 } },
    { 71060, 2, { 323, 220 } },
    { 71100, 2, { 300, 237 } },
    { 71136, 2, { 288, 247 } },
    { 71148, 2, { 294, 242 } },
    { 71162, 2, { 299, 238 } },
    { 71176, 2, { 287, 248 } },
    { 71225, 2, { 275, 259 } },
    { 71232, 2, { 318, 224 } },
    { 71280, 2, { 270, 264 } },
    { 71344, 2, { 343, 208 } },
    { 71370, 2, { 305, 234 } },
    { 71400, 2, { 280, 255 } },
    { 71424, 2, { 279, 256 } },
    { 71440, 2, { 304, 235 } },
    { 71442, 2, { 294, 243 } },
    { 71484, 2, { 276, 259 } },
    { 71508, 2, { 303, 236 } },
    { 71550, 2, { 270, 265 } },
    { 71556, 2, { 268, 267 } },
    { 71595, 2, { 333, 215 } },
    { 71680, 2, { 280, 256 } },
    { 71685, 2, { 295, 243 } },
    { 71687, 2, { 343, 209 } },
    { 71688, 2, { 309, 232 } },
    { 71712, 2, { 288, 249 } },
    { 71750, 2, { 287, 250 } },
    { 71775, 2, { 275, 261 } },
    { 71820, 2, { 270, 266 } },
    { 71825, 2, { 325, 221 } },
    { 71904, 2, { 321, 224 } },
    { 71928, 2, { 296, 243 } },
    { 71940, 2, { 327, 220 } },
    { 71955, 2, { 351, 205 } },
    { 71995, 2, { 385, 187 } },
    { 72000, 2, { 288, 250 } },
    { 72036, 2, { 276, 261 } },
    { 72048, 2, { 304, 237 } },
    { 72072, 2, { 273, 264 } },
    { 72080, 2, { 272, 265 } },
    { 72105, 2, { 285, 253 } },
    { 72128, 2, { 322, 224 } },
    { 72150, 2, { 325, 222 } },
    { 72168, 2, { 291, 248 } },
    { 72192, 2, { 282, 256 } },
    { 72200, 2, { 361, 200 } },
    { 72240, 2, { 280, 258 } },
    { 72250, 2, { 289, 250 } },
    { 72261, 2, { 279, 259 } },
    { 72324, 2, { 287, 252 } },
    { 72352, 2, { 272, 266 } },
    { 72420, 2, { 284, 255 } },
    { 72468, 2, { 297, 244 } },
    { 72520, 2, { 280, 259 } },
    { 72540, 2, { 279, 260 } },
    { 72570, 2, { 295, 246 } },
    { 72576, 2, { 288, 252 } },
    { 72600, 2, { 275, 264 } },
    { 72624, 2, { 272, 267 } },
    { 72657, 2, { 299, 243 } },
    { 72708, 2, { 292, 249 } },
    { 72720, 2, { 303, 240 } },
    { 72732, 2, { 319, 228 } },
    { 72765, 2, { 297, 245 } },
    { 72816, 2, { 296, 246 } },
    { 72828, 2, { 289, 252 } },
    { 72912, 2, { 294, 248 } },
    { 72924, 2, { 309, 236 } },
    { 72960, 2, { 285, 256 } },
    { 72996, 2, { 308, 237 } },
    { 73080, 2, { 280, 261 } },
    { 73125, 2, { 325, 225 } },
    { 73140, 2, { 276, 265 } },
    { 73143, 2, { 301, 243 } },
    { 73150, 2, { 275, 266 } },
    { 73160, 2, { 295, 248 } },
    { 73164, 2, { 273, 268 } },
    { 73185, 2, { 287, 255 } },
    { 73188, 2, { 321, 228 } },
    { 73216, 2, { 286, 256 } },
    { 73248, 2, { 327, 224 } },
    { 73255, 2, { 299, 245 } },
    { 73332, 2, { 291, 252 } },
    { 73359, 2, { 297, 247 } },
    { 73440, 2, { 272, 270 } },
    { 73472, 2, { 287, 256 } },
    { 73500, 2, { 294, 250 } },
    { 73515, 2, { 377, 195 } },
    { 73600, 2, { 320, 230 } },
    { 73656, 2, { 279, 264 } },
    { 73689, 2, { 319, 231 } },
    { 73692, 2, { 276, 267 } },
    { 73696, 2, { 329, 224 } },
    { 73704, 2, { 296, 249 } },
    { 73710, 2, { 273, 270 } },
    { 73728, 2, { 288, 256 } },
    { 73776, 2, { 318, 232 } },
    { 73815, 2, { 285, 259 } },
    { 73872, 2, { 304, 243 } },
    { 73932, 2, { 303, 244 } },
    { 73935, 2, { 279, 265 } },
    { 73944, 2, { 312, 237 } },
    { 74025, 2, { 315, 235 } },
    { 74100, 2, { 285, 260 } },
    { 74115, 2, { 305, 243 } },
    { 74124, 2, { 284, 261 } },
    { 74160, 2, { 309, 240 } },
    { 74200, 2, { 280, 265 } },
    { 74240, 2, { 290, 256 } },
    { 74250, 2, { 275, 270 } },
    { 74256, 2, { 273, 272 } },
    { 74304, 2, { 288, 258 } },
    { 74340, 2, { 295, 252 } },
    { 74370, 2, { 335, 222 } },
    { 74382, 2, { 294, 253 } },
    { 74448, 2, { 282, 264 } },
    { 74460, 2, { 292, 255 } },
    { 74472, 2, { 321, 232 } },
    { 74480, 2, { 280, 266 } },
    { 74496, 2, { 291, 256 } },
    { 74556, 2, { 327, 228 } },
    { 74592, 2, { 288, 259 } },
    { 74613, 2, { 323, 231 } },
    { 74620, 2, { 287, 260 } },
    { 74648, 2, { 301, 248 } },
    { 74700, 2, { 300, 249 } },
    { 74730, 2, { 282, 265 } },
    { 74750, 2, { 299, 250 } },
    { 74760, 2, { 280, 267 } },
    { 74772, 2, { 279, 268 } },
    { 74784, 2, { 304, 246 } },
    { 74800, 2, { 275, 272 } },
    { 74844, 2, { 297, 252 } },
    { 74865, 2, { 345, 217 } },
    { 74880, 2, { 288, 260 } },
    { 74907, 2, { 287, 261 } },
    { 75030, 2, { 305, 246 } },
    { 75072, 2, { 276, 272 } },
    { 75075, 2, { 275, 273 } },
    { 75110, 2, { 290, 259 } },
    { 75140, 2, { 289, 260 } },
    { 75141, 2, { 297, 253 } },
    { 75144, 2, { 303, 248 } },
    { 75168, 2, { 288, 261 } },
    { 75200, 2, { 320, 235 } },
    { 75240, 2, { 285, 264 } },
    { 75250, 2, { 301, 250 } },
    { 75264, 2, { 294, 256 } },
    { 75348, 2, { 276, 273 } },
    { 75375, 2, { 335, 225 } },
    { 75396, 2, { 309, 244 } },
    { 75411, 2, { 399, 189 } },
    { 75465, 2, { 351, 215 } },
    { 75480, 2, { 296, 255 } },
    { 75504, 2, { 286, 264 } },
    { 75516, 2, { 348, 217 } },
    { 75520, 2, { 295, 256 } },
    { 75582, 2, { 306, 247 } },
    { 75600, 2, { 280, 270 } },
    { 75640, 2, { 305, 248 } },
    { 75660, 2, { 291, 260 } },
    { 75696, 2, { 304, 249 } },
    { 75712, 2, { 338, 224 } },
    { 75735, 2, { 297, 255 } },
    { 75756, 2, { 321, 236 } },
    { 75768, 2, { 287, 264 } },
    { 75803, 2, { 343, 221 } },
    { 75816, 2, { 312, 243 } },
    { 75828, 2, { 284, 267 } },
    { 75864, 2, { 327, 232 } },
    { 75888, 2, { 279, 272 } },
    { 75900, 2, { 276, 275 } },
    { 75922, 2, { 319, 238 } },
    { 75924, 2, { 333, 228 } },
    { 76000, 2, { 304, 250 } },
    { 76032, 2, { 288, 264 } },
    { 76050, 2, { 325, 234 } },
    { 76110, 2, { 295, 258 } },
    { 76125, 2, { 375, 203 } },
    { 76212, 2, { 292, 261 } },
    { 76230, 2, { 315, 242 } },
    { 76245, 2, { 299, 255 } },
    { 76296, 2, { 289, 264 } },
    { 76320, 2, { 288, 265 } },
    { 76328, 2, { 329, 232 } },
    { 76356, 2, { 303, 252 } },
    { 76368, 2, { 296, 258 } },
    { 76380, 2, { 285, 268 } },
    { 76440, 2, { 280, 273 } },
    { 76475, 2, { 437, 175 } },
    { 76500, 2, { 300, 255 } },
    { 76544, 2, { 299, 256 } },
    { 76545, 2, { 315, 243 } },
    { 76560, 2, { 290, 264 } },
    { 76608, 2, { 288, 266 } },
    { 76632, 2, { 309, 248 } },
    { 76692, 2, { 308, 249 } },
    { 76704, 2, { 282, 272 } },
    { 76725, 2, { 279, 275 } },
    { 76752, 2, { 312, 246 } },
    { 76755, 2, { 301, 255 } },
    { 76788, 2, { 316, 243 } },
    { 76797, 2, { 371, 207 } },
    { 76800, 2, { 300, 256 } },
    { 76824, 2, { 291, 264 } },
    { 76832, 2, { 343, 224 } },
    { 76860, 2, { 305, 252 } },
    { 76896, 2, { 288, 267 } },
    { 76912, 2, { 304, 253 } },
    { 76923, 2, { 297, 259 } },
    { 76950, 2, { 285, 270 } },
    { 76995, 2, { 295, 261 } },
    { 77000, 2, { 280, 275 } },
    { 77004, 2, { 279, 276 } },
    { 77040, 2, { 321, 240 } },
    { 77056, 2, { 301, 256 } },
    { 77064, 2, { 312, 247 } },
    { 77077, 2, { 539, 143 } },
    { 77080, 2, { 328, 235 } },
    { 77172, 2, { 327, 236 } },
    { 77175, 2, { 315, 245 } },
    { 77220, 2, { 286, 270 } },
    { 77256, 2, { 296, 261 } },
    { 77292, 2, { 339, 228 } },
    { 77350, 2, { 325, 238 } },
    { 77418, 2, { 306, 253 } },
    { 77440, 2, { 320, 242 } },
    { 77490, 2, { 287, 270 } },
    { 77520, 2, { 285, 272 } },
    { 77532, 2, { 284, 273 } },
    { 77550, 2, { 282, 275 } },
    { 77568, 2, { 303, 256 } },
    { 77571, 2, { 351, 221 } },
    { 77616, 2, { 294, 264 } },
    { 77688, 2, { 312, 249 } },
    { 77700, 2, { 300, 259 } },
    { 77740, 2, { 299, 260 } },
    { 77748, 2, { 341, 228 } },
    { 77760, 2, { 288, 270 } },
    { 77868, 2, { 309, 252 } },
    { 77880, 2, { 295, 264 } },
    { 77910, 2, { 294, 265 } },
    { 77924, 2, { 308, 253 } },
    { 77964, 2, { 292, 267 } },
    { 77988, 2, { 291, 268 } },
    { 78030, 2, { 289, 270 } },
    { 78057, 2, { 413, 189 } },
    { 78064, 2, { 287, 272 } },
    { 78080, 2, { 305, 256 } },
    { 78120, 2, { 280, 279 } },
    { 78155, 2, { 319, 245 } },
    { 78166, 2, { 323, 242 } },
    { 78246, 2, { 322, 243 } },
    { 78255, 2, { 333, 235 } },
    { 78260, 2, { 301, 260 } },
    { 78300, 2, { 290, 270 } },
    { 78324, 2, { 321, 244 } },
    { 78390, 2, { 335, 234 } },
    { 78408, 2, { 297, 264 } },
    { 78432, 2, { 304, 258 } },
    { 78440, 2, { 296, 265 } },
    { 78480, 2, { 327, 240 } },
    { 78489, 2, { 323, 243 } },
    { 78540, 2, { 308, 255 } },
    { 78561, 2, { 301, 261 } },
    { 78585, 2, { 403, 195 } },
    { 78588, 2, { 333, 236 } },
    { 78624, 2, { 288, 273 } },
    { 78648, 2, { 339, 232 } },
    { 78650, 2, { 286, 275 } },
    { 78660, 2, { 285, 276 } },
    { 78684, 2, { 316, 249 } },
    { 78690, 2, { 305, 258 } },
    { 78705, 2, { 297, 265 } },
    { 78720, 2, { 320, 246 } },
    { 78771, 2, { 341, 231 } },
    { 78780, 2, { 303, 260 } },
    { 78810, 2, { 355, 222 } },
    { 78848, 2, { 308, 256 } },
    { 78864, 2, { 318, 248 } },
    { 78880, 2, { 290, 272 } },
    { 78897, 2, { 289, 273 } },
    { 78925, 2, { 287, 275 } },
    { 78960, 2, { 282, 280 } },
    { 78975, 2, { 325, 243 } },
    { 79002, 2, { 297, 266 } },
    { 79032, 2, { 296, 267 } },
    { 79104, 2, { 309, 256 } },
    { 79135, 2, { 323, 245 } },
    { 79152, 2, { 291, 272 } },
    { 79200, 2, { 288, 275 } },
    { 79212, 2, { 287, 276 } },
    { 79236, 2, { 284, 279 } },
    { 79254, 2, { 306, 259 } },
    { 79335, 2, { 369, 215 } },
    { 79344, 2, { 304, 261 } },
    { 79360, 2, { 310, 256 } },
    { 79365, 2, { 407, 195 } },
    { 79380, 2, { 294, 270 } },
    { 79420, 2, { 361, 220 } },
    { 79464, 2, { 301, 264 } },
    { 79475, 2, { 289, 275 } },
    { 79488, 2, { 288, 276 } },
    { 79500, 2, { 300, 265 } },
    { 79534, 2, { 299, 266 } },
    { 79576, 2, { 343, 232 } },
    { 79596, 2, { 297, 268 } },
    { 79605, 2, { 305, 261 } },
    { 79608, 2, { 321, 248 } },
    { 79650, 2, { 295, 270 } },
    { 79680, 2, { 320, 249 } },
    { 79695, 2, { 315, 253 } },
    { 79716, 2, { 292, 273 } },
    { 79788, 2, { 327, 244 } },
    { 79800, 2, { 285, 280 } },
    { 79872, 2, { 312, 256 } },
    { 79875, 2, { 355, 225 } },
    { 79920, 2, { 296, 270 } },
    { 79947, 2, { 329, 243 } },
    { 79950, 2, { 325, 246 } },
    { 79968, 2, { 294, 272 } },
    { 79992, 2, { 303, 264 } },
    { 80000, 2, { 320, 250 } },
    { 80004, 2, { 339, 236 } },
    { 80028, 2, { 324, 247 } },
    { 80040, 2, { 290, 276 } },
    { 80073, 2, { 287, 279 } },
    { 80080, 2, { 286, 280 } },
    { 80100, 2, { 300, 267 } },
    { 80223, 2, { 363, 221 } },
    { 80240, 2, { 295, 272 } },
    { 80275, 2, { 325, 247 } },
    { 80290, 2, { 310, 259 } },
    { 80316, 2, { 291, 276 } },
    { 80340, 2, { 309, 260 } },
    { 80352, 2, { 288, 279 } },
    { 80360, 2, { 287, 280 } },
    { 80388, 2, { 308, 261 } },
    { 80465, 2, { 385, 209 } },
    { 80496, 2, { 312, 258 } },
    { 80500, 2, { 322, 250 } },
    { 80520, 2, { 305, 264 } },
    { 80560, 2, { 304, 265 } },
    { 80580, 2, { 316, 255 } },
    { 80640, 2, { 288, 280 } },
    { 80676, 2, { 324, 249 } },
    { 80703, 2, { 427, 189 } },
    { 80730, 2, { 299, 270 } },
    { 80750, 2, { 323, 250 } },
    { 80784, 2, { 297, 272 } },
    { 80808, 2, { 296, 273 } },
    { 80840, 2, { 344, 235 } },
    { 80850, 2, { 294, 275 } },
    { 80892, 2, { 321, 252 } },
    { 80920, 2, { 289, 280 } },
    { 80940, 2, { 285, 284 } },
    { 80960, 2, { 320, 253 } },
    { 81030, 2, { 365, 222 } },
    { 81081, 2, { 297, 273 } },
    { 81090, 2, { 306, 265 } },
    { 81096, 2, { 327, 248 } },
    { 81158, 2, { 341, 238 } },
    { 81168, 2, { 304, 267 } },
    { 81204, 2, { 303, 268 } },
    { 81216, 2, { 288, 282 } },
    { 81252, 2, { 333, 244 } },
    { 81270, 2, { 301, 270 } },
    { 81328, 2, { 299, 272 } },
    { 81345, 2, { 319, 255 } },
    { 81360, 2, { 339, 240 } },
    { 81375, 2, { 375, 217 } },
    { 81396, 2, { 306, 266 } },
    { 81400, 2, { 296, 275 } },
    { 81405, 2, { 335, 243 } },
    { 81408, 2, { 318, 256 } },
    { 81420, 2, { 295, 276 } },
    { 81432, 2, { 312, 261 } },
    { 81468, 2, { 292, 279 } },
    { 81480, 2, { 291, 280 } },
    { 81536, 2, { 364, 224 } },
    { 81576, 2, { 309, 264 } },
    { 81585, 2, { 315, 259 } },
    { 81592, 2, { 329, 248 } },
    { 81600, 2, { 300, 272 } },
    { 81627, 2, { 299, 273 } },
    { 81664, 2, { 319, 256 } },
    { 81672, 2, { 328, 249 } },
    { 81675, 2, { 297, 275 } },
    { 81795, 2, { 287, 285 } },
    { 81840, 2, { 310, 264 } },
    { 81872, 2, { 301, 272 } },
    { 81900, 2, { 300, 273 } },
    { 81972, 2, { 297, 276 } },
    { 82080, 2, { 288, 285 } },
    { 82110, 2, { 322, 255 } },
    { 82125, 2, { 365, 225 } },
    { 82134, 2, { 338, 243 } },
    { 82176, 2, { 321, 256 } },
    { 82225, 2, { 299, 275 } },
    { 82236, 2, { 308, 267 } },
    { 82250, 2, { 329, 250 } },
    { 82305, 2, { 295, 279 } },
    { 82320, 2, { 294, 280 } },
    { 82350, 2, { 305, 270 } },
    { 82368, 2, { 288, 286 } },
    { 82404, 2, { 327, 252 } },
    { 82410, 2, { 335, 246 } },
    { 82416, 2, { 303, 272 } },
    { 82432, 2, { 322, 256 } },
    { 82476, 2, { 316, 261 } },
    { 82485, 2, { 351, 235 } },
    { 82500, 2, { 300, 275 } },
    { 82560, 2, { 320, 258 } },
    { 82584, 2, { 296, 279 } },
    { 82600, 2, { 295, 280 } },
    { 82644, 2, { 291, 284 } },
    { 82654, 2, { 289, 286 } },
    { 82656, 2, { 288, 287 } },
    { 82680, 2, { 312, 265 } },
    { 82716, 2, { 339, 244 } },
    { 82720, 2, { 352, 235 } },
    { 82775, 2, { 301, 275 } },
    { 82810, 2, { 338, 245 } },
    { 82812, 2, { 309, 268 } },
    { 82836, 2, { 351, 236 } },
    { 82960, 2, { 305, 272 } },
    { 82992, 2, { 304, 273 } },
    { 83006, 2, { 343, 242 } },
    { 83070, 2, { 355, 234 } },
    { 83076, 2, { 301, 276 } },
    { 83104, 2, { 371, 224 } },
    { 83160, 2, { 297, 280 } },
    { 83190, 2, { 295, 282 } },
    { 83200, 2, { 320, 260 } },
    { 83220, 2, { 292, 285 } },
    { 83230, 2, { 290, 287 } },
    { 83232, 2, { 289, 288 } },
    { 83304, 2, { 312, 267 } },
    { 83349, 2, { 343, 243 } },
    { 83391, 2, { 361, 231 } },
    { 83460, 2, { 321, 260 } },
    { 83472, 2, { 296, 282 } },
    { 83475, 2, { 315, 265 } },
    { 83490, 2, { 330, 253 } },
    { 83520, 2, { 290, 288 } },
    { 83545, 2, { 341, 245 } },
    { 83600, 2, { 304, 275 } },
    { 83628, 2, { 303, 276 } },
    { 83640, 2, { 328, 255 } },
    { 83700, 2, { 300, 279 } },
    { 83712, 2, { 327, 256 } },
    { 83720, 2, { 299, 280 } },
    { 83808, 2, { 291, 288 } },
    { 83835, 2, { 345, 243 } },
    { 83850, 2, { 325, 258 } },
    { 83895, 2, { 329, 255 } },
    { 83904, 2, { 304, 276 } },
    { 83916, 2, { 324, 259 } },
    { 83952, 2, { 318, 264 } },
    { 83979, 2, { 301, 279 } },
    { 83980, 2, { 323, 260 } },
    { 84048, 2, { 309, 272 } },
    { 84072, 2, { 339, 248 } },
    { 84084, 2, { 294, 286 } },
    { 84150, 2, { 306, 275 } },
    { 84175, 2, { 325, 259 } },
    { 84180, 2, { 305, 276 } },
    { 84216, 2, { 319, 264 } },
    { 84224, 2, { 329, 256 } },
    { 84240, 2, { 312, 270 } },
    { 84280, 2, { 301, 280 } },
    { 84320, 2, { 310, 272 } },
    { 84348, 2, { 297, 284 } },
    { 84360, 2, { 296, 285 } },
    { 84372, 2, { 316, 267 } },
    { 84420, 2, { 315, 268 } },
    { 84480, 2, { 320, 264 } },
    { 84564, 2, { 324, 261 } },
    { 84624, 2, { 328, 258 } },
    { 84645, 2, { 297, 285 } },
    { 84660, 2, { 332, 255 } },
    { 84672, 2, { 294, 288 } },
    { 84721, 2, { 343, 247 } },
    { 84744, 2, { 321, 264 } },
    { 84800, 2, { 320, 265 } },
    { 84816, 2, { 304, 279 } },
    { 84825, 2, { 325, 261 } },
    { 84840, 2, { 303, 280 } },
    { 84854, 2, { 319, 266 } },
    { 84942, 2, { 297, 286 } },
    { 84952, 2, { 296, 287 } },
    { 84960, 2, { 295, 288 } },
    { 84966, 2, { 294, 289 } },
    { 84972, 2, { 292, 291 } },
    { 85020, 2, { 327, 260 } },
    { 85050, 2, { 315, 270 } },
    { 85064, 2, { 343, 248 } },
    { 85085, 2, { 385, 221 } },
    { 85095, 2, { 305, 279 } },
    { 85176, 2, { 312, 273 } },
    { 85215, 2, { 299, 285 } },
    { 85239, 2, { 297, 287 } },
    { 85272, 2, { 323, 264 } },
    { 85284, 2, { 309, 276 } },
    { 85400, 2, { 305, 280 } },
    { 85410, 2, { 365, 234 } },
    { 85428, 2, { 339, 252 } },
    { 85440, 2, { 320, 267 } },
    { 85470, 2, { 330, 259 } },
    { 85491, 2, { 413, 207 } },
    { 85500, 2, { 300, 285 } },
    { 85514, 2, { 299, 286 } },
    { 85536, 2, { 297, 288 } },
    { 85540, 2, { 329, 260 } },
    { 85560, 2, { 310, 276 } },
    { 85608, 2, { 328, 261 } },
    { 85644, 2, { 351, 244 } },
    { 85680, 2, { 306, 280 } },
    { 85728, 2, { 304, 282 } },
    { 85750, 2, { 343, 250 } },
    { 85785, 2, { 301, 285 } },
    { 85800, 2, { 300, 286 } },
    { 85833, 2, { 297, 289 } },
    { 85869, 2, { 329, 261 } },
    { 85932, 2, { 308, 279 } },
    { 85995, 2, { 315, 273 } },
    { 86010, 2, { 305, 282 } },
    { 86016, 2, { 336, 256 } },
    { 86020, 2, { 340, 253 } },
    { 86028, 2, { 321, 268 } },
    { 86052, 2, { 303, 284 } },
    { 86072, 2, { 371, 232 } },
    { 86100, 2, { 300, 287 } },
    { 86112, 2, { 299, 288 } },
    { 86130, 2, { 297, 290 } },
    { 86136, 2, { 296, 291 } },
    { 86184, 2, { 324, 266 } },
    { 86240, 2, { 308, 280 } },
    { 86265, 2, { 355, 243 } },
    { 86268, 2, { 316, 273 } },
    { 86275, 2, { 425, 203 } },
    { 86328, 2, { 327, 264 } },
    { 86400, 2, { 300, 288 } },
    { 86430, 2, { 335, 258 } },
    { 86450, 2, { 325, 266 } },
    { 86480, 2, { 368, 235 } },
    { 86496, 2, { 318, 272 } },
    { 86508, 2, { 324, 267 } },
    { 86520, 2, { 309, 280 } },
    { 86526, 2, { 342, 253 } },
    { 86528, 2, { 338, 256 } },
    { 86580, 2, { 333, 260 } },
    { 86625, 2, { 315, 275 } },
    { 86640, 2, { 304, 285 } },
    { 86652, 2, { 332, 261 } },
    { 86688, 2, { 301, 288 } },
    { 86697, 2, { 351, 247 } },
    { 86700, 2, { 300, 289 } },
    { 86715, 2, { 369, 235 } },
    { 86724, 2, { 297, 292 } },
    { 86730, 2, { 295, 294 } },
    { 86751, 2, { 357, 243 } },
    { 86768, 2, { 319, 272 } },
    { 86779, 2, { 343, 253 } },
    { 86784, 2, { 339, 256 } },
    { 86920, 2, { 328, 265 } },
    { 86940, 2, { 315, 276 } },
    { 86955, 2, { 341, 255 } },
    { 87000, 2, { 300, 290 } },
    { 87024, 2, { 296, 294 } },
    { 87048, 2, { 312, 279 } },
    { 87087, 2, { 319, 273 } },
    { 87108, 2, { 357, 244 } },
    { 87120, 2, { 330, 264 } },
    { 87210, 2, { 306, 285 } },
    { 87248, 2, { 304, 287 } },
    { 87264, 2, { 303, 288 } },
    { 87290, 2, { 301, 290 } },
    { 87296, 2, { 341, 256 } },
    { 87300, 2, { 300, 291 } },
    { 87312, 2, { 321, 272 } },
    { 87320, 2, { 296, 295 } },
    { 87330, 2, { 355, 246 } },
    { 87362, 2, { 361, 242 } },
    { 87435, 2, { 335, 261 } },
    { 87450, 2, { 318, 275 } },
    { 87465, 2, { 343, 255 } },
    { 87576, 2, { 328, 267 } },
    { 87584, 2, { 322, 272 } },
    { 87615, 2, { 297, 295 } },
    { 87636, 2, { 327, 268 } },
    { 87696, 2, { 336, 261 } },
    { 87723, 2, { 361, 243 } },
    { 87725, 2, { 319, 275 } },
    { 87750, 2, { 325, 270 } },
    { 87756, 2, { 309, 284 } },
    { 87780, 2, { 308, 285 } },
    { 87792, 2, { 354, 248 } },
    { 87808, 2, { 343, 256 } },
    { 87822, 2, { 306, 287 } },
    { 87840, 2, { 305, 288 } },
    { 87906, 2, { 299, 294 } },
    { 87912, 2, { 297, 296 } },
    { 87984, 2, { 312, 282 } },
    { 88000, 2, { 320, 275 } },
    { 88044, 2, { 319, 276 } },
    { 88060, 2, { 340, 259 } },
    { 88088, 2, { 308, 286 } },
    { 88128, 2, { 306, 288 } },
    { 88140, 2, { 339, 260 } },
    { 88160, 2, { 304, 290 } },
    { 88164, 2, { 316, 279 } },
    { 88179, 2, { 323, 273 } },
    { 88200, 2, { 300, 294 } },
    { 88245, 2, { 333, 265 } },
    { 88320, 2, { 320, 276 } },
    { 88389, 2, { 427, 207 } },
    { 88400, 2, { 325, 272 } },
    { 88445, 2, { 361, 245 } },
    { 88452, 2, { 324, 273 } },
    { 88464, 2, { 304, 291 } },
    { 88476, 2, { 303, 292 } },
    { 88500, 2, { 300, 295 } },
    { 88536, 2, { 357, 248 } },
    { 88550, 2, { 322, 275 } },
    { 88560, 2, { 328, 270 } },
    { 88572, 2, { 363, 244 } },
    { 88596, 2, { 321, 276 } },
    { 88644, 2, { 332, 267 } },
    { 88695, 2, { 365, 243 } },
    { 88704, 2, { 308, 288 } },
    { 88740, 2, { 306, 290 } },
    { 88803, 2, { 299, 297 } },
    { 88825, 2, { 323, 275 } },
    { 88920, 2, { 312, 285 } },
    { 88935, 2, { 363, 245 } },
    { 88944, 2, { 327, 272 } },
    { 88970, 2, { 310, 287 } },
    { 88992, 2, { 309, 288 } },
    { 89012, 2, { 308, 289 } },
    { 89040, 2, { 318, 280 } },
    { 89056, 2, { 352, 253 } },
    { 89088, 2, { 348, 256 } },
    { 89096, 2, { 301, 296 } },
    { 89100, 2, { 300, 297 } },
    { 89180, 2, { 343, 260 } },
    { 89244, 2, { 333, 268 } },
    { 89280, 2, { 310, 288 } },
    { 89355, 2, { 345, 259 } },
    { 89376, 2, { 304, 294 } },
    { 89397, 2, { 301, 297 } },
    { 89460, 2, { 315, 284 } },
    { 89488, 2, { 329, 272 } },
    { 89496, 2, { 339, 264 } },
    { 89505, 2, { 351, 255 } },
    { 89523, 2, { 343, 261 } },
    { 89544, 2, { 312, 287 } },
    { 89600, 2, { 320, 280 } },
    { 89628, 2, { 308, 291 } },
    { 89661, 2, { 363, 247 } },
    { 89670, 2, { 305, 294 } },
    { 89680, 2, { 304, 295 } },
    { 89688, 2, { 303, 296 } },
    { 89700, 2, { 300, 299 } },
    { 89712, 2, { 336, 267 } },
    { 89726, 2, { 377, 238 } },
    { 89760, 2, { 330, 272 } },
    { 89784, 2, { 344, 261 } },
    { 89790, 2, { 365, 246 } },
    { 89856, 2, { 312, 288 } },
    { 89880, 2, { 321, 280 } },
    { 90024, 2, { 341, 264 } },
    { 90060, 2, { 316, 285 } },
    { 90090, 2, { 315, 286 } },
    { 90132, 2, { 348, 259 } },
    { 90153, 2, { 371, 243 } },
    { 90160, 2, { 322, 280 } },
    { 90168, 2, { 312, 289 } },
    { 90200, 2, { 328, 275 } },
    { 90228, 2, { 309, 292 } },
    { 90240, 2, { 320, 282 } },
    { 90250, 2, { 361, 250 } },
    { 90252, 2, { 327, 276 } },
    { 90270, 2, { 306, 295 } },
    { 90280, 2, { 305, 296 } },
    { 90288, 2, { 304, 297 } },
    { 90300, 2, { 301, 300 } },
    { 90321, 2, { 357, 253 } },
    { 90396, 2, { 324, 279 } },
    { 90405, 2, { 315, 287 } },
    { 90440, 2, { 323, 280 } },
    { 90450, 2, { 335, 270 } },
    { 90475, 2, { 329, 275 } },
    { 90480, 2, { 312, 290 } },
    { 90576, 2, { 306, 296 } },
    { 90585, 2, { 305, 297 } },
    { 90624, 2, { 354, 256 } },
    { 90636, 2, { 332, 273 } },
    { 90650, 2, { 350, 259 } },
    { 90675, 2, { 325, 279 } },
    { 90706, 2, { 341, 266 } },
    { 90720, 2, { 315, 288 } },
    { 90768, 2, { 366, 248 } },
    { 90780, 2, { 340, 267 } },
    { 90792, 2, { 312, 291 } },
    { 90852, 2, { 339, 268 } },
    { 90896, 2, { 304, 299 } },
    { 90900, 2, { 303, 300 } },
    { 90915, 2, { 319, 285 } },
    { 90945, 2, { 387, 235 } },
    { 91000, 2, { 325, 280 } },
    { 91035, 2, { 315, 289 } },
    { 91091, 2, { 539, 169 } },
    { 91120, 2, { 335, 272 } },
    { 91125, 2, { 375, 243 } },
    { 91160, 2, { 344, 265 } },
    { 91164, 2, { 321, 284 } },
    { 91200, 2, { 304, 300 } },
    { 91260, 2, { 338, 270 } },
    { 91464, 2, { 309, 296 } },
    { 91476, 2, { 308, 297 } },
    { 91494, 2, { 306, 299 } },
    { 91500, 2, { 305, 300 } },
    { 91504, 2, { 304, 301 } },
    { 91512, 2, { 328, 279 } },
    { 91520, 2, { 320, 286 } },
    { 91560, 2, { 327, 280 } },
    { 91575, 2, { 333, 275 } },
    { 91584, 2, { 318, 288 } },
    { 91590, 2, { 355, 258 } },
    { 91630, 2, { 374, 245 } },
    { 91650, 2, { 325, 282 } },
    { 91728, 2, { 312, 294 } },
    { 91770, 2, { 322, 285 } },
    { 91791, 2, { 329, 279 } },
    { 91840, 2, { 320, 287 } },
    { 91848, 2, { 344, 267 } },
    { 91872, 2, { 319, 288 } },
    { 91875, 2, { 375, 245 } },
    { 91908, 2, { 333, 276 } },
    { 91956, 2, { 316, 291 } },
    { 91980, 2, { 315, 292 } },
    { 92000, 2, { 368, 250 } },
    { 92008, 2, { 371, 248 } },
    { 92040, 2, { 312, 295 } },
    { 92070, 2, { 310, 297 } },
    { 92092, 2, { 308, 299 } },
    { 92106, 2, { 306, 301 } },
    { 92112, 2, { 304, 303 } },
    { 92120, 2, { 329, 280 } },
    { 92208, 2, { 339, 272 } },
    { 92225, 2, { 425, 217 } },
    { 92340, 2, { 324, 285 } },
    { 92365, 2, { 377, 245 } },
    { 92378, 2, { 323, 286 } },
    { 92400, 2, { 308, 300 } },
    { 92448, 2, { 321, 288 } },
    { 92460, 2, { 335, 276 } },
    { 92480, 2, { 320, 289 } },
    { 92496, 2, { 328, 282 } },
    { 92575, 2, { 529, 175 } },
    { 92628, 2, { 332, 279 } },
    { 92655, 2, { 355, 261 } },
    { 92664, 2, { 312, 297 } },
    { 92700, 2, { 309, 300 } },
    { 92720, 2, { 305, 304 } },
    { 92736, 2, { 322, 288 } },
    { 92752, 2, { 341, 272 } },
    { 92796, 2, { 407, 228 } },
    { 92800, 2, { 320, 290 } },
    { 92820, 2, { 340, 273 } },
    { 92868, 2, { 327, 284 } },
    { 92880, 2, { 344, 270 } },
    { 92916, 2, { 348, 267 } },
    { 92925, 2, { 315, 295 } },
    { 92988, 2, { 324, 287 } },
    { 93000, 2, { 310, 300 } },
    { 93015, 2, { 351, 265 } },
    { 93024, 2, { 306, 304 } },
    { 93093, 2, { 341, 273 } },
    { 93100, 2, { 350, 266 } },
    { 93120, 2, { 320, 291 } },
    { 93150, 2, { 345, 270 } },
    { 93184, 2, { 364, 256 } },
    { 93240, 2, { 315, 296 } },
    { 93275, 2, { 325, 287 } },
    { 93280, 2, { 352, 265 } },
    { 93288, 2, { 312, 299 } },
    { 93296, 2, { 343, 272 } },
    { 93310, 2, { 310, 301 } },
    { 93312, 2, { 324, 288 } },
    { 93324, 2, { 308, 303 } },
    { 93330, 2, { 306, 305 } },
    { 93456, 2, { 354, 264 } },
    { 93465, 2, { 335, 279 } },
    { 93480, 2, { 328, 285 } },
    { 93564, 2, { 339, 276 } },
    { 93696, 2, { 366, 256 } },
    { 93732, 2, { 321, 292 } },
    { 93744, 2, { 336, 279 } },
    { 93765, 2, { 329, 285 } },
    { 93775, 2, { 341, 275 } },
    { 93786, 2, { 319, 294 } },
    { 93795, 2, { 481, 195 } },
    { 93800, 2, { 335, 280 } },
    { 93810, 2, { 318, 295 } },
    { 93852, 2, { 316, 297 } },
    { 93860, 2, { 361, 260 } },
    { 93912, 2, { 312, 301 } },
    { 93925, 2, { 325, 289 } },
    { 93936, 2, { 309, 304 } },
    { 93960, 2, { 324, 290 } },
    { 93984, 2, { 352, 267 } },
    { 94068, 2, { 351, 268 } },
    { 94080, 2, { 320, 294 } },
    { 94116, 2, { 341, 276 } },
    { 94128, 2, { 318, 296 } },
    { 94170, 2, { 365, 258 } },
    { 94176, 2, { 327, 288 } },
    { 94185, 2, { 315, 299 } },
    { 94240, 2, { 310, 304 } },
    { 94284, 2, { 324, 291 } },
    { 94325, 2, { 343, 275 } },
    { 94380, 2, { 330, 286 } },
    { 94395, 2, { 435, 217 } },
    { 94400, 2, { 320, 295 } },
    { 94470, 2, { 335, 282 } },
    { 94500, 2, { 315, 300 } },
    { 94536, 2, { 312, 303 } },
    { 94572, 2, { 333, 284 } },
    { 94600, 2, { 344, 275 } },
    { 94620, 2, { 332, 285 } },
    { 94640, 2, { 338, 280 } },
    { 94656, 2, { 348, 272 } },
    { 94710, 2, { 330, 287 } },
    { 94743, 2, { 319, 297 } },
    { 94752, 2, { 329, 288 } },
    { 94809, 2, { 429, 221 } },
    { 94815, 2, { 315, 301 } },
    { 94860, 2, { 310, 306 } },
    { 94920, 2, { 339, 280 } },
    { 94962, 2, { 323, 294 } },
    { 94976, 2, { 371, 256 } },
    { 95004, 2, { 348, 273 } },
    { 95013, 2, { 391, 243 } },
    { 95016, 2, { 321, 296 } },
    { 95040, 2, { 320, 297 } },
    { 95095, 2, { 385, 247 } },
    { 95160, 2, { 312, 305 } },
    { 95172, 2, { 309, 308 } },
    { 95175, 2, { 405, 235 } },
    { 95220, 2, { 345, 276 } },
    { 95232, 2, { 372, 256 } },
    { 95256, 2, { 324, 294 } },
    { 95265, 2, { 365, 261 } },
    { 95304, 2, { 361, 264 } },
    { 95370, 2, { 330, 289 } },
    { 95410, 2, { 329, 290 } },
    { 95448, 2, { 328, 291 } },
    { 95472, 2, { 312, 306 } },
    { 95484, 2, { 327, 292 } },
    { 95550, 2, { 325, 294 } },
    { 95571, 2, { 333, 287 } },
    { 95580, 2, { 324, 295 } },
    { 95634, 2, { 322, 297 } },
    { 95676, 2, { 357, 268 } },
    { 95680, 2, { 320, 299 } },
    { 95697, 2, { 343, 279 } },
    { 95700, 2, { 319, 300 } },
    { 95748, 2, { 316, 303 } },
    { 95760, 2, { 315, 304 } },
    { 95795, 2, { 391, 245 } },
    { 95832, 2, { 363, 264 } },
    { 95850, 2, { 355, 270 } },
    { 95914, 2, { 403, 238 } },
    { 95931, 2, { 323, 297 } },
    { 95940, 2, { 369, 260 } },
    { 95976, 2, { 344, 279 } },
    { 95985, 2, { 395, 243 } },
    { 96000, 2, { 320, 300 } },
    { 96040, 2, { 343, 280 } },
    { 96075, 2, { 315, 305 } },
    { 96135, 2, { 377, 255 } },
    { 96140, 2, { 380, 253 } },
    { 96200, 2, { 325, 296 } },
    { 96228, 2, { 324, 297 } },
    { 96276, 2, { 339, 284 } },
    { 96288, 2, { 354, 272 } },
    { 96300, 2, { 321, 300 } },
    { 96320, 2, { 320, 301 } },
    { 96348, 2, { 372, 259 } },
    { 96408, 2, { 312, 309 } },
    { 96425, 2, { 475, 203 } },
    { 96432, 2, { 328, 294 } },
    { 96480, 2, { 335, 288 } },
    { 96512, 2, { 377, 256 } },
    { 96525, 2, { 325, 297 } },
    { 96600, 2, { 322, 300 } },
    { 96612, 2, { 332, 291 } },
    { 96624, 2, { 366, 264 } },
    { 96672, 2, { 318, 304 } },
    { 96720, 2, { 312, 310 } },
    { 96760, 2, { 328, 295 } },
    { 96792, 2, { 327, 296 } },
    { 96800, 2, { 352, 275 } },
    { 96831, 2, { 371, 261 } },
    { 96876, 2, { 324, 299 } },
    { 96900, 2, { 323, 300 } },
    { 96957, 2, { 399, 243 } },
    { 96960, 2, { 320, 303 } },
    { 96976, 2, { 319, 304 } },
    { 96990, 2, { 318, 305 } },
    { 97008, 2, { 344, 282 } },
    { 97020, 2, { 315, 308 } },
    { 97083, 2, { 469, 207 } },
    { 97092, 2, { 348, 279 } },
    { 97104, 2, { 336, 289 } },
    { 97125, 2, { 375, 259 } },
    { 97152, 2, { 352, 276 } },
    { 97170, 2, { 395, 246 } },
    { 97175, 2, { 325, 299 } },
    { 97185, 2, { 341, 285 } },
    { 97188, 2, { 356, 273 } },
    { 97200, 2, { 324, 300 } },
    { 97236, 2, { 333, 292 } },
    { 97284, 2, { 363, 268 } },
    { 97350, 2, { 330, 295 } },
    { 97384, 2, { 329, 296 } },
    { 97405, 2, { 385, 253 } },
    { 97416, 2, { 328, 297 } },
    { 97440, 2, { 336, 290 } },
    { 97500, 2, { 325, 300 } },
    { 97520, 2, { 368, 265 } },
    { 97524, 2, { 324, 301 } },
    { 97536, 2, { 381, 256 } },
    { 97580, 2, { 340, 287 } },
    { 97584, 2, { 321, 304 } },
    { 97600, 2, { 320, 305 } },
    { 97614, 2, { 319, 306 } },
    { 97632, 2, { 339, 288 } },
    { 97644, 2, { 316, 309 } },
    { 97680, 2, { 330, 296 } },
    { 97682, 2, { 338, 289 } },
    { 97713, 2, { 329, 297 } },
    { 97750, 2, { 391, 250 } },
    { 97755, 2, { 343, 285 } },
    { 97776, 2, { 336, 291 } },
    { 97785, 2, { 369, 265 } },
    { 97825, 2, { 325, 301 } },
    { 97888, 2, { 322, 304 } },
    { 97920, 2, { 320, 306 } },
    { 97980, 2, { 345, 284 } },
    { 98040, 2, { 344, 285 } },
    { 98098, 2, { 343, 286 } },
    { 98100, 2, { 327, 300 } },
    { 98154, 2, { 342, 287 } },
    { 98172, 2, { 324, 303 } },
    { 98175, 2, { 357, 275 } },
    { 98208, 2, { 341, 288 } },
    { 98235, 2, { 333, 295 } },
    { 98252, 2, { 319, 308 } },
    { 98280, 2, { 315, 312 } },
    { 98490, 2, { 335, 294 } },
    { 98496, 2, { 324, 304 } },
    { 98532, 2, { 322, 306 } },
    { 98550, 2, { 365, 270 } },
    { 98553, 2, { 361, 273 } },
    { 98560, 2, { 320, 308 } },
    { 98568, 2, { 333, 296 } },
    { 98604, 2, { 332, 297 } },
    { 98670, 2, { 330, 299 } },
    { 98700, 2, { 329, 300 } },
    { 98728, 2, { 328, 301 } },
    { 98735, 2, { 403, 245 } },
    { 98736, 2, { 363, 272 } },
    { 98784, 2, { 336, 294 } },
    { 98800, 2, { 325, 304 } },
    { 98820, 2, { 324, 305 } },
    { 98838, 2, { 323, 306 } },
    { 98868, 2, { 321, 308 } },
    { 98880, 2, { 320, 309 } },
    { 98892, 2, { 369, 268 } },
    { 98940, 2, { 340, 291 } },
    { 98988, 2, { 339, 292 } },
    { 99015, 2, { 345, 287 } },
    { 99045, 2, { 355, 279 } },
    { 99060, 2, { 381, 260 } },
    { 99120, 2, { 336, 295 } },
    { 99127, 2, { 343, 289 } },
    { 99160, 2, { 335, 296 } },
    { 99180, 2, { 342, 290 } },
    { 99200, 2, { 320, 310 } },
    { 99216, 2, { 318, 312 } },
    { 99264, 2, { 352, 282 } },
    { 99275, 2, { 361, 275 } },
    { 99324, 2, { 356, 279 } },
    { 99330, 2, { 330, 301 } },
    { 99360, 2, { 345, 288 } },
    { 99372, 2, { 338, 294 } },
    { 99384, 2, { 328, 303 } },
    { 99408, 2, { 327, 304 } },
    { 99450, 2, { 325, 306 } },
    { 99470, 2, { 343, 290 } },
    { 99484, 2, { 323, 308 } },
    { 99495, 2, { 335, 297 } },
    { 99528, 2, { 319, 312 } },
    { 99540, 2, { 316, 315 } },
    { 99552, 2, { 366, 272 } },
    { 99640, 2, { 376, 265 } },
    { 99684, 2, { 351, 284 } },
    { 99792, 2, { 324, 308 } },
    { 99840, 2, { 320, 312 } },
    { 99876, 2, { 348, 287 } },
    { 99900, 2, { 333, 300 } },
    { 100016, 2, { 329, 304 } },
    { 100035, 2, { 351, 285 } },
    { 100040, 2, { 328, 305 } },
    { 100104, 2, { 344, 291 } },
    { 100110, 2, { 355, 282 } },
    { 100116, 2, { 324, 309 } },
    { 100152, 2, { 321, 312 } },
    { 100188, 2, { 363, 276 } },
    { 100224, 2, { 348, 288 } },
    { 100233, 2, { 333, 301 } },
    { 100254, 2, { 341, 294 } },
    { 100282, 2, { 377, 266 } },
    { 100320, 2, { 330, 304 } },
    { 100344, 2, { 339, 296 } },
    { 100352, 2, { 392, 256 } },
    { 100359, 2, { 413, 243 } },
    { 100368, 2, { 328, 306 } },
    { 100386, 2, { 338, 297 } },
    { 100440, 2, { 324, 310 } },
    { 100450, 2, { 350, 287 } },
    { 100464, 2, { 322, 312 } },
    { 100485, 2, { 319, 315 } },
    { 100500, 2, { 335, 300 } },
    { 100555, 2, { 455, 221 } },
    { 100584, 2, { 381, 264 } },
    { 100596, 2, { 332, 303 } },
    { 100620, 2, { 387, 260 } },
    { 100650, 2, { 330, 305 } },
    { 100672, 2, { 352, 286 } },
    { 100674, 2, { 329, 306 } },
    { 100716, 2, { 327, 308 } },
    { 100737, 2, { 351, 287 } },
    { 100740, 2, { 345, 292 } },
    { 100776, 2, { 323, 312 } },
    { 100793, 2, { 539, 187 } },
    { 100800, 2, { 320, 315 } },
    { 100890, 2, { 342, 295 } },
    { 100912, 2, { 371, 272 } },
    { 100947, 2, { 399, 253 } },
    { 101080, 2, { 361, 280 } },
    { 101136, 2, { 336, 301 } },
    { 101150, 2, { 350, 289 } },
    { 101184, 2, { 372, 272 } },
    { 101200, 2, { 368, 275 } },
    { 101232, 2, { 333, 304 } },
    { 101250, 2, { 375, 270 } },
    { 101268, 2, { 348, 291 } },
    { 101277, 2, { 341, 297 } },
    { 101352, 2, { 328, 309 } },
    { 101388, 2, { 357, 284 } },
    { 101400, 2, { 325, 312 } },
    { 101430, 2, { 322, 315 } },
    { 101436, 2, { 321, 316 } },
    { 101439, 2, { 351, 289 } },
    { 101460, 2, { 356, 285 } },
    { 101475, 2, { 369, 275 } },
    { 101480, 2, { 344, 295 } },
    { 101520, 2, { 360, 282 } },
    { 101528, 2, { 343, 296 } },
    { 101556, 2, { 364, 279 } },
    { 101565, 2, { 333, 305 } },
    { 101660, 2, { 340, 299 } },
    { 101700, 2, { 339, 300 } },
    { 101728, 2, { 352, 289 } },
    { 101745, 2, { 323, 315 } },
    { 101760, 2, { 320, 318 } },
    { 101790, 2, { 351, 290 } },
    { 101808, 2, { 336, 303 } },
    { 101835, 2, { 365, 279 } },
    { 101840, 2, { 335, 304 } },
    { 101844, 2, { 369, 276 } },
    { 101871, 2, { 343, 297 } },
    { 101910, 2, { 395, 258 } },
    { 101920, 2, { 364, 280 } },
    { 101952, 2, { 354, 288 } },
    { 101990, 2, { 329, 310 } },
    { 102024, 2, { 327, 312 } },
    { 102025, 2, { 371, 275 } },
    { 102060, 2, { 324, 315 } },
    { 102080, 2, { 320, 319 } },
    { 102108, 2, { 381, 268 } },
    { 102120, 2, { 345, 296 } },
    { 102168, 2, { 344, 297 } },
    { 102240, 2, { 355, 288 } },
    { 102245, 2, { 605, 169 } },
    { 102258, 2, { 342, 299 } },
    { 102340, 2, { 340, 301 } },
    { 102375, 2, { 325, 315 } },
    { 102424, 2, { 413, 248 } },
    { 102432, 2, { 352, 291 } },
    { 102465, 2, { 345, 297 } },
    { 102480, 2, { 336, 305 } },
    { 102492, 2, { 351, 292 } },
    { 102510, 2, { 335, 306 } },
    { 102544, 2, { 377, 272 } },
    { 102555, 2, { 387, 265 } },
    { 102557, 2, { 343, 299 } },
    { 102564, 2, { 333, 308 } },
    { 102588, 2, { 332, 309 } },
    { 102648, 2, { 329, 312 } },
    { 102660, 2, { 348, 295 } },
    { 102672, 2, { 368, 279 } },
    { 102718, 2, { 322, 319 } },
    { 102720, 2, { 321, 320 } },
    { 102765, 2, { 403, 255 } },
    { 102816, 2, { 336, 306 } },
    { 102850, 2, { 374, 275 } },
    { 102900, 2, { 343, 300 } },
    { 102921, 2, { 377, 273 } },
    { 102930, 2, { 365, 282 } },
    { 102942, 2, { 342, 301 } },
    { 102960, 2, { 330, 312 } },
    { 103020, 2, { 340, 303 } },
    { 103040, 2, { 322, 320 } },
    { 103056, 2, { 339, 304 } },
    { 103075, 2, { 475, 217 } },
    { 103092, 2, { 363, 284 } },
    { 103095, 2, { 395, 261 } },
    { 103168, 2, { 403, 256 } },
    { 103246, 2, { 361, 286 } },
    { 103275, 2, { 405, 255 } },
    { 103320, 2, { 328, 315 } },
    { 103332, 2, { 327, 316 } },
    { 103350, 2, { 325, 318 } },
    { 103356, 2, { 324, 319 } },
    { 103360, 2, { 323, 320 } },
    { 103400, 2, { 376, 275 } },
    { 103488, 2, { 336, 308 } },
    { 103500, 2, { 345, 300 } },
    { 103509, 2, { 371, 279 } },
    { 103545, 2, { 351, 295 } },
    { 103596, 2, { 356, 291 } },
    { 103632, 2, { 381, 272 } },
    { 103635, 2, { 329, 315 } },
    { 103664, 2, { 341, 304 } },
    { 103675, 2, { 325, 319 } },
    { 103680, 2, { 324, 320 } },
    { 103716, 2, { 387, 268 } },
    { 103740, 2, { 364, 285 } },
    { 103752, 2, { 393, 264 } },
    { 103761, 2, { 427, 243 } },
    { 103776, 2, { 368, 282 } },
    { 103785, 2, { 407, 255 } },
    { 103824, 2, { 336, 309 } },
    { 103840, 2, { 352, 295 } },
    { 103845, 2, { 345, 301 } },
    { 103880, 2, { 371, 280 } },
    { 103896, 2, { 333, 312 } },
    { 103936, 2, { 406, 256 } },
    { 103968, 2, { 342, 304 } },
    { 104000, 2, { 325, 320 } },
    { 104004, 2, { 324, 321 } },
    { 104104, 2, { 338, 308 } },
    { 104160, 2, { 336, 310 } },
    { 104232, 2, { 344, 303 } },
    { 104244, 2, { 357, 292 } },
    { 104272, 2, { 343, 304 } },
    { 104304, 2, { 328, 318 } },
    { 104310, 2, { 342, 305 } },
    { 104328, 2, { 324, 322 } },
    { 104346, 2, { 341, 306 } },
    { 104370, 2, { 355, 294 } },
    { 104412, 2, { 339, 308 } },
    { 104520, 2, { 335, 312 } },
    { 104544, 2, { 352, 297 } },
    { 104580, 2, { 332, 315 } },
    { 104640, 2, { 327, 320 } },
    { 104650, 2, { 325, 322 } },
    { 104652, 2, { 324, 323 } },
    { 104748, 2, { 348, 301 } },
    { 104760, 2, { 360, 291 } },
    { 104784, 2, { 354, 296 } },
    { 104796, 2, { 369, 284 } },
    { 104880, 2, { 345, 304 } },
    { 104907, 2, { 363, 289 } },
    { 104920, 2, { 344, 305 } },
    { 104949, 2, { 351, 299 } },
    { 104958, 2, { 343, 306 } },
    { 104975, 2, { 325, 323 } },
    { 105000, 2, { 350, 300 } },
    { 105028, 2, { 341, 308 } },
    { 105060, 2, { 340, 309 } },
    { 105080, 2, { 355, 296 } },
    { 105156, 2, { 381, 276 } },
    { 105196, 2, { 364, 289 } },
    { 105228, 2, { 333, 316 } },
    { 105248, 2, { 352, 299 } },
    { 105264, 2, { 344, 306 } },
    { 105270, 2, { 330, 319 } },
    { 105280, 2, { 329, 320 } },
    { 105288, 2, { 328, 321 } },
    { 105300, 2, { 325, 324 } },
    { 105324, 2, { 393, 268 } },
    { 105350, 2, { 350, 301 } },
    { 105408, 2, { 366, 288 } },
    { 105435, 2, { 355, 297 } },
    { 105444, 2, { 348, 303 } },
    { 105525, 2, { 335, 315 } },
    { 105570, 2, { 345, 306 } },
    { 105600, 2, { 330, 320 } },
    { 105651, 2, { 351, 301 } },
    { 105672, 2, { 357, 296 } },
    { 105728, 2, { 413, 256 } },
    { 105732, 2, { 356, 297 } },
    { 105735, 2, { 371, 285 } },
    { 105768, 2, { 339, 312 } },
    { 105792, 2, { 348, 304 } },
    { 105840, 2, { 336, 315 } },
    { 105896, 2, { 427, 248 } },
    { 105924, 2, { 364, 291 } },
    { 105948, 2, { 327, 324 } },
    { 105963, 2, { 429, 247 } },
    { 105996, 2, { 363, 292 } },
    { 106000, 2, { 400, 265 } },
    { 106020, 2, { 342, 310 } },
    { 106029, 2, { 357, 297 } },
    { 106080, 2, { 340, 312 } },
    { 106134, 2, { 361, 294 } },
    { 106140, 2, { 348, 305 } },
    { 106190, 2, { 370, 287 } },
    { 106191, 2, { 437, 243 } },
    { 106260, 2, { 330, 322 } },
    { 106296, 2, { 344, 309 } },
    { 106330, 2, { 343, 310 } },
    { 106392, 2, { 341, 312 } },
    { 106400, 2, { 350, 304 } },
    { 106425, 2, { 387, 275 } },
    { 106470, 2, { 338, 315 } },
    { 106500, 2, { 355, 300 } },
    { 106530, 2, { 335, 318 } },
    { 106560, 2, { 333, 320 } },
    { 106572, 2, { 332, 321 } },
    { 106590, 2, { 330, 323 } },
    { 106596, 2, { 329, 324 } },
    { 106600, 2, { 328, 325 } },
    { 106650, 2, { 395, 270 } },
    { 106656, 2, { 352, 303 } },
    { 106680, 2, { 381, 280 } },
    { 106704, 2, { 342, 312 } },
    { 106720, 2, { 368, 290 } },
    { 106722, 2, { 363, 294 } },
    { 106743, 2, { 357, 299 } },
    { 106764, 2, { 372, 287 } },
    { 106812, 2, { 387, 276 } },
    { 106848, 2, { 336, 318 } },
    { 106896, 2, { 393, 272 } },
    { 106920, 2, { 330, 324 } },
    { 106925, 2, { 329, 325 } },
    { 106932, 2, { 399, 268 } },
    { 107016, 2, { 343, 312 } },
    { 107055, 2, { 351, 305 } },
    { 107065, 2, { 437, 245 } },
    { 107070, 2, { 415, 258 } },
    { 107088, 2, { 368, 291 } },
    { 107100, 2, { 340, 315 } },
    { 107124, 2, { 339, 316 } },
    { 107136, 2, { 372, 288 } },
    { 107160, 2, { 376, 285 } },
    { 107163, 2, { 441, 243 } },
    { 107184, 2, { 336, 319 } },
    { 107198, 2, { 403, 266 } },
    { 107200, 2, { 335, 320 } },
    { 107217, 2, { 361, 297 } },
    { 107250, 2, { 330, 325 } },
    { 107256, 2, { 328, 327 } },
    { 107310, 2, { 365, 294 } },
    { 107325, 2, { 405, 265 } },
    { 107360, 2, { 352, 305 } },
    { 107415, 2, { 341, 315 } },
    { 107445, 2, { 377, 285 } },
    { 107448, 2, { 363, 296 } },
    { 107520, 2, { 336, 320 } },
    { 107525, 2, { 391, 275 } },
    { 107532, 2, { 348, 309 } },
    { 107590, 2, { 371, 290 } },
    { 107616, 2, { 354, 304 } },
    { 107625, 2, { 375, 287 } },
    { 107640, 2, { 345, 312 } },
    { 107712, 2, { 352, 306 } },
    { 107748, 2, { 369, 292 } },
    { 107793, 2, { 413, 261 } },
    { 107800, 2, { 350, 308 } },
    { 107856, 2, { 336, 321 } },
    { 107868, 2, { 356, 303 } },
    { 107880, 2, { 348, 310 } },
    { 107892, 2, { 333, 324 } },
    { 107912, 2, { 329, 328 } },
    { 107920, 2, { 355, 304 } },
    { 107970, 2, { 354, 305 } },
    { 108040, 2, { 365, 296 } },
    { 108045, 2, { 343, 315 } },
    { 108108, 2, { 351, 308 } },
    { 108160, 2, { 338, 320 } },
    { 108192, 2, { 336, 322 } },
    { 108204, 2, { 381, 284 } },
    { 108225, 2, { 333, 325 } },
    { 108240, 2, { 330, 328 } },
    { 108252, 2, { 372, 291 } },
    { 108262, 2, { 407, 266 } },
    { 108290, 2, { 442, 245 } },
    { 108300, 2, { 361, 300 } },
    { 108315, 2, { 415, 261 } },
    { 108336, 2, { 366, 296 } },
    { 108360, 2, { 344, 315 } },
    { 108375, 2, { 375, 289 } },
    { 108405, 2, { 365, 297 } },
    { 108460, 2, { 340, 319 } },
    { 108468, 2, { 393, 276 } },
    { 108480, 2, { 339, 320 } },
    { 108528, 2, { 336, 323 } },
    { 108537, 2, { 363, 299 } },
    { 108540, 2, { 335, 324 } },
    { 108560, 2, { 368, 295 } },
    { 108564, 2, { 332, 327 } },
    { 108570, 2, { 330, 329 } },
    { 108630, 2, { 355, 306 } },
    { 108768, 2, { 352, 309 } },
    { 108800, 2, { 340, 320 } },
    { 108810, 2, { 351, 310 } },
    { 108855, 2, { 369, 295 } },
    { 108864, 2, { 336, 324 } },
    { 109020, 2, { 345, 316 } },
    { 109060, 2, { 380, 287 } },
    { 109080, 2, { 360, 303 } },
    { 109098, 2, { 342, 319 } },
    { 109120, 2, { 341, 320 } },
    { 109140, 2, { 340, 321 } },
    { 109174, 2, { 338, 323 } },
    { 109200, 2, { 336, 325 } },
    { 109224, 2, { 333, 328 } },
    { 109250, 2, { 437, 250 } },
    { 109296, 2, { 368, 297 } },
    { 109312, 2, { 427, 256 } },
    { 109344, 2, { 402, 272 } },
    { 109392, 2, { 344, 318 } },
    { 109416, 2, { 376, 291 } },
    { 109417, 2, { 343, 319 } },
    { 109440, 2, { 342, 320 } },
    { 109480, 2, { 340, 322 } },
    { 109500, 2, { 365, 300 } },
    { 109512, 2, { 338, 324 } },
    { 109557, 2, { 333, 329 } },
    { 109616, 2, { 403, 272 } },
    { 109620, 2, { 348, 315 } },
    { 109650, 2, { 425, 258 } },
    { 109728, 2, { 381, 288 } },
    { 109760, 2, { 343, 320 } },
    { 109800, 2, { 360, 305 } },
    { 109802, 2, { 341, 322 } },
    { 109816, 2, { 371, 296 } },
    { 109820, 2, { 340, 323 } },
    { 109824, 2, { 352, 312 } },
    { 109836, 2, { 339, 324 } },
    { 109872, 2, { 336, 327 } },
    { 109880, 2, { 335, 328 } },
    { 109908, 2, { 387, 284 } },
    { 109956, 2, { 357, 308 } },
    { 110000, 2, { 400, 275 } },
    { 110004, 2, { 356, 309 } },
    { 110019, 2, { 403, 273 } },
    { 110040, 2, { 393, 280 } },
    { 110055, 2, { 345, 319 } },
    { 110075, 2, { 425, 259 } },
    { 110110, 2, { 385, 286 } },
    { 110124, 2, { 342, 322 } },
    { 110160, 2, { 340, 324 } },
    { 110187, 2, { 371, 297 } },
    { 110205, 2, { 395, 279 } },
    { 110240, 2, { 416, 265 } },
    { 110292, 2, { 364, 303 } },
    { 110352, 2, { 363, 304 } },
    { 110400, 2, { 345, 320 } },
    { 110424, 2, { 344, 321 } },
    { 110432, 2, { 406, 272 } },
    { 110448, 2, { 354, 312 } },
    { 110484, 2, { 341, 324 } },
    { 110544, 2, { 336, 329 } },
    { 110550, 2, { 335, 330 } },
    { 110556, 2, { 333, 332 } },
    { 110580, 2, { 380, 291 } },
    { 110700, 2, { 369, 300 } },
    { 110760, 2, { 355, 312 } },
    { 110789, 2, { 343, 323 } },
    { 110825, 2, { 341, 325 } },
    { 110838, 2, { 377, 294 } },
    { 110880, 2, { 336, 330 } },
    { 110916, 2, { 351, 316 } },
    { 110920, 2, { 376, 295 } },
    { 110925, 2, { 425, 261 } },
    { 110960, 2, { 365, 304 } },
    { 110976, 2, { 384, 289 } },
    { 111000, 2, { 370, 300 } },
    { 111069, 2, { 369, 301 } },
    { 111104, 2, { 434, 256 } },
    { 111111, 2, { 407, 273 } },
    { 111132, 2, { 343, 324 } },
    { 111150, 2, { 342, 325 } },
    { 111180, 2, { 340, 327 } },
    { 111188, 2, { 361, 308 } },
    { 111192, 2, { 339, 328 } },
    { 111240, 2, { 360, 309 } },
    { 111252, 2, { 381, 292 } },
    { 111264, 2, { 366, 304 } },
    { 111265, 2, { 385, 289 } },
    { 111320, 2, { 440, 253 } },
    { 111360, 2, { 348, 320 } },
    { 111370, 2, { 370, 301 } },
    { 111375, 2, { 375, 297 } },
    { 111384, 2, { 357, 312 } },
    { 111390, 2, { 395, 282 } },
    { 111447, 2, { 427, 261 } },
    { 111475, 2, { 343, 325 } },
    { 111504, 2, { 368, 303 } },
    { 111540, 2, { 338, 330 } },
    { 111555, 2, { 335, 333 } },
    { 111573, 2, { 441, 253 } },
    { 111600, 2, { 360, 310 } },
    { 111612, 2, { 393, 284 } },
    { 111650, 2, { 350, 319 } },
    { 111672, 2, { 376, 297 } },
    { 111690, 2, { 365, 306 } },
    { 111708, 2, { 348, 321 } },
    { 111744, 2, { 384, 291 } },
    { 111780, 2, { 345, 324 } },
    { 111800, 2, { 344, 325 } },
    { 111804, 2, { 363, 308 } },
    { 111825, 2, { 355, 315 } },
    { 111826, 2, { 374, 299 } },
    { 111860, 2, { 340, 329 } },
    { 111888, 2, { 336, 333 } },
    { 111925, 2, { 407, 275 } },
    { 111930, 2, { 390, 287 } },
    { 111936, 2, { 352, 318 } },
    { 111969, 2, { 351, 319 } },
    { 111972, 2, { 372, 301 } },
    { 112000, 2, { 350, 320 } },
    { 112050, 2, { 415, 270 } },
    { 112095, 2, { 423, 265 } },
    { 112140, 2, { 356, 315 } },
    { 112176, 2, { 342, 328 } },
    { 112240, 2, { 368, 305 } },
    { 112288, 2, { 352, 319 } },
    { 112320, 2, { 351, 320 } },
    { 112332, 2, { 407, 276 } },
    { 112336, 2, { 413, 272 } },
    { 112385, 2, { 455, 247 } },
    { 112455, 2, { 357, 315 } },
    { 112476, 2, { 364, 309 } },
    { 112480, 2, { 370, 304 } },
    { 112488, 2, { 344, 327 } },
    { 112500, 2, { 375, 300 } },
    { 112504, 2, { 343, 328 } },
    { 112518, 2, { 342, 329 } },
    { 112530, 2, { 341, 330 } },
    { 112545, 2, { 369, 305 } },
    { 112548, 2, { 339, 332 } },
    { 112560, 2, { 336, 335 } },
    { 112608, 2, { 368, 306 } },
    { 112632, 2, { 361, 312 } },
    { 112651, 2, { 539, 209 } },
    { 112665, 2, { 435, 259 } },
    { 112700, 2, { 350, 322 } },
    { 112710, 2, { 390, 289 } },
    { 112716, 2, { 372, 303 } },
    { 112776, 2, { 381, 296 } },
    { 112784, 2, { 371, 304 } },
    { 112812, 2, { 357, 316 } },
    { 112875, 2, { 375, 301 } },
    { 112890, 2, { 355, 318 } },
    { 112992, 2, { 352, 321 } },
    { 113004, 2, { 387, 292 } },
    { 113022, 2, { 351, 322 } },
    { 113050, 2, { 350, 323 } },
    { 113088, 2, { 372, 304 } },
    { 113100, 2, { 348, 325 } },
    { 113160, 2, { 345, 328 } },
    { 113176, 2, { 344, 329 } },
    { 113184, 2, { 393, 288 } },
    { 113190, 2, { 343, 330 } },
    { 113220, 2, { 340, 333 } },
    { 113256, 2, { 363, 312 } },
    { 113280, 2, { 354, 320 } },
    { 113288, 2, { 392, 289 } },
    { 113316, 2, { 399, 284 } },
    { 113344, 2, { 352, 322 } },
    { 113373, 2, { 351, 323 } },
    { 113400, 2, { 350, 324 } },
    { 113436, 2, { 411, 276 } },
    { 113505, 2, { 345, 329 } },
    { 113520, 2, { 344, 330 } },
    { 113568, 2, { 338, 336 } },
    { 113600, 2, { 355, 320 } },
    { 113620, 2, { 380, 299 } },
    { 113652, 2, { 369, 308 } },
    { 113696, 2, { 352, 323 } },
    { 113712, 2, { 368, 309 } },
    { 113715, 2, { 361, 315 } },
    { 113724, 2, { 351, 324 } },
    { 113778, 2, { 378, 301 } },
    { 113796, 2, { 348, 327 } },
    { 113880, 2, { 365, 312 } },
    { 113883, 2, { 357, 319 } },
    { 113904, 2, { 339, 336 } },
    { 113928, 2, { 376, 303 } },
    { 113967, 2, { 469, 243 } },
    { 114000, 2, { 375, 304 } },
    { 114048, 2, { 352, 324 } },
    { 114075, 2, { 351, 325 } },
    { 114080, 2, { 368, 310 } },
    { 114165, 2, { 387, 295 } },
    { 114192, 2, { 366, 312 } },
    { 114219, 2, { 343, 333 } },
    { 114240, 2, { 340, 336 } },
    { 114276, 2, { 356, 321 } },
    { 114300, 2, { 381, 300 } },
    { 114345, 2, { 363, 315 } },
    { 114380, 2, { 380, 301 } },
    { 114400, 2, { 352, 325 } },
    { 114480, 2, { 360, 318 } },
    { 114492, 2, { 348, 329 } },
    { 114540, 2, { 345, 332 } },
    { 114552, 2, { 344, 333 } },
    { 114570, 2, { 342, 335 } },
    { 114576, 2, { 341, 336 } },
    { 114608, 2, { 377, 304 } },
    { 114660, 2, { 364, 315 } },
    { 114680, 2, { 376, 305 } },
    { 114708, 2, { 363, 316 } },
    { 114750, 2, { 375, 306 } },
    { 114756, 2, { 393, 292 } },
    { 114855, 2, { 403, 285 } },
    { 114912, 2, { 342, 336 } },
    { 114948, 2, { 372, 309 } },
    { 114950, 2, { 418, 275 } },
    { 114975, 2, { 365, 315 } },
    { 115005, 2, { 451, 255 } },
    { 115010, 2, { 371, 310 } },
    { 115020, 2, { 355, 324 } },
    { 115050, 2, { 354, 325 } },
    { 115056, 2, { 376, 306 } },
    { 115080, 2, { 411, 280 } },
    { 115104, 2, { 352, 327 } },
    { 115115, 2, { 385, 299 } },
    { 115128, 2, { 351, 328 } },
    { 115140, 2, { 380, 303 } },
    { 115150, 2, { 350, 329 } },
    { 115192, 2, { 374, 308 } },
    { 115200, 2, { 360, 320 } },
    { 115227, 2, { 413, 279 } },
    { 115236, 2, { 388, 297 } },
    { 115240, 2, { 344, 335 } },
    { 115248, 2, { 343, 336 } },
    { 115260, 2, { 340, 339 } },
    { 115311, 2, { 357, 323 } },
    { 115362, 2, { 377, 306 } },
    { 115425, 2, { 405, 285 } },
    { 115440, 2, { 370, 312 } },
    { 115479, 2, { 351, 329 } },
    { 115520, 2, { 361, 320 } },
    { 115560, 2, { 360, 321 } },
    { 115640, 2, { 392, 295 } },
    { 115668, 2, { 357, 324 } },
    { 115776, 2, { 402, 288 } },
    { 115785, 2, { 415, 279 } },
    { 115808, 2, { 352, 329 } },
    { 115824, 2, { 381, 304 } },
    { 115884, 2, { 348, 333 } },
    { 115920, 2, { 345, 336 } },
    { 115934, 2, { 343, 338 } },
    { 115940, 2, { 341, 340 } },
    { 115995, 2, { 407, 285 } },
    { 116000, 2, { 400, 290 } },
    { 116025, 2, { 357, 325 } },
    { 116070, 2, { 365, 318 } },
    { 116100, 2, { 387, 300 } },
    { 116112, 2, { 354, 328 } },
    { 116116, 2, { 364, 319 } },
    { 116127, 2, { 391, 297 } },
    { 116130, 2, { 395, 294 } },
    { 116144, 2, { 427, 272 } },
    { 116160, 2, { 352, 330 } },
    { 116184, 2, { 376, 309 } },
    { 116325, 2, { 423, 275 } },
    { 116328, 2, { 393, 296 } },
    { 116352, 2, { 384, 303 } },
    { 116412, 2, { 356, 327 } },
    { 116424, 2, { 378, 308 } },
    { 116440, 2, { 355, 328 } },
    { 116480, 2, { 364, 320 } },
    { 116508, 2, { 399, 292 } },
    { 116532, 2, { 351, 332 } },
    { 116580, 2, { 348, 335 } },
    { 116600, 2, { 424, 275 } },
    { 116604, 2, { 369, 316 } },
    { 116616, 2, { 344, 339 } },
    { 116620, 2, { 343, 340 } },
    { 116622, 2, { 342, 341 } },
    { 116688, 2, { 374, 312 } },
    { 116724, 2, { 411, 284 } },
    { 116725, 2, { 575, 203 } },
    { 116760, 2, { 417, 280 } },
    { 116800, 2, { 365, 320 } },
    { 116844, 2, { 364, 321 } },
    { 116865, 2, { 371, 315 } },
    { 116928, 2, { 348, 336 } },
    { 116963, 2, { 343, 341 } },
    { 117000, 2, { 360, 325 } },
    { 117024, 2, { 368, 318 } },
    { 117030, 2, { 415, 282 } },
    { 117045, 2, { 405, 289 } },
    { 117096, 2, { 357, 328 } },
    { 117120, 2, { 366, 320 } },
    { 117150, 2, { 355, 330 } },
    { 117180, 2, { 372, 315 } },
    { 117216, 2, { 352, 333 } },
    { 117249, 2, { 363, 323 } },
    { 117300, 2, { 345, 340 } },
    { 117306, 2, { 343, 342 } },
    { 117315, 2, { 395, 297 } },
    { 117325, 2, { 361, 325 } },
    { 117348, 2, { 381, 308 } },
    { 117369, 2, { 483, 243 } },
    { 117390, 2, { 390, 301 } },
    { 117392, 2, { 368, 319 } },
    { 117420, 2, { 380, 309 } },
    { 117450, 2, { 405, 290 } },
    { 117504, 2, { 384, 306 } },
    { 117564, 2, { 388, 303 } },
    { 117572, 2, { 364, 323 } },
    { 117585, 2, { 351, 335 } },
    { 117600, 2, { 350, 336 } },
    { 117612, 2, { 363, 324 } },
    { 117645, 2, { 345, 341 } },
    { 117648, 2, { 344, 342 } },
    { 117720, 2, { 360, 327 } },
    { 117810, 2, { 357, 330 } },
    { 117900, 2, { 393, 300 } },
    { 117920, 2, { 352, 335 } },
    { 117936, 2, { 351, 336 } },
    { 117972, 2, { 348, 339 } },
    { 117990, 2, { 345, 342 } },
    { 117992, 2, { 344, 343 } },
    { 118000, 2, { 400, 295 } },
    { 118035, 2, { 387, 305 } },
    { 118048, 2, { 434, 272 } },
    { 118104, 2, { 399, 296 } },
    { 118128, 2, { 368, 321 } },
    { 118215, 2, { 355, 333 } },
    { 118260, 2, { 365, 324 } },
    { 118300, 2, { 350, 338 } },
    { 118335, 2, { 345, 343 } },
    { 118368, 2, { 411, 288 } },
    { 118400, 2, { 370, 320 } },
    { 118404, 2, { 396, 299 } },
    { 118428, 2, { 417, 284 } },
    { 118440, 2, { 360, 329 } },
    { 118482, 2, { 403, 294 } },
    { 118500, 2, { 375, 316 } },
    { 118503, 2, { 399, 297 } },
    { 118524, 2, { 357, 332 } },
    { 118548, 2, { 356, 333 } },
    { 118560, 2, { 380, 312 } },
    { 118575, 2, { 425, 279 } },
    { 118590, 2, { 354, 335 } },
    { 118656, 2, { 384, 309 } },
    { 118668, 2, { 348, 341 } },
    { 118680, 2, { 345, 344 } },
    { 118720, 2, { 371, 320 } },
    { 118755, 2, { 377, 315 } },
    { 118776, 2, { 392, 303 } },
    { 118800, 2, { 360, 330 } },
    { 118872, 2, { 381, 312 } },
    { 118944, 2, { 354, 336 } },
    { 118950, 2, { 366, 325 } },
    { 118976, 2, { 352, 338 } },
    { 118992, 2, { 402, 296 } },
    { 119028, 2, { 364, 327 } },
    { 119040, 2, { 372, 320 } },
    { 119064, 2, { 363, 328 } },
    { 119119, 2, { 539, 221 } },
    { 119130, 2, { 361, 330 } },
    { 119133, 2, { 427, 279 } },
    { 119196, 2, { 387, 308 } },
    { 119232, 2, { 368, 324 } },
    { 119280, 2, { 355, 336 } },
    { 119301, 2, { 399, 299 } },
    { 119328, 2, { 352, 339 } },
    { 119340, 2, { 351, 340 } },
    { 119350, 2, { 350, 341 } },
    { 119364, 2, { 348, 343 } },
    { 119412, 2, { 372, 321 } },
    { 119472, 2, { 393, 304 } },
    { 119475, 2, { 405, 295 } },
    { 119556, 2, { 369, 324 } },
    { 119560, 2, { 392, 305 } },
    { 119568, 2, { 376, 318 } },
    { 119600, 2, { 368, 325 } },
    { 119625, 2, { 375, 319 } },
    { 119646, 2, { 391, 306 } },
    { 119658, 2, { 407, 294 } },
    { 119680, 2, { 352, 340 } },
    { 119691, 2, { 351, 341 } },
    { 119700, 2, { 350, 342 } },
    { 119720, 2, { 365, 328 } },
    { 119808, 2, { 384, 312 } },
    { 119850, 2, { 425, 282 } },
    { 119880, 2, { 360, 333 } },
    { 119892, 2, { 388, 309 } },
    { 119925, 2, { 369, 325 } },
    { 119952, 2, { 357, 336 } },
    { 119988, 2, { 396, 303 } },
    { 120000, 2, { 375, 320 } },
    { 120012, 2, { 411, 292 } },
    { 120032, 2, { 352, 341 } },
    { 120048, 2, { 366, 328 } },
    { 120050, 2, { 350, 343 } },
    { 120060, 2, { 348, 345 } },
    { 120096, 2, { 417, 288 } },
    { 120120, 2, { 364, 330 } },
    { 120132, 2, { 423, 284 } },
    { 120150, 2, { 445, 270 } },
    { 120175, 2, { 437, 275 } },
    { 120204, 2, { 371, 324 } },
    { 120224, 2, { 416, 289 } },
    { 120336, 2, { 368, 327 } },
    { 120384, 2, { 352, 342 } },
    { 120393, 2, { 351, 343 } },
    { 120396, 2, { 381, 316 } },
    { 120435, 2, { 465, 259 } },
    { 120450, 2, { 365, 330 } },
    { 120516, 2, { 363, 332 } },
    { 120575, 2, { 371, 325 } },
    { 120582, 2, { 378, 319 } },
    { 120600, 2, { 360, 335 } },
    { 120615, 2, { 473, 255 } },
    { 120640, 2, { 377, 320 } },
    { 120684, 2, { 356, 339 } },
    { 120696, 2, { 376, 321 } },
    { 120736, 2, { 352, 343 } },
    { 120744, 2, { 351, 344 } },
    { 120771, 2, { 497, 243 } },
    { 120785, 2, { 493, 245 } },
    { 120802, 2, { 374, 323 } },
    { 120870, 2, { 395, 306 } },
    { 120900, 2, { 372, 325 } },
    { 121032, 2, { 369, 328 } },
    { 121044, 2, { 393, 308 } },
    { 121072, 2, { 368, 329 } },
    { 121095, 2, { 351, 345 } },
    { 121125, 2, { 375, 323 } },
    { 121128, 2, { 392, 309 } },
    { 121176, 2, { 374, 324 } },
    { 121200, 2, { 400, 303 } },
    { 121212, 2, { 364, 333 } },
    { 121220, 2, { 380, 319 } },
    { 121275, 2, { 385, 315 } },
    { 121296, 2, { 361, 336 } },
    { 121380, 2, { 357, 340 } },
    { 121394, 2, { 377, 322 } },
    { 121401, 2, { 369, 329 } },
    { 121410, 2, { 355, 342 } },
    { 121440, 2, { 352, 345 } },
    { 121500, 2, { 375, 324 } },
    { 121545, 2, { 365, 333 } },
    { 121550, 2, { 374, 325 } },
    { 121600, 2, { 380, 320 } },
    { 121635, 2, { 459, 265 } },
    { 121644, 2, { 372, 327 } },
    { 121656, 2, { 411, 296 } },
    { 121680, 2, { 360, 338 } },
    { 121688, 2, { 371, 328 } },
    { 121716, 2, { 378, 322 } },
    { 121730, 2, { 370, 329 } },
    { 121737, 2, { 357, 341 } },
    { 121764, 2, { 417, 292 } },
    { 121776, 2, { 354, 344 } },
    { 121800, 2, { 350, 348 } },
    { 121920, 2, { 381, 320 } },
    { 121968, 2, { 363, 336 } },
    { 121975, 2, { 425, 287 } },
    { 121980, 2, { 380, 321 } },
    { 121992, 2, { 391, 312 } },
    { 122000, 2, { 400, 305 } },
    { 122010, 2, { 415, 294 } },
    { 122018, 2, { 361, 338 } },
    { 122040, 2, { 360, 339 } },
    { 122112, 2, { 384, 318 } },
    { 122120, 2, { 355, 344 } },
    { 122148, 2, { 351, 348 } },
    { 122200, 2, { 376, 325 } },
    { 122208, 2, { 402, 304 } },
    { 122220, 2, { 388, 315 } },
    { 122248, 2, { 413, 296 } },
    { 122292, 2, { 387, 316 } },
    { 122304, 2, { 364, 336 } },
    { 122360, 2, { 380, 322 } },
    { 122364, 2, { 396, 309 } },
    { 122388, 2, { 372, 329 } },
    { 122400, 2, { 360, 340 } },
    { 122409, 2, { 469, 261 } },
    { 122430, 2, { 371, 330 } },
    { 122496, 2, { 352, 348 } },
    { 122508, 2, { 369, 332 } },
    { 122512, 2, { 403, 304 } },
    { 122525, 2, { 377, 325 } },
    { 122544, 2, { 368, 333 } },
    { 122610, 2, { 366, 335 } },
    { 122616, 2, { 393, 312 } },
    { 122640, 2, { 365, 336 } },
    { 122655, 2, { 481, 255 } },
    { 122661, 2, { 413, 297 } },
    { 122688, 2, { 426, 288 } },
    { 122694, 2, { 363, 338 } },
    { 122720, 2, { 416, 295 } },
    { 122740, 2, { 361, 340 } },
    { 122760, 2, { 360, 341 } },
    { 122808, 2, { 357, 344 } },
    { 122815, 2, { 385, 319 } },
    { 122820, 2, { 356, 345 } },
    { 122850, 2, { 351, 350 } },
    { 122892, 2, { 399, 308 } },
    { 122952, 2, { 376, 327 } },
    { 122976, 2, { 366, 336 } },
    { 123000, 2, { 375, 328 } },
    { 123025, 2, { 475, 259 } },
    { 123120, 2, { 360, 342 } },
    { 123200, 2, { 352, 350 } },
    { 123255, 2, { 415, 297 } },
    { 123264, 2, { 384, 321 } },
    { 123280, 2, { 368, 335 } },
    { 123300, 2, { 411, 300 } },
    { 123318, 2, { 403, 306 } },
    { 123375, 2, { 375, 329 } },
    { 123396, 2, { 364, 339 } },
    { 123410, 2, { 410, 301 } },
    { 123420, 2, { 363, 340 } },
    { 123424, 2, { 406, 304 } },
    { 123432, 2, { 417, 296 } },
    { 123444, 2, { 381, 324 } },
    { 123480, 2, { 360, 343 } },
    { 123516, 2, { 423, 292 } },
    { 123525, 2, { 405, 305 } },
    { 123540, 2, { 355, 348 } },
    { 123543, 2, { 371, 333 } },
    { 123552, 2, { 352, 351 } },
    { 123600, 2, { 400, 309 } },
    { 123615, 2, { 369, 335 } },
    { 123728, 2, { 407, 304 } },
    { 123823, 2, { 361, 343 } },
    { 123876, 2, { 372, 333 } },
    { 123981, 2, { 429, 289 } },
    { 123984, 2, { 369, 336 } },
    { 124000, 2, { 400, 310 } },
    { 124025, 2, { 451, 275 } },
    { 124032, 2, { 384, 323 } },
    { 124080, 2, { 376, 330 } },
    { 124124, 2, { 364, 341 } },
    { 124155, 2, { 445, 279 } },
    { 124173, 2, { 511, 243 } },
    { 124188, 2, { 393, 316 } },
    { 124200, 2, { 360, 345 } },
    { 124236, 2, { 357, 348 } },
    { 124260, 2, { 380, 327 } },
    { 124320, 2, { 370, 336 } },
    { 124355, 2, { 385, 323 } },
    { 124362, 2, { 378, 329 } },
    { 124410, 2, { 377, 330 } },
    { 124416, 2, { 384, 324 } },
    { 124425, 2, { 395, 315 } },
    { 124476, 2, { 451, 276 } },
    { 124500, 2, { 375, 332 } },
    { 124509, 2, { 363, 343 } },
    { 124548, 2, { 388, 321 } },
    { 124605, 2, { 355, 351 } },
    { 124608, 2, { 354, 352 } },
    { 124620, 2, { 372, 335 } },
    { 124656, 2, { 371, 336 } },
    { 124740, 2, { 378, 330 } },
    { 124752, 2, { 368, 339 } },
    { 124775, 2, { 575, 217 } },
    { 124785, 2, { 423, 295 } },
    { 124800, 2, { 384, 325 } },
    { 124830, 2, { 365, 342 } },
    { 124836, 2, { 404, 309 } },
    { 124845, 2, { 435, 287 } },
    { 124872, 2, { 363, 344 } },
    { 124944, 2, { 411, 304 } },
    { 124950, 2, { 357, 350 } },
    { 124956, 2, { 356, 351 } },
    { 124960, 2, { 355, 352 } },
    { 124968, 2, { 381, 328 } },
    { 124982, 2, { 418, 299 } },
    { 124992, 2, { 372, 336 } },
    { 125020, 2, { 380, 329 } },
    { 125048, 2, { 392, 319 } },
    { 125080, 2, { 424, 295 } },
    { 125100, 2, { 417, 300 } },
    { 125208, 2, { 376, 333 } },
    { 125268, 2, { 429, 292 } },
    { 125307, 2, { 357, 351 } },
    { 125356, 2, { 407, 308 } },
    { 125388, 2, { 387, 324 } },
    { 125424, 2, { 402, 312 } },
    { 125440, 2, { 392, 320 } },
    { 125460, 2, { 369, 340 } },
    { 125488, 2, { 368, 341 } },
    { 125490, 2, { 445, 282 } },
    { 125550, 2, { 405, 310 } },
    { 125552, 2, { 413, 304 } },
    { 125560, 2, { 365, 344 } },
    { 125568, 2, { 384, 327 } },
    { 125580, 2, { 364, 345 } },
    { 125610, 2, { 395, 318 } },
    { 125664, 2, { 357, 352 } },
    { 125670, 2, { 355, 354 } },
    { 125685, 2, { 399, 315 } },
    { 125760, 2, { 393, 320 } },
    { 125775, 2, { 387, 325 } },
    { 125832, 2, { 392, 321 } },
    { 125840, 2, { 440, 286 } },
    { 125856, 2, { 368, 342 } },
    { 125904, 2, { 366, 344 } },
    { 125960, 2, { 376, 335 } },
    { 125970, 2, { 390, 323 } },
    { 126000, 2, { 360, 350 } },
    { 126072, 2, { 408, 309 } },
    { 126084, 2, { 399, 316 } },
    { 126096, 2, { 426, 296 } },
    { 126108, 2, { 372, 339 } },
    { 126126, 2, { 429, 294 } },
    { 126140, 2, { 371, 340 } },
    { 126224, 2, { 368, 343 } },
    { 126225, 2, { 425, 297 } },
    { 126280, 2, { 385, 328 } },
    { 126324, 2, { 363, 348 } },
    { 126350, 2, { 361, 350 } },
    { 126360, 2, { 360, 351 } },
    { 126392, 2, { 427, 296 } },
    { 126400, 2, { 395, 320 } },
    { 126420, 2, { 420, 301 } },
    { 126492, 2, { 381, 332 } },
    { 126540, 2, { 370, 342 } },
    { 126567, 2, { 369, 343 } },
    { 126588, 2, { 411, 308 } },
    { 126616, 2, { 392, 323 } },
    { 126630, 2, { 378, 335 } },
    { 126684, 2, { 391, 324 } },
    { 126711, 2, { 361, 351 } },
    { 126720, 2, { 360, 352 } },
    { 126750, 2, { 375, 338 } },
    { 126768, 2, { 417, 304 } },
    { 126819, 2, { 427, 297 } },
    { 126875, 2, { 625, 203 } },
    { 126876, 2, { 388, 327 } },
    { 126880, 2, { 416, 305 } },
    { 126882, 2, { 371, 342 } },
    { 126900, 2, { 423, 300 } },
    { 126910, 2, { 370, 343 } },
    { 126936, 2, { 369, 344 } },
    { 126945, 2, { 403, 315 } },
    { 126960, 2, { 368, 345 } },
    { 126984, 2, { 407, 312 } },
    { 126990, 2, { 415, 306 } },
    { 127008, 2, { 378, 336 } },
    { 127020, 2, { 365, 348 } },
    { 127050, 2, { 363, 350 } },
    { 127072, 2, { 361, 352 } },
    { 127075, 2, { 391, 325 } },
    { 127092, 2, { 357, 356 } },
    { 127116, 2, { 396, 321 } },
    { 127200, 2, { 400, 318 } },
    { 127260, 2, { 404, 315 } },
    { 127281, 2, { 399, 319 } },
    { 127323, 2, { 387, 329 } },
    { 127332, 2, { 393, 324 } },
    { 127400, 2, { 364, 350 } },
    { 127428, 2, { 444, 287 } },
    { 127440, 2, { 360, 354 } },
    { 127464, 2, { 376, 339 } },
    { 127500, 2, { 375, 340 } },
    { 127512, 2, { 396, 322 } },
    { 127568, 2, { 469, 272 } },
    { 127575, 2, { 405, 315 } },
    { 127596, 2, { 372, 343 } },
    { 127600, 2, { 400, 319 } },
    { 127624, 2, { 371, 344 } },
    { 127680, 2, { 380, 336 } },
    { 127764, 2, { 364, 351 } },
    { 127776, 2, { 363, 352 } },
    { 127800, 2, { 360, 355 } },
    { 127872, 2, { 384, 333 } },
    { 127875, 2, { 375, 341 } },
    { 127890, 2, { 406, 315 } },
    { 127920, 2, { 390, 328 } },
    { 127925, 2, { 425, 301 } },
    { 127946, 2, { 481, 266 } },
    { 127980, 2, { 395, 324 } },
    { 127995, 2, { 371, 345 } },
    { 128016, 2, { 381, 336 } },
    { 128030, 2, { 413, 310 } },
    { 128064, 2, { 368, 348 } },
    { 128115, 2, { 365, 351 } },
    { 128128, 2, { 364, 352 } },
    { 128180, 2, { 377, 340 } },
    { 128184, 2, { 392, 327 } },
    { 128205, 2, { 385, 333 } },
    { 128232, 2, { 411, 312 } },
    { 128250, 2, { 375, 342 } },
    { 128271, 2, { 429, 299 } },
    { 128282, 2, { 374, 343 } },
    { 128310, 2, { 390, 329 } },
    { 128340, 2, { 372, 345 } },
    { 128400, 2, { 400, 321 } },
    { 128412, 2, { 369, 348 } },
    { 128436, 2, { 417, 308 } },
    { 128480, 2, { 365, 352 } },
    { 128484, 2, { 387, 332 } },
    { 128520, 2, { 360, 357 } },
    { 128535, 2, { 451, 285 } },
    { 128547, 2, { 529, 243 } },
    { 128592, 2, { 376, 342 } },
    { 128625, 2, { 375, 343 } },
    { 128640, 2, { 384, 335 } },
    { 128744, 2, { 418, 308 } },
    { 128760, 2, { 370, 348 } },
    { 128800, 2, { 368, 350 } },
    { 128820, 2, { 380, 339 } },
    { 128832, 2, { 366, 352 } },
    { 128877, 2, { 361, 357 } },
    { 128898, 2, { 378, 341 } },
    { 128904, 2, { 393, 328 } },
    { 128934, 2, { 377, 342 } },
    { 128960, 2, { 403, 320 } },
    { 128968, 2, { 376, 343 } },
    { 129000, 2, { 375, 344 } },
    { 129015, 2, { 423, 305 } },
    { 129024, 2, { 384, 336 } },
    { 129108, 2, { 371, 348 } },
    { 129115, 2, { 527, 245 } },
    { 129168, 2, { 368, 351 } },
    { 129195, 2, { 405, 319 } },
    { 129204, 2, { 388, 333 } },
    { 129210, 2, { 365, 354 } },
    { 129228, 2, { 363, 356 } },
    { 129311, 2, { 377, 343 } },
    { 129320, 2, { 424, 305 } },
    { 129360, 2, { 385, 336 } },
    { 129472, 2, { 448, 289 } },
    { 129492, 2, { 396, 327 } },
    { 129504, 2, { 426, 304 } },
    { 129540, 2, { 381, 340 } },
    { 129560, 2, { 395, 328 } },
    { 129580, 2, { 380, 341 } },
    { 129605, 2, { 529, 245 } },
    { 129645, 2, { 387, 335 } },
    { 129648, 2, { 438, 296 } },
    { 129654, 2, { 378, 343 } },
    { 129675, 2, { 399, 325 } },
    { 129684, 2, { 404, 321 } },
    { 129717, 2, { 497, 261 } },
    { 129720, 2, { 376, 345 } },
    { 129744, 2, { 408, 318 } },
    { 129766, 2, { 403, 322 } },
    { 129780, 2, { 412, 315 } },
    { 129789, 2, { 437, 297 } },
    { 129792, 2, { 384, 338 } },
    { 129800, 2, { 440, 295 } },
    { 129808, 2, { 427, 304 } },
    { 129850, 2, { 371, 350 } },
    { 129870, 2, { 370, 351 } },
    { 129876, 2, { 411, 316 } },
    { 129888, 2, { 369, 352 } },
    { 129920, 2, { 406, 320 } },
    { 129930, 2, { 366, 355 } },
    { 129948, 2, { 364, 357 } },
    { 129960, 2, { 361, 360 } },
    { 130000, 2, { 400, 325 } },
    { 130032, 2, { 378, 344 } },
    { 130050, 2, { 425, 306 } },
    { 130065, 2, { 377, 345 } },
    { 130075, 2, { 473, 275 } },
    { 130095, 2, { 413, 315 } },
    { 130104, 2, { 417, 312 } },
    { 130130, 2, { 385, 338 } },
    { 130176, 2, { 384, 339 } },
    { 130200, 2, { 372, 350 } },
    { 130221, 2, { 371, 351 } },
    { 130240, 2, { 370, 352 } },
    { 130272, 2, { 368, 354 } },
    { 130284, 2, { 396, 329 } },
    { 130340, 2, { 380, 343 } },
    { 130350, 2, { 395, 330 } },
    { 130410, 2, { 378, 345 } },
    { 130416, 2, { 418, 312 } },
    { 130476, 2, { 393, 332 } },
    { 130500, 2, { 375, 348 } },
    { 130536, 2, { 392, 333 } },
    { 130548, 2, { 473, 276 } },
    { 130560, 2, { 384, 340 } },
    { 130572, 2, { 372, 351 } },
    { 130592, 2, { 371, 352 } },
    { 130640, 2, { 368, 355 } },
    { 130650, 2, { 390, 335 } },
    { 130680, 2, { 363, 360 } },
    { 130725, 2, { 415, 315 } },
    { 130800, 2, { 400, 327 } },
    { 130815, 2, { 405, 323 } },
    { 130830, 2, { 445, 294 } },
    { 130851, 2, { 469, 279 } },
    { 130872, 2, { 399, 328 } },
    { 130900, 2, { 374, 350 } },
    { 130935, 2, { 435, 301 } },
    { 130944, 2, { 372, 352 } },
    { 130968, 2, { 408, 321 } },
    { 130975, 2, { 403, 325 } },
    { 130995, 2, { 369, 355 } },
    { 131040, 2, { 364, 360 } },
    { 131043, 2, { 363, 361 } },
    { 131054, 2, { 407, 322 } },
    { 131064, 2, { 381, 344 } },
    { 131100, 2, { 380, 345 } },
    { 131175, 2, { 477, 275 } },
    { 131220, 2, { 405, 324 } },
    { 131274, 2, { 374, 351 } },
    { 131285, 2, { 385, 341 } },
    { 131313, 2, { 481, 273 } },
    { 131320, 2, { 392, 335 } },
    { 131328, 2, { 384, 342 } },
    { 131364, 2, { 369, 356 } },
    { 131376, 2, { 368, 357 } },
    { 131400, 2, { 365, 360 } },
    { 131404, 2, { 364, 361 } },
    { 131495, 2, { 455, 289 } },
    { 131520, 2, { 411, 320 } },
    { 131532, 2, { 388, 339 } },
    { 131535, 2, { 395, 333 } },
    { 131560, 2, { 440, 299 } },
    { 131580, 2, { 387, 340 } },
    { 131625, 2, { 375, 351 } },
    { 131648, 2, { 374, 352 } },
    { 131670, 2, { 385, 342 } },
    { 131712, 2, { 384, 343 } },
    { 131760, 2, { 366, 360 } },
    { 131772, 2, { 417, 316 } },
    { 131784, 2, { 408, 323 } },
    { 131835, 2, { 517, 255 } },
    { 131856, 2, { 402, 328 } },
    { 131859, 2, { 441, 299 } },
    { 131868, 2, { 396, 333 } },
    { 131936, 2, { 434, 304 } },
    { 131950, 2, { 377, 350 } },
    { 131970, 2, { 415, 318 } },
    { 131976, 2, { 376, 351 } },
    { 132000, 2, { 375, 352 } },
    { 132048, 2, { 393, 336 } },
    { 132060, 2, { 372, 355 } },
    { 132066, 2, { 414, 319 } },
    { 132108, 2, { 404, 327 } },
    { 132132, 2, { 364, 363 } },
    { 132158, 2, { 391, 338 } },
    { 132160, 2, { 413, 320 } },
    { 132165, 2, { 445, 297 } },
    { 132250, 2, { 529, 250 } },
    { 132252, 2, { 412, 321 } },
    { 132275, 2, { 407, 325 } },
    { 132288, 2, { 416, 318 } },
    { 132300, 2, { 378, 350 } },
    { 132327, 2, { 377, 351 } },
    { 132370, 2, { 427, 310 } },
    { 132440, 2, { 385, 344 } },
    { 132468, 2, { 399, 332 } },
    { 132588, 2, { 381, 348 } },
    { 132594, 2, { 451, 294 } },
    { 132660, 2, { 396, 335 } },
    { 132704, 2, { 377, 352 } },
    { 132720, 2, { 395, 336 } },
    { 132741, 2, { 387, 343 } },
    { 132804, 2, { 372, 357 } },
    { 132840, 2, { 369, 360 } },
    { 132888, 2, { 392, 339 } },
    { 132912, 2, { 426, 312 } },
    { 132940, 2, { 391, 340 } },
    { 132990, 2, { 390, 341 } },
    { 133056, 2, { 378, 352 } },
    { 133104, 2, { 376, 354 } },
    { 133110, 2, { 435, 306 } },
    { 133128, 2, { 387, 344 } },
    { 133133, 2, { 539, 247 } },
    { 133152, 2, { 438, 304 } },
    { 133164, 2, { 411, 324 } },
    { 133200, 2, { 370, 360 } },
    { 133245, 2, { 405, 329 } },
    { 133371, 2, { 511, 261 } },
    { 133380, 2, { 380, 351 } },
    { 133416, 2, { 408, 327 } },
    { 133440, 2, { 417, 320 } },
    { 133455, 2, { 465, 287 } },
    { 133480, 2, { 376, 355 } },
    { 133500, 2, { 375, 356 } },
    { 133536, 2, { 416, 321 } },
    { 133560, 2, { 371, 360 } },
    { 133584, 2, { 368, 363 } },
    { 133590, 2, { 366, 365 } },
    { 133620, 2, { 393, 340 } },
    { 133632, 2, { 384, 348 } },
    { 133644, 2, { 444, 301 } },
    { 133650, 2, { 405, 330 } },
    { 133668, 2, { 423, 316 } },
    { 133672, 2, { 392, 341 } },
    { 133705, 2, { 605, 221 } },
    { 133722, 2, { 391, 342 } },
    { 133760, 2, { 380, 352 } },
    { 133770, 2, { 390, 343 } },
    { 133848, 2, { 396, 338 } },
    { 133860, 2, { 388, 345 } },
    { 133875, 2, { 375, 357 } },
    { 133980, 2, { 385, 348 } },
    { 134000, 2, { 400, 335 } },
    { 134064, 2, { 392, 342 } },
    { 134100, 2, { 447, 300 } },
    { 134112, 2, { 381, 352 } },
    { 134113, 2, { 391, 343 } },
    { 134160, 2, { 390, 344 } },
    { 134190, 2, { 378, 355 } },
    { 134200, 2, { 440, 305 } },
    { 134225, 2, { 413, 325 } },
    { 134232, 2, { 376, 357 } },
    { 134244, 2, { 396, 339 } },
    { 134316, 2, { 369, 364 } },
    { 134320, 2, { 368, 365 } },
    { 134368, 2, { 416, 323 } },
    { 134379, 2, { 553, 243 } },
    { 134400, 2, { 384, 350 } },
    { 134460, 2, { 405, 332 } },
    { 134505, 2, { 427, 315 } },
    { 134532, 2, { 404, 333 } },
    { 134589, 2, { 377, 357 } },
    { 134640, 2, { 374, 360 } },
    { 134676, 2, { 387, 348 } },
    { 134685, 2, { 369, 365 } },
    { 134688, 2, { 368, 366 } },
    { 134724, 2, { 412, 327 } },
    { 134750, 2, { 385, 350 } },
    { 134784, 2, { 384, 351 } },
    { 134805, 2, { 473, 285 } },
    { 134808, 2, { 411, 328 } },
    { 134820, 2, { 420, 321 } },
    { 134890, 2, { 410, 329 } },
    { 134946, 2, { 378, 357 } },
    { 134976, 2, { 444, 304 } },
    { 134995, 2, { 551, 245 } },
    { 135000, 2, { 375, 360 } },
    { 135014, 2, { 374, 361 } },
    { 135036, 2, { 372, 363 } },
    { 135072, 2, { 402, 336 } },
    { 135090, 2, { 395, 342 } },
    { 135108, 2, { 417, 324 } },
    { 135135, 2, { 385, 351 } },
    { 135150, 2, { 425, 318 } },
    { 135192, 2, { 393, 344 } },
    { 135200, 2, { 400, 338 } },
    { 135240, 2, { 392, 345 } },
    { 135375, 2, { 375, 361 } },
    { 135405, 2, { 459, 295 } },
    { 135464, 2, { 413, 328 } },
    { 135520, 2, { 385, 352 } },
    { 135564, 2, { 429, 316 } },
    { 135575, 2, { 425, 319 } },
    { 135600, 2, { 400, 339 } },
    { 135625, 2, { 625, 217 } },
    { 135636, 2, { 381, 356 } },
    { 135660, 2, { 380, 357 } },
    { 135675, 2, { 405, 335 } },
    { 135720, 2, { 377, 360 } },
    { 135780, 2, { 372, 365 } },
    { 135792, 2, { 369, 368 } },
    { 135828, 2, { 396, 343 } },
    { 135850, 2, { 418, 325 } },
    { 135864, 2, { 408, 333 } },
    { 135880, 2, { 395, 344 } },
    { 135888, 2, { 447, 304 } },
    { 135915, 2, { 533, 255 } },
    { 135936, 2, { 384, 354 } },
    { 135975, 2, { 525, 259 } },
    { 136032, 2, { 416, 327 } },
    { 136045, 2, { 455, 299 } },
    { 136059, 2, { 399, 341 } },
    { 136080, 2, { 378, 360 } },
    { 136104, 2, { 424, 321 } },
    { 136125, 2, { 375, 363 } },
    { 136136, 2, { 374, 364 } },
    { 136160, 2, { 370, 368 } },
    { 136170, 2, { 445, 306 } },
    { 136188, 2, { 388, 351 } },
    { 136206, 2, { 414, 329 } },
    { 136224, 2, { 387, 352 } },
    { 136290, 2, { 385, 354 } },
    { 136320, 2, { 384, 355 } },
    { 136325, 2, { 475, 287 } },
    { 136344, 2, { 437, 312 } },
    { 136367, 2, { 539, 253 } },
    { 136400, 2, { 400, 341 } },
    { 136452, 2, { 411, 332 } },
    { 136458, 2, { 378, 361 } },
    { 136488, 2, { 376, 363 } },
    { 136500, 2, { 375, 364 } },
    { 136528, 2, { 371, 368 } },
    { 136620, 2, { 396, 345 } },
    { 136640, 2, { 427, 320 } },
    { 136656, 2, { 438, 312 } },
    { 136710, 2, { 434, 315 } },
    { 136752, 2, { 407, 336 } },
    { 136764, 2, { 393, 348 } },
    { 136776, 2, { 417, 328 } },
    { 136800, 2, { 380, 360 } },
    { 136850, 2, { 391, 350 } },
    { 136851, 2, { 377, 363 } },
    { 136880, 2, { 464, 295 } },
    { 136896, 2, { 372, 368 } },
    { 136899, 2, { 371, 369 } },
    { 136950, 2, { 415, 330 } },
    { 136956, 2, { 404, 339 } },
    { 137020, 2, { 403, 340 } },
    { 137052, 2, { 423, 324 } },
    { 137085, 2, { 481, 285 } },
    { 137088, 2, { 384, 357 } },
    { 137160, 2, { 381, 360 } },
    { 137196, 2, { 412, 333 } },
    { 137214, 2, { 378, 363 } },
    { 137228, 2, { 377, 364 } },
    { 137240, 2, { 376, 365 } },
    { 137241, 2, { 391, 351 } },
    { 137256, 2, { 399, 344 } },
    { 137268, 2, { 372, 369 } },
    { 137270, 2, { 371, 370 } },
    { 137275, 2, { 425, 323 } },
    { 137280, 2, { 390, 352 } },
    { 137340, 2, { 420, 327 } },
    { 137385, 2, { 387, 355 } },
    { 137460, 2, { 395, 348 } },
    { 137475, 2, { 423, 325 } },
    { 137529, 2, { 413, 333 } },
    { 137592, 2, { 378, 364 } },
    { 137616, 2, { 376, 366 } },
    { 137640, 2, { 372, 370 } },
    { 137676, 2, { 447, 308 } },
    { 137700, 2, { 405, 340 } },
    { 137712, 2, { 453, 304 } },
    { 137760, 2, { 410, 336 } },
    { 137772, 2, { 387, 356 } },
    { 137800, 2, { 424, 325 } },
    { 137826, 2, { 403, 342 } },
    { 137940, 2, { 380, 363 } },
    { 137970, 2, { 378, 365 } },
    { 138000, 2, { 375, 368 } },
    { 138012, 2, { 372, 371 } },
    { 138040, 2, { 406, 340 } },
    { 138096, 2, { 411, 336 } },
    { 138105, 2, { 405, 341 } },
    { 138180, 2, { 420, 329 } },
    { 138195, 2, { 415, 333 } },
    { 138229, 2, { 403, 343 } },
    { 138240, 2, { 384, 360 } },
    { 138288, 2, { 402, 344 } },
    { 138312, 2, { 408, 339 } },
    { 138336, 2, { 393, 352 } },
    { 138444, 2, { 417, 332 } },
    { 138446, 2, { 406, 341 } },
    { 138450, 2, { 390, 355 } },
    { 138516, 2, { 388, 357 } },
    { 138528, 2, { 416, 333 } },
    { 138567, 2, { 429, 323 } },
    { 138600, 2, { 385, 360 } },
    { 138624, 2, { 384, 361 } },
    { 138645, 2, { 395, 351 } },
    { 138648, 2, { 424, 327 } },
    { 138663, 2, { 497, 279 } },
    { 138684, 2, { 381, 364 } },
    { 138736, 2, { 377, 368 } },
    { 138744, 2, { 376, 369 } },
    { 138768, 2, { 392, 354 } },
    { 138775, 2, { 427, 325 } },
    { 138824, 2, { 469, 296 } },
    { 138852, 2, { 399, 348 } },
    { 138880, 2, { 434, 320 } },
    { 138908, 2, { 451, 308 } },
    { 138915, 2, { 405, 343 } },
    { 138985, 2, { 385, 361 } },
    { 138996, 2, { 396, 351 } },
    { 139035, 2, { 403, 345 } },
    { 139040, 2, { 395, 352 } },
    { 139104, 2, { 378, 368 } },
    { 139125, 2, { 375, 371 } },
    { 139150, 2, { 506, 275 } },
    { 139160, 2, { 392, 355 } },
    { 139194, 2, { 407, 342 } },
    { 139200, 2, { 400, 348 } },
    { 139230, 2, { 390, 357 } },
    { 139293, 2, { 469, 297 } },
    { 139320, 2, { 387, 360 } },
    { 139356, 2, { 441, 316 } },
    { 139360, 2, { 416, 335 } },
    { 139380, 2, { 404, 345 } },
    { 139392, 2, { 384, 363 } },
    { 139440, 2, { 415, 336 } },
    { 139464, 2, { 447, 312 } },
    { 139496, 2, { 376, 371 } },
    { 139500, 2, { 375, 372 } },
    { 139524, 2, { 453, 308 } },
    { 139536, 2, { 408, 342 } },
    { 139587, 2, { 391, 357 } },
    { 139601, 2, { 407, 343 } },
    { 139650, 2, { 399, 350 } },
    { 139668, 2, { 412, 339 } },
    { 139725, 2, { 405, 345 } },
    { 139728, 2, { 426, 328 } },
    { 139740, 2, { 411, 340 } },
    { 139776, 2, { 384, 364 } },
    { 139825, 2, { 425, 329 } },
    { 139830, 2, { 395, 354 } },
    { 139860, 2, { 378, 370 } },
    { 139908, 2, { 393, 356 } },
    { 139920, 2, { 424, 330 } },
    { 139944, 2, { 392, 357 } },
    { 139956, 2, { 428, 327 } },
    { 139965, 2, { 465, 301 } },
    { 139995, 2, { 459, 305 } },
    { 140000, 2, { 400, 350 } },
    { 140049, 2, { 399, 351 } },
    { 140056, 2, { 427, 328 } },
    { 140070, 2, { 406, 345 } },
    { 140112, 2, { 417, 336 } },
    { 140160, 2, { 384, 365 } },
    { 140175, 2, { 445, 315 } },
    { 140208, 2, { 381, 368 } },
    { 140220, 2, { 380, 369 } },
    { 140238, 2, { 378, 371 } },
    { 140250, 2, { 375, 374 } },
    { 140360, 2, { 440, 319 } },
    { 140400, 2, { 390, 360 } },
    { 140415, 2, { 407, 345 } },
    { 140420, 2, { 413, 340 } },
    { 140436, 2, { 423, 332 } },
    { 140448, 2, { 399, 352 } },
    { 140544, 2, { 384, 366 } },
    { 140580, 2, { 396, 355 } },
    { 140630, 2, { 410, 343 } },
    { 140679, 2, { 441, 319 } },
    { 140712, 2, { 429, 328 } },
    { 140715, 2, { 477, 295 } },
    { 140760, 2, { 391, 360 } },
    { 140777, 2, { 637, 221 } },
    { 140790, 2, { 390, 361 } },
    { 140844, 2, { 388, 363 } },
    { 140868, 2, { 387, 364 } },
    { 140910, 2, { 385, 366 } },
    { 140940, 2, { 405, 348 } },
    { 140980, 2, { 380, 371 } },
    { 140998, 2, { 377, 374 } },
    { 141000, 2, { 376, 375 } },
    { 141024, 2, { 416, 339 } },
    { 141050, 2, { 403, 350 } },
    { 141075, 2, { 475, 297 } },
    { 141120, 2, { 392, 360 } },
    { 141174, 2, { 414, 341 } },
    { 141192, 2, { 424, 333 } },
    { 141252, 2, { 447, 316 } },
    { 141255, 2, { 387, 365 } },
    { 141264, 2, { 432, 327 } },
    { 141336, 2, { 453, 312 } },
    { 141372, 2, { 378, 374 } },
    { 141375, 2, { 377, 375 } },
    { 141384, 2, { 411, 344 } },
    { 141414, 2, { 481, 294 } },
    { 141440, 2, { 416, 340 } },
    { 141453, 2, { 403, 351 } },
    { 141470, 2, { 430, 329 } },
    { 141480, 2, { 393, 360 } },
    { 141504, 2, { 402, 352 } },
    { 141510, 2, { 445, 318 } },
    { 141512, 2, { 392, 361 } },
    { 141520, 2, { 464, 305 } },
    { 141525, 2, { 425, 333 } },
    { 141600, 2, { 400, 354 } },
    { 141610, 2, { 490, 289 } },
    { 141636, 2, { 407, 348 } },
    { 141680, 2, { 385, 368 } },
    { 141696, 2, { 384, 369 } },
    { 141705, 2, { 423, 335 } },
    { 141732, 2, { 381, 372 } },
    { 141750, 2, { 378, 375 } },
    { 141780, 2, { 417, 340 } },
    { 141804, 2, { 404, 351 } },
    { 141856, 2, { 403, 352 } },
    { 141930, 2, { 415, 342 } },
    { 141933, 2, { 391, 363 } },
    { 142000, 2, { 400, 355 } },
    { 142002, 2, { 414, 343 } },
    { 142025, 2, { 437, 325 } },
    { 142040, 2, { 424, 335 } },
    { 142044, 2, { 399, 356 } },
    { 142065, 2, { 385, 369 } },
    { 142072, 2, { 413, 344 } },
    { 142080, 2, { 384, 370 } },
    { 142100, 2, { 406, 350 } },
    { 142128, 2, { 378, 376 } },
    { 142140, 2, { 412, 345 } },
    { 142175, 2, { 517, 275 } },
    { 142191, 2, { 427, 333 } },
    { 142200, 2, { 395, 360 } },
    { 142272, 2, { 416, 342 } },
    { 142290, 2, { 459, 310 } },
    { 142296, 2, { 392, 363 } },
    { 142324, 2, { 391, 364 } },
    { 142350, 2, { 390, 365 } },
    { 142380, 2, { 420, 339 } },
    { 142416, 2, { 387, 368 } },
    { 142428, 2, { 429, 332 } },
    { 142464, 2, { 384, 371 } },
    { 142485, 2, { 413, 345 } },
    { 142500, 2, { 380, 375 } },
    { 142506, 2, { 378, 377 } },
    { 142524, 2, { 428, 333 } },
    { 142545, 2, { 559, 255 } },
    { 142569, 2, { 511, 279 } },
    { 142576, 2, { 469, 304 } },
    { 142590, 2, { 485, 294 } },
    { 142680, 2, { 410, 348 } },
    { 142710, 2, { 402, 355 } },
    { 142760, 2, { 415, 344 } },
    { 142766, 2, { 442, 323 } },
    { 142800, 2, { 400, 357 } },
    { 142848, 2, { 384, 372 } },
    { 142857, 2, { 407, 351 } },
    { 142912, 2, { 406, 352 } },
    { 142956, 2, { 396, 361 } },
    { 142975, 2, { 475, 301 } },
    { 143000, 2, { 440, 325 } },
    { 143028, 2, { 411, 348 } },
    { 143040, 2, { 447, 320 } },
    { 143052, 2, { 393, 364 } },
    { 143055, 2, { 495, 289 } },
    { 143080, 2, { 392, 365 } },
    { 143115, 2, { 435, 329 } },
    { 143136, 2, { 426, 336 } },
    { 143143, 2, { 847, 169 } },
    { 143148, 2, { 453, 316 } },
    { 143172, 2, { 388, 369 } },
    { 143208, 2, { 408, 351 } },
    { 143220, 2, { 385, 372 } },
    { 143256, 2, { 381, 376 } },
    { 143260, 2, { 380, 377 } },
    { 143264, 2, { 407, 352 } },
    { 143325, 2, { 441, 325 } },
    { 143374, 2, { 418, 343 } },
    { 143448, 2, { 417, 344 } },
    { 143451, 2, { 483, 297 } },
    { 143472, 2, { 392, 366 } },
    { 143520, 2, { 390, 368 } },
    { 143577, 2, { 387, 371 } },
    { 143616, 2, { 384, 374 } },
    { 143640, 2, { 380, 378 } },
    { 143664, 2, { 438, 328 } },
    { 143736, 2, { 424, 339 } },
    { 143748, 2, { 396, 363 } },
    { 143775, 2, { 405, 355 } },
    { 143820, 2, { 423, 340 } },
    { 143840, 2, { 464, 310 } },
    { 143856, 2, { 432, 333 } },
    { 143871, 2, { 403, 357 } },
    { 143960, 2, { 472, 305 } },
    { 143964, 2, { 387, 372 } },
    { 143990, 2, { 385, 374 } },
    { 144000, 2, { 384, 375 } },
    { 144045, 2, { 485, 297 } },
    { 144060, 2, { 420, 343 } },
    { 144144, 2, { 396, 364 } },
    { 144180, 2, { 405, 356 } },
    { 144228, 2, { 404, 357 } },
    { 144305, 2, { 589, 245 } },
    { 144320, 2, { 410, 352 } },
    { 144333, 2, { 553, 261 } },
    { 144375, 2, { 385, 375 } },
    { 144420, 2, { 415, 348 } },
    { 144432, 2, { 408, 354 } },
    { 144540, 2, { 396, 365 } },
    { 144550, 2, { 413, 350 } },
    { 144570, 2, { 395, 366 } },
    { 144585, 2, { 405, 357 } },
    { 144612, 2, { 412, 351 } },
    { 144624, 2, { 393, 368 } },
    { 144648, 2, { 392, 369 } },
    { 144672, 2, { 411, 352 } },
    { 144690, 2, { 390, 371 } },
    { 144704, 2, { 448, 323 } },
    { 144716, 2, { 484, 299 } },
    { 144720, 2, { 402, 360 } },
    { 144760, 2, { 385, 376 } },
    { 144768, 2, { 384, 377 } },
    { 144780, 2, { 381, 380 } },
    { 144828, 2, { 447, 324 } },
    { 144840, 2, { 408, 355 } },
    { 144900, 2, { 414, 350 } },
    { 144925, 2, { 425, 341 } },
    { 144960, 2, { 453, 320 } },
    { 144963, 2, { 413, 351 } },
    { 145008, 2, { 424, 342 } },
    { 145044, 2, { 459, 316 } },
    { 145089, 2, { 423, 343 } },
    { 145092, 2, { 428, 339 } },
    { 145116, 2, { 417, 348 } },
    { 145145, 2, { 385, 377 } },
    { 145152, 2, { 384, 378 } },
    { 145180, 2, { 427, 340 } },
    { 145188, 2, { 436, 333 } },
    { 145200, 2, { 400, 363 } },
    { 145222, 2, { 451, 322 } },
    { 145236, 2, { 399, 364 } },
    { 145299, 2, { 407, 357 } },
    { 145350, 2, { 425, 342 } },
    { 145360, 2, { 395, 368 } },
    { 145376, 2, { 413, 352 } },
    { 145432, 2, { 392, 371 } },
    { 145475, 2, { 529, 275 } },
    { 145485, 2, { 477, 305 } },
    { 145500, 2, { 388, 375 } },
    { 145512, 2, { 387, 376 } },
    { 145530, 2, { 385, 378 } },
    { 145600, 2, { 400, 364 } },
    { 145656, 2, { 408, 357 } },
    { 145665, 2, { 415, 351 } },
    { 145684, 2, { 473, 308 } },
    { 145728, 2, { 396, 368 } },
    { 145755, 2, { 395, 369 } },
    { 145775, 2, { 425, 343 } },
    { 145800, 2, { 405, 360 } },
    { 145860, 2, { 390, 374 } },
    { 145920, 2, { 384, 380 } },
    { 146000, 2, { 400, 365 } },
    { 146016, 2, { 416, 351 } },
    { 146025, 2, { 495, 295 } },
    { 146076, 2, { 444, 329 } },
    { 146080, 2, { 415, 352 } },
    { 146124, 2, { 396, 369 } },
    { 146160, 2, { 406, 360 } },
    { 146196, 2, { 393, 372 } },
    { 146200, 2, { 425, 344 } },
    { 146205, 2, { 405, 361 } },
    { 146224, 2, { 481, 304 } },
    { 146234, 2, { 391, 374 } },
    { 146280, 2, { 424, 345 } },
    { 146289, 2, { 403, 363 } },
    { 146304, 2, { 384, 381 } },
    { 146316, 2, { 411, 356 } },
    { 146400, 2, { 400, 366 } },
    { 146412, 2, { 441, 332 } },
    { 146421, 2, { 459, 319 } },
    { 146448, 2, { 432, 339 } },
    { 146520, 2, { 396, 370 } },
    { 146523, 2, { 507, 289 } },
    { 146544, 2, { 426, 344 } },
    { 146575, 2, { 451, 325 } },
    { 146608, 2, { 392, 374 } },
    { 146616, 2, { 447, 328 } },
    { 146625, 2, { 391, 375 } },
    { 146640, 2, { 390, 376 } },
    { 146652, 2, { 404, 363 } },
    { 146692, 2, { 403, 364 } },
    { 146718, 2, { 418, 351 } },
    { 146730, 2, { 402, 365 } },
    { 146740, 2, { 460, 319 } },
    { 146772, 2, { 453, 324 } },
    { 146784, 2, { 417, 352 } },
    { 146832, 2, { 399, 368 } },
    { 146850, 2, { 445, 330 } },
    { 146888, 2, { 427, 344 } },
    { 146910, 2, { 415, 354 } },
    { 146916, 2, { 396, 371 } },
    { 146940, 2, { 395, 372 } },
    { 146965, 2, { 455, 323 } },
    { 146970, 2, { 414, 355 } },
    { 147000, 2, { 392, 375 } },
    { 147015, 2, { 405, 363 } },
    { 147030, 2, { 390, 377 } },
    { 147060, 2, { 387, 380 } },
    { 147084, 2, { 412, 357 } },
    { 147112, 2, { 497, 296 } },
    { 147136, 2, { 418, 352 } },
    { 147147, 2, { 429, 343 } },
    { 147168, 2, { 438, 336 } },
    { 147204, 2, { 423, 348 } },
    { 147264, 2, { 416, 354 } },
    { 147288, 2, { 408, 361 } },
    { 147315, 2, { 427, 345 } },
    { 147345, 2, { 517, 285 } },
    { 147400, 2, { 440, 335 } },
    { 147420, 2, { 390, 378 } },
    { 147490, 2, { 430, 343 } },
    { 147560, 2, { 434, 340 } },
    { 147576, 2, { 429, 344 } },
    { 147600, 2, { 400, 369 } },
    { 147609, 2, { 497, 297 } },
    { 147660, 2, { 428, 345 } },
    { 147680, 2, { 416, 355 } },
    { 147706, 2, { 437, 338 } },
    { 147735, 2, { 441, 335 } },
    { 147744, 2, { 432, 342 } },
    { 147768, 2, { 393, 376 } },
    { 147784, 2, { 392, 377 } },
    { 147798, 2, { 391, 378 } },
    { 147804, 2, { 436, 339 } },
    { 147825, 2, { 405, 365 } },
    { 147828, 2, { 388, 381 } },
    { 147840, 2, { 385, 384 } },
    { 147900, 2, { 425, 348 } },
    { 147936, 2, { 402, 368 } },
    { 147960, 2, { 411, 360 } },
    { 147968, 2, { 512, 289 } },
    { 148000, 2, { 400, 370 } },
    { 148092, 2, { 492, 301 } },
    { 148104, 2, { 396, 374 } },
    { 148148, 2, { 407, 364 } },
    { 148176, 2, { 392, 378 } },
    { 148185, 2, { 445, 333 } },
    { 148257, 2, { 459, 323 } },
    { 148304, 2, { 403, 368 } },
    { 148335, 2, { 435, 341 } },
    { 148400, 2, { 400, 371 } },
    { 148404, 2, { 447, 332 } },
    { 148410, 2, { 485, 306 } },
    { 148428, 2, { 399, 372 } },
    { 148452, 2, { 417, 356 } },
    { 148500, 2, { 396, 375 } },
    { 148520, 2, { 395, 376 } },
    { 148580, 2, { 391, 380 } },
    { 148584, 2, { 453, 328 } },
    { 148608, 2, { 387, 384 } },
    { 148680, 2, { 413, 360 } },
    { 148716, 2, { 459, 324 } },
    { 148720, 2, { 440, 338 } },
    { 148770, 2, { 435, 342 } },
    { 148800, 2, { 400, 372 } },
    { 148824, 2, { 424, 351 } },
    { 148836, 2, { 471, 316 } },
    { 148920, 2, { 408, 365 } },
    { 148925, 2, { 575, 259 } },
    { 148995, 2, { 387, 385 } },
    { 149040, 2, { 405, 368 } },
    { 149058, 2, { 441, 338 } },
    { 149076, 2, { 404, 369 } },
    { 149100, 2, { 420, 355 } },
    { 149160, 2, { 440, 339 } },
    { 149175, 2, { 425, 351 } },
    { 149184, 2, { 444, 336 } },
    { 149205, 2, { 435, 343 } },
    { 149292, 2, { 396, 377 } },
    { 149310, 2, { 395, 378 } },
    { 149328, 2, { 408, 366 } },
    { 149340, 2, { 393, 380 } },
    { 149352, 2, { 392, 381 } },
    { 149400, 2, { 415, 360 } },
    { 149408, 2, { 406, 368 } },
    { 149435, 2, { 605, 247 } },
    { 149450, 2, { 427, 350 } },
    { 149556, 2, { 412, 363 } },
    { 149600, 2, { 400, 374 } },
    { 149604, 2, { 411, 364 } },
    { 149625, 2, { 399, 375 } },
    { 149640, 2, { 430, 348 } },
    { 149730, 2, { 434, 345 } },
    { 149760, 2, { 390, 384 } },
    { 149776, 2, { 407, 368 } },
    { 149850, 2, { 405, 370 } },
    { 149877, 2, { 427, 351 } },
    { 149891, 2, { 437, 343 } },
    { 149940, 2, { 420, 357 } },
    { 149952, 2, { 426, 352 } },
    { 150000, 2, { 400, 375 } },
    { 150024, 2, { 399, 376 } },
    { 150040, 2, { 440, 341 } },
    { 150080, 2, { 448, 335 } },
    { 150096, 2, { 424, 354 } },
    { 150120, 2, { 417, 360 } },
    { 150144, 2, { 391, 384 } },
    { 150150, 2, { 390, 385 } },
    { 150156, 2, { 388, 387 } },
    { 150165, 2, { 423, 355 } },
    { 150176, 2, { 416, 361 } },
    { 150192, 2, { 447, 336 } },
    { 150228, 2, { 428, 351 } },
    { 150255, 2, { 405, 371 } },
    { 150304, 2, { 427, 352 } },
    { 150336, 2, { 432, 348 } },
    { 150381, 2, { 441, 341 } },
    { 150396, 2, { 453, 332 } },
    { 150420, 2, { 436, 345 } },
    { 150423, 2, { 399, 377 } },
    { 150450, 2, { 425, 354 } },
    { 150480, 2, { 396, 380 } },
    { 150516, 2, { 444, 339 } },
    { 150520, 2, { 424, 355 } },
    { 150528, 2, { 392, 384 } },
    { 150535, 2, { 391, 385 } },
    { 150552, 2, { 408, 369 } },
    { 150588, 2, { 423, 356 } },
    { 150660, 2, { 405, 372 } },
    { 150672, 2, { 438, 344 } },
    { 150675, 2, { 525, 287 } },
    { 150720, 2, { 471, 320 } },
    { 150722, 2, { 403, 374 } },
    { 150800, 2, { 400, 377 } },
    { 150822, 2, { 399, 378 } },
    { 150858, 2, { 493, 306 } },
    { 150876, 2, { 396, 381 } },
    { 150880, 2, { 410, 368 } },
    { 150912, 2, { 393, 384 } },
    { 150920, 2, { 392, 385 } },
    { 150960, 2, { 408, 370 } },
    { 150975, 2, { 495, 305 } },
    { 151008, 2, { 416, 363 } },
    { 151050, 2, { 475, 318 } },
    { 151088, 2, { 497, 304 } },
    { 151110, 2, { 414, 365 } },
    { 151125, 2, { 403, 375 } },
    { 151152, 2, { 402, 376 } },
    { 151200, 2, { 400, 378 } },
    { 151248, 2, { 411, 368 } },
    { 151256, 2, { 511, 296 } },
    { 151335, 2, { 513, 295 } },
    { 151340, 2, { 460, 329 } },
    { 151360, 2, { 430, 352 } },
    { 151368, 2, { 408, 371 } },
    { 151380, 2, { 435, 348 } },
    { 151404, 2, { 407, 372 } },
    { 151470, 2, { 405, 374 } },
    { 151500, 2, { 404, 375 } },
    { 151515, 2, { 455, 333 } },
    { 151525, 2, { 475, 319 } },
    { 151536, 2, { 451, 336 } },
    { 151606, 2, { 442, 343 } },
    { 151620, 2, { 399, 380 } },
    { 151632, 2, { 432, 351 } },
    { 151641, 2, { 581, 261 } },
    { 151680, 2, { 395, 384 } },
    { 151704, 2, { 392, 387 } },
    { 151767, 2, { 511, 297 } },
    { 151788, 2, { 417, 364 } },
    { 151800, 2, { 440, 345 } },
    { 151840, 2, { 416, 365 } },
    { 151872, 2, { 448, 339 } },
    { 151875, 2, { 405, 375 } },
    { 151890, 2, { 415, 366 } },
    { 151900, 2, { 434, 350 } },
    { 151905, 2, { 533, 285 } },
    { 151980, 2, { 447, 340 } },
    { 151984, 2, { 413, 368 } },
    { 152028, 2, { 412, 369 } },
    { 152064, 2, { 396, 384 } },
    { 152110, 2, { 410, 371 } },
    { 152152, 2, { 418, 364 } },
    { 152190, 2, { 445, 342 } },
    { 152208, 2, { 453, 336 } },
    { 152250, 2, { 406, 375 } },
    { 152256, 2, { 416, 366 } },
    { 152280, 2, { 405, 376 } },
    { 152292, 2, { 444, 343 } },
    { 152306, 2, { 473, 322 } },
    { 152320, 2, { 448, 340 } },
    { 152334, 2, { 403, 378 } },
    { 152352, 2, { 414, 368 } },
    { 152388, 2, { 459, 332 } },
    { 152397, 2, { 413, 369 } },
    { 152400, 2, { 400, 381 } },
    { 152460, 2, { 396, 385 } },
    { 152484, 2, { 393, 388 } },
    { 152490, 2, { 391, 390 } },
    { 152520, 2, { 410, 372 } },
    { 152604, 2, { 471, 324 } },
    { 152625, 2, { 407, 375 } },
    { 152685, 2, { 405, 377 } },
    { 152720, 2, { 415, 368 } },
    { 152724, 2, { 429, 356 } },
    { 152768, 2, { 434, 352 } },
    { 152775, 2, { 485, 315 } },
    { 152796, 2, { 428, 357 } },
    { 152810, 2, { 413, 370 } },
    { 152865, 2, { 395, 387 } },
    { 152880, 2, { 392, 390 } },
    { 152892, 2, { 411, 372 } },
    { 152928, 2, { 432, 354 } },
    { 152950, 2, { 437, 350 } },
    { 152985, 2, { 465, 329 } },
    { 153000, 2, { 408, 375 } },
    { 153036, 2, { 436, 351 } },
    { 153120, 2, { 435, 352 } },
    { 153125, 2, { 625, 245 } },
    { 153135, 2, { 415, 369 } },
    { 153140, 2, { 403, 380 } },
    { 153180, 2, { 414, 370 } },
    { 153216, 2, { 399, 384 } },
    { 153252, 2, { 396, 387 } },
    { 153272, 2, { 392, 391 } },
    { 153300, 2, { 420, 365 } },
    { 153360, 2, { 426, 360 } },
    { 153387, 2, { 437, 351 } },
    { 153400, 2, { 472, 325 } },
    { 153425, 2, { 425, 361 } },
    { 153450, 2, { 450, 341 } },
    { 153456, 2, { 417, 368 } },
    { 153468, 2, { 406, 378 } },
    { 153504, 2, { 416, 369 } },
    { 153594, 2, { 414, 371 } },
    { 153600, 2, { 400, 384 } },
    { 153636, 2, { 413, 372 } },
    { 153725, 2, { 473, 325 } },
    { 153748, 2, { 476, 323 } },
    { 153765, 2, { 459, 335 } },
    { 153768, 2, { 447, 344 } },
    { 153816, 2, { 408, 377 } },
    { 153832, 2, { 469, 328 } },
    { 153846, 2, { 407, 378 } },
    { 153900, 2, { 405, 380 } },
    { 153912, 2, { 424, 363 } },
    { 153920, 2, { 416, 370 } },
    { 153924, 2, { 404, 381 } },
    { 153972, 2, { 423, 364 } },
    { 154000, 2, { 400, 385 } },
    { 154020, 2, { 453, 340 } },
    { 154050, 2, { 395, 390 } },
    { 154056, 2, { 393, 392 } },
    { 154077, 2, { 483, 319 } },
    { 154154, 2, { 539, 286 } },
    { 154176, 2, { 438, 352 } },
    { 154224, 2, { 408, 378 } },
    { 154230, 2, { 485, 318 } },
    { 154280, 2, { 406, 380 } },
    { 154287, 2, { 553, 279 } },
    { 154336, 2, { 416, 371 } },
    { 154368, 2, { 402, 384 } },
    { 154380, 2, { 415, 372 } },
    { 154395, 2, { 423, 365 } },
    { 154440, 2, { 396, 390 } },
    { 154488, 2, { 471, 328 } },
    { 154500, 2, { 412, 375 } },
    { 154530, 2, { 505, 306 } },
    { 154536, 2, { 411, 376 } },
    { 154548, 2, { 477, 324 } },
    { 154560, 2, { 420, 368 } },
    { 154660, 2, { 407, 380 } },
    { 154693, 2, { 451, 343 } },
    { 154752, 2, { 403, 384 } },
    { 154760, 2, { 424, 365 } },
    { 154770, 2, { 402, 385 } },
    { 154800, 2, { 400, 387 } },
    { 154812, 2, { 399, 388 } },
    { 154836, 2, { 396, 391 } },
    { 154840, 2, { 395, 392 } },
    { 154860, 2, { 435, 356 } },
    { 154869, 2, { 429, 361 } },
    { 154875, 2, { 413, 375 } },
    { 154882, 2, { 481, 322 } },
    { 154980, 2, { 410, 378 } },
    { 155025, 2, { 477, 325 } },
    { 155034, 2, { 486, 319 } },
    { 155040, 2, { 408, 380 } },
    { 155124, 2, { 417, 372 } },
    { 155142, 2, { 442, 351 } },
    { 155155, 2, { 403, 385 } },
    { 155184, 2, { 424, 366 } },
    { 155250, 2, { 414, 375 } },
    { 155288, 2, { 413, 376 } },
    { 155344, 2, { 511, 304 } },
    { 155364, 2, { 428, 363 } },
    { 155400, 2, { 420, 370 } },
    { 155440, 2, { 464, 335 } },
    { 155448, 2, { 408, 381 } },
    { 155472, 2, { 474, 328 } },
    { 155490, 2, { 426, 365 } },
    { 155520, 2, { 405, 384 } },
    { 155550, 2, { 425, 366 } },
    { 155556, 2, { 447, 348 } },
    { 155584, 2, { 416, 374 } },
    { 155595, 2, { 451, 345 } },
    { 155610, 2, { 399, 390 } },
    { 155628, 2, { 396, 393 } },
    { 155652, 2, { 436, 357 } },
    { 155664, 2, { 414, 376 } },
    { 155760, 2, { 440, 354 } },
    { 155771, 2, { 539, 289 } },
    { 155805, 2, { 611, 255 } },
    { 155820, 2, { 420, 371 } },
    { 155832, 2, { 453, 344 } },
    { 155844, 2, { 444, 351 } },
    { 155904, 2, { 406, 384 } },
    { 155925, 2, { 405, 385 } },
    { 155940, 2, { 452, 345 } },
    { 155952, 2, { 432, 361 } },
    { 156000, 2, { 400, 390 } },
    { 156009, 2, { 399, 391 } },
    { 156040, 2, { 415, 376 } },
    { 156060, 2, { 459, 340 } },
    { 156078, 2, { 414, 377 } },
    { 156114, 2, { 413, 378 } },
    { 156156, 2, { 429, 364 } },
    { 156177, 2, { 469, 333 } },
    { 156180, 2, { 411, 380 } },
    { 156195, 2, { 445, 351 } },
    { 156200, 2, { 440, 355 } },
    { 156275, 2, { 475, 329 } },
    { 156288, 2, { 407, 384 } },
    { 156325, 2, { 481, 325 } },
    { 156348, 2, { 404, 387 } },
    { 156372, 2, { 471, 332 } },
    { 156400, 2, { 400, 391 } },
    { 156408, 2, { 399, 392 } },
    { 156420, 2, { 396, 395 } },
    { 156456, 2, { 424, 369 } },
    { 156465, 2, { 513, 305 } },
    { 156519, 2, { 459, 341 } },
    { 156555, 2, { 441, 355 } },
    { 156600, 2, { 435, 360 } },
    { 156672, 2, { 408, 384 } },
    { 156695, 2, { 407, 385 } },
    { 156702, 2, { 533, 294 } },
    { 156750, 2, { 418, 375 } },
    { 156768, 2, { 426, 368 } },
    { 156792, 2, { 417, 376 } },
    { 156800, 2, { 400, 392 } },
    { 156825, 2, { 425, 369 } },
    { 156832, 2, { 416, 377 } },
    { 156860, 2, { 460, 341 } },
    { 156870, 2, { 415, 378 } },
    { 156933, 2, { 423, 371 } },
    { 156940, 2, { 413, 380 } },
    { 156948, 2, { 451, 348 } },
    { 156972, 2, { 412, 381 } },
    { 156996, 2, { 441, 356 } },
    { 157080, 2, { 408, 385 } },
    { 157113, 2, { 529, 297 } },
    { 157136, 2, { 427, 368 } },
    { 157140, 2, { 405, 388 } },
    { 157170, 2, { 403, 390 } },
    { 157200, 2, { 400, 393 } },
    { 157248, 2, { 416, 378 } },
    { 157325, 2, { 725, 217 } },
    { 157339, 2, { 637, 247 } },
    { 157344, 2, { 447, 352 } },
    { 157356, 2, { 423, 372 } },
    { 157440, 2, { 410, 384 } },
    { 157472, 2, { 518, 304 } },
    { 157500, 2, { 420, 375 } },
    { 157530, 2, { 445, 354 } },
    { 157563, 2, { 427, 369 } },
    { 157584, 2, { 402, 392 } },
    { 157586, 2, { 418, 377 } },
    { 157644, 2, { 453, 348 } },
    { 157675, 2, { 425, 371 } },
    { 157680, 2, { 432, 365 } },
    { 157780, 2, { 460, 343 } },
    { 157824, 2, { 411, 384 } },
    { 157872, 2, { 429, 368 } },
    { 157896, 2, { 408, 387 } },
    { 157932, 2, { 428, 369 } },
    { 157950, 2, { 405, 390 } },
    { 157976, 2, { 403, 392 } },
    { 157990, 2, { 427, 370 } },
    { 158000, 2, { 400, 395 } },
    { 158004, 2, { 399, 396 } },
    { 158015, 2, { 715, 221 } },
    { 158025, 2, { 525, 301 } },
    { 158080, 2, { 416, 380 } },
    { 158100, 2, { 425, 372 } },
    { 158112, 2, { 432, 366 } },
    { 158120, 2, { 472, 335 } },
    { 158175, 2, { 475, 333 } },
    { 158224, 2, { 464, 341 } },
    { 158240, 2, { 430, 368 } },
    { 158256, 2, { 471, 336 } },
    { 158268, 2, { 436, 363 } },
    { 158270, 2, { 490, 323 } },
    { 158340, 2, { 406, 390 } },
    { 158355, 2, { 405, 391 } },
    { 158364, 2, { 477, 332 } },
    { 158400, 2, { 400, 396 } },
    { 158424, 2, { 483, 328 } },
    { 158460, 2, { 417, 380 } },
    { 158496, 2, { 416, 381 } },
    { 158508, 2, { 444, 357 } },
    { 158592, 2, { 413, 384 } },
    { 158600, 2, { 488, 325 } },
    { 158631, 2, { 437, 363 } },
    { 158652, 2, { 452, 351 } },
    { 158730, 2, { 407, 390 } },
    { 158752, 2, { 451, 352 } },
    { 158760, 2, { 405, 392 } },
    { 158772, 2, { 404, 393 } },
    { 158790, 2, { 402, 395 } },
    { 158844, 2, { 427, 372 } },
    { 158928, 2, { 462, 344 } },
    { 158976, 2, { 414, 384 } },
    { 159000, 2, { 424, 375 } },
    { 159030, 2, { 465, 342 } },
    { 159040, 2, { 448, 355 } },
    { 159048, 2, { 423, 376 } },
    { 159068, 2, { 437, 364 } },
    { 159075, 2, { 505, 315 } },
    { 159120, 2, { 408, 390 } },
    { 159132, 2, { 447, 356 } },
    { 159250, 2, { 455, 350 } },
    { 159264, 2, { 474, 336 } },
    { 159285, 2, { 555, 287 } },
    { 159315, 2, { 559, 285 } },
    { 159360, 2, { 415, 384 } },
    { 159390, 2, { 414, 385 } },
    { 159408, 2, { 432, 369 } },
    { 159444, 2, { 412, 387 } },
    { 159456, 2, { 453, 352 } },
    { 159460, 2, { 469, 340 } },
    { 159468, 2, { 411, 388 } },
    { 159495, 2, { 465, 343 } },
    { 159500, 2, { 500, 319 } },
    { 159528, 2, { 408, 391 } },
    { 159530, 2, { 430, 371 } },
    { 159544, 2, { 407, 392 } },
    { 159562, 2, { 442, 361 } },
    { 159588, 2, { 403, 396 } },
    { 159600, 2, { 400, 399 } },
    { 159705, 2, { 455, 351 } },
    { 159712, 2, { 434, 368 } },
    { 159720, 2, { 440, 363 } },
    { 159732, 2, { 459, 348 } },
    { 159795, 2, { 477, 335 } },
    { 159800, 2, { 425, 376 } },
    { 159831, 2, { 413, 387 } },
    { 159840, 2, { 432, 370 } },
    { 159885, 2, { 495, 323 } },
    { 159960, 2, { 430, 372 } },
    { 159975, 2, { 405, 395 } },
    { 160020, 2, { 420, 381 } },
    { 160050, 2, { 485, 330 } },
    { 160056, 2, { 456, 351 } },
    { 160080, 2, { 435, 368 } },
    { 160083, 2, { 441, 363 } },
    { 160125, 2, { 427, 375 } },
    { 160128, 2, { 417, 384 } },
    { 160140, 2, { 471, 340 } },
    { 160160, 2, { 416, 385 } },
    { 160176, 2, { 426, 376 } },
    { 160200, 2, { 445, 360 } },
    { 160225, 2, { 425, 377 } },
    { 160272, 2, { 424, 378 } },
    { 160325, 2, { 583, 275 } },
    { 160344, 2, { 408, 393 } },
    { 160356, 2, { 483, 332 } },
    { 160380, 2, { 405, 396 } },
    { 160392, 2, { 489, 328 } },
    { 160500, 2, { 428, 375 } },
    { 160512, 2, { 418, 384 } },
    { 160524, 2, { 441, 364 } },
    { 160552, 2, { 427, 376 } },
    { 160590, 2, { 505, 318 } },
    { 160600, 2, { 440, 365 } },
    { 160605, 2, { 415, 387 } },
    { 160650, 2, { 425, 378 } },
    { 160704, 2, { 432, 372 } },
    { 160740, 2, { 423, 380 } },
    { 160776, 2, { 406, 396 } },
    { 160797, 2, { 403, 399 } },
    { 160800, 2, { 402, 400 } },
    { 160875, 2, { 429, 375 } },
    { 160884, 2, { 436, 369 } },
    { 160888, 2, { 442, 364 } },
    { 160920, 2, { 447, 360 } },
    { 160930, 2, { 418, 385 } },
    { 160965, 2, { 441, 365 } },
    { 160992, 2, { 416, 387 } },
    { 161007, 2, { 451, 357 } },
    { 161040, 2, { 440, 366 } },
    { 161070, 2, { 413, 390 } },
    { 161112, 2, { 411, 392 } },
    { 161160, 2, { 408, 395 } },
    { 161161, 2, { 539, 299 } },
    { 161172, 2, { 407, 396 } },
    { 161184, 2, { 438, 368 } },
    { 161196, 2, { 404, 399 } },
    { 161200, 2, { 403, 400 } },
    { 161210, 2, { 470, 343 } },
    { 161262, 2, { 527, 306 } },
    { 161268, 2, { 453, 356 } },
    { 161280, 2, { 420, 384 } },
    { 161304, 2, { 429, 376 } },
    { 161336, 2, { 469, 344 } },
    { 161364, 2, { 452, 357 } },
    { 161385, 2, { 435, 371 } },
    { 161406, 2, { 427, 378 } },
    { 161424, 2, { 456, 354 } },
    { 161505, 2, { 485, 333 } },
    { 161544, 2, { 424, 381 } },
    { 161595, 2, { 405, 399 } },
    { 161700, 2, { 420, 385 } },
    { 161728, 2, { 448, 361 } },
    { 161733, 2, { 429, 377 } },
    { 161796, 2, { 417, 388 } },
    { 161805, 2, { 469, 345 } },
    { 161820, 2, { 435, 372 } },
    { 161850, 2, { 415, 390 } },
    { 161868, 2, { 492, 329 } },
    { 161875, 2, { 625, 259 } },
    { 161896, 2, { 413, 392 } },
    { 161916, 2, { 412, 393 } },
    { 161955, 2, { 531, 305 } },
    { 161975, 2, { 475, 341 } },
    { 162000, 2, { 405, 400 } },
    { 162024, 2, { 471, 344 } },
    { 162099, 2, { 581, 279 } },
    { 162162, 2, { 429, 378 } },
    { 162180, 2, { 477, 340 } },
    { 162225, 2, { 515, 315 } },
    { 162239, 2, { 473, 343 } },
    { 162240, 2, { 416, 390 } },
    { 162260, 2, { 427, 380 } },
    { 162288, 2, { 414, 392 } },
    { 162348, 2, { 489, 332 } },
    { 162360, 2, { 410, 396 } },
    { 162393, 2, { 407, 399 } },
    { 162400, 2, { 406, 400 } },
    { 162432, 2, { 423, 384 } },
    { 162450, 2, { 450, 361 } },
    { 162540, 2, { 420, 387 } },
    { 162624, 2, { 448, 363 } },
    { 162656, 2, { 416, 391 } },
    { 162680, 2, { 415, 392 } },
    { 162708, 2, { 447, 364 } },
    { 162750, 2, { 434, 375 } },
    { 162756, 2, { 411, 396 } },
    { 162792, 2, { 408, 399 } },
    { 162800, 2, { 407, 400 } },
    { 162855, 2, { 423, 385 } },
    { 162864, 2, { 432, 377 } },
    { 162870, 2, { 445, 366 } },
    { 162925, 2, { 475, 343 } },
    { 162945, 2, { 459, 355 } },
    { 163016, 2, { 497, 328 } },
    { 163020, 2, { 418, 390 } },
    { 163056, 2, { 474, 344 } },
    { 163068, 2, { 428, 381 } },
    { 163080, 2, { 453, 360 } },
    { 163185, 2, { 473, 345 } },
    { 163215, 2, { 405, 403 } },
    { 163240, 2, { 424, 385 } },
    { 163296, 2, { 432, 378 } },
    { 163350, 2, { 450, 363 } },
    { 163392, 2, { 444, 368 } },
    { 163404, 2, { 459, 356 } },
    { 163415, 2, { 667, 245 } },
    { 163438, 2, { 418, 391 } },
    { 163464, 2, { 417, 392 } },
    { 163480, 2, { 488, 335 } },
    { 163488, 2, { 416, 393 } },
    { 163500, 2, { 436, 375 } },
    { 163520, 2, { 448, 365 } },
    { 163530, 2, { 414, 395 } },
    { 163548, 2, { 413, 396 } },
    { 163560, 2, { 435, 376 } },
    { 163584, 2, { 426, 384 } },
    { 163592, 2, { 484, 338 } },
    { 163611, 2, { 441, 371 } },
    { 163618, 2, { 406, 403 } },
    { 163620, 2, { 405, 404 } },
    { 163647, 2, { 513, 319 } },
    { 163760, 2, { 445, 368 } },
    { 163761, 2, { 507, 323 } },
    { 163770, 2, { 515, 318 } },
    { 163836, 2, { 444, 369 } },
    { 163856, 2, { 418, 392 } },
    { 163875, 2, { 437, 375 } },
    { 163908, 2, { 471, 348 } },
    { 163968, 2, { 427, 384 } },
    { 164000, 2, { 410, 400 } },
    { 164010, 2, { 426, 385 } },
    { 164016, 2, { 408, 402 } },
    { 164052, 2, { 434, 378 } },
    { 164076, 2, { 452, 363 } },
    { 164088, 2, { 424, 387 } },
    { 164124, 2, { 423, 388 } },
    { 164150, 2, { 469, 350 } },
    { 164160, 2, { 432, 380 } },
    { 164164, 2, { 451, 364 } },
    { 164205, 2, { 445, 369 } },
    { 164220, 2, { 420, 391 } },
    { 164241, 2, { 553, 297 } },
    { 164255, 2, { 455, 361 } },
    { 164256, 2, { 464, 354 } },
    { 164304, 2, { 489, 336 } },
    { 164320, 2, { 416, 395 } },
    { 164340, 2, { 415, 396 } },
    { 164388, 2, { 412, 399 } },
    { 164400, 2, { 411, 400 } },
    { 164424, 2, { 408, 403 } },
    { 164430, 2, { 406, 405 } },
    { 164450, 2, { 506, 325 } },
    { 164475, 2, { 425, 387 } },
    { 164496, 2, { 447, 368 } },
    { 164502, 2, { 481, 342 } },
    { 164560, 2, { 440, 374 } },
    { 164592, 2, { 432, 381 } },
    { 164604, 2, { 473, 348 } },
    { 164619, 2, { 469, 351 } },
    { 164688, 2, { 438, 376 } },
    { 164703, 2, { 483, 341 } },
    { 164720, 2, { 464, 355 } },
    { 164724, 2, { 444, 371 } },
    { 164730, 2, { 510, 323 } },
    { 164736, 2, { 416, 396 } },
    { 164835, 2, { 407, 405 } },
    { 164892, 2, { 453, 364 } },
    { 164920, 2, { 434, 380 } },
    { 164934, 2, { 441, 374 } },
    { 164983, 2, { 481, 343 } },
    { 165000, 2, { 440, 375 } },
    { 165025, 2, { 575, 287 } },
    { 165048, 2, { 529, 312 } },
    { 165060, 2, { 420, 393 } },
    { 165088, 2, { 469, 352 } },
    { 165120, 2, { 430, 384 } },
    { 165132, 2, { 417, 396 } },
    { 165165, 2, { 429, 385 } },
    { 165200, 2, { 413, 400 } },
    { 165240, 2, { 408, 405 } },
    { 165242, 2, { 407, 406 } },
    { 165249, 2, { 427, 387 } },
    { 165300, 2, { 435, 380 } },
    { 165312, 2, { 448, 369 } },
    { 165360, 2, { 424, 390 } },
    { 165375, 2, { 441, 375 } },
    { 165376, 2, { 512, 323 } },
    { 165501, 2, { 497, 333 } },
    { 165528, 2, { 418, 396 } },
    { 165540, 2, { 445, 372 } },
    { 165600, 2, { 414, 400 } },
    { 165636, 2, { 428, 387 } },
    { 165648, 2, { 408, 406 } },
    { 165699, 2, { 459, 361 } },
    { 165726, 2, { 486, 341 } },
    { 165750, 2, { 425, 390 } },
    { 165760, 2, { 448, 370 } },
    { 165792, 2, { 471, 352 } },
    { 165816, 2, { 423, 392 } },
    { 165825, 2, { 495, 335 } },
    { 165870, 2, { 485, 342 } },
    { 165880, 2, { 440, 377 } },
    { 165888, 2, { 432, 384 } },
    { 165900, 2, { 420, 395 } },
    { 165945, 2, { 481, 345 } },
    { 165968, 2, { 451, 368 } },
    { 165984, 2, { 416, 399 } },
    { 165996, 2, { 477, 348 } },
    { 166000, 2, { 415, 400 } },
    { 166012, 2, { 484, 343 } },
    { 166044, 2, { 411, 404 } },
    { 166050, 2, { 410, 405 } },
    { 166056, 2, { 408, 407 } },
    { 166060, 2, { 437, 380 } },
    { 166116, 2, { 436, 381 } },
    { 166152, 2, { 483, 344 } },
    { 166155, 2, { 583, 285 } },
    { 166160, 2, { 496, 335 } },
    { 166175, 2, { 425, 391 } },
    { 166257, 2, { 441, 377 } },
    { 166260, 2, { 489, 340 } },
    { 166284, 2, { 447, 372 } },
    { 166452, 2, { 429, 388 } },
    { 166496, 2, { 473, 352 } },
    { 166500, 2, { 444, 375 } },
    { 166530, 2, { 427, 390 } },
    { 166600, 2, { 425, 392 } },
    { 166632, 2, { 424, 393 } },
    { 166650, 2, { 505, 330 } },
    { 166656, 2, { 434, 384 } },
    { 166704, 2, { 453, 368 } },
    { 166725, 2, { 475, 351 } },
    { 166788, 2, { 452, 369 } },
    { 166800, 2, { 417, 400 } },
    { 166830, 2, { 415, 402 } },
    { 166842, 2, { 414, 403 } },
    { 166848, 2, { 474, 352 } },
    { 166860, 2, { 412, 405 } },
    { 166896, 2, { 456, 366 } },
    { 166950, 2, { 450, 371 } },
    { 166980, 2, { 460, 363 } },
    { 166992, 2, { 426, 392 } },
    { 167040, 2, { 435, 384 } },
    { 167055, 2, { 555, 301 } },
    { 167076, 2, { 442, 378 } },
    { 167085, 2, { 423, 395 } },
    { 167184, 2, { 432, 387 } },
    { 167200, 2, { 418, 400 } },
    { 167232, 2, { 416, 402 } },
    { 167265, 2, { 413, 405 } },
    { 167280, 2, { 410, 408 } },
    { 167320, 2, { 445, 376 } },
    { 167328, 2, { 498, 336 } },
    { 167384, 2, { 427, 392 } },
    { 167440, 2, { 455, 368 } },
    { 167480, 2, { 424, 395 } },
    { 167508, 2, { 423, 396 } },
    { 167535, 2, { 459, 365 } },
    { 167552, 2, { 448, 374 } },
    { 167560, 2, { 472, 355 } },
    { 167580, 2, { 420, 399 } },
    { 167608, 2, { 511, 328 } },
    { 167620, 2, { 493, 340 } },
    { 167640, 2, { 440, 381 } },
    { 167648, 2, { 416, 403 } },
    { 167676, 2, { 471, 356 } },
    { 167688, 2, { 411, 408 } },
    { 167739, 2, { 429, 391 } },
    { 167772, 2, { 451, 372 } },
    { 167808, 2, { 437, 384 } },
    { 167895, 2, { 455, 369 } },
    { 168000, 2, { 420, 400 } },
    { 168025, 2, { 517, 325 } },
    { 168072, 2, { 447, 376 } },
    { 168075, 2, { 415, 405 } },
    { 168084, 2, { 414, 406 } },
    { 168150, 2, { 475, 354 } },
    { 168165, 2, { 505, 333 } },
    { 168168, 2, { 429, 392 } },
    { 168192, 2, { 438, 384 } },
    { 168204, 2, { 428, 393 } },
    { 168210, 2, { 445, 378 } },
    { 168216, 2, { 489, 344 } },
    { 168245, 2, { 437, 385 } },
    { 168264, 2, { 456, 369 } },
    { 168270, 2, { 426, 395 } },
    { 168300, 2, { 425, 396 } },
    { 168336, 2, { 501, 336 } },
    { 168432, 2, { 464, 363 } },
    { 168454, 2, { 418, 403 } },
    { 168468, 2, { 417, 404 } },
    { 168480, 2, { 416, 405 } },
    { 168498, 2, { 414, 407 } },
    { 168504, 2, { 413, 408 } },
    { 168516, 2, { 453, 372 } },
    { 168606, 2, { 493, 342 } },
    { 168630, 2, { 438, 385 } },
    { 168732, 2, { 436, 387 } },
    { 168756, 2, { 492, 343 } },
    { 168780, 2, { 435, 388 } },
    { 168831, 2, { 481, 351 } },
    { 168861, 2, { 473, 357 } },
    { 168896, 2, { 416, 406 } },
    { 168912, 2, { 414, 408 } },
    { 168948, 2, { 468, 361 } },
    { 168960, 2, { 440, 384 } },
    { 169000, 2, { 500, 338 } },
    { 169050, 2, { 483, 350 } },
    { 169065, 2, { 585, 289 } },
    { 169092, 2, { 427, 396 } },
    { 169099, 2, { 493, 343 } },
    { 169125, 2, { 451, 375 } },
    { 169164, 2, { 444, 381 } },
    { 169176, 2, { 424, 399 } },
    { 169200, 2, { 423, 400 } },
    { 169260, 2, { 420, 403 } },
    { 169290, 2, { 418, 405 } },
    { 169312, 2, { 416, 407 } },
    { 169320, 2, { 415, 408 } },
    { 169330, 2, { 413, 410 } },
    { 169332, 2, { 412, 411 } },
    { 169335, 2, { 477, 355 } },
    { 169344, 2, { 432, 392 } },
    { 169360, 2, { 464, 365 } },
    { 169400, 2, { 440, 385 } },
    { 169442, 2, { 494, 343 } },
    { 169500, 2, { 452, 375 } },
    { 169533, 2, { 483, 351 } },
    { 169560, 2, { 471, 360 } },
    { 169575, 2, { 425, 399 } },
    { 169728, 2, { 416, 408 } },
    { 169740, 2, { 414, 410 } },
    { 169764, 2, { 516, 329 } },
    { 169776, 2, { 432, 393 } },
    { 169785, 2, { 441, 385 } },
    { 169812, 2, { 477, 356 } },
    { 169824, 2, { 464, 366 } },
    { 169830, 2, { 459, 370 } },
    { 169860, 2, { 447, 380 } },
    { 169884, 2, { 429, 396 } },
    { 169950, 2, { 515, 330 } },
    { 170000, 2, { 425, 400 } },
    { 170016, 2, { 462, 368 } },
    { 170100, 2, { 420, 405 } },
    { 170136, 2, { 417, 408 } },
    { 170163, 2, { 511, 333 } },
    { 170170, 2, { 442, 385 } },
    { 170172, 2, { 489, 348 } },
    { 170235, 2, { 485, 351 } },
    { 170240, 2, { 448, 380 } },
    { 170280, 2, { 430, 396 } },
    { 170289, 2, { 459, 371 } },
    { 170328, 2, { 453, 376 } },
    { 170340, 2, { 501, 340 } },
    { 170400, 2, { 426, 400 } },
    { 170430, 2, { 437, 390 } },
    { 170448, 2, { 424, 402 } },
    { 170478, 2, { 451, 378 } },
    { 170496, 2, { 444, 384 } },
    { 170500, 2, { 500, 341 } },
    { 170520, 2, { 420, 406 } },
    { 170544, 2, { 418, 408 } },
    { 170560, 2, { 416, 410 } },
    { 170625, 2, { 455, 375 } },
    { 170640, 2, { 432, 395 } },
    { 170660, 2, { 460, 371 } },
    { 170688, 2, { 448, 381 } },
    { 170748, 2, { 459, 372 } },
    { 170772, 2, { 428, 399 } },
    { 170800, 2, { 427, 400 } },
    { 170850, 2, { 425, 402 } },
    { 170880, 2, { 445, 384 } },
    { 170892, 2, { 423, 404 } },
    { 170940, 2, { 420, 407 } },
    { 170968, 2, { 497, 344 } },
    { 170976, 2, { 416, 411 } },
    { 170982, 2, { 414, 413 } },
    { 171072, 2, { 432, 396 } },
    { 171080, 2, { 455, 376 } },
    { 171108, 2, { 441, 388 } },
    { 171216, 2, { 464, 369 } },
    { 171275, 2, { 425, 403 } },
    { 171304, 2, { 437, 392 } },
    { 171312, 2, { 498, 344 } },
    { 171336, 2, { 472, 363 } },
    { 171348, 2, { 436, 393 } },
    { 171444, 2, { 471, 364 } },
    { 171495, 2, { 515, 333 } },
    { 171520, 2, { 512, 335 } },
    { 171535, 2, { 455, 377 } },
    { 171600, 2, { 429, 400 } },
    { 171626, 2, { 533, 322 } },
    { 171648, 2, { 447, 384 } },
    { 171680, 2, { 464, 370 } },
    { 171690, 2, { 485, 354 } },
    { 171696, 2, { 438, 392 } },
    { 171717, 2, { 481, 357 } },
    { 171720, 2, { 424, 405 } },
    { 171804, 2, { 417, 412 } },
    { 171808, 2, { 416, 413 } },
    { 171810, 2, { 415, 414 } },
    { 171828, 2, { 444, 387 } },
    { 171836, 2, { 476, 361 } },
    { 171855, 2, { 513, 335 } },
    { 171864, 2, { 434, 396 } },
    { 171912, 2, { 456, 377 } },
    { 171925, 2, { 529, 325 } },
    { 171941, 2, { 539, 319 } },
    { 171948, 2, { 483, 356 } },
    { 172000, 2, { 430, 400 } },
    { 172040, 2, { 440, 391 } },
    { 172125, 2, { 425, 405 } },
    { 172128, 2, { 489, 352 } },
    { 172140, 2, { 453, 380 } },
    { 172172, 2, { 473, 364 } },
    { 172200, 2, { 420, 410 } },
    { 172212, 2, { 452, 381 } },
    { 172215, 2, { 445, 387 } },
    { 172224, 2, { 416, 414 } },
    { 172260, 2, { 435, 396 } },
    { 172280, 2, { 472, 365 } },
    { 172344, 2, { 501, 344 } },
    { 172368, 2, { 432, 399 } },
    { 172380, 2, { 442, 390 } },
    { 172431, 2, { 441, 391 } },
    { 172500, 2, { 460, 375 } },
    { 172515, 2, { 465, 371 } },
    { 172550, 2, { 425, 406 } },
    { 172557, 2, { 581, 297 } },
    { 172575, 2, { 531, 325 } },
    { 172584, 2, { 423, 408 } },
    { 172592, 2, { 469, 368 } },
    { 172608, 2, { 464, 372 } },
    { 172620, 2, { 420, 411 } },
    { 172640, 2, { 416, 415 } },
    { 172692, 2, { 468, 369 } },
    { 172710, 2, { 505, 342 } },
    { 172725, 2, { 525, 329 } },
    { 172752, 2, { 472, 366 } },
    { 172788, 2, { 462, 374 } },
    { 172800, 2, { 432, 400 } },
    { 172822, 2, { 442, 391 } },
    { 172872, 2, { 441, 392 } },
    { 172887, 2, { 429, 403 } },
    { 172920, 2, { 440, 393 } },
    { 172935, 2, { 427, 405 } },
    { 172975, 2, { 425, 407 } },
    { 172980, 2, { 465, 372 } },
    { 173010, 2, { 438, 395 } },
    { 173043, 2, { 459, 377 } },
    { 173061, 2, { 469, 369 } },
    { 173075, 2, { 575, 301 } },
    { 173184, 2, { 451, 384 } },
    { 173225, 2, { 533, 325 } },
    { 173240, 2, { 488, 355 } },
    { 173250, 2, { 450, 385 } },
    { 173264, 2, { 442, 392 } },
    { 173316, 2, { 429, 404 } },
    { 173328, 2, { 471, 368 } },
    { 173340, 2, { 428, 405 } },
    { 173376, 2, { 448, 387 } },
    { 173394, 2, { 494, 351 } },
    { 173400, 2, { 425, 408 } },
    { 173420, 2, { 460, 377 } },
    { 173436, 2, { 447, 388 } },
    { 173460, 2, { 420, 413 } },
    { 173472, 2, { 417, 416 } },
    { 173530, 2, { 469, 370 } },
    { 173550, 2, { 445, 390 } },
    { 173558, 2, { 506, 343 } },
    { 173600, 2, { 434, 400 } },
    { 173628, 2, { 468, 371 } },
    { 173635, 2, { 451, 385 } },
    { 173664, 2, { 432, 402 } },
    { 173712, 2, { 462, 376 } },
    { 173736, 2, { 456, 381 } },
    { 173745, 2, { 429, 405 } },
    { 173800, 2, { 440, 395 } },
    { 173808, 2, { 426, 408 } },
    { 173817, 2, { 623, 279 } },
    { 173850, 2, { 475, 366 } },
    { 173888, 2, { 418, 416 } },
    { 173901, 2, { 507, 343 } },
    { 173952, 2, { 453, 384 } },
    { 173964, 2, { 436, 399 } },
    { 174000, 2, { 435, 400 } },
    { 174064, 2, { 473, 368 } },
    { 174080, 2, { 512, 340 } },
    { 174084, 2, { 489, 356 } },
    { 174096, 2, { 432, 403 } },
    { 174097, 2, { 539, 323 } },
    { 174105, 2, { 477, 365 } },
    { 174135, 2, { 611, 285 } },
    { 174150, 2, { 430, 405 } },
    { 174168, 2, { 472, 369 } },
    { 174195, 2, { 441, 395 } },
    { 174200, 2, { 520, 335 } },
    { 174216, 2, { 427, 408 } },
    { 174264, 2, { 424, 411 } },
    { 174276, 2, { 423, 412 } },
    { 174300, 2, { 420, 415 } },
    { 174348, 2, { 501, 348 } },
    { 174363, 2, { 437, 399 } },
    { 174370, 2, { 470, 371 } },
    { 174408, 2, { 507, 344 } },
    { 174420, 2, { 459, 380 } },
    { 174432, 2, { 474, 368 } },
    { 174440, 2, { 445, 392 } },
    { 174447, 2, { 497, 351 } },
    { 174492, 2, { 444, 393 } },
    { 174636, 2, { 441, 396 } },
    { 174685, 2, { 713, 245 } },
    { 174699, 2, { 423, 413 } },
    { 174720, 2, { 420, 416 } },
    { 174800, 2, { 437, 400 } },
    { 174840, 2, { 465, 376 } },
    { 174845, 2, { 605, 289 } },
    { 174924, 2, { 452, 387 } },
    { 174933, 2, { 513, 341 } },
    { 174944, 2, { 497, 352 } },
    { 174960, 2, { 432, 405 } },
    { 175032, 2, { 429, 408 } },
    { 175070, 2, { 427, 410 } },
    { 175084, 2, { 481, 364 } },
    { 175104, 2, { 456, 384 } },
    { 175112, 2, { 424, 413 } },
    { 175140, 2, { 420, 417 } },
    { 175168, 2, { 448, 391 } },
    { 175200, 2, { 438, 400 } },
    { 175212, 2, { 471, 372 } },
    { 175224, 2, { 447, 392 } },
    { 175260, 2, { 460, 381 } },
    { 175275, 2, { 475, 369 } },
    { 175296, 2, { 498, 352 } },
    { 175305, 2, { 435, 403 } },
    { 175380, 2, { 444, 395 } },
    { 175392, 2, { 432, 406 } },
    { 175440, 2, { 430, 408 } },
    { 175446, 2, { 486, 361 } },
    { 175450, 2, { 550, 319 } },
    { 175525, 2, { 425, 413 } },
    { 175536, 2, { 424, 414 } },
    { 175545, 2, { 423, 415 } },
    { 175560, 2, { 420, 418 } },
    { 175644, 2, { 476, 369 } },
    { 175680, 2, { 480, 366 } },
    { 175712, 2, { 544, 323 } },
    { 175725, 2, { 495, 355 } },
    { 175740, 2, { 435, 404 } },
    { 175764, 2, { 453, 388 } },
    { 175770, 2, { 434, 405 } },
    { 175784, 2, { 511, 344 } },
    { 175812, 2, { 483, 364 } },
    { 175824, 2, { 432, 407 } },
    { 175875, 2, { 469, 375 } },
    { 175908, 2, { 428, 411 } },
    { 175950, 2, { 425, 414 } },
    { 175956, 2, { 473, 372 } },
    { 175960, 2, { 424, 415 } },
    { 175968, 2, { 423, 416 } },
    { 176001, 2, { 493, 357 } },
    { 176040, 2, { 489, 360 } },
    { 176064, 2, { 448, 393 } },
    { 176080, 2, { 496, 355 } },
    { 176085, 2, { 455, 387 } },
    { 176130, 2, { 515, 342 } },
    { 176175, 2, { 435, 405 } },
    { 176220, 2, { 445, 396 } },
    { 176225, 2, { 475, 371 } },
    { 176344, 2, { 469, 376 } },
    { 176352, 2, { 501, 352 } },
    { 176418, 2, { 486, 363 } },
    { 176436, 2, { 468, 377 } },
    { 176472, 2, { 456, 387 } },
    { 176550, 2, { 535, 330 } },
    { 176580, 2, { 436, 405 } },
    { 176605, 2, { 715, 247 } },
    { 176638, 2, { 434, 407 } },
    { 176640, 2, { 460, 384 } },
    { 176700, 2, { 465, 380 } },
    { 176715, 2, { 459, 385 } },
    { 176748, 2, { 429, 412 } },
    { 176778, 2, { 427, 414 } },
    { 176784, 2, { 464, 381 } },
    { 176790, 2, { 426, 415 } },
    { 176792, 2, { 451, 392 } },
    { 176800, 2, { 425, 416 } },
    { 176808, 2, { 424, 417 } },
    { 176880, 2, { 440, 402 } },
    { 176890, 2, { 490, 361 } },
    { 176960, 2, { 448, 395 } },
    { 176985, 2, { 437, 405 } },
    { 176988, 2, { 516, 343 } },
    { 177000, 2, { 472, 375 } },
    { 177008, 2, { 481, 368 } },
    { 177012, 2, { 447, 396 } },
    { 177045, 2, { 435, 407 } },
    { 177072, 2, { 434, 408 } },
    { 177096, 2, { 471, 376 } },
    { 177120, 2, { 432, 410 } },
    { 177156, 2, { 444, 399 } },
    { 177216, 2, { 426, 416 } },
    { 177255, 2, { 505, 351 } },
    { 177320, 2, { 440, 403 } },
    { 177331, 2, { 517, 343 } },
    { 177375, 2, { 473, 375 } },
    { 177408, 2, { 448, 396 } },
    { 177444, 2, { 477, 372 } },
    { 177450, 2, { 455, 390 } },
    { 177480, 2, { 435, 408 } },
    { 177510, 2, { 485, 366 } },
    { 177552, 2, { 432, 411 } },
    { 177576, 2, { 453, 392 } },
    { 177590, 2, { 430, 413 } },
    { 177600, 2, { 444, 400 } },
    { 177632, 2, { 427, 416 } },
    { 177636, 2, { 452, 393 } },
    { 177650, 2, { 425, 418 } },
    { 177660, 2, { 423, 420 } },
    { 177723, 2, { 441, 403 } },
    { 177744, 2, { 483, 368 } },
    { 177750, 2, { 450, 395 } },
    { 177840, 2, { 456, 390 } },
    { 177885, 2, { 531, 335 } },
    { 177905, 2, { 455, 391 } },
    { 177996, 2, { 489, 364 } },
    { 178000, 2, { 445, 400 } },
    { 178002, 2, { 522, 341 } },
    { 178020, 2, { 430, 414 } },
    { 178092, 2, { 459, 388 } },
    { 178120, 2, { 488, 365 } },
    { 178155, 2, { 535, 333 } },
    { 178164, 2, { 441, 404 } },
    { 178200, 2, { 440, 405 } },
    { 178220, 2, { 469, 380 } },
    { 178224, 2, { 474, 376 } },
    { 178296, 2, { 437, 408 } },
    { 178308, 2, { 468, 381 } },
    { 178356, 2, { 501, 356 } },
    { 178360, 2, { 455, 392 } },
    { 178365, 2, { 517, 345 } },
    { 178416, 2, { 432, 413 } },
    { 178425, 2, { 549, 325 } },
    { 178464, 2, { 429, 416 } },
    { 178476, 2, { 428, 417 } },
    { 178500, 2, { 425, 420 } },
    { 178524, 2, { 513, 348 } },
    { 178560, 2, { 465, 384 } },
    { 178596, 2, { 451, 396 } },
    { 178605, 2, { 441, 405 } },
    { 178640, 2, { 440, 406 } },
    { 178695, 2, { 495, 361 } },
    { 178704, 2, { 438, 408 } },
    { 178752, 2, { 448, 399 } },
    { 178770, 2, { 505, 354 } },
    { 178800, 2, { 447, 400 } },
    { 178802, 2, { 529, 338 } },
    { 178848, 2, { 432, 414 } },
    { 178880, 2, { 430, 416 } },
    { 178890, 2, { 445, 402 } },
    { 178959, 2, { 493, 363 } },
    { 178965, 2, { 485, 369 } },
    { 178980, 2, { 471, 380 } },
    { 179010, 2, { 442, 405 } },
    { 179075, 2, { 475, 377 } },
    { 179080, 2, { 440, 407 } },
    { 179180, 2, { 527, 340 } },
    { 179196, 2, { 436, 411 } },
    { 179208, 2, { 456, 393 } },
    { 179220, 2, { 435, 412 } },
    { 179280, 2, { 432, 415 } },
    { 179340, 2, { 427, 420 } },
    { 179352, 2, { 424, 423 } },
    { 179361, 2, { 511, 351 } },
    { 179375, 2, { 625, 287 } },
    { 179388, 2, { 453, 396 } },
    { 179469, 2, { 459, 391 } },
    { 179487, 2, { 441, 407 } },
    { 179550, 2, { 450, 399 } },
    { 179568, 2, { 464, 387 } },
    { 179655, 2, { 435, 413 } },
    { 179676, 2, { 434, 414 } },
    { 179775, 2, { 425, 423 } },
    { 179816, 2, { 494, 364 } },
    { 179820, 2, { 444, 405 } },
    { 179832, 2, { 472, 381 } },
    { 179850, 2, { 545, 330 } },
    { 179872, 2, { 511, 352 } },
    { 179916, 2, { 517, 348 } },
    { 179928, 2, { 441, 408 } },
    { 179949, 2, { 451, 399 } },
    { 179952, 2, { 489, 368 } },
    { 179998, 2, { 559, 322 } },
    { 180000, 2, { 450, 400 } },
    { 180072, 2, { 488, 369 } },
    { 180075, 2, { 525, 343 } },
    { 180090, 2, { 435, 414 } },
    { 180096, 2, { 448, 402 } },
    { 180120, 2, { 456, 395 } },
    { 180144, 2, { 432, 417 } },
    { 180180, 2, { 429, 420 } },
    { 180200, 2, { 425, 424 } },
    { 180225, 2, { 445, 405 } },
    { 180234, 2, { 527, 342 } },
    { 180348, 2, { 452, 399 } },
    { 180360, 2, { 501, 360 } },
    { 180375, 2, { 481, 375 } },
    { 180420, 2, { 465, 388 } },
    { 180480, 2, { 470, 384 } },
    { 180492, 2, { 507, 356 } },
    { 180544, 2, { 434, 416 } },
    { 180576, 2, { 432, 418 } },
    { 180588, 2, { 447, 404 } },
    { 180600, 2, { 430, 420 } },
    { 180612, 2, { 519, 348 } },
    { 180621, 2, { 427, 423 } },
    { 180624, 2, { 426, 424 } },
    { 180642, 2, { 462, 391 } },
    { 180675, 2, { 495, 365 } },
    { 180761, 2, { 527, 343 } },
    { 180765, 2, { 515, 351 } },
    { 180780, 2, { 460, 393 } },
    { 180840, 2, { 440, 411 } },
    { 180864, 2, { 471, 384 } },
    { 180873, 2, { 567, 319 } },
    { 180895, 2, { 605, 299 } },
    { 180960, 2, { 435, 416 } },
    { 181040, 2, { 496, 365 } },
    { 181044, 2, { 428, 423 } },
    { 181048, 2, { 427, 424 } },
    { 181050, 2, { 426, 425 } },
    { 181056, 2, { 492, 368 } },
    { 181104, 2, { 462, 392 } },
    { 181116, 2, { 468, 387 } },
    { 181125, 2, { 483, 375 } },
    { 181200, 2, { 453, 400 } },
    { 181203, 2, { 561, 323 } },
    { 181260, 2, { 477, 380 } },
    { 181305, 2, { 459, 395 } },
    { 181350, 2, { 450, 403 } },
    { 181356, 2, { 476, 381 } },
    { 181384, 2, { 553, 328 } },
    { 181440, 2, { 432, 420 } },
    { 181447, 2, { 529, 343 } },
    { 181475, 2, { 427, 425 } },
    { 181485, 2, { 545, 333 } },
    { 181500, 2, { 484, 375 } },
    { 181503, 2, { 469, 387 } },
    { 181560, 2, { 445, 408 } },
    { 181608, 2, { 483, 376 } },
    { 181632, 2, { 473, 384 } },
    { 181675, 2, { 559, 325 } },
    { 181692, 2, { 441, 412 } },
    { 181720, 2, { 440, 413 } },
    { 181760, 2, { 512, 355 } },
    { 181764, 2, { 459, 396 } },
    { 181770, 2, { 438, 415 } },
    { 181790, 2, { 490, 371 } },
    { 181792, 2, { 437, 416 } },
    { 181812, 2, { 436, 417 } },
    { 181818, 2, { 481, 378 } },
    { 181888, 2, { 448, 406 } },
    { 181896, 2, { 429, 424 } },
    { 181908, 2, { 489, 372 } },
    { 181944, 2, { 456, 399 } },
    { 182000, 2, { 455, 400 } },
    { 182016, 2, { 474, 384 } },
    { 182040, 2, { 444, 410 } },
    { 182091, 2, { 483, 377 } },
    { 182105, 2, { 473, 385 } },
    { 182115, 2, { 513, 355 } },
    { 182133, 2, { 441, 413 } },
    { 182160, 2, { 440, 414 } },
    { 182182, 2, { 539, 338 } },
    { 182208, 2, { 438, 416 } },
    { 182280, 2, { 434, 420 } },
    { 182310, 2, { 515, 354 } },
    { 182336, 2, { 448, 407 } },
    { 182352, 2, { 464, 393 } },
    { 182364, 2, { 501, 364 } },
    { 182376, 2, { 447, 408 } },
    { 182468, 2, { 484, 377 } },
    { 182484, 2, { 444, 411 } },
    { 182490, 2, { 462, 395 } },
    { 182532, 2, { 492, 371 } },
    { 182595, 2, { 555, 329 } },
    { 182600, 2, { 440, 415 } },
    { 182628, 2, { 513, 356 } },
    { 182655, 2, { 451, 405 } },
    { 182664, 2, { 472, 387 } },
    { 182666, 2, { 437, 418 } },
    { 182688, 2, { 519, 352 } },
    { 182700, 2, { 435, 420 } },
    { 182736, 2, { 432, 423 } },
    { 182748, 2, { 471, 388 } },
    { 182780, 2, { 481, 380 } },
    { 182784, 2, { 448, 408 } },
    { 182819, 2, { 533, 343 } },
    { 182880, 2, { 480, 381 } },
    { 182896, 2, { 497, 368 } },
    { 182910, 2, { 455, 402 } },
    { 182970, 2, { 535, 342 } },
    { 183000, 2, { 488, 375 } },
    { 183012, 2, { 453, 404 } },
    { 183015, 2, { 441, 415 } },
    { 183027, 2, { 507, 361 } },
    { 183060, 2, { 452, 405 } },
    { 183106, 2, { 451, 406 } },
    { 183141, 2, { 459, 399 } },
    { 183150, 2, { 450, 407 } },
    { 183222, 2, { 486, 377 } },
    { 183264, 2, { 498, 368 } },
    { 183280, 2, { 464, 395 } },
    { 183312, 2, { 456, 402 } },
    { 183330, 2, { 485, 378 } },
    { 183365, 2, { 455, 403 } },
    { 183372, 2, { 444, 413 } },
    { 183393, 2, { 497, 369 } },
    { 183425, 2, { 575, 319 } },
    { 183456, 2, { 441, 416 } },
    { 183480, 2, { 440, 417 } },
    { 183520, 2, { 496, 370 } },
    { 183540, 2, { 437, 420 } },
    { 183600, 2, { 432, 425 } },
    { 183610, 2, { 430, 427 } },
    { 183612, 2, { 429, 428 } },
    { 183645, 2, { 477, 385 } },
    { 183680, 2, { 448, 410 } },
    { 183744, 2, { 464, 396 } },
    { 183750, 2, { 490, 375 } },
    { 183768, 2, { 456, 403 } },
    { 183799, 2, { 539, 341 } },
    { 183825, 2, { 475, 387 } },
    { 183848, 2, { 469, 392 } },
    { 183864, 2, { 489, 376 } },
    { 183872, 2, { 442, 416 } },
    { 183885, 2, { 533, 345 } },
    { 183890, 2, { 497, 370 } },
    { 183915, 2, { 549, 335 } },
    { 183920, 2, { 440, 418 } },
    { 183924, 2, { 468, 393 } },
    { 184008, 2, { 451, 408 } },
    { 184032, 2, { 432, 426 } },
    { 184080, 2, { 472, 390 } },
    { 184093, 2, { 637, 289 } },
    { 184110, 2, { 510, 361 } },
    { 184128, 2, { 448, 411 } },
    { 184140, 2, { 465, 396 } },
    { 184149, 2, { 553, 333 } },
    { 184164, 2, { 447, 412 } },
    { 184184, 2, { 506, 364 } },
    { 184212, 2, { 476, 387 } },
    { 184230, 2, { 445, 414 } },
    { 184260, 2, { 444, 415 } },
    { 184275, 2, { 455, 405 } },
    { 184320, 2, { 480, 384 } },
    { 184338, 2, { 441, 418 } },
    { 184368, 2, { 501, 368 } },
    { 184382, 2, { 493, 374 } },
    { 184404, 2, { 484, 381 } },
    { 184428, 2, { 436, 423 } },
    { 184440, 2, { 435, 424 } },
    { 184450, 2, { 434, 425 } },
    { 184464, 2, { 432, 427 } },
    { 184500, 2, { 450, 410 } },
    { 184548, 2, { 507, 364 } },
    { 184569, 2, { 517, 357 } },
    { 184600, 2, { 520, 355 } },
    { 184632, 2, { 471, 392 } },
    { 184680, 2, { 456, 405 } },
    { 184704, 2, { 444, 416 } },
    { 184764, 2, { 519, 356 } },
    { 184824, 2, { 453, 408 } },
    { 184830, 2, { 505, 366 } },
    { 184832, 2, { 512, 361 } },
    { 184860, 2, { 468, 395 } },
    { 184977, 2, { 459, 403 } },
    { 185024, 2, { 448, 413 } },
    { 185031, 2, { 623, 297 } },
    { 185076, 2, { 477, 388 } },
    { 185115, 2, { 615, 301 } },
    { 185120, 2, { 445, 416 } },
    { 185130, 2, { 495, 374 } },
    { 185136, 2, { 456, 406 } },
    { 185148, 2, { 444, 417 } },
    { 185150, 2, { 529, 350 } },
    { 185185, 2, { 455, 407 } },
    { 185220, 2, { 441, 420 } },
    { 185250, 2, { 475, 390 } },
    { 185328, 2, { 432, 429 } },
    { 185380, 2, { 460, 403 } },
    { 185416, 2, { 473, 392 } },
    { 185436, 2, { 459, 404 } },
    { 185472, 2, { 448, 414 } },
    { 185496, 2, { 472, 393 } },
    { 185500, 2, { 500, 371 } },
    { 185640, 2, { 442, 420 } },
    { 185679, 2, { 529, 351 } },
    { 185712, 2, { 438, 424 } },
    { 185725, 2, { 437, 425 } },
    { 185745, 2, { 435, 427 } },
    { 185760, 2, { 432, 430 } },
    { 185772, 2, { 452, 411 } },
    { 185808, 2, { 474, 392 } },
    { 185820, 2, { 489, 380 } },
    { 185850, 2, { 450, 413 } },
    { 185856, 2, { 484, 384 } },
    { 185900, 2, { 550, 338 } },
    { 185920, 2, { 448, 415 } },
    { 185928, 2, { 488, 381 } },
    { 185952, 2, { 447, 416 } },
    { 186000, 2, { 465, 400 } },
    { 186116, 2, { 476, 391 } },
    { 186120, 2, { 440, 423 } },
    { 186150, 2, { 438, 425 } },
    { 186180, 2, { 435, 428 } },
    { 186200, 2, { 475, 392 } },
    { 186345, 2, { 505, 369 } },
    { 186354, 2, { 459, 406 } },
    { 186372, 2, { 501, 372 } },
    { 186375, 2, { 497, 375 } },
    { 186390, 2, { 545, 342 } },
    { 186440, 2, { 472, 395 } },
    { 186516, 2, { 471, 396 } },
    { 186528, 2, { 464, 402 } },
    { 186576, 2, { 507, 368 } },
    { 186636, 2, { 453, 412 } },
    { 186714, 2, { 451, 414 } },
    { 186732, 2, { 468, 399 } },
    { 186750, 2, { 450, 415 } },
    { 186760, 2, { 460, 406 } },
    { 186813, 2, { 459, 407 } },
    { 186816, 2, { 448, 417 } },
    { 186840, 2, { 519, 360 } },
    { 186872, 2, { 497, 376 } },
    { 186880, 2, { 512, 365 } },
    { 186900, 2, { 445, 420 } },
    { 186960, 2, { 456, 410 } },
    { 186984, 2, { 441, 424 } },
    { 186992, 2, { 464, 403 } },
    { 187000, 2, { 440, 425 } },
    { 187044, 2, { 436, 429 } },
    { 187068, 2, { 476, 393 } },
    { 187110, 2, { 462, 405 } },
    { 187187, 2, { 847, 221 } },
    { 187200, 2, { 450, 416 } },
    { 187220, 2, { 460, 407 } },
    { 187245, 2, { 513, 365 } },
    { 187248, 2, { 498, 376 } },
    { 187264, 2, { 448, 418 } },
    { 187272, 2, { 459, 408 } },
    { 187308, 2, { 473, 396 } },
    { 187340, 2, { 493, 380 } },
    { 187404, 2, { 483, 388 } },
    { 187416, 2, { 456, 411 } },
    { 187425, 2, { 441, 425 } },
    { 187440, 2, { 440, 426 } },
    { 187452, 2, { 492, 381 } },
    { 187473, 2, { 437, 429 } },
    { 187488, 2, { 434, 432 } },
    { 187550, 2, { 550, 341 } },
    { 187590, 2, { 481, 390 } },
    { 187600, 2, { 469, 400 } },
    { 187616, 2, { 451, 416 } },
    { 187680, 2, { 460, 408 } },
    { 187695, 2, { 485, 387 } },
    { 187740, 2, { 447, 420 } },
    { 187775, 2, { 725, 259 } },
    { 187776, 2, { 489, 384 } },
    { 187785, 2, { 535, 351 } },
    { 187812, 2, { 444, 423 } },
    { 187860, 2, { 465, 404 } },
    { 187880, 2, { 440, 427 } },
    { 187920, 2, { 435, 432 } },
    { 188000, 2, { 470, 400 } },
    { 188034, 2, { 462, 407 } },
    { 188048, 2, { 511, 368 } },
    { 188100, 2, { 450, 418 } },
    { 188125, 2, { 625, 301 } },
    { 188139, 2, { 527, 357 } },
    { 188160, 2, { 448, 420 } },
    { 188188, 2, { 517, 364 } },
    { 188190, 2, { 459, 410 } },
    { 188235, 2, { 445, 423 } },
    { 188307, 2, { 441, 427 } },
    { 188325, 2, { 465, 405 } },
    { 188328, 2, { 456, 413 } },
    { 188370, 2, { 455, 414 } },
    { 188376, 2, { 501, 376 } },
    { 188400, 2, { 471, 400 } },
    { 188415, 2, { 477, 395 } },
    { 188448, 2, { 453, 416 } },
    { 188484, 2, { 452, 417 } },
    { 188490, 2, { 515, 366 } },
    { 188496, 2, { 462, 408 } },
    { 188500, 2, { 500, 377 } },
    { 188505, 2, { 531, 355 } },
    { 188552, 2, { 481, 392 } },
    { 188559, 2, { 511, 369 } },
    { 188604, 2, { 468, 403 } },
    { 188640, 2, { 480, 393 } },
    { 188680, 2, { 445, 424 } },
    { 188700, 2, { 444, 425 } },
    { 188727, 2, { 473, 399 } },
    { 188748, 2, { 441, 428 } },
    { 188760, 2, { 440, 429 } },
    { 188784, 2, { 437, 432 } },
    { 188790, 2, { 435, 434 } },
    { 188848, 2, { 464, 407 } },
    { 188856, 2, { 488, 387 } },
    { 188860, 2, { 497, 380 } },
    { 188892, 2, { 477, 396 } },
    { 188916, 2, { 519, 364 } },
    { 188928, 2, { 492, 384 } },
    { 188955, 2, { 585, 323 } },
    { 188976, 2, { 496, 381 } },
    { 188993, 2, { 551, 343 } },
    { 189036, 2, { 531, 356 } },
    { 189060, 2, { 460, 411 } },
    { 189070, 2, { 511, 370 } },
    { 189108, 2, { 459, 412 } },
    { 189150, 2, { 485, 390 } },
    { 189175, 2, { 575, 329 } },
    { 189189, 2, { 441, 429 } },
    { 189210, 2, { 510, 371 } },
    { 189216, 2, { 438, 432 } },
    { 189240, 2, { 456, 415 } },
    { 189244, 2, { 484, 391 } },
    { 189255, 2, { 465, 407 } },
    { 189280, 2, { 455, 416 } },
    { 189336, 2, { 483, 392 } },
    { 189390, 2, { 535, 354 } },
    { 189420, 2, { 451, 420 } },
    { 189440, 2, { 512, 370 } },
    { 189475, 2, { 583, 325 } },
    { 189504, 2, { 448, 423 } },
    { 189528, 2, { 447, 424 } },
    { 189540, 2, { 468, 405 } },
    { 189567, 2, { 459, 413 } },
    { 189570, 2, { 445, 426 } },
    { 189588, 2, { 444, 427 } },
    { 189600, 2, { 474, 400 } },
    { 189618, 2, { 442, 429 } },
    { 189660, 2, { 436, 435 } },
    { 189696, 2, { 456, 416 } },
    { 189720, 2, { 465, 408 } },
    { 189728, 2, { 484, 392 } },
    { 189732, 2, { 489, 388 } },
    { 189744, 2, { 472, 402 } },
    { 189750, 2, { 506, 375 } },
    { 189800, 2, { 520, 365 } },
    { 189805, 2, { 493, 385 } },
    { 189810, 2, { 513, 370 } },
    { 189888, 2, { 516, 368 } },
    { 189924, 2, { 476, 399 } },
    { 189945, 2, { 469, 405 } },
    { 189980, 2, { 460, 413 } },
    { 190000, 2, { 475, 400 } },
    { 190008, 2, { 468, 406 } },
    { 190035, 2, { 515, 369 } },
    { 190080, 2, { 440, 432 } },
    { 190120, 2, { 485, 392 } },
    { 190125, 2, { 507, 375 } },
    { 190152, 2, { 456, 417 } },
    { 190190, 2, { 455, 418 } },
    { 190212, 2, { 484, 393 } },
    { 190232, 2, { 553, 344 } },
    { 190240, 2, { 464, 410 } },
    { 190260, 2, { 453, 420 } },
    { 190280, 2, { 536, 355 } },
    { 190281, 2, { 533, 357 } },
    { 190284, 2, { 471, 404 } },
    { 190320, 2, { 488, 390 } },
    { 190365, 2, { 555, 343 } },
    { 190380, 2, { 501, 380 } },
    { 190400, 2, { 448, 425 } },
    { 190404, 2, { 492, 387 } },
    { 190463, 2, { 637, 299 } },
    { 190476, 2, { 444, 429 } },
    { 190485, 2, { 459, 415 } },
    { 190500, 2, { 500, 381 } },
    { 190512, 2, { 441, 432 } },
    { 190575, 2, { 495, 385 } },
    { 190624, 2, { 518, 368 } },
    { 190632, 2, { 507, 376 } },
    { 190704, 2, { 464, 411 } },
    { 190762, 2, { 506, 377 } },
    { 190800, 2, { 450, 424 } },
    { 190836, 2, { 513, 372 } },
    { 190848, 2, { 448, 426 } },
    { 190890, 2, { 505, 378 } },
    { 190920, 2, { 444, 430 } },
    { 190944, 2, { 442, 432 } },
    { 190950, 2, { 475, 402 } },
    { 190960, 2, { 440, 434 } },
    { 190992, 2, { 519, 368 } },
    { 191100, 2, { 455, 420 } },
    { 191160, 2, { 472, 405 } },
    { 191196, 2, { 452, 423 } },
    { 191232, 2, { 498, 384 } },
    { 191250, 2, { 450, 425 } },
    { 191295, 2, { 545, 351 } },
    { 191296, 2, { 448, 427 } },
    { 191301, 2, { 527, 363 } },
    { 191316, 2, { 447, 428 } },
    { 191352, 2, { 469, 408 } },
    { 191360, 2, { 460, 416 } },
    { 191400, 2, { 440, 435 } },
    { 191425, 2, { 475, 403 } },
    { 191436, 2, { 516, 371 } },
    { 191488, 2, { 512, 374 } },
    { 191565, 2, { 473, 405 } },
    { 191580, 2, { 465, 412 } },
    { 191590, 2, { 490, 391 } },
    { 191625, 2, { 511, 375 } },
    { 191632, 2, { 464, 413 } },
    { 191646, 2, { 507, 378 } },
    { 191675, 2, { 451, 425 } },
    { 191688, 2, { 489, 392 } },
    { 191730, 2, { 462, 415 } },
    { 191737, 2, { 559, 343 } },
    { 191760, 2, { 470, 408 } },
    { 191784, 2, { 488, 393 } },
    { 191808, 2, { 444, 432 } },
    { 191820, 2, { 460, 417 } },
    { 191862, 2, { 459, 418 } },
    { 191880, 2, { 468, 410 } },
    { 191919, 2, { 481, 399 } },
    { 191952, 2, { 496, 387 } },
    { 192024, 2, { 504, 381 } },
    { 192027, 2, { 529, 363 } },
    { 192038, 2, { 473, 406 } },
    { 192045, 2, { 465, 413 } },
    { 192060, 2, { 485, 396 } },
    { 192072, 2, { 453, 424 } },
    { 192096, 2, { 464, 414 } },
    { 192136, 2, { 511, 376 } },
    { 192150, 2, { 450, 427 } },
    { 192168, 2, { 471, 408 } },
    { 192185, 2, { 595, 323 } },
    { 192192, 2, { 448, 429 } },
    { 192240, 2, { 445, 432 } },
    { 192276, 2, { 441, 436 } },
    { 192280, 2, { 440, 437 } },
    { 192290, 2, { 469, 410 } },
    { 192324, 2, { 517, 372 } },
    { 192339, 2, { 497, 387 } },
    { 192348, 2, { 468, 411 } },
    { 192375, 2, { 475, 405 } },
    { 192384, 2, { 501, 384 } },
    { 192400, 2, { 481, 400 } },
    { 192465, 2, { 455, 423 } },
    { 192500, 2, { 500, 385 } },
    { 192510, 2, { 465, 414 } },
    { 192556, 2, { 529, 364 } },
    { 192560, 2, { 464, 415 } },
    { 192640, 2, { 448, 430 } },
    { 192660, 2, { 494, 390 } },
    { 192708, 2, { 477, 404 } },
    { 192717, 2, { 441, 437 } },
    { 192720, 2, { 440, 438 } },
    { 192760, 2, { 488, 395 } },
    { 192780, 2, { 459, 420 } },
    { 192850, 2, { 475, 406 } },
    { 192855, 2, { 559, 345 } },
    { 192888, 2, { 456, 423 } },
    { 192920, 2, { 455, 424 } },
    { 192930, 2, { 545, 354 } },
    { 192960, 2, { 480, 402 } },
    { 192984, 2, { 473, 408 } },
    { 193050, 2, { 450, 429 } },
    { 193068, 2, { 519, 372 } },
    { 193104, 2, { 447, 432 } },
    { 193116, 2, { 462, 418 } },
    { 193120, 2, { 544, 355 } },
    { 193140, 2, { 444, 435 } },
    { 193154, 2, { 442, 437 } },
    { 193230, 2, { 565, 342 } },
    { 193284, 2, { 468, 413 } },
    { 193320, 2, { 537, 360 } },
    { 193325, 2, { 475, 407 } },
    { 193347, 2, { 567, 341 } },
    { 193356, 2, { 492, 393 } },
    { 193392, 2, { 474, 408 } },
    { 193401, 2, { 513, 377 } },
    { 193440, 2, { 465, 416 } },
    { 193452, 2, { 564, 343 } },
    { 193473, 2, { 581, 333 } },
    { 193488, 2, { 464, 417 } },
    { 193500, 2, { 450, 430 } },
    { 193536, 2, { 448, 432 } },
    { 193545, 2, { 495, 391 } },
    { 193644, 2, { 489, 396 } },
    { 193648, 2, { 494, 392 } },
    { 193732, 2, { 476, 407 } },
    { 193800, 2, { 456, 425 } },
    { 193815, 2, { 531, 365 } },
    { 193830, 2, { 455, 426 } },
    { 193875, 2, { 517, 375 } },
    { 193884, 2, { 453, 428 } },
    { 193908, 2, { 452, 429 } },
    { 193914, 2, { 486, 399 } },
    { 193992, 2, { 472, 411 } },
    { 194000, 2, { 485, 400 } },
    { 194012, 2, { 533, 364 } },
    { 194040, 2, { 441, 440 } },
    { 194052, 2, { 471, 412 } },
    { 194103, 2, { 553, 351 } },
    { 194110, 2, { 470, 413 } },
    { 194166, 2, { 469, 414 } },
    { 194180, 2, { 511, 380 } },
    { 194220, 2, { 468, 415 } },
    { 194250, 2, { 518, 375 } },
    { 194256, 2, { 456, 426 } },
    { 194304, 2, { 506, 384 } },
    { 194388, 2, { 501, 388 } },
    { 194400, 2, { 450, 432 } },
    { 194432, 2, { 448, 434 } },
    { 194480, 2, { 442, 440 } },
    { 194560, 2, { 512, 380 } },
    { 194579, 2, { 539, 361 } },
    { 194580, 2, { 460, 423 } },
    { 194616, 2, { 459, 424 } },
    { 194649, 2, { 483, 403 } },
    { 194656, 2, { 553, 352 } },
    { 194670, 2, { 515, 378 } },
    { 194688, 2, { 468, 416 } },
    { 194712, 2, { 456, 427 } },
    { 194775, 2, { 525, 371 } },
    { 194805, 2, { 481, 405 } },
    { 194810, 2, { 506, 385 } },
    { 194824, 2, { 497, 392 } },
    { 194832, 2, { 451, 432 } },
    { 194880, 2, { 448, 435 } },
    { 194892, 2, { 447, 436 } },
    { 194895, 2, { 549, 355 } },
    { 194910, 2, { 445, 438 } },
    { 194922, 2, { 442, 441 } },
    { 194928, 2, { 496, 393 } },
    { 194940, 2, { 513, 380 } },
    { 194970, 2, { 485, 402 } },
    { 195048, 2, { 504, 387 } },
    { 195052, 2, { 484, 403 } },
    { 195075, 2, { 459, 425 } },
    { 195104, 2, { 469, 416 } },
    { 195132, 2, { 483, 404 } },
    { 195144, 2, { 519, 376 } },
    { 195156, 2, { 468, 417 } },
    { 195216, 2, { 498, 392 } },
    { 195228, 2, { 493, 396 } },
    { 195286, 2, { 481, 406 } },
    { 195300, 2, { 450, 434 } },
    { 195408, 2, { 472, 414 } },
    { 195415, 2, { 605, 323 } },
    { 195435, 2, { 505, 387 } },
    { 195468, 2, { 537, 364 } },
    { 195520, 2, { 470, 416 } },
    { 195525, 2, { 495, 395 } },
    { 195600, 2, { 489, 400 } },
    { 195615, 2, { 483, 405 } },
    { 195624, 2, { 456, 429 } },
    { 195636, 2, { 476, 411 } },
    { 195640, 2, { 536, 365 } },
    { 195696, 2, { 453, 432 } },
    { 195734, 2, { 451, 434 } },
    { 195750, 2, { 450, 435 } },
    { 195776, 2, { 448, 437 } },
    { 195800, 2, { 445, 440 } },
    { 195804, 2, { 444, 441 } },
    { 195810, 2, { 535, 366 } },
    { 195822, 2, { 473, 414 } },
    { 195840, 2, { 480, 408 } },
    { 195858, 2, { 486, 403 } },
    { 195880, 2, { 472, 415 } },
    { 195888, 2, { 462, 424 } },
    { 195920, 2, { 496, 395 } },
    { 195936, 2, { 471, 416 } },
    { 195975, 2, { 585, 335 } },
    { 195993, 2, { 459, 427 } },
    { 196000, 2, { 490, 400 } },
    { 196020, 2, { 484, 405 } },
    { 196040, 2, { 520, 377 } },
    { 196075, 2, { 575, 341 } },
    { 196080, 2, { 456, 430 } },
    { 196144, 2, { 533, 368 } },
    { 196175, 2, { 475, 413 } },
    { 196176, 2, { 488, 402 } },
    { 196185, 2, { 451, 435 } },
    { 196224, 2, { 448, 438 } },
    { 196245, 2, { 445, 441 } },
    { 196272, 2, { 464, 423 } },
    { 196308, 2, { 492, 399 } },
    { 196350, 2, { 462, 425 } },
    { 196365, 2, { 689, 285 } },
    { 196384, 2, { 544, 361 } },
    { 196392, 2, { 501, 392 } },
    { 196416, 2, { 496, 396 } },
    { 196420, 2, { 460, 427 } },
    { 196425, 2, { 485, 405 } },
    { 196452, 2, { 459, 428 } },
    { 196500, 2, { 500, 393 } },
    { 196512, 2, { 534, 368 } },
    { 196524, 2, { 477, 412 } },
    { 196560, 2, { 455, 432 } },
    { 196581, 2, { 483, 407 } },
    { 196596, 2, { 508, 387 } },
    { 196620, 2, { 452, 435 } },
    { 196650, 2, { 450, 437 } },
    { 196680, 2, { 447, 440 } },
    { 196707, 2, { 493, 399 } },
    { 196710, 2, { 474, 415 } },
    { 196716, 2, { 507, 388 } },
    { 196768, 2, { 473, 416 } },
    { 196800, 2, { 480, 410 } },
    { 196824, 2, { 472, 417 } },
    { 196840, 2, { 518, 380 } },
    { 196950, 2, { 505, 390 } },
    { 196980, 2, { 469, 420 } },
    { 197001, 2, { 477, 413 } },
    { 197098, 2, { 527, 374 } },
    { 197120, 2, { 448, 440 } },
    { 197160, 2, { 465, 424 } },
    { 197184, 2, { 474, 416 } },
    { 197200, 2, { 464, 425 } },
    { 197220, 2, { 519, 380 } },
    { 197225, 2, { 575, 343 } },
    { 197280, 2, { 480, 411 } },
    { 197316, 2, { 486, 406 } },
    { 197340, 2, { 460, 429 } },
    { 197370, 2, { 459, 430 } },
    { 197400, 2, { 470, 420 } },
    { 197415, 2, { 535, 369 } },
    { 197505, 2, { 495, 399 } },
    { 197508, 2, { 453, 436 } },
    { 197532, 2, { 531, 372 } },
    { 197556, 2, { 489, 404 } },
    { 197568, 2, { 448, 441 } },
    { 197580, 2, { 445, 444 } },
    { 197600, 2, { 475, 416 } },
    { 197616, 2, { 537, 368 } },
    { 197640, 2, { 488, 405 } },
    { 197652, 2, { 543, 364 } },
    { 197664, 2, { 464, 426 } },
    { 197757, 2, { 511, 387 } },
    { 197780, 2, { 580, 341 } },
    { 197802, 2, { 486, 407 } },
    { 197820, 2, { 471, 420 } },
    { 197880, 2, { 485, 408 } },
    { 197904, 2, { 456, 434 } },
    { 197955, 2, { 477, 415 } },
    { 197964, 2, { 468, 423 } },
    { 198000, 2, { 450, 440 } },
    { 198016, 2, { 448, 442 } },
    { 198072, 2, { 504, 393 } },
    { 198099, 2, { 621, 319 } },
    { 198128, 2, { 464, 427 } },
    { 198144, 2, { 512, 387 } },
    { 198198, 2, { 462, 429 } },
    { 198237, 2, { 507, 391 } },
    { 198254, 2, { 578, 343 } },
    { 198288, 2, { 459, 432 } },
    { 198315, 2, { 565, 351 } },
    { 198352, 2, { 506, 392 } },
    { 198360, 2, { 456, 435 } },
    { 198375, 2, { 529, 375 } },
    { 198387, 2, { 469, 423 } },
    { 198396, 2, { 501, 396 } },
    { 198440, 2, { 451, 440 } },
    { 198450, 2, { 450, 441 } },
    { 198468, 2, { 447, 444 } },
    { 198492, 2, { 476, 417 } },
    { 198528, 2, { 517, 384 } },
    { 198555, 2, { 465, 427 } },
    { 198560, 2, { 544, 365 } },
    { 198575, 2, { 611, 325 } },
    { 198720, 2, { 460, 432 } },
    { 198744, 2, { 507, 392 } },
    { 198800, 2, { 497, 400 } },
    { 198835, 2, { 455, 437 } },
    { 198856, 2, { 469, 424 } },
    { 198891, 2, { 451, 441 } },
    { 198900, 2, { 450, 442 } },
    { 198912, 2, { 448, 444 } },
    { 198924, 2, { 484, 411 } },
    { 198968, 2, { 476, 418 } },
    { 198996, 2, { 483, 412 } },
    { 199020, 2, { 465, 428 } },
    { 199044, 2, { 513, 388 } },
    { 199045, 2, { 517, 385 } },
    { 199056, 2, { 464, 429 } },
    { 199134, 2, { 481, 414 } },
    { 199200, 2, { 480, 415 } },
    { 199206, 2, { 459, 434 } },
    { 199260, 2, { 486, 410 } },
    { 199272, 2, { 456, 437 } },
    { 199290, 2, { 455, 438 } },
    { 199296, 2, { 519, 384 } },
    { 199305, 2, { 515, 387 } },
    { 199320, 2, { 453, 440 } },
    { 199325, 2, { 469, 425 } },
    { 199332, 2, { 452, 441 } },
    { 199360, 2, { 448, 445 } },
    { 199375, 2, { 625, 319 } },
    { 199392, 2, { 496, 402 } },
    { 199410, 2, { 510, 391 } },
    { 199430, 2, { 490, 407 } },
    { 199470, 2, { 545, 366 } },
    { 199500, 2, { 475, 420 } },
    { 199512, 2, { 489, 408 } },
    { 199520, 2, { 464, 430 } },
    { 199563, 2, { 559, 357 } },
    { 199584, 2, { 462, 432 } },
    { 199640, 2, { 460, 434 } },
    { 199644, 2, { 508, 393 } },
    { 199656, 2, { 472, 423 } },
    { 199665, 2, { 459, 435 } },
    { 199704, 2, { 471, 424 } },
    { 199728, 2, { 456, 438 } },
    { 199764, 2, { 537, 372 } },
    { 199824, 2, { 543, 368 } },
    { 199836, 2, { 468, 427 } },
    { 199864, 2, { 581, 344 } },
    { 199875, 2, { 533, 375 } },
    { 199920, 2, { 476, 420 } },
    { 199980, 2, { 495, 404 } },
    { 200010, 2, { 565, 354 } },
    { 200013, 2, { 551, 363 } },
    { 200070, 2, { 494, 405 } },
    { 200096, 2, { 481, 416 } },
    { 200100, 2, { 460, 435 } },
    { 200124, 2, { 459, 436 } },
    { 200160, 2, { 480, 417 } },
    { 200192, 2, { 512, 391 } },
    { 200200, 2, { 455, 440 } },
    { 200244, 2, { 451, 444 } },
    { 200250, 2, { 450, 445 } },
    { 200256, 2, { 448, 447 } },
    { 200260, 2, { 527, 380 } },
    { 200312, 2, { 511, 392 } },
    { 200340, 2, { 477, 420 } },
    { 200385, 2, { 549, 365 } },
    { 200400, 2, { 501, 400 } },
    { 200475, 2, { 495, 405 } },
    { 200568, 2, { 488, 411 } },
    { 200583, 2, { 459, 437 } },
    { 200600, 2, { 472, 425 } },
    { 200655, 2, { 455, 441 } },
    { 200690, 2, { 470, 427 } },
    { 200718, 2, { 486, 413 } },
    { 200725, 2, { 775, 259 } },
    { 200772, 2, { 468, 429 } },
    { 200784, 2, { 534, 376 } },
    { 200790, 2, { 485, 414 } },
    { 200850, 2, { 515, 390 } },
    { 200880, 2, { 465, 432 } },
    { 200925, 2, { 475, 423 } },
    { 200928, 2, { 483, 416 } },
    { 200976, 2, { 474, 424 } },
    { 201025, 2, { 473, 425 } },
    { 201058, 2, { 481, 418 } },
    { 201072, 2, { 472, 426 } },
    { 201096, 2, { 456, 441 } },
    { 201105, 2, { 545, 369 } },
    { 201110, 2, { 455, 442 } },
    { 201132, 2, { 453, 444 } },
    { 201135, 2, { 583, 345 } },
    { 201144, 2, { 493, 408 } },
    { 201216, 2, { 512, 393 } },
    { 201240, 2, { 468, 430 } },
    { 201280, 2, { 544, 370 } },
    { 201285, 2, { 497, 405 } },
    { 201348, 2, { 476, 423 } },
    { 201372, 2, { 519, 388 } },
    { 201376, 2, { 464, 434 } },
    { 201400, 2, { 475, 424 } },
    { 201450, 2, { 474, 425 } },
    { 201465, 2, { 495, 407 } },
    { 201468, 2, { 489, 412 } },
    { 201474, 2, { 533, 378 } },
    { 201500, 2, { 500, 403 } },
    { 201544, 2, { 472, 427 } },
    { 201586, 2, { 539, 374 } },
    { 201588, 2, { 471, 428 } },
    { 201600, 2, { 450, 448 } },
    { 201663, 2, { 679, 297 } },
    { 201670, 2, { 469, 430 } },
    { 201690, 2, { 486, 415 } },
    { 201760, 2, { 485, 416 } },
    { 201780, 2, { 531, 380 } },
    { 201825, 2, { 575, 351 } },
    { 201828, 2, { 484, 417 } },
    { 201840, 2, { 464, 435 } },
    { 201872, 2, { 496, 407 } },
    { 201894, 2, { 462, 437 } },
    { 201912, 2, { 537, 376 } },
    { 201960, 2, { 459, 440 } },
    { 201996, 2, { 543, 372 } },
    { 202020, 2, { 455, 444 } },
    { 202027, 2, { 589, 343 } },
    { 202032, 2, { 488, 414 } },
    { 202044, 2, { 452, 447 } },
    { 202048, 2, { 451, 448 } },
    { 202125, 2, { 525, 385 } },
    { 202176, 2, { 468, 432 } },
    { 202212, 2, { 492, 411 } },
    { 202230, 2, { 535, 378 } },
    { 202240, 2, { 512, 395 } },
    { 202248, 2, { 477, 424 } },
    { 202335, 2, { 615, 329 } },
    { 202350, 2, { 475, 426 } },
    { 202370, 2, { 490, 413 } },
    { 202404, 2, { 501, 404 } },
    { 202488, 2, { 472, 429 } },
    { 202520, 2, { 488, 415 } },
    { 202521, 2, { 561, 361 } },
    { 202608, 2, { 469, 432 } },
    { 202635, 2, { 513, 395 } },
    { 202664, 2, { 517, 392 } },
    { 202692, 2, { 508, 399 } },
    { 202725, 2, { 477, 425 } },
    { 202740, 2, { 465, 436 } },
    { 202752, 2, { 512, 396 } },
    { 202788, 2, { 516, 393 } },
    { 202800, 2, { 507, 400 } },
    { 202825, 2, { 475, 427 } },
    { 202860, 2, { 460, 441 } },
    { 202884, 2, { 583, 348 } },
    { 202895, 2, { 527, 385 } },
    { 202920, 2, { 456, 445 } },
    { 202944, 2, { 453, 448 } },
    { 202950, 2, { 451, 450 } },
    { 203000, 2, { 500, 406 } },
    { 203010, 2, { 505, 402 } },
    { 203040, 2, { 470, 432 } },
    { 203112, 2, { 468, 434 } },
    { 203136, 2, { 529, 384 } },
    { 203148, 2, { 486, 418 } },
    { 203184, 2, { 498, 408 } },
    { 203196, 2, { 492, 413 } },
    { 203203, 2, { 539, 377 } },
    { 203232, 2, { 464, 438 } },
    { 203280, 2, { 462, 440 } },
    { 203360, 2, { 496, 410 } },
    { 203424, 2, { 489, 416 } },
    { 203448, 2, { 519, 392 } },
    { 203472, 2, { 471, 432 } },
    { 203476, 2, { 559, 364 } },
    { 203490, 2, { 510, 399 } },
    { 203496, 2, { 488, 417 } },
    { 203500, 2, { 500, 407 } },
    { 203504, 2, { 553, 368 } },
    { 203550, 2, { 575, 354 } },
    { 203580, 2, { 468, 435 } },
    { 203665, 2, { 529, 385 } },
    { 203679, 2, { 477, 427 } },
    { 203700, 2, { 485, 420 } },
    { 203770, 2, { 497, 410 } },
    { 203796, 2, { 459, 444 } },
    { 203832, 2, { 456, 447 } },
    { 203840, 2, { 455, 448 } },
    { 203856, 2, { 496, 411 } },
    { 203918, 2, { 506, 403 } },
    { 203931, 2, { 581, 351 } },
    { 203940, 2, { 495, 412 } },
    { 204000, 2, { 480, 425 } },
    { 204015, 2, { 469, 435 } },
    { 204057, 2, { 553, 369 } },
    { 204060, 2, { 537, 380 } },
    { 204102, 2, { 493, 414 } },
    { 204120, 2, { 486, 420 } },
    { 204156, 2, { 477, 428 } },
    { 204168, 2, { 543, 376 } },
    { 204180, 2, { 492, 415 } },
    { 204204, 2, { 462, 442 } },
    { 204228, 2, { 549, 372 } },
    { 204255, 2, { 459, 445 } },
    { 204288, 2, { 456, 448 } },
    { 204336, 2, { 473, 432 } },
    { 204360, 2, { 520, 393 } },
    { 204400, 2, { 511, 400 } },
    { 204408, 2, { 501, 408 } },
    { 204425, 2, { 481, 425 } },
    { 204435, 2, { 495, 413 } },
    { 204480, 2, { 480, 426 } },
    { 204490, 2, { 605, 338 } },
    { 204512, 2, { 581, 352 } },
    { 204516, 2, { 468, 437 } },
    { 204525, 2, { 505, 405 } },
    { 204600, 2, { 465, 440 } },
    { 204624, 2, { 464, 441 } },
    { 204672, 2, { 492, 416 } },
    { 204732, 2, { 484, 423 } },
    { 204750, 2, { 455, 450 } },
    { 204756, 2, { 453, 452 } },
    { 204768, 2, { 474, 432 } },
    { 204792, 2, { 483, 424 } },
    { 204800, 2, { 512, 400 } },
    { 204820, 2, { 490, 418 } },
    { 204828, 2, { 507, 404 } },
    { 204960, 2, { 480, 427 } },
    { 205056, 2, { 534, 384 } },
    { 205114, 2, { 598, 343 } },
    { 205155, 2, { 485, 423 } },
    { 205164, 2, { 492, 417 } },
    { 205200, 2, { 456, 450 } },
    { 205205, 2, { 455, 451 } },
    { 205275, 2, { 483, 425 } },
    { 205282, 2, { 473, 434 } },
    { 205296, 2, { 546, 376 } },
    { 205320, 2, { 472, 435 } },
    { 205335, 2, { 507, 405 } },
    { 205344, 2, { 496, 414 } },
    { 205356, 2, { 471, 436 } },
    { 205380, 2, { 489, 420 } },
    { 205400, 2, { 520, 395 } },
    { 205425, 2, { 495, 415 } },
    { 205500, 2, { 500, 411 } },
    { 205504, 2, { 494, 416 } },
    { 205524, 2, { 519, 396 } },
    { 205590, 2, { 462, 445 } },
    { 205620, 2, { 460, 447 } },
    { 205625, 2, { 625, 329 } },
    { 205632, 2, { 459, 448 } },
    { 205640, 2, { 485, 424 } },
    { 205656, 2, { 456, 451 } },
    { 205712, 2, { 559, 368 } },
    { 205740, 2, { 508, 405 } },
    { 205751, 2, { 637, 323 } },
    { 205755, 2, { 473, 435 } },
    { 205800, 2, { 490, 420 } },
    { 205821, 2, { 567, 363 } },
    { 205824, 2, { 512, 402 } },
    { 205840, 2, { 496, 415 } },
    { 205884, 2, { 516, 399 } },
    { 205905, 2, { 555, 371 } },
    { 206010, 2, { 545, 378 } },
    { 206016, 2, { 464, 444 } },
    { 206028, 2, { 531, 388 } },
    { 206040, 2, { 505, 408 } },
    { 206045, 2, { 841, 245 } },
    { 206064, 2, { 477, 432 } },
    { 206074, 2, { 493, 418 } },
    { 206080, 2, { 460, 448 } },
    { 206150, 2, { 475, 434 } },
    { 206208, 2, { 537, 384 } },
    { 206283, 2, { 517, 399 } },
    { 206310, 2, { 529, 390 } },
    { 206340, 2, { 543, 380 } },
    { 206349, 2, { 481, 429 } },
    { 206360, 2, { 469, 440 } },
    { 206388, 2, { 468, 441 } },
    { 206400, 2, { 480, 430 } },
    { 206412, 2, { 501, 412 } },
    { 206424, 2, { 488, 423 } },
    { 206448, 2, { 506, 408 } },
    { 206460, 2, { 465, 444 } },
    { 206480, 2, { 464, 445 } },
    { 206500, 2, { 500, 413 } },
    { 206568, 2, { 456, 453 } },
    { 206610, 2, { 485, 426 } },
    { 206635, 2, { 715, 289 } },
    { 206720, 2, { 544, 380 } },
    { 206724, 2, { 483, 428 } },
    { 206736, 2, { 472, 438 } },
    { 206739, 2, { 513, 403 } },
    { 206752, 2, { 497, 416 } },
    { 206790, 2, { 565, 366 } },
    { 206829, 2, { 469, 441 } },
    { 206832, 2, { 496, 417 } },
    { 206856, 2, { 468, 442 } },
    { 206910, 2, { 495, 418 } },
    { 206955, 2, { 511, 405 } },
    { 206976, 2, { 462, 448 } },
    { 207009, 2, { 459, 451 } },
    { 207030, 2, { 515, 402 } },
    { 207045, 2, { 535, 387 } },
    { 207060, 2, { 476, 435 } },
    { 207144, 2, { 504, 411 } },
    { 207168, 2, { 498, 416 } },
    { 207200, 2, { 518, 400 } },
    { 207240, 2, { 471, 440 } },
    { 207252, 2, { 513, 404 } },
    { 207320, 2, { 568, 365 } },
    { 207336, 2, { 489, 424 } },
    { 207350, 2, { 550, 377 } },
    { 207368, 2, { 529, 392 } },
    { 207400, 2, { 488, 425 } },
    { 207408, 2, { 464, 447 } },
    { 207459, 2, { 623, 333 } },
    { 207460, 2, { 460, 451 } },
    { 207468, 2, { 459, 452 } },
    { 207480, 2, { 456, 455 } },
    { 207522, 2, { 486, 427 } },
    { 207570, 2, { 510, 407 } },
    { 207575, 2, { 475, 437 } },
    { 207600, 2, { 519, 400 } },
    { 207636, 2, { 484, 429 } },
    { 207669, 2, { 609, 341 } },
    { 207675, 2, { 585, 355 } },
    { 207888, 2, { 488, 426 } },
    { 207900, 2, { 462, 450 } },
    { 207928, 2, { 553, 376 } },
    { 207972, 2, { 477, 436 } },
    { 208000, 2, { 500, 416 } },
    { 208012, 2, { 476, 437 } },
    { 208050, 2, { 475, 438 } },
    { 208075, 2, { 725, 287 } },
    { 208080, 2, { 510, 408 } },
    { 208104, 2, { 552, 377 } },
    { 208116, 2, { 492, 423 } },
    { 208120, 2, { 473, 440 } },
    { 208152, 2, { 472, 441 } },
    { 208236, 2, { 469, 444 } },
    { 208260, 2, { 468, 445 } },
    { 208278, 2, { 513, 406 } },
    { 208320, 2, { 465, 448 } },
    { 208356, 2, { 537, 388 } },
    { 208362, 2, { 462, 451 } },
    { 208380, 2, { 460, 453 } },
    { 208384, 2, { 512, 407 } },
    { 208416, 2, { 501, 416 } },
    { 208485, 2, { 565, 369 } },
    { 208494, 2, { 486, 429 } },
    { 208500, 2, { 500, 417 } },
    { 208512, 2, { 543, 384 } },
    { 208560, 2, { 474, 440 } },
    { 208575, 2, { 515, 405 } },
    { 208593, 2, { 473, 441 } },
    { 208620, 2, { 549, 380 } },
    { 208650, 2, { 535, 390 } },
    { 208656, 2, { 483, 432 } },
    { 208658, 2, { 578, 361 } },
    { 208680, 2, { 470, 444 } },
    { 208692, 2, { 527, 396 } },
    { 208754, 2, { 481, 434 } },
    { 208788, 2, { 508, 411 } },
    { 208791, 2, { 513, 407 } },
    { 208800, 2, { 464, 450 } },
    { 208845, 2, { 459, 455 } },
    { 208884, 2, { 507, 412 } },
    { 208896, 2, { 512, 408 } },
    { 208936, 2, { 533, 392 } },
    { 208980, 2, { 486, 430 } },
    { 209000, 2, { 475, 440 } },
    { 209040, 2, { 520, 402 } },
    { 209070, 2, { 505, 414 } },
    { 209076, 2, { 524, 399 } },
    { 209088, 2, { 484, 432 } },
    { 209100, 2, { 492, 425 } },
    { 209124, 2, { 471, 444 } },
    { 209196, 2, { 468, 447 } },
    { 209209, 2, { 847, 247 } },
    { 209230, 2, { 490, 427 } },
    { 209235, 2, { 481, 435 } },
    { 209244, 2, { 564, 371 } },
    { 209250, 2, { 465, 450 } },
    { 209264, 2, { 464, 451 } },
    { 209292, 2, { 489, 428 } },
    { 209304, 2, { 459, 456 } },
    { 209328, 2, { 534, 392 } },
    { 209352, 2, { 488, 429 } },
    { 209380, 2, { 551, 380 } },
    { 209440, 2, { 476, 440 } },
    { 209475, 2, { 475, 441 } },
    { 209510, 2, { 511, 410 } },
    { 209520, 2, { 485, 432 } },
    { 209525, 2, { 493, 425 } },
    { 209560, 2, { 520, 403 } },
    { 209573, 2, { 611, 343 } },
    { 209625, 2, { 559, 375 } },
    { 209664, 2, { 468, 448 } },
    { 209676, 2, { 519, 404 } },
    { 209715, 2, { 465, 451 } },
    { 209745, 2, { 531, 395 } },
    { 209760, 2, { 460, 456 } },
    { 209790, 2, { 518, 405 } },
    { 209808, 2, { 496, 423 } },
    { 209880, 2, { 477, 440 } },
    { 209902, 2, { 517, 406 } },
    { 209916, 2, { 476, 441 } },
    { 209920, 2, { 512, 410 } },
    { 209952, 2, { 486, 432 } },
    { 210012, 2, { 473, 444 } },
    { 210040, 2, { 472, 445 } },
    { 210080, 2, { 505, 416 } },
    { 210084, 2, { 492, 427 } },
    { 210112, 2, { 469, 448 } },
    { 210168, 2, { 504, 417 } },
    { 210180, 2, { 465, 452 } },
    { 210192, 2, { 464, 453 } },
    { 210210, 2, { 462, 455 } },
    { 210231, 2, { 497, 423 } },
    { 210240, 2, { 480, 438 } },
    { 210273, 2, { 527, 399 } },
    { 210276, 2, { 531, 396 } },
    { 210330, 2, { 513, 410 } },
    { 210366, 2, { 522, 403 } },
    { 210375, 2, { 495, 425 } },
    { 210420, 2, { 501, 420 } },
    { 210432, 2, { 512, 411 } },
    { 210450, 2, { 575, 366 } },
    { 210496, 2, { 506, 416 } },
    { 210504, 2, { 537, 392 } },
    { 210540, 2, { 484, 435 } },
    { 210560, 2, { 470, 448 } },
    { 210588, 2, { 483, 436 } },
    { 210630, 2, { 510, 413 } },
    { 210672, 2, { 462, 456 } },
    { 210684, 2, { 543, 388 } },
    { 210728, 2, { 497, 424 } },
    { 210749, 2, { 539, 391 } },
    { 210795, 2, { 611, 345 } },
    { 210800, 2, { 496, 425 } },
    { 210900, 2, { 475, 444 } },
    { 210912, 2, { 507, 416 } },
    { 210915, 2, { 545, 387 } },
    { 210924, 2, { 486, 434 } },
    { 210925, 2, { 649, 325 } },
    { 210930, 2, { 474, 445 } },
    { 210936, 2, { 517, 408 } },
    { 210945, 2, { 615, 343 } },
    { 210984, 2, { 472, 447 } },
    { 211008, 2, { 471, 448 } },
    { 211050, 2, { 469, 450 } },
    { 211068, 2, { 468, 451 } },
    { 211120, 2, { 464, 455 } },
    { 211140, 2, { 460, 459 } },
    { 211152, 2, { 498, 424 } },
    { 211185, 2, { 585, 361 } },
    { 211200, 2, { 480, 440 } },
    { 211225, 2, { 497, 425 } },
    { 211232, 2, { 574, 368 } },
    { 211248, 2, { 489, 432 } },
    { 211250, 2, { 625, 338 } },
    { 211288, 2, { 539, 392 } },
    { 211296, 2, { 496, 426 } },
    { 211356, 2, { 513, 412 } },
    { 211365, 2, { 495, 427 } },
    { 211410, 2, { 486, 435 } },
    { 211497, 2, { 493, 429 } },
    { 211500, 2, { 470, 450 } },
    { 211508, 2, { 484, 437 } },
    { 211560, 2, { 492, 430 } },
    { 211640, 2, { 481, 440 } },
    { 211650, 2, { 498, 425 } },
    { 211680, 2, { 480, 441 } },
    { 211720, 2, { 536, 395 } },
    { 211752, 2, { 519, 408 } },
    { 211761, 2, { 621, 341 } },
    { 211788, 2, { 477, 444 } },
    { 211836, 2, { 508, 417 } },
    { 211860, 2, { 495, 428 } },
    { 211869, 2, { 513, 413 } },
    { 211904, 2, { 473, 448 } },
    { 211926, 2, { 494, 429 } },
    { 211968, 2, { 512, 414 } },
    { 212004, 2, { 468, 453 } },
    { 212040, 2, { 465, 456 } },
    { 212076, 2, { 516, 411 } },
    { 212100, 2, { 505, 420 } },
    { 212121, 2, { 481, 441 } },
    { 212135, 2, { 551, 385 } },
    { 212160, 2, { 480, 442 } },
    { 212175, 2, { 575, 369 } },
    { 212205, 2, { 645, 329 } },
    { 212220, 2, { 524, 405 } },
    { 212256, 2, { 528, 402 } },
    { 212265, 2, { 477, 445 } },
    { 212280, 2, { 488, 435 } },
    { 212352, 2, { 474, 448 } },
    { 212355, 2, { 495, 429 } },
    { 212382, 2, { 486, 437 } },
    { 212400, 2, { 472, 450 } },
    { 212424, 2, { 501, 424 } },
    { 212430, 2, { 485, 438 } },
    { 212454, 2, { 522, 407 } },
    { 212480, 2, { 512, 415 } },
    { 212544, 2, { 492, 432 } },
    { 212550, 2, { 545, 390 } },
    { 212576, 2, { 511, 416 } },
    { 212625, 2, { 525, 405 } },
    { 212652, 2, { 537, 396 } },
    { 212667, 2, { 533, 399 } },
    { 212704, 2, { 544, 391 } },
    { 212772, 2, { 476, 447 } },
    { 212784, 2, { 496, 429 } },
    { 212800, 2, { 475, 448 } },
    { 212850, 2, { 473, 450 } },
    { 212856, 2, { 543, 392 } },
    { 212892, 2, { 471, 452 } },
    { 212895, 2, { 513, 415 } },
    { 212940, 2, { 468, 455 } },
    { 212976, 2, { 464, 459 } },
    { 213012, 2, { 549, 388 } },
    { 213108, 2, { 516, 413 } },
    { 213120, 2, { 480, 444 } },
    { 213125, 2, { 625, 341 } },
    { 213180, 2, { 510, 418 } },
    { 213192, 2, { 504, 423 } },
    { 213204, 2, { 489, 436 } },
    { 213210, 2, { 515, 414 } },
    { 213248, 2, { 476, 448 } },
    { 213280, 2, { 496, 430 } },
    { 213325, 2, { 575, 371 } },
    { 213400, 2, { 485, 440 } },
    { 213435, 2, { 465, 459 } },
    { 213500, 2, { 500, 427 } },
    { 213504, 2, { 512, 417 } },
    { 213525, 2, { 585, 365 } },
    { 213570, 2, { 565, 378 } },
    { 213600, 2, { 480, 445 } },
    { 213615, 2, { 505, 423 } },
    { 213675, 2, { 525, 407 } },
    { 213696, 2, { 477, 448 } },
    { 213710, 2, { 497, 430 } },
    { 213720, 2, { 520, 411 } },
    { 213744, 2, { 488, 438 } },
    { 213750, 2, { 475, 450 } },
    { 213759, 2, { 567, 377 } },
    { 213785, 2, { 715, 299 } },
    { 213807, 2, { 589, 363 } },
    { 213808, 2, { 581, 368 } },
    { 213816, 2, { 472, 453 } },
    { 213828, 2, { 519, 412 } },
    { 213840, 2, { 486, 440 } },
    { 213864, 2, { 469, 456 } },
    { 213885, 2, { 485, 441 } },
    { 213900, 2, { 465, 460 } },
    { 213928, 2, { 484, 442 } },
    { 214011, 2, { 553, 387 } },
    { 214016, 2, { 512, 418 } },
    { 214020, 2, { 492, 435 } },
    { 214032, 2, { 546, 392 } },
    { 214065, 2, { 603, 355 } },
    { 214120, 2, { 505, 424 } },
    { 214130, 2, { 490, 437 } },
    { 214149, 2, { 663, 323 } },
    { 214200, 2, { 476, 450 } },
    { 214225, 2, { 475, 451 } },
    { 214240, 2, { 515, 416 } },
    { 214245, 2, { 529, 405 } },
    { 214320, 2, { 470, 456 } },
    { 214326, 2, { 486, 441 } },
    { 214368, 2, { 464, 462 } },
    { 214375, 2, { 625, 343 } },
    { 214389, 2, { 581, 369 } },
    { 214428, 2, { 501, 428 } },
    { 214452, 2, { 483, 444 } },
    { 214500, 2, { 500, 429 } },
    { 214524, 2, { 531, 404 } },
    { 214560, 2, { 480, 447 } },
    { 214656, 2, { 516, 416 } },
    { 214676, 2, { 476, 451 } },
    { 214704, 2, { 497, 432 } },
    { 214760, 2, { 472, 455 } },
    { 214776, 2, { 471, 456 } },
    { 214795, 2, { 595, 361 } },
    { 214800, 2, { 537, 400 } },
    { 214812, 2, { 468, 459 } },
    { 214880, 2, { 544, 395 } },
    { 214884, 2, { 508, 423 } },
    { 214968, 2, { 507, 424 } },
    { 215016, 2, { 527, 408 } },
    { 215028, 2, { 543, 396 } },
    { 215050, 2, { 506, 425 } },
    { 215070, 2, { 535, 402 } },
    { 215072, 2, { 517, 416 } },
    { 215118, 2, { 629, 342 } },
    { 215130, 2, { 505, 426 } },
    { 215136, 2, { 498, 432 } },
    { 215160, 2, { 489, 440 } },
    { 215172, 2, { 516, 417 } },
    { 215208, 2, { 488, 441 } },
    { 215215, 2, { 473, 455 } },
    { 215271, 2, { 469, 459 } },
    { 215280, 2, { 468, 460 } },
    { 215340, 2, { 485, 444 } },
    { 215364, 2, { 524, 411 } },
    { 215460, 2, { 513, 420 } },
    { 215488, 2, { 481, 448 } },
    { 215586, 2, { 522, 413 } },
    { 215604, 2, { 477, 452 } },
    { 215628, 2, { 476, 453 } },
    { 215644, 2, { 572, 377 } },
    { 215670, 2, { 474, 455 } },
    { 215688, 2, { 473, 456 } },
    { 215730, 2, { 470, 459 } },
    { 215740, 2, { 469, 460 } },
    { 215747, 2, { 629, 343 } },
    { 215760, 2, { 465, 464 } },
    { 215800, 2, { 520, 415 } },
    { 215820, 2, { 495, 436 } },
    { 215832, 2, { 529, 408 } },
    { 215865, 2, { 533, 405 } },
    { 215878, 2, { 494, 437 } },
    { 215904, 2, { 519, 416 } },
    { 215985, 2, { 561, 385 } },
    { 216000, 2, { 480, 450 } },
    { 216144, 2, { 474, 456 } },
    { 216153, 2, { 511, 423 } },
    { 216195, 2, { 497, 435 } },
    { 216240, 2, { 510, 424 } },
    { 216270, 2, { 486, 445 } },
    { 216300, 2, { 515, 420 } },
    { 216315, 2, { 495, 437 } },
    { 216348, 2, { 484, 447 } },
    { 216384, 2, { 483, 448 } },
    { 216398, 2, { 533, 406 } },
    { 216432, 2, { 501, 432 } },
    { 216450, 2, { 481, 450 } },
    { 216480, 2, { 480, 451 } },
    { 216576, 2, { 512, 423 } },
    { 216600, 2, { 475, 456 } },
    { 216648, 2, { 472, 459 } },
    { 216660, 2, { 471, 460 } },
    { 216664, 2, { 511, 424 } },
    { 216675, 2, { 535, 405 } },
    { 216720, 2, { 504, 430 } },
    { 216775, 2, { 575, 377 } },
    { 216776, 2, { 553, 392 } },
    { 216825, 2, { 525, 413 } },
    { 216832, 2, { 484, 448 } },
    { 216840, 2, { 520, 417 } },
    { 216855, 2, { 549, 395 } },
    { 216876, 2, { 583, 372 } },
    { 216920, 2, { 493, 440 } },
    { 216948, 2, { 537, 404 } },
    { 216972, 2, { 492, 441 } },
    { 216996, 2, { 507, 428 } },
    { 217000, 2, { 500, 434 } },
    { 217008, 2, { 528, 411 } },
    { 217035, 2, { 477, 455 } },
    { 217080, 2, { 536, 405 } },
    { 217107, 2, { 473, 459 } },
    { 217116, 2, { 489, 444 } },
    { 217152, 2, { 468, 464 } },
    { 217160, 2, { 488, 445 } },
    { 217175, 2, { 511, 425 } },
    { 217200, 2, { 543, 400 } },
    { 217217, 2, { 539, 403 } },
    { 217248, 2, { 496, 438 } },
    { 217280, 2, { 485, 448 } },
    { 217350, 2, { 483, 450 } },
    { 217360, 2, { 494, 440 } },
    { 217404, 2, { 549, 396 } },
    { 217413, 2, { 493, 441 } },
    { 217440, 2, { 480, 453 } },
    { 217500, 2, { 500, 435 } },
    { 217512, 2, { 477, 456 } },
    { 217560, 2, { 490, 444 } },
    { 217580, 2, { 473, 460 } },
    { 217600, 2, { 512, 425 } },
    { 217616, 2, { 469, 464 } },
    { 217620, 2, { 468, 465 } },
    { 217668, 2, { 561, 388 } },
    { 217672, 2, { 598, 364 } },
    { 217728, 2, { 486, 448 } },
    { 217770, 2, { 510, 427 } },
    { 217800, 2, { 484, 450 } },
    { 217833, 2, { 483, 451 } },
    { 217845, 2, { 515, 423 } },
    { 217854, 2, { 494, 441 } },
    { 217872, 2, { 534, 408 } },
    { 217906, 2, { 493, 442 } },
    { 217932, 2, { 508, 429 } },
    { 217980, 2, { 519, 420 } },
    { 218025, 2, { 475, 459 } },
    { 218064, 2, { 472, 462 } },
    { 218075, 2, { 671, 325 } },
    { 218080, 2, { 470, 464 } },
    { 218085, 2, { 469, 465 } },
    { 218112, 2, { 512, 426 } },
    { 218127, 2, { 611, 357 } },
    { 218136, 2, { 488, 447 } },
    { 218148, 2, { 588, 371 } },
    { 218160, 2, { 505, 432 } },
    { 218178, 2, { 527, 414 } },
    { 218225, 2, { 725, 301 } },
    { 218250, 2, { 485, 450 } },
    { 218268, 2, { 516, 423 } },
    { 218316, 2, { 483, 452 } },
    { 218360, 2, { 515, 424 } },
    { 218400, 2, { 480, 455 } },
    { 218405, 2, { 605, 361 } },
    { 218436, 2, { 501, 436 } },
    { 218456, 2, { 581, 376 } },
    { 218484, 2, { 476, 459 } },
    { 218508, 2, { 524, 417 } },
    { 218526, 2, { 473, 462 } },
    { 218544, 2, { 471, 464 } },
    { 218592, 2, { 506, 432 } },
    { 218625, 2, { 583, 375 } },
    { 218652, 2, { 532, 411 } },
    { 218655, 2, { 565, 387 } },
    { 218673, 2, { 623, 351 } },
    { 218680, 2, { 497, 440 } },
    { 218700, 2, { 486, 450 } },
    { 218736, 2, { 496, 441 } },
    { 218772, 2, { 531, 412 } },
    { 218790, 2, { 495, 442 } },
    { 218855, 2, { 481, 455 } },
    { 218880, 2, { 480, 456 } },
    { 218890, 2, { 530, 413 } },
    { 218940, 2, { 492, 445 } },
    { 219051, 2, { 513, 427 } },
    { 219072, 2, { 489, 448 } },
    { 219090, 2, { 545, 402 } },
    { 219096, 2, { 537, 408 } },
    { 219120, 2, { 498, 440 } },
    { 219128, 2, { 559, 392 } },
    { 219177, 2, { 497, 441 } },
    { 219186, 2, { 486, 451 } },
    { 219240, 2, { 504, 435 } },
    { 219252, 2, { 484, 453 } },
    { 219336, 2, { 481, 456 } },
    { 219351, 2, { 561, 391 } },
    { 219372, 2, { 543, 404 } },
    { 219373, 2, { 539, 407 } },
    { 219390, 2, { 515, 426 } },
    { 219420, 2, { 477, 460 } },
    { 219450, 2, { 475, 462 } },
    { 219472, 2, { 473, 464 } },
    { 219480, 2, { 472, 465 } },
    { 219492, 2, { 469, 468 } },
    { 219520, 2, { 490, 448 } },
    { 219555, 2, { 595, 369 } },
    { 219564, 2, { 513, 428 } },
    { 219600, 2, { 488, 450 } },
    { 219648, 2, { 512, 429 } },
    { 219725, 2, { 517, 425 } },
    { 219730, 2, { 511, 430 } },
    { 219780, 2, { 495, 444 } },
    { 219849, 2, { 551, 399 } },
    { 219924, 2, { 492, 447 } },
    { 219936, 2, { 474, 464 } },
    { 219945, 2, { 473, 465 } },
    { 219960, 2, { 470, 468 } },
    { 219996, 2, { 567, 388 } },
    { 220032, 2, { 573, 384 } },
    { 220056, 2, { 519, 424 } },
    { 220064, 2, { 529, 416 } },
    { 220095, 2, { 603, 365 } },
    { 220150, 2, { 518, 425 } },
    { 220160, 2, { 512, 430 } },
    { 220176, 2, { 528, 417 } },
    { 220224, 2, { 496, 444 } },
    { 220248, 2, { 483, 456 } },
    { 220255, 2, { 899, 245 } },
    { 220275, 2, { 495, 445 } },
    { 220286, 2, { 527, 418 } },
    { 220296, 2, { 536, 411 } },
    { 220320, 2, { 480, 459 } },
    { 220332, 2, { 516, 427 } },
    { 220350, 2, { 565, 390 } },
    { 220365, 2, { 531, 415 } },
    { 220400, 2, { 475, 464 } },
    { 220416, 2, { 492, 448 } },
    { 220428, 2, { 471, 468 } },
    { 220430, 2, { 470, 469 } },
    { 220440, 2, { 501, 440 } },
    { 220455, 2, { 621, 355 } },
    { 220500, 2, { 490, 450 } },
    { 220590, 2, { 513, 430 } },
    { 220662, 2, { 533, 414 } },
    { 220668, 2, { 497, 444 } },
    { 220720, 2, { 496, 445 } },
    { 220725, 2, { 545, 405 } },
    { 220752, 2, { 504, 438 } },
    { 220779, 2, { 481, 459 } },
    { 220800, 2, { 480, 460 } },
    { 220932, 2, { 612, 361 } },
    { 220980, 2, { 508, 435 } },
    { 220990, 2, { 490, 451 } },
    { 221000, 2, { 500, 442 } },
    { 221028, 2, { 489, 452 } },
    { 221052, 2, { 507, 436 } },
    { 221064, 2, { 488, 453 } },
    { 221130, 2, { 486, 455 } },
    { 221160, 2, { 485, 456 } },
    { 221184, 2, { 512, 432 } },
    { 221190, 2, { 505, 438 } },
    { 221200, 2, { 553, 400 } },
    { 221221, 2, { 1001, 221 } },
    { 221235, 2, { 645, 343 } },
    { 221244, 2, { 537, 412 } },
    { 221260, 2, { 481, 460 } },
    { 221312, 2, { 494, 448 } },
    { 221328, 2, { 477, 464 } },
    { 221340, 2, { 476, 465 } },
    { 221364, 2, { 473, 468 } },
    { 221368, 2, { 472, 469 } },
    { 221408, 2, { 544, 407 } },
    { 221430, 2, { 605, 366 } },
    { 221490, 2, { 535, 414 } },
    { 221520, 2, { 520, 426 } },
    { 221536, 2, { 602, 368 } },
    { 221544, 2, { 543, 408 } },
    { 221559, 2, { 507, 437 } },
    { 221578, 2, { 646, 343 } },
    { 221610, 2, { 498, 445 } },
    { 221616, 2, { 486, 456 } },
    { 221650, 2, { 550, 403 } },
    { 221652, 2, { 524, 423 } },
    { 221697, 2, { 483, 459 } },
    { 221712, 2, { 496, 447 } },
    { 221728, 2, { 533, 416 } },
    { 221760, 2, { 480, 462 } },
    { 221796, 2, { 549, 404 } },
    { 221844, 2, { 532, 417 } },
    { 221850, 2, { 493, 450 } },
    { 221904, 2, { 536, 414 } },
    { 221940, 2, { 540, 411 } },
    { 222040, 2, { 488, 455 } },
    { 222132, 2, { 519, 428 } },
    { 222144, 2, { 534, 416 } },
    { 222156, 2, { 484, 459 } },
    { 222180, 2, { 483, 460 } },
    { 222200, 2, { 505, 440 } },
    { 222222, 2, { 481, 462 } },
    { 222264, 2, { 504, 441 } },
    { 222285, 2, { 511, 435 } },
    { 222300, 2, { 475, 468 } },
    { 222312, 2, { 472, 471 } },
    { 222324, 2, { 573, 388 } },
    { 222404, 2, { 611, 364 } },
    { 222425, 2, { 775, 287 } },
    { 222440, 2, { 536, 415 } },
    { 222444, 2, { 501, 444 } },
    { 222456, 2, { 552, 403 } },
    { 222480, 2, { 515, 432 } },
    { 222525, 2, { 575, 387 } },
    { 222530, 2, { 578, 385 } },
    { 222600, 2, { 525, 424 } },
    { 222615, 2, { 485, 459 } },
    { 222642, 2, { 513, 434 } },
    { 222656, 2, { 497, 448 } },
    { 222705, 2, { 505, 441 } },
    { 222768, 2, { 476, 468 } },
    { 222775, 2, { 475, 469 } },
    { 222870, 2, { 510, 437 } },
    { 222876, 2, { 492, 453 } },
    { 222894, 2, { 522, 427 } },
    { 222912, 2, { 516, 432 } },
    { 222984, 2, { 489, 456 } },
    { 223020, 2, { 531, 420 } },
    { 223040, 2, { 544, 410 } },
    { 223041, 2, { 559, 399 } },
    { 223080, 2, { 507, 440 } },
    { 223104, 2, { 498, 448 } },
    { 223155, 2, { 513, 435 } },
    { 223184, 2, { 481, 464 } },
    { 223200, 2, { 480, 465 } },
    { 223236, 2, { 477, 468 } },
    { 223245, 2, { 495, 451 } },
    { 223300, 2, { 550, 406 } },
    { 223344, 2, { 517, 432 } },
    { 223392, 2, { 537, 416 } },
    { 223440, 2, { 490, 456 } },
    { 223500, 2, { 500, 447 } },
    { 223512, 2, { 536, 417 } },
    { 223560, 2, { 486, 460 } },
    { 223584, 2, { 544, 411 } },
    { 223587, 2, { 507, 441 } },
    { 223650, 2, { 497, 450 } },
    { 223665, 2, { 481, 465 } },
    { 223668, 2, { 513, 436 } },
    { 223696, 2, { 496, 451 } },
    { 223713, 2, { 477, 469 } },
    { 223716, 2, { 543, 412 } },
    { 223728, 2, { 474, 472 } },
    { 223740, 2, { 495, 452 } },
    { 223744, 2, { 512, 437 } },
    { 223820, 2, { 589, 380 } },
    { 223850, 2, { 550, 407 } },
    { 223860, 2, { 492, 455 } },
    { 223905, 2, { 649, 345 } },
    { 223925, 2, { 689, 325 } },
    { 223965, 2, { 553, 405 } },
    { 223975, 2, { 527, 425 } },
    { 223992, 2, { 488, 459 } },
    { 224000, 2, { 500, 448 } },
    { 224028, 2, { 508, 441 } },
    { 224070, 2, { 485, 462 } },
    { 224112, 2, { 483, 464 } },
    { 224175, 2, { 525, 427 } },
    { 224181, 2, { 513, 437 } },
    { 224196, 2, { 476, 471 } },
    { 224200, 2, { 475, 472 } },
    { 224208, 2, { 519, 432 } },
    { 224220, 2, { 505, 444 } },
    { 224224, 2, { 539, 416 } },
    { 224250, 2, { 575, 390 } },
    { 224256, 2, { 512, 438 } },
    { 224280, 2, { 504, 445 } },
    { 224315, 2, { 493, 455 } },
    { 224360, 2, { 568, 395 } },
    { 224378, 2, { 517, 434 } },
    { 224400, 2, { 510, 440 } },
    { 224448, 2, { 501, 448 } },
    { 224455, 2, { 583, 385 } },
    { 224460, 2, { 516, 435 } },
    { 224532, 2, { 486, 462 } },
    { 224553, 2, { 629, 357 } },
    { 224616, 2, { 573, 392 } },
    { 224640, 2, { 480, 468 } },
    { 224652, 2, { 579, 388 } },
    { 224675, 2, { 475, 473 } },
    { 224688, 2, { 496, 453 } },
    { 224700, 2, { 525, 428 } },
    { 224770, 2, { 494, 455 } },
    { 224775, 2, { 555, 405 } },
    { 224796, 2, { 524, 429 } },
    { 224808, 2, { 493, 456 } },
    { 224825, 2, { 529, 425 } },
    { 224840, 2, { 511, 440 } },
    { 224847, 2, { 581, 387 } },
    { 224895, 2, { 517, 435 } },
    { 224910, 2, { 490, 459 } },
    { 224928, 2, { 528, 426 } },
    { 224939, 2, { 1331, 169 } },
    { 224940, 2, { 489, 460 } },
    { 225036, 2, { 532, 423 } },
    { 225040, 2, { 485, 464 } },
    { 225060, 2, { 484, 465 } },
    { 225108, 2, { 481, 468 } },
    { 225120, 2, { 480, 469 } },
    { 225144, 2, { 477, 472 } },
    { 225148, 2, { 476, 473 } },
    { 225150, 2, { 475, 474 } },
    { 225180, 2, { 540, 417 } },
    { 225216, 2, { 544, 414 } },
    { 225225, 2, { 495, 455 } },
    { 225280, 2, { 512, 440 } },
    { 225288, 2, { 504, 447 } },
    { 225302, 2, { 539, 418 } },
    { 225330, 2, { 518, 435 } },
    { 225351, 2, { 511, 441 } },
    { 225456, 2, { 488, 462 } },
    { 225500, 2, { 500, 451 } },
    { 225504, 2, { 486, 464 } },
    { 225540, 2, { 537, 420 } },
    { 225570, 2, { 515, 438 } },
    { 225600, 2, { 480, 470 } },
    { 225630, 2, { 545, 414 } },
    { 225675, 2, { 531, 425 } },
    { 225680, 2, { 496, 455 } },
    { 225720, 2, { 495, 456 } },
    { 225760, 2, { 544, 415 } },
    { 225792, 2, { 504, 448 } },
    { 225828, 2, { 492, 459 } },
    { 225888, 2, { 543, 416 } },
    { 225990, 2, { 486, 465 } },
    { 226044, 2, { 483, 468 } },
    { 226080, 2, { 480, 471 } },
    { 226083, 2, { 527, 429 } },
    { 226107, 2, { 679, 333 } },
    { 226188, 2, { 549, 412 } },
    { 226200, 2, { 520, 435 } },
    { 226240, 2, { 505, 448 } },
    { 226284, 2, { 519, 436 } },
    { 226287, 2, { 493, 459 } },
    { 226304, 2, { 512, 442 } },
    { 226305, 2, { 535, 423 } },
    { 226310, 2, { 530, 427 } },
    { 226395, 2, { 559, 405 } },
    { 226416, 2, { 534, 424 } },
    { 226452, 2, { 501, 452 } },
    { 226500, 2, { 500, 453 } },
    { 226525, 2, { 533, 425 } },
    { 226548, 2, { 522, 434 } },
    { 226575, 2, { 477, 475 } },
    { 226590, 2, { 498, 455 } },
    { 226600, 2, { 515, 440 } },
    { 226625, 2, { 875, 259 } },
    { 226632, 2, { 497, 456 } },
    { 226644, 2, { 561, 404 } },
    { 226665, 2, { 621, 365 } },
    { 226688, 2, { 506, 448 } },
    { 226728, 2, { 536, 423 } },
    { 226730, 2, { 553, 410 } },
    { 226737, 2, { 531, 427 } },
    { 226746, 2, { 494, 459 } },
    { 226765, 2, { 589, 385 } },
    { 226780, 2, { 493, 460 } },
    { 226800, 2, { 504, 450 } },
    { 226848, 2, { 544, 417 } },
    { 226875, 2, { 605, 375 } },
    { 226884, 2, { 511, 444 } },
    { 226896, 2, { 489, 464 } },
    { 226908, 2, { 573, 396 } },
    { 226920, 2, { 488, 465 } },
    { 226941, 2, { 529, 429 } },
    { 226950, 2, { 510, 445 } },
    { 226954, 2, { 559, 406 } },
    { 226968, 2, { 579, 392 } },
    { 226980, 2, { 485, 468 } },
    { 227040, 2, { 480, 473 } },
    { 227052, 2, { 477, 476 } },
    { 227076, 2, { 508, 447 } },
    { 227088, 2, { 498, 456 } },
    { 227106, 2, { 558, 407 } },
    { 227115, 2, { 515, 441 } },
    { 227130, 2, { 565, 402 } },
    { 227136, 2, { 507, 448 } },
    { 227150, 2, { 550, 413 } },
    { 227250, 2, { 505, 450 } },
    { 227268, 2, { 531, 428 } },
    { 227328, 2, { 512, 444 } },
    { 227360, 2, { 490, 464 } },
    { 227392, 2, { 544, 418 } },
    { 227500, 2, { 500, 455 } },
    { 227520, 2, { 480, 474 } },
    { 227556, 2, { 516, 441 } },
    { 227664, 2, { 496, 459 } },
    { 227688, 2, { 537, 424 } },
    { 227700, 2, { 495, 460 } },
    { 227752, 2, { 581, 392 } },
    { 227760, 2, { 520, 438 } },
    { 227766, 2, { 493, 462 } },
    { 227772, 2, { 513, 444 } },
    { 227800, 2, { 536, 425 } },
    { 227835, 2, { 549, 415 } },
    { 227840, 2, { 512, 445 } },
    { 227910, 2, { 535, 426 } },
    { 227920, 2, { 518, 440 } },
    { 227934, 2, { 486, 469 } },
    { 227940, 2, { 524, 435 } },
    { 227964, 2, { 484, 471 } },
    { 227976, 2, { 483, 472 } },
    { 227997, 2, { 517, 441 } },
    { 228000, 2, { 480, 475 } },
    { 228060, 2, { 543, 420 } },
    { 228085, 2, { 605, 377 } },
    { 228123, 2, { 497, 459 } },
    { 228144, 2, { 582, 392 } },
    { 228150, 2, { 507, 450 } },
    { 228165, 2, { 615, 371 } },
    { 228228, 2, { 494, 462 } },
    { 228285, 2, { 513, 445 } },
    { 228288, 2, { 492, 464 } },
    { 228312, 2, { 504, 453 } },
    { 228336, 2, { 536, 426 } },
    { 228360, 2, { 519, 440 } },
    { 228420, 2, { 486, 470 } },
    { 228456, 2, { 501, 456 } },
    { 228459, 2, { 483, 473 } },
    { 228475, 2, { 481, 475 } },
    { 228480, 2, { 480, 476 } },
    { 228501, 2, { 567, 403 } },
    { 228516, 2, { 548, 417 } },
    { 228528, 2, { 529, 432 } },
    { 228536, 2, { 539, 424 } },
    { 228620, 2, { 497, 460 } },
    { 228660, 2, { 515, 444 } },
    { 228735, 2, { 585, 391 } },
    { 228780, 2, { 492, 465 } },
    { 228781, 2, { 667, 343 } },
    { 228825, 2, { 565, 405 } },
    { 228852, 2, { 489, 468 } },
    { 228864, 2, { 512, 447 } },
    { 228872, 2, { 488, 469 } },
    { 228888, 2, { 561, 408 } },
    { 228900, 2, { 525, 436 } },
    { 228920, 2, { 485, 472 } },
    { 228928, 2, { 511, 448 } },
    { 228956, 2, { 481, 476 } },
    { 228960, 2, { 480, 477 } },
    { 229068, 2, { 567, 404 } },
    { 229075, 2, { 539, 425 } },
    { 229125, 2, { 611, 375 } },
    { 229152, 2, { 496, 462 } },
    { 229164, 2, { 507, 452 } },
    { 229200, 2, { 573, 400 } },
    { 229215, 2, { 555, 413 } },
    { 229264, 2, { 623, 368 } },
    { 229284, 2, { 579, 396 } },
    { 229320, 2, { 490, 468 } },
    { 229392, 2, { 486, 472 } },
    { 229425, 2, { 483, 475 } },
    { 229500, 2, { 500, 459 } },
    { 229548, 2, { 517, 444 } },
    { 229600, 2, { 560, 410 } },
    { 229620, 2, { 516, 445 } },
    { 229632, 2, { 552, 416 } },
    { 229680, 2, { 495, 464 } },
    { 229770, 2, { 555, 414 } },
    { 229810, 2, { 490, 469 } },
    { 229836, 2, { 537, 428 } },
    { 229840, 2, { 520, 442 } },
    { 229848, 2, { 488, 471 } },
    { 229878, 2, { 486, 473 } },
    { 229887, 2, { 623, 369 } },
    { 229890, 2, { 485, 474 } },
    { 229908, 2, { 483, 476 } },
    { 229944, 2, { 536, 429 } },
    { 229950, 2, { 511, 450 } },
    { 229957, 2, { 637, 361 } },
    { 230010, 2, { 510, 451 } },
    { 230048, 2, { 553, 416 } },
    { 230112, 2, { 544, 423 } },
    { 230124, 2, { 508, 453 } },
    { 230184, 2, { 552, 417 } },
    { 230230, 2, { 506, 455 } },
    { 230232, 2, { 543, 424 } },
    { 230265, 2, { 595, 387 } },
    { 230280, 2, { 505, 456 } },
    { 230318, 2, { 551, 418 } },
    { 230436, 2, { 519, 444 } },
    { 230460, 2, { 501, 460 } },
    { 230516, 2, { 572, 403 } },
    { 230535, 2, { 545, 423 } },
    { 230580, 2, { 540, 427 } },
    { 230608, 2, { 497, 464 } },
    { 230640, 2, { 496, 465 } },
    { 230652, 2, { 516, 447 } },
    { 230680, 2, { 584, 395 } },
    { 230688, 2, { 534, 432 } },
    { 230720, 2, { 515, 448 } },
    { 230724, 2, { 493, 468 } },
    { 230736, 2, { 506, 456 } },
    { 230748, 2, { 492, 469 } },
    { 230769, 2, { 567, 407 } },
    { 230808, 2, { 489, 472 } },
    { 230850, 2, { 486, 475 } },
    { 230868, 2, { 484, 477 } },
    { 230880, 2, { 481, 480 } },
    { 230912, 2, { 512, 451 } },
    { 230945, 2, { 715, 323 } },
    { 231000, 2, { 500, 462 } },
    { 231072, 2, { 498, 464 } },
    { 231075, 2, { 585, 395 } },
    { 231084, 2, { 524, 441 } },
    { 231105, 2, { 497, 465 } },
    { 231120, 2, { 535, 432 } },
    { 231132, 2, { 561, 412 } },
    { 231150, 2, { 575, 402 } },
    { 231168, 2, { 516, 448 } },
    { 231192, 2, { 494, 468 } },
    { 231200, 2, { 544, 425 } },
    { 231231, 2, { 539, 429 } },
    { 231240, 2, { 492, 470 } },
    { 231264, 2, { 528, 438 } },
    { 231312, 2, { 488, 474 } },
    { 231322, 2, { 533, 434 } },
    { 231336, 2, { 486, 476 } },
    { 231345, 2, { 485, 477 } },
    { 231363, 2, { 513, 451 } },
    { 231400, 2, { 520, 445 } },
    { 231420, 2, { 532, 435 } },
    { 231426, 2, { 559, 414 } },
    { 231492, 2, { 573, 404 } },
    { 231495, 2, { 671, 345 } },
    { 231504, 2, { 546, 424 } },
    { 231516, 2, { 531, 436 } },
    { 231600, 2, { 579, 400 } },
    { 231616, 2, { 517, 448 } },
    { 231660, 2, { 495, 468 } },
    { 231725, 2, { 575, 403 } },
    { 231732, 2, { 492, 471 } },
    { 231744, 2, { 544, 426 } },
    { 231750, 2, { 515, 450 } },
    { 231770, 2, { 490, 473 } },
    { 231795, 2, { 505, 459 } },
    { 231800, 2, { 488, 475 } },
    { 231804, 2, { 548, 423 } },
    { 231840, 2, { 483, 480 } },
    { 231855, 2, { 533, 435 } },
    { 231875, 2, { 625, 371 } },
    { 231876, 2, { 513, 452 } },
    { 231880, 2, { 527, 440 } },
    { 231936, 2, { 512, 453 } },
    { 231984, 2, { 537, 432 } },
    { 232050, 2, { 510, 455 } },
    { 232064, 2, { 518, 448 } },
    { 232128, 2, { 496, 468 } },
    { 232155, 2, { 495, 469 } },
    { 232170, 2, { 545, 426 } },
    { 232254, 2, { 506, 459 } },
    { 232290, 2, { 522, 445 } },
    { 232320, 2, { 484, 480 } },
    { 232323, 2, { 483, 481 } },
    { 232400, 2, { 560, 415 } },
    { 232404, 2, { 543, 428 } },
    { 232407, 2, { 527, 441 } },
    { 232440, 2, { 520, 447 } },
    { 232464, 2, { 501, 464 } },
    { 232470, 2, { 567, 410 } },
    { 232484, 2, { 532, 437 } },
    { 232500, 2, { 500, 465 } },
    { 232512, 2, { 519, 448 } },
    { 232544, 2, { 559, 416 } },
    { 232551, 2, { 729, 319 } },
    { 232560, 2, { 510, 456 } },
    { 232596, 2, { 497, 468 } },
    { 232617, 2, { 583, 399 } },
    { 232624, 2, { 496, 469 } },
    { 232645, 2, { 595, 391 } },
    { 232716, 2, { 492, 473 } },
    { 232764, 2, { 489, 476 } },
    { 232776, 2, { 488, 477 } },
    { 232800, 2, { 485, 480 } },
    { 232804, 2, { 484, 481 } },
    { 232848, 2, { 504, 462 } },
    { 232875, 2, { 575, 405 } },
    { 232932, 2, { 564, 413 } },
    { 232934, 2, { 527, 442 } },
    { 232960, 2, { 512, 455 } },
    { 233016, 2, { 511, 456 } },
    { 233100, 2, { 518, 450 } },
    { 233120, 2, { 496, 470 } },
    { 233160, 2, { 536, 435 } },
    { 233172, 2, { 508, 459 } },
    { 233220, 2, { 507, 460 } },
    { 233235, 2, { 639, 365 } },
    { 233275, 2, { 775, 301 } },
    { 233280, 2, { 486, 480 } },
    { 233310, 2, { 505, 462 } },
    { 233325, 2, { 549, 425 } },
    { 233376, 2, { 528, 442 } },
    { 233415, 2, { 513, 455 } },
    { 233450, 2, { 575, 406 } },
    { 233472, 2, { 512, 456 } },
    { 233496, 2, { 552, 423 } },
    { 233590, 2, { 497, 470 } },
    { 233604, 2, { 567, 412 } },
    { 233616, 2, { 496, 471 } },
    { 233618, 2, { 518, 451 } },
    { 233640, 2, { 495, 472 } },
    { 233700, 2, { 492, 475 } },
    { 233740, 2, { 580, 403 } },
    { 233748, 2, { 516, 453 } },
    { 233766, 2, { 486, 481 } },
    { 233772, 2, { 484, 483 } },
    { 233784, 2, { 573, 408 } },
    { 233818, 2, { 529, 442 } },
    { 233840, 2, { 592, 395 } },
    { 233910, 2, { 565, 414 } },
    { 233916, 2, { 579, 404 } },
    { 233919, 2, { 553, 423 } },
    { 233920, 2, { 544, 430 } },
    { 233928, 2, { 513, 456 } },
    { 234000, 2, { 500, 468 } },
    { 234025, 2, { 575, 407 } },
    { 234036, 2, { 591, 396 } },
    { 234080, 2, { 532, 440 } },
    { 234117, 2, { 621, 377 } },
    { 234132, 2, { 537, 436 } },
    { 234135, 2, { 495, 473 } },
    { 234175, 2, { 493, 475 } },
    { 234228, 2, { 524, 447 } },
    { 234234, 2, { 507, 462 } },
    { 234248, 2, { 623, 376 } },
    { 234320, 2, { 505, 464 } },
    { 234330, 2, { 535, 438 } },
    { 234360, 2, { 504, 465 } },
    { 234416, 2, { 598, 392 } },
    { 234432, 2, { 528, 444 } },
    { 234465, 2, { 539, 435 } },
    { 234468, 2, { 501, 468 } },
    { 234472, 2, { 553, 424 } },
    { 234500, 2, { 500, 469 } },
    { 234520, 2, { 520, 451 } },
    { 234549, 2, { 511, 459 } },
    { 234576, 2, { 543, 432 } },
    { 234584, 2, { 497, 472 } },
    { 234588, 2, { 519, 452 } },
    { 234608, 2, { 496, 473 } },
    { 234612, 2, { 532, 441 } },
    { 234624, 2, { 564, 416 } },
    { 234668, 2, { 493, 476 } },
    { 234684, 2, { 492, 477 } },
    { 234720, 2, { 489, 480 } },
    { 234738, 2, { 486, 483 } },
    { 234768, 2, { 536, 438 } },
    { 234780, 2, { 516, 455 } },
    { 234840, 2, { 515, 456 } },
    { 234850, 2, { 550, 427 } },
    { 234960, 2, { 528, 445 } },
    { 234972, 2, { 549, 428 } },
    { 235008, 2, { 512, 459 } },
    { 235011, 2, { 589, 399 } },
    { 235025, 2, { 553, 425 } },
    { 235053, 2, { 533, 441 } },
    { 235056, 2, { 498, 472 } },
    { 235060, 2, { 511, 460 } },
    { 235092, 2, { 548, 429 } },
    { 235104, 2, { 496, 474 } },
    { 235125, 2, { 495, 475 } },
    { 235144, 2, { 494, 476 } },
    { 235152, 2, { 552, 426 } },
    { 235188, 2, { 556, 423 } },
    { 235200, 2, { 490, 480 } },
    { 235224, 2, { 486, 484 } },
    { 235235, 2, { 517, 455 } },
    { 235248, 2, { 507, 464 } },
    { 235305, 2, { 567, 415 } },
    { 235320, 2, { 530, 444 } },
    { 235400, 2, { 535, 440 } },
    { 235410, 2, { 570, 413 } },
    { 235422, 2, { 522, 451 } },
    { 235431, 2, { 707, 333 } },
    { 235445, 2, { 961, 245 } },
    { 235500, 2, { 500, 471 } },
    { 235520, 2, { 512, 460 } },
    { 235543, 2, { 539, 437 } },
    { 235560, 2, { 520, 453 } },
    { 235600, 2, { 496, 475 } },
    { 235620, 2, { 495, 476 } },
    { 235625, 2, { 625, 377 } },
    { 235690, 2, { 490, 481 } },
    { 235704, 2, { 488, 483 } },
    { 235710, 2, { 486, 485 } },
    { 235720, 2, { 568, 415 } },
    { 235752, 2, { 517, 456 } },
    { 235764, 2, { 531, 444 } },
    { 235935, 2, { 535, 441 } },
    { 235950, 2, { 550, 429 } },
    { 235980, 2, { 513, 460 } },
    { 236016, 2, { 528, 447 } },
    { 236060, 2, { 580, 407 } },
    { 236075, 2, { 497, 475 } },
    { 236076, 2, { 573, 412 } },
    { 236160, 2, { 492, 480 } },
    { 236208, 2, { 518, 456 } },
    { 236220, 2, { 508, 465 } },
    { 236232, 2, { 579, 408 } },
    { 236250, 2, { 525, 450 } },
    { 236280, 2, { 537, 440 } },
    { 236295, 2, { 531, 445 } },
    { 236340, 2, { 505, 468 } },
    { 236376, 2, { 504, 469 } },
    { 236379, 2, { 551, 429 } },
    { 236385, 2, { 515, 459 } },
    { 236400, 2, { 591, 400 } },
    { 236472, 2, { 501, 472 } },
    { 236500, 2, { 500, 473 } },
    { 236544, 2, { 512, 462 } },
    { 236550, 2, { 498, 475 } },
    { 236555, 2, { 605, 391 } },
    { 236592, 2, { 496, 477 } },
    { 236600, 2, { 520, 455 } },
    { 236640, 2, { 493, 480 } },
    { 236664, 2, { 519, 456 } },
    { 236676, 2, { 489, 484 } },
    { 236680, 2, { 488, 485 } },
    { 236698, 2, { 583, 406 } },
    { 236748, 2, { 543, 436 } },
    { 236775, 2, { 525, 451 } },
    { 236808, 2, { 506, 468 } },
    { 236844, 2, { 516, 459 } },
    { 236880, 2, { 504, 470 } },
    { 236925, 2, { 585, 405 } },
    { 236985, 2, { 555, 427 } },
    { 236992, 2, { 529, 448 } },
    { 237069, 2, { 497, 477 } },
    { 237104, 2, { 511, 464 } },
    { 237120, 2, { 494, 480 } },
    { 237160, 2, { 490, 484 } },
    { 237168, 2, { 488, 486 } },
    { 237276, 2, { 507, 468 } },
    { 237300, 2, { 525, 452 } },
    { 237303, 2, { 517, 459 } },
    { 237372, 2, { 524, 453 } },
    { 237384, 2, { 504, 471 } },
    { 237440, 2, { 530, 448 } },
    { 237456, 2, { 582, 408 } },
    { 237475, 2, { 575, 413 } },
    { 237510, 2, { 522, 455 } },
    { 237540, 2, { 535, 444 } },
    { 237575, 2, { 559, 425 } },
    { 237600, 2, { 495, 480 } },
    { 237615, 2, { 511, 465 } },
    { 237636, 2, { 492, 483 } },
    { 237699, 2, { 539, 441 } },
    { 237705, 2, { 689, 345 } },
    { 237728, 2, { 544, 437 } },
    { 237762, 2, { 518, 459 } },
    { 237790, 2, { 553, 430 } },
    { 237804, 2, { 532, 447 } },
    { 237864, 2, { 561, 424 } },
    { 237930, 2, { 515, 462 } },
    { 238000, 2, { 500, 476 } },
    { 238032, 2, { 513, 464 } },
    { 238050, 2, { 529, 450 } },
    { 238095, 2, { 495, 481 } },
    { 238119, 2, { 493, 483 } },
    { 238140, 2, { 490, 486 } },
    { 238185, 2, { 603, 395 } },
    { 238238, 2, { 539, 442 } },
    { 238272, 2, { 544, 438 } },
    { 238280, 2, { 518, 460 } },
    { 238329, 2, { 679, 351 } },
    { 238336, 2, { 532, 448 } },
    { 238360, 2, { 505, 472 } },
    { 238368, 2, { 573, 416 } },
    { 238380, 2, { 548, 435 } },
    { 238392, 2, { 504, 473 } },
    { 238428, 2, { 537, 444 } },
    { 238476, 2, { 501, 476 } },
    { 238500, 2, { 500, 477 } },
    { 238520, 2, { 536, 445 } },
    { 238524, 2, { 556, 429 } },
    { 238525, 2, { 725, 329 } },
    { 238545, 2, { 513, 465 } },
    { 238548, 2, { 579, 412 } },
    { 238560, 2, { 497, 480 } },
    { 238576, 2, { 496, 481 } },
    { 238612, 2, { 493, 484 } },
    { 238620, 2, { 492, 485 } },
    { 238632, 2, { 489, 488 } },
    { 238680, 2, { 510, 468 } },
    { 238700, 2, { 550, 434 } },
    { 238710, 2, { 545, 438 } },
    { 238740, 2, { 519, 460 } },
    { 238764, 2, { 591, 404 } },
    { 238784, 2, { 533, 448 } },
    { 238800, 2, { 597, 400 } },
    { 238854, 2, { 517, 462 } },
    { 238875, 2, { 525, 455 } },
    { 238896, 2, { 504, 474 } },
    { 238920, 2, { 543, 440 } },
    { 238960, 2, { 515, 464 } },
    { 238995, 2, { 565, 423 } },
    { 239020, 2, { 629, 380 } },
    { 239040, 2, { 498, 480 } },
    { 239071, 2, { 697, 343 } },
    { 239085, 2, { 495, 483 } },
    { 239096, 2, { 494, 484 } },
    { 239148, 2, { 511, 468 } },
    { 239184, 2, { 528, 453 } },
    { 239190, 2, { 510, 469 } },
    { 239232, 2, { 534, 448 } },
    { 239268, 2, { 508, 471 } },
    { 239295, 2, { 645, 371 } },
    { 239304, 2, { 507, 472 } },
    { 239343, 2, { 663, 361 } },
    { 239364, 2, { 549, 436 } },
    { 239370, 2, { 505, 474 } },
    { 239400, 2, { 504, 475 } },
    { 239424, 2, { 516, 464 } },
    { 239512, 2, { 611, 392 } },
    { 239540, 2, { 580, 413 } },
    { 239568, 2, { 496, 483 } },
    { 239580, 2, { 495, 484 } },
    { 239592, 2, { 536, 447 } },
    { 239598, 2, { 493, 486 } },
    { 239616, 2, { 512, 468 } },
    { 239680, 2, { 535, 448 } },
    { 239785, 2, { 527, 455 } },
    { 239800, 2, { 545, 440 } },
    { 239850, 2, { 533, 450 } },
    { 239888, 2, { 517, 464 } },
    { 239904, 2, { 504, 476 } },
    { 239932, 2, { 532, 451 } },
    { 239940, 2, { 516, 465 } },
    { 240000, 2, { 500, 480 } },
    { 240012, 2, { 531, 452 } },
    { 240075, 2, { 495, 485 } },
    { 240084, 2, { 494, 486 } },
    { 240093, 2, { 721, 333 } },
    { 240108, 2, { 561, 428 } },
    { 240128, 2, { 512, 469 } },
    { 240149, 2, { 637, 377 } },
    { 240160, 2, { 608, 395 } },
    { 240170, 2, { 511, 470 } },
    { 240240, 2, { 520, 462 } },
    { 240312, 2, { 527, 456 } },
    { 240345, 2, { 545, 441 } },
    { 240350, 2, { 506, 475 } },
    { 240352, 2, { 518, 464 } },
    { 240405, 2, { 517, 465 } },
    { 240408, 2, { 504, 477 } },
    { 240480, 2, { 501, 480 } },
    { 240500, 2, { 500, 481 } },
    { 240516, 2, { 524, 459 } },
    { 240555, 2, { 553, 435 } },
    { 240560, 2, { 496, 485 } },
    { 240570, 2, { 495, 486 } },
    { 240576, 2, { 537, 448 } },
    { 240588, 2, { 492, 489 } },
    { 240597, 2, { 513, 469 } },
    { 240625, 2, { 625, 385 } },
    { 240640, 2, { 512, 470 } },
    { 240660, 2, { 573, 420 } },
    { 240690, 2, { 565, 426 } },
    { 240695, 2, { 529, 455 } },
    { 240720, 2, { 510, 472 } },
    { 240750, 2, { 535, 450 } },
    { 240800, 2, { 560, 430 } },
    { 240816, 2, { 519, 464 } },
    { 240828, 2, { 564, 427 } },
    { 240856, 2, { 506, 476 } },
    { 240864, 2, { 579, 416 } },
    { 240870, 2, { 518, 465 } },
    { 240885, 2, { 505, 477 } },
    { 240975, 2, { 525, 459 } },
    { 240996, 2, { 532, 453 } },
    { 241020, 2, { 515, 468 } },
    { 241056, 2, { 496, 486 } },
    { 241080, 2, { 492, 490 } },
    { 241092, 2, { 543, 444 } },
    { 241101, 2, { 623, 387 } },
    { 241110, 2, { 513, 470 } },
    { 241128, 2, { 591, 408 } },
    { 241129, 2, { 703, 343 } },
    { 241152, 2, { 512, 471 } },
    { 241188, 2, { 597, 404 } },
    { 241192, 2, { 511, 472 } },
    { 241200, 2, { 536, 450 } },
    { 241224, 2, { 529, 456 } },
    { 241230, 2, { 510, 473 } },
    { 241332, 2, { 507, 476 } },
    { 241380, 2, { 540, 447 } },
    { 241400, 2, { 568, 425 } },
    { 241428, 2, { 649, 372 } },
    { 241472, 2, { 539, 448 } },
    { 241500, 2, { 500, 483 } },
    { 241530, 2, { 498, 485 } },
    { 241536, 2, { 544, 444 } },
    { 241542, 2, { 497, 486 } },
    { 241560, 2, { 495, 488 } },
    { 241570, 2, { 493, 490 } },
    { 241605, 2, { 531, 455 } },
    { 241668, 2, { 548, 441 } },
    { 241680, 2, { 530, 456 } },
    { 241696, 2, { 581, 416 } },
    { 241758, 2, { 594, 407 } },
    { 241776, 2, { 552, 438 } },
    { 241800, 2, { 520, 465 } },
    { 241815, 2, { 705, 343 } },
    { 241860, 2, { 556, 435 } },
    { 241875, 2, { 625, 387 } },
    { 241893, 2, { 527, 459 } },
    { 241920, 2, { 504, 480 } },
    { 241956, 2, { 517, 468 } },
    { 241980, 2, { 545, 444 } },
    { 242000, 2, { 500, 484 } },
    { 242004, 2, { 516, 469 } },
    { 242060, 2, { 494, 490 } },
    { 242080, 2, { 544, 445 } },
    { 242112, 2, { 582, 416 } },
    { 242121, 2, { 667, 363 } },
    { 242136, 2, { 513, 472 } },
    { 242165, 2, { 595, 407 } },
    { 242176, 2, { 512, 473 } },
    { 242208, 2, { 522, 464 } },
    { 242250, 2, { 510, 475 } },
    { 242316, 2, { 508, 477 } },
    { 242352, 2, { 528, 459 } },
    { 242360, 2, { 584, 415 } },
    { 242400, 2, { 505, 480 } },
    { 242420, 2, { 527, 460 } },
    { 242424, 2, { 504, 481 } },
    { 242440, 2, { 551, 440 } },
    { 242484, 2, { 501, 484 } },
    { 242515, 2, { 533, 455 } },
    { 242520, 2, { 516, 470 } },
    { 242536, 2, { 497, 488 } },
    { 242544, 2, { 496, 489 } },
    { 242606, 2, { 559, 434 } },
    { 242649, 2, { 513, 473 } },
    { 242676, 2, { 567, 428 } },
    { 242688, 2, { 512, 474 } },
    { 242720, 2, { 592, 410 } },
    { 242724, 2, { 537, 452 } },
    { 242725, 2, { 511, 475 } },
    { 242730, 2, { 522, 465 } },
    { 242775, 2, { 585, 415 } },
    { 242808, 2, { 536, 453 } },
    { 242811, 2, { 529, 459 } },
    { 242844, 2, { 588, 413 } },
    { 242880, 2, { 506, 480 } },
    { 242892, 2, { 519, 468 } },
    { 242952, 2, { 573, 424 } },
    { 242970, 2, { 534, 455 } },
    { 242991, 2, { 551, 441 } },
    { 243000, 2, { 500, 486 } },
    { 243024, 2, { 498, 488 } },
    { 243036, 2, { 516, 471 } },
    { 243040, 2, { 496, 490 } },
    { 243080, 2, { 515, 472 } },
    { 243089, 2, { 539, 451 } },
    { 243100, 2, { 550, 442 } },
    { 243165, 2, { 559, 435 } },
    { 243168, 2, { 544, 447 } },
    { 243180, 2, { 579, 420 } },
    { 243200, 2, { 512, 475 } },
    { 243210, 2, { 605, 402 } },
    { 243225, 2, { 575, 423 } },
    { 243243, 2, { 567, 429 } },
    { 243264, 2, { 543, 448 } },
    { 243320, 2, { 553, 440 } },
    { 243360, 2, { 507, 480 } },
    { 243375, 2, { 649, 375 } },
    { 243386, 2, { 506, 481 } },
    { 243390, 2, { 570, 427 } },
    { 243432, 2, { 504, 483 } },
    { 243474, 2, { 527, 462 } },
    { 243492, 2, { 591, 412 } },
    { 243504, 2, { 534, 456 } },
    { 243530, 2, { 497, 490 } },
    { 243540, 2, { 495, 492 } },
    { 243542, 2, { 494, 493 } },
    { 243576, 2, { 597, 408 } },
    { 243600, 2, { 525, 464 } },
    { 243612, 2, { 603, 404 } },
    { 243648, 2, { 564, 432 } },
    { 243660, 2, { 524, 465 } },
    { 243672, 2, { 568, 429 } },
    { 243675, 2, { 513, 475 } },
    { 243712, 2, { 512, 476 } },
    { 243747, 2, { 511, 477 } },
    { 243750, 2, { 625, 390 } },
    { 243756, 2, { 549, 444 } },
    { 243789, 2, { 611, 399 } },
    { 243810, 2, { 567, 430 } },
    { 243815, 2, { 605, 403 } },
    { 243873, 2, { 553, 441 } },
    { 243880, 2, { 520, 469 } },
    { 243936, 2, { 504, 484 } },
    { 243950, 2, { 574, 425 } },
    { 243960, 2, { 535, 456 } },
    { 244032, 2, { 496, 492 } },
    { 244035, 2, { 495, 493 } },
    { 244110, 2, { 515, 474 } },
    { 244160, 2, { 545, 448 } },
    { 244188, 2, { 513, 476 } },
    { 244200, 2, { 550, 444 } },
    { 244205, 2, { 845, 289 } },
    { 244216, 2, { 623, 392 } },
    { 244224, 2, { 512, 477 } },
    { 244260, 2, { 531, 460 } },
    { 244305, 2, { 549, 445 } },
    { 244440, 2, { 504, 485 } },
    { 244488, 2, { 501, 488 } },
    { 244500, 2, { 500, 489 } },
    { 244524, 2, { 497, 492 } },
    { 244530, 2, { 495, 494 } },
    { 244559, 2, { 713, 343 } },
    { 244596, 2, { 561, 436 } },
    { 244608, 2, { 546, 448 } },
    { 244620, 2, { 540, 453 } },
    { 244647, 2, { 533, 459 } },
    { 244783, 2, { 847, 289 } },
    { 244800, 2, { 510, 480 } },
    { 244818, 2, { 522, 469 } },
    { 244872, 2, { 537, 456 } },
    { 244920, 2, { 520, 471 } },
    { 244944, 2, { 504, 486 } },
    { 244950, 2, { 575, 426 } },
    { 244956, 2, { 548, 447 } },
    { 244968, 2, { 519, 472 } },
    { 245000, 2, { 500, 490 } },
    { 245014, 2, { 518, 473 } },
    { 245050, 2, { 650, 377 } },
    { 245100, 2, { 516, 475 } },
    { 245157, 2, { 561, 437 } },
    { 245180, 2, { 533, 460 } },
    { 245196, 2, { 556, 441 } },
    { 245244, 2, { 573, 428 } },
    { 245250, 2, { 545, 450 } },
    { 245280, 2, { 511, 480 } },
    { 245295, 2, { 621, 395 } },
    { 245310, 2, { 510, 481 } },
    { 245340, 2, { 522, 470 } },
    { 245344, 2, { 544, 451 } },
    { 245364, 2, { 508, 483 } },
    { 245388, 2, { 507, 484 } },
    { 245427, 2, { 609, 403 } },
    { 245430, 2, { 505, 486 } },
    { 245436, 2, { 543, 452 } },
    { 245496, 2, { 579, 424 } },
    { 245520, 2, { 496, 495 } },
    { 245525, 2, { 575, 427 } },
    { 245565, 2, { 535, 459 } },
    { 245575, 2, { 517, 475 } },
    { 245655, 2, { 515, 477 } },
    { 245680, 2, { 592, 415 } },
    { 245700, 2, { 525, 468 } },
    { 245745, 2, { 635, 387 } },
    { 245760, 2, { 512, 480 } },
    { 245763, 2, { 581, 423 } },
    { 245856, 2, { 591, 416 } },
    { 245916, 2, { 506, 486 } },
    { 245920, 2, { 530, 464 } },
    { 245960, 2, { 520, 473 } },
    { 245964, 2, { 597, 412 } },
    { 246015, 2, { 497, 495 } },
    { 246024, 2, { 536, 459 } },
    { 246050, 2, { 518, 475 } },
    { 246092, 2, { 517, 476 } },
    { 246132, 2, { 516, 477 } },
    { 246202, 2, { 589, 418 } },
    { 246225, 2, { 525, 469 } },
    { 246240, 2, { 513, 480 } },
    { 246246, 2, { 533, 462 } },
    { 246272, 2, { 512, 481 } },
    { 246330, 2, { 510, 483 } },
    { 246344, 2, { 581, 424 } },
    { 246384, 2, { 522, 472 } },
    { 246400, 2, { 550, 448 } },
    { 246402, 2, { 507, 486 } },
    { 246420, 2, { 555, 444 } },
    { 246432, 2, { 544, 453 } },
    { 246440, 2, { 505, 488 } },
    { 246456, 2, { 504, 489 } },
    { 246480, 2, { 520, 474 } },
    { 246492, 2, { 501, 492 } },
    { 246500, 2, { 500, 493 } },
    { 246512, 2, { 497, 496 } },
    { 246519, 2, { 559, 441 } },
    { 246636, 2, { 527, 468 } },
    { 246645, 2, { 567, 435 } },
    { 246744, 2, { 552, 447 } },
    { 246753, 2, { 513, 481 } },
    { 246768, 2, { 582, 424 } },
    { 246804, 2, { 524, 471 } },
    { 246906, 2, { 522, 473 } },
    { 246925, 2, { 581, 425 } },
    { 246960, 2, { 504, 490 } },
    { 247000, 2, { 500, 494 } },
    { 247008, 2, { 498, 496 } },
    { 247020, 2, { 537, 460 } },
    { 247044, 2, { 519, 476 } },
    { 247080, 2, { 568, 435 } },
    { 247095, 2, { 765, 323 } },
    { 247104, 2, { 528, 468 } },
    { 247170, 2, { 535, 462 } },
    { 247200, 2, { 515, 480 } },
    { 247212, 2, { 567, 436 } },
    { 247225, 2, { 725, 341 } },
    { 247247, 2, { 1001, 247 } },
    { 247248, 2, { 606, 408 } },
    { 247296, 2, { 512, 483 } },
    { 247312, 2, { 533, 464 } },
    { 247350, 2, { 510, 485 } },
    { 247380, 2, { 532, 465 } },
    { 247401, 2, { 539, 459 } },
    { 247416, 2, { 507, 488 } },
    { 247470, 2, { 565, 438 } },
    { 247500, 2, { 500, 495 } },
    { 247520, 2, { 520, 476 } },
    { 247536, 2, { 573, 432 } },
    { 247572, 2, { 529, 468 } },
    { 247608, 2, { 543, 456 } },
    { 247632, 2, { 528, 469 } },
    { 247646, 2, { 686, 361 } },
    { 247650, 2, { 635, 390 } },
    { 247660, 2, { 580, 427 } },
    { 247680, 2, { 516, 480 } },
    { 247744, 2, { 553, 448 } },
    { 247775, 2, { 583, 425 } },
    { 247776, 2, { 534, 464 } },
    { 247779, 2, { 513, 483 } },
    { 247800, 2, { 525, 472 } },
    { 247808, 2, { 512, 484 } },
    { 247812, 2, { 579, 428 } },
    { 247845, 2, { 533, 465 } },
    { 247860, 2, { 510, 486 } },
    { 247863, 2, { 609, 407 } },
    { 247940, 2, { 506, 490 } },
    { 247950, 2, { 522, 475 } },
    { 248040, 2, { 520, 477 } },
    { 248050, 2, { 550, 451 } },
    { 248064, 2, { 544, 456 } },
    { 248066, 2, { 611, 406 } },
    { 248148, 2, { 549, 452 } },
    { 248157, 2, { 707, 351 } },
    { 248160, 2, { 517, 480 } },
    { 248200, 2, { 584, 425 } },
    { 248220, 2, { 591, 420 } },
    { 248240, 2, { 535, 464 } },
    { 248244, 2, { 548, 453 } },
    { 248292, 2, { 513, 484 } },
    { 248320, 2, { 512, 485 } },
    { 248325, 2, { 525, 473 } },
    { 248346, 2, { 511, 486 } },
    { 248352, 2, { 597, 416 } },
    { 248400, 2, { 540, 460 } },
    { 248412, 2, { 508, 489 } },
    { 248430, 2, { 507, 490 } },
    { 248436, 2, { 603, 412 } },
    { 248460, 2, { 505, 492 } },
    { 248472, 2, { 504, 493 } },
    { 248496, 2, { 501, 496 } },
    { 248500, 2, { 500, 497 } },
    { 248508, 2, { 531, 468 } },
    { 248520, 2, { 545, 456 } },
    { 248532, 2, { 556, 447 } },
    { 248570, 2, { 530, 469 } },
    { 248589, 2, { 729, 341 } },
    { 248625, 2, { 585, 425 } },
    { 248640, 2, { 518, 480 } },
    { 248675, 2, { 725, 343 } },
    { 248688, 2, { 528, 471 } },
    { 248710, 2, { 595, 418 } },
    { 248724, 2, { 564, 441 } },
    { 248768, 2, { 598, 416 } },
    { 248784, 2, { 568, 438 } },
    { 248805, 2, { 513, 485 } },
    { 248820, 2, { 572, 435 } },
    { 248829, 2, { 697, 357 } },
    { 248832, 2, { 512, 486 } },
    { 248880, 2, { 510, 488 } },
    { 248976, 2, { 504, 494 } },
    { 249039, 2, { 531, 469 } },
    { 249067, 2, { 637, 391 } },
    { 249075, 2, { 615, 405 } },
    { 249084, 2, { 561, 444 } },
    { 249090, 2, { 570, 437 } },
    { 249120, 2, { 519, 480 } },
    { 249165, 2, { 565, 441 } },
    { 249168, 2, { 537, 464 } },
    { 249200, 2, { 560, 445 } },
    { 249228, 2, { 516, 483 } },
    { 249240, 2, { 536, 465 } },
    { 249275, 2, { 767, 325 } },
    { 249280, 2, { 608, 410 } },
    { 249368, 2, { 511, 488 } },
    { 249417, 2, { 749, 333 } },
    { 249444, 2, { 507, 492 } },
    { 249458, 2, { 506, 493 } },
    { 249480, 2, { 504, 495 } },
    { 249550, 2, { 575, 434 } },
    { 249600, 2, { 520, 480 } },
    { 249612, 2, { 671, 372 } },
    { 249690, 2, { 574, 435 } },
    { 249696, 2, { 544, 459 } },
    { 249704, 2, { 637, 392 } },
    { 249711, 2, { 517, 483 } },
    { 249750, 2, { 555, 450 } },
    { 249780, 2, { 543, 460 } },
    { 249795, 2, { 549, 455 } },
    { 249828, 2, { 573, 436 } },
    { 249830, 2, { 581, 430 } },
    { 249948, 2, { 524, 477 } },
    { 249951, 2, { 507, 493 } },
    { 249975, 2, { 505, 495 } },
    { 250056, 2, { 552, 453 } },
    { 250096, 2, { 539, 464 } },
    { 250120, 2, { 520, 481 } },
    { 250128, 2, { 579, 432 } },
    { 250155, 2, { 545, 459 } },
    { 250240, 2, { 544, 460 } },
    { 250245, 2, { 603, 415 } },
    { 250250, 2, { 550, 455 } },
    { 250260, 2, { 516, 485 } },
    { 250263, 2, { 621, 403 } },
    { 250272, 2, { 528, 474 } },
    { 250290, 2, { 515, 486 } },
    { 250305, 2, { 555, 451 } },
    { 250320, 2, { 560, 447 } },
    { 250325, 2, { 527, 475 } },
    { 250344, 2, { 513, 488 } },
    { 250368, 2, { 512, 489 } },
    { 250380, 2, { 535, 468 } },
    { 250390, 2, { 511, 490 } },
    { 250432, 2, { 559, 448 } },
    { 250470, 2, { 506, 495 } },
    { 250480, 2, { 505, 496 } },
    { 250488, 2, { 504, 497 } },
    { 250500, 2, { 501, 500 } },
    { 250551, 2, { 679, 369 } },
    { 250560, 2, { 522, 480 } },
    { 250572, 2, { 532, 471 } },
    { 250584, 2, { 591, 424 } },
    { 250632, 2, { 531, 472 } },
    { 250635, 2, { 539, 465 } },
    { 250705, 2, { 551, 455 } },
    { 250733, 2, { 731, 343 } },
    { 250740, 2, { 597, 420 } },
    { 250800, 2, { 528, 475 } },
    { 250852, 2, { 527, 476 } },
    { 250860, 2, { 555, 452 } },
    { 250880, 2, { 512, 490 } },
    { 250908, 2, { 609, 412 } },
    { 250965, 2, { 507, 495 } },
    { 250971, 2, { 629, 399 } },
    { 250992, 2, { 504, 498 } },
    { 251076, 2, { 588, 427 } },
    { 251082, 2, { 522, 481 } },
    { 251100, 2, { 540, 465 } },
    { 251125, 2, { 875, 287 } },
    { 251160, 2, { 520, 483 } },
    { 251196, 2, { 519, 484 } },
    { 251250, 2, { 625, 402 } },
    { 251256, 2, { 551, 456 } },
    { 251262, 2, { 517, 486 } },
    { 251275, 2, { 529, 475 } },
    { 251316, 2, { 537, 468 } },
    { 251320, 2, { 515, 488 } },
    { 251328, 2, { 528, 476 } },
    { 251370, 2, { 513, 490 } },
    { 251412, 2, { 511, 492 } },
    { 251424, 2, { 582, 432 } },
    { 251430, 2, { 510, 493 } },
    { 251460, 2, { 508, 495 } },
    { 251472, 2, { 507, 496 } },
    { 251490, 2, { 505, 498 } },
    { 251532, 2, { 548, 459 } },
    { 251550, 2, { 559, 450 } },
    { 251600, 2, { 592, 425 } },
    { 251625, 2, { 671, 375 } },
    { 251636, 2, { 532, 473 } },
    { 251658, 2, { 558, 451 } },
    { 251685, 2, { 595, 423 } },
    { 251720, 2, { 580, 434 } },
    { 251748, 2, { 518, 486 } },
    { 251790, 2, { 545, 462 } },
    { 251804, 2, { 529, 476 } },
    { 251850, 2, { 575, 438 } },
    { 251856, 2, { 528, 477 } },
    { 251868, 2, { 556, 453 } },
    { 251875, 2, { 625, 403 } },
    { 251904, 2, { 512, 492 } },
    { 251930, 2, { 590, 427 } },
    { 251940, 2, { 510, 494 } },
    { 251952, 2, { 543, 464 } },
    { 252000, 2, { 504, 500 } },
    { 252048, 2, { 534, 472 } },
    { 252096, 2, { 606, 416 } },
    { 252108, 2, { 564, 447 } },
    { 252120, 2, { 573, 440 } },
    { 252200, 2, { 520, 485 } },
    { 252225, 2, { 531, 475 } },
    { 252252, 2, { 539, 468 } },
    { 252288, 2, { 576, 438 } },
    { 252315, 2, { 567, 445 } },
    { 252320, 2, { 608, 415 } },
    { 252324, 2, { 516, 489 } },
    { 252340, 2, { 620, 407 } },
    { 252396, 2, { 513, 492 } },
    { 252405, 2, { 639, 395 } },
    { 252416, 2, { 512, 493 } },
    { 252444, 2, { 579, 436 } },
    { 252456, 2, { 536, 471 } },
    { 252504, 2, { 504, 501 } },
    { 252520, 2, { 535, 472 } },
    { 252525, 2, { 525, 481 } },
    { 252540, 2, { 549, 460 } },
    { 252560, 2, { 560, 451 } },
    { 252586, 2, { 578, 437 } },
    { 252672, 2, { 564, 448 } },
    { 252681, 2, { 589, 429 } },
    { 252720, 2, { 520, 486 } },
    { 252735, 2, { 581, 435 } },
    { 252747, 2, { 621, 407 } },
    { 252756, 2, { 531, 476 } },
    { 252760, 2, { 568, 445 } },
    { 252824, 2, { 572, 442 } },
    { 252840, 2, { 516, 490 } },
    { 252880, 2, { 545, 464 } },
    { 252909, 2, { 513, 493 } },
    { 252928, 2, { 512, 494 } },
    { 252945, 2, { 511, 495 } },
    { 252948, 2, { 591, 428 } },
    { 252960, 2, { 510, 496 } },
    { 253000, 2, { 506, 500 } },
    { 253022, 2, { 583, 434 } },
    { 253071, 2, { 721, 351 } },
    { 253080, 2, { 555, 456 } },
    { 253092, 2, { 524, 483 } },
    { 253125, 2, { 625, 405 } },
    { 253128, 2, { 597, 424 } },
    { 253170, 2, { 522, 485 } },
    { 253175, 2, { 533, 475 } },
    { 253253, 2, { 847, 299 } },
    { 253260, 2, { 540, 469 } },
    { 253272, 2, { 519, 488 } },
    { 253330, 2, { 517, 490 } },
    { 253344, 2, { 546, 464 } },
    { 253368, 2, { 552, 459 } },
    { 253380, 2, { 515, 492 } },
    { 253440, 2, { 512, 495 } },
    { 253456, 2, { 511, 496 } },
    { 253460, 2, { 551, 460 } },
    { 253464, 2, { 537, 472 } },
    { 253470, 2, { 510, 497 } },
    { 253500, 2, { 507, 500 } },
    { 253572, 2, { 561, 452 } },
    { 253575, 2, { 525, 483 } },
    { 253590, 2, { 535, 474 } },
    { 253605, 2, { 583, 435 } },
    { 253650, 2, { 534, 475 } },
    { 253680, 2, { 560, 453 } },
    { 253708, 2, { 533, 476 } },
    { 253750, 2, { 625, 406 } },
    { 253764, 2, { 532, 477 } },
    { 253800, 2, { 540, 470 } },
    { 253827, 2, { 553, 459 } },
    { 253896, 2, { 568, 447 } },
    { 253920, 2, { 529, 480 } },
    { 253968, 2, { 528, 481 } },
    { 253995, 2, { 615, 413 } },
    { 254064, 2, { 536, 474 } },
    { 254079, 2, { 763, 333 } },
    { 254100, 2, { 525, 484 } },
    { 254124, 2, { 543, 468 } },
    { 254176, 2, { 611, 416 } },
    { 254250, 2, { 565, 450 } },
    { 254265, 2, { 737, 345 } },
    { 254280, 2, { 520, 489 } },
    { 254320, 2, { 578, 440 } },
    { 254340, 2, { 540, 471 } },
    { 254345, 2, { 559, 455 } },
    { 254364, 2, { 517, 492 } },
    { 254375, 2, { 625, 407 } },
    { 254380, 2, { 553, 460 } },
    { 254400, 2, { 530, 480 } },
    { 254408, 2, { 539, 472 } },
    { 254412, 2, { 573, 444 } },
    { 254448, 2, { 513, 496 } },
    { 254464, 2, { 512, 497 } },
    { 254508, 2, { 508, 501 } },
    { 254520, 2, { 505, 504 } },
    { 254541, 2, { 527, 483 } },
    { 254560, 2, { 592, 430 } },
    { 254562, 2, { 551, 462 } },
    { 254592, 2, { 544, 468 } },
    { 254600, 2, { 536, 475 } },
    { 254610, 2, { 615, 414 } },
    { 254736, 2, { 522, 488 } },
    { 254745, 2, { 555, 459 } },
    { 254760, 2, { 579, 440 } },
    { 254820, 2, { 548, 465 } },
    { 254826, 2, { 594, 429 } },
    { 254880, 2, { 531, 480 } },
    { 254898, 2, { 578, 441 } },
    { 254925, 2, { 515, 495 } },
    { 254947, 2, { 539, 473 } },
    { 254961, 2, { 513, 497 } },
    { 254975, 2, { 775, 329 } },
    { 254976, 2, { 512, 498 } },
    { 255024, 2, { 506, 504 } },
    { 255060, 2, { 545, 468 } },
    { 255068, 2, { 527, 484 } },
    { 255150, 2, { 525, 486 } },
    { 255195, 2, { 535, 477 } },
    { 255200, 2, { 550, 464 } },
    { 255204, 2, { 556, 459 } },
    { 255255, 2, { 561, 455 } },
    { 255270, 2, { 635, 402 } },
    { 255300, 2, { 555, 460 } },
    { 255312, 2, { 591, 432 } },
    { 255348, 2, { 519, 492 } },
    { 255360, 2, { 532, 480 } },
    { 255420, 2, { 516, 495 } },
    { 255440, 2, { 515, 496 } },
    { 255492, 2, { 564, 453 } },
    { 255500, 2, { 511, 500 } },
    { 255516, 2, { 597, 428 } },
    { 255528, 2, { 507, 504 } },
    { 255600, 2, { 568, 450 } },
    { 255612, 2, { 537, 476 } },
    { 255640, 2, { 581, 440 } },
    { 255645, 2, { 585, 437 } },
    { 255672, 2, { 536, 477 } },
    { 255680, 2, { 544, 470 } },
    { 255684, 2, { 572, 447 } },
    { 255717, 2, { 567, 451 } },
    { 255744, 2, { 576, 444 } },
    { 255780, 2, { 522, 490 } },
    { 255816, 2, { 561, 456 } },
    { 255915, 2, { 517, 495 } },
    { 255936, 2, { 516, 496 } },
    { 256000, 2, { 512, 500 } },
    { 256025, 2, { 539, 475 } },
    { 256080, 2, { 528, 485 } },
    { 256122, 2, { 527, 486 } },
    { 256200, 2, { 525, 488 } },
    { 256221, 2, { 581, 441 } },
    { 256224, 2, { 544, 471 } },
    { 256236, 2, { 524, 489 } },
    { 256256, 2, { 572, 448 } },
    { 256275, 2, { 603, 425 } },
    { 256284, 2, { 567, 452 } },
    { 256296, 2, { 543, 472 } },
    { 256320, 2, { 534, 480 } },
    { 256360, 2, { 520, 493 } },
    { 256410, 2, { 518, 495 } },
    { 256432, 2, { 517, 496 } },
    { 256452, 2, { 516, 497 } },
    { 256470, 2, { 515, 498 } },
    { 256500, 2, { 513, 500 } },
    { 256512, 2, { 512, 501 } },
    { 256581, 2, { 559, 459 } },
    { 256592, 2, { 553, 464 } },
    { 256608, 2, { 528, 486 } },
    { 256680, 2, { 552, 465 } },
    { 256704, 2, { 573, 448 } },
    { 256711, 2, { 637, 403 } },
    { 256795, 2, { 667, 385 } },
    { 256800, 2, { 535, 480 } },
    { 256880, 2, { 520, 494 } },
    { 256928, 2, { 518, 496 } },
    { 256932, 2, { 549, 468 } },
    { 256944, 2, { 606, 424 } },
    { 256956, 2, { 532, 483 } },
    { 257004, 2, { 531, 484 } },
    { 257040, 2, { 510, 504 } },
    { 257070, 2, { 570, 451 } },
    { 257076, 2, { 579, 444 } },
    { 257088, 2, { 618, 416 } },
    { 257094, 2, { 529, 486 } },
    { 257103, 2, { 539, 477 } },
    { 257114, 2, { 638, 403 } },
    { 257140, 2, { 559, 460 } },
    { 257145, 2, { 553, 465 } },
    { 257152, 2, { 574, 448 } },
    { 257175, 2, { 635, 405 } },
    { 257240, 2, { 545, 472 } },
    { 257304, 2, { 568, 453 } },
    { 257312, 2, { 544, 473 } },
    { 257400, 2, { 520, 495 } },
    { 257424, 2, { 519, 496 } },
    { 257439, 2, { 533, 483 } },
    { 257472, 2, { 576, 447 } },
    { 257481, 2, { 549, 469 } },
    { 257520, 2, { 555, 464 } },
    { 257535, 2, { 531, 485 } },
    { 257544, 2, { 511, 504 } },
    { 257550, 2, { 510, 505 } },
    { 257556, 2, { 508, 507 } },
    { 257580, 2, { 530, 486 } },
    { 257640, 2, { 565, 456 } },
    { 257676, 2, { 591, 436 } },
    { 257712, 2, { 546, 472 } },
    { 257715, 2, { 621, 415 } },
    { 257725, 2, { 793, 325 } },
    { 257730, 2, { 605, 426 } },
    { 257760, 2, { 537, 480 } },
    { 257856, 2, { 544, 474 } },
    { 257904, 2, { 597, 432 } },
    { 257950, 2, { 550, 469 } },
    { 257972, 2, { 533, 484 } },
    { 257985, 2, { 567, 455 } },
    { 258048, 2, { 512, 504 } },
    { 258060, 2, { 510, 506 } },
    { 258084, 2, { 603, 428 } },
    { 258108, 2, { 548, 471 } },
    { 258115, 2, { 715, 361 } },
    { 258125, 2, { 625, 413 } },
    { 258192, 2, { 528, 489 } },
    { 258216, 2, { 609, 424 } },
    { 258230, 2, { 527, 490 } },
    { 258258, 2, { 546, 473 } },
    { 258300, 2, { 525, 492 } },
    { 258330, 2, { 545, 474 } },
    { 258375, 2, { 689, 375 } },
    { 258400, 2, { 544, 475 } },
    { 258440, 2, { 520, 497 } },
    { 258468, 2, { 543, 476 } },
    { 258500, 2, { 517, 500 } },
    { 258516, 2, { 516, 501 } },
    { 258540, 2, { 556, 465 } },
    { 258552, 2, { 513, 504 } },
    { 258560, 2, { 512, 505 } },
    { 258720, 2, { 528, 490 } },
    { 258750, 2, { 575, 450 } },
    { 258819, 2, { 713, 363 } },
    { 258825, 2, { 525, 493 } },
    { 258852, 2, { 583, 444 } },
    { 258876, 2, { 564, 459 } },
    { 258888, 2, { 536, 483 } },
    { 258912, 2, { 522, 496 } },
    { 258960, 2, { 520, 498 } },
    { 258990, 2, { 534, 485 } },
    { 258996, 2, { 573, 452 } },
    { 259000, 2, { 518, 500 } },
    { 259038, 2, { 533, 486 } },
    { 259065, 2, { 513, 505 } },
    { 259072, 2, { 512, 506 } },
    { 259116, 2, { 572, 453 } },
    { 259128, 2, { 531, 488 } },
    { 259160, 2, { 589, 440 } },
    { 259168, 2, { 623, 416 } },
    { 259182, 2, { 561, 462 } },
    { 259200, 2, { 540, 480 } },
    { 259210, 2, { 529, 490 } },
    { 259233, 2, { 663, 391 } },
    { 259259, 2, { 539, 481 } },
    { 259260, 2, { 580, 447 } },
    { 259325, 2, { 575, 451 } },
    { 259335, 2, { 565, 459 } },
    { 259350, 2, { 525, 494 } },
    { 259376, 2, { 559, 464 } },
    { 259380, 2, { 524, 495 } },
    { 259392, 2, { 579, 448 } },
    { 259434, 2, { 522, 497 } },
    { 259440, 2, { 552, 470 } },
    { 259488, 2, { 544, 477 } },
    { 259500, 2, { 519, 500 } },
    { 259515, 2, { 657, 395 } },
    { 259560, 2, { 515, 504 } },
    { 259578, 2, { 513, 506 } },
    { 259584, 2, { 512, 507 } },
    { 259675, 2, { 611, 425 } },
    { 259740, 2, { 540, 481 } },
    { 259749, 2, { 589, 441 } },
    { 259776, 2, { 528, 492 } },
    { 259880, 2, { 584, 445 } },
    { 259908, 2, { 537, 484 } },
    { 259910, 2, { 553, 470 } },
    { 259920, 2, { 570, 456 } },
    { 259935, 2, { 559, 465 } },
    { 259960, 2, { 536, 485 } },
    { 259965, 2, { 545, 477 } },
    { 259992, 2, { 552, 471 } },
    { 260010, 2, { 535, 486 } },
    { 260015, 2, { 595, 437 } },
    { 260040, 2, { 591, 440 } },
    { 260148, 2, { 532, 489 } },
    { 260150, 2, { 550, 473 } },
    { 260288, 2, { 581, 448 } },
    { 260292, 2, { 597, 436 } },
    { 260295, 2, { 555, 469 } },
    { 260304, 2, { 528, 493 } },
    { 260325, 2, { 585, 445 } },
    { 260338, 2, { 527, 494 } },
    { 260400, 2, { 525, 496 } },
    { 260406, 2, { 629, 414 } },
    { 260496, 2, { 536, 486 } },
    { 260520, 2, { 520, 501 } },
    { 260568, 2, { 517, 504 } },
    { 260580, 2, { 516, 505 } },
    { 260592, 2, { 534, 488 } },
    { 260604, 2, { 513, 508 } },
    { 260610, 2, { 511, 510 } },
    { 260640, 2, { 543, 480 } },
    { 260652, 2, { 609, 428 } },
    { 260712, 2, { 568, 459 } },
    { 260736, 2, { 582, 448 } },
    { 260760, 2, { 530, 492 } },
    { 260775, 2, { 549, 475 } },
    { 260820, 2, { 540, 483 } },
    { 260832, 2, { 528, 494 } },
    { 260865, 2, { 527, 495 } },
    { 260883, 2, { 707, 369 } },
    { 260925, 2, { 525, 497 } },
    { 260928, 2, { 576, 453 } },
    { 260967, 2, { 731, 357 } },
    { 261016, 2, { 553, 472 } },
    { 261030, 2, { 565, 462 } },
    { 261048, 2, { 584, 447 } },
    { 261072, 2, { 518, 504 } },
    { 261080, 2, { 535, 488 } },
    { 261120, 2, { 512, 510 } },
    { 261170, 2, { 533, 490 } },
    { 261184, 2, { 583, 448 } },
    { 261225, 2, { 645, 405 } },
    { 261252, 2, { 531, 492 } },
    { 261288, 2, { 573, 456 } },
    { 261324, 2, { 549, 476 } },
    { 261326, 2, { 529, 494 } },
    { 261360, 2, { 528, 495 } },
    { 261396, 2, { 548, 477 } },
    { 261440, 2, { 608, 430 } },
    { 261555, 2, { 705, 371 } },
    { 261576, 2, { 519, 504 } },
    { 261580, 2, { 580, 451 } },
    { 261600, 2, { 545, 480 } },
    { 261612, 2, { 516, 507 } },
    { 261632, 2, { 512, 511 } },
    { 261648, 2, { 552, 474 } },
    { 261664, 2, { 544, 481 } },
    { 261696, 2, { 564, 464 } },
    { 261702, 2, { 558, 469 } },
    { 261708, 2, { 579, 452 } },
    { 261725, 2, { 551, 475 } },
    { 261792, 2, { 606, 432 } },
    { 261800, 2, { 550, 476 } },
    { 261855, 2, { 529, 495 } },
    { 261870, 2, { 602, 435 } },
    { 261876, 2, { 556, 471 } },
    { 261900, 2, { 540, 485 } },
    { 261950, 2, { 650, 403 } },
    { 261954, 2, { 539, 486 } },
    { 261960, 2, { 555, 472 } },
    { 262032, 2, { 618, 424 } },
    { 262056, 2, { 537, 488 } },
    { 262080, 2, { 520, 504 } },
    { 262104, 2, { 536, 489 } },
    { 262143, 2, { 513, 511 } },
    { 262160, 2, { 565, 464 } },
    { 262200, 2, { 552, 475 } },
    { 262260, 2, { 558, 470 } },
    { 262276, 2, { 532, 493 } },
    { 262280, 2, { 632, 415 } },
    { 262395, 2, { 595, 441 } },
    { 262400, 2, { 640, 410 } },
    { 262404, 2, { 591, 444 } },
    { 262416, 2, { 528, 497 } },
    { 262500, 2, { 525, 500 } },
    { 262515, 2, { 555, 473 } },
    { 262524, 2, { 524, 501 } },
    { 262548, 2, { 561, 468 } },
    { 262600, 2, { 520, 505 } },
    { 262605, 2, { 615, 427 } },
    { 262650, 2, { 515, 510 } },
    { 262656, 2, { 513, 512 } },
    { 262668, 2, { 636, 413 } },
    { 262675, 2, { 553, 475 } },
    { 262680, 2, { 597, 440 } },
    { 262740, 2, { 580, 453 } },
    { 262752, 2, { 544, 483 } },
    { 262773, 2, { 679, 387 } },
    { 262800, 2, { 584, 450 } },
    { 262812, 2, { 543, 484 } },
    { 262836, 2, { 588, 447 } },
    { 262880, 2, { 530, 496 } },
    { 262890, 2, { 635, 414 } },
    { 262899, 2, { 749, 351 } },
    { 262908, 2, { 603, 436 } },
    { 262922, 2, { 629, 418 } },
    { 262944, 2, { 528, 498 } },
    { 262990, 2, { 578, 455 } },
    { 263032, 2, { 539, 488 } },
    { 263088, 2, { 522, 504 } },
    { 263120, 2, { 520, 506 } },
    { 263200, 2, { 560, 470 } },
    { 263220, 2, { 535, 492 } },
    { 263304, 2, { 552, 477 } },
    { 263310, 2, { 655, 402 } },
    { 263340, 2, { 532, 495 } },
    { 263375, 2, { 875, 301 } },
    { 263376, 2, { 531, 496 } },
    { 263410, 2, { 530, 497 } },
    { 263424, 2, { 588, 448 } },
    { 263440, 2, { 592, 445 } },
    { 263466, 2, { 574, 459 } },
    { 263500, 2, { 527, 500 } },
    { 263529, 2, { 623, 423 } },
    { 263580, 2, { 573, 460 } },
    { 263610, 2, { 522, 505 } },
    { 263640, 2, { 520, 507 } },
    { 263652, 2, { 519, 508 } },
    { 263655, 2, { 567, 465 } },
    { 263670, 2, { 517, 510 } },
    { 263676, 2, { 516, 511 } },
    { 263680, 2, { 515, 512 } },
    { 263760, 2, { 560, 471 } },
    { 263781, 2, { 553, 477 } },
    { 263835, 2, { 533, 495 } },
    { 263840, 2, { 544, 485 } },
    { 263907, 2, { 531, 497 } },
    { 263925, 2, { 575, 459 } },
    { 263934, 2, { 558, 473 } },
    { 264000, 2, { 528, 500 } },
    { 264024, 2, { 579, 456 } },
    { 264040, 2, { 574, 460 } },
    { 264060, 2, { 540, 489 } },
    { 264110, 2, { 539, 490 } },
    { 264120, 2, { 568, 465 } },
    { 264152, 2, { 623, 424 } },
    { 264180, 2, { 518, 510 } },
    { 264192, 2, { 516, 512 } },
    { 264195, 2, { 515, 513 } },
    { 264204, 2, { 537, 492 } },
    { 264368, 2, { 533, 496 } },
    { 264375, 2, { 625, 423 } },
    { 264384, 2, { 544, 486 } },
    { 264385, 2, { 605, 437 } },
    { 264420, 2, { 565, 468 } },
    { 264480, 2, { 551, 480 } },
    { 264500, 2, { 529, 500 } },
    { 264516, 2, { 564, 469 } },
    { 264528, 2, { 528, 501 } },
    { 264550, 2, { 550, 481 } },
    { 264552, 2, { 584, 453 } },
    { 264600, 2, { 525, 504 } },
    { 264615, 2, { 767, 345 } },
    { 264624, 2, { 592, 447 } },
    { 264627, 2, { 729, 363 } },
    { 264684, 2, { 548, 483 } },
    { 264704, 2, { 517, 512 } },
    { 264708, 2, { 516, 513 } },
    { 264768, 2, { 591, 448 } },
    { 264792, 2, { 561, 472 } },
    { 264810, 2, { 546, 485 } },
    { 264825, 2, { 535, 495 } },
    { 264864, 2, { 534, 496 } },
    { 264870, 2, { 545, 486 } },
    { 264880, 2, { 560, 473 } },
    { 264957, 2, { 651, 407 } },
    { 264960, 2, { 552, 480 } },
    { 264984, 2, { 543, 488 } },
    { 264990, 2, { 605, 438 } },
    { 264992, 2, { 637, 416 } },
    { 265050, 2, { 558, 475 } },
    { 265068, 2, { 597, 444 } },
    { 265174, 2, { 611, 434 } },
    { 265185, 2, { 639, 415 } },
    { 265188, 2, { 539, 492 } },
    { 265200, 2, { 520, 510 } },
    { 265212, 2, { 556, 477 } },
    { 265216, 2, { 518, 512 } },
    { 265221, 2, { 517, 513 } },
    { 265265, 2, { 583, 455 } },
    { 265275, 2, { 655, 405 } },
    { 265320, 2, { 536, 495 } },
    { 265356, 2, { 546, 486 } },
    { 265360, 2, { 535, 496 } },
    { 265392, 2, { 582, 456 } },
    { 265440, 2, { 553, 480 } },
    { 265475, 2, { 925, 287 } },
    { 265500, 2, { 531, 500 } },
    { 265512, 2, { 552, 481 } },
    { 265524, 2, { 609, 436 } },
    { 265525, 2, { 559, 475 } },
    { 265600, 2, { 640, 415 } },
    { 265608, 2, { 527, 504 } },
    { 265644, 2, { 564, 471 } },
    { 265650, 2, { 525, 506 } },
    { 265668, 2, { 524, 507 } },
    { 265696, 2, { 608, 437 } },
    { 265716, 2, { 549, 484 } },
    { 265720, 2, { 520, 511 } },
    { 265727, 2, { 539, 493 } },
    { 265728, 2, { 519, 512 } },
    { 265734, 2, { 518, 513 } },
    { 265740, 2, { 516, 515 } },
    { 265785, 2, { 611, 435 } },
    { 265788, 2, { 621, 428 } },
    { 265825, 2, { 775, 343 } },
    { 265848, 2, { 583, 456 } },
    { 265872, 2, { 573, 464 } },
    { 265923, 2, { 567, 469 } },
    { 265960, 2, { 545, 488 } },
    { 265980, 2, { 572, 465 } },
    { 266000, 2, { 532, 500 } },
    { 266016, 2, { 544, 489 } },
    { 266049, 2, { 721, 369 } },
    { 266084, 2, { 559, 476 } },
    { 266133, 2, { 551, 483 } },
    { 266168, 2, { 679, 392 } },
    { 266175, 2, { 525, 507 } },
    { 266240, 2, { 520, 512 } },
    { 266250, 2, { 625, 426 } },
    { 266265, 2, { 549, 485 } },
    { 266266, 2, { 539, 494 } },
    { 266336, 2, { 574, 464 } },
    { 266340, 2, { 579, 460 } },
    { 266352, 2, { 537, 496 } },
    { 266364, 2, { 588, 453 } },
    { 266385, 2, { 645, 413 } },
    { 266392, 2, { 536, 497 } },
    { 266400, 2, { 555, 480 } },
    { 266430, 2, { 535, 498 } },
    { 266448, 2, { 546, 488 } },
    { 266490, 2, { 567, 470 } },
    { 266500, 2, { 533, 500 } },
    { 266532, 2, { 532, 501 } },
    { 266560, 2, { 544, 490 } },
    { 266616, 2, { 529, 504 } },
    { 266625, 2, { 675, 395 } },
    { 266640, 2, { 528, 505 } },
    { 266662, 2, { 527, 506 } },
    { 266679, 2, { 581, 459 } },
    { 266680, 2, { 565, 472 } },
    { 266684, 2, { 551, 484 } },
    { 266700, 2, { 525, 508 } },
    { 266742, 2, { 522, 511 } },
    { 266760, 2, { 520, 513 } },
    { 266772, 2, { 517, 516 } },
    { 266800, 2, { 575, 464 } },
    { 266805, 2, { 539, 495 } },
    { 266875, 2, { 625, 427 } },
    { 266910, 2, { 574, 465 } },
    { 266928, 2, { 536, 498 } },
    { 266976, 2, { 618, 432 } },
    { 266992, 2, { 592, 451 } },
    { 267003, 2, { 783, 341 } },
    { 267030, 2, { 621, 430 } },
    { 267036, 2, { 561, 476 } },
    { 267120, 2, { 530, 504 } },
    { 267132, 2, { 591, 452 } },
    { 267140, 2, { 703, 380 } },
    { 267156, 2, { 543, 492 } },
    { 267168, 2, { 528, 506 } },
    { 267189, 2, { 527, 507 } },
    { 267197, 2, { 779, 343 } },
    { 267260, 2, { 581, 460 } },
    { 267264, 2, { 522, 512 } },
    { 267300, 2, { 540, 495 } },
    { 267325, 2, { 629, 425 } },
    { 267330, 2, { 570, 469 } },
    { 267344, 2, { 539, 496 } },
    { 267410, 2, { 605, 442 } },
    { 267444, 2, { 612, 437 } },
    { 267456, 2, { 597, 448 } },
    { 267528, 2, { 568, 471 } },
    { 267624, 2, { 531, 504 } },
    { 267648, 2, { 544, 492 } },
    { 267696, 2, { 528, 507 } },
    { 267720, 2, { 552, 485 } },
    { 267732, 2, { 603, 444 } },
    { 267800, 2, { 520, 515 } },
    { 267804, 2, { 519, 516 } },
    { 267806, 2, { 518, 517 } },
    { 267810, 2, { 565, 474 } },
    { 267813, 2, { 763, 351 } },
    { 267840, 2, { 540, 496 } },
    { 267894, 2, { 594, 451 } },
    { 267900, 2, { 564, 475 } },
    { 267904, 2, { 598, 448 } },
    { 267912, 2, { 549, 488 } },
    { 267972, 2, { 548, 489 } },
    { 267995, 2, { 589, 455 } },
    { 268056, 2, { 584, 459 } },
    { 268125, 2, { 625, 429 } },
    { 268128, 2, { 532, 504 } },
    { 268140, 2, { 545, 492 } },
    { 268155, 2, { 531, 505 } },
    { 268164, 2, { 573, 468 } },
    { 268176, 2, { 592, 453 } },
    { 268191, 2, { 567, 473 } },
    { 268192, 2, { 544, 493 } },
    { 268203, 2, { 529, 507 } },
    { 268226, 2, { 686, 391 } },
    { 268272, 2, { 552, 486 } },
    { 268275, 2, { 525, 511 } },
    { 268335, 2, { 603, 445 } },
    { 268345, 2, { 595, 451 } },
    { 268356, 2, { 627, 428 } },
    { 268380, 2, { 540, 497 } },
    { 268392, 2, { 633, 424 } },
    { 268398, 2, { 558, 481 } },
    { 268500, 2, { 537, 500 } },
    { 268536, 2, { 536, 501 } },
    { 268548, 2, { 556, 483 } },
    { 268584, 2, { 589, 456 } },
    { 268600, 2, { 632, 425 } },
    { 268605, 2, { 635, 423 } },
    { 268620, 2, { 555, 484 } },
    { 268632, 2, { 533, 504 } },
    { 268656, 2, { 579, 464 } },
    { 268736, 2, { 544, 494 } },
    { 268758, 2, { 553, 486 } },
    { 268770, 2, { 527, 510 } },
    { 268800, 2, { 525, 512 } },
    { 268812, 2, { 524, 513 } },
    { 268830, 2, { 522, 515 } },
    { 268840, 2, { 520, 517 } },
    { 268975, 2, { 725, 371 } },
    { 269028, 2, { 564, 477 } },
    { 269040, 2, { 570, 472 } },
    { 269059, 2, { 833, 323 } },
    { 269100, 2, { 575, 468 } },
    { 269136, 2, { 534, 504 } },
    { 269178, 2, { 546, 493 } },
    { 269192, 2, { 532, 506 } },
    { 269232, 2, { 568, 474 } },
    { 269280, 2, { 528, 510 } },
    { 269325, 2, { 525, 513 } },
    { 269328, 2, { 543, 496 } },
    { 269346, 2, { 583, 462 } },
    { 269360, 2, { 520, 518 } },
    { 269412, 2, { 572, 471 } },
    { 269451, 2, { 611, 441 } },
    { 269496, 2, { 591, 456 } },
    { 269500, 2, { 539, 500 } },
    { 269505, 2, { 565, 477 } },
    { 269555, 2, { 715, 377 } },
    { 269568, 2, { 576, 468 } },
    { 269584, 2, { 581, 464 } },
    { 269610, 2, { 570, 473 } },
    { 269640, 2, { 535, 504 } },
    { 269670, 2, { 534, 505 } },
    { 269675, 2, { 575, 469 } },
    { 269696, 2, { 602, 448 } },
    { 269698, 2, { 533, 506 } },
    { 269700, 2, { 580, 465 } },
    { 269724, 2, { 532, 507 } },
    { 269730, 2, { 555, 486 } },
    { 269748, 2, { 531, 508 } },
    { 269775, 2, { 545, 495 } },
    { 269790, 2, { 529, 510 } },
    { 269800, 2, { 568, 475 } },
    { 269808, 2, { 528, 511 } },
    { 269824, 2, { 527, 512 } },
    { 269841, 2, { 561, 481 } },
    { 269844, 2, { 597, 452 } },
    { 269864, 2, { 553, 488 } },
    { 269874, 2, { 522, 517 } },
    { 269880, 2, { 520, 519 } },
    { 269892, 2, { 567, 476 } },
    { 269928, 2, { 552, 489 } },
    { 269988, 2, { 596, 453 } },
    { 269990, 2, { 551, 490 } },
    { 269997, 2, { 559, 483 } },
    { 270000, 2, { 540, 500 } },
    { 270048, 2, { 582, 464 } },
    { 270088, 2, { 637, 424 } },
    { 270108, 2, { 549, 492 } },
    { 270135, 2, { 621, 435 } },
    { 270165, 2, { 581, 465 } },
    { 270270, 2, { 546, 495 } },
    { 270320, 2, { 545, 496 } },
    { 270336, 2, { 528, 512 } },
    { 270351, 2, { 527, 513 } },
    { 270368, 2, { 544, 497 } },
    { 270396, 2, { 522, 518 } },
    { 270456, 2, { 573, 472 } },
    { 270480, 2, { 552, 490 } },
    { 270504, 2, { 578, 468 } },
    { 270510, 2, { 635, 426 } },
    { 270512, 2, { 583, 464 } },
    { 270540, 2, { 540, 501 } },
    { 270556, 2, { 559, 484 } },
    { 270560, 2, { 608, 445 } },
    { 270600, 2, { 550, 492 } },
    { 270630, 2, { 558, 485 } },
    { 270648, 2, { 537, 504 } },
    { 270655, 2, { 665, 407 } },
    { 270680, 2, { 536, 505 } },
    { 270720, 2, { 564, 480 } },
    { 270756, 2, { 621, 436 } },
    { 270816, 2, { 546, 496 } },
    { 270830, 2, { 530, 511 } },
    { 270840, 2, { 555, 488 } },
    { 270848, 2, { 529, 512 } },
    { 270864, 2, { 528, 513 } },
    { 270900, 2, { 525, 516 } },
    { 270912, 2, { 544, 498 } },
    { 270924, 2, { 633, 428 } },
    { 270936, 2, { 568, 477 } },
    { 270940, 2, { 589, 460 } },
    { 270970, 2, { 553, 490 } },
    { 270972, 2, { 579, 468 } },
    { 271040, 2, { 560, 484 } },
    { 271095, 2, { 583, 465 } },
    { 271150, 2, { 550, 493 } },
    { 271170, 2, { 655, 414 } },
    { 271200, 2, { 565, 480 } },
    { 271250, 2, { 625, 434 } },
    { 271260, 2, { 548, 495 } },
    { 271296, 2, { 576, 471 } },
    { 271320, 2, { 532, 510 } },
    { 271341, 2, { 531, 511 } },
    { 271360, 2, { 530, 512 } },
    { 271377, 2, { 529, 513 } },
    { 271400, 2, { 575, 472 } },
    { 271410, 2, { 545, 498 } },
    { 271425, 2, { 525, 517 } },
    { 271440, 2, { 522, 520 } },
    { 271488, 2, { 606, 448 } },
    { 271500, 2, { 543, 500 } },
    { 271502, 2, { 574, 473 } },
    { 271524, 2, { 561, 484 } },
    { 271560, 2, { 584, 465 } },
    { 271572, 2, { 636, 427 } },
    { 271575, 2, { 639, 425 } },
    { 271600, 2, { 560, 485 } },
    { 271656, 2, { 539, 504 } },
    { 271674, 2, { 559, 486 } },
    { 271700, 2, { 550, 494 } },
    { 271728, 2, { 592, 459 } },
    { 271752, 2, { 536, 507 } },
    { 271800, 2, { 600, 453 } },
    { 271830, 2, { 533, 510 } },
    { 271860, 2, { 591, 460 } },
    { 271872, 2, { 531, 512 } },
    { 271884, 2, { 556, 489 } },
    { 271890, 2, { 530, 513 } },
    { 271920, 2, { 528, 515 } },
    { 271950, 2, { 525, 518 } },
    { 271956, 2, { 524, 519 } },
    { 271975, 2, { 575, 473 } },
    { 272000, 2, { 544, 500 } },
    { 272020, 2, { 580, 469 } },
    { 272076, 2, { 553, 492 } },
    { 272090, 2, { 598, 455 } },
    { 272118, 2, { 589, 462 } },
    { 272136, 2, { 552, 493 } },
    { 272194, 2, { 551, 494 } },
    { 272232, 2, { 597, 456 } },
    { 272240, 2, { 656, 415 } },
    { 272304, 2, { 549, 496 } },
    { 272384, 2, { 532, 512 } },
    { 272412, 2, { 564, 483 } },
    { 272448, 2, { 528, 516 } },
    { 272544, 2, { 544, 501 } },
    { 272550, 2, { 575, 474 } },
    { 272556, 2, { 603, 452 } },
    { 272646, 2, { 561, 486 } },
    { 272650, 2, { 574, 475 } },
    { 272655, 2, { 657, 415 } },
    { 272685, 2, { 735, 371 } },
    { 272700, 2, { 540, 505 } },
    { 272727, 2, { 567, 481 } },
    { 272734, 2, { 539, 506 } },
    { 272745, 2, { 551, 495 } },
    { 272748, 2, { 573, 476 } },
    { 272796, 2, { 537, 508 } },
    { 272800, 2, { 550, 496 } },
    { 272832, 2, { 588, 464 } },
    { 272844, 2, { 572, 477 } },
    { 272850, 2, { 535, 510 } },
    { 272853, 2, { 549, 497 } },
    { 272896, 2, { 533, 512 } },
    { 272916, 2, { 532, 513 } },
    { 272935, 2, { 845, 323 } },
    { 272976, 2, { 528, 517 } },
    { 273000, 2, { 525, 520 } },
    { 273024, 2, { 576, 474 } },
    { 273060, 2, { 555, 492 } },
    { 273070, 2, { 581, 470 } },
    { 273105, 2, { 595, 459 } },
    { 273180, 2, { 580, 471 } },
    { 273240, 2, { 540, 506 } },
    { 273273, 2, { 539, 507 } },
    { 273288, 2, { 579, 472 } },
    { 273350, 2, { 550, 497 } },
    { 273360, 2, { 536, 510 } },
    { 273372, 2, { 627, 436 } },
    { 273408, 2, { 534, 512 } },
    { 273420, 2, { 558, 490 } },
    { 273429, 2, { 533, 513 } },
    { 273456, 2, { 633, 432 } },
    { 273465, 2, { 531, 515 } },
    { 273480, 2, { 530, 516 } },
    { 273492, 2, { 639, 428 } },
    { 273504, 2, { 528, 518 } },
    { 273540, 2, { 564, 485 } },
    { 273564, 2, { 596, 459 } },
    { 273581, 2, { 847, 323 } },
    { 273585, 2, { 793, 345 } },
    { 273600, 2, { 570, 480 } },
    { 273609, 2, { 707, 387 } },
    { 273672, 2, { 543, 504 } },
    { 273728, 2, { 611, 448 } },
    { 273735, 2, { 553, 495 } },
    { 273750, 2, { 625, 438 } },
    { 273768, 2, { 561, 488 } },
    { 273780, 2, { 540, 507 } },
    { 273840, 2, { 560, 489 } },
    { 273861, 2, { 567, 483 } },
    { 273896, 2, { 536, 511 } },
    { 273910, 2, { 559, 490 } },
    { 273920, 2, { 535, 512 } },
    { 273996, 2, { 531, 516 } },
    { 273999, 2, { 627, 437 } },
    { 274032, 2, { 528, 519 } },
    { 274040, 2, { 527, 520 } },
    { 274050, 2, { 525, 522 } },
    { 274057, 2, { 799, 343 } },
    { 274120, 2, { 616, 445 } },
    { 274176, 2, { 544, 504 } },
    { 274208, 2, { 608, 451 } },
    { 274224, 2, { 591, 464 } },
    { 274232, 2, { 581, 472 } },
    { 274275, 2, { 575, 477 } },
    { 274288, 2, { 553, 496 } },
    { 274340, 2, { 580, 473 } },
    { 274344, 2, { 552, 497 } },
    { 274365, 2, { 585, 469 } },
    { 274400, 2, { 560, 490 } },
    { 274428, 2, { 567, 484 } },
    { 274455, 2, { 535, 513 } },
    { 274482, 2, { 598, 459 } },
    { 274500, 2, { 549, 500 } },
    { 274505, 2, { 713, 385 } },
    { 274548, 2, { 548, 501 } },
    { 274560, 2, { 528, 520 } },
    { 274590, 2, { 565, 486 } },
    { 274620, 2, { 597, 460 } },
    { 274659, 2, { 609, 451 } },
    { 274680, 2, { 545, 504 } },
    { 274704, 2, { 582, 472 } },
    { 274720, 2, { 544, 505 } },
    { 274743, 2, { 623, 441 } },
    { 274752, 2, { 576, 477 } },
    { 274833, 2, { 729, 377 } },
    { 274890, 2, { 539, 510 } },
    { 274896, 2, { 552, 498 } },
    { 274911, 2, { 689, 399 } },
    { 274944, 2, { 537, 512 } },
    { 274968, 2, { 536, 513 } },
    { 274995, 2, { 567, 485 } },
    { 275010, 2, { 534, 515 } },
    { 275040, 2, { 573, 480 } },
    { 275044, 2, { 532, 517 } },
    { 275064, 2, { 584, 471 } },
    { 275080, 2, { 529, 520 } },
    { 275094, 2, { 527, 522 } },
    { 275100, 2, { 525, 524 } },
    { 275132, 2, { 572, 481 } },
    { 275184, 2, { 546, 504 } },
    { 275200, 2, { 640, 430 } },
    { 275220, 2, { 556, 495 } },
    { 275264, 2, { 544, 506 } },
    { 275268, 2, { 609, 452 } },
    { 275280, 2, { 555, 496 } },
    { 275310, 2, { 570, 483 } },
    { 275400, 2, { 540, 510 } },
    { 275415, 2, { 645, 427 } },
    { 275480, 2, { 568, 485 } },
    { 275500, 2, { 551, 500 } },
    { 275520, 2, { 560, 492 } },
    { 275604, 2, { 579, 476 } },
    { 275616, 2, { 528, 522 } },
    { 275720, 2, { 565, 488 } },
    { 275724, 2, { 621, 444 } },
    { 275730, 2, { 546, 505 } },
    { 275772, 2, { 588, 469 } },
    { 275796, 2, { 564, 489 } },
    { 275808, 2, { 544, 507 } },
    { 275825, 2, { 649, 425 } },
    { 275835, 2, { 555, 497 } },
    { 275844, 2, { 543, 508 } },
    { 275940, 2, { 540, 511 } },
    { 275968, 2, { 539, 512 } },
    { 275975, 2, { 581, 475 } },
    { 275988, 2, { 633, 436 } },
    { 276000, 2, { 552, 500 } },
    { 276012, 2, { 561, 492 } },
    { 276040, 2, { 536, 515 } },
    { 276048, 2, { 568, 486 } },
    { 276060, 2, { 535, 516 } },
    { 276080, 2, { 560, 493 } },
    { 276094, 2, { 533, 518 } },
    { 276108, 2, { 532, 519 } },
    { 276120, 2, { 531, 520 } },
    { 276165, 2, { 765, 361 } },
    { 276250, 2, { 625, 442 } },
    { 276276, 2, { 546, 506 } },
    { 276318, 2, { 602, 459 } },
    { 276336, 2, { 606, 456 } },
    { 276345, 2, { 621, 445 } },
    { 276360, 2, { 564, 490 } },
    { 276375, 2, { 737, 375 } },
    { 276381, 2, { 749, 369 } },
    { 276450, 2, { 570, 485 } },
    { 276480, 2, { 540, 512 } },
    { 276500, 2, { 553, 500 } },
    { 276507, 2, { 539, 513 } },
    { 276552, 2, { 552, 501 } },
    { 276573, 2, { 561, 493 } },
    { 276575, 2, { 575, 481 } },
    { 276588, 2, { 591, 468 } },
    { 276640, 2, { 532, 520 } },
    { 276660, 2, { 530, 522 } },
    { 276675, 2, { 527, 525 } },
    { 276696, 2, { 549, 504 } },
    { 276705, 2, { 559, 495 } },
    { 276710, 2, { 590, 469 } },
    { 276750, 2, { 615, 450 } },
    { 276760, 2, { 629, 440 } },
    { 276768, 2, { 558, 496 } },
    { 276816, 2, { 584, 474 } },
    { 276864, 2, { 618, 448 } },
    { 276920, 2, { 602, 460 } },
    { 276925, 2, { 583, 475 } },
    { 276948, 2, { 588, 471 } },
    { 277008, 2, { 597, 464 } },
    { 277020, 2, { 540, 513 } },
    { 277056, 2, { 576, 481 } },
    { 277065, 2, { 655, 423 } },
    { 277092, 2, { 537, 516 } },
    { 277134, 2, { 561, 494 } },
    { 277137, 2, { 581, 477 } },
    { 277140, 2, { 596, 465 } },
    { 277160, 2, { 533, 520 } },
    { 277200, 2, { 528, 525 } },
    { 277236, 2, { 604, 459 } },
    { 277245, 2, { 549, 505 } },
    { 277264, 2, { 559, 496 } },
    { 277326, 2, { 558, 497 } },
    { 277332, 2, { 573, 484 } },
    { 277344, 2, { 642, 432 } },
    { 277380, 2, { 603, 460 } },
    { 277389, 2, { 629, 441 } },
    { 277400, 2, { 584, 475 } },
    { 277440, 2, { 544, 510 } },
    { 277500, 2, { 555, 500 } },
    { 277508, 2, { 583, 476 } },
    { 277641, 2, { 791, 351 } },
    { 277680, 2, { 534, 520 } },
    { 277695, 2, { 561, 495 } },
    { 277725, 2, { 529, 525 } },
    { 277752, 2, { 568, 489 } },
    { 277830, 2, { 567, 490 } },
    { 277836, 2, { 548, 507 } },
    { 277875, 2, { 585, 475 } },
    { 277920, 2, { 579, 480 } },
    { 277950, 2, { 545, 510 } },
    { 277980, 2, { 565, 492 } },
    { 277984, 2, { 544, 511 } },
    { 277992, 2, { 572, 486 } },
    { 278005, 2, { 611, 455 } },
    { 278016, 2, { 543, 512 } },
    { 278100, 2, { 540, 515 } },
    { 278103, 2, { 697, 399 } },
    { 278124, 2, { 539, 516 } },
    { 278130, 2, { 635, 438 } },
    { 278160, 2, { 570, 488 } },
    { 278184, 2, { 536, 519 } },
    { 278200, 2, { 535, 520 } },
    { 278226, 2, { 533, 522 } },
    { 278240, 2, { 592, 470 } },
    { 278244, 2, { 531, 524 } },
    { 278256, 2, { 528, 527 } },
    { 278300, 2, { 550, 506 } },
    { 278320, 2, { 560, 497 } },
    { 278369, 2, { 637, 437 } },
    { 278388, 2, { 627, 444 } },
    { 278400, 2, { 580, 480 } },
    { 278425, 2, { 925, 301 } },
    { 278520, 2, { 633, 440 } },
    { 278556, 2, { 556, 501 } },
    { 278568, 2, { 584, 477 } },
    { 278586, 2, { 594, 469 } },
    { 278604, 2, { 639, 436 } },
    { 278663, 2, { 539, 517 } },
    { 278712, 2, { 553, 504 } },
    { 278760, 2, { 552, 505 } },
    { 278800, 2, { 656, 425 } },
    { 278806, 2, { 551, 506 } },
    { 278832, 2, { 592, 471 } },
    { 278850, 2, { 550, 507 } },
    { 278880, 2, { 560, 498 } },
    { 278892, 2, { 549, 508 } },
    { 278952, 2, { 591, 472 } },
    { 278964, 2, { 567, 492 } },
    { 278980, 2, { 580, 481 } },
    { 279027, 2, { 721, 387 } },
    { 279030, 2, { 655, 426 } },
    { 279040, 2, { 545, 512 } },
    { 279072, 2, { 544, 513 } },
    { 279104, 2, { 623, 448 } },
    { 279180, 2, { 540, 517 } },
    { 279225, 2, { 657, 425 } },
    { 279240, 2, { 537, 520 } },
    { 279270, 2, { 535, 522 } },
    { 279300, 2, { 532, 525 } },
    { 279312, 2, { 529, 528 } },
    { 279328, 2, { 602, 464 } },
    { 279357, 2, { 551, 507 } },
    { 279360, 2, { 576, 485 } },
    { 279396, 2, { 597, 468 } },
    { 279450, 2, { 575, 486 } },
    { 279500, 2, { 559, 500 } },
    { 279510, 2, { 605, 462 } },
    { 279531, 2, { 567, 493 } },
    { 279552, 2, { 546, 512 } },
    { 279565, 2, { 715, 391 } },
    { 279585, 2, { 545, 513 } },
    { 279620, 2, { 620, 451 } },
    { 279624, 2, { 573, 488 } },
    { 279675, 2, { 565, 495 } },
    { 279680, 2, { 608, 460 } },
    { 279708, 2, { 572, 489 } },
    { 279720, 2, { 540, 518 } },
    { 279734, 2, { 689, 406 } },
    { 279744, 2, { 564, 496 } },
    { 279752, 2, { 578, 484 } },
    { 279775, 2, { 589, 475 } },
    { 279792, 2, { 536, 522 } },
    { 279825, 2, { 533, 525 } },
    { 279840, 2, { 530, 528 } },
    { 279864, 2, { 552, 507 } },
    { 279930, 2, { 602, 465 } },
    { 279936, 2, { 576, 486 } },
    { 280016, 2, { 592, 473 } },
    { 280035, 2, { 635, 441 } },
    { 280071, 2, { 621, 451 } },
    { 280125, 2, { 675, 415 } },
    { 280140, 2, { 580, 483 } },
    { 280160, 2, { 544, 515 } },
    { 280188, 2, { 543, 516 } },
    { 280231, 2, { 817, 343 } },
    { 280236, 2, { 579, 484 } },
    { 280240, 2, { 565, 496 } },
    { 280260, 2, { 540, 519 } },
    { 280280, 2, { 539, 520 } },
    { 280308, 2, { 564, 497 } },
    { 280364, 2, { 532, 527 } },
    { 280368, 2, { 531, 528 } },
    { 280449, 2, { 611, 459 } },
    { 280476, 2, { 588, 477 } },
    { 280488, 2, { 696, 403 } },
    { 280497, 2, { 703, 399 } },
    { 280539, 2, { 549, 511 } },
    { 280560, 2, { 560, 501 } },
    { 280600, 2, { 575, 488 } },
    { 280608, 2, { 592, 474 } },
    { 280665, 2, { 567, 495 } },
    { 280692, 2, { 621, 452 } },
    { 280704, 2, { 544, 516 } },
    { 280716, 2, { 596, 471 } },
    { 280800, 2, { 540, 520 } },
    { 280860, 2, { 604, 465 } },
    { 280896, 2, { 532, 528 } },
    { 280908, 2, { 578, 486 } },
    { 280917, 2, { 637, 441 } },
    { 280962, 2, { 594, 473 } },
    { 281010, 2, { 551, 510 } },
    { 281050, 2, { 550, 511 } },
    { 281052, 2, { 633, 444 } },
    { 281088, 2, { 549, 512 } },
    { 281124, 2, { 548, 513 } },
    { 281160, 2, { 568, 495 } },
    { 281184, 2, { 606, 464 } },
    { 281190, 2, { 546, 515 } },
    { 281200, 2, { 592, 475 } },
    { 281220, 2, { 545, 516 } },
    { 281232, 2, { 558, 504 } },
    { 281240, 2, { 632, 445 } },
    { 281248, 2, { 544, 517 } },
    { 281250, 2, { 625, 450 } },
    { 281295, 2, { 665, 423 } },
    { 281316, 2, { 591, 476 } },
    { 281358, 2, { 539, 522 } },
    { 281370, 2, { 565, 498 } },
    { 281388, 2, { 537, 524 } },
    { 281400, 2, { 536, 525 } },
    { 281424, 2, { 533, 528 } },
    { 281428, 2, { 532, 529 } },
    { 281435, 2, { 595, 473 } },
    { 281520, 2, { 552, 510 } },
    { 281547, 2, { 763, 369 } },
    { 281554, 2, { 637, 442 } },
    { 281589, 2, { 583, 483 } },
    { 281600, 2, { 550, 512 } },
    { 281664, 2, { 576, 489 } },
    { 281666, 2, { 649, 434 } },
    { 281784, 2, { 597, 472 } },
    { 281790, 2, { 558, 505 } },
    { 281792, 2, { 544, 518 } },
    { 281799, 2, { 567, 497 } },
    { 281808, 2, { 618, 456 } },
    { 281875, 2, { 625, 451 } },
    { 281892, 2, { 556, 507 } },
    { 281916, 2, { 573, 492 } },
    { 281940, 2, { 555, 508 } },
    { 281952, 2, { 534, 528 } },
    { 281996, 2, { 572, 493 } },
    { 282030, 2, { 553, 510 } },
    { 282051, 2, { 693, 407 } },
    { 282072, 2, { 552, 511 } },
    { 282080, 2, { 656, 430 } },
    { 282112, 2, { 551, 512 } },
    { 282150, 2, { 550, 513 } },
    { 282200, 2, { 664, 425 } },
    { 282204, 2, { 603, 468 } },
    { 282282, 2, { 546, 517 } },
    { 282285, 2, { 615, 459 } },
    { 282302, 2, { 646, 437 } },
    { 282315, 2, { 649, 435 } },
    { 282336, 2, { 544, 519 } },
    { 282360, 2, { 543, 520 } },
    { 282384, 2, { 592, 477 } },
    { 282464, 2, { 679, 416 } },
    { 282480, 2, { 535, 528 } },
    { 282492, 2, { 532, 531 } },
    { 282552, 2, { 579, 488 } },
    { 282555, 2, { 585, 483 } },
    { 282564, 2, { 564, 501 } },
    { 282568, 2, { 572, 494 } },
    { 282576, 2, { 609, 464 } },
    { 282600, 2, { 600, 471 } },
    { 282624, 2, { 552, 512 } },
    { 282663, 2, { 551, 513 } },
    { 282720, 2, { 570, 496 } },
    { 282735, 2, { 549, 515 } },
    { 282744, 2, { 561, 504 } },
    { 282800, 2, { 560, 505 } },
    { 282854, 2, { 559, 506 } },
    { 282864, 2, { 568, 498 } },
    { 282900, 2, { 575, 492 } },
    { 282975, 2, { 539, 525 } },
    { 283136, 2, { 553, 512 } },
    { 283140, 2, { 572, 495 } },
    { 283176, 2, { 552, 513 } },
    { 283200, 2, { 590, 480 } },
    { 283220, 2, { 578, 490 } },
    { 283240, 2, { 584, 485 } },
    { 283284, 2, { 549, 516 } },
    { 283290, 2, { 570, 497 } },
    { 283338, 2, { 583, 486 } },
    { 283360, 2, { 560, 506 } },
    { 283392, 2, { 576, 492 } },
    { 283400, 2, { 545, 520 } },
    { 283404, 2, { 627, 452 } },
    { 283475, 2, { 575, 493 } },
    { 283500, 2, { 540, 525 } },
    { 283504, 2, { 611, 464 } },
    { 283528, 2, { 581, 488 } },
    { 283536, 2, { 537, 528 } },
    { 283556, 2, { 533, 532 } },
    { 283584, 2, { 633, 448 } },
    { 283590, 2, { 685, 414 } },
    { 283605, 2, { 555, 511 } },
    { 283620, 2, { 580, 489 } },
    { 283680, 2, { 591, 480 } },
    { 283689, 2, { 553, 513 } },
    { 283716, 2, { 639, 444 } },
    { 283725, 2, { 585, 485 } },
    { 283800, 2, { 550, 516 } },
    { 283815, 2, { 595, 477 } },
    { 283824, 2, { 584, 486 } },
    { 283836, 2, { 651, 436 } },
    { 283920, 2, { 546, 520 } },
    { 283968, 2, { 544, 522 } },
    { 284004, 2, { 588, 483 } },
    { 284016, 2, { 582, 488 } },
    { 284053, 2, { 539, 527 } },
    { 284085, 2, { 535, 531 } },
    { 284115, 2, { 611, 465 } },
    { 284130, 2, { 574, 495 } },
    { 284160, 2, { 555, 512 } },
    { 284172, 2, { 597, 476 } },
    { 284208, 2, { 573, 496 } },
    { 284240, 2, { 646, 440 } },
    { 284280, 2, { 552, 515 } },
    { 284292, 2, { 596, 477 } },
    { 284310, 2, { 585, 486 } },
    { 284350, 2, { 550, 517 } },
    { 284355, 2, { 639, 445 } },
    { 284375, 2, { 625, 455 } },
    { 284400, 2, { 600, 474 } },
    { 284412, 2, { 548, 519 } },
    { 284484, 2, { 604, 471 } },
    { 284487, 2, { 589, 483 } },
    { 284490, 2, { 545, 522 } },
    { 284532, 2, { 543, 524 } },
    { 284544, 2, { 576, 494 } },
    { 284568, 2, { 568, 501 } },
    { 284580, 2, { 540, 527 } },
    { 284592, 2, { 539, 528 } },
    { 284616, 2, { 536, 531 } },
    { 284625, 2, { 575, 495 } },
    { 284648, 2, { 598, 476 } },
    { 284690, 2, { 581, 490 } },
    { 284704, 2, { 574, 496 } },
    { 284715, 2, { 555, 513 } },
    { 284760, 2, { 565, 504 } },
    { 284800, 2, { 640, 445 } },
    { 284820, 2, { 564, 505 } },
    { 284868, 2, { 579, 492 } },
    { 284886, 2, { 646, 441 } },
    { 284900, 2, { 550, 518 } },
    { 284928, 2, { 636, 448 } },
    { 284988, 2, { 561, 508 } },
    { 285076, 2, { 589, 484 } },
    { 285090, 2, { 559, 510 } },
    { 285120, 2, { 540, 528 } },
    { 285131, 2, { 539, 529 } },
    { 285138, 2, { 558, 511 } },
    { 285175, 2, { 671, 425 } },
    { 285200, 2, { 575, 496 } },
    { 285228, 2, { 556, 513 } },
    { 285243, 2, { 799, 357 } },
    { 285285, 2, { 627, 455 } },
    { 285348, 2, { 553, 516 } },
    { 285376, 2, { 637, 448 } },
    { 285384, 2, { 552, 517 } },
    { 285480, 2, { 549, 520 } },
    { 285576, 2, { 584, 489 } },
    { 285600, 2, { 544, 525 } },
    { 285660, 2, { 540, 529 } },
    { 285670, 2, { 539, 530 } },
    { 285684, 2, { 537, 532 } },
    { 285690, 2, { 535, 534 } },
    { 285696, 2, { 558, 512 } },
    { 285714, 2, { 594, 481 } },
    { 285750, 2, { 635, 450 } },
    { 285760, 2, { 608, 470 } },
    { 285768, 2, { 567, 504 } },
    { 285775, 2, { 575, 497 } },
    { 285912, 2, { 627, 456 } },
    { 285936, 2, { 552, 518 } },
    { 285948, 2, { 564, 507 } },
    { 285950, 2, { 602, 475 } },
    { 285957, 2, { 623, 459 } },
    { 286032, 2, { 606, 472 } },
    { 286044, 2, { 591, 484 } },
    { 286090, 2, { 610, 469 } },
    { 286116, 2, { 633, 452 } },
    { 286143, 2, { 667, 429 } },
    { 286160, 2, { 560, 511 } },
    { 286195, 2, { 595, 481 } },
    { 286200, 2, { 540, 530 } },
    { 286208, 2, { 559, 512 } },
    { 286209, 2, { 539, 531 } },
    { 286224, 2, { 536, 534 } },
    { 286286, 2, { 847, 338 } },
    { 286335, 2, { 567, 505 } },
    { 286350, 2, { 575, 498 } },
    { 286368, 2, { 608, 471 } },
    { 286380, 2, { 555, 516 } },
    { 286425, 2, { 603, 475 } },
    { 286440, 2, { 616, 465 } },
    { 286488, 2, { 552, 519 } },
    { 286500, 2, { 573, 500 } },
    { 286520, 2, { 551, 520 } },
    { 286560, 2, { 597, 480 } },
    { 286572, 2, { 572, 501 } },
    { 286580, 2, { 623, 460 } },
    { 286650, 2, { 546, 525 } },
    { 286688, 2, { 544, 527 } },
    { 286704, 2, { 543, 528 } },
    { 286720, 2, { 560, 512 } },
    { 286740, 2, { 540, 531 } },
    { 286752, 2, { 618, 464 } },
    { 286760, 2, { 536, 535 } },
    { 286767, 2, { 559, 513 } },
    { 286770, 2, { 605, 474 } },
    { 286824, 2, { 629, 456 } },
    { 286836, 2, { 583, 492 } },
    { 286840, 2, { 568, 505 } },
    { 286848, 2, { 576, 498 } },
    { 286875, 2, { 625, 459 } },
    { 286890, 2, { 655, 438 } },
    { 286902, 2, { 567, 506 } },
    { 286935, 2, { 555, 517 } },
    { 287000, 2, { 574, 500 } },
    { 287028, 2, { 603, 476 } },
    { 287100, 2, { 550, 522 } },
    { 287120, 2, { 592, 485 } },
    { 287184, 2, { 579, 496 } },
    { 287217, 2, { 679, 423 } },
    { 287280, 2, { 540, 532 } },
    { 287287, 2, { 539, 533 } },
    { 287300, 2, { 650, 442 } },
    { 287370, 2, { 558, 515 } },
    { 287448, 2, { 609, 472 } },
    { 287469, 2, { 567, 507 } },
    { 287525, 2, { 775, 371 } },
    { 287532, 2, { 588, 489 } },
    { 287560, 2, { 553, 520 } },
    { 287584, 2, { 608, 473 } },
    { 287595, 2, { 581, 495 } },
    { 287616, 2, { 642, 448 } },
    { 287625, 2, { 767, 375 } },
    { 287676, 2, { 549, 524 } },
    { 287700, 2, { 548, 525 } },
    { 287712, 2, { 592, 486 } },
    { 287742, 2, { 546, 527 } },
    { 287760, 2, { 545, 528 } },
    { 287776, 2, { 544, 529 } },
    { 287820, 2, { 540, 533 } },
    { 287832, 2, { 537, 536 } },
    { 287850, 2, { 570, 505 } },
    { 287868, 2, { 596, 483 } },
    { 287875, 2, { 875, 329 } },
    { 287896, 2, { 679, 424 } },
    { 287976, 2, { 568, 507 } },
    { 288000, 2, { 576, 500 } },
    { 288036, 2, { 567, 508 } },
    { 288057, 2, { 609, 473 } },
    { 288108, 2, { 604, 477 } },
    { 288144, 2, { 552, 522 } },
    { 288145, 2, { 715, 403 } },
    { 288150, 2, { 565, 510 } },
    { 288156, 2, { 649, 444 } },
    { 288176, 2, { 581, 496 } },
    { 288192, 2, { 608, 474 } },
    { 288204, 2, { 564, 511 } },
    { 288252, 2, { 612, 471 } },
    { 288260, 2, { 580, 497 } },
    { 288288, 2, { 546, 528 } },
    { 288320, 2, { 544, 530 } },
    { 288400, 2, { 560, 515 } },
    { 288405, 2, { 585, 493 } },
    { 288408, 2, { 591, 488 } },
    { 288420, 2, { 570, 506 } },
    { 288435, 2, { 615, 469 } },
    { 288463, 2, { 841, 343 } },
    { 288486, 2, { 558, 517 } },
    { 288512, 2, { 644, 448 } },
    { 288558, 2, { 697, 414 } },
    { 288564, 2, { 556, 519 } },
    { 288576, 2, { 576, 501 } },
    { 288585, 2, { 583, 495 } },
    { 288600, 2, { 555, 520 } },
    { 288610, 2, { 589, 490 } },
    { 288640, 2, { 640, 451 } },
    { 288648, 2, { 633, 456 } },
    { 288666, 2, { 553, 522 } },
    { 288672, 2, { 582, 496 } },
    { 288711, 2, { 629, 459 } },
    { 288765, 2, { 621, 465 } },
    { 288768, 2, { 564, 512 } },
    { 288792, 2, { 573, 504 } },
    { 288800, 2, { 608, 475 } },
    { 288828, 2, { 639, 452 } },
    { 288834, 2, { 546, 529 } },
    { 288855, 2, { 655, 441 } },
    { 288864, 2, { 544, 531 } },
    { 288876, 2, { 543, 532 } },
    { 288900, 2, { 540, 535 } },
    { 288904, 2, { 539, 536 } },
    { 288948, 2, { 597, 484 } },
    { 288960, 2, { 560, 516 } },
    { 289000, 2, { 578, 500 } },
    { 289044, 2, { 558, 518 } },
    { 289072, 2, { 623, 464 } },
    { 289080, 2, { 584, 495 } },
    { 289168, 2, { 583, 496 } },
    { 289170, 2, { 567, 510 } },
    { 289275, 2, { 551, 525 } },
    { 289280, 2, { 565, 512 } },
    { 289289, 2, { 1001, 289 } },
    { 289296, 2, { 574, 504 } },
    { 289332, 2, { 564, 513 } },
    { 289340, 2, { 629, 460 } },
    { 289395, 2, { 545, 531 } },
    { 289408, 2, { 544, 532 } },
    { 289476, 2, { 561, 516 } },
    { 289488, 2, { 592, 489 } },
    { 289500, 2, { 579, 500 } },
    { 289520, 2, { 560, 517 } },
    { 289562, 2, { 559, 518 } },
    { 289674, 2, { 627, 462 } },
    { 289680, 2, { 568, 510 } },
    { 289695, 2, { 623, 465 } },
    { 289710, 2, { 555, 522 } },
    { 289731, 2, { 663, 437 } },
    { 289737, 2, { 567, 511 } },
    { 289755, 2, { 685, 423 } },
    { 289800, 2, { 552, 525 } },
    { 289845, 2, { 565, 513 } },
    { 289850, 2, { 550, 527 } },
    { 289863, 2, { 749, 387 } },
    { 289872, 2, { 549, 528 } },
    { 289884, 2, { 588, 493 } },
    { 289952, 2, { 544, 533 } },
    { 289980, 2, { 540, 537 } },
    { 290004, 2, { 572, 507 } },
    { 290016, 2, { 608, 477 } },
    { 290080, 2, { 560, 518 } },
    { 290136, 2, { 616, 471 } },
    { 290160, 2, { 558, 520 } },
    { 290225, 2, { 611, 475 } },
    { 290248, 2, { 568, 511 } },
    { 290250, 2, { 645, 450 } },
    { 290280, 2, { 590, 492 } },
    { 290290, 2, { 638, 455 } },
    { 290304, 2, { 567, 512 } },
    { 290325, 2, { 553, 525 } },
    { 290360, 2, { 595, 488 } },
    { 290400, 2, { 550, 528 } },
    { 290460, 2, { 564, 515 } },
    { 290496, 2, { 544, 534 } },
    { 290500, 2, { 581, 500 } },
    { 290580, 2, { 580, 501 } },
    { 290605, 2, { 665, 437 } },
    { 290628, 2, { 598, 486 } },
    { 290640, 2, { 560, 519 } },
    { 290680, 2, { 559, 520 } },
    { 290745, 2, { 585, 497 } },
    { 290772, 2, { 591, 492 } },
    { 290780, 2, { 620, 469 } },
    { 290820, 2, { 555, 524 } },
    { 290832, 2, { 584, 498 } },
    { 290836, 2, { 611, 476 } },
    { 290880, 2, { 576, 505 } },
    { 290895, 2, { 615, 473 } },
    { 290904, 2, { 552, 527 } },
    { 290928, 2, { 551, 528 } },
    { 290950, 2, { 550, 529 } },
    { 290966, 2, { 589, 494 } },
    { 290988, 2, { 548, 531 } },
    { 291005, 2, { 605, 481 } },
    { 291018, 2, { 546, 533 } },
    { 291030, 2, { 545, 534 } },
    { 291040, 2, { 544, 535 } },
    { 291048, 2, { 543, 536 } },
    { 291060, 2, { 540, 539 } },
    { 291084, 2, { 573, 508 } },
    { 291165, 2, { 705, 413 } },
    { 291180, 2, { 633, 460 } },
    { 291214, 2, { 671, 434 } },
    { 291264, 2, { 592, 492 } },
    { 291270, 2, { 570, 511 } },
    { 291312, 2, { 578, 504 } },
    { 291336, 2, { 597, 488 } },
    { 291384, 2, { 568, 513 } },
    { 291444, 2, { 596, 489 } },
    { 291465, 2, { 635, 459 } },
    { 291540, 2, { 565, 516 } },
    { 291555, 2, { 589, 495 } },
    { 291648, 2, { 588, 496 } },
    { 291669, 2, { 731, 399 } },
    { 291696, 2, { 618, 472 } },
    { 291708, 2, { 657, 444 } },
    { 291720, 2, { 561, 520 } },
    { 291732, 2, { 604, 483 } },
    { 291798, 2, { 559, 522 } },
    { 291810, 2, { 685, 426 } },
    { 291816, 2, { 579, 504 } },
    { 291840, 2, { 570, 512 } },
    { 291852, 2, { 603, 484 } },
    { 291870, 2, { 621, 470 } },
    { 291879, 2, { 791, 369 } },
    { 291885, 2, { 671, 435 } },
    { 291893, 2, { 851, 343 } },
    { 291900, 2, { 556, 525 } },
    { 291920, 2, { 656, 445 } },
    { 291924, 2, { 612, 477 } },
    { 291984, 2, { 553, 528 } },
    { 292005, 2, { 567, 515 } },
    { 292020, 2, { 620, 471 } },
    { 292032, 2, { 576, 507 } },
    { 292068, 2, { 549, 532 } },
    { 292110, 2, { 546, 535 } },
    { 292120, 2, { 545, 536 } },
    { 292128, 2, { 544, 537 } },
    { 292175, 2, { 725, 403 } },
    { 292236, 2, { 588, 497 } },
    { 292320, 2, { 560, 522 } },
    { 292365, 2, { 657, 445 } },
    { 292383, 2, { 637, 459 } },
    { 292455, 2, { 603, 485 } },
    { 292500, 2, { 585, 500 } },
    { 292520, 2, { 568, 515 } },
    { 292560, 2, { 552, 530 } },
    { 292572, 2, { 567, 516 } },
    { 292584, 2, { 584, 501 } },
    { 292600, 2, { 550, 532 } },
    { 292640, 2, { 590, 496 } },
    { 292656, 2, { 546, 536 } },
    { 292716, 2, { 564, 519 } },
    { 292740, 2, { 574, 510 } },
    { 292752, 2, { 642, 456 } },
    { 292810, 2, { 623, 470 } },
    { 292824, 2, { 581, 504 } },
    { 292825, 2, { 689, 425 } },
    { 292864, 2, { 572, 512 } },
    { 292875, 2, { 781, 375 } },
    { 292929, 2, { 609, 481 } },
    { 292950, 2, { 558, 525 } },
    { 292992, 2, { 654, 448 } },
    { 293020, 2, { 598, 490 } },
    { 293040, 2, { 555, 528 } },
    { 293046, 2, { 578, 507 } },
    { 293090, 2, { 553, 530 } },
    { 293112, 2, { 552, 531 } },
    { 293125, 2, { 625, 469 } },
    { 293132, 2, { 551, 532 } },
    { 293136, 2, { 591, 496 } },
    { 293139, 2, { 567, 517 } },
    { 293150, 2, { 550, 533 } },
    { 293216, 2, { 544, 539 } },
    { 293220, 2, { 543, 540 } },
    { 293230, 2, { 590, 497 } },
    { 293250, 2, { 575, 510 } },
    { 293260, 2, { 620, 473 } },
    { 293265, 2, { 665, 441 } },
    { 293328, 2, { 582, 504 } },
    { 293335, 2, { 595, 493 } },
    { 293370, 2, { 635, 462 } },
    { 293376, 2, { 573, 512 } },
    { 293400, 2, { 600, 489 } },
    { 293436, 2, { 572, 513 } },
    { 293475, 2, { 559, 525 } },
    { 293550, 2, { 570, 515 } },
    { 293601, 2, { 651, 451 } },
    { 293625, 2, { 675, 435 } },
    { 293643, 2, { 553, 531 } },
    { 293706, 2, { 567, 518 } },
    { 293712, 2, { 633, 464 } },
    { 293715, 2, { 549, 535 } },
    { 293724, 2, { 597, 492 } },
    { 293733, 2, { 621, 473 } },
    { 293760, 2, { 544, 540 } },
    { 293787, 2, { 729, 403 } },
    { 293800, 2, { 565, 520 } },
    { 293825, 2, { 575, 511 } },
    { 293832, 2, { 583, 504 } },
    { 293854, 2, { 703, 418 } },
    { 293888, 2, { 574, 512 } },
    { 293904, 2, { 624, 471 } },
    { 293910, 2, { 582, 505 } },
    { 293930, 2, { 595, 494 } },
    { 293940, 2, { 639, 460 } },
    { 293964, 2, { 561, 524 } },
    { 293985, 2, { 695, 423 } },
    { 294000, 2, { 560, 525 } },
    { 294056, 2, { 623, 472 } },
    { 294060, 2, { 580, 507 } },
    { 294112, 2, { 707, 416 } },
    { 294132, 2, { 579, 508 } },
    { 294151, 2, { 1331, 221 } },
    { 294216, 2, { 552, 533 } },
    { 294252, 2, { 651, 452 } },
    { 294264, 2, { 549, 536 } },
    { 294276, 2, { 548, 537 } },
    { 294300, 2, { 545, 540 } },
    { 294336, 2, { 576, 511 } },
    { 294372, 2, { 612, 481 } },
    { 294400, 2, { 575, 512 } },
    { 294462, 2, { 574, 513 } },
    { 294500, 2, { 589, 500 } },
    { 294525, 2, { 561, 525 } },
    { 294588, 2, { 588, 501 } },
    { 294624, 2, { 558, 528 } },
    { 294690, 2, { 570, 517 } },
    { 294750, 2, { 655, 450 } },
    { 294756, 2, { 609, 484 } },
    { 294768, 2, { 552, 534 } },
    { 294784, 2, { 658, 448 } },
    { 294792, 2, { 568, 519 } },
    { 294814, 2, { 598, 493 } },
    { 294816, 2, { 592, 498 } },
    { 294840, 2, { 546, 540 } },
    { 294880, 2, { 608, 485 } },
    { 294912, 2, { 576, 512 } },
    { 294920, 2, { 584, 505 } },
    { 294930, 2, { 565, 522 } },
    { 294975, 2, { 575, 513 } },
    { 295020, 2, { 596, 495 } },
    { 295065, 2, { 711, 415 } },
    { 295075, 2, { 725, 407 } },
    { 295104, 2, { 636, 464 } },
    { 295113, 2, { 611, 483 } },
    { 295120, 2, { 560, 527 } },
    { 295152, 2, { 559, 528 } },
    { 295218, 2, { 594, 497 } },
    { 295236, 2, { 556, 531 } },
    { 295240, 2, { 605, 488 } },
    { 295260, 2, { 555, 532 } },
    { 295281, 2, { 763, 387 } },
    { 295295, 2, { 649, 455 } },
    { 295320, 2, { 552, 535 } },
    { 295356, 2, { 604, 489 } },
    { 295392, 2, { 544, 543 } },
    { 295425, 2, { 585, 505 } },
    { 295480, 2, { 664, 445 } },
    { 295488, 2, { 576, 513 } },
    { 295500, 2, { 591, 500 } },
    { 295568, 2, { 637, 464 } },
    { 295596, 2, { 612, 483 } },
    { 295625, 2, { 625, 473 } },
    { 295647, 2, { 561, 527 } },
    { 295668, 2, { 573, 516 } },
    { 295728, 2, { 606, 488 } },
    { 295740, 2, { 558, 530 } },
    { 295776, 2, { 624, 474 } },
    { 295815, 2, { 555, 533 } },
    { 295911, 2, { 549, 539 } },
    { 295925, 2, { 623, 475 } },
    { 295944, 2, { 627, 472 } },
    { 296010, 2, { 585, 506 } },
    { 296055, 2, { 645, 459 } },
    { 296070, 2, { 695, 426 } },
    { 296088, 2, { 584, 507 } },
    { 296100, 2, { 564, 525 } },
    { 296112, 2, { 597, 496 } },
    { 296205, 2, { 637, 465 } },
    { 296208, 2, { 561, 528 } },
    { 296225, 2, { 697, 425 } },
    { 296240, 2, { 560, 529 } },
    { 296244, 2, { 633, 468 } },
    { 296250, 2, { 625, 474 } },
    { 296310, 2, { 581, 510 } },
    { 296380, 2, { 580, 511 } },
    { 296400, 2, { 570, 520 } },
    { 296408, 2, { 553, 536 } },
    { 296424, 2, { 552, 537 } },
    { 296448, 2, { 579, 512 } },
    { 296450, 2, { 550, 539 } },
    { 296460, 2, { 549, 540 } },
    { 296480, 2, { 545, 544 } },
    { 296496, 2, { 568, 522 } },
    { 296592, 2, { 592, 501 } },
    { 296640, 2, { 576, 515 } },
    { 296676, 2, { 603, 492 } },
    { 296700, 2, { 575, 516 } },
    { 296703, 2, { 729, 407 } },
    { 296758, 2, { 574, 517 } },
    { 296769, 2, { 561, 529 } },
    { 296800, 2, { 560, 530 } },
    { 296868, 2, { 572, 519 } },
    { 296940, 2, { 588, 505 } },
    { 296946, 2, { 611, 486 } },
    { 296960, 2, { 580, 512 } },
    { 296964, 2, { 657, 452 } },
    { 296989, 2, { 551, 539 } },
    { 297000, 2, { 550, 540 } },
    { 297024, 2, { 546, 544 } },
    { 297108, 2, { 567, 524 } },
    { 297171, 2, { 623, 477 } },
    { 297180, 2, { 585, 508 } },
    { 297192, 2, { 609, 488 } },
    { 297216, 2, { 576, 516 } },
    { 297275, 2, { 575, 517 } },
    { 297297, 2, { 693, 429 } },
    { 297312, 2, { 608, 489 } },
    { 297360, 2, { 560, 531 } },
    { 297375, 2, { 793, 375 } },
    { 297388, 2, { 559, 532 } },
    { 297414, 2, { 558, 533 } },
    { 297472, 2, { 581, 512 } },
    { 297480, 2, { 555, 536 } },
    { 297500, 2, { 595, 500 } },
    { 297528, 2, { 552, 539 } },
    { 297540, 2, { 551, 540 } },
    { 297564, 2, { 548, 543 } },
    { 297570, 2, { 546, 545 } },
    { 297648, 2, { 624, 477 } },
    { 297660, 2, { 605, 492 } },
    { 297675, 2, { 567, 525 } },
    { 297792, 2, { 564, 528 } },
    { 297840, 2, { 584, 510 } },
    { 297850, 2, { 575, 518 } },
    { 297864, 2, { 591, 504 } },
    { 297888, 2, { 642, 464 } },
    { 297920, 2, { 560, 532 } },
    { 297924, 2, { 671, 444 } },
    { 297960, 2, { 573, 520 } },
    { 297984, 2, { 582, 512 } },
    { 297990, 2, { 602, 495 } },
    { 298034, 2, { 589, 506 } },
    { 298053, 2, { 581, 513 } },
    { 298125, 2, { 625, 477 } },
    { 298200, 2, { 568, 525 } },
    { 298220, 2, { 620, 481 } },
    { 298224, 2, { 654, 456 } },
    { 298265, 2, { 605, 493 } },
    { 298284, 2, { 636, 469 } },
    { 298320, 2, { 565, 528 } },
    { 298368, 2, { 576, 518 } },
    { 298452, 2, { 561, 532 } },
    { 298480, 2, { 560, 533 } },
    { 298496, 2, { 583, 512 } },
    { 298500, 2, { 597, 500 } },
    { 298530, 2, { 558, 535 } },
    { 298572, 2, { 556, 537 } },
    { 298592, 2, { 602, 496 } },
    { 298596, 2, { 596, 501 } },
    { 298620, 2, { 553, 540 } },
    { 298623, 2, { 589, 507 } },
    { 298656, 2, { 549, 544 } },
    { 298701, 2, { 621, 481 } },
    { 298760, 2, { 616, 485 } },
    { 298764, 2, { 579, 516 } },
    { 298775, 2, { 629, 475 } },
    { 298776, 2, { 633, 472 } },
    { 298800, 2, { 600, 498 } },
    { 298809, 2, { 567, 527 } },
    { 298870, 2, { 605, 494 } },
    { 298890, 2, { 615, 486 } },
    { 298908, 2, { 684, 437 } },
    { 298920, 2, { 564, 530 } },
    { 298935, 2, { 585, 511 } },
    { 298944, 2, { 576, 519 } },
    { 298960, 2, { 592, 505 } },
    { 298980, 2, { 604, 495 } },
    { 299000, 2, { 575, 520 } },
    { 299013, 2, { 561, 533 } },
    { 299026, 2, { 689, 434 } },
    { 299040, 2, { 560, 534 } },
    { 299052, 2, { 639, 468 } },
    { 299061, 2, { 707, 423 } },
    { 299079, 2, { 583, 513 } },
    { 299088, 2, { 558, 536 } },
    { 299115, 2, { 765, 391 } },
    { 299136, 2, { 608, 492 } },
    { 299145, 2, { 555, 539 } },
    { 299200, 2, { 550, 544 } },
    { 299205, 2, { 549, 545 } },
    { 299268, 2, { 612, 489 } },
    { 299299, 2, { 1001, 299 } },
    { 299376, 2, { 567, 528 } },
    { 299390, 2, { 611, 490 } },
    { 299425, 2, { 725, 413 } },
    { 299439, 2, { 679, 441 } },
    { 299460, 2, { 620, 483 } },
    { 299475, 2, { 605, 495 } },
    { 299484, 2, { 564, 531 } },
    { 299520, 2, { 576, 520 } },
    { 299556, 2, { 628, 477 } },
    { 299592, 2, { 584, 513 } },
    { 299600, 2, { 560, 535 } },
    { 299628, 2, { 574, 522 } },
    { 299676, 2, { 663, 452 } },
    { 299691, 2, { 603, 497 } },
    { 299700, 2, { 555, 540 } },
    { 299712, 2, { 669, 448 } },
    { 299715, 2, { 689, 435 } },
    { 299730, 2, { 582, 515 } },
    { 299736, 2, { 552, 543 } },
    { 299744, 2, { 551, 544 } },
    { 299768, 2, { 707, 424 } },
    { 299782, 2, { 686, 437 } },
    { 299796, 2, { 581, 516 } },
    { 299838, 2, { 649, 462 } },
    { 299860, 2, { 580, 517 } },
    { 299915, 2, { 665, 451 } },
    { 299936, 2, { 721, 416 } },
    { 299943, 2, { 567, 529 } },
    { 299970, 2, { 594, 505 } },
    { 300015, 2, { 565, 531 } },
    { 300030, 2, { 685, 438 } },
    { 300080, 2, { 605, 496 } },
    { 300120, 2, { 610, 492 } },
    { 300125, 2, { 875, 343 } },
    { 300144, 2, { 592, 507 } },
    { 300150, 2, { 575, 522 } },
    { 300200, 2, { 632, 475 } },
    { 300228, 2, { 591, 508 } },
    { 300252, 2, { 573, 524 } },
    { 300288, 2, { 552, 544 } },
    { 300300, 2, { 550, 546 } },
    { 300366, 2, { 666, 451 } },
    { 300375, 2, { 675, 445 } },
    { 300390, 2, { 570, 527 } },
    { 300440, 2, { 580, 518 } },
    { 300468, 2, { 588, 511 } },
    { 300495, 2, { 871, 345 } },
    { 300510, 2, { 567, 530 } },
    { 300560, 2, { 578, 520 } },
    { 300564, 2, { 594, 506 } },
    { 300576, 2, { 606, 496 } },
    { 300600, 2, { 600, 501 } },
    { 300625, 2, { 625, 481 } },
    { 300645, 2, { 655, 459 } },
    { 300664, 2, { 637, 472 } },
    { 300672, 2, { 576, 522 } },
    { 300696, 2, { 561, 536 } },
    { 300713, 2, { 833, 361 } },
    { 300720, 2, { 560, 537 } },
    { 300760, 2, { 584, 515 } },
    { 300762, 2, { 558, 539 } },
    { 300800, 2, { 640, 470 } },
    { 300828, 2, { 583, 516 } },
    { 300832, 2, { 553, 544 } },
    { 300840, 2, { 552, 545 } },
    { 300846, 2, { 551, 546 } },
    { 300852, 2, { 549, 548 } },
    { 300888, 2, { 597, 504 } },
    { 300960, 2, { 570, 528 } },
    { 300990, 2, { 635, 474 } },
    { 301000, 2, { 602, 500 } },
    { 301020, 2, { 580, 519 } },
    { 301035, 2, { 705, 427 } },
    { 301056, 2, { 588, 512 } },
    { 301070, 2, { 595, 506 } },
    { 301080, 2, { 579, 520 } },
    { 301125, 2, { 803, 375 } },
    { 301158, 2, { 594, 507 } },
    { 301185, 2, { 621, 485 } },
    { 301224, 2, { 616, 489 } },
    { 301275, 2, { 585, 515 } },
    { 301290, 2, { 605, 498 } },
    { 301301, 2, { 559, 539 } },
    { 301308, 2, { 633, 476 } },
    { 301350, 2, { 574, 525 } },
    { 301392, 2, { 552, 546 } },
    { 301444, 2, { 572, 527 } },
    { 301455, 2, { 609, 495 } },
    { 301464, 2, { 632, 477 } },
    { 301490, 2, { 590, 511 } },
    { 301500, 2, { 603, 500 } },
    { 301530, 2, { 570, 529 } },
    { 301568, 2, { 589, 512 } },
    { 301584, 2, { 618, 488 } },
    { 301587, 2, { 627, 481 } },
    { 301608, 2, { 568, 531 } },
    { 301644, 2, { 567, 532 } },
    { 301710, 2, { 565, 534 } },
    { 301740, 2, { 564, 535 } },
    { 301785, 2, { 649, 465 } },
    { 301840, 2, { 560, 539 } },
    { 301860, 2, { 559, 540 } },
    { 301908, 2, { 556, 543 } },
    { 301920, 2, { 555, 544 } },
    { 301994, 2, { 583, 518 } },
    { 302005, 2, { 935, 323 } },
    { 302016, 2, { 572, 528 } },
    { 302022, 2, { 658, 459 } },
    { 302064, 2, { 609, 496 } },
    { 302080, 2, { 590, 512 } },
    { 302085, 2, { 685, 441 } },
    { 302120, 2, { 581, 520 } },
    { 302157, 2, { 589, 513 } },
    { 302172, 2, { 596, 507 } },
    { 302175, 2, { 711, 425 } },
    { 302211, 2, { 567, 533 } },
    { 302220, 2, { 657, 460 } },
    { 302316, 2, { 708, 427 } },
    { 302328, 2, { 612, 494 } },
    { 302379, 2, { 561, 539 } },
    { 302388, 2, { 669, 452 } },
    { 302400, 2, { 560, 540 } },
    { 302445, 2, { 585, 517 } },
    { 302505, 2, { 645, 469 } },
    { 302535, 2, { 729, 415 } },
    { 302544, 2, { 573, 528 } },
    { 302560, 2, { 610, 496 } },
    { 302575, 2, { 637, 475 } },
    { 302580, 2, { 615, 492 } },
    { 302588, 2, { 572, 529 } },
    { 302592, 2, { 591, 512 } },
    { 302600, 2, { 680, 445 } },
    { 302604, 2, { 604, 501 } },
    { 302610, 2, { 655, 462 } },
    { 302634, 2, { 731, 414 } },
    { 302640, 2, { 582, 520 } },
    { 302720, 2, { 640, 473 } },
    { 302784, 2, { 608, 498 } },
    { 302820, 2, { 588, 515 } },
    { 302840, 2, { 565, 536 } },
    { 302848, 2, { 676, 448 } },
    { 302868, 2, { 564, 537 } },
    { 302895, 2, { 635, 477 } },
    { 302940, 2, { 561, 540 } },
    { 303000, 2, { 600, 505 } },
    { 303024, 2, { 642, 472 } },
    { 303025, 2, { 575, 527 } },
    { 303048, 2, { 552, 549 } },
    { 303050, 2, { 551, 550 } },
    { 303056, 2, { 611, 496 } },
    { 303072, 2, { 574, 528 } },
    { 303096, 2, { 584, 519 } },
    { 303170, 2, { 610, 497 } },
    { 303180, 2, { 620, 489 } },
    { 303264, 2, { 624, 486 } },
    { 303276, 2, { 597, 508 } },
    { 303282, 2, { 581, 522 } },
    { 303312, 2, { 568, 534 } },
    { 303324, 2, { 628, 483 } },
    { 303345, 2, { 567, 535 } },
    { 303396, 2, { 579, 524 } },
    { 303450, 2, { 578, 525 } },
    { 303456, 2, { 654, 464 } },
    { 303468, 2, { 627, 484 } },
    { 303485, 2, { 667, 455 } },
    { 303525, 2, { 639, 475 } },
    { 303534, 2, { 594, 511 } },
    { 303552, 2, { 558, 544 } },
    { 303555, 2, { 735, 413 } },
    { 303597, 2, { 553, 549 } },
    { 303600, 2, { 552, 550 } },
    { 303688, 2, { 616, 493 } },
    { 303696, 2, { 592, 513 } },
    { 303732, 2, { 572, 531 } },
    { 303750, 2, { 625, 486 } },
    { 303807, 2, { 629, 483 } },
    { 303810, 2, { 570, 533 } },
    { 303840, 2, { 633, 480 } },
    { 303849, 2, { 637, 477 } },
    { 303880, 2, { 568, 535 } },
    { 303912, 2, { 567, 536 } },
    { 303996, 2, { 564, 539 } },
    { 304000, 2, { 608, 500 } },
    { 304024, 2, { 623, 488 } },
    { 304080, 2, { 560, 543 } },
    { 304096, 2, { 559, 544 } },
    { 304110, 2, { 558, 545 } },
    { 304128, 2, { 576, 528 } },
    { 304140, 2, { 555, 548 } },
    { 304150, 2, { 553, 550 } },
    { 304152, 2, { 552, 551 } },
    { 304164, 2, { 612, 497 } },
    { 304192, 2, { 679, 448 } },
    { 304200, 2, { 585, 520 } },
    { 304290, 2, { 621, 490 } },
    { 304325, 2, { 925, 329 } },
    { 304326, 2, { 583, 522 } },
    { 304410, 2, { 695, 438 } },
    { 304436, 2, { 629, 484 } },
    { 304440, 2, { 590, 516 } },
    { 304500, 2, { 580, 525 } },
    { 304515, 2, { 603, 505 } },
    { 304608, 2, { 608, 501 } },
    { 304836, 2, { 573, 532 } },
    { 304848, 2, { 584, 522 } },
    { 304850, 2, { 650, 469 } },
    { 304876, 2, { 572, 533 } },
    { 304880, 2, { 592, 515 } },
    { 304920, 2, { 605, 504 } },
    { 304950, 2, { 570, 535 } },
    { 304956, 2, { 591, 516 } },
    { 304980, 2, { 598, 510 } },
    { 304983, 2, { 721, 423 } },
    { 305016, 2, { 568, 537 } },
    { 305025, 2, { 581, 525 } },
    { 305040, 2, { 615, 496 } },
    { 305045, 2, { 845, 361 } },
    { 305064, 2, { 669, 456 } },
    { 305100, 2, { 565, 540 } },
    { 305136, 2, { 624, 489 } },
    { 305172, 2, { 588, 519 } },
    { 305184, 2, { 561, 544 } },
    { 305200, 2, { 560, 545 } },
    { 305214, 2, { 559, 546 } },
    { 305235, 2, { 595, 513 } },
    { 305244, 2, { 556, 549 } },
    { 305256, 2, { 553, 552 } },
    { 305270, 2, { 623, 490 } },
    { 305280, 2, { 576, 530 } },
    { 305283, 2, { 841, 363 } },
    { 305305, 2, { 671, 455 } },
    { 305312, 2, { 658, 464 } },
    { 305325, 2, { 575, 531 } },
    { 305424, 2, { 606, 504 } },
    { 305472, 2, { 592, 516 } },
    { 305500, 2, { 611, 500 } },
    { 305520, 2, { 570, 536 } },
    { 305532, 2, { 621, 492 } },
    { 305613, 2, { 567, 539 } },
    { 305655, 2, { 615, 497 } },
    { 305660, 2, { 580, 527 } },
    { 305664, 2, { 597, 512 } },
    { 305694, 2, { 629, 486 } },
    { 305704, 2, { 721, 424 } },
    { 305712, 2, { 579, 528 } },
    { 305748, 2, { 596, 513 } },
    { 305760, 2, { 560, 546 } },
    { 305762, 2, { 578, 529 } },
    { 305767, 2, { 847, 361 } },
    { 305856, 2, { 576, 531 } },
    { 305877, 2, { 713, 429 } },
    { 305910, 2, { 594, 515 } },
    { 305976, 2, { 627, 488 } },
    { 306000, 2, { 600, 510 } },
    { 306064, 2, { 592, 517 } },
    { 306075, 2, { 583, 525 } },
    { 306117, 2, { 791, 387 } },
    { 306152, 2, { 568, 539 } },
    { 306153, 2, { 621, 493 } },
    { 306160, 2, { 688, 445 } },
    { 306176, 2, { 598, 512 } },
    { 306180, 2, { 567, 540 } },
    { 306228, 2, { 604, 507 } },
    { 306240, 2, { 580, 528 } },
    { 306250, 2, { 625, 490 } },
    { 306252, 2, { 564, 543 } },
    { 306280, 2, { 589, 520 } },
    { 306299, 2, { 893, 343 } },
    { 306306, 2, { 561, 546 } },
    { 306324, 2, { 603, 508 } },
    { 306360, 2, { 555, 552 } },
    { 306372, 2, { 633, 484 } },
    { 306397, 2, { 637, 481 } },
    { 306432, 2, { 576, 532 } },
    { 306475, 2, { 575, 533 } },
    { 306495, 2, { 695, 441 } },
    { 306520, 2, { 632, 485 } },
    { 306528, 2, { 618, 496 } },
    { 306540, 2, { 585, 524 } },
    { 306600, 2, { 584, 525 } },
    { 306612, 2, { 612, 501 } },
    { 306680, 2, { 680, 451 } },
    { 306735, 2, { 605, 507 } },
    { 306768, 2, { 581, 528 } },
    { 306774, 2, { 598, 513 } },
    { 306816, 2, { 564, 544 } },
    { 306878, 2, { 638, 481 } },
    { 306900, 2, { 558, 550 } },
    { 306915, 2, { 555, 553 } },
    { 307008, 2, { 576, 533 } },
    { 307020, 2, { 595, 516 } },
    { 307040, 2, { 608, 505 } },
    { 307050, 2, { 575, 534 } },
    { 307092, 2, { 628, 489 } },
    { 307098, 2, { 594, 517 } },
    { 307128, 2, { 573, 536 } },
    { 307152, 2, { 632, 486 } },
    { 307164, 2, { 572, 537 } },
    { 307188, 2, { 636, 483 } },
    { 307200, 2, { 600, 512 } },
    { 307230, 2, { 570, 539 } },
    { 307248, 2, { 592, 519 } },
    { 307272, 2, { 651, 472 } },
    { 307296, 2, { 582, 528 } },
    { 307320, 2, { 591, 520 } },
    { 307328, 2, { 686, 448 } },
    { 307360, 2, { 565, 544 } },
    { 307377, 2, { 697, 441 } },
    { 307380, 2, { 564, 545 } },
    { 307428, 2, { 561, 548 } },
    { 307440, 2, { 560, 549 } },
    { 307450, 2, { 559, 550 } },
    { 307476, 2, { 657, 468 } },
    { 307500, 2, { 615, 500 } },
    { 307584, 2, { 576, 534 } },
    { 307615, 2, { 595, 517 } },
    { 307632, 2, { 624, 493 } },
    { 307648, 2, { 608, 506 } },
    { 307692, 2, { 594, 518 } },
    { 307740, 2, { 669, 460 } },
    { 307800, 2, { 570, 540 } },
    { 307824, 2, { 583, 528 } },
    { 307923, 2, { 651, 473 } },
    { 307930, 2, { 581, 530 } },
    { 307980, 2, { 580, 531 } },
    { 308000, 2, { 560, 550 } },
    { 308016, 2, { 558, 552 } },
    { 308028, 2, { 579, 532 } },
    { 308052, 2, { 597, 516 } },
    { 308125, 2, { 625, 493 } },
    { 308133, 2, { 603, 511 } },
    { 308140, 2, { 620, 497 } },
    { 308160, 2, { 576, 535 } },
    { 308200, 2, { 575, 536 } },
    { 308224, 2, { 602, 512 } },
    { 308250, 2, { 685, 450 } },
    { 308256, 2, { 608, 507 } },
    { 308275, 2, { 649, 475 } },
    { 308295, 2, { 585, 527 } },
    { 308308, 2, { 572, 539 } },
    { 308320, 2, { 656, 470 } },
    { 308357, 2, { 899, 343 } },
    { 308385, 2, { 623, 495 } },
    { 308424, 2, { 568, 543 } },
    { 308448, 2, { 567, 544 } },
    { 308484, 2, { 627, 492 } },
    { 308490, 2, { 565, 546 } },
    { 308511, 2, { 581, 531 } },
    { 308525, 2, { 1025, 301 } },
    { 308550, 2, { 561, 550 } },
    { 308560, 2, { 560, 551 } },
    { 308568, 2, { 559, 552 } },
    { 308574, 2, { 558, 553 } },
    { 308580, 2, { 556, 555 } },
    { 308610, 2, { 635, 486 } },
    { 308616, 2, { 616, 501 } },
    { 308637, 2, { 621, 497 } },
    { 308672, 2, { 689, 448 } },
    { 308688, 2, { 654, 472 } },
    { 308700, 2, { 588, 525 } },
    { 308750, 2, { 625, 494 } },
    { 308826, 2, { 602, 513 } },
    { 308880, 2, { 572, 540 } },
    { 308904, 2, { 633, 488 } },
    { 308924, 2, { 649, 476 } },
    { 309000, 2, { 600, 515 } },
    { 309008, 2, { 623, 496 } },
    { 309015, 2, { 567, 545 } },
    { 309024, 2, { 592, 522 } },
    { 309048, 2, { 632, 489 } },
    { 309111, 2, { 561, 551 } },
    { 309140, 2, { 580, 533 } },
    { 309168, 2, { 678, 456 } },
    { 309225, 2, { 589, 525 } },
    { 309276, 2, { 639, 484 } },
    { 309312, 2, { 576, 537 } },
    { 309320, 2, { 703, 440 } },
    { 309324, 2, { 596, 519 } },
    { 309372, 2, { 609, 508 } },
    { 309375, 2, { 625, 495 } },
    { 309400, 2, { 595, 520 } },
    { 309420, 2, { 573, 540 } },
    { 309465, 2, { 585, 529 } },
    { 309540, 2, { 660, 469 } },
    { 309560, 2, { 568, 545 } },
    { 309575, 2, { 725, 427 } },
    { 309582, 2, { 567, 546 } },
    { 309636, 2, { 564, 549 } },
    { 309672, 2, { 561, 552 } },
    { 309680, 2, { 560, 553 } },
    { 309684, 2, { 591, 524 } },
    { 309690, 2, { 558, 555 } },
    { 309760, 2, { 605, 512 } },
    { 309852, 2, { 604, 513 } },
    { 309876, 2, { 588, 527 } },
    { 309915, 2, { 639, 485 } },
    { 309925, 2, { 575, 539 } },
    { 309960, 2, { 574, 540 } },
    { 310002, 2, { 671, 462 } },
    { 310023, 2, { 703, 441 } },
    { 310080, 2, { 570, 544 } },
    { 310104, 2, { 584, 531 } },
    { 310128, 2, { 568, 546 } },
    { 310156, 2, { 583, 532 } },
    { 310185, 2, { 565, 549 } },
    { 310200, 2, { 564, 550 } },
    { 310245, 2, { 559, 555 } },
    { 310272, 2, { 606, 512 } },
    { 310284, 2, { 612, 507 } },
    { 310288, 2, { 656, 473 } },
    { 310310, 2, { 682, 455 } },
    { 310344, 2, { 579, 536 } },
    { 310365, 2, { 605, 513 } },
    { 310400, 2, { 640, 485 } },
    { 310416, 2, { 669, 464 } },
    { 310440, 2, { 597, 520 } },
    { 310464, 2, { 576, 539 } },
    { 310470, 2, { 655, 474 } },
    { 310500, 2, { 575, 540 } },
    { 310536, 2, { 681, 456 } },
    { 310545, 2, { 603, 515 } },
    { 310590, 2, { 595, 522 } },
    { 310596, 2, { 572, 543 } },
    { 310620, 2, { 620, 501 } },
    { 310625, 2, { 625, 497 } },
    { 310650, 2, { 570, 545 } },
    { 310675, 2, { 731, 425 } },
    { 310716, 2, { 567, 548 } },
    { 310726, 2, { 629, 494 } },
    { 310752, 2, { 624, 498 } },
    { 310800, 2, { 560, 555 } },
    { 310821, 2, { 779, 399 } },
    { 310856, 2, { 637, 488 } },
    { 310860, 2, { 628, 495 } },
    { 310960, 2, { 598, 520 } },
    { 310992, 2, { 589, 528 } },
    { 311004, 2, { 636, 489 } },
    { 311040, 2, { 576, 540 } },
    { 311052, 2, { 588, 529 } },
    { 311080, 2, { 616, 505 } },
    { 311148, 2, { 603, 516 } },
    { 311234, 2, { 602, 517 } },
    { 311250, 2, { 625, 498 } },
    { 311370, 2, { 582, 535 } },
    { 311400, 2, { 600, 519 } },
    { 311416, 2, { 581, 536 } },
    { 311436, 2, { 633, 492 } },
    { 311460, 2, { 580, 537 } },
    { 311472, 2, { 618, 504 } },
    { 311500, 2, { 623, 500 } },
    { 311520, 2, { 590, 528 } },
    { 311542, 2, { 578, 539 } },
    { 311600, 2, { 656, 475 } },
    { 311610, 2, { 611, 510 } },
    { 311640, 2, { 588, 530 } },
    { 311661, 2, { 679, 459 } },
    { 311688, 2, { 648, 481 } },
    { 311696, 2, { 616, 506 } },
    { 311710, 2, { 610, 511 } },
    { 311712, 2, { 573, 544 } },
    { 311787, 2, { 707, 441 } },
    { 311805, 2, { 585, 533 } },
    { 311808, 2, { 609, 512 } },
    { 311832, 2, { 568, 549 } },
    { 311850, 2, { 567, 550 } },
    { 311856, 2, { 584, 534 } },
    { 311880, 2, { 565, 552 } },
    { 311892, 2, { 564, 553 } },
    { 311904, 2, { 608, 513 } },
    { 311916, 2, { 561, 556 } },
    { 311922, 2, { 559, 558 } },
    { 311952, 2, { 582, 536 } },
    { 312015, 2, { 671, 465 } },
    { 312048, 2, { 591, 528 } },
    { 312075, 2, { 657, 475 } },
    { 312090, 2, { 606, 515 } },
    { 312120, 2, { 578, 540 } },
    { 312130, 2, { 637, 490 } },
    { 312180, 2, { 605, 516 } },
    { 312228, 2, { 588, 531 } },
    { 312256, 2, { 574, 544 } },
    { 312320, 2, { 610, 512 } },
    { 312375, 2, { 595, 525 } },
    { 312417, 2, { 567, 551 } },
    { 312420, 2, { 615, 508 } },
    { 312435, 2, { 655, 477 } },
    { 312440, 2, { 584, 535 } },
    { 312455, 2, { 715, 437 } },
    { 312480, 2, { 560, 558 } },
    { 312543, 2, { 693, 451 } },
    { 312550, 2, { 658, 475 } },
    { 312620, 2, { 580, 539 } },
    { 312624, 2, { 624, 501 } },
    { 312650, 2, { 650, 481 } },
    { 312660, 2, { 579, 540 } },
    { 312664, 2, { 646, 484 } },
    { 312732, 2, { 612, 511 } },
    { 312741, 2, { 729, 429 } },
    { 312750, 2, { 695, 450 } },
    { 312768, 2, { 576, 543 } },
    { 312800, 2, { 575, 544 } },
    { 312828, 2, { 597, 524 } },
    { 312832, 2, { 611, 512 } },
    { 312840, 2, { 632, 495 } },
    { 312900, 2, { 596, 525 } },
    { 312936, 2, { 663, 472 } },
    { 312960, 2, { 640, 489 } },
    { 312975, 2, { 585, 535 } },
    { 312984, 2, { 567, 552 } },
    { 312987, 2, { 867, 361 } },
    { 313020, 2, { 564, 555 } },
    { 313040, 2, { 560, 559 } },
    { 313092, 2, { 669, 468 } },
    { 313110, 2, { 630, 497 } },
    { 313120, 2, { 608, 515 } },
    { 313131, 2, { 651, 481 } },
    { 313170, 2, { 715, 438 } },
    { 313200, 2, { 580, 540 } },
    { 313225, 2, { 737, 425 } },
    { 313260, 2, { 681, 460 } },
    { 313280, 2, { 704, 445 } },
    { 313296, 2, { 642, 488 } },
    { 313348, 2, { 589, 532 } },
    { 313443, 2, { 611, 513 } },
    { 313467, 2, { 649, 483 } },
    { 313470, 2, { 645, 486 } },
    { 313476, 2, { 604, 519 } },
    { 313495, 2, { 689, 455 } },
    { 313551, 2, { 567, 553 } },
    { 313560, 2, { 585, 536 } },
    { 313565, 2, { 595, 527 } },
    { 313599, 2, { 561, 559 } },
    { 313605, 2, { 621, 505 } },
    { 313608, 2, { 584, 537 } },
    { 313632, 2, { 594, 528 } },
    { 313728, 2, { 608, 516 } },
    { 313740, 2, { 581, 540 } },
    { 313760, 2, { 592, 530 } },
    { 313845, 2, { 735, 427 } },
    { 313875, 2, { 675, 465 } },
    { 313920, 2, { 576, 545 } },
    { 313950, 2, { 575, 546 } },
    { 313956, 2, { 612, 513 } },
    { 313968, 2, { 633, 496 } },
    { 314004, 2, { 573, 548 } },
    { 314028, 2, { 572, 549 } },
    { 314041, 2, { 637, 493 } },
    { 314070, 2, { 570, 551 } },
    { 314104, 2, { 568, 553 } },
    { 314160, 2, { 561, 560 } },
    { 314226, 2, { 594, 529 } },
    { 314237, 2, { 583, 539 } },
    { 314244, 2, { 602, 522 } },
    { 314265, 2, { 615, 511 } },
    { 314325, 2, { 635, 495 } },
    { 314336, 2, { 608, 517 } },
    { 314340, 2, { 620, 507 } },
    { 314352, 2, { 592, 531 } },
    { 314388, 2, { 639, 492 } },
    { 314412, 2, { 591, 532 } },
    { 314415, 2, { 685, 459 } },
    { 314496, 2, { 576, 546 } },
    { 314500, 2, { 629, 500 } },
    { 314545, 2, { 665, 473 } },
    { 314580, 2, { 588, 535 } },
    { 314592, 2, { 678, 464 } },
    { 314600, 2, { 572, 550 } },
    { 314628, 2, { 628, 501 } },
    { 314640, 2, { 570, 552 } },
    { 314650, 2, { 725, 434 } },
    { 314678, 2, { 637, 494 } },
    { 314685, 2, { 567, 555 } },
    { 314736, 2, { 632, 498 } },
    { 314755, 2, { 595, 529 } },
    { 314760, 2, { 610, 516 } },
    { 314776, 2, { 584, 539 } },
    { 314820, 2, { 583, 540 } },
    { 314853, 2, { 609, 517 } },
    { 314874, 2, { 686, 459 } },
    { 314880, 2, { 615, 512 } },
    { 314916, 2, { 644, 489 } },
    { 314940, 2, { 580, 543 } },
    { 314976, 2, { 579, 544 } },
    { 315000, 2, { 600, 525 } },
    { 315018, 2, { 666, 473 } },
    { 315056, 2, { 679, 464 } },
    { 315084, 2, { 651, 484 } },
    { 315120, 2, { 606, 520 } },
    { 315146, 2, { 598, 527 } },
    { 315172, 2, { 572, 551 } },
    { 315180, 2, { 612, 515 } },
    { 315210, 2, { 570, 553 } },
    { 315216, 2, { 597, 528 } },
    { 315240, 2, { 568, 555 } },
    { 315252, 2, { 567, 556 } },
    { 315270, 2, { 565, 558 } },
    { 315315, 2, { 585, 539 } },
    { 315392, 2, { 616, 512 } },
    { 315400, 2, { 664, 475 } },
    { 315425, 2, { 775, 407 } },
    { 315456, 2, { 636, 496 } },
    { 315468, 2, { 621, 508 } },
    { 315495, 2, { 615, 513 } },
    { 315520, 2, { 580, 544 } },
    { 315536, 2, { 592, 533 } },
    { 315549, 2, { 783, 403 } },
    { 315552, 2, { 608, 519 } },
    { 315588, 2, { 578, 546 } },
    { 315675, 2, { 575, 549 } },
    { 315700, 2, { 574, 550 } },
    { 315756, 2, { 588, 537 } },
    { 315768, 2, { 669, 472 } },
    { 315810, 2, { 605, 522 } },
    { 315840, 2, { 564, 560 } },
    { 315900, 2, { 585, 540 } },
    { 315945, 2, { 595, 531 } },
    { 315952, 2, { 637, 496 } },
    { 315972, 2, { 603, 524 } },
    { 315984, 2, { 681, 464 } },
    { 316008, 2, { 594, 532 } },
    { 316020, 2, { 687, 460 } },
    { 316030, 2, { 715, 442 } },
    { 316050, 2, { 602, 525 } },
    { 316064, 2, { 581, 544 } },
    { 316092, 2, { 636, 497 } },
    { 316128, 2, { 592, 534 } },
    { 316200, 2, { 600, 527 } },
    { 316224, 2, { 576, 549 } },
    { 316230, 2, { 635, 498 } },
    { 316296, 2, { 573, 552 } },
    { 316368, 2, { 624, 507 } },
    { 316395, 2, { 711, 445 } },
    { 316400, 2, { 565, 560 } },
    { 316404, 2, { 564, 561 } },
    { 316416, 2, { 618, 512 } },
    { 316470, 2, { 685, 462 } },
    { 316476, 2, { 596, 531 } },
    { 316498, 2, { 611, 518 } },
    { 316500, 2, { 633, 500 } },
    { 316602, 2, { 594, 533 } },
    { 316608, 2, { 582, 544 } },
    { 316632, 2, { 632, 501 } },
    { 316720, 2, { 592, 535 } },
    { 316736, 2, { 707, 448 } },
    { 316776, 2, { 591, 536 } },
    { 316800, 2, { 576, 550 } },
    { 316820, 2, { 620, 511 } },
    { 316825, 2, { 575, 551 } },
    { 316827, 2, { 749, 423 } },
    { 316848, 2, { 574, 552 } },
    { 316872, 2, { 648, 489 } },
    { 316875, 2, { 625, 507 } },
    { 316932, 2, { 588, 539 } },
    { 316944, 2, { 568, 558 } },
    { 316953, 2, { 567, 559 } },
    { 317016, 2, { 612, 518 } },
    { 317100, 2, { 604, 525 } },
    { 317112, 2, { 584, 543 } },
    { 317115, 2, { 729, 435 } },
    { 317135, 2, { 595, 533 } },
    { 317152, 2, { 583, 544 } },
    { 317190, 2, { 582, 545 } },
    { 317205, 2, { 665, 477 } },
    { 317240, 2, { 616, 515 } },
    { 317250, 2, { 675, 470 } },
    { 317275, 2, { 925, 343 } },
    { 317292, 2, { 579, 548 } },
    { 317331, 2, { 621, 511 } },
    { 317340, 2, { 615, 516 } },
    { 317376, 2, { 576, 551 } },
    { 317400, 2, { 575, 552 } },
    { 317440, 2, { 620, 512 } },
    { 317460, 2, { 572, 555 } },
    { 317471, 2, { 589, 539 } },
    { 317475, 2, { 747, 425 } },
    { 317492, 2, { 644, 493 } },
    { 317520, 2, { 567, 560 } },
    { 317550, 2, { 725, 438 } },
    { 317604, 2, { 597, 532 } },
    { 317625, 2, { 605, 525 } },
    { 317628, 2, { 612, 519 } },
    { 317680, 2, { 722, 440 } },
    { 317688, 2, { 651, 488 } },
    { 317720, 2, { 611, 520 } },
    { 317730, 2, { 595, 534 } },
    { 317790, 2, { 594, 535 } },
    { 317856, 2, { 602, 528 } },
    { 317900, 2, { 578, 550 } },
    { 317904, 2, { 592, 537 } },
    { 317952, 2, { 576, 552 } },
    { 317955, 2, { 615, 517 } },
    { 317961, 2, { 721, 441 } },
    { 317975, 2, { 575, 553 } },
    { 317988, 2, { 657, 484 } },
    { 318000, 2, { 600, 530 } },
    { 318010, 2, { 590, 539 } },
    { 318087, 2, { 567, 561 } },
    { 318136, 2, { 598, 532 } },
    { 318160, 2, { 656, 485 } },
    { 318240, 2, { 585, 544 } },
    { 318274, 2, { 629, 506 } },
    { 318280, 2, { 584, 545 } },
    { 318304, 2, { 686, 464 } },
    { 318318, 2, { 583, 546 } },
    { 318330, 2, { 655, 486 } },
    { 318384, 2, { 594, 536 } },
    { 318396, 2, { 628, 507 } },
    { 318402, 2, { 722, 441 } },
    { 318420, 2, { 580, 549 } },
    { 318432, 2, { 642, 496 } },
    { 318444, 2, { 669, 476 } },
    { 318472, 2, { 616, 517 } },
    { 318478, 2, { 578, 551 } },
    { 318500, 2, { 637, 500 } },
    { 318516, 2, { 627, 508 } },
    { 318528, 2, { 576, 553 } },
    { 318570, 2, { 574, 555 } },
    { 318588, 2, { 573, 556 } },
    { 318600, 2, { 590, 540 } },
    { 318630, 2, { 570, 559 } },
    { 318636, 2, { 636, 501 } },
    { 318645, 2, { 657, 485 } },
    { 318648, 2, { 568, 561 } },
    { 318660, 2, { 565, 564 } },
    { 318681, 2, { 783, 407 } },
    { 318708, 2, { 681, 468 } },
    { 318720, 2, { 640, 498 } },
    { 318725, 2, { 671, 475 } },
    { 318750, 2, { 625, 510 } },
    { 318768, 2, { 687, 464 } },
    { 318780, 2, { 630, 506 } },
    { 318801, 2, { 799, 399 } },
    { 318825, 2, { 585, 545 } },
    { 318835, 2, { 605, 527 } },
    { 318864, 2, { 584, 546 } },
    { 318903, 2, { 629, 507 } },
    { 318920, 2, { 595, 536 } },
    { 318942, 2, { 611, 522 } },
    { 318969, 2, { 581, 549 } },
    { 318976, 2, { 623, 512 } },
    { 319005, 2, { 695, 459 } },
    { 319032, 2, { 633, 504 } },
    { 319088, 2, { 592, 539 } },
    { 319116, 2, { 609, 524 } },
    { 319140, 2, { 591, 540 } },
    { 319152, 2, { 654, 488 } },
    { 319160, 2, { 632, 505 } },
    { 319200, 2, { 570, 560 } },
    { 319284, 2, { 588, 543 } },
    { 319308, 2, { 649, 492 } },
    { 319319, 2, { 847, 377 } },
    { 319375, 2, { 625, 511 } },
    { 319396, 2, { 671, 476 } },
    { 319440, 2, { 605, 528 } },
    { 319488, 2, { 624, 512 } },
    { 319500, 2, { 639, 500 } },
    { 319550, 2, { 581, 550 } },
    { 319599, 2, { 623, 513 } },
    { 319608, 2, { 579, 552 } },
    { 319680, 2, { 576, 555 } },
    { 319696, 2, { 689, 464 } },
    { 319704, 2, { 616, 519 } },
    { 319725, 2, { 609, 525 } },
    { 319748, 2, { 572, 559 } },
    { 319788, 2, { 567, 564 } },
    { 319800, 2, { 600, 533 } },
    { 319815, 2, { 621, 515 } },
    { 319865, 2, { 665, 481 } },
    { 319872, 2, { 588, 544 } },
    { 319923, 2, { 697, 459 } },
    { 319968, 2, { 606, 528 } },
    { 319992, 2, { 597, 536 } },
    { 320000, 2, { 625, 512 } },
    { 320016, 2, { 678, 472 } },
    { 320045, 2, { 605, 529 } },
    { 320052, 2, { 596, 537 } },
    { 320075, 2, { 775, 413 } },
    { 320112, 2, { 624, 513 } },
    { 320160, 2, { 580, 552 } },
    { 320166, 2, { 594, 539 } },
    { 320292, 2, { 574, 558 } },
    { 320320, 2, { 572, 560 } },
    { 320355, 2, { 567, 565 } },
    { 320385, 2, { 689, 465 } },
    { 320400, 2, { 600, 534 } },
    { 320416, 2, { 589, 544 } },
    { 320424, 2, { 632, 507 } },
    { 320436, 2, { 621, 516 } },
    { 320450, 2, { 650, 493 } },
    { 320460, 2, { 588, 545 } },
    { 320488, 2, { 679, 472 } },
    { 320540, 2, { 620, 517 } },
    { 320565, 2, { 645, 497 } },
    { 320568, 2, { 703, 456 } },
    { 320580, 2, { 585, 548 } },
    { 320595, 2, { 737, 435 } },
    { 320616, 2, { 584, 549 } },
    { 320620, 2, { 697, 460 } },
    { 320625, 2, { 625, 513 } },
    { 320640, 2, { 640, 501 } },
    { 320650, 2, { 583, 550 } },
    { 320712, 2, { 581, 552 } },
    { 320724, 2, { 604, 531 } },
    { 320740, 2, { 580, 553 } },
    { 320775, 2, { 611, 525 } },
    { 320796, 2, { 603, 532 } },
    { 320850, 2, { 575, 558 } },
    { 320866, 2, { 574, 559 } },
    { 320880, 2, { 573, 560 } },
    { 320892, 2, { 572, 561 } },
    { 320920, 2, { 568, 565 } },
    { 320943, 2, { 609, 527 } },
    { 320960, 2, { 590, 544 } },
    { 321000, 2, { 600, 535 } },
    { 321030, 2, { 615, 522 } },
    { 321057, 2, { 621, 517 } },
    { 321090, 2, { 695, 462 } },
    { 321100, 2, { 650, 494 } },
    { 321120, 2, { 669, 480 } },
    { 321160, 2, { 620, 518 } },
    { 321255, 2, { 605, 531 } },
    { 321264, 2, { 582, 552 } },
    { 321300, 2, { 595, 540 } },
    { 321360, 2, { 618, 520 } },
    { 321408, 2, { 576, 558 } },
    { 321425, 2, { 575, 559 } },
    { 321432, 2, { 681, 472 } },
    { 321440, 2, { 574, 560 } },
    { 321456, 2, { 592, 543 } },
    { 321504, 2, { 591, 544 } },
    { 321516, 2, { 687, 468 } },
    { 321552, 2, { 609, 528 } },
    { 321564, 2, { 633, 508 } },
    { 321594, 2, { 589, 546 } },
    { 321632, 2, { 608, 529 } },
    { 321640, 2, { 680, 473 } },
    { 321678, 2, { 621, 518 } },
    { 321780, 2, { 620, 519 } },
    { 321816, 2, { 583, 552 } },
    { 321900, 2, { 580, 555 } },
    { 321904, 2, { 649, 496 } },
    { 321924, 2, { 579, 556 } },
    { 321930, 2, { 630, 511 } },
    { 321984, 2, { 576, 559 } },
    { 322000, 2, { 575, 560 } },
    { 322040, 2, { 664, 485 } },
    { 322050, 2, { 570, 565 } },
    { 322056, 2, { 568, 567 } },
    { 322080, 2, { 610, 528 } },
    { 322164, 2, { 628, 513 } },
    { 322200, 2, { 600, 537 } },
    { 322218, 2, { 663, 486 } },
    { 322240, 2, { 608, 530 } },
    { 322245, 2, { 651, 495 } },
    { 322260, 2, { 615, 524 } },
    { 322320, 2, { 632, 510 } },
    { 322322, 2, { 598, 539 } },
    { 322335, 2, { 585, 551 } },
    { 322371, 2, { 731, 441 } },
    { 322380, 2, { 597, 540 } },
    { 322452, 2, { 636, 507 } },
    { 322455, 2, { 581, 555 } },
    { 322465, 2, { 605, 533 } },
    { 322500, 2, { 625, 516 } },
    { 322560, 2, { 576, 560 } },
    { 322605, 2, { 603, 535 } },
    { 322640, 2, { 592, 545 } },
    { 322644, 2, { 644, 501 } },
    { 322677, 2, { 629, 513 } },
    { 322695, 2, { 639, 505 } },
    { 322704, 2, { 648, 498 } },
    { 322740, 2, { 652, 495 } },
    { 322749, 2, { 763, 423 } },
    { 322812, 2, { 588, 549 } },
    { 322848, 2, { 608, 531 } },
    { 322896, 2, { 651, 496 } },
    { 322920, 2, { 585, 552 } },
    { 322952, 2, { 584, 553 } },
    { 323000, 2, { 646, 500 } },
    { 323008, 2, { 721, 448 } },
    { 323050, 2, { 650, 497 } },
    { 323070, 2, { 605, 534 } },
    { 323125, 2, { 625, 517 } },
    { 323136, 2, { 576, 561 } },
    { 323172, 2, { 573, 564 } },
    { 323190, 2, { 570, 567 } },
    { 323200, 2, { 640, 505 } },
    { 323208, 2, { 603, 536 } },
    { 323232, 2, { 592, 546 } },
    { 323244, 2, { 657, 492 } },
    { 323323, 2, { 1001, 323 } },
    { 323360, 2, { 688, 470 } },
    { 323380, 2, { 703, 460 } },
    { 323400, 2, { 588, 550 } },
    { 323449, 2, { 943, 343 } },
    { 323505, 2, { 585, 553 } },
    { 323532, 2, { 627, 516 } },
    { 323544, 2, { 663, 488 } },
    { 323565, 2, { 583, 555 } },
    { 323568, 2, { 642, 504 } },
    { 323595, 2, { 705, 459 } },
    { 323628, 2, { 596, 543 } },
    { 323680, 2, { 578, 560 } },
    { 323730, 2, { 594, 545 } },
    { 323748, 2, { 612, 529 } },
    { 323750, 2, { 625, 518 } },
    { 323760, 2, { 570, 568 } },
    { 323785, 2, { 841, 385 } },
    { 323796, 2, { 669, 484 } },
    { 323817, 2, { 741, 437 } },
    { 323840, 2, { 640, 506 } },
    { 323850, 2, { 635, 510 } },
    { 323856, 2, { 624, 519 } },
    { 323868, 2, { 591, 548 } },
    { 323883, 2, { 679, 477 } },
    { 323950, 2, { 589, 550 } },
    { 323960, 2, { 623, 520 } },
    { 323988, 2, { 588, 551 } },
    { 324064, 2, { 608, 533 } },
    { 324093, 2, { 671, 483 } },
    { 324096, 2, { 633, 512 } },
    { 324120, 2, { 584, 555 } },
    { 324156, 2, { 681, 476 } },
    { 324198, 2, { 581, 558 } },
    { 324210, 2, { 606, 535 } },
    { 324216, 2, { 632, 513 } },
    { 324220, 2, { 580, 559 } },
    { 324225, 2, { 655, 495 } },
    { 324240, 2, { 579, 560 } },
    { 324264, 2, { 687, 472 } },
    { 324280, 2, { 605, 536 } },
    { 324300, 2, { 575, 564 } },
    { 324324, 2, { 572, 567 } },
    { 324348, 2, { 604, 537 } },
    { 324360, 2, { 612, 530 } },
    { 324384, 2, { 654, 496 } },
    { 324405, 2, { 729, 445 } },
    { 324415, 2, { 713, 455 } },
    { 324513, 2, { 707, 459 } },
    { 324597, 2, { 609, 533 } },
    { 324612, 2, { 639, 508 } },
    { 324625, 2, { 875, 371 } },
    { 324632, 2, { 616, 527 } },
    { 324648, 2, { 648, 501 } },
    { 324672, 2, { 608, 534 } },
    { 324690, 2, { 685, 474 } },
    { 324720, 2, { 615, 528 } },
    { 324768, 2, { 597, 544 } },
    { 324816, 2, { 606, 536 } },
    { 324864, 2, { 576, 564 } },
    { 324870, 2, { 595, 546 } },
    { 324972, 2, { 612, 531 } },
    { 324996, 2, { 636, 511 } },
    { 325000, 2, { 625, 520 } },
    { 325008, 2, { 592, 549 } },
    { 325017, 2, { 603, 539 } },
    { 325052, 2, { 611, 532 } },
    { 325080, 2, { 602, 540 } },
    { 325120, 2, { 635, 512 } },
    { 325128, 2, { 589, 552 } },
    { 325164, 2, { 588, 553 } },
    { 325260, 2, { 585, 556 } },
    { 325280, 2, { 608, 535 } },
    { 325312, 2, { 598, 544 } },
    { 325314, 2, { 583, 558 } },
    { 325360, 2, { 581, 560 } },
    { 325380, 2, { 580, 561 } },
    { 325404, 2, { 621, 524 } },
    { 325440, 2, { 576, 565 } },
    { 325458, 2, { 574, 567 } },
    { 325464, 2, { 573, 568 } },
    { 325480, 2, { 632, 515 } },
    { 325500, 2, { 620, 525 } },
    { 325584, 2, { 612, 532 } },
    { 325600, 2, { 592, 550 } },
    { 325620, 2, { 603, 540 } },
    { 325632, 2, { 636, 512 } },
    { 325680, 2, { 590, 552 } },
    { 325703, 2, { 833, 391 } },
    { 325710, 2, { 630, 517 } },
    { 325728, 2, { 624, 522 } },
    { 325755, 2, { 635, 513 } },
    { 325800, 2, { 600, 543 } },
    { 325864, 2, { 616, 529 } },
    { 325872, 2, { 584, 558 } },
    { 325920, 2, { 582, 560 } },
    { 325932, 2, { 628, 519 } },
    { 325975, 2, { 767, 425 } },
    { 325983, 2, { 817, 399 } },
    { 326025, 2, { 575, 567 } },
    { 326144, 2, { 637, 512 } },
    { 326190, 2, { 655, 498 } },
    { 326196, 2, { 612, 533 } },
    { 326232, 2, { 591, 552 } },
    { 326250, 2, { 625, 522 } },
    { 326268, 2, { 636, 513 } },
    { 326270, 2, { 590, 553 } },
    { 326304, 2, { 618, 528 } },
    { 326337, 2, { 899, 363 } },
    { 326340, 2, { 588, 555 } },
    { 326368, 2, { 658, 496 } },
    { 326400, 2, { 600, 544 } },
    { 326424, 2, { 609, 536 } },
    { 326472, 2, { 669, 488 } },
    { 326480, 2, { 583, 560 } },
    { 326496, 2, { 608, 537 } },
    { 326508, 2, { 598, 546 } },
    { 326529, 2, { 639, 511 } },
    { 326556, 2, { 579, 564 } },
    { 326592, 2, { 576, 567 } },
    { 326600, 2, { 575, 568 } },
    { 326625, 2, { 871, 375 } },
    { 326628, 2, { 633, 516 } },
    { 326652, 2, { 652, 501 } },
    { 326655, 2, { 595, 549 } },
    { 326656, 2, { 638, 512 } },
    { 326688, 2, { 656, 498 } },
    { 326700, 2, { 594, 550 } },
    { 326745, 2, { 685, 477 } },
    { 326781, 2, { 637, 513 } },
    { 326800, 2, { 688, 475 } },
    { 326830, 2, { 667, 490 } },
    { 326859, 2, { 663, 493 } },
    { 326880, 2, { 681, 480 } },
    { 326975, 2, { 725, 451 } },
    { 327000, 2, { 600, 545 } },
    { 327012, 2, { 687, 476 } },
    { 327015, 2, { 585, 559 } },
    { 327075, 2, { 623, 525 } },
    { 327080, 2, { 629, 520 } },
    { 327096, 2, { 616, 531 } },
    { 327132, 2, { 699, 468 } },
    { 327156, 2, { 597, 548 } },
    { 327180, 2, { 574, 570 } },
    { 327204, 2, { 596, 549 } },
    { 327228, 2, { 737, 444 } },
    { 327250, 2, { 595, 550 } },
    { 327267, 2, { 621, 527 } },
    { 327275, 2, { 689, 475 } },
    { 327294, 2, { 594, 551 } },
    { 327360, 2, { 620, 528 } },
    { 327375, 2, { 675, 485 } },
    { 327376, 2, { 592, 553 } },
    { 327420, 2, { 612, 535 } },
    { 327488, 2, { 602, 544 } },
    { 327522, 2, { 646, 507 } },
    { 327600, 2, { 585, 560 } },
    { 327624, 2, { 584, 561 } },
    { 327635, 2, { 805, 407 } },
    { 327660, 2, { 635, 516 } },
    { 327684, 2, { 581, 564 } },
    { 327712, 2, { 608, 539 } },
    { 327726, 2, { 578, 567 } },
    { 327750, 2, { 575, 570 } },
    { 327756, 2, { 573, 572 } },
    { 327789, 2, { 693, 473 } },
    { 327845, 2, { 595, 551 } },
    { 327888, 2, { 594, 552 } },
    { 327964, 2, { 689, 476 } },
    { 327972, 2, { 604, 543 } },
    { 328008, 2, { 632, 519 } },
    { 328020, 2, { 660, 497 } },
    { 328032, 2, { 603, 544 } },
    { 328042, 2, { 682, 481 } },
    { 328048, 2, { 707, 464 } },
    { 328050, 2, { 675, 486 } },
    { 328185, 2, { 585, 561 } },
    { 328320, 2, { 576, 570 } },
    { 328335, 2, { 795, 413 } },
    { 328338, 2, { 629, 522 } },
    { 328440, 2, { 595, 552 } },
    { 328482, 2, { 594, 553 } },
    { 328500, 2, { 657, 500 } },
    { 328536, 2, { 648, 507 } },
    { 328548, 2, { 627, 524 } },
    { 328560, 2, { 592, 555 } },
    { 328596, 2, { 591, 556 } },
    { 328635, 2, { 603, 545 } },
    { 328644, 2, { 612, 537 } },
    { 328656, 2, { 656, 501 } },
    { 328692, 2, { 588, 559 } },
    { 328704, 2, { 642, 512 } },
    { 328757, 2, { 1331, 247 } },
    { 328779, 2, { 729, 451 } },
    { 328790, 2, { 610, 539 } },
    { 328812, 2, { 583, 564 } },
    { 328830, 2, { 582, 565 } },
    { 328848, 2, { 624, 527 } },
    { 328860, 2, { 580, 567 } },
    { 328872, 2, { 579, 568 } },
    { 328944, 2, { 616, 534 } },
    { 329000, 2, { 658, 500 } },
    { 329085, 2, { 639, 515 } },
    { 329120, 2, { 605, 544 } },
    { 329130, 2, { 621, 530 } },
    { 329148, 2, { 669, 492 } },
    { 329160, 2, { 633, 520 } },
    { 329175, 2, { 627, 525 } },
    { 329220, 2, { 590, 558 } },
    { 329280, 2, { 588, 560 } },
    { 329329, 2, { 611, 539 } },
    { 329375, 2, { 625, 527 } },
    { 329400, 2, { 600, 549 } },
    { 329427, 2, { 581, 567 } },
    { 329430, 2, { 695, 474 } },
    { 329472, 2, { 576, 572 } },
    { 329498, 2, { 598, 551 } },
    { 329544, 2, { 597, 552 } },
    { 329560, 2, { 616, 535 } },
    { 329595, 2, { 645, 511 } },
    { 329600, 2, { 640, 515 } },
    { 329604, 2, { 681, 484 } },
    { 329616, 2, { 654, 504 } },
    { 329623, 2, { 961, 343 } },
    { 329640, 2, { 615, 536 } },
    { 329664, 2, { 606, 544 } },
    { 329670, 2, { 594, 555 } },
    { 329700, 2, { 628, 525 } },
    { 329724, 2, { 639, 516 } },
    { 329728, 2, { 644, 512 } },
    { 329760, 2, { 687, 480 } },
    { 329800, 2, { 680, 485 } },
    { 329840, 2, { 589, 560 } },
    { 329868, 2, { 588, 561 } },
    { 329904, 2, { 632, 522 } },
    { 329928, 2, { 699, 472 } },
    { 329940, 2, { 585, 564 } },
    { 329960, 2, { 584, 565 } },
    { 330000, 2, { 600, 550 } },
    { 330008, 2, { 581, 568 } },
    { 330048, 2, { 576, 573 } },
    { 330050, 2, { 575, 574 } },
    { 330084, 2, { 636, 519 } },
    { 330132, 2, { 671, 492 } },
    { 330144, 2, { 608, 543 } },
    { 330165, 2, { 667, 495 } },
    { 330190, 2, { 623, 530 } },
    { 330200, 2, { 635, 520 } },
    { 330240, 2, { 640, 516 } },
    { 330270, 2, { 606, 545 } },
    { 330309, 2, { 749, 441 } },
    { 330330, 2, { 605, 546 } },
    { 330336, 2, { 592, 558 } },
    { 330372, 2, { 621, 532 } },
    { 330395, 2, { 845, 391 } },
    { 330400, 2, { 590, 560 } },
    { 330429, 2, { 589, 561 } },
    { 330444, 2, { 603, 548 } },
    { 330460, 2, { 620, 533 } },
    { 330525, 2, { 585, 565 } },
    { 330561, 2, { 583, 567 } },
    { 330564, 2, { 652, 507 } },
    { 330576, 2, { 582, 568 } },
    { 330616, 2, { 578, 572 } },
    { 330624, 2, { 576, 574 } },
    { 330630, 2, { 618, 535 } },
    { 330645, 2, { 705, 469 } },
    { 330660, 2, { 660, 501 } },
    { 330708, 2, { 651, 508 } },
    { 330720, 2, { 624, 530 } },
    { 330780, 2, { 596, 555 } },
    { 330792, 2, { 616, 537 } },
    { 330813, 2, { 623, 531 } },
    { 330864, 2, { 678, 488 } },
    { 330880, 2, { 640, 517 } },
    { 330885, 2, { 645, 513 } },
    { 330925, 2, { 775, 427 } },
    { 330928, 2, { 592, 559 } },
    { 330939, 2, { 721, 459 } },
    { 330960, 2, { 591, 560 } },
    { 330993, 2, { 621, 533 } },
    { 331056, 2, { 627, 528 } },
    { 331075, 2, { 697, 475 } },
    { 331100, 2, { 602, 550 } },
    { 331128, 2, { 584, 567 } },
    { 331170, 2, { 581, 570 } },
    { 331177, 2, { 847, 391 } },
    { 331188, 2, { 579, 572 } },
    { 331200, 2, { 576, 575 } },
    { 331240, 2, { 637, 520 } },
    { 331248, 2, { 618, 536 } },
    { 331280, 2, { 656, 505 } },
    { 331296, 2, { 609, 544 } },
    { 331344, 2, { 624, 531 } },
    { 331352, 2, { 679, 488 } },
    { 331360, 2, { 608, 545 } },
    { 331470, 2, { 635, 522 } },
    { 331485, 2, { 615, 539 } },
    { 331515, 2, { 695, 477 } },
    { 331596, 2, { 604, 549 } },
    { 331683, 2, { 627, 529 } },
    { 331692, 2, { 633, 524 } },
    { 331695, 2, { 585, 567 } },
    { 331785, 2, { 657, 505 } },
    { 331800, 2, { 600, 553 } },
    { 331824, 2, { 669, 496 } },
    { 331840, 2, { 610, 544 } },
    { 331875, 2, { 625, 531 } },
    { 331925, 2, { 781, 425 } },
    { 331932, 2, { 597, 556 } },
    { 331968, 2, { 608, 546 } },
    { 332010, 2, { 595, 558 } },
    { 332046, 2, { 594, 559 } },
    { 332052, 2, { 708, 469 } },
    { 332100, 2, { 615, 540 } },
    { 332112, 2, { 592, 561 } },
    { 332145, 2, { 605, 549 } },
    { 332150, 2, { 650, 511 } },
    { 332160, 2, { 640, 519 } },
    { 332220, 2, { 588, 565 } },
    { 332235, 2, { 621, 535 } },
    { 332280, 2, { 585, 568 } },
    { 332288, 2, { 649, 512 } },
    { 332304, 2, { 602, 552 } },
    { 332310, 2, { 583, 570 } },
    { 332316, 2, { 612, 543 } },
    { 332328, 2, { 681, 488 } },
    { 332340, 2, { 580, 573 } },
    { 332384, 2, { 611, 544 } },
    { 332415, 2, { 747, 445 } },
    { 332416, 2, { 742, 448 } },
    { 332424, 2, { 648, 513 } },
    { 332500, 2, { 625, 532 } },
    { 332508, 2, { 687, 484 } },
    { 332592, 2, { 624, 533 } },
    { 332605, 2, { 595, 559 } },
    { 332640, 2, { 594, 560 } },
    { 332664, 2, { 664, 501 } },
    { 332710, 2, { 679, 490 } },
    { 332724, 2, { 699, 476 } },
    { 332760, 2, { 590, 564 } },
    { 332775, 2, { 675, 493 } },
    { 332787, 2, { 689, 483 } },
    { 332800, 2, { 640, 520 } },
    { 332816, 2, { 671, 496 } },
    { 332820, 2, { 645, 516 } },
    { 332856, 2, { 603, 552 } },
    { 332878, 2, { 767, 434 } },
    { 332880, 2, { 584, 570 } },
    { 332910, 2, { 685, 486 } },
    { 332920, 2, { 580, 574 } },
    { 332928, 2, { 578, 576 } },
    { 332940, 2, { 620, 537 } },
    { 332948, 2, { 644, 517 } },
    { 332990, 2, { 670, 497 } },
    { 333000, 2, { 600, 555 } },
    { 333125, 2, { 625, 533 } },
    { 333200, 2, { 595, 560 } },
    { 333216, 2, { 624, 534 } },
    { 333234, 2, { 594, 561 } },
    { 333268, 2, { 676, 493 } },
    { 333270, 2, { 630, 529 } },
    { 333312, 2, { 651, 512 } },
    { 333324, 2, { 591, 564 } },
    { 333333, 2, { 693, 481 } },
    { 333355, 2, { 605, 551 } },
    { 333396, 2, { 588, 567 } },
    { 333459, 2, { 603, 553 } },
    { 333465, 2, { 645, 517 } },
    { 333468, 2, { 628, 531 } },
    { 333504, 2, { 579, 576 } },
    { 333540, 2, { 612, 545 } },
    { 333564, 2, { 627, 532 } },
    { 333606, 2, { 611, 546 } },
    { 333645, 2, { 767, 435 } },
    { 333680, 2, { 688, 485 } },
    { 333704, 2, { 707, 472 } },
    { 333732, 2, { 609, 548 } },
    { 333740, 2, { 740, 451 } },
    { 333750, 2, { 625, 534 } },
    { 333756, 2, { 657, 508 } },
    { 333792, 2, { 608, 549 } },
    { 333840, 2, { 624, 535 } },
    { 333888, 2, { 592, 564 } },
    { 333900, 2, { 630, 530 } },
    { 333925, 2, { 703, 475 } },
    { 333928, 2, { 623, 536 } },
    { 333960, 2, { 605, 552 } },
    { 333963, 2, { 589, 567 } },
    { 334050, 2, { 655, 510 } },
    { 334075, 2, { 581, 575 } },
    { 334080, 2, { 580, 576 } },
    { 334110, 2, { 602, 555 } },
    { 334180, 2, { 620, 539 } },
    { 334191, 2, { 627, 533 } },
    { 334224, 2, { 633, 528 } },
    { 334236, 2, { 644, 519 } },
    { 334305, 2, { 765, 437 } },
    { 334320, 2, { 597, 560 } },
    { 334356, 2, { 596, 561 } },
    { 334400, 2, { 608, 550 } },
    { 334425, 2, { 637, 525 } },
    { 334476, 2, { 652, 513 } },
    { 334480, 2, { 592, 565 } },
    { 334488, 2, { 616, 543 } },
    { 334500, 2, { 669, 500 } },
    { 334512, 2, { 606, 552 } },
    { 334530, 2, { 590, 567 } },
    { 334544, 2, { 721, 464 } },
    { 334560, 2, { 615, 544 } },
    { 334593, 2, { 791, 423 } },
    { 334620, 2, { 585, 572 } },
    { 334628, 2, { 629, 532 } },
    { 334632, 2, { 584, 573 } },
    { 334642, 2, { 583, 574 } },
    { 334650, 2, { 582, 575 } },
    { 334656, 2, { 581, 576 } },
    { 334719, 2, { 621, 539 } },
    { 334776, 2, { 696, 481 } },
    { 334800, 2, { 600, 558 } },
    { 334836, 2, { 639, 524 } },
    { 334848, 2, { 654, 512 } },
    { 334854, 2, { 689, 486 } },
    { 334880, 2, { 598, 560 } },
    { 334884, 2, { 649, 516 } },
    { 334950, 2, { 609, 550 } },
    { 335000, 2, { 625, 536 } },
    { 335008, 2, { 608, 551 } },
    { 335052, 2, { 681, 492 } },
    { 335088, 2, { 624, 537 } },
    { 335220, 2, { 604, 555 } },
    { 335225, 2, { 583, 575 } },
    { 335232, 2, { 582, 576 } },
    { 335250, 2, { 745, 450 } },
    { 335256, 2, { 687, 488 } },
    { 335268, 2, { 603, 556 } },
    { 335280, 2, { 635, 528 } },
    { 335320, 2, { 664, 505 } },
    { 335340, 2, { 621, 540 } },
    { 335400, 2, { 600, 559 } },
    { 335412, 2, { 693, 484 } },
    { 335478, 2, { 598, 561 } },
    { 335520, 2, { 699, 480 } },
    { 335529, 2, { 731, 459 } },
    { 335552, 2, { 749, 448 } },
    { 335580, 2, { 595, 564 } },
    { 335592, 2, { 632, 531 } },
    { 335610, 2, { 594, 565 } },
    { 335616, 2, { 608, 552 } },
    { 335664, 2, { 592, 567 } },
    { 335688, 2, { 591, 568 } },
    { 335699, 2, { 637, 527 } },
    { 335720, 2, { 616, 545 } },
    { 335730, 2, { 589, 570 } },
    { 335790, 2, { 585, 574 } },
    { 335800, 2, { 584, 575 } },
    { 335808, 2, { 583, 576 } },
    { 335820, 2, { 580, 579 } },
    { 335916, 2, { 602, 558 } },
    { 335920, 2, { 646, 520 } },
    { 335988, 2, { 612, 549 } },
    { 336015, 2, { 655, 513 } },
    { 336050, 2, { 611, 550 } },
    { 336072, 2, { 627, 536 } },
    { 336105, 2, { 679, 495 } },
    { 336168, 2, { 609, 552 } },
    { 336182, 2, { 649, 518 } },
    { 336192, 2, { 618, 544 } },
    { 336224, 2, { 608, 553 } },
    { 336226, 2, { 638, 527 } },
    { 336260, 2, { 731, 460 } },
    { 336288, 2, { 678, 496 } },
    { 336312, 2, { 648, 519 } },
    { 336336, 2, { 588, 572 } },
    { 336375, 2, { 585, 575 } },
    { 336420, 2, { 623, 540 } },
    { 336483, 2, { 763, 441 } },
    { 336490, 2, { 665, 506 } },
    { 336528, 2, { 656, 513 } },
    { 336567, 2, { 651, 517 } },
    { 336600, 2, { 600, 561 } },
    { 336648, 2, { 664, 507 } },
    { 336651, 2, { 697, 483 } },
    { 336660, 2, { 620, 543 } },
    { 336690, 2, { 645, 522 } },
    { 336700, 2, { 650, 518 } },
    { 336708, 2, { 597, 564 } },
    { 336720, 2, { 610, 552 } },
    { 336756, 2, { 633, 532 } },
    { 336784, 2, { 679, 496 } },
    { 336804, 2, { 663, 508 } },
    { 336810, 2, { 618, 545 } },
    { 336864, 2, { 638, 528 } },
    { 336875, 2, { 625, 539 } },
    { 336896, 2, { 658, 512 } },
    { 336908, 2, { 589, 572 } },
    { 336924, 2, { 588, 573 } },
    { 336960, 2, { 585, 576 } },
    { 336973, 2, { 637, 529 } },
    { 336980, 2, { 581, 580 } },
    { 337020, 2, { 615, 548 } },
    { 337025, 2, { 793, 425 } },
    { 337050, 2, { 630, 535 } },
    { 337120, 2, { 602, 560 } },
    { 337176, 2, { 669, 504 } },
    { 337185, 2, { 635, 531 } },
    { 337212, 2, { 612, 551 } },
    { 337225, 2, { 1025, 329 } },
    { 337236, 2, { 628, 537 } },
    { 337239, 2, { 707, 477 } },
    { 337260, 2, { 660, 511 } },
    { 337280, 2, { 620, 544 } },
    { 337330, 2, { 610, 553 } },
    { 337348, 2, { 697, 484 } },
    { 337365, 2, { 595, 567 } },
    { 337392, 2, { 594, 568 } },
    { 337440, 2, { 592, 570 } },
    { 337488, 2, { 632, 534 } },
    { 337500, 2, { 625, 540 } },
    { 337535, 2, { 935, 361 } },
    { 337554, 2, { 658, 513 } },
    { 337590, 2, { 605, 558 } },
    { 337610, 2, { 637, 530 } },
    { 337680, 2, { 603, 560 } },
    { 337716, 2, { 636, 531 } },
    { 337725, 2, { 711, 475 } },
    { 337770, 2, { 695, 486 } },
    { 337776, 2, { 681, 496 } },
    { 337840, 2, { 656, 515 } },
    { 337920, 2, { 640, 528 } },
    { 337932, 2, { 596, 567 } },
    { 337953, 2, { 627, 539 } },
    { 337960, 2, { 595, 568 } },
    { 337980, 2, { 645, 524 } },
    { 338004, 2, { 687, 492 } },
    { 338052, 2, { 591, 572 } },
    { 338100, 2, { 588, 575 } },
    { 338120, 2, { 632, 535 } },
    { 338130, 2, { 585, 578 } },
    { 338136, 2, { 584, 579 } },
    { 338140, 2, { 583, 580 } },
    { 338169, 2, { 667, 507 } },
    { 338184, 2, { 616, 549 } },
    { 338195, 2, { 605, 559 } },
    { 338198, 2, { 686, 493 } },
    { 338200, 2, { 712, 475 } },
    { 338247, 2, { 637, 531 } },
    { 338256, 2, { 648, 522 } },
    { 338316, 2, { 699, 484 } },
    { 338355, 2, { 657, 515 } },
    { 338388, 2, { 652, 519 } },
    { 338436, 2, { 612, 553 } },
    { 338445, 2, { 621, 545 } },
    { 338496, 2, { 656, 516 } },
    { 338560, 2, { 640, 529 } },
    { 338580, 2, { 594, 570 } },
    { 338604, 2, { 609, 556 } },
    { 338640, 2, { 664, 510 } },
    { 338675, 2, { 589, 575 } },
    { 338676, 2, { 668, 507 } },
    { 338688, 2, { 588, 576 } },
    { 338742, 2, { 697, 486 } },
    { 338800, 2, { 605, 560 } },
    { 338832, 2, { 624, 543 } },
    { 338844, 2, { 604, 561 } },
    { 338910, 2, { 715, 474 } },
    { 338912, 2, { 623, 544 } },
    { 338976, 2, { 642, 528 } },
    { 338985, 2, { 729, 465 } },
    { 339000, 2, { 600, 565 } },
    { 339012, 2, { 657, 516 } },
    { 339031, 2, { 629, 539 } },
    { 339066, 2, { 598, 567 } },
    { 339075, 2, { 685, 495 } },
    { 339090, 2, { 635, 534 } },
    { 339096, 2, { 597, 568 } },
    { 339105, 2, { 611, 555 } },
    { 339150, 2, { 595, 570 } },
    { 339152, 2, { 656, 517 } },
    { 339200, 2, { 640, 530 } },
    { 339216, 2, { 592, 573 } },
    { 339227, 2, { 989, 343 } },
    { 339264, 2, { 589, 576 } },
    { 339288, 2, { 633, 536 } },
    { 339300, 2, { 585, 580 } },
    { 339304, 2, { 584, 581 } },
    { 339360, 2, { 606, 560 } },
    { 339384, 2, { 632, 537 } },
    { 339388, 2, { 644, 527 } },
    { 339416, 2, { 616, 551 } },
    { 339465, 2, { 795, 427 } },
    { 339480, 2, { 615, 552 } },
    { 339500, 2, { 679, 500 } },
    { 339521, 2, { 637, 533 } },
    { 339549, 2, { 703, 483 } },
    { 339570, 2, { 630, 539 } },
    { 339575, 2, { 799, 425 } },
    { 339660, 2, { 612, 555 } },
    { 339735, 2, { 781, 435 } },
    { 339768, 2, { 594, 572 } },
    { 339808, 2, { 592, 574 } },
    { 339840, 2, { 590, 576 } },
    { 339852, 2, { 669, 508 } },
    { 339864, 2, { 588, 578 } },
    { 339872, 2, { 608, 559 } },
    { 339885, 2, { 585, 581 } },
    { 339888, 2, { 584, 582 } },
    { 339948, 2, { 639, 532 } },
    { 340000, 2, { 625, 544 } },
    { 340025, 2, { 725, 469 } },
    { 340054, 2, { 638, 533 } },
    { 340080, 2, { 624, 545 } },
    { 340092, 2, { 603, 564 } },
    { 340095, 2, { 615, 553 } },
    { 340170, 2, { 667, 510 } },
    { 340200, 2, { 600, 567 } },
    { 340252, 2, { 703, 484 } },
    { 340256, 2, { 686, 496 } },
    { 340260, 2, { 636, 535 } },
    { 340308, 2, { 621, 548 } },
    { 340312, 2, { 721, 472 } },
    { 340360, 2, { 635, 536 } },
    { 340380, 2, { 610, 558 } },
    { 340400, 2, { 592, 575 } },
    { 340416, 2, { 591, 576 } },
    { 340425, 2, { 765, 445 } },
    { 340431, 2, { 609, 559 } },
    { 340442, 2, { 589, 578 } },
    { 340452, 2, { 588, 579 } },
    { 340464, 2, { 656, 519 } },
    { 340500, 2, { 681, 500 } },
    { 340560, 2, { 645, 528 } },
    { 340632, 2, { 664, 513 } },
    { 340648, 2, { 616, 553 } },
    { 340659, 2, { 837, 407 } },
    { 340695, 2, { 603, 565 } },
    { 340704, 2, { 624, 546 } },
    { 340725, 2, { 649, 525 } },
    { 340752, 2, { 687, 496 } },
    { 340860, 2, { 598, 570 } },
    { 340875, 2, { 675, 505 } },
    { 340938, 2, { 611, 558 } },
    { 340956, 2, { 594, 574 } },
    { 341004, 2, { 628, 543 } },
    { 341055, 2, { 585, 583 } },
    { 341088, 2, { 608, 561 } },
    { 341112, 2, { 699, 488 } },
    { 341120, 2, { 640, 533 } },
    { 341124, 2, { 651, 524 } },
    { 341130, 2, { 685, 498 } },
    { 341136, 2, { 618, 552 } },
    { 341145, 2, { 665, 513 } },
    { 341220, 2, { 605, 564 } },
    { 341250, 2, { 625, 546 } },
    { 341275, 2, { 803, 425 } },
    { 341334, 2, { 602, 567 } },
    { 341341, 2, { 847, 403 } },
    { 341432, 2, { 637, 536 } },
    { 341440, 2, { 704, 485 } },
    { 341484, 2, { 597, 572 } },
    { 341504, 2, { 667, 512 } },
    { 341508, 2, { 596, 573 } },
    { 341532, 2, { 636, 537 } },
    { 341550, 2, { 594, 575 } },
    { 341600, 2, { 610, 560 } },
    { 341620, 2, { 589, 580 } },
    { 341628, 2, { 588, 581 } },
    { 341640, 2, { 585, 584 } },
    { 341712, 2, { 678, 504 } },
    { 341734, 2, { 646, 529 } },
    { 341744, 2, { 689, 496 } },
    { 341760, 2, { 640, 534 } },
    { 341775, 2, { 651, 525 } },
    { 341820, 2, { 633, 540 } },
    { 341824, 2, { 763, 448 } },
    { 341865, 2, { 639, 535 } },
    { 341880, 2, { 616, 555 } },
    { 341887, 2, { 1183, 289 } },
    { 341910, 2, { 655, 522 } },
    { 341940, 2, { 615, 556 } },
    { 341955, 2, { 745, 459 } },
    { 341960, 2, { 664, 515 } },
    { 341964, 2, { 644, 531 } },
    { 342000, 2, { 600, 570 } },
    { 342027, 2, { 623, 549 } },
    { 342056, 2, { 598, 572 } },
    { 342108, 2, { 612, 559 } },
    { 342144, 2, { 594, 576 } },
    { 342160, 2, { 611, 560 } },
    { 342171, 2, { 621, 551 } },
    { 342240, 2, { 620, 552 } },
    { 342300, 2, { 652, 525 } },
    { 342342, 2, { 627, 546 } },
    { 342370, 2, { 670, 511 } },
    { 342390, 2, { 606, 565 } },
    { 342400, 2, { 640, 535 } },
    { 342432, 2, { 656, 522 } },
    { 342468, 2, { 604, 567 } },
    { 342504, 2, { 603, 568 } },
    { 342528, 2, { 669, 512 } },
    { 342540, 2, { 660, 519 } },
    { 342550, 2, { 650, 527 } },
    { 342576, 2, { 624, 549 } },
    { 342630, 2, { 705, 486 } },
    { 342650, 2, { 623, 550 } },
    { 342672, 2, { 649, 528 } },
    { 342684, 2, { 668, 513 } },
    { 342705, 2, { 737, 465 } },
    { 342720, 2, { 595, 576 } },
    { 342760, 2, { 760, 451 } },
    { 342768, 2, { 592, 579 } },
    { 342771, 2, { 611, 561 } },
    { 342780, 2, { 591, 580 } },
    { 342790, 2, { 590, 581 } },
    { 342792, 2, { 621, 552 } },
    { 342804, 2, { 588, 583 } },
    { 342860, 2, { 620, 553 } },
    { 342900, 2, { 635, 540 } },
    { 342912, 2, { 608, 564 } },
    { 342925, 2, { 725, 473 } },
    { 342930, 2, { 690, 497 } },
    { 343000, 2, { 686, 500 } },
    { 343035, 2, { 605, 567 } },
    { 343070, 2, { 754, 455 } },
    { 343125, 2, { 625, 549 } },
    { 343140, 2, { 602, 570 } },
    { 343170, 2, { 615, 558 } },
    { 343175, 2, { 925, 371 } },
    { 343176, 2, { 632, 543 } },
    { 343200, 2, { 600, 572 } },
    { 343224, 2, { 681, 504 } },
    { 343308, 2, { 732, 469 } },
    { 343332, 2, { 594, 578 } },
    { 343350, 2, { 630, 545 } },
    { 343400, 2, { 680, 505 } },
    { 343413, 2, { 621, 553 } },
    { 343434, 2, { 629, 546 } },
    { 343476, 2, { 609, 564 } },
    { 343500, 2, { 687, 500 } },
    { 343520, 2, { 608, 565 } },
    { 343539, 2, { 779, 441 } },
    { 343552, 2, { 671, 512 } },
    { 343596, 2, { 627, 548 } },
    { 343640, 2, { 605, 568 } },
    { 343650, 2, { 725, 474 } },
    { 343680, 2, { 640, 537 } },
    { 343728, 2, { 616, 558 } },
    { 343785, 2, { 615, 559 } },
    { 343791, 2, { 749, 459 } },
    { 343800, 2, { 600, 573 } },
    { 343805, 2, { 665, 517 } },
    { 343824, 2, { 624, 551 } },
    { 343872, 2, { 597, 576 } },
    { 343882, 2, { 638, 539 } },
    { 343896, 2, { 623, 552 } },
    { 343908, 2, { 699, 492 } },
    { 343915, 2, { 715, 481 } },
    { 343917, 2, { 721, 477 } },
    { 343952, 2, { 592, 581 } },
    { 343980, 2, { 588, 585 } },
    { 344025, 2, { 695, 495 } },
    { 344040, 2, { 610, 564 } },
    { 344043, 2, { 889, 387 } },
    { 344064, 2, { 672, 512 } },
    { 344080, 2, { 680, 506 } },
    { 344088, 2, { 648, 531 } },
    { 344100, 2, { 620, 555 } },
    { 344112, 2, { 642, 536 } },
    { 344124, 2, { 711, 484 } },
    { 344160, 2, { 717, 480 } },
    { 344162, 2, { 793, 434 } },
    { 344190, 2, { 745, 462 } },
    { 344208, 2, { 606, 568 } },
    { 344268, 2, { 657, 524 } },
    { 344288, 2, { 742, 464 } },
    { 344322, 2, { 666, 517 } },
    { 344352, 2, { 633, 544 } },
    { 344375, 2, { 625, 551 } },
    { 344400, 2, { 600, 574 } },
    { 344421, 2, { 639, 539 } },
    { 344440, 2, { 632, 545 } },
    { 344448, 2, { 598, 576 } },
    { 344520, 2, { 594, 580 } },
    { 344544, 2, { 592, 582 } },
    { 344565, 2, { 589, 585 } },
    { 344616, 2, { 664, 519 } },
    { 344655, 2, { 621, 555 } },
    { 344715, 2, { 735, 469 } },
    { 344736, 2, { 608, 567 } },
    { 344760, 2, { 663, 520 } },
    { 344772, 2, { 628, 549 } },
    { 344817, 2, { 729, 473 } },
    { 344835, 2, { 711, 485 } },
    { 344850, 2, { 605, 570 } },
    { 344916, 2, { 603, 572 } },
    { 344955, 2, { 793, 435 } },
    { 344960, 2, { 616, 560 } },
    { 345000, 2, { 600, 575 } },
    { 345016, 2, { 707, 488 } },
    { 345060, 2, { 639, 540 } },
    { 345072, 2, { 624, 553 } },
    { 345084, 2, { 596, 579 } },
    { 345114, 2, { 594, 581 } },
    { 345136, 2, { 592, 583 } },
    { 345144, 2, { 591, 584 } },
    { 345204, 2, { 669, 516 } },
    { 345268, 2, { 649, 532 } },
    { 345276, 2, { 621, 556 } },
    { 345303, 2, { 609, 567 } },
    { 345312, 2, { 654, 528 } },
    { 345320, 2, { 712, 485 } },
    { 345348, 2, { 636, 543 } },
    { 345384, 2, { 648, 533 } },
    { 345440, 2, { 635, 544 } },
    { 345450, 2, { 658, 525 } },
    { 345477, 2, { 627, 551 } },
    { 345576, 2, { 616, 561 } },
    { 345600, 2, { 600, 576 } },
    { 345625, 2, { 625, 553 } },
    { 345720, 2, { 645, 536 } },
    { 345765, 2, { 623, 555 } },
    { 345780, 2, { 612, 565 } },
    { 345800, 2, { 650, 532 } },
    { 345825, 2, { 725, 477 } },
    { 345828, 2, { 644, 537 } },
    { 345840, 2, { 655, 528 } },
    { 345870, 2, { 610, 567 } },
    { 345912, 2, { 609, 568 } },
    { 345920, 2, { 736, 470 } },
    { 345948, 2, { 681, 508 } },
    { 345950, 2, { 629, 550 } },
    { 345984, 2, { 636, 544 } },
    { 346032, 2, { 648, 534 } },
    { 346080, 2, { 618, 560 } },
    { 346092, 2, { 604, 573 } },
    { 346104, 2, { 627, 552 } },
    { 346110, 2, { 695, 498 } },
    { 346112, 2, { 676, 512 } },
    { 346115, 2, { 899, 385 } },
    { 346125, 2, { 923, 375 } },
    { 346150, 2, { 602, 575 } },
    { 346212, 2, { 652, 531 } },
    { 346236, 2, { 671, 516 } },
    { 346248, 2, { 687, 504 } },
    { 346260, 2, { 597, 580 } },
    { 346290, 2, { 595, 582 } },
    { 346302, 2, { 594, 583 } },
    { 346320, 2, { 592, 585 } },
    { 346332, 2, { 589, 588 } },
    { 346437, 2, { 611, 567 } },
    { 346450, 2, { 650, 533 } },
    { 346500, 2, { 630, 550 } },
    { 346528, 2, { 637, 544 } },
    { 346545, 2, { 755, 459 } },
    { 346560, 2, { 608, 570 } },
    { 346580, 2, { 620, 559 } },
    { 346608, 2, { 664, 522 } },
    { 346620, 2, { 636, 545 } },
    { 346692, 2, { 668, 519 } },
    { 346704, 2, { 699, 496 } },
    { 346710, 2, { 635, 546 } },
    { 346725, 2, { 603, 575 } },
    { 346752, 2, { 602, 576 } },
    { 346764, 2, { 781, 444 } },
    { 346788, 2, { 676, 513 } },
    { 346800, 2, { 600, 578 } },
    { 346860, 2, { 615, 564 } },
    { 346884, 2, { 633, 548 } },
    { 346885, 2, { 595, 583 } },
    { 346896, 2, { 594, 584 } },
    { 346920, 2, { 590, 588 } },
    { 346968, 2, { 632, 549 } },
    { 346983, 2, { 651, 533 } },
    { 347004, 2, { 612, 567 } },
    { 347028, 2, { 717, 484 } },
    { 347072, 2, { 638, 544 } },
    { 347130, 2, { 609, 570 } },
    { 347136, 2, { 678, 512 } },
    { 347139, 2, { 621, 559 } },
    { 347208, 2, { 629, 552 } },
    { 347225, 2, { 731, 475 } },
    { 347282, 2, { 703, 494 } },
    { 347328, 2, { 603, 576 } },
    { 347400, 2, { 600, 579 } },
    { 347412, 2, { 663, 524 } },
    { 347440, 2, { 688, 505 } },
    { 347480, 2, { 595, 584 } },
    { 347490, 2, { 594, 585 } },
    { 347508, 2, { 591, 588 } },
    { 347520, 2, { 640, 543 } },
    { 347536, 2, { 749, 464 } },
    { 347578, 2, { 671, 518 } },
    { 347625, 2, { 675, 515 } },
    { 347633, 2, { 1573, 221 } },
    { 347634, 2, { 623, 558 } },
    { 347648, 2, { 679, 512 } },
    { 347655, 2, { 645, 539 } },
    { 347680, 2, { 656, 530 } },
    { 347760, 2, { 621, 560 } },
    { 347805, 2, { 655, 531 } },
    { 347820, 2, { 620, 561 } },
    { 347880, 2, { 669, 520 } },
    { 347900, 2, { 700, 497 } },
    { 347976, 2, { 648, 537 } },
    { 348000, 2, { 600, 580 } },
    { 348040, 2, { 616, 565 } },
    { 348075, 2, { 595, 585 } },
    { 348096, 2, { 592, 588 } },
    { 348192, 2, { 624, 558 } },
    { 348194, 2, { 646, 539 } },
    { 348255, 2, { 639, 545 } },
    { 348270, 2, { 611, 570 } },
    { 348300, 2, { 645, 540 } },
    { 348327, 2, { 679, 513 } },
    { 348336, 2, { 656, 531 } },
    { 348348, 2, { 609, 572 } },
    { 348384, 2, { 608, 573 } },
    { 348390, 2, { 630, 553 } },
    { 348432, 2, { 714, 488 } },
    { 348435, 2, { 783, 445 } },
    { 348450, 2, { 606, 575 } },
    { 348480, 2, { 605, 576 } },
    { 348500, 2, { 697, 500 } },
    { 348540, 2, { 628, 555 } },
    { 348600, 2, { 600, 581 } },
    { 348612, 2, { 627, 556 } },
    { 348615, 2, { 635, 549 } },
    { 348648, 2, { 597, 584 } },
    { 348660, 2, { 596, 585 } },
    { 348672, 2, { 681, 512 } },
    { 348705, 2, { 615, 567 } },
    { 348725, 2, { 725, 481 } },
    { 348750, 2, { 625, 558 } },
    { 348768, 2, { 672, 519 } },
    { 348800, 2, { 640, 545 } },
    { 348810, 2, { 755, 462 } },
    { 348816, 2, { 624, 559 } },
    { 348831, 2, { 791, 441 } },
    { 348840, 2, { 612, 570 } },
    { 348843, 2, { 961, 363 } },
    { 348880, 2, { 623, 560 } },
    { 348936, 2, { 651, 536 } },
    { 348975, 2, { 675, 517 } },
    { 348985, 2, { 767, 455 } },
    { 348992, 2, { 608, 574 } },
    { 348996, 2, { 687, 508 } },
    { 349056, 2, { 606, 576 } },
    { 349074, 2, { 738, 473 } },
    { 349125, 2, { 665, 525 } },
    { 349140, 2, { 660, 529 } },
    { 349160, 2, { 602, 580 } },
    { 349164, 2, { 636, 549 } },
    { 349170, 2, { 618, 565 } },
    { 349184, 2, { 682, 512 } },
    { 349200, 2, { 600, 582 } },
    { 349206, 2, { 726, 481 } },
    { 349248, 2, { 642, 544 } },
    { 349280, 2, { 592, 590 } },
    { 349305, 2, { 803, 435 } },
    { 349320, 2, { 615, 568 } },
    { 349350, 2, { 685, 510 } },
    { 349370, 2, { 713, 490 } },
    { 349375, 2, { 625, 559 } },
    { 349401, 2, { 663, 527 } },
    { 349416, 2, { 633, 552 } },
    { 349448, 2, { 722, 484 } },
    { 349492, 2, { 611, 572 } },
    { 349500, 2, { 699, 500 } },
    { 349524, 2, { 657, 532 } },
    { 349525, 2, { 775, 451 } },
    { 349600, 2, { 608, 575 } },
    { 349650, 2, { 630, 555 } },
    { 349690, 2, { 605, 578 } },
    { 349692, 2, { 644, 543 } },
    { 349713, 2, { 637, 549 } },
    { 349716, 2, { 604, 579 } },
    { 349740, 2, { 603, 580 } },
    { 349770, 2, { 655, 534 } },
    { 349800, 2, { 600, 583 } },
    { 349811, 2, { 649, 539 } },
    { 349812, 2, { 711, 492 } },
    { 349830, 2, { 598, 585 } },
    { 349860, 2, { 595, 588 } },
    { 349866, 2, { 594, 589 } },
    { 349872, 2, { 592, 591 } },
    { 349890, 2, { 642, 545 } },
    { 349896, 2, { 717, 488 } },
    { 349932, 2, { 723, 484 } },
    { 349965, 2, { 693, 505 } },
    { 350000, 2, { 625, 560 } },
    { 350020, 2, { 740, 473 } },
    { 350075, 2, { 737, 475 } },
    { 350124, 2, { 652, 537 } },
    { 350172, 2, { 639, 548 } },
    { 350175, 2, { 609, 575 } },
    { 350200, 2, { 680, 515 } },
    { 350217, 2, { 763, 459 } },
    { 350244, 2, { 621, 564 } },
    { 350304, 2, { 656, 534 } },
    { 350336, 2, { 644, 544 } },
    { 350343, 2, { 603, 581 } },
    { 350350, 2, { 637, 550 } },
    { 350385, 2, { 705, 497 } },
    { 350427, 2, { 777, 451 } },
    { 350455, 2, { 595, 589 } },
    { 350460, 2, { 594, 590 } },
    { 350493, 2, { 627, 559 } },
    { 350520, 2, { 635, 552 } },
    { 350544, 2, { 654, 536 } },
    { 350556, 2, { 669, 524 } },
    { 350625, 2, { 625, 561 } },
    { 350649, 2, { 729, 481 } },
    { 350658, 2, { 693, 506 } },
    { 350672, 2, { 707, 496 } },
    { 350676, 2, { 612, 573 } },
    { 350700, 2, { 668, 525 } },
    { 350714, 2, { 611, 574 } },
    { 350727, 2, { 663, 529 } },
    { 350760, 2, { 632, 555 } },
    { 350784, 2, { 609, 576 } },
    { 350812, 2, { 737, 476 } },
    { 350844, 2, { 676, 519 } },
    { 350865, 2, { 621, 565 } },
    { 350880, 2, { 645, 544 } },
    { 350960, 2, { 656, 535 } },
    { 350966, 2, { 602, 583 } },
    { 350982, 2, { 629, 558 } },
    { 350987, 2, { 637, 551 } },
    { 351000, 2, { 600, 585 } },
    { 351024, 2, { 618, 568 } },
    { 351036, 2, { 597, 588 } },
    { 351080, 2, { 655, 536 } },
    { 351120, 2, { 616, 570 } },
    { 351168, 2, { 708, 496 } },
    { 351232, 2, { 686, 512 } },
    { 351288, 2, { 612, 574 } },
    { 351325, 2, { 611, 575 } },
    { 351351, 2, { 693, 507 } },
    { 351360, 2, { 610, 576 } },
    { 351372, 2, { 623, 564 } },
    { 351396, 2, { 681, 516 } },
    { 351405, 2, { 685, 513 } },
    { 351495, 2, { 657, 535 } },
    { 351500, 2, { 703, 500 } },
    { 351540, 2, { 620, 567 } },
    { 351560, 2, { 680, 517 } },
    { 351575, 2, { 1025, 343 } },
    { 351624, 2, { 598, 588 } },
    { 351648, 2, { 594, 592 } },
    { 351708, 2, { 636, 553 } },
    { 351744, 2, { 687, 512 } },
    { 351780, 2, { 615, 572 } },
    { 351785, 2, { 665, 529 } },
    { 351848, 2, { 721, 488 } },
    { 351864, 2, { 648, 543 } },
    { 351876, 2, { 708, 497 } },
    { 351900, 2, { 612, 575 } },
    { 351918, 2, { 686, 513 } },
    { 351936, 2, { 611, 576 } },
    { 351948, 2, { 633, 556 } },
    { 352000, 2, { 640, 550 } },
    { 352032, 2, { 608, 579 } },
    { 352044, 2, { 693, 508 } },
    { 352110, 2, { 605, 582 } },
    { 352152, 2, { 603, 584 } },
    { 352170, 2, { 602, 585 } },
    { 352176, 2, { 638, 552 } },
    { 352222, 2, { 598, 589 } },
    { 352236, 2, { 596, 591 } },
    { 352240, 2, { 595, 592 } },
    { 352272, 2, { 656, 537 } },
    { 352275, 2, { 671, 525 } },
    { 352296, 2, { 699, 504 } },
    { 352308, 2, { 628, 561 } },
    { 352352, 2, { 616, 572 } },
    { 352359, 2, { 799, 441 } },
    { 352495, 2, { 715, 493 } },
    { 352500, 2, { 625, 564 } },
    { 352512, 2, { 612, 576 } },
    { 352560, 2, { 624, 565 } },
    { 352584, 2, { 664, 531 } },
    { 352590, 2, { 690, 511 } },
    { 352640, 2, { 608, 580 } },
    { 352656, 2, { 632, 558 } },
    { 352682, 2, { 697, 506 } },
    { 352716, 2, { 646, 546 } },
    { 352728, 2, { 621, 568 } },
    { 352764, 2, { 717, 492 } },
    { 352768, 2, { 689, 512 } },
    { 352800, 2, { 600, 588 } },
    { 352824, 2, { 723, 488 } },
    { 352869, 2, { 629, 561 } },
    { 352920, 2, { 680, 519 } },
    { 352935, 2, { 713, 495 } },
    { 352968, 2, { 616, 573 } },
    { 352980, 2, { 636, 555 } },
    { 353056, 2, { 649, 544 } },
    { 353073, 2, { 731, 483 } },
    { 353080, 2, { 679, 520 } },
    { 353115, 2, { 665, 531 } },
    { 353130, 2, { 745, 474 } },
    { 353133, 2, { 783, 451 } },
    { 353160, 2, { 648, 545 } },
    { 353210, 2, { 715, 494 } },
    { 353220, 2, { 609, 580 } },
    { 353232, 2, { 669, 528 } },
    { 353241, 2, { 623, 567 } },
    { 353248, 2, { 608, 581 } },
    { 353280, 2, { 640, 552 } },
    { 353320, 2, { 605, 584 } },
    { 353340, 2, { 604, 585 } },
    { 353367, 2, { 639, 553 } },
    { 353400, 2, { 600, 589 } },
    { 353424, 2, { 597, 592 } },
    { 353430, 2, { 595, 594 } },
    { 353457, 2, { 689, 513 } },
    { 353460, 2, { 645, 548 } },
    { 353528, 2, { 749, 472 } },
    { 353535, 2, { 637, 555 } },
    { 353556, 2, { 644, 549 } },
    { 353565, 2, { 729, 485 } },
    { 353600, 2, { 650, 544 } },
    { 353628, 2, { 627, 564 } },
    { 353675, 2, { 1075, 329 } },
    { 353700, 2, { 655, 540 } },
    { 353804, 2, { 731, 484 } },
    { 353808, 2, { 624, 567 } },
    { 353856, 2, { 608, 582 } },
    { 353864, 2, { 623, 568 } },
    { 353904, 2, { 606, 584 } },
    { 353925, 2, { 605, 585 } },
    { 354000, 2, { 600, 590 } },
    { 354032, 2, { 763, 464 } },
    { 354036, 2, { 652, 543 } },
    { 354120, 2, { 681, 520 } },
    { 354123, 2, { 657, 539 } },
    { 354144, 2, { 651, 544 } },
    { 354200, 2, { 616, 575 } },
    { 354240, 2, { 615, 576 } },
    { 354288, 2, { 671, 528 } },
    { 354320, 2, { 688, 515 } },
    { 354330, 2, { 635, 558 } },
    { 354348, 2, { 612, 579 } },
    { 354354, 2, { 649, 546 } },
    { 354375, 2, { 625, 567 } },
    { 354380, 2, { 611, 580 } },
    { 354384, 2, { 642, 552 } },
    { 354410, 2, { 610, 581 } },
    { 354420, 2, { 660, 537 } },
    { 354445, 2, { 665, 533 } },
    { 354450, 2, { 695, 510 } },
    { 354464, 2, { 608, 583 } },
    { 354480, 2, { 633, 560 } },
    { 354492, 2, { 687, 516 } },
    { 354552, 2, { 632, 561 } },
    { 354564, 2, { 603, 588 } },
    { 354576, 2, { 664, 534 } },
    { 354600, 2, { 600, 591 } },
    { 354708, 2, { 668, 531 } },
    { 354780, 2, { 657, 540 } },
    { 354816, 2, { 616, 576 } },
    { 354825, 2, { 747, 475 } },
    { 354844, 2, { 644, 551 } },
    { 354960, 2, { 612, 580 } },
    { 354978, 2, { 666, 533 } },
    { 354996, 2, { 684, 519 } },
    { 355000, 2, { 625, 568 } },
    { 355047, 2, { 609, 583 } },
    { 355092, 2, { 699, 508 } },
    { 355110, 2, { 623, 570 } },
    { 355212, 2, { 598, 594 } },
    { 355240, 2, { 664, 535 } },
    { 355260, 2, { 620, 573 } },
    { 355266, 2, { 731, 486 } },
    { 355284, 2, { 639, 556 } },
    { 355300, 2, { 646, 550 } },
    { 355350, 2, { 618, 575 } },
    { 355365, 2, { 745, 477 } },
    { 355368, 2, { 663, 536 } },
    { 355446, 2, { 637, 558 } },
    { 355500, 2, { 711, 500 } },
    { 355509, 2, { 627, 567 } },
    { 355520, 2, { 704, 505 } },
    { 355572, 2, { 612, 581 } },
    { 355600, 2, { 635, 560 } },
    { 355632, 2, { 717, 496 } },
    { 355656, 2, { 609, 584 } },
    { 355680, 2, { 608, 585 } },
    { 355696, 2, { 688, 517 } },
    { 355716, 2, { 723, 492 } },
    { 355718, 2, { 703, 506 } },
    { 355725, 2, { 675, 527 } },
    { 355740, 2, { 605, 588 } },
    { 355752, 2, { 648, 549 } },
    { 355776, 2, { 654, 544 } },
    { 355810, 2, { 598, 595 } },
    { 355812, 2, { 597, 596 } },
    { 355875, 2, { 949, 375 } },
    { 355880, 2, { 620, 574 } },
    { 355908, 2, { 669, 532 } },
    { 355946, 2, { 646, 551 } },
    { 355950, 2, { 630, 565 } },
    { 355968, 2, { 618, 576 } },
    { 355971, 2, { 737, 483 } },
    { 356040, 2, { 645, 552 } },
    { 356048, 2, { 616, 578 } },
    { 356070, 2, { 715, 498 } },
    { 356076, 2, { 628, 567 } },
    { 356083, 2, { 637, 559 } },
    { 356125, 2, { 875, 407 } },
    { 356136, 2, { 627, 568 } },
    { 356160, 2, { 636, 560 } },
    { 356208, 2, { 656, 543 } },
    { 356224, 2, { 704, 506 } },
    { 356250, 2, { 625, 570 } },
    { 356252, 2, { 676, 527 } },
    { 356265, 2, { 609, 585 } },
    { 356307, 2, { 893, 399 } },
    { 356320, 2, { 655, 544 } },
    { 356345, 2, { 605, 589 } },
    { 356352, 2, { 696, 512 } },
    { 356384, 2, { 602, 592 } },
    { 356400, 2, { 600, 594 } },
    { 356421, 2, { 703, 507 } },
    { 356440, 2, { 665, 536 } },
    { 356454, 2, { 621, 574 } },
    { 356475, 2, { 679, 525 } },
    { 356532, 2, { 803, 444 } },
    { 356535, 2, { 695, 513 } },
    { 356568, 2, { 664, 537 } },
    { 356642, 2, { 638, 559 } },
    { 356643, 2, { 629, 567 } },
    { 356655, 2, { 767, 465 } },
    { 356664, 2, { 616, 579 } },
    { 356685, 2, { 645, 553 } },
    { 356700, 2, { 615, 580 } },
    { 356720, 2, { 637, 560 } },
    { 356730, 2, { 690, 517 } },
    { 356748, 2, { 651, 548 } },
    { 356796, 2, { 612, 583 } },
    { 356832, 2, { 672, 531 } },
    { 356844, 2, { 681, 524 } },
    { 356895, 2, { 693, 515 } },
    { 356902, 2, { 689, 518 } },
    { 356915, 2, { 1105, 323 } },
    { 356960, 2, { 736, 485 } },
    { 356964, 2, { 604, 591 } },
    { 356972, 2, { 671, 532 } },
    { 356976, 2, { 603, 592 } },
    { 357000, 2, { 600, 595 } },
    { 357012, 2, { 633, 564 } },
    { 357048, 2, { 648, 551 } },
    { 357072, 2, { 688, 519 } },
    { 357075, 2, { 621, 575 } },
    { 357080, 2, { 632, 565 } },
    { 357120, 2, { 620, 576 } },
    { 357200, 2, { 752, 475 } },
    { 357240, 2, { 687, 520 } },
    { 357273, 2, { 749, 477 } },
    { 357315, 2, { 615, 581 } },
    { 357357, 2, { 637, 561 } },
    { 357420, 2, { 644, 555 } },
    { 357435, 2, { 611, 585 } },
    { 357500, 2, { 625, 572 } },
    { 357504, 2, { 608, 588 } },
    { 357520, 2, { 656, 545 } },
    { 357552, 2, { 624, 573 } },
    { 357561, 2, { 697, 513 } },
    { 357570, 2, { 685, 522 } },
    { 357588, 2, { 602, 594 } },
    { 357616, 2, { 721, 496 } },
    { 357630, 2, { 655, 546 } },
    { 357696, 2, { 621, 576 } },
    { 357700, 2, { 700, 511 } },
    { 357750, 2, { 675, 530 } },
    { 357760, 2, { 640, 559 } },
    { 357840, 2, { 630, 568 } },
    { 357864, 2, { 744, 481 } },
    { 357870, 2, { 755, 474 } },
    { 357888, 2, { 699, 512 } },
    { 357896, 2, { 616, 581 } },
    { 357948, 2, { 652, 549 } },
    { 357952, 2, { 658, 544 } },
    { 357984, 2, { 678, 528 } },
    { 358020, 2, { 612, 585 } },
    { 358050, 2, { 651, 550 } },
    { 358065, 2, { 657, 545 } },
    { 358092, 2, { 609, 588 } },
    { 358112, 2, { 608, 589 } },
    { 358140, 2, { 635, 564 } },
    { 358150, 2, { 650, 551 } },
    { 358160, 2, { 605, 592 } },
    { 358176, 2, { 624, 574 } },
    { 358200, 2, { 600, 597 } },
    { 358225, 2, { 623, 575 } },
    { 358248, 2, { 649, 552 } },
    { 358281, 2, { 693, 517 } },
    { 358340, 2, { 779, 460 } },
    { 358344, 2, { 632, 567 } },
    { 358380, 2, { 660, 543 } },
    { 358400, 2, { 640, 560 } },
    { 358500, 2, { 717, 500 } },
    { 358512, 2, { 616, 582 } },
    { 358530, 2, { 629, 570 } },
    { 358545, 2, { 615, 583 } },
    { 358584, 2, { 669, 536 } },
    { 358608, 2, { 723, 496 } },
    { 358620, 2, { 645, 556 } },
    { 358644, 2, { 627, 572 } },
    { 358668, 2, { 729, 492 } },
    { 358680, 2, { 610, 588 } },
    { 358701, 2, { 609, 589 } },
    { 358716, 2, { 668, 537 } },
    { 358720, 2, { 608, 590 } },
    { 358750, 2, { 625, 574 } },
    { 358752, 2, { 606, 592 } },
    { 358785, 2, { 603, 595 } },
    { 358800, 2, { 600, 598 } },
    { 358848, 2, { 623, 576 } },
    { 358875, 2, { 725, 495 } },
    { 358904, 2, { 728, 493 } },
    { 358956, 2, { 676, 531 } },
    { 358974, 2, { 666, 539 } },
    { 358980, 2, { 620, 579 } },
    { 359040, 2, { 640, 561 } },
    { 359055, 2, { 711, 505 } },
    { 359128, 2, { 616, 583 } },
    { 359136, 2, { 688, 522 } },
    { 359160, 2, { 615, 584 } },
    { 359268, 2, { 611, 588 } },
    { 359328, 2, { 608, 591 } },
    { 359340, 2, { 636, 565 } },
    { 359370, 2, { 605, 594 } },
    { 359388, 2, { 603, 596 } },
    { 359397, 2, { 729, 493 } },
    { 359424, 2, { 624, 576 } },
    { 359450, 2, { 650, 553 } },
    { 359480, 2, { 760, 473 } },
    { 359499, 2, { 901, 399 } },
    { 359513, 2, { 667, 539 } },
    { 359520, 2, { 642, 560 } },
    { 359544, 2, { 633, 568 } },
    { 359560, 2, { 712, 505 } },
    { 359568, 2, { 681, 528 } },
    { 359595, 2, { 655, 549 } },
    { 359640, 2, { 648, 555 } },
    { 359658, 2, { 689, 522 } },
    { 359720, 2, { 680, 529 } },
    { 359788, 2, { 629, 572 } },
    { 359844, 2, { 628, 573 } },
    { 359870, 2, { 679, 530 } },
    { 359910, 2, { 645, 558 } },
    { 359988, 2, { 687, 524 } },
    { 360036, 2, { 657, 548 } },
    { 360045, 2, { 635, 567 } },
    { 360096, 2, { 682, 528 } },
    { 360135, 2, { 755, 477 } },
    { 360136, 2, { 763, 472 } },
    { 360144, 2, { 656, 549 } },
    { 360150, 2, { 686, 525 } },
    { 360180, 2, { 621, 580 } },
    { 360195, 2, { 649, 555 } },
    { 360220, 2, { 620, 581 } },
    { 360240, 2, { 632, 570 } },
    { 360255, 2, { 705, 511 } },
    { 360297, 2, { 817, 441 } },
    { 360325, 2, { 725, 497 } },
    { 360360, 2, { 616, 585 } },
    { 360396, 2, { 639, 564 } },
    { 360468, 2, { 612, 589 } },
    { 360528, 2, { 609, 592 } },
    { 360549, 2, { 679, 531 } },
    { 360552, 2, { 664, 543 } },
    { 360570, 2, { 606, 595 } },
    { 360588, 2, { 604, 597 } },
    { 360612, 2, { 636, 567 } },
    { 360639, 2, { 703, 513 } },
    { 360640, 2, { 644, 560 } },
    { 360672, 2, { 624, 578 } },
    { 360680, 2, { 635, 568 } },
    { 360684, 2, { 699, 516 } },
    { 360789, 2, { 841, 429 } },
    { 360800, 2, { 656, 550 } },
    { 360801, 2, { 621, 581 } },
    { 360815, 2, { 793, 455 } },
    { 360855, 2, { 729, 495 } },
    { 360864, 2, { 672, 537 } },
    { 360912, 2, { 618, 584 } },
    { 360960, 2, { 640, 564 } },
    { 361000, 2, { 722, 500 } },
    { 361008, 2, { 654, 552 } },
    { 361035, 2, { 639, 565 } },
    { 361050, 2, { 725, 498 } },
    { 361080, 2, { 612, 590 } },
    { 361120, 2, { 610, 592 } },
    { 361125, 2, { 675, 535 } },
    { 361130, 2, { 670, 539 } },
    { 361152, 2, { 608, 594 } },
    { 361179, 2, { 637, 567 } },
    { 361188, 2, { 711, 508 } },
    { 361200, 2, { 602, 600 } },
    { 361250, 2, { 625, 578 } },
    { 361260, 2, { 669, 540 } },
    { 361284, 2, { 644, 561 } },
    { 361296, 2, { 624, 579 } },
    { 361340, 2, { 623, 580 } },
    { 361361, 2, { 1001, 361 } },
    { 361368, 2, { 717, 504 } },
    { 361375, 2, { 875, 413 } },
    { 361460, 2, { 620, 583 } },
    { 361491, 2, { 713, 507 } },
    { 361500, 2, { 723, 500 } },
    { 361522, 2, { 686, 527 } },
    { 361560, 2, { 655, 552 } },
    { 361584, 2, { 648, 558 } },
    { 361600, 2, { 640, 565 } },
    { 361620, 2, { 615, 588 } },
    { 361665, 2, { 705, 513 } },
    { 361669, 2, { 671, 539 } },
    { 361675, 2, { 629, 575 } },
    { 361692, 2, { 612, 591 } },
    { 361712, 2, { 611, 592 } },
    { 361725, 2, { 689, 525 } },
    { 361746, 2, { 609, 594 } },
    { 361760, 2, { 608, 595 } },
    { 361788, 2, { 708, 511 } },
    { 361790, 2, { 605, 598 } },
    { 361800, 2, { 603, 600 } },
    { 361816, 2, { 637, 568 } },
    { 361836, 2, { 684, 529 } },
    { 361860, 2, { 652, 555 } },
    { 361880, 2, { 664, 545 } },
    { 361900, 2, { 658, 550 } },
    { 361920, 2, { 624, 580 } },
    { 361950, 2, { 635, 570 } },
    { 361956, 2, { 651, 556 } },
    { 361984, 2, { 707, 512 } },
    { 361998, 2, { 663, 546 } },
    { 362043, 2, { 621, 583 } },
    { 362070, 2, { 745, 486 } },
    { 362076, 2, { 633, 572 } },
    { 362136, 2, { 632, 573 } },
    { 362142, 2, { 649, 558 } },
    { 362232, 2, { 648, 559 } },
    { 362250, 2, { 630, 575 } },
    { 362292, 2, { 681, 532 } },
    { 362295, 2, { 747, 485 } },
    { 362304, 2, { 612, 592 } },
    { 362340, 2, { 610, 594 } },
    { 362440, 2, { 680, 533 } },
    { 362496, 2, { 708, 512 } },
    { 362544, 2, { 624, 581 } },
    { 362560, 2, { 704, 515 } },
    { 362600, 2, { 700, 518 } },
    { 362604, 2, { 737, 492 } },
    { 362637, 2, { 891, 407 } },
    { 362664, 2, { 621, 584 } },
    { 362691, 2, { 707, 513 } },
    { 362700, 2, { 620, 585 } },
    { 362724, 2, { 668, 543 } },
    { 362730, 2, { 642, 565 } },
    { 362736, 2, { 687, 528 } },
    { 362790, 2, { 695, 522 } },
    { 362810, 2, { 710, 511 } },
    { 362824, 2, { 616, 589 } },
    { 362848, 2, { 667, 544 } },
    { 362880, 2, { 630, 576 } },
    { 362894, 2, { 686, 529 } },
    { 362934, 2, { 611, 594 } },
    { 362952, 2, { 639, 568 } },
    { 362964, 2, { 609, 596 } },
    { 362976, 2, { 608, 597 } },
    { 363000, 2, { 605, 600 } },
    { 363012, 2, { 676, 537 } },
    { 363055, 2, { 805, 451 } },
    { 363069, 2, { 791, 459 } },
    { 363072, 2, { 732, 496 } },
    { 363090, 2, { 637, 570 } },
    { 363120, 2, { 680, 534 } },
    { 363125, 2, { 625, 581 } },
    { 363132, 2, { 693, 524 } },
    { 363165, 2, { 781, 465 } },
    { 363168, 2, { 624, 582 } },
    { 363204, 2, { 684, 531 } },
    { 363300, 2, { 692, 525 } },
    { 363321, 2, { 657, 553 } },
    { 363324, 2, { 663, 548 } },
    { 363350, 2, { 650, 559 } },
    { 363375, 2, { 765, 475 } },
    { 363400, 2, { 632, 575 } },
    { 363408, 2, { 678, 536 } },
    { 363475, 2, { 775, 469 } },
    { 363480, 2, { 699, 520 } },
    { 363506, 2, { 682, 533 } },
    { 363545, 2, { 611, 595 } },
    { 363584, 2, { 608, 598 } },
    { 363600, 2, { 606, 600 } },
    { 363612, 2, { 628, 579 } },
    { 363630, 2, { 690, 527 } },
    { 363660, 2, { 627, 580 } },
    { 363735, 2, { 685, 531 } },
    { 363750, 2, { 625, 582 } },
    { 363780, 2, { 645, 564 } },
    { 363792, 2, { 624, 583 } },
    { 363800, 2, { 680, 535 } },
    { 363804, 2, { 732, 497 } },
    { 363825, 2, { 675, 539 } },
    { 363832, 2, { 623, 584 } },
    { 363834, 2, { 697, 522 } },
    { 363909, 2, { 651, 559 } },
    { 363936, 2, { 669, 544 } },
    { 363944, 2, { 679, 536 } },
    { 363951, 2, { 763, 477 } },
    { 363968, 2, { 704, 517 } },
    { 364000, 2, { 650, 560 } },
    { 364021, 2, { 833, 437 } },
    { 364056, 2, { 616, 591 } },
    { 364080, 2, { 615, 592 } },
    { 364095, 2, { 783, 465 } },
    { 364140, 2, { 612, 595 } },
    { 364212, 2, { 604, 603 } },
    { 364236, 2, { 717, 508 } },
    { 364325, 2, { 767, 475 } },
    { 364375, 2, { 625, 583 } },
    { 364392, 2, { 723, 504 } },
    { 364428, 2, { 636, 573 } },
    { 364455, 2, { 623, 585 } },
    { 364480, 2, { 670, 544 } },
    { 364500, 2, { 675, 540 } },
    { 364536, 2, { 664, 549 } },
    { 364572, 2, { 684, 533 } },
    { 364608, 2, { 633, 576 } },
    { 364640, 2, { 688, 530 } },
    { 364650, 2, { 650, 561 } },
    { 364656, 2, { 642, 568 } },
    { 364720, 2, { 752, 485 } },
    { 364800, 2, { 608, 600 } },
    { 364815, 2, { 605, 603 } },
    { 364820, 2, { 629, 580 } },
    { 364896, 2, { 672, 543 } },
    { 364980, 2, { 660, 553 } },
    { 365000, 2, { 625, 584 } },
    { 365016, 2, { 681, 536 } },
    { 365024, 2, { 671, 544 } },
    { 365040, 2, { 624, 585 } },
    { 365056, 2, { 713, 512 } },
    { 365079, 2, { 759, 481 } },
    { 365085, 2, { 665, 549 } },
    { 365092, 2, { 767, 476 } },
    { 365148, 2, { 621, 588 } },
    { 365160, 2, { 680, 537 } },
    { 365190, 2, { 658, 555 } },
    { 365292, 2, { 657, 556 } },
    { 365295, 2, { 735, 497 } },
    { 365310, 2, { 615, 594 } },
    { 365313, 2, { 663, 551 } },
    { 365328, 2, { 688, 531 } },
    { 365364, 2, { 612, 597 } },
    { 365400, 2, { 609, 600 } },
    { 365484, 2, { 687, 532 } },
    { 365490, 2, { 655, 558 } },
    { 365500, 2, { 731, 500 } },
    { 365508, 2, { 639, 572 } },
    { 365512, 2, { 749, 488 } },
    { 365560, 2, { 703, 520 } },
    { 365585, 2, { 935, 391 } },
    { 365625, 2, { 625, 585 } },
    { 365700, 2, { 636, 575 } },
    { 365715, 2, { 645, 567 } },
    { 365750, 2, { 665, 550 } },
    { 365760, 2, { 635, 576 } },
    { 365769, 2, { 621, 589 } },
    { 365772, 2, { 652, 561 } },
    { 365790, 2, { 685, 534 } },
    { 365856, 2, { 618, 592 } },
    { 365904, 2, { 616, 594 } },
    { 365928, 2, { 632, 579 } },
    { 365976, 2, { 612, 598 } },
    { 366000, 2, { 610, 600 } },
    { 366016, 2, { 608, 602 } },
    { 366030, 2, { 630, 581 } },
    { 366036, 2, { 649, 564 } },
    { 366048, 2, { 656, 558 } },
    { 366054, 2, { 722, 507 } },
    { 366080, 2, { 640, 572 } },
    { 366120, 2, { 648, 565 } },
    { 366165, 2, { 711, 515 } },
    { 366168, 2, { 627, 584 } },
    { 366240, 2, { 654, 560 } },
    { 366275, 2, { 637, 575 } },
    { 366276, 2, { 699, 524 } },
    { 366282, 2, { 646, 567 } },
    { 366300, 2, { 660, 555 } },
    { 366324, 2, { 623, 588 } },
    { 366336, 2, { 636, 576 } },
    { 366360, 2, { 645, 568 } },
    { 366366, 2, { 671, 546 } },
    { 366390, 2, { 621, 590 } },
    { 366415, 2, { 665, 551 } },
    { 366420, 2, { 620, 591 } },
    { 366520, 2, { 616, 595 } },
    { 366540, 2, { 615, 596 } },
    { 366548, 2, { 689, 532 } },
    { 366575, 2, { 775, 473 } },
    { 366597, 2, { 693, 529 } },
    { 366600, 2, { 611, 600 } },
    { 366612, 2, { 669, 548 } },
    { 366624, 2, { 608, 603 } },
    { 366630, 2, { 606, 605 } },
    { 366680, 2, { 712, 515 } },
    { 366704, 2, { 656, 559 } },
    { 366720, 2, { 640, 573 } },
    { 366730, 2, { 806, 455 } },
    { 366732, 2, { 668, 549 } },
    { 366741, 2, { 799, 459 } },
    { 366792, 2, { 696, 527 } },
    { 366795, 2, { 627, 585 } },
    { 366800, 2, { 655, 560 } },
    { 366850, 2, { 638, 575 } },
    { 366876, 2, { 711, 516 } },
    { 366912, 2, { 624, 588 } },
    { 366930, 2, { 755, 486 } },
    { 367024, 2, { 791, 464 } },
    { 367068, 2, { 676, 543 } },
    { 367080, 2, { 644, 570 } },
    { 367104, 2, { 717, 512 } },
    { 367140, 2, { 633, 580 } },
    { 367164, 2, { 651, 564 } },
    { 367192, 2, { 632, 581 } },
    { 367284, 2, { 723, 508 } },
    { 367290, 2, { 630, 583 } },
    { 367308, 2, { 684, 537 } },
    { 367350, 2, { 775, 474 } },
    { 367353, 2, { 833, 441 } },
    { 367360, 2, { 640, 574 } },
    { 367380, 2, { 628, 585 } },
    { 367392, 2, { 688, 534 } },
    { 367416, 2, { 648, 567 } },
    { 367425, 2, { 639, 575 } },
    { 367452, 2, { 692, 531 } },
    { 367488, 2, { 638, 576 } },
    { 367500, 2, { 625, 588 } },
    { 367521, 2, { 777, 473 } },
    { 367536, 2, { 624, 589 } },
    { 367570, 2, { 623, 590 } },
    { 367598, 2, { 682, 539 } },
    { 367632, 2, { 621, 592 } },
    { 367640, 2, { 707, 520 } },
    { 367710, 2, { 618, 595 } },
    { 367740, 2, { 681, 540 } },
    { 367752, 2, { 616, 597 } },
    { 367822, 2, { 611, 602 } },
    { 367824, 2, { 632, 582 } },
    { 367836, 2, { 609, 604 } },
    { 367840, 2, { 608, 605 } },
    { 367875, 2, { 675, 545 } },
    { 367920, 2, { 630, 584 } },
    { 367965, 2, { 629, 585 } },
    { 367983, 2, { 649, 567 } },
    { 368000, 2, { 640, 575 } },
    { 368010, 2, { 705, 522 } },
    { 368016, 2, { 656, 561 } },
    { 368032, 2, { 742, 496 } },
    { 368039, 2, { 1073, 343 } },
    { 368064, 2, { 639, 576 } },
    { 368080, 2, { 688, 535 } },
    { 368082, 2, { 726, 507 } },
    { 368125, 2, { 625, 589 } },
    { 368145, 2, { 729, 505 } },
    { 368160, 2, { 624, 590 } },
    { 368184, 2, { 667, 552 } },
    { 368186, 2, { 637, 578 } },
    { 368232, 2, { 687, 536 } },
    { 368244, 2, { 636, 579 } },
    { 368280, 2, { 620, 594 } },
    { 368298, 2, { 666, 553 } },
    { 368368, 2, { 616, 598 } },
    { 368424, 2, { 612, 602 } },
    { 368448, 2, { 608, 606 } },
    { 368480, 2, { 658, 560 } },
    { 368520, 2, { 664, 555 } },
    { 368600, 2, { 760, 485 } },
    { 368628, 2, { 663, 556 } },
    { 368676, 2, { 627, 588 } },
    { 368725, 2, { 1075, 343 } },
    { 368745, 2, { 793, 465 } },
    { 368775, 2, { 745, 495 } },
    { 368784, 2, { 624, 591 } },
    { 368816, 2, { 623, 592 } },
    { 368832, 2, { 678, 544 } },
    { 368928, 2, { 672, 549 } },
    { 368940, 2, { 645, 572 } },
    { 369000, 2, { 615, 600 } },
    { 369012, 2, { 644, 573 } },
    { 369036, 2, { 612, 603 } },
    { 369045, 2, { 695, 531 } },
    { 369072, 2, { 699, 528 } },
    { 369117, 2, { 651, 567 } },
    { 369150, 2, { 642, 575 } },
    { 369152, 2, { 721, 512 } },
    { 369240, 2, { 680, 543 } },
    { 369265, 2, { 845, 437 } },
    { 369288, 2, { 669, 552 } },
    { 369303, 2, { 627, 589 } },
    { 369325, 2, { 869, 425 } },
    { 369360, 2, { 648, 570 } },
    { 369369, 2, { 693, 533 } },
    { 369376, 2, { 679, 544 } },
    { 369420, 2, { 655, 564 } },
    { 369456, 2, { 688, 537 } },
    { 369460, 2, { 637, 580 } },
    { 369495, 2, { 621, 595 } },
    { 369510, 2, { 654, 565 } },
    { 369512, 2, { 646, 572 } },
    { 369516, 2, { 636, 581 } },
    { 369570, 2, { 635, 582 } },
    { 369576, 2, { 696, 531 } },
    { 369600, 2, { 616, 600 } },
    { 369603, 2, { 729, 507 } },
    { 369655, 2, { 611, 605 } },
    { 369672, 2, { 633, 584 } },
    { 369675, 2, { 775, 477 } },
    { 369684, 2, { 652, 567 } },
    { 369720, 2, { 632, 585 } },
    { 369750, 2, { 725, 510 } },
    { 369768, 2, { 651, 568 } },
    { 369792, 2, { 642, 576 } },
    { 369840, 2, { 670, 552 } },
    { 369852, 2, { 629, 588 } },
    { 369873, 2, { 721, 513 } },
    { 369886, 2, { 731, 506 } },
    { 369900, 2, { 675, 548 } },
    { 369920, 2, { 640, 578 } },
    { 369972, 2, { 717, 516 } },
    { 369984, 2, { 656, 564 } },
    { 369985, 2, { 961, 385 } },
    { 370000, 2, { 625, 592 } },
    { 370025, 2, { 779, 475 } },
    { 370062, 2, { 623, 594 } },
    { 370116, 2, { 621, 596 } },
    { 370139, 2, { 847, 437 } },
    { 370140, 2, { 620, 597 } },
    { 370175, 2, { 871, 425 } },
    { 370176, 2, { 723, 512 } },
    { 370230, 2, { 615, 602 } },
    { 370260, 2, { 612, 605 } },
    { 370272, 2, { 609, 608 } },
    { 370332, 2, { 729, 508 } },
    { 370359, 2, { 783, 473 } },
    { 370392, 2, { 671, 552 } },
    { 370461, 2, { 767, 483 } },
    { 370464, 2, { 681, 544 } },
    { 370475, 2, { 725, 511 } },
    { 370510, 2, { 670, 553 } },
    { 370512, 2, { 664, 558 } },
    { 370548, 2, { 657, 564 } },
    { 370560, 2, { 640, 579 } },
    { 370600, 2, { 680, 545 } },
    { 370620, 2, { 639, 580 } },
    { 370640, 2, { 656, 565 } },
    { 370656, 2, { 624, 594 } },
    { 370740, 2, { 668, 555 } },
    { 370755, 2, { 693, 535 } },
    { 370783, 2, { 1081, 343 } },
    { 370800, 2, { 618, 600 } },
    { 370840, 2, { 635, 584 } },
    { 370880, 2, { 610, 608 } },
    { 370944, 2, { 644, 576 } },
    { 370968, 2, { 696, 533 } },
    { 370975, 2, { 781, 475 } },
    { 370980, 2, { 687, 540 } },
    { 371008, 2, { 682, 544 } },
    { 371010, 2, { 745, 498 } },
    { 371025, 2, { 765, 485 } },
    { 371070, 2, { 630, 589 } },
    { 371124, 2, { 676, 549 } },
    { 371130, 2, { 695, 534 } },
    { 371148, 2, { 628, 591 } },
    { 371175, 2, { 707, 525 } },
    { 371184, 2, { 627, 592 } },
    { 371200, 2, { 640, 580 } },
    { 371205, 2, { 657, 565 } },
    { 371250, 2, { 625, 594 } },
    { 371259, 2, { 639, 581 } },
    { 371280, 2, { 624, 595 } },
    { 371304, 2, { 648, 573 } },
    { 371371, 2, { 637, 583 } },
    { 371385, 2, { 655, 567 } },
    { 371412, 2, { 684, 543 } },
    { 371448, 2, { 616, 603 } },
    { 371460, 2, { 615, 604 } },
    { 371472, 2, { 654, 568 } },
    { 371475, 2, { 635, 585 } },
    { 371488, 2, { 611, 608 } },
    { 371504, 2, { 749, 496 } },
    { 371520, 2, { 645, 576 } },
    { 371604, 2, { 692, 537 } },
    { 371664, 2, { 696, 534 } },
    { 371680, 2, { 736, 505 } },
    { 371700, 2, { 630, 590 } },
    { 371735, 2, { 665, 559 } },
    { 371790, 2, { 729, 510 } },
    { 371840, 2, { 640, 581 } },
    { 371868, 2, { 699, 532 } },
    { 371875, 2, { 625, 595 } },
    { 371910, 2, { 690, 539 } },
    { 371925, 2, { 675, 551 } },
    { 371952, 2, { 648, 574 } },
    { 371964, 2, { 669, 556 } },
    { 372000, 2, { 620, 600 } },
    { 372008, 2, { 637, 584 } },
    { 372040, 2, { 655, 568 } },
    { 372060, 2, { 636, 585 } },
    { 372090, 2, { 785, 474 } },
    { 372096, 2, { 612, 608 } },
    { 372099, 2, { 611, 609 } },
    { 372204, 2, { 633, 588 } },
    { 372294, 2, { 666, 559 } },
    { 372344, 2, { 763, 488 } },
    { 372372, 2, { 651, 572 } },
    { 372400, 2, { 665, 560 } },
    { 372405, 2, { 671, 555 } },
    { 372416, 2, { 704, 529 } },
    { 372438, 2, { 627, 594 } },
    { 372476, 2, { 676, 551 } },
    { 372480, 2, { 640, 582 } },
    { 372504, 2, { 664, 561 } },
    { 372526, 2, { 649, 574 } },
    { 372528, 2, { 624, 597 } },
    { 372564, 2, { 711, 524 } },
    { 372600, 2, { 621, 600 } },
    { 372645, 2, { 637, 585 } },
    { 372680, 2, { 616, 605 } },
    { 372708, 2, { 612, 609 } },
    { 372736, 2, { 728, 512 } },
    { 372771, 2, { 679, 549 } },
    { 372775, 2, { 775, 481 } },
    { 372840, 2, { 717, 520 } },
    { 372855, 2, { 795, 469 } },
    { 372876, 2, { 644, 579 } },
    { 372900, 2, { 660, 565 } },
    { 372960, 2, { 630, 592 } },
    { 373065, 2, { 627, 595 } },
    { 373068, 2, { 723, 516 } },
    { 373086, 2, { 658, 567 } },
    { 373100, 2, { 650, 574 } },
    { 373120, 2, { 640, 583 } },
    { 373152, 2, { 624, 598 } },
    { 373175, 2, { 649, 575 } },
    { 373176, 2, { 639, 584 } },
    { 373184, 2, { 686, 544 } },
    { 373188, 2, { 681, 548 } },
    { 373230, 2, { 638, 585 } },
    { 373240, 2, { 620, 602 } },
    { 373248, 2, { 648, 576 } },
    { 373275, 2, { 675, 553 } },
    { 373296, 2, { 616, 606 } },
    { 373320, 2, { 612, 610 } },
    { 373350, 2, { 655, 570 } },
    { 373352, 2, { 791, 472 } },
    { 373380, 2, { 635, 588 } },
    { 373395, 2, { 803, 465 } },
    { 373450, 2, { 679, 550 } },
    { 373500, 2, { 747, 500 } },
    { 373512, 2, { 632, 591 } },
    { 373584, 2, { 688, 543 } },
    { 373596, 2, { 652, 573 } },
    { 373625, 2, { 875, 427 } },
    { 373626, 2, { 629, 594 } },
    { 373635, 2, { 855, 437 } },
    { 373692, 2, { 627, 596 } },
    { 373725, 2, { 755, 495 } },
    { 373728, 2, { 687, 544 } },
    { 373750, 2, { 625, 598 } },
    { 373752, 2, { 696, 537 } },
    { 373800, 2, { 623, 600 } },
    { 373824, 2, { 649, 576 } },
    { 373842, 2, { 621, 602 } },
    { 373860, 2, { 620, 603 } },
    { 373890, 2, { 618, 605 } },
    { 373920, 2, { 615, 608 } },
    { 373932, 2, { 612, 611 } },
    { 373996, 2, { 703, 532 } },
    { 374010, 2, { 685, 546 } },
    { 374052, 2, { 732, 511 } },
    { 374100, 2, { 645, 580 } },
    { 374166, 2, { 702, 533 } },
    { 374187, 2, { 667, 561 } },
    { 374255, 2, { 629, 595 } },
    { 374256, 2, { 678, 552 } },
    { 374325, 2, { 651, 575 } },
    { 374374, 2, { 847, 442 } },
    { 374418, 2, { 671, 558 } },
    { 374445, 2, { 785, 477 } },
    { 374556, 2, { 637, 588 } },
    { 374625, 2, { 675, 555 } },
    { 374640, 2, { 669, 560 } },
    { 374664, 2, { 699, 536 } },
    { 374710, 2, { 707, 530 } },
    { 374736, 2, { 633, 592 } },
    { 374745, 2, { 645, 581 } },
    { 374748, 2, { 668, 561 } },
    { 374784, 2, { 732, 512 } },
    { 374816, 2, { 689, 544 } },
    { 374825, 2, { 725, 517 } },
    { 374850, 2, { 630, 595 } },
    { 374916, 2, { 628, 597 } },
    { 374920, 2, { 721, 520 } },
    { 374928, 2, { 642, 584 } },
    { 374946, 2, { 627, 598 } },
    { 374960, 2, { 688, 545 } },
    { 374976, 2, { 651, 576 } },
    { 375000, 2, { 625, 600 } },
    { 375003, 2, { 731, 513 } },
    { 375060, 2, { 658, 570 } },
    { 375084, 2, { 621, 604 } },
    { 375144, 2, { 616, 609 } },
    { 375160, 2, { 664, 565 } },
    { 375180, 2, { 676, 555 } },
    { 375192, 2, { 648, 579 } },
    { 375193, 2, { 637, 589 } },
    { 375200, 2, { 670, 560 } },
    { 375240, 2, { 636, 590 } },
    { 375300, 2, { 675, 556 } },
    { 375375, 2, { 715, 525 } },
    { 375408, 2, { 632, 594 } },
    { 375417, 2, { 707, 531 } },
    { 375435, 2, { 729, 515 } },
    { 375440, 2, { 722, 520 } },
    { 375452, 2, { 644, 583 } },
    { 375516, 2, { 684, 549 } },
    { 375550, 2, { 725, 518 } },
    { 375585, 2, { 735, 511 } },
    { 375648, 2, { 624, 602 } },
    { 375669, 2, { 623, 603 } },
    { 375683, 2, { 697, 539 } },
    { 375700, 2, { 650, 578 } },
    { 375705, 2, { 621, 605 } },
    { 375708, 2, { 717, 524 } },
    { 375732, 2, { 639, 588 } },
    { 375744, 2, { 618, 608 } },
    { 375756, 2, { 692, 543 } },
    { 375765, 2, { 615, 611 } },
    { 375782, 2, { 638, 589 } },
    { 375804, 2, { 657, 572 } },
    { 375820, 2, { 817, 460 } },
    { 375830, 2, { 637, 590 } },
    { 375840, 2, { 648, 580 } },
    { 375876, 2, { 636, 591 } },
    { 375888, 2, { 656, 573 } },
    { 375900, 2, { 700, 537 } },
    { 375912, 2, { 681, 552 } },
    { 375920, 2, { 635, 592 } },
    { 375921, 2, { 663, 567 } },
    { 375936, 2, { 704, 534 } },
    { 375960, 2, { 723, 520 } },
    { 375990, 2, { 755, 498 } },
    { 376035, 2, { 645, 583 } },
    { 376040, 2, { 632, 595 } },
    { 376047, 2, { 889, 423 } },
    { 376050, 2, { 654, 575 } },
    { 376065, 2, { 685, 549 } },
    { 376142, 2, { 629, 598 } },
    { 376164, 2, { 729, 516 } },
    { 376194, 2, { 689, 546 } },
    { 376200, 2, { 627, 600 } },
    { 376250, 2, { 625, 602 } },
    { 376257, 2, { 779, 483 } },
    { 376272, 2, { 624, 603 } },
    { 376290, 2, { 666, 565 } },
    { 376320, 2, { 640, 588 } },
    { 376376, 2, { 616, 611 } },
    { 376380, 2, { 615, 612 } },
    { 376428, 2, { 741, 508 } },
    { 376464, 2, { 682, 552 } },
    { 376476, 2, { 687, 548 } },
    { 376488, 2, { 648, 581 } },
    { 376512, 2, { 636, 592 } },
    { 376584, 2, { 663, 568 } },
    { 376623, 2, { 783, 481 } },
    { 376640, 2, { 704, 535 } },
    { 376675, 2, { 793, 475 } },
    { 376680, 2, { 645, 584 } },
    { 376704, 2, { 654, 576 } },
    { 376740, 2, { 630, 598 } },
    { 376805, 2, { 715, 527 } },
    { 376845, 2, { 679, 555 } },
    { 376875, 2, { 625, 603 } },
    { 376884, 2, { 684, 551 } },
    { 376893, 2, { 729, 517 } },
    { 376960, 2, { 620, 608 } },
    { 377036, 2, { 779, 484 } },
    { 377055, 2, { 665, 567 } },
    { 377104, 2, { 637, 592 } },
    { 377136, 2, { 648, 582 } },
    { 377145, 2, { 765, 493 } },
    { 377190, 2, { 635, 594 } },
    { 377200, 2, { 656, 575 } },
    { 377235, 2, { 747, 505 } },
    { 377268, 2, { 633, 596 } },
    { 377280, 2, { 655, 576 } },
    { 377300, 2, { 686, 550 } },
    { 377304, 2, { 632, 597 } },
    { 377307, 2, { 791, 477 } },
    { 377316, 2, { 669, 564 } },
    { 377377, 2, { 1001, 377 } },
    { 377400, 2, { 629, 600 } },
    { 377460, 2, { 699, 540 } },
    { 377468, 2, { 793, 476 } },
    { 377487, 2, { 837, 451 } },
    { 377508, 2, { 652, 579 } },
    { 377520, 2, { 624, 605 } },
    { 377568, 2, { 621, 608 } },
    { 377580, 2, { 620, 609 } },
    { 377600, 2, { 640, 590 } },
    { 377650, 2, { 650, 581 } },
    { 377685, 2, { 693, 545 } },
    { 377706, 2, { 714, 529 } },
    { 377712, 2, { 688, 549 } },
    { 377720, 2, { 665, 568 } },
    { 377775, 2, { 657, 575 } },
    { 377880, 2, { 670, 564 } },
    { 377895, 2, { 885, 427 } },
    { 377910, 2, { 646, 585 } },
    { 377928, 2, { 696, 543 } },
    { 377986, 2, { 686, 551 } },
    { 378000, 2, { 630, 600 } },
    { 378015, 2, { 869, 435 } },
    { 378048, 2, { 704, 537 } },
    { 378120, 2, { 685, 552 } },
    { 378125, 2, { 625, 605 } },
    { 378144, 2, { 624, 606 } },
    { 378180, 2, { 660, 573 } },
    { 378189, 2, { 621, 609 } },
    { 378235, 2, { 715, 529 } },
    { 378240, 2, { 640, 591 } },
    { 378252, 2, { 684, 553 } },
    { 378288, 2, { 639, 592 } },
    { 378350, 2, { 658, 575 } },
    { 378378, 2, { 637, 594 } },
    { 378400, 2, { 688, 550 } },
    { 378420, 2, { 636, 595 } },
    { 378444, 2, { 671, 564 } },
    { 378448, 2, { 763, 496 } },
    { 378450, 2, { 725, 522 } },
    { 378480, 2, { 664, 570 } },
    { 378525, 2, { 721, 525 } },
    { 378560, 2, { 676, 560 } },
    { 378576, 2, { 717, 528 } },
    { 378624, 2, { 696, 544 } },
    { 378636, 2, { 681, 556 } },
    { 378675, 2, { 675, 561 } },
    { 378684, 2, { 628, 603 } },
    { 378708, 2, { 627, 604 } },
    { 378750, 2, { 625, 606 } },
    { 378756, 2, { 668, 567 } },
    { 378784, 2, { 623, 608 } },
    { 378810, 2, { 621, 610 } },
    { 378820, 2, { 620, 611 } },
    { 378840, 2, { 616, 615 } },
    { 378852, 2, { 723, 524 } },
    { 378879, 2, { 867, 437 } },
    { 378885, 2, { 871, 435 } },
    { 378917, 2, { 703, 539 } },
    { 378950, 2, { 650, 583 } },
    { 378952, 2, { 707, 536 } },
    { 378972, 2, { 638, 594 } },
    { 379008, 2, { 658, 576 } },
    { 379040, 2, { 736, 515 } },
    { 379050, 2, { 665, 570 } },
    { 379080, 2, { 648, 585 } },
    { 379224, 2, { 687, 552 } },
    { 379236, 2, { 663, 572 } },
    { 379260, 2, { 630, 602 } },
    { 379316, 2, { 644, 589 } },
    { 379431, 2, { 621, 611 } },
    { 379440, 2, { 620, 612 } },
    { 379470, 2, { 695, 546 } },
    { 379476, 2, { 747, 508 } },
    { 379500, 2, { 660, 575 } },
    { 379512, 2, { 753, 504 } },
    { 379525, 2, { 799, 475 } },
    { 379533, 2, { 651, 583 } },
    { 379610, 2, { 638, 595 } },
    { 379665, 2, { 649, 585 } },
    { 379680, 2, { 672, 565 } },
    { 379692, 2, { 636, 597 } },
    { 379755, 2, { 783, 485 } },
    { 379760, 2, { 752, 505 } },
    { 379764, 2, { 693, 548 } },
    { 379800, 2, { 633, 600 } },
    { 379824, 2, { 656, 579 } },
    { 379848, 2, { 646, 588 } },
    { 379904, 2, { 742, 512 } },
    { 379908, 2, { 692, 549 } },
    { 379950, 2, { 745, 510 } },
    { 379992, 2, { 669, 568 } },
    { 379995, 2, { 705, 539 } },
    { 380000, 2, { 625, 608 } },
    { 380016, 2, { 624, 609 } },
    { 380030, 2, { 623, 610 } },
    { 380052, 2, { 621, 612 } },
    { 380064, 2, { 642, 592 } },
    { 380100, 2, { 700, 543 } },
    { 380120, 2, { 680, 559 } },
    { 380160, 2, { 640, 594 } },
    { 380184, 2, { 651, 584 } },
    { 380190, 2, { 667, 570 } },
    { 380196, 2, { 708, 537 } },
    { 380205, 2, { 639, 595 } },
    { 380240, 2, { 679, 560 } },
    { 380256, 2, { 699, 544 } },
    { 380275, 2, { 1025, 371 } },
    { 380292, 2, { 737, 516 } },
    { 380385, 2, { 711, 535 } },
    { 380432, 2, { 767, 496 } },
    { 380457, 2, { 671, 567 } },
    { 380472, 2, { 664, 573 } },
    { 380475, 2, { 801, 475 } },
    { 380494, 2, { 646, 589 } },
    { 380512, 2, { 736, 517 } },
    { 380545, 2, { 629, 605 } },
    { 380604, 2, { 644, 591 } },
    { 380625, 2, { 625, 609 } },
    { 380640, 2, { 624, 610 } },
    { 380646, 2, { 742, 513 } },
    { 380688, 2, { 618, 616 } },
    { 380700, 2, { 675, 564 } },
    { 380730, 2, { 686, 555 } },
    { 380765, 2, { 805, 473 } },
    { 380800, 2, { 640, 595 } },
    { 380835, 2, { 651, 585 } },
    { 380844, 2, { 639, 596 } },
    { 380880, 2, { 690, 552 } },
    { 380920, 2, { 712, 535 } },
    { 380926, 2, { 637, 598 } },
    { 380928, 2, { 744, 512 } },
    { 381000, 2, { 635, 600 } },
    { 381024, 2, { 648, 588 } },
    { 381060, 2, { 657, 580 } },
    { 381095, 2, { 715, 533 } },
    { 381096, 2, { 632, 603 } },
    { 381136, 2, { 656, 581 } },
    { 381150, 2, { 630, 605 } },
    { 381210, 2, { 655, 582 } },
    { 381216, 2, { 627, 608 } },
    { 381238, 2, { 682, 559 } },
    { 381264, 2, { 624, 611 } },
    { 381276, 2, { 623, 612 } },
    { 381300, 2, { 620, 615 } },
    { 381360, 2, { 681, 560 } },
    { 381375, 2, { 675, 565 } },
    { 381420, 2, { 652, 585 } },
    { 381425, 2, { 803, 475 } },
    { 381444, 2, { 717, 532 } },
    { 381480, 2, { 660, 578 } },
    { 381510, 2, { 785, 486 } },
    { 381546, 2, { 738, 517 } },
    { 381555, 2, { 695, 549 } },
    { 381570, 2, { 690, 553 } },
    { 381582, 2, { 731, 522 } },
    { 381612, 2, { 649, 588 } },
    { 381640, 2, { 658, 580 } },
    { 381672, 2, { 648, 589 } },
    { 381717, 2, { 657, 581 } },
    { 381744, 2, { 723, 528 } },
    { 381766, 2, { 737, 518 } },
    { 381792, 2, { 656, 582 } },
    { 381800, 2, { 664, 575 } },
    { 381810, 2, { 715, 534 } },
    { 381840, 2, { 645, 592 } },
    { 381875, 2, { 625, 611 } },
    { 381888, 2, { 624, 612 } },
    { 381915, 2, { 621, 615 } },
    { 381936, 2, { 654, 584 } },
    { 381938, 2, { 722, 529 } },
    { 381972, 2, { 687, 556 } },
    { 381990, 2, { 642, 595 } },
    { 381996, 2, { 729, 524 } },
    { 382025, 2, { 925, 413 } },
    { 382075, 2, { 725, 527 } },
    { 382080, 2, { 640, 597 } },
    { 382104, 2, { 696, 549 } },
    { 382109, 2, { 1183, 323 } },
    { 382130, 2, { 721, 530 } },
    { 382140, 2, { 660, 579 } },
    { 382185, 2, { 745, 513 } },
    { 382200, 2, { 637, 600 } },
    { 382230, 2, { 685, 558 } },
    { 382239, 2, { 891, 429 } },
    { 382272, 2, { 704, 543 } },
    { 382284, 2, { 666, 574 } },
    { 382320, 2, { 648, 590 } },
    { 382332, 2, { 633, 604 } },
    { 382344, 2, { 712, 537 } },
    { 382347, 2, { 833, 459 } },
    { 382356, 2, { 684, 559 } },
    { 382360, 2, { 632, 605 } },
    { 382395, 2, { 689, 555 } },
    { 382432, 2, { 629, 608 } },
    { 382448, 2, { 656, 583 } },
    { 382452, 2, { 628, 609 } },
    { 382500, 2, { 625, 612 } },
    { 382520, 2, { 655, 584 } },
    { 382524, 2, { 753, 508 } },
    { 382536, 2, { 621, 616 } },
    { 382580, 2, { 740, 517 } },
    { 382655, 2, { 841, 455 } },
    { 382668, 2, { 669, 572 } },
    { 382690, 2, { 710, 539 } },
    { 382704, 2, { 714, 536 } },
    { 382720, 2, { 640, 598 } },
    { 382764, 2, { 668, 573 } },
    { 382788, 2, { 651, 588 } },
    { 382800, 2, { 638, 600 } },
    { 382850, 2, { 650, 589 } },
    { 382851, 2, { 721, 531 } },
    { 382905, 2, { 635, 603 } },
    { 382925, 2, { 901, 425 } },
    { 382950, 2, { 666, 575 } },
    { 382968, 2, { 648, 591 } },
    { 382992, 2, { 632, 606 } },
    { 383019, 2, { 793, 483 } },
    { 383040, 2, { 630, 608 } },
    { 383052, 2, { 699, 548 } },
    { 383061, 2, { 629, 609 } },
    { 383097, 2, { 627, 611 } },
    { 383130, 2, { 645, 594 } },
    { 383145, 2, { 623, 615 } },
    { 383175, 2, { 655, 585 } },
    { 383229, 2, { 693, 553 } },
    { 383292, 2, { 676, 567 } },
    { 383328, 2, { 726, 528 } },
    { 383350, 2, { 697, 550 } },
    { 383400, 2, { 639, 600 } },
    { 383460, 2, { 660, 581 } },
    { 383488, 2, { 749, 512 } },
    { 383508, 2, { 636, 603 } },
    { 383525, 2, { 667, 575 } },
    { 383600, 2, { 685, 560 } },
    { 383614, 2, { 658, 583 } },
    { 383625, 2, { 775, 495 } },
    { 383656, 2, { 728, 527 } },
    { 383670, 2, { 630, 609 } },
    { 383680, 2, { 704, 545 } },
    { 383688, 2, { 657, 584 } },
    { 383724, 2, { 627, 612 } },
    { 383760, 2, { 624, 615 } },
    { 383768, 2, { 623, 616 } },
    { 383800, 2, { 760, 505 } },
    { 383838, 2, { 703, 546 } },
    { 383904, 2, { 688, 558 } },
    { 383940, 2, { 711, 540 } },
    { 384000, 2, { 640, 600 } },
    { 384054, 2, { 726, 529 } },
    { 384060, 2, { 692, 555 } },
    { 384084, 2, { 681, 564 } },
    { 384111, 2, { 637, 603 } },
    { 384160, 2, { 686, 560 } },
    { 384183, 2, { 729, 527 } },
    { 384192, 2, { 667, 576 } },
    { 384200, 2, { 680, 565 } },
    { 384208, 2, { 649, 592 } },
    { 384237, 2, { 749, 513 } },
    { 384252, 2, { 781, 492 } },
    { 384300, 2, { 630, 610 } },
    { 384307, 2, { 713, 539 } },
    { 384312, 2, { 717, 536 } },
    { 384370, 2, { 646, 595 } },
    { 384420, 2, { 645, 596 } },
    { 384444, 2, { 708, 543 } },
    { 384456, 2, { 664, 579 } },
    { 384462, 2, { 689, 558 } },
    { 384468, 2, { 644, 597 } },
    { 384540, 2, { 663, 580 } },
    { 384560, 2, { 760, 506 } },
    { 384608, 2, { 707, 544 } },
    { 384636, 2, { 723, 532 } },
    { 384659, 2, { 1331, 289 } },
    { 384705, 2, { 747, 515 } },
    { 384720, 2, { 687, 560 } },
    { 384744, 2, { 697, 552 } },
    { 384780, 2, { 636, 605 } },
    { 384800, 2, { 650, 592 } },
    { 384810, 2, { 635, 606 } },
    { 384846, 2, { 686, 561 } },
    { 384864, 2, { 633, 608 } },
    { 384888, 2, { 632, 609 } },
    { 384912, 2, { 648, 594 } },
    { 384930, 2, { 630, 611 } },
    { 384948, 2, { 629, 612 } },
    { 384975, 2, { 725, 531 } },
    { 384993, 2, { 679, 567 } },
    { 385000, 2, { 625, 616 } },
    { 385020, 2, { 621, 620 } },
    { 385050, 2, { 755, 510 } },
    { 385056, 2, { 672, 573 } },
    { 385104, 2, { 678, 568 } },
    { 385140, 2, { 655, 588 } },
    { 385152, 2, { 708, 544 } },
    { 385154, 2, { 671, 574 } },
    { 385175, 2, { 775, 497 } },
    { 385200, 2, { 642, 600 } },
    { 385280, 2, { 640, 602 } },
    { 385308, 2, { 693, 556 } },
    { 385332, 2, { 652, 591 } },
    { 385344, 2, { 669, 576 } },
    { 385392, 2, { 651, 592 } },
    { 385452, 2, { 747, 516 } },
    { 385506, 2, { 649, 594 } },
    { 385526, 2, { 667, 578 } },
    { 385536, 2, { 753, 512 } },
    { 385572, 2, { 759, 508 } },
    { 385632, 2, { 624, 618 } },
    { 385671, 2, { 899, 429 } },
    { 385672, 2, { 679, 568 } },
    { 385728, 2, { 656, 588 } },
    { 385825, 2, { 671, 575 } },
    { 385840, 2, { 689, 560 } },
    { 385848, 2, { 699, 552 } },
    { 385917, 2, { 799, 483 } },
    { 385920, 2, { 640, 603 } },
    { 385950, 2, { 775, 498 } },
    { 385956, 2, { 639, 604 } },
    { 385968, 2, { 688, 561 } },
    { 386008, 2, { 791, 488 } },
    { 386048, 2, { 754, 512 } },
    { 386080, 2, { 635, 608 } },
    { 386100, 2, { 650, 594 } },
    { 386155, 2, { 649, 595 } },
    { 386220, 2, { 628, 615 } },
    { 386232, 2, { 627, 616 } },
    { 386250, 2, { 625, 618 } },
    { 386260, 2, { 623, 620 } },
    { 386316, 2, { 657, 588 } },
    { 386325, 2, { 765, 505 } },
    { 386340, 2, { 685, 564 } },
    { 386370, 2, { 729, 530 } },
    { 386400, 2, { 644, 600 } },
    { 386425, 2, { 725, 533 } },
    { 386448, 2, { 664, 582 } },
    { 386456, 2, { 721, 536 } },
    { 386496, 2, { 671, 576 } },
    { 386512, 2, { 784, 493 } },
    { 386595, 2, { 639, 605 } },
    { 386616, 2, { 712, 543 } },
    { 386650, 2, { 703, 550 } },
    { 386688, 2, { 636, 608 } },
    { 386694, 2, { 651, 594 } },
    { 386750, 2, { 650, 595 } },
    { 386772, 2, { 668, 579 } },
    { 386802, 2, { 702, 551 } },
    { 386808, 2, { 681, 568 } },
    { 386856, 2, { 648, 597 } },
    { 386880, 2, { 624, 620 } },
    { 386883, 2, { 623, 621 } },
    { 386925, 2, { 737, 525 } },
    { 386946, 2, { 666, 581 } },
    { 386958, 2, { 726, 533 } },
    { 387000, 2, { 645, 600 } },
    { 387030, 2, { 665, 582 } },
    { 387040, 2, { 656, 590 } },
    { 387100, 2, { 700, 553 } },
    { 387150, 2, { 725, 534 } },
    { 387168, 2, { 654, 592 } },
    { 387180, 2, { 717, 540 } },
    { 387192, 2, { 663, 584 } },
    { 387200, 2, { 640, 605 } },
    { 387205, 2, { 805, 481 } },
    { 387280, 2, { 752, 515 } },
    { 387296, 2, { 637, 608 } },
    { 387315, 2, { 755, 513 } },
    { 387324, 2, { 636, 609 } },
    { 387348, 2, { 676, 573 } },
    { 387387, 2, { 693, 559 } },
    { 387396, 2, { 633, 612 } },
    { 387450, 2, { 630, 615 } },
    { 387464, 2, { 629, 616 } },
    { 387468, 2, { 687, 564 } },
    { 387495, 2, { 711, 545 } },
    { 387504, 2, { 624, 621 } },
    { 387528, 2, { 723, 536 } },
    { 387600, 2, { 646, 600 } },
    { 387695, 2, { 665, 583 } },
    { 387696, 2, { 656, 591 } },
    { 387760, 2, { 655, 592 } },
    { 387810, 2, { 695, 558 } },
    { 387828, 2, { 684, 567 } },
    { 387840, 2, { 640, 606 } },
    { 387855, 2, { 663, 585 } },
    { 387860, 2, { 820, 473 } },
    { 387872, 2, { 713, 544 } },
    { 387891, 2, { 917, 423 } },
    { 387904, 2, { 638, 608 } },
    { 387960, 2, { 636, 610 } },
    { 387996, 2, { 651, 596 } },
    { 388020, 2, { 669, 580 } },
    { 388025, 2, { 913, 425 } },
    { 388032, 2, { 688, 564 } },
    { 388040, 2, { 712, 545 } },
    { 388056, 2, { 703, 552 } },
    { 388075, 2, { 817, 475 } },
    { 388080, 2, { 630, 616 } },
    { 388125, 2, { 625, 621 } },
    { 388143, 2, { 707, 549 } },
    { 388206, 2, { 702, 553 } },
    { 388212, 2, { 692, 561 } },
    { 388278, 2, { 666, 583 } },
    { 388284, 2, { 741, 524 } },
    { 388314, 2, { 799, 486 } },
    { 388332, 2, { 644, 603 } },
    { 388360, 2, { 665, 584 } },
    { 388368, 2, { 696, 558 } },
    { 388395, 2, { 685, 567 } },
    { 388410, 2, { 642, 605 } },
    { 388416, 2, { 672, 578 } },
    { 388440, 2, { 664, 585 } },
    { 388485, 2, { 801, 485 } },
    { 388500, 2, { 700, 555 } },
    { 388512, 2, { 639, 608 } },
    { 388531, 2, { 1573, 247 } },
    { 388548, 2, { 753, 516 } },
    { 388557, 2, { 729, 533 } },
    { 388570, 2, { 637, 610 } },
    { 388575, 2, { 785, 495 } },
    { 388608, 2, { 704, 552 } },
    { 388620, 2, { 635, 612 } },
    { 388644, 2, { 699, 556 } },
    { 388680, 2, { 632, 615 } },
    { 388692, 2, { 708, 549 } },
    { 388700, 2, { 650, 598 } },
    { 388720, 2, { 688, 565 } },
    { 388740, 2, { 627, 620 } },
    { 388752, 2, { 624, 623 } },
    { 388773, 2, { 693, 561 } },
    { 388788, 2, { 716, 543 } },
    { 388800, 2, { 648, 600 } },
    { 388815, 2, { 735, 529 } },
    { 388850, 2, { 707, 550 } },
    { 388890, 2, { 745, 522 } },
    { 388926, 2, { 697, 558 } },
    { 388944, 2, { 657, 592 } },
    { 388962, 2, { 686, 567 } },
    { 389025, 2, { 665, 585 } },
    { 389064, 2, { 696, 559 } },
    { 389070, 2, { 655, 594 } },
    { 389080, 2, { 685, 568 } },
    { 389088, 2, { 672, 579 } },
    { 389130, 2, { 654, 595 } },
    { 389136, 2, { 726, 536 } },
    { 389158, 2, { 722, 539 } },
    { 389200, 2, { 695, 560 } },
    { 389207, 2, { 637, 611 } },
    { 389244, 2, { 652, 597 } },
    { 389270, 2, { 670, 581 } },
    { 389375, 2, { 625, 623 } },
    { 389400, 2, { 649, 600 } },
    { 389480, 2, { 728, 535 } },
    { 389500, 2, { 779, 500 } },
    { 389532, 2, { 681, 572 } },
    { 389536, 2, { 658, 592 } },
    { 389580, 2, { 645, 604 } },
    { 389628, 2, { 711, 548 } },
    { 389640, 2, { 680, 573 } },
    { 389664, 2, { 656, 594 } },
    { 389760, 2, { 640, 609 } },
    { 389818, 2, { 638, 611 } },
    { 389844, 2, { 637, 612 } },
    { 389850, 2, { 678, 575 } },
    { 389865, 2, { 705, 553 } },
    { 389928, 2, { 633, 616 } },
    { 389980, 2, { 629, 620 } },
    { 389988, 2, { 628, 621 } },
    { 390000, 2, { 625, 624 } },
    { 390015, 2, { 729, 535 } },
    { 390048, 2, { 717, 544 } },
    { 390060, 2, { 660, 591 } },
    { 390080, 2, { 736, 530 } },
    { 390096, 2, { 648, 602 } },
    { 390144, 2, { 762, 512 } },
    { 390150, 2, { 675, 578 } },
    { 390195, 2, { 667, 585 } },
    { 390216, 2, { 687, 568 } },
    { 390320, 2, { 656, 595 } },
    { 390336, 2, { 642, 608 } },
    { 390390, 2, { 715, 546 } },
    { 390400, 2, { 640, 610 } },
    { 390420, 2, { 723, 540 } },
    { 390425, 2, { 679, 575 } },
    { 390450, 2, { 685, 570 } },
    { 390456, 2, { 638, 612 } },
    { 390507, 2, { 663, 589 } },
    { 390528, 2, { 678, 576 } },
    { 390576, 2, { 632, 618 } },
    { 390609, 2, { 629, 621 } },
    { 390656, 2, { 763, 512 } },
    { 390663, 2, { 689, 567 } },
    { 390696, 2, { 669, 584 } },
    { 390698, 2, { 649, 602 } },
    { 390720, 2, { 660, 592 } },
    { 390728, 2, { 676, 578 } },
    { 390744, 2, { 648, 603 } },
    { 390775, 2, { 725, 539 } },
    { 390780, 2, { 668, 585 } },
    { 390830, 2, { 646, 605 } },
    { 390852, 2, { 658, 594 } },
    { 390888, 2, { 712, 549 } },
    { 390915, 2, { 657, 595 } },
    { 390930, 2, { 785, 498 } },
    { 390960, 2, { 720, 543 } },
    { 391000, 2, { 680, 575 } },
    { 391017, 2, { 697, 561 } },
    { 391020, 2, { 665, 588 } },
    { 391040, 2, { 640, 611 } },
    { 391068, 2, { 639, 612 } },
    { 391104, 2, { 672, 582 } },
    { 391140, 2, { 636, 615 } },
    { 391160, 2, { 635, 616 } },
    { 391248, 2, { 627, 624 } },
    { 391300, 2, { 650, 602 } },
    { 391391, 2, { 1001, 391 } },
    { 391400, 2, { 760, 515 } },
    { 391404, 2, { 676, 579 } },
    { 391419, 2, { 763, 513 } },
    { 391428, 2, { 747, 524 } },
    { 391440, 2, { 699, 560 } },
    { 391500, 2, { 675, 580 } },
    { 391524, 2, { 708, 553 } },
    { 391545, 2, { 693, 565 } },
    { 391552, 2, { 644, 608 } },
    { 391560, 2, { 753, 520 } },
    { 391572, 2, { 657, 596 } },
    { 391632, 2, { 656, 597 } },
    { 391644, 2, { 759, 516 } },
    { 391680, 2, { 640, 612 } },
    { 391685, 2, { 665, 589 } },
    { 391755, 2, { 637, 615 } },
    { 391875, 2, { 627, 625 } },
    { 391880, 2, { 776, 505 } },
    { 391920, 2, { 690, 568 } },
    { 391932, 2, { 684, 573 } },
    { 391980, 2, { 695, 564 } },
    { 391989, 2, { 741, 529 } },
    { 392040, 2, { 648, 605 } },
    { 392049, 2, { 889, 441 } },
    { 392084, 2, { 737, 532 } },
    { 392150, 2, { 682, 575 } },
    { 392160, 2, { 645, 608 } },
    { 392175, 2, { 675, 581 } },
    { 392196, 2, { 644, 609 } },
    { 392224, 2, { 721, 544 } },
    { 392256, 2, { 681, 576 } },
    { 392275, 2, { 923, 425 } },
    { 392336, 2, { 791, 496 } },
    { 392364, 2, { 692, 567 } },
    { 392385, 2, { 707, 555 } },
    { 392392, 2, { 637, 616 } },
    { 392400, 2, { 654, 600 } },
    { 392418, 2, { 702, 559 } },
    { 392424, 2, { 664, 591 } },
    { 392430, 2, { 635, 618 } },
    { 392460, 2, { 633, 620 } },
    { 392472, 2, { 632, 621 } },
    { 392490, 2, { 630, 623 } },
    { 392496, 2, { 629, 624 } },
    { 392535, 2, { 671, 585 } },
    { 392616, 2, { 684, 574 } },
    { 392630, 2, { 710, 553 } },
    { 392688, 2, { 648, 606 } },
    { 392700, 2, { 660, 595 } },
    { 392704, 2, { 767, 512 } },
    { 392730, 2, { 689, 570 } },
    { 392832, 2, { 682, 576 } },
    { 392916, 2, { 717, 548 } },
    { 392920, 2, { 760, 517 } },
    { 392931, 2, { 693, 567 } },
    { 392940, 2, { 666, 590 } },
    { 392964, 2, { 687, 572 } },
    { 393000, 2, { 655, 600 } },
    { 393008, 2, { 638, 616 } },
    { 393084, 2, { 716, 549 } },
    { 393120, 2, { 630, 624 } },
    { 393125, 2, { 629, 625 } },
    { 393156, 2, { 652, 603 } },
    { 393204, 2, { 651, 604 } },
    { 393300, 2, { 684, 575 } },
    { 393312, 2, { 723, 544 } },
    { 393328, 2, { 793, 496 } },
    { 393372, 2, { 669, 588 } },
    { 393390, 2, { 705, 558 } },
    { 393421, 2, { 1147, 343 } },
    { 393470, 2, { 730, 539 } },
    { 393484, 2, { 644, 611 } },
    { 393525, 2, { 675, 583 } },
    { 393576, 2, { 713, 552 } },
    { 393600, 2, { 640, 615 } },
    { 393624, 2, { 639, 616 } },
    { 393660, 2, { 729, 540 } },
    { 393680, 2, { 665, 592 } },
    { 393720, 2, { 680, 579 } },
    { 393736, 2, { 632, 623 } },
    { 393750, 2, { 630, 625 } },
    { 393756, 2, { 628, 627 } },
    { 393760, 2, { 736, 535 } },
    { 393813, 2, { 893, 441 } },
    { 393820, 2, { 679, 580 } },
    { 393822, 2, { 663, 594 } },
    { 393960, 2, { 670, 588 } },
    { 393965, 2, { 715, 551 } },
    { 393975, 2, { 765, 515 } },
    { 393984, 2, { 648, 608 } },
    { 394009, 2, { 731, 539 } },
    { 394020, 2, { 660, 597 } },
    { 394065, 2, { 695, 567 } },
    { 394095, 2, { 645, 611 } },
    { 394110, 2, { 755, 522 } },
    { 394128, 2, { 644, 612 } },
    { 394174, 2, { 779, 506 } },
    { 394200, 2, { 657, 600 } },
    { 394212, 2, { 722, 546 } },
    { 394224, 2, { 688, 573 } },
    { 394236, 2, { 699, 564 } },
    { 394240, 2, { 640, 616 } },
    { 394272, 2, { 666, 592 } },
    { 394335, 2, { 635, 621 } },
    { 394383, 2, { 629, 627 } },
    { 394416, 2, { 664, 594 } },
    { 394420, 2, { 740, 533 } },
    { 394450, 2, { 686, 575 } },
    { 394548, 2, { 671, 588 } },
    { 394560, 2, { 685, 576 } },
    { 394572, 2, { 753, 524 } },
    { 394592, 2, { 649, 608 } },
    { 394611, 2, { 817, 483 } },
    { 394625, 2, { 875, 451 } },
    { 394632, 2, { 648, 609 } },
    { 394680, 2, { 660, 598 } },
    { 394740, 2, { 645, 612 } },
    { 394760, 2, { 695, 568 } },
    { 394788, 2, { 668, 591 } },
    { 394800, 2, { 658, 600 } },
    { 394912, 2, { 656, 602 } },
    { 394940, 2, { 637, 620 } },
    { 394944, 2, { 704, 561 } },
    { 394956, 2, { 636, 621 } },
    { 394965, 2, { 655, 603 } },
    { 394975, 2, { 925, 427 } },
    { 394980, 2, { 681, 580 } },
    { 394992, 2, { 633, 624 } },
    { 395000, 2, { 632, 625 } },
    { 395010, 2, { 630, 627 } },
    { 395076, 2, { 803, 492 } },
    { 395080, 2, { 664, 595 } },
    { 395115, 2, { 795, 497 } },
    { 395136, 2, { 672, 588 } },
    { 395148, 2, { 663, 596 } },
    { 395160, 2, { 712, 555 } },
    { 395199, 2, { 697, 567 } },
    { 395200, 2, { 650, 608 } },
    { 395241, 2, { 649, 609 } },
    { 395250, 2, { 750, 527 } },
    { 395280, 2, { 648, 610 } },
    { 395316, 2, { 711, 556 } },
    { 395352, 2, { 646, 612 } },
    { 395415, 2, { 783, 505 } },
    { 395428, 2, { 817, 484 } },
    { 395460, 2, { 676, 585 } },
    { 395472, 2, { 642, 616 } },
    { 395486, 2, { 689, 574 } },
    { 395520, 2, { 640, 618 } },
    { 395568, 2, { 656, 603 } },
    { 395577, 2, { 637, 621 } },
    { 395595, 2, { 745, 531 } },
    { 395600, 2, { 688, 575 } },
    { 395670, 2, { 654, 605 } },
    { 395692, 2, { 748, 529 } },
    { 395712, 2, { 687, 576 } },
    { 395760, 2, { 680, 582 } },
    { 395784, 2, { 717, 552 } },
    { 395808, 2, { 651, 608 } },
    { 395829, 2, { 721, 549 } },
    { 395850, 2, { 650, 609 } },
    { 395901, 2, { 837, 473 } },
    { 395920, 2, { 707, 560 } },
    { 395928, 2, { 648, 611 } },
    { 395952, 2, { 678, 584 } },
    { 396025, 2, { 775, 511 } },
    { 396036, 2, { 684, 579 } },
    { 396048, 2, { 669, 592 } },
    { 396060, 2, { 644, 615 } },
    { 396150, 2, { 695, 570 } },
    { 396165, 2, { 735, 539 } },
    { 396175, 2, { 689, 575 } },
    { 396180, 2, { 639, 620 } },
    { 396198, 2, { 638, 621 } },
    { 396204, 2, { 723, 548 } },
    { 396228, 2, { 636, 623 } },
    { 396240, 2, { 635, 624 } },
    { 396264, 2, { 632, 627 } },
    { 396270, 2, { 630, 629 } },
    { 396396, 2, { 693, 572 } },
    { 396408, 2, { 664, 597 } },
    { 396440, 2, { 680, 583 } },
    { 396480, 2, { 672, 590 } },
    { 396508, 2, { 686, 578 } },
    { 396516, 2, { 692, 573 } },
    { 396536, 2, { 679, 584 } },
    { 396550, 2, { 721, 550 } },
    { 396552, 2, { 744, 533 } },
    { 396640, 2, { 670, 592 } },
    { 396720, 2, { 684, 580 } },
    { 396760, 2, { 728, 545 } },
    { 396800, 2, { 640, 620 } },
    { 396828, 2, { 657, 604 } },
    { 396864, 2, { 636, 624 } },
    { 396865, 2, { 667, 595 } },
    { 396880, 2, { 656, 605 } },
    { 396930, 2, { 655, 606 } },
    { 397032, 2, { 699, 568 } },
    { 397056, 2, { 704, 564 } },
    { 397068, 2, { 652, 609 } },
    { 397100, 2, { 722, 550 } },
    { 397150, 2, { 650, 611 } },
    { 397152, 2, { 672, 591 } },
    { 397155, 2, { 913, 435 } },
    { 397176, 2, { 741, 536 } },
    { 397188, 2, { 649, 612 } },
    { 397215, 2, { 679, 585 } },
    { 397232, 2, { 671, 592 } },
    { 397243, 2, { 737, 539 } },
    { 397296, 2, { 712, 558 } },
    { 397305, 2, { 729, 545 } },
    { 397306, 2, { 767, 518 } },
    { 397320, 2, { 645, 616 } },
    { 397341, 2, { 833, 477 } },
    { 397358, 2, { 754, 527 } },
    { 397380, 2, { 716, 555 } },
    { 397404, 2, { 684, 581 } },
    { 397440, 2, { 640, 621 } },
    { 397476, 2, { 724, 549 } },
    { 397485, 2, { 657, 605 } },
    { 397488, 2, { 637, 624 } },
    { 397500, 2, { 636, 625 } },
    { 397524, 2, { 633, 628 } },
    { 397536, 2, { 656, 606 } },
    { 397575, 2, { 675, 589 } },
    { 397584, 2, { 753, 528 } },
    { 397620, 2, { 705, 564 } },
    { 397632, 2, { 654, 608 } },
    { 397670, 2, { 665, 598 } },
    { 397704, 2, { 681, 584 } },
    { 397716, 2, { 759, 524 } },
    { 397719, 2, { 749, 531 } },
    { 397760, 2, { 704, 565 } },
    { 397761, 2, { 651, 611 } },
    { 397800, 2, { 650, 612 } },
    { 397830, 2, { 745, 534 } },
    { 397836, 2, { 771, 516 } },
    { 397880, 2, { 686, 580 } },
    { 397936, 2, { 646, 616 } },
    { 397969, 2, { 1331, 299 } },
    { 397980, 2, { 660, 603 } },
    { 398025, 2, { 725, 549 } },
    { 398097, 2, { 639, 623 } },
    { 398112, 2, { 638, 624 } },
    { 398125, 2, { 637, 625 } },
    { 398160, 2, { 632, 630 } },
    { 398164, 2, { 676, 589 } },
    { 398208, 2, { 732, 544 } },
    { 398240, 2, { 655, 608 } },
    { 398250, 2, { 675, 590 } },
    { 398352, 2, { 688, 579 } },
    { 398412, 2, { 651, 612 } },
    { 398460, 2, { 687, 580 } },
    { 398475, 2, { 693, 575 } },
    { 398520, 2, { 648, 615 } },
    { 398560, 2, { 752, 530 } },
    { 398574, 2, { 671, 594 } },
    { 398601, 2, { 703, 567 } },
    { 398652, 2, { 717, 556 } },
    { 398670, 2, { 685, 582 } },
    { 398684, 2, { 697, 572 } },
    { 398720, 2, { 640, 623 } },
    { 398724, 2, { 669, 596 } },
    { 398736, 2, { 639, 624 } },
    { 398750, 2, { 638, 625 } },
    { 398772, 2, { 636, 627 } },
    { 398796, 2, { 668, 597 } },
    { 398808, 2, { 696, 573 } },
    { 398825, 2, { 1075, 371 } },
    { 398860, 2, { 740, 539 } },
    { 398866, 2, { 667, 598 } },
    { 398905, 2, { 1105, 361 } },
    { 398970, 2, { 682, 585 } },
    { 399000, 2, { 665, 600 } },
    { 399096, 2, { 723, 552 } },
    { 399135, 2, { 649, 615 } },
    { 399168, 2, { 648, 616 } },
    { 399245, 2, { 671, 595 } },
    { 399252, 2, { 679, 588 } },
    { 399300, 2, { 660, 605 } },
    { 399360, 2, { 640, 624 } },
    { 399375, 2, { 639, 625 } },
    { 399399, 2, { 637, 627 } },
    { 399432, 2, { 712, 561 } },
    { 399456, 2, { 657, 608 } },
    { 399492, 2, { 729, 548 } },
    { 399500, 2, { 799, 500 } },
    { 399504, 2, { 656, 609 } },
    { 399516, 2, { 676, 591 } },
    { 399588, 2, { 804, 497 } },
    { 399600, 2, { 666, 600 } },
    { 399620, 2, { 689, 580 } },
    { 399627, 2, { 779, 513 } },
    { 399640, 2, { 776, 515 } },
    { 399645, 2, { 747, 535 } },
    { 399672, 2, { 728, 549 } },
    { 399685, 2, { 715, 559 } },
    { 399735, 2, { 705, 567 } },
    { 399784, 2, { 649, 616 } },
    { 399828, 2, { 699, 572 } },
    { 399840, 2, { 672, 595 } },
    { 399900, 2, { 645, 620 } },
    { 399924, 2, { 644, 621 } },
    { 399938, 2, { 686, 583 } },
    { 399993, 2, { 713, 561 } },
    { 400000, 2, { 640, 625 } },
    { 400040, 2, { 685, 584 } },
    { 400050, 2, { 635, 630 } },
    { 400056, 2, { 633, 632 } },
    { 400064, 2, { 658, 608 } },
    { 400140, 2, { 684, 585 } },
    { 400155, 2, { 721, 555 } },
    { 400158, 2, { 774, 517 } },
    { 400160, 2, { 656, 610 } },
    { 400200, 2, { 667, 600 } },
    { 400320, 2, { 695, 576 } },
    { 400350, 2, { 785, 510 } },
    { 400392, 2, { 664, 603 } },
    { 400416, 2, { 688, 582 } },
    { 400428, 2, { 681, 588 } },
    { 400440, 2, { 705, 568 } },
    { 400452, 2, { 663, 604 } },
    { 400464, 2, { 648, 618 } },
    { 400545, 2, { 645, 621 } },
    { 400554, 2, { 693, 578 } },
    { 400596, 2, { 753, 532 } },
    { 400608, 2, { 642, 624 } },
    { 400610, 2, { 679, 590 } },
    { 400668, 2, { 692, 579 } },
    { 400673, 2, { 637, 629 } },
    { 400675, 2, { 775, 517 } },
    { 400710, 2, { 703, 570 } },
    { 400725, 2, { 685, 585 } },
    { 400752, 2, { 726, 552 } },
    { 400775, 2, { 697, 575 } },
    { 400816, 2, { 656, 611 } },
    { 400860, 2, { 655, 612 } },
    { 400869, 2, { 707, 567 } },
    { 400890, 2, { 690, 581 } },
    { 400896, 2, { 696, 576 } },
    { 400905, 2, { 755, 531 } },
    { 400920, 2, { 771, 520 } },
    { 400925, 2, { 725, 553 } },
    { 400928, 2, { 737, 544 } },
    { 400932, 2, { 666, 602 } },
    { 400980, 2, { 652, 615 } },
    { 400995, 2, { 665, 603 } },
    { 401004, 2, { 711, 564 } },
    { 401016, 2, { 651, 616 } },
    { 401100, 2, { 700, 573 } },
    { 401104, 2, { 688, 583 } },
    { 401115, 2, { 663, 605 } },
    { 401120, 2, { 736, 545 } },
    { 401128, 2, { 728, 551 } },
    { 401184, 2, { 672, 597 } },
    { 401208, 2, { 687, 584 } },
    { 401250, 2, { 642, 625 } },
    { 401280, 2, { 640, 627 } },
    { 401292, 2, { 639, 628 } },
    { 401302, 2, { 638, 629 } },
    { 401310, 2, { 637, 630 } },
    { 401320, 2, { 635, 632 } },
    { 401376, 2, { 678, 592 } },
    { 401400, 2, { 669, 600 } },
    { 401408, 2, { 784, 512 } },
    { 401436, 2, { 708, 567 } },
    { 401450, 2, { 775, 518 } },
    { 401464, 2, { 749, 536 } },
    { 401472, 2, { 656, 612 } },
    { 401505, 2, { 923, 435 } },
    { 401520, 2, { 717, 560 } },
    { 401544, 2, { 676, 594 } },
    { 401576, 2, { 707, 568 } },
    { 401625, 2, { 675, 595 } },
    { 401676, 2, { 716, 561 } },
    { 401679, 2, { 729, 551 } },
    { 401709, 2, { 777, 517 } },
    { 401715, 2, { 711, 565 } },
    { 401720, 2, { 664, 605 } },
    { 401760, 2, { 648, 620 } },
    { 401793, 2, { 1007, 399 } },
    { 401800, 2, { 700, 574 } },
    { 401820, 2, { 724, 555 } },
    { 401835, 2, { 645, 623 } },
    { 401841, 2, { 891, 451 } },
    { 401856, 2, { 644, 624 } },
    { 401880, 2, { 680, 591 } },
    { 401940, 2, { 638, 630 } },
    { 401968, 2, { 679, 592 } },
    { 401988, 2, { 723, 556 } },
    { 402000, 2, { 670, 600 } },
    { 402040, 2, { 760, 529 } },
    { 402050, 2, { 731, 550 } },
    { 402084, 2, { 657, 612 } },
    { 402116, 2, { 703, 572 } },
    { 402270, 2, { 690, 583 } },
    { 402280, 2, { 712, 565 } },
    { 402300, 2, { 675, 596 } },
    { 402320, 2, { 752, 535 } },
    { 402336, 2, { 762, 528 } },
    { 402380, 2, { 649, 620 } },
    { 402384, 2, { 664, 606 } },
    { 402402, 2, { 737, 546 } },
    { 402408, 2, { 648, 621 } },
    { 402480, 2, { 645, 624 } },
    { 402500, 2, { 644, 625 } },
    { 402560, 2, { 640, 629 } },
    { 402584, 2, { 637, 632 } },
    { 402588, 2, { 636, 633 } },
    { 402597, 2, { 837, 481 } },
    { 402600, 2, { 660, 610 } },
    { 402624, 2, { 699, 576 } },
    { 402633, 2, { 693, 581 } },
    { 402675, 2, { 767, 525 } },
    { 402688, 2, { 704, 572 } },
    { 402696, 2, { 658, 612 } },
    { 402705, 2, { 785, 513 } },
    { 402780, 2, { 685, 588 } },
    { 402804, 2, { 668, 603 } },
    { 402864, 2, { 654, 616 } },
    { 402876, 2, { 684, 589 } },
    { 402930, 2, { 666, 605 } },
    { 402948, 2, { 702, 574 } },
    { 402960, 2, { 690, 584 } },
    { 402984, 2, { 696, 579 } },
    { 402990, 2, { 665, 606 } },
    { 402996, 2, { 781, 516 } },
    { 403025, 2, { 1175, 343 } },
    { 403029, 2, { 649, 621 } },
    { 403065, 2, { 689, 585 } },
    { 403104, 2, { 646, 624 } },
    { 403152, 2, { 681, 592 } },
    { 403155, 2, { 765, 527 } },
    { 403170, 2, { 755, 534 } },
    { 403172, 2, { 748, 539 } },
    { 403200, 2, { 640, 630 } },
    { 403245, 2, { 783, 515 } },
    { 403260, 2, { 660, 611 } },
    { 403325, 2, { 949, 425 } },
    { 403326, 2, { 679, 594 } },
    { 403380, 2, { 747, 540 } },
    { 403392, 2, { 704, 573 } },
    { 403403, 2, { 1001, 403 } },
    { 403410, 2, { 678, 595 } },
    { 403425, 2, { 815, 495 } },
    { 403440, 2, { 656, 615 } },
    { 403480, 2, { 655, 616 } },
    { 403512, 2, { 731, 552 } },
    { 403535, 2, { 667, 605 } },
    { 403560, 2, { 684, 590 } },
    { 403572, 2, { 676, 597 } },
    { 403608, 2, { 753, 536 } },
    { 403620, 2, { 651, 620 } },
    { 403648, 2, { 742, 544 } },
    { 403650, 2, { 650, 621 } },
    { 403690, 2, { 730, 553 } },
    { 403704, 2, { 648, 623 } },
    { 403750, 2, { 646, 625 } },
    { 403760, 2, { 721, 560 } },
    { 403788, 2, { 644, 627 } },
    { 403848, 2, { 639, 632 } },
    { 403860, 2, { 636, 635 } },
    { 403942, 2, { 671, 602 } },
    { 403956, 2, { 687, 588 } },
    { 404000, 2, { 800, 505 } },
    { 404004, 2, { 771, 524 } },
    { 404019, 2, { 693, 583 } },
    { 404040, 2, { 728, 555 } },
    { 404054, 2, { 686, 589 } },
    { 404076, 2, { 669, 604 } },
    { 404085, 2, { 869, 465 } },
    { 404225, 2, { 703, 575 } },
    { 404244, 2, { 684, 591 } },
    { 404260, 2, { 697, 580 } },
    { 404271, 2, { 651, 621 } },
    { 404320, 2, { 665, 608 } },
    { 404376, 2, { 664, 609 } },
    { 404388, 2, { 717, 564 } },
    { 404397, 2, { 917, 441 } },
    { 404490, 2, { 695, 582 } },
    { 404505, 2, { 801, 505 } },
    { 404544, 2, { 672, 602 } },
    { 404547, 2, { 759, 533 } },
    { 404550, 2, { 725, 558 } },
    { 404558, 2, { 781, 518 } },
    { 404586, 2, { 741, 546 } },
    { 404595, 2, { 729, 555 } },
    { 404600, 2, { 680, 595 } },
    { 404670, 2, { 658, 615 } },
    { 404685, 2, { 765, 529 } },
    { 404712, 2, { 657, 616 } },
    { 404736, 2, { 744, 544 } },
    { 404790, 2, { 655, 618 } },
    { 404796, 2, { 732, 553 } },
    { 404800, 2, { 704, 575 } },
    { 404811, 2, { 783, 517 } },
    { 404820, 2, { 692, 585 } },
    { 404838, 2, { 714, 567 } },
    { 404880, 2, { 723, 560 } },
    { 404892, 2, { 652, 621 } },
    { 404928, 2, { 666, 608 } },
    { 404950, 2, { 650, 623 } },
    { 404976, 2, { 649, 624 } },
    { 404992, 2, { 791, 512 } },
    { 405000, 2, { 648, 625 } },
    { 405015, 2, { 871, 465 } },
    { 405060, 2, { 645, 628 } },
    { 405072, 2, { 696, 582 } },
    { 405076, 2, { 644, 629 } },
    { 405080, 2, { 760, 533 } },
    { 405108, 2, { 682, 594 } },
    { 405120, 2, { 640, 633 } },
    { 405132, 2, { 637, 636 } },
    { 405153, 2, { 763, 531 } },
    { 405216, 2, { 672, 603 } },
    { 405275, 2, { 725, 559 } },
    { 405300, 2, { 700, 579 } },
    { 405324, 2, { 729, 556 } },
    { 405408, 2, { 656, 618 } },
    { 405420, 2, { 699, 580 } },
    { 405520, 2, { 685, 592 } },
    { 405536, 2, { 667, 608 } },
    { 405552, 2, { 714, 568 } },
    { 405600, 2, { 650, 624 } },
    { 405625, 2, { 649, 625 } },
    { 405657, 2, { 959, 423 } },
    { 405684, 2, { 708, 573 } },
    { 405720, 2, { 644, 630 } },
    { 405744, 2, { 642, 632 } },
    { 405756, 2, { 663, 612 } },
    { 405765, 2, { 639, 635 } },
    { 405783, 2, { 791, 513 } },
    { 405790, 2, { 682, 595 } },
    { 405834, 2, { 726, 559 } },
    { 405840, 2, { 712, 570 } },
    { 405870, 2, { 815, 498 } },
    { 405876, 2, { 681, 596 } },
    { 405880, 2, { 695, 584 } },
    { 405900, 2, { 660, 615 } },
    { 405920, 2, { 688, 590 } },
    { 405945, 2, { 837, 485 } },
    { 405960, 2, { 680, 597 } },
    { 405972, 2, { 716, 567 } },
    { 406016, 2, { 793, 512 } },
    { 406068, 2, { 741, 548 } },
    { 406080, 2, { 705, 576 } },
    { 406112, 2, { 686, 592 } },
    { 406164, 2, { 724, 561 } },
    { 406224, 2, { 651, 624 } },
    { 406245, 2, { 795, 511 } },
    { 406260, 2, { 666, 610 } },
    { 406296, 2, { 648, 627 } },
    { 406315, 2, { 665, 611 } },
    { 406350, 2, { 645, 630 } },
    { 406400, 2, { 640, 635 } },
    { 406404, 2, { 639, 636 } },
    { 406406, 2, { 638, 637 } },
    { 406410, 2, { 690, 589 } },
    { 406455, 2, { 735, 553 } },
    { 406504, 2, { 833, 488 } },
    { 406525, 2, { 707, 575 } },
    { 406575, 2, { 695, 585 } },
    { 406600, 2, { 760, 535 } },
    { 406608, 2, { 688, 591 } },
    { 406620, 2, { 753, 540 } },
    { 406640, 2, { 680, 598 } },
    { 406692, 2, { 711, 572 } },
    { 406700, 2, { 700, 581 } },
    { 406704, 2, { 687, 592 } },
    { 406752, 2, { 669, 608 } },
    { 406755, 2, { 655, 621 } },
    { 406770, 2, { 745, 546 } },
    { 406800, 2, { 678, 600 } },
    { 406812, 2, { 668, 609 } },
    { 406824, 2, { 737, 552 } },
    { 406847, 2, { 931, 437 } },
    { 406875, 2, { 651, 625 } },
    { 406890, 2, { 685, 594 } },
    { 406912, 2, { 704, 578 } },
    { 406926, 2, { 666, 611 } },
    { 406980, 2, { 646, 630 } },
    { 407040, 2, { 640, 636 } },
    { 407043, 2, { 639, 637 } },
    { 407088, 2, { 771, 528 } },
    { 407115, 2, { 747, 545 } },
    { 407148, 2, { 777, 524 } },
    { 407160, 2, { 696, 585 } },
    { 407232, 2, { 672, 606 } },
    { 407253, 2, { 861, 473 } },
    { 407256, 2, { 717, 568 } },
    { 407330, 2, { 770, 529 } },
    { 407340, 2, { 657, 620 } },
    { 407360, 2, { 670, 608 } },
    { 407376, 2, { 656, 621 } },
    { 407400, 2, { 679, 600 } },
    { 407407, 2, { 847, 481 } },
    { 407456, 2, { 749, 544 } },
    { 407484, 2, { 686, 594 } },
    { 407511, 2, { 729, 559 } },
    { 407550, 2, { 650, 627 } },
    { 407592, 2, { 648, 629 } },
    { 407616, 2, { 704, 579 } },
    { 407628, 2, { 676, 603 } },
    { 407640, 2, { 645, 632 } },
    { 407652, 2, { 644, 633 } },
    { 407670, 2, { 642, 635 } },
    { 407680, 2, { 640, 637 } },
    { 407700, 2, { 675, 604 } },
    { 407740, 2, { 703, 580 } },
    { 407772, 2, { 723, 564 } },
    { 407808, 2, { 708, 576 } },
    { 407827, 2, { 1189, 343 } },
    { 407835, 2, { 795, 513 } },
    { 407862, 2, { 702, 581 } },
    { 407888, 2, { 689, 592 } },
    { 407898, 2, { 731, 558 } },
    { 407960, 2, { 658, 620 } },
    { 407968, 2, { 671, 608 } },
    { 407976, 2, { 712, 573 } },
    { 408044, 2, { 767, 532 } },
    { 408051, 2, { 889, 459 } },
    { 408096, 2, { 654, 624 } },
    { 408100, 2, { 700, 583 } },
    { 408204, 2, { 667, 612 } },
    { 408216, 2, { 699, 584 } },
    { 408240, 2, { 648, 630 } },
    { 408291, 2, { 741, 551 } },
    { 408320, 2, { 640, 638 } },
    { 408348, 2, { 684, 597 } },
    { 408360, 2, { 664, 615 } },
    { 408375, 2, { 675, 605 } },
    { 408408, 2, { 663, 616 } },
    { 408432, 2, { 762, 536 } },
    { 408480, 2, { 690, 592 } },
    { 408500, 2, { 817, 500 } },
    { 408595, 2, { 935, 437 } },
    { 408600, 2, { 681, 600 } },
    { 408618, 2, { 658, 621 } },
    { 408639, 2, { 671, 609 } },
    { 408660, 2, { 695, 588 } },
    { 408672, 2, { 688, 594 } },
    { 408688, 2, { 656, 623 } },
    { 408720, 2, { 655, 624 } },
    { 408750, 2, { 654, 625 } },
    { 408804, 2, { 652, 627 } },
    { 408807, 2, { 721, 567 } },
    { 408825, 2, { 711, 575 } },
    { 408828, 2, { 651, 628 } },
    { 408850, 2, { 650, 629 } },
    { 408870, 2, { 649, 630 } },
    { 408900, 2, { 705, 580 } },
    { 408960, 2, { 640, 639 } },
    { 408968, 2, { 763, 536 } },
    { 408969, 2, { 729, 561 } },
    { 408972, 2, { 692, 591 } },
    { 408980, 2, { 676, 605 } },
    { 409005, 2, { 745, 549 } },
    { 409032, 2, { 684, 598 } },
    { 409035, 2, { 737, 555 } },
    { 409045, 2, { 899, 455 } },
    { 409101, 2, { 759, 539 } },
    { 409220, 2, { 740, 553 } },
    { 409248, 2, { 672, 609 } },
    { 409266, 2, { 689, 594 } },
    { 409275, 2, { 765, 535 } },
    { 409311, 2, { 657, 623 } },
    { 409356, 2, { 747, 548 } },
    { 409360, 2, { 680, 602 } },
    { 409374, 2, { 722, 567 } },
    { 409400, 2, { 712, 575 } },
    { 409428, 2, { 669, 612 } },
    { 409437, 2, { 679, 603 } },
    { 409452, 2, { 687, 596 } },
    { 409479, 2, { 651, 629 } },
    { 409500, 2, { 650, 630 } },
    { 409528, 2, { 721, 568 } },
    { 409590, 2, { 666, 615 } },
    { 409605, 2, { 705, 581 } },
    { 409632, 2, { 753, 544 } },
    { 409640, 2, { 665, 616 } },
    { 409696, 2, { 826, 496 } },
    { 409728, 2, { 704, 582 } },
    { 409770, 2, { 785, 522 } },
    { 409836, 2, { 697, 588 } },
    { 409840, 2, { 752, 545 } },
    { 409860, 2, { 660, 621 } },
    { 409887, 2, { 799, 513 } },
    { 409920, 2, { 672, 610 } },
    { 409932, 2, { 708, 579 } },
    { 409944, 2, { 696, 589 } },
    { 409955, 2, { 689, 595 } },
    { 409968, 2, { 657, 624 } },
    { 409975, 2, { 713, 575 } },
    { 410000, 2, { 656, 625 } },
    { 410025, 2, { 781, 525 } },
    { 410040, 2, { 670, 612 } },
    { 410060, 2, { 707, 580 } },
    { 410091, 2, { 731, 561 } },
    { 410124, 2, { 717, 572 } },
    { 410130, 2, { 651, 630 } },
    { 410172, 2, { 771, 532 } },
    { 410176, 2, { 754, 544 } },
    { 410184, 2, { 648, 633 } },
    { 410190, 2, { 678, 605 } },
    { 410220, 2, { 645, 636 } },
    { 410256, 2, { 666, 616 } },
    { 410268, 2, { 716, 573 } },
    { 410292, 2, { 783, 524 } },
    { 410352, 2, { 664, 618 } },
    { 410375, 2, { 875, 469 } },
    { 410400, 2, { 675, 608 } },
    { 410432, 2, { 704, 583 } },
    { 410508, 2, { 724, 567 } },
    { 410550, 2, { 690, 595 } },
    { 410571, 2, { 931, 441 } },
    { 410592, 2, { 658, 624 } },
    { 410625, 2, { 657, 625 } },
    { 410640, 2, { 696, 590 } },
    { 410652, 2, { 671, 612 } },
    { 410664, 2, { 723, 568 } },
    { 410669, 2, { 833, 493 } },
    { 410688, 2, { 713, 576 } },
    { 410736, 2, { 688, 597 } },
    { 410774, 2, { 793, 518 } },
    { 410820, 2, { 668, 615 } },
    { 410844, 2, { 804, 511 } },
    { 410865, 2, { 645, 637 } },
    { 410872, 2, { 644, 638 } },
    { 410880, 2, { 642, 640 } },
    { 410970, 2, { 665, 618 } },
    { 411000, 2, { 685, 600 } },
    { 411012, 2, { 699, 588 } },
    { 411015, 2, { 705, 583 } },
    { 411060, 2, { 663, 620 } },
    { 411075, 2, { 675, 609 } },
    { 411156, 2, { 729, 564 } },
    { 411180, 2, { 660, 623 } },
    { 411201, 2, { 749, 549 } },
    { 411250, 2, { 658, 625 } },
    { 411255, 2, { 703, 585 } },
    { 411264, 2, { 672, 612 } },
    { 411312, 2, { 656, 627 } },
    { 411320, 2, { 728, 565 } },
    { 411324, 2, { 681, 604 } },
    { 411336, 2, { 696, 591 } },
    { 411348, 2, { 708, 581 } },
    { 411400, 2, { 680, 605 } },
    { 411432, 2, { 651, 632 } },
    { 411440, 2, { 695, 592 } },
    { 411480, 2, { 648, 635 } },
    { 411502, 2, { 646, 637 } },
    { 411516, 2, { 644, 639 } },
    { 411525, 2, { 775, 531 } },
    { 411579, 2, { 973, 423 } },
    { 411600, 2, { 686, 600 } },
    { 411684, 2, { 676, 609 } },
    { 411720, 2, { 705, 584 } },
    { 411750, 2, { 675, 610 } },
    { 411768, 2, { 684, 602 } },
    { 411810, 2, { 742, 555 } },
    { 411840, 2, { 660, 624 } },
    { 411885, 2, { 729, 565 } },
    { 411950, 2, { 749, 550 } },
    { 411996, 2, { 741, 556 } },
    { 412000, 2, { 800, 515 } },
    { 412080, 2, { 680, 606 } },
    { 412090, 2, { 841, 490 } },
    { 412104, 2, { 669, 616 } },
    { 412114, 2, { 713, 578 } },
    { 412160, 2, { 644, 640 } },
    { 412200, 2, { 687, 600 } },
    { 412224, 2, { 678, 608 } },
    { 412230, 2, { 755, 546 } },
    { 412248, 2, { 712, 579 } },
    { 412269, 2, { 961, 429 } },
    { 412335, 2, { 693, 595 } },
    { 412344, 2, { 664, 621 } },
    { 412368, 2, { 726, 568 } },
    { 412380, 2, { 711, 580 } },
    { 412425, 2, { 675, 611 } },
    { 412452, 2, { 684, 603 } },
    { 412500, 2, { 660, 625 } },
    { 412510, 2, { 710, 581 } },
    { 412515, 2, { 801, 515 } },
    { 412542, 2, { 738, 559 } },
    { 412560, 2, { 720, 573 } },
    { 412596, 2, { 657, 628 } },
    { 412641, 2, { 783, 527 } },
    { 412644, 2, { 753, 548 } },
    { 412650, 2, { 655, 630 } },
    { 412665, 2, { 671, 615 } },
    { 412672, 2, { 806, 512 } },
    { 412716, 2, { 652, 633 } },
    { 412764, 2, { 649, 636 } },
    { 412775, 2, { 869, 475 } },
    { 412776, 2, { 648, 637 } },
    { 412800, 2, { 645, 640 } },
    { 412815, 2, { 949, 435 } },
    { 412830, 2, { 695, 594 } },
    { 412832, 2, { 679, 608 } },
    { 412888, 2, { 707, 584 } },
    { 412896, 2, { 736, 561 } },
    { 412965, 2, { 665, 621 } },
    { 412984, 2, { 722, 572 } },
    { 412992, 2, { 717, 576 } },
    { 413028, 2, { 693, 596 } },
    { 413055, 2, { 685, 603 } },
    { 413075, 2, { 775, 533 } },
    { 413091, 2, { 711, 581 } },
    { 413100, 2, { 675, 612 } },
    { 413105, 2, { 1015, 407 } },
    { 413124, 2, { 692, 597 } },
    { 413168, 2, { 784, 527 } },
    { 413250, 2, { 725, 570 } },
    { 413256, 2, { 771, 536 } },
    { 413270, 2, { 715, 578 } },
    { 413280, 2, { 656, 630 } },
    { 413328, 2, { 654, 632 } },
    { 413336, 2, { 671, 616 } },
    { 413364, 2, { 703, 588 } },
    { 413400, 2, { 650, 636 } },
    { 413402, 2, { 817, 506 } },
    { 413413, 2, { 649, 637 } },
    { 413424, 2, { 648, 638 } },
    { 413440, 2, { 646, 640 } },
    { 413478, 2, { 702, 589 } },
    { 413556, 2, { 723, 572 } },
    { 413595, 2, { 707, 585 } },
    { 413600, 2, { 752, 550 } },
    { 413660, 2, { 740, 559 } },
    { 413672, 2, { 664, 623 } },
    { 413700, 2, { 700, 591 } },
    { 413712, 2, { 663, 624 } },
    { 413725, 2, { 871, 475 } },
    { 413808, 2, { 699, 592 } },
    { 413820, 2, { 660, 627 } },
    { 413850, 2, { 775, 534 } },
    { 413875, 2, { 875, 473 } },
    { 413952, 2, { 672, 616 } },
    { 413960, 2, { 655, 632 } },
    { 414000, 2, { 690, 600 } },
    { 414018, 2, { 697, 594 } },
    { 414036, 2, { 651, 636 } },
    { 414048, 2, { 681, 608 } },
    { 414050, 2, { 650, 637 } },
    { 414072, 2, { 648, 639 } },
    { 414120, 2, { 680, 609 } },
    { 414141, 2, { 777, 533 } },
    { 414180, 2, { 702, 590 } },
    { 414190, 2, { 679, 610 } },
    { 414200, 2, { 760, 545 } },
    { 414207, 2, { 667, 621 } },
    { 414348, 2, { 803, 516 } },
    { 414375, 2, { 663, 625 } },
    { 414384, 2, { 712, 582 } },
    { 414414, 2, { 693, 598 } },
    { 414477, 2, { 731, 567 } },
    { 414495, 2, { 755, 549 } },
    { 414528, 2, { 762, 544 } },
    { 414540, 2, { 658, 630 } },
    { 414564, 2, { 716, 579 } },
    { 414575, 2, { 721, 575 } },
    { 414596, 2, { 871, 476 } },
    { 414656, 2, { 682, 608 } },
    { 414675, 2, { 855, 485 } },
    { 414700, 2, { 650, 638 } },
    { 414715, 2, { 697, 595 } },
    { 414720, 2, { 648, 640 } },
    { 414750, 2, { 750, 553 } },
    { 414778, 2, { 689, 602 } },
    { 414780, 2, { 669, 620 } },
    { 414828, 2, { 668, 621 } },
    { 414852, 2, { 724, 573 } },
    { 414864, 2, { 688, 603 } },
    { 414918, 2, { 666, 623 } },
    { 414948, 2, { 687, 604 } },
    { 414960, 2, { 665, 624 } },
    { 414990, 2, { 783, 530 } },
    { 415000, 2, { 664, 625 } },
    { 415008, 2, { 786, 528 } },
    { 415030, 2, { 686, 605 } },
    { 415044, 2, { 732, 567 } },
    { 415065, 2, { 885, 469 } },
    { 415072, 2, { 763, 544 } },
    { 415104, 2, { 736, 564 } },
    { 415110, 2, { 685, 606 } },
    { 415125, 2, { 675, 615 } },
    { 415140, 2, { 660, 629 } },
    { 415160, 2, { 776, 535 } },
    { 415224, 2, { 657, 632 } },
    { 415248, 2, { 656, 633 } },
    { 415290, 2, { 654, 635 } },
    { 415296, 2, { 672, 618 } },
    { 415332, 2, { 747, 556 } },
    { 415360, 2, { 649, 640 } },
    { 415380, 2, { 645, 644 } },
    { 415480, 2, { 680, 611 } },
    { 415492, 2, { 781, 532 } },
    { 415512, 2, { 696, 597 } },
    { 415520, 2, { 742, 560 } },
    { 415530, 2, { 729, 570 } },
    { 415548, 2, { 679, 612 } },
    { 415584, 2, { 666, 624 } },
    { 415625, 2, { 665, 625 } },
    { 415650, 2, { 815, 510 } },
    { 415656, 2, { 753, 552 } },
    { 415668, 2, { 737, 564 } },
    { 415695, 2, { 749, 555 } },
    { 415710, 2, { 745, 558 } },
    { 415740, 2, { 676, 615 } },
    { 415744, 2, { 812, 512 } },
    { 415840, 2, { 736, 565 } },
    { 415860, 2, { 717, 580 } },
    { 415872, 2, { 684, 608 } },
    { 415896, 2, { 744, 559 } },
    { 415932, 2, { 759, 548 } },
    { 415954, 2, { 803, 518 } },
    { 416000, 2, { 650, 640 } },
    { 416016, 2, { 648, 642 } },
    { 416020, 2, { 671, 620 } },
    { 416064, 2, { 704, 591 } },
    { 416070, 2, { 670, 621 } },
    { 416120, 2, { 808, 515 } },
    { 416130, 2, { 715, 582 } },
    { 416150, 2, { 725, 574 } },
    { 416185, 2, { 805, 517 } },
    { 416208, 2, { 667, 624 } },
    { 416240, 2, { 688, 605 } },
    { 416250, 2, { 666, 625 } },
    { 416262, 2, { 714, 583 } },
    { 416295, 2, { 841, 495 } },
    { 416325, 2, { 793, 525 } },
    { 416328, 2, { 664, 627 } },
    { 416340, 2, { 771, 540 } },
    { 416364, 2, { 663, 628 } },
    { 416416, 2, { 676, 616 } },
    { 416448, 2, { 723, 576 } },
    { 416472, 2, { 777, 536 } },
    { 416480, 2, { 685, 608 } },
    { 416500, 2, { 700, 595 } },
    { 416520, 2, { 712, 585 } },
    { 416556, 2, { 684, 609 } },
    { 416560, 2, { 656, 635 } },
    { 416580, 2, { 655, 636 } },
    { 416585, 2, { 845, 493 } },
    { 416592, 2, { 789, 528 } },
    { 416604, 2, { 699, 596 } },
    { 416628, 2, { 652, 639 } },
    { 416640, 2, { 651, 640 } },
    { 416691, 2, { 671, 621 } },
    { 416702, 2, { 682, 611 } },
    { 416745, 2, { 735, 567 } },
    { 416772, 2, { 681, 612 } },
    { 416806, 2, { 697, 598 } },
    { 416835, 2, { 785, 531 } },
    { 416845, 2, { 689, 605 } },
    { 416875, 2, { 667, 625 } },
    { 416880, 2, { 720, 579 } },
    { 416925, 2, { 765, 545 } },
    { 416928, 2, { 688, 606 } },
    { 416976, 2, { 714, 584 } },
    { 417000, 2, { 695, 600 } },
    { 417027, 2, { 663, 629 } },
    { 417078, 2, { 799, 522 } },
    { 417088, 2, { 686, 608 } },
    { 417105, 2, { 713, 585 } },
    { 417130, 2, { 707, 590 } },
    { 417144, 2, { 728, 573 } },
    { 417175, 2, { 925, 451 } },
    { 417195, 2, { 657, 635 } },
    { 417216, 2, { 656, 636 } },
    { 417240, 2, { 684, 610 } },
    { 417248, 2, { 767, 544 } },
    { 417276, 2, { 692, 603 } },
    { 417312, 2, { 648, 644 } },
    { 417339, 2, { 783, 533 } },
    { 417360, 2, { 705, 592 } },
    { 417384, 2, { 682, 612 } },
    { 417410, 2, { 670, 623 } },
    { 417450, 2, { 690, 605 } },
    { 417456, 2, { 669, 624 } },
    { 417480, 2, { 710, 588 } },
    { 417560, 2, { 715, 584 } },
    { 417571, 2, { 847, 493 } },
    { 417585, 2, { 679, 615 } },
    { 417648, 2, { 678, 616 } },
    { 417690, 2, { 663, 630 } },
    { 417696, 2, { 687, 608 } },
    { 417725, 2, { 775, 539 } },
    { 417780, 2, { 660, 633 } },
    { 417852, 2, { 657, 636 } },
    { 417872, 2, { 656, 637 } },
    { 417900, 2, { 700, 597 } },
    { 417924, 2, { 684, 611 } },
    { 417956, 2, { 649, 644 } },
    { 417960, 2, { 648, 645 } },
    { 418068, 2, { 711, 588 } },
    { 418080, 2, { 670, 624 } },
    { 418095, 2, { 815, 513 } },
    { 418132, 2, { 731, 572 } },
    { 418176, 2, { 704, 594 } },
    { 418180, 2, { 721, 580 } },
    { 418200, 2, { 680, 615 } },
    { 418209, 2, { 667, 627 } },
    { 418264, 2, { 679, 616 } },
    { 418275, 2, { 715, 585 } },
    { 418285, 2, { 665, 629 } },
    { 418320, 2, { 664, 630 } },
    { 418418, 2, { 847, 494 } },
    { 418428, 2, { 708, 591 } },
    { 418446, 2, { 729, 574 } },
    { 418500, 2, { 675, 620 } },
    { 418509, 2, { 657, 637 } },
    { 418544, 2, { 707, 592 } },
    { 418545, 2, { 655, 639 } },
    { 418560, 2, { 654, 640 } },
    { 418572, 2, { 693, 604 } },
    { 418600, 2, { 650, 644 } },
    { 418605, 2, { 649, 645 } },
    { 418608, 2, { 648, 646 } },
    { 418656, 2, { 672, 623 } },
    { 418668, 2, { 753, 556 } },
    { 418704, 2, { 671, 624 } },
    { 418728, 2, { 717, 584 } },
    { 418770, 2, { 705, 594 } },
    { 418782, 2, { 767, 546 } },
    { 418836, 2, { 668, 627 } },
    { 418860, 2, { 716, 585 } },
    { 418887, 2, { 763, 549 } },
    { 418905, 2, { 783, 535 } },
    { 418912, 2, { 689, 608 } },
    { 418950, 2, { 665, 630 } },
    { 418968, 2, { 759, 552 } },
    { 418992, 2, { 688, 609 } },
    { 419016, 2, { 663, 632 } },
    { 419040, 2, { 720, 582 } },
    { 419085, 2, { 695, 603 } },
    { 419100, 2, { 660, 635 } },
    { 419121, 2, { 817, 513 } },
    { 419136, 2, { 708, 592 } },
    { 419184, 2, { 656, 639 } },
    { 419190, 2, { 785, 534 } },
    { 419196, 2, { 724, 579 } },
    { 419200, 2, { 655, 640 } },
    { 419220, 2, { 685, 612 } },
    { 419244, 2, { 651, 644 } },
    { 419265, 2, { 693, 605 } },
    { 419340, 2, { 723, 580 } },
    { 419375, 2, { 671, 625 } },
    { 419400, 2, { 699, 600 } },
    { 419424, 2, { 771, 544 } },
    { 419436, 2, { 732, 573 } },
    { 419440, 2, { 749, 560 } },
    { 419496, 2, { 681, 616 } },
    { 419520, 2, { 690, 608 } },
    { 419601, 2, { 689, 609 } },
    { 419628, 2, { 726, 578 } },
    { 419650, 2, { 763, 550 } },
    { 419680, 2, { 688, 610 } },
    { 419688, 2, { 696, 603 } },
    { 419748, 2, { 789, 532 } },
    { 419796, 2, { 676, 621 } },
    { 419832, 2, { 686, 612 } },
    { 419881, 2, { 779, 539 } },
    { 419900, 2, { 650, 646 } },
    { 420000, 2, { 672, 625 } },
    { 420021, 2, { 791, 531 } },
    { 420112, 2, { 682, 616 } },
    { 420132, 2, { 669, 628 } },
    { 420147, 2, { 741, 567 } },
    { 420180, 2, { 705, 596 } },
    { 420210, 2, { 667, 630 } },
    { 420240, 2, { 680, 618 } },
    { 420280, 2, { 665, 632 } },
    { 420288, 2, { 704, 597 } },
    { 420312, 2, { 664, 633 } },
    { 420320, 2, { 710, 592 } },
    { 420325, 2, { 731, 575 } },
    { 420368, 2, { 688, 611 } },
    { 420394, 2, { 703, 598 } },
    { 420420, 2, { 660, 637 } },
    { 420444, 2, { 687, 612 } },
    { 420480, 2, { 657, 640 } },
    { 420510, 2, { 655, 642 } },
    { 420525, 2, { 675, 623 } },
    { 420540, 2, { 652, 645 } },
    { 420552, 2, { 649, 648 } },
    { 420624, 2, { 762, 552 } },
    { 420660, 2, { 684, 615 } },
    { 420693, 2, { 871, 483 } },
    { 420714, 2, { 742, 567 } },
    { 420750, 2, { 750, 561 } },
    { 420784, 2, { 728, 578 } },
    { 420792, 2, { 712, 591 } },
    { 420875, 2, { 875, 481 } },
    { 420888, 2, { 741, 568 } },
    { 420903, 2, { 917, 459 } },
    { 420912, 2, { 666, 632 } },
    { 420959, 2, { 781, 539 } },
    { 420980, 2, { 679, 620 } },
    { 420992, 2, { 704, 598 } },
    { 421056, 2, { 688, 612 } },
    { 421064, 2, { 721, 584 } },
    { 421080, 2, { 660, 638 } },
    { 421120, 2, { 658, 640 } },
    { 421135, 2, { 715, 589 } },
    { 421152, 2, { 656, 642 } },
    { 421170, 2, { 695, 606 } },
    { 421200, 2, { 650, 648 } },
    { 421225, 2, { 725, 581 } },
    { 421260, 2, { 708, 595 } },
    { 421290, 2, { 755, 558 } },
    { 421296, 2, { 786, 536 } },
    { 421308, 2, { 747, 564 } },
    { 421344, 2, { 672, 627 } },
    { 421362, 2, { 729, 578 } },
    { 421400, 2, { 700, 602 } },
    { 421428, 2, { 692, 609 } },
    { 421443, 2, { 891, 473 } },
    { 421498, 2, { 782, 539 } },
    { 421512, 2, { 728, 579 } },
    { 421515, 2, { 765, 551 } },
    { 421575, 2, { 803, 525 } },
    { 421590, 2, { 690, 611 } },
    { 421596, 2, { 717, 588 } },
    { 421632, 2, { 732, 576 } },
    { 421640, 2, { 664, 635 } },
    { 421659, 2, { 679, 621 } },
    { 421668, 2, { 663, 636 } },
    { 421680, 2, { 753, 560 } },
    { 421685, 2, { 697, 605 } },
    { 421728, 2, { 736, 573 } },
    { 421740, 2, { 660, 639 } },
    { 421776, 2, { 696, 606 } },
    { 421785, 2, { 721, 585 } },
    { 421800, 2, { 703, 600 } },
    { 421848, 2, { 651, 648 } },
    { 421850, 2, { 650, 649 } },
    { 421875, 2, { 675, 625 } },
    { 421876, 2, { 793, 532 } },
    { 421890, 2, { 686, 615 } },
    { 421950, 2, { 725, 582 } },
    { 421960, 2, { 685, 616 } },
    { 422004, 2, { 759, 556 } },
    { 422055, 2, { 747, 565 } },
    { 422100, 2, { 670, 630 } },
    { 422142, 2, { 798, 529 } },
    { 422196, 2, { 699, 604 } },
    { 422220, 2, { 681, 620 } },
    { 422232, 2, { 723, 584 } },
    { 422280, 2, { 680, 621 } },
    { 422331, 2, { 663, 637 } },
    { 422370, 2, { 722, 585 } },
    { 422400, 2, { 660, 640 } },
    { 422415, 2, { 745, 567 } },
    { 422499, 2, { 651, 649 } },
    { 422508, 2, { 771, 548 } },
    { 422560, 2, { 695, 608 } },
    { 422604, 2, { 702, 602 } },
    { 422675, 2, { 725, 583 } },
    { 422676, 2, { 708, 597 } },
    { 422685, 2, { 837, 505 } },
    { 422688, 2, { 672, 629 } },
    { 422730, 2, { 671, 630 } },
    { 422807, 2, { 1309, 323 } },
    { 422808, 2, { 669, 632 } },
    { 422820, 2, { 729, 580 } },
    { 422844, 2, { 668, 633 } },
    { 422904, 2, { 789, 536 } },
    { 422910, 2, { 666, 635 } },
    { 422912, 2, { 826, 512 } },
    { 422919, 2, { 959, 441 } },
    { 422920, 2, { 776, 545 } },
    { 422928, 2, { 712, 594 } },
    { 422940, 2, { 665, 636 } },
    { 422968, 2, { 664, 637 } },
    { 423000, 2, { 705, 600 } },
    { 423038, 2, { 737, 574 } },
    { 423045, 2, { 711, 595 } },
    { 423072, 2, { 678, 624 } },
    { 423108, 2, { 657, 644 } },
    { 423120, 2, { 656, 645 } },
    { 423150, 2, { 651, 650 } },
    { 423156, 2, { 716, 591 } },
    { 423168, 2, { 696, 608 } },
    { 423192, 2, { 687, 616 } },
    { 423200, 2, { 736, 575 } },
    { 423225, 2, { 675, 627 } },
    { 423280, 2, { 715, 592 } },
    { 423325, 2, { 1025, 413 } },
    { 423330, 2, { 685, 618 } },
    { 423360, 2, { 672, 630 } },
    { 423400, 2, { 725, 584 } },
    { 423423, 2, { 693, 611 } },
    { 423453, 2, { 969, 437 } },
    { 423465, 2, { 763, 555 } },
    { 423500, 2, { 700, 605 } },
    { 423522, 2, { 682, 621 } },
    { 423540, 2, { 724, 585 } },
    { 423549, 2, { 729, 581 } },
    { 423584, 2, { 854, 496 } },
    { 423640, 2, { 680, 623 } },
    { 423696, 2, { 679, 624 } },
    { 423735, 2, { 689, 615 } },
    { 423750, 2, { 678, 625 } },
    { 423756, 2, { 711, 596 } },
    { 423775, 2, { 737, 575 } },
    { 423792, 2, { 654, 648 } },
    { 423828, 2, { 732, 579 } },
    { 423852, 2, { 676, 627 } },
    { 423864, 2, { 696, 609 } },
    { 423900, 2, { 675, 628 } },
    { 423940, 2, { 820, 517 } },
    { 423976, 2, { 791, 536 } },
    { 423980, 2, { 731, 580 } },
    { 423984, 2, { 726, 584 } },
    { 424000, 2, { 800, 530 } },
    { 424020, 2, { 740, 573 } },
    { 424053, 2, { 889, 477 } },
    { 424080, 2, { 684, 620 } },
    { 424116, 2, { 693, 612 } },
    { 424125, 2, { 725, 585 } },
    { 424130, 2, { 730, 581 } },
    { 424175, 2, { 893, 475 } },
    { 424235, 2, { 713, 595 } },
    { 424242, 2, { 666, 637 } },
    { 424270, 2, { 665, 638 } },
    { 424281, 2, { 759, 559 } },
    { 424296, 2, { 664, 639 } },
    { 424320, 2, { 663, 640 } },
    { 424375, 2, { 679, 625 } },
    { 424410, 2, { 658, 645 } },
    { 424424, 2, { 689, 616 } },
    { 424440, 2, { 655, 648 } },
    { 424452, 2, { 652, 651 } },
    { 424464, 2, { 717, 592 } },
    { 424473, 2, { 697, 609 } },
    { 424512, 2, { 704, 603 } },
    { 424536, 2, { 722, 588 } },
    { 424545, 2, { 913, 465 } },
    { 424560, 2, { 696, 610 } },
    { 424575, 2, { 675, 629 } },
    { 424650, 2, { 745, 570 } },
    { 424683, 2, { 749, 567 } },
    { 424692, 2, { 753, 564 } },
    { 424710, 2, { 702, 605 } },
    { 424760, 2, { 740, 574 } },
    { 424764, 2, { 684, 621 } },
    { 424840, 2, { 760, 559 } },
    { 424879, 2, { 667, 637 } },
    { 424880, 2, { 752, 565 } },
    { 424935, 2, { 665, 639 } },
    { 424944, 2, { 681, 624 } },
    { 424992, 2, { 699, 608 } },
    { 425000, 2, { 680, 625 } },
    { 425007, 2, { 729, 583 } },
    { 425040, 2, { 660, 644 } },
    { 425064, 2, { 712, 597 } },
    { 425124, 2, { 723, 588 } },
    { 425184, 2, { 688, 618 } },
    { 425204, 2, { 676, 629 } },
    { 425256, 2, { 696, 611 } },
    { 425292, 2, { 732, 581 } },
    { 425315, 2, { 703, 605 } },
    { 425320, 2, { 686, 620 } },
    { 425340, 2, { 695, 612 } },
    { 425376, 2, { 672, 633 } },
    { 425385, 2, { 685, 621 } },
    { 425390, 2, { 721, 590 } },
    { 425430, 2, { 815, 522 } },
    { 425432, 2, { 749, 568 } },
    { 425475, 2, { 775, 549 } },
    { 425484, 2, { 669, 636 } },
    { 425520, 2, { 720, 591 } },
    { 425568, 2, { 682, 624 } },
    { 425580, 2, { 692, 615 } },
    { 425592, 2, { 771, 552 } },
    { 425600, 2, { 665, 640 } },
    { 425685, 2, { 767, 555 } },
    { 425700, 2, { 660, 645 } },
    { 425736, 2, { 657, 648 } },
    { 425744, 2, { 656, 649 } },
    { 425796, 2, { 777, 548 } },
    { 425810, 2, { 770, 553 } },
    { 425820, 2, { 705, 604 } },
    { 425850, 2, { 835, 510 } },
    { 425880, 2, { 676, 630 } },
    { 425920, 2, { 704, 605 } },
    { 425940, 2, { 687, 620 } },
    { 426000, 2, { 710, 600 } },
    { 426006, 2, { 686, 621 } },
    { 426060, 2, { 789, 540 } },
    { 426120, 2, { 670, 636 } },
    { 426132, 2, { 684, 623 } },
    { 426144, 2, { 736, 579 } },
    { 426240, 2, { 666, 640 } },
    { 426250, 2, { 682, 625 } },
    { 426275, 2, { 1003, 425 } },
    { 426288, 2, { 664, 642 } },
    { 426300, 2, { 700, 609 } },
    { 426312, 2, { 744, 573 } },
    { 426321, 2, { 707, 603 } },
    { 426360, 2, { 660, 646 } },
    { 426374, 2, { 713, 598 } },
    { 426384, 2, { 658, 648 } },
    { 426387, 2, { 841, 507 } },
    { 426400, 2, { 656, 650 } },
    { 426426, 2, { 781, 546 } },
    { 426465, 2, { 729, 585 } },
    { 426564, 2, { 697, 612 } },
    { 426600, 2, { 675, 632 } },
    { 426624, 2, { 704, 606 } },
    { 426650, 2, { 742, 575 } },
    { 426720, 2, { 672, 635 } },
    { 426735, 2, { 783, 545 } },
    { 426756, 2, { 671, 636 } },
    { 426790, 2, { 670, 637 } },
    { 426816, 2, { 684, 624 } },
    { 426832, 2, { 721, 592 } },
    { 426852, 2, { 668, 639 } },
    { 426880, 2, { 667, 640 } },
    { 426888, 2, { 693, 616 } },
    { 426924, 2, { 708, 603 } },
    { 426930, 2, { 665, 642 } },
    { 426972, 2, { 663, 644 } },
    { 427025, 2, { 725, 589 } },
    { 427035, 2, { 735, 581 } },
    { 427042, 2, { 658, 649 } },
    { 427056, 2, { 656, 651 } },
    { 427063, 2, { 1183, 361 } },
    { 427180, 2, { 689, 620 } },
    { 427196, 2, { 803, 532 } },
    { 427248, 2, { 688, 621 } },
    { 427280, 2, { 763, 560 } },
    { 427284, 2, { 747, 572 } },
    { 427329, 2, { 833, 513 } },
    { 427332, 2, { 717, 596 } },
    { 427392, 2, { 672, 636 } },
    { 427424, 2, { 703, 608 } },
    { 427427, 2, { 671, 637 } },
    { 427440, 2, { 685, 624 } },
    { 427452, 2, { 716, 597 } },
    { 427455, 2, { 805, 531 } },
    { 427500, 2, { 684, 625 } },
    { 427518, 2, { 702, 609 } },
    { 427548, 2, { 869, 492 } },
    { 427570, 2, { 715, 598 } },
    { 427584, 2, { 786, 544 } },
    { 427668, 2, { 681, 628 } },
    { 427680, 2, { 660, 648 } },
    { 427700, 2, { 658, 650 } },
    { 427704, 2, { 753, 568 } },
    { 427720, 2, { 680, 629 } },
    { 427721, 2, { 1247, 343 } },
    { 427728, 2, { 798, 536 } },
    { 427770, 2, { 679, 630 } },
    { 427788, 2, { 699, 612 } },
    { 427869, 2, { 689, 621 } },
    { 427884, 2, { 724, 591 } },
    { 427908, 2, { 676, 633 } },
    { 427924, 2, { 812, 527 } },
    { 427975, 2, { 901, 475 } },
    { 427986, 2, { 767, 558 } },
    { 428000, 2, { 800, 535 } },
    { 428016, 2, { 723, 592 } },
    { 428040, 2, { 696, 615 } },
    { 428064, 2, { 672, 637 } },
    { 428076, 2, { 759, 564 } },
    { 428085, 2, { 755, 567 } },
    { 428120, 2, { 695, 616 } },
    { 428127, 2, { 703, 609 } },
    { 428160, 2, { 669, 640 } },
    { 428220, 2, { 702, 610 } },
    { 428280, 2, { 664, 645 } },
    { 428298, 2, { 663, 646 } },
    { 428340, 2, { 660, 649 } },
    { 428352, 2, { 736, 582 } },
    { 428355, 2, { 835, 513 } },
    { 428364, 2, { 657, 652 } },
    { 428370, 2, { 655, 654 } },
    { 428400, 2, { 680, 630 } },
    { 428450, 2, { 779, 550 } },
    { 428460, 2, { 740, 579 } },
    { 428496, 2, { 678, 632 } },
    { 428505, 2, { 735, 583 } },
    { 428535, 2, { 801, 535 } },
    { 428544, 2, { 744, 576 } },
    { 428571, 2, { 891, 481 } },
    { 428575, 2, { 775, 553 } },
    { 428604, 2, { 748, 573 } },
    { 428610, 2, { 785, 546 } },
    { 428624, 2, { 688, 623 } },
    { 428625, 2, { 675, 635 } },
    { 428640, 2, { 705, 608 } },
    { 428652, 2, { 729, 588 } },
    { 428676, 2, { 771, 556 } },
    { 428688, 2, { 687, 624 } },
    { 428736, 2, { 672, 638 } },
    { 428750, 2, { 686, 625 } },
    { 428778, 2, { 738, 581 } },
    { 428792, 2, { 728, 589 } },
    { 428800, 2, { 670, 640 } },
    { 428868, 2, { 684, 627 } },
    { 428910, 2, { 841, 510 } },
    { 428922, 2, { 702, 611 } },
    { 428978, 2, { 682, 629 } },
    { 429000, 2, { 660, 650 } },
    { 429024, 2, { 656, 654 } },
    { 429065, 2, { 805, 533 } },
    { 429084, 2, { 783, 548 } },
    { 429088, 2, { 736, 583 } },
    { 429093, 2, { 973, 441 } },
    { 429128, 2, { 679, 632 } },
    { 429135, 2, { 915, 469 } },
    { 429195, 2, { 923, 465 } },
    { 429200, 2, { 725, 592 } },
    { 429216, 2, { 789, 544 } },
    { 429240, 2, { 730, 588 } },
    { 429300, 2, { 675, 636 } },
    { 429336, 2, { 712, 603 } },
    { 429352, 2, { 697, 616 } },
    { 429381, 2, { 729, 589 } },
    { 429400, 2, { 760, 565 } },
    { 429408, 2, { 672, 639 } },
    { 429429, 2, { 847, 507 } },
    { 429440, 2, { 671, 640 } },
    { 429444, 2, { 711, 604 } },
    { 429510, 2, { 695, 618 } },
    { 429525, 2, { 747, 575 } },
    { 429548, 2, { 667, 644 } },
    { 429570, 2, { 666, 645 } },
    { 429624, 2, { 663, 648 } },
    { 429660, 2, { 660, 651 } },
    { 429680, 2, { 656, 655 } },
    { 429732, 2, { 692, 621 } },
    { 429780, 2, { 741, 580 } },
    { 429792, 2, { 726, 592 } },
    { 429840, 2, { 720, 597 } },
    { 429856, 2, { 707, 608 } },
    { 429870, 2, { 690, 623 } },
    { 429913, 2, { 1331, 323 } },
    { 429940, 2, { 740, 581 } },
    { 429975, 2, { 675, 637 } },
    { 430000, 2, { 688, 625 } },
    { 430008, 2, { 779, 552 } },
    { 430080, 2, { 672, 640 } },
    { 430110, 2, { 729, 590 } },
    { 430122, 2, { 686, 627 } },
    { 430128, 2, { 696, 618 } },
    { 430144, 2, { 704, 611 } },
    { 430155, 2, { 711, 605 } },
    { 430200, 2, { 717, 600 } },
    { 430248, 2, { 728, 591 } },
    { 430254, 2, { 738, 583 } },
    { 430304, 2, { 791, 544 } },
    { 430335, 2, { 657, 655 } },
    { 430350, 2, { 755, 570 } },
    { 430360, 2, { 742, 580 } },
    { 430392, 2, { 681, 632 } },
    { 430440, 2, { 680, 633 } },
    { 430464, 2, { 708, 608 } },
    { 430500, 2, { 700, 615 } },
    { 430530, 2, { 678, 635 } },
    { 430560, 2, { 690, 624 } },
    { 430584, 2, { 699, 616 } },
    { 430592, 2, { 841, 512 } },
    { 430625, 2, { 689, 625 } },
    { 430650, 2, { 675, 638 } },
    { 430661, 2, { 799, 539 } },
    { 430675, 2, { 749, 575 } },
    { 430716, 2, { 753, 572 } },
    { 430760, 2, { 712, 605 } },
    { 430776, 2, { 744, 579 } },
    { 430836, 2, { 669, 644 } },
    { 430848, 2, { 704, 612 } },
    { 430860, 2, { 668, 645 } },
    { 430882, 2, { 667, 646 } },
    { 430896, 2, { 752, 573 } },
    { 430908, 2, { 723, 596 } },
    { 430920, 2, { 665, 648 } },
    { 430950, 2, { 663, 650 } },
    { 430965, 2, { 785, 549 } },
    { 430992, 2, { 657, 656 } },
    { 431055, 2, { 837, 515 } },
    { 431112, 2, { 759, 568 } },
    { 431145, 2, { 715, 603 } },
    { 431172, 2, { 708, 609 } },
    { 431200, 2, { 700, 616 } },
    { 431250, 2, { 690, 625 } },
    { 431270, 2, { 707, 610 } },
    { 431319, 2, { 893, 483 } },
    { 431340, 2, { 780, 553 } },
    { 431365, 2, { 713, 605 } },
    { 431376, 2, { 688, 627 } },
    { 431392, 2, { 793, 544 } },
    { 431420, 2, { 740, 583 } },
    { 431424, 2, { 672, 642 } },
    { 431436, 2, { 687, 628 } },
    { 431457, 2, { 851, 507 } },
    { 431460, 2, { 705, 612 } },
    { 431472, 2, { 712, 606 } },
    { 431494, 2, { 686, 629 } },
    { 431520, 2, { 696, 620 } },
    { 431550, 2, { 685, 630 } },
    { 431568, 2, { 666, 648 } },
    { 431585, 2, { 665, 649 } },
    { 431595, 2, { 695, 621 } },
    { 431648, 2, { 658, 656 } },
    { 431680, 2, { 710, 608 } },
    { 431730, 2, { 702, 615 } },
    { 431739, 2, { 693, 623 } },
    { 431748, 2, { 716, 603 } },
    { 431760, 2, { 771, 560 } },
    { 431775, 2, { 855, 505 } },
    { 431800, 2, { 680, 635 } },
    { 431844, 2, { 679, 636 } },
    { 431880, 2, { 708, 610 } },
    { 431964, 2, { 676, 639 } },
    { 431970, 2, { 714, 605 } },
    { 431984, 2, { 784, 551 } },
    { 432000, 2, { 675, 640 } },
    { 432003, 2, { 689, 627 } },
    { 432012, 2, { 777, 556 } },
    { 432055, 2, { 1105, 391 } },
    { 432124, 2, { 671, 644 } },
    { 432140, 2, { 697, 620 } },
    { 432160, 2, { 730, 592 } },
    { 432180, 2, { 686, 630 } },
    { 432216, 2, { 667, 648 } },
    { 432225, 2, { 765, 565 } },
    { 432228, 2, { 724, 597 } },
    { 432234, 2, { 666, 649 } },
    { 432250, 2, { 665, 650 } },
    { 432264, 2, { 664, 651 } },
    { 432276, 2, { 663, 652 } },
    { 432280, 2, { 808, 535 } },
    { 432300, 2, { 660, 655 } },
    { 432372, 2, { 789, 548 } },
    { 432400, 2, { 752, 575 } },
    { 432432, 2, { 693, 624 } },
    { 432450, 2, { 775, 558 } },
    { 432540, 2, { 801, 540 } },
    { 432612, 2, { 732, 591 } },
    { 432621, 2, { 763, 567 } },
    { 432640, 2, { 676, 640 } },
    { 432684, 2, { 707, 612 } },
    { 432729, 2, { 837, 517 } },
    { 432744, 2, { 741, 584 } },
    { 432765, 2, { 815, 531 } },
    { 432768, 2, { 672, 644 } },
    { 432795, 2, { 671, 645 } },
    { 432816, 2, { 762, 568 } },
    { 432817, 2, { 803, 539 } },
    { 432837, 2, { 697, 621 } },
    { 432900, 2, { 666, 650 } },
    { 432920, 2, { 685, 632 } },
    { 432960, 2, { 660, 656 } },
    { 432972, 2, { 684, 633 } },
    { 432978, 2, { 793, 546 } },
    { 433008, 2, { 744, 582 } },
    { 433048, 2, { 703, 616 } },
    { 433068, 2, { 717, 604 } },
    { 433092, 2, { 748, 579 } },
    { 433116, 2, { 681, 636 } },
    { 433125, 2, { 693, 625 } },
    { 433160, 2, { 680, 637 } },
    { 433188, 2, { 756, 573 } },
    { 433200, 2, { 722, 600 } },
    { 433225, 2, { 775, 559 } },
    { 433251, 2, { 819, 529 } },
    { 433260, 2, { 747, 580 } },
    { 433290, 2, { 715, 606 } },
    { 433344, 2, { 732, 592 } },
    { 433356, 2, { 737, 588 } },
    { 433380, 2, { 699, 620 } },
    { 433384, 2, { 763, 568 } },
    { 433440, 2, { 672, 645 } },
    { 433455, 2, { 781, 555 } },
    { 433485, 2, { 741, 585 } },
    { 433500, 2, { 750, 578 } },
    { 433504, 2, { 713, 608 } },
    { 433512, 2, { 669, 648 } },
    { 433550, 2, { 667, 650 } },
    { 433590, 2, { 745, 582 } },
    { 433608, 2, { 696, 623 } },
    { 433620, 2, { 660, 657 } },
    { 433675, 2, { 913, 475 } },
    { 433680, 2, { 695, 624 } },
    { 433728, 2, { 753, 576 } },
    { 433755, 2, { 729, 595 } },
    { 433800, 2, { 723, 600 } },
    { 433825, 2, { 925, 469 } },
    { 433840, 2, { 680, 638 } },
    { 433862, 2, { 814, 533 } },
    { 433872, 2, { 786, 552 } },
    { 433881, 2, { 679, 639 } },
    { 433884, 2, { 692, 627 } },
    { 433920, 2, { 678, 640 } },
    { 434010, 2, { 690, 629 } },
    { 434070, 2, { 689, 630 } },
    { 434112, 2, { 672, 646 } },
    { 434148, 2, { 726, 598 } },
    { 434160, 2, { 670, 648 } },
    { 434184, 2, { 687, 632 } },
    { 434214, 2, { 731, 594 } },
    { 434240, 2, { 736, 590 } },
    { 434256, 2, { 664, 654 } },
    { 434259, 2, { 791, 549 } },
    { 434280, 2, { 660, 658 } },
    { 434340, 2, { 684, 635 } },
    { 434343, 2, { 777, 559 } },
    { 434420, 2, { 749, 580 } },
    { 434434, 2, { 682, 637 } },
    { 434484, 2, { 729, 596 } },
    { 434511, 2, { 693, 627 } },
    { 434520, 2, { 680, 639 } },
    { 434560, 2, { 679, 640 } },
    { 434565, 2, { 783, 555 } },
    { 434616, 2, { 728, 597 } },
    { 434700, 2, { 675, 644 } },
    { 434720, 2, { 715, 608 } },
    { 434763, 2, { 721, 603 } },
    { 434805, 2, { 707, 615 } },
    { 434808, 2, { 671, 648 } },
    { 434844, 2, { 771, 564 } },
    { 434868, 2, { 668, 651 } },
    { 434875, 2, { 875, 497 } },
    { 434889, 2, { 767, 567 } },
    { 434910, 2, { 665, 654 } },
    { 434920, 2, { 664, 655 } },
    { 434928, 2, { 663, 656 } },
    { 434945, 2, { 731, 595 } },
    { 434976, 2, { 736, 591 } },
    { 435000, 2, { 696, 625 } },
    { 435072, 2, { 704, 618 } },
    { 435120, 2, { 735, 592 } },
    { 435132, 2, { 711, 612 } },
    { 435183, 2, { 901, 483 } },
    { 435200, 2, { 680, 640 } },
    { 435204, 2, { 693, 628 } },
    { 435210, 2, { 815, 534 } },
    { 435240, 2, { 702, 620 } },
    { 435348, 2, { 783, 556 } },
    { 435372, 2, { 852, 511 } },
    { 435375, 2, { 675, 645 } },
    { 435408, 2, { 752, 579 } },
    { 435420, 2, { 708, 615 } },
    { 435456, 2, { 672, 648 } },
    { 435480, 2, { 760, 573 } },
    { 435504, 2, { 688, 633 } },
    { 435512, 2, { 707, 616 } },
    { 435528, 2, { 789, 552 } },
    { 435625, 2, { 697, 625 } },
    { 435660, 2, { 685, 636 } },
    { 435708, 2, { 684, 637 } },
    { 435750, 2, { 750, 581 } },
    { 435780, 2, { 807, 540 } },
    { 435825, 2, { 745, 585 } },
    { 435840, 2, { 681, 640 } },
    { 435860, 2, { 703, 620 } },
    { 435870, 2, { 835, 522 } },
    { 435897, 2, { 693, 629 } },
    { 435925, 2, { 1175, 371 } },
    { 435936, 2, { 717, 608 } },
    { 435953, 2, { 1271, 343 } },
    { 436000, 2, { 800, 545 } },
    { 436020, 2, { 676, 645 } },
    { 436044, 2, { 716, 609 } },
    { 436050, 2, { 675, 646 } },
    { 436080, 2, { 690, 632 } },
    { 436100, 2, { 700, 623 } },
    { 436128, 2, { 672, 649 } },
    { 436150, 2, { 671, 650 } },
    { 436176, 2, { 699, 624 } },
    { 436188, 2, { 669, 652 } },
    { 436230, 2, { 666, 655 } },
    { 436240, 2, { 665, 656 } },
    { 436248, 2, { 664, 657 } },
    { 436304, 2, { 737, 592 } },
    { 436320, 2, { 720, 606 } },
    { 436356, 2, { 713, 612 } },
    { 436392, 2, { 684, 638 } },
    { 436449, 2, { 741, 589 } },
    { 436450, 2, { 725, 602 } },
    { 436475, 2, { 1027, 425 } },
    { 436480, 2, { 682, 640 } },
    { 436527, 2, { 819, 533 } },
    { 436545, 2, { 801, 545 } },
    { 436560, 2, { 680, 642 } },
    { 436563, 2, { 703, 621 } },
    { 436572, 2, { 724, 603 } },
    { 436590, 2, { 693, 630 } },
    { 436692, 2, { 723, 604 } },
    { 436696, 2, { 676, 646 } },
    { 436740, 2, { 753, 580 } },
    { 436800, 2, { 672, 650 } },
    { 436810, 2, { 722, 605 } },
    { 436821, 2, { 671, 651 } },
    { 436865, 2, { 715, 611 } },
    { 436880, 2, { 688, 635 } },
    { 436896, 2, { 666, 656 } },
    { 436905, 2, { 665, 657 } },
    { 436932, 2, { 687, 636 } },
    { 437000, 2, { 760, 575 } },
    { 437004, 2, { 732, 597 } },
    { 437019, 2, { 697, 627 } },
    { 437076, 2, { 684, 639 } },
    { 437100, 2, { 705, 620 } },
    { 437138, 2, { 731, 598 } },
    { 437175, 2, { 725, 603 } },
    { 437184, 2, { 704, 621 } },
    { 437248, 2, { 854, 512 } },
    { 437250, 2, { 750, 583 } },
    { 437255, 2, { 961, 455 } },
    { 437340, 2, { 740, 591 } },
    { 437346, 2, { 702, 623 } },
    { 437376, 2, { 804, 544 } },
    { 437400, 2, { 675, 648 } },
    { 437409, 2, { 917, 477 } },
    { 437416, 2, { 749, 584 } },
    { 437437, 2, { 1001, 437 } },
    { 437472, 2, { 672, 651 } },
    { 437525, 2, { 925, 473 } },
    { 437568, 2, { 688, 636 } },
    { 437580, 2, { 663, 660 } },
    { 437664, 2, { 752, 582 } },
    { 437668, 2, { 686, 638 } },
    { 437675, 2, { 1025, 427 } },
    { 437697, 2, { 783, 559 } },
    { 437715, 2, { 685, 639 } },
    { 437724, 2, { 756, 579 } },
    { 437760, 2, { 684, 640 } },
    { 437784, 2, { 696, 629 } },
    { 437805, 2, { 705, 621 } },
    { 437850, 2, { 695, 630 } },
    { 437880, 2, { 712, 615 } },
    { 437886, 2, { 901, 486 } },
    { 437920, 2, { 680, 644 } },
    { 437928, 2, { 771, 568 } },
    { 437955, 2, { 679, 645 } },
    { 437976, 2, { 693, 632 } },
    { 438000, 2, { 730, 600 } },
    { 438030, 2, { 785, 558 } },
    { 438036, 2, { 692, 633 } },
    { 438048, 2, { 676, 648 } },
    { 438060, 2, { 735, 596 } },
    { 438075, 2, { 675, 649 } },
    { 438150, 2, { 690, 635 } },
    { 438165, 2, { 749, 585 } },
    { 438228, 2, { 666, 658 } },
    { 438256, 2, { 688, 637 } },
    { 438340, 2, { 707, 620 } },
    { 438368, 2, { 721, 608 } },
    { 438400, 2, { 685, 640 } },
    { 438416, 2, { 752, 583 } },
    { 438425, 2, { 923, 475 } },
    { 438438, 2, { 803, 546 } },
    { 438440, 2, { 776, 565 } },
    { 438464, 2, { 806, 544 } },
    { 438480, 2, { 696, 630 } },
    { 438515, 2, { 737, 595 } },
    { 438564, 2, { 681, 644 } },
    { 438592, 2, { 704, 623 } },
    { 438600, 2, { 680, 645 } },
    { 438672, 2, { 703, 624 } },
    { 438684, 2, { 789, 556 } },
    { 438725, 2, { 763, 575 } },
    { 438746, 2, { 814, 539 } },
    { 438750, 2, { 675, 650 } },
    { 438804, 2, { 717, 612 } },
    { 438858, 2, { 729, 602 } },
    { 438864, 2, { 669, 656 } },
    { 438876, 2, { 668, 657 } },
    { 438893, 2, { 689, 637 } },
    { 438900, 2, { 665, 660 } },
    { 438912, 2, { 762, 576 } },
    { 438948, 2, { 801, 548 } },
    { 438972, 2, { 699, 628 } },
    { 438984, 2, { 728, 603 } },
    { 438991, 2, { 833, 527 } },
    { 439008, 2, { 807, 544 } },
    { 439040, 2, { 686, 640 } },
    { 439047, 2, { 707, 621 } },
    { 439110, 2, { 697, 630 } },
    { 439200, 2, { 720, 610 } },
    { 439208, 2, { 682, 644 } },
    { 439215, 2, { 705, 623 } },
    { 439236, 2, { 747, 588 } },
    { 439240, 2, { 695, 632 } },
    { 439264, 2, { 742, 592 } },
    { 439280, 2, { 680, 646 } },
    { 439296, 2, { 704, 624 } },
    { 439344, 2, { 678, 648 } },
    { 439350, 2, { 725, 606 } },
    { 439375, 2, { 703, 625 } },
    { 439392, 2, { 736, 597 } },
    { 439410, 2, { 755, 582 } },
    { 439425, 2, { 675, 651 } },
    { 439450, 2, { 799, 550 } },
    { 439488, 2, { 672, 654 } },
    { 439520, 2, { 670, 656 } },
    { 439530, 2, { 690, 637 } },
    { 439582, 2, { 689, 638 } },
    { 439584, 2, { 723, 608 } },
    { 439632, 2, { 688, 639 } },
    { 439635, 2, { 795, 553 } },
    { 439668, 2, { 708, 621 } },
    { 439680, 2, { 687, 640 } },
    { 439704, 2, { 744, 591 } },
    { 439752, 2, { 753, 584 } },
    { 439770, 2, { 685, 642 } },
    { 439810, 2, { 721, 610 } },
    { 439824, 2, { 714, 616 } },
    { 439845, 2, { 885, 497 } },
    { 439875, 2, { 765, 575 } },
    { 439920, 2, { 705, 624 } },
    { 439992, 2, { 679, 648 } },
    { 440000, 2, { 704, 625 } },
    { 440016, 2, { 712, 618 } },
    { 440040, 2, { 760, 579 } },
    { 440055, 2, { 693, 635 } },
    { 440076, 2, { 676, 651 } },
    { 440100, 2, { 675, 652 } },
    { 440115, 2, { 793, 555 } },
    { 440154, 2, { 702, 627 } },
    { 440160, 2, { 672, 655 } },
    { 440176, 2, { 671, 656 } },
    { 440181, 2, { 959, 459 } },
    { 440220, 2, { 667, 660 } },
    { 440232, 2, { 664, 663 } },
    { 440258, 2, { 767, 574 } },
    { 440300, 2, { 700, 629 } },
    { 440316, 2, { 729, 604 } },
    { 440325, 2, { 855, 515 } },
    { 440340, 2, { 716, 615 } },
    { 440360, 2, { 808, 545 } },
    { 440363, 2, { 817, 539 } },
    { 440440, 2, { 715, 616 } },
    { 440484, 2, { 781, 564 } },
    { 440496, 2, { 684, 644 } },
    { 440510, 2, { 899, 490 } },
    { 440559, 2, { 777, 567 } },
    { 440568, 2, { 696, 633 } },
    { 440640, 2, { 680, 648 } },
    { 440657, 2, { 833, 529 } },
    { 440725, 2, { 1037, 425 } },
    { 440748, 2, { 693, 636 } },
    { 440781, 2, { 703, 627 } },
    { 440800, 2, { 725, 608 } },
    { 440820, 2, { 711, 620 } },
    { 440840, 2, { 824, 535 } },
    { 440865, 2, { 873, 505 } },
    { 440916, 2, { 724, 609 } },
    { 440960, 2, { 689, 640 } },
    { 441012, 2, { 771, 572 } },
    { 441025, 2, { 767, 575 } },
    { 441045, 2, { 729, 605 } },
    { 441084, 2, { 708, 623 } },
    { 441090, 2, { 754, 585 } },
    { 441168, 2, { 707, 624 } },
    { 441180, 2, { 684, 645 } },
    { 441285, 2, { 949, 465 } },
    { 441288, 2, { 681, 648 } },
    { 441320, 2, { 680, 649 } },
    { 441336, 2, { 777, 568 } },
    { 441350, 2, { 679, 650 } },
    { 441396, 2, { 732, 603 } },
    { 441408, 2, { 704, 627 } },
    { 441441, 2, { 693, 637 } },
    { 441504, 2, { 672, 657 } },
    { 441518, 2, { 671, 658 } },
    { 441540, 2, { 669, 660 } },
    { 441560, 2, { 665, 664 } },
    { 441595, 2, { 1085, 407 } },
    { 441600, 2, { 690, 640 } },
    { 441612, 2, { 783, 564 } },
    { 441636, 2, { 741, 596 } },
    { 441672, 2, { 717, 616 } },
    { 441675, 2, { 755, 585 } },
    { 441693, 2, { 779, 567 } },
    { 441696, 2, { 688, 642 } },
    { 441728, 2, { 812, 544 } },
    { 441750, 2, { 750, 589 } },
    { 441768, 2, { 699, 632 } },
    { 441780, 2, { 740, 597 } },
    { 441792, 2, { 708, 624 } },
    { 441840, 2, { 789, 560 } },
    { 441870, 2, { 715, 618 } },
    { 441875, 2, { 707, 625 } },
    { 441910, 2, { 749, 590 } },
    { 441936, 2, { 682, 648 } },
    { 441945, 2, { 805, 549 } },
    { 441960, 2, { 696, 635 } },
    { 442020, 2, { 695, 636 } },
    { 442068, 2, { 748, 591 } },
    { 442125, 2, { 675, 655 } },
    { 442134, 2, { 693, 638 } },
    { 442152, 2, { 712, 621 } },
    { 442176, 2, { 672, 658 } },
    { 442188, 2, { 692, 639 } },
    { 442200, 2, { 670, 660 } },
    { 442221, 2, { 667, 663 } },
    { 442224, 2, { 666, 664 } },
    { 442236, 2, { 807, 548 } },
    { 442244, 2, { 836, 529 } },
    { 442255, 2, { 731, 605 } },
    { 442272, 2, { 813, 544 } },
    { 442320, 2, { 760, 582 } },
    { 442323, 2, { 833, 531 } },
    { 442330, 2, { 710, 623 } },
    { 442356, 2, { 764, 579 } },
    { 442395, 2, { 783, 565 } },
    { 442428, 2, { 687, 644 } },
    { 442442, 2, { 1001, 442 } },
    { 442470, 2, { 686, 645 } },
    { 442476, 2, { 723, 612 } },
    { 442494, 2, { 793, 558 } },
    { 442500, 2, { 708, 625 } },
    { 442530, 2, { 745, 594 } },
    { 442540, 2, { 763, 580 } },
    { 442680, 2, { 680, 651 } },
    { 442740, 2, { 705, 628 } },
    { 442764, 2, { 753, 588 } },
    { 442773, 2, { 713, 621 } },
    { 442800, 2, { 675, 656 } },
    { 442816, 2, { 704, 629 } },
    { 442860, 2, { 671, 660 } },
    { 442884, 2, { 668, 663 } },
    { 442890, 2, { 666, 665 } },
    { 442953, 2, { 711, 623 } },
    { 442960, 2, { 784, 565 } },
    { 442975, 2, { 725, 611 } },
    { 443040, 2, { 710, 624 } },
    { 443080, 2, { 760, 583 } },
    { 443100, 2, { 700, 633 } },
    { 443156, 2, { 686, 646 } },
    { 443256, 2, { 759, 584 } },
    { 443300, 2, { 682, 650 } },
    { 443352, 2, { 696, 637 } },
    { 443385, 2, { 835, 531 } },
    { 443408, 2, { 749, 592 } },
    { 443415, 2, { 721, 615 } },
    { 443520, 2, { 672, 660 } },
    { 443555, 2, { 667, 665 } },
    { 443586, 2, { 726, 611 } },
    { 443610, 2, { 795, 558 } },
    { 443625, 2, { 845, 525 } },
    { 443664, 2, { 702, 632 } },
    { 443674, 2, { 737, 602 } },
    { 443680, 2, { 752, 590 } },
    { 443700, 2, { 725, 612 } },
    { 443716, 2, { 689, 644 } },
    { 443760, 2, { 688, 645 } },
    { 443808, 2, { 736, 603 } },
    { 443840, 2, { 730, 608 } },
    { 443880, 2, { 685, 648 } },
    { 443904, 2, { 768, 578 } },
    { 443916, 2, { 684, 649 } },
    { 443940, 2, { 735, 604 } },
    { 443961, 2, { 729, 609 } },
    { 443975, 2, { 1075, 413 } },
    { 443989, 2, { 697, 637 } },
    { 444000, 2, { 740, 600 } },
    { 444012, 2, { 681, 652 } },
    { 444015, 2, { 715, 621 } },
    { 444087, 2, { 931, 477 } },
    { 444090, 2, { 678, 655 } },
    { 444096, 2, { 771, 576 } },
    { 444105, 2, { 695, 639 } },
    { 444106, 2, { 754, 589 } },
    { 444132, 2, { 676, 657 } },
    { 444136, 2, { 721, 616 } },
    { 444150, 2, { 675, 658 } },
    { 444168, 2, { 744, 597 } },
    { 444216, 2, { 669, 664 } },
    { 444276, 2, { 738, 602 } },
    { 444375, 2, { 711, 625 } },
    { 444405, 2, { 689, 645 } },
    { 444416, 2, { 868, 512 } },
    { 444432, 2, { 752, 591 } },
    { 444444, 2, { 777, 572 } },
    { 444465, 2, { 747, 595 } },
    { 444528, 2, { 686, 648 } },
    { 444540, 2, { 717, 620 } },
    { 444564, 2, { 699, 636 } },
    { 444600, 2, { 684, 650 } },
    { 444612, 2, { 804, 553 } },
    { 444620, 2, { 860, 517 } },
    { 444636, 2, { 716, 621 } },
    { 444672, 2, { 768, 579 } },
    { 444675, 2, { 735, 605 } },
    { 444686, 2, { 697, 638 } },
    { 444690, 2, { 729, 610 } },
    { 444720, 2, { 680, 654 } },
    { 444744, 2, { 696, 639 } },
    { 444752, 2, { 722, 616 } },
    { 444768, 2, { 678, 656 } },
    { 444800, 2, { 695, 640 } },
    { 444850, 2, { 775, 574 } },
    { 444912, 2, { 713, 624 } },
    { 444960, 2, { 720, 618 } },
    { 444990, 2, { 815, 546 } },
    { 444996, 2, { 789, 564 } },
    { 445000, 2, { 712, 625 } },
    { 445005, 2, { 899, 495 } },
    { 445008, 2, { 762, 584 } },
    { 445056, 2, { 732, 608 } },
    { 445095, 2, { 785, 567 } },
    { 445120, 2, { 832, 535 } },
    { 445137, 2, { 861, 517 } },
    { 445176, 2, { 687, 648 } },
    { 445179, 2, { 731, 609 } },
    { 445212, 2, { 747, 596 } },
    { 445214, 2, { 686, 649 } },
    { 445260, 2, { 724, 615 } },
    { 445280, 2, { 736, 605 } },
    { 445284, 2, { 684, 651 } },
    { 445315, 2, { 845, 527 } },
    { 445356, 2, { 801, 556 } },
    { 445368, 2, { 723, 616 } },
    { 445400, 2, { 680, 655 } },
    { 445410, 2, { 707, 630 } },
    { 445419, 2, { 729, 611 } },
    { 445424, 2, { 679, 656 } },
    { 445440, 2, { 696, 640 } },
    { 445464, 2, { 807, 552 } },
    { 445480, 2, { 740, 602 } },
    { 445500, 2, { 675, 660 } },
    { 445524, 2, { 813, 548 } },
    { 445536, 2, { 672, 663 } },
    { 445560, 2, { 705, 632 } },
    { 445588, 2, { 779, 572 } },
    { 445592, 2, { 763, 584 } },
    { 445625, 2, { 713, 625 } },
    { 445632, 2, { 704, 633 } },
    { 445665, 2, { 803, 555 } },
    { 445770, 2, { 702, 635 } },
    { 445776, 2, { 753, 592 } },
    { 445788, 2, { 732, 609 } },
    { 445842, 2, { 799, 558 } },
    { 445890, 2, { 835, 534 } },
    { 445900, 2, { 686, 650 } },
    { 445995, 2, { 765, 583 } },
    { 446016, 2, { 736, 606 } },
    { 446103, 2, { 679, 657 } },
    { 446121, 2, { 837, 533 } },
    { 446148, 2, { 729, 612 } },
    { 446160, 2, { 676, 660 } },
    { 446190, 2, { 695, 642 } },
    { 446200, 2, { 776, 575 } },
    { 446215, 2, { 671, 665 } },
    { 446220, 2, { 670, 666 } },
    { 446250, 2, { 714, 625 } },
    { 446292, 2, { 693, 644 } },
    { 446340, 2, { 692, 645 } },
    { 446355, 2, { 763, 585 } },
    { 446369, 2, { 847, 527 } },
    { 446400, 2, { 720, 620 } },
    { 446424, 2, { 712, 627 } },
    { 446448, 2, { 786, 568 } },
    { 446472, 2, { 689, 648 } },
    { 446488, 2, { 833, 536 } },
    { 446500, 2, { 893, 500 } },
    { 446508, 2, { 711, 628 } },
    { 446512, 2, { 688, 649 } },
    { 446556, 2, { 748, 597 } },
    { 446600, 2, { 700, 638 } },
    { 446607, 2, { 973, 459 } },
    { 446688, 2, { 752, 594 } },
    { 446736, 2, { 681, 656 } },
    { 446745, 2, { 1027, 435 } },
    { 446760, 2, { 680, 657 } },
    { 446775, 2, { 777, 575 } },
    { 446796, 2, { 756, 591 } },
    { 446824, 2, { 707, 632 } },
    { 446832, 2, { 696, 642 } },
    { 446875, 2, { 715, 625 } },
    { 446880, 2, { 672, 665 } },
    { 446886, 2, { 671, 666 } },
    { 446892, 2, { 669, 668 } },
    { 446940, 2, { 764, 585 } },
    { 446976, 2, { 768, 582 } },
    { 447000, 2, { 745, 600 } },
    { 447005, 2, { 845, 529 } },
    { 447020, 2, { 721, 620 } },
    { 447040, 2, { 704, 635 } },
    { 447051, 2, { 713, 627 } },
    { 447120, 2, { 690, 648 } },
    { 447125, 2, { 875, 511 } },
    { 447174, 2, { 702, 637 } },
    { 447180, 2, { 771, 580 } },
    { 447200, 2, { 688, 650 } },
    { 447216, 2, { 726, 616 } },
    { 447300, 2, { 700, 639 } },
    { 447304, 2, { 748, 598 } },
    { 447360, 2, { 699, 640 } },
    { 447370, 2, { 770, 581 } },
    { 447372, 2, { 731, 612 } },
    { 447408, 2, { 717, 624 } },
    { 447435, 2, { 815, 549 } },
    { 447440, 2, { 680, 658 } },
    { 447450, 2, { 785, 570 } },
    { 447525, 2, { 675, 663 } },
    { 447552, 2, { 672, 666 } },
    { 447564, 2, { 741, 604 } },
    { 447678, 2, { 693, 646 } },
    { 447720, 2, { 728, 615 } },
    { 447741, 2, { 721, 621 } },
    { 447744, 2, { 704, 636 } },
    { 447795, 2, { 837, 535 } },
    { 447810, 2, { 690, 649 } },
    { 447811, 2, { 703, 637 } },
    { 447850, 2, { 689, 650 } },
    { 447876, 2, { 702, 638 } },
    { 447888, 2, { 688, 651 } },
    { 447924, 2, { 687, 652 } },
    { 447925, 2, { 779, 575 } },
    { 447990, 2, { 685, 654 } },
    { 448000, 2, { 700, 640 } },
    { 448020, 2, { 684, 655 } },
    { 448050, 2, { 725, 618 } },
    { 448063, 2, { 847, 529 } },
    { 448096, 2, { 737, 608 } },
    { 448140, 2, { 679, 660 } },
    { 448152, 2, { 789, 568 } },
    { 448164, 2, { 708, 633 } },
    { 448188, 2, { 676, 663 } },
    { 448200, 2, { 675, 664 } },
    { 448224, 2, { 672, 667 } },
    { 448239, 2, { 799, 561 } },
    { 448260, 2, { 723, 620 } },
    { 448294, 2, { 781, 574 } },
    { 448335, 2, { 729, 615 } },
    { 448380, 2, { 705, 636 } },
    { 448404, 2, { 869, 516 } },
    { 448448, 2, { 704, 637 } },
    { 448470, 2, { 755, 594 } },
    { 448497, 2, { 791, 567 } },
    { 448514, 2, { 703, 638 } },
    { 448539, 2, { 689, 651 } },
    { 448560, 2, { 712, 630 } },
    { 448630, 2, { 754, 595 } },
    { 448632, 2, { 744, 603 } },
    { 448692, 2, { 807, 556 } },
    { 448695, 2, { 767, 585 } },
    { 448704, 2, { 684, 656 } },
    { 448776, 2, { 813, 552 } },
    { 448788, 2, { 753, 596 } },
    { 448812, 2, { 819, 548 } },
    { 448833, 2, { 737, 609 } },
    { 448868, 2, { 697, 644 } },
    { 448875, 2, { 675, 665 } },
    { 448920, 2, { 696, 645 } },
    { 448932, 2, { 716, 627 } },
    { 448944, 2, { 752, 597 } },
    { 448960, 2, { 736, 610 } },
    { 449064, 2, { 693, 648 } },
    { 449075, 2, { 781, 575 } },
    { 449080, 2, { 824, 545 } },
    { 449085, 2, { 705, 637 } },
    { 449106, 2, { 714, 629 } },
    { 449152, 2, { 704, 638 } },
    { 449160, 2, { 760, 591 } },
    { 449190, 2, { 690, 651 } },
    { 449235, 2, { 745, 603 } },
    { 449280, 2, { 702, 640 } },
    { 449288, 2, { 791, 568 } },
    { 449328, 2, { 759, 592 } },
    { 449344, 2, { 826, 544 } },
    { 449350, 2, { 817, 550 } },
    { 449352, 2, { 711, 632 } },
    { 449360, 2, { 685, 656 } },
    { 449388, 2, { 684, 657 } },
    { 449460, 2, { 681, 660 } },
    { 449568, 2, { 672, 669 } },
    { 449580, 2, { 708, 635 } },
    { 449595, 2, { 873, 515 } },
    { 449604, 2, { 724, 621 } },
    { 449631, 2, { 793, 567 } },
    { 449652, 2, { 707, 636 } },
    { 449696, 2, { 736, 611 } },
    { 449735, 2, { 715, 629 } },
    { 449757, 2, { 693, 649 } },
    { 449820, 2, { 714, 630 } },
    { 449856, 2, { 704, 639 } },
    { 449878, 2, { 1331, 338 } },
    { 449904, 2, { 721, 624 } },
    { 449920, 2, { 703, 640 } },
    { 449952, 2, { 688, 654 } },
    { 449955, 2, { 891, 505 } },
    { 449995, 2, { 805, 559 } },
    { 450000, 2, { 720, 625 } },
    { 450016, 2, { 686, 656 } },
    { 450045, 2, { 685, 657 } },
    { 450072, 2, { 684, 658 } },
    { 450120, 2, { 682, 660 } },
    { 450156, 2, { 699, 644 } },
    { 450170, 2, { 763, 590 } },
    { 450180, 2, { 732, 615 } },
    { 450192, 2, { 678, 664 } },
    { 450225, 2, { 675, 667 } },
    { 450240, 2, { 672, 670 } },
    { 450264, 2, { 771, 584 } },
    { 450275, 2, { 775, 581 } },
    { 450276, 2, { 717, 628 } },
    { 450296, 2, { 731, 616 } },
    { 450360, 2, { 695, 648 } },
    { 450432, 2, { 736, 612 } },
    { 450492, 2, { 692, 651 } },
    { 450528, 2, { 722, 624 } },
    { 450549, 2, { 999, 451 } },
    { 450585, 2, { 765, 589 } },
    { 450604, 2, { 836, 539 } },
    { 450625, 2, { 721, 625 } },
    { 450640, 2, { 688, 655 } },
    { 450660, 2, { 740, 609 } },
    { 450672, 2, { 687, 656 } },
    { 450696, 2, { 712, 633 } },
    { 450765, 2, { 795, 567 } },
    { 450775, 2, { 949, 475 } },
    { 450800, 2, { 700, 644 } },
    { 450840, 2, { 680, 663 } },
    { 450856, 2, { 679, 664 } },
    { 450864, 2, { 744, 606 } },
    { 450870, 2, { 678, 665 } },
    { 450892, 2, { 676, 667 } },
    { 450900, 2, { 675, 668 } },
    { 450912, 2, { 672, 671 } },
    { 450918, 2, { 738, 611 } },
    { 450984, 2, { 817, 552 } },
    { 450996, 2, { 708, 637 } },
    { 451044, 2, { 737, 612 } },
    { 451050, 2, { 775, 582 } },
    { 451104, 2, { 762, 592 } },
    { 451136, 2, { 742, 608 } },
    { 451152, 2, { 723, 624 } },
    { 451178, 2, { 871, 518 } },
    { 451188, 2, { 747, 604 } },
    { 451200, 2, { 705, 640 } },
    { 451230, 2, { 845, 534 } },
    { 451242, 2, { 774, 583 } },
    { 451248, 2, { 714, 632 } },
    { 451250, 2, { 722, 625 } },
    { 451308, 2, { 789, 572 } },
    { 451332, 2, { 756, 597 } },
    { 451451, 2, { 847, 533 } },
    { 451470, 2, { 745, 606 } },
    { 451485, 2, { 711, 635 } },
    { 451500, 2, { 700, 645 } },
    { 451524, 2, { 764, 591 } },
    { 451530, 2, { 865, 522 } },
    { 451560, 2, { 710, 636 } },
    { 451605, 2, { 759, 595 } },
    { 451620, 2, { 772, 585 } },
    { 451647, 2, { 749, 603 } },
    { 451656, 2, { 697, 648 } },
    { 451675, 2, { 725, 623 } },
    { 451696, 2, { 763, 592 } },
    { 451704, 2, { 696, 649 } },
    { 451737, 2, { 891, 507 } },
    { 451764, 2, { 801, 564 } },
    { 451773, 2, { 707, 639 } },
    { 451800, 2, { 753, 600 } },
    { 451820, 2, { 779, 580 } },
    { 451825, 2, { 775, 583 } },
    { 451836, 2, { 693, 652 } },
    { 451880, 2, { 715, 632 } },
    { 451920, 2, { 807, 560 } },
    { 451935, 2, { 747, 605 } },
    { 451950, 2, { 690, 655 } },
    { 451968, 2, { 704, 642 } },
    { 451980, 2, { 729, 620 } },
    { 451984, 2, { 689, 656 } },
    { 452000, 2, { 800, 565 } },
    { 452016, 2, { 688, 657 } },
    { 452028, 2, { 813, 556 } },
    { 452088, 2, { 702, 644 } },
    { 452100, 2, { 685, 660 } },
    { 452120, 2, { 712, 635 } },
    { 452140, 2, { 740, 611 } },
    { 452184, 2, { 681, 664 } },
    { 452196, 2, { 711, 636 } },
    { 452200, 2, { 680, 665 } },
    { 452214, 2, { 679, 666 } },
    { 452235, 2, { 885, 511 } },
    { 452244, 2, { 676, 669 } },
    { 452250, 2, { 675, 670 } },
    { 452270, 2, { 710, 637 } },
    { 452295, 2, { 855, 529 } },
    { 452352, 2, { 744, 608 } },
    { 452364, 2, { 759, 596 } },
    { 452375, 2, { 875, 517 } },
    { 452400, 2, { 696, 650 } },
    { 452412, 2, { 708, 639 } },
    { 452466, 2, { 798, 567 } },
    { 452480, 2, { 707, 640 } },
    { 452565, 2, { 801, 565 } },
    { 452640, 2, { 690, 656 } },
    { 452704, 2, { 688, 658 } },
    { 452732, 2, { 703, 644 } },
    { 452736, 2, { 786, 576 } },
    { 452760, 2, { 686, 660 } },
    { 452790, 2, { 702, 645 } },
    { 452880, 2, { 680, 666 } },
    { 452892, 2, { 803, 564 } },
    { 452907, 2, { 711, 637 } },
    { 452925, 2, { 675, 671 } },
    { 452952, 2, { 699, 648 } },
    { 452960, 2, { 745, 608 } },
    { 452991, 2, { 777, 583 } },
    { 453024, 2, { 726, 624 } },
    { 453033, 2, { 799, 567 } },
    { 453050, 2, { 697, 650 } },
    { 453096, 2, { 696, 651 } },
    { 453120, 2, { 708, 640 } },
    { 453144, 2, { 717, 632 } },
    { 453152, 2, { 784, 578 } },
    { 453180, 2, { 780, 581 } },
    { 453220, 2, { 731, 620 } },
    { 453228, 2, { 716, 633 } },
    { 453250, 2, { 875, 518 } },
    { 453255, 2, { 737, 615 } },
    { 453264, 2, { 798, 568 } },
    { 453299, 2, { 841, 539 } },
    { 453348, 2, { 771, 588 } },
    { 453362, 2, { 689, 658 } },
    { 453375, 2, { 775, 585 } },
    { 453376, 2, { 704, 644 } },
    { 453390, 2, { 714, 635 } },
    { 453420, 2, { 687, 660 } },
    { 453440, 2, { 832, 545 } },
    { 453456, 2, { 752, 603 } },
    { 453492, 2, { 684, 663 } },
    { 453530, 2, { 682, 665 } },
    { 453544, 2, { 712, 637 } },
    { 453560, 2, { 680, 667 } },
    { 453600, 2, { 675, 672 } },
    { 453680, 2, { 848, 535 } },
    { 453720, 2, { 760, 597 } },
    { 453744, 2, { 822, 552 } },
    { 453747, 2, { 697, 651 } },
    { 453750, 2, { 726, 625 } },
    { 453768, 2, { 777, 584 } },
    { 453888, 2, { 768, 591 } },
    { 453915, 2, { 693, 655 } },
    { 453948, 2, { 724, 627 } },
    { 453951, 2, { 731, 621 } },
    { 453960, 2, { 776, 585 } },
    { 453992, 2, { 737, 616 } },
    { 454020, 2, { 690, 658 } },
    { 454044, 2, { 723, 628 } },
    { 454064, 2, { 767, 592 } },
    { 454080, 2, { 688, 660 } },
    { 454138, 2, { 703, 646 } },
    { 454140, 2, { 783, 580 } },
    { 454167, 2, { 729, 623 } },
    { 454181, 2, { 713, 637 } },
    { 454230, 2, { 721, 630 } },
    { 454272, 2, { 676, 672 } },
    { 454300, 2, { 700, 649 } },
    { 454400, 2, { 710, 640 } },
    { 454410, 2, { 765, 594 } },
    { 454464, 2, { 789, 576 } },
    { 454475, 2, { 1225, 371 } },
    { 454480, 2, { 760, 598 } },
    { 454530, 2, { 695, 654 } },
    { 454545, 2, { 777, 585 } },
    { 454572, 2, { 732, 621 } },
    { 454584, 2, { 744, 611 } },
    { 454597, 2, { 1573, 289 } },
    { 454608, 2, { 693, 656 } },
    { 454644, 2, { 692, 657 } },
    { 454740, 2, { 689, 660 } },
    { 454755, 2, { 915, 497 } },
    { 454770, 2, { 815, 558 } },
    { 454784, 2, { 704, 646 } },
    { 454790, 2, { 730, 623 } },
    { 454812, 2, { 753, 604 } },
    { 454818, 2, { 686, 663 } },
    { 454825, 2, { 791, 575 } },
    { 454840, 2, { 685, 664 } },
    { 454848, 2, { 736, 618 } },
    { 454860, 2, { 684, 665 } },
    { 454896, 2, { 702, 648 } },
    { 454908, 2, { 681, 668 } },
    { 454920, 2, { 680, 669 } },
    { 454930, 2, { 679, 670 } },
    { 454960, 2, { 752, 605 } },
    { 454968, 2, { 712, 639 } },
    { 455026, 2, { 814, 559 } },
    { 455040, 2, { 711, 640 } },
    { 455100, 2, { 740, 615 } },
    { 455112, 2, { 756, 602 } },
    { 455148, 2, { 807, 564 } },
    { 455168, 2, { 889, 512 } },
    { 455175, 2, { 765, 595 } },
    { 455182, 2, { 793, 574 } },
    { 455184, 2, { 696, 654 } },
    { 455235, 2, { 979, 465 } },
    { 455265, 2, { 755, 603 } },
    { 455280, 2, { 813, 560 } },
    { 455364, 2, { 819, 556 } },
    { 455392, 2, { 749, 608 } },
    { 455520, 2, { 730, 624 } },
    { 455532, 2, { 714, 638 } },
    { 455598, 2, { 702, 649 } },
    { 455616, 2, { 678, 672 } },
    { 455672, 2, { 721, 632 } },
    { 455700, 2, { 700, 651 } },
    { 455712, 2, { 752, 606 } },
    { 455748, 2, { 699, 652 } },
    { 455760, 2, { 720, 633 } },
    { 455793, 2, { 899, 507 } },
    { 455868, 2, { 756, 603 } },
    { 455880, 2, { 696, 655 } },
    { 455910, 2, { 835, 546 } },
    { 455920, 2, { 695, 656 } },
    { 455940, 2, { 745, 612 } },
    { 455975, 2, { 793, 575 } },
    { 456000, 2, { 750, 608 } },
    { 456012, 2, { 717, 636 } },
    { 456015, 2, { 707, 645 } },
    { 456025, 2, { 725, 629 } },
    { 456036, 2, { 732, 623 } },
    { 456057, 2, { 889, 513 } },
    { 456108, 2, { 764, 597 } },
    { 456144, 2, { 688, 663 } },
    { 456165, 2, { 837, 545 } },
    { 456168, 2, { 687, 664 } },
    { 456192, 2, { 704, 648 } },
    { 456210, 2, { 685, 666 } },
    { 456225, 2, { 825, 553 } },
    { 456228, 2, { 684, 667 } },
    { 456252, 2, { 772, 591 } },
    { 456280, 2, { 680, 671 } },
    { 456288, 2, { 679, 672 } },
    { 456300, 2, { 676, 675 } },
    { 456320, 2, { 713, 640 } },
    { 456330, 2, { 742, 615 } },
    { 456365, 2, { 767, 595 } },
    { 456432, 2, { 771, 592 } },
    { 456435, 2, { 735, 621 } },
    { 456456, 2, { 728, 627 } },
    { 456489, 2, { 783, 583 } },
    { 456520, 2, { 808, 565 } },
    { 456615, 2, { 695, 657 } },
    { 456654, 2, { 726, 629 } },
    { 456660, 2, { 708, 645 } },
    { 456665, 2, { 1045, 437 } },
    { 456750, 2, { 725, 630 } },
    { 456768, 2, { 732, 624 } },
    { 456840, 2, { 705, 648 } },
    { 456870, 2, { 785, 582 } },
    { 456875, 2, { 731, 625 } },
    { 456876, 2, { 686, 666 } },
    { 456885, 2, { 715, 639 } },
    { 456890, 2, { 749, 610 } },
    { 456896, 2, { 704, 649 } },
    { 456936, 2, { 723, 632 } },
    { 456950, 2, { 703, 650 } },
    { 456960, 2, { 680, 672 } },
    { 457002, 2, { 702, 651 } },
    { 457028, 2, { 748, 611 } },
    { 457056, 2, { 736, 621 } },
    { 457083, 2, { 729, 627 } },
    { 457104, 2, { 712, 642 } },
    { 457164, 2, { 747, 612 } },
    { 457200, 2, { 720, 635 } },
    { 457219, 2, { 1333, 343 } },
    { 457272, 2, { 696, 657 } },
    { 457275, 2, { 871, 525 } },
    { 457314, 2, { 858, 533 } },
    { 457317, 2, { 833, 549 } },
    { 457380, 2, { 693, 660 } },
    { 457425, 2, { 855, 535 } },
    { 457443, 2, { 959, 477 } },
    { 457500, 2, { 732, 625 } },
    { 457504, 2, { 841, 544 } },
    { 457520, 2, { 688, 665 } },
    { 457524, 2, { 716, 639 } },
    { 457530, 2, { 755, 606 } },
    { 457545, 2, { 705, 649 } },
    { 457562, 2, { 686, 667 } },
    { 457596, 2, { 684, 669 } },
    { 457600, 2, { 704, 650 } },
    { 457620, 2, { 789, 580 } },
    { 457632, 2, { 681, 672 } },
    { 457653, 2, { 703, 651 } },
    { 457677, 2, { 737, 621 } },
    { 457765, 2, { 1015, 451 } },
    { 457812, 2, { 729, 628 } },
    { 457821, 2, { 819, 559 } },
    { 457824, 2, { 753, 608 } },
    { 457884, 2, { 711, 644 } },
    { 457905, 2, { 735, 623 } },
    { 457912, 2, { 728, 629 } },
    { 457920, 2, { 720, 636 } },
    { 457968, 2, { 696, 658 } },
    { 458052, 2, { 779, 588 } },
    { 458109, 2, { 893, 513 } },
    { 458136, 2, { 707, 648 } },
    { 458160, 2, { 690, 664 } },
    { 458172, 2, { 801, 572 } },
    { 458185, 2, { 689, 665 } },
    { 458200, 2, { 725, 632 } },
    { 458208, 2, { 688, 666 } },
    { 458280, 2, { 684, 670 } },
    { 458292, 2, { 724, 633 } },
    { 458304, 2, { 682, 672 } },
    { 458325, 2, { 679, 675 } },
    { 458337, 2, { 731, 627 } },
    { 458376, 2, { 807, 568 } },
    { 458380, 2, { 820, 559 } },
    { 458415, 2, { 835, 549 } },
    { 458432, 2, { 754, 608 } },
    { 458436, 2, { 759, 604 } },
    { 458490, 2, { 870, 527 } },
    { 458496, 2, { 768, 597 } },
    { 458532, 2, { 813, 564 } },
    { 458541, 2, { 729, 629 } },
    { 458544, 2, { 699, 656 } },
    { 458556, 2, { 721, 636 } },
    { 458575, 2, { 1079, 425 } },
    { 458616, 2, { 776, 591 } },
    { 458640, 2, { 720, 637 } },
    { 458643, 2, { 867, 529 } },
    { 458689, 2, { 851, 539 } },
    { 458700, 2, { 695, 660 } },
    { 458720, 2, { 752, 610 } },
    { 458780, 2, { 791, 580 } },
    { 458796, 2, { 692, 663 } },
    { 458832, 2, { 726, 632 } },
    { 458850, 2, { 690, 665 } },
    { 458865, 2, { 891, 515 } },
    { 458874, 2, { 689, 666 } },
    { 458880, 2, { 717, 640 } },
    { 458916, 2, { 687, 668 } },
    { 458920, 2, { 745, 616 } },
    { 458964, 2, { 684, 671 } },
    { 458983, 2, { 833, 551 } },
    { 458990, 2, { 790, 581 } },
    { 459000, 2, { 680, 675 } },
    { 459024, 2, { 786, 584 } },
    { 459025, 2, { 1075, 427 } },
    { 459030, 2, { 715, 642 } },
    { 459040, 2, { 755, 608 } },
    { 459172, 2, { 713, 644 } },
    { 459225, 2, { 785, 585 } },
    { 459228, 2, { 781, 588 } },
    { 459240, 2, { 712, 645 } },
    { 459270, 2, { 729, 630 } },
    { 459315, 2, { 865, 531 } },
    { 459375, 2, { 735, 625 } },
    { 459420, 2, { 741, 620 } },
    { 459425, 2, { 799, 575 } },
    { 459459, 2, { 693, 663 } },
    { 459516, 2, { 771, 596 } },
    { 459550, 2, { 707, 650 } },
    { 459648, 2, { 684, 672 } },
    { 459660, 2, { 705, 652 } },
    { 459725, 2, { 925, 497 } },
    { 459774, 2, { 738, 623 } },
    { 459792, 2, { 744, 618 } },
    { 459800, 2, { 760, 605 } },
    { 459810, 2, { 702, 655 } },
    { 459828, 2, { 723, 636 } },
    { 459888, 2, { 737, 624 } },
    { 459900, 2, { 700, 657 } },
    { 459914, 2, { 722, 637 } },
    { 459984, 2, { 777, 592 } },
    { 460000, 2, { 736, 625 } },
    { 460020, 2, { 697, 660 } },
    { 460040, 2, { 742, 620 } },
    { 460080, 2, { 710, 648 } },
    { 460089, 2, { 763, 603 } },
    { 460152, 2, { 693, 664 } },
    { 460200, 2, { 708, 650 } },
    { 460224, 2, { 752, 612 } },
    { 460230, 2, { 690, 667 } },
    { 460272, 2, { 688, 669 } },
    { 460288, 2, { 899, 512 } },
    { 460306, 2, { 686, 671 } },
    { 460317, 2, { 957, 481 } },
    { 460320, 2, { 685, 672 } },
    { 460350, 2, { 682, 675 } },
    { 460356, 2, { 681, 676 } },
    { 460404, 2, { 756, 609 } },
    { 460410, 2, { 745, 618 } },
    { 460416, 2, { 704, 654 } },
    { 460512, 2, { 702, 656 } },
    { 460560, 2, { 760, 606 } },
    { 460575, 2, { 801, 575 } },
    { 460598, 2, { 713, 646 } },
    { 460600, 2, { 700, 658 } },
    { 460625, 2, { 737, 625 } },
    { 460635, 2, { 749, 615 } },
    { 460647, 2, { 891, 517 } },
    { 460692, 2, { 764, 603 } },
    { 460719, 2, { 721, 639 } },
    { 460728, 2, { 711, 648 } },
    { 460768, 2, { 748, 616 } },
    { 460776, 2, { 789, 584 } },
    { 460782, 2, { 742, 621 } },
    { 460800, 2, { 720, 640 } },
    { 460824, 2, { 728, 633 } },
    { 460836, 2, { 753, 612 } },
    { 460845, 2, { 693, 665 } },
    { 460884, 2, { 772, 597 } },
    { 460908, 2, { 708, 651 } },
    { 460922, 2, { 803, 574 } },
    { 460944, 2, { 776, 594 } },
    { 460955, 2, { 935, 493 } },
    { 460960, 2, { 688, 670 } },
    { 460980, 2, { 780, 591 } },
    { 460992, 2, { 686, 672 } },
    { 461010, 2, { 726, 635 } },
    { 461020, 2, { 740, 623 } },
    { 461040, 2, { 680, 678 } },
    { 461100, 2, { 725, 636 } },
    { 461120, 2, { 704, 655 } },
    { 461187, 2, { 783, 589 } },
    { 461244, 2, { 714, 646 } },
    { 461250, 2, { 738, 625 } },
    { 461340, 2, { 699, 660 } },
    { 461370, 2, { 845, 546 } },
    { 461384, 2, { 749, 616 } },
    { 461440, 2, { 721, 640 } },
    { 461448, 2, { 696, 663 } },
    { 461472, 2, { 736, 627 } },
    { 461480, 2, { 695, 664 } },
    { 461580, 2, { 735, 628 } },
    { 461604, 2, { 807, 572 } },
    { 461648, 2, { 688, 671 } },
    { 461664, 2, { 687, 672 } },
    { 461700, 2, { 684, 675 } },
    { 461720, 2, { 680, 679 } },
    { 461725, 2, { 803, 575 } },
    { 461734, 2, { 767, 602 } },
    { 461748, 2, { 717, 644 } },
    { 461760, 2, { 740, 624 } },
    { 461776, 2, { 784, 589 } },
    { 461784, 2, { 813, 568 } },
    { 461820, 2, { 716, 645 } },
    { 461825, 2, { 725, 637 } },
    { 461890, 2, { 715, 646 } },
    { 461895, 2, { 795, 581 } },
    { 461910, 2, { 865, 534 } },
    { 461916, 2, { 702, 658 } },
    { 461944, 2, { 791, 584 } },
    { 461970, 2, { 783, 590 } },
    { 462024, 2, { 713, 648 } },
    { 462036, 2, { 831, 556 } },
    { 462060, 2, { 755, 612 } },
    { 462080, 2, { 722, 640 } },
    { 462105, 2, { 815, 567 } },
    { 462111, 2, { 697, 663 } },
    { 462160, 2, { 848, 545 } },
    { 462213, 2, { 901, 513 } },
    { 462231, 2, { 693, 667 } },
    { 462240, 2, { 720, 642 } },
    { 462280, 2, { 728, 635 } },
    { 462315, 2, { 735, 629 } },
    { 462352, 2, { 781, 592 } },
    { 462375, 2, { 685, 675 } },
    { 462480, 2, { 705, 656 } },
    { 462528, 2, { 704, 657 } },
    { 462553, 2, { 1183, 391 } },
    { 462560, 2, { 784, 590 } },
    { 462600, 2, { 771, 600 } },
    { 462636, 2, { 724, 639 } },
    { 462645, 2, { 745, 621 } },
    { 462672, 2, { 714, 648 } },
    { 462720, 2, { 723, 640 } },
    { 462735, 2, { 791, 585 } },
    { 462825, 2, { 765, 605 } },
    { 462840, 2, { 696, 665 } },
    { 462870, 2, { 695, 666 } },
    { 462915, 2, { 729, 635 } },
    { 462924, 2, { 693, 668 } },
    { 462944, 2, { 736, 629 } },
    { 462948, 2, { 692, 669 } },
    { 462990, 2, { 690, 671 } },
    { 463008, 2, { 689, 672 } },
    { 463050, 2, { 686, 675 } },
    { 463080, 2, { 681, 680 } },
    { 463092, 2, { 777, 596 } },
    { 463104, 2, { 768, 603 } },
    { 463125, 2, { 741, 625 } },
    { 463140, 2, { 747, 620 } },
    { 463232, 2, { 704, 658 } },
    { 463239, 2, { 817, 567 } },
    { 463272, 2, { 776, 597 } },
    { 463275, 2, { 725, 639 } },
    { 463296, 2, { 762, 608 } },
    { 463344, 2, { 784, 591 } },
    { 463356, 2, { 732, 633 } },
    { 463372, 2, { 871, 532 } },
    { 463386, 2, { 714, 649 } },
    { 463420, 2, { 799, 580 } },
    { 463450, 2, { 713, 650 } },
    { 463505, 2, { 697, 665 } },
    { 463512, 2, { 712, 651 } },
    { 463536, 2, { 696, 666 } },
    { 463572, 2, { 711, 652 } },
    { 463644, 2, { 729, 636 } },
    { 463680, 2, { 690, 672 } },
    { 463736, 2, { 686, 676 } },
    { 463740, 2, { 708, 655 } },
    { 463749, 2, { 759, 611 } },
    { 463750, 2, { 742, 625 } },
    { 463760, 2, { 682, 680 } },
    { 463792, 2, { 707, 656 } },
    { 463848, 2, { 753, 616 } },
    { 463904, 2, { 763, 608 } },
    { 463905, 2, { 793, 585 } },
    { 463932, 2, { 789, 588 } },
    { 463980, 2, { 703, 660 } },
    { 464000, 2, { 725, 640 } },
    { 464100, 2, { 700, 663 } },
    { 464121, 2, { 973, 477 } },
    { 464136, 2, { 699, 664 } },
    { 464202, 2, { 697, 666 } },
    { 464280, 2, { 730, 636 } },
    { 464360, 2, { 760, 611 } },
    { 464373, 2, { 729, 637 } },
    { 464380, 2, { 749, 620 } },
    { 464400, 2, { 688, 675 } },
    { 464412, 2, { 687, 676 } },
    { 464430, 2, { 685, 678 } },
    { 464436, 2, { 684, 679 } },
    { 464448, 2, { 708, 656 } },
    { 464464, 2, { 728, 638 } },
    { 464499, 2, { 707, 657 } },
    { 464508, 2, { 748, 621 } },
    { 464520, 2, { 735, 632 } },
    { 464535, 2, { 837, 555 } },
    { 464550, 2, { 815, 570 } },
    { 464576, 2, { 854, 544 } },
    { 464580, 2, { 801, 580 } },
    { 464600, 2, { 808, 575 } },
    { 464616, 2, { 717, 648 } },
    { 464625, 2, { 875, 531 } },
    { 464640, 2, { 704, 660 } },
    { 464695, 2, { 781, 595 } },
    { 464736, 2, { 752, 618 } },
    { 464820, 2, { 732, 635 } },
    { 464832, 2, { 807, 576 } },
    { 464880, 2, { 745, 624 } },
    { 465000, 2, { 744, 625 } },
    { 465003, 2, { 693, 671 } },
    { 465010, 2, { 730, 637 } },
    { 465025, 2, { 979, 475 } },
    { 465036, 2, { 813, 572 } },
    { 465045, 2, { 721, 645 } },
    { 465075, 2, { 689, 675 } },
    { 465080, 2, { 755, 616 } },
    { 465102, 2, { 729, 638 } },
    { 465129, 2, { 749, 621 } },
    { 465156, 2, { 708, 657 } },
    { 465192, 2, { 728, 639 } },
    { 465276, 2, { 764, 609 } },
    { 465290, 2, { 782, 595 } },
    { 465300, 2, { 705, 660 } },
    { 465312, 2, { 786, 592 } },
    { 465348, 2, { 741, 628 } },
    { 465360, 2, { 831, 560 } },
    { 465381, 2, { 747, 623 } },
    { 465408, 2, { 768, 606 } },
    { 465426, 2, { 702, 663 } },
    { 465430, 2, { 763, 610 } },
    { 465450, 2, { 725, 642 } },
    { 465500, 2, { 700, 665 } },
    { 465516, 2, { 772, 603 } },
    { 465520, 2, { 880, 529 } },
    { 465560, 2, { 824, 565 } },
    { 465595, 2, { 845, 551 } },
    { 465612, 2, { 723, 644 } },
    { 465624, 2, { 696, 669 } },
    { 465647, 2, { 731, 637 } },
    { 465648, 2, { 712, 654 } },
    { 465660, 2, { 780, 597 } },
    { 465684, 2, { 771, 604 } },
    { 465696, 2, { 693, 672 } },
    { 465705, 2, { 711, 655 } },
    { 465760, 2, { 710, 656 } },
    { 465800, 2, { 685, 680 } },
    { 465804, 2, { 684, 681 } },
    { 465842, 2, { 779, 598 } },
    { 465885, 2, { 765, 609 } },
    { 465888, 2, { 736, 633 } },
    { 465920, 2, { 728, 640 } },
    { 465930, 2, { 835, 558 } },
    { 465975, 2, { 855, 545 } },
    { 466032, 2, { 798, 584 } },
    { 466089, 2, { 703, 663 } },
    { 466116, 2, { 716, 651 } },
    { 466128, 2, { 702, 664 } },
    { 466284, 2, { 732, 637 } },
    { 466290, 2, { 785, 594 } },
    { 466320, 2, { 696, 670 } },
    { 466336, 2, { 767, 608 } },
    { 466360, 2, { 712, 655 } },
    { 466375, 2, { 875, 533 } },
    { 466378, 2, { 731, 638 } },
    { 466400, 2, { 800, 583 } },
    { 466416, 2, { 711, 656 } },
    { 466464, 2, { 688, 678 } },
    { 466480, 2, { 686, 680 } },
    { 466488, 2, { 684, 682 } },
    { 466520, 2, { 856, 545 } },
    { 466550, 2, { 775, 602 } },
    { 466578, 2, { 882, 529 } },
    { 466590, 2, { 755, 618 } },
    { 466620, 2, { 707, 660 } },
    { 466668, 2, { 783, 596 } },
    { 466690, 2, { 791, 590 } },
    { 466697, 2, { 847, 551 } },
    { 466752, 2, { 704, 663 } },
    { 466830, 2, { 702, 665 } },
    { 466851, 2, { 903, 517 } },
    { 466860, 2, { 753, 620 } },
    { 466875, 2, { 747, 625 } },
    { 466896, 2, { 822, 568 } },
    { 466900, 2, { 700, 667 } },
    { 466932, 2, { 699, 668 } },
    { 466980, 2, { 724, 645 } },
    { 466992, 2, { 752, 621 } },
    { 467016, 2, { 696, 671 } },
    { 467040, 2, { 695, 672 } },
    { 467055, 2, { 873, 535 } },
    { 467088, 2, { 789, 592 } },
    { 467100, 2, { 692, 675 } },
    { 467103, 2, { 767, 609 } },
    { 467124, 2, { 804, 581 } },
    { 467152, 2, { 688, 679 } },
    { 467160, 2, { 687, 680 } },
    { 467200, 2, { 730, 640 } },
    { 467208, 2, { 721, 648 } },
    { 467250, 2, { 750, 623 } },
    { 467324, 2, { 817, 572 } },
    { 467325, 2, { 775, 603 } },
    { 467360, 2, { 736, 635 } },
    { 467376, 2, { 728, 642 } },
    { 467400, 2, { 760, 615 } },
    { 467460, 2, { 735, 636 } },
    { 467484, 2, { 717, 652 } },
    { 467495, 2, { 703, 665 } },
    { 467500, 2, { 748, 625 } },
    { 467509, 2, { 1363, 343 } },
    { 467565, 2, { 915, 511 } },
    { 467610, 2, { 715, 654 } },
    { 467670, 2, { 714, 655 } },
    { 467712, 2, { 696, 672 } },
    { 467748, 2, { 732, 639 } },
    { 467775, 2, { 693, 675 } },
    { 467784, 2, { 712, 657 } },
    { 467852, 2, { 686, 682 } },
    { 467883, 2, { 837, 559 } },
    { 467928, 2, { 776, 603 } },
    { 467976, 2, { 744, 629 } },
    { 468000, 2, { 720, 650 } },
    { 468048, 2, { 784, 597 } },
    { 468050, 2, { 814, 575 } },
    { 468060, 2, { 807, 580 } },
    { 468096, 2, { 736, 636 } },
    { 468120, 2, { 705, 664 } },
    { 468125, 2, { 749, 625 } },
    { 468135, 2, { 909, 515 } },
    { 468160, 2, { 704, 665 } },
    { 468180, 2, { 765, 612 } },
    { 468195, 2, { 735, 637 } },
    { 468234, 2, { 702, 667 } },
    { 468272, 2, { 791, 592 } },
    { 468288, 2, { 813, 576 } },
    { 468300, 2, { 700, 669 } },
    { 468312, 2, { 741, 632 } },
    { 468342, 2, { 826, 567 } },
    { 468384, 2, { 697, 672 } },
    { 468420, 2, { 740, 633 } },
    { 468468, 2, { 693, 676 } },
    { 468480, 2, { 732, 640 } },
    { 468504, 2, { 723, 648 } },
    { 468510, 2, { 690, 679 } },
    { 468520, 2, { 689, 680 } },
    { 468528, 2, { 688, 681 } },
    { 468540, 2, { 685, 684 } },
    { 468600, 2, { 710, 660 } },
    { 468630, 2, { 738, 635 } },
    { 468650, 2, { 721, 650 } },
    { 468684, 2, { 831, 564 } },
    { 468720, 2, { 720, 651 } },
    { 468732, 2, { 737, 636 } },
    { 468768, 2, { 771, 608 } },
    { 468855, 2, { 755, 621 } },
    { 468864, 2, { 704, 666 } },
    { 468930, 2, { 735, 638 } },
    { 468996, 2, { 726, 646 } },
    { 469040, 2, { 715, 656 } },
    { 469116, 2, { 747, 628 } },
    { 469125, 2, { 695, 675 } },
    { 469200, 2, { 690, 680 } },
    { 469224, 2, { 686, 684 } },
    { 469245, 2, { 763, 615 } },
    { 469260, 2, { 711, 660 } },
    { 469300, 2, { 722, 650 } },
    { 469308, 2, { 777, 604 } },
    { 469315, 2, { 805, 583 } },
    { 469350, 2, { 745, 630 } },
    { 469365, 2, { 1079, 435 } },
    { 469392, 2, { 762, 616 } },
    { 469404, 2, { 708, 663 } },
    { 469448, 2, { 707, 664 } },
    { 469456, 2, { 793, 592 } },
    { 469469, 2, { 737, 637 } },
    { 469476, 2, { 729, 644 } },
    { 469480, 2, { 776, 605 } },
    { 469530, 2, { 705, 666 } },
    { 469560, 2, { 728, 645 } },
    { 469567, 2, { 1369, 343 } },
    { 469568, 2, { 704, 667 } },
    { 469650, 2, { 775, 606 } },
    { 469680, 2, { 760, 618 } },
    { 469700, 2, { 700, 671 } },
    { 469728, 2, { 699, 672 } },
    { 469752, 2, { 851, 552 } },
    { 469755, 2, { 715, 657 } },
    { 469775, 2, { 817, 575 } },
    { 469800, 2, { 696, 675 } },
    { 469860, 2, { 764, 615 } },
    { 469872, 2, { 753, 624 } },
    { 469898, 2, { 689, 682 } },
    { 469908, 2, { 687, 684 } },
    { 470000, 2, { 752, 625 } },
    { 470008, 2, { 763, 616 } },
    { 470016, 2, { 768, 612 } },
    { 470080, 2, { 832, 565 } },
    { 470106, 2, { 738, 637 } },
    { 470148, 2, { 772, 609 } },
    { 470162, 2, { 781, 602 } },
    { 470205, 2, { 729, 645 } },
    { 470244, 2, { 789, 596 } },
    { 470250, 2, { 750, 627 } },
    { 470256, 2, { 776, 606 } },
    { 470288, 2, { 728, 646 } },
    { 470304, 2, { 736, 639 } },
    { 470322, 2, { 901, 522 } },
    { 470327, 2, { 1573, 299 } },
    { 470340, 2, { 702, 670 } },
    { 470352, 2, { 717, 656 } },
    { 470400, 2, { 700, 672 } },
    { 470412, 2, { 716, 657 } },
    { 470421, 2, { 917, 513 } },
    { 470436, 2, { 788, 597 } },
    { 470448, 2, { 726, 648 } },
    { 470475, 2, { 697, 675 } },
    { 470492, 2, { 748, 629 } },
    { 470525, 2, { 725, 649 } },
    { 470547, 2, { 693, 679 } },
    { 470580, 2, { 690, 682 } },
    { 470592, 2, { 688, 684 } },
    { 470764, 2, { 731, 644 } },
    { 470820, 2, { 708, 665 } },
    { 470840, 2, { 745, 632 } },
    { 470862, 2, { 707, 666 } },
    { 470880, 2, { 720, 654 } },
    { 470890, 2, { 961, 490 } },
    { 470925, 2, { 805, 585 } },
    { 470934, 2, { 729, 646 } },
    { 470940, 2, { 705, 668 } },
    { 470952, 2, { 744, 633 } },
    { 470976, 2, { 704, 669 } },
    { 470988, 2, { 756, 623 } },
    { 471042, 2, { 702, 671 } },
    { 471086, 2, { 874, 539 } },
    { 471105, 2, { 855, 551 } },
    { 471108, 2, { 913, 516 } },
    { 471120, 2, { 755, 624 } },
    { 471156, 2, { 852, 553 } },
    { 471172, 2, { 697, 676 } },
    { 471210, 2, { 695, 678 } },
    { 471240, 2, { 693, 680 } },
    { 471252, 2, { 692, 681 } },
    { 471276, 2, { 689, 684 } },
    { 471280, 2, { 688, 685 } },
    { 471288, 2, { 807, 584 } },
    { 471295, 2, { 779, 605 } },
    { 471324, 2, { 724, 651 } },
    { 471380, 2, { 740, 637 } },
    { 471396, 2, { 723, 652 } },
    { 471504, 2, { 752, 627 } },
    { 471510, 2, { 806, 585 } },
    { 471540, 2, { 813, 580 } },
    { 471600, 2, { 720, 655 } },
    { 471625, 2, { 875, 539 } },
    { 471680, 2, { 704, 670 } },
    { 471705, 2, { 767, 615 } },
    { 471744, 2, { 702, 672 } },
    { 471750, 2, { 750, 629 } },
    { 471801, 2, { 841, 561 } },
    { 471835, 2, { 793, 595 } },
    { 471852, 2, { 771, 612 } },
    { 471888, 2, { 696, 678 } },
    { 471900, 2, { 715, 660 } },
    { 471960, 2, { 690, 684 } },
    { 471968, 2, { 688, 686 } },
    { 471975, 2, { 725, 651 } },
    { 472000, 2, { 800, 590 } },
    { 472008, 2, { 831, 568 } },
    { 472017, 2, { 741, 637 } },
    { 472056, 2, { 712, 663 } },
    { 472059, 2, { 889, 531 } },
    { 472068, 2, { 837, 564 } },
    { 472104, 2, { 711, 664 } },
    { 472140, 2, { 732, 645 } },
    { 472164, 2, { 803, 588 } },
    { 472192, 2, { 868, 544 } },
    { 472230, 2, { 795, 594 } },
    { 472290, 2, { 865, 546 } },
    { 472311, 2, { 833, 567 } },
    { 472384, 2, { 704, 671 } },
    { 472392, 2, { 729, 648 } },
    { 472416, 2, { 703, 672 } },
    { 472440, 2, { 744, 635 } },
    { 472472, 2, { 728, 649 } },
    { 472500, 2, { 700, 675 } },
    { 472512, 2, { 736, 642 } },
    { 472524, 2, { 699, 676 } },
    { 472527, 2, { 999, 473 } },
    { 472549, 2, { 1309, 361 } },
    { 472584, 2, { 696, 679 } },
    { 472600, 2, { 695, 680 } },
    { 472626, 2, { 693, 682 } },
    { 472650, 2, { 690, 685 } },
    { 472654, 2, { 689, 686 } },
    { 472656, 2, { 688, 687 } },
    { 472675, 2, { 925, 511 } },
    { 472719, 2, { 713, 663 } },
    { 472752, 2, { 784, 603 } },
    { 472815, 2, { 711, 665 } },
    { 472824, 2, { 792, 597 } },
    { 472860, 2, { 710, 666 } },
    { 472884, 2, { 753, 628 } },
    { 472905, 2, { 837, 565 } },
    { 472914, 2, { 774, 611 } },
    { 472932, 2, { 783, 604 } },
    { 472976, 2, { 721, 656 } },
    { 473040, 2, { 720, 657 } },
    { 473055, 2, { 705, 671 } },
    { 473060, 2, { 763, 620 } },
    { 473110, 2, { 782, 605 } },
    { 473121, 2, { 729, 649 } },
    { 473144, 2, { 833, 568 } },
    { 473200, 2, { 700, 676 } },
    { 473220, 2, { 717, 660 } },
    { 473304, 2, { 888, 533 } },
    { 473340, 2, { 690, 686 } },
    { 473355, 2, { 785, 603 } },
    { 473368, 2, { 749, 632 } },
    { 473400, 2, { 789, 600 } },
    { 473445, 2, { 835, 567 } },
    { 473472, 2, { 822, 576 } },
    { 473473, 2, { 847, 559 } },
    { 473480, 2, { 712, 665 } },
    { 473484, 2, { 748, 633 } },
    { 473525, 2, { 775, 611 } },
    { 473600, 2, { 740, 640 } },
    { 473616, 2, { 759, 624 } },
    { 473652, 2, { 708, 669 } },
    { 473688, 2, { 731, 648 } },
    { 473690, 2, { 707, 670 } },
    { 473697, 2, { 721, 657 } },
    { 473712, 2, { 834, 568 } },
    { 473715, 2, { 783, 605 } },
    { 473760, 2, { 705, 672 } },
    { 473800, 2, { 824, 575 } },
    { 473820, 2, { 745, 636 } },
    { 473823, 2, { 763, 621 } },
    { 473824, 2, { 871, 544 } },
    { 473860, 2, { 817, 580 } },
    { 473928, 2, { 728, 651 } },
    { 473960, 2, { 697, 680 } },
    { 473976, 2, { 696, 681 } },
    { 474000, 2, { 750, 632 } },
    { 474012, 2, { 693, 684 } },
    { 474032, 2, { 689, 688 } },
    { 474045, 2, { 715, 663 } },
    { 474096, 2, { 714, 664 } },
    { 474145, 2, { 713, 665 } },
    { 474150, 2, { 725, 654 } },
    { 474192, 2, { 712, 666 } },
    { 474240, 2, { 741, 640 } },
    { 474266, 2, { 754, 629 } },
    { 474288, 2, { 723, 656 } },
    { 474300, 2, { 765, 620 } },
    { 474330, 2, { 815, 582 } },
    { 474345, 2, { 747, 635 } },
    { 474360, 2, { 708, 670 } },
    { 474375, 2, { 759, 625 } },
    { 474411, 2, { 779, 609 } },
    { 474444, 2, { 764, 621 } },
    { 474516, 2, { 807, 588 } },
    { 474525, 2, { 703, 675 } },
    { 474579, 2, { 729, 651 } },
    { 474606, 2, { 799, 594 } },
    { 474624, 2, { 768, 618 } },
    { 474628, 2, { 737, 644 } },
    { 474672, 2, { 696, 682 } },
    { 474705, 2, { 693, 685 } },
    { 474708, 2, { 716, 663 } },
    { 474720, 2, { 690, 688 } },
    { 474747, 2, { 777, 611 } },
    { 474760, 2, { 715, 664 } },
    { 474780, 2, { 772, 615 } },
    { 474792, 2, { 813, 584 } },
    { 474810, 2, { 714, 665 } },
    { 474848, 2, { 781, 608 } },
    { 474880, 2, { 742, 640 } },
    { 474885, 2, { 865, 549 } },
    { 474903, 2, { 891, 533 } },
    { 474936, 2, { 771, 616 } },
    { 474948, 2, { 711, 668 } },
    { 475000, 2, { 760, 625 } },
    { 475020, 2, { 754, 630 } },
    { 475068, 2, { 708, 671 } },
    { 475092, 2, { 747, 636 } },
    { 475104, 2, { 707, 672 } },
    { 475150, 2, { 731, 650 } },
    { 475164, 2, { 788, 603 } },
    { 475200, 2, { 704, 675 } },
    { 475228, 2, { 703, 676 } },
    { 475300, 2, { 700, 679 } },
    { 475308, 2, { 729, 652 } },
    { 475320, 2, { 699, 680 } },
    { 475332, 2, { 831, 572 } },
    { 475354, 2, { 697, 682 } },
    { 475365, 2, { 737, 645 } },
    { 475376, 2, { 803, 592 } },
    { 475380, 2, { 695, 684 } },
    { 475404, 2, { 692, 687 } },
    { 475405, 2, { 799, 595 } },
    { 475410, 2, { 690, 689 } },
    { 475416, 2, { 744, 639 } },
    { 475452, 2, { 843, 564 } },
    { 475488, 2, { 762, 624 } },
    { 475530, 2, { 726, 655 } },
    { 475540, 2, { 767, 620 } },
    { 475566, 2, { 871, 546 } },
    { 475600, 2, { 725, 656 } },
    { 475629, 2, { 781, 609 } },
    { 475640, 2, { 920, 517 } },
    { 475650, 2, { 755, 630 } },
    { 475668, 2, { 724, 657 } },
    { 475695, 2, { 961, 495 } },
    { 475710, 2, { 785, 606 } },
    { 475776, 2, { 708, 672 } },
    { 475785, 2, { 873, 545 } },
    { 475800, 2, { 732, 650 } },
    { 475839, 2, { 747, 637 } },
    { 475860, 2, { 721, 660 } },
    { 475875, 2, { 705, 675 } },
    { 475881, 2, { 731, 651 } },
    { 475896, 2, { 753, 632 } },
    { 475904, 2, { 704, 676 } },
    { 475950, 2, { 835, 570 } },
    { 475968, 2, { 804, 592 } },
    { 476010, 2, { 738, 645 } },
    { 476016, 2, { 752, 633 } },
    { 476055, 2, { 745, 639 } },
    { 476088, 2, { 717, 664 } },
    { 476112, 2, { 728, 654 } },
    { 476160, 2, { 744, 640 } },
    { 476190, 2, { 715, 666 } },
    { 476238, 2, { 714, 667 } },
    { 476250, 2, { 750, 635 } },
    { 476256, 2, { 726, 656 } },
    { 476280, 2, { 735, 648 } },
    { 476307, 2, { 767, 621 } },
    { 476325, 2, { 725, 657 } },
    { 476328, 2, { 712, 669 } },
    { 476420, 2, { 820, 581 } },
    { 476425, 2, { 1003, 475 } },
    { 476476, 2, { 748, 637 } },
    { 476504, 2, { 889, 536 } },
    { 476520, 2, { 722, 660 } },
    { 476532, 2, { 732, 651 } },
    { 476556, 2, { 789, 604 } },
    { 476580, 2, { 705, 676 } },
    { 476595, 2, { 765, 623 } },
    { 476652, 2, { 759, 628 } },
    { 476658, 2, { 702, 679 } },
    { 476685, 2, { 891, 535 } },
    { 476700, 2, { 700, 681 } },
    { 476748, 2, { 697, 684 } },
    { 476760, 2, { 696, 685 } },
    { 476775, 2, { 815, 585 } },
    { 476784, 2, { 693, 688 } },
    { 476800, 2, { 745, 640 } },
    { 476840, 2, { 728, 655 } },
    { 476850, 2, { 825, 578 } },
    { 476875, 2, { 763, 625 } },
    { 476905, 2, { 715, 667 } },
    { 476928, 2, { 736, 648 } },
    { 476973, 2, { 791, 603 } },
    { 477015, 2, { 735, 649 } },
    { 477050, 2, { 725, 658 } },
    { 477090, 2, { 810, 589 } },
    { 477120, 2, { 710, 672 } },
    { 477160, 2, { 755, 632 } },
    { 477180, 2, { 723, 660 } },
    { 477204, 2, { 741, 644 } },
    { 477225, 2, { 707, 675 } },
    { 477240, 2, { 776, 615 } },
    { 477300, 2, { 740, 645 } },
    { 477312, 2, { 704, 678 } },
    { 477360, 2, { 702, 680 } },
    { 477386, 2, { 793, 602 } },
    { 477396, 2, { 801, 596 } },
    { 477400, 2, { 700, 682 } },
    { 477411, 2, { 759, 629 } },
    { 477456, 2, { 696, 686 } },
    { 477477, 2, { 693, 689 } },
    { 477495, 2, { 729, 655 } },
    { 477520, 2, { 752, 635 } },
    { 477555, 2, { 1027, 465 } },
    { 477576, 2, { 737, 648 } },
    { 477603, 2, { 931, 513 } },
    { 477630, 2, { 783, 610 } },
    { 477648, 2, { 744, 642 } },
    { 477664, 2, { 736, 649 } },
    { 477717, 2, { 867, 551 } },
    { 477744, 2, { 807, 592 } },
    { 477785, 2, { 803, 595 } },
    { 477792, 2, { 711, 672 } },
    { 477888, 2, { 786, 608 } },
    { 477900, 2, { 708, 675 } },
    { 477972, 2, { 748, 639 } },
    { 478016, 2, { 704, 679 } },
    { 478020, 2, { 771, 620 } },
    { 478040, 2, { 703, 680 } },
    { 478044, 2, { 813, 588 } },
    { 478060, 2, { 820, 583 } },
    { 478114, 2, { 923, 518 } },
    { 478116, 2, { 699, 684 } },
    { 478125, 2, { 765, 625 } },
    { 478142, 2, { 697, 686 } },
    { 478152, 2, { 696, 687 } },
    { 478160, 2, { 695, 688 } },
    { 478224, 2, { 729, 656 } },
    { 478225, 2, { 925, 517 } },
    { 478240, 2, { 784, 610 } },
    { 478268, 2, { 812, 589 } },
    { 478272, 2, { 752, 636 } },
    { 478290, 2, { 745, 642 } },
    { 478296, 2, { 728, 657 } },
    { 478325, 2, { 1007, 475 } },
    { 478400, 2, { 736, 650 } },
    { 478413, 2, { 783, 611 } },
    { 478500, 2, { 725, 660 } },
    { 478548, 2, { 756, 633 } },
    { 478584, 2, { 782, 612 } },
    { 478590, 2, { 742, 645 } },
    { 478611, 2, { 749, 639 } },
    { 478632, 2, { 777, 616 } },
    { 478656, 2, { 831, 576 } },
    { 478686, 2, { 722, 663 } },
    { 478695, 2, { 705, 679 } },
    { 478720, 2, { 704, 680 } },
    { 478737, 2, { 1043, 459 } },
    { 478744, 2, { 721, 664 } },
    { 478764, 2, { 702, 682 } },
    { 478800, 2, { 700, 684 } },
    { 478824, 2, { 843, 568 } },
    { 478880, 2, { 730, 656 } },
    { 478908, 2, { 753, 636 } },
    { 478950, 2, { 775, 618 } },
    { 478956, 2, { 717, 668 } },
    { 478962, 2, { 738, 649 } },
    { 479004, 2, { 716, 669 } },
    { 479028, 2, { 764, 627 } },
    { 479094, 2, { 714, 671 } },
    { 479120, 2, { 848, 565 } },
    { 479136, 2, { 713, 672 } },
    { 479196, 2, { 783, 612 } },
    { 479220, 2, { 735, 652 } },
    { 479232, 2, { 768, 624 } },
    { 479250, 2, { 710, 675 } },
    { 479325, 2, { 825, 581 } },
    { 479360, 2, { 749, 640 } },
    { 479370, 2, { 841, 570 } },
    { 479375, 2, { 767, 625 } },
    { 479400, 2, { 705, 680 } },
    { 479412, 2, { 772, 621 } },
    { 479424, 2, { 704, 681 } },
    { 479446, 2, { 703, 682 } },
    { 479460, 2, { 732, 655 } },
    { 479520, 2, { 720, 666 } },
    { 479544, 2, { 696, 689 } },
    { 479550, 2, { 695, 690 } },
    { 479556, 2, { 693, 692 } },
    { 479568, 2, { 776, 618 } },
    { 479570, 2, { 806, 595 } },
    { 479622, 2, { 858, 559 } },
    { 479655, 2, { 765, 627 } },
    { 479682, 2, { 729, 658 } },
    { 479688, 2, { 759, 632 } },
    { 479700, 2, { 738, 650 } },
    { 479710, 2, { 770, 623 } },
    { 479712, 2, { 789, 608 } },
    { 479787, 2, { 737, 651 } },
    { 479808, 2, { 714, 672 } },
    { 479864, 2, { 779, 616 } },
    { 479880, 2, { 744, 645 } },
    { 479892, 2, { 788, 609 } },
    { 479952, 2, { 792, 606 } },
    { 479988, 2, { 796, 603 } },
    { 480000, 2, { 750, 640 } },
    { 480012, 2, { 724, 663 } },
    { 480048, 2, { 822, 584 } },
    { 480060, 2, { 756, 635 } },
    { 480072, 2, { 723, 664 } },
    { 480095, 2, { 1015, 473 } },
    { 480128, 2, { 704, 682 } },
    { 480180, 2, { 755, 636 } },
    { 480186, 2, { 721, 666 } },
    { 480192, 2, { 732, 656 } },
    { 480200, 2, { 700, 686 } },
    { 480240, 2, { 696, 690 } },
    { 480260, 2, { 740, 649 } },
    { 480298, 2, { 754, 637 } },
    { 480315, 2, { 781, 615 } },
    { 480375, 2, { 875, 549 } },
    { 480384, 2, { 834, 576 } },
    { 480420, 2, { 765, 628 } },
    { 480480, 2, { 715, 672 } },
    { 480491, 2, { 1331, 361 } },
    { 480528, 2, { 752, 639 } },
    { 480600, 2, { 712, 675 } },
    { 480636, 2, { 711, 676 } },
    { 480725, 2, { 1025, 469 } },
    { 480732, 2, { 708, 679 } },
    { 480760, 2, { 707, 680 } },
    { 480816, 2, { 742, 648 } },
    { 480852, 2, { 703, 684 } },
    { 480870, 2, { 702, 685 } },
    { 480896, 2, { 832, 578 } },
    { 480900, 2, { 700, 687 } },
    { 480912, 2, { 699, 688 } },
    { 480924, 2, { 732, 657 } },
    { 480928, 2, { 791, 608 } },
    { 480930, 2, { 697, 690 } },
    { 480972, 2, { 807, 596 } },
    { 481068, 2, { 747, 644 } },
    { 481080, 2, { 760, 633 } },
    { 481096, 2, { 781, 616 } },
    { 481104, 2, { 771, 624 } },
    { 481140, 2, { 729, 660 } },
    { 481185, 2, { 765, 629 } },
    { 481250, 2, { 770, 625 } },
    { 481275, 2, { 713, 675 } },
    { 481296, 2, { 813, 592 } },
    { 481299, 2, { 861, 559 } },
    { 481327, 2, { 893, 539 } },
    { 481338, 2, { 726, 663 } },
    { 481344, 2, { 736, 654 } },
    { 481400, 2, { 725, 664 } },
    { 481481, 2, { 1001, 481 } },
    { 481536, 2, { 704, 684 } },
    { 481545, 2, { 783, 615 } },
    { 481558, 2, { 742, 649 } },
    { 481572, 2, { 702, 686 } },
    { 481574, 2, { 722, 667 } },
    { 481584, 2, { 762, 632 } },
    { 481635, 2, { 695, 693 } },
    { 481650, 2, { 741, 650 } },
    { 481680, 2, { 720, 669 } },
    { 481740, 2, { 740, 651 } },
    { 481800, 2, { 730, 660 } },
    { 481824, 2, { 717, 672 } },
    { 481896, 2, { 776, 621 } },
    { 481920, 2, { 753, 640 } },
    { 481950, 2, { 714, 675 } },
    { 481980, 2, { 831, 580 } },
    { 481988, 2, { 713, 676 } },
    { 482064, 2, { 726, 664 } },
    { 482080, 2, { 736, 655 } },
    { 482090, 2, { 710, 679 } },
    { 482144, 2, { 793, 608 } },
    { 482148, 2, { 708, 681 } },
    { 482160, 2, { 735, 656 } },
    { 482196, 2, { 843, 572 } },
    { 482202, 2, { 774, 623 } },
    { 482216, 2, { 763, 632 } },
    { 482220, 2, { 705, 684 } },
    { 482232, 2, { 849, 568 } },
    { 482240, 2, { 704, 685 } },
    { 482258, 2, { 703, 686 } },
    { 482295, 2, { 869, 555 } },
    { 482300, 2, { 700, 689 } },
    { 482328, 2, { 696, 693 } },
    { 482400, 2, { 720, 670 } },
    { 482445, 2, { 755, 639 } },
    { 482460, 2, { 731, 660 } },
    { 482510, 2, { 791, 610 } },
    { 482517, 2, { 777, 621 } },
    { 482560, 2, { 754, 640 } },
    { 482600, 2, { 760, 635 } },
    { 482625, 2, { 715, 675 } },
    { 482670, 2, { 865, 558 } },
    { 482724, 2, { 759, 636 } },
    { 482736, 2, { 712, 678 } },
    { 482760, 2, { 745, 648 } },
    { 482769, 2, { 711, 679 } },
    { 482784, 2, { 752, 642 } },
    { 482790, 2, { 726, 665 } },
    { 482825, 2, { 775, 623 } },
    { 482850, 2, { 725, 666 } },
    { 482868, 2, { 789, 612 } },
    { 482885, 2, { 1105, 437 } },
    { 482937, 2, { 793, 609 } },
    { 482944, 2, { 704, 686 } },
    { 482964, 2, { 723, 668 } },
    { 482976, 2, { 702, 688 } },
    { 482980, 2, { 779, 620 } },
    { 483021, 2, { 697, 693 } },
    { 483070, 2, { 721, 670 } },
    { 483072, 2, { 768, 629 } },
    { 483075, 2, { 855, 565 } },
    { 483084, 2, { 756, 639 } },
    { 483105, 2, { 749, 645 } },
    { 483120, 2, { 720, 671 } },
    { 483132, 2, { 741, 652 } },
    { 483200, 2, { 755, 640 } },
    { 483208, 2, { 748, 646 } },
    { 483210, 2, { 767, 630 } },
    { 483300, 2, { 716, 675 } },
    { 483327, 2, { 729, 663 } },
    { 483390, 2, { 738, 655 } },
    { 483395, 2, { 799, 605 } },
    { 483405, 2, { 871, 555 } },
    { 483406, 2, { 803, 602 } },
    { 483448, 2, { 712, 679 } },
    { 483472, 2, { 737, 656 } },
    { 483480, 2, { 711, 680 } },
    { 483483, 2, { 759, 637 } },
    { 483552, 2, { 736, 657 } },
    { 483588, 2, { 707, 684 } },
    { 483600, 2, { 744, 650 } },
    { 483612, 2, { 764, 633 } },
    { 483616, 2, { 889, 544 } },
    { 483630, 2, { 705, 686 } },
    { 483640, 2, { 856, 565 } },
    { 483648, 2, { 704, 687 } },
    { 483678, 2, { 702, 689 } },
    { 483708, 2, { 699, 692 } },
    { 483720, 2, { 696, 695 } },
    { 483759, 2, { 779, 621 } },
    { 483804, 2, { 801, 604 } },
    { 483875, 2, { 875, 553 } },
    { 483912, 2, { 792, 611 } },
    { 484000, 2, { 800, 605 } },
    { 484044, 2, { 772, 627 } },
    { 484056, 2, { 729, 664 } },
    { 484075, 2, { 1139, 425 } },
    { 484110, 2, { 815, 594 } },
    { 484120, 2, { 728, 665 } },
    { 484128, 2, { 738, 656 } },
    { 484176, 2, { 786, 616 } },
    { 484188, 2, { 771, 628 } },
    { 484200, 2, { 807, 600 } },
    { 484218, 2, { 854, 567 } },
    { 484242, 2, { 726, 667 } },
    { 484288, 2, { 736, 658 } },
    { 484330, 2, { 770, 629 } },
    { 484344, 2, { 744, 651 } },
    { 484356, 2, { 724, 669 } },
    { 484380, 2, { 702, 690 } },
    { 484428, 2, { 876, 553 } },
    { 484449, 2, { 1003, 483 } },
    { 484500, 2, { 750, 646 } },
    { 484512, 2, { 721, 672 } },
    { 484548, 2, { 813, 596 } },
    { 484561, 2, { 899, 539 } },
    { 484575, 2, { 923, 525 } },
    { 484605, 2, { 801, 605 } },
    { 484620, 2, { 788, 615 } },
    { 484653, 2, { 731, 663 } },
    { 484692, 2, { 717, 676 } },
    { 484704, 2, { 748, 648 } },
    { 484710, 2, { 755, 642 } },
    { 484764, 2, { 796, 609 } },
    { 484770, 2, { 715, 678 } },
    { 484785, 2, { 729, 665 } },
    { 484800, 2, { 800, 606 } },
    { 484825, 2, { 1025, 473 } },
    { 484840, 2, { 713, 680 } },
    { 484848, 2, { 728, 666 } },
    { 484872, 2, { 712, 681 } },
    { 484880, 2, { 760, 638 } },
    { 484932, 2, { 753, 644 } },
    { 484946, 2, { 737, 658 } },
    { 484980, 2, { 708, 685 } },
    { 485000, 2, { 776, 625 } },
    { 485040, 2, { 705, 688 } },
    { 485056, 2, { 704, 689 } },
    { 485070, 2, { 703, 690 } },
    { 485100, 2, { 700, 693 } },
    { 485112, 2, { 697, 696 } },
    { 485130, 2, { 785, 618 } },
    { 485163, 2, { 1057, 459 } },
    { 485184, 2, { 722, 672 } },
    { 485275, 2, { 1175, 413 } },
    { 485304, 2, { 831, 584 } },
    { 485316, 2, { 732, 663 } },
    { 485352, 2, { 749, 648 } },
    { 485415, 2, { 805, 603 } },
    { 485460, 2, { 783, 620 } },
    { 485520, 2, { 714, 680 } },
    { 485568, 2, { 843, 576 } },
    { 485576, 2, { 728, 667 } },
    { 485595, 2, { 891, 545 } },
    { 485604, 2, { 738, 658 } },
    { 485625, 2, { 777, 625 } },
    { 485628, 2, { 849, 572 } },
    { 485639, 2, { 833, 583 } },
    { 485640, 2, { 710, 684 } },
    { 485745, 2, { 705, 689 } },
    { 485760, 2, { 704, 690 } },
    { 485775, 2, { 765, 635 } },
    { 485856, 2, { 723, 672 } },
    { 485940, 2, { 780, 623 } },
    { 485970, 2, { 835, 582 } },
    { 486000, 2, { 720, 675 } },
    { 486024, 2, { 789, 616 } },
    { 486096, 2, { 741, 656 } },
    { 486098, 2, { 841, 578 } },
    { 486115, 2, { 731, 665 } },
    { 486144, 2, { 768, 633 } },
    { 486180, 2, { 730, 666 } },
    { 486200, 2, { 715, 680 } },
    { 486243, 2, { 729, 667 } },
    { 486315, 2, { 909, 535 } },
    { 486324, 2, { 711, 684 } },
    { 486381, 2, { 1007, 483 } },
    { 486396, 2, { 708, 687 } },
    { 486400, 2, { 760, 640 } },
    { 486416, 2, { 707, 688 } },
    { 486465, 2, { 791, 615 } },
    { 486472, 2, { 833, 584 } },
    { 486475, 2, { 725, 671 } },
    { 486504, 2, { 699, 696 } },
    { 486540, 2, { 765, 636 } },
    { 486552, 2, { 776, 627 } },
    { 486576, 2, { 744, 654 } },
    { 486591, 2, { 799, 609 } },
    { 486624, 2, { 822, 592 } },
    { 486675, 2, { 721, 675 } },
    { 486720, 2, { 720, 676 } },
    { 486750, 2, { 750, 649 } },
    { 486752, 2, { 742, 656 } },
    { 486780, 2, { 732, 665 } },
    { 486846, 2, { 731, 666 } },
    { 486850, 2, { 749, 650 } },
    { 486864, 2, { 756, 644 } },
    { 486875, 2, { 779, 625 } },
    { 486920, 2, { 740, 658 } },
    { 486927, 2, { 917, 531 } },
    { 486948, 2, { 714, 682 } },
    { 486972, 2, { 729, 668 } },
    { 487032, 2, { 728, 669 } },
    { 487035, 2, { 711, 685 } },
    { 487044, 2, { 747, 652 } },
    { 487056, 2, { 834, 584 } },
    { 487104, 2, { 708, 688 } },
    { 487179, 2, { 703, 693 } },
    { 487200, 2, { 700, 696 } },
    { 487227, 2, { 961, 507 } },
    { 487230, 2, { 745, 654 } },
    { 487256, 2, { 791, 616 } },
    { 487272, 2, { 771, 632 } },
    { 487305, 2, { 735, 663 } },
    { 487320, 2, { 744, 655 } },
    { 487344, 2, { 781, 624 } },
    { 487350, 2, { 722, 675 } },
    { 487428, 2, { 807, 604 } },
    { 487475, 2, { 775, 629 } },
    { 487485, 2, { 785, 621 } },
    { 487557, 2, { 763, 639 } },
    { 487560, 2, { 717, 680 } },
    { 487596, 2, { 716, 681 } },
    { 487600, 2, { 848, 575 } },
    { 487620, 2, { 756, 645 } },
    { 487680, 2, { 762, 640 } },
    { 487692, 2, { 713, 684 } },
    { 487695, 2, { 793, 615 } },
    { 487720, 2, { 712, 685 } },
    { 487800, 2, { 813, 600 } },
    { 487809, 2, { 783, 623 } },
    { 487825, 2, { 1027, 475 } },
    { 487830, 2, { 707, 690 } },
    { 487860, 2, { 705, 692 } },
    { 487872, 2, { 704, 693 } },
    { 487890, 2, { 702, 695 } },
    { 487900, 2, { 700, 697 } },
    { 487920, 2, { 760, 642 } },
    { 487944, 2, { 753, 648 } },
    { 487956, 2, { 777, 628 } },
    { 487968, 2, { 736, 663 } },
    { 487971, 2, { 837, 583 } },
    { 488000, 2, { 800, 610 } },
    { 488040, 2, { 735, 664 } },
    { 488048, 2, { 752, 649 } },
    { 488061, 2, { 889, 549 } },
    { 488070, 2, { 765, 638 } },
    { 488072, 2, { 722, 676 } },
    { 488124, 2, { 819, 596 } },
    { 488125, 2, { 781, 625 } },
    { 488160, 2, { 720, 678 } },
    { 488187, 2, { 861, 567 } },
    { 488196, 2, { 764, 639 } },
    { 488215, 2, { 1015, 481 } },
    { 488224, 2, { 803, 608 } },
    { 488250, 2, { 750, 651 } },
    { 488320, 2, { 763, 640 } },
    { 488410, 2, { 845, 578 } },
    { 488430, 2, { 729, 670 } },
    { 488433, 2, { 779, 627 } },
    { 488448, 2, { 768, 636 } },
    { 488475, 2, { 835, 585 } },
    { 488480, 2, { 710, 688 } },
    { 488488, 2, { 728, 671 } },
    { 488566, 2, { 817, 598 } },
    { 488579, 2, { 767, 637 } },
    { 488592, 2, { 702, 696 } },
    { 488628, 2, { 831, 588 } },
    { 488670, 2, { 895, 546 } },
    { 488676, 2, { 772, 633 } },
    { 488700, 2, { 724, 675 } },
    { 488720, 2, { 745, 656 } },
    { 488748, 2, { 723, 676 } },
    { 488750, 2, { 782, 625 } },
    { 488796, 2, { 759, 644 } },
    { 488800, 2, { 752, 650 } },
    { 488808, 2, { 744, 657 } },
    { 488832, 2, { 804, 608 } },
    { 488840, 2, { 808, 605 } },
    { 488880, 2, { 720, 679 } },
    { 488940, 2, { 843, 580 } },
    { 488988, 2, { 799, 612 } },
    { 488992, 2, { 826, 592 } },
    { 489024, 2, { 849, 576 } },
    { 489027, 2, { 803, 609 } },
    { 489056, 2, { 899, 544 } },
    { 489060, 2, { 715, 684 } },
    { 489090, 2, { 714, 685 } },
    { 489118, 2, { 713, 686 } },
    { 489125, 2, { 875, 559 } },
    { 489144, 2, { 712, 687 } },
    { 489159, 2, { 729, 671 } },
    { 489168, 2, { 711, 688 } },
    { 489180, 2, { 789, 620 } },
    { 489216, 2, { 728, 672 } },
    { 489240, 2, { 755, 648 } },
    { 489280, 2, { 704, 695 } },
    { 489285, 2, { 747, 655 } },
    { 489288, 2, { 703, 696 } },
    { 489294, 2, { 702, 697 } },
    { 489300, 2, { 700, 699 } },
    { 489325, 2, { 851, 575 } },
    { 489335, 2, { 1085, 451 } },
    { 489348, 2, { 788, 621 } },
    { 489375, 2, { 725, 675 } },
    { 489405, 2, { 885, 553 } },
    { 489440, 2, { 736, 665 } },
    { 489456, 2, { 792, 618 } },
    { 489465, 2, { 745, 657 } },
    { 489510, 2, { 735, 666 } },
    { 489540, 2, { 796, 615 } },
    { 489552, 2, { 744, 658 } },
    { 489566, 2, { 847, 578 } },
    { 489600, 2, { 720, 680 } },
    { 489636, 2, { 804, 609 } },
    { 489708, 2, { 732, 669 } },
    { 489720, 2, { 742, 660 } },
    { 489762, 2, { 819, 598 } },
    { 489800, 2, { 775, 632 } },
    { 489888, 2, { 729, 672 } },
    { 489951, 2, { 707, 693 } },
    { 489984, 2, { 704, 696 } },
    { 490032, 2, { 738, 664 } },
    { 490048, 2, { 806, 608 } },
    { 490050, 2, { 726, 675 } },
    { 490105, 2, { 737, 665 } },
    { 490116, 2, { 869, 564 } },
    { 490176, 2, { 736, 666 } },
    { 490200, 2, { 760, 645 } },
    { 490212, 2, { 801, 612 } },
    { 490245, 2, { 735, 667 } },
    { 490280, 2, { 721, 680 } },
    { 490320, 2, { 720, 681 } },
    { 490356, 2, { 771, 636 } },
    { 490420, 2, { 791, 620 } },
    { 490428, 2, { 717, 684 } },
    { 490440, 2, { 732, 670 } },
    { 490455, 2, { 865, 567 } },
    { 490464, 2, { 786, 624 } },
    { 490490, 2, { 715, 686 } },
    { 490560, 2, { 730, 672 } },
    { 490620, 2, { 740, 663 } },
    { 490637, 2, { 833, 589 } },
    { 490644, 2, { 708, 693 } },
    { 490656, 2, { 807, 608 } },
    { 490680, 2, { 705, 696 } },
    { 490688, 2, { 704, 697 } },
    { 490752, 2, { 768, 639 } },
    { 490770, 2, { 738, 665 } },
    { 490776, 2, { 726, 676 } },
    { 490842, 2, { 737, 666 } },
    { 490875, 2, { 825, 595 } },
    { 490880, 2, { 767, 640 } },
    { 490912, 2, { 736, 667 } },
    { 490956, 2, { 753, 652 } },
    { 490960, 2, { 722, 680 } },
    { 490980, 2, { 735, 668 } },
    { 491036, 2, { 923, 532 } },
    { 491040, 2, { 720, 682 } },
    { 491052, 2, { 813, 604 } },
    { 491064, 2, { 777, 632 } },
    { 491150, 2, { 893, 550 } },
    { 491208, 2, { 776, 633 } },
    { 491211, 2, { 791, 621 } },
    { 491232, 2, { 714, 688 } },
    { 491250, 2, { 750, 655 } },
    { 491260, 2, { 770, 638 } },
    { 491280, 2, { 712, 690 } },
    { 491344, 2, { 749, 656 } },
    { 491355, 2, { 895, 549 } },
    { 491400, 2, { 702, 700 } },
    { 491436, 2, { 748, 657 } },
    { 491445, 2, { 815, 603 } },
    { 491512, 2, { 917, 536 } },
    { 491550, 2, { 725, 678 } },
    { 491568, 2, { 784, 627 } },
    { 491582, 2, { 949, 518 } },
    { 491589, 2, { 867, 567 } },
    { 491625, 2, { 855, 575 } },
    { 491640, 2, { 723, 680 } },
    { 491660, 2, { 793, 620 } },
    { 491700, 2, { 745, 660 } },
    { 491724, 2, { 783, 628 } },
    { 491790, 2, { 845, 582 } },
    { 491808, 2, { 752, 654 } },
    { 491832, 2, { 759, 648 } },
    { 491855, 2, { 805, 611 } },
    { 491892, 2, { 716, 687 } },
    { 491904, 2, { 732, 672 } },
    { 491920, 2, { 715, 688 } },
    { 491946, 2, { 714, 689 } },
    { 491952, 2, { 831, 592 } },
    { 491967, 2, { 959, 513 } },
    { 491970, 2, { 713, 690 } },
    { 491985, 2, { 841, 585 } },
    { 492000, 2, { 750, 656 } },
    { 492012, 2, { 711, 692 } },
    { 492024, 2, { 741, 664 } },
    { 492032, 2, { 961, 512 } },
    { 492060, 2, { 708, 695 } },
    { 492063, 2, { 1023, 481 } },
    { 492072, 2, { 707, 696 } },
    { 492075, 2, { 729, 675 } },
    { 492093, 2, { 749, 657 } },
    { 492096, 2, { 704, 699 } },
    { 492100, 2, { 703, 700 } },
    { 492135, 2, { 763, 645 } },
    { 492156, 2, { 756, 651 } },
    { 492170, 2, { 790, 623 } },
    { 492200, 2, { 856, 575 } },
    { 492275, 2, { 725, 679 } },
    { 492312, 2, { 843, 584 } },
    { 492336, 2, { 789, 624 } },
    { 492384, 2, { 736, 669 } },
    { 492420, 2, { 849, 580 } },
    { 492453, 2, { 793, 621 } },
    { 492480, 2, { 720, 684 } },
    { 492499, 2, { 931, 529 } },
    { 492507, 2, { 783, 629 } },
    { 492560, 2, { 752, 655 } },
    { 492575, 2, { 1037, 475 } },
    { 492635, 2, { 715, 689 } },
    { 492680, 2, { 872, 565 } },
    { 492745, 2, { 935, 527 } },
    { 492750, 2, { 730, 675 } },
    { 492760, 2, { 776, 635 } },
    { 492780, 2, { 764, 645 } },
    { 492800, 2, { 704, 700 } },
    { 492900, 2, { 775, 636 } },
    { 493000, 2, { 725, 680 } },
    { 493020, 2, { 747, 660 } },
    { 493025, 2, { 925, 533 } },
    { 493038, 2, { 774, 637 } },
    { 493044, 2, { 724, 681 } },
    { 493050, 2, { 865, 570 } },
    { 493056, 2, { 768, 642 } },
    { 493120, 2, { 736, 670 } },
    { 493136, 2, { 784, 629 } },
    { 493164, 2, { 721, 684 } },
    { 493185, 2, { 735, 671 } },
    { 493200, 2, { 720, 685 } },
    { 493218, 2, { 846, 583 } },
    { 493240, 2, { 760, 649 } },
    { 493245, 2, { 873, 565 } },
    { 493272, 2, { 744, 663 } },
    { 493296, 2, { 717, 688 } },
    { 493308, 2, { 772, 639 } },
    { 493350, 2, { 715, 690 } },
    { 493416, 2, { 712, 693 } },
    { 493425, 2, { 731, 675 } },
    { 493440, 2, { 771, 640 } },
    { 493493, 2, { 1001, 493 } },
    { 493500, 2, { 705, 700 } },
    { 493506, 2, { 703, 702 } },
    { 493584, 2, { 728, 678 } },
    { 493640, 2, { 820, 602 } },
    { 493675, 2, { 775, 637 } },
    { 493680, 2, { 726, 680 } },
    { 493695, 2, { 795, 621 } },
    { 493696, 2, { 812, 608 } },
    { 493728, 2, { 834, 592 } },
    { 493740, 2, { 780, 633 } },
    { 493770, 2, { 755, 654 } },
    { 493776, 2, { 762, 648 } },
    { 493830, 2, { 837, 590 } },
    { 493845, 2, { 803, 615 } },
    { 493856, 2, { 736, 671 } },
    { 493884, 2, { 807, 612 } },
    { 493890, 2, { 815, 606 } },
    { 493920, 2, { 720, 686 } },
    { 493948, 2, { 767, 644 } },
    { 493968, 2, { 753, 656 } },
    { 494064, 2, { 752, 657 } },
    { 494076, 2, { 788, 627 } },
    { 494100, 2, { 732, 675 } },
    { 494109, 2, { 713, 693 } },
    { 494130, 2, { 905, 546 } },
    { 494145, 2, { 711, 695 } },
    { 494156, 2, { 731, 676 } },
    { 494160, 2, { 710, 696 } },
    { 494172, 2, { 742, 666 } },
    { 494190, 2, { 765, 646 } },
    { 494208, 2, { 704, 702 } },
    { 494247, 2, { 741, 667 } },
    { 494285, 2, { 817, 605 } },
    { 494304, 2, { 813, 608 } },
    { 494312, 2, { 728, 679 } },
    { 494316, 2, { 796, 621 } },
    { 494325, 2, { 845, 585 } },
    { 494340, 2, { 749, 660 } },
    { 494361, 2, { 931, 531 } },
    { 494375, 2, { 791, 625 } },
    { 494400, 2, { 800, 618 } },
    { 494450, 2, { 725, 682 } },
    { 494460, 2, { 738, 670 } },
    { 494494, 2, { 1001, 494 } },
    { 494505, 2, { 891, 555 } },
    { 494532, 2, { 723, 684 } },
    { 494550, 2, { 785, 630 } },
    { 494615, 2, { 935, 529 } },
    { 494640, 2, { 720, 687 } },
    { 494648, 2, { 803, 616 } },
    { 494676, 2, { 819, 604 } },
    { 494680, 2, { 745, 664 } },
    { 494715, 2, { 767, 645 } },
    { 494760, 2, { 744, 665 } },
    { 494840, 2, { 712, 695 } },
    { 494856, 2, { 711, 696 } },
    { 494868, 2, { 759, 652 } },
    { 494892, 2, { 708, 699 } },
    { 494900, 2, { 707, 700 } },
    { 494910, 2, { 705, 702 } },
    { 494912, 2, { 704, 703 } },
    { 494988, 2, { 741, 668 } },
    { 494991, 2, { 729, 679 } },
    { 495012, 2, { 852, 581 } },
    { 495060, 2, { 740, 669 } },
    { 495180, 2, { 756, 655 } },
    { 495198, 2, { 738, 671 } },
    { 495225, 2, { 775, 639 } },
    { 495264, 2, { 737, 672 } },
    { 495276, 2, { 831, 596 } },
    { 495280, 2, { 755, 656 } },
    { 495285, 2, { 795, 623 } },
    { 495292, 2, { 722, 686 } },
    { 495380, 2, { 799, 620 } },
    { 495405, 2, { 909, 545 } },
    { 495492, 2, { 789, 628 } },
    { 495495, 2, { 715, 693 } },
    { 495504, 2, { 744, 666 } },
    { 495550, 2, { 850, 583 } },
    { 495625, 2, { 793, 625 } },
    { 495670, 2, { 730, 679 } },
    { 495684, 2, { 843, 588 } },
    { 495720, 2, { 729, 680 } },
    { 495768, 2, { 728, 681 } },
    { 495816, 2, { 849, 584 } },
    { 495864, 2, { 776, 639 } },
    { 495900, 2, { 725, 684 } },
    { 495924, 2, { 748, 663 } },
    { 495936, 2, { 738, 672 } },
    { 495945, 2, { 927, 535 } },
    { 495950, 2, { 763, 650 } },
    { 495990, 2, { 835, 594 } },
    { 496000, 2, { 775, 640 } },
    { 496008, 2, { 747, 664 } },
    { 496035, 2, { 755, 657 } },
    { 496048, 2, { 721, 688 } },
    { 496080, 2, { 720, 689 } },
    { 496120, 2, { 785, 632 } },
    { 496125, 2, { 735, 675 } },
    { 496128, 2, { 768, 646 } },
    { 496164, 2, { 717, 692 } },
    { 496170, 2, { 745, 666 } },
    { 496179, 2, { 799, 621 } },
    { 496188, 2, { 716, 693 } },
    { 496223, 2, { 779, 637 } },
    { 496230, 2, { 714, 695 } },
    { 496248, 2, { 713, 696 } },
    { 496272, 2, { 784, 633 } },
    { 496314, 2, { 707, 702 } },
    { 496320, 2, { 705, 704 } },
    { 496392, 2, { 888, 559 } },
    { 496485, 2, { 765, 649 } },
    { 496496, 2, { 728, 682 } },
    { 496524, 2, { 771, 644 } },
    { 496540, 2, { 740, 671 } },
    { 496620, 2, { 801, 620 } },
    { 496692, 2, { 756, 657 } },
    { 496716, 2, { 781, 636 } },
    { 496752, 2, { 786, 632 } },
    { 496755, 2, { 747, 665 } },
    { 496800, 2, { 720, 690 } },
    { 496845, 2, { 905, 549 } },
    { 496860, 2, { 735, 676 } },
    { 496920, 2, { 808, 615 } },
    { 496944, 2, { 714, 696 } },
    { 496980, 2, { 753, 660 } },
    { 497002, 2, { 779, 638 } },
    { 497028, 2, { 732, 679 } },
    { 497040, 2, { 760, 654 } },
    { 497080, 2, { 731, 680 } },
    { 497112, 2, { 807, 616 } },
    { 497178, 2, { 729, 682 } },
    { 497200, 2, { 880, 565 } },
    { 497205, 2, { 783, 635 } },
    { 497250, 2, { 750, 663 } },
    { 497280, 2, { 740, 672 } },
    { 497310, 2, { 726, 685 } },
    { 497336, 2, { 749, 664 } },
    { 497350, 2, { 725, 686 } },
    { 497354, 2, { 814, 611 } },
    { 497364, 2, { 764, 651 } },
    { 497388, 2, { 724, 687 } },
    { 497424, 2, { 723, 688 } },
    { 497448, 2, { 756, 658 } },
    { 497475, 2, { 737, 675 } },
    { 497490, 2, { 721, 690 } },
    { 497497, 2, { 781, 637 } },
    { 497511, 2, { 1043, 477 } },
    { 497550, 2, { 775, 642 } },
    { 497553, 2, { 817, 609 } },
    { 497556, 2, { 813, 612 } },
    { 497640, 2, { 715, 696 } },
    { 497658, 2, { 714, 697 } },
    { 497664, 2, { 768, 648 } },
    { 497688, 2, { 712, 699 } },
    { 497700, 2, { 711, 700 } },
    { 497705, 2, { 845, 589 } },
    { 497728, 2, { 707, 704 } },
    { 497736, 2, { 744, 669 } },
    { 497800, 2, { 760, 655 } },
    { 497835, 2, { 851, 585 } },
    { 497840, 2, { 784, 635 } },
    { 497882, 2, { 742, 671 } },
    { 497904, 2, { 759, 656 } },
    { 497940, 2, { 772, 645 } },
    { 497988, 2, { 783, 636 } },
    { 498000, 2, { 750, 664 } },
    { 498015, 2, { 765, 651 } },
    { 498036, 2, { 726, 686 } },
    { 498069, 2, { 891, 559 } },
    { 498134, 2, { 782, 637 } },
    { 498192, 2, { 776, 642 } },
    { 498225, 2, { 949, 525 } },
    { 498300, 2, { 755, 660 } },
    { 498355, 2, { 715, 697 } },
    { 498420, 2, { 710, 702 } },
    { 498432, 2, { 708, 704 } },
    { 498435, 2, { 707, 705 } },
    { 498480, 2, { 744, 670 } },
    { 498492, 2, { 732, 681 } },
    { 498520, 2, { 824, 605 } },
    { 498542, 2, { 731, 682 } },
    { 498550, 2, { 767, 650 } },
    { 498575, 2, { 925, 539 } },
    { 498576, 2, { 752, 663 } },
    { 498600, 2, { 831, 600 } },
    { 498624, 2, { 742, 672 } },
    { 498636, 2, { 729, 684 } },
    { 498648, 2, { 789, 632 } },
    { 498680, 2, { 728, 685 } },
    { 498750, 2, { 750, 665 } },
    { 498771, 2, { 783, 637 } },
    { 498780, 2, { 765, 652 } },
    { 498800, 2, { 725, 688 } },
    { 498804, 2, { 788, 633 } },
    { 498806, 2, { 869, 574 } },
    { 498834, 2, { 749, 666 } },
    { 498848, 2, { 917, 544 } },
    { 498852, 2, { 837, 596 } },
    { 498883, 2, { 847, 589 } },
    { 498916, 2, { 748, 667 } },
    { 498960, 2, { 720, 693 } },
    { 498996, 2, { 747, 668 } },
    { 499008, 2, { 736, 678 } },
    { 499016, 2, { 931, 536 } },
    { 499032, 2, { 717, 696 } },
    { 499056, 2, { 843, 592 } },
    { 499065, 2, { 735, 679 } },
    { 499092, 2, { 796, 627 } },
    { 499100, 2, { 713, 700 } },
    { 499110, 2, { 762, 655 } },
    { 499140, 2, { 708, 705 } },
    { 499149, 2, { 973, 513 } },
    { 499200, 2, { 768, 650 } },
    { 499212, 2, { 849, 588 } },
    { 499260, 2, { 785, 636 } },
    { 499284, 2, { 804, 621 } },
    { 499317, 2, { 767, 651 } },
    { 499320, 2, { 730, 684 } },
    { 499344, 2, { 808, 618 } },
    { 499365, 2, { 729, 685 } },
    { 499375, 2, { 799, 625 } },
    { 499380, 2, { 812, 615 } },
    { 499410, 2, { 895, 558 } },
    { 499485, 2, { 1005, 497 } },
    { 499488, 2, { 726, 688 } },
    { 499500, 2, { 740, 675 } },
    { 499525, 2, { 725, 689 } },
    { 499590, 2, { 793, 630 } },
    { 499608, 2, { 771, 648 } },
    { 499653, 2, { 721, 693 } },
    { 499675, 2, { 869, 575 } },
    { 499681, 2, { 1547, 323 } },
    { 499730, 2, { 770, 649 } },
    { 499744, 2, { 736, 679 } },
    { 499751, 2, { 1457, 343 } },
    { 499776, 2, { 822, 608 } },
    { 499800, 2, { 714, 700 } },
    { 499824, 2, { 712, 702 } },
    { 499840, 2, { 710, 704 } },
    { 499851, 2, { 891, 561 } },
    { 499872, 2, { 762, 656 } },
    { 499905, 2, { 805, 621 } },
    { 499912, 2, { 791, 632 } },
    { 499928, 2, { 836, 598 } },
    { 499954, 2, { 871, 574 } },
    { 499968, 2, { 744, 672 } },
    { 499992, 2, { 753, 664 } },
    { 500000, 2, { 800, 625 } },
    { 500004, 2, { 731, 684 } },
    { 500080, 2, { 752, 665 } },
    { 500094, 2, { 729, 686 } },
    { 500136, 2, { 728, 687 } },
    { 500175, 2, { 741, 675 } },
    { 500192, 2, { 784, 638 } },
    { 500214, 2, { 726, 689 } },
    { 500250, 2, { 725, 690 } },
    { 500316, 2, { 723, 692 } },
    { 500320, 2, { 848, 590 } },
    { 500340, 2, { 807, 620 } },
    { 500346, 2, { 722, 693 } },
    { 500388, 2, { 777, 644 } },
    { 500395, 2, { 841, 595 } },
    { 500400, 2, { 720, 695 } },
    { 500409, 2, { 819, 611 } },
    { 500412, 2, { 748, 669 } },
    { 500484, 2, { 716, 699 } },
    { 500500, 2, { 715, 700 } },
    { 500520, 2, { 776, 645 } },
    { 500526, 2, { 713, 702 } },
    { 500528, 2, { 763, 656 } },
    { 500544, 2, { 711, 704 } },
    { 500556, 2, { 708, 707 } },
    { 500625, 2, { 801, 625 } },
    { 500640, 2, { 745, 672 } },
    { 500808, 2, { 813, 616 } },
    { 500825, 2, { 871, 575 } },
    { 500832, 2, { 752, 666 } },
    { 500850, 2, { 742, 675 } },
    { 500871, 2, { 1037, 483 } },
    { 500892, 2, { 804, 623 } },
    { 500916, 2, { 741, 676 } },
    { 500973, 2, { 799, 627 } },
    { 500976, 2, { 784, 639 } },
    { 501020, 2, { 820, 611 } },
    { 501072, 2, { 803, 624 } },
    { 501075, 2, { 765, 655 } },
    { 501102, 2, { 738, 679 } },
    { 501160, 2, { 737, 680 } },
    { 501216, 2, { 736, 681 } },
    { 501228, 2, { 714, 702 } },
    { 501270, 2, { 735, 682 } },
    { 501291, 2, { 763, 657 } },
    { 501320, 2, { 755, 664 } },
    { 501336, 2, { 792, 633 } },
    { 501380, 2, { 860, 583 } },
    { 501400, 2, { 872, 575 } },
    { 501410, 2, { 754, 665 } },
    { 501420, 2, { 732, 685 } },
    { 501424, 2, { 814, 616 } },
    { 501466, 2, { 731, 686 } },
    { 501552, 2, { 729, 688 } },
    { 501592, 2, { 728, 689 } },
    { 501615, 2, { 785, 639 } },
    { 501676, 2, { 779, 644 } },
    { 501696, 2, { 804, 624 } },
    { 501725, 2, { 1175, 427 } },
    { 501732, 2, { 724, 693 } },
    { 501735, 2, { 1079, 465 } },
    { 501760, 2, { 784, 640 } },
    { 501768, 2, { 808, 621 } },
    { 501787, 2, { 1331, 377 } },
    { 501795, 2, { 885, 567 } },
    { 501804, 2, { 789, 636 } },
    { 501816, 2, { 721, 696 } },
    { 501830, 2, { 749, 670 } },
    { 501840, 2, { 720, 697 } },
    { 501875, 2, { 803, 625 } },
    { 501900, 2, { 717, 700 } },
    { 501924, 2, { 831, 604 } },
    { 501930, 2, { 715, 702 } },
    { 501942, 2, { 714, 703 } },
    { 501948, 2, { 764, 657 } },
    { 501952, 2, { 713, 704 } },
    { 501960, 2, { 712, 705 } },
    { 501963, 2, { 861, 583 } },
    { 501970, 2, { 710, 707 } },
    { 501975, 2, { 873, 575 } },
    { 501984, 2, { 747, 672 } },
    { 502200, 2, { 744, 675 } },
    { 502208, 2, { 826, 608 } },
    { 502240, 2, { 730, 688 } },
    { 502250, 2, { 875, 574 } },
    { 502272, 2, { 768, 654 } },
    { 502281, 2, { 729, 689 } },
    { 502299, 2, { 833, 603 } },
    { 502320, 2, { 728, 690 } },
    { 502326, 2, { 774, 649 } },
    { 502400, 2, { 785, 640 } },
    { 502425, 2, { 725, 693 } },
    { 502428, 2, { 843, 596 } },
    { 502440, 2, { 790, 636 } },
    { 502460, 2, { 740, 679 } },
    { 502572, 2, { 772, 651 } },
    { 502608, 2, { 849, 592 } },
    { 502645, 2, { 715, 703 } },
    { 502656, 2, { 714, 704 } },
    { 502677, 2, { 711, 707 } },
    { 502680, 2, { 710, 708 } },
    { 502692, 2, { 771, 652 } },
    { 502740, 2, { 735, 684 } },
    { 502758, 2, { 901, 558 } },
    { 502824, 2, { 861, 584 } },
    { 502830, 2, { 755, 666 } },
    { 502860, 2, { 867, 580 } },
    { 502875, 2, { 745, 675 } },
    { 502884, 2, { 732, 687 } },
    { 502964, 2, { 781, 644 } },
    { 502975, 2, { 775, 649 } },
    { 503004, 2, { 753, 668 } },
    { 503010, 2, { 729, 690 } },
    { 503028, 2, { 801, 628 } },
    { 503040, 2, { 768, 655 } },
    { 503088, 2, { 752, 669 } },
    { 503100, 2, { 774, 650 } },
    { 503125, 2, { 805, 625 } },
    { 503152, 2, { 767, 656 } },
    { 503208, 2, { 723, 696 } },
    { 503230, 2, { 790, 637 } },
    { 503250, 2, { 750, 671 } },
    { 503272, 2, { 817, 616 } },
    { 503280, 2, { 720, 699 } },
    { 503328, 2, { 749, 672 } },
    { 503360, 2, { 715, 704 } },
    { 503384, 2, { 712, 707 } },
    { 503388, 2, { 711, 708 } },
    { 503415, 2, { 891, 565 } },
    { 503424, 2, { 736, 684 } },
    { 503430, 2, { 865, 582 } },
    { 503433, 2, { 917, 549 } },
    { 503505, 2, { 835, 603 } },
    { 503532, 2, { 788, 639 } },
    { 503568, 2, { 807, 624 } },
    { 503580, 2, { 763, 660 } },
    { 503595, 2, { 855, 589 } },
    { 503616, 2, { 732, 688 } },
    { 503670, 2, { 815, 618 } },
    { 503745, 2, { 781, 645 } },
    { 503840, 2, { 752, 670 } },
    { 503868, 2, { 796, 633 } },
    { 503880, 2, { 741, 680 } },
    { 503940, 2, { 740, 681 } },
    { 503958, 2, { 923, 546 } },
    { 503970, 2, { 785, 642 } },
    { 503976, 2, { 759, 664 } },
    { 504000, 2, { 720, 700 } },
    { 504060, 2, { 813, 620 } },
    { 504063, 2, { 889, 567 } },
    { 504108, 2, { 737, 684 } },
    { 504160, 2, { 736, 685 } },
    { 504175, 2, { 1075, 469 } },
    { 504189, 2, { 1057, 477 } },
    { 504218, 2, { 902, 559 } },
    { 504252, 2, { 756, 667 } },
    { 504273, 2, { 777, 649 } },
    { 504288, 2, { 816, 618 } },
    { 504336, 2, { 798, 632 } },
    { 504339, 2, { 899, 561 } },
    { 504384, 2, { 852, 592 } },
    { 504390, 2, { 731, 690 } },
    { 504432, 2, { 744, 678 } },
    { 504468, 2, { 729, 692 } },
    { 504504, 2, { 728, 693 } },
    { 504560, 2, { 742, 680 } },
    { 504570, 2, { 726, 695 } },
    { 504576, 2, { 768, 657 } },
    { 504592, 2, { 752, 671 } },
    { 504600, 2, { 725, 696 } },
    { 504686, 2, { 767, 658 } },
    { 504700, 2, { 721, 700 } },
    { 504735, 2, { 759, 665 } },
    { 504768, 2, { 717, 704 } },
    { 504780, 2, { 716, 705 } },
    { 504868, 2, { 949, 532 } },
    { 504896, 2, { 736, 686 } },
    { 504900, 2, { 748, 675 } },
    { 504952, 2, { 889, 568 } },
    { 504960, 2, { 789, 640 } },
    { 504972, 2, { 747, 676 } },
    { 504990, 2, { 905, 558 } },
    { 505000, 2, { 808, 625 } },
    { 505035, 2, { 783, 645 } },
    { 505050, 2, { 777, 650 } },
    { 505110, 2, { 745, 678 } },
    { 505120, 2, { 770, 656 } },
    { 505141, 2, { 793, 637 } },
    { 505176, 2, { 744, 679 } },
    { 505197, 2, { 729, 693 } },
    { 505215, 2, { 927, 545 } },
    { 505248, 2, { 831, 608 } },
    { 505296, 2, { 726, 696 } },
    { 505325, 2, { 725, 697 } },
    { 505400, 2, { 722, 700 } },
    { 505440, 2, { 720, 702 } },
    { 505449, 2, { 791, 639 } },
    { 505530, 2, { 738, 685 } },
    { 505548, 2, { 837, 604 } },
    { 505568, 2, { 854, 592 } },
    { 505575, 2, { 749, 675 } },
    { 505582, 2, { 737, 686 } },
    { 505600, 2, { 790, 640 } },
    { 505620, 2, { 795, 636 } },
    { 505632, 2, { 736, 687 } },
    { 505680, 2, { 735, 688 } },
    { 505764, 2, { 756, 669 } },
    { 505776, 2, { 771, 656 } },
    { 505800, 2, { 843, 600 } },
    { 505908, 2, { 828, 611 } },
    { 505925, 2, { 1225, 413 } },
    { 505960, 2, { 728, 695 } },
    { 505968, 2, { 762, 664 } },
    { 505995, 2, { 915, 553 } },
    { 506000, 2, { 880, 575 } },
    { 506004, 2, { 849, 596 } },
    { 506010, 2, { 835, 606 } },
    { 506016, 2, { 753, 672 } },
    { 506022, 2, { 726, 697 } },
    { 506025, 2, { 865, 585 } },
    { 506076, 2, { 724, 699 } },
    { 506088, 2, { 781, 648 } },
    { 506100, 2, { 723, 700 } },
    { 506115, 2, { 815, 621 } },
    { 506142, 2, { 721, 702 } },
    { 506160, 2, { 720, 703 } },
    { 506220, 2, { 715, 708 } },
    { 506232, 2, { 712, 711 } },
    { 506240, 2, { 791, 640 } },
    { 506253, 2, { 759, 667 } },
    { 506268, 2, { 738, 686 } },
    { 506328, 2, { 867, 584 } },
    { 506331, 2, { 893, 567 } },
    { 506345, 2, { 805, 629 } },
    { 506350, 2, { 779, 650 } },
    { 506352, 2, { 822, 616 } },
    { 506385, 2, { 837, 605 } },
    { 506400, 2, { 800, 633 } },
    { 506415, 2, { 735, 689 } },
    { 506464, 2, { 784, 646 } },
    { 506506, 2, { 847, 598 } },
    { 506520, 2, { 756, 670 } },
    { 506532, 2, { 764, 663 } },
    { 506540, 2, { 817, 620 } },
    { 506583, 2, { 731, 693 } },
    { 506600, 2, { 745, 680 } },
    { 506604, 2, { 777, 652 } },
    { 506616, 2, { 808, 627 } },
    { 506632, 2, { 763, 664 } },
    { 506655, 2, { 729, 695 } },
    { 506664, 2, { 744, 681 } },
    { 506715, 2, { 913, 555 } },
    { 506730, 2, { 762, 665 } },
    { 506736, 2, { 782, 648 } },
    { 506796, 2, { 807, 628 } },
    { 506844, 2, { 722, 702 } },
    { 506850, 2, { 775, 654 } },
    { 506880, 2, { 720, 704 } },
    { 506920, 2, { 760, 667 } },
    { 506970, 2, { 774, 655 } },
    { 506974, 2, { 806, 629 } },
    { 507000, 2, { 750, 676 } },
    { 507012, 2, { 759, 668 } },
    { 507056, 2, { 737, 688 } },
    { 507072, 2, { 834, 608 } },
    { 507104, 2, { 736, 689 } },
    { 507129, 2, { 779, 651 } },
    { 507204, 2, { 772, 657 } },
    { 507213, 2, { 747, 679 } },
    { 507276, 2, { 732, 693 } },
    { 507312, 2, { 813, 624 } },
    { 507357, 2, { 817, 621 } },
    { 507360, 2, { 755, 672 } },
    { 507384, 2, { 729, 696 } },
    { 507416, 2, { 728, 697 } },
    { 507465, 2, { 895, 567 } },
    { 507504, 2, { 776, 654 } },
    { 507520, 2, { 793, 640 } },
    { 507528, 2, { 742, 684 } },
    { 507584, 2, { 721, 704 } },
    { 507600, 2, { 720, 705 } },
    { 507636, 2, { 717, 708 } },
    { 507640, 2, { 740, 686 } },
    { 507744, 2, { 738, 688 } },
    { 507780, 2, { 780, 651 } },
    { 507840, 2, { 736, 690 } },
    { 507870, 2, { 810, 627 } },
    { 507936, 2, { 814, 624 } },
    { 507960, 2, { 747, 680 } },
    { 507990, 2, { 826, 615 } },
    { 508000, 2, { 800, 635 } },
    { 508032, 2, { 756, 672 } },
    { 508079, 2, { 1573, 323 } },
    { 508080, 2, { 730, 696 } },
    { 508113, 2, { 729, 697 } },
    { 508116, 2, { 789, 644 } },
    { 508130, 2, { 833, 610 } },
    { 508158, 2, { 763, 666 } },
    { 508167, 2, { 783, 649 } },
    { 508200, 2, { 726, 700 } },
    { 508260, 2, { 788, 645 } },
    { 508277, 2, { 943, 539 } },
    { 508280, 2, { 776, 655 } },
    { 508288, 2, { 722, 704 } },
    { 508300, 2, { 782, 650 } },
    { 508305, 2, { 721, 705 } },
    { 508326, 2, { 741, 686 } },
    { 508365, 2, { 715, 711 } },
    { 508368, 2, { 714, 712 } },
    { 508375, 2, { 875, 581 } },
    { 508380, 2, { 740, 687 } },
    { 508400, 2, { 775, 656 } },
    { 508431, 2, { 781, 651 } },
    { 508440, 2, { 760, 669 } },
    { 508464, 2, { 792, 642 } },
    { 508482, 2, { 738, 689 } },
    { 508530, 2, { 737, 690 } },
    { 508572, 2, { 831, 612 } },
    { 508620, 2, { 735, 692 } },
    { 508635, 2, { 801, 635 } },
    { 508644, 2, { 796, 639 } },
    { 508680, 2, { 785, 648 } },
    { 508725, 2, { 765, 665 } },
    { 508740, 2, { 732, 695 } },
    { 508750, 2, { 814, 625 } },
    { 508776, 2, { 731, 696 } },
    { 508800, 2, { 795, 640 } },
    { 508805, 2, { 841, 605 } },
    { 508816, 2, { 784, 649 } },
    { 508860, 2, { 771, 660 } },
    { 508872, 2, { 728, 699 } },
    { 508898, 2, { 851, 598 } },
    { 508932, 2, { 804, 633 } },
    { 508950, 2, { 725, 702 } },
    { 508956, 2, { 876, 581 } },
    { 508963, 2, { 799, 637 } },
    { 508992, 2, { 723, 704 } },
    { 509028, 2, { 753, 676 } },
    { 509040, 2, { 720, 707 } },
    { 509076, 2, { 716, 711 } },
    { 509080, 2, { 715, 712 } },
    { 509082, 2, { 714, 713 } },
    { 509124, 2, { 798, 638 } },
    { 509172, 2, { 843, 604 } },
    { 509175, 2, { 775, 657 } },
    { 509184, 2, { 768, 663 } },
    { 509229, 2, { 959, 531 } },
    { 509250, 2, { 750, 679 } },
    { 509292, 2, { 774, 658 } },
    { 509320, 2, { 749, 680 } },
    { 509328, 2, { 786, 648 } },
    { 509388, 2, { 748, 681 } },
    { 509400, 2, { 849, 600 } },
    { 509425, 2, { 1025, 497 } },
    { 509436, 2, { 801, 636 } },
    { 509535, 2, { 845, 603 } },
    { 509580, 2, { 745, 684 } },
    { 509600, 2, { 728, 700 } },
    { 509625, 2, { 755, 675 } },
    { 509640, 2, { 744, 685 } },
    { 509675, 2, { 725, 703 } },
    { 509712, 2, { 777, 656 } },
    { 509733, 2, { 783, 651 } },
    { 509760, 2, { 720, 708 } },
    { 509762, 2, { 799, 638 } },
    { 509795, 2, { 715, 713 } },
    { 509808, 2, { 741, 688 } },
    { 509832, 2, { 776, 657 } },
    { 509856, 2, { 752, 678 } },
    { 509860, 2, { 740, 689 } },
    { 509950, 2, { 775, 658 } },
    { 509960, 2, { 760, 671 } },
    { 510000, 2, { 750, 680 } },
    { 510024, 2, { 807, 632 } },
    { 510048, 2, { 736, 693 } },
    { 510055, 2, { 767, 665 } },
    { 510081, 2, { 957, 533 } },
    { 510125, 2, { 875, 583 } },
    { 510150, 2, { 895, 570 } },
    { 510195, 2, { 791, 645 } },
    { 510237, 2, { 801, 637 } },
    { 510255, 2, { 765, 667 } },
    { 510272, 2, { 938, 544 } },
    { 510300, 2, { 729, 700 } },
    { 510378, 2, { 726, 703 } },
    { 510384, 2, { 744, 686 } },
    { 510400, 2, { 725, 704 } },
    { 510420, 2, { 724, 705 } },
    { 510468, 2, { 721, 708 } },
    { 510496, 2, { 742, 688 } },
    { 510504, 2, { 717, 712 } },
    { 510510, 2, { 715, 714 } },
    { 510516, 2, { 783, 652 } },
    { 510564, 2, { 813, 628 } },
    { 510570, 2, { 837, 610 } },
    { 510608, 2, { 752, 679 } },
    { 510625, 2, { 817, 625 } },
    { 510663, 2, { 867, 589 } },
    { 510692, 2, { 793, 644 } },
    { 510708, 2, { 803, 636 } },
    { 510720, 2, { 760, 672 } },
    { 510741, 2, { 737, 693 } },
    { 510748, 2, { 812, 629 } },
    { 510796, 2, { 836, 611 } },
    { 510822, 2, { 767, 666 } },
    { 510860, 2, { 820, 623 } },
    { 510867, 2, { 901, 567 } },
    { 510900, 2, { 780, 655 } },
    { 510948, 2, { 747, 684 } },
    { 510972, 2, { 869, 588 } },
    { 511020, 2, { 765, 668 } },
    { 511056, 2, { 728, 702 } },
    { 511104, 2, { 726, 704 } },
    { 511116, 2, { 764, 669 } },
    { 511119, 2, { 931, 549 } },
    { 511128, 2, { 744, 687 } },
    { 511200, 2, { 720, 710 } },
    { 511210, 2, { 763, 670 } },
    { 511272, 2, { 789, 648 } },
    { 511328, 2, { 841, 608 } },
    { 511407, 2, { 837, 611 } },
    { 511464, 2, { 808, 633 } },
    { 511485, 2, { 793, 645 } },
    { 511488, 2, { 768, 666 } },
    { 511500, 2, { 750, 682 } },
    { 511511, 2, { 803, 637 } },
    { 511520, 2, { 736, 695 } },
    { 511525, 2, { 925, 553 } },
    { 511560, 2, { 735, 696 } },
    { 511668, 2, { 732, 699 } },
    { 511680, 2, { 780, 656 } },
    { 511695, 2, { 747, 685 } },
    { 511700, 2, { 731, 700 } },
    { 511704, 2, { 824, 621 } },
    { 511784, 2, { 728, 703 } },
    { 511819, 2, { 1309, 391 } },
    { 511836, 2, { 772, 663 } },
    { 511875, 2, { 819, 625 } },
    { 511884, 2, { 723, 708 } },
    { 511890, 2, { 755, 678 } },
    { 511896, 2, { 831, 616 } },
    { 511910, 2, { 721, 710 } },
    { 511920, 2, { 720, 711 } },
    { 511944, 2, { 771, 664 } },
    { 511980, 2, { 742, 690 } },
    { 512001, 2, { 903, 567 } },
    { 512040, 2, { 753, 680 } },
    { 512064, 2, { 762, 672 } },
    { 512070, 2, { 845, 606 } },
    { 512072, 2, { 968, 529 } },
    { 512112, 2, { 752, 681 } },
    { 512120, 2, { 826, 620 } },
    { 512148, 2, { 804, 637 } },
    { 512244, 2, { 837, 612 } },
    { 512256, 2, { 736, 696 } },
    { 512259, 2, { 817, 627 } },
    { 512265, 2, { 923, 555 } },
    { 512295, 2, { 735, 697 } },
    { 512316, 2, { 749, 684 } },
    { 512325, 2, { 759, 675 } },
    { 512336, 2, { 781, 656 } },
    { 512430, 2, { 870, 589 } },
    { 512460, 2, { 730, 702 } },
    { 512487, 2, { 729, 703 } },
    { 512512, 2, { 728, 704 } },
    { 512525, 2, { 1079, 475 } },
    { 512544, 2, { 843, 608 } },
    { 512560, 2, { 745, 688 } },
    { 512575, 2, { 725, 707 } },
    { 512601, 2, { 969, 529 } },
    { 512616, 2, { 744, 689 } },
    { 512631, 2, { 721, 711 } },
    { 512720, 2, { 754, 680 } },
    { 512736, 2, { 763, 672 } },
    { 512772, 2, { 741, 692 } },
    { 512796, 2, { 849, 604 } },
    { 512820, 2, { 740, 693 } },
    { 512865, 2, { 783, 655 } },
    { 512910, 2, { 738, 695 } },
    { 512928, 2, { 822, 624 } },
    { 512946, 2, { 826, 621 } },
    { 512952, 2, { 737, 696 } },
    { 512975, 2, { 1207, 425 } },
    { 512981, 2, { 931, 551 } },
    { 512988, 2, { 788, 651 } },
    { 512992, 2, { 736, 697 } },
    { 513000, 2, { 750, 684 } },
    { 513040, 2, { 848, 605 } },
    { 513080, 2, { 808, 635 } },
    { 513084, 2, { 759, 676 } },
    { 513128, 2, { 748, 686 } },
    { 513135, 2, { 905, 567 } },
    { 513156, 2, { 861, 596 } },
    { 513162, 2, { 731, 702 } },
    { 513205, 2, { 1085, 473 } },
    { 513216, 2, { 729, 704 } },
    { 513240, 2, { 728, 705 } },
    { 513252, 2, { 807, 636 } },
    { 513264, 2, { 816, 629 } },
    { 513300, 2, { 725, 708 } },
    { 513315, 2, { 765, 671 } },
    { 513324, 2, { 756, 679 } },
    { 513352, 2, { 721, 712 } },
    { 513360, 2, { 720, 713 } },
    { 513372, 2, { 717, 716 } },
    { 513390, 2, { 785, 654 } },
    { 513400, 2, { 755, 680 } },
    { 513420, 2, { 796, 645 } },
    { 513422, 2, { 806, 637 } },
    { 513450, 2, { 815, 630 } },
    { 513475, 2, { 893, 575 } },
    { 513513, 2, { 741, 693 } },
    { 513520, 2, { 784, 655 } },
    { 513555, 2, { 1005, 511 } },
    { 513585, 2, { 909, 565 } },
    { 513590, 2, { 770, 667 } },
    { 513600, 2, { 800, 642 } },
    { 513648, 2, { 738, 696 } },
    { 513744, 2, { 834, 616 } },
    { 513750, 2, { 750, 685 } },
    { 513756, 2, { 804, 639 } },
    { 513792, 2, { 768, 669 } },
    { 513810, 2, { 865, 594 } },
    { 513816, 2, { 813, 632 } },
    { 513876, 2, { 748, 687 } },
    { 513898, 2, { 781, 658 } },
    { 513920, 2, { 730, 704 } },
    { 513936, 2, { 747, 688 } },
    { 513945, 2, { 729, 705 } },
    { 513975, 2, { 825, 623 } },
    { 513996, 2, { 812, 633 } },
    { 514050, 2, { 745, 690 } },
    { 514080, 2, { 720, 714 } },
    { 514140, 2, { 779, 660 } },
    { 514150, 2, { 791, 650 } },
    { 514185, 2, { 885, 581 } },
    { 514332, 2, { 819, 628 } },
    { 514368, 2, { 752, 684 } },
    { 514395, 2, { 805, 639 } },
    { 514428, 2, { 789, 652 } },
    { 514464, 2, { 736, 699 } },
    { 514488, 2, { 776, 663 } },
    { 514500, 2, { 735, 700 } },
    { 514560, 2, { 768, 670 } },
    { 514600, 2, { 775, 664 } },
    { 514624, 2, { 731, 704 } },
    { 514692, 2, { 841, 612 } },
    { 514696, 2, { 728, 707 } },
    { 514710, 2, { 774, 665 } },
    { 514755, 2, { 837, 615 } },
    { 514764, 2, { 724, 711 } },
    { 514776, 2, { 723, 712 } },
    { 514786, 2, { 722, 713 } },
    { 514800, 2, { 720, 715 } },
    { 514836, 2, { 756, 681 } },
    { 514855, 2, { 851, 605 } },
    { 514932, 2, { 913, 564 } },
    { 514960, 2, { 785, 656 } },
    { 514976, 2, { 836, 616 } },
    { 514998, 2, { 867, 594 } },
    { 515000, 2, { 824, 625 } },
    { 515025, 2, { 763, 675 } },
    { 515028, 2, { 771, 668 } },
    { 515040, 2, { 740, 696 } },
    { 515052, 2, { 753, 684 } },
    { 515088, 2, { 784, 657 } },
    { 515120, 2, { 752, 685 } },
    { 515160, 2, { 795, 648 } },
    { 515185, 2, { 935, 551 } },
    { 515200, 2, { 736, 700 } },
    { 515214, 2, { 783, 658 } },
    { 515220, 2, { 831, 620 } },
    { 515280, 2, { 760, 678 } },
    { 515312, 2, { 749, 688 } },
    { 515328, 2, { 732, 704 } },
    { 515372, 2, { 748, 689 } },
    { 515403, 2, { 729, 707 } },
    { 515450, 2, { 793, 650 } },
    { 515475, 2, { 725, 711 } },
    { 515508, 2, { 722, 714 } },
    { 515592, 2, { 744, 693 } },
    { 515616, 2, { 786, 656 } },
    { 515632, 2, { 871, 592 } },
    { 515700, 2, { 764, 675 } },
    { 515736, 2, { 741, 696 } },
    { 515745, 2, { 785, 657 } },
    { 515780, 2, { 740, 697 } },
    { 515840, 2, { 806, 640 } },
    { 515844, 2, { 801, 644 } },
    { 515850, 2, { 905, 570 } },
    { 515872, 2, { 752, 686 } },
    { 515900, 2, { 737, 700 } },
    { 515916, 2, { 843, 612 } },
    { 515928, 2, { 777, 664 } },
    { 515955, 2, { 795, 649 } },
    { 515970, 2, { 735, 702 } },
    { 516000, 2, { 750, 688 } },
    { 516030, 2, { 835, 618 } },
    { 516040, 2, { 760, 679 } },
    { 516060, 2, { 732, 705 } },
    { 516096, 2, { 768, 672 } },
    { 516110, 2, { 730, 707 } },
    { 516132, 2, { 729, 708 } },
    { 516150, 2, { 775, 666 } },
    { 516192, 2, { 849, 608 } },
    { 516200, 2, { 725, 712 } },
    { 516230, 2, { 722, 715 } },
    { 516240, 2, { 720, 717 } },
    { 516243, 2, { 793, 651 } },
    { 516250, 2, { 826, 625 } },
    { 516285, 2, { 745, 693 } },
    { 516312, 2, { 808, 639 } },
    { 516420, 2, { 755, 684 } },
    { 516432, 2, { 742, 696 } },
    { 516460, 2, { 833, 620 } },
    { 516468, 2, { 772, 669 } },
    { 516477, 2, { 741, 697 } },
    { 516480, 2, { 807, 640 } },
    { 516483, 2, { 999, 517 } },
    { 516528, 2, { 816, 633 } },
    { 516591, 2, { 1007, 513 } },
    { 516624, 2, { 752, 687 } },
    { 516648, 2, { 824, 627 } },
    { 516663, 2, { 973, 531 } },
    { 516670, 2, { 770, 671 } },
    { 516672, 2, { 736, 702 } },
    { 516705, 2, { 735, 703 } },
    { 516732, 2, { 867, 596 } },
    { 516750, 2, { 750, 689 } },
    { 516780, 2, { 783, 660 } },
    { 516810, 2, { 749, 690 } },
    { 516816, 2, { 776, 666 } },
    { 516840, 2, { 730, 708 } },
    { 516852, 2, { 879, 588 } },
    { 516912, 2, { 726, 712 } },
    { 516924, 2, { 747, 692 } },
    { 516925, 2, { 725, 713 } },
    { 516971, 2, { 1183, 437 } },
    { 517055, 2, { 869, 595 } },
    { 517068, 2, { 813, 636 } },
    { 517075, 2, { 925, 559 } },
    { 517080, 2, { 744, 695 } },
    { 517090, 2, { 830, 623 } },
    { 517132, 2, { 803, 644 } },
    { 517140, 2, { 765, 676 } },
    { 517244, 2, { 754, 686 } },
    { 517260, 2, { 740, 699 } },
    { 517275, 2, { 825, 627 } },
    { 517280, 2, { 848, 610 } },
    { 517293, 2, { 833, 621 } },
    { 517374, 2, { 737, 702 } },
    { 517408, 2, { 736, 703 } },
    { 517440, 2, { 735, 704 } },
    { 517517, 2, { 847, 611 } },
    { 517524, 2, { 732, 707 } },
    { 517560, 2, { 760, 681 } },
    { 517584, 2, { 789, 656 } },
    { 517590, 2, { 729, 710 } },
    { 517608, 2, { 728, 711 } },
    { 517638, 2, { 726, 713 } },
    { 517650, 2, { 725, 714 } },
    { 517668, 2, { 723, 716 } },
    { 517716, 2, { 788, 657 } },
    { 517725, 2, { 767, 675 } },
    { 517752, 2, { 799, 648 } },
    { 517860, 2, { 756, 685 } },
    { 517880, 2, { 856, 605 } },
    { 517888, 2, { 896, 578 } },
    { 517902, 2, { 798, 649 } },
    { 517935, 2, { 803, 645 } },
    { 517940, 2, { 893, 580 } },
    { 517968, 2, { 792, 654 } },
    { 517979, 2, { 961, 539 } },
    { 518016, 2, { 852, 608 } },
    { 518035, 2, { 779, 665 } },
    { 518064, 2, { 753, 688 } },
    { 518075, 2, { 901, 575 } },
    { 518100, 2, { 785, 660 } },
    { 518112, 2, { 771, 672 } },
    { 518128, 2, { 752, 689 } },
    { 518154, 2, { 949, 546 } },
    { 518160, 2, { 762, 680 } },
    { 518196, 2, { 796, 651 } },
    { 518240, 2, { 790, 656 } },
    { 518245, 2, { 871, 595 } },
    { 518320, 2, { 760, 682 } },
    { 518340, 2, { 795, 652 } },
    { 518466, 2, { 782, 663 } },
    { 518518, 2, { 814, 637 } },
    { 518520, 2, { 745, 696 } },
    { 518535, 2, { 835, 621 } },
    { 518544, 2, { 831, 624 } },
    { 518568, 2, { 744, 697 } },
    { 518580, 2, { 774, 670 } },
    { 518592, 2, { 876, 592 } },
    { 518616, 2, { 756, 686 } },
    { 518650, 2, { 902, 575 } },
    { 518700, 2, { 741, 700 } },
    { 518736, 2, { 808, 642 } },
    { 518805, 2, { 915, 567 } },
    { 518840, 2, { 763, 680 } },
    { 518848, 2, { 737, 704 } },
    { 518868, 2, { 812, 639 } },
    { 518880, 2, { 736, 705 } },
    { 518896, 2, { 791, 656 } },
    { 518925, 2, { 825, 629 } },
    { 518940, 2, { 837, 620 } },
    { 518976, 2, { 816, 636 } },
    { 519036, 2, { 777, 668 } },
    { 519048, 2, { 729, 712 } },
    { 519057, 2, { 749, 693 } },
    { 519060, 2, { 820, 633 } },
    { 519064, 2, { 728, 713 } },
    { 519090, 2, { 726, 715 } },
    { 519108, 2, { 724, 717 } },
    { 519120, 2, { 721, 720 } },
    { 519144, 2, { 776, 669 } },
    { 519156, 2, { 759, 684 } },
    { 519165, 2, { 747, 695 } },
    { 519168, 2, { 768, 676 } },
    { 519176, 2, { 889, 584 } },
    { 519200, 2, { 800, 649 } },
    { 519232, 2, { 854, 608 } },
    { 519288, 2, { 843, 616 } },
    { 519350, 2, { 799, 650 } },
    { 519354, 2, { 774, 671 } },
    { 519365, 2, { 781, 665 } },
    { 519372, 2, { 756, 687 } },
    { 519400, 2, { 742, 700 } },
    { 519435, 2, { 765, 679 } },
    { 519440, 2, { 755, 688 } },
    { 519453, 2, { 891, 583 } },
    { 519480, 2, { 740, 702 } },
    { 519504, 2, { 822, 632 } },
    { 519552, 2, { 738, 704 } },
    { 519585, 2, { 737, 705 } },
    { 519588, 2, { 849, 612 } },
    { 519622, 2, { 899, 578 } },
    { 519645, 2, { 735, 707 } },
    { 519680, 2, { 812, 640 } },
    { 519687, 2, { 791, 657 } },
    { 519708, 2, { 807, 644 } },
    { 519720, 2, { 732, 710 } },
    { 519750, 2, { 750, 693 } },
    { 519777, 2, { 729, 713 } },
    { 519792, 2, { 728, 714 } },
    { 519800, 2, { 904, 575 } },
    { 519840, 2, { 722, 720 } },
    { 519912, 2, { 747, 696 } },
    { 519939, 2, { 917, 567 } },
    { 520000, 2, { 800, 650 } },
    { 520025, 2, { 775, 671 } },
    { 520030, 2, { 782, 665 } },
    { 520044, 2, { 861, 604 } },
    { 520056, 2, { 744, 699 } },
    { 520065, 2, { 819, 635 } },
    { 520128, 2, { 756, 688 } },
    { 520146, 2, { 781, 666 } },
    { 520149, 2, { 799, 651 } },
    { 520182, 2, { 741, 702 } },
    { 520200, 2, { 765, 680 } },
    { 520208, 2, { 793, 656 } },
    { 520260, 2, { 754, 690 } },
    { 520284, 2, { 764, 681 } },
    { 520290, 2, { 738, 705 } },
    { 520308, 2, { 873, 596 } },
    { 520320, 2, { 813, 640 } },
    { 520331, 2, { 1517, 343 } },
    { 520344, 2, { 792, 657 } },
    { 520352, 2, { 736, 707 } },
    { 520368, 2, { 879, 592 } },
    { 520380, 2, { 735, 708 } },
    { 520416, 2, { 834, 624 } },
    { 520421, 2, { 1331, 391 } },
    { 520429, 2, { 817, 637 } },
    { 520452, 2, { 732, 711 } },
    { 520506, 2, { 729, 714 } },
    { 520520, 2, { 728, 715 } },
    { 520536, 2, { 943, 552 } },
    { 520560, 2, { 723, 720 } },
    { 520600, 2, { 760, 685 } },
    { 520625, 2, { 833, 625 } },
    { 520674, 2, { 759, 686 } },
    { 520695, 2, { 783, 665 } },
    { 520704, 2, { 768, 678 } },
    { 520740, 2, { 789, 660 } },
    { 520785, 2, { 815, 639 } },
    { 520800, 2, { 744, 700 } },
    { 520856, 2, { 917, 568 } },
    { 520884, 2, { 742, 702 } },
    { 520890, 2, { 895, 582 } },
    { 520905, 2, { 847, 615 } },
    { 520923, 2, { 741, 703 } },
    { 520950, 2, { 755, 690 } },
    { 520960, 2, { 740, 704 } },
    { 521076, 2, { 753, 692 } },
    { 521088, 2, { 736, 708 } },
    { 521100, 2, { 772, 675 } },
    { 521136, 2, { 752, 693 } },
    { 521160, 2, { 808, 645 } },
    { 521196, 2, { 771, 676 } },
    { 521235, 2, { 729, 715 } },
    { 521240, 2, { 785, 664 } },
    { 521246, 2, { 817, 638 } },
    { 521250, 2, { 750, 695 } },
    { 521304, 2, { 749, 696 } },
    { 521356, 2, { 748, 697 } },
    { 521360, 2, { 760, 686 } },
    { 521367, 2, { 777, 671 } },
    { 521400, 2, { 790, 660 } },
    { 521424, 2, { 816, 639 } },
    { 521472, 2, { 768, 679 } },
    { 521520, 2, { 795, 656 } },
    { 521560, 2, { 767, 680 } },
    { 521592, 2, { 824, 633 } },
    { 521594, 2, { 782, 667 } },
    { 521595, 2, { 865, 603 } },
    { 521640, 2, { 756, 690 } },
    { 521645, 2, { 1445, 361 } },
    { 521664, 2, { 741, 704 } },
    { 521700, 2, { 740, 705 } },
    { 521730, 2, { 765, 682 } },
    { 521752, 2, { 847, 616 } },
    { 521766, 2, { 738, 707 } },
    { 521794, 2, { 793, 658 } },
    { 521796, 2, { 737, 708 } },
    { 521820, 2, { 780, 669 } },
    { 521868, 2, { 831, 628 } },
    { 521885, 2, { 1085, 481 } },
    { 521892, 2, { 763, 684 } },
    { 521904, 2, { 786, 664 } },
    { 521934, 2, { 731, 714 } },
    { 521964, 2, { 729, 716 } },
    { 521970, 2, { 762, 685 } },
    { 521976, 2, { 728, 717 } },
    { 522000, 2, { 725, 720 } },
    { 522120, 2, { 760, 687 } },
    { 522144, 2, { 777, 672 } },
    { 522192, 2, { 759, 688 } },
    { 522210, 2, { 845, 618 } },
    { 522240, 2, { 768, 680 } },
    { 522252, 2, { 801, 652 } },
    { 522288, 2, { 744, 702 } },
    { 522291, 2, { 833, 627 } },
    { 522340, 2, { 820, 637 } },
    { 522368, 2, { 742, 704 } },
    { 522444, 2, { 788, 663 } },
    { 522445, 2, { 805, 649 } },
    { 522500, 2, { 836, 625 } },
    { 522522, 2, { 754, 693 } },
    { 522560, 2, { 736, 710 } },
    { 522580, 2, { 901, 580 } },
    { 522600, 2, { 780, 670 } },
    { 522640, 2, { 752, 695 } },
    { 522660, 2, { 843, 620 } },
    { 522665, 2, { 731, 715 } },
    { 522675, 2, { 909, 575 } },
    { 522690, 2, { 786, 665 } },
    { 522720, 2, { 726, 720 } },
    { 522725, 2, { 725, 721 } },
    { 522750, 2, { 750, 697 } },
    { 522753, 2, { 803, 651 } },
    { 522784, 2, { 961, 544 } },
    { 522810, 2, { 785, 666 } },
    { 522830, 2, { 770, 679 } },
    { 522852, 2, { 748, 699 } },
    { 522900, 2, { 747, 700 } },
    { 522928, 2, { 784, 667 } },
    { 522936, 2, { 807, 648 } },
    { 522951, 2, { 759, 689 } },
    { 522972, 2, { 796, 657 } },
    { 522984, 2, { 849, 616 } },
    { 522990, 2, { 745, 702 } },
    { 523008, 2, { 768, 681 } },
    { 523032, 2, { 744, 703 } },
    { 523044, 2, { 783, 668 } },
    { 523075, 2, { 1225, 427 } },
    { 523094, 2, { 767, 682 } },
    { 523110, 2, { 742, 705 } },
    { 523125, 2, { 775, 675 } },
    { 523138, 2, { 869, 602 } },
    { 523180, 2, { 740, 707 } },
    { 523200, 2, { 800, 654 } },
    { 523215, 2, { 755, 693 } },
    { 523230, 2, { 815, 642 } },
    { 523240, 2, { 824, 635 } },
    { 523250, 2, { 805, 650 } },
    { 523260, 2, { 765, 684 } },
    { 523296, 2, { 736, 711 } },
    { 523320, 2, { 735, 712 } },
    { 523328, 2, { 832, 629 } },
    { 523380, 2, { 732, 715 } },
    { 523404, 2, { 804, 651 } },
    { 523452, 2, { 724, 723 } },
    { 523488, 2, { 779, 672 } },
    { 523572, 2, { 813, 644 } },
    { 523575, 2, { 895, 585 } },
    { 523600, 2, { 748, 700 } },
    { 523611, 2, { 1107, 473 } },
    { 523640, 2, { 760, 689 } },
    { 523668, 2, { 867, 604 } },
    { 523740, 2, { 812, 645 } },
    { 523755, 2, { 927, 565 } },
    { 523775, 2, { 1025, 511 } },
    { 523776, 2, { 744, 704 } },
    { 523800, 2, { 776, 675 } },
    { 523809, 2, { 1089, 481 } },
    { 523872, 2, { 816, 642 } },
    { 523884, 2, { 879, 596 } },
    { 523896, 2, { 789, 664 } },
    { 523908, 2, { 756, 693 } },
    { 523957, 2, { 833, 629 } },
    { 523980, 2, { 738, 710 } },
    { 524000, 2, { 800, 655 } },
    { 524025, 2, { 765, 685 } },
    { 524055, 2, { 735, 713 } },
    { 524088, 2, { 753, 696 } },
    { 524124, 2, { 828, 633 } },
    { 524160, 2, { 728, 720 } },
    { 524172, 2, { 726, 722 } },
    { 524190, 2, { 865, 606 } },
    { 524216, 2, { 814, 644 } },
    { 524223, 2, { 1099, 477 } },
    { 524238, 2, { 858, 611 } },
    { 524256, 2, { 762, 688 } },
    { 524280, 2, { 771, 680 } },
    { 524300, 2, { 749, 700 } },
    { 524342, 2, { 871, 602 } },
    { 524400, 2, { 760, 690 } },
    { 524475, 2, { 777, 675 } },
    { 524480, 2, { 745, 704 } },
    { 524496, 2, { 784, 669 } },
    { 524520, 2, { 744, 705 } },
    { 524535, 2, { 867, 605 } },
    { 524610, 2, { 783, 670 } },
    { 524628, 2, { 741, 708 } },
    { 524655, 2, { 801, 655 } },
    { 524700, 2, { 795, 660 } },
    { 524745, 2, { 845, 621 } },
    { 524755, 2, { 1015, 517 } },
    { 524768, 2, { 736, 713 } },
    { 524832, 2, { 781, 672 } },
    { 524835, 2, { 963, 545 } },
    { 524844, 2, { 732, 717 } },
    { 524868, 2, { 764, 687 } },
    { 524880, 2, { 729, 720 } },
    { 524888, 2, { 728, 721 } },
    { 524944, 2, { 763, 688 } },
    { 524975, 2, { 913, 575 } },
    { 525096, 2, { 748, 702 } },
    { 525140, 2, { 770, 682 } },
    { 525192, 2, { 831, 632 } },
    { 525210, 2, { 854, 615 } },
    { 525224, 2, { 791, 664 } },
    { 525228, 2, { 759, 692 } },
    { 525252, 2, { 777, 676 } },
    { 525280, 2, { 784, 670 } },
    { 525312, 2, { 768, 684 } },
    { 525393, 2, { 783, 671 } },
    { 525420, 2, { 756, 695 } },
    { 525450, 2, { 775, 678 } },
    { 525456, 2, { 738, 712 } },
    { 525460, 2, { 860, 611 } },
    { 525480, 2, { 755, 696 } },
    { 525504, 2, { 736, 714 } },
    { 525525, 2, { 735, 715 } },
    { 525538, 2, { 754, 697 } },
    { 525546, 2, { 774, 679 } },
    { 525600, 2, { 730, 720 } },
    { 525609, 2, { 729, 721 } },
    { 525616, 2, { 728, 722 } },
    { 525636, 2, { 837, 628 } },
    { 525648, 2, { 752, 699 } },
    { 525690, 2, { 810, 649 } },
    { 525732, 2, { 772, 681 } },
    { 525798, 2, { 749, 702 } },
    { 525825, 2, { 779, 675 } },
    { 525844, 2, { 748, 703 } },
    { 525888, 2, { 747, 704 } },
    { 525915, 2, { 899, 585 } },
    { 525987, 2, { 759, 693 } },
    { 526008, 2, { 744, 707 } },
    { 526032, 2, { 843, 624 } },
    { 526050, 2, { 835, 630 } },
    { 526064, 2, { 784, 671 } },
    { 526071, 2, { 861, 611 } },
    { 526080, 2, { 768, 685 } },
    { 526128, 2, { 776, 678 } },
    { 526140, 2, { 740, 711 } },
    { 526148, 2, { 817, 644 } },
    { 526162, 2, { 767, 686 } },
    { 526164, 2, { 807, 652 } },
    { 526218, 2, { 737, 714 } },
    { 526225, 2, { 775, 679 } },
    { 526240, 2, { 736, 715 } },
    { 526260, 2, { 735, 716 } },
    { 526288, 2, { 889, 592 } },
    { 526320, 2, { 731, 720 } },
    { 526330, 2, { 730, 721 } },
    { 526338, 2, { 729, 722 } },
    { 526344, 2, { 728, 723 } },
    { 526350, 2, { 726, 725 } },
    { 526380, 2, { 849, 620 } },
    { 526449, 2, { 903, 583 } },
    { 526456, 2, { 833, 632 } },
    { 526470, 2, { 763, 690 } },
    { 526473, 2, { 837, 629 } },
    { 526491, 2, { 959, 549 } },
    { 526500, 2, { 750, 702 } },
    { 526536, 2, { 824, 639 } },
    { 526592, 2, { 748, 704 } },
    { 526604, 2, { 779, 676 } },
    { 526656, 2, { 832, 633 } },
    { 526680, 2, { 760, 693 } },
    { 526695, 2, { 949, 555 } },
    { 526710, 2, { 905, 582 } },
    { 526750, 2, { 875, 602 } },
    { 526768, 2, { 803, 656 } },
    { 526824, 2, { 813, 648 } },
    { 526848, 2, { 768, 686 } },
    { 526988, 2, { 812, 649 } },
    { 527000, 2, { 775, 680 } },
    { 527040, 2, { 732, 720 } },
    { 527052, 2, { 789, 668 } },
    { 527085, 2, { 765, 689 } },
    { 527088, 2, { 834, 632 } },
    { 527100, 2, { 753, 700 } },
    { 527136, 2, { 816, 646 } },
    { 527172, 2, { 788, 669 } },
    { 527175, 2, { 781, 675 } },
    { 527250, 2, { 750, 703 } },
    { 527292, 2, { 873, 604 } },
    { 527296, 2, { 749, 704 } },
    { 527307, 2, { 841, 627 } },
    { 527310, 2, { 810, 651 } },
    { 527340, 2, { 748, 705 } },
    { 527345, 2, { 793, 665 } },
    { 527364, 2, { 771, 684 } },
    { 527400, 2, { 879, 600 } },
    { 527424, 2, { 804, 656 } },
    { 527425, 2, { 1241, 425 } },
    { 527436, 2, { 819, 644 } },
    { 527460, 2, { 745, 708 } },
    { 527472, 2, { 792, 666 } },
    { 527520, 2, { 785, 672 } },
    { 527527, 2, { 1001, 527 } },
    { 527560, 2, { 872, 605 } },
    { 527592, 2, { 741, 712 } },
    { 527616, 2, { 768, 687 } },
    { 527625, 2, { 875, 603 } },
    { 527670, 2, { 738, 715 } },
    { 527696, 2, { 767, 688 } },
    { 527712, 2, { 736, 717 } },
    { 527744, 2, { 868, 608 } },
    { 527748, 2, { 796, 663 } },
    { 527772, 2, { 732, 721 } },
    { 527796, 2, { 729, 724 } },
    { 527800, 2, { 728, 725 } },
    { 527877, 2, { 931, 567 } },
    { 527880, 2, { 795, 664 } },
    { 527904, 2, { 752, 702 } },
    { 528000, 2, { 750, 704 } },
    { 528045, 2, { 749, 705 } },
    { 528080, 2, { 805, 656 } },
    { 528125, 2, { 845, 625 } },
    { 528129, 2, { 747, 707 } },
    { 528138, 2, { 793, 666 } },
    { 528165, 2, { 873, 605 } },
    { 528192, 2, { 786, 672 } },
    { 528200, 2, { 760, 695 } },
    { 528228, 2, { 804, 657 } },
    { 528240, 2, { 744, 710 } },
    { 528264, 2, { 759, 696 } },
    { 528320, 2, { 832, 635 } },
    { 528333, 2, { 741, 713 } },
    { 528374, 2, { 803, 658 } },
    { 528432, 2, { 808, 654 } },
    { 528444, 2, { 756, 699 } },
    { 528456, 2, { 776, 681 } },
    { 528471, 2, { 851, 621 } },
    { 528516, 2, { 831, 636 } },
    { 528525, 2, { 729, 725 } },
    { 528528, 2, { 728, 726 } },
    { 528612, 2, { 812, 651 } },
    { 528632, 2, { 782, 676 } },
    { 528640, 2, { 826, 640 } },
    { 528660, 2, { 801, 660 } },
    { 528710, 2, { 830, 637 } },
    { 528759, 2, { 763, 693 } },
    { 528770, 2, { 874, 605 } },
    { 528808, 2, { 931, 568 } },
    { 528876, 2, { 747, 708 } },
    { 528885, 2, { 805, 657 } },
    { 528900, 2, { 820, 645 } },
    { 528984, 2, { 744, 711 } },
    { 529008, 2, { 824, 642 } },
    { 529023, 2, { 759, 697 } },
    { 529074, 2, { 741, 714 } },
    { 529092, 2, { 828, 639 } },
    { 529152, 2, { 768, 689 } },
    { 529188, 2, { 836, 633 } },
    { 529200, 2, { 735, 720 } },
    { 529221, 2, { 869, 609 } },
    { 529230, 2, { 767, 690 } },
    { 529236, 2, { 732, 723 } },
    { 529240, 2, { 808, 655 } },
    { 529254, 2, { 729, 726 } },
    { 529308, 2, { 754, 702 } },
    { 529375, 2, { 847, 625 } },
    { 529380, 2, { 765, 692 } },
    { 529392, 2, { 807, 656 } },
    { 529404, 2, { 843, 628 } },
    { 529425, 2, { 905, 585 } },
    { 529452, 2, { 764, 693 } },
    { 529470, 2, { 795, 666 } },
    { 529480, 2, { 854, 620 } },
    { 529529, 2, { 1001, 529 } },
    { 529550, 2, { 850, 623 } },
    { 529568, 2, { 871, 608 } },
    { 529590, 2, { 762, 695 } },
    { 529620, 2, { 780, 679 } },
    { 529695, 2, { 745, 711 } },
    { 529720, 2, { 760, 697 } },
    { 529737, 2, { 799, 663 } },
    { 529760, 2, { 770, 688 } },
    { 529776, 2, { 849, 624 } },
    { 529802, 2, { 923, 574 } },
    { 529815, 2, { 741, 715 } },
    { 529830, 2, { 841, 630 } },
    { 529848, 2, { 792, 669 } },
    { 529872, 2, { 798, 664 } },
    { 529875, 2, { 785, 675 } },
    { 529925, 2, { 1025, 517 } },
    { 529935, 2, { 735, 721 } },
    { 529970, 2, { 791, 670 } },
    { 529975, 2, { 731, 725 } },
    { 530000, 2, { 848, 625 } },
    { 530010, 2, { 755, 702 } },
    { 530062, 2, { 754, 703 } },
    { 530076, 2, { 813, 652 } },
    { 530100, 2, { 775, 684 } },
    { 530112, 2, { 753, 704 } },
    { 530160, 2, { 752, 705 } },
    { 530190, 2, { 774, 685 } },
    { 530208, 2, { 789, 672 } },
    { 530250, 2, { 750, 707 } },
    { 530292, 2, { 749, 708 } },
    { 530334, 2, { 854, 621 } },
    { 530352, 2, { 762, 696 } },
    { 530364, 2, { 772, 687 } },
    { 530376, 2, { 861, 616 } },
    { 530439, 2, { 871, 609 } },
    { 530440, 2, { 745, 712 } },
    { 530448, 2, { 771, 688 } },
    { 530556, 2, { 741, 716 } },
    { 530580, 2, { 740, 717 } },
    { 530604, 2, { 867, 612 } },
    { 530640, 2, { 737, 720 } },
    { 530656, 2, { 736, 721 } },
    { 530670, 2, { 735, 722 } },
    { 530700, 2, { 732, 725 } },
    { 530706, 2, { 731, 726 } },
    { 530712, 2, { 729, 728 } },
    { 530725, 2, { 923, 575 } },
    { 530796, 2, { 852, 623 } },
    { 530816, 2, { 754, 704 } },
    { 530856, 2, { 808, 657 } },
    { 530880, 2, { 790, 672 } },
    { 530916, 2, { 879, 604 } },
    { 530950, 2, { 925, 574 } },
    { 530964, 2, { 774, 686 } },
    { 531024, 2, { 851, 624 } },
    { 531036, 2, { 891, 596 } },
    { 531048, 2, { 763, 696 } },
    { 531050, 2, { 817, 650 } },
    { 531060, 2, { 795, 668 } },
    { 531180, 2, { 780, 681 } },
    { 531216, 2, { 744, 714 } },
    { 531240, 2, { 760, 699 } },
    { 531278, 2, { 779, 682 } },
    { 531300, 2, { 759, 700 } },
    { 531335, 2, { 799, 665 } },
    { 531360, 2, { 738, 720 } },
    { 531454, 2, { 833, 638 } },
    { 531468, 2, { 756, 703 } },
    { 531480, 2, { 824, 645 } },
    { 531495, 2, { 837, 635 } },
    { 531505, 2, { 845, 629 } },
    { 531520, 2, { 755, 704 } },
    { 531531, 2, { 767, 693 } },
    { 531552, 2, { 784, 678 } },
    { 531560, 2, { 776, 685 } },
    { 531615, 2, { 915, 581 } },
    { 531630, 2, { 895, 594 } },
    { 531648, 2, { 832, 639 } },
    { 531650, 2, { 775, 686 } },
    { 531657, 2, { 783, 679 } },
    { 531664, 2, { 752, 707 } },
    { 531675, 2, { 765, 695 } },
    { 531720, 2, { 840, 633 } },
    { 531760, 2, { 782, 680 } },
    { 531790, 2, { 749, 710 } },
    { 531828, 2, { 748, 711 } },
    { 531840, 2, { 831, 640 } },
    { 531864, 2, { 747, 712 } },
    { 531867, 2, { 817, 651 } },
    { 531875, 2, { 851, 625 } },
    { 531900, 2, { 788, 675 } },
    { 531930, 2, { 745, 714 } },
    { 531960, 2, { 744, 715 } },
    { 532098, 2, { 738, 721 } },
    { 532128, 2, { 736, 723 } },
    { 532134, 2, { 799, 666 } },
    { 532140, 2, { 735, 724 } },
    { 532168, 2, { 731, 728 } },
    { 532170, 2, { 730, 729 } },
    { 532180, 2, { 820, 649 } },
    { 532224, 2, { 756, 704 } },
    { 532230, 2, { 785, 678 } },
    { 532266, 2, { 798, 667 } },
    { 532287, 2, { 833, 639 } },
    { 532332, 2, { 837, 636 } },
    { 532400, 2, { 880, 605 } },
    { 532416, 2, { 752, 708 } },
    { 532440, 2, { 765, 696 } },
    { 532467, 2, { 999, 533 } },
    { 532475, 2, { 1121, 475 } },
    { 532512, 2, { 774, 688 } },
    { 532524, 2, { 796, 669 } },
    { 532532, 2, { 836, 637 } },
    { 532539, 2, { 749, 711 } },
    { 532608, 2, { 876, 608 } },
    { 532620, 2, { 807, 660 } },
    { 532656, 2, { 822, 648 } },
    { 532665, 2, { 801, 665 } },
    { 532763, 2, { 847, 629 } },
    { 532770, 2, { 826, 645 } },
    { 532776, 2, { 843, 632 } },
    { 532800, 2, { 740, 720 } },
    { 532818, 2, { 759, 702 } },
    { 532899, 2, { 731, 729 } },
    { 532950, 2, { 825, 646 } },
    { 532980, 2, { 756, 705 } },
    { 533010, 2, { 815, 654 } },
    { 533025, 2, { 927, 575 } },
    { 533052, 2, { 804, 663 } },
    { 533071, 2, { 989, 539 } },
    { 533112, 2, { 776, 687 } },
    { 533124, 2, { 753, 708 } },
    { 533172, 2, { 849, 628 } },
    { 533200, 2, { 775, 688 } },
    { 533205, 2, { 765, 697 } },
    { 533286, 2, { 774, 689 } },
    { 533288, 2, { 749, 712 } },
    { 533324, 2, { 748, 713 } },
    { 533328, 2, { 813, 656 } },
    { 533364, 2, { 789, 676 } },
    { 533445, 2, { 795, 671 } },
    { 533448, 2, { 744, 717 } },
    { 533484, 2, { 812, 657 } },
    { 533520, 2, { 741, 720 } },
    { 533532, 2, { 771, 692 } },
    { 533533, 2, { 1001, 533 } },
    { 533540, 2, { 740, 721 } },
    { 533565, 2, { 835, 639 } },
    { 533577, 2, { 759, 703 } },
    { 533600, 2, { 736, 725 } },
    { 533610, 2, { 735, 726 } },
    { 533628, 2, { 732, 729 } },
    { 533664, 2, { 816, 654 } },
    { 533750, 2, { 854, 625 } },
    { 533760, 2, { 768, 695 } },
    { 533800, 2, { 785, 680 } },
    { 533820, 2, { 820, 651 } },
    { 533904, 2, { 784, 681 } },
    { 533919, 2, { 969, 551 } },
    { 533920, 2, { 752, 710 } },
    { 533925, 2, { 791, 675 } },
    { 533975, 2, { 775, 689 } },
    { 533988, 2, { 819, 652 } },
    { 533995, 2, { 803, 665 } },
    { 534000, 2, { 750, 712 } },
    { 534006, 2, { 783, 682 } },
    { 534036, 2, { 764, 699 } },
    { 534100, 2, { 763, 700 } },
    { 534105, 2, { 747, 715 } },
    { 534144, 2, { 832, 642 } },
    { 534177, 2, { 973, 549 } },
    { 534204, 2, { 781, 684 } },
    { 534240, 2, { 742, 720 } },
    { 534275, 2, { 1075, 497 } },
    { 534276, 2, { 873, 612 } },
    { 534300, 2, { 780, 685 } },
    { 534325, 2, { 737, 725 } },
    { 534336, 2, { 736, 726 } },
    { 534360, 2, { 732, 730 } },
    { 534375, 2, { 855, 625 } },
    { 534394, 2, { 779, 686 } },
    { 534432, 2, { 879, 608 } },
    { 534435, 2, { 869, 615 } },
    { 534480, 2, { 786, 680 } },
    { 534492, 2, { 756, 707 } },
    { 534520, 2, { 805, 664 } },
    { 534528, 2, { 768, 696 } },
    { 534540, 2, { 755, 708 } },
    { 534570, 2, { 865, 618 } },
    { 534576, 2, { 777, 688 } },
    { 534600, 2, { 792, 675 } },
    { 534625, 2, { 875, 611 } },
    { 534640, 2, { 815, 656 } },
    { 534650, 2, { 850, 629 } },
    { 534672, 2, { 752, 711 } },
    { 534681, 2, { 861, 621 } },
    { 534688, 2, { 784, 682 } },
    { 534750, 2, { 750, 713 } },
    { 534798, 2, { 803, 666 } },
    { 534852, 2, { 747, 716 } },
    { 534888, 2, { 782, 684 } },
    { 534905, 2, { 899, 595 } },
    { 534963, 2, { 957, 559 } },
    { 534996, 2, { 772, 693 } },
    { 535000, 2, { 856, 625 } },
    { 535020, 2, { 740, 723 } },
    { 535040, 2, { 760, 704 } },
    { 535050, 2, { 738, 725 } },
    { 535059, 2, { 1043, 513 } },
    { 535068, 2, { 801, 668 } },
    { 535080, 2, { 735, 728 } },
    { 535164, 2, { 831, 644 } },
    { 535194, 2, { 901, 594 } },
    { 535200, 2, { 800, 669 } },
    { 535275, 2, { 793, 675 } },
    { 535296, 2, { 768, 697 } },
    { 535304, 2, { 847, 632 } },
    { 535353, 2, { 777, 689 } },
    { 535392, 2, { 792, 676 } },
    { 535425, 2, { 825, 649 } },
    { 535440, 2, { 776, 690 } },
    { 535455, 2, { 815, 657 } },
    { 535458, 2, { 798, 671 } },
    { 535500, 2, { 750, 714 } },
    { 535528, 2, { 917, 584 } },
    { 535572, 2, { 783, 684 } },
    { 535626, 2, { 763, 702 } },
    { 535665, 2, { 871, 615 } },
    { 535704, 2, { 808, 663 } },
    { 535717, 2, { 841, 637 } },
    { 535766, 2, { 781, 686 } },
    { 535780, 2, { 860, 623 } },
    { 535800, 2, { 760, 705 } },
    { 535815, 2, { 735, 729 } },
    { 535848, 2, { 807, 664 } },
    { 535860, 2, { 780, 687 } },
    { 535920, 2, { 770, 696 } },
    { 535990, 2, { 806, 665 } },
    { 536000, 2, { 800, 670 } },
    { 536067, 2, { 889, 603 } },
    { 536070, 2, { 835, 642 } },
    { 536095, 2, { 901, 595 } },
    { 536112, 2, { 816, 657 } },
    { 536130, 2, { 777, 690 } },
    { 536136, 2, { 753, 712 } },
    { 536148, 2, { 843, 636 } },
    { 536250, 2, { 750, 715 } },
    { 536256, 2, { 784, 684 } },
    { 536316, 2, { 748, 717 } },
    { 536355, 2, { 783, 685 } },
    { 536360, 2, { 920, 583 } },
    { 536393, 2, { 1331, 403 } },
    { 536400, 2, { 745, 720 } },
    { 536410, 2, { 790, 679 } },
    { 536424, 2, { 744, 721 } },
    { 536445, 2, { 819, 655 } },
    { 536448, 2, { 762, 704 } },
    { 536452, 2, { 782, 686 } },
    { 536484, 2, { 741, 724 } },
    { 536520, 2, { 789, 680 } },
    { 536536, 2, { 737, 728 } },
    { 536544, 2, { 736, 729 } },
    { 536568, 2, { 849, 632 } },
    { 536580, 2, { 813, 660 } },
    { 536616, 2, { 771, 696 } },
    { 536625, 2, { 795, 675 } },
    { 536628, 2, { 788, 681 } },
    { 536640, 2, { 780, 688 } },
    { 536690, 2, { 770, 697 } },
    { 536760, 2, { 756, 710 } },
    { 536800, 2, { 800, 671 } },
    { 536805, 2, { 755, 711 } },
    { 536832, 2, { 768, 699 } },
    { 536844, 2, { 913, 588 } },
    { 536900, 2, { 767, 700 } },
    { 536928, 2, { 752, 714 } },
    { 536935, 2, { 805, 667 } },
    { 536940, 2, { 785, 684 } },
    { 536976, 2, { 792, 678 } },
    { 537030, 2, { 765, 702 } },
    { 537040, 2, { 784, 685 } },
    { 537075, 2, { 775, 693 } },
    { 537138, 2, { 783, 686 } },
    { 537152, 2, { 763, 704 } },
    { 537165, 2, { 865, 621 } },
    { 537251, 2, { 1859, 289 } },
    { 537264, 2, { 738, 728 } },
    { 537273, 2, { 737, 729 } },
    { 537280, 2, { 736, 730 } },
    { 537285, 2, { 735, 731 } },
    { 537300, 2, { 796, 675 } },
    { 537320, 2, { 760, 707 } },
    { 537328, 2, { 781, 688 } },
    { 537372, 2, { 759, 708 } },
    { 537420, 2, { 780, 689 } },
    { 537425, 2, { 925, 581 } },
    { 537472, 2, { 832, 646 } },
    { 537510, 2, { 779, 690 } },
    { 537516, 2, { 756, 711 } },
    { 537540, 2, { 867, 620 } },
    { 537560, 2, { 755, 712 } },
    { 537570, 2, { 905, 594 } },
    { 537600, 2, { 768, 700 } },
    { 537602, 2, { 754, 713 } },
    { 537680, 2, { 752, 715 } },
    { 537684, 2, { 777, 692 } },
    { 537768, 2, { 776, 693 } },
    { 537795, 2, { 765, 703 } },
    { 537840, 2, { 747, 720 } },
    { 537876, 2, { 804, 669 } },
    { 537880, 2, { 791, 680 } },
    { 537900, 2, { 815, 660 } },
    { 537912, 2, { 744, 723 } },
    { 537915, 2, { 763, 705 } },
    { 537930, 2, { 774, 695 } },
    { 537948, 2, { 879, 612 } },
    { 537950, 2, { 742, 725 } },
    { 537966, 2, { 741, 726 } },
    { 538005, 2, { 1157, 465 } },
    { 538016, 2, { 736, 731 } },
    { 538020, 2, { 735, 732 } },
    { 538118, 2, { 833, 646 } },
    { 538125, 2, { 861, 625 } },
    { 538128, 2, { 808, 666 } },
    { 538164, 2, { 891, 604 } },
    { 538240, 2, { 841, 640 } },
    { 538350, 2, { 925, 582 } },
    { 538356, 2, { 754, 714 } },
    { 538410, 2, { 786, 685 } },
    { 538434, 2, { 767, 702 } },
    { 538480, 2, { 848, 635 } },
    { 538488, 2, { 831, 648 } },
    { 538560, 2, { 748, 720 } },
    { 538587, 2, { 747, 721 } },
    { 538608, 2, { 784, 687 } },
    { 538620, 2, { 764, 705 } },
    { 538650, 2, { 798, 675 } },
    { 538704, 2, { 774, 696 } },
    { 538740, 2, { 738, 730 } },
    { 538752, 2, { 736, 732 } },
    { 538896, 2, { 824, 654 } },
    { 539000, 2, { 770, 700 } },
    { 539028, 2, { 756, 713 } },
    { 539055, 2, { 891, 605 } },
    { 539070, 2, { 755, 714 } },
    { 539076, 2, { 807, 668 } },
    { 539110, 2, { 754, 715 } },
    { 539121, 2, { 961, 561 } },
    { 539136, 2, { 768, 702 } },
    { 539148, 2, { 753, 716 } },
    { 539175, 2, { 975, 553 } },
    { 539184, 2, { 752, 717 } },
    { 539220, 2, { 817, 660 } },
    { 539232, 2, { 822, 656 } },
    { 539240, 2, { 793, 680 } },
    { 539275, 2, { 925, 583 } },
    { 539280, 2, { 749, 720 } },
    { 539316, 2, { 844, 639 } },
    { 539320, 2, { 776, 695 } },
    { 539352, 2, { 792, 681 } },
    { 539400, 2, { 744, 725 } },
    { 539448, 2, { 741, 728 } },
    { 539460, 2, { 740, 729 } },
    { 539478, 2, { 738, 731 } },
    { 539484, 2, { 737, 732 } },
    { 539487, 2, { 783, 689 } },
    { 539520, 2, { 843, 640 } },
    { 539560, 2, { 820, 658 } },
    { 539616, 2, { 803, 672 } },
    { 539628, 2, { 772, 699 } },
    { 539676, 2, { 789, 684 } },
    { 539685, 2, { 895, 603 } },
    { 539695, 2, { 1235, 437 } },
    { 539700, 2, { 771, 700 } },
    { 539720, 2, { 824, 655 } },
    { 539784, 2, { 756, 714 } },
    { 539805, 2, { 795, 679 } },
    { 539832, 2, { 813, 664 } },
    { 539847, 2, { 779, 693 } },
    { 539865, 2, { 837, 645 } },
    { 539904, 2, { 768, 703 } },
    { 539955, 2, { 845, 639 } },
    { 539964, 2, { 849, 636 } },
    { 539968, 2, { 767, 704 } },
    { 540000, 2, { 750, 720 } },
    { 540056, 2, { 748, 722 } },
    { 540080, 2, { 785, 688 } },
    { 540124, 2, { 799, 676 } },
    { 540144, 2, { 744, 726 } },
    { 540155, 2, { 805, 671 } },
    { 540175, 2, { 775, 697 } },
    { 540189, 2, { 741, 729 } },
    { 540204, 2, { 763, 708 } },
    { 540265, 2, { 893, 605 } },
    { 540288, 2, { 804, 672 } },
    { 540360, 2, { 760, 711 } },
    { 540408, 2, { 759, 712 } },
    { 540432, 2, { 834, 648 } },
    { 540512, 2, { 889, 608 } },
    { 540540, 2, { 756, 715 } },
    { 540552, 2, { 808, 669 } },
    { 540600, 2, { 795, 680 } },
    { 540617, 2, { 833, 649 } },
    { 540708, 2, { 861, 628 } },
    { 540735, 2, { 767, 705 } },
    { 540750, 2, { 750, 721 } },
    { 540768, 2, { 786, 688 } },
    { 540792, 2, { 777, 696 } },
    { 540800, 2, { 800, 676 } },
    { 540804, 2, { 748, 723 } },
    { 540826, 2, { 793, 682 } },
    { 540828, 2, { 747, 724 } },
    { 540855, 2, { 765, 707 } },
    { 540870, 2, { 745, 726 } },
    { 540891, 2, { 871, 621 } },
    { 540918, 2, { 742, 729 } },
    { 540940, 2, { 740, 731 } },
    { 540960, 2, { 736, 735 } },
    { 540995, 2, { 1015, 533 } },
    { 541008, 2, { 816, 663 } },
    { 541025, 2, { 1139, 475 } },
    { 541044, 2, { 791, 684 } },
    { 541125, 2, { 925, 585 } },
    { 541160, 2, { 815, 664 } },
    { 541167, 2, { 759, 713 } },
    { 541233, 2, { 781, 693 } },
    { 541260, 2, { 873, 620 } },
    { 541310, 2, { 770, 703 } },
    { 541356, 2, { 788, 687 } },
    { 541368, 2, { 824, 657 } },
    { 541443, 2, { 1121, 483 } },
    { 541450, 2, { 833, 650 } },
    { 541464, 2, { 879, 616 } },
    { 541476, 2, { 801, 676 } },
    { 541500, 2, { 750, 722 } },
    { 541569, 2, { 777, 697 } },
    { 541575, 2, { 747, 725 } },
    { 541620, 2, { 765, 708 } },
    { 541650, 2, { 785, 690 } },
    { 541671, 2, { 741, 731 } },
    { 541695, 2, { 737, 735 } },
    { 541730, 2, { 763, 710 } },
    { 541788, 2, { 897, 604 } },
    { 541812, 2, { 831, 652 } },
    { 541836, 2, { 783, 692 } },
    { 541856, 2, { 826, 656 } },
    { 541872, 2, { 848, 639 } },
    { 541875, 2, { 867, 625 } },
    { 541880, 2, { 760, 713 } },
    { 541926, 2, { 759, 714 } },
    { 542010, 2, { 870, 623 } },
    { 542025, 2, { 803, 675 } },
    { 542052, 2, { 756, 717 } },
    { 542076, 2, { 796, 681 } },
    { 542080, 2, { 770, 704 } },
    { 542087, 2, { 851, 637 } },
    { 542100, 2, { 780, 695 } },
    { 542160, 2, { 753, 720 } },
    { 542184, 2, { 779, 696 } },
    { 542192, 2, { 752, 721 } },
    { 542225, 2, { 943, 575 } },
    { 542241, 2, { 1057, 513 } },
    { 542256, 2, { 858, 632 } },
    { 542304, 2, { 807, 672 } },
    { 542360, 2, { 745, 728 } },
    { 542370, 2, { 895, 606 } },
    { 542376, 2, { 744, 729 } },
    { 542400, 2, { 800, 678 } },
    { 542412, 2, { 741, 732 } },
    { 542424, 2, { 776, 699 } },
    { 542430, 2, { 738, 735 } },
    { 542432, 2, { 737, 736 } },
    { 542490, 2, { 845, 642 } },
    { 542493, 2, { 763, 711 } },
    { 542520, 2, { 792, 685 } },
    { 542544, 2, { 762, 712 } },
    { 542568, 2, { 888, 611 } },
    { 542640, 2, { 760, 714 } },
    { 542700, 2, { 804, 675 } },
    { 542724, 2, { 852, 637 } },
    { 542773, 2, { 931, 583 } },
    { 542784, 2, { 771, 704 } },
    { 542790, 2, { 815, 666 } },
    { 542832, 2, { 789, 688 } },
    { 542864, 2, { 917, 592 } },
    { 542880, 2, { 754, 720 } },
    { 542892, 2, { 843, 644 } },
    { 542925, 2, { 855, 635 } },
    { 542976, 2, { 768, 707 } },
    { 542997, 2, { 819, 663 } },
    { 543025, 2, { 749, 725 } },
    { 543084, 2, { 813, 668 } },
    { 543105, 2, { 745, 729 } },
    { 543120, 2, { 744, 730 } },
    { 543125, 2, { 869, 625 } },
    { 543168, 2, { 738, 736 } },
    { 543204, 2, { 764, 711 } },
    { 543213, 2, { 837, 649 } },
    { 543228, 2, { 812, 669 } },
    { 543235, 2, { 913, 595 } },
    { 543256, 2, { 763, 712 } },
    { 543286, 2, { 841, 646 } },
    { 543305, 2, { 817, 665 } },
    { 543312, 2, { 784, 693 } },
    { 543320, 2, { 799, 680 } },
    { 543345, 2, { 979, 555 } },
    { 543360, 2, { 849, 640 } },
    { 543375, 2, { 805, 675 } },
    { 543400, 2, { 760, 715 } },
    { 543444, 2, { 759, 716 } },
    { 543456, 2, { 816, 666 } },
    { 543510, 2, { 810, 671 } },
    { 543520, 2, { 790, 688 } },
    { 543552, 2, { 894, 608 } },
    { 543560, 2, { 856, 635 } },
    { 543576, 2, { 781, 696 } },
    { 543600, 2, { 755, 720 } },
    { 543660, 2, { 780, 697 } },
    { 543696, 2, { 752, 723 } },
    { 543704, 2, { 931, 584 } },
    { 543744, 2, { 768, 708 } },
    { 543750, 2, { 750, 725 } },
    { 543753, 2, { 959, 567 } },
    { 543780, 2, { 795, 684 } },
    { 543816, 2, { 747, 728 } },
    { 543837, 2, { 893, 609 } },
    { 543864, 2, { 744, 731 } },
    { 543879, 2, { 801, 679 } },
    { 543895, 2, { 899, 605 } },
    { 543900, 2, { 740, 735 } },
    { 543906, 2, { 738, 737 } },
    { 543950, 2, { 946, 575 } },
    { 543996, 2, { 828, 657 } },
    { 543998, 2, { 793, 686 } },
    { 544005, 2, { 785, 693 } },
    { 544011, 2, { 1073, 507 } },
    { 544050, 2, { 775, 702 } },
    { 544095, 2, { 963, 565 } },
    { 544104, 2, { 792, 687 } },
    { 544128, 2, { 832, 654 } },
    { 544152, 2, { 861, 632 } },
    { 544170, 2, { 935, 582 } },
    { 544185, 2, { 783, 695 } },
    { 544208, 2, { 791, 688 } },
    { 544215, 2, { 1065, 511 } },
    { 544236, 2, { 798, 682 } },
    { 544260, 2, { 772, 705 } },
    { 544320, 2, { 756, 720 } },
    { 544341, 2, { 1029, 529 } },
    { 544375, 2, { 871, 625 } },
    { 544380, 2, { 844, 645 } },
    { 544390, 2, { 770, 707 } },
    { 544401, 2, { 891, 611 } },
    { 544416, 2, { 848, 642 } },
    { 544476, 2, { 867, 628 } },
    { 544500, 2, { 750, 726 } },
    { 544544, 2, { 748, 728 } },
    { 544635, 2, { 741, 735 } },
    { 544640, 2, { 740, 736 } },
    { 544680, 2, { 765, 712 } },
    { 544712, 2, { 959, 568 } },
    { 544726, 2, { 949, 574 } },
    { 544752, 2, { 776, 702 } },
    { 544765, 2, { 1105, 493 } },
    { 544800, 2, { 800, 681 } },
    { 544824, 2, { 828, 658 } },
    { 544825, 2, { 775, 703 } },
    { 544830, 2, { 762, 715 } },
    { 544852, 2, { 812, 671 } },
    { 544880, 2, { 784, 695 } },
    { 544896, 2, { 774, 704 } },
    { 544918, 2, { 799, 682 } },
    { 544920, 2, { 760, 717 } },
    { 544950, 2, { 865, 630 } },
    { 544960, 2, { 832, 655 } },
    { 544968, 2, { 783, 696 } },
    { 544980, 2, { 879, 620 } },
    { 545000, 2, { 872, 625 } },
    { 545076, 2, { 756, 721 } },
    { 545105, 2, { 901, 605 } },
    { 545125, 2, { 875, 623 } },
    { 545136, 2, { 831, 656 } },
    { 545160, 2, { 770, 708 } },
    { 545172, 2, { 753, 724 } },
    { 545200, 2, { 752, 725 } },
    { 545220, 2, { 780, 699 } },
    { 545259, 2, { 1023, 533 } },
    { 545272, 2, { 749, 728 } },
    { 545280, 2, { 768, 710 } },
    { 545292, 2, { 748, 729 } },
    { 545300, 2, { 779, 700 } },
    { 545340, 2, { 745, 732 } },
    { 545370, 2, { 742, 735 } },
    { 545376, 2, { 741, 736 } },
    { 545380, 2, { 740, 737 } },
    { 545400, 2, { 808, 675 } },
    { 545412, 2, { 903, 604 } },
    { 545445, 2, { 765, 713 } },
    { 545454, 2, { 777, 702 } },
    { 545490, 2, { 855, 638 } },
    { 545532, 2, { 807, 676 } },
    { 545584, 2, { 793, 688 } },
    { 545600, 2, { 775, 704 } },
    { 545625, 2, { 873, 625 } },
    { 545670, 2, { 774, 705 } },
    { 545675, 2, { 949, 575 } },
    { 545688, 2, { 792, 689 } },
    { 545713, 2, { 1591, 343 } },
    { 545715, 2, { 905, 603 } },
    { 545724, 2, { 837, 652 } },
    { 545748, 2, { 876, 623 } },
    { 545751, 2, { 783, 697 } },
    { 545790, 2, { 791, 690 } },
    { 545808, 2, { 822, 664 } },
    { 545832, 2, { 756, 722 } },
    { 545868, 2, { 771, 708 } },
    { 545870, 2, { 845, 646 } },
    { 545904, 2, { 816, 669 } },
    { 545916, 2, { 804, 679 } },
    { 545928, 2, { 989, 552 } },
    { 545952, 2, { 752, 726 } },
    { 545972, 2, { 868, 629 } },
    { 545988, 2, { 789, 692 } },
    { 546000, 2, { 750, 728 } },
    { 546021, 2, { 749, 729 } },
    { 546048, 2, { 768, 711 } },
    { 546084, 2, { 788, 693 } },
    { 546090, 2, { 835, 654 } },
    { 546112, 2, { 742, 736 } },
    { 546250, 2, { 874, 625 } },
    { 546264, 2, { 843, 648 } },
    { 546270, 2, { 786, 695 } },
    { 546273, 2, { 819, 667 } },
    { 546312, 2, { 824, 663 } },
    { 546315, 2, { 847, 645 } },
    { 546336, 2, { 813, 672 } },
    { 546360, 2, { 785, 696 } },
    { 546416, 2, { 923, 592 } },
    { 546448, 2, { 784, 697 } },
    { 546480, 2, { 759, 720 } },
    { 546516, 2, { 799, 684 } },
    { 546560, 2, { 854, 640 } },
    { 546588, 2, { 756, 723 } },
    { 546592, 2, { 899, 608 } },
    { 546624, 2, { 832, 657 } },
    { 546630, 2, { 798, 685 } },
    { 546750, 2, { 750, 729 } },
    { 546756, 2, { 849, 644 } },
    { 546770, 2, { 749, 730 } },
    { 546788, 2, { 748, 731 } },
    { 546804, 2, { 747, 732 } },
    { 546840, 2, { 744, 735 } },
    { 546852, 2, { 796, 687 } },
    { 546854, 2, { 742, 737 } },
    { 546920, 2, { 904, 605 } },
    { 546960, 2, { 795, 688 } },
    { 546975, 2, { 765, 715 } },
    { 547008, 2, { 777, 704 } },
    { 547056, 2, { 786, 696 } },
    { 547080, 2, { 776, 705 } },
    { 547092, 2, { 819, 668 } },
    { 547104, 2, { 834, 656 } },
    { 547162, 2, { 847, 646 } },
    { 547170, 2, { 793, 690 } },
    { 547200, 2, { 760, 720 } },
    { 547218, 2, { 774, 707 } },
    { 547225, 2, { 1325, 413 } },
    { 547230, 2, { 870, 629 } },
    { 547281, 2, { 833, 657 } },
    { 547400, 2, { 782, 700 } },
    { 547404, 2, { 754, 726 } },
    { 547520, 2, { 928, 590 } },
    { 547524, 2, { 804, 681 } },
    { 547584, 2, { 744, 736 } },
    { 547596, 2, { 742, 738 } },
    { 547624, 2, { 889, 616 } },
    { 547638, 2, { 767, 714 } },
    { 547680, 2, { 815, 672 } },
    { 547740, 2, { 765, 716 } },
    { 547788, 2, { 764, 717 } },
    { 547800, 2, { 825, 664 } },
    { 547820, 2, { 860, 637 } },
    { 547824, 2, { 808, 678 } },
    { 547884, 2, { 801, 684 } },
    { 547925, 2, { 775, 707 } },
    { 547944, 2, { 867, 632 } },
    { 547960, 2, { 760, 721 } },
    { 547965, 2, { 891, 615 } },
    { 548000, 2, { 800, 685 } },
    { 548016, 2, { 784, 699 } },
    { 548020, 2, { 940, 583 } },
    { 548044, 2, { 851, 644 } },
    { 548080, 2, { 806, 680 } },
    { 548100, 2, { 756, 725 } },
    { 548114, 2, { 799, 686 } },
    { 548130, 2, { 755, 726 } },
    { 548163, 2, { 791, 693 } },
    { 548184, 2, { 753, 728 } },
    { 548208, 2, { 752, 729 } },
    { 548235, 2, { 837, 655 } },
    { 548244, 2, { 873, 628 } },
    { 548250, 2, { 750, 731 } },
    { 548262, 2, { 781, 702 } },
    { 548268, 2, { 749, 732 } },
    { 548320, 2, { 745, 736 } },
    { 548328, 2, { 744, 737 } },
    { 548340, 2, { 741, 740 } },
    { 548352, 2, { 768, 714 } },
    { 548359, 2, { 931, 589 } },
    { 548405, 2, { 767, 715 } },
    { 548416, 2, { 779, 704 } },
    { 548430, 2, { 905, 606 } },
    { 548460, 2, { 831, 660 } },
    { 548496, 2, { 879, 624 } },
    { 548580, 2, { 820, 669 } },
    { 548595, 2, { 835, 657 } },
    { 548625, 2, { 825, 665 } },
    { 548632, 2, { 776, 707 } },
    { 548640, 2, { 762, 720 } },
    { 548685, 2, { 801, 685 } },
    { 548700, 2, { 775, 708 } },
    { 548709, 2, { 901, 609 } },
    { 548760, 2, { 807, 680 } },
    { 548784, 2, { 824, 666 } },
    { 548856, 2, { 756, 726 } },
    { 548892, 2, { 772, 711 } },
    { 548912, 2, { 754, 728 } },
    { 548952, 2, { 771, 712 } },
    { 548960, 2, { 752, 730 } },
    { 548964, 2, { 782, 702 } },
    { 549010, 2, { 770, 713 } },
    { 549024, 2, { 798, 688 } },
    { 549054, 2, { 846, 649 } },
    { 549072, 2, { 744, 738 } },
    { 549080, 2, { 742, 740 } },
    { 549100, 2, { 850, 646 } },
    { 549120, 2, { 768, 715 } },
    { 549144, 2, { 789, 696 } },
    { 549185, 2, { 923, 595 } },
    { 549252, 2, { 803, 684 } },
    { 549325, 2, { 1075, 511 } },
    { 549360, 2, { 763, 720 } },
    { 549423, 2, { 969, 567 } },
    { 549444, 2, { 844, 651 } },
    { 549450, 2, { 814, 675 } },
    { 549480, 2, { 760, 723 } },
    { 549516, 2, { 759, 724 } },
    { 549540, 2, { 774, 710 } },
    { 549549, 2, { 793, 693 } },
    { 549575, 2, { 1157, 475 } },
    { 549585, 2, { 885, 621 } },
    { 549588, 2, { 813, 676 } },
    { 549600, 2, { 800, 687 } },
    { 549626, 2, { 913, 602 } },
    { 549636, 2, { 843, 652 } },
    { 549640, 2, { 755, 728 } },
    { 549666, 2, { 754, 729 } },
    { 549746, 2, { 782, 703 } },
    { 549780, 2, { 748, 735 } },
    { 549792, 2, { 747, 736 } },
    { 549810, 2, { 745, 738 } },
    { 549824, 2, { 781, 704 } },
    { 549840, 2, { 790, 696 } },
    { 549900, 2, { 780, 705 } },
    { 549945, 2, { 909, 605 } },
    { 549990, 2, { 810, 679 } },
    { 550000, 2, { 880, 625 } },
    { 550056, 2, { 984, 559 } },
    { 550116, 2, { 777, 708 } },
    { 550125, 2, { 815, 675 } },
    { 550137, 2, { 1139, 483 } },
    { 550140, 2, { 795, 692 } },
    { 550152, 2, { 849, 648 } },
    { 550188, 2, { 899, 612 } },
    { 550220, 2, { 820, 671 } },
    { 550248, 2, { 808, 681 } },
    { 550352, 2, { 848, 649 } },
    { 550368, 2, { 756, 728 } },
    { 550375, 2, { 875, 629 } },
    { 550395, 2, { 755, 729 } },
    { 550440, 2, { 792, 695 } },
    { 550449, 2, { 783, 703 } },
    { 550464, 2, { 752, 732 } },
    { 550515, 2, { 749, 735 } },
    { 550525, 2, { 1159, 475 } },
    { 550536, 2, { 791, 696 } },
    { 550550, 2, { 770, 715 } },
    { 550560, 2, { 744, 740 } },
    { 550605, 2, { 781, 705 } },
    { 550656, 2, { 768, 717 } },
    { 550704, 2, { 894, 616 } },
    { 550715, 2, { 935, 589 } },
    { 550740, 2, { 804, 685 } },
    { 550746, 2, { 837, 658 } },
    { 550788, 2, { 948, 581 } },
    { 550800, 2, { 765, 720 } },
    { 550812, 2, { 788, 699 } },
    { 550830, 2, { 854, 645 } },
    { 550848, 2, { 906, 608 } },
    { 550858, 2, { 803, 686 } },
    { 551000, 2, { 760, 725 } },
    { 551025, 2, { 775, 711 } },
    { 551040, 2, { 820, 672 } },
    { 551070, 2, { 785, 702 } },
    { 551075, 2, { 1175, 469 } },
    { 551088, 2, { 774, 712 } },
    { 551100, 2, { 825, 668 } },
    { 551122, 2, { 902, 611 } },
    { 551124, 2, { 756, 729 } },
    { 551152, 2, { 784, 703 } },
    { 551174, 2, { 754, 731 } },
    { 551196, 2, { 753, 732 } },
    { 551200, 2, { 800, 689 } },
    { 551232, 2, { 783, 704 } },
    { 551250, 2, { 750, 735 } },
    { 551256, 2, { 824, 669 } },
    { 551264, 2, { 749, 736 } },
    { 551304, 2, { 744, 741 } },
    { 551355, 2, { 885, 623 } },
    { 551412, 2, { 867, 636 } },
    { 551460, 2, { 780, 707 } },
    { 551475, 2, { 817, 675 } },
    { 551551, 2, { 1001, 551 } },
    { 551565, 2, { 765, 721 } },
    { 551628, 2, { 796, 693 } },
    { 551650, 2, { 850, 649 } },
    { 551691, 2, { 973, 567 } },
    { 551733, 2, { 903, 611 } },
    { 551736, 2, { 776, 711 } },
    { 551760, 2, { 760, 726 } },
    { 551784, 2, { 831, 664 } },
    { 551800, 2, { 775, 712 } },
    { 551880, 2, { 756, 730 } },
    { 551988, 2, { 807, 684 } },
    { 552000, 2, { 750, 736 } },
    { 552012, 2, { 879, 628 } },
    { 552015, 2, { 783, 705 } },
    { 552036, 2, { 771, 716 } },
    { 552048, 2, { 744, 742 } },
    { 552069, 2, { 889, 621 } },
    { 552120, 2, { 856, 645 } },
    { 552123, 2, { 1089, 507 } },
    { 552156, 2, { 979, 564 } },
    { 552160, 2, { 812, 680 } },
    { 552240, 2, { 767, 720 } },
    { 552276, 2, { 828, 667 } },
    { 552292, 2, { 817, 676 } },
    { 552300, 2, { 789, 700 } },
    { 552330, 2, { 765, 722 } },
    { 552348, 2, { 804, 687 } },
    { 552372, 2, { 764, 723 } },
    { 552384, 2, { 822, 672 } },
    { 552420, 2, { 810, 682 } },
    { 552450, 2, { 762, 725 } },
    { 552464, 2, { 803, 688 } },
    { 552475, 2, { 1025, 539 } },
    { 552552, 2, { 759, 728 } },
    { 552570, 2, { 815, 678 } },
    { 552630, 2, { 845, 654 } },
    { 552636, 2, { 756, 731 } },
    { 552640, 2, { 785, 704 } },
    { 552660, 2, { 755, 732 } },
    { 552664, 2, { 973, 568 } },
    { 552684, 2, { 869, 636 } },
    { 552720, 2, { 752, 735 } },
    { 552735, 2, { 865, 639 } },
    { 552750, 2, { 750, 737 } },
    { 552762, 2, { 749, 738 } },
    { 552780, 2, { 747, 740 } },
    { 552805, 2, { 1045, 529 } },
    { 552825, 2, { 819, 675 } },
    { 552840, 2, { 813, 680 } },
    { 552916, 2, { 806, 686 } },
    { 552948, 2, { 781, 708 } },
    { 552951, 2, { 917, 603 } },
    { 552960, 2, { 768, 720 } },
    { 552972, 2, { 812, 681 } },
    { 553008, 2, { 843, 656 } },
    { 553110, 2, { 895, 618 } },
    { 553112, 2, { 833, 664 } },
    { 553150, 2, { 851, 650 } },
    { 553152, 2, { 804, 688 } },
    { 553175, 2, { 763, 725 } },
    { 553224, 2, { 777, 712 } },
    { 553248, 2, { 816, 678 } },
    { 553311, 2, { 759, 729 } },
    { 553320, 2, { 795, 696 } },
    { 553344, 2, { 786, 704 } },
    { 553350, 2, { 775, 714 } },
    { 553410, 2, { 774, 715 } },
    { 553480, 2, { 808, 685 } },
    { 553524, 2, { 772, 717 } },
    { 553548, 2, { 849, 652 } },
    { 553553, 2, { 869, 637 } },
    { 553575, 2, { 825, 671 } },
    { 553581, 2, { 783, 707 } },
    { 553608, 2, { 792, 699 } },
    { 553644, 2, { 819, 676 } },
    { 553660, 2, { 893, 620 } },
    { 553700, 2, { 791, 700 } },
    { 553707, 2, { 799, 693 } },
    { 553720, 2, { 872, 635 } },
    { 553725, 2, { 963, 575 } },
    { 553728, 2, { 768, 721 } },
    { 553776, 2, { 834, 664 } },
    { 553784, 2, { 812, 682 } },
    { 553800, 2, { 780, 710 } },
    { 553833, 2, { 1043, 531 } },
    { 553840, 2, { 805, 688 } },
    { 553850, 2, { 950, 583 } },
    { 553860, 2, { 765, 724 } },
    { 553932, 2, { 828, 669 } },
    { 554040, 2, { 760, 729 } },
    { 554064, 2, { 776, 714 } },
    { 554112, 2, { 832, 666 } },
    { 554190, 2, { 754, 735 } },
    { 554200, 2, { 815, 680 } },
    { 554208, 2, { 753, 736 } },
    { 554224, 2, { 752, 737 } },
    { 554246, 2, { 826, 671 } },
    { 554260, 2, { 749, 740 } },
    { 554265, 2, { 981, 565 } },
    { 554268, 2, { 748, 741 } },
    { 554280, 2, { 745, 744 } },
    { 554288, 2, { 784, 707 } },
    { 554292, 2, { 801, 692 } },
    { 554355, 2, { 873, 635 } },
    { 554364, 2, { 783, 708 } },
    { 554400, 2, { 770, 720 } },
    { 554484, 2, { 861, 644 } },
    { 554496, 2, { 768, 722 } },
    { 554508, 2, { 844, 657 } },
    { 554553, 2, { 893, 621 } },
    { 554580, 2, { 780, 711 } },
    { 554592, 2, { 848, 654 } },
    { 554610, 2, { 798, 695 } },
    { 554625, 2, { 765, 725 } },
    { 554645, 2, { 805, 689 } },
    { 554652, 2, { 852, 651 } },
    { 554736, 2, { 762, 728 } },
    { 554827, 2, { 871, 637 } },
    { 554829, 2, { 759, 731 } },
    { 554840, 2, { 776, 715 } },
    { 554850, 2, { 810, 685 } },
    { 554895, 2, { 855, 649 } },
    { 554944, 2, { 754, 736 } },
    { 554976, 2, { 752, 738 } },
    { 555060, 2, { 841, 660 } },
    { 555072, 2, { 784, 708 } },
    { 555096, 2, { 808, 687 } },
    { 555100, 2, { 793, 700 } },
    { 555108, 2, { 831, 668 } },
    { 555120, 2, { 771, 720 } },
    { 555165, 2, { 845, 657 } },
    { 555170, 2, { 770, 721 } },
    { 555216, 2, { 807, 688 } },
    { 555228, 2, { 873, 636 } },
    { 555264, 2, { 768, 723 } },
    { 555282, 2, { 791, 702 } },
    { 555296, 2, { 938, 592 } },
    { 555330, 2, { 865, 642 } },
    { 555408, 2, { 798, 696 } },
    { 555440, 2, { 848, 655 } },
    { 555450, 2, { 805, 690 } },
    { 555456, 2, { 789, 704 } },
    { 555458, 2, { 961, 578 } },
    { 555464, 2, { 763, 728 } },
    { 555520, 2, { 868, 640 } },
    { 555528, 2, { 879, 632 } },
    { 555540, 2, { 788, 705 } },
    { 555560, 2, { 760, 731 } },
    { 555588, 2, { 759, 732 } },
    { 555611, 2, { 833, 667 } },
    { 555632, 2, { 847, 656 } },
    { 555646, 2, { 923, 602 } },
    { 555660, 2, { 756, 735 } },
    { 555680, 2, { 755, 736 } },
    { 555696, 2, { 816, 681 } },
    { 555750, 2, { 750, 741 } },
    { 555765, 2, { 1005, 553 } },
    { 555768, 2, { 747, 744 } },
    { 555775, 2, { 1075, 517 } },
    { 555780, 2, { 785, 708 } },
    { 555795, 2, { 895, 621 } },
    { 555810, 2, { 955, 582 } },
    { 555930, 2, { 783, 710 } },
    { 555940, 2, { 770, 722 } },
    { 555984, 2, { 792, 702 } },
    { 556000, 2, { 800, 695 } },
    { 556017, 2, { 913, 609 } },
    { 556036, 2, { 884, 629 } },
    { 556075, 2, { 767, 725 } },
    { 556092, 2, { 813, 684 } },
    { 556101, 2, { 819, 679 } },
    { 556104, 2, { 799, 696 } },
    { 556110, 2, { 835, 666 } },
    { 556140, 2, { 780, 713 } },
    { 556160, 2, { 790, 704 } },
    { 556200, 2, { 824, 675 } },
    { 556206, 2, { 779, 714 } },
    { 556227, 2, { 763, 729 } },
    { 556248, 2, { 903, 616 } },
    { 556308, 2, { 909, 612 } },
    { 556332, 2, { 777, 716 } },
    { 556380, 2, { 843, 660 } },
    { 556392, 2, { 776, 717 } },
    { 556404, 2, { 796, 699 } },
    { 556416, 2, { 756, 736 } },
    { 556479, 2, { 803, 693 } },
    { 556500, 2, { 750, 742 } },
    { 556515, 2, { 747, 745 } },
    { 556600, 2, { 920, 605 } },
    { 556605, 2, { 837, 665 } },
    { 556608, 2, { 832, 669 } },
    { 556640, 2, { 784, 710 } },
    { 556686, 2, { 793, 702 } },
    { 556695, 2, { 801, 695 } },
    { 556738, 2, { 874, 637 } },
    { 556776, 2, { 792, 703 } },
    { 556780, 2, { 820, 679 } },
    { 556800, 2, { 768, 725 } },
    { 556842, 2, { 767, 726 } },
    { 556850, 2, { 925, 602 } },
    { 556864, 2, { 791, 704 } },
    { 556875, 2, { 825, 675 } },
    { 556920, 2, { 765, 728 } },
    { 556944, 2, { 849, 656 } },
    { 556956, 2, { 764, 729 } },
    { 556985, 2, { 779, 715 } },
    { 556990, 2, { 763, 730 } },
    { 557136, 2, { 848, 657 } },
    { 557172, 2, { 756, 737 } },
    { 557190, 2, { 755, 738 } },
    { 557194, 2, { 817, 682 } },
    { 557220, 2, { 753, 740 } },
    { 557232, 2, { 752, 741 } },
    { 557256, 2, { 749, 744 } },
    { 557280, 2, { 774, 720 } },
    { 557375, 2, { 875, 637 } },
    { 557424, 2, { 784, 711 } },
    { 557440, 2, { 832, 670 } },
    { 557460, 2, { 815, 684 } },
    { 557496, 2, { 783, 712 } },
    { 557520, 2, { 808, 690 } },
    { 557536, 2, { 917, 608 } },
    { 557550, 2, { 826, 675 } },
    { 557566, 2, { 782, 713 } },
    { 557568, 2, { 768, 726 } },
    { 557583, 2, { 841, 663 } },
    { 557600, 2, { 800, 697 } },
    { 557612, 2, { 836, 667 } },
    { 557634, 2, { 781, 714 } },
    { 557655, 2, { 791, 705 } },
    { 557685, 2, { 765, 729 } },
    { 557700, 2, { 780, 715 } },
    { 557760, 2, { 830, 672 } },
    { 557775, 2, { 925, 603 } },
    { 557844, 2, { 812, 687 } },
    { 557856, 2, { 894, 624 } },
    { 557865, 2, { 759, 735 } },
    { 557984, 2, { 752, 742 } },
    { 558000, 2, { 750, 744 } },
    { 558012, 2, { 876, 637 } },
    { 558054, 2, { 774, 721 } },
    { 558090, 2, { 795, 702 } },
    { 558096, 2, { 906, 616 } },
    { 558110, 2, { 833, 670 } },
    { 558125, 2, { 893, 625 } },
    { 558135, 2, { 785, 711 } },
    { 558140, 2, { 860, 649 } },
    { 558144, 2, { 816, 684 } },
    { 558156, 2, { 772, 723 } },
    { 558204, 2, { 771, 724 } },
    { 558272, 2, { 793, 704 } },
    { 558279, 2, { 783, 713 } },
    { 558348, 2, { 782, 714 } },
    { 558360, 2, { 792, 705 } },
    { 558376, 2, { 767, 728 } },
    { 558404, 2, { 814, 686 } },
    { 558420, 2, { 820, 681 } },
    { 558432, 2, { 831, 672 } },
    { 558441, 2, { 999, 559 } },
    { 558444, 2, { 807, 692 } },
    { 558467, 2, { 1547, 361 } },
    { 558516, 2, { 763, 732 } },
    { 558530, 2, { 790, 707 } },
    { 558558, 2, { 806, 693 } },
    { 558600, 2, { 760, 735 } },
    { 558612, 2, { 789, 708 } },
    { 558620, 2, { 901, 620 } },
    { 558624, 2, { 759, 736 } },
    { 558657, 2, { 891, 627 } },
    { 558672, 2, { 824, 678 } },
    { 558675, 2, { 955, 585 } },
    { 558750, 2, { 750, 745 } },
    { 558756, 2, { 748, 747 } },
    { 558775, 2, { 775, 721 } },
    { 558780, 2, { 804, 695 } },
    { 558789, 2, { 861, 649 } },
    { 558800, 2, { 880, 635 } },
    { 558888, 2, { 803, 696 } },
    { 558900, 2, { 810, 690 } },
    { 558912, 2, { 852, 656 } },
    { 558920, 2, { 785, 712 } },
    { 558943, 2, { 833, 671 } },
    { 558960, 2, { 816, 685 } },
    { 558992, 2, { 784, 713 } },
    { 559044, 2, { 879, 636 } },
    { 559065, 2, { 793, 705 } },
    { 559104, 2, { 768, 728 } },
    { 559116, 2, { 837, 668 } },
    { 559125, 2, { 875, 639 } },
    { 559130, 2, { 782, 715 } },
    { 559143, 2, { 767, 729 } },
    { 559200, 2, { 800, 699 } },
    { 559215, 2, { 765, 731 } },
    { 559260, 2, { 780, 717 } },
    { 559265, 2, { 841, 665 } },
    { 559284, 2, { 836, 669 } },
    { 559290, 2, { 905, 618 } },
    { 559300, 2, { 799, 700 } },
    { 559320, 2, { 790, 708 } },
    { 559344, 2, { 813, 688 } },
    { 559440, 2, { 756, 740 } },
    { 559496, 2, { 776, 721 } },
    { 559503, 2, { 749, 747 } },
    { 559521, 2, { 901, 621 } },
    { 559548, 2, { 891, 628 } },
    { 559559, 2, { 1001, 559 } },
    { 559572, 2, { 844, 663 } },
    { 559629, 2, { 987, 567 } },
    { 559632, 2, { 786, 712 } },
    { 559636, 2, { 869, 644 } },
    { 559650, 2, { 861, 650 } },
    { 559674, 2, { 1003, 558 } },
    { 559680, 2, { 795, 704 } },
    { 559752, 2, { 843, 664 } },
    { 559764, 2, { 852, 657 } },
    { 559776, 2, { 784, 714 } },
    { 559797, 2, { 1159, 483 } },
    { 559824, 2, { 856, 654 } },
    { 559845, 2, { 783, 715 } },
    { 559860, 2, { 860, 651 } },
    { 559872, 2, { 768, 729 } },
    { 559911, 2, { 893, 627 } },
    { 559944, 2, { 792, 707 } },
    { 559980, 2, { 765, 732 } },
    { 560000, 2, { 800, 700 } },
    { 560025, 2, { 855, 655 } },
    { 560028, 2, { 791, 708 } },
    { 560056, 2, { 959, 584 } },
    { 560120, 2, { 760, 737 } },
    { 560175, 2, { 825, 679 } },
    { 560196, 2, { 756, 741 } },
    { 560224, 2, { 854, 656 } },
    { 560232, 2, { 753, 744 } },
    { 560240, 2, { 752, 745 } },
    { 560268, 2, { 788, 711 } },
    { 560280, 2, { 805, 696 } },
    { 560340, 2, { 849, 660 } },
    { 560439, 2, { 891, 629 } },
    { 560448, 2, { 834, 672 } },
    { 560462, 2, { 817, 686 } },
    { 560490, 2, { 785, 714 } },
    { 560505, 2, { 869, 645 } },
    { 560550, 2, { 925, 606 } },
    { 560592, 2, { 816, 687 } },
    { 560625, 2, { 897, 625 } },
    { 560628, 2, { 783, 716 } },
    { 560640, 2, { 768, 730 } },
    { 560680, 2, { 856, 655 } },
    { 560700, 2, { 801, 700 } },
    { 560720, 2, { 815, 688 } },
    { 560763, 2, { 903, 621 } },
    { 560790, 2, { 837, 670 } },
    { 560805, 2, { 763, 735 } },
    { 560832, 2, { 762, 736 } },
    { 560835, 2, { 927, 605 } },
    { 560846, 2, { 814, 689 } },
    { 560880, 2, { 760, 738 } },
    { 560898, 2, { 799, 702 } },
    { 560924, 2, { 871, 644 } },
    { 560945, 2, { 1085, 517 } },
    { 560952, 2, { 756, 742 } },
    { 561000, 2, { 750, 748 } },
    { 561015, 2, { 819, 685 } },
    { 561048, 2, { 776, 723 } },
    { 561085, 2, { 805, 697 } },
    { 561120, 2, { 835, 672 } },
    { 561144, 2, { 824, 681 } },
    { 561150, 2, { 774, 725 } },
    { 561180, 2, { 796, 705 } },
    { 561184, 2, { 923, 608 } },
    { 561249, 2, { 1053, 533 } },
    { 561267, 2, { 1057, 531 } },
    { 561288, 2, { 771, 728 } },
    { 561330, 2, { 770, 729 } },
    { 561372, 2, { 861, 652 } },
    { 561393, 2, { 931, 603 } },
    { 561408, 2, { 768, 731 } },
    { 561440, 2, { 880, 638 } },
    { 561495, 2, { 913, 615 } },
    { 561540, 2, { 764, 735 } },
    { 561560, 2, { 808, 695 } },
    { 561561, 2, { 847, 663 } },
    { 561568, 2, { 763, 736 } },
    { 561600, 2, { 780, 720 } },
    { 561610, 2, { 791, 710 } },
    { 561627, 2, { 837, 671 } },
    { 561630, 2, { 965, 582 } },
    { 561660, 2, { 759, 740 } },
    { 561672, 2, { 807, 696 } },
    { 561680, 2, { 826, 680 } },
    { 561720, 2, { 755, 744 } },
    { 561744, 2, { 752, 747 } },
    { 561750, 2, { 750, 749 } },
    { 561756, 2, { 831, 676 } },
    { 561768, 2, { 789, 712 } },
    { 561782, 2, { 806, 697 } },
    { 561792, 2, { 798, 704 } },
    { 561795, 2, { 871, 645 } },
    { 561808, 2, { 949, 592 } },
    { 561816, 2, { 867, 648 } },
    { 561848, 2, { 889, 632 } },
    { 561960, 2, { 840, 669 } },
    { 561990, 2, { 786, 715 } },
    { 561996, 2, { 804, 699 } },
    { 562005, 2, { 905, 621 } },
    { 562065, 2, { 795, 707 } },
    { 562107, 2, { 923, 609 } },
    { 562120, 2, { 920, 611 } },
    { 562128, 2, { 784, 717 } },
    { 562176, 2, { 768, 732 } },
    { 562185, 2, { 961, 585 } },
    { 562212, 2, { 828, 679 } },
    { 562224, 2, { 816, 689 } },
    { 562320, 2, { 781, 720 } },
    { 562350, 2, { 815, 690 } },
    { 562380, 2, { 780, 721 } },
    { 562392, 2, { 856, 657 } },
    { 562401, 2, { 791, 711 } },
    { 562408, 2, { 847, 664 } },
    { 562520, 2, { 820, 686 } },
    { 562548, 2, { 777, 724 } },
    { 562560, 2, { 879, 640 } },
    { 562596, 2, { 813, 692 } },
    { 562600, 2, { 776, 725 } },
    { 562650, 2, { 775, 726 } },
    { 562716, 2, { 812, 693 } },
    { 562770, 2, { 845, 666 } },
    { 562788, 2, { 772, 729 } },
    { 562848, 2, { 858, 656 } },
    { 562860, 2, { 795, 708 } },
    { 562870, 2, { 770, 731 } },
    { 562925, 2, { 979, 575 } },
    { 562950, 2, { 810, 695 } },
    { 563040, 2, { 765, 736 } },
    { 563094, 2, { 763, 738 } },
    { 563112, 2, { 792, 711 } },
    { 563124, 2, { 843, 668 } },
    { 563125, 2, { 901, 625 } },
    { 563160, 2, { 760, 741 } },
    { 563192, 2, { 791, 712 } },
    { 563220, 2, { 756, 745 } },
    { 563244, 2, { 753, 748 } },
    { 563248, 2, { 752, 749 } },
    { 563316, 2, { 897, 628 } },
    { 563325, 2, { 777, 725 } },
    { 563340, 2, { 820, 687 } },
    { 563376, 2, { 776, 726 } },
    { 563472, 2, { 774, 728 } },
    { 563500, 2, { 805, 700 } },
    { 563570, 2, { 830, 679 } },
    { 563580, 2, { 909, 620 } },
    { 563584, 2, { 896, 629 } },
    { 563615, 2, { 845, 667 } },
    { 563625, 2, { 835, 675 } },
    { 563640, 2, { 770, 732 } },
    { 563673, 2, { 899, 627 } },
    { 563706, 2, { 803, 702 } },
    { 563730, 2, { 817, 690 } },
    { 563736, 2, { 849, 664 } },
    { 563745, 2, { 767, 735 } },
    { 563750, 2, { 902, 625 } },
    { 563760, 2, { 783, 720 } },
    { 563787, 2, { 1099, 513 } },
    { 563805, 2, { 765, 737 } },
    { 563850, 2, { 895, 630 } },
    { 563868, 2, { 828, 681 } },
    { 563914, 2, { 943, 598 } },
    { 563920, 2, { 760, 742 } },
    { 563940, 2, { 780, 723 } },
    { 563985, 2, { 755, 747 } },
    { 563992, 2, { 754, 748 } },
    { 564000, 2, { 752, 750 } },
    { 564075, 2, { 981, 575 } },
    { 564096, 2, { 832, 678 } },
    { 564200, 2, { 775, 728 } },
    { 564213, 2, { 851, 663 } },
    { 564291, 2, { 819, 689 } },
    { 564300, 2, { 825, 684 } },
    { 564372, 2, { 771, 732 } },
    { 564435, 2, { 999, 565 } },
    { 564440, 2, { 824, 685 } },
    { 564480, 2, { 768, 735 } },
    { 564512, 2, { 767, 736 } },
    { 564525, 2, { 965, 585 } },
    { 564543, 2, { 783, 721 } },
    { 564620, 2, { 763, 740 } },
    { 564630, 2, { 870, 649 } },
    { 564636, 2, { 844, 669 } },
    { 564655, 2, { 949, 595 } },
    { 564696, 2, { 759, 744 } },
    { 564732, 2, { 756, 747 } },
    { 564768, 2, { 848, 666 } },
    { 564775, 2, { 779, 725 } },
    { 564792, 2, { 808, 699 } },
    { 564795, 2, { 815, 693 } },
    { 564816, 2, { 861, 656 } },
    { 564872, 2, { 917, 616 } },
    { 564876, 2, { 852, 663 } },
    { 564900, 2, { 807, 700 } },
    { 564924, 2, { 789, 716 } },
    { 564927, 2, { 901, 627 } },
    { 564949, 2, { 847, 667 } },
    { 564975, 2, { 775, 729 } },
    { 564980, 2, { 820, 689 } },
    { 564996, 2, { 788, 717 } },
    { 565000, 2, { 904, 625 } },
    { 565008, 2, { 894, 632 } },
    { 565020, 2, { 774, 730 } },
    { 565056, 2, { 864, 654 } },
    { 565080, 2, { 831, 680 } },
    { 565110, 2, { 805, 702 } },
    { 565175, 2, { 925, 611 } },
    { 565200, 2, { 785, 720 } },
    { 565250, 2, { 850, 665 } },
    { 565264, 2, { 784, 721 } },
    { 565284, 2, { 867, 652 } },
    { 565312, 2, { 803, 704 } },
    { 565344, 2, { 906, 624 } },
    { 565488, 2, { 756, 748 } },
    { 565500, 2, { 754, 750 } },
    { 565536, 2, { 822, 688 } },
    { 565554, 2, { 779, 726 } },
    { 565600, 2, { 800, 707 } },
    { 565656, 2, { 777, 728 } },
    { 565704, 2, { 776, 729 } },
    { 565710, 2, { 865, 654 } },
    { 565719, 2, { 869, 651 } },
    { 565760, 2, { 832, 680 } },
    { 565775, 2, { 1325, 427 } },
    { 565785, 2, { 891, 635 } },
    { 565812, 2, { 806, 702 } },
    { 565848, 2, { 813, 696 } },
    { 565880, 2, { 860, 658 } },
    { 565915, 2, { 805, 703 } },
    { 565920, 2, { 786, 720 } },
    { 565956, 2, { 796, 711 } },
    { 565964, 2, { 812, 697 } },
    { 566016, 2, { 768, 737 } },
    { 566040, 2, { 795, 712 } },
    { 566046, 2, { 767, 738 } },
    { 566048, 2, { 784, 722 } },
    { 566076, 2, { 879, 644 } },
    { 566080, 2, { 928, 610 } },
    { 566088, 2, { 824, 687 } },
    { 566100, 2, { 765, 740 } },
    { 566115, 2, { 803, 705 } },
    { 566124, 2, { 764, 741 } },
    { 566130, 2, { 835, 678 } },
    { 566181, 2, { 817, 693 } },
    { 566200, 2, { 760, 745 } },
    { 566202, 2, { 793, 714 } },
    { 566225, 2, { 781, 725 } },
    { 566244, 2, { 756, 749 } },
    { 566250, 2, { 755, 750 } },
    { 566256, 2, { 753, 752 } },
    { 566307, 2, { 801, 707 } },
    { 566370, 2, { 870, 651 } },
    { 566400, 2, { 800, 708 } },
    { 566433, 2, { 777, 729 } },
    { 566440, 2, { 833, 680 } },
    { 566475, 2, { 975, 581 } },
    { 566496, 2, { 843, 672 } },
    { 566525, 2, { 775, 731 } },
    { 566544, 2, { 814, 696 } },
    { 566559, 2, { 1071, 529 } },
    { 566592, 2, { 832, 681 } },
    { 566610, 2, { 935, 606 } },
    { 566618, 2, { 806, 703 } },
    { 566676, 2, { 891, 636 } },
    { 566720, 2, { 770, 736 } },
    { 566748, 2, { 819, 692 } },
    { 566784, 2, { 768, 738 } },
    { 566820, 2, { 804, 705 } },
    { 566825, 2, { 1025, 553 } },
    { 566832, 2, { 784, 723 } },
    { 566865, 2, { 765, 741 } },
    { 566892, 2, { 783, 724 } },
    { 566904, 2, { 897, 632 } },
    { 566928, 2, { 762, 744 } },
    { 566930, 2, { 890, 637 } },
    { 566995, 2, { 793, 715 } },
    { 567000, 2, { 756, 750 } },
    { 567021, 2, { 871, 651 } },
    { 567084, 2, { 903, 628 } },
    { 567108, 2, { 801, 708 } },
    { 567112, 2, { 779, 728 } },
    { 567120, 2, { 816, 695 } },
    { 567132, 2, { 849, 668 } },
    { 567216, 2, { 808, 702 } },
    { 567240, 2, { 815, 696 } },
    { 567270, 2, { 955, 594 } },
    { 567300, 2, { 775, 732 } },
    { 567312, 2, { 848, 669 } },
    { 567336, 2, { 921, 616 } },
    { 567358, 2, { 814, 697 } },
    { 567385, 2, { 1015, 559 } },
    { 567420, 2, { 772, 735 } },
    { 567424, 2, { 806, 704 } },
    { 567456, 2, { 771, 736 } },
    { 567490, 2, { 770, 737 } },
    { 567528, 2, { 856, 663 } },
    { 567580, 2, { 767, 740 } },
    { 567588, 2, { 812, 699 } },
    { 567600, 2, { 825, 688 } },
    { 567630, 2, { 765, 742 } },
    { 567645, 2, { 923, 615 } },
    { 567648, 2, { 864, 657 } },
    { 567666, 2, { 846, 671 } },
    { 567672, 2, { 763, 744 } },
    { 567675, 2, { 783, 725 } },
    { 567690, 2, { 762, 745 } },
    { 567720, 2, { 760, 747 } },
    { 567728, 2, { 959, 592 } },
    { 567732, 2, { 759, 748 } },
    { 567760, 2, { 755, 752 } },
    { 567800, 2, { 835, 680 } },
    { 567853, 2, { 1573, 361 } },
    { 567864, 2, { 792, 717 } },
    { 567875, 2, { 875, 649 } },
    { 567891, 2, { 779, 729 } },
    { 567987, 2, { 777, 731 } },
    { 568000, 2, { 800, 710 } },
    { 568008, 2, { 828, 686 } },
    { 568071, 2, { 889, 639 } },
    { 568080, 2, { 789, 720 } },
    { 568100, 2, { 874, 650 } },
    { 568106, 2, { 833, 682 } },
    { 568125, 2, { 909, 625 } },
    { 568128, 2, { 807, 704 } },
    { 568160, 2, { 848, 670 } },
    { 568176, 2, { 798, 712 } },
    { 568215, 2, { 915, 621 } },
    { 568232, 2, { 973, 584 } },
    { 568260, 2, { 770, 738 } },
    { 568288, 2, { 826, 688 } },
    { 568305, 2, { 865, 657 } },
    { 568320, 2, { 768, 740 } },
    { 568323, 2, { 837, 679 } },
    { 568400, 2, { 784, 725 } },
    { 568404, 2, { 831, 684 } },
    { 568428, 2, { 804, 707 } },
    { 568512, 2, { 756, 752 } },
    { 568524, 2, { 803, 708 } },
    { 568560, 2, { 824, 690 } },
    { 568568, 2, { 781, 728 } },
    { 568575, 2, { 855, 665 } },
    { 568620, 2, { 780, 729 } },
    { 568632, 2, { 817, 696 } },
    { 568675, 2, { 989, 575 } },
    { 568701, 2, { 1003, 567 } },
    { 568752, 2, { 816, 697 } },
    { 568764, 2, { 777, 732 } },
    { 568800, 2, { 790, 720 } },
    { 568836, 2, { 828, 687 } },
    { 568841, 2, { 893, 637 } },
    { 568854, 2, { 858, 663 } },
    { 568890, 2, { 774, 735 } },
    { 568960, 2, { 889, 640 } },
    { 568974, 2, { 798, 713 } },
    { 569008, 2, { 848, 671 } },
    { 569088, 2, { 768, 741 } },
    { 569100, 2, { 813, 700 } },
    { 569114, 2, { 767, 742 } },
    { 569160, 2, { 765, 744 } },
    { 569184, 2, { 784, 726 } },
    { 569196, 2, { 873, 652 } },
    { 569205, 2, { 819, 695 } },
    { 569220, 2, { 795, 716 } },
    { 569240, 2, { 760, 749 } },
    { 569250, 2, { 759, 750 } },
    { 569268, 2, { 756, 753 } },
    { 569296, 2, { 782, 728 } },
    { 569316, 2, { 836, 681 } },
    { 569349, 2, { 781, 729 } },
    { 569400, 2, { 780, 730 } },
    { 569430, 2, { 810, 703 } },
    { 569457, 2, { 917, 621 } },
    { 569520, 2, { 791, 720 } },
    { 569590, 2, { 790, 721 } },
    { 569592, 2, { 879, 648 } },
    { 569640, 2, { 808, 705 } },
    { 569664, 2, { 774, 736 } },
    { 569700, 2, { 844, 675 } },
    { 569712, 2, { 858, 664 } },
    { 569724, 2, { 788, 723 } },
    { 569734, 2, { 893, 638 } },
    { 569850, 2, { 786, 725 } },
    { 569856, 2, { 768, 742 } },
    { 569868, 2, { 843, 676 } },
    { 569910, 2, { 785, 726 } },
    { 569920, 2, { 832, 685 } },
    { 569925, 2, { 765, 745 } },
    { 569940, 2, { 805, 708 } },
    { 569961, 2, { 763, 747 } },
    { 569985, 2, { 1027, 555 } },
    { 569988, 2, { 852, 669 } },
    { 570000, 2, { 760, 750 } },
    { 570024, 2, { 756, 754 } },
    { 570045, 2, { 915, 623 } },
    { 570064, 2, { 869, 656 } },
    { 570078, 2, { 782, 729 } },
    { 570096, 2, { 856, 666 } },
    { 570150, 2, { 905, 630 } },
    { 570180, 2, { 780, 731 } },
    { 570262, 2, { 1058, 539 } },
    { 570276, 2, { 868, 657 } },
    { 570285, 2, { 855, 667 } },
    { 570304, 2, { 938, 608 } },
    { 570312, 2, { 801, 712 } },
    { 570350, 2, { 850, 671 } },
    { 570360, 2, { 776, 735 } },
    { 570375, 2, { 845, 675 } },
    { 570384, 2, { 816, 699 } },
    { 570400, 2, { 775, 736 } },
    { 570438, 2, { 774, 737 } },
    { 570486, 2, { 799, 714 } },
    { 570492, 2, { 828, 689 } },
    { 570515, 2, { 943, 605 } },
    { 570528, 2, { 849, 672 } },
    { 570540, 2, { 771, 740 } },
    { 570570, 2, { 770, 741 } },
    { 570625, 2, { 913, 625 } },
    { 570648, 2, { 767, 744 } },
    { 570696, 2, { 903, 632 } },
    { 570708, 2, { 764, 747 } },
    { 570720, 2, { 820, 696 } },
    { 570732, 2, { 796, 717 } },
    { 570741, 2, { 969, 589 } },
    { 570768, 2, { 759, 752 } },
    { 570775, 2, { 1343, 425 } },
    { 570780, 2, { 756, 755 } },
    { 570836, 2, { 812, 703 } },
    { 570840, 2, { 804, 710 } },
    { 570843, 2, { 819, 697 } },
    { 570852, 2, { 909, 628 } },
    { 570900, 2, { 825, 692 } },
    { 570969, 2, { 1007, 567 } },
    { 571020, 2, { 921, 620 } },
    { 571032, 2, { 792, 721 } },
    { 571040, 2, { 830, 688 } },
    { 571050, 2, { 810, 705 } },
    { 571064, 2, { 884, 646 } },
    { 571120, 2, { 880, 649 } },
    { 571140, 2, { 835, 684 } },
    { 571160, 2, { 872, 655 } },
    { 571175, 2, { 775, 737 } },
    { 571200, 2, { 800, 714 } },
    { 571236, 2, { 789, 724 } },
    { 571285, 2, { 799, 715 } },
    { 571290, 2, { 822, 695 } },
    { 571298, 2, { 949, 602 } },
    { 571356, 2, { 807, 708 } },
    { 571376, 2, { 871, 656 } },
    { 571389, 2, { 897, 637 } },
    { 571392, 2, { 768, 744 } },
    { 571428, 2, { 814, 702 } },
    { 571480, 2, { 785, 728 } },
    { 571584, 2, { 832, 687 } },
    { 571590, 2, { 783, 730 } },
    { 571644, 2, { 804, 711 } },
    { 571648, 2, { 812, 704 } },
    { 571650, 2, { 925, 618 } },
    { 571692, 2, { 781, 732 } },
    { 571704, 2, { 861, 664 } },
    { 571728, 2, { 831, 688 } },
    { 571795, 2, { 961, 595 } },
    { 571802, 2, { 869, 658 } },
    { 571815, 2, { 873, 655 } },
    { 571824, 2, { 792, 722 } },
    { 571857, 2, { 1023, 559 } },
    { 571872, 2, { 777, 736 } },
    { 571880, 2, { 841, 680 } },
    { 571900, 2, { 817, 700 } },
    { 571905, 2, { 895, 639 } },
    { 571950, 2, { 775, 738 } },
    { 572000, 2, { 800, 715 } },
    { 572033, 2, { 1309, 437 } },
    { 572040, 2, { 840, 681 } },
    { 572052, 2, { 772, 741 } },
    { 572112, 2, { 822, 696 } },
    { 572130, 2, { 815, 702 } },
    { 572160, 2, { 768, 745 } },
    { 572208, 2, { 786, 728 } },
    { 572220, 2, { 765, 748 } },
    { 572250, 2, { 763, 750 } },
    { 572265, 2, { 785, 729 } },
    { 572280, 2, { 760, 753 } },
    { 572286, 2, { 759, 754 } },
    { 572319, 2, { 1107, 517 } },
    { 572320, 2, { 784, 730 } },
    { 572352, 2, { 813, 704 } },
    { 572355, 2, { 805, 711 } },
    { 572373, 2, { 783, 731 } },
    { 572390, 2, { 910, 629 } },
    { 572400, 2, { 795, 720 } },
    { 572460, 2, { 812, 705 } },
    { 572508, 2, { 837, 684 } },
    { 572544, 2, { 852, 672 } },
    { 572565, 2, { 779, 735 } },
    { 572572, 2, { 847, 676 } },
    { 572592, 2, { 906, 632 } },
    { 572607, 2, { 1043, 549 } },
    { 572616, 2, { 792, 723 } },
    { 572649, 2, { 777, 737 } },
    { 572663, 2, { 899, 637 } },
    { 572664, 2, { 856, 669 } },
    { 572670, 2, { 810, 707 } },
    { 572680, 2, { 824, 695 } },
    { 572688, 2, { 776, 738 } },
    { 572715, 2, { 801, 715 } },
    { 572832, 2, { 816, 702 } },
    { 572880, 2, { 770, 744 } },
    { 572904, 2, { 872, 657 } },
    { 572907, 2, { 1083, 529 } },
    { 572910, 2, { 845, 678 } },
    { 572975, 2, { 1025, 559 } },
    { 572985, 2, { 765, 749 } },
    { 573024, 2, { 762, 752 } },
    { 573040, 2, { 760, 754 } },
    { 573056, 2, { 814, 704 } },
    { 573104, 2, { 784, 731 } },
    { 573108, 2, { 879, 652 } },
    { 573118, 2, { 871, 658 } },
    { 573156, 2, { 783, 732 } },
    { 573160, 2, { 805, 712 } },
    { 573180, 2, { 820, 699 } },
    { 573195, 2, { 795, 721 } },
    { 573210, 2, { 965, 594 } },
    { 573240, 2, { 843, 680 } },
    { 573248, 2, { 832, 689 } },
    { 573300, 2, { 780, 735 } },
    { 573325, 2, { 1207, 475 } },
    { 573342, 2, { 803, 714 } },
    { 573344, 2, { 779, 736 } },
    { 573345, 2, { 837, 685 } },
    { 573405, 2, { 889, 645 } },
    { 573475, 2, { 791, 725 } },
    { 573496, 2, { 836, 686 } },
    { 573516, 2, { 801, 716 } },
    { 573600, 2, { 800, 717 } },
    { 573624, 2, { 771, 744 } },
    { 573648, 2, { 816, 703 } },
    { 573696, 2, { 768, 747 } },
    { 573705, 2, { 855, 671 } },
    { 573716, 2, { 767, 748 } },
    { 573760, 2, { 815, 704 } },
    { 573776, 2, { 763, 752 } },
    { 573792, 2, { 834, 688 } },
    { 573800, 2, { 760, 755 } },
    { 573804, 2, { 759, 756 } },
    { 573888, 2, { 784, 732 } },
    { 573924, 2, { 849, 676 } },
    { 573937, 2, { 833, 689 } },
    { 573965, 2, { 805, 713 } },
    { 574035, 2, { 781, 735 } },
    { 574040, 2, { 904, 635 } },
    { 574080, 2, { 780, 736 } },
    { 574182, 2, { 837, 686 } },
    { 574200, 2, { 792, 725 } },
    { 574308, 2, { 774, 742 } },
    { 574332, 2, { 836, 687 } },
    { 574392, 2, { 789, 728 } },
    { 574425, 2, { 851, 675 } },
    { 574434, 2, { 846, 679 } },
    { 574452, 2, { 788, 729 } },
    { 574464, 2, { 768, 748 } },
    { 574480, 2, { 835, 688 } },
    { 574488, 2, { 808, 711 } },
    { 574525, 2, { 1225, 469 } },
    { 574560, 2, { 760, 756 } },
    { 574574, 2, { 902, 637 } },
    { 574584, 2, { 807, 712 } },
    { 574590, 2, { 895, 642 } },
    { 574600, 2, { 845, 680 } },
    { 574620, 2, { 785, 732 } },
    { 574656, 2, { 876, 656 } },
    { 574695, 2, { 891, 645 } },
    { 574704, 2, { 921, 624 } },
    { 574740, 2, { 927, 620 } },
    { 574764, 2, { 844, 681 } },
    { 574770, 2, { 782, 735 } },
    { 574816, 2, { 781, 736 } },
    { 574838, 2, { 901, 638 } },
    { 574860, 2, { 780, 737 } },
    { 574875, 2, { 875, 657 } },
    { 574925, 2, { 793, 725 } },
    { 574944, 2, { 848, 678 } },
    { 574980, 2, { 777, 740 } },
    { 574992, 2, { 792, 726 } },
    { 575000, 2, { 920, 625 } },
    { 575016, 2, { 776, 741 } },
    { 575025, 2, { 825, 697 } },
    { 575050, 2, { 775, 742 } },
    { 575052, 2, { 831, 692 } },
    { 575100, 2, { 810, 710 } },
    { 575148, 2, { 861, 668 } },
    { 575168, 2, { 817, 704 } },
    { 575232, 2, { 768, 749 } },
    { 575244, 2, { 841, 684 } },
    { 575250, 2, { 767, 750 } },
    { 575276, 2, { 851, 676 } },
    { 575280, 2, { 765, 752 } },
    { 575292, 2, { 764, 753 } },
    { 575310, 2, { 762, 755 } },
    { 575340, 2, { 860, 669 } },
    { 575360, 2, { 899, 640 } },
    { 575421, 2, { 987, 583 } },
    { 575424, 2, { 864, 666 } },
    { 575460, 2, { 828, 695 } },
    { 575484, 2, { 806, 714 } },
    { 575505, 2, { 783, 735 } },
    { 575508, 2, { 796, 723 } },
    { 575580, 2, { 795, 724 } },
    { 575586, 2, { 891, 646 } },
    { 575604, 2, { 813, 708 } },
    { 575652, 2, { 924, 623 } },
    { 575688, 2, { 867, 664 } },
    { 575718, 2, { 793, 726 } },
    { 575750, 2, { 875, 658 } },
    { 575795, 2, { 1045, 551 } },
    { 575840, 2, { 944, 610 } },
    { 575848, 2, { 791, 728 } },
    { 575856, 2, { 774, 744 } },
    { 575865, 2, { 955, 603 } },
    { 575910, 2, { 790, 729 } },
    { 575960, 2, { 770, 748 } },
    { 575976, 2, { 824, 699 } },
    { 576000, 2, { 768, 750 } },
    { 576004, 2, { 836, 689 } },
    { 576016, 2, { 973, 592 } },
    { 576090, 2, { 865, 666 } },
    { 576150, 2, { 835, 690 } },
    { 576180, 2, { 873, 660 } },
    { 576240, 2, { 784, 735 } },
    { 576275, 2, { 925, 623 } },
    { 576288, 2, { 783, 736 } },
    { 576290, 2, { 806, 715 } },
    { 576378, 2, { 781, 738 } },
    { 576400, 2, { 880, 655 } },
    { 576450, 2, { 854, 675 } },
    { 576460, 2, { 779, 740 } },
    { 576468, 2, { 804, 717 } },
    { 576576, 2, { 792, 728 } },
    { 576583, 2, { 1681, 343 } },
    { 576600, 2, { 775, 744 } },
    { 576612, 2, { 843, 684 } },
    { 576624, 2, { 879, 656 } },
    { 576630, 2, { 774, 745 } },
    { 576639, 2, { 791, 729 } },
    { 576684, 2, { 772, 747 } },
    { 576693, 2, { 837, 689 } },
    { 576708, 2, { 771, 748 } },
    { 576720, 2, { 801, 720 } },
    { 576725, 2, { 1003, 575 } },
    { 576730, 2, { 770, 749 } },
    { 576784, 2, { 767, 752 } },
    { 576800, 2, { 800, 721 } },
    { 576810, 2, { 765, 754 } },
    { 576828, 2, { 763, 756 } },
    { 576840, 2, { 760, 759 } },
    { 576875, 2, { 923, 625 } },
    { 576912, 2, { 808, 714 } },
    { 576926, 2, { 841, 686 } },
    { 576992, 2, { 949, 608 } },
    { 577020, 2, { 815, 708 } },
    { 577060, 2, { 860, 671 } },
    { 577071, 2, { 783, 737 } },
    { 577080, 2, { 840, 687 } },
    { 577150, 2, { 850, 679 } },
    { 577215, 2, { 909, 635 } },
    { 577239, 2, { 779, 741 } },
    { 577269, 2, { 833, 693 } },
    { 577280, 2, { 820, 704 } },
    { 577304, 2, { 793, 728 } },
    { 577320, 2, { 849, 680 } },
    { 577332, 2, { 812, 711 } },
    { 577368, 2, { 792, 729 } },
    { 577430, 2, { 791, 730 } },
    { 577488, 2, { 848, 681 } },
    { 577500, 2, { 770, 750 } },
    { 577521, 2, { 801, 721 } },
    { 577530, 2, { 810, 713 } },
    { 577548, 2, { 789, 732 } },
    { 577575, 2, { 765, 755 } },
    { 577668, 2, { 897, 644 } },
    { 577680, 2, { 830, 696 } },
    { 577720, 2, { 808, 715 } },
    { 577728, 2, { 816, 708 } },
    { 577731, 2, { 861, 671 } },
    { 577760, 2, { 785, 736 } },
    { 577800, 2, { 856, 675 } },
    { 577808, 2, { 784, 737 } },
    { 577812, 2, { 807, 716 } },
    { 577830, 2, { 935, 618 } },
    { 577850, 2, { 889, 650 } },
    { 577885, 2, { 869, 665 } },
    { 577940, 2, { 781, 740 } },
    { 577941, 2, { 949, 609 } },
    { 577980, 2, { 780, 741 } },
    { 578006, 2, { 946, 611 } },
    { 578016, 2, { 864, 669 } },
    { 578088, 2, { 777, 744 } },
    { 578097, 2, { 793, 729 } },
    { 578100, 2, { 820, 705 } },
    { 578120, 2, { 776, 745 } },
    { 578124, 2, { 909, 636 } },
    { 578136, 2, { 872, 663 } },
    { 578151, 2, { 931, 621 } },
    { 578160, 2, { 792, 730 } },
    { 578200, 2, { 826, 700 } },
    { 578240, 2, { 832, 695 } },
    { 578259, 2, { 891, 649 } },
    { 578277, 2, { 959, 603 } },
    { 578280, 2, { 790, 732 } },
    { 578289, 2, { 867, 667 } },
    { 578295, 2, { 905, 639 } },
    { 578304, 2, { 768, 753 } },
    { 578305, 2, { 1085, 533 } },
    { 578340, 2, { 765, 756 } },
    { 578347, 2, { 1073, 539 } },
    { 578376, 2, { 831, 696 } },
    { 578388, 2, { 921, 628 } },
    { 578400, 2, { 800, 723 } },
    { 578448, 2, { 824, 702 } },
    { 578496, 2, { 786, 736 } },
    { 578508, 2, { 852, 679 } },
    { 578550, 2, { 798, 725 } },
    { 578578, 2, { 1001, 578 } },
    { 578592, 2, { 784, 738 } },
    { 578646, 2, { 1037, 558 } },
    { 578655, 2, { 835, 693 } },
    { 578688, 2, { 822, 704 } },
    { 578730, 2, { 955, 606 } },
    { 578760, 2, { 780, 742 } },
    { 578772, 2, { 828, 699 } },
    { 578816, 2, { 896, 646 } },
    { 578856, 2, { 813, 712 } },
    { 578864, 2, { 968, 598 } },
    { 578880, 2, { 804, 720 } },
    { 578925, 2, { 775, 747 } },
    { 578956, 2, { 812, 713 } },
    { 579012, 2, { 791, 732 } },
    { 579025, 2, { 1007, 575 } },
    { 579033, 2, { 819, 707 } },
    { 579040, 2, { 770, 752 } },
    { 579072, 2, { 768, 754 } },
    { 579120, 2, { 762, 760 } },
    { 579150, 2, { 810, 715 } },
    { 579156, 2, { 867, 668 } },
    { 579180, 2, { 788, 735 } },
    { 579204, 2, { 837, 692 } },
    { 579215, 2, { 871, 665 } },
    { 579275, 2, { 799, 725 } },
    { 579312, 2, { 894, 648 } },
    { 579330, 2, { 785, 738 } },
    { 579336, 2, { 808, 717 } },
    { 579360, 2, { 816, 710 } },
    { 579375, 2, { 927, 625 } },
    { 579420, 2, { 783, 740 } },
    { 579425, 2, { 1075, 539 } },
    { 579462, 2, { 782, 741 } },
    { 579465, 2, { 815, 711 } },
    { 579502, 2, { 781, 742 } },
    { 579544, 2, { 917, 632 } },
    { 579555, 2, { 795, 729 } },
    { 579576, 2, { 779, 744 } },
    { 579600, 2, { 805, 720 } },
    { 579670, 2, { 845, 686 } },
    { 579672, 2, { 776, 747 } },
    { 579684, 2, { 804, 721 } },
    { 579726, 2, { 774, 749 } },
    { 579740, 2, { 820, 707 } },
    { 579792, 2, { 771, 752 } },
    { 579828, 2, { 844, 687 } },
    { 579840, 2, { 768, 755 } },
    { 579852, 2, { 767, 756 } },
    { 579876, 2, { 764, 759 } },
    { 579880, 2, { 763, 760 } },
    { 579904, 2, { 832, 697 } },
    { 579924, 2, { 801, 724 } },
    { 579975, 2, { 825, 703 } },
    { 579984, 2, { 843, 688 } },
    { 580000, 2, { 800, 725 } },
    { 580032, 2, { 848, 684 } },
    { 580074, 2, { 799, 726 } },
    { 580086, 2, { 871, 666 } },
    { 580125, 2, { 875, 663 } },
    { 580140, 2, { 879, 660 } },
    { 580176, 2, { 816, 711 } },
    { 580212, 2, { 852, 681 } },
    { 580280, 2, { 815, 712 } },
    { 580284, 2, { 796, 729 } },
    { 580290, 2, { 841, 690 } },
    { 580293, 2, { 1057, 549 } },
    { 580356, 2, { 846, 686 } },
    { 580368, 2, { 856, 678 } },
    { 580437, 2, { 1089, 533 } },
    { 580450, 2, { 893, 650 } },
    { 580464, 2, { 834, 696 } },
    { 580475, 2, { 775, 749 } },
    { 580545, 2, { 855, 679 } },
    { 580580, 2, { 770, 754 } },
    { 580601, 2, { 833, 697 } },
    { 580608, 2, { 768, 756 } },
    { 580635, 2, { 765, 759 } },
    { 580668, 2, { 913, 636 } },
    { 580692, 2, { 868, 669 } },
    { 580704, 2, { 789, 736 } },
    { 580716, 2, { 849, 684 } },
    { 580720, 2, { 854, 680 } },
    { 580725, 2, { 801, 725 } },
    { 580752, 2, { 872, 666 } },
    { 580754, 2, { 899, 646 } },
    { 580788, 2, { 876, 663 } },
    { 580800, 2, { 800, 726 } },
    { 580880, 2, { 848, 685 } },
    { 580888, 2, { 902, 644 } },
    { 580920, 2, { 824, 705 } },
    { 580932, 2, { 891, 652 } },
    { 580944, 2, { 784, 741 } },
    { 580986, 2, { 783, 742 } },
    { 581010, 2, { 905, 642 } },
    { 581040, 2, { 807, 720 } },
    { 581042, 2, { 847, 686 } },
    { 581064, 2, { 781, 744 } },
    { 581100, 2, { 780, 745 } },
    { 581160, 2, { 835, 696 } },
    { 581175, 2, { 861, 675 } },
    { 581196, 2, { 777, 748 } },
    { 581224, 2, { 776, 749 } },
    { 581250, 2, { 775, 750 } },
    { 581292, 2, { 804, 723 } },
    { 581316, 2, { 772, 753 } },
    { 581343, 2, { 893, 651 } },
    { 581360, 2, { 845, 688 } },
    { 581385, 2, { 791, 735 } },
    { 581400, 2, { 765, 760 } },
    { 581405, 2, { 961, 605 } },
    { 581440, 2, { 790, 736 } },
    { 581504, 2, { 826, 704 } },
    { 581529, 2, { 1147, 507 } },
    { 581532, 2, { 903, 644 } },
    { 581568, 2, { 832, 699 } },
    { 581581, 2, { 913, 637 } },
    { 581647, 2, { 1331, 437 } },
    { 581672, 2, { 799, 728 } },
    { 581700, 2, { 831, 700 } },
    { 581715, 2, { 837, 695 } },
    { 581728, 2, { 784, 742 } },
    { 581742, 2, { 798, 729 } },
    { 581875, 2, { 875, 665 } },
    { 581895, 2, { 965, 603 } },
    { 581910, 2, { 815, 714 } },
    { 581940, 2, { 795, 732 } },
    { 582000, 2, { 776, 750 } },
    { 582036, 2, { 861, 676 } },
    { 582048, 2, { 774, 752 } },
    { 582072, 2, { 921, 632 } },
    { 582084, 2, { 828, 703 } },
    { 582108, 2, { 813, 716 } },
    { 582120, 2, { 770, 756 } },
    { 582153, 2, { 767, 759 } },
    { 582156, 2, { 927, 628 } },
    { 582175, 2, { 803, 725 } },
    { 582176, 2, { 791, 736 } },
    { 582192, 2, { 933, 624 } },
    { 582204, 2, { 812, 717 } },
    { 582330, 2, { 826, 705 } },
    { 582335, 2, { 1105, 527 } },
    { 582400, 2, { 800, 728 } },
    { 582417, 2, { 999, 583 } },
    { 582471, 2, { 799, 729 } },
    { 582498, 2, { 938, 621 } },
    { 582552, 2, { 783, 744 } },
    { 582568, 2, { 808, 721 } },
    { 582576, 2, { 848, 687 } },
    { 582615, 2, { 963, 605 } },
    { 582624, 2, { 816, 714 } },
    { 582659, 2, { 1081, 539 } },
    { 582660, 2, { 780, 747 } },
    { 582692, 2, { 779, 748 } },
    { 582736, 2, { 847, 688 } },
    { 582750, 2, { 777, 750 } },
    { 582800, 2, { 775, 752 } },
    { 582813, 2, { 841, 693 } },
    { 582855, 2, { 793, 735 } },
    { 582876, 2, { 771, 756 } },
    { 582894, 2, { 846, 689 } },
    { 582900, 2, { 804, 725 } },
    { 582912, 2, { 768, 759 } },
    { 582920, 2, { 767, 760 } },
    { 582936, 2, { 856, 681 } },
    { 582958, 2, { 874, 667 } },
    { 583000, 2, { 1000, 583 } },
    { 583020, 2, { 790, 738 } },
    { 583050, 2, { 845, 690 } },
    { 583072, 2, { 959, 608 } },
    { 583100, 2, { 833, 700 } },
    { 583110, 2, { 855, 682 } },
    { 583128, 2, { 801, 728 } },
    { 583164, 2, { 873, 668 } },
    { 583184, 2, { 889, 656 } },
    { 583200, 2, { 800, 729 } },
    { 583219, 2, { 1183, 493 } },
    { 583275, 2, { 825, 707 } },
    { 583335, 2, { 783, 745 } },
    { 583338, 2, { 798, 731 } },
    { 583356, 2, { 843, 692 } },
    { 583368, 2, { 872, 669 } },
    { 583389, 2, { 837, 697 } },
    { 583440, 2, { 780, 748 } },
    { 583443, 2, { 1029, 567 } },
    { 583569, 2, { 1099, 531 } },
    { 583583, 2, { 847, 689 } },
    { 583605, 2, { 891, 655 } },
    { 583635, 2, { 949, 615 } },
    { 583648, 2, { 793, 736 } },
    { 583656, 2, { 879, 664 } },
    { 583680, 2, { 768, 760 } },
    { 583695, 2, { 765, 763 } },
    { 583704, 2, { 792, 737 } },
    { 583712, 2, { 928, 629 } },
    { 583740, 2, { 828, 705 } },
    { 583758, 2, { 791, 738 } },
    { 583770, 2, { 870, 671 } },
    { 583786, 2, { 851, 686 } },
    { 583848, 2, { 901, 648 } },
    { 583860, 2, { 789, 740 } },
    { 583875, 2, { 865, 675 } },
    { 583905, 2, { 1005, 581 } },
    { 583908, 2, { 788, 741 } },
    { 583940, 2, { 860, 679 } },
    { 583947, 2, { 819, 713 } },
    { 583968, 2, { 869, 672 } },
    { 583975, 2, { 1175, 497 } },
    { 584000, 2, { 800, 730 } },
    { 584010, 2, { 810, 721 } },
    { 584040, 2, { 785, 744 } },
    { 584045, 2, { 1295, 451 } },
    { 584060, 2, { 1007, 580 } },
    { 584064, 2, { 832, 702 } },
    { 584073, 2, { 889, 657 } },
    { 584080, 2, { 784, 745 } },
    { 584100, 2, { 825, 708 } },
    { 584112, 2, { 849, 688 } },
    { 584155, 2, { 817, 715 } },
    { 584184, 2, { 808, 723 } },
    { 584200, 2, { 920, 635 } },
    { 584220, 2, { 780, 749 } },
    { 584250, 2, { 779, 750 } },
    { 584268, 2, { 807, 724 } },
    { 584288, 2, { 961, 608 } },
    { 584304, 2, { 777, 752 } },
    { 584320, 2, { 830, 704 } },
    { 584328, 2, { 776, 753 } },
    { 584364, 2, { 836, 699 } },
    { 584370, 2, { 774, 755 } },
    { 584375, 2, { 935, 625 } },
    { 584430, 2, { 770, 759 } },
    { 584460, 2, { 765, 764 } },
    { 584496, 2, { 792, 738 } },
    { 584545, 2, { 1105, 529 } },
    { 584584, 2, { 803, 728 } },
    { 584640, 2, { 812, 720 } },
    { 584727, 2, { 957, 611 } },
    { 584775, 2, { 1017, 575 } },
    { 584784, 2, { 786, 744 } },
    { 584790, 2, { 965, 606 } },
    { 584800, 2, { 800, 731 } },
    { 584820, 2, { 810, 722 } },
    { 584844, 2, { 897, 652 } },
    { 584892, 2, { 844, 693 } },
    { 584896, 2, { 832, 703 } },
    { 584936, 2, { 782, 748 } },
    { 584970, 2, { 930, 629 } },
    { 585024, 2, { 831, 704 } },
    { 585060, 2, { 796, 735 } },
    { 585072, 2, { 816, 717 } },
    { 585090, 2, { 985, 594 } },
    { 585120, 2, { 795, 736 } },
    { 585156, 2, { 806, 726 } },
    { 585216, 2, { 768, 762 } },
    { 585234, 2, { 793, 738 } },
    { 585264, 2, { 822, 712 } },
    { 585324, 2, { 852, 687 } },
    { 585330, 2, { 895, 654 } },
    { 585333, 2, { 1141, 513 } },
    { 585340, 2, { 791, 740 } },
    { 585360, 2, { 813, 720 } },
    { 585387, 2, { 803, 729 } },
    { 585396, 2, { 828, 707 } },
    { 585570, 2, { 786, 745 } },
    { 585585, 2, { 819, 715 } },
    { 585599, 2, { 833, 703 } },
    { 585600, 2, { 800, 732 } },
    { 585603, 2, { 943, 621 } },
    { 585648, 2, { 784, 747 } },
    { 585650, 2, { 850, 689 } },
    { 585660, 2, { 860, 681 } },
    { 585675, 2, { 855, 685 } },
    { 585684, 2, { 783, 748 } },
    { 585750, 2, { 781, 750 } },
    { 585756, 2, { 921, 636 } },
    { 585792, 2, { 864, 678 } },
    { 585800, 2, { 808, 725 } },
    { 585864, 2, { 824, 711 } },
    { 585880, 2, { 776, 755 } },
    { 585900, 2, { 775, 756 } },
    { 585915, 2, { 795, 737 } },
    { 585924, 2, { 933, 628 } },
    { 585948, 2, { 772, 759 } },
    { 585960, 2, { 771, 760 } },
    { 585963, 2, { 917, 639 } },
    { 585984, 2, { 768, 763 } },
    { 586040, 2, { 805, 728 } },
    { 586044, 2, { 876, 669 } },
    { 586047, 2, { 903, 649 } },
    { 586080, 2, { 792, 740 } },
    { 586092, 2, { 867, 676 } },
    { 586116, 2, { 804, 729 } },
    { 586170, 2, { 835, 702 } },
    { 586176, 2, { 852, 688 } },
    { 586332, 2, { 801, 732 } },
    { 586360, 2, { 856, 685 } },
    { 586395, 2, { 785, 747 } },
    { 586404, 2, { 819, 716 } },
    { 586432, 2, { 784, 748 } },
    { 586464, 2, { 894, 656 } },
    { 586467, 2, { 783, 749 } },
    { 586470, 2, { 865, 678 } },
    { 586500, 2, { 782, 750 } },
    { 586551, 2, { 901, 651 } },
    { 586560, 2, { 780, 752 } },
    { 586608, 2, { 808, 726 } },
    { 586670, 2, { 986, 595 } },
    { 586710, 2, { 795, 738 } },
    { 586719, 2, { 973, 603 } },
    { 586728, 2, { 843, 696 } },
    { 586755, 2, { 767, 765 } },
    { 586768, 2, { 806, 728 } },
    { 586800, 2, { 815, 720 } },
    { 586810, 2, { 830, 707 } },
    { 586820, 2, { 793, 740 } },
    { 586845, 2, { 805, 729 } },
    { 586872, 2, { 792, 741 } },
    { 586880, 2, { 896, 655 } },
    { 586920, 2, { 804, 730 } },
    { 586950, 2, { 903, 650 } },
    { 586960, 2, { 880, 667 } },
    { 586971, 2, { 847, 693 } },
    { 587016, 2, { 789, 744 } },
    { 587076, 2, { 812, 723 } },
    { 587088, 2, { 906, 648 } },
    { 587125, 2, { 875, 671 } },
    { 587136, 2, { 834, 704 } },
    { 587160, 2, { 840, 699 } },
    { 587172, 2, { 879, 668 } },
    { 587190, 2, { 851, 690 } },
    { 587216, 2, { 784, 749 } },
    { 587265, 2, { 799, 735 } },
    { 587312, 2, { 781, 752 } },
    { 587328, 2, { 798, 736 } },
    { 587340, 2, { 780, 753 } },
    { 587366, 2, { 779, 754 } },
    { 587400, 2, { 825, 712 } },
    { 587412, 2, { 777, 756 } },
    { 587496, 2, { 807, 728 } },
    { 587508, 2, { 849, 692 } },
    { 587510, 2, { 770, 763 } },
    { 587520, 2, { 768, 765 } },
    { 587552, 2, { 854, 688 } },
    { 587574, 2, { 806, 729 } },
    { 587640, 2, { 830, 708 } },
    { 587664, 2, { 792, 742 } },
    { 587730, 2, { 822, 715 } },
    { 587760, 2, { 790, 744 } },
    { 587796, 2, { 803, 732 } },
    { 587840, 2, { 835, 704 } },
    { 587880, 2, { 828, 710 } },
    { 587925, 2, { 871, 675 } },
    { 587940, 2, { 820, 717 } },
    { 587951, 2, { 923, 637 } },
    { 587972, 2, { 913, 644 } },
    { 587979, 2, { 1037, 567 } },
    { 588000, 2, { 784, 750 } },
    { 588015, 2, { 895, 657 } },
    { 588060, 2, { 810, 726 } },
    { 588072, 2, { 856, 687 } },
    { 588115, 2, { 935, 629 } },
    { 588120, 2, { 780, 754 } },
    { 588126, 2, { 798, 737 } },
    { 588132, 2, { 961, 612 } },
    { 588240, 2, { 774, 760 } },
    { 588294, 2, { 882, 667 } },
    { 588300, 2, { 795, 740 } },
    { 588302, 2, { 1331, 442 } },
    { 588336, 2, { 816, 721 } },
    { 588348, 2, { 831, 708 } },
    { 588384, 2, { 864, 681 } },
    { 588392, 2, { 931, 632 } },
    { 588406, 2, { 793, 742 } },
    { 588411, 2, { 837, 703 } },
    { 588432, 2, { 897, 656 } },
    { 588448, 2, { 994, 592 } },
    { 588455, 2, { 805, 731 } },
    { 588504, 2, { 791, 744 } },
    { 588544, 2, { 836, 704 } },
    { 588588, 2, { 858, 686 } },
    { 588600, 2, { 872, 675 } },
    { 588612, 2, { 813, 724 } },
    { 588627, 2, { 1053, 559 } },
    { 588636, 2, { 788, 747 } },
    { 588645, 2, { 927, 635 } },
    { 588672, 2, { 876, 672 } },
    { 588708, 2, { 828, 711 } },
    { 588720, 2, { 880, 669 } },
    { 588750, 2, { 785, 750 } },
    { 588756, 2, { 903, 652 } },
    { 588816, 2, { 783, 752 } },
    { 588885, 2, { 913, 645 } },
    { 588900, 2, { 780, 755 } },
    { 588924, 2, { 779, 756 } },
    { 588945, 2, { 1065, 553 } },
    { 588965, 2, { 845, 697 } },
    { 588984, 2, { 776, 759 } },
    { 589000, 2, { 775, 760 } },
    { 589032, 2, { 808, 729 } },
    { 589044, 2, { 771, 764 } },
    { 589056, 2, { 768, 767 } },
    { 589152, 2, { 816, 722 } },
    { 589160, 2, { 824, 715 } },
    { 589186, 2, { 806, 731 } },
    { 589225, 2, { 925, 637 } },
    { 589260, 2, { 805, 732 } },
    { 589280, 2, { 928, 635 } },
    { 589360, 2, { 848, 695 } },
    { 589375, 2, { 943, 625 } },
    { 589380, 2, { 836, 705 } },
    { 589410, 2, { 885, 666 } },
    { 589440, 2, { 921, 640 } },
    { 589475, 2, { 1241, 475 } },
    { 589498, 2, { 1027, 574 } },
    { 589536, 2, { 801, 736 } },
    { 589560, 2, { 867, 680 } },
    { 589572, 2, { 927, 636 } },
    { 589589, 2, { 1001, 589 } },
    { 589600, 2, { 800, 737 } },
    { 589656, 2, { 933, 632 } },
    { 589662, 2, { 799, 738 } },
    { 589680, 2, { 780, 756 } },
    { 589692, 2, { 939, 628 } },
    { 589836, 2, { 796, 741 } },
    { 589875, 2, { 825, 715 } },
    { 589956, 2, { 844, 699 } },
    { 589960, 2, { 860, 686 } },
    { 589968, 2, { 816, 723 } },
    { 589992, 2, { 793, 744 } },
    { 590000, 2, { 944, 625 } },
    { 590040, 2, { 792, 745 } },
    { 590085, 2, { 837, 705 } },
    { 590100, 2, { 843, 700 } },
    { 590148, 2, { 873, 676 } },
    { 590150, 2, { 814, 725 } },
    { 590172, 2, { 789, 748 } },
    { 590190, 2, { 955, 618 } },
    { 590205, 2, { 803, 735 } },
    { 590240, 2, { 868, 680 } },
    { 590296, 2, { 889, 664 } },
    { 590304, 2, { 858, 688 } },
    { 590320, 2, { 785, 752 } },
    { 590352, 2, { 784, 753 } },
    { 590359, 2, { 847, 697 } },
    { 590364, 2, { 828, 713 } },
    { 590400, 2, { 800, 738 } },
    { 590436, 2, { 781, 756 } },
    { 590480, 2, { 880, 671 } },
    { 590499, 2, { 819, 721 } },
    { 590520, 2, { 777, 760 } },
    { 590525, 2, { 1027, 575 } },
    { 590550, 2, { 775, 762 } },
    { 590562, 2, { 774, 763 } },
    { 590580, 2, { 772, 765 } },
    { 590590, 2, { 770, 767 } },
    { 590604, 2, { 948, 623 } },
    { 590625, 2, { 875, 675 } },
    { 590640, 2, { 856, 690 } },
    { 590688, 2, { 879, 672 } },
    { 590700, 2, { 825, 716 } },
    { 590720, 2, { 832, 710 } },
    { 590724, 2, { 807, 732 } },
    { 590730, 2, { 870, 679 } },
    { 590733, 2, { 891, 663 } },
    { 590744, 2, { 959, 616 } },
    { 590808, 2, { 824, 717 } },
    { 590820, 2, { 860, 687 } },
    { 590824, 2, { 874, 676 } },
    { 590877, 2, { 791, 747 } },
    { 590904, 2, { 849, 696 } },
    { 590940, 2, { 804, 735 } },
    { 590976, 2, { 864, 684 } },
    { 591008, 2, { 803, 736 } },
    { 591072, 2, { 786, 752 } },
    { 591075, 2, { 925, 639 } },
    { 591108, 2, { 868, 681 } },
    { 591136, 2, { 784, 754 } },
    { 591162, 2, { 858, 689 } },
    { 591165, 2, { 783, 755 } },
    { 591180, 2, { 835, 708 } },
    { 591192, 2, { 782, 756 } },
    { 591216, 2, { 872, 678 } },
    { 591220, 2, { 820, 721 } },
    { 591250, 2, { 946, 625 } },
    { 591260, 2, { 799, 740 } },
    { 591261, 2, { 779, 759 } },
    { 591300, 2, { 810, 730 } },
    { 591312, 2, { 776, 762 } },
    { 591325, 2, { 775, 763 } },
    { 591360, 2, { 770, 768 } },
    { 591381, 2, { 1043, 567 } },
    { 591396, 2, { 884, 669 } },
    { 591422, 2, { 989, 598 } },
    { 591430, 2, { 833, 710 } },
    { 591448, 2, { 968, 611 } },
    { 591480, 2, { 795, 744 } },
    { 591500, 2, { 845, 700 } },
    { 591552, 2, { 832, 711 } },
    { 591584, 2, { 973, 608 } },
    { 591600, 2, { 816, 725 } },
    { 591624, 2, { 792, 747 } },
    { 591660, 2, { 855, 692 } },
    { 591672, 2, { 831, 712 } },
    { 591690, 2, { 815, 726 } },
    { 591710, 2, { 790, 749 } },
    { 591744, 2, { 804, 736 } },
    { 591745, 2, { 1015, 583 } },
    { 591759, 2, { 837, 707 } },
    { 591840, 2, { 822, 720 } },
    { 591864, 2, { 813, 728 } },
    { 591870, 2, { 905, 654 } },
    { 591872, 2, { 1024, 578 } },
    { 591920, 2, { 784, 755 } },
    { 591948, 2, { 783, 756 } },
    { 592000, 2, { 800, 740 } },
    { 592020, 2, { 780, 759 } },
    { 592040, 2, { 779, 760 } },
    { 592059, 2, { 799, 741 } },
    { 592064, 2, { 841, 704 } },
    { 592088, 2, { 776, 763 } },
    { 592120, 2, { 904, 655 } },
    { 592128, 2, { 771, 768 } },
    { 592185, 2, { 1067, 555 } },
    { 592200, 2, { 840, 705 } },
    { 592263, 2, { 833, 711 } },
    { 592280, 2, { 871, 680 } },
    { 592296, 2, { 851, 696 } },
    { 592325, 2, { 817, 725 } },
    { 592368, 2, { 861, 688 } },
    { 592410, 2, { 806, 735 } },
    { 592416, 2, { 792, 748 } },
    { 592450, 2, { 850, 697 } },
    { 592480, 2, { 805, 736 } },
    { 592540, 2, { 860, 689 } },
    { 592592, 2, { 814, 728 } },
    { 592596, 2, { 837, 708 } },
    { 592614, 2, { 803, 738 } },
    { 592668, 2, { 909, 652 } },
    { 592704, 2, { 784, 756 } },
    { 592740, 2, { 801, 740 } },
    { 592752, 2, { 848, 699 } },
    { 592860, 2, { 820, 723 } },
    { 592875, 2, { 775, 765 } },
    { 592956, 2, { 819, 724 } },
    { 593021, 2, { 1573, 377 } },
    { 593028, 2, { 867, 684 } },
    { 593055, 2, { 955, 621 } },
    { 593096, 2, { 833, 712 } },
    { 593124, 2, { 921, 644 } },
    { 593125, 2, { 949, 625 } },
    { 593142, 2, { 817, 726 } },
    { 593164, 2, { 793, 748 } },
    { 593190, 2, { 845, 702 } },
    { 593208, 2, { 792, 749 } },
    { 593216, 2, { 806, 736 } },
    { 593229, 2, { 861, 689 } },
    { 593250, 2, { 791, 750 } },
    { 593285, 2, { 805, 737 } },
    { 593320, 2, { 815, 728 } },
    { 593328, 2, { 789, 752 } },
    { 593340, 2, { 870, 682 } },
    { 593364, 2, { 788, 753 } },
    { 593388, 2, { 933, 636 } },
    { 593406, 2, { 814, 729 } },
    { 593430, 2, { 786, 755 } },
    { 593448, 2, { 939, 632 } },
    { 593460, 2, { 785, 756 } },
    { 593472, 2, { 843, 704 } },
    { 593505, 2, { 981, 605 } },
    { 593560, 2, { 781, 760 } },
    { 593568, 2, { 864, 687 } },
    { 593572, 2, { 812, 731 } },
    { 593600, 2, { 800, 742 } },
    { 593616, 2, { 894, 664 } },
    { 593628, 2, { 777, 764 } },
    { 593640, 2, { 776, 765 } },
    { 593658, 2, { 774, 767 } },
    { 593676, 2, { 828, 717 } },
    { 593685, 2, { 835, 711 } },
    { 593712, 2, { 798, 744 } },
    { 593775, 2, { 819, 725 } },
    { 593808, 2, { 834, 712 } },
    { 593832, 2, { 872, 681 } },
    { 593835, 2, { 885, 671 } },
    { 593845, 2, { 893, 665 } },
    { 593850, 2, { 925, 642 } },
    { 593880, 2, { 808, 735 } },
    { 593929, 2, { 833, 713 } },
    { 593952, 2, { 807, 736 } },
    { 593955, 2, { 985, 603 } },
    { 593978, 2, { 931, 638 } },
    { 594000, 2, { 792, 750 } },
    { 594035, 2, { 845, 703 } },
    { 594072, 2, { 888, 669 } },
    { 594080, 2, { 790, 752 } },
    { 594090, 2, { 805, 738 } },
    { 594125, 2, { 875, 679 } },
    { 594135, 2, { 815, 729 } },
    { 594204, 2, { 879, 676 } },
    { 594220, 2, { 803, 740 } },
    { 594225, 2, { 855, 695 } },
    { 594270, 2, { 837, 710 } },
    { 594300, 2, { 849, 700 } },
    { 594320, 2, { 782, 760 } },
    { 594336, 2, { 906, 656 } },
    { 594363, 2, { 913, 651 } },
    { 594396, 2, { 836, 711 } },
    { 594405, 2, { 777, 765 } },
    { 594412, 2, { 923, 644 } },
    { 594425, 2, { 775, 767 } },
    { 594432, 2, { 774, 768 } },
    { 594456, 2, { 799, 744 } },
    { 594475, 2, { 1075, 553 } },
    { 594510, 2, { 798, 745 } },
    { 594520, 2, { 835, 712 } },
    { 594550, 2, { 1034, 575 } },
    { 594585, 2, { 905, 657 } },
    { 594612, 2, { 796, 747 } },
    { 594660, 2, { 795, 748 } },
    { 594720, 2, { 826, 720 } },
    { 594750, 2, { 793, 750 } },
    { 594776, 2, { 817, 728 } },
    { 594804, 2, { 876, 679 } },
    { 594825, 2, { 825, 721 } },
    { 594832, 2, { 791, 752 } },
    { 594864, 2, { 816, 729 } },
    { 594880, 2, { 832, 715 } },
    { 594909, 2, { 931, 639 } },
    { 594920, 2, { 856, 695 } },
    { 594996, 2, { 831, 716 } },
    { 595020, 2, { 844, 705 } },
    { 595034, 2, { 814, 731 } },
    { 595056, 2, { 784, 759 } },
    { 595080, 2, { 783, 760 } },
    { 595116, 2, { 813, 732 } },
    { 595140, 2, { 780, 763 } },
    { 595188, 2, { 891, 668 } },
    { 595200, 2, { 775, 768 } },
    { 595212, 2, { 772, 771 } },
    { 595296, 2, { 848, 702 } },
    { 595335, 2, { 923, 645 } },
    { 595344, 2, { 942, 632 } },
    { 595350, 2, { 810, 735 } },
    { 595395, 2, { 909, 655 } },
    { 595441, 2, { 847, 703 } },
    { 595455, 2, { 795, 749 } },
    { 595525, 2, { 1025, 581 } },
    { 595539, 2, { 959, 621 } },
    { 595548, 2, { 852, 699 } },
    { 595593, 2, { 817, 729 } },
    { 595608, 2, { 897, 664 } },
    { 595630, 2, { 889, 670 } },
    { 595650, 2, { 825, 722 } },
    { 595680, 2, { 816, 730 } },
    { 595752, 2, { 824, 723 } },
    { 595764, 2, { 804, 741 } },
    { 595782, 2, { 918, 649 } },
    { 595812, 2, { 861, 692 } },
    { 595826, 2, { 803, 742 } },
    { 595935, 2, { 779, 765 } },
    { 595944, 2, { 801, 744 } },
    { 595950, 2, { 822, 725 } },
    { 595959, 2, { 777, 767 } },
    { 595980, 2, { 774, 770 } },
    { 596000, 2, { 800, 745 } },
    { 596037, 2, { 899, 663 } },
    { 596068, 2, { 836, 713 } },
    { 596070, 2, { 895, 666 } },
    { 596134, 2, { 869, 686 } },
    { 596160, 2, { 810, 736 } },
    { 596190, 2, { 835, 714 } },
    { 596232, 2, { 819, 728 } },
    { 596275, 2, { 1037, 575 } },
    { 596288, 2, { 847, 704 } },
    { 596304, 2, { 808, 738 } },
    { 596310, 2, { 834, 715 } },
    { 596316, 2, { 868, 687 } },
    { 596336, 2, { 793, 752 } },
    { 596370, 2, { 965, 618 } },
    { 596376, 2, { 792, 753 } },
    { 596400, 2, { 840, 710 } },
    { 596477, 2, { 1739, 343 } },
    { 596484, 2, { 789, 756 } },
    { 596496, 2, { 816, 731 } },
    { 596544, 2, { 832, 717 } },
    { 596556, 2, { 876, 681 } },
    { 596580, 2, { 815, 732 } },
    { 596600, 2, { 785, 760 } },
    { 596640, 2, { 880, 678 } },
    { 596700, 2, { 780, 765 } },
    { 596736, 2, { 777, 768 } },
    { 596745, 2, { 801, 745 } },
    { 596785, 2, { 1003, 595 } },
    { 596808, 2, { 921, 648 } },
    { 596820, 2, { 812, 735 } },
    { 596844, 2, { 843, 708 } },
    { 596850, 2, { 865, 690 } },
    { 596910, 2, { 985, 606 } },
    { 596970, 2, { 810, 737 } },
    { 596988, 2, { 828, 721 } },
    { 597051, 2, { 819, 729 } },
    { 597080, 2, { 920, 649 } },
    { 597120, 2, { 933, 640 } },
    { 597132, 2, { 873, 684 } },
    { 597135, 2, { 847, 705 } },
    { 597168, 2, { 792, 754 } },
    { 597180, 2, { 807, 740 } },
    { 597204, 2, { 939, 636 } },
    { 597240, 2, { 790, 756 } },
    { 597300, 2, { 825, 724 } },
    { 597312, 2, { 816, 732 } },
    { 597320, 2, { 872, 685 } },
    { 597360, 2, { 786, 760 } },
    { 597375, 2, { 885, 675 } },
    { 597400, 2, { 824, 725 } },
    { 597402, 2, { 851, 702 } },
    { 597408, 2, { 784, 762 } },
    { 597429, 2, { 783, 763 } },
    { 597432, 2, { 803, 744 } },
    { 597465, 2, { 781, 765 } },
    { 597506, 2, { 871, 686 } },
    { 597550, 2, { 850, 703 } },
    { 597575, 2, { 1025, 583 } },
    { 597600, 2, { 800, 747 } },
    { 597632, 2, { 812, 736 } },
    { 597652, 2, { 799, 748 } },
    { 597696, 2, { 849, 704 } },
    { 597720, 2, { 879, 680 } },
    { 597800, 2, { 854, 700 } },
    { 597835, 2, { 899, 665 } },
    { 597840, 2, { 795, 752 } },
    { 597861, 2, { 891, 671 } },
    { 597872, 2, { 869, 688 } },
    { 597960, 2, { 792, 755 } },
    { 597996, 2, { 791, 756 } },
    { 598005, 2, { 873, 685 } },
    { 598026, 2, { 858, 697 } },
    { 598092, 2, { 788, 759 } },
    { 598122, 2, { 846, 707 } },
    { 598170, 2, { 785, 762 } },
    { 598192, 2, { 784, 763 } },
    { 598212, 2, { 783, 764 } },
    { 598224, 2, { 824, 726 } },
    { 598230, 2, { 782, 765 } },
    { 598260, 2, { 780, 767 } },
    { 598272, 2, { 779, 768 } },
    { 598296, 2, { 776, 771 } },
    { 598299, 2, { 897, 667 } },
    { 598320, 2, { 831, 720 } },
    { 598344, 2, { 856, 699 } },
    { 598345, 2, { 989, 605 } },
    { 598368, 2, { 813, 736 } },
    { 598400, 2, { 800, 748 } },
    { 598416, 2, { 822, 728 } },
    { 598430, 2, { 830, 721 } },
    { 598437, 2, { 1127, 531 } },
    { 598444, 2, { 812, 737 } },
    { 598455, 2, { 837, 715 } },
    { 598500, 2, { 798, 750 } },
    { 598560, 2, { 860, 696 } },
    { 598598, 2, { 1001, 598 } },
    { 598644, 2, { 828, 723 } },
    { 598689, 2, { 819, 731 } },
    { 598728, 2, { 808, 741 } },
    { 598808, 2, { 952, 629 } },
    { 598845, 2, { 1079, 555 } },
    { 598850, 2, { 826, 725 } },
    { 598920, 2, { 805, 744 } },
    { 598980, 2, { 804, 745 } },
    { 599040, 2, { 780, 768 } },
    { 599064, 2, { 872, 687 } },
    { 599104, 2, { 814, 736 } },
    { 599148, 2, { 801, 748 } },
    { 599165, 2, { 901, 665 } },
    { 599196, 2, { 897, 668 } },
    { 599200, 2, { 800, 749 } },
    { 599248, 2, { 871, 688 } },
    { 599250, 2, { 799, 750 } },
    { 599265, 2, { 965, 621 } },
    { 599280, 2, { 880, 681 } },
    { 599292, 2, { 837, 716 } },
    { 599319, 2, { 1057, 567 } },
    { 599368, 2, { 973, 616 } },
    { 599388, 2, { 796, 753 } },
    { 599400, 2, { 810, 740 } },
    { 599412, 2, { 836, 717 } },
    { 599420, 2, { 820, 731 } },
    { 599440, 2, { 944, 635 } },
    { 599445, 2, { 865, 693 } },
    { 599508, 2, { 793, 756 } },
    { 599564, 2, { 874, 686 } },
    { 599592, 2, { 903, 664 } },
    { 599640, 2, { 789, 760 } },
    { 599675, 2, { 1411, 425 } },
    { 599697, 2, { 1169, 513 } },
    { 599760, 2, { 784, 765 } },
    { 599808, 2, { 781, 768 } },
    { 599830, 2, { 779, 770 } },
    { 599840, 2, { 815, 736 } },
    { 599844, 2, { 777, 772 } },
    { 599850, 2, { 775, 774 } },
    { 599907, 2, { 1029, 583 } },
    { 599940, 2, { 909, 660 } },
    { 599949, 2, { 801, 749 } },
    { 599964, 2, { 867, 692 } },
    { 599985, 2, { 995, 603 } },
    { 600000, 2, { 800, 750 } },
    { 600066, 2, { 901, 666 } },
    { 600075, 2, { 889, 675 } },
    { 600084, 2, { 844, 711 } },
    { 600096, 2, { 798, 752 } },
    { 600160, 2, { 880, 682 } },
    { 600210, 2, { 810, 741 } },
    { 600216, 2, { 843, 712 } },
    { 600237, 2, { 1161, 517 } },
    { 600250, 2, { 875, 686 } },
    { 600270, 2, { 935, 642 } },
    { 600300, 2, { 828, 725 } },
    { 600320, 2, { 896, 670 } },
    { 600325, 2, { 925, 649 } },
    { 600384, 2, { 848, 708 } },
    { 600408, 2, { 807, 744 } },
    { 600425, 2, { 1175, 511 } },
    { 600457, 2, { 1859, 323 } },
    { 600474, 2, { 841, 714 } },
    { 600480, 2, { 834, 720 } },
    { 600492, 2, { 921, 652 } },
    { 600495, 2, { 817, 735 } },
    { 600525, 2, { 785, 765 } },
    { 600561, 2, { 783, 767 } },
    { 600576, 2, { 782, 768 } },
    { 600588, 2, { 804, 747 } },
    { 600600, 2, { 780, 770 } },
    { 600624, 2, { 776, 774 } },
    { 600660, 2, { 846, 710 } },
    { 600691, 2, { 943, 637 } },
    { 600696, 2, { 824, 729 } },
    { 600704, 2, { 832, 722 } },
    { 600754, 2, { 913, 658 } },
    { 600768, 2, { 894, 672 } },
    { 600795, 2, { 845, 711 } },
    { 600831, 2, { 867, 693 } },
    { 600852, 2, { 933, 644 } },
    { 600873, 2, { 923, 651 } },
    { 600912, 2, { 856, 702 } },
    { 600915, 2, { 885, 679 } },
    { 600950, 2, { 850, 707 } },
    { 600960, 2, { 939, 640 } },
    { 600990, 2, { 871, 690 } },
    { 601020, 2, { 795, 756 } },
    { 601065, 2, { 855, 703 } },
    { 601092, 2, { 849, 708 } },
    { 601128, 2, { 792, 759 } },
    { 601140, 2, { 860, 699 } },
    { 601160, 2, { 791, 760 } },
    { 601200, 2, { 835, 720 } },
    { 601216, 2, { 854, 704 } },
    { 601224, 2, { 984, 611 } },
    { 601236, 2, { 879, 684 } },
    { 601312, 2, { 817, 736 } },
    { 601315, 2, { 841, 715 } },
    { 601328, 2, { 784, 767 } },
    { 601335, 2, { 805, 747 } },
    { 601344, 2, { 783, 768 } },
    { 601370, 2, { 781, 770 } },
    { 601380, 2, { 780, 771 } },
    { 601400, 2, { 776, 775 } },
    { 601425, 2, { 825, 729 } },
    { 601426, 2, { 833, 722 } },
    { 601470, 2, { 815, 738 } },
    { 601524, 2, { 868, 693 } },
    { 601536, 2, { 832, 723 } },
    { 601552, 2, { 917, 656 } },
    { 601584, 2, { 906, 664 } },
    { 601620, 2, { 813, 740 } },
    { 601640, 2, { 845, 712 } },
    { 601644, 2, { 831, 724 } },
    { 601650, 2, { 955, 630 } },
    { 601680, 2, { 872, 690 } },
    { 601692, 2, { 798, 754 } },
    { 601800, 2, { 850, 708 } },
    { 601812, 2, { 876, 687 } },
    { 601875, 2, { 963, 625 } },
    { 601887, 2, { 793, 759 } },
    { 601920, 2, { 792, 760 } },
    { 601953, 2, { 957, 629 } },
    { 601960, 2, { 808, 745 } },
    { 602004, 2, { 884, 681 } },
    { 602040, 2, { 865, 696 } },
    { 602064, 2, { 888, 678 } },
    { 602070, 2, { 854, 705 } },
    { 602080, 2, { 848, 710 } },
    { 602085, 2, { 979, 615 } },
    { 602100, 2, { 892, 675 } },
    { 602112, 2, { 784, 768 } },
    { 602140, 2, { 782, 770 } },
    { 602154, 2, { 826, 729 } },
    { 602175, 2, { 777, 775 } },
    { 602196, 2, { 804, 749 } },
    { 602208, 2, { 816, 738 } },
    { 602217, 2, { 847, 711 } },
    { 602250, 2, { 803, 750 } },
    { 602272, 2, { 928, 649 } },
    { 602280, 2, { 840, 717 } },
    { 602352, 2, { 801, 752 } },
    { 602364, 2, { 852, 707 } },
    { 602400, 2, { 800, 753 } },
    { 602446, 2, { 799, 754 } },
    { 602469, 2, { 917, 657 } },
    { 602485, 2, { 845, 713 } },
    { 602490, 2, { 798, 755 } },
    { 602547, 2, { 961, 627 } },
    { 602600, 2, { 920, 655 } },
    { 602602, 2, { 946, 637 } },
    { 602640, 2, { 810, 744 } },
    { 602680, 2, { 793, 760 } },
    { 602688, 2, { 876, 688 } },
    { 602700, 2, { 820, 735 } },
    { 602730, 2, { 905, 666 } },
    { 602770, 2, { 790, 763 } },
    { 602784, 2, { 819, 736 } },
    { 602796, 2, { 789, 764 } },
    { 602800, 2, { 880, 685 } },
    { 602820, 2, { 788, 765 } },
    { 602875, 2, { 875, 689 } },
    { 602880, 2, { 785, 768 } },
    { 602888, 2, { 806, 748 } },
    { 602910, 2, { 783, 770 } },
    { 602928, 2, { 848, 711 } },
    { 602952, 2, { 777, 776 } },
    { 602970, 2, { 995, 606 } },
    { 603064, 2, { 847, 712 } },
    { 603075, 2, { 825, 731 } },
    { 603200, 2, { 800, 754 } },
    { 603204, 2, { 903, 668 } },
    { 603288, 2, { 798, 756 } },
    { 603330, 2, { 845, 714 } },
    { 603351, 2, { 1099, 549 } },
    { 603432, 2, { 867, 696 } },
    { 603450, 2, { 810, 745 } },
    { 603477, 2, { 837, 721 } },
    { 603480, 2, { 856, 705 } },
    { 603504, 2, { 792, 762 } },
    { 603520, 2, { 820, 736 } },
    { 603576, 2, { 808, 747 } },
    { 603588, 2, { 843, 716 } },
    { 603603, 2, { 819, 737 } },
    { 603612, 2, { 828, 729 } },
    { 603636, 2, { 807, 748 } },
    { 603648, 2, { 786, 768 } },
    { 603668, 2, { 893, 676 } },
    { 603680, 2, { 784, 770 } },
    { 603725, 2, { 779, 775 } },
    { 603750, 2, { 805, 750 } },
    { 603840, 2, { 816, 740 } },
    { 603856, 2, { 803, 752 } },
    { 603876, 2, { 948, 637 } },
    { 603900, 2, { 825, 732 } },
    { 603911, 2, { 847, 713 } },
    { 603925, 2, { 833, 725 } },
    { 603936, 2, { 864, 699 } },
    { 604000, 2, { 800, 755 } },
    { 604010, 2, { 935, 646 } },
    { 604032, 2, { 832, 726 } },
    { 604044, 2, { 799, 756 } },
    { 604116, 2, { 873, 692 } },
    { 604125, 2, { 895, 675 } },
    { 604164, 2, { 796, 759 } },
    { 604176, 2, { 921, 656 } },
    { 604200, 2, { 795, 760 } },
    { 604219, 2, { 931, 649 } },
    { 604233, 2, { 973, 621 } },
    { 604296, 2, { 792, 763 } },
    { 604310, 2, { 890, 679 } },
    { 604340, 2, { 820, 737 } },
    { 604352, 2, { 994, 608 } },
    { 604395, 2, { 999, 605 } },
    { 604404, 2, { 927, 652 } },
    { 604428, 2, { 836, 723 } },
    { 604440, 2, { 828, 730 } },
    { 604464, 2, { 784, 771 } },
    { 604476, 2, { 783, 772 } },
    { 604485, 2, { 855, 707 } },
    { 604488, 2, { 849, 712 } },
    { 604494, 2, { 781, 774 } },
    { 604500, 2, { 780, 775 } },
    { 604513, 2, { 949, 637 } },
    { 604520, 2, { 889, 680 } },
    { 604560, 2, { 880, 687 } },
    { 604580, 2, { 817, 740 } },
    { 604584, 2, { 933, 648 } },
    { 604608, 2, { 804, 752 } },
    { 604650, 2, { 834, 725 } },
    { 604656, 2, { 816, 741 } },
    { 604675, 2, { 1273, 475 } },
    { 604709, 2, { 1763, 343 } },
    { 604716, 2, { 939, 644 } },
    { 604728, 2, { 888, 681 } },
    { 604752, 2, { 879, 688 } },
    { 604755, 2, { 801, 755 } },
    { 604800, 2, { 800, 756 } },
    { 604824, 2, { 869, 696 } },
    { 604836, 2, { 951, 636 } },
    { 604872, 2, { 813, 744 } },
    { 604877, 2, { 1547, 391 } },
    { 604890, 2, { 846, 715 } },
    { 604950, 2, { 925, 654 } },
    { 604968, 2, { 831, 728 } },
    { 604992, 2, { 822, 736 } },
    { 604996, 2, { 868, 697 } },
    { 605000, 2, { 968, 625 } },
    { 605024, 2, { 1022, 592 } },
    { 605115, 2, { 791, 765 } },
    { 605148, 2, { 844, 717 } },
    { 605192, 2, { 808, 749 } },
    { 605275, 2, { 781, 775 } },
    { 605283, 2, { 779, 777 } },
    { 605340, 2, { 855, 708 } },
    { 605360, 2, { 805, 752 } },
    { 605397, 2, { 817, 741 } },
    { 605412, 2, { 804, 753 } },
    { 605440, 2, { 860, 704 } },
    { 605472, 2, { 816, 742 } },
    { 605475, 2, { 897, 675 } },
    { 605488, 2, { 923, 656 } },
    { 605520, 2, { 841, 720 } },
    { 605535, 2, { 1095, 553 } },
    { 605556, 2, { 801, 756 } },
    { 605616, 2, { 814, 744 } },
    { 605625, 2, { 969, 625 } },
    { 605640, 2, { 824, 735 } },
    { 605682, 2, { 798, 759 } },
    { 605772, 2, { 852, 711 } },
    { 605871, 2, { 1141, 531 } },
    { 605880, 2, { 792, 765 } },
    { 605913, 2, { 903, 671 } },
    { 605952, 2, { 789, 768 } },
    { 605988, 2, { 837, 724 } },
    { 606000, 2, { 808, 750 } },
    { 606040, 2, { 872, 695 } },
    { 606060, 2, { 780, 777 } },
    { 606088, 2, { 959, 632 } },
    { 606144, 2, { 861, 704 } },
    { 606210, 2, { 835, 726 } },
    { 606300, 2, { 860, 705 } },
    { 606320, 2, { 848, 715 } },
    { 606360, 2, { 815, 744 } },
    { 606372, 2, { 897, 676 } },
    { 606390, 2, { 870, 697 } },
    { 606424, 2, { 833, 728 } },
    { 606441, 2, { 799, 759 } },
    { 606480, 2, { 798, 760 } },
    { 606515, 2, { 1085, 559 } },
    { 606528, 2, { 832, 729 } },
    { 606564, 2, { 812, 747 } },
    { 606585, 2, { 795, 763 } },
    { 606645, 2, { 793, 765 } },
    { 606690, 2, { 810, 749 } },
    { 606720, 2, { 790, 768 } },
    { 606732, 2, { 868, 699 } },
    { 606735, 2, { 873, 695 } },
    { 606810, 2, { 895, 678 } },
    { 606816, 2, { 784, 774 } },
    { 606825, 2, { 783, 775 } },
    { 606837, 2, { 781, 777 } },
    { 606864, 2, { 807, 752 } },
    { 606879, 2, { 819, 741 } },
    { 606960, 2, { 843, 720 } },
    { 606970, 2, { 805, 754 } },
    { 607020, 2, { 804, 755 } },
    { 607068, 2, { 803, 756 } },
    { 607110, 2, { 826, 735 } },
    { 607145, 2, { 913, 665 } },
    { 607152, 2, { 834, 728 } },
    { 607185, 2, { 927, 655 } },
    { 607200, 2, { 800, 759 } },
    { 607202, 2, { 841, 722 } },
    { 607212, 2, { 909, 668 } },
    { 607230, 2, { 865, 702 } },
    { 607240, 2, { 799, 760 } },
    { 607257, 2, { 833, 729 } },
    { 607292, 2, { 943, 644 } },
    { 607308, 2, { 884, 687 } },
    { 607320, 2, { 840, 723 } },
    { 607334, 2, { 923, 658 } },
    { 607360, 2, { 832, 730 } },
    { 607380, 2, { 795, 764 } },
    { 607392, 2, { 864, 703 } },
    { 607425, 2, { 975, 623 } },
    { 607452, 2, { 892, 681 } },
    { 607464, 2, { 792, 767 } },
    { 607488, 2, { 791, 768 } },
    { 607500, 2, { 810, 750 } },
    { 607548, 2, { 788, 771 } },
    { 607560, 2, { 830, 732 } },
    { 607590, 2, { 785, 774 } },
    { 607600, 2, { 784, 775 } },
    { 607608, 2, { 783, 776 } },
    { 607620, 2, { 780, 779 } },
    { 607725, 2, { 925, 657 } },
    { 607840, 2, { 928, 655 } },
    { 607848, 2, { 817, 744 } },
    { 607860, 2, { 921, 660 } },
    { 607880, 2, { 835, 728 } },
    { 607884, 2, { 849, 716 } },
    { 607920, 2, { 816, 745 } },
    { 607936, 2, { 826, 736 } },
    { 607950, 2, { 965, 630 } },
    { 608016, 2, { 848, 717 } },
    { 608020, 2, { 860, 707 } },
    { 608025, 2, { 825, 737 } },
    { 608090, 2, { 833, 730 } },
    { 608112, 2, { 824, 738 } },
    { 608124, 2, { 813, 748 } },
    { 608192, 2, { 832, 731 } },
    { 608256, 2, { 792, 768 } },
    { 608268, 2, { 879, 692 } },
    { 608292, 2, { 831, 732 } },
    { 608316, 2, { 933, 652 } },
    { 608391, 2, { 783, 777 } },
    { 608424, 2, { 808, 753 } },
    { 608440, 2, { 820, 742 } },
    { 608465, 2, { 851, 715 } },
    { 608472, 2, { 939, 648 } },
    { 608580, 2, { 805, 756 } },
    { 608608, 2, { 836, 728 } },
    { 608616, 2, { 856, 711 } },
    { 608634, 2, { 867, 702 } },
    { 608640, 2, { 951, 640 } },
    { 608650, 2, { 925, 658 } },
    { 608715, 2, { 835, 729 } },
    { 608730, 2, { 985, 618 } },
    { 608751, 2, { 1089, 559 } },
    { 608760, 2, { 801, 760 } },
    { 608762, 2, { 826, 737 } },
    { 608805, 2, { 815, 747 } },
    { 608825, 2, { 1225, 497 } },
    { 608832, 2, { 906, 672 } },
    { 608850, 2, { 825, 738 } },
    { 608855, 2, { 1105, 551 } },
    { 608888, 2, { 917, 664 } },
    { 608923, 2, { 833, 731 } },
    { 608940, 2, { 796, 765 } },
    { 608960, 2, { 865, 704 } },
    { 609000, 2, { 812, 750 } },
    { 609024, 2, { 793, 768 } },
    { 609026, 2, { 893, 682 } },
    { 609070, 2, { 791, 770 } },
    { 609108, 2, { 789, 772 } },
    { 609120, 2, { 810, 752 } },
    { 609150, 2, { 786, 775 } },
    { 609160, 2, { 785, 776 } },
    { 609168, 2, { 784, 777 } },
    { 609178, 2, { 782, 779 } },
    { 609180, 2, { 781, 780 } },
    { 609224, 2, { 946, 644 } },
    { 609235, 2, { 1007, 605 } },
    { 609280, 2, { 896, 680 } },
    { 609336, 2, { 806, 756 } },
    { 609390, 2, { 915, 666 } },
    { 609408, 2, { 828, 736 } },
    { 609444, 2, { 836, 729 } },
    { 609501, 2, { 867, 703 } },
    { 609525, 2, { 903, 675 } },
    { 609528, 2, { 872, 699 } },
    { 609552, 2, { 816, 747 } },
    { 609588, 2, { 826, 738 } },
    { 609600, 2, { 800, 762 } },
    { 609609, 2, { 957, 637 } },
    { 609615, 2, { 855, 713 } },
    { 609700, 2, { 871, 700 } },
    { 609756, 2, { 833, 732 } },
    { 609765, 2, { 795, 767 } },
    { 609840, 2, { 792, 770 } },
    { 609875, 2, { 875, 697 } },
    { 609936, 2, { 786, 776 } },
    { 609957, 2, { 783, 779 } },
    { 609960, 2, { 782, 780 } },
    { 609966, 2, { 846, 721 } },
    { 610000, 2, { 976, 625 } },
    { 610040, 2, { 808, 755 } },
    { 610056, 2, { 888, 687 } },
    { 610060, 2, { 940, 649 } },
    { 610080, 2, { 820, 744 } },
    { 610090, 2, { 845, 722 } },
    { 610092, 2, { 807, 756 } },
    { 610155, 2, { 819, 745 } },
    { 610176, 2, { 896, 681 } },
    { 610204, 2, { 868, 703 } },
    { 610212, 2, { 844, 723 } },
    { 610236, 2, { 804, 759 } },
    { 610245, 2, { 955, 639 } },
    { 610280, 2, { 803, 760 } },
    { 610332, 2, { 843, 724 } },
    { 610335, 2, { 891, 685 } },
    { 610389, 2, { 999, 611 } },
    { 610400, 2, { 800, 763 } },
    { 610416, 2, { 942, 648 } },
    { 610428, 2, { 903, 676 } },
    { 610470, 2, { 798, 765 } },
    { 610500, 2, { 814, 750 } },
    { 610560, 2, { 795, 768 } },
    { 610566, 2, { 841, 726 } },
    { 610584, 2, { 824, 741 } },
    { 610610, 2, { 793, 770 } },
    { 610632, 2, { 792, 771 } },
    { 610736, 2, { 784, 779 } },
    { 610740, 2, { 783, 780 } },
    { 610827, 2, { 1003, 609 } },
    { 610875, 2, { 905, 675 } },
    { 610880, 2, { 830, 736 } },
    { 610884, 2, { 852, 717 } },
    { 610896, 2, { 858, 712 } },
    { 611010, 2, { 837, 730 } },
    { 611065, 2, { 1027, 595 } },
    { 611072, 2, { 868, 704 } },
    { 611100, 2, { 873, 700 } },
    { 611116, 2, { 817, 748 } },
    { 611156, 2, { 949, 644 } },
    { 611163, 2, { 801, 763 } },
    { 611184, 2, { 816, 749 } },
    { 611220, 2, { 835, 732 } },
    { 611235, 2, { 799, 765 } },
    { 611240, 2, { 826, 740 } },
    { 611250, 2, { 815, 750 } },
    { 611280, 2, { 849, 720 } },
    { 611320, 2, { 899, 680 } },
    { 611325, 2, { 825, 741 } },
    { 611376, 2, { 813, 752 } },
    { 611436, 2, { 812, 753 } },
    { 611442, 2, { 871, 702 } },
    { 611460, 2, { 790, 774 } },
    { 611490, 2, { 935, 654 } },
    { 611505, 2, { 963, 635 } },
    { 611520, 2, { 784, 780 } },
    { 611523, 2, { 783, 781 } },
    { 611534, 2, { 847, 722 } },
    { 611544, 2, { 921, 664 } },
    { 611550, 2, { 810, 755 } },
    { 611568, 2, { 822, 744 } },
    { 611600, 2, { 880, 695 } },
    { 611610, 2, { 870, 703 } },
    { 611611, 2, { 1001, 611 } },
    { 611616, 2, { 831, 736 } },
    { 611632, 2, { 889, 688 } },
    { 611667, 2, { 931, 657 } },
    { 611685, 2, { 985, 621 } },
    { 611712, 2, { 864, 708 } },
    { 611754, 2, { 806, 759 } },
    { 611776, 2, { 869, 704 } },
    { 611784, 2, { 879, 696 } },
    { 611800, 2, { 805, 760 } },
    { 611820, 2, { 927, 660 } },
    { 611832, 2, { 888, 689 } },
    { 611847, 2, { 837, 731 } },
    { 611875, 2, { 979, 625 } },
    { 611940, 2, { 868, 705 } },
    { 611964, 2, { 801, 764 } },
    { 612000, 2, { 800, 765 } },
    { 612040, 2, { 856, 715 } },
    { 612048, 2, { 933, 656 } },
    { 612066, 2, { 798, 767 } },
    { 612105, 2, { 949, 645 } },
    { 612144, 2, { 872, 702 } },
    { 612157, 2, { 961, 637 } },
    { 612180, 2, { 855, 716 } },
    { 612228, 2, { 939, 652 } },
    { 612234, 2, { 791, 774 } },
    { 612255, 2, { 833, 735 } },
    { 612264, 2, { 789, 776 } },
    { 612276, 2, { 788, 777 } },
    { 612300, 2, { 785, 780 } },
    { 612304, 2, { 784, 781 } },
    { 612324, 2, { 876, 699 } },
    { 612390, 2, { 822, 745 } },
    { 612420, 2, { 865, 708 } },
    { 612444, 2, { 951, 644 } },
    { 612480, 2, { 870, 704 } },
    { 612535, 2, { 1295, 473 } },
    { 612540, 2, { 820, 747 } },
    { 612560, 2, { 806, 760 } },
    { 612598, 2, { 893, 686 } },
    { 612612, 2, { 819, 748 } },
    { 612645, 2, { 869, 705 } },
    { 612680, 2, { 901, 680 } },
    { 612684, 2, { 837, 732 } },
    { 612720, 2, { 828, 740 } },
    { 612750, 2, { 817, 750 } },
    { 612794, 2, { 962, 637 } },
    { 612801, 2, { 959, 639 } },
    { 612804, 2, { 892, 687 } },
    { 612850, 2, { 850, 721 } },
    { 612864, 2, { 798, 768 } },
    { 612880, 2, { 815, 752 } },
    { 612900, 2, { 900, 681 } },
    { 612927, 2, { 987, 621 } },
    { 612950, 2, { 943, 650 } },
    { 613008, 2, { 792, 774 } },
    { 613025, 2, { 791, 775 } },
    { 613032, 2, { 861, 712 } },
    { 613088, 2, { 784, 782 } },
    { 613104, 2, { 848, 723 } },
    { 613110, 2, { 955, 642 } },
    { 613125, 2, { 981, 625 } },
    { 613184, 2, { 832, 737 } },
    { 613200, 2, { 840, 730 } },
    { 613263, 2, { 1007, 609 } },
    { 613272, 2, { 808, 759 } },
    { 613320, 2, { 807, 760 } },
    { 613350, 2, { 846, 725 } },
    { 613410, 2, { 805, 762 } },
    { 613431, 2, { 819, 749 } },
    { 613440, 2, { 852, 720 } },
    { 613452, 2, { 804, 763 } },
    { 613470, 2, { 845, 726 } },
    { 613525, 2, { 1067, 575 } },
    { 613536, 2, { 913, 672 } },
    { 613548, 2, { 828, 741 } },
    { 613590, 2, { 905, 678 } },
    { 613600, 2, { 800, 767 } },
    { 613632, 2, { 799, 768 } },
    { 613640, 2, { 920, 667 } },
    { 613700, 2, { 850, 722 } },
    { 613704, 2, { 843, 728 } },
    { 613716, 2, { 796, 771 } },
    { 613740, 2, { 795, 772 } },
    { 613752, 2, { 856, 717 } },
    { 613760, 2, { 896, 685 } },
    { 613782, 2, { 793, 774 } },
    { 613795, 2, { 923, 665 } },
    { 613800, 2, { 792, 775 } },
    { 613816, 2, { 791, 776 } },
    { 613824, 2, { 834, 736 } },
    { 613836, 2, { 867, 708 } },
    { 613872, 2, { 784, 783 } },
    { 613880, 2, { 824, 745 } },
    { 613899, 2, { 891, 689 } },
    { 613921, 2, { 833, 737 } },
    { 614016, 2, { 832, 738 } },
    { 614040, 2, { 840, 731 } },
    { 614055, 2, { 871, 705 } },
    { 614061, 2, { 1083, 567 } },
    { 614075, 2, { 847, 725 } },
    { 614169, 2, { 989, 621 } },
    { 614180, 2, { 820, 749 } },
    { 614250, 2, { 819, 750 } },
    { 614292, 2, { 852, 721 } },
    { 614295, 2, { 803, 765 } },
    { 614304, 2, { 864, 711 } },
    { 614376, 2, { 828, 742 } },
    { 614385, 2, { 999, 615 } },
    { 614390, 2, { 917, 670 } },
    { 614400, 2, { 800, 768 } },
    { 614422, 2, { 851, 722 } },
    { 614448, 2, { 816, 753 } },
    { 614482, 2, { 901, 682 } },
    { 614484, 2, { 909, 676 } },
    { 614544, 2, { 826, 744 } },
    { 614560, 2, { 835, 736 } },
    { 614575, 2, { 793, 775 } },
    { 614628, 2, { 813, 756 } },
    { 614655, 2, { 785, 783 } },
    { 614676, 2, { 849, 724 } },
    { 614680, 2, { 968, 635 } },
    { 614718, 2, { 923, 666 } },
    { 614754, 2, { 833, 738 } },
    { 614760, 2, { 872, 705 } },
    { 614790, 2, { 810, 759 } },
    { 614800, 2, { 848, 725 } },
    { 614859, 2, { 1273, 483 } },
    { 614910, 2, { 995, 618 } },
    { 614916, 2, { 899, 684 } },
    { 614936, 2, { 973, 632 } },
    { 614940, 2, { 831, 740 } },
    { 614992, 2, { 952, 646 } },
    { 615015, 2, { 865, 711 } },
    { 615040, 2, { 961, 640 } },
    { 615043, 2, { 1573, 391 } },
    { 615060, 2, { 804, 765 } },
    { 615072, 2, { 894, 688 } },
    { 615090, 2, { 870, 707 } },
    { 615120, 2, { 880, 699 } },
    { 615125, 2, { 875, 703 } },
    { 615160, 2, { 845, 728 } },
    { 615168, 2, { 801, 768 } },
    { 615195, 2, { 837, 735 } },
    { 615228, 2, { 921, 668 } },
    { 615230, 2, { 799, 770 } },
    { 615252, 2, { 869, 708 } },
    { 615264, 2, { 816, 754 } },
    { 615276, 2, { 844, 729 } },
    { 615285, 2, { 1017, 605 } },
    { 615300, 2, { 879, 700 } },
    { 615328, 2, { 938, 656 } },
    { 615330, 2, { 795, 774 } },
    { 615342, 2, { 897, 686 } },
    { 615384, 2, { 792, 777 } },
    { 615420, 2, { 789, 780 } },
    { 615440, 2, { 785, 784 } },
    { 615505, 2, { 1045, 589 } },
    { 615528, 2, { 824, 747 } },
    { 615552, 2, { 896, 687 } },
    { 615600, 2, { 810, 760 } },
    { 615624, 2, { 904, 681 } },
    { 615648, 2, { 848, 726 } },
    { 615680, 2, { 832, 740 } },
    { 615696, 2, { 808, 762 } },
    { 615780, 2, { 933, 660 } },
    { 615825, 2, { 805, 765 } },
    { 615880, 2, { 865, 712 } },
    { 615888, 2, { 819, 752 } },
    { 615978, 2, { 918, 671 } },
    { 615984, 2, { 939, 656 } },
    { 615996, 2, { 852, 723 } },
    { 616000, 2, { 800, 770 } },
    { 616005, 2, { 845, 729 } },
    { 616018, 2, { 817, 754 } },
    { 616050, 2, { 925, 666 } },
    { 616077, 2, { 889, 693 } },
    { 616080, 2, { 816, 755 } },
    { 616140, 2, { 815, 756 } },
    { 616148, 2, { 884, 697 } },
    { 616161, 2, { 793, 777 } },
    { 616200, 2, { 790, 780 } },
    { 616224, 2, { 786, 784 } },
    { 616230, 2, { 835, 738 } },
    { 616248, 2, { 951, 648 } },
    { 616284, 2, { 901, 684 } },
    { 616308, 2, { 812, 759 } },
    { 616420, 2, { 833, 740 } },
    { 616455, 2, { 855, 721 } },
    { 616476, 2, { 861, 716 } },
    { 616504, 2, { 808, 763 } },
    { 616512, 2, { 832, 741 } },
    { 616548, 2, { 807, 764 } },
    { 616550, 2, { 950, 649 } },
    { 616572, 2, { 891, 692 } },
    { 616590, 2, { 806, 765 } },
    { 616605, 2, { 1111, 555 } },
    { 616616, 2, { 847, 728 } },
    { 616620, 2, { 860, 717 } },
    { 616635, 2, { 965, 639 } },
    { 616704, 2, { 803, 768 } },
    { 616714, 2, { 899, 686 } },
    { 616800, 2, { 800, 771 } },
    { 616860, 2, { 828, 745 } },
    { 616869, 2, { 837, 737 } },
    { 616896, 2, { 816, 756 } },
    { 616920, 2, { 795, 776 } },
    { 616968, 2, { 792, 779 } },
    { 616975, 2, { 851, 725 } },
    { 616980, 2, { 791, 780 } },
    { 617004, 2, { 788, 783 } },
    { 617010, 2, { 786, 785 } },
    { 617015, 2, { 1037, 595 } },
    { 617050, 2, { 1025, 602 } },
    { 617076, 2, { 843, 732 } },
    { 617100, 2, { 825, 748 } },
    { 617120, 2, { 812, 760 } },
    { 617136, 2, { 897, 688 } },
    { 617148, 2, { 868, 711 } },
    { 617176, 2, { 824, 749 } },
    { 617211, 2, { 873, 707 } },
    { 617253, 2, { 833, 741 } },
    { 617304, 2, { 867, 712 } },
    { 617320, 2, { 920, 671 } },
    { 617344, 2, { 832, 742 } },
    { 617400, 2, { 840, 735 } },
    { 617435, 2, { 805, 767 } },
    { 617460, 2, { 820, 753 } },
    { 617463, 2, { 847, 729 } },
    { 617472, 2, { 804, 768 } },
    { 617520, 2, { 830, 744 } },
    { 617526, 2, { 819, 754 } },
    { 617550, 2, { 895, 690 } },
    { 617580, 2, { 846, 730 } },
    { 617610, 2, { 865, 714 } },
    { 617625, 2, { 915, 675 } },
    { 617695, 2, { 845, 731 } },
    { 617700, 2, { 852, 725 } },
    { 617760, 2, { 792, 780 } },
    { 617799, 2, { 949, 651 } },
    { 617880, 2, { 813, 760 } },
    { 617890, 2, { 910, 679 } },
    { 617895, 2, { 995, 621 } },
    { 617916, 2, { 884, 699 } },
    { 617925, 2, { 825, 749 } },
    { 617952, 2, { 942, 656 } },
    { 618000, 2, { 824, 750 } },
    { 618030, 2, { 810, 763 } },
    { 618072, 2, { 849, 728 } },
    { 618084, 2, { 873, 708 } },
    { 618120, 2, { 808, 765 } },
    { 618125, 2, { 989, 625 } },
    { 618135, 2, { 841, 735 } },
    { 618144, 2, { 822, 752 } },
    { 618156, 2, { 892, 693 } },
    { 618171, 2, { 867, 713 } },
    { 618184, 2, { 931, 664 } },
    { 618192, 2, { 848, 729 } },
    { 618233, 2, { 1147, 539 } },
    { 618240, 2, { 805, 768 } },
    { 618254, 2, { 1027, 602 } },
    { 618264, 2, { 831, 744 } },
    { 618300, 2, { 900, 687 } },
    { 618310, 2, { 803, 770 } },
    { 618320, 2, { 944, 655 } },
    { 618332, 2, { 1012, 611 } },
    { 618345, 2, { 819, 755 } },
    { 618372, 2, { 801, 772 } },
    { 618426, 2, { 799, 774 } },
    { 618450, 2, { 798, 775 } },
    { 618492, 2, { 796, 777 } },
    { 618516, 2, { 828, 747 } },
    { 618540, 2, { 793, 780 } },
    { 618552, 2, { 792, 781 } },
    { 618570, 2, { 790, 783 } },
    { 618576, 2, { 789, 784 } },
    { 618625, 2, { 875, 707 } },
    { 618640, 2, { 814, 760 } },
    { 618723, 2, { 1127, 549 } },
    { 618765, 2, { 1065, 581 } },
    { 618772, 2, { 902, 686 } },
    { 618813, 2, { 1107, 559 } },
    { 618816, 2, { 879, 704 } },
    { 618849, 2, { 893, 693 } },
    { 618888, 2, { 856, 723 } },
    { 618912, 2, { 921, 672 } },
    { 618936, 2, { 888, 697 } },
    { 618975, 2, { 917, 675 } },
    { 618976, 2, { 841, 736 } },
    { 619008, 2, { 806, 768 } },
    { 619020, 2, { 855, 724 } },
    { 619040, 2, { 848, 730 } },
    { 619080, 2, { 804, 770 } },
    { 619146, 2, { 954, 649 } },
    { 619150, 2, { 854, 725 } },
    { 619157, 2, { 847, 731 } },
    { 619164, 2, { 819, 756 } },
    { 619200, 2, { 800, 774 } },
    { 619225, 2, { 799, 775 } },
    { 619236, 2, { 927, 668 } },
    { 619240, 2, { 904, 685 } },
    { 619245, 2, { 891, 695 } },
    { 619248, 2, { 798, 776 } },
    { 619332, 2, { 876, 707 } },
    { 619344, 2, { 792, 782 } },
    { 619353, 2, { 791, 783 } },
    { 619360, 2, { 790, 784 } },
    { 619380, 2, { 837, 740 } },
    { 619400, 2, { 815, 760 } },
    { 619440, 2, { 870, 712 } },
    { 619476, 2, { 836, 741 } },
    { 619488, 2, { 864, 717 } },
    { 619500, 2, { 826, 750 } },
    { 619512, 2, { 933, 664 } },
    { 619528, 2, { 851, 728 } },
    { 619530, 2, { 965, 642 } },
    { 619650, 2, { 810, 765 } },
    { 619740, 2, { 939, 660 } },
    { 619752, 2, { 833, 744 } },
    { 619760, 2, { 976, 635 } },
    { 619776, 2, { 807, 768 } },
    { 619840, 2, { 832, 745 } },
    { 619875, 2, { 855, 725 } },
    { 619884, 2, { 804, 771 } },
    { 619905, 2, { 867, 715 } },
    { 619920, 2, { 820, 756 } },
    { 619992, 2, { 872, 711 } },
    { 620000, 2, { 800, 775 } },
    { 620004, 2, { 847, 732 } },
    { 620052, 2, { 951, 652 } },
    { 620060, 2, { 860, 721 } },
    { 620100, 2, { 795, 780 } },
    { 620103, 2, { 817, 759 } },
    { 620136, 2, { 792, 783 } },
    { 620144, 2, { 791, 784 } },
    { 620160, 2, { 816, 760 } },
    { 620165, 2, { 1015, 611 } },
    { 620172, 2, { 828, 749 } },
    { 620235, 2, { 895, 693 } },
    { 620310, 2, { 870, 713 } },
    { 620340, 2, { 844, 735 } },
    { 620379, 2, { 851, 729 } },
    { 620400, 2, { 825, 752 } },
    { 620425, 2, { 1079, 575 } },
    { 620448, 2, { 843, 736 } },
    { 620466, 2, { 869, 714 } },
    { 620472, 2, { 824, 753 } },
    { 620496, 2, { 834, 744 } },
    { 620508, 2, { 996, 623 } },
    { 620550, 2, { 985, 630 } },
    { 620568, 2, { 884, 702 } },
    { 620600, 2, { 856, 725 } },
    { 620610, 2, { 822, 755 } },
    { 620620, 2, { 806, 770 } },
    { 620675, 2, { 925, 671 } },
    { 620712, 2, { 888, 699 } },
    { 620724, 2, { 897, 692 } },
    { 620736, 2, { 848, 732 } },
    { 620739, 2, { 1169, 531 } },
    { 620772, 2, { 867, 716 } },
    { 620775, 2, { 801, 775 } },
    { 620806, 2, { 961, 646 } },
    { 620823, 2, { 799, 777 } },
    { 620895, 2, { 795, 781 } },
    { 620919, 2, { 793, 783 } },
    { 620920, 2, { 817, 760 } },
    { 620977, 2, { 931, 667 } },
    { 621000, 2, { 828, 750 } },
    { 621027, 2, { 891, 697 } },
    { 621030, 2, { 815, 762 } },
    { 621048, 2, { 904, 687 } },
    { 621054, 2, { 837, 742 } },
    { 621075, 2, { 845, 735 } },
    { 621108, 2, { 852, 729 } },
    { 621132, 2, { 813, 764 } },
    { 621152, 2, { 826, 752 } },
    { 621180, 2, { 812, 765 } },
    { 621240, 2, { 835, 744 } },
    { 621264, 2, { 903, 688 } },
    { 621270, 2, { 810, 767 } },
    { 621285, 2, { 915, 679 } },
    { 621330, 2, { 834, 745 } },
    { 621350, 2, { 850, 731 } },
    { 621376, 2, { 1022, 608 } },
    { 621425, 2, { 1325, 469 } },
    { 621452, 2, { 884, 703 } },
    { 621456, 2, { 856, 726 } },
    { 621468, 2, { 849, 732 } },
    { 621478, 2, { 902, 689 } },
    { 621504, 2, { 832, 747 } },
    { 621522, 2, { 803, 774 } },
    { 621528, 2, { 893, 696 } },
    { 621575, 2, { 1081, 575 } },
    { 621576, 2, { 801, 776 } },
    { 621588, 2, { 831, 748 } },
    { 621600, 2, { 800, 777 } },
    { 621621, 2, { 819, 759 } },
    { 621642, 2, { 798, 779 } },
    { 621670, 2, { 830, 749 } },
    { 621712, 2, { 793, 784 } },
    { 621720, 2, { 792, 785 } },
    { 621732, 2, { 789, 788 } },
    { 621747, 2, { 973, 639 } },
    { 621756, 2, { 909, 684 } },
    { 621760, 2, { 928, 670 } },
    { 621780, 2, { 860, 723 } },
    { 621792, 2, { 816, 762 } },
    { 621810, 2, { 846, 735 } },
    { 621860, 2, { 1003, 620 } },
    { 621888, 2, { 948, 656 } },
    { 621894, 2, { 871, 714 } },
    { 621920, 2, { 845, 736 } },
    { 621960, 2, { 852, 730 } },
    { 622050, 2, { 825, 754 } },
    { 622080, 2, { 810, 768 } },
    { 622120, 2, { 824, 755 } },
    { 622125, 2, { 875, 711 } },
    { 622167, 2, { 903, 689 } },
    { 622200, 2, { 850, 732 } },
    { 622224, 2, { 894, 696 } },
    { 622251, 2, { 833, 747 } },
    { 622300, 2, { 889, 700 } },
    { 622325, 2, { 803, 775 } },
    { 622332, 2, { 879, 708 } },
    { 622336, 2, { 832, 748 } },
    { 622356, 2, { 868, 717 } },
    { 622380, 2, { 820, 759 } },
    { 622440, 2, { 798, 780 } },
    { 622485, 2, { 795, 783 } },
    { 622512, 2, { 792, 786 } },
    { 622544, 2, { 949, 656 } },
    { 622545, 2, { 847, 735 } },
    { 622566, 2, { 854, 729 } },
    { 622596, 2, { 921, 676 } },
    { 622608, 2, { 816, 763 } },
    { 622644, 2, { 979, 636 } },
    { 622656, 2, { 828, 752 } },
    { 622665, 2, { 909, 685 } },
    { 622688, 2, { 928, 671 } },
    { 622710, 2, { 814, 765 } },
    { 622720, 2, { 896, 695 } },
    { 622728, 2, { 837, 744 } },
    { 622800, 2, { 865, 720 } },
    { 622804, 2, { 812, 767 } },
    { 622836, 2, { 876, 711 } },
    { 622863, 2, { 1003, 621 } },
    { 622935, 2, { 981, 635 } },
    { 622968, 2, { 808, 771 } },
    { 623000, 2, { 875, 712 } },
    { 623004, 2, { 807, 772 } },
    { 623007, 2, { 899, 693 } },
    { 623025, 2, { 923, 675 } },
    { 623040, 2, { 880, 708 } },
    { 623070, 2, { 805, 774 } },
    { 623100, 2, { 804, 775 } },
    { 623133, 2, { 1099, 567 } },
    { 623162, 2, { 874, 713 } },
    { 623168, 2, { 832, 749 } },
    { 623181, 2, { 841, 741 } },
    { 623200, 2, { 800, 779 } },
    { 623220, 2, { 799, 780 } },
    { 623238, 2, { 798, 781 } },
    { 623244, 2, { 933, 668 } },
    { 623268, 2, { 796, 783 } },
    { 623280, 2, { 795, 784 } },
    { 623295, 2, { 855, 729 } },
    { 623328, 2, { 906, 688 } },
    { 623364, 2, { 861, 724 } },
    { 623376, 2, { 888, 702 } },
    { 623392, 2, { 847, 736 } },
    { 623441, 2, { 1183, 527 } },
    { 623475, 2, { 815, 765 } },
    { 623480, 2, { 872, 715 } },
    { 623484, 2, { 828, 753 } },
    { 623496, 2, { 939, 664 } },
    { 623502, 2, { 846, 737 } },
    { 623508, 2, { 892, 699 } },
    { 623560, 2, { 917, 680 } },
    { 623565, 2, { 837, 745 } },
    { 623574, 2, { 882, 707 } },
    { 623610, 2, { 845, 738 } },
    { 623616, 2, { 812, 768 } },
    { 623623, 2, { 979, 637 } },
    { 623645, 2, { 935, 667 } },
    { 623700, 2, { 810, 770 } },
    { 623745, 2, { 835, 747 } },
    { 623760, 2, { 904, 690 } },
    { 623770, 2, { 931, 670 } },
    { 623796, 2, { 908, 687 } },
    { 623808, 2, { 864, 722 } },
    { 623820, 2, { 843, 740 } },
    { 623856, 2, { 951, 656 } },
    { 623931, 2, { 803, 777 } },
    { 623964, 2, { 957, 652 } },
    { 623968, 2, { 992, 629 } },
    { 624000, 2, { 800, 780 } },
    { 624024, 2, { 856, 729 } },
    { 624036, 2, { 798, 782 } },
    { 624105, 2, { 1005, 621 } },
    { 624160, 2, { 830, 752 } },
    { 624195, 2, { 873, 715 } },
    { 624225, 2, { 861, 725 } },
    { 624240, 2, { 816, 765 } },
    { 624312, 2, { 828, 754 } },
    { 624338, 2, { 814, 767 } },
    { 624340, 2, { 1007, 620 } },
    { 624375, 2, { 925, 675 } },
    { 624384, 2, { 813, 768 } },
    { 624393, 2, { 901, 693 } },
    { 624442, 2, { 949, 658 } },
    { 624450, 2, { 905, 690 } },
    { 624456, 2, { 826, 756 } },
    { 624492, 2, { 836, 747 } },
    { 624512, 2, { 896, 697 } },
    { 624570, 2, { 955, 654 } },
    { 624575, 2, { 1075, 581 } },
    { 624624, 2, { 858, 728 } },
    { 624672, 2, { 864, 723 } },
    { 624680, 2, { 805, 776 } },
    { 624701, 2, { 931, 671 } },
    { 624708, 2, { 804, 777 } },
    { 624720, 2, { 822, 760 } },
    { 624750, 2, { 833, 750 } },
    { 624780, 2, { 801, 780 } },
    { 624800, 2, { 800, 781 } },
    { 624864, 2, { 849, 736 } },
    { 624876, 2, { 903, 692 } },
    { 624888, 2, { 792, 789 } },
    { 624890, 2, { 791, 790 } },
    { 624897, 2, { 819, 763 } },
    { 624910, 2, { 874, 715 } },
    { 624912, 2, { 831, 752 } },
    { 624976, 2, { 848, 737 } },
    { 625005, 2, { 817, 765 } },
    { 625053, 2, { 1023, 611 } },
    { 625068, 2, { 873, 716 } },
    { 625086, 2, { 847, 738 } },
    { 625100, 2, { 893, 700 } },
    { 625140, 2, { 828, 755 } },
    { 625152, 2, { 814, 768 } },
    { 625209, 2, { 897, 697 } },
    { 625224, 2, { 872, 717 } },
    { 625347, 2, { 1007, 621 } },
    { 625392, 2, { 808, 774 } },
    { 625404, 2, { 844, 741 } },
    { 625416, 2, { 824, 759 } },
    { 625443, 2, { 1027, 609 } },
    { 625482, 2, { 858, 729 } },
    { 625488, 2, { 942, 664 } },
    { 625600, 2, { 800, 782 } },
    { 625617, 2, { 799, 783 } },
    { 625625, 2, { 875, 715 } },
    { 625632, 2, { 798, 784 } },
    { 625660, 2, { 820, 763 } },
    { 625680, 2, { 792, 790 } },
    { 625695, 2, { 885, 707 } },
    { 625716, 2, { 819, 764 } },
    { 625800, 2, { 840, 745 } },
    { 625807, 2, { 1183, 529 } },
    { 625824, 2, { 848, 738 } },
    { 625848, 2, { 879, 712 } },
    { 625856, 2, { 889, 704 } },
    { 625860, 2, { 855, 732 } },
    { 625872, 2, { 816, 767 } },
    { 625920, 2, { 815, 768 } },
    { 625974, 2, { 867, 722 } },
    { 625975, 2, { 1225, 511 } },
    { 626052, 2, { 812, 771 } },
    { 626076, 2, { 837, 748 } },
    { 626115, 2, { 1005, 623 } },
    { 626175, 2, { 825, 759 } },
    { 626200, 2, { 808, 775 } },
    { 626220, 2, { 852, 735 } },
    { 626232, 2, { 807, 776 } },
    { 626250, 2, { 835, 750 } },
    { 626275, 2, { 1025, 611 } },
    { 626280, 2, { 921, 680 } },
    { 626304, 2, { 896, 699 } },
    { 626318, 2, { 913, 686 } },
    { 626336, 2, { 851, 736 } },
    { 626340, 2, { 803, 780 } },
    { 626373, 2, { 891, 703 } },
    { 626400, 2, { 800, 783 } },
    { 626409, 2, { 1141, 549 } },
    { 626416, 2, { 799, 784 } },
    { 626430, 2, { 798, 785 } },
    { 626450, 2, { 850, 737 } },
    { 626460, 2, { 795, 788 } },
    { 626472, 2, { 792, 791 } },
    { 626496, 2, { 832, 753 } },
    { 626544, 2, { 912, 687 } },
    { 626580, 2, { 885, 708 } },
    { 626652, 2, { 927, 676 } },
    { 626688, 2, { 816, 768 } },
    { 626725, 2, { 1075, 583 } },
    { 626745, 2, { 889, 705 } },
    { 626780, 2, { 814, 770 } },
    { 626808, 2, { 861, 728 } },
    { 626850, 2, { 995, 630 } },
    { 626875, 2, { 1003, 625 } },
    { 626913, 2, { 837, 749 } },
    { 626976, 2, { 933, 672 } },
    { 627000, 2, { 825, 760 } },
    { 627072, 2, { 852, 736 } },
    { 627095, 2, { 805, 779 } },
    { 627096, 2, { 901, 696 } },
    { 627130, 2, { 1054, 595 } },
    { 627150, 2, { 925, 678 } },
    { 627165, 2, { 905, 693 } },
    { 627168, 2, { 834, 752 } },
    { 627192, 2, { 843, 744 } },
    { 627198, 2, { 858, 731 } },
    { 627200, 2, { 800, 784 } },
    { 627252, 2, { 939, 668 } },
    { 627270, 2, { 870, 721 } },
    { 627300, 2, { 820, 765 } },
    { 627328, 2, { 832, 754 } },
    { 627396, 2, { 924, 679 } },
    { 627435, 2, { 955, 657 } },
    { 627440, 2, { 880, 713 } },
    { 627456, 2, { 817, 768 } },
    { 627480, 2, { 830, 756 } },
    { 627564, 2, { 868, 723 } },
    { 627627, 2, { 847, 741 } },
    { 627636, 2, { 813, 772 } },
    { 627660, 2, { 951, 660 } },
    { 627669, 2, { 861, 729 } },
    { 627690, 2, { 854, 735 } },
    { 627705, 2, { 1073, 585 } },
    { 627708, 2, { 867, 724 } },
    { 627732, 2, { 846, 742 } },
    { 627750, 2, { 810, 775 } },
    { 627760, 2, { 826, 760 } },
    { 627792, 2, { 902, 696 } },
    { 627816, 2, { 808, 777 } },
    { 627874, 2, { 806, 779 } },
    { 627876, 2, { 963, 652 } },
    { 627888, 2, { 824, 762 } },
    { 627900, 2, { 805, 780 } },
    { 627920, 2, { 835, 752 } },
    { 627924, 2, { 804, 781 } },
    { 627984, 2, { 801, 784 } },
    { 627990, 2, { 865, 726 } },
    { 628000, 2, { 800, 785 } },
    { 628044, 2, { 796, 789 } },
    { 628056, 2, { 793, 792 } },
    { 628075, 2, { 925, 679 } },
    { 628082, 2, { 833, 754 } },
    { 628092, 2, { 876, 717 } },
    { 628144, 2, { 913, 688 } },
    { 628155, 2, { 891, 705 } },
    { 628160, 2, { 832, 755 } },
    { 628173, 2, { 819, 767 } },
    { 628236, 2, { 831, 756 } },
    { 628260, 2, { 849, 740 } },
    { 628280, 2, { 904, 695 } },
    { 628290, 2, { 895, 702 } },
    { 628320, 2, { 816, 770 } },
    { 628368, 2, { 848, 741 } },
    { 628452, 2, { 828, 759 } },
    { 628524, 2, { 884, 711 } },
    { 628544, 2, { 854, 736 } },
    { 628560, 2, { 810, 776 } },
    { 628680, 2, { 806, 780 } },
    { 628705, 2, { 805, 781 } },
    { 628712, 2, { 824, 763 } },
    { 628749, 2, { 803, 783 } },
    { 628785, 2, { 801, 785 } },
    { 628800, 2, { 800, 786 } },
    { 628815, 2, { 1133, 555 } },
    { 628845, 2, { 795, 791 } },
    { 628860, 2, { 892, 705 } },
    { 628866, 2, { 882, 713 } },
    { 628929, 2, { 1043, 603 } },
    { 628940, 2, { 820, 767 } },
    { 628992, 2, { 819, 768 } },
    { 629028, 2, { 909, 692 } },
    { 629068, 2, { 841, 748 } },
    { 629090, 2, { 817, 770 } },
    { 629100, 2, { 900, 699 } },
    { 629104, 2, { 959, 656 } },
    { 629136, 2, { 816, 771 } },
    { 629160, 2, { 840, 749 } },
    { 629200, 2, { 880, 715 } },
    { 629230, 2, { 890, 707 } },
    { 629244, 2, { 908, 693 } },
    { 629364, 2, { 879, 716 } },
    { 629370, 2, { 810, 777 } },
    { 629375, 2, { 1007, 625 } },
    { 629376, 2, { 894, 704 } },
    { 629391, 2, { 861, 731 } },
    { 629398, 2, { 854, 737 } },
    { 629415, 2, { 985, 639 } },
    { 629424, 2, { 837, 752 } },
    { 629433, 2, { 873, 721 } },
    { 629442, 2, { 867, 726 } },
    { 629460, 2, { 807, 780 } },
    { 629475, 2, { 825, 763 } },
    { 629508, 2, { 836, 753 } },
    { 629532, 2, { 804, 783 } },
    { 629552, 2, { 803, 784 } },
    { 629629, 2, { 1001, 629 } },
    { 629640, 2, { 795, 792 } },
    { 629670, 2, { 834, 755 } },
    { 629694, 2, { 897, 702 } },
    { 629720, 2, { 865, 728 } },
    { 629748, 2, { 833, 756 } },
    { 629760, 2, { 820, 768 } },
    { 629825, 2, { 1475, 427 } },
    { 629850, 2, { 850, 741 } },
    { 629856, 2, { 864, 729 } },
    { 629888, 2, { 896, 703 } },
    { 629920, 2, { 992, 635 } },
    { 629937, 2, { 891, 707 } },
    { 629964, 2, { 921, 684 } },
    { 629993, 2, { 989, 637 } },
    { 630000, 2, { 840, 750 } },
    { 630025, 2, { 869, 725 } },
    { 630063, 2, { 959, 657 } },
    { 630120, 2, { 885, 712 } },
    { 630135, 2, { 855, 737 } },
    { 630168, 2, { 847, 744 } },
    { 630200, 2, { 920, 685 } },
    { 630252, 2, { 854, 738 } },
    { 630270, 2, { 846, 745 } },
    { 630300, 2, { 825, 764 } },
    { 630315, 2, { 805, 783 } },
    { 630336, 2, { 804, 784 } },
    { 630344, 2, { 836, 754 } },
    { 630360, 2, { 824, 765 } },
    { 630435, 2, { 795, 793 } },
    { 630456, 2, { 872, 723 } },
    { 630468, 2, { 844, 747 } },
    { 630476, 2, { 979, 644 } },
    { 630552, 2, { 1032, 611 } },
    { 630564, 2, { 843, 748 } },
    { 630576, 2, { 906, 696 } },
    { 630585, 2, { 865, 729 } },
    { 630591, 2, { 851, 741 } },
    { 630700, 2, { 850, 742 } },
    { 630708, 2, { 933, 676 } },
    { 630720, 2, { 864, 730 } },
    { 630740, 2, { 940, 671 } },
    { 630750, 2, { 841, 750 } },
    { 630765, 2, { 963, 655 } },
    { 630810, 2, { 815, 774 } },
    { 630828, 2, { 891, 708 } },
    { 630850, 2, { 814, 775 } },
    { 630875, 2, { 875, 721 } },
    { 630888, 2, { 813, 776 } },
    { 630896, 2, { 917, 688 } },
    { 630924, 2, { 812, 777 } },
    { 630960, 2, { 880, 717 } },
    { 630990, 2, { 810, 779 } },
    { 631008, 2, { 939, 672 } },
    { 631071, 2, { 1113, 567 } },
    { 631085, 2, { 949, 665 } },
    { 631098, 2, { 806, 783 } },
    { 631110, 2, { 965, 654 } },
    { 631120, 2, { 805, 784 } },
    { 631140, 2, { 804, 785 } },
    { 631176, 2, { 867, 728 } },
    { 631188, 2, { 801, 788 } },
    { 631190, 2, { 889, 710 } },
    { 631200, 2, { 800, 789 } },
    { 631215, 2, { 845, 747 } },
    { 631260, 2, { 835, 756 } },
    { 631296, 2, { 822, 768 } },
    { 631332, 2, { 852, 741 } },
    { 631368, 2, { 888, 711 } },
    { 631389, 2, { 1007, 627 } },
    { 631455, 2, { 979, 645 } },
    { 631464, 2, { 951, 664 } },
    { 631465, 2, { 1445, 437 } },
    { 631470, 2, { 930, 679 } },
    { 631475, 2, { 871, 725 } },
    { 631488, 2, { 832, 759 } },
    { 631533, 2, { 1037, 609 } },
    { 631560, 2, { 831, 760 } },
    { 631584, 2, { 816, 774 } },
    { 631596, 2, { 876, 721 } },
    { 631605, 2, { 1027, 615 } },
    { 631656, 2, { 849, 744 } },
    { 631728, 2, { 856, 738 } },
    { 631750, 2, { 875, 722 } },
    { 631755, 2, { 909, 695 } },
    { 631760, 2, { 848, 745 } },
    { 631764, 2, { 828, 763 } },
    { 631788, 2, { 969, 652 } },
    { 631800, 2, { 810, 780 } },
    { 631890, 2, { 826, 765 } },
    { 631896, 2, { 904, 699 } },
    { 631904, 2, { 806, 784 } },
    { 631935, 2, { 837, 755 } },
    { 631960, 2, { 854, 740 } },
    { 632000, 2, { 800, 790 } },
    { 632016, 2, { 798, 792 } },
    { 632034, 2, { 949, 666 } },
    { 632043, 2, { 867, 729 } },
    { 632052, 2, { 873, 724 } },
    { 632079, 2, { 889, 711 } },
    { 632100, 2, { 860, 735 } },
    { 632200, 2, { 872, 725 } },
    { 632220, 2, { 820, 771 } },
    { 632247, 2, { 833, 759 } },
    { 632268, 2, { 819, 772 } },
    { 632320, 2, { 832, 760 } },
    { 632370, 2, { 985, 642 } },
    { 632400, 2, { 816, 775 } },
    { 632440, 2, { 815, 776 } },
    { 632448, 2, { 864, 732 } },
    { 632480, 2, { 944, 670 } },
    { 632500, 2, { 1012, 625 } },
    { 632502, 2, { 901, 702 } },
    { 632520, 2, { 840, 753 } },
    { 632548, 2, { 812, 779 } },
    { 632555, 2, { 1085, 583 } },
    { 632610, 2, { 810, 781 } },
    { 632632, 2, { 869, 728 } },
    { 632664, 2, { 808, 783 } },
    { 632688, 2, { 807, 784 } },
    { 632700, 2, { 855, 740 } },
    { 632709, 2, { 847, 747 } },
    { 632730, 2, { 805, 786 } },
    { 632772, 2, { 837, 756 } },
    { 632775, 2, { 825, 767 } },
    { 632800, 2, { 800, 791 } },
    { 632808, 2, { 799, 792 } },
    { 632814, 2, { 798, 793 } },
    { 632820, 2, { 796, 795 } },
    { 632880, 2, { 879, 720 } },
    { 632896, 2, { 899, 704 } },
    { 632925, 2, { 873, 725 } },
    { 632960, 2, { 860, 736 } },
    { 632968, 2, { 889, 712 } },
    { 633024, 2, { 942, 672 } },
    { 633072, 2, { 872, 726 } },
    { 633080, 2, { 833, 760 } },
    { 633144, 2, { 851, 744 } },
    { 633150, 2, { 938, 675 } },
    { 633175, 2, { 817, 775 } },
    { 633178, 2, { 923, 686 } },
    { 633180, 2, { 865, 732 } },
    { 633213, 2, { 1197, 529 } },
    { 633290, 2, { 830, 763 } },
    { 633325, 2, { 1175, 539 } },
    { 633348, 2, { 876, 723 } },
    { 633360, 2, { 812, 780 } },
    { 633420, 2, { 810, 782 } },
    { 633424, 2, { 944, 671 } },
    { 633450, 2, { 1025, 618 } },
    { 633456, 2, { 848, 747 } },
    { 633501, 2, { 869, 729 } },
    { 633591, 2, { 801, 791 } },
    { 633600, 2, { 800, 792 } },
    { 633648, 2, { 921, 688 } },
    { 633654, 2, { 846, 749 } },
    { 633660, 2, { 885, 716 } },
    { 633696, 2, { 861, 736 } },
    { 633750, 2, { 845, 750 } },
    { 633820, 2, { 860, 737 } },
    { 633828, 2, { 884, 717 } },
    { 633840, 2, { 834, 760 } },
    { 633880, 2, { 920, 689 } },
    { 633919, 2, { 1573, 403 } },
    { 633930, 2, { 935, 678 } },
    { 633936, 2, { 843, 752 } },
    { 633984, 2, { 832, 762 } },
    { 634005, 2, { 965, 657 } },
    { 634032, 2, { 816, 777 } },
    { 634040, 2, { 968, 655 } },
    { 634068, 2, { 927, 684 } },
    { 634088, 2, { 871, 728 } },
    { 634106, 2, { 814, 779 } },
    { 634140, 2, { 813, 780 } },
    { 634144, 2, { 1043, 608 } },
    { 634172, 2, { 812, 781 } },
    { 634200, 2, { 840, 755 } },
    { 634207, 2, { 1849, 343 } },
    { 634212, 2, { 892, 711 } },
    { 634270, 2, { 910, 697 } },
    { 634280, 2, { 808, 785 } },
    { 634296, 2, { 856, 741 } },
    { 634356, 2, { 804, 789 } },
    { 634365, 2, { 999, 635 } },
    { 634368, 2, { 826, 768 } },
    { 634392, 2, { 801, 792 } },
    { 634400, 2, { 800, 793 } },
    { 634440, 2, { 933, 680 } },
    { 634452, 2, { 996, 637 } },
    { 634508, 2, { 868, 731 } },
    { 634524, 2, { 836, 759 } },
    { 634550, 2, { 925, 686 } },
    { 634557, 2, { 861, 737 } },
    { 634600, 2, { 835, 760 } },
    { 634608, 2, { 904, 702 } },
    { 634644, 2, { 867, 732 } },
    { 634692, 2, { 908, 699 } },
    { 634725, 2, { 819, 775 } },
    { 634740, 2, { 852, 745 } },
    { 634764, 2, { 939, 676 } },
    { 634788, 2, { 916, 693 } },
    { 634809, 2, { 817, 777 } },
    { 634816, 2, { 832, 763 } },
    { 634884, 2, { 831, 764 } },
    { 634920, 2, { 814, 780 } },
    { 634933, 2, { 2197, 289 } },
    { 634942, 2, { 931, 682 } },
    { 634959, 2, { 871, 729 } },
    { 634995, 2, { 927, 685 } },
    { 635000, 2, { 1000, 635 } },
    { 635008, 2, { 902, 704 } },
    { 635024, 2, { 923, 688 } },
    { 635040, 2, { 810, 784 } },
    { 635052, 2, { 849, 748 } },
    { 635076, 2, { 828, 767 } },
    { 635088, 2, { 808, 786 } },
    { 635152, 2, { 848, 749 } },
    { 635160, 2, { 804, 790 } },
    { 635268, 2, { 951, 668 } },
    { 635304, 2, { 824, 771 } },
    { 635310, 2, { 905, 702 } },
    { 635376, 2, { 854, 744 } },
    { 635440, 2, { 845, 752 } },
    { 635448, 2, { 913, 696 } },
    { 635481, 2, { 917, 693 } },
    { 635532, 2, { 844, 753 } },
    { 635544, 2, { 819, 776 } },
    { 635580, 2, { 963, 660 } },
    { 635607, 2, { 1121, 567 } },
    { 635625, 2, { 1017, 625 } },
    { 635664, 2, { 816, 779 } },
    { 635680, 2, { 928, 685 } },
    { 635688, 2, { 872, 729 } },
    { 635700, 2, { 815, 780 } },
    { 635712, 2, { 903, 704 } },
    { 635778, 2, { 858, 741 } },
    { 635796, 2, { 812, 783 } },
    { 635805, 2, { 995, 639 } },
    { 635850, 2, { 810, 785 } },
    { 635904, 2, { 828, 768 } },
    { 635916, 2, { 807, 788 } },
    { 635922, 2, { 882, 721 } },
    { 635964, 2, { 804, 791 } },
    { 635970, 2, { 870, 731 } },
    { 635976, 2, { 803, 792 } },
    { 636000, 2, { 800, 795 } },
    { 636030, 2, { 955, 666 } },
    { 636108, 2, { 869, 732 } },
    { 636120, 2, { 837, 760 } },
    { 636160, 2, { 896, 710 } },
    { 636174, 2, { 891, 714 } },
    { 636192, 2, { 846, 752 } },
    { 636195, 2, { 1095, 581 } },
    { 636240, 2, { 880, 723 } },
    { 636270, 2, { 835, 762 } },
    { 636272, 2, { 874, 728 } },
    { 636300, 2, { 900, 707 } },
    { 636345, 2, { 895, 711 } },
    { 636396, 2, { 879, 724 } },
    { 636405, 2, { 957, 665 } },
    { 636444, 2, { 852, 747 } },
    { 636480, 2, { 816, 780 } },
    { 636525, 2, { 943, 675 } },
    { 636528, 2, { 894, 712 } },
    { 636640, 2, { 865, 736 } },
    { 636650, 2, { 850, 749 } },
    { 636696, 2, { 888, 717 } },
    { 636776, 2, { 959, 664 } },
    { 636900, 2, { 825, 772 } },
    { 636916, 2, { 989, 644 } },
    { 636944, 2, { 847, 752 } },
    { 636975, 2, { 855, 745 } },
    { 637000, 2, { 875, 728 } },
    { 637050, 2, { 822, 775 } },
    { 637056, 2, { 896, 711 } },
    { 637065, 2, { 891, 715 } },
    { 637140, 2, { 820, 777 } },
    { 637143, 2, { 961, 663 } },
    { 637146, 2, { 874, 729 } },
    { 637200, 2, { 885, 720 } },
    { 637245, 2, { 833, 765 } },
    { 637260, 2, { 817, 780 } },
    { 637296, 2, { 816, 781 } },
    { 637308, 2, { 843, 756 } },
    { 637320, 2, { 904, 705 } },
    { 637325, 2, { 925, 689 } },
    { 637329, 2, { 979, 651 } },
    { 637332, 2, { 921, 692 } },
    { 637362, 2, { 814, 783 } },
    { 637371, 2, { 1057, 603 } },
    { 637392, 2, { 813, 784 } },
    { 637440, 2, { 830, 768 } },
    { 637450, 2, { 950, 671 } },
    { 637468, 2, { 943, 676 } },
    { 637488, 2, { 912, 699 } },
    { 637512, 2, { 808, 789 } },
    { 637560, 2, { 805, 792 } },
    { 637596, 2, { 801, 796 } },
    { 637602, 2, { 799, 798 } },
    { 637632, 2, { 864, 738 } },
    { 637720, 2, { 856, 745 } },
    { 637776, 2, { 824, 774 } },
    { 637824, 2, { 906, 704 } },
    { 637840, 2, { 938, 680 } },
    { 637872, 2, { 822, 776 } },
    { 637875, 2, { 875, 729 } },
    { 637925, 2, { 1343, 475 } },
    { 637956, 2, { 891, 716 } },
    { 637980, 2, { 868, 735 } },
    { 638000, 2, { 880, 725 } },
    { 638001, 2, { 819, 779 } },
    { 638085, 2, { 885, 721 } },
    { 638112, 2, { 816, 782 } },
    { 638120, 2, { 860, 742 } },
    { 638144, 2, { 832, 767 } },
    { 638145, 2, { 815, 783 } },
    { 638148, 2, { 852, 749 } },
    { 638172, 2, { 933, 684 } },
    { 638176, 2, { 814, 784 } },
    { 638208, 2, { 831, 768 } },
    { 638248, 2, { 884, 722 } },
    { 638250, 2, { 851, 750 } },
    { 638260, 2, { 940, 679 } },
    { 638288, 2, { 973, 656 } },
    { 638319, 2, { 841, 759 } },
    { 638352, 2, { 806, 792 } },
    { 638365, 2, { 805, 793 } },
    { 638370, 2, { 865, 738 } },
    { 638385, 2, { 803, 795 } },
    { 638388, 2, { 828, 771 } },
    { 638400, 2, { 800, 798 } },
    { 638435, 2, { 1015, 629 } },
    { 638448, 2, { 849, 752 } },
    { 638495, 2, { 893, 715 } },
    { 638520, 2, { 939, 680 } },
    { 638544, 2, { 848, 753 } },
    { 638550, 2, { 825, 774 } },
    { 638575, 2, { 1025, 623 } },
    { 638600, 2, { 824, 775 } },
    { 638604, 2, { 876, 729 } },
    { 638631, 2, { 837, 763 } },
    { 638638, 2, { 847, 754 } },
    { 638664, 2, { 897, 712 } },
    { 638715, 2, { 869, 735 } },
    { 638730, 2, { 846, 755 } },
    { 638775, 2, { 835, 765 } },
    { 638790, 2, { 995, 642 } },
    { 638820, 2, { 819, 780 } },
    { 638825, 2, { 1111, 575 } },
    { 638848, 2, { 868, 736 } },
    { 638880, 2, { 880, 726 } },
    { 638894, 2, { 817, 782 } },
    { 638911, 2, { 833, 767 } },
    { 638928, 2, { 816, 783 } },
    { 638960, 2, { 815, 784 } },
    { 639009, 2, { 1029, 621 } },
    { 639030, 2, { 895, 714 } },
    { 639036, 2, { 873, 732 } },
    { 639065, 2, { 961, 665 } },
    { 639072, 2, { 951, 672 } },
    { 639128, 2, { 808, 791 } },
    { 639132, 2, { 884, 723 } },
    { 639144, 2, { 807, 792 } },
    { 639160, 2, { 841, 760 } },
    { 639180, 2, { 804, 795 } },
    { 639200, 2, { 800, 799 } },
    { 639210, 2, { 858, 745 } },
    { 639261, 2, { 973, 657 } },
    { 639276, 2, { 957, 668 } },
    { 639280, 2, { 976, 655 } },
    { 639324, 2, { 826, 774 } },
    { 639331, 2, { 1463, 437 } },
    { 639360, 2, { 864, 740 } },
    { 639400, 2, { 920, 695 } },
    { 639432, 2, { 856, 747 } },
    { 639468, 2, { 837, 764 } },
    { 639540, 2, { 836, 765 } },
    { 639561, 2, { 897, 713 } },
    { 639564, 2, { 892, 717 } },
    { 639584, 2, { 869, 736 } },
    { 639625, 2, { 875, 731 } },
    { 639639, 2, { 819, 781 } },
    { 639711, 2, { 817, 783 } },
    { 639716, 2, { 868, 737 } },
    { 639730, 2, { 910, 703 } },
    { 639840, 2, { 860, 744 } },
    { 639900, 2, { 810, 790 } },
    { 639912, 2, { 879, 728 } },
    { 640080, 2, { 840, 762 } },
    { 640090, 2, { 1058, 605 } },
    { 640134, 2, { 954, 671 } },
    { 640140, 2, { 908, 705 } },
    { 640150, 2, { 826, 775 } },
    { 640185, 2, { 871, 735 } },
    { 640200, 2, { 825, 776 } },
    { 640211, 2, { 1331, 481 } },
    { 640224, 2, { 864, 741 } },
    { 640240, 2, { 848, 755 } },
    { 640248, 2, { 824, 777 } },
    { 640284, 2, { 916, 699 } },
    { 640320, 2, { 870, 736 } },
    { 640332, 2, { 847, 756 } },
    { 640395, 2, { 855, 749 } },
    { 640420, 2, { 820, 781 } },
    { 640458, 2, { 819, 782 } },
    { 640500, 2, { 854, 750 } },
    { 640512, 2, { 834, 768 } },
    { 640528, 2, { 817, 784 } },
    { 640560, 2, { 816, 785 } },
    { 640563, 2, { 987, 649 } },
    { 640575, 2, { 949, 675 } },
    { 640584, 2, { 861, 744 } },
    { 640590, 2, { 815, 786 } },
    { 640596, 2, { 844, 759 } },
    { 640640, 2, { 832, 770 } },
    { 640644, 2, { 813, 788 } },
    { 640668, 2, { 812, 789 } },
    { 640680, 2, { 843, 760 } },
    { 640704, 2, { 852, 752 } },
    { 640710, 2, { 810, 791 } },
    { 640740, 2, { 885, 724 } },
    { 640775, 2, { 1349, 475 } },
    { 640794, 2, { 803, 798 } },
    { 640800, 2, { 801, 800 } },
    { 640871, 2, { 1189, 539 } },
    { 640900, 2, { 850, 754 } },
    { 640920, 2, { 840, 763 } },
    { 641016, 2, { 921, 696 } },
    { 641025, 2, { 825, 777 } },
    { 641056, 2, { 871, 736 } },
    { 641088, 2, { 848, 756 } },
    { 641190, 2, { 870, 737 } },
    { 641212, 2, { 836, 767 } },
    { 641280, 2, { 835, 768 } },
    { 641322, 2, { 869, 738 } },
    { 641376, 2, { 816, 786 } },
    { 641410, 2, { 833, 770 } },
    { 641424, 2, { 966, 664 } },
    { 641459, 2, { 931, 689 } },
    { 641472, 2, { 832, 771 } },
    { 641484, 2, { 927, 692 } },
    { 641520, 2, { 810, 792 } },
    { 641532, 2, { 831, 772 } },
    { 641556, 2, { 852, 753 } },
    { 641568, 2, { 978, 656 } },
    { 641580, 2, { 867, 740 } },
    { 641654, 2, { 851, 754 } },
    { 641690, 2, { 890, 721 } },
    { 641700, 2, { 828, 775 } },
    { 641781, 2, { 1169, 549 } },
    { 641844, 2, { 849, 756 } },
    { 641875, 2, { 1027, 625 } },
    { 641886, 2, { 899, 714 } },
    { 641900, 2, { 917, 700 } },
    { 641904, 2, { 933, 688 } },
    { 641979, 2, { 837, 767 } },
    { 642000, 2, { 856, 750 } },
    { 642005, 2, { 1079, 595 } },
    { 642024, 2, { 888, 723 } },
    { 642048, 2, { 836, 768 } },
    { 642060, 2, { 820, 783 } },
    { 642096, 2, { 819, 784 } },
    { 642135, 2, { 1157, 555 } },
    { 642200, 2, { 845, 760 } },
    { 642208, 2, { 854, 752 } },
    { 642252, 2, { 897, 716 } },
    { 642276, 2, { 939, 684 } },
    { 642330, 2, { 810, 793 } },
    { 642360, 2, { 808, 795 } },
    { 642372, 2, { 807, 796 } },
    { 642390, 2, { 805, 798 } },
    { 642400, 2, { 803, 800 } },
    { 642411, 2, { 891, 721 } },
    { 642420, 2, { 830, 774 } },
    { 642432, 2, { 896, 717 } },
    { 642466, 2, { 1007, 638 } },
    { 642488, 2, { 1043, 616 } },
    { 642555, 2, { 981, 655 } },
    { 642600, 2, { 840, 765 } },
    { 642656, 2, { 1057, 608 } },
    { 642675, 2, { 825, 779 } },
    { 642690, 2, { 965, 666 } },
    { 642744, 2, { 904, 711 } },
    { 642752, 2, { 913, 704 } },
    { 642785, 2, { 899, 715 } },
    { 642798, 2, { 871, 738 } },
    { 642816, 2, { 837, 768 } },
    { 642850, 2, { 989, 650 } },
    { 642876, 2, { 951, 676 } },
    { 642915, 2, { 819, 785 } },
    { 642936, 2, { 903, 712 } },
    { 642940, 2, { 1037, 620 } },
    { 642960, 2, { 846, 760 } },
    { 642978, 2, { 882, 729 } },
    { 643041, 2, { 1211, 531 } },
    { 643080, 2, { 920, 699 } },
    { 643104, 2, { 812, 792 } },
    { 643188, 2, { 806, 798 } },
    { 643195, 2, { 805, 799 } },
    { 643200, 2, { 804, 800 } },
    { 643260, 2, { 852, 755 } },
    { 643284, 2, { 963, 668 } },
    { 643302, 2, { 891, 722 } },
    { 643356, 2, { 828, 777 } },
    { 643365, 2, { 841, 765 } },
    { 643370, 2, { 910, 707 } },
    { 643383, 2, { 1053, 611 } },
    { 643416, 2, { 969, 664 } },
    { 643428, 2, { 879, 732 } },
    { 643455, 2, { 905, 711 } },
    { 643467, 2, { 1023, 629 } },
    { 643500, 2, { 825, 780 } },
    { 643536, 2, { 872, 738 } },
    { 643552, 2, { 884, 728 } },
    { 643560, 2, { 865, 744 } },
    { 643572, 2, { 909, 708 } },
    { 643632, 2, { 848, 759 } },
    { 643665, 2, { 913, 705 } },
    { 643680, 2, { 864, 745 } },
    { 643692, 2, { 948, 679 } },
    { 643720, 2, { 836, 770 } },
    { 643824, 2, { 816, 789 } },
    { 643860, 2, { 876, 735 } },
    { 643890, 2, { 845, 762 } },
    { 643896, 2, { 813, 792 } },
    { 643916, 2, { 812, 793 } },
    { 643950, 2, { 810, 795 } },
    { 643968, 2, { 832, 774 } },
    { 643977, 2, { 1037, 621 } },
    { 643994, 2, { 806, 799 } },
    { 644000, 2, { 805, 800 } },
    { 644004, 2, { 804, 801 } },
    { 644028, 2, { 861, 748 } },
    { 644052, 2, { 843, 764 } },
    { 644096, 2, { 1024, 629 } },
    { 644140, 2, { 860, 749 } },
    { 644160, 2, { 880, 732 } },
    { 644182, 2, { 979, 658 } },
    { 644190, 2, { 985, 654 } },
    { 644215, 2, { 901, 715 } },
    { 644265, 2, { 927, 695 } },
    { 644280, 2, { 826, 780 } },
    { 644322, 2, { 966, 667 } },
    { 644325, 2, { 825, 781 } },
    { 644355, 2, { 999, 645 } },
    { 644400, 2, { 895, 720 } },
    { 644436, 2, { 884, 729 } },
    { 644448, 2, { 822, 784 } },
    { 644490, 2, { 837, 770 } },
    { 644525, 2, { 889, 725 } },
    { 644540, 2, { 871, 740 } },
    { 644556, 2, { 836, 771 } },
    { 644568, 2, { 856, 753 } },
    { 644575, 2, { 1121, 575 } },
    { 644625, 2, { 955, 675 } },
    { 644640, 2, { 816, 790 } },
    { 644670, 2, { 855, 754 } },
    { 644688, 2, { 814, 792 } },
    { 644700, 2, { 921, 700 } },
    { 644725, 2, { 925, 697 } },
    { 644736, 2, { 876, 736 } },
    { 644742, 2, { 833, 774 } },
    { 644784, 2, { 808, 798 } },
    { 644798, 2, { 869, 742 } },
    { 644800, 2, { 806, 800 } },
    { 644805, 2, { 805, 801 } },
    { 644840, 2, { 940, 686 } },
    { 644856, 2, { 831, 776 } },
    { 644875, 2, { 875, 737 } },
    { 644904, 2, { 936, 689 } },
    { 644916, 2, { 892, 723 } },
    { 644960, 2, { 928, 695 } },
    { 645012, 2, { 828, 779 } },
    { 645048, 2, { 867, 744 } },
    { 645050, 2, { 950, 679 } },
    { 645072, 2, { 906, 712 } },
    { 645084, 2, { 891, 724 } },
    { 645106, 2, { 826, 781 } },
    { 645120, 2, { 840, 768 } },
    { 645150, 2, { 825, 782 } },
    { 645165, 2, { 885, 729 } },
    { 645183, 2, { 931, 693 } },
    { 645192, 2, { 824, 783 } },
    { 645216, 2, { 858, 752 } },
    { 645240, 2, { 849, 760 } },
    { 645270, 2, { 822, 785 } },
    { 645300, 2, { 900, 717 } },
    { 645337, 2, { 1309, 493 } },
    { 645344, 2, { 938, 688 } },
    { 645354, 2, { 918, 703 } },
    { 645372, 2, { 819, 788 } },
    { 645381, 2, { 1107, 583 } },
    { 645408, 2, { 864, 747 } },
    { 645456, 2, { 816, 791 } },
    { 645480, 2, { 815, 792 } },
    { 645498, 2, { 846, 763 } },
    { 645502, 2, { 814, 793 } },
    { 645525, 2, { 855, 755 } },
    { 645540, 2, { 812, 795 } },
    { 645568, 2, { 917, 704 } },
    { 645575, 2, { 833, 775 } },
    { 645588, 2, { 908, 711 } },
    { 645600, 2, { 807, 800 } },
    { 645612, 2, { 804, 803 } },
    { 645624, 2, { 854, 756 } },
    { 645636, 2, { 933, 692 } },
    { 645656, 2, { 968, 667 } },
    { 645660, 2, { 844, 765 } },
    { 645696, 2, { 912, 708 } },
    { 645750, 2, { 861, 750 } },
    { 645780, 2, { 916, 705 } },
    { 645795, 2, { 1017, 635 } },
    { 645876, 2, { 924, 699 } },
    { 645888, 2, { 841, 768 } },
    { 645909, 2, { 851, 759 } },
    { 645975, 2, { 825, 783 } },
    { 646020, 2, { 873, 740 } },
    { 646032, 2, { 939, 688 } },
    { 646072, 2, { 973, 664 } },
    { 646152, 2, { 872, 741 } },
    { 646155, 2, { 865, 747 } },
    { 646164, 2, { 837, 772 } },
    { 646170, 2, { 905, 714 } },
    { 646176, 2, { 848, 762 } },
    { 646204, 2, { 884, 731 } },
    { 646250, 2, { 1034, 625 } },
    { 646280, 2, { 856, 755 } },
    { 646282, 2, { 871, 742 } },
    { 646290, 2, { 835, 774 } },
    { 646323, 2, { 969, 667 } },
    { 646350, 2, { 834, 775 } },
    { 646360, 2, { 904, 715 } },
    { 646380, 2, { 810, 798 } },
    { 646404, 2, { 913, 708 } },
    { 646408, 2, { 833, 776 } },
    { 646415, 2, { 805, 803 } },
    { 646425, 2, { 845, 765 } },
    { 646464, 2, { 832, 777 } },
    { 646485, 2, { 917, 705 } },
    { 646536, 2, { 869, 744 } },
    { 646548, 2, { 903, 716 } },
    { 646640, 2, { 944, 685 } },
    { 646646, 2, { 1001, 646 } },
    { 646668, 2, { 828, 781 } },
    { 646680, 2, { 951, 680 } },
    { 646758, 2, { 826, 783 } },
    { 646760, 2, { 851, 760 } },
    { 646800, 2, { 825, 784 } },
    { 646816, 2, { 928, 697 } },
    { 646840, 2, { 824, 785 } },
    { 646875, 2, { 1035, 625 } },
    { 646898, 2, { 943, 686 } },
    { 646905, 2, { 915, 707 } },
    { 646912, 2, { 896, 722 } },
    { 646932, 2, { 858, 754 } },
    { 646944, 2, { 879, 736 } },
    { 646947, 2, { 1141, 567 } },
    { 646980, 2, { 820, 789 } },
    { 647024, 2, { 848, 763 } },
    { 647064, 2, { 817, 792 } },
    { 647088, 2, { 816, 793 } },
    { 647145, 2, { 985, 657 } },
    { 647148, 2, { 813, 796 } },
    { 647184, 2, { 834, 776 } },
    { 647190, 2, { 810, 799 } },
    { 647192, 2, { 889, 728 } },
    { 647208, 2, { 808, 801 } },
    { 647220, 2, { 805, 804 } },
    { 647280, 2, { 870, 744 } },
    { 647292, 2, { 969, 668 } },
    { 647325, 2, { 945, 685 } },
    { 647352, 2, { 888, 729 } },
    { 647400, 2, { 830, 780 } },
    { 647424, 2, { 843, 768 } },
    { 647425, 2, { 893, 725 } },
    { 647460, 2, { 981, 660 } },
    { 647472, 2, { 861, 752 } },
    { 647490, 2, { 955, 678 } },
    { 647570, 2, { 841, 770 } },
    { 647580, 2, { 860, 753 } },
    { 647584, 2, { 826, 784 } },
    { 647595, 2, { 1053, 615 } },
    { 647634, 2, { 874, 741 } },
    { 647640, 2, { 840, 771 } },
    { 647660, 2, { 940, 689 } },
    { 647664, 2, { 824, 786 } },
    { 647703, 2, { 1043, 621 } },
    { 647790, 2, { 858, 755 } },
    { 647808, 2, { 896, 723 } },
    { 647820, 2, { 885, 732 } },
    { 647829, 2, { 819, 791 } },
    { 647946, 2, { 923, 702 } },
    { 647955, 2, { 847, 765 } },
    { 647960, 2, { 835, 776 } },
    { 648000, 2, { 810, 800 } },
    { 648081, 2, { 889, 729 } },
    { 648096, 2, { 942, 688 } },
    { 648125, 2, { 1037, 625 } },
    { 648128, 2, { 832, 779 } },
    { 648150, 2, { 870, 745 } },
    { 648168, 2, { 904, 717 } },
    { 648180, 2, { 831, 780 } },
    { 648210, 2, { 930, 697 } },
    { 648318, 2, { 893, 726 } },
    { 648324, 2, { 828, 783 } },
    { 648351, 2, { 999, 649 } },
    { 648375, 2, { 875, 741 } },
    { 648384, 2, { 921, 704 } },
    { 648396, 2, { 868, 747 } },
    { 648432, 2, { 912, 711 } },
    { 648516, 2, { 867, 748 } },
    { 648550, 2, { 850, 763 } },
    { 648560, 2, { 880, 737 } },
    { 648585, 2, { 1015, 639 } },
    { 648600, 2, { 920, 705 } },
    { 648620, 2, { 820, 791 } },
    { 648636, 2, { 849, 764 } },
    { 648648, 2, { 819, 792 } },
    { 648672, 2, { 928, 699 } },
    { 648675, 2, { 837, 775 } },
    { 648720, 2, { 816, 795 } },
    { 648750, 2, { 865, 750 } },
    { 648788, 2, { 812, 799 } },
    { 648828, 2, { 807, 804 } },
    { 648830, 2, { 806, 805 } },
    { 648882, 2, { 846, 767 } },
    { 648900, 2, { 900, 721 } },
    { 648907, 2, { 833, 779 } },
    { 648945, 2, { 855, 759 } },
    { 648956, 2, { 946, 686 } },
    { 648960, 2, { 832, 780 } },
    { 648970, 2, { 889, 730 } },
    { 649000, 2, { 1000, 649 } },
    { 649040, 2, { 854, 760 } },
    { 649078, 2, { 899, 722 } },
    { 649116, 2, { 876, 741 } },
    { 649128, 2, { 888, 731 } },
    { 649152, 2, { 828, 784 } },
    { 649165, 2, { 1073, 605 } },
    { 649250, 2, { 875, 742 } },
    { 649350, 2, { 925, 702 } },
    { 649368, 2, { 933, 696 } },
    { 649392, 2, { 978, 664 } },
    { 649428, 2, { 897, 724 } },
    { 649440, 2, { 820, 792 } },
    { 649467, 2, { 819, 793 } },
    { 649512, 2, { 837, 776 } },
    { 649558, 2, { 1079, 602 } },
    { 649572, 2, { 814, 798 } },
    { 649600, 2, { 812, 800 } },
    { 649640, 2, { 872, 745 } },
    { 649649, 2, { 847, 767 } },
    { 649704, 2, { 856, 759 } },
    { 649728, 2, { 846, 768 } },
    { 649740, 2, { 833, 780 } },
    { 649760, 2, { 992, 655 } },
    { 649770, 2, { 895, 726 } },
    { 649775, 2, { 1175, 553 } },
    { 649788, 2, { 939, 692 } },
    { 649792, 2, { 832, 781 } },
    { 649800, 2, { 855, 760 } },
    { 649890, 2, { 830, 783 } },
    { 649935, 2, { 909, 715 } },
    { 649980, 2, { 828, 785 } },
    { 650034, 2, { 882, 737 } },
    { 650076, 2, { 852, 763 } },
    { 650100, 2, { 825, 788 } },
    { 650104, 2, { 893, 728 } },
    { 650136, 2, { 824, 789 } },
    { 650160, 2, { 840, 774 } },
    { 650260, 2, { 820, 793 } },
    { 650268, 2, { 892, 729 } },
    { 650349, 2, { 837, 777 } },
    { 650370, 2, { 815, 798 } },
    { 650385, 2, { 873, 745 } },
    { 650386, 2, { 814, 799 } },
    { 650400, 2, { 813, 800 } },
    { 650412, 2, { 812, 801 } },
    { 650416, 2, { 848, 767 } },
    { 650430, 2, { 810, 803 } },
    { 650440, 2, { 808, 805 } },
    { 650460, 2, { 879, 740 } },
    { 650480, 2, { 865, 752 } },
    { 650484, 2, { 951, 684 } },
    { 650496, 2, { 847, 768 } },
    { 650573, 2, { 833, 781 } },
    { 650592, 2, { 864, 753 } },
    { 650624, 2, { 832, 782 } },
    { 650650, 2, { 845, 770 } },
    { 650670, 2, { 943, 690 } },
    { 650700, 2, { 900, 723 } },
    { 650715, 2, { 923, 705 } },
    { 650720, 2, { 830, 784 } },
    { 650724, 2, { 844, 771 } },
    { 650730, 2, { 995, 654 } },
    { 650793, 2, { 1221, 533 } },
    { 650796, 2, { 843, 772 } },
    { 650832, 2, { 894, 728 } },
    { 650844, 2, { 909, 716 } },
    { 650845, 2, { 1105, 589 } },
    { 650916, 2, { 861, 756 } },
    { 650988, 2, { 963, 676 } },
    { 650997, 2, { 893, 729 } },
    { 651000, 2, { 840, 775 } },
    { 651014, 2, { 949, 686 } },
    { 651015, 2, { 851, 765 } },
    { 651024, 2, { 822, 792 } },
    { 651035, 2, { 979, 665 } },
    { 651036, 2, { 908, 717 } },
    { 651070, 2, { 917, 710 } },
    { 651112, 2, { 1057, 616 } },
    { 651168, 2, { 816, 798 } },
    { 651200, 2, { 814, 800 } },
    { 651244, 2, { 836, 779 } },
    { 651276, 2, { 916, 711 } },
    { 651300, 2, { 835, 780 } },
    { 651321, 2, { 891, 731 } },
    { 651360, 2, { 885, 736 } },
    { 651375, 2, { 965, 675 } },
    { 651384, 2, { 872, 747 } },
    { 651406, 2, { 833, 782 } },
    { 651420, 2, { 846, 770 } },
    { 651456, 2, { 832, 783 } },
    { 651475, 2, { 1133, 575 } },
    { 651480, 2, { 890, 732 } },
    { 651504, 2, { 831, 784 } },
    { 651508, 2, { 871, 748 } },
    { 651560, 2, { 895, 728 } },
    { 651630, 2, { 870, 749 } },
    { 651695, 2, { 935, 697 } },
    { 651700, 2, { 931, 700 } },
    { 651780, 2, { 852, 765 } },
    { 651784, 2, { 824, 791 } },
    { 651794, 2, { 946, 689 } },
    { 651833, 2, { 1183, 551 } },
    { 651882, 2, { 913, 714 } },
    { 651900, 2, { 820, 795 } },
    { 651924, 2, { 819, 796 } },
    { 651950, 2, { 850, 767 } },
    { 651966, 2, { 817, 798 } },
    { 651984, 2, { 816, 799 } },
    { 651987, 2, { 917, 711 } },
    { 652000, 2, { 815, 800 } },
    { 652023, 2, { 837, 779 } },
    { 652032, 2, { 849, 768 } },
    { 652036, 2, { 812, 803 } },
    { 652050, 2, { 810, 805 } },
    { 652056, 2, { 808, 807 } },
    { 652064, 2, { 994, 656 } },
    { 652068, 2, { 921, 708 } },
    { 652080, 2, { 836, 780 } },
    { 652120, 2, { 952, 685 } },
    { 652190, 2, { 847, 770 } },
    { 652212, 2, { 891, 732 } },
    { 652224, 2, { 948, 688 } },
    { 652239, 2, { 833, 783 } },
    { 652245, 2, { 885, 737 } },
    { 652272, 2, { 856, 762 } },
    { 652320, 2, { 864, 755 } },
    { 652365, 2, { 855, 763 } },
    { 652384, 2, { 928, 703 } },
    { 652455, 2, { 895, 729 } },
    { 652575, 2, { 825, 791 } },
    { 652620, 2, { 876, 745 } },
    { 652674, 2, { 899, 726 } },
    { 652680, 2, { 840, 777 } },
    { 652740, 2, { 860, 759 } },
    { 652815, 2, { 815, 801 } },
    { 652860, 2, { 810, 806 } },
    { 652904, 2, { 917, 712 } },
    { 652912, 2, { 949, 688 } },
    { 652925, 2, { 1025, 637 } },
    { 652953, 2, { 1003, 651 } },
    { 652960, 2, { 848, 770 } },
    { 653004, 2, { 873, 748 } },
    { 653016, 2, { 897, 728 } },
    { 653072, 2, { 833, 784 } },
    { 653100, 2, { 933, 700 } },
    { 653120, 2, { 832, 785 } },
    { 653125, 2, { 1045, 625 } },
    { 653128, 2, { 856, 763 } },
    { 653130, 2, { 885, 738 } },
    { 653184, 2, { 864, 756 } },
    { 653220, 2, { 855, 764 } },
    { 653225, 2, { 901, 725 } },
    { 653235, 2, { 1177, 555 } },
    { 653250, 2, { 871, 750 } },
    { 653268, 2, { 924, 707 } },
    { 653292, 2, { 828, 789 } },
    { 653310, 2, { 854, 765 } },
    { 653315, 2, { 1235, 529 } },
    { 653400, 2, { 825, 792 } },
    { 653415, 2, { 889, 735 } },
    { 653480, 2, { 961, 680 } },
    { 653488, 2, { 869, 752 } },
    { 653544, 2, { 939, 696 } },
    { 653568, 2, { 851, 768 } },
    { 653592, 2, { 904, 723 } },
    { 653600, 2, { 817, 800 } },
    { 653604, 2, { 868, 753 } },
    { 653616, 2, { 816, 801 } },
    { 653625, 2, { 875, 747 } },
    { 653652, 2, { 813, 804 } },
    { 653697, 2, { 837, 781 } },
    { 653715, 2, { 995, 657 } },
    { 653752, 2, { 836, 782 } },
    { 653772, 2, { 903, 724 } },
    { 653790, 2, { 930, 703 } },
    { 653805, 2, { 835, 783 } },
    { 653808, 2, { 848, 771 } },
    { 653856, 2, { 834, 784 } },
    { 653877, 2, { 873, 749 } },
    { 653904, 2, { 912, 717 } },
    { 653913, 2, { 897, 729 } },
    { 653920, 2, { 976, 670 } },
    { 653940, 2, { 865, 756 } },
    { 653950, 2, { 902, 725 } },
    { 653952, 2, { 832, 786 } },
    { 653975, 2, { 925, 707 } },
    { 653976, 2, { 879, 744 } },
    { 654000, 2, { 872, 750 } },
    { 654005, 2, { 1081, 605 } },
    { 654030, 2, { 845, 774 } },
    { 654080, 2, { 896, 730 } },
    { 654120, 2, { 828, 790 } },
    { 654126, 2, { 901, 726 } },
    { 654168, 2, { 843, 776 } },
    { 654192, 2, { 826, 792 } },
    { 654199, 2, { 1027, 637 } },
    { 654225, 2, { 825, 793 } },
    { 654240, 2, { 870, 752 } },
    { 654270, 2, { 965, 678 } },
    { 654288, 2, { 951, 688 } },
    { 654304, 2, { 889, 736 } },
    { 654336, 2, { 852, 768 } },
    { 654345, 2, { 999, 655 } },
    { 654368, 2, { 968, 676 } },
    { 654372, 2, { 876, 747 } },
    { 654381, 2, { 819, 799 } },
    { 654444, 2, { 882, 742 } },
    { 654472, 2, { 812, 806 } },
    { 654480, 2, { 810, 808 } },
    { 654493, 2, { 931, 703 } },
    { 654550, 2, { 950, 689 } },
    { 654588, 2, { 836, 783 } },
    { 654640, 2, { 835, 784 } },
    { 654675, 2, { 903, 725 } },
    { 654690, 2, { 834, 785 } },
    { 654828, 2, { 831, 788 } },
    { 654840, 2, { 856, 765 } },
    { 654885, 2, { 891, 735 } },
    { 654900, 2, { 885, 740 } },
    { 654925, 2, { 1139, 575 } },
    { 654948, 2, { 828, 791 } },
    { 654975, 2, { 1025, 639 } },
    { 654976, 2, { 896, 731 } },
    { 654992, 2, { 871, 752 } },
    { 655000, 2, { 1000, 655 } },
    { 655018, 2, { 826, 793 } },
    { 655040, 2, { 890, 736 } },
    { 655044, 2, { 884, 741 } },
    { 655080, 2, { 824, 795 } },
    { 655140, 2, { 895, 732 } },
    { 655180, 2, { 820, 799 } },
    { 655200, 2, { 819, 800 } },
    { 655248, 2, { 816, 803 } },
    { 655260, 2, { 815, 804 } },
    { 655270, 2, { 814, 805 } },
    { 655284, 2, { 812, 807 } },
    { 655308, 2, { 981, 668 } },
    { 655344, 2, { 888, 738 } },
    { 655368, 2, { 987, 664 } },
    { 655375, 2, { 875, 749 } },
    { 655389, 2, { 909, 721 } },
    { 655400, 2, { 904, 725 } },
    { 655424, 2, { 836, 784 } },
    { 655428, 2, { 849, 772 } },
    { 655452, 2, { 867, 756 } },
    { 655500, 2, { 874, 750 } },
    { 655557, 2, { 1007, 651 } },
    { 655578, 2, { 847, 774 } },
    { 655600, 2, { 880, 745 } },
    { 655620, 2, { 892, 735 } },
    { 655632, 2, { 942, 696 } },
    { 655650, 2, { 846, 775 } },
    { 655690, 2, { 986, 665 } },
    { 655707, 2, { 897, 731 } },
    { 655720, 2, { 845, 776 } },
    { 655752, 2, { 921, 712 } },
    { 655785, 2, { 855, 767 } },
    { 655788, 2, { 844, 777 } },
    { 655872, 2, { 854, 768 } },
    { 655960, 2, { 920, 713 } },
    { 655980, 2, { 841, 780 } },
    { 656000, 2, { 820, 800 } },
    { 656010, 2, { 985, 666 } },
    { 656040, 2, { 840, 781 } },
    { 656064, 2, { 816, 804 } },
    { 656080, 2, { 944, 695 } },
    { 656110, 2, { 910, 721 } },
    { 656124, 2, { 876, 749 } },
    { 656180, 2, { 860, 763 } },
    { 656183, 2, { 1331, 493 } },
    { 656205, 2, { 1067, 615 } },
    { 656208, 2, { 837, 784 } },
    { 656250, 2, { 875, 750 } },
    { 656304, 2, { 904, 726 } },
    { 656310, 2, { 835, 786 } },
    { 656316, 2, { 927, 708 } },
    { 656328, 2, { 943, 696 } },
    { 656352, 2, { 848, 774 } },
    { 656355, 2, { 893, 735 } },
    { 656397, 2, { 1057, 621 } },
    { 656425, 2, { 847, 775 } },
    { 656448, 2, { 832, 789 } },
    { 656484, 2, { 908, 723 } },
    { 656496, 2, { 846, 776 } },
    { 656502, 2, { 957, 686 } },
    { 656530, 2, { 830, 791 } },
    { 656600, 2, { 938, 700 } },
    { 656604, 2, { 828, 793 } },
    { 656616, 2, { 872, 753 } },
    { 656640, 2, { 855, 768 } },
    { 656656, 2, { 902, 728 } },
    { 656667, 2, { 891, 737 } },
    { 656670, 2, { 826, 795 } },
    { 656700, 2, { 825, 796 } },
    { 656772, 2, { 916, 717 } },
    { 656775, 2, { 945, 695 } },
    { 656820, 2, { 820, 801 } },
    { 656825, 2, { 1075, 611 } },
    { 656829, 2, { 901, 729 } },
    { 656832, 2, { 933, 704 } },
    { 656850, 2, { 870, 755 } },
    { 656880, 2, { 816, 805 } },
    { 656892, 2, { 852, 771 } },
    { 656904, 2, { 813, 808 } },
    { 656964, 2, { 869, 756 } },
    { 657020, 2, { 910, 722 } },
    { 657024, 2, { 928, 708 } },
    { 657030, 2, { 905, 726 } },
    { 657041, 2, { 1127, 583 } },
    { 657045, 2, { 837, 785 } },
    { 657060, 2, { 932, 705 } },
    { 657090, 2, { 882, 745 } },
    { 657111, 2, { 1079, 609 } },
    { 657153, 2, { 1159, 567 } },
    { 657200, 2, { 848, 775 } },
    { 657216, 2, { 978, 672 } },
    { 657225, 2, { 1035, 635 } },
    { 657272, 2, { 847, 776 } },
    { 657280, 2, { 832, 790 } },
    { 657300, 2, { 939, 700 } },
    { 657305, 2, { 935, 703 } },
    { 657324, 2, { 961, 684 } },
    { 657360, 2, { 830, 792 } },
    { 657384, 2, { 903, 728 } },
    { 657400, 2, { 865, 760 } },
    { 657492, 2, { 879, 748 } },
    { 657510, 2, { 930, 707 } },
    { 657514, 2, { 1331, 494 } },
    { 657540, 2, { 843, 780 } },
    { 657552, 2, { 824, 798 } },
    { 657600, 2, { 822, 800 } },
    { 657657, 2, { 819, 803 } },
    { 657662, 2, { 841, 782 } },
    { 657675, 2, { 925, 711 } },
    { 657685, 2, { 817, 805 } },
    { 657696, 2, { 816, 806 } },
    { 657720, 2, { 812, 810 } },
    { 657800, 2, { 920, 715 } },
    { 657804, 2, { 861, 764 } },
    { 657860, 2, { 889, 740 } },
    { 657900, 2, { 850, 774 } },
    { 657984, 2, { 894, 736 } },
    { 658000, 2, { 875, 752 } },
    { 658008, 2, { 888, 741 } },
    { 658050, 2, { 1025, 642 } },
    { 658070, 2, { 833, 790 } },
    { 658086, 2, { 858, 767 } },
    { 658092, 2, { 951, 692 } },
    { 658112, 2, { 832, 791 } },
    { 658116, 2, { 909, 724 } },
    { 658125, 2, { 975, 675 } },
    { 658152, 2, { 831, 792 } },
    { 658240, 2, { 880, 748 } },
    { 658255, 2, { 845, 779 } },
    { 658260, 2, { 828, 795 } },
    { 658287, 2, { 903, 729 } },
    { 658350, 2, { 825, 798 } },
    { 658360, 2, { 872, 755 } },
    { 658368, 2, { 864, 762 } },
    { 658416, 2, { 946, 696 } },
    { 658440, 2, { 885, 744 } },
    { 658460, 2, { 820, 803 } },
    { 658476, 2, { 819, 804 } },
    { 658502, 2, { 817, 806 } },
    { 658512, 2, { 816, 807 } },
    { 658520, 2, { 815, 808 } },
    { 658525, 2, { 1325, 497 } },
    { 658665, 2, { 861, 765 } },
    { 658692, 2, { 963, 684 } },
    { 658720, 2, { 895, 736 } },
    { 658735, 2, { 1015, 649 } },
    { 658752, 2, { 876, 752 } },
    { 658812, 2, { 868, 759 } },
    { 658824, 2, { 849, 776 } },
    { 658825, 2, { 1387, 475 } },
    { 658840, 2, { 905, 728 } },
    { 658880, 2, { 928, 710 } },
    { 658896, 2, { 848, 777 } },
    { 658920, 2, { 867, 760 } },
    { 658944, 2, { 832, 792 } },
    { 658950, 2, { 955, 690 } },
    { 659016, 2, { 904, 729 } },
    { 659022, 2, { 923, 714 } },
    { 659025, 2, { 909, 725 } },
    { 659100, 2, { 845, 780 } },
    { 659115, 2, { 873, 755 } },
    { 659130, 2, { 865, 762 } },
    { 659175, 2, { 825, 799 } },
    { 659176, 2, { 1043, 632 } },
    { 659232, 2, { 864, 763 } },
    { 659246, 2, { 961, 686 } },
    { 659295, 2, { 819, 805 } },
    { 659316, 2, { 987, 668 } },
    { 659340, 2, { 814, 810 } },
    { 659352, 2, { 993, 664 } },
    { 659362, 2, { 902, 731 } },
    { 659373, 2, { 957, 689 } },
    { 659376, 2, { 912, 723 } },
    { 659400, 2, { 840, 785 } },
    { 659436, 2, { 921, 716 } },
    { 659525, 2, { 851, 775 } },
    { 659556, 2, { 837, 788 } },
    { 659568, 2, { 906, 728 } },
    { 659604, 2, { 836, 789 } },
    { 659620, 2, { 860, 767 } },
    { 659628, 2, { 876, 753 } },
    { 659640, 2, { 920, 717 } },
    { 659655, 2, { 963, 685 } },
    { 659680, 2, { 868, 760 } },
    { 659715, 2, { 915, 721 } },
    { 659736, 2, { 833, 792 } },
    { 659745, 2, { 905, 729 } },
    { 659750, 2, { 875, 754 } },
    { 659776, 2, { 832, 793 } },
    { 659792, 2, { 959, 688 } },
    { 659808, 2, { 928, 711 } },
    { 659813, 2, { 847, 779 } },
    { 659932, 2, { 962, 686 } },
    { 659976, 2, { 856, 771 } },
    { 659988, 2, { 873, 756 } },
    { 660000, 2, { 825, 800 } },
    { 660024, 2, { 824, 801 } },
    { 660060, 2, { 855, 772 } },
    { 660114, 2, { 819, 806 } },
    { 660150, 2, { 815, 810 } },
    { 660156, 2, { 813, 812 } },
    { 660192, 2, { 897, 736 } },
    { 660231, 2, { 891, 741 } },
    { 660240, 2, { 840, 786 } },
    { 660275, 2, { 1225, 539 } },
    { 660300, 2, { 852, 775 } },
    { 660348, 2, { 884, 747 } },
    { 660352, 2, { 896, 737 } },
    { 660387, 2, { 861, 767 } },
    { 660450, 2, { 850, 777 } },
    { 660480, 2, { 860, 768 } },
    { 660510, 2, { 895, 738 } },
    { 660528, 2, { 834, 792 } },
    { 660564, 2, { 933, 708 } },
    { 660569, 2, { 833, 793 } },
    { 660618, 2, { 882, 749 } },
    { 660660, 2, { 847, 780 } },
    { 660726, 2, { 846, 781 } },
    { 660765, 2, { 899, 735 } },
    { 660790, 2, { 845, 782 } },
    { 660800, 2, { 826, 800 } },
    { 660820, 2, { 893, 740 } },
    { 660852, 2, { 844, 783 } },
    { 660912, 2, { 843, 784 } },
    { 660960, 2, { 816, 810 } },
    { 660961, 2, { 1927, 343 } },
    { 660968, 2, { 814, 812 } },
    { 660972, 2, { 892, 741 } },
    { 660996, 2, { 854, 774 } },
    { 661008, 2, { 879, 752 } },
    { 661010, 2, { 931, 710 } },
    { 661056, 2, { 939, 704 } },
    { 661089, 2, { 871, 759 } },
    { 661122, 2, { 891, 742 } },
    { 661200, 2, { 870, 760 } },
    { 661230, 2, { 837, 790 } },
    { 661248, 2, { 861, 768 } },
    { 661250, 2, { 1058, 625 } },
    { 661290, 2, { 938, 705 } },
    { 661320, 2, { 835, 792 } },
    { 661380, 2, { 876, 755 } },
    { 661388, 2, { 1027, 644 } },
    { 661440, 2, { 832, 795 } },
    { 661476, 2, { 831, 796 } },
    { 661500, 2, { 875, 756 } },
    { 661504, 2, { 1024, 646 } },
    { 661560, 2, { 888, 745 } },
    { 661572, 2, { 828, 799 } },
    { 661635, 2, { 845, 783 } },
    { 661640, 2, { 952, 695 } },
    { 661664, 2, { 899, 736 } },
    { 661710, 2, { 822, 805 } },
    { 661713, 2, { 893, 741 } },
    { 661725, 2, { 865, 765 } },
    { 661740, 2, { 820, 807 } },
    { 661752, 2, { 819, 808 } },
    { 661770, 2, { 817, 810 } },
    { 661815, 2, { 955, 693 } },
    { 661848, 2, { 872, 759 } },
    { 661850, 2, { 854, 775 } },
    { 661878, 2, { 918, 721 } },
    { 661896, 2, { 951, 696 } },
    { 661925, 2, { 913, 725 } },
    { 661932, 2, { 908, 729 } },
    { 661941, 2, { 931, 711 } },
    { 661960, 2, { 871, 760 } },
    { 661980, 2, { 885, 748 } },
    { 662004, 2, { 852, 777 } },
    { 662025, 2, { 975, 679 } },
    { 662067, 2, { 837, 791 } },
    { 662112, 2, { 836, 792 } },
    { 662150, 2, { 850, 779 } },
    { 662160, 2, { 890, 744 } },
    { 662220, 2, { 849, 780 } },
    { 662235, 2, { 833, 795 } },
    { 662244, 2, { 957, 692 } },
    { 662268, 2, { 916, 723 } },
    { 662277, 2, { 987, 671 } },
    { 662288, 2, { 848, 781 } },
    { 662354, 2, { 847, 782 } },
    { 662388, 2, { 867, 764 } },
    { 662400, 2, { 828, 800 } },
    { 662415, 2, { 1027, 645 } },
    { 662460, 2, { 905, 732 } },
    { 662475, 2, { 825, 803 } },
    { 662480, 2, { 845, 784 } },
    { 662508, 2, { 924, 717 } },
    { 662544, 2, { 856, 774 } },
    { 662592, 2, { 816, 812 } },
    { 662625, 2, { 855, 775 } },
    { 662640, 2, { 880, 753 } },
    { 662652, 2, { 932, 711 } },
    { 662670, 2, { 995, 666 } },
    { 662688, 2, { 864, 767 } },
    { 662697, 2, { 1099, 603 } },
    { 662760, 2, { 840, 789 } },
    { 662796, 2, { 918, 722 } },
    { 662805, 2, { 927, 715 } },
    { 662823, 2, { 1169, 567 } },
    { 662865, 2, { 885, 749 } },
    { 662872, 2, { 931, 712 } },
    { 662904, 2, { 837, 792 } },
    { 662935, 2, { 1085, 611 } },
    { 662948, 2, { 836, 793 } },
    { 663000, 2, { 850, 780 } },
    { 663040, 2, { 896, 740 } },
    { 663060, 2, { 860, 771 } },
    { 663080, 2, { 968, 685 } },
    { 663120, 2, { 921, 720 } },
    { 663156, 2, { 981, 676 } },
    { 663168, 2, { 942, 704 } },
    { 663201, 2, { 847, 783 } },
    { 663228, 2, { 828, 801 } },
    { 663264, 2, { 846, 784 } },
    { 663278, 2, { 826, 803 } },
    { 663300, 2, { 825, 804 } },
    { 663320, 2, { 824, 805 } },
    { 663324, 2, { 993, 668 } },
    { 663336, 2, { 888, 747 } },
    { 663390, 2, { 819, 810 } },
    { 663400, 2, { 856, 775 } },
    { 663404, 2, { 817, 812 } },
    { 663408, 2, { 816, 813 } },
    { 663480, 2, { 855, 776 } },
    { 663495, 2, { 1065, 623 } },
    { 663520, 2, { 880, 754 } },
    { 663544, 2, { 952, 697 } },
    { 663552, 2, { 864, 768 } },
    { 663585, 2, { 1079, 615 } },
    { 663600, 2, { 840, 790 } },
    { 663663, 2, { 1001, 663 } },
    { 663732, 2, { 927, 716 } },
    { 663741, 2, { 837, 793 } },
    { 663780, 2, { 851, 780 } },
    { 663795, 2, { 891, 745 } },
    { 663803, 2, { 931, 713 } },
    { 663810, 2, { 870, 763 } },
    { 663850, 2, { 850, 781 } },
    { 663872, 2, { 902, 736 } },
    { 663936, 2, { 832, 798 } },
    { 663984, 2, { 848, 783 } },
    { 664000, 2, { 830, 800 } },
    { 664020, 2, { 868, 765 } },
    { 664048, 2, { 847, 784 } },
    { 664083, 2, { 889, 747 } },
    { 664110, 2, { 846, 785 } },
    { 664125, 2, { 825, 805 } },
    { 664170, 2, { 845, 786 } },
    { 664176, 2, { 822, 808 } },
    { 664200, 2, { 820, 810 } },
    { 664224, 2, { 816, 814 } },
    { 664240, 2, { 874, 760 } },
    { 664284, 2, { 843, 788 } },
    { 664296, 2, { 933, 712 } },
    { 664320, 2, { 865, 768 } },
    { 664335, 2, { 855, 777 } },
    { 664392, 2, { 893, 744 } },
    { 664400, 2, { 880, 755 } },
    { 664411, 2, { 2057, 323 } },
    { 664440, 2, { 840, 791 } },
    { 664464, 2, { 872, 762 } },
    { 664524, 2, { 879, 756 } },
    { 664580, 2, { 940, 707 } },
    { 664587, 2, { 959, 693 } },
    { 664608, 2, { 903, 736 } },
    { 664620, 2, { 836, 795 } },
    { 664640, 2, { 992, 670 } },
    { 664664, 2, { 913, 728 } },
    { 664692, 2, { 861, 772 } },
    { 664700, 2, { 850, 782 } },
    { 664768, 2, { 832, 799 } },
    { 664785, 2, { 869, 765 } },
    { 664800, 2, { 831, 800 } },
    { 664812, 2, { 939, 708 } },
    { 664825, 2, { 917, 725 } },
    { 664839, 2, { 1211, 549 } },
    { 664848, 2, { 912, 729 } },
    { 664875, 2, { 985, 675 } },
    { 664884, 2, { 828, 803 } },
    { 664938, 2, { 901, 738 } },
    { 664950, 2, { 825, 806 } },
    { 664968, 2, { 824, 807 } },
    { 665000, 2, { 875, 760 } },
    { 665028, 2, { 819, 812 } },
    { 665038, 2, { 817, 814 } },
    { 665040, 2, { 816, 815 } },
    { 665112, 2, { 856, 777 } },
    { 665136, 2, { 894, 744 } },
    { 665160, 2, { 920, 723 } },
    { 665210, 2, { 910, 731 } },
    { 665225, 2, { 1025, 649 } },
    { 665275, 2, { 1157, 575 } },
    { 665376, 2, { 928, 717 } },
    { 665379, 2, { 1089, 611 } },
    { 665388, 2, { 909, 732 } },
    { 665415, 2, { 837, 795 } },
    { 665445, 2, { 1199, 555 } },
    { 665480, 2, { 1016, 655 } },
    { 665482, 2, { 851, 782 } },
    { 665496, 2, { 936, 711 } },
    { 665511, 2, { 903, 737 } },
    { 665520, 2, { 885, 752 } },
    { 665550, 2, { 850, 783 } },
    { 665567, 2, { 833, 799 } },
    { 665616, 2, { 849, 784 } },
    { 665652, 2, { 884, 753 } },
    { 665680, 2, { 848, 785 } },
    { 665700, 2, { 951, 700 } },
    { 665808, 2, { 858, 776 } },
    { 665850, 2, { 965, 690 } },
    { 665874, 2, { 1026, 649 } },
    { 665880, 2, { 895, 744 } },
    { 665910, 2, { 882, 755 } },
    { 665916, 2, { 844, 789 } },
    { 665973, 2, { 961, 693 } },
    { 665984, 2, { 946, 704 } },
    { 666000, 2, { 888, 750 } },
    { 666045, 2, { 855, 779 } },
    { 666072, 2, { 841, 792 } },
    { 666080, 2, { 905, 736 } },
    { 666099, 2, { 873, 763 } },
    { 666120, 2, { 840, 793 } },
    { 666135, 2, { 1017, 655 } },
    { 666144, 2, { 864, 771 } },
    { 666159, 2, { 899, 741 } },
    { 666198, 2, { 949, 702 } },
    { 666204, 2, { 924, 721 } },
    { 666225, 2, { 945, 705 } },
    { 666252, 2, { 837, 796 } },
    { 666315, 2, { 871, 765 } },
    { 666324, 2, { 892, 747 } },
    { 666330, 2, { 835, 798 } },
    { 666333, 2, { 851, 783 } },
    { 666396, 2, { 963, 692 } },
    { 666400, 2, { 833, 800 } },
    { 666425, 2, { 1159, 575 } },
    { 666432, 2, { 832, 801 } },
    { 666468, 2, { 891, 748 } },
    { 666477, 2, { 1043, 639 } },
    { 666528, 2, { 848, 786 } },
    { 666540, 2, { 828, 805 } },
    { 666600, 2, { 825, 808 } },
    { 666610, 2, { 890, 749 } },
    { 666624, 2, { 868, 768 } },
    { 666655, 2, { 935, 713 } },
    { 666660, 2, { 820, 813 } },
    { 666666, 2, { 819, 814 } },
    { 666672, 2, { 817, 816 } },
    { 666740, 2, { 901, 740 } },
    { 666750, 2, { 875, 762 } },
    { 666804, 2, { 921, 724 } },
    { 666816, 2, { 906, 736 } },
    { 666855, 2, { 1015, 657 } },
    { 666875, 2, { 1067, 625 } },
    { 666900, 2, { 855, 780 } },
    { 666925, 2, { 925, 721 } },
    { 666952, 2, { 968, 689 } },
    { 666972, 2, { 873, 764 } },
    { 666974, 2, { 854, 781 } },
    { 666995, 2, { 1003, 665 } },
    { 667000, 2, { 920, 725 } },
    { 667029, 2, { 957, 697 } },
    { 667035, 2, { 915, 729 } },
    { 667080, 2, { 872, 765 } },
    { 667116, 2, { 852, 783 } },
    { 667152, 2, { 904, 738 } },
    { 667184, 2, { 851, 784 } },
    { 667200, 2, { 834, 800 } },
    { 667212, 2, { 987, 676 } },
    { 667233, 2, { 833, 801 } },
    { 667275, 2, { 861, 775 } },
    { 667290, 2, { 870, 767 } },
    { 667296, 2, { 993, 672 } },
    { 667320, 2, { 830, 804 } },
    { 667332, 2, { 999, 668 } },
    { 667359, 2, { 891, 749 } },
    { 667368, 2, { 828, 806 } },
    { 667380, 2, { 908, 735 } },
    { 667392, 2, { 869, 768 } },
    { 667440, 2, { 824, 810 } },
    { 667485, 2, { 819, 815 } },
    { 667520, 2, { 896, 745 } },
    { 667575, 2, { 989, 675 } },
    { 667576, 2, { 917, 728 } },
    { 667584, 2, { 912, 732 } },
    { 667590, 2, { 867, 770 } },
    { 667625, 2, { 875, 763 } },
    { 667641, 2, { 901, 741 } },
    { 667656, 2, { 843, 792 } },
    { 667667, 2, { 1001, 667 } },
    { 667755, 2, { 855, 781 } },
    { 667764, 2, { 916, 729 } },
    { 667800, 2, { 840, 795 } },
    { 667821, 2, { 1029, 649 } },
    { 667830, 2, { 985, 678 } },
    { 667890, 2, { 905, 738 } },
    { 667920, 2, { 880, 759 } },
    { 667964, 2, { 836, 799 } },
    { 667968, 2, { 852, 784 } },
    { 667998, 2, { 1003, 666 } },
    { 668000, 2, { 835, 800 } },
    { 668024, 2, { 1057, 632 } },
    { 668028, 2, { 933, 716 } },
    { 668040, 2, { 879, 760 } },
    { 668052, 2, { 924, 723 } },
    { 668096, 2, { 832, 803 } },
    { 668124, 2, { 831, 804 } },
    { 668136, 2, { 861, 776 } },
    { 668160, 2, { 870, 768 } },
    { 668196, 2, { 828, 807 } },
    { 668220, 2, { 860, 777 } },
    { 668244, 2, { 932, 717 } },
    { 668250, 2, { 825, 810 } },
    { 668304, 2, { 819, 816 } },
    { 668316, 2, { 913, 732 } },
    { 668340, 2, { 846, 790 } },
    { 668382, 2, { 858, 779 } },
    { 668388, 2, { 876, 763 } },
    { 668493, 2, { 917, 729 } },
    { 668528, 2, { 889, 752 } },
    { 668560, 2, { 976, 685 } },
    { 668564, 2, { 989, 676 } },
    { 668565, 2, { 895, 747 } },
    { 668568, 2, { 939, 712 } },
    { 668577, 2, { 1027, 651 } },
    { 668610, 2, { 855, 782 } },
    { 668655, 2, { 1053, 635 } },
    { 668664, 2, { 888, 753 } },
    { 668682, 2, { 854, 783 } },
    { 668736, 2, { 864, 774 } },
    { 668745, 2, { 965, 693 } },
    { 668763, 2, { 837, 799 } },
    { 668800, 2, { 836, 800 } },
    { 668820, 2, { 852, 785 } },
    { 668835, 2, { 835, 801 } },
    { 668899, 2, { 833, 803 } },
    { 668928, 2, { 832, 804 } },
    { 669012, 2, { 849, 788 } },
    { 669045, 2, { 949, 705 } },
    { 669060, 2, { 826, 810 } },
    { 669072, 2, { 848, 789 } },
    { 669120, 2, { 820, 816 } },
    { 669123, 2, { 819, 817 } },
    { 669130, 2, { 847, 790 } },
    { 669175, 2, { 923, 725 } },
    { 669186, 2, { 846, 791 } },
    { 669228, 2, { 868, 771 } },
    { 669240, 2, { 845, 792 } },
    { 669256, 2, { 952, 703 } },
    { 669280, 2, { 890, 752 } },
    { 669285, 2, { 963, 695 } },
    { 669312, 2, { 896, 747 } },
    { 669324, 2, { 867, 772 } },
    { 669330, 2, { 999, 670 } },
    { 669375, 2, { 875, 765 } },
    { 669410, 2, { 917, 730 } },
    { 669424, 2, { 973, 688 } },
    { 669438, 2, { 882, 759 } },
    { 669504, 2, { 951, 704 } },
    { 669510, 2, { 865, 774 } },
    { 669515, 2, { 1295, 517 } },
    { 669536, 2, { 854, 784 } },
    { 669600, 2, { 837, 800 } },
    { 669636, 2, { 836, 801 } },
    { 669655, 2, { 1007, 665 } },
    { 669725, 2, { 1075, 623 } },
    { 669732, 2, { 833, 804 } },
    { 669750, 2, { 893, 750 } },
    { 669760, 2, { 832, 805 } },
    { 669780, 2, { 915, 732 } },
    { 669864, 2, { 904, 741 } },
    { 669900, 2, { 825, 812 } },
    { 669912, 2, { 824, 813 } },
    { 669920, 2, { 848, 790 } },
    { 669930, 2, { 822, 815 } },
    { 669940, 2, { 820, 817 } },
    { 670032, 2, { 846, 792 } },
    { 670140, 2, { 876, 765 } },
    { 670208, 2, { 896, 748 } },
    { 670225, 2, { 1411, 475 } },
    { 670236, 2, { 948, 707 } },
    { 670240, 2, { 944, 710 } },
    { 670248, 2, { 856, 783 } },
    { 670320, 2, { 840, 798 } },
    { 670329, 2, { 999, 671 } },
    { 670344, 2, { 901, 744 } },
    { 670350, 2, { 1025, 654 } },
    { 670410, 2, { 955, 702 } },
    { 670432, 2, { 1022, 656 } },
    { 670440, 2, { 888, 755 } },
    { 670450, 2, { 1150, 583 } },
    { 670480, 2, { 986, 680 } },
    { 670488, 2, { 921, 728 } },
    { 670514, 2, { 962, 697 } },
    { 670530, 2, { 930, 721 } },
    { 670548, 2, { 969, 692 } },
    { 670560, 2, { 880, 762 } },
    { 670592, 2, { 832, 806 } },
    { 670670, 2, { 871, 770 } },
    { 670704, 2, { 942, 712 } },
    { 670720, 2, { 1024, 655 } },
    { 670752, 2, { 822, 816 } },
    { 670768, 2, { 848, 791 } },
    { 670824, 2, { 847, 792 } },
    { 670878, 2, { 846, 793 } },
    { 670890, 2, { 1045, 642 } },
    { 670944, 2, { 928, 723 } },
    { 670950, 2, { 945, 710 } },
    { 670956, 2, { 858, 782 } },
    { 670980, 2, { 844, 795 } },
    { 670995, 2, { 1147, 585 } },
    { 671000, 2, { 1000, 671 } },
    { 671004, 2, { 981, 684 } },
    { 671028, 2, { 843, 796 } },
    { 671055, 2, { 913, 735 } },
    { 671088, 2, { 902, 744 } },
    { 671099, 2, { 1859, 361 } },
    { 671112, 2, { 936, 717 } },
    { 671118, 2, { 841, 798 } },
    { 671125, 2, { 875, 767 } },
    { 671148, 2, { 927, 724 } },
    { 671160, 2, { 840, 799 } },
    { 671175, 2, { 855, 785 } },
    { 671184, 2, { 944, 711 } },
    { 671232, 2, { 874, 768 } },
    { 671240, 2, { 865, 776 } },
    { 671250, 2, { 895, 750 } },
    { 671268, 2, { 993, 676 } },
    { 671300, 2, { 959, 700 } },
    { 671301, 2, { 1081, 621 } },
    { 671328, 2, { 864, 777 } },
    { 671340, 2, { 835, 804 } },
    { 671370, 2, { 834, 805 } },
    { 671398, 2, { 833, 806 } },
    { 671424, 2, { 832, 807 } },
    { 671448, 2, { 831, 808 } },
    { 671517, 2, { 969, 693 } },
    { 671550, 2, { 825, 814 } },
    { 671556, 2, { 879, 764 } },
    { 671560, 2, { 824, 815 } },
    { 671580, 2, { 820, 819 } },
    { 671594, 2, { 979, 686 } },
    { 671625, 2, { 995, 675 } },
    { 671650, 2, { 950, 707 } },
    { 671660, 2, { 860, 781 } },
    { 671671, 2, { 847, 793 } },
    { 671676, 2, { 892, 753 } },
    { 671760, 2, { 933, 720 } },
    { 671944, 2, { 923, 728 } },
    { 671960, 2, { 856, 785 } },
    { 671968, 2, { 913, 736 } },
    { 671985, 2, { 981, 685 } },
    { 672000, 2, { 840, 800 } },
    { 672075, 2, { 927, 725 } },
    { 672111, 2, { 837, 803 } },
    { 672133, 2, { 1247, 539 } },
    { 672228, 2, { 852, 789 } },
    { 672288, 2, { 894, 752 } },
    { 672300, 2, { 830, 810 } },
    { 672312, 2, { 872, 771 } },
    { 672324, 2, { 939, 716 } },
    { 672336, 2, { 828, 812 } },
    { 672350, 2, { 850, 791 } },
    { 672408, 2, { 849, 792 } },
    { 672441, 2, { 861, 781 } },
    { 672452, 2, { 899, 748 } },
    { 672464, 2, { 848, 793 } },
    { 672570, 2, { 846, 795 } },
    { 672600, 2, { 885, 760 } },
    { 672606, 2, { 869, 774 } },
    { 672660, 2, { 909, 740 } },
    { 672672, 2, { 858, 784 } },
    { 672705, 2, { 891, 755 } },
    { 672750, 2, { 897, 750 } },
    { 672760, 2, { 968, 695 } },
    { 672768, 2, { 876, 768 } },
    { 672771, 2, { 957, 703 } },
    { 672792, 2, { 867, 776 } },
    { 672800, 2, { 841, 800 } },
    { 672816, 2, { 856, 786 } },
    { 672828, 2, { 908, 741 } },
    { 672840, 2, { 840, 801 } },
    { 672864, 2, { 978, 688 } },
    { 672867, 2, { 923, 729 } },
    { 672948, 2, { 837, 804 } },
    { 672966, 2, { 882, 763 } },
    { 673040, 2, { 895, 752 } },
    { 673056, 2, { 864, 779 } },
    { 673064, 2, { 833, 808 } },
    { 673080, 2, { 852, 790 } },
    { 673164, 2, { 828, 813 } },
    { 673200, 2, { 825, 816 } },
    { 673260, 2, { 916, 735 } },
    { 673308, 2, { 951, 708 } },
    { 673320, 2, { 905, 744 } },
    { 673322, 2, { 893, 754 } },
    { 673344, 2, { 1002, 672 } },
    { 673365, 2, { 847, 795 } },
    { 673380, 2, { 860, 783 } },
    { 673425, 2, { 1025, 657 } },
    { 673440, 2, { 915, 736 } },
    { 673475, 2, { 869, 775 } },
    { 673480, 2, { 904, 745 } },
    { 673530, 2, { 858, 785 } },
    { 673596, 2, { 891, 756 } },
    { 673712, 2, { 1027, 656 } },
    { 673728, 2, { 928, 726 } },
    { 673740, 2, { 855, 788 } },
    { 673750, 2, { 875, 770 } },
    { 673785, 2, { 837, 805 } },
    { 673816, 2, { 836, 806 } },
    { 673836, 2, { 932, 723 } },
    { 673872, 2, { 834, 808 } },
    { 673920, 2, { 832, 810 } },
    { 673932, 2, { 852, 791 } },
    { 673946, 2, { 1058, 637 } },
    { 673948, 2, { 901, 748 } },
    { 673956, 2, { 873, 772 } },
    { 673980, 2, { 940, 717 } },
    { 673992, 2, { 828, 814 } },
    { 673995, 2, { 917, 735 } },
    { 674016, 2, { 826, 816 } },
    { 674025, 2, { 825, 817 } },
    { 674050, 2, { 850, 793 } },
    { 674064, 2, { 906, 744 } },
    { 674100, 2, { 900, 749 } },
    { 674145, 2, { 1055, 639 } },
    { 674154, 2, { 871, 774 } },
    { 674160, 2, { 848, 795 } },
    { 674163, 2, { 861, 783 } },
    { 674172, 2, { 921, 732 } },
    { 674245, 2, { 943, 715 } },
    { 674250, 2, { 870, 775 } },
    { 674289, 2, { 973, 693 } },
    { 674310, 2, { 845, 798 } },
    { 674325, 2, { 925, 729 } },
    { 674355, 2, { 915, 737 } },
    { 674375, 2, { 1079, 625 } },
    { 674400, 2, { 843, 800 } },
    { 674424, 2, { 969, 696 } },
    { 674436, 2, { 868, 777 } },
    { 674450, 2, { 1025, 658 } },
    { 674520, 2, { 840, 803 } },
    { 674544, 2, { 897, 752 } },
    { 674610, 2, { 995, 678 } },
    { 674652, 2, { 836, 807 } },
    { 674680, 2, { 835, 808 } },
    { 674688, 2, { 896, 753 } },
    { 674700, 2, { 865, 780 } },
    { 674730, 2, { 833, 810 } },
    { 674772, 2, { 831, 812 } },
    { 674817, 2, { 1331, 507 } },
    { 674820, 2, { 828, 815 } },
    { 674856, 2, { 824, 819 } },
    { 674912, 2, { 917, 736 } },
    { 674928, 2, { 872, 774 } },
    { 674960, 2, { 880, 767 } },
    { 674970, 2, { 894, 755 } },
    { 674975, 2, { 931, 725 } },
    { 675004, 2, { 1012, 667 } },
    { 675024, 2, { 861, 784 } },
    { 675025, 2, { 871, 775 } },
    { 675070, 2, { 935, 722 } },
    { 675072, 2, { 879, 768 } },
    { 675087, 2, { 1037, 651 } },
    { 675120, 2, { 870, 776 } },
    { 675136, 2, { 959, 704 } },
    { 675155, 2, { 845, 799 } },
    { 675213, 2, { 869, 777 } },
    { 675240, 2, { 993, 680 } },
    { 675255, 2, { 885, 763 } },
    { 675270, 2, { 915, 738 } },
    { 675288, 2, { 904, 747 } },
    { 675324, 2, { 962, 702 } },
    { 675384, 2, { 856, 789 } },
    { 675393, 2, { 867, 779 } },
    { 675396, 2, { 876, 771 } },
    { 675423, 2, { 1057, 639 } },
    { 675444, 2, { 903, 748 } },
    { 675492, 2, { 933, 724 } },
    { 675584, 2, { 832, 812 } },
    { 675625, 2, { 1081, 625 } },
    { 675640, 2, { 889, 760 } },
    { 675648, 2, { 828, 816 } },
    { 675675, 2, { 825, 819 } },
    { 675766, 2, { 1027, 658 } },
    { 675792, 2, { 912, 741 } },
    { 675800, 2, { 872, 775 } },
    { 675804, 2, { 849, 796 } },
    { 675840, 2, { 880, 768 } },
    { 675990, 2, { 870, 777 } },
    { 676000, 2, { 845, 800 } },
    { 676035, 2, { 905, 747 } },
    { 676039, 2, { 1547, 437 } },
    { 676044, 2, { 844, 801 } },
    { 676080, 2, { 939, 720 } },
    { 676095, 2, { 959, 705 } },
    { 676140, 2, { 885, 764 } },
    { 676172, 2, { 868, 779 } },
    { 676175, 2, { 925, 731 } },
    { 676200, 2, { 840, 805 } },
    { 676260, 2, { 867, 780 } },
    { 676269, 2, { 891, 759 } },
    { 676284, 2, { 996, 679 } },
    { 676296, 2, { 837, 808 } },
    { 676305, 2, { 855, 791 } },
    { 676350, 2, { 835, 810 } },
    { 676368, 2, { 854, 792 } },
    { 676377, 2, { 1107, 611 } },
    { 676416, 2, { 832, 813 } },
    { 676476, 2, { 828, 817 } },
    { 676480, 2, { 896, 755 } },
    { 676500, 2, { 825, 820 } },
    { 676512, 2, { 864, 783 } },
    { 676544, 2, { 961, 704 } },
    { 676566, 2, { 918, 737 } },
    { 676575, 2, { 873, 775 } },
    { 676620, 2, { 895, 756 } },
    { 676656, 2, { 888, 762 } },
    { 676704, 2, { 848, 798 } },
    { 676728, 2, { 936, 723 } },
    { 676753, 2, { 847, 799 } },
    { 676767, 2, { 871, 777 } },
    { 676775, 2, { 1177, 575 } },
    { 676800, 2, { 846, 800 } },
    { 676845, 2, { 845, 801 } },
    { 676848, 2, { 944, 717 } },
    { 676863, 2, { 1161, 583 } },
    { 676875, 2, { 1083, 625 } },
    { 677005, 2, { 841, 805 } },
    { 677028, 2, { 892, 759 } },
    { 677040, 2, { 840, 806 } },
    { 677075, 2, { 1325, 511 } },
    { 677096, 2, { 856, 791 } },
    { 677100, 2, { 915, 740 } },
    { 677112, 2, { 951, 712 } },
    { 677160, 2, { 836, 810 } },
    { 677205, 2, { 909, 745 } },
    { 677248, 2, { 832, 814 } },
    { 677250, 2, { 875, 774 } },
    { 677280, 2, { 830, 816 } },
    { 677295, 2, { 865, 783 } },
    { 677310, 2, { 1055, 642 } },
    { 677320, 2, { 826, 820 } },
    { 677328, 2, { 824, 822 } },
    { 677340, 2, { 852, 795 } },
    { 677376, 2, { 864, 784 } },
    { 677425, 2, { 1225, 553 } },
    { 677430, 2, { 965, 702 } },
    { 677440, 2, { 928, 730 } },
    { 677446, 2, { 913, 742 } },
    { 677448, 2, { 873, 776 } },
    { 677544, 2, { 872, 777 } },
    { 677556, 2, { 957, 708 } },
    { 677586, 2, { 949, 714 } },
    { 677600, 2, { 847, 800 } },
    { 677700, 2, { 900, 753 } },
    { 677705, 2, { 1139, 595 } },
    { 677730, 2, { 870, 779 } },
    { 677740, 2, { 940, 721 } },
    { 677768, 2, { 931, 728 } },
    { 677772, 2, { 843, 804 } },
    { 677787, 2, { 893, 759 } },
    { 677856, 2, { 921, 736 } },
    { 677880, 2, { 840, 807 } },
    { 677908, 2, { 868, 781 } },
    { 677925, 2, { 1035, 655 } },
    { 677976, 2, { 984, 689 } },
    { 678000, 2, { 904, 750 } },
    { 678015, 2, { 855, 793 } },
    { 678040, 2, { 920, 737 } },
    { 678062, 2, { 833, 814 } },
    { 678080, 2, { 832, 815 } },
    { 678096, 2, { 831, 816 } },
    { 678132, 2, { 828, 819 } },
    { 678160, 2, { 865, 784 } },
    { 678240, 2, { 864, 785 } },
    { 678276, 2, { 908, 747 } },
    { 678300, 2, { 850, 798 } },
    { 678320, 2, { 976, 695 } },
    { 678368, 2, { 928, 731 } },
    { 678375, 2, { 1005, 675 } },
    { 678405, 2, { 923, 735 } },
    { 678447, 2, { 847, 801 } },
    { 678454, 2, { 989, 686 } },
    { 678468, 2, { 861, 788 } },
    { 678480, 2, { 880, 771 } },
    { 678540, 2, { 860, 789 } },
    { 678564, 2, { 927, 732 } },
    { 678580, 2, { 917, 740 } },
    { 678588, 2, { 879, 772 } },
    { 678612, 2, { 1067, 636 } },
    { 678680, 2, { 893, 760 } },
    { 678699, 2, { 931, 729 } },
    { 678750, 2, { 905, 750 } },
    { 678755, 2, { 1435, 473 } },
    { 678756, 2, { 916, 741 } },
    { 678810, 2, { 935, 726 } },
    { 678852, 2, { 981, 692 } },
    { 678900, 2, { 876, 775 } },
    { 678912, 2, { 832, 816 } },
    { 678930, 2, { 854, 795 } },
    { 678960, 2, { 828, 820 } },
    { 679000, 2, { 875, 776 } },
    { 679005, 2, { 955, 711 } },
    { 679042, 2, { 1066, 637 } },
    { 679056, 2, { 903, 752 } },
    { 679070, 2, { 890, 763 } },
    { 679098, 2, { 851, 798 } },
    { 679104, 2, { 864, 786 } },
    { 679140, 2, { 882, 770 } },
    { 679150, 2, { 850, 799 } },
    { 679185, 2, { 1053, 645 } },
    { 679200, 2, { 849, 800 } },
    { 679212, 2, { 993, 684 } },
    { 679224, 2, { 933, 728 } },
    { 679248, 2, { 848, 801 } },
    { 679272, 2, { 913, 744 } },
    { 679296, 2, { 928, 732 } },
    { 679320, 2, { 888, 765 } },
    { 679328, 2, { 923, 736 } },
    { 679338, 2, { 846, 803 } },
    { 679354, 2, { 901, 754 } },
    { 679380, 2, { 845, 804 } },
    { 679428, 2, { 932, 729 } },
    { 679440, 2, { 894, 760 } },
    { 679470, 2, { 870, 781 } },
    { 679500, 2, { 900, 755 } },
    { 679520, 2, { 992, 685 } },
    { 679536, 2, { 858, 792 } },
    { 679575, 2, { 975, 697 } },
    { 679581, 2, { 1127, 603 } },
    { 679620, 2, { 940, 723 } },
    { 679630, 2, { 931, 730 } },
    { 679644, 2, { 837, 812 } },
    { 679650, 2, { 985, 690 } },
    { 679668, 2, { 836, 813 } },
    { 679680, 2, { 885, 768 } },
    { 679710, 2, { 834, 815 } },
    { 679716, 2, { 948, 717 } },
    { 679728, 2, { 833, 816 } },
    { 679744, 2, { 832, 817 } },
    { 679800, 2, { 825, 824 } },
    { 679830, 2, { 930, 731 } },
    { 679833, 2, { 891, 763 } },
    { 679836, 2, { 939, 724 } },
    { 679875, 2, { 875, 777 } },
    { 679890, 2, { 865, 786 } },
    { 679932, 2, { 909, 748 } },
    { 680000, 2, { 850, 800 } },
    { 680043, 2, { 987, 689 } },
    { 680050, 2, { 938, 725 } },
    { 680064, 2, { 896, 759 } },
    { 680085, 2, { 889, 765 } },
    { 680200, 2, { 895, 760 } },
    { 680238, 2, { 918, 741 } },
    { 680260, 2, { 860, 791 } },
    { 680295, 2, { 1023, 665 } },
    { 680316, 2, { 1068, 637 } },
    { 680394, 2, { 858, 793 } },
    { 680400, 2, { 840, 810 } },
    { 680427, 2, { 869, 783 } },
    { 680485, 2, { 1235, 551 } },
    { 680520, 2, { 856, 795 } },
    { 680544, 2, { 834, 816 } },
    { 680560, 2, { 905, 752 } },
    { 680561, 2, { 833, 817 } },
    { 680580, 2, { 855, 796 } },
    { 680652, 2, { 876, 777 } },
    { 680680, 2, { 884, 770 } },
    { 680688, 2, { 978, 696 } },
    { 680712, 2, { 904, 753 } },
    { 680724, 2, { 891, 764 } },
    { 680760, 2, { 915, 744 } },
    { 680800, 2, { 851, 800 } },
    { 680841, 2, { 909, 749 } },
    { 680890, 2, { 959, 710 } },
    { 680916, 2, { 951, 716 } },
    { 680940, 2, { 873, 780 } },
    { 680944, 2, { 848, 803 } },
    { 680960, 2, { 896, 760 } },
    { 680988, 2, { 847, 804 } },
    { 681030, 2, { 846, 805 } },
    { 681065, 2, { 1015, 671 } },
    { 681096, 2, { 888, 767 } },
    { 681100, 2, { 973, 700 } },
    { 681108, 2, { 844, 807 } },
    { 681120, 2, { 860, 792 } },
    { 681144, 2, { 843, 808 } },
    { 681156, 2, { 901, 756 } },
    { 681174, 2, { 923, 738 } },
    { 681200, 2, { 1040, 655 } },
    { 681207, 2, { 969, 703 } },
    { 681210, 2, { 841, 810 } },
    { 681264, 2, { 912, 747 } },
    { 681296, 2, { 869, 784 } },
    { 681312, 2, { 906, 752 } },
    { 681318, 2, { 837, 814 } },
    { 681360, 2, { 835, 816 } },
    { 681384, 2, { 957, 712 } },
    { 681408, 2, { 832, 819 } },
    { 681420, 2, { 831, 820 } },
    { 681450, 2, { 826, 825 } },
    { 681540, 2, { 921, 740 } },
    { 681564, 2, { 884, 771 } },
    { 681590, 2, { 910, 749 } },
    { 681600, 2, { 852, 800 } },
    { 681615, 2, { 891, 765 } },
    { 681625, 2, { 875, 779 } },
    { 681696, 2, { 864, 789 } },
    { 681720, 2, { 874, 780 } },
    { 681725, 2, { 925, 737 } },
    { 681792, 2, { 848, 804 } },
    { 681795, 2, { 981, 695 } },
    { 681804, 2, { 963, 708 } },
    { 681849, 2, { 959, 711 } },
    { 681870, 2, { 955, 714 } },
    { 681912, 2, { 861, 792 } },
    { 681980, 2, { 860, 793 } },
    { 681984, 2, { 888, 768 } },
    { 681990, 2, { 895, 762 } },
    { 681993, 2, { 871, 783 } },
    { 682000, 2, { 880, 775 } },
    { 682040, 2, { 1003, 680 } },
    { 682080, 2, { 840, 812 } },
    { 682104, 2, { 879, 776 } },
    { 682155, 2, { 837, 815 } },
    { 682176, 2, { 836, 816 } },
    { 682185, 2, { 1095, 623 } },
    { 682227, 2, { 833, 819 } },
    { 682240, 2, { 832, 820 } },
    { 682341, 2, { 899, 759 } },
    { 682344, 2, { 936, 729 } },
    { 682380, 2, { 892, 765 } },
    { 682395, 2, { 1005, 679 } },
    { 682410, 2, { 989, 690 } },
    { 682452, 2, { 852, 801 } },
    { 682465, 2, { 1085, 629 } },
    { 682479, 2, { 1099, 621 } },
    { 682500, 2, { 875, 780 } },
    { 682512, 2, { 944, 723 } },
    { 682520, 2, { 904, 755 } },
    { 682539, 2, { 1221, 559 } },
    { 682550, 2, { 850, 803 } },
    { 682560, 2, { 864, 790 } },
    { 682584, 2, { 952, 717 } },
    { 682596, 2, { 849, 804 } },
    { 682605, 2, { 985, 693 } },
    { 682640, 2, { 848, 805 } },
    { 682650, 2, { 925, 738 } },
    { 682675, 2, { 1175, 581 } },
    { 682682, 2, { 847, 806 } },
    { 682689, 2, { 1121, 609 } },
    { 682752, 2, { 889, 768 } },
    { 682760, 2, { 845, 808 } },
    { 682773, 2, { 861, 793 } },
    { 682776, 2, { 872, 783 } },
    { 682808, 2, { 959, 712 } },
    { 682864, 2, { 871, 784 } },
    { 682920, 2, { 840, 813 } },
    { 682950, 2, { 870, 785 } },
    { 682955, 2, { 1027, 665 } },
    { 682956, 2, { 933, 732 } },
    { 682992, 2, { 837, 816 } },
    { 683004, 2, { 987, 692 } },
    { 683012, 2, { 836, 817 } },
    { 683020, 2, { 923, 740 } },
    { 683060, 2, { 833, 820 } },
    { 683088, 2, { 856, 798 } },
    { 683100, 2, { 828, 825 } },
    { 683145, 2, { 855, 799 } },
    { 683184, 2, { 993, 688 } },
    { 683196, 2, { 867, 788 } },
    { 683200, 2, { 854, 800 } },
    { 683220, 2, { 885, 772 } },
    { 683240, 2, { 899, 760 } },
    { 683265, 2, { 1111, 615 } },
    { 683298, 2, { 957, 714 } },
    { 683316, 2, { 972, 703 } },
    { 683375, 2, { 875, 781 } },
    { 683397, 2, { 891, 767 } },
    { 683400, 2, { 850, 804 } },
    { 683424, 2, { 864, 791 } },
    { 683430, 2, { 1045, 654 } },
    { 683436, 2, { 1011, 676 } },
    { 683485, 2, { 935, 731 } },
    { 683501, 2, { 1073, 637 } },
    { 683508, 2, { 948, 721 } },
    { 683520, 2, { 890, 768 } },
    { 683550, 2, { 882, 775 } },
    { 683568, 2, { 846, 808 } },
    { 683592, 2, { 939, 728 } },
    { 683675, 2, { 943, 725 } },
    { 683700, 2, { 860, 795 } },
    { 683724, 2, { 908, 753 } },
    { 683760, 2, { 840, 814 } },
    { 683774, 2, { 1183, 578 } },
    { 683802, 2, { 938, 729 } },
    { 683829, 2, { 837, 817 } },
    { 683859, 2, { 901, 759 } },
    { 683865, 2, { 835, 819 } },
    { 683872, 2, { 994, 688 } },
    { 683904, 2, { 832, 822 } },
    { 683928, 2, { 828, 826 } },
    { 683936, 2, { 928, 737 } },
    { 684000, 2, { 855, 800 } },
    { 684046, 2, { 1003, 682 } },
    { 684156, 2, { 852, 803 } },
    { 684180, 2, { 905, 756 } },
    { 684208, 2, { 1043, 656 } },
    { 684250, 2, { 850, 805 } },
    { 684252, 2, { 916, 747 } },
    { 684285, 2, { 931, 735 } },
    { 684288, 2, { 864, 792 } },
    { 684315, 2, { 999, 685 } },
    { 684320, 2, { 910, 752 } },
    { 684336, 2, { 848, 807 } },
    { 684352, 2, { 1088, 629 } },
    { 684376, 2, { 847, 808 } },
    { 684400, 2, { 944, 725 } },
    { 684420, 2, { 915, 748 } },
    { 684432, 2, { 873, 784 } },
    { 684450, 2, { 845, 810 } },
    { 684516, 2, { 843, 812 } },
    { 684520, 2, { 872, 785 } },
    { 684530, 2, { 889, 770 } },
    { 684600, 2, { 840, 815 } },
    { 684648, 2, { 888, 771 } },
    { 684675, 2, { 895, 765 } },
    { 684684, 2, { 836, 819 } },
    { 684720, 2, { 951, 720 } },
    { 684744, 2, { 831, 824 } },
    { 684760, 2, { 901, 760 } },
    { 684775, 2, { 1075, 637 } },
    { 684852, 2, { 868, 789 } },
    { 684864, 2, { 928, 738 } },
    { 684866, 2, { 923, 742 } },
    { 684950, 2, { 950, 721 } },
    { 684981, 2, { 1089, 629 } },
    { 684990, 2, { 885, 774 } },
    { 684992, 2, { 973, 704 } },
    { 684999, 2, { 917, 747 } },
    { 685000, 2, { 1000, 685 } },
    { 685020, 2, { 932, 735 } },
    { 685025, 2, { 1175, 583 } },
    { 685055, 2, { 851, 805 } },
    { 685069, 2, { 1271, 539 } },
    { 685080, 2, { 865, 792 } },
    { 685100, 2, { 850, 806 } },
    { 685125, 2, { 875, 783 } },
    { 685152, 2, { 864, 793 } },
    { 685212, 2, { 957, 716 } },
    { 685216, 2, { 874, 784 } },
    { 685224, 2, { 921, 744 } },
    { 685248, 2, { 996, 688 } },
    { 685251, 2, { 1043, 657 } },
    { 685305, 2, { 873, 785 } },
    { 685308, 2, { 897, 764 } },
    { 685335, 2, { 915, 749 } },
    { 685344, 2, { 944, 726 } },
    { 685356, 2, { 861, 796 } },
    { 685392, 2, { 872, 786 } },
    { 685400, 2, { 920, 745 } },
    { 685404, 2, { 948, 723 } },
    { 685410, 2, { 930, 737 } },
    { 685542, 2, { 858, 799 } },
    { 685620, 2, { 879, 780 } },
    { 685656, 2, { 856, 801 } },
    { 685762, 2, { 854, 803 } },
    { 685776, 2, { 942, 728 } },
    { 685790, 2, { 970, 707 } },
    { 685824, 2, { 893, 768 } },
    { 685850, 2, { 946, 725 } },
    { 685860, 2, { 852, 805 } },
    { 685906, 2, { 851, 806 } },
    { 685908, 2, { 876, 783 } },
    { 685965, 2, { 973, 705 } },
    { 685971, 2, { 1287, 533 } },
    { 685980, 2, { 927, 740 } },
    { 685992, 2, { 849, 808 } },
    { 686000, 2, { 875, 784 } },
    { 686052, 2, { 969, 708 } },
    { 686070, 2, { 847, 810 } },
    { 686080, 2, { 1024, 670 } },
    { 686115, 2, { 965, 711 } },
    { 686136, 2, { 904, 759 } },
    { 686147, 2, { 931, 737 } },
    { 686154, 2, { 961, 714 } },
    { 686172, 2, { 844, 813 } },
    { 686205, 2, { 897, 765 } },
    { 686256, 2, { 841, 816 } },
    { 686280, 2, { 840, 817 } },
    { 686295, 2, { 909, 755 } },
    { 686340, 2, { 837, 820 } },
    { 686343, 2, { 1029, 667 } },
    { 686350, 2, { 925, 742 } },
    { 686370, 2, { 835, 822 } },
    { 686392, 2, { 833, 824 } },
    { 686400, 2, { 832, 825 } },
    { 686504, 2, { 943, 728 } },
    { 686550, 2, { 995, 690 } },
    { 686565, 2, { 855, 803 } },
    { 686576, 2, { 913, 752 } },
    { 686592, 2, { 894, 768 } },
    { 686637, 2, { 1211, 567 } },
    { 686664, 2, { 867, 792 } },
    { 686686, 2, { 1001, 686 } },
    { 686688, 2, { 933, 736 } },
    { 686700, 2, { 900, 763 } },
    { 686720, 2, { 928, 740 } },
    { 686736, 2, { 912, 753 } },
    { 686760, 2, { 885, 776 } },
    { 686774, 2, { 1007, 682 } },
    { 686784, 2, { 876, 784 } },
    { 686868, 2, { 884, 777 } },
    { 686880, 2, { 848, 810 } },
    { 687115, 2, { 961, 715 } },
    { 687140, 2, { 860, 799 } },
    { 687156, 2, { 993, 692 } },
    { 687204, 2, { 909, 756 } },
    { 687216, 2, { 834, 824 } },
    { 687225, 2, { 833, 825 } },
    { 687232, 2, { 832, 826 } },
    { 687240, 2, { 830, 828 } },
    { 687280, 2, { 880, 781 } },
    { 687312, 2, { 888, 774 } },
    { 687323, 2, { 1079, 637 } },
    { 687344, 2, { 952, 722 } },
    { 687348, 2, { 939, 732 } },
    { 687360, 2, { 895, 768 } },
    { 687401, 2, { 1573, 437 } },
    { 687420, 2, { 855, 804 } },
    { 687447, 2, { 943, 729 } },
    { 687456, 2, { 868, 792 } },
    { 687480, 2, { 1011, 680 } },
    { 687564, 2, { 852, 807 } },
    { 687582, 2, { 918, 749 } },
    { 687610, 2, { 893, 770 } },
    { 687648, 2, { 912, 754 } },
    { 687660, 2, { 876, 785 } },
    { 687700, 2, { 1058, 650 } },
    { 687732, 2, { 892, 771 } },
    { 687735, 2, { 899, 765 } },
    { 687750, 2, { 875, 786 } },
    { 687775, 2, { 1025, 671 } },
    { 687792, 2, { 966, 712 } },
    { 687800, 2, { 905, 760 } },
    { 687852, 2, { 891, 772 } },
    { 687888, 2, { 843, 816 } },
    { 687897, 2, { 1253, 549 } },
    { 687924, 2, { 873, 788 } },
    { 687939, 2, { 861, 799 } },
    { 687940, 2, { 1060, 649 } },
    { 687960, 2, { 840, 819 } },
    { 688000, 2, { 860, 800 } },
    { 688008, 2, { 872, 789 } },
    { 688023, 2, { 1141, 603 } },
    { 688025, 2, { 949, 725 } },
    { 688040, 2, { 835, 824 } },
    { 688068, 2, { 831, 828 } },
    { 688080, 2, { 915, 752 } },
    { 688086, 2, { 889, 774 } },
    { 688160, 2, { 880, 782 } },
    { 688170, 2, { 870, 791 } },
    { 688176, 2, { 944, 729 } },
    { 688200, 2, { 888, 775 } },
    { 688215, 2, { 1067, 645 } },
    { 688248, 2, { 869, 792 } },
    { 688275, 2, { 855, 805 } },
    { 688296, 2, { 952, 723 } },
    { 688311, 2, { 999, 689 } },
    { 688344, 2, { 989, 696 } },
    { 688446, 2, { 1026, 671 } },
    { 688485, 2, { 1185, 581 } },
    { 688500, 2, { 850, 810 } },
    { 688512, 2, { 978, 704 } },
    { 688524, 2, { 951, 724 } },
    { 688545, 2, { 963, 715 } },
    { 688560, 2, { 906, 760 } },
    { 688597, 2, { 1081, 637 } },
    { 688636, 2, { 884, 779 } },
    { 688688, 2, { 946, 728 } },
    { 688758, 2, { 966, 713 } },
    { 688779, 2, { 841, 819 } },
    { 688800, 2, { 840, 820 } },
    { 688842, 2, { 882, 781 } },
    { 688848, 2, { 904, 762 } },
    { 688860, 2, { 860, 801 } },
    { 688896, 2, { 832, 828 } },
    { 688905, 2, { 945, 729 } },
    { 688908, 2, { 921, 748 } },
    { 688940, 2, { 931, 740 } },
    { 688975, 2, { 889, 775 } },
    { 689000, 2, { 1000, 689 } },
    { 689010, 2, { 965, 714 } },
    { 689040, 2, { 870, 792 } },
    { 689080, 2, { 856, 805 } },
    { 689120, 2, { 944, 730 } },
    { 689130, 2, { 855, 806 } },
    { 689136, 2, { 879, 784 } },
    { 689172, 2, { 908, 759 } },
    { 689310, 2, { 851, 810 } },
    { 689325, 2, { 975, 707 } },
    { 689376, 2, { 1002, 688 } },
    { 689388, 2, { 849, 812 } },
    { 689424, 2, { 848, 813 } },
    { 689425, 2, { 1199, 575 } },
    { 689430, 2, { 938, 735 } },
    { 689440, 2, { 992, 695 } },
    { 689472, 2, { 864, 798 } },
    { 689490, 2, { 846, 815 } },
    { 689508, 2, { 963, 716 } },
    { 689520, 2, { 845, 816 } },
    { 689535, 2, { 995, 693 } },
    { 689584, 2, { 917, 752 } },
    { 689605, 2, { 1037, 665 } },
    { 689610, 2, { 905, 762 } },
    { 689688, 2, { 837, 824 } },
    { 689689, 2, { 1001, 689 } },
    { 689700, 2, { 836, 825 } },
    { 689715, 2, { 1053, 655 } },
    { 689724, 2, { 833, 828 } },
    { 689748, 2, { 916, 753 } },
    { 689752, 2, { 872, 791 } },
    { 689843, 2, { 1309, 527 } },
    { 689850, 2, { 945, 730 } },
    { 689864, 2, { 889, 776 } },
    { 689892, 2, { 903, 764 } },
    { 689910, 2, { 870, 793 } },
    { 689928, 2, { 969, 712 } },
    { 689970, 2, { 1055, 654 } },
    { 689976, 2, { 888, 777 } },
    { 690000, 2, { 920, 750 } },
    { 690030, 2, { 902, 765 } },
    { 690060, 2, { 868, 795 } },
    { 690132, 2, { 867, 796 } },
    { 690184, 2, { 968, 713 } },
    { 690195, 2, { 979, 705 } },
    { 690200, 2, { 850, 812 } },
    { 690228, 2, { 913, 756 } },
    { 690235, 2, { 1295, 533 } },
    { 690270, 2, { 865, 798 } },
    { 690300, 2, { 885, 780 } },
    { 690336, 2, { 846, 816 } },
    { 690345, 2, { 1035, 667 } },
    { 690365, 2, { 845, 817 } },
    { 690368, 2, { 938, 736 } },
    { 690420, 2, { 933, 740 } },
    { 690432, 2, { 899, 768 } },
    { 690459, 2, { 1029, 671 } },
    { 690480, 2, { 840, 822 } },
    { 690525, 2, { 837, 825 } },
    { 690543, 2, { 873, 791 } },
    { 690560, 2, { 832, 830 } },
    { 690580, 2, { 860, 803 } },
    { 690612, 2, { 932, 741 } },
    { 690615, 2, { 927, 745 } },
    { 690625, 2, { 1105, 625 } },
    { 690642, 2, { 1037, 666 } },
    { 690690, 2, { 858, 805 } },
    { 690768, 2, { 936, 738 } },
    { 690792, 2, { 856, 807 } },
    { 690795, 2, { 903, 765 } },
    { 690800, 2, { 880, 785 } },
    { 690816, 2, { 896, 771 } },
    { 690830, 2, { 973, 710 } },
    { 690840, 2, { 855, 808 } },
    { 690855, 2, { 869, 795 } },
    { 690872, 2, { 949, 728 } },
    { 690897, 2, { 969, 713 } },
    { 690900, 2, { 940, 735 } },
    { 690975, 2, { 925, 747 } },
    { 691008, 2, { 944, 732 } },
    { 691012, 2, { 851, 812 } },
    { 691092, 2, { 948, 729 } },
    { 691104, 2, { 939, 736 } },
    { 691120, 2, { 848, 815 } },
    { 691128, 2, { 993, 696 } },
    { 691152, 2, { 847, 816 } },
    { 691164, 2, { 876, 789 } },
    { 691173, 2, { 1113, 621 } },
    { 691185, 2, { 885, 781 } },
    { 691188, 2, { 956, 723 } },
    { 691200, 2, { 864, 800 } },
    { 691236, 2, { 844, 819 } },
    { 691260, 2, { 843, 820 } },
    { 691288, 2, { 884, 782 } },
    { 691308, 2, { 999, 692 } },
    { 691360, 2, { 928, 745 } },
    { 691362, 2, { 837, 826 } },
    { 691380, 2, { 835, 828 } },
    { 691383, 2, { 861, 803 } },
    { 691390, 2, { 833, 830 } },
    { 691392, 2, { 832, 831 } },
    { 691416, 2, { 873, 792 } },
    { 691424, 2, { 992, 697 } },
    { 691470, 2, { 985, 702 } },
    { 691488, 2, { 882, 784 } },
    { 691515, 2, { 1089, 635 } },
    { 691524, 2, { 1011, 684 } },
    { 691548, 2, { 858, 806 } },
    { 691560, 2, { 904, 765 } },
    { 691680, 2, { 880, 786 } },
    { 691740, 2, { 854, 810 } },
    { 691752, 2, { 888, 779 } },
    { 691775, 2, { 1475, 469 } },
    { 691803, 2, { 973, 711 } },
    { 691821, 2, { 949, 729 } },
    { 691834, 2, { 902, 767 } },
    { 691875, 2, { 1025, 675 } },
    { 691900, 2, { 850, 814 } },
    { 691920, 2, { 930, 744 } },
    { 691999, 2, { 847, 817 } },
    { 692000, 2, { 865, 800 } },
    { 692040, 2, { 876, 790 } },
    { 692055, 2, { 845, 819 } },
    { 692064, 2, { 864, 801 } },
    { 692075, 2, { 893, 775 } },
    { 692076, 2, { 924, 749 } },
    { 692120, 2, { 968, 715 } },
    { 692125, 2, { 875, 791 } },
    { 692172, 2, { 884, 783 } },
    { 692230, 2, { 899, 770 } },
    { 692244, 2, { 861, 804 } },
    { 692250, 2, { 923, 750 } },
    { 692307, 2, { 891, 777 } },
    { 692325, 2, { 905, 765 } },
    { 692328, 2, { 951, 728 } },
    { 692370, 2, { 882, 785 } },
    { 692445, 2, { 871, 795 } },
    { 692461, 2, { 1309, 529 } },
    { 692484, 2, { 897, 772 } },
    { 692550, 2, { 855, 810 } },
    { 692552, 2, { 1043, 664 } },
    { 692592, 2, { 921, 752 } },
    { 692601, 2, { 903, 767 } },
    { 692652, 2, { 879, 788 } },
    { 692676, 2, { 852, 813 } },
    { 692730, 2, { 895, 774 } },
    { 692736, 2, { 902, 768 } },
    { 692760, 2, { 920, 753 } },
    { 692776, 2, { 973, 712 } },
    { 692780, 2, { 940, 737 } },
    { 692784, 2, { 849, 816 } },
    { 692825, 2, { 925, 749 } },
    { 692835, 2, { 935, 741 } },
    { 692850, 2, { 894, 775 } },
    { 692860, 2, { 980, 707 } },
    { 692865, 2, { 865, 801 } },
    { 692868, 2, { 957, 724 } },
    { 692916, 2, { 876, 791 } },
    { 692955, 2, { 885, 783 } },
    { 692960, 2, { 976, 710 } },
    { 693000, 2, { 840, 825 } },
    { 693036, 2, { 837, 828 } },
    { 693056, 2, { 833, 832 } },
    { 693084, 2, { 892, 777 } },
    { 693132, 2, { 979, 708 } },
    { 693135, 2, { 1055, 657 } },
    { 693158, 2, { 986, 703 } },
    { 693203, 2, { 2021, 343 } },
    { 693216, 2, { 928, 747 } },
    { 693240, 2, { 872, 795 } },
    { 693264, 2, { 858, 808 } },
    { 693312, 2, { 942, 736 } },
    { 693330, 2, { 955, 726 } },
    { 693360, 2, { 856, 810 } },
    { 693392, 2, { 1057, 656 } },
    { 693396, 2, { 927, 748 } },
    { 693420, 2, { 889, 780 } },
    { 693462, 2, { 869, 798 } },
    { 693504, 2, { 896, 774 } },
    { 693532, 2, { 868, 799 } },
    { 693567, 2, { 909, 763 } },
    { 693576, 2, { 936, 741 } },
    { 693600, 2, { 850, 816 } },
    { 693651, 2, { 1139, 609 } },
    { 693680, 2, { 920, 754 } },
    { 693693, 2, { 847, 819 } },
    { 693744, 2, { 894, 776 } },
    { 693750, 2, { 925, 750 } },
    { 693770, 2, { 901, 770 } },
    { 693792, 2, { 864, 803 } },
    { 693804, 2, { 969, 716 } },
    { 693825, 2, { 841, 825 } },
    { 693840, 2, { 840, 826 } },
    { 693842, 2, { 961, 722 } },
    { 693861, 2, { 893, 777 } },
    { 693875, 2, { 875, 793 } },
    { 693888, 2, { 834, 832 } },
    { 693900, 2, { 900, 771 } },
    { 693935, 2, { 1147, 605 } },
    { 694020, 2, { 860, 807 } },
    { 694025, 2, { 1207, 575 } },
    { 694048, 2, { 943, 736 } },
    { 694080, 2, { 960, 723 } },
    { 694083, 2, { 1369, 507 } },
    { 694089, 2, { 891, 779 } },
    { 694096, 2, { 923, 752 } },
    { 694120, 2, { 938, 740 } },
    { 694152, 2, { 933, 744 } },
    { 694200, 2, { 890, 780 } },
    { 694232, 2, { 1012, 686 } },
    { 694260, 2, { 855, 812 } },
    { 694305, 2, { 999, 695 } },
    { 694320, 2, { 880, 789 } },
    { 694323, 2, { 927, 749 } },
    { 694330, 2, { 910, 763 } },
    { 694375, 2, { 1111, 625 } },
    { 694380, 2, { 852, 815 } },
    { 694400, 2, { 868, 800 } },
    { 694416, 2, { 851, 816 } },
    { 694449, 2, { 1057, 657 } },
    { 694450, 2, { 850, 817 } },
    { 694476, 2, { 909, 764 } },
    { 694512, 2, { 848, 819 } },
    { 694520, 2, { 895, 776 } },
    { 694540, 2, { 847, 820 } },
    { 694548, 2, { 981, 708 } },
    { 694568, 2, { 1099, 632 } },
    { 694575, 2, { 945, 735 } },
    { 694590, 2, { 845, 822 } },
    { 694600, 2, { 920, 755 } },
    { 694620, 2, { 908, 765 } },
    { 694632, 2, { 843, 824 } },
    { 694656, 2, { 864, 804 } },
    { 694710, 2, { 837, 830 } },
    { 694716, 2, { 836, 831 } },
    { 694720, 2, { 835, 832 } },
    { 694848, 2, { 924, 752 } },
    { 694860, 2, { 939, 740 } },
    { 694876, 2, { 1079, 644 } },
    { 694908, 2, { 873, 796 } },
    { 694944, 2, { 912, 762 } },
    { 694950, 2, { 1025, 678 } },
    { 694980, 2, { 858, 810 } },
    { 695000, 2, { 1000, 695 } },
    { 695020, 2, { 1121, 620 } },
    { 695040, 2, { 905, 768 } },
    { 695045, 2, { 1105, 629 } },
    { 695058, 2, { 871, 798 } },
    { 695079, 2, { 1003, 693 } },
    { 695100, 2, { 993, 700 } },
    { 695130, 2, { 870, 799 } },
    { 695200, 2, { 869, 800 } },
    { 695232, 2, { 852, 816 } },
    { 695244, 2, { 916, 759 } },
    { 695266, 2, { 1573, 442 } },
    { 695268, 2, { 868, 801 } },
    { 695275, 2, { 959, 725 } },
    { 695304, 2, { 888, 783 } },
    { 695400, 2, { 915, 760 } },
    { 695457, 2, { 931, 747 } },
    { 695460, 2, { 865, 804 } },
    { 695552, 2, { 836, 832 } },
    { 695568, 2, { 1011, 688 } },
    { 695583, 2, { 1267, 549 } },
    { 695600, 2, { 925, 752 } },
    { 695604, 2, { 1014, 686 } },
    { 695628, 2, { 1017, 684 } },
    { 695688, 2, { 861, 808 } },
    { 695728, 2, { 944, 737 } },
    { 695772, 2, { 924, 753 } },
    { 695808, 2, { 906, 768 } },
    { 695856, 2, { 872, 798 } },
    { 695871, 2, { 891, 781 } },
    { 695912, 2, { 952, 731 } },
    { 695928, 2, { 856, 813 } },
    { 695955, 2, { 1079, 645 } },
    { 695960, 2, { 1016, 685 } },
    { 695970, 2, { 855, 814 } },
    { 695975, 2, { 1025, 679 } },
    { 696000, 2, { 870, 800 } },
    { 696072, 2, { 897, 776 } },
    { 696080, 2, { 880, 791 } },
    { 696087, 2, { 889, 783 } },
    { 696132, 2, { 951, 732 } },
    { 696141, 2, { 1121, 621 } },
    { 696168, 2, { 879, 792 } },
    { 696180, 2, { 849, 820 } },
    { 696195, 2, { 955, 729 } },
    { 696204, 2, { 932, 747 } },
    { 696256, 2, { 946, 736 } },
    { 696276, 2, { 921, 756 } },
    { 696280, 2, { 845, 824 } },
    { 696300, 2, { 844, 825 } },
    { 696303, 2, { 999, 697 } },
    { 696320, 2, { 1024, 680 } },
    { 696336, 2, { 978, 712 } },
    { 696348, 2, { 841, 828 } },
    { 696384, 2, { 837, 832 } },
    { 696388, 2, { 836, 833 } },
    { 696390, 2, { 835, 834 } },
    { 696420, 2, { 876, 795 } },
    { 696465, 2, { 945, 737 } },
    { 696540, 2, { 893, 780 } },
    { 696570, 2, { 930, 749 } },
    { 696600, 2, { 860, 810 } },
    { 696645, 2, { 1017, 685 } },
    { 696672, 2, { 944, 738 } },
    { 696762, 2, { 891, 782 } },
    { 696780, 2, { 882, 790 } },
    { 696787, 2, { 1183, 589 } },
    { 696795, 2, { 1133, 615 } },
    { 696800, 2, { 871, 800 } },
    { 696825, 2, { 855, 815 } },
    { 696864, 2, { 854, 816 } },
    { 696920, 2, { 917, 760 } },
    { 696924, 2, { 956, 729 } },
    { 696969, 2, { 851, 819 } },
    { 696976, 2, { 889, 784 } },
    { 696984, 2, { 904, 771 } },
    { 697004, 2, { 868, 803 } },
    { 697015, 2, { 1045, 667 } },
    { 697056, 2, { 848, 822 } },
    { 697068, 2, { 867, 804 } },
    { 697080, 2, { 888, 785 } },
    { 697104, 2, { 846, 824 } },
    { 697116, 2, { 903, 772 } },
    { 697125, 2, { 845, 825 } },
    { 697200, 2, { 840, 830 } },
    { 697212, 2, { 963, 724 } },
    { 697221, 2, { 837, 833 } },
    { 697248, 2, { 864, 807 } },
    { 697268, 2, { 1012, 689 } },
    { 697374, 2, { 901, 774 } },
    { 697376, 2, { 992, 703 } },
    { 697380, 2, { 885, 788 } },
    { 697392, 2, { 1002, 696 } },
    { 697410, 2, { 861, 810 } },
    { 697452, 2, { 874, 798 } },
    { 697476, 2, { 884, 789 } },
    { 697480, 2, { 940, 742 } },
    { 697500, 2, { 900, 775 } },
    { 697515, 2, { 949, 735 } },
    { 697632, 2, { 1014, 688 } },
    { 697640, 2, { 856, 815 } },
    { 697662, 2, { 882, 791 } },
    { 697675, 2, { 1075, 649 } },
    { 697680, 2, { 855, 816 } },
    { 697686, 2, { 961, 726 } },
    { 697697, 2, { 1001, 697 } },
    { 697728, 2, { 948, 736 } },
    { 697760, 2, { 890, 784 } },
    { 697788, 2, { 852, 819 } },
    { 697840, 2, { 880, 793 } },
    { 697851, 2, { 1007, 693 } },
    { 697884, 2, { 933, 748 } },
    { 697928, 2, { 847, 824 } },
    { 697950, 2, { 846, 825 } },
    { 697968, 2, { 888, 786 } },
    { 697984, 2, { 896, 779 } },
    { 698004, 2, { 843, 828 } },
    { 698040, 2, { 840, 831 } },
    { 698100, 2, { 895, 780 } },
    { 698139, 2, { 1053, 663 } },
    { 698145, 2, { 915, 763 } },
    { 698152, 2, { 959, 728 } },
    { 698175, 2, { 963, 725 } },
    { 698250, 2, { 875, 798 } },
    { 698275, 2, { 901, 775 } },
    { 698280, 2, { 920, 759 } },
    { 698400, 2, { 873, 800 } },
    { 698436, 2, { 892, 783 } },
    { 698445, 2, { 913, 765 } },
    { 698464, 2, { 949, 736 } },
    { 698472, 2, { 872, 801 } },
    { 698490, 2, { 995, 702 } },
    { 698535, 2, { 855, 817 } },
    { 698544, 2, { 882, 792 } },
    { 698610, 2, { 870, 803 } },
    { 698616, 2, { 939, 744 } },
    { 698676, 2, { 869, 804 } },
    { 698763, 2, { 897, 779 } },
    { 698775, 2, { 847, 825 } },
    { 698784, 2, { 928, 753 } },
    { 698796, 2, { 846, 826 } },
    { 698880, 2, { 840, 832 } },
    { 698895, 2, { 837, 835 } },
    { 698920, 2, { 865, 808 } },
    { 699006, 2, { 979, 714 } },
    { 699050, 2, { 902, 775 } },
    { 699060, 2, { 915, 764 } },
    { 699072, 2, { 993, 704 } },
    { 699111, 2, { 959, 729 } },
    { 699125, 2, { 875, 799 } },
    { 699132, 2, { 861, 812 } },
    { 699180, 2, { 860, 813 } },
    { 699192, 2, { 936, 747 } },
    { 699200, 2, { 874, 800 } },
    { 699219, 2, { 893, 783 } },
    { 699270, 2, { 858, 815 } },
    { 699300, 2, { 900, 777 } },
    { 699335, 2, { 1015, 689 } },
    { 699360, 2, { 930, 752 } },
    { 699370, 2, { 970, 721 } },
    { 699435, 2, { 891, 785 } },
    { 699504, 2, { 912, 767 } },
    { 699545, 2, { 869, 805 } },
    { 699567, 2, { 957, 731 } },
    { 699576, 2, { 849, 824 } },
    { 699600, 2, { 848, 825 } },
    { 699612, 2, { 1011, 692 } },
    { 699660, 2, { 845, 828 } },
    { 699684, 2, { 879, 796 } },
    { 699696, 2, { 904, 774 } },
    { 699712, 2, { 841, 832 } },
    { 699720, 2, { 840, 833 } },
    { 699732, 2, { 837, 836 } },
    { 699776, 2, { 896, 781 } },
    { 699825, 2, { 903, 775 } },
    { 699840, 2, { 864, 810 } },
    { 699855, 2, { 1261, 555 } },
    { 699867, 2, { 1127, 621 } },
    { 699885, 2, { 927, 755 } },
    { 699936, 2, { 951, 736 } },
    { 699960, 2, { 921, 760 } },
    { 700000, 2, { 875, 800 } },
    { 700035, 2, { 885, 791 } },
    { 700068, 2, { 908, 771 } },
    { 700070, 2, { 959, 730 } },
    { 700077, 2, { 901, 777 } },
    { 700112, 2, { 893, 784 } },
    { 700128, 2, { 858, 816 } },
    { 700150, 2, { 950, 737 } },
    { 700280, 2, { 854, 820 } },
    { 700335, 2, { 985, 711 } },
    { 700336, 2, { 962, 728 } },
    { 700350, 2, { 870, 805 } },
    { 700362, 2, { 949, 738 } },
    { 700416, 2, { 912, 768 } },
    { 700434, 2, { 918, 763 } },
    { 700448, 2, { 848, 826 } },
    { 700470, 2, { 905, 774 } },
    { 700476, 2, { 868, 807 } },
    { 700524, 2, { 957, 732 } },
    { 700536, 2, { 867, 808 } },
    { 700553, 2, { 841, 833 } },
    { 700560, 2, { 840, 834 } },
    { 700590, 2, { 965, 726 } },
    { 700600, 2, { 904, 775 } },
    { 700625, 2, { 1121, 625 } },
    { 700632, 2, { 888, 789 } },
    { 700640, 2, { 928, 755 } },
    { 700650, 2, { 865, 810 } },
    { 700672, 2, { 896, 782 } },
    { 700728, 2, { 903, 776 } },
    { 700740, 2, { 916, 765 } },
    { 700785, 2, { 895, 783 } },
    { 700800, 2, { 876, 800 } },
    { 700812, 2, { 927, 756 } },
    { 700848, 2, { 942, 744 } },
    { 700872, 2, { 1007, 696 } },
    { 700875, 2, { 875, 801 } },
    { 700896, 2, { 894, 784 } },
    { 700910, 2, { 1054, 665 } },
    { 700920, 2, { 885, 792 } },
    { 700925, 2, { 1219, 575 } },
    { 700986, 2, { 858, 817 } },
    { 701040, 2, { 920, 762 } },
    { 701064, 2, { 856, 819 } },
    { 701100, 2, { 855, 820 } },
    { 701155, 2, { 871, 805 } },
    { 701184, 2, { 913, 768 } },
    { 701190, 2, { 882, 795 } },
    { 701220, 2, { 870, 806 } },
    { 701298, 2, { 962, 729 } },
    { 701316, 2, { 847, 828 } },
    { 701364, 2, { 844, 831 } },
    { 701376, 2, { 843, 832 } },
    { 701400, 2, { 840, 835 } },
    { 701415, 2, { 981, 715 } },
    { 701437, 2, { 1331, 527 } },
    { 701440, 2, { 1024, 685 } },
    { 701480, 2, { 923, 760 } },
    { 701505, 2, { 917, 765 } },
    { 701520, 2, { 888, 790 } },
    { 701556, 2, { 969, 724 } },
    { 701568, 2, { 864, 812 } },
    { 701592, 2, { 943, 744 } },
    { 701616, 2, { 933, 752 } },
    { 701676, 2, { 876, 801 } },
    { 701680, 2, { 895, 784 } },
    { 701748, 2, { 909, 772 } },
    { 701760, 2, { 860, 816 } },
    { 701778, 2, { 1023, 686 } },
    { 701784, 2, { 972, 722 } },
    { 701790, 2, { 894, 785 } },
    { 701796, 2, { 932, 753 } },
    { 701800, 2, { 968, 725 } },
    { 701805, 2, { 885, 793 } },
    { 701848, 2, { 1057, 664 } },
    { 701892, 2, { 873, 804 } },
    { 701960, 2, { 872, 805 } },
    { 701974, 2, { 931, 754 } },
    { 702075, 2, { 851, 825 } },
    { 702100, 2, { 850, 826 } },
    { 702108, 2, { 891, 788 } },
    { 702144, 2, { 848, 828 } },
    { 702150, 2, { 906, 775 } },
    { 702180, 2, { 846, 830 } },
    { 702240, 2, { 840, 836 } },
    { 702260, 2, { 949, 740 } },
    { 702261, 2, { 1099, 639 } },
    { 702270, 2, { 867, 810 } },
    { 702280, 2, { 905, 776 } },
    { 702310, 2, { 889, 790 } },
    { 702372, 2, { 939, 748 } },
    { 702396, 2, { 981, 716 } },
    { 702408, 2, { 888, 791 } },
    { 702429, 2, { 1079, 651 } },
    { 702432, 2, { 864, 813 } },
    { 702468, 2, { 948, 741 } },
    { 702513, 2, { 1239, 567 } },
    { 702576, 2, { 861, 816 } },
    { 702625, 2, { 875, 803 } },
    { 702630, 2, { 1055, 666 } },
    { 702650, 2, { 1081, 650 } },
    { 702660, 2, { 956, 735 } },
    { 702720, 2, { 915, 768 } },
    { 702744, 2, { 987, 712 } },
    { 702756, 2, { 964, 729 } },
    { 702765, 2, { 873, 805 } },
    { 702780, 2, { 884, 795 } },
    { 702848, 2, { 1088, 646 } },
    { 702900, 2, { 852, 825 } },
    { 702945, 2, { 1107, 635 } },
    { 702960, 2, { 870, 808 } },
    { 702972, 2, { 849, 828 } },
    { 702975, 2, { 975, 721 } },
    { 703000, 2, { 925, 760 } },
    { 703010, 2, { 847, 830 } },
    { 703018, 2, { 899, 782 } },
    { 703040, 2, { 845, 832 } },
    { 703044, 2, { 993, 708 } },
    { 703050, 2, { 1075, 654 } },
    { 703056, 2, { 906, 776 } },
    { 703076, 2, { 841, 836 } },
    { 703080, 2, { 840, 837 } },
    { 703098, 2, { 954, 737 } },
    { 703120, 2, { 880, 799 } },
    { 703136, 2, { 1022, 688 } },
    { 703150, 2, { 1025, 686 } },
    { 703152, 2, { 912, 771 } },
    { 703200, 2, { 879, 800 } },
    { 703222, 2, { 962, 731 } },
    { 703248, 2, { 897, 784 } },
    { 703280, 2, { 944, 745 } },
    { 703290, 2, { 985, 714 } },
    { 703296, 2, { 864, 814 } },
    { 703360, 2, { 896, 785 } },
    { 703395, 2, { 957, 735 } },
    { 703437, 2, { 861, 817 } },
    { 703470, 2, { 895, 786 } },
    { 703485, 2, { 965, 729 } },
    { 703494, 2, { 969, 726 } },
    { 703500, 2, { 875, 804 } },
    { 703632, 2, { 856, 822 } },
    { 703644, 2, { 921, 764 } },
    { 703656, 2, { 1011, 696 } },
    { 703703, 2, { 1001, 703 } },
    { 703704, 2, { 872, 807 } },
    { 703740, 2, { 951, 740 } },
    { 703764, 2, { 1017, 692 } },
    { 703788, 2, { 892, 789 } },
    { 703800, 2, { 850, 828 } },
    { 703824, 2, { 946, 744 } },
    { 703840, 2, { 848, 830 } },
    { 703872, 2, { 846, 832 } },
    { 703890, 2, { 869, 810 } },
    { 703990, 2, { 890, 791 } },
    { 704004, 2, { 867, 812 } },
    { 704025, 2, { 945, 745 } },
    { 704060, 2, { 940, 749 } },
    { 704088, 2, { 889, 792 } },
    { 704099, 2, { 1331, 529 } },
    { 704106, 2, { 918, 767 } },
    { 704158, 2, { 949, 742 } },
    { 704160, 2, { 864, 815 } },
    { 704165, 2, { 1085, 649 } },
    { 704172, 2, { 996, 707 } },
    { 704184, 2, { 888, 793 } },
    { 704214, 2, { 966, 729 } },
    { 704256, 2, { 896, 786 } },
    { 704295, 2, { 999, 705 } },
    { 704320, 2, { 992, 710 } },
    { 704340, 2, { 860, 819 } },
    { 704352, 2, { 928, 759 } },
    { 704375, 2, { 875, 805 } },
    { 704460, 2, { 885, 796 } },
    { 704475, 2, { 909, 775 } },
    { 704520, 2, { 855, 824 } },
    { 704522, 2, { 1027, 686 } },
    { 704550, 2, { 854, 825 } },
    { 704628, 2, { 851, 828 } },
    { 704688, 2, { 848, 831 } },
    { 704700, 2, { 870, 810 } },
    { 704704, 2, { 847, 832 } },
    { 704718, 2, { 846, 833 } },
    { 704730, 2, { 845, 834 } },
    { 704748, 2, { 843, 836 } },
    { 704781, 2, { 891, 791 } },
    { 704790, 2, { 955, 738 } },
    { 704808, 2, { 936, 753 } },
    { 704847, 2, { 1023, 689 } },
    { 704850, 2, { 925, 762 } },
    { 704865, 2, { 959, 735 } },
    { 704880, 2, { 880, 801 } },
    { 704900, 2, { 950, 742 } },
    { 704907, 2, { 1169, 603 } },
    { 704916, 2, { 963, 732 } },
    { 704990, 2, { 935, 754 } },
    { 705012, 2, { 924, 763 } },
    { 705160, 2, { 1037, 680 } },
    { 705168, 2, { 944, 747 } },
    { 705180, 2, { 876, 805 } },
    { 705243, 2, { 903, 781 } },
    { 705250, 2, { 875, 806 } },
    { 705348, 2, { 933, 756 } },
    { 705376, 2, { 938, 752 } },
    { 705384, 2, { 873, 808 } },
    { 705408, 2, { 1002, 704 } },
    { 705425, 2, { 973, 725 } },
    { 705483, 2, { 901, 783 } },
    { 705510, 2, { 871, 810 } },
    { 705516, 2, { 908, 777 } },
    { 705628, 2, { 869, 812 } },
    { 705640, 2, { 920, 767 } },
    { 705672, 2, { 891, 792 } },
    { 705684, 2, { 868, 813 } },
    { 705744, 2, { 936, 754 } },
    { 705755, 2, { 1615, 437 } },
    { 705775, 2, { 925, 763 } },
    { 705824, 2, { 959, 736 } },
    { 705831, 2, { 1159, 609 } },
    { 705840, 2, { 865, 816 } },
    { 705888, 2, { 864, 817 } },
    { 705900, 2, { 905, 780 } },
    { 705960, 2, { 888, 795 } },
    { 706020, 2, { 861, 820 } },
    { 706090, 2, { 917, 770 } },
    { 706095, 2, { 923, 765 } },
    { 706120, 2, { 1016, 695 } },
    { 706128, 2, { 939, 752 } },
    { 706200, 2, { 856, 825 } },
    { 706225, 2, { 1025, 689 } },
    { 706230, 2, { 855, 826 } },
    { 706236, 2, { 916, 771 } },
    { 706266, 2, { 902, 783 } },
    { 706275, 2, { 1075, 657 } },
    { 706316, 2, { 884, 799 } },
    { 706320, 2, { 872, 810 } },
    { 706335, 2, { 961, 735 } },
    { 706368, 2, { 849, 832 } },
    { 706380, 2, { 915, 772 } },
    { 706384, 2, { 848, 833 } },
    { 706401, 2, { 969, 729 } },
    { 706410, 2, { 846, 835 } },
    { 706428, 2, { 844, 837 } },
    { 706440, 2, { 841, 840 } },
    { 706500, 2, { 900, 785 } },
    { 706552, 2, { 868, 814 } },
    { 706560, 2, { 920, 768 } },
    { 706563, 2, { 891, 793 } },
    { 706576, 2, { 1027, 688 } },
    { 706580, 2, { 980, 721 } },
    { 706596, 2, { 1111, 636 } },
    { 706629, 2, { 931, 759 } },
    { 706640, 2, { 880, 803 } },
    { 706662, 2, { 913, 774 } },
    { 706692, 2, { 987, 716 } },
    { 706716, 2, { 879, 804 } },
    { 706755, 2, { 889, 795 } },
    { 706758, 2, { 1014, 697 } },
    { 706800, 2, { 912, 775 } },
    { 706815, 2, { 1017, 695 } },
    { 706836, 2, { 897, 788 } },
    { 706860, 2, { 918, 770 } },
    { 706932, 2, { 876, 807 } },
    { 706944, 2, { 896, 789 } },
    { 706992, 2, { 858, 824 } },
    { 707000, 2, { 875, 808 } },
    { 707016, 2, { 993, 712 } },
    { 707049, 2, { 903, 783 } },
    { 707112, 2, { 854, 828 } },
    { 707135, 2, { 989, 715 } },
    { 707136, 2, { 928, 762 } },
    { 707160, 2, { 852, 830 } },
    { 707168, 2, { 902, 784 } },
    { 707200, 2, { 850, 832 } },
    { 707232, 2, { 848, 834 } },
    { 707234, 2, { 1037, 682 } },
    { 707250, 2, { 943, 750 } },
    { 707252, 2, { 871, 812 } },
    { 707265, 2, { 845, 837 } },
    { 707292, 2, { 999, 708 } },
    { 707296, 2, { 961, 736 } },
    { 707301, 2, { 927, 763 } },
    { 707319, 2, { 1139, 621 } },
    { 707328, 2, { 921, 768 } },
    { 707350, 2, { 1075, 658 } },
    { 707388, 2, { 932, 759 } },
    { 707445, 2, { 995, 711 } },
    { 707455, 2, { 1015, 697 } },
    { 707472, 2, { 867, 816 } },
    { 707520, 2, { 880, 804 } },
    { 707544, 2, { 951, 744 } },
    { 707560, 2, { 931, 760 } },
    { 707575, 2, { 913, 775 } },
    { 707600, 2, { 976, 725 } },
    { 707616, 2, { 864, 819 } },
    { 707625, 2, { 925, 765 } },
    { 707700, 2, { 1011, 700 } },
    { 707805, 2, { 945, 749 } },
    { 707820, 2, { 940, 753 } },
    { 707832, 2, { 904, 783 } },
    { 707840, 2, { 896, 790 } },
    { 707850, 2, { 858, 825 } },
    { 707916, 2, { 1023, 692 } },
    { 707940, 2, { 855, 828 } },
    { 707952, 2, { 903, 784 } },
    { 708000, 2, { 885, 800 } },
    { 708012, 2, { 852, 831 } },
    { 708032, 2, { 851, 832 } },
    { 708048, 2, { 894, 792 } },
    { 708050, 2, { 850, 833 } },
    { 708080, 2, { 848, 835 } },
    { 708084, 2, { 884, 801 } },
    { 708120, 2, { 843, 840 } },
    { 708125, 2, { 1133, 625 } },
    { 708156, 2, { 948, 747 } },
    { 708180, 2, { 870, 814 } },
    { 708210, 2, { 915, 774 } },
    { 708228, 2, { 927, 764 } },
    { 708246, 2, { 882, 803 } },
    { 708288, 2, { 868, 816 } },
    { 708339, 2, { 867, 817 } },
    { 708344, 2, { 973, 728 } },
    { 708345, 2, { 891, 795 } },
    { 708384, 2, { 942, 752 } },
    { 708396, 2, { 956, 741 } },
    { 708400, 2, { 880, 805 } },
    { 708435, 2, { 865, 819 } },
    { 708480, 2, { 864, 820 } },
    { 708510, 2, { 1045, 678 } },
    { 708540, 2, { 964, 735 } },
    { 708561, 2, { 1141, 621 } },
    { 708615, 2, { 905, 783 } },
    { 708624, 2, { 888, 798 } },
    { 708736, 2, { 896, 791 } },
    { 708750, 2, { 875, 810 } },
    { 708840, 2, { 895, 792 } },
    { 708864, 2, { 852, 832 } },
    { 708876, 2, { 873, 812 } },
    { 708883, 2, { 851, 833 } },
    { 708890, 2, { 910, 779 } },
    { 708936, 2, { 872, 813 } },
    { 708939, 2, { 847, 837 } },
    { 708975, 2, { 1035, 685 } },
    { 708981, 2, { 1029, 689 } },
    { 708994, 2, { 871, 814 } },
    { 709020, 2, { 909, 780 } },
    { 709050, 2, { 870, 815 } },
    { 709080, 2, { 933, 760 } },
    { 709104, 2, { 869, 816 } },
    { 709140, 2, { 892, 795 } },
    { 709156, 2, { 868, 817 } },
    { 709236, 2, { 891, 796 } },
    { 709240, 2, { 952, 745 } },
    { 709280, 2, { 880, 806 } },
    { 709290, 2, { 999, 710 } },
    { 709308, 2, { 969, 732 } },
    { 709317, 2, { 973, 729 } },
    { 709320, 2, { 920, 771 } },
    { 709324, 2, { 1034, 686 } },
    { 709371, 2, { 1161, 611 } },
    { 709401, 2, { 913, 777 } },
    { 709423, 2, { 1331, 533 } },
    { 709464, 2, { 861, 824 } },
    { 709475, 2, { 925, 767 } },
    { 709500, 2, { 860, 825 } },
    { 709512, 2, { 888, 799 } },
    { 709520, 2, { 905, 784 } },
    { 709590, 2, { 930, 763 } },
    { 709631, 2, { 2197, 323 } },
    { 709632, 2, { 896, 792 } },
    { 709640, 2, { 904, 785 } },
    { 709660, 2, { 959, 740 } },
    { 709716, 2, { 852, 833 } },
    { 709764, 2, { 849, 836 } },
    { 709775, 2, { 979, 725 } },
    { 709776, 2, { 848, 837 } },
    { 709800, 2, { 845, 840 } },
    { 709884, 2, { 939, 756 } },
    { 709920, 2, { 870, 816 } },
    { 709982, 2, { 1079, 658 } },
    { 710010, 2, { 882, 805 } },
    { 710040, 2, { 915, 776 } },
    { 710052, 2, { 948, 749 } },
    { 710073, 2, { 867, 819 } },
    { 710100, 2, { 900, 789 } },
    { 710160, 2, { 880, 807 } },
    { 710208, 2, { 864, 822 } },
    { 710232, 2, { 879, 808 } },
    { 710244, 2, { 981, 724 } },
    { 710290, 2, { 973, 730 } },
    { 710304, 2, { 906, 784 } },
    { 710325, 2, { 861, 825 } },
    { 710360, 2, { 860, 826 } },
    { 710400, 2, { 888, 800 } },
    { 710430, 2, { 995, 714 } },
    { 710448, 2, { 912, 779 } },
    { 710451, 2, { 1253, 567 } },
    { 710500, 2, { 875, 812 } },
    { 710528, 2, { 854, 832 } },
    { 710535, 2, { 1005, 707 } },
    { 710544, 2, { 904, 786 } },
    { 710600, 2, { 850, 836 } },
    { 710640, 2, { 846, 840 } },
    { 710645, 2, { 845, 841 } },
    { 710655, 2, { 885, 803 } },
    { 710675, 2, { 917, 775 } },
    { 710680, 2, { 872, 815 } },
    { 710710, 2, { 910, 781 } },
    { 710736, 2, { 871, 816 } },
    { 710775, 2, { 975, 729 } },
    { 710790, 2, { 870, 817 } },
    { 710832, 2, { 944, 753 } },
    { 710892, 2, { 868, 819 } },
    { 710940, 2, { 867, 820 } },
    { 710964, 2, { 908, 783 } },
    { 710976, 2, { 966, 736 } },
    { 710988, 2, { 993, 716 } },
    { 711000, 2, { 900, 790 } },
    { 711012, 2, { 921, 772 } },
    { 711018, 2, { 891, 798 } },
    { 711022, 2, { 943, 754 } },
    { 711030, 2, { 865, 822 } },
    { 711048, 2, { 1032, 689 } },
    { 711144, 2, { 952, 747 } },
    { 711200, 2, { 889, 800 } },
    { 711210, 2, { 906, 785 } },
    { 711225, 2, { 981, 725 } },
    { 711260, 2, { 1060, 671 } },
    { 711288, 2, { 888, 801 } },
    { 711330, 2, { 905, 786 } },
    { 711336, 2, { 856, 831 } },
    { 711348, 2, { 951, 748 } },
    { 711360, 2, { 855, 832 } },
    { 711399, 2, { 1073, 663 } },
    { 711420, 2, { 852, 835 } },
    { 711436, 2, { 851, 836 } },
    { 711450, 2, { 850, 837 } },
    { 711480, 2, { 847, 840 } },
    { 711492, 2, { 844, 843 } },
    { 711495, 2, { 873, 815 } },
    { 711540, 2, { 885, 804 } },
    { 711550, 2, { 950, 749 } },
    { 711555, 2, { 1157, 615 } },
    { 711564, 2, { 903, 788 } },
    { 711592, 2, { 917, 776 } },
    { 711680, 2, { 1024, 695 } },
    { 711711, 2, { 869, 819 } },
    { 711725, 2, { 1225, 581 } },
    { 711732, 2, { 916, 777 } },
    { 711744, 2, { 1011, 704 } },
    { 711750, 2, { 949, 750 } },
    { 711776, 2, { 928, 767 } },
    { 711875, 2, { 1139, 625 } },
    { 711900, 2, { 900, 791 } },
    { 711909, 2, { 891, 799 } },
    { 711984, 2, { 978, 728 } },
    { 712000, 2, { 890, 800 } },
    { 712008, 2, { 899, 792 } },
    { 712068, 2, { 1029, 692 } },
    { 712080, 2, { 860, 828 } },
    { 712089, 2, { 889, 801 } },
    { 712101, 2, { 961, 741 } },
    { 712125, 2, { 1055, 675 } },
    { 712166, 2, { 1118, 637 } },
    { 712170, 2, { 965, 738 } },
    { 712188, 2, { 876, 813 } },
    { 712215, 2, { 855, 833 } },
    { 712250, 2, { 875, 814 } },
    { 712287, 2, { 851, 837 } },
    { 712327, 2, { 847, 841 } },
    { 712368, 2, { 873, 816 } },
    { 712400, 2, { 1040, 685 } },
    { 712404, 2, { 924, 771 } },
    { 712426, 2, { 1034, 689 } },
    { 712470, 2, { 935, 762 } },
    { 712480, 2, { 976, 730 } },
    { 712580, 2, { 869, 820 } },
    { 712602, 2, { 1062, 671 } },
    { 712614, 2, { 893, 798 } },
    { 712620, 2, { 963, 740 } },
    { 712656, 2, { 882, 808 } },
    { 712712, 2, { 979, 728 } },
    { 712720, 2, { 944, 755 } },
    { 712725, 2, { 975, 731 } },
    { 712760, 2, { 865, 824 } },
    { 712800, 2, { 864, 825 } },
    { 712812, 2, { 933, 764 } },
    { 712845, 2, { 1085, 657 } },
    { 712880, 2, { 938, 760 } },
    { 712896, 2, { 948, 752 } },
    { 712908, 2, { 861, 828 } },
    { 712975, 2, { 1501, 475 } },
    { 712980, 2, { 932, 765 } },
    { 713000, 2, { 920, 775 } },
    { 713031, 2, { 1023, 697 } },
    { 713048, 2, { 856, 833 } },
    { 713124, 2, { 852, 837 } },
    { 713160, 2, { 849, 840 } },
    { 713184, 2, { 874, 816 } },
    { 713232, 2, { 936, 762 } },
    { 713256, 2, { 904, 789 } },
    { 713286, 2, { 918, 777 } },
    { 713295, 2, { 1089, 655 } },
    { 713349, 2, { 871, 819 } },
    { 713385, 2, { 955, 747 } },
    { 713388, 2, { 884, 807 } },
    { 713424, 2, { 1002, 712 } },
    { 713440, 2, { 910, 784 } },
    { 713460, 2, { 940, 759 } },
    { 713475, 2, { 945, 755 } },
    { 713545, 2, { 1015, 703 } },
    { 713565, 2, { 909, 785 } },
    { 713575, 2, { 1241, 575 } },
    { 713592, 2, { 901, 792 } },
    { 713640, 2, { 939, 760 } },
    { 713648, 2, { 949, 752 } },
    { 713664, 2, { 864, 826 } },
    { 713700, 2, { 900, 793 } },
    { 713713, 2, { 1001, 713 } },
    { 713728, 2, { 1024, 697 } },
    { 713748, 2, { 879, 812 } },
    { 713830, 2, { 1105, 646 } },
    { 713844, 2, { 948, 753 } },
    { 713856, 2, { 858, 832 } },
    { 713900, 2, { 1100, 649 } },
    { 713904, 2, { 856, 834 } },
    { 713925, 2, { 855, 835 } },
    { 713940, 2, { 876, 815 } },
    { 714000, 2, { 850, 840 } },
    { 714012, 2, { 897, 796 } },
    { 714015, 2, { 1107, 645 } },
    { 714077, 2, { 931, 767 } },
    { 714096, 2, { 912, 783 } },
    { 714132, 2, { 956, 747 } },
    { 714168, 2, { 872, 819 } },
    { 714175, 2, { 1225, 583 } },
    { 714210, 2, { 895, 798 } },
    { 714220, 2, { 871, 820 } },
    { 714240, 2, { 930, 768 } },
    { 714285, 2, { 999, 715 } },
    { 714324, 2, { 964, 741 } },
    { 714357, 2, { 1071, 667 } },
    { 714375, 2, { 1125, 635 } },
    { 714384, 2, { 902, 792 } },
    { 714400, 2, { 893, 800 } },
    { 714402, 2, { 923, 774 } },
    { 714408, 2, { 867, 824 } },
    { 714420, 2, { 882, 810 } },
    { 714492, 2, { 892, 801 } },
    { 714546, 2, { 954, 749 } },
    { 714560, 2, { 880, 812 } },
    { 714588, 2, { 987, 724 } },
    { 714615, 2, { 915, 781 } },
    { 714660, 2, { 860, 831 } },
    { 714696, 2, { 921, 776 } },
    { 714725, 2, { 1243, 575 } },
    { 714756, 2, { 889, 804 } },
    { 714760, 2, { 856, 835 } },
    { 714780, 2, { 855, 836 } },
    { 714798, 2, { 854, 837 } },
    { 714816, 2, { 876, 816 } },
    { 714840, 2, { 851, 840 } },
    { 714850, 2, { 850, 841 } },
    { 714864, 2, { 848, 843 } },
    { 714870, 2, { 846, 845 } },
    { 714875, 2, { 875, 817 } },
    { 714879, 2, { 913, 783 } },
    { 714960, 2, { 993, 720 } },
    { 715000, 2, { 1000, 715 } },
    { 715008, 2, { 896, 798 } },
    { 715080, 2, { 885, 808 } },
    { 715110, 2, { 985, 726 } },
    { 715122, 2, { 918, 779 } },
    { 715152, 2, { 951, 752 } },
    { 715155, 2, { 973, 735 } },
    { 715176, 2, { 903, 792 } },
    { 715200, 2, { 894, 800 } },
    { 715208, 2, { 1058, 676 } },
    { 715225, 2, { 1525, 469 } },
    { 715275, 2, { 867, 825 } },
    { 715284, 2, { 999, 716 } },
    { 715286, 2, { 902, 793 } },
    { 715290, 2, { 1055, 678 } },
    { 715325, 2, { 923, 775 } },
    { 715392, 2, { 864, 828 } },
    { 715440, 2, { 880, 813 } },
    { 715473, 2, { 891, 803 } },
    { 715488, 2, { 928, 771 } },
    { 715500, 2, { 900, 795 } },
    { 715520, 2, { 860, 832 } },
    { 715560, 2, { 890, 804 } },
    { 715575, 2, { 987, 725 } },
    { 715644, 2, { 927, 772 } },
    { 715715, 2, { 847, 845 } },
    { 715737, 2, { 943, 759 } },
    { 715788, 2, { 1011, 708 } },
    { 715792, 2, { 913, 784 } },
    { 715806, 2, { 874, 819 } },
    { 715836, 2, { 957, 748 } },
    { 715860, 2, { 873, 820 } },
    { 715904, 2, { 896, 799 } },
    { 715920, 2, { 912, 785 } },
    { 715950, 2, { 925, 774 } },
    { 716000, 2, { 895, 800 } },
    { 716040, 2, { 884, 810 } },
    { 716079, 2, { 903, 793 } },
    { 716100, 2, { 868, 825 } },
    { 716128, 2, { 973, 736 } },
    { 716220, 2, { 865, 828 } },
    { 716250, 2, { 955, 750 } },
    { 716292, 2, { 909, 788 } },
    { 716300, 2, { 950, 754 } },
    { 716320, 2, { 880, 814 } },
    { 716352, 2, { 861, 832 } },
    { 716364, 2, { 891, 804 } },
    { 716373, 2, { 959, 747 } },
    { 716380, 2, { 860, 833 } },
    { 716412, 2, { 908, 789 } },
    { 716430, 2, { 858, 835 } },
    { 716445, 2, { 915, 783 } },
    { 716472, 2, { 856, 837 } },
    { 716496, 2, { 944, 759 } },
    { 716544, 2, { 933, 768 } },
    { 716556, 2, { 849, 844 } },
    { 716560, 2, { 848, 845 } },
    { 716562, 2, { 847, 846 } },
    { 716595, 2, { 1111, 645 } },
    { 716616, 2, { 888, 807 } },
    { 716625, 2, { 875, 819 } },
    { 716628, 2, { 979, 732 } },
    { 716703, 2, { 897, 799 } },
    { 716720, 2, { 1054, 680 } },
    { 716760, 2, { 905, 792 } },
    { 716784, 2, { 872, 822 } },
    { 716832, 2, { 912, 786 } },
    { 716850, 2, { 885, 810 } },
    { 716856, 2, { 952, 753 } },
    { 716870, 2, { 931, 770 } },
    { 716880, 2, { 870, 824 } },
    { 716895, 2, { 895, 801 } },
    { 716925, 2, { 869, 825 } },
    { 716958, 2, { 918, 781 } },
    { 717025, 2, { 989, 725 } },
    { 717060, 2, { 969, 740 } },
    { 717120, 2, { 864, 830 } },
    { 717145, 2, { 935, 767 } },
    { 717171, 2, { 923, 777 } },
    { 717200, 2, { 880, 815 } },
    { 717220, 2, { 940, 763 } },
    { 717228, 2, { 916, 783 } },
    { 717255, 2, { 891, 805 } },
    { 717264, 2, { 879, 816 } },
    { 717360, 2, { 854, 840 } },
    { 717396, 2, { 939, 764 } },
    { 717402, 2, { 899, 798 } },
    { 717408, 2, { 848, 846 } },
    { 717435, 2, { 963, 745 } },
    { 717444, 2, { 876, 819 } },
    { 717535, 2, { 1079, 665 } },
    { 717552, 2, { 906, 792 } },
    { 717570, 2, { 938, 765 } },
    { 717584, 2, { 1043, 688 } },
    { 717600, 2, { 897, 800 } },
    { 717696, 2, { 896, 801 } },
    { 717794, 2, { 869, 826 } },
    { 717800, 2, { 925, 776 } },
    { 717876, 2, { 867, 828 } },
    { 717880, 2, { 1048, 685 } },
    { 717912, 2, { 936, 767 } },
    { 717948, 2, { 882, 814 } },
    { 717984, 2, { 864, 831 } },
    { 718011, 2, { 917, 783 } },
    { 718065, 2, { 985, 729 } },
    { 718092, 2, { 981, 732 } },
    { 718116, 2, { 996, 721 } },
    { 718165, 2, { 1207, 595 } },
    { 718200, 2, { 855, 840 } },
    { 718236, 2, { 852, 843 } },
    { 718256, 2, { 848, 847 } },
    { 718272, 2, { 928, 774 } },
    { 718312, 2, { 889, 808 } },
    { 718380, 2, { 921, 780 } },
    { 718389, 2, { 1267, 567 } },
    { 718425, 2, { 927, 775 } },
    { 718443, 2, { 1107, 649 } },
    { 718487, 2, { 1333, 539 } },
    { 718520, 2, { 920, 781 } },
    { 718536, 2, { 987, 728 } },
    { 718572, 2, { 932, 771 } },
    { 718575, 2, { 871, 825 } },
    { 718580, 2, { 1159, 620 } },
    { 718620, 2, { 870, 826 } },
    { 718641, 2, { 1037, 693 } },
    { 718675, 2, { 1513, 475 } },
    { 718680, 2, { 904, 795 } },
    { 718692, 2, { 884, 813 } },
    { 718704, 2, { 868, 828 } },
    { 718760, 2, { 952, 755 } },
    { 718788, 2, { 903, 796 } },
    { 718828, 2, { 961, 748 } },
    { 718830, 2, { 882, 815 } },
    { 718865, 2, { 893, 805 } },
    { 718875, 2, { 1065, 675 } },
    { 718928, 2, { 917, 784 } },
    { 718932, 2, { 993, 724 } },
    { 718956, 2, { 951, 756 } },
    { 718998, 2, { 901, 798 } },
    { 719019, 2, { 909, 791 } },
    { 719026, 2, { 1078, 667 } },
    { 719055, 2, { 855, 841 } },
    { 719095, 2, { 851, 845 } },
    { 719100, 2, { 850, 846 } },
    { 719169, 2, { 1023, 703 } },
    { 719200, 2, { 899, 800 } },
    { 719250, 2, { 875, 822 } },
    { 719264, 2, { 988, 728 } },
    { 719280, 2, { 888, 810 } },
    { 719304, 2, { 984, 731 } },
    { 719312, 2, { 976, 737 } },
    { 719325, 2, { 1035, 695 } },
    { 719328, 2, { 944, 762 } },
    { 719345, 2, { 1189, 605 } },
    { 719352, 2, { 873, 824 } },
    { 719400, 2, { 872, 825 } },
    { 719433, 2, { 1287, 559 } },
    { 719446, 2, { 871, 826 } },
    { 719488, 2, { 896, 803 } },
    { 719523, 2, { 987, 729 } },
    { 719532, 2, { 869, 828 } },
    { 719550, 2, { 975, 738 } },
    { 719565, 2, { 979, 735 } },
    { 719568, 2, { 912, 789 } },
    { 719580, 2, { 895, 804 } },
    { 719664, 2, { 957, 752 } },
    { 719670, 2, { 894, 805 } },
    { 719680, 2, { 865, 832 } },
    { 719712, 2, { 864, 833 } },
    { 719739, 2, { 1159, 621 } },
    { 719758, 2, { 893, 806 } },
    { 719796, 2, { 861, 836 } },
    { 719808, 2, { 978, 736 } },
    { 719810, 2, { 910, 791 } },
    { 719820, 2, { 860, 837 } },
    { 719832, 2, { 1011, 712 } },
    { 719844, 2, { 892, 807 } },
    { 719868, 2, { 956, 753 } },
    { 719872, 2, { 1024, 703 } },
    { 719928, 2, { 891, 808 } },
    { 719940, 2, { 852, 845 } },
    { 719950, 2, { 850, 847 } },
    { 719952, 2, { 849, 848 } },
    { 719992, 2, { 989, 728 } },
    { 720000, 2, { 900, 800 } },
    { 720005, 2, { 1007, 715 } },
    { 720020, 2, { 973, 740 } },
    { 720036, 2, { 1017, 708 } },
    { 720090, 2, { 889, 810 } },
    { 720108, 2, { 964, 747 } },
    { 720153, 2, { 1127, 639 } },
    { 720252, 2, { 972, 741 } },
    { 720276, 2, { 933, 772 } },
    { 720288, 2, { 976, 738 } },
    { 720324, 2, { 963, 748 } },
    { 720360, 2, { 870, 828 } },
    { 720384, 2, { 896, 804 } },
    { 720447, 2, { 1131, 637 } },
    { 720480, 2, { 912, 790 } },
    { 720544, 2, { 979, 736 } },
    { 720575, 2, { 925, 779 } },
    { 720576, 2, { 864, 834 } },
    { 720588, 2, { 1133, 636 } },
    { 720594, 2, { 882, 817 } },
    { 720630, 2, { 918, 785 } },
    { 720650, 2, { 994, 725 } },
    { 720657, 2, { 861, 837 } },
    { 720698, 2, { 902, 799 } },
    { 720720, 2, { 858, 840 } },
    { 720780, 2, { 879, 820 } },
    { 720797, 2, { 851, 847 } },
    { 720800, 2, { 850, 848 } },
    { 720855, 2, { 965, 747 } },
    { 720900, 2, { 890, 810 } },
    { 720936, 2, { 969, 744 } },
    { 720944, 2, { 1099, 656 } },
    { 720980, 2, { 940, 767 } },
    { 720981, 2, { 989, 729 } },
    { 721000, 2, { 875, 824 } },
    { 721020, 2, { 915, 788 } },
    { 721035, 2, { 945, 763 } },
    { 721050, 2, { 874, 825 } },
    { 721152, 2, { 939, 768 } },
    { 721160, 2, { 968, 745 } },
    { 721168, 2, { 959, 752 } },
    { 721188, 2, { 871, 828 } },
    { 721240, 2, { 949, 760 } },
    { 721259, 2, { 1309, 551 } },
    { 721280, 2, { 896, 805 } },
    { 721305, 2, { 1053, 685 } },
    { 721308, 2, { 868, 831 } },
    { 721325, 2, { 1075, 671 } },
    { 721344, 2, { 867, 832 } },
    { 721392, 2, { 904, 798 } },
    { 721395, 2, { 943, 765 } },
    { 721410, 2, { 865, 834 } },
    { 721440, 2, { 864, 835 } },
    { 721497, 2, { 903, 799 } },
    { 721500, 2, { 925, 780 } },
    { 721525, 2, { 931, 775 } },
    { 721556, 2, { 1012, 713 } },
    { 721578, 2, { 858, 841 } },
    { 721608, 2, { 856, 843 } },
    { 721620, 2, { 855, 844 } },
    { 721644, 2, { 852, 847 } },
    { 721656, 2, { 936, 771 } },
    { 721665, 2, { 1015, 711 } },
    { 721680, 2, { 930, 776 } },
    { 721860, 2, { 908, 795 } },
    { 721920, 2, { 940, 768 } },
    { 721944, 2, { 888, 813 } },
    { 721968, 2, { 1014, 712 } },
    { 721980, 2, { 945, 764 } },
    { 722007, 2, { 1089, 663 } },
    { 722043, 2, { 1099, 657 } },
    { 722064, 2, { 921, 784 } },
    { 722092, 2, { 1036, 697 } },
    { 722160, 2, { 885, 816 } },
    { 722176, 2, { 868, 832 } },
    { 722190, 2, { 905, 798 } },
    { 722200, 2, { 920, 785 } },
    { 722228, 2, { 884, 817 } },
    { 722304, 2, { 864, 836 } },
    { 722337, 2, { 1113, 649 } },
    { 722352, 2, { 894, 808 } },
    { 722361, 2, { 1083, 667 } },
    { 722370, 2, { 995, 726 } },
    { 722400, 2, { 860, 840 } },
    { 722425, 2, { 925, 781 } },
    { 722448, 2, { 1038, 696 } },
    { 722456, 2, { 931, 776 } },
    { 722475, 2, { 855, 845 } },
    { 722484, 2, { 854, 846 } },
    { 722496, 2, { 852, 848 } },
    { 722568, 2, { 924, 782 } },
    { 722610, 2, { 930, 777 } },
    { 722700, 2, { 876, 825 } },
    { 722709, 2, { 923, 783 } },
    { 722722, 2, { 1001, 722 } },
    { 722724, 2, { 916, 789 } },
    { 722750, 2, { 875, 826 } },
    { 722760, 2, { 951, 760 } },
    { 722799, 2, { 1043, 693 } },
    { 722800, 2, { 1040, 695 } },
    { 722844, 2, { 873, 828 } },
    { 722880, 2, { 960, 753 } },
    { 722904, 2, { 993, 728 } },
    { 722912, 2, { 928, 779 } },
    { 723008, 2, { 869, 832 } },
    { 723060, 2, { 927, 780 } },
    { 723072, 2, { 896, 807 } },
    { 723096, 2, { 913, 792 } },
    { 723120, 2, { 920, 786 } },
    { 723125, 2, { 1157, 625 } },
    { 723135, 2, { 1065, 679 } },
    { 723160, 2, { 895, 808 } },
    { 723168, 2, { 864, 837 } },
    { 723216, 2, { 912, 793 } },
    { 723240, 2, { 861, 840 } },
    { 723276, 2, { 999, 724 } },
    { 723320, 2, { 856, 845 } },
    { 723324, 2, { 948, 763 } },
    { 723348, 2, { 852, 849 } },
    { 723350, 2, { 851, 850 } },
    { 723360, 2, { 880, 822 } },
    { 723456, 2, { 942, 768 } },
    { 723492, 2, { 891, 812 } },
    { 723564, 2, { 909, 796 } },
    { 723632, 2, { 923, 784 } },
    { 723690, 2, { 935, 774 } },
    { 723695, 2, { 899, 805 } },
    { 723720, 2, { 888, 815 } },
    { 723750, 2, { 965, 750 } },
    { 723765, 2, { 915, 791 } },
    { 723840, 2, { 870, 832 } },
    { 723855, 2, { 1177, 615 } },
    { 723876, 2, { 1011, 716 } },
    { 723877, 2, { 869, 833 } },
    { 723905, 2, { 1295, 559 } },
    { 723996, 2, { 884, 819 } },
    { 724000, 2, { 905, 800 } },
    { 724005, 2, { 865, 837 } },
    { 724008, 2, { 933, 776 } },
    { 724035, 2, { 1027, 705 } },
    { 724104, 2, { 904, 801 } },
    { 724160, 2, { 992, 730 } },
    { 724164, 2, { 932, 777 } },
    { 724176, 2, { 856, 846 } },
    { 724185, 2, { 855, 847 } },
    { 724192, 2, { 854, 848 } },
    { 724200, 2, { 852, 850 } },
    { 724224, 2, { 943, 768 } },
    { 724275, 2, { 925, 783 } },
    { 724284, 2, { 1023, 708 } },
    { 724296, 2, { 879, 824 } },
    { 724375, 2, { 1159, 625 } },
    { 724416, 2, { 924, 784 } },
    { 724430, 2, { 917, 790 } },
    { 724464, 2, { 936, 774 } },
    { 724470, 2, { 930, 779 } },
    { 724500, 2, { 875, 828 } },
    { 724536, 2, { 1041, 696 } },
    { 724605, 2, { 1005, 721 } },
    { 724626, 2, { 994, 729 } },
    { 724632, 2, { 872, 831 } },
    { 724672, 2, { 871, 832 } },
    { 724675, 2, { 1025, 707 } },
    { 724680, 2, { 915, 792 } },
    { 724710, 2, { 870, 833 } },
    { 724740, 2, { 940, 771 } },
    { 724768, 2, { 928, 781 } },
    { 724776, 2, { 897, 808 } },
    { 724800, 2, { 906, 800 } },
    { 724812, 2, { 867, 836 } },
    { 724850, 2, { 950, 763 } },
    { 724905, 2, { 905, 801 } },
    { 724908, 2, { 939, 772 } },
    { 724950, 2, { 895, 810 } },
    { 724980, 2, { 860, 843 } },
    { 725000, 2, { 1000, 725 } },
    { 725010, 2, { 858, 845 } },
    { 725032, 2, { 856, 847 } },
    { 725040, 2, { 855, 848 } },
    { 725075, 2, { 1261, 575 } },
    { 725085, 2, { 1107, 655 } },
    { 725109, 2, { 903, 803 } },
    { 725116, 2, { 893, 812 } },
    { 725152, 2, { 992, 731 } },
    { 725172, 2, { 1068, 679 } },
    { 725196, 2, { 892, 813 } },
    { 725200, 2, { 925, 784 } },
    { 725220, 2, { 918, 790 } },
    { 725249, 2, { 931, 779 } },
    { 725274, 2, { 891, 814 } },
    { 725305, 2, { 901, 805 } },
    { 725340, 2, { 924, 785 } },
    { 725355, 2, { 995, 729 } },
    { 725400, 2, { 900, 806 } },
    { 725424, 2, { 889, 816 } },
    { 725496, 2, { 888, 817 } },
    { 725517, 2, { 1053, 689 } },
    { 725536, 2, { 1106, 656 } },
    { 725543, 2, { 871, 833 } },
    { 725560, 2, { 935, 776 } },
    { 725582, 2, { 946, 767 } },
    { 725604, 2, { 956, 759 } },
    { 725625, 2, { 1075, 675 } },
    { 725700, 2, { 885, 820 } },
    { 725725, 2, { 1001, 725 } },
    { 725748, 2, { 921, 788 } },
    { 725760, 2, { 864, 840 } },
    { 725788, 2, { 1058, 686 } },
    { 725835, 2, { 913, 795 } },
    { 725880, 2, { 920, 789 } },
    { 725892, 2, { 964, 753 } },
    { 725900, 2, { 854, 850 } },
    { 725940, 2, { 981, 740 } },
    { 725949, 2, { 1169, 621 } },
    { 725985, 2, { 949, 765 } },
    { 726000, 2, { 880, 825 } },
    { 726012, 2, { 903, 804 } },
    { 726084, 2, { 972, 747 } },
    { 726110, 2, { 902, 805 } },
    { 726138, 2, { 918, 791 } },
    { 726165, 2, { 891, 815 } },
    { 726206, 2, { 901, 806 } },
    { 726240, 2, { 890, 816 } },
    { 726264, 2, { 917, 792 } },
    { 726300, 2, { 900, 807 } },
    { 726327, 2, { 1281, 567 } },
    { 726330, 2, { 930, 781 } },
    { 726336, 2, { 873, 832 } },
    { 726376, 2, { 872, 833 } },
    { 726418, 2, { 979, 742 } },
    { 726432, 2, { 966, 752 } },
    { 726440, 2, { 1016, 715 } },
    { 726450, 2, { 870, 835 } },
    { 726516, 2, { 868, 837 } },
    { 726528, 2, { 946, 768 } },
    { 726530, 2, { 970, 749 } },
    { 726564, 2, { 951, 764 } },
    { 726570, 2, { 897, 810 } },
    { 726600, 2, { 865, 840 } },
    { 726624, 2, { 864, 841 } },
    { 726684, 2, { 861, 844 } },
    { 726744, 2, { 856, 849 } },
    { 726768, 2, { 882, 824 } },
    { 726831, 2, { 973, 747 } },
    { 726869, 2, { 1859, 391 } },
    { 726876, 2, { 993, 732 } },
    { 726880, 2, { 880, 826 } },
    { 726902, 2, { 893, 814 } },
    { 726930, 2, { 985, 738 } },
    { 726950, 2, { 938, 775 } },
    { 727040, 2, { 1024, 710 } },
    { 727050, 2, { 925, 786 } },
    { 727056, 2, { 891, 816 } },
    { 727065, 2, { 963, 755 } },
    { 727080, 2, { 876, 830 } },
    { 727090, 2, { 910, 799 } },
    { 727111, 2, { 931, 781 } },
    { 727120, 2, { 976, 745 } },
    { 727155, 2, { 1017, 715 } },
    { 727160, 2, { 980, 742 } },
    { 727168, 2, { 874, 832 } },
    { 727175, 2, { 1003, 725 } },
    { 727209, 2, { 873, 833 } },
    { 727216, 2, { 1057, 688 } },
    { 727248, 2, { 872, 834 } },
    { 727272, 2, { 888, 819 } },
    { 727308, 2, { 908, 801 } },
    { 727353, 2, { 869, 837 } },
    { 727415, 2, { 1235, 589 } },
    { 727419, 2, { 987, 737 } },
    { 727552, 2, { 896, 812 } },
    { 727584, 2, { 858, 848 } },
    { 727605, 2, { 855, 851 } },
    { 727620, 2, { 905, 804 } },
    { 727632, 2, { 978, 744 } },
    { 727650, 2, { 882, 825 } },
    { 727695, 2, { 927, 785 } },
    { 727710, 2, { 955, 762 } },
    { 727720, 2, { 904, 805 } },
    { 727740, 2, { 933, 780 } },
    { 727776, 2, { 912, 798 } },
    { 727812, 2, { 879, 828 } },
    { 727824, 2, { 944, 771 } },
    { 727902, 2, { 954, 763 } },
    { 727904, 2, { 989, 736 } },
    { 727920, 2, { 1011, 720 } },
    { 727947, 2, { 891, 817 } },
    { 727950, 2, { 1055, 690 } },
    { 727956, 2, { 876, 831 } },
    { 727974, 2, { 918, 793 } },
    { 728000, 2, { 875, 832 } },
    { 728028, 2, { 963, 756 } },
    { 728035, 2, { 1085, 671 } },
    { 728042, 2, { 874, 833 } },
    { 728064, 2, { 948, 768 } },
    { 728091, 2, { 889, 819 } },
    { 728120, 2, { 872, 835 } },
    { 728156, 2, { 871, 836 } },
    { 728160, 2, { 888, 820 } },
    { 728172, 2, { 1017, 716 } },
    { 728178, 2, { 1003, 726 } },
    { 728210, 2, { 1010, 721 } },
    { 728220, 2, { 916, 795 } },
    { 728280, 2, { 867, 840 } },
    { 728340, 2, { 915, 796 } },
    { 728352, 2, { 864, 843 } },
    { 728360, 2, { 1048, 695 } },
    { 728364, 2, { 897, 812 } },
    { 728365, 2, { 935, 779 } },
    { 728376, 2, { 979, 744 } },
    { 728420, 2, { 860, 847 } },
    { 728448, 2, { 896, 813 } },
    { 728460, 2, { 855, 852 } },
    { 728480, 2, { 928, 785 } },
    { 728532, 2, { 882, 826 } },
    { 728574, 2, { 913, 798 } },
    { 728610, 2, { 894, 815 } },
    { 728640, 2, { 880, 828 } },
    { 728650, 2, { 950, 767 } },
    { 728664, 2, { 939, 776 } },
    { 728688, 2, { 893, 816 } },
    { 728700, 2, { 1041, 700 } },
    { 728715, 2, { 1313, 555 } },
    { 728728, 2, { 1001, 728 } },
    { 728750, 2, { 1166, 625 } },
    { 728775, 2, { 1025, 711 } },
    { 728832, 2, { 876, 832 } },
    { 728840, 2, { 959, 760 } },
    { 728850, 2, { 1075, 678 } },
    { 728875, 2, { 875, 833 } },
    { 728904, 2, { 968, 753 } },
    { 728955, 2, { 873, 835 } },
    { 728973, 2, { 931, 783 } },
    { 728980, 2, { 889, 820 } },
    { 729015, 2, { 917, 795 } },
    { 729027, 2, { 871, 837 } },
    { 729036, 2, { 924, 789 } },
    { 729072, 2, { 976, 747 } },
    { 729099, 2, { 1141, 639 } },
    { 729120, 2, { 868, 840 } },
    { 729144, 2, { 936, 779 } },
    { 729147, 2, { 867, 841 } },
    { 729240, 2, { 885, 824 } },
    { 729270, 2, { 999, 730 } },
    { 729330, 2, { 906, 805 } },
    { 729344, 2, { 896, 814 } },
    { 729399, 2, { 961, 759 } },
    { 729408, 2, { 928, 786 } },
    { 729432, 2, { 921, 792 } },
    { 729456, 2, { 1002, 728 } },
    { 729504, 2, { 894, 816 } },
    { 729528, 2, { 904, 807 } },
    { 729540, 2, { 945, 772 } },
    { 729560, 2, { 920, 793 } },
    { 729624, 2, { 903, 808 } },
    { 729630, 2, { 990, 737 } },
    { 729708, 2, { 876, 833 } },
    { 729729, 2, { 891, 819 } },
    { 729736, 2, { 1099, 664 } },
    { 729750, 2, { 875, 834 } },
    { 729756, 2, { 932, 783 } },
    { 729771, 2, { 1121, 651 } },
    { 729810, 2, { 901, 810 } },
    { 729828, 2, { 873, 836 } },
    { 729864, 2, { 872, 837 } },
    { 729872, 2, { 968, 754 } },
    { 729904, 2, { 931, 784 } },
    { 729925, 2, { 1075, 679 } },
    { 729936, 2, { 888, 822 } },
    { 729960, 2, { 869, 840 } },
    { 730050, 2, { 930, 785 } },
    { 730075, 2, { 1007, 725 } },
    { 730080, 2, { 864, 845 } },
    { 730128, 2, { 861, 848 } },
    { 730140, 2, { 860, 849 } },
    { 730158, 2, { 858, 851 } },
    { 730170, 2, { 855, 854 } },
    { 730233, 2, { 1211, 603 } },
    { 730240, 2, { 896, 815 } },
    { 730269, 2, { 999, 731 } },
    { 730275, 2, { 975, 749 } },
    { 730303, 2, { 2023, 361 } },
    { 730320, 2, { 895, 816 } },
    { 730360, 2, { 961, 760 } },
    { 730368, 2, { 951, 768 } },
    { 730380, 2, { 940, 777 } },
    { 730400, 2, { 880, 830 } },
    { 730422, 2, { 1023, 714 } },
    { 730476, 2, { 927, 788 } },
    { 730512, 2, { 912, 801 } },
    { 730548, 2, { 892, 819 } },
    { 730575, 2, { 955, 765 } },
    { 730590, 2, { 994, 735 } },
    { 730620, 2, { 891, 820 } },
    { 730639, 2, { 1147, 637 } },
    { 730656, 2, { 944, 774 } },
    { 730664, 2, { 874, 836 } },
    { 730730, 2, { 910, 803 } },
    { 730752, 2, { 1038, 704 } },
    { 730756, 2, { 1081, 676 } },
    { 730785, 2, { 1133, 645 } },
    { 730800, 2, { 870, 840 } },
    { 730825, 2, { 943, 775 } },
    { 730836, 2, { 909, 804 } },
    { 730840, 2, { 968, 755 } },
    { 730845, 2, { 981, 745 } },
    { 730848, 2, { 993, 736 } },
    { 730884, 2, { 924, 791 } },
    { 730908, 2, { 948, 771 } },
    { 730944, 2, { 864, 846 } },
    { 730992, 2, { 942, 776 } },
    { 731082, 2, { 1007, 726 } },
    { 731104, 2, { 992, 737 } },
    { 731115, 2, { 1055, 693 } },
    { 731120, 2, { 962, 760 } },
    { 731136, 2, { 896, 816 } },
    { 731148, 2, { 957, 764 } },
    { 731170, 2, { 935, 782 } },
    { 731187, 2, { 1003, 729 } },
    { 731240, 2, { 905, 808 } },
    { 731268, 2, { 999, 732 } },
    { 731276, 2, { 1066, 686 } },
    { 731280, 2, { 880, 831 } },
    { 731328, 2, { 879, 832 } },
    { 731340, 2, { 956, 765 } },
    { 731367, 2, { 893, 819 } },
    { 731400, 2, { 920, 795 } },
    { 731423, 2, { 1127, 649 } },
    { 731430, 2, { 903, 810 } },
    { 731460, 2, { 876, 835 } },
    { 731472, 2, { 933, 784 } },
    { 731500, 2, { 875, 836 } },
    { 731520, 2, { 960, 762 } },
    { 731584, 2, { 994, 736 } },
    { 731600, 2, { 944, 775 } },
    { 731612, 2, { 901, 812 } },
    { 731640, 2, { 871, 840 } },
    { 731675, 2, { 925, 791 } },
    { 731676, 2, { 964, 759 } },
    { 731696, 2, { 973, 752 } },
    { 731700, 2, { 900, 813 } },
    { 731718, 2, { 954, 767 } },
    { 731724, 2, { 868, 843 } },
    { 731731, 2, { 1001, 731 } },
    { 731745, 2, { 909, 805 } },
    { 731748, 2, { 867, 844 } },
    { 731790, 2, { 865, 846 } },
    { 731808, 2, { 864, 847 } },
    { 731835, 2, { 1053, 695 } },
    { 731850, 2, { 861, 850 } },
    { 731880, 2, { 856, 855 } },
    { 731916, 2, { 972, 753 } },
    { 731962, 2, { 1067, 686 } },
    { 731964, 2, { 1011, 724 } },
    { 731975, 2, { 1273, 575 } },
    { 732000, 2, { 915, 800 } },
    { 732025, 2, { 1175, 623 } },
    { 732032, 2, { 896, 817 } },
    { 732048, 2, { 906, 808 } },
    { 732060, 2, { 882, 830 } },
    { 732105, 2, { 935, 783 } },
    { 732192, 2, { 928, 789 } },
    { 732240, 2, { 904, 810 } },
    { 732260, 2, { 893, 820 } },
    { 732375, 2, { 875, 837 } },
    { 732420, 2, { 939, 780 } },
    { 732424, 2, { 902, 812 } },
    { 732468, 2, { 1023, 716 } },
    { 732501, 2, { 1057, 693 } },
    { 732536, 2, { 889, 824 } },
    { 732564, 2, { 918, 798 } },
    { 732578, 2, { 938, 781 } },
    { 732600, 2, { 888, 825 } },
    { 732615, 2, { 867, 845 } },
    { 732645, 2, { 1005, 729 } },
    { 732648, 2, { 1029, 712 } },
    { 732725, 2, { 1325, 553 } },
    { 732756, 2, { 908, 807 } },
    { 732780, 2, { 885, 828 } },
    { 732849, 2, { 897, 817 } },
    { 732864, 2, { 1041, 704 } },
    { 732888, 2, { 936, 783 } },
    { 732900, 2, { 1047, 700 } },
    { 733005, 2, { 895, 819 } },
    { 733040, 2, { 880, 833 } },
    { 733050, 2, { 905, 810 } },
    { 733056, 2, { 996, 736 } },
    { 733075, 2, { 1475, 497 } },
    { 733116, 2, { 921, 796 } },
    { 733120, 2, { 928, 790 } },
    { 733125, 2, { 1173, 625 } },
    { 733150, 2, { 946, 775 } },
    { 733212, 2, { 876, 837 } },
    { 733236, 2, { 903, 812 } },
    { 733248, 2, { 912, 804 } },
    { 733257, 2, { 927, 791 } },
    { 733278, 2, { 1027, 714 } },
    { 733320, 2, { 873, 840 } },
    { 733381, 2, { 1331, 551 } },
    { 733414, 2, { 901, 814 } },
    { 733425, 2, { 889, 825 } },
    { 733440, 2, { 955, 768 } },
    { 733488, 2, { 888, 826 } },
    { 733500, 2, { 900, 815 } },
    { 733520, 2, { 865, 848 } },
    { 733525, 2, { 925, 793 } },
    { 733536, 2, { 864, 849 } },
    { 733572, 2, { 861, 852 } },
    { 733584, 2, { 899, 816 } },
    { 733600, 2, { 917, 800 } },
    { 733635, 2, { 959, 765 } },
    { 733677, 2, { 1029, 713 } },
    { 733716, 2, { 916, 801 } },
    { 733785, 2, { 923, 795 } },
    { 733788, 2, { 981, 748 } },
    { 733824, 2, { 882, 832 } },
    { 733920, 2, { 880, 834 } },
    { 733932, 2, { 1044, 703 } },
    { 733941, 2, { 1053, 697 } },
    { 733992, 2, { 952, 771 } },
    { 734019, 2, { 957, 767 } },
    { 734020, 2, { 980, 749 } },
    { 734052, 2, { 913, 804 } },
    { 734080, 2, { 992, 740 } },
    { 734103, 2, { 1007, 729 } },
    { 734140, 2, { 940, 781 } },
    { 734160, 2, { 874, 840 } },
    { 734172, 2, { 951, 772 } },
    { 734184, 2, { 891, 824 } },
    { 734265, 2, { 945, 777 } },
    { 734272, 2, { 1043, 704 } },
    { 734310, 2, { 995, 738 } },
    { 734320, 2, { 1072, 685 } },
    { 734349, 2, { 867, 847 } },
    { 734400, 2, { 864, 850 } },
    { 734440, 2, { 860, 854 } },
    { 734448, 2, { 858, 856 } },
    { 734454, 2, { 938, 783 } },
    { 734472, 2, { 909, 808 } },
    { 734517, 2, { 917, 801 } },
    { 734526, 2, { 949, 774 } },
    { 734580, 2, { 924, 795 } },
    { 734604, 2, { 884, 831 } },
    { 734635, 2, { 1045, 703 } },
    { 734643, 2, { 897, 819 } },
    { 734657, 2, { 1363, 539 } },
    { 734706, 2, { 882, 833 } },
    { 734712, 2, { 968, 759 } },
    { 734720, 2, { 896, 820 } },
    { 734745, 2, { 915, 803 } },
    { 734760, 2, { 936, 785 } },
    { 734769, 2, { 963, 763 } },
    { 734800, 2, { 880, 835 } },
    { 734820, 2, { 993, 740 } },
    { 734844, 2, { 879, 836 } },
    { 734910, 2, { 935, 786 } },
    { 734928, 2, { 976, 753 } },
    { 734952, 2, { 904, 813 } },
    { 734965, 2, { 913, 805 } },
    { 734976, 2, { 928, 792 } },
    { 735000, 2, { 875, 840 } },
    { 735034, 2, { 874, 841 } },
    { 735048, 2, { 984, 747 } },
    { 735063, 2, { 1207, 609 } },
    { 735072, 2, { 912, 806 } },
    { 735075, 2, { 891, 825 } },
    { 735080, 2, { 920, 799 } },
    { 735096, 2, { 872, 843 } },
    { 735150, 2, { 870, 845 } },
    { 735165, 2, { 961, 765 } },
    { 735174, 2, { 869, 846 } },
    { 735204, 2, { 933, 788 } },
    { 735216, 2, { 867, 848 } },
    { 735264, 2, { 864, 851 } },
    { 735300, 2, { 860, 855 } },
    { 735330, 2, { 965, 762 } },
    { 735348, 2, { 932, 789 } },
    { 735392, 2, { 938, 784 } },
    { 735420, 2, { 1020, 721 } },
    { 735456, 2, { 978, 752 } },
    { 735475, 2, { 949, 775 } },
    { 735488, 2, { 884, 832 } },
    { 735490, 2, { 931, 790 } },
    { 735540, 2, { 897, 820 } },
    { 735560, 2, { 994, 740 } },
    { 735625, 2, { 1177, 625 } },
    { 735630, 2, { 930, 791 } },
    { 735660, 2, { 915, 804 } },
    { 735680, 2, { 880, 836 } },
    { 735690, 2, { 895, 822 } },
    { 735696, 2, { 936, 786 } },
    { 735732, 2, { 963, 764 } },
    { 735735, 2, { 1001, 735 } },
    { 735795, 2, { 985, 747 } },
    { 735816, 2, { 989, 744 } },
    { 735875, 2, { 875, 841 } },
    { 735900, 2, { 892, 825 } },
    { 735904, 2, { 928, 793 } },
    { 735930, 2, { 962, 765 } },
    { 735966, 2, { 891, 826 } },
    { 735984, 2, { 912, 807 } },
    { 736008, 2, { 1011, 728 } },
    { 736032, 2, { 902, 816 } },
    { 736078, 2, { 1073, 686 } },
    { 736092, 2, { 889, 828 } },
    { 736128, 2, { 864, 852 } },
    { 736155, 2, { 861, 855 } },
    { 736176, 2, { 939, 784 } },
    { 736208, 2, { 979, 752 } },
    { 736263, 2, { 999, 737 } },
    { 736281, 2, { 899, 819 } },
    { 736308, 2, { 1017, 724 } },
    { 736320, 2, { 885, 832 } },
    { 736440, 2, { 969, 760 } },
    { 736470, 2, { 882, 835 } },
    { 736512, 2, { 896, 822 } },
    { 736554, 2, { 923, 798 } },
    { 736560, 2, { 880, 837 } },
    { 736596, 2, { 948, 777 } },
    { 736600, 2, { 1016, 725 } },
    { 736656, 2, { 894, 824 } },
    { 736725, 2, { 893, 825 } },
    { 736736, 2, { 1001, 736 } },
    { 736760, 2, { 904, 815 } },
    { 736764, 2, { 1029, 716 } },
    { 736800, 2, { 921, 800 } },
    { 736812, 2, { 873, 844 } },
    { 736840, 2, { 872, 845 } },
    { 736848, 2, { 903, 816 } },
    { 736866, 2, { 871, 846 } },
    { 736875, 2, { 1125, 655 } },
    { 736880, 2, { 976, 755 } },
    { 736890, 2, { 870, 847 } },
    { 736912, 2, { 869, 848 } },
    { 736920, 2, { 890, 828 } },
    { 736932, 2, { 868, 849 } },
    { 736934, 2, { 902, 817 } },
    { 736980, 2, { 865, 852 } },
    { 737000, 2, { 1000, 737 } },
    { 737009, 2, { 1157, 637 } },
    { 737016, 2, { 861, 856 } },
    { 737028, 2, { 1041, 708 } },
    { 737035, 2, { 1105, 667 } },
    { 737040, 2, { 888, 830 } },
    { 737076, 2, { 956, 771 } },
    { 737088, 2, { 1047, 704 } },
    { 737100, 2, { 900, 819 } },
    { 737154, 2, { 918, 803 } },
    { 737205, 2, { 885, 833 } },
    { 737264, 2, { 944, 781 } },
    { 737268, 2, { 917, 804 } },
    { 737280, 2, { 960, 768 } },
    { 737325, 2, { 1017, 725 } },
    { 737352, 2, { 882, 836 } },
    { 737373, 2, { 949, 777 } },
    { 737385, 2, { 1199, 615 } },
    { 737426, 2, { 943, 782 } },
    { 737450, 2, { 1075, 686 } },
    { 737460, 2, { 964, 765 } },
    { 737472, 2, { 1002, 736 } },
    { 737480, 2, { 895, 824 } },
    { 737495, 2, { 1219, 605 } },
    { 737528, 2, { 986, 748 } },
    { 737616, 2, { 968, 762 } },
    { 737685, 2, { 873, 845 } },
    { 737712, 2, { 872, 846 } },
    { 737737, 2, { 871, 847 } },
    { 737748, 2, { 891, 828 } },
    { 737760, 2, { 870, 848 } },
    { 737800, 2, { 868, 850 } },
    { 737817, 2, { 867, 851 } },
    { 737856, 2, { 864, 854 } },
    { 737870, 2, { 889, 830 } },
    { 737891, 2, { 1369, 539 } },
    { 737892, 2, { 927, 796 } },
    { 737919, 2, { 901, 819 } },
    { 737928, 2, { 888, 831 } },
    { 737940, 2, { 980, 753 } },
    { 737955, 2, { 1035, 713 } },
    { 737976, 2, { 951, 776 } },
    { 738000, 2, { 900, 820 } },
    { 738036, 2, { 988, 747 } },
    { 738045, 2, { 945, 781 } },
    { 738048, 2, { 961, 768 } },
    { 738100, 2, { 1100, 671 } },
    { 738108, 2, { 909, 812 } },
    { 738150, 2, { 925, 798 } },
    { 738192, 2, { 1014, 728 } },
    { 738204, 2, { 908, 813 } },
    { 738225, 2, { 965, 765 } },
    { 738255, 2, { 1185, 623 } },
    { 738276, 2, { 924, 799 } },
    { 738283, 2, { 931, 793 } },
    { 738360, 2, { 879, 840 } },
    { 738369, 2, { 943, 783 } },
    { 738390, 2, { 906, 815 } },
    { 738395, 2, { 1241, 595 } },
    { 738400, 2, { 923, 800 } },
    { 738430, 2, { 959, 770 } },
    { 738468, 2, { 876, 843 } },
    { 738480, 2, { 905, 816 } },
    { 738504, 2, { 936, 789 } },
    { 738528, 2, { 942, 784 } },
    { 738530, 2, { 874, 845 } },
    { 738584, 2, { 872, 847 } },
    { 738608, 2, { 871, 848 } },
    { 738650, 2, { 869, 850 } },
    { 738668, 2, { 868, 851 } },
    { 738684, 2, { 867, 852 } },
    { 738720, 2, { 864, 855 } },
    { 738750, 2, { 985, 750 } },
    { 738760, 2, { 920, 803 } },
    { 738792, 2, { 993, 744 } },
    { 738804, 2, { 957, 772 } },
    { 738816, 2, { 888, 832 } },
    { 738820, 2, { 901, 820 } },
    { 738936, 2, { 933, 792 } },
    { 738990, 2, { 918, 805 } },
    { 739025, 2, { 1025, 721 } },
    { 739040, 2, { 992, 745 } },
    { 739056, 2, { 1038, 712 } },
    { 739075, 2, { 925, 799 } },
    { 739125, 2, { 1095, 675 } },
    { 739128, 2, { 897, 824 } },
    { 739152, 2, { 944, 783 } },
    { 739170, 2, { 955, 774 } },
    { 739206, 2, { 1014, 729 } },
    { 739212, 2, { 916, 807 } },
    { 739260, 2, { 999, 740 } },
    { 739296, 2, { 906, 816 } },
    { 739312, 2, { 943, 784 } },
    { 739320, 2, { 915, 808 } },
    { 739328, 2, { 1024, 722 } },
    { 739375, 2, { 875, 845 } },
    { 739431, 2, { 873, 847 } },
    { 739440, 2, { 936, 790 } },
    { 739480, 2, { 973, 760 } },
    { 739530, 2, { 891, 830 } },
    { 739575, 2, { 865, 855 } },
    { 739648, 2, { 889, 832 } },
    { 739704, 2, { 888, 833 } },
    { 739827, 2, { 1269, 583 } },
    { 739860, 2, { 885, 836 } },
    { 739908, 2, { 884, 837 } },
    { 739932, 2, { 939, 788 } },
    { 739970, 2, { 961, 770 } },
    { 740000, 2, { 925, 800 } },
    { 740025, 2, { 897, 825 } },
    { 740050, 2, { 950, 779 } },
    { 740052, 2, { 1011, 732 } },
    { 740080, 2, { 880, 841 } },
    { 740096, 2, { 896, 826 } },
    { 740110, 2, { 970, 763 } },
    { 740124, 2, { 924, 801 } },
    { 740145, 2, { 931, 795 } },
    { 740160, 2, { 960, 771 } },
    { 740194, 2, { 1079, 686 } },
    { 740214, 2, { 1003, 738 } },
    { 740220, 2, { 876, 845 } },
    { 740250, 2, { 875, 846 } },
    { 740278, 2, { 874, 847 } },
    { 740304, 2, { 873, 848 } },
    { 740316, 2, { 969, 764 } },
    { 740328, 2, { 872, 849 } },
    { 740350, 2, { 871, 850 } },
    { 740370, 2, { 870, 851 } },
    { 740376, 2, { 904, 819 } },
    { 740388, 2, { 869, 852 } },
    { 740439, 2, { 1127, 657 } },
    { 740440, 2, { 865, 856 } },
    { 740460, 2, { 861, 860 } },
    { 740480, 2, { 890, 832 } },
    { 740484, 2, { 921, 804 } },
    { 740520, 2, { 935, 792 } },
    { 740544, 2, { 912, 812 } },
    { 740592, 2, { 888, 834 } },
    { 740600, 2, { 920, 805 } },
    { 740610, 2, { 1055, 702 } },
    { 740652, 2, { 1023, 724 } },
    { 740655, 2, { 981, 755 } },
    { 740675, 2, { 1075, 689 } },
    { 740718, 2, { 946, 783 } },
    { 740740, 2, { 910, 814 } },
    { 740745, 2, { 885, 837 } },
    { 740784, 2, { 976, 759 } },
    { 740835, 2, { 909, 815 } },
    { 740880, 2, { 882, 840 } },
    { 740925, 2, { 925, 801 } },
    { 740936, 2, { 917, 808 } },
    { 740940, 2, { 932, 795 } },
    { 740952, 2, { 984, 753 } },
    { 740962, 2, { 1054, 703 } },
    { 741000, 2, { 950, 780 } },
    { 741024, 2, { 992, 747 } },
    { 741040, 2, { 944, 785 } },
    { 741060, 2, { 895, 828 } },
    { 741080, 2, { 955, 776 } },
    { 741125, 2, { 875, 847 } },
    { 741150, 2, { 915, 810 } },
    { 741192, 2, { 1041, 712 } },
    { 741195, 2, { 905, 819 } },
    { 741234, 2, { 1014, 731 } },
    { 741252, 2, { 892, 831 } },
    { 741276, 2, { 1047, 708 } },
    { 741312, 2, { 864, 858 } },
    { 741356, 2, { 913, 812 } },
    { 741370, 2, { 890, 833 } },
    { 741455, 2, { 935, 793 } },
    { 741456, 2, { 912, 813 } },
    { 741468, 2, { 1092, 679 } },
    { 741472, 2, { 928, 799 } },
    { 741480, 2, { 888, 835 } },
    { 741489, 2, { 1139, 651 } },
    { 741520, 2, { 920, 806 } },
    { 741566, 2, { 1081, 686 } },
    { 741573, 2, { 1043, 711 } },
    { 741608, 2, { 952, 779 } },
    { 741636, 2, { 972, 763 } },
    { 741660, 2, { 940, 789 } },
    { 741664, 2, { 946, 784 } },
    { 741675, 2, { 899, 825 } },
    { 741690, 2, { 1005, 738 } },
    { 741741, 2, { 1001, 741 } },
    { 741744, 2, { 909, 816 } },
    { 741750, 2, { 989, 750 } },
    { 741762, 2, { 882, 841 } },
    { 741780, 2, { 951, 780 } },
    { 741825, 2, { 945, 785 } },
    { 741840, 2, { 880, 843 } },
    { 741876, 2, { 879, 844 } },
    { 741888, 2, { 896, 828 } },
    { 741895, 2, { 1435, 517 } },
    { 741950, 2, { 950, 781 } },
    { 741965, 2, { 1015, 731 } },
    { 741972, 2, { 876, 847 } },
    { 741984, 2, { 944, 786 } },
    { 742000, 2, { 875, 848 } },
    { 742126, 2, { 869, 854 } },
    { 742140, 2, { 868, 855 } },
    { 742152, 2, { 867, 856 } },
    { 742170, 2, { 865, 858 } },
    { 742203, 2, { 891, 833 } },
    { 742220, 2, { 1003, 740 } },
    { 742224, 2, { 987, 752 } },
    { 742248, 2, { 936, 793 } },
    { 742284, 2, { 948, 783 } },
    { 742352, 2, { 1079, 688 } },
    { 742365, 2, { 1053, 705 } },
    { 742440, 2, { 920, 807 } },
    { 742456, 2, { 968, 767 } },
    { 742500, 2, { 900, 825 } },
    { 742560, 2, { 884, 840 } },
    { 742577, 2, { 2057, 361 } },
    { 742616, 2, { 1043, 712 } },
    { 742632, 2, { 957, 776 } },
    { 742668, 2, { 933, 796 } },
    { 742716, 2, { 897, 828 } },
    { 742764, 2, { 993, 748 } },
    { 742770, 2, { 917, 810 } },
    { 742775, 2, { 925, 803 } },
    { 742797, 2, { 1107, 671 } },
    { 742812, 2, { 956, 777 } },
    { 742848, 2, { 876, 848 } },
    { 742900, 2, { 874, 850 } },
    { 742976, 2, { 893, 832 } },
    { 742980, 2, { 870, 854 } },
    { 742995, 2, { 869, 855 } },
    { 743015, 2, { 923, 805 } },
    { 743040, 2, { 864, 860 } },
    { 743067, 2, { 949, 783 } },
    { 743070, 2, { 930, 799 } },
    { 743088, 2, { 904, 822 } },
    { 743145, 2, { 1339, 555 } },
    { 743225, 2, { 959, 775 } },
    { 743232, 2, { 948, 784 } },
    { 743244, 2, { 964, 771 } },
    { 743256, 2, { 888, 837 } },
    { 743265, 2, { 995, 747 } },
    { 743280, 2, { 912, 815 } },
    { 743325, 2, { 901, 825 } },
    { 743328, 2, { 928, 801 } },
    { 743400, 2, { 885, 840 } },
    { 743424, 2, { 968, 768 } },
    { 743436, 2, { 963, 772 } },
    { 743444, 2, { 884, 841 } },
    { 743470, 2, { 910, 817 } },
    { 743505, 2, { 1095, 679 } },
    { 743512, 2, { 952, 781 } },
    { 743540, 2, { 940, 791 } },
    { 743600, 2, { 880, 845 } },
    { 743652, 2, { 908, 819 } },
    { 743680, 2, { 896, 830 } },
    { 743688, 2, { 939, 792 } },
    { 743700, 2, { 925, 804 } },
    { 743712, 2, { 976, 762 } },
    { 743724, 2, { 876, 849 } },
    { 743774, 2, { 874, 851 } },
    { 743796, 2, { 873, 852 } },
    { 743808, 2, { 894, 832 } },
    { 743820, 2, { 924, 805 } },
    { 743834, 2, { 871, 854 } },
    { 743869, 2, { 893, 833 } },
    { 743886, 2, { 867, 858 } },
    { 743904, 2, { 864, 861 } },
    { 743910, 2, { 905, 822 } },
    { 743925, 2, { 975, 763 } },
    { 743964, 2, { 988, 753 } },
    { 743985, 2, { 891, 835 } },
    { 744000, 2, { 930, 800 } },
    { 744016, 2, { 949, 784 } },
    { 744029, 2, { 1331, 559 } },
    { 744072, 2, { 903, 824 } },
    { 744093, 2, { 889, 837 } },
    { 744096, 2, { 1011, 736 } },
    { 744107, 2, { 1183, 629 } },
    { 744120, 2, { 936, 795 } },
    { 744128, 2, { 1057, 704 } },
    { 744150, 2, { 902, 825 } },
    { 744168, 2, { 921, 808 } },
    { 744184, 2, { 959, 776 } },
    { 744255, 2, { 999, 745 } },
    { 744345, 2, { 973, 765 } },
    { 744372, 2, { 899, 828 } },
    { 744444, 2, { 1017, 732 } },
    { 744464, 2, { 952, 782 } },
    { 744480, 2, { 880, 846 } },
    { 744575, 2, { 1027, 725 } },
    { 744576, 2, { 896, 831 } },
    { 744600, 2, { 876, 850 } },
    { 744625, 2, { 875, 851 } },
    { 744640, 2, { 895, 832 } },
    { 744660, 2, { 945, 788 } },
    { 744705, 2, { 871, 855 } },
    { 744708, 2, { 916, 813 } },
    { 744720, 2, { 870, 856 } },
    { 744800, 2, { 931, 800 } },
    { 744816, 2, { 944, 789 } },
    { 744876, 2, { 891, 836 } },
    { 744900, 2, { 955, 780 } },
    { 744930, 2, { 890, 837 } },
    { 744975, 2, { 903, 825 } },
    { 744996, 2, { 1029, 724 } },
    { 745000, 2, { 1000, 745 } },
    { 745008, 2, { 913, 816 } },
    { 745038, 2, { 1022, 729 } },
    { 745040, 2, { 1072, 695 } },
    { 745074, 2, { 954, 781 } },
    { 745085, 2, { 1045, 713 } },
    { 745104, 2, { 912, 817 } },
    { 745108, 2, { 1157, 644 } },
    { 745180, 2, { 1007, 740 } },
    { 745184, 2, { 928, 803 } },
    { 745212, 2, { 884, 843 } },
    { 745280, 2, { 1088, 685 } },
    { 745290, 2, { 882, 845 } },
    { 745308, 2, { 927, 804 } },
    { 745356, 2, { 1041, 716 } },
    { 745360, 2, { 880, 847 } },
    { 745380, 2, { 909, 820 } },
    { 745392, 2, { 879, 848 } },
    { 745416, 2, { 918, 812 } },
    { 745420, 2, { 940, 793 } },
    { 745464, 2, { 1047, 712 } },
    { 745465, 2, { 1121, 665 } },
    { 745488, 2, { 1002, 744 } },
    { 745500, 2, { 875, 852 } },
    { 745503, 2, { 957, 779 } },
    { 745524, 2, { 972, 767 } },
    { 745560, 2, { 872, 855 } },
    { 745584, 2, { 951, 784 } },
    { 745620, 2, { 867, 860 } },
    { 745668, 2, { 924, 807 } },
    { 745706, 2, { 989, 754 } },
    { 745710, 2, { 938, 795 } },
    { 745720, 2, { 905, 824 } },
    { 745731, 2, { 931, 801 } },
    { 745760, 2, { 944, 790 } },
    { 745800, 2, { 904, 825 } },
    { 745965, 2, { 1089, 685 } },
    { 746004, 2, { 996, 749 } },
    { 746028, 2, { 901, 828 } },
    { 746031, 2, { 1221, 611 } },
    { 746064, 2, { 942, 792 } },
    { 746112, 2, { 928, 804 } },
    { 746130, 2, { 935, 798 } },
    { 746187, 2, { 1007, 741 } },
    { 746232, 2, { 1003, 744 } },
    { 746235, 2, { 927, 805 } },
    { 746250, 2, { 995, 750 } },
    { 746265, 2, { 1157, 645 } },
    { 746304, 2, { 897, 832 } },
    { 746325, 2, { 963, 775 } },
    { 746328, 2, { 968, 771 } },
    { 746350, 2, { 1150, 649 } },
    { 746368, 2, { 896, 833 } },
    { 746400, 2, { 933, 800 } },
    { 746430, 2, { 895, 834 } },
    { 746490, 2, { 894, 835 } },
    { 746532, 2, { 932, 801 } },
    { 746544, 2, { 906, 824 } },
    { 746548, 2, { 893, 836 } },
    { 746550, 2, { 945, 790 } },
    { 746604, 2, { 892, 837 } },
    { 746640, 2, { 915, 816 } },
    { 746736, 2, { 993, 752 } },
    { 746760, 2, { 889, 840 } },
    { 746790, 2, { 930, 803 } },
    { 746823, 2, { 1113, 671 } },
    { 746856, 2, { 902, 828 } },
    { 746910, 2, { 965, 774 } },
    { 746928, 2, { 912, 819 } },
    { 746940, 2, { 885, 844 } },
    { 746976, 2, { 992, 753 } },
    { 746991, 2, { 1169, 639 } },
    { 747000, 2, { 900, 830 } },
    { 747040, 2, { 920, 812 } },
    { 747054, 2, { 882, 847 } },
    { 747065, 2, { 935, 799 } },
    { 747120, 2, { 880, 849 } },
    { 747201, 2, { 897, 833 } },
    { 747225, 2, { 1025, 729 } },
    { 747250, 2, { 875, 854 } },
    { 747252, 2, { 918, 814 } },
    { 747264, 2, { 896, 834 } },
    { 747270, 2, { 874, 855 } },
    { 747288, 2, { 873, 856 } },
    { 747300, 2, { 940, 795 } },
    { 747318, 2, { 871, 858 } },
    { 747320, 2, { 952, 785 } },
    { 747340, 2, { 869, 860 } },
    { 747348, 2, { 868, 861 } },
    { 747360, 2, { 865, 864 } },
    { 747400, 2, { 925, 808 } },
    { 747441, 2, { 893, 837 } },
    { 747444, 2, { 939, 796 } },
    { 747488, 2, { 994, 752 } },
    { 747495, 2, { 945, 791 } },
    { 747520, 2, { 1024, 730 } },
    { 747565, 2, { 1085, 689 } },
    { 747593, 2, { 931, 803 } },
    { 747600, 2, { 890, 840 } },
    { 747630, 2, { 923, 810 } },
    { 747656, 2, { 1027, 728 } },
    { 747684, 2, { 903, 828 } },
    { 747740, 2, { 980, 763 } },
    { 747747, 2, { 913, 819 } },
    { 747765, 2, { 955, 783 } },
    { 747813, 2, { 1023, 731 } },
    { 747840, 2, { 912, 820 } },
    { 747852, 2, { 921, 812 } },
    { 747900, 2, { 900, 831 } },
    { 747936, 2, { 882, 848 } },
    { 747960, 2, { 920, 813 } },
    { 747968, 2, { 899, 832 } },
    { 747972, 2, { 948, 789 } },
    { 748000, 2, { 880, 850 } },
    { 748055, 2, { 1015, 737 } },
    { 748068, 2, { 969, 772 } },
    { 748125, 2, { 875, 855 } },
    { 748140, 2, { 1011, 740 } },
    { 748160, 2, { 896, 835 } },
    { 748170, 2, { 918, 815 } },
    { 748176, 2, { 872, 858 } },
    { 748209, 2, { 869, 861 } },
    { 748272, 2, { 917, 816 } },
    { 748328, 2, { 1127, 664 } },
    { 748440, 2, { 891, 840 } },
    { 748475, 2, { 1175, 637 } },
    { 748496, 2, { 1141, 656 } },
    { 748510, 2, { 1190, 629 } },
    { 748524, 2, { 931, 804 } },
    { 748544, 2, { 1024, 731 } },
    { 748548, 2, { 956, 783 } },
    { 748584, 2, { 888, 843 } },
    { 748592, 2, { 944, 793 } },
    { 748650, 2, { 930, 805 } },
    { 748665, 2, { 1143, 655 } },
    { 748683, 2, { 1027, 729 } },
    { 748710, 2, { 885, 846 } },
    { 748720, 2, { 955, 784 } },
    { 748748, 2, { 884, 847 } },
    { 748800, 2, { 900, 832 } },
    { 748836, 2, { 1023, 732 } },
    { 748840, 2, { 965, 776 } },
    { 748867, 2, { 899, 833 } },
    { 748880, 2, { 880, 851 } },
    { 748896, 2, { 928, 807 } },
    { 748908, 2, { 879, 852 } },
    { 748935, 2, { 935, 801 } },
    { 748960, 2, { 992, 755 } },
    { 748980, 2, { 876, 855 } },
    { 748992, 2, { 996, 752 } },
    { 749000, 2, { 875, 856 } },
    { 749016, 2, { 909, 824 } },
    { 749028, 2, { 964, 777 } },
    { 749056, 2, { 896, 836 } },
    { 749060, 2, { 871, 860 } },
    { 749070, 2, { 870, 861 } },
    { 749075, 2, { 1577, 475 } },
    { 749088, 2, { 867, 864 } },
    { 749100, 2, { 908, 825 } },
    { 749112, 2, { 1029, 728 } },
    { 749115, 2, { 895, 837 } },
    { 749190, 2, { 1105, 678 } },
    { 749208, 2, { 1007, 744 } },
    { 749210, 2, { 973, 770 } },
    { 749232, 2, { 946, 792 } },
    { 749250, 2, { 925, 810 } },
    { 749275, 2, { 1025, 731 } },
    { 749320, 2, { 1048, 715 } },
    { 749331, 2, { 891, 841 } },
    { 749340, 2, { 905, 828 } },
    { 749360, 2, { 986, 760 } },
    { 749375, 2, { 1199, 625 } },
    { 749388, 2, { 951, 788 } },
    { 749398, 2, { 962, 779 } },
    { 749412, 2, { 972, 771 } },
    { 749476, 2, { 923, 812 } },
    { 749484, 2, { 981, 764 } },
    { 749520, 2, { 1041, 720 } },
    { 749595, 2, { 885, 847 } },
    { 749616, 2, { 966, 776 } },
    { 749637, 2, { 1141, 657 } },
    { 749650, 2, { 1034, 725 } },
    { 749652, 2, { 1047, 716 } },
    { 749664, 2, { 912, 822 } },
    { 749700, 2, { 882, 850 } },
    { 749736, 2, { 936, 801 } },
    { 749760, 2, { 880, 852 } },
    { 749772, 2, { 1059, 708 } },
    { 749800, 2, { 920, 815 } },
    { 749808, 2, { 984, 762 } },
    { 749868, 2, { 948, 791 } },
    { 749892, 2, { 874, 858 } },
    { 749931, 2, { 871, 861 } },
    { 749952, 2, { 868, 864 } },
    { 749988, 2, { 996, 753 } },
    { 750006, 2, { 918, 817 } },
    { 750105, 2, { 1055, 711 } },
    { 750120, 2, { 893, 840 } },
    { 750132, 2, { 933, 804 } },
    { 750141, 2, { 1029, 729 } },
    { 750178, 2, { 946, 793 } },
    { 750200, 2, { 968, 775 } },
    { 750204, 2, { 916, 819 } },
    { 750244, 2, { 1003, 748 } },
    { 750300, 2, { 915, 820 } },
    { 750321, 2, { 1089, 689 } },
    { 750360, 2, { 888, 845 } },
    { 750375, 2, { 1035, 725 } },
    { 750386, 2, { 931, 806 } },
    { 750400, 2, { 938, 800 } },
    { 750464, 2, { 902, 832 } },
    { 750480, 2, { 885, 848 } },
    { 750516, 2, { 884, 849 } },
    { 750519, 2, { 1083, 693 } },
    { 750533, 2, { 901, 833 } },
    { 750570, 2, { 985, 762 } },
    { 750582, 2, { 882, 851 } },
    { 750630, 2, { 955, 786 } },
    { 750651, 2, { 989, 759 } },
    { 750708, 2, { 993, 756 } },
    { 750720, 2, { 920, 816 } },
    { 750750, 2, { 875, 858 } },
    { 750780, 2, { 873, 860 } },
    { 750792, 2, { 872, 861 } },
    { 750816, 2, { 869, 864 } },
    { 750897, 2, { 959, 783 } },
    { 750960, 2, { 894, 840 } },
    { 751023, 2, { 917, 819 } },
    { 751104, 2, { 978, 768 } },
    { 751128, 2, { 952, 789 } },
    { 751140, 2, { 963, 780 } },
    { 751170, 2, { 1022, 735 } },
    { 751200, 2, { 939, 800 } },
    { 751212, 2, { 924, 813 } },
    { 751224, 2, { 904, 831 } },
    { 751248, 2, { 888, 846 } },
    { 751275, 2, { 945, 795 } },
    { 751296, 2, { 903, 832 } },
    { 751322, 2, { 923, 814 } },
    { 751366, 2, { 902, 833 } },
    { 751410, 2, { 990, 759 } },
    { 751440, 2, { 930, 808 } },
    { 751450, 2, { 950, 791 } },
    { 751500, 2, { 900, 835 } },
    { 751502, 2, { 961, 782 } },
    { 751520, 2, { 880, 854 } },
    { 751527, 2, { 1057, 711 } },
    { 751536, 2, { 921, 816 } },
    { 751564, 2, { 899, 836 } },
    { 751680, 2, { 870, 864 } },
    { 751709, 2, { 1127, 667 } },
    { 751740, 2, { 935, 804 } },
    { 751800, 2, { 895, 840 } },
    { 751825, 2, { 1037, 725 } },
    { 751856, 2, { 959, 784 } },
    { 751872, 2, { 979, 768 } },
    { 751905, 2, { 1023, 735 } },
    { 751940, 2, { 917, 820 } },
    { 751944, 2, { 969, 776 } },
    { 751956, 2, { 892, 843 } },
    { 752000, 2, { 940, 800 } },
    { 752004, 2, { 891, 844 } },
    { 752031, 2, { 1211, 621 } },
    { 752094, 2, { 889, 846 } },
    { 752124, 2, { 932, 807 } },
    { 752136, 2, { 888, 847 } },
    { 752184, 2, { 1011, 744 } },
    { 752192, 2, { 1022, 736 } },
    { 752220, 2, { 945, 796 } },
    { 752235, 2, { 1067, 705 } },
    { 752248, 2, { 931, 808 } },
    { 752284, 2, { 884, 851 } },
    { 752376, 2, { 1081, 696 } },
    { 752400, 2, { 880, 855 } },
    { 752424, 2, { 879, 856 } },
    { 752496, 2, { 976, 771 } },
    { 752544, 2, { 871, 864 } },
    { 752550, 2, { 870, 865 } },
    { 752556, 2, { 868, 867 } },
    { 752580, 2, { 1017, 740 } },
    { 752584, 2, { 1057, 712 } },
    { 752625, 2, { 1115, 675 } },
    { 752640, 2, { 896, 840 } },
    { 752652, 2, { 909, 828 } },
    { 752700, 2, { 965, 780 } },
    { 752724, 2, { 927, 812 } },
    { 752745, 2, { 1005, 749 } },
    { 752752, 2, { 1001, 752 } },
    { 752760, 2, { 918, 820 } },
    { 752840, 2, { 1160, 649 } },
    { 752862, 2, { 1037, 726 } },
    { 752895, 2, { 891, 845 } },
    { 752928, 2, { 992, 759 } },
    { 752940, 2, { 890, 846 } },
    { 752955, 2, { 1065, 707 } },
    { 752960, 2, { 905, 832 } },
    { 753000, 2, { 1000, 753 } },
    { 753032, 2, { 904, 833 } },
    { 753060, 2, { 924, 815 } },
    { 753192, 2, { 951, 792 } },
    { 753207, 2, { 1157, 651 } },
    { 753214, 2, { 938, 803 } },
    { 753225, 2, { 913, 825 } },
    { 753228, 2, { 882, 854 } },
    { 753236, 2, { 901, 836 } },
    { 753246, 2, { 962, 783 } },
    { 753270, 2, { 1055, 714 } },
    { 753300, 2, { 900, 837 } },
    { 753312, 2, { 912, 826 } },
    { 753350, 2, { 950, 793 } },
    { 753375, 2, { 875, 861 } },
    { 753480, 2, { 897, 840 } },
    { 753489, 2, { 1161, 649 } },
    { 753504, 2, { 1002, 752 } },
    { 753525, 2, { 985, 765 } },
    { 753536, 2, { 896, 841 } },
    { 753600, 2, { 942, 800 } },
    { 753610, 2, { 935, 806 } },
    { 753660, 2, { 948, 795 } },
    { 753684, 2, { 1041, 724 } },
    { 753725, 2, { 1475, 511 } },
    { 753792, 2, { 906, 832 } },
    { 753830, 2, { 890, 847 } },
    { 753840, 2, { 1047, 720 } },
    { 753864, 2, { 933, 808 } },
    { 753872, 2, { 889, 848 } },
    { 753912, 2, { 888, 849 } },
    { 753936, 2, { 904, 834 } },
    { 753948, 2, { 1053, 716 } },
    { 753960, 2, { 915, 824 } },
    { 753984, 2, { 924, 816 } },
    { 754000, 2, { 1000, 754 } },
    { 754008, 2, { 1059, 712 } },
    { 754020, 2, { 885, 852 } },
    { 754068, 2, { 987, 764 } },
    { 754075, 2, { 973, 775 } },
    { 754116, 2, { 957, 788 } },
    { 754137, 2, { 901, 837 } },
    { 754138, 2, { 913, 826 } },
    { 754208, 2, { 962, 784 } },
    { 754236, 2, { 876, 861 } },
    { 754245, 2, { 999, 755 } },
    { 754272, 2, { 873, 864 } },
    { 754280, 2, { 872, 865 } },
    { 754284, 2, { 956, 789 } },
    { 754292, 2, { 869, 868 } },
    { 754375, 2, { 1207, 625 } },
    { 754377, 2, { 897, 841 } },
    { 754416, 2, { 936, 806 } },
    { 754435, 2, { 1247, 605 } },
    { 754446, 2, { 966, 781 } },
    { 754455, 2, { 949, 795 } },
    { 754464, 2, { 928, 813 } },
    { 754509, 2, { 1159, 651 } },
    { 754515, 2, { 1035, 729 } },
    { 754548, 2, { 908, 831 } },
    { 754560, 2, { 960, 786 } },
    { 754585, 2, { 893, 845 } },
    { 754614, 2, { 954, 791 } },
    { 754650, 2, { 975, 774 } },
    { 754677, 2, { 891, 847 } },
    { 754680, 2, { 993, 760 } },
    { 754688, 2, { 1024, 737 } },
    { 754720, 2, { 890, 848 } },
    { 754728, 2, { 984, 767 } },
    { 754754, 2, { 1001, 754 } },
    { 754770, 2, { 905, 834 } },
    { 754800, 2, { 888, 850 } },
    { 754812, 2, { 964, 783 } },
    { 754820, 2, { 940, 803 } },
    { 754840, 2, { 904, 835 } },
    { 754845, 2, { 1027, 735 } },
    { 754851, 2, { 969, 779 } },
    { 754908, 2, { 903, 836 } },
    { 754956, 2, { 939, 804 } },
    { 754974, 2, { 902, 837 } },
    { 754975, 2, { 1313, 575 } },
    { 754985, 2, { 1295, 583 } },
    { 754992, 2, { 882, 856 } },
    { 755000, 2, { 1000, 755 } },
    { 755040, 2, { 880, 858 } },
    { 755048, 2, { 973, 776 } },
    { 755055, 2, { 945, 799 } },
    { 755076, 2, { 1068, 707 } },
    { 755136, 2, { 874, 864 } },
    { 755145, 2, { 873, 865 } },
    { 755160, 2, { 870, 868 } },
    { 755220, 2, { 921, 820 } },
    { 755244, 2, { 972, 777 } },
    { 755328, 2, { 896, 843 } },
    { 755352, 2, { 936, 807 } },
    { 755392, 2, { 928, 814 } },
    { 755424, 2, { 976, 774 } },
    { 755425, 2, { 1025, 737 } },
    { 755430, 2, { 894, 845 } },
    { 755436, 2, { 1067, 708 } },
    { 755440, 2, { 994, 760 } },
    { 755480, 2, { 935, 808 } },
    { 755505, 2, { 927, 815 } },
    { 755559, 2, { 1253, 603 } },
    { 755568, 2, { 891, 848 } },
    { 755573, 2, { 1729, 437 } },
    { 755580, 2, { 980, 771 } },
    { 755595, 2, { 965, 783 } },
    { 755608, 2, { 917, 824 } },
    { 755650, 2, { 889, 850 } },
    { 755664, 2, { 1038, 728 } },
    { 755700, 2, { 916, 825 } },
    { 755712, 2, { 984, 768 } },
    { 755725, 2, { 925, 817 } },
    { 755769, 2, { 1241, 609 } },
    { 755790, 2, { 885, 854 } },
    { 755811, 2, { 903, 837 } },
    { 755820, 2, { 884, 855 } },
    { 755854, 2, { 946, 799 } },
    { 755872, 2, { 1027, 736 } },
    { 755904, 2, { 992, 762 } },
    { 755937, 2, { 923, 819 } },
    { 755940, 2, { 879, 860 } },
    { 755955, 2, { 963, 785 } },
    { 755964, 2, { 913, 828 } },
    { 755970, 2, { 1115, 678 } },
    { 755973, 2, { 1037, 729 } },
    { 756000, 2, { 875, 864 } },
    { 756024, 2, { 872, 867 } },
    { 756028, 2, { 871, 868 } },
    { 756030, 2, { 870, 869 } },
    { 756112, 2, { 1099, 688 } },
    { 756144, 2, { 944, 801 } },
    { 756160, 2, { 1088, 695 } },
    { 756162, 2, { 1026, 737 } },
    { 756217, 2, { 1127, 671 } },
    { 756228, 2, { 1011, 748 } },
    { 756240, 2, { 920, 822 } },
    { 756245, 2, { 1085, 697 } },
    { 756250, 2, { 1210, 625 } },
    { 756280, 2, { 1022, 740 } },
    { 756288, 2, { 909, 832 } },
    { 756320, 2, { 928, 815 } },
    { 756327, 2, { 1353, 559 } },
    { 756360, 2, { 955, 792 } },
    { 756371, 2, { 893, 847 } },
    { 756400, 2, { 976, 775 } },
    { 756432, 2, { 918, 824 } },
    { 756450, 2, { 1025, 738 } },
    { 756470, 2, { 1058, 715 } },
    { 756490, 2, { 1010, 749 } },
    { 756510, 2, { 906, 835 } },
    { 756522, 2, { 954, 793 } },
    { 756525, 2, { 917, 825 } },
    { 756560, 2, { 965, 784 } },
    { 756585, 2, { 989, 765 } },
    { 756600, 2, { 970, 780 } },
    { 756613, 2, { 1573, 481 } },
    { 756648, 2, { 904, 837 } },
    { 756756, 2, { 882, 858 } },
    { 756840, 2, { 901, 840 } },
    { 756855, 2, { 1089, 695 } },
    { 756860, 2, { 923, 820 } },
    { 756864, 2, { 876, 864 } },
    { 756920, 2, { 1016, 745 } },
    { 756960, 2, { 912, 830 } },
    { 756976, 2, { 968, 782 } },
    { 756996, 2, { 951, 796 } },
    { 756999, 2, { 1219, 621 } },
    { 757020, 2, { 930, 814 } },
    { 757029, 2, { 987, 767 } },
    { 757068, 2, { 897, 844 } },
    { 757120, 2, { 896, 845 } },
    { 757170, 2, { 895, 846 } },
    { 757188, 2, { 972, 779 } },
    { 757197, 2, { 909, 833 } },
    { 757302, 2, { 949, 798 } },
    { 757308, 2, { 892, 849 } },
    { 757316, 2, { 1036, 731 } },
    { 757332, 2, { 981, 772 } },
    { 757344, 2, { 966, 784 } },
    { 757350, 2, { 891, 850 } },
    { 757393, 2, { 1189, 637 } },
    { 757428, 2, { 889, 852 } },
    { 757435, 2, { 1139, 665 } },
    { 757440, 2, { 960, 789 } },
    { 757485, 2, { 905, 837 } },
    { 757560, 2, { 885, 856 } },
    { 757575, 2, { 925, 819 } },
    { 757596, 2, { 933, 812 } },
    { 757610, 2, { 959, 790 } },
    { 757620, 2, { 915, 828 } },
    { 757624, 2, { 1141, 664 } },
    { 757665, 2, { 1017, 745 } },
    { 757680, 2, { 880, 861 } },
    { 757687, 2, { 2209, 343 } },
    { 757716, 2, { 932, 813 } },
    { 757740, 2, { 876, 865 } },
    { 757758, 2, { 874, 867 } },
    { 757760, 2, { 1024, 740 } },
    { 757764, 2, { 873, 868 } },
    { 757770, 2, { 871, 870 } },
    { 757834, 2, { 931, 814 } },
    { 757848, 2, { 1041, 728 } },
    { 757872, 2, { 912, 831 } },
    { 757925, 2, { 1525, 497 } },
    { 757926, 2, { 1027, 738 } },
    { 757944, 2, { 957, 792 } },
    { 757950, 2, { 930, 815 } },
    { 758016, 2, { 896, 846 } },
    { 758028, 2, { 1047, 724 } },
    { 758030, 2, { 910, 833 } },
    { 758032, 2, { 944, 803 } },
    { 758112, 2, { 894, 848 } },
    { 758160, 2, { 936, 810 } },
    { 758176, 2, { 928, 817 } },
    { 758190, 2, { 995, 762 } },
    { 758205, 2, { 1015, 747 } },
    { 758241, 2, { 891, 851 } },
    { 758244, 2, { 1059, 716 } },
    { 758268, 2, { 918, 826 } },
    { 758280, 2, { 890, 852 } },
    { 758295, 2, { 1107, 685 } },
    { 758310, 2, { 942, 805 } },
    { 758336, 2, { 1088, 697 } },
    { 758352, 2, { 888, 854 } },
    { 758373, 2, { 1029, 737 } },
    { 758400, 2, { 948, 800 } },
    { 758472, 2, { 884, 858 } },
    { 758490, 2, { 965, 786 } },
    { 758574, 2, { 1139, 666 } },
    { 758580, 2, { 940, 807 } },
    { 758625, 2, { 875, 867 } },
    { 758640, 2, { 872, 870 } },
    { 758652, 2, { 993, 764 } },
    { 758664, 2, { 984, 771 } },
    { 758670, 2, { 1045, 726 } },
    { 758700, 2, { 900, 843 } },
    { 758712, 2, { 939, 808 } },
    { 758725, 2, { 979, 775 } },
    { 758784, 2, { 912, 832 } },
    { 758835, 2, { 945, 803 } },
    { 758844, 2, { 963, 788 } },
    { 758880, 2, { 930, 816 } },
    { 758901, 2, { 957, 793 } },
    { 758904, 2, { 921, 824 } },
    { 758912, 2, { 896, 847 } },
    { 758928, 2, { 978, 776 } },
    { 758960, 2, { 895, 848 } },
    { 758976, 2, { 944, 804 } },
    { 759000, 2, { 920, 825 } },
    { 759015, 2, { 909, 835 } },
    { 759033, 2, { 1089, 697 } },
    { 759050, 2, { 893, 850 } },
    { 759115, 2, { 943, 805 } },
    { 759132, 2, { 891, 852 } },
    { 759165, 2, { 1177, 645 } },
    { 759200, 2, { 949, 800 } },
    { 759240, 2, { 888, 855 } },
    { 759276, 2, { 917, 828 } },
    { 759278, 2, { 1007, 754 } },
    { 759304, 2, { 1043, 728 } },
    { 759348, 2, { 948, 801 } },
    { 759456, 2, { 879, 864 } },
    { 759492, 2, { 876, 867 } },
    { 759500, 2, { 875, 868 } },
    { 759525, 2, { 975, 779 } },
    { 759552, 2, { 989, 768 } },
    { 759616, 2, { 913, 832 } },
    { 759655, 2, { 899, 845 } },
    { 759696, 2, { 912, 833 } },
    { 759759, 2, { 897, 847 } },
    { 759780, 2, { 938, 810 } },
    { 759800, 2, { 1048, 725 } },
    { 759810, 2, { 930, 817 } },
    { 759880, 2, { 968, 785 } },
    { 759920, 2, { 920, 826 } },
    { 759924, 2, { 909, 836 } },
    { 759948, 2, { 996, 763 } },
    { 759996, 2, { 908, 837 } },
    { 760000, 2, { 950, 800 } },
    { 760020, 2, { 956, 795 } },
    { 760025, 2, { 1075, 707 } },
    { 760032, 2, { 928, 819 } },
    { 760058, 2, { 943, 806 } },
    { 760095, 2, { 889, 855 } },
    { 760140, 2, { 927, 820 } },
    { 760200, 2, { 905, 840 } },
    { 760272, 2, { 1011, 752 } },
    { 760275, 2, { 981, 775 } },
    { 760320, 2, { 880, 864 } },
    { 760347, 2, { 1043, 729 } },
    { 760350, 2, { 925, 822 } },
    { 760375, 2, { 875, 869 } },
    { 760410, 2, { 994, 765 } },
    { 760455, 2, { 1161, 655 } },
    { 760461, 2, { 1147, 663 } },
    { 760480, 2, { 970, 784 } },
    { 760500, 2, { 900, 845 } },
    { 760529, 2, { 913, 833 } },
    { 760550, 2, { 1025, 742 } },
    { 760596, 2, { 964, 789 } },
    { 760608, 2, { 912, 834 } },
    { 760627, 2, { 931, 817 } },
    { 760648, 2, { 952, 799 } },
    { 760656, 2, { 897, 848 } },
    { 760683, 2, { 979, 777 } },
    { 760695, 2, { 1079, 705 } },
    { 760704, 2, { 896, 849 } },
    { 760716, 2, { 1017, 748 } },
    { 760725, 2, { 945, 805 } },
    { 760760, 2, { 910, 836 } },
    { 760800, 2, { 951, 800 } },
    { 760848, 2, { 968, 786 } },
    { 760914, 2, { 891, 854 } },
    { 760928, 2, { 1106, 688 } },
    { 760960, 2, { 928, 820 } },
    { 760968, 2, { 936, 813 } },
    { 760984, 2, { 889, 856 } },
    { 761040, 2, { 906, 840 } },
    { 761076, 2, { 972, 783 } },
    { 761100, 2, { 885, 860 } },
    { 761110, 2, { 917, 830 } },
    { 761112, 2, { 961, 792 } },
    { 761120, 2, { 1072, 710 } },
    { 761124, 2, { 884, 861 } },
    { 761136, 2, { 942, 808 } },
    { 761175, 2, { 995, 765 } },
    { 761196, 2, { 916, 831 } },
    { 761200, 2, { 880, 865 } },
    { 761244, 2, { 876, 869 } },
    { 761250, 2, { 875, 870 } },
    { 761256, 2, { 873, 872 } },
    { 761277, 2, { 1003, 759 } },
    { 761280, 2, { 915, 832 } },
    { 761306, 2, { 1157, 658 } },
    { 761328, 2, { 933, 816 } },
    { 761345, 2, { 901, 845 } },
    { 761453, 2, { 899, 847 } },
    { 761460, 2, { 980, 777 } },
    { 761475, 2, { 923, 825 } },
    { 761520, 2, { 912, 835 } },
    { 761530, 2, { 946, 805 } },
    { 761600, 2, { 896, 850 } },
    { 761607, 2, { 1099, 693 } },
    { 761616, 2, { 984, 774 } },
    { 761670, 2, { 910, 837 } },
    { 761720, 2, { 1096, 695 } },
    { 761733, 2, { 963, 791 } },
    { 761748, 2, { 988, 771 } },
    { 761772, 2, { 957, 796 } },
    { 761805, 2, { 891, 855 } },
    { 761808, 2, { 944, 807 } },
    { 761838, 2, { 1067, 714 } },
    { 761859, 2, { 973, 783 } },
    { 761875, 2, { 1219, 625 } },
    { 761904, 2, { 888, 858 } },
    { 761940, 2, { 918, 830 } },
    { 761964, 2, { 987, 772 } },
    { 762000, 2, { 1000, 762 } },
    { 762012, 2, { 1041, 732 } },
    { 762034, 2, { 1027, 742 } },
    { 762036, 2, { 1004, 759 } },
    { 762048, 2, { 882, 864 } },
    { 762072, 2, { 904, 843 } },
    { 762090, 2, { 955, 798 } },
    { 762125, 2, { 875, 871 } },
    { 762132, 2, { 903, 844 } },
    { 762195, 2, { 915, 833 } },
    { 762200, 2, { 925, 824 } },
    { 762216, 2, { 1047, 728 } },
    { 762246, 2, { 901, 846 } },
    { 762256, 2, { 976, 781 } },
    { 762280, 2, { 1003, 760 } },
    { 762300, 2, { 900, 847 } },
    { 762372, 2, { 1053, 724 } },
    { 762390, 2, { 985, 774 } },
    { 762398, 2, { 923, 826 } },
    { 762405, 2, { 959, 795 } },
    { 762450, 2, { 897, 850 } },
    { 762468, 2, { 939, 812 } },
    { 762480, 2, { 1059, 720 } },
    { 762489, 2, { 931, 819 } },
    { 762496, 2, { 896, 851 } },
    { 762528, 2, { 1014, 752 } },
    { 762540, 2, { 895, 852 } },
    { 762552, 2, { 952, 801 } },
    { 762575, 2, { 1175, 649 } },
    { 762588, 2, { 921, 828 } },
    { 762624, 2, { 993, 768 } },
    { 762660, 2, { 892, 855 } },
    { 762671, 2, { 1547, 493 } },
    { 762696, 2, { 891, 856 } },
    { 762723, 2, { 1107, 689 } },
    { 762755, 2, { 1085, 703 } },
    { 762816, 2, { 928, 822 } },
    { 762832, 2, { 973, 784 } },
    { 762840, 2, { 936, 815 } },
    { 762850, 2, { 950, 803 } },
    { 762880, 2, { 1024, 745 } },
    { 762930, 2, { 882, 865 } },
    { 762944, 2, { 917, 832 } },
    { 762960, 2, { 880, 867 } },
    { 762972, 2, { 879, 868 } },
    { 763000, 2, { 875, 872 } },
    { 763048, 2, { 1012, 754 } },
    { 763140, 2, { 948, 805 } },
    { 763147, 2, { 901, 847 } },
    { 763175, 2, { 1225, 623 } },
    { 763200, 2, { 900, 848 } },
    { 763236, 2, { 999, 764 } },
    { 763308, 2, { 932, 819 } },
    { 763344, 2, { 912, 837 } },
    { 763347, 2, { 897, 851 } },
    { 763392, 2, { 896, 852 } },
    { 763420, 2, { 931, 820 } },
    { 763425, 2, { 975, 783 } },
    { 763515, 2, { 893, 855 } },
    { 763560, 2, { 909, 840 } },
    { 763572, 2, { 969, 788 } },
    { 763623, 2, { 1071, 713 } },
    { 763680, 2, { 888, 860 } },
    { 763686, 2, { 957, 798 } },
    { 763752, 2, { 968, 789 } },
    { 763776, 2, { 884, 864 } },
    { 763800, 2, { 950, 804 } },
    { 763830, 2, { 943, 810 } },
    { 763840, 2, { 880, 868 } },
    { 763848, 2, { 927, 824 } },
    { 763875, 2, { 875, 873 } },
    { 763880, 2, { 904, 845 } },
    { 763895, 2, { 935, 817 } },
    { 763945, 2, { 949, 805 } },
    { 763968, 2, { 1038, 736 } },
    { 763980, 2, { 1020, 749 } },
    { 764000, 2, { 955, 800 } },
    { 764001, 2, { 1267, 603 } },
    { 764050, 2, { 925, 826 } },
    { 764100, 2, { 900, 849 } },
    { 764150, 2, { 899, 850 } },
    { 764181, 2, { 913, 837 } },
    { 764208, 2, { 976, 783 } },
    { 764218, 2, { 1183, 646 } },
    { 764220, 2, { 940, 813 } },
    { 764244, 2, { 897, 852 } },
    { 764280, 2, { 965, 792 } },
    { 764313, 2, { 1007, 759 } },
    { 764316, 2, { 1011, 756 } },
    { 764325, 2, { 1075, 711 } },
    { 764400, 2, { 910, 840 } },
    { 764405, 2, { 1445, 529 } },
    { 764445, 2, { 1243, 615 } },
    { 764456, 2, { 952, 803 } },
    { 764478, 2, { 891, 858 } },
    { 764520, 2, { 920, 831 } },
    { 764522, 2, { 1121, 682 } },
    { 764540, 2, { 889, 860 } },
    { 764568, 2, { 888, 861 } },
    { 764604, 2, { 951, 804 } },
    { 764640, 2, { 885, 864 } },
    { 764643, 2, { 957, 799 } },
    { 764694, 2, { 882, 867 } },
    { 764712, 2, { 936, 817 } },
    { 764720, 2, { 880, 869 } },
    { 764748, 2, { 876, 873 } },
    { 764750, 2, { 875, 874 } },
    { 764784, 2, { 904, 846 } },
    { 764832, 2, { 992, 771 } },
    { 764864, 2, { 1088, 703 } },
    { 764925, 2, { 987, 775 } },
    { 764928, 2, { 996, 768 } },
    { 764940, 2, { 915, 836 } },
    { 764955, 2, { 955, 801 } },
    { 765000, 2, { 900, 850 } },
    { 765036, 2, { 948, 807 } },
    { 765060, 2, { 933, 820 } },
    { 765180, 2, { 981, 780 } },
    { 765184, 2, { 896, 854 } },
    { 765204, 2, { 1023, 748 } },
    { 765225, 2, { 895, 855 } },
    { 765264, 2, { 894, 856 } },
    { 765306, 2, { 1037, 738 } },
    { 765310, 2, { 910, 841 } },
    { 765320, 2, { 1007, 760 } },
    { 765380, 2, { 980, 781 } },
    { 765408, 2, { 938, 816 } },
    { 765440, 2, { 920, 832 } },
    { 765444, 2, { 908, 843 } },
    { 765450, 2, { 945, 810 } },
    { 765567, 2, { 1089, 703 } },
    { 765570, 2, { 906, 845 } },
    { 765600, 2, { 880, 870 } },
    { 765630, 2, { 905, 846 } },
    { 765675, 2, { 1025, 747 } },
    { 765688, 2, { 904, 847 } },
    { 765700, 2, { 950, 806 } },
    { 765716, 2, { 943, 812 } },
    { 765744, 2, { 903, 848 } },
    { 765756, 2, { 956, 801 } },
    { 765765, 2, { 935, 819 } },
    { 765850, 2, { 901, 850 } },
    { 765855, 2, { 915, 837 } },
    { 765900, 2, { 900, 851 } },
    { 765912, 2, { 987, 776 } },
    { 765930, 2, { 1055, 726 } },
    { 765952, 2, { 1024, 748 } },
    { 766062, 2, { 954, 803 } },
    { 766080, 2, { 896, 855 } },
    { 766120, 2, { 895, 856 } },
    { 766160, 2, { 976, 785 } },
    { 766176, 2, { 1041, 736 } },
    { 766194, 2, { 893, 858 } },
    { 766224, 2, { 939, 816 } },
    { 766233, 2, { 999, 767 } },
    { 766260, 2, { 891, 860 } },
    { 766272, 2, { 921, 832 } },
    { 766320, 2, { 930, 824 } },
    { 766360, 2, { 920, 833 } },
    { 766380, 2, { 964, 795 } },
    { 766404, 2, { 1047, 732 } },
    { 766428, 2, { 884, 867 } },
    { 766458, 2, { 882, 869 } },
    { 766475, 2, { 989, 775 } },
    { 766480, 2, { 880, 871 } },
    { 766488, 2, { 879, 872 } },
    { 766500, 2, { 876, 875 } },
    { 766528, 2, { 928, 826 } },
    { 766530, 2, { 918, 835 } },
    { 766548, 2, { 963, 796 } },
    { 766584, 2, { 936, 819 } },
    { 766596, 2, { 993, 772 } },
    { 766692, 2, { 916, 837 } },
    { 766700, 2, { 902, 850 } },
    { 766716, 2, { 1059, 724 } },
    { 766752, 2, { 978, 784 } },
    { 766815, 2, { 1005, 763 } },
    { 766836, 2, { 1071, 716 } },
    { 766878, 2, { 961, 798 } },
    { 766908, 2, { 972, 789 } },
    { 766920, 2, { 913, 840 } },
    { 766935, 2, { 897, 855 } },
    { 766948, 2, { 1118, 686 } },
    { 766992, 2, { 912, 841 } },
    { 767000, 2, { 1000, 767 } },
    { 767040, 2, { 940, 816 } },
    { 767080, 2, { 1016, 755 } },
    { 767136, 2, { 976, 786 } },
    { 767144, 2, { 931, 824 } },
    { 767151, 2, { 891, 861 } },
    { 767195, 2, { 1073, 715 } },
    { 767196, 2, { 909, 844 } },
    { 767200, 2, { 959, 800 } },
    { 767232, 2, { 888, 864 } },
    { 767270, 2, { 970, 791 } },
    { 767280, 2, { 920, 834 } },
    { 767380, 2, { 1037, 740 } },
    { 767440, 2, { 905, 848 } },
    { 767448, 2, { 918, 836 } },
    { 767472, 2, { 944, 813 } },
    { 767496, 2, { 904, 849 } },
    { 767520, 2, { 936, 820 } },
    { 767529, 2, { 917, 837 } },
    { 767536, 2, { 979, 784 } },
    { 767550, 2, { 903, 850 } },
    { 767556, 2, { 927, 828 } },
    { 767624, 2, { 968, 793 } },
    { 767648, 2, { 1043, 736 } },
    { 767676, 2, { 962, 798 } },
    { 767725, 2, { 1025, 749 } },
    { 767730, 2, { 942, 815 } },
    { 767767, 2, { 1001, 767 } },
    { 767808, 2, { 992, 774 } },
    { 767820, 2, { 955, 804 } },
    { 767832, 2, { 897, 856 } },
    { 767835, 2, { 1017, 755 } },
    { 767844, 2, { 924, 831 } },
    { 767865, 2, { 1065, 721 } },
    { 767910, 2, { 895, 858 } },
    { 767916, 2, { 996, 771 } },
    { 767936, 2, { 923, 832 } },
    { 767970, 2, { 954, 805 } },
    { 767980, 2, { 893, 860 } },
    { 768012, 2, { 892, 861 } },
    { 768033, 2, { 1169, 657 } },
    { 768060, 2, { 1004, 765 } },
    { 768075, 2, { 931, 825 } },
    { 768094, 2, { 986, 779 } },
    { 768096, 2, { 889, 864 } },
    { 768105, 2, { 909, 845 } },
    { 768120, 2, { 888, 865 } },
    { 768152, 2, { 946, 812 } },
    { 768159, 2, { 959, 801 } },
    { 768180, 2, { 885, 868 } },
    { 768200, 2, { 920, 835 } },
    { 768222, 2, { 882, 871 } },
    { 768240, 2, { 880, 873 } },
    { 768264, 2, { 952, 807 } },
    { 768288, 2, { 906, 848 } },
    { 768300, 2, { 975, 788 } },
    { 768360, 2, { 1011, 760 } },
    { 768384, 2, { 928, 828 } },
    { 768408, 2, { 951, 808 } },
    { 768544, 2, { 1022, 752 } },
    { 768570, 2, { 935, 822 } },
    { 768600, 2, { 900, 854 } },
    { 768614, 2, { 1078, 713 } },
    { 768638, 2, { 962, 799 } },
    { 768645, 2, { 899, 855 } },
    { 768670, 2, { 973, 790 } },
    { 768672, 2, { 942, 816 } },
    { 768690, 2, { 949, 810 } },
    { 768750, 2, { 1025, 750 } },
    { 768768, 2, { 896, 858 } },
    { 768792, 2, { 933, 824 } },
    { 768800, 2, { 961, 800 } },
    { 768816, 2, { 912, 843 } },
    { 768852, 2, { 972, 791 } },
    { 768859, 2, { 923, 833 } },
    { 768873, 2, { 893, 861 } },
    { 768900, 2, { 932, 825 } },
    { 768955, 2, { 1271, 605 } },
    { 768960, 2, { 890, 864 } },
    { 769065, 2, { 885, 869 } },
    { 769095, 2, { 1055, 729 } },
    { 769104, 2, { 882, 872 } },
    { 769120, 2, { 880, 874 } },
    { 769160, 2, { 938, 820 } },
    { 769230, 2, { 945, 814 } },
    { 769296, 2, { 1023, 752 } },
    { 769318, 2, { 1331, 578 } },
    { 769350, 2, { 1115, 690 } },
    { 769356, 2, { 903, 852 } },
    { 769360, 2, { 944, 815 } },
    { 769365, 2, { 1107, 695 } },
    { 769392, 2, { 936, 822 } },
    { 769405, 2, { 1157, 665 } },
    { 769419, 2, { 1239, 621 } },
    { 769428, 2, { 957, 804 } },
    { 769488, 2, { 943, 816 } },
    { 769496, 2, { 1057, 728 } },
    { 769500, 2, { 900, 855 } },
    { 769536, 2, { 1002, 768 } },
    { 769560, 2, { 968, 795 } },
    { 769600, 2, { 925, 832 } },
    { 769626, 2, { 897, 858 } },
    { 769652, 2, { 988, 779 } },
    { 769692, 2, { 924, 833 } },
    { 769743, 2, { 1053, 731 } },
    { 769824, 2, { 891, 864 } },
    { 769825, 2, { 1325, 581 } },
    { 769860, 2, { 910, 846 } },
    { 769896, 2, { 888, 867 } },
    { 769923, 2, { 909, 847 } },
    { 769925, 2, { 1339, 575 } },
    { 769956, 2, { 921, 836 } },
    { 769980, 2, { 939, 820 } },
    { 770000, 2, { 880, 875 } },
    { 770004, 2, { 879, 876 } },
    { 770028, 2, { 1068, 721 } },
    { 770040, 2, { 920, 837 } },
    { 770064, 2, { 976, 789 } },
    { 770070, 2, { 965, 798 } },
    { 770085, 2, { 981, 785 } },
    { 770130, 2, { 995, 774 } },
    { 770175, 2, { 945, 815 } },
    { 770185, 2, { 1105, 697 } },
    { 770224, 2, { 1058, 728 } },
    { 770240, 2, { 928, 830 } },
    { 770280, 2, { 917, 840 } },
    { 770340, 2, { 1041, 740 } },
    { 770350, 2, { 994, 775 } },
    { 770355, 2, { 901, 855 } },
    { 770385, 2, { 957, 805 } },
    { 770406, 2, { 1079, 714 } },
    { 770440, 2, { 935, 824 } },
    { 770472, 2, { 984, 783 } },
    { 770525, 2, { 925, 833 } },
    { 770553, 2, { 1057, 729 } },
    { 770560, 2, { 896, 860 } },
    { 770568, 2, { 993, 776 } },
    { 770588, 2, { 949, 812 } },
    { 770592, 2, { 1047, 736 } },
    { 770625, 2, { 1125, 685 } },
    { 770630, 2, { 1010, 763 } },
    { 770640, 2, { 912, 845 } },
    { 770715, 2, { 891, 865 } },
    { 770724, 2, { 948, 813 } },
    { 770735, 2, { 1159, 665 } },
    { 770770, 2, { 910, 847 } },
    { 770796, 2, { 972, 793 } },
    { 770832, 2, { 909, 848 } },
    { 770835, 2, { 885, 871 } },
    { 770847, 2, { 987, 781 } },
    { 770868, 2, { 882, 874 } },
    { 770880, 2, { 880, 876 } },
    { 770892, 2, { 908, 849 } },
    { 770952, 2, { 1059, 728 } },
    { 771000, 2, { 1000, 771 } },
    { 771001, 2, { 1309, 589 } },
    { 771040, 2, { 976, 790 } },
    { 771060, 2, { 905, 852 } },
    { 771075, 2, { 1035, 745 } },
    { 771120, 2, { 918, 840 } },
    { 771168, 2, { 928, 831 } },
    { 771210, 2, { 902, 855 } },
    { 771225, 2, { 975, 791 } },
    { 771228, 2, { 999, 772 } },
    { 771255, 2, { 985, 783 } },
    { 771264, 2, { 927, 832 } },
    { 771282, 2, { 1058, 729 } },
    { 771324, 2, { 969, 796 } },
    { 771342, 2, { 899, 858 } },
    { 771375, 2, { 935, 825 } },
    { 771400, 2, { 950, 812 } },
    { 771420, 2, { 897, 860 } },
    { 771435, 2, { 1085, 711 } },
    { 771450, 2, { 925, 834 } },
    { 771456, 2, { 896, 861 } },
    { 771470, 2, { 1030, 749 } },
    { 771492, 2, { 956, 807 } },
    { 771528, 2, { 1037, 744 } },
    { 771540, 2, { 924, 835 } },
    { 771552, 2, { 893, 864 } },
    { 771628, 2, { 923, 836 } },
    { 771640, 2, { 955, 808 } },
    { 771650, 2, { 1150, 671 } },
    { 771672, 2, { 888, 869 } },
    { 771680, 2, { 910, 848 } },
    { 771720, 2, { 885, 872 } },
    { 771732, 2, { 884, 873 } },
    { 771750, 2, { 882, 875 } },
    { 771834, 2, { 966, 799 } },
    { 771840, 2, { 960, 804 } },
    { 771875, 2, { 1235, 625 } },
    { 771936, 2, { 946, 816 } },
    { 772000, 2, { 965, 800 } },
    { 772005, 2, { 1391, 555 } },
    { 772038, 2, { 918, 841 } },
    { 772044, 2, { 1092, 707 } },
    { 772065, 2, { 903, 855 } },
    { 772164, 2, { 964, 801 } },
    { 772179, 2, { 1083, 713 } },
    { 772188, 2, { 916, 843 } },
    { 772191, 2, { 927, 833 } },
    { 772200, 2, { 900, 858 } },
    { 772212, 2, { 951, 812 } },
    { 772225, 2, { 1343, 575 } },
    { 772260, 2, { 915, 844 } },
    { 772272, 2, { 1038, 744 } },
    { 772304, 2, { 1027, 752 } },
    { 772398, 2, { 913, 846 } },
    { 772404, 2, { 1011, 764 } },
    { 772416, 2, { 894, 864 } },
    { 772464, 2, { 912, 847 } },
    { 772480, 2, { 1088, 710 } },
    { 772486, 2, { 949, 814 } },
    { 772497, 2, { 891, 867 } },
    { 772524, 2, { 933, 828 } },
    { 772551, 2, { 923, 837 } },
    { 772560, 2, { 888, 870 } },
    { 772616, 2, { 884, 874 } },
    { 772620, 2, { 948, 815 } },
    { 772695, 2, { 1115, 693 } },
    { 772730, 2, { 931, 830 } },
    { 772768, 2, { 992, 779 } },
    { 772821, 2, { 987, 783 } },
    { 772915, 2, { 1081, 715 } },
    { 772920, 2, { 904, 855 } },
    { 772965, 2, { 965, 801 } },
    { 772968, 2, { 903, 856 } },
    { 773024, 2, { 928, 833 } },
    { 773028, 2, { 981, 788 } },
    { 773058, 2, { 901, 858 } },
    { 773120, 2, { 1024, 755 } },
    { 773136, 2, { 936, 826 } },
    { 773190, 2, { 990, 781 } },
    { 773220, 2, { 980, 789 } },
    { 773256, 2, { 957, 808 } },
    { 773280, 2, { 895, 864 } },
    { 773310, 2, { 894, 865 } },
    { 773355, 2, { 1199, 645 } },
    { 773364, 2, { 892, 867 } },
    { 773388, 2, { 891, 868 } },
    { 773398, 2, { 989, 782 } },
    { 773424, 2, { 984, 786 } },
    { 773430, 2, { 889, 870 } },
    { 773432, 2, { 968, 799 } },
    { 773448, 2, { 888, 871 } },
    { 773500, 2, { 884, 875 } },
    { 773520, 2, { 880, 879 } },
    { 773535, 2, { 973, 795 } },
    { 773550, 2, { 955, 810 } },
    { 773568, 2, { 948, 816 } },
    { 773575, 2, { 1067, 725 } },
    { 773604, 2, { 988, 783 } },
    { 773605, 2, { 961, 805 } },
    { 773640, 2, { 921, 840 } },
    { 773670, 2, { 1110, 697 } },
    { 773696, 2, { 1099, 704 } },
    { 773720, 2, { 920, 841 } },
    { 773736, 2, { 939, 824 } },
    { 773760, 2, { 930, 832 } },
    { 773775, 2, { 905, 855 } },
    { 773808, 2, { 987, 784 } },
    { 773829, 2, { 1211, 639 } },
    { 773850, 2, { 938, 825 } },
    { 773892, 2, { 996, 777 } },
    { 773927, 2, { 1463, 529 } },
    { 773952, 2, { 928, 834 } },
    { 773955, 2, { 945, 819 } },
    { 773976, 2, { 952, 813 } },
    { 774000, 2, { 900, 860 } },
    { 774045, 2, { 927, 835 } },
    { 774084, 2, { 1004, 771 } },
    { 774090, 2, { 915, 846 } },
    { 774144, 2, { 896, 864 } },
    { 774165, 2, { 1095, 707 } },
    { 774180, 2, { 935, 828 } },
    { 774210, 2, { 985, 786 } },
    { 774224, 2, { 913, 848 } },
    { 774225, 2, { 925, 837 } },
    { 774231, 2, { 893, 867 } },
    { 774252, 2, { 963, 804 } },
    { 774279, 2, { 891, 869 } },
    { 774288, 2, { 912, 849 } },
    { 774387, 2, { 989, 783 } },
    { 774410, 2, { 910, 851 } },
    { 774468, 2, { 909, 852 } },
    { 774492, 2, { 932, 831 } },
    { 774504, 2, { 1041, 744 } },
    { 774520, 2, { 1139, 680 } },
    { 774540, 2, { 993, 780 } },
    { 774576, 2, { 978, 792 } },
    { 774592, 2, { 931, 832 } },
    { 774680, 2, { 905, 856 } },
    { 774690, 2, { 930, 833 } },
    { 774706, 2, { 1073, 722 } },
    { 774720, 2, { 960, 807 } },
    { 774752, 2, { 992, 781 } },
    { 774780, 2, { 1047, 740 } },
    { 774800, 2, { 1040, 745 } },
    { 774860, 2, { 901, 860 } },
    { 774872, 2, { 959, 808 } },
    { 774880, 2, { 928, 835 } },
    { 774900, 2, { 900, 861 } },
    { 774928, 2, { 952, 814 } },
    { 774972, 2, { 927, 836 } },
    { 775000, 2, { 1000, 775 } },
    { 775005, 2, { 915, 847 } },
    { 775008, 2, { 897, 864 } },
    { 775040, 2, { 896, 865 } },
    { 775075, 2, { 1075, 721 } },
    { 775124, 2, { 893, 868 } },
    { 775170, 2, { 891, 870 } },
    { 775180, 2, { 980, 791 } },
    { 775188, 2, { 1059, 732 } },
    { 775200, 2, { 912, 850 } },
    { 775208, 2, { 889, 872 } },
    { 775215, 2, { 963, 805 } },
    { 775224, 2, { 888, 873 } },
    { 775257, 2, { 1273, 609 } },
    { 775260, 2, { 885, 876 } },
    { 775320, 2, { 910, 852 } },
    { 775368, 2, { 968, 801 } },
    { 775376, 2, { 989, 784 } },
    { 775390, 2, { 1007, 770 } },
    { 775404, 2, { 1071, 724 } },
    { 775440, 2, { 1077, 720 } },
    { 775489, 2, { 1573, 493 } },
    { 775500, 2, { 940, 825 } },
    { 775515, 2, { 1261, 615 } },
    { 775536, 2, { 906, 856 } },
    { 775560, 2, { 920, 843 } },
    { 775625, 2, { 1241, 625 } },
    { 775632, 2, { 904, 858 } },
    { 775635, 2, { 1245, 623 } },
    { 775656, 2, { 972, 798 } },
    { 775675, 2, { 1349, 575 } },
    { 775676, 2, { 1037, 748 } },
    { 775698, 2, { 966, 803 } },
    { 775710, 2, { 918, 845 } },
    { 775761, 2, { 901, 861 } },
    { 775775, 2, { 1001, 775 } },
    { 775782, 2, { 917, 846 } },
    { 775860, 2, { 965, 804 } },
    { 775866, 2, { 1029, 754 } },
    { 775880, 2, { 952, 815 } },
    { 775920, 2, { 915, 848 } },
    { 775968, 2, { 944, 822 } },
    { 775971, 2, { 981, 791 } },
    { 776000, 2, { 970, 800 } },
    { 776016, 2, { 951, 816 } },
    { 776048, 2, { 1066, 728 } },
    { 776050, 2, { 913, 850 } },
    { 776061, 2, { 891, 871 } },
    { 776097, 2, { 889, 873 } },
    { 776100, 2, { 975, 796 } },
    { 776150, 2, { 950, 817 } },
    { 776160, 2, { 882, 880 } },
    { 776204, 2, { 1012, 767 } },
    { 776208, 2, { 942, 824 } },
    { 776256, 2, { 933, 832 } },
    { 776322, 2, { 1003, 774 } },
    { 776340, 2, { 908, 855 } },
    { 776376, 2, { 984, 789 } },
    { 776385, 2, { 1065, 729 } },
    { 776412, 2, { 948, 819 } },
    { 776440, 2, { 940, 826 } },
    { 776448, 2, { 1011, 768 } },
    { 776475, 2, { 1015, 765 } },
    { 776490, 2, { 905, 858 } },
    { 776503, 2, { 1127, 689 } },
    { 776550, 2, { 930, 835 } },
    { 776580, 2, { 903, 860 } },
    { 776664, 2, { 938, 828 } },
    { 776720, 2, { 1022, 760 } },
    { 776736, 2, { 899, 864 } },
    { 776776, 2, { 1001, 776 } },
    { 776815, 2, { 1105, 703 } },
    { 776832, 2, { 896, 867 } },
    { 776853, 2, { 1121, 693 } },
    { 776875, 2, { 1243, 625 } },
    { 776880, 2, { 936, 830 } },
    { 776910, 2, { 893, 870 } },
    { 776952, 2, { 891, 872 } },
    { 776988, 2, { 1017, 764 } },
    { 777000, 2, { 888, 875 } },
    { 777024, 2, { 912, 852 } },
    { 777036, 2, { 884, 879 } },
    { 777062, 2, { 1573, 494 } },
    { 777084, 2, { 924, 841 } },
    { 777168, 2, { 1008, 771 } },
    { 777192, 2, { 1128, 689 } },
    { 777200, 2, { 1072, 725 } },
    { 777216, 2, { 1012, 768 } },
    { 777228, 2, { 956, 813 } },
    { 777231, 2, { 949, 819 } },
    { 777240, 2, { 1016, 765 } },
    { 777324, 2, { 921, 844 } },
    { 777325, 2, { 1003, 775 } },
    { 777400, 2, { 920, 845 } },
    { 777492, 2, { 939, 828 } },
    { 777510, 2, { 954, 815 } },
    { 777546, 2, { 918, 847 } },
    { 777552, 2, { 1002, 776 } },
    { 777600, 2, { 900, 864 } },
    { 777616, 2, { 917, 848 } },
    { 777684, 2, { 916, 849 } },
    { 777728, 2, { 896, 868 } },
    { 777756, 2, { 987, 788 } },
    { 777784, 2, { 952, 817 } },
    { 777816, 2, { 936, 831 } },
    { 777870, 2, { 1005, 774 } },
    { 777875, 2, { 889, 875 } },
    { 777876, 2, { 913, 852 } },
    { 777920, 2, { 884, 880 } },
    { 777948, 2, { 964, 807 } },
    { 777952, 2, { 1057, 736 } },
    { 777975, 2, { 943, 825 } },
    { 778085, 2, { 1505, 517 } },
    { 778104, 2, { 909, 856 } },
    { 778113, 2, { 1253, 621 } },
    { 778180, 2, { 949, 820 } },
    { 778221, 2, { 999, 779 } },
    { 778240, 2, { 1024, 760 } },
    { 778260, 2, { 1020, 763 } },
    { 778302, 2, { 994, 783 } },
    { 778305, 2, { 979, 795 } },
    { 778320, 2, { 920, 846 } },
    { 778344, 2, { 904, 861 } },
    { 778360, 2, { 1160, 671 } },
    { 778400, 2, { 973, 800 } },
    { 778464, 2, { 901, 864 } },
    { 778500, 2, { 900, 865 } },
    { 778505, 2, { 1015, 767 } },
    { 778512, 2, { 993, 784 } },
    { 778572, 2, { 972, 801 } },
    { 778590, 2, { 1055, 738 } },
    { 778596, 2, { 897, 868 } },
    { 778624, 2, { 896, 869 } },
    { 778635, 2, { 1089, 715 } },
    { 778650, 2, { 895, 870 } },
    { 778668, 2, { 1041, 748 } },
    { 778680, 2, { 927, 840 } },
    { 778716, 2, { 892, 873 } },
    { 778720, 2, { 992, 785 } },
    { 778734, 2, { 891, 874 } },
    { 778752, 2, { 936, 832 } },
    { 778764, 2, { 889, 876 } },
    { 778800, 2, { 885, 880 } },
    { 778848, 2, { 912, 854 } },
    { 778932, 2, { 924, 843 } },
    { 778968, 2, { 1047, 744 } },
    { 779025, 2, { 975, 799 } },
    { 779031, 2, { 1161, 671 } },
    { 779076, 2, { 969, 804 } },
    { 779085, 2, { 995, 783 } },
    { 779100, 2, { 980, 795 } },
    { 779121, 2, { 1043, 747 } },
    { 779220, 2, { 962, 810 } },
    { 779240, 2, { 920, 847 } },
    { 779246, 2, { 1066, 731 } },
    { 779247, 2, { 931, 837 } },
    { 779275, 2, { 1525, 511 } },
    { 779280, 2, { 955, 816 } },
    { 779296, 2, { 994, 784 } },
    { 779328, 2, { 902, 864 } },
    { 779331, 2, { 1003, 777 } },
    { 779373, 2, { 973, 801 } },
    { 779424, 2, { 1059, 736 } },
    { 779433, 2, { 899, 867 } },
    { 779450, 2, { 917, 850 } },
    { 779520, 2, { 896, 870 } },
    { 779532, 2, { 988, 789 } },
    { 779568, 2, { 894, 872 } },
    { 779580, 2, { 915, 852 } },
    { 779625, 2, { 891, 875 } },
    { 779640, 2, { 890, 876 } },
    { 779688, 2, { 884, 882 } },
    { 779702, 2, { 913, 854 } },
    { 779712, 2, { 992, 786 } },
    { 779720, 2, { 965, 808 } },
    { 779748, 2, { 1077, 724 } },
    { 779760, 2, { 912, 855 } },
    { 779779, 2, { 1001, 779 } },
    { 779790, 2, { 935, 834 } },
    { 779820, 2, { 951, 820 } },
    { 779868, 2, { 996, 783 } },
    { 779880, 2, { 970, 804 } },
    { 779988, 2, { 933, 836 } },
    { 780000, 2, { 975, 800 } },
    { 780084, 2, { 932, 837 } },
    { 780108, 2, { 1004, 777 } },
    { 780120, 2, { 985, 792 } },
    { 780192, 2, { 903, 864 } },
    { 780208, 2, { 968, 806 } },
    { 780219, 2, { 999, 781 } },
    { 780252, 2, { 1012, 771 } },
    { 780273, 2, { 1053, 741 } },
    { 780275, 2, { 1357, 575 } },
    { 780300, 2, { 900, 867 } },
    { 780312, 2, { 984, 793 } },
    { 780325, 2, { 1225, 637 } },
    { 780416, 2, { 896, 871 } },
    { 780425, 2, { 1007, 775 } },
    { 780435, 2, { 1107, 705 } },
    { 780440, 2, { 895, 872 } },
    { 780450, 2, { 946, 825 } },
    { 780480, 2, { 960, 813 } },
    { 780492, 2, { 1011, 772 } },
    { 780516, 2, { 891, 876 } },
    { 780528, 2, { 966, 808 } },
    { 780552, 2, { 888, 879 } },
    { 780570, 2, { 885, 882 } },
    { 780576, 2, { 1038, 752 } },
    { 780615, 2, { 913, 855 } },
    { 780624, 2, { 936, 834 } },
    { 780759, 2, { 1071, 729 } },
    { 780760, 2, { 1048, 745 } },
    { 780804, 2, { 943, 828 } },
    { 780858, 2, { 923, 846 } },
    { 780864, 2, { 996, 784 } },
    { 780876, 2, { 981, 796 } },
    { 780912, 2, { 957, 816 } },
    { 781000, 2, { 1000, 781 } },
    { 781008, 2, { 921, 848 } },
    { 781011, 2, { 1029, 759 } },
    { 781044, 2, { 1067, 732 } },
    { 781050, 2, { 1025, 762 } },
    { 781080, 2, { 920, 849 } },
    { 781140, 2, { 940, 831 } },
    { 781144, 2, { 962, 812 } },
    { 781176, 2, { 968, 807 } },
    { 781200, 2, { 900, 868 } },
    { 781218, 2, { 918, 851 } },
    { 781220, 2, { 1060, 737 } },
    { 781242, 2, { 979, 798 } },
    { 781248, 2, { 939, 832 } },
    { 781284, 2, { 917, 852 } },
    { 781335, 2, { 895, 873 } },
    { 781375, 2, { 893, 875 } },
    { 781389, 2, { 1099, 711 } },
    { 781425, 2, { 1035, 755 } },
    { 781560, 2, { 936, 835 } },
    { 781572, 2, { 1023, 764 } },
    { 781632, 2, { 944, 828 } },
    { 781650, 2, { 965, 810 } },
    { 781740, 2, { 909, 860 } },
    { 781776, 2, { 976, 801 } },
    { 781781, 2, { 923, 847 } },
    { 781788, 2, { 908, 861 } },
    { 781830, 2, { 1022, 765 } },
    { 781869, 2, { 957, 817 } },
    { 781872, 2, { 1074, 728 } },
    { 781875, 2, { 1125, 695 } },
    { 781920, 2, { 905, 864 } },
    { 781956, 2, { 963, 812 } },
    { 781960, 2, { 904, 865 } },
    { 782040, 2, { 931, 840 } },
    { 782068, 2, { 901, 868 } },
    { 782070, 2, { 995, 786 } },
    { 782075, 2, { 1025, 763 } },
    { 782080, 2, { 940, 832 } },
    { 782100, 2, { 900, 869 } },
    { 782130, 2, { 899, 870 } },
    { 782145, 2, { 955, 819 } },
    { 782184, 2, { 897, 872 } },
    { 782208, 2, { 896, 873 } },
    { 782250, 2, { 894, 875 } },
    { 782275, 2, { 1079, 725 } },
    { 782304, 2, { 928, 843 } },
    { 782320, 2, { 889, 880 } },
    { 782340, 2, { 885, 884 } },
    { 782388, 2, { 927, 844 } },
    { 782391, 2, { 1173, 667 } },
    { 782400, 2, { 960, 815 } },
    { 782439, 2, { 1007, 777 } },
    { 782460, 2, { 945, 828 } },
    { 782484, 2, { 993, 788 } },
    { 782488, 2, { 1099, 712 } },
    { 782496, 2, { 912, 858 } },
    { 782544, 2, { 952, 822 } },
    { 782550, 2, { 925, 846 } },
    { 782560, 2, { 1072, 730 } },
    { 782595, 2, { 935, 837 } },
    { 782628, 2, { 924, 847 } },
    { 782688, 2, { 992, 789 } },
    { 782691, 2, { 987, 793 } },
    { 782694, 2, { 1062, 737 } },
    { 782704, 2, { 923, 848 } },
    { 782730, 2, { 1115, 702 } },
    { 782782, 2, { 1001, 782 } },
    { 782784, 2, { 906, 864 } },
    { 782832, 2, { 1041, 752 } },
    { 782920, 2, { 920, 851 } },
    { 782925, 2, { 949, 825 } },
    { 782936, 2, { 902, 868 } },
    { 782952, 2, { 969, 808 } },
    { 782955, 2, { 1143, 685 } },
    { 782964, 2, { 956, 819 } },
    { 782971, 2, { 931, 841 } },
    { 783000, 2, { 900, 870 } },
    { 783020, 2, { 940, 833 } },
    { 783090, 2, { 990, 791 } },
    { 783104, 2, { 896, 874 } },
    { 783150, 2, { 1135, 690 } },
    { 783156, 2, { 1047, 748 } },
    { 783180, 2, { 916, 855 } },
    { 783200, 2, { 890, 880 } },
    { 783216, 2, { 888, 882 } },
    { 783240, 2, { 915, 856 } },
    { 783255, 2, { 1111, 705 } },
    { 783288, 2, { 946, 828 } },
    { 783315, 2, { 927, 845 } },
    { 783336, 2, { 1016, 771 } },
    { 783360, 2, { 960, 816 } },
    { 783432, 2, { 936, 837 } },
    { 783475, 2, { 925, 847 } },
    { 783520, 2, { 944, 830 } },
    { 783552, 2, { 924, 848 } },
    { 783624, 2, { 951, 824 } },
    { 783640, 2, { 1096, 715 } },
    { 783660, 2, { 1059, 740 } },
    { 783675, 2, { 1075, 729 } },
    { 783680, 2, { 992, 790 } },
    { 783690, 2, { 906, 865 } },
    { 783720, 2, { 933, 840 } },
    { 783725, 2, { 1081, 725 } },
    { 783728, 2, { 976, 803 } },
    { 783732, 2, { 964, 813 } },
    { 783744, 2, { 942, 832 } },
    { 783768, 2, { 904, 867 } },
    { 783783, 2, { 957, 819 } },
    { 783804, 2, { 903, 868 } },
    { 783870, 2, { 901, 870 } },
    { 783874, 2, { 949, 826 } },
    { 783900, 2, { 900, 871 } },
    { 783959, 2, { 1331, 589 } },
    { 783972, 2, { 918, 854 } },
    { 784000, 2, { 896, 875 } },
    { 784020, 2, { 895, 876 } },
    { 784035, 2, { 917, 855 } },
    { 784056, 2, { 1077, 728 } },
    { 784068, 2, { 892, 879 } },
    { 784080, 2, { 891, 880 } },
    { 784092, 2, { 1083, 724 } },
    { 784098, 2, { 889, 882 } },
    { 784125, 2, { 1025, 765 } },
    { 784160, 2, { 928, 845 } },
    { 784176, 2, { 961, 816 } },
    { 784215, 2, { 999, 785 } },
    { 784245, 2, { 1067, 735 } },
    { 784320, 2, { 912, 860 } },
    { 784336, 2, { 1043, 752 } },
    { 784350, 2, { 945, 830 } },
    { 784400, 2, { 925, 848 } },
    { 784404, 2, { 972, 807 } },
    { 784464, 2, { 944, 831 } },
    { 784476, 2, { 924, 849 } },
    { 784485, 2, { 1053, 745 } },
    { 784536, 2, { 1011, 776 } },
    { 784548, 2, { 1116, 703 } },
    { 784550, 2, { 923, 850 } },
    { 784576, 2, { 943, 832 } },
    { 784641, 2, { 1023, 767 } },
    { 784692, 2, { 921, 852 } },
    { 784700, 2, { 950, 826 } },
    { 784704, 2, { 976, 804 } },
    { 784707, 2, { 903, 869 } },
    { 784740, 2, { 902, 870 } },
    { 784784, 2, { 1001, 784 } },
    { 784845, 2, { 963, 815 } },
    { 784875, 2, { 897, 875 } },
    { 784890, 2, { 918, 855 } },
    { 784896, 2, { 896, 876 } },
    { 784905, 2, { 1005, 781 } },
    { 784952, 2, { 917, 856 } },
    { 784980, 2, { 890, 882 } },
    { 785000, 2, { 1000, 785 } },
    { 785004, 2, { 939, 836 } },
    { 785008, 2, { 1141, 688 } },
    { 785010, 2, { 955, 822 } },
    { 785088, 2, { 928, 846 } },
    { 785106, 2, { 938, 837 } },
    { 785124, 2, { 1017, 772 } },
    { 785169, 2, { 927, 847 } },
    { 785180, 2, { 913, 860 } },
    { 785200, 2, { 1040, 755 } },
    { 785213, 2, { 2431, 323 } },
    { 785232, 2, { 912, 861 } },
    { 785323, 2, { 1457, 539 } },
    { 785349, 2, { 1003, 783 } },
    { 785376, 2, { 909, 864 } },
    { 785400, 2, { 924, 850 } },
    { 785421, 2, { 959, 819 } },
    { 785460, 2, { 988, 795 } },
    { 785512, 2, { 1079, 728 } },
    { 785519, 2, { 943, 833 } },
    { 785536, 2, { 1088, 722 } },
    { 785568, 2, { 1002, 784 } },
    { 785610, 2, { 903, 870 } },
    { 785642, 2, { 902, 871 } },
    { 785652, 2, { 987, 796 } },
    { 785655, 2, { 1027, 765 } },
    { 785664, 2, { 992, 792 } },
    { 785676, 2, { 932, 843 } },
    { 785680, 2, { 920, 854 } },
    { 785700, 2, { 900, 873 } },
    { 785726, 2, { 899, 874 } },
    { 785757, 2, { 1207, 651 } },
    { 785772, 2, { 897, 876 } },
    { 785808, 2, { 918, 856 } },
    { 785840, 2, { 893, 880 } },
    { 785844, 2, { 996, 789 } },
    { 785850, 2, { 930, 845 } },
    { 785880, 2, { 888, 885 } },
    { 785890, 2, { 1030, 763 } },
    { 785954, 2, { 962, 817 } },
    { 785970, 2, { 1065, 738 } },
    { 786000, 2, { 1000, 786 } },
    { 786016, 2, { 928, 847 } },
    { 786030, 2, { 985, 798 } },
    { 786048, 2, { 1068, 736 } },
    { 786093, 2, { 913, 861 } },
    { 786096, 2, { 927, 848 } },
    { 786132, 2, { 1004, 783 } },
    { 786156, 2, { 1029, 764 } },
    { 786175, 2, { 1025, 767 } },
    { 786184, 2, { 973, 808 } },
    { 786216, 2, { 984, 799 } },
    { 786240, 2, { 910, 864 } },
    { 786258, 2, { 1083, 726 } },
    { 786285, 2, { 909, 865 } },
    { 786324, 2, { 924, 851 } },
    { 786335, 2, { 935, 841 } },
    { 786352, 2, { 944, 833 } },
    { 786357, 2, { 1287, 611 } },
    { 786380, 2, { 959, 820 } },
    { 786384, 2, { 1016, 774 } },
    { 786420, 2, { 1020, 771 } },
    { 786435, 2, { 1417, 555 } },
    { 786450, 2, { 1050, 749 } },
    { 786456, 2, { 993, 792 } },
    { 786480, 2, { 904, 870 } },
    { 786500, 2, { 1100, 715 } },
    { 786513, 2, { 903, 871 } },
    { 786555, 2, { 1135, 693 } },
    { 786570, 2, { 942, 835 } },
    { 786588, 2, { 1111, 708 } },
    { 786600, 2, { 900, 874 } },
    { 786625, 2, { 899, 875 } },
    { 786720, 2, { 894, 880 } },
    { 786765, 2, { 889, 885 } },
    { 786807, 2, { 1267, 621 } },
    { 786828, 2, { 969, 812 } },
    { 786840, 2, { 948, 830 } },
    { 786842, 2, { 1147, 686 } },
    { 786864, 2, { 1014, 776 } },
    { 786900, 2, { 915, 860 } },
    { 786915, 2, { 1005, 783 } },
    { 786920, 2, { 955, 824 } },
    { 786940, 2, { 980, 803 } },
    { 786942, 2, { 1026, 767 } },
    { 786968, 2, { 1081, 728 } },
    { 786984, 2, { 968, 813 } },
    { 786996, 2, { 1041, 756 } },
    { 787050, 2, { 954, 825 } },
    { 787059, 2, { 961, 819 } },
    { 787072, 2, { 946, 832 } },
    { 787083, 2, { 1037, 759 } },
    { 787116, 2, { 979, 804 } },
    { 787176, 2, { 936, 841 } },
    { 787185, 2, { 945, 833 } },
    { 787200, 2, { 960, 820 } },
    { 787212, 2, { 999, 788 } },
    { 787236, 2, { 908, 867 } },
    { 787290, 2, { 966, 815 } },
    { 787296, 2, { 944, 834 } },
    { 787332, 2, { 1092, 721 } },
    { 787344, 2, { 1047, 752 } },
    { 787350, 2, { 905, 870 } },
    { 787360, 2, { 1036, 760 } },
    { 787400, 2, { 1016, 775 } },
    { 787416, 2, { 903, 872 } },
    { 787428, 2, { 951, 828 } },
    { 787440, 2, { 965, 816 } },
    { 787452, 2, { 933, 844 } },
    { 787500, 2, { 900, 875 } },
    { 787584, 2, { 896, 879 } },
    { 787600, 2, { 895, 880 } },
    { 787626, 2, { 893, 882 } },
    { 787632, 2, { 976, 807 } },
    { 787644, 2, { 891, 884 } },
    { 787710, 2, { 930, 847 } },
    { 787788, 2, { 948, 831 } },
    { 787800, 2, { 975, 808 } },
    { 787836, 2, { 996, 791 } },
    { 787865, 2, { 1105, 713 } },
    { 787872, 2, { 928, 849 } },
    { 787878, 2, { 962, 819 } },
    { 787896, 2, { 1059, 744 } },
    { 787920, 2, { 938, 840 } },
    { 787930, 2, { 1045, 754 } },
    { 788000, 2, { 985, 800 } },
    { 788004, 2, { 954, 826 } },
    { 788018, 2, { 946, 833 } },
    { 788049, 2, { 1081, 729 } },
    { 788085, 2, { 1055, 747 } },
    { 788095, 2, { 979, 805 } },
    { 788100, 2, { 925, 852 } },
    { 788120, 2, { 1037, 760 } },
    { 788125, 2, { 1261, 625 } },
    { 788175, 2, { 1017, 775 } },
    { 788184, 2, { 984, 801 } },
    { 788216, 2, { 1144, 689 } },
    { 788240, 2, { 944, 835 } },
    { 788242, 2, { 923, 854 } },
    { 788307, 2, { 1131, 697 } },
    { 788364, 2, { 1077, 732 } },
    { 788375, 2, { 901, 875 } },
    { 788376, 2, { 921, 856 } },
    { 788392, 2, { 1054, 748 } },
    { 788425, 2, { 1175, 671 } },
    { 788480, 2, { 896, 880 } },
    { 788481, 2, { 1007, 783 } },
    { 788535, 2, { 891, 885 } },
    { 788568, 2, { 957, 824 } },
    { 788580, 2, { 1011, 780 } },
    { 788620, 2, { 917, 860 } },
    { 788640, 2, { 930, 848 } },
    { 788676, 2, { 916, 861 } },
    { 788700, 2, { 956, 825 } },
    { 788724, 2, { 981, 804 } },
    { 788736, 2, { 948, 832 } },
    { 788760, 2, { 939, 840 } },
    { 788800, 2, { 928, 850 } },
    { 788832, 2, { 913, 864 } },
    { 788880, 2, { 912, 865 } },
    { 788920, 2, { 968, 815 } },
    { 788970, 2, { 910, 867 } },
    { 788985, 2, { 985, 801 } },
    { 789000, 2, { 1000, 789 } },
    { 789012, 2, { 909, 868 } },
    { 789048, 2, { 936, 843 } },
    { 789061, 2, { 1183, 667 } },
    { 789075, 2, { 945, 835 } },
    { 789120, 2, { 960, 822 } },
    { 789160, 2, { 905, 872 } },
    { 789165, 2, { 923, 855 } },
    { 789192, 2, { 904, 873 } },
    { 789210, 2, { 999, 790 } },
    { 789243, 2, { 1029, 767 } },
    { 789250, 2, { 902, 875 } },
    { 789264, 2, { 972, 812 } },
    { 789291, 2, { 943, 837 } },
    { 789327, 2, { 1071, 737 } },
    { 789360, 2, { 897, 880 } },
    { 789390, 2, { 895, 882 } },
    { 789412, 2, { 893, 884 } },
    { 789420, 2, { 892, 885 } },
    { 789432, 2, { 889, 888 } },
    { 789480, 2, { 918, 860 } },
    { 789488, 2, { 931, 848 } },
    { 789495, 2, { 1095, 721 } },
    { 789504, 2, { 1024, 771 } },
    { 789507, 2, { 1083, 729 } },
    { 789516, 2, { 964, 819 } },
    { 789525, 2, { 957, 825 } },
    { 789568, 2, { 949, 832 } },
    { 789579, 2, { 1057, 747 } },
    { 789600, 2, { 940, 840 } },
    { 789660, 2, { 963, 820 } },
    { 789684, 2, { 948, 833 } },
    { 789705, 2, { 981, 805 } },
    { 789728, 2, { 928, 851 } },
    { 789750, 2, { 975, 810 } },
    { 789756, 2, { 1023, 772 } },
    { 789804, 2, { 927, 852 } },
    { 789906, 2, { 1014, 779 } },
    { 789950, 2, { 925, 854 } },
    { 790020, 2, { 924, 855 } },
    { 790032, 2, { 906, 872 } },
    { 790050, 2, { 1145, 690 } },
    { 790065, 2, { 905, 873 } },
    { 790125, 2, { 903, 875 } },
    { 790128, 2, { 944, 837 } },
    { 790209, 2, { 999, 791 } },
    { 790216, 2, { 959, 824 } },
    { 790224, 2, { 978, 808 } },
    { 790230, 2, { 994, 795 } },
    { 790236, 2, { 972, 813 } },
    { 790272, 2, { 896, 882 } },
    { 790320, 2, { 890, 888 } },
    { 790335, 2, { 965, 819 } },
    { 790398, 2, { 918, 861 } },
    { 790400, 2, { 950, 832 } },
    { 790428, 2, { 993, 796 } },
    { 790438, 2, { 1159, 682 } },
    { 790464, 2, { 1074, 736 } },
    { 790517, 2, { 949, 833 } },
    { 790533, 2, { 1273, 621 } },
    { 790560, 2, { 915, 864 } },
    { 790608, 2, { 1086, 728 } },
    { 790625, 2, { 1265, 625 } },
    { 790656, 2, { 928, 852 } },
    { 790685, 2, { 1015, 779 } },
    { 790704, 2, { 912, 867 } },
    { 790713, 2, { 1141, 693 } },
    { 790740, 2, { 955, 828 } },
    { 790790, 2, { 910, 869 } },
    { 790860, 2, { 980, 807 } },
    { 790875, 2, { 925, 855 } },
    { 790920, 2, { 936, 845 } },
    { 791000, 2, { 904, 875 } },
    { 791010, 2, { 935, 846 } },
    { 791028, 2, { 903, 876 } },
    { 791100, 2, { 900, 879 } },
    { 791112, 2, { 952, 831 } },
    { 791120, 2, { 899, 880 } },
    { 791154, 2, { 897, 882 } },
    { 791160, 2, { 1041, 760 } },
    { 791175, 2, { 959, 825 } },
    { 791184, 2, { 933, 848 } },
    { 791208, 2, { 891, 888 } },
    { 791210, 2, { 890, 889 } },
    { 791232, 2, { 951, 832 } },
    { 791240, 2, { 1048, 755 } },
    { 791245, 2, { 1295, 611 } },
    { 791250, 2, { 1055, 750 } },
    { 791268, 2, { 932, 849 } },
    { 791280, 2, { 942, 840 } },
    { 791350, 2, { 931, 850 } },
    { 791388, 2, { 988, 801 } },
    { 791430, 2, { 930, 851 } },
    { 791505, 2, { 1107, 715 } },
    { 791520, 2, { 970, 816 } },
    { 791532, 2, { 1047, 756 } },
    { 791544, 2, { 1032, 767 } },
    { 791580, 2, { 948, 835 } },
    { 791616, 2, { 912, 868 } },
    { 791673, 2, { 969, 817 } },
    { 791714, 2, { 1067, 742 } },
    { 791780, 2, { 1180, 671 } },
    { 791800, 2, { 925, 856 } },
    { 791802, 2, { 946, 837 } },
    { 791820, 2, { 954, 830 } },
    { 791856, 2, { 936, 846 } },
    { 791934, 2, { 923, 858 } },
    { 791940, 2, { 985, 804 } },
    { 792000, 2, { 900, 880 } },
    { 792050, 2, { 1022, 775 } },
    { 792060, 2, { 921, 860 } },
    { 792064, 2, { 896, 884 } },
    { 792099, 2, { 891, 889 } },
    { 792120, 2, { 920, 861 } },
    { 792132, 2, { 1059, 748 } },
    { 792156, 2, { 1004, 789 } },
    { 792180, 2, { 972, 815 } },
    { 792207, 2, { 999, 793 } },
    { 792275, 2, { 1075, 737 } },
    { 792281, 2, { 931, 851 } },
    { 792288, 2, { 917, 864 } },
    { 792350, 2, { 1150, 689 } },
    { 792396, 2, { 957, 828 } },
    { 792420, 2, { 940, 843 } },
    { 792484, 2, { 913, 868 } },
    { 792512, 2, { 928, 854 } },
    { 792516, 2, { 939, 844 } },
    { 792528, 2, { 912, 869 } },
    { 792540, 2, { 1020, 777 } },
    { 792561, 2, { 987, 803 } },
    { 792576, 2, { 1024, 774 } },
    { 792608, 2, { 992, 799 } },
    { 792610, 2, { 910, 871 } },
    { 792624, 2, { 1011, 784 } },
    { 792648, 2, { 909, 872 } },
    { 792672, 2, { 1077, 736 } },
    { 792680, 2, { 1043, 760 } },
    { 792684, 2, { 908, 873 } },
    { 792715, 2, { 1015, 781 } },
    { 792750, 2, { 906, 875 } },
    { 792756, 2, { 1083, 732 } },
    { 792765, 2, { 1115, 711 } },
    { 792780, 2, { 905, 876 } },
    { 792792, 2, { 924, 858 } },
    { 792825, 2, { 961, 825 } },
    { 792880, 2, { 901, 880 } },
    { 792918, 2, { 899, 882 } },
    { 792948, 2, { 897, 884 } },
    { 792960, 2, { 896, 885 } },
    { 792984, 2, { 893, 888 } },
    { 792990, 2, { 891, 890 } },
    { 793000, 2, { 1000, 793 } },
    { 793065, 2, { 1079, 735 } },
    { 793078, 2, { 1034, 767 } },
    { 793117, 2, { 2197, 361 } },
    { 793135, 2, { 1085, 731 } },
    { 793152, 2, { 918, 864 } },
    { 793212, 2, { 931, 852 } },
    { 793230, 2, { 965, 822 } },
    { 793254, 2, { 1111, 714 } },
    { 793260, 2, { 1017, 780 } },
    { 793350, 2, { 1025, 774 } },
    { 793364, 2, { 949, 836 } },
    { 793408, 2, { 1012, 784 } },
    { 793440, 2, { 912, 870 } },
    { 793476, 2, { 948, 837 } },
    { 793485, 2, { 1145, 693 } },
    { 793488, 2, { 976, 813 } },
    { 793500, 2, { 1058, 750 } },
    { 793512, 2, { 927, 856 } },
    { 793548, 2, { 938, 846 } },
    { 793584, 2, { 1002, 792 } },
    { 793611, 2, { 969, 819 } },
    { 793650, 2, { 925, 858 } },
    { 793702, 2, { 1157, 686 } },
    { 793730, 2, { 986, 805 } },
    { 793760, 2, { 902, 880 } },
    { 793780, 2, { 923, 860 } },
    { 793793, 2, { 1001, 793 } },
    { 793800, 2, { 900, 882 } },
    { 793848, 2, { 1023, 776 } },
    { 793872, 2, { 894, 888 } },
    { 793940, 2, { 1060, 749 } },
    { 793968, 2, { 952, 834 } },
    { 794010, 2, { 995, 798 } },
    { 794052, 2, { 959, 828 } },
    { 794070, 2, { 918, 865 } },
    { 794088, 2, { 984, 807 } },
    { 794112, 2, { 1034, 768 } },
    { 794124, 2, { 972, 817 } },
    { 794144, 2, { 1079, 736 } },
    { 794172, 2, { 916, 867 } },
    { 794205, 2, { 999, 795 } },
    { 794220, 2, { 915, 868 } },
    { 794240, 2, { 1088, 730 } },
    { 794310, 2, { 913, 870 } },
    { 794313, 2, { 949, 837 } },
    { 794325, 2, { 1275, 623 } },
    { 794339, 2, { 1247, 637 } },
    { 794352, 2, { 912, 871 } },
    { 794376, 2, { 1003, 792 } },
    { 794385, 2, { 1143, 695 } },
    { 794388, 2, { 1029, 772 } },
    { 794400, 2, { 993, 800 } },
    { 794436, 2, { 956, 831 } },
    { 794560, 2, { 955, 832 } },
    { 794580, 2, { 969, 820 } },
    { 794592, 2, { 992, 801 } },
    { 794600, 2, { 1096, 725 } },
    { 794616, 2, { 904, 879 } },
    { 794640, 2, { 903, 880 } },
    { 794664, 2, { 936, 849 } },
    { 794682, 2, { 901, 882 } },
    { 794703, 2, { 923, 861 } },
    { 794716, 2, { 899, 884 } },
    { 794745, 2, { 945, 841 } },
    { 794760, 2, { 895, 888 } },
    { 794772, 2, { 892, 891 } },
    { 794864, 2, { 1057, 752 } },
    { 794880, 2, { 920, 864 } },
    { 794898, 2, { 1027, 774 } },
    { 794916, 2, { 933, 852 } },
    { 794920, 2, { 952, 835 } },
    { 794948, 2, { 979, 812 } },
    { 794955, 2, { 1005, 791 } },
    { 794970, 2, { 990, 803 } },
    { 794976, 2, { 1014, 784 } },
    { 795000, 2, { 1000, 795 } },
    { 795015, 2, { 1053, 755 } },
    { 795025, 2, { 1225, 649 } },
    { 795036, 2, { 951, 836 } },
    { 795080, 2, { 1112, 715 } },
    { 795093, 2, { 1073, 741 } },
    { 795135, 2, { 915, 869 } },
    { 795160, 2, { 965, 824 } },
    { 795200, 2, { 994, 800 } },
    { 795204, 2, { 999, 796 } },
    { 795285, 2, { 1161, 685 } },
    { 795300, 2, { 964, 825 } },
    { 795312, 2, { 1008, 789 } },
    { 795324, 2, { 1041, 764 } },
    { 795328, 2, { 1088, 731 } },
    { 795340, 2, { 910, 874 } },
    { 795375, 2, { 909, 875 } },
    { 795424, 2, { 938, 848 } },
    { 795440, 2, { 976, 815 } },
    { 795501, 2, { 1281, 621 } },
    { 795528, 2, { 1016, 783 } },
    { 795564, 2, { 902, 882 } },
    { 795600, 2, { 900, 884 } },
    { 795625, 2, { 1273, 625 } },
    { 795627, 2, { 1211, 657 } },
    { 795648, 2, { 896, 888 } },
    { 795663, 2, { 893, 891 } },
    { 795685, 2, { 935, 851 } },
    { 795696, 2, { 968, 822 } },
    { 795708, 2, { 961, 828 } },
    { 795720, 2, { 1047, 760 } },
    { 795744, 2, { 921, 864 } },
    { 795792, 2, { 944, 843 } },
    { 795795, 2, { 1001, 795 } },
    { 795800, 2, { 920, 865 } },
    { 795872, 2, { 952, 836 } },
    { 795880, 2, { 985, 808 } },
    { 795925, 2, { 1027, 775 } },
    { 795938, 2, { 1331, 598 } },
    { 795970, 2, { 959, 830 } },
    { 795984, 2, { 966, 824 } },
    { 795990, 2, { 942, 845 } },
    { 796000, 2, { 995, 800 } },
    { 796005, 2, { 931, 855 } },
    { 796059, 2, { 1089, 731 } },
    { 796068, 2, { 972, 819 } },
    { 796080, 2, { 930, 856 } },
    { 796110, 2, { 1115, 714 } },
    { 796145, 2, { 989, 805 } },
    { 796176, 2, { 912, 873 } },
    { 796180, 2, { 940, 847 } },
    { 796195, 2, { 1445, 551 } },
    { 796224, 2, { 928, 858 } },
    { 796250, 2, { 910, 875 } },
    { 796272, 2, { 939, 848 } },
    { 796284, 2, { 909, 876 } },
    { 796290, 2, { 1045, 762 } },
    { 796368, 2, { 1059, 752 } },
    { 796400, 2, { 905, 880 } },
    { 796425, 2, { 925, 861 } },
    { 796470, 2, { 955, 834 } },
    { 796484, 2, { 901, 884 } },
    { 796500, 2, { 900, 885 } },
    { 796536, 2, { 897, 888 } },
    { 796544, 2, { 896, 889 } },
    { 796572, 2, { 981, 812 } },
    { 796575, 2, { 975, 817 } },
    { 796576, 2, { 992, 803 } },
    { 796590, 2, { 954, 835 } },
    { 796620, 2, { 935, 852 } },
    { 796668, 2, { 1011, 788 } },
    { 796740, 2, { 980, 813 } },
    { 796770, 2, { 1135, 702 } },
    { 796800, 2, { 960, 830 } },
    { 796824, 2, { 918, 868 } },
    { 796835, 2, { 943, 845 } },
    { 796860, 2, { 932, 855 } },
    { 796887, 2, { 973, 819 } },
    { 796917, 2, { 1023, 779 } },
    { 796936, 2, { 931, 856 } },
    { 796950, 2, { 966, 825 } },
    { 796965, 2, { 915, 871 } },
    { 796980, 2, { 1077, 740 } },
    { 796995, 2, { 995, 801 } },
    { 797040, 2, { 972, 820 } },
    { 797088, 2, { 912, 874 } },
    { 797134, 2, { 989, 806 } },
    { 797148, 2, { 1089, 732 } },
    { 797160, 2, { 910, 876 } },
    { 797181, 2, { 957, 833 } },
    { 797184, 2, { 1038, 768 } },
    { 797220, 2, { 927, 860 } },
    { 797280, 2, { 906, 880 } },
    { 797300, 2, { 938, 850 } },
    { 797316, 2, { 988, 807 } },
    { 797328, 2, { 904, 882 } },
    { 797364, 2, { 963, 828 } },
    { 797440, 2, { 896, 890 } },
    { 797445, 2, { 895, 891 } },
    { 797472, 2, { 923, 864 } },
    { 797475, 2, { 1029, 775 } },
    { 797496, 2, { 987, 808 } },
    { 797525, 2, { 1387, 575 } },
    { 797560, 2, { 1016, 785 } },
    { 797568, 2, { 992, 804 } },
    { 797580, 2, { 945, 844 } },
    { 797640, 2, { 920, 867 } },
    { 797650, 2, { 1075, 742 } },
    { 797680, 2, { 944, 845 } },
    { 797685, 2, { 1065, 749 } },
    { 797696, 2, { 1024, 779 } },
    { 797720, 2, { 980, 814 } },
    { 797742, 2, { 918, 869 } },
    { 797760, 2, { 960, 831 } },
    { 797790, 2, { 917, 870 } },
    { 797796, 2, { 996, 801 } },
    { 797810, 2, { 1105, 722 } },
    { 797825, 2, { 1175, 679 } },
    { 797850, 2, { 985, 810 } },
    { 797860, 2, { 973, 820 } },
    { 797880, 2, { 915, 872 } },
    { 797888, 2, { 959, 832 } },
    { 797895, 2, { 1043, 765 } },
    { 797979, 2, { 1027, 777 } },
    { 798000, 2, { 912, 875 } },
    { 798048, 2, { 978, 816 } },
    { 798060, 2, { 940, 849 } },
    { 798080, 2, { 928, 860 } },
    { 798132, 2, { 908, 879 } },
    { 798180, 2, { 1004, 795 } },
    { 798182, 2, { 994, 803 } },
    { 798201, 2, { 999, 799 } },
    { 798210, 2, { 905, 882 } },
    { 798252, 2, { 903, 884 } },
    { 798255, 2, { 1095, 729 } },
    { 798336, 2, { 896, 891 } },
    { 798345, 2, { 1017, 785 } },
    { 798372, 2, { 993, 804 } },
    { 798399, 2, { 1197, 667 } },
    { 798456, 2, { 969, 824 } },
    { 798468, 2, { 1012, 789 } },
    { 798504, 2, { 1029, 776 } },
    { 798525, 2, { 945, 845 } },
    { 798560, 2, { 920, 868 } },
    { 798576, 2, { 1016, 786 } },
    { 798600, 2, { 968, 825 } },
    { 798624, 2, { 944, 846 } },
    { 798640, 2, { 1072, 745 } },
    { 798648, 2, { 933, 856 } },
    { 798660, 2, { 918, 870 } },
    { 798721, 2, { 943, 847 } },
    { 798756, 2, { 1028, 777 } },
    { 798765, 2, { 1133, 705 } },
    { 798816, 2, { 942, 848 } },
    { 798840, 2, { 951, 840 } },
    { 798864, 2, { 979, 816 } },
    { 798875, 2, { 913, 875 } },
    { 798910, 2, { 1010, 791 } },
    { 798912, 2, { 912, 876 } },
    { 798950, 2, { 950, 841 } },
    { 799008, 2, { 928, 861 } },
    { 799020, 2, { 965, 828 } },
    { 799056, 2, { 1074, 744 } },
    { 799085, 2, { 1343, 595 } },
    { 799164, 2, { 948, 843 } },
    { 799227, 2, { 897, 891 } },
    { 799254, 2, { 1026, 779 } },
    { 799260, 2, { 924, 865 } },
    { 799296, 2, { 1086, 736 } },
    { 799335, 2, { 955, 837 } },
    { 799344, 2, { 936, 854 } },
    { 799425, 2, { 935, 855 } },
    { 799428, 2, { 921, 868 } },
    { 799456, 2, { 1162, 688 } },
    { 799480, 2, { 920, 869 } },
    { 799488, 2, { 1041, 768 } },
    { 799500, 2, { 975, 820 } },
    { 799515, 2, { 981, 815 } },
    { 799552, 2, { 961, 832 } },
    { 799568, 2, { 944, 847 } },
    { 799578, 2, { 918, 871 } },
    { 799624, 2, { 917, 872 } },
    { 799645, 2, { 1085, 737 } },
    { 799668, 2, { 916, 873 } },
    { 799680, 2, { 952, 840 } },
    { 799744, 2, { 1024, 781 } },
    { 799788, 2, { 913, 876 } },
    { 799799, 2, { 1001, 799 } },
    { 799825, 2, { 1391, 575 } },
    { 799908, 2, { 1047, 764 } },
    { 799920, 2, { 909, 880 } },
    { 799929, 2, { 1161, 689 } },
    { 799932, 2, { 1068, 749 } },
    { 799980, 2, { 995, 804 } },
    { 799992, 2, { 984, 813 } },
    { 800028, 2, { 939, 852 } },
    { 800040, 2, { 904, 885 } },
    { 800052, 2, { 957, 836 } },
    { 800072, 2, { 1099, 728 } },
    { 800088, 2, { 901, 888 } },
    { 800100, 2, { 900, 889 } },
    { 800124, 2, { 897, 892 } },
    { 800128, 2, { 896, 893 } },
    { 800130, 2, { 895, 894 } },
    { 800172, 2, { 956, 837 } },
    { 800226, 2, { 1022, 783 } },
    { 800280, 2, { 936, 855 } },
    { 800360, 2, { 935, 856 } },
    { 800384, 2, { 962, 832 } },
    { 800400, 2, { 920, 870 } },
    { 800415, 2, { 945, 847 } },
    { 800496, 2, { 918, 872 } },
    { 800513, 2, { 961, 833 } },
    { 800525, 2, { 1025, 781 } },
    { 800541, 2, { 917, 873 } },
    { 800544, 2, { 992, 807 } },
    { 800604, 2, { 1059, 756 } },
    { 800618, 2, { 1079, 742 } },
    { 800632, 2, { 952, 841 } },
    { 800640, 2, { 960, 834 } },
    { 800660, 2, { 931, 860 } },
    { 800667, 2, { 1253, 639 } },
    { 800712, 2, { 1011, 792 } },
    { 800730, 2, { 930, 861 } },
    { 800748, 2, { 1044, 767 } },
    { 800768, 2, { 1024, 782 } },
    { 800800, 2, { 910, 880 } },
    { 800865, 2, { 1369, 585 } },
    { 800928, 2, { 927, 864 } },
    { 800976, 2, { 902, 888 } },
    { 801000, 2, { 900, 890 } },
    { 801009, 2, { 899, 891 } },
    { 801021, 2, { 897, 893 } },
    { 801024, 2, { 896, 894 } },
    { 801040, 2, { 1054, 760 } },
    { 801060, 2, { 948, 845 } },
    { 801084, 2, { 964, 831 } },
    { 801090, 2, { 989, 810 } },
    { 801108, 2, { 924, 867 } },
    { 801150, 2, { 1050, 763 } },
    { 801164, 2, { 923, 868 } },
    { 801171, 2, { 1099, 729 } },
    { 801248, 2, { 1022, 784 } },
    { 801288, 2, { 1077, 744 } },
    { 801297, 2, { 1127, 711 } },
    { 801306, 2, { 1026, 781 } },
    { 801320, 2, { 920, 871 } },
    { 801346, 2, { 962, 833 } },
    { 801350, 2, { 1034, 775 } },
    { 801360, 2, { 945, 848 } },
    { 801396, 2, { 1017, 788 } },
    { 801420, 2, { 1083, 740 } },
    { 801444, 2, { 987, 812 } },
    { 801456, 2, { 944, 849 } },
    { 801515, 2, { 1045, 767 } },
    { 801540, 2, { 915, 876 } },
    { 801550, 2, { 943, 850 } },
    { 801600, 2, { 960, 835 } },
    { 801624, 2, { 1016, 789 } },
    { 801648, 2, { 912, 879 } },
    { 801735, 2, { 1243, 645 } },
    { 801752, 2, { 973, 824 } },
    { 801801, 2, { 979, 819 } },
    { 801855, 2, { 927, 865 } },
    { 801864, 2, { 903, 888 } },
    { 801900, 2, { 900, 891 } },
    { 801920, 2, { 896, 895 } },
    { 801990, 2, { 938, 855 } },
    { 802125, 2, { 1035, 775 } },
    { 802164, 2, { 1133, 708 } },
    { 802165, 2, { 1435, 559 } },
    { 802179, 2, { 963, 833 } },
    { 802197, 2, { 999, 803 } },
    { 802200, 2, { 955, 840 } },
    { 802230, 2, { 935, 858 } },
    { 802272, 2, { 976, 822 } },
    { 802332, 2, { 918, 874 } },
    { 802344, 2, { 993, 808 } },
    { 802375, 2, { 917, 875 } },
    { 802380, 2, { 933, 860 } },
    { 802400, 2, { 944, 850 } },
    { 802424, 2, { 1127, 712 } },
    { 802452, 2, { 932, 861 } },
    { 802516, 2, { 1012, 793 } },
    { 802536, 2, { 952, 843 } },
    { 802575, 2, { 1025, 783 } },
    { 802620, 2, { 910, 882 } },
    { 802638, 2, { 1037, 774 } },
    { 802644, 2, { 951, 844 } },
    { 802655, 2, { 1207, 665 } },
    { 802683, 2, { 959, 837 } },
    { 802720, 2, { 928, 865 } },
    { 802725, 2, { 973, 825 } },
    { 802760, 2, { 940, 854 } },
    { 802791, 2, { 901, 891 } },
    { 802854, 2, { 949, 846 } },
    { 802872, 2, { 972, 826 } },
    { 802880, 2, { 965, 832 } },
    { 802956, 2, { 924, 869 } },
    { 803000, 2, { 1000, 803 } },
    { 803010, 2, { 923, 870 } },
    { 803025, 2, { 1075, 747 } },
    { 803068, 2, { 989, 812 } },
    { 803088, 2, { 936, 858 } },
    { 803110, 2, { 1043, 770 } },
    { 803112, 2, { 921, 872 } },
    { 803136, 2, { 1068, 752 } },
    { 803160, 2, { 920, 873 } },
    { 803187, 2, { 1159, 693 } },
    { 803196, 2, { 999, 804 } },
    { 803225, 2, { 1691, 475 } },
    { 803244, 2, { 988, 813 } },
    { 803250, 2, { 918, 875 } },
    { 803264, 2, { 1141, 704 } },
    { 803292, 2, { 917, 876 } },
    { 803320, 2, { 1057, 760 } },
    { 803396, 2, { 961, 836 } },
    { 803400, 2, { 975, 824 } },
    { 803440, 2, { 913, 880 } },
    { 803520, 2, { 930, 864 } },
    { 803551, 2, { 1127, 713 } },
    { 803556, 2, { 909, 884 } },
    { 803580, 2, { 908, 885 } },
    { 803586, 2, { 1007, 798 } },
    { 803640, 2, { 905, 888 } },
    { 803649, 2, { 1029, 781 } },
    { 803652, 2, { 1041, 772 } },
    { 803656, 2, { 904, 889 } },
    { 803675, 2, { 1037, 775 } },
    { 803682, 2, { 902, 891 } },
    { 803700, 2, { 900, 893 } },
    { 803712, 2, { 897, 896 } },
    { 803760, 2, { 985, 816 } },
    { 803772, 2, { 996, 807 } },
    { 803784, 2, { 939, 856 } },
    { 803790, 2, { 1145, 702 } },
    { 803803, 2, { 949, 847 } },
    { 803825, 2, { 925, 869 } },
    { 803840, 2, { 1024, 785 } },
    { 803862, 2, { 1207, 666 } },
    { 803904, 2, { 948, 848 } },
    { 803910, 2, { 1055, 762 } },
    { 803928, 2, { 984, 817 } },
    { 803960, 2, { 995, 808 } },
    { 804096, 2, { 1047, 768 } },
    { 804105, 2, { 963, 835 } },
    { 804141, 2, { 1027, 783 } },
    { 804195, 2, { 945, 851 } },
    { 804204, 2, { 1004, 801 } },
    { 804232, 2, { 962, 836 } },
    { 804264, 2, { 1081, 744 } },
    { 804272, 2, { 1169, 688 } },
    { 804287, 2, { 2057, 391 } },
    { 804288, 2, { 944, 852 } },
    { 804384, 2, { 912, 882 } },
    { 804408, 2, { 968, 831 } },
    { 804420, 2, { 981, 820 } },
    { 804440, 2, { 910, 884 } },
    { 804450, 2, { 930, 865 } },
    { 804492, 2, { 1053, 764 } },
    { 804528, 2, { 906, 888 } },
    { 804540, 2, { 1012, 795 } },
    { 804573, 2, { 903, 891 } },
    { 804576, 2, { 928, 867 } },
    { 804615, 2, { 1185, 679 } },
    { 804636, 2, { 927, 868 } },
    { 804650, 2, { 950, 847 } },
    { 804750, 2, { 925, 870 } },
    { 804752, 2, { 949, 848 } },
    { 804756, 2, { 1011, 796 } },
    { 804780, 2, { 1020, 789 } },
    { 804804, 2, { 924, 871 } },
    { 804810, 2, { 965, 834 } },
    { 804840, 2, { 1059, 760 } },
    { 804852, 2, { 948, 849 } },
    { 804864, 2, { 1024, 786 } },
    { 804895, 2, { 1015, 793 } },
    { 804924, 2, { 1028, 783 } },
    { 804960, 2, { 936, 860 } },
    { 805000, 2, { 920, 875 } },
    { 805068, 2, { 963, 836 } },
    { 805120, 2, { 1088, 740 } },
    { 805140, 2, { 945, 852 } },
    { 805164, 2, { 916, 879 } },
    { 805168, 2, { 1027, 784 } },
    { 805175, 2, { 1075, 749 } },
    { 805194, 2, { 962, 837 } },
    { 805200, 2, { 915, 880 } },
    { 805266, 2, { 913, 882 } },
    { 805392, 2, { 952, 846 } },
    { 805464, 2, { 904, 891 } },
    { 805475, 2, { 1111, 725 } },
    { 805476, 2, { 903, 892 } },
    { 805486, 2, { 902, 893 } },
    { 805488, 2, { 1038, 776 } },
    { 805500, 2, { 900, 895 } },
    { 805504, 2, { 899, 896 } },
    { 805545, 2, { 1053, 765 } },
    { 805560, 2, { 959, 840 } },
    { 805562, 2, { 986, 817 } },
    { 805596, 2, { 1077, 748 } },
    { 805600, 2, { 950, 848 } },
    { 805650, 2, { 1025, 786 } },
    { 805675, 2, { 925, 871 } },
    { 805707, 2, { 1029, 783 } },
    { 805749, 2, { 1037, 777 } },
    { 805752, 2, { 1083, 744 } },
    { 805800, 2, { 948, 850 } },
    { 805860, 2, { 990, 814 } },
    { 805872, 2, { 978, 824 } },
    { 805896, 2, { 936, 861 } },
    { 805908, 2, { 956, 843 } },
    { 805950, 2, { 995, 810 } },
    { 806000, 2, { 1000, 806 } },
    { 806050, 2, { 1175, 686 } },
    { 806112, 2, { 933, 864 } },
    { 806113, 2, { 1463, 551 } },
    { 806124, 2, { 1023, 788 } },
    { 806130, 2, { 954, 845 } },
    { 806176, 2, { 944, 854 } },
    { 806200, 2, { 1112, 725 } },
    { 806211, 2, { 1337, 603 } },
    { 806250, 2, { 1075, 750 } },
    { 806265, 2, { 943, 855 } },
    { 806274, 2, { 1106, 729 } },
    { 806316, 2, { 993, 812 } },
    { 806344, 2, { 952, 847 } },
    { 806352, 2, { 942, 856 } },
    { 806355, 2, { 905, 891 } },
    { 806379, 2, { 903, 893 } },
    { 806400, 2, { 900, 896 } },
    { 806403, 2, { 899, 897 } },
    { 806432, 2, { 928, 869 } },
    { 806448, 2, { 951, 848 } },
    { 806465, 2, { 1333, 605 } },
    { 806496, 2, { 992, 813 } },
    { 806600, 2, { 925, 872 } },
    { 806610, 2, { 966, 835 } },
    { 806650, 2, { 949, 850 } },
    { 806652, 2, { 924, 873 } },
    { 806680, 2, { 938, 860 } },
    { 806715, 2, { 985, 819 } },
    { 806725, 2, { 1403, 575 } },
    { 806736, 2, { 1029, 784 } },
    { 806760, 2, { 972, 830 } },
    { 806796, 2, { 921, 876 } },
    { 806806, 2, { 1001, 806 } },
    { 806820, 2, { 1020, 791 } },
    { 806868, 2, { 964, 837 } },
    { 806895, 2, { 1161, 695 } },
    { 806949, 2, { 1089, 741 } },
    { 806960, 2, { 917, 880 } },
    { 806985, 2, { 1135, 711 } },
    { 807000, 2, { 1000, 807 } },
    { 807015, 2, { 1005, 803 } },
    { 807024, 2, { 989, 816 } },
    { 807030, 2, { 915, 882 } },
    { 807040, 2, { 970, 832 } },
    { 807044, 2, { 1036, 779 } },
    { 807070, 2, { 1210, 667 } },
    { 807075, 2, { 1055, 765 } },
    { 807120, 2, { 912, 885 } },
    { 807192, 2, { 909, 888 } },
    { 807196, 2, { 988, 817 } },
    { 807296, 2, { 901, 896 } },
    { 807300, 2, { 900, 897 } },
    { 807312, 2, { 968, 834 } },
    { 807360, 2, { 928, 870 } },
    { 807408, 2, { 1008, 801 } },
    { 807415, 2, { 1003, 805 } },
    { 807488, 2, { 992, 814 } },
    { 807495, 2, { 1313, 615 } },
    { 807525, 2, { 925, 873 } },
    { 807534, 2, { 986, 819 } },
    { 807540, 2, { 939, 860 } },
    { 807576, 2, { 924, 874 } },
    { 807590, 2, { 973, 830 } },
    { 807615, 2, { 1179, 685 } },
    { 807625, 2, { 923, 875 } },
    { 807648, 2, { 1074, 752 } },
    { 807651, 2, { 1053, 767 } },
    { 807675, 2, { 979, 825 } },
    { 807705, 2, { 965, 837 } },
    { 807708, 2, { 957, 844 } },
    { 807720, 2, { 1016, 795 } },
    { 807732, 2, { 972, 831 } },
    { 807755, 2, { 1105, 731 } },
    { 807816, 2, { 1041, 776 } },
    { 807840, 2, { 918, 880 } },
    { 807891, 2, { 1241, 651 } },
    { 807930, 2, { 955, 846 } },
    { 807936, 2, { 1024, 789 } },
    { 807984, 2, { 1086, 744 } },
    { 808005, 2, { 913, 885 } },
    { 808010, 2, { 970, 833 } },
    { 808020, 2, { 1005, 804 } },
    { 808038, 2, { 954, 847 } },
    { 808044, 2, { 932, 867 } },
    { 808056, 2, { 1032, 783 } },
    { 808080, 2, { 910, 888 } },
    { 808101, 2, { 909, 889 } },
    { 808110, 2, { 1095, 738 } },
    { 808128, 2, { 976, 828 } },
    { 808170, 2, { 930, 869 } },
    { 808176, 2, { 904, 894 } },
    { 808192, 2, { 902, 896 } },
    { 808197, 2, { 901, 897 } },
    { 808248, 2, { 952, 849 } },
    { 808280, 2, { 968, 835 } },
    { 808284, 2, { 1047, 772 } },
    { 808288, 2, { 928, 871 } },
    { 808325, 2, { 1043, 775 } },
    { 808335, 2, { 1035, 781 } },
    { 808344, 2, { 927, 872 } },
    { 808418, 2, { 1003, 806 } },
    { 808480, 2, { 992, 815 } },
    { 808500, 2, { 924, 875 } },
    { 808588, 2, { 1012, 799 } },
    { 808605, 2, { 1057, 765 } },
    { 808654, 2, { 979, 826 } },
    { 808680, 2, { 920, 879 } },
    { 808704, 2, { 936, 864 } },
    { 808780, 2, { 1060, 763 } },
    { 808794, 2, { 917, 882 } },
    { 808800, 2, { 1011, 800 } },
    { 808808, 2, { 1001, 808 } },
    { 808830, 2, { 946, 855 } },
    { 808848, 2, { 984, 822 } },
    { 808860, 2, { 915, 884 } },
    { 808864, 2, { 1099, 736 } },
    { 808920, 2, { 945, 856 } },
    { 808960, 2, { 1024, 790 } },
    { 808990, 2, { 910, 889 } },
    { 808992, 2, { 954, 848 } },
    { 809028, 2, { 908, 891 } },
    { 809039, 2, { 931, 869 } },
    { 809070, 2, { 905, 894 } },
    { 809076, 2, { 1059, 764 } },
    { 809080, 2, { 904, 895 } },
    { 809088, 2, { 903, 896 } },
    { 809100, 2, { 900, 899 } },
    { 809172, 2, { 988, 819 } },
    { 809217, 2, { 1107, 731 } },
    { 809226, 2, { 1098, 737 } },
    { 809280, 2, { 960, 843 } },
    { 809340, 2, { 940, 861 } },
    { 809360, 2, { 1072, 755 } },
    { 809368, 2, { 1043, 776 } },
    { 809400, 2, { 950, 852 } },
    { 809480, 2, { 980, 826 } },
    { 809490, 2, { 1115, 726 } },
    { 809532, 2, { 1017, 796 } },
    { 809536, 2, { 973, 832 } },
    { 809575, 2, { 1175, 689 } },
    { 809613, 2, { 1267, 639 } },
    { 809616, 2, { 1002, 808 } },
    { 809627, 2, { 1271, 637 } },
    { 809640, 2, { 936, 865 } },
    { 809670, 2, { 985, 822 } },
    { 809748, 2, { 996, 813 } },
    { 809840, 2, { 955, 848 } },
    { 809844, 2, { 933, 868 } },
    { 809904, 2, { 1077, 752 } },
    { 809952, 2, { 944, 858 } },
    { 809970, 2, { 931, 870 } },
    { 810030, 2, { 930, 871 } },
    { 810080, 2, { 976, 830 } },
    { 810084, 2, { 969, 836 } },
    { 810117, 2, { 1169, 693 } },
    { 810144, 2, { 928, 873 } },
    { 810152, 2, { 952, 851 } },
    { 810186, 2, { 1014, 799 } },
    { 810216, 2, { 968, 837 } },
    { 810228, 2, { 1004, 807 } },
    { 810252, 2, { 951, 852 } },
    { 810288, 2, { 993, 816 } },
    { 810300, 2, { 925, 876 } },
    { 810336, 2, { 1101, 736 } },
    { 810390, 2, { 1135, 714 } },
    { 810432, 2, { 938, 864 } },
    { 810446, 2, { 949, 854 } },
    { 810464, 2, { 992, 817 } },
    { 810480, 2, { 921, 880 } },
    { 810495, 2, { 1085, 747 } },
    { 810540, 2, { 948, 855 } },
    { 810560, 2, { 1088, 745 } },
    { 810600, 2, { 965, 840 } },
    { 810612, 2, { 979, 828 } },
    { 810635, 2, { 1007, 805 } },
    { 810656, 2, { 1034, 784 } },
    { 810660, 2, { 916, 885 } },
    { 810700, 2, { 1100, 737 } },
    { 810744, 2, { 913, 888 } },
    { 810750, 2, { 1081, 750 } },
    { 810768, 2, { 912, 889 } },
    { 810775, 2, { 1025, 791 } },
    { 810810, 2, { 910, 891 } },
    { 810828, 2, { 909, 892 } },
    { 810852, 2, { 1029, 788 } },
    { 810870, 2, { 906, 895 } },
    { 810880, 2, { 905, 896 } },
    { 810888, 2, { 904, 897 } },
    { 810900, 2, { 901, 900 } },
    { 810901, 2, { 931, 871 } },
    { 810960, 2, { 930, 872 } },
    { 810985, 2, { 1015, 799 } },
    { 811008, 2, { 1024, 792 } },
    { 811056, 2, { 976, 831 } },
    { 811092, 2, { 1028, 789 } },
    { 811125, 2, { 927, 875 } },
    { 811152, 2, { 1032, 786 } },
    { 811188, 2, { 999, 812 } },
    { 811200, 2, { 960, 845 } },
    { 811239, 2, { 1023, 793 } },
    { 811250, 2, { 1250, 649 } },
    { 811251, 2, { 1141, 711 } },
    { 811296, 2, { 939, 864 } },
    { 811300, 2, { 950, 854 } },
    { 811305, 2, { 1089, 745 } },
    { 811314, 2, { 959, 846 } },
    { 811325, 2, { 1411, 575 } },
    { 811377, 2, { 1113, 729 } },
    { 811395, 2, { 949, 855 } },
    { 811408, 2, { 1079, 752 } },
    { 811410, 2, { 1110, 731 } },
    { 811440, 2, { 920, 882 } },
    { 811536, 2, { 957, 848 } },
    { 811538, 2, { 1183, 686 } },
    { 811545, 2, { 917, 885 } },
    { 811620, 2, { 972, 835 } },
    { 811640, 2, { 985, 824 } },
    { 811642, 2, { 1007, 806 } },
    { 811644, 2, { 956, 849 } },
    { 811680, 2, { 912, 890 } },
    { 811776, 2, { 906, 896 } },
    { 811800, 2, { 902, 900 } },
    { 811832, 2, { 931, 872 } },
    { 811920, 2, { 995, 816 } },
    { 811971, 2, { 1037, 783 } },
    { 811980, 2, { 1041, 780 } },
    { 812000, 2, { 928, 875 } },
    { 812040, 2, { 1005, 808 } },
    { 812045, 2, { 961, 845 } },
    { 812052, 2, { 927, 876 } },
    { 812160, 2, { 940, 864 } },
    { 812175, 2, { 975, 833 } },
    { 812196, 2, { 924, 879 } },
    { 812200, 2, { 1048, 775 } },
    { 812240, 2, { 923, 880 } },
    { 812268, 2, { 981, 828 } },
    { 812383, 2, { 1859, 437 } },
    { 812392, 2, { 1141, 712 } },
    { 812406, 2, { 966, 841 } },
    { 812430, 2, { 918, 885 } },
    { 812448, 2, { 936, 868 } },
    { 812472, 2, { 1047, 776 } },
    { 812475, 2, { 1035, 785 } },
    { 812490, 2, { 1022, 795 } },
    { 812520, 2, { 915, 888 } },
    { 812544, 2, { 1058, 768 } },
    { 812592, 2, { 912, 891 } },
    { 812595, 2, { 1065, 763 } },
    { 812630, 2, { 910, 893 } },
    { 812652, 2, { 964, 843 } },
    { 812668, 2, { 1156, 703 } },
    { 812700, 2, { 903, 900 } },
    { 812702, 2, { 902, 901 } },
    { 812725, 2, { 1121, 725 } },
    { 812736, 2, { 996, 816 } },
    { 812763, 2, { 931, 873 } },
    { 812772, 2, { 963, 844 } },
    { 812784, 2, { 944, 861 } },
    { 812825, 2, { 1025, 793 } },
    { 812835, 2, { 1115, 729 } },
    { 812844, 2, { 1011, 804 } },
    { 812889, 2, { 1071, 759 } },
    { 812916, 2, { 1053, 772 } },
    { 812928, 2, { 928, 876 } },
    { 813000, 2, { 1000, 813 } },
    { 813015, 2, { 1015, 801 } },
    { 813020, 2, { 1060, 767 } },
    { 813120, 2, { 924, 880 } },
    { 813232, 2, { 959, 848 } },
    { 813241, 2, { 1331, 611 } },
    { 813252, 2, { 1111, 732 } },
    { 813276, 2, { 1044, 779 } },
    { 813288, 2, { 987, 824 } },
    { 813312, 2, { 1059, 768 } },
    { 813345, 2, { 1261, 645 } },
    { 813384, 2, { 936, 869 } },
    { 813435, 2, { 915, 889 } },
    { 813440, 2, { 992, 820 } },
    { 813450, 2, { 935, 870 } },
    { 813456, 2, { 1008, 807 } },
    { 813483, 2, { 913, 891 } },
    { 813555, 2, { 909, 895 } },
    { 813564, 2, { 972, 837 } },
    { 813576, 2, { 933, 872 } },
    { 813603, 2, { 903, 901 } },
    { 813618, 2, { 1026, 793 } },
    { 813636, 2, { 932, 873 } },
    { 813645, 2, { 945, 861 } },
    { 813660, 2, { 955, 852 } },
    { 813694, 2, { 931, 874 } },
    { 813696, 2, { 978, 832 } },
    { 813735, 2, { 963, 845 } },
    { 813750, 2, { 930, 875 } },
    { 813792, 2, { 1038, 784 } },
    { 813816, 2, { 1016, 801 } },
    { 813846, 2, { 1121, 726 } },
    { 813888, 2, { 942, 864 } },
    { 813890, 2, { 1057, 770 } },
    { 813904, 2, { 1118, 728 } },
    { 813960, 2, { 952, 855 } },
    { 813967, 2, { 961, 847 } },
    { 813984, 2, { 976, 834 } },
    { 814000, 2, { 925, 880 } },
    { 814016, 2, { 1106, 736 } },
    { 814050, 2, { 1005, 810 } },
    { 814055, 2, { 1045, 779 } },
    { 814056, 2, { 951, 856 } },
    { 814086, 2, { 923, 882 } },
    { 814088, 2, { 968, 841 } },
    { 814095, 2, { 1145, 711 } },
    { 814164, 2, { 921, 884 } },
    { 814185, 2, { 999, 815 } },
    { 814200, 2, { 920, 885 } },
    { 814212, 2, { 1077, 756 } },
    { 814242, 2, { 949, 858 } },
    { 814248, 2, { 1032, 789 } },
    { 814260, 2, { 993, 820 } },
    { 814275, 2, { 987, 825 } },
    { 814296, 2, { 917, 888 } },
    { 814308, 2, { 1023, 796 } },
    { 814320, 2, { 936, 870 } },
    { 814380, 2, { 980, 831 } },
    { 814385, 2, { 935, 871 } },
    { 814401, 2, { 973, 837 } },
    { 814407, 2, { 957, 851 } },
    { 814416, 2, { 912, 893 } },
    { 814464, 2, { 909, 896 } },
    { 814476, 2, { 908, 897 } },
    { 814500, 2, { 905, 900 } },
    { 814528, 2, { 979, 832 } },
    { 814572, 2, { 1089, 748 } },
    { 814625, 2, { 931, 875 } },
    { 814653, 2, { 1351, 603 } },
    { 814716, 2, { 954, 854 } },
    { 814730, 2, { 1030, 791 } },
    { 814740, 2, { 1101, 740 } },
    { 814752, 2, { 943, 864 } },
    { 814775, 2, { 1417, 575 } },
    { 814800, 2, { 970, 840 } },
    { 814814, 2, { 962, 847 } },
    { 814830, 2, { 942, 865 } },
    { 814884, 2, { 1068, 763 } },
    { 814905, 2, { 995, 819 } },
    { 814929, 2, { 969, 841 } },
    { 814960, 2, { 976, 835 } },
    { 814980, 2, { 940, 867 } },
    { 815000, 2, { 1000, 815 } },
    { 815040, 2, { 960, 849 } },
    { 815045, 2, { 1015, 803 } },
    { 815052, 2, { 939, 868 } },
    { 815074, 2, { 1081, 754 } },
    { 815080, 2, { 994, 820 } },
    { 815122, 2, { 938, 869 } },
    { 815150, 2, { 959, 850 } },
    { 815184, 2, { 918, 888 } },
    { 815256, 2, { 936, 871 } },
    { 815265, 2, { 915, 891 } },
    { 815269, 2, { 1547, 527 } },
    { 815320, 2, { 935, 872 } },
    { 815328, 2, { 912, 894 } },
    { 815360, 2, { 910, 896 } },
    { 815364, 2, { 957, 852 } },
    { 815424, 2, { 992, 822 } },
    { 815480, 2, { 1073, 760 } },
    { 815490, 2, { 1066, 765 } },
    { 815507, 2, { 979, 833 } },
    { 815556, 2, { 931, 876 } },
    { 815580, 2, { 985, 828 } },
    { 815625, 2, { 1125, 725 } },
    { 815654, 2, { 1189, 686 } },
    { 815661, 2, { 963, 847 } },
    { 815672, 2, { 1012, 806 } },
    { 815675, 2, { 1475, 553 } },
    { 815685, 2, { 1157, 705 } },
    { 815712, 2, { 928, 879 } },
    { 815724, 2, { 996, 819 } },
    { 815760, 2, { 927, 880 } },
    { 815850, 2, { 925, 882 } },
    { 815859, 2, { 1107, 737 } },
    { 815925, 2, { 989, 825 } },
    { 815997, 2, { 1029, 793 } },
    { 816000, 2, { 960, 850 } },
    { 816024, 2, { 968, 843 } },
    { 816060, 2, { 938, 870 } },
    { 816075, 2, { 975, 837 } },
    { 816102, 2, { 918, 889 } },
    { 816130, 2, { 917, 890 } },
    { 816140, 2, { 949, 860 } },
    { 816144, 2, { 1041, 784 } },
    { 816156, 2, { 916, 891 } },
    { 816180, 2, { 915, 892 } },
    { 816183, 2, { 999, 817 } },
    { 816228, 2, { 948, 861 } },
    { 816240, 2, { 912, 895 } },
    { 816252, 2, { 1004, 813 } },
    { 816255, 2, { 935, 873 } },
    { 816270, 2, { 910, 897 } },
    { 816312, 2, { 904, 903 } },
    { 816340, 2, { 980, 833 } },
    { 816354, 2, { 1023, 798 } },
    { 816390, 2, { 965, 846 } },
    { 816400, 2, { 1040, 785 } },
    { 816408, 2, { 986, 828 } },
    { 816410, 2, { 1070, 763 } },
    { 816442, 2, { 1003, 814 } },
    { 816465, 2, { 1027, 795 } },
    { 816480, 2, { 945, 864 } },
    { 816520, 2, { 1096, 745 } },
    { 816525, 2, { 955, 855 } },
    { 816560, 2, { 944, 865 } },
    { 816570, 2, { 1055, 774 } },
    { 816585, 2, { 1111, 735 } },
    { 816624, 2, { 954, 856 } },
    { 816630, 2, { 978, 835 } },
    { 816660, 2, { 1047, 780 } },
    { 816669, 2, { 1043, 783 } },
    { 816672, 2, { 1086, 752 } },
    { 816684, 2, { 1012, 807 } },
    { 816720, 2, { 984, 830 } },
    { 816816, 2, { 924, 884 } },
    { 816850, 2, { 961, 850 } },
    { 816855, 2, { 923, 885 } },
    { 816860, 2, { 940, 869 } },
    { 816888, 2, { 1011, 808 } },
    { 816912, 2, { 976, 837 } },
    { 817020, 2, { 918, 890 } },
    { 817047, 2, { 917, 891 } },
    { 817068, 2, { 959, 852 } },
    { 817089, 2, { 949, 861 } },
    { 817128, 2, { 936, 873 } },
    { 817152, 2, { 912, 896 } },
    { 817173, 2, { 981, 833 } },
    { 817190, 2, { 935, 874 } },
    { 817209, 2, { 1121, 729 } },
    { 817245, 2, { 1143, 715 } },
    { 817260, 2, { 1028, 795 } },
    { 817308, 2, { 933, 876 } },
    { 817320, 2, { 973, 840 } },
    { 817344, 2, { 946, 864 } },
    { 817377, 2, { 1023, 799 } },
    { 817380, 2, { 956, 855 } },
    { 817404, 2, { 1036, 789 } },
    { 817425, 2, { 945, 865 } },
    { 817440, 2, { 1040, 786 } },
    { 817452, 2, { 972, 841 } },
    { 817480, 2, { 955, 856 } },
    { 817530, 2, { 1145, 714 } },
    { 817548, 2, { 1059, 772 } },
    { 817581, 2, { 943, 867 } },
    { 817600, 2, { 1022, 800 } },
    { 817632, 2, { 1002, 816 } },
    { 817663, 2, { 1517, 539 } },
    { 817668, 2, { 1017, 804 } },
    { 817684, 2, { 1007, 812 } },
    { 817704, 2, { 984, 831 } },
    { 817712, 2, { 1043, 784 } },
    { 817740, 2, { 924, 885 } },
    { 817817, 2, { 1001, 817 } },
    { 817830, 2, { 1165, 702 } },
    { 817836, 2, { 969, 844 } },
    { 817848, 2, { 921, 888 } },
    { 817860, 2, { 951, 860 } },
    { 817880, 2, { 920, 889 } },
    { 817887, 2, { 1343, 609 } },
    { 817890, 2, { 995, 822 } },
    { 817908, 2, { 1092, 749 } },
    { 817920, 2, { 960, 852 } },
    { 817950, 2, { 950, 861 } },
    { 817960, 2, { 968, 845 } },
    { 818048, 2, { 913, 896 } },
    { 818064, 2, { 912, 897 } },
    { 818090, 2, { 910, 899 } },
    { 818100, 2, { 909, 900 } },
    { 818120, 2, { 905, 904 } },
    { 818125, 2, { 935, 875 } },
    { 818176, 2, { 1024, 799 } },
    { 818232, 2, { 993, 824 } },
    { 818235, 2, { 957, 855 } },
    { 818244, 2, { 1071, 764 } },
    { 818320, 2, { 965, 848 } },
    { 818363, 2, { 1547, 529 } },
    { 818376, 2, { 1032, 793 } },
    { 818400, 2, { 930, 880 } },
    { 818436, 2, { 964, 849 } },
    { 818448, 2, { 944, 867 } },
    { 818496, 2, { 928, 882 } },
    { 818505, 2, { 1161, 705 } },
    { 818520, 2, { 1077, 760 } },
    { 818524, 2, { 943, 868 } },
    { 818565, 2, { 1331, 615 } },
    { 818685, 2, { 1017, 805 } },
    { 818688, 2, { 984, 832 } },
    { 818740, 2, { 940, 871 } },
    { 818805, 2, { 969, 845 } },
    { 818808, 2, { 939, 872 } },
    { 818892, 2, { 989, 828 } },
    { 818928, 2, { 968, 846 } },
    { 818975, 2, { 1025, 799 } },
    { 819000, 2, { 910, 900 } },
    { 819024, 2, { 906, 904 } },
    { 819060, 2, { 935, 876 } },
    { 819072, 2, { 948, 864 } },
    { 819084, 2, { 1029, 796 } },
    { 819135, 2, { 981, 835 } },
    { 819144, 2, { 1101, 744 } },
    { 819150, 2, { 1075, 762 } },
    { 819168, 2, { 966, 848 } },
    { 819175, 2, { 1057, 775 } },
    { 819180, 2, { 999, 820 } },
    { 819192, 2, { 957, 856 } },
    { 819200, 2, { 1024, 800 } },
    { 819228, 2, { 932, 879 } },
    { 819280, 2, { 931, 880 } },
    { 819312, 2, { 1014, 808 } },
    { 819315, 2, { 945, 867 } },
    { 819375, 2, { 1311, 625 } },
    { 819390, 2, { 955, 858 } },
    { 819396, 2, { 972, 843 } },
    { 819405, 2, { 1179, 695 } },
    { 819423, 2, { 979, 837 } },
    { 819468, 2, { 927, 884 } },
    { 819504, 2, { 1008, 813 } },
    { 819520, 2, { 985, 832 } },
    { 819546, 2, { 1027, 798 } },
    { 819624, 2, { 923, 888 } },
    { 819672, 2, { 952, 861 } },
    { 819698, 2, { 1007, 814 } },
    { 819720, 2, { 920, 891 } },
    { 819774, 2, { 918, 893 } },
    { 819819, 2, { 1001, 819 } },
    { 819840, 2, { 915, 896 } },
    { 819880, 2, { 995, 824 } },
    { 819888, 2, { 912, 899 } },
    { 819910, 2, { 910, 901 } },
    { 819912, 2, { 1016, 807 } },
    { 819924, 2, { 908, 903 } },
    { 819930, 2, { 906, 905 } },
    { 819945, 2, { 959, 855 } },
    { 819962, 2, { 1034, 793 } },
    { 819975, 2, { 975, 841 } },
    { 820020, 2, { 948, 865 } },
    { 820050, 2, { 994, 825 } },
    { 820080, 2, { 1005, 816 } },
    { 820105, 2, { 1147, 715 } },
    { 820116, 2, { 981, 836 } },
    { 820125, 2, { 1125, 729 } },
    { 820155, 2, { 1095, 749 } },
    { 820224, 2, { 1024, 801 } },
    { 820225, 2, { 1075, 763 } },
    { 820232, 2, { 1057, 776 } },
    { 820281, 2, { 1113, 737 } },
    { 820287, 2, { 1053, 779 } },
    { 820308, 2, { 1041, 788 } },
    { 820336, 2, { 944, 869 } },
    { 820410, 2, { 943, 870 } },
    { 820456, 2, { 1127, 728 } },
    { 820476, 2, { 963, 852 } },
    { 820479, 2, { 1081, 759 } },
    { 820560, 2, { 1040, 789 } },
    { 820620, 2, { 940, 873 } },
    { 820625, 2, { 1313, 625 } },
    { 820656, 2, { 984, 834 } },
    { 820743, 2, { 969, 847 } },
    { 820750, 2, { 938, 875 } },
    { 820800, 2, { 912, 900 } },
    { 820820, 2, { 910, 902 } },
    { 820845, 2, { 1073, 765 } },
    { 820848, 2, { 1047, 784 } },
    { 820904, 2, { 959, 856 } },
    { 820932, 2, { 1011, 812 } },
    { 820953, 2, { 1099, 747 } },
    { 821025, 2, { 1025, 801 } },
    { 821028, 2, { 988, 831 } },
    { 821040, 2, { 933, 880 } },
    { 821066, 2, { 1054, 779 } },
    { 821100, 2, { 966, 850 } },
    { 821128, 2, { 946, 868 } },
    { 821142, 2, { 931, 882 } },
    { 821184, 2, { 987, 832 } },
    { 821205, 2, { 945, 869 } },
    { 821280, 2, { 928, 885 } },
    { 821304, 2, { 1037, 792 } },
    { 821338, 2, { 986, 833 } },
    { 821340, 2, { 972, 845 } },
    { 821370, 2, { 1045, 786 } },
    { 821376, 2, { 992, 828 } },
    { 821400, 2, { 925, 888 } },
    { 821424, 2, { 942, 872 } },
    { 821425, 2, { 1133, 725 } },
    { 821436, 2, { 924, 889 } },
    { 821440, 2, { 1088, 755 } },
    { 821457, 2, { 1003, 819 } },
    { 821490, 2, { 985, 834 } },
    { 821520, 2, { 978, 840 } },
    { 821532, 2, { 921, 892 } },
    { 821541, 2, { 1349, 609 } },
    { 821560, 2, { 920, 893 } },
    { 821583, 2, { 1127, 729 } },
    { 821590, 2, { 970, 847 } },
    { 821600, 2, { 1027, 800 } },
    { 821610, 2, { 918, 895 } },
    { 821632, 2, { 917, 896 } },
    { 821640, 2, { 984, 835 } },
    { 821652, 2, { 916, 897 } },
    { 821655, 2, { 961, 855 } },
    { 821664, 2, { 951, 864 } },
    { 821700, 2, { 913, 900 } },
    { 821712, 2, { 912, 901 } },
    { 821736, 2, { 909, 904 } },
    { 821784, 2, { 1059, 776 } },
    { 821832, 2, { 968, 849 } },
    { 821916, 2, { 948, 867 } },
    { 821975, 2, { 1225, 671 } },
    { 822000, 2, { 1000, 822 } },
    { 822016, 2, { 988, 832 } },
    { 822066, 2, { 966, 851 } },
    { 822096, 2, { 1038, 792 } },
    { 822180, 2, { 965, 852 } },
    { 822195, 2, { 1089, 755 } },
    { 822204, 2, { 993, 828 } },
    { 822224, 2, { 944, 871 } },
    { 822272, 2, { 1024, 803 } },
    { 822276, 2, { 1004, 819 } },
    { 822325, 2, { 925, 889 } },
    { 822360, 2, { 924, 890 } },
    { 822375, 2, { 1075, 765 } },
    { 822393, 2, { 923, 891 } },
    { 822460, 2, { 1003, 820 } },
    { 822480, 2, { 920, 894 } },
    { 822492, 2, { 1023, 804 } },
    { 822510, 2, { 962, 855 } },
    { 822528, 2, { 918, 896 } },
    { 822560, 2, { 970, 848 } },
    { 822564, 2, { 939, 876 } },
    { 822624, 2, { 912, 902 } },
    { 822645, 2, { 909, 905 } },
    { 822680, 2, { 1048, 785 } },
    { 822744, 2, { 936, 879 } },
    { 822756, 2, { 1012, 813 } },
    { 822768, 2, { 976, 843 } },
    { 822800, 2, { 935, 880 } },
    { 822828, 2, { 1077, 764 } },
    { 822848, 2, { 989, 832 } },
    { 822870, 2, { 1115, 738 } },
    { 822900, 2, { 975, 844 } },
    { 822948, 2, { 1164, 707 } },
    { 822960, 2, { 1016, 810 } },
    { 822976, 2, { 1169, 704 } },
    { 823020, 2, { 946, 870 } },
    { 823075, 2, { 1025, 803 } },
    { 823080, 2, { 1083, 760 } },
    { 823095, 2, { 945, 871 } },
    { 823116, 2, { 956, 861 } },
    { 823140, 2, { 1020, 807 } },
    { 823158, 2, { 973, 846 } },
    { 823176, 2, { 927, 888 } },
    { 823200, 2, { 980, 840 } },
    { 823221, 2, { 1253, 657 } },
    { 823284, 2, { 924, 891 } },
    { 823296, 2, { 1024, 804 } },
    { 823360, 2, { 992, 830 } },
    { 823361, 2, { 1309, 629 } },
    { 823400, 2, { 920, 895 } },
    { 823428, 2, { 1028, 801 } },
    { 823446, 2, { 918, 897 } },
    { 823480, 2, { 952, 865 } },
    { 823485, 2, { 1339, 615 } },
    { 823500, 2, { 915, 900 } },
    { 823515, 2, { 1023, 805 } },
    { 823536, 2, { 912, 903 } },
    { 823548, 2, { 1101, 748 } },
    { 823581, 2, { 1269, 649 } },
    { 823600, 2, { 1136, 725 } },
    { 823608, 2, { 984, 837 } },
    { 823620, 2, { 1036, 795 } },
    { 823716, 2, { 1044, 789 } },
    { 823732, 2, { 949, 868 } },
    { 823745, 2, { 1235, 667 } },
    { 823768, 2, { 968, 851 } },
    { 823837, 2, { 989, 833 } },
    { 823860, 2, { 995, 828 } },
    { 823878, 2, { 1026, 803 } },
    { 823935, 2, { 931, 885 } },
    { 823966, 2, { 946, 871 } },
    { 823970, 2, { 1043, 790 } },
    { 824010, 2, { 1135, 726 } },
    { 824040, 2, { 945, 872 } },
    { 824064, 2, { 928, 888 } },
    { 824100, 2, { 1005, 820 } },
    { 824103, 2, { 927, 889 } },
    { 824112, 2, { 944, 873 } },
    { 824160, 2, { 1010, 816 } },
    { 824175, 2, { 925, 891 } },
    { 824180, 2, { 980, 841 } },
    { 824182, 2, { 943, 874 } },
    { 824220, 2, { 964, 855 } },
    { 824250, 2, { 942, 875 } },
    { 824256, 2, { 954, 864 } },
    { 824296, 2, { 986, 836 } },
    { 824310, 2, { 1065, 774 } },
    { 824320, 2, { 920, 896 } },
    { 824328, 2, { 963, 856 } },
    { 824352, 2, { 992, 831 } },
    { 824362, 2, { 1111, 742 } },
    { 824439, 2, { 913, 903 } },
    { 824445, 2, { 985, 837 } },
    { 824472, 2, { 1041, 792 } },
    { 824525, 2, { 1075, 767 } },
    { 824538, 2, { 961, 858 } },
    { 824551, 2, { 1183, 697 } },
    { 824568, 2, { 1032, 799 } },
    { 824600, 2, { 950, 868 } },
    { 824615, 2, { 1363, 605 } },
    { 824619, 2, { 969, 851 } },
    { 824670, 2, { 935, 882 } },
    { 824715, 2, { 1107, 745 } },
    { 824720, 2, { 976, 845 } },
    { 824733, 2, { 1007, 819 } },
    { 824740, 2, { 959, 860 } },
    { 824772, 2, { 933, 884 } },
    { 824820, 2, { 932, 885 } },
    { 824824, 2, { 1001, 824 } },
    { 824832, 2, { 1074, 768 } },
    { 824850, 2, { 975, 846 } },
    { 824976, 2, { 1011, 816 } },
    { 824992, 2, { 928, 889 } },
    { 825000, 2, { 1000, 825 } },
    { 825036, 2, { 1047, 788 } },
    { 825075, 2, { 965, 855 } },
    { 825104, 2, { 973, 848 } },
    { 825120, 2, { 955, 864 } },
    { 825125, 2, { 943, 875 } },
    { 825132, 2, { 924, 893 } },
    { 825174, 2, { 999, 826 } },
    { 825210, 2, { 954, 865 } },
    { 825216, 2, { 921, 896 } },
    { 825228, 2, { 972, 849 } },
    { 825240, 2, { 920, 897 } },
    { 825248, 2, { 1184, 697 } },
    { 825265, 2, { 1241, 665 } },
    { 825282, 2, { 918, 899 } },
    { 825300, 2, { 917, 900 } },
    { 825360, 2, { 912, 905 } },
    { 825372, 2, { 909, 908 } },
    { 825384, 2, { 952, 867 } },
    { 825396, 2, { 962, 858 } },
    { 825435, 2, { 1079, 765 } },
    { 825440, 2, { 938, 880 } },
    { 825468, 2, { 951, 868 } },
    { 825475, 2, { 1325, 623 } },
    {