#include "codepoint_width.h"

#include <stdbool.h>
#include <stdint.h>

typedef uint_least32_t char32_t;

// Generated by GraphemeTableGen (https://github.com/microsoft/terminal/blob/0961a77a5aec003e9f79d388f8e7bffb9a550cdb/src/tools/GraphemeTableGen/Program.cs)
// on 2025-02-25T07:26:37Z, from Unicode 16.0.0, 9224 bytes
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.

// Manually adjusted for C compatibility
// To generate:
// 0. Install .NET 8.0
// 1. Download the tool from: https://github.com/microsoft/terminal/tree/main/src/tools/GraphemeTableGen
// 2. Download the Unicode data from: https://www.unicode.org/Public/UCD/latest/ucdxml/ucd.nounihan.grouped.zip
// 3. Build the project: `dotnet build GraphemeTableGen.csproj`
// 4. Run the tool: `./GraphemeTableGen ucd.nounihan.grouped.xml`
// 5. Copy the generated code and adjust it for C compatibility by replacing `constexpr` and `auto` keywords.

// clang-format off
static const uint16_t s_stage0[] = {
    0x0000, 0x0020, 0x0040, 0x0060, 0x0080, 0x009f, 0x00bf, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00d8, 0x00f8, 0x010a, 0x010e, 0x010b, 0x0108, 0x0113, 0x0133, 0x0153, 0x0153, 0x0153, 0x016f,
    0x018f, 0x01a7, 0x01c7, 0x01e7, 0x0133, 0x0133, 0x0205, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0221, 0x0236, 0x00ca, 0x00ca,
    0x0256, 0x0276, 0x0133, 0x0133, 0x0133, 0x028b, 0x02ab, 0x02b9, 0x0133, 0x02cc, 0x02ea, 0x0302, 0x0322, 0x033f, 0x035f, 0x037f,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x039f,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x039f,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x03bf, 0x03c7, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
    0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
    0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x03e7,
    0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
    0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x03e7,
};
static const uint16_t s_stage1[] = {
    0x0000, 0x0004, 0x000c, 0x0014, 0x001c, 0x0024, 0x002a, 0x0031, 0x002a, 0x0037, 0x002a, 0x003f, 0x0047, 0x0049, 0x004f, 0x0057, 0x005f, 0x0065, 0x006d, 0x002a, 0x002a, 0x002a, 0x0073, 0x007b, 0x0083, 0x008a, 0x002a, 0x0091, 0x0098, 0x009f, 0x00a3, 0x00aa,
    0x00b2, 0x00b8, 0x00be, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed, 0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d, 0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0164, 0x016b, 0x0173, 0x0175, 0x017d, 0x0182, 0x018a, 0x0192, 0x019a,
    0x019d, 0x01a5, 0x01ad, 0x002a, 0x01b5, 0x01b9, 0x01bd, 0x01c2, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x01ca, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x01d0, 0x01d7, 0x01de, 0x01e6,
    0x01ed, 0x002a, 0x01f5, 0x002a, 0x01fb, 0x002a, 0x002a, 0x002a, 0x0203, 0x0209, 0x0211, 0x0218, 0x0220, 0x0228, 0x0230, 0x0236, 0x023d, 0x002a, 0x002a, 0x0244, 0x002a, 0x002a, 0x002a, 0x0047, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x024c, 0x0254, 0x025c, 0x0262, 0x026a, 0x0272, 0x027a, 0x0282, 0x028a, 0x0292, 0x029a, 0x002a, 0x02a2, 0x002a, 0x02a9, 0x02b0, 0x002a, 0x02b8, 0x02bc, 0x02c4, 0x002a, 0x002a, 0x02cc, 0x02d4, 0x02dc, 0x02e4, 0x02ec, 0x02f4, 0x02fc, 0x0304, 0x030c, 0x002a,
    0x002a, 0x002a, 0x002a, 0x0314, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x031c, 0x0322, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0326, 0x002a, 0x032d, 0x002a, 0x0043, 0x002a, 0x002a, 0x0335, 0x0339, 0x0341, 0x0341, 0x0341, 0x0347, 0x034d,
    0x0355, 0x035b, 0x0341, 0x0363, 0x0341, 0x036a, 0x036e, 0x0374, 0x037b, 0x0381, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341,
    0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0388, 0x0390, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0393, 0x039b, 0x017f, 0x002a, 0x002a, 0x002a, 0x002a, 0x03a3, 0x002a, 0x03ab, 0x03b3, 0x03bb, 0x03c3, 0x03cb, 0x03d3,
    0x03d8, 0x03e0, 0x03e8, 0x03f0, 0x002a, 0x002a, 0x002a, 0x03f7, 0x03ff, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x03ff, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x03ff, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x03ff, 0x0400, 0x0401,
    0x0402, 0x0403, 0x0404, 0x0405, 0x03ff, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x03ff, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x040c, 0x0414, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc,
    0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x041c, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0424, 0x042a, 0x002a, 0x032d, 0x0355, 0x0432, 0x0437, 0x043b, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0443, 0x002a, 0x002a, 0x002a, 0x044b, 0x002a, 0x0450, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0458, 0x002a, 0x002a, 0x01f1, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0460, 0x0465, 0x002a, 0x002a, 0x002a,
    0x002a, 0x046b, 0x0471, 0x002a, 0x00a7, 0x0479, 0x002a, 0x0481, 0x0489, 0x0491, 0x0499, 0x04a1, 0x04a9, 0x04b1, 0x04b9, 0x04bc, 0x04c4, 0x002a, 0x04c9, 0x04d1, 0x04d9, 0x04e0, 0x04e8, 0x04ed, 0x04f5, 0x04f9, 0x0501, 0x002a, 0x002a, 0x0504, 0x050c, 0x0510,
    0x0518, 0x051b, 0x002a, 0x0522, 0x002a, 0x002a, 0x002a, 0x0528, 0x002a, 0x002a, 0x002a, 0x0530, 0x0538, 0x002a, 0x053e, 0x0546, 0x054e, 0x0556, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x055a, 0x002a, 0x0562, 0x002a, 0x0569, 0x0571, 0x0578, 0x002a, 0x002a,
    0x002a, 0x002a, 0x057b, 0x0583, 0x058b, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0211, 0x0593, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0598, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x059e, 0x05a5, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x05ac, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x05b3, 0x05ba, 0x05be, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341,
    0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x05c6, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341,
    0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x05ce, 0x05d6, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x05d8, 0x0341, 0x0341, 0x0341, 0x0341, 0x05e0, 0x05e7, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x05ed, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x05f5, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x05fd, 0x0605, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0609, 0x0611, 0x002a, 0x002a, 0x0619, 0x002a, 0x002a, 0x0341, 0x0621, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0629, 0x0631, 0x0639, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x0641, 0x002a, 0x0648, 0x002a, 0x05a5, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x064b, 0x0651, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x0651, 0x002a, 0x002a, 0x002a, 0x0657, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
    0x002a, 0x002a, 0x065d, 0x002a, 0x0665, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x066d,
    0x066e, 0x066e, 0x0675, 0x067d, 0x0683, 0x068b, 0x0691, 0x0699, 0x06a1, 0x066e, 0x066e, 0x06a9, 0x06b0, 0x06b8, 0x06bf, 0x06c7, 0x06cf, 0x06d0, 0x06d1, 0x06d9, 0x06e1, 0x06e9, 0x06ee, 0x06d0, 0x06f6, 0x06d0, 0x06fe, 0x002a, 0x0706, 0x002a, 0x070e, 0x0716,
    0x071d, 0x0724, 0x066e, 0x072c, 0x0734, 0x06d0, 0x06d0, 0x066e, 0x073c, 0x0744, 0x074c, 0x002a, 0x002a, 0x002a, 0x002a, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x066e, 0x0754, 0x0341,
    0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0341, 0x0342, 0x075c,
    0x0047, 0x0764, 0x0764, 0x0047, 0x0047, 0x0047, 0x076c, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764,
    0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x0764, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc,
    0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x02bc, 0x0774,
};
static const uint16_t s_stage2[] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0011, 0x0018, 0x0020, 0x0022, 0x002a, 0x0008, 0x0029, 0x0030,
    0x0036, 0x003e, 0x0040, 0x0047, 0x004c, 0x0008, 0x004a, 0x002d,
    0x004e, 0x002d, 0x0053, 0x0029, 0x005b, 0x0063, 0x0034, 0x0008,
    0x004e, 0x002d, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x002a, 0x006b, 0x0049, 0x0008, 0x0008, 0x0008,
    0x0008, 0x004c, 0x0008, 0x004c, 0x0008, 0x0008, 0x0008, 0x0072,
    0x005a, 0x0079, 0x0081, 0x0008, 0x0008, 0x0008, 0x0008, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0008,
    0x0008, 0x0091, 0x0092, 0x0098, 0x0028, 0x0091, 0x0092, 0x0098,
    0x0028, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x004c,
    0x0008, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x004c,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a0, 0x00a6, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00ad, 0x0089, 0x0089,
    0x0089, 0x0089, 0x00af, 0x00b5, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x00bd, 0x0008, 0x0089, 0x00c5, 0x0008,
    0x0008, 0x0008, 0x0008, 0x00a0, 0x0089, 0x0089, 0x0008, 0x0008,
    0x00c9, 0x0008, 0x0008, 0x00a8, 0x00d1, 0x00d8, 0x00df, 0x0008,
    0x0008, 0x00e5, 0x00c8, 0x0008, 0x0008, 0x0008, 0x0089, 0x0089,
    0x00a5, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a8,
    0x0089, 0x00c9, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a0,
    0x00a4, 0x00ed, 0x0008, 0x0008, 0x00a8, 0x00f5, 0x00f9, 0x00a2,
    0x0008, 0x0008, 0x0008, 0x00fd, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0105, 0x0089, 0x0008, 0x0008, 0x0008, 0x0008, 0x00ac, 0x0089,
    0x0089, 0x010c, 0x0089, 0x0089, 0x0089, 0x0111, 0x0008, 0x0115,
    0x011a, 0x011a, 0x011a, 0x011a, 0x0120, 0x0127, 0x012e, 0x00ad,
    0x011a, 0x0136, 0x0008, 0x0008, 0x011a, 0x013d, 0x0008, 0x0115,
    0x011a, 0x011a, 0x0145, 0x014c, 0x0152, 0x0159, 0x0160, 0x0166,
    0x016e, 0x0136, 0x0008, 0x0175, 0x0177, 0x017e, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0182, 0x0189, 0x0190, 0x00c8,
    0x0008, 0x0008, 0x0008, 0x0194, 0x0008, 0x017e, 0x0008, 0x0115,
    0x011a, 0x011a, 0x0145, 0x019c, 0x0152, 0x01a4, 0x01ab, 0x0008,
    0x0008, 0x0136, 0x0008, 0x0008, 0x01b2, 0x013d, 0x0008, 0x0115,
    0x011a, 0x011a, 0x0145, 0x019c, 0x01ba, 0x0159, 0x0160, 0x01c2,
    0x016e, 0x0136, 0x0008, 0x01ca, 0x0008, 0x01d0, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x01d3, 0x01db, 0x01e2, 0x0166,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x01ea, 0x0008, 0x0115,
    0x011a, 0x011a, 0x0145, 0x011a, 0x01f2, 0x01f9, 0x0200, 0x0206,
    0x020e, 0x0136, 0x0008, 0x0008, 0x0008, 0x013d, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0212, 0x021a, 0x0221, 0x0227,
    0x0008, 0x0136, 0x0008, 0x016a, 0x0008, 0x022f, 0x0008, 0x0115,
    0x011a, 0x011a, 0x011a, 0x011a, 0x0237, 0x023e, 0x0245, 0x0166,
    0x0008, 0x0136, 0x0008, 0x0008, 0x0008, 0x013d, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x024c, 0x0253, 0x025b,
    0x0008, 0x0008, 0x0263, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x026a, 0x00a5, 0x00ca, 0x008a, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x026a, 0x00a3, 0x0008, 0x008a, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a6, 0x0008, 0x0008,
    0x0178, 0x024d, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x00ad, 0x0128, 0x00b0, 0x00a9, 0x0089, 0x00ad, 0x0089, 0x0089,
    0x0089, 0x00a3, 0x0177, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x00a9, 0x0271, 0x0279, 0x0008, 0x0008, 0x01d3,
    0x027e, 0x00c9, 0x0008, 0x00e0, 0x0008, 0x0286, 0x00ed, 0x0008,
    0x00ed, 0x0008, 0x0008, 0x0008, 0x0008, 0x028e, 0x028e, 0x028e,
    0x028e, 0x028e, 0x028e, 0x028e, 0x028e, 0x0296, 0x0296, 0x0296,
    0x0296, 0x0296, 0x029e, 0x029e, 0x029e, 0x029e, 0x029e, 0x029e,
    0x029e, 0x029e, 0x0008, 0x0008, 0x0008, 0x00a9, 0x0008, 0x0008,
    0x0008, 0x0008, 0x02a6, 0x0008, 0x0008, 0x0008, 0x02ac, 0x0008,
    0x0008, 0x0136, 0x0008, 0x0008, 0x0008, 0x0136, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x02b1, 0x0129, 0x02b9, 0x0127,
    0x00a4, 0x00ed, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a0, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0206, 0x0008, 0x0008,
    0x0008, 0x0008, 0x00c8, 0x0008, 0x0008, 0x0008, 0x0008, 0x02c1,
    0x02c8, 0x02d0, 0x02d7, 0x0008, 0x0008, 0x00ca, 0x02df, 0x0008,
    0x0008, 0x0008, 0x0008, 0x02e3, 0x008a, 0x02eb, 0x012a, 0x02f3,
    0x00d8, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0089,
    0x0089, 0x008a, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0110, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x02fb, 0x0301,
    0x01d9, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a0, 0x00a4, 0x0008,
    0x0112, 0x0008, 0x0008, 0x0008, 0x0309, 0x0311, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0317, 0x031f, 0x022f, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0327, 0x032b, 0x030b, 0x0008, 0x0008, 0x0330, 0x0089,
    0x0271, 0x018b, 0x0338, 0x00a6, 0x0008, 0x0340, 0x0348, 0x034d,
    0x0022, 0x0355, 0x035d, 0x0363, 0x0008, 0x036a, 0x0008, 0x0008,
    0x0372, 0x0089, 0x002c, 0x007a, 0x0025, 0x0008, 0x0008, 0x0008,
    0x0008, 0x002c, 0x0008, 0x0008, 0x0089, 0x0089, 0x0089, 0x0089,
    0x00c9, 0x0008, 0x037a, 0x004c, 0x0073, 0x0008, 0x0381, 0x002d,
    0x0008, 0x036a, 0x0008, 0x0008, 0x0033, 0x0060, 0x0092, 0x0026,
    0x0092, 0x0028, 0x0008, 0x004c, 0x0389, 0x038f, 0x0008, 0x0396,
    0x0008, 0x0028, 0x0008, 0x0008, 0x039c, 0x0008, 0x007a, 0x0008,
    0x0008, 0x0008, 0x0040, 0x03a4, 0x039f, 0x03a9, 0x0068, 0x03ae,
    0x007d, 0x0032, 0x0008, 0x03b4, 0x002e, 0x0008, 0x03bc, 0x03ba,
    0x0008, 0x0008, 0x03ba, 0x0008, 0x002b, 0x004c, 0x002b, 0x0008,
    0x0008, 0x007a, 0x0008, 0x0008, 0x002e, 0x03c4, 0x0008, 0x03cc,
    0x0008, 0x0008, 0x03d4, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x03d5, 0x0008, 0x0008, 0x0008, 0x03dd, 0x03e5, 0x03ed,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0092, 0x0092, 0x0092, 0x0092,
    0x0092, 0x0092, 0x0092, 0x0092, 0x03f5, 0x0092, 0x0092, 0x0092,
    0x0092, 0x0098, 0x0092, 0x0092, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0098, 0x03fb, 0x0401, 0x0032, 0x0407, 0x040e, 0x0028, 0x0008,
    0x0349, 0x007a, 0x0008, 0x0416, 0x041e, 0x0425, 0x042d, 0x0433,
    0x043a, 0x043a, 0x0442, 0x043a, 0x0437, 0x0442, 0x0446, 0x043a,
    0x044e, 0x0451, 0x043a, 0x043b, 0x0459, 0x045f, 0x0467, 0x046b,
    0x0469, 0x0473, 0x043a, 0x0477, 0x0478, 0x047e, 0x0480, 0x0485,
    0x0455, 0x0482, 0x048b, 0x0491, 0x0499, 0x0473, 0x04a1, 0x03cf,
    0x036a, 0x04a9, 0x0394, 0x002b, 0x04ad, 0x04b5, 0x04bc, 0x0008,
    0x04c4, 0x0008, 0x004e, 0x0092, 0x0008, 0x0008, 0x04cc, 0x0008,
    0x036a, 0x0008, 0x04a9, 0x04d4, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0393, 0x0008, 0x04dc, 0x0008, 0x0008, 0x04e4,
    0x0008, 0x0008, 0x0008, 0x0008, 0x04e8, 0x0028, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x00ca, 0x00a6, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x00ca, 0x04f0, 0x04f0, 0x04f0,
    0x04f6, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04fa,
    0x0008, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0,
    0x04f0, 0x0502, 0x0008, 0x0008, 0x0008, 0x04f0, 0x04f0, 0x04f0,
    0x04f0, 0x04f0, 0x050a, 0x0512, 0x0515, 0x051c, 0x04f0, 0x04f0,
    0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f1, 0x0524, 0x04f0,
    0x04f0, 0x04f0, 0x04f0, 0x052c, 0x04f0, 0x04f0, 0x04f0, 0x04f0,
    0x04f0, 0x051c, 0x04f0, 0x04f1, 0x04f0, 0x04f0, 0x04f0, 0x04f0,
    0x04f0, 0x04f0, 0x0502, 0x0534, 0x04f0, 0x04f0, 0x04f0, 0x04f1,
    0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x0092, 0x04f0, 0x04f0, 0x04f0,
    0x04f0, 0x04f0, 0x04f0, 0x0513, 0x053b, 0x04f0, 0x04f0, 0x04f0,
    0x04f0, 0x04f9, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0,
    0x04f1, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x00ca, 0x0330, 0x0543, 0x0008, 0x0008, 0x0008, 0x00a8, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0549, 0x01cf, 0x0008, 0x0008, 0x0550,
    0x01ce, 0x0008, 0x0008, 0x0557, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0327, 0x025b, 0x055f, 0x0008, 0x0008, 0x0008, 0x0089,
    0x0089, 0x00a6, 0x00ca, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a8,
    0x0543, 0x0008, 0x0008, 0x00ca, 0x0089, 0x022f, 0x0008, 0x028e,
    0x028e, 0x028e, 0x0567, 0x0111, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x056c, 0x0572, 0x0579, 0x0008, 0x0008, 0x0008, 0x00ed,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0580, 0x0587, 0x0008,
    0x01cf, 0x058e, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x01ce,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0596, 0x01c1,
    0x00c8, 0x0008, 0x0008, 0x0008, 0x0008, 0x059e, 0x05a6, 0x0008,
    0x0008, 0x0008, 0x0008, 0x01d6, 0x05ae, 0x0008, 0x0008, 0x05b6,
    0x05b7, 0x05b7, 0x05bb, 0x05b7, 0x05b7, 0x05b7, 0x05b6, 0x05b7,
    0x05b7, 0x05bb, 0x05b7, 0x05b7, 0x05b7, 0x05b6, 0x05b7, 0x05b7,
    0x05c0, 0x0008, 0x0296, 0x0296, 0x05c8, 0x05cf, 0x029e, 0x029e,
    0x029e, 0x029e, 0x029e, 0x05d3, 0x0008, 0x0008, 0x0008, 0x0177,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0089, 0x0089, 0x04f0, 0x0532,
    0x0089, 0x0089, 0x04f0, 0x04f0, 0x04f5, 0x04f0, 0x04f1, 0x04fa,
    0x0008, 0x0008, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x0533, 0x0008,
    0x0008, 0x0008, 0x01d3, 0x0008, 0x0008, 0x0008, 0x0008, 0x04f1,
    0x0008, 0x0000, 0x05db, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x00ed, 0x0008, 0x0008, 0x0008, 0x0008, 0x00c9,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00a8, 0x00a5,
    0x05e2, 0x00aa, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x02d8,
    0x0008, 0x0008, 0x0008, 0x0008, 0x00aa, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x00a2, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x05e9, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x00aa, 0x05ef, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x05f7, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0089, 0x008a, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x05ff,
    0x00ca, 0x0112, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0607,
    0x060e, 0x01d0, 0x00e7, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x00a5, 0x0008, 0x0008, 0x0008, 0x00ca, 0x026e, 0x00a3,
    0x0008, 0x0227, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x01cf,
    0x0008, 0x0112, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0604,
    0x0128, 0x0616, 0x061d, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0625, 0x062c, 0x0177, 0x00c8, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x00ca, 0x02f3, 0x00a5, 0x0008,
    0x0008, 0x022f, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0634, 0x063c, 0x0640, 0x0166, 0x0008, 0x0646, 0x00a3, 0x00a3,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x02f3,
    0x064d, 0x0654, 0x065c, 0x0008, 0x0663, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x055a, 0x0089, 0x066b, 0x0008, 0x0008,
    0x0177, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x02f3,
    0x0673, 0x067a, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0166, 0x0158, 0x0682, 0x00c9, 0x0008, 0x0008, 0x0280,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x02f3, 0x0689,
    0x00c9, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0691, 0x0581, 0x0008, 0x0008, 0x0008, 0x0318, 0x0699, 0x00a4,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0625, 0x0089, 0x0224,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x06a1, 0x06a8,
    0x06b0, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0606, 0x06b6, 0x06be, 0x0008, 0x0008, 0x0008, 0x00ad, 0x00a5,
    0x0008, 0x0008, 0x0008, 0x0008, 0x00a0, 0x06c6, 0x00ca, 0x0008,
    0x0580, 0x02d7, 0x0008, 0x0008, 0x0008, 0x0008, 0x06cd, 0x06d3,
    0x0128, 0x00a6, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0166,
    0x008a, 0x0581, 0x0008, 0x0008, 0x00ac, 0x0089, 0x0089, 0x06db,
    0x06e2, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x06e9,
    0x06f0, 0x06f7, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x06ff, 0x0707, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x070f, 0x0008, 0x0717, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x024f, 0x071f, 0x0727, 0x0008, 0x0008, 0x01d0, 0x0008,
    0x0008, 0x0008, 0x0008, 0x00a7, 0x0089, 0x0543, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x00a8, 0x0089, 0x02f1, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x00a3, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x008a, 0x0008, 0x0008, 0x0008, 0x0008,
    0x072c, 0x0733, 0x0008, 0x0008, 0x00ca, 0x025a, 0x025b, 0x025b,
    0x025b, 0x025b, 0x025b, 0x00ca, 0x00a5, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x073b, 0x0008, 0x0743, 0x0008, 0x04f0, 0x04f0,
    0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x0008, 0x04f0, 0x04f0,
    0x0502, 0x0008, 0x0008, 0x0008, 0x0008, 0x0534, 0x04f0, 0x0533,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x04f4, 0x074b,
    0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x0529, 0x0008, 0x0752, 0x0008,
    0x0008, 0x075a, 0x0008, 0x04fe, 0x0008, 0x04f0, 0x04f0, 0x04f0,
    0x04f0, 0x04f0, 0x04f0, 0x04f0, 0x04fa, 0x0008, 0x0008, 0x0008,
    0x0206, 0x00a4, 0x0008, 0x0008, 0x0008, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0543, 0x0089, 0x0089, 0x008a, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x01d4, 0x0602, 0x02f3,
    0x0089, 0x0762, 0x00a4, 0x0008, 0x0008, 0x0008, 0x05ef, 0x0008,
    0x0008, 0x0191, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x04f0, 0x04f0, 0x04f1, 0x0008, 0x04f0, 0x04f0, 0x04f1,
    0x0008, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x008a,
    0x00a0, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x00a3, 0x00ed,
    0x0008, 0x01ce, 0x0008, 0x0008, 0x00a0, 0x00ad, 0x0089, 0x0008,
    0x0008, 0x008a, 0x0089, 0x0089, 0x0764, 0x00b3, 0x00a5, 0x0008,
    0x0008, 0x00ca, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0177, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00aa, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x00a8, 0x0008, 0x0008, 0x008a,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x00aa, 0x00a5, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x076c, 0x043a, 0x043a,
    0x043a, 0x043a, 0x043a, 0x043a, 0x043a, 0x043a, 0x043b, 0x043a,
    0x043a, 0x043a, 0x043a, 0x043a, 0x043a, 0x0092, 0x0774, 0x0092,
    0x0092, 0x0092, 0x077c, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
    0x0784, 0x078c, 0x078e, 0x0092, 0x0796, 0x079d, 0x07a2, 0x0092,
    0x07a5, 0x043a, 0x043a, 0x043a, 0x043a, 0x07aa, 0x07b0, 0x07b0,
    0x07b0, 0x07b8, 0x043a, 0x04f0, 0x07c0, 0x04f0, 0x0513, 0x07c6,
    0x07cb, 0x04f0, 0x07ce, 0x07d6, 0x043a, 0x0444, 0x043a, 0x043a,
    0x043a, 0x0442, 0x0442, 0x0442, 0x0442, 0x07d7, 0x043d, 0x07df,
    0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x07e0,
    0x0442, 0x0442, 0x0446, 0x043a, 0x0442, 0x0442, 0x0442, 0x0442,
    0x07e6, 0x0446, 0x043a, 0x0442, 0x0442, 0x07ed, 0x07f5, 0x0442,
    0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0443, 0x07fd,
    0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442,
    0x0800, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442, 0x0442,
    0x0807, 0x0391, 0x080f, 0x0442, 0x0442, 0x0442, 0x043a, 0x043a,
    0x0468, 0x043a, 0x043a, 0x07d1, 0x043a, 0x076c, 0x043a, 0x043a,
    0x043a, 0x043a, 0x043a, 0x043a, 0x043a, 0x043f, 0x0442, 0x0442,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0444, 0x076c,
    0x0802, 0x043e, 0x043a, 0x07d3, 0x043e, 0x0445, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0817, 0x043a, 0x0008, 0x0008,
    0x04dc, 0x043a, 0x0442, 0x0446, 0x07d7, 0x043a, 0x0008, 0x0817,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x043a, 0x0008,
    0x0819, 0x0008, 0x0008, 0x0008, 0x0008, 0x043a, 0x0008, 0x0008,
    0x0008, 0x0391, 0x043a, 0x043a, 0x0008, 0x0821, 0x0442, 0x0442,
    0x0442, 0x0442, 0x0442, 0x0826, 0x082a, 0x0442, 0x0442, 0x0442,
    0x0442, 0x0442, 0x0442, 0x0442, 0x043a, 0x043a, 0x043a, 0x043a,
    0x043a, 0x043a, 0x0442, 0x0445, 0x0442, 0x0475, 0x0442, 0x0442,
    0x0442, 0x0442, 0x0442, 0x0442, 0x0443, 0x043c, 0x0442, 0x0800,
    0x0442, 0x07d6, 0x0442, 0x07d7, 0x043a, 0x043a, 0x043a, 0x043a,
    0x043a, 0x043a, 0x043a, 0x0459, 0x0832, 0x0000, 0x0000, 0x0000,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0000, 0x0000, 0x0092, 0x0092, 0x0092, 0x0092,
    0x0092, 0x0092, 0x0092, 0x083a,
};
static const uint8_t s_stage3[] = {
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x41, 0x40, 0xc0, 0x40, 0x40, 0xc0, 0x40, 0x40,
    0xc0, 0x4c, 0xc0, 0x40, 0x40, 0x41, 0xcc, 0x40,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0xc0, 0xc0,
    0xc0, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0xc0,
    0x40, 0x40, 0x40, 0x40, 0xc0, 0x40, 0xc0, 0xc0,
    0xc0, 0x40, 0xc0, 0xc0, 0x40, 0x40, 0x40, 0xc0,
    0xc0, 0xc0, 0x40, 0xc0, 0x40, 0xc0, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0xc0, 0xc0, 0xc0, 0x40,
    0x40, 0x40, 0x40, 0xc0, 0xc0, 0xc0, 0x40, 0xc0,
    0x40, 0x40, 0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0x40,
    0xc0, 0x40, 0x40, 0xc0, 0x40, 0xc0, 0x40, 0xc0,
    0x40, 0xc0, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x40,
    0x40, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0xc0, 0x40,
    0xc0, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x40, 0x02, 0x02,
    0x40, 0x02, 0x02, 0x40, 0x02, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x40, 0x40, 0x02, 0x02, 0x02,
    0x40, 0x02, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x40,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x40, 0x40, 0x02,
    0x40, 0x02, 0x02, 0x02, 0x02, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x04, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x02, 0x40, 0x40, 0x02, 0x02, 0x40,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x40, 0x02, 0x02,
    0x02, 0x40, 0x40, 0x40, 0x40, 0x04, 0x04, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x02, 0x02, 0x04, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x42, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b,
    0x4b, 0x4b, 0x02, 0x42, 0x02, 0x40, 0x42, 0x42,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42,
    0x42, 0x42, 0x42, 0x0a, 0x42, 0x42, 0x40, 0x40,
    0x02, 0x02, 0x40, 0x40, 0x40, 0x40, 0x02, 0x42,
    0x42, 0x40, 0x40, 0x40, 0x40, 0x4b, 0x40, 0x4b,
    0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x40, 0x4b, 0x40,
    0x40, 0x40, 0x4b, 0x4b, 0x40, 0x40, 0x02, 0x40,
    0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x40, 0x40,
    0x42, 0x40, 0x40, 0x42, 0x42, 0x0a, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x40, 0x40,
    0x40, 0x40, 0x4b, 0x4b, 0x40, 0x4b, 0x4b, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x02, 0x40, 0x02,
    0x02, 0x42, 0x40, 0x40, 0x40, 0x40, 0x02, 0x40,
    0x42, 0x42, 0x02, 0x02, 0x40, 0x40, 0x40, 0x40,
    0x02, 0x40, 0x40, 0x02, 0x02, 0x02, 0x40, 0x40,
    0x40, 0x02, 0x40, 0x40, 0x4b, 0x40, 0x4b, 0x4b,
    0x40, 0x4b, 0x4b, 0x4b, 0x42, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x40, 0x02, 0x42, 0x40, 0x42, 0x42,
    0x0a, 0x40, 0x40, 0x4b, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x4b, 0x4b, 0x40, 0x40, 0x02, 0x40,
    0x42, 0x02, 0x40, 0x40, 0x40, 0x40, 0x40, 0x02,
    0x02, 0x42, 0x40, 0x4b, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x02, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x42, 0x42, 0x02, 0x42, 0x42, 0x40, 0x40,
    0x40, 0x42, 0x42, 0x40, 0x42, 0x42, 0x42, 0x02,
    0x40, 0x40, 0x02, 0x42, 0x42, 0x42, 0x02, 0x40,
    0x40, 0x40, 0x4b, 0x4b, 0x40, 0x40, 0x02, 0x40,
    0x02, 0x02, 0x42, 0x42, 0x42, 0x42, 0x40, 0x02,
    0x02, 0x40, 0x02, 0x02, 0x02, 0x0a, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x02, 0x02, 0x40, 0x4b, 0x4b,
    0x4b, 0x40, 0x40, 0x40, 0x40, 0x40, 0x02, 0x40,
    0x42, 0x02, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40,
    0x02, 0x42, 0x40, 0x42, 0x42, 0x02, 0x02, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x40, 0x02,
    0x02, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x4b,
    0x4b, 0x4b, 0x02, 0x02, 0x40, 0x42, 0x42, 0x02,
    0x02, 0x02, 0x02, 0x40, 0x42, 0x42, 0x40, 0x42,
    0x42, 0x42, 0x0a, 0x44, 0x40, 0x40, 0x02, 0x40,
    0x40, 0x40, 0x40, 0x42, 0x42, 0x02, 0x02, 0x02,
    0x40, 0x02, 0x40, 0x42, 0x42, 0x42, 0x42, 0x42,
    0x42, 0x42, 0x42, 0x40, 0x40, 0x42, 0x42, 0x40,
    0x40, 0x40, 0x40, 0x02, 0x40, 0x42, 0x02, 0x02,
    0x02, 0x02, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x40, 0x02, 0x02, 0x42, 0x42, 0x02, 0x02,
    0x40, 0x40, 0x40, 0x40, 0x02, 0x02, 0x40, 0x40,
    0x02, 0x40, 0x42, 0x02, 0x02, 0x40, 0x85, 0x85,
    0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x46, 0x46,
    0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x47, 0x47,
    0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x40, 0x40,
    0x02, 0x02, 0x02, 0x42, 0x40, 0x40, 0x02, 0x02,
    0x42, 0x40, 0x40, 0x40, 0x40, 0x02, 0x02, 0x42,
    0x02, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02,
    0x42, 0x02, 0x02, 0x02, 0x42, 0x42, 0x42, 0x42,
    0x02, 0x42, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40,
    0x42, 0x42, 0x02, 0x42, 0x42, 0x42, 0x42, 0x42,
    0x02, 0x02, 0x02, 0x40, 0x40, 0x40, 0x40, 0x02,
    0x42, 0x42, 0x02, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x42, 0x02, 0x42, 0x02, 0x40, 0x02, 0x40, 0x40,
    0x02, 0x02, 0x02, 0x42, 0x42, 0x42, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x40, 0x40, 0x40, 0x40, 0x02,
    0x42, 0x02, 0x02, 0x02, 0x42, 0x02, 0x42, 0x42,
    0x42, 0x40, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42,
    0x42, 0x02, 0x02, 0x42, 0x02, 0x02, 0x02, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x02, 0x42, 0x02,
    0x02, 0x42, 0x42, 0x42, 0x02, 0x42, 0x02, 0x40,
    0x40, 0x40, 0x40, 0x42, 0x42, 0x42, 0x42, 0x02,
    0x02, 0x02, 0x02, 0x40, 0x02, 0x02, 0x02, 0x02,
    0x40, 0x40, 0x40, 0x40, 0x02, 0x40, 0x40, 0x42,
    0x40, 0x40, 0x40, 0x02, 0x02, 0x0d, 0x02, 0x02,
    0xc0, 0x40, 0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0x40,
    0x40, 0xc0, 0xc0, 0x40, 0x40, 0x41, 0x41, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x40, 0xc0, 0x40, 0xc0,
    0xc0, 0x40, 0xc0, 0x40, 0x40, 0x40, 0xc0, 0x4c,
    0x40, 0xc0, 0x40, 0x4c, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x02, 0x02, 0x02, 0x02, 0x02, 0x41,
    0x02, 0x02, 0x40, 0x40, 0x40, 0xc0, 0x40, 0xc0,
    0x40, 0x40, 0xc0, 0xcc, 0x40, 0x40, 0x40, 0xc0,
    0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xcc, 0xcc,
    0xcc, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x4c,
    0x4c, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x40,
    0xc0, 0x40, 0x40, 0x40, 0xc0, 0x40, 0x40, 0xc0,
    0x40, 0x40, 0x40, 0xc0, 0x40, 0x40, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0x40, 0xc0, 0x40, 0x40, 0x40,
    0xc0, 0x40, 0x40, 0x40, 0xc0, 0xc0, 0x40, 0x40,
    0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0x40, 0x8c, 0x8c,
    0x40, 0x40, 0x40, 0x40, 0x4c, 0x80, 0x80, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x4c, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x4c, 0x40, 0x8c, 0x8c,
    0x8c, 0x8c, 0x4c, 0x4c, 0x4c, 0x8c, 0x4c, 0x4c,
    0x8c, 0x40, 0x40, 0x40, 0x40, 0x4c, 0x4c, 0x4c,
    0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0xc0, 0xcc,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x4c, 0x4c, 0x40,
    0x40, 0x40, 0x40, 0xc0, 0xc0, 0x40, 0x40, 0xcc,
    0xc0, 0x40, 0x40, 0x40, 0x40, 0xc0, 0xc0, 0x40,
    0x40, 0xc0, 0x40, 0x40, 0xc0, 0xc0, 0x40, 0x40,
    0x40, 0x4c, 0x4c, 0x8c, 0x8c, 0x40, 0x4c, 0x4c,
    0x4c, 0x4c, 0x4c, 0xcc, 0xc0, 0x4c, 0xcc, 0x4c,
    0x4c, 0x4c, 0x4c, 0xcc, 0xcc, 0x4c, 0x4c, 0x4c,
    0x40, 0x8c, 0x8c, 0x4c, 0x4c, 0x4c, 0x4c, 0xcc,
    0x4c, 0xcc, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c,
    0x4c, 0x4c, 0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x8c,
    0x8c, 0x8c, 0x4c, 0x4c, 0x4c, 0x4c, 0xcc, 0xcc,
    0x4c, 0xcc, 0xcc, 0xcc, 0x4c, 0xcc, 0xcc, 0x4c,
    0xcc, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x40,
    0x40, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x4c,
    0x4c, 0x4c, 0x8c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c,
    0x4c, 0xcc, 0xcc, 0x4c, 0x4c, 0x8c, 0x8c, 0x4c,
    0x4c, 0x4c, 0x4c, 0x4c, 0x8c, 0x8c, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0x8c, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x8c, 0x8c, 0xcc,
    0x8c, 0xcc, 0xcc, 0x8c, 0xcc, 0xcc, 0x8c, 0xcc,
    0xcc, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x8c, 0x40,
    0x40, 0x4c, 0x4c, 0x4c, 0x40, 0x4c, 0x40, 0x4c,
    0x40, 0x8c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x4c, 0x40, 0x40, 0x4c, 0x40, 0x40, 0x40,
    0x40, 0x8c, 0x40, 0x8c, 0x40, 0x40, 0x40, 0x8c,
    0x8c, 0x8c, 0x40, 0x8c, 0x40, 0x40, 0x40, 0x4c,
    0x4c, 0x4c, 0x4c, 0x4c, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x8c, 0x8c, 0x8c, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x8c, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x4c, 0x4c, 0x4c, 0x40, 0x40, 0x40, 0x8c,
    0x8c, 0x40, 0x40, 0x40, 0x40, 0x8c, 0xc0, 0xc0,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x40, 0x80, 0x80, 0x80, 0x80, 0x80, 0x40, 0x40,
    0x40, 0x40, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x40, 0x40, 0x80, 0x80, 0x02, 0x02, 0x02, 0x02,
    0x82, 0x82, 0x8c, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x8c, 0x80, 0x40, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x40, 0x02, 0x02, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x80, 0x8c, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x40, 0x40, 0x02, 0x40, 0x40, 0x40, 0x02,
    0x40, 0x40, 0x40, 0x42, 0x42, 0x02, 0x02, 0x42,
    0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42,
    0x42, 0x42, 0x42, 0x02, 0x02, 0x40, 0x40, 0x85,
    0x85, 0x85, 0x85, 0x85, 0x40, 0x40, 0x40, 0x02,
    0x42, 0x42, 0x02, 0x02, 0x42, 0x42, 0x02, 0x02,
    0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42,
    0x02, 0x02, 0x42, 0x42, 0x02, 0x02, 0x40, 0x40,
    0x40, 0x40, 0x02, 0x42, 0x40, 0x40, 0x02, 0x40,
    0x02, 0x02, 0x02, 0x40, 0x40, 0x02, 0x40, 0x40,
    0x40, 0x42, 0x02, 0x02, 0x42, 0x42, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x42, 0x02, 0x40, 0x02, 0x42,
    0x42, 0x40, 0x42, 0x02, 0x40, 0x40, 0x88, 0x89,
    0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x88,
    0x89, 0x89, 0x89, 0x89, 0x40, 0x40, 0x40, 0x40,
    0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x40,
    0x40, 0x40, 0x47, 0x47, 0x47, 0x47, 0x47, 0x40,
    0x40, 0x40, 0x40, 0x41, 0x02, 0x02, 0x02, 0x40,
    0xc0, 0x40, 0x40, 0x02, 0x02, 0x02, 0x40, 0x02,
    0x02, 0x40, 0x40, 0x40, 0x02, 0x02, 0x40, 0x40,
    0x40, 0x02, 0x02, 0x02, 0x02, 0x40, 0x40, 0x42,
    0x02, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x02,
    0x40, 0x40, 0x02, 0x02, 0x40, 0x40, 0x40, 0x42,
    0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x02,
    0x02, 0x40, 0x40, 0x04, 0x40, 0x40, 0x42, 0x40,
    0x44, 0x44, 0x40, 0x40, 0x40, 0x40, 0x02, 0x02,
    0x02, 0x02, 0x40, 0x42, 0x02, 0x40, 0x40, 0x40,
    0x40, 0x42, 0x42, 0x42, 0x02, 0x02, 0x42, 0x42,
    0x02, 0x42, 0x02, 0x02, 0x40, 0x40, 0x40, 0x02,
    0x02, 0x40, 0x42, 0x42, 0x02, 0x42, 0x42, 0x42,
    0x42, 0x40, 0x40, 0x42, 0x42, 0x42, 0x40, 0x40,
    0x42, 0x42, 0x40, 0x40, 0x02, 0x02, 0x40, 0x42,
    0x40, 0x40, 0x42, 0x40, 0x42, 0x42, 0x42, 0x40,
    0x42, 0x42, 0x02, 0x42, 0x02, 0x44, 0x02, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x02, 0x02, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x42, 0x42, 0x02, 0x02, 0x02,
    0x42, 0x02, 0x40, 0x02, 0x42, 0x02, 0x42, 0x42,
    0x42, 0x42, 0x02, 0x42, 0x02, 0x02, 0x40, 0x40,
    0x40, 0x40, 0x42, 0x42, 0x42, 0x42, 0x02, 0x02,
    0x42, 0x02, 0x02, 0x02, 0x42, 0x42, 0x02, 0x42,
    0x02, 0x40, 0x40, 0x40, 0x02, 0x42, 0x02, 0x42,
    0x42, 0x40, 0x40, 0x02, 0x02, 0x02, 0x02, 0x42,
    0x02, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40,
    0x42, 0x40, 0x40, 0x02, 0x02, 0x42, 0x02, 0x44,
    0x42, 0x44, 0x42, 0x02, 0x40, 0x40, 0x40, 0x40,
    0x02, 0x02, 0x42, 0x42, 0x42, 0x42, 0x02, 0x40,
    0x40, 0x40, 0x42, 0x40, 0x40, 0x40, 0x02, 0x42,
    0x44, 0x02, 0x02, 0x02, 0x02, 0x40, 0x40, 0x40,
    0x40, 0x44, 0x44, 0x44, 0x44, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x40, 0x42, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x42, 0x02, 0x02, 0x42, 0x02,
    0x02, 0x40, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x40, 0x40, 0x02, 0x40, 0x02, 0x02, 0x40, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x44, 0x02, 0x40,
    0x40, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x02,
    0x02, 0x40, 0x42, 0x42, 0x02, 0x42, 0x02, 0x40,
    0x40, 0x40, 0x02, 0x02, 0x42, 0x42, 0x40, 0x02,
    0x02, 0x44, 0x42, 0x40, 0x40, 0x40, 0x40, 0x02,
    0x02, 0x02, 0x40, 0x40, 0x40, 0x42, 0x42, 0x02,
    0x42, 0x02, 0x40, 0x40, 0x40, 0x40, 0x40, 0x46,
    0x40, 0x40, 0x40, 0x46, 0x46, 0x46, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80, 0x02,
    0x40, 0x40, 0x40, 0x82, 0x82, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80, 0x40,
    0x80, 0x80, 0x40, 0x40, 0x80, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x80, 0x80, 0x80, 0x40, 0x40, 0x80,
    0x40, 0x40, 0x02, 0x02, 0x02, 0x40, 0x40, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x4c, 0x4c, 0x4c, 0x4c,
    0x8c, 0x4c, 0x4c, 0x4c, 0xc0, 0xc0, 0xc0, 0x40,
    0x40, 0x4c, 0x4c, 0x4c, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0x40, 0x4c, 0xc0, 0xc0, 0x40, 0x40,
    0x4c, 0x4c, 0x4c, 0x4c, 0xcc, 0xcc, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xcc, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0x8c, 0xc0, 0x8c, 0x8c,
    0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c,
    0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43,
    0x80, 0x8c, 0x8c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c,
    0x80, 0x80, 0x8c, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x80, 0x4c,
    0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x8c, 0x8c,
    0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x8c,
    0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x4c, 0x8c, 0x8c,
    0x8c, 0x4c, 0x4c, 0x4c, 0x4c, 0x8c, 0x4c, 0x4c,
    0x4c, 0x8c, 0x4c, 0x4c, 0x4c, 0x8c, 0x8c, 0x8c,
    0x82, 0x82, 0x82, 0x82, 0x82, 0x8c, 0x4c, 0x8c,
    0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x4c, 0x4c, 0x8c,
    0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x40, 0x40, 0x4c,
    0x4c, 0x4c, 0x8c, 0x8c, 0x8c, 0x8c, 0x4c, 0x40,
    0x40, 0x40, 0x40, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c,
    0x4c, 0x40, 0x40, 0x40, 0x40, 0x8c, 0x8c, 0x8c,
    0x8c, 0x40, 0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x8c,
    0x40, 0x8c, 0x41, 0x02, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0x40, 0x40,
};
static const uint32_t s_joinRules[2][16] = {
    {
        0x03cfffcf, 0x0fffffff, 0x03cfffcf, 0x03cfff4f,
        0x0000000c, 0x03c0c3cf, 0x03cf0fcf, 0x03cf3fcf,
        0x03cf0fcf, 0x03cf3fcf, 0x030fffcf, 0x03cfffcf,
        0x03cfffcf, 0x00cfffcf, 0x00000000, 0x00000000,
    },
    {
        0x03cfffcf, 0x0fffffff, 0x03cfffcf, 0x03cfffcf,
        0x0000000c, 0x03c0c3cf, 0x03cf0fcf, 0x03cf3fcf,
        0x03cf0fcf, 0x03cf3fcf, 0x030fffcf, 0x03cfffcf,
        0x03cfffcf, 0x00cfffcf, 0x00000000, 0x00000000,
    },
};
static int ucdLookup(const char32_t cp)
{
    const uint16_t s0 = s_stage0[cp >> 11];
    const uint16_t s1 = s_stage1[s0 + ((cp >> 6) & 31)];
    const uint16_t s2 = s_stage2[s1 + ((cp >> 3) & 7)];
    const uint8_t s3 = s_stage3[s2 + ((cp >> 0) & 7)];
    return s3;
}
static int ucdGraphemeJoins(const int state, const int lead, const int trail)
{
    const int l = lead & 15;
    const int t = trail & 15;
    return (s_joinRules[state][l] >> (t * 2)) & 3;
}
static bool ucdGraphemeDone(const int state)
{
    return state == 3;
}
static int ucdToCharacterWidth(const int val)
{
    return val >> 6;
}
// clang-format on
// End of generated code

/*
 * This file is part of mpv.
 *
 * mpv is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * mpv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with mpv.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "common/common.h"

int term_disp_width(bstr str, int max_width, const unsigned char **cut_pos)
{
    static const int ambiguous_width = 1;

    int width = 0;

    const unsigned char *prev_pos = str.start;
    while (str.len) {
        int current_width = 0;

        if (bstr_eatstart0(&str, "\033[")) {
            while (str.len && !((*str.start >= '@' && *str.start <= '~') || *str.start == 'm'))
                str = bstr_cut(str, 1);
            str = bstr_cut(str, 1);
            goto next;
        }

        prev_pos = str.start;
        int cp = bstr_decode_utf8(str, &str);

        // Stop processing on any invalid input
        if (cp < 0)
            return 0;

        if (cp == '\r') {
            width = 0;
            goto next;
        }

        if (cp == '\t') {
            // Assume tabstop width is 8
            current_width = 8 - width % 8;
            goto next;
        }

        if (cp < 0x20)
            goto next;

        if (cp <= 0x7E) {
            current_width = 1;
            goto next;
        }

        int state = 0;

        while (true) {
            int lead = ucdLookup(cp);
            int w = ucdToCharacterWidth(lead);
            if (w == 3)
                w = ambiguous_width;

            // U+FE0F Variation Selector-16 is used to turn unqualified Emojis into qualified ones.
            // By convention, this turns them from being ambiguous width (= narrow) into wide ones.
            // We achieve this here by explicitly giving this codepoint a wide width.
            // Later down below we'll clamp width back to <= 2.
            if (cp == 0xFE0F)
                w = 2;

            current_width += w;

            if (!str.len)
                break;

            // Fetch next codepoint in grapheme cluster
            bstr cluster_end;
            cp = bstr_decode_utf8(str, &cluster_end);
            // Stop processing on any invalid input
            if (cp < 0)
                return 0;
            int trail = ucdLookup(cp);

            state = ucdGraphemeJoins(state, lead, trail);
            if (ucdGraphemeDone(state))
                break;

            str = cluster_end;
        }

        current_width = MPMIN(current_width, 2);
next:
        if (width + current_width > max_width) {
            mp_assert(prev_pos < str.start + str.len);
            *cut_pos = prev_pos;
            break;
        }
        width += current_width;
        if (width == max_width) {
            if (str.len)
                *cut_pos = str.start;
            break;
        }
    }

    return width;
}
