(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1037949,      28519]*)
(*NotebookOutlinePosition[   1038638,      28543]*)
(*  CellTagsIndexPosition[   1038594,      28539]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Initialization", "Section"],

Cell[BoxData[
    \(Needs["\<Optimization`UnconstrainedProblems`\>"]\)], "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving Storn and Price's fitting problem", "Section"],

Cell["\<\
The problem is to find a 8th (or 16th) degree polynomial that lies \
between -1 and 1 when the argument is between -1 and 1, but is bigger than \
ChebyshevT[8, x] (or Chebyshev[16,x]) when x is at -1.2 and 1.2. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ChebyshevT[8, x]\)], "Input"],

Cell[BoxData[
    \(1 - 32\ x\^2 + 160\ x\^4 - 256\ x\^6 + 128\ x\^8\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[ChebyshevT[8, x], {x, \(-1.2\), 1.2}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.396825 0.133002 0.118287 [
[.10317 .1205 -6 -9 ]
[.10317 .1205 6 0 ]
[.30159 .1205 -12 -9 ]
[.30159 .1205 12 0 ]
[.69841 .1205 -9 -9 ]
[.69841 .1205 9 0 ]
[.89683 .1205 -3 -9 ]
[.89683 .1205 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .25129 -6 -4.5 ]
[.4875 .25129 0 4.5 ]
[.4875 .36958 -6 -4.5 ]
[.4875 .36958 0 4.5 ]
[.4875 .48786 -6 -4.5 ]
[.4875 .48786 0 4.5 ]
[.4875 .60615 -6 -4.5 ]
[.4875 .60615 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .133 m
.10317 .13925 L
s
[(-1)] .10317 .1205 0 1 Mshowa
.30159 .133 m
.30159 .13925 L
s
[(-0.5)] .30159 .1205 0 1 Mshowa
.69841 .133 m
.69841 .13925 L
s
[(0.5)] .69841 .1205 0 1 Mshowa
.89683 .133 m
.89683 .13925 L
s
[(1)] .89683 .1205 0 1 Mshowa
.125 Mabswid
.14286 .133 m
.14286 .13675 L
s
.18254 .133 m
.18254 .13675 L
s
.22222 .133 m
.22222 .13675 L
s
.2619 .133 m
.2619 .13675 L
s
.34127 .133 m
.34127 .13675 L
s
.38095 .133 m
.38095 .13675 L
s
.42063 .133 m
.42063 .13675 L
s
.46032 .133 m
.46032 .13675 L
s
.53968 .133 m
.53968 .13675 L
s
.57937 .133 m
.57937 .13675 L
s
.61905 .133 m
.61905 .13675 L
s
.65873 .133 m
.65873 .13675 L
s
.7381 .133 m
.7381 .13675 L
s
.77778 .133 m
.77778 .13675 L
s
.81746 .133 m
.81746 .13675 L
s
.85714 .133 m
.85714 .13675 L
s
.06349 .133 m
.06349 .13675 L
s
.02381 .133 m
.02381 .13675 L
s
.93651 .133 m
.93651 .13675 L
s
.97619 .133 m
.97619 .13675 L
s
.25 Mabswid
0 .133 m
1 .133 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .25129 m
.50625 .25129 L
s
[(1)] .4875 .25129 1 0 Mshowa
.5 .36958 m
.50625 .36958 L
s
[(2)] .4875 .36958 1 0 Mshowa
.5 .48786 m
.50625 .48786 L
s
[(3)] .4875 .48786 1 0 Mshowa
.5 .60615 m
.50625 .60615 L
s
[(4)] .4875 .60615 1 0 Mshowa
.125 Mabswid
.5 .03837 m
.50375 .03837 L
s
.5 .06203 m
.50375 .06203 L
s
.5 .08569 m
.50375 .08569 L
s
.5 .10934 m
.50375 .10934 L
s
.5 .15666 m
.50375 .15666 L
s
.5 .18032 m
.50375 .18032 L
s
.5 .20397 m
.50375 .20397 L
s
.5 .22763 m
.50375 .22763 L
s
.5 .27495 m
.50375 .27495 L
s
.5 .2986 m
.50375 .2986 L
s
.5 .32226 m
.50375 .32226 L
s
.5 .34592 m
.50375 .34592 L
s
.5 .39323 m
.50375 .39323 L
s
.5 .41689 m
.50375 .41689 L
s
.5 .44055 m
.50375 .44055 L
s
.5 .46421 m
.50375 .46421 L
s
.5 .51152 m
.50375 .51152 L
s
.5 .53518 m
.50375 .53518 L
s
.5 .55884 m
.50375 .55884 L
s
.5 .58249 m
.50375 .58249 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.0897 .61803 m
.094 .473 L
.0995 .32847 L
.10458 .22546 L
.10924 .15308 L
.11181 .12109 L
.11425 .09539 L
.11651 .07536 L
.11898 .0573 L
.12121 .04413 L
.12331 .03422 L
.12461 .0292 L
.12602 .0247 L
.12719 .02164 L
.12848 .01897 L
.12988 .01684 L
.13064 .016 L
.13136 .01541 L
.13263 .01481 L
.13335 .01472 L
.134 .01478 L
.13527 .01528 L
.13644 .01618 L
.13773 .01761 L
.1391 .01961 L
.1414 .02398 L
.14393 .03011 L
.15402 .06447 L
.16328 .10353 L
.17408 .15001 L
.18413 .18856 L
.19328 .21673 L
.1984 .22903 L
.20306 .23788 L
.20554 .24169 L
.20817 .24502 L
.21105 .24785 L
.21233 .24883 L
.21371 .2497 L
.215 .25034 L
.21618 .25078 L
.21737 .25109 L
.21849 .25125 L
.2198 .25128 L
.22101 .25117 L
.22171 .25104 L
.22234 .25088 L
.22376 .25039 L
.22497 .24983 L
.22609 .24919 L
Mistroke
.22865 .24733 L
.23114 .24498 L
.23381 .24191 L
.24304 .22728 L
.25395 .20346 L
.26388 .17754 L
.28461 .11855 L
.30377 .06873 L
.31339 .04851 L
.3224 .03346 L
.3273 .02703 L
.3318 .0223 L
.33678 .01838 L
.3394 .01688 L
.34072 .01627 L
.34216 .01573 L
.3435 .01532 L
.34474 .01504 L
.34592 .01485 L
.34717 .01474 L
.34829 .01472 L
.34934 .01476 L
.35049 .01487 L
.35173 .01508 L
.35304 .01539 L
.35447 .01583 L
.35707 .01693 L
.35959 .01834 L
.36194 .01996 L
.37085 .02861 L
.37535 .0344 L
.38032 .04182 L
.39964 .07894 L
.42049 .12791 L
.44011 .17454 L
.45049 .19685 L
.4616 .21747 L
.47233 .23333 L
.47741 .23922 L
.4821 .24366 L
.4868 .24713 L
.48928 .24854 L
.49191 .24972 L
.49301 .25012 L
.49419 .25048 L
.49521 .25074 L
.49633 .25097 L
.49763 .25115 L
.49887 .25126 L
.50007 .25129 L
Mistroke
.50119 .25126 L
.50247 .25114 L
.50312 .25106 L
.50383 .25094 L
.50509 .25067 L
.50627 .25035 L
.50892 .24938 L
.51176 .24798 L
.51698 .24443 L
.52172 .24011 L
.53128 .22849 L
.54034 .21417 L
.57869 .12992 L
.59809 .08398 L
.60839 .06213 L
.61949 .04213 L
.62464 .03442 L
.63006 .02755 L
.63509 .02241 L
.63753 .02036 L
.63976 .01876 L
.64186 .01749 L
.64415 .01637 L
.64541 .01588 L
.64656 .0155 L
.64766 .01521 L
.64884 .01497 L
.65003 .01481 L
.65114 .01473 L
.65246 .01473 L
.65367 .01481 L
.65492 .01498 L
.65563 .01512 L
.65629 .01527 L
.65877 .01607 L
.66007 .01663 L
.66143 .01732 L
.66387 .01881 L
.66938 .02343 L
.67414 .02879 L
.67935 .03606 L
.69798 .07282 L
.71918 .12932 L
.73847 .18393 L
.74808 .20832 L
.75314 .21964 L
.75851 .23014 L
.76319 .23781 L
.76568 .24126 L
.76836 .24445 L
Mistroke
.77081 .24686 L
.77305 .24863 L
.77413 .24933 L
.77531 .24997 L
.77635 .25044 L
.77745 .25082 L
.77809 .25099 L
.77878 .25113 L
.78 .25127 L
.78069 .25129 L
.78143 .25126 L
.78213 .25118 L
.78276 .25106 L
.78399 .25073 L
.78469 .25047 L
.78533 .2502 L
.78776 .24876 L
.78992 .24699 L
.7923 .24448 L
.79712 .23759 L
.80232 .22745 L
.80793 .21344 L
.81809 .18065 L
.83773 .09916 L
.84811 .05619 L
.85382 .03654 L
.85663 .02866 L
.85921 .0227 L
.86172 .01836 L
.86298 .01676 L
.86369 .01606 L
.86437 .01552 L
.8651 .01509 L
.86576 .01483 L
.86648 .01472 L
.86726 .01478 L
.86794 .01501 L
.86866 .01542 L
.86996 .01665 L
.87123 .01847 L
.8726 .02117 L
.8739 .02446 L
.87509 .02816 L
.87735 .03705 L
.87973 .04932 L
.88201 .06405 L
.88444 .08338 L
.88884 .12863 L
.89407 .20238 L
.89883 .29152 L
Mistroke
.90364 .40653 L
.90876 .56002 L
Mfstroke
.90876 .56002 m
.91019 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oSoooool0
0ol0003oooooooooo`2>ooooo`00Soooool00ol0003oooooooooo`2>ooooo`00Q_ooool3o`0000Ko
oooo00?o0000ooooooooool0S_ooool008Oooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`2>ooooo`009_ooool3o`0003Wooooo1Ol0000Hooooo`Go00000oooool00ol0003ooooooooo
o`05ooooo`?o00009_ooool5o`0003Wooooo0ol0000Wooooo`009_ooool01?l0003oooooo`000?l0
000fooooo`?o00000oooool2o`0001oooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0Uooooo`;o00000oooool3o`0003Oooooo00?o0000ooooool000009oooool002Gooooo00Go0000
ooooooooooooooooo`00000eooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02?ooooo0_l00007ooooo`03o`000?oo
oooooooo03Cooooo00Go0000ooooooooooooooooo`00000Vooooo`009Oooool01Ol0003ooooooooo
oooooooo000003Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Jooooo`;o0000
1oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
<oooool01Ol0003ooooooooooooooooo000002Kooooo000Tooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool0<Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01[ooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool0<Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02?ooooo
000Tooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0<?ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool08Oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0Sooooo`009?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo033ooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo023ooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool08oooool002Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0^oooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool08?ooool2o`00027ooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool08oooool002?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0]ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0Oooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo02?ooooo000Sooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
;Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0
7oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Rooooo`008oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo02_ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Nooooo`03o`000?oo
oooooooo01kooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0[ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool08_ooool002?ooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`0[ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool07Oooool0
0ol0003oooooooooo`0Nooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0:oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo02;ooooo000Sooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo
01gooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo
02[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Rooooo`008oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool05Oooool00ol0003o
ooooooooo`0Looooo`;o00007_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo02[o
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Rooooo`008oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool05Oooool00ol0003ooooo
ooooo`0Looooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool05?ooool00ol0003ooooo
ooooo`0Zooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool08_ooool002;ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool06oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo01Gooooo00?o
0000ooooooooool0:?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo02;ooooo000R
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0H
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0F
ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0R
ooooo`008_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo02Kooooo00?o0000oooo
ooooool06Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool08_ooool002;ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Uooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Jooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo027ooooo000Rooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
9Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0
6_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0Qooooo`008_ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo02Cooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`0Hooooo`;o00006_oo
ool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0Qooooo`008Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo02Cooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooo
oooo01Wooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool08Oooool001oooooo0ol0000<ooooo`03o`000?oooooooooo
02;ooooo0ol00003ooooo`03o`000?oooooooooo00;ooooo0ol0000Cooooo`03o`000?oooooooooo
01Sooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Cooooo`;o00001?ooool01Ol0
003oooooooooool0003ooooo00?o00008_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
000000;o00007oooool0023ooooo0_l0000=ooooo`03o`000?oooooooooo023ooooo00Co0000oooo
ool0003o00001oooool01Ol0003ooooooooooooooooo000001?ooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo01;ooooo00Co0000oooooooooooo0000
1_ooool2o`0000?ooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0:ooooo`04o`00
0?ooooooooooo`00023ooooo000Hooooo`Go00000oooool2o`0000gooooo00?o0000ooooooooool0
6Oooool5o`0000;ooooo00Co0000ooooool0003o00002oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Cooooo`04
o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Noooo
o`03o`000?oooooooooo00[ooooo00Co0000oooooooooooo00008?ooool0023ooooo0_l0000=oooo
o`03o`000?oooooooooo023ooooo00Co0000ooooool0003o00002oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0C
ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Pooooo`03o`00
0?oooooooooo00[ooooo00Co0000oooooooooooo00008?ooool0023ooooo0_l0000=ooooo`03o`00
0?oooooooooo023ooooo0_l000000ooooooo0000ooooo`06ooooo`Co00005Oooool00ol0003ooooo
ooooo`0Fooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool05?ooool01?l0003ooooo
ooooool00007ooooo`Co00008Oooool00ol0003oooooooooo`0:ooooo`04o`000?ooooooooooo`00
023ooooo000Oooooo`?o00003Oooool00ol0003oooooooooo`0Pooooo`;o000000?oooooo`000?oo
ool01_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo01Kooooo0_l0000Gooooo`03
o`000?oooooooooo01Cooooo00Co0000oooooooooooo00001oooool2o`0002;ooooo00?o0000oooo
ooooool03?ooool3o`00023ooooo000Pooooo`;o00003_ooool00ol0003oooooooooo`0Pooooo`;o
00002?ooool5o`0001Cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Fooooo`03
o`000?oooooooooo01Gooooo0_l00008ooooo`Go00007oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooo0000023ooooo000Qooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
7oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0
5Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`0Pooooo`008Oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo01oooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Eooooo`03o`000?oo
oooooooo01Gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Oooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool08?ooool0027ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`0Oooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool07_ooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo023ooooo000Qooooo`03o`000?oooooooooo
00gooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo
01kooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Pooooo`008Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool09?ooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool09Oooool00ol0003o
ooooooooo`0Mooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool08?ooool00003oooo
ool0003o00000?oo00007?l00002ooooo`002?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooool000002Oooool00ol0003oooooooooo`04ooooo`05o`000?oo
ooooooooooooool000002_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool2o`0000[ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooool000002_ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool01?l0003ooooo
ooooool00007ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00002_ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo000Pooooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01_o
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Pooooo`008?ooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool09oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0:?ooool00ol0003ooooo
ooooo`0Kooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool08?ooool0023ooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo02Wooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02Wooooo00?o
0000ooooooooool06Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01oooooo000P
ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0Y
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Z
ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0O
ooooo`008?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01Wooooo00?o0000oooo
ooooool0:_ooool00ol0003oooooooooo`0Aooooo`;o00004Oooool00ol0003oooooooooo`0[oooo
o`03o`000?oooooooooo01Sooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Ooooo
o`008?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool0:oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool0:oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool07oooool0023ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Hooooo`03o`00
0?oooooooooo02_ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo02cooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo01oooooo000Pooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03ooo
ool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Oooooo`008?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo01Kooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool07oooool0023ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool05Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo01oooooo000Pooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo01Co
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Oooooo`008?ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0<?ooool00ol0003ooooo
ooooo`0=ooooo`;o00003_ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Oooooo`008?ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0<Oooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0<_ooool00ol0003ooooooooo
o`0Cooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool07oooool0023ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo03;ooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo03;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo01kooooo000Ooooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0boooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0coooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Noooo
o`007oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0<oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool0=?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool07_ooool001oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo03Cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo03Cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo01kooooo000Oooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooooooo`0Nooooo`007oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0:ooooo`;o00002oooool0
0ol0003oooooooooo`0fooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`0Nooooo`007oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool07_ooool001oooooo00?o0000ooooooooool05Oooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo03Oooooo00?o0000ooooooooool03_ooool00ol0003o
ooooooooo`0Fooooo`03o`000?oooooooooo01kooooo000Oooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Nooooo`007oooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0>_ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0>_ooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool07_ooool001oooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo03[ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo03_ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01kooooo000Ooooo
o`03o`000?oooooooooo01Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0loooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0loooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Noooo
o`007oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool0?Oooool00ol0003oooooooooo`06ooooo`;o00001oooool00ol0003oooooooooo`0mooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Nooooo`00
7oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
?oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
?oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0
7_ooool001oooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo047ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo047ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Iooooo`03o`000?oo
oooooooo01kooooo000Oooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`12ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`12ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool06Oooool0
0ol0003oooooooooo`0Nooooo`007oooool00ol0003oooooooooo`0Iooooo`;o00001_ooool00ol0
003oooooooooo`10ooooo`?o000000?oooooo`000?ooool00oooool01?l0003oooooooooooooool2
o`0004Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooo
oooo01kooooo000Oooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`12ooooo`04o`000?ooooooooooooooo`;o00000_ooool01?l0003oooooooooool0
0019ooooo`;o00000oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo01kooooo000O
ooooo`03o`000?oooooooooo01_ooooo1Ol00015ooooo`03o`000?oooooooooo00?ooooo1_l0001:
ooooo`Go00007_ooool00ol0003oooooooooo`0Mooooo`007_ooool00ol0003oooooooooo`1Voooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0K_ooool00ol0003oooooooooo`0Moooo
o`007_ooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool0K_ooool00ol0003oooooooooo`0Mooooo`007_ooool00ol0003oooooooooo`1Uooooo`;o0000
1oooool00ol0003oooooooooo`1^ooooo`03o`000?oooooooooo01gooooo000Nooooo`03o`000?oo
oooooooo06Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1^ooooo`03o`000?oo
oooooooo01gooooo000Nooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool0K_ooool0
0ol0003oooooooooo`0Mooooo`007_ooool00ol0003oooooooooo`1^ooooo`03o`000?oooooooooo
06kooooo00?o0000ooooooooool07Oooool001kooooo00?o0000ooooooooool0K_ooool2o`0006oo
oooo00?o0000ooooooooool07Oooool001kooooo00?o0000ooooooooool0K_ooool00ol0003ooooo
ooooo`1^ooooo`03o`000?oooooooooo01gooooo000Nooooo`03o`000?oooooooooo06kooooo00?o
0000ooooooooool0K_ooool00ol0003oooooooooo`0Mooooo`007_ooool00ol0003oooooooooo`1^
ooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool07Oooool001kooooo00?o0000oooo
ooooool0K_ooool00ol0003oooooooooo`1^ooooo`03o`000?oooooooooo01gooooo000Nooooo`03
o`000?oooooooooo06kooooo00?o0000ooooooooool0K_ooool00ol0003oooooooooo`0Mooooo`00
7_ooool00ol0003oooooooooo`1^ooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool0
7Oooool001kooooo00?o0000ooooooooool0K_ooool2o`0006oooooo00?o0000ooooooooool07Ooo
ool001kooooo00?o0000ooooooooool0K_ooool00ol0003oooooooooo`1^ooooo`03o`000?oooooo
oooo01gooooo000Mooooo`03o`000?oooooooooo06oooooo00?o0000ooooooooool0K_ooool00ol0
003oooooooooo`0Mooooo`007Oooool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo06ko
oooo00?o0000ooooooooool07Oooool001gooooo00?o0000ooooooooool0Koooool00ol0003ooooo
ooooo`1^ooooo`03o`000?oooooooooo01gooooo000Mooooo`03o`000?oooooooooo06oooooo00?o
0000ooooooooool0K_ooool00ol0003oooooooooo`0Mooooo`007Oooool00ol0003oooooooooo`1_
ooooo`;o0000Koooool00ol0003oooooooooo`0Mooooo`007Oooool00ol0003oooooooooo`1_oooo
o`03o`000?oooooooooo06oooooo00?o0000ooooooooool07?ooool001gooooo00?o0000oooooooo
ool0Koooool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo01cooooo000Mooooo`03o`00
0?oooooooooo06oooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`0Looooo`007Ooo
ool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo06oooooo00?o0000ooooooooool07?oo
ool001gooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`1_ooooo`03o`000?oooooo
oooo01cooooo000Mooooo`03o`000?oooooooooo06oooooo00?o0000ooooooooool0Koooool00ol0
003oooooooooo`0Looooo`007Oooool00ol0003oooooooooo`1_ooooo`;o0000L?ooool00ol0003o
ooooooooo`0Looooo`007Oooool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo06oooooo
00?o0000ooooooooool07?ooool001gooooo00?o0000ooooooooool0Koooool00ol0003ooooooooo
o`1_ooooo`03o`000?oooooooooo01cooooo000Mooooo`03o`000?oooooooooo06oooooo00?o0000
ooooooooool0Koooool00ol0003oooooooooo`0Looooo`007Oooool00ol0003oooooooooo`1Uoooo
o`Go00001Oooool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo01cooooo000Mooooo`03
o`000?oooooooooo06Kooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`1_oooo
o`03o`000?oooooooooo01cooooo000Mooooo`03o`000?oooooooooo06Oooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo01cooooo000Mooooo`03o`00
0?oooooooooo06Sooooo00?o0000ooooooooool01?ooool3o`0006oooooo00?o0000ooooooooool0
7?ooool001gooooo00?o0000ooooooooool0IOooool01Ol0003ooooooooooooooooo000000Gooooo
00?o0000ooooooooool0Koooool00ol0003oooooooooo`0Looooo`007Oooool00ol0003ooooooooo
o`1Uooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`1_ooooo`03o`00
0?oooooooooo01cooooo000Mooooo`03o`000?oooooooooo06Kooooo0ol00006ooooo`03o`000?oo
oooooooo073ooooo00?o0000ooooooooool06oooool001gooooo00?o0000ooooooooool0Koooool0
0ol0003oooooooooo`1`ooooo`03o`000?oooooooooo01_ooooo000Mooooo`03o`000?oooooooooo
06oooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0Kooooo`007Oooool00ol0003o
ooooooooo`1_ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool06oooool001gooooo
00?o0000ooooooooool0Koooool2o`00077ooooo00?o0000ooooooooool06oooool001gooooo00?o
0000ooooooooool0Koooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo01_ooooo000L
ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0K
ooooo`007?ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo073ooooo00?o0000oooo
ooooool06oooool001cooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`1`ooooo`03
o`000?oooooooooo01_ooooo000Looooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0
L?ooool00ol0003oooooooooo`0Kooooo`007?ooool00ol0003oooooooooo`1`ooooo`;o0000LOoo
ool00ol0003oooooooooo`0Kooooo`007?ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooo
oooo073ooooo00?o0000ooooooooool06oooool001cooooo00?o0000ooooooooool0L?ooool00ol0
003oooooooooo`1`ooooo`03o`000?oooooooooo01_ooooo000Looooo`03o`000?oooooooooo073o
oooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0Kooooo`007?ooool00ol0003ooooo
ooooo`1`ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool06oooool001cooooo00?o
0000ooooooooool0L?ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo01_ooooo000L
ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0K
ooooo`007?ooool00ol0003oooooooooo`1`ooooo`;o0000LOooool00ol0003oooooooooo`0Koooo
o`007?ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo073ooooo00?o0000oooooooo
ool06oooool001cooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`1`ooooo`03o`00
0?oooooooooo01_ooooo000Looooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0L?oo
ool00ol0003oooooooooo`0Kooooo`007?ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooo
oooo073ooooo00?o0000ooooooooool06oooool001cooooo00?o0000ooooooooool0L?ooool00ol0
003oooooooooo`1`ooooo`03o`000?oooooooooo01_ooooo000Looooo`03o`000?oooooooooo073o
oooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0Kooooo`007?ooool00ol0003ooooo
ooooo`1`ooooo`;o0000LOooool00ol0003oooooooooo`0Kooooo`007?ooool00ol0003ooooooooo
o`1`ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool06oooool001cooooo00?o0000
ooooooooool0L?ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo01_ooooo000Loooo
o`03o`000?oooooooooo073ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0Koooo
o`007?ooool00ol0003oooooooooo`1Wooooo`?o00001_ooool00ol0003oooooooooo`1`ooooo`03
o`000?oooooooooo01_ooooo000Looooo`03o`000?oooooooooo06Kooooo00Go0000oooooooooooo
ooooo`000005ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool06oooool001cooooo
00?o0000ooooooooool0J_ooool00ol0003oooooooooo`03ooooo`?o0000LOooool00ol0003ooooo
ooooo`0Jooooo`007?ooool00ol0003oooooooooo`1Xooooo`;o00001_ooool00ol0003ooooooooo
o`1aooooo`03o`000?oooooooooo01[ooooo000Looooo`03o`000?oooooooooo06[ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo01[ooooo000Loooo
o`03o`000?oooooooooo06Kooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooo
oooo077ooooo00?o0000ooooooooool06_ooool001cooooo00?o0000ooooooooool0Ioooool3o`00
00Kooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Jooooo`007?ooool00ol0003o
ooooooooo`1`ooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool06_ooool001cooooo
00?o0000ooooooooool0L?ooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo01[ooooo
000Kooooo`03o`000?oooooooooo077ooooo0_l0001booooo`03o`000?oooooooooo01[ooooo000K
ooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0J
ooooo`006oooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo077ooooo00?o0000oooo
ooooool06_ooool001_ooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`1aooooo`03
o`000?oooooooooo01[ooooo000Kooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool0
LOooool00ol0003oooooooooo`0Jooooo`006oooool00ol0003oooooooooo`1aooooo`03o`000?oo
oooooooo077ooooo00?o0000ooooooooool06_ooool001_ooooo00?o0000ooooooooool0LOooool0
0ol0003oooooooooo`1aooooo`03o`000?oooooooooo01[ooooo000Kooooo`03o`000?oooooooooo
077ooooo0_l0001booooo`03o`000?oooooooooo01[ooooo000Kooooo`03o`000?oooooooooo077o
oooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Jooooo`006oooool00ol0003ooooo
ooooo`1aooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool06_ooool001_ooooo00?o
0000ooooooooool0LOooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo01[ooooo000K
ooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0J
ooooo`006oooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo077ooooo00?o0000oooo
ooooool06_ooool001_ooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`1aooooo`03
o`000?oooooooooo01[ooooo000Kooooo`03o`000?oooooooooo077ooooo0_l0001booooo`03o`00
0?oooooooooo01[ooooo000Kooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool0LOoo
ool00ol0003oooooooooo`0Jooooo`006oooool00ol0003oooooooooo`1aooooo`03o`000?oooooo
oooo077ooooo00?o0000ooooooooool06_ooool001_ooooo00?o0000ooooooooool0LOooool00ol0
003oooooooooo`1aooooo`03o`000?oooooooooo01[ooooo000Kooooo`03o`000?oooooooooo077o
oooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Jooooo`006oooool00ol0003ooooo
ooooo`1aooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool06_ooool001_ooooo00?o
0000ooooooooool0LOooool2o`0007;ooooo00?o0000ooooooooool06_ooool001[ooooo00?o0000
ooooooooool0L_ooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo01[ooooo000Joooo
o`03o`000?oooooooooo07;ooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Joooo
o`006_ooool00ol0003oooooooooo`1booooo`03o`000?oooooooooo077ooooo00?o0000oooooooo
ool06_ooool001[ooooo00?o0000ooooooooool0J_ooool3o`0000Gooooo00?o0000ooooooooool0
LOooool00ol0003oooooooooo`0Jooooo`006_ooool00ol0003oooooooooo`1[ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Jooooo`006_ooool0
0ol0003oooooooooo`1Xooooo`Go00001Oooool00ol0003oooooooooo`1aooooo`03o`000?oooooo
oooo01[ooooo000Jooooo`03o`000?oooooooooo06Sooooo00Co0000oooooooooooo00001_ooool3
o`00077ooooo00?o0000ooooooooool06_ooool001[ooooo00?o0000ooooooooool0JOooool00ol0
003oooooo`000006ooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool06_ooool001[o
oooo00?o0000ooooooooool0J_ooool2o`0000Kooooo00?o0000ooooooooool0LOooool00ol0003o
ooooooooo`0Jooooo`006_ooool00ol0003oooooooooo`1[ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Jooooo`00oooooolQooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.27356, -1.13405, \
0.008875, 0.0297735}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["Here is a helper function that converts a list of \
coefficient to a polynomial", "Text"]], "SmallText"],

Cell[BoxData[
    \(CoefficientToPoly[L_List, \ z_] := 
      Expand[Fold[#1\ z + #2 &, \ 0, \ Reverse[L]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CoefficientToPoly[{a0, \ a1, \ a2, \ a3, \ a4, \ a5, \ a6, \ a7, \ 
        a8}, \ z]\)], "Input"],

Cell[BoxData[
    \(a0 + a1\ z + a2\ z\^2 + a3\ z\^3 + a4\ z\^4 + a5\ z\^5 + a6\ z\^6 + 
      a7\ z\^7 + a8\ z\^8\)], "Output"]
}, Open  ]],

Cell["The list of evaluation points for the 8th degree problem.", "Text"],

Cell[BoxData[
    \(SquaredPenalty[
        coeff_List]\  := \[IndentingNewLine]Module[{evalpts, \ 
          xx\  = \ ChebyshevT[8, 1.2], \ core, \ penalty1, \ 
          penalty2}, \[IndentingNewLine] (*\ 
          The\ 60\ uniformly\ spaced\ evaluation\ points\ between\ [\(-1\), \ 
              1]\ *) \[IndentingNewLine]evalpts\  = \ 
          N[Table[i, {i, \ \(-1\), 1, 2/59}]]; \[IndentingNewLine]core\  = \ 
          CoefficientToPoly[coeff, \ evalpts]; \[IndentingNewLine] (*\ 
          Compute\ the\ squared\ penalty\ of\ the\ core\ \
*) \[IndentingNewLine]penalty1\  = \ 
          Total[Map[If[Abs[#] > 1, \((1 - #)\)^2, 0] &, 
              core]]; \[IndentingNewLine] (*\ 
          Compute\ the\ squared\ penalty\ at\ the\ boundaries\ \
*) \[IndentingNewLine]penalty2\  = \ 
          Total[\[IndentingNewLine]Map[\ 
              If[#1\  < \ xx, \ \((#1 - xx)\)^2, \ 
                  0] &, \ \[IndentingNewLine]CoefficientToPoly[
                coeff, \ {\(-1.2\), \ 
                  1.2}]\[IndentingNewLine]]\[IndentingNewLine]]; \
\[IndentingNewLine]penalty1 + penalty2\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    \(\(ListOfVars = \ {a0, \ a1, \ a2, \ a3, \ a4, \ a5, \ a6, \ a7, \ 
          a8};\)\)], "Input"],

Cell[BoxData[
    \(\(SquaredPenaltyFunc\  = SquaredPenalty[ListOfVars];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SquaredPenalty[Table[Random[], {i, 1, 9}]]\)], "Input"],

Cell[BoxData[
    \(8933.571483850186`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SquaredPenalty[CoefficientList[ChebyshevT[8, x], x]]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = \ 
      ListOfVars\  /. \ \ \(NMinimize[SquaredPenaltyFunc, \ ListOfVars, \ 
            MaxIterations \[Rule] 200]\)[\([2]\)]\)], "Input"],

Cell[BoxData[
    \({1.0159931880440332`, 
      0.04029287361086938`, \(-30.868925806109452`\), \
\(-0.1300075061412712`\), 156.0158434341129`, 
      0.1446919137856554`, \(-251.69617784421808`\), \
\(-0.05135380013760603`\), 126.5498605129087`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{ChebyshevT[8, x], 
        Evaluate[CoefficientToPoly[sol1, x]]}, {x, \(-1.2\), 1.2}, 
      PlotStyle \[Rule] {{Thickness[0.01], RGBColor[1, 0, 0]}, 
          RGBColor[0, 0, 0]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.396825 0.134526 0.117789 [
[.10317 .12203 -6 -9 ]
[.10317 .12203 6 0 ]
[.30159 .12203 -12 -9 ]
[.30159 .12203 12 0 ]
[.69841 .12203 -9 -9 ]
[.69841 .12203 9 0 ]
[.89683 .12203 -3 -9 ]
[.89683 .12203 3 0 ]
[.4875 .01674 -12 -4.5 ]
[.4875 .01674 0 4.5 ]
[.4875 .25232 -6 -4.5 ]
[.4875 .25232 0 4.5 ]
[.4875 .37011 -6 -4.5 ]
[.4875 .37011 0 4.5 ]
[.4875 .48789 -6 -4.5 ]
[.4875 .48789 0 4.5 ]
[.4875 .60568 -6 -4.5 ]
[.4875 .60568 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .13453 m
.10317 .14078 L
s
[(-1)] .10317 .12203 0 1 Mshowa
.30159 .13453 m
.30159 .14078 L
s
[(-0.5)] .30159 .12203 0 1 Mshowa
.69841 .13453 m
.69841 .14078 L
s
[(0.5)] .69841 .12203 0 1 Mshowa
.89683 .13453 m
.89683 .14078 L
s
[(1)] .89683 .12203 0 1 Mshowa
.125 Mabswid
.14286 .13453 m
.14286 .13828 L
s
.18254 .13453 m
.18254 .13828 L
s
.22222 .13453 m
.22222 .13828 L
s
.2619 .13453 m
.2619 .13828 L
s
.34127 .13453 m
.34127 .13828 L
s
.38095 .13453 m
.38095 .13828 L
s
.42063 .13453 m
.42063 .13828 L
s
.46032 .13453 m
.46032 .13828 L
s
.53968 .13453 m
.53968 .13828 L
s
.57937 .13453 m
.57937 .13828 L
s
.61905 .13453 m
.61905 .13828 L
s
.65873 .13453 m
.65873 .13828 L
s
.7381 .13453 m
.7381 .13828 L
s
.77778 .13453 m
.77778 .13828 L
s
.81746 .13453 m
.81746 .13828 L
s
.85714 .13453 m
.85714 .13828 L
s
.06349 .13453 m
.06349 .13828 L
s
.02381 .13453 m
.02381 .13828 L
s
.93651 .13453 m
.93651 .13828 L
s
.97619 .13453 m
.97619 .13828 L
s
.25 Mabswid
0 .13453 m
1 .13453 L
s
.5 .01674 m
.50625 .01674 L
s
[(-1)] .4875 .01674 1 0 Mshowa
.5 .25232 m
.50625 .25232 L
s
[(1)] .4875 .25232 1 0 Mshowa
.5 .37011 m
.50625 .37011 L
s
[(2)] .4875 .37011 1 0 Mshowa
.5 .48789 m
.50625 .48789 L
s
[(3)] .4875 .48789 1 0 Mshowa
.5 .60568 m
.50625 .60568 L
s
[(4)] .4875 .60568 1 0 Mshowa
.125 Mabswid
.5 .04029 m
.50375 .04029 L
s
.5 .06385 m
.50375 .06385 L
s
.5 .08741 m
.50375 .08741 L
s
.5 .11097 m
.50375 .11097 L
s
.5 .15808 m
.50375 .15808 L
s
.5 .18164 m
.50375 .18164 L
s
.5 .2052 m
.50375 .2052 L
s
.5 .22876 m
.50375 .22876 L
s
.5 .27587 m
.50375 .27587 L
s
.5 .29943 m
.50375 .29943 L
s
.5 .32299 m
.50375 .32299 L
s
.5 .34655 m
.50375 .34655 L
s
.5 .39366 m
.50375 .39366 L
s
.5 .41722 m
.50375 .41722 L
s
.5 .44078 m
.50375 .44078 L
s
.5 .46434 m
.50375 .46434 L
s
.5 .51145 m
.50375 .51145 L
s
.5 .53501 m
.50375 .53501 L
s
.5 .55857 m
.50375 .55857 L
s
.5 .58213 m
.50375 .58213 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.01 w
.08969 .61803 m
.094 .47309 L
.0995 .32917 L
.10458 .2266 L
.10924 .15452 L
.11181 .12267 L
.11425 .09708 L
.11651 .07713 L
.11898 .05914 L
.12121 .04602 L
.12331 .03616 L
.12461 .03116 L
.12602 .02668 L
.12719 .02363 L
.12848 .02097 L
.12988 .01885 L
.13064 .01802 L
.13136 .01743 L
.13263 .01683 L
.13335 .01674 L
.134 .0168 L
.13527 .0173 L
.13644 .0182 L
.13773 .01962 L
.1391 .02161 L
.1414 .02596 L
.14393 .03207 L
.15402 .06629 L
.16328 .10518 L
.17408 .15146 L
.18413 .18985 L
.19328 .2179 L
.1984 .23015 L
.20306 .23897 L
.20554 .24275 L
.20817 .24607 L
.21105 .24889 L
.21233 .24987 L
.21371 .25073 L
.215 .25137 L
.21618 .25181 L
.21737 .25212 L
.21849 .25228 L
.2198 .25231 L
.22101 .25219 L
.22171 .25206 L
.22234 .25191 L
.22376 .25142 L
.22497 .25087 L
.22609 .25023 L
Mistroke
.22865 .24837 L
.23114 .24603 L
.23381 .24298 L
.24304 .22841 L
.25395 .20469 L
.26388 .17888 L
.28461 .12013 L
.30377 .07053 L
.31339 .05039 L
.3224 .0354 L
.3273 .029 L
.3318 .02429 L
.33678 .02038 L
.3394 .01889 L
.34072 .01829 L
.34216 .01775 L
.3435 .01734 L
.34474 .01706 L
.34592 .01688 L
.34717 .01676 L
.34829 .01674 L
.34934 .01678 L
.35049 .01689 L
.35173 .0171 L
.35304 .01741 L
.35447 .01785 L
.35707 .01894 L
.35959 .02035 L
.36194 .02196 L
.37085 .03057 L
.37535 .03634 L
.38032 .04373 L
.39964 .08069 L
.42049 .12945 L
.44011 .17589 L
.45049 .1981 L
.4616 .21864 L
.47233 .23443 L
.47741 .2403 L
.4821 .24472 L
.4868 .24817 L
.48928 .24958 L
.49191 .25075 L
.49301 .25115 L
.49419 .25151 L
.49521 .25177 L
.49633 .25199 L
.49763 .25218 L
.49887 .25228 L
.50007 .25232 L
Mistroke
.50119 .25228 L
.50247 .25217 L
.50312 .25208 L
.50383 .25196 L
.50509 .2517 L
.50627 .25138 L
.50892 .25041 L
.51176 .24902 L
.51698 .24548 L
.52172 .24119 L
.53128 .22961 L
.54034 .21535 L
.57869 .13145 L
.59809 .08571 L
.60839 .06395 L
.61949 .04404 L
.62464 .03636 L
.63006 .02952 L
.63509 .0244 L
.63753 .02236 L
.63976 .02077 L
.64186 .0195 L
.64415 .01839 L
.64541 .01789 L
.64656 .01752 L
.64766 .01723 L
.64884 .01699 L
.65003 .01683 L
.65114 .01675 L
.65246 .01675 L
.65367 .01683 L
.65492 .017 L
.65563 .01714 L
.65629 .01729 L
.65877 .01809 L
.66007 .01864 L
.66143 .01933 L
.66387 .02082 L
.66938 .02542 L
.67414 .03075 L
.67935 .03799 L
.69798 .0746 L
.71918 .13086 L
.73847 .18524 L
.74808 .20953 L
.75314 .2208 L
.75851 .23125 L
.76319 .2389 L
.76568 .24233 L
.76836 .2455 L
Mistroke
.77081 .24791 L
.77305 .24967 L
.77413 .25036 L
.77531 .251 L
.77635 .25147 L
.77745 .25185 L
.77809 .25202 L
.77878 .25216 L
.78 .2523 L
.78069 .25232 L
.78143 .25228 L
.78213 .2522 L
.78276 .25209 L
.78399 .25176 L
.78469 .2515 L
.78533 .25123 L
.78776 .2498 L
.78992 .24804 L
.7923 .24553 L
.79712 .23867 L
.80232 .22857 L
.80793 .21462 L
.81809 .18197 L
.83773 .10083 L
.84811 .05804 L
.85382 .03847 L
.85663 .03062 L
.85921 .02469 L
.86172 .02037 L
.86298 .01878 L
.86369 .01807 L
.86437 .01753 L
.8651 .01711 L
.86576 .01686 L
.86648 .01674 L
.86726 .0168 L
.86794 .01703 L
.86866 .01744 L
.86996 .01866 L
.87123 .02048 L
.8726 .02317 L
.8739 .02645 L
.87509 .03013 L
.87735 .03898 L
.87973 .0512 L
.88201 .06586 L
.88444 .08511 L
.88884 .13018 L
.89407 .20361 L
.89883 .29237 L
Mistroke
.90364 .4069 L
.90876 .55974 L
Mfstroke
.90876 .55974 m
.9102 .61803 L
s
0 0 0 r
.5 Mabswid
.0898 .61803 m
.094 .47613 L
.0995 .33129 L
.10458 .22791 L
.10924 .15512 L
.11181 .12291 L
.11425 .09699 L
.11651 .07675 L
.11898 .05846 L
.12121 .04509 L
.12331 .035 L
.12461 .02987 L
.12602 .02525 L
.12719 .0221 L
.12848 .01933 L
.12988 .01709 L
.13064 .01619 L
.13136 .01555 L
.13263 .01486 L
.13335 .01472 L
.134 .01473 L
.13527 .01516 L
.13644 .01598 L
.13773 .01734 L
.1391 .01926 L
.1414 .02352 L
.14393 .02954 L
.15402 .06365 L
.16328 .10277 L
.17408 .14966 L
.18413 .18889 L
.19328 .21792 L
.19797 .22979 L
.20306 .24018 L
.20596 .24493 L
.20864 .24854 L
.21119 .25131 L
.2125 .25247 L
.2139 .25352 L
.21517 .2543 L
.21633 .25487 L
.21749 .25532 L
.2186 .25562 L
.21988 .25582 L
.22107 .25587 L
.22237 .25577 L
.2231 .25564 L
.22376 .25549 L
.22497 .2551 L
.22609 .25463 L
Mistroke
.22865 .25313 L
.23114 .25115 L
.23381 .24847 L
.23864 .24224 L
.24304 .23517 L
.26388 .18821 L
.28461 .13137 L
.30377 .08277 L
.31339 .06286 L
.3224 .04791 L
.3273 .04146 L
.3318 .03666 L
.33678 .03261 L
.3394 .03103 L
.34072 .03038 L
.34216 .02978 L
.3435 .02932 L
.34474 .02898 L
.34592 .02874 L
.34717 .02857 L
.34829 .02848 L
.34934 .02847 L
.35049 .02852 L
.35173 .02865 L
.35304 .02889 L
.35447 .02925 L
.35582 .02969 L
.35707 .03018 L
.36194 .03286 L
.36617 .03616 L
.37085 .04081 L
.38032 .05316 L
.39964 .08834 L
.42049 .13513 L
.44011 .17991 L
.45049 .20139 L
.4616 .22129 L
.47233 .23663 L
.47741 .24234 L
.4821 .24666 L
.4868 .25004 L
.48928 .25143 L
.49191 .2526 L
.49301 .25299 L
.49419 .25335 L
.49521 .25361 L
.49633 .25384 L
.49763 .25404 L
.49887 .25416 L
.50007 .2542 L
Mistroke
.50119 .25418 L
.50247 .25409 L
.50312 .25401 L
.50383 .25391 L
.50509 .25366 L
.50627 .25337 L
.50892 .25247 L
.51176 .25116 L
.51698 .24781 L
.52172 .24372 L
.53128 .23267 L
.54034 .21903 L
.57869 .13871 L
.59809 .09505 L
.60839 .07438 L
.61949 .05556 L
.62464 .04836 L
.63006 .04198 L
.63469 .03759 L
.63735 .03554 L
.63976 .03397 L
.64204 .03276 L
.64452 .03175 L
.64588 .03133 L
.64714 .03104 L
.64834 .03083 L
.64961 .0307 L
.6507 .03065 L
.65187 .03067 L
.65297 .03076 L
.65398 .0309 L
.65515 .03113 L
.65644 .03147 L
.65877 .03232 L
.66134 .0336 L
.66411 .03539 L
.66913 .03969 L
.67401 .04516 L
.6785 .05129 L
.68872 .06887 L
.69949 .09222 L
.73754 .1933 L
.74759 .21762 L
.7571 .23655 L
.76235 .24472 L
.76512 .24827 L
.76806 .25139 L
.77053 .25349 L
.77183 .2544 L
.77324 .25522 L
Mistroke
.77453 .25582 L
.77572 .25623 L
.7769 .25653 L
.77803 .25668 L
.77927 .25672 L
.77997 .25668 L
.78062 .2566 L
.7818 .25635 L
.78306 .25594 L
.78418 .25544 L
.78523 .25486 L
.78761 .25314 L
.79019 .25063 L
.79254 .24776 L
.79783 .23923 L
.80235 .22968 L
.80727 .21698 L
.81621 .18821 L
.83559 .10825 L
.84588 .06454 L
.85129 .04455 L
.85424 .03519 L
.85698 .02778 L
.85942 .02243 L
.86067 .02021 L
.86202 .01823 L
.8628 .01731 L
.86351 .01661 L
.86419 .01608 L
.86491 .01566 L
.86617 .01532 L
.86688 .01535 L
.86754 .01553 L
.86879 .01629 L
.86998 .01754 L
.87105 .01913 L
.87221 .02138 L
.87347 .02446 L
.87481 .02853 L
.87723 .03802 L
.8797 .05087 L
.88237 .06866 L
.8872 .11261 L
.89191 .17207 L
.89624 .24359 L
.90095 .3426 L
.90599 .47674 L
Mfstroke
.90599 .47674 m
.90989 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oSoooool0
0ol0003oooooooooo`2>ooooo`00Soooool00ol0003oooooooooo`2>ooooo`00Q_ooool3o`0000Ko
oooo00?o0000ooooooooool0S_ooool008Oooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`2>ooooo`009Oooool01?oo003o0000o`000?l0000hooooo`Goo`006Oooool5o`0000?ooooo
00?o0000ooooooooool01Oooool3o`0002Kooooo1?oo000jooooo`?o00009oooool002Gooooo00Co
0000ool00?oo003o0000=_ooool9ool001oooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Tooooo`Woo`00=_ooool00ooo003o0000ool00002o`0002Kooooo000Tooooo`03ool00?l0
003oo`0000;oo`0000?o0000ooooooooool0<_ooool5ool00003oooooooo003oo`0000?oo`007_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02?ooooo1Ooo00000oooooooo`00ool0
0002ool003Kooooo00Go0000ool00?oo003oo`00o`00000Vooooo`009?ooool00ooo003o0000oooo
o`02ool00003o`000?oooooooooo03;ooooo0_oo0007ooooo`?oo`007?ooool2o`0000Oooooo00?o
0000ooooooooool08_ooool3ool000Kooooo1?oo000cooooo`06ool00?l0003oo`00oooooooo003o
00009_ooool002?ooooo00?oo`00o`000?oo00000_ooool2ool00003o`000?oooooooooo033ooooo
0ooo00000ooooooo0000o`000005o`0000?oo`007?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo027ooooo0ooo0003ooooo`?o00000_ooool4ool003;ooooo00Coo`00o`000?oooooo
oooo0_oo00000ol0003oooooooooo`0Sooooo`008oooool00ooo003o0000ooooo`02ooooo`;oo`00
00?o0000ooooooooool0;oooool3ool00003ooooool0003o000000Kooooo00Co0000ool00?oo003o
o`008oooool00ol0003oooooooooo`0Pooooo`?oo`000_ooool2o`0000?ooooo0_l00002ooooo`;o
o`00<_ooool00ol0003oo`00ooooo`02ooooo`03ool00?l0003ooooo02Cooooo000Sooooo`03ool0
0?l0003ooooo00?ooooo00?oo`00o`000?ooool0;oooool3ool00003ooooool0003ooooo00Sooooo
00Co0000ool00?oo003oo`008_ooool00ol0003oooooooooo`0Oooooo`?oo`0000?oooooo`000?l0
00001oooool00ol0003oooooool00002ool0033ooooo00?oo`00o`000?oo00000oooool00ooo003o
0000ooooo`0Tooooo`008oooool00ooo003o0000ooooo`03ooooo`;oo`0000?o0000ooooooooool0
;Oooool2ool00003ooooool0003ooooo00[ooooo00?o0000ool00?oo00008_ooool2o`00023ooooo
0_oo0002ooooo`03o`000?oooooooooo00Oooooo0_l00002ool0033ooooo00?oo`00o`000?ooool0
0oooool00ooo003o0000ooooo`0Tooooo`008_ooool00ooo003o0000ool00005ooooo`03ool00?l0
003ooooo02gooooo0ooo00000ol0003oooooooooo`0:ooooo`04o`000?oo003oo`00ool0027ooooo
00?o0000ooooooooool07_ooool3ool000;o00003?ooool00ol0003oo`00ool0000_ooooo`03o`00
0?oo003ooooo00?ooooo00?oo`00o`000?ooool09?ooool002;ooooo00?oo`00o`000?ooool01Ooo
ool00ooo003o0000ooooo`0]ooooo`;oo`0000?o0000ooooooooool03?ooool00ol0003oo`00ool0
000Qooooo`03o`000?oooooooooo01kooooo0_oo00000ol0003oooooooooo`0<ooooo`03o`000?oo
003oo`0002kooooo00?oo`00o`000?oo00001?ooool2ool00003o`000?oooooooooo02;ooooo000R
ooooo`03ool00?l0003ooooo00Gooooo0_oo00000ol0003oooooooooo`0Zooooo`?oo`0000?o0000
ooooooooool03Oooool00ol0003oo`00ool0000Pooooo`03o`000?oooooooooo01gooooo0ooo0000
0ol0003oooooooooo`0=ooooo`03o`000?oo003oo`0002gooooo00?o0000ool00?ooool01Oooool0
0ooo003o0000ooooo`0Sooooo`008_ooool00ooo003o0000ooooo`06ooooo`03ool00?l0003ooooo
02_ooooo0_oo00000ol0003oooooooooo`0?ooooo`03o`000?oo003ooooo01oooooo00?o0000oooo
ooooool07Oooool2ool00003o`000?oooooooooo00kooooo00?o0000ool00?oo0000;Oooool00ol0
003oo`00ooooo`05ooooo`03ool00?l0003ooooo02?ooooo000Rooooo`03ool00?l0003ooooo00Ko
oooo00?oo`00o`000?ooool0:_ooool3ool00003o`000?oooooooooo00oooooo00?o0000ool00?oo
00007oooool00ol0003oooooooooo`0Looooo`?oo`0000?o0000ooooooooool03oooool00ol0003o
o`00ool0000[ooooo`03ool00?l0003oo`0000Kooooo00?oo`00o`000?ooool08oooool002;ooooo
00?oo`00o`000?ooool01_ooool2ool00003o`000?oooooooooo02Sooooo0_oo00000ol0003ooooo
ooooo`0Aooooo`03o`000?oo003ooooo01kooooo00?o0000ooooooooool07?ooool2ool00003o`00
0?oooooooooo017ooooo00?o0000ool00?ooool0:_ooool00ol0003oo`00ooooo`06ooooo`;oo`00
00?o0000ooooooooool08Oooool002;ooooo00?oo`00o`000?ooool01oooool00ooo003o0000oooo
o`0Xooooo`?oo`0000?o0000ooooooooool04Oooool00ol0003oo`00ool0000Nooooo`;o00007?oo
ool3ool00003o`000?oooooooooo017ooooo00?o0000ool00?ooool0:_ooool00ol0003oo`00oooo
o`07ooooo`03ool00?l0003ooooo02;ooooo000Rooooo`03o`000?oo003ooooo00Oooooo00?oo`00
o`000?ooool0:?ooool2ool00003o`000?oooooooooo01?ooooo00?o0000ool00?ooool07Oooool0
0ol0003oooooooooo`0Kooooo`;oo`0000?o0000ooooooooool04_ooool00ooo003o0000ool0000Y
ooooo`03ool00?l0003oo`0000Sooooo00?oo`00o`000?ooool08_ooool0027ooooo00?oo`00o`00
0?oo00002?ooool00ooo003o0000ooooo`0Wooooo`?oo`0000?o0000ooooooooool04oooool00ol0
003oo`00ooooo`0Mooooo`03o`000?oooooooooo01[ooooo0ooo00000ol0003oooooooooo`0Coooo
o`03o`000?oo003ooooo02Sooooo00?oo`00o`000?ooool02?ooool00ooo003o0000ooooo`0Roooo
o`008Oooool00ooo003o0000ooooo`08ooooo`03ool00?l0003ooooo02Oooooo0_oo00000ol0003o
ooooooooo`0Dooooo`03ool00?l0003oo`0001gooooo00?o0000ooooooooool06_ooool2ool00003
o`000?oooooooooo01Cooooo00?oo`00o`000?oo0000:?ooool00ooo003o0000ooooo`08ooooo`03
ool00?l0003ooooo02;ooooo000Qooooo`03ool00?l0003ooooo00Sooooo0_oo00000ol0003ooooo
ooooo`0Tooooo`?oo`0000?o0000ooooooooool05Oooool00ol0003oo`00ooooo`0Looooo`03o`00
0?oooooooooo01Wooooo0ooo00000ol0003oooooooooo`0Eooooo`03o`000?oo003ooooo02Oooooo
00?o0000ool00?ooool02?ooool00ooo003o0000ooooo`0Rooooo`008Oooool00ooo003o0000oooo
o`09ooooo`03ool00?l0003ooooo02Gooooo0_oo00000ol0003oooooooooo`0Fooooo`03ool00?l0
003oo`0001cooooo00?o0000ooooooooool06Oooool2ool00003o`000?oooooooooo01Kooooo00?o
o`00o`000?oo00009_ooool00ooo003o0000ool00009ooooo`03ool00?l0003ooooo02;ooooo000Q
ooooo`03ool00?l0003ooooo00Wooooo00?oo`00o`000?ooool09Oooool2ool00003o`000?oooooo
oooo01Oooooo00?o0000ool00?ooool06oooool2o`0001Wooooo0ooo00000ol0003oooooooooo`0G
ooooo`03o`000?oo003ooooo02Gooooo00?oo`00o`000?ooool02Oooool00ooo003o0000ooooo`0R
ooooo`008?ooool00ooo003o0000ool0000:ooooo`03ool00?l0003ooooo02Cooooo0_oo00000ol0
003oooooooooo`0Hooooo`03ool00?l0003oo`0001_ooooo00?o0000ooooooooool06?ooool2ool0
0003o`000?oooooooooo01Sooooo00?o0000ool00?ooool09Oooool00ooo003o0000ooooo`09oooo
o`03ool00?l0003ooooo02;ooooo000Oooooo`03o`000?oo003o000000_ooooo00?oo`00o`000?oo
ool08oooool01?l0003oo`00ool00?l00002ooooo`03o`000?oooooooooo00;ooooo0ol0000Aoooo
o`03o`000?oo003ooooo01[ooooo00?o0000ooooooooool05oooool3ool00003o`000?oooooooooo
017ooooo0_l00004ooooo`05o`000?oo003o0000ool00?ooool00ol0000Qooooo`03ool00?l0003o
oooo00Wooooo0_oo0004o`0001oooooo000Pooooo`03ool00?l0003ooooo00[ooooo0_oo00000ol0
003oooooooooo`0Pooooo`05o`000?ooooooo`00ool00?l000001_ooool01Ol0003ooooooooooooo
oooo0000013ooooo00?oo`00o`000?oo00006_ooool00ol0003oooooooooo`0Gooooo`;oo`0000?o
0000ooooooooool04Oooool01?l0003oooooooooool00005ooooo`03o`000?oo003o000000?ooooo
00?o0000ooooooooool07Oooool2ool00003o`000?oooooooooo00Sooooo0_oo00000ol0003ooooo
o`00000Pooooo`006?ooool5o`0000?ooooo00?oo`00o`000?ooool02_ooool2ool00003o`000?oo
oooooooo01Wooooo1Ol00002ooooo`04o`000?oo003oo`00o`0000_ooooo00?o0000ooooooooool0
3oooool00ol0003oo`00ooooo`0Iooooo`03o`000?oooooooooo01Kooooo0ooo00000ol0003ooooo
ooooo`0Aooooo`04o`000?ooooooooooo`0000Gooooo00?oo`00o`000?ooool00oooool00ol0003o
ooooooooo`0Mooooo`03ool00?l0003ooooo00[ooooo0_oo00000ol0003oooooo`00000Pooooo`00
8?ooool00ooo003o0000ooooo`0;ooooo`03ool00?l0003ooooo027ooooo00Co0000ool00?oo003o
00002oooool00ol0003oooooooooo`0?ooooo`03ool00?l0003oo`0001Wooooo00?o0000oooooooo
ool05_ooool2ool00003o`000?oooooooooo01;ooooo00Co0000oooooooooooo00001Oooool00ooo
003o0000ool00003ooooo`03o`000?oooooooooo01gooooo00?oo`00o`000?ooool02oooool01?oo
003o0000ooooool0000Pooooo`008?ooool00ooo003o0000ooooo`0;ooooo`03ool00?l0003ooooo
027ooooo00Co0000ool00?oo003o00001oooool4o`0001?ooooo00?o0000ool00?ooool06?ooool0
0ol0003oooooooooo`0Eooooo`?oo`0000?o0000ooooooooool04_ooool01?l0003oooooooooool0
0006ooooo`03o`000?oo003o000000;o00008?ooool00ooo003o0000ooooo`0;ooooo`04ool00?l0
003oooooo`00023ooooo000Oooooo`;oo`0000?o0000ooooooooool02_ooool00ooo003o0000oooo
o`0Qooooo`;oo`000_l00007ooooo`03o`000?oooooooooo01Cooooo00?oo`00o`000?ooool06?oo
ool2o`0001Kooooo0_oo00000ol0003oooooooooo`0Cooooo`04o`000?ooooooooooo`0000Kooooo
00?oo`00o`000?oo00008Oooool2ool00003o`000?oooooooooo00[ooooo00Coo`00o`000?l0003o
00008?ooool001oooooo00?oo`00o`000?ooool03?ooool2ool00003o`000?oooooooooo01oooooo
0_oo00000ol0003oooooooooo`06ooooo`Go00004_ooool00ooo003o0000ool0000Hooooo`03o`00
0?oooooooooo01Gooooo0_oo00000ol0003oooooooooo`0Dooooo`;o00002?ooool00ol0003oo`00
o`000002o`0001kooooo0_oo00000ol0003oooooooooo`0:ooooo`04ool00?l0003oooooo`00023o
oooo000Oooooo`03ool00?l0003ooooo00cooooo0_oo00000ol0003oooooooooo`0Oooooo`;oo`00
00?o0000ooooooooool07_ooool00ol0003oo`00ooooo`0Gooooo`03o`000?oooooooooo01Cooooo
0_oo00000ol0003oooooooooo`0Oooooo`03o`000?oo003ooooo023ooooo00?oo`00o`000?ooool0
3?ooool00ooo003o0000ooooo`0Qooooo`007oooool00ooo003o0000ooooo`0=ooooo`03ool00?l0
003ooooo01oooooo0_oo00000ol0003oooooooooo`0Oooooo`03ool00?l0003oo`0001Oooooo00?o
0000ooooooooool05?ooool2ool00003o`000?oooooooooo01oooooo00?oo`00o`000?oo00008?oo
ool00ooo003o0000ooooo`0<ooooo`03ool00?l0003ooooo027ooooo000Oooooo`03ool00?l0003o
oooo00gooooo00?oo`00o`000?ooool07oooool2ool00003o`000?oooooooooo023ooooo00?o0000
ool00?ooool05_ooool00ol0003oooooooooo`0Cooooo`;oo`0000?o0000ooooooooool08Oooool0
0ol0003oo`00ooooo`0Oooooo`03ool00?l0003ooooo00cooooo00?oo`00o`000?oo00008Oooool0
01oooooo00?oo`00o`000?ooool03Oooool2ool00003o`000?oooooooooo01cooooo0ooo00000ol0
003oooooooooo`0Pooooo`03ool00?l0003oo`0001Kooooo00?o0000ooooooooool04oooool2ool0
0003o`000?oooooooooo027ooooo00?oo`00o`000?ooool07_ooool2ool00003o`000?oooooooooo
00cooooo00?o0000ool00?ooool08?ooool001oooooo00?oo`00o`000?ooool03Oooool2ool00003
o`000?oooooooooo01cooooo0_oo00000ol0003oooooooooo`0Rooooo`03o`000?oo003ooooo01Go
oooo00?o0000ooooooooool04_ooool2ool00003o`000?oooooooooo02;ooooo00?oo`00o`000?oo
00007_ooool00ooo003o0000ooooo`0>ooooo`03ool00?l0003ooooo023ooooo00000ooooooo0000
o`00000Lo`000003ool00?l0003o000000ko000000?oo`00o`000?l000007Ol00002ool002Go0000
00?oo`00o`000?oo0000:_l00002ool002Oo000000?oo`00o`000?l000007?l000000ooo003o0000
o`00000>o`000003ool00?l0003o000001ko00000_ooool000Oooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oo003o000000Sooooo00?o0000ooooooooool01?oo
ool00ooo003o0000ooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool01?l0003oooooooooooooool2ool00003o`000?oooooooooo00?ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ool00?ooool0
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1_ooool2ool000;o00002_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool00_ooool00ooo003o0000ool00004ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool01Ol0003ooooooooooooo003o000000Oooooo00?o0000oooooooo
ool01Oooool01?oo003o0000ooooool0000:ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool01_ooool001kooooo00?o0000ool00?l000003oooool00ooo003o0000ooooo`0Looooo`;o
o`0000?o0000ooooooooool00oooool00ol0003oooooooooo`0Nooooo`03ool00?l0003oo`0001Co
oooo00?o0000ooooooooool04Oooool2ool00003o`000?oooooooooo01oooooo00?o0000oooooooo
ool00oooool00ol0003oo`00ooooo`0Kooooo`;oo`0000?o0000ooooooooool03Oooool01?oo003o
0000ooooool0000Oooooo`007oooool00ooo003o0000ooooo`0>ooooo`;oo`0000?o0000oooooooo
ool06_ooool2ool00003o`000?oooooooooo02Gooooo00?o0000ool00?ooool04oooool00ol0003o
ooooooooo`0@ooooo`;oo`0000?o0000ooooooooool09_ooool00ooo003o0000ooooo`0Kooooo`03
ool00?l0003ooooo00oooooo00?oo`00o`000?ooool08?ooool001oooooo00?oo`00o`000?ooool0
3_ooool2ool00003o`000?oooooooooo01Wooooo0_oo00000ol0003oooooooooo`0Vooooo`03ool0
0?l0003ooooo01?ooooo00?o0000ooooooooool04?ooool2ool00003o`000?oooooooooo02Kooooo
00?oo`00o`000?oo00006oooool00ooo003o0000ooooo`0?ooooo`03ool00?l0003ooooo023ooooo
000Oooooo`03ool00?l0003ooooo00oooooo00?oo`00o`000?ooool06_ooool2ool00003o`000?oo
oooooooo02Kooooo00?oo`00o`000?oo00004oooool00ol0003oooooooooo`0?ooooo`;oo`0000?o
0000ooooooooool0:?ooool00ol0003oo`00ooooo`0Jooooo`03ool00?l0003ooooo00oooooo00?o
o`00o`000?ooool08?ooool001oooooo00?oo`00o`000?ooool03oooool00ooo003o0000ooooo`0I
ooooo`?oo`0000?o0000ooooooooool09oooool00ooo003o0000ooooo`0Booooo`03o`000?oooooo
oooo00oooooo0_oo00000ol0003oooooooooo`0Xooooo`03ool00?l0003oo`0001[ooooo00?o0000
ool00?ooool03oooool00ooo003o0000ooooo`0Pooooo`007oooool00ooo003o0000ooooo`0?oooo
o`;oo`0000?o0000ooooooooool05oooool2ool00003o`000?oooooooooo02Sooooo00?oo`00o`00
0?oo00004_ooool2o`00013ooooo00?oo`00o`000?ooool0:oooool00ol0003oo`00ooooo`0Hoooo
o`03ool00?l0003oo`00013ooooo00?oo`00o`000?ooool08?ooool001oooooo00?oo`00o`000?oo
ool03oooool2ool00003o`000?oooooooooo01Oooooo0_oo00000ol0003oooooooooo`0Yooooo`03
o`000?oo003ooooo017ooooo00?o0000ooooooooool03_ooool2ool00003o`000?oooooooooo02[o
oooo00?o0000ool00?ooool06?ooool00ooo003o0000ooooo`0@ooooo`;oo`0000?o0000oooooooo
ool07_ooool001oooooo00?oo`00o`000?ooool04?ooool00ooo003o0000ooooo`0Gooooo`;oo`00
00?o0000ooooooooool0:_ooool00ooo003o0000ool0000Aooooo`03o`000?oooooooooo00kooooo
00?oo`00o`000?ooool0;?ooool00ooo003o0000ool0000Hooooo`03ool00?l0003ooooo013ooooo
0_oo00000ol0003oooooooooo`0Nooooo`007oooool00ooo003o0000ooooo`0@ooooo`;oo`0000?o
0000ooooooooool05Oooool2ool00003o`000?oooooooooo02_ooooo00?o0000ool00?ooool04?oo
ool00ol0003oooooooooo`0=ooooo`;oo`0000?o0000ooooooooool0;?ooool00ol0003oo`00oooo
o`0Gooooo`03o`000?oo003ooooo013ooooo0_oo00000ol0003oooooooooo`0Nooooo`007oooool0
0ooo003o0000ooooo`0@ooooo`;oo`0000?o0000ooooooooool05Oooool2ool00003o`000?oooooo
oooo02_ooooo00?oo`00o`000?ooool04?ooool00ol0003oooooooooo`0=ooooo`03ool00?l0003o
oooo02kooooo00?oo`00o`000?oo00005oooool00ol0003oo`00ooooo`0Aooooo`03ool00?l0003o
oooo01oooooo000Nooooo`03ool00?l0003oo`0001;ooooo00?oo`00o`000?ooool05Oooool2ool0
0003o`000?oooooooooo02cooooo00?oo`00o`000?oo00004?ooool00ol0003oooooooooo`0<oooo
o`;oo`0000?o0000ooooooooool0;_ooool00ol0003oo`00ooooo`0Eooooo`03ool00?l0003oo`00
01;ooooo00?oo`00o`000?ooool07oooool001kooooo00?oo`00o`000?ooool04_ooool00ooo003o
0000ooooo`0Eooooo`;oo`0000?o0000ooooooooool0;Oooool00ooo003o0000ooooo`0?ooooo`;o
00003Oooool00ooo003o0000ooooo`0`ooooo`03o`000?oo003ooooo01Gooooo00?oo`00o`000?oo
ool04_ooool00ooo003o0000ooooo`0Oooooo`007_ooool00ooo003o0000ooooo`0Booooo`;oo`00
00?o0000ooooooooool04_ooool3ool00003o`000?oooooooooo02gooooo00?oo`00o`000?oo0000
3oooool00ol0003oooooooooo`0;ooooo`;oo`0000?o0000ooooooooool0;oooool00ooo003o0000
ool0000Eooooo`03o`000?oo003ooooo01;ooooo00?oo`00o`000?ooool07oooool001kooooo00?o
o`00o`000?ooool04_ooool2ool00003o`000?oooooooooo01;ooooo0_oo00000ol0003ooooooooo
o`0_ooooo`03ool00?l0003ooooo00kooooo00?o0000ooooooooool02oooool2ool00003o`000?oo
oooooooo033ooooo00?o0000ool00?ooool05?ooool00ol0003oo`00ooooo`0Booooo`03ool00?l0
003ooooo01oooooo000Nooooo`03ool00?l0003ooooo01?ooooo00?oo`00o`000?ooool04oooool2
ool00003o`000?oooooooooo02oooooo00?oo`00o`000?oo00003_ooool00ol0003oooooooooo`0:
ooooo`;oo`0000?o0000ooooooooool0<Oooool00ol0003oo`00ool0000Cooooo`03ool00?l0003o
o`0001?ooooo00?oo`00o`000?ooool07oooool001kooooo00?oo`00o`000?ooool04oooool2ool0
0003o`000?oooooooooo013ooooo0_oo00000ol0003oooooooooo`0aooooo`03ool00?l0003ooooo
00gooooo00?o0000ooooooooool02_ooool2ool00003o`000?oooooooooo03;ooooo00?o0000ool0
0?ooool04_ooool00ol0003oo`00ooooo`0Cooooo`03ool00?l0003ooooo01oooooo000Nooooo`03
ool00?l0003ooooo01?ooooo0_oo00000ol0003oooooooooo`0@ooooo`;oo`0000?o0000oooooooo
ool0<Oooool00ooo003o0000ool0000=ooooo`03o`000?oooooooooo00[ooooo00?oo`00o`000?oo
ool0=?ooool00ol0003oo`00ool0000Booooo`03o`000?oo003ooooo01?ooooo00?oo`00o`000?oo
ool07oooool001kooooo00?oo`00o`000?ooool05?ooool00ooo003o0000ooooo`0Aooooo`03ool0
0?l0003ooooo03Cooooo00?oo`00o`000?ooool03?ooool00ol0003oooooooooo`09ooooo`;oo`00
00?o0000ooooooooool0<oooool00ol0003oo`00ool0000Aooooo`03ool00?l0003oo`0001Cooooo
00?oo`00o`000?ooool07oooool001kooooo00?oo`00o`000?ooool05?ooool2ool00003o`000?oo
oooooooo00kooooo0_oo00000ol0003oooooooooo`0cooooo`03ool00?l0003oo`0000cooooo0_l0
000:ooooo`03ool00?l0003ooooo03Kooooo00?o0000ool00?ooool04?ooool00ol0003oo`00oooo
o`0Dooooo`03ool00?l0003ooooo01oooooo000Nooooo`03ool00?l0003ooooo01Cooooo0_oo0000
0ol0003oooooooooo`0>ooooo`;oo`0000?o0000ooooooooool0=?ooool00ooo003o0000ooooo`0;
ooooo`03o`000?oooooooooo00Sooooo0_oo00000ol0003oooooooooo`0eooooo`03o`000?oo003o
o`00013ooooo00?o0000ool00?ooool05?ooool00ooo003o0000ooooo`0Oooooo`007Oooool00ooo
003o0000ool0000Fooooo`03ool00?l0003ooooo00kooooo0_oo00000ol0003oooooooooo`0eoooo
o`03ool00?l0003oo`0000_ooooo00?o0000ooooooooool02?ooool00ooo003o0000ooooo`0goooo
o`03o`000?oo003oo`0000oooooo00?oo`00o`000?oo00005Oooool2ool00003o`000?oooooooooo
01gooooo000Mooooo`03ool00?l0003ooooo01Kooooo0_oo00000ol0003oooooooooo`0<ooooo`;o
o`0000?o0000ooooooooool0=_ooool00ooo003o0000ooooo`0:ooooo`03o`000?oooooooooo00Oo
oooo0_oo00000ol0003oooooooooo`0gooooo`03o`000?oo003oo`0000kooooo00?o0000ool00?oo
ool05Oooool2ool00003o`000?oooooooooo01gooooo000Mooooo`03ool00?l0003ooooo01Kooooo
0_oo00000ol0003oooooooooo`0;ooooo`;oo`0000?o0000ooooooooool0=oooool00ooo003o0000
ool0000:ooooo`03o`000?oooooooooo00Oooooo00?oo`00o`000?ooool0>Oooool00ol0003oo`00
ool0000>ooooo`03o`000?oo003ooooo01Gooooo0_oo00000ol0003oooooooooo`0Mooooo`007Ooo
ool00ooo003o0000ooooo`0Gooooo`03ool00?l0003ooooo00cooooo0_oo00000ol0003ooooooooo
o`0hooooo`03ool00?l0003ooooo00Wooooo00?o0000ooooooooool01_ooool2ool00003o`000?oo
oooooooo03Sooooo00?o0000ool00?oo00003Oooool00ooo003o0000ool0000Fooooo`;oo`0000?o
0000ooooooooool07Oooool001gooooo00?oo`00o`000?ooool05oooool2ool00003o`000?oooooo
oooo00[ooooo00?oo`00o`000?ooool0>_ooool00ooo003o0000ool00009ooooo`03o`000?oooooo
oooo00Kooooo00?oo`00o`000?ooool0>oooool00ol0003oo`00ool0000<ooooo`03o`000?oo003o
oooo01Kooooo0_oo00000ol0003oooooooooo`0Mooooo`007Oooool00ooo003o0000ooooo`0Hoooo
o`03ool00?l0003ooooo00[ooooo0_oo00000ol0003oooooooooo`0jooooo`03ool00?l0003oo`00
00Sooooo0_l00006ooooo`;oo`0000?o0000ooooooooool0>oooool00ol0003oo`00ool0000:oooo
o`03ool00?l0003oo`0001Oooooo0_oo00000ol0003oooooooooo`0Mooooo`007Oooool00ooo003o
0000ooooo`0Hooooo`03ool00?l0003ooooo00[ooooo0_oo00000ol0003oooooooooo`0kooooo`03
ool00?l0003oo`0000Oooooo00?o0000ooooooooool01?ooool2ool00003o`000?oooooooooo03co
oooo00?o0000ool00?oo00002_ooool00ooo003o0000ooooo`0Hooooo`03ool00?l0003ooooo01ko
oooo000Mooooo`03ool00?l0003ooooo01Sooooo0_oo00000ol0003oooooooooo`07ooooo`;oo`00
00?o0000ooooooooool0?Oooool00ooo003o0000ool00006ooooo`03o`000?oooooooooo00?ooooo
0_oo00000ol0003oooooooooo`0nooooo`03o`000?oo003oo`0000Sooooo00?oo`00o`000?oo0000
6Oooool00ooo003o0000ooooo`0Nooooo`007Oooool00ooo003o0000ooooo`0Iooooo`03ool00?l0
003ooooo00Oooooo0ooo00000ol0003oooooooooo`0nooooo`03ool00?l0003oo`0000Gooooo00?o
0000ooooooooool00_ooool2ool00003o`000?oooooooooo043ooooo00?o0000ool00?ooool01_oo
ool2ool00003o`000?oooooooooo01Sooooo00?oo`00o`000?ooool07_ooool001gooooo00?oo`00
o`000?ooool06Oooool2ool00003o`000?oooooooooo00Cooooo0_oo0002o`00043ooooo0_l00000
0ooo003o0000ool00004ooooo`03o`000?oooooooooo00?oo`0000?o0000ooooooooool0@Oooool0
0ooo003o0000ool00005ooooo`;oo`0000?o0000ool00?ooool06Oooool00ooo003o0000ooooo`0N
ooooo`007Oooool00ooo003o0000ooooo`0Jooooo`;oo`0000?o0000ool00?ooool00_ooool2ool0
0003o`000?oooooooooo047ooooo00Go0000oooooooo003o0000ool00003ooooo`04o`000?oooooo
o`00ool000;o0000AOooool00ol0003oo`00ool00004ooooo`03ool00?l0003ooooo01_ooooo00?o
o`00o`000?ooool07_ooool001gooooo00?oo`00o`000?ooool06oooool2ool00003o`000?oo003o
o`0000;oo`0000?o0000ooooooooool0@_ooool01?l0003ooooooooooooo0003o`0000Coo`0000?o
0000ooooooooool0A_ooool00ol0003oo`00ool00004ool00003o`000?oooooooooo01[ooooo00?o
o`00o`000?ooool07_ooool001gooooo00?oo`00o`000?ooool07?ooool2ool000Go0000A?ooool0
1?l0003oooooooooooooool2ool000Go000000?oo`00ooooooooool0Aoooool2o`0000;oo`000_l0
000Mooooo`03ool00?l0003ooooo01kooooo000Mooooo`03ool00?l0003ooooo06Oooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`1;ooooo`?o00007oooool00ooo003o0000ooooo`0N
ooooo`007Oooool00ooo003o0000ooooo`1Vooooo`;o00001oooool00ol0003oooooooooo`1]oooo
o`03ool00?l0003ooooo01kooooo000Mooooo`03ool00?l0003ooooo06Oooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`1]ooooo`03ool00?l0003ooooo01kooooo000Mooooo`03ool0
0?l0003ooooo06oooooo00?o0000ooooooooool0KOooool00ooo003o0000ooooo`0Nooooo`007Ooo
ool00ooo003o0000ooooo`1_ooooo`03o`000?oooooooooo06gooooo00?oo`00o`000?ooool07_oo
ool001gooooo00?oo`00o`000?ooool0Koooool2o`0006kooooo00?oo`00o`000?oo00007_ooool0
01cooooo0_oo00000ol0003oooooooooo`1^ooooo`03o`000?oooooooooo06kooooo00?o0000ool0
0?ooool07Oooool001cooooo00?oo`00o`000?ooool0L?ooool00ol0003oooooooooo`1^ooooo`03
o`000?oo003ooooo01gooooo000Looooo`03ool00?l0003ooooo073ooooo00?o0000ooooooooool0
K_ooool00ol0003oo`00ooooo`0Mooooo`007?ooool00ooo003o0000ooooo`1`ooooo`03o`000?oo
oooooooo06kooooo00?o0000ool00?ooool07Oooool001cooooo00?oo`00o`000?ooool0L?ooool0
0ol0003oooooooooo`1^ooooo`03o`000?oo003ooooo01gooooo000Looooo`03ool00?l0003ooooo
073ooooo00?o0000ooooooooool0K_ooool00ooo003o0000ooooo`0Mooooo`007?ooool00ooo003o
0000ooooo`1`ooooo`;o0000Koooool00ooo003o0000ooooo`0Mooooo`007?ooool00ooo003o0000
ooooo`1`ooooo`03o`000?oooooooooo06kooooo00?oo`00o`000?ooool07Oooool001cooooo00?o
o`00o`000?ooool0L?ooool00ol0003oooooooooo`1^ooooo`03ool00?l0003ooooo01gooooo000L
ooooo`03ool00?l0003ooooo073ooooo00?o0000ooooooooool0K_ooool00ooo003o0000ooooo`0M
ooooo`007?ooool00ooo003o0000ooooo`1`ooooo`03o`000?oooooooooo06kooooo00?oo`00o`00
0?ooool07Oooool001cooooo00?oo`00o`000?ooool0L?ooool00ol0003oooooooooo`1^ooooo`03
ool00?l0003ooooo01gooooo000Looooo`03ool00?l0003ooooo073ooooo00?o0000ooooooooool0
K_ooool00ooo003o0000ooooo`0Mooooo`007?ooool00ooo003o0000ooooo`1`ooooo`;o0000Kooo
ool00ooo003o0000ooooo`0Mooooo`007?ooool00ooo003o0000ooooo`1`ooooo`03o`000?oooooo
oooo06kooooo00?oo`00o`000?ooool07Oooool001cooooo00?oo`00o`000?ooool0L?ooool00ol0
003oooooooooo`1^ooooo`03ool00?l0003ooooo01gooooo000Looooo`03ool00?l0003ooooo073o
oooo00?o0000ooooooooool0K_ooool00ooo003o0000ooooo`0Mooooo`007?ooool00ooo003o0000
ooooo`1`ooooo`03o`000?oooooooooo06kooooo00?oo`00o`000?ooool07Oooool001cooooo00?o
o`00o`000?ooool0L?ooool00ol0003oooooooooo`1^ooooo`03ool00?l0003ooooo01gooooo000L
ooooo`03ool00?l0003ooooo073ooooo0_l0001_ooooo`03ool00?l0003ooooo01gooooo000Loooo
o`03ool00?l0003ooooo073ooooo00?o0000ooooooooool0K_ooool00ooo003o0000ooooo`0Moooo
o`007?ooool00ooo003o0000ooooo`1`ooooo`03o`000?oooooooooo06kooooo00?oo`00o`000?oo
00007Oooool001cooooo00?oo`00o`000?ooool0L?ooool00ol0003oooooooooo`1_ooooo`03o`00
0?oo003ooooo01cooooo000Looooo`03ool00?l0003ooooo06Kooooo1Ol00005ooooo`03o`000?oo
oooooooo06oooooo00?o0000ool00?ooool07?ooool001cooooo00?oo`00o`000?ooool0Ioooool0
1?l0003oooooooooool00005ooooo`03o`000?oooooooooo06oooooo00?o0000ool00?ooool07?oo
ool001_ooooo0_oo00000ol0003oooooooooo`1Wooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool0Koooool00ol0003oo`00ooooo`0Looooo`006oooool00ooo003o0000ooooo`1Zoooo
o`03o`000?oooooooooo00Cooooo0ol0001_ooooo`03o`000?oo003ooooo01cooooo000Kooooo`03
ool00?l0003ooooo06Oooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo
06oooooo00?o0000ool00?ooool07?ooool001_ooooo00?oo`00o`000?ooool0Ioooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool0Koooool00ooo003o0000ooooo`0Loooo
o`006oooool00ooo003o0000ooooo`1Xooooo`?o00001_ooool00ol0003oooooooooo`1_ooooo`03
ool00?l0003ooooo01cooooo000Kooooo`03ool00?l0003ooooo077ooooo00?o0000ooooooooool0
Koooool00ooo003o0000ooooo`0Looooo`006oooool00ooo003o0000ooooo`1aooooo`03o`000?oo
oooooooo06oooooo00?oo`00o`000?ooool07?ooool001_ooooo00?oo`00o`000?ooool0LOooool0
0ol0003oooooooooo`1_ooooo`03ool00?l0003ooooo01cooooo000Kooooo`03ool00?l0003ooooo
077ooooo0_l0001`ooooo`03ool00?l0003ooooo01cooooo000Kooooo`03ool00?l0003ooooo077o
oooo00?o0000ooooooooool0Koooool00ooo003o0000ooooo`0Looooo`006oooool00ooo003o0000
ooooo`1aooooo`03o`000?oooooooooo06oooooo00?oo`00o`000?ooool07?ooool001_ooooo00?o
o`00o`000?ooool0LOooool00ol0003oooooooooo`1_ooooo`03ool00?l0003ooooo01cooooo000K
ooooo`03ool00?l0003ooooo077ooooo00?o0000ooooooooool0Koooool00ooo003o0000ooooo`0L
ooooo`006oooool00ooo003o0000ooooo`1aooooo`03o`000?oooooooooo06oooooo00?oo`00o`00
0?ooool07?ooool001_ooooo00?oo`00o`000?ooool0LOooool2o`00073ooooo00?oo`00o`000?oo
ool07?ooool001_ooooo00?oo`00o`000?ooool0LOooool00ol0003oooooooooo`1_ooooo`03ool0
0?l0003ooooo01cooooo000Kooooo`03ool00?l0003ooooo077ooooo00?o0000ooooooooool0Kooo
ool00ooo003o0000ooooo`0Looooo`006oooool00ooo003o0000ooooo`1aooooo`03o`000?oooooo
oooo06oooooo00?oo`00o`000?ooool07?ooool001_ooooo00?oo`00o`000?ooool0LOooool00ol0
003oooooooooo`1_ooooo`03ool00?l0003ooooo01cooooo000Kooooo`03ool00?l0003ooooo077o
oooo00?o0000ooooooooool0Koooool00ooo003o0000ooooo`0Looooo`006oooool00ooo003o0000
ooooo`1aooooo`03o`000?oooooooooo06oooooo00?oo`00o`000?ooool07?ooool001[ooooo0_oo
00000ol0003oooooooooo`1`ooooo`;o0000L?ooool00ooo003o0000ooooo`0Looooo`006_ooool0
0ooo003o0000ooooo`1booooo`03o`000?oooooooooo06oooooo0_oo00000ol0003oooooooooo`0J
ooooo`006_ooool00ooo003o0000ooooo`1booooo`03o`000?oooooooooo06oooooo0_oo00000ol0
003oooooooooo`0Jooooo`006_ooool00ooo003o0000ooooo`1booooo`03o`000?oooooooooo06oo
oooo0_oo00000ol0003oooooooooo`0Jooooo`006_ooool00ooo003o0000ooooo`1booooo`03o`00
0?oooooooooo06oooooo0_oo00000ol0003oooooooooo`0Jooooo`006_ooool00ooo003o0000oooo
o`1booooo`03o`000?oooooooooo06oooooo0_oo00000ol0003oooooooooo`0Jooooo`006_ooool0
0ooo003o0000ooooo`1booooo`03o`000?oooooooooo06oooooo0_oo00000ol0003oooooooooo`0J
ooooo`006_ooool00ooo003o0000ooooo`1booooo`;o0000L?ooool2ool00003o`000?oooooooooo
01[ooooo000Jooooo`03ool00?l0003ooooo07;ooooo00?o0000ooooooooool0Koooool2ool00003
o`000?oooooooooo01[ooooo000Jooooo`03ool00?l0003ooooo07;ooooo00?o0000ooooooooool0
Koooool2ool00003o`000?oooooooooo01[ooooo000Jooooo`03ool00?l0003ooooo07;ooooo00?o
0000ooooooooool0Koooool2ool00003o`000?oooooooooo01[ooooo000Jooooo`03ool00?l0003o
oooo06Wooooo0ol00006ooooo`03o`000?oooooooooo06oooooo0_oo00000ol0003oooooooooo`0J
ooooo`006_ooool00ooo003o0000ooooo`1Xooooo`05o`000?ooooooooooooooool000001Oooool0
0ol0003oooooooooo`1_ooooo`;oo`0000?o0000ooooooooool06_ooool001[ooooo00?oo`00o`00
0?ooool0K?ooool00ol0003oooooooooo`03ooooo`?o0000Koooool2ool00003o`000?oooooooooo
01[ooooo000Jooooo`03ool00?l0003ooooo06[ooooo0_l00006ooooo`03o`000?oooooooooo073o
oooo00?oo`00o`000?ooool06oooool001[ooooo00?oo`00o`000?ooool0K?ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo073ooooo00?oo`00o`000?ooool06oooool001[ooooo00?o
o`00o`000?ooool0J?ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool0
L?ooool00ooo003o0000ooooo`0Kooooo`006_ooool00ooo003o0000ooooo`1Yooooo`?o00001_oo
ool00ol0003oooooooooo`1`ooooo`03ool00?l0003ooooo01_ooooo000Jooooo`03ool00?l0003o
oooo07;ooooo00?o0000ooooooooool0L?ooool00ooo003o0000ooooo`0Kooooo`006_ooool00ooo
003o0000ooooo`1booooo`03o`000?oooooooooo073ooooo00?oo`00o`000?ooool06oooool001[o
oooo00?oo`00o`000?ooool0L_ooool2o`00077ooooo00?oo`00o`000?ooool06oooool001[ooooo
00?oo`00o`000?ooool0L_ooool00ol0003oooooooooo`1`ooooo`03ool00?l0003ooooo01_ooooo
000Jooooo`03ool00?l0003ooooo07;ooooo00?o0000ooooooooool0L?ooool00ooo003o0000oooo
o`0Kooooo`006_ooool00ooo003o0000ooooo`1booooo`03o`000?oooooooooo073ooooo00?oo`00
o`000?ooool06oooool001[ooooo00?oo`00o`000?ooool0L_ooool00ol0003oooooooooo`1`oooo
o`03ool00?l0003ooooo01_ooooo000Jooooo`03ool00?l0003ooooo07;ooooo00?o0000oooooooo
ool0L?ooool00ooo003o0000ooooo`0Kooooo`006_ooool00ooo003o0000ooooo`1booooo`03o`00
0?oooooooooo073ooooo00?oo`00o`000?ooool06oooool001[ooooo00?oo`00o`000?ooool0L_oo
ool2o`00077ooooo00?oo`00o`000?ooool06oooool001[ooooo00?oo`00o`000?ooool0L_ooool0
0ol0003oooooooooo`1`ooooo`03ool00?l0003ooooo01_ooooo000Jooooo`03ool00?l0003ooooo
07;ooooo00?o0000ooooooooool0L?ooool00ooo003o0000ooooo`0Kooooo`006_ooool00ooo003o
0000ooooo`1booooo`03o`000?oooooooooo073ooooo00?oo`00o`000?ooool06oooool001Wooooo
00?oo`00o`000?oo0000Loooool00ol0003oooooooooo`1`ooooo`;oo`0000?o0000ooooooooool0
6Oooool001Wooooo00?oo`00o`000?ooool0Loooool00ol0003oooooooooo`1`ooooo`;oo`0000?o
0000ooooooooool06Oooool001Wooooo00?oo`00o`000?ooool0Loooool00ol0003oooooooooo`1`
ooooo`;oo`0000?o0000ooooooooool06Oooool001Wooooo00?oo`00o`000?ooool0Loooool2o`00
077ooooo0_oo00000ol0003oooooooooo`0Iooooo`006Oooool00ooo003o0000ooooo`1cooooo`03
o`000?oooooooooo073ooooo0_oo00000ol0003oooooooooo`0Iooooo`006Oooool00ooo003o0000
ooooo`1cooooo`03o`000?oooooooooo073ooooo0_oo00000ol0003oooooooooo`0Iooooo`006Ooo
ool00ooo003o0000ooooo`1cooooo`03o`000?oooooooooo073ooooo0_oo00000ol0003ooooooooo
o`0Iooooo`006Oooool00ooo003o0000ooooo`1cooooo`03o`000?oooooooooo073ooooo0_oo0000
0ol0003oooooooooo`0Iooooo`006Oooool00ooo003o0000ooooo`1cooooo`03o`000?oooooooooo
073ooooo0_oo00000ol0003oooooooooo`0Iooooo`006Oooool00ooo003o0000ooooo`1cooooo`;o
0000LOooool2ool00003o`000?oooooooooo01Wooooo000Iooooo`03ool00?l0003ooooo07?ooooo
00?o0000ooooooooool0L?ooool2ool00003o`000?oooooooooo01Wooooo000Iooooo`03ool00?l0
003ooooo07?ooooo00?o0000ooooooooool0L?ooool2ool00003o`000?oooooooooo01Wooooo000I
ooooo`03ool00?l0003ooooo07?ooooo00?o0000ooooooooool0L?ooool2ool00003o`000?oooooo
oooo01Wooooo000Iooooo`03ool00?l0003ooooo06_ooooo0ol00005ooooo`03o`000?oooooooooo
077ooooo00?oo`00o`000?ooool06_ooool001Wooooo00?oo`00o`000?ooool0K?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo077ooooo00?oo`00o`000?ooool06_ooool001Wooooo
00?oo`00o`000?ooool0JOooool5o`0000Gooooo00?o0000ooooooooool0LOooool00ooo003o0000
ooooo`0Jooooo`006Oooool00ooo003o0000ooooo`1Yooooo`04o`000?ooooooooooo`0000Kooooo
0ol0001aooooo`03ool00?l0003ooooo01[ooooo000Iooooo`03ool00?l0003ooooo06[ooooo00?o
0000ooooool000001_ooool00ol0003oooooooooo`1aooooo`03ool00?l0003ooooo01[ooooo000I
ooooo`03ool00?l0003ooooo06_ooooo0_l00006ooooo`03o`000?oooooooooo077ooooo00?oo`00
o`000?ooool06_ooool001Wooooo00?oo`00o`000?ooool0K?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo077ooooo00?oo`00o`000?ooool06_ooool001Wooooo00?oo`00o`000?oo
ool0Loooool00ol0003oooooooooo`1aooooo`03ool00?l0003ooooo01[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.27019, -1.14212, \
0.0088515, 0.0298202}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(sol\  = \ 
        Reap[\[IndentingNewLine]NMinimize[SquaredPenaltyFunc, \ 
            ListOfVars, \ \[IndentingNewLine]StepMonitor \[RuleDelayed] \ 
              Sow[ListOfVars], \[IndentingNewLine]MaxIterations \[Rule] \ 
              12, \[IndentingNewLine]Method\  \[Rule] \ \
{"\<DifferentialEvolution\>", \ "\<SearchPoints\>" \[Rule] \ 
                  10}\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(sol[\([\(-1\)]\)]\)[\([1]\)] // Length\)], "Input"],

Cell[BoxData[
    \(115\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Griewangk's Function", "Section"],

Cell[BoxData[
    \(Griewangk[coeff_List]\  := \[IndentingNewLine]\ 
      Total[coeff^2/4000]\  - \ 
        Product[\ 
          Cos[\ coeff[\([i + 1]\)]/Sqrt[i + 1]\ ], \ {i, 0, 9}\ ]\ \  + \ 
        1\)], "Input"],

Cell[BoxData[
    \(\(GrieVars\  = \ {a0, \ a1, \ a2, \ a3, \ a4, \ a5, \ a6, \ a7, \ a8, \ 
          a9};\)\)], "Input"],

Cell[BoxData[
    \(\(GriewangkFunc\  = \ Griewangk[GrieVars];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Gsol = \ 
      GrieVars\  /. \ \ \(NMinimize[GriewangkFunc, \ GrieVars, \ 
            Method \[Rule] {"\<DifferentialEvolution\>"}]\)[\([2]\)]\)], \
"Input"],

Cell[BoxData[
    \({\(-4.737451510841616`*^-11\), 
      1.6630553661712954`*^-9, \(-1.074241117017706`*^-9\), 
      1.4289324874741152`*^-8, \(-3.0946840490673964`*^-9\), 
      2.6987479634586498`*^-9, 5.073908947246935`*^-9, 
      2.8390418371355704`*^-9, 1.0122970842678225`*^-8, 
      1.0751594983656322`*^-9}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Corana's Parabola: Ingber (1993), Corana et alii (1987).", "Section"],

Cell[BoxData[
    \(\(\(f6[
          coeff_List]\  := \ \[IndentingNewLine]Module[{dj, zj, cz, c1, 
            c2}, \[IndentingNewLine]dj\  = {1. , \ 1000. , \ 10. , \ 
              100. }; \[IndentingNewLine]zj\  = \ \(Floor[\ 
                    Abs[#/0.2]\  + \ 0.49999\ ]\ Sign[#]\ 0.2\  &\)\  /@ \ 
              coeff; \[IndentingNewLine]cz\  = \ \(# < 0.05\  &\)\  /@ \ 
              Abs[coeff\  - \ zj]; \[IndentingNewLine]c1\  = \ 
            0.15\ \((\ 
                  zj\  - \ 
                    0.05\ Sign[zj]\ )\)^2\ \ dj; \[IndentingNewLine]c2\  = \ 
            dj\ coeff\ ^2; \[IndentingNewLine]Total[
            Map[If[#[\([1]\)], \ #[\([2]\)], \ #[\([3]\)]] &, \ 
              Thread[{cz, c1, 
                  c2}]]]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(\(CVars\  = \ {x1, x2, x3, x4};\)\)], "Input"],

Cell[BoxData[
    \(\(CoranaFunc = f6[CVars];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[CoranaFunc, \ CVars]\)], "Input"],

Cell[BoxData[
    \({0.45562500000000006`, {x1 \[Rule] \(-0.7719837907591419`\), 
        x2 \[Rule] 0.019037319919359294`, 
        x3 \[Rule] \(-0.23719177313118567`\), 
        x4 \[Rule] 0.1719214612907332`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[CoranaFunc, \ CVars, 
      Method -> "\<DifferentialEvolution\>"]\)], "Input"],

Cell[BoxData[
    \({0.`, {x1 \[Rule] \(-0.005084574605747657`\), 
        x2 \[Rule] \(-0.040864978722906856`\), 
        x3 \[Rule] \(-0.020862596229034178`\), 
        x4 \[Rule] \(-0.008088899577172962`\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Corana's parabola in 2D", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      Evaluate[CoranaFunc /. \ {\ x2 \[Rule] \ 0. , \ 
            x4 \[Rule] \ 0. }], \ {x1, 0, 1}, {x3, 0, 1}, 
      Mesh \[Rule] False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.1978e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.14598 .19958 -17.886 -9 ]
[.14598 .19958 .11404 0 ]
[.27013 .15073 -17.1354 -9 ]
[.27013 .15073 .86461 0 ]
[.40046 .09948 -16.3848 -9 ]
[.40046 .09948 1.61518 0 ]
[.53743 .04564 -15.6342 -9 ]
[.53743 .04564 2.36575 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.76745 .09703 0 -6.16187 ]
[.76745 .09703 18 2.83813 ]
[.82812 .18993 0 -6.07246 ]
[.82812 .18993 18 2.92754 ]
[.88369 .27502 0 -5.99218 ]
[.88369 .27502 18 3.00782 ]
[.93478 .35327 0 -5.9197 ]
[.93478 .35327 18 3.0803 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01683 .31074 -6 -2.78089 ]
[.01683 .31074 0 6.21911 ]
[.00933 .35774 -6 -2.82074 ]
[.00933 .35774 0 6.17926 ]
[.0016 .40618 -6 -2.86193 ]
[.0016 .40618 0 6.13807 ]
[-0.00636 .45612 -6 -2.90453 ]
[-0.00636 .45612 0 6.09547 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.2)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.4)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.6)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.8)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.18558 .19702 m
.18832 .19985 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.3108 .14799 m
.31341 .15094 L
s
.34306 .13535 m
.34564 .13834 L
s
.37572 .12257 m
.37826 .12558 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.51046 .06981 m
.51284 .07294 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.75514 .10158 m
.74899 .10385 L
s
[(0.2)] .76745 .09703 -1 .3693 Mshowa
.81573 .19425 m
.80953 .19642 L
s
[(0.4)] .82812 .18993 -1 .34944 Mshowa
.87123 .27915 m
.865 .28122 L
s
[(0.6)] .88369 .27502 -1 .3316 Mshowa
.92227 .35722 m
.91601 .35919 L
s
[(0.8)] .93478 .35327 -1 .31549 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(1)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.7708 .12553 m
.7671 .12688 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.83006 .21617 m
.82633 .21745 L
s
.84407 .23761 m
.84035 .23888 L
s
.8578 .2586 m
.85407 .25986 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.9099 .3383 m
.90615 .3395 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02909 .30606 m
.03522 .30371 L
s
[(2)] .01683 .31074 1 -0.38202 Mshowa
.02163 .35315 m
.02777 .35086 L
s
[(4)] .00933 .35774 1 -0.37317 Mshowa
.01394 .40169 m
.0201 .39945 L
s
[(6)] .0016 .40618 1 -0.36402 Mshowa
.006 .45174 m
.01219 .44954 L
s
[(8)] -0.00636 .45612 1 -0.35455 Mshowa
.125 Mabswid
.03455 .27164 m
.03821 .27021 L
s
.03274 .28303 m
.03641 .28161 L
s
.03092 .2945 m
.0346 .29309 L
s
.02725 .3177 m
.03093 .3163 L
s
.02539 .32943 m
.02907 .32804 L
s
.02351 .34125 m
.0272 .33986 L
s
.01973 .36515 m
.02342 .36378 L
s
.01781 .37724 m
.0215 .37588 L
s
.01588 .38942 m
.01958 .38806 L
s
.01198 .41406 m
.01568 .41272 L
s
.01 .42652 m
.01371 .42519 L
s
.00801 .43908 m
.01172 .43776 L
s
.00398 .46449 m
.0077 .46318 L
s
.00195 .47735 m
.00566 .47605 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.661 .744 .911 r
.39126 .62012 .40414 .63189 .4257 .62553 .41293 .61366 Mtetra
.659 .744 .912 r
.41293 .61366 .4257 .62553 .44742 .61927 .43477 .60731 Mtetra
.658 .743 .913 r
.43477 .60731 .44742 .61927 .46933 .613 .45678 .60094 Mtetra
.666 .745 .91 r
.45678 .60094 .46933 .613 .49142 .60623 .47899 .59407 Mtetra
.661 .744 .911 r
.47899 .59407 .49142 .60623 .51369 .59966 .50137 .5874 Mtetra
.639 .738 .92 r
.50137 .5874 .51369 .59966 .53614 .5943 .52394 .58195 Mtetra
.653 .742 .915 r
.52394 .58195 .53614 .5943 .55878 .58812 .54671 .57566 Mtetra
.652 .742 .915 r
.54671 .57566 .55878 .58812 .58162 .58195 .56967 .56939 Mtetra
.692 .753 .898 r
.56967 .56939 .58162 .58195 .6046 .57319 .59278 .56052 Mtetra
.661 .744 .911 r
.59278 .56052 .6046 .57319 .6278 .56635 .61611 .55357 Mtetra
.583 .717 .935 r
.61611 .55357 .6278 .56635 .65135 .56358 .63978 .55071 Mtetra
.647 .74 .917 r
.63978 .55071 .65135 .56358 .67501 .55749 .66358 .54452 Mtetra
.645 .739 .918 r
.66358 .54452 .67501 .55749 .69889 .55143 .68759 .53835 Mtetra
.734 .766 .879 r
.68759 .53835 .69889 .55143 .7226 .539 .71146 .52579 Mtetra
.661 .744 .912 r
.71146 .52579 .7226 .539 .7468 .53187 .7358 .51854 Mtetra
.483 .668 .945 r
.7358 .51854 .7468 .53187 .77185 .53337 .76097 .51997 Mtetra
.64 .738 .919 r
.76097 .51997 .77185 .53337 .79663 .52739 .7859 .51388 Mtetra
.639 .737 .92 r
.7859 .51388 .79663 .52739 .82166 .52143 .81108 .5078 Mtetra
.785 .783 .851 r
.81108 .5078 .82166 .52143 .84578 .50358 .83538 .4898 Mtetra
.661 .744 .912 r
.83538 .4898 .84578 .50358 .87104 .49614 .8608 .48224 Mtetra
.334 .579 .931 r
.8608 .48224 .87104 .49614 .89821 .50367 .8881 .4897 Mtetra
.634 .735 .921 r
.8881 .4897 .89821 .50367 .92425 .49779 .9143 .4837 Mtetra
.826 .798 .825 r
.9143 .4837 .92425 .49779 .94831 .47456 .93857 .46028 Mtetra
.661 .744 .912 r
.93857 .46028 .94831 .47456 .97449 .46685 .96491 .45245 Mtetra
.549 .311 .507 r
.37153 .76404 .39126 .62012 .41293 .61366 .39427 .75786 Mtetra
.55 .311 .507 r
.39427 .75786 .41293 .61366 .43477 .60731 .4172 .75179 Mtetra
.55 .312 .507 r
.4172 .75179 .43477 .60731 .45678 .60094 .44033 .7457 Mtetra
.549 .311 .507 r
.44033 .7457 .45678 .60094 .47899 .59407 .46367 .73907 Mtetra
.46367 .73907 .47899 .59407 .50137 .5874 .4872 .73267 Mtetra
.552 .314 .508 r
.4872 .73267 .50137 .5874 .52394 .58195 .51094 .72761 Mtetra
.55 .312 .507 r
.51094 .72761 .52394 .58195 .54671 .57566 .5349 .72163 Mtetra
.551 .312 .507 r
.5349 .72163 .54671 .57566 .56967 .56939 .55907 .71568 Mtetra
.545 .307 .506 r
.55907 .71568 .56967 .56939 .59278 .56052 .58342 .70687 Mtetra
.549 .311 .507 r
.58342 .70687 .59278 .56052 .61611 .55357 .60801 .70018 Mtetra
.558 .319 .509 r
.60801 .70018 .61611 .55357 .63978 .55071 .63296 .698 Mtetra
.551 .313 .507 r
.63296 .698 .63978 .55071 .66358 .54452 .65805 .69217 Mtetra
.551 .313 .508 r
.65805 .69217 .66358 .54452 .68759 .53835 .68339 .68636 Mtetra
.537 .302 .505 r
.68339 .68636 .68759 .53835 .71146 .52579 .70861 .6735 Mtetra
.549 .311 .507 r
.70861 .6735 .71146 .52579 .7358 .51854 .73432 .66651 Mtetra
.567 .326 .509 r
.73432 .66651 .7358 .51854 .76097 .51997 .76092 .6691 Mtetra
.552 .314 .508 r
.76092 .6691 .76097 .51997 .7859 .51388 .78729 .6634 Mtetra
.78729 .6634 .7859 .51388 .81108 .5078 .81393 .65773 Mtetra
.527 .294 .505 r
.81393 .65773 .81108 .5078 .83538 .4898 .83964 .63886 Mtetra
.549 .311 .507 r
.83964 .63886 .83538 .4898 .8608 .48224 .86656 .63155 Mtetra
.579 .334 .509 r
.86656 .63155 .8608 .48224 .8881 .4897 .89553 .64088 Mtetra
.553 .314 .508 r
.89553 .64088 .8881 .4897 .9143 .4837 .92331 .63532 Mtetra
.517 .288 .505 r
.92331 .63532 .9143 .4837 .93857 .46028 .94901 .61046 Mtetra
.549 .311 .507 r
.94901 .61046 .93857 .46028 .96491 .45245 .97697 .60288 Mtetra
.637 .582 .776 r
.35841 .73533 .37153 .76404 .39427 .75786 .38116 .72901 Mtetra
.636 .581 .776 r
.38116 .72901 .39427 .75786 .4172 .75179 .40411 .72279 Mtetra
.40411 .72279 .4172 .75179 .44033 .7457 .42725 .71656 Mtetra
.64 .583 .775 r
.42725 .71656 .44033 .7457 .46367 .73907 .45061 .70978 Mtetra
.637 .582 .776 r
.45061 .70978 .46367 .73907 .4872 .73267 .47416 .70324 Mtetra
.625 .576 .779 r
.47416 .70324 .4872 .73267 .51094 .72761 .4979 .69802 Mtetra
.633 .58 .777 r
.4979 .69802 .51094 .72761 .5349 .72163 .52187 .69189 Mtetra
.632 .579 .777 r
.52187 .69189 .5349 .72163 .55907 .71568 .54607 .68579 Mtetra
.655 .591 .771 r
.54607 .68579 .55907 .71568 .58342 .70687 .57044 .67683 Mtetra
.637 .582 .776 r
.57044 .67683 .58342 .70687 .60801 .70018 .59505 .66999 Mtetra
.596 .56 .785 r
.59505 .66999 .60801 .70018 .63296 .698 .62 .66763 Mtetra
.629 .578 .778 r
.62 .66763 .63296 .698 .65805 .69217 .64512 .66163 Mtetra
.64512 .66163 .65805 .69217 .68339 .68636 .67048 .65566 Mtetra
.682 .605 .763 r
.67048 .65566 .68339 .68636 .70861 .6735 .69574 .64267 Mtetra
.637 .582 .776 r
.69574 .64267 .70861 .6735 .73432 .66651 .72148 .63552 Mtetra
.547 .533 .791 r
.72148 .63552 .73432 .66651 .76092 .6691 .74807 .63789 Mtetra
.626 .576 .779 r
.74807 .63789 .76092 .6691 .78729 .6634 .77446 .63201 Mtetra
.625 .576 .779 r
.77446 .63201 .78729 .6634 .81393 .65773 .80112 .62617 Mtetra
.716 .622 .752 r
.80112 .62617 .81393 .65773 .83964 .63886 .8269 .6072 Mtetra
.637 .582 .776 r
.8269 .6072 .83964 .63886 .86656 .63155 .85385 .59972 Mtetra
.475 .491 .794 r
.85385 .59972 .86656 .63155 .89553 .64088 .88279 .60877 Mtetra
.622 .574 .779 r
.88279 .60877 .89553 .64088 .92331 .63532 .9106 .60302 Mtetra
.746 .638 .74 r
.9106 .60302 .92331 .63532 .94901 .61046 .93639 .57809 Mtetra
.637 .582 .776 r
.93639 .57809 .94901 .61046 .97697 .60288 .96438 .57033 Mtetra
.585 .403 .602 r
.35201 .57288 .35841 .73533 .38116 .72901 .37394 .56611 Mtetra
.584 .403 .602 r
.37394 .56611 .38116 .72901 .40411 .72279 .39605 .55943 Mtetra
.39605 .55943 .40411 .72279 .42725 .71656 .41834 .55273 Mtetra
.585 .404 .602 r
.41834 .55273 .42725 .71656 .45061 .70978 .44083 .54553 Mtetra
.585 .403 .602 r
.44083 .54553 .45061 .70978 .47416 .70324 .4635 .53853 Mtetra
.582 .401 .602 r
.4635 .53853 .47416 .70324 .4979 .69802 .48634 .53274 Mtetra
.584 .403 .602 r
.48634 .53274 .4979 .69802 .52187 .69189 .5094 .52611 Mtetra
.5094 .52611 .52187 .69189 .54607 .68579 .53266 .5195 Mtetra
.589 .406 .602 r
.53266 .5195 .54607 .68579 .57044 .67683 .55611 .51026 Mtetra
.585 .403 .602 r
.55611 .51026 .57044 .67683 .59505 .66999 .57976 .50296 Mtetra
.577 .398 .602 r
.57976 .50296 .59505 .66999 .62 .66763 .60371 .49976 Mtetra
.583 .402 .602 r
.60371 .49976 .62 .66763 .64512 .66163 .62783 .49321 Mtetra
.62783 .49321 .64512 .66163 .67048 .65566 .65217 .48668 Mtetra
.594 .41 .602 r
.65217 .48668 .67048 .65566 .69574 .64267 .67644 .47371 Mtetra
.585 .403 .602 r
.67644 .47371 .69574 .64267 .72148 .63552 .70114 .46609 Mtetra
.569 .392 .602 r
.70114 .46609 .72148 .63552 .74807 .63789 .72659 .46717 Mtetra
.582 .402 .602 r
.72659 .46717 .74807 .63789 .77446 .63201 .75188 .4607 Mtetra
.75188 .4607 .77446 .63201 .80112 .62617 .77742 .45424 Mtetra
.603 .416 .601 r
.77742 .45424 .80112 .62617 .8269 .6072 .80219 .43578 Mtetra
.585 .403 .602 r
.80219 .43578 .8269 .6072 .85385 .59972 .82801 .42782 Mtetra
.558 .385 .603 r
.82801 .42782 .85385 .59972 .88279 .60877 .8556 .43495 Mtetra
.582 .401 .602 r
.8556 .43495 .88279 .60877 .9106 .60302 .8822 .42854 Mtetra
.61 .421 .6 r
.8822 .42854 .9106 .60302 .93639 .57809 .907 .40463 Mtetra
.585 .403 .602 r
.907 .40463 .93639 .57809 .96438 .57033 .93377 .39638 Mtetra
.662 .743 .91 r
.33838 .56034 .35201 .57288 .37394 .56611 .36042 .55346 Mtetra
.66 .742 .911 r
.36042 .55346 .37394 .56611 .39605 .55943 .38264 .54668 Mtetra
.659 .742 .911 r
.38264 .54668 .39605 .55943 .41834 .55273 .40505 .53987 Mtetra
.667 .744 .908 r
.40505 .53987 .41834 .55273 .44083 .54553 .42766 .53256 Mtetra
.662 .743 .91 r
.42766 .53256 .44083 .54553 .4635 .53853 .45045 .52545 Mtetra
.64 .737 .919 r
.45045 .52545 .4635 .53853 .48634 .53274 .47341 .51956 Mtetra
.654 .741 .913 r
.47341 .51956 .48634 .53274 .5094 .52611 .4966 .51282 Mtetra
.653 .74 .914 r
.4966 .51282 .5094 .52611 .53266 .5195 .51999 .50609 Mtetra
.692 .752 .897 r
.51999 .50609 .53266 .5195 .55611 .51026 .54357 .49673 Mtetra
.662 .743 .91 r
.54357 .49673 .55611 .51026 .57976 .50296 .56736 .48931 Mtetra
.585 .716 .933 r
.56736 .48931 .57976 .50296 .60371 .49976 .59143 .48601 Mtetra
.648 .739 .916 r
.59143 .48601 .60371 .49976 .62783 .49321 .61568 .47935 Mtetra
.646 .738 .916 r
.61568 .47935 .62783 .49321 .65217 .48668 .64016 .4727 Mtetra
.734 .765 .878 r
.64016 .4727 .65217 .48668 .67644 .47371 .6646 .45959 Mtetra
.662 .743 .91 r
.6646 .45959 .67644 .47371 .70114 .46609 .68945 .45184 Mtetra
.486 .668 .944 r
.68945 .45184 .70114 .46609 .72659 .46717 .71502 .45283 Mtetra
.641 .736 .918 r
.71502 .45283 .72659 .46717 .75188 .4607 .74047 .44623 Mtetra
.64 .736 .918 r
.74047 .44623 .75188 .4607 .77742 .45424 .76616 .43965 Mtetra
.784 .782 .851 r
.76616 .43965 .77742 .45424 .80219 .43578 .79113 .42103 Mtetra
.662 .743 .91 r
.79113 .42103 .80219 .43578 .82801 .42782 .81711 .41293 Mtetra
.339 .58 .931 r
.81711 .41293 .82801 .42782 .8556 .43495 .84483 .41998 Mtetra
.635 .734 .92 r
.84483 .41998 .8556 .43495 .8822 .42854 .8716 .41344 Mtetra
.825 .797 .825 r
.8716 .41344 .8822 .42854 .907 .40463 .89661 .38934 Mtetra
.662 .743 .91 r
.89661 .38934 .907 .40463 .93377 .39638 .92356 .38095 Mtetra
.521 .259 .458 r
.31829 .65287 .33838 .56034 .36042 .55346 .34111 .64612 Mtetra
.522 .259 .458 r
.34111 .64612 .36042 .55346 .38264 .54668 .36412 .63948 Mtetra
.36412 .63948 .38264 .54668 .40505 .53987 .38734 .63281 Mtetra
.52 .258 .457 r
.38734 .63281 .40505 .53987 .42766 .53256 .41077 .62561 Mtetra
.521 .259 .458 r
.41077 .62561 .42766 .53256 .45045 .52545 .4344 .61862 Mtetra
.526 .263 .459 r
.4344 .61862 .45045 .52545 .47341 .51956 .45821 .61294 Mtetra
.523 .26 .458 r
.45821 .61294 .47341 .51956 .4966 .51282 .48226 .60635 Mtetra
.523 .261 .458 r
.48226 .60635 .4966 .51282 .51999 .50609 .50653 .59979 Mtetra
.513 .252 .456 r
.50653 .59979 .51999 .50609 .54357 .49673 .53103 .59041 Mtetra
.521 .259 .458 r
.53103 .59041 .54357 .49673 .56736 .48931 .55573 .5831 Mtetra
.537 .272 .461 r
.55573 .5831 .56736 .48931 .59143 .48601 .58073 .58021 Mtetra
.525 .262 .459 r
.58073 .58021 .59143 .48601 .61568 .47935 .60593 .57372 Mtetra
.60593 .57372 .61568 .47935 .64016 .4727 .63138 .56726 Mtetra
.5 .241 .454 r
.63138 .56726 .64016 .4727 .6646 .45959 .65681 .55387 Mtetra
.521 .259 .458 r
.65681 .55387 .6646 .45959 .68945 .45184 .68266 .54623 Mtetra
.552 .284 .463 r
.68266 .54623 .68945 .45184 .71502 .45283 .70927 .54796 Mtetra
.526 .263 .459 r
.70927 .54796 .71502 .45283 .74047 .44623 .73576 .54157 Mtetra
.73576 .54157 .74047 .44623 .76616 .43965 .76253 .53519 Mtetra
.482 .228 .452 r
.76253 .53519 .76616 .43965 .79113 .42103 .78855 .5159 Mtetra
.521 .259 .458 r
.78855 .5159 .79113 .42103 .81711 .41293 .81564 .5079 Mtetra
.57 .298 .463 r
.81564 .5079 .81711 .41293 .84483 .41998 .84454 .51617 Mtetra
.527 .264 .459 r
.84454 .51617 .84483 .41998 .8716 .41344 .87247 .50986 Mtetra
.465 .216 .452 r
.87247 .50986 .8716 .41344 .89661 .38934 .89857 .48467 Mtetra
.521 .259 .458 r
.89857 .48467 .89661 .38934 .92356 .38095 .92671 .47637 Mtetra
.642 .603 .795 r
.30463 .62657 .31829 .65287 .34111 .64612 .32748 .61968 Mtetra
.64 .603 .796 r
.32748 .61968 .34111 .64612 .36412 .63948 .35053 .61289 Mtetra
.64 .602 .796 r
.35053 .61289 .36412 .63948 .38734 .63281 .37377 .60608 Mtetra
.645 .605 .794 r
.37377 .60608 .38734 .63281 .41077 .62561 .39724 .59873 Mtetra
.642 .603 .795 r
.39724 .59873 .41077 .62561 .4344 .61862 .42091 .5916 Mtetra
.628 .597 .799 r
.42091 .5916 .4344 .61862 .45821 .61294 .44475 .58576 Mtetra
.637 .601 .797 r
.44475 .58576 .45821 .61294 .48226 .60635 .46884 .57903 Mtetra
.636 .601 .797 r
.46884 .57903 .48226 .60635 .50653 .59979 .49315 .57231 Mtetra
.661 .613 .789 r
.49315 .57231 .50653 .59979 .53103 .59041 .51769 .56278 Mtetra
.642 .603 .795 r
.51769 .56278 .53103 .59041 .55573 .5831 .54244 .55532 Mtetra
.596 .581 .806 r
.54244 .55532 .55573 .5831 .58073 .58021 .56746 .55226 Mtetra
.633 .599 .798 r
.56746 .55226 .58073 .58021 .60593 .57372 .59271 .54561 Mtetra
.632 .599 .798 r
.59271 .54561 .60593 .57372 .63138 .56726 .6182 .53897 Mtetra
.69 .627 .78 r
.6182 .53897 .63138 .56726 .65681 .55387 .6437 .52545 Mtetra
.642 .603 .795 r
.6437 .52545 .65681 .55387 .68266 .54623 .6696 .51765 Mtetra
.541 .55 .814 r
.6696 .51765 .68266 .54623 .70927 .54796 .69622 .51917 Mtetra
.629 .597 .799 r
.69622 .51917 .70927 .54796 .73576 .54157 .72276 .51261 Mtetra
.628 .597 .799 r
.72276 .51261 .73576 .54157 .76253 .53519 .74958 .50605 Mtetra
.727 .645 .767 r
.74958 .50605 .76253 .53519 .78855 .5159 .7757 .48664 Mtetra
.642 .603 .795 r
.7757 .48664 .78855 .5159 .81564 .5079 .80284 .47847 Mtetra
.46 .503 .816 r
.80284 .47847 .81564 .5079 .84454 .51617 .83175 .48649 Mtetra
.625 .595 .8 r
.83175 .48649 .84454 .51617 .87247 .50986 .85973 .47999 Mtetra
.759 .661 .754 r
.85973 .47999 .87247 .50986 .89857 .48467 .88596 .45471 Mtetra
.642 .603 .795 r
.88596 .45471 .89857 .48467 .92671 .47637 .91416 .44622 Mtetra
.643 .609 .801 r
.29081 .60084 .30463 .62657 .32748 .61968 .3137 .59381 Mtetra
.641 .609 .801 r
.3137 .59381 .32748 .61968 .35053 .61289 .33678 .58688 Mtetra
.641 .608 .801 r
.33678 .58688 .35053 .61289 .37377 .60608 .36006 .57992 Mtetra
.646 .611 .8 r
.36006 .57992 .37377 .60608 .39724 .59873 .38358 .57243 Mtetra
.643 .609 .801 r
.38358 .57243 .39724 .59873 .42091 .5916 .40728 .56515 Mtetra
.629 .603 .805 r
.40728 .56515 .42091 .5916 .44475 .58576 .43116 .55916 Mtetra
.638 .607 .802 r
.43116 .55916 .44475 .58576 .46884 .57903 .45529 .55227 Mtetra
.637 .606 .802 r
.45529 .55227 .46884 .57903 .49315 .57231 .47964 .5454 Mtetra
.663 .619 .794 r
.47964 .5454 .49315 .57231 .51769 .56278 .50424 .53572 Mtetra
.643 .609 .801 r
.50424 .53572 .51769 .56278 .54244 .55532 .52903 .52811 Mtetra
.596 .586 .812 r
.52903 .52811 .54244 .55532 .56746 .55226 .55409 .52487 Mtetra
.634 .605 .803 r
.55409 .52487 .56746 .55226 .59271 .54561 .57938 .51806 Mtetra
.633 .605 .803 r
.57938 .51806 .59271 .54561 .6182 .53897 .60493 .51126 Mtetra
.692 .633 .785 r
.60493 .51126 .6182 .53897 .6437 .52545 .63051 .4976 Mtetra
.643 .609 .801 r
.63051 .4976 .6437 .52545 .6696 .51765 .65646 .48963 Mtetra
.539 .555 .82 r
.65646 .48963 .6696 .51765 .69622 .51917 .6831 .49095 Mtetra
.63 .603 .804 r
.6831 .49095 .69622 .51917 .72276 .51261 .7097 .48421 Mtetra
.629 .603 .804 r
.7097 .48421 .72276 .51261 .74958 .50605 .73657 .47748 Mtetra
.729 .651 .771 r
.73657 .47748 .74958 .50605 .7757 .48664 .7628 .45794 Mtetra
.643 .609 .801 r
.7628 .45794 .7757 .48664 .80284 .47847 .79 .4496 Mtetra
.455 .506 .822 r
.79 .4496 .80284 .47847 .83175 .48649 .81892 .45737 Mtetra
.626 .601 .805 r
.81892 .45737 .83175 .48649 .85973 .47999 .84696 .45069 Mtetra
.762 .667 .757 r
.84696 .45069 .85973 .47999 .88596 .45471 .87331 .4253 Mtetra
.643 .609 .801 r
.87331 .4253 .88596 .45471 .91416 .44622 .90159 .41663 Mtetra
.588 .422 .624 r
.28235 .49978 .29081 .60084 .3137 .59381 .30479 .49245 Mtetra
.587 .421 .624 r
.30479 .49245 .3137 .59381 .33678 .58688 .32742 .4852 Mtetra
.32742 .4852 .33678 .58688 .36006 .57992 .35024 .47793 Mtetra
.588 .422 .624 r
.35024 .47793 .36006 .57992 .38358 .57243 .37328 .47014 Mtetra
.37328 .47014 .38358 .57243 .40728 .56515 .3965 .46255 Mtetra
.583 .418 .624 r
.3965 .46255 .40728 .56515 .43116 .55916 .41989 .45618 Mtetra
.586 .42 .624 r
.41989 .45618 .43116 .55916 .45529 .55227 .44352 .44895 Mtetra
.44352 .44895 .45529 .55227 .47964 .5454 .46737 .44174 Mtetra
.594 .426 .624 r
.46737 .44174 .47964 .5454 .50424 .53572 .49146 .43185 Mtetra
.588 .422 .624 r
.49146 .43185 .50424 .53572 .52903 .52811 .51573 .42392 Mtetra
.574 .412 .624 r
.51573 .42392 .52903 .52811 .55409 .52487 .54024 .42014 Mtetra
.585 .419 .624 r
.54024 .42014 .55409 .52487 .57938 .51806 .56498 .41296 Mtetra
.584 .419 .624 r
.56498 .41296 .57938 .51806 .60493 .51126 .58997 .40579 Mtetra
.604 .433 .623 r
.58997 .40579 .60493 .51126 .63051 .4976 .61502 .39209 Mtetra
.588 .421 .624 r
.61502 .39209 .63051 .4976 .65646 .48963 .64041 .38379 Mtetra
.56 .402 .624 r
.64041 .38379 .65646 .48963 .6831 .49095 .66642 .38431 Mtetra
.584 .419 .624 r
.66642 .38431 .6831 .49095 .7097 .48421 .69241 .37717 Mtetra
.583 .418 .624 r
.69241 .37717 .7097 .48421 .73657 .47748 .71867 .37003 Mtetra
.617 .442 .622 r
.71867 .37003 .73657 .47748 .7628 .45794 .74436 .35073 Mtetra
.588 .421 .624 r
.74436 .35073 .7628 .45794 .79 .4496 .77094 .34206 Mtetra
.54 .389 .625 r
.77094 .34206 .79 .4496 .81892 .45737 .7991 .34865 Mtetra
.582 .418 .624 r
.7991 .34865 .81892 .45737 .84696 .45069 .82649 .34153 Mtetra
.63 .449 .62 r
.82649 .34153 .84696 .45069 .87331 .4253 .85232 .31668 Mtetra
.587 .421 .624 r
.85232 .31668 .87331 .4253 .90159 .41663 .87993 .30767 Mtetra
.663 .742 .909 r
.26767 .48619 .28235 .49978 .30479 .49245 .29022 .47874 Mtetra
.66 .742 .91 r
.29022 .47874 .30479 .49245 .32742 .4852 .31297 .47138 Mtetra
.66 .741 .91 r
.31297 .47138 .32742 .4852 .35024 .47793 .33591 .46399 Mtetra
.667 .743 .907 r
.33591 .46399 .35024 .47793 .37328 .47014 .35907 .45608 Mtetra
.663 .742 .909 r
.35907 .45608 .37328 .47014 .3965 .46255 .38242 .44836 Mtetra
.641 .736 .918 r
.38242 .44836 .3965 .46255 .41989 .45618 .40593 .44188 Mtetra
.655 .74 .912 r
.40593 .44188 .41989 .45618 .44352 .44895 .42969 .43452 Mtetra
.653 .74 .913 r
.42969 .43452 .44352 .44895 .46737 .44174 .45367 .42718 Mtetra
.693 .751 .896 r
.45367 .42718 .46737 .44174 .49146 .43185 .47791 .41716 Mtetra
.663 .742 .909 r
.47791 .41716 .49146 .43185 .51573 .42392 .50232 .4091 Mtetra
.587 .715 .932 r
.50232 .4091 .51573 .42392 .54024 .42014 .52695 .4052 Mtetra
.648 .738 .915 r
.52695 .4052 .54024 .42014 .56498 .41296 .55184 .39788 Mtetra
.647 .738 .915 r
.55184 .39788 .56498 .41296 .58997 .40579 .57698 .39058 Mtetra
.734 .764 .877 r
.57698 .39058 .58997 .40579 .61502 .39209 .6022 .37672 Mtetra
.663 .742 .909 r
.6022 .37672 .61502 .39209 .64041 .38379 .62774 .36829 Mtetra
.488 .668 .943 r
.62774 .36829 .64041 .38379 .66642 .38431 .65388 .3687 Mtetra
.642 .736 .917 r
.65388 .3687 .66642 .38431 .69241 .37717 .68003 .36141 Mtetra
.641 .735 .917 r
.68003 .36141 .69241 .37717 .71867 .37003 .70645 .35413 Mtetra
.784 .781 .85 r
.70645 .35413 .71867 .37003 .74436 .35073 .73235 .33465 Mtetra
.663 .742 .909 r
.73235 .33465 .74436 .35073 .77094 .34206 .75911 .32582 Mtetra
.342 .581 .931 r
.75911 .32582 .77094 .34206 .7991 .34865 .7874 .33232 Mtetra
.636 .733 .919 r
.7874 .33232 .7991 .34865 .82649 .34153 .81496 .32505 Mtetra
.825 .796 .824 r
.81496 .32505 .82649 .34153 .85232 .31668 .84103 .29998 Mtetra
.663 .743 .909 r
.84103 .29998 .85232 .31668 .87993 .30767 .86882 .29082 Mtetra
.424 .084 .283 r
.24824 .52698 .26767 .48619 .29022 .47874 .27127 .51953 Mtetra
.426 .086 .284 r
.27127 .51953 .29022 .47874 .31297 .47138 .2945 .51216 Mtetra
.426 .087 .284 r
.2945 .51216 .31297 .47138 .33591 .46399 .31793 .50477 Mtetra
.421 .081 .282 r
.31793 .50477 .33591 .46399 .35907 .45608 .34159 .49684 Mtetra
.424 .084 .283 r
.34159 .49684 .35907 .45608 .38242 .44836 .36546 .48912 Mtetra
.439 .099 .29 r
.36546 .48912 .38242 .44836 .40593 .44188 .38948 .48266 Mtetra
.43 .09 .286 r
.38948 .48266 .40593 .44188 .42969 .43452 .41377 .47532 Mtetra
.431 .091 .287 r
.41377 .47532 .42969 .43452 .45367 .42718 .43829 .46798 Mtetra
.4 .062 .273 r
.43829 .46798 .45367 .42718 .47791 .41716 .46308 .45786 Mtetra
.424 .084 .283 r
.46308 .45786 .47791 .41716 .50232 .4091 .48806 .44977 Mtetra
.468 .126 .302 r
.48806 .44977 .50232 .4091 .52695 .4052 .51324 .44602 Mtetra
.434 .094 .288 r
.51324 .44602 .52695 .4052 .55184 .39788 .53872 .43872 Mtetra
.435 .095 .288 r
.53872 .43872 .55184 .39788 .57698 .39058 .56444 .43142 Mtetra
.362 .03 .261 r
.56444 .43142 .57698 .39058 .6022 .37672 .59029 .41732 Mtetra
.424 .085 .283 r
.59029 .41732 .6022 .37672 .62774 .36829 .61645 .40885 Mtetra
.507 .159 .312 r
.61645 .40885 .62774 .36829 .65388 .3687 .6432 .40958 Mtetra
.438 .098 .289 r
.6432 .40958 .65388 .3687 .68003 .36141 .67 .40231 Mtetra
.439 .098 .29 r
.67 .40231 .68003 .36141 .70645 .35413 .69708 .39505 Mtetra
.309 0 .248 r
.69708 .39505 .70645 .35413 .73235 .33465 .72366 .3751 Mtetra
.424 .085 .284 r
.72366 .3751 .73235 .33465 .75911 .32582 .7511 .36622 Mtetra
.55 .194 .317 r
.7511 .36622 .75911 .32582 .7874 .33232 .78009 .3733 Mtetra
.442 .101 .29 r
.78009 .3733 .7874 .33232 .81496 .32505 .80837 .36605 Mtetra
.261 0 .243 r
.80837 .36605 .81496 .32505 .84103 .29998 .83515 .34029 Mtetra
.424 .085 .284 r
.83515 .34029 .84103 .29998 .86882 .29082 .86369 .33106 Mtetra
.648 .635 .823 r
.23365 .50345 .24824 .52698 .27127 .51953 .25674 .49585 Mtetra
.646 .634 .824 r
.25674 .49585 .27127 .51953 .2945 .51216 .28002 .48834 Mtetra
.28002 .48834 .2945 .51216 .31793 .50477 .3035 .4808 Mtetra
.651 .636 .822 r
.3035 .4808 .31793 .50477 .34159 .49684 .32724 .47272 Mtetra
.648 .635 .823 r
.32724 .47272 .34159 .49684 .36546 .48912 .35116 .46485 Mtetra
.633 .629 .828 r
.35116 .46485 .36546 .48912 .38948 .48266 .37524 .45824 Mtetra
.642 .633 .825 r
.37524 .45824 .38948 .48266 .41377 .47532 .3996 .45073 Mtetra
.641 .632 .826 r
.3996 .45073 .41377 .47532 .43829 .46798 .42418 .44324 Mtetra
.67 .645 .816 r
.42418 .44324 .43829 .46798 .46308 .45786 .44906 .43297 Mtetra
.648 .635 .823 r
.44906 .43297 .46308 .45786 .48806 .44977 .4741 .42473 Mtetra
.596 .611 .837 r
.4741 .42473 .48806 .44977 .51324 .44602 .49934 .4208 Mtetra
.638 .631 .827 r
.49934 .4208 .51324 .44602 .53872 .43872 .52489 .41333 Mtetra
.637 .63 .827 r
.52489 .41333 .53872 .43872 .56444 .43142 .55069 .40587 Mtetra
.702 .659 .805 r
.55069 .40587 .56444 .43142 .59029 .41732 .57664 .39161 Mtetra
.648 .635 .823 r
.57664 .39161 .59029 .41732 .61645 .40885 .60288 .38298 Mtetra
.531 .577 .846 r
.60288 .38298 .61645 .40885 .6432 .40958 .62968 .38351 Mtetra
.633 .629 .828 r
.62968 .38351 .6432 .40958 .67 .40231 .65656 .37607 Mtetra
.633 .628 .828 r
.65656 .37607 .67 .40231 .69708 .39505 .68372 .36863 Mtetra
.742 .677 .788 r
.68372 .36863 .69708 .39505 .72366 .3751 .71044 .34852 Mtetra
.648 .635 .824 r
.71044 .34852 .72366 .3751 .7511 .36622 .73797 .33947 Mtetra
.436 .521 .847 r
.73797 .33947 .7511 .36622 .78009 .3733 .767 .34632 Mtetra
.629 .627 .829 r
.767 .34632 .78009 .3733 .80837 .36605 .79537 .33888 Mtetra
.776 .694 .772 r
.79537 .33888 .80837 .36605 .83515 .34029 .82231 .31298 Mtetra
.648 .635 .824 r
.82231 .31298 .83515 .34029 .86369 .33106 .85095 .30356 Mtetra
.649 .642 .83 r
.21883 .48044 .23365 .50345 .25674 .49585 .24198 .47269 Mtetra
.648 .642 .83 r
.24198 .47269 .25674 .49585 .28002 .48834 .26532 .46504 Mtetra
.647 .641 .83 r
.26532 .46504 .28002 .48834 .3035 .4808 .28887 .45735 Mtetra
.653 .644 .828 r
.28887 .45735 .3035 .4808 .32724 .47272 .31267 .44912 Mtetra
.649 .642 .83 r
.31267 .44912 .32724 .47272 .35116 .46485 .33667 .4411 Mtetra
.634 .636 .835 r
.33667 .4411 .35116 .46485 .37524 .45824 .36081 .43433 Mtetra
.644 .64 .832 r
.36081 .43433 .37524 .45824 .3996 .45073 .38523 .42667 Mtetra
.643 .639 .832 r
.38523 .42667 .3996 .45073 .42418 .44324 .40989 .41902 Mtetra
.672 .652 .822 r
.40989 .41902 .42418 .44324 .44906 .43297 .43485 .40859 Mtetra
.649 .642 .83 r
.43485 .40859 .44906 .43297 .4741 .42473 .45997 .40019 Mtetra
.595 .618 .844 r
.45997 .40019 .4741 .42473 .49934 .4208 .48528 .39609 Mtetra
.639 .638 .833 r
.48528 .39609 .49934 .4208 .52489 .41333 .5109 .38846 Mtetra
.638 .637 .833 r
.5109 .38846 .52489 .41333 .55069 .40587 .53678 .38083 Mtetra
.704 .666 .81 r
.53678 .38083 .55069 .40587 .57664 .39161 .56284 .36641 Mtetra
.649 .642 .83 r
.56284 .36641 .57664 .39161 .60288 .38298 .58918 .35761 Mtetra
.529 .583 .853 r
.58918 .35761 .60288 .38298 .62968 .38351 .61602 .35795 Mtetra
.634 .636 .834 r
.61602 .35795 .62968 .38351 .65656 .37607 .64299 .35033 Mtetra
.633 .635 .834 r
.64299 .35033 .65656 .37607 .68372 .36863 .67025 .34271 Mtetra
.745 .684 .793 r
.67025 .34271 .68372 .36863 .71044 .34852 .69711 .32245 Mtetra
.649 .642 .83 r
.69711 .32245 .71044 .34852 .73797 .33947 .72474 .31321 Mtetra
.431 .525 .854 r
.72474 .31321 .73797 .33947 .767 .34632 .75381 .31984 Mtetra
.63 .634 .835 r
.75381 .31984 .767 .34632 .79537 .33888 .78229 .31222 Mtetra
.78 .701 .776 r
.78229 .31222 .79537 .33888 .82231 .31298 .8094 .28616 Mtetra
.649 .642 .83 r
.8094 .28616 .82231 .31298 .85095 .30356 .83815 .27656 Mtetra
.604 .478 .681 r
.20712 .42372 .21883 .48044 .24198 .47269 .23011 .41576 Mtetra
.603 .477 .681 r
.23011 .41576 .24198 .47269 .26532 .46504 .25329 .40789 Mtetra
.25329 .40789 .26532 .46504 .28887 .45735 .27667 .39998 Mtetra
.606 .479 .681 r
.27667 .39998 .28887 .45735 .31267 .44912 .3003 .39154 Mtetra
.604 .478 .681 r
.3003 .39154 .31267 .44912 .33667 .4411 .32412 .38329 Mtetra
.596 .473 .682 r
.32412 .38329 .33667 .4411 .36081 .43433 .34809 .37627 Mtetra
.601 .476 .681 r
.34809 .37627 .36081 .43433 .38523 .42667 .37233 .36838 Mtetra
.601 .475 .681 r
.37233 .36838 .38523 .42667 .40989 .41902 .3968 .36049 Mtetra
.615 .485 .68 r
.3968 .36049 .40989 .41902 .43485 .40859 .42159 .34988 Mtetra
.604 .478 .681 r
.42159 .34988 .43485 .40859 .45997 .40019 .44653 .34125 Mtetra
.579 .461 .683 r
.44653 .34125 .45997 .40019 .48528 .39609 .47162 .33681 Mtetra
.599 .474 .682 r
.47162 .33681 .48528 .39609 .5109 .38846 .49705 .32892 Mtetra
.598 .474 .682 r
.49705 .32892 .5109 .38846 .53678 .38083 .52274 .32103 Mtetra
.633 .496 .678 r
.52274 .32103 .53678 .38083 .56284 .36641 .54863 .30652 Mtetra
.604 .478 .681 r
.54863 .30652 .56284 .36641 .58918 .35761 .57476 .29747 Mtetra
.551 .444 .685 r
.57476 .29747 .58918 .35761 .61602 .35795 .60136 .29735 Mtetra
.597 .473 .682 r
.60136 .29735 .61602 .35795 .64299 .35033 .62811 .28945 Mtetra
.596 .473 .682 r
.62811 .28945 .64299 .35033 .67025 .34271 .65515 .28155 Mtetra
.656 .51 .674 r
.65515 .28155 .67025 .34271 .69711 .32245 .68185 .26132 Mtetra
.604 .478 .681 r
.68185 .26132 .69711 .32245 .72474 .31321 .70927 .25183 Mtetra
.512 .419 .687 r
.70927 .25183 .72474 .31321 .75381 .31984 .73803 .25781 Mtetra
.595 .472 .682 r
.73803 .25781 .75381 .31984 .78229 .31222 .76627 .24989 Mtetra
.677 .523 .669 r
.76627 .24989 .78229 .31222 .8094 .28616 .79324 .22399 Mtetra
.604 .478 .681 r
.79324 .22399 .8094 .28616 .83815 .27656 .82176 .21413 Mtetra
.663 .742 .908 r
.19125 .40898 .20712 .42372 .23011 .41576 .21435 .40089 Mtetra
.661 .741 .909 r
.21435 .40089 .23011 .41576 .25329 .40789 .23765 .39288 Mtetra
.66 .741 .91 r
.23765 .39288 .25329 .40789 .27667 .39998 .26116 .38483 Mtetra
.668 .743 .907 r
.26116 .38483 .27667 .39998 .3003 .39154 .28492 .37625 Mtetra
.663 .742 .908 r
.28492 .37625 .3003 .39154 .32412 .38329 .30887 .36787 Mtetra
.642 .735 .917 r
.30887 .36787 .32412 .38329 .34809 .37627 .33296 .36072 Mtetra
.655 .739 .912 r
.33296 .36072 .34809 .37627 .37233 .36838 .35734 .35268 Mtetra
.654 .739 .912 r
.35734 .35268 .37233 .36838 .3968 .36049 .38195 .34464 Mtetra
.693 .75 .896 r
.38195 .34464 .3968 .36049 .42159 .34988 .40689 .33388 Mtetra
.663 .742 .908 r
.40689 .33388 .42159 .34988 .44653 .34125 .43197 .3251 Mtetra
.587 .715 .931 r
.43197 .3251 .44653 .34125 .47162 .33681 .4572 .32053 Mtetra
.649 .737 .914 r
.4572 .32053 .47162 .33681 .49705 .32892 .48277 .31249 Mtetra
.648 .737 .914 r
.48277 .31249 .49705 .32892 .52274 .32103 .50861 .30445 Mtetra
.734 .763 .876 r
.50861 .30445 .52274 .32103 .54863 .30652 .53468 .28976 Mtetra
.663 .742 .908 r
.53468 .28976 .54863 .30652 .57476 .29747 .56098 .28055 Mtetra
.49 .668 .942 r
.56098 .28055 .57476 .29747 .60136 .29735 .58771 .2803 Mtetra
.643 .735 .916 r
.58771 .2803 .60136 .29735 .62811 .28945 .61463 .27224 Mtetra
.641 .735 .916 r
.61463 .27224 .62811 .28945 .65515 .28155 .64184 .26418 Mtetra
.784 .78 .849 r
.64184 .26418 .65515 .28155 .68185 .26132 .66876 .24374 Mtetra
.663 .742 .909 r
.66876 .24374 .68185 .26132 .70927 .25183 .69636 .23408 Mtetra
.345 .582 .931 r
.69636 .23408 .70927 .25183 .73803 .25781 .72526 .23994 Mtetra
.636 .733 .918 r
.72526 .23994 .73803 .25781 .76627 .24989 .75368 .23184 Mtetra
.825 .795 .824 r
.75368 .23184 .76627 .24989 .79324 .22399 .78091 .20571 Mtetra
.663 .742 .909 r
.78091 .20571 .79324 .22399 .82176 .21413 .80963 .19567 Mtetra
.277 .772 .718 r
.17288 .41449 .19125 .40898 .21435 .40089 .19624 .40631 Mtetra
.268 .765 .713 r
.19624 .40631 .21435 .40089 .23765 .39288 .2198 .39821 Mtetra
.266 .764 .712 r
.2198 .39821 .23765 .39288 .26116 .38483 .24358 .39007 Mtetra
.293 .782 .725 r
.24358 .39007 .26116 .38483 .28492 .37625 .26761 .38138 Mtetra
.277 .772 .718 r
.26761 .38138 .28492 .37625 .30887 .36787 .29185 .37289 Mtetra
.203 .719 .679 r
.29185 .37289 .30887 .36787 .33296 .36072 .31622 .36566 Mtetra
.248 .751 .703 r
.31622 .36566 .33296 .36072 .35734 .35268 .34088 .35752 Mtetra
.244 .748 .701 r
.34088 .35752 .35734 .35268 .38195 .34464 .36579 .34939 Mtetra
.381 .838 .761 r
.36579 .34939 .38195 .34464 .40689 .33388 .39105 .33848 Mtetra
.277 .771 .717 r
.39105 .33848 .40689 .33388 .43197 .3251 .41644 .32959 Mtetra
0 0 0 r
.41644 .32959 .43197 .3251 .4572 .32053 .44196 .32498 Mtetra
.228 .737 .693 r
.44196 .32498 .4572 .32053 .48277 .31249 .46786 .31683 Mtetra
.224 .734 .691 r
.46786 .31683 .48277 .31249 .50861 .30445 .49402 .30869 Mtetra
.516 .91 .793 r
.49402 .30869 .50861 .30445 .53468 .28976 .52046 .29377 Mtetra
.276 .771 .717 r
.52046 .29377 .53468 .28976 .56098 .28055 .54711 .28445 Mtetra
.137 0 0 r
.54711 .28445 .56098 .28055 .58771 .2803 .57415 .28422 Mtetra
.209 .724 .685 r
.57415 .28422 .58771 .2803 .61463 .27224 .60143 .27605 Mtetra
.205 .721 .683 r
.60143 .27605 .61463 .27224 .64184 .26418 .62901 .26788 Mtetra
.653 .964 .789 r
.62901 .26788 .64184 .26418 .66876 .24374 .65634 .24712 Mtetra
.276 .77 .716 r
.65634 .24712 .66876 .24374 .69636 .23408 .68433 .23732 Mtetra
.319 0 0 r
.68433 .23732 .69636 .23408 .72526 .23994 .71358 .24331 Mtetra
0 0 0 r
.71358 .24331 .72526 .23994 .75368 .23184 .7424 .2351 Mtetra
.737 .981 .753 r
.7424 .2351 .75368 .23184 .78091 .20571 .77008 .20854 Mtetra
.274 .769 .715 r
.77008 .20854 .78091 .20571 .80963 .19567 .79922 .19834 Mtetra
.655 .673 .855 r
.15701 .39352 .17288 .41449 .19624 .40631 .18045 .38519 Mtetra
.653 .672 .856 r
.18045 .38519 .19624 .40631 .2198 .39821 .2041 .37693 Mtetra
.652 .672 .856 r
.2041 .37693 .2198 .39821 .24358 .39007 .22796 .36864 Mtetra
.658 .674 .854 r
.22796 .36864 .24358 .39007 .26761 .38138 .25209 .3598 Mtetra
.655 .673 .855 r
.25209 .3598 .26761 .38138 .29185 .37289 .27641 .35115 Mtetra
.637 .667 .862 r
.27641 .35115 .29185 .37289 .31622 .36566 .30087 .34376 Mtetra
.648 .671 .858 r
.30087 .34376 .31622 .36566 .34088 .35752 .32563 .33546 Mtetra
.647 .67 .858 r
.32563 .33546 .34088 .35752 .36579 .34939 .35063 .32716 Mtetra
.679 .682 .846 r
.35063 .32716 .36579 .34939 .39105 .33848 .376 .31609 Mtetra
.655 .673 .855 r
.376 .31609 .39105 .33848 .41644 .32959 .4015 .30703 Mtetra
.594 .648 .873 r
.4015 .30703 .41644 .32959 .44196 .32498 .4271 .30224 Mtetra
.643 .669 .86 r
.4271 .30224 .44196 .32498 .46786 .31683 .45311 .29393 Mtetra
.642 .668 .86 r
.45311 .29393 .46786 .31683 .49402 .30869 .47938 .2856 Mtetra
.714 .697 .832 r
.47938 .2856 .49402 .30869 .52046 .29377 .50596 .27052 Mtetra
.655 .673 .855 r
.50596 .27052 .52046 .29377 .54711 .28445 .53272 .26101 Mtetra
.519 .61 .883 r
.53272 .26101 .54711 .28445 .57415 .28422 .55984 .2606 Mtetra
.638 .667 .861 r
.55984 .2606 .57415 .28422 .60143 .27605 .58724 .25224 Mtetra
.637 .666 .861 r
.58724 .25224 .60143 .27605 .62901 .26788 .61494 .24388 Mtetra
.758 .715 .812 r
.61494 .24388 .62901 .26788 .65634 .24712 .64246 .22294 Mtetra
.655 .673 .856 r
.64246 .22294 .65634 .24712 .68433 .23732 .67058 .21295 Mtetra
.406 .544 .881 r
.67058 .21295 .68433 .23732 .71358 .24331 .69989 .21873 Mtetra
.633 .664 .862 r
.69989 .21873 .71358 .24331 .7424 .2351 .72886 .21032 Mtetra
.795 .731 .792 r
.72886 .21032 .7424 .2351 .77008 .20854 .75674 .18357 Mtetra
.655 .673 .856 r
.75674 .18357 .77008 .20854 .79922 .19834 .78603 .17317 Mtetra
.656 .682 .862 r
.14084 .37304 .15701 .39352 .18045 .38519 .16437 .36456 Mtetra
.654 .681 .863 r
.16437 .36456 .18045 .38519 .2041 .37693 .1881 .35615 Mtetra
.1881 .35615 .2041 .37693 .22796 .36864 .21206 .3477 Mtetra
.66 .683 .861 r
.21206 .3477 .22796 .36864 .25209 .3598 .23628 .3387 Mtetra
.656 .682 .862 r
.23628 .3387 .25209 .3598 .27641 .35115 .2607 .32989 Mtetra
.638 .675 .869 r
.2607 .32989 .27641 .35115 .30087 .34376 .28525 .32234 Mtetra
.649 .679 .865 r
.28525 .32234 .30087 .34376 .32563 .33546 .31011 .31388 Mtetra
.648 .679 .865 r
.31011 .31388 .32563 .33546 .35063 .32716 .33521 .30541 Mtetra
.681 .691 .852 r
.33521 .30541 .35063 .32716 .376 .31609 .3607 .29417 Mtetra
.656 .682 .862 r
.3607 .29417 .376 .31609 .4015 .30703 .38631 .28494 Mtetra
.594 .656 .881 r
.38631 .28494 .4015 .30703 .4271 .30224 .41201 .27998 Mtetra
.644 .677 .867 r
.41201 .27998 .4271 .30224 .45311 .29393 .43812 .27149 Mtetra
.643 .677 .867 r
.43812 .27149 .45311 .29393 .47938 .2856 .46451 .26299 Mtetra
.717 .705 .837 r
.46451 .26299 .47938 .2856 .50596 .27052 .49124 .24772 Mtetra
.656 .682 .862 r
.49124 .24772 .50596 .27052 .53272 .26101 .51812 .23803 Mtetra
.516 .617 .891 r
.51812 .23803 .53272 .26101 .55984 .2606 .54534 .23743 Mtetra
.639 .675 .868 r
.54534 .23743 .55984 .2606 .58724 .25224 .57286 .22889 Mtetra
.638 .675 .868 r
.57286 .22889 .58724 .25224 .61494 .24388 .60069 .22034 Mtetra
.762 .723 .817 r
.60069 .22034 .61494 .24388 .64246 .22294 .62839 .19921 Mtetra
.656 .682 .862 r
.62839 .19921 .64246 .22294 .67058 .21295 .65665 .18902 Mtetra
.399 .549 .888 r
.65665 .18902 .67058 .21295 .69989 .21873 .68605 .1946 Mtetra
.634 .673 .87 r
.68605 .1946 .69989 .21873 .72886 .21032 .71516 .18598 Mtetra
.799 .739 .797 r
.71516 .18598 .72886 .21032 .75674 .18357 .74327 .15904 Mtetra
.656 .682 .862 r
.74327 .15904 .75674 .18357 .78603 .17317 .77271 .14844 Mtetra
.641 .607 .8 r
.12546 .34416 .14084 .37304 .16437 .36456 .14903 .3355 Mtetra
.639 .606 .8 r
.14903 .3355 .16437 .36456 .1881 .35615 .17279 .32692 Mtetra
.17279 .32692 .1881 .35615 .21206 .3477 .19678 .31829 Mtetra
.643 .608 .799 r
.19678 .31829 .21206 .3477 .23628 .3387 .22104 .30912 Mtetra
.641 .607 .8 r
.22104 .30912 .23628 .3387 .2607 .32989 .2455 .30014 Mtetra
.626 .6 .804 r
.2455 .30014 .2607 .32989 .28525 .32234 .27008 .29239 Mtetra
.635 .604 .801 r
.27008 .29239 .28525 .32234 .31011 .31388 .29498 .28375 Mtetra
.634 .604 .802 r
.29498 .28375 .31011 .31388 .33521 .30541 .32012 .27509 Mtetra
.661 .616 .794 r
.32012 .27509 .33521 .30541 .3607 .29417 .34566 .26367 Mtetra
.641 .607 .8 r
.34566 .26367 .3607 .29417 .38631 .28494 .37131 .25425 Mtetra
.593 .583 .811 r
.37131 .25425 .38631 .28494 .41201 .27998 .39703 .24908 Mtetra
.631 .602 .802 r
.39703 .24908 .41201 .27998 .43812 .27149 .42319 .24039 Mtetra
.63 .602 .803 r
.42319 .24039 .43812 .27149 .46451 .26299 .44962 .23169 Mtetra
.69 .631 .784 r
.44962 .23169 .46451 .26299 .49124 .24772 .47643 .21626 Mtetra
.641 .607 .8 r
.47643 .21626 .49124 .24772 .51812 .23803 .50337 .20637 Mtetra
.534 .551 .819 r
.50337 .20637 .51812 .23803 .54534 .23743 .53059 .20551 Mtetra
.627 .6 .803 r
.53059 .20551 .54534 .23743 .57286 .22889 .55817 .19676 Mtetra
.626 .6 .804 r
.55817 .19676 .57286 .22889 .60069 .22034 .58605 .18798 Mtetra
.728 .649 .77 r
.58605 .18798 .60069 .22034 .62839 .19921 .61386 .1667 Mtetra
.641 .607 .8 r
.61386 .1667 .62839 .19921 .65665 .18902 .64219 .15631 Mtetra
.45 .501 .82 r
.64219 .15631 .65665 .18902 .68605 .1946 .67158 .16157 Mtetra
.623 .598 .804 r
.67158 .16157 .68605 .1946 .71516 .18598 .70074 .15272 Mtetra
.761 .666 .756 r
.70074 .15272 .71516 .18598 .74327 .15904 .72899 .12566 Mtetra
.64 .607 .8 r
.72899 .12566 .74327 .15904 .77271 .14844 .75851 .11483 Mtetra
.663 .741 .908 r
.10823 .32811 .12546 .34416 .14903 .3355 .13191 .31931 Mtetra
.661 .741 .909 r
.13191 .31931 .14903 .3355 .17279 .32692 .1558 .31057 Mtetra
.66 .741 .909 r
.1558 .31057 .17279 .32692 .19678 .31829 .17992 .3018 Mtetra
.668 .743 .906 r
.17992 .3018 .19678 .31829 .22104 .30912 .20431 .29247 Mtetra
.663 .741 .908 r
.20431 .29247 .22104 .30912 .2455 .30014 .2289 .28333 Mtetra
.642 .735 .916 r
.2289 .28333 .2455 .30014 .27008 .29239 .25362 .27543 Mtetra
.655 .739 .911 r
.25362 .27543 .27008 .29239 .29498 .28375 .27865 .26662 Mtetra
.654 .739 .912 r
.27865 .26662 .29498 .28375 .32012 .27509 .30393 .2578 Mtetra
.693 .75 .895 r
.30393 .2578 .32012 .27509 .34566 .26367 .32964 .24621 Mtetra
.663 .741 .908 r
.32964 .24621 .34566 .26367 .37131 .25425 .35544 .23662 Mtetra
.588 .715 .931 r
.35544 .23662 .37131 .25425 .39703 .24908 .3813 .23129 Mtetra
.649 .737 .914 r
.3813 .23129 .39703 .24908 .42319 .24039 .40761 .22243 Mtetra
.648 .737 .914 r
.40761 .22243 .42319 .24039 .44962 .23169 .4342 .21355 Mtetra
.734 .763 .876 r
.4342 .21355 .44962 .23169 .47643 .21626 .46121 .19792 Mtetra
.663 .741 .908 r
.46121 .19792 .47643 .21626 .50337 .20637 .48832 .18785 Mtetra
.491 .668 .942 r
.48832 .18785 .50337 .20637 .53059 .20551 .51567 .18684 Mtetra
.643 .735 .916 r
.51567 .18684 .53059 .20551 .55817 .19676 .54342 .1779 Mtetra
.642 .734 .916 r
.54342 .1779 .55817 .19676 .58605 .18798 .57148 .16894 Mtetra
.784 .78 .849 r
.57148 .16894 .58605 .18798 .61386 .1667 .59954 .14743 Mtetra
.663 .742 .908 r
.59954 .14743 .61386 .1667 .64219 .15631 .62806 .13684 Mtetra
.346 .582 .931 r
.62806 .13684 .64219 .15631 .67158 .16157 .65757 .14194 Mtetra
.637 .732 .917 r
.65757 .14194 .67158 .16157 .70074 .15272 .68694 .1329 Mtetra
.824 .794 .824 r
.68694 .1329 .70074 .15272 .72899 .12566 .71547 .10559 Mtetra
.663 .742 .908 r
.71547 .10559 .72899 .12566 .75851 .11483 .7452 .09455 Mtetra
.664 .778 .934 r
.09031 .31453 .10823 .32811 .13191 .31931 .11414 .30557 Mtetra
.661 .778 .935 r
.11414 .30557 .13191 .31931 .1558 .31057 .13818 .29669 Mtetra
.661 .778 .936 r
.13818 .29669 .1558 .31057 .17992 .3018 .16244 .28776 Mtetra
.669 .78 .932 r
.16244 .28776 .17992 .3018 .20431 .29247 .18698 .27828 Mtetra
.664 .778 .934 r
.18698 .27828 .20431 .29247 .2289 .28333 .21173 .26898 Mtetra
.64 .772 .943 r
.21173 .26898 .2289 .28333 .25362 .27543 .2366 .26093 Mtetra
.655 .776 .938 r
.2366 .26093 .25362 .27543 .27865 .26662 .2618 .25196 Mtetra
.654 .776 .938 r
.2618 .25196 .27865 .26662 .30393 .2578 .28724 .24298 Mtetra
.697 .787 .92 r
.28724 .24298 .30393 .2578 .32964 .24621 .31313 .23121 Mtetra
.664 .779 .934 r
.31313 .23121 .32964 .24621 .35544 .23662 .33911 .22145 Mtetra
.578 .75 .959 r
.33911 .22145 .35544 .23662 .3813 .23129 .36512 .21597 Mtetra
.648 .774 .94 r
.36512 .21597 .3813 .23129 .40761 .22243 .39162 .20694 Mtetra
.647 .774 .941 r
.39162 .20694 .40761 .22243 .4342 .21355 .41839 .19789 Mtetra
.742 .799 .898 r
.41839 .19789 .4342 .21355 .46121 .19792 .44563 .18205 Mtetra
.664 .779 .934 r
.44563 .18205 .46121 .19792 .48832 .18785 .47293 .1718 Mtetra
.467 .697 .968 r
.47293 .1718 .48832 .18785 .51567 .18684 .50044 .17064 Mtetra
.641 .772 .943 r
.50044 .17064 .51567 .18684 .54342 .1779 .5284 .16152 Mtetra
.639 .771 .943 r
.5284 .16152 .54342 .1779 .57148 .16894 .55666 .15238 Mtetra
.795 .815 .868 r
.55666 .15238 .57148 .16894 .59954 .14743 .585 .13062 Mtetra
.664 .779 .934 r
.585 .13062 .59954 .14743 .62806 .13684 .61374 .11983 Mtetra
.303 .597 .948 r
.61374 .11983 .62806 .13684 .65757 .14194 .64342 .12481 Mtetra
.634 .769 .945 r
.64342 .12481 .65757 .14194 .68694 .1329 .67302 .11557 Mtetra
.838 .828 .838 r
.67302 .11557 .68694 .1329 .71547 .10559 .70185 .08797 Mtetra
.664 .779 .935 r
.70185 .08797 .71547 .10559 .7452 .09455 .73183 .07672 Mtetra
.661 .717 .89 r
.07273 .29599 .09031 .31453 .11414 .30557 .09667 .28687 Mtetra
.659 .717 .891 r
.09667 .28687 .11414 .30557 .13818 .29669 .12082 .27783 Mtetra
.658 .716 .891 r
.12082 .27783 .13818 .29669 .16244 .28776 .1452 .26873 Mtetra
.665 .718 .889 r
.1452 .26873 .16244 .28776 .18698 .27828 .16986 .25908 Mtetra
.661 .717 .89 r
.16986 .25908 .18698 .27828 .21173 .26898 .19474 .24961 Mtetra
.641 .711 .898 r
.19474 .24961 .21173 .26898 .2366 .26093 .21972 .24139 Mtetra
.654 .715 .893 r
.21972 .24139 .2366 .26093 .2618 .25196 .24504 .23225 Mtetra
.652 .715 .894 r
.24504 .23225 .2618 .25196 .28724 .24298 .27062 .2231 Mtetra
.689 .726 .879 r
.27062 .2231 .28724 .24298 .31313 .23121 .29666 .21114 Mtetra
.661 .717 .89 r
.29666 .21114 .31313 .23121 .33911 .22145 .32278 .2012 Mtetra
.591 .691 .912 r
.32278 .2012 .33911 .22145 .36512 .21597 .3489 .19554 Mtetra
.648 .713 .895 r
.3489 .19554 .36512 .21597 .39162 .20694 .37554 .18632 Mtetra
.647 .713 .896 r
.37554 .18632 .39162 .20694 .41839 .19789 .40245 .17709 Mtetra
.728 .74 .861 r
.40245 .17709 .41839 .19789 .44563 .18205 .42988 .16104 Mtetra
.661 .717 .89 r
.42988 .16104 .44563 .18205 .47293 .1718 .45734 .15059 Mtetra
.502 .648 .922 r
.45734 .15059 .47293 .1718 .50044 .17064 .48497 .14925 Mtetra
.642 .711 .897 r
.48497 .14925 .50044 .17064 .5284 .16152 .51308 .13993 Mtetra
.641 .71 .898 r
.51308 .13993 .5284 .16152 .55666 .15238 .54151 .13058 Mtetra
.775 .757 .837 r
.54151 .13058 .55666 .15238 .585 .13062 .57007 .1086 Mtetra
.661 .717 .89 r
.57007 .1086 .585 .13062 .61374 .11983 .59899 .0976 Mtetra
.369 .569 .915 r
.59899 .0976 .61374 .11983 .64342 .12481 .62878 .10239 Mtetra
.636 .708 .899 r
.62878 .10239 .64342 .12481 .67302 .11557 .65856 .09293 Mtetra
.815 .772 .813 r
.65856 .09293 .67302 .11557 .70185 .08797 .68767 .06509 Mtetra
.661 .718 .89 r
.68767 .06509 .70185 .08797 .73183 .07672 .71784 .05362 Mtetra
.662 .722 .894 r
.05481 .27753 .07273 .29599 .09667 .28687 .07886 .26825 Mtetra
.659 .721 .895 r
.07886 .26825 .09667 .28687 .12082 .27783 .10312 .25904 Mtetra
.10312 .25904 .12082 .27783 .1452 .26873 .12762 .24978 Mtetra
.666 .723 .892 r
.12762 .24978 .1452 .26873 .16986 .25908 .15241 .23996 Mtetra
.662 .722 .894 r
.15241 .23996 .16986 .25908 .19474 .24961 .17741 .23031 Mtetra
.641 .716 .902 r
.17741 .23031 .19474 .24961 .21972 .24139 .20251 .22192 Mtetra
.654 .72 .897 r
.20251 .22192 .21972 .24139 .24504 .23225 .22797 .2126 Mtetra
.653 .719 .897 r
.22797 .2126 .24504 .23225 .27062 .2231 .25367 .20327 Mtetra
.69 .731 .882 r
.25367 .20327 .27062 .2231 .29666 .21114 .27986 .19112 Mtetra
.662 .722 .894 r
.27986 .19112 .29666 .21114 .32278 .2012 .30613 .181 Mtetra
.591 .696 .915 r
.30613 .181 .32278 .2012 .3489 .19554 .33237 .17516 Mtetra
.648 .718 .899 r
.33237 .17516 .3489 .19554 .37554 .18632 .35916 .16575 Mtetra
.647 .717 .899 r
.35916 .16575 .37554 .18632 .40245 .17709 .38622 .15632 Mtetra
.729 .744 .864 r
.38622 .15632 .40245 .17709 .42988 .16104 .41384 .14007 Mtetra
.662 .722 .894 r
.41384 .14007 .42988 .16104 .45734 .15059 .44147 .12942 Mtetra
.5 .652 .926 r
.44147 .12942 .45734 .15059 .48497 .14925 .46921 .12789 Mtetra
.642 .716 .901 r
.46921 .12789 .48497 .14925 .51308 .13993 .49748 .11836 Mtetra
.641 .715 .901 r
.49748 .11836 .51308 .13993 .54151 .13058 .52609 .1088 Mtetra
.777 .762 .839 r
.52609 .1088 .54151 .13058 .57007 .1086 .55488 .08659 Mtetra
.662 .722 .894 r
.55488 .08659 .57007 .1086 .59899 .0976 .58399 .07538 Mtetra
.365 .572 .918 r
.58399 .07538 .59899 .0976 .62878 .10239 .6139 .07996 Mtetra
.636 .713 .903 r
.6139 .07996 .62878 .10239 .65856 .09293 .64386 .07029 Mtetra
.817 .777 .815 r
.64386 .07029 .65856 .09293 .68767 .06509 .67324 .04219 Mtetra
.661 .722 .894 r
.67324 .04219 .68767 .06509 .71784 .05362 .70363 .03049 Mtetra
.664 .741 .908 r
.03634 .26033 .05481 .27753 .07886 .26825 .06052 .25089 Mtetra
.661 .741 .909 r
.06052 .25089 .07886 .26825 .10312 .25904 .08491 .24151 Mtetra
.66 .741 .909 r
.08491 .24151 .10312 .25904 .12762 .24978 .10953 .23208 Mtetra
.668 .742 .906 r
.10953 .23208 .12762 .24978 .15241 .23996 .13446 .22208 Mtetra
.664 .741 .908 r
.13446 .22208 .15241 .23996 .17741 .23031 .1596 .21226 Mtetra
.642 .735 .916 r
.1596 .21226 .17741 .23031 .20251 .22192 .18483 .20369 Mtetra
.655 .739 .911 r
.18483 .20369 .20251 .22192 .22797 .2126 .21043 .1942 Mtetra
.654 .739 .912 r
.21043 .1942 .22797 .2126 .25367 .20327 .23628 .18468 Mtetra
.693 .75 .895 r
.23628 .18468 .25367 .20327 .27986 .19112 .26264 .17235 Mtetra
.664 .741 .908 r
.26264 .17235 .27986 .19112 .30613 .181 .28906 .16203 Mtetra
.588 .715 .931 r
.28906 .16203 .30613 .181 .33237 .17516 .31544 .15601 Mtetra
.649 .737 .914 r
.31544 .15601 .33237 .17516 .35916 .16575 .34239 .14641 Mtetra
.648 .737 .914 r
.34239 .14641 .35916 .16575 .38622 .15632 .36962 .13678 Mtetra
.734 .763 .876 r
.36962 .13678 .38622 .15632 .41384 .14007 .39744 .12032 Mtetra
.663 .741 .908 r
.39744 .12032 .41384 .14007 .44147 .12942 .42525 .10946 Mtetra
.491 .668 .942 r
.42525 .10946 .44147 .12942 .46921 .12789 .45312 .10775 Mtetra
.643 .735 .916 r
.45312 .10775 .46921 .12789 .49748 .11836 .48158 .09801 Mtetra
.642 .734 .916 r
.48158 .09801 .49748 .11836 .52609 .1088 .51037 .08825 Mtetra
.784 .78 .849 r
.51037 .08825 .52609 .1088 .55488 .08659 .53943 .06579 Mtetra
.663 .741 .908 r
.53943 .06579 .55488 .08659 .58399 .07538 .56874 .05435 Mtetra
.347 .582 .931 r
.56874 .05435 .58399 .07538 .6139 .07996 .59877 .05876 Mtetra
.637 .732 .917 r
.59877 .05876 .6139 .07996 .64386 .07029 .62895 .04885 Mtetra
.824 .794 .824 r
.62895 .04885 .64386 .07029 .67324 .04219 .65863 .02049 Mtetra
.663 .742 .908 r
.65863 .02049 .67324 .04219 .70363 .03049 .68923 .00855 Mtetra
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.2)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.4)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.6)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.8)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.18558 .19702 m
.18832 .19985 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.3108 .14799 m
.31341 .15094 L
s
.34306 .13535 m
.34564 .13834 L
s
.37572 .12257 m
.37826 .12558 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.51046 .06981 m
.51284 .07294 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.562},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jB000`400?l00000o`00003ooooooolQ
ooooo`00`?ooool3o`0005gooooo0031ooooo`03o`000?oooooooooo05cooooo0031ooooo`03o`00
0?oooooooooo05cooooo0031ooooo`03o`000?oooooooooo05cooooo0031ooooo`03o`000?oooooo
oooo05cooooo0030ooooo`;o00002Oooool2o`0005?ooooo0031ooooo`03o`000?oooooooooo00Ko
oooo00Co0000oooooooooooo0000D_ooool00<[ooooo00Co0000oooooooooooo0000D_ooool00<[o
oooo00Co0000oooooooooooo0000D_ooool00<[ooooo00Co0000oooooooooooo0000D_ooool00<[o
oooo00Co0000oooooooooooo0000D_ooool00<Gooooo0_l00004ooooo`;o0000Doooool00<;ooooo
0ol000000ooooooo0000o`00001Hooooo`00`?ooool2o`0000Cooooo0_l0001Hooooo`00_Oooool3
o`0000Gooooo00CoZKgXo`000?oooooo0000Eoooool008oooooo0_l00004ooooo`03o`000?oooooo
oooo00;ooooo0ol0000Mooooo`?o00001Oooool4ojVmj003o`000?oooooo000005Oooooo002>oooo
o`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Jooooo`;o00000_oo
ool00ol0003oooooooooo`07ojVmj004o`000?nY_NSoooooo`0005Kooooo002>ooooo`04o`000?oo
ooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Gooooo`?o00001Oooool9ojVmj005
o`000?nY_NSoooooooooool00000EOooool008kooooo00Co0000oooooooooooo00002?ooool3o`00
01Kooooo0_l00007ooooo`;od/_B2?nY_NP00ol0003oZKgXojVmj002o`0005Gooooo002>ooooo`04
o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Booooo`?o00002?ooool4
om;;dPOoZKgX00Ko0000ojVmj?nY_NSoZKgXooooool0001Dooooo`00S_ooool01?l0003ooooooooo
ool00007ooooo`05o`000?ooooooooooooooool000003oooool3o`0000;ooooo00?o0000oooooooo
ool01Oooool5om;;dPSoZKgX00?o0000ojVmj?nY^>@00_ooool00ol0003oooooooooo`1Aooooo`00
Soooool2o`0000Wooooo0ol0000>ooooo`;o00003?ooool7om;;dPKoZKgX00?oZKSTo`000?nY^>@0
0_nY^>@00ooooooo0000ooooo`1Booooo`00Z?ooool3o`0000gooooo2OoBbm82ojVmj0CoZKST00Co
0000ojVhi?nY^>CoZKST0_ooool00ol0003oooooooooo`1@ooooo`00Y_ooool2o`000003ooooool0
003ooooo00cooooo2_oBbm86ojVhi003o`000?nY^>CoZKST00;oZKST00?oooooo`000?ooool0DOoo
ool00:?ooooo0ol0000@ooooo`[od/_B0_oAa]05ojVhi003o`000?nY^>CoZKST00?oZKST00?ooooo
o`000?ooool0D?ooool00:7ooooo0_l0000Aooooo`03oj>kj_oBbm;od/_B00Sod/_B0ooAa]05ojVh
i003o`000?nY^>CoZKST00?oZKST00?oooooo`000?l00000D?ooool009kooooo0ol0000@ooooo`Go
Xk_Z2?oBbm85om76d0CoZKST00?o0000ojVhi?nY^>@01?nY^>@00ooooooo0000ooooo`1?ooooo`00
Voooool3o`000003ooooool0003ooooo00?ooooo00?oZKgXoeRDk_mHU>h00omHU>h4ooooo`WoXk_Z
1_oBbm87om76d0?oZKST00?o0000ojVhi?nY^>@00onY^>@01?nY]n?oooooooooool0001?ooooo`00
VOooool2o`0000Gooooo00?o0000ojVmj?nY_NP00onY_NP7oeRDkP[oXk_Z1OoBbm88om76d0?oZKST
00?o0000ojVhi?nY^>@01OnY]n<2ooooo`03o`000?oooooooooo04cooooo002Fooooo`?o00001Ooo
ool9ojVmj0OoF9C^2_nS^nX3om;;dP[odLK@0_nY^>@00ol0003oZKOSojVgh`05ojVgh`;ooooo00?o
0000ooooooooool0C?ooool006Wooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000M
ooooo`;o00001_ooool00oo8amWoZKgXojVmj009ojVmj0OoF9C^2_nS^nX00ooBbm;odLK@om76d008
om76d004om35d?nY]n?oZKOSo`0000SoZKOS0_ooool00ol0003oooooooooo`1;ooooo`00J?ooool0
1?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000006Oooool3o`0000;ooooo
00?o0000ooooooooool00_ooool3olS7f@_oZKgX1_mHU>h9oj>kjP03oj:fiooAa]3odLK@00SodLK@
0oo@aM000onY]n?o0000ojVgh`07ojVgh`?ooooo00?o0000ooooooooool0B_ooool006Sooooo00Co
0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000001Oooooo0_l00009ooooo`Go
b<OI2OnY_NP01?nY^>CoGI;[oefBjomMT^/4oeRDkPGoXk_Z1OnR]^L8om76d0God<G@00?o0000ojVg
honY]n<01onY]n<00ooooooo0000o`00001<ooooo`00J?ooool01?l0003oooooooooool00007oooo
o`Co00005Oooool3o`0000Wooooo2?o8amT5ojVmj0GoZKST1_mMT^/00omHU>koXk_Zoj:fi`08oj:f
i`KodLK@1_o@aM000ol0003oZKOSojVgh`06ojVgh`05ojW7koooooooooooooooool000002?ooool2
o`0000Cooooo00Co0000oooooooooooooooo1Ol0000dooooo`00J?ooool01?l0003oooooooooool0
0007ooooo`03o`000?oooooooooo01?ooooo1?l0000:ooooo`[ob<OI00?oZKgXojVhi?nY^>@01onY
^>@6oefBj`[oX[KW1OoAa]07om35d003o`000?nY]n?oZKOS00?oZKOS1OnYanl3ooooo`03o`000?oo
oooooooo00Cooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool0000dooooo`00
J?ooool01?l0003oooooooooool00008ooooo`03o`000?oooooooooo013ooooo0_l0000=ooooo`[o
b<OI00?oa/?FojVhi?nY^>@02?nY^>@7oefBj`[oX[KW0ooAa]08om35d003o`000?o@aM3oZKOS00Wo
ZLO_0_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000oooo
ooooool0=?ooool006Wooooo0_l0000:ooooo`;o00003Oooool3o`0000gooooo00?oY;_ZolS7fOo8
amT02?o8amT3olK3eP[oZKST1omMT^/:oj:fi`03om76d?o@aM3od<G@00Ood<G@00?o0000omKCe_nY
anl02_nYanl2ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00002_ooool00ol0
003oooooooooo`0cooooo`00P_ooool2o`0000gooooo1OnT^nX8olS7f@Goa/?F2_nY^>@6oefBj`Wo
X[KW00?oX[GVom35d?o@aM002?o@aM000ooFdmKo0000omKCeP0;ojW7k`;ooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool00000=?ooool0
07oooooo0ol000000ooooooo0000ooooo`09ooooo`WoY;_Z1_o8amT6olK3ePWoZKST00CoZKOSoejA
j_mNTN[oGY7Z1?mMT^/5oj:fi`GoX[GV2?o@aM02omKCeP03o`000?oFdmKoe]?F00WoZLO_00CoZKgX
oooooooooooo00001?ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool0
0000=?ooool007cooooo0ol0000<ooooo`?oY;cZ2OnT^nX5olS7f@Soa/?F1OnY^>@5ojVgh`KoGY7Z
00?oGI;[oj:fionR]NH02?nR]NH6om35d0?oe]?F00Co0000omKCe_oFdmKoe]?F1OnYanl5ojVmj0?o
00001?ooool2o`0000Wooooo0ol0000eooooo`00N_ooool2o`0000cooooo1onT_>X9ojBkjP?ob<OI
2_o6`mH00onY^>CoZKOSojVgh`06ojVgh`OoGY7Z2_nR]NH5om35d0Coe]?F00?o0000omKCe_oFdmH0
0_oFdmH00onYanooZKgXojVmj007ojVmj0;ooooo00?o0000ooooooooool0A?ooool007Oooooo1?l0
0007ooooo`CoOJ_a2_nT_>X9ojBkjP03olS7fOo6`mKoa/?F00Soa/?F00?oa/7FojVghonY]n<02?nY
]n<7oejAjP[oX[GV0oo@aM05omKCeP05o`000?oFdmKoe]?FomKCe_oBbm802onY_NP00ooooooo0000
ooooo`15ooooo`00MOooool2o`0000Cooooo00?o0000oooooonY_NP02OmmZo4:ojBljPKoY;_Z0onT
]nH9olK3eP?oa/7F2_nY]n<7oejAjP[oX[GV00?od<G@omKCe_oFdmH01?oFdmH00ol0003oe]?FomKC
eP03om;;dP_oZKgX00?oooooo`000?ooool0A?ooool007;ooooo0ol00005ooooo`GoZKgX2OmmZo4:
ojBljP;oY;_Z1onT]nH7olK3ePGoa/7F2OnY]n<7oejAjPWoX[GV00?oX/CaomKCe_oFdmH01OoFdmH0
0ol0003oe]?Fom;;dP04om;;dPWoZKgX00?oXi_<ooooool00000AOooool004Gooooo0_l00004oooo
o`03o`000?oooooooooo00?ooooo0ol0000Looooo`;o00001Oooool9ojVmj0SoOJ_a2OnT_>X;ojBg
iPGoa/?F1_o6`MH:ojVgh`OoGY7Z1OnR]NH5oj;4l@Koe]?F00?o0000om;;d_oBbm801OoBbm85ojVm
j0GoXi_<00?oooooo`000?ooool0@oooool004Cooooo00Co0000oooooooooooo00002_ooool00ol0
003oooooooooo`0Hooooo`?o000000?oooooo`000?ooool00_ooool2ok_3h0[oZKgX2?mmZo45ojBl
jPooY;OV0oo6`mH8olK1ePOoZKOS0onYanl4odfHlP?oGY7Z00?oX[GVoj;4lOnRa?401onRa?45omKC
eP03o`000?oBbm;od/_B00Kod/_B00?oZKgXoj>Kc?nSVl`01_nSVl`00ooooooo0000o`000013oooo
o`00A?ooool01?l0003oooooooooool00007ooooo`Go00005_ooool3o`0000Kooooo1Onk`n0:ojVm
j0SoOJ_a00?oY;cZojBgi_nT]nH04OnT]nH00oo6`mKoa/7FolK1eP08olK1eP;oZKOS2?nYanl6odfH
lP_oX/Ca0ooFdmH00ooBbm;o0000om;;dP06om;;dP03ol:Z`OnSVlcoXi_<00OoXi_<0_ooool00ol0
003oooooooooo`11ooooo`00A?ooool01?l0003oooooooooool00007ooooo`04o`000?oooooooooo
o`0001Gooooo0_l00008ooooo`Oo^l?P2?nY_NP00onY^>CoOjK]ognVk@06ognVkA?oY;OV00?oY;GU
olK1e_o6`MH02?o6`MH00oo;d=koZLO_ojW7k`09ojW7k`KoCISb2onRa?401?oFdmKod/_Bom;;d_l0
0006om;;dP?o`Z[12OnSVl`2ooooo`03o`000?oooooooooo043ooooo0014ooooo`04o`000?oooooo
ooooo`0000Sooooo00?o0000ooooool000004_ooool4o`0000Oooooo2_nk`n04ojVmj0GoZKST2?mo
Y^d?ojBgiPGoY;GU2?o6`MH3ol_@gP_oZLO_1_m=V?89oj;4l@05oj>kj_oBbm;od/_Bom;;d_l00000
1OoBbm84ol:Z`@WoXi_<0oooool00ol0003oooooooooo`0oooooo`00A?ooool01?l0003ooooooooo
ool00009ooooo`;o00004?ooool2o`0000?ooooo00?o0000ooooooooool00oooool00onU_>Wo^l?P
ok_3h00:ok_3h003ojVmj?nY^>CoZKST00KoZKST2?moY^d;ojBgiPWoY;GU1_o6`MH5ol_@gPWoZLO_
00CoZKgXoeRDk_mHU>koF9C^1?m=V?85oj;4l@GoXk_Z0_oBbm800ol0003od/_Bom;;dP02om;;dPGo
`Z[12OnSVl`3ooooo`03o`000?oooooooooo03oooooo0015ooooo`;o00002oooool00ol0003ooooo
ooooo`0;ooooo`?o00002?ooool5ojFlj@[o^l?P00?o^[kMojVhi?nY^>@02?nY^>@7ognVk@WoY;OV
00?oY;KUojBeiOnT]ND02?nT]ND5olK1ePOobm3N1OnYanl5ojVmj0KoF9C^00?oCISboj;4lOnS^nX0
2?nS^nX00ooBbm;o0000om;;dP02om;;dPOo`Z[12OnSVl`3ooooo`03o`000?oooooooooo03kooooo
001Nooooo`;o00002?ooool9ojFlj@Oo^l?P1?nj_]d:ojVhi0OoOjK]1OnT]nH5ojBfi@[oY;GU0oo6
`MH9ol_@gP03ojW7konY_NSoZKgX00OoZKgX1_mHU>h;oj>kjP03o`000?oBbm;od/_B00So`Z[12OnS
Vl`4ooooo`03o`000?oooooooooo03gooooo001Kooooo`?o00000_ooool00ol0003oooooooooo`02
ooooo`?oY[cY2_nU_>T4ok_3h0Oo^[kM2_nY^>@7ognVk@03ojBgi_nT]^GoY;KU00OoY;KU2_nT]ND0
0oo6`MKobm3Nol_@gP07ol_@gP03olS7fOnY_NSoZKgX00WoZKgX1_mHU>h:oj>kjP03o`000?oBbm;o
`Z[100So`Z[12?nSVl`01?nW[]coooooooooooooool2o`0003oooooo001Hooooo`?o00001oooool7
ojJlj@[oYKcY00?o^l?PokZngOnj_]d01onj_]d9ojVhi003ojVghon0YNcoP:G/00GoP:G/2_nT]^D9
ojBei@03oj?5lOo;d=kobm3N00Oobm3N0oo8amT;ojVmj0KoF9C^2OnS^nX00ol0003o`Z[1ol:Z`@09
ol:Z`@CoXi_<1OnW[]`4ooooo`03o`000?oooooooooo03cooooo001Fooooo`;o00001_ooool2oiJg
kP[oY[cY2?nU_>T00onU]nKo^[kMokZng@09okZng@GoZKST1OnY]n<7oh2Uk0[oY;KU1OnT]ND5oj?5
l@Oobm3N1Oo8amT9ojVmj004ojBKc?mcP=7oLh3Aog>0d@CoF9C^1OnS^nX4oinIc@03o`000?o2Z/7o
`Z[100So`Z[100?oXi_<ojN^g?nW[]`01_nW[]`5ooooo`03o`000?oooooooooo03_ooooo001Coooo
o`Co00001?ooool6oiJgkP[oY[cY1?nU_>T5ojFgiP_o^[kM00?oZKSTojVghonY]n<01onY]n<7oh2U
k0[oY;KU00?oY;GUoj?5lOnSaO401onSaO45ol_@gPOob<OI1OnY_NP5ojBKc0KoLh3A00?oF9C^oj>k
j_nOVLd01_nOVLd00ol0003o`Z[1ol:Z`@08ol:Z`@[oYjkL1?ooool00ol0003oooooooooo`0koooo
o`00DOooool2o`0000Cooooo00?o0000ojVmj?nY_NP02?nF]nh:ojJlj@03ojFljOnU]nKoYKOV00Ko
YKOV2Onj_]d2okZmg0WoZKOS2?n0YN`7ojBfi@?oY<Ga2_nSaO43ol_@gPWob<OI00?oZKgXojBKc?nT
Vl`01_nTVl`7og>0d@SoWiW=00?o0000oinIcOo2Z/401oo2Z/42olbmc0[oYjkL1?ooool00ol0003o
ooooooooo`0jooooo`008_ooool2o`0000Cooooo00Co0000oooooooooooooooo1Ol0000Mooooo`?o
00001?ooool6ojVmj0SoU[O^2?nV_>T;ojFgiPKo^[kM1Onj_M`9ojVgh`SoP:G/0_nT]^D8ojC5l@[o
XlGa00?obm3NolS7fOo8amT01oo8amT00onjY/GoY9_<ojBKc008ojBKc0OoLh3A1onOVLd00ol0003o
WiW=ol:Z`@06ol:Z`@?oc;g<2_nW[]`5ooooo`03o`000?oooooooooo03Wooooo000Qooooo`04o`00
0?ooooooooooo`0000Sooooo00Co0000oooooooooooo00006_ooool4o`0000Cooooo2OnY_NP8oiJg
kPCoY[cY3onU]nH4okZng@Oo^[gL2OnY]n<4oh2Uk0CoMk;g2_nTaO47oj?5l@;oY;_Z2Oo8amT3okZV
a@WoY9_<1omcP=47oinIc@03o`000?nOVLgo`Z[100Go`Z[11Oo<_L`:ojN^g0?ooooo0_l00009oooo
o`;o00001?ooool00ol0003oooooooooo`03ooooo`?o00008oooool0027ooooo00Co0000oooooooo
oooo00002Oooool00ol0003oooooooooo`0Hooooo`;o00000oooool01?l0003ooooooooooona_nD;
ojVmj0SoU[O^00?oY[cYojFgi_nU]nH04?nU]nH00onj_]go^[gLokZmg008okZmg0KoZKOS0onYanl8
ogNbm`[oY<Ga0_nSaO47ojBkjPOob<OI1?njY/D9ojBKc0SoLh3A1_nOVLd00ol0003oWiW=oinIc@04
ol:Z`@Ooc;g<2?nW[]`00onW[=_oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00Co0000
oooooooooooo00002_ooool00ol0003oooooooooo`0Rooooo`008Oooool01?l0003oooooooooool0
000:ooooo`03o`000?oooooooooo01Cooooo0ol00005ooooo`Go/KoU2onY_NP4oiJgkP?oUk;Z4_nU
]nH00onU]^Go^[gLokZmg00:okZmg0;oZKOS1onYanl8ogNbm`SoY<Ga00?oY;cZojBkj_nT^nX02?nT
^nX5olS7f@Ko^ZK52OnTVl`7og>0d@KoWiW=00?o0000oinIcOnOVLd00oo2Z/48olbmc0GoYjkL1OnW
[=/5ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00001oooool5o`0002?ooooo
000Qooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Cooooo`;o
00001_ooool8ok6oi@WoZKgX00?oZKSToiNbj_nG/^X01_nG/^X>ojFgiPGoYKKU2_nj_M`00onmc>Go
ZLO_ojW7k`08ojW7k`SoMk;g1?nTaO45ojBljP[oY;_Z0oo8amT7okZVa@WoY9_<1omcP=46oinIc@05
o`000?nOVLgoWiW=oinIcOo2Z/402_o<_L`00onW[]coYjcKojN/f`06ojN/f`Gooooo00?o0000oooo
ooooool01?ooool01?l0003oooooooooool00007ooooo`04o`000?ooooooooooo`0002Cooooo000Q
ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000@ooooo`?o0000
0_ooool01Ol0003oooooooooooooooooYkgY00[o/KoU1OnY_NP5ojVhi0SoUk;Z2_nU]nH9ojFfi@So
^[gL0onmc>D:ojW7k`SoMk;g00?oY<GaojBlj_nT_>X01_nT_>X:ojBkjP03olS7fOnjY/Go^ZK500Ko
^ZK52_nTVl`7og>0d@GoWiW=00Co0000oinIcOnOVLgoXZcN2oo<_L`:ojN/f`Gooooo00?o0000oooo
ooooool00oooool01?l0003oooooooooool00008ooooo`03o`000?oooooo000002Cooooo000Roooo
o`;o00002Oooool3o`0000oooooo0_l00006ooooo`GoYkgY2_na_nD00onY_NSoZKSTojVhi007ojVh
i0SoUk;Z1_nU]nH<ojFfi@Ko^[gL1_nmc>D8ojW7k`03ojVmj?mmZo7oOJ_a00KoOJ_a2_nT_>X7ojBk
jP;oX9W=2_njY/D8ojBKc004ojN^g?mVS>?oIXcSofJ<h`CoLh3A1OnOVLd00ol0003oXZcNoj:/gP02
oj:/gPWoc;g<0_o;^lX:ojN/f`Cooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0
0009ooooo`;o00009?ooool003cooooo0ol00006ooooo`SoYkgY2?na_nD2ok2kh@WoZKST2OnG/^X2
ojFgiQ3oYKKU0onj_M`9okg<i@CoZLO_1OnY_NP8ogf[l@[oY;cZ0_nT^nX7oj2Ic@Wo^ZK51OnTVl`5
ojN^g0KoIXcS00?oLh3AoinIcOnR[=h00_nR[=h00ol0003oXZcNoj:/gP02oj:/gPSoc;g<0oo;^lX:
ojN/f`?ooooo0ol00005ooooo`;o00002oooool00ol0003oooooooooo`0Rooooo`00>Oooool3o`00
00;ooooo00Co0000oooooooooooooooo3?nW_NT4ok6oi@Ko/;_Q2OnY^>@6oiNbjP;oUk3Y4onU]^D0
0onj_Mco_LcUokg<i@09okg<i@03ojW7konY_NSoZKgX00KoZKgX2?mmZo48ojBljP[oX9W=2_njY/D0
0onTVlcoYjkLojN^g006ojN^g0OoIXcS1?nR[=h00ol0003oXZcNoj:/gP03oj:/gPKoc;g<1Oo;^lX:
ojN/f`;ooooo00CoZKgXoooooooooooo0000=_ooool003Oooooo0_l00006oooooa3oYkgY00?o/KoU
ok2khOn`^n401on`^n49ojVhi0;oUk;Z1_nG/>T@ojFfi@?oYLK`2_nmc>D00onk`n3oZKgXojVmj008
ojVmj0SoOJ_a1?nT_>X>oj2Ic@So^ZK500?o`kWAojN^g?nW[]`02?nW[]`7ofJ<h`?oXZcN00?o0000
oj:/g_nR[=h01?nR[=h4olbmc0Oobk_:2?nW[=/5ojVmj003ooooool0003ooooo03Gooooo000doooo
o`?o00001Oooool00onT_>[oYkgYojNmj@0?ojNmj@03ojNhiOn`^n7o/;_Q00Wo/;_Q1_nY^>@3ojVg
h`SoUk3Y3?nU]^D7ojG6l0Oo_LcU1?nk`n0:ojVmj0SoOJ_a00?oY;cZoj2IcOnPVLd03_nPVLd7okZV
a@?o`kWA2_nW[]`7ofJ<h`;oXZcN00?o0000oj:/g_nR[=h01?nR[=h3olbmc0Sobk_:1OnW[=/9ojVm
j003ooooool0003ooooo03Cooooo000booooo`;o000000?oooooo`000?ooool00_ooool5ojBljPgo
YkgY1OnW^>D;ok2kh@;oZKST1onY]n<8oiN`j@SoYKKU2onUa_04okg<i@Oo^l?P2?nY_NP00onTVlco
R8gAohR=d@06ohR=dA7oX9W=1_njY/D4ol>id@[oYjkL1omVS><2oj:/gP03o`000?nR[=koXZcN00Go
XZcN00?oc;g<ol^kb_o;^lX02?o;^lX00onW[=_oA/Bgom?;dP0:ojVmj0;ooooo00?o0000oooooooo
ool0<_ooool002oooooo0ol00004ooooo`03o`000?nT_>[oY;cZ00KoY;cZ2_nW_NT8ojNhi@Wo/;_Q
00?o/;WQojVghonY]n<02?nY]n<8oiN`j@CoYKKU3onUa_000onmc>Go^l?Pok_3h008ok_3h0CoZKgX
1OnTVl`8ohR=dA7oX9W=1?njY/D6ol>id@[oYjkL1omVS><00onR[=ko0000oj:/gP04oj:/gP;oXZWL
2_o;^lX2okck`0?odl_B2_nY_NP00ooooooo0000ooooo`0cooooo`003_ooool2o`0001gooooo0_l0
0005ooooo`?oZKgX2OnT_>X6ojNmj@coYkSU1_n`^n44ok2ih@[oZKOS2?nG/>T00onU]^GoYLK`ojG6
l00=ojG6l0?oYKcY2onk`n000onY_NSoY9_<ojBKc005ojBKc0SoR8gA4OnPVLd3okZVa@So`kWA2?nW
[]`00onW[=_oIh_QofN;h@03ofN;h@?oIXcS00?o0000oj:/g_nRZM`01_nRZM`8ol^kbP;o_?_01OoC
bm88ojVmj004oiYj[_oooooo0000o`0003?ooooo000=ooooo`04o`000?ooooooooooo`0001Wooooo
0ol00004ooooo`OoZKgX2OnT_>X2ojNmjA3oYkSU1?n`^n46ok2ih@[oZKOS1?nG/>T4oi>om@coYLK`
1onU_>T9ok_3h003ok2Qb?nTVlcoY9_<00OoY9_<2?n8SM4Aoj2Ic@03okZVaOo3^M7o`kWA00Oo`kWA
1OnW[]`5ojN/f`OoIh_Q00?oXZWLo`000?nRZM`01_nRZM`7ol^kbP;o_?_01_oCbm85ojVmj0CoVWZ^
0oooool00ol0003oooooooooo`0`ooooo`003Oooool01?l0003oooooooooool0000Fooooo`?o0000
0oooool00ol0003oZkgWoj^mi`09ojVmj0OoY;cZ00?oY;OVojNhiOnW^>D04OnW^>D00on`^n7o/;WQ
ok2ih@07ok2ih@SoZKOS0_nYanl8oi>om@SoYLK`00?oY[cYojFljOnU_>T02?nU_>T6ok_3h0Co/:78
2?nTVl`8ohR=d@ooX9W=0_nS[=h;ol>id@03ojN^g?nW[=_oYjcK00KoYjcK2?mWRn400ol0003oXZWL
oj:Yg006oj:Yg0Gobk_:0_nlnl08om?;dP03ojVmj?nJNZkoVWZ^00KoVWZ^0_ooool00ol0003ooooo
ooooo`0`ooooo`003Oooool01?l0003oooooooooool0000Dooooo`;o00001?ooool6oj^mi`WoZKgX
1?nT_>X4ojBgiQ3oYkSU0_nV]n@;ok2ih@CoZKOS1_nYanl8oi>om@CoYLK`1OnV_>T:ojFlj@Co^l?P
1On`XLP8ojBKc0WoR8gA2_nPVLd7oj>/gPWo`kWA00?o`[O?ojN/fonW[=/02?nW[=/7ofN;h@03o`00
0?nRZMcoXZWL00KoXZWL1?o;^lX2okck`0Wodl_B2OnJNZh3ooooo`03o`000?oooooooooo02oooooo
000=ooooo`04o`000?ooooooooooo`00017ooooo0ol00004ooooo`WoZkgW2OnY_NP00onT_>[oY;OV
ojBgiP05ojBgiPcoYkSU1_nV]n@;ok2ih@03ojVghonYanooZLO_00OoZLO_2?nC_oD00onUa_3oY[cY
ojJlj@06ojJlj@[oYKcY00?o^l?Pok2Qb?n`XLP01_n`XLP8ojBKc0SoR8gA1_nPVLd<oj>/gPOo`kWA
0oo2]ll9ojN/f`OoIh_Q00?o0000oj:Yg?nRZM`01_nRZM`3ol^kbP;o_?_02OoCbm800on]QJ_oVWZ^
oiYj[P07oiYj[PCooooo00?o0000ooooooooool0;_ooool000gooooo00Co0000oooooooooooo0000
3oooool2o`0000?ooooo00Co0000oooooonX_NSoZ;gX2_n[_NL6ojVmj0;oZKST2OnT]nH8ojNhi@;o
YkOT2?nV]n@9ok2ih@;o//W[2_nYanl4oi>om@?oU[O^2_nV_>T7ojFlj@;oXI[=2On`XLP8ojBKc0Wo
R8gA0_nPVLd?oj>/gPGo`kWA1_o2]ll9ojN/f`KoIh_Q00?o0000oj:Yg?nRZM`01onRZM`00oo;^l[o
_?_0oj:kj`09om?;dP?o[HF[2?nJNZh4ooooo`03o`000?oooooooooo02kooooo000>ooooo`;o0000
3Oooool3o`0000Cooooo1_nX_NP:oj^mi`;oZKgX1_nY^>@9ojBgiPCoYkSU1_nW]n@8ojJgi0Go/;WQ
1_nbbN/8ojW7k`03ojVmj?nF]nkoU[O^00KoU[O^2_nV_>T2ojFlj@OoXI[=2On`XLP8ojBKc0CoR8gA
1?n4WN@Boj>/gP?o`kWA1oo2]ll8ojN/f`?oA/Fg00GoZKgXofN;hOmWRn7oIh_Qo`000007oj:Yg0Ko
X[_[1ooCbm84ojf5Z`WoVWZ^0oooool2o`0002oooooo000Jooooo`?o00001Oooool9ojRmj0SoZkgW
0_nZ^N@8ojVhi0WoY;OV00?oYkSUojNgi?nW]n@01onW]n@8ojJgi003ok2ihOnbbN_o//W[00So//W[
1?nYanl5ojVmj0SoU[O^2?nV_>T:oj6Jc@Wo/:781_nTVl`2ojN^g0WoQ9gT4_nS[=h00oo3^M7o`[O?
ol:gc`07ol:gc`CoYjcK0_m6aKL7ojVmj003oeRDk_l0003oIh_Q00;oXZWL0_mHU>h9oj:kj`Godl_B
1On]QJ/9oiYj[PGooooo00?o0000ooooooooool0;?ooool001Sooooo0_l00003ooooo`03o`000?oo
oooooooo00?oZKgX2OnX_NP4oj^mi`KoZ[WT2?nY^>@6ojBgiP?oY;KU2_nW]n@6ojJgi0?oYlK`2_nb
bN/00onYanooZKgXojVmj006ojVmj0SoU[O^1?nV_>T>oj6Jc@Wo/:780_nTVl`6ojN^g0SoQ9gT4OnS
[=h00onSZ]co`[O?ol:gc`09ol:gc`03ojN/fom6aKOob<OI00WoZKgX0_l00006oeRDkPWoX[_[0ooC
bm86ojf5Z`WoVWZ^1Oooool00ol0003oooooooooo`0/ooooo`005Oooool3o`0000Gooooo1onY_NP9
ojRmj003oj^mionZ^NCoZ[WT00OoZ[WT2?nY^>@2ojBgiPOoY;KU2_nW]n@2ojJgi0OoYlK`2?nbbN/0
0ona_nGoZKgXojVmj008ojVmj0SoU[O^00?oY[cYoj6JcOnQV/d03_nQV/d8ok2Qb003okNde_nW[]co
YjkL00OoYjkL2?n4WN@=oj>/gPGoXj[L2Oo2]ll2ojOfb@?ob<OI1OnY_NP3o`000003ojVmj?l0003o
F9C^00KoF9C^2OnR^n/00ooCbm;o[HF[ojf5Z`06ojf5Z`SoVWZ^1_ooool00ol0003oooooooooo`0[
ooooo`005?ooool2o`0000Cooooo2onY_NP6ojRmj0?oZ;SU2_nZ^N@6ojVhi0;oZKOS2OnT]^D8ojNg
i0_oYlK`1?nbbN/5ok6oi@[oZKgX1?nF]nh3oiNEca;oXI[=1On`XLP4okNdePSoYjkL2On4WN@9oj>/
gPSoXj[L2?o2]ll2ojOfb@Gob<OI00CoZKgXo`000?l0003o00001?nY_NP01?nJNZko0000oh=[[on3
Jjl4oeRDkPOoX[_[0_nHN:h9ojf5Z`SoVWZ^1_ooool00ol0003oooooooooo`0[ooooo`005?ooool3
o`0000ooZKgX0_nX_NP7ojRhi@[oZ[WT0_nY^>@6ojVgh`WoY;KU1?nW]n@?ojO6l003ok;9jona_nGo
/KoU00Ko/KoU2?nY_NP00onTVlcoUiG?oiNEc`06oiNEca7oXI[=1?n`XLP6okNdePSoYjkL2?n4WN@6
oj>/gPcoXj[L1_o2]ll2ojOfb@Cob<OI0ol00004ojVmj0CoVWZ^00?oPf^_o`000?n3Jjl01?n3Jjl0
0omHU>koX[_[oj:kj`06oiQh[PWo[HF[2OnJNZh6ooooo`;o00002?ooool2o`0000Cooooo00?o0000
ooooooooool00_ooool3o`0001Gooooo000Dooooo`03o`000?nY_NSo000000koZKgX2onX^>D8ojZi
i003ojZghonY]n?oZKOS00OoZKOS2OnT]^D00onW]nCoYlK`ojO6l00=ojO6l0;oYkgY2_na_nD4ojVm
j0GoY9_<1onGULlBoj6Jc@03ok2Qb?ng]=Ko]kCF00Ko]kCF2OnW[]`8ohBMi0;oXjcN3onSZ]`4ol:g
c`?oYoK90_o8amT3o`0000Cob<OI00?oZKgXoiYj[_nJNZh01OnJNZh00on3Jjoo0000oh=[[`04oh=[
[`WoV7R^2?n]QJ/9oiYj[PKooooo0_l00007ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000
ooooooooooooooooo`00000Dooooo`003Oooool2o`0000Gooooo00?o0000oooooonY_NP03?nY_NP>
ojRhi@CoZ[WT1OnZ]n<9ojVgh`KoY;KU0onSaO4<ojO6l0KoYkgY2_na_nD00onY_NSoY9_<ojBKc005
ojBKc0SoUiG?4?nQV/d00onT[Mgo]kCFokNdeP08okNdePKoYjkL0_nW[=X8ohBLhQ7oXj[L0oo2]ll3
ojOfb@?o00001_o8amT00onWPZcoVWZ^oiYj[P06oiYj[P03oh=[[ol0003oPf^_00CoPf^_2OnHN:h8
ojf5Z`WoVWZ^1oooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000Oooooo00Go
0000ooooooooooooooooo`00000Dooooo`003?ooool01?l0003oooooooooool00003ooooo`04o`00
0?oooooo0000ooooo`[oZKgX4OnX^>D00onZ^NCoZ[OSojZgh`06ojZgh`WoZKOS0_nT]^D7oj?5l@So
YlK`2_nW_NT8ok6oi@03ojVMbonTVlcoY9_<00OoY9_<1onGULl=oj6Jc@GoY:gM2_ng]=H2ojN^g0Ko
YjcJ2?n4W>8Aoj>Zg003ol:gconWm/Wo000000;o00002?o8amT2ojN2[0SoVWZ^0_n3Jjl00ol0003o
Pf^_oh=[[`03oh=[[`SoV7R^2On]QJ/8oiYj[PSooooo00?o0000ooooooooool01?ooool01?l0003o
ooooooooool00007ooooo`Co00005Oooool000cooooo00Co0000oooooooooooo00000oooool2o`00
00?ooooo1_nY_NP3ojVhi0ooZ;SU0onX]n@8ojZgh`SoZKOS0onYanl8oj?5l@CoYlK`3_nW_NT4ok6o
i@GoZIg;2?nTVl`8oiNEc`WoXI[=2?nT[Md9okNdeP03okJbe?nW[=[oYjcJ00OoYjcJ1on4W>8?oj>Z
g004ojBlj_l0003o0000o`0000CoY;cZ1Oo8amT5ojN2[0OoVWZ^0on3Jjl00ol0003oPf^_oh=[[`02
oh=[[`SoV7R^2On]QJ/9oiYj[PSooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0
0007ooooo`03o`000?oooooooooo01Kooooo000<ooooo`04o`000?ooooooooooo`0000?ooooo00?o
0000ooooooooool00oooool2ojVmj0OoZKST2onX^>D7ojRgi0SoZ[OS1?nY]n<7ojW7k`SoXlGa00?o
YlK`ojNmjOnW_NT03onW_NT00ona_nGoZIg;ojVMb`05ojVMb`WoY9_<1onGULl6oj6Jc@coY:gM1ong
]=H3okJbe0SoYjcJ2?n4W>8;oj>Zg004ojBlj_l0003o0000o`0000SoY;cZ0oo8amT6ojN2[0SoVWZ^
0_n3Jjl00ol0003oPf^_oh=[[`02oh=[[`WoV7R^2?n]QJ/9oiYj[PSooooo00?o0000ooooooooool0
0oooool01?l0003oooooooooool00008ooooo`03o`000?oooooooooo01Gooooo000<ooooo`04o`00
0?ooooooooooo`0000?ooooo00?o0000ooooooooool01?ooool9ojVhi0OoZ;SU2onX]n@8ojZgh`03
ojVghonYanooZLO_00SoZLO_1_nSaO43ojBljPooYkgY00?oXY[=ojVMbonYWL/01onYWL/8ojBKc0So
UiG?0_nQV/d@ojB]g@Co]kCF1Onf/]@9ojN/fPOoQ9cR1onSZ]`2ojBljP?o00003?nT_>X00oo8amWo
Yh:/ojN2[005ojN2[0SoVWZ^0on3Jjl01?l0003oPf^_oh=[[on3Jjl9oiQh[PSo[HF[2?nJNZh00onV
Y=Coooooooooo`06ooooo`;o00001Oooool2o`0000[ooooo0_l0000Eooooo`003?ooool01?l0003o
ooooooooool00003ooooo`;o00001_ooool9ojVhi0CoZ;SU3_nX]n@6ojZgh`?oZlO^2_nYanl2oj?5
l@OoY;cZ2onW_NT5oj:Jc@SoZIg;2OnTVl`4oiNEc`?oV:OQ4_nT[Md3okNdePOo][;D2OnW[=X7ohBL
hP;oXj[L0_mmZo401?nT_>[o0000o`000?l0000>ojBljP03oiQi[_nWPZcoYh:/00KoYh:/2?nJNZh4
oh=[[`04o`000?n3JjooPf^_oh=[[`SoV7R^2On]QJ/4oiYj[PGoYZCD2Oooool00ol0003ooooooooo
o`0Uooooo`003Oooool2o`0000Cooooo00?o0000ooooooooool01_ooool9ojVhi003ojRhiOnX]nCo
Z;OT00ooZ;OT0_nZ]n<8oj_7kPKoZLO_0_nY_NP:ojBljPKoYkgY2_nRV/d8ojVMb`OoY9_<00?oYjkL
oiRWhOnHYn401_nHYn4BojB]g@03okNde_nf/]Co][;D00Oo][;D1onW[=X00om6aKOoZKgXojVmj003
ojVmj0GoOJ_a0_l0000>ojBljPCoV7V^2OnWPZ`7oiYj[PGoPf^_00?o0000oh=[[on3Jjl02?nHN:h9
ojf5Z`03oiYj[_nVY=CoYZCD00KoYZCD2Oooool00ol0003oooooooooo`0Uooooo`004oooool00ol0
003oooooooooo`07ooooo`KoZKST0_nY]n<AojRgi0;oZLO_2_n[anh2ojW7k`KoZKgX2_nT_>X2ojNm
j@goXY[=2?nYWL/4ojBKc0GoYjkL2?nHYn4?ojB]g@;oY:_L2_nf/]@4ojN/fP;oA/Fg2?nY_NP01?mm
Zo7o0000o`000?l00003ogf[l@[oY;cZ2?nHNJh8ojN2[0OoVWZ^1On3Jjl00ol0003oPf^_oh=[[`08
oiQh[PWo[HF[2_nVY=@9ooooo`03o`000?oooooooooo02Cooooo000Booooo`?o00002Oooool2ojVh
i0KoZKOS3OnX]n@6ojW7k`SoZlO^00?oZkkWojVmj?nY_NP01onY_NP8ojBljP03oj2IcOnRV/goXY[=
00koXY[=2?nYWL/00onTVlcoYjkLojN^g006ojN^g0SoV:OQ2onT[Md6ojB[g0[o][;D00?oYjcJodK5
]on4j</00_nk`n06ojVmj0?o00001ommZo46ojBljP_oV7V^2?nWPZ`8oiYj[PGoPf^_00?o0000oh=[
[onHN:h02?nHN:h7ojf5Z`;oak?62_nVY=@4ooooo`;oK1E80oooool00ol0003oooooooooo`0Soooo
o`004_ooool00ol0003oooooooooo`0:ooooo`SoZKOS2_nX]n@9ojW7k`CoZlO^1On[_^L9ojVmj0Co
Y;cZ1OnPVLd?oj:Jc@OoZIg;00?o[[3JojN^g?nW[]`02?nW[]`8oiRWh@KoY:gM2onTZm`8okJbe0;o
Q>S;1Onk`n02ojVmj0?o00001?nY_NP7ogf[l@;oY;cZ3_nHNJh8ojN2[0SoVWZ^1_n3Jjl00ol0003o
V7R^oiQh[P07oiQh[PKo[HF[0oo7/lH:ojJTe0KoK1E800?oZKkXooooooooool00_l0000Tooooo`00
4_ooool00ol0003oooooooooo`0;ooooo`SoZKOS1_nX]n@=ojW7k`03oj_7k_n[_^OoZkkW00KoZkkW
2OnY_NP00onT_>[oX9W=oj2Ic@05oj2IcA3oXY[=1?nYWL/4ojj`fP[oYjkL2?nHYn42ojB]g@koY:_L
1_nf/]@3ohCXb`Go^l?P0ol00005ojVmj0;oVWZ^1on=LJl@oiQi[PSoYh:/2?nJNZh6oh=[[`03o`00
0?n3JjooV7R^00OoV7R^1On]QJ/5olNcaP[oYZCD1Om/5DP2ojVnj003ooooool0003o000002Cooooo
000Booooo`?o00003?ooool8ojVgh`;oZ;OT3onYanl3ojRmj0SoZkkW1_nY_NP2ojBKc0WoX9W=4?nR
V/d00onYWL_o[[3Jojj`fP05ojj`fP[oYjkL1?nHYn43oiRUga7oY:_L1?nf/]@2ohCXb`Co^l?P0ol0
0003ok_3h0;oZKgX1OnJNZh7ohea[a7oV7V^2?nWPZ`7oiYj[POoPf^_00?o0000oiQh[_nHN:h01_nH
N:h4ojf5Z`Ooak?62?nVY=@00onUX];oK1E8of`EB003of`EB0;oZKkX0oooool00ol0003ooooooooo
o`0Qooooo`002Oooool5o`0000Cooooo00?o0000ooooooooool03Oooool6ojVgh`ooZLO_1onX_NP8
oj^ni`;oZKgX1_nTVl`8oj2Ic@koXY[=0_nU[Md9ojj`fPSoYjkL00?oYjcJoiRUgonHYMl01_nHYMlA
ojB[g003okJbe?n4j<_oYKcY00;oYKcY00Co^l?Po`000?l0003o00001Onk`n000onROZgoVWZ^oiYj
[P06oiYj[POoSG6_4?nHNJh8ojN2[0SoVWZ^1on3Jjl00ol0003oV7R^oiQh[P06oiQh[P;o[HF[2?o7
/lH5ojJTe0GoYJ;B0om/5DP4ojVnj0;ooooo00?o0000ooooooooool08Oooool000[ooooo00Co0000
oooooooooooo00001?ooool00ol0003oooooooooo`0>ooooo`;oZKOS3onYanl00onY_NSoZ;gXojRm
j008ojRmj0KoZkkW2OnTVl`8oj2Ic@_oXY[=1_nU[Md9ojj`fPCoYjkL1OnW[=X8oiRUg`koY:_L00?o
>K^`ojFljOnU_>T00_nU_>T3o`0000Ko^l?P0onROZd8oiYj[POoSG6_4?nHNJh8ojN2[0SoVWZ^1on3
Jjl00onHN:ko0000oiQh[P06oiQh[P03ojf5Zoo7/lKoak?600Soak?600?oYZCDojFRd_nUX]801_nU
X]83of`EB0;oZKkX0_nFJil3ooooo`03o`000?oooooooooo023ooooo000;ooooo`03o`000?oooooo
oooo00?ooooo0ol0000Aooooo`coZLO_1OnY_NP:ojRmj0;oZkkW3OnTVl`8oj2Ic@OoXY[=00?oYZgM
ojF]gOnU[Md01onU[Md9ojj`fP03ojN^g?nW[=[oYjcJ00GoYjcJ2?nHYMl;ojB[g0?oY[cY0_nU_>T3
o`0000CoYKcY1?nk`n04oj9n[@SoVWZ^1on=LJl@oiQi[PSoYh:/1onJNZh01?nVY=CoKXKJofj6f_m^
Q]X5oh=[[`03o`000?nHN:koV7R^00?oV7R^0_nQX]D;olNcaPWoYJ;B0om/5DP4oiI[W`Cooooo00?o
0000ooooooooool07oooool000cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0B
ooooo`WoZLO_2?nY_NP8ojRmj003oj>Kc?nTVlcoY9_<00goY9_<2?nPVLd4oj:Jc@GoYZgM2?nU[Md8
ojj`fP03ojf^f?nW[=[oYjcJ00OoYjcJ2?nHYMl6ojB[g003ocZl/OnV_>WoY[cY00?oY[cY0ol00008
ojFlj@03ok_3h?nROZgoXWj]00GoXWj]1onJNZh7ohea[a3oV7V^2OnWPZ`3oiYj[PGoYZCD1_m^Q]X0
0on3JjooV7R^o`000007oj6Re@Woak?60_o6/LD9ojFRdP;oK1E81OnFJil2ooooo`;o00008Oooool0
00Wooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo01?ooooo1_nYanl;
ojVmj0CoZ;gX1OnSVl`?ojBKc0SoX9W=00?oXY[=ojJ]gOnV[Md01_nV[Md8ojF]g@Co[[3J1On][]P9
ojN/fPSoV:GO0_nTZm`2oiJgkPCoY[cY0ol00003ojJlj@KoYKcY0_nINJh8oj9n[@SoVWZ^1on=LJl@
oiQi[PSoYh:/00?oVWZ^ojJTe?nVY=@01OnVY=@7ofj6fP;oXJ;E00?o0000oj6ReOnQX]D01?nQX]D8
olNcaP?oa[752OnUX]82of`EB0GoUV^O1?ooool00ol0003oooooooooo`0Nooooo`002Oooool01Ol0
003ooooooooooooooooo000000?ooooo0_l0000Eooooo`;oZLO_3onY_NP00onX_NSoXi_<oj>Kc005
oj>Kc0ooY9_<1_nPVLd2oj>/gPWoYZgM2OnU[Md00on^/=[o[JkHojf^f006ojf^f0SoYjcJ1_nHYMl7
oiJgkP03ojJljOl0003o000000OoY[cY0_nU_>T5oiUi[PSoXWj]2?nJNZh7ohea[a3oV7V^1onWPZ`0
0onn[l_oYZCDojJTe007ojJTe0OoKXKJ00?oXJ;Eo`000?nQX]D01_nQX]D6olNcaPGoa[752?nUX]80
0om/5DSoUV^OoiI[W`04oiI[W`Cooooo00?o0000ooooooooool07_ooool000[ooooo0ol00004oooo
o`03o`000?oooooooooo01Cooooo4?nY_NP:oj>Kc0ooY9_<0_nPVLd6oj>/gPWoYZgM1_nU[Md2ojF[
f`Wo[JkH2OnW[=X2oiRUg`?oZKgX1OnF]nh3o`0000SoY[cY2?nINJh8oj9n[@SoVWZ^1on=LJl@oiQi
[PKoYh:/0onn[l/9ojJTe0KoKXKJ0_nQX]D00ol0003oXJ;Eoj6Re@05oj6Re@Coak?61_o6/LD9ojFR
dPKoUV^O1Oooool00ol0003oooooooooo`0Mooooo`004Oooool00ol0003oooooooooo`0Eooooo`co
ZKgX3OnSVl`>ojBKc0;oYjkL2?nS[=h9ojJ]g@;oYJgM1_nUZm/9ojf^f0KoYjcJ2?nY_NP01?nF]nko
0000o`000?l00004oiJgkPCoY[cY3?nINJh7oj9n[@SoVWZ^1on=LJl@oiQi[PCoYh:/1Onn[l/9ojJT
e0OoKXKJ0_nQX]D00ol0003oXJ;Eoj6Re@04oj6Re@?oak?61oo6/LD7ojFRdPSoUV^O1_ooool00ol0
003oooooooooo`0Looooo`004?ooool00ol0003oooooo`00000Gooooo`SoZKgX00?oY9_<oj>Kc?nS
Vl`03_nSVl`:ojBKc0KoYjkL2?nS[=h6ojJ]g@_oYJ_K2On][]P2ojN/fP03of7F`_na_nGo/KoU00Ko
ZKgX0ol00008oiJgkP03ojJljOnINJkoVGV^00coVGV^2?nROZd8oiYj[POoSG6_4?nHNJh2ojN2[0Oo
_Zo;2OnVY=@7ofj6fP;oXJ;E00?o0000oj6ReOnQX]D01?nQX]D00oo7/lKoa[75olJaa@07olJaa@;o
YJ;B1?nQLYh9oiI[W`Gooooo0_l00008ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o
00001oooool0013ooooo0_l0000Iooooo`CoZKgX1OnTVl`?oj>Kc0KoY9_<0_nX[]`9ojN^g0SoXjcN
0_nV[Md>ojF[f`So[JkH00?oHMK2ok6oiOna_nD01?na_nD2ojVmj0?o00001?nY_NP4oiJgkP?oU7J^
3onINJh8oj9n[@SoVWZ^1on=LJl@oiQi[P03ojN2[?nn[l_o_Zo;00Oo_Zo;1onVY=@01?nUX];oKhGH
ofn5f?m_QMP4ofj6fP;oXJ;E00?o0000oj6ReOnQX]D00_nQX]D2oj6Pe0[oa[751_nQLYh9oiI[W`Ko
oooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooo
ooooool000001_ooool0013ooooo00?o0000ooooooooool06Oooool00onY_NSoY9_<ojBKc005ojBK
c13oXi_<0_nTVl`6ojR^g0WoYjkL1_nS[=h00onSZ]coYJ_KojF[f`0?ojF[f`Co[JkH0_mQe/87ok6o
i@?o00001OnY_NP2oiYj[POoU7J^3onINJh8oj9n[@SoVWZ^1on=LJl>oiQi[P;oXZ;E2_nn[l/4ojJT
e0GoYJ;B1_m_QMP01?m^Q][oXJ;Eoj6ReOl00006oj6Pe0Soa[752?nQLYh8oiI[W`Oooooo00?o0000
ooooooooool01?ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool00000
1_ooool0013ooooo0ol0000Iooooo`WoY9_<3_nSVl`00onW[]coZ:kLojR^g007ojR^g0WoYjkL0_nS
[=h5oj>Zg17oYJ_K00?o[JkHof7F`_ln_k<00_nW_NT4ok6oi@?o00000ona_nD2ojVmj0GoVWZ^1onD
MZh?oiUi[PSoXWj]2?nJNZh7ohea[`[oV7V^1onRX]D:okj_b`03ojJTe?nUX];oYJ;B00GoYJ;B1om_
QMP3oj6Pe003o`000?nQX=CoXJ3D00?oXJ3D1oo6/LD9oj5bWPSoUV^O1oooool00ol0003ooooooooo
o`04ooooo`04o`000?ooooooooooo`0000Sooooo0ol00007ooooo`004?ooool00ol0003ooooooooo
o`0Jooooo`SoY9_<3?nSVl`4ojN^g0SoZ:kL2?nW[]`00onW[=[oXj[Loj>Zg006oj>Zg0koYJ_K0_ln
_k<6ojNmj@?o00001Ona_nD00onMO:koVWZ^oiYj[P05oiYj[PSoU7J^3onINJh7oj9n[@WoVWZ^1on=
LJl5oiQi[P_oXZ;E2Onn[l/00onm[LWoYJ;BojFRdP07ojFRdPOoKhGH0onQX=@00ol0003oXJ3Doj6P
e003oj6Pe0Goa[750_nDJil8oj5bWPSoUV^O2?ooool00ol0003oooooooooo`03ooooo`04o`000?oo
ooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000006ooooo`002Oooool3o`0000Cooooo
00?o0000ooooooooool06oooool8ojBKc0WoXi_<1onW[]`8ojR^g0CoYjkL1OnW[=X7oj>Zg0_oYJ_K
00?o?[ncojNmjOnW_NT01OnW_NT3o`000003ojNmjOna_nGo/KoU00;o/KoU1?nMO:h8oiYj[POoU7J^
3onINJh7oj9n[@WoVWZ^1on=LJl2oiQi[PooXZ;E1onn[l/3okf]b@SoYJ;B1om_QMP3oj6Pe003o`00
0?nQX=CoXJ3D00?oXJ3D1?o6/LD3oiA[W`SoXG:N2OnFJil7ooooo`;o00001?ooool01?l0003ooooo
ooooool00007ooooo`05o`000?ooooooooooooooool000001_ooool000[ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Looooo`OoY9_<1_nSVl`:ojN^g0WoZ:kL00?oYjkLojN/f_nW
[=X01_nW[=X7oj>Zg0KoYJ_K0_lo`;<7ojNmj@?o00001OnW_NT00ona_nGoWGb^oiel[P05oiel[POo
VWZ^1onDMZh?oiUi[PSoXWj]1onJNZh00onVY=CoQiGJohNEfP05ohNEfQ7oXZ;E1Onn[l/5okf]b@Wo
YJ;B1om_QMP3oj6Pe003o`000?nQX=CoXJ3D00;oXJ3D0oo6/LD4oiA[W`SoXG:N2OnFJil6ooooo`03
o`000?oooooo000000Gooooo0_l00009ooooo`?o00001oooool000Oooooo1Ol00003ooooo`?o0000
7Oooool8ojBKc0;oXi_<3_nW[]`6ojR^g0;oZ:cJ2OnW[=X8oj>Zg0;oYJ_K00Co?l2cojBlj_nT_>[o
Y;cZ1OnW_NT3o`0000OoYkgY00?oVGV^oiel[_nMO:h01_nMO:h7oiYj[POoU7J^3onINJh8oj9n[@Co
VWZ^1OnVY=@7ohNEfQ3oXZ;E0onn[l/8okf]b@SoYJ;B1om_QMP4oj6Pe003o`000?nQX=CoXJ3D00;o
XJ3D00?oa[75oiA[WonDJil00onDJil9oj5bWPSoUV^O2Oooool00ol0003oooooooooo`0Gooooo`00
1oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo01kooooo1_nTVl`BojN^g0;o
Z:kL1_nX[=X9ojN/fPKoXj[L00?o<kR]ojBlj_nT_>X01OnT_>X2ojNmj@;o00001onW_NT4oiUi[PSo
WGb^1onJNZh7oiAf[PooVGV^2?nROZd00onJNZkoYZCDojJTe006ojJTe0OoQiGJ4OnRX]D00onn[l_o
_Jg9okf]b@07okf]b@WoYJ;B1_m_QMP4oj6Pe004o`000?nQX=CoXJ3DohYSW`OoU6^O2OnQLYh8oiI[
W`[ooooo00?o0000ooooooooool05_ooool000Sooooo00?o0000ooooool000001?ooool00ol0003o
ooooooooo`0Oooooo`;oY9_<5?nW[]`00onV[=_oZ:cJojR/fP07ojR/fPWoYjcJ0_nSZ]`00om6aKOo
ZKgXojVmj007ojBljP?o00001OnW_NT9oiUi[POoWGb^1onJNZh8oiAf[PooVGV^1_nROZd00ondZ/oo
YZCDojJTe008ojJTe0OoQiGJ3_nRX]D2oj:Pd`[o_Jg91onUX]800onMLIooUV^OoiI[W`04oiI[W`;o
KhGH0_nQX=@2ohYSW`03o`000?n:HiooRV>O00SoU6^O2?nQLYh8oiI[W`[ooooo00?o0000oooooooo
ool05_ooool000Wooooo0_l00004ooooo`;o00008?oooolCojN^g0GoYZcK2?nX[=X8ojN/fP03odK5
]onY_NSoZKgX00CoZKgX0onT_>X3o`0000?oY;cZ0_nW_NT<oiUi[PSoWGb^1onJNZh7oiAf[PooVGV^
0onROZd5okBZc`WoYZCD2?n7UMX:oj:Re@KoXZ3C2_nm[LT2ojFRdPGoWG6O1onFJil6ohYSW`03o`00
0?n:HiooU6^O00OoU6^O2?nQLYh9oiI[W`Wooooo0_l0000Gooooo`002_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo023ooooo3onW[]`00onW[=_oYZcKojJ/f`06ojJ/f`SoZ:cJ1?nW
[=X00om6aKOoZkkXoj^nj007ojVmj0?o00001?nT_>X2oiQi[PkoVGV^2?nMO:h7oiYj[POoU7J^3onI
NJh00onROZgo]:[?okBZc`06okBZc`SoYZCD2?n7UMX6oj:Re@;oXZ7C2?nRX=<9okf]b@SoWG6O2?nF
Jil6ohYSW`03o`000?nDJiooU6^O00KoU6^O2?nQLYh9oiI[W`_ooooo00?o0000ooooooooool05?oo
ool000oooooo00?o0000ooooooooool08Oooool;ojN^g0GoYjcK2?nV[=/8ojR/fP03ojN/f_n[_^So
ZkkX00CoZkkX0onY_NP3o`0000;oZKgX0_nT_>X5oiQi[PkoVGV^2?nMO:h7oiYj[POoU7J^3_nINJh0
0onSXmGo]:[?okBZc`07okBZc`WoYZCD2?n7UMX2oj:Re@KoXZ7C2?nRX=<7okf]b@03oiE[WonMLIoo
WG6O00KoWG6O2?nFJil6ohYSW`03o`000?nDJiooU6^O00KoU6^O2OnQLYh8oiI[W`_ooooo00?o0000
ooooooooool05?ooool000kooooo00?o0000ooooool000008_ooool9ojN^g0SoYjcK2?nV[=/6ojR/
fPSoZkkX0ol00004ojVmj003oiYj[_nHNJkoV7V^00GoV7V^3onINJh7oiel[POoVWZ^1onDMZh;oiUi
[PGoXj?E2OndZ/l6ojJTe0;oYJ;B2?n7TmP8oj:Qd`WoXZ3C1?nm[LT4oiE[W`SoWG6O1onFJil7ohYS
W`03o`000?nDJiooU6^O00GoU6^O2OnQLYh8oiI[W`Kooooo0_n5@WD4ooooo`03o`000?oooooooooo
01?ooooo000>ooooo`;o00009?ooool6ojN^g0;oYjcJ2?nW[=/9ojJ/f`;oZ:cJ00CoA<>fojRmj?nX
_NSoZ;gX1?n[_^P3o`0000;oZkkX0_nY_NP4oiYj[PSoV7V^3_nINJh8oiel[PKoVWZ^2?nDMZh8oiUi
[POoXj?E2_ndZ/l2ojJTe0KoYJ;B2?n7TmP8oj:Qd`SoXZ3C0onm[LT5oiE[W`SoWG6O1onFJil8ohYS
W`03o`000?nDJiooU6^O00GoU6^O2?nQLYh8oiI[W`;ooooo1_n5@WD00onY_^Soooooooooo`02oooo
o`03o`000?oooooooooo01;ooooo000>ooooo`03o`000?oooooooooo02Cooooo0_nW[]`6ojN/fPSo
YjcK1_nV[=/2odC3]POoZ;gX0ol00004oj^nj003oi]j[_nJNZkoVWZ^00GoVWZ^1onHNJh>oiUi[PSo
WGb^1onJNZh7oiAf[PGoVGV^2onSXmD8okBZc`03ok>Xc_nUX];oYJ;B00KoYJ;B2?n7TmP9oj:Qd`So
XZ3C00?o_Jg9oiE[WonEJil01?nEJil8oieaW`OoUV^O2?n:Hil00ol0003oU6^OoiA[W`05oiA[W`So
XG:N2OnFJil7ohE2M@03ojVnj?oooooooooo00;ooooo0_l0000Cooooo`003_ooool00ol0003ooooo
ooooo`0Tooooo`WoYjcJ2?nW[=/2ojJ/f`;oA<>f0_nY_NP5ojRmj0?o000000?oZ;gXoj^nj?n[_^P0
0_n[_^P3oi]j[POoVWZ^1onHNJh>oiUi[PSoWGb^1onJNZh7oiAf[P;oVGV^3onSXmD5okBZc`Co/jS>
2?nUX]88ohNCf0SoXZ7C1_nRX=<9oiE[W`SoWG6O2?nFJil7ohYSW`03oiA[Wol0003oU6^O00GoU6^O
2?nQLYh9oiI[W`OoQD9e0_nY_^P4ooooo`03o`000?oooooooooo017ooooo000>ooooo`?o00009Ooo
ool9ojN/fPKoYjcK0_m4`kH6ojVmj004ojRmj?l0003o0000o`0000GoZ;gX00?oZkkXoi]j[_nKNZh0
0onKNZh7oiYj[POoV7V^3onINJh7oiel[POoVWZ^1?nDMZh3oiRNf17oXj?E1?ndZ/l5ok>XcPWoYJ;B
1on7TmP9oj:Qd`;oXZ3C3?nEJil8oieaW`SoUV^O1on:Hil2oiA[W`03o`000?nDJiooU6^O00?oU6^O
2OnQLYh8oiI[W`OoQD9e0_nEIiX4ooooo`03o`000?oooooooooo017ooooo0006ooooo`?o00001Ooo
ool00ol0003oooooooooo`0Vooooo`WoYjcJ0_nW[=/00om4`kKoZKgXojVmj006ojVmj0?o00001_nX
_NP2oiYj[POoVgZ^1_nJNZh7oiQi[PooVGV^2?nMO:h5oiYj[P03ojJTe?nHW]SoV9kH00KoV9kH4OnS
XmD00ondZ/oo/jS>ok>XcP06ok>XcPSoYJ;B1on7TmP7oj:Qd`;oSfJO3_nEJil9oieaW`OoUV^O2?n:
Hil2oiA[W`03o`000?nDJiooU6^O00;oU6^O2OnQLYh8oiI[W`OoQD9e0_nEIiX5ooooo`03o`000?oo
oooooooo013ooooo0005ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooooooo
o`0Vooooo`SoYjcJ00?oA/FgojVmj?nY_NP01onY_NP2o`0000CoZKgX0_nX_NP5oiYj[POoVgZ^1onJ
NZh7oiQi[PkoVGV^2?nMO:h2oiYj[PGoYZCD2?nHW]P>oj>Se@;oXj7C2_ncZ<h8ojFRdPOoQi?H0_nR
XM<6ohmVW`ooUF^O2?nMLIl7oiI[W`SoRV>O0_nDJil00ol0003oU6^OoiA[W`03oiA[W`SoXG:N2?nF
Jil7ohE2M@;oUFNJ1_ooool00ol0003oooooooooo`05ooooo`?o00001oooool000Gooooo00Go0000
ooooooooooooooooo`000003ooooo`03o`000?oooooo000002Sooooo1?nW[=X01?m6aKOooooooooo
ooooool6ojVmj0?o00001OnY_NP9oiYj[PKoVgZ^1onJNZh7oiQi[PkoVGV^1onMO:h00on/Y];oYZCD
ojJTe006ojJTe0OoV9kH2onSXmD6oj>Qd`Wo/jS>1_nUX]83oiY^W`OoUV^O1on?IYl?oiE[W`SoWG6O
1onFJil8ohYSW`?oU6^O00?o0000oiA[WonDJil00_nDJil8oj5bWPWoUV^O1_n5@WD3oiEWVPGooooo
0_l00007ooooo`03o`000?oooooooooo00Kooooo0005ooooo`Co00001?ooool2o`0002[ooooo00?o
YjcJooooooooool01Oooool2ojVmj0?o00001OnY_NP<oiYj[PKoVgZ^1onJNZh7oiQi[PooVGV^0onM
O:h5ojbVdPOoYZCD2?nHW]P6oj>Se@[oXj7C2_ncZ<h2ojFRdPKoVVjO1onFJil7ohmVW`ooUF^O2?nM
LIl7oiI[W`SoRV>O1?nDJil01?l0003oU6^OoiA[WonDJil8oj5bWPWoUV^O1_n5@WD3oiEWVPKooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`001Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo033ooooo0ol00005ojVmj0ooVWZ^1_nKNZh7oiYj[POoV7V^3onI
NJh00onMO:ko[:KBojbVdP05ojbVdPSoYZCD2?nHW]P2oj>Se@koXj7C2?ncZ<h00onEJiooVVjOoiY^
W`06oiY^W`OoUV^O1on?IYl?oiE[W`SoWG6O2?nFJil7ohYSW`GoU6^O00?o0000oiA[WonDJil02OnQ
LYh7oiI[W`03ojBKcOn5@WGoQD9e00CoQD9e0onEIiX7ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool01_ooool000Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0]
ooooo`?o00000oooool2ojVmj1;oVWZ^1onKNZh7oiYj[PKoV7V^3OnINJh2ojBSe0Wo[:KB2?nVY=@4
oiRNf0?oV9cF4OnSXM<5ok>XcPCoUF^O1onJKYl7oiI[W`OoSfJO3onEJil8oieaW`SoUV^O1on:Hil5
oiA[W`03o`000?nDJiooU6^O00WoXG:N1?nFJil5ojBKc@GoQD9e0onEIiX7ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01_ooool000Oooooo0_l00004ooooo`;o0000:oooool3o`00
00Kooooo5?nJNZh7oi]j[POoVWZ^1onHNJh9oiUi[PKoY:?D2?n/Y]87ojJTe003ojFRd_nHW=KoV9cF
00KoV9cF4?nSXM<4ok>XcPGoUF^O1onJKYl8oiI[W`OoSfJO3onEJil8oieaW`OoUV^O2?n:Hil5oiA[
W`03o`000?nDJiooU6^O00SoXG:N00?oUV^OojBKcOnTVld01_nTVld5ohE2M@?oUFNJ2?ooool00ol0
003oooooooooo`02ooooo`;o00002?ooool000gooooo00?o0000ooooooooool09oooool3o`0000Wo
oooo5OnJNZh6oi]j[POoVWZ^1onHNJh5oiUi[P_oY:?D1on/Y]84ojJTe0GoYJ;B1onHW=HAoj>Qd`03
ok>Xc_nEJiooUF^O00GoUF^O1onJKYl8oiI[W`OoSfJO3onEJil8oieaW`OoUV^O2?n:Hil6oiA[W`03
o`000?nDJiooXG:N00KoXG:N00?o`j[1ojBKcOnTVld01onTVld5ohE2M@CoUFNJ1_ooool3o`0000Co
oooo00?o0000ooooooooool01_ooool000cooooo00?o0000ooooooooool09Oooool3o`0000cooooo
5OnJNZh6oi]j[POoVWZ^1onHNJh2oiUi[PkoY:?D2?n/Y]800onVY=CoYJ;BojFRdP05ojFRdPSoV9cF
3_nSXM<:oiE[W`SoVVjO1onFJil7ohmVW`ooUF^O2?nMLIl7oiI[W`SoRV>O1_nDJil00ol0003oU6^O
oj5bWP05oj5bWP?o`j[12OnTVld4ohE2M@CoUFNJ0oooool3o`0000;ooooo00?o0000ooooooooool0
2oooool000cooooo0ol0000Rooooo`?o00004?oooolDoiYj[PKoVgZ^2?nJNZh5oiQi[P03oj:ReOnT
XmCoY:?D00ooY:?D1_n/Y]800on[YM3oYJ;BojFRdP07ojFRdPSoV9cF2_nSXM<=oiE[W`SoVVjO1onF
Jil7ohmVW`ooUF^O2?nMLIl7oiI[W`SoRV>O1onDJil00ol0003oXG:Noj5bWP03oj5bWPCo`j[12OnT
Vld4ohE2M@CoUFNJ0ol00005ooooo`03o`000?oooooooooo00_ooooo000<ooooo`03o`000?oooooo
oooo01oooooo0ol0000CoooooaCoVWZ^1onKNZh7oiYj[P;oV7V^1OnRX]DAojBSe0;o[:KB1On[YM09
ojFRdPOoV9cF1_nSXM<3oi9YW`koUF^O2?nJKYl7oiI[W`OoSfJO3onEJil8oieaW`SoUV^O1on:Hil8
oiA[W`04o`000?nQLYkoXG:Noj5bWPGo`j[12OnTVld4ohE2M@CoUFNJ2?ooool00ol0003ooooooooo
o`0;ooooo`003?ooool00ol0003oooooooooo`0Looooo`?o00005_oooolDoiYj[POoVgZ^1OnJNZh2
ojJTe0OoXZ;E3onTXm@2ojBQd`SoZjG@2?nUX]88oiRLeP;oXj7C1_nBJIl>oiE[W`SoVVjO1onFJil7
ohmVW`ooUF^O2?nMLIl8oiI[W`OoRV>O2OnDJil00ol0003oXG:Nol>Z`@06ol>Z`@WoY9_=0on5@WD4
oiEWVPSooooo00?o0000ooooooooool02oooool000cooooo0ol0000Jooooo`;o00006OoooolEoiYj
[PKoVgZ^0_nJNZh6ojJTe0OoXZ;E2onTXm@6ojBQd`OoZjG@2OnUX]84oiRLePGoUVbO1_nBJIl?oiE[
W`OoVVjO1onFJil7ohmVWa3oUF^O2?nMLIl7oiI[W`SoRV>O2?nDJil00ol0003o`j[1ol>Z`@06ol>Z
`@SoY9_=00CoY9[;ohE2MOn5@WGoQD9e1OnEIiX8ooooo`03o`000?oooooooooo00[ooooo0004oooo
o`?o00001Oooool00ol0003oooooooooo`0Gooooo`?o00006ooooolEoiYj[PGoVgZ^00?oYjCCojJT
e?nVY=@01onVY=@7oj:Re@OoY:?D00?oY:;CojBQdonTXM<01_nTXM<8oj^Ud0KoYJ;B1?nHKIl7oiI/
W`KoTVVO3onEJil7oiY^W`SoUV^O1on?IYl?oiE[W`SoWG6O1OnFJil2ojBKc@?oM87B1On:Hil6oiA[
W`;oX9W>00?o`j[1o`000?o3Z/401_o3Z/45ojBKc@GoY9[;0_n5@WD5oiEWVPSooooo00?o0000oooo
ooooool02_ooool000?ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo
01Gooooo0ol0000OoooooaCoVWZ^0_nKNZh5ojNTd`SoYZCD1onRX]D4ojBSe0GoY:;C2?nTXM<8oj^U
d0;oYJ;B1onHKIl7oiI/W`KoTVVO3onEJil7oiY^W`SoUV^O1on?IYl?oiE[W`SoWG6O0_nFJil6ojBK
c@KoM87B00?oRV>OoiA[WonDJil01onPVLh00oo3Z/7o0000ol>Z`@06ol>Z`@03ojBKcOnTV/_oY9[;
00KoY9[;0_n5@WD5oiEWVPCooooo0_n<Ch42ooooo`03o`000?oooooooooo00[ooooo0003ooooo`05
o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`0Booooo`?o00008_oooolCoiYj
[P03ojFTe?nWY=?oYjCC00KoYjCC2?nVY=@7oj:Re@03ojBSe?nTX]?oY:;C00GoY:;C2OnTXM<6oj^U
d0?oUV^O1onHKIl7oiI/W`KoTVVO3onEJil8oiY^W`OoUV^O1on?IYl?oiE[W`OoWG6O00?o^ZK5ojBK
cOnTVld01_nTVld7ogB1dPWoX9W>00?o`j[1o`000?o3Z/401Oo3Z/400oo2ZL7oY9[;ojBJb`07ojBJ
b`;oQD9e1OnEIiX00oooooooS4n1oha?P@03oha?P@03ojVnjOoooooo000000cooooo0004ooooo`?o
00001?ooool2o`00013ooooo0ol0000Uoooooa3oVWZ^1OnUY=@7ojNTd`WoYZCD0onRX]D3oj:Qd`Wo
Y:;C2?nTXM<4oj^Ud0GoUV^O1onHKIl7oiI/W`OoTVVO3_nEJil8oiY^W`OoUV^O1on?IYl?oiE[W`Ko
WG6O0onjY/D8ojBKc@OoM87B2?nPVLh2ol>Z`@03o`000?o3Z/7o`j[100;o`j[10oo2ZL49ojBJb`03
ohE2MOnEIi[oUFNJ00?oUFNJ1_n<Ch400onY_^Woooooo`00000<ooooo`000oooool01Ol0003ooooo
oooooooooooo000000?ooooo00?o0000ooooooooool03?ooool3o`0002Sooooo3?nJNZh9ojFTe0So
YjCC1_nVY=@2ojFRdPOoXZ7C2OnTX]<8ojBQd`03oj^Ud?nFJiooUV^O00GoUV^O1onHKIl7oiI/W`Oo
TVVO3_nEJil8oiY^W`OoUV^O1on?IYl?oiE[W`GoWG6O1?njY/D8ojBKc@OoM87B2OnPVLh2ol>Z`@03
o`000?o3Z/7o`j[100Co`ZW12OnTV//00on5@WGoUFNJoiEWVP04oiEWVPGoS4n10_nY_^T00ol0003o
ooooooooo`0:ooooo`000oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooooooo
ool02Oooool3o`0002_ooooo2OnJNZh=ojFTe0SoYjCC0_nVY=@6ojFRdPOoXZ7C2?nTX]<6ojBQd`[o
UV^O1onHKIl7oiI/W`OoTVVO3_nEJil8oiY^W`OoUV^O1on?IYl@oiE[W`?oWG6O1OnjY/D9ojBKc@Oo
M87B2?nPVLh3ol>Z`@03o`000?o2ZL7o`ZW100Co`ZW12?nTV//00on5@WGoUFNJoiEWVP04oiEWVPGo
S4n10_ooool00ol0003oooooooooo`0:ooooo`001?ooool3o`0000Cooooo0_l00007ooooo`?o0000
;oooool5oiYj[P03ojJTe?nUY=CoYJCD00koYJCD1_nWY=<00onVX];oYJ;BojFRdP06ojFRdPOoXZ7C
2OnTX]<2ojBQd`goUV^O1onHKIl7oiI/W`OoTVVO3onEJil7oiY^W`OoUV^O1on?IYl@oiE[W`;oWG6O
1onjY/D8ojBKc@OoM87B2?nPVLh3ol>Z`@03o`000?o2ZL7o`ZW100Co`ZW12OnTV//6oiEWVPGoS4n1
0oooool00ol0003oooooooooo`09ooooo`002oooool00ol0003oooooooooo`03ooooo`?o0000<_oo
ool3oiYj[PCoYZCD3onUY=@4ojNTd`CoYZ;B2?nUX]87oj:Qd`KoY:;C1OnEJil<oiI[W`OoV6fO2?nF
K9l6oi9YW`ooUF^O1onJKYl8oiI[W`OoSfJO3onEJil00onMLIoo^ZK5okZVa@06okZVa@WoY9_=1omd
PM88oj2IcP04ol>Z`Oo2ZL7o`ZW1o`0000Ko`ZW11onTV//7oiEWVPGoS4n10oooool00ol0003ooooo
ooooo`09ooooo`002_ooool01?l0003oooooooooooooool3o`0003Gooooo00?oVWZ^ojJTe?nVY=@0
1?nVY=@@ojFTe003ojNTdonVX];oYZ;B00CoYZ;B2OnUX]87oj:Qd`;oY:;C2?nEJil=oiI[W`KoV6fO
2?nFK9l6oi9YW`ooUF^O1onJKYl8oiI[W`OoSfJO3OnEJil2oj6Jc@Wo^ZK51onTVld2ojBJb`?oMH3@
1?mdPM86oj2IcP;oWiS<1?o2ZL400ol0003o`ZW1ol:Y`@03ol:Y`@CoY9[;0_nLJiT8oiEWVPKoS4n1
0_ooool00ol0003oooooooooo`09ooooo`002_ooool4o`0003Sooooo2?nVY=@>ojFTe003ojFRd_nV
X];oYZ;B00KoYZ;B2?nUX]86oj:Qd`CoUVbO1onEJil=oiI[W`OoV6fO1onFK9l6oi9YW`ooUF^O2?nJ
KYl7oiI[W`OoSfJO2OnEJil7oj6Jc@Wo^ZK50_nTVld7ojBJb`KoMH3@00?oM87Boj2Ic_nPVLh01_nO
V<`3ol:Y`@03o`000?o2ZL7o`ZW100Co`ZW100?oY9[;oia[VOnLJiT00onLJiT8oiEWVPGoS4n10_oo
ool00ol0003oooooooooo`09ooooo`002_ooool2o`0003_ooooo2?nVY=@:ojFTe0GoYJ;B2?nVX]88
ojFRdP;oXZ7C1onFK9l7oiE[W`goUV^O1onHKIl7oiI/W`OoTVVO3_nEJil8oiY^W`OoUV^O1on?IYl4
oiE[W`coXI[=2?njY/D00onjYLCoY9[;ojBJb`07ojBJb`OoMH3@2?nOV<`4ol:Y`@03o`000?o2ZL7o
`ZW100?o`ZW11_nLJiT8oiEWVPGoS4n10_ooool00ol0003oooooooooo`09ooooo`003?ooool00ol0
003oooooooooo`0iooooo`OoYZCD1_nUY=@:ojFRdPOoYZ;B1_nUX]8;oiI/W`OoUF^O3OnFJil7oiQ]
W`OoUVbO1onBJIl>oiE[W`SoVVjO1OnFJil2ojBKc@OoRHkA4?nQV/d7okZVa@?o^ZG42?nTV//8ogF0
d0SoWiS<1?o2ZL401?l0003o`ZW1ol:Y`Oo2ZL47oia[V@SoUFNJ1On<Ch42ooooo`03o`000?oooooo
oooo00Wooooo000=ooooo`03o`000?oooooooooo03Sooooo2?nVY=@2ojFTe0goYJ;B2?nVX]82ojFR
dP03oiI[WonFK9ooUVbO00_oUVbO1onEJil=oiI[W`OoV6fO1onFK9l7oi9YW`koUF^O2?nJKYl2oiI[
W`KoY9_=1on9S]4@oj6Jc@Go^ZK51?njYL@9ojBJb`OoMH3@2?nOV<`5ol:Y`@03o`000?o2ZL7oW6^I
00OoW6^I2?nEIiX5oha?P@;ooooo00?o0000ooooooooool02Oooool000kooooo00?o0000oooooooo
ool0>?ooool6ojJTe17oYJ;B1_nVX]84oiI[W`goUVbO1onEJil=oiI[W`OoV6fO1onFK9l7oi9YW`oo
UF^O1_nJKYl00onaX/SoY9_=ojBKc@06ojBKc@OoRHkA4?nQV/d4okZVa@Ko^ZG42?nTV//7ogF0d0So
WiS<1Oo2ZL400ol0003oU6JJoia[V@07oia[V@SoUFNJ1On<Ch42ooooo`03o`000?oooooooooo00Wo
oooo000?ooooo`;o0000>Oooool2ojJTe1GoYJ;B0_nVX]87oiI[W`goUVbO1onEJil=oiI[W`OoV6fO
1onFK9l7oi9YW`ooUF^O1?nJKYl4ok6Rb0OoY9_=2?n9S]4?oj6Jc@?o^ZK51onjYL@8ojBJb`SoMH3@
2?nOV<`4ol:Y`@03oiAVV_l0003oW6^I00SoW6^I1onEIiX5oha?P@?ooooo00?o0000ooooooooool0
2?ooool0017ooooo00?o0000ooooooooool0=_oooolEojFRdPcoUV^O3?nFK9l7oiE[W`koUV^O1_nH
KIl7oiI/W`OoTVVO3onEJil3oiY^W`Go/J;82?nTVld7ohV>dA3oXI[=00?o^ZK5okZUa?njYL@01onj
YL@8ojBJb`OoMH3@2?nOV<`3ol:Y`@?oU6JJ00?o0000oia[VOnLJiT01_nLJiT8oiEWVPCoS4n10ooo
ool00ol0003oooooooooo`08ooooo`004_ooool00ol0003oooooooooo`0foooooa7oYJ;B0_nFK9l=
oiI[W`coUVbO2?nEJil=oiI[W`KoV6fO1onFK9l7oi9YW`ooUF^O00?oVVjOok6Rb?naX/P01OnaX/P8
ojBKc@SoRHkA3?nQV/d3oj2Hc0[o^ZG41_nTV//2oiYZV@?oUFNJ1?meP=09oinHc003ol:Y`OnDIY[o
U6JJ00?oU6JJ00?o0000oia[VOnLJiT01OnLJiT8oiEWVPCoS4n10oooool00ol0003oooooooooo`08
ooooo`004oooool00ol0003oooooooooo`0fooooo`goYJ;B1OnFK9l=oiI[W`coUVbO2?nEJil=oiI[
W`KoV6fO2?nFK9l7oi9YW`coUF^O0_nRV/d9ok6Rb0OoY9_=2?n9S]46oj6Jc@;oXIS<2?nPV<`:okZU
a0;oY9[;1OnJJYT7oiEWVP03ogF0d?nOV<coWiS<00;oWiS<0_n>HYX8oiAVVP03o`000?nLJiWoW6^I
00GoW6^I2?nEIiX4oha?P@?ooooo00?o0000ooooooooool02?ooool001Cooooo0_l0000fooooo`[o
YJ;B00?ooooooiI/WonFK9l01OnFK9l=oiI[W`goUVbO1onEJil=oiI[W`KoV6fO2?nFK9l7oi9YW`Wo
UF^O1_nRV/d8ok6Rb0SoY9_=2?n9S]42oj6Jc@KoXIS<1onPV<`9okZUa0SoVVZI2?nEIiX6ohiRVPSo
U6JJ00?oW6^Io`000?nLJiT01OnLJiT8oiEWVPCoS4n10oooool00ol0003oooooooooo`08ooooo`00
5_ooool00ol0003oooooooooo`0dooooo`KoYJ;B1?ooool7oiI/W`goUV^O3OnFK9l7oiE[W`goUV^O
1onHKIl7oiI/W`OoTVVO1OnEJil:oj:Jc@So/J;81_nTVld2ojBJb`SoRXc@2?nQV<`8oj2Hc0Oo^ZG4
00?oU6JJoiYZVOnJJYT01_nJJYT8oiEWVPOoSV:J1onDIYX2oia[V@03o`000?nLJiWoW6^I00?oW6^I
2?nEIiX4oha?P@?ooooo00?o0000ooooooooool02?ooool001Oooooo00?o0000ooooooooool0=?oo
ool2ojFRdPOooooo1onFK9l=oiI[W`goUVbO1onEJil=oiI[W`OoV6fO1onFK9l7oi9YW`;oUF^O3_nR
V/d8ok6Rb0;oY9_=1_nTV//8ohZ<d0OoXIS<2OnPV<`4okZUa0?oU6JJ2?nJJYT8oiEWVPOoSV:J1onD
IYX2oia[V@03o`000?nLJiWoW6^I00CoW6^I2?nEIiX3oha?P@?ooooo00?o0000ooooooooool02?oo
ool001Sooooo00?o0000ooooooooool0?Oooool6oiI/W`goUV^O3OnFK9l7oiE[W`goUV^O1onHKIl7
oiI/W`CoTVVO0onHU/l@oj:Jc@Oo/J;800?o/:37ojBJbonTV//01_nTV//8ohZ<d0SoXIS<2?nPV<`3
okZUa0GoU6JJ1onJJYT8oiEWVPOoSV:J2?nDIYX2oia[V@03o`000?nLJiWoW6^I00?oW6^I2?nEIiX4
oha?P@;ooooo00?o0000ooooooooool02?ooool001Wooooo0_l0000mooooo`KoUVbO3OnFJil=oiI/
W`OoUF^O3_nFJil6oiQ]W`GoUVbO0_nTVld8oiRFc`ooXY[=1?naX/P5ok2Pa`SoY9[;1on:S=08oj6H
c0WoX9S<00?o^ZG4oiAVV_nDIYX01?nDIYX7oiYZV@SoUFNJ1on>HYX8oiAVVP?oW6^I00?o0000oia[
VOnLJiT00_nLJiT8oiEWVPCoS4n10oooool00ol0003oooooooooo`07ooooo`006oooool00ol0003o
ooooooooo`0jooooo`KoUVbO3OnFJil=oiI/W`OoUF^O3_nFJil6oiQ]W`;oUVbO1_nTVld7oiRFca3o
XY[=00?o/J;8ok2Paon`X<L01On`X<L9ojBJb`OoRXc@1onQV<`7oj2Hc0WoU6JJ2?nJJYT7oiEWVPOo
SV:J2?nDIYX4oia[V@04o`000?nLJiWoW6^Ioia[V@SoUFNJ1?n<Ch43ooooo`03o`000?oooooooooo
00Oooooo000Looooo`03o`000?oooooooooo03Wooooo1_nFK9l=oiI[W`goUVbO1onEJil>oiI[W`Go
V6fO00?oZIk;ojBKcOnTVld01_nTVld8oiRFc`koXY[=00?oXIW<ok2Paon`X<L01on`X<L8ojBJb`Oo
RXc@2?nQV<`2oj2Hc0goU6JJ2?nJJYT8oiEWVPKoSV:J2?nDIYX4oia[V@04o`000?nLJiWoW6^Ioia[
V@SoUFNJ1?n<Ch43ooooo`03o`000?oooooooooo00Oooooo000Mooooo`03o`000?oooooooooo03So
oooo1onFK9l<oiI[W`goUVbO2?nEJil=oiI[W`;oV6fO1OnYW//8ojBKc@SoV9K?2_nRV/d5oj6Ic0So
/:372OnTV//6ohZ<d0KoXIS<0onAI9X>oiAVVPSoVVZI2?nEIiX6ohiRVPSoU6JJ1OnLJiT00ol0003o
W6^Ioia[V@09oiEWVP?oS4n10oooool00ol0003oooooooooo`07ooooo`007_ooool2o`0003Sooooo
1onFK9l<oiI[W`goUVbO2?nEJil;oiI[W`;oXi_=1onYW//9ojBKc@OoV9K?1_nRV/d2oj:Ic0OoXIW<
2On`X<L7ojBJb`;oV6RJ1?nEIiX2ohZ<d0;oXIS<1_nAI9X>oiAVVPSoVVZI2?nEIiX7ohiRVPOoU6JJ
1_nLJiT00ol0003oW6^Ioia[V@08oiEWVP?oS4n10oooool00ol0003oooooooooo`07ooooo`008?oo
ool00ol0003oooooooooo`0eooooo`OoUVbO3?nFJil>oiI/W`OoUF^O2?nFJil6oj>Kc@OoZIk;2?nT
Vld8oiRFc`;oXY[=1_nRVL`7oj6Ic0So/:371?nTV//5oiQXVPOoUFNJ1onAI9X>oiAVVPSoVVZI2?nE
IiX7ohiRVPSoU6JJ1OnLJiT00ol0003oW6^Ioia[V@08oiEWVP?oS4n10oooool00ol0003ooooooooo
o`07ooooo`008Oooool00ol0003oooooooooo`0dooooo`OoUVbO3?nFJil>oiI/W`OoUF^O1OnFJil9
oj>Kc@SoZIk;2?nTVld4oiRFc`?oV9C>2?nRVL`7oj6Ic0Wo/:3700?oY9[;oiQXV_nHJ9X01OnHJ9X7
oiEWVPOoTFBJ3onDIYX7oiYZV@SoUFNJ1on>HYX8oiAVVPKoW6^I00?o0000oia[VOnEIiX01onEIiX3
oha?P@?ooooo00?o0000ooooooooool01oooool002;ooooo00?o0000ooooooooool0<oooool7oiI/
W`goUV^O3OnFK9l7oiE[W`;oUV^O3?nSVld8ojVNb`KoY9_=0_nTV//8oiRDcPOoXYW<2?nQVL`7ok2P
a`;oUFJJ1onHJ9X7oiEWVPOoTFBJ3onDIYX7oiYZV@SoUFNJ1on>HYX8oiAVVPOoW6^I00?o0000oiEW
V_nEIiX01_nEIiX3oha?P@Cooooo00?o0000ooooooooool01_ooool002?ooooo0_l0000cooooo`Oo
UVbO3OnFJil=oiI/W`GoUF^O0_nQV/h?oj>Kc@SoZIk;0_nTVld6ojBJb`OoV9C>2?nRVL`7oj6Ic0Co
/:371OnEIYX7oiQXVPOoUFNJ1onAI9X?oiAVVPOoVVZI2?nEIiX7ohiRVPSoU6JJ2?nLJiT00ol0003o
UFNJoiEWVP06oiEWVP;oS4n11?ooool00ol0003oooooooooo`06ooooo`009Oooool00ol0003ooooo
ooooo`0`ooooo`OoUVbO3OnFJil=oiI/W`;oUF^O1_nQV/h>oj>Kc@OoZIk;00?oZIc9ojBJbonTV//0
1_nTV//7oiRDcPSoXYW<2?nQVL`00on`X<OoUFJJoiEVVP05oiEVVPOoV6RJ1onEIiX7oi5TVPooU6JJ
2?nJJYT8oiEWVPKoSV:J2?nDIYX8oia[V@03o`000?nEIi[oUFNJ00KoUFNJ0_n<Ch44ooooo`03o`00
0?oooooooooo00Kooooo000Vooooo`03o`000?oooooooooo02oooooo1onFK9l=oiI[W`coUVbO00?o
Y9_=oj6Jc_nQV/h01_nQV/h>oj>Kc@CoZIk;1OnYW<T8ojBJb`OoV9C>1onRVL`6oj6Ic0[oUFJJ1onH
J9X8oiEWVPOoTFBJ3_nDIYX8oiYZV@SoUFNJ1_n>HYX8oiAVVPWoW6^I00?o0000oiEWV_nEIiX01OnE
IiX2oha?P@Cooooo00?o0000ooooooooool01_ooool002Oooooo00?o0000ooooooooool0;_ooool7
oiI/W`goUV^O2OnFK9l5ojBKc@SoXI[>3_nSVld00onYW/_oZIc9ojVLb@05ojVLb@SoY9[;1onHU<h8
oj:Ic0;oXIW<3_nEIYX6oiQXVPSoUFNJ1onAI9X>oiAVVPSoVVZI2?nEIiX7ohiRVPSoU6JJ2?nLJiT0
0onEIi[o0000oiEWVP03oiEWVP;oXiC60_n<Ch44ooooo`03o`000?oooooooooo00Kooooo000Xoooo
o`;o0000;oooool7oiI/W`coUV^O1OnFK9l2ojFLc0OoY9_=2?nQV/h;oj>Kc@?oXYW<2OnYW<T7ojBJ
b`OoV9C>1_nRVL`4oi=UVPkoUFJJ1onHJ9X7oiEWVPOoTFBJ3_nDIYX8oiYZV@SoUFNJ1on>HYX8oiAV
VPSoW6^I0_nEIiX00ol0003oXiC6oj>DaP04oj>DaP03oha?POoooooooooo00;ooooo00?o0000oooo
ooooool01_ooool002[ooooo00?o0000ooooooooool0;?ooool7oiI/W`coUV^O0_nFK9l6ojFLc0Oo
Y9_=1onQV/h6oj>Kc@;oXiW<1onRVL`9ojVLb@OoY9[;1onHU<h2oj:Ic0OoTfFJ3_nEIYX7oiQXVPOo
UFNJ1onAI9X>oiAVVPSoVVZI2?nEIiX7ohiRVPSoU6JJ2?nLJiT2oj>DaP03o`000?nSU<KoXiC600Co
XiC60_n<Ch43ooooo`03o`000?oooooooooo00Kooooo000[ooooo`03o`000?oooooooooo02_ooooo
1onFK9l;oiI[W`03ojBKcOnUW<coYIc<00KoYIc<2?nTVld7oj6JcP;oXi_=1_nSVL`6oj:Ic0WoZIc9
1_nTV//3oiIWVPOoUFNJ1onCIIX>oiEVVPOoV6RJ1onEIiX7oi5TVPooU6JJ1onJJYT8oiEWVPOoSV:J
2?nDIYX7oia[V@;o_Z>m0_nSU<H00ol0003oXiC6oj>DaP03oj>DaP;oS4n10oooool00ol0003ooooo
ooooo`06ooooo`00;?ooool00ol0003oooooooooo`0Zooooo`OoUVbO2?nFJil5ojBKc@SoYIc<1onT
Vld6oj6JcP03oj2Hc?nSVLcoXiW<00KoXiW<1onRVL`9ojVLb@;oY9[;1_nFIiX7oiEWVPOoTfFJ3_nE
IYX7oiQXVPOoUFNJ1onAI9X?oiAVVPOoVVZI2?nEIiX7ohiRVPSoU6JJ1_nLJiT3okjS_@?oXiC600?o
0000oj>Da_nSU<H00onSU<H00on<Ch7oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo000]
ooooo`;o0000:_ooool7oiI/W`?oUV^O2_nTVld8ojFLc0SoY9_=0_nQV/h5oj2Hc0SoXiW<1onRVL`7
ojVLb@?oUFNJ1_nFIiX7oiEWVPOoTfFJ3_nEIYX7oiQXVPOoUFNJ1onAI9X?oiAVVPOoVVZI2OnEIiX6
ohiRVPSoU6JJ1OnLJiT4okjS_@?oXiC600?o0000oj>Da_nSU<H00onSU<H00on<Ch7oooooooooo`02
ooooo`03o`000?oooooooooo00Gooooo000_ooooo`03o`000?oooooooooo02Oooooo1OnFK9l@ojBK
c@OoYIc<1_nTVld2ojBJb`OoX9S<2?nSVL`7oj:Ic0CoZIc91_nEIiX7oiIWVPKoUFNJ1onCIIX>oiEV
VPOoV6RJ2?nEIiX7oi5TVPkoU6JJ2?nJJYT8oiEWVPKoSV:J2OnDIYX3oia[V@Ko_Z>m0onSU<H00ol0
003oXiC6oj>DaP02oj>DaP03oha?POoooooooooo00;ooooo00?o0000ooooooooool01Oooool0033o
oooo00?o0000ooooooooool09_ooool2oiI/WaCoY9_=1onUW<`2ojBKc@KoY9[;1onPV<`8oj>Ic0Oo
XYW<00?oZIc9oiEWV_nEIiX01_nEIiX7oiIWVPKoUFNJ1onCIIX>oiEVVPOoV6RJ2?nEIiX7oi5TVPko
U6JJ2?nJJYT8oiEWVPOoSV:J2?nDIYX2oia[V@Oo_Z>m1?nSU<H00ol0003oXiC6oj>DaP02oj>DaPCo
oooo00?o0000ooooooooool01Oooool0037ooooo00?o0000ooooooooool09OoooolFojBKc@KoYIc<
00?oYI[;ojBJbonTV//01_nTV//7oj2Hc0SoXiW<1_nRVL`:oiEWVPOoUVNJ1_nEIiX7oi=UVPkoUFJJ
2?nHJ9X7oiEWVPOoTFBJ3_nDIYX8oiYZV@KoUFNJ0_nSU<H3ogUmb`CoSV:J2?nDIYX00onLJiWo_Z>m
okjS_@06okjS_@GoXiC600Co0000oj>Da_nSU<KoXiC61?ooool00ol0003oooooooooo`05ooooo`00
<_ooool2o`0002Kooooo5_nTVld2ojFLc0GoYI[;2?nTV//7oj2Hc0SoXiW<0_nRVL`=oiEWVPOoUVNJ
1_nEIiX8oi=UVPkoUFJJ1onHJ9X7oiEWVPOoTFBJ3_nDIYX8oiYZV@;oUFNJ1onSU<H5ogUmb`03ohiR
V_nDIY[oU6JJ00;oU6JJ1?nOT/L:okjS_@CoXiC600?o0000oj>Da_ooool01Oooool00ol0003ooooo
ooooo`05ooooo`00=?ooool00ol0003oooooooooo`0SoooooaGoY9_=00?oXi[;ojFJbonUV//01OnU
V//8ojBJb`OoX9S<1_nSVL`4oiAVVPgoUFNJ1onFIiX7oiEWVPOoTfFJ3_nEIYX7oiQXVPOoUFNJ1onA
I9X>oiAVVPOoVVZI00?o]io0oj>Da_nSU<H01onSU<H6ogUmb`WoWi;72OnnXkd2oj>DaP?ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`00=Oooool00ol0003oooooooooo`0S
oooooa7oY9_=1OnSV//7ojFJb`OoY9[;2?nPV<`2oj>Ic0OoU6JJ3OnEIiX7oiIWVPOoUFNJ1onCIIX>
oiEVVPOoV6RJ1onEIiX7oi5TVPooU6JJ1OnJJYT3okNO`0SoXiC61omiOL/8oinBa`Wo_Z>m1_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo000fooooo`03o`000?oooooooooo
02?ooooo2onTVld:oj>Jb`SoYI[;1onTV//4oj2Hc0GoUFNJ2?nDIYX<oiEWVPOoUVNJ1onEIiX7oi=U
VPkoUFJJ1onHJ9X7oiEWVPOoTFBJ3onDIYX3oiYZV@Go]io02OnSU<H6ogUmb`SoWi;72?nnXkd7oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool003Oooooo0_l0000Sooooo`Ko
Y9_=00?oY9[;oj>JbonSV//03OnSV//7ojFJb`KoY9[;2onEIiX7oiAVVPcoUFNJ1onFIiX7oiEWVPOo
TfFJ3_nEIYX7oiQXVPOoUFNJ1onAI9X?oiAVVP;oVVZI1ongWl08oj>DaPOoNGg;2?nOT/L6okjS_@Wo
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`00>Oooool00ol0003ooooo
ooooo`0Qooooo`;oY9_=1OnTV//?oj>Jb`OoYI[;0_nTV//>oiEWVPOoU6JJ3OnEIiX6oiIWVPOoUFNJ
1onCIIX>oiEVVPOoV6RJ2?nEIiX7oi5TVPkoU6JJ00?oVVZIokNO`?ngWl001_ngWl08oj>DaPOoNGg;
2?nOT/L5okjS_@_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`00>_oo
ool00ol0003oooooooooo`0Pooooo`OoY9[;3onSV//6ojFJba7oUFNJ1onDIYX=oiEWVPKoUVNJ1onE
IiX7oi=UVPkoUFJJ1onHJ9X8oiEWVPOoTFBJ3?nDIYX2oinCa`Wo]io02OnSU<H6ogUmb`SoWi;71?nn
Xkd=ooooo`05o`000?ooooooooooooooool000001_ooool003_ooooo00?o0000ooooooooool08?oo
ool7ojBJb`ooXi[;0_nUV//DoiEWVPOoU6JJ3OnEIiX6oiIWVPOoUFNJ1onCIIX>oiEVVPSoV6RJ1onE
IiX7oi5TVPWoU6JJ1_nOTlL9okNO`0SoXiC61omiOL/8oinBa`;o_Z>m3_ooool01Ol0003ooooooooo
oooooooo000000Kooooo000looooo`;o00008?ooool7ojBJb`goXi[;6?nEIiX7oiAVVPgoUFNJ1_nF
IiX7oiEWVPOoTfFJ3_nEIYX8oiQXVPOoUFNJ1onAI9X4oiAVVP?oX9?72?nOTlL9okNO`0KoXiC61Ooo
ool4ogUmb`SoWi;700?o_Z>mooooooooool03_ooool01?l0003oooooooooool00006ooooo`00?_oo
ool00ol0003oooooooooo`0Nooooo`OoY9[;2OnSV//KoiEWVPOoU6JJ3OnEIiX6oiIWVPOoUFNJ1onC
IIX?oiEVVPOoV6RJ1OnEIiX2oj>DaPOoS8S:2?nPTlL8oinCa`Wo]io00_nSU<H<ooooo`03ogUmbonO
T/OoWi;700;oWi;75Oooool00ol0003oooooo`000006ooooo`00?oooool00ol0003oooooooooo`0N
ooooo`KoY9[;1_nSV//NoiEWVPOoU6JJ3OnEIiX6oiIWVPOoUFNJ1onCIIX?oiEVVPOoV6RJ0_nEIiX6
oj>DaPOoS8S:1onPTlL8oinCa`So]io0:Oooool01?l0003oooooooooool00005ooooo`00@?ooool2
o`0001kooooo1onTV//2oj>Jb`;ooooo7onEIiX7oiAVVPgoUFNJ1_nFIiX7oiEWVPSoTfFJ3_nEIYX6
oiQXVP03ojjJ`onSU<KoXiC600KoXiC61on<R<X7oj2Ca`SoWi?71ongWl0[ooooo`03o`000?oooooo
000000Gooooo0012ooooo`03o`000?oooooooooo01cooooo0onTV//7oooooaooUFNJ1onDIYX=oiEW
VPOoUVNJ1onEIiX7oi=UVPkoUFJJ0onHJ9X5ojjJ``OoXiC61on<R<X8oj2Ca`SoWi?71?ngWl0^oooo
o`;o00001Oooool004?ooooo00?o0000ooooooooool09OoooolOoiEWVPOoU6JJ3OnEIiX7oiIWVPOo
UFNJ1onCIIX>oiEVVP03oiQXV_n^V/?o[Y[300Go[Y[32?nSU<H7ohb8bPOoX9?72?nOTlL3okNO`2ko
oooo0ol00005ooooo`00A?ooool00ol0003oooooooooo`0ToooooaooUFNJ1onDIYX=oiEWVPOoUVNJ
1onEIiX7oi=UVPcoUFJJ0_nQTlL8ojjJ``SoXiC61on<R<X7oj2Ca`WoWi?700?o]io0ooooooooool0
:Oooool4o`0000Sooooo0015ooooo`;o00009?oooolOoiEWVPOoU6JJ3OnEIiX7oiIWVPOoUFNJ1onC
IIX9oiEVVPKoXI?72?n^V/<7oj>DaPOoS8S:2?nPTlL4oinCabcooooo1?l0000<ooooo`00Aoooool0
0ol0003oooooooooo`0QoooooaooUFNJ1onDIYX>oiEWVPKoUVNJ1onEIiX7oi=UVPCoUFJJ2onQTlL8
ojjJ``SoXiC61on<R<X5oj2Cabkooooo1?l0000@ooooo`00B?ooool00ol0003oooooooooo`0Poooo
oaooUFNJ1onDIYX>oiEWVPKoUVNJ1onEIiX4oi=UVP?oV8o83onQTlL8ojjJ``KoXiC61oooool2ohb8
bP;oX9?7;_ooool3o`0001Cooooo0019ooooo`03o`000?oooooooooo01oooooo7onEIiX8oiAVVPgo
UFNJ1_nFIiX5oiEWVP;oXiC62?nHSlP?oj6Ca`So[Y[30_nSU<Hhooooo`Co00005oooool004[ooooo
0_l0000Oooooob3oUFNJ1onDIYX=oiEWVPKoUVNJ0_nEIiX6oj>DaPOoV8o83onQTlL7ojjJ`cOooooo
1?l0000Kooooo`00C?ooool00ol0003oooooooooo`0Looooob3oUFNJ1onDIYX=oiEWVPGoUVNJ00?o
YiO5oj>Da_nSU<H01_nSU<H7oiR?b0ooXI?71On^V/<eooooo`Co00007oooool004gooooo00?o0000
ooooooooool06ooooolPoiEWVPOoU6JJ3OnEIiX2oiIWVPGoYiO52?nSU<H7oiR?b0ooXI?70on^V/<b
ooooo`Co00008oooool004kooooo00?o0000ooooooooool06_oooolPoiEWVPOoU6JJ2onEIiX2oj6D
aPOoYiO52?nSU<H7oiR?b0ooXI?700?o[Y[3ooooooooool0;_ooool4o`0002Oooooo001?ooooo`;o
00006_oooolPoiEWVPOoU6JJ2?nEIiX6oj6DaPOoYiO52?nSU<H6oiR?b0coXI?7<?ooool4o`0002_o
oooo001Aooooo`03o`000?oooooooooo01Oooooo8?nEIiX7oiAVVPGoUFNJ00?oXYC6oj6Da_nQU<H0
1_nQU<H7ojNGa@SoXiC61onHSlP5oj6Cac;ooooo1?l0000_ooooo`00D_ooool00ol0003ooooooooo
o`0GoooooaooUFNJ1onDIYX2oiEWVPGoXYC61onQU<H8ojNGa@SoXiC61_nHSlP2oj6Cac7ooooo1?l0
000cooooo`00Doooool00ol0003oooooooooo`0FoooooaooUFNJ1?nDIYX3oinCa`OoXYC62?nQU<H7
ojNGa@KoXiC6>?ooool3o`0003Oooooo001Dooooo`;o00005_oooolNoiEWVP03oj>Da_nOTlOoWi?7
00KoWi?71onRU<H7oj6DaPSoYiO50_nSU<Hgooooo`Co0000>_ooool005Kooooo00?o0000oooooooo
ool04ooooolKoiEWVPGoXiC61onOTlL7oj:DaPOoXIC61onWUlDfooooo`Co0000?_ooool005Oooooo
00?o0000ooooooooool04_oooolHoiEWVP03oj>Ea_nSU<KoXiC600GoXiC61onOTlL8oj:DaPOoXIC6
0onWUlDeooooo`Co0000@_ooool005Sooooo00?o0000ooooooooool04OoooolEoiEWVPGoXiG61onS
U<H7oinCa`OoXYC61onQU<H00onWUlGoooooooooo`0aooooo`Co0000A_ooool005Wooooo0_l0000A
oooooa3oUFNJ0onRU<H7oj>EaPOoXiC61onOTlL8oj:DaP?oXIC6<oooool4o`0004[ooooo001Koooo
o`03o`000?oooooooooo00kooooo2onEIiX9oj:DaPKoXiG62?nSU<H6oinCa`KoXYC6=?ooool4o`00
04kooooo001Looooo`03o`000?oooooooooo00gooooo2?nEIiX<oj:DaPOoXiG61onSU<H7oinCa`;o
XYC6<oooool4o`0005;ooooo001Mooooo`03o`000?oooooooooo00cooooo1OnEIiX00onSU<KoXYC6
oj:DaP0<oj:DaPOoXiG62?nSU<H3oinCacGooooo0ol0001Fooooo`00G_ooool2o`0000cooooo0_nE
IiX5oj>DaPkoXYC61_nSULH6oj>DaSKooooo1?l0001Iooooo`00H?ooool00ol0003oooooooooo`09
ooooo`OoXiC63_nRU<H7oj>EaP;oXiC6=Oooool4o`0005gooooo001Qooooo`03o`000?oooooooooo
00Wooooo1onSU<H=oj:DaPKoXiG6=?ooool4o`00067ooooo001Rooooo`03o`000?oooooooooo00So
oooo1onSU<H>oj:DaP;oXiG6<oooool4o`0006Gooooo001Sooooo`;o00002?ooool8oj>DaP[oXYC6
=?ooool4o`0006Wooooo001Uooooo`03o`000?oooooooooo00Kooooo1onSU<H6oj:DaSCooooo1?l0
001]ooooo`00I_ooool00ol0003oooooooooo`05ooooo`SoXiC60_nRU<H00ol0003oooooooooo`0`
ooooo`Co0000LOooool006Oooooo00?o0000ooooooooool01?ooool6oj>DaP?ooooo00?o0000oooo
ooooool0;_ooool3o`0007Gooooo001Xooooo`;o00001Oooool2oj>DaPKooooo00?o0000oooooooo
ool0:_ooool4o`0007Sooooo001Zooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
9_ooool4o`0007cooooo001[ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool08_oo
ool4o`00083ooooo001/ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool07_ooool4
o`0008Cooooo001]ooooo`;o00002?ooool00ol0003oooooooooo`0Jooooo`Co0000R?ooool006oo
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Fooooo`Co0000S?ooool0073ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`Co0000T?ooool0077ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0>ooooo`Co0000U?ooool007;ooooo0_l00003
ooooo`03o`000?oooooooooo00_ooooo0ol0002Hooooo`00M?ooool01?l0003oooooooooool00009
ooooo`Co0000Voooool007Gooooo00?o0000ooooool000001Oooool4o`0009oooooo001fooooo`;o
000000?oooooo`000?l000000_l0002Sooooo`00Moooool2o`000:Oooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {232.562, 0}} -> {-0.0380384, 0.0227459, \
0.00350305, 0.00350305}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[
      Evaluate[CoranaFunc /. \ {\ x2 \[Rule] \ 0.0, \ 
            x4 \[Rule] \ 0.0}], \ {x1, 0, 2}, {x3, 0, 2}, 
      ColorFunction \[Rule] \((Hue[0.7\ \((1 - #)\)] &)\), 
      ContourLines \[Rule] False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.480769 0.0192308 0.480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -9 -9 ]
[.25962 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -18 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(0.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(1)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .22 1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 .64 1 r
.01923 .44926 m
.05929 .44922 L
.09936 .44924 L
.13942 .44894 L
.17949 .44868 L
.21955 .44916 L
.25962 .44798 L
.29968 .44902 L
.33974 .447 L
.37981 .44642 L
.41987 .44882 L
.45994 .44506 L
.5 .44856 L
.54006 .44347 L
.58013 .44824 L
.62019 .44165 L
.66026 .44065 L
.70032 .44786 L
.74038 .43847 L
.78045 .44742 L
.82051 .43604 L
.86058 .43472 L
.90064 .44693 L
.94071 .43184 L
.98077 .44638 L
.98077 .98077 L
.01923 .98077 L
F
0 .22 1 r
.01923 .47023 m
.05929 .47027 L
.09936 .47025 L
.13942 .47055 L
.17949 .4708 L
.21955 .47033 L
.25962 .4715 L
.29968 .47046 L
.33974 .47247 L
.37981 .47306 L
.41987 .47066 L
.45994 .47441 L
.5 .47092 L
.54006 .47602 L
.58013 .47124 L
.62019 .47787 L
.66026 .4789 L
.70032 .47162 L
.74038 .48115 L
.78045 .47206 L
.82051 .48372 L
.86058 .48514 L
.90064 .47255 L
.94071 .48833 L
.98077 .47309 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .52 m
.05929 .51998 L
.09936 .51999 L
.13942 .51979 L
.17949 .51963 L
.21955 .51994 L
.25962 .51916 L
.29968 .51985 L
.33974 .51851 L
.37981 .51812 L
.41987 .51972 L
.45994 .51719 L
.5 .51955 L
.54006 .51607 L
.58013 .51934 L
.62019 .51475 L
.66026 .51402 L
.70032 .51908 L
.74038 .51239 L
.78045 .51879 L
.82051 .51053 L
.86058 .50951 L
.90064 .51846 L
.94071 .50723 L
.98077 .51809 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .53413 m
.05929 .5341 L
.09936 .53412 L
.13942 .53386 L
.17949 .53365 L
.21955 .53405 L
.25962 .53306 L
.29968 .53393 L
.33974 .53225 L
.37981 .53177 L
.41987 .53376 L
.45994 .53067 L
.5 .53354 L
.54006 .52939 L
.58013 .53328 L
.62019 .52795 L
.66026 .52716 L
.70032 .53296 L
.74038 .52548 L
.78045 .5326 L
.82051 .52365 L
.86058 .52268 L
.90064 .53219 L
.94071 .52062 L
.98077 .53174 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .54578 m
.05929 .54581 L
.09936 .5458 L
.13942 .54605 L
.17949 .54625 L
.21955 .54586 L
.25962 .54683 L
.29968 .54598 L
.33974 .54762 L
.37981 .54809 L
.41987 .54614 L
.45994 .54918 L
.5 .54636 L
.54006 .55045 L
.58013 .54662 L
.62019 .55188 L
.66026 .55266 L
.70032 .54693 L
.74038 .55435 L
.78045 .54728 L
.82051 .55619 L
.86058 .55718 L
.90064 .54768 L
.94071 .55929 L
.98077 .54813 L
.98077 .98077 L
.01923 .98077 L
F
0 .22 1 r
.01923 .55993 m
.05929 .55995 L
.09936 .55994 L
.13942 .56015 L
.17949 .56031 L
.21955 .55999 L
.25962 .5608 L
.29968 .56009 L
.33974 .56147 L
.37981 .56189 L
.41987 .56022 L
.45994 .56286 L
.5 .5604 L
.54006 .56405 L
.58013 .56062 L
.62019 .56545 L
.66026 .56625 L
.70032 .56088 L
.74038 .56803 L
.78045 .56118 L
.82051 .57012 L
.86058 .57131 L
.90064 .56153 L
.94071 .57406 L
.98077 .56191 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .59648 m
.05929 .59646 L
.09936 .59647 L
.13942 .59631 L
.17949 .59617 L
.21955 .59643 L
.25962 .59578 L
.29968 .59636 L
.33974 .59523 L
.37981 .5949 L
.41987 .59625 L
.45994 .5941 L
.5 .59611 L
.54006 .59312 L
.58013 .59593 L
.62019 .59195 L
.66026 .59129 L
.70032 .59572 L
.74038 .58979 L
.78045 .59547 L
.82051 .58804 L
.86058 .58704 L
.90064 .59519 L
.94071 .58477 L
.98077 .59487 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .60666 m
.05929 .60664 L
.09936 .60665 L
.13942 .6065 L
.17949 .60637 L
.21955 .60661 L
.25962 .60602 L
.29968 .60654 L
.33974 .60552 L
.37981 .60521 L
.41987 .60644 L
.45994 .6045 L
.5 .60631 L
.54006 .60363 L
.58013 .60615 L
.62019 .60263 L
.66026 .60206 L
.70032 .60596 L
.74038 .60083 L
.78045 .60573 L
.82051 .59942 L
.86058 .59866 L
.90064 .60548 L
.94071 .59699 L
.98077 .60519 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .61678 m
.05929 .61676 L
.09936 .61677 L
.13942 .61661 L
.17949 .61647 L
.21955 .61673 L
.25962 .61609 L
.29968 .61665 L
.33974 .61557 L
.37981 .61525 L
.41987 .61655 L
.45994 .6145 L
.5 .61641 L
.54006 .61362 L
.58013 .61624 L
.62019 .61259 L
.66026 .61203 L
.70032 .61603 L
.74038 .6108 L
.78045 .61579 L
.82051 .60943 L
.86058 .6087 L
.90064 .61553 L
.94071 .60713 L
.98077 .61523 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .66841 m
.05929 .66843 L
.09936 .66842 L
.13942 .66855 L
.17949 .66866 L
.21955 .66845 L
.25962 .66898 L
.29968 .66851 L
.33974 .66942 L
.37981 .66969 L
.41987 .6686 L
.45994 .67031 L
.5 .66872 L
.54006 .67106 L
.58013 .66886 L
.62019 .67193 L
.66026 .67242 L
.70032 .66903 L
.74038 .67347 L
.78045 .66923 L
.82051 .67465 L
.86058 .67528 L
.90064 .66945 L
.94071 .67666 L
.98077 .66971 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .67707 m
.05929 .67709 L
.09936 .67708 L
.13942 .67721 L
.17949 .67732 L
.21955 .67711 L
.25962 .67763 L
.29968 .67717 L
.33974 .67808 L
.37981 .67835 L
.41987 .67726 L
.45994 .67898 L
.5 .67738 L
.54006 .67975 L
.58013 .67752 L
.62019 .68065 L
.66026 .68116 L
.70032 .67769 L
.74038 .68228 L
.78045 .67789 L
.82051 .68356 L
.86058 .68426 L
.90064 .67811 L
.94071 .68581 L
.98077 .67836 L
.98077 .98077 L
.01923 .98077 L
F
0 .22 1 r
.01923 .68629 m
.05929 .68631 L
.09936 .6863 L
.13942 .68645 L
.17949 .68658 L
.21955 .68634 L
.25962 .68695 L
.29968 .68641 L
.33974 .68747 L
.37981 .68779 L
.41987 .68651 L
.45994 .68856 L
.5 .68665 L
.54006 .68952 L
.58013 .68681 L
.62019 .69067 L
.66026 .69133 L
.70032 .68701 L
.74038 .69286 L
.78045 .68725 L
.82051 .69474 L
.86058 .69585 L
.90064 .68751 L
.94071 .69863 L
.98077 .68782 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .70922 m
.05929 .70921 L
.09936 .70922 L
.13942 .7091 L
.17949 .70901 L
.21955 .70919 L
.25962 .70873 L
.29968 .70913 L
.33974 .70835 L
.37981 .70811 L
.41987 .70906 L
.45994 .70755 L
.5 .70896 L
.54006 .70686 L
.58013 .70883 L
.62019 .70605 L
.66026 .70559 L
.70032 .70869 L
.74038 .70455 L
.78045 .70851 L
.82051 .70334 L
.86058 .70266 L
.90064 .70832 L
.94071 .70112 L
.98077 .70809 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .71632 m
.05929 .71631 L
.09936 .71631 L
.13942 .71621 L
.17949 .71612 L
.21955 .71629 L
.25962 .71588 L
.29968 .71624 L
.33974 .71553 L
.37981 .71532 L
.41987 .71617 L
.45994 .71482 L
.5 .71608 L
.54006 .71423 L
.58013 .71597 L
.62019 .71352 L
.66026 .71313 L
.70032 .71583 L
.74038 .71227 L
.78045 .71568 L
.82051 .71129 L
.86058 .71075 L
.90064 .7155 L
.94071 .70958 L
.98077 .71531 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .72311 m
.05929 .7231 L
.09936 .7231 L
.13942 .723 L
.17949 .72291 L
.21955 .72308 L
.25962 .72266 L
.29968 .72303 L
.33974 .72232 L
.37981 .72211 L
.41987 .72296 L
.45994 .72162 L
.5 .72287 L
.54006 .72103 L
.58013 .72276 L
.62019 .72035 L
.66026 .71997 L
.70032 .72262 L
.74038 .71914 L
.78045 .72247 L
.82051 .71822 L
.86058 .71772 L
.90064 .72229 L
.94071 .71664 L
.98077 .7221 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .1 r
.01923 .7303 m
.05929 .73028 L
.09936 .73029 L
.13942 .73017 L
.17949 .73007 L
.21955 .73026 L
.25962 .7298 L
.29968 .7302 L
.33974 .72942 L
.37981 .72919 L
.41987 .73013 L
.45994 .72865 L
.5 .73003 L
.54006 .72801 L
.58013 .7299 L
.62019 .72728 L
.66026 .72688 L
.70032 .72975 L
.74038 .72601 L
.78045 .72958 L
.82051 .72505 L
.86058 .72453 L
.90064 .72939 L
.94071 .72343 L
.98077 .72917 L
.98077 .98077 L
.01923 .98077 L
F
.32 1 0 r
.01923 .73927 m
.05929 .73925 L
.09936 .73926 L
.13942 .73909 L
.17949 .73895 L
.21955 .73922 L
.25962 .73856 L
.29968 .73914 L
.33974 .73803 L
.37981 .73771 L
.41987 .73903 L
.45994 .73699 L
.5 .73888 L
.54006 .73615 L
.58013 .7387 L
.62019 .73522 L
.66026 .73472 L
.70032 .73849 L
.74038 .73366 L
.78045 .73825 L
.82051 .73251 L
.86058 .73191 L
.90064 .73799 L
.94071 .73066 L
.98077 .73769 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .1 r
.01923 .74146 m
.05929 .74148 L
.09936 .74147 L
.13942 .74163 L
.17949 .74177 L
.21955 .74151 L
.25962 .74215 L
.29968 .74158 L
.33974 .74267 L
.37981 .74297 L
.41987 .74169 L
.45994 .74368 L
.5 .74183 L
.54006 .74449 L
.58013 .74201 L
.62019 .7454 L
.66026 .7459 L
.70032 .74221 L
.74038 .74694 L
.78045 .74244 L
.82051 .74807 L
.86058 .74866 L
.90064 .7427 L
.94071 .7499 L
.98077 .74299 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .75027 m
.05929 .75028 L
.09936 .75027 L
.13942 .75039 L
.17949 .75048 L
.21955 .7503 L
.25962 .75076 L
.29968 .75036 L
.33974 .75114 L
.37981 .75137 L
.41987 .75043 L
.45994 .7519 L
.5 .75053 L
.54006 .75254 L
.58013 .75066 L
.62019 .75327 L
.66026 .75367 L
.70032 .7508 L
.74038 .75454 L
.78045 .75097 L
.82051 .75551 L
.86058 .75603 L
.90064 .75117 L
.94071 .75714 L
.98077 .75138 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .75747 m
.05929 .75748 L
.09936 .75747 L
.13942 .75758 L
.17949 .75767 L
.21955 .7575 L
.25962 .75792 L
.29968 .75755 L
.33974 .75827 L
.37981 .75848 L
.41987 .75762 L
.45994 .75898 L
.5 .75771 L
.54006 .75957 L
.58013 .75782 L
.62019 .76027 L
.66026 .76066 L
.70032 .75796 L
.74038 .76151 L
.78045 .75812 L
.82051 .76246 L
.86058 .76298 L
.90064 .75829 L
.94071 .7641 L
.98077 .75849 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .76444 m
.05929 .76445 L
.09936 .76445 L
.13942 .76456 L
.17949 .76465 L
.21955 .76447 L
.25962 .7649 L
.29968 .76452 L
.33974 .76527 L
.37981 .76549 L
.41987 .7646 L
.45994 .76601 L
.5 .76469 L
.54006 .76664 L
.58013 .76481 L
.62019 .76739 L
.66026 .76781 L
.70032 .76495 L
.74038 .76874 L
.78045 .76511 L
.82051 .76981 L
.86058 .7704 L
.90064 .76529 L
.94071 .7717 L
.98077 .7655 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .79463 m
.05929 .79462 L
.09936 .79463 L
.13942 .79453 L
.17949 .79445 L
.21955 .7946 L
.25962 .79423 L
.29968 .79456 L
.33974 .7939 L
.37981 .79371 L
.41987 .7945 L
.45994 .79324 L
.5 .79441 L
.54006 .79268 L
.58013 .79431 L
.62019 .79201 L
.66026 .79164 L
.70032 .79419 L
.74038 .7908 L
.78045 .79404 L
.82051 .78984 L
.86058 .78931 L
.90064 .79388 L
.94071 .78814 L
.98077 .7937 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .80061 m
.05929 .8006 L
.09936 .80061 L
.13942 .80052 L
.17949 .80044 L
.21955 .80058 L
.25962 .80024 L
.29968 .80054 L
.33974 .79995 L
.37981 .79977 L
.41987 .80048 L
.45994 .79935 L
.5 .80041 L
.54006 .79885 L
.58013 .80031 L
.62019 .79825 L
.66026 .79792 L
.70032 .8002 L
.74038 .79719 L
.78045 .80007 L
.82051 .79636 L
.86058 .79591 L
.90064 .79992 L
.94071 .79493 L
.98077 .79976 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .1 r
.01923 .80624 m
.05929 .80623 L
.09936 .80624 L
.13942 .80615 L
.17949 .80608 L
.21955 .80622 L
.25962 .80588 L
.29968 .80618 L
.33974 .8056 L
.37981 .80543 L
.41987 .80612 L
.45994 .80503 L
.5 .80605 L
.54006 .80455 L
.58013 .80596 L
.62019 .80398 L
.66026 .80367 L
.70032 .80585 L
.74038 .80298 L
.78045 .80572 L
.82051 .80221 L
.86058 .80179 L
.90064 .80558 L
.94071 .80088 L
.98077 .80542 L
.98077 .98077 L
.01923 .98077 L
F
.32 1 0 r
.01923 .81183 m
.05929 .81182 L
.09936 .81183 L
.13942 .81174 L
.17949 .81167 L
.21955 .81181 L
.25962 .81147 L
.29968 .81177 L
.33974 .81118 L
.37981 .81101 L
.41987 .81171 L
.45994 .81061 L
.5 .81163 L
.54006 .81012 L
.58013 .81154 L
.62019 .80956 L
.66026 .80925 L
.70032 .81143 L
.74038 .80856 L
.78045 .81131 L
.82051 .8078 L
.86058 .80739 L
.90064 .81116 L
.94071 .80651 L
.98077 .811 L
.98077 .98077 L
.01923 .98077 L
F
.74 1 0 r
.01923 .81764 m
.05929 .81763 L
.09936 .81764 L
.13942 .81755 L
.17949 .81747 L
.21955 .81761 L
.25962 .81725 L
.29968 .81757 L
.33974 .81695 L
.37981 .81677 L
.41987 .81751 L
.45994 .81634 L
.5 .81743 L
.54006 .81583 L
.58013 .81733 L
.62019 .81524 L
.66026 .81492 L
.70032 .81722 L
.74038 .81421 L
.78045 .81708 L
.82051 .81342 L
.86058 .813 L
.90064 .81693 L
.94071 .8121 L
.98077 .81676 L
.98077 .98077 L
.01923 .98077 L
F
1 .84 0 r
.01923 .82687 m
.05929 .82685 L
.09936 .82686 L
.13942 .82665 L
.17949 .82648 L
.21955 .82681 L
.25962 .826 L
.29968 .82671 L
.33974 .82535 L
.37981 .82496 L
.41987 .82657 L
.45994 .82408 L
.5 .8264 L
.54006 .82306 L
.58013 .82618 L
.62019 .82193 L
.66026 .82132 L
.70032 .82592 L
.73553 .82051 L
.74038 .82022 L
.7451 .82051 L
.78045 .82563 L
.80975 .82051 L
.82051 .81936 L
.86058 .8189 L
.87413 .82051 L
.90064 .8253 L
.92038 .82051 L
.94071 .81793 L
.97393 .82051 L
.98077 .82494 L
.98077 .98077 L
.01923 .98077 L
F
.74 1 0 r
.01923 .86175 m
.05929 .86176 L
.09936 .86176 L
.13942 .86184 L
.17949 .86192 L
.21955 .86178 L
.25962 .86212 L
.29968 .86182 L
.33974 .86241 L
.37981 .86258 L
.41987 .86188 L
.45994 .86298 L
.5 .86195 L
.54006 .86346 L
.58013 .86205 L
.62019 .86402 L
.66026 .86432 L
.70032 .86216 L
.74038 .86498 L
.78045 .86228 L
.82051 .86572 L
.86058 .86611 L
.90064 .86243 L
.94071 .86694 L
.98077 .86259 L
.98077 .98077 L
.01923 .98077 L
F
.32 1 0 r
.01923 .86719 m
.05929 .8672 L
.09936 .86719 L
.13942 .86727 L
.17949 .86734 L
.21955 .86721 L
.25962 .86752 L
.29968 .86725 L
.33974 .86778 L
.37981 .86794 L
.41987 .8673 L
.45994 .86831 L
.5 .86737 L
.54006 .86876 L
.58013 .86745 L
.62019 .86927 L
.66026 .86956 L
.70032 .86756 L
.74038 .87018 L
.78045 .86767 L
.82051 .87087 L
.86058 .87124 L
.90064 .8678 L
.94071 .87204 L
.98077 .86795 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .1 r
.01923 .87228 m
.05929 .87228 L
.09936 .87228 L
.13942 .87236 L
.17949 .87242 L
.21955 .8723 L
.25962 .8726 L
.29968 .87233 L
.33974 .87285 L
.37981 .87301 L
.41987 .87239 L
.45994 .87337 L
.5 .87245 L
.54006 .8738 L
.58013 .87253 L
.62019 .8743 L
.66026 .87458 L
.70032 .87263 L
.74038 .8752 L
.78045 .87274 L
.82051 .87588 L
.86058 .87625 L
.90064 .87287 L
.94071 .87705 L
.98077 .87302 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .87729 m
.05929 .8773 L
.09936 .8773 L
.13942 .87737 L
.17949 .87744 L
.21955 .87732 L
.25962 .87762 L
.29968 .87735 L
.33974 .87788 L
.37981 .87803 L
.41987 .8774 L
.45994 .8784 L
.5 .87747 L
.54006 .87884 L
.58013 .87755 L
.62019 .87935 L
.66026 .87964 L
.70032 .87765 L
.74038 .88027 L
.78045 .87776 L
.82051 .88099 L
.86058 .88138 L
.90064 .87789 L
.94071 .88221 L
.98077 .87804 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .88247 m
.05929 .88248 L
.09936 .88247 L
.13942 .88256 L
.17949 .88262 L
.21955 .88249 L
.25962 .88282 L
.29968 .88253 L
.33974 .88309 L
.37981 .88325 L
.41987 .88259 L
.45994 .88365 L
.5 .88266 L
.54006 .88412 L
.58013 .88274 L
.62019 .88468 L
.66026 .88499 L
.70032 .88285 L
.74038 .88568 L
.78045 .88297 L
.82051 .88647 L
.86058 .8869 L
.90064 .88311 L
.94071 .88785 L
.98077 .88327 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .88814 m
.05929 .88815 L
.09936 .88814 L
.13942 .88823 L
.17949 .88831 L
.21955 .88816 L
.25962 .88853 L
.29968 .88821 L
.33974 .88884 L
.37981 .88904 L
.41987 .88827 L
.45994 .88949 L
.5 .88835 L
.54006 .89005 L
.58013 .88845 L
.62019 .89071 L
.66026 .89108 L
.70032 .88857 L
.74038 .89193 L
.78045 .88871 L
.82051 .89291 L
.86058 .89346 L
.90064 .88887 L
.94071 .89469 L
.98077 .88905 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .90903 m
.05929 .90903 L
.09936 .90903 L
.13942 .90896 L
.17949 .9089 L
.21955 .90901 L
.25962 .90873 L
.29968 .90898 L
.33974 .90849 L
.37981 .90834 L
.41987 .90893 L
.45994 .90799 L
.5 .90887 L
.54006 .90757 L
.58013 .90879 L
.62019 .90708 L
.66026 .9068 L
.70032 .9087 L
.74038 .90618 L
.78045 .90859 L
.82051 .90547 L
.86058 .90508 L
.90064 .90847 L
.94071 .90422 L
.98077 .90833 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .91353 m
.05929 .91352 L
.09936 .91352 L
.13942 .91346 L
.17949 .9134 L
.21955 .91351 L
.25962 .91325 L
.29968 .91348 L
.33974 .91303 L
.37981 .91289 L
.41987 .91343 L
.45994 .91258 L
.5 .91338 L
.54006 .9122 L
.58013 .91331 L
.62019 .91175 L
.66026 .9115 L
.70032 .91322 L
.74038 .91095 L
.78045 .91312 L
.82051 .91033 L
.86058 .90999 L
.90064 .91301 L
.94071 .90926 L
.98077 .91289 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .1 r
.01923 .91776 m
.05929 .91775 L
.09936 .91776 L
.13942 .91769 L
.17949 .91764 L
.21955 .91774 L
.25962 .91749 L
.29968 .91771 L
.33974 .91728 L
.37981 .91715 L
.41987 .91767 L
.45994 .91685 L
.5 .91762 L
.54006 .91649 L
.58013 .91755 L
.62019 .91607 L
.66026 .91583 L
.70032 .91747 L
.74038 .91531 L
.78045 .91737 L
.82051 .91473 L
.86058 .91442 L
.90064 .91727 L
.94071 .91373 L
.98077 .91714 L
.98077 .98077 L
.01923 .98077 L
F
.32 1 0 r
.01923 .92192 m
.05929 .92191 L
.09936 .92192 L
.13942 .92185 L
.17949 .9218 L
.21955 .9219 L
.25962 .92165 L
.29968 .92187 L
.33974 .92144 L
.37981 .92131 L
.41987 .92183 L
.45994 .92101 L
.5 .92177 L
.54006 .92065 L
.58013 .92171 L
.62019 .92024 L
.66026 .92 L
.70032 .92162 L
.74038 .9195 L
.78045 .92153 L
.82051 .91893 L
.86058 .91862 L
.90064 .92142 L
.94071 .91796 L
.98077 .9213 L
.98077 .98077 L
.01923 .98077 L
F
.74 1 0 r
.01923 .92615 m
.05929 .92615 L
.09936 .92615 L
.13942 .92608 L
.17949 .92603 L
.21955 .92613 L
.25962 .92587 L
.29968 .9261 L
.33974 .92566 L
.37981 .92553 L
.41987 .92606 L
.45994 .92522 L
.5 .926 L
.54006 .92485 L
.58013 .92593 L
.62019 .92442 L
.66026 .92418 L
.70032 .92585 L
.74038 .92367 L
.78045 .92575 L
.82051 .92309 L
.86058 .92278 L
.90064 .92564 L
.94071 .92212 L
.98077 .92552 L
.98077 .98077 L
.01923 .98077 L
F
1 .84 0 r
.01923 .93065 m
.05929 .93064 L
.09936 .93064 L
.13942 .93057 L
.17949 .93051 L
.21955 .93062 L
.25962 .93034 L
.29968 .93059 L
.33974 .93011 L
.37981 .92997 L
.41987 .93054 L
.45994 .92963 L
.5 .93048 L
.54006 .92924 L
.58013 .93041 L
.62019 .92878 L
.66026 .92853 L
.70032 .93031 L
.74038 .92798 L
.78045 .93021 L
.82051 .92737 L
.86058 .92705 L
.90064 .93009 L
.94071 .92636 L
.98077 .92996 L
.98077 .98077 L
.01923 .98077 L
F
1 .42 0 r
.01923 .93573 m
.05929 .93572 L
.09936 .93572 L
.13942 .93564 L
.17949 .93557 L
.21955 .9357 L
.25962 .93537 L
.29968 .93566 L
.33974 .93509 L
.37981 .93493 L
.41987 .93561 L
.45994 .93454 L
.5 .93553 L
.54006 .93409 L
.58013 .93544 L
.62019 .93356 L
.66026 .93328 L
.70032 .93533 L
.74038 .93266 L
.78045 .93521 L
.82051 .93199 L
.86058 .93163 L
.90064 .93507 L
.94071 .93087 L
.98077 .93492 L
.98077 .98077 L
.01923 .98077 L
F
1 .84 0 r
.01923 .96449 m
.05929 .9645 L
.09936 .9645 L
.13942 .96456 L
.17949 .96461 L
.21955 .96451 L
.25962 .96475 L
.29968 .96454 L
.33974 .96495 L
.37981 .96507 L
.41987 .96458 L
.45994 .96534 L
.5 .96463 L
.54006 .96566 L
.58013 .9647 L
.62019 .96603 L
.66026 .96623 L
.70032 .96478 L
.74038 .96665 L
.78045 .96487 L
.82051 .9671 L
.86058 .96734 L
.90064 .96497 L
.94071 .96784 L
.98077 .96508 L
.98077 .98077 L
.01923 .98077 L
F
.74 1 0 r
.01923 .96799 m
.05929 .968 L
.09936 .96799 L
.13942 .96804 L
.17949 .96808 L
.21955 .96801 L
.25962 .96819 L
.29968 .96803 L
.33974 .96834 L
.37981 .96843 L
.41987 .96806 L
.45994 .96864 L
.5 .9681 L
.54006 .96889 L
.58013 .96815 L
.62019 .96918 L
.66026 .96934 L
.70032 .96821 L
.74038 .96968 L
.78045 .96827 L
.82051 .97004 L
.86058 .97024 L
.90064 .96835 L
.94071 .97065 L
.98077 .96844 L
.98077 .98077 L
.01923 .98077 L
F
.32 1 0 r
.01923 .97077 m
.05929 .97078 L
.09936 .97078 L
.13942 .97081 L
.17949 .97085 L
.21955 .97079 L
.25962 .97094 L
.29968 .9708 L
.33974 .97106 L
.37981 .97114 L
.41987 .97083 L
.45994 .97132 L
.5 .97086 L
.54006 .97153 L
.58013 .9709 L
.62019 .97177 L
.66026 .9719 L
.70032 .97095 L
.74038 .97219 L
.78045 .97101 L
.82051 .97251 L
.86058 .97267 L
.90064 .97107 L
.94071 .97303 L
.98077 .97114 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .1 r
.01923 .97314 m
.05929 .97314 L
.09936 .97314 L
.13942 .97317 L
.17949 .9732 L
.21955 .97315 L
.25962 .97328 L
.29968 .97316 L
.33974 .97339 L
.37981 .97345 L
.41987 .97318 L
.45994 .97361 L
.5 .97321 L
.54006 .97379 L
.58013 .97325 L
.62019 .97401 L
.66026 .97412 L
.70032 .97329 L
.74038 .97438 L
.78045 .97334 L
.82051 .97466 L
.86058 .9748 L
.90064 .9734 L
.94071 .97512 L
.98077 .97346 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .97521 m
.05929 .97522 L
.09936 .97522 L
.13942 .97525 L
.17949 .97527 L
.21955 .97522 L
.25962 .97534 L
.29968 .97524 L
.33974 .97544 L
.37981 .9755 L
.41987 .97526 L
.45994 .97564 L
.5 .97528 L
.54006 .9758 L
.58013 .97531 L
.62019 .97599 L
.66026 .9761 L
.70032 .97535 L
.74038 .97633 L
.78045 .9754 L
.82051 .97658 L
.86058 .97671 L
.90064 .97545 L
.94071 .977 L
.98077 .9755 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .97708 m
.05929 .97709 L
.09936 .97709 L
.13942 .97711 L
.17949 .97714 L
.21955 .97709 L
.25962 .9772 L
.29968 .97711 L
.33974 .97729 L
.37981 .97734 L
.41987 .97712 L
.45994 .97747 L
.5 .97715 L
.54006 .97762 L
.58013 .97718 L
.62019 .97779 L
.66026 .97789 L
.70032 .97721 L
.74038 .9781 L
.78045 .97725 L
.82051 .97833 L
.86058 .97845 L
.90064 .9773 L
.94071 .97872 L
.98077 .97735 L
.98077 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .97879 m
.05929 .9788 L
.09936 .9788 L
.13942 .97882 L
.17949 .97884 L
.21955 .9788 L
.25962 .9789 L
.29968 .97881 L
.33974 .97898 L
.37981 .97903 L
.41987 .97883 L
.45994 .97915 L
.5 .97885 L
.54006 .97929 L
.58013 .97888 L
.62019 .97945 L
.66026 .97954 L
.70032 .97891 L
.74038 .97973 L
.78045 .97895 L
.82051 .97995 L
.86058 .98006 L
.90064 .97899 L
.94071 .9803 L
.98077 .97904 L
.98077 .98077 L
.01923 .98077 L
F
0 .22 1 r
.01923 .78778 m
.05929 .78776 L
.09936 .78777 L
.13942 .78765 L
.17949 .78756 L
.21955 .78774 L
.25962 .78728 L
.29968 .78769 L
.33974 .78688 L
.37981 .78663 L
.41987 .78761 L
.45994 .78605 L
.5 .78751 L
.54006 .78532 L
.58013 .78738 L
.62019 .78445 L
.66026 .78394 L
.70032 .78723 L
.74038 .78278 L
.78045 .78705 L
.82051 .78138 L
.86058 .78056 L
.90064 .78685 L
.93209 .78045 L
.90064 .77313 L
.86058 .78031 L
.82051 .77933 L
.78045 .77291 L
.74038 .7777 L
.70032 .77271 L
.66026 .77638 L
.62019 .77581 L
.58013 .77254 L
.54006 .77483 L
.5 .7724 L
.45994 .77402 L
.41987 .77229 L
.37981 .77337 L
.33974 .7731 L
.29968 .7722 L
.25962 .77266 L
.21955 .77214 L
.17949 .77235 L
.13942 .77224 L
.09936 .77211 L
.05929 .77212 L
.01923 .7721 L
F
.2 0 1 r
.01923 .32512 m
.05929 .32506 L
.09936 .32509 L
.13942 .32456 L
.17949 .32413 L
.21955 .32496 L
.25962 .32288 L
.29968 .32472 L
.33974 .32113 L
.37981 .32005 L
.41987 .32437 L
.45994 .31747 L
.5 .32391 L
.54006 .31427 L
.58013 .32335 L
.62019 .31027 L
.66026 .30789 L
.70032 .32267 L
.74038 .30188 L
.78045 .32189 L
.8145 .29968 L
.78045 .25995 L
.74038 .29455 L
.70224 .25962 L
.74038 .22701 L
.78045 .25924 L
.81866 .21955 L
.80492 .17949 L
.81196 .13942 L
.82051 .10271 L
.82149 .09936 L
.82051 .05936 L
.82051 .05929 L
.82051 .02971 L
.82246 .01923 L
.01923 .01923 L
F
0 .22 1 r
.01923 .90395 m
.05929 .90394 L
.09936 .90395 L
.13942 .90386 L
.17949 .90379 L
.21955 .90392 L
.25962 .90359 L
.29968 .90389 L
.33974 .9033 L
.37981 .90312 L
.41987 .90383 L
.45994 .9027 L
.5 .90375 L
.54006 .90218 L
.58013 .90366 L
.62019 .90156 L
.66026 .9012 L
.70032 .90355 L
.73651 .90064 L
.70032 .89568 L
.66026 .89955 L
.62019 .89891 L
.58013 .89551 L
.54006 .89784 L
.5 .89537 L
.45994 .897 L
.41987 .89526 L
.37981 .89634 L
.33974 .89606 L
.29968 .89518 L
.25962 .89563 L
.21955 .89512 L
.17949 .89532 L
.13942 .89522 L
.09936 .89509 L
.05929 .8951 L
.01923 .89508 L
F
.2 0 1 r
.01923 .43095 m
.05929 .43092 L
.09936 .43094 L
.13942 .43065 L
.17949 .43041 L
.21955 .43086 L
.25962 .42973 L
.29968 .43073 L
.33974 .42876 L
.37981 .42816 L
.41987 .43054 L
.45994 .42672 L
.5 .43029 L
.54006 .42492 L
.58013 .42998 L
.62019 .42268 L
.66026 .42135 L
.70032 .42961 L
.73399 .41987 L
.70032 .40176 L
.66026 .41586 L
.62019 .41312 L
.58013 .40121 L
.54006 .40913 L
.5 .40074 L
.45994 .40621 L
.41987 .40037 L
.37981 .40397 L
.33974 .40306 L
.29968 .40009 L
.25962 .40159 L
.21955 .39989 L
.17949 .40056 L
.13942 .40021 L
.09936 .39978 L
.05929 .39981 L
.01923 .39976 L
F
.01923 .50652 m
.05929 .50649 L
.09936 .5065 L
.13942 .50627 L
.17949 .50608 L
.21955 .50645 L
.25962 .50553 L
.29968 .50634 L
.33974 .50474 L
.37981 .50425 L
.41987 .50619 L
.45994 .50306 L
.5 .50599 L
.54006 .50155 L
.58013 .50573 L
.61821 .5 L
.58013 .49047 L
.54006 .49702 L
.5 .49011 L
.45994 .49451 L
.41987 .48982 L
.37981 .49267 L
.33974 .49194 L
.29968 .4896 L
.25962 .49077 L
.21955 .48945 L
.17949 .48997 L
.13942 .48969 L
.09936 .48936 L
.05929 .48938 L
.01923 .48934 L
F
0 .22 1 r
.01923 .98038 m
.05929 .98038 L
.09936 .98038 L
.13942 .9804 L
.17949 .98042 L
.21955 .98038 L
.25962 .98048 L
.29968 .98039 L
.33974 .98055 L
.37981 .9806 L
.41987 .98041 L
.45994 .98071 L
.5 .98043 L
.5318 .98077 L
.01923 .98077 L
F
.2 0 1 r
.01923 .58404 m
.05929 .58401 L
.09936 .58403 L
.13942 .58378 L
.17949 .58358 L
.21955 .58396 L
.25962 .583 L
.29968 .58385 L
.33974 .58214 L
.37981 .5816 L
.41987 .58369 L
.45994 .58025 L
.5 .58348 L
.52662 .58013 L
.5 .57566 L
.45994 .57996 L
.41987 .57539 L
.37981 .57808 L
.33974 .57737 L
.29968 .57519 L
.25962 .57627 L
.21955 .57506 L
.17949 .57553 L
.13942 .57528 L
.09936 .57498 L
.05929 .575 L
.01923 .57496 L
F
.01923 .70063 m
.05929 .70061 L
.09936 .70062 L
.13942 .70046 L
.17949 .70033 L
.21955 .70058 L
.23537 .70032 L
.21955 .69974 L
.17949 .70031 L
.13942 .7 L
.09936 .69965 L
.05929 .69967 L
.01923 .69963 L
F
.29968 .6999 m
.30861 .70032 L
.29968 .70051 L
.28361 .70032 L
F
0 .22 1 r
.33974 .25707 m
.37981 .25443 L
.39537 .25962 L
.37981 .26433 L
.33974 .26189 L
.33067 .25962 L
F
0 1 .1 r
.37981 .63203 m
.38477 .66026 L
.37981 .66043 L
.34741 .66026 L
F
.2 0 1 r
.41987 .70014 m
.42175 .70032 L
.41987 .7004 L
.41498 .70032 L
F
0 .22 1 r
.45994 .24914 m
.48602 .25962 L
.45994 .26937 L
.43392 .25962 L
F
0 1 .1 r
.45994 .63002 m
.47862 .66026 L
.45994 .66115 L
.44092 .66026 L
F
1 0 0 r
.45994 .94068 m
.46098 .94071 L
.45994 .9607 L
.45882 .94071 L
F
0 .22 1 r
.54006 .24363 m
.57205 .25962 L
.54006 .27483 L
.50888 .25962 L
F
0 1 .1 r
.54006 .62787 m
.56603 .66026 L
.54006 .662 L
.51422 .66026 L
F
1 0 0 r
.54006 .94005 m
.55451 .94071 L
.54006 .96121 L
.52532 .94071 L
F
0 .64 1 r
.54006 .35827 m
.54477 .37981 L
.54006 .38058 L
.53517 .37981 L
F
0 .22 1 r
.60523 .98077 m
.58013 .98046 L
.54807 .98077 L
F
.2 0 1 r
.58013 .57599 m
.60167 .58013 L
.58013 .58322 L
.5532 .58013 L
F
0 .22 1 r
.62019 .23765 m
.66026 .2344 L
.69657 .25962 L
.66026 .28471 L
.62019 .28107 L
.58643 .25962 L
F
0 1 .1 r
.62019 .62561 m
.66026 .62445 L
.69115 .66026 L
.66026 .66351 L
.62019 .66298 L
.59147 .66026 L
F
1 0 0 r
.62019 .93935 m
.66026 .93898 L
.68239 .94071 L
.66026 .96205 L
.62019 .96176 L
.6007 .94071 L
F
0 .64 1 r
.62019 .35003 m
.66026 .3465 L
.67655 .37981 L
.66026 .38519 L
.62019 .3836 L
.60725 .37981 L
F
0 .22 1 r
.66026 .16925 m
.66135 .17949 L
.66026 .18112 L
.6295 .17949 L
F
.2 0 1 r
.70032 .49091 m
.72403 .5 L
.70032 .50543 L
.66723 .5 L
F
0 .22 1 r
.71533 .98077 m
.70032 .98048 L
.67833 .98077 L
F
.2 0 1 r
.70032 .5764 m
.71286 .58013 L
.70032 .5829 L
.68151 .58013 L
F
0 1 .1 r
.74038 .62207 m
.77623 .66026 L
.74038 .66466 L
.70571 .66026 L
F
1 0 0 r
.74038 .93819 m
.76883 .94071 L
.74038 .96266 L
.71218 .94071 L
F
0 .64 1 r
.74038 .33987 m
.76401 .37981 L
.74038 .38856 L
.71673 .37981 L
F
0 .22 1 r
.74038 .13773 m
.74121 .13942 L
.75205 .17949 L
.74038 .19728 L
.7285 .17949 L
.73953 .13942 L
F
0 1 .94 r
.74038 .45919 m
.74293 .45994 L
.74038 .46064 L
.73776 .45994 L
F
0 .22 1 r
.78045 .89587 m
.81033 .90064 L
.78045 .90342 L
.74414 .90064 L
F
.2 0 1 r
.78045 .40242 m
.80878 .41987 L
.78045 .42918 L
.74662 .41987 L
F
.78045 .49143 m
.80137 .5 L
.78045 .50508 L
.75654 .5 L
F
0 .22 1 r
.79372 .98077 m
.78045 .98052 L
.76547 .98077 L
F
.2 0 1 r
.78045 .57688 m
.79137 .58013 L
.78045 .58252 L
.76811 .58013 L
F
0 1 .1 r
.82051 .61982 m
.86058 .619 L
.86648 .62019 L
.89937 .66026 L
.86058 .66658 L
.82051 .66591 L
.78408 .66026 L
.81846 .62019 L
F
1 0 0 r
.82051 .93735 m
.86058 .93691 L
.89201 .94071 L
.86058 .96362 L
.82051 .9633 L
.79072 .94071 L
F
0 .64 1 r
.82051 .33482 m
.86058 .33222 L
.87167 .33974 L
.88777 .37981 L
.86058 .39418 L
.82051 .39222 L
.79501 .37981 L
.81252 .33974 L
F
0 1 .94 r
.82051 .45544 m
.86058 .45367 L
.87298 .45994 L
.86058 .46591 L
.82051 .46421 L
.81104 .45994 L
F
0 1 .52 r
.82051 .5395 m
.86058 .53792 L
.86605 .54006 L
.86058 .54211 L
.82051 .5406 L
.81897 .54006 L
F
.2 0 1 r
.929 .01923 m
.92819 .05929 L
.9286 .09936 L
.92201 .13942 L
.91677 .17949 L
.92688 .21955 L
.90064 .25672 L
.86632 .21955 L
.8785 .17949 L
.87216 .13942 L
.86423 .09936 L
.86474 .05929 L
.86376 .01923 L
F
.90064 .26221 m
.92388 .29968 L
.90064 .32099 L
.86993 .29968 L
F
0 .22 1 r
.90064 .8961 m
.92081 .90064 L
.90064 .90328 L
.87361 .90064 L
F
.2 0 1 r
.90064 .40317 m
.91966 .41987 L
.90064 .42868 L
.875 .41987 L
F
.90064 .49203 m
.9141 .5 L
.90064 .50468 L
.88176 .5 L
F
0 .22 1 r
.90835 .98077 m
.90064 .98056 L
.88903 .98077 L
F
.2 0 1 r
.90064 .57746 m
.9066 .58013 L
.90064 .58207 L
.89135 .58013 L
F
0 1 .1 r
.98077 .66045 m
.94071 .66799 L
.9013 .66026 L
.92674 .62019 L
.94071 .61729 L
.97043 .62019 L
.98077 .63197 L
F
1 0 0 r
.94071 .93599 m
.97975 .94071 L
.94071 .9643 L
.90611 .94071 L
F
0 .64 1 r
.94071 .32675 m
.97287 .33974 L
.9787 .37981 L
.94071 .39844 L
.90932 .37981 L
.92242 .33974 L
F
0 1 .94 r
.94071 .45023 m
.97344 .45994 L
.94071 .46928 L
.92133 .45994 L
F
0 1 .52 r
.94071 .53495 m
.97021 .54006 L
.94071 .54498 L
.9271 .54006 L
F
1 .42 0 r
.94071 .82753 m
.96721 .86058 L
.94071 .86148 L
.93183 .86058 L
F
.74 1 0 r
.94071 .73982 m
.96315 .74038 L
.94071 .74093 L
.93754 .74038 L
F
0 .22 1 r
.98077 .78662 m
.96704 .78045 L
.98077 .77339 L
F
.2 0 1 r
.98077 .25426 m
.97034 .21955 L
.97567 .17949 L
.97309 .13942 L
.96929 .09936 L
.96955 .05929 L
.96905 .01923 L
.98077 .01923 L
F
.98077 .31998 m
.97207 .29968 L
.98077 .26448 L
F
0 .22 1 r
.98077 .90311 m
.97371 .90064 L
.98077 .89636 L
F
.2 0 1 r
.98077 .42812 m
.9743 .41987 L
.98077 .40403 L
F
.98077 .50421 m
.97685 .5 L
.98077 .49272 L
F
0 .22 1 r
.98077 .9806 m
.97903 .98077 L
.98077 .98077 L
F
.2 0 1 r
.98077 .58156 m
.9796 .58013 L
.98077 .57813 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`006Oooool2o`0003Sooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000goooo
o`?o0000=_ooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`0003Kooooo1Ol00005oooo
o`006?ooool01?l0003oooooooooool0000fooooo`04o`000?ooooooooooo`0000Oooooo00Go0000
ooooooooooooooooo`00000gooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool01ooo
ool01Ol0003ooooooooooooooooo000003Kooooo00Co0000oooooooooooo00001Oooool001Sooooo
00Co0000oooooooooooo0000=_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo
03Gooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
03Gooooo00?o0000ooooooooool01Oooool001Sooooo00Co0000oooooooooooo0000=_ooool01?l0
003oooooooooool0000;ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool0=_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool01?ooool0
01Sooooo00Co0000oooooooooooo0000=_ooool01?l0003oooooooooool00007ooooo`Co0000>?oo
ool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo00Oooooo1?l0000fooooo`05o`000?oo
ooooooooooooool000001Oooool001Sooooo00Co0000oooooooooooo0000=_ooool01?l0003ooooo
ooooool00007ooooo`03o`000?oooooooooo03Sooooo0_l0000gooooo`;o00002Oooool00ol0003o
ooooooooo`0gooooo`05o`000?ooooooooooooooool000001Oooool001Wooooo0_l0000hooooo`;o
00002?ooool5o`0003Oooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`07ooooo`Go
0000=_ooool3o`0000Kooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo003ooooo
ob7ooooo000Eoooooooo00002ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0mooooo`03o`000?oo
oooooooo03gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0mooooo`03o`000?oo
oooooooo00;ooooo0Ol00001ooooo`003_ooool2o`0000Gooooo00?o0000ooooooooool0ooooool7
ooooo`7o00000Oooool000gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`3o
ooooo`Oooooo0Ol00001ooooo`003Oooool01?l0003oooooooooool00004ooooo`;o0000ooooool7
ooooo`;o00000Oooool000gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02
ooooomGo<`3o2ol0>?lBoc<0o`[o03So0olc0?l5ooooo`7o00000Oooool000gooooo00Co0000oooo
oooooooo00001?ooool00ol0003oooooooooo`02ooooomGo<`3o2ol0>?lBoc<0o`[o03So0olc0?l5
ooooo`7o00000Oooool000gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02
ooooomGo<`3o2ol0>?lBoc<0o`[o03So0olc0?l5ooooo`7o00000Oooool000kooooo0_l00005oooo
o`03o`000?oooooooooo00;oooooeOlc0?l;o`0hoa;o<`3o2_l0>?l3oc<0o`Gooooo0Ol00001oooo
o`005Oooool00ol0003oooooooooo`02ooooomGo<`3o2ol0>?lBoc<0o`[o03So0olc0?l5ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_oooooEoc<0o`_o03So4_lc0?l:o`0ho`?o<`3o
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooeOlc0?l;o`0hoa7o<`3o2ol0
>?l3oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooomGo<`3o2ol0>?lA
oc<0o`_o03So0olc0?l5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooEoc<0
o`_o03So4Olc0?l;o`0ho`?o<`3o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
ooooeOlc0?l;o`0hoa7o<`3o2ol0>?l3oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooomGo<`3o2ol0>?lAoc<0o`_o03So0olc0?l5ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooooEoc<0o`_o03So4Olc0?l;o`0ho`?o<`3o1Oooool1o`00007ooooo000E
ooooo`;o00000ooooooEoc<0o`_o03So4Olc0?l;o`0ho`?o<`3o1?ooool2o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;oooooeOlc0?l;o`0hoa7o<`3o2ol0>?l3oc<0o`Gooooo0Ol00001oooo
o`005Oooool00ol0003oooooooooo`02ooooomGo<`3o2ol0>?lAoc<0o`_o03So0olc0?l5ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_oooooEoc<0o`_o03So4Olc0?l;o`0ho`?o<`3o
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooeOlc0?l;o`0hoa7o<`3o2ol0
>?l3oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooomGo<`3o2ol0>?lA
oc<0o`_o03So0olc0?l5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooEoc<0
o`_o03So4Olc0?l;o`0ho`?o<`3o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
ooooeOlc0?l;o`0hoa7o<`3o2ol0>?l3oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooomGo<`3o2ol0>?lAoc<0o`_o03So0olc0?l5ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooooEoc<0o`_o03So4Olc0?l;o`0ho`?o<`3o1Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;oooooeOlc0?l;o`0hoa7o<`3o2ol0>?l3oc<0o`Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02ooooomGo<`3o2ol0>?lAoc<0o`_o03So0olc0?l5oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooEoc<0o`co03So4?lc0?l;o`0ho`?o
<`3o1Oooool1o`00007ooooo000Eooooo`;o00000ooooooDoc<0o`go03So4?lc0?l;o`0ho`?o<`3o
1?ooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooe?lc0?l=o`0hoa3o<`3o2ol0
>?l3oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooomCo<`3o3Ol0>?l@
oc<0o`co03So0_lc0?l5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooCoc<0
o`ko03So3olc0?l=o`0ho`;o<`3o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
oooodolc0?l?o`0ho`ko<`3o3Ol0>?l2oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooom?o<`3o3ol0>?l>oc<0o`go03So0_lc0?l5ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooooBoc<0oa3o03So3_lc0?l=o`0ho`;o<`3o1Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo_olc0?l00ol0>?oo<`3ooc<0o`0@oc<0oa3o03So3_lc0?l=
o`0ho`;o<`3o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo_olc0?l00ol0
>?oo<`3ooc<0o`0@oc<0oa3o03So3_lc0?l=o`0ho`;o<`3o1Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo_olc0?l2o`0hoa7o<`3o4?l0>?l>oc<0o`go03So0_lc0?l5ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_oooonnoc<0o`?o03So4Olc0?lAo`0ho`go<`3o
3Ol0>?l2oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooookko<`3o0ol0
>?lAoc<0oa7o03So3?lc0?l>o`0ho`;o<`3o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo__lc0?l4o`0hoa3o<`3o4Ol0>?l<oc<0o`oo03So00?o<`3oooooooooool00oooool1
o`00007ooooo000Eooooo`;o00000ooooonmoc<0o`Go03So3olc0?lBo`0ho`co<`3o3ol0>?l00olc
0?ooooooooooo`02ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_oooonmoc<0o`Go
03So3olc0?lBo`0ho`co<`3o3ol0>?l00olc0?ooooooooooo`03ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_oooonYoc<0o`03o`0hoolc0?oo<`3o017o<`3o1Ol0>?l?oc<0oa?o03So
2olc0?l?o`0ho`03oc<0oooooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooojKo<`3o1?l0>?lCoc<0o`Ko03So3_lc0?lCo`0ho`[o<`3o4?l0>?l00olc0?oooooooooo
o`03ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooonSoc<0o`Oo03So4_lc0?l7
o`0ho`ko<`3o4ol0>?l:oc<0oa3o03So00?o<`3oooooooooool00oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;ooooo_?lc0?l7o`0ho`ko<`3o4ol0>?l:oc<0oa3o03So00?o<`3ooooo
ooooool00oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo_Olc0?l6o`0ho`ko
<`3o4ol0>?l:oc<0oa3o03So00?o<`3oooooooooool00oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo__lc0?l4o`0hoa3o<`3o4_l0>?l;oc<0o`oo03So00?o<`3oooooooooool0
0oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo__lc0?l3o`0hoa7o<`3o4Ol0
>?l<oc<0o`oo03So00?o<`3oooooooooool00oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo_olc0?l00ol0>?oo<`3ooc<0o`0@oc<0oa7o03So3?lc0?l>o`0ho`;o<`3o1Oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooodolc0?l@o`0ho`go<`3o3Ol0>?l2oc<0
o`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooom?o<`3o3ol0>?l>oc<0o`go
03So0_lc0?l5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooCoc<0o`oo03So
3_lc0?l=o`0ho`;o<`3o1Oooool1o`00007ooooo000Eooooo`;o00000ooooooCoc<0o`oo03So3_lc
0?l=o`0ho`;o<`3o1?ooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooe?lc0?l>
o`0ho`oo<`3o2ol0>?l3oc<0o`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
omCo<`3o3Ol0>?l@oc<0o`_o03So0olc0?l5ooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool00_oooooDoc<0o`go03So4?lc0?l;o`0ho`?o<`3o1Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooodolc0?l?o`0ho`oo<`3o3?l0>?l2oc<0o`Gooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02oooookko<`3o0ol0>?lAoc<0oa7o03So3Olc0?l=o`0ho`;o<`3o1Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo_Olc0?l5o`0ho`oo<`3o4ol0>?l;
oc<0o`ko03So0_lc0?l5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooonOoc<0
o`go03So4?lc0?l7o`0ho`go<`3o5Ol0>?l:oc<0o`oo03So00?o<`3oooooooooool00oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;oooooW_lc0?l@o`0ho`go<`3o2_l0>?l:oc<0oaOo
03So2?lc0?l@o`0ho`03oc<0oooooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooohWo<`3o0ol0>?l@oc<0oa?o03So2_lc0?l=o`0ho`So<`3o6Ol0>?l6oc<0oa7o03So
00?o<`3oooooooooool00oooool1o`00007ooooo0002ooooo`;o00001?ooool00ol0003ooooooooo
o`02ooooo`?o00001Oooool00ol0003oooooooooo`02ooooohOo<`3o1ol0>?l=oc<0oaKo03So1olc
0?l@o`0ho`Go<`3o6ol0>?l4oc<0oa?o03So1Oooool1o`00007ooooo00001Ooooooo0000oooooooo
oooo000000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo
Lolc0?l5o`0ho`go<`3o3?l0>?l8oc<0oa[o03So1?lc0?lBo`0ho`?o<`3o7Ol0>?l3oc<0oa?o03So
1Oooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000_ooooo00?o0000ooooooooool0
0_ooool2o`0000?oooooFolc0?l8o`0ho`go<`3o2ol0>?l8oc<0oa3o03So1Olc0?lLo`0ho`;o<`3o
5?l0>?l00olc0?oo03Soo`0ho`0Mo`0ho`03oc<0ool0>?oo03So01;o03So1?ooool2o`00007ooooo
00001Ooooooo0000oooooooooooo000000_ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02oooooeGo<`3o3_l0>?l=oc<0o`_o03So2Olc0?l>o`0ho`Oo<`3o6_l0>?l3oc<0oa?o03So
00?o<`3oo`0hool0>?l0<ol0>?l5ooooo`7o00000Oooool00005ooooool0003oooooooooool00000
1oooool4o`0000Gooooo00?o0000ooooooooool00_oooomLoc<0o`Go03So4_lc0?l5o`0ho`ko<`3o
2_l0>?l:oc<0oaSo03So1Olc0?lAo`0ho`?o<`3o=?l0>?l5ooooo`7o00000Oooool00005ooooool0
003oooooooooool000001oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo
MOlc0?l00ol0>?oo<`3ooc<0o`0@oc<0o`Go03So3olc0?lDo`0ho`So<`3o3ol0>?l5oc<0oako03So
00?o<`3oo`0hool0>?l04_l0>?l5ooooo`7o00000Oooool000;ooooo0_l00008ooooo`Go00001?oo
ool00ol0003oooooooooo`02oooooh[o<`3o00?o03Sooc<0oolc0?l04?lc0?lBo`0ho`[o<`3o3Ol0
>?l7oc<0oaco03So0olc0?lCo`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
oooooioo<`3o3ol0>?l<oc<0o`_o03So2Olc0?lJo`0ho`Co<`3o4ol0>?l5ooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_oooonPoc<0o`co03So3olc0?l9o`0ho`_o<`3o6?l0>?l6oc<0
oa7o03So00?o<`3oooooooooool00oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
ooooY_lc0?l5o`0hoa7o<`3o1ol0>?l<oc<0oaOo03So1olc0?lAo`0ho`03oc<0oooooooooooo00?o
oooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooookgo<`3o1Ol0>?l>oc<0oaKo03So
2?lc0?l@o`0ho`03oc<0oooooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02oooookko<`3o0ol0>?l@oc<0oaCo03So2_lc0?l?o`0ho`03oc<0oooooooooooo00?ooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02oooookoo<`3o00?o03Sooc<0oolc0?l04?lc0?lB
o`0ho`_o<`3o3ol0>?l00olc0?ooooooooooo`03ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_oooooCoc<0oa3o03So3Olc0?l=o`0ho`;o<`3o1Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;oooood_lc0?lBo`0ho`co<`3o3Ol0>?l2oc<0o`Gooooo0Ol00001ooooo`00
5Oooool2o`0000?ooooo__lc0?l3o`0hoa3o<`3o5?l0>?l:oc<0o`oo03So00?o<`3oooooooooool0
0_ooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooYOlc0?l7o`0hoa3o<`3o1ol0
>?l<oc<0oaOo03So2?lc0?l@o`0ho`03oc<0oooooooooooo00?ooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02oooooiko<`3o4Ol0>?l;oc<0o`co03So2?lc0?lJo`0ho`Go<`3o4Ol0>?l0
0olc0?ooooooooooo`03ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooon8oc<0
o`Ko03So3?lc0?lHo`0ho`Ko<`3o4?l0>?l4oc<0oago03So0olc0?lCo`0ho`Gooooo0Ol00001oooo
o`005Oooool00ol0003oooooooooo`02oooooe_o<`3o2Ol0>?l>oc<0o`[o03So1olc0?l@o`0ho`Co
<`3o7_l0>?l00olc0?oo03Soo`0ho`0Bo`0ho`03oc<0ool0>?oo03So01go03So00?o<`3oo`0hool0
>?l04_l0>?l5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolUoc<0o`co03So
2_lc0?l;o`0ho`[o<`3o6Ol0>?l4oc<0oi;o03So1Oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooom?l0>?l3o`2So`So03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooolol0>?l6o`2So`Ko03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;oooooeOl0>?l<o`2Soa7o03So2Ol0Xol4o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003o
ooooooooo`02ooooomCo03So3_l0Xol?o`0ho`co0:?o0_l0>?l5ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_oooooCo`0ho`oo0:?o3_l0>?l=o`2So`;o03So1Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;oooooYOl0>?l5o`2SoaGo03So00?o0:?oo`0hool0>?l04Ol0
>?l@o`2So`go03So3Ol0Xol2o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
oooooj3o03So2ol0XolCo`0ho`?o0:?o4Ol0>?lAo`2So`co03So3ol0Xol00ol0>?ooooooooooo`03
ooooo`7o00000Oooool001Gooooo0_l00003oooooj3o03So2ol0XolBo`0ho`Co0:?o4Ol0>?lBo`2S
o`_o03So3ol0Xol00ol0>?ooooooooooo`02ooooo`;o00000Oooool001Gooooo00?o0000oooooooo
ool00_oooonOo`0ho`go0:?o4Ol0>?l5o`2So`oo03So4ol0Xol;o`0ho`oo0:?o00?o03Sooooooooo
ool00oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooWol0>?l=o`2Soa3o03So
1ol0Xol>o`0hoaCo0:?o2Ol0>?l@o`2So`03o`0hoooooooooooo00?ooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02oooooiko03So3_l0Xol@o`0ho`So0:?o3?l0>?lEo`2So`Wo03So4?l0
Xol00ol0>?ooooooooooo`03ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooon:
o`0ho`03o`2Sool0>?oo03So017o03So3ol0Xol>o`0ho`Wo0:?o3?l0>?lFo`2So`Oo03So4_l0Xol5
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooon9o`0ho`;o0:?o4_l0>?l@o`2S
o`go03So2ol0Xol:o`0hoaOo0:?o1ol0>?lBo`2So`Gooooo0Ol00001ooooo`005Oooool00ol0003o
ooooooooo`02ooooohWo03So0_l0XolBo`0hoa7o0:?o3?l0>?l<o`2So`Wo03So6?l0Xol6o`0hoa;o
0:?o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooWol0>?l>o`2So`ko03So
2_l0Xol;o`0hoaKo0:?o2?l0>?l@o`2So`03o`0hoooooooooooo00?ooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02ooooojKo03So1Ol0XolBo`0ho`Go0:?o4?l0>?lBo`2So`co03So3?l0
Xol3o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooookoo03So00?o0:?o
o`0hool0>?l04Ol0>?l?o`2Soa3o03So2?l0Xol5o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooomGo03So2ol0XolCo`0ho`Go0:?o1ol0>?l5ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooooeo`0ho`03o`2Sool0>?oo03So00Oo03So1Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;oooooool0>?l5ooooo`7o00000Oooool001Gooooo0_l0
0003oooooeco<`3o2Ol0>?l<oc<0o`[o03So2Olc0?l>o`0ho`Ko<`3o7?l0>?l3oc<0oa;o03So0olc
0?lMo`0ho`;o<`3o5?l0>?l4ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_oooon9
oc<0o`Co03So3olc0?lEo`0ho`So<`3o3_l0>?l6oc<0oa_o03So1?lc0?lCo`0ho`Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02oooooioo<`3o3ol0>?l=oc<0o`[o03So2_lc0?lGo`0h
o`Oo<`3o4_l0>?l5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooonVoc<0o`Go
03So4Olc0?l8o`0ho`go<`3o5?l0>?l9oc<0oa7o03So1Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo__lc0?l4o`0hoa3o<`3o4_l0>?l;oc<0o`oo03So00?o<`3oooooooooool0
0oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooYOlc0?l9o`0ho`ko<`3o2?l0
>?l<oc<0oaKo03So2?lc0?l@o`0ho`03oc<0oooooooooooo00?ooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02ooooohSo<`3o1_l0>?l?oc<0oaKo03So1?lc0?lBo`0ho`?o<`3o7Ol0>?l2
oc<0oaCo03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo>olc0?l;o`0h
o`[o<`3o5_l0>?l:oc<0o`co03So1olc0?l@o`0ho`Go<`3oIol0>?l5ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_ooooodo`0ho`?o0:?o2?l0>?l5ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_oooooCo`0ho`oo0:?o3ol0>?l9o`2So`Go03So1Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;oooooYOl0>?l9o`2So`oo03So1_l0Xol<o`0hoaOo0:?o2?l0
>?l>o`2So`?o03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooQOl0>?l<
o`2So`[o03So6?l0Xol5o`0hoa3o0:?o1?l0>?lMo`2So`;o03So5?l0Xol5ooooo`7o00000Oooool0
01Gooooo0_l00003oooooc_o03So2ol0Xol:o`0hoaKo0:?o2_l0>?n?o`2So`Cooooo0_l00001oooo
o`005Oooool00ol0003oooooooooo`02ooooooCo0:?o0ol0oo08o`2So`Gooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02ooooomCo0:?o3Ol0oo0Ao`2So`So0?o`1Ol0Xol5ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooonoo`2So`03o`3ol?l0Xooo0:?o017o0:?o4?l0
oo0=o`2So`go0?o`0_l0Xol5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooE
o`2So`co0?o`4Ol0Xol9o`3ol0Co0:?o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;ooooomOl0Xol2o`3ol0So0:?o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
oooo??l0>?l9o`2So`co03So5?l0Xol<o`0ho`[o0:?o2Ol0>?mko`2So`Gooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02ooooohWo03So1ol0Xol<o`0hoaKo0:?o1ol0>?l>o`2So`Ko03So
6ol0Xol4o`0hoa;o0:?o00?o03Soooooooooool00oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;oooooY_l0>?l7o`2Soa7o03So1?l0Xol?o`0hoa?o0:?o2ol0>?l<o`2So`Co03So1Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooe?l0>?l=o`2Soa7o03So1ol0Xol6
o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooooGo03So00?o0:?oo`0h
ool0>?l01ol0>?l5ooooo`7o00000Oooool000gooooo0ol00005ooooo`03o`000?oooooooooo00;o
oooo??lc0?l9o`0ho`co<`3o5?l0>?l9oc<0oi7o03So1Oooool1o`00007ooooo000>ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool00_oooomcoc<0o`So03So2olc0?l:o`0ho`Wo<`3o
6_l0>?l5oc<0oa7o03So1?lc0?lLo`0ho`?o<`3o4ol0>?l5ooooo`7o00000Oooool000kooooo00?o
0000ooooooooool01?ooool2o`0000?oooooW_lc0?l@o`0ho`go<`3o2ol0>?l:oc<0oaKo03So2?lc
0?lAo`0ho`Cooooo0_l00001ooooo`003_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00;oooooWOlc0?lBo`0ho`_o<`3o3Ol0>?l8oc<0oa[o03So0olc0?lCo`0ho`Gooooo0Ol00001
ooooo`003_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;oooooD?lc0?lFo`0h
o`[o<`3o3?l0>?l9oc<0o`co03So1olc0?lLo`0ho`?o<`3o4ol0>?l2oc<0oc?o03So1Oooool1o`00
007ooooo000=ooooo`;o00001_ooool00ol0003oooooooooo`02oooooo?o03So1Ol0Xol7o`0ho`Go
oooo0Ol00001ooooo`003_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo
_Ol0>?l6o`2So`oo03So4Ol0Xol<o`0ho`co0:?o1?l0>?l5ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooon5o`0ho`co0:?o2_l0>?lFo`2So`Oo03So4?l0Xol5o`0hoa_o0:?o1?l0
>?lBo`2So`03o`0hoooooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
oooooooo0:?o1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooodol0Xol?o`3o
l17o0:?o1Ol0oo07o`2So`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooojGo
0:?o2Ol0oo0?o`2So`Ko0?o`3?l0XolGo`3ol0Wo0:?o3?l0oo04o`2So`Gooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02ooooog3o0:?o3?l0oo09o`2So`co0?o`2_l0XolHo`3ol0Go0:?o
4?l0oo04o`2Soago0?o`0ol0XolBo`3ol003o`2Soooooooooooo00?ooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02ooooooCo0?o`1?l0ohD7o`3ol0Gooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02ooooom[o0?o`1ol0ohDAo`3ol0Wo0?n51?l0oo05ooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_ooooodo`3ol0Go0?n51_l0oo05ooooo`7o00000Oooool001Go
oooo0_l00003ooooocco0:?o2Ol0oo0<o`2SoaCo0?o`3?l0Xol:o`3ol0Wo0:?oNol0oo04ooooo`;o
00000Oooool001Gooooo00?o0000ooooooooool00_oooon9o`2So`Oo0?o`3?l0XolDo`3ol0Wo0:?o
3_l0oo07o`2SoaWo0?o`1_l0Xol@o`3ol0;o0:?o1Oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooo__l0Xol4o`3ol17o0:?o3ol0oo0?o`2So`Wo0?o`1Ol0Xol5ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_ooooodo`2So`?o0?o`2?l0Xol5ooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_oooomLo`0ho`Wo0:?o3?l0>?l:o`2So`_o03So2_l0Xol9o`0h
oaWo0:?o1ol0>?l>o`2So`Ko03So6ol0Xol4o`0hoa?o0:?o1Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;oooooW_l0>?l?o`2Soa7o03So1?l0Xol?o`0hoa?o0:?o2ol0>?l>o`2So`;o
03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooe?l0>?l=o`2Soa7o03So
2?l0Xol5o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooooGo03So0_l0
Xol8o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooe7o<`3o5?l0>?l<
oc<0o`[o03So2_lc0?l=o`0ho`Oo<`3o6_l0>?l5oc<0odOo03So1Oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;oooooL?lc0?l<o`0ho`So<`3o3ol0>?l5oc<0oaco03So0olc0?lCo`0h
o`;o<`3o7_l0>?l00olc0?oo03Soo`0ho`0Bo`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003o
ooooooooo`02oooooooo03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo
f_l0>?l9o`2So`oo03So1ol0Xol6o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooojGo03So2Ol0Xol?o`0ho`Ko0:?o3ol0>?lFo`2So`Go03So4Ol0Xol00ol0>?oooooooooo
o`03ooooo`7o00000Oooool001Gooooo0_l00003oooooe3o03So5_l0Xol:o`0ho`co0:?o2Ol0>?l<
o`2So`[o03So6?l0Xol5o`0hoa3o0:?o1Ol0>?lbo`2So`Cooooo0_l00001ooooo`005Oooool00ol0
003oooooooooo`02ooooom[o0:?o2Ol0oo0?o`2So`Oo0?o`1_l0Xol5ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooonKo`2SoaKo0?o`2Ol0Xol<o`3ol0[o0:?o6?l0oo05o`2Soa7o
0?o`00?o0:?oooooooooool00oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo
ool0oo05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooBo`3ol17o0?n53ol0
oo07o`3oQ@Ko0?o`1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooQOl0oo0<
o`3oQ@[o0?o`5_l0ohD9o`3ol0co0?n51ol0oo0Ko`3oQ@Go0?o`4Ol0ohD00ol0oo3oooooooooo`03
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooco`3oQ@Oo0?lI1Ol0ohD5oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooooDo`3oQ@go0?lI4?l0ohD<o`3o6@;o
0?n51Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooYOl0ohD5o`3o6AGo0?n5
00?o0?lIo`3oQOl0ohD04_l0ohD>o`3o6@oo0?n53Ol0oaT00ol0ohGoooooooooo`03ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooonPo`3oQ@_o0?lI5?l0ohD2o`3o6A;o0?n54?l0
oaT=o`3oQ@oo0?lI1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooGol0ohD0
0ol0oaWo0?n5o`3oQ@0Xo`3oQ@03o`3o6Ol0ohGo0?n501?o0?n53?l0oaTBo`3oQ@Co0?lI4?l0ohDB
o`3o6@_o0?n54?l0oaT5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooomNo`3o
Q@;o0?lI5Ol0ohD00ol0oaWo0?n5o`3oQ@0Ao`3oQ@?o0?lI4ol0ohD>o`3o6A3o0?n51_l0oaT>o`3o
QACo0?lI2_l0ohD@o`3o6@Gooooo0Ol00001ooooo`005Oooool2o`0000?oooooGOl0ohD3o`3o6ACo
0?n50ol0oaTAo`3oQ@Go0?lI4Ol0ohD@o`3o6@ko0?n52?l0oaT<o`3oQAKo0?lI2?l0ohDAo`3o6@Co
oooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02oooooeco0?n51?l0oaTCo`3oQ@Co0?lI
4?l0ohD7o`3o6@oo0?n54Ol0oaT=o`3oQ@[o0?lI2_l0ohDGo`3o6@Oo0?n54_l0oaT5ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooomKo`3oQ@Ko0?lI4_l0ohD5o`3o6@ko0?n52?l0
oaT>o`3oQA?o0?lI2ol0ohD<o`3o6@Wo0?n56?l0oaT6o`3oQA;o0?lI1Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;oooooF_l0ohD7o`3o6A7o0?n51_l0oaT>o`3oQ@Wo0?lI3?l0ohDE
o`3o6@Wo0?n53_l0oaT7o`3oQA[o0?lI1?l0ohDCo`3o6@Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02oooooeWo0?n52?l0oaTAo`3oQ@Oo0?lI3?l0ohD;o`3o6@[o0?n55ol0oaT7o`3o
QA3o0?lI1Ol0ohDLo`3o6@?o0?n54ol0oaT5ooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool00_oooomHo`3oQ@Wo0?lI4?l0ohD9o`3o6@[o0?n53Ol0oaT8o`3oQAWo0?lI1Ol0ohDBo`3o6@?o
0?n57_l0oaT00ol0ohGo0?lIo`3o6@0Bo`3o6@Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooojKo0?n52?l0oaT>o`3oQ@So0?lI3Ol0ohDDo`3o6@Wo0?n53ol0oaT2o`3oQ@Gooooo
0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooo?o0?n51Ol0oaT7o`3oQ@Gooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02ooooohKo0?o`2_l0ohD<o`3ol1Co0?n52ol0oo0:
o`3oQ@Wo0?o`6Ol0ohD7o`3ol0oo0?n50_l0oo05ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_oooooCo`3ol0oo0?n54Ol0oo05o`3oQ@Oo0?o`1Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;oooooG?l0Xol9o`3ol0co0:?o2_l0oo0;o`2So`[o0?o`3?l0XolDo`3ol0Wo
0:?o3_l0oo07o`2SoaWo0?o`1_l0XolBo`3ol0Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02oooookko0:?o1?l0oo0Ao`2So`oo0?o`3ol0Xol<o`3ol0;o0:?o1Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;ooooom?l0Xol4o`3ol0Oo0:?o1Oooool1o`00007ooooo000E
ooooo`;o00000ooooonLo`0hoaCo0:?o2ol0>?l:o`2So`Wo03So6Ol0Xol6o`0hoa3o0:?o0_l0>?l4
ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_oooooCo`0ho`oo0:?o3ol0>?l9o`2S
o`Go03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooom?l0>?l3o`2So`So
03So1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooool0>?l5ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooonmo`0ho`Ko0:?o3ol0>?lDo`2So`[o03So2ol0
Xol4o`0ho`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooe3o03So5_l0Xol:
o`0ho`co0:?o2Ol0>?l<o`2So`[o03So5_l0Xol7o`0hoa3o0:?o1Ol0>?lbo`2So`Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02ooooom3o0:?o5_l0oo0:o`2So`_o0?o`1?l0Xol5oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolko`2So`_o0?o`2_l0XolFo`3ol0[o
0:?o3?l0oo09o`2So`co0?o`2_l0XomTo`3ol0Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02oooook[o0?o`3?l0ohD:o`3ol1Ko0?n52_l0oo0;o`3oQ@Co0?o`1Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;oooool_l0ohD7o`3o6@Ko0?n51Oooool1o`00007ooooo0000
1?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oo
oooooooo00;oooooYOl0ohD<o`3o6@Wo0?n53?l0oaT:o`3oQAKo0?lI1ol0ohDAo`3o6@03o`3oQOoo
oooooooo00?ooooo0Ol00001ooooo`000_ooool00ol0003oooooooooo`07ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooooooo`02oooooo;o0?lI1omAo`06o`3o6@Gooooo0Ol0
0001ooooo`000_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00_oooonUo`3o6@coDOl02Ol0oaT<oe7o00[o0?lI5_mAo`07o`3o6A7oDOl000?o0?lI
ooooooooool00oooool1o`00007ooooo0002ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool00_ooool2o`0000?oooooD?l0oaTFoe7o00[o0?lI3?mAo`09o`3o6@coDOl02_l0oaUToe7o
00Cooooo0_l00001ooooo`000_ooool00ol0003oooooooooo`07ooooo`Co00001Oooool00ol0003o
ooooooooo`02oooooe7o0?lI5?mAo`0<o`3o6@[oDOl02ol0oaT:oe7o00co0?lI5?mAo`09o`3o6DKo
DOl01Oooool1o`00007ooooo00000ooooooo0000o`000009ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool00_oooonno`3o6@OoDOl03?l0oaTDoe7o00Wo0?lI3omAo`02o`3o6@Gooooo
0Ol00001ooooo`000_ooool00ol0003oooooooooo`07ooooo`Go00001?ooool00ol0003ooooooooo
o`02oooooo?o0?lI1OmAo`07o`3o6@Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
ooooojKo0?n52_l0oaT;o`3oQ@[o0?lI3?l0ohDDo`3o6@co0?n52Ol0oaT5o`3oQ@Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02oooooooo0?n51Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo^ol0oo0:o`3oQ@co0?o`5?l0ohD<o`3ol0Wo0?n51Ol0oo05ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_oooollo`2So`Wo0?o`3?l0XolDo`3ol0co0:?o
2_l0oo0;o`2So`[o0?o`3?l0XomSo`3ol0Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02oooook_o0:?o2_l0oo0<o`2SoaCo0?o`3?l0Xol9o`3ol0Go0:?o1Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo??l0>?l9o`2So`co03So5?l0Xol<o`0ho`[o0:?o2ol0>?mi
o`2So`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooojKo03So2_l0Xol;o`0h
o`[o0:?o3?l0>?lFo`2So`Ko03So4Ol0Xol00ol0>?ooooooooooo`03ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooooKo`0ho`Oo0:?o3ol0>?l<o`2So`;o03So1Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo^_l0>?l<o`2So`[o03So5_l0Xol8o`0hoa7o0:?o
1Oooool1o`00007ooooo000Eooooo`;o00000ooooolko`0ho`_o0:?o2_l0>?lFo`2So`[o03So3?l0
Xol9o`0hog[o0:?o1?ooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo^_l0Xol<
o`3ol0[o0:?o5_l0oo0:o`2So`_o0?o`1?l0Xol5ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_ooooobo`3ol0Oo0?n51_l0oo05ooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool00_oooonKo`3ol1Ko0?n52Ol0oo0<o`3oQ@[o0?o`5_l0ohD7o`3ol17o0?n500?o0?o`oooooooo
ool00oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooood?l0ohDFo`3o6@[o0?n5
2ol0oaT4o`3oQ@Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooooo0?lI1Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooVol0oaTFoe7o00Wo0?lI3?mAo`0:
o`3o6AKoDOl02_l0oaT;oe7o00Co0?lI1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;oooood?mAo`0Fokgo00[oDOl02onmo`04oe7o00Gooooo0Ol00001ooooo`005Oooool00ol0003o
ooooooooo`02oooooa_oDOl05_nmo`0:oe7o0<Co_Ol01Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;oooooYOnmo`09oooG00ko_Ol02?ooe`0<okgo01KoomL02?nmo`0AoooG00Gooooo
0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooe_o_Ol02oooe`0:okgo00coomL02Onm
o`0<oooG00[o_Ol06?ooe`04okgo01;oomL00onmo`0MoooG00;o_Ol05?ooe`05ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_oooooooooG00Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooooGoomL000?oof/0oooG0?ooe`001oooe`05ooooo`7o00000Oooool001Go
oooo0_l00003ooooooCoomL00oooJ`08oooG00Cooooo0_l00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooooCoomL01?ooJ`07oooG00Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooooCoomL01OooJ`06oooG00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
oooooo?oomL01_ooJ`06oooG00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
oo?oomL01oooJ`05oooG00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooo?o
omL02?ooJ`04oooG00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooo;oomL0
2_ooJ`03oooG00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooog7o_Ol02_oo
e`0;okgo00[oomL03?nmo`0DoooG00_o_Ol02_ooe`0<okgo01CoomL02Onmo`0?oooG00;o_Ol01Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooolonmo`05oooG00Oo_Ol01Oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooodOmAo`0Dokgo00coDOl02Onmo`05oe7o
00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooico0?lI5?mAo`0;o`3o6@[o
DOl03?l0oaTDoe7o00co0?lI2OmAo`05o`3o6@Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02oooooe7o0?n55?l0oaT<o`3oQ@[o0?lI2ol0ohD:o`3o6@co0?n55?l0oaT;o`3oQ@[o0?lI
3?l0ohD^o`3o6@Gooooo0Ol00001ooooo`005Oooool2o`0000?ooooolOl0ohD9o`3o6@Go0?n51?oo
ool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo^ol0oo0:o`3oQ@co0?o`5?l0ohD<
o`3ol0Wo0?n51Ol0oo05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooomao`2S
o`[o0?o`2ol0Xol:o`3ol0co0:?o5?l0oo0;o`2So`[o0?o`3?l0XolFo`3ol0Oo0:?o3ol0oo02o`2S
o`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooom_o0:?o1ol0oo0Ao`2So`Go
0?o`1ol0Xol5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooomao`0ho`[o0:?o
2ol0>?l:o`2So`co03So5?l0Xol8o`0hoa3o0:?o1Ol0>?lKo`2So`Co03So4ol0Xol5ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooonmo`0ho`Ko0:?o3_l0>?lDo`2So`[o03So3ol0
Xol00ol0>?ooooooooooo`03ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooooob
o`2So`Oo0?o`1_l0Xol5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooon5o`2S
o`co0?o`2_l0XolFo`3ol0Wo0:?o3?l0oo0:o`2SoaKo0?o`1ol0XolAo`3ol003o`2Soooooooooooo
00?ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooi_o0?o`5_l0ohD9o`3ol0co
0?n52_l0oo0Fo`3oQ@[o0?o`2ol0ohD4o`3ol0Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02oooook[o0?n53?l0oaT:o`3oQAKo0?lI2_l0ohD;o`3o6@Co0?n51Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;oooood?l0oaTFoe7o00[o0?lI2omAo`04o`3o6@Gooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02ooooom[oDOl03?nmo`0:oe7o00_o_Ol01?mAo`05
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooooo`okgo00_oomL01?nmo`05oooo
o`7o00000Oooool001Gooooo0_l00003oooooa_o_Ol05_ooe`0:okgo00_oomL02_nmo`2_oooG00Co
oooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02ooooohGoomL03?ooJ`0:oooG01Koof/0
2Oooe`0<oom[00[oomL05_ooJ`0:oooG00_oof/01?ooe`05ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooooAoom[01Coo`002oooJ`0;ool000Coof/01Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;oooooQ_ooJ`08ool000goof/05Ooo000:oom[00coo`002OooJ`0H
ool000Koof/04Ooo00000oooJ`3oooooooooo`03ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_oooon7oom[00Ooo`003_ooJ`0Cool000coof/02_oo000;oom[01Koo`002OooJ`0=ool0
00?oof/01Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooR?ooJ`05ool0013o
of/04Ooo000>oom[00Soo`003OooJ`0Cool000coof/02ooo0004oom[00Gooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02ooooohSoof/01?oo000Boom[00ooo`004?ooJ`05ool0017oof/0
4?oo000?oom[00Ooo`001_ooJ`05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
oon9oom[00?oo`004oooJ`0=ool001;oof/00ooo000Coom[00goo`004oooJ`03ool000Soof/01Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooR_ooJ`000ooo003oof/0oom[000C
oom[00_oo`005?ooJ`000ooo003oof/0oom[000Coom[00_oo`005OooJ`000ooo003oof/0oom[0007
oom[00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooooooof/01Oooool1o`00
007ooooo000<ooooo`Go00001?ooool00ol0003oooooooooo`02oooooe7o_Ol05?ooe`0<okgo00[o
omL02onmo`0:oooG00co_Ol05?ooe`0;okgo04CoomL01Oooool1o`00007ooooo000=ooooo`04o`00
0?ooooooooooo`0000Cooooo00?o0000ooooooooool00_oooonkoe7o00[o_Ol03?mAo`0Dokgo00co
DOl02Onmo`05oe7o00Gooooo0Ol00001ooooo`003_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00;oooooQ_l0ohD:o`3o6@co0?n55?l0oaT;o`3oQ@[o0?lI3?l0ohDDo`3o6@co0?n5
2Ol0oaT5o`3oQ@Gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`03ooooo`;o00000ooo
oonVo`2So`[o0?o`2ol0Xol:o`3ol0co0:?o5?l0oo0<o`2So`Wo0?o`1Ol0Xol4ooooo`;o00000Ooo
ool000cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo0?oooooo1ooo
ool1o`00007ooooo000<ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooooooo
o`3oooooo`Oooooo0Ol00001ooooo`003Oooool3o`0000Gooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0mooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0??ooool0
0ol0003oooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`02ooooo`7o00000Oooool001Goooooool0000;o`00007ooooo003oooooob7ooooo
003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.207, -0.172242, 0.00783272, \
0.00783272}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(fgm[method_] := 
      Reap[Timing@
          NMinimize[{f6[{x, 0, y, 0}]}, {{x, 0, 2}, {y, 0, 2}}, 
            MaxIterations \[Rule] 1000, PrecisionGoal \[Rule] 10, 
            Method \[Rule] method, 
            StepMonitor \[RuleDelayed] Sow[{x, y}]]]\)], "Input"],

Cell[BoxData[
    \(\(data = \({#, 
              fgm[#]} &\) /@ {"\<NelderMead\>", "\<DifferentialEvolution\>", \
"\<SimulatedAnnealing\>", "\<RandomSearch\>", Automatic};\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\({#1, #2[\([1]\)]} &\) @@@ data\)], "Input"],

Cell[BoxData[
    \({{"NelderMead", {2.129066999999999`\ Second, {1.9837500000000003`, {x \
\[Rule] \(-0.030884114539702474`\), 
              y \[Rule] 
                1.2426101142599186`}}}}, {"DifferentialEvolution", \
{4.527048999999998`\ Second, {0.`, {x \[Rule] \(-0.01662196276380587`\), 
              y \[Rule] 
                0.0010197598544767934`}}}}, {"SimulatedAnnealing", \
{0.13464999999999705`\ Second, {0.169125`, {x \[Rule] 1.014676120077943`, 
              y \[Rule] 
                0.16705628352785373`}}}}, {"RandomSearch", \
{0.20575899999999692`\ Second, {0.018375000000000002`, {x \[Rule] 
                0.35099159450958517`, 
              y \[Rule] \(-0.04938129454502283`\)}}}}, {Automatic, \
{2.0926759999999938`\ Second, {1.9837500000000003`, {x \[Rule] \
\(-0.030884114539702474`\), y \[Rule] 1.2426101142599186`}}}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Module", "[", 
      RowBox[{\({cp}\), ",", "\[IndentingNewLine]", 
        StyleBox[\( (*\ contour\ plot\ of\ the\ objective\ function\ *) \),
          "CodeComment"], 
        StyleBox["\[IndentingNewLine]",
          "CodeComment"], 
        RowBox[{\(cp = 
            Block[{$DisplayFunction = 
                  Identity}, \[IndentingNewLine]ContourPlot[
                f6[{x, 0, y, 0}], {x, 0, 2}, {y, 0, 
                  2}, \[IndentingNewLine]PlotPoints \[Rule] 360, 
                PlotRange \[Rule] 
                  All, \[IndentingNewLine]ContourLines \[Rule] 
                  False, \[IndentingNewLine]ColorFunction \[Rule] \((Hue[
                        0.7\ \((1 - #)\)] &)\)]]\), ";", "\n", 
          RowBox[{"Show", "[", 
            RowBox[{"GraphicsArray", "[", "\[IndentingNewLine]", 
              StyleBox[\( (*\ show\ contour\ plot\ and\ search\ path\ *) \),
                
                "CodeComment"], \(\(Show[{cp, 
                      Graphics[{Hue[0], Thickness[0.005], 
                          Line[#[\([2, 2, 
                                1]\)]]}]}, \[IndentingNewLine]PlotRange \
\[Rule] {{0, 2}, {0, 2}}, 
                    PlotLabel \[Rule] #[\([1]\)], \
\[IndentingNewLine]DisplayFunction \[Rule] Identity, 
                    Frame \[Rule] False] &\) /@ \[IndentingNewLine]Take[data, 
                  4]\), "]"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    \($Aborted\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Corana's Parabola in 1D", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[CoranaFunc /. \ {x1 \[Rule] \ x, x2 \[Rule] 0. , \ 
            x3 \[Rule] 0. , \ x4 \[Rule] 0. }], \ {x, \(-1\), 
        2.5}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.295918 0.272109 0.0147151 0.267293 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.15986 .00222 -12 -9 ]
[.15986 .00222 12 0 ]
[.43197 .00222 -9 -9 ]
[.43197 .00222 9 0 ]
[.56803 .00222 -3 -9 ]
[.56803 .00222 3 0 ]
[.70408 .00222 -9 -9 ]
[.70408 .00222 9 0 ]
[.84014 .00222 -3 -9 ]
[.84014 .00222 3 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.28342 .14836 -18 -4.5 ]
[.28342 .14836 0 4.5 ]
[.28342 .28201 -6 -4.5 ]
[.28342 .28201 0 4.5 ]
[.28342 .41566 -18 -4.5 ]
[.28342 .41566 0 4.5 ]
[.28342 .5493 -6 -4.5 ]
[.28342 .5493 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-1)] .02381 .00222 0 1 Mshowa
.15986 .01472 m
.15986 .02097 L
s
[(-0.5)] .15986 .00222 0 1 Mshowa
.43197 .01472 m
.43197 .02097 L
s
[(0.5)] .43197 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(1)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(1.5)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(2)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2.5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.29592 .14836 m
.30217 .14836 L
s
[(0.5)] .28342 .14836 1 0 Mshowa
.29592 .28201 m
.30217 .28201 L
s
[(1)] .28342 .28201 1 0 Mshowa
.29592 .41566 m
.30217 .41566 L
s
[(1.5)] .28342 .41566 1 0 Mshowa
.29592 .5493 m
.30217 .5493 L
s
[(2)] .28342 .5493 1 0 Mshowa
.125 Mabswid
.29592 .04144 m
.29967 .04144 L
s
.29592 .06817 m
.29967 .06817 L
s
.29592 .0949 m
.29967 .0949 L
s
.29592 .12163 m
.29967 .12163 L
s
.29592 .17509 m
.29967 .17509 L
s
.29592 .20182 m
.29967 .20182 L
s
.29592 .22855 m
.29967 .22855 L
s
.29592 .25528 m
.29967 .25528 L
s
.29592 .30874 m
.29967 .30874 L
s
.29592 .33547 m
.29967 .33547 L
s
.29592 .3622 m
.29967 .3622 L
s
.29592 .38893 m
.29967 .38893 L
s
.29592 .44238 m
.29967 .44238 L
s
.29592 .46911 m
.29967 .46911 L
s
.29592 .49584 m
.29967 .49584 L
s
.29592 .52257 m
.29967 .52257 L
s
.29592 .57603 m
.29967 .57603 L
s
.29592 .60276 m
.29967 .60276 L
s
.25 Mabswid
.29592 0 m
.29592 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .0509 m
.02846 .0509 L
.03279 .0509 L
.03406 .0509 L
.03527 .0509 L
.03636 .0509 L
.03754 .25572 L
.03882 .25334 L
.04018 .25082 L
.04262 .24634 L
.06244 .21149 L
.06369 .2094 L
.06438 .20824 L
.06501 .03727 L
.06576 .03727 L
.06647 .03727 L
.06782 .03727 L
.07293 .03727 L
.07881 .03727 L
.0842 .03727 L
.08668 .03727 L
.0893 .03727 L
.09038 .03727 L
.09153 .03727 L
.0928 .16365 L
.09399 .16191 L
.10458 .14688 L
.10945 .14024 L
.11202 .13681 L
.11474 .13321 L
.11712 .13012 L
.11777 .12928 L
.11847 .12838 L
.11974 .02684 L
.12092 .02684 L
.12216 .02684 L
.12437 .02684 L
.13382 .02684 L
.13795 .02684 L
.14241 .02684 L
.14366 .02684 L
.14497 .02684 L
.14609 .02684 L
.14732 .09442 L
.14848 .09319 L
.14972 .09188 L
.15196 .08953 L
.16216 .07931 L
.16708 .07464 L
.16951 .0724 L
Mistroke
.17069 .07133 L
.17175 .07037 L
.1728 .06943 L
.17379 .01963 L
.17483 .01963 L
.17595 .01963 L
.18052 .01963 L
.19086 .01963 L
.19591 .01963 L
.19811 .01963 L
.19927 .01963 L
.2005 .01963 L
.2018 .04669 L
.203 .04589 L
.20536 .04432 L
.21056 .04102 L
.21631 .03759 L
.22158 .03467 L
.22395 .03341 L
.22616 .03228 L
.22727 .03173 L
.22846 .01562 L
.22978 .01562 L
.23097 .01562 L
.24109 .01562 L
.24561 .01562 L
.24799 .01562 L
.2505 .01562 L
.25271 .01562 L
.25396 .01562 L
.25513 .02072 L
.2562 .02041 L
.25718 .02013 L
.25938 .01953 L
.26862 .01741 L
.27329 .01656 L
.27844 .01582 L
.27974 .01566 L
.28112 .01551 L
.28183 .01543 L
.28262 .01472 L
.28333 .01472 L
.284 .01472 L
.28532 .01472 L
.28652 .01472 L
.28719 .01472 L
.28791 .01472 L
.28922 .01472 L
.29042 .01472 L
.29174 .01472 L
Mistroke
.2924 .01472 L
.29312 .01472 L
.29441 .01472 L
.29569 .01472 L
.29691 .01472 L
.298 .01472 L
.29919 .01472 L
.29984 .01472 L
.30053 .01472 L
.30175 .01472 L
.30307 .01472 L
.30382 .01472 L
.30451 .01472 L
.30578 .01472 L
.30693 .01472 L
.30757 .01472 L
.30826 .01472 L
.30952 .01472 L
.31064 .0155 L
.31188 .01563 L
.31439 .01595 L
.31888 .01662 L
.32409 .01758 L
.3297 .01884 L
.33229 .01949 L
.33369 .01987 L
.335 .02023 L
.33613 .02055 L
.33732 .01562 L
.33801 .01562 L
.33865 .01562 L
.33986 .01562 L
.34959 .01562 L
.35491 .01562 L
.35751 .01562 L
.35989 .01562 L
.36093 .01562 L
.36206 .01562 L
.36314 .01562 L
.36413 .03151 L
.36529 .03209 L
.36633 .03261 L
.36868 .03383 L
.37835 .03924 L
.38362 .04248 L
.38853 .04568 L
.3898 .04653 L
.39101 .04735 L
.39167 .01963 L
.39239 .01963 L
Mistroke
.39365 .01963 L
.39927 .01963 L
.40412 .01963 L
.40926 .01963 L
.41365 .01963 L
.41485 .01963 L
.41615 .01963 L
.41737 .01963 L
.41848 .06895 L
.41973 .07005 L
.42086 .07107 L
.42339 .07338 L
.42795 .07764 L
.43291 .08246 L
.43828 .08788 L
.44074 .09042 L
.44333 .09316 L
.4444 .0943 L
.44554 .09553 L
.4468 .02684 L
.44797 .02684 L
.45711 .02684 L
.46204 .02684 L
.46727 .02684 L
.47001 .02684 L
.47075 .02684 L
.47156 .02684 L
.47232 .02684 L
.47302 .12794 L
.47426 .12953 L
.47561 .13128 L
.47834 .13484 L
.49846 .1628 L
.49977 .16473 L
.501 .03727 L
.50229 .03727 L
.5037 .03727 L
.50665 .03727 L
.50938 .03727 L
.51477 .03727 L
.5197 .03727 L
.52198 .03727 L
.52447 .03727 L
.52561 .03727 L
.52682 .03727 L
.52797 .2091 L
.529 .21084 L
.53901 .22803 L
.54867 .24533 L
.55132 .25019 L
Mistroke
.55276 .25286 L
.55347 .25417 L
.55411 .25537 L
.55526 .0509 L
.5565 .0509 L
.55911 .0509 L
.56829 .0509 L
.57332 .0509 L
.57804 .0509 L
.58031 .0509 L
.58159 .0509 L
.58276 .31174 L
.58398 .31426 L
.5853 .31702 L
.58797 .32263 L
.59715 .34229 L
.60236 .35371 L
.60522 .36007 L
.60662 .36321 L
.60792 .36612 L
.60914 .06774 L
.61044 .06774 L
.61316 .06774 L
.61792 .06774 L
.62738 .06774 L
.6301 .06774 L
.63268 .06774 L
.63381 .06774 L
.635 .06774 L
.63631 .433 L
.63753 .43599 L
.65585 .48239 L
.69356 .58551 L
.70296 .61282 L
Mfstroke
.70296 .61282 m
.70472 .61803 L
s
.71687 .61803 m
.71806 .11104 L
.71875 .11104 L
.71947 .11104 L
.72078 .11104 L
.72374 .11104 L
.73371 .11104 L
.73854 .11104 L
.74092 .11104 L
.74313 .11104 L
.74435 .11104 L
s
.74435 .11104 m
.7454 .61803 L
s
.77188 .61803 m
.77262 .1375 L
.77374 .1375 L
.77497 .1375 L
.77611 .1375 L
.78043 .1375 L
.78541 .1375 L
.78994 .1375 L
.7949 .1375 L
.79626 .1375 L
.79773 .1375 L
.7984 .1375 L
.79911 .1375 L
s
.79911 .1375 m
.79987 .61803 L
s
.82668 .61803 m
.82704 .16717 L
.82769 .16717 L
.83006 .16717 L
.84087 .16717 L
.84619 .16717 L
.84878 .16717 L
.85113 .16717 L
.85229 .16717 L
.85355 .16717 L
s
.85355 .16717 m
.8541 .61803 L
s
.88112 .61803 m
.88157 .20005 L
.88263 .20005 L
.88498 .20005 L
.88996 .20005 L
.89939 .20005 L
.90197 .20005 L
.90475 .20005 L
.90609 .20005 L
.90737 .20005 L
s
.90737 .20005 m
.90778 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`003Oooool3o`0001gooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000ioooo
o`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00007?ooool3o`0001cooooo0ol00004oooo
o`03o`000?oooooooooo00;ooooo0ol0000Looooo`Go00006_ooool5o`0000?ooooo00?o0000oooo
ooooool00_ooool3o`0000Wooooo000>ooooo`03o`000?oooooooooo01_ooooo00Co0000oooooooo
oooo00001oooool01Ol0003ooooooooooooooooo000003Oooooo00Co0000oooooooooooo00001ooo
ool01Ol0003ooooooooooooooooo000001cooooo00?o0000ooooooooool07?ooool00ol0003ooooo
ooooo`07ooooo`05o`000?ooooooooooooooool000007?ooool01?l0003oooooooooool0000Koooo
o`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000008ooooo`001_ooool5
o`0000?ooooo00?o0000ooooooooool05?ooool5o`0000;ooooo00Co0000oooooooooooo00002ooo
ool00ol0003oooooooooo`0eooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0
6_ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
6oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
1_ooool000kooooo00?o0000ooooooooool06oooool01?l0003oooooooooool0000;ooooo`03o`00
0?oooooooooo03Gooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Jooooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Looooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`06ooooo`00
3_ooool00ol0003oooooooooo`0Kooooo`04o`000?ooooooooooo`0000Oooooo1?l0000hooooo`04
o`000?ooooooooooo`0000Oooooo1?l0000Mooooo`03o`000?oooooooooo01cooooo00?o0000oooo
ooooool01oooool4o`0001cooooo00Go0000ooooooooooooooooo`00000Jooooo`05o`000?oooooo
ooooooooool000001oooool4o`0000Wooooo000=ooooo`;o00007Oooool01?l0003oooooooooool0
0007ooooo`03o`000?oooooooooo03Wooooo00Co0000oooooooooooo00001oooool00ol0003ooooo
ooooo`0Mooooo`;o00007Oooool2o`0000Wooooo00?o0000ooooooooool07Oooool01Ol0003ooooo
oooooooooooo000001[ooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo
00[ooooo000>ooooo`03o`000?oooooooooo01cooooo0_l00008ooooo`Go0000>?ooool2o`0000So
oooo1Ol0000Looooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01oooool5o`0001co
oooo0ol0000Looooo`?o00002?ooool5o`0000Sooooo001Fooooo`03o`000?oooooooooo0<Oooooo
001Fooooo`03o`000?oooooooooo0<Oooooo001Fooooo`03o`000?oooooooooo0<Oooooo001Foooo
o`03o`000?oooooooooo0<Oooooo0005oooooooo00004ol00009ooooo`003?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooooooo2?l00003ooooo`05
o`000?ooooooooooooooool000000_ooool01?l0003oooooooooooooool5o`0000Kooooo00?o0000
ooooooooool01Oooool4o`0000?ooooo00Co0000oooooooooooo00000oooool01?l0003ooooooooo
ooooool8o`0000?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00gooooo000<ooooo`03o`000?oooooooooo02;ooooo00Go0000oooooooooooooooo
o`000006ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000Tooooo`03
o`000?oooooooooo02;ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo00gooooo000Vooooo`So00001oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`So0000
VOooool002Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`2Gooooo`009_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`02ooooo`?o00004_ooool00ol0003oooooooooo`0@ooooo`?o00001?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`2Gooooo`005oooool8o`0000Oooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000E
ooooo`03o`000?oooooooooo01?ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`So0000R_oo
ool001Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`04o`000?oooooo
0000o`0001Kooooo0_l0000Eooooo`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`28ooooo`005oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo0_l0000Hooooo`03o`000?oooooooooo01Gooooo0ol00006ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0R?ooool001Oooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0R?ooool0
00cooooo1?l00007ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool07_ooool00ol0
003oooooooooo`0Oooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool8o`00
07_ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Nooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0NOooool000oooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01kooooo
00?o0000ooooooooool07oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`1iooooo`003oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07_ooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo07Wooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo01oooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool8o`0006cooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00oooool2o`00023ooooo0_l0000Pooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`1Zooooo`003oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00;ooooo0_l0000Qooooo`03o`000?oooooooooo023ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo06[ooooo000?ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Pooooo`03o`00
0?oooooooooo027ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo06[ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_l0
000Sooooo`03o`000?oooooooooo02;ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo06[ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooool000009Ooo
ool00ol0003oooooooooo`0Sooooo`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
J_ooool000oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01Oooool2o`0002Kooooo00?o0000ooooooooool09?oo
ool00ol0003oooooo`000006ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo06[ooooo000?ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Uooooo`;o00001_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`1Zooooo`003oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
02Gooooo0_l0000Wooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0J_ooool000oo
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo06[o
oooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0;Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`1Zooooo`003oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo02gooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0J_ooool000oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0]
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo01?ooooo2?l0001?ooooo`003oooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0]oooo
o`03o`000?oooooooooo02gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo04gooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02gooooo00?o0000oooooooo
ool0;Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0COooool000oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0;Oooool2o`0002kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04gooooo000?ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo02gooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Cooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0COooool000oooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo0_l0000_ooooo`03o`000?oooooo
oooo02gooooo0_l00006ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0COooool0
00oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1=ooooo`003oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0_ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo2?l00010ooooo`003oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`00000Oooooo`;o
00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`0_ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0?_ooool000oooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`05ooooo`05o`000?ooooooooooooooool000007_ooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0`
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0?_ooool000oooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0001oooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`02ooooo`?o0000<Oooool01Ol0003ooooooooo
oooooooo000000Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo03kooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Ooo
ool01?l0003oooooooooool0000Oooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0booooo`04o`000?ooooooooooo`0000Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03kooooo000?ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooo`00000Pooooo`04
o`000?ooooooooooo`0000Oooooo1?l00005ooooo`03o`000?oooooooooo03;ooooo00Co0000oooo
oooooooo00001_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0?_ooool0013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`;o00008Oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool0<oooool00ol0003oooooo`000006ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0nooooo`004?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool08Oooool2o`0000Sooooo1Ol00004oooo
o`03o`000?oooooooooo03Cooooo0_l00006ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0nooooo`004?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0=?ooool00ol0003oooooooooo`0eooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo03kooooo000@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
??ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`05ooooo`So0000<Oooool0013ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0looooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0_ooooo`004?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo03cooooo0_l0000mooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0;oooool0
013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo
03cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0_ooooo`004?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0??ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo02oooooo000@ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0;oooool0013ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0looooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0_ooooo`004?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03cooooo00?o0000
ooooooooool0??ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02oooooo000@oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0loooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0;oooool0013ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0looooo`;o0000?Oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo2?l0000Rooooo`004?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo03cooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`004?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0??oo
ool2o`0000Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo023ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0?Oooool0
0ol0003oooooooooo`0mooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo000@ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
023ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0?_ooool00ol0003o
ooooooooo`0nooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo023ooooo000@ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0?_ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo
000@ooooo`05o`000?ooooooooooooooool00000@Oooool2o`00043ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
8?ooool0013ooooo00Co0000oooooooooooo0000@_ooool00ol0003oooooooooo`0oooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo023ooooo000@ooooo`04o`000?ooooooooooo`0004;ooooo00?o0000ooooooooool0
@?ooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Pooooo`004?ooool00ol0003oooooo`000013ooooo`03o`000?oooooooooo047ooooo
00Co0000oooooooooooo00001_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023o
oooo000@ooooo`03o`000?oooooo000004?ooooo00?o0000ooooooooool0@Oooool01?l0003ooooo
ooooool00006ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool0013ooooo
0_l00014ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooool000001_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo023ooooo000@ooooo`03o`000?oooooooooo04?ooooo00?o
0000ooooooooool0@oooool2o`0000Kooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Pooooo`004?ooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo04?ooooo0_l00006
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool0013ooooo00?o0000oooo
ooooool0@oooool2o`0004Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo04_ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1;ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0Booo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001>ooooo`?o00001Oooool0
0ol0003oooooooooo`1;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool0
04oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1;ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool08?ooool004oooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`1;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool004oooooo
00?o0000ooooooooool01?ooool3o`0004_ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Pooooo`00Coooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04_ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00C_ooool2o`0000Kooooo00?o0000
ooooooooool0Boooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001?oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Boooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo04_ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1;ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0Booo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`;o0000C?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo
04_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003o
ooooooooo`1<ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo
00?o0000ooooooooool0C?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo
001Fooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Pooooo`00E_ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool08?ooool005Kooooo00?o0000ooooooooool0C_ooool01Ol0003ooooooooooooooooo
000000Oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo023ooooo001Fooooo`;o0000Coooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Foooo
o`03o`000?oooooooooo04kooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0
003oooooooooo`1?ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo
04oooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0D?ooool00ol0
003oooooo`000007ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Aooooo`;o00001oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo
00?o0000ooooooooool0DOooool2o`0000Oooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo057ooooo0_l0
0007ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Pooooo`00E_ooool2o`0005?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000oooo
ooooool0D_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Jooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00
E_ooool00ol0003oooooooooo`1Jooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Jooooo`03o`000?oo
oooooooo01?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool0
0ol0003oooooooooo`1Jooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Jooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool2o`0005_o
oooo00?o0000ooooooooool04oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023o
oooo001Fooooo`03o`000?oooooooooo05[ooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo05[ooooo00?o
0000ooooooooool04oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001F
ooooo`03o`000?oooooooooo05[ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo05[ooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo0012ooooo`?o
00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`1Jooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00
@oooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`1Jooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Pooooo`00@oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo
0ol0001Jooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Pooooo`00@oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0F_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool08?ooool004?ooooo00?o0000ooooooooool01oooool4o`0000Gooooo00?o0000
ooooooooool0F_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool08?ooool004;ooooo0_l00009ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool0F_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool08?ooool004?ooooo00?o0000ooooooooool01oooool5o`0000Cooooo00?o0000oooooooo
ool0F_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool08?ooool005Kooooo00?o0000ooooooooool0F_ooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0F_oo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?oo
ool005Kooooo00?o0000ooooooooool0F_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo0_l0001Looooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003o
ooooooooo`1Kooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Kooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003ooooooooo
o`1Looooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Pooooo`00E_ooool00ol0003oooooooooo`1Looooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Moooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Poooo
o`00E_ooool00ol0003oooooooooo`1Mooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool2o`0005kooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oo
oooooooo05kooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo023ooooo001Fooooo`03o`000?oooooooooo05kooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo
05kooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
023ooooo001Fooooo`03o`000?oooooooooo05oooooo00?o0000ooooooooool03_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo05oooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo
001Fooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`;o0000HOooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000oooo
ooooool0H?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool08?ooool005Kooooo00?o0000ooooooooool0HOooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0
HOooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
8?ooool005Kooooo00?o0000ooooooooool0H_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0H_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool0
05Kooooo00?o0000ooooooooool0H_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool08?ooool005Kooooo0_l0001Tooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003ooooo
ooooo`1Sooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Tooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1T
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0P
ooooo`00E_ooool00ol0003oooooooooo`1Tooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Pooooo`00COooool5o`0000Cooooo00?o0000oooooooo
ool0IOooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool08?ooool004kooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`1Uooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00
Coooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001@ooooo`03o`000?oo
oooooooo00?ooooo0ol0001Vooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Pooooo`00COooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool0I_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool08?ooool004gooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooooooo06Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo023ooooo001>ooooo`?o00001Oooool00ol0003oooooooooo`1Wooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0
003oooooooooo`1Wooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`0Pooooo`00E_ooool00ol0003oooooooooo`1Xooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`00E_ooool00ol0003ooooo
ooooo`1Xooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Pooooo`00E_ooool2o`0006[ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo06Wooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Foooo
o`03o`000?oooooooooo06Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo06[ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`00
0?oooooooooo06[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo023ooooo001Fooooo`03o`000?oooooooooo06[ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo001Fooooo`03o`000?oooooo
oooo06_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo023ooooo001Fooooo`;o0000K?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0Joooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool005Kooooo
00?o0000ooooooooool0K?ooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool08?ooool005Kooooo00?o0000ooooooooool0K?ooool01Ol0003ooooooooooooooooo000000Oo
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool08?ooool005Kooooo00?o0000ooooooooool0KOooool01?l0003ooooo
ooooool00007ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo023ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.16691, -0.170227, \
0.013476, 0.0137188}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[
      CoranaFunc /. \ {x1 \[Rule] x - 0.73, \ x2 \[Rule] 0. , \ 
          x3 \[Rule] 0. , \ x4 \[Rule] 0. }, x, 
      Method -> "\<NelderMead\>"]\)], "Input"],

Cell[BoxData[
    \({0.`, {x \[Rule] 0.7747045018860196`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = 
      FindMinimumPlot[f6[{x, 0, 0, 0}], {x, 0.9}, 
        Method -> "\<QuasiNewton\>", 
        PlotRange \[Rule] {{0, 1}, {0, 1}}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0 1 0 0.618034 [
[.2 -0.0125 -9 -9 ]
[.2 -0.0125 9 0 ]
[.4 -0.0125 -9 -9 ]
[.4 -0.0125 9 0 ]
[.6 -0.0125 -9 -9 ]
[.6 -0.0125 9 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -3 -9 ]
[1 -0.0125 3 0 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2 0 m
.2 .00625 L
s
[(0.2)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(0.4)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(0.6)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(0.8)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(1)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.4 .01136 m
.42028 .01136 L
.43084 .01136 L
.43643 .01136 L
.4424 .01136 L
.4453 .01136 L
.44672 .01136 L
.44804 .01136 L
.44923 .01136 L
.44983 .01136 L
.45049 .12543 L
.45116 .1258 L
.45187 .12619 L
.45316 .12692 L
.46318 .13259 L
.48482 .14527 L
.50567 .15803 L
.52572 .17081 L
.53691 .17816 L
.5422 .18169 L
.54706 .18496 L
.54834 .18583 L
.54896 .18625 L
.54953 .18664 L
.55013 .02804 L
.55078 .02804 L
.55214 .02804 L
.55764 .02804 L
.5676 .02804 L
.58852 .02804 L
.60864 .02804 L
.61882 .02804 L
.63006 .02804 L
.63517 .02804 L
.64069 .02804 L
.64322 .02804 L
.6459 .02804 L
.64818 .02804 L
.6488 .02804 L
.64947 .02804 L
.6501 .2612 L
.65067 .26166 L
.67166 .27881 L
.69186 .29583 L
.71334 .31449 L
.72403 .32398 L
.73402 .33299 L
.74361 .34175 L
.74637 .34429 L
.74774 .34555 L
Mistroke
.7484 .34616 L
.749 .34671 L
.74958 .34726 L
.75014 .05215 L
.75072 .05215 L
.75135 .05215 L
.75392 .05215 L
.77547 .05215 L
.79623 .05215 L
.81619 .05215 L
.82731 .05215 L
.83744 .05215 L
.84248 .05215 L
.84513 .05215 L
.84659 .05215 L
.84795 .05215 L
.84913 .05215 L
.8498 .05215 L
.85041 .44696 L
.85104 .44762 L
.85173 .44835 L
.85312 .44981 L
.85789 .45486 L
.87922 .47775 L
.89974 .50032 L
.9 .50061 L
Mfstroke
0 0 0 r
.055 w
.4 .01136 Mdot
1 0 0 r
.0325 w
.9 .50061 Mdot
.4 .01136 Mdot
0 1 0 r
.02 w
.9 .50061 Mdot
.9 .50061 Mdot
.9 .50061 Mdot
.4 .01136 Mdot
.4 .01136 Mdot
.4 .01136 Mdot
0 0 1 r
.5 Mabswid
.9 .50061 m
.9 .50061 L
.4 .01136 L
s
.015 w
.9 .50061 Mdot
.9 .50061 Mdot
.4 .01136 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00@oooool2o`0000Cooooo00Co0000oooooooooooooooo1Ol0000Uooooo`;o00001?ooool0
0ol0003oooooooooo`03ooooo`?o00009Oooool2o`0000Cooooo00?o0000ooooooooool00_ooool3
o`0002Kooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000[ooooo`?o00001Oooool0
04;ooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool0000Tooooo`04o`000?oo
ooooooooo`0000[ooooo00?o0000ooooooooool08oooool01?l0003oooooooooool00007ooooo`05
o`000?ooooooooooooooool000009?ooool01?l0003oooooooooool00007ooooo`05o`000?oooooo
ooooooooool00000:oooool00ol0003oooooooooo`04ooooo`00@_ooool01?l0003oooooooooool0
0009ooooo`03o`000?oooooooooo02Cooooo00Co0000oooooooooooo00001oooool5o`0002Cooooo
00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000002Cooooo00Co0000oooo
oooooooo00001oooool01Ol0003ooooooooooooooooo000002_ooooo00?o0000ooooooooool01?oo
ool004;ooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`0Sooooo`04o`000?oo
ooooooooo`0000Oooooo00Co0000oooooooooooo00009Oooool01?l0003oooooooooool00007oooo
o`Co00009Oooool01?l0003oooooooooool00008ooooo`?o0000;?ooool00ol0003oooooooooo`04
ooooo`00@_ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000009?oo
ool01?l0003oooooooooool00008ooooo`03o`000?oooooo000002Gooooo00Co0000oooooooooooo
00001oooool00ol0003oooooooooo`0Vooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooo
ooooooooooooo`00000[ooooo`03o`000?oooooooooo00Cooooo0012ooooo`04o`000?oooooooooo
o`0000Oooooo00Go0000ooooooooooooooooo`00000Tooooo`04o`000?ooooooooooo`0000Wooooo
0_l0000Uooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool09Oooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool00000:_ooool2o`0000Kooooo0013oooo
o`;o00002Oooool3o`0002Kooooo0_l0000;ooooo`03o`000?oooooooooo02Cooooo0_l0000:oooo
o`;o00009_ooool2o`0000Wooooo0ol0000/ooooo`03o`000?oooooooooo00Cooooo003oooooob7o
oooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo000GooooofGo00001_oo002Io`00
00Gooooo000Gooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01?ooool3o`0000;o
o`000ol0o`03ool000?o00001Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool00oooool001Oooooo00?o0000ooooooooool0G_ooool3o`000003ool0
0?l0o`3o003o00;o003o00?o0?l0ool00?oo00000ol0002Jooooo`005oooool00ol0003ooooooooo
o`1Nooooo`?o000000?oo`00o`3o0?l00?l00_l00?l00ol0o`3oo`00ool00009o`0009Cooooo000G
ooooo`03o`000?oooooooooo05kooooo0ol000000ooo003o0?l0o`00o`03o`00o`;oo`000ol00005
ooooo`03o`000?oooooooooo09;ooooo000Gooooo`03o`000?oooooooooo05kooooo1?l000001_oo
003o0?l0o`3o0?l0o`3oo`00o`00o`Co00001Oooool00ol0003oooooooooo`2Booooo`005oooool0
0ol0003oooooooooo`1Oooooo`Co00001?oo00001?l0003o003oo`000?l00006ooooo`03o`000?oo
oooooooo09;ooooo000Gooooo`03o`000?oooooooooo063ooooo2Ol000000ol00?ooooooooooo`05
ooooo`03o`000?oooooooooo01Oooooo6ol0001Pooooo`005oooool00ol0003oooooooooo`1Qoooo
o`So000000?oooooo`00ooooool01Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool0G_ooool001Oooooo00?o0000ooooooooool0H_ooool6o`0000?o
oooo00?o003oooooooooool00oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool0G_ooool001Oooooo00?o0000ooooooooool0K?ooool00ol00?oooooo
ooooo`02ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003ooooo
ooooo`1Nooooo`005oooool00ol0003oooooooooo`1]ooooo`05o`00ooooooooooooooooool00000
6Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo05kooooo000Gooooo`03o`000?oo
oooooooo06kooooo00Co003ooooooooooooo00006Oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo05kooooo000Gooooo`03o`000?oooooooooo06oooooo00?o003oooooool000006Ooo
ool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo6ol0000/ooooo`005oooool0
0ol0003oooooooooo`1`ooooo`03o`00ool0003ooooo01Sooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:_ooool0
01Oooooo00?o0000ooooooooool0LOooool00ol00?ooooooooooo`0Gooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
02[ooooo000Gooooo`03o`000?oooooooooo077ooooo00?o0000o`00ooooool05oooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003o
ooooooooo`0Zooooo`005oooool00ol0003oooooooooo`1aooooo`03o`000?oooooo003o01Oooooo
00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool0:_ooool001Oooooo00?o0000ooooooooool0LOooool01?l0003ooooooooo
ool00?lFooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003ooooo
ooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo077ooooo00Go
0000ooooooooooooooooo`00o`0Eooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0
5oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oo
oooooooo077ooooo00?o0000ooooooooool00_ooool00ol00?ooooooooooo`0Booooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo02[ooooo000Gooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool00oooool0
0ol00?ooooooooooo`0Aooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo
077ooooo00?o0000ooooooooool01?ooool00ol00?ooooooooooo`0@ooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
02[ooooo000Gooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool01Oooool00ol00?oo
ooooooooo`0?ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo077ooooo
00?o0000ooooooooool01_ooool00ol00?ooooooooooo`0>ooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo
000Gooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool01oooool00ol00?oooooooooo
o`0=ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003ooooooooo
o`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo077ooooo00?o0000
ooooooooool02?ooool00ol00?ooooooooooo`0<ooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Goooo
o`03o`000?oooooooooo077ooooo00?o0000ooooooooool02Oooool00ol00?ooooooooooo`0;oooo
o`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo077ooooo00?o0000oooooooo
ool02_ooool00ol00?ooooooooooo`0:ooooo`03o`000?oooooooooo01Oooooo00?o0000oooooooo
ool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo0003ooooo`;o0000
1?ooool01?l0003oooooooooooooool5o`0000Gooooo00?o0000ooooooooool0LOooool00ol0003o
ooooooooo`0;ooooo`03o`00oooooooooooo00Wooooo00?o0000ooooooooool05oooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:_ooool000;ooooo
00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo
077ooooo00?o0000ooooooooool03?ooool00ol00?ooooooooooo`08ooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
02[ooooo0002ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`1aooooo`03o`000?oooooooooo00gooooo00?o003oooooooooool01oooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0
003oooooooooo`0Zooooo`000_ooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo
00Cooooo0_l0001booooo`03o`000?oooooooooo00kooooo00?o003oooooooooool01_ooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0
003oooooooooo`0Zooooo`000_ooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooo
ooooool000001Oooool00ol0003oooooooooo`1booooo`?o00003_ooool00ol00?ooooooooooo`05
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo02[ooooo0002ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000
ooooooooooooooooo`000005ooooo`03o`000?oooooooooo07Gooooo0_l0000=ooooo`03o`00oooo
oooooooo00Cooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool0:_ooool000?ooooo0_l00009ooooo`?o00001_ooool0
0ol0003oooooooooo`1gooooo`;o00003?ooool00ol00?ooooooooooo`03ooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo02[ooooo000Gooooo`03o`000?oooooooooo07Wooooo00?o0000ooooooooool02_ooool00ol0
0?ooooooooooo`02ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo07[o
oooo0_l0000;ooooo`05o`00ooooooooooooooooool000006Oooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:_ooool001Oooooo00?o0000oooooooo
ool0O?ooool00ol0003oooooooooo`09ooooo`04o`00ooooooooooooo`0001Wooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03
o`000?oooooooooo07gooooo0_l0000:ooooo`03o`00oooooooo000001Wooooo00?o0000oooooooo
ool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`00
0?oooooooooo07oooooo00?o0000ooooooooool02?ooool00ol00?oo0000ooooo`0Hooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`005ooo
ool00ol0003oooooooooo`20ooooo`;o00002Oooool00ol00?ooooooooooo`0Gooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`005oooool0
0ol0003oooooooooo`22ooooo`;o00001oooool00ol0003o003oooooo`0Gooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`005oooool00ol0
003oooooooooo`24ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool00?l05oooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:_ooool001Oo
oooo00?o0000ooooooooool0QOooool2o`0000Cooooo00Co0000oooooooooooo003o5_ooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:_ooool001Oo
oooo00?o0000ooooooooool0Qoooool01Ol0003ooooooooooooooooo000000?ooooo0_l00?lDoooo
o`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zoooo
o`005oooool00ol0003oooooooooo`28ooooo`04o`000?ooooooooooo`0000Gooooo00?o003ooooo
ooooool04Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000oooo
ooooool0:_ooool001Oooooo00?o0000ooooooooool0ROooool00ol0003oooooo`000006ooooo`03
o`00oooooooooooo013ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03
o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo08[ooooo0_l00007ooooo`03o`00
oooooooooooo00oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo09Cooooo00?o003oooooooooool03_oo
ool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:_oo
ool001Oooooo00?o0000ooooooooool0UOooool00ol00?ooooooooooo`0=ooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`005oooool00ol0
003oooooooooo`2Fooooo`03o`00oooooooooooo00cooooo00?o0000ooooooooool05oooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo09Oo
oooo00?o003oooooooooool02oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool0:_ooool001Oooooo00?o0000ooooooooool0V?ooool00ol00?oooooo
ooooo`0:ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003ooooo
ooooo`0Zooooo`005oooool00ol0003oooooooooo`2Iooooo`03o`00oooooooooooo00Wooooo00?o
0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000G
ooooo`03o`000?oooooooooo09[ooooo00?o003oooooooooool02?ooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:_ooool001Oooooo00?o0000oooo
ooooool0Voooool00ol00?ooooooooooo`07ooooo`03o`000?oooooooooo01Oooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`0Zooooo`005oooool00ol0003oooooooooo`2Looooo`03
o`00oooooooooooo00Kooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03
o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo09gooooo00?o003oooooooooool0
1Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0
:_ooool001Oooooo00?o0000ooooooooool0W_ooool00ol00?ooooooooooo`04ooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`005oooool0
0ol0003oooooooooo`2Oooooo`03o`00oooooooooooo00?ooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo0003ooooo`;o00001?ooool00ol0
003oooooooooo`03ooooo`?o00001Oooool00ol0003oooooooooo`2Pooooo`03o`00oooooooooooo
00;ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
02[ooooo0002ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`2Qooooo`05o`00ooooooooooooooooool000006Oooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo02[ooooo0002ooooo`04o`000?ooooooooooo`0000Oooooo1Ol00005
ooooo`03o`000?oooooooooo0:;ooooo00Co003ooooooooooooo00006Oooool00ol0003ooooooooo
o`0Gooooo`03o`000?oooooooooo02[ooooo0002ooooo`04o`000?ooooooooooo`0000Oooooo00Co
0000oooooooooooo00001_ooool2o`000:Cooooo00?o003oooooool000006Oooool00ol0003ooooo
ooooo`0Gooooo`03o`000?oooooooooo02[ooooo0002ooooo`04o`000?ooooooooooo`0000Sooooo
00?o0000ooooool000001_ooool00ol0003oooooooooo`2Tooooo`03o`00ool0003ooooo01Sooooo
00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`000_ooool01?l0003ooooooooo
ool00009ooooo`;o00001_ooool00ol0003oooooooooo`2Uooooo`03o`00oooooooooooo01Oooooo
00?o0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`000oooool2o`0000_ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`2Uooooo`03o`000?l00?oooooo01Oooooo00?o
0000ooooooooool05oooool00ol0003oooooooooo`0Zooooo`005oooool00ol0003oooooooooo`2U
ooooo`;o000000?o003oooooooooool05Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo02[ooooo000Gooooo`03o`000?oooooooooo0:Oooooo00?o0000o`00ooooool05Oooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0:So
oooo00?o0000o`00ooooool05?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[o
oooo000Gooooo`03o`000?oooooooooo0:[ooooo00?o003oooooooooool04_ooool00ol0003ooooo
ooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0:_ooooo00?o
003oo`000?ooool04Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000G
ooooo`03o`000?oooooooooo0:cooooo00?o003oo`000?ooool04?ooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0:gooooo00?o003oo`00
0?ooool03oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03
o`000?oooooooooo0:kooooo00?o003oo`000?ooool03_ooool00ol0003oooooooooo`0Gooooo`03
o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0:oooooo00?o003oo`000?ooool0
3Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oo
oooooooo0;3ooooo00?o003oo`000?ooool03?ooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo02[ooooo000Gooooo`03o`000?oooooooooo0;7ooooo00?o003oo`000?ooool02oooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo
0;;ooooo00?o003oo`000?ooool02_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
02[ooooo000Gooooo`03o`000?oooooooooo0;?ooooo00?o003oo`000?ooool02Oooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0;Cooooo
00?o003oo`000?ooool02?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo
000Gooooo`03o`000?oooooooooo0;Gooooo00?o003oo`000?ooool01oooool00ol0003ooooooooo
o`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0;Kooooo00?o003o
o`000?ooool01_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Goooo
o`03o`000?oooooooooo0;Oooooo00?o003oo`000?l000001Oooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0;Sooooo00?o003oooooool0
00001?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`00
0?oooooooooo0;Wooooo00?o003oooooool000000oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0;[ooooo00?o003oooooool000000_oo
ool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooo
oooo0;_ooooo0_l00?l00ol0003oooooo`00000Iooooo`03o`000?oooooooooo02[ooooo000Goooo
o`03o`000?oooooooooo0;gooooo00?o003oo`000?l000006Oooool00ol0003oooooooooo`0Zoooo
o`005oooool00ol0003oooooooooo`2nooooo`03o`00ool0003ooooo01Sooooo00?o0000oooooooo
ool0:_ooool001Oooooo00?o0000ooooooooool0_oooool00ol00?ooooooooooo`0Gooooo`03o`00
0?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0<3ooooo00?o003oooooooooool05_oo
ool00ol0003oooooooooo`0Zooooo`000oooool2o`0000Cooooo00?o0000ooooooooool00_ooool3
o`0000Kooooo00?o0000ooooooooool0`Oooool00ol00?ooooooooooo`0Eooooo`03o`000?oooooo
oooo02[ooooo0002ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00
0005ooooo`03o`000?oooooooooo0<;ooooo00?o003oooooooooool05?ooool00ol0003ooooooooo
o`0Zooooo`000_ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool00000
1Oooool00ol0003oooooooooo`33ooooo`03o`00oooooooooooo01?ooooo00?o0000ooooooooool0
:_ooool000;ooooo00Co0000oooooooooooo00001oooool4o`0000Kooooo0_l00035ooooo`03o`00
oooooooooooo01;ooooo00?o0000ooooooooool0:_ooool000;ooooo00Co0000oooooooooooo0000
1oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0<Gooooo00?o003oooooooooool0
4Oooool00ol0003oooooooooo`0Zooooo`000_ooool01?l0003oooooooooool00008ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0a_ooool00ol00?ooooooooooo`0@ooooo`03o`00
0?oooooooooo02[ooooo0003ooooo`;o00002_ooool2o`0000Kooooo00?o0000ooooooooool0aooo
ool00ol00?ooooooooooo`0?ooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooo
oooo0<Sooooo00?o003oooooooooool03_ooool00ol0003oooooooooo`0Zooooo`005oooool00ol0
003oooooooooo`39ooooo`03o`00oooooooooooo00gooooo00?o0000ooooooooool0:_ooool001Oo
oooo00?o0000ooooooooool0b_ooool00ol00?ooooooooooo`0<ooooo`03o`000?oooooooooo02[o
oooo000Gooooo`03o`000?oooooooooo0<_ooooo00?o003oooooooooool02oooool00ol0003ooooo
ooooo`0Zooooo`005oooool00ol0003oooooooooo`3<ooooo`03o`00oooooooooooo00[ooooo00?o
0000ooooooooool0:_ooool001Oooooo00?o0000ooooooooool0cOooool00ol00?ooooooooooo`09
ooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oooooooooo0<kooooo00?o003ooooo
ooooool02?ooool00ol0003oooooooooo`0Zooooo`005oooool00ol0003oooooooooo`3?ooooo`03
o`00oooooooooooo00Oooooo00?o0000ooooooooool0:_ooool001Oooooo00?o0000ooooooooool0
d?ooool00ol00?ooooooooooo`06ooooo`03o`000?oooooooooo02[ooooo000Gooooo`03o`000?oo
oooooooo0=7ooooo00?o003oooooooooool01Oooool00ol0003oooooooooo`0Zooooo`005oooool0
0ol0003oooooooooo`3Booooo`03o`00oooooooooooo00Cooooo00?o0000ooooooooool0:_ooool0
01Oooooo00?o0000ooooooooool0doooool00ol00?ooooooooooo`03ooooo`03o`000?oooooooooo
02[ooooo000Gooooo`03o`000?oooooooooo0=Cooooo00?o003oooooooooool00_ooool00ol0003o
ooooooooo`0Zooooo`005oooool00ol0003oooooooooo`3Eooooo`05o`00ooooooooooooooooool0
0000;?ooool001Oooooo00?o0000ooooooooool0e_ooool01?l00?ooooooooooool0000/ooooo`00
5oooool00ol0003oooooooooo`3Gooooo`03o`00oooooooo000002cooooo000Gooooo`03o`000?oo
oooooooo0=Sooooo00?o003oo`000?l00000:oooool001Oooooo00?o0000ooooooooool0fOooool0
0ol00?oo0000ooooo`0Zooooo`005oooool00ol0003oooooooooo`3Jooooo`03o`00ool0003ooooo
02Wooooo000Gooooo`03o`000?oooooooooo0=_ooooo00?o003oooooooooool0:?ooool001Oooooo
00?o0000ooooooooool0g?ooool00ol00?ooooooooooo`0Wooooo`005oooool00ol0003ooooooooo
o`3Mooooo`03o`00oooooooooooo02Kooooo000Gooooo`03o`000?oooooooooo0=kooooo00?o003o
ooooooooool09Oooool001Oooooo00?o0000ooooooooool0goooool00ol00?ooooooooooo`0Toooo
o`005oooool00ol0003oooooooooo`3Pooooo`03o`00ool0003ooooo02?ooooo0003ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`?o00001_ooool00ol0003oooooooooo`3Qooooo`03o`00
ool0003ooooo02;ooooo0002ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooo
ooooo`000005ooooo`03o`000?oooooooooo0>;ooooo00?o003oo`000?oo00000ooo000Nooooo`00
0_ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001Oooool00ol0
003oooooooooo`3Sooooo`03o`00oooo003oo`0000?oo`007Oooool000;ooooo00Co0000oooooooo
oooo00002?ooool3o`0000Kooooo0_l0003Sooooo`;oo`0000Co003oo`3o0?l0o`3o0?l00_oo000L
ooooo`000_ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001Ooo
ool00ol0003oooooooooo`3Rooooo`;oo`000ol00?l2o`3o0003ool00?oooooooooo01[ooooo0002
ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000005ooooo`03o`00
0?oooooooooo0>;ooooo0_oo0003o`00o`;o0?l000?oo`00ooooooooool06_ooool000?ooooo0_l0
0009ooooo`?o00001_ooool00ol0003oooooooooo`3Rooooo`;oo`000ol00?l2o`3o0003ool00?oo
oooooooo01[ooooo000Gooooo`03o`000?oooooooooo0>?ooooo0_oo0003o`3o0003ool00?oooooo
oooo01_ooooo000Gooooo`03o`000?oooooooooo0>Cooooo1?oo000Nooooo`005oooool00ol0003o
ooooooooo`3oooooo`Oooooo000Gooooo`03o`000?oooooooooo0?oooooo1oooool001Oooooo00?o
0000ooooooooool0ooooool7ooooo`005oooool00ol0003oooooooooo`3oooooo`Oooooo000Goooo
o`03o`000?oooooooooo0?oooooo1oooool001Oooooo00?o0000ooooooooool0ooooool7ooooo`00
5oooool00ol0003oooooooooo`3oooooo`Oooooo000Gooooo`03o`000?oooooooooo0?oooooo1ooo
ool001Oooooo00?o0000ooooooooool0ooooool7ooooo`005oooool00ol0003oooooooooo`3ooooo
o`Oooooo000Gooooo`03o`000?oooooooooo0?oooooo1oooool001Oooooo00?o0000ooooooooool0
ooooool7ooooo`005oooool00ol0003oooooooooo`3oooooo`Oooooo000Gooooo`03o`000?oooooo
oooo0?oooooo1oooool001Oooooo00?o0000ooooooooool0ooooool7ooooo`005oooool00ol0003o
ooooooooo`3oooooo`Oooooo000Gooooo`03o`000?oooooooooo0?oooooo1oooool001Oooooo00?o
0000ooooooooool0ooooool7ooooo`005oooool00ol0003oooooooooo`3oooooo`Oooooo000Goooo
o`03o`000?oooooooooo0?oooooo1oooool001Oooooo00?o0000ooooooooool0ooooool7ooooo`00
5oooool00ol0003oooooooooo`3oooooo`Oooooo000Gooooo`03o`000?oooooooooo0?oooooo1ooo
ool000kooooo0ol00006ooooo`03o`000?oooooooooo0?oooooo1oooool000oooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`3oooooo`Oooooo000?ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool0ooooool7ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000
ooooool8ooooo`003oooool00ol0003oooooooooo`3oooooo`oooooo000>ooooo`;o0000oooooolA
ooooo`003oooool00ol0003oooooooooo`3oooooo`oooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0888029, -0.0764114, \
0.00385797, 0.00624232}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({0.018375000000000002`, {x \[Rule] 0.4`}}\), 
        ",", \({"Steps" \[Rule] 1, "Function" \[Rule] 6, 
          "Gradient" \[Rule] 2}\), ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[f6[{x, 0, 0, 0}], {x, 0.3, 0.5}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.40476 4.76191 0.0147151 2.35442 [
[.2619 .00222 -12 -9 ]
[.2619 .00222 12 0 ]
[.5 .00222 -9 -9 ]
[.5 .00222 9 0 ]
[.7381 .00222 -12 -9 ]
[.7381 .00222 12 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.01131 .13244 -24 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -24 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -24 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.35)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(0.4)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(0.45)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(0.5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.05)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.1)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.15)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.2)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.25)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29724 m
.02756 .29724 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57977 m
.02756 .57977 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .22661 m
.06244 .23823 L
.10458 .25125 L
.14415 .26382 L
.18221 .27621 L
.22272 .28973 L
.24141 .29608 L
.25127 .29946 L
.25666 .30132 L
.2593 .30223 L
.26045 .30263 L
.26171 .30306 L
.26301 .05798 L
.26425 .05798 L
.26698 .05798 L
.27279 .05798 L
.28302 .05798 L
.30316 .05798 L
.3438 .05798 L
.38293 .05798 L
.42451 .05798 L
.46458 .05798 L
.50313 .05798 L
.54413 .05798 L
.58362 .05798 L
.62159 .05798 L
.66202 .05798 L
.70093 .05798 L
.7111 .05798 L
.72217 .05798 L
.72723 .05798 L
.73262 .05798 L
.73483 .05798 L
.73599 .05798 L
.73721 .05798 L
.73786 .05798 L
.73858 .4917 L
.73983 .49226 L
.74229 .49335 L
.78285 .51161 L
.82189 .5295 L
.86339 .54887 L
.90337 .56787 L
.94184 .58646 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00Coooool2o`0000Cooooo00?o0000ooooooooool0
0_ooool3o`0000?ooooo0ol0000^ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`?o0000
;Oooool2o`0000Cooooo00?o0000ooooooooool00oooool3o`0000;ooooo0ol0000^ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`?o00000oooool004kooooo00Co0000oooooooooooo0000
1oooool01ol0003ooooooooooooooooo0000ooooool000000oooool00ol0003oooooooooo`0Zoooo
o`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool0:oooool01?l0003oooooooooool0
000:ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool0:_ooool01?l0003ooooo
ooooool00007ooooo`05o`000?ooooooooooooooool000000_ooool004kooooo00Co0000oooooooo
oooo00002oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02[ooooo00Co0000oooo
oooooooo00001oooool5o`0002cooooo00Co0000oooooooooooo00001oooool5o`0000Gooooo00?o
0000ooooooooool0:_ooool01?l0003oooooooooool0000;ooooo`7o00000Oooool1ooooo`00C_oo
ool01?l0003oooooooooool00009ooooo`;o00001_ooool00ol0003oooooooooo`0Zooooo`04o`00
0?ooooooooooo`0000Oooooo00Co0000oooooooooooo0000;Oooool01?l0003oooooooooool00007
ooooo`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool0:_ooool01?l0003ooooooooo
ool0000;ooooo`7o00000Oooool1ooooo`00C_ooool01?l0003oooooooooool0000;ooooo`03o`00
0?oooooo000000?o0000;Oooool01?l0003oooooooooool00008ooooo`03o`000?oooooo000002go
oooo00Co0000oooooooooooo00002?ooool00ol0003oooooo`000002ooooo`Co0000;Oooool01?l0
003oooooooooool00007ooooo`Co00000oooool004kooooo00Co0000oooooooooooo00001oooool0
1ol0003ooooooooooooooooo0000ooooool00000<?ooool01?l0003oooooooooool00009ooooo`;o
0000;Oooool01?l0003oooooooooool00009ooooo`;o00000_ooool00ol0003oooooooooo`0^oooo
o`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool01?ooool004oooooo0_l00009oooo
o`?o00000_ooool5o`0002gooooo0_l0000;ooooo`03o`000?oooooooooo02cooooo0_l0000;oooo
o`03o`000?oooooooooo00Go0000;Oooool2o`0000Sooooo1Ol00002ooooo`00oooooolQooooo`00
6oooool00ol0003oooooooooo`3oooooo`?ooooo000Kooooo`03o`000?oooooooooo0?oooooo0ooo
ool001_ooooo00?o0000ooooooooool0ooooool3ooooo`005Oooooooo`0000Wo00000oooool001_o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Oo
oooo000Kooooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0??ooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool01oooool001_ooooo00?o
0000ooooooooool0ooooool3ooooo`006oooool00ol0003oooooooooo`3oooooo`?ooooo000Koooo
o`03o`000?oooooooooo0?oooooo0oooool001_ooooo00?o0000ooooooooool0ooooool3ooooo`00
6oooool2o`000?oooooo1?ooool001_ooooo00?o0000ooooooooool0ooooool3ooooo`006oooool0
0ol0003oooooooooo`3oooooo`?ooooo000Kooooo`03o`000?oooooooooo0?oooooo0oooool001_o
oooo00?o0000ooooooooool0ooooool3ooooo`006oooool00ol0003oooooooooo`0looooogko0000
B?ooool001_ooooo0_l0000mooooo`03o`000?oooooooooo07[ooooo00?o0000ooooooooool0A_oo
ool001_ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`1jooooo`03o`000?oooooo
oooo04Kooooo000Kooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0N_ooool00ol0
003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo07[o
oooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0??ooool00ol0003ooooo
ooooo`1jooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo03cooooo00?o
0000ooooooooool0N_ooool00ol0003oooooooooo`16ooooo`006oooool2o`0003gooooo00?o0000
ooooooooool0N_ooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`0loooo
o`03o`000?oooooooooo07[ooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000oooooooo
ool0??ooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`00
0?oooooooooo03cooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`16ooooo`006ooo
ool00ol0003oooooooooo`0looooo`03o`000?oooooooooo07[ooooo00?o0000ooooooooool0A_oo
ool001_ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`1jooooo`03o`000?oooooo
oooo04Kooooo000Kooooo`;o0000?Oooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo
04Kooooo000Kooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0N_ooool00ol0003o
ooooooooo`16ooooo`006oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo07[ooooo
00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0??ooool00ol0003ooooooooo
o`1jooooo`03o`000?oooooooooo04Kooooo0002ooooo`;o00001?ooool00ol0003oooooooooo`03
ooooo`;o00000oooool3o`0000Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`1j
ooooo`03o`000?oooooooooo04Kooooo00001Ooooooo0000oooooooooooo000000Sooooo00Ko0000
oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
??ooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo04Kooooo00001Ooooooo0000oooo
oooooooo000000Sooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02ooooo`;o
0000?Oooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo04Kooooo00001Ooooooo0000
oooooooooooo000000Sooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo03cooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`16oooo
o`0000Goooooo`000?ooooooooooo`000008ooooo`05o`000?ooooooooooo`000?ooool01?l00005
ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`16
ooooo`0000Goooooo`000?ooooooooooo`000008ooooo`06o`000?ooooooooooo`000?oooooo0000
2?ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo07[ooooo00?o0000ooooooooool0
A_ooool000;ooooo0_l0000:ooooo`;o00000_ooool5o`0000Cooooo00?o0000ooooooooool0??oo
ool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooo
oooo03cooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`16ooooo`006oooool00ol0
003oooooooooo`0looooo`03o`000?oooooooooo07[ooooo00?o0000ooooooooool0A_ooool001_o
oooo0_l0000mooooo`03o`000?oooooooooo07[ooooo00?o0000ooooooooool0A_ooool001_ooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo04Kooooo
000Kooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0N_ooool00ol0003ooooooooo
o`16ooooo`006oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo07[ooooo00?o0000
ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`1joooo
o`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo03cooooo00?o0000oooooooo
ool0N_ooool00ol0003oooooooooo`16ooooo`006oooool2o`0003gooooo00?o0000ooooooooool0
N_ooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`0kooooo`03o`000?oo
oooooooo07_ooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0>oooool0
0ol0003oooooooooo`1kooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo
03_ooooo00?o0000ooooooooool0Noooool00ol0003oooooooooo`16ooooo`006oooool00ol0003o
ooooooooo`0kooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool0A_ooool001_ooooo
00?o0000ooooooooool0>oooool00ol0003oooooooooo`1kooooo`03o`000?oooooooooo04Kooooo
000Kooooo`;o0000??ooool00ol0003oooooooooo`1kooooo`03o`000?oooooooooo04Kooooo000K
ooooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0Noooool00ol0003oooooooooo`16
ooooo`006oooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo07_ooooo00?o0000oooo
ooooool0A_ooool001_ooooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`1kooooo`03
o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0
Noooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`0kooooo`03o`000?oo
oooooooo07_ooooo00?o0000ooooooooool0A_ooool001_ooooo0ol0000kooooo`03o`000?oooooo
oooo07_ooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool00ol0000hoooo
o`03o`000?oooooooooo07_ooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000oooooooo
ool00oooool3o`0003Gooooo00?o0000ooooooooool0Noooool00ol0003oooooooooo`16ooooo`00
6oooool00ol0003oooooooooo`06ooooo`?o0000<_ooool00ol0003oooooooooo`1kooooo`03o`00
0?oooooooooo04Kooooo0008ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001Ooo
ool00ol0003oooooooooo`09ooooo`?o0000;oooool00ol0003oooooooooo`1kooooo`03o`000?oo
oooooooo04Kooooo0007ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0<ooooo`?o0000;?ooool00ol0003oooooooooo`1kooooo`03o`000?oo
oooooooo04Kooooo0007ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?oo
ool2o`00013ooooo0ol0000Yooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool0A_oo
ool000Oooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01;ooooo0ol0000Vooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool0A_oo
ool000Oooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01Gooooo0ol0000Sooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool0A_oo
ool000Oooooo00Co0000oooooooooooo00002?ooool2o`0000Kooooo00?o0000ooooooooool06?oo
ool3o`00023ooooo00?o0000ooooooooool0Noooool00ol0003oooooooooo`16ooooo`002?ooool2
o`0000[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Kooooo`Co00007?ooool0
0ol0003oooooooooo`1kooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo
01oooooo0ol0000Iooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool0A_ooool001_o
oooo00?o0000ooooooooool08_ooool3o`0001Kooooo00?o0000ooooooooool0Noooool00ol0003o
ooooooooo`16ooooo`006oooool2o`0002Kooooo0ol0000Cooooo`03o`000?oooooooooo07_ooooo
00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0:?ooool3o`00013ooooo00?o
0000ooooooooool0Noooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`0[
ooooo`?o00003Oooool00ol0003oooooooooo`1kooooo`03o`000?oooooooooo04Kooooo000Koooo
o`03o`000?oooooooooo02kooooo0ol0000:ooooo`03o`000?oooooooooo07_ooooo00?o0000oooo
ooooool0A_ooool001_ooooo00?o0000ooooooooool0<Oooool2o`0000Sooooo00?o0000oooooooo
ool0Noooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`0cooooo`?o0000
1Oooool00ol0003oooooooooo`1kooooo`03o`000?oooooooooo04Kooooo000Kooooo`;o0000=ooo
ool4o`000003ooooool0003ooooo07cooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000
ooooooooool0>_ooool2o`0007gooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000oooo
ooooool0^Oooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`2iooooo`03
o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool0
A_ooool001_ooooo00?o0000ooooooooool0^Oooool00ol0003oooooooooo`16ooooo`006oooool2
o`000;[ooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0^Oooool00ol0
003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo04Ko
oooo000Kooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool0A_ooool001_ooooo00?o
0000ooooooooool0^Oooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`2i
ooooo`03o`000?oooooooooo04Kooooo000Kooooo`;o0000^_ooool00ol0003oooooooooo`16oooo
o`006oooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`00
0?oooooooooo0;Wooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0^Ooo
ool00ol0003oooooooooo`16ooooo`000_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3
o`0000?ooooo0ol00005ooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool0A_ooool0
0005ooooool0003oooooooooool000002Oooool01Ol0003ooooooooooooooooo000000?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo04Kooooo0000
1Ooooooo0000oooooooooooo000000Wooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`02ooooo`;o0000^_ooool00ol0003oooooooooo`16ooooo`0000Goooooo`000?ooooooooooo`00
0009ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`2iooooo`03o`000?oooooooooo04Kooooo00001Ooooooo0000oooooooooooo000000Wooooo00Co
0000oooooooooooooooo1?l00005ooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool0
A_ooool00005ooooool0003oooooooooool000002?ooool2o`0000?ooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo04Kooooo0002ooooo`;o00002_oo
ool01?l0003oooooooooooooool5o`0000Cooooo00?o0000ooooooooool0^Oooool00ol0003ooooo
ooooo`16ooooo`006oooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo04Kooooo000K
ooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool0A_ooool001_ooooo0_l0002joooo
o`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo0;Wooooo00?o0000oooooooo
ool0A_ooool001_ooooo00?o0000ooooooooool0^Oooool00ol0003oooooooooo`16ooooo`006ooo
ool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooo
oooo0;Wooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0^Oooool00ol0
003oooooooooo`16ooooo`006oooool2o`000;[ooooo00?o0000ooooooooool0A_ooool001_ooooo
00?o0000ooooooooool0^Oooool00ol0003oooooooooo`16ooooo`006oooool00ol0003ooooooooo
o`2iooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo0;Wooooo00?o0000
ooooooooool0A_ooool001_ooooo00?o0000ooooooooool0^Oooool00ol0003oooooooooo`16oooo
o`006oooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo04Kooooo000Kooooo`;o0000
^_ooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`2iooooo`03o`000?oo
oooooooo04Kooooo000Kooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool0A_ooool0
01_ooooo00?o0000ooooooooool0^Oooool00ol0003oooooooooo`16ooooo`006oooool00ol0003o
ooooooooo`2iooooo`03o`000?oooooooooo04Kooooo000Kooooo`03o`000?oooooooooo0;Wooooo
00?o0000ooooooooool0A_ooool001_ooooo0_l0002jooooo`03o`000?oooooooooo04Kooooo000K
ooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool0A_ooool001_ooooo00?o0000oooo
ooooool0^Oooool00ol0003oooooooooo`16ooooo`006oooool00ol0003oooooooooo`2iooooo`03
o`000?oooooooooo04Kooooo0008ooooo`;o00001?ooool01?l0003oooooooooooooool5o`0000Co
oooo00?o0000ooooooooool0^Oooool00ol0003oooooooooo`16ooooo`001oooool01?l0003ooooo
ooooool00008ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool0^Oooool00ol0
003oooooooooo`16ooooo`001oooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo
00Cooooo0_l0002jooooo`03o`000?oooooooooo04Kooooo0007ooooo`04o`000?ooooooooooo`00
00[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo
04Kooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004
ooooo`03o`000?oooooooooo0;Wooooo0ol00016ooooo`001oooool01?l0003oooooooooool00007
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`2looooo`;o0000A?oo
ool000Sooooo0_l00009ooooo`?o00001Oooool00ol0003oooooooooo`2nooooo`?o0000@Oooool0
01_ooooo00?o0000ooooooooool0`Oooool2o`0003oooooo000Kooooo`03o`000?oooooooooo0<?o
oooo0_l0000mooooo`006oooool2o`000<Kooooo0_l0000kooooo`006oooool00ol0003ooooooooo
o`37ooooo`;o0000>Oooool001_ooooo00?o0000ooooooooool0bOooool2o`0003Oooooo000Koooo
o`03o`000?oooooooooo0<_ooooo0_l0000eooooo`006oooool00ol0003oooooooooo`3=ooooo`;o
0000<oooool001_ooooo00?o0000ooooooooool0coooool2o`00037ooooo000Kooooo`;o0000d_oo
ool2o`0002oooooo000Kooooo`03o`000?oooooooooo0=?ooooo0ol0000/ooooo`006oooool00ol0
003oooooooooo`3Fooooo`;o0000:_ooool001_ooooo00?o0000ooooooooool0f?ooool2o`0002So
oooo000Kooooo`03o`000?oooooooooo0=[ooooo0_l0000Vooooo`006oooool00ol0003ooooooooo
o`3Looooo`;o00009?ooool001_ooooo0_l0003Oooooo`;o00008_ooool001_ooooo00?o0000oooo
ooooool0h?ooool2o`00023ooooo000Kooooo`03o`000?oooooooooo0>;ooooo0_l0000Nooooo`00
6oooool00ol0003oooooooooo`3Tooooo`;o00007?ooool001_ooooo00?o0000ooooooooool0i_oo
ool2o`0001[ooooo000Kooooo`03o`000?oooooooooo0>Sooooo0_l0000Hooooo`006oooool2o`00
0>_ooooo0_l0000Fooooo`006oooool00ol0003oooooooooo`3/ooooo`;o00005?ooool001_ooooo
00?o0000ooooooooool0k_ooool2o`0001;ooooo000Kooooo`03o`000?oooooooooo0?3ooooo0ol0
000?ooooo`000_ooool2o`0000Cooooo00Co0000oooooooooooooooo1Ol00002ooooo`?o00001Ooo
ool00ol0003oooooooooo`3cooooo`;o00003Oooool00005ooooool0003oooooooooool000002?oo
ool01_l0003oooooooooool0003oooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`3eooooo`?o00002_ooool00005ooooool0003oooooooooool000002Oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00;ooooo0_l0003iooooo`03o`000?oooooooooo00Oo
oooo00001Ooooooo0000oooooooooooo000000[ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0?oooooo0oooool00005ooooool0003oooooooooool0
00001oooool01_l0003ooooooooooooooooo0000ooooo`Co00001Oooool00ol0003oooooooooo`3o
ooooo`?ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Oo0000ooooooooooooooooo`00
0?oooooo000000Sooooo00?o0000ooooooooool0ooooool3ooooo`000_ooool2o`0000Wooooo0ol0
0002ooooo`Go00001?ooool00ol0003oooooooooo`3oooooo`?ooooo003oooooob7ooooo003ooooo
ob7ooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0.278228, -0.0240252, \
0.000797743, 0.00161347}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rosenbrock's Function", "Section"],

Cell[BoxData[
    \(Rosenbrock[coeff_List] := \ 
      Total[\ 100\ \((Drop[coeff, 1] - 
                  Drop[coeff, \(-1\)]^2)\)^2\  + \ \((1 - 
                Drop[coeff, \(-1\)])\)^2]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\[IndentingNewLine]ContourPlot[
          Rosenbrock[{x1, x2}], \ {x1, 0, 2}, {x2, 0, 2}, 
          ColorFunction \[Rule] \((Hue[0.7\ \((1 - #)\)] &)\), 
          ContourLines \[Rule] False, 
          Contours \[Rule] \ 60], \[IndentingNewLine]Plot3D[
          Rosenbrock[{x1, x2}], {x1, 0, 2}, {x2, 0, 
            2}]\[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.480769 0.0192308 0.480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -9 -9 ]
[.25962 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -18 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(0.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(1)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.13 0 1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.06 0 1 r
.01923 .15163 m
.05929 .15645 L
.09936 .16778 L
.12863 .17949 L
.13942 .18529 L
.17949 .20992 L
.19338 .21955 L
.21955 .24085 L
.24072 .25962 L
.25962 .2783 L
.27978 .29968 L
.29968 .32237 L
.31365 .33974 L
.33974 .37288 L
.34425 .37981 L
.37288 .41987 L
.37981 .42994 L
.39771 .45994 L
.41987 .49374 L
.4216 .5 L
.44543 .54006 L
.45994 .56413 L
.46363 .58013 L
.48823 .62019 L
.5 .64095 L
.50973 .66026 L
.52686 .70032 L
.54006 .72438 L
.54758 .74038 L
.56126 .78045 L
.58013 .81425 L
.58293 .82051 L
.5998 .86058 L
.61523 .90064 L
.62019 .91071 L
.63219 .94071 L
.64173 .98077 L
.01923 .98077 L
F
0 .01 1 r
.01923 .25069 m
.05929 .25481 L
.08575 .25962 L
.09936 .26554 L
.13942 .28293 L
.16882 .29968 L
.17949 .30684 L
.21955 .33739 L
.22234 .33974 L
.25962 .37458 L
.26475 .37981 L
.29968 .41833 L
.30098 .41987 L
.33309 .45994 L
.33974 .46875 L
.36217 .5 L
.37981 .52577 L
.38902 .54006 L
.41426 .58013 L
.41987 .58935 L
.43761 .62019 L
.45994 .65953 L
.46031 .66026 L
.4812 .70032 L
.5 .73638 L
.5018 .74038 L
.52097 .78045 L
.54006 .81978 L
.54035 .82051 L
.55769 .86058 L
.57601 .90064 L
.58013 .90986 L
.59193 .94071 L
.60922 .98077 L
.01923 .98077 L
F
0 .08 1 r
.01923 .31867 m
.05929 .32262 L
.09936 .33318 L
.11738 .33974 L
.13942 .35039 L
.17949 .37421 L
.18764 .37981 L
.21955 .40467 L
.23693 .41987 L
.25962 .44174 L
.27707 .45994 L
.29968 .48543 L
.31183 .5 L
.33974 .53573 L
.34295 .54006 L
.37134 .58013 L
.37981 .59269 L
.39758 .62019 L
.41987 .65624 L
.42224 .66026 L
.44536 .70032 L
.45994 .72645 L
.46733 .74038 L
.48834 .78045 L
.5 .80327 L
.50833 .82051 L
.52768 .86058 L
.54006 .88671 L
.54621 .90064 L
.56415 .94071 L
.58013 .97668 L
.58173 .98077 L
.01923 .98077 L
F
0 .15 1 r
.01923 .37383 m
.05929 .37768 L
.07408 .37981 L
.09936 .38818 L
.13942 .40531 L
.16553 .41987 L
.17949 .42906 L
.21955 .45943 L
.22015 .45994 L
.25962 .49646 L
.26312 .5 L
.29965 .54006 L
.29968 .5401 L
.33198 .58013 L
.33974 .59039 L
.36128 .62019 L
.37981 .64731 L
.38829 .66026 L
.41349 .70032 L
.41987 .71086 L
.43712 .74038 L
.45962 .78045 L
.45994 .78102 L
.48086 .82051 L
.5 .85784 L
.50134 .86058 L
.5208 .90064 L
.5398 .94071 L
.54006 .94128 L
.55779 .98077 L
.01923 .98077 L
F
0 .22 1 r
.01923 .42151 m
.05929 .42531 L
.09936 .43575 L
.13942 .45282 L
.15294 .45994 L
.17949 .47653 L
.21128 .5 L
.21955 .50687 L
.25584 .54006 L
.25962 .54385 L
.29335 .58013 L
.29968 .58748 L
.32635 .62019 L
.33974 .63774 L
.35615 .66026 L
.37981 .69463 L
.38356 .70032 L
.40905 .74038 L
.41987 .75817 L
.43297 .78045 L
.45564 .82051 L
.45994 .82834 L
.47711 .86058 L
.49773 .90064 L
.5 .90514 L
.51737 .94071 L
.53642 .98077 L
.01923 .98077 L
F
0 .29 1 r
.01923 .46412 m
.05929 .46787 L
.09936 .47827 L
.13942 .4953 L
.14854 .5 L
.17949 .51898 L
.20834 .54006 L
.21955 .5493 L
.25347 .58013 L
.25962 .58625 L
.29132 .62019 L
.29968 .62986 L
.32455 .66026 L
.33974 .6801 L
.35453 .70032 L
.37981 .73698 L
.38206 .74038 L
.40765 .78045 L
.41987 .80051 L
.43166 .82051 L
.45439 .86058 L
.45994 .87067 L
.47594 .90064 L
.49659 .94071 L
.5 .94746 L
.5163 .98077 L
.01923 .98077 L
F
0 .36 1 r
.01923 .50298 m
.05929 .5067 L
.09936 .51707 L
.13942 .53408 L
.15093 .54006 L
.17949 .55773 L
.21 .58013 L
.21955 .58803 L
.25484 .62019 L
.25962 .62496 L
.29252 .66026 L
.29968 .66855 L
.32563 .70032 L
.33974 .71878 L
.35552 .74038 L
.37981 .77565 L
.38298 .78045 L
.40852 .82051 L
.41987 .83917 L
.43248 .86058 L
.45517 .90064 L
.45994 .90933 L
.47669 .94071 L
.4973 .98077 L
.01923 .98077 L
F
0 .43 1 r
.01923 .53895 m
.03332 .54006 L
.05929 .54264 L
.09936 .55299 L
.13942 .56997 L
.15833 .58013 L
.17949 .59361 L
.21515 .62019 L
.21955 .62388 L
.25907 .66026 L
.25962 .66081 L
.2962 .70032 L
.29968 .70438 L
.32893 .74038 L
.33974 .7546 L
.35854 .78045 L
.37981 .81147 L
.38578 .82051 L
.41114 .86058 L
.41987 .87498 L
.43496 .90064 L
.45751 .94071 L
.45994 .94513 L
.47893 .98077 L
.01923 .98077 L
F
0 .5 1 r
.01923 .57259 m
.05929 .57626 L
.084 .58013 L
.09936 .58658 L
.13942 .60355 L
.169 .62019 L
.17949 .62717 L
.21955 .65743 L
.22291 .66026 L
.25962 .69434 L
.26551 .70032 L
.29968 .7379 L
.30179 .74038 L
.33396 .78045 L
.33974 .78812 L
.36314 .82051 L
.37981 .84498 L
.39005 .86058 L
.41514 .90064 L
.41987 .90848 L
.43873 .94071 L
.45994 .97863 L
.4611 .98077 L
.01923 .98077 L
F
0 .57 1 r
.01923 .60429 m
.05929 .60795 L
.09936 .61825 L
.10528 .62019 L
.13942 .63521 L
.17949 .65881 L
.18165 .66026 L
.21955 .68906 L
.23262 .70032 L
.25962 .72597 L
.2736 .74038 L
.29968 .76952 L
.30888 .78045 L
.33974 .81972 L
.34034 .82051 L
.369 .86058 L
.37981 .87658 L
.39549 .90064 L
.41987 .94007 L
.42025 .94071 L
.44356 .98077 L
.01923 .98077 L
F
0 .64 1 r
.01923 .63437 m
.05929 .63801 L
.09936 .64829 L
.1299 .66026 L
.13942 .66523 L
.17949 .68883 L
.1959 .70032 L
.21955 .71907 L
.24362 .74038 L
.25962 .75597 L
.28292 .78045 L
.29968 .79951 L
.31711 .82051 L
.33974 .84971 L
.34778 .86058 L
.37585 .90064 L
.37981 .90656 L
.40187 .94071 L
.41987 .97005 L
.42624 .98077 L
.01923 .98077 L
F
0 .71 1 r
.01923 .66303 m
.05929 .66666 L
.09936 .67694 L
.13942 .69387 L
.15183 .70032 L
.17949 .71745 L
.21073 .74038 L
.21955 .74768 L
.2555 .78045 L
.25962 .78457 L
.29312 .82051 L
.29968 .82811 L
.3262 .86058 L
.33974 .8783 L
.35606 .90064 L
.37981 .93515 L
.38349 .94071 L
.40901 .98077 L
.01923 .98077 L
F
0 .78 1 r
.01923 .69048 m
.05929 .69409 L
.09276 .70032 L
.09936 .70436 L
.13942 .72128 L
.17286 .74038 L
.17949 .74485 L
.21955 .77508 L
.22589 .78045 L
.25962 .81196 L
.26801 .82051 L
.29968 .8555 L
.304 .86058 L
.33595 .90064 L
.33974 .90568 L
.36498 .94071 L
.37981 .96252 L
.39176 .98077 L
.01923 .98077 L
F
0 .85 1 r
.01923 .71685 m
.05929 .72045 L
.09936 .73071 L
.12508 .74038 L
.13942 .74762 L
.17949 .77119 L
.19286 .78045 L
.21955 .80141 L
.24127 .82051 L
.25962 .83828 L
.28093 .86058 L
.29968 .88181 L
.31536 .90064 L
.33974 .93199 L
.34621 .94071 L
.3744 .98077 L
.01923 .98077 L
F
0 .92 1 r
.01923 .74225 m
.05929 .74585 L
.09936 .7561 L
.13942 .773 L
.15365 .78045 L
.17949 .79656 L
.21201 .82051 L
.21955 .82677 L
.25656 .86058 L
.25962 .86364 L
.29406 .90064 L
.29968 .90717 L
.32705 .94071 L
.33974 .95734 L
.35684 .98077 L
.01923 .98077 L
F
0 .99 1 r
.01923 .7668 m
.05929 .77038 L
.09922 .78045 L
.09936 .78062 L
.13942 .79752 L
.17867 .82051 L
.17949 .82107 L
.21955 .85128 L
.23041 .86058 L
.25962 .88815 L
.27179 .90064 L
.29968 .93167 L
.30732 .94071 L
.33894 .98077 L
.01923 .98077 L
F
0 1 .94 r
.01923 .79056 m
.05929 .79414 L
.09936 .80437 L
.13807 .82051 L
.13942 .82126 L
.17949 .84481 L
.20162 .86058 L
.21955 .87502 L
.2482 .90064 L
.25962 .91188 L
.28686 .94071 L
.29968 .95539 L
.32063 .98077 L
.01923 .98077 L
F
0 1 .87 r
.01923 .81361 m
.05929 .81718 L
.08196 .82051 L
.09936 .82741 L
.13942 .8443 L
.16852 .86058 L
.17949 .86784 L
.21955 .89804 L
.22266 .90064 L
.25962 .93489 L
.26536 .94071 L
.29968 .97841 L
.3017 .98077 L
.01923 .98077 L
F
0 1 .8 r
.01923 .83601 m
.05929 .83958 L
.09936 .8498 L
.12753 .86058 L
.13942 .86668 L
.17949 .89022 L
.19447 .90064 L
.21955 .92041 L
.24256 .94071 L
.25962 .95726 L
.28205 .98077 L
.01923 .98077 L
F
0 1 .73 r
.01923 .85782 m
.05187 .86058 L
.05929 .86138 L
.09936 .87159 L
.13942 .88847 L
.16186 .90064 L
.17949 .912 L
.21779 .94071 L
.21955 .94219 L
.25962 .97904 L
.26134 .98077 L
.01923 .98077 L
F
0 1 .66 r
.01923 .87907 m
.05929 .88262 L
.09936 .89283 L
.12087 .90064 L
.13942 .90971 L
.17949 .93323 L
.19037 .94071 L
.21955 .96342 L
.23938 .98077 L
.01923 .98077 L
F
0 1 .59 r
.01923 .89981 m
.03034 .90064 L
.05929 .90336 L
.09936 .91356 L
.13942 .93043 L
.15865 .94071 L
.17949 .95395 L
.21553 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .92007 m
.05929 .92361 L
.09936 .93382 L
.11868 .94071 L
.13942 .95068 L
.17949 .9742 L
.1891 .98077 L
.01923 .98077 L
F
0 1 .45 r
.01923 .93988 m
.03021 .94071 L
.05929 .94342 L
.09936 .95362 L
.13942 .97048 L
.15868 .98077 L
.01923 .98077 L
F
0 1 .38 r
.01923 .95928 m
.05929 .96281 L
.09936 .97301 L
.12078 .98077 L
.01923 .98077 L
F
0 1 .31 r
.01923 .97829 m
.04929 .98077 L
.01923 .98077 L
F
.06 0 1 r
.74644 .98077 m
.74038 .96269 L
.73315 .94071 L
.71961 .90064 L
.70821 .86058 L
.70032 .84464 L
.69169 .82051 L
.67728 .78045 L
.66325 .74038 L
.66026 .73413 L
.64746 .70032 L
.63676 .66026 L
.62019 .63 L
.61613 .62019 L
.59983 .58013 L
.58369 .54006 L
.58013 .53311 L
.56573 .5 L
.54957 .45994 L
.54006 .44261 L
.52933 .41987 L
.51202 .37981 L
.5 .35905 L
.49535 .33974 L
.4705 .29968 L
.45994 .28236 L
.45067 .25962 L
.42439 .21955 L
.41987 .2126 L
.40129 .17949 L
.37981 .14923 L
.37444 .13942 L
.34467 .09936 L
.33974 .09311 L
.31372 .05929 L
.29968 .04535 L
.27841 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .01 1 r
.7776 .98077 m
.76855 .94071 L
.75338 .90064 L
.74038 .8658 L
.73989 .86058 L
.72818 .82051 L
.71267 .78045 L
.70032 .74856 L
.69879 .74038 L
.68538 .70032 L
.66922 .66026 L
.66026 .63806 L
.65524 .62019 L
.63966 .58013 L
.62261 .54006 L
.62019 .53437 L
.60787 .5 L
.59032 .45994 L
.58013 .43733 L
.57365 .41987 L
.55574 .37981 L
.54006 .34711 L
.53712 .33974 L
.51848 .29968 L
.5 .26362 L
.49821 .25962 L
.47806 .21955 L
.45994 .18685 L
.45619 .17949 L
.43361 .13942 L
.41987 .11682 L
.40965 .09936 L
.38368 .05929 L
.37981 .05368 L
.35635 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .08 1 r
.79994 .98077 m
.78653 .94071 L
.78045 .92252 L
.7748 .90064 L
.76197 .86058 L
.74805 .82051 L
.74038 .79865 L
.73526 .78045 L
.72183 .74038 L
.70725 .70032 L
.70032 .6815 L
.69365 .66026 L
.6792 .62019 L
.66377 .58013 L
.66026 .5711 L
.64935 .54006 L
.63358 .5 L
.62019 .46741 L
.61748 .45994 L
.60153 .41987 L
.58424 .37981 L
.58013 .37046 L
.56737 .33974 L
.5492 .29968 L
.54006 .28022 L
.53087 .25962 L
.51154 .21955 L
.5 .19673 L
.4916 .17949 L
.47063 .13942 L
.45994 .11997 L
.44881 .09936 L
.42554 .05929 L
.41987 .05001 L
.40121 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .15 1 r
.81594 .98077 m
.80405 .94071 L
.79121 .90064 L
.78045 .86775 L
.77848 .86058 L
.76626 .82051 L
.75291 .78045 L
.74038 .74393 L
.73934 .74038 L
.72644 .70032 L
.7124 .66026 L
.70032 .62682 L
.69818 .62019 L
.68426 .58013 L
.6693 .54006 L
.66026 .51644 L
.65442 .5 L
.63918 .45994 L
.62308 .41987 L
.62019 .41279 L
.60728 .37981 L
.59049 .33974 L
.58013 .31585 L
.57341 .29968 L
.55578 .25962 L
.54006 .22564 L
.53734 .21955 L
.51858 .17949 L
.5 .14216 L
.49867 .13942 L
.47832 .09936 L
.45994 .06539 L
.45667 .05929 L
.43413 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .22 1 r
.82976 .98077 m
.82051 .95084 L
.81776 .94071 L
.80601 .90064 L
.79344 .86058 L
.78051 .82051 L
.78045 .82032 L
.76834 .78045 L
.75523 .74038 L
.74168 .70032 L
.74038 .69653 L
.72868 .66026 L
.71487 .62019 L
.70056 .58013 L
.70032 .57946 L
.6867 .54006 L
.67197 .5 L
.66026 .4691 L
.65696 .45994 L
.64188 .41987 L
.626 .37981 L
.62019 .36546 L
.61009 .33974 L
.59351 .29968 L
.58013 .26854 L
.5764 .25962 L
.55897 .21955 L
.5406 .17949 L
.54006 .17835 L
.522 .13942 L
.50227 .09936 L
.5 .09486 L
.48205 .05929 L
.46057 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .29 1 r
.84244 .98077 m
.83041 .94071 L
.82051 .90837 L
.81835 .90064 L
.80656 .86058 L
.79409 .82051 L
.78127 .78045 L
.78045 .7779 L
.76893 .74038 L
.75591 .70032 L
.74246 .66026 L
.74038 .65413 L
.72934 .62019 L
.7156 .58013 L
.70139 .54006 L
.70032 .53708 L
.68742 .5 L
.67277 .45994 L
.66026 .42674 L
.65776 .41987 L
.64269 .37981 L
.6269 .33974 L
.62019 .32311 L
.61094 .29968 L
.59443 .25962 L
.58013 .2262 L
.57733 .21955 L
.55993 .17949 L
.54165 .13942 L
.54006 .13601 L
.52303 .09936 L
.50341 .05929 L
.5 .05254 L
.4832 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .36 1 r
.85346 .98077 m
.84194 .94071 L
.82996 .90064 L
.82051 .86962 L
.81793 .86058 L
.80605 .82051 L
.79361 .78045 L
.78084 .74038 L
.78045 .73917 L
.76842 .70032 L
.7554 .66026 L
.742 .62019 L
.74038 .61542 L
.72881 .58013 L
.71507 .54006 L
.7009 .5 L
.70032 .49839 L
.68687 .45994 L
.67222 .41987 L
.66026 .38806 L
.65723 .37981 L
.6421 .33974 L
.62632 .29968 L
.62019 .28444 L
.61034 .25962 L
.59381 .21955 L
.58013 .18754 L
.57673 .17949 L
.55927 .13942 L
.541 .09936 L
.54006 .09735 L
.52233 .05929 L
.5027 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .43 1 r
.86345 .98077 m
.86058 .9709 L
.85222 .94071 L
.84063 .90064 L
.82866 .86058 L
.82051 .83374 L
.81668 .82051 L
.80469 .78045 L
.79224 .74038 L
.78045 .70331 L
.77954 .70032 L
.76701 .66026 L
.75397 .62019 L
.74057 .58013 L
.74038 .57958 L
.72733 .54006 L
.71356 .5 L
.70032 .46255 L
.69942 .45994 L
.6853 .41987 L
.67062 .37981 L
.66026 .35223 L
.65565 .33974 L
.64042 .29968 L
.62461 .25962 L
.62019 .24863 L
.60859 .21955 L
.59199 .17949 L
.58013 .15173 L
.5749 .13942 L
.55735 .09936 L
.54006 .06154 L
.53904 .05929 L
.52027 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .5 1 r
.8731 .98077 m
.86156 .94071 L
.86058 .93732 L
.85031 .90064 L
.83866 .86058 L
.82667 .82051 L
.82051 .80018 L
.81474 .78045 L
.80265 .74038 L
.79016 .70032 L
.78045 .66976 L
.77753 .66026 L
.76488 .62019 L
.75178 .58013 L
.74038 .54604 L
.73844 .54006 L
.72508 .5 L
.71125 .45994 L
.70032 .42903 L
.69715 .41987 L
.68291 .37981 L
.66816 .33974 L
.66026 .31872 L
.65318 .29968 L
.63785 .25962 L
.62198 .21955 L
.62019 .21512 L
.6059 .17949 L
.5892 .13942 L
.58013 .11822 L
.57207 .09936 L
.55438 .05929 L
.54006 .02805 L
.53602 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .57 1 r
.882 .98077 m
.87067 .94071 L
.86058 .90566 L
.85919 .90064 L
.84786 .86058 L
.83613 .82051 L
.82412 .78045 L
.82051 .76854 L
.81221 .74038 L
.80002 .70032 L
.78748 .66026 L
.78045 .63813 L
.77488 .62019 L
.76212 .58013 L
.74896 .54006 L
.74038 .51442 L
.73565 .5 L
.72218 .45994 L
.70827 .41987 L
.70032 .39741 L
.69417 .37981 L
.67981 .33974 L
.66499 .29968 L
.66026 .28712 L
.64998 .25962 L
.63452 .21955 L
.62019 .18352 L
.6186 .17949 L
.60241 .13942 L
.58559 .09936 L
.58013 .08663 L
.56838 .05929 L
.55053 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .64 1 r
.89027 .98077 m
.87916 .94071 L
.86778 .90064 L
.86058 .87563 L
.85638 .86058 L
.84492 .82051 L
.83312 .78045 L
.82108 .74038 L
.82051 .73853 L
.80916 .70032 L
.79688 .66026 L
.78429 .62019 L
.78045 .60812 L
.7717 .58013 L
.75883 .54006 L
.7456 .5 L
.74038 .48442 L
.7323 .45994 L
.7187 .41987 L
.70471 .37981 L
.70032 .36742 L
.6906 .33974 L
.67611 .29968 L
.66119 .25962 L
.66026 .25713 L
.64613 .21955 L
.63054 .17949 L
.62019 .15354 L
.61458 .13942 L
.59822 .09936 L
.58126 .05929 L
.58013 .05666 L
.56395 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .71 1 r
.89798 .98077 m
.8871 .94071 L
.87591 .90064 L
.86449 .86058 L
.86058 .847 L
.85313 .82051 L
.84156 .78045 L
.82969 .74038 L
.82051 .7099 L
.81769 .70032 L
.80566 .66026 L
.79329 .62019 L
.78065 .58013 L
.78045 .57951 L
.76804 .54006 L
.75506 .5 L
.74177 .45994 L
.74038 .45581 L
.72844 .41987 L
.71472 .37981 L
.70065 .33974 L
.70032 .33882 L
.68649 .29968 L
.67187 .25962 L
.66026 .22853 L
.65692 .21955 L
.64171 .17949 L
.62599 .13942 L
.62019 .12495 L
.60995 .09936 L
.59342 .05929 L
.58013 .02807 L
.57636 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .78 1 r
.90542 .98077 m
.90064 .96338 L
.89457 .94071 L
.88358 .90064 L
.87231 .86058 L
.86084 .82051 L
.86058 .81959 L
.84949 .78045 L
.83782 .74038 L
.82589 .70032 L
.82051 .68249 L
.81392 .66026 L
.80177 .62019 L
.78931 .58013 L
.78045 .55211 L
.77669 .54006 L
.76396 .5 L
.75088 .45994 L
.74038 .42842 L
.73757 .41987 L
.72413 .37981 L
.7103 .33974 L
.70032 .31144 L
.69621 .29968 L
.6819 .25962 L
.66716 .21955 L
.66026 .20115 L
.65215 .17949 L
.63677 .13942 L
.62091 .09936 L
.62019 .09757 L
.60477 .05929 L
.58805 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .85 1 r
.9126 .98077 m
.90165 .94071 L
.90064 .93703 L
.89082 .90064 L
.87973 .86058 L
.8684 .82051 L
.86058 .79324 L
.85698 .78045 L
.84551 .74038 L
.83374 .70032 L
.82175 .66026 L
.82051 .65616 L
.80978 .62019 L
.79752 .58013 L
.78498 .54006 L
.78045 .52578 L
.77236 .5 L
.7595 .45994 L
.74632 .41987 L
.74038 .4021 L
.73299 .37981 L
.71941 .33974 L
.70547 .29968 L
.70032 .28512 L
.69134 .25962 L
.67688 .21955 L
.662 .17949 L
.66026 .17484 L
.64692 .13942 L
.63137 .09936 L
.62019 .07126 L
.61542 .05929 L
.59909 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .92 1 r
.91943 .98077 m
.9086 .94071 L
.90064 .91164 L
.89769 .90064 L
.88677 .86058 L
.87559 .82051 L
.86419 .78045 L
.86058 .76786 L
.8528 .74038 L
.84121 .70032 L
.82936 .66026 L
.82051 .63079 L
.81737 .62019 L
.80531 .58013 L
.79294 .54006 L
.78045 .50042 L
.78032 .5 L
.76767 .45994 L
.75469 .41987 L
.74141 .37981 L
.74038 .37674 L
.72805 .33974 L
.71433 .29968 L
.70032 .25977 L
.70027 .25962 L
.68607 .21955 L
.67146 .17949 L
.66026 .14949 L
.6565 .13942 L
.64126 .09936 L
.62554 .05929 L
.62019 .04592 L
.60949 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 .99 1 r
.92594 .98077 m
.91524 .94071 L
.90435 .90064 L
.90064 .88711 L
.89348 .86058 L
.88245 .82051 L
.87118 .78045 L
.86058 .74334 L
.85974 .74038 L
.84833 .70032 L
.83663 .66026 L
.8247 .62019 L
.82051 .60628 L
.81272 .58013 L
.80053 .54006 L
.78806 .5 L
.78045 .47591 L
.77544 .45994 L
.76266 .41987 L
.74956 .37981 L
.74038 .35224 L
.73625 .33974 L
.72275 .29968 L
.7089 .25962 L
.70032 .23526 L
.6948 .21955 L
.68044 .17949 L
.66567 .13942 L
.66026 .12499 L
.65063 .09936 L
.63521 .05929 L
.62019 .02142 L
.61932 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .94 r
.93217 .98077 m
.9216 .94071 L
.91082 .90064 L
.90064 .86336 L
.89989 .86058 L
.88901 .82051 L
.87788 .78045 L
.86653 .74038 L
.86058 .7196 L
.85512 .70032 L
.84358 .66026 L
.83179 .62019 L
.82051 .58254 L
.8198 .58013 L
.80778 .54006 L
.79547 .5 L
.78291 .45994 L
.78045 .45218 L
.77027 .41987 L
.75735 .37981 L
.74414 .33974 L
.74038 .32851 L
.73078 .29968 L
.71714 .25962 L
.70315 .21955 L
.70032 .21154 L
.68899 .17949 L
.67445 .13942 L
.66026 .10127 L
.65954 .09936 L
.64439 .05929 L
.62877 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .87 r
.93813 .98077 m
.92769 .94071 L
.91703 .90064 L
.90618 .86058 L
.90064 .84032 L
.89529 .82051 L
.8843 .78045 L
.87307 .74038 L
.86165 .70032 L
.86058 .69657 L
.85024 .66026 L
.83859 .62019 L
.82671 .58013 L
.82051 .55951 L
.81472 .54006 L
.80257 .5 L
.79015 .45994 L
.78045 .42915 L
.77754 .41987 L
.7648 .37981 L
.75176 .33974 L
.74038 .30549 L
.73846 .29968 L
.72502 .25962 L
.71122 .21955 L
.70032 .18852 L
.69715 .17949 L
.68285 .13942 L
.66815 .09936 L
.66026 .07826 L
.65315 .05929 L
.6378 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .8 r
.94387 .98077 m
.94071 .96838 L
.93355 .94071 L
.92301 .90064 L
.91226 .86058 L
.90135 .82051 L
.90064 .81793 L
.89046 .78045 L
.87936 .74038 L
.86805 .70032 L
.86058 .67418 L
.85663 .66026 L
.84512 .62019 L
.83337 .58013 L
.8214 .54006 L
.82051 .53713 L
.80938 .5 L
.79711 .45994 L
.78459 .41987 L
.78045 .40678 L
.77195 .37981 L
.75907 .33974 L
.74591 .29968 L
.74038 .28312 L
.73256 .25962 L
.71896 .21955 L
.70503 .17949 L
.70032 .16616 L
.69088 .13942 L
.6764 .09936 L
.66154 .05929 L
.66026 .05589 L
.64642 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .73 r
.94941 .98077 m
.94071 .94658 L
.93919 .94071 L
.92876 .90064 L
.91812 .86058 L
.9073 .82051 L
.90064 .79614 L
.8964 .78045 L
.88542 .74038 L
.87422 .70032 L
.86283 .66026 L
.86058 .6524 L
.85141 .62019 L
.83978 .58013 L
.82793 .54006 L
.82051 .51535 L
.81594 .5 L
.80381 .45994 L
.79143 .41987 L
.78045 .385 L
.77882 .37981 L
.76611 .33974 L
.7531 .29968 L
.74038 .26134 L
.73981 .25962 L
.72639 .21955 L
.71264 .17949 L
.70032 .14438 L
.69858 .13942 L
.68431 .09936 L
.66966 .05929 L
.66026 .03412 L
.65468 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .66 r
.95478 .98077 m
.94464 .94071 L
.94071 .92534 L
.93432 .90064 L
.92378 .86058 L
.91305 .82051 L
.90216 .78045 L
.90064 .7749 L
.89127 .74038 L
.88018 .70032 L
.86889 .66026 L
.86058 .63116 L
.85747 .62019 L
.84597 .58013 L
.83423 .54006 L
.82228 .5 L
.82051 .49412 L
.81027 .45994 L
.79802 .41987 L
.78552 .37981 L
.78045 .36377 L
.77288 .33974 L
.76002 .29968 L
.74688 .25962 L
.74038 .24012 L
.73354 .21955 L
.71996 .17949 L
.70605 .13942 L
.70032 .12316 L
.69191 .09936 L
.67746 .05929 L
.66263 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .59 r
.96001 .98077 m
.94992 .94071 L
.94071 .9046 L
.93968 .90064 L
.92925 .86058 L
.91862 .82051 L
.90781 .78045 L
.90064 .75417 L
.89691 .74038 L
.88593 .70032 L
.87475 .66026 L
.86337 .62019 L
.86058 .61044 L
.85194 .58013 L
.84033 .54006 L
.82849 .5 L
.82051 .47339 L
.8165 .45994 L
.80438 .41987 L
.79201 .37981 L
.78045 .34305 L
.77941 .33974 L
.7667 .29968 L
.75371 .25962 L
.74043 .21955 L
.74038 .2194 L
.72702 .17949 L
.71328 .13942 L
.70032 .10245 L
.69924 .09936 L
.68498 .05929 L
.67034 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .52 r
.96513 .98077 m
.95505 .94071 L
.94489 .90064 L
.94071 .88435 L
.93455 .86058 L
.92401 .82051 L
.91329 .78045 L
.90241 .74038 L
.90064 .73392 L
.89151 .70032 L
.88042 .66026 L
.86914 .62019 L
.86058 .59019 L
.85772 .58013 L
.84622 .54006 L
.83449 .5 L
.82255 .45994 L
.82051 .45315 L
.81053 .41987 L
.79829 .37981 L
.7858 .33974 L
.78045 .32281 L
.77316 .29968 L
.7603 .25962 L
.74717 .21955 L
.74038 .19916 L
.73384 .17949 L
.72026 .13942 L
.70636 .09936 L
.70032 .08221 L
.69223 .05929 L
.67778 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .45 r
.97017 .98077 m
.96006 .94071 L
.94994 .90064 L
.94071 .86454 L
.93968 .86058 L
.92924 .82051 L
.91861 .78045 L
.90781 .74038 L
.90064 .71411 L
.89691 .70032 L
.88592 .66026 L
.87474 .62019 L
.86337 .58013 L
.86058 .57038 L
.85193 .54006 L
.84031 .5 L
.82848 .45994 L
.82051 .43335 L
.81649 .41987 L
.80437 .37981 L
.79199 .33974 L
.78045 .30301 L
.7794 .29968 L
.76669 .25962 L
.75369 .21955 L
.74042 .17949 L
.74038 .17937 L
.727 .13942 L
.71327 .09936 L
.70032 .06242 L
.69922 .05929 L
.68496 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .38 r
.97515 .98077 m
.96496 .94071 L
.95486 .90064 L
.94467 .86058 L
.94071 .84514 L
.93432 .82051 L
.92377 .78045 L
.91305 .74038 L
.90217 .70032 L
.90064 .69472 L
.89126 .66026 L
.88017 .62019 L
.86889 .58013 L
.86058 .551 L
.85747 .54006 L
.84596 .5 L
.83423 .45994 L
.82229 .41987 L
.82051 .41397 L
.81026 .37981 L
.79801 .33974 L
.78552 .29968 L
.78045 .28363 L
.77287 .25962 L
.76001 .21955 L
.74687 .17949 L
.74038 .15999 L
.73353 .13942 L
.71995 .09936 L
.70605 .05929 L
.70032 .04304 L
.6919 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .31 r
.98011 .98077 m
.96979 .94071 L
.95968 .90064 L
.94953 .86058 L
.94071 .82614 L
.93925 .82051 L
.92879 .78045 L
.91815 .74038 L
.90735 .70032 L
.90064 .67573 L
.89645 .66026 L
.88545 .62019 L
.87426 .58013 L
.86288 .54006 L
.86058 .532 L
.85144 .5 L
.83981 .45994 L
.82797 .41987 L
.82051 .39498 L
.81598 .37981 L
.80384 .33974 L
.79146 .29968 L
.78045 .26464 L
.77887 .25962 L
.76614 .21955 L
.75313 .17949 L
.74038 .141 L
.73986 .13942 L
.72642 .09936 L
.71267 .05929 L
.70032 .02406 L
.69862 .01923 L
.98077 .01923 L
.98077 .98077 L
F
0 1 .24 r
.98077 .96462 m
.97456 .94071 L
.96439 .90064 L
.95427 .86058 L
.94405 .82051 L
.94071 .80751 L
.93368 .78045 L
.92312 .74038 L
.91239 .70032 L
.90151 .66026 L
.90064 .6571 L
.89059 .62019 L
.87948 .58013 L
.86819 .54006 L
.86058 .51338 L
.85677 .5 L
.84524 .45994 L
.8335 .41987 L
.82155 .37981 L
.82051 .37635 L
.80951 .33974 L
.79724 .29968 L
.78474 .25962 L
.78045 .24602 L
.77209 .21955 L
.75921 .17949 L
.74606 .13942 L
.74038 .12238 L
.73271 .09936 L
.7191 .05929 L
.70518 .01923 L
.98077 .01923 L
F
0 1 .17 r
.98077 .94633 m
.9793 .94071 L
.96903 .90064 L
.95891 .86058 L
.94874 .82051 L
.94071 .78923 L
.93843 .78045 L
.92796 .74038 L
.9173 .70032 L
.90649 .66026 L
.90064 .63882 L
.89558 .62019 L
.88457 .58013 L
.87336 .54006 L
.86198 .5 L
.86058 .4951 L
.85053 .45994 L
.83888 .41987 L
.82702 .37981 L
.82051 .35808 L
.81503 .33974 L
.80287 .29968 L
.79047 .25962 L
.78045 .22775 L
.77787 .21955 L
.76511 .17949 L
.75209 .13942 L
.74038 .10411 L
.73881 .09936 L
.72534 .05929 L
.71157 .01923 L
.98077 .01923 L
F
0 1 .1 r
.98077 .92837 m
.97361 .90064 L
.96346 .86058 L
.95332 .82051 L
.94307 .78045 L
.94071 .77127 L
.93267 .74038 L
.92209 .70032 L
.91135 .66026 L
.90064 .62086 L
.90046 .62019 L
.88953 .58013 L
.8784 .54006 L
.8671 .5 L
.86058 .47715 L
.85568 .45994 L
.84412 .41987 L
.83236 .37981 L
.82051 .34013 L
.8204 .33974 L
.80834 .29968 L
.79605 .25962 L
.78353 .21955 L
.78045 .2098 L
.77086 .17949 L
.75795 .13942 L
.74478 .09936 L
.74038 .08617 L
.73141 .05929 L
.71777 .01923 L
.98077 .01923 L
F
0 1 .03 r
.98077 .91073 m
.97815 .90064 L
.96793 .86058 L
.9578 .82051 L
.94761 .78045 L
.94071 .75363 L
.93727 .74038 L
.92677 .70032 L
.9161 .66026 L
.90527 .62019 L
.90064 .60322 L
.89436 .58013 L
.88332 .54006 L
.8721 .5 L
.8607 .45994 L
.86058 .45951 L
.84923 .41987 L
.83756 .37981 L
.82568 .33974 L
.82051 .3225 L
.81367 .29968 L
.80149 .25962 L
.78907 .21955 L
.78045 .19217 L
.77645 .17949 L
.76366 .13942 L
.75061 .09936 L
.74038 .06854 L
.73731 .05929 L
.72381 .01923 L
.98077 .01923 L
F
.04 1 0 r
.98077 .89338 m
.97234 .86058 L
.9622 .82051 L
.95204 .78045 L
.94177 .74038 L
.94071 .73628 L
.93133 .70032 L
.92074 .66026 L
.90998 .62019 L
.90064 .58588 L
.89908 .58013 L
.88812 .54006 L
.87697 .5 L
.86565 .45994 L
.86058 .44217 L
.85422 .41987 L
.84263 .37981 L
.83085 .33974 L
.82051 .30516 L
.81888 .29968 L
.80679 .25962 L
.79447 .21955 L
.78192 .17949 L
.78045 .17484 L
.76923 .13942 L
.75629 .09936 L
.74308 .05929 L
.74038 .05121 L
.72969 .01923 L
.98077 .01923 L
F
.11 1 0 r
.98077 .87631 m
.97671 .86058 L
.96653 .82051 L
.95638 .78045 L
.94616 .74038 L
.94071 .71922 L
.9358 .70032 L
.92527 .66026 L
.91458 .62019 L
.90373 .58013 L
.90064 .56882 L
.89281 .54006 L
.88174 .5 L
.87049 .45994 L
.86058 .42512 L
.85909 .41987 L
.84759 .37981 L
.83589 .33974 L
.82399 .29968 L
.82051 .2881 L
.81196 .25962 L
.79974 .21955 L
.78729 .17949 L
.78045 .15778 L
.77466 .13942 L
.76183 .09936 L
.74873 .05929 L
.74038 .03415 L
.73541 .01923 L
.98077 .01923 L
F
.18 1 0 r
.98077 .85951 m
.97079 .82051 L
.96065 .78045 L
.95047 .74038 L
.94071 .70243 L
.94016 .70032 L
.9297 .66026 L
.91907 .62019 L
.90829 .58013 L
.90064 .55203 L
.89739 .54006 L
.8864 .5 L
.87523 .45994 L
.86388 .41987 L
.86058 .40833 L
.85243 .37981 L
.84081 .33974 L
.829 .29968 L
.82051 .27131 L
.81701 .25962 L
.80489 .21955 L
.79253 .17949 L
.78045 .141 L
.77995 .13942 L
.76723 .09936 L
.75425 .05929 L
.74101 .01923 L
.98077 .01923 L
F
.25 1 0 r
.98077 .84297 m
.97501 .82051 L
.96484 .78045 L
.95469 .74038 L
.94443 .70032 L
.94071 .68589 L
.93404 .66026 L
.92348 .62019 L
.91276 .58013 L
.90189 .54006 L
.90064 .53549 L
.89096 .5 L
.87986 .45994 L
.86858 .41987 L
.86058 .39179 L
.85716 .37981 L
.84563 .33974 L
.83389 .29968 L
.82196 .25962 L
.82051 .25478 L
.80992 .21955 L
.79765 .17949 L
.78517 .13942 L
.78045 .12447 L
.77251 .09936 L
.75964 .05929 L
.7465 .01923 L
.98077 .01923 L
F
.32 1 0 r
.98077 .82668 m
.97918 .82051 L
.96898 .78045 L
.95883 .74038 L
.94862 .70032 L
.94071 .6696 L
.93828 .66026 L
.92779 .62019 L
.91713 .58013 L
.90633 .54006 L
.90064 .5192 L
.89542 .5 L
.88439 .45994 L
.87318 .41987 L
.86181 .37981 L
.86058 .3755 L
.85034 .33974 L
.83869 .29968 L
.82684 .25962 L
.82051 .2385 L
.81484 .21955 L
.80267 .17949 L
.79027 .13942 L
.78045 .10818 L
.77767 .09936 L
.7649 .05929 L
.75187 .01923 L
.98077 .01923 L
F
.39 1 0 r
.98077 .81062 m
.97306 .78045 L
.96291 .74038 L
.95273 .70032 L
.94244 .66026 L
.94071 .65354 L
.93201 .62019 L
.92142 .58013 L
.91067 .54006 L
.90064 .50315 L
.89979 .5 L
.88883 .45994 L
.87769 .41987 L
.86639 .37981 L
.86058 .35945 L
.85495 .33974 L
.84338 .29968 L
.83161 .25962 L
.82051 .22244 L
.81965 .21955 L
.80757 .17949 L
.79526 .13942 L
.78273 .09936 L
.78045 .09213 L
.77005 .05929 L
.75712 .01923 L
.98077 .01923 L
F
.46 1 0 r
.98077 .79478 m
.9771 .78045 L
.96692 .74038 L
.95677 .70032 L
.94653 .66026 L
.94071 .6377 L
.93615 .62019 L
.92562 .58013 L
.91494 .54006 L
.9041 .5 L
.90064 .48732 L
.89318 .45994 L
.88211 .41987 L
.87087 .37981 L
.86058 .34362 L
.85947 .33974 L
.84798 .29968 L
.83628 .25962 L
.82439 .21955 L
.82051 .20662 L
.81237 .17949 L
.80015 .13942 L
.78771 .09936 L
.78045 .0763 L
.77508 .05929 L
.76226 .01923 L
.98077 .01923 L
F
.53 1 0 r
.98077 .77916 m
.97089 .74038 L
.96074 .70032 L
.95054 .66026 L
.94071 .62209 L
.94021 .62019 L
.92975 .58013 L
.91912 .54006 L
.90834 .5 L
.90064 .4717 L
.89744 .45994 L
.88645 .41987 L
.87527 .37981 L
.86393 .33974 L
.86058 .32801 L
.85248 .29968 L
.84086 .25962 L
.82905 .21955 L
.82051 .191 L
.81707 .17949 L
.80493 .13942 L
.79258 .09936 L
.78045 .06069 L
.78001 .05929 L
.76728 .01923 L
.98077 .01923 L
F
.6 1 0 r
.98077 .76375 m
.9748 .74038 L
.96465 .70032 L
.95448 .66026 L
.9442 .62019 L
.94071 .60667 L
.93379 .58013 L
.92322 .54006 L
.9125 .5 L
.90164 .45994 L
.90064 .45629 L
.89069 .41987 L
.87959 .37981 L
.86831 .33974 L
.86058 .3126 L
.85689 .29968 L
.84535 .25962 L
.83361 .21955 L
.82168 .17949 L
.82051 .1756 L
.80962 .13942 L
.79736 .09936 L
.78487 .05929 L
.78045 .04529 L
.7722 .01923 L
.98077 .01923 L
F
.67 1 0 r
.98077 .74853 m
.97868 .74038 L
.96851 .70032 L
.95835 .66026 L
.94812 .62019 L
.94071 .59146 L
.93776 .58013 L
.92725 .54006 L
.91659 .5 L
.90578 .45994 L
.90064 .44108 L
.89486 .41987 L
.88382 .37981 L
.87261 .33974 L
.86123 .29968 L
.86058 .29739 L
.84975 .25962 L
.83809 .21955 L
.82623 .17949 L
.82051 .16039 L
.81422 .13942 L
.80204 .09936 L
.78963 .05929 L
.78045 .03008 L
.77703 .01923 L
.98077 .01923 L
F
.74 1 0 r
.98077 .73351 m
.97232 .70032 L
.96217 .66026 L
.95197 .62019 L
.94166 .58013 L
.94071 .57644 L
.93121 .54006 L
.9206 .5 L
.90985 .45994 L
.90064 .42606 L
.89896 .41987 L
.88798 .37981 L
.87683 .33974 L
.86552 .29968 L
.86058 .28237 L
.85408 .25962 L
.84248 .21955 L
.8307 .17949 L
.82051 .14537 L
.81873 .13942 L
.80663 .09936 L
.79431 .05929 L
.78176 .01923 L
.98077 .01923 L
F
.81 1 0 r
.98077 .71867 m
.97609 .70032 L
.96594 .66026 L
.95576 .62019 L
.9455 .58013 L
.94071 .5616 L
.9351 .54006 L
.92455 .5 L
.91385 .45994 L
.903 .41987 L
.90064 .41123 L
.89207 .37981 L
.88098 .33974 L
.86973 .29968 L
.86058 .26754 L
.85832 .25962 L
.8468 .21955 L
.83508 .17949 L
.82318 .13942 L
.82051 .13054 L
.81113 .09936 L
.79889 .05929 L
.78643 .01923 L
.98077 .01923 L
F
.88 1 0 r
.98077 .70401 m
.97983 .70032 L
.96965 .66026 L
.9595 .62019 L
.94927 .58013 L
.94071 .54695 L
.93892 .54006 L
.92842 .5 L
.91778 .45994 L
.90699 .41987 L
.90064 .39657 L
.89608 .37981 L
.88505 .33974 L
.87386 .29968 L
.8625 .25962 L
.86058 .25288 L
.85103 .21955 L
.83939 .17949 L
.82755 .13942 L
.82051 .11589 L
.81556 .09936 L
.8034 .05929 L
.79102 .01923 L
.98077 .01923 L
F
.95 1 0 r
.98077 .68952 m
.97333 .66026 L
.96318 .62019 L
.95298 .58013 L
.94268 .54006 L
.94071 .53246 L
.93223 .5 L
.92164 .45994 L
.9109 .41987 L
.90064 .38208 L
.90002 .37981 L
.88906 .33974 L
.87793 .29968 L
.86663 .25962 L
.86058 .2384 L
.8552 .21955 L
.84362 .17949 L
.83185 .13942 L
.82051 .1014 L
.8199 .09936 L
.80782 .05929 L
.79552 .01923 L
.98077 .01923 L
F
1 .98 0 r
.98077 .6752 m
.97697 .66026 L
.96681 .62019 L
.95664 .58013 L
.94638 .54006 L
.94071 .51814 L
.93598 .5 L
.92545 .45994 L
.91476 .41987 L
.90393 .37981 L
.90064 .36776 L
.893 .33974 L
.88192 .29968 L
.87068 .25962 L
.86058 .22408 L
.85929 .21955 L
.84778 .17949 L
.83608 .13942 L
.82419 .09936 L
.82051 .08709 L
.81216 .05929 L
.79994 .01923 L
.98077 .01923 L
F
1 .91 0 r
.98077 .66104 m
.98057 .66026 L
.9704 .62019 L
.96025 .58013 L
.95002 .54006 L
.94071 .50398 L
.93967 .5 L
.92919 .45994 L
.91855 .41987 L
.90777 .37981 L
.90064 .3536 L
.89687 .33974 L
.88586 .29968 L
.87467 .25962 L
.86333 .21955 L
.86058 .20992 L
.85187 .17949 L
.84023 .13942 L
.82841 .09936 L
.82051 .07293 L
.81643 .05929 L
.80428 .01923 L
.98077 .01923 L
F
1 .84 0 r
.98077 .64703 m
.97395 .62019 L
.96381 .58013 L
.95361 .54006 L
.9433 .5 L
.94071 .48997 L
.93287 .45994 L
.92229 .41987 L
.91156 .37981 L
.90068 .33974 L
.90064 .3396 L
.88972 .29968 L
.8786 .25962 L
.86731 .21955 L
.86058 .19592 L
.85589 .17949 L
.84432 .13942 L
.83257 .09936 L
.82062 .05929 L
.82051 .05893 L
.80855 .01923 L
.98077 .01923 L
F
1 .77 0 r
.98077 .63317 m
.97747 .62019 L
.96732 .58013 L
.95715 .54006 L
.94688 .5 L
.94071 .47611 L
.93649 .45994 L
.92596 .41987 L
.91528 .37981 L
.90446 .33974 L
.90064 .32574 L
.89353 .29968 L
.88247 .25962 L
.87123 .21955 L
.86058 .18206 L
.85984 .17949 L
.84834 .13942 L
.83665 .09936 L
.82477 .05929 L
.82051 .04507 L
.81275 .01923 L
.98077 .01923 L
F
1 .7 0 r
.98077 .61946 m
.9708 .58013 L
.96064 .54006 L
.95041 .5 L
.94071 .4624 L
.94007 .45994 L
.92958 .41987 L
.91895 .37981 L
.90818 .33974 L
.90064 .31203 L
.89728 .29968 L
.88627 .25962 L
.8751 .21955 L
.86376 .17949 L
.86058 .16835 L
.8523 .13942 L
.84067 .09936 L
.82886 .05929 L
.82051 .03137 L
.81688 .01923 L
.98077 .01923 L
F
1 .63 0 r
.98077 .60588 m
.97424 .58013 L
.96409 .54006 L
.95389 .5 L
.94358 .45994 L
.94071 .44883 L
.93315 .41987 L
.92257 .37981 L
.91184 .33974 L
.90097 .29968 L
.90064 .29846 L
.89002 .25962 L
.8789 .21955 L
.86761 .17949 L
.86058 .15478 L
.85619 .13942 L
.84463 .09936 L
.83288 .05929 L
.82094 .01923 L
.98077 .01923 L
F
1 .56 0 r
.98077 .59245 m
.97764 .58013 L
.9675 .54006 L
.95732 .5 L
.94705 .45994 L
.94071 .43539 L
.93666 .41987 L
.92613 .37981 L
.91546 .33974 L
.90463 .29968 L
.90064 .28503 L
.89371 .25962 L
.88264 .21955 L
.87142 .17949 L
.86058 .14135 L
.86003 .13942 L
.84853 .09936 L
.83684 .05929 L
.82497 .01923 L
.98077 .01923 L
F
1 .49 0 r
.98077 .57914 m
.97087 .54006 L
.96071 .5 L
.95048 .45994 L
.94071 .42209 L
.94013 .41987 L
.92964 .37981 L
.91902 .33974 L
.90824 .29968 L
.90064 .27173 L
.89734 .25962 L
.88633 .21955 L
.87516 .17949 L
.86382 .13942 L
.86058 .12805 L
.85236 .09936 L
.84074 .05929 L
.82893 .01923 L
.98077 .01923 L
F
1 .42 0 r
.98077 .56597 m
.9742 .54006 L
.96406 .5 L
.95385 .45994 L
.94355 .41987 L
.94071 .40892 L
.93311 .37981 L
.92253 .33974 L
.9118 .29968 L
.90093 .25962 L
.90064 .25855 L
.88997 .21955 L
.87885 .17949 L
.86757 .13942 L
.86058 .11488 L
.85614 .09936 L
.84458 .05929 L
.83283 .01923 L
.98077 .01923 L
F
1 .35 0 r
.98077 .55292 m
.97751 .54006 L
.96737 .5 L
.95719 .45994 L
.94692 .41987 L
.94071 .39587 L
.93652 .37981 L
.92599 .33974 L
.91531 .29968 L
.90449 .25962 L
.90064 .24551 L
.89356 .21955 L
.88249 .17949 L
.87126 .13942 L
.86058 .10183 L
.85987 .09936 L
.84837 .05929 L
.83668 .01923 L
.98077 .01923 L
F
1 .28 0 r
.98077 .53999 m
.97065 .5 L
.96048 .45994 L
.95025 .41987 L
.94071 .38294 L
.93989 .37981 L
.9294 .33974 L
.91877 .29968 L
.90799 .25962 L
.90064 .23258 L
.89709 .21955 L
.88608 .17949 L
.8749 .13942 L
.86356 .09936 L
.86058 .08891 L
.8521 .05929 L
.84047 .01923 L
.98077 .01923 L
F
1 .21 0 r
.98077 .52718 m
.97389 .5 L
.96374 .45994 L
.95353 .41987 L
.94322 .37981 L
.94071 .37013 L
.93277 .33974 L
.92218 .29968 L
.91145 .25962 L
.90064 .21977 L
.90058 .21955 L
.88962 .17949 L
.87849 .13942 L
.8672 .09936 L
.86058 .0761 L
.85578 .05929 L
.8442 .01923 L
.98077 .01923 L
F
1 .14 0 r
.98077 .51448 m
.9771 .5 L
.96696 .45994 L
.95678 .41987 L
.9465 .37981 L
.94071 .35744 L
.93609 .33974 L
.92555 .29968 L
.91487 .25962 L
.90404 .21955 L
.90064 .20708 L
.89311 .17949 L
.88203 .13942 L
.8708 .09936 L
.86058 .06341 L
.8594 .05929 L
.84789 .01923 L
.98077 .01923 L
F
1 .07 0 r
.98077 .5019 m
.98029 .5 L
.97015 .45994 L
.95999 .41987 L
.94974 .37981 L
.94071 .34485 L
.93938 .33974 L
.92888 .29968 L
.91824 .25962 L
.90746 .21955 L
.90064 .1945 L
.89655 .17949 L
.88553 .13942 L
.87434 .09936 L
.863 .05929 L
.86058 .05083 L
.85152 .01923 L
.98077 .01923 L
F
1 0 0 r
.98077 .48943 m
.97331 .45994 L
.96316 .41987 L
.95294 .37981 L
.94262 .33974 L
.94071 .33238 L
.93216 .29968 L
.92157 .25962 L
.91083 .21955 L
.90064 .18202 L
.89995 .17949 L
.88898 .13942 L
.87784 .09936 L
.86654 .05929 L
.86058 .03836 L
.85511 .01923 L
.98077 .01923 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`006Oooool2o`0003Sooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000goooo
o`?o0000=_ooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`0003Kooooo1Ol00005oooo
o`006?ooool01?l0003oooooooooool0000fooooo`04o`000?ooooooooooo`0000Oooooo00Go0000
ooooooooooooooooo`00000gooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool01ooo
ool01Ol0003ooooooooooooooooo000003Kooooo00Co0000oooooooooooo00001Oooool001Sooooo
00Co0000oooooooooooo0000=_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo
03Gooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
03Gooooo00?o0000ooooooooool01Oooool001Sooooo00Co0000oooooooooooo0000=_ooool01?l0
003oooooooooool0000;ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool0=_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool01?ooool0
01Sooooo00Co0000oooooooooooo0000=_ooool01?l0003oooooooooool00007ooooo`Co0000>?oo
ool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo00Oooooo1?l0000fooooo`05o`000?oo
ooooooooooooool000001Oooool001Sooooo00Co0000oooooooooooo0000=_ooool01?l0003ooooo
ooooool00007ooooo`03o`000?oooooooooo03Sooooo0_l0000gooooo`;o00002Oooool00ol0003o
ooooooooo`0gooooo`05o`000?ooooooooooooooool000001Oooool001Wooooo0_l0000hooooo`;o
00002?ooool5o`0003Oooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`07ooooo`Go
0000=_ooool3o`0000Kooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo003ooooo
ob7ooooo000Eoooooooo00002ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0mooooo`03o`000?oo
oooooooo03gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0mooooo`03o`000?oo
oooooooo00;ooooo0Ol00001ooooo`003_ooool2o`0000Gooooo00?o0000ooooooooool0ooooool7
ooooo`7o00000Oooool000gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`3o
ooooo`Oooooo0Ol00001ooooo`003Oooool01?l0003oooooooooool00004ooooo`;o0000ooooool7
ooooo`;o00000Oooool000gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02
ooooodGo8@3o5?l?0?l<o`02o`Wo01Co1ol09_l6o`0ho`Go04[o1Ol0G?l4o`1^o`Co07oo1?l0TOl3
o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0ol0ol`2o`3o^P;o0?nX0_l0oiL2
o`3oQ@;o0?mc00?o0?mQo`3oCol0odl00_l0ocd00ol0ob_o0?lIo`3o6@02o`3o1`05o`[o0?lLo`3o
7?l0obko0?loo`000_mAo`001_mSo`3oMOl0ogGo0?n7o`3oVOl0oj_o00;o_Ol000Cocol0on7o0?oc
o`3oooX00_ooj0003?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA
027oo`001Oooool1o`00007ooooo000=ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000oooo
ooooool00_oooom6ob40oaCo3`3o3?l00_l9o`0Do`Oo02Ko1_l0>?l5o`1:o`Go05co1?l0K_l4o`1o
o`Co097o0ol0Xol3o`2eo`?o0<Oo0ol0fOl2o`3[o`?o0?go0_l0oo02o`3ogP;o0?o<0ol0okX2o`3o
Z0;o0?nG0_l0ohD00ol0og?o0?mQo`3oH@02o`3oC`03o`3o?Ol0ob_o0?l[00;o0?lI00Co0?l7o`[o
0?lLo`3o7?l00_l^o`001_loo`3oDOl0of?o0?mSo`3oMOl0ohOo00;oVOl000GoZol0okgo0?o?o`3o
hOl0oo?o0002oooj000=oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3o
ob<0oolA000Qool000Gooooo0Ol00001ooooo`003Oooool01?l0003oooooooooool00004ooooo`03
o`000?oooooooooo00;oooooAolQ0?lDo`l0o`_o00;o2Ol05?l7o`0Vo`Ko03So1Ol0B_l5o`1Lo`Co
06ko1?l0Ool4o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol2o`3mo`;o0?o`0_l0omh3o`3oc0;o
0?nj0_l0ojP2o`3oU`;o0?n50_l0og<00ol0of7o0?m?o`3oC`02o`3o?@03o`3o:ol0oaWo0?lI00;o
0?l700Go2_l0oaco0?lLo`3o;_l0ocoo0002oe7o0006of?o0?meo`3oMOl0ohOo0?nIo`3oZol00_nm
o`001?o?o`3ohOl0oo?o0?oonP02oooX000;oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3o
odL0oole0?oo8`008Ooo0005ooooo`7o00000Oooool000kooooo0_l00005ooooo`03o`000?oooooo
oooo00;oooooB?lQ0?lCo`l0o`co00;o2Ol05?l7o`0Vo`Ko03So1Ol0B_l5o`1Lo`?o06ko1Ol0Ool3
o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol2o`3mo`;o0?o`0_l0omh3o`3oc0;o0?nj0_l0ojP2
o`3oU`;o0?n50_l0og<2o`3oH@04o`3oCol0ocgo0?lmo`3o:`;o0?lI0_l0o`L01Ol:o`3o7?l0oaco
0?l^o`3o?ol000;oDOl000KoHol0ogGo0?meo`3oQol0oiWo0?n[o`02okgo0004oloo0?oQo`3olol0
oooj00;oonP000coomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@0P
ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooodSo8@3o5?l?0?l<o`02
o`So01Co1ol09_l7o`0ho`Co04[o1Ol0G?l4o`1^o`Co07oo1?l0TOl3o`2So`?o0;Go0ol0aol3o`3I
o`;o0>_o0ol0oOl2o`3ol0;o0?oN0_l0ol`3o`3o^P;o0?nX0_l0oiL2o`3oQ@03o`3oLol0of7o0?mQ
00;o0?m?00?o0?lmo`3o:ol0ob/00_l0oaT01?l0o`Oo2_l0oaco0?lLo`02obko0006ocoo0?mAo`3o
Hol0of?o0?meo`3oQol00_nIo`001On[o`3o_Ol0oloo0?oQo`3olol000;oooX000goonP0oooG0?oo
a@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa40023oo`001Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;oooooBOlQ0?lDo`l0o`_o00;o2Ol05?l7o`0Vo`Ko03So
1Ol0B_l5o`1Lo`?o06ko1Ol0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol2o`3mo`;o0?o`
0_l0omh3o`3oc0;o0?nj0_l0ojP2o`3oU`;o0?n50_l0og<00ol0of7o0?m?o`3oC`02o`3o?@04o`3o
:ol0oaWo0?lIo`3o1`;o2_l00_lLo`001Ol^o`3o?ol0oe7o0?mAo`3oHol000;oMOl000?oQol0oiWo
0?n[o`000_nmo`001?o?o`3ohOl0oo?o0?oonP02oooX000;oooG0?oo/`3ook<0oonQ0?ooS`3oogd0
oom[0?ooF@3oodL0oole0?oo4@008?oo0005ooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool00_oooom:ob40oaCo3`3o2ol00_l9o`0Do`Oo02Ko1_l0>?l5o`1:o`Co05co1?l0K_l4o`1oo`Co
097o0_l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`;o0?go0_l0oo03o`3ogP;o0?o<0_l0okX2o`3oZ0;o
0?nG0_l0ohD2o`3oL`;o0?mQ00Co0?m?o`3o?Ol0ocgo0?l[0_l0oaT00ol0o`Oo2_l0o`[o0002oaco
0005obko0?loo`3oDOl0oe7o0?mSo`000_meo`000on7o`3oVOl0oj_o0002okgo0004oloo0?oQo`3o
lol0oooj00;oonP000_oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolA000P
ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooood_o8@3o4ol?0?l;o`02
o`Wo01Co1ol09_l6o`0ho`Go04[o1?l0G?l4o`1^o`Co07oo1?l0TOl3o`2So`?o0;Go0ol0aol3o`3I
o`?o0>_o0_l0oOl2o`3ol0;o0?oN0ol0ol`2o`3o^P;o0?nX0_l0oiL2o`3oQ@03o`3oLol0of7o0?mQ
00;o0?m?00?o0?lmo`3o:ol0ob/00_l0oaT01?l0o`Oo2_l0o`[o0?lLo`02obko0006ocoo0?mAo`3o
Hol0of?o0?meo`3oQol00_nIo`001On[o`3o_Ol0oloo0?oQo`3olol000;oooX000goonP0oooG0?oo
a@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa4001ooo`001Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;oooooC?lQ0?lCo`l0o`_o00;o2Ol05?l7o`0Vo`Ko03So
1Ol0B_l4o`1Lo`Co06ko1?l0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol2o`3mo`;o0?o`
0_l0omh3o`3oc0;o0?nj0_l0ojP2o`3oU`;o0?n500?o0?mco`3oHOl0of400_l0odl00ol0ocgo0?l[
o`3o:`02o`3o6@04o`3o1ol:o`3o2_l0oaco00;o;_l000Ko?ol0oe7o0?mSo`3oHol0ogGo0?n7o`02
oiWo0005oj_o0?nmo`3ocol0on7o0?oco`000_oonP003Oooj03oomL0ooo50?oo/`3ooj40oon?0?oo
O@3oof/0oomI0?ooA`3oocD0oolS0?oo4@007ooo0005ooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_oooom=ob40oa?o3`3o2ol00_l8o`0Do`Oo02Ko1_l0>?l5o`1:o`Co05co1?l0K_l4
o`1oo`Co097o0_l0Xol3o`2eo`?o0<Oo1?l0fOl2o`3[o`;o0?go0_l0oo03o`3ogP;o0?o<0_l0okX2
o`3oZ0;o0?nG0_l0ohD2o`3oL`;o0?mQ00Co0?m?o`3o?Ol0ocgo0?l[0_l0oaT00ol0o`Oo2_l0o`[o
0002oaco0005obko0?loo`3oDOl0oe7o0?mSo`000_meo`000on7o`3oVOl0oj_o0002okgo0004oloo
0?oQo`3olol0oooj00;oonP000_oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0
oolA000Oool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooodko8@3o4ol?
0?l;o`02o`So01Co1ol09_l6o`0ho`Go04[o1?l0G?l4o`1^o`Co07oo0ol0TOl3o`2So`?o0;Go0ol0
aol3o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0ol0ol`2o`3o^P;o0?nX0_l0oiL2o`3oQ@03o`3oLol0
of7o0?mQ00;o0?m?00?o0?lmo`3o:ol0ob/00_l0oaT01?l0o`Oo2_l0o`[o0?lLo`02obko0006ocoo
0?mAo`3oHol0of?o0?meo`3oQol00_nIo`001On[o`3o_Ol0oloo0?oQo`3olol000;oooX000goonP0
oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa4001koo`001Oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooC_lQ0?lCo`l0o`_o00;o2?l05?l7o`0V
o`Ko03So1Ol0B_l4o`1Lo`Co06ko1?l0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol2o`3m
o`;o0?o`0_l0omh3o`3oc0;o0?nj0_l0ojP2o`3oU`;o0?n500?o0?mco`3oHOl0of400_l0odl00ol0
ocgo0?l[o`3o:`02o`3o6@04o`3o1ol:o`3o2_l0oaco00;o;_l000Ko?ol0oe7o0?mSo`3oHol0ogGo
0?n7o`02oiWo0005oj_o0?nmo`3ocol0on7o0?oco`000_oonP003Oooj03oomL0ooo50?oo/`3ooj40
oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@007_oo0005ooooo`7o00000Oooool001Gooooo
0_l00003ooooodoo8@3o4ol?0?l;o`02o`So01Co1ol09_l6o`0ho`Go04[o0ol0G?l5o`1^o`Co07oo
0ol0TOl3o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0ol0ol`2o`3o^P;o0?nX
0_l0oiL00ol0ohGo0?mco`3oL`02o`3oH@04o`3oCol0ocgo0?lmo`3o:`;o0?lI0_l0o`L01Ol:o`3o
7?l0oaco0?l^o`3o?ol000;oDOl000SoHol0ogGo0?n7o`3oQol0oiWo0?n[o`3o_Ol0oloo00;ohOl0
00oolol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo
4@007_oo0004ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_oooom@ob40oa?o3`3o
2_l00_l8o`0Do`Oo02Ko1_l0>?l5o`1:o`Co05co1?l0K_l4o`1oo`?o097o0ol0Xol3o`2eo`Co0<Oo
0_l0fOl3o`3[o`;o0?go0_l0oo02o`3ogP?o0?o<0_l0okX2o`3oZ0;o0?nG00?o0?n5o`3oLol0og<0
0_l0of42o`3oC`04o`3o?Ol0ob_o0?l[o`3o6@;o0?l70_l:o`001OlLo`3o;_l0obko0?loo`3oDOl0
00;oHol000WoMOl0ohOo0?nIo`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`000_oonP002_ooj03oomL0
ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`02oolS0003oolA0?oo003oo`0001_oo`001Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;oooooDOlQ0?lBo`l0o`_o00;o2?l05?l7
o`0Vo`Ko03So1?l0B_l4o`1Lo`Go06ko1?l0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`;o0=Wo0ol0jol2
o`3mo`;o0?o`0_l0omh3o`3oc0;o0?nj0_l0ojP2o`3oU`;o0?n500?o0?mco`3oHOl0of400_l0odl0
1?l0ocgo0?l[o`3o:ol0oaT2o`3o1`;o2_l000Go7?l0obko0?l^o`3o?ol0oe7o0002of?o0009ogGo
0?n7o`3oVOl0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol000;oooX000goonP0oooG0?ooa@3ook<0oonQ
0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa4001goo`001Oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;oooooD_lQ0?lBo`l0o`[o00;o2?l05?l7o`0Vo`Ko03So1Ol0B_l4o`1L
o`Co06ko1?l0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol2o`3mo`;o0?o`0_l0omh3o`3o
c0;o0?nj0_l0ojP2o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ00Co0?m?o`3o?Ol0ocgo0?l[0_l0oaT2
o`3o1`05o`[o0?lLo`3o7?l0obko0?loo`000_mAo`002?mSo`3oMOl0ohOo0?n7o`3oVOl0oj_o0?nm
o`3ocol00_oQo`003ooco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom7
0?oo=@3oob<0oolA000Mool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
oe;o8@3o4ol?0?l:o`02o`So01Co1ol09_l6o`0ho`Co04[o1?l0G?l5o`1^o`?o07oo1?l0TOl3o`2S
o`?o0;Go0ol0aol2o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0ol0ol`2o`3o^P;o0?nX0_l0oiL00ol0
ohGo0?mco`3oL`02o`3oH@;o0?m?00Co0?lmo`3o:ol0ob_o0?lI0_l0o`L2o`[o0006oaco0?l^o`3o
;_l0ocoo0?mAo`3oHol00_meo`002On7o`3oVOl0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0002
oooX0009oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooA`3oocD000;oob<000?ooa40ool00?oo
00006_oo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooomCob40oa;o3`3o
2ol00_l8o`0Do`Ko02Ko1_l0>?l5o`1:o`Co05co1?l0K_l4o`1oo`?o097o0ol0Xol3o`2eo`?o0<Oo
0_l0fOl3o`3[o`;o0?go0ol0oo001?l0omko0?o<o`3oc?l0ol`2o`3o^P;o0?nX0_l0oiL2o`3oQ@03
o`3oLol0of7o0?mQ00;o0?m?00Co0?lmo`3o:ol0ob_o0?lI0_l0o`L2o`[o0005oaco0?l^o`3o;_l0
ocoo0?mAo`000_mSo`002Omeo`3oQol0oiWo0?nIo`3oZol0okgo0?o?o`3ohOl0oo?o0002oooj000=
oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA000Lool000Go
oooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooeCo8@3o4_l?0?l:o`02o`So01Co
1ol09_l5o`0ho`Go04[o1?l0G?l4o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0_l0aol3o`3Io`?o0>_o
0_l0oOl2o`3ol0;o0?oN0ol0ol`2o`3o^P;o0?nX00?o0?nGo`3oQOl0ohD00_l0og<2o`3oH@04o`3o
Col0ocgo0?lmo`3o:`;o0?lI0_l0o`L01Ol:o`3o7?l0oaco0?l^o`3o?ol000;oDOl000SoHol0ogGo
0?n7o`3oQol0oiWo0?n[o`3o_Ol0oloo00;ohOl000oolol0oooj0?ooj03oomL0ooo50?oo/`3ooj40
oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@007?oo0005ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_oooomEob40oa7o3`3o2ol00_l8o`0Do`Ko02Ko1_l0>?l4o`1:o`Go05co
1?l0K_l3o`1oo`Co097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl3o`3[o`;o0?go0_l0oo02o`3ogP?o0?o<
0_l0okX2o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of400ol0odoo0?lmo`3o?@02o`3o:`04o`3o
6Ol0o`Oo0?l7o`[o00;o7?l000Ko;_l0ocoo0?mAo`3oDOl0of?o0?meo`02ohOo0004oiWo0?n[o`3o
_Ol0oloo00;ohOl000oolol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?oo
A`3oocD0oolS0?oo4@007?oo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
oomEob40oa;o3`3o2_l00_l8o`0Do`Oo02Ko1Ol0>?l5o`1:o`Co05co1?l0K_l4o`1oo`?o097o0ol0
Xol4o`2eo`;o0<Oo0_l0fOl3o`3[o`;o0?go0ol0oo001?l0omko0?o<o`3oc?l0ol`2o`3o^P;o0?nX
0_l0oiL2o`3oQ@03o`3oLol0of7o0?mQ00;o0?m?00Co0?lmo`3o:ol0ob_o0?lI0_l0o`L2o`[o0005
oaco0?l^o`3o;_l0ocoo0?mAo`000_mSo`002?meo`3oQol0oiWo0?nIo`3oZol0okgo0?o?o`3ohOl0
0_oco`003_oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3o
oa406ooo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooomFob40oa;o3`3o
2_l00_l8o`0Do`Ko02Ko1_l0>?l4o`1:o`Go05co1?l0K_l3o`1oo`Co097o0ol0Xol3o`2eo`;o0<Oo
0ol0fOl3o`3[o`;o0?go0_l0oo02o`3ogP?o0?o<0_l0okX2o`3oZ003o`3oUol0ohGo0?n500;o0?mc
0_l0of400ol0odoo0?lmo`3o?@02o`3o:`04o`3o6Ol0o`Oo0?l7o`[o00;o7?l000Ko;_l0ocoo0?mA
o`3oDOl0of?o0?meo`02ohOo0004oiWo0?n[o`3o_Ol0oloo00;ohOl000oolol0oooj0?ooj03oomL0
ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@006ooo0005ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooomFob40oa;o3`3o2_l00_l8o`0Do`Ko02Ko1_l0
>?l4o`1:o`Go05co1?l0K_l3o`1oo`Co097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl3o`3[o`;o0?go0_l0
oo02o`3ogP?o0?o<0_l0okX2o`3oZ003o`3oUol0ohGo0?n500;o0?mc0_l0of400ol0odoo0?lmo`3o
?@02o`3o:`04o`3o6Ol0o`Oo0?l7o`[o00;o7?l000Ko;_l0ocoo0?mAo`3oDOl0of?o0?meo`02ohOo
0004oiWo0?n[o`3o_Ol0oloo00;ohOl000oolol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?oo
O@3oof/0oomI0?ooA`3oocD0oolS0?oo4@006ooo0005ooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_oooomGob40oa;o3`3o2_l00_l8o`0Do`Ko02Ko1_l0>?l4o`1:o`Go05co1?l0K_l3
o`1oo`Co097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl2o`3[o`?o0?go0_l0oo02o`3ogP;o0?o<0ol0okX0
0ol0ojSo0?nGo`3oU`02o`3oQ@;o0?mc00Co0?mQo`3oCol0odoo0?lm0_l0ob/2o`3o6@04o`3o1ol:
o`3o2_l0oaco00;o;_l000?o?ol0oe7o0?mSo`000_meo`000on7o`3oVOl0oj_o0002okgo000Aoloo
0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS
0?oo4@006ooo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooomHob40oa7o
3`3o2ol00_l7o`0Do`Ko02Ko1_l0>?l4o`1:o`Go05co1?l0K_l3o`1oo`Co097o0ol0Xol3o`2eo`;o
0<Oo0ol0fOl3o`3[o`;o0?go0_l0oo02o`3ogP?o0?o<0_l0okX2o`3oZ003o`3oUol0ohGo0?n500;o
0?mc0_l0of400ol0odoo0?lmo`3o?@02o`3o:`04o`3o6Ol0o`Oo0?l7o`[o00;o7?l000Ko;_l0ocoo
0?mAo`3oDOl0of?o0?meo`02ohOo0004oiWo0?n[o`3o_Ol0oloo00;ohOl000oolol0oooj0?ooj03o
omL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@006_oo0005ooooo`7o
00000Oooool001Gooooo0_l00003oooooeWo8@3o4Ol?0?l:o`02o`So01Co1_l09_l6o`0ho`Co04[o
1?l0G?l4o`1^o`Co07oo0ol0TOl4o`2So`;o0;Go0ol0aol2o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN
0ol0ol`2o`3o^P;o0?nX00?o0?nGo`3oQOl0ohD00_l0og<2o`3oH@03o`3oCol0ocgo0?lm00;o0?l[
00Co0?lIo`3o1ol0o`Oo2_l00_lLo`001_l^o`3o?ol0ocoo0?mAo`3oHol0ogGo00;oQol000?oVOl0
oj_o0?nmo`000_o?o`004?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0
oomI0?ooA`3oocD0oolS0?oo4@0Jool000Cooooo0_l00001ooooo`005Oooool00ol0003ooooooooo
o`02oooooe[o8@3o4?l?0?l;o`02o`Oo01Co1_l09_l6o`0ho`Co04[o1Ol0G?l4o`1^o`?o07oo1?l0
TOl3o`2So`?o0;Go0_l0aol3o`3Io`;o0>_o0ol0oOl2o`3ol0;o0?oN0_l0ol`3o`3o^P03o`3oZ?l0
oiOo0?nG00;o0?n50_l0og<00ol0of7o0?m?o`3oC`02o`3o?@04o`3o:ol0oaWo0?lIo`3o1`;o2_l0
00Ko7?l0obko0?l^o`3o?ol0oe7o0?mSo`02ogGo0003ohOo0?nIo`3oZol000;o_Ol0017ocol0on7o
0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA
000Jool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooe[o8@3o4Ol?0?l:
o`02o`So01Co1_l09_l5o`0ho`Go04[o1?l0G?l4o`1^o`Co07oo0ol0TOl3o`2So`?o0;Go0ol0aol2
o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0ol0ol`2o`3o^P;o0?nX00?o0?nGo`3oQOl0ohD00_l0og<2
o`3oH@03o`3oCol0ocgo0?lm00;o0?l[00Co0?lIo`3o1ol0o`Oo2_l00_lLo`001_l^o`3o?ol0oe7o
0?mAo`3oHol0ogGo00;oQol000?oVOl0oj_o0?nmo`000_o?o`004?oQo`3olol0oooj0?ooj03oomL0
ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@0Iool000Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02oooooe_o8@3o4Ol?0?l:o`02o`Oo01Co1_l09_l6o`0h
o`Co04[o1Ol0G?l4o`1^o`?o07oo1?l0TOl3o`2So`?o0;Go0_l0aol3o`3Io`;o0>_o0ol0oOl2o`3o
l0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL2o`3oQ@;o0?mc00Co0?mQo`3oCol0ocgo0?lm0_l0ob/2
o`3o6@05o`3o1ol:o`3o2_l0oaco0?l^o`000_loo`002?mAo`3oHol0ogGo0?meo`3oQol0oiWo0?n[
o`3o_Ol00_o?o`004?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI
0?ooA`3oocD0oolS0?oo4@0Iool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
oooooeco8@3o4?l?0?l;o`02o`Oo01Co1_l09_l5o`0ho`Go04[o1?l0G?l4o`1^o`Co07oo0ol0TOl3
o`2So`?o0;Go0ol0aol2o`3Io`;o0>_o0ol0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL2
o`3oQ@;o0?mc00?o0?mQo`3oCol0odl00_l0ocd01?l0ob_o0?lIo`3o6Ol0o`L2o`[o0006oaco0?l^
o`3o?ol0ocoo0?mAo`3oHol00_meo`000on7o`3oVOl0oj_o0002okgo000Aoloo0?oQo`3olol0oooj
0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@006Ooo0005
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooomMob40oa3o3`3o2_l00_l7o`0D
o`Ko02Ko1_l0>?l4o`1:o`Co05co1?l0K_l4o`1oo`?o097o1?l0Xol2o`2eo`?o0<Oo0_l0fOl3o`3[
o`;o0?go0_l0oo02o`3ogP?o0?o<0_l0okX2o`3oZ003o`3oUol0ohGo0?n500;o0?mc0_l0of400ol0
odoo0?lmo`3o?@02o`3o:`04o`3o6Ol0o`Oo0?l7o`[o00;o7?l000Ko;_l0ocoo0?mAo`3oDOl0of?o
0?meo`02ohOo0003oiWo0?n[o`3o_Ol000;ocol0013ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0
oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa406?oo0005ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooomNob40oa3o3`3o2_l00_l7o`0Do`Ko02Ko1_l0>?l4o`1:o`Co
05co1?l0K_l4o`1oo`?o097o0ol0Xol3o`2eo`?o0<Oo0_l0fOl3o`3[o`;o0?go0_l0oo02o`3ogP;o
0?o<0_l0okX2o`3oZ0;o0?nG0_l0ohD2o`3oL`03o`3oHOl0odoo0?m?00;o0?lm00Co0?l[o`3o6Ol0
oaWo0?l70_l:o`001_lLo`3o;_l0ocoo0?loo`3oDOl0of?o00;oMOl000CoQol0oiWo0?n[o`3o_Ol0
0_o?o`004?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3o
ocD0oolS0?oo4@0Hool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooeko
8@3o4?l?0?l:o`02o`So01Co1Ol09_l6o`0ho`Co04[o1?l0G?l4o`1^o`Co07oo0ol0TOl3o`2So`?o
0;Go0ol0aol2o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL2o`3oQ@;o
0?mc00?o0?mQo`3oCol0odl00_l0ocd01?l0ob_o0?lIo`3o6Ol0o`L2o`[o0006oaco0?l^o`3o?ol0
ocoo0?mAo`3oHol00_meo`001?n7o`3oVOl0oj_o0?nmo`02oloo000@on7o0?oco`3oooX0oooX0?oo
e`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA01Soo`001Oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;oooooGolQ0?l@o`l0o`[o00;o1ol05?l6o`0Vo`Ko
03So1?l0B_l4o`1Lo`Co06ko1?l0Ool3o`2Ao`?o0:?o0ol0]Ol2o`37o`?o0=Wo0ol0jol2o`3mo`;o
0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP2o`3oU`04o`3oQOl0og?o0?mco`3oH@;o0?m?0_l0ocd2o`3o
:`05o`3o6Ol0o`Oo2_l0o`[o0?lLo`000_l^o`001_loo`3oDOl0of?o0?mSo`3oMOl0ohOo00;oVOl0
01?oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?oo
F@3oodL0oole0?oo8`3ooa4001Soo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;oooooH?lQ0?l?o`l0o`[o00;o2?l05?l5o`0Vo`Ko03So1?l0B_l4o`1Lo`Co06ko1?l0Ool3o`2A
o`?o0:?o0ol0]Ol3o`37o`;o0=Wo0ol0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP2o`3o
U`;o0?n500?o0?mco`3oHOl0of400_l0odl2o`3o?@04o`3o:ol0oaWo0?lIo`3o1`;o2_l00_l^o`02
ocoo0008oe7o0?mSo`3oMOl0ogGo0?n7o`3oVOl0oj_o0?nmo`02oloo0007on7o0?oco`3oooX0oooX
0?ooe`3oolD0oonc0002oon?0007oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA000Gool000Gooooo
0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooof3o8@3o4?l?0?l:o`02o`Oo01Co1_l0
9_l6o`0ho`Co04[o1?l0G?l4o`1^o`?o07oo1?l0TOl2o`2So`?o0;Go0ol0aol2o`3Io`?o0>_o0_l0
oOl2o`3ol0;o0?oN0ol0ol`00ol0ok[o0?nXo`3oZ002o`3oU`;o0?n50_l0og<00ol0of7o0?m?o`3o
C`02o`3o?@04o`3o:ol0oaWo0?lIo`3o1`;o2_l000Ko7?l0obko0?loo`3o?ol0oe7o0?mSo`02ogGo
0004ohOo0?nIo`3oZol0okgo00;ocol0013ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?oo
S`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa405ooo0005ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_ooool7o`l0oe[o8@3o3ol?0?l:o`02o`So01Co1Ol09_l6o`0ho`Co04[o1?l0
G?l4o`1^o`Co07oo0ol0TOl3o`2So`?o0;Go0_l0aol3o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0_l0
ol`2o`3o^P;o0?nX0_l0oiL01?l0ohGo0?mco`3oLol0of42o`3oC`;o0?lm0_l0ob/01Ol0oaWo0?l7
o`[o0?l:o`3o7?l000;o;_l000Ko?ol0oe7o0?mSo`3oHol0ogGo0?n7o`02oiWo000Coj_o0?nmo`3o
col0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3o
ob<0oolA000Gool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`ko3`3o
E?lQ0?l?o`l0o`[o00;o1ol05?l6o`0Vo`Ko03So1?l0B_l4o`1Lo`Co06ko0ol0Ool3o`2Ao`?o0:?o
0ol0]Ol3o`37o`;o0=Wo0ol0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP2o`3oU`;o0?n5
00?o0?mco`3oHOl0of400_l0odl2o`3o?@06o`3o:ol0oaWo0?lIo`3o1ol:o`3o7?l00_l^o`02ocoo
0008oe7o0?mSo`3oMOl0ogGo0?n7o`3oVOl0oj_o0?nmo`02oloo0007on7o0?oco`3oooX0oooX0?oo
e`3ook<0oonQ0002oon?0007oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA000Fool000Gooooo0Ol0
0001ooooo`005Oooool2o`0000?ooooo4Ol?0?mAob40oa3o3`3o2Ol00_l8o`0Do`Go02Ko1_l0>?l4
o`1:o`Co05co1?l0K_l3o`1oo`Co097o0_l0Xol3o`2eo`?o0<Oo0_l0fOl3o`3[o`;o0?go0_l0oo02
o`3ogP?o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL2o`3oQ@03o`3oLol0of7o0?mQ00;o0?m?0_l0ocd0
1?l0ob_o0?lIo`3o6Ol0o`L2o`[o0006oaco0?l^o`3o?ol0ocoo0?mAo`3oHol00_meo`001?n7o`3o
VOl0oj_o0?nmo`02oloo000@on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?oo
J`3ooeT0oom70?oo=@3oob<0oolA01Koo`001?ooool2o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo5?l?0?m?ob40o`oo3`3o2Ol00_l8o`0Do`Go02Ko1_l0>?l4o`1:o`Go05co0ol0K_l4
o`1oo`?o097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl3o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX2
o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of400ol0odoo0?lmo`3o?@02o`3o:`05o`3o6Ol0o`Oo
2_l0o`[o0?lLo`000_l^o`002?loo`3oDOl0of?o0?mSo`3oMOl0ohOo0?nIo`3oZol00_nmo`004Oo?
o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo
8`3ooa4001Koo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5ol?0?m<
ob40oa3o3`3o2Ol00_l8o`0Do`Go02Ko1_l0>?l4o`1:o`Co05co1?l0K_l3o`1oo`?o097o0ol0Xol3
o`2eo`?o0<Oo0_l0fOl3o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX2o`3oZ0;o0?nG00?o0?n5
o`3oLol0og<00_l0of400ol0odoo0?lmo`3o?@02o`3o:`05o`3o6Ol0o`Oo0?l7o`[o0?lLo`000_l^
o`001Oloo`3oDOl0of?o0?mSo`3oMOl000;oQol001CoVOl0okgo0?nmo`3ocol0on7o0?oco`3oooX0
oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA01Koo`001Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo6_l?0?m:ob40o`oo3`3o2Ol00_l8
o`0Do`Go02Ko1_l0>?l4o`1:o`Co05co1?l0K_l3o`1oo`Co097o0_l0Xol3o`2eo`?o0<Oo0_l0fOl3
o`3[o`;o0?go0_l0oo03o`3ogP;o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL2o`3oQ@03o`3oLol0of7o
0?mQ00;o0?m?0_l0ocd01?l0ob_o0?lIo`3o6Ol0o`L2o`[o0006oaco0?l^o`3o?ol0ocoo0?mAo`3o
Hol00_meo`001?n7o`3oVOl0oj_o0?nmo`02oloo000@on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc
0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA01Goo`001Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo7Ol?0?m8ob40o`oo3`3o2Ol00_l8o`0Do`Go02Ko1_l0>?l4
o`1:o`Co05co1?l0K_l3o`1oo`?o097o0ol0Xol3o`2eo`?o0<Oo0_l0fOl3o`3[o`;o0?go0_l0oo02
o`3ogP;o0?o<0_l0okX2o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of400ol0odoo0?lmo`3o?@02
o`3o:`05o`3o6Ol0o`Oo2_l0o`[o0?lLo`000_l^o`002?loo`3oDOl0of?o0?mSo`3oMOl0ohOo0?nI
o`3oZol00_nmo`004Oo?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[
0?ooF@3oodL0oole0?oo8`3ooa4001Goo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo7ol?0?m6ob40o`oo3`3o2Ol00_l8o`0Do`Go02Ko1_l0>?l4o`1:o`Co05co1?l0K_l4
o`1oo`;o097o0ol0Xol3o`2eo`?o0<Oo0_l0fOl3o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX2
o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of400ol0odoo0?lmo`3o?@02o`3o:`05o`3o6Ol0o`Oo
2_l0o`[o0?lLo`000_l^o`002?loo`3oDOl0of?o0?mSo`3oMOl0ohOo0?nIo`3oZol00_nmo`004Oo?
o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo
8`3ooa4001Goo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo8?l?0?m6
ob40o`oo3`3o2Ol00_l8o`0Do`Go02Ko1_l0>?l4o`1:o`Co05co1?l0K_l3o`1oo`?o097o0ol0Xol3
o`2eo`?o0<Oo0_l0fOl2o`3[o`?o0?go0_l0oo02o`3ogP;o0?o<0_l0okX00ol0ojSo0?nGo`3oU`02
o`3oQ@;o0?mc00Co0?mQo`3oCol0odoo0?lm0_l0ob/2o`3o6@07o`3o1ol:o`3o7?l0oaco0?l^o`3o
?ol0oe7o0002of?o00;oMOl001GoVOl0oj_o0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0
ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@005Ooo0005ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooolRo`l0odCo8@3o3ol?0?l:o`02o`Oo01Co1Ol0
9_l6o`0ho`Co04[o1?l0G?l4o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0ol0aol2o`3Io`?o0>_o0_l0
oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL00ol0ohGo0?mco`3oL`02o`3oH@03o`3oCol0
ocgo0?lm00;o0?l[00Go0?lIo`3o1ol:o`3o2_l0oaco0002obko0008ocoo0?mAo`3oHol0of?o0?me
o`3oQol0oiWo0?n[o`02okgo0005oloo0?oQo`3olol0oooj0?ooj0000_ooa@002Ooo/`3ooj40oon?
0?ooO@3oof/0oomI0?ooA`3oocD0oolS000Eool000Gooooo0Ol00001ooooo`005Oooool00ol0003o
ooooooooo`02ooooobCo3`3o@olQ0?l?o`l0o`Wo00;o2?l05?l5o`0Vo`Go03So1Ol0B_l3o`1Lo`Co
06ko1?l0Ool2o`2Ao`?o0:?o0ol0]Ol3o`37o`;o0=Wo0ol0jol2o`3mo`?o0?o`00?o0?oNo`3oc?l0
ol`00_l0okX2o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of400ol0odoo0?lmo`3o?@02o`3o:`05
o`3o6Ol0o`Oo2_l0o`[o0?lLo`000_l^o`002?loo`3oDOl0of?o0?mSo`3oMOl0ohOo0?nIo`3oZol0
0_nmo`004Oo?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3o
odL0oole0?oo8`3ooa4001Coo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
oooo9Ol?0?m3ob40o`ko3`3o2_l00_l7o`0Do`Go02Ko1_l0>?l4o`1:o`Co05co1?l0K_l3o`1oo`?o
097o0ol0Xol3o`2eo`?o0<Oo0_l0fOl2o`3[o`?o0?go0_l0oo02o`3ogP;o0?o<0_l0okX00ol0ojSo
0?nGo`3oU`02o`3oQ@;o0?mc00Co0?mQo`3oCol0odoo0?lm0_l0ob/01?l0oaWo0?l7o`3o1ol:o`02
oaco0003obko0?loo`3oDOl000;oHol000?oMOl0ohOo0?nIo`000_n[o`004_nmo`3ocol0on7o0?oc
o`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA01Co
o`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo9ol?0?m1ob40o`oo3`3o
2Ol00_l8o`0Do`Go02Ko1Ol0>?l5o`1:o`?o05co1?l0K_l3o`1oo`?o097o0ol0Xol3o`2eo`?o0<Oo
0_l0fOl3o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX2o`3oZ003o`3oUol0ohGo0?n500;o0?mc
0_l0of401?l0odoo0?lmo`3o?Ol0ob/2o`3o6@04o`3o1ol:o`3o2_l0oaco00;o;_l000So?ol0oe7o
0?mSo`3oHol0ogGo0?n7o`3oVOl0oj_o00;o_Ol000Gocol0on7o0?oco`3oonP0oooG0002ooo50009
oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3ooa4001Coo`001Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo:Ol?0?m0ob40o`oo3`3o2Ol00_l7o`0Do`Go02Ko1Ol0>?l5
o`1:o`?o05co1Ol0K_l3o`1oo`;o097o0ol0Xol3o`2eo`?o0<Oo0_l0fOl3o`3[o`;o0?go0ol0oo00
0ol0omko0?o<o`3oc002o`3o^P;o0?nX0_l0oiL00ol0ohGo0?mco`3oL`02o`3oH@03o`3oCol0ocgo
0?lm00;o0?l[00Go0?lIo`3o1ol:o`3o2_l0oaco0002obko0008ocoo0?mAo`3oHol0of?o0?meo`3o
Qol0oiWo0?n[o`02okgo000Aoloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?oo
O@3oof/0oomI0?ooA`3oocD0oolS0?oo4@004ooo0005ooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_oooolZo`l0ocoo8@3o3ol?0?l9o`02o`Oo01Co1Ol09_l6o`0ho`Co04[o1?l0G?l4
o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0ol0aol2o`3Io`;o0>_o0ol0oOl2o`3ol0;o0?oN0_l0ol`2
o`3o^P03o`3oZ?l0oiOo0?nG00;o0?n50_l0og<01?l0of7o0?m?o`3oCol0ocd2o`3o:`04o`3o6Ol0
o`Oo0?l7o`[o00;o7?l000?o;_l0ocoo0?mAo`000_mSo`000omeo`3oQol0oiWo0002oj_o000Bokgo
0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole
0?oo8`3ooa404ooo0005ooooo`7o00000Oooool001Gooooo0_l00003ooooobco3`3o?_lQ0?l?o`l0
o`Wo00;o1ol05?l5o`0Vo`Go03So1Ol0B_l3o`1Lo`Co06ko0ol0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37
o`;o0=Wo0_l0jol3o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj00?o0?nXo`3oUol0oiL00_l0ohD2o`3o
L`04o`3oHOl0odoo0?m?o`3o?@;o0?l[00Co0?lIo`3o1ol0o`Oo2_l00_lLo`000ol^o`3o?ol0oe7o
0002of?o0003ogGo0?n7o`3oVOl000;oZol001;o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo5
0?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@0Cool000Cooooo0_l00001oooo
o`005Oooool00ol0003oooooooooo`02ooooobgo3`3o?_lQ0?l>o`l0o`Wo00;o1ol05?l5o`0Vo`Go
03So1Ol0B_l3o`1Lo`Go06ko0ol0Ool2o`2Ao`?o0:?o0ol0]Ol3o`37o`;o0=Wo0ol0jol2o`3mo`?o
0?o`00?o0?oNo`3oc?l0ol`00_l0okX2o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of400ol0odoo
0?lmo`3o?@02o`3o:`05o`3o6Ol0o`Oo2_l0o`[o0?lLo`000_l^o`002?loo`3oDOl0of?o0?mSo`3o
MOl0ohOo0?nIo`3oZol00_nmo`004Oo?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?oo
S`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa4001;oo`001Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo;_l?0?lnob40o`ko3`3o2Ol00_l7o`0Do`Go02Ko1Ol0>?l5o`1:o`?o
05co1?l0K_l3o`1oo`?o097o0ol0Xol3o`2eo`?o0<Oo0_l0fOl2o`3[o`?o0?go0_l0oo02o`3ogP;o
0?o<0_l0okX00ol0ojSo0?nGo`3oU`02o`3oQ@;o0?mc00Co0?mQo`3oCol0odoo0?lm0_l0ob/01?l0
oaWo0?l7o`3o1ol:o`02oaco0003obko0?loo`3oDOl000;oHol000?oMOl0ohOo0?nIo`000_n[o`00
4_nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom7
0?oo=@3oob<0oolA01;oo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo
<?l?0?llob40o`ko3`3o2Ol00_l7o`0Do`Go02Ko1_l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`?o097o
0ol0Xol3o`2eo`?o0<Oo0_l0fOl2o`3[o`?o0?go0_l0oo02o`3ogP;o0?o<0_l0okX00ol0ojSo0?nG
o`3oU`02o`3oQ@;o0?mc00Co0?mQo`3oCol0odoo0?lm0_l0ob/01?l0oaWo0?l7o`3o1ol:o`02oaco
0008obko0?loo`3oDOl0oe7o0?mSo`3oMOl0ohOo0?nIo`02oj_o000Bokgo0?o?o`3ohOl0oo?o0?oo
nP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa404_oo0005
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolao`l0occo8@3o3_l?0?l9o`02
o`Ko01Co1_l09_l5o`0ho`Go04[o0ol0G?l4o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0_l0aol3o`3I
o`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL00ol0ohGo0?mco`3oL`02o`3o
H@04o`3oCol0ocgo0?lmo`3o:`;o0?lI00Co0?l7o`[o0?lLo`3o7?l00_l^o`001_loo`3oDOl0of?o
0?meo`3oQol0oiWo00;oZol000go_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40
oon?0?ooO@3oof/000;ooeT000?oocD0oolS0?oo4@004_oo0005ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_oooolco`l0oc_o8@3o3Ol?0?l9o`02o`Oo01Co1Ol09_l6o`0ho`Co04[o
0ol0G?l4o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0ol0aol2o`3Io`;o0>_o0ol0oOl2o`3ol0;o0?oN
0_l0ol`2o`3o^P03o`3oZ?l0oiOo0?nG00;o0?n50_l0og<01?l0of7o0?m?o`3oCol0ocd2o`3o:`04
o`3o6Ol0o`Oo0?l7o`[o00;o7?l000So;_l0ocoo0?mAo`3oDOl0of?o0?meo`3oQol0oiWo00;oZol0
01;o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?oo
A`3oocD0oolS0?oo4@0Aool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
ocCo3`3o>_lQ0?l>o`l0o`Wo00;o1_l05?l6o`0Vo`Go03So1?l0B_l4o`1Lo`?o06ko0ol0Ool3o`2A
o`Co0:?o0_l0]Ol3o`37o`;o0=Wo0ol0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj00?o0?nXo`3o
Uol0oiL00_l0ohD2o`3oL`03o`3oHOl0odoo0?m?00;o0?lm00Go0?l[o`3o6Ol0o`Oo0?l7o`[o0002
oaco0008obko0?loo`3oDOl0oe7o0?mSo`3oMOl0ohOo0?nIo`02oj_o000Bokgo0?o?o`3ohOl0oo?o
0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa404Ooo
0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooooleo`l0oc[o8@3o3Ol?0?l9
o`02o`Oo01Co1Ol09_l6o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0_l0aol3
o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL00ol0ohGo0?mco`3oL`02
o`3oH@04o`3oCol0ocgo0?lmo`3o:`;o0?lI00Co0?l7o`[o0?lLo`3o7?l00_l^o`001_loo`3oDOl0
of?o0?meo`3oQol0oiWo00;oZol001;o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3o
oj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS0?oo4@0Aool000Gooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02ooooocOo3`3o>?lQ0?l>o`l0o`Wo00;o1_l05?l6o`0Vo`Go03So1?l0
B_l4o`1Lo`?o06ko0ol0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`;o0=Wo0ol0jol2o`3mo`;o0?o`0_l0
omh2o`3oc003o`3o^_l0ojSo0?nX00;o0?nG0_l0ohD2o`3oL`04o`3oHOl0odoo0?m?o`3o?@;o0?l[
00Co0?lIo`3o1ol0o`Oo2_l00_lLo`002?l^o`3o?ol0oe7o0?mAo`3oHol0ogGo0?n7o`3oVOl00_n[
o`004_nmo`3ohOl0oo?o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0
oom70?oo=@3oob<0oolA013oo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
oooo>?l?0?lhob40o`go3`3o2Ol00_l6o`0Do`Ko02Ko1Ol0>?l5o`1:o`Co05co0ol0K_l3o`1oo`?o
097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX2o`3oZ0;o
0?nG00?o0?n5o`3oLol0og<00_l0of401?l0odoo0?lmo`3o?Ol0ob/2o`3o6@06o`3o1ol:o`3o7?l0
oaco0?l^o`3o?ol00_mAo`001?mSo`3oMOl0ohOo0?nIo`02oj_o000Bokgo0?oQo`3ohOl0oo?o0?oo
nP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa404?oo0005
ooooo`7o00000Oooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005oooo
o`03o`000?oooooooooo00;ooooo>Ol?0?lhob40o`go3`3o2Ol00_l6o`0Do`Ko02Ko1Ol0>?l4o`1:
o`Co05co0ol0K_l3o`1oo`?o097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl2o`3[o`;o0?go0_l0oo02o`3o
gP;o0?o<0_l0okX2o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of401?l0odoo0?lmo`3o?Ol0ob/2
o`3o6@04o`3o1ol:o`3o7?l0oaco00;o;_l000Ko?ol0oe7o0?mSo`3oMOl0ohOo0?nIo`02oj_o000B
okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0
oole0?oo8`3ooa404?oo0005ooooo`7o00000Oooool00005ooooool0003oooooooooool000001ooo
ool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_ooool7o`02oc?o3`3o
=olQ0?l=o`l0o`Wo00;o1_l05?l6o`0Vo`Go03So1?l0B_l5o`1Lo`;o06ko0ol0Ool3o`2Ao`?o0:?o
0ol0]Ol3o`37o`;o0=Wo0ol0jol2o`3mo`;o0?o`0_l0omh2o`3oc003o`3o^_l0ojSo0?nX00;o0?nG
0_l0ohD2o`3oL`04o`3oHOl0odoo0?m?o`3o?@;o0?l[00Co0?lIo`3o1ol0o`Oo2_l00_lLo`002?l^
o`3o?ol0oe7o0?mAo`3oHol0ogGo0?n7o`3oVOl00_n[o`004_nmo`3ohOl0oo?o0?oco`3oooX0oooX
0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA00ooo`001Oooool1
o`00007ooooo00001Ooooooo0000oooooooooooo000000_ooooo00?o0000ooooooooool00_ooool2
o`0000?ooooo4?l00_l[o`l0ocOo8@3o3Ol?0?l9o`02o`Ko01Co1_l09_l5o`0ho`Co04[o1?l0G?l3
o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0_l0aol3o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2
o`3o^P;o0?nX0_l0oiL00ol0ohGo0?mco`3oL`02o`3oH@04o`3oCol0ocgo0?lmo`3o:`;o0?lI00Ko
0?l7o`[o0?lLo`3o7?l0obko0?loo`02oe7o0004of?o0?meo`3oQol0oiWo00;oZol001;o_Ol0oloo
0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS
0?oo4@0?ool000Cooooo0_l00001ooooo`0000Goooooo`000?ooooooooooo`00000;ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_oooolDo`02obSo3`3o=_lQ0?l>o`l0o`So00;o
1_l05?l6o`0Vo`Go03So1?l0B_l4o`1Lo`?o06ko0ol0Ool3o`2Ao`?o0:?o0ol0]Ol2o`37o`?o0=Wo
0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP2o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ
00Co0?m?o`3o?Ol0ocgo0?l[0_l0oaT01_l0o`Oo2_l0oaco0?lLo`3o;_l0ocoo00;oDOl000CoHol0
ogGo0?n7o`3oVOl00_n[o`004_nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3o
ohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<0oolA00ooo`001Oooool1o`00007ooooo00001Ooooooo
0000oooooooooooo000000Oooooo1?l00005ooooo`03o`000?oooooooooo00;ooooo5Ol00_lXo`l0
ocKo8@3o3Ol?0?l9o`02o`Ko01Co1_l09_l5o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2S
o`?o0;Go0_l0aol3o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00?o0?nj00?o0?nXo`3o
Uol0oiL00_l0ohD00ol0og?o0?mQo`3oH@02o`3oC`05o`3o?Ol0ob_o0?lIo`3o6Ol0o`L00_l:o`02
oaco00;o?ol000GoDOl0of?o0?meo`3oQol0oiWo0002oj_o000Bokgo0?o?o`3ohOl0oo?o0?oonP3o
onP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`3ooa403ooo0005oooo
o`7o00000Oooool00005ooooool0003oooooooooool000001oooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00;ooooo5ol00_lWo`l0ocGo8@3o3_l?0?l8o`02o`Ko01Co1_l09_l5o`0h
o`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0_l0aol3o`3Io`;o0>_o0_l0oOl2o`3o
l0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL01?l0ohGo0?mco`3oLol0of42o`3oC`;o0?lm00Go0?l[
o`3o6Ol0oaWo0?l7o`[o0002oaco000:obko0?loo`3oDOl0oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0
okgo00;ocol000oohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3o
odL0oole0?oo4@003ooo0005ooooo`7o00000Oooool000;ooooo0_l00008ooooo`Go00001?ooool0
0ol0003oooooooooo`02oooooaWo00;o9_l?0?leob40o`go3`3o2?l00_l7o`0Do`Go02Ko1Ol0>?l5
o`1:o`?o05co0ol0K_l3o`1oo`?o097o0ol0Xol3o`2eo`?o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02
o`3ogP;o0?o<0_l0okX2o`3oZ0;o0?nG00?o0?n5o`3oLol0og<00_l0of401?l0odoo0?lmo`3o?Ol0
ob/2o`3o6@06o`3o1ol:o`3o7?l0oaco0?l^o`3o?ol00_mAo`001?mSo`3oMOl0ohOo0?nIo`02oj_o
000Bokgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3o
odL0oole0?oo8`3ooa403_oo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
oolLo`02obCo3`3o=?lQ0?l>o`l0o`So00;o1_l05?l6o`0Vo`Go03So1?l0B_l4o`1Lo`?o06ko0ol0
Ool3o`2Ao`?o0:?o0ol0]Ol2o`37o`?o0=Wo0_l0jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00ol0
okX00ol0ojSo0?nGo`3oU`02o`3oQ@03o`3oLol0of7o0?mQ00;o0?m?00Go0?lmo`3o:ol0oaWo0?lI
o`3o1`02o`[o0009oaco0?l^o`3o?ol0ocoo0?mAo`3oHol0ogGo0?n7o`3oVOl000;oZol001;o_Ol0
oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0
oolS0?oo4@0>ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooako00;o
8_l?0?leob40o`go3`3o2?l00_l7o`0Do`Go02Ko1Ol0>?l4o`1:o`Co05co0ol0K_l3o`1oo`?o097o
0ol0Xol3o`2eo`;o0<Oo0ol0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX2o`3oZ0;o0?nG
00Co0?n5o`3oLol0og?o0?mQ0_l0odl2o`3o?@05o`3o:ol0oaWo0?lIo`3o1ol:o`000_lLo`002_l^
o`3o?ol0oe7o0?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`02oloo0008on7o0?oco`3oooX0oooX
0?ooe`3oolD0oonc0?ooX@02oomm0005oom[0?ooF@3oodL0oole0?oo4@003_oo0005ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooolPo`02ob7o3`3o=?lQ0?l>o`l0o`Oo00;o1ol0
5?l5o`0Vo`Go03So1Ol0B_l3o`1Lo`?o06ko0ol0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`;o0=Wo0_l0
jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP2o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ00Co
0?m?o`3o?Ol0ocgo0?l[0_l0oaT01_l0o`Oo2_l0oaco0?lLo`3o;_l0ocoo00;oDOl000GoHol0ogGo
0?n7o`3oVOl0oj_o0002okgo000@oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?
0?ooO@3oof/0oomI0?ooA`3oocD0oolA00koo`001Oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooo8_l00_lPo`l0ocCo8@3o3Ol?0?l8o`02o`Ko01Co1_l09_l5o`0ho`Co04[o1?l0
G?l3o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0_l0aol3o`3Io`;o0>_o0_l0oOl2o`3ol004o`3og_l0
olco0?o<o`3oc0;o0?nj00?o0?nXo`3oUol0oiL00_l0ohD00ol0og?o0?mQo`3oH@02o`3oC`05o`3o
?Ol0ob_o0?lIo`3o6Ol0o`L00_l:o`002OlLo`3o;_l0ocoo0?loo`3oDOl0of?o0?meo`3oQol0oiWo
0002oj_o000Aokgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[
0?ooF@3oodL0oole0?oo4@003_oo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool0
0_oooolTo`02oaoo3`3o=?lQ0?l=o`l0o`So00;o1_l05?l5o`0Vo`Go03So1?l0B_l4o`1Lo`?o06ko
0ol0Ool3o`2Ao`?o0:?o0ol0]Ol2o`37o`?o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj
00?o0?nXo`3oUol0oiL00_l0ohD00ol0og?o0?mQo`3oH@02o`3oC`05o`3o?Ol0ob_o0?lIo`3o6Ol0
o`L00_l:o`002?lLo`3o;_l0ocoo0?loo`3oDOl0of?o0?meo`3oQol00_nIo`004on[o`3o_Ol0oloo
0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS
0?oo4@003Ooo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolVo`02oako
3`3o<olQ0?l=o`l0o`So00;o1_l05?l5o`0Vo`Go03So1Ol0B_l3o`1Lo`?o06ko1?l0Ool2o`2Ao`?o
0:?o0ol0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP2o`3oU`03
o`3oQOl0og?o0?mc00;o0?mQ00Co0?m?o`3o?Ol0ocgo0?l[0_l0oaT01_l0o`Oo2_l0o`[o0?lLo`3o
;_l0ocoo00;oDOl000GoHol0ogGo0?n7o`3oVOl0oj_o0002okgo000@oloo0?oQo`3olol0oooj0?oo
j03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolA00goo`001Oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;ooooo:?l00_lMo`l0oc?o8@3o3Ol?0?l8o`02o`Ko
01Co1Ol09_l5o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`?o0;Go0_l0aol3o`3Io`;o
0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P03o`3oZ?l0oiOo0?nG00;o0?n500?o0?mco`3oHOl0
of400_l0odl01Ol0ocgo0?l[o`3o6Ol0oaWo0?l700;o2_l000So7?l0obko0?loo`3o?ol0oe7o0?mS
o`3oMOl0ohOo00;oVOl001;oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ
0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo4@0=ool000Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooobWo00;o7?l?0?lcob40o`go3`3o2?l00_l6o`0Do`Go02Ko1Ol0>?l4o`1:
o`Co05co0ol0K_l3o`1oo`?o097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl2o`3[o`;o0?go0_l0oo02o`3o
gP;o0?o<0_l0okX00ol0ojSo0?nGo`3oU`02o`3oQ@03o`3oLol0of7o0?mQ00;o0?m?00Co0?lmo`3o
:ol0oaWo0?lI0_l0o`L00ol:o`3o7?l0obko0002ocoo0004oe7o0?mSo`3oMOl0ohOo00;oVOl001;o
Zol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3o
odL0oole0?oo4@0=ool000Gooooo0Ol00001ooooo`005Oooool2o`0000?ooooo:_l00_lLo`l0oc?o
8@3o3Ol?0?l8o`02o`Ko01Co1Ol09_l5o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`?o
0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX0_l0oiL01?l0ohGo
0?mco`3oLol0of42o`3oC`03o`3o?Ol0ob_o0?l[00;o0?lI00Co0?l7o`[o0?lLo`3o;_l00_loo`00
0omAo`3oHol0ogGo0002ohOo0009oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL000;o
olD000Oooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD000;ooa403?oo0004ooooo`;o00000Oooool0
01Gooooo00?o0000ooooooooool00_ooool/o`02oa_o3`3o<_lQ0?l=o`l0o`So00;o1_l05?l5o`0V
o`Go03So1?l0B_l4o`1Lo`?o06ko0ol0Ool3o`2Ao`?o0:?o0ol0]Ol2o`37o`?o0=Wo0_l0jol2o`3m
o`04o`3ol?l0omko0?oNo`3ogP;o0?o<0_l0okX01?l0ojSo0?nGo`3oUol0ohD2o`3oL`;o0?mQ0_l0
odl01Ol0ocgo0?l[o`3o6Ol0oaWo0?l700;o2_l000So7?l0obko0?loo`3o?ol0oe7o0?mSo`3oMOl0
ohOo00;oVOl001;oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3o
ogd0oom[0?ooF@3oodL0oolS0?oo4@0<ool000Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooobgo00;o6ol?0?lbob40o`co3`3o2?l00_l7o`0Do`Go02Ko1Ol0>?l3o`1:o`Co05co
0ol0K_l3o`1oo`?o097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<
0_l0okX00ol0ojSo0?nGo`3oU`02o`3oQ@03o`3oLol0of7o0?mQ00;o0?m?00Co0?lmo`3o:ol0oaWo
0?lI0_l0o`L00ol:o`3o7?l0obko0002ocoo0004oe7o0?mSo`3oMOl0ohOo00;oVOl001;oZol0okgo
0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole
0?oo4@0<ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooobko00;o6ol?
0?laob40o`go3`3o2?l00_l6o`0Do`Go02Ko1Ol0>?l4o`1:o`Co05co0ol0K_l3o`1oo`?o097o0ol0
Xol2o`2eo`?o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX2o`3oZ0;o0?nG00Co
0?n5o`3oLol0og?o0?mQ0_l0odl00ol0ocgo0?l[o`3o:`02o`3o6@04o`3o1ol:o`3o7?l0obko00;o
?ol000CoDOl0of?o0?meo`3oQol00_nIo`004On[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0
ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD000;ooa402ooo0005ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_ooool7o`0DobWo00;o6_l?0?laob40o`co3`3o2?l00_l7
o`0Do`Go02Ko1Ol0>?l3o`1:o`Co05co0ol0K_l3o`1oo`?o097o0ol0Xol3o`2eo`;o0<Oo0ol0fOl2
o`3[o`03o`3mool0oo3o0?o`00?o0?oN0_l0ol`2o`3o^P04o`3oZ?l0oiOo0?nGo`3oQ@;o0?mc0_l0
of42o`3oC`05o`3o?Ol0ob_o0?lIo`3o6Ol0o`L00_l:o`002?lLo`3o;_l0ocoo0?loo`3oDOl0of?o
0?meo`3oQol00_nIo`004_n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40
oon?0?ooO@3oof/0oomI0?ooA`3oob<0oolA00_oo`001Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo3_l05?lSo`02oaWo3`3o<_lQ0?l;o`l0o`So00;o1ol05?l5o`0Vo`Go03So
0ol0B_l4o`1Lo`Co06ko0_l0Ool3o`2Ao`Co0:?o0_l0]Ol2o`37o`?o0=Wo0_l0jol2o`3mo`;o0?o`
0_l0omh2o`3oc0;o0?nj00?o0?nXo`3oUol0oiL00_l0ohD00ol0og?o0?mQo`3oH@02o`3oC`05o`3o
?Ol0ob_o0?lIo`3o6Ol0o`L00_l:o`002?lLo`3o;_l0ocoo0?loo`3oDOl0of?o0?meo`3oQol00_nI
o`004_n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0
oomI0?ooA`3oob<0oolA00_oo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
oooo4Ol05?lRo`02oaSo3`3o<OlQ0?l<o`l0o`So00;o1ol05?l4o`0Vo`Go03So1?l0B_l4o`1Lo`?o
06ko0ol0Ool3o`2Ao`?o0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o
0?nj0_l0ojP00ol0oiOo0?n5o`3oQ@02o`3oL`04o`3oHOl0odoo0?m?o`3o?@;o0?l[00Ko0?lIo`3o
1ol:o`3o2_l0oaco0?l^o`02ocoo0004oe7o0?mSo`3oMOl0ohOo00;oVOl0017oZol0okgo0?o?o`3o
hOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oolS0002oolA
00[oo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5?l05?lPo`02oaSo
3`3o<OlQ0?l;o`l0o`So00;o1ol05?l5o`0Vo`Go03So0ol0B_l4o`1Lo`?o06ko0ol0Ool3o`2Ao`?o
0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP2o`3oU`04
o`3oQOl0og?o0?mco`3oH@;o0?m?00?o0?lmo`3o:ol0ob/00_l0oaT01?l0o`Oo2_l0oaco0?l^o`02
ocoo0004oe7o0?mSo`3oMOl0ohOo00;oVOl0017oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG
0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0002oolA00[oo`001Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo5ol05?lNo`02oaSo3`3o<?lQ0?l;o`l0o`So00;o
1ol05?l5o`0Vo`Go03So0ol0B_l4o`1Lo`Co06ko0_l0Ool3o`2Ao`Co0:?o0_l0]Ol2o`37o`?o0=Wo
0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj00?o0?nXo`3oUol0oiL00_l0ohD00ol0og?o0?mQ
o`3oH@02o`3oC`05o`3o?Ol0ob_o0?lIo`3o6Ol0o`L00_l:o`002?lLo`3o;_l0ocoo0?loo`3oDOl0
of?o0?meo`3oQol00_nIo`004_n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3o
oj40oon?0?ooO@3oof/0oomI0?ooA`3oob<0oolA00[oo`001Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo6_l05?lLo`02oaSo3`3o<?lQ0?l;o`l0o`So00;o1ol05?l5o`0Vo`Co
03So1?l0B_l4o`1Lo`?o06ko0ol0Ool3o`2Ao`?o0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o
0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP00ol0oiOo0?n5o`3oQ@02o`3oL`04o`3oHOl0odoo0?m?o`3o
?@;o0?l[00Ko0?lIo`3o1ol:o`3o2_l0oaco0?l^o`02ocoo0004oe7o0?mSo`3oMOl0ohOo00;oVOl0
01;oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?oo
F@3oodL0oolS0?oo4@0:ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
oago01Co6ol00_lFo`l0oc3o8@3o2ol?0?l8o`02o`Oo01Co1Ol09_l4o`0ho`Co04[o1?l0G?l3o`1^
o`?o07oo0ol0TOl3o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o
^P;o0?nX00?o0?nGo`3oQOl0ohD00_l0og<01?l0of7o0?m?o`3oCol0ocd2o`3o:`06o`3o6Ol0o`Oo
2_l0o`[o0?lLo`3o;_l00_loo`001?mAo`3oHol0ogGo0?n7o`02oiWo000@oj_o0?nmo`3ocol0on7o
0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom700;oob<02_oo0005
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolPo`0DoaWo00;o5_l?0?l`ob40
o`_o3`3o2?l00_l7o`0Do`Go02Ko1?l0>?l4o`1:o`Co05co0ol0K_l3o`1oo`?o097o0ol0Xol2o`2e
o`;o0<Oo0ol0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX01?l0ojSo0?nGo`3oUol0ohD2
o`3oL`;o0?mQ0_l0odl00ol0ocgo0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o;_l000;o?ol000CoDOl0
of?o0?meo`3oQol00_nIo`001On[o`3o_Ol0oloo0?oQo`3olol000;oooX000_oomL0ooo50?oo/`3o
oj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolS000:ool000Gooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02ooooob;o01Co6?l00_lFo`l0oboo8@3o2ol?0?l8o`02o`Oo01Co1Ol09_l4
o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o0_l0oOl2
o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX00?o0?nGo`3oQOl0ohD00_l0og<01?l0of7o0?m?o`3oCol0
ocd2o`3o:`06o`3o6Ol0o`Oo2_l0o`[o0?lLo`3o;_l00_loo`001?mAo`3oHol0ogGo0?n7o`02oiWo
000Boj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3o
oeT0oom70?oo8`3ooa402Ooo0005ooooo`7o00000Oooool001Gooooo0_l00003ooooob?o01Co6?l0
0_lFo`l0obko8@3o3?l?0?l8o`02o`Ko01Co1_l09_l3o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo1?l0
TOl2o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P;o0?nX00?o
0?nGo`3oQOl0ohD00_l0og<00ol0of7o0?m?o`3oC`02o`3o?@03o`3o:ol0oaWo0?l700;o2_l000So
7?l0obko0?loo`3o?ol0oe7o0?mSo`3oMOl0ohOo00;oVOl001;oZol0okgo0?o?o`3ohOl0oo?o0?oo
nP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo8`09ool000Cooooo
0_l00001ooooo`005Oooool00ol0003oooooooooo`02ooooobGo01Co5ol00_lFo`l0obko8@3o2ol?
0?l8o`02o`Oo01Co1Ol09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`;o0;Go0_l0
aol3o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P04o`3oZ?l0oiOo0?nGo`3oQ@;o0?mc
0_l0of42o`3oC`03o`3o?Ol0ob_o0?lI00;o0?l700?o2_l0oaco0?l^o`000_loo`001?mAo`3oHol0
ogGo0?n7o`02oiWo000Boj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3o
ohl0oomm0?ooJ`3ooeT0oom70?oo=@3oob<02Ooo0005ooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_oooolVo`0DoaOo00;o5_l?0?l]ob40o`co3`3o2?l00_l6o`0Do`Ko02Ko0ol0>?l4
o`1:o`Co05co0ol0K_l3o`1oo`?o097o0ol0Xol2o`2eo`?o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02
o`3ogP;o0?o<0_l0okX2o`3oZ003o`3oUol0ohGo0?n500;o0?mc00Co0?mQo`3oCol0odoo0?lm0_l0
ob/02?l0oaWo0?l7o`[o0?l:o`3o7?l0obko0?loo`3oDOl00_mSo`005_meo`3oQol0oiWo0?nIo`3o
Zol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?ooA`3o
ocD0oolS0?oo4@08ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooobOo
01Co5ol00_lFo`l0obgo8@3o2ol?0?l8o`02o`Oo01Co1Ol09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o
07oo0ol0TOl3o`2So`;o0;Go0_l0aol2o`3Io`?o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`00ol0ok[o
0?nXo`3oZ002o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ00Go0?m?o`3o?Ol0ob_o0?l[o`3o6@02o`3o
1`04o`[o0?lLo`3o;_l0ocoo00;oDOl000?oHol0ogGo0?n7o`000_nIo`003_n[o`3o_Ol0oloo0?oQ
o`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/00_ooA`000ooo8`3ooa40ool0
0007ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooobWo01Co5_l00_lF
o`l0obgo8@3o2ol?0?l8o`02o`Ko01Co1Ol09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3
o`2So`;o0;Go0_l0aol3o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`00ol0ok[o0?nXo`3oZ002
o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ0_l0odl00ol0ocgo0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o
;_l000;o?ol000CoDOl0of?o0?meo`3oQol00_nIo`004_n[o`3o_Ol0oloo0?oQo`3olol0oooj0?oo
j03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolA00Soo`001Oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;ooooo:_l05?lFo`02oaGo3`3o;OlQ0?l;o`l0o`So
00;o1_l05?l6o`0Vo`?o03So1?l0B_l4o`1Lo`?o06ko0ol0Ool4o`2Ao`;o0:?o0_l0]Ol3o`37o`;o
0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj0_l0ojP00ol0oiOo0?n5o`3oQ@02o`3oL`04
o`3oHOl0odoo0?m?o`3o?@;o0?l[00So0?lIo`3o1ol:o`3o2_l0oaco0?l^o`3o?ol0oe7o00;oHol0
01KoMOl0ohOo0?nIo`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?oo
X@3oohl0oomm0?ooJ`3oodL0oole0?oo8`3ooa401ooo0005ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_ooool7o`0VobKo01Co5?l00_lEo`l0obgo8@3o2ol?0?l8o`02o`Ko01Co1Ol0
9_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`;o0;Go0_l0aol3o`3Io`;o0>_o0_l0
oOl2o`3ol0;o0?oN0_l0ol`00ol0ok[o0?nXo`3oZ002o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ00Go
0?m?o`3o?Ol0ob_o0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o;_l000;o?ol000CoDOl0of?o0?meo`3o
Qol00_nIo`004_n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?oo
O@3oof/0oom70?oo=@3oob<0oolA00Ooo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo4Ol09_lNo`0Doa;o00;o5Ol?0?l]ob40o`_o3`3o2?l00_l6o`0Do`Go02Ko1?l0>?l4
o`1:o`Co05co0ol0K_l3o`1oo`?o097o0ol0Xol2o`2eo`;o0<Oo0ol0fOl2o`3[o`;o0?go0_l0oo02
o`3ogP;o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL00ol0ohGo0?mco`3oL`02o`3oH@05o`3oCol0ocgo
0?l[o`3o:ol0oaT00_l0o`L00ol:o`3o7?l0obko0002ocoo0004oe7o0?mSo`3oMOl0ohOo00;oVOl0
01;oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0oom[0?oo
F@3oocD0oolS0?oo4@07ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
oaCo02Ko7?l05?lBo`02oaGo3`3o;OlQ0?l;o`l0o`So00;o1_l05?l5o`0Vo`Co03So1?l0B_l4o`1L
o`?o06ko0ol0Ool3o`2Ao`;o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3o
c0;o0?nj00?o0?nXo`3oUol0oiL00_l0ohD2o`3oL`06o`3oHOl0odoo0?lmo`3o?Ol0ob_o0?lI0_l0
o`L02Ol:o`3o7?l0obko0?l^o`3o?ol0oe7o0?mSo`3oMOl0ohOo0002oiWo000Boj_o0?nmo`3ocol0
on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oole0?oo8`3ooa40
1ooo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolGo`0Voa[o01Co4_l0
0_lEo`l0obco8@3o2ol?0?l8o`02o`Ko01Co1Ol09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0
TOl3o`2So`;o0;Go0_l0aol3o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN00?o0?o<o`3o^_l0okX00_l0
ojP2o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ00Go0?m?o`3o?Ol0ob_o0?l[o`3o6@02o`3o1`03o`[o
0?lLo`3o;_l000;o?ol000GoDOl0of?o0?meo`3oQol0oiWo0002oj_o000:okgo0?o?o`3olol0oo?o
0?oonP3oonP0oooG0?ooa@3ook<0oonQ00;oogd000Goof/0oom70?oo=@3oob<0oolA0006ool000Go
oooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaWo02Ko6Ol05?lBo`02oaGo3`3o
:olQ0?l<o`l0o`So00;o1_l05?l4o`0Vo`Co03So1Ol0B_l3o`1Lo`?o06ko0ol0Ool3o`2Ao`?o0:?o
0_l0]Ol2o`37o`?o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc003o`3o^_l0ojSo0?nX00;o0?nG
00?o0?n5o`3oLol0og<00_l0of401Ol0odoo0?lmo`3o:ol0ob_o0?lI00;o0?l700?o2_l0oaco0?l^
o`000_loo`001?mAo`3oHol0ogGo0?n7o`02oiWo000Boj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX
0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oole0?oo8`3ooa401_oo0005ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooolLo`0VoaOo01Co4_l00_lDo`l0obco8@3o2ol?
0?l8o`02o`Ko01Co1Ol09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl2o`2So`?o0;Go0_l0
aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P03o`3oZ?l0oiOo0?nG00;o0?n50_l0
og<01_l0of7o0?m?o`3o?Ol0ocgo0?l[o`3o6@;o0?l700?o2_l0oaco0?l^o`000_loo`001?mAo`3o
Hol0ogGo0?n7o`02oiWo000Boj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?oo
X@3oohl0oomm0?ooJ`3ooeT0oole0?oo8`3ooa401_oo0005ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooolNo`0VoaKo01Co4_l00_lDo`l0ob_o8@3o3?l?0?l8o`02o`Go01Co1Ol0
9_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl3o`2So`;o0;Go0_l0aol3o`3Io`;o0>_o0_l0
oOl2o`3ol0;o0?oN00?o0?o<o`3o^_l0okX00_l0ojP2o`3oU`04o`3oQOl0og?o0?mco`3oH@;o0?m?
00Co0?lmo`3o:ol0ob_o0?lI0_l0o`L00ol:o`3o;_l0obko0002ocoo0005oe7o0?mSo`3oMOl0ohOo
0?nIo`000_n[o`004Oo?o`3ohOl0oo?o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oogd0oom[
0?ooF@3oodL0oole0?oo8`3ooa4000Goo`001Oooool1o`00007ooooo000Eooooo`;o00000ooooolP
o`0VoaGo01Co4_l00_lDo`l0ob[o8@3o3?l?0?l8o`02o`Ko01Co1?l09_l4o`0ho`Go04[o0ol0G?l3
o`1^o`Co07oo0_l0TOl3o`2So`;o0;Go0_l0aol3o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`0
0ol0ok[o0?nXo`3oZ002o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ00Go0?m?o`3o?Ol0ob_o0?l[o`3o
6@02o`3o1`03o`[o0?lLo`3o;_l000;o?ol000GoDOl0of?o0?meo`3oQol0oiWo0002oj_o00;ocol0
00SohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ00;oogd000GooeT0oom70?oo=@3oob<0oolA
0005ool000Cooooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02ooooob;o02Ko5Ol05?lA
o`02oa?o3`3o:olQ0?l;o`l0o`So00;o1_l05?l5o`0Vo`Co03So1?l0B_l4o`1Lo`?o06ko0ol0Ool3
o`2Ao`;o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj00?o0?nX
o`3oUol0oiL00_l0ohD2o`3oL`06o`3oHOl0odoo0?lmo`3o?Ol0ob_o0?lI0_l0o`L00ol:o`3o7?l0
obko0002ocoo0005oe7o0?mSo`3oMOl0ohOo0?nIo`000_n[o`002_nmo`3ocol0on7o0?oco`3oooX0
oooX0?ooe`3oolD0oonc0?ooX@02oomm0005oomI0?ooA`3oocD0oolS0?oo4@001Ooo0005ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_oooolTo`0VoaCo01Co4Ol00_lCo`l0ob[o8@3o
3?l?0?l8o`02o`Ko01Co1?l09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl2o`2So`?o0;Go
0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`2o`3o^P03o`3oZ?l0oiOo0?nG00;o0?n5
0_l0og<01_l0of7o0?m?o`3o?Ol0ocgo0?l[o`3o6@;o0?l700?o2_l0oaco0?l^o`000_loo`001?mA
o`3oHol0ogGo0?n7o`02oiWo000Boj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc
0?ooX@3oohl0oomm0?ooJ`3ooeT0oole0?oo8`3ooa401Ooo0005ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_oooolUo`0VoaCo01Co4Ol00_lCo`l0obWo8@3o3?l?0?l8o`02o`Ko01Co
1?l09_l4o`0ho`Go04[o0ol0G?l3o`1^o`Co07oo0_l0TOl3o`2So`;o0;Go0_l0aol3o`3Io`;o0>_o
0_l0oOl2o`3ol0;o0?oN0_l0ol`00ol0ok[o0?nXo`3oZ002o`3oU`03o`3oQOl0og?o0?mc00;o0?mQ
00Go0?m?o`3o?Ol0ob_o0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o;_l000;o?ol000GoDOl0of?o0?me
o`3oQol0oiWo0002oj_o00;ocol000oohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooO@3o
of/0oomI0?ooA`3oocD0oolS0?oo4@001?oo0005ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_oooolWo`0Voa?o01Co4Ol00_lCo`l0obWo8@3o3?l?0?l8o`02o`Go01Co1Ol09_l4o`0h
o`Co04[o1?l0G?l3o`1^o`?o07oo0ol0TOl2o`2So`?o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3o
l0;o0?oN0_l0ol`2o`3o^P03o`3oZ?l0oiOo0?nG00;o0?n500Co0?mco`3oHOl0of7o0?m?0_l0ocd0
1ol0ob_o0?lIo`3o1ol0o`Oo2_l0oaco0?l^o`000_loo`001OmAo`3oHol0ogGo0?n7o`3oVOl000;o
Zol0017o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oomm0?ooJ`3ooeT0oom7
0?oo=@3oob<0oolA0004ool000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
o`Oo03So8_l09_lBo`0Doa3o00;o4ol?0?lYob40o`co3`3o2?l00_l5o`0Do`Go02Ko1?l0>?l4o`1:
o`Co05co0ol0K_l3o`1oo`?o097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02o`3o
gP;o0?o<0_l0okX00ol0ojSo0?nGo`3oU`02o`3oQ@04o`3oLol0of7o0?mQo`3oC`;o0?lm00Oo0?l[
o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l000;o?ol000GoDOl0of?o0?meo`3oQol0oiWo0002oj_o000A
okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oof/0oomI0?ooA`3oocD0
oolS0?oo4@001?oo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool>o`0h
oaco02Ko4_l05?l@o`02oa?o3`3o:OlQ0?l<o`l0o`So00;o1Ol05?l5o`0Vo`Co03So1?l0B_l4o`1L
o`?o06ko0ol0Ool2o`2Ao`?o0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00?o0?oNo`3o
c?l0ol`00_l0okX2o`3oZ0;o0?nG0_l0ohD2o`3oH@05o`3oCol0ocgo0?lmo`3o:ol0oaT00_l0o`L0
0ol:o`3o7?l0obko0002ocoo0004oe7o0?mSo`3oMOl0ohOo00;oVOl001;oZol0okgo0?o?o`3ohOl0
oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oof/0oomI0?ooA`3oocD0oolS0?oo4@04ool0
00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa7o03So6ol09_lAo`0Doa3o
00;o4ol?0?lXob40o`co3`3o2?l00_l5o`0Do`Go02Ko1?l0>?l4o`1:o`Co05co0ol0K_l3o`1oo`?o
097o0_l0Xol2o`2eo`?o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<0_l0okX00ol0ojSo
0?nGo`3oU`02o`3oQ@04o`3oLol0of7o0?mQo`3oC`;o0?lm00Co0?l[o`3o6Ol0o`Oo2_l00_lLo`00
2_l^o`3o?ol0ocoo0?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`02oloo0005on7o0?oco`3oooX0
oooX0?ooe`000_oo/`001oooX@3oogd0oom[0?ooF@3oodL0oole0?oo4@001?oo0005ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooolDo`0hoaWo02Ko4Ol05?l@o`02oa;o3`3o:OlQ
0?l;o`l0o`So00;o1_l05?l4o`0Vo`Go03So0ol0B_l4o`1Lo`Co06ko0_l0Ool3o`2Ao`;o0:?o0ol0
]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`?o0?o`00?o0?oNo`3oc?l0ol`00_l0okX00ol0ojSo0?nGo`3o
U`02o`3oQ@04o`3oLol0of7o0?mQo`3oC`;o0?lm00Oo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l0
00;o?ol000KoDOl0of?o0?meo`3oQol0oiWo0?n[o`02okgo000@oloo0?oQo`3olol0oooj0?ooj03o
omL0ooo50?oo/`3ooj40oon?0?ooJ`3ooeT0oom70?oo=@3oob<0oolA00?oo`001Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo5ol0>?lGo`0Voa7o01Co3ol00_lCo`l0obSo8@3o
3?l?0?l8o`02o`Go01Co1Ol09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0_l0TOl3o`2So`;o0;Go
0ol0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj0_l0ojP2o`3oU`05o`3o
QOl0og?o0?mQo`3oHOl0odl00_l0ocd01ol0ob_o0?lIo`3o1ol0o`Oo2_l0oaco0?l^o`000_loo`00
1?mAo`3oHol0ogGo0?n7o`02oiWo000Boj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0
oonc0?ooX@3oohl0oom[0?ooF@3oodL0oole0?oo8`3ooa400ooo0005ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooolIo`0hoaOo02Ko4?l05?l?o`02oa;o3`3o:OlQ0?l;o`l0o`So
00;o1_l05?l4o`0Vo`Co03So1?l0B_l4o`1Lo`?o06ko0ol0Ool3o`2Ao`;o0:?o0_l0]Ol3o`37o`;o
0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc0;o0?nj00?o0?nXo`3oUol0oiL00_l0ohD01?l0og?o
0?mQo`3oHOl0odl2o`3o?@04o`3o:ol0oaWo0?l7o`[o00;o7?l000[o;_l0ocoo0?loo`3oDOl0of?o
0?meo`3oQol0oiWo0?n[o`3o_Ol00_o?o`003_oQo`3olol0oooj0?ooj03oomL0oonc0?ooX@3oohl0
oomm0?ooJ`3ooeT0oom70?oo=@3ooa400ooo0005ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_oooolLo`0hoaGo02Ko3ol05?l@o`02oa;o3`3o:?lQ0?l<o`l0o`Oo00;o1_l05?l4o`0V
o`Go03So0ol0B_l4o`1Lo`Co06ko0_l0Ool3o`2Ao`;o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2o`3m
o`?o0?o`00?o0?oNo`3oc?l0ol`00_l0okX00ol0ojSo0?nGo`3oU`02o`3oQ@04o`3oLol0of7o0?mQ
o`3oC`;o0?lm00?o0?l[o`3o6Ol0o`L00_l:o`002olLo`3o;_l0ocoo0?loo`3oDOl0of?o0?meo`3o
Qol0oiWo0?n[o`3o_Ol000;ocol000GohOl0oo?o0?oonP3oonP0oooG0002oonc0007oon?0?ooO@3o
of/0oomI0?ooA`3oocD0oolA0003ool000Gooooo0Ol00001ooooo`005Oooool2o`0000?ooooo7_l0
>?lEo`0Vo`ko01Co3ol00_lBo`l0obWo8@3o2ol?0?l8o`02o`Go01Co1Ol09_l4o`0ho`Co04[o1?l0
G?l3o`1^o`?o07oo0_l0TOl3o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0
olco0?o<00;o0?nj0_l0ojP2o`3oU`05o`3oQOl0og?o0?mQo`3oHOl0odl00_l0ocd01ol0ob_o0?lI
o`3o1ol0o`Oo2_l0oaco0?l^o`000_loo`001omAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`000_o?
o`001OoQo`3olol0oooj0?ooj03oomL000;ook<000Oooj40oomm0?ooJ`3ooeT0oom70?oo=@3ooa40
00?oo`001?ooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo8?l0>?lDo`0Vo`ko
01Co3ol00_lBo`l0obWo8@3o2ol?0?l7o`02o`Ko01Co1?l09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o
07oo0_l0TOl3o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o
0?nj0_l0ojP2o`3oU`05o`3oQOl0og?o0?mQo`3oHOl0odl00_l0ocd01ol0ob_o0?lIo`3o6Ol0o`Oo
2_l0oaco0?l^o`000_loo`000omAo`3oHol0ogGo0002ohOo000CoiWo0?nmo`3o_Ol0oloo0?oQo`3o
lol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooJ`3ooeT0oom70?oo=@3oob<0oolA0002ool0
00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooob;o03So4ol09_l>o`0Do`oo
00;o4Ol?0?lYob40o`_o3`3o1ol00_l6o`0Do`Co02Ko1Ol0>?l3o`1:o`Co05co1?l0K_l2o`1oo`?o
097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`?o0?go0_l0oo000ol0omko0?o<o`3oc002o`3o^P03
o`3oZ?l0oiOo0?nG00;o0?n500Co0?mco`3oHOl0of7o0?m?0_l0ocd00ol0ob_o0?lIo`3o1`02o`[o
000;oaco0?l^o`3o?ol0ocoo0?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`000_o?o`003_oQo`3o
lol0oooj0?ooj03oomL0oonc0?ooX@3oohl0oomm0?ooJ`3ooeT0oom70?oo=@3ooa400_oo0005oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolSo`0hoa;o02Ko3ol05?l?o`02oa7o
3`3o:OlQ0?l;o`l0o`Oo00;o1_l05?l4o`0Vo`Co03So1?l0B_l4o`1Lo`?o06ko0ol0Ool2o`2Ao`?o
0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00_l0okX2o`3oZ004
o`3oUol0ohGo0?n5o`3oL`;o0?mQ00Go0?m?o`3o?Ol0ocgo0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o
;_l000;o?ol000OoDOl0of?o0?meo`3oQol0oiWo0?n[o`3o_Ol000;ocol000kohOl0oo?o0?oonP3o
onP0oooG0?oo/`3ooj40oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolA00;oo`001Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo9Ol0>?lBo`0Vo`ko01Co3ol00_l@o`l0obWo8@3o
2ol?0?l7o`02o`Ko01Co1?l09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0_l0TOl3o`2So`;o0;Go
0ol0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj0_l0ojP01?l0oiOo0?n5
o`3oQOl0og<2o`3oH@05o`3oCol0ocgo0?lmo`3o:ol0oaT00_l0o`L00ol:o`3o7?l0obko0002ocoo
0007oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0okgo0002oloo000>on7o0?oco`3oooX0oooX0?ooe`3o
olD0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0oole0?oo4@02ool000Gooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02ooooo`Oo04[o8?l0>?lAo`0Vo`ko01Co3ol00_l@o`l0obWo8@3o2ol?
0?l7o`02o`Ko01Co1?l09_l4o`0ho`Co04[o0ol0G?l3o`1^o`?o07oo0ol0TOl2o`2So`?o0;Go0_l0
aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN00Co0?o<o`3o^_l0ok[o0?nj0_l0ojP2o`3oQ@04o`3o
Lol0of7o0?mQo`3oC`;o0?lm00Oo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l000;o?ol000OoDOl0
of?o0?meo`3oMOl0oiWo0?n[o`3o_Ol000;ocol000kohOl0oo?o0?oonP3oonP0oooG0?ooa@3ooj40
oon?0?ooO@3oof/0oomI0?ooA`3oocD0oolA00;oo`001Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo3ol0B_lIo`0hoa7o02Ko3_l05?l>o`02oa7o3`3o:?lQ0?l;o`l0o`Oo00;o
1_l05?l4o`0Vo`Co03So1?l0B_l4o`1Lo`?o06ko0ol0Ool2o`2Ao`?o0:?o0_l0]Ol3o`37o`;o0=Wo
0_l0jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00_l0okX2o`3oZ004o`3oUol0ohGo0?n5o`3oL`;o
0?mQ00Go0?m?o`3o?Ol0ocgo0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o;_l000;o?ol000OoDOl0of?o
0?meo`3oQol0oiWo0?n[o`3o_Ol000;ocol000oohOl0oo?o0?oonP3oonP0oooG0?ooa@3ooj40oon?
0?ooO@3oof/0oomI0?ooA`3oocD0oolA0?oo00001Oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooo5?l0B_lFo`0hoa3o02Ko3_l05?l>o`02oa7o3`3o9olQ0?l;o`l0o`So00;o1Ol0
5?l5o`0Vo`?o03So1?l0B_l4o`1Lo`?o06ko0ol0Ool2o`2Ao`?o0:?o0_l0]Ol3o`37o`;o0=Wo0_l0
jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00_l0okX2o`3oZ004o`3oUol0ohGo0?n5o`3oL`;o0?mQ
00Go0?m?o`3o?Ol0ocgo0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o;_l000;o?ol000OoDOl0of?o0?me
o`3oQol0oiWo0?n[o`3o_Ol000;ocol000oohOl0oo?o0?oonP3oonP0oooG0?ooa@3ooj40oon?0?oo
O@3oof/0oomI0?ooA`3oocD0oolA0?oo00001Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo5ol0B_lEo`0hoa3o02Ko3Ol05?l>o`02oa3o3`3o:?lQ0?l;o`l0o`Oo00;o1_l05?l4
o`0Vo`Co03So1?l0B_l3o`1Lo`?o06ko0ol0Ool3o`2Ao`;o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2
o`3mo`;o0?o`0_l0omh01_l0olco0?njo`3o^_l0ok[o0?nXo`3oU`;o0?n500Co0?mco`3oHOl0of7o
0?m?0_l0ocd01ol0ob_o0?lIo`3o1ol0o`Oo2_l0oaco0?l^o`000_loo`001omAo`3oHol0ogGo0?n7
o`3oVOl0oj_o0?nmo`000_o?o`003ooQo`3olol0oooj0?ooj03oomL0ooo50?ooX@3oohl0oomm0?oo
J`3ooeT0oom70?oo=@3ooa40ool00005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool0
0_oooolIo`1:oaCo03So4?l09_l=o`0Do`ko00;o4?l?0?lWob40o`_o3`3o1ol00_l6o`0Do`Co02Ko
1?l0>?l4o`1:o`Co05co0ol0K_l3o`1oo`;o097o0ol0Xol2o`2eo`?o0<Oo0_l0fOl2o`3[o`;o0?go
0_l0oo000ol0omko0?o<o`3oc002o`3o^P;o0?nX00Co0?nGo`3oQOl0ohGo0?mc0_l0of401Ol0odoo
0?lmo`3o:ol0ob_o0?lI00;o0?l700?o2_l0oaco0?l^o`000_loo`002omAo`3oHol0ogGo0?n7o`3o
VOl0oj_o0?nmo`3ocol0on7o0?oco`3oooX000;oonP000[oolD0oonc0?ooX@3oohl0oomm0?ooJ`3o
oeT0oole0?oo8`3ooa401Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo7?l0
B_lCo`0ho`oo02Ko3Ol05?l=o`02oa7o3`3o9olQ0?l;o`l0o`Oo00;o1_l05?l4o`0Vo`Co03So1?l0
B_l3o`1Lo`?o06ko0ol0Ool2o`2Ao`?o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0
omh00ol0olco0?njo`3o^P02o`3oZ004o`3oUol0ohGo0?n5o`3oL`;o0?mQ00Go0?m?o`3o?Ol0ob_o
0?l[o`3o6@02o`3o1`03o`[o0?lLo`3o;_l000;o?ol000_oDOl0of?o0?meo`3oQol0oiWo0?n[o`3o
_Ol0oloo0?oQo`3olol0oooj0002oooX000:ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?oo=@3o
ob<0oolA00Gooooo0Ol00001ooooo`003Oooool3o`0000Gooooo00?o0000ooooooooool00_oooolN
o`1:oa;o03So3ol09_l=o`0Do`go00;o4Ol?0?lVob40o`_o3`3o1ol00_l6o`0Do`Co02Ko1?l0>?l4
o`1:o`?o05co0ol0K_l3o`1oo`?o097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02
o`3ogP06o`3oc?l0ok[o0?njo`3o^_l0ojSo0?nG0_l0ohD01?l0og?o0?mQo`3oHOl0odl2o`3o?@07
o`3o:ol0oaWo0?l7o`3o1ol:o`3o7?l0obko0002ocoo0007oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0
okgo0002oloo000>on7o0?oco`3oooX0oooX0?ooe`3oolD0oonQ0?ooS`3oogd0oom[0?ooF@3oodL0
oole0?oo4@05ooooo`7o00000Oooool000kooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`02ooooob3o04[o4_l0>?l>o`0Vo`go01Co3Ol00_l@o`l0obKo8@3o2ol?0?l7o`02o`Ko01Co
1?l09_l4o`0ho`Co04[o1?l0G?l3o`1^o`?o07oo0_l0TOl3o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o
0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj0_l0ojP01?l0oiOo0?n5o`3oQOl0og<2o`3oH@05
o`3oCol0ocgo0?l[o`3o:ol0oaT00_l0o`L00ol:o`3o7?l0obko0002ocoo000Foe7o0?mSo`3oMOl0
ohOo0?nIo`3oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oonQ0?ooS`3oogd0
oom[0?ooF@3oocD0oolS00Gooooo0Ol00001ooooo`003_ooool00ol0003oooooooooo`04ooooo`;o
00000ooooolRo`1:oa7o03So3_l09_l=o`0Do`go00;o4?l?0?lVob40o`_o3`3o1ol00_l6o`0Do`Co
02Ko1?l0>?l4o`1:o`?o05co0ol0K_l3o`1oo`?o097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o
0?go0_l0oo02o`3ogP03o`3oc?l0ok[o0?nj00;o0?nX00Co0?nGo`3oQOl0ohGo0?mc0_l0of401Ol0
odoo0?lmo`3o?Ol0ob_o0?lI00;o0?l700?o2_l0oaco0?l^o`000_loo`005_mAo`3oHol0ogGo0?n7
o`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?oo
J`3ooeT0oole0?oo8`04ooooo`;o00000Oooool000kooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`02ooooobCo04[o4?l0>?l=o`0Vo`go01Co3Ol00_l@o`l0obKo8@3o2ol?0?l7o`02
o`Ko01Co1?l09_l4o`0ho`Co04[o0ol0G?l3o`1^o`?o07oo0ol0TOl2o`2So`?o0;Go0_l0aol2o`3I
o`;o0>_o0_l0oOl2o`3ol0;o0?oN00?o0?o<o`3o^_l0okX00_l0ojP01?l0oiOo0?n5o`3oQOl0og<2
o`3oH@05o`3oCol0ocgo0?lmo`3o:ol0oaT00_l0o`L00ol:o`3o7?l0obko0002ocoo000:oe7o0?mS
o`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`3ohOl0oo?o00;oooX000[oomL0ooo50?oo/`3ooj40oon?
0?ooO@3oof/0oomI0?oo=@3oob<01Oooool1o`00007ooooo000>ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool00_ooool7o`1Loako04[o4?l0>?l=o`0Vo`go01Co3Ol00_l@o`l0obKo
8@3o2ol?0?l7o`02o`Go01Co1Ol09_l4o`0ho`Co04[o0ol0G?l3o`1^o`;o07oo0ol0TOl3o`2So`;o
0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`00ol0ok[o0?nXo`3oZ002o`3oU`05
o`3oQOl0og?o0?mco`3oHOl0odl00_l0ocd01ol0ob_o0?lIo`3o1ol0o`Oo2_l0oaco0?l^o`000_lo
o`002?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol00_oQo`003?oco`3oooX0oooG0?ooa@3o
ok<0oonQ0?ooS`3oogd0oom[0?ooF@3oocD0oolS00Gooooo0Ol00001ooooo`003Oooool2o`0000Ko
oooo00?o0000ooooooooool00_ooool>o`1LoaWo04[o4?l0>?l<o`0Vo`go01Co3Ol00_l?o`l0obKo
8@3o2ol?0?l7o`02o`Ko01Co1?l09_l4o`0ho`Co04[o0ol0G?l3o`1^o`?o07oo0ol0TOl2o`2So`?o
0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN00?o0?o<o`3o^_l0okX00_l0ojP01?l0oiOo
0?n5o`3oQOl0og<2o`3oH@05o`3oCol0ocgo0?lmo`3o:ol0oaT00_l0o`L00ol:o`3o7?l0obko0002
ocoo00;oHol001?oMOl0ohOo0?nIo`3oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3o
ok<0oonQ0?ooS`3oogd0oomI0?ooA`3oocD000Gooooo0Ol00001ooooo`003_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00;ooooo4Ol0G?lHo`1:o`oo03So3?l09_l<o`0Do`ko00;o
3ol?0?lVob40o`_o3`3o1_l00_l6o`0Do`Co02Ko1?l0>?l4o`1:o`?o05co0ol0K_l3o`1oo`?o097o
0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<00Co0?njo`3oZ?l0ojSo
0?nG0_l0ohD01?l0og?o0?mQo`3oHOl0odl2o`3o?@07o`3o:ol0oaWo0?l7o`3o1ol:o`3o7?l0obko
0002ocoo000:oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`3ohOl0oo?o00;oooX000WoomL0
ooo50?oo/`3ooj40oon?0?ooO@3oof/0oomI0?oo=@001Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo5?l0G?lFo`1:o`oo03So3?l09_l<o`0Do`go00;o3ol?0?lVob40o`_o3`3o
1ol00_l5o`0Do`Go02Ko1?l0>?l4o`1:o`?o05co0ol0K_l2o`1oo`?o097o0ol0Xol2o`2eo`;o0<Oo
0_l0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL01Ol0ohGo0?mc
o`3oLol0of7o0?m?00;o0?lm00Oo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l000;o?ol000SoDOl0
of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo00;ohOl000_olol0oooj0?ooe`3oolD0oonc0?ooX@3o
ohl0oomm0?ooJ`3ooeT0oole0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
oolGo`1LoaGo04[o3_l0>?l<o`0Vo`co01Co3Ol00_l?o`l0obGo8@3o2ol?0?l7o`02o`Go01Co1Ol0
9_l4o`0ho`Co04[o0ol0G?l3o`1^o`?o07oo0ol0TOl2o`2So`?o0;Go0_l0aol2o`3Io`;o0>_o0_l0
oOl2o`3ol0;o0?oN00?o0?o<o`3o^_l0okX00_l0ojP01_l0oiOo0?n5o`3oQOl0og?o0?mQo`3oC`?o
0?lm00Wo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l0ocoo0?mAo`000_mSo`004_meo`3oQol0oiWo
0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3ooeT0oom7
00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa[o05co4ol0B_l>o`0ho`_o
02Ko3Ol05?l=o`02o`oo3`3o9OlQ0?l;o`l0o`Ko00;o1_l05?l4o`0Vo`Go03So0ol0B_l3o`1Lo`?o
06ko0ol0Ool3o`2Ao`;o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc004
o`3o^_l0ojSo0?nXo`3oU`;o0?n500Co0?mco`3oHOl0odoo0?m?0_l0ocd01ol0ob_o0?lIo`3o1ol0
o`Oo2_l0oaco0?l^o`000_loo`005?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o0?oc
o`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooF@3oodL01Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo7Ol0G?lAo`1:o`ko03So2ol09_l<o`0Do`go00;o3ol?0?lU
ob40o`_o3`3o1ol00_l5o`0Do`Go02Ko1?l0>?l4o`1:o`?o05co0ol0K_l3o`1oo`;o097o0ol0Xol2
o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL0
1Ol0ohGo0?mco`3oLol0of7o0?m?00;o0?lm00Oo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l000;o
?ol000SoDOl0of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo00;ohOl000[oooX0oooX0?ooe`3oolD0
oonc0?ooX@3oohl0oomm0?ooF@3oodL01Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;ooooo8?l0G?l@o`1:o`go03So2ol09_l<o`0Do`go00;o3ol?0?lUob40o`_o3`3o1_l00_l6o`0D
o`Co02Ko1?l0>?l4o`1:o`?o05co0ol0K_l3o`1oo`;o097o0ol0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[
o`;o0?go0_l0oo03o`3ogP04o`3oc?l0ok[o0?nXo`3oZ0;o0?nG00Go0?n5o`3oLol0og?o0?mQo`3o
C`02o`3o?@06o`3o:ol0oaWo0?l7o`3o1ol:o`3o7?l00_l^o`002Oloo`3oDOl0of?o0?meo`3oQol0
oiWo0?n[o`3o_Ol0oloo0002on7o000:oo?o0?oonP3oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/0
oomI00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooob;o05co3ol0B_l=o`0h
o`_o02Ko3?l05?l<o`02o`oo3`3o9OlQ0?l;o`l0o`Ko00;o1_l05?l4o`0Vo`Go03So0ol0B_l3o`1L
o`?o06ko0ol0Ool3o`2Ao`;o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3o
c004o`3o^_l0ojSo0?nXo`3oU`;o0?n500Co0?mco`3oHOl0odoo0?m?0_l0ocd01ol0ob_o0?lIo`3o
1ol0o`Oo2_l0oaco0?l^o`000_loo`004omAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o
0?oco`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0?ooF@001Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo8ol0G?l?o`1:o`go03So2ol09_l<o`0Do`co00;o3ol?0?lU
ob40o`[o3`3o1ol00_l6o`0Do`Co02Ko1?l0>?l4o`1:o`?o05co0ol0K_l3o`1oo`;o097o0ol0Xol2
o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL0
1Ol0ohGo0?mco`3oLol0of7o0?m?00;o0?lm00Oo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l000;o
?ol001?oDOl0of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo5
0?oo/`3ooj40oon?0?ooO@3ooeT000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
ooooo`ko06ko5ol0G?l?o`1:o`co03So2_l09_l<o`0Do`co00;o3ol?0?lUob40o`[o3`3o1ol00_l6
o`0Do`Co02Ko1?l0>?l4o`1:o`?o05co0ol0K_l3o`1oo`;o097o0ol0Xol2o`2eo`;o0<Oo0_l0fOl2
o`3[o`;o0?go0_l0oo02o`3ogP;o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL01Ol0ohGo0?mco`3oLol0
of7o0?m?00;o0?lm00Oo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l000;o?ol001?oDOl0of?o0?me
o`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?oo
O@3ooeT000Gooooo0Ol00001ooooo`005Oooool2o`0000?ooooo4Ol0K_lFo`1Lo`ko04[o3?l0>?l:
o`0Vo`co01Co3?l00_l?o`l0obGo8@3o2_l?0?l7o`02o`Ko01Co1?l09_l4o`0ho`?o04[o0ol0G?l3
o`1^o`?o07oo0ol0TOl2o`2So`?o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol004o`3og_l0olco
0?o<o`3o^P;o0?nX0_l0oiL01Ol0ohGo0?mco`3oLol0of7o0?m?00;o0?lm00Go0?l[o`3o6Ol0o`Oo
0?l7o`[o0002oaco00;o?ol000GoDOl0of?o0?meo`3oQol0oiWo0002oj_o000<okgo0?o?o`3olol0
oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@3oof/01?ooool2o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo5?l0K_lDo`1Lo`oo04[o2ol0>?l:o`0Vo`co01Co3?l00_l?o`l0obCo
8@3o2_l?0?l7o`02o`Ko01Co1?l09_l4o`0ho`Co04[o0ol0G?l3o`1^o`?o07oo0_l0TOl3o`2So`;o
0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol0;o0?oN0_l0ol`00ol0ok[o0?nXo`3oZ002o`3oU`05
o`3oQOl0og?o0?mQo`3oHOl0odl00_l0ocd01ol0ob_o0?lIo`3o1ol0o`Oo2_l0oaco0?l^o`000_lo
o`004_mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`3oooX0oooX0?ooe`3oolD0
oonc0?ooX@3oohl0oom[00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaOo
06ko4ol0G?l>o`1:o`_o03So2_l09_l;o`0Do`co00;o3ol?0?lTob40o`_o3`3o1_l00_l6o`0Do`Co
02Ko1?l0>?l4o`1:o`?o05co0ol0K_l3o`1oo`;o097o0ol0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o
0?go0_l0oo02o`3ogP;o0?o<00?o0?njo`3oZ?l0ojP00_l0oiL01Ol0ohGo0?mco`3oHOl0of7o0?m?
00;o0?lm00Oo0?l[o`3o6Ol0o`Oo0?l7o`[o0?lLo`3o;_l000;o?ol001;oDOl0of?o0?meo`3oQol0
oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3ooj40oon?0?ooO@05oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolIo`1^oa?o05co3Ol0B_l;o`0ho`[o
02Ko2ol05?l<o`02o`oo3`3o9?lQ0?l:o`l0o`Oo00;o1_l05?l4o`0Vo`Co03So0ol0B_l3o`1Lo`?o
06ko0ol0Ool3o`2Ao`;o0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00Co0?oNo`3oc?l0
olco0?nj0_l0ojP2o`3oU`05o`3oQOl0og?o0?mco`3oHOl0odl00_l0ocd01ol0ob_o0?lIo`3o1ol0
o`Oo2_l0oaco0?l^o`000_loo`001OmAo`3oHol0ogGo0?n7o`3oVOl000;oZol000_o_Ol0oloo0?oc
o`3oooX0oooX0?ooe`3oolD0oonc0?ooX@3oohl0oomm0005ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooolLo`1^oa7o05co3Ol0B_l;o`0ho`[o02Ko2ol05?l<o`02o`oo3`3o8olQ
0?l;o`l0o`Ko00;o1_l05?l4o`0Vo`Co03So1?l0B_l3o`1Lo`?o06ko0ol0Ool2o`2Ao`?o0:?o0_l0
]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc003o`3o^_l0ojSo0?nX00;o0?nG0_l0
og<2o`3oH@05o`3oCol0ocgo0?lmo`3o:ol0oaT00_l0o`L01?l:o`3o7?l0obko0?loo`02oe7o000@
of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3oohl0
oomm00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooako06ko4Ol0G?l<o`1:
o`_o03So2_l09_l;o`0Do`co00;o3_l?0?lTob40o`[o3`3o1_l00_l7o`0Do`Co02Ko1?l0>?l3o`1:
o`?o05co0ol0K_l3o`1oo`?o097o0_l0Xol2o`2eo`?o0<Oo0_l0fOl2o`3[o`;o0?go00?o0?o`o`3o
g_l0omh00_l0ol`00ol0ok[o0?nXo`3oZ002o`3oU`05o`3oQOl0og?o0?mco`3oHOl0odl00_l0ocd0
2?l0ob_o0?lIo`3o1ol0o`Oo2_l0oaco0?l^o`3o?ol00_mAo`004?mSo`3oMOl0ohOo0?nIo`3oZol0
okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oon?0?ooO@05ooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_oooolPo`1^oa3o05co3?l0B_l;o`0ho`[o02Ko2_l05?l<o`02
o`ko3`3o9?lQ0?l;o`l0o`Ko00;o1_l05?l4o`0Vo`Co03So0ol0B_l3o`1Lo`?o06ko0ol0Ool3o`2A
o`;o0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00Co0?oNo`3oc?l0olco0?nj0_l0ojP2
o`3oU`05o`3oQOl0og?o0?mco`3oHOl0odl00_l0ocd01ol0ob_o0?lIo`3o1ol0o`Oo2_l0oaco0?l^
o`000_loo`001OmAo`3oHol0ogGo0?n7o`3oVOl000;oZol000[ocol0on7o0?oco`3oooX0oooX0?oo
e`3oolD0oonc0?ooX@3oohl01Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo
1ol0OolKo`1^oa3o05co2ol0B_l;o`0ho`[o02Ko2_l05?l<o`02o`ko3`3o8olQ0?l;o`l0o`Ko00;o
1_l05?l4o`0Vo`Co03So1?l0B_l3o`1Lo`?o06ko0ol0Ool2o`2Ao`?o0:?o0_l0]Ol2o`37o`;o0=Wo
0_l0jol2o`3mo`;o0?o`0_l0omh2o`3oc003o`3o^_l0ojSo0?nX00;o0?nG0_l0og<2o`3oH@05o`3o
Col0ocgo0?lmo`3o:ol0oaT00_l0o`L01?l:o`3o7?l0obko0?loo`02oe7o000?of?o0?meo`3oQol0
oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0ooo50?oo/`3oohl000Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02ooooo`oo07oo5_l0K_l>o`1Lo`_o04[o2ol0>?l:o`0V
o`[o01Co3?l00_l=o`l0obCo8@3o2ol?0?l6o`02o`Ko01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^
o`?o07oo0ol0TOl2o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o0_l0oOl00ol0oo3o0?oNo`3ogP02o`3o
c003o`3o^_l0ojSo0?nX00;o0?nG00Go0?n5o`3oLol0og?o0?mQo`3oC`02o`3o?@08o`3o:ol0oaWo
0?l7o`3o1ol:o`3o7?l0obko0?loo`02oe7o000?of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQ
o`3olol0oooj0?ooj03oomL0ooo50?oo/`3oohl000Gooooo0Ol00001ooooo`005Oooool00ol0003o
ooooooooo`02oooooa?o07oo5?l0K_l<o`1Lo`co04[o2_l0>?l:o`0Vo`[o01Co3?l00_l=o`l0obCo
8@3o2ol?0?l6o`02o`Ko01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^o`?o07oo0ol0TOl2o`2So`;o
0;Go0ol0aol2o`3Io`;o0>_o0_l0oOl00ol0oo3o0?oNo`3ogP02o`3oc003o`3o^_l0ojSo0?nX00;o
0?nG00Go0?n5o`3oLol0og?o0?mQo`3oC`02o`3o?@08o`3o:ol0oaWo0?l7o`3o1ol:o`3o7?l0obko
0?loo`02oe7o000?of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0
ooo50?oo/`3oohl000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaGo07oo
4ol0K_l<o`1Lo`co04[o2_l0>?l:o`0Vo`[o01Co3?l00_l=o`l0obCo8@3o2ol?0?l6o`02o`Go01Co
1Ol09_l4o`0ho`;o04[o1?l0G?l3o`1^o`?o07oo0_l0TOl2o`2So`?o0;Go0_l0aol2o`3Io`;o0>_o
0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Co0?nXo`3oUol0oiOo0?n50_l0og<01_l0of7o
0?m?o`3o?Ol0ocgo0?l[o`3o6@;o0?l700Co2_l0oaco0?l^o`3o?ol00_mAo`000omSo`3oMOl0ohOo
0002oiWo000:okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<0oon?00Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02oooooaOo07oo4_l0K_l<o`1Lo`_o04[o2_l0>?l;o`0V
o`[o01Co2ol00_l=o`l0obCo8@3o2ol?0?l6o`02o`Ko01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^
o`?o07oo0ol0TOl2o`2So`;o0;Go0ol0aol2o`3Io`;o0>_o00?o0?goo`3ol?l0oo000_l0omh2o`3o
c004o`3o^_l0ojSo0?nXo`3oU`;o0?n50_l0og<01ol0of7o0?m?o`3o?Ol0ocgo0?l[o`3o6Ol0o`L0
0_l:o`001_lLo`3o;_l0ocoo0?mAo`3oHol0ogGo00;oQol000_oVOl0oj_o0?nmo`3ocol0on7o0?oc
o`3oooX0oooG0?ooa@3ook<0oonQ0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool0
0_oooolIo`1ooa7o06ko3Ol0G?l:o`1:o`[o03So2_l09_l;o`0Do`[o00;o3_l?0?lSob40o`_o3`3o
1_l00_l6o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0ol0K_l3o`1oo`?o097o0_l0Xol2o`2eo`?o0<Oo
0_l0fOl2o`3[o`;o0?go00?o0?o`o`3og_l0omh00_l0ol`01?l0ok[o0?nXo`3oZ?l0oiL2o`3oQ@;o
0?mc00Oo0?mQo`3oCol0ocgo0?lmo`3o:ol0oaWo0?l700;o2_l000?o7?l0obko0?loo`000_mAo`00
3_mSo`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@3ook<01Ooo
ool1o`00007ooooo000Eooooo`;o00000ooooolLo`1ooa3o06ko3?l0G?l:o`1:o`[o03So2_l09_l:
o`0Do`_o00;o3Ol?0?lTob40o`_o3`3o1_l00_l5o`0Do`Go02Ko1?l0>?l2o`1:o`Co05co0ol0K_l3
o`1oo`;o097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo000ol0omko0?o<o`3oc002
o`3o^P04o`3oZ?l0oiOo0?nGo`3oQ@;o0?mc00Ko0?mQo`3oCol0ocgo0?lmo`3o:ol0oaT2o`3o1`04
o`[o0?lLo`3o;_l0ocoo00;oDOl000koHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`3o
ooX0oooX0?ooe`3oolD0oonc00Cooooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02oooo
oako07oo3ol0K_l<o`1Lo`[o04[o2_l0>?l:o`0Vo`[o01Co2ol00_l=o`l0ob?o8@3o2ol?0?l6o`02
o`Ko01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^o`?o07oo0_l0TOl3o`2So`;o0;Go0ol0aol2o`3I
o`;o0>_o00?o0?goo`3ol?l0oo000_l0omh2o`3oc004o`3o^_l0ojSo0?nGo`3oU`;o0?n50_l0og<0
1ol0of7o0?m?o`3o?Ol0ocgo0?l[o`3o6Ol0o`L00_l:o`001_lLo`3o;_l0ocoo0?mAo`3oHol0ogGo
00;oQol000[oVOl0oj_o0?nmo`3ocol0on7o0?oco`3oooX0oooG0?ooa@3ook<01Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo8?l0Ool?o`1^o`_o05co2_l0B_l:o`0ho`[o02Ko
2Ol05?l;o`02o`ko3`3o8_lQ0?l;o`l0o`Ko00;o1_l05?l4o`0Vo`Co03So0ol0B_l3o`1Lo`?o06ko
0ol0Ool3o`2Ao`;o0:?o0_l0]Ol3o`37o`;o0=Wo0_l0jol2o`3mo`03o`3ol?l0omko0?oN00;o0?o<
00Co0?njo`3oZ?l0ojSo0?nG0_l0ohD2o`3oL`07o`3oHOl0odoo0?lmo`3o?Ol0ob_o0?lIo`3o1`02
o`[o0006oaco0?l^o`3o?ol0oe7o0?mSo`3oMOl00_n7o`002_nIo`3oZol0okgo0?o?o`3ohOl0oo?o
0?oonP3oomL0ooo50?oo/`05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool7
o`2Aoa_o07oo3_l0K_l;o`1Lo`[o04[o2Ol0>?l:o`0Vo`[o01Co2ol00_l=o`l0ob?o8@3o2ol?0?l6
o`02o`Go01Co1Ol09_l4o`0ho`;o04[o1?l0G?l3o`1^o`?o07oo0_l0TOl2o`2So`?o0;Go0_l0aol2
o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Co0?nXo`3oUol0oiOo0?n50_l0
og<01ol0of7o0?m?o`3o?Ol0ocgo0?l[o`3o6Ol0o`L00_l:o`001_lLo`3o;_l0ocoo0?mAo`3oHol0
ogGo00;oQol000[oVOl0oj_o0?nmo`3ocol0on7o0?oco`3oooX0oooG0?ooa@3ook<01Oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;ooooo3_l0TOlFo`1oo`go06ko2ol0G?l:o`1:o`Wo
03So2_l09_l:o`0Do`[o00;o3_l?0?lRob40o`_o3`3o1_l00_l5o`0Do`Go02Ko1?l0>?l3o`1:o`?o
05co0ol0K_l3o`1oo`;o097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo000ol0omko
0?o<o`3oc002o`3o^P04o`3oZ?l0oiOo0?nGo`3oQ@;o0?mc00Oo0?mQo`3oCol0ocgo0?lmo`3o:ol0
oaWo0?l700;o2_l000?o7?l0obko0?loo`000_mAo`003OmSo`3oMOl0ohOo0?nIo`3oZol0okgo0?o?
o`3ohOl0oo?o0?oonP3oonP0oooG0?ooa@001Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo4Ol0TOlEo`1oo`go06ko2_l0G?l:o`1:o`Wo03So2_l09_l9o`0Do`_o00;o3Ol?0?lR
ob40o`_o3`3o1_l00_l6o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0ol0K_l3o`1oo`?o097o0_l0Xol2
o`2eo`?o0<Oo0_l0fOl2o`3[o`;o0?go00?o0?o`o`3og_l0omh00_l0ol`01?l0ok[o0?nXo`3oZ?l0
oiL2o`3oQ@;o0?mc00Oo0?mQo`3oCol0ocgo0?lmo`3o:ol0oaWo0?l700;o2_l000Ko7?l0obko0?lo
o`3oDOl0of?o0?meo`02ohOo0009oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooe`3oolD000Go
oooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaCo097o5?l0Ool<o`1^o`[o05co
2_l0B_l9o`0ho`[o02Ko2Ol05?l;o`02o`go3`3o8_lQ0?l;o`l0o`Ko00;o1Ol05?l5o`0Vo`Co03So
0ol0B_l3o`1Lo`?o06ko0ol0Ool2o`2Ao`;o0:?o0ol0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`
00?o0?oNo`3oc?l0ol`00_l0okX01?l0ojSo0?nGo`3oUol0ohD2o`3oL`07o`3oHOl0odoo0?lmo`3o
?Ol0ob_o0?lIo`3o1`02o`[o0006oaco0?l^o`3o?ol0oe7o0?mSo`3oMOl00_n7o`002OnIo`3oZol0
okgo0?o?o`3ohOl0oo?o0?oonP3oomL0ooo50005ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_oooolIo`2Aoa3o07oo3?l0K_l;o`1Lo`So04[o2Ol0>?l:o`0Vo`Wo01Co2ol00_l=o`l0
ob;o8@3o2ol?0?l6o`02o`Go01Co1Ol09_l4o`0ho`?o04[o0ol0G?l3o`1^o`?o07oo0_l0TOl2o`2S
o`?o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Co0?nXo`3o
Uol0oiOo0?n50_l0og<01ol0of7o0?m?o`3o?Ol0ocgo0?l[o`3o6Ol0o`L00_l:o`001OlLo`3o;_l0
ocoo0?mAo`3oHol000;oMOl000[oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooe`3oolD0
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo6ol0TOl?o`1oo`go06ko2Ol0
G?l9o`1:o`Wo03So2_l09_l9o`0Do`_o00;o3Ol?0?lRob40o`[o3`3o1ol00_l5o`0Do`Co02Ko1?l0
>?l3o`1:o`Co05co0_l0K_l3o`1oo`;o097o0ol0Xol2o`2eo`;o0<Oo0ol0fOl00ol0jooo0?goo`3m
o`02o`3ol003o`3og_l0olco0?o<00;o0?nj00Co0?nXo`3oUol0oiOo0?n50_l0og<01ol0of7o0?m?
o`3o?Ol0ocgo0?l[o`3o6Ol0o`L00_l:o`000olLo`3o;_l0ocoo0002oe7o000<of?o0?meo`3oQol0
oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooe`3oolD01Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo7_l0TOl>o`1oo`co06ko2Ol0G?l9o`1:o`Wo03So2_l09_l9o`0Do`[o
00;o3_l?0?lRob40o`[o3`3o1_l00_l5o`0Do`Go02Ko1?l0>?l3o`1:o`?o05co0ol0K_l3o`1oo`;o
097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo001?l0omko0?o<o`3oc?l0okX2o`3o
Z0;o0?nG00Go0?n5o`3oLol0of7o0?mQo`3oC`02o`3o?@03o`3o:ol0oaWo0?l700;o2_l0013o7?l0
obko0?loo`3oDOl0of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj03oomL0
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo8?l0TOl=o`1oo`co06ko2Ol0
G?l8o`1:o`[o03So2_l09_l8o`0Do`_o00;o3Ol?0?lRob40o`[o3`3o1_l00_l6o`0Do`Co02Ko1?l0
>?l3o`1:o`?o05co0ol0K_l3o`1oo`;o097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0
oo001?l0omko0?o<o`3oc?l0okX2o`3oZ0;o0?nG00Go0?n5o`3oLol0og?o0?mQo`3oC`02o`3o?@03
o`3o:ol0oaWo0?l700;o2_l000Go7?l0obko0?loo`3oDOl0of?o0002ogGo0009ohOo0?nIo`3oZol0
okgo0?o?o`3ohOl0oo?o0?oonP3oomL000Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooo`Oo0:?o6ol0TOl<o`1oo`co06ko2Ol0G?l8o`1:o`[o03So2Ol09_l9o`0Do`[o00;o3_l?
0?lRob40o`Wo3`3o1ol00_l5o`0Do`Co02Ko1?l0>?l3o`1:o`Co05co0_l0K_l3o`1oo`;o097o0ol0
Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo000ol0omko0?o<o`3oc002o`3o^P04o`3oZ?l0
oiOo0?nGo`3oQ@;o0?mc00Oo0?mQo`3oCol0ocgo0?lmo`3o:ol0oaWo0?l700;o2_l000?o7?l0obko
0?loo`000_mAo`002omSo`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`3ohOl0oo?o0?oonP3oomL000Go
oooo0Ol00001ooooo`005Oooool2o`0000?ooooo3_l0XolFo`2Ao`co07oo2ol0K_l9o`1Lo`So04[o
2Ol0>?l:o`0Vo`So01Co2ol00_l>o`l0ob7o8@3o2Ol?0?l7o`02o`Go01Co1Ol09_l3o`0ho`Co04[o
0ol0G?l3o`1^o`;o07oo0ol0TOl2o`2So`?o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol004o`3o
g_l0olco0?njo`3o^P;o0?nX0_l0oiL01_l0ohGo0?mco`3oHOl0of7o0?m?o`3o?@;o0?l[01?o0?lI
o`3o1ol:o`3o2_l0oaco0?l^o`3o?ol0oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`3ohOl0
oo?o0?oonP3oonP000Cooooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02oooooa7o0:?o
5?l0TOl<o`1oo`_o06ko2Ol0G?l8o`1:o`Wo03So2_l09_l8o`0Do`_o00;o3Ol?0?lRob40o`Wo3`3o
1_l00_l6o`0Do`Co02Ko0ol0>?l4o`1:o`?o05co0ol0K_l3o`1oo`;o097o0_l0Xol3o`2eo`;o0<Oo
0_l0fOl2o`3[o`;o0?go0_l0oo001?l0omko0?o<o`3o^_l0okX2o`3oZ0;o0?nG00Go0?n5o`3oLol0
of7o0?mQo`3oC`02o`3o?@03o`3o:ol0oaWo0?l700;o2_l000oo7?l0obko0?loo`3oDOl0of?o0?me
o`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj0?ooj0001Oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;ooooo5?l0XolCo`2Ao`co07oo2_l0K_l9o`1Lo`So04[o2Ol0>?l9o`0V
o`Wo01Co2_l00_l>o`l0ob7o8@3o2Ol?0?l7o`02o`Go01Co1?l09_l4o`0ho`?o04[o1?l0G?l2o`1^
o`?o07oo0_l0TOl3o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<
00;o0?nj00Go0?nXo`3oUol0oiOo0?n5o`3oL`02o`3oH@06o`3oCol0ocgo0?lmo`3o:ol0oaWo0?l7
0_l:o`000olLo`3o;_l0ocoo0002oe7o000:ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`3o
ooX0oooX00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaOo0:?o4_l0TOl;
o`1oo`[o06ko2Ol0G?l8o`1:o`So03So2_l09_l8o`0Do`_o00;o3Ol?0?lRob40o`Wo3`3o1_l00_l5
o`0Do`Co02Ko1?l0>?l3o`1:o`Co05co0_l0K_l3o`1oo`;o097o0ol0Xol2o`2eo`?o0<Oo00?o0=Wo
o`3[ool0jol00_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Co0?nXo`3oUol0oiOo0?n50_l0
og<01ol0of7o0?m?o`3oCol0ocgo0?l[o`3o6Ol0o`L00_l:o`000olLo`3o;_l0ocoo0002oe7o000:
of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj00Gooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02oooooa[o0:?o4?l0TOl;o`1oo`[o06ko2Ol0G?l8o`1:o`So03So2Ol0
9_l9o`0Do`[o00;o3Ol?0?lRob40o`Wo3`3o1_l00_l6o`0Do`Co02Ko0ol0>?l4o`1:o`?o05co0ol0
K_l3o`1oo`;o097o0_l0Xol3o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo001?l0omko0?o<o`3o
^_l0okX2o`3oZ0;o0?nG00Go0?n5o`3oLol0of7o0?mQo`3oC`02o`3o?@03o`3o:ol0oaWo0?l700;o
2_l000ko7?l0obko0?loo`3oDOl0of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`3olol0oooj
00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooago0:?o3_l0TOl;o`1oo`[o
06ko2Ol0G?l8o`1:o`So03So2Ol09_l9o`0Do`[o00;o3Ol?0?lRob40o`Wo3`3o1_l00_l5o`0Do`Co
02Ko1?l0>?l3o`1:o`Co05co0_l0K_l3o`1oo`;o097o0ol0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o
0?go0_l0oo000ol0omko0?o<o`3oc002o`3o^P05o`3oZ?l0oiOo0?nGo`3oQOl0og<00_l0of401_l0
odoo0?lmo`3o?Ol0ob_o0?lIo`3o1`;o2_l000ko7?l0obko0?loo`3oDOl0of?o0?meo`3oQol0oiWo
0?n[o`3o_Ol0oloo0?oQo`3olol0oooj00Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooo`Oo0;Go6Ol0Xol=o`2Ao`_o07oo2?l0K_l9o`1Lo`So04[o2?l0>?l9o`0Vo`Wo01Co2_l0
0_l=o`l0ob;o8@3o2Ol?0?l6o`02o`Go01Co1?l09_l4o`0ho`?o04[o1?l0G?l2o`1^o`?o07oo0_l0
TOl3o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Go
0?nXo`3oUol0oiOo0?n5o`3oL`02o`3oH@06o`3oCol0ocgo0?lmo`3o:ol0oaWo0?l70_l:o`003_lL
o`3o;_l0ocoo0?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`3oooX01Oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo3_l0]OlDo`2So`co097o2ol0Ool8o`1^
o`Wo05co2?l0B_l8o`0ho`Wo02Ko2Ol05?l:o`02o`go3`3o8OlQ0?l:o`l0o`Ko00;o1Ol05?l4o`0V
o`Co03So0ol0B_l3o`1Lo`?o06ko0_l0Ool3o`2Ao`;o0:?o0ol0]Ol00ol0aooo0=Woo`3Io`02o`3[
o`;o0?go0_l0oo02o`3ogP04o`3oc?l0ok[o0?njo`3oZ0;o0?nG00Go0?n5o`3oLol0og?o0?mQo`3o
C`02o`3o?@03o`3o:ol0oaWo0?l700;o2_l000ko7?l0obko0?loo`3o?ol0of?o0?meo`3oQol0oiWo
0?n[o`3o_Ol0oloo0?oQo`3olol0oooj00Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02oooooa7o0;Go4ol0Xol<o`2Ao`[o07oo2?l0K_l8o`1Lo`Wo04[o2?l0>?l9o`0Vo`Wo01Co2_l0
0_l<o`l0ob;o8@3o2Ol?0?l6o`02o`Go01Co1?l09_l4o`0ho`?o04[o1?l0G?l2o`1^o`?o07oo0_l0
TOl3o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Go
0?nXo`3oUol0oiOo0?n5o`3oL`02o`3oH@06o`3oCol0ocgo0?lmo`3o:ol0oaWo0?l70_l:o`003OlL
o`3o;_l0ocoo0?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`001Oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5?l0]OlAo`2So`co097o2_l0Ool8o`1^o`So
05co2Ol0B_l8o`0ho`So02Ko2Ol05?l:o`02o`go3`3o8OlQ0?l9o`l0o`Ko00;o1Ol05?l4o`0Vo`Co
03So0ol0B_l4o`1Lo`?o06ko0_l0Ool2o`2Ao`?o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o
0?o`00?o0?oNo`3oc?l0ol`00_l0okX01Ol0ojSo0?nGo`3oUol0ohGo0?mc00;o0?mQ00Ko0?m?o`3o
?Ol0ocgo0?l[o`3o6Ol0o`L2o`[o000=oaco0?l^o`3o?ol0oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0
okgo0?o?o`3ohOl0oo?o0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolG
o`2eoa3o0:?o2ol0TOl:o`1oo`So06ko2?l0G?l9o`1:o`So03So2?l09_l9o`0Do`[o00;o3?l?0?lQ
ob40o`[o3`3o1_l00_l5o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0ol0K_l2o`1oo`?o097o0_l0Xol3
o`2eo`03o`37ool0fOoo0=Wo00;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Co0?nX
o`3oUol0oiOo0?n50_l0og<01ol0of7o0?m?o`3o?Ol0ocgo0?l[o`3o6Ol0o`L00_l:o`003OlLo`3o
;_l0ocoo0?loo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3ocol0on7o0?oco`001Oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo6Ol0]Ol@o`2So`_o097o2Ol0Ool8o`1^o`So05co
2?l0B_l8o`0ho`Wo02Ko2?l05?l:o`02o`go3`3o8OlQ0?l9o`l0o`Ko00;o1Ol05?l4o`0Vo`Co03So
0ol0B_l4o`1Lo`;o06ko0ol0Ool2o`2Ao`?o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`03o`3o
l?l0omko0?oN00;o0?o<0_l0okX01Ol0ojSo0?nGo`3oUol0ohGo0?mc00;o0?mQ00So0?m?o`3o?Ol0
ob_o0?l[o`3o6Ol0o`Oo2_l0oaco00;o;_l000[o?ol0oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0okgo
0?o?o`3ohOl01Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo7?l0]Ol>o`2S
o`_o097o2Ol0Ool8o`1^o`So05co2?l0B_l8o`0ho`Wo02Ko2?l05?l:o`02o`co3`3o8OlQ0?l:o`l0
o`Ko00;o1Ol05?l3o`0Vo`Go03So0ol0B_l3o`1Lo`?o06ko0_l0Ool3o`2Ao`;o0:?o0_l0]Ol2o`37
o`;o0=Wo0_l0jol2o`3mo`03o`3ol?l0omko0?oN00;o0?o<0_l0okX01Ol0ojSo0?nGo`3oUol0ohGo
0?mc00;o0?mQ00So0?m?o`3o?Ol0ob_o0?l[o`3o6Ol0o`Oo2_l0oaco00;o;_l000[o?ol0oe7o0?mS
o`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`3ohOl01Oooool1o`00007ooooo000Eooooo`;o00000ooo
oolNo`2eo`ko0:?o2ol0TOl8o`1oo`So06ko2?l0G?l8o`1:o`So03So2?l09_l9o`0Do`[o00;o3?l?
0?lPob40o`[o3`3o1_l00_l5o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0ol0K_l2o`1oo`?o097o0_l0
Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo000ol0omko0?o<o`3oc002o`3o^P04o`3oZ?l0
oiOo0?nGo`3oQ@;o0?mc00Oo0?mQo`3oCol0ocgo0?lmo`3o:ol0oaWo0?l700;o2_l000co7?l0obko
0?loo`3oDOl0of?o0?meo`3oQol0oiWo0?n[o`3o_Ol0oloo0?oQo`04ooooo`;o00000Oooool001Go
oooo00?o0000ooooooooool00_ooool7o`37oaWo0;Go3_l0Xol:o`2Ao`So07oo2?l0K_l8o`1Lo`So
04[o2?l0>?l8o`0Vo`So01Co2_l00_l<o`l0ob7o8@3o2Ol?0?l6o`02o`Go01Co1?l09_l4o`0ho`?o
04[o1?l0G?l2o`1^o`?o07oo0_l0TOl3o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl00ol0oo3o
0?oNo`3ogP02o`3oc0;o0?nj00Go0?nXo`3oUol0oiOo0?n5o`3oL`02o`3oH@08o`3oCol0ocgo0?l[
o`3o:ol0oaWo0?l7o`[o0?lLo`02obko0009ocoo0?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`3o
col000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa3o0<Oo4ol0]Ol<o`2S
o`[o097o2?l0Ool8o`1^o`So05co2?l0B_l8o`0ho`So02Ko2?l05?l:o`02o`co3`3o8?lQ0?l:o`l0
o`Ko00;o1Ol05?l4o`0Vo`Co03So0ol0B_l3o`1Lo`?o06ko0_l0Ool3o`2Ao`;o0:?o0_l0]Ol2o`37
o`;o0=Wo0_l0jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00_l0okX01Ol0ojSo0?nGo`3oUol0ohGo
0?mc00;o0?mQ00So0?m?o`3o?Ol0ob_o0?l[o`3o6Ol0o`Oo2_l0oaco00;o;_l000Wo?ol0oe7o0?mS
o`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo5Ol0aol@o`2eo`co0:?o2Ol0TOl7o`1oo`Wo06ko1ol0G?l8o`1:o`So03So2?l09_l8
o`0Do`[o00;o3?l?0?lPob40o`[o3`3o1_l00_l5o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0ol0K_l2
o`1oo`?o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo000ol0omko0?o<o`3oc002
o`3o^P05o`3oZ?l0oiOo0?nGo`3oQOl0og<00_l0of401ol0odoo0?lmo`3o:ol0ob_o0?lIo`3o1ol:
o`000_lLo`002_l^o`3o?ol0oe7o0?mSo`3oMOl0ohOo0?nIo`3oZol0okgo0?o?o`05ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooolGo`37o`oo0;Go3?l0Xol9o`2Ao`Oo07oo2?l0
K_l8o`1Lo`So04[o2?l0>?l8o`0Vo`So01Co2_l00_l<o`l0ob3o8@3o2Ol?0?l7o`02o`Co01Co1?l0
9_l4o`0ho`?o04[o0ol0G?l3o`1^o`?o07oo0_l0TOl3o`2So`03o`2eool0aooo0<Oo00;o0=Wo0_l0
jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00_l0okX01Ol0ojSo0?nGo`3oUol0ohGo0?mc00;o0?mQ
00Ko0?m?o`3o?Ol0ob_o0?l[o`3o6Ol0o`L2o`[o000;oaco0?l^o`3o?ol0oe7o0?mSo`3oMOl0ohOo
0?nIo`3oZol0okgo0?o?o`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo
6Ol0aol?o`2eo`_o0:?o2Ol0TOl7o`1oo`So06ko2?l0G?l8o`1:o`Oo03So2?l09_l8o`0Do`[o00;o
3?l?0?lPob40o`[o3`3o1_l00_l5o`0Do`Co02Ko1?l0>?l3o`1:o`;o05co1?l0K_l2o`1oo`?o097o
0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo000ol0omko0?o<o`3oc002o`3o^P05o`3o
Z?l0oiOo0?nGo`3oQOl0og<00_l0of400ol0odoo0?lmo`3o:`02o`3o6@05o`3o1ol:o`3o7?l0obko
0?loo`000_mAo`001_mSo`3oMOl0ohOo0?nIo`3oZol0okgo00Gooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02oooooaco0<Oo3Ol0]Ol;o`2So`Wo097o1ol0Ool8o`1^o`So05co1ol0B_l8
o`0ho`Oo02Ko2Ol05?l:o`02o`co3`3o7olQ0?l:o`l0o`Ko00;o1Ol05?l4o`0Vo`Co03So0ol0B_l3
o`1Lo`?o06ko0_l0Ool3o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00?o0?oN
o`3oc?l0ol`00_l0okX01Ol0ojSo0?nGo`3oUol0ohGo0?mc00;o0?mQ00Oo0?m?o`3o?Ol0ob_o0?l[
o`3o6Ol0o`Oo2_l000;o7?l000Wo;_l0ocoo0?mAo`3oHol0ogGo0?n7o`3oVOl0oj_o0?nmo`001Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo7_l0aol<o`2eo`_o0:?o2Ol0TOl7
o`1oo`So06ko2?l0G?l7o`1:o`Oo03So2?l09_l9o`0Do`Wo00;o3?l?0?lPob40o`Wo3`3o1ol00_l4
o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0ol0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2
o`3[o`;o0?go0_l0oo000ol0omko0?o<o`3oc002o`3o^P05o`3oZ?l0oiOo0?nGo`3oQOl0og<00_l0
of401_l0odoo0?lmo`3o:ol0ob_o0?lIo`3o1`;o2_l000[o7?l0obko0?loo`3oDOl0of?o0?meo`3o
Qol0oiWo0?n[o`3o_Ol01Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo1ol0
fOlIo`37o`co0;Go2ol0Xol8o`2Ao`Oo07oo2?l0K_l7o`1Lo`So04[o1ol0>?l8o`0Vo`So01Co2_l0
0_l;o`l0ob3o8@3o2_l?0?l6o`02o`Go01Co1?l09_l4o`0ho`?o04[o0_l0G?l4o`1^o`;o07oo0ol0
TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o00Go0?goo`3ol?l0oo3o0?o`o`3ogP02o`3oc0;o0?nj
00?o0?nXo`3oUol0ohD00_l0og<2o`3oH@03o`3oCol0ocgo0?l[00;o0?lI00Go0?l7o`[o0?lLo`3o
;_l0ocoo0002oe7o0005of?o0?meo`3oQol0oiWo0?nmo`001Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo3ol0fOlCo`37o`_o0;Go2ol0Xol8o`2Ao`Oo07oo1ol0K_l8o`1Lo`So
04[o1ol0>?l7o`0Vo`Wo01Co2Ol00_l<o`l0oaoo8@3o2_l?0?l6o`02o`Go01Co1?l09_l4o`0ho`?o
04[o0ol0G?l3o`1^o`;o07oo0ol0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003
o`3og_l0olco0?o<00;o0?nj00Go0?nXo`3oUol0ohGo0?n5o`3oL`02o`3oH@03o`3oCol0ocgo0?l[
00;o0?lI00Go0?l7o`[o0?lLo`3o;_l0ocoo0002oe7o0005of?o0?meo`3oQol0oiWo0?nmo`001Ooo
ool1o`00007ooooo00001?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00;ooooo0ol0
0005ooooo`03o`000?oooooooooo00;ooooo5?l0fOl@o`37o`_o0;Go2_l0Xol7o`2Ao`So07oo1ol0
K_l8o`1Lo`Oo04[o1ol0>?l8o`0Vo`So01Co2_l00_l;o`l0ob3o8@3o2Ol?0?l7o`02o`Co01Co1?l0
9_l4o`0ho`?o04[o0ol0G?l3o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0
oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Go0?nXo`3oUol0oiOo0?n5o`3oL`02o`3oH@03o`3o
Col0ocgo0?l[00;o0?lI00Go0?l7o`[o0?lLo`3o;_l0ocoo0002oe7o0005of?o0?meo`3oQol0oiWo
0?n[o`001Oooool1o`00007ooooo0002ooooo`03o`000?oooooooooo00Oooooo00Go0000oooooooo
ooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo5ol0fOl?o`37o`[o0;Go2_l0Xol7o`2A
o`So07oo1ol0K_l7o`1Lo`So04[o1ol0>?l7o`0Vo`Wo01Co2Ol00_l<o`l0oaoo8@3o2Ol?0?l7o`02
o`Co01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3I
o`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Go0?nXo`3oUol0oiOo0?n5o`3oL`02
o`3oH@05o`3oCol0ocgo0?l[o`3o:ol0oaT00_l0o`L02_l:o`3o7?l0obko0?loo`3oDOl0of?o0?me
o`3oQol0oiWo0?n[o`05ooooo`7o00000Oooool000;ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo6_l0fOl=o`37o`_o0;Go2Ol0Xol7o`2A
o`So07oo1ol0K_l7o`1Lo`So04[o1_l0>?l8o`0Vo`So01Co2_l00_l;o`l0oaoo8@3o2_l?0?l6o`02
o`Go01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0ol0TOl2o`2So`;o0;Go0_l0aol2o`3I
o`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Go0?nXo`3oUol0ohGo0?n5o`3oL`02
o`3oH@03o`3oCol0ocgo0?l[00;o0?lI00Go0?l7o`[o0?lLo`3o;_l0ocoo0002oe7o0004of?o0?me
o`3oQol0oiWo00Gooooo0Ol00001ooooo`000_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00;ooooo0_l00003oooooaco0=Wo3Ol0aol:o`2eo`Wo0:?o1ol0TOl8o`1oo`Oo06ko1ol0
G?l7o`1:o`Oo03So2?l09_l8o`0Do`Wo00;o3?l?0?lOob40o`Wo3`3o1ol00_l4o`0Do`Co02Ko1?l0
>?l3o`1:o`?o05co0ol0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0
oo000ol0omko0?o<o`3oc002o`3o^P05o`3oZ?l0oiOo0?n5o`3oQOl0og<00_l0of400ol0odoo0?lm
o`3o:`02o`3o6@05o`3o1ol:o`3o7?l0obko0?loo`000_mAo`001?mSo`3oMOl0ohOo0?nIo`04oooo
o`;o00000Oooool000;ooooo00?o0000ooooooooool01oooool4o`0000Gooooo00?o0000oooooooo
ool00_ooool7o`3[oaOo0=Wo3?l0aol:o`2eo`Wo0:?o1_l0TOl8o`1oo`Oo06ko1ol0G?l7o`1:o`Oo
03So2?l09_l8o`0Do`Wo00;o3?l?0?lOob40o`Wo3`3o1ol00_l4o`0Do`Co02Ko1?l0>?l3o`1:o`?o
05co0ol0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo000ol0omko
0?o<o`3oc002o`3o^P05o`3oZ?l0oiOo0?n5o`3oQOl0og<00_l0of400ol0odoo0?lmo`3o:`02o`3o
6@05o`3o1ol:o`3o7?l0obko0?loo`000_mAo`001?mSo`3oMOl0ohOo0?nIo`05ooooo`7o00000Ooo
ool00003ooooool0003o000000Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02
ooooo`ko0>_o4_l0fOl<o`37o`Wo0;Go2Ol0Xol6o`2Ao`So07oo1ol0K_l7o`1Lo`Oo04[o1ol0>?l8
o`0Vo`So01Co2Ol00_l<o`l0oaoo8@3o2Ol?0?l6o`02o`Co01Co1Ol09_l3o`0ho`Co04[o0ol0G?l2
o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco
0?o<00;o0?nj00Go0?nXo`3oUol0ohGo0?n5o`3oL`02o`3oH@0:o`3oCol0ocgo0?l[o`3o:ol0oaWo
0?l7o`[o0?lLo`3o;_l0ocoo00;oDOl000CoHol0ogGo0?n7o`3oVOl01Oooool1o`00007ooooo0002
ooooo`03o`000?oooooooooo00Oooooo1Ol00004ooooo`03o`000?oooooooooo00;ooooo4Ol0jolA
o`3Io`_o0<Oo2_l0]Ol8o`2So`Ko097o2?l0Ool7o`1^o`Oo05co1ol0B_l7o`0ho`Oo02Ko2?l05?l9
o`02o`co3`3o7olQ0?l9o`l0o`Oo00;o1?l05?l4o`0Vo`Co03So0ol0B_l3o`1Lo`?o06ko0ol0Ool2
o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo00Co0>_oo`3mool0oOoo0?go0_l0oo000ol0omko0?o<o`3o
c002o`3o^P06o`3oZ?l0oiOo0?n5o`3oQOl0og?o0?mQ0_l0odl02ol0ocgo0?l[o`3o6Ol0oaWo0?l7
o`[o0?lLo`3o;_l0ocoo0?mAo`3oHol000;oMOl000?oVOl0ooooooooool00oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;ooooo5?l0jol@o`3Io`[o0<Oo2_l0]Ol8o`2So`Ko097o2?l0
Ool7o`1^o`Oo05co1_l0B_l7o`0ho`So02Ko2?l05?l9o`02o`_o3`3o7olQ0?l:o`l0o`Ko00;o1?l0
5?l4o`0Vo`Co03So0ol0B_l3o`1Lo`?o06ko0ol0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0
jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00_l0okX01Ol0ojSo0?nGo`3oQOl0ohGo0?mc00;o0?mQ
00?o0?m?o`3o?Ol0ob/00_l0oaT01Ol0o`Oo2_l0oaco0?l^o`3o?ol000;oDOl000?oHol0ogGo0?n7
o`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5ol0jol>o`3Io`_o0<Oo
2Ol0]Ol7o`2So`Oo097o2?l0Ool6o`1^o`So05co1_l0B_l7o`0ho`Oo02Ko2?l05?l9o`02o`co3`3o
7olQ0?l9o`l0o`Ko00;o1?l05?l5o`0Vo`?o03So1?l0B_l3o`1Lo`;o06ko0ol0Ool2o`2Ao`;o0:?o
0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00?o0?oNo`3oc?l0ol`00_l0okX01Ol0ojSo0?nG
o`3oQOl0ohGo0?mc00;o0?mQ00[o0?m?o`3o?Ol0ob_o0?l[o`3o6Ol0o`Oo2_l0oaco0?l^o`3o?ol0
0_mAo`000omSo`3oMOl0ohOo0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
oolIo`3[o`ko0=Wo2_l0aol9o`2eo`Oo0:?o1ol0TOl8o`1oo`Ko06ko1ol0G?l7o`1:o`Ko03So2?l0
9_l8o`0Do`Wo00;o2ol?0?lOob40o`Wo3`3o1ol00_l4o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0ol0
K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl01?l0jooo0?goo`3mool0oOl2o`3ol005o`3o
g_l0olco0?o<o`3o^_l0ojP00_l0oiL2o`3oQ@07o`3oLol0of7o0?m?o`3oCol0ocgo0?l[o`3o6@02
o`3o1`08o`[o0?lLo`3o;_l0ocoo0?mAo`3oHol0ogGo0?n7o`05ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_oooolLo`3[o`go0=Wo2_l0aol8o`2eo`Oo0:?o1ol0TOl7o`1oo`Oo06ko
1ol0G?l6o`1:o`Oo03So2?l09_l8o`0Do`So00;o2ol?0?lOob40o`[o3`3o1_l00_l4o`0Do`Co02Ko
1?l0>?l3o`1:o`?o05co0ol0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go
0_l0oo001?l0omko0?o<o`3oc?l0okX2o`3oZ005o`3oUol0ohGo0?n5o`3oLol0of400_l0odl00ol0
ocgo0?l[o`3o6@02o`3o1`08o`[o0?lLo`3o;_l0ocoo0?mAo`3oHol0ogGo0?n7o`05ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_ooool7o`3moaOo0>_o3?l0fOl:o`37o`So0;Go1ol0
Xol7o`2Ao`Oo07oo1ol0K_l7o`1Lo`Ko04[o1ol0>?l7o`0Vo`So01Co2?l00_l<o`l0oaoo8@3o2Ol?
0?l6o`02o`Go01Co1?l09_l3o`0ho`Co04[o0ol0G?l2o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0
aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Ko0?nXo`3oUol0ohGo0?n5
o`3oLol0of42o`3oC`0;o`3o?Ol0ob_o0?l[o`3o6Ol0o`Oo2_l0oaco0?l^o`3o?ol0oe7o0?mSo`00
0_meo`05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool>o`3moa;o0>_o3?l0
fOl9o`37o`So0;Go1ol0Xol7o`2Ao`Oo07oo1_l0K_l8o`1Lo`Go04[o1ol0>?l8o`0Vo`So01Co2?l0
0_l;o`l0oaoo8@3o2Ol?0?l6o`02o`Go01Co1?l09_l4o`0ho`?o04[o0ol0G?l2o`1^o`?o07oo0_l0
TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol003o`3og_l0olco0?o<00;o0?nj00Go
0?nXo`3oUol0ohGo0?n5o`3oL`02o`3oH@0:o`3oCol0ocgo0?l[o`3o:ol0oaWo0?l7o`[o0?lLo`3o
;_l0ocoo00;oDOl000?oHol0ogGo0?ooool01?ooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo4Ol0oOlAo`3[o`_o0=Wo2Ol0aol8o`2eo`Oo0:?o1ol0TOl7o`1oo`Ko06ko1ol0G?l6
o`1:o`Oo03So1ol09_l8o`0Do`So00;o2ol?0?lOob40o`[o3`3o1_l00_l4o`0Do`Co02Ko1?l0>?l3
o`1:o`?o05co0ol0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo00
1?l0omko0?o<o`3oc?l0okX2o`3oZ005o`3oUol0ohGo0?n5o`3oLol0of400_l0odl00ol0ocgo0?l[
o`3o6@02o`3o1`07o`[o0?lLo`3o;_l0ocoo0?mAo`3oHol0ogGo0005ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooolDo`3moa3o0>_o2_l0fOl9o`37o`So0;Go1ol0Xol7o`2Ao`Oo
07oo1_l0K_l7o`1Lo`Ko04[o1ol0>?l7o`0Vo`So01Co2?l00_l;o`l0oaoo8@3o2Ol?0?l6o`02o`Go
01Co1?l09_l3o`0ho`Co04[o0ol0G?l2o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o
0>_o0_l0oOl2o`3ol004o`3og_l0olco0?o<o`3o^P;o0?nX00Go0?nGo`3oQOl0ohGo0?mco`3oH@02
o`3oC`03o`3o?Ol0ob_o0?lI00;o0?l700Oo2_l0oaco0?l^o`3o?ol0oe7o0?mSo`3oMOl000Gooooo
0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaOo0?go3ol0jol:o`3Io`Wo0<Oo1ol0
]Ol6o`2So`Oo097o1ol0Ool6o`1^o`Oo05co1_l0B_l7o`0ho`Oo02Ko2?l05?l8o`02o`_o3`3o7olQ
0?l9o`l0o`Ko00;o1Ol05?l4o`0Vo`?o03So1?l0B_l3o`1Lo`;o06ko0ol0Ool2o`2Ao`;o0:?o0_l0
]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00Co0?oNo`3oc?l0olco0?nj0_l0ojP01Ol0oiOo0?n5
o`3oQOl0og?o0?mQ00;o0?m?00?o0?lmo`3o:ol0oaT00_l0o`L01ol:o`3o7?l0obko0?loo`3oDOl0
of?o0?meo`001Oooool1o`00007ooooo000Eooooo`;o00000ooooolJo`3mo`go0>_o2_l0fOl9o`37
o`Oo0;Go1_l0Xol7o`2Ao`Oo07oo1_l0K_l7o`1Lo`Ko04[o1ol0>?l7o`0Vo`So01Co2?l00_l;o`l0
oaoo8@3o2Ol?0?l5o`02o`Go01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2S
o`;o0;Go0ol0aol00ol0fOoo0>_oo`3[o`02o`3mo`;o0?o`00Co0?oNo`3oc?l0olco0?nj0_l0ojP0
1Ol0oiOo0?n5o`3oQOl0og?o0?mQ00;o0?m?0_l0ocd02?l0oaWo0?l7o`3o1ol:o`3o7?l0obko0?lo
o`3oDOl00_mSo`04ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_ooool7o`3ol1Ko
0?go3?l0jol:o`3Io`So0<Oo1ol0]Ol6o`2So`Oo097o1_l0Ool7o`1^o`Oo05co1_l0B_l7o`0ho`Oo
02Ko1ol05?l8o`02o`_o3`3o7olQ0?l9o`l0o`Ko00;o1Ol05?l4o`0Vo`?o03So1?l0B_l3o`1Lo`;o
06ko0ol0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00Co0?oNo`3oc?l0
olco0?nj0_l0ojP01Ol0oiOo0?n5o`3oQOl0og?o0?mQ00;o0?m?00?o0?lmo`3o:ol0oaT00_l0o`L0
1_l:o`3o7?l0obko0?loo`3oDOl0of?o00Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooo`ko0?o`4_l0oOl:o`3[o`[o0=Wo2?l0aol7o`2eo`Ko0:?o1ol0TOl6o`1oo`Oo06ko1_l0
G?l6o`1:o`Oo03So1ol09_l8o`0Do`So00;o2ol?0?lNob40o`Wo3`3o1_l00_l5o`0Do`Co02Ko0ol0
>?l4o`1:o`?o05co0_l0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0
oo001?l0omko0?o<o`3oc?l0okX2o`3oZ005o`3oUol0ohGo0?n5o`3oLol0of400_l0odl00ol0ocgo
0?l[o`3o6@02o`3o1`06o`[o0?lLo`3o;_l0ocoo0?mAo`3oHol01Oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;ooooo4Ol0oo0Ao`3mo`[o0>_o2Ol0fOl8o`37o`Oo0;Go1_l0Xol7o`2A
o`Ko07oo1_l0K_l7o`1Lo`Ko04[o1ol0>?l7o`0Vo`Oo01Co2?l00_l<o`l0oako8@3o2Ol?0?l5o`02
o`Go01Co1?l09_l4o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3I
o`;o0>_o0_l0oOl2o`3ol004o`3og_l0olco0?o<o`3o^P;o0?nX00Go0?nGo`3oQOl0ohGo0?mco`3o
H@02o`3oC`;o0?lm00Wo0?lIo`3o1ol0o`Oo2_l0oaco0?l^o`3o?ol0oe7o0?mSo`001Oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5?l0oo0@o`3mo`Wo0>_o2_l0fOl7o`37o`Oo
0;Go1_l0Xol6o`2Ao`Oo07oo1_l0K_l6o`1Lo`Ko04[o1ol0>?l7o`0Vo`So01Co2?l00_l;o`l0oako
8@3o2Ol?0?l6o`02o`Go01Co1?l09_l3o`0ho`Co04[o0ol0G?l2o`1^o`?o07oo0_l0TOl2o`2So`;o
0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol004o`3og_l0olco0?o<o`3o^P;o0?nX00Go0?nGo`3o
QOl0ohGo0?mco`3oH@02o`3oC`05o`3o?Ol0ob_o0?lIo`3o1ol:o`000_lLo`000ol^o`3o?ol0of?o
0005ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolGo`3ol0ko0?go2_l0jol9
o`3Io`Oo0<Oo1ol0]Ol6o`2So`Ko097o1_l0Ool7o`1^o`Ko05co1_l0B_l7o`0ho`Oo02Ko1ol05?l8
o`02o`co3`3o7_lQ0?l9o`l0o`Go00;o1Ol05?l4o`0Vo`Co03So0ol0B_l3o`1Lo`;o06ko0ol0Ool2
o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00Co0?oNo`3oc?l0olco0?nj0_l0
ojP01Ol0oiOo0?n5o`3oQOl0og?o0?mQ00;o0?m?00Go0?lmo`3o:ol0oaWo0?l7o`[o0002oaco0003
obko0?loo`3oDOl000Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa[o0?o`
3Ol0oOl9o`3[o`Wo0=Wo1ol0aol7o`2eo`Ko0:?o1_l0TOl6o`1oo`Oo06ko1_l0G?l6o`1:o`Oo03So
1ol09_l7o`0Do`So00;o2ol?0?lNob40o`Wo3`3o1Ol00_l5o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co
0ol0K_l2o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo001?l0omko0?o<
o`3oc?l0okX2o`3oZ005o`3oUol0ohGo0?n5o`3oLol0of400_l0odl00ol0ocgo0?l[o`3o6@02o`3o
1`05o`[o0?lLo`3o;_l0ocoo0?mAo`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;ooooo1ol0omhEo`3ol0go0?go2Ol0jol8o`3Io`Oo0<Oo1ol0]Ol6o`2So`Ko097o1_l0Ool6o`1^
o`Ko05co1_l0B_l7o`0ho`Oo02Ko1ol05?l8o`02o`co3`3o7OlQ0?l9o`l0o`Ko00;o1Ol05?l4o`0V
o`?o03So1?l0B_l3o`1Lo`;o06ko0ol0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3m
o`;o0?o`00Co0?oNo`3oc?l0olco0?nj0_l0ojP01Ol0oiOo0?n5o`3oQOl0og?o0?mQ00;o0?m?00Go
0?lmo`3o:ol0oaWo0?l7o`[o0002oaco0003obko0?loo`3ooooo00Cooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02ooooo`oo0?oN4?l0oo0;o`3mo`Wo0>_o2?l0fOl7o`37o`Oo0;Go1_l0
Xol6o`2Ao`Ko07oo1_l0K_l6o`1Lo`Ko04[o1ol0>?l7o`0Vo`Oo01Co2?l00_l<o`l0oago8@3o2Ol?
0?l5o`02o`Go01Co1?l09_l4o`0ho`?o04[o0ol0G?l2o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0
aol2o`3Io`;o0>_o0_l0oOl2o`3ol004o`3og_l0olco0?o<o`3o^P;o0?nX00Go0?nGo`3oQOl0ohGo
0?mco`3oH@02o`3oC`05o`3o?Ol0ob_o0?lIo`3o1ol:o`000_lLo`000ol^o`3o?ol0ooooo`04oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolCo`3ogPoo0?o`2_l0oOl8o`3[o`So
0=Wo1_l0aol7o`2eo`Ko0:?o1_l0TOl6o`1oo`Ko06ko1_l0G?l6o`1:o`Oo03So1ol09_l7o`0Do`So
00;o3?l?0?lMob40o`Wo3`3o1Ol00_l5o`0Do`Co02Ko1?l0>?l3o`1:o`?o05co0_l0K_l3o`1oo`;o
097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go0_l0oo001?l0omko0?o<o`3oc?l0okX2o`3o
Z005o`3oUol0ohGo0?n5o`3oLol0of400_l0odl01Ol0ocgo0?l[o`3o6Ol0o`Oo2_l000;o7?l000?o
;_l0ocoo0?ooool01?ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5Ol0omh>
o`3ol0[o0?go2?l0jol8o`3Io`Ko0<Oo1ol0]Ol6o`2So`Ko097o1_l0Ool6o`1^o`Ko05co1_l0B_l7
o`0ho`Oo02Ko1ol05?l8o`02o`co3`3o7?lQ0?l9o`l0o`Ko00;o1Ol05?l4o`0Vo`?o03So0ol0B_l3
o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00Co0?oN
o`3oc?l0olco0?nj0_l0ojP01?l0oiOo0?n5o`3oQOl0og<2o`3oH@06o`3oCol0ocgo0?l[o`3o6Ol0
o`Oo2_l00_lLo`000ol^o`3o?ol0ooooo`04ooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool00_oooolGo`3ogPko0?o`2Ol0oOl9o`3[o`Oo0=Wo1_l0aol6o`2eo`Oo0:?o1_l0TOl6o`1oo`Ko
06ko1_l0G?l5o`1:o`Oo03So1ol09_l7o`0Do`So00;o3?l?0?lMob40o`Wo3`3o1Ol00_l5o`0Do`Co
02Ko1?l0>?l3o`1:o`?o05co0_l0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o
0?go00?o0?o`o`3og_l0omh00_l0ol`01Ol0ok[o0?nXo`3oZ?l0oiOo0?n500;o0?mc00?o0?mQo`3o
Col0ocd00_l0ob/01_l0oaWo0?l7o`[o0?lLo`3o;_l0ocoo00Gooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02oooooaWo0?oN3Ol0oo0:o`3mo`So0>_o1ol0fOl6o`37o`Ko0;Go1ol0Xol6
o`2Ao`Ko07oo1Ol0K_l6o`1Lo`Ko04[o1ol0>?l7o`0Vo`Oo01Co2?l00_l;o`l0oago8@3o2Ol?0?l5
o`02o`Go01Co1?l09_l4o`0ho`?o04[o0ol0G?l2o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2
o`3Io`;o0>_o0_l0oOl2o`3ol004o`3og_l0olco0?o<o`3o^P;o0?nX00Go0?nGo`3oQOl0ohGo0?mc
o`3oH@02o`3oC`05o`3o?Ol0ob_o0?lIo`3o1ol:o`000_lLo`000ol^o`3oooooooooo`03ooooo`7o
00000Oooool001Gooooo0_l00003ooooo`Oo0?o<5Ol0omh;o`3ol0[o0?go2?l0jol7o`3Io`Ko0<Oo
1_l0]Ol6o`2So`Ko097o1_l0Ool6o`1^o`Ko05co1Ol0B_l7o`0ho`Oo02Ko1ol05?l8o`02o`co3`3o
7?lQ0?l9o`l0o`Ko00;o1Ol05?l4o`0Vo`?o03So0ol0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o
0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`;o0?o`00Co0?oNo`3oc?l0olco0?nj0_l0ojP01?l0oiOo
0?n5o`3oQOl0og<2o`3oH@06o`3oCol0ocgo0?l[o`3o6Ol0o`Oo2_l00_lLo`000ol^o`3ooooooooo
o`02ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_ooool>o`3oc13o0?oN2ol0oo0:
o`3mo`Oo0>_o1_l0fOl6o`37o`Oo0;Go1_l0Xol6o`2Ao`Ko07oo1_l0K_l5o`1Lo`Ko04[o1ol0>?l7
o`0Vo`Oo01Co2?l00_l;o`l0oago8@3o2Ol?0?l5o`02o`Go01Co1?l09_l4o`0ho`?o04[o0_l0G?l3
o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl00ol0oo3o0?oNo`3ogP02
o`3oc005o`3o^_l0ojSo0?nXo`3oUol0ohD00_l0og<00ol0of7o0?m?o`3o?@02o`3o:`05o`3o6Ol0
o`Oo2_l0oaco0?l^o`001Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo4Ol0
ol`?o`3ogP[o0?o`2_l0oOl7o`3[o`Ko0=Wo1_l0aol7o`2eo`Ko0:?o1_l0TOl6o`1oo`Go06ko1_l0
G?l6o`1:o`Oo03So1_l09_l7o`0Do`So00;o2ol?0?lMob40o`Wo3`3o1Ol00_l5o`0Do`Co02Ko1?l0
>?l3o`1:o`?o05co0_l0K_l3o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go00?o
0?o`o`3og_l0omh00_l0ol`01Ol0ok[o0?nXo`3oZ?l0oiOo0?n500;o0?mc00?o0?mQo`3oCol0ocd0
0_l0ob/01Ol0oaWo0?l7o`[o0?lLo`3o;_l000Gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02oooooaCo0?o<3_l0omh:o`3ol0Wo0?go1ol0jol6o`3Io`Ko0<Oo1_l0]Ol7o`2So`Go097o
1_l0Ool6o`1^o`Ko05co1Ol0B_l7o`0ho`Oo02Ko1_l05?l8o`02o`co3`3o7?lQ0?l9o`l0o`Ko00;o
1Ol05?l4o`0Vo`?o03So0ol0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo
0_l0jol2o`3mo`03o`3ol?l0omko0?oN00;o0?o<00Go0?njo`3oZ?l0ojSo0?nGo`3oQ@02o`3oL`03
o`3oHOl0odoo0?lm00;o0?l[00Go0?lIo`3o1ol:o`3o7?l0obko0005ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooolGo`3oc0go0?oN2Ol0oo09o`3mo`Oo0>_o1_l0fOl6o`37o`Ko
0;Go1_l0Xol6o`2Ao`Ko07oo1Ol0K_l6o`1Lo`Ko04[o1ol0>?l6o`0Vo`Oo01Co2?l00_l;o`l0oago
8@3o2?l?0?l6o`02o`Go01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o
0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl2o`3ol004o`3og_l0olco0?o<o`3o^P;o0?nX00Go0?nGo`3o
QOl0ohGo0?mco`3oH@02o`3oC`05o`3o?Ol0ob_o0?lIo`3o1ol:o`000_lLo`05ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_oooolJo`3oc0co0?oN2Ol0oo08o`3mo`Oo0>_o1_l0fOl6
o`37o`Ko0;Go1_l0Xol6o`2Ao`Go07oo1_l0K_l6o`1Lo`Go04[o1ol0>?l7o`0Vo`Ko01Co2?l00_l;
o`l0oago8@3o2Ol?0?l5o`02o`Go01Co1?l09_l4o`0ho`?o04[o0ol0G?l2o`1^o`?o07oo0_l0TOl2
o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl00ol0oo3o0?oNo`3ogP02o`3oc005o`3o^_l0ojSo
0?nXo`3oUol0ohD00_l0og<00ol0of7o0?m?o`3o?@02o`3o:`04o`3o6Ol0o`Oo2_l0oaco00Gooooo
0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`Ko0?nj5ol0ol`;o`3ogPSo0?o`2?l0
oOl7o`3[o`Ko0=Wo1ol0aol5o`2eo`Ko0:?o1_l0TOl5o`1oo`Ko06ko1_l0G?l5o`1:o`Oo03So1_l0
9_l7o`0Do`So00;o2ol?0?lMob40o`So3`3o1_l00_l5o`0Do`Co02Ko0ol0>?l3o`1:o`?o05co0ol0
K_l2o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go00?o0?o`o`3og_l0omh00_l0
ol`01Ol0ok[o0?nXo`3oZ?l0oiOo0?n500;o0?mc00?o0?mQo`3oCol0ocd00_l0ob/01?l0oaWo0?l7
o`[o0?lLo`05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool>o`3o^Q7o0?o<
2_l0omh9o`3ol0So0?go1_l0jol5o`3Io`Oo0<Oo1Ol0]Ol6o`2So`Ko097o1Ol0Ool6o`1^o`Ko05co
1Ol0B_l7o`0ho`Ko02Ko1ol05?l8o`02o`_o3`3o7OlQ0?l8o`l0o`Ko00;o1Ol05?l4o`0Vo`?o03So
0ol0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`03o`3o
l?l0omko0?oN00;o0?o<00Co0?njo`3oZ?l0ojSo0?nG0_l0ohD01?l0og?o0?mQo`3oCol0ocd2o`3o
:`04o`3o6Ol0o`Oo2_l0oaco00Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
oa7o0?nj3ol0ol`:o`3ogPWo0?o`2?l0oOl5o`3[o`Ko0=Wo1ol0aol5o`2eo`Ko0:?o1_l0TOl5o`1o
o`Ko06ko1_l0G?l5o`1:o`Oo03So1_l09_l7o`0Do`So00;o2ol?0?lLob40o`So3`3o1ol00_l4o`0D
o`Co02Ko0ol0>?l4o`1:o`;o05co0ol0K_l2o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[
o`;o0?go00?o0?o`o`3og_l0omh00_l0ol`00ol0ok[o0?nXo`3oZ002o`3oU`05o`3oQOl0og?o0?mQ
o`3oCol0ocd00_l0ob/01?l0oaWo0?l7o`[o0?lLo`05ooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_oooolDo`3o^Pko0?o<2_l0omh8o`3ol0So0?go1Ol0jol6o`3Io`Oo0<Oo1Ol0]Ol6
o`2So`Ko097o1Ol0Ool5o`1^o`Ko05co1_l0B_l6o`0ho`Ko02Ko1ol05?l8o`02o`_o3`3o7OlQ0?l8
o`l0o`Ko00;o1?l05?l5o`0Vo`?o03So0ol0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0_l0]Ol2
o`37o`;o0=Wo0_l0jol00ol0oOoo0?o`o`3ol002o`3ogP04o`3oc?l0ok[o0?njo`3oZ0;o0?nG00Oo
0?n5o`3oLol0of7o0?mQo`3oCol0ocgo0?l[00;o0?lI00?o0?l7o`[o0?ooool01?ooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo5ol0okX=o`3oc0Wo0?oN2?l0oo08o`3mo`Go0>_o
1_l0fOl7o`37o`Go0;Go1_l0Xol6o`2Ao`Co07oo1_l0K_l6o`1Lo`Go04[o1ol0>?l6o`0Vo`Oo01Co
2?l00_l:o`l0oago8@3o2?l?0?l6o`02o`Go01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo
0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl00ol0oo3o0?oNo`3ogP02o`3oc004o`3o
^_l0ojSo0?nXo`3oU`;o0?n500Co0?mco`3oHOl0odoo0?lm0_l0ob/00ol0oaWo0?l7o`[o0005oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolJo`3o^P_o0?o<2Ol0omh9o`3ol0Oo
0?go1Ol0jol6o`3Io`Ko0<Oo1_l0]Ol5o`2So`Ko097o1Ol0Ool5o`1^o`Ko05co1_l0B_l6o`0ho`Ko
02Ko1ol05?l8o`02o`_o3`3o7?lQ0?l8o`l0o`Oo00;o1?l05?l4o`0Vo`?o03So1?l0B_l2o`1Lo`?o
06ko0_l0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol2o`3mo`03o`3ol?l0omko0?oN00;o
0?o<00?o0?njo`3oZ?l0ojP00_l0oiL01Ol0ohGo0?mco`3oHOl0odoo0?lm00;o0?l[00?o0?lIo`3o
1ol:o`001Oooool1o`00007ooooo000Eooooo`;o00000oooool7o`3oZ1Ko0?nj2_l0ol`9o`3ogPSo
0?o`1ol0oOl5o`3[o`Ko0=Wo1_l0aol5o`2eo`Ko0:?o1_l0TOl5o`1oo`Go06ko1_l0G?l5o`1:o`Oo
03So1_l09_l6o`0Do`Wo00;o2_l?0?lMob40o`So3`3o1_l00_l4o`0Do`Go02Ko0ol0>?l3o`1:o`?o
05co0ol0K_l2o`1oo`04o`2Aool0Xooo0:?oo`2So`;o0;Go0_l0aol2o`3Io`;o0>_o00?o0?goo`3o
l?l0oo000_l0omh01?l0olco0?njo`3o^_l0ojP2o`3oU`07o`3oQOl0og?o0?mQo`3oHOl0odoo0?lm
o`3o:`02o`3o6@03o`[o0?oooooooooo00;ooooo0_l00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooo`oo0?nX4Ol0okX9o`3oc0So0?oN2?l0oo07o`3mo`Go0>_o1_l0fOl6o`37o`Go0;Go1_l0
Xol5o`2Ao`Go07oo1Ol0K_l7o`1Lo`Go04[o1_l0>?l6o`0Vo`Oo01Co2?l00_l:o`l0oago8@3o2?l?
0?l6o`02o`Go01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0_l0
aol2o`3Io`;o0>_o0_l0oOl01?l0oo3o0?oNo`3og_l0ol`2o`3o^P05o`3oZ?l0oiOo0?nGo`3oQOl0
og<00_l0of400ol0odoo0?lmo`3o:`02o`3o6@03o`[o0?oooooooooo00?ooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02oooooaCo0?nX3_l0okX8o`3oc0Wo0?oN1ol0oo06o`3mo`Ko0>_o
1_l0fOl5o`37o`Ko0;Go1Ol0Xol6o`2Ao`Go07oo1Ol0K_l6o`1Lo`Go04[o1_l0>?l6o`0Vo`Oo01Co
2?l00_l;o`l0oaco8@3o2Ol?0?l6o`02o`Co01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo
0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl01?l0oo3o0?oNo`3og_l0ol`2o`3o^P05
o`3oZ?l0oiOo0?nGo`3oQOl0og<00_l0of400ol0odoo0?lmo`3o:`02o`3o6@03o`3o1ooooooooooo
00?ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaOo0?nX3?l0okX9o`3oc0So
0?oN1ol0oo06o`3mo`Ko0>_o1_l0fOl5o`37o`Go0;Go1_l0Xol6o`2Ao`Co07oo1_l0K_l6o`1Lo`Go
04[o1_l0>?l6o`0Vo`Oo01Co2?l00_l:o`l0oaco8@3o2Ol?0?l6o`02o`Co01Co1?l09_l3o`0ho`?o
04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl00ol0oo3o
0?oNo`3ogP02o`3oc003o`3o^_l0ojSo0?nX00;o0?nG00Go0?n5o`3oLol0of7o0?m?o`3o?@02o`3o
:`03o`3o6Ol0o`Oooooo00Cooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaWo
0?nX3?l0okX8o`3oc0So0?oN1ol0oo06o`3mo`Ko0>_o1_l0fOl5o`37o`Go0;Go1_l0Xol5o`2Ao`Go
07oo1Ol0K_l6o`1Lo`Go04[o1_l0>?l6o`0Vo`Oo01Co2?l00_l:o`l0oago8@3o2?l?0?l6o`02o`Go
01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o
0>_o0_l0oOl01?l0oo3o0?oNo`3og_l0ol`2o`3o^P05o`3oZ?l0oiOo0?nGo`3oQOl0og<00_l0of40
0ol0odoo0?lmo`3o:`02o`3o6@Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
o`?o0?nG6?l0ojP;o`3o^PSo0?o<2?l0omh7o`3ol0Ko0?go1_l0jol6o`3Io`Go0<Oo1Ol0]Ol6o`2S
o`Go097o1Ol0Ool5o`1^o`Ko05co1Ol0B_l6o`0ho`Ko02Ko1ol05?l8o`02o`[o3`3o7?lQ0?l9o`l0
o`Ko00;o1?l05?l4o`0Vo`?o03So0ol0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37
o`;o0=Wo0_l0jol2o`3mo`04o`3ol?l0omko0?oNo`3oc0;o0?nj00Go0?nXo`3oUol0oiOo0?n5o`3o
L`02o`3oH@03o`3oCol0ocgo0?l[00;o0?lI1Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo3_l0oiL?o`3oZ0_o0?nj2?l0ol`8o`3ogPKo0?o`1Ol0oOl7o`3[o`Go0=Wo1_l0aol4
o`2eo`Oo0:?o1?l0TOl5o`1oo`Go06ko1_l0G?l5o`1:o`Oo03So1Ol09_l7o`0Do`So00;o2ol?0?lK
ob40o`Wo3`3o1_l00_l4o`0Do`Co02Ko0ol0>?l3o`1:o`?o05co0ol0K_l2o`1oo`;o097o0_l0Xol2
o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go00Co0?o`o`3og_l0omko0?o<0_l0okX2o`3oZ003o`3oUol0
ohGo0?mc00;o0?mQ00?o0?m?o`3o?Ol0ob/00_l0oaT5ooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_oooolAo`3oU`oo0?nX2Ol0okX8o`3oc0So0?oN1_l0oo05o`3mo`Ko0>_o1_l0fOl5
o`37o`Go0;Go1_l0Xol5o`2Ao`Go07oo1Ol0K_l6o`1Lo`Go04[o1_l0>?l6o`0Vo`Oo01Co2?l00_l;
o`l0oa_o8@3o2Ol?0?l5o`02o`Co01Co1?l09_l4o`0ho`;o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2
o`2So`;o0;Go0ol0aol2o`3Io`04o`3[ool0oOoo0?goo`3ol0;o0?oN00So0?o<o`3o^_l0ok[o0?nj
o`3oZ?l0oiOo0?n5o`3oL`;o0?mQ00?o0?m?o`3o?Ol0ob/00_l0oaT5ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_oooolDo`3oU`ko0?nX2?l0okX9o`3oc0Oo0?oN1_l0oo05o`3mo`Ko
0>_o1_l0fOl5o`37o`Go0;Go1_l0Xol5o`2Ao`Co07oo1_l0K_l5o`1Lo`Ko04[o1_l0>?l5o`0Vo`Oo
01Co2?l00_l;o`l0oa_o8@3o2Ol?0?l6o`02o`Co01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o
07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl01?l0oo3o0?oNo`3og_l0ol`2o`3o
^P05o`3oZ?l0oiOo0?nGo`3oQOl0og<00_l0of401?l0odoo0?lmo`3o:ol0oaT5ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_oooolGo`3oU`go0?nX2?l0okX8o`3oc0Oo0?oN1_l0oo05
o`3mo`Ko0>_o1_l0fOl5o`37o`Go0;Go1_l0Xol4o`2Ao`Go07oo1Ol0K_l6o`1Lo`Go04[o1_l0>?l6
o`0Vo`Oo01Co2?l00_l;o`l0oa[o8@3o2Ol?0?l6o`02o`Co01Co1?l09_l3o`0ho`?o04[o0ol0G?l3
o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl01?l0oo3o0?oNo`3og_l0
ol`2o`3o^P;o0?nX00?o0?nGo`3oQOl0og<00_l0of401?l0odoo0?lmo`3o:ol0oaT5ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooolJo`3oU`_o0?nX2?l0okX8o`3oc0Oo0?oN1_l0
oo05o`3mo`Ko0>_o1Ol0fOl6o`37o`Go0;Go1Ol0Xol5o`2Ao`Go07oo1Ol0K_l5o`1Lo`Ko04[o1_l0
>?l5o`0Vo`Oo01Co2?l00_l;o`l0oa_o8@3o2Ol?0?l5o`02o`Co01Co1?l09_l4o`0ho`;o04[o0ol0
G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0ol0aol2o`3Io`04o`3[ool0oOoo0?goo`3ol0;o0?oN
00So0?o<o`3o^_l0ok[o0?njo`3oZ?l0oiOo0?n5o`3oL`;o0?mQ00Co0?m?o`3o?Ol0ob_o0?lI1Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo1ol0ohDFo`3oU`[o0?nX2?l0okX8
o`3oc0Ko0?oN1_l0oo05o`3mo`Ko0>_o1Ol0fOl6o`37o`Co0;Go1_l0Xol4o`2Ao`Go07oo1Ol0K_l6
o`1Lo`Go04[o1_l0>?l6o`0Vo`Oo01Co1ol00_l;o`l0oa_o8@3o2Ol?0?l5o`02o`Go01Co1?l09_l3
o`0ho`?o04[o0ol0G?l2o`1^o`?o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl0
1?l0oo3o0?oNo`3og_l0ol`2o`3o^P06o`3oZ?l0oiOo0?n5o`3oQOl0og?o0?mQ0_l0odl00ol0ocgo
0?l[ooooo`04ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool?o`3oQA7o0?nG
2Ol0ojP8o`3o^POo0?o<1_l0omh6o`3ol0Go0?go1_l0jol5o`3Io`Go0<Oo1Ol0]Ol6o`2So`Co097o
1Ol0Ool5o`1^o`Go05co1_l0B_l5o`0ho`Ko02Ko1ol05?l8o`02o`_o3`3o6olQ0?l9o`l0o`Go00;o
1?l05?l4o`0Vo`?o03So0ol0B_l3o`1Lo`;o06ko0ol0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo
0_l0jol2o`3mo`04o`3ol?l0omko0?oNo`3oc0;o0?nj00Ko0?nXo`3oUol0ohGo0?n5o`3oLol0of42
o`3oC`03o`3o?Ol0ob_ooooo00Cooooo0Ol00001ooooo`005Oooool2o`0000?ooooo5?l0ohD>o`3o
U`So0?nX2?l0okX7o`3oc0Ko0?oN1_l0oo05o`3mo`Ko0>_o1Ol0fOl5o`37o`Go0;Go1Ol0Xol5o`2A
o`Co07oo1_l0K_l5o`1Lo`Ko04[o1Ol0>?l6o`0Vo`Oo01Co1ol00_l;o`l0oa_o8@3o2Ol?0?l5o`02
o`Co01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0ol0aol00ol0
fOoo0>_oo`3[o`02o`3mo`04o`3ol?l0omko0?oNo`3oc0;o0?nj00Go0?nXo`3oUol0oiOo0?n5o`3o
L`02o`3oH@03o`3oCol0ocgo0?l[00Cooooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02
oooooaOo0?n53Ol0oiL8o`3oZ0So0?nj1_l0ol`6o`3ogPKo0?o`1Ol0oOl6o`3[o`Go0=Wo1Ol0aol5
o`2eo`Go0:?o1?l0TOl5o`1oo`Go06ko1Ol0G?l6o`1:o`Go03So1_l09_l7o`0Do`Oo00;o2ol?0?lK
ob40o`Wo3`3o1Ol00_l5o`0Do`Co02Ko0ol0>?l3o`1:o`?o05co0_l0K_l3o`1oo`;o097o0_l0Xol2
o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go00Co0?o`o`3og_l0omko0?o<0_l0okX01_l0ojSo0?nGo`3o
QOl0ohGo0?mco`3oH@;o0?m?00?o0?lmooooooooool00oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo6_l0ohD;o`3oU`So0?nX2?l0okX6o`3oc0Ko0?oN1_l0oo05o`3mo`Ko0>_o
1Ol0fOl5o`37o`Go0;Go1Ol0Xol4o`2Ao`Go07oo1Ol0K_l5o`1Lo`Ko04[o1Ol0>?l6o`0Vo`Oo01Co
1ol00_l;o`l0oa_o8@3o2Ol?0?l5o`02o`Co01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo
0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o0_l0oOl01?l0oo3o0?oNo`3og_l0ol`2o`3o^P06
o`3oZ?l0oiOo0?n5o`3oQOl0og?o0?mQ0_l0odl00ol0ocgoooooooooo`03ooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_ooool8o`3oLaCo0?n52ol0oiL8o`3oZ0Ko0?nj1ol0ol`5o`3o
gPKo0?o`1Ol0oOl6o`3[o`Go0=Wo1Ol0aol5o`2eo`Go0:?o1?l0TOl5o`1oo`Ko06ko1?l0G?l6o`1:
o`Go03So1_l09_l7o`0Do`Oo00;o2ol?0?lKob40o`Wo3`3o1Ol00_l4o`0Do`Co02Ko0ol0>?l3o`1:
o`?o05co0ol0K_l2o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go00Co0?o`o`3o
g_l0omko0?o<0_l0okX01_l0ojSo0?nGo`3oQOl0ohGo0?mco`3oH@;o0?m?00?o0?lmooooooooool0
0oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo3_l0og<@o`3oQ@[o0?nG2?l0
ojP7o`3o^PKo0?o<1Ol0omh6o`3ol0Go0?go1_l0jol5o`3Io`Go0<Oo1Ol0]Ol5o`2So`Co097o1Ol0
Ool5o`1^o`Go05co1_l0B_l5o`0ho`Ko02Ko1ol05?l7o`02o`[o3`3o6olQ0?l9o`l0o`Go00;o1?l0
5?l5o`0Vo`?o03So0_l0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0ol0]Ol00ol0aooo0=Woo`3I
o`02o`3[o`;o0?go00?o0?o`o`3og_l0omh00_l0ol`00ol0ok[o0?nXo`3oU`02o`3oQ@05o`3oLol0
of7o0?m?o`3oCol0ocd01Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo4Ol0
og<?o`3oQ@Wo0?nG2?l0ojP7o`3o^PKo0?o<1Ol0omh6o`3ol0Go0?go1_l0jol5o`3Io`Go0<Oo1?l0
]Ol5o`2So`Go097o1Ol0Ool5o`1^o`Co05co1_l0B_l5o`0ho`Ko02Ko1ol05?l7o`02o`[o3`3o6olQ
0?l9o`l0o`Ko00;o1?l05?l4o`0Vo`?o03So0ol0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0_l0
]Ol2o`37o`;o0=Wo0_l0jol00ol0oOoo0?o`o`3ol002o`3ogP06o`3oc?l0ok[o0?nXo`3oZ?l0oiOo
0?n50_l0og<00ol0of7o0?m?o`3o?@05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool0
0_oooolDo`3oL`ko0?n52?l0oiL9o`3oZ0Ko0?nj1_l0ol`5o`3ogPKo0?o`1Ol0oOl5o`3[o`Go0=Wo
1Ol0aol5o`2eo`Go0:?o1?l0TOl5o`1oo`Go06ko1Ol0G?l6o`1:o`Go03So1_l09_l6o`0Do`So00;o
2_l?0?lKob40o`Wo3`3o1Ol00_l4o`0Do`Co02Ko0ol0>?l3o`1:o`?o05co0ol0K_l2o`1oo`;o097o
0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`;o0?go00Co0?o`o`3og_l0omko0?o<0_l0okX01_l0ojSo
0?nGo`3oQOl0ohGo0?mco`3oH@;o0?m?1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;ooooo5ol0og<=o`3oQ@So0?nG2?l0ojP6o`3o^PKo0?o<1Ol0omh5o`3ol0Ko0?go1Ol0jol5o`3I
o`Go0<Oo1?l0]Ol5o`2So`Go097o1Ol0Ool5o`1^o`Co05co1_l0B_l5o`0ho`Ko02Ko1ol05?l7o`02
o`[o3`3o6olQ0?l9o`l0o`Go00;o1?l05?l4o`0Vo`Co03So0_l0B_l3o`1Lo`?o06ko0_l0Ool2o`2A
o`;o0:?o0ol0]Ol00ol0aooo0=Woo`3Io`02o`3[o`;o0?go00?o0?o`o`3og_l0omh00_l0ol`00ol0
ok[o0?nXo`3oU`02o`3oQ@04o`3oLol0of7o0?m?o`3oC`Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooo`Oo0?mQ4ol0og<;o`3oQ@So0?nG2?l0ojP7o`3o^PGo0?o<1Ol0omh5o`3o
l0Ko0?go1?l0jol6o`3Io`Go0<Oo1?l0]Ol5o`2So`Go097o1?l0Ool5o`1^o`Go05co1_l0B_l5o`0h
o`Ko02Ko1_l05?l8o`02o`Wo3`3o6olQ0?l9o`l0o`Ko00;o1?l05?l4o`0Vo`?o03So0ol0B_l2o`1L
o`Co06ko0_l0Ool2o`2Ao`;o0:?o0_l0]Ol2o`37o`;o0=Wo0_l0jol01?l0oOoo0?o`o`3ol?l0omh2
o`3oc005o`3o^_l0ojSo0?nXo`3oUol0ohD00_l0og<00ol0of7o0?m?ooooo`04ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_ooool>o`3oH@oo0?mc2_l0ohD8o`3oU`Oo0?nX1ol0okX5
o`3oc0Go0?oN1Ol0oo05o`3mo`Go0>_o1Ol0fOl5o`37o`Go0;Go1?l0Xol5o`2Ao`Go07oo1Ol0K_l5
o`1Lo`Go04[o1Ol0>?l6o`0Vo`Oo01Co1ol00_l9o`l0oa_o8@3o2Ol?0?l6o`02o`Co01Co1?l09_l3
o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o00?o0?go
o`3ol?l0oo000_l0omh01_l0olco0?njo`3oZ?l0ojSo0?nGo`3oQ@;o0?mc00?o0?mQo`3oCoooool0
1?ooool1o`00007ooooo000<ooooo`Go00001?ooool00ol0003oooooooooo`02oooooa7o0?mQ3ol0
og<9o`3oQ@Oo0?nG1ol0ojP7o`3o^PGo0?o<1Ol0omh5o`3ol0Go0?go1Ol0jol5o`3Io`Go0<Oo1?l0
]Ol5o`2So`Go097o1Ol0Ool4o`1^o`Go05co1Ol0B_l5o`0ho`Ko02Ko1ol05?l7o`02o`Wo3`3o7?lQ
0?l8o`l0o`Ko00;o1?l05?l4o`0Vo`Co03So0_l0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0_l0
]Ol2o`37o`;o0=Wo0_l0jol00ol0oOoo0?o`o`3ol002o`3ogP06o`3oc?l0ok[o0?nXo`3oZ?l0oiOo
0?n50_l0og<00ol0of7o0?m?ooooo`04ooooo`7o00000Oooool000gooooo00Co0000oooooooooooo
00001?ooool00ol0003oooooooooo`02oooooaCo0?mQ3_l0og<8o`3oQ@Oo0?nG1ol0ojP7o`3o^PGo
0?o<1Ol0omh5o`3ol0Go0?go1Ol0jol4o`3Io`Ko0<Oo1?l0]Ol4o`2So`Go097o1Ol0Ool5o`1^o`Go
05co1Ol0B_l5o`0ho`Ko02Ko1_l05?l8o`02o`Wo3`3o6olQ0?l9o`l0o`Go00;o1?l05?l4o`0Vo`Co
03So0_l0B_l3o`1Lo`?o06ko0_l0Ool2o`2Ao`;o0:?o0ol0]Ol00ol0aooo0=Woo`3Io`02o`3[o`;o
0?go00Co0?o`o`3og_l0omko0?o<0_l0okX01ol0ojSo0?nGo`3oQOl0ohGo0?mco`3oHOl0odl01Ooo
ool1o`00007ooooo000>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_oooolH
o`3oH@co0?mc2?l0ohD7o`3oU`Ko0?nX1ol0okX5o`3oc0Go0?oN1Ol0oo05o`3mo`Go0>_o1?l0fOl5
o`37o`Co0;Go1Ol0Xol5o`2Ao`Go07oo1?l0K_l5o`1Lo`Go04[o1Ol0>?l6o`0Vo`Oo01Co1ol00_l9
o`l0oa_o8@3o2Ol?0?l6o`02o`Co01Co1?l09_l3o`0ho`?o04[o0ol0G?l3o`1^o`;o07oo0_l0TOl2
o`2So`;o0;Go0_l0aol2o`3Io`;o0>_o00Co0?goo`3ol?l0oo3o0?oN0_l0ol`01Ol0ok[o0?nXo`3o
Z?l0oiOo0?n500;o0?mc00?o0?mQooooooooool00oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00?ooooo0_l00003ooooo`Go0?m?5_l0of4:o`3oL`So0?n51ol0oiL6o`3oZ0Ko0?nj1_l0
ol`5o`3ogPGo0?o`1Ol0oOl5o`3[o`Co0=Wo1Ol0aol4o`2eo`Go0:?o1Ol0TOl4o`1oo`Go06ko1Ol0
G?l5o`1:o`Go03So1_l09_l6o`0Do`So00;o2?l?0?lLob40o`So3`3o1_l00_l4o`0Do`Co02Ko1?l0
>?l2o`1:o`?o05co0ol0K_l2o`1oo`;o097o0_l0Xol2o`2eo`;o0<Oo0_l0fOl2o`3[o`04o`3mool0
oo3o0?o`o`3ogP;o0?o<00Go0?njo`3oZ?l0ojSo0?nGo`3oQ@02o`3oL`03o`3oHOoooooooooo00;o
oooo0_l00001ooooo`003?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooooooo
ool0ooooool7ooooo`7o00000Oooool000cooooo00Go0000ooooooooooooooooo`000004ooooo`03
o`000?oooooooooo0?oooooo1oooool1o`00007ooooo000=ooooo`?o00001Oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0?Oooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool00_ooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00;ooooo0Ol00001ooooo`005Oooooooo`0000_o00000Oooool0
0?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.207, -0.172242, 0.00783272, \
0.00783272}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.1978e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -17.6983 -9 ]
[.17646 .18758 .30168 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -15.8219 -9 ]
[.50253 .05935 2.17811 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 18 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 18 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01669 .31161 -18 -2.78163 ]
[.01669 .31161 0 6.21837 ]
[.00905 .35954 -18 -2.82227 ]
[.00905 .35954 0 6.17773 ]
[.00116 .40897 -18 -2.8643 ]
[.00116 .40897 0 6.1357 ]
[-0.00697 .45996 -18 -2.90781 ]
[-0.00697 .45996 0 6.09219 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(0.5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(1)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1.5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(0.5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(1)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1.5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02895 .30693 m
.03508 .30459 L
s
[(200)] .01669 .31161 1 -0.38186 Mshowa
.02134 .35496 m
.02749 .35267 L
s
[(400)] .00905 .35954 1 -0.37283 Mshowa
.01349 .40448 m
.01966 .40224 L
s
[(600)] .00116 .40897 1 -0.36349 Mshowa
.0054 .45558 m
.01158 .45339 L
s
[(800)] -0.00697 .45996 1 -0.35382 Mshowa
.125 Mabswid
.03451 .27185 m
.03818 .27043 L
s
.03267 .28346 m
.03634 .28204 L
s
.03082 .29515 m
.03449 .29374 L
s
.02707 .3188 m
.03075 .3174 L
s
.02518 .33076 m
.02886 .32937 L
s
.02327 .34281 m
.02695 .34143 L
s
.0194 .3672 m
.02309 .36583 L
s
.01745 .37953 m
.02114 .37817 L
s
.01548 .39196 m
.01917 .39061 L
s
.01149 .41711 m
.0152 .41577 L
s
.00948 .42983 m
.01318 .4285 L
s
.00744 .44265 m
.01115 .44133 L
s
.00333 .46861 m
.00705 .4673 L
s
.00125 .48174 m
.00497 .48044 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.662 .657 .835 r
.38927 .67142 .4021 .69019 .42403 .68331 .41127 .66446 Metetra
.675 .662 .83 r
.41127 .66446 .42403 .68331 .44617 .67517 .43348 .65628 Metetra
.687 .667 .826 r
.43348 .65628 .44617 .67517 .46848 .66579 .45587 .64692 Metetra
.697 .672 .822 r
.45587 .64692 .46848 .66579 .49094 .65524 .47842 .63643 Metetra
.707 .677 .819 r
.47842 .63643 .49094 .65524 .51354 .6436 .50112 .62491 Metetra
.715 .682 .817 r
.50112 .62491 .51354 .6436 .53626 .631 .52393 .61247 Metetra
.722 .687 .816 r
.52393 .61247 .53626 .631 .55908 .61758 .54686 .59926 Metetra
.728 .692 .816 r
.54686 .59926 .55908 .61758 .58198 .6035 .56988 .58545 Metetra
.732 .697 .817 r
.56988 .58545 .58198 .6035 .60497 .58896 .593 .57122 Metetra
.735 .702 .82 r
.593 .57122 .60497 .58896 .62804 .57419 .6162 .55681 Metetra
.736 .707 .824 r
.6162 .55681 .62804 .57419 .6512 .55941 .6395 .54244 Metetra
.735 .713 .83 r
.6395 .54244 .6512 .55941 .67445 .54491 .66291 .52839 Metetra
.731 .718 .838 r
.66291 .52839 .67445 .54491 .69783 .53095 .68645 .51494 Metetra
.724 .723 .849 r
.68645 .51494 .69783 .53095 .72136 .51787 .71016 .5024 Metetra
.713 .728 .862 r
.71016 .5024 .72136 .51787 .74509 .50598 .73407 .49111 Metetra
.694 .731 .879 r
.73407 .49111 .74509 .50598 .76907 .49565 .75825 .48144 Metetra
.667 .733 .899 r
.75825 .48144 .76907 .49565 .79338 .48728 .78277 .47378 Metetra
.626 .73 .922 r
.78277 .47378 .79338 .48728 .81809 .48128 .8077 .46856 Metetra
.563 .718 .945 r
.8077 .46856 .81809 .48128 .84332 .47813 .83317 .46626 Metetra
.469 .689 .963 r
.83317 .46626 .84332 .47813 .86918 .47833 .85929 .46738 Metetra
.327 .63 .961 r
.85929 .46738 .86918 .47833 .89583 .48245 .88622 .47252 Metetra
.13 .525 .916 r
.88622 .47252 .89583 .48245 .92345 .49115 .91414 .48234 Metetra
0 .366 .805 r
.91414 .48234 .92345 .49115 .95224 .50515 .94327 .49758 Metetra
0 .179 .639 r
.94327 .49758 .95224 .50515 .98248 .52531 .97387 .51914 Metetra
.662 .66 .838 r
.37628 .65276 .38927 .67142 .41127 .66446 .39836 .64571 Metetra
.675 .665 .833 r
.39836 .64571 .41127 .66446 .43348 .65628 .42064 .63749 Metetra
.686 .67 .829 r
.42064 .63749 .43348 .65628 .45587 .64692 .44311 .62814 Metetra
.696 .675 .825 r
.44311 .62814 .45587 .64692 .47842 .63643 .46575 .61772 Metetra
.706 .68 .822 r
.46575 .61772 .47842 .63643 .50112 .62491 .48854 .60631 Metetra
.714 .685 .82 r
.48854 .60631 .50112 .62491 .52393 .61247 .51146 .59404 Metetra
.72 .689 .82 r
.51146 .59404 .52393 .61247 .54686 .59926 .5345 .58104 Metetra
.726 .694 .82 r
.5345 .58104 .54686 .59926 .56988 .58545 .55764 .56749 Metetra
.73 .699 .821 r
.55764 .56749 .56988 .58545 .593 .57122 .58088 .55357 Metetra
.732 .704 .824 r
.58088 .55357 .593 .57122 .6162 .55681 .60422 .53951 Metetra
.733 .71 .829 r
.60422 .53951 .6162 .55681 .6395 .54244 .62766 .52555 Metetra
.731 .715 .835 r
.62766 .52555 .6395 .54244 .66291 .52839 .65123 .51195 Metetra
.727 .72 .844 r
.65123 .51195 .66291 .52839 .68645 .51494 .67493 .499 Metetra
.718 .725 .855 r
.67493 .499 .68645 .51494 .71016 .5024 .69881 .48701 Metetra
.705 .729 .869 r
.69881 .48701 .71016 .5024 .73407 .49111 .72291 .47633 Metetra
.685 .732 .886 r
.72291 .47633 .73407 .49111 .75825 .48144 .74728 .46732 Metetra
.654 .732 .907 r
.74728 .46732 .75825 .48144 .78277 .47378 .77201 .46038 Metetra
.609 .727 .93 r
.77201 .46038 .78277 .47378 .8077 .46856 .79717 .45594 Metetra
.539 .712 .952 r
.79717 .45594 .8077 .46856 .83317 .46626 .82287 .45449 Metetra
.435 .678 .966 r
.82287 .45449 .83317 .46626 .85929 .46738 .84925 .45655 Metetra
.282 .609 .955 r
.84925 .45655 .85929 .46738 .88622 .47252 .87646 .46272 Metetra
.074 .492 .896 r
.87646 .46272 .88622 .47252 .91414 .48234 .90468 .47367 Metetra
0 .325 .771 r
.90468 .47367 .91414 .48234 .94327 .49758 .93415 .49019 Metetra
0 .139 .598 r
.93415 .49019 .94327 .49758 .97387 .51914 .96512 .51316 Metetra
.662 .664 .841 r
.36314 .63419 .37628 .65276 .39836 .64571 .38529 .62705 Metetra
.674 .668 .836 r
.38529 .62705 .39836 .64571 .42064 .63749 .40765 .6188 Metetra
.685 .673 .832 r
.40765 .6188 .42064 .63749 .44311 .62814 .4302 .60946 Metetra
.696 .678 .828 r
.4302 .60946 .44311 .62814 .46575 .61772 .45293 .5991 Metetra
.704 .682 .826 r
.45293 .5991 .46575 .61772 .48854 .60631 .47582 .5878 Metetra
.712 .687 .824 r
.47582 .5878 .48854 .60631 .51146 .59404 .49884 .57569 Metetra
.719 .692 .824 r
.49884 .57569 .51146 .59404 .5345 .58104 .52199 .5629 Metetra
.724 .697 .824 r
.52199 .5629 .5345 .58104 .55764 .56749 .54524 .54961 Metetra
.727 .702 .826 r
.54524 .54961 .55764 .56749 .58088 .55357 .56861 .536 Metetra
.729 .707 .829 r
.56861 .536 .58088 .55357 .60422 .53951 .59209 .52229 Metetra
.729 .712 .834 r
.59209 .52229 .60422 .53951 .62766 .52555 .61567 .50873 Metetra
.727 .717 .841 r
.61567 .50873 .62766 .52555 .65123 .51195 .63939 .49559 Metetra
.721 .722 .85 r
.63939 .49559 .65123 .51195 .67493 .499 .66326 .48314 Metetra
.712 .727 .862 r
.66326 .48314 .67493 .499 .69881 .48701 .68731 .47171 Metetra
.697 .731 .876 r
.68731 .47171 .69881 .48701 .72291 .47633 .71159 .46163 Metetra
.674 .733 .894 r
.71159 .46163 .72291 .47633 .74728 .46732 .73616 .45328 Metetra
.64 .732 .915 r
.73616 .45328 .74728 .46732 .77201 .46038 .7611 .44707 Metetra
.59 .725 .937 r
.7611 .44707 .77201 .46038 .79717 .45594 .78648 .44342 Metetra
.513 .705 .958 r
.78648 .44342 .79717 .45594 .82287 .45449 .81242 .44283 Metetra
.399 .664 .967 r
.81242 .44283 .82287 .45449 .84925 .45655 .83906 .44583 Metetra
.234 .585 .946 r
.83906 .44583 .84925 .45655 .87646 .46272 .86655 .45305 Metetra
.017 .456 .872 r
.86655 .45305 .87646 .46272 .90468 .47367 .89507 .46515 Metetra
0 .284 .734 r
.89507 .46515 .90468 .47367 .93415 .49019 .92487 .48296 Metetra
0 .101 .558 r
.92487 .48296 .93415 .49019 .96512 .51316 .95622 .50738 Metetra
.662 .667 .844 r
.34983 .61572 .36314 .63419 .38529 .62705 .37205 .60849 Metetra
.674 .671 .839 r
.37205 .60849 .38529 .62705 .40765 .6188 .39449 .60019 Metetra
.685 .676 .835 r
.39449 .60019 .40765 .6188 .4302 .60946 .41713 .59086 Metetra
.695 .68 .832 r
.41713 .59086 .4302 .60946 .45293 .5991 .43995 .58056 Metetra
.703 .685 .829 r
.43995 .58056 .45293 .5991 .47582 .5878 .46293 .56938 Metetra
.711 .69 .828 r
.46293 .56938 .47582 .5878 .49884 .57569 .48606 .55742 Metetra
.717 .694 .828 r
.48606 .55742 .49884 .57569 .52199 .5629 .50931 .54484 Metetra
.721 .699 .828 r
.50931 .54484 .52199 .5629 .54524 .54961 .53269 .5318 Metetra
.725 .704 .83 r
.53269 .5318 .54524 .54961 .56861 .536 .55619 .5185 Metetra
.726 .709 .834 r
.55619 .5185 .56861 .536 .59209 .52229 .57979 .50515 Metetra
.725 .714 .839 r
.57979 .50515 .59209 .52229 .61567 .50873 .60353 .49199 Metetra
.722 .719 .847 r
.60353 .49199 .61567 .50873 .63939 .49559 .62739 .4793 Metetra
.716 .724 .856 r
.62739 .4793 .63939 .49559 .66326 .48314 .65142 .46735 Metetra
.705 .728 .869 r
.65142 .46735 .66326 .48314 .68731 .47171 .67565 .45648 Metetra
.688 .732 .884 r
.67565 .45648 .68731 .47171 .71159 .46163 .70012 .44701 Metetra
.663 .733 .902 r
.70012 .44701 .71159 .46163 .73616 .45328 .72488 .43933 Metetra
.625 .731 .923 r
.72488 .43933 .73616 .45328 .7611 .44707 .75002 .43384 Metetra
.569 .721 .945 r
.75002 .43384 .7611 .44707 .78648 .44342 .77563 .43098 Metetra
.485 .697 .962 r
.77563 .43098 .78648 .44342 .81242 .44283 .80181 .43126 Metetra
.36 .648 .965 r
.80181 .43126 .81242 .44283 .83906 .44583 .8287 .43523 Metetra
.183 .559 .933 r
.8287 .43523 .83906 .44583 .86655 .45305 .85647 .4435 Metetra
0 .419 .844 r
.85647 .4435 .86655 .45305 .89507 .46515 .8853 .45678 Metetra
0 .242 .695 r
.8853 .45678 .89507 .46515 .92487 .48296 .91544 .4759 Metetra
.474 0 0 r
.91544 .4759 .92487 .48296 .95622 .50738 .94716 .50181 Metetra
.662 .67 .847 r
.33634 .59733 .34983 .61572 .37205 .60849 .35864 .59002 Metetra
.674 .674 .842 r
.35864 .59002 .37205 .60849 .39449 .60019 .38117 .58168 Metetra
.684 .679 .839 r
.38117 .58168 .39449 .60019 .41713 .59086 .40389 .57236 Metetra
.694 .683 .835 r
.40389 .57236 .41713 .59086 .43995 .58056 .4268 .56211 Metetra
.702 .687 .833 r
.4268 .56211 .43995 .58056 .46293 .56938 .44988 .55103 Metetra
.709 .692 .832 r
.44988 .55103 .46293 .56938 .48606 .55742 .47311 .53924 Metetra
.715 .697 .832 r
.47311 .53924 .48606 .55742 .50931 .54484 .49648 .52686 Metetra
.719 .701 .833 r
.49648 .52686 .50931 .54484 .53269 .5318 .51998 .51408 Metetra
.722 .706 .835 r
.51998 .51408 .53269 .5318 .55619 .5185 .5436 .50108 Metetra
.723 .711 .839 r
.5436 .50108 .55619 .5185 .57979 .50515 .56734 .48808 Metetra
.721 .716 .845 r
.56734 .48808 .57979 .50515 .60353 .49199 .59121 .47533 Metetra
.717 .721 .852 r
.59121 .47533 .60353 .49199 .62739 .4793 .61524 .46308 Metetra
.71 .726 .863 r
.61524 .46308 .62739 .4793 .65142 .46735 .63943 .45164 Metetra
.697 .73 .875 r
.63943 .45164 .65142 .46735 .67565 .45648 .66382 .44132 Metetra
.679 .733 .891 r
.66382 .44132 .67565 .45648 .70012 .44701 .68847 .43246 Metetra
.651 .733 .91 r
.68847 .43246 .70012 .44701 .72488 .43933 .71343 .42545 Metetra
.609 .729 .931 r
.71343 .42545 .72488 .43933 .75002 .43384 .73878 .42069 Metetra
.547 .716 .951 r
.73878 .42069 .75002 .43384 .77563 .43098 .76461 .41864 Metetra
.454 .687 .966 r
.76461 .41864 .77563 .43098 .80181 .43126 .79103 .4198 Metetra
.318 .63 .962 r
.79103 .4198 .80181 .43126 .8287 .43523 .81818 .42473 Metetra
.13 .529 .917 r
.81818 .42473 .8287 .43523 .85647 .4435 .84622 .43408 Metetra
0 .38 .813 r
.84622 .43408 .85647 .4435 .8853 .45678 .87536 .44856 Metetra
0 .201 .656 r
.87536 .44856 .8853 .45678 .91544 .4759 .90583 .46902 Metetra
.51 0 0 r
.90583 .46902 .91544 .4759 .94716 .50181 .93794 .49644 Metetra
.663 .673 .85 r
.32268 .57904 .33634 .59733 .35864 .59002 .34506 .57163 Metetra
.674 .677 .846 r
.34506 .57163 .35864 .59002 .38117 .58168 .36766 .56325 Metetra
.684 .682 .842 r
.36766 .56325 .38117 .58168 .40389 .57236 .39048 .55393 Metetra
.693 .686 .839 r
.39048 .55393 .40389 .57236 .4268 .56211 .41348 .54374 Metetra
.701 .69 .837 r
.41348 .54374 .4268 .56211 .44988 .55103 .43666 .53277 Metetra
.707 .695 .836 r
.43666 .53277 .44988 .55103 .47311 .53924 .45999 .52113 Metetra
.713 .699 .836 r
.45999 .52113 .47311 .53924 .49648 .52686 .48347 .50896 Metetra
.716 .704 .837 r
.48347 .50896 .49648 .52686 .51998 .51408 .50709 .49643 Metetra
.719 .709 .84 r
.50709 .49643 .51998 .51408 .5436 .50108 .53084 .48373 Metetra
.719 .713 .844 r
.53084 .48373 .5436 .50108 .56734 .48808 .55471 .47108 Metetra
.717 .718 .85 r
.55471 .47108 .56734 .48808 .59121 .47533 .57873 .45873 Metetra
.712 .723 .858 r
.57873 .45873 .59121 .47533 .61524 .46308 .60291 .44694 Metetra
.703 .727 .869 r
.60291 .44694 .61524 .46308 .63943 .45164 .62726 .436 Metetra
.689 .731 .882 r
.62726 .436 .63943 .45164 .66382 .44132 .65183 .42623 Metetra
.668 .733 .899 r
.65183 .42623 .66382 .44132 .68847 .43246 .67666 .41799 Metetra
.637 .733 .917 r
.67666 .41799 .68847 .43246 .71343 .42545 .70181 .41165 Metetra
.591 .727 .938 r
.70181 .41165 .71343 .42545 .73878 .42069 .72736 .40762 Metetra
.522 .71 .957 r
.72736 .40762 .73878 .42069 .76461 .41864 .75341 .40638 Metetra
.42 .676 .968 r
.75341 .40638 .76461 .41864 .79103 .4198 .78007 .40844 Metetra
.273 .609 .955 r
.78007 .40844 .79103 .4198 .81818 .42473 .80747 .41435 Metetra
.076 .497 .897 r
.80747 .41435 .81818 .42473 .84622 .43408 .83579 .42479 Metetra
0 .34 .78 r
.83579 .42479 .84622 .43408 .87536 .44856 .86524 .44049 Metetra
0 .162 .616 r
.86524 .44049 .87536 .44856 .90583 .46902 .89605 .46232 Metetra
.543 .003 0 r
.89605 .46232 .90583 .46902 .93794 .49644 .92853 .4913 Metetra
.663 .677 .853 r
.30883 .56083 .32268 .57904 .34506 .57163 .33129 .55332 Metetra
.673 .681 .849 r
.33129 .55332 .34506 .57163 .36766 .56325 .35398 .54489 Metetra
.683 .685 .845 r
.35398 .54489 .36766 .56325 .39048 .55393 .37688 .53558 Metetra
.692 .689 .842 r
.37688 .53558 .39048 .55393 .41348 .54374 .39998 .52545 Metetra
.699 .693 .841 r
.39998 .52545 .41348 .54374 .43666 .53277 .42326 .51458 Metetra
.705 .697 .84 r
.42326 .51458 .43666 .53277 .45999 .52113 .4467 .50309 Metetra
.71 .702 .84 r
.4467 .50309 .45999 .52113 .48347 .50896 .47029 .49112 Metetra
.714 .706 .842 r
.47029 .49112 .48347 .50896 .50709 .49643 .49402 .47884 Metetra
.715 .711 .845 r
.49402 .47884 .50709 .49643 .53084 .48373 .5179 .46645 Metetra
.715 .716 .849 r
.5179 .46645 .53084 .48373 .55471 .47108 .54191 .45415 Metetra
.712 .72 .856 r
.54191 .45415 .55471 .47108 .57873 .45873 .56607 .4422 Metetra
.706 .725 .865 r
.56607 .4422 .57873 .45873 .60291 .44694 .5904 .43086 Metetra
.696 .729 .876 r
.5904 .43086 .60291 .44694 .62726 .436 .61491 .42042 Metetra
.681 .732 .889 r
.61491 .42042 .62726 .436 .65183 .42623 .63965 .41121 Metetra
.657 .734 .906 r
.63965 .41121 .65183 .42623 .67666 .41799 .66466 .40358 Metetra
.623 .732 .925 r
.66466 .40358 .67666 .41799 .70181 .41165 .69001 .39792 Metetra
.571 .724 .945 r
.69001 .39792 .70181 .41165 .72736 .40762 .71576 .39464 Metetra
.495 .703 .962 r
.71576 .39464 .72736 .40762 .75341 .40638 .74203 .39422 Metetra
.384 .662 .968 r
.74203 .39422 .75341 .40638 .78007 .40844 .76892 .39717 Metetra
.226 .586 .946 r
.76892 .39717 .78007 .40844 .80747 .41435 .79658 .40409 Metetra
.021 .463 .874 r
.79658 .40409 .80747 .41435 .83579 .42479 .82518 .41563 Metetra
0 .3 .744 r
.82518 .41563 .83579 .42479 .86524 .44049 .85493 .43257 Metetra
0 .124 .577 r
.85493 .43257 .86524 .44049 .89605 .46232 .88608 .4558 Metetra
.573 .033 0 r
.88608 .4558 .89605 .46232 .92853 .4913 .91894 .48637 Metetra
.663 .68 .856 r
.29478 .5427 .30883 .56083 .33129 .55332 .31733 .53509 Metetra
.673 .684 .852 r
.31733 .53509 .33129 .55332 .35398 .54489 .3401 .52662 Metetra
.682 .688 .849 r
.3401 .52662 .35398 .54489 .37688 .53558 .3631 .51731 Metetra
.69 .692 .846 r
.3631 .51731 .37688 .53558 .39998 .52545 .38629 .50723 Metetra
.697 .696 .844 r
.38629 .50723 .39998 .52545 .42326 .51458 .40967 .49646 Metetra
.703 .7 .844 r
.40967 .49646 .42326 .51458 .4467 .50309 .43321 .48512 Metetra
.708 .704 .844 r
.43321 .48512 .4467 .50309 .47029 .49112 .45692 .47335 Metetra
.711 .709 .846 r
.45692 .47335 .47029 .49112 .49402 .47884 .48077 .46132 Metetra
.712 .713 .85 r
.48077 .46132 .49402 .47884 .5179 .46645 .50477 .44923 Metetra
.711 .718 .855 r
.50477 .44923 .5179 .46645 .54191 .45415 .52892 .43728 Metetra
.707 .723 .862 r
.52892 .43728 .54191 .45415 .56607 .4422 .55323 .42573 Metetra
.7 .727 .871 r
.55323 .42573 .56607 .4422 .5904 .43086 .5777 .41484 Metetra
.689 .731 .882 r
.5777 .41484 .5904 .43086 .61491 .42042 .60237 .40491 Metetra
.671 .733 .897 r
.60237 .40491 .61491 .42042 .63965 .41121 .62728 .39626 Metetra
.645 .734 .914 r
.62728 .39626 .63965 .41121 .66466 .40358 .65247 .38925 Metetra
.607 .731 .933 r
.65247 .38925 .66466 .40358 .69001 .39792 .67801 .38426 Metetra
.55 .719 .952 r
.67801 .38426 .69001 .39792 .71576 .39464 .70397 .38174 Metetra
.467 .695 .966 r
.70397 .38174 .71576 .39464 .74203 .39422 .73045 .38214 Metetra
.345 .646 .966 r
.73045 .38214 .74203 .39422 .76892 .39717 .75758 .386 Metetra
.177 .56 .933 r
.75758 .386 .76892 .39717 .79658 .40409 .78549 .39393 Metetra
0 .427 .847 r
.78549 .39393 .79658 .40409 .82518 .41563 .81437 .4066 Metetra
0 .259 .707 r
.81437 .4066 .82518 .41563 .85493 .43257 .84442 .42481 Metetra
.454 0 0 r
.84442 .42481 .85493 .43257 .88608 .4558 .87591 .44947 Metetra
.6 .062 0 r
.87591 .44947 .88608 .4558 .91894 .48637 .90916 .48168 Metetra
.663 .684 .859 r
.28053 .52465 .29478 .5427 .31733 .53509 .30316 .51694 Metetra
.673 .687 .855 r
.30316 .51694 .31733 .53509 .3401 .52662 .32603 .50842 Metetra
.681 .691 .852 r
.32603 .50842 .3401 .52662 .3631 .51731 .34911 .49911 Metetra
.689 .694 .85 r
.34911 .49911 .3631 .51731 .38629 .50723 .3724 .48908 Metetra
.696 .698 .848 r
.3724 .48908 .38629 .50723 .40967 .49646 .39588 .47841 Metetra
.701 .703 .848 r
.39588 .47841 .40967 .49646 .43321 .48512 .41954 .46722 Metetra
.705 .707 .849 r
.41954 .46722 .43321 .48512 .45692 .47335 .44336 .45565 Metetra
.708 .711 .851 r
.44336 .45565 .45692 .47335 .48077 .46132 .46733 .44387 Metetra
.708 .716 .855 r
.46733 .44387 .48077 .46132 .50477 .44923 .49146 .43207 Metetra
.707 .72 .86 r
.49146 .43207 .50477 .44923 .52892 .43728 .51574 .42047 Metetra
.702 .725 .868 r
.51574 .42047 .52892 .43728 .55323 .42573 .54018 .40932 Metetra
.694 .729 .877 r
.54018 .40932 .55323 .42573 .5777 .41484 .56481 .39888 Metetra
.681 .732 .889 r
.56481 .39888 .5777 .41484 .60237 .40491 .58964 .38945 Metetra
.661 .734 .904 r
.58964 .38945 .60237 .40491 .62728 .39626 .61472 .38137 Metetra
.632 .734 .921 r
.61472 .38137 .62728 .39626 .65247 .38925 .64009 .37498 Metetra
.59 .728 .94 r
.64009 .37498 .65247 .38925 .67801 .38426 .66581 .37068 Metetra
.527 .714 .958 r
.66581 .37068 .67801 .38426 .70397 .38174 .69198 .36891 Metetra
.435 .684 .969 r
.69198 .36891 .70397 .38174 .73045 .38214 .71868 .37015 Metetra
.304 .627 .962 r
.71868 .37015 .73045 .38214 .75758 .386 .74603 .37494 Metetra
.125 .531 .917 r
.74603 .37494 .75758 .386 .78549 .39393 .7742 .38389 Metetra
0 .39 .818 r
.7742 .38389 .78549 .39393 .81437 .4066 .80335 .39771 Metetra
0 .22 .668 r
.80335 .39771 .81437 .4066 .84442 .42481 .8337 .41721 Metetra
.49 0 0 r
.8337 .41721 .84442 .42481 .87591 .44947 .86553 .44334 Metetra
.624 .088 0 r
.86553 .44334 .87591 .44947 .90916 .48168 .89916 .47722 Metetra
.663 .687 .862 r
.26608 .50667 .28053 .52465 .30316 .51694 .28879 .49886 Metetra
.672 .69 .859 r
.28879 .49886 .30316 .51694 .32603 .50842 .31175 .49029 Metetra
.681 .694 .856 r
.31175 .49029 .32603 .50842 .34911 .49911 .33493 .48098 Metetra
.688 .697 .854 r
.33493 .48098 .34911 .49911 .3724 .48908 .35832 .47099 Metetra
.694 .701 .852 r
.35832 .47099 .3724 .48908 .39588 .47841 .3819 .46042 Metetra
.699 .705 .852 r
.3819 .46042 .39588 .47841 .41954 .46722 .40566 .44938 Metetra
.703 .709 .853 r
.40566 .44938 .41954 .46722 .44336 .45565 .42959 .438 Metetra
.705 .714 .856 r
.42959 .438 .44336 .45565 .46733 .44387 .45369 .42647 Metetra
.704 .718 .86 r
.45369 .42647 .46733 .44387 .49146 .43207 .47794 .41497 Metetra
.702 .723 .866 r
.47794 .41497 .49146 .43207 .51574 .42047 .50236 .40372 Metetra
.696 .727 .874 r
.50236 .40372 .51574 .42047 .54018 .40932 .52694 .39296 Metetra
.687 .731 .884 r
.52694 .39296 .54018 .40932 .56481 .39888 .55172 .38298 Metetra
.672 .734 .896 r
.55172 .38298 .56481 .39888 .58964 .38945 .57671 .37406 Metetra
.65 .735 .911 r
.57671 .37406 .58964 .38945 .61472 .38137 .60195 .36653 Metetra
.618 .733 .928 r
.60195 .36653 .61472 .38137 .64009 .37498 .6275 .36077 Metetra
.571 .726 .947 r
.6275 .36077 .64009 .37498 .66581 .37068 .65341 .35716 Metetra
.502 .708 .963 r
.65341 .35716 .66581 .37068 .69198 .36891 .67977 .35616 Metetra
.402 .672 .97 r
.67977 .35616 .69198 .36891 .71868 .37015 .70669 .35824 Metetra
.26 .607 .954 r
.70669 .35824 .71868 .37015 .74603 .37494 .73428 .36397 Metetra
.073 .5 .897 r
.73428 .36397 .74603 .37494 .7742 .38389 .76269 .37397 Metetra
0 .351 .785 r
.76269 .37397 .7742 .38389 .80335 .39771 .79211 .38896 Metetra
0 .181 .63 r
.79211 .38896 .80335 .39771 .8337 .41721 .82277 .40977 Metetra
.524 0 0 r
.82277 .40977 .8337 .41721 .86553 .44334 .85494 .4374 Metetra
.647 .113 0 r
.85494 .4374 .86553 .44334 .89916 .47722 .88895 .47301 Metetra
.663 .691 .865 r
.2514 .48876 .26608 .50667 .28879 .49886 .27421 .48085 Metetra
.672 .694 .862 r
.27421 .48085 .28879 .49886 .31175 .49029 .29726 .47222 Metetra
.68 .697 .859 r
.29726 .47222 .31175 .49029 .33493 .48098 .32053 .46291 Metetra
.687 .7 .857 r
.32053 .46291 .33493 .48098 .35832 .47099 .34402 .45297 Metetra
.692 .704 .856 r
.34402 .45297 .35832 .47099 .3819 .46042 .3677 .44249 Metetra
.697 .708 .857 r
.3677 .44249 .3819 .46042 .40566 .44938 .39157 .43159 Metetra
.7 .712 .858 r
.39157 .43159 .40566 .44938 .42959 .438 .41562 .42042 Metetra
.701 .716 .861 r
.41562 .42042 .42959 .438 .45369 .42647 .43983 .40913 Metetra
.7 .721 .865 r
.43983 .40913 .45369 .42647 .47794 .41497 .46421 .39792 Metetra
.697 .725 .871 r
.46421 .39792 .47794 .41497 .50236 .40372 .48876 .38702 Metetra
.69 .729 .88 r
.48876 .38702 .50236 .40372 .52694 .39296 .51349 .37666 Metetra
.68 .732 .89 r
.51349 .37666 .52694 .39296 .55172 .38298 .53841 .36713 Metetra
.663 .735 .903 r
.53841 .36713 .55172 .38298 .57671 .37406 .56356 .35872 Metetra
.638 .735 .918 r
.56356 .35872 .57671 .37406 .60195 .36653 .58897 .35176 Metetra
.603 .732 .936 r
.58897 .35176 .60195 .36653 .6275 .36077 .61469 .34662 Metetra
.551 .722 .953 r
.61469 .34662 .6275 .36077 .65341 .35716 .64079 .34371 Metetra
.475 .7 .967 r
.64079 .34371 .65341 .35716 .67977 .35616 .66735 .34348 Metetra
.365 .658 .969 r
.66735 .34348 .67977 .35616 .70669 .35824 .69448 .34642 Metetra
.214 .584 .944 r
.69448 .34642 .70669 .35824 .73428 .36397 .72229 .3531 Metetra
.019 .467 .874 r
.72229 .3531 .73428 .36397 .76269 .37397 .75095 .36416 Metetra
0 .312 .75 r
.75095 .36416 .76269 .37397 .79211 .38896 .78065 .38034 Metetra
0 .143 .591 r
.78065 .38034 .79211 .38896 .82277 .40977 .81161 .40251 Metetra
.555 .011 0 r
.81161 .40251 .82277 .40977 .85494 .4374 .84411 .43167 Metetra
.667 .136 0 r
.84411 .43167 .85494 .4374 .88895 .47301 .87851 .46905 Metetra
.663 .694 .869 r
.2365 .47091 .2514 .48876 .27421 .48085 .2594 .4629 Metetra
.671 .697 .865 r
.2594 .4629 .27421 .48085 .29726 .47222 .28254 .45422 Metetra
.679 .7 .863 r
.28254 .45422 .29726 .47222 .32053 .46291 .30591 .4449 Metetra
.685 .703 .861 r
.30591 .4449 .32053 .46291 .34402 .45297 .3295 .435 Metetra
.69 .707 .86 r
.3295 .435 .34402 .45297 .3677 .44249 .35329 .42462 Metetra
.694 .711 .861 r
.35329 .42462 .3677 .44249 .39157 .43159 .37727 .41386 Metetra
.697 .715 .863 r
.37727 .41386 .39157 .43159 .41562 .42042 .40143 .40288 Metetra
.697 .719 .866 r
.40143 .40288 .41562 .42042 .43983 .40913 .42576 .39184 Metetra
.696 .723 .871 r
.42576 .39184 .43983 .40913 .46421 .39792 .45027 .38093 Metetra
.692 .727 .877 r
.45027 .38093 .46421 .39792 .48876 .38702 .47495 .37037 Metetra
.684 .731 .886 r
.47495 .37037 .48876 .38702 .51349 .37666 .49982 .36041 Metetra
.672 .734 .897 r
.49982 .36041 .51349 .37666 .53841 .36713 .52489 .35133 Metetra
.653 .736 .91 r
.52489 .35133 .53841 .36713 .56356 .35872 .55019 .34343 Metetra
.626 .735 .926 r
.55019 .34343 .56356 .35872 .58897 .35176 .57576 .33704 Metetra
.586 .73 .943 r
.57576 .33704 .58897 .35176 .61469 .34662 .60166 .33254 Metetra
.529 .718 .959 r
.60166 .33254 .61469 .34662 .64079 .34371 .62794 .33033 Metetra
.445 .691 .97 r
.62794 .33033 .64079 .34371 .66735 .34348 .6547 .33087 Metetra
.327 .642 .966 r
.6547 .33087 .66735 .34348 .69448 .34642 .68203 .33468 Metetra
.165 .558 .931 r
.68203 .33468 .69448 .34642 .72229 .3531 .71007 .34232 Metetra
0 .432 .848 r
.71007 .34232 .72229 .3531 .75095 .36416 .73898 .35446 Metetra
0 .272 .714 r
.73898 .35446 .75095 .36416 .78065 .38034 .76895 .37186 Metetra
.437 0 0 r
.76895 .37186 .78065 .38034 .81161 .40251 .80021 .39541 Metetra
.583 .04 0 r
.80021 .39541 .81161 .40251 .84411 .43167 .83305 .42615 Metetra
.685 .158 0 r
.83305 .42615 .84411 .43167 .87851 .46905 .86783 .46535 Metetra
.664 .698 .872 r
.22136 .45313 .2365 .47091 .2594 .4629 .24435 .44502 Metetra
.671 .7 .869 r
.24435 .44502 .2594 .4629 .28254 .45422 .26759 .43627 Metetra
.678 .703 .866 r
.26759 .43627 .28254 .45422 .30591 .4449 .29106 .42694 Metetra
.684 .706 .865 r
.29106 .42694 .30591 .4449 .3295 .435 .31475 .41709 Metetra
.688 .71 .865 r
.31475 .41709 .3295 .435 .35329 .42462 .33864 .4068 Metetra
.692 .714 .865 r
.33864 .4068 .35329 .42462 .37727 .41386 .36273 .39618 Metetra
.694 .717 .867 r
.36273 .39618 .37727 .41386 .40143 .40288 .38701 .38539 Metetra
.694 .721 .871 r
.38701 .38539 .40143 .40288 .42576 .39184 .41146 .37459 Metetra
.691 .725 .876 r
.41146 .37459 .42576 .39184 .45027 .38093 .4361 .36397 Metetra
.686 .729 .883 r
.4361 .36397 .45027 .38093 .47495 .37037 .46091 .35376 Metetra
.677 .733 .892 r
.46091 .35376 .47495 .37037 .49982 .36041 .48591 .3442 Metetra
.663 .735 .903 r
.48591 .3442 .49982 .36041 .52489 .35133 .51113 .33558 Metetra
.642 .736 .917 r
.51113 .33558 .52489 .35133 .55019 .34343 .53659 .32819 Metetra
.612 .734 .933 r
.53659 .32819 .55019 .34343 .57576 .33704 .56232 .32237 Metetra
.568 .728 .949 r
.56232 .32237 .57576 .33704 .60166 .33254 .58839 .3185 Metetra
.505 .712 .964 r
.58839 .3185 .60166 .33254 .62794 .33033 .61485 .31701 Metetra
.414 .68 .972 r
.61485 .31701 .62794 .33033 .6547 .33087 .6418 .31834 Metetra
.286 .624 .96 r
.6418 .31834 .6547 .33087 .68203 .33468 .66935 .32302 Metetra
.115 .53 .914 r
.66935 .32302 .68203 .33468 .71007 .34232 .69761 .33164 Metetra
0 .395 .819 r
.69761 .33164 .71007 .34232 .73898 .35446 .72676 .34489 Metetra
0 .234 .677 r
.72676 .34489 .73898 .35446 .76895 .37186 .75699 .36353 Metetra
.474 0 0 r
.75699 .36353 .76895 .37186 .80021 .39541 .78855 .38848 Metetra
.608 .067 0 r
.78855 .38848 .80021 .39541 .83305 .42615 .82172 .42084 Metetra
.649 .109 0 r
.82172 .42084 .83305 .42615 .86783 .46535 .8563 .45607 Metetra
.664 .701 .875 r
.20598 .43541 .22136 .45313 .24435 .44502 .22907 .42719 Metetra
.671 .704 .872 r
.22907 .42719 .24435 .44502 .26759 .43627 .2524 .41838 Metetra
.677 .707 .87 r
.2524 .41838 .26759 .43627 .29106 .42694 .27597 .40904 Metetra
.682 .71 .869 r
.27597 .40904 .29106 .42694 .31475 .41709 .29976 .39923 Metetra
.686 .713 .869 r
.29976 .39923 .31475 .41709 .33864 .4068 .32376 .38902 Metetra
.689 .716 .87 r
.32376 .38902 .33864 .4068 .36273 .39618 .34796 .37855 Metetra
.69 .72 .872 r
.34796 .37855 .36273 .39618 .38701 .38539 .37235 .36795 Metetra
.69 .724 .876 r
.37235 .36795 .38701 .38539 .41146 .37459 .39693 .35739 Metetra
.686 .728 .882 r
.39693 .35739 .41146 .37459 .4361 .36397 .42169 .34706 Metetra
.68 .731 .889 r
.42169 .34706 .4361 .36397 .46091 .35376 .44663 .3372 Metetra
.67 .734 .898 r
.44663 .3372 .46091 .35376 .48591 .3442 .47177 .32804 Metetra
.654 .736 .91 r
.47177 .32804 .48591 .3442 .51113 .33558 .49713 .31987 Metetra
.631 .737 .924 r
.49713 .31987 .51113 .33558 .53659 .32819 .52274 .31299 Metetra
.597 .733 .94 r
.52274 .31299 .53659 .32819 .56232 .32237 .54863 .30775 Metetra
.549 .724 .956 r
.54863 .30775 .56232 .32237 .58839 .3185 .57487 .30453 Metetra
.479 .705 .968 r
.57487 .30453 .58839 .3185 .61485 .31701 .60151 .30374 Metetra
.38 .668 .971 r
.60151 .30374 .61485 .31701 .6418 .31834 .62866 .30587 Metetra
.243 .603 .952 r
.62866 .30587 .6418 .31834 .66935 .32302 .6564 .31144 Metetra
.064 .5 .894 r
.6564 .31144 .66935 .32302 .69761 .33164 .68489 .32106 Metetra
0 .358 .787 r
.68489 .32106 .69761 .33164 .72676 .34489 .71428 .33543 Metetra
0 .196 .639 r
.71428 .33543 .72676 .34489 .75699 .36353 .74478 .35533 Metetra
.508 0 0 r
.74478 .35533 .75699 .36353 .78855 .38848 .77662 .38174 Metetra
.631 .093 0 r
.77662 .38174 .78855 .38848 .82172 .42084 .81013 .41576 Metetra
.482 0 0 r
.81013 .41576 .82172 .42084 .8563 .45607 .84373 .4388 Metetra
.664 .705 .878 r
.19034 .41775 .20598 .43541 .22907 .42719 .21353 .40941 Metetra
.67 .707 .876 r
.21353 .40941 .22907 .42719 .2524 .41838 .23697 .40054 Metetra
.676 .71 .874 r
.23697 .40054 .2524 .41838 .27597 .40904 .26064 .39119 Metetra
.68 .713 .873 r
.26064 .39119 .27597 .40904 .29976 .39923 .28453 .38141 Metetra
.684 .716 .873 r
.28453 .38141 .29976 .39923 .32376 .38902 .30864 .37129 Metetra
.686 .719 .874 r
.30864 .37129 .32376 .38902 .34796 .37855 .33295 .36096 Metetra
.687 .723 .877 r
.33295 .36096 .34796 .37855 .37235 .36795 .35745 .35055 Metetra
.685 .726 .881 r
.35745 .35055 .37235 .36795 .39693 .35739 .38215 .34023 Metetra
.681 .73 .887 r
.38215 .34023 .39693 .35739 .42169 .34706 .40703 .33019 Metetra
.674 .733 .895 r
.40703 .33019 .42169 .34706 .44663 .3372 .4321 .32067 Metetra
.662 .736 .905 r
.4321 .32067 .44663 .3372 .47177 .32804 .45738 .31191 Metetra
.644 .737 .917 r
.45738 .31191 .47177 .32804 .49713 .31987 .48288 .30419 Metetra
.618 .737 .931 r
.48288 .30419 .49713 .31987 .52274 .31299 .50864 .29783 Metetra
.581 .732 .946 r
.50864 .29783 .52274 .31299 .54863 .30775 .53469 .29317 Metetra
.528 .72 .961 r
.53469 .29317 .54863 .30775 .57487 .30453 .5611 .2906 Metetra
.452 .697 .972 r
.5611 .2906 .57487 .30453 .60151 .30374 .58792 .29054 Metetra
.344 .653 .969 r
.58792 .29054 .60151 .30374 .62866 .30587 .61525 .29347 Metetra
.197 .58 .941 r
.61525 .29347 .62866 .30587 .6564 .31144 .64319 .29995 Metetra
.013 .467 .872 r
.64319 .29995 .6564 .31144 .68489 .32106 .6719 .31058 Metetra
0 .32 .753 r
.6719 .31058 .68489 .32106 .71428 .33543 .70152 .32608 Metetra
0 .159 .601 r
.70152 .32608 .71428 .33543 .74478 .35533 .73228 .34729 Metetra
.539 0 0 r
.73228 .34729 .74478 .35533 .77662 .38174 .76442 .37517 Metetra
.652 .116 0 r
.76442 .37517 .77662 .38174 .81013 .41576 .79826 .41091 Metetra
0 .405 .721 r
.79826 .41091 .81013 .41576 .84373 .4388 .83091 .42119 Metetra
.664 .709 .881 r
.17444 .40013 .19034 .41775 .21353 .40941 .19773 .39168 Metetra
.669 .711 .879 r
.19773 .39168 .21353 .40941 .23697 .40054 .22127 .38275 Metetra
.674 .713 .877 r
.22127 .38275 .23697 .40054 .26064 .39119 .24504 .37338 Metetra
.679 .716 .877 r
.24504 .37338 .26064 .39119 .28453 .38141 .26904 .36363 Metetra
.682 .719 .877 r
.26904 .36363 .28453 .38141 .30864 .37129 .29325 .35361 Metetra
.683 .722 .879 r
.29325 .35361 .30864 .37129 .33295 .36096 .31767 .34341 Metetra
.683 .725 .882 r
.31767 .34341 .33295 .36096 .35745 .35055 .34229 .33318 Metetra
.681 .729 .887 r
.34229 .33318 .35745 .35055 .38215 .34023 .36711 .3231 Metetra
.675 .732 .893 r
.36711 .3231 .38215 .34023 .40703 .33019 .39211 .31336 Metetra
.667 .735 .901 r
.39211 .31336 .40703 .33019 .4321 .32067 .41732 .30418 Metetra
.653 .737 .911 r
.41732 .30418 .4321 .32067 .45738 .31191 .44273 .29582 Metetra
.633 .738 .924 r
.44273 .29582 .45738 .31191 .48288 .30419 .46837 .28856 Metetra
.605 .736 .938 r
.46837 .28856 .48288 .30419 .50864 .29783 .49428 .28271 Metetra
.564 .73 .953 r
.49428 .28271 .50864 .29783 .53469 .29317 .52049 .27864 Metetra
.505 .715 .966 r
.52049 .27864 .53469 .29317 .5611 .2906 .54705 .27671 Metetra
.422 .687 .973 r
.54705 .27671 .5611 .2906 .58792 .29054 .57404 .27739 Metetra
.306 .637 .965 r
.57404 .27739 .58792 .29054 .61525 .29347 .60156 .28114 Metetra
.15 .554 .927 r
.60156 .28114 .61525 .29347 .64319 .29995 .6297 .28853 Metetra
0 .434 .846 r
.6297 .28853 .64319 .29995 .6719 .31058 .65862 .30019 Metetra
0 .282 .718 r
.65862 .30019 .6719 .31058 .70152 .32608 .68848 .31686 Metetra
.423 0 0 r
.68848 .31686 .70152 .32608 .73228 .34729 .71949 .33939 Metetra
.567 .021 0 r
.71949 .33939 .73228 .34729 .76442 .37517 .75192 .3688 Metetra
.671 .138 0 r
.75192 .3688 .76442 .37517 .79826 .41091 .78608 .4063 Metetra
.288 .766 .929 r
.78608 .4063 .79826 .41091 .83091 .42119 .81783 .40322 Metetra
.664 .713 .884 r
.15826 .38257 .17444 .40013 .19773 .39168 .18166 .37399 Metetra
.669 .714 .882 r
.18166 .37399 .19773 .39168 .22127 .38275 .20529 .365 Metetra
.673 .716 .881 r
.20529 .365 .22127 .38275 .24504 .37338 .22917 .35561 Metetra
.677 .719 .881 r
.22917 .35561 .24504 .37338 .26904 .36363 .25328 .3459 Metetra
.679 .722 .882 r
.25328 .3459 .26904 .36363 .29325 .35361 .2776 .33595 Metetra
.68 .725 .884 r
.2776 .33595 .29325 .35361 .31767 .34341 .30213 .32589 Metetra
.679 .728 .887 r
.30213 .32589 .31767 .34341 .34229 .33318 .32687 .31584 Metetra
.676 .731 .892 r
.32687 .31584 .34229 .33318 .36711 .3231 .3518 .306 Metetra
.669 .734 .899 r
.3518 .306 .36711 .3231 .39211 .31336 .37693 .29655 Metetra
.659 .737 .907 r
.37693 .29655 .39211 .31336 .41732 .30418 .40226 .28771 Metetra
.644 .739 .918 r
.40226 .28771 .41732 .30418 .44273 .29582 .42781 .27976 Metetra
.622 .738 .93 r
.42781 .27976 .44273 .29582 .46837 .28856 .45359 .27295 Metetra
.59 .735 .944 r
.45359 .27295 .46837 .28856 .49428 .28271 .47964 .26763 Metetra
.545 .727 .958 r
.47964 .26763 .49428 .28271 .52049 .27864 .506 .26414 Metetra
.481 .709 .97 r
.506 .26414 .52049 .27864 .54705 .27671 .53272 .26288 Metetra
.39 .676 .974 r
.53272 .26288 .54705 .27671 .57404 .27739 .55989 .26429 Metetra
.265 .618 .958 r
.55989 .26429 .57404 .27739 .60156 .28114 .58758 .26887 Metetra
.102 .527 .91 r
.58758 .26887 .60156 .28114 .6297 .28853 .61592 .27719 Metetra
0 .398 .817 r
.61592 .27719 .6297 .28853 .65862 .30019 .64504 .2899 Metetra
0 .244 .682 r
.64504 .2899 .65862 .30019 .68848 .31686 .67513 .30776 Metetra
.46 0 0 r
.67513 .30776 .68848 .31686 .71949 .33939 .70639 .33165 Metetra
.593 .048 0 r
.70639 .33165 .71949 .33939 .75192 .3688 .7391 .36262 Metetra
.616 .067 0 r
.7391 .36262 .75192 .3688 .78608 .4063 .77304 .39487 Metetra
.618 .85 .987 r
.77304 .39487 .78608 .4063 .81783 .40322 .80449 .3849 Metetra
.664 .716 .887 r
.1418 .36504 .15826 .38257 .18166 .37399 .1653 .35635 Metetra
.668 .718 .886 r
.1653 .35635 .18166 .37399 .20529 .365 .18904 .34728 Metetra
.672 .72 .885 r
.18904 .34728 .20529 .365 .22917 .35561 .21302 .33787 Metetra
.675 .722 .885 r
.21302 .33787 .22917 .35561 .25328 .3459 .23724 .32819 Metetra
.677 .725 .886 r
.23724 .32819 .25328 .3459 .2776 .33595 .26167 .31833 Metetra
.677 .728 .888 r
.26167 .31833 .2776 .33595 .30213 .32589 .28631 .30839 Metetra
.675 .731 .892 r
.28631 .30839 .30213 .32589 .32687 .31584 .31116 .29854 Metetra
.671 .734 .897 r
.31116 .29854 .32687 .31584 .3518 .306 .33621 .28893 Metetra
.663 .736 .904 r
.33621 .28893 .3518 .306 .37693 .29655 .36146 .27976 Metetra
.652 .739 .913 r
.36146 .27976 .37693 .29655 .40226 .28771 .38692 .27128 Metetra
.634 .74 .924 r
.38692 .27128 .40226 .28771 .42781 .27976 .4126 .26372 Metetra
.61 .739 .937 r
.4126 .26372 .42781 .27976 .45359 .27295 .43852 .25738 Metetra
.575 .734 .95 r
.43852 .25738 .45359 .27295 .47964 .26763 .46471 .25258 Metetra
.525 .723 .964 r
.46471 .25258 .47964 .26763 .506 .26414 .49122 .24968 Metetra
.455 .702 .973 r
.49122 .24968 .506 .26414 .53272 .26288 .5181 .24908 Metetra
.356 .663 .972 r
.5181 .24908 .53272 .26288 .55989 .26429 .54543 .25124 Metetra
.223 .598 .949 r
.54543 .25124 .55989 .26429 .58758 .26887 .5733 .25666 Metetra
.052 .497 .89 r
.5733 .25666 .58758 .26887 .61592 .27719 .60182 .26593 Metetra
0 .362 .786 r
.60182 .26593 .61592 .27719 .64504 .2899 .63115 .27971 Metetra
0 .207 .645 r
.63115 .27971 .64504 .2899 .67513 .30776 .66146 .29879 Metetra
.494 0 0 r
.66146 .29879 .67513 .30776 .70639 .33165 .69297 .32407 Metetra
.616 .074 0 r
.69297 .32407 .70639 .33165 .7391 .36262 .72595 .35664 Metetra
.41 0 0 r
.72595 .35664 .7391 .36262 .77304 .39487 .75918 .37637 Metetra
.645 .763 .934 r
.75918 .37637 .77304 .39487 .80449 .3849 .79088 .36619 Metetra
.664 .72 .891 r
.12503 .34756 .1418 .36504 .1653 .35635 .14864 .33874 Metetra
.668 .721 .889 r
.14864 .33874 .1653 .35635 .18904 .34728 .17249 .3296 Metetra
.671 .723 .889 r
.17249 .3296 .18904 .34728 .21302 .33787 .19658 .32017 Metetra
.673 .725 .889 r
.19658 .32017 .21302 .33787 .23724 .32819 .2209 .31052 Metetra
.674 .728 .89 r
.2209 .31052 .23724 .32819 .26167 .31833 .24545 .30073 Metetra
.673 .731 .893 r
.24545 .30073 .26167 .31833 .28631 .30839 .2702 .29093 Metetra
.67 .733 .897 r
.2702 .29093 .28631 .30839 .31116 .29854 .29516 .28125 Metetra
.665 .736 .903 r
.29516 .28125 .31116 .29854 .33621 .28893 .32033 .27188 Metetra
.656 .738 .91 r
.32033 .27188 .33621 .28893 .36146 .27976 .3457 .263 Metetra
.643 .74 .919 r
.3457 .263 .36146 .27976 .38692 .27128 .37128 .25486 Metetra
.624 .74 .93 r
.37128 .25486 .38692 .27128 .4126 .26372 .39709 .2477 Metetra
.597 .738 .943 r
.39709 .2477 .4126 .26372 .43852 .25738 .42315 .24182 Metetra
.558 .732 .956 r
.42315 .24182 .43852 .25738 .46471 .25258 .44948 .23755 Metetra
.503 .718 .968 r
.44948 .23755 .46471 .25258 .49122 .24968 .47613 .23525 Metetra
.427 .693 .975 r
.47613 .23525 .49122 .24968 .5181 .24908 .50317 .23532 Metetra
.32 .648 .969 r
.50317 .23532 .5181 .24908 .54543 .25124 .53066 .23824 Metetra
.178 .575 .937 r
.53066 .23824 .54543 .25124 .5733 .25666 .55869 .24451 Metetra
.003 .466 .867 r
.55869 .24451 .5733 .25666 .60182 .26593 .5874 .25474 Metetra
0 .326 .753 r
.5874 .25474 .60182 .26593 .63115 .27971 .61693 .26962 Metetra
0 .171 .608 r
.61693 .26962 .63115 .27971 .66146 .29879 .64745 .28993 Metetra
.525 0 0 r
.64745 .28993 .66146 .29879 .69297 .32407 .6792 .31664 Metetra
.638 .098 0 r
.6792 .31664 .69297 .32407 .72595 .35664 .71245 .35087 Metetra
0 .516 .805 r
.71245 .35087 .72595 .35664 .75918 .37637 .74504 .35749 Metetra
.645 .763 .934 r
.74504 .35749 .75918 .37637 .79088 .36619 .77698 .3471 Metetra
.664 .724 .894 r
.10796 .33011 .12503 .34756 .14864 .33874 .13168 .32117 Metetra
.667 .725 .893 r
.13168 .32117 .14864 .33874 .17249 .3296 .15564 .31195 Metetra
.669 .727 .893 r
.15564 .31195 .17249 .3296 .19658 .32017 .17984 .30249 Metetra
.671 .729 .893 r
.17984 .30249 .19658 .32017 .2209 .31052 .20427 .29286 Metetra
.671 .731 .895 r
.20427 .29286 .2209 .31052 .24545 .30073 .22892 .28315 Metetra
.669 .733 .898 r
.22892 .28315 .24545 .30073 .2702 .29093 .25379 .27348 Metetra
.666 .736 .902 r
.25379 .27348 .2702 .29093 .29516 .28125 .27886 .26398 Metetra
.659 .738 .908 r
.27886 .26398 .29516 .28125 .32033 .27188 .30414 .25484 Metetra
.649 .74 .916 r
.30414 .25484 .32033 .27188 .3457 .263 .32964 .24626 Metetra
.634 .741 .925 r
.32964 .24626 .3457 .263 .37128 .25486 .35534 .23846 Metetra
.613 .741 .937 r
.35534 .23846 .37128 .25486 .39709 .2477 .38128 .2317 Metetra
.583 .738 .949 r
.38128 .2317 .39709 .2477 .42315 .24182 .40746 .22629 Metetra
.54 .729 .962 r
.40746 .22629 .42315 .24182 .44948 .23755 .43393 .22255 Metetra
.48 .713 .972 r
.43393 .22255 .44948 .23755 .47613 .23525 .46073 .22084 Metetra
.397 .683 .976 r
.46073 .22084 .47613 .23525 .50317 .23532 .48791 .2216 Metetra
.282 .631 .963 r
.48791 .2216 .50317 .23532 .53066 .23824 .51555 .22528 Metetra
.133 .55 .922 r
.51555 .22528 .53066 .23824 .55869 .24451 .54376 .23242 Metetra
0 .433 .841 r
.54376 .23242 .55869 .24451 .5874 .25474 .57264 .24363 Metetra
0 .289 .719 r
.57264 .24363 .5874 .25474 .61693 .26962 .60236 .25962 Metetra
.413 0 0 r
.60236 .25962 .61693 .26962 .64745 .28993 .63309 .28121 Metetra
.553 .003 0 r
.63309 .28121 .64745 .28993 .6792 .31664 .66507 .30938 Metetra
.657 .12 0 r
.66507 .30938 .6792 .31664 .71245 .35087 .69859 .34531 Metetra
.431 .845 .965 r
.69859 .34531 .71245 .35087 .74504 .35749 .73061 .33822 Metetra
.645 .763 .934 r
.73061 .33822 .74504 .35749 .77698 .3471 .7628 .32762 Metetra
.664 .728 .897 r
.09057 .31269 .10796 .33011 .13168 .32117 .1144 .30362 Metetra
.666 .729 .896 r
.1144 .30362 .13168 .32117 .15564 .31195 .13847 .29432 Metetra
.668 .73 .896 r
.13847 .29432 .15564 .31195 .17984 .30249 .16278 .28484 Metetra
.668 .732 .897 r
.16278 .28484 .17984 .30249 .20427 .29286 .18732 .27523 Metetra
.668 .734 .899 r
.18732 .27523 .20427 .29286 .22892 .28315 .21208 .26559 Metetra
.665 .736 .903 r
.21208 .26559 .22892 .28315 .25379 .27348 .23706 .25604 Metetra
.661 .739 .907 r
.23706 .25604 .25379 .27348 .27886 .26398 .26224 .24673 Metetra
.653 .741 .914 r
.26224 .24673 .27886 .26398 .30414 .25484 .28764 .23782 Metetra
.642 .742 .922 r
.28764 .23782 .30414 .25484 .32964 .24626 .31325 .22952 Metetra
.625 .743 .932 r
.31325 .22952 .32964 .24626 .35534 .23846 .33908 .22207 Metetra
.601 .741 .943 r
.33908 .22207 .35534 .23846 .38128 .2317 .36514 .21572 Metetra
.568 .736 .955 r
.36514 .21572 .38128 .2317 .40746 .22629 .39145 .21077 Metetra
.521 .726 .967 r
.39145 .21077 .40746 .22629 .43393 .22255 .41805 .20756 Metetra
.455 .706 .975 r
.41805 .20756 .43393 .22255 .46073 .22084 .44498 .20647 Metetra
.365 .671 .974 r
.44498 .20647 .46073 .22084 .48791 .2216 .47231 .20791 Metetra
.242 .612 .955 r
.47231 .20791 .48791 .2216 .51555 .22528 .5001 .21236 Metetra
.086 .523 .905 r
.5001 .21236 .51555 .22528 .54376 .23242 .52847 .22038 Metetra
0 .399 .813 r
.52847 .22038 .54376 .23242 .57264 .24363 .55752 .23259 Metetra
0 .253 .684 r
.55752 .23259 .57264 .24363 .60236 .25962 .58742 .24972 Metetra
.449 0 0 r
.58742 .24972 .60236 .25962 .63309 .28121 .61835 .27261 Metetra
.579 .031 0 r
.61835 .27261 .63309 .28121 .66507 .30938 .65056 .30229 Metetra
.542 0 0 r
.65056 .30229 .66507 .30938 .69859 .34531 .68379 .32926 Metetra
.639 .805 .963 r
.68379 .32926 .69859 .34531 .73061 .33822 .71587 .31855 Metetra
.645 .763 .934 r
.71587 .31855 .73061 .33822 .7628 .32762 .74832 .30772 Metetra
.664 .732 .9 r
.07283 .29529 .09057 .31269 .1144 .30362 .09678 .28609 Metetra
.665 .732 .9 r
.09678 .28609 .1144 .30362 .13847 .29432 .12096 .27671 Metetra
.666 .734 .9 r
.12096 .27671 .13847 .29432 .16278 .28484 .14538 .2672 Metetra
.666 .735 .901 r
.14538 .2672 .16278 .28484 .18732 .27523 .17003 .25761 Metetra
.665 .737 .904 r
.17003 .25761 .18732 .27523 .21208 .26559 .19491 .24804 Metetra
.661 .739 .908 r
.19491 .24804 .21208 .26559 .23706 .25604 .21999 .23862 Metetra
.656 .741 .913 r
.21999 .23862 .23706 .25604 .26224 .24673 .2453 .22948 Metetra
.647 .743 .919 r
.2453 .22948 .26224 .24673 .28764 .23782 .27081 .2208 Metetra
.634 .744 .928 r
.27081 .2208 .28764 .23782 .31325 .22952 .29653 .21279 Metetra
.615 .744 .938 r
.29653 .21279 .31325 .22952 .33908 .22207 .32248 .20568 Metetra
.588 .741 .949 r
.32248 .20568 .33908 .22207 .36514 .21572 .34866 .19974 Metetra
.551 .735 .961 r
.34866 .19974 .36514 .21572 .39145 .21077 .37509 .19526 Metetra
.5 .722 .971 r
.37509 .19526 .39145 .21077 .41805 .20756 .40182 .19259 Metetra
.429 .698 .977 r
.40182 .19259 .41805 .20756 .44498 .20647 .42889 .19211 Metetra
.331 .657 .972 r
.42889 .19211 .44498 .20647 .47231 .20791 .45635 .19424 Metetra
.201 .592 .945 r
.45635 .19424 .47231 .20791 .5001 .21236 .48429 .19949 Metetra
.038 .494 .884 r
.48429 .19949 .5001 .21236 .52847 .22038 .51281 .2084 Metetra
0 .365 .783 r
.51281 .2084 .52847 .22038 .55752 .23259 .54202 .22163 Metetra
0 .217 .648 r
.54202 .22163 .55752 .23259 .58742 .24972 .5721 .23991 Metetra
.482 0 0 r
.5721 .23991 .58742 .24972 .61835 .27261 .60322 .26414 Metetra
.603 .056 0 r
.60322 .26414 .61835 .27261 .65056 .30229 .63564 .29537 Metetra
0 .314 .668 r
.63564 .29537 .65056 .30229 .68379 .32926 .66849 .3094 Metetra
.645 .763 .934 r
.66849 .3094 .68379 .32926 .71587 .31855 .70082 .29846 Metetra
.645 .763 .934 r
.70082 .29846 .71587 .31855 .74832 .30772 .73353 .2874 Metetra
.664 .736 .903 r
.05475 .27792 .07283 .29529 .09678 .28609 .07881 .26858 Metetra
.665 .736 .903 r
.07881 .26858 .09678 .28609 .12096 .27671 .10311 .25912 Metetra
.665 .737 .904 r
.10311 .25912 .12096 .27671 .14538 .2672 .12765 .24957 Metetra
.664 .738 .906 r
.12765 .24957 .14538 .2672 .17003 .25761 .15241 .24 Metetra
.661 .74 .908 r
.15241 .24 .17003 .25761 .19491 .24804 .17739 .2305 Metetra
.657 .742 .912 r
.17739 .2305 .19491 .24804 .21999 .23862 .20259 .2212 Metetra
.65 .743 .918 r
.20259 .2212 .21999 .23862 .2453 .22948 .228 .21224 Metetra
.64 .745 .925 r
.228 .21224 .2453 .22948 .27081 .2208 .25363 .20379 Metetra
.625 .745 .933 r
.25363 .20379 .27081 .2208 .29653 .21279 .27946 .19606 Metetra
.604 .744 .943 r
.27946 .19606 .29653 .21279 .32248 .20568 .30552 .1893 Metetra
.575 .74 .955 r
.30552 .1893 .32248 .20568 .34866 .19974 .33182 .18376 Metetra
.534 .732 .966 r
.33182 .18376 .34866 .19974 .37509 .19526 .35838 .17975 Metetra
.478 .717 .975 r
.35838 .17975 .37509 .19526 .40182 .19259 .38523 .17763 Metetra
.4 .689 .978 r
.38523 .17763 .40182 .19259 .42889 .19211 .41242 .17776 Metetra
.295 .642 .967 r
.41242 .17776 .42889 .19211 .45635 .19424 .44002 .1806 Metetra
.158 .569 .932 r
.44002 .1806 .45635 .19424 .48429 .19949 .4681 .18665 Metetra
0 .463 .861 r
.4681 .18665 .48429 .19949 .51281 .2084 .49676 .19647 Metetra
0 .329 .751 r
.49676 .19647 .51281 .2084 .54202 .22163 .52613 .21073 Metetra
0 .182 .613 r
.52613 .21073 .54202 .22163 .5721 .23991 .55637 .23021 Metetra
.513 0 0 r
.55637 .23021 .5721 .23991 .60322 .26414 .58767 .25581 Metetra
.625 .08 0 r
.58767 .25581 .60322 .26414 .63564 .29537 .62029 .28862 Metetra
.185 .685 .913 r
.62029 .28862 .63564 .29537 .66849 .3094 .65286 .28911 Metetra
.645 .763 .934 r
.65286 .28911 .66849 .3094 .70082 .29846 .68545 .27795 Metetra
.645 .763 .934 r
.68545 .27795 .70082 .29846 .73353 .2874 .71842 .26665 Metetra
.664 .739 .906 r
.0363 .26056 .05475 .27792 .07881 .26858 .06049 .25108 Metetra
.664 .74 .907 r
.06049 .25108 .07881 .26858 .10311 .25912 .0849 .24153 Metetra
.663 .74 .908 r
.0849 .24153 .10311 .25912 .12765 .24957 .10955 .23195 Metetra
.661 .742 .91 r
.10955 .23195 .12765 .24957 .15241 .24 .13442 .22239 Metetra
.658 .743 .913 r
.13442 .22239 .15241 .24 .17739 .2305 .15951 .21296 Metetra
.652 .744 .917 r
.15951 .21296 .17739 .2305 .20259 .2212 .18482 .20378 Metetra
.644 .746 .923 r
.18482 .20378 .20259 .2212 .228 .21224 .21035 .19499 Metetra
.632 .747 .93 r
.21035 .19499 .228 .21224 .25363 .20379 .23608 .18677 Metetra
.616 .746 .939 r
.23608 .18677 .25363 .20379 .27946 .19606 .26203 .17933 Metetra
.593 .745 .949 r
.26203 .17933 .27946 .19606 .30552 .1893 .2882 .17291 Metetra
.56 .739 .96 r
.2882 .17291 .30552 .1893 .33182 .18376 .31461 .16778 Metetra
.516 .729 .97 r
.31461 .16778 .33182 .18376 .35838 .17975 .34129 .16425 Metetra
.454 .71 .978 r
.34129 .16425 .35838 .17975 .38523 .17763 .36826 .16267 Metetra
.37 .678 .977 r
.36826 .16267 .38523 .17763 .41242 .17776 .39557 .16343 Metetra
.258 .625 .96 r
.39557 .16343 .41242 .17776 .44002 .1806 .42329 .16698 Metetra
.113 .544 .916 r
.42329 .16698 .44002 .1806 .4681 .18665 .4515 .17384 Metetra
0 .432 .836 r
.4515 .17384 .4681 .18665 .49676 .19647 .4803 .18459 Metetra
0 .294 .718 r
.4803 .18459 .49676 .19647 .52613 .21073 .50981 .19991 Metetra
.404 0 0 r
.50981 .19991 .52613 .21073 .55637 .23021 .54021 .2206 Metetra
.541 0 0 r
.54021 .2206 .55637 .23021 .58767 .25581 .57168 .24761 Metetra
.616 .067 0 r
.57168 .24761 .58767 .25581 .62029 .28862 .60444 .27967 Metetra
.587 .889 .99 r
.60444 .27967 .62029 .28862 .65286 .28911 .6369 .26839 Metetra
.645 .763 .934 r
.6369 .26839 .65286 .28911 .68545 .27795 .66975 .25698 Metetra
.645 .763 .934 r
.66975 .25698 .68545 .27795 .71842 .26665 .70298 .24544 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(0.5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(1)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1.5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.562},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jB000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00a?ooool5o`0005Oooooo0035ooooo`04o`000?oo
ooooooooo`0005Oooooo0036ooooo`03o`000?oooooooooo05Oooooo0037ooooo`03o`000?oooooo
oooo05Kooooo0034ooooo`05o`000?ooooooooooooooool00000Eoooool00<Cooooo00Go0000oooo
ooooooooooooo`000007ooooo`;o0000C_ooool00<Gooooo0ol00007ooooo`04o`000?oooooooooo
o`0004gooooo003?ooooo`04o`000?ooooooooooo`0004gooooo003?ooooo`04o`000?oooooooooo
o`0004gooooo003?ooooo`04o`000?ooooooooooo`0004gooooo003?ooooo`04o`000?oooooooooo
o`0004gooooo003:ooooo`;o00001?ooool2o`0004kooooo0037ooooo`?o000000?oooooo`000?oo
ool0Doooool00<Gooooo0_l00004ooooo`;o0000Doooool00<;ooooo0ol00006ooooo`03o`000?oo
oooo000005;ooooo002oooooo`?o00002Oooool00ol0003oooooo`00001Booooo`00_Oooool2o`00
00;ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool0001Aooooo`00^_ooool3o`00
00kooooo00Go0000ooooooooooooooooo`00001@ooooo`00^?ooool2o`00017ooooo00Go0000oooo
ooooooooooooo`00001@ooooo`00R_ooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`00
01cooooo0ol0000Cooooo`06o`000?ooooooooooo`000?oooooo0000Coooool008_ooooo00?o0000
ooooooooool01oooool01Ol0003ooooooooooooooooo000001Wooooo0_l00003ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1<ooooo`00Roooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Cooooo0ol0000Hooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0C?ooool008_ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Booooo`;o00006oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
04_ooooo002;ooooo`03o`000?oooooooooo00Oooooo1?l0000Booooo`Co00007Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo04_ooooo002:ooooo`;o00002Oooool00ol0003ooooo
ooooo`0@ooooo`?o00008Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04[ooooo
002;ooooo`03o`000?oooooooooo00Oooooo1Ol0000<ooooo`;o00009?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo04Wooooo002Sooooo`?o00009_ooool00ol0003oooooooooo`04
ooooo`;o0000Boooool00:7ooooo0_l00002ooooo`03o`000?oooooooooo02Cooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`18ooooo`00W_ooool3o`0002_ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`17ooooo`00W?ooool2o`0002kooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`17ooooo`00VOooool3o`00033ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`16ooooo`00Uoooool2o`0000?ooooo00?o0000ooooooooool0;Oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo04Gooooo002Dooooo`?o0000=Oooool00ol0
003oooooooooo`08ooooo`;o0000Aoooool0097ooooo0ol0000hooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool0A?ooool008oooooo0_l00002ooooo`03o`000?oooooooooo03Kooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`13ooooo`00S?ooool3o`0003gooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`13ooooo`00R_ooool2o`00043ooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`12ooooo`00J?ooool3o`0001cooooo0ol00012oooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool0@Oooool006Wooooo00?o0000oooooooo
ool06Oooool2o`0000?ooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo047ooooo001Yooooo`03o`000?oooooooooo01Kooooo0ol00017ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooool000002?ooool2o`0000Cooooo00?o0000ooooooooool0
0_ooool3o`0002cooooo001Yooooo`03o`000?oooooooooo01Cooooo0_l0001:ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool00007ooooo`05o`00
0?ooooooooooooooool00000:oooool006Wooooo00?o0000ooooooooool04Oooool3o`000003oooo
ool0003ooooo04Wooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`04ooooo`04o`00
0?ooooooooooo`0000_ooooo00?o0000ooooooooool0:Oooool006Sooooo0_l0000@ooooo`?o0000
Coooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo
00002oooool00ol0003oooooooooo`0Yooooo`00JOooool00ol0003oooooooooo`0<ooooo`;o0000
D_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo
00001oooool4o`0002cooooo001eooooo`?o0000E?ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0]ooooo`00
Loooool2o`0000?ooooo00?o0000ooooooooool0D_ooool00ol0003oooooooooo`0?ooooo`?o0000
1?ooool2o`0000Sooooo1Ol0000[ooooo`00L?ooool3o`0005[ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0looooo`00K_ooool2o`0005gooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0kooooo`00Joooool3o`000003ooooool0003ooooo05cooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`0jooooo`00J?ooool3o`0000Gooooo00?o0000oooooooo
ool0F_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo03[ooooo001Vooooo`;o0000
IOooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo03Wooooo001Sooooo`Go0000IOoo
ool00ol0003oooooooooo`0Cooooo`?o0000>_ooool0067ooooo0_l0001Zooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool0>?ooool003?ooooo0_l00004ooooo`03o`000?oooooooooo
00;ooooo0ol0000Mooooo`?o0000K?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo
03Oooooo000booooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000J
ooooo`?o0000K_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo03Kooooo000boooo
o`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool05Oooool3o`0000;ooooo00?o0000
ooooooooool02_oooolGo`0004_ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0f
ooooo`00<_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo01?ooooo0_l0000;
ooooo`Oo00001On4^_P00ol0003oM;GjogBenP04ogBenP03o`000?mN[O[oGZgj00CoGZgj00Co0000
od:OmOm2WoGo@Yoe1Ol00016ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0=Ooo
ool003;ooooo00Co0000oooooooooooo00001oooool4o`0001?ooooo0ol00007ooooo`Ko00001On?
_OD00ol0003oQ;[hohBjn005ohBjn003o`000?md]O[oM;Gj00CoM;Gj00?o0000oej]n_mN[OX01?mN
[OX00ol0003o@Yoeod:Om@04od:Om@Co0000@oooool00ol0003oooooooooo`0Gooooo`?o0000=_oo
ool003;ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0Aooooo`?o00000_oo
ool00ol0003oooooooooo`02ooooo`?o00000onG__800ol0003oSkgeohnmm@06ohnmm@03o`000?n4
^_SoQ;[h00GoQ;[h00?o0000ogBen_md]OX01?md]OX00ol0003oGZgjoej]nP04oej]nP03o`000?m2
WoGo@Yoe00Co@Yoe00?o0000oab;j_lLRnX01?l0000oooooo`03o`000?oooooooooo01Wooooo00?o
0000ooooooooool0=?ooool003?ooooo0_l00008ooooo`Go00003Oooool2o`0000Kooooo1?l00007
oiNnlP03o`000?n?_OGoSkge00KoSkge00?o0000ohBjn?n4^_P00_n4^_PKo`0000;o78_Z1Ol0000k
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0<oooool004cooooo0ol00005oooo
o`?o00001?nM__000ol0003oUkkboiNnlP05oiNnlP03o`000?n?_OGoSkge00CoSkge1_l00004ohRk
m`03o`000?mj]oWoN[Oi00CoN[Oi00?o0000ofJ`n_mV/?X01OmV/?X00ol0003oBjCgod^Tm`04od^T
m`Ko00000_l0K]H3o`0003Sooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0coooo
o`00B_ooool2o`000004ooooool0003o0000ooooo`Co00002?nM__000ol0003oUkkboiNnlP05oiNn
lP03o`000?n?_OGoSkge00?o00000onC_O@00ol0003oR;_gohRkm`05ohRkm`03o`000?mj]oWoN[Oi
00CoN[Oi00?o0000ofJ`n_mV/?X01OmV/?X00ol0003oBjCgod^Tm`04od^Tm`04o`000?lXTNko:97^
obRAkP?o00000_l0K]H3o`0003Kooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0b
ooooo`00Aoooool3o`0000?ooooo0ol00003oj6okP03o`000?nM__3oWKk`00OoWKk`00?o0000oiNn
l_nG__800_nG__85o`0000OoTkgd00?o0000ohRkmon8^oL01On8^oL00ol0003oN[OiogZgn@04ogZg
n@03o`000?mV/?[oI[3j00;oI[3j2?l00002od^Tm`03o`000?lXTNko:97^00?o:97^1?l000000ol0
BkOo0000o`00000dooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0<Oooool004Go
oooo0_l00003ooooo`?o00001onQ_nh00ol0003oWKk`oifnl006oifnl0Go00001?nJ__400ol0003o
Tkgdoi>mm006oi>mm003o`000?n8^oOoR;_g00;oR;_g3_l00005offbnP03o`000?mDZ?SoE:Sh00So
000000?o:97^o`000?l0M]`00_l00002o`1;]`;o0000<_ooool00ol0003oooooooooo`0Kooooo`;o
0000<oooool004;ooooo1?l00002ooooo`;o00000_nT_^`00ol0003oXKo^oj6okP06oj6okP03o`00
0?nM__3oWKk`00;oWKk`0ol000000onO_^ko0000oiZnl@07oiZnl@03o`000?nC_OCoTkgd00CoTkgd
1_l00004ohflmP03o`000?mo^?SoOkSh00GoOkSh00?o0000offbn_m]/_X01Om]/_X00ol0003oE:Sh
oeBXn003oeBXn004o`000?lcUo7o<iOaoc>Gl@Co000000?o07KLo`000?l000000_l0BkL2o`00033o
oooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0`ooooo`00@?ooool2o`0000Cooooo
0_l00005ojBnk003o`000?nQ_nkoXKo^00KoXKo^00Co0000oifnl?l0003o00001OnO_^h00ol0003o
V[kaoiZnl@06oiZnl@03o`000?nC_OCoTkgd00?o00000_nF_O800ol0003oSKcfohflmP06ohflmP03
o`000?mo^?SoOkSh00GoOkSh00?o0000offbn_m]/_X01Om]/_X00ol0003oE:ShoeBXn003oeBXn003
o`000?lcUo7o<iOa00?o<iOa1ol000000ol0BkOo0000ooooo`0^ooooo`03o`000?oooooooooo01ko
oooo00?o0000ooooooooool0;oooool003gooooo0ol00003ooooo`?o00002?nT_^`00ol0003oXKo^
oj6okP04oj6okP?o00002?nO_^h00ol0003oV[kaoiZnl@04oiZnl@Co00001_nF_O800ol0003oSKcf
ohflmP06ohflmP03o`000?mo^?SoOkSh00GoOkSh00?o0000offbn_m]/_X00_m]/_X8o`000003oeBX
n?l0003o<iOa00Co<iOa00?o0000o`Unh_l9O^801_l0000^ooooo`03o`000?oooooooooo01kooooo
00?o0000ooooooooool0;oooool003[ooooo1?l00002ooooo`?o00000onV_^X00ol0003oY;k/ojBn
k006ojBnk003o`000?nQ_nkoXKo^00?o00000onS_^`00ol0003oWkk^oinnkP06oinnkP03o`000?nJ
__7oV[ka00?o00001?nM__000ol0003oU[gboiJmlP04oiJmlP03o`000?n=_?KoSKcf00CoSKcf3_l0
0004ogBdn@04o`000?mMZoWoGJ_ioef[n@Oo000000?o<iOao`000?l9O^800ol9O^82o`000003o`1D
`?l0003o000002gooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0^ooooo`00>?oo
ool2o`0000;ooooo1?l00007ojJnjP03o`000?nT_^coY;k/00CoY;k/1?l00007oj>nk003o`000?nO
_^koWkk^00CoWkk^1?l00008oifnl003o`000?nF_O;oU[gb00CoU[gb00?o0000ohflm_n=_?H00ol0
0004oi6lm003o`000?n5^OOoQKWg00CoQKWg00?o0000ogBdnOmd]?T01Omd]?T00ol0003oGJ_ioef[
n@04oef[n@03o`000?lmW?Co?Icd00Go00000ol9O^85o`0002_ooooo00?o0000ooooooooool07ooo
ool00ol0003oooooooooo`0]ooooo`005oooool2o`0001cooooo0ol000001?oooooo0000o`000?l0
0003ojRnj@03o`000?nV_^[oY[kZ00KoY[kZ00?o0000ojBnk?nT_^`00ol00004ojJnj`03o`000?nS
_^coXkk/00GoXkk/00?o0000oinnk_nO_^h00ol00004oj:nk@03o`000?nM__3oWKk`00KoWKk`00Co
0000oiJml_nF_O;oU[gb1Ol00008oi6lm003o`000?n5^OOoQKWg00CoQKWg00?o0000ogBdnOmd]?T0
1Omd]?T00ol0003oGJ_ioef[n@04oef[n@03o`000?lmW?Co?Icd00?o?Icd1_l000001?l0GLSo0000
o`000?l0000Zooooo`03o`000?oooooooooo01kooooo0_l00007ooooo`?o00009Oooool001Kooooo
00Co0000oooooooooooo00006Oooool6o`0000OoZ;kY00?o0000ojJnj_nV_^X01OnV_^X3o`0000So
Y[k[00?o0000oj>nk?nS_^`01?nS_^`3o`0000SoX[k]00?o0000oifnl?nM__001?nM__05o`0000Go
VKga00?o0000oi6lm?nA_?@01_nA_?@00ol0003oQKWgohFim`04ohFim`03o`000?md]?WoM;Ci00;o
M;Ci3ol000000olmW?Co0000oaJ5i`02oaJ5i`?o000000Co05g8o`000?l0003o0000:?ooool00ol0
003oooooooooo`0Pooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool09?ooool001Ko
oooo00Co0000oooooooooooo00005_ooool6o`0000;oZKgX00?o0000ojRnjOnX_^T01_nX_^T00ol0
003oY[kZojJnjP02ojJnjP;o00000_nX_NT00ol0003oY[k[ojJnj`07ojJnj`03o`000?nS_^coXkk/
00?o00000_nU_^/00ol0003oX[k]oj:nk@07oj:nk@03o`000?nM__3oWKk`00?o00000_nO_^h00ol0
003oVKgaoiVml@06oiVml@03o`000?nA_?CoTKcd00CoTKcd3Ol00004ogZfn003o`000?mU[_WoIJki
00CoIJki00Co0000odRQm_m8XOKoB:7f1Ol00003oaJ5i`Go00009oooool00ol0003oooooooooo`0Q
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool09?ooool001Kooooo00Co0000oooo
oooooooo00005?ooool2o`000003ooooool0003o000000KoZKgX00?o0000ojRnjOnX_^T01_nX_^T0
1?l0003oY[kZo`000?l00005ojRmj@03o`000?nV_^_oY[k[00KoY[k[0ol00006ojFnj`03o`000?nR
_^goX[k]00KoX[k]0ol00006oinnkP03o`000?nI_O7oVKga00KoVKga00?o0000oi6lm?nA_?@00ol0
0002oiFllP03o`000?n:^_KoR[[f00KoR[[f00?o0000ogZfn?mj]_P01?mj]_P00ol0003oIJkiofF^
n@04ofF^n@03o`000?m8XOKoB:7f00?oB:7f00?o0000ob:<k?l000001?l000000ol0I]3o0000o`00
0002o`0002Gooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo02Cooooo000Fooooo`04o`000?ooooooooooo`00017ooooo0ol000000ooooooo0000o`00
0009ojVmj003o`000?nX_^WoZ;kY00CoZ;kY0ol00008ojRmj@03o`000?nV_^_oY[k[00;oY[k[0ol0
00000onW_NWo0000ojFnj`07ojFnj`03o`000?nR_^goX[k]00;oX[k]0ol000000onT_Nco0000oinn
kP07oinnkP03o`000?nI_O7oVKga00CoVKga1?l00006oiFllP03o`000?n:^_KoR[[f00KoR[[f00?o
0000ogZfn?mj]_P01?mj]_P00ol0003oIJkiofF^n@04ofF^n@03o`000?m8XOKoB:7f00?oB:7f00?o
0000ob:<k?lRS>`00_lRS>`3o`000003o`1Vd?l0003o000000;o00008oooool00ol0003ooooooooo
o`0Rooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool09?ooool001Kooooo00Co0000
oooooooooooo00003oooool2o`0000;ooooo0_l00002ojVmj003o`000?nY_NSoZKgX00OoZKgX00?o
0000ojRnjOnX_^T00ol00003ojVmj003o`000?nX_NWoZ;gY00KoZ;gY00Co0000ojJnjol0003o0000
1OnW_NT00ol0003oYKk[ojFnj`06ojFnj`04o`000?nR_^go0000o`0000GoY;g/00?o0000oinnk_nO
_^h01_nO_^h00ol0003oVKgaoiVml@03o`0000?oW;g_00?o0000oiFll_nE_?801OnE_?800ol0003o
R[[fohZjmP04ohZjmQGo000000?oB:7fo`000?lRS>`01OlRS>`6o`0002;ooooo00?o0000oooooooo
ool08oooool01?l0003oooooooooooooool2o`0002Kooooo000Gooooo`;o00003Oooool3o`0000;o
oooo0_l00005ojVmj003o`000?nY_NSoZKgX00KoZKgX0ol00007ojVmj003o`000?nX_NWoZ;gY00Co
Z;gY0ol00008ojNmj@03o`000?nU_^_oYKk[00CoYKk[0ol00008ojBmk003o`000?nO_^koWkk^00Co
Wkk^1?l00007oibmk`03o`000?nE_?;oUKcb00GoUKcb00?o0000ohZjm_n:^_H00ol00003ohjkm003
o`000?n0]oOoP;Og00CoP;Og00?o0000offanOm]/OT01?m]/OT01?l0003oDJGhoe6Un?mAYOP7o`00
00;o8Xc/00?o0000o`1^eol000001?l0000Pooooo`03o`000?oooooooooo027ooooo0ol00004oooo
o`03o`000?oooooooooo02Cooooo000Sooooo`?o00000_ooool4o`0000OoZKgX00?o0000ojVmj?nY
_NP00_nY_NP3o`0000;oZKcW00?o0000ojVmj?nY_NP01_nY_NP00ol0003oZ;gYojRmj@03o`0000?o
ZKgX00?o0000ojNmjOnW_NT01_nW_NT00ol0003oYKk[ojFnj`03o`0000?oYkgY00?o0000ojBmk?nT
_N`01_nT_N`00ol0003oWkk^oinnkP03o`0000?oX[g/00?o0000oibmkonL_Nl01_nL_Nl00ol0003o
UKcboiFllP02oiFllPGo00001on>^o@00ol0003oP;Ogoh2gm`04oh2gm`03o`000?m]/OWoKK7i00Co
KK7i00?o0000oe6Un?mAYOP01?mAYOP00ol0003o;I?_obfCk`06o`000004ohX00?l0003oP`00o`00
01oooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Xooooo`008Oooool2o`0000;o
oooo0ol00004ojVmj003o`000?nY_NSoZKgX00GoZKgX00Co0000ojVmj?l0003o00001_nY_>L00ol0
003oZKgXojVmj005ojVmj0?o00001onY_NP00ol0003oYkgYojNmj@04ojNmj@Co00001onW_NT00ol0
003oY;g/ojBmk004ojBmk0Co00001onR_N`00ol0003oW;g_oibmk`04oibmk`Ko00001?nH_?400ol0
003oS[_dohjkm006ohjkm003o`000?n0]oOoP;Og00CoP;Og00?o0000offanOm]/OT01?m]/OT00ol0
003oDJGhoe6Un004oe6Un003o`000?l]Tnoo;I?_00?o;I?_1ol0000Mooooo`;o00009oooool00ol0
003oooooooooo`0Wooooo`007_ooool3o`000004ooooool0003o0000o`0000SoZKgX00?o0000ojVm
j?nY_NP01?nY_NP3o`0000SoZKcW00?o0000ojVmj?nY_NP00_nY_NP2o`0000;oZ[cW00?o0000ojVm
j?nY_NP01_nY_NP00ol0003oYkgYojNmj@03o`0000?oZKgX00?o0000ojNmjOnW_NT01_nW_NT00ol0
003oY;g/ojBmk003o`0000?oY[gZ00?o0000oj:mk?nR_N`01_nR_N`00ol0003oW;g_oibmk`03o`00
00?oWkg^00?o0000oiRllOnH_?401OnH_?400ol0003oS[_dohjkm004ohjkm1[o00000ol]Tnl00ol0
003o07OMo`000005o`0001Sooooo0ol000000onU`noo0000ooooo`0Vooooo`03o`000?oooooooooo
02Oooooo000Mooooo`;o000000?oooooo`000?l000000_nY_NL00ol0003oZKgXojVmj007ojVmj003
o`000?nY_NSoZKgX00?o00000onZ_>L00ol0003oZKcWojVli`06ojVli`04o`000?nY_NSo0000o`00
00GoZ[cW00?o0000ojVmj?nY_NP01OnY_NP3o`0000OoZKgX00?o0000ojNmjOnW_NT01OnW_NT3o`00
00OoY[gZ00?o0000oj:mk?nR_N`01?nR_N`4o`0000OoWkg^00?o0000oiRllOnH_?401OnH_?400ol0
003oS[_dohjkm003o`0000?oTk_c00?o0000ohJim_n6^OH01?n6^OH00ol0003oM;?iogBcn@05ogBc
n@03o`000?mKZOSoFjWh00?oFjWh00?o0000ocVIl_l000001?l000001?l0Mmgo0000oidA0?nM4@04
o`0001?ooooo0ol00005ojG3k`03o`000?oooooooooo02Gooooo00?o0000ooooooooool09_ooool0
01gooooo0ol00005ojVmi`03o`000?nY_NSoZKgX00KoZKgX0ol00007ojZli`03o`000?nY_>OoZKcW
00CoZKcW0ol00008ojZli`03o`000?nY_NSoZKgX00;oZKgX0_l00002ojZli`03o`000?nY_NSoZKgX
00KoZKgX00?o0000ojNmjOnW_NT00_nW_NT2o`0000;oZ;cX00?o0000ojJmj_nV_NX01_nV_NX00ol0
003oX[g/oj:mk003o`0000?oY;g[00?o0000oinmk_nO_Nh01_nO_Nh00ol0003oV;caoiRll@02oiRl
l@Go00001onC^o<00ol0003oQ[WfohJimP04ohJimP03o`000?md/oWoM;?i00GoM;?i00?o0000oe^Y
n?mKZOP00omKZOP00ol0003o>IWbocVIlP02ocVIlPCo000000?oWA40o`000?nO50001?l0000>oooo
o`?o00002OnU`nl00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo02Kooooo000Mooooo`;o
00001onY_NL00ol0003oZKgXojVmj002ojVmj0?o00000_nZ_>L00ol0003oZ[cWojZli`06ojZli`03
o`000?nY_>OoZKcW00?o00000_nZ_>H00ol0003oZ[cWojZli`07ojZli`04o`000?nY_NSo0000o`00
00GoZ[cW00?o0000ojVmj?nY_NP01_nY_NP01?l0003oYkgYo`000?l00005ojRlj003o`000?nV_N[o
Y[gZ00GoY[gZ0ol00007ojBmj`03o`000?nO_NkoWkg^00CoWkg^1_l00004oibmk`03o`000?nC^o?o
Tk_c00KoTk_c00?o0000ohJim_n6^OH01?n6^OH00ol0003oM;?iogBcn@02ogBcn@So000000?oFjWh
o`000?liVO801OliVO82o`000003oidA0?l0003oWa@000Co00002_ooool3o`0000;oYL?_00?o0000
ojG3konU`nl02?nU`nl00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo02Gooooo000Foooo
o`;o00001Oooool00ol0003oooooo`000007ojVmi`04o`000?nY_NSo0000o`0000KoZ[cW00?o0000
ojZlionZ_>L01OnZ_>L3o`0000KoZ[cV00?o0000ojZlionZ_>L01_nZ_>L2o`0000SoZ[cW00?o0000
ojVmj?nY_NP01?nY_NP3o`0000SoZ;cX00?o0000ojJmj_nV_NX00_nV_NX2o`000003ojNlj?l0003o
Y;g[00SoY;g[00?o0000oinmk_nO_Nh00ol00002oj:mk003o`000?nL_NooW;g_00KoW;g_00?o0000
oi>klonC^o<01?nC^o<=o`0000CoNkGh00Co0000of>]nOmS[OWoHjgi1ol00002ocVIlP;o000000?o
WA40o`000?nO50001?l00006ooooo`?o00001_nU`nl00ol0003oYL?_ojG3k`07ojG3k`;o00009_oo
ool00ol0003oooooooooo`0Tooooo`005Oooool01?l0003oooooooooool00003ooooo`05o`000?oo
oooo0000ooooool000001_nY_NL3o`0000SoZ[cW00?o0000ojZlionZ_>L00_nZ_>L2o`0000;oZ[_V
00?o0000ojZli_nZ_>H01OnZ_>H00ol0003oZ[cWojZli`02ojZli`?o000000?oZk_Vo`000?nZ_>L0
2?nZ_>L00ol0003oZKgXojVmj003o`0000?oZ[cV00?o0000ojRlj?nX_>P01_nX_>P01?l0003oY[gZ
o`000?l00004ojNlj003o`000?nT_N_oY;g[00KoY;g[0ol00006oj:mk003o`000?nL_NooW;g_00Ko
W;g_00?o0000oi>klonC^o<00ol00002oiNll@03o`000?n;^_GoRk[e00KoRk[e00?o0000og^en?mk
]OP01?mk]OP00ol0003oHjgiof>]n@04of>]n@03o`000?m3W_Go@ike00Go000000?oWA40o`000?nO
50001Ol000001?oooooo0000o`000?l0000:ojG3k`03o`000?nU`nooYL?_00?oYL?_0ol000000onU
`noo0000ooooo`0Uooooo`03o`000?oooooooooo02Cooooo000Eooooo`04o`000?ooooooooooo`00
00?ooooo0_l00003ooooo`03o`000?nY_NOoZKgW00?o00000onY_>L00ol0003oZ[cWojZli`06ojZl
i`04o`000?nZ_>Oo0000o`0000GoZ[_V00?o0000ojZli_nZ_>H01OnZ_>H01?l0003oZ[cWo`000?l0
0005oj^kiP03o`000?nZ_>OoZ[cW00KoZ[cW0ol00007ojZliP03o`000?nX_>SoZ;cX00CoZ;cX0ol0
0007ojNlj003o`000?nT_N_oY;g[00;oY;g[0ol000000onV_NWo0000oj:mk007oj:mk003o`000?nL
_NooW;g_00CoW;g_1?l00006oiNll@03o`000?n;^_GoRk[e00KoRk[e00?o0000og^en?mk]OP01?mk
]OP00ol0003oHjgiof>]n@04of>]n@03o`000?m3W_Go@ike00?o@ike0_l000001OnM4@3o0000oilD
0?l0003oVPh000Co000000?oU^?mo`000?nU`nl02_nU`nl00ol0003oYL?_o`000002o`0000GoYL?_
00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Sooooo`005Oooool01?l0003ooooooooo
ool00003ooooo`03o`000?oooooooooo00?ooooo0_l00007ojVli`03o`000?nZ_>OoZ[cW00CoZ[cW
0ol00008ojZkiP03o`000?nZ_>KoZ[cV00CoZ[cV0ol00007oj^kiP03o`000?nZ_>OoZ[cW00;oZ[cW
0ol000000on[^nGo0000ojZliP08ojZliP03o`000?nX_>SoZ;cX00?o00000onZ_>L00ol0003oYkcX
ojNlj005ojNlj004o`000?nT_N_o0000o`0000GoY[gY00?o0000oj:mk?nR_N`01_nR_N`00ol0003o
W;g_oibmk`03o`0000?oWkc^00?o0000oiNllOnG_?401OnG_?400ol0003oRk[eoh^jm@04oh^jmAGo
000000Co@ikeo`000?l0003oWA401?l00005oiKSo@03o`000?nU`nooYL?_00SoYL?_0_l00008ojG3
k`;o00009_ooool00ol0003oooooooooo`0Rooooo`005Oooool01?l0003oooooooooool00003oooo
o`;o00001Oooool00ol0003oZKcWojVli`06ojVli`03o`000?nZ_>OoZ[cW00?o00000_nZ^nH00ol0
003oZ[_VojZkiP07ojZkiP03o`000?nZ_>KoZ[cV00?o00000on[^nD00ol0003oZk_Voj^kiP05oj^k
iP04o`000?nZ_>Oo0000o`0000GoZk_U00?o0000ojZli_nZ_>H01_nZ_>H3o`0000OoZ[cW00?o0000
ojNlj?nW_>P01?nW_>P3o`0000OoY[gY00?o0000oj:mk?nR_N`01?nR_N`4o`0000OoWkc^00?o0000
oiNllOnG_?401OnG_?400ol0003oRk[eoh^jm@03o`0000?oT;[c00?o0000oh6gmon1]oL01?n1]oL0
0ol0003oK:oiofb_n@04ofb_n@04o`000?m>XoOoCZ?godjSm`Go00002OnFhod00ol0003oYL?_ojG3
k`04ojG3k`?o000000?oYL?_o`000?nU`nl02?nU`nl00ol0003oooooooooo`0Sooooo`;o00009?oo
ool001Gooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`03o`000?nY
_>OoZKcW00GoZKcW0ol00006ojZkiP03o`000?nZ^nKoZ[_V00KoZ[_V0ol00007oj^ki@03o`000?n[
^nKoZk_V00CoZk_V0ol00007oj^ki@03o`000?nZ_>KoZ[cV00;oZ[cV0ol000000on[^nGo0000ojZl
i`08ojZli`03o`000?nW_>SoYkcX00?o00000onY_>L00ol0003oY[gYojJmj@05ojJmj@03o`000?nR
_NcoX[g/00?o00000onT_N/00ol0003oWkc^oinlkP06oinlkP03o`000?nG_?7oUkca00;oUkca1Ol0
0007oi2jl`03o`000?n1]oOoPKOg00CoPKOg00?o0000ofb_nOm/[oT01?m/[oT00ol0003oCZ?go`00
0002o`0000;oCZ?g0ol00008oiKSo@03o`000?nU`nooYL?_00?o00001OnU`nl00ol0003oYL?_ojG3
k`07ojG3k`03o`000?oooooooooo02Cooooo00?o0000ooooooooool08Oooool001Kooooo0_l00004
ooooo`03o`000?oooooooooo00Kooooo00?o0000ojVlionY_>L00_nY_>L2o`0000;oZK_V00?o0000
ojZki_nZ^nH01OnZ^nH00ol0003oZ[_VojZkiP02ojZkiP?o000000?oZk[Uo`000?n[^nD02?n[^nD0
0ol0003oZk_Voj^kiP03o`0000?oZk_U00?o0000oj^kiOn[^nD01On[^nD01?l0003oZ[cVo`000?l0
0005oj^ki@03o`000?nZ_>OoZ[cW00KoZ[cW0ol00007ojVli`03o`000?nV_NWoY[gY00CoY[gY0ol0
0007ojBmj`03o`000?nO_>koWkc^00CoWkc^1_l00004oiZll003o`000?n@^_?oT;[c00KoT;[c00?o
0000oh6gmon1]oL01?n1]oL00ol0003oK:oiofb_n@02ofb_n@?o00001_m>XoL00ol0003o9Xg]o`00
000:o`0000WoYL?_00?o0000ojG3konU`nl01_nU`nl2o`0002Kooooo00?o0000ooooooooool08?oo
ool001_ooooo00?o0000ooooool000002?ooool01?l0003oZKcWo`000?l00005ojVkiP03o`000?nZ
^nKoZ[_V00GoZ[_V00Co0000ojZki_l0003o00001On[^^D00ol0003oZk_Uoj^ki@06oj^ki@?o0000
1on[^nD00ol0003oZk_Uoj^ki@04oj^ki@?o00001on[^nD00ol0003oZ[cWojZli`02ojZli`?o0000
00?oZk_Uo`000?nY_>L02?nY_>L00ol0003oY[gYojJmj@03o`0000;oZ;cX00?o0000ojBmjonT_N/0
1_nT_N/00ol0003oWkc^oinlkP03o`0000?oX[c/00?o0000oiZll?nJ_?001OnJ_?000ol0003oT;[c
oi2jl`04oi2jlaco00001Ol_[nT00ol0003oYL?_ojG3k`08ojG3k`03o`000?nU`nooYL?_00?oYL?_
0ol000000onU`noo0000ooooo`0Uooooo`03o`000?oooooooooo023ooooo000Kooooo`;o00002_oo
ool00ol0003oZK_VojVkiP06ojVkiP03o`000?nZ^nKoZ[_V00CoZ[_V0ol00007oj^ji@03o`000?n[
^nGoZk_U00;oZk_U0ol000000on[^^Co0000oj^ki@08oj^ki@03o`000?n[^nGoZk_U00?o00000on/
^n@00ol0003oZk_Uoj^ki@05oj^ki@04o`000?nZ_>Oo0000o`0000GoZk_U00?o0000ojVlionY_>L0
1_nY_>L3o`0000KoZ;cX00?o0000ojBmjonT_N/01?nT_N/4o`0000OoX[c/00?o0000oiZll?nJ_?00
1OnJ_?000ol0003oT;[coi2jl`03o`0000;oU;_b00?o0000ohNhm_n7^?H00_n7^?H4o`0000KoLk;h
00?o0000oeRWn?mHYoP01?mHYoP00ol0003o<YC`o`000003o`0000Co;joY00?o0000ojG3konU`nl0
2?nU`nl00ol0003oYL?_o`000002o`0000GoYL?_00?o0000ooooooooool09?ooool00ol0003ooooo
ooooo`0Oooooo`006oooool00ol0003oooooooooo`0:ooooo`03o`000?nY^nKoZK_V00KoZK_V00?o
0000ojZki_nZ^nH00ol00003ojZji@03o`000?n[^^GoZk[U00GoZk[U00Co0000oj^kiOl0003o0000
1On[^^@00ol0003oZk_Uoj^ki@06oj^ki@?o00001on/^n@00ol0003oZk_Uoj^ki@04oj^ki@;o0000
2?n[^nD00ol0003oZKcWojVli`02ojVli`?o000000?oZk_Vo`000?nX_>P01onX_>P00ol0003oY;g[
ojBmj`03o`0000?oYkcY00?o0000oj:lk?nR_>`01_nR_>`00ol0003oV[c`oiZll002oiZll0Go0000
1_nD^o84o`0000CoQkSf00?o0000og>bn?mc/_P01?mc/_P00ol0003oF:OhoeRWn004oeRWn004o`00
0?lbU?3o<YC`oc:Dl0?o00000ol_[nT00ol0003oYL?_ojG3k`07ojG3k`;o00002OnU`nl00ol0003o
ooooooooo`0Sooooo`;o00008?ooool001_ooooo0ol0000;ooooo`03o`000?nY^nKoZK_V00CoZK_V
1?l00007ojZji@03o`000?n[^^GoZk[U00CoZk[U0ol00007oj^ji003o`000?n[^nGoZk_U00;oZk_U
0ol000000on/^^?o0000ojbki008ojbki003o`000?n[^nGoZk_U00?o00000_n/^n@00ol0003oZk_U
oj^ki@06oj^ki@04o`000?nY_>Oo0000o`0000GoZk_V00?o0000ojRlj?nX_>P01OnX_>P3o`0000Oo
YkcY00?o0000oj:lk?nR_>`01?nR_>`6o`0000?oW[c^00?o0000oiBkl_nD^o800onD^o84o`0000Co
QkSf3ol00002oeRWn003o`000?lbU?3o<YC`00?o<YC`1?l00006ojG3k`?o000000?oYL?_o`000?nU
`nl02OnU`nl00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo01kooooo000Kooooo`03o`00
0?oooooooooo00cooooo00?o0000ojVki_nY^nH00ol00002ojVji@03o`000?nZ^^GoZ[[U00OoZ[[U
00?o0000oj^jiOn[^^D00ol00003oj^ji003o`000?n[^^CoZk[T00GoZk[T00Co0000oj^kiOl0003o
00001On/^^<00ol0003o[;_Tojbki006ojbki0?o00001_n/^n@00ol0003oZk_Uoj^ki@04oj^ki@?o
00002?n[^nH00ol0003oZ;cXojRlj002ojRlj0;o000000?oZ[cVo`000?nW_>T02?nW_>T00ol0003o
X[c/oj:lk003o`0000?oY;cZ00?o0000oijlk_nN_>h01?nN_>h00ol0003oU;_boiBklP02o`0000;o
U;_b1_l00004ohbim003o`000?mj]?OoN[Cg00CoN[Cg00Co0000of6[n?mQZoSoHJ_h2?l000000olb
U?3o0000o`000002o`0000;oYL?_0ol00005ojG3k`03o`000?nU`nooYL?_00OoYL?_0_l0000Uoooo
o`03o`000?oooooooooo01gooooo0006ooooo`Go00000oooool2o`0000Cooooo0_l00005ooooo`03
o`000?oooooooooo00gooooo0_l00006ojVji@03o`000?nZ^^GoZ[[U00KoZ[[U0ol00007oj^ji003
o`000?n[^^CoZk[T00CoZk[T0_l00008ojbjh`03o`000?n/^nCo[;_T00;o[;_T0ol000000on]^^?o
0000ojbki007ojbki003o`000?n[^nGoZk_U00?o00000on]^n@00ol0003oZk_Voj^kiP06oj^kiP04
o`000?nX_>So0000o`0000CoZ[cV00?o0000ojNljOnW_>T01_nW_>T3o`0000OoY;cZ00?o0000oijl
k_nN_>h00onN_>h3o`000004oiBkl_l0003o0000o`0000?oV;_`00?o0000ohbim?n<^O@01On<^O@0
0ol0003oN[CgogZdm`04ogZdm`03o`000?mQZoSoHJ_h00CoHJ_h00Co0000ocjJlolnV_?o?Y[c1?l0
00000ol0D:_o0000o`000009ojG3k`03o`000?nU`nooYL?_00?oYL?_0ol000000onU`noo0000oooo
o`0Uooooo`03o`000?oooooooooo01cooooo0007ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00ko
oooo00?o0000ojVjiOnY^^D01OnY^^D00ol0003oZ[[UojZji@02ojZji@?o000000?oZ[WTo`000?n[
^^@02?n[^^@00ol0003oZk[Toj^ji003o`000003ojbihol0003o[;[S00So[;[S00Co0000ojbki?l0
003o00001On]^^<00ol0003o[;_Tojbki005ojbki0?o00001on]^n@00ol0003oZk_Voj^kiP04oj^k
iP?o00001onZ_>H00ol0003oYkcYojNlj@02ojNlj@?o000000?oZKcWo`000?nT_>X02?nT_>X00ol0
003oW[c^o`000006o`0000OoV;_`00?o0000ohbim?n<^O@01On<^O@00ol0003oN[CgogZdm`04ogZd
m`03o`000?mQZoSoHJ_h00CoHJ_h00?o0000ocjJlolnV_<00olnV_<3o`0000_oYL?_00?o0000ojG3
kol000000_l00005ojG3k`03o`000?oooooooooo02?ooooo00?o0000ooooooooool07?ooool000So
oooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000?ooooo0ol0000@ooooo`03o`000?nY^^GoZK[U00GoZK[U00Co0000ojZjiOl0003o00001OnZ
^N@00ol0003oZk[Toj^ji006oj^ji0?o00001On/^N<00ol0003o[;[Sojbjh`06ojbjh`;o00002?n]
^^<00ol0003o[;_Tojbki002ojbki0;o000000?o[K[So`000?n]^n@02?n]^n@00ol0003oZk_Voj^k
iP03o`0000?o[;_T00?o0000ojZli_nZ_>H01OnZ_>H01?l0003oYkcYo`000?l00005ojVli`03o`00
0?nT_>[oY;cZ00GoY;cZ1Ol00004oj6lk003o`000?nH^o3oV;_`00KoV;_`00?o0000ohbim?n<^O@0
0_n<^O@Fo`000004ocjJlol0003o47oTo`0000[oYL?_0_l00009ojG3k`03o`000?oooooooooo02;o
oooo0_l00007ooooo`?o00001?ooool00ol0003oooooooooo`02ooooo`?o00001oooool000Wooooo
00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooo
ooooooooooooo`00000Cooooo`03o`000?nY^^GoZK[U00CoZK[U0ol00007ojZii003o`000?n[^^Co
Zk[T00;oZk[T0ol000000on[^N?o0000ojbih`06ojbih`03o`000?n/^^?o[;[S00;o[;[S0ol00000
0on]^N;o0000ojfjh`08ojfjh`04o`000?n/^nCo0000o`0000Co[K[S00?o0000ojfki?n]^n@01_n]
^n@3o`0000Oo[;_T00?o0000ojZli_nZ_>H01?nZ_>H2o`0000SoZKcW00Co0000ojBlj_nT_>[oY;cZ
1?l000000onW_>So0000oj6lk006oj6lk003o`000?nH^o3oV;_`00CoV;_`1_l00003oi6jlP03o`00
0?n1]_KoPKKf00GoPKKf00?o0000ofV^n?mY[_P01?mY[_P01?l0003oBIoeodVOmOm9WoD5o`0000Ko
YL?_0ol000000onSc_Ko0000ojG3k`08ojG3k`;o00009Oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`000006ooooo`001_ooool01Ol0003o
oooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo01;ooooo00?o0000ojVjiOnY^^D00ol00003ojVii003o`000?nZ
^NCoZ[WT00GoZ[WT00Co0000oj^ji?l0003o00001On[^N<00ol0003o[;WSojbih`05ojbih`04o`00
0?n/^^?o0000o`0000Go[KWR00?o0000ojfjhon]^^<01_n]^^<2o`0000Oo[K[S00?o0000ojfki?n]
^n@00_n]^n@3o`000003ojjjhol0003o[;_T00So[;_T00?o0000ojZli_nZ_>H00ol00002ojbki@03
o`000?nY_>OoZKcW00KoZKcW1?l00005ojNlj003o`000?nQ_>coXKc/00GoXKc/00?o0000oiRkl?nH
^o000ol00002oibkkP03o`000?nA^_;oTK[b00GoTK[b00?o0000oh6fm_n1]_H01On1]_H00ol0003o
JJkhofV^n004ofV^n003o`000?m9WoGoBIoe00CoBIoe0_l00002ojG3k`?o00001OnSc_H00ol0003o
YL?_ojG3k`07ojG3k`;o00009?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool01?ooool000Kooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool2o`0001Cooooo0_l00007
ojVii003o`000?nZ^NCoZ[WT00CoZ[WT0_l00008oj^ih`03o`000?n/^N?o[;WS00Co[;WS0ol00007
ojfihP03o`000?n]^^?o[K[S00;o[K[S0ol000000on^^N;o0000ojfjh`07ojfjh`04o`000?n]^nCo
0000o`0000Go[[[S00?o0000ojbki?n/^n@01_n/^n@3o`0000Ko[;_U00?o0000ojVlionY_>L00_nY
_>L5o`0000SoYkcX00?o0000oj6lk?nQ_>`00onQ_>`4o`0000KoW;_^00?o0000oi6jl_nA^_801OnA
^_800ol0003oPKKfoh6fmP02oh6fmPoo00000_m9WoD3o`0000WoXlkf00?o0000ojG3konU`nl00onU
`nl3o`000003ojG3kol0003ooooo02Cooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00Cooooo0007ooooo`?o00001?ooool2o`0000Cooooo0_l00004
ooooo`03o`000?oooooooooo01Cooooo00?o0000ojVii?nY^N@01_nY^N@00ol0003oZ[WTojZii003
o`0000;oZkSS00?o0000oj^ihon[^N<01_n[^N<00ol0003o[;WSojbih`03o`0000?o[;SR00?o0000
ojfih_n]^N801On]^N801?l0003o[K[So`000?l00005ojjihP03o`000?n]^^?o[K[S00Go[K[S0_l0
0008ojjjh`03o`000?n/^nCo[;_T00;o[;_T0ol000000on^^^?o0000ojbki@07ojbki@Ko00000on[
^nD00ol0003oYkcXojNlj005ojNlj003o`000?nQ_>coXKc/00?o00000onT_>X00ol0003oW;_^oibk
kP05oibkkP03o`000?nA^_;oTK[b00;oTK[b1ol00004ohNgm@03o`000?ma/?SoLK3h00CoLK3h00Co
0000oe>TmomCY?OoDjCg1Ol0000:oj?>mP03o`000?nU`noo000000;o00001?nU`nl2o`0002Cooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`07ooooo`Co00001oooool001[ooooo00?o
0000ooooooooool05Oooool00ol0003oZKWTojVii005ojVii0?o00001_n[^><00ol0003oZkWSoj^i
h`05oj^ih`?o00001on/^>800ol0003o[KWRojfihP04ojfihP;o00002?n^^N800ol0003o[K[Sojfj
h`02ojfjh`;o000000?o[[WQo`000?n^^^<02?n^^^<01?l0003o[;_To`000?l00005ojjjh`03o`00
0?n/^nGo[;_U00Co[;_U1?l00007oj^ki@03o`000?nW_>SoYkcX00CoYkcX0ol00007ojBljP03o`00
0?nL^nkoW;_^00CoW;_^1Ol00005oiJjl@03o`000?n7]oGoQkOe00CoQkOe00?o0000og6`n?ma/?P0
1?ma/?P00ol0003oDjCgoe>Tm`04oe>Tm`;o00002?nSc_H3o`0000SoYL?_0_l0000Tooooo`03o`00
0?oooooooooo00;ooooo0_l00009ooooo`03o`000?oooooooooo00Sooooo000Iooooo`?o00005ooo
ool00ol0003oZKWTojVii002ojVii0;o000000?oZKSTo`000?n[^><01on[^><00ol0003oZkWSoj^i
h`02oj^ih`;o000000?o[;SRo`000?n/^>802?n/^>800ol0003o[KWRojfihP03o`0000;o[KSQ00?o
0000ojjih_n^^N801_n^^N801?l0003o[K[So`000?l00004ojjih@03o`000?n^^^?o[[[S00Ko[[[S
0_l00008ojjjh`03o`000?n/^nGo[;_U00Co00000_n^^n<00ol0003oZk_Uoj^ki@06oj^ki@03o`00
0?nW_>SoYkcX00?o00000_nY_>L00ol0003oY;cZojBljP06ojBljP03o`000?nL^nkoW;_^00?o0000
0_nP_>d00ol0003oU[[aoiJjl@06oiJjl@03o`000?n7]oGoQkOe00CoQkOe00?o0000og6`n?ma/?P0
1?ma/?P00ol0003oDjCgoe>Tm`04oe>Tm`;o00000_nSc_H5o`0000;oK]Sg00?o0000ojG3konU`nl0
1onU`nl00ol0003oooooooooo`0Qooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool0
1oooool5o`0000Kooooo000Iooooo`03o`000?oooooooooo01Sooooo00Co0000ojVii?l0003o0000
1?nY^>@00ol0003oZkSSoj^hh`06oj^hh`04o`000?n[^N?o0000o`0000Co[;SR00?o0000ojbhh_n/
^>801_n/^>83o`0000Ko[KSQ00?o0000ojjih_n^^N801?n^^N83o`0000Oo[[WQ00?o0000ojjjhon^
^^<00_n^^^<3o`0000;o[kWQ00?o0000ojjjhon^^^<01On^^^<5o`0000Go[[_S00?o0000oj^kiOn[
^nD01?n[^nD4o`0000KoZKcW00?o0000ojBlj_nT_>X01?nT_>X4o`0000KoX;c]00?o0000oiJjlOnF
^_401?nF^_4Jo`0000SoK]Sg00?o0000ojG3konU`nl01onU`nl00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo01Oooooo000Iooooo`03o`000?oooooooooo01Wooooo00?o0000ojVhi?nY^>@0
1OnY^>@00ol0003oZkSSoj^hh`04oj^hh`?o00001on/^>800ol0003o[;SRojbhhP02ojbhhP?o0000
00?o[KSQo`000?n]^>401on]^>400ol0003o[[WRojjihP03o`0000?o[[SQ00?o0000ojjihOn^^N40
1On^^N401?l0003o[[[So`000?l00006ojnih@04o`000?n^^^?o[[[Sojjjh`Ko00002?n^^n<00ol0
003oZk_Uoj^ki@03o`0000;o[K_T00?o0000ojVlionY_>L01_nY_>L00ol0003oY;cZojBljP03o`00
00;oYkcX00?o0000oj2lkOnP_>d01_nP_>d00ol0003oU[[aoiJjl@03o`0000;oV[__00?o0000ohfh
lon=^?<01On=^?<00ol0003oNK?gogVcm`04ogVcm`03o`000?mMZ?SoGJSh00?oGJSh00?o0000ocJE
lOlfUO400_l00007ofkHm`03o`000?nU`nooYL?_00GoYL?_0ol0000Tooooo`03o`000?oooooooooo
01Kooooo000Iooooo`?o00006_ooool00ol0003oZKSTojVhi005ojVhi003o`000?n[^>?oZkSS00?o
00000on[]n800ol0003o[;SRojbhhP05ojbhhP04o`000?n/^>;o0000o`0000Go[KSQ00?o0000ojfh
hOn]^>401On]^>43o`0000Oo[[SQ00?o0000ojjihOn^^N401?n^^N42o`0000Wo[kWQ1_l00002ojnj
h@03o`000?n^^n?o[[_S00Ko[[_S0ol00006ojfki003o`000?nY_>OoZKcW00CoZKcW1?l00006ojNl
j003o`000?nP_>goX;c]00CoX;c]1?l00006oiZkk`03o`000?n=^??oSKSc00GoSKSc00?o0000ogVc
momi/oL01?mi/oL00ol0003oGJShoefXn003oefXn004o`000?lfUO7o=YGaocJEl@Ko00000_m^f?L0
0ol0003oYL?_ojG3k`04o`0000;oYL?_00?o0000ooooooooool08oooool00ol0003oooooooooo`0E
ooooo`001_ooool3o`0000?ooooo0_l00004ooooo`;o00001Oooool00ol0003oooooooooo`0Koooo
o`03o`000?nY^>CoZKST00CoZKST0ol00007oj^ghP03o`000?n/^>;o[;SR00Co[;SR0_l00008ojfh
h@03o`000?n]^>7o[KSQ00;o[KSQ0_l000000on^^>3o0000ojjhh@08ojjhh@03o`000?n^^N7o[[WQ
00?o00000_n_^N000ol0003o[kWQojnih@03ojnih@Ko00001_n_^^400ol0003o[[_Sojjkh`02ojjk
h`?o000000?o[k[Ro`000?n]^n@01on]^n@00ol0003oZKcWojVli`03o`0000?o[;_U00?o0000ojNl
j?nW_>P01OnW_>P00ol0003oX;c]oj2lk@03o`0000;oXkc[00?o0000oiZkkonJ^nl01_nJ^nl00ol0
003oSKScohfhl`02ohfhl`oo000000?oGJSho`000?lfUO401?lfUO42o`000003o`24c_l0003o0000
00?o00001onU`nl00ol0003oooooooooo`0Rooooo`;o00005_ooool000Oooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0Looooo`03o`000?nY^>CoZKST00?o00000_nY]n<00ol0003oZkORoj^ghP06
oj^ghP03o`000?n/^>;o[;SR00?o00000_n/]n400ol0003o[KSQojfhh@06ojfhh@04o`000?n]^>7o
0000o`0000Co[[SP00?o0000ojjhhOn^^>401_n^^>43o`0000Ko[kWP00?o0000ojnihOl000001Ol0
00000on`^N3o0000ojnjh@07ojnjh@04o`000?n^^n?o0000o`0000Go[k[R00?o0000ojfki?n]^n@0
1On]^n@3o`0000Oo[;_U00?o0000ojNlj?nW_>P01?nW_>P3o`0000KoXkc[00?o0000oiZkkonJ^nl0
1?nJ^nl6o`0000?oT[Wb00?o0000oh2em_n0]OH01On0]OH01?l0003oIZchofJ/n?mV[?P7o`0000;o
=YGa0_l00002o`24cP03o`000?nU`nooYL?_00OoYL?_00?o0000ooooooooool08Oooool2o`0001Ko
oooo0004ooooo`Go00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00?ooooo00?o0000ooooooooool07_ooool2o`0000KoZKOS00?o0000oj^gh_n[]n801On[]n83o`00
00Ko[;OQ00?o0000ojfhhOn]^>401On]^>42o`0000Oo[[SP00?o0000ojjhhOn^^>400_n^^>43o`00
0003ojnhgol0003o[kWP00Go[kWP0ol000000on_^N7o0000o`000005ok2ih003o`000?n_^^7o[k[Q
00Go[k[Q0_l00008ojnjhP03o`000?n]^nCo[K_T00;o[K_T0_l00002ojnkhP03o`000?n/^nGo[;_U
00Ko[;_U00?o0000ojNlj?nW_>P00ol00002ojVli`03o`000?nS_>_oXkc[00GoXkc[00?o0000oiZk
konJ^nl00ol00003oijkk@03o`000?nB^O;oT[Wb00CoT[Wb00?o0000oh2em_n0]OH01On0]OH00ol0
003oIZchofJ/n003ofJ/n004o`000?m2VoCo@Y_dod:Km0Ko000000?o08C>o`000?nU`nl01onU`nl2
o`0002Cooooo00?o0000ooooooooool04oooool000Cooooo00Co0000oooooooooooo00000oooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo0_l0000Oooooo`03o`00
0?nY]n?oZKOS00KoZKOS00?o0000oj^gh_n[]n800_n[]n82o`000003oj^fhOl0003o[;OQ00Oo[;OQ
00?o0000ojfhhOn]^>400_n]^>42o`000003ojfgh?l0003o[[SP00Oo[[SP00Co0000ojjhhOl0003o
00001On_^=l00ol0003o[kWPojnih003o`0000;o[kWP0_l00008ok2ih003o`000?n_^^7o[k[Q00;o
[k[Q0_l000000on`^N3o0000ojnjhP08ojnjhP04o`000?n]^nCo0000o`0000Go[k_R00?o0000ojbk
iOn/^nD01?n/^nD4o`0000KoZKcW00?o0000oj>ljonS_>/01?nS_>/3o`0000OoW[_]00?o0000oi:i
l_nB^O801?nB^O800ol0003oP;Gfoh2emP02oh2emPSo000000?oIZcho`000?m2Vo@01Om2Vo@3o`00
0003o`24c_l0003oYL?_00KoYL?_0ol0000Sooooo`03o`000?oooooooooo01?ooooo0005ooooo`03
o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003
ooooo`03o`000?oooooooooo01oooooo00?o0000ojVghonY]n<01_nY]n<01?l0003oZkORo`000?l0
0004oj^fh@03o`000?n/]n7o[;OQ00Ko[;OQ00Co0000ojfhhOl0003o00001?n]]n000ol0003o[[SP
ojjhh005ojjhh0;o00002?n_^=l2o`0000?o[kWP0_l000000on`^=oo0000ok2ih008ok2ih004o`00
0?n_^^7o0000o`0000Co/;WP00?o0000ojnjh_n_^^801_n_^^82o`0000So[k_R00?o0000ojbkiOn/
^nD00ol00002ojjkh`03o`000?nY_>OoZKcW00KoZKcW00?o0000oj>ljonS_>/00ol00002ojJlj@03
o`000?nN^ngoW[_]00KoW[_]00Co0000oi:il_nB^O;oT[Wb1ol00004ohJfm@04o`000?m_[oSoKjoh
ofn_n0Oo00000_m2Vo@01?l0003o4WoUo`000?l00002ojG3k`Go00000_nU`nl00ol0003ooooooooo
o`0Rooooo`03o`000?oooooooooo01;ooooo0006ooooo`;o00000oooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool08?ooool00ol0003oZKOS
ojVgh`04ojVgh`?o00001on[]^400ol0003o[;OQojbgh@04ojbgh@?o00001on]]n000ol0003o[[SP
ojjhh002ojjhh0;o000000?o[kOOo`000?n_^=l01?n_^=l3o`000003ojnhgol0003o[kWP00;o0000
1?n`^=l00ol0003o/;WPok2ih006ok2ih0;o00001on`^N000ol0003o[k[RojnjhP02ojnjhP?o0000
00?o/K[Po`000?n_^n801on_^n83o`0000Ko[[_S00?o0000ojVlionY_>L01?nY_>L4o`0000KoY[cY
00?o0000oijkkOnN^nd01?nN^nd5o`0000CoUk[`00?o0000ohJfmOn6]_D01On6]_D00ol0003oKjoh
ofn_n004ofn_n003o`000?m=X?KoCJ3f00So00002?nU`nl00ol0003oooooooooo`0Rooooo`03o`00
0?oooooooooo017ooooo0007ooooo`03o`000?oooooooooo00;ooooo0_l00004ooooo`;o00001?oo
ool2o`0002;ooooo00?o0000ojVghonY]n<00ol00003ojVfhP03o`000?n[]^7oZkKQ00GoZkKQ00?o
0000ojbghOn/]n400ol00003ojbfh003o`000?n]]n3o[KOP00Go[KOP00Co0000ojjhh?l0003o0000
1?n_]ml00ol0003o[kSOo`000002o`0000Co[kSO0_l00007ok2hg`03o`000?n`^N3o/;WP00;o/;WP
0ol000000ona^=ko0000ok2ih007ok2ih004o`000?n_^^;o0000o`0000Go/K[P00?o0000ojnkh_n_
^n800_n_^n83o`000003ok2jhOl0003o[[_S00Oo[[_S00?o0000ojVlionY_>L00ol00002ojbki@03
o`000?nV_>WoY[cY00KoY[cY00?o0000oijkkOnN^nd00ol00002oj6kj`03o`000?nG^_3oUk[`00Go
Uk[`00?o0000ohJfmOn6]_D01On6]_D00ol0003oKjohofn_n004ofn_n003o`000?m=X?KoCJ3f00?o
CJ3f00?o0000oan7j_l000002OnU`nl2o`0002;ooooo0_l0000Cooooo`006?ooool00ol0003ooooo
ooooo`0Rooooo`;o00001onY]^800ol0003oZkKQoj^fh@04oj^fh@?o00001on/]^000ol0003o[KOP
ojfgh004ojfgh0;o00001On_]ml3o`0000Co[kSO0ol000000on`]mko0000ok2hg`07ok2hg`04o`00
0?n`^N3o0000o`0000Go/KSN00?o0000ok2ih?n`^N001On`^N02o`0000So/K[P00Co0000ojnkh_l0
003o00001On`^^400ol0003o[[_Sojjkh`05ojjkh`?o00001_n/^nD00ol0003oY[cYojJlj@04ojJl
j@Co00001_nQ^n/00ol0003oUk[`oiNjl005oiNjl003o`000?n6]_GoQ[Ke00;oQ[Ke3ol000001?m=
X?Ko0000oan7j_l00009ojG3k`03o`000?oooooooooo02;ooooo00?o0000ooooooooool04?ooool0
01Sooooo00?o0000ooooooooool08oooool00ol0003oZKKRojVfhP06ojVfhP03o`000?n[]^7oZkKQ
00?o000000?oZkKQo`000?n/]^002?n/]^000ol0003o[KOPojfgh003o`0000;o[[KO00?o0000ojng
gol000000_l00003ojngg`04o`000?n_^=oo0000o`0000Go/;ON00?o0000ok2hgon`^=l01On`^=l2
o`0000So/KSN00?o0000ok2ih?n`^N000_n`^N02o`0000;o/[WN00?o0000ok6jh?na^^001Ona^^02
o`0000So/;[Q00Co0000ojjkhon^^n?o[[_S0ol00002ojnkhP03o`000?n/^nGo[;_U00Go[;_U00?o
0000ojJljOnV_>T00ol00002ojVki`03o`000?nQ^n_oXK_[00KoXK_[00?o0000oiNjl?nG^_000_nG
^_07o`0000CoS;Sc00?o0000ogNamomg/OL01?mg/OL01?l0003oF:GgoeRUmomHYOL5o`0000OoYL?_
0ol0000Tooooo`03o`000?oooooooooo00oooooo000Gooooo`;o00009_ooool00ol0003oZKKRojVf
hP05ojVfhP?o00001On[]^400ol0003o[;KPojbfh006ojbfh0?o00001?n^]]l3o`0000Ko[kOO0_l0
0008ok2ggP03o`000?n`^=oo/;SO00;o/;SO0_l00002ok6gg@03o`000?na^=ko/KSN00Ko/KSN00Co
0000ok2ih?l0003o00001Onb^Mh00ol0003o/K[Pok6jh002ok6jh0;o000000?o/[WNo`000?n`^^40
1on`^^401?l0003o[[_So`000?l00006ojnkhP03o`000?n/^nGo[;_U00Co[;_U0ol00006ojVki`03
o`000?nQ^n_oXK_[00CoXK_[1_l00004oi^kkP03o`000?n<^??oS;Sc00GoS;Sc00?o0000ogNamomg
/OL01?mg/OL00ol0003oF:GgoeRUm`03oeRUm`03o`000?l]Snko000000;oYL?_1?l00002oikIo003
o`000?oooooooooo02;ooooo00?o0000ooooooooool03oooool001Oooooo00?o0000ooooooooool0
9_ooool00ol0003oZKKRojVfhP02ojVfhP;o000000?oZKGQo`000?n[]^401_n[]^400ol0003o[;KP
ojbfh002ojbfh0?o000000Co[KGOo`000?n^]]oo[[KO0ol00003ojjfg`03o`000?n_]moo[kOO00?o
000000?o[kKNo`000?n`]mh02?n`]mh01?l0003o/;SOo`000?l00005ok6gg@03o`000?na^=ko/KSN
00Co/KSN0ol00008ok:igP04o`000?na^^3o0000o`0000Co/[WN00?o0000ok2jhOn`^^401On`^^42
o`0000Wo[k_R00?o0000ojbkiOn/^nD00ol00002ojjkh`03o`000?nY^nOoZK_W00GoZK_W00?o0000
oj6kjonQ^n/00ol00002ojFkj@03o`000?nK^nkoVk_^00KoVk_^00?o0000ohbhlon<^?<00_n<^?<?
o`000003oeRUmol0003o;Ho^00;o00001onNfO`00ol0003oooooooooo`0Qooooo`;o00004?ooool0
01Oooooo00?o0000ooooooooool09oooool01?l0003oZKKRo`000?l00004ojVeh@03o`000?n[]^7o
ZkKQ00GoZkKQ00Co0000ojbfh?l0003o00001?n]]Ml3o`0000Ko[[KO0ol00005ojnfgP03o`000?n`
]mko/;ON00Ko/;ON0_l00008ok6gg@03o`000?na^=ko/KSN00?o00000_nb^=d00ol0003o/[WNok:i
gP06ok:igP;o00001onb^Mh00ol0003o/;[Qok2jh@02ok2jh@;o00000_nb^]l00ol0003o[k_Rojnk
hP06ojnkhP?o00001_n^^n<00ol0003oZK_WojVki`04ojVki`?o00001_nU^nT00ol0003oVk_^oi^k
kP04oi^kkPKo00000onB^O400ol0003oO[?fogjcmP05ogjcmP04o`000?mRZOOoHZWgof:Ym`Go0000
2?nNfO`00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00kooooo000Gooooo`?o0000:?oo
ool00ol0003oZKGQojVeh@05ojVeh@03o`000?n[]^7oZkKQ00CoZkKQ0_l00004ojfeg`;o00000_n]
]Ml00ol0003o[[KOojjfg`02ojjfg`;o000000?o[[GNo`000?n_]]h01_n_]]h00ol0003o/;ONok2g
gP02ok2ggP?o00000_na]]d00ol0003o/KOMok6gg@05ok6gg@?o00001_nb^=d00ol0003o/[WNok:i
gP02ok:igP?o000000?o/kSMo`000?nb^Mh01onb^Mh01?l0003o/;[Qo`000?l00005ok:jg`03o`00
0?n_^n;o[k_R00;o[k_R0ol000000ona^^3o0000ojjkh`07ojjkh`03o`000?nY^nOoZK_W00?o0000
00?oZk_Uo`000?nU^nT01onU^nT00ol0003oVk_^oi^kkP03o`0000;oWk_/00?o0000oi:ilOnB^O40
1OnB^O400ol0003oO[?fogjcmP05ogjcmP03o`000?mRZOOoHZWg00?oHZWg00?o0000ocVFl_l00000
2?nNfO`00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00gooooo000Gooooo`03o`000?oo
oooooooo02Wooooo00?o0000ojVehOnY]N401OnY]N400ol0003oZkKQoj^fh@03o`000003oj^dh?l0
003o[KGO00?o00001On]]Ml01?l0003o[[KOo`000?l00004ojjegP03o`000?n_]]ko[kKN00Go[kKN
00Co0000ok2gg_l0003o00001_na]]d00ol0003o/KOMok6gg@02ok6gg@;o000000?o/[OLo`000?nb
^=d01onb^=d01?l0003o/[WNo`000?l00005ok>hg@03o`000?nb^Mko/[WN00Go/[WN0_l00008ok:j
g`04o`000?n_^n;o0000o`0000Go/K[P00?o0000ojjkhon^^n<01On^^n<3o`0000GoZk_U00?o0000
ojFkjOnU^nT01?nU^nT4o`0000KoWk_/00?o0000oi:ilOnB^O401OnB^O400ol0003oO[?fogjcmP02
ogjcmPSo000000?oHZWgo`000?liU_802_l0000Sooooo`03o`000?oooooooooo00cooooo0003oooo
o`?o00001?ooool2o`0000Cooooo0_l00005ooooo`03o`000?oooooooooo02[ooooo00?o0000ojVe
hOnY]N401?nY]N43o`0000?oZkCP0ol00008ojfeg`;o00001on^]Mh00ol0003o[kKNojnfgP04ojnf
gP;o00002Ona]]d01?l0003o/KOMo`000?l00004ok:gg003o`000?nb^=go/[SM00Go/[SM0_l00008
ok>hg@04o`000?nb^Mko/[WNok:igP?o00000_nc^Md00ol0003o/[[Ook:jg`05ok:jg`;o00002?na
^^001?l0003o[[_Sojjkhon^^n<3o`000003ok2khOl0003oZk_U00KoZk_U00?o0000ojFkjOnU^nT0
0ol00003ojRki`03o`000?nO^ncoWk_/00GoWk_/00?o0000oi:ilOnB^O400_nB^O47o`0000?oQKGd
00?o0000of^]mom[[OL00_m[[OL7o`0000GoBLC]0ol0000Qooooo`03o`000?oooooooooo00Gooooo
1Ol00002ooooo`000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo02cooooo00?o0000ojVe
hOnY]N400ol000000onY]>3o0000oj^dh003o`0000?oZkCP00?o0000ojfegon]]Ml00_n]]Ml3o`00
0003ojfdg_l0003o[[GN00Oo[[GN00?o0000ojnfg_n_]]h00ol00002ok2eg@03o`000?na]]go/KKM
00Ko/KKM0_l00007ok:gg003o`000?nb^=go/[SM00;o/[SM0_l000000onc]mco0000ok>hg@07ok>h
g@04o`000?nb^Mko0000o`0000Ko/kWM00?o0000ok:jgonb^]l00_nb^]l2o`000003ok>ig_l0003o
/K[P00Oo/K[P00Co0000ojjkhol0003o00001On`^n400ol0003oZk_Uoj^ki@04oj^ki@?o00001onX
^nL00ol0003oWk_/oinkk002oinkk0Oo00001?nG^_000ol0003oQKGdohFem004ohFem003o`000?m[
[OOoJjgg00CoJjgg00?o0000odFKm?l000001?l00003odW4k@?o00008?ooool2o`0000Oooooo00Co
0000oooooooooooo00000_ooool000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool2o`0002kooooo0_l00003ojVd
h0?o00001on[]>001?l0003o[KGOo`000?l00005ojfdgP03o`000?n^]Mko[[GN00Go[[GN0ol00006
ok2eg@03o`000?na]]go/KKM00;o/KKM0ol000000ona]]co0000ok:gg007ok:gg004o`000?nb^=go
0000o`0000Co/kOL00?o0000ok>hgOnc^=d01Onc^=d2o`0000Wo/kWM00Co0000ok:jgol0003o0000
1?nc^Mh00ol0003o/K[Pok6jh005ok6jh0;o00002?n`^n400ol0003oZk_Uoj^ki@03o`0000;o[[_S
00?o0000ojRkionX^nL01OnX^nL5o`0000CoXk_Z00?o0000oiNjl?nG^_001OnG^_000ol0003oQKGd
ohFem004ohFem003o`000?m[[OOoJjgg00CoJjgg00Co0000odFKm?m5VoCoAI_d2_l0000Pooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool000;ooooo1?l00003ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0]oooo
o`03o`000?nY]>3o000000;o00000onY]>000ol0003oZkCPoj^dh004oj^dh0?o00001on]]=h00ol0
003o[[GNojjegP02ojjegP;o000000?o[kCMo`000?n`]Md01on`]Md01?l0003o/KKMo`000?l00005
ok6fg003o`000?nb]mco/[OL00Go/[OL0_l00007ok>gg003o`000?nc^=go/kSM00;o/kSM0_l00002
okBgg003o`000?nc^Mgo/kWM00Ko/kWM0_l00007ok>igP04o`000?na^^3o/K[Pok6jh0?o000000?o
/k[No`000?n`^n401on`^n43o`0000Ko[[_S00?o0000ojRkionX^nL00_nX^nL2o`000003oj^ki_l0
003oXk_Z00OoXk_Z00?o0000oiNjl?nG^_000_nG^_0Fo`000004odFKm?l0003o0000o`1W^0Go0000
7oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo007ooooo0002ooooo`03o`000?oo
oooooooo00Cooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003ooooo`03
o`000?oooooooooo02cooooo0ol00007ojVdh003o`000?n[]>3oZkCP00?o00000on[]=l00ol0003o
[KCNojfdgP05ojfdgP04o`000?n^]Mko0000o`0000Co[kCM00?o0000ok2egOn`]Md01On`]Md2o`00
00So/KKL00Co0000ok:gg?nb]mco/[OL0ol000000onc]]_o0000ok>gg007ok>gg004o`000?nc^=go
0000o`0000Go];OL00?o0000ok>igOnc^Md00_nc^Md3o`000003okBhg?l0003o/kWN00Ko/kWN00Co
0000ok6jh?l0003o00001Onc^]h00ol0003o/;_Qok2kh@02ok2kh@?o000000?o/[[Po`000?n^^n<0
1on^^n<01?l0003oZ;_Wo`000?l00004oj^kiP03o`000?nS^n[oXk_Z00CoXk_Z1_l00003oi^jkP03
o`000?n<]o?oS;Oc00GoS;Oc00?o0000ogB_momd[oL01?md[oL01?l0003oDJ7foe6Qm_mAXOH6o`00
0003oiD:0?l0003o000000;o00007_ooool00ol0003oooooooooo`02ooooo`05o`000?oooooooooo
ooooool000000_ooool000?ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000?ooooo0_l0000Zooooo`?o00000oooool00ol0003oZKCPojVd
h004ojVdh0?o00001on[]=l00ol0003o[KCNojfdgP04ojfdgP;o00001on_]=d00ol0003o/;GMok2e
g@02ok2eg@;o000000?o/;CLo`000?na]]`01ona]]`01?l0003o/[OLo`000?l00005ok>ff`03o`00
0?nc]mco/kOL00Go/kOL0_l00008okBgg004o`000?nc^Mgo0000o`0000Go];SL00?o0000ok>ig_nc
^Mh01?nc^Mh2o`0000So/k[N00Co0000ok2khOl0003o00001Onb^^000ol0003o[[_Sojjkh`04ojjk
h`?o00001on[^nH00ol0003oXk_Zoj>kjP03o`0000;oY[_X00?o0000oi^jk_nK^^h01OnK^^h00ol0
003oS;Ocohbgl`05ohbgl`03o`000?md[oOoM:og00CoM:og00?o0000oe6Qm_mAXOH00omAXOH9o`00
01cooooo0ol00003ooooo`05o`000?ooooooooooooooool000000_ooool000Cooooo0_l00004oooo
o`;o00001?ooool2o`0000Cooooo00?o0000ooooooooool09oooool2o`0000Oooooo00?o0000ojVd
h?nY]>000ol000000onY/moo0000oj^dg`08oj^dg`03o`000?n]]=ko[KCN00?o000000?o[K?Mo`00
0?n_]=d01on_]=d01?l0003o/;GMo`000?l00004ok2dg003o`000?na]]co/KKL00Go/KKL0_l00008
ok>ff`03o`000?nc]mco/kOL00;o/kOL0_l00002okBff`03o`000?nd]mco];OL00Go];OL0_l00008
okBhg004o`000?nc^Mko/kWNok>igP;o00000_nd^M`00ol0003o/k[Nok>jgP05ok>jgP;o00002?nb
^^000ol0003o[[_Sojjkh`03o`0000;o/;_Q00?o0000oj^ki_n[^nH01On[^nH3o`0000KoY[_X00?o
0000oi^jk_nK^^h01OnK^^h00ol0003oS;Ocohbgl`02ohbgl`oo000000?oDJ7fo`000?l000000_l0
00001?n_:03o0000o`000?n60002o`0001Oooooo1?l000000ooooooo0000ooooo`03ooooo`?o0000
0oooool001Gooooo00?o0000ooooooooool09Oooool3o`0000[ooooo0_l00005ojVcg`03o`000?n[
]=ooZkCO00KoZkCO0ol00005ojfcg@03o`000?n_]=go[kCM00Go[kCM0_l00007ok2dg003o`000?na
]]co/KKL00;o/KKL0_l000000onb]M_o0000ok>ff`08ok>ff`04o`000?nc]mco0000o`0000Go];KK
00?o0000okBgg?nd]m`00_nd]m`2o`000003okFgf_l0003o];SL00Oo];SL00Co0000ok>ig_l0003o
00001Ond^M`00ol0003o/k[Nok>jgP02ok>jgP;o00000_nd^Md00ol0003o/[[Pok:jh005ok:jh0?o
00001_n`^n400ol0003oZk_Voj^kiP02oj^kiP;o00000_n]^n@00ol0003oY[_XojJkj005ojJkj003
o`000?nK^^koVk[^00;oVk[^1ol00004oi6hl@03o`000?ml/_KoO;;f00?oO;;f00?o0000oebUmomL
YOL00_mLYOL7o`000003ojXR0?l0003oQP0000;o00004oooool3o`0000Gooooo00?o0000oooooooo
ool02?ooool001Gooooo00?o0000ooooooooool08_ooool3o`0000gooooo00?o0000ojVcgonY/ml0
1OnY/ml00ol0003oZkCOoj^dg`02oj^dg`?o000000?oZk?No`000?n]/md01_n]/md00ol0003o[kCM
ojndg@02ojndg@;o000000?o[k?Lo`000?n`]=`01on`]=`01?l0003o/KKLo`000?l00004ok:ef`03
o`000?nc]]_o/kKK00Ko/kKK0_l00008okBff`04o`000?nd]mco0000o`0000Co]KOJ00?o0000okBh
g?nd^=`01Ond^=`2o`0000So];WL00Co0000ok>jg_l0003o00001Ond^Md00ol0003o/[[Pok:jh002
ok:jh0;o000000?o/k[No`000?n`^n401on`^n401?l0003oZk_Vo`000?l00005ojfki003o`000?nV
^nSoY[_X00CoY[_X1Ol00004oinkk003o`000?nA^?7oTKSa00GoTKSa00?o0000ogbbm_ml/_H00oml
/_H00ol0003oG:GgoebUm`04oebUm`Go000000?oZR80o`000?l000000_l0000?ooooo`?o00002?oo
ool00ol0003oooooooooo`08ooooo`005Oooool2o`00023ooooo0ol0000Aooooo`03o`000?nY/moo
ZK?O00GoZK?O00Co0000oj^dgol0003o00001On[/mh00ol0003o[K?Mojfcg@05ojfcg@04o`000?n_
]=go0000o`0000Co[k?L00?o0000ok2dg?n`]=`01On`]=`2o`0000Oo/[GK00?o0000ok>ffonc]]/0
0_nc]]/3o`000003ok>ef_l0003o];KK00Oo];KK0_l00007okFgfP03o`000?nd^=co];SL00;o];SL
0_l000000onf]m[o0000okBig007okBig0;o00002?nd^Md01?l0003o/[[Po`000?l00004ok>jgP03
o`000?n`^n7o/;_Q00Co/;_Q0ol00008ojfki003o`000?nV^nSoY[_X00?o000000?oZK_Vo`000?nO
^n`01onO^n`00ol0003oTKSaoi6hl@02oi6hl@ko00000_mLYOL3o`000005ojlX0?l0003oZR80o`00
0?nU70000_l0000:ooooo`Co00002oooool00ol0003oooooooooo`08ooooo`005Oooool00ol0003o
ooooooooo`0Looooo`?o00005Oooool00ol0003oZK?OojVcg`04ojVcg`;o00002?n[/mh00ol0003o
[K?Mojfcg@03ojfcg@?o00001on_/m`00ol0003o/;CLok2dg002ok2dg0;o000000?o/KCKo`000?nb
]M/01onb]M/01?l0003o/kKKo`000?l00005ok>efP03o`000?nd]]_o];KK00;o];KK0ol000000one
]]Wo0000okFgfP07okFgfP04o`000?nd^=co0000o`0000Co][OJ00?o0000okBig?nd^M`00_nd^M`3
o`000003okJhfol0003o];WM00Oo];WM0_l00007ok>jgP03o`000?n`^n7o/;_Q00?o00000_nb^]l0
0ol0003o[K_Tojfki006ojfki0?o00001OnY^nH00ol0003oWk_/oinkk004oinkk0Ko00000onG^Nl0
0ol0003oPkCeoh>dm@04oh>dm@04o`000?mVZOOoIZWgofJYm`Ko000000?o[bP0o`000?nZ8P001Ol0
0005ooooo`?o00004?ooool00ol0003oooooooooo`07ooooo`005Oooool00ol0003oooooooooo`0I
ooooo`?o00006Oooool00ol0003oZK?OojVcg`03o`0000;oZK;O00?o0000oj^cg_n[/mh01On[/mh0
0ol0003o[K?Mojfcg@03o`0000?o[K?L00?o0000ojncg?n_/m`01On_/m`01?l0003o/;CLo`000?l0
0004ok6df`03o`000?nb]M_o/[GK00Go/[GK0_l00008ok>efP04o`000?nd]]_o0000o`0000Go]KKI
00?o0000okFgf_ne]mX01One]mX2o`0000Oo][OJ00Co0000okBig?l0003o00001Onf^=/00ol0003o
];WMokBig@02okBig@?o000000?o][WKo`000?nc^]h01_nc^]h3o`0000Ko/[[O00?o0000ojfki?n]
^n@00_n]^n@3o`000003ok2kh_l0003oZK_V00KoZK_V00?o0000oinkk?nO^n`00ol00002oj>kjP03
o`000?nG^NooUkW_00GoUkW_00?o0000oh>dmOn3]?D01?n3]?D00ol0003oIZWgofJYm`03ofJYm`07
o`000?lkUO;o0000o`000?n_:03o0000ojXR0005o`000004ooooool0003o0000o`0001?ooooo00?o
0000ooooooooool01oooool001Gooooo0_l0000Gooooo`?o00007Oooool2o`0000KoZK;O00?o0000
oj^cg_n[/mh01?n[/mh3o`0000Oo[K?L00?o0000ojncg?n_/m`01?n_/m`2o`0000Oo/KCK00?o0000
ok:efonb]M/00_nb]M/2o`000003ok:df_l0003o/kGJ00Oo/kGJ0_l00008okFff@04o`000?ne]m[o
]KOJokFgfP?o000000?o][KIo`000?nf]mX01_nf]mX2o`0000So][SK00Co0000okBigOl0003o0000
1Onf^M/00ol0003o/k[Nok>jgP02ok>jgP;o000000?o]KWLo`000?nb^]l01onb^]l01?l0003o[K_T
o`000?l00005ok2khP03o`000?nY^nKoZK_V00CoZK_V0ol00006oj>kjP03o`000?nG^NooUkW_00Co
UkW_00?o0000oh>dmOn3]?D00_n3]?D8o`000003ofJYmol0003o>iGb00;o000000?o[bP0o`000?nZ
8P000_l000001?nO5P3o0000o`000?l0000Eooooo`03o`000?oooooooooo00Oooooo00001?oooooo
0000o`000?l00004ooooo`;o00001?ooool2o`0000Gooooo00?o0000ooooooooool04oooool3o`00
023ooooo00?o0000ojVbgonY/]l01_nY/]l00ol0003oZk?Noj^cgP03o`000003oj^bgOl0003o[K?L
00So[K?L00?o0000ojncg?n_/m`00ol000000on_/m_o0000ok6df`07ok6df`04o`000?nb]M_o0000
o`0000Co/[CJ00?o0000ok>ef_nc]MX01?nc]MX00ol0003o];CIo`000008okFff@04o`000?ne]m[o
0000o`0000Go][KI00?o0000okJgf_nf]mX00_nf]mX2o`000003okNgfOl0003o][SK00Oo][SK0_l0
0008okJif`04o`000?nc^]ko0000o`0000Co]KWL00?o0000ok:jgonb^]l01Onb^]l2o`0000So/;_R
00?o0000ojVki_nY^nH00ol000000on/^nCo0000oj>kjP07oj>kjP04o`000?nG^NooUkW_oiNik`Oo
00001?n9]_<01?l0003oKjggofn]mom_[OL6o`000003ojlX0?l0003oZR8000;o000000CoWaH0o`00
0?l0003o00005?ooool00ol0003oooooooooo`07ooooo`0000Go0000ooooooooooooooooo`000002
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003ooooo
ooooo`0Booooo`;o00009?ooool00ol0003oZK;OojVbg`05ojVbg`?o00001On[/]d00ol0003o[K?L
ojfcg006ojfcg0?o00001On_/m/00ol0003o/KCKok6df`05ok6df`;o00001onb]=X01?l0003o/kGJ
ok>ef_nc]MX2o`0000?o];CI00?o0000okFffOne]]T01One]]T2o`0000So][KI00Co0000okJgf_l0
003o00001?ng]mT00ol0003o][SKokJhf`04okJhf`03o`000?ng]mWo000000So][WK0_l00007okFi
g003o`000?nb^]oo/[[O00;o/[[O0_l000000ond^]ko0000ok2khP07ok2khP?o00001On/^n@00ol0
003oXk_Zoj>kjP04oj>kjPGo00001?nK^^h00ol0003oRKKcohVfl`05ohVfl`03o`000?m_[OOoKjgg
00?oKjgg0_l000001Om8VoCo0000ojlX0?l0003oZR8000;o000000CoWaH0o`000?l0003o00004ooo
ool00ol0003oooooooooo`07ooooo`0000Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0?ooooo`?o
00009oooool00ol0003oZK;OojVbg`02ojVbg`;o000000?oZK7No`000?n[/]d01_n[/]d00ol0003o
[K?Lojfcg002ojfcg0?o000000?o[[;Ko`000?n_/m/01_n_/m/00ol0003o/KCKok6df`02ok6df`;o
000000?o/K?Jo`000?nb]=X01onb]=X00ol0003o/kGJo`000006okBdf@03o`000?ne]]Wo]KKI00;o
]KKI0_l000000onf]MSo0000okJff@07okJff@;o00001ong]mT01?l0003o][SKokJhfonf^=/2o`00
00?o]kOI00?o0000okJifonf^M/01?nf^M/00ol0003o]kSJo`000008okFig004o`000?nb^]oo0000
o`0000Co];[N00?o0000ok2kh_n`^n800_n`^n83o`000003ok:kh?l0003o[;_T00Ko[;_T00?o0000
oj>kj_nS^nX00ol00003ojNkj003o`000?nK^^koVk[^00CoVk[^00?o0000ohVflon9]_<00_n9]_<8
o`000004ofn]mol0003o0000odRKm0?o000000CoZR80o`000?l0003oWaH00ol0000Booooo`03o`00
0?oooooooooo00Oooooo00001?oooooo0000o`000?l00003ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00000oooool2o`0000gooooo0ol0000[ooooo`04o`000?nY/]oo0000
o`0000CoZK7N00?o0000oj^bgOn[/]d01On[/]d01?l0003o[K?Lo`000?l00005ojjbf`03o`000?n_
/m_o[k?K00Go[k?K00Co0000ok6dfol0003o00001?na/mX00ol0003o/[CJok:dfP05ok:dfP;o0000
2?nd]=T01?l0003o]KKIo`000?l00004okJef003o`000?nf]]Wo][KI00Co][KI00?o0000okNff?l0
00002?ng]mT00ol0003o][SKo`000006okNgf@04o`000?nf^M_o][WKokJif`;o00000ong^=X00ol0
003o]KWLokFig005okFig0;o00001ond^]h01?l0003o/;_Ro`000?l00005ok:kh003o`000?n/^nCo
[;_T00Co[;_T0ol00007ojNkj004o`000?nK^^koVk[^oi^jkPOo00001?n@]o401?l0003oN;3fogR`
m_mh/?H;o`000003oilF0?l0003o000000;o00004?ooool00ol0003oooooooooo`07ooooo`0000Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00000oooool00ol0003oooooooooo`09ooooo`?o0000;oooool00ol0003oZK7NojVagP05ojVa
gP03o`000?n[/]goZk;M00CoZk;M0_l00008ojjbf`03o`000?n_/m_o[k?K00?o[k?K0ol00007ok6c
fP03o`000?nb]=[o/[CJ00;o/[CJ0_l00002ok>cf@03o`000?nd]=Wo];CI00Go];CI0_l00007okJe
f004o`000?nf]]Wo][KIokJff@;o00000ong]]P00ol0003o]kOIokNgf@05okNgf@;o00002?ng]mT0
0ol0003o][WKo`000006okNhfP04o`000?ne^Mco]KWLokFig0?o000000?o]kWKo`000?nd^]h01_nd
^]h2o`0000So/[_P00?o0000ojbki?n/^n@00ol00002ojnkhP03o`000?nW^nSoYk_X00CoYk_X1Ol0
0004oj2jk003o`000?n@]o7oT;Oa00GoT;Oa00?o0000ogR`m_mh/?H00omh/?H2o`0000;oDj7f1Ol0
00000onO5P3o0000o`000002o`00013ooooo00?o0000ooooooooool01_ooool00005o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool01_ooool3o`0003?ooooo00?o0000ojVag_nY/Mh01OnY/Mh00ol0003o
Zk;Moj^bg@03o`000003ojbag?l0003o[[;K00Oo[[;K00?o0000ojncfon_/m/00ol00002ok2bfP03
o`000?na/m[o/K?J00Ko/K?J00Co0000ok:df_l0003o00001Onc/mT00ol0003o];CIokBdf@02okBd
f@;o000000?o]KCHo`000?nf]MP01onf]MP00ol0003o][KIo`000006okNff003o`000?ng]mWo]kOI
00;o]kOI0_l000000onh]]So0000okNgf@07okNgf@;o00001ong^=X01?l0003o]KWLo`000?l00005
okNif`03o`000?nd^]ko];[N00;o];[N0_l000000onf^]co0000ok:kh007ok:kh0?o00001_n_^n80
0ol0003oYk_XojNkj003o`0000;oZ[_V00?o0000oj2jk?nP^^`01OnP^^`00ol0003oT;Oaoi2gl@02
oi2gl@So000000?oN;3fo`000?mCXOH01?mCXOH9o`0000kooooo00?o0000ooooooooool01_ooool0
0004ooooool0003o0000o`0000Cooooo0_l00004ooooo`;o00001?ooool2o`0000Cooooo0ol0000g
ooooo`03o`000?nY/MkoZK7N00CoZK7N0ol00005ojbag003o`000?n^/]_o[[;K00Go[[;K0ol00006
ok2bfP03o`000?na/m[o/K?J00Co/K?J0ol00008ok>cf@04o`000?nd]=Wo0000o`0000Co]KCH00?o
0000okJef?nf]MP01Onf]MP2o`0000So]kKH00Co0000okNgfOl0003o00001?nh]]P00ol0003o]kOI
okNgf@02okNgf@?o000000?o^;OHo`000?ng^=X01_ng^=X2o`0000So]kWK00Co0000okBjg_l0003o
00001?nf^]`00ol0003o/[_Pok:kh002ok:kh0?o000000?o];[No`000?n_^n801_n_^n83o`0000Ko
Z[_V00?o0000oj2jk?nP^^`00onP^^`6o`0000Sooooo1ol000001?mCXOKo0000ob66j_lQQ^X6o`00
00gooooo00?o0000ooooooooool01_ooool001?ooooo00Co0000oooooooooooooooo0ol0000koooo
o`03o`000?nY/MkoZK7N00?o000000?oZK3Mo`000?n//M`01_n//M`00ol0003o[[;Kojjbf`02ojjb
f`;o000000?o[[7Ko`000?n`/]X01on`/]X00ol0003o/K?Jok6cfP03o`0000;o/[;I00?o0000ok>c
fOnc/mT01_nc/mT2o`0000Oo]KCH00Co0000okJef?nf]MSo][GH0ol000000onf]=Oo0000okNff007
okNff0;o00001onh]]P01?l0003o]kOIo`000?l00005okRgf003o`000?ng^=[o]kSJ00;o]kSJ0_l0
00000onh^=So0000okNif`07okNif`;o00001onf^]`01?l0003o/[_Po`000?l00005okBjgP03o`00
0?n_^n;o[k_R00;o[k_R0_l000000ona^n7o0000ojZkiP06ojZkiP03o`000?nP^^coX;[/00?o0000
4Oooool01?l0003oooooooooooooool5o`000006ob66j_l0003o0000o`000?n;003o00003?ooool0
0ol0003oooooooooo`06ooooo`004oooool4o`0003oooooo0_l00005ojV`g@03o`000?n//Mco[;7L
00Go[;7L00Co0000ojjbfol0003o00001?n^/M/00ol0003o/;;Jok2bfP05ok2bfP?o00001_nb/]T0
0ol0003o/k?Iok>cf@02ok>cf@?o000000?o/k?Ho`000?ne]=P01_ne]=P01?l0003o][GHo`000?l0
0005okJde`03o`000?ng]]So]kKH00;o]kKH0ol000000onh]MOo0000okRff006okRff0;o00002?nh
]mP01?l0003o]kSJo`000?l00004okRhf003o`000?ng^M_o]kWK00;o]kWK0ol000000onh^=Wo0000
okJjg006okJjg0;o00002?nd^]h01?l0003o[k_Ro`000?l00004ok6kh@03o`000?nZ^nKoZ[_V00Co
Z[_V0ol0000Dooooo`03o`000?oooooooooo00Kooooo1Ol000000on;003o0000ooooo`0:ooooo`03
o`000?oooooooooo00Kooooo000Cooooo`;o0000@Oooool00ol0003oZK3MojV`g@05ojV`g@03o`00
0?n//Mco[;7L00Co[;7L0_l00007ojjaf`03o`000?n`/][o/;;J00;o/;;J0_l000000on`/MWo0000
ok:bf@07ok:bf@04o`000?nc/mWo0000o`0000Go/k?H00?o0000okFdf?ne]=P01?ne]=P2o`0000So
][CG00Co0000okNff?l0003o00001Onh]ML00ol0003o^;KHokRff003okRff003o`000?ni]]Ko0000
00So^;OH0_l00007okRhf004o`000?ng^M_o0000o`0000Go^;SI00?o0000okJjg?nf^]`00_nf^]`2
o`000003okNif_l0003o];[N00Oo];[N0_l00007ok6kh@03o`000?nZ^nKoZ[_V00?o00006?ooool0
0ol0003oooooooooo`08ooooo`Ko00002Oooool00ol0003oooooooooo`06ooooo`005Oooool00ol0
003oooooooooo`0oooooo`03o`000?nY/=goZK3M00GoZK3M00?o0000ojbag?n//M`00ol000000on/
/=_o0000ojjaf`07ojjaf`04o`000?n`/][o0000o`0000Co/;7I00?o0000ok:bfOnb/]T01Onb/]T2
o`0000So/k?H00Co0000okFdf?ne]=So]KCH0_l000000one/mOo0000okJde`07okJde`;o00002?nh
]ML00ol0003o^;KHokRff002o`0000?o^KKF00?o0000okRgf?nh]mP01?nh]mP00ol0003o^KKFo`00
0007okRhf0;o00002?nh^=T01?l0003o][[Lo`000?l00004okNifP03o`000?nd^]ko];[N00;o];[N
0ol000000onf^]co0000ok6kh@06ok6kh@?o00007?ooool00ol0003oooooooooo`0:ooooo`Co0000
2?ooool00ol0003oooooooooo`06ooooo`005_ooool00ol0003oooooooooo`0oooooo`03o`000?nY
/=goZK3M00CoZK3M0ol00005ojb`f`03o`000?n^/M_o[[7K00Go[[7K0_l00007ok2af@03o`000?nb
/]Wo/[;I00;o/[;I0_l000000onb/]So0000ok>cf007ok>cf004o`000?ne]=So0000o`0000Co]K?G
00?o0000okJdeonf]=L01?nf]=L00ol0003o]kCFo`000008okRee`03o`000?nh]]So000000Ko^KKF
00Co0000okRgf?nh]mSo^;OH0_l00003okVfeP03o`000?nh^=So^;SH00?o^;SH00Co0000okZgeonj
]mOo00001onh^=T2o`0000Oo]kWJ00Co0000okBjg_l0003o00001Onf^]`00ol0003o/K_Qok6kh@02
ok6kh@;o00008?ooool00ol0003oooooooooo`0;ooooo`Co00001_ooool00ol0003oooooooooo`06
ooooo`005oooool00ol0003oooooooooo`0oooooo`03o`000?nY/=goZK3M00?o000000?oZJoLo`00
0?n//=/01_n//=/00ol0003o[[7Kojjaf`02ojjaf`;o000000?o[[3Jo`000?n`/MT01on`/MT01?l0
003o/[;Io`000?l00004ok:bf003o`000?nc/mSo/k?H00Go/k?H0_l00007okFce`04o`000?nf]=Oo
][CGokJde`;o00000ong]=H00ol0003o^;GGokRee`05okRee`;o00002?ni]]H00ol0003o^;OHo`00
0006okVfeP03o`000?nh^=So^;SH00;o00001?nj]mL00ol0003o^;SIokRhf@02okRhf@;o000000?o
^[SHo`000?ng^MX01_ng^MX2o`0000So][[L00Co0000ok6khOl0003o00008_ooool00ol0003ooooo
ooooo`0=ooooo`?o00001_ooool00ol0003oooooooooo`05ooooo`006?ooool2o`00043ooooo0_l0
0005ojV_g003o`000?n//=_o[;3K00Go[;3K00Co0000ojjafol0003o00001?n^/=X00ol0003o/;7I
ok2af@05ok2af@;o00001onb/]P00ol0003o/k?Hok>cf002ok>cf0;o000000?o];;Go`000?ne/mL0
1one/mL00ol0003o][CGo`000006okNdeP03o`000?nh]MOo^;GG00;o^;GG0_l000000onh]=Go0000
okVfeP07okVfeP;o00001oni]]H00ol0003o^;SHo`000007okZge`04o`000?nh^=Wo0000o`0000Co
^[SH00?o0000okNif_ng^MX00_ng^MX2o`000003okVifOl0003o][[L00Oo][[L0_l0000Uooooo`03
o`000?oooooooooo00kooooo0_l00005ooooo`03o`000?oooooooooo00Gooooo000Jooooo`03o`00
0?oooooooooo03gooooo00?o0000ojV_g?nY[m`01OnY[m`00ol0003o[;3Kojb`f`04ojb`f`;o0000
1on^/=X00ol0003o/;7Iok2af@02ok2af@;o000000?o/;7Ho`000?nb/]P01onb/]P01?l0003o/k?H
o`000?l00004okBbe`03o`000?ne/mOo]K?G00Go]K?G0_l00008okNdeP04o`000?nh]MOo0000o`00
00Co^;CE00?o0000okVfe_ni]]H00_ni]]H3o`000003okVeeOl0003o^KKF00Ko^KKF0_l00008okZg
e`;o00001onj^=P01?l0003o]kWJo`000?l00004okVif@03o`000?nf^]co][[L00;o][[L0ol0000X
ooooo`03o`000?oooooooooo00oooooo0_l00003ooooo`03o`000?oooooooooo00Gooooo000Koooo
o`03o`000?oooooooooo03gooooo00?o0000ojV_g?nY[m`01OnY[m`00ol0003o[;3Kojb`f`03o`00
00;o[:oJ00?o0000ojj`f_n^/=X01On^/=X01?l0003o/;7Io`000?l00004ok2af003o`000?nb/]So
/[;H00Go/[;H0_l00007okBbe`03o`000?ne/mOo]K?G00;o]K?G0_l000000onf/]Ko0000okNdeP07
okNdeP;o00001onh]=D01?l0003o^KKFo`000?l00005okVee@03o`000?ni]]Ko^KKF00;o^KKF0_l0
00000onj]]Go0000okZge`05okZge`;o000000?o^kOEo`000?nj^=P01_nj^=P2o`0000Oo^KWI00Co
0000okJjg?l0003o0000;?ooool00ol0003oooooooooo`0?ooooo`;o00000_ooool00ol0003ooooo
ooooo`05ooooo`007?ooool00ol0003oooooooooo`0mooooo`03o`000?nY[mcoZJoL00CoZJoL0ol0
0006ojb_fP03o`000?n^/=[o[[3J00Co[[3J0_l00007ok2af003o`000?nb/]So/[;H00;o/[;H0_l0
00000onb/MOo0000okBbe`07okBbe`04o`000?ne/mOo0000o`0000Co][;F00?o0000okNde_ng]=H0
0_ng]=H3o`000003okRceOl0003o^;CE00Ko^;CE0_l00008okVee@04o`000?ni]]Ko0000o`0000Co
^[KE00?o0000okZgeonj]mL00_nj]mL00ol0003o^kOEok^ge@02ok^ge@03o`000?nj^=So^[SH00?o
^[SH00?o0000ok^ge_l000001oni^MT2o`0002kooooo00?o0000ooooooooool04Oooool3o`0000Oo
oooo000Mooooo`;o0000?_ooool00ol0003oZJoLojV_g003o`000003ojV_fol0003o[:oJ00Oo[:oJ
00?o0000ojj`f_n^/=X00ol000000on^/=Wo0000ok2af007ok2af004o`000?nb/]So0000o`0000Co
/[7G00?o0000okBbeond/]L01Ond/]L2o`0000Oo][;F00Co0000okNde_l0003o00001Onh/mD00ol0
003o^;CEokRde@03okRde@03o`000?ni]=Co000000So^KGE0_l00007okZfe@04o`000?nj]mOo0000
o`0000Ko^kOE00?o0000okZhf?nj^=P00_l00003ok^geP03o`000?ni^MWo^KWI00?o^KWI00?o0000
ooooooooool0;oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Gooooo000Ooooo
o`03o`000?oooooooooo03cooooo0_l00005ojV_f`03o`000?n/[m[o[:oJ00Go[:oJ0ol00005ojj`
f@03o`000?n`/MSo/;7H00Go/;7H0_l00007ok:ae`04o`000?nd/]Oo];;GokBbe`?o000000?o];7F
o`000?nf/]H01_nf/]H2o`0000So^;?E00?o0000okRdeOnh]=D00_l00003okVde003o`000?ni]MGo
^KGE00Co^KGE00?o0000okZde?l000001onj]]D2o`0000So^kOE00?o0000okZhf?l000001_nk]mH0
0ol0003o^KWIokVif@02o`0003?ooooo00?o0000ooooooooool04Oooool2o`0000Kooooo000Poooo
o`03o`000?oooooooooo03_ooooo00?o0000ojV_fonY[m/01OnY[m/00ol0003o[:oJojb_fP02ojb_
fP;o000000?o[:oJo`000?n^/=T01_n^/=T00ol0003o/;7Hok2af002ok2af0;o000000?o/K3Go`00
0?nb/ML01_nb/ML01?l0003o];;Go`000?l00005okBaeP03o`000?nf/]Ko][;F00?o][;F00?o0000
okNbe?l000002?nh/mD00ol0003o^;CEo`000006okVde004o`000?ni]MGo^KGEokVee@;o00000onj
]=@00ol0003o^[KEokZfe@03okZfe@03o`000?nk]MCo000000So^kOE0_l00007ok^geP03o`000?ni
^MWo000003Gooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`04ooooo`008Oooool0
0ol0003oooooooooo`0kooooo`03o`000?nY[m_oZJoK00GoZJoK00Co0000ojb_f_l0003o00001?n/
[mX00ol0003o[[3Iojj`f@05ojj`f@04o`000?n`/MSo0000o`0000Co/K3G00?o0000ok:aeonb/ML0
1?nb/ML2o`0000So];7F00?o0000okJbe_nf/]H00_l00003okNbe003o`000?nh/mGo^;?E00Go^;?E
0_l00008okVde003o`000?ni]MGo000000Ko^[CD00?o0000okZfeOnj]]D00_l00003ok^ee003o`00
0?nk]mGo^kOE00?o^kOE0_l000000onl]]Co0000ok^geP06ok^geP;o0000=oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo00Cooooo000Rooooo`;o0000??ooool00ol0003oZJoKojV_
f`04ojV_f`;o00001on/[mX00ol0003o[[3Iojj`f@03ojj`f@?o00001ona/=L01?l0003o/[7Gok:a
eonb/ML2o`000003ok>`e_l0003o];7F00Oo];7F00?o0000okJbe_l000001_ng/]@00ol0003o^;?E
okRce@02okRce@;o000000?o^;;Co`000?ni]=@01oni]=@2o`0000Oo^[CD00?o0000okZfeOl00000
1_nk]M@01Ol0003o^kOEok^geOnk]mGo000000Co_;KD00?o0000ok^ge_nk]mH00_nk]mH2o`0003[o
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`04ooooo`009?ooool00ol0003ooooo
ooooo`0jooooo`03o`000?nY[m_oZJoK00?o000000?oZJkKo`000?n/[mX01_n/[mX00ol0003o[[3I
ojj`f@03o`0000;o[ZoH00?o0000ok6`eona/=L01Ona/=L01?l0003o/[7Go`000?l00004ok>`eP03
o`000?nd/MKo];7F00Go];7F0_l00008okNbe004o`000?nh/mGo0000o`0000Co^;;C00?o0000okVd
e?ni]=@00_ni]=@3o`000003okZcdol0003o^[CD00Ko^[CD0_l00007ok^ee004o`000?nk]mGo0000
o`0000Ko_;KD00Co0000ok^ge_l0003o0000?Oooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00Cooooo000Uooooo`03o`000?oooooooooo03[ooooo0_l00005ojV^f`03o`000?n/[m[o
[:oJ00Co[:oJ0ol00006ojj_f003o`000?na/=Oo/K3G00Co/K3G0_l00007ok>`eP03o`000?nd/MKo
];7F00;o];7F0_l000000one/MCo0000okNbe007okNbe0;o00001onh/]<01?l0003o^KCDo`000?l0
0005okZcd`03o`000?nj]=Co^[CD00?o^[CD00?o0000ok^dd_l000001onk]M@2o`0000So_;KD0_l0
000oooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool002Kooooo00?o0000
ooooooooool0>Oooool00ol0003oZJkKojV^f`05ojV^f`03o`000?n/[m[o[:oJ00?o000000?o[:kI
o`000?n^[mP01on^[mP01?l0003o/K3Gok6`eona/=L2o`000003ok6_e_l0003o/k3F00Oo/k3F00Co
0000okBae_l0003o00001?ne/M@00ol0003o]k;DokNbe004okNbe003o`000?ng/M?o000000Oo^;;C
0_l00008okZcd`03o`000?nj]=Co^[CD00;o00000onk]=800ol0003o^kGDok^ee002ok^ee0;o0000
0_nl]=800ol0003o_;KDokbfe004okbfe003o`000?oooooooooo043ooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`04ooooo`009oooool2o`0003[ooooo00?o0000ojV^fonY[]/01?nY
[]/3o`0000Go[:kI00?o0000ojj_f?n^[mP01On^[mP01?l0003o/K3Go`000?l00004ok6_eP03o`00
0?nc/=Ko/k3F00Go/k3F0_l00007okFae004o`000?ng/]Co]k;DokNbe0;o00000ong/M<00ol0003o
^;;CokRbd`03okRbd`03o`000?ni/];o000000So^[?C00?o0000okZde?l000001_nk]=801?l0003o
^kGDo`000?l00005okbddP04o`000?nl]]Co_;KDokbfe0;o0000A?ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00Cooooo000Yooooo`03o`000?oooooooooo03Sooooo00?o0000ojV^
fonY[]/00ol000000onY[M[o0000ojb^f@06ojb^f@03o`000?n^[mSo[ZoH00Co[ZoH0_l00007ok6_
eP03o`000?nc/=Ko/k3F00;o/k3F0_l000000onc[mGo0000okFae007okFae003o`000?ng/]Co0000
00Ko]k7C00?o0000okRbdonh/]<00_l00003okVbdP03o`000?nj/m?o^[?C00Go^[?C0_l00007ok^d
dP;o00002?nl]=800ol0003o_;KDo`000017ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool01?ooool002[ooooo00?o0000ooooooooool0>?ooool2o`0000GoZJgJ00?o0000ojb^fOn/
[]T01On/[]T00ol0003o[ZoHojj_f003o`000003ojn^eol0003o/JoF00Oo/JoF00Co0000ok>`e_l0
003o00001?nc[mD00ol0003o]K7DokFae005okFae0;o00001ong/M<00ol0003o^;;Co`000006okVb
dP03o`000?nj/m?o^[?C00;o^[?C0_l000000onj/];o0000ok^ddP05ok^ddP03o`000?nl/m7o0000
00So_;CB0_l00018ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool002_o
oooo00?o0000ooooooooool0=oooool00ol0003oZJgJojV]fP05ojV]fP03o`000?n/[]Wo[:kI00Co
[:kI0ol00005ojn^e`03o`000?na[mKo/JoF00Go/JoF0_l00007ok>_e@04o`000?ne/MCo]K7DokFa
e0?o000000?o][3Co`000?ng/M<01_ng/M<2o`0000So^K;B00Co0000okZcdol0003o00001?nj/]80
1?l0003o^kCBok^dd_nk]=82o`0000?o_;?A00?o0000okbdd_nl]=800onl]=82o`0004_ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`03ooooo`00;?ooool2o`0003Sooooo00?o0000
ojV]f_nY[MX01OnY[MX00ol0003o[:kIojb^f@03o`000003ojb]f?l0003o[jkG00Ko[jkG00?o0000
ok6_e_na[mH00_na[mH2o`000003ok6^eOl0003o/joE00Ko/joE00Co0000okFae?l0003o00001Onf
/=<00ol0003o]k7CokNad`02okNad`;o000000?o^;7Bo`000?ni/]801oni/]82o`0000Oo^[;B00?o
0000ok^dd_l000001_nl/m401Ol0003o_;CBokbdd_nl]=;o000004kooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`03ooooo`00;_ooool00ol0003oooooooooo`0fooooo`03o`000?nY
[M[oZJgJ00CoZJgJ0ol00005ojb]f003o`000?n_[]Oo[jkG00Go[jkG00Co0000ok6_e_l0003o0000
1?na[]D00ol0003o/joEok>_e@04ok>_e@;o00002?nf/=<01?l0003o]k7Co`000?l00004okRadP03
o`000?ni/];o^K;B00Co^K;B00?o0000okVadOl000001onj/]82o`0000Oo_;?A00Co0000okbdd_l0
003o0000D?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo000_ooooo`03
o`000?oooooooooo03Kooooo00?o0000ojV]f_nY[MX00ol000000onY[=Wo0000ojb]f006ojb]f003
o`000?n_[]Oo[jkG00Co[jkG0_l00007ok6^e@04o`000?nc[mGo/joEok>_e@;o000000?o/joDo`00
0?nf/=<01onf/=<2o`0000Oo^;7B00Co0000okVbd_ni/];o^K;B0_l00003okVad@03o`000?nj/];o
^[;B00?o^[;B00?o0000ok^bdOl000001onl/m42o`0005;ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`03ooooo`00<?ooool00ol0003oooooooooo`0fooooo`;o00001OnY[=T00ol0
003o[:gHojb]f005ojb]f003o`000?n_[]Oo[jkG00?o000000?o[jgFo`000?na[]D01_na[]D01?l0
003o/joEo`000?l00004ok>_e003o`000?nf/=?o][3C00Co][3C00?o0000okJ_d_l000002?nh/M80
0ol0003o^K;Bo`000006okVad@03o`000?nj/];o^[;B00;o00000onk/]400ol0003o_;?Aokbcd@03
okbcd@03o`000?oooooooooo05?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`03
ooooo`00<Oooool2o`0003Kooooo00?o0000ojV/fOnY[=T01OnY[=T00ol0003o[:gHojb]f004ojb]
f0?o00001On_[MH00ol0003o/JkEok6^e@04ok6^e@;o00001onc[m@01?l0003o][3CokJ`donf/=<2
o`0000?o]ZoB00?o0000okRad_nh/M801Onh/M82o`0000Oo^K7A00?o0000okZbd_l000001_nk/]40
0ol0003o_;?Aokbcd@02o`0005Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03
ooooo`00<oooool00ol0003oooooooooo`0dooooo`03o`000?nY[=WoZJcI00GoZJcI00?o0000ojb]
f?n/[MP00ol000000on/[=Oo0000ojn]eP06ojn]eP03o`000?na[]Go/JkE00?o000000?o/JkDo`00
0?nc[m@01onc[m@00ol0003o][3Co`000006okJ_dP04o`000?nh/M;o^;7BokRadP?o000000?o^;3A
o`000?ni/M401_ni/M42o`0000Oo^k;A00?o0000okbcdOl00000FOooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00;ooooo000dooooo`03o`000?oooooooooo03Cooooo00?o0000ojV/
fOnY[=T01?nY[=T3o`0000Go[:cG00?o0000ojn]e_n_[MH01?n_[MH3o`0000Go/JkD00?o0000ok>_
e?nc[m@01Onc[m@2o`0000Oo]ZoB00Co0000okRad_l0003o00001Onh/=400ol0003o^K7AokVad@03
okVad@03o`000?nj/M3o000000Oo^k;A0_l0001Kooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool00_ooool003Gooooo00?o0000ooooooooool0=?ooool00ol0003oZJcIojV/f@03o`00
0003ojV[f?l0003o[:cG00Ko[:cG00Co0000ojn]e_n_[MKo[jgF0_l000000on_[MGo0000ok6^e006
ok6^e003o`000?nc[mCo/joD00;o/joD0_l000000ond[]?o0000okJ_dP06okJ_dP;o00002?nh/=40
0ol0003o^K7AokVad@02o`0000?o^[7@00?o0000ok^bdOnk/]400onk/]400ol0003oooooooooo`1L
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool003Kooooo0_l0000eoooo
o`;o00001OnYZmP00ol0003o[:cGojb/e`04ojb/e`04o`000?n_[MKo0000o`0000Co[jgE00?o0000
ok6^e?na[]@01Ona[]@01?l0003o/joDo`000?l00004okB^d`03o`000?nf[m;o]ZoB00?o]ZoB00?o
0000okJ_dOl000002?nh/=400ol0003o^K7Ao`000006okZad003o`000?nk/]7o^k;A00;o0000H?oo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo000hooooo`03o`000?oooooo
oooo03;ooooo00?o0000ojV[f?nYZmP01OnYZmP00ol0003o[:cGojb/e`03ojb/e`;o00001on_[MD0
0ol0003o/JkDok6^e004ok6^e0;o00001ond[]<00ol0003o]ZoBokJ_dP02o`0000?o]ZoA00?o0000
okR`dOnh/=401Onh/=42o`0000Oo^[7@00?o0000ok^bdOl00000H_ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00;ooooo000iooooo`03o`000?oooooooooo03;ooooo00?o0000ojV[
f?nYZmP01?nYZmP00ol0003o[:cGojb/e`03o`000003ojb[e_l0003o[jgE00Oo[jgE00?o0000ok6^
e?na[]@00ol000000onb[M?o0000okB^d`06okB^d`03o`000?nf[m;o000000Ko]ZoA00?o0000okR`
dOnh/=400_nh/=42o`000003okR_d?l0003o^[7@00Ko^[7@0_l0001Tooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool00_ooool003[ooooo00?o0000ooooooooool0<_ooool00ol0003o
ZJ_HojV[f003ojV[f0?o00001On/ZmH00ol0003o[jgEojn]e@05ojn]e@?o00001Onb[M<00ol0003o
]:kCokB^d`04okB^d`;o00002?nf[m401?l0003o^;3Ao`000?l00004okR_d003o`000?nj/M3o^[7@
00?o^[7@00?o0000ooooooooool0IOooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00;ooooo000kooooo`;o0000<_ooool00ol0003oZJ_HojV[f003o`000003ojVZf?l0003o[:_F00Ko
[:_F00?o0000ojn]eOn_[MD00_n_[MD2o`000003ojn/e?l0003o/ZgC00Ko/ZgC00Co0000okB^dond
[]?o]:kC0_l000000ond[];o0000okJ_d@07okJ_d@;o00001onh[m000ol0003o^[7@okZad002o`00
06Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`00?Oooool00ol0003o
ooooooooo`0`ooooo`;o00001OnYZ]P00ol0003o[:_Fojb[eP05ojb[eP04o`000?n_[MGo0000o`00
00Co[jcD00?o0000ok:]donb[M<01?nb[M<01?l0003o]:kCo`000?l00004okB^dP03o`000?nf[m7o
]ZoA00Co]ZoA00?o0000okN^dOl000001onh[m000ol0003o^[7@o`00001[ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool00Oooool003kooooo00?o0000ooooooooool0;oooool00ol0
003oZJ[HojVZf005ojVZf003o`000?n/ZmKo[:_F00Co[:_F0_l00007ojn/e003o`000?nb[M?o/ZgC
00?o/ZgC0_l00007okB^dP04o`000?nf[m7o]ZoAokJ_d@;o00000ong[]400ol0003o^:o@okR_d004
okR_d0;o0000KOooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo007ooooo000ooooo
o`03o`000?oooooooooo02oooooo00?o0000ojVZf?nYZ]P01OnYZ]P00ol0003o[:_Fojb[eP03o`00
0003ojb[e_l0003o[jcD00Ko[jcD00?o0000ok:]donb[M<00ol000000onb[=?o0000okB^dP07okB^
dP03o`000?nf[m7o000000Ko]jkA00Co0000okR_d?nh[m3o^:o@0_l0001`ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool00Oooool0043ooooo0_l0000`ooooo`03o`000?nYZ]SoZJ[H
00CoZJ[H0ol00005ojb[eP03o`000?n_[=Co[jcD00Co[jcD0ol00005ok:/d`03o`000?nd[];o]:kB
00Go]:kB0_l00007okN^d@04o`000?nh[m3o0000o`0007?ooooo00Go0000ooooooooooooooooo`00
0003ooooo`00@_ooool00ol0003oooooooooo`0^ooooo`03o`000?nYZ]SoZJ[H00?o000000?oZJWG
o`000?n/ZmH01_n/ZmH01?l0003o[jcDojn/e?n_[=@2o`000003ojn[e?l0003o/ZcC00Ko/ZcC00?o
0000okB^d_nd[]800_nd[]82o`000003okB]dOl0003o]jkA00Ko]jkA0_l0001eooooo`05o`000?oo
ooooooooooooool000000oooool004?ooooo00?o0000ooooooooool0;_ooool2o`0000GoZJWG00?o
0000ojb[e_n/ZmH01?n/ZmH01?l0003o[jcDo`000?l00004ojn[e003o`000?nb[=?o/ZcC00Go/ZcC
00Co0000okB^d_l0003o00001?nd[M400ol0003o]jkAokN^d@02okN^d@;o0000N?ooool01?l0003o
ooooooooool00003ooooo`00A?ooool00ol0003oooooooooo`0]ooooo`03o`000?nYZMOoZJWG00Go
ZJWG00?o0000ojb[e_n/ZmH00on/ZmH2o`0000Oo[j_D00?o0000ok:/donb[=<01?nb[=<2o`0000Oo
]:gA00Co0000okN^dOl0003o0000Noooool00ol0003oooooo`000003ooooo`00AOooool2o`0002ko
oooo00?o0000ojVYeonYZML01?nYZML00ol0003o[:_Fojb[eP03o`000003ojbZeOl0003o[j_D00Oo
[j_D00?o0000ok:/donb[=<00ol000000onb[=;o0000okB]d@06okB]d@;o0000OOooool01?l0003o
ooooooooool00002ooooo`00Aoooool00ol0003oooooooooo`0/ooooo`03o`000?nYZMOoZJWG00?o
ZJWG0ol00005ojbZe@03o`000?n_ZmCo[j_D00Go[j_D0ol00005ok:/dP03o`000?nd[M7o]:gA00?o
]:gA00?o0000ooooooooool0O_ooool00ol0003oooooo`000002ooooo`00B?ooool00ol0003ooooo
ooooo`0[ooooo`03o`000?nYZMOoZJWG00?o000000?oZJSFo`000?n/Z]D01_n/Z]D00ol0003o[j_D
ojn[e002ojn[e0;o000000?o[j[Co`000?nb[=801_nb[=800ol0003o]:gAokB]d@02o`0008;ooooo
0_l00002ooooo`00BOooool00ol0003oooooooooo`0[ooooo`;o00001OnYZ=H00ol0003o[:[EojbZ
e@05ojbZe@04o`000?n_ZmCo0000o`0000Co[j[C00?o0000ok:/d_nb[=801?nb[=800ol0003o]:gA
o`000023ooooo`?o00000_ooool004[ooooo00?o0000ooooooooool0:_ooool00ol0003oZJSFojVX
eP05ojVXeP03o`000?n/Z]Go[:[E00Co[:[E0_l00007ojnZd`03o`000?nb[=;o/ZcB00?o/ZcB0_l0
0020ooooo`Co00001Oooool004_ooooo0_l0000[ooooo`03o`000?nYZ=KoZJSF00GoZJSF00?o0000
ojbZeOn/Z]D00ol000000on/ZMCo0000ojnZd`06ojnZd`03o`000?nb[=;o/ZcB00?o0000O_ooool4
o`0000Wooooo001=ooooo`03o`000?oooooooooo02Wooooo00?o0000ojVXe_nYZ=H01?nYZ=H3o`00
00Go[:WD00?o0000ojnZdon_Z]<01?n_Z]<3o`0007kooooo0ol0000=ooooo`00C_ooool00ol0003o
ooooooooo`0Yooooo`03o`000?nYZ=KoZJSF00?o000000?oZJSEo`000?n/ZM@01_n/ZM@01?l0003o
[j[CojnZdon_Z]<2o`0007gooooo1?l0000@ooooo`00Coooool00ol0003oooooooooo`0Yooooo`;o
00001OnYZ=D00ol0003o[:WDojbYe004ojbYe004o`000?n_Z]?o0000o`0007_ooooo1?l0000Doooo
o`00D?ooool2o`0002Wooooo00?o0000ojVXeOnYZ=D01OnYZ=D00ol0003o[:WDojbYe003ojbYe0;o
0000NOooool4o`0001Sooooo001Booooo`03o`000?oooooooooo02Oooooo00?o0000ojVXeOnYZ=D0
1?nYZ=D00ol0003o[:WDojbYe003o`0007Oooooo1?l0000Looooo`00Doooool00ol0003ooooooooo
o`0Wooooo`03o`000?nYZ=GoZJSE00?oZJSE0ol0001gooooo`?o00008?ooool005Cooooo00?o0000
ooooooooool09_ooool00ol0003oZJSEojVXe@03o`0007Kooooo1?l0000Sooooo`00EOooool2o`00
02Oooooo0_l0001eooooo`Co00009oooool005Oooooo00?o0000ooooooooool09?ooool00ol0003o
ooooooooo`1`ooooo`Co0000:oooool005Sooooo00?o0000ooooooooool08oooool00ol0003ooooo
ooooo`1/ooooo`Co0000;oooool005Wooooo00?o0000ooooooooool08_ooool00ol0003ooooooooo
o`1Yooooo`?o0000<oooool005[ooooo0_l0000Rooooo`03o`000?oooooooooo06Gooooo1?l0000f
ooooo`00G?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo067ooooo1?l0000joooo
o`00GOooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo05gooooo1?l0000nooooo`00
G_ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo05Wooooo1?l00012ooooo`00Gooo
ool2o`0001gooooo00?o0000ooooooooool0E_ooool3o`0004Kooooo001Qooooo`03o`000?oooooo
oooo01[ooooo00?o0000ooooooooool0D_ooool4o`0004Wooooo001Rooooo`03o`000?oooooooooo
01Wooooo00?o0000ooooooooool0C_ooool4o`0004gooooo001Sooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool0B_ooool4o`00057ooooo001Tooooo`;o00006?ooool00ol0003ooooo
ooooo`16ooooo`Co0000EOooool006Kooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`12ooooo`Co0000FOooool006Oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0o
ooooo`?o0000GOooool006Sooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0koooo
o`Co0000H?ooool006Wooooo0_l0000Cooooo`03o`000?oooooooooo03Oooooo1?l0001Tooooo`00
Joooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo03?ooooo1?l0001Xooooo`00K?oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo02oooooo1?l0001/ooooo`00KOooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo02gooooo0ol0001`ooooo`00K_ooool2o`00
00gooooo00?o0000ooooooooool0:Oooool4o`0007?ooooo001`ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool09Oooool4o`0007Oooooo001aooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool08Oooool4o`0007_ooooo001booooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool07Oooool4o`0007oooooo001cooooo`;o00002?ooool00ol0003oooooooooo`0J
ooooo`?o0000Poooool007Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Foooo
o`Co0000Q_ooool007Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`Co
0000R_ooool007Oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0>ooooo`Co0000
S_ooool007Sooooo0_l00003ooooo`03o`000?oooooooooo00[ooooo1?l0002Booooo`00N_ooool0
1?l0003oooooooooool00009ooooo`?o0000U_ooool007_ooooo00?o0000ooooool000001Oooool4
o`0009Wooooo001looooo`;o000000?oooooo`000?l000000_l0002Mooooo`00OOooool2o`000:7o
oooo003oooooob7ooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {232.562, 0}} -> {-0.0711162, 0.0132378, \
0.00358177, 0.00358177}}]
}, Open  ]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[Rosenbrock[{x1, x2, x3, x4, x5}], {x1, x2, x3, x4, x5}, 
      Method -> "\<DifferentialEvolution\>"]\)], "Input"],

Cell[BoxData[
    \({1.2412233305586858`*^-27, {x1 \[Rule] 1.0000000000000038`, 
        x2 \[Rule] 1.0000000000000075`, x3 \[Rule] 1.0000000000000153`, 
        x4 \[Rule] 1.0000000000000304`, 
        x5 \[Rule] 1.0000000000000608`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[
      Rosenbrock[{x1, x2}], {{x1, 0.2}, {x2, 0.2}}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.221154 1.20192 -0.147072 1.12784 [
[.01923 -0.0125 -9 -9 ]
[.01923 -0.0125 9 0 ]
[.25962 -0.0125 -9 -9 ]
[.25962 -0.0125 9 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .0785 -18 -4.5 ]
[-0.0125 .0785 0 4.5 ]
[-0.0125 .30406 -18 -4.5 ]
[-0.0125 .30406 0 4.5 ]
[-0.0125 .52963 -18 -4.5 ]
[-0.0125 .52963 0 4.5 ]
[-0.0125 .7552 -18 -4.5 ]
[-0.0125 .7552 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0.2)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(0.4)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0.6)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(0.8)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(1)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .0785 m
.00625 .0785 L
s
[(0.2)] -0.0125 .0785 1 0 Mshowa
0 .30406 m
.00625 .30406 L
s
[(0.4)] -0.0125 .30406 1 0 Mshowa
0 .52963 m
.00625 .52963 L
s
[(0.6)] -0.0125 .52963 1 0 Mshowa
0 .7552 m
.00625 .7552 L
s
[(0.8)] -0.0125 .7552 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .13489 m
.00375 .13489 L
s
0 .19128 m
.00375 .19128 L
s
0 .24767 m
.00375 .24767 L
s
0 .36046 m
.00375 .36046 L
s
0 .41685 m
.00375 .41685 L
s
0 .47324 m
.00375 .47324 L
s
0 .58602 m
.00375 .58602 L
s
0 .64242 m
.00375 .64242 L
s
0 .69881 m
.00375 .69881 L
s
0 .81159 m
.00375 .81159 L
s
0 .86799 m
.00375 .86799 L
s
0 .92438 m
.00375 .92438 L
s
0 .0221 m
.00375 .0221 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .0785 m
1 .0785 L
s
.99375 .30406 m
1 .30406 L
s
.99375 .52963 m
1 .52963 L
s
.99375 .7552 m
1 .7552 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .13489 m
1 .13489 L
s
.99625 .19128 m
1 .19128 L
s
.99625 .24767 m
1 .24767 L
s
.99625 .36046 m
1 .36046 L
s
.99625 .41685 m
1 .41685 L
s
.99625 .47324 m
1 .47324 L
s
.99625 .58602 m
1 .58602 L
s
.99625 .64242 m
1 .64242 L
s
.99625 .69881 m
1 .69881 L
s
.99625 .81159 m
1 .81159 L
s
.99625 .86799 m
1 .86799 L
s
.99625 .92438 m
1 .92438 L
s
.99625 .0221 m
1 .0221 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.925 g
.01923 .17195 m
.02575 .17463 L
.02894 .17597 L
.03866 .18013 L
.04816 .18434 L
.04837 .18444 L
.05808 .18889 L
.06779 .19348 L
.06899 .19406 L
.07751 .19822 L
.08722 .2031 L
.08853 .20377 L
.09693 .20812 L
.10664 .21329 L
.10699 .21348 L
.11636 .21861 L
.12454 .22319 L
.12607 .22406 L
.13578 .22967 L
.14129 .23291 L
.14549 .23541 L
.15521 .2413 L
.15735 .24262 L
.16492 .24734 L
.17279 .25233 L
.17463 .25351 L
.18434 .25984 L
.18768 .26204 L
.19406 .2663 L
.20208 .27176 L
.20377 .27291 L
.21348 .27967 L
.21604 .28147 L
.22319 .28657 L
.22958 .29118 L
.23291 .29361 L
.24262 .30079 L
.24275 .30089 L
.25233 .30813 L
.25558 .31061 L
.26204 .3156 L
.26808 .32032 L
.27176 .32322 L
.28029 .33003 L
.28147 .33098 L
.29118 .33889 L
.29222 .33974 L
.30089 .34694 L
.30389 .34946 L
.31061 .35514 L
.31532 .35917 L
.32032 .36348 L
.32652 .36888 L
.33003 .37196 L
.33751 .37859 L
.33974 .38059 L
.34829 .38831 L
.34946 .38936 L
.35889 .39802 L
.35917 .39828 L
.36888 .40734 L
.36929 .40773 L
.37859 .41655 L
.37953 .41744 L
.38831 .4259 L
.3896 .42716 L
.39802 .43539 L
.39952 .43687 L
.40773 .44503 L
.40928 .44658 L
.41744 .45481 L
.4189 .45629 L
.42716 .46474 L
.42839 .46601 L
.43687 .47481 L
.43774 .47572 L
.44658 .48502 L
.44696 .48543 L
.45607 .49514 L
.45629 .49538 L
.46506 .50486 L
.46601 .50589 L
.47393 .51457 L
.47572 .51654 L
.4827 .52428 L
.48543 .52733 L
.49137 .53399 L
.49514 .53827 L
.49993 .54371 L
.50486 .54935 L
.50839 .55342 L
.51457 .56057 L
.51677 .56313 L
.52428 .57194 L
.52505 .57284 L
.53324 .58256 L
.53399 .58346 L
.54135 .59227 L
.54371 .59511 L
.54937 .60198 L
.55342 .60692 L
.55732 .61169 L
.56313 .61886 L
.56518 .62141 L
.57284 .63095 L
.57298 .63112 L
.58069 .64083 L
.58256 .64319 L
.58834 .65054 L
.59227 .65557 L
.59592 .66026 L
.60198 .66809 L
.60343 .66997 L
.61087 .67968 L
.61169 .68076 L
.61825 .68939 L
.62141 .69358 L
.62557 .69911 L
.63112 .70653 L
.63282 .70882 L
.64002 .71853 L
.64083 .71963 L
.64716 .72824 L
.65054 .73288 L
.65424 .73796 L
.66026 .74627 L
.66126 .74767 L
.66824 .75738 L
.66997 .75981 L
.67516 .76709 L
.67968 .77348 L
.68202 .77681 L
.68884 .78652 L
.68939 .78731 L
.69561 .79623 L
.69911 .80128 L
.70233 .80594 L
.70882 .81539 L
.709 .81566 L
.71563 .82537 L
.71853 .82965 L
.72221 .83508 L
.72824 .84405 L
.72875 .84479 L
.73524 .85451 L
.73796 .85859 L
.74169 .86422 L
.74767 .87328 L
.7481 .87393 L
.75446 .88364 L
.75738 .88812 L
.76079 .89336 L
.76708 .90307 L
.76709 .90309 L
.77333 .91278 L
.77681 .91822 L
.77954 .92249 L
.78571 .93221 L
.78652 .93348 L
.79185 .94192 L
.79623 .9489 L
.79795 .95163 L
.80401 .96134 L
.80594 .96445 L
.81004 .97106 L
.81566 .98015 L
.81604 .98077 L
.01923 .98077 L
F
0 g
.01923 .17195 m
.02575 .17463 L
.02894 .17597 L
.03866 .18013 L
.04816 .18434 L
.04837 .18444 L
.05808 .18889 L
.06779 .19348 L
.06899 .19406 L
.07751 .19822 L
.08722 .2031 L
.08853 .20377 L
.09693 .20812 L
.10664 .21329 L
.10699 .21348 L
.11636 .21861 L
.12454 .22319 L
.12607 .22406 L
.13578 .22967 L
.14129 .23291 L
.14549 .23541 L
.15521 .2413 L
.15735 .24262 L
.16492 .24734 L
.17279 .25233 L
.17463 .25351 L
.18434 .25984 L
.18768 .26204 L
.19406 .2663 L
.20208 .27176 L
.20377 .27291 L
.21348 .27967 L
.21604 .28147 L
.22319 .28657 L
.22958 .29118 L
.23291 .29361 L
.24262 .30079 L
.24275 .30089 L
.25233 .30813 L
.25558 .31061 L
.26204 .3156 L
.26808 .32032 L
.27176 .32322 L
.28029 .33003 L
.28147 .33098 L
.29118 .33889 L
.29222 .33974 L
.30089 .34694 L
.30389 .34946 L
.31061 .35514 L
Mistroke
.31532 .35917 L
.32032 .36348 L
.32652 .36888 L
.33003 .37196 L
.33751 .37859 L
.33974 .38059 L
.34829 .38831 L
.34946 .38936 L
.35889 .39802 L
.35917 .39828 L
.36888 .40734 L
.36929 .40773 L
.37859 .41655 L
.37953 .41744 L
.38831 .4259 L
.3896 .42716 L
.39802 .43539 L
.39952 .43687 L
.40773 .44503 L
.40928 .44658 L
.41744 .45481 L
.4189 .45629 L
.42716 .46474 L
.42839 .46601 L
.43687 .47481 L
.43774 .47572 L
.44658 .48502 L
.44696 .48543 L
.45607 .49514 L
.45629 .49538 L
.46506 .50486 L
.46601 .50589 L
.47393 .51457 L
.47572 .51654 L
.4827 .52428 L
.48543 .52733 L
.49137 .53399 L
.49514 .53827 L
.49993 .54371 L
.50486 .54935 L
.50839 .55342 L
.51457 .56057 L
.51677 .56313 L
.52428 .57194 L
.52505 .57284 L
.53324 .58256 L
.53399 .58346 L
.54135 .59227 L
.54371 .59511 L
.54937 .60198 L
Mistroke
.55342 .60692 L
.55732 .61169 L
.56313 .61886 L
.56518 .62141 L
.57284 .63095 L
.57298 .63112 L
.58069 .64083 L
.58256 .64319 L
.58834 .65054 L
.59227 .65557 L
.59592 .66026 L
.60198 .66809 L
.60343 .66997 L
.61087 .67968 L
.61169 .68076 L
.61825 .68939 L
.62141 .69358 L
.62557 .69911 L
.63112 .70653 L
.63282 .70882 L
.64002 .71853 L
.64083 .71963 L
.64716 .72824 L
.65054 .73288 L
.65424 .73796 L
.66026 .74627 L
.66126 .74767 L
.66824 .75738 L
.66997 .75981 L
.67516 .76709 L
.67968 .77348 L
.68202 .77681 L
.68884 .78652 L
.68939 .78731 L
.69561 .79623 L
.69911 .80128 L
.70233 .80594 L
.70882 .81539 L
.709 .81566 L
.71563 .82537 L
.71853 .82965 L
.72221 .83508 L
.72824 .84405 L
.72875 .84479 L
.73524 .85451 L
.73796 .85859 L
.74169 .86422 L
.74767 .87328 L
.7481 .87393 L
.75446 .88364 L
Mistroke
.75738 .88812 L
.76079 .89336 L
.76708 .90307 L
.76709 .90309 L
.77333 .91278 L
.77681 .91822 L
.77954 .92249 L
.78571 .93221 L
.78652 .93348 L
.79185 .94192 L
.79623 .9489 L
.79795 .95163 L
.80401 .96134 L
.80594 .96445 L
.81004 .97106 L
.81566 .98015 L
.81604 .98077 L
Mfstroke
.85 g
.01923 .33129 m
.02894 .3352 L
.03866 .33925 L
.03981 .33974 L
.04837 .34345 L
.05808 .34779 L
.06171 .34946 L
.06779 .35228 L
.07751 .35692 L
.08212 .35917 L
.08722 .3617 L
.09693 .36662 L
.10129 .36888 L
.10664 .37169 L
.11636 .37691 L
.11944 .37859 L
.12607 .38227 L
.13578 .38778 L
.1367 .38831 L
.14549 .39343 L
.1532 .39802 L
.15521 .39923 L
.16492 .40517 L
.16904 .40773 L
.17463 .41126 L
.18427 .41744 L
.18434 .41749 L
.19406 .42387 L
.19898 .42716 L
.20377 .43039 L
.21321 .43687 L
.21348 .43706 L
.22319 .44387 L
.227 .44658 L
.23291 .45083 L
.24039 .45629 L
.24262 .45794 L
.25233 .46519 L
.25341 .46601 L
.26204 .47259 L
.2661 .47572 L
.27176 .48013 L
.27848 .48543 L
.28147 .48781 L
.29057 .49514 L
.29118 .49564 L
.30089 .50362 L
.30238 .50486 L
.31061 .51174 L
.31394 .51457 L
.32032 .52001 L
.32527 .52428 L
.33003 .52843 L
.33637 .53399 L
.33974 .53698 L
.34726 .54371 L
.34946 .54569 L
.35795 .55342 L
.35917 .55454 L
.36845 .56313 L
.36888 .56353 L
.37859 .57267 L
.37877 .57284 L
.38831 .58196 L
.38893 .58256 L
.39802 .59139 L
.39892 .59227 L
.40773 .60096 L
.40875 .60198 L
.41744 .61069 L
.41844 .61169 L
.42716 .62055 L
.42799 .62141 L
.43687 .63057 L
.4374 .63112 L
.44658 .64072 L
.44668 .64083 L
.45584 .65054 L
.45629 .65103 L
.46488 .66026 L
.46601 .66148 L
.4738 .66997 L
.47572 .67207 L
.48262 .67968 L
.48543 .68281 L
.49132 .68939 L
.49514 .69369 L
.49993 .69911 L
.50486 .70472 L
.50843 .70882 L
.51457 .7159 L
.51684 .71853 L
.52428 .72722 L
.52515 .72824 L
.53338 .73796 L
.53399 .73869 L
.54152 .74767 L
.54371 .7503 L
.54957 .75738 L
.55342 .76205 L
.55755 .76709 L
.56313 .77396 L
.56544 .77681 L
.57284 .786 L
.57326 .78652 L
.581 .79623 L
.58256 .7982 L
.58867 .80594 L
.59227 .81054 L
.59627 .81566 L
.60198 .82302 L
.6038 .82537 L
.61126 .83508 L
.61169 .83565 L
.61866 .84479 L
.62141 .84842 L
.62599 .85451 L
.63112 .86134 L
.63327 .86422 L
.64048 .87393 L
.64083 .87441 L
.64763 .88364 L
.65054 .88762 L
.65473 .89336 L
.66026 .90098 L
.66177 .90307 L
.66875 .91278 L
.66997 .91448 L
.67569 .92249 L
.67968 .92813 L
.68257 .93221 L
.68939 .94192 L
.68939 .94192 L
.69617 .95163 L
.69911 .95586 L
.7029 .96134 L
.70882 .96994 L
.70958 .97106 L
.71622 .98077 L
.01923 .98077 L
F
0 g
.01923 .33129 m
.02894 .3352 L
.03866 .33925 L
.03981 .33974 L
.04837 .34345 L
.05808 .34779 L
.06171 .34946 L
.06779 .35228 L
.07751 .35692 L
.08212 .35917 L
.08722 .3617 L
.09693 .36662 L
.10129 .36888 L
.10664 .37169 L
.11636 .37691 L
.11944 .37859 L
.12607 .38227 L
.13578 .38778 L
.1367 .38831 L
.14549 .39343 L
.1532 .39802 L
.15521 .39923 L
.16492 .40517 L
.16904 .40773 L
.17463 .41126 L
.18427 .41744 L
.18434 .41749 L
.19406 .42387 L
.19898 .42716 L
.20377 .43039 L
.21321 .43687 L
.21348 .43706 L
.22319 .44387 L
.227 .44658 L
.23291 .45083 L
.24039 .45629 L
.24262 .45794 L
.25233 .46519 L
.25341 .46601 L
.26204 .47259 L
.2661 .47572 L
.27176 .48013 L
.27848 .48543 L
.28147 .48781 L
.29057 .49514 L
.29118 .49564 L
.30089 .50362 L
.30238 .50486 L
.31061 .51174 L
.31394 .51457 L
Mistroke
.32032 .52001 L
.32527 .52428 L
.33003 .52843 L
.33637 .53399 L
.33974 .53698 L
.34726 .54371 L
.34946 .54569 L
.35795 .55342 L
.35917 .55454 L
.36845 .56313 L
.36888 .56353 L
.37859 .57267 L
.37877 .57284 L
.38831 .58196 L
.38893 .58256 L
.39802 .59139 L
.39892 .59227 L
.40773 .60096 L
.40875 .60198 L
.41744 .61069 L
.41844 .61169 L
.42716 .62055 L
.42799 .62141 L
.43687 .63057 L
.4374 .63112 L
.44658 .64072 L
.44668 .64083 L
.45584 .65054 L
.45629 .65103 L
.46488 .66026 L
.46601 .66148 L
.4738 .66997 L
.47572 .67207 L
.48262 .67968 L
.48543 .68281 L
.49132 .68939 L
.49514 .69369 L
.49993 .69911 L
.50486 .70472 L
.50843 .70882 L
.51457 .7159 L
.51684 .71853 L
.52428 .72722 L
.52515 .72824 L
.53338 .73796 L
.53399 .73869 L
.54152 .74767 L
.54371 .7503 L
.54957 .75738 L
.55342 .76205 L
Mistroke
.55755 .76709 L
.56313 .77396 L
.56544 .77681 L
.57284 .786 L
.57326 .78652 L
.581 .79623 L
.58256 .7982 L
.58867 .80594 L
.59227 .81054 L
.59627 .81566 L
.60198 .82302 L
.6038 .82537 L
.61126 .83508 L
.61169 .83565 L
.61866 .84479 L
.62141 .84842 L
.62599 .85451 L
.63112 .86134 L
.63327 .86422 L
.64048 .87393 L
.64083 .87441 L
.64763 .88364 L
.65054 .88762 L
.65473 .89336 L
.66026 .90098 L
.66177 .90307 L
.66875 .91278 L
.66997 .91448 L
.67569 .92249 L
.67968 .92813 L
.68257 .93221 L
.68939 .94192 L
.68939 .94192 L
.69617 .95163 L
.69911 .95586 L
.7029 .96134 L
.70882 .96994 L
.70958 .97106 L
.71622 .98077 L
Mfstroke
.775 g
.01923 .44611 m
.02042 .44658 L
.02894 .44998 L
.03866 .454 L
.04406 .45629 L
.04837 .45816 L
.05808 .46246 L
.06584 .46601 L
.06779 .46691 L
.07751 .47151 L
.08614 .47572 L
.08722 .47625 L
.09693 .48114 L
.10522 .48543 L
.10664 .48618 L
.11636 .49136 L
.12329 .49514 L
.12607 .49668 L
.13578 .50215 L
.14048 .50486 L
.14549 .50777 L
.15521 .51353 L
.15692 .51457 L
.16492 .51944 L
.1727 .52428 L
.17463 .5255 L
.18434 .5317 L
.18788 .53399 L
.19406 .53805 L
.20254 .54371 L
.20377 .54454 L
.21348 .55117 L
.21672 .55342 L
.22319 .55796 L
.23046 .56313 L
.23291 .56489 L
.24262 .57196 L
.24381 .57284 L
.25233 .57918 L
.2568 .58256 L
.26204 .58655 L
.26945 .59227 L
.27176 .59406 L
.28147 .60172 L
.2818 .60198 L
.29118 .60952 L
.29385 .61169 L
.30089 .61747 L
.30563 .62141 L
.31061 .62557 L
.31717 .63112 L
.32032 .63381 L
.32846 .64083 L
.33003 .6422 L
.33953 .65054 L
.33974 .65073 L
.34946 .65941 L
.3504 .66026 L
.35917 .66823 L
.36106 .66997 L
.36888 .6772 L
.37154 .67968 L
.37859 .68632 L
.38184 .68939 L
.38831 .69558 L
.39197 .69911 L
.39802 .70499 L
.40193 .70882 L
.40773 .71454 L
.41175 .71853 L
.41744 .72424 L
.42141 .72824 L
.42716 .73408 L
.43094 .73796 L
.43687 .74407 L
.44033 .74767 L
.44658 .75421 L
.44959 .75738 L
.45629 .76449 L
.45873 .76709 L
.46601 .77492 L
.46775 .77681 L
.47572 .78549 L
.47665 .78652 L
.48543 .79621 L
.48545 .79623 L
.49414 .80594 L
.49514 .80708 L
.50272 .81566 L
.50486 .81809 L
.51121 .82537 L
.51457 .82925 L
.5196 .83508 L
.52428 .84055 L
.5279 .84479 L
.53399 .852 L
.53611 .85451 L
.54371 .86359 L
.54423 .86422 L
.55227 .87393 L
.55342 .87533 L
.56023 .88364 L
.56313 .88722 L
.5681 .89336 L
.57284 .89925 L
.5759 .90307 L
.58256 .91142 L
.58363 .91278 L
.59129 .92249 L
.59227 .92375 L
.59887 .93221 L
.60198 .93622 L
.60639 .94192 L
.61169 .94883 L
.61384 .95163 L
.62122 .96134 L
.62141 .96159 L
.62854 .97106 L
.63112 .9745 L
.6358 .98077 L
.01923 .98077 L
F
0 g
.01923 .44611 m
.02042 .44658 L
.02894 .44998 L
.03866 .454 L
.04406 .45629 L
.04837 .45816 L
.05808 .46246 L
.06584 .46601 L
.06779 .46691 L
.07751 .47151 L
.08614 .47572 L
.08722 .47625 L
.09693 .48114 L
.10522 .48543 L
.10664 .48618 L
.11636 .49136 L
.12329 .49514 L
.12607 .49668 L
.13578 .50215 L
.14048 .50486 L
.14549 .50777 L
.15521 .51353 L
.15692 .51457 L
.16492 .51944 L
.1727 .52428 L
.17463 .5255 L
.18434 .5317 L
.18788 .53399 L
.19406 .53805 L
.20254 .54371 L
.20377 .54454 L
.21348 .55117 L
.21672 .55342 L
.22319 .55796 L
.23046 .56313 L
.23291 .56489 L
.24262 .57196 L
.24381 .57284 L
.25233 .57918 L
.2568 .58256 L
.26204 .58655 L
.26945 .59227 L
.27176 .59406 L
.28147 .60172 L
.2818 .60198 L
.29118 .60952 L
.29385 .61169 L
.30089 .61747 L
.30563 .62141 L
.31061 .62557 L
Mistroke
.31717 .63112 L
.32032 .63381 L
.32846 .64083 L
.33003 .6422 L
.33953 .65054 L
.33974 .65073 L
.34946 .65941 L
.3504 .66026 L
.35917 .66823 L
.36106 .66997 L
.36888 .6772 L
.37154 .67968 L
.37859 .68632 L
.38184 .68939 L
.38831 .69558 L
.39197 .69911 L
.39802 .70499 L
.40193 .70882 L
.40773 .71454 L
.41175 .71853 L
.41744 .72424 L
.42141 .72824 L
.42716 .73408 L
.43094 .73796 L
.43687 .74407 L
.44033 .74767 L
.44658 .75421 L
.44959 .75738 L
.45629 .76449 L
.45873 .76709 L
.46601 .77492 L
.46775 .77681 L
.47572 .78549 L
.47665 .78652 L
.48543 .79621 L
.48545 .79623 L
.49414 .80594 L
.49514 .80708 L
.50272 .81566 L
.50486 .81809 L
.51121 .82537 L
.51457 .82925 L
.5196 .83508 L
.52428 .84055 L
.5279 .84479 L
.53399 .852 L
.53611 .85451 L
.54371 .86359 L
.54423 .86422 L
.55227 .87393 L
Mistroke
.55342 .87533 L
.56023 .88364 L
.56313 .88722 L
.5681 .89336 L
.57284 .89925 L
.5759 .90307 L
.58256 .91142 L
.58363 .91278 L
.59129 .92249 L
.59227 .92375 L
.59887 .93221 L
.60198 .93622 L
.60639 .94192 L
.61169 .94883 L
.61384 .95163 L
.62122 .96134 L
.62141 .96159 L
.62854 .97106 L
.63112 .9745 L
.6358 .98077 L
Mfstroke
.7 g
.01923 .54074 m
.02675 .54371 L
.02894 .54459 L
.03866 .54858 L
.04837 .55272 L
.04998 .55342 L
.05808 .557 L
.06779 .56143 L
.07144 .56313 L
.07751 .56601 L
.08722 .57073 L
.09147 .57284 L
.09693 .5756 L
.10664 .58061 L
.11033 .58256 L
.11636 .58577 L
.12607 .59108 L
.12821 .59227 L
.13578 .59653 L
.14524 .60198 L
.14549 .60213 L
.15521 .60788 L
.16153 .61169 L
.16492 .61377 L
.17463 .6198 L
.17717 .62141 L
.18434 .62598 L
.19224 .63112 L
.19406 .63231 L
.20377 .63879 L
.20679 .64083 L
.21348 .64541 L
.22087 .65054 L
.22319 .65217 L
.23291 .65908 L
.23453 .66026 L
.24262 .66614 L
.2478 .66997 L
.25233 .67335 L
.26071 .67968 L
.26204 .6807 L
.27176 .68819 L
.27329 .68939 L
.28147 .69584 L
.28557 .69911 L
.29118 .70362 L
.29756 .70882 L
.30089 .71156 L
.30929 .71853 L
.31061 .71964 L
.32032 .72786 L
.32076 .72824 L
.33003 .73624 L
.33201 .73796 L
.33974 .74475 L
.34303 .74767 L
.34946 .75342 L
.35385 .75738 L
.35917 .76223 L
.36446 .76709 L
.36888 .77118 L
.3749 .77681 L
.37859 .78029 L
.38516 .78652 L
.38831 .78953 L
.39525 .79623 L
.39802 .79893 L
.40517 .80594 L
.40773 .80847 L
.41495 .81566 L
.41744 .81816 L
.42458 .82537 L
.42716 .82799 L
.43408 .83508 L
.43687 .83797 L
.44344 .84479 L
.44658 .84809 L
.45267 .85451 L
.45629 .85836 L
.46177 .86422 L
.46601 .86878 L
.47076 .87393 L
.47572 .87934 L
.47964 .88364 L
.48543 .89005 L
.48841 .89336 L
.49514 .9009 L
.49707 .90307 L
.50486 .9119 L
.50563 .91278 L
.51409 .92249 L
.51457 .92305 L
.52246 .93221 L
.52428 .93434 L
.53073 .94192 L
.53399 .94578 L
.53892 .95163 L
.54371 .95736 L
.54702 .96134 L
.55342 .96909 L
.55503 .97106 L
.56297 .98077 L
.01923 .98077 L
F
0 g
.01923 .54074 m
.02675 .54371 L
.02894 .54459 L
.03866 .54858 L
.04837 .55272 L
.04998 .55342 L
.05808 .557 L
.06779 .56143 L
.07144 .56313 L
.07751 .56601 L
.08722 .57073 L
.09147 .57284 L
.09693 .5756 L
.10664 .58061 L
.11033 .58256 L
.11636 .58577 L
.12607 .59108 L
.12821 .59227 L
.13578 .59653 L
.14524 .60198 L
.14549 .60213 L
.15521 .60788 L
.16153 .61169 L
.16492 .61377 L
.17463 .6198 L
.17717 .62141 L
.18434 .62598 L
.19224 .63112 L
.19406 .63231 L
.20377 .63879 L
.20679 .64083 L
.21348 .64541 L
.22087 .65054 L
.22319 .65217 L
.23291 .65908 L
.23453 .66026 L
.24262 .66614 L
.2478 .66997 L
.25233 .67335 L
.26071 .67968 L
.26204 .6807 L
.27176 .68819 L
.27329 .68939 L
.28147 .69584 L
.28557 .69911 L
.29118 .70362 L
.29756 .70882 L
.30089 .71156 L
.30929 .71853 L
.31061 .71964 L
Mistroke
.32032 .72786 L
.32076 .72824 L
.33003 .73624 L
.33201 .73796 L
.33974 .74475 L
.34303 .74767 L
.34946 .75342 L
.35385 .75738 L
.35917 .76223 L
.36446 .76709 L
.36888 .77118 L
.3749 .77681 L
.37859 .78029 L
.38516 .78652 L
.38831 .78953 L
.39525 .79623 L
.39802 .79893 L
.40517 .80594 L
.40773 .80847 L
.41495 .81566 L
.41744 .81816 L
.42458 .82537 L
.42716 .82799 L
.43408 .83508 L
.43687 .83797 L
.44344 .84479 L
.44658 .84809 L
.45267 .85451 L
.45629 .85836 L
.46177 .86422 L
.46601 .86878 L
.47076 .87393 L
.47572 .87934 L
.47964 .88364 L
.48543 .89005 L
.48841 .89336 L
.49514 .9009 L
.49707 .90307 L
.50486 .9119 L
.50563 .91278 L
.51409 .92249 L
.51457 .92305 L
.52246 .93221 L
.52428 .93434 L
.53073 .94192 L
.53399 .94578 L
.53892 .95163 L
.54371 .95736 L
.54702 .96134 L
.55342 .96909 L
Mistroke
.55503 .97106 L
.56297 .98077 L
Mfstroke
.625 g
.01923 .62312 m
.02894 .62695 L
.03866 .63093 L
.03911 .63112 L
.04837 .63506 L
.05808 .63933 L
.06143 .64083 L
.06779 .64374 L
.07751 .6483 L
.08216 .65054 L
.08722 .65301 L
.09693 .65787 L
.1016 .66026 L
.10664 .66287 L
.11636 .66802 L
.11997 .66997 L
.12607 .67331 L
.13578 .67875 L
.13742 .67968 L
.14549 .68434 L
.15408 .68939 L
.15521 .69007 L
.16492 .69595 L
.17004 .69911 L
.17463 .70197 L
.18434 .70814 L
.1854 .70882 L
.19406 .71446 L
.20021 .71853 L
.20377 .72092 L
.21348 .72753 L
.21452 .72824 L
.22319 .73428 L
.22839 .73796 L
.23291 .74118 L
.24185 .74767 L
.24262 .74823 L
.25233 .75542 L
.25494 .75738 L
.26204 .76276 L
.26769 .76709 L
.27176 .77025 L
.28011 .77681 L
.28147 .77788 L
.29118 .78566 L
.29225 .78652 L
.30089 .79358 L
.3041 .79623 L
.31061 .80165 L
.3157 .80594 L
.32032 .80987 L
.32706 .81566 L
.33003 .81823 L
.33819 .82537 L
.33974 .82674 L
.34911 .83508 L
.34946 .83539 L
.35917 .84419 L
.35983 .84479 L
.36888 .85314 L
.37035 .85451 L
.37859 .86223 L
.38069 .86422 L
.38831 .87147 L
.39087 .87393 L
.39802 .88086 L
.40087 .88364 L
.40773 .89039 L
.41072 .89336 L
.41744 .90007 L
.42043 .90307 L
.42716 .90989 L
.42999 .91278 L
.43687 .91986 L
.43941 .92249 L
.44658 .92998 L
.4487 .93221 L
.45629 .94024 L
.45787 .94192 L
.46601 .95065 L
.46692 .95163 L
.47572 .9612 L
.47585 .96134 L
.48467 .97106 L
.48543 .9719 L
.49338 .98077 L
.01923 .98077 L
F
0 g
.01923 .62312 m
.02894 .62695 L
.03866 .63093 L
.03911 .63112 L
.04837 .63506 L
.05808 .63933 L
.06143 .64083 L
.06779 .64374 L
.07751 .6483 L
.08216 .65054 L
.08722 .65301 L
.09693 .65787 L
.1016 .66026 L
.10664 .66287 L
.11636 .66802 L
.11997 .66997 L
.12607 .67331 L
.13578 .67875 L
.13742 .67968 L
.14549 .68434 L
.15408 .68939 L
.15521 .69007 L
.16492 .69595 L
.17004 .69911 L
.17463 .70197 L
.18434 .70814 L
.1854 .70882 L
.19406 .71446 L
.20021 .71853 L
.20377 .72092 L
.21348 .72753 L
.21452 .72824 L
.22319 .73428 L
.22839 .73796 L
.23291 .74118 L
.24185 .74767 L
.24262 .74823 L
.25233 .75542 L
.25494 .75738 L
.26204 .76276 L
.26769 .76709 L
.27176 .77025 L
.28011 .77681 L
.28147 .77788 L
.29118 .78566 L
.29225 .78652 L
.30089 .79358 L
.3041 .79623 L
.31061 .80165 L
.3157 .80594 L
Mistroke
.32032 .80987 L
.32706 .81566 L
.33003 .81823 L
.33819 .82537 L
.33974 .82674 L
.34911 .83508 L
.34946 .83539 L
.35917 .84419 L
.35983 .84479 L
.36888 .85314 L
.37035 .85451 L
.37859 .86223 L
.38069 .86422 L
.38831 .87147 L
.39087 .87393 L
.39802 .88086 L
.40087 .88364 L
.40773 .89039 L
.41072 .89336 L
.41744 .90007 L
.42043 .90307 L
.42716 .90989 L
.42999 .91278 L
.43687 .91986 L
.43941 .92249 L
.44658 .92998 L
.4487 .93221 L
.45629 .94024 L
.45787 .94192 L
.46601 .95065 L
.46692 .95163 L
.47572 .9612 L
.47585 .96134 L
.48467 .97106 L
.48543 .9719 L
.49338 .98077 L
Mfstroke
.55 g
.01923 .69705 m
.0245 .69911 L
.02894 .70087 L
.03866 .70484 L
.04805 .70882 L
.04837 .70896 L
.05808 .71322 L
.06779 .71762 L
.06976 .71853 L
.07751 .72218 L
.08722 .72687 L
.08999 .72824 L
.09693 .73172 L
.10664 .73671 L
.10902 .73796 L
.11636 .74185 L
.12607 .74713 L
.12704 .74767 L
.13578 .75256 L
.14419 .75738 L
.14549 .75814 L
.15521 .76386 L
.16058 .76709 L
.16492 .76973 L
.17463 .77575 L
.17632 .77681 L
.18434 .78191 L
.19146 .78652 L
.19406 .78822 L
.20377 .79467 L
.20609 .79623 L
.21348 .80127 L
.22023 .80594 L
.22319 .80802 L
.23291 .81491 L
.23395 .81566 L
.24262 .82195 L
.24727 .82537 L
.25233 .82913 L
.26022 .83508 L
.26204 .83647 L
.27176 .84394 L
.27285 .84479 L
.28147 .85157 L
.28516 .85451 L
.29118 .85934 L
.29719 .86422 L
.30089 .86725 L
.30895 .87393 L
.31061 .87532 L
.32032 .88353 L
.32046 .88364 L
.33003 .89188 L
.33173 .89336 L
.33974 .90038 L
.34278 .90307 L
.34946 .90903 L
.35362 .91278 L
.35917 .91782 L
.36426 .92249 L
.36888 .92676 L
.37472 .93221 L
.37859 .93585 L
.38499 .94192 L
.38831 .94508 L
.3951 .95163 L
.39802 .95446 L
.40505 .96134 L
.40773 .96399 L
.41484 .97106 L
.41744 .97366 L
.42449 .98077 L
.01923 .98077 L
F
0 g
.01923 .69705 m
.0245 .69911 L
.02894 .70087 L
.03866 .70484 L
.04805 .70882 L
.04837 .70896 L
.05808 .71322 L
.06779 .71762 L
.06976 .71853 L
.07751 .72218 L
.08722 .72687 L
.08999 .72824 L
.09693 .73172 L
.10664 .73671 L
.10902 .73796 L
.11636 .74185 L
.12607 .74713 L
.12704 .74767 L
.13578 .75256 L
.14419 .75738 L
.14549 .75814 L
.15521 .76386 L
.16058 .76709 L
.16492 .76973 L
.17463 .77575 L
.17632 .77681 L
.18434 .78191 L
.19146 .78652 L
.19406 .78822 L
.20377 .79467 L
.20609 .79623 L
.21348 .80127 L
.22023 .80594 L
.22319 .80802 L
.23291 .81491 L
.23395 .81566 L
.24262 .82195 L
.24727 .82537 L
.25233 .82913 L
.26022 .83508 L
.26204 .83647 L
.27176 .84394 L
.27285 .84479 L
.28147 .85157 L
.28516 .85451 L
.29118 .85934 L
.29719 .86422 L
.30089 .86725 L
.30895 .87393 L
.31061 .87532 L
Mistroke
.32032 .88353 L
.32046 .88364 L
.33003 .89188 L
.33173 .89336 L
.33974 .90038 L
.34278 .90307 L
.34946 .90903 L
.35362 .91278 L
.35917 .91782 L
.36426 .92249 L
.36888 .92676 L
.37472 .93221 L
.37859 .93585 L
.38499 .94192 L
.38831 .94508 L
.3951 .95163 L
.39802 .95446 L
.40505 .96134 L
.40773 .96399 L
.41484 .97106 L
.41744 .97366 L
.42449 .98077 L
Mfstroke
.475 g
.01923 .7647 m
.02537 .76709 L
.02894 .76851 L
.03866 .77247 L
.04837 .77658 L
.0489 .77681 L
.05808 .78083 L
.06779 .78523 L
.07058 .78652 L
.07751 .78978 L
.08722 .79447 L
.09079 .79623 L
.09693 .79931 L
.10664 .80429 L
.10981 .80594 L
.11636 .80942 L
.12607 .8147 L
.12781 .81566 L
.13578 .82012 L
.14494 .82537 L
.14549 .82569 L
.15521 .83141 L
.16132 .83508 L
.16492 .83727 L
.17463 .84328 L
.17705 .84479 L
.18434 .84943 L
.19218 .85451 L
.19406 .85573 L
.20377 .86218 L
.20679 .86422 L
.21348 .86877 L
.22093 .87393 L
.22319 .87551 L
.23291 .8824 L
.23464 .88364 L
.24262 .88943 L
.24795 .89336 L
.25233 .89661 L
.2609 .90307 L
.26204 .90394 L
.27176 .91141 L
.27352 .91278 L
.28147 .91903 L
.28583 .92249 L
.29118 .92679 L
.29785 .93221 L
.30089 .9347 L
.3096 .94192 L
.31061 .94276 L
.32032 .95096 L
.3211 .95163 L
.33003 .95931 L
.33237 .96134 L
.33974 .96781 L
.34341 .97106 L
.34946 .97645 L
.35425 .98077 L
.01923 .98077 L
F
0 g
.01923 .7647 m
.02537 .76709 L
.02894 .76851 L
.03866 .77247 L
.04837 .77658 L
.0489 .77681 L
.05808 .78083 L
.06779 .78523 L
.07058 .78652 L
.07751 .78978 L
.08722 .79447 L
.09079 .79623 L
.09693 .79931 L
.10664 .80429 L
.10981 .80594 L
.11636 .80942 L
.12607 .8147 L
.12781 .81566 L
.13578 .82012 L
.14494 .82537 L
.14549 .82569 L
.15521 .83141 L
.16132 .83508 L
.16492 .83727 L
.17463 .84328 L
.17705 .84479 L
.18434 .84943 L
.19218 .85451 L
.19406 .85573 L
.20377 .86218 L
.20679 .86422 L
.21348 .86877 L
.22093 .87393 L
.22319 .87551 L
.23291 .8824 L
.23464 .88364 L
.24262 .88943 L
.24795 .89336 L
.25233 .89661 L
.2609 .90307 L
.26204 .90394 L
.27176 .91141 L
.27352 .91278 L
.28147 .91903 L
.28583 .92249 L
.29118 .92679 L
.29785 .93221 L
.30089 .9347 L
.3096 .94192 L
.31061 .94276 L
Mistroke
.32032 .95096 L
.3211 .95163 L
.33003 .95931 L
.33237 .96134 L
.33974 .96781 L
.34341 .97106 L
.34946 .97645 L
.35425 .98077 L
Mfstroke
.4 g
.01923 .82744 m
.02894 .83124 L
.03838 .83508 L
.03866 .8352 L
.04837 .8393 L
.05808 .84354 L
.06088 .84479 L
.06779 .84794 L
.07751 .85248 L
.08175 .85451 L
.08722 .85716 L
.09693 .86199 L
.10131 .86422 L
.10664 .86697 L
.11636 .8721 L
.11977 .87393 L
.12607 .87737 L
.13578 .88279 L
.1373 .88364 L
.14549 .88835 L
.15402 .89336 L
.15521 .89406 L
.16492 .89992 L
.17005 .90307 L
.17463 .90592 L
.18434 .91207 L
.18545 .91278 L
.19406 .91836 L
.20031 .92249 L
.20377 .92481 L
.21348 .9314 L
.21466 .93221 L
.22319 .93813 L
.22857 .94192 L
.23291 .94501 L
.24206 .95163 L
.24262 .95204 L
.25233 .95921 L
.25518 .96134 L
.26204 .96654 L
.26795 .97106 L
.27176 .974 L
.2804 .98077 L
.01923 .98077 L
F
0 g
.01923 .82744 m
.02894 .83124 L
.03838 .83508 L
.03866 .8352 L
.04837 .8393 L
.05808 .84354 L
.06088 .84479 L
.06779 .84794 L
.07751 .85248 L
.08175 .85451 L
.08722 .85716 L
.09693 .86199 L
.10131 .86422 L
.10664 .86697 L
.11636 .8721 L
.11977 .87393 L
.12607 .87737 L
.13578 .88279 L
.1373 .88364 L
.14549 .88835 L
.15402 .89336 L
.15521 .89406 L
.16492 .89992 L
.17005 .90307 L
.17463 .90592 L
.18434 .91207 L
.18545 .91278 L
.19406 .91836 L
.20031 .92249 L
.20377 .92481 L
.21348 .9314 L
.21466 .93221 L
.22319 .93813 L
.22857 .94192 L
.23291 .94501 L
.24206 .95163 L
.24262 .95204 L
.25233 .95921 L
.25518 .96134 L
.26204 .96654 L
.26795 .97106 L
.27176 .974 L
.2804 .98077 L
s
.325 g
.01923 .8862 m
.02894 .89 L
.03722 .89336 L
.03866 .89395 L
.04837 .89804 L
.05808 .90228 L
.05984 .90307 L
.06779 .90667 L
.07751 .91121 L
.08081 .91278 L
.08722 .91589 L
.09693 .92071 L
.10044 .92249 L
.10664 .92569 L
.11636 .93081 L
.11896 .93221 L
.12607 .93607 L
.13578 .94149 L
.13654 .94192 L
.14549 .94705 L
.15332 .95163 L
.15521 .95275 L
.16492 .95861 L
.16938 .96134 L
.17463 .9646 L
.18434 .97075 L
.18482 .97106 L
.19406 .97704 L
.19971 .98077 L
.01923 .98077 L
F
0 g
.01923 .8862 m
.02894 .89 L
.03722 .89336 L
.03866 .89395 L
.04837 .89804 L
.05808 .90228 L
.05984 .90307 L
.06779 .90667 L
.07751 .91121 L
.08081 .91278 L
.08722 .91589 L
.09693 .92071 L
.10044 .92249 L
.10664 .92569 L
.11636 .93081 L
.11896 .93221 L
.12607 .93607 L
.13578 .94149 L
.13654 .94192 L
.14549 .94705 L
.15332 .95163 L
.15521 .95275 L
.16492 .95861 L
.16938 .96134 L
.17463 .9646 L
.18434 .97075 L
.18482 .97106 L
.19406 .97704 L
.19971 .98077 L
s
.25 g
.01923 .94166 m
.01992 .94192 L
.02894 .94545 L
.03866 .9494 L
.044 .95163 L
.04837 .95349 L
.05808 .95773 L
.06612 .96134 L
.06779 .96211 L
.07751 .96664 L
.08669 .97106 L
.08722 .97132 L
.09693 .97614 L
.10599 .98077 L
.01923 .98077 L
F
0 g
.01923 .94166 m
.01992 .94192 L
.02894 .94545 L
.03866 .9494 L
.044 .95163 L
.04837 .95349 L
.05808 .95773 L
.06612 .96134 L
.06779 .96211 L
.07751 .96664 L
.08669 .97106 L
.08722 .97132 L
.09693 .97614 L
.10599 .98077 L
s
.925 g
.98077 .69238 m
.97917 .68939 L
.97398 .67968 L
.97106 .67423 L
.96877 .66997 L
.96353 .66026 L
.96134 .65623 L
.95826 .65054 L
.95297 .64083 L
.95163 .63837 L
.94766 .63112 L
.94232 .62141 L
.94192 .62067 L
.93696 .61169 L
.93221 .60312 L
.93157 .60198 L
.92616 .59227 L
.92249 .58572 L
.92072 .58256 L
.91525 .57284 L
.91278 .56847 L
.90976 .56313 L
.90424 .55342 L
.90307 .55137 L
.89869 .54371 L
.89336 .53441 L
.89311 .53399 L
.88751 .52428 L
.88364 .51761 L
.88188 .51457 L
.87621 .50486 L
.87393 .50096 L
.87052 .49514 L
.86479 .48543 L
.86422 .48446 L
.85904 .47572 L
.85451 .46811 L
.85325 .46601 L
.84743 .45629 L
.84479 .45191 L
.84158 .44658 L
.83569 .43687 L
.83508 .43586 L
.82978 .42716 L
.82537 .41996 L
.82382 .41744 L
.81784 .40773 L
.81566 .40421 L
.81181 .39802 L
.80594 .38861 L
.80575 .38831 L
.79966 .37859 L
.79623 .37316 L
.79352 .36888 L
.78735 .35917 L
.78652 .35786 L
.78114 .34946 L
.77681 .34271 L
.77489 .33974 L
.7686 .33003 L
.76709 .32771 L
.76227 .32032 L
.75738 .31287 L
.7559 .31061 L
.74948 .30089 L
.74767 .29817 L
.74302 .29118 L
.73796 .28362 L
.73651 .28147 L
.72996 .27176 L
.72824 .26922 L
.72336 .26204 L
.71853 .25497 L
.71672 .25233 L
.71003 .24262 L
.70882 .24088 L
.70328 .23291 L
.69911 .22693 L
.69649 .22319 L
.68964 .21348 L
.68939 .21313 L
.68274 .20377 L
.67968 .19948 L
.67579 .19406 L
.66997 .18599 L
.66878 .18434 L
.66171 .17463 L
.66026 .17264 L
.65459 .16492 L
.65054 .15944 L
.6474 .15521 L
.64083 .1464 L
.64015 .14549 L
.63284 .13578 L
.63112 .1335 L
.62547 .12607 L
.62141 .12076 L
.61803 .11636 L
.61169 .10816 L
.61052 .10664 L
.60293 .09693 L
.60198 .09572 L
.59528 .08722 L
.59227 .08342 L
.58755 .07751 L
.58256 .07128 L
.57975 .06779 L
.57284 .05928 L
.57186 .05808 L
.5639 .04837 L
.56313 .04744 L
.55585 .03866 L
.55342 .03574 L
.54771 .02894 L
.54371 .0242 L
.53949 .01923 L
.98077 .01923 L
F
0 g
.98077 .69238 m
.97917 .68939 L
.97398 .67968 L
.97106 .67423 L
.96877 .66997 L
.96353 .66026 L
.96134 .65623 L
.95826 .65054 L
.95297 .64083 L
.95163 .63837 L
.94766 .63112 L
.94232 .62141 L
.94192 .62067 L
.93696 .61169 L
.93221 .60312 L
.93157 .60198 L
.92616 .59227 L
.92249 .58572 L
.92072 .58256 L
.91525 .57284 L
.91278 .56847 L
.90976 .56313 L
.90424 .55342 L
.90307 .55137 L
.89869 .54371 L
.89336 .53441 L
.89311 .53399 L
.88751 .52428 L
.88364 .51761 L
.88188 .51457 L
.87621 .50486 L
.87393 .50096 L
.87052 .49514 L
.86479 .48543 L
.86422 .48446 L
.85904 .47572 L
.85451 .46811 L
.85325 .46601 L
.84743 .45629 L
.84479 .45191 L
.84158 .44658 L
.83569 .43687 L
.83508 .43586 L
.82978 .42716 L
.82537 .41996 L
.82382 .41744 L
.81784 .40773 L
.81566 .40421 L
.81181 .39802 L
.80594 .38861 L
Mistroke
.80575 .38831 L
.79966 .37859 L
.79623 .37316 L
.79352 .36888 L
.78735 .35917 L
.78652 .35786 L
.78114 .34946 L
.77681 .34271 L
.77489 .33974 L
.7686 .33003 L
.76709 .32771 L
.76227 .32032 L
.75738 .31287 L
.7559 .31061 L
.74948 .30089 L
.74767 .29817 L
.74302 .29118 L
.73796 .28362 L
.73651 .28147 L
.72996 .27176 L
.72824 .26922 L
.72336 .26204 L
.71853 .25497 L
.71672 .25233 L
.71003 .24262 L
.70882 .24088 L
.70328 .23291 L
.69911 .22693 L
.69649 .22319 L
.68964 .21348 L
.68939 .21313 L
.68274 .20377 L
.67968 .19948 L
.67579 .19406 L
.66997 .18599 L
.66878 .18434 L
.66171 .17463 L
.66026 .17264 L
.65459 .16492 L
.65054 .15944 L
.6474 .15521 L
.64083 .1464 L
.64015 .14549 L
.63284 .13578 L
.63112 .1335 L
.62547 .12607 L
.62141 .12076 L
.61803 .11636 L
.61169 .10816 L
.61052 .10664 L
Mistroke
.60293 .09693 L
.60198 .09572 L
.59528 .08722 L
.59227 .08342 L
.58755 .07751 L
.58256 .07128 L
.57975 .06779 L
.57284 .05928 L
.57186 .05808 L
.5639 .04837 L
.56313 .04744 L
.55585 .03866 L
.55342 .03574 L
.54771 .02894 L
.54371 .0242 L
.53949 .01923 L
Mfstroke
.85 g
.98077 .53822 m
.97851 .53399 L
.97332 .52428 L
.97106 .52007 L
.9681 .51457 L
.96285 .50486 L
.96134 .50207 L
.95759 .49514 L
.9523 .48543 L
.95163 .48421 L
.94698 .47572 L
.94192 .46651 L
.94164 .46601 L
.93628 .45629 L
.93221 .44895 L
.93089 .44658 L
.92547 .43687 L
.92249 .43154 L
.92003 .42716 L
.91457 .41744 L
.91278 .41428 L
.90907 .40773 L
.90355 .39802 L
.90307 .39718 L
.898 .38831 L
.89336 .38022 L
.89242 .37859 L
.88682 .36888 L
.88364 .36341 L
.88118 .35917 L
.87552 .34946 L
.87393 .34674 L
.86982 .33974 L
.86422 .33023 L
.8641 .33003 L
.85835 .32032 L
.85451 .31387 L
.85256 .31061 L
.84674 .30089 L
.84479 .29765 L
.84089 .29118 L
.83508 .28159 L
.83501 .28147 L
.82909 .27176 L
.82537 .26567 L
.82314 .26204 L
.81716 .25233 L
.81566 .24991 L
.81113 .24262 L
.80594 .23429 L
.80508 .23291 L
.79899 .22319 L
.79623 .21882 L
.79286 .21348 L
.78669 .20377 L
.78652 .2035 L
.78048 .19406 L
.77681 .18833 L
.77424 .18434 L
.76795 .17463 L
.76709 .17331 L
.76162 .16492 L
.75738 .15844 L
.75525 .15521 L
.74884 .14549 L
.74767 .14372 L
.74239 .13578 L
.73796 .12915 L
.73589 .12607 L
.72935 .11636 L
.72824 .11472 L
.72276 .10664 L
.71853 .10045 L
.71612 .09693 L
.70944 .08722 L
.70882 .08632 L
.7027 .07751 L
.69911 .07235 L
.69592 .06779 L
.68939 .05852 L
.68908 .05808 L
.6822 .04837 L
.67968 .04484 L
.67525 .03866 L
.66997 .03131 L
.66826 .02894 L
.6612 .01923 L
.98077 .01923 L
F
0 g
.98077 .53822 m
.97851 .53399 L
.97332 .52428 L
.97106 .52007 L
.9681 .51457 L
.96285 .50486 L
.96134 .50207 L
.95759 .49514 L
.9523 .48543 L
.95163 .48421 L
.94698 .47572 L
.94192 .46651 L
.94164 .46601 L
.93628 .45629 L
.93221 .44895 L
.93089 .44658 L
.92547 .43687 L
.92249 .43154 L
.92003 .42716 L
.91457 .41744 L
.91278 .41428 L
.90907 .40773 L
.90355 .39802 L
.90307 .39718 L
.898 .38831 L
.89336 .38022 L
.89242 .37859 L
.88682 .36888 L
.88364 .36341 L
.88118 .35917 L
.87552 .34946 L
.87393 .34674 L
.86982 .33974 L
.86422 .33023 L
.8641 .33003 L
.85835 .32032 L
.85451 .31387 L
.85256 .31061 L
.84674 .30089 L
.84479 .29765 L
.84089 .29118 L
.83508 .28159 L
.83501 .28147 L
.82909 .27176 L
.82537 .26567 L
.82314 .26204 L
.81716 .25233 L
.81566 .24991 L
.81113 .24262 L
.80594 .23429 L
Mistroke
.80508 .23291 L
.79899 .22319 L
.79623 .21882 L
.79286 .21348 L
.78669 .20377 L
.78652 .2035 L
.78048 .19406 L
.77681 .18833 L
.77424 .18434 L
.76795 .17463 L
.76709 .17331 L
.76162 .16492 L
.75738 .15844 L
.75525 .15521 L
.74884 .14549 L
.74767 .14372 L
.74239 .13578 L
.73796 .12915 L
.73589 .12607 L
.72935 .11636 L
.72824 .11472 L
.72276 .10664 L
.71853 .10045 L
.71612 .09693 L
.70944 .08722 L
.70882 .08632 L
.7027 .07751 L
.69911 .07235 L
.69592 .06779 L
.68939 .05852 L
.68908 .05808 L
.6822 .04837 L
.67968 .04484 L
.67525 .03866 L
.66997 .03131 L
.66826 .02894 L
.6612 .01923 L
Mfstroke
.775 g
.98077 .42532 m
.97656 .41744 L
.97136 .40773 L
.97106 .40717 L
.96613 .39802 L
.96134 .38916 L
.96088 .38831 L
.95561 .37859 L
.95163 .37131 L
.95031 .36888 L
.94498 .35917 L
.94192 .3536 L
.93964 .34946 L
.93426 .33974 L
.93221 .33604 L
.92886 .33003 L
.92344 .32032 L
.92249 .31863 L
.91799 .31061 L
.91278 .30137 L
.91251 .30089 L
.90701 .29118 L
.90307 .28426 L
.90148 .28147 L
.89592 .27176 L
.89336 .2673 L
.89033 .26204 L
.88472 .25233 L
.88364 .25048 L
.87907 .24262 L
.87393 .23382 L
.8734 .23291 L
.8677 .22319 L
.86422 .2173 L
.86196 .21348 L
.8562 .20377 L
.85451 .20093 L
.8504 .19406 L
.84479 .18471 L
.84457 .18434 L
.83871 .17463 L
.83508 .16864 L
.83282 .16492 L
.82689 .15521 L
.82537 .15272 L
.82093 .14549 L
.81566 .13695 L
.81493 .13578 L
.8089 .12607 L
.80594 .12132 L
.80284 .11636 L
.79673 .10664 L
.79623 .10585 L
.79059 .09693 L
.78652 .09052 L
.78441 .08722 L
.77819 .07751 L
.77681 .07535 L
.77194 .06779 L
.76709 .06032 L
.76564 .05808 L
.7593 .04837 L
.75738 .04544 L
.75292 .03866 L
.74767 .03071 L
.7465 .02894 L
.74003 .01923 L
.98077 .01923 L
F
0 g
.98077 .42532 m
.97656 .41744 L
.97136 .40773 L
.97106 .40717 L
.96613 .39802 L
.96134 .38916 L
.96088 .38831 L
.95561 .37859 L
.95163 .37131 L
.95031 .36888 L
.94498 .35917 L
.94192 .3536 L
.93964 .34946 L
.93426 .33974 L
.93221 .33604 L
.92886 .33003 L
.92344 .32032 L
.92249 .31863 L
.91799 .31061 L
.91278 .30137 L
.91251 .30089 L
.90701 .29118 L
.90307 .28426 L
.90148 .28147 L
.89592 .27176 L
.89336 .2673 L
.89033 .26204 L
.88472 .25233 L
.88364 .25048 L
.87907 .24262 L
.87393 .23382 L
.8734 .23291 L
.8677 .22319 L
.86422 .2173 L
.86196 .21348 L
.8562 .20377 L
.85451 .20093 L
.8504 .19406 L
.84479 .18471 L
.84457 .18434 L
.83871 .17463 L
.83508 .16864 L
.83282 .16492 L
.82689 .15521 L
.82537 .15272 L
.82093 .14549 L
.81566 .13695 L
.81493 .13578 L
.8089 .12607 L
.80594 .12132 L
Mistroke
.80284 .11636 L
.79673 .10664 L
.79623 .10585 L
.79059 .09693 L
.78652 .09052 L
.78441 .08722 L
.77819 .07751 L
.77681 .07535 L
.77194 .06779 L
.76709 .06032 L
.76564 .05808 L
.7593 .04837 L
.75738 .04544 L
.75292 .03866 L
.74767 .03071 L
.7465 .02894 L
.74003 .01923 L
Mfstroke
.7 g
.98077 .33177 m
.97984 .33003 L
.97465 .32032 L
.97106 .31361 L
.96944 .31061 L
.9642 .30089 L
.96134 .29561 L
.95894 .29118 L
.95366 .28147 L
.95163 .27775 L
.94835 .27176 L
.94302 .26204 L
.94192 .26005 L
.93766 .25233 L
.93228 .24262 L
.93221 .24249 L
.92687 .23291 L
.92249 .22508 L
.92144 .22319 L
.91598 .21348 L
.91278 .20781 L
.91049 .20377 L
.90498 .19406 L
.90307 .1907 L
.89944 .18434 L
.89387 .17463 L
.89336 .17374 L
.88827 .16492 L
.88364 .15692 L
.88265 .15521 L
.877 .14549 L
.87393 .14025 L
.87131 .13578 L
.8656 .12607 L
.86422 .12373 L
.85985 .11636 L
.85451 .10736 L
.85408 .10664 L
.84827 .09693 L
.84479 .09114 L
.84243 .08722 L
.83656 .07751 L
.83508 .07507 L
.83066 .06779 L
.82537 .05914 L
.82472 .05808 L
.81875 .04837 L
.81566 .04337 L
.81274 .03866 L
.8067 .02894 L
.80594 .02774 L
.80062 .01923 L
.98077 .01923 L
F
0 g
.98077 .33177 m
.97984 .33003 L
.97465 .32032 L
.97106 .31361 L
.96944 .31061 L
.9642 .30089 L
.96134 .29561 L
.95894 .29118 L
.95366 .28147 L
.95163 .27775 L
.94835 .27176 L
.94302 .26204 L
.94192 .26005 L
.93766 .25233 L
.93228 .24262 L
.93221 .24249 L
.92687 .23291 L
.92249 .22508 L
.92144 .22319 L
.91598 .21348 L
.91278 .20781 L
.91049 .20377 L
.90498 .19406 L
.90307 .1907 L
.89944 .18434 L
.89387 .17463 L
.89336 .17374 L
.88827 .16492 L
.88364 .15692 L
.88265 .15521 L
.877 .14549 L
.87393 .14025 L
.87131 .13578 L
.8656 .12607 L
.86422 .12373 L
.85985 .11636 L
.85451 .10736 L
.85408 .10664 L
.84827 .09693 L
.84479 .09114 L
.84243 .08722 L
.83656 .07751 L
.83508 .07507 L
.83066 .06779 L
.82537 .05914 L
.82472 .05808 L
.81875 .04837 L
.81566 .04337 L
.81274 .03866 L
.8067 .02894 L
Mistroke
.80594 .02774 L
.80062 .01923 L
Mfstroke
.625 g
.98077 .2501 m
.97678 .24262 L
.97157 .23291 L
.97106 .23194 L
.96635 .22319 L
.96134 .21394 L
.9611 .21348 L
.95582 .20377 L
.95163 .19608 L
.95052 .19406 L
.9452 .18434 L
.94192 .17837 L
.93986 .17463 L
.93448 .16492 L
.93221 .16081 L
.92909 .15521 L
.92366 .14549 L
.92249 .1434 L
.91822 .13578 L
.91278 .12614 L
.91274 .12607 L
.90724 .11636 L
.90307 .10903 L
.90171 .10664 L
.89615 .09693 L
.89336 .09206 L
.89057 .08722 L
.88496 .07751 L
.88364 .07524 L
.87932 .06779 L
.87393 .05857 L
.87364 .05808 L
.86794 .04837 L
.86422 .04205 L
.86221 .03866 L
.85645 .02894 L
.85451 .02568 L
.85066 .01923 L
.98077 .01923 L
F
0 g
.98077 .2501 m
.97678 .24262 L
.97157 .23291 L
.97106 .23194 L
.96635 .22319 L
.96134 .21394 L
.9611 .21348 L
.95582 .20377 L
.95163 .19608 L
.95052 .19406 L
.9452 .18434 L
.94192 .17837 L
.93986 .17463 L
.93448 .16492 L
.93221 .16081 L
.92909 .15521 L
.92366 .14549 L
.92249 .1434 L
.91822 .13578 L
.91278 .12614 L
.91274 .12607 L
.90724 .11636 L
.90307 .10903 L
.90171 .10664 L
.89615 .09693 L
.89336 .09206 L
.89057 .08722 L
.88496 .07751 L
.88364 .07524 L
.87932 .06779 L
.87393 .05857 L
.87364 .05808 L
.86794 .04837 L
.86422 .04205 L
.86221 .03866 L
.85645 .02894 L
.85451 .02568 L
.85066 .01923 L
s
.55 g
.98077 .17668 m
.97968 .17463 L
.97449 .16492 L
.97106 .15853 L
.96927 .15521 L
.96403 .14549 L
.96134 .14052 L
.95877 .13578 L
.95349 .12607 L
.95163 .12266 L
.94818 .11636 L
.94285 .10664 L
.94192 .10496 L
.93749 .09693 L
.93221 .0874 L
.93211 .08722 L
.9267 .07751 L
.92249 .06998 L
.92127 .06779 L
.91581 .05808 L
.91278 .05272 L
.91032 .04837 L
.90481 .03866 L
.90307 .0356 L
.89927 .02894 L
.8937 .01923 L
.98077 .01923 L
F
0 g
.98077 .17668 m
.97968 .17463 L
.97449 .16492 L
.97106 .15853 L
.96927 .15521 L
.96403 .14549 L
.96134 .14052 L
.95877 .13578 L
.95349 .12607 L
.95163 .12266 L
.94818 .11636 L
.94285 .10664 L
.94192 .10496 L
.93749 .09693 L
.93221 .0874 L
.93211 .08722 L
.9267 .07751 L
.92249 .06998 L
.92127 .06779 L
.91581 .05808 L
.91278 .05272 L
.91032 .04837 L
.90481 .03866 L
.90307 .0356 L
.89927 .02894 L
.8937 .01923 L
s
.475 g
.98077 .10943 m
.97929 .10664 L
.97409 .09693 L
.97106 .09127 L
.96888 .08722 L
.96364 .07751 L
.96134 .07327 L
.95838 .06779 L
.95309 .05808 L
.95163 .05541 L
.94778 .04837 L
.94244 .03866 L
.94192 .0377 L
.93709 .02894 L
.93221 .02014 L
.9317 .01923 L
.98077 .01923 L
F
0 g
.98077 .10943 m
.97929 .10664 L
.97409 .09693 L
.97106 .09127 L
.96888 .08722 L
.96364 .07751 L
.96134 .07327 L
.95838 .06779 L
.95309 .05808 L
.95163 .05541 L
.94778 .04837 L
.94244 .03866 L
.94192 .0377 L
.93709 .02894 L
.93221 .02014 L
.9317 .01923 L
s
.4 g
.98077 .047 m
.97631 .03866 L
.97111 .02894 L
.97106 .02885 L
.96588 .01923 L
.98077 .01923 L
F
0 g
.98077 .047 m
.97631 .03866 L
.97111 .02894 L
.97106 .02885 L
.96588 .01923 L
s
0 0 0 r
.055 w
.98077 .98077 Mdot
.5 0 .5 r
.04 w
.01923 .0785 Mdot
.09937 .05114 Mdot
.25461 .01923 Mdot
.41157 .1428 Mdot
.52294 .2733 Mdot
.72605 .52019 Mdot
.79656 .65705 Mdot
.8695 .77715 Mdot
.98077 .9711 Mdot
.98077 .98077 Mdot
1 1 0 r
.025 w
.01923 .0785 Mdot
.98077 .25895 Mdot
.09937 .05114 Mdot
.25461 .01923 Mdot
.41157 .1428 Mdot
.52294 .2733 Mdot
.72605 .52019 Mdot
.79656 .65705 Mdot
.94828 .90255 Mdot
.8695 .77715 Mdot
.98077 .9711 Mdot
.98077 .98077 Mdot
0 0 1 r
.5 Mabswid
.01923 .0785 m
.01923 .0785 L
.09937 .05114 L
.25461 .01923 L
.41157 .1428 L
.52294 .2733 L
.72605 .52019 L
.79656 .65705 L
.8695 .77715 L
.98077 .9711 L
.98077 .98077 L
s
.015 w
.01923 .0785 Mdot
.01923 .0785 Mdot
.09937 .05114 Mdot
.25461 .01923 Mdot
.41157 .1428 Mdot
.52294 .2733 Mdot
.72605 .52019 Mdot
.79656 .65705 Mdot
.8695 .77715 Mdot
.98077 .9711 Mdot
.98077 .98077 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`004oooool2o`0000Cooooo00Co0000oooooooooooooooo1Ol0000aooooo`;o00001?ooool0
0ol0003oooooooooo`03ooooo`?o0000<Oooool2o`0000Cooooo00?o0000ooooooooool00_ooool3
o`00037ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000gooooo`?o00001_ooool0
01;ooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool0000`ooooo`04o`000?oo
ooooooooo`0000[ooooo00?o0000ooooooooool0;oooool01?l0003oooooooooool00007ooooo`05
o`000?ooooooooooooooool00000;oooool01?l0003oooooooooool00007ooooo`05o`000?oooooo
ooooooooool00000=oooool00ol0003oooooooooo`05ooooo`004_ooool01?l0003oooooooooool0
0009ooooo`03o`000?oooooooooo033ooooo00Co0000oooooooooooo00001oooool5o`00033ooooo
00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000002oooooo00Co0000oooo
oooooooo00001oooool01Ol0003ooooooooooooooooo000003Oooooo00?o0000ooooooooool01Ooo
ool001;ooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`0_ooooo`04o`000?oo
ooooooooo`0000Oooooo00Co0000oooooooooooo0000<Oooool01?l0003oooooooooool00007oooo
o`Co0000<?ooool01?l0003oooooooooool00008ooooo`?o0000>?ooool00ol0003oooooooooo`05
ooooo`004_ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool00000<?oo
ool01?l0003oooooooooool00008ooooo`03o`000?oooooo0000037ooooo00Co0000oooooooooooo
00001oooool00ol0003oooooooooo`0aooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooo
ooooooooooooo`00000gooooo`03o`000?oooooooooo00Gooooo000Booooo`04o`000?oooooooooo
o`0000Oooooo00Go0000ooooooooooooooooo`00000`ooooo`04o`000?ooooooooooo`0000Wooooo
0_l0000aooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool0<?ooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool00000=_ooool2o`0000Oooooo000Coooo
o`;o00002Oooool3o`0003;ooooo0_l0000;ooooo`03o`000?oooooooooo033ooooo0_l0000:oooo
o`;o0000<Oooool2o`0000Wooooo0ol0000hooooo`03o`000?oooooooooo00Gooooo003oooooob7o
oooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo000Eoooooooo00002ol00001oooo
o`005Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00[ooooo1?mo07l?ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`02ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0hooooo`SoO`1o
?Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0
0_ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo03gooooo0_mo07l4oooo00;oO`1o`Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo03cooooo0_mo07l6oooo00;oO`1o`?ooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo03cooooo0_mo07l4o`00o`;oool00_mo07m6oooo
o`03o`000?oooooooooo01gooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool1o`00007ooooo000Eooooo`;o
0000>_ooool5o`00o`03oooo0?l00?oo003o00;o003o00?oool0ogl0Oomo07l0A_ooool00ol0003o
k>c/onc/k00Monc/k003o`000?oIfMWofMWI01;ofMWI00?o0000olK6a_o6a/H03Oo6a/H00ol0003o
/k>cok>c/`0;ok>c/`03o`000?nOWiooWinO00SoWinO00?o0000ohb<S?n<S8`01on<S8`00ol0003o
NGUiogUiN@06ogUiN@04o`000?mVIVKoIVIVofIVIPCooooo0_l00001ooooo`005Oooool00ol0003o
ooooooooo`0eooooo`Co003o0oooool2ogl0O`06oooo0?l00?oo003oo`00ooooo`3o003o0_mo07m7
ooooo`03o`000?o/k>cok>c/01gok>c/00?o0000omWIfOoIfMT04_oIfMT00ol0003oa/K6olK6aP0=
olK6aP03o`000?nc/k?o/k>c00_o/k>c00?o0000oinOWonOWil02?nOWil00ol0003oS8b<ohb<S007
ohb<S003o`000?miNGWoNGUi00KoNGUi00?o0000ofIVI_mVIVH01Oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo033ooooo1Ol00?l8ooooo`;oO`1o1?ooo`000omo07oo003oooooo`18oooo
o`03o`000?o/k>cok>c/01gok>c/00?o0000omWIfOoIfMT04_oIfMT00ol0003oa/K6olK6aP0=olK6
aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil02OnOWil00ol0003oS8b<ohb<S007ohb<
S003o`000?miNGWoNGUi00KoNGUi00?o0000ofIVI_ooool01?ooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo02_ooooo1Ol00?l=ooooo`SoO`1o0_l00?m8ooooo`03o`000?o/k>cok>c/01go
k>c/00?o0000omWIfOoIfMT04OoIfMT00ol0003oa/K6olK6aP0=olK6aP03o`000?nc/k?o/k>c00[o
/k>c00?o0000oinOWonOWil02OnOWil00ol0003oS8b<ohb<S007ohb<S003o`000?miNGWoNGUi00Ko
NGUi00?o0000ofIVI_ooool01?ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo01Gooooo
1?mo07l>ooooo`Co003o5?ooool4ogl0O`Cooooo00?o003oooooooooool0A_ooool00ol0003ok>c/
onc/k00Lonc/k003o`000?oIfMWofMWI01;ofMWI00?o0000olK6a_o6a/H03Oo6a/H00ol0003o/k>c
ok>c/`0:ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`01on<S8`00ol0003oNGUi
ogUiN@06ogUiN@03o`000?oooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`0Cooooo`SoO`1o1oooool5o`00ob7ooooo00?o003oooooooooool0AOooool00ol0003ok>c/onc/
k00Monc/k003o`000?oIfMWofMWI01;ofMWI00?o0000olK6a_o6a/H03Oo6a/H00ol0003o/k>cok>c
/`0:ok>c/`03o`000?nOWiooWinO00SoWinO00?o0000ohb<S?n<S8`01on<S8`00ol0003oNGUiogUi
N@06ogUiN@03o`000?oooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`0C
ooooo`;oO`1o1?ooo`02ogl0O`?ooooo1?l00?lWooooo`;o003oA_ooool00ol0003ok>c/onc/k00M
onc/k003o`000?oIfMWofMWI01;ofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o/k>cok>c/`0:
ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`01on<S8`00ol0003oNGUiogUiN@05
ogUiN@03o`000?oooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`0Boooo
o`;oO`1o0_ooo`08o`00obgooooo00?o003oooooooooool0A?ooool2o`0001kok>c/00?o0000omWI
fOoIfMT04OoIfMT00ol0003oa/K6olK6aP0=olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinO
WonOWil02OnOWil00ol0003oS8b<ohb<S007ohb<S003o`000?miNGWoNGUi00GoNGUi00?o0000oooo
ooooool00_ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo01;ooooo0_mo07l2oooo00?o
003o00?oool0ogl0Oomo07l0<?ooool00ol00?ooooooooooo`14ooooo`03o`000?o/k>cok>c/01co
k>c/00?o0000omWIfOoIfMT04OoIfMT00ol0003oa/K6olK6aP0=olK6aP03o`000?nc/k?o/k>c00[o
/k>c00?o0000oinOWonOWil02OnOWil00ol0003oS8b<ohb<S007ohb<S003o`000?miNGWoNGUi00Go
NGUi1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo01;ooooo00?oO`1oo`00ool00?l0
1?l00?l00oooo`3oO`1oogl0O`0aooooo`03o`00oooooooooooo04Cooooo00?o0000onc/k?o/k>`0
7?o/k>`00ol0003ofMWIomWIf@0AomWIf@03o`000?o6a/Koa/K600goa/K600?o0000ok>c/onc/k<0
2_nc/k<00ol0003oWinOoinOW`08oinOW`03o`000?n<S8coS8b<00SoS8b<00?o0000ogUiNOmiNGT0
1?miNGT5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool04?ooool3o`00o`03ogl0Oooo
o`3oool000Coool00_mo07lbooooo`;o003oAOooool00ol0003ok>c/onc/k00Lonc/k003o`000?oI
fMWofMWI017ofMWI0_l0000>olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil02?nO
Wil00ol0003oS8b<ohb<S007ohb<S003o`000?miNGWoNGUi00CoNGUi1Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00CoO`1o2Oooool3o`00o`?ooooo0_mo07l4oooo00;oO`1o=Oooool0
0ol00?ooooooooooo`13ooooo`03o`000?o/k>cok>c/01cok>c/00?o0000omWIfOoIfMT04OoIfMT0
0ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil02?nOWil0
0ol0003oS8b<ohb<S007ohb<S003o`000?miNGWoNGUi00CoNGUi1Oooool1o`00007ooooo000Eoooo
o`03o`000?mo07ooO`1o00KoO`1o1?ooool3o`00o`Kooooo2?mo07lfooooo`03o`00oooooooooooo
04?ooooo00?o0000onc/k?o/k>`07?o/k>`00ol0003ofMWIomWIf@0AomWIf@03o`000?o6a/Koa/K6
00coa/K600?o0000ok>c/onc/k<02_nc/k<00ol0003oWinOoinOW`08oinOW`03o`000?n<S8coS8b<
00OoS8b<00?o0000ogUiNOmiNGT00omiNGT5ooooo`7o00000Oooool000;ooooo0_l00004ooooo`04
o`000?ooooooooooooooo`Go00001?ooool00ol0003oO`1oogl0O`04oooo00;oO`1o00Coooooo`00
ool00?oo003o2oooool4ogl0OcWooooo00?o003oooooooooool0@oooool00ol0003ok>c/onc/k00K
onc/k003o`000?oIfMWofMWI017ofMWI00?o0000olK6a_o6a/H03Oo6a/H00ol0003o/k>cok>c/`09
ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`01_n<S8`00ol0003oNGUiogUiN@03
ogUiN@Gooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`000008ooooo`04o`000?oooooo
ooooo`0000Cooooo0_mo07l5oooo00?o003oC?ooool2o`00od?ooooo00?o0000onc/k?o/k>`06oo/
k>`00ol0003ofMWIomWIf@0BomWIf@03o`000?o6a/Koa/K600goa/K600?o0000ok>c/onc/k<02Onc
/k<00ol0003oWinOoinOW`08oinOW`03o`000?n<S8coS8b<00OoS8b<00?o0000ogUiNOmiNGT00_mi
NGT5ooooo`7o00000Oooool00005ooooool0003oooooooooool000002Oooool00ol0003ooooooooo
o`04ooooo`;oO`1o00?oool0o`00ool00?l00_l00?l00oooo`3oO`1oogl0O`1>ooooo`03o`00oooo
oooooooo047ooooo00?o0000onc/k?o/k>`06oo/k>`00ol0003ofMWIomWIf@0AomWIf@03o`000?o6
a/Koa/K600goa/K600?o0000ok>c/onc/k<02_nc/k<00ol0003oWinOoinOW`08oinOW`03o`000?n<
S8coS8b<00OoS8b<00Co0000ogUiNOmiNGWoNGUi1?ooool2o`00007ooooo00001Ooooooo0000oooo
oooooooo000000[ooooo00?o0000ooooooooool00oooool2ogl0O`04oooo0?l00?oo003oo`00o`;o
ool00_mo07m?ooooo`03o`00oooooooooooo043ooooo00?o0000onc/k?o/k>`07?o/k>`00ol0003o
fMWIomWIf@0@omWIf@03o`000?o6a/Koa/K600goa/K600?o0000ok>c/onc/k<02_nc/k<00ol0003o
WinOoinOW`08oinOW`03o`000?n<S8coS8b<00OoS8b<00Co0000ogUiNOmiNGWoNGUi1Oooool1o`00
007ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`000004
ooooo`;oO`1o00Coool0o`00ool00?oo003o0_ooo`02ogl0Oe3ooooo0_l00?m1ooooo`03o`000?o/
k>cok>c/01cok>c/00?o0000omWIfOoIfMT04?oIfMT00ol0003oa/K6olK6aP0=olK6aP03o`000?nc
/k?o/k>c00[o/k>c00?o0000oinOWonOWil02?nOWil00ol0003oS8b<ohb<S007ohb<S003o`000?mi
NGWoNGUi00Gooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`000007ooooo`05o`000?oo
ooooooooooooool000001?ooool00ol0003oO`1oogl0O`04oooo00;oO`1oDoooool00ol00?oooooo
ooooo`0oooooo`03o`000?o/k>cok>c/01_ok>c/00?o0000omWIfOoIfMT04OoIfMT2o`0000koa/K6
00?o0000ok>c/onc/k<02Onc/k<00ol0003oWinOoinOW`08oinOW`03o`000?n<S8coS8b<00OoS8b<
00?o0000ogUiNOmiNGT01Oooool1o`00007ooooo0002ooooo`;o00002Oooool3o`0000Gooooo00?o
0000ogl0Oomo07l01_mo07mDooooo`03o`00oooooooooooo03oooooo00?o0000onc/k?o/k>`06oo/
k>`00ol0003ofMWIomWIf@0AomWIf@03o`000?o6a/Koa/K600coa/K600?o0000ok>c/onc/k<02_nc
/k<00ol0003oWinOoinOW`08oinOW`03o`000?n<S8coS8b<00OoS8b<00?o0000ogUiNOooool01?oo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00CoO`1oEoooool00ol00?ooooooooooo`0o
ooooo`03o`000?o/k>cok>c/01_ok>c/00?o0000omWIfOoIfMT04OoIfMT00ol0003oa/K6olK6aP0<
olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil02?nOWil00ol0003oS8b<ohb<S006
ohb<S003o`000?miNGWooooo00Cooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`1Loooo
o`;o003o?oooool00ol0003ok>c/onc/k00Lonc/k003o`000?oIfMWofMWI013ofMWI00?o0000olK6
a_o6a/H03?o6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00SoWinO00?o0000ohb<
S?n<S8`01_n<S8`00ol0003oNGUiooooo`04ooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool0G_ooool00ol00?ooooooooooo`0mooooo`03o`000?o/k>cok>c/01_ok>c/00?o0000omWIfOoI
fMT04OoIfMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonO
Wil02?nOWil00ol0003oS8b<ohb<S006ohb<S003o`000?oooooooooo00?ooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`1Oooooo`03o`00oooooooooooo03gooooo00?o0000onc/k?o/k>`0
6oo/k>`00ol0003ofMWIomWIf@0@omWIf@03o`000?o6a/Koa/K600goa/K600?o0000ok>c/onc/k<0
2Onc/k<2o`0000WoWinO00?o0000ohb<S?n<S8`01on<S8`00ol0003oooooooooo`02ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool0H?ooool00ol00?ooooooooooo`0mooooo`03o`000?o/
k>cok>c/01[ok>c/00?o0000omWIfOoIfMT04OoIfMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc
/k?o/k>c00[o/k>c00?o0000oinOWonOWil02?nOWil00ol0003oS8b<ohb<S006ohb<S0Gooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`1Qooooo`;o003o?_ooool00ol0003ok>c/onc/k00J
onc/k0;o00004_oIfMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000
oinOWonOWil02?nOWil00ol0003oS8b<ohb<S005ohb<S0Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`1Sooooo`03o`00oooooooooooo03cooooo00?o0000onc/k?o/k>`06_o/k>`00ol0
003ofMWIomWIf@0@omWIf@03o`000?o6a/Koa/K600coa/K600?o0000ok>c/onc/k<02_nc/k<00ol0
003oWinOoinOW`08oinOW`03o`000?n<S8coS8b<00GoS8b<1Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo06Cooooo00?o003oooooooooool0>oooool00ol0003ok>c/onc/k00Konc/k003
o`000?oIfMWofMWI013ofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o/k>cok>c/`0:ok>c/`03
o`000?nOWiooWinO00SoWinO00?o0000ohb<S?n<S8`01?n<S8`5ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool0IOooool2o`00o`03oooooomo07ooO`1o00;oO`1o=oooool00ol0003ok>c/
onc/k00Jonc/k003o`000?oIfMWofMWI017ofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o/k>c
ok>c/`09ok>c/`03o`000?nOWiooWinO00SoWinO00?o0000ohb<S?n<S8`01?n<S8`5ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool0I_ooool00omo07oo003oogl0O`05ogl0OcGooooo00?o
0000onc/k?o/k>`06oo/k>`00ol0003ofMWIomWIf@0@omWIf@03o`000?o6a/Koa/K600coa/K600?o
0000ok>c/onc/k<02_nc/k<00ol0003oWinOoinOW`07oinOW`03o`000?n<S8coS8b<00CoS8b<1Ooo
ool1o`00007ooooo000Eooooo`;o0000Ioooool2ogl0O`04o`00ooooo`3oool0oooo00;oO`1o=_oo
ool2o`0001cok>c/00?o0000omWIfOoIfMT04?oIfMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc
/k?o/k>c00[o/k>c00?o0000oinOWonOWil01onOWil00ol0003oS8b<ohb<S003ohb<S0Cooooo0_l0
0001ooooo`005Oooool00ol0003oooooooooo`1Uooooo`;oO`1o0_ooo`001?l00?ooool0oooo0?oo
o`02ogl0OcKooooo00?o0000onc/k?o/k>`06_o/k>`00ol0003ofMWIomWIf@0@omWIf@03o`000?o6
a/Koa/K600coa/K600?o0000ok>c/onc/k<02_nc/k<00ol0003oWinOoinOW`07oinOW`03o`000?n<
S8coS8b<00?oS8b<1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo06Gooooo0_mo07l2
oooo00?o003o00?oool0ogl0Oomo07l0=oooool00ol0003ok>c/onc/k00Jonc/k003o`000?oIfMWo
fMWI013ofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWioo
WinO00OoWinO00?o0000ohb<S?n<S8`00_n<S8`5ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool0IOooool2ogl0O`;oool00ol00?l00oooo`3oO`1oogl0O`0hooooo`03o`000?o/k>cok>c/
01Wok>c/0_l0000BomWIf@03o`000?o6a/Koa/K600coa/K600?o0000ok>c/onc/k<02Onc/k<00ol0
003oWinOoinOW`08oinOW`04o`000?n<S8coS8b<ohb<S0Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`1Uooooo`;oO`1o0_ooo`03o`00o`03oooo0?mo07ooO`1o03Sooooo00?o0000onc/
k?o/k>`06_o/k>`00ol0003ofMWIomWIf@0@omWIf@03o`000?o6a/Koa/K600coa/K600?o0000ok>c
/onc/k<02Onc/k<00ol0003oWinOoinOW`08oinOW`04o`000?n<S8coS8b<ohb<S0Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`1Vooooo`;oO`1o1?ooo`000ol00?ooO`1oooooo`0ioooo
o`03o`000?o/k>cok>c/01[ok>c/00?o0000omWIfOoIfMT04?oIfMT00ol0003oa/K6olK6aP0<olK6
aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000oinOWonOWil02?nOWil00ol0003oS8b<ohb<S005oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool0I_ooool7ogl0O`03o`00oooooooooooo03Wo
oooo00?o0000onc/k?o/k>`06Oo/k>`2o`00017ofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o
/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00OoWinO0_l000000on<S8coooooooooo`03ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool0J?ooool4ogl0O`;ooooo00?o003oooooooooool0
>Oooool00ol0003ok>c/onc/k00Ionc/k003o`000?oIfMWofMWI013ofMWI00?o0000olK6a_o6a/H0
3?o6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00SoWinO00?o0000ohb<S?ooool0
1?ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo06oooooo00?o003oooooooooool0>Ooo
ool00ol0003ok>c/onc/k00Ionc/k003o`000?oIfMWofMWI013ofMWI00?o0000olK6a_o6a/H03?o6
a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00SoWinO00?o0000ooooooooool00ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo073ooooo00?o003oooooooooool0>?ooool0
0ol0003ok>c/onc/k00Jonc/k003o`000?oIfMWofMWI013ofMWI00?o0000olK6a_o6a/H02oo6a/H0
0ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00SoWinO00?o0000ooooooooool00oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo0_l0001/ooooo`03o`00oooooooooooo
03Wooooo00?o0000onc/k?o/k>`06_o/k>`00ol0003ofMWIomWIf@0?omWIf@03o`000?o6a/Koa/K6
00coa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003oWinOoinOW`08oinOW`03o`000?oooooooooo
00;ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`;ok>c/0ol0001Zooooo`03
o`00oooooooooooo03Wooooo00?o0000onc/k?o/k>`06Oo/k>`00ol0003ofMWIomWIf@0@omWIf@03
o`000?o6a/Koa/K600_oa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003oWinOoinOW`08oinOW`03
o`000?oooooooooo00;ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`Gok>c/
0ol0001Xooooo`03o`00oooooooooooo03Sooooo00?o0000onc/k?o/k>`06Oo/k>`00ol0003ofMWI
omWIf@0@omWIf@03o`000?o6a/Koa/K600coa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003oWinO
oinOW`07oinOW`Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`Sok>c/00?o
0000ooooooooool0I_ooool00ol00?ooooooooooo`0hooooo`03o`000?o/k>cok>c/01Wok>c/00?o
0000omWIfOoIfMT04?oIfMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o
0000oinOWonOWil01_nOWil5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool9
onc/k003o`000?oooooooooo06Kooooo00?o003oooooooooool0>?ooool00ol0003ok>c/onc/k00I
onc/k003o`000?oIfMWofMWI00oofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o/k>cok>c/`09
ok>c/`03o`000?nOWiooWinO00KoWinO1Oooool1o`00007ooooo000Eooooo`;o00000oooool:onc/
k0?o0000I_ooool00ol00?ooooooooooo`0gooooo`03o`000?o/k>cok>c/01Wok>c/00?o0000omWI
fOoIfMT04?oIfMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000oinO
WonOWil01OnOWil4ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_ooool=onc/k0;o
0000IOooool00ol00?ooooooooooo`0gooooo`03o`000?o/k>cok>c/01Wok>c/00?o0000omWIfOoI
fMT04?oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00Wo/k>c0_l00006oinOW`Go
oooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`ook>c/0ol0001Rooooo`03o`00
oooooooooooo03Sooooo00?o0000onc/k?o/k>`06Oo/k>`00ol0003ofMWIomWIf@0?omWIf@03o`00
0?o6a/Koa/K600coa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003oWinOoinOW`04oinOW`Gooooo
0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa;ok>c/0_l0001Qooooo`03o`00oooo
oooooooo03Sooooo00?o0000onc/k?o/k>`06Oo/k>`00ol0003ofMWIomWIf@0?omWIf@03o`000?o6
a/Koa/K600coa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003oWinOoinOW`03oinOW`Gooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02oooooaCok>c/00?o0000ooooooooool0Goooool0
0ol00?ooooooooooo`0gooooo`03o`000?o/k>cok>c/01Wok>c/00?o0000omWIfOoIfMT03ooIfMT0
0ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000oinOWonOWil00onOWil5
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolEonc/k0;o0000H?ooool00ol0
0?ooooooooooo`0gooooo`03o`000?o/k>cok>c/01Wok>c/00?o0000omWIfOoIfMT03ooIfMT00ol0
003oa/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil00_nOWil5oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolGonc/k0?o0000G_ooool00ol00?oo
ooooooooo`0gooooo`03o`000?o/k>cok>c/01Sok>c/00?o0000omWIfOoIfMT04?oIfMT00ol0003o
a/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000oinOWonOWil00_nOWil5ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_oooolJonc/k003o`000?oooooooooo05cooooo
00?o003oooooooooool0=_ooool00ol0003ok>c/onc/k00Ionc/k003o`000?oIfMWofMWI00oofMWI
00?o0000olK6a_o6a/H02oo6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00;oWinO
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo6oo/k>`00ol0003ooooooooo
o`1Looooo`03o`00oooooooooooo03Kooooo00?o0000onc/k?o/k>`06?o/k>`00ol0003ofMWIomWI
f@0?omWIf@03o`000?o6a/Koa/K600coa/K600?o0000ok>c/onc/k<02Onc/k<01?l0003oWinOoinO
WonOWil5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolLonc/k0?o0000Fooo
ool00ol00?ooooooooooo`0gooooo`03o`000?o/k>cok>c/01Sok>c/00?o0000omWIfOoIfMT03ooI
fMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00So/k>c00Co0000oinOWonOWiooWinO
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo7oo/k>`00ol0003ooooooooo
o`1Iooooo`03o`00oooooooooooo03Kooooo0_l0000Jonc/k003o`000?oIfMWofMWI00oofMWI00?o
0000olK6a_o6a/H02oo6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00Gooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02ooooob3ok>c/00?o0000ooooooooool0FOooool0
0ol00?ooooooooooo`0gooooo`03o`000?o/k>cok>c/01Sok>c/00?o0000omWIfOoIfMT03ooIfMT0
0ol0003oa/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000oinOWoooool01?ooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo8Oo/k>`3o`0005Wooooo00?o003ooooo
ooooool0=_ooool00ol0003ok>c/onc/k00Honc/k003o`000?oIfMWofMWI00oofMWI00?o0000olK6
a_o6a/H02oo6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWioooooo00Cooooo0Ol00001oooo
o`005Oooool00ol0003oooooooooo`02ooooobCok>c/00?o0000ooooooooool0Eoooool00ol00?oo
ooooooooo`0fooooo`03o`000?o/k>cok>c/01Ook>c/00?o0000omWIfOoIfMT04?oIfMT00ol0003o
a/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000ooooooooool00oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo9Oo/k>`2o`0005Sooooo00?o003oooooooooool0
=Oooool00ol0003ok>c/onc/k00Honc/k003o`000?oIfMWofMWI00oofMWI00?o0000olK6a_o6a/H0
2oo6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?oooooooooo00?ooooo0Ol00001ooooo`005Ooo
ool2o`0000?ooooo9oo/k>`2o`0005Oooooo00?o003oooooooooool0=Oooool00ol0003ok>c/onc/
k00Gonc/k003o`000?oIfMWofMWI00oofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o/k>cok>c
/`08ok>c/`03o`000?oooooooooo00;ooooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02
ooooobWok>c/00?o0000ooooooooool0E?ooool00ol00?ooooooooooo`0fooooo`03o`000?o/k>co
k>c/01Ook>c/0_l0000@omWIf@;o00003Oo6a/H00ol0003o/k>cok>c/`06ok>c/`Coool00oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo:Oo/k>`3o`0005Gooooo00?o003ooooo
ooooool0=_ooool00ol0003ok>c/onc/k00Gonc/k003o`000?oIfMWofMWI00oofMWI00?o0000olK6
a_o6a/H02oo6a/H00ol0003o/k>cok>c/`05ok>c/`Koool00_ooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo;?o/k>`00ol0003oooooooooo`1Cooooo`03o`00ooooooooO`1o00?o
O`1o<_ooool00ol0003ok>c/onc/k00Honc/k003o`000?oIfMWofMWI00oofMWI00?o0000olK6a_o6
a/H02oo6a/H00ol0003o/k>cok>c/`04ok>c/`Koool00_ooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo;Oo/k>`00ol0003oooooooooo`1Booooo`03ogl0Ool00?ooO`1o00GoO`1o
<Oooool00ol0003ok>c/onc/k00Gonc/k003o`000?oIfMWofMWI00oofMWI00?o0000olK6a_o6a/H0
2oo6a/H00ol0003o/k>cok>c/`04ok>c/`Koool00_ooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooo;_o/k>`00ol0003oooooooooo`1Aooooo`;oO`1o00Co003ooooo0?ooo`3oool0
0_mo07laooooo`03o`000?o/k>cok>c/01Sok>c/00?o0000omWIfOoIfMT03ooIfMT00ol0003oa/K6
olK6aP0:olK6aP03o`000?nc/k?o/k>c00Co/k>c1_ooo`02ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_ooool_onc/k003o`000?oooooooooo04oooooo0_mo07l01?ooo`3o003oo`00
ool00?l2oooo00;oO`1o<Oooool00ol0003ok>c/onc/k00Gonc/k003o`000?oIfMWofMWI00oofMWI
00?o0000olK6a_o6a/H02oo6a/H00ol0003o/k>cok>c/`04ok>c/`Coool00oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;ooooo<?o/k>`3o`0004kooooo0_mo07l01?ooo`3o003oo`00
ool00?l2oooo00;oO`1o<_ooool00ol0003ok>c/onc/k00Gonc/k003o`000?oIfMWofMWI00oofMWI
00?o0000olK6a_o6a/H02oo6a/H00ol0003o/k>cok>c/`05ok>c/`Gooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02oooooc?ok>c/00?o0000ooooooooool0Boooool2ogl0O`04oooo0?l0
0?oo003oo`00o`;oool00_mo07lbooooo`03o`000?o/k>cok>c/01Sok>c/00?o0000omWIfOoIfMT0
3_oIfMT00ol0003oa/K6olK6aP0<olK6aP03o`000?nc/k?o/k>c00Co/k>c1Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;ooooo=?o/k>`2o`0004_ooooo0_mo07l4oooo0004o`00oooo
o`3oO`1oogl0Oc?ooooo00?o0000onc/k?o/k>`06?o/k>`00ol0003ofMWIomWIf@0>omWIf@03o`00
0?o6a/Koa/K600_oa/K600?o0000ok>c/onc/k<01?nc/k<5ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_oooolfonc/k003o`000?oooooooooo04Wooooo0_mo07l4oooo0003o`00oomo
07oooooo03Cooooo00?o0000onc/k?o/k>`05oo/k>`00ol0003ofMWIomWIf@0?omWIf@03o`000?o6
a/Koa/K600[oa/K600?o0000ok>c/onc/k<01?nc/k<5ooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_oooolgonc/k003o`000?oooooooooo04Sooooo1omo07l00ol00?ooooooooooo`0c
ooooo`03o`000?o/k>cok>c/01Sok>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003oa/K6olK6aP0;
olK6aP03o`000?nc/k?o/k>c00?o/k>c1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;ooooo>?o/k>`2o`0004[ooooo1?mo07l2ooooo`03o`00oooooooooooo03?ooooo00?o0000onc/
k?o/k>`05oo/k>`00ol0003ofMWIomWIf@0?omWIf@03o`000?o6a/Koa/K600[oa/K600?o0000ok>c
/onc/k<00onc/k<5ooooo`7o00000Oooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00?o
oooo0ol00004ooooo`03o`000?oooooooooo00;ooooo>_o/k>`00ol0003oooooooooo`1>ooooo`03
o`00oooooooooooo03;ooooo00?o0000onc/k?o/k>`06?o/k>`00ol0003ofMWIomWIf@0>omWIf@03
o`000?o6a/Koa/K600_oa/K600?o0000ok>c/onc/k<00_nc/k<5ooooo`7o00000Oooool00005oooo
ool0003oooooooooool000002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;o
oooo>oo/k>`2o`0004kooooo00?o003oooooooooool0<oooool2o`0001Wok>c/00?o0000omWIfOoI
fMT03_oIfMT00ol0003oa/K6olK6aP0;olK6aP04o`000?nc/k?o/k>cok>c/`Gooooo0Ol00001oooo
o`0000Goooooo`000?ooooooooooo`000007ooooo`Go00001?ooool2o`0000?ooooo?Oo/k>`00ol0
003oooooooooo`1<ooooo`03o`00oooooooooooo03?ooooo00?o0000onc/k?o/k>`05oo/k>`00ol0
003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600_oa/K600Co0000ok>c/onc/k?o/k>c1?ooool2
o`00007ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Co0000oooooooooooo00001Ooo
ool00ol0003oooooooooo`02ooooockok>c/00?o0000ooooooooool0C?ooool00ol00?oooooooooo
o`0cooooo`03o`000?o/k>cok>c/01Ook>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003oa/K6olK6
aP0;olK6aP03o`000?nc/k?o/k>c00Gooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`00
0008ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool00_ooooloonc/k003o`000?oo
oooooooo04cooooo00?o003oooooooooool0<oooool00ol0003ok>c/onc/k00Fonc/k003o`000?oI
fMWofMWI00oofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`05ooooo`7o00000Ooo
ool00005ooooool0003oooooooooool000002Oooool2o`0000Gooooo00?o0000ooooooooool00_oo
oom0onc/k0;o0000COooool00ol00?ooooooooooo`0booooo`03o`000?o/k>cok>c/01Ook>c/00?o
0000omWIfOoIfMT03_oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`000?nc/k?ooooo00Cooooo0Ol0
0001ooooo`000_ooool2o`0000_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
oooood;ok>c/00?o0000ooooooooool0B_ooool00ol00?ooooooooooo`0cooooo`03o`000?o/k>co
k>c/01Ook>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`000?oooooo
oooo00?ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooood?ok>c/00?o0000oooo
ooooool0B_ooool00ol00?ooooooooooo`0cooooo`03o`000?o/k>cok>c/01Kok>c/00?o0000omWI
fOoIfMT03_oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`000?oooooooooo00?ooooo0Ol00001oooo
o`005Oooool00ol0003oooooooooo`02ooooodCok>c/00?o0000ooooooooool0B_ooool00ol00?oo
ooooooooo`0cooooo`03o`000?o/k>cok>c/01Kok>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003o
a/K6olK6aP0;olK6aP03o`000?oooooooooo00;ooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooo`?o0000@_o/k>`2o`0004_ooooo00?o003oooooooooool0<_ooool00ol0003ok>c/
onc/k00Fonc/k003o`000?oIfMWofMWI00kofMWI00?o0000olK6a_o6a/H02oo6a/H00ol0003ooooo
ooooo`02ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool3omWIf@;o0000@_o/
k>`00ol0003oooooooooo`19ooooo`03o`00oooooooooooo037ooooo00?o0000onc/k?o/k>`05_o/
k>`00ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600_oa/K61Oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo1OoIfMT00ol0003ok>c/onc/k010onc/k003o`000?oooooo
oooo04Wooooo00?o003oooooooooool0<Oooool00ol0003ok>c/onc/k00Fonc/k003o`000?oIfMWo
fMWI00kofMWI00?o0000olK6a_o6a/H02_o6a/H5ooooo`7o00000Oooool001Gooooo00?o0000oooo
ooooool00_ooool5omWIf@?o0000@?o/k>`2o`0004[ooooo00?o003oooooooooool0<_ooool00ol0
003ok>c/onc/k00Fonc/k003o`000?oIfMWofMWI00kofMWI00?o0000olK6a_o6a/H02Oo6a/H5oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool8omWIf@;o0000@?o/k>`00ol0003o
ooooooooo`18ooooo`03o`00oooooooooooo037ooooo00?o0000onc/k?o/k>`05oo/k>`00ol0003o
fMWIomWIf@0=omWIf@03o`000?o6a/Koa/K600Woa/K61Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo2_oIfMT3o`0003kok>c/0_l00019ooooo`03o`00oooooooooooo037ooooo
00?o0000onc/k?o/k>`05_o/k>`00ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600Soa/K6
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo3OoIfMT2o`0003gok>c/00?o
0000ooooooooool0B?ooool00ol00?ooooooooooo`0aooooo`03o`000?o/k>cok>c/01Gok>c/00?o
0000omWIfOoIfMT03ooIfMT00ol0003oa/K6olK6aP07olK6aPGooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02ooooo`oofMWI0_l0000lonc/k0;o0000BOooool00ol00?ooooooooooo`0a
ooooo`03o`000?o/k>cok>c/01Gok>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003oa/K6olK6aP07
olK6aPGooooo0Ol00001ooooo`005Oooool2o`0000?ooooo4OoIfMT3o`0003_ok>c/00?o0000oooo
ooooool0A_ooool00ol00?ooooooooooo`0aooooo`03o`000?o/k>cok>c/01Kok>c/00?o0000omWI
fOoIfMT03_oIfMT00ol0003oa/K6olK6aP06olK6aPCooooo0_l00001ooooo`005Oooool00ol0003o
ooooooooo`02oooooaCofMWI00?o0000onc/k?o/k>`0>Oo/k>`2o`0004Oooooo00?o003ooooooooo
ool0<Oooool00ol0003ok>c/onc/k00Eonc/k003o`000?oIfMWofMWI00kofMWI00?o0000olK6a_o6
a/H01_o6a/H5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolEomWIf@;o0000
>oo/k>`00ol0003oooooooooo`15ooooo`03o`00oooooooooooo037ooooo00?o0000onc/k?o/k>`0
5Oo/k>`00ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600Goa/K61Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;ooooo5ooIfMT3o`0003Sok>c/00?o0000ooooooooool0A_oo
ool00ol00?ooooooooooo`0`ooooo`03o`000?o/k>cok>c/01Gok>c/00?o0000omWIfOoIfMT03ooI
fMT00ol0003oa/K6olK6aP04olK6aPGooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
oooooa[ofMWI00?o0000onc/k?o/k>`0=_o/k>`00ol0003oooooooooo`16ooooo`03o`00oooooooo
oooo02oooooo00?o0000onc/k?o/k>`05_o/k>`00ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Ko
a/K600Coa/K61Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo6ooIfMT00ol0
003ok>c/onc/k00fonc/k0;o0000Aoooool00ol00?ooooooooooo`0_ooooo`03o`000?o/k>cok>c/
01Kok>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003oa/K6olK6aP03olK6aPGooooo0Ol00001oooo
o`005Oooool00ol0003oooooooooo`02oooooacofMWI0ol0000gonc/k003o`000?oooooooooo04Co
oooo00?o003oooooooooool0<?ooool00ol0003ok>c/onc/k00Eonc/k003o`000?oIfMWofMWI00ko
fMWI00?o0000olK6a_o6a/H00oo6a/H5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool0
0_oooolOomWIf@03o`000?o/k>cok>c/03Gok>c/00?o0000ooooooooool0A?ooool00ol00?oooooo
ooooo`0`ooooo`03o`000?o/k>cok>c/01Gok>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003oa/K6
olK6aP02olK6aPGooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooob3ofMWI00?o
0000onc/k?o/k>`0=Oo/k>`00ol0003oooooooooo`14ooooo`03o`00oooooooooooo02oooooo00?o
0000onc/k?o/k>`05Oo/k>`00ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600;oa/K61Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo8OoIfMT3o`0003Gok>c/00?o0000
ooooooooool0A?ooool00ol00?ooooooooooo`0^ooooo`03o`000?o/k>cok>c/01Kok>c/00?o0000
omWIfOoIfMT03OoIfMT00ol0003oa/K6olK6aP02olK6aPGooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooobCofMWI0_l0000donc/k003o`000?oooooooooo04Cooooo00?o003ooooo
ooooool0;_ooool00ol0003ok>c/onc/k00Fonc/k003o`000?oIfMWofMWI00gofMWI00Co0000olK6
a_o6a/Koa/K61Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo9_oIfMT00ol0
003ok>c/onc/k00bonc/k003o`000?oooooooooo04?ooooo00?o003oooooooooool0;_ooool00ol0
003ok>c/onc/k00Fonc/k003o`000?oIfMWofMWI00gofMWI00Co0000olK6a_o6a/Koa/K61Oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo9ooIfMT00ol0003ok>c/onc/k00bonc/
k003o`000?oooooooooo04?ooooo00?o003oooooooooool0;_ooool00ol0003ok>c/onc/k00Fonc/
k003o`000?oIfMWofMWI00gofMWI00?o0000olK6a_o6a/H01Oooool1o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo:?oIfMT00ol0003ok>c/onc/k00bonc/k003o`000?oooooooooo04?o
oooo00?o003oooooooooool0;_ooool00ol0003ok>c/onc/k00Eonc/k003o`000?oIfMWofMWI00ko
fMWI00?o0000olK6a_ooool01?ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo
:OoIfMT3o`0003;ok>c/00?o0000ooooooooool0@oooool00ol00?ooooooooooo`0^ooooo`03o`00
0?o/k>cok>c/01Gok>c/00?o0000omWIfOoIfMT03OoIfMT00ol0003oa/K6ooooo`04ooooo`7o0000
0Oooool001Gooooo0_l00003ooooobcofMWI00?o0000onc/k?o/k>`0<?o/k>`2o`0004Cooooo00?o
003oooooooooool0;_ooool00ol0003ok>c/onc/k00Eonc/k003o`000?oIfMWofMWI00gofMWI00?o
0000ooooooooool00_ooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo;OoIfMT0
0ol0003ok>c/onc/k00aonc/k003o`000?oooooooooo04;ooooo00?o003oooooooooool0;Oooool0
0ol0003ok>c/onc/k00Eonc/k003o`000?oIfMWofMWI00gofMWI00?o0000ooooooooool00oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo;_oIfMT2o`0003;ok>c/00?o0000oooo
ooooool0@Oooool00ol00?ooooooooooo`0]ooooo`03o`000?o/k>cok>c/01Kok>c/00?o0000omWI
fOoIfMT03OoIfMT00ol0003oooooooooo`02ooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool00_ooool`omWIf@03o`000?o/k>cok>c/02ook>c/0_l00013ooooo`03o`00oooooooooooo02go
oooo00?o0000onc/k?o/k>`05Oo/k>`00ol0003ofMWIomWIf@0=omWIf@Gooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02oooooc7ofMWI0_l0000aonc/k003o`000?oooooooooo047ooooo
00?o003oooooooooool0;Oooool00ol0003ok>c/onc/k00Eonc/k003o`000?oIfMWofMWI00cofMWI
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo<ooIfMT2o`00033ok>c/00?o
0000ooooooooool0@Oooool00ol00?ooooooooooo`0]ooooo`03o`000?o/k>cok>c/01Gok>c/00?o
0000omWIfOoIfMT02ooIfMT5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooole
omWIf@03o`000?o/k>cok>c/02gok>c/00?o0000ooooooooool0@_ooool00ol00?ooooooooooo`0/
ooooo`03o`000?o/k>cok>c/01Gok>c/00?o0000omWIfOoIfMT02ooIfMT5ooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_oooolfomWIf@03o`000?o/k>cok>c/02gok>c/00?o0000oooo
ooooool0@Oooool00ol00?ooooooooooo`0]ooooo`03o`000?o/k>cok>c/01Gok>c/00?o0000omWI
fOoIfMT02_oIfMT5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool3o`0003Co
fMWI0_l0000^onc/k0;o0000@_ooool00ol00?ooooooooooo`0/ooooo`03o`000?o/k>cok>c/01Go
k>c/00?o0000omWIfOoIfMT02_oIfMT5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool0
0_ooool3olK6aP;o0000=?oIfMT00ol0003ok>c/onc/k00]onc/k003o`000?oooooooooo043ooooo
00?o003oooooooooool0;?ooool00ol0003ok>c/onc/k00Donc/k003o`000?oIfMWofMWI00[ofMWI
1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo1Oo6a/H2o`0003?ofMWI00?o
0000onc/k?o/k>`0;Oo/k>`00ol0003oooooooooo`10ooooo`03o`00oooooooooooo02_ooooo00?o
0000onc/k?o/k>`05?o/k>`00ol0003ofMWIomWIf@0:omWIf@Gooooo0Ol00001ooooo`005Oooool0
0ol0003oooooooooo`02ooooo`Ooa/K60ol0000aomWIf@;o0000;Oo/k>`00ol0003oooooooooo`11
ooooo`03o`00oooooooooooo02_ooooo00?o0000onc/k?o/k>`05?o/k>`00ol0003ofMWIomWIf@09
omWIf@Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`[oa/K60_l0000aomWI
f@03o`000?o/k>cok>c/02_ok>c/00?o0000ooooooooool0@Oooool00ol00?ooooooooooo`0Zoooo
o`03o`000?o/k>cok>c/01Gok>c/00?o0000omWIfOoIfMT02?oIfMT5ooooo`7o00000Oooool001Go
oooo00?o0000ooooooooool00_ooool<olK6aP;o0000<?oIfMT00ol0003ok>c/onc/k00[onc/k0;o
0000@Oooool00ol00?ooooooooooo`0[ooooo`03o`000?o/k>cok>c/01Gok>c/00?o0000omWIfOoI
fMT01ooIfMT5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool>olK6aP03o`00
0?oIfMWofMWI02kofMWI00?o0000onc/k?o/k>`0;?o/k>`00ol0003oooooooooo`0oooooo`03o`00
oooooooooooo02_ooooo00?o0000onc/k?o/k>`05?o/k>`00ol0003ofMWIomWIf@07omWIf@Gooooo
0Ol00001ooooo`005Oooool2o`0000?ooooo3oo6a/H3o`0002kofMWI00?o0000onc/k?o/k>`0;?o/
k>`00ol0003oooooooooo`0oooooo`03o`00oooooooooooo02[ooooo00?o0000onc/k?o/k>`05Oo/
k>`00ol0003ofMWIomWIf@06omWIf@Cooooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02
oooooa;oa/K60ol0000/omWIf@;o0000;?o/k>`00ol0003oooooooooo`10ooooo`03o`00oooooooo
oooo02[ooooo00?o0000onc/k?o/k>`05?o/k>`00ol0003ofMWIomWIf@06omWIf@Gooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02oooooaGoa/K60_l0000/omWIf@;o0000:oo/k>`00ol0
003oooooooooo`10ooooo`03o`00oooooooooooo02Wooooo00?o0000onc/k?o/k>`05Oo/k>`00ol0
003ofMWIomWIf@05omWIf@Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooaOo
a/K60_l0000/omWIf@03o`000?o/k>cok>c/02Wok>c/0_l00010ooooo`03o`00oooooooooooo02[o
oooo00?o0000onc/k?o/k>`05Oo/k>`00ol0003ofMWIomWIf@04omWIf@Gooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02oooooaWoa/K600?o0000omWIfOoIfMT0:_oIfMT00ol0003ok>c/
onc/k00Yonc/k003o`000?oooooooooo03oooooo00?o003oooooooooool0:Oooool00ol0003ok>c/
onc/k00Eonc/k003o`000?oIfMWofMWI00CofMWI1Oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooo6_o6a/H2o`0002_ofMWI00?o0000onc/k?o/k>`0:Oo/k>`00ol0003ooooooooo
o`0oooooo`03o`00oooooooooooo02Wooooo00?o0000onc/k?o/k>`05Oo/k>`00ol0003ofMWIomWI
f@03omWIf@Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooacoa/K60_l0000Z
omWIf@;o0000:_o/k>`00ol0003oooooooooo`0oooooo`03o`00oooooooooooo02Wooooo00?o0000
onc/k?o/k>`05?o/k>`00ol0003ofMWIomWIf@03omWIf@Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02oooooakoa/K600?o0000omWIfOoIfMT0:OoIfMT00ol0003ok>c/onc/k00Xonc/
k003o`000?oooooooooo03oooooo00?o003oooooooooool0:Oooool00ol0003ok>c/onc/k00Conc/
k003o`000?oIfMWofMWI00?ofMWI1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
oooo7oo6a/H2o`0002[ofMWI00?o0000onc/k?o/k>`0:?o/k>`00ol0003oooooooooo`0oooooo`03
o`00ooooooooO`1o00?oO`1o9_ooool00ol0003ok>c/onc/k00Conc/k0;o00000ooIfMT5ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_oooolQolK6aP;o0000:OoIfMT00ol0003ok>c/
onc/k00Xonc/k003o`000?oooooooooo03kooooo00?o003oogl0Oomo07l01Omo07lTooooo`03o`00
0?o/k>cok>c/01Cok>c/00Co0000omWIfOoIfMWofMWI1Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo8oo6a/H00ol0003ofMWIomWIf@0WomWIf@03o`000?o/k>cok>c/02Sok>c/
00?o0000ooooooooool0?Oooool00omo07oo003ooooo0003oooo00;oO`1o9Oooool00ol0003ok>c/
onc/k00Donc/k003o`000?oIfMWofMWI00Gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooobCoa/K60ol0000WomWIf@;o0000:Oo/k>`00ol0003oooooooooo`0kooooo`;oO`1o00?o
ool0o`00ooooo`000oooo`02ogl0ObCooooo00?o0000onc/k?o/k>`05?o/k>`00ol0003ofMWIomWI
f@05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolWolK6aP03o`000?oIfMWo
fMWI02KofMWI00?o0000onc/k?o/k>`09_o/k>`00ol0003oooooooooo`0kooooo`;oO`1o00Coool0
o`00ool00?oo003o0_ooo`02ogl0ObCooooo00?o0000onc/k?o/k>`05Oo/k>`00ol0003ofMWIoooo
o`04ooooo`7o00000Oooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005
ooooo`03o`000?oooooooooo00;ooooo:?o6a/H00ol0003ofMWIomWIf@0UomWIf@03o`000?o/k>co
k>c/02Ook>c/00?o0000ooooooooool0>_ooool2ogl0O`04oooo0?l00?oo003oo`00o`;oool00_mo
07lUooooo`03o`000?o/k>cok>c/01Cok>c/00?o0000omWIfOooool01?ooool1o`00007ooooo0000
1Ooooooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`00
0?oooooooooo00;ooooo:Oo6a/H2o`0002KofMWI00?o0000onc/k?o/k>`09oo/k>`2o`0003[ooooo
0_mo07l01?ooo`3o003oo`00ool00?l2oooo00;oO`1o9_ooool00ol0003ok>c/onc/k00Conc/k003
o`000?oIfMWooooo00Cooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`000007ooooo`05
o`000?ooooooooooooooool000001?ooool2o`0000?ooooo:oo6a/H00ol0003ofMWIomWIf@0TomWI
f@;o0000:?o/k>`00ol0003oooooooooo`0iooooo`;oO`1o0oooo`000ol00?ooO`1oogl0O`0Woooo
o`03o`000?o/k>cok>c/01Cok>c/00?o0000ooooooooool00_ooool2o`00007ooooo00001Ooooooo
0000oooooooooooo000000Oooooo1?l00005ooooo`03o`000?oooooooooo00;ooooo;?o6a/H2o`00
02KofMWI00?o0000onc/k?o/k>`09_o/k>`00ol0003oooooooooo`0hooooo`GoO`1o00?o003oogl0
Oomo07l0:?ooool00ol0003ok>c/onc/k00Donc/k003o`000?oooooooooo00;ooooo0Ol00001oooo
o`0000Goooooo`000?ooooooooooo`000007ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool00_ooool^olK6aP;o00009OoIfMT00ol0003ok>c/onc/k00Vonc/k003o`000?oooooooooo
03Wooooo1?mo07l00ol00?ooooooooooo`0Wooooo`03o`000?o/k>cok>c/01Cok>c/00?o0000oooo
ooooool00_ooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000Sooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`02ooooo`;o0000;_o6a/H00ol0003ofMWIomWIf@0SomWI
f@03o`000?o/k>cok>c/02Kok>c/00?o0000ooooooooool0??ooool00ol00?ooooooooooo`0Xoooo
o`03o`000?o/k>cok>c/01?ok>c/1Oooool1o`00007ooooo0002ooooo`;o00002_ooool2o`0000Go
oooo00?o0000ooooooooool00_ooool2ok>c/`?o0000;?o6a/H2o`0002CofMWI0_l0000Wonc/k003
o`000?oooooooooo03cooooo00?o003oooooooooool09oooool00ol0003ok>c/onc/k00Conc/k0Go
oooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`Go/k>c0ol0000[olK6aP03o`00
0?oIfMWofMWI02?ofMWI00?o0000onc/k?o/k>`09Oo/k>`00ol0003oooooooooo`0kooooo`03o`00
oooooooooooo02Sooooo00?o0000onc/k?o/k>`04_o/k>`5ooooo`7o00000Oooool001Gooooo00?o
0000ooooooooool00_ooool8ok>c/`;o0000:_o6a/H00ol0003ofMWIomWIf@0SomWIf@03o`000?o/
k>cok>c/02Gok>c/00?o0000ooooooooool0>oooool00ol00?ooooooooooo`0Xooooo`03o`000?o/
k>cok>c/017ok>c/1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo2_nc/k<3
o`0002Soa/K600?o0000omWIfOoIfMT08_oIfMT2o`0002Kok>c/00?o0000ooooooooool0>oooool0
0ol00?ooooooooooo`0Xooooo`03o`000?o/k>cok>c/017ok>c/1Oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;ooooo3Onc/k<00ol0003oa/K6olK6aP0VolK6aP;o00009?oIfMT00ol0
003ok>c/onc/k00Tonc/k003o`000?oooooooooo03_ooooo00?o003oooooooooool0:?ooool00ol0
003ok>c/onc/k00@onc/k0Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`ko
/k>c00?o0000olK6a_o6a/H09oo6a/H2o`0002?ofMWI00?o0000onc/k?o/k>`09?o/k>`00ol0003o
ooooooooo`0jooooo`03o`00oooooooooooo02Sooooo00?o0000onc/k?o/k>`04?o/k>`5ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_ooool?ok>c/`?o0000:?o6a/H00ol0003ofMWI
omWIf@0QomWIf@03o`000?o/k>cok>c/02Cok>c/00?o0000ooooooooool0>_ooool00ol00?oooooo
ooooo`0Xooooo`03o`000?o/k>cok>c/00ook>c/1Oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooo4_nc/k<00ol0003oa/K6olK6aP0VolK6aP03o`000?oIfMWofMWI027ofMWI00?o
0000onc/k?o/k>`09?o/k>`00ol0003oooooooooo`0iooooo`03o`00oooooooooooo02Sooooo00?o
0000onc/k?o/k>`03oo/k>`5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolC
ok>c/`?o00009_o6a/H2o`00027ofMWI0_l0000Uonc/k003o`000?oooooooooo03[ooooo00?o003o
ooooooooool0:?ooool00ol0003ok>c/onc/k00>onc/k0Gooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02oooooaKo/k>c00?o0000olK6a_o6a/H09Oo6a/H00ol0003ofMWIomWIf@0PomWI
f@03o`000?o/k>cok>c/02?ok>c/00?o0000ooooooooool0>Oooool00ol00?ooooooooooo`0Xoooo
o`03o`000?o/k>cok>c/00kok>c/1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;o
oooo5onc/k<3o`0002Goa/K600?o0000omWIfOoIfMT08?oIfMT2o`0002Cok>c/0_l0000jooooo`03
o`00oooooooooooo02Sooooo00?o0000onc/k?o/k>`03Oo/k>`5ooooo`7o00000Oooool001Gooooo
0_l00003oooooa[o/k>c0_l0000TolK6aP03o`000?oIfMWofMWI027ofMWI00?o0000onc/k?o/k>`0
8_o/k>`00ol0003oooooooooo`0hooooo`03o`00oooooooooooo02Wooooo00?o0000onc/k?o/k>`0
3?o/k>`4ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_oooolLok>c/`03o`000?o6
a/Koa/K602;oa/K600?o0000omWIfOoIfMT08OoIfMT00ol0003ok>c/onc/k00Ronc/k003o`000?oo
oooooooo03Sooooo00?o003oooooooooool0:?ooool00ol0003ok>c/onc/k00<onc/k0Gooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02oooooago/k>c0_l0000SolK6aP?o00008?oIfMT0
0ol0003ok>c/onc/k00Sonc/k003o`000?oooooooooo03Oooooo00?o003oooooooooool0:Oooool0
0ol0003ok>c/onc/k00;onc/k0Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
oaoo/k>c0_l0000TolK6aP03o`000?oIfMWofMWI01kofMWI00?o0000onc/k?o/k>`08oo/k>`00ol0
003oooooooooo`0gooooo`03o`00oooooooooooo02Sooooo00?o0000onc/k?o/k>`02oo/k>`5oooo
o`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolQok>c/`;o00008oo6a/H00ol0003o
fMWIomWIf@0NomWIf@03o`000?o/k>cok>c/02?ok>c/00?o0000ooooooooool0=_ooool00ol00?oo
ooooooooo`0Yooooo`03o`000?o/k>cok>c/00[ok>c/1Oooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo8onc/k<00ol0003oa/K6olK6aP0QolK6aP03o`000?oIfMWofMWI01kofMWI
00?o0000onc/k?o/k>`08_o/k>`00ol0003oooooooooo`0gooooo`03o`00oooooooooooo02Sooooo
00?o0000onc/k?o/k>`02_o/k>`5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
oolTok>c/`;o00008_o6a/H00ol0003ofMWIomWIf@0NomWIf@03o`000?o/k>cok>c/02;ok>c/00?o
0000ooooooooool0=_ooool00ol00?ooooooooooo`0Yooooo`03o`000?o/k>cok>c/00Wok>c/1Ooo
ool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo9_nc/k<2o`00027oa/K60_l0000O
omWIf@03o`000?o/k>cok>c/02;ok>c/00?o0000ooooooooool0=_ooool00ol00?ooooooooooo`0Y
ooooo`03o`000?o/k>cok>c/00Sok>c/1Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;ooooo:?nc/k<00ol0003oa/K6olK6aP0PolK6aP03o`000?oIfMWofMWI01gofMWI00?o0000onc/
k?o/k>`08Oo/k>`00ol0003oooooooooo`0fooooo`03o`00oooooooooooo02Wooooo00?o0000onc/
k?o/k>`02?o/k>`5ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolYok>c/`;o
00008Oo6a/H00ol0003ofMWIomWIf@0MomWIf@03o`000?o/k>cok>c/027ok>c/0_l0000gooooo`03
o`00oooooooooooo02Wooooo00?o0000onc/k?o/k>`01oo/k>`5ooooo`7o00000Oooool001Gooooo
00?o0000ooooooooool00_ooool3o`0002So/k>c00?o0000olK6a_o6a/H07_o6a/H00ol0003ofMWI
omWIf@0NomWIf@03o`000?o/k>cok>c/027ok>c/00?o0000ooooooooool0=Oooool00ol00?oooooo
ooooo`0Yooooo`03o`000?o/k>cok>c/00Ook>c/1Oooool1o`00007ooooo000Eooooo`03o`000?oo
oooooooo00;ooooo0onOWil2o`0002Oo/k>c0_l0000OolK6aP;o00007ooIfMT00ol0003ok>c/onc/
k00Qonc/k003o`000?oooooooooo03Gooooo00?o003oooooooooool0:Oooool00ol0003ok>c/onc/
k006onc/k0Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`GoWinO0ol0000V
ok>c/`;o00007oo6a/H00ol0003ofMWIomWIf@0MomWIf@03o`000?o/k>cok>c/027ok>c/00?o0000
ooooooooool0=?ooool00ol00?ooooooooooo`0Yooooo`03o`000?o/k>cok>c/00Kok>c/1Oooool1
o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo2?nOWil2o`0002Ko/k>c00?o0000olK6
a_o6a/H07Oo6a/H00ol0003ofMWIomWIf@0LomWIf@03o`000?o/k>cok>c/027ok>c/00?o0000oooo
ooooool0=Oooool00ol00?ooooooooooo`0Yooooo`03o`000?o/k>cok>c/00Gok>c/1Oooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;ooooo2_nOWil00ol0003o/k>cok>c/`0Tok>c/`03
o`000?o6a/Koa/K601goa/K600?o0000omWIfOoIfMT07?oIfMT00ol0003ok>c/onc/k00Qonc/k003
o`000?oooooooooo03Cooooo00?o003oooooooooool0:_ooool00ol0003ok>c/onc/k004onc/k0Go
oooo0Ol00001ooooo`005Oooool2o`0000?ooooo2onOWil3o`0002Co/k>c0_l0000NolK6aP;o0000
7OoIfMT2o`0002;ok>c/0_l0000eooooo`03o`00oomo07ooO`1o00;oO`1o9oooool00ol0003ok>c/
onc/k004onc/k0Cooooo0_l00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`koWinO00?o
0000ok>c/onc/k<08onc/k<00ol0003oa/K6olK6aP0MolK6aP03o`000?oIfMWofMWI01cofMWI00?o
0000onc/k?o/k>`08?o/k>`00ol0003oooooooooo`0booooo`03ogl0Ool00?ooO`1o00GoO`1o9Ooo
ool00ol0003ok>c/onc/k004onc/k0Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
ooooo`ooWinO0ol0000Sok>c/`03o`000?o6a/Koa/K601goa/K60_l0000MomWIf@03o`000?o/k>co
k>c/023ok>c/00?o0000ooooooooool0<Oooool2ogl0O`04o`00ooooo`3oool0oooo00;oO`1o9_oo
ool00ol0003ok>c/onc/k003onc/k0Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02
oooooa;oWinO0ol0000Qok>c/`?o00007_o6a/H00ol0003ofMWIomWIf@0JomWIf@03o`000?o/k>co
k>c/027ok>c/00?o0000ooooooooool0;oooool2ogl0O`04oooo0?l00?oo003oo`00o`;oool00_mo
07lUooooo`03o`000?o/k>cok>c/00?ok>c/1Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo5OnOWil00ol0003o/k>cok>c/`0Qok>c/`03o`000?o6a/Koa/K601coa/K600?o0000
omWIfOoIfMT06_oIfMT00ol0003ok>c/onc/k00Ponc/k003o`000?oooooooooo02oooooo0_mo07l0
1?ooo`3o003oo`00ool00?l2oooo00;oO`1o9_ooool00ol0003ok>c/onc/k002onc/k0Gooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02oooooaKoWinO0ol0000Pok>c/`;o00007Oo6a/H0
0ol0003ofMWIomWIf@0KomWIf@;o00008Oo/k>`00ol0003oooooooooo`0^ooooo`;oO`1o00Coool0
o`00ool00?oo003o0_ooo`02ogl0ObOooooo00Co0000onc/k?o/k>cok>c/1Oooool1o`00007ooooo
000Eooooo`03o`000?oooooooooo00;ooooo6OnOWil00ol0003o/k>cok>c/`0Ook>c/`;o00007?o6
a/H00ol0003ofMWIomWIf@0LomWIf@03o`000?o/k>cok>c/01ook>c/00?o0000ooooooooool0;Ooo
ool2ogl0O`?oool000?o003ooooo0?ooo`000_mo07lWooooo`04o`000?o/k>cok>c/onc/k0Gooooo
0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa[oWinO0_l0000Qok>c/`03o`000?o6
a/Koa/K601[oa/K60_l0000MomWIf@03o`000?o/k>cok>c/01ook>c/00?o0000ooooooooool0;Ooo
ool2ogl0O`?oool000?o003oogl0Oomo07l0:Oooool00ol0003ok>c/onc/k005ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_oooolLoinOW`;o00008?nc/k<00ol0003oa/K6olK6aP0K
olK6aP03o`000?oIfMWofMWI01[ofMWI00?o0000onc/k?o/k>`07oo/k>`00ol0003oooooooooo`0]
ooooo`GoO`1o00?o003oogl0Oomo07l0:_ooool00ol0003ok>c/ooooo`04ooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_oooolNoinOW`03o`000?nc/k?o/k>c01ko/k>c00?o0000olK6
a_o6a/H06oo6a/H00ol0003ofMWIomWIf@0JomWIf@03o`000?o/k>cok>c/01ook>c/00?o0000oooo
ooooool0;_ooool4ogl0O`03o`00oooooooooooo02Wooooo00?o0000onc/k?ooool01?ooool1o`00
007ooooo000Eooooo`03o`000?oooooooooo00;ooooo7onOWil2o`0001oo/k>c0_l0000KolK6aP03
o`000?oIfMWofMWI01_ofMWI00?o0000onc/k?o/k>`07oo/k>`00ol0003oooooooooo`0aooooo`03
o`00oooooooooooo02Wooooo00?o0000onc/k?ooool01?ooool1o`00007ooooo000Eooooo`03o`00
0?oooooooooo00;ooooo8OnOWil3o`0001ko/k>c00?o0000olK6a_o6a/H06Oo6a/H00ol0003ofMWI
omWIf@0KomWIf@03o`000?o/k>cok>c/01ook>c/00?o0000ooooooooool0<Oooool00ol00?oooooo
ooooo`0Yooooo`03o`000?oooooooooo00?ooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooobCoWinO00?o0000ok>c/onc/k<07?nc/k<2o`0001[oa/K60_l0000LomWIf@03o`000?o/
k>cok>c/01ook>c/00?o0000ooooooooool0<Oooool00ol00?ooooooooooo`0Yooooo`03o`000?oo
oooooooo00;ooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooobCoWinO0ol0000N
ok>c/`03o`000?o6a/Koa/K601Woa/K600?o0000omWIfOoIfMT06OoIfMT00ol0003ok>c/onc/k00O
onc/k003o`000?oooooooooo037ooooo00?o003oooooooooool0:Oooool00ol0003oooooooooo`02
ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool00ol0003oWinOoinOW`0ToinO
W`03o`000?nc/k?o/k>c01co/k>c00?o0000olK6a_o6a/H06Oo6a/H00ol0003ofMWIomWIf@0IomWI
f@;o00008?o/k>`00ol0003oooooooooo`0aooooo`03o`00oooooooooooo02gooooo0Ol00001oooo
o`005Oooool2o`0000?ooooo00CoS8b<o`000?l0003o00009?nOWil00ol0003o/k>cok>c/`0Lok>c
/`03o`000?o6a/Koa/K601Woa/K600?o0000omWIfOoIfMT06_oIfMT00ol0003ok>c/onc/k00Nonc/
k003o`000?oooooooooo037ooooo00?o003oooooooooool0:oooool2o`00007ooooo000Eooooo`03
o`000?oooooooooo00;ooooo1?n<S8`00ol0003oWinOoinOW`0RoinOW`?o00007?nc/k<00ol0003o
a/K6olK6aP0IolK6aP03o`000?oIfMWofMWI01WofMWI00?o0000onc/k?o/k>`07_o/k>`00ol0003o
ooooooooo`0aooooo`03o`00oooooooooooo02cooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooo`GoS8b<0ol0000ToinOW`03o`000?nc/k?o/k>c01[o/k>c00?o0000olK6a_o6a/H0
6Oo6a/H00ol0003ofMWIomWIf@0IomWIf@03o`000?o/k>cok>c/01kok>c/00?o0000ooooooooool0
<Oooool00ol00?ooooooooooo`0[ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
ool8ohb<S0;o00008_nOWil2o`0001co/k>c0_l0000JolK6aP03o`000?oIfMWofMWI01WofMWI00?o
0000onc/k?o/k>`07_o/k>`00ol0003oooooooooo`0`ooooo`03o`00oooooooooooo02_ooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02ooooo`[oS8b<0ol0000QoinOW`;o00007?nc/k<0
0ol0003oa/K6olK6aP0HolK6aP03o`000?oIfMWofMWI01WofMWI00?o0000onc/k?o/k>`07_o/k>`0
0ol0003oooooooooo`0`ooooo`03o`00oooooooooooo02[ooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooo`goS8b<0_l0000QoinOW`03o`000?nc/k?o/k>c01[o/k>c00?o0000olK6
a_o6a/H06?o6a/H00ol0003ofMWIomWIf@0IomWIf@03o`000?o/k>cok>c/01kok>c/00?o0000oooo
ooooool0<?ooool00ol00?ooooooooooo`0Yooooo`7o00000Oooool001Gooooo00?o0000oooooooo
ool00_ooool?ohb<S0?o00007onOWil2o`0001_o/k>c00?o0000olK6a_o6a/H06?o6a/H00ol0003o
fMWIomWIf@0IomWIf@03o`000?o/k>cok>c/01gok>c/00?o0000ooooooooool0<?ooool00ol00?oo
ooooooooo`0Yooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oooolBohb<S003o`00
0?nOWiooWinO01koWinO00?o0000ok>c/onc/k<06Onc/k<00ol0003oa/K6olK6aP0HolK6aP03o`00
0?oIfMWofMWI01WofMWI00?o0000onc/k?o/k>`07Oo/k>`00ol0003oooooooooo`0`ooooo`03o`00
oooooooooooo02Sooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa?oS8b<0_l0
000OoinOW`;o00006_nc/k<00ol0003oa/K6olK6aP0HolK6aP03o`000?oIfMWofMWI01SofMWI00?o
0000onc/k?o/k>`07_o/k>`00ol0003oooooooooo`0`ooooo`03o`00oooooooooooo02Oooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02oooooaGoS8b<0_l0000OoinOW`03o`000?nc/k?o
/k>c01So/k>c00?o0000olK6a_o6a/H06?o6a/H00ol0003ofMWIomWIf@0HomWIf@03o`000?o/k>co
k>c/01kok>c/00?o0000ooooooooool0;oooool00ol00?ooooooooooo`0Wooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_oooolGohb<S0?o00007OnOWil2o`0001Wo/k>c0_l0000IolK6
aP03o`000?oIfMWofMWI01SofMWI00?o0000onc/k?o/k>`07_o/k>`00ol0003oooooooooo`0_oooo
o`03o`00oooooooooooo02Kooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa[o
S8b<00?o0000oinOWonOWil07?nOWil00ol0003o/k>cok>c/`0Hok>c/`03o`000?o6a/Koa/K601Oo
a/K600?o0000omWIfOoIfMT06?oIfMT00ol0003ok>c/onc/k00Monc/k003o`000?oooooooooo02oo
oooo00?o003oooooooooool09_ooool1o`00007ooooo0002ooooo`;o00001?ooool00ol0003ooooo
ooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`02oooooa_oS8b<00?o0000oinOWonOWil0
7?nOWil00ol0003o/k>cok>c/`0Hok>c/`03o`000?o6a/Koa/K601Ooa/K600?o0000omWIfOoIfMT0
6?oIfMT00ol0003ok>c/onc/k00Monc/k003o`000?oooooooooo02oooooo00?o003oooooooooool0
9Oooool1o`00007ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000oooooooooooo
ooooo`000004ooooo`03o`000?oooooooooo00;ooooo7?n<S8`3o`0001coWinO0_l0000Iok>c/`;o
00006?o6a/H00ol0003ofMWIomWIf@0HomWIf@03o`000?o/k>cok>c/01cok>c/00?o0000oooooooo
ool0<?ooool00ol00?ooooooooooo`0Tooooo`7o00000Oooool00005ooooool0003oooooooooool0
00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_oooolOohb<
S003o`000?nOWiooWinO01_oWinO00?o0000ok>c/onc/k<06?nc/k<00ol0003oa/K6olK6aP0EolK6
aP03o`000?oIfMWofMWI01SofMWI00?o0000onc/k?o/k>`07?o/k>`00ol0003oooooooooo`0`oooo
o`03o`00oooooooooooo02Cooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`000008oooo
o`?o00001Oooool2o`0000?ooooo8?n<S8`00ol0003oWinOoinOW`0KoinOW`03o`000?nc/k?o/k>c
01Oo/k>c00?o0000olK6a_o6a/H05_o6a/H00ol0003ofMWIomWIf@0HomWIf@03o`000?o/k>cok>c/
01cok>c/00?o0000ooooooooool0<?ooool00ol00?ooooooooooo`0Rooooo`;o00000Oooool00005
ooooool0003oooooooooool000001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooooooool00_oooolQohb<S0?o00006onOWil00ol0003o/k>cok>c/`0Gok>c/`03o`000?o6a/Ko
a/K601Koa/K60_l0000IomWIf@03o`000?o/k>cok>c/01cok>c/0_l0000aooooo`03o`00oooooooo
oooo02;ooooo0Ol00001ooooo`0000Goooooo`000?ooooooooooo`000007ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooooooo`02ooooo`;o00008_n<S8`00ol0003oWinOoinO
W`0IoinOW`;o00006?nc/k<2o`0001Soa/K600?o0000omWIfOoIfMT05ooIfMT00ol0003ok>c/onc/
k00Lonc/k003o`000?oooooooooo02oooooo00?o003oogl0Oomo07l00_mo07lPooooo`7o00000Ooo
ool000;ooooo0_l00009ooooo`?o00001Oooool00ol0003oooooooooo`02ooooo`;oNGUi0_l0000Q
ohb<S0;o00006onOWil00ol0003o/k>cok>c/`0Gok>c/`03o`000?o6a/Koa/K601Koa/K600?o0000
omWIfOoIfMT05ooIfMT00ol0003ok>c/onc/k00Lonc/k003o`000?oooooooooo02gooooo0_mo07l0
0ol00?ooO`1oogl0O`03ogl0Oakooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooo
o`CoNGUi00?o0000ohb<S?n<S8`08?n<S8`2o`0001[oWinO00?o0000ok>c/onc/k<05onc/k<00ol0
003oa/K6olK6aP0FolK6aP03o`000?oIfMWofMWI01KofMWI00?o0000onc/k?o/k>`07?o/k>`00ol0
003oooooooooo`0]ooooo`;oO`1o00Co003ooooo0?ooo`3oool00_mo07lNooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_ooool5ogUiN@?o00008On<S8`00ol0003oWinOoinOW`0HoinO
W`03o`000?nc/k?o/k>c01Ko/k>c00?o0000olK6a_o6a/H05oo6a/H00ol0003ofMWIomWIf@0FomWI
f@03o`000?o/k>cok>c/01cok>c/00?o0000ooooooooool0:oooool2ogl0O`04oooo0?l00?oo003o
o`00o`;oool00_mo07lMooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool8ogUi
N@;o00008?n<S8`2o`0001WoWinO0_l0000Gok>c/`03o`000?o6a/Koa/K601Koa/K600?o0000omWI
fOoIfMT05ooIfMT00ol0003ok>c/onc/k00Lonc/k003o`000?oooooooooo02[ooooo0_mo07l01?oo
o`3o003oo`00ool00?l2oooo00;oO`1o7Oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo
00;ooooo2_miNGT3o`0001ooS8b<0_l0000IoinOW`03o`000?nc/k?o/k>c01Go/k>c0_l0000GolK6
aP03o`000?oIfMWofMWI01OofMWI00?o0000onc/k?o/k>`07?o/k>`00ol0003oooooooooo`0Yoooo
o`;oO`1o00Coool0o`00ool00?oo003o0_ooo`02ogl0Oagooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02ooooo`goNGUi0_l0000Oohb<S003o`000?nOWiooWinO01OoWinO0_l0000Gok>c
/`03o`000?o6a/Koa/K601Goa/K600?o0000omWIfOoIfMT05ooIfMT00ol0003ok>c/onc/k00Lonc/
k003o`000?oooooooooo02Sooooo0_mo07l4oooo0004o`00ooooo`3oO`1oogl0Oagooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02ooooo`ooNGUi0ol0000Lohb<S0?o00006OnOWil00ol0
003o/k>cok>c/`0Eok>c/`03o`000?o6a/Koa/K601Goa/K600?o0000omWIfOoIfMT05_oIfMT00ol0
003ok>c/onc/k00Lonc/k003o`000?oooooooooo02Wooooo0_mo07l3oooo0003o`00oomo07ooO`1o
01kooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa;oNGUi00?o0000ohb<S?n<
S8`07?n<S8`00ol0003oWinOoinOW`0GoinOW`03o`000?nc/k?o/k>c01Go/k>c00?o0000olK6a_o6
a/H05Oo6a/H00ol0003ofMWIomWIf@0FomWIf@03o`000?o/k>cok>c/01cok>c/00?o0000oooooooo
ool0:?ooool6ogl0O`03o`00oomo07oooooo01gooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02oooooa?oNGUi0_l0000Mohb<S0;o00006?nOWil00ol0003o/k>cok>c/`0Eok>c/`03o`00
0?o6a/Koa/K601Goa/K600?o0000omWIfOoIfMT05_oIfMT2o`0001gok>c/00?o0000ooooooooool0
:Oooool4ogl0O`03ooooool00?oooooo01gooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02oooooaGoNGUi0_l0000Mohb<S003o`000?nOWiooWinO01KoWinO0_l0000Fok>c/`03o`000?o6
a/Koa/K601Goa/K600?o0000omWIfOoIfMT05_oIfMT00ol0003ok>c/onc/k00Konc/k003o`000?oo
oooooooo02kooooo00?o003oooooooooool07?ooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo5omiNGT3o`0001_oS8b<00?o0000oinOWonOWil05onOWil00ol0003o/k>cok>c/`0D
ok>c/`03o`000?o6a/Koa/K601Goa/K600?o0000omWIfOoIfMT05_oIfMT00ol0003ok>c/onc/k00K
onc/k003o`000?oooooooooo02kooooo00?o003oooooooooool06oooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;ooooo6_miNGT00ol0003oS8b<ohb<S00Iohb<S0;o00006?nOWil00ol0
003o/k>cok>c/`0Dok>c/`03o`000?o6a/Koa/K601Coa/K600?o0000omWIfOoIfMT05_oIfMT00ol0
003ok>c/onc/k00Konc/k003o`000?oooooooooo02kooooo00?o003oooooooooool06oooool1o`00
007ooooo000Eooooo`;o00000ooooolKogUiN@03o`000?n<S8coS8b<01[oS8b<00?o0000oinOWonO
Wil05_nOWil00ol0003o/k>cok>c/`0Dok>c/`03o`000?o6a/Koa/K601Coa/K600?o0000omWIfOoI
fMT05_oIfMT00ol0003ok>c/onc/k00Konc/k003o`000?oooooooooo02kooooo00?o003ooooooooo
ool06Oooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo7?miNGT3o`0001[oS8b<
00?o0000oinOWonOWil05_nOWil00ol0003o/k>cok>c/`0Dok>c/`03o`000?o6a/Koa/K601Coa/K6
00?o0000omWIfOoIfMT05_oIfMT00ol0003ok>c/onc/k00Konc/k003o`000?oooooooooo02gooooo
00?o003oooooooooool06_ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo7omi
NGT00ol0003oS8b<ohb<S00Hohb<S003o`000?nOWiooWinO01GoWinO0_l0000Fok>c/`03o`000?o6
a/Koa/K601Coa/K600?o0000omWIfOoIfMT05_oIfMT00ol0003ok>c/onc/k00Jonc/k003o`000?oo
oooooooo02kooooo00?o003oooooooooool06Oooool1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo8?miNGT00ol0003oS8b<ohb<S00Hohb<S003o`000?nOWiooWinO01KoWinO00?o0000
ok>c/onc/k<05?nc/k<00ol0003oa/K6olK6aP0DolK6aP03o`000?oIfMWofMWI01KofMWI00?o0000
onc/k?o/k>`06_o/k>`00ol0003oooooooooo`0^ooooo`03o`00oooooooooooo01Sooooo0Ol00001
ooooo`005Oooool00ol0003oooooooooo`02ooooo`?o00007_miNGT3o`0001SoS8b<0_l0000GoinO
W`;o00005Onc/k<00ol0003oa/K6olK6aP0DolK6aP03o`000?oIfMWofMWI01GofMWI00?o0000onc/
k?o/k>`06oo/k>`00ol0003oooooooooo`0]ooooo`03o`00oooooooooooo01Sooooo0Ol00001oooo
o`005Oooool00ol0003oooooooooo`02ooooo`?oIVIV0_l0000OogUiN@;o00006?n<S8`2o`0001Oo
WinO00?o0000ok>c/onc/k<04onc/k<00ol0003oa/K6olK6aP0ColK6aP;o00005ooIfMT00ol0003o
k>c/onc/k00Konc/k003o`000?oooooooooo02gooooo00?o003oooooooooool05oooool1o`00007o
oooo000Eooooo`03o`000?oooooooooo00;ooooo1OmVIVH3o`0001koNGUi00?o0000ohb<S?n<S8`0
5on<S8`00ol0003oWinOoinOW`0EoinOW`03o`000?nc/k?o/k>c01?o/k>c00?o0000olK6a_o6a/H0
5?o6a/H00ol0003ofMWIomWIf@0EomWIf@03o`000?o/k>cok>c/01_ok>c/00?o0000ooooooooool0
;?ooool00ol00?ooooooooooo`0Gooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_oo
ool8ofIVIP;o00007OmiNGT2o`0001OoS8b<0ol0000EoinOW`03o`000?nc/k?o/k>c01Co/k>c00?o
0000olK6a_o6a/H04oo6a/H00ol0003ofMWIomWIf@0EomWIf@03o`000?o/k>cok>c/01_ok>c/00?o
0000ooooooooool0;Oooool00ol00?ooooooooooo`0Fooooo`7o00000Oooool001Gooooo00?o0000
ooooooooool00_ooool:ofIVIP03o`000?miNGWoNGUi01coNGUi00?o0000ohb<S?n<S8`05on<S8`0
0ol0003oWinOoinOW`0CoinOW`03o`000?nc/k?o/k>c01Co/k>c00?o0000olK6a_o6a/H04oo6a/H0
0ol0003ofMWIomWIf@0EomWIf@03o`000?o/k>cok>c/01_ok>c/00?o0000ooooooooool0;?ooool0
0ol00?ooooooooooo`0Fooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool;ofIV
IP;o00007OmiNGT2o`0001OoS8b<0_l0000EoinOW`;o00005Onc/k<00ol0003oa/K6olK6aP0ColK6
aP03o`000?oIfMWofMWI01GofMWI00?o0000onc/k?o/k>`06_o/k>`00ol0003oooooooooo`0]oooo
o`03o`00oooooooooooo01Gooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`go
IVIV0_l0000MogUiN@;o00005on<S8`00ol0003oWinOoinOW`0DoinOW`03o`000?nc/k?o/k>c01;o
/k>c0_l0000EolK6aP03o`000?oIfMWofMWI01GofMWI00?o0000onc/k?o/k>`06_o/k>`00ol0003o
ooooooooo`0]ooooo`03o`00oooooooooooo01Cooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02ooooo`ooIVIV0ol0000LogUiN@03o`000?n<S8coS8b<01GoS8b<0_l0000EoinOW`03o`00
0?nc/k?o/k>c01?o/k>c00?o0000olK6a_o6a/H04oo6a/H00ol0003ofMWIomWIf@0EomWIf@03o`00
0?o/k>cok>c/01[ok>c/00?o0000ooooooooool0;?ooool00ol00?ooooooooooo`0Dooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_oooolBofIVIP?o00006OmiNGT3o`0001KoS8b<00?o
0000oinOWonOWil05?nOWil00ol0003o/k>cok>c/`0Cok>c/`03o`000?o6a/Koa/K601;oa/K600?o
0000omWIfOoIfMT05OoIfMT00ol0003ok>c/onc/k00Konc/k003o`000?oooooooooo02cooooo00?o
003oooooooooool04oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5OmVIVH0
0ol0003oNGUiogUiN@0IogUiN@03o`000?n<S8coS8b<01CoS8b<0_l0000EoinOW`03o`000?nc/k?o
/k>c01;o/k>c00?o0000olK6a_o6a/H04oo6a/H00ol0003ofMWIomWIf@0EomWIf@03o`000?o/k>co
k>c/01[ok>c/00?o0000ooooooooool0;?ooool00ol00?ooooooooooo`0Cooooo`7o00000Oooool0
01Gooooo00?o0000ooooooooool00_oooolFofIVIP03o`000?miNGWoNGUi01WoNGUi0_l0000Fohb<
S003o`000?nOWiooWinO01?oWinO00?o0000ok>c/onc/k<04_nc/k<2o`0001Coa/K600?o0000omWI
fOoIfMT05OoIfMT00ol0003ok>c/onc/k00Jonc/k003o`000?oooooooooo02cooooo00?o003ooooo
ooooool04_ooool1o`00007ooooo000Eooooo`;o00000ooooolGofIVIP?o00006_miNGT00ol0003o
S8b<ohb<S00Dohb<S0;o00005?nOWil00ol0003o/k>cok>c/`0Cok>c/`03o`000?o6a/Koa/K601;o
a/K600?o0000omWIfOoIfMT05OoIfMT00ol0003ok>c/onc/k00Ionc/k003o`000?oooooooooo02co
oooo00?o003oooooooooool04Oooool2o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo
6_mVIVH2o`0001WoNGUi00?o0000ohb<S?n<S8`05On<S8`00ol0003oWinOoinOW`0BoinOW`;o0000
5?nc/k<00ol0003oa/K6olK6aP0BolK6aP03o`000?oIfMWofMWI01GofMWI00?o0000onc/k?o/k>`0
6Oo/k>`00ol0003oooooooooo`0/ooooo`03o`00oooooooooooo017ooooo0Ol00001ooooo`005Ooo
ool00ol0003oooooooooo`02oooooacoIVIV0_l0000HogUiN@;o00005On<S8`2o`0001GoWinO00?o
0000ok>c/onc/k<04Onc/k<00ol0003oa/K6olK6aP0ColK6aP03o`000?oIfMWofMWI01CofMWI00?o
0000onc/k?o/k>`06Oo/k>`00ol0003oooooooooo`0]ooooo`03o`00oooooooooooo013ooooo0Ol0
0001ooooo`005Oooool00ol0003oooooooooo`02oooooakoIVIV00?o0000ogUiNOmiNGT05omiNGT0
0ol0003oS8b<ohb<S00Dohb<S003o`000?nOWiooWinO01?oWinO00?o0000ok>c/onc/k<04Onc/k<0
0ol0003oa/K6olK6aP0ColK6aP03o`000?oIfMWofMWI01CofMWI00?o0000onc/k?o/k>`06Oo/k>`0
0ol0003oooooooooo`0/ooooo`03o`00oooooooooooo013ooooo0Ol00001ooooo`005Oooool00ol0
003oooooooooo`02oooooaooIVIV0_l0000HogUiN@03o`000?n<S8coS8b<01CoS8b<00?o0000oinO
WonOWil04_nOWil00ol0003o/k>cok>c/`0Bok>c/`03o`000?o6a/Koa/K601?oa/K600?o0000omWI
fOoIfMT05?oIfMT00ol0003ok>c/onc/k00Ionc/k003o`000?oooooooooo02cooooo00?o003ooooo
ooooool03oooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo0ol0000NofIVIP;o
00005omiNGT00ol0003oS8b<ohb<S00Dohb<S003o`000?nOWiooWinO01;oWinO00?o0000ok>c/onc
/k<04_nc/k<00ol0003oa/K6olK6aP0BolK6aP03o`000?oIfMWofMWI01GofMWI00?o0000onc/k?o/
k>`06Oo/k>`00ol0003oooooooooo`0[ooooo`03o`00oooooooooooo00oooooo0Ol00001ooooo`00
5Oooool00ol0003oooooooooo`02ooooo`?oDe=C0_l0000NofIVIP03o`000?miNGWoNGUi01GoNGUi
0_l0000Eohb<S003o`000?nOWiooWinO01;oWinO00?o0000ok>c/onc/k<04_nc/k<00ol0003oa/K6
olK6aP0BolK6aP03o`000?oIfMWofMWI01CofMWI00?o0000onc/k?o/k>`06Oo/k>`00ol0003ooooo
ooooo`0/ooooo`03o`00oooooooooooo00kooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooo`GoDe=C0ol0000LofIVIP?o00005_miNGT2o`0001CoS8b<0_l0000CoinOW`;o00004onc
/k<00ol0003oa/K6olK6aP0BolK6aP03o`000?oIfMWofMWI01CofMWI00?o0000onc/k?o/k>`06Oo/
k>`00ol0003oooooooooo`0[ooooo`03o`00ooooooooool000?oool02oooool1o`00007ooooo000E
ooooo`03o`000?oooooooooo00;ooooo2?mCDe<2o`0001goIVIV00?o0000ogUiNOmiNGT05OmiNGT0
0ol0003oS8b<ohb<S00Cohb<S003o`000?nOWiooWinO01;oWinO00?o0000ok>c/onc/k<04?nc/k<0
0ol0003oa/K6olK6aP0ColK6aP03o`000?oIfMWofMWI01?ofMWI00?o0000onc/k?o/k>`06_o/k>`0
0ol0003oooooooooo`0[ooooo`03o`00ooooo`3oool000?oool02_ooool1o`00007ooooo000Eoooo
o`03o`000?oooooooooo00;ooooo2_mCDe<3o`0001_oIVIV00?o0000ogUiNOmiNGT05OmiNGT2o`00
01CoS8b<00?o0000oinOWonOWil04OnOWil00ol0003o/k>cok>c/`0Aok>c/`;o00005?o6a/H00ol0
003ofMWIomWIf@0ComWIf@;o00006oo/k>`00ol0003oooooooooo`0Zooooo`03o`00ooooo`3oool0
00?oool02_ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo3OmCDe<2o`0001[o
IVIV0_l0000GogUiN@03o`000?n<S8coS8b<01;oS8b<00?o0000oinOWonOWil04OnOWil00ol0003o
/k>cok>c/`0Aok>c/`03o`000?o6a/Koa/K601?oa/K600?o0000omWIfOoIfMT04ooIfMT00ol0003o
k>c/onc/k00Ionc/k003o`000?oooooooooo02[ooooo00?oool0o`00ooooo`000oooo`0:ooooo`7o
00000Oooool001Gooooo00?o0000ooooooooool00_ooool?oe=CD`03o`000?mVIVKoIVIV01WoIVIV
00?o0000ogUiNOmiNGT05OmiNGT00ol0003oS8b<ohb<S00Bohb<S003o`000?nOWiooWinO017oWinO
00?o0000ok>c/onc/k<04Onc/k<00ol0003oa/K6olK6aP0ColK6aP03o`000?oIfMWofMWI01?ofMWI
00?o0000onc/k?o/k>`06Oo/k>`00ol0003oooooooooo`0Yooooo`;oool000Co003ooooo0?ooo`3o
ool02_ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo4?mCDe<2o`0001[oIVIV
0_l0000EogUiN@?o00004on<S8`00ol0003oWinOoinOW`0AoinOW`03o`000?nc/k?o/k>c017o/k>c
00?o0000olK6a_o6a/H04_o6a/H00ol0003ofMWIomWIf@0ComWIf@;o00006_o/k>`00ol0003ooooo
ooooo`0Zooooo`04oooo0?l00?ooool0oooo00_ooooo0Ol00001ooooo`005Oooool00ol0003ooooo
ooooo`02oooooa;oDe=C0ol0000IofIVIP;o00005_miNGT00ol0003oS8b<ohb<S00Aohb<S0;o0000
4_nOWil00ol0003o/k>cok>c/`0Aok>c/`03o`000?o6a/Koa/K601;oa/K600?o0000omWIfOoIfMT0
4ooIfMT00ol0003ok>c/onc/k00Ionc/k003o`000?oooooooooo02_ooooo00?o003oooooooooool0
2_ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo5OmCDe<2o`0001WoIVIV00?o
0000ogUiNOmiNGT05?miNGT00ol0003oS8b<ohb<S00Bohb<S003o`000?nOWiooWinO013oWinO0_l0
000Bok>c/`03o`000?o6a/Koa/K601;oa/K600?o0000omWIfOoIfMT04ooIfMT00ol0003ok>c/onc/
k00Ionc/k003o`000?oooooooooo02[ooooo00?o003oooooooooool02_ooool1o`00007ooooo000E
ooooo`;o00000ooooolGoe=CD`;o00006?mVIVH2o`0001GoNGUi00?o0000ohb<S?n<S8`04_n<S8`0
0ol0003oWinOoinOW`0@oinOW`03o`000?nc/k?o/k>c017o/k>c00?o0000olK6a_o6a/H04Oo6a/H0
0ol0003ofMWIomWIf@0ComWIf@03o`000?o/k>cok>c/01Wok>c/00?o0000ooooooooool0:oooool0
0ol00?ooooooooooo`08ooooo`;o00000Oooool001Gooooo00?o0000ooooooooool00_oooolIoe=C
D`03o`000?mVIVKoIVIV01OoIVIV00?o0000ogUiNOmiNGT04omiNGT00ol0003oS8b<ohb<S00Aohb<
S003o`000?nOWiooWinO017oWinO00?o0000ok>c/onc/k<04Onc/k<00ol0003oa/K6olK6aP0AolK6
aP03o`000?oIfMWofMWI01?ofMWI00?o0000onc/k?o/k>`06Oo/k>`00ol0003oooooooooo`0Zoooo
o`03o`00oooooooooooo00Wooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooa[o
De=C0_l0000HofIVIP03o`000?miNGWoNGUi01?oNGUi00?o0000ohb<S?n<S8`04On<S8`00ol0003o
WinOoinOW`0AoinOW`03o`000?nc/k?o/k>c017o/k>c00?o0000olK6a_o6a/H04Oo6a/H00ol0003o
fMWIomWIf@0ComWIf@03o`000?o/k>cok>c/01Sok>c/0_l0000/ooooo`03o`00oooooooooooo00So
oooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02oooooacoDe=C0ol0000FofIVIP03o`00
0?miNGWoNGUi01?oNGUi00?o0000ohb<S?n<S8`04On<S8`00ol0003oWinOoinOW`0AoinOW`03o`00
0?nc/k?o/k>c013o/k>c00?o0000olK6a_o6a/H04_o6a/H00ol0003ofMWIomWIf@0BomWIf@03o`00
0?o/k>cok>c/01Wok>c/00?o0000ooooooooool0:oooool00ol00?ooooooooooo`07ooooo`7o0000
0Oooool001Gooooo00?o0000ooooooooool00_ooool00ol0003oDe=Coe=CD`0Loe=CD`03o`000?mV
IVKoIVIV01CoIVIV0_l0000DogUiN@03o`000?n<S8coS8b<017oS8b<00?o0000oinOWonOWil04OnO
Wil00ol0003o/k>cok>c/`0@ok>c/`03o`000?o6a/Koa/K6017oa/K600?o0000omWIfOoIfMT04ooI
fMT2o`0001[ok>c/00?o0000ooooooooool0:_ooool00ol00?ooooooooooo`07ooooo`7o00000Ooo
ool001Gooooo00?o0000ooooooooool00_ooool5o`0001[oDe=C0_l0000GofIVIP;o00004omiNGT2
o`0001;oS8b<0_l0000AoinOW`;o00004_nc/k<00ol0003oa/K6olK6aP0AolK6aP03o`000?oIfMWo
fMWI01?ofMWI00?o0000onc/k?o/k>`06?o/k>`00ol0003oooooooooo`0[ooooo`03o`00oooooooo
oooo00Kooooo0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`Go?clo0_l0000Joe=C
D`?o00005_mVIVH00ol0003oNGUiogUiN@0BogUiN@03o`000?n<S8coS8b<017oS8b<00?o0000oinO
WonOWil04?nOWil00ol0003o/k>cok>c/`0@ok>c/`03o`000?o6a/Koa/K6017oa/K600?o0000omWI
fOoIfMT04ooIfMT00ol0003ok>c/onc/k00Honc/k003o`000?oooooooooo02[ooooo00?o003ooooo
ooooool01_ooool1o`00007ooooo000Eooooo`03o`000?oooooooooo00;ooooo1olo?cl00ol0003o
De=Coe=CD`0Joe=CD`;o00005OmVIVH2o`0001?oNGUi00?o0000ohb<S?n<S8`04On<S8`00ol0003o
WinOoinOW`0@oinOW`03o`000?nc/k?o/k>c013o/k>c00?o0000olK6a_o6a/H04Oo6a/H00ol0003o
fMWIomWIf@0ComWIf@03o`000?o/k>cok>c/01Sok>c/00?o0000ooooooooool0:_ooool00ol00?oo
ooooooooo`05ooooo`7o00000Oooool001Gooooo00?o0000ooooooooool00_ooool8oclo?`;o0000
7?mCDe<00ol0003oIVIVofIVIP0DofIVIP03o`000?miNGWoNGUi017oNGUi00?o0000ohb<S?n<S8`0
4On<S8`00ol0003oWinOoinOW`0?oinOW`03o`000?nc/k?o/k>c013o/k>c00?o0000olK6a_o6a/H0
4Oo6a/H00ol0003ofMWIomWIf@0ComWIf@03o`000?o/k>cok>c/01Sok>c/00?o0000ooooooooool0
:_ooool00ol00?ooooooogl0O`03ogl0O`;ooooo0Ol00001ooooo`005Oooool00ol0003ooooooooo
o`02ooooo`[o?clo0_l0000Koe=CD`03o`000?mVIVKoIVIV01CoIVIV00?o0000ogUiNOmiNGT04Omi
NGT00ol0003oS8b<ohb<S00@ohb<S003o`000?nOWiooWinO013oWinO0_l0000Aok>c/`03o`000?o6
a/Koa/K6017oa/K600?o0000omWIfOoIfMT04_oIfMT00ol0003ok>c/onc/k00Ionc/k003o`000?oo
oooooooo02Wooooo00?oO`1oo`00oomo07l01Omo07l1o`00007ooooo000Eooooo`03o`000?oooooo
oooo00;ooooo3?lo?cl3o`0001WoDe=C00?o0000ofIVI_mVIVH05?mVIVH00ol0003oNGUiogUiN@0A
ogUiN@;o00004On<S8`2o`00017oWinO0_l0000Aok>c/`03o`000?o6a/Koa/K6017oa/K600?o0000
omWIfOoIfMT04_oIfMT00ol0003ok>c/onc/k00Honc/k0;o0000:_ooool00omo07ooool0o`00o`02
oooo00?oO`1o0Ol00001ooooo`005Oooool00ol0003oooooooooo`02ooooo`oo?clo0ol0000Goe=C
D`?o00005?mVIVH2o`0001?oNGUi00?o0000ohb<S?n<S8`04?n<S8`00ol0003oWinOoinOW`0@oinO
W`03o`000?nc/k?o/k>c00oo/k>c00?o0000olK6a_o6a/H04Oo6a/H00ol0003ofMWIomWIf@0BomWI
f@03o`000?o/k>cok>c/01Sok>c/00?o0000ooooooooool09oooool01?mo07ooool0oooo0?l00?l3
oooo00?oO`1o0Oooool000gooooo0ol00005ooooo`03o`000?oooooooooo00;ooooo4_lo?cl2o`00
01SoDe=C00?o0000ofIVI_mVIVH04omVIVH00ol0003oNGUiogUiN@0AogUiN@03o`000?n<S8coS8b<
013oS8b<00?o0000oinOWonOWil04?nOWil00ol0003o/k>cok>c/`0?ok>c/`03o`000?o6a/Koa/K6
017oa/K600?o0000omWIfOoIfMT04_oIfMT00ol0003ok>c/onc/k00Honc/k003o`000?oooooooooo
02Gooooo00Co0000ogl0Ooooo`3oool00ol00?l01?ooo`3oO`1oogl0Oomo07l1ooooo`003_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo5?lo?cl00ol0003oDe=Coe=CD`0F
oe=CD`03o`000?mVIVKoIVIV01?oIVIV00?o0000ogUiNOmiNGT04OmiNGT00ol0003oS8b<ohb<S00@
ohb<S003o`000?nOWiooWinO00ooWinO00?o0000ok>c/onc/k<03onc/k<00ol0003oa/K6olK6aP0A
olK6aP03o`000?oIfMWofMWI01;ofMWI00?o0000onc/k?o/k>`06?o/k>`00ol0003oooooooooo`0T
ooooo`;o000000?oO`1ooooo0?ooo`000ol00?l01?ooo`3oO`1oogl0Oomo07l1ooooo`003_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo5Olo?cl2o`0001OoDe=C0_l0000D
ofIVIP03o`000?miNGWoNGUi017oNGUi00?o0000ohb<S?n<S8`04?n<S8`00ol0003oWinOoinOW`0?
oinOW`03o`000?nc/k?o/k>c00oo/k>c00?o0000olK6a_o6a/H04Oo6a/H00ol0003ofMWIomWIf@0B
omWIf@03o`000?o/k>cok>c/01Sok>c/00?o0000ooooooooool08oooool2o`000003ogl0Ooooo`3o
ool000?o003o00Coool0ogl0Oomo07ooO`1o0Oooool000kooooo00?o0000ooooooooool01?ooool2
o`0000?ooooo5olo?cl00ol0003oDe=Coe=CD`0Foe=CD`03o`000?mVIVKoIVIV01;oIVIV00?o0000
ogUiNOmiNGT04OmiNGT00ol0003oS8b<ohb<S00@ohb<S003o`000?nOWiooWinO00ooWinO00?o0000
ok>c/onc/k<03onc/k<00ol0003oa/K6olK6aP0AolK6aP03o`000?oIfMWofMWI01;ofMWI00?o0000
onc/k?o/k>`05oo/k>`2o`0002Cooooo0_l000000omo07ooool0oooo0003o`00o`04oooo0?mo07oo
O`1oogl0O`7ooooo000>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0noooool2
o`000003ogl0Ooooo`3oool000?o003o00Coool0ogl0Oomo07ooO`1o0Oooool000gooooo0_l00006
ooooo`03o`000?oooooooooo0?_ooooo0_l000000omo07ooool0oooo0004oooo00?oO`1o0Oooool0
00kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
03gooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo
03Oooooo0ol000000omo07ooool0oooo0002oooo00?oO`1o0Ol00001ooooo`005Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo00Sooooo0_l00008ogl0O`7o00000Oooool001Gooooo
ool00004o`0000CoO`1o0ol00001ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQoooo
o`00oooooolQooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {0.117201, 0.0740302, 0.00313309, \
0.00333889}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({0.`, {x1 \[Rule] 1.`, x2 \[Rule] 1.`}}\), 
        ",", \({"Steps" \[Rule] 9, "Residual" \[Rule] 12, 
          "Jacobian" \[Rule] 10}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output"]
}, Open  ]],

Cell["Hessian", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[Rosenbrock[{x1, x2}], {{x1, x2}, 2}]\  // \ MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(2 + 800\ x1\^2 - 
                400\ \((\(-x1\^2\) + x2)\)\), \(\(-400\)\ x1\)},
            {\(\(-400\)\ x1\), "200"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zimmermann's Corner", "Section"],

Cell[BoxData[
    \(\(\(Zimmermann[x_, \ 
        y_]\  := \[IndentingNewLine]Module[{f8, c0, c1, c2, c3, 
          xx}, \[IndentingNewLine]f8\  = \ 
          9 - x\  - \ y; \[IndentingNewLine]c0\  = \ 
          If\ [x\  < \ 0, \ \(-100\)\ x, \ 0]; \[IndentingNewLine]c1\  = \ 
          If\ [y\  < \ 0, \ \(-100\)\ y, \ 
            0]; \[IndentingNewLine]xx\  = \ \((x - 3)\)^2\  + \ \((y - 
                  2)\)^2; \[IndentingNewLine]c2\  = \ 
          If[xx\  > \ 16, \ 100\ *\ \((xx - 16)\), \ 
            0]; \[IndentingNewLine]c3\  = \ 
          If[x\ y\  > \ 14, \ 100\ *\ \((x\ y\  - \ 14)\), \ 
            0]; \[IndentingNewLine]Max[f8, \ c0, \ c1, \ c2, \ 
          c3]\[IndentingNewLine]]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[Zimmermann[x, y], {x, 0, 9}, {y, 0, 9}, \ 
      ColorFunction \[Rule] \((Hue[0.7\ \((1 - #)\)] &)\), 
      ContourLines \[Rule] False, Contours \[Rule] \ 60]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.106838 0.0192308 0.106838 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.23291 -0.0125 -3 -9 ]
[.23291 -0.0125 3 0 ]
[.44658 -0.0125 -3 -9 ]
[.44658 -0.0125 3 0 ]
[.66026 -0.0125 -3 -9 ]
[.66026 -0.0125 3 0 ]
[.87393 -0.0125 -3 -9 ]
[.87393 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .23291 -6 -4.5 ]
[-0.0125 .23291 0 4.5 ]
[-0.0125 .44658 -6 -4.5 ]
[-0.0125 .44658 0 4.5 ]
[-0.0125 .66026 -6 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .87393 -6 -4.5 ]
[-0.0125 .87393 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.23291 0 m
.23291 .00625 L
s
[(2)] .23291 -0.0125 0 1 Mshowa
.44658 0 m
.44658 .00625 L
s
[(4)] .44658 -0.0125 0 1 Mshowa
.66026 0 m
.66026 .00625 L
s
[(6)] .66026 -0.0125 0 1 Mshowa
.87393 0 m
.87393 .00625 L
s
[(8)] .87393 -0.0125 0 1 Mshowa
.125 Mabswid
.07265 0 m
.07265 .00375 L
s
.12607 0 m
.12607 .00375 L
s
.17949 0 m
.17949 .00375 L
s
.28632 0 m
.28632 .00375 L
s
.33974 0 m
.33974 .00375 L
s
.39316 0 m
.39316 .00375 L
s
.5 0 m
.5 .00375 L
s
.55342 0 m
.55342 .00375 L
s
.60684 0 m
.60684 .00375 L
s
.71368 0 m
.71368 .00375 L
s
.76709 0 m
.76709 .00375 L
s
.82051 0 m
.82051 .00375 L
s
.92735 0 m
.92735 .00375 L
s
.98077 0 m
.98077 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .23291 m
.00625 .23291 L
s
[(2)] -0.0125 .23291 1 0 Mshowa
0 .44658 m
.00625 .44658 L
s
[(4)] -0.0125 .44658 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(6)] -0.0125 .66026 1 0 Mshowa
0 .87393 m
.00625 .87393 L
s
[(8)] -0.0125 .87393 1 0 Mshowa
.125 Mabswid
0 .07265 m
.00375 .07265 L
s
0 .12607 m
.00375 .12607 L
s
0 .17949 m
.00375 .17949 L
s
0 .28632 m
.00375 .28632 L
s
0 .33974 m
.00375 .33974 L
s
0 .39316 m
.00375 .39316 L
s
0 .5 m
.00375 .5 L
s
0 .55342 m
.00375 .55342 L
s
0 .60684 m
.00375 .60684 L
s
0 .71368 m
.00375 .71368 L
s
0 .76709 m
.00375 .76709 L
s
0 .82051 m
.00375 .82051 L
s
0 .92735 m
.00375 .92735 L
s
0 .98077 m
.00375 .98077 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.23291 .99375 m
.23291 1 L
s
.44658 .99375 m
.44658 1 L
s
.66026 .99375 m
.66026 1 L
s
.87393 .99375 m
.87393 1 L
s
.125 Mabswid
.07265 .99625 m
.07265 1 L
s
.12607 .99625 m
.12607 1 L
s
.17949 .99625 m
.17949 1 L
s
.28632 .99625 m
.28632 1 L
s
.33974 .99625 m
.33974 1 L
s
.39316 .99625 m
.39316 1 L
s
.5 .99625 m
.5 1 L
s
.55342 .99625 m
.55342 1 L
s
.60684 .99625 m
.60684 1 L
s
.71368 .99625 m
.71368 1 L
s
.76709 .99625 m
.76709 1 L
s
.82051 .99625 m
.82051 1 L
s
.92735 .99625 m
.92735 1 L
s
.98077 .99625 m
.98077 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .23291 m
1 .23291 L
s
.99375 .44658 m
1 .44658 L
s
.99375 .66026 m
1 .66026 L
s
.99375 .87393 m
1 .87393 L
s
.125 Mabswid
.99625 .07265 m
1 .07265 L
s
.99625 .12607 m
1 .12607 L
s
.99625 .17949 m
1 .17949 L
s
.99625 .28632 m
1 .28632 L
s
.99625 .33974 m
1 .33974 L
s
.99625 .39316 m
1 .39316 L
s
.99625 .5 m
1 .5 L
s
.99625 .55342 m
1 .55342 L
s
.99625 .60684 m
1 .60684 L
s
.99625 .71368 m
1 .71368 L
s
.99625 .76709 m
1 .76709 L
s
.99625 .82051 m
1 .82051 L
s
.99625 .92735 m
1 .92735 L
s
.99625 .98077 m
1 .98077 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .94 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 1 .87 r
.01923 .79664 m
.05929 .8176 L
.06543 .82051 L
.09936 .83518 L
.13942 .84967 L
.17678 .86058 L
.17949 .86127 L
.21955 .87015 L
.25962 .87641 L
.29968 .88014 L
.33974 .88138 L
.37981 .88014 L
.41987 .87641 L
.45994 .87178 L
.49193 .86058 L
.5 .84942 L
.51555 .82051 L
.54006 .78279 L
.54167 .78045 L
.57069 .74038 L
.58013 .72825 L
.60313 .70032 L
.62019 .68099 L
.63963 .66026 L
.66026 .63963 L
.68099 .62019 L
.70032 .60313 L
.72825 .58013 L
.74038 .57069 L
.78045 .54167 L
.78279 .54006 L
.82051 .51555 L
.84642 .5 L
.86058 .49191 L
.90064 .47043 L
.92393 .45994 L
.94071 .45415 L
.96454 .41987 L
.96144 .37981 L
.97913 .33974 L
.98077 .3322 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .8 r
.01923 .80854 m
.04185 .82051 L
.05929 .82908 L
.09936 .84633 L
.13942 .86056 L
.13948 .86058 L
.17949 .87196 L
.21955 .8807 L
.25962 .88686 L
.29968 .89053 L
.33974 .89175 L
.37981 .89053 L
.41987 .88686 L
.45994 .88265 L
.5 .87045 L
.51029 .86058 L
.53247 .82051 L
.54006 .80882 L
.55948 .78045 L
.58013 .75242 L
.58949 .74038 L
.62019 .70354 L
.62304 .70032 L
.66026 .66077 L
.66077 .66026 L
.70032 .62304 L
.70354 .62019 L
.74038 .58949 L
.75242 .58013 L
.78045 .55948 L
.80882 .54006 L
.82051 .53247 L
.86058 .50803 L
.87462 .5 L
.90064 .48581 L
.94071 .46573 L
.94905 .45994 L
.97386 .41987 L
.98077 .38518 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .73 r
.01923 .82019 m
.01983 .82051 L
.05929 .84035 L
.09936 .85728 L
.10804 .86058 L
.13942 .87127 L
.17949 .88249 L
.21955 .89108 L
.25962 .89714 L
.29778 .90064 L
.29968 .90076 L
.33974 .90196 L
.37981 .90076 L
.38171 .90064 L
.41987 .89714 L
.45994 .89228 L
.5 .88525 L
.52677 .86058 L
.54006 .83514 L
.54938 .82051 L
.57729 .78045 L
.58013 .77659 L
.60829 .74038 L
.62019 .7261 L
.64294 .70032 L
.66026 .68192 L
.68192 .66026 L
.70032 .64294 L
.7261 .62019 L
.74038 .60829 L
.77659 .58013 L
.78045 .57729 L
.82051 .54938 L
.83485 .54006 L
.86058 .52414 L
.90064 .50119 L
.90282 .5 L
.94071 .48058 L
.96643 .45994 L
.98077 .42461 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .66 r
.01923 .83162 m
.05929 .8514 L
.08043 .86058 L
.09936 .86805 L
.13942 .8818 L
.17949 .89284 L
.21588 .90064 L
.21955 .90129 L
.25962 .90727 L
.29968 .91083 L
.33974 .91202 L
.37981 .91083 L
.41987 .90727 L
.45994 .90129 L
.46361 .90064 L
.5 .89512 L
.54006 .86092 L
.54025 .86058 L
.5663 .82051 L
.58013 .80076 L
.5951 .78045 L
.62019 .74866 L
.62709 .74038 L
.66026 .70307 L
.66285 .70032 L
.70032 .66285 L
.70307 .66026 L
.74038 .62709 L
.74866 .62019 L
.78045 .5951 L
.80076 .58013 L
.82051 .5663 L
.86058 .54025 L
.86088 .54006 L
.90064 .51657 L
.93102 .5 L
.94071 .49506 L
.97967 .45994 L
.98077 .45722 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .59 r
.01923 .84284 m
.05555 .86058 L
.05929 .86227 L
.09936 .87863 L
.13942 .89216 L
.16971 .90064 L
.17949 .90303 L
.21955 .91136 L
.25962 .91725 L
.29968 .92076 L
.33974 .92193 L
.37981 .92076 L
.41987 .91725 L
.45994 .91136 L
.5 .90319 L
.50998 .90064 L
.54006 .88599 L
.55637 .86058 L
.58013 .82493 L
.58322 .82051 L
.61291 .78045 L
.62019 .77122 L
.64589 .74038 L
.66026 .72422 L
.68275 .70032 L
.70032 .68275 L
.72422 .66026 L
.74038 .64589 L
.77122 .62019 L
.78045 .61291 L
.82051 .58322 L
.82493 .58013 L
.86058 .55637 L
.88691 .54006 L
.90064 .53195 L
.94071 .50966 L
.95922 .5 L
.98077 .48355 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .52 r
.01923 .85385 m
.03271 .86058 L
.05929 .87295 L
.09936 .88905 L
.13372 .90064 L
.13942 .90236 L
.17949 .91307 L
.21955 .92128 L
.25962 .92709 L
.29968 .93054 L
.33974 .93169 L
.37981 .93054 L
.41987 .92709 L
.45994 .92128 L
.5 .91361 L
.54006 .90339 L
.54477 .90064 L
.57248 .86058 L
.58013 .8491 L
.60014 .82051 L
.62019 .79378 L
.63072 .78045 L
.66026 .74537 L
.66469 .74038 L
.70032 .70265 L
.70265 .70032 L
.74038 .66469 L
.74537 .66026 L
.78045 .63072 L
.79378 .62019 L
.82051 .60014 L
.8491 .58013 L
.86058 .57248 L
.90064 .54733 L
.91294 .54006 L
.94071 .52437 L
.98077 .50432 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .45 r
.01923 .86467 m
.05929 .88345 L
.09936 .89929 L
.1031 .90064 L
.13942 .91242 L
.17949 .92296 L
.21955 .93106 L
.25962 .93678 L
.29968 .94019 L
.3101 .94071 L
.33974 .94133 L
.36939 .94071 L
.37981 .94019 L
.41987 .93678 L
.45994 .93106 L
.5 .92351 L
.54006 .91705 L
.5656 .90064 L
.58013 .87375 L
.58859 .86058 L
.61706 .82051 L
.62019 .81634 L
.64852 .78045 L
.66026 .76652 L
.68349 .74038 L
.70032 .72256 L
.72256 .70032 L
.74038 .68349 L
.76652 .66026 L
.78045 .64852 L
.81634 .62019 L
.82051 .61706 L
.86058 .58859 L
.87327 .58013 L
.90064 .56271 L
.93897 .54006 L
.94071 .53908 L
.98077 .52005 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .38 r
.01923 .87532 m
.05929 .89379 L
.07598 .90064 L
.09936 .90939 L
.13942 .92232 L
.17949 .93272 L
.21955 .9407 L
.21959 .94071 L
.25962 .94634 L
.29968 .94971 L
.33974 .95083 L
.37981 .94971 L
.41987 .94634 L
.4599 .94071 L
.45994 .9407 L
.5 .93302 L
.54006 .92716 L
.57868 .90064 L
.58013 .89768 L
.60471 .86058 L
.62019 .8389 L
.63398 .82051 L
.66026 .78767 L
.66633 .78045 L
.70032 .74246 L
.70228 .74038 L
.74038 .70228 L
.74246 .70032 L
.78045 .66633 L
.78767 .66026 L
.82051 .63398 L
.8389 .62019 L
.86058 .60471 L
.89744 .58013 L
.90064 .57809 L
.94071 .55379 L
.965 .54006 L
.98077 .53291 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .31 r
.01923 .88578 m
.05151 .90064 L
.05929 .90397 L
.09936 .91934 L
.13942 .93208 L
.17235 .94071 L
.17949 .94233 L
.21955 .95021 L
.25962 .95578 L
.29968 .9591 L
.33974 .96021 L
.37981 .9591 L
.41987 .95578 L
.45994 .95021 L
.5 .94227 L
.50714 .94071 L
.54006 .93488 L
.58013 .91548 L
.59383 .90064 L
.62019 .86147 L
.62082 .86058 L
.6509 .82051 L
.66026 .80881 L
.68414 .78045 L
.70032 .76237 L
.72108 .74038 L
.74038 .72108 L
.76237 .70032 L
.78045 .68414 L
.80881 .66026 L
.82051 .6509 L
.86058 .62082 L
.86145 .62019 L
.90064 .59347 L
.92161 .58013 L
.94071 .56851 L
.98077 .54562 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .24 r
.01923 .89608 m
.02894 .90064 L
.05929 .91399 L
.09936 .92914 L
.13588 .94071 L
.13942 .94171 L
.17949 .95182 L
.21955 .95959 L
.25962 .9651 L
.29968 .96838 L
.33974 .96947 L
.37981 .96838 L
.41987 .9651 L
.45994 .95959 L
.5 .9514 L
.54006 .94136 L
.5436 .94071 L
.58013 .9287 L
.60911 .90064 L
.62019 .88427 L
.63693 .86058 L
.66026 .82996 L
.66782 .82051 L
.70032 .78227 L
.70195 .78045 L
.73988 .74038 L
.74038 .73988 L
.78045 .70195 L
.78227 .70032 L
.82051 .66782 L
.82996 .66026 L
.86058 .63693 L
.88401 .62019 L
.90064 .60885 L
.94071 .58322 L
.94578 .58013 L
.98077 .55972 L
.98077 .98077 L
.01923 .98077 L
F
0 1 .17 r
.01923 .90623 m
.05929 .92387 L
.09936 .93881 L
.10496 .94071 L
.13942 .9512 L
.17949 .96119 L
.21955 .96886 L
.25962 .9743 L
.29968 .97754 L
.33974 .97862 L
.37981 .97754 L
.41987 .9743 L
.45994 .96886 L
.5 .96056 L
.54006 .94774 L
.57453 .94071 L
.58013 .93893 L
.62019 .90735 L
.62424 .90064 L
.65304 .86058 L
.66026 .85111 L
.68474 .82051 L
.70032 .80218 L
.71976 .78045 L
.74038 .75868 L
.75868 .74038 L
.78045 .71976 L
.80218 .70032 L
.82051 .68474 L
.85111 .66026 L
.86058 .65304 L
.90064 .62424 L
.90657 .62019 L
.94071 .59793 L
.96995 .58013 L
.98077 .57382 L
.98077 .98077 L
.01923 .98077 L
F
0 .99 1 r
.01923 .78448 m
.05929 .80589 L
.09136 .82051 L
.09936 .82382 L
.13942 .83858 L
.17949 .85039 L
.21955 .85942 L
.22518 .86058 L
.25962 .86579 L
.29968 .86958 L
.33974 .87084 L
.37981 .86958 L
.41987 .86579 L
.45462 .86058 L
.45994 .85939 L
.49872 .82051 L
.5 .81823 L
.52386 .78045 L
.54006 .75677 L
.55189 .74038 L
.58013 .70408 L
.58323 .70032 L
.61848 .66026 L
.62019 .65843 L
.65843 .62019 L
.66026 .61848 L
.70032 .58323 L
.70408 .58013 L
.74038 .55189 L
.75677 .54006 L
.78045 .52386 L
.81823 .5 L
.82051 .49863 L
.86058 .4758 L
.89086 .45994 L
.90064 .45505 L
.94071 .43974 L
.95291 .41987 L
.94938 .37981 L
.96752 .33974 L
.97417 .29968 L
.97712 .25962 L
.97754 .21955 L
.97543 .17949 L
.97078 .13942 L
.96353 .09936 L
.95359 .05929 L
.94083 .01923 L
.01923 .01923 L
F
0 .92 1 r
.01923 .77205 m
.0339 .78045 L
.05929 .79394 L
.09936 .81224 L
.12029 .82051 L
.13942 .82728 L
.17949 .83931 L
.21955 .84851 L
.25962 .85499 L
.29968 .85885 L
.33974 .86013 L
.37981 .85885 L
.41987 .85653 L
.45994 .84609 L
.48268 .82051 L
.5 .79003 L
.50605 .78045 L
.5331 .74038 L
.54006 .73074 L
.56332 .70032 L
.58013 .67991 L
.59733 .66026 L
.62019 .63587 L
.63587 .62019 L
.66026 .59733 L
.67991 .58013 L
.70032 .56332 L
.73074 .54006 L
.74038 .5331 L
.78045 .50605 L
.79003 .5 L
.82051 .48171 L
.8601 .45994 L
.86058 .45969 L
.90064 .43967 L
.93701 .41987 L
.94071 .41291 L
.94362 .37981 L
.9567 .33974 L
.96339 .29968 L
.96639 .25962 L
.96681 .21955 L
.96468 .17949 L
.95995 .13942 L
.95258 .09936 L
.94246 .05929 L
.94071 .05349 L
.92945 .01923 L
.01923 .01923 L
F
0 .85 1 r
.01923 .75933 m
.05683 .78045 L
.05929 .78172 L
.09936 .80042 L
.13942 .81576 L
.15367 .82051 L
.17949 .82803 L
.21955 .83739 L
.25962 .844 L
.29968 .84792 L
.33974 .84923 L
.37981 .84792 L
.41987 .84775 L
.45994 .82725 L
.46533 .82051 L
.48824 .78045 L
.5 .76183 L
.5143 .74038 L
.54006 .70471 L
.54342 .70032 L
.57618 .66026 L
.58013 .65574 L
.61331 .62019 L
.62019 .61331 L
.65574 .58013 L
.66026 .57618 L
.70032 .54342 L
.70471 .54006 L
.74038 .5143 L
.76183 .5 L
.78045 .48824 L
.82051 .46479 L
.82934 .45994 L
.86058 .44357 L
.90064 .42428 L
.91125 .41987 L
.93985 .37981 L
.94071 .37001 L
.94628 .33974 L
.95243 .29968 L
.95548 .25962 L
.95591 .21955 L
.95374 .17949 L
.94893 .13942 L
.94142 .09936 L
.94071 .09612 L
.93111 .05929 L
.91784 .01923 L
.01923 .01923 L
F
0 .78 1 r
.01923 .74629 m
.05929 .76923 L
.08184 .78045 L
.09936 .78834 L
.13942 .80402 L
.17949 .81652 L
.19445 .82051 L
.21955 .82607 L
.25962 .8328 L
.29968 .8368 L
.33974 .83813 L
.37981 .8368 L
.41987 .83664 L
.44638 .82051 L
.45994 .79918 L
.47043 .78045 L
.4955 .74038 L
.5 .73363 L
.52351 .70032 L
.54006 .67868 L
.55503 .66026 L
.58013 .63157 L
.59075 .62019 L
.62019 .59075 L
.63157 .58013 L
.66026 .55503 L
.67868 .54006 L
.70032 .52351 L
.73363 .5 L
.74038 .4955 L
.78045 .47043 L
.79858 .45994 L
.82051 .44787 L
.86058 .42746 L
.87688 .41987 L
.90064 .41311 L
.93377 .37981 L
.93584 .33974 L
.94071 .30522 L
.94127 .29968 L
.94437 .25962 L
.94481 .21955 L
.9426 .17949 L
.94071 .15794 L
.9377 .13942 L
.93005 .09936 L
.91953 .05929 L
.90599 .01923 L
.01923 .01923 L
F
0 .71 1 r
.01923 .73292 m
.0313 .74038 L
.05929 .75644 L
.09936 .776 L
.10961 .78045 L
.13942 .79202 L
.17949 .8048 L
.21955 .81453 L
.25292 .82051 L
.25962 .82139 L
.29968 .82547 L
.33974 .82682 L
.37981 .82547 L
.41987 .82183 L
.4223 .82051 L
.45283 .78045 L
.45994 .76782 L
.4767 .74038 L
.5 .70543 L
.50361 .70032 L
.53388 .66026 L
.54006 .65265 L
.56819 .62019 L
.58013 .6074 L
.6074 .58013 L
.62019 .56819 L
.65265 .54006 L
.66026 .53388 L
.70032 .50361 L
.70543 .5 L
.74038 .4767 L
.76782 .45994 L
.78045 .45262 L
.82051 .43095 L
.84267 .41987 L
.86058 .41135 L
.90064 .39972 L
.92106 .37981 L
.92496 .33974 L
.9299 .29968 L
.93306 .25962 L
.93351 .21955 L
.93125 .17949 L
.92626 .13942 L
.91845 .09936 L
.90772 .05929 L
.90064 .03819 L
.89389 .01923 L
.01923 .01923 L
F
0 .64 1 r
.01923 .71917 m
.05404 .74038 L
.05929 .74332 L
.09936 .76338 L
.13942 .77976 L
.14129 .78045 L
.17949 .79282 L
.21955 .80276 L
.25962 .80976 L
.29968 .81392 L
.33974 .8153 L
.37981 .81672 L
.41987 .80205 L
.43526 .78045 L
.4579 .74038 L
.45994 .73705 L
.4837 .70032 L
.5 .67724 L
.51273 .66026 L
.54006 .62662 L
.54563 .62019 L
.58013 .58323 L
.58323 .58013 L
.62019 .54563 L
.62662 .54006 L
.66026 .51273 L
.67724 .5 L
.70032 .4837 L
.73705 .45994 L
.74038 .4579 L
.78045 .43481 L
.80884 .41987 L
.82051 .41403 L
.86058 .39523 L
.89806 .37981 L
.90064 .37775 L
.91323 .33974 L
.9183 .29968 L
.92152 .25962 L
.92198 .21955 L
.91968 .17949 L
.91459 .13942 L
.90662 .09936 L
.90064 .07589 L
.89566 .05929 L
.88152 .01923 L
.01923 .01923 L
F
0 .57 1 r
.01923 .70502 m
.05929 .72987 L
.07876 .74038 L
.09936 .75044 L
.13942 .76723 L
.17906 .78045 L
.17949 .78057 L
.21955 .79074 L
.25962 .79789 L
.29968 .80213 L
.33974 .80354 L
.37981 .80828 L
.41712 .78045 L
.41987 .77533 L
.4391 .74038 L
.45994 .70629 L
.4638 .70032 L
.49159 .66026 L
.5 .64904 L
.52308 .62019 L
.54006 .60059 L
.55907 .58013 L
.58013 .55907 L
.60059 .54006 L
.62019 .52308 L
.64904 .5 L
.66026 .49159 L
.70032 .4638 L
.70629 .45994 L
.74038 .4391 L
.775 .41987 L
.78045 .417 L
.82051 .39711 L
.85897 .37981 L
.86058 .37931 L
.90047 .33974 L
.90064 .33831 L
.90646 .29968 L
.90975 .25962 L
.91022 .21955 L
.90787 .17949 L
.90267 .13942 L
.90064 .12741 L
.89453 .09936 L
.88333 .05929 L
.86886 .01923 L
.01923 .01923 L
F
0 .5 1 r
.01923 .69044 m
.03393 .70032 L
.05929 .71604 L
.09936 .73717 L
.10618 .74038 L
.13942 .75439 L
.17949 .76806 L
.21955 .77845 L
.2282 .78045 L
.25962 .78576 L
.29968 .7901 L
.33974 .79154 L
.37981 .79539 L
.39875 .78045 L
.41987 .74119 L
.4203 .74038 L
.4439 .70032 L
.45994 .67553 L
.47044 .66026 L
.5 .62084 L
.50052 .62019 L
.5349 .58013 L
.54006 .57456 L
.57456 .54006 L
.58013 .5349 L
.62019 .50052 L
.62084 .5 L
.66026 .47044 L
.67553 .45994 L
.70032 .4439 L
.74038 .4203 L
.74116 .41987 L
.78045 .39919 L
.82051 .3802 L
.82138 .37981 L
.86058 .36675 L
.89175 .33974 L
.89507 .29968 L
.89773 .25962 L
.89821 .21955 L
.89581 .17949 L
.8905 .13942 L
.88218 .09936 L
.87071 .05929 L
.86058 .03148 L
.85589 .01923 L
.01923 .01923 L
F
0 .43 1 r
.01923 .67538 m
.05686 .70032 L
.05929 .70179 L
.09936 .72355 L
.13731 .74038 L
.13942 .74122 L
.17949 .75524 L
.21955 .76588 L
.25962 .77336 L
.29968 .77779 L
.33974 .77985 L
.37981 .77611 L
.40188 .74038 L
.41987 .70732 L
.42399 .70032 L
.44929 .66026 L
.45994 .64477 L
.47796 .62019 L
.5 .59264 L
.51073 .58013 L
.54006 .54853 L
.54853 .54006 L
.58013 .51073 L
.59264 .5 L
.62019 .47796 L
.64477 .45994 L
.66026 .44929 L
.70032 .42399 L
.70732 .41987 L
.74038 .4015 L
.78045 .38138 L
.78378 .37981 L
.82051 .36328 L
.86058 .34979 L
.87338 .33974 L
.88363 .29968 L
.88545 .25962 L
.88594 .21955 L
.88349 .17949 L
.87805 .13942 L
.86953 .09936 L
.86058 .06768 L
.85779 .05929 L
.84259 .01923 L
.01923 .01923 L
F
0 .36 1 r
.01923 .65978 m
.01988 .66026 L
.05929 .68712 L
.08187 .70032 L
.09936 .70953 L
.13942 .72771 L
.1741 .74038 L
.17949 .74209 L
.21955 .75301 L
.25962 .76067 L
.29968 .76521 L
.33974 .77251 L
.37981 .74677 L
.38284 .74038 L
.40409 .70032 L
.41987 .67349 L
.42814 .66026 L
.4554 .62019 L
.45994 .61401 L
.48656 .58013 L
.5 .56444 L
.5225 .54006 L
.54006 .5225 L
.56444 .5 L
.58013 .48656 L
.61401 .45994 L
.62019 .4554 L
.66026 .42814 L
.67349 .41987 L
.70032 .40409 L
.74038 .38271 L
.74618 .37981 L
.78045 .36358 L
.82051 .34636 L
.84112 .33974 L
.86058 .32583 L
.87067 .29968 L
.87289 .25962 L
.87339 .21955 L
.87088 .17949 L
.8653 .13942 L
.86058 .11523 L
.85658 .09936 L
.84454 .05929 L
.82892 .01923 L
.01923 .01923 L
F
0 .29 1 r
.01923 .64361 m
.0419 .66026 L
.05929 .67194 L
.09936 .69509 L
.10964 .70032 L
.13942 .71381 L
.17949 .7286 L
.21955 .73981 L
.22176 .74038 L
.25962 .74766 L
.29968 .75232 L
.33974 .76072 L
.36436 .74038 L
.37981 .70882 L
.38418 .70032 L
.40699 .66026 L
.41987 .63965 L
.43284 .62019 L
.45994 .58325 L
.46239 .58013 L
.49647 .54006 L
.5 .53624 L
.53624 .5 L
.54006 .49647 L
.58013 .46239 L
.58325 .45994 L
.62019 .43284 L
.63965 .41987 L
.66026 .40699 L
.70032 .38418 L
.70858 .37981 L
.74038 .36391 L
.78045 .34577 L
.79475 .33974 L
.82051 .33215 L
.85796 .29968 L
.86008 .25962 L
.86053 .21955 L
.85795 .17949 L
.85225 .13942 L
.8433 .09936 L
.83092 .05929 L
.82051 .03284 L
.81486 .01923 L
.01923 .01923 L
F
0 .22 1 r
.01923 .62675 m
.05929 .65621 L
.06548 .66026 L
.09936 .68019 L
.13942 .6995 L
.14132 .70032 L
.17949 .71474 L
.21955 .72626 L
.25962 .73432 L
.29968 .73956 L
.30747 .74038 L
.33974 .74094 L
.3405 .74038 L
.36507 .70032 L
.37981 .67099 L
.38584 .66026 L
.41028 .62019 L
.41987 .60581 L
.43822 .58013 L
.45994 .55248 L
.47045 .54006 L
.5 .50805 L
.50805 .5 L
.54006 .47045 L
.55248 .45994 L
.58013 .43822 L
.60581 .41987 L
.62019 .41028 L
.66026 .38584 L
.67099 .37981 L
.70032 .36428 L
.74038 .34511 L
.75245 .33974 L
.78045 .32796 L
.82051 .31665 L
.84288 .29968 L
.84818 .25962 L
.84735 .21955 L
.84471 .17949 L
.83885 .13942 L
.82965 .09936 L
.82051 .06931 L
.81692 .05929 L
.80038 .01923 L
.01923 .01923 L
F
0 .15 1 r
.01923 .60915 m
.03278 .62019 L
.05929 .63989 L
.09142 .66026 L
.09936 .66476 L
.13942 .68475 L
.1791 .70032 L
.17949 .70045 L
.21955 .71232 L
.25962 .72062 L
.29968 .72994 L
.33974 .71115 L
.34484 .70032 L
.36469 .66026 L
.37981 .63339 L
.38773 .62019 L
.41405 .58013 L
.41987 .57197 L
.44442 .54006 L
.45994 .52172 L
.47985 .5 L
.5 .47985 L
.52172 .45994 L
.54006 .44442 L
.57197 .41987 L
.58013 .41405 L
.62019 .38773 L
.63339 .37981 L
.66026 .36469 L
.70032 .34437 L
.71016 .33974 L
.74038 .32631 L
.78045 .31015 L
.8119 .29968 L
.82051 .29386 L
.83485 .25962 L
.83382 .21955 L
.8311 .17949 L
.82507 .13942 L
.82051 .11755 L
.81579 .09936 L
.8025 .05929 L
.78542 .01923 L
.01923 .01923 L
F
0 .08 1 r
.01923 .59068 m
.05563 .62019 L
.05929 .62287 L
.09936 .64928 L
.12035 .66026 L
.13942 .66948 L
.17949 .68665 L
.21955 .69906 L
.22826 .70032 L
.25962 .70652 L
.29968 .71616 L
.32348 .70032 L
.33974 .66807 L
.34355 .66026 L
.36517 .62019 L
.37981 .59579 L
.38988 .58013 L
.41839 .54006 L
.41987 .53813 L
.45165 .5 L
.45994 .49096 L
.49096 .45994 L
.5 .45165 L
.53813 .41987 L
.54006 .41839 L
.58013 .38988 L
.59579 .37981 L
.62019 .36517 L
.66026 .34355 L
.66786 .33974 L
.70032 .32447 L
.74038 .30751 L
.76052 .29968 L
.78045 .29597 L
.82 .25962 L
.82036 .21955 L
.81877 .17949 L
.81274 .13942 L
.80168 .09936 L
.78761 .05929 L
.78045 .04233 L
.77077 .01923 L
.01923 .01923 L
F
0 .01 1 r
.01923 .57306 m
.02898 .58013 L
.05929 .60761 L
.08051 .62019 L
.09936 .63278 L
.13942 .6543 L
.15375 .66026 L
.17949 .67142 L
.21955 .68942 L
.25962 .69284 L
.29968 .69517 L
.32566 .66026 L
.33974 .62556 L
.34261 .62019 L
.36601 .58013 L
.37981 .55819 L
.39236 .54006 L
.41987 .5043 L
.42345 .5 L
.45994 .4602 L
.4602 .45994 L
.5 .42345 L
.5043 .41987 L
.54006 .39236 L
.55819 .37981 L
.58013 .36601 L
.62019 .34261 L
.62556 .33974 L
.66026 .32323 L
.70032 .30456 L
.71218 .29968 L
.74038 .2919 L
.78045 .28234 L
.80715 .25962 L
.81474 .21955 L
.8094 .17949 L
.79927 .13942 L
.78653 .09936 L
.78045 .08117 L
.77299 .05929 L
.75508 .01923 L
.01923 .01923 L
F
.06 0 1 r
.01923 .55321 m
.05139 .58013 L
.05929 .58816 L
.09936 .6148 L
.10459 .62019 L
.13942 .63898 L
.17949 .65444 L
.19455 .66026 L
.21955 .67256 L
.25962 .67885 L
.29968 .66323 L
.30193 .66026 L
.32843 .62019 L
.33974 .58327 L
.34162 .58013 L
.374 .54006 L
.37981 .52081 L
.39673 .5 L
.41987 .47046 L
.42958 .45994 L
.45994 .42958 L
.47046 .41987 L
.5 .39673 L
.52081 .37981 L
.54006 .374 L
.58013 .34162 L
.58327 .33974 L
.62019 .32843 L
.66026 .30142 L
.66384 .29968 L
.70032 .28636 L
.74038 .2741 L
.77408 .25962 L
.78045 .25497 L
.79985 .21955 L
.79268 .17949 L
.78145 .13942 L
.78045 .13582 L
.77094 .09936 L
.75798 .05929 L
.74038 .02469 L
.73698 .01923 L
.01923 .01923 L
F
.13 0 1 r
.01923 .52435 m
.03243 .54006 L
.05929 .56193 L
.07822 .58013 L
.09936 .59477 L
.13942 .62003 L
.13965 .62019 L
.17949 .63494 L
.21955 .64637 L
.24742 .66026 L
.25962 .6618 L
.26623 .66026 L
.29605 .62019 L
.29968 .61529 L
.31729 .58013 L
.33974 .54135 L
.341 .54006 L
.36474 .5 L
.37981 .48409 L
.39998 .45994 L
.41987 .43908 L
.43908 .41987 L
.45994 .39998 L
.48409 .37981 L
.5 .36474 L
.54006 .341 L
.54135 .33974 L
.58013 .31729 L
.61529 .29968 L
.62019 .29605 L
.66026 .27766 L
.70032 .2662 L
.72171 .25962 L
.74038 .24624 L
.77146 .21955 L
.76679 .17949 L
.75943 .13942 L
.75327 .09936 L
.74038 .06139 L
.73899 .05929 L
.71617 .01923 L
.01923 .01923 L
F
0 1 .1 r
.01923 .91622 m
.05929 .93362 L
.07766 .94071 L
.09936 .94835 L
.13942 .96058 L
.17949 .97044 L
.21955 .97802 L
.23694 .98077 L
.01923 .98077 L
F
0 1 .03 r
.01923 .92607 m
.05304 .94071 L
.05929 .94322 L
.09936 .95776 L
.13942 .96983 L
.17949 .97958 L
.18497 .98077 L
.01923 .98077 L
F
.04 1 0 r
.01923 .93578 m
.03036 .94071 L
.05929 .9527 L
.09936 .96705 L
.13942 .97898 L
.14612 .98077 L
.01923 .98077 L
F
.11 1 0 r
.01923 .94535 m
.05929 .96205 L
.09936 .97623 L
.1138 .98077 L
.01923 .98077 L
F
.18 1 0 r
.01923 .9548 m
.05929 .97129 L
.08559 .98077 L
.01923 .98077 L
F
.25 1 0 r
.01923 .96413 m
.05929 .98042 L
.06023 .98077 L
.01923 .98077 L
F
.32 1 0 r
.01923 .97334 m
.03705 .98077 L
.01923 .98077 L
F
0 1 .1 r
.98077 .58792 m
.94071 .61264 L
.92913 .62019 L
.90064 .63962 L
.87226 .66026 L
.86058 .66916 L
.82208 .70032 L
.82051 .70165 L
.78045 .73757 L
.77748 .74038 L
.74038 .77748 L
.73757 .78045 L
.70165 .82051 L
.70032 .82208 L
.66916 .86058 L
.66026 .87226 L
.63962 .90064 L
.62019 .92887 L
.60219 .94071 L
.58013 .9474 L
.54006 .95516 L
.5 .96987 L
.45994 .97802 L
.44254 .98077 L
.98077 .98077 L
F
0 1 .03 r
.98077 .60202 m
.95169 .62019 L
.94071 .62735 L
.90064 .655 L
.89341 .66026 L
.86058 .68527 L
.84199 .70032 L
.82051 .71857 L
.79628 .74038 L
.78045 .75538 L
.75538 .78045 L
.74038 .79628 L
.71857 .82051 L
.70032 .84199 L
.68527 .86058 L
.66026 .89341 L
.655 .90064 L
.62552 .94071 L
.62019 .94433 L
.58013 .95532 L
.54006 .96477 L
.5 .97948 L
.49452 .98077 L
.98077 .98077 L
F
.04 1 0 r
.98077 .61612 m
.97425 .62019 L
.94071 .64207 L
.91456 .66026 L
.90064 .67038 L
.86189 .70032 L
.86058 .70138 L
.82051 .73549 L
.81508 .74038 L
.78045 .77319 L
.77319 .78045 L
.74038 .81508 L
.73549 .82051 L
.70138 .86058 L
.70032 .86189 L
.67038 .90064 L
.66026 .91654 L
.64287 .94071 L
.62019 .95606 L
.58013 .96392 L
.54006 .97772 L
.53337 .98077 L
.98077 .98077 L
F
.11 1 0 r
.98077 .63021 m
.94071 .65678 L
.93571 .66026 L
.90064 .68576 L
.8818 .70032 L
.86058 .7175 L
.83388 .74038 L
.82051 .75241 L
.791 .78045 L
.78045 .791 L
.75241 .82051 L
.74038 .83388 L
.7175 .86058 L
.70032 .8818 L
.68576 .90064 L
.66026 .93672 L
.65712 .94071 L
.62019 .96554 L
.58013 .97443 L
.56569 .98077 L
.98077 .98077 L
F
.18 1 0 r
.98077 .64431 m
.95685 .66026 L
.94071 .67149 L
.9017 .70032 L
.90064 .70114 L
.86058 .73361 L
.85267 .74038 L
.82051 .76933 L
.80881 .78045 L
.78045 .80881 L
.76933 .82051 L
.74038 .85267 L
.73361 .86058 L
.70114 .90064 L
.70032 .90174 L
.67171 .94071 L
.66026 .95197 L
.62019 .97355 L
.5939 .98077 L
.98077 .98077 L
F
.25 1 0 r
.98077 .65841 m
.978 .66026 L
.94071 .6862 L
.92161 .70032 L
.90064 .71652 L
.87147 .74038 L
.86058 .74972 L
.82662 .78045 L
.82051 .78625 L
.78625 .82051 L
.78045 .82662 L
.74972 .86058 L
.74038 .87147 L
.71652 .90064 L
.70032 .92215 L
.6864 .94071 L
.66026 .96396 L
.62019 .98052 L
.61926 .98077 L
.98077 .98077 L
F
.32 1 0 r
.98077 .67251 m
.94151 .70032 L
.94071 .70092 L
.90064 .7319 L
.89027 .74038 L
.86058 .76584 L
.84443 .78045 L
.82051 .80317 L
.80317 .82051 L
.78045 .84443 L
.76584 .86058 L
.74038 .89027 L
.7319 .90064 L
.70092 .94071 L
.70032 .94145 L
.66026 .97382 L
.64257 .98077 L
.98077 .98077 L
F
.39 1 0 r
.98077 .68661 m
.96141 .70032 L
.94071 .71563 L
.90907 .74038 L
.90064 .74728 L
.86224 .78045 L
.86058 .78195 L
.82051 .82009 L
.82009 .82051 L
.78195 .86058 L
.78045 .86224 L
.74728 .90064 L
.74038 .9092 L
.71563 .94071 L
.70032 .95858 L
.66416 .98077 L
.98077 .98077 L
F
.46 1 0 r
.98077 .70071 m
.94071 .73034 L
.92787 .74038 L
.90064 .76266 L
.88005 .78045 L
.86058 .79806 L
.83701 .82051 L
.82051 .83701 L
.79806 .86058 L
.78045 .88005 L
.76266 .90064 L
.74038 .92811 L
.73034 .94071 L
.70032 .97247 L
.68444 .98077 L
.98077 .98077 L
F
.53 1 0 r
.98077 .71481 m
.94667 .74038 L
.94071 .74505 L
.90064 .77804 L
.89786 .78045 L
.86058 .81418 L
.85392 .82051 L
.82051 .85392 L
.81418 .86058 L
.78045 .89786 L
.77804 .90064 L
.74505 .94071 L
.74038 .94642 L
.70357 .98077 L
.98077 .98077 L
F
.6 1 0 r
.98077 .72891 m
.96547 .74038 L
.94071 .75976 L
.91566 .78045 L
.90064 .79342 L
.87084 .82051 L
.86058 .83029 L
.83029 .86058 L
.82051 .87084 L
.79342 .90064 L
.78045 .91566 L
.75976 .94071 L
.74038 .96373 L
.72181 .98077 L
.98077 .98077 L
F
.67 1 0 r
.98077 .74301 m
.94071 .77448 L
.93347 .78045 L
.90064 .8088 L
.88776 .82051 L
.86058 .8464 L
.8464 .86058 L
.82051 .88776 L
.8088 .90064 L
.78045 .93347 L
.77448 .94071 L
.74038 .97961 L
.73909 .98077 L
.98077 .98077 L
F
.74 1 0 r
.98077 .75711 m
.95128 .78045 L
.94071 .78919 L
.90468 .82051 L
.90064 .82419 L
.86252 .86058 L
.86058 .86252 L
.82419 .90064 L
.82051 .90468 L
.78919 .94071 L
.78045 .95128 L
.75531 .98077 L
.98077 .98077 L
F
.81 1 0 r
.98077 .77121 m
.96909 .78045 L
.94071 .8039 L
.9216 .82051 L
.90064 .83957 L
.87863 .86058 L
.86058 .87863 L
.83957 .90064 L
.82051 .9216 L
.8039 .94071 L
.78045 .96909 L
.77071 .98077 L
.98077 .98077 L
F
.88 1 0 r
.98077 .7853 m
.94071 .81861 L
.93852 .82051 L
.90064 .85495 L
.89474 .86058 L
.86058 .89474 L
.85495 .90064 L
.82051 .93852 L
.81861 .94071 L
.78545 .98077 L
.98077 .98077 L
F
.95 1 0 r
.98077 .7994 m
.95544 .82051 L
.94071 .83332 L
.91086 .86058 L
.90064 .87033 L
.87033 .90064 L
.86058 .91086 L
.83332 .94071 L
.82051 .95544 L
.79968 .98077 L
.98077 .98077 L
F
1 .98 0 r
.98077 .8135 m
.97236 .82051 L
.94071 .84804 L
.92697 .86058 L
.90064 .88571 L
.88571 .90064 L
.86058 .92697 L
.84804 .94071 L
.82051 .97236 L
.81363 .98077 L
.98077 .98077 L
F
1 .91 0 r
.98077 .8276 m
.94308 .86058 L
.94071 .86275 L
.90109 .90064 L
.90064 .9011 L
.86275 .94071 L
.86058 .94308 L
.82769 .98077 L
.98077 .98077 L
F
1 .84 0 r
.98077 .8417 m
.9592 .86058 L
.94071 .87746 L
.91647 .90064 L
.90064 .91666 L
.87746 .94071 L
.86058 .9592 L
.8419 .98077 L
.98077 .98077 L
F
1 .77 0 r
.98077 .8558 m
.97531 .86058 L
.94071 .89217 L
.93185 .90064 L
.90064 .93202 L
.89217 .94071 L
.86058 .97531 L
.8559 .98077 L
.98077 .98077 L
F
1 .7 0 r
.98077 .87 m
.94723 .90064 L
.94071 .90707 L
.90696 .94071 L
.90064 .947 L
.86943 .98077 L
.98077 .98077 L
F
1 .63 0 r
.98077 .88417 m
.96261 .90064 L
.94071 .92207 L
.92178 .94071 L
.90064 .9614 L
.88248 .98077 L
.98077 .98077 L
F
1 .56 0 r
.98077 .89815 m
.97799 .90064 L
.94071 .93654 L
.9364 .94071 L
.90064 .97502 L
.89515 .98077 L
.98077 .98077 L
F
1 .49 0 r
.98077 .91189 m
.95067 .94071 L
.94071 .95011 L
.90739 .98077 L
.98077 .98077 L
F
1 .42 0 r
.98077 .92517 m
.96447 .94071 L
.94071 .96241 L
.91924 .98077 L
.98077 .98077 L
F
1 .35 0 r
.98077 .93774 m
.97764 .94071 L
.94071 .97306 L
.93079 .98077 L
.98077 .98077 L
F
1 .28 0 r
.98077 .94943 m
.94208 .98077 L
.98077 .98077 L
F
0 1 .87 r
.98077 .13466 m
.97431 .09936 L
.96454 .05929 L
.952 .01923 L
.98077 .01923 L
F
1 .21 0 r
.98077 .96003 m
.95316 .98077 L
.98077 .98077 L
F
0 1 .8 r
.98077 .08045 m
.9753 .05929 L
.96297 .01923 L
.98077 .01923 L
F
1 .14 0 r
.98077 .96935 m
.96408 .98077 L
.98077 .98077 L
F
0 1 .73 r
.98077 .04178 m
.97375 .01923 L
.98077 .01923 L
F
1 .07 0 r
.98077 .97718 m
.97488 .98077 L
.98077 .98077 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`003oooool2o`0003Kooooo1Ol0000hooooo`?o0000=oooool3o`0003Oooooo0ol0000Uoooo
o`003_ooool01?l0003oooooooooool0000fooooo`04o`000?ooooooooooo`0003Wooooo00?o0000
ooooooooool0=Oooool01Ol0003ooooooooooooooooo000003Gooooo00Go0000oooooooooooooooo
o`00000Tooooo`003_ooool01?l0003oooooooooool0000gooooo`03o`000?oooooooooo03Kooooo
1Ol0000fooooo`05o`000?ooooooooooooooool00000=Oooool01Ol0003ooooooooooooooooo0000
02Cooooo000>ooooo`04o`000?ooooooooooo`0003Sooooo00?o0000ooooooooool0=Oooool01?l0
003oooooooooool0000gooooo`Co0000=oooool3o`0002Gooooo000>ooooo`04o`000?oooooooooo
o`0003Gooooo00Go0000ooooooooooooooooo`00000gooooo`03o`000?oooooo000003Oooooo00?o
0000ooooooooool0=oooool01Ol0003ooooooooooooooooo000002Cooooo000>ooooo`04o`000?oo
ooooooooo`0003Gooooo00Go0000ooooooooooooooooo`00000hooooo`;o0000>?ooool00ol0003o
ooooooooo`0fooooo`05o`000?ooooooooooooooool000009?ooool000oooooo0_l0000gooooo`?o
0000>_ooool00ol0003oooooooooo`0gooooo`;o0000=oooool3o`0002Gooooo003oooooob7ooooo
003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo000:oooooooo0000
5Ol00002ooooo`002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;ooooo0Ol0
0001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0=oooool0
0ol0003oooooooooo`0hooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0=oooool0
0ol0003oooooooooo`0Pooooo`7o00000Oooool1ooooo`000oooool2o`0000Gooooo00?o0000oooo
ooooool0oooooolAooooo`7o00000Oooool1ooooo`000_ooool01?l0003oooooooooool00004oooo
o`03o`000?oooooooooo0?oooooo4Oooool1o`00007ooooo0Oooool000;ooooo00Co0000oooooooo
oooo00001?ooool3o`000?oooooo3oooool3o`0000;ooooo0002ooooo`04o`000?ooooooooooo`00
00Cooooo00?o0000ooooooooool00ooooonoob40o`Ko3`3o1Ol00_l4o`0Do`Co02Ko1?l0>?l4o`1:
o`Co05co1?l0K_l3o`1oo`Co097o0ol0Xol4o`2eo`?o0<Oo0ol0fOl4o`3[o`?o0?go0ol0oo03o`3o
gP?o0?o<0_l0okX5ooooo`7o00000Oooool1ooooo`000_ooool01?l0003oooooooooool00004oooo
o`03o`000?oooooooooo00?ooooo`?lQ0?l6o`l0o`Go00;o1?l05?l4o`0Vo`Co03So1?l0B_l4o`1L
o`Co06ko0ol0Ool4o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`0ol0omh4o`3o
c003o`3o^_oooooooooo00?ooooo0Ol00001ooooo`7ooooo0002ooooo`04o`000?ooooooooooo`00
00Cooooo00?o0000ooooooooool00oooooo0ob40o`Ko3`3o1Ol00_l4o`0Do`Co02Ko1?l0>?l4o`1:
o`Co05co1?l0K_l3o`1oo`Co097o0ol0Xol4o`2eo`?o0<Oo0ol0fOl4o`3[o`?o0?go0ol0oo03o`3o
gP?o0?o<00?o0?njooooooooool00oooool1o`00007ooooo0Oooool000?ooooo0_l00005ooooo`03
o`000?oooooooooo00?ooooo`OlQ0?l6o`l0o`Go00;o1?l05?l4o`0Vo`Co03So1?l0B_l3o`1Lo`Co
06ko1?l0Ool3o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo1?l0jol3o`3mo`?o0?o`0ol0omh3o`3oc003
o`3o^_oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo
`OlQ0?l6o`l0o`Go00;o1?l05?l4o`0Vo`Co03So1?l0B_l4o`1Lo`Co06ko0ol0Ool4o`2Ao`?o0:?o
1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`0ol0omh4o`3oc0Gooooo0Ol00001ooooo`7ooooo
000:ooooo`03o`000?oooooooooo00?ooooo`_lQ0?l6o`l0o`Go00;o0ol05?l5o`0Vo`Co03So1?l0
B_l3o`1Lo`Co06ko0ol0Ool4o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo1?l0jol3o`3mo`?o0?o`0ol0
omh3o`3oc0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo`olQ0?l5
o`l0o`Go00;o1?l05?l4o`0Vo`Co03So1?l0B_l3o`1Lo`Co06ko1?l0Ool3o`2Ao`?o0:?o1Ol0]Ol2
o`37o`?o0=Wo1?l0jol3o`3mo`?o0?o`0ol0omh3o`3oc0Gooooo0Ol00001ooooo`7ooooo000:oooo
o`03o`000?oooooooooo00?ooooo`olQ0?l5o`l0o`Go00;o1?l05?l4o`0Vo`Co03So1Ol0B_l3o`1L
o`Co06ko0ol0Ool4o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`0ol0omh3o`3o
c0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooa?lQ0?l5o`l0o`Go
00;o1?l05?l4o`0Vo`Co03So1?l0B_l3o`1Lo`Co06ko0ol0Ool4o`2Ao`?o0:?o1?l0]Ol3o`37o`?o
0=Wo1?l0jol2o`3mo`?o0?o`0ol0omh3o`3oc0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`00
0?oooooooooo00?oooooa?lQ0?l5o`l0o`Go00;o1?l05?l4o`0Vo`Co03So1?l0B_l3o`1Lo`Co06ko
1?l0Ool3o`2Ao`?o0:?o1Ol0]Ol2o`37o`?o0=Wo1?l0jol3o`3mo`?o0?o`0ol0omh2o`3oc0Gooooo
0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooaOlQ0?l5o`l0o`Go00;o1?l0
5?l4o`0Vo`Co03So1?l0B_l3o`1Lo`Co06ko0ol0Ool4o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0
jol3o`3mo`?o0?o`0ol0omh2o`3oc0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooo
oooo00?oooooa_lQ0?l4o`l0o`Go00;o1?l05?l4o`0Vo`Co03So1?l0B_l3o`1Lo`Co06ko0ol0Ool4
o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`0ol0omh2o`3oc0Gooooo0Ol00001
ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooa_lQ0?l5o`l0o`Go00;o0ol05?l4o`0V
o`Go03So0ol0B_l4o`1Lo`Co06ko0ol0Ool3o`2Ao`Co0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3m
o`?o0?o`1?l0omh00ol0olcoooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003o
ooooooooo`03ooooolKo8@3o1Ol?0?l5o`02o`Co01Co1?l09_l4o`0ho`Co04[o0ol0G?l4o`1^o`?o
07oo1?l0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl3o`3ol0?o0?oN00?o0?o<oooooooo
ool00oooool1o`00007ooooo0Oooool000[ooooo0_l00004ooooolOo8@3o1?l?0?l5o`02o`Co01Co
1?l09_l4o`0ho`Co04[o0ol0G?l4o`1^o`?o07oo1?l0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o
0ol0oOl3o`3ol0?o0?oN00?o0?o<ooooooooool00_ooool2o`0000;ooooo000:ooooo`03o`000?oo
oooooooo00?oooooaolQ0?l5o`l0o`Go00;o0ol05?l4o`0Vo`Co03So1?l0B_l4o`1Lo`?o06ko1?l0
Ool3o`2Ao`Co0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`1?l0omh5ooooo`7o00000Ooo
ool1ooooo`002_ooool00ol0003oooooooooo`03ooooolOo8@3o1Ol?0?l5o`02o`Co01Co1?l09_l4
o`0ho`Co04[o0ol0G?l4o`1^o`?o07oo1?l0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl3
o`3ol0?o0?oN1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooooo8ob40
o`Co3`3o1Ol00_l4o`0Do`Co02Ko1?l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`Co097o0ol0Xol4o`2e
o`?o0<Oo0ol0fOl3o`3[o`?o0?go0ol0oo03o`3ogPGooooo0Ol00001ooooo`7ooooo000:ooooo`03
o`000?oooooooooo00?ooooob?lQ0?l5o`l0o`Co00;o1?l05?l4o`0Vo`Co03So1?l0B_l4o`1Lo`?o
06ko1?l0Ool3o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`0ol0omh5ooooo`7o
00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooolSo8@3o1Ol?0?l5o`02o`?o01Co
1?l09_l4o`0ho`Co04[o1?l0G?l3o`1^o`Co07oo0ol0TOl4o`2So`?o0;Go0ol0aol4o`3Io`;o0>_o
0ol0oOl3o`3ol0?o0?oN1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooo
ooo9ob40o`Co3`3o1Ol00_l4o`0Do`Co02Ko1?l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`Co097o0ol0
Xol4o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0ol0oo02o`3ogPGooooo0Ol00001ooooo`7ooooo000:
ooooo`03o`000?oooooooooo00?ooooobOlQ0?l5o`l0o`Co00;o1?l05?l4o`0Vo`Co03So1?l0B_l4
o`1Lo`?o06ko1?l0Ool3o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`0_l0omh5
ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooolWo8@3o1Ol?0?l4o`02
o`Co01Co1?l09_l4o`0ho`Co04[o1?l0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3I
o`?o0>_o0ol0oOl3o`3ol0;o0?oN1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooooooo
ool00oooooo9ob40o`Go3`3o1Ol00_l4o`0Do`Co02Ko0ol0>?l4o`1:o`Co05co0ol0K_l4o`1oo`?o
097o0ol0Xol4o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0ol0oo02o`3ogPGooooo0Ol00001ooooo`7o
oooo000:ooooo`03o`000?oooooooooo00?ooooobOlQ0?l6o`l0o`Co00;o1?l05?l4o`0Vo`Co03So
0ol0B_l5o`1Lo`;o06ko1?l0Ool4o`2Ao`;o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`Co0?o`
00?o0?oNooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooo
ooo:ob40o`Go3`3o1?l00_l4o`0Do`Co02Ko1?l0>?l4o`1:o`Co05co0ol0K_l4o`1oo`?o097o0ol0
Xol4o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0ol0oo000ol0omkoooooooooo`03ooooo`7o00000Ooo
ool1ooooo`002_ooool00ol0003oooooooooo`03oooool[o8@3o1Ol?0?l5o`02o`Co01Co1?l09_l3
o`0ho`Co04[o1?l0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl3
o`3ol003o`3og_oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo
00?ooooob_lQ0?l6o`l0o`Co00;o1?l05?l4o`0Vo`Co03So0ol0B_l4o`1Lo`?o06ko1?l0Ool3o`2A
o`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`00?o0?oNooooooooool00oooool1o`00
007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooooo:ob40o`Ko3`3o1?l00_l4o`0Do`Co
02Ko1?l0>?l3o`1:o`Co05co0ol0K_l4o`1oo`Co097o0_l0Xol4o`2eo`?o0<Oo0ol0fOl3o`3[o`?o
0?go0ol0oo000ol0omkoooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool2o`0000Cooooo
b_lQ0?l6o`l0o`Go00;o1?l05?l3o`0Vo`Co03So0ol0B_l4o`1Lo`?o06ko1?l0Ool4o`2Ao`;o0:?o
1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`Co0?o`1?ooool2o`0000;ooooo000:ooooo`03o`000?oo
oooooooo00?ooooobolQ0?l6o`l0o`Co00;o1?l05?l4o`0Vo`?o03So1?l0B_l4o`1Lo`?o06ko1?l0
Ool3o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`1Oooool1o`00007ooooo0Ooo
ool000[ooooo00?o0000ooooooooool00oooooo;ob40o`Ko3`3o1?l00_l4o`0Do`Co02Ko1?l0>?l3
o`1:o`Co05co0ol0K_l4o`1oo`?o097o0ol0Xol4o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0ol0oo05
ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooool_o8@3o1_l?0?l5o`02
o`Co01Co0ol09_l4o`0ho`?o04[o1?l0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3I
o`?o0>_o0ol0oOl3o`3ol0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?o
oooobolQ0?l6o`l0o`Go00;o1?l05?l3o`0Vo`Co03So0ol0B_l4o`1Lo`?o06ko1?l0Ool3o`2Ao`?o
0:?o1?l0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo
00?o0000ooooooooool00oooooo;ob40o`Ko3`3o1Ol00_l4o`0Do`?o02Ko1?l0>?l3o`1:o`Co05co
0ol0K_l4o`1oo`?o097o0ol0Xol4o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0ol0oo05ooooo`7o0000
0Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooool_o8@3o1ol?0?l5o`02o`?o01Co0ol0
9_l4o`0ho`?o04[o1?l0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go1?l0aol2o`3Io`?o0>_o0ol0
oOl3o`3ol0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooc?lQ0?l6
o`l0o`Go00;o0ol05?l4o`0Vo`?o03So1?l0B_l3o`1Lo`Co06ko0ol0Ool4o`2Ao`?o0:?o0ol0]Ol4
o`37o`;o0=Wo0ol0jol3o`3mo`?o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooo
ooooool00oooooo<ob40o`Ko3`3o1Ol00_l3o`0Do`Co02Ko0ol0>?l4o`1:o`?o05co1?l0K_l3o`1o
o`Co097o0ol0Xol3o`2eo`Co0<Oo0_l0fOl3o`3[o`?o0?go0ol0oo05ooooo`7o00000Oooool1oooo
o`002_ooool00ol0003oooooooooo`03ooooolco8@3o1ol?0?l5o`02o`?o01Co0ol09_l4o`0ho`?o
04[o1?l0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl2o`3ol0Go
oooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooc?lQ0?l7o`l0o`Go00;o
0ol05?l3o`0Vo`Co03So0ol0B_l4o`1Lo`?o06ko1?l0Ool3o`2Ao`?o0:?o1?l0]Ol3o`37o`?o0=Wo
0ol0jol3o`3mo`;o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooo
ooo<ob40o`Oo3`3o1Ol00_l3o`0Do`?o02Ko1?l0>?l3o`1:o`Co05co0ol0K_l4o`1oo`?o097o0ol0
Xol4o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0_l0oo05ooooo`7o00000Oooool1ooooo`002_ooool0
0ol0003oooooooooo`03ooooolgo8@3o1_l?0?l5o`02o`?o01Co1?l09_l3o`0ho`Co04[o0ol0G?l4
o`1^o`?o07oo1?l0TOl3o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl2o`3ol0Gooooo0Ol00001
ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooocOlQ0?l7o`l0o`Go00;o0_l05?l4o`0V
o`?o03So1?l0B_l3o`1Lo`Co06ko0ol0Ool4o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3m
o`;o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo0_l00004ooooolgo8@3o1ol?0?l5o`02o`;o
01Co1?l09_l3o`0ho`Co04[o0ol0G?l4o`1^o`?o07oo1?l0TOl3o`2So`?o0;Go0ol0aol3o`3Io`?o
0>_o0ol0oOl2o`3ol0Cooooo0_l00002ooooo`002_ooool00ol0003oooooooooo`03ooooolgo8@3o
1ol?0?l5o`02o`;o01Co1?l09_l3o`0ho`Co04[o0ol0G?l4o`1^o`?o07oo1?l0TOl3o`2So`?o0;Go
0ol0aol3o`3Io`?o0>_o0ol0oOl2o`3ol0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oo
oooooooo00?ooooocOlQ0?l7o`l0o`Go00;o0_l05?l4o`0Vo`?o03So1?l0B_l3o`1Lo`Co06ko0ol0
Ool4o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`;o0?o`1Oooool1o`00007ooooo0Ooo
ool000[ooooo00?o0000ooooooooool00oooooo=ob40o`Oo3`3o1Ol00_l2o`0Do`Co02Ko0ol0>?l4
o`1:o`?o05co1?l0K_l3o`1oo`Co097o0ol0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0_l0oo05
ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooolgo8@3o2?l?0?l4o`02
o`;o01Co1?l09_l3o`0ho`Co04[o0ol0G?l4o`1^o`?o07oo1?l0TOl3o`2So`?o0;Go0ol0aol3o`3I
o`?o0>_o0ol0oOl2o`3ol0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?o
oooocOlQ0?l8o`l0o`Co00;o0_l05?l4o`0Vo`?o03So1?l0B_l3o`1Lo`Co06ko0ol0Ool4o`2Ao`?o
0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`;o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo
00?o0000ooooooooool00oooooo>ob40o`Oo3`3o1Ol00_l2o`0Do`?o02Ko1?l0>?l4o`1:o`?o05co
1?l0K_l3o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go00?o0?o`ooooooooool0
0oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooooo>ob40o`Oo3`3o1Ol0
0_l2o`0Do`?o02Ko1?l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0
fOl3o`3[o`?o0?go00?o0?o`ooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000
ooooooooool00oooooo>ob40o`Oo3`3o1Ol00_l2o`0Do`?o02Ko1?l0>?l4o`1:o`?o05co1?l0K_l3
o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go00?o0?o`ooooooooool00oooool1
o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooooo>ob40o`So3`3o1?l00_l2o`0D
o`?o02Ko1?l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[
o`?o0?go00?o0?o`ooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooooooo
ool00oooooo>ob40o`So3`3o1?l00_l2o`0Do`?o02Ko1?l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`?o
097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go00?o0?o`ooooooooool00oooool1o`00007o
oooo0Oooool000[ooooo00?o0000ooooooooool00oooooo>ob40o`So3`3o1?l00_l2o`0Do`?o02Ko
1?l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go
00?o0?o`ooooooooool00oooool1o`00007ooooo0Oooool00003ooooool0003o000000?o00001?oo
ool00ol0003oooooooooo`03ooooolko8@3o2?l?0?l4o`02o`;o01Co0ol09_l4o`0ho`Co04[o0ol0
G?l4o`1^o`?o07oo0ol0TOl4o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0oo3ooooooooo
o`03ooooo`7o00000Oooool1ooooo`000_ooool01?l0003oooooooooool00004ooooo`03o`000?oo
oooooooo00?ooooocOlQ0?l9o`l0o`Co00;o0_l05?l3o`0Vo`Co03So1?l0B_l3o`1Lo`Co06ko0ol0
Ool3o`2Ao`Co0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`03o`3ol?oooooooooo00?ooooo0Ol0
0001ooooo`7ooooo0003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooooo<
ob40o`Wo3`3o1Ol00_l2o`0Do`?o02Ko1?l0>?l4o`1:o`?o05co1?l0K_l3o`1oo`?o097o1?l0Xol3
o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go00?o0?o`ooooooooool00oooool1o`00007ooooo0Oooool0
00Cooooo00?o0000ooooooooool00oooool3o`0000?ooooobolQ0?l:o`l0o`Go00;o0_l05?l3o`0V
o`Co03So1?l0B_l3o`1Lo`Co06ko0ol0Ool3o`2Ao`Co0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3m
o`04o`3ol?ooooooooooooooo`?o00000_ooool00003ooooool0003ooooo00;ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`03oooool[o8@3o2_l?0?l5o`02o`?o01Co0ol09_l4o`0h
o`Co04[o0ol0G?l4o`1^o`?o07oo0ol0TOl4o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0
oo3oooooooooo`03ooooo`7o00000Oooool1ooooo`0000?oooooo`000?ooool00_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00?ooooobOlQ0?l;o`l0o`Go00;o0ol05?l4o`0Vo`?o
03So1?l0B_l3o`1Lo`Co06ko0ol0Ool3o`2Ao`Co0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`03
o`3ol?oooooooooo00?ooooo0Ol00001ooooo`7ooooo0002ooooo`?o00001Oooool00ol0003ooooo
ooooo`03ooooolSo8@3o2ol?0?l6o`02o`?o01Co1?l09_l3o`0ho`Co04[o0ol0G?l3o`1^o`Co07oo
0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0oo3oooooooooo`03ooooo`7o0000
0Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooolOo8@3o3?l?0?l6o`02o`?o01Co1?l0
9_l3o`0ho`Co04[o0ol0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0
oOl00ol0oo3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03
ooooolGo8@3o3Ol?0?l7o`02o`?o01Co1?l09_l3o`0ho`Co04[o0ol0G?l3o`1^o`Co07oo0ol0TOl3
o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0oo3oooooooooo`03ooooo`7o00000Oooool1
ooooo`002_ooool00ol0003oooooooooo`03oooool?o8@3o3ol?0?l6o`02o`Co01Co1?l09_l3o`0h
o`Co04[o0ol0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0
oo3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooool;o
8@3o3_l?0?l8o`02o`Co01Co1?l09_l3o`0ho`Co04[o0ol0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co
0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0oo3oooooooooo`03ooooo`7o00000Oooool1ooooo`00
2_ooool00ol0003oooooooooo`03oooool3o8@3o3_l?0?l9o`02o`Co01Co1Ol09_l3o`0ho`Co04[o
0ol0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0oo3ooooo
ooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooookgo8@3o3ol?
0?l:o`02o`Co01Co1_l09_l3o`0ho`Co04[o0ol0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0
aol3o`3Io`?o0>_o0ol0oOl00ol0oo3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool0
0ol0003oooooooooo`03oooookWo8@3o4?l?0?l<o`02o`Co01Co1_l09_l4o`0ho`Co04[o0ol0G?l3
o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0oo3oooooooooo`03
ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooookGo8@3o4_l?0?l=o`02
o`Co01Co1ol09_l4o`0ho`Co04[o0ol0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3I
o`?o0>_o0ol0oOl00ol0oo3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003o
ooooooooo`03oooook;o8@3o4ol?0?l>o`02o`Co01Co2?l09_l4o`0ho`Co04[o0ol0G?l3o`1^o`Co
07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl00ol0oo3oooooooooo`03ooooo`7o
00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooojoo8@3o4ol?0?l@o`02o`Co01Co
2?l09_l5o`0ho`Co04[o0ol0G?l3o`1^o`Co07oo0ol0TOl3o`2So`Co0;Go0ol0aol3o`3Io`?o0>_o
0ol0oOl00ol0oo3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003ooooooooo
o`03ooooojgo8@3o4_l?0?l@o`02o`Ko01Co2Ol09_l4o`0ho`Co04[o0ol0G?l4o`1^o`?o07oo0ol0
TOl4o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl2o`3ol0Gooooo0Ol00001ooooo`7ooooo000:
ooooo`;o00001?oooonZob40oa;o3`3o3ol00_l9o`0Do`Wo02Ko1Ol0>?l4o`1:o`?o05co1?l0K_l3
o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0_l0oo04ooooo`;o00000_ooool0
00[ooooo00?o0000ooooooooool00ooooonXob40oa7o3`3o3ol00_l;o`0Do`[o02Ko1Ol0>?l4o`1:
o`?o05co1?l0K_l3o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0_l0oo05oooo
o`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooojKo8@3o4?l?0?l>o`02o`ko
01Co2ol09_l5o`0ho`Co04[o0ol0G?l4o`1^o`?o07oo0ol0TOl4o`2So`?o0;Go0ol0aol3o`3Io`?o
0>_o0ol0oOl2o`3ol0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo
Y?lQ0?l?o`l0o`go00;o3_l05?l=o`0Vo`Oo03So1?l0B_l3o`1Lo`Co06ko0ol0Ool3o`2Ao`Co0:?o
0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`;o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo00?o
0000ooooooooool00ooooonRob40o`oo3`3o3?l00_l=o`0Do`ko02Ko2Ol0>?l4o`1:o`Co05co1?l0
K_l3o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0_l0oo05ooooo`7o00000Ooo
ool1ooooo`002_ooool00ol0003oooooooooo`03oooooj3o8@3o3ol?0?l=o`02o`_o01Co3_l09_l;
o`0ho`Co04[o1Ol0G?l4o`1^o`?o07oo0ol0TOl4o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl2
o`3ol0Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooW_lQ0?l@o`l0
o`co00;o2ol05?l=o`0Vo`go03So1?l0B_l6o`1Lo`Co06ko0ol0Ool3o`2Ao`Co0:?o0ol0]Ol3o`37
o`?o0=Wo0ol0jol3o`3mo`;o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooooooo
ool00ooooonMob40o`oo3`3o3?l00_l;o`0Do`go02Ko3_l0>?l4o`1:o`Ko05co1?l0K_l4o`1oo`?o
097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0_l0oo05ooooo`7o00000Oooool1ooooo`00
2_ooool00ol0003oooooooooo`03oooooi_o8@3o3ol?0?l;o`02o`_o01Co3_l09_l?o`0ho`Co04[o
1ol0G?l4o`1^o`Co07oo0ol0TOl3o`2So`?o0;Go1?l0aol2o`3Io`?o0>_o0ol0oOl3o`3ol0Gooooo
0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooVOlQ0?l@o`l0o`[o00;o2ol0
5?l=o`0Vo`oo03So1_l0B_l8o`1Lo`Co06ko1?l0Ool3o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0
jol3o`3mo`?o0?o`1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooonG
ob40oa3o3`3o2_l00_l;o`0Do`go02Ko3Ol0>?l9o`1:o`So05co1?l0K_l4o`1oo`?o097o1?l0Xol3
o`2eo`?o0<Oo0ol0fOl3o`3[o`?o0?go0ol0oo05ooooo`7o00000Oooool1ooooo`002_ooool00ol0
003oooooooooo`03oooooiGo8@3o4Ol?0?l9o`02o`_o01Co3Ol09_l<o`0ho`_o04[o2?l0G?l5o`1^
o`Co07oo0ol0TOl4o`2So`?o0;Go0ol0aol3o`3Io`?o0>_o0ol0oOl3o`3ol0Gooooo0Ol00001oooo
o`7ooooo000:ooooo`03o`000?oooooooooo00?oooooU?lQ0?l?o`l0o`Wo00;o3?l05?l=o`0Vo`_o
03So3Ol0B_l8o`1Lo`Ko06ko1?l0Ool3o`2Ao`Co0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o
0?o`1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooonBob40o`ko3`3o
2_l00_l;o`0Do`go02Ko2ol0>?l=o`1:o`Wo05co2?l0K_l4o`1oo`?o097o0ol0Xol3o`2eo`Co0<Oo
0_l0fOl3o`3[o`?o0?go1?l0oo05ooooo`7o00000Oooool1ooooo`002_ooool2o`0000CoooooT?lQ
0?l=o`l0o`[o00;o3?l05?l<o`0Vo`_o03So3Ol0B_l;o`1Lo`So06ko1Ol0Ool3o`2Ao`?o0:?o0ol0
]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`Co0?o`1?ooool2o`0000;ooooo000:ooooo`03o`000?oooooo
oooo00?oooooSolQ0?l<o`l0o`_o00;o2ol05?l;o`0Vo`co03So3?l0B_l<o`1Lo`[o06ko1Ol0Ool3
o`2Ao`?o0:?o0ol0]Ol3o`37o`?o0=Wo0ol0jol3o`3mo`?o0?o`00?o0?oNooooooooool00oooool1
o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooon>ob40o`_o3`3o2ol00_l;o`0D
o`_o02Ko3Ol0>?l;o`1:o`_o05co3?l0K_l5o`1oo`?o097o1?l0Xol3o`2eo`?o0<Oo0ol0fOl3o`3[
o`?o0?go0ol0oo000ol0omkoooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003o
ooooooooo`03ooooohco8@3o3?l?0?l:o`02o`_o01Co2ol09_l=o`0ho`_o04[o2ol0G?l=o`1^o`Go
07oo0ol0TOl5o`2So`?o0;Go0ol0aol3o`3Io`;o0>_o0ol0oOl3o`3ol0;o0?oN1Oooool1o`00007o
oooo0Oooool000[ooooo00?o0000ooooooooool00ooooon:ob40o`go3`3o2Ol00_l;o`0Do`_o02Ko
3Ol0>?l;o`1:o`_o05co3Ol0K_l6o`1oo`?o097o1Ol0Xol4o`2eo`?o0<Oo0ol0fOl2o`3[o`?o0?go
0ol0oo02o`3ogPGooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooROlQ
0?l=o`l0o`Wo00;o2ol05?l;o`0Vo`_o03So2ol0B_l;o`1Lo`go06ko2?l0Ool3o`2Ao`Ko0:?o1?l0
]Ol3o`37o`?o0=Wo0_l0jol2o`3mo`?o0?o`0ol0omh5ooooo`7o00000Oooool1ooooo`002_ooool0
0ol0003oooooooooo`03ooooohOo8@3o3Ol?0?l9o`02o`_o01Co2ol09_l;o`0ho`_o04[o2ol0G?l<
o`1^o`[o07oo0ol0TOl7o`2So`Co0;Go0ol0aol2o`3Io`;o0>_o0ol0oOl3o`3ol0?o0?oN1Oooool1
o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooon5ob40o`ko3`3o2?l00_l;o`0D
o`_o02Ko2ol0>?l;o`1:o`_o05co2ol0K_l<o`1oo`?o097o1ol0Xol4o`2eo`Co0<Oo0_l0fOl2o`3[
o`;o0?go0ol0oo04o`3ogPGooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?o
ooooPolQ0?l?o`l0o`Oo00;o2ol05?l;o`0Vo`_o03So2ol0B_l;o`1Lo`_o06ko3Ol0Ool3o`2Ao`So
0:?o1?l0]Ol4o`37o`;o0=Wo0_l0jol2o`3mo`?o0?o`1?l0omh5ooooo`7o00000Oooool1ooooo`00
2_ooool00ol0003oooooooooo`03oooooh;o8@3o3ol?0?l7o`02o`[o01Co2ol09_l;o`0ho`_o04[o
2_l0G?l;o`1^o`go07oo1Ol0TOl9o`2So`Co0;Go1?l0aol2o`3Io`04o`3[ool0oOoo0?goo`3mo`?o
0?o`1?l0omh5ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooooh7o8@3o
3ol?0?l6o`02o`_o01Co2_l09_l;o`0ho`[o04[o2ol0G?l;o`1^o`_o07oo2?l0TOl:o`2So`Co0;Go
1?l0aol2o`3Io`03o`3[ool0oOoo0?go00?o0?o`1Ol0omh5ooooo`7o00000Oooool1ooooo`002_oo
ool00ol0003oooooooooo`03oooooh3o8@3o3?l?0?l9o`02o`[o01Co2_l09_l;o`0ho`[o04[o2_l0
G?l;o`1^o`_o07oo2_l0TOl:o`2So`Go0;Go1?l0aol2o`3Io`03o`3[ool0oOoo0?go00?o0?o`1Ol0
omh5ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooogoo8@3o2_l?0?l:
o`02o`[o01Co2_l09_l;o`0ho`[o04[o2ol0G?l;o`1^o`Wo07oo2_l0TOl;o`2So`Oo0;Go1?l0aol0
1?l0fOoo0>_oo`3mool0oOl3o`3ol0Ko0?oN1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000
ooooooooool00ooooomnob40o`[o3`3o2_l00_l:o`0Do`[o02Ko2ol0>?l9o`1:o`_o05co2ol0K_l9
o`1oo`[o097o2_l0Xol:o`2eo`?o0<Oo0_l0fOl00ol0jooo0?goo`3mo`03o`3ol0Ko0?oN1Oooool1
o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooommob40o`[o3`3o2_l00_l:o`0D
o`Wo02Ko2ol0>?l:o`1:o`[o05co2ol0K_l9o`1oo`[o097o2_l0Xol;o`2eo`?o0<Oo0_l0fOl2o`3[
o`;o0?go0ol0oo06o`3ogPGooooo0Ol00001ooooo`7ooooo000:ooooo`;o00001?oooomlob40o`[o
3`3o2_l00_l9o`0Do`[o02Ko2ol0>?l9o`1:o`[o05co2_l0K_l;o`1oo`Wo097o2Ol0Xol=o`2eo`?o
0<Oo0_l0fOl3o`3[o`;o0?go0ol0oo06o`3ogPCooooo0_l00002ooooo`002_ooool00ol0003ooooo
ooooo`03ooooog_o8@3o2_l?0?l9o`02o`[o01Co2_l09_l:o`0ho`Wo04[o2ol0G?l9o`1^o`_o07oo
2Ol0TOl9o`2So`ko0;Go0ol0aol3o`3Io`?o0>_o0_l0oOl3o`3ol0Ko0?oN1Oooool1o`00007ooooo
0Oooool000[ooooo00?o0000ooooooooool00ooooomjob40o`Wo3`3o2_l00_l:o`0Do`Wo02Ko2_l0
>?l:o`1:o`[o05co2Ol0K_l;o`1oo`Wo097o2Ol0Xol?o`2eo`?o0<Oo0ol0fOl4o`3[o`?o0?go0ol0
oo04o`3ogP03o`3oc?oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooo
oooo00?oooooN?lQ0?l:o`l0o`Wo00;o2_l05?l:o`0Vo`[o03So2Ol0B_l:o`1Lo`Wo06ko2ol0Ool9
o`2Ao`Wo0:?o3_l0]Ol5o`37o`?o0=Wo1Ol0jol3o`3mo`?o0?o`1?l0omh00ol0olcoooooooooo`03
ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooogOo8@3o2_l?0?l9o`02
o`[o01Co2Ol09_l:o`0ho`[o04[o2Ol0G?l9o`1^o`_o07oo2?l0TOl;o`2So`_o0;Go2?l0aol4o`3I
o`Go0>_o0ol0oOl3o`3ol0Co0?oN00?o0?o<ooooooooool00oooool1o`00007ooooo0Oooool000[o
oooo00?o0000ooooooooool00ooooomfob40o`Wo3`3o2_l00_l9o`0Do`[o02Ko2_l0>?l9o`1:o`Wo
05co2Ol0K_l:o`1oo`Wo097o2ol0Xol:o`2eo`[o0<Oo1?l0fOl6o`3[o`?o0?go0ol0oo04o`3ogP03
o`3oc?oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo
MOlQ0?l9o`l0o`Wo00;o2_l05?l:o`0Vo`Wo03So2Ol0B_l9o`1Lo`[o06ko2Ol0Ool9o`2Ao`_o0:?o
2Ol0]Ol:o`37o`Oo0=Wo1_l0jol3o`3mo`?o0?o`1?l0omh00ol0olcoooooooooo`03ooooo`7o0000
0Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooogCo8@3o2Ol?0?l9o`02o`[o01Co2Ol0
9_l9o`0ho`Wo04[o2Ol0G?l:o`1^o`Wo07oo2Ol0TOl:o`2So`Wo0;Go2_l0aol9o`3Io`Oo0>_o0ol0
oOl3o`3ol0?o0?oN0_l0ol`5ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03
ooooog?o8@3o2Ol?0?l9o`02o`So01Co2Ol09_l:o`0ho`Wo04[o2Ol0G?l:o`1^o`Wo07oo2Ol0TOl9
o`2So`[o0;Go2Ol0aol:o`3Io`Oo0>_o1Ol0oOl3o`3ol0?o0?oN0_l0ol`5ooooo`7o00000Oooool1
ooooo`002_ooool00ol0003oooooooooo`03ooooog;o8@3o2Ol?0?l8o`02o`Wo01Co2Ol09_l:o`0h
o`Wo04[o2Ol0G?l9o`1^o`[o07oo2?l0TOl9o`2So`[o0;Go2Ol0aol9o`3Io`So0>_o1ol0oOl3o`3o
l0?o0?oN0_l0ol`5ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooog7o
8@3o2Ol?0?l8o`02o`Wo01Co2Ol09_l9o`0ho`[o04[o2?l0G?l:o`1^o`Wo07oo2?l0TOl:o`2So`Wo
0;Go2Ol0aol9o`3Io`Wo0>_o1ol0oOl3o`3ol0?o0?oN0ol0ol`5ooooo`7o00000Oooool1ooooo`00
2_ooool00ol0003oooooooooo`03ooooog3o8@3o2?l?0?l9o`02o`Wo01Co2Ol09_l9o`0ho`[o04[o
2?l0G?l9o`1^o`Wo07oo2Ol0TOl9o`2So`Wo0;Go2Ol0aol9o`3Io`Wo0>_o2Ol0oOl2o`3ol0?o0?oN
1?l0ol`5ooooo`7o00000Oooool1ooooo`000oooool3o`0000Cooooo00?o0000ooooooooool00ooo
oom_ob40o`So3`3o2Ol00_l9o`0Do`Wo02Ko2Ol0>?l9o`1:o`Wo05co2?l0K_l:o`1oo`So097o2Ol0
Xol9o`2eo`Wo0<Oo2_l0fOl8o`3[o`[o0?go0ol0oo03o`3ogP?o0?o<00?o0?njooooooooool00ooo
ool1o`00007ooooo0Oooool000Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03
ooooofko8@3o2?l?0?l9o`02o`Wo01Co2Ol09_l8o`0ho`[o04[o2?l0G?l9o`1^o`Wo07oo2?l0TOl:
o`2So`So0;Go2_l0aol9o`3Io`Wo0>_o2ol0oOl2o`3ol0?o0?oN1?l0ol`00ol0ok[oooooooooo`03
ooooo`7o00000Oooool1ooooo`0000?oooooo`000?l000000ol00004ooooo`03o`000?oooooooooo
00?oooooKOlQ0?l8o`l0o`Wo00;o2Ol05?l9o`0Vo`So03So2Ol0B_l9o`1Lo`So06ko2_l0Ool7o`2A
o`[o0:?o2Ol0]Ol9o`37o`Wo0=Wo2Ol0jol;o`3mo`Co0?o`0_l0omh4o`3oc0;o0?nj1Oooool1o`00
007ooooo0Oooool00005ooooool0003oooooooooool000001Oooool3o`0000?oooooK?lQ0?l8o`l0
o`Wo00;o2Ol05?l8o`0Vo`Wo03So2Ol0B_l8o`1Lo`Wo06ko2Ol0Ool8o`2Ao`Wo0:?o2Ol0]Ol9o`37
o`Wo0=Wo2Ol0jol:o`3mo`Ko0?o`0ol0omh4o`3oc0;o0?nj0oooool3o`0000;ooooo0002ooooo`03
o`000?oooooo000000Gooooo00?o0000ooooooooool00ooooom[ob40o`So3`3o2Ol00_l9o`0Do`So
02Ko2?l0>?l:o`1:o`So05co2?l0K_l9o`1oo`So097o2_l0Xol8o`2eo`Wo0<Oo2Ol0fOl8o`3[o`[o
0?go2?l0oo03o`3ogPGo0?o<0_l0okX5ooooo`7o00000Oooool1ooooo`000oooool2o`0000Gooooo
00?o0000ooooooooool00ooooomZob40o`So3`3o2Ol00_l8o`0Do`Wo02Ko2?l0>?l9o`1:o`Wo05co
1ol0K_l:o`1oo`Oo097o2_l0Xol8o`2eo`Wo0<Oo2?l0fOl9o`3[o`Wo0?go2ol0oo03o`3ogPCo0?o<
0ol0okX5ooooo`7o00000Oooool1ooooo`001?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?oooooJOlQ0?l8o`l0o`Wo00;o2?l05?l9o`0Vo`So03So2Ol0B_l8o`1Lo`So06ko2Ol0
Ool8o`2Ao`[o0:?o1ol0]Ol9o`37o`So0=Wo2Ol0jol9o`3mo`[o0?o`1Ol0omh5o`3oc0?o0?nj1Ooo
ool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooomXob40o`So3`3o2Ol00_l8
o`0Do`Wo02Ko2?l0>?l9o`1:o`Oo05co2?l0K_l9o`1oo`Wo097o2?l0Xol8o`2eo`Wo0<Oo2Ol0fOl8
o`3[o`So0?go2Ol0oo08o`3ogPCo0?o<1?l0okX00ol0ojSoooooooooo`03ooooo`7o00000Oooool1
ooooo`002_ooool00ol0003oooooooooo`03ooooofSo8@3o2?l?0?l9o`02o`So01Co2?l09_l8o`0h
o`So04[o2?l0G?l8o`1^o`Wo07oo2?l0TOl9o`2So`So0;Go2?l0aol:o`3Io`Oo0>_o2Ol0oOl8o`3o
l0Wo0?oN1?l0ol`4o`3o^P;o0?nX1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooooooo
ool00ooooomWob40o`So3`3o2Ol00_l8o`0Do`So02Ko2?l0>?l8o`1:o`So05co2?l0K_l9o`1oo`So
097o2?l0Xol8o`2eo`Wo0<Oo2Ol0fOl7o`3[o`Wo0?go2?l0oo09o`3ogPGo0?o<1?l0okX3o`3oZ0Go
oooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooI_lQ0?l8o`l0o`Wo00;o
2?l05?l8o`0Vo`Oo03So2Ol0B_l8o`1Lo`So06ko2?l0Ool9o`2Ao`So0:?o2?l0]Ol8o`37o`Wo0=Wo
2?l0jol8o`3mo`So0?o`2Ol0omh6o`3oc0Co0?nj1?l0ojP5ooooo`7o00000Oooool1ooooo`002_oo
ool00ol0003oooooooooo`03ooooofGo8@3o2Ol?0?l8o`02o`So01Co2?l09_l7o`0ho`Wo04[o2?l0
G?l8o`1^o`So07oo2?l0TOl9o`2So`So0;Go2?l0aol8o`3Io`So0>_o2Ol0oOl7o`3ol0So0?oN2?l0
ol`4o`3o^PGo0?nX1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooomU
ob40o`So3`3o2?l00_l8o`0Do`So02Ko1ol0>?l8o`1:o`Wo05co1ol0K_l9o`1oo`So097o2?l0Xol8
o`2eo`So0<Oo2Ol0fOl7o`3[o`Wo0?go1ol0oo08o`3ogPWo0?o<1?l0okX6o`3oZ0Gooooo0Ol00001
ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooI?lQ0?l8o`l0o`So00;o2?l05?l7o`0V
o`So03So2?l0B_l9o`1Lo`Oo06ko2?l0Ool8o`2Ao`Wo0:?o1ol0]Ol8o`37o`Wo0=Wo1ol0jol9o`3m
o`So0?o`1ol0omh9o`3oc0Go0?nj1ol0ojP5ooooo`7o00000Oooool1ooooo`002_ooool00ol0003o
ooooooooo`03ooooof?o8@3o2?l?0?l8o`02o`So01Co1ol09_l8o`0ho`So04[o2Ol0G?l7o`1^o`So
07oo2?l0TOl8o`2So`So0;Go2?l0aol8o`3Io`Oo0>_o2Ol0oOl8o`3ol0Oo0?oN2Ol0ol`6o`3o^POo
0?nX00?o0?nGooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool0
0ooooomRob40o`So3`3o2?l00_l8o`0Do`Oo02Ko2?l0>?l8o`1:o`So05co1ol0K_l8o`1oo`Wo097o
1ol0Xol8o`2eo`So0<Oo2?l0fOl7o`3[o`[o0?go1ol0oo07o`3ogPSo0?o<2?l0okX7o`3oZ0;o0?nG
1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooomQob40o`So3`3o2?l0
0_l7o`0Do`So02Ko2?l0>?l8o`1:o`Oo05co2?l0K_l8o`1oo`So097o2?l0Xol7o`2eo`Wo0<Oo1ol0
fOl8o`3[o`Wo0?go1ol0oo08o`3ogPOo0?o<2Ol0okX6o`3oZ0Co0?nG1Oooool1o`00007ooooo0Ooo
ool000[ooooo0_l00004ooooof3o8@3o2?l?0?l8o`02o`Oo01Co2?l09_l8o`0ho`So04[o1ol0G?l8
o`1^o`So07oo2?l0TOl7o`2So`So0;Go2?l0aol8o`3Io`Oo0>_o2Ol0oOl7o`3ol0So0?oN1ol0ol`9
o`3o^POo0?nX1Ol0oiL4ooooo`;o00000_ooool000[ooooo00?o0000ooooooooool00ooooomOob40
o`So3`3o2?l00_l7o`0Do`So02Ko2?l0>?l8o`1:o`Oo05co2?l0K_l7o`1oo`So097o2?l0Xol8o`2e
o`Oo0<Oo2?l0fOl8o`3[o`Oo0?go2?l0oo08o`3ogPSo0?o<1ol0okX8o`3oZ0Oo0?nG1Oooool1o`00
007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooomOob40o`So3`3o1ol00_l8o`0Do`So
02Ko1ol0>?l8o`1:o`Oo05co2?l0K_l7o`1oo`So097o2?l0Xol7o`2eo`So0<Oo2?l0fOl8o`3[o`Oo
0?go1ol0oo08o`3ogPWo0?o<1ol0okX7o`3oZ0So0?nG00?o0?n5ooooooooool00oooool1o`00007o
oooo0Oooool000[ooooo00?o0000ooooooooool00ooooomNob40o`So3`3o2?l00_l7o`0Do`So02Ko
1ol0>?l8o`1:o`Oo05co2?l0K_l7o`1oo`So097o2?l0Xol7o`2eo`So0<Oo1ol0fOl8o`3[o`Oo0?go
2?l0oo07o`3ogPWo0?o<1ol0okX8o`3oZ0Oo0?nG0ol0ohD5ooooo`7o00000Oooool1ooooo`002_oo
ool00ol0003oooooooooo`03oooooego8@3o2?l?0?l8o`02o`Oo01Co2?l09_l8o`0ho`Oo04[o1ol0
G?l7o`1^o`So07oo2?l0TOl8o`2So`Oo0;Go1ol0aol8o`3Io`So0>_o1ol0oOl7o`3ol0So0?oN2?l0
ol`7o`3o^PSo0?nX1ol0oiL5o`3oQ@Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooo
oooo00?oooooGOlQ0?l8o`l0o`Oo00;o1ol05?l8o`0Vo`So03So1ol0B_l7o`1Lo`Oo06ko2?l0Ool8
o`2Ao`Oo0:?o2?l0]Ol7o`37o`Oo0=Wo2?l0jol8o`3mo`Ko0?o`2?l0omh9o`3oc0Oo0?nj1ol0ojP8
o`3oU`Ko0?n51Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooomLob40
o`So3`3o1ol00_l8o`0Do`Oo02Ko2?l0>?l7o`1:o`Oo05co1ol0K_l8o`1oo`So097o1ol0Xol7o`2e
o`So0<Oo1ol0fOl7o`3[o`So0?go1ol0oo07o`3ogPWo0?o<1ol0okX7o`3oZ0So0?nG2?l0ohD5oooo
o`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooooe_o8@3o2?l?0?l7o`02o`So
01Co1ol09_l8o`0ho`Oo04[o1ol0G?l7o`1^o`So07oo2?l0TOl6o`2So`So0;Go2?l0aol6o`3Io`So
0>_o2?l0oOl6o`3ol0So0?oN2?l0ol`7o`3o^PSo0?nX1ol0oiL9o`3oQ@03o`3oLooooooooooo00?o
oooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?oooooFolQ0?l8o`l0o`Oo00;o
1ol05?l7o`0Vo`So03So1ol0B_l7o`1Lo`Oo06ko2?l0Ool7o`2Ao`Oo0:?o2?l0]Ol7o`37o`Oo0=Wo
1ol0jol8o`3mo`Ko0?o`2?l0omh8o`3oc0Oo0?nj2?l0ojP7o`3oU`Wo0?n50ol0og<5ooooo`7o0000
0Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooo`03o`l0oolQ0?oo8@3o05Oo8@3o2?l?
0?l7o`02o`So01Co1_l09_l8o`0ho`Oo04[o1ol0G?l7o`1^o`So07oo1ol0TOl7o`2So`So0;Go1ol0
aol7o`3Io`Oo0>_o1ol0oOl7o`3ol0So0?oN1ol0ol`8o`3o^POo0?nX1ol0oiL8o`3oQ@Ko0?mc1Ooo
ool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool2o`l0oeSo8@3o2?l?0?l6
o`02o`So01Co1_l09_l8o`0ho`Oo04[o1ol0G?l7o`1^o`So07oo1_l0TOl7o`2So`Wo0;Go1_l0aol7
o`3Io`Oo0>_o2?l0oOl6o`3ol0So0?oN2?l0ol`7o`3o^POo0?nX1ol0oiL8o`3oQ@Oo0?mc00?o0?mQ
ooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool3o`l0
oeKo8@3o2Ol?0?l5o`02o`So01Co1_l09_l8o`0ho`Oo04[o1ol0G?l7o`1^o`Oo07oo1ol0TOl7o`2S
o`So0;Go1ol0aol7o`3Io`Oo0>_o1ol0oOl7o`3ol0Oo0?oN2?l0ol`7o`3o^POo0?nX1ol0oiL8o`3o
Q@Ko0?mc1?l0of45ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooo`Go
3`3oDolQ0?l9o`l0o`Go00;o1ol05?l7o`0Vo`So03So1ol0B_l7o`1Lo`Oo06ko1ol0Ool7o`2Ao`Oo
0:?o1ol0]Ol7o`37o`So0=Wo1_l0jol7o`3mo`So0?o`1_l0omh8o`3oc0Oo0?nj1ol0ojP7o`3oU`Oo
0?n51ol0og<6o`3oH@Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo
1_l?0?mBob40o`Wo3`3o1Ol00_l7o`0Do`Oo02Ko2?l0>?l7o`1:o`Oo05co1ol0K_l7o`1oo`Ko097o
2?l0Xol6o`2eo`Oo0<Oo1ol0fOl7o`3[o`Oo0?go2?l0oo06o`3ogPSo0?o<1ol0okX7o`3oZ0Oo0?nG
1_l0ohD8o`3oL`Oo0?mQ1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooo
ool7o`l0oe7o8@3o2?l?0?l5o`02o`Oo01Co1ol09_l8o`0ho`Oo04[o1ol0G?l7o`1^o`Oo07oo1_l0
TOl7o`2So`Oo0;Go1ol0aol7o`3Io`Oo0>_o1ol0oOl8o`3ol0Ko0?oN2?l0ol`6o`3o^POo0?nX1ol0
oiL7o`3oQ@Oo0?mc2?l0of400ol0odooooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool2
o`0000Cooooo2Ol?0?m>ob40o`So3`3o1Ol00_l7o`0Do`Oo02Ko2?l0>?l7o`1:o`Oo05co1ol0K_l7
o`1oo`Ko097o1ol0Xol7o`2eo`Oo0<Oo1ol0fOl7o`3[o`Ko0?go2Ol0oo06o`3ogPOo0?o<1_l0okX8
o`3oZ0Oo0?nG1_l0ohD8o`3oL`Oo0?mQ0ol0odl4ooooo`;o00000_ooool000[ooooo00?o0000oooo
ooooool00oooool2o`02o`So3`3oC?lQ0?l8o`l0o`Ko00;o1_l05?l8o`0Vo`Oo03So1ol0B_l7o`1L
o`Oo06ko1ol0Ool6o`2Ao`Oo0:?o1ol0]Ol6o`37o`So0=Wo1ol0jol6o`3mo`So0?o`1ol0omh7o`3o
c0Ko0?nj2?l0ojP6o`3oU`Ko0?n52?l0og<7o`3oH@Go0?m?1Oooool1o`00007ooooo0Oooool000[o
oooo00?o0000ooooooooool00oooool3o`02o`So3`3oBolQ0?l7o`l0o`Ko00;o1ol05?l7o`0Vo`So
03So1_l0B_l7o`1Lo`Oo06ko1ol0Ool6o`2Ao`Oo0:?o1ol0]Ol6o`37o`Oo0=Wo2?l0jol6o`3mo`So
0?o`1ol0omh6o`3oc0Ko0?nj2?l0ojP6o`3oU`Oo0?n52?l0og<7o`3oH@Ko0?m?1Oooool1o`00007o
oooo0Oooool000[ooooo00?o0000ooooooooool00oooool4o`02o`So3`3oBOlQ0?l7o`l0o`Oo00;o
1_l05?l7o`0Vo`So03So1_l0B_l7o`1Lo`Oo06ko1ol0Ool6o`2Ao`Oo0:?o1ol0]Ol6o`37o`Oo0=Wo
2?l0jol6o`3mo`Oo0?o`1ol0omh6o`3oc0Oo0?nj1ol0ojP7o`3oU`Ko0?n52?l0og<7o`3oH@Oo0?m?
00?o0?lmooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooo
ool5o`02o`So3`3oAolQ0?l8o`l0o`Ko00;o1_l05?l8o`0Vo`Oo03So1_l0B_l7o`1Lo`Oo06ko1ol0
Ool6o`2Ao`Oo0:?o1ol0]Ol6o`37o`Oo0=Wo1ol0jol6o`3mo`So0?o`1ol0omh6o`3oc0Ko0?nj2?l0
ojP6o`3oU`Oo0?n51ol0og<7o`3oH@Oo0?m?0ol0ocd5ooooo`7o00000Oooool1ooooo`002_ooool0
0ol0003oooooooooo`03ooooo`Ko00;o2?l?0?m5ob40o`So3`3o1_l00_l7o`0Do`Oo02Ko1ol0>?l6
o`1:o`Oo05co1ol0K_l7o`1oo`Ko097o1ol0Xol6o`2eo`Oo0<Oo1ol0fOl7o`3[o`Ko0?go2?l0oo06
o`3ogPKo0?o<1ol0okX7o`3oZ0Oo0?nG1_l0ohD8o`3oL`Ko0?mQ1ol0odl5o`3o?@Gooooo0Ol00001
ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo00?o01Coo`02ool00_l01?l00_l8o`l0
odCo8@3o1ol?0?l7o`02o`Ko01Co1ol09_l7o`0ho`Ko04[o1ol0G?l7o`1^o`Oo07oo1_l0TOl7o`2S
o`Ko0;Go1ol0aol7o`3Io`Ko0>_o1ol0oOl7o`3ol0Ko0?oN1ol0ol`6o`3o^POo0?nX1ol0oiL6o`3o
Q@So0?mc1_l0of47o`3oC`Ko0?lm00?o0?l[ooooooooool00oooool1o`00007ooooo0Oooool000[o
oooo00?o0000ooooooooool00oooool2o`0Do`Ko00;o2?l?0?m2ob40o`Oo3`3o1ol00_l6o`0Do`Oo
02Ko1ol0>?l6o`1:o`Oo05co1ol0K_l6o`1oo`Oo097o1ol0Xol6o`2eo`Oo0<Oo1_l0fOl7o`3[o`Oo
0?go1_l0oo07o`3ogPOo0?o<1_l0okX7o`3oZ0Oo0?nG1_l0ohD8o`3oL`Go0?mQ1ol0odl7o`3o?@;o
0?l[1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool4o`0Do`Ko00;o
2?l?0?loob40o`Oo3`3o1ol00_l6o`0Do`Oo02Ko1ol0>?l6o`1:o`Oo05co1ol0K_l6o`1oo`Oo097o
1ol0Xol6o`2eo`Oo0<Oo1_l0fOl7o`3[o`Oo0?go1_l0oo07o`3ogPKo0?o<1_l0okX8o`3oZ0Ko0?nG
1ol0ohD6o`3oL`Ko0?mQ2?l0odl6o`3o?@Co0?l[1Oooool1o`00007ooooo0Oooool000[ooooo00?o
0000ooooooooool00oooool5o`0Do`Ko00;o2?l?0?lnob40o`Oo3`3o1ol00_l6o`0Do`Oo02Ko1ol0
>?l6o`1:o`Oo05co1ol0K_l6o`1oo`Oo097o1_l0Xol7o`2eo`Ko0<Oo1_l0fOl7o`3[o`Ko0?go1ol0
oo07o`3ogPKo0?o<1_l0okX7o`3oZ0Oo0?nG1ol0ohD6o`3oL`Ko0?mQ1ol0odl7o`3o?@Go0?l[1Ooo
ool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool6o`0Do`Oo00;o2?l?0?lk
ob40o`So3`3o1_l00_l6o`0Do`Oo02Ko1ol0>?l7o`1:o`Ko05co1ol0K_l6o`1oo`Oo097o1_l0Xol7
o`2eo`Ko0<Oo1_l0fOl7o`3[o`Ko0?go1ol0oo07o`3ogPKo0?o<1_l0okX7o`3oZ0Oo0?nG1ol0ohD5
o`3oL`Oo0?mQ1ol0odl6o`3o?@Ko0?l[00?o0?lIooooooooool00oooool1o`00007ooooo0Oooool0
00[ooooo00?o0000ooooooooool00oooool2o`0Vo`Go01Co1ol00_l8o`l0oc[o8@3o2?l?0?l5o`02
o`Oo01Co1_l09_l7o`0ho`Oo04[o1_l0G?l7o`1^o`Ko07oo1ol0TOl6o`2So`Oo0;Go1_l0aol6o`3I
o`Oo0>_o1_l0oOl7o`3ol0Ko0?oN1ol0ol`6o`3o^POo0?nX1_l0oiL7o`3oQ@Ko0?mc1ol0of46o`3o
C`Ko0?lm1ol0ob/2o`3o6@Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?o
oooo0ol09_l5o`0Do`Oo00;o2Ol?0?lhob40o`Oo3`3o1_l00_l7o`0Do`Ko02Ko1_l0>?l7o`1:o`Oo
05co1_l0K_l6o`1oo`Oo097o1_l0Xol7o`2eo`Ko0<Oo1_l0fOl7o`3[o`Ko0?go1ol0oo06o`3ogPKo
0?o<1_l0okX7o`3oZ0Oo0?nG1ol0ohD6o`3oL`Ko0?mQ1_l0odl7o`3o?@Ko0?l[1?l0oaT5ooooo`7o
00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooo`Co02Ko1Ol05?l8o`02o`So3`3o
=_lQ0?l8o`l0o`Go00;o1ol05?l6o`0Vo`Oo03So1_l0B_l7o`1Lo`Oo06ko1Ol0Ool7o`2Ao`Ko0:?o
1ol0]Ol6o`37o`Ko0=Wo1_l0jol7o`3mo`Oo0?o`1_l0omh6o`3oc0Ko0?nj1ol0ojP7o`3oU`Ko0?n5
1_l0og<7o`3oH@Ko0?m?1_l0ocd6o`3o:`Ko0?lI1Oooool1o`00007ooooo0Oooool000[ooooo00?o
0000ooooooooool00oooool5o`0Vo`Go01Co2?l00_l9o`l0ocCo8@3o2?l?0?l4o`02o`So01Co1Ol0
9_l7o`0ho`Ko04[o1ol0G?l7o`1^o`Go07oo1ol0TOl6o`2So`Oo0;Go1_l0aol6o`3Io`Ko0>_o1ol0
oOl7o`3ol0Ko0?oN1_l0ol`6o`3o^PKo0?nX1ol0oiL6o`3oQ@Oo0?mc1_l0of46o`3oC`Ko0?lm1ol0
ob/6o`3o6@03o`3o1ooooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`;o00001?ooool7
o`0Vo`Co01Co2Ol00_l9o`l0oc7o8@3o2?l?0?l5o`02o`Oo01Co1_l09_l6o`0ho`Oo04[o1_l0G?l7
o`1^o`Ko07oo1_l0TOl6o`2So`Oo0;Go1_l0aol6o`3Io`Ko0>_o1ol0oOl6o`3ol0Ko0?oN1ol0ol`5
o`3o^POo0?nX1ol0oiL6o`3oQ@Ko0?mc1_l0of47o`3oC`Ko0?lm1_l0ob/7o`3o6@;o0?l71?ooool2
o`0000;ooooo000:ooooo`03o`000?oooooooooo00?ooooo00?o03Soo`0Vool09_l01Ol09_l5o`0D
o`So00;o2Ol?0?l`ob40o`So3`3o1?l00_l7o`0Do`Ko02Ko1ol0>?l6o`1:o`Oo05co1_l0K_l6o`1o
o`Ko097o1_l0Xol6o`2eo`Oo0<Oo1_l0fOl6o`3[o`Oo0?go1_l0oo06o`3ogPKo0?o<1_l0okX7o`3o
Z0Ko0?nG1_l0ohD7o`3oL`Ko0?mQ1_l0odl6o`3o?@Oo0?l[1_l0oaT4o`3o1`Gooooo0Ol00001oooo
o`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo0_l0>?l7o`0Vo`Ko01Co1ol00_l:o`l0obko
8@3o2?l?0?l4o`02o`Oo01Co1_l09_l6o`0ho`Ko04[o1ol0G?l6o`1^o`Ko07oo1_l0TOl6o`2So`Ko
0;Go1ol0aol6o`3Io`Ko0>_o1ol0oOl5o`3ol0Oo0?oN1_l0ol`6o`3o^PKo0?nX1_l0oiL7o`3oQ@Ko
0?mc1_l0of46o`3oC`Ko0?lm1ol0ob/6o`3o6@Ko0?l71Oooool1o`00007ooooo0Oooool000[ooooo
00?o0000ooooooooool00oooool3o`0ho`Oo02Ko1_l05?l7o`02o`[o3`3o;?lQ0?l8o`l0o`Co00;o
1ol05?l6o`0Vo`Ko03So1_l0B_l6o`1Lo`Oo06ko1_l0Ool6o`2Ao`Ko0:?o1_l0]Ol7o`37o`Ko0=Wo
1_l0jol7o`3mo`Go0?o`1ol0omh6o`3oc0Ko0?nj1_l0ojP6o`3oU`Oo0?n51_l0og<6o`3oH@Ko0?m?
1_l0ocd6o`3o:`Oo0?lI1_l0o`L00ol:o`3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_oo
ool00ol0003oooooooooo`03ooooo`Go03So1_l09_l7o`0Do`Oo00;o2_l?0?lYob40o`Wo3`3o0ol0
0_l7o`0Do`Ko02Ko1_l0>?l6o`1:o`Ko05co1ol0K_l6o`1oo`Ko097o1_l0Xol6o`2eo`Oo0<Oo1_l0
fOl6o`3[o`Ko0?go1_l0oo07o`3ogPGo0?o<1ol0okX5o`3oZ0Oo0?nG1_l0ohD6o`3oL`Ko0?mQ1_l0
odl7o`3o?@Go0?l[1ol0oaT6o`3o1`?o2_l01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000
ooooooooool00oooool6o`0ho`Oo02Ko1_l05?l8o`02o`_o3`3o9_lQ0?l9o`l0o`?o00;o1ol05?l6
o`0Vo`Ko03So1_l0B_l6o`1Lo`Oo06ko1_l0Ool6o`2Ao`Ko0:?o1_l0]Ol6o`37o`Oo0=Wo1_l0jol6
o`3mo`Ko0?o`1Ol0omh6o`3oc0Oo0?nj1Ol0ojP7o`3oU`Ko0?n51_l0og<6o`3oH@Ko0?m?1_l0ocd6
o`3o:`Oo0?lI1_l0o`L4o`[o00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo
00?ooooo0_l0B_l5o`0ho`Oo02Ko1ol05?l8o`02o`co3`3o8_lQ0?l9o`l0o`Co00;o1_l05?l6o`0V
o`Ko03So1_l0B_l6o`1Lo`Oo06ko1_l0Ool6o`2Ao`Ko0:?o1_l0]Ol6o`37o`Oo0=Wo1_l0jol6o`3m
o`Ko0?o`1Ol0omh6o`3oc0Ko0?nj1_l0ojP7o`3oU`Ko0?n51_l0og<6o`3oH@Ko0?m?1_l0ocd6o`3o
:`Ko0?lI1_l0o`L6o`[o00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?o
oooo0ol0B_l6o`0ho`Oo02Ko1_l05?l9o`02o`go3`3o7_lQ0?l9o`l0o`Go00;o1_l05?l6o`0Vo`Go
03So1ol0B_l5o`1Lo`Oo06ko1_l0Ool6o`2Ao`Oo0:?o1Ol0]Ol6o`37o`Oo0=Wo1_l0jol6o`3mo`Ko
0?o`1Ol0omh6o`3oc0Ko0?nj1_l0ojP6o`3oU`Oo0?n51_l0og<6o`3oH@Ko0?m?1_l0ocd6o`3o:`Ko
0?lI1_l0o`L6o`[o0003oaco0?oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`00
0?oooooooooo00?ooooo1?l0B_l6o`0ho`So02Ko1_l05?l9o`02o`ko3`3o6_lQ0?l9o`l0o`Go00;o
1_l05?l6o`0Vo`Ko03So1_l0B_l6o`1Lo`Ko06ko1_l0Ool6o`2Ao`Oo0:?o1Ol0]Ol7o`37o`Ko0=Wo
1_l0jol6o`3mo`Ko0?o`1Ol0omh6o`3oc0Ko0?nj1_l0ojP6o`3oU`Ko0?n51_l0og<6o`3oH@Oo0?m?
1Ol0ocd7o`3o:`Ko0?lI1Ol0o`L7o`[o00;o7?l01Oooool1o`00007ooooo0Oooool000[ooooo00?o
0000ooooooooool00oooool6o`1:o`Go03So2?l09_l7o`0Do`Wo00;o4?l?0?lEob40o`[o3`3o1Ol0
0_l6o`0Do`Ko02Ko1Ol0>?l7o`1:o`Go05co1ol0K_l6o`1oo`Ko097o1_l0Xol5o`2eo`Oo0<Oo1_l0
fOl5o`3[o`Oo0?go1_l0oo05o`3ogPKo0?o<1_l0okX6o`3oZ0Ko0?nG1_l0ohD6o`3oL`Ko0?mQ1_l0
odl6o`3o?@Oo0?l[1Ol0oaT6o`3o1`Ko2_l01?lLo`05ooooo`7o00000Oooool1ooooo`002_ooool0
0ol0003oooooooooo`03ooooo`Oo04[o1_l0>?l8o`0Vo`Oo01Co2Ol00_lAo`l0oa7o8@3o2_l?0?l5
o`02o`Ko01Co1_l09_l5o`0ho`Oo04[o1Ol0G?l7o`1^o`Ko07oo1_l0TOl6o`2So`Ko0;Go1_l0aol6
o`3Io`Go0>_o1ol0oOl5o`3ol0Ko0?oN1_l0ol`5o`3o^POo0?nX1_l0oiL6o`3oQ@Ko0?mc1_l0of46
o`3oC`Go0?lm1ol0ob/6o`3o6@Go0?l71_l:o`06oaco00Gooooo0Ol00001ooooo`7ooooo000:oooo
o`03o`000?oooooooooo00?ooooo0_l0G?l7o`1:o`Go03So2?l09_l7o`0Do`_o00;o4Ol?0?l>ob40
o`Wo3`3o1_l00_l5o`0Do`Oo02Ko1Ol0>?l7o`1:o`Go05co1_l0K_l6o`1oo`Ko097o1_l0Xol6o`2e
o`Ko0<Oo1_l0fOl5o`3[o`Oo0?go1Ol0oo06o`3ogPKo0?o<1Ol0okX6o`3oZ0Ko0?nG1ol0ohD5o`3o
L`Oo0?mQ1Ol0odl6o`3o?@Oo0?l[1Ol0oaT6o`3o1`Ko2_l01_lLo`000ol^o`3oooooooooo`03oooo
o`7o00000Oooool1ooooo`000_ooool3o`0000Gooooo00?o0000ooooooooool00oooool3o`1Lo`Oo
04[o1_l0>?l8o`0Vo`Oo01Co2ol00_lAo`l0o`_o8@3o2_l?0?l6o`02o`Go01Co1_l09_l5o`0ho`Oo
04[o1Ol0G?l7o`1^o`Ko07oo1Ol0TOl6o`2So`Ko0;Go1_l0aol6o`3Io`Go0>_o1ol0oOl5o`3ol0Ko
0?oN1_l0ol`5o`3o^PKo0?nX1_l0oiL6o`3oQ@Ko0?mc1ol0of45o`3oC`Ko0?lm1_l0ob/6o`3o6@Go
0?l71_l:o`06oaco00?o;_l01Oooool1o`00007ooooo0Oooool00003ooooool0003ooooo00;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`Go05co1_l0B_l7o`0ho`So02Ko
1ol05?l;o`02oa3o3`3o2OlQ0?l:o`l0o`Ko00;o1Ol05?l6o`0Vo`Ko03So1_l0B_l6o`1Lo`Ko06ko
1_l0Ool5o`2Ao`Ko0:?o1_l0]Ol6o`37o`Ko0=Wo1Ol0jol7o`3mo`Go0?o`1_l0omh6o`3oc0Go0?nj
1_l0ojP6o`3oU`Ko0?n51_l0og<6o`3oH@Go0?m?1_l0ocd6o`3o:`Oo0?lI1?l0o`L7o`[o00Ko7?l0
1?l^o`05ooooo`7o00000Oooool1ooooo`0000?oooooo`000?ooool00_ooool00ol0003ooooooooo
o`02ooooo`?o00000oooool6o`1Lo`Ko04[o1ol0>?l8o`0Vo`Wo01Co2ol00_l?o`l0o`Ko8@3o2_l?
0?l7o`02o`Go01Co1_l09_l5o`0ho`Ko04[o1_l0G?l6o`1^o`Ko07oo1Ol0TOl6o`2So`Ko0;Go1_l0
aol6o`3Io`Go0>_o1ol0oOl5o`3ol0Ko0?oN1_l0ol`5o`3o^PKo0?nX1_l0oiL6o`3oQ@Ko0?mc1Ol0
of46o`3oC`Ko0?lm1_l0ob/6o`3o6@Go0?l71_l:o`06oaco00Ko;_l00oooool3o`0000;ooooo0000
0ooooooo0000o`000002o`0000Gooooo00?o0000ooooooooool00oooool2o`1^o`Ko05co1_l0B_l8
o`0ho`Oo02Ko2_l05?l;o`02o`oo3`3o0_lQ0?l:o`l0o`Oo00;o1Ol05?l6o`0Vo`Go03So1_l0B_l6
o`1Lo`Ko06ko1_l0Ool5o`2Ao`Ko0:?o1_l0]Ol6o`37o`Ko0=Wo1Ol0jol6o`3mo`Ko0?o`1_l0omh6
o`3oc0Go0?nj1_l0ojP6o`3oU`Ko0?n51_l0og<5o`3oH@Ko0?m?1Ol0ocd7o`3o:`Go0?lI1_l0o`L5
o`[o00Ko7?l01_l^o`02ocoo00Gooooo0Ol00001ooooo`7ooooo00000ooooooo0000ooooo`07oooo
o`03o`000?oooooooooo00?ooooo0ol0K_l7o`1Lo`Ko04[o2?l0>?l7o`0Vo`_o01Co2_l00_lHo`l0
o`So00;o1Ol05?l6o`0Vo`Go03So1_l0B_l6o`1Lo`Ko06ko1_l0Ool5o`2Ao`Ko0:?o1_l0]Ol6o`37
o`Ko0=Wo1Ol0jol6o`3mo`Ko0?o`1Ol0omh6o`3oc0Go0?nj1_l0ojP5o`3oU`Oo0?n51_l0og<5o`3o
H@Ko0?m?1Ol0ocd7o`3o:`Go0?lI1_l0o`L5o`[o00Ko7?l01_l^o`03ocoo00Gooooo0Ol00001oooo
o`7ooooo0002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool4o`1^o`Oo
05co1_l0B_l9o`0ho`Oo02Ko2ol05?l9o`02oaCo3`3o2_l00_l5o`0Do`Ko02Ko1Ol0>?l6o`1:o`Ko
05co1_l0K_l6o`1oo`Go097o1_l0Xol6o`2eo`Ko0<Oo1_l0fOl5o`3[o`Ko0?go1_l0oo05o`3ogPKo
0?o<1Ol0okX6o`3oZ0Go0?nG1ol0ohD5o`3oL`Ko0?mQ1Ol0odl6o`3o?@Oo0?l[1Ol0oaT6o`3o1`Go
2_l01_lLo`05obko00Go?ol01Oooool1o`00007ooooo0Oooool000?ooooo0_l00005ooooo`03o`00
0?oooooooooo00?ooooo1_l0K_l7o`1Lo`Ko04[o2Ol0>?l7o`0Vo`_o01Co2Ol00_l?o`l0o`co00;o
1_l05?l6o`0Vo`Go03So1_l0B_l6o`1Lo`Go06ko1_l0Ool5o`2Ao`Ko0:?o1_l0]Ol6o`37o`Ko0=Wo
1Ol0jol6o`3mo`Ko0?o`1Ol0omh6o`3oc0Go0?nj1_l0ojP5o`3oU`Oo0?n51Ol0og<6o`3oH@Go0?m?
1_l0ocd6o`3o:`Go0?lI1_l0o`L5o`[o00Ko7?l01_l^o`06ocoo00Gooooo0Ol00001ooooo`7ooooo
000:ooooo`03o`000?oooooooooo00?ooooo0_l0Ool5o`1^o`Oo05co1ol0B_l8o`0ho`Wo02Ko2_l0
5?l>o`02o`Go3`3o3ol00_l5o`0Do`Ko02Ko1_l0>?l5o`1:o`Ko05co1_l0K_l5o`1oo`Ko097o1_l0
Xol5o`2eo`Ko0<Oo1_l0fOl6o`3[o`Go0?go1_l0oo05o`3ogPKo0?o<1Ol0okX6o`3oZ0Go0?nG1ol0
ohD5o`3oL`Ko0?mQ1Ol0odl6o`3o?@Ko0?l[1Ol0oaT6o`3o1`Go2_l01_lLo`06obko00Ko?ol000?o
DOl0ooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool3
o`1oo`Ko06ko1ol0G?l6o`1:o`Wo03So2_l09_l:o`0Doako00;o1_l05?l6o`0Vo`Go03So1_l0B_l6
o`1Lo`Go06ko1_l0Ool5o`2Ao`Ko0:?o1_l0]Ol5o`37o`Ko0=Wo1_l0jol5o`3mo`Ko0?o`1Ol0omh6
o`3oc0Go0?nj1_l0ojP5o`3oU`Oo0?n51Ol0og<6o`3oH@Go0?m?1_l0ocd6o`3o:`Go0?lI1_l0o`L5
o`[o00Ko7?l01Ol^o`07ocoo00;oDOl01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooo
ooooool00oooool5o`1oo`Go06ko2?l0G?l6o`1:o`Wo03So2ol09_l9o`0Doa_o00;o1_l05?l6o`0V
o`Ko03So1Ol0B_l6o`1Lo`Go06ko1_l0Ool5o`2Ao`Oo0:?o1Ol0]Ol6o`37o`Go0=Wo1_l0jol5o`3m
o`Ko0?o`1Ol0omh6o`3oc0Go0?nj1_l0ojP5o`3oU`Oo0?n51?l0og<7o`3oH@Co0?m?1ol0ocd5o`3o
:`Ko0?lI1Ol0o`L6o`[o00Go7?l01_l^o`06ocoo00CoDOl01Oooool1o`00007ooooo0Oooool000[o
oooo00?o0000ooooooooool00oooool6o`1oo`Go06ko2?l0G?l7o`1:o`Wo03So2ol09_l9o`0DoaSo
00;o1_l05?l6o`0Vo`Ko03So1Ol0B_l6o`1Lo`Ko06ko1Ol0Ool6o`2Ao`Ko0:?o1Ol0]Ol6o`37o`Ko
0=Wo1Ol0jol6o`3mo`Go0?o`1Ol0omh6o`3oc0Go0?nj1_l0ojP5o`3oU`Ko0?n51Ol0og<6o`3oH@Go
0?m?1_l0ocd6o`3o:`Go0?lI1_l0o`L5o`[o00Ko7?l01Ol^o`06ocoo00GoDOl000?oHol0oooooooo
ool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool7o`1oo`Ko06ko
2?l0G?l8o`1:o`Wo03So2ol09_l=o`0Doa7o00;o1_l05?l6o`0Vo`Ko03So1Ol0B_l5o`1Lo`Ko06ko
1Ol0Ool6o`2Ao`Ko0:?o1_l0]Ol5o`37o`Ko0=Wo1Ol0jol6o`3mo`Go0?o`1Ol0omh6o`3oc0Go0?nj
1_l0ojP5o`3oU`Ko0?n51Ol0og<6o`3oH@Go0?m?1_l0ocd5o`3o:`Ko0?lI1Ol0o`L6o`[o00Go7?l0
1_l^o`06ocoo00GoDOl00_mSo`05ooooo`7o00000Oooool1ooooo`002_ooool00ol0003ooooooooo
o`03ooooo`;o097o1ol0Ool6o`1^o`Oo05co2Ol0B_l:o`0ho`_o02Ko5Ol05?l5o`02o`Ko01Co1_l0
9_l6o`0ho`Go04[o1_l0G?l6o`1^o`Go07oo1_l0TOl5o`2So`Ko0;Go1Ol0aol6o`3Io`Go0>_o1_l0
oOl5o`3ol0Go0?oN1_l0ol`5o`3o^PKo0?nX1Ol0oiL6o`3oQ@Go0?mc1_l0of45o`3oC`Ko0?lm1Ol0
ob/6o`3o6@Go0?l71Ol:o`06oaco00Go;_l01_loo`05oe7o00CoHol01Oooool1o`00007ooooo0Ooo
ool000[ooooo00?o0000ooooooooool00oooool4o`2Ao`Ko07oo1ol0K_l7o`1Lo`Wo04[o2ol0>?l;
o`0Voago01Co1_l09_l6o`0ho`Go04[o1Ol0G?l6o`1^o`Go07oo1_l0TOl5o`2So`Ko0;Go1Ol0aol6
o`3Io`Go0>_o1_l0oOl5o`3ol0Go0?oN1_l0ol`5o`3o^PKo0?nX1Ol0oiL6o`3oQ@Go0?mc1_l0of45
o`3oC`Ko0?lm1Ol0ob/6o`3o6@Go0?l71Ol:o`06oaco00Go;_l01_loo`05oe7o00GoHol01Oooool1
o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool6o`2Ao`Go07oo2?l0K_l7o`1L
o`Wo04[o2ol0>?l>o`0VoaKo01Co1ol09_l6o`0ho`Go04[o1Ol0G?l6o`1^o`Go07oo1_l0TOl5o`2S
o`Ko0;Go1Ol0aol6o`3Io`Go0>_o1_l0oOl5o`3ol0Go0?oN1_l0ol`5o`3o^PKo0?nX1Ol0oiL6o`3o
Q@Go0?mc1_l0of45o`3oC`Ko0?lm1Ol0ob/5o`3o6@Ko0?l71Ol:o`05oaco00Ko;_l01Oloo`05oe7o
00KoHol000?oMOl0ooooooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooooooo
ool00oooool7o`2Ao`Ko07oo2?l0K_l7o`1Lo`[o04[o2ol0>?l@o`0Voa3o01Co2?l09_l6o`0ho`Go
04[o1Ol0G?l6o`1^o`Go07oo1_l0TOl5o`2So`Ko0;Go1Ol0aol5o`3Io`Ko0>_o1Ol0oOl6o`3ol0Go
0?oN1_l0ol`5o`3o^PKo0?nX1Ol0oiL5o`3oQ@Go0?mc1_l0of45o`3oC`Ko0?lm1Ol0ob/5o`3o6@Ko
0?l71Ol:o`05oaco00Ko;_l01Oloo`05oe7o00KoHol00_meo`05ooooo`7o00000Oooool1ooooo`00
2_ooool00ol0003oooooooooo`03ooooo`;o0:?o1ol0TOl6o`1oo`Oo06ko2Ol0G?l:o`1:o`_o03So
4Ol09_l;o`0Do`So02Ko1_l0>?l5o`1:o`Go05co1_l0K_l5o`1oo`Ko097o1Ol0Xol6o`2eo`Go0<Oo
1_l0fOl5o`3[o`Ko0?go1Ol0oo06o`3ogPGo0?o<1_l0okX5o`3oZ0Go0?nG1Ol0ohD5o`3oL`Ko0?mQ
1Ol0odl6o`3o?@Go0?l[1Ol0oaT6o`3o1`Go2_l01OlLo`06obko00Go?ol01OmAo`06of?o00?oMOl0
1Oooool1o`00007ooooo0Oooool000[ooooo0_l00004ooooo`Co0:?o1_l0TOl7o`1oo`Oo06ko2Ol0
G?l;o`1:o`_o03So4_l09_l6o`0Do`So02Ko1_l0>?l6o`1:o`Go05co1_l0K_l5o`1oo`Ko097o1?l0
Xol7o`2eo`Co0<Oo1_l0fOl5o`3[o`Ko0?go1Ol0oo06o`3ogPGo0?o<1_l0okX5o`3oZ0Go0?nG1Ol0
ohD5o`3oL`Ko0?mQ1Ol0odl6o`3o?@Go0?l[1Ol0oaT6o`3o1`Go2_l01OlLo`06obko00Go?ol01OmA
o`05of?o00GoMOl01?ooool2o`0000;ooooo000:ooooo`03o`000?oooooooooo00?ooooo1_l0Xol5
o`2Ao`Oo07oo2?l0K_l9o`1Lo`co04[o3?l0>?lAo`0Vo`;o01Co1ol09_l8o`0ho`Ko04[o1?l0G?l6
o`1^o`Go07oo1_l0TOl5o`2So`Ko0;Go1Ol0aol5o`3Io`Ko0>_o1Ol0oOl5o`3ol0Ko0?oN1Ol0ol`6
o`3o^PGo0?nX1Ol0oiL5o`3oQ@Go0?mc1_l0of45o`3oC`Ko0?lm1Ol0ob/5o`3o6@Ko0?l71Ol:o`04
oaco00Oo;_l01?loo`05oe7o00KoHol01Omeo`000on7o`3oooooooooo`03ooooo`7o00000Oooool1
ooooo`002_ooool00ol0003oooooooooo`03ooooo`;o0;Go1Ol0Xol6o`2Ao`Oo07oo2Ol0K_l9o`1L
o`go04[o3Ol0>?lBo`0Vo`[o03So1_l0B_l5o`1Lo`Ko06ko1Ol0Ool5o`2Ao`Go0:?o1_l0]Ol5o`37
o`Ko0=Wo1Ol0jol5o`3mo`Ko0?o`1Ol0omh5o`3oc0Ko0?nj1Ol0ojP5o`3oU`Go0?n51Ol0og<6o`3o
H@Go0?m?1_l0ocd4o`3o:`Go0?lI1_l0o`L5o`[o00Go7?l01_l^o`05ocoo00GoDOl01OmSo`06ogGo
00;oQol01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool3o`2eo`Ko
0:?o1_l0TOl7o`1oo`Wo06ko2_l0G?l=o`1:oa3o03So2_l09_l;o`0ho`Ko04[o1Ol0G?l6o`1^o`Go
07oo1_l0TOl5o`2So`Go0;Go1Ol0aol6o`3Io`Go0>_o1Ol0oOl6o`3ol0Go0?oN1Ol0ol`6o`3o^PGo
0?nX1Ol0oiL5o`3oQ@Go0?mc1Ol0of46o`3oC`Go0?lm1Ol0ob/5o`3o6@Ko0?l71Ol:o`05oaco00Ko
;_l01Oloo`05oe7o00GoHol01Omeo`04ohOo00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`00
0?oooooooooo00?ooooo1Ol0]Ol6o`2So`Oo097o1_l0Ool9o`1^o`_o05co3_l0B_lAo`0ho`?o02Ko
3Ol0>?l6o`1:o`Co05co1_l0K_l5o`1oo`Ko097o1Ol0Xol5o`2eo`Ko0<Oo1Ol0fOl6o`3[o`Go0?go
1Ol0oo05o`3ogPGo0?o<1_l0okX5o`3oZ0Go0?nG1Ol0ohD5o`3oL`Go0?mQ1_l0odl5o`3o?@Go0?l[
1Ol0oaT6o`3o1`Go2_l01OlLo`06obko00Go?ol01?mAo`06of?o00GoMOl01On7o`05ooooo`7o0000
0Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooo`Ko0;Go1ol0Xol7o`2Ao`Oo07oo2Ol0
K_l;o`1Lo`oo04[o7?l0>?l6o`1:o`Go05co1_l0K_l5o`1oo`Go097o1Ol0Xol6o`2eo`Go0<Oo1Ol0
fOl6o`3[o`Go0?go1Ol0oo05o`3ogPGo0?o<1_l0okX5o`3oZ0Go0?nG1Ol0ohD5o`3oL`Go0?mQ1_l0
odl5o`3o?@Go0?l[1Ol0oaT6o`3o1`Co2_l01_lLo`05obko00Ko?ol01?mAo`05of?o00KoMOl01On7
o`000onIo`3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03
ooooo`;o0<Oo1_l0]Ol7o`2So`Oo097o1ol0Ool:o`1^o`co05co3_l0B_lIo`0ho`Ko04[o1?l0G?l6
o`1^o`Go07oo1_l0TOl5o`2So`Go0;Go1Ol0aol6o`3Io`Go0>_o1Ol0oOl5o`3ol0Go0?oN1Ol0ol`6
o`3o^PGo0?nX1Ol0oiL5o`3oQ@Go0?mc1Ol0of46o`3oC`Go0?lm1Ol0ob/5o`3o6@Ko0?l71?l:o`05
oaco00Ko;_l01Oloo`05oe7o00GoHol01Omeo`05ohOo00?oVOl01Oooool1o`00007ooooo0Oooool0
00[ooooo00?o0000ooooooooool00oooool3o`37o`Ko0;Go1ol0Xol8o`2Ao`So07oo2_l0K_l<o`1L
oa?o04[o4?l0>?l6o`1:o`Go05co1_l0K_l5o`1oo`Go097o1Ol0Xol5o`2eo`Go0<Oo1_l0fOl5o`3[
o`Go0?go1Ol0oo05o`3ogPGo0?o<1_l0okX5o`3oZ0Go0?nG1Ol0ohD5o`3oL`Go0?mQ1_l0odl5o`3o
?@Go0?l[1Ol0oaT5o`3o1`Go2_l01OlLo`06obko00Go?ol01OmAo`05of?o00GoMOl01On7o`04oiWo
00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo1Ol0aol6o`2eo`Oo
0:?o2?l0TOl9o`1oo`Wo06ko3ol0G?lSo`1:o`Go05co1_l0K_l5o`1oo`Go097o1Ol0Xol5o`2eo`Go
0<Oo1_l0fOl5o`3[o`Go0?go1Ol0oo05o`3ogPGo0?o<1_l0okX5o`3oZ0Go0?nG1Ol0ohD5o`3oL`Go
0?mQ1_l0odl5o`3o?@Go0?l[1Ol0oaT5o`3o1`Go2_l01OlLo`06obko00Co?ol01_mAo`04of?o00Ko
MOl01On7o`05oiWo00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo
1_l0aol7o`2eo`Oo0:?o2?l0TOl:o`1oo`Wo06ko4Ol0G?lMo`1:o`Ko05co1_l0K_l5o`1oo`Go097o
1Ol0Xol5o`2eo`Go0<Oo1_l0fOl5o`3[o`Go0?go1Ol0oo05o`3ogPGo0?o<1Ol0okX6o`3oZ0Go0?nG
1Ol0ohD5o`3oL`Go0?mQ1Ol0odl5o`3o?@Go0?l[1Ol0oaT5o`3o1`Ko2_l01?lLo`06obko00Co?ol0
1_mAo`04of?o00GoMOl01_n7o`05oiWo0003oj_o0?oooooooooo00?ooooo0Ol00001ooooo`7ooooo
000:ooooo`03o`000?oooooooooo00?ooooo0_l0fOl6o`37o`Oo0;Go1ol0Xol9o`2Ao`[o07oo2_l0
K_lFo`1Loa?o04[o1_l0G?l6o`1^o`Go07oo1Ol0TOl5o`2So`Go0;Go1Ol0aol6o`3Io`Go0>_o1Ol0
oOl5o`3ol0Go0?oN1Ol0ol`5o`3o^PKo0?nX1Ol0oiL5o`3oQ@Go0?mc1Ol0of45o`3oC`Go0?lm1Ol0
ob/5o`3o6@Go0?l71_l:o`04oaco00Ko;_l01?loo`05oe7o00GoHol01Omeo`06ohOo00GoVOl00_n[
o`05ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooo`Co0=Wo1_l0aol7
o`2eo`Oo0:?o2Ol0TOl;o`1oo`[o06ko6_l0G?l;o`1:o`Ko05co1_l0K_l6o`1oo`Go097o1Ol0Xol5
o`2eo`Go0<Oo1Ol0fOl5o`3[o`Go0?go1Ol0oo06o`3ogPCo0?o<1_l0okX5o`3oZ0Ko0?nG1?l0ohD5
o`3oL`Go0?mQ1Ol0odl5o`3o?@Go0?l[1Ol0oaT5o`3o1`Ko2_l01?lLo`05obko00Go?ol01OmAo`05
of?o00GoMOl01_n7o`05oiWo00?oZol01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooo
ooooool00oooool6o`3Io`Go0<Oo1ol0]Ol8o`2So`Wo097o3?l0Ool<o`1^oaWo05co1_l0B_l5o`1L
o`So06ko1Ol0Ool5o`2Ao`Go0:?o1Ol0]Ol5o`37o`Ko0=Wo1?l0jol6o`3mo`Co0?o`1_l0omh5o`3o
c0Go0?nj1Ol0ojP6o`3oU`Co0?n51Ol0og<5o`3oH@Go0?m?1Ol0ocd5o`3o:`Go0?lI1Ol0o`L5o`[o
00Go7?l01Ol^o`05ocoo00GoDOl01OmSo`05ogGo00KoQol01OnIo`04oj_o00Gooooo0Ol00001oooo
o`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo0_l0jol5o`3Io`Ko0<Oo1ol0]Ol9o`2So`Wo
097o3Ol0Ool=o`1^oaOo05co0_l0B_l4o`1Lo`Wo06ko1_l0Ool5o`2Ao`Go0:?o1Ol0]Ol5o`37o`Go
0=Wo1Ol0jol5o`3mo`Go0?o`1_l0omh4o`3oc0Go0?nj1Ol0ojP6o`3oU`Co0?n51Ol0og<5o`3oH@Go
0?m?1Ol0ocd5o`3o:`Go0?lI1Ol0o`L5o`[o00Go7?l01Ol^o`05ocoo00GoDOl01OmSo`05ogGo00Ko
Qol01?nIo`05oj_o0003okgo0?oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`00
0?oooooooooo00?ooooo1?l0jol5o`3Io`Ko0<Oo1ol0]Ol9o`2So`[o097o3Ol0OolCo`1^oa?o05co
2_l0K_l5o`1oo`Go097o1Ol0Xol5o`2eo`Go0<Oo1Ol0fOl5o`3[o`Ko0?go1?l0oo06o`3ogPCo0?o<
1Ol0okX6o`3oZ0Go0?nG1?l0ohD5o`3oL`Go0?mQ1Ol0odl5o`3o?@Go0?l[1Ol0oaT5o`3o1`Go2_l0
1OlLo`05obko00Go?ol01?mAo`05of?o00KoMOl01On7o`05oiWo00GoZol00_nmo`05ooooo`7o0000
0Oooool1ooooo`002_ooool2o`0000Cooooo1Ol0jol6o`3Io`Oo0<Oo1_l0]Ol9o`2So`_o097o3ol0
OolFo`1^o`Wo05co2ol0K_l5o`1oo`Ko097o1?l0Xol6o`2eo`Co0<Oo1_l0fOl4o`3[o`Ko0?go1?l0
oo06o`3ogPCo0?o<1Ol0okX6o`3oZ0Go0?nG1?l0ohD5o`3oL`Go0?mQ1Ol0odl5o`3o?@Go0?l[1Ol0
oaT5o`3o1`Go2_l01OlLo`04obko00Go?ol01OmAo`05of?o00KoMOl01On7o`05oiWo00GoZol00onm
o`04ooooo`;o00000_ooool000[ooooo00?o0000ooooooooool00oooool7o`3[o`Ko0=Wo1ol0aol7
o`2eo`Wo0:?o2ol0TOlAo`1ooaKo06ko0ol0G?l;o`1^o`Ko07oo1Ol0TOl5o`2So`Go0;Go1Ol0aol5
o`3Io`Go0>_o1Ol0oOl5o`3ol0Go0?oN1Ol0ol`5o`3o^PGo0?nX1Ol0oiL4o`3oQ@Go0?mc1Ol0of45
o`3oC`Go0?lm1Ol0ob/5o`3o6@Go0?l71Ol:o`04oaco00Go;_l01Oloo`05oe7o00GoHol01_meo`04
ohOo00KoVOl01?n[o`05okgo00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo
00?ooooo0_l0oOl7o`3[o`Ko0=Wo1ol0aol8o`2eo`[o0:?o2ol0TOlFo`1ooa_o06ko1Ol0Ool6o`2A
o`Co0:?o1_l0]Ol4o`37o`Go0=Wo1Ol0jol5o`3mo`Go0?o`1Ol0omh5o`3oc0Go0?nj1Ol0ojP5o`3o
U`Co0?n51Ol0og<5o`3oH@Go0?m?1Ol0ocd5o`3o:`Go0?lI1Ol0o`L5o`[o00Co7?l01Ol^o`05ocoo
00GoDOl01OmSo`06ogGo00CoQol01_nIo`04oj_o00Go_Ol000?ocol0ooooooooool00oooool1o`00
007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool4o`3mo`Ko0>_o1ol0fOl7o`37o`Wo
0;Go2_l0Xol;o`2Aoako07oo2_l0K_l;o`1oo`Go097o1Ol0Xol5o`2eo`Go0<Oo1?l0fOl5o`3[o`Go
0?go1Ol0oo05o`3ogPGo0?o<1Ol0okX5o`3oZ0Go0?nG1?l0ohD5o`3oL`Go0?mQ1Ol0odl5o`3o?@Go
0?l[1Ol0oaT5o`3o1`Go2_l01?lLo`05obko00Go?ol01OmAo`05of?o00KoMOl01?n7o`05oiWo00Go
Zol01?nmo`03oloo00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo
1_l0oOl5o`3[o`So0=Wo2?l0aol8o`2eo`co0:?o3Ol0TOl[o`1oo`Go097o1_l0Xol5o`2eo`Go0<Oo
1?l0fOl5o`3[o`Go0?go1Ol0oo05o`3ogPGo0?o<1Ol0okX5o`3oZ0Go0?nG1?l0ohD5o`3oL`Go0?mQ
1Ol0odl5o`3o?@Go0?l[1Ol0oaT5o`3o1`Go2_l01?lLo`05obko00Go?ol01OmAo`05of?o00CoMOl0
1_n7o`04oiWo00KoZol01?nmo`04oloo00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oo
oooooooo00?ooooo0_l0oo06o`3mo`Go0>_o2Ol0fOl8o`37o`So0;Go3Ol0Xol>o`2AobGo07oo1Ol0
TOl7o`2So`Go0;Go1Ol0aol4o`3Io`Go0>_o1Ol0oOl5o`3ol0Go0?oN1Ol0ol`5o`3o^PGo0?nX1Ol0
oiL4o`3oQ@Go0?mc1Ol0of45o`3oC`Go0?lm1Ol0ob/5o`3o6@Go0?l71?l:o`05oaco00Go;_l01?lo
o`05oe7o00GoHol01?meo`06ohOo00CoVOl01_n[o`04okgo00Gocol01Oooool1o`00007ooooo0Ooo
ool000[ooooo00?o0000ooooooooool00oooool4o`3ol0Go0?go1_l0jol9o`3Io`Wo0<Oo2?l0]Ol=
o`2Soa?o097o7?l0Ool5o`2Ao`Oo0:?o1Ol0]Ol5o`37o`Co0=Wo1Ol0jol5o`3mo`Ko0?o`1?l0omh5
o`3oc0Go0?nj1Ol0ojP5o`3oU`Co0?n51Ol0og<5o`3oH@Ko0?m?1?l0ocd5o`3o:`Go0?lI1Ol0o`L4
o`[o00Go7?l01?l^o`05ocoo00GoDOl01OmSo`04ogGo00KoQol01?nIo`06oj_o00Co_Ol01Oo?o`00
0ooQo`3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooo
o`Ko0?o`1Ol0oOl7o`3[o`So0=Wo2Ol0aol9o`2eo`oo0:?o9?l0TOl5o`1oo`Go097o1ol0Xol5o`2e
o`Go0<Oo1Ol0fOl5o`3[o`Go0?go1Ol0oo04o`3ogPGo0?o<1Ol0okX5o`3oZ0Go0?nG1?l0ohD6o`3o
L`Co0?mQ1_l0odl4o`3o?@Go0?l[1Ol0oaT5o`3o1`Co2_l01OlLo`04obko00Go?ol01OmAo`05of?o
00CoMOl01_n7o`04oiWo00GoZol01Onmo`05oloo00;ohOl01Oooool1o`00007ooooo0Oooool000[o
oooo00?o0000ooooooooool00oooool7o`3ol0Ko0?go1ol0jol9o`3Io`Wo0<Oo2_l0]Ol@o`2SobOo
097o2Ol0Xol4o`2eo`Ko0<Oo1?l0fOl6o`3[o`Co0?go1Ol0oo05o`3ogPCo0?o<1_l0okX4o`3oZ0Go
0?nG1Ol0ohD5o`3oL`Co0?mQ1_l0odl4o`3o?@Go0?l[1Ol0oaT5o`3o1`Co2_l01OlLo`04obko00Go
?ol01OmAo`05of?o00CoMOl01On7o`05oiWo00GoZol01Onmo`05oloo00?ohOl01Oooool1o`00007o
oooo0Oooool000[ooooo00?o0000ooooooooool00oooool2o`3ogPOo0?o`1_l0oOl7o`3[o`Wo0=Wo
2_l0aol<o`2eoaCo0:?o7Ol0TOl9o`2So`Co0;Go1_l0aol5o`3Io`Go0>_o1Ol0oOl5o`3ol0Co0?oN
1Ol0ol`5o`3o^PGo0?nX1Ol0oiL4o`3oQ@Go0?mc1Ol0of45o`3oC`Co0?lm1Ol0ob/5o`3o6@Go0?l7
1?l:o`05oaco00Co;_l01Oloo`05oe7o00CoHol01Omeo`05ohOo00GoVOl01On[o`05okgo00Gocol0
0ooQo`000ooco`3oooooooooo`03ooooo`7o00000Oooool1ooooo`002_ooool00ol0003ooooooooo
o`03ooooo`Co0?oN1ol0oo07o`3mo`Ko0>_o2Ol0fOl;o`37o`oo0;Go6Ol0XolAo`2Ao`So0:?o1Ol0
]Ol7o`37o`Co0=Wo1Ol0jol5o`3mo`Go0?o`1Ol0omh4o`3oc0Go0?nj1Ol0ojP5o`3oU`Co0?n51Ol0
og<5o`3oH@Go0?m?1?l0ocd5o`3o:`Go0?lI1Ol0o`L4o`[o00Go7?l01?l^o`05ocoo00GoDOl01?mS
o`05ogGo00GoQol01OnIo`05oj_o00Go_Ol01?o?o`04on7o00;olol01Oooool1o`00007ooooo0Ooo
ool000[ooooo00?o0000ooooooooool00oooool7o`3ogPKo0?o`1ol0oOl7o`3[o`Wo0=Wo2ol0aolA
o`2eoaoo0:?o1Ol0TOl6o`2So`So0;Go1_l0aol4o`3Io`Ko0>_o1?l0oOl5o`3ol0Go0?oN1?l0ol`6
o`3o^PCo0?nX1Ol0oiL4o`3oQ@Go0?mc1Ol0of45o`3oC`Co0?lm1Ol0ob/5o`3o6@Go0?l71?l:o`05
oaco00Co;_l01Oloo`05oe7o00CoHol01Omeo`04ohOo00KoVOl01?n[o`05okgo00Gocol01?oQo`03
oo?o00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo0_l0ol`7o`3o
gPKo0?o`1ol0oOl8o`3[o`[o0=Wo2ol0aolFo`2eoako0:?o2_l0]Ol6o`37o`Go0=Wo1Ol0jol5o`3m
o`Co0?o`1Ol0omh5o`3oc0Go0?nj1Ol0ojP4o`3oU`Go0?n51?l0og<5o`3oH@Go0?m?1?l0ocd5o`3o
:`Go0?lI1Ol0o`L4o`[o00Go7?l01?l^o`05ocoo00GoDOl01?mSo`05ogGo00CoQol01OnIo`05oj_o
00Go_Ol01Oo?o`04on7o00Colol01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooooooo
ool00oooool4o`3oc0Oo0?oN1_l0oo07o`3mo`Wo0>_o2_l0fOl;o`37oako0;Go4?l0Xol<o`2eo`Oo
0<Oo1?l0fOl6o`3[o`Co0?go1Ol0oo05o`3ogPCo0?o<1Ol0okX5o`3oZ0Co0?nG1Ol0ohD4o`3oL`Go
0?mQ1Ol0odl4o`3o?@Go0?l[1Ol0oaT5o`3o1`Co2_l01OlLo`04obko00Go?ol01OmAo`04of?o00Go
MOl01?n7o`05oiWo00GoZol01?nmo`06oloo00CohOl01?oco`000ooonP3oooooooooo`03ooooo`7o
00000Oooool1ooooo`002_ooool2o`0000Cooooo1_l0ol`6o`3ogPOo0?o`2?l0oOl9o`3[o`_o0=Wo
3_l0aolbo`2eo`Oo0<Oo1Ol0fOl5o`3[o`Go0?go1?l0oo05o`3ogPCo0?o<1Ol0okX5o`3oZ0Co0?nG
1Ol0ohD4o`3oL`Go0?mQ1Ol0odl4o`3o?@Go0?l[1Ol0oaT4o`3o1`Go2_l01OlLo`04obko00Go?ol0
1OmAo`04of?o00GoMOl01?n7o`05oiWo00GoZol01?nmo`06oloo00CohOl01?oco`02oooj00Cooooo
0_l00002ooooo`002_ooool00ol0003oooooooooo`03ooooo`;o0?nj1_l0ol`6o`3ogPSo0?o`2?l0
oOl:o`3[o`_o0=Wo4ol0aolXo`2eo`Ko0<Oo1_l0fOl5o`3[o`Co0?go1Ol0oo05o`3ogPCo0?o<1Ol0
okX5o`3oZ0Co0?nG1Ol0ohD4o`3oL`Go0?mQ1Ol0odl4o`3o?@Go0?l[1Ol0oaT4o`3o1`Go2_l01OlL
o`04obko00Go?ol01OmAo`04of?o00GoMOl01?n7o`05oiWo00GoZol01?nmo`05oloo00GohOl01?oc
o`03oooj00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo1?l0okX6
o`3oc0Oo0?oN1ol0oo09o`3mo`[o0>_o2ol0fOlEo`37oako0;Go2_l0aol7o`3Io`Go0>_o1?l0oOl5
o`3ol0Go0?oN1?l0ol`5o`3o^PCo0?nX1Ol0oiL5o`3oQ@Co0?mc1Ol0of45o`3oC`Co0?lm1Ol0ob/5
o`3o6@Co0?l71Ol:o`05oaco00Co;_l01Oloo`04oe7o00GoHol01?meo`05ohOo00CoVOl01?n[o`05
okgo00Gocol01OoQo`04oo?o00CoooX01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooo
ooooool00oooool6o`3o^PGo0?o<2?l0omh8o`3ol0Wo0?go2ol0jol<o`3IocKo0<Oo1ol0fOl6o`3[
o`Co0?go1Ol0oo05o`3ogPCo0?o<1Ol0okX5o`3oZ0Co0?nG1Ol0ohD4o`3oL`Go0?mQ1Ol0odl4o`3o
?@Ko0?l[1?l0oaT4o`3o1`Go2_l01OlLo`04obko00Go?ol01?mAo`05of?o00CoMOl01On7o`04oiWo
00CoZol01Onmo`05oloo00GohOl01?oco`04oooj0003oooX0?oooooooooo00?ooooo0Ol00001oooo
o`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo0_l0ojP5o`3o^PKo0?o<2Ol0omh8o`3ol0[o
0?go2ol0jol=o`3Ioc3o0<Oo1_l0fOl7o`3[o`Co0?go1_l0oo04o`3ogPGo0?o<1?l0okX5o`3oZ0Co
0?nG1Ol0ohD4o`3oL`Go0?mQ1Ol0odl4o`3o?@Ko0?l[1?l0oaT4o`3o1`Go2_l01OlLo`04obko00Go
?ol01?mAo`05of?o00CoMOl01?n7o`05oiWo00CoZol01Onmo`05oloo00GohOl01?oco`04oooj00;o
onP01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool4o`3oZ0Go0?nj
1ol0ol`8o`3ogPWo0?o`2_l0oOl;o`3[oa?o0=Wo9_l0aol5o`3Io`So0>_o1?l0oOl6o`3ol0Go0?oN
1?l0ol`5o`3o^PCo0?nX1Ol0oiL4o`3oQ@Go0?mc1?l0of46o`3oC`Co0?lm1Ol0ob/4o`3o6@Co0?l7
1Ol:o`05oaco00Co;_l01Oloo`04oe7o00GoHol01?meo`04ohOo00GoVOl01?n[o`05okgo00Gocol0
1?oQo`05oo?o00CoooX00oooj005ooooo`7o00000Oooool1ooooo`002_ooool00ol0003ooooooooo
o`03ooooo`Ko0?nX1Ol0okX8o`3oc0So0?oN2Ol0oo0;o`3mo`co0>_o>?l0fOl8o`3[o`Co0?go1ol0
oo04o`3ogPGo0?o<1?l0okX5o`3oZ0Co0?nG1Ol0ohD4o`3oL`Go0?mQ1Ol0odl4o`3o?@Go0?l[1?l0
oaT4o`3o1`Go2_l01OlLo`04obko00Go?ol01?mAo`04of?o00GoMOl01?n7o`05oiWo00CoZol01Onm
o`05oloo00CohOl01Ooco`04oooj00CoonP01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000
ooooooooool00oooool2o`3oU`Go0?nX1_l0okX9o`3oc0So0?oN2_l0oo0;o`3mo`go0>_o<Ol0fOl9
o`3[o`Co0?go1ol0oo04o`3ogPGo0?o<1?l0okX5o`3oZ0Go0?nG1?l0ohD5o`3oL`Co0?mQ1Ol0odl4
o`3o?@Go0?l[1?l0oaT4o`3o1`Go2_l01OlLo`04obko00Go?ol01?mAo`04of?o00GoMOl01?n7o`05
oiWo00CoZol01Onmo`05oloo00CohOl01Ooco`03oooj00GoonP000?oomL0ooooooooool00oooool1
o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool4o`3oU`Go0?nX1ol0okX8o`3o
c0Wo0?oN2_l0oo0;o`3moa?o0>_o9_l0fOl8o`3[o`Ko0?go2?l0oo04o`3ogPGo0?o<1?l0okX4o`3o
Z0Go0?nG1?l0ohD5o`3oL`Co0?mQ1Ol0odl5o`3o?@Co0?l[1Ol0oaT4o`3o1`Co2_l01OlLo`04obko
00Go?ol01?mAo`04of?o00GoMOl01?n7o`05oiWo00CoZol01Onmo`05oloo00?ohOl01_oco`03oooj
00GoonP00_ooe`05ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooo`Ko
0?nG1Ol0ojP8o`3o^PSo0?o<2Ol0omh;o`3ol0co0?go>?l0jol9o`3mo`So0?o`1?l0omh5o`3oc0Co
0?nj1?l0ojP5o`3oU`Go0?n51?l0og<5o`3oH@Co0?m?1Ol0ocd4o`3o:`Go0?lI1?l0o`L4o`[o00Go
7?l01?l^o`05ocoo00CoDOl01?mSo`05ogGo00CoQol01OnIo`04oj_o00Go_Ol01Oo?o`03on7o00Go
lol01?oonP05oooX00?oomL01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool0
0oooool2o`3oQ@Ko0?nG1Ol0ojP9o`3o^PSo0?o<2Ol0omh<o`3ol0go0?go<?l0jol;o`3mo`So0?o`
1Ol0omh4o`3oc0Go0?nj1?l0ojP5o`3oU`Co0?n51?l0og<5o`3oH@Co0?m?1Ol0ocd4o`3o:`Go0?lI
1?l0o`L4o`[o00Go7?l01?l^o`05ocoo00CoDOl01?mSo`05ogGo00CoQol01OnIo`04oj_o00Go_Ol0
1Oo?o`03on7o00Golol01?oonP05oooX00CoomL01Oooool1o`00007ooooo0Oooool000[ooooo00?o
0000ooooooooool00oooool3o`3oQ@Oo0?nG1_l0ojP8o`3o^PWo0?o<2Ol0omh<o`3ol1?o0?go8?l0
jolAo`3mo`So0?o`1Ol0omh5o`3oc0Co0?nj1?l0ojP5o`3oU`Co0?n51?l0og<5o`3oH@Co0?m?1Ol0
ocd4o`3o:`Go0?lI1?l0o`L4o`[o00Go7?l01?l^o`05ocoo00CoDOl01?mSo`05ogGo00CoQol01OnI
o`04oj_o00Go_Ol01?o?o`04on7o00Golol01?oonP05oooX00CoomL000?oolD0ooooooooool00ooo
ool1o`00007ooooo0Oooool000;ooooo0ol00005ooooo`03o`000?oooooooooo00?ooooo1Ol0ohD6
o`3oU`So0?nX2?l0okX9o`3oc0_o0?oN3Ol0oo0io`3mo`_o0?o`1_l0omh5o`3oc0?o0?nj1Ol0ojP5
o`3oU`Co0?n51?l0og<5o`3oH@Co0?m?1Ol0ocd4o`3o:`Go0?lI1?l0o`L4o`[o00Go7?l01?l^o`05
ocoo00CoDOl01?mSo`05ogGo00CoQol01OnIo`04oj_o00Go_Ol01?o?o`04on7o00Golol01?oonP05
oooX00CoomL00_ooa@05ooooo`7o00000Oooool1ooooo`0000?oooooo`000?ooool00_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo0_l0og<5o`3oQ@Ko0?nG2Ol0ojP8o`3o
^P[o0?o<2ol0omh>o`3ol2oo0?go3Ol0oo09o`3ogPCo0?o<0ol0okX6o`3oZ0Go0?nG1?l0ohD4o`3o
L`Go0?mQ1?l0odl5o`3o?@Co0?l[1Ol0oaT4o`3o1`Co2_l01OlLo`04obko00Go?ol01?mAo`04of?o
00GoMOl01?n7o`05oiWo00CoZol01?nmo`05oloo00CohOl01?oco`04oooj00GoonP01?ooe`03ooo5
00Gooooo0Ol00001ooooo`7ooooo00000ooooooo0000ooooo`02ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool00oooool4o`3oL`Go0?n51ol0oiL8o`3oZ0Wo0?nj2_l0ol`;o`3ogQ?o
0?o`8?l0oOlAo`3ol0_o0?oN1?l0ol`3o`3o^PKo0?nX1Ol0oiL4o`3oQ@Co0?mc1Ol0of44o`3oC`Go
0?lm1?l0ob/5o`3o6@Go0?l70ol:o`05oaco00Co;_l01Oloo`05oe7o00?oHol01Omeo`04ohOo00Go
VOl01?n[o`04okgo00Gocol01?oQo`04oo?o00CoooX01Oooj004oooG00CoolD01Oooool1o`00007o
oooo0Oooool000;ooooo0ol00005ooooo`?o00000oooool7o`3oL`Co0?n52?l0oiL8o`3oZ0Wo0?nj
2ol0ol`<o`3ogS_o0?o`3?l0omh6o`3oc0?o0?nj1ol0ojP4o`3oU`Go0?n50ol0og<5o`3oH@Go0?m?
1?l0ocd4o`3o:`Go0?lI1Ol0o`L3o`[o00Go7?l01?l^o`05ocoo00GoDOl00omSo`05ogGo00CoQol0
1OnIo`04oj_o00Co_Ol01Oo?o`03on7o00Golol01?oonP05oooX00CoomL01?ooa@001?oo/`3ooooo
ooooooooool3o`0000;ooooo00000ooooooo0000ooooo`02ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00oooool2o`3oH@Oo0?mc1?l0ohD9o`3oU`So0?nX2_l0okX;o`3oc0go0?oN
<Ol0oo0=o`3ogPWo0?o<0ol0okX7o`3oZ0Co0?nG1Ol0ohD4o`3oL`Co0?mQ1Ol0odl4o`3o?@Go0?l[
1?l0oaT5o`3o1`Co2_l01?lLo`05obko00Co?ol01OmAo`04of?o00CoMOl01?n7o`05oiWo00CoZol0
1?nmo`05oloo00?ohOl01Ooco`04oooj00GoonP01?ooe`04ooo500;ook<01Oooool1o`00007ooooo
0Oooool00003ooooool0003ooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`03ooooo`Co0?mQ1ol0og<5o`3oQ@So0?nG2Ol0ojP:o`3o^P_o0?o<4ol0omhPo`3ol1;o0?oN2ol0
ol`3o`3o^POo0?nX1Ol0oiL5o`3oQ@?o0?mc1Ol0of44o`3oC`Go0?lm1?l0ob/4o`3o6@Go0?l71?l:
o`04oaco00Go;_l01?loo`05oe7o00CoHol01?meo`04ohOo00GoVOl01?n[o`04okgo00Gocol00ooQ
o`05oo?o00CoooX01?ooj005oooG00CoolD00ooo/`05ooooo`7o00000Oooool1ooooo`000_ooool3
o`0000Gooooo00?o0000ooooooooool00oooool7o`3oH@Ko0?mc1_l0ohD8o`3oU`Wo0?nX2ol0okX?
o`3oc3Ko0?oN4Ol0ol`3o`3o^PSo0?nX1?l0oiL5o`3oQ@Co0?mc1?l0of45o`3oC`Co0?lm1?l0ob/5
o`3o6@Co0?l71?l:o`04oaco00Go;_l01?loo`05oe7o00CoHol01?meo`04ohOo00GoVOl01?n[o`04
okgo00Gocol00ooQo`05oo?o00CoooX01?ooj005oooG00CoolD01?oo/`05ooooo`7o00000Oooool1
ooooo`002_ooool00ol0003oooooooooo`03ooooo`;o0?m?1ol0of46o`3oL`Oo0?n52?l0oiL:o`3o
Z0_o0?nj5_l0ol`Po`3ogQSo0?o<1_l0okX7o`3oZ0Go0?nG1_l0ohD3o`3oL`Co0?mQ1Ol0odl4o`3o
?@Co0?l[1Ol0oaT4o`3o1`Go2_l01?lLo`04obko00Co?ol01OmAo`04of?o00CoMOl01?n7o`05oiWo
00CoZol01?nmo`05oloo00?ohOl01Ooco`04oooj00CoonP01Oooe`03ooo500Gook<000?ooj40oooo
ooooool00oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool4o`3oC`Oo
0?mQ1ol0og<7o`3oQ@So0?nG2_l0ojP;o`3o^Qko0?o<2_l0omhNo`3oc0[o0?nj1_l0ojP7o`3oU`Go
0?n50ol0og<5o`3oH@Go0?m?1?l0ocd4o`3o:`Co0?lI1?l0o`L5o`[o00Co7?l01?l^o`04ocoo00Go
DOl01?mSo`04ogGo00CoQol01?nIo`05oj_o00Co_Ol01Oo?o`03on7o00Golol01?oonP04oooX00Go
omL00oooa@05oonc00;ooj401Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool0
0oooool7o`3oC`Ko0?mQ1ol0og<8o`3oQ@So0?nG3?l0ojP>o`3o^SKo0?o<4Ol0okX4o`3oZ0Wo0?nG
1Ol0ohD4o`3oL`Co0?mQ1Ol0odl4o`3o?@Co0?l[1?l0oaT4o`3o1`Go2_l01?lLo`04obko00Co?ol0
1OmAo`04of?o00CoMOl01?n7o`04oiWo00GoZol01?nmo`05oloo00?ohOl01Ooco`04oooj00CoonP0
1?ooe`04ooo500Gook<00oooX@05ooooo`7o00000Oooool1ooooo`002_ooool00ol0003ooooooooo
o`03ooooo`;o0?lm1ol0odl6o`3oH@Oo0?mc2Ol0ohD9o`3oU`go0?nX4ol0okXQo`3oc1Ko0?nj2?l0
ojP:o`3oU`Ko0?n50ol0og<4o`3oH@Go0?m?1?l0ocd4o`3o:`Co0?lI1?l0o`L5o`[o00Co7?l01?l^
o`04ocoo00GoDOl01?mSo`04ogGo00CoQol01?nIo`05oj_o00Co_Ol01?o?o`04on7o00Golol01?oo
nP04oooX00CoomL01?ooa@05oonc00Cooj401Oooool1o`00007ooooo0Oooool000[ooooo00?o0000
ooooooooool00oooool4o`3o?@Oo0?m?1_l0of49o`3oL`Oo0?n52ol0oiL?o`3oZ1Wo0?nj2_l0ol`H
o`3o^Poo0?nX2ol0oiL5o`3oQ@?o0?mc1Ol0of45o`3oC`Co0?lm1?l0ob/4o`3o6@Co0?l71Ol:o`04
oaco00Co;_l01?loo`05oe7o00CoHol01?meo`04ohOo00CoVOl01On[o`04okgo00Cocol01?oQo`05
oo?o00CoooX01?ooj004oooG00CoolD01Ooo/`04oonQ0003oon?0?oooooooooo00?ooooo0Ol00001
ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo1_l0ocd7o`3oC`Oo0?mQ2Ol0og<7o`3o
Q@co0?nG4?l0ojPao`3o^Q3o0?nX3?l0oiL7o`3oQ@?o0?mc1_l0of44o`3oC`Go0?lm1?l0ob/4o`3o
6@Co0?l71Ol:o`04oaco00Co;_l01?loo`05oe7o00CoHol01?meo`04ohOo00CoVOl01?n[o`05okgo
00Cocol01?oQo`04oo?o00CoooX01Oooj004oooG00CoolD01?oo/`04oonQ00;oohl01Oooool1o`00
007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool2o`3o:`Oo0?lm1ol0odl6o`3oH@[o
0?mc2?l0ohD=o`3oUaCo0?nX8?l0okXCo`3oZ0go0?nG2Ol0ohD3o`3oL`Oo0?mQ1?l0odl4o`3o?@Go
0?l[1?l0oaT4o`3o1`Go2_l01OlLo`03obko00Co?ol01OmAo`04of?o00CoMOl01?n7o`04oiWo00Go
Zol01?nmo`04oloo00CohOl01?oco`04oooj00GoonP01?ooe`03ooo500Gook<01?ooX@03oon?00Go
oooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo1?l0ob/7o`3o?@So0?m?
1_l0of4;o`3oL`Oo0?n54?l0oiLko`3oZ13o0?nG2ol0ohD3o`3oL`Oo0?mQ1?l0odl4o`3o?@Go0?l[
1?l0oaT5o`3o1`Co2_l01OlLo`03obko00Co?ol01OmAo`04of?o00CoMOl01?n7o`04oiWo00GoZol0
1?nmo`04oloo00CohOl01?oco`04oooj00GoonP01?ooe`03ooo500Gook<01?ooX@03oon?0003oomm
0?oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooooooo00?ooooo0_l0
oaT5o`3o:`Ko0?lm2Ol0odl7o`3oH@_o0?mc2?l0ohD@o`3oUc7o0?nX4?l0oiL?o`3oQ@?o0?mc1_l0
of45o`3oC`Co0?lm1_l0ob/3o`3o6@Ko0?l71?l:o`04oaco00Co;_l00oloo`06oe7o00?oHol01?me
o`04ohOo00CoVOl01On[o`04okgo00Cocol01?oQo`04oo?o00CoooX01Oooj004oooG00?oolD01Ooo
/`04oonQ00?oohl00_ooO@05ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03
ooooo`Co0?lI1Ol0ob/7o`3o?@So0?m?2?l0of4;o`3oL`[o0?n55?l0oiLPo`3oZ1?o0?nG3_l0ohD7
o`3oL`Ko0?mQ1_l0odl4o`3o?@Ko0?l[1?l0oaT5o`3o1`Co2_l01?lLo`04obko00Co?ol01OmAo`04
of?o00?oMOl01On7o`03oiWo00GoZol01?nmo`04oloo00CohOl01?oco`04oooj00CoonP01Oooe`03
ooo500Gook<01?ooX@03oon?00?oogd01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000oooo
ooooool00oooool7o`3o6@Co0?l[2?l0ocd8o`3oC`Wo0?mQ2ol0og<?o`3oQCKo0?nG3_l0ohD>o`3o
L`Go0?mQ1ol0odl3o`3o?@So0?l[0ol0oaT6o`3o1`?o2_l01?lLo`04obko00Co?ol01OmAo`04of?o
00?oMOl01On7o`04oiWo00CoZol01?nmo`04oloo00CohOl01?oco`04oooj00CoonP01Oooe`03ooo5
00Cook<01OooX@03oon?00Coogd01Oooool1o`00007ooooo0Oooool000[ooooo0_l00004ooooo`;o
0?l71ol0oaT4o`3o:`Wo0?lm2?l0odl:o`3oH@_o0?mc5_l0ohDPo`3oUaGo0?n53_l0og<8o`3oH@Oo
0?m?0ol0ocd8o`3o:`?o0?lI1_l0o`L3o`[o00Go7?l01?l^o`03ocoo00GoDOl01?mSo`04ogGo00Co
Qol01?nIo`04oj_o00Co_Ol01Oo?o`03on7o00Colol01?oonP04oooX00GoomL00oooa@04oonc00Go
oj400oooS`04oomm0003oom[0?oooooooooo00;ooooo0_l00002ooooo`002_ooool00ol0003ooooo
ooooo`03ooooo`Co0?l71ol0oaT5o`3o:`Wo0?lm2?l0odl:o`3oH@_o0?mc7_l0ohD:o`3oUago0?n5
3?l0og<;o`3oH@Ko0?m?1Ol0ocd7o`3o:`Go0?lI1Ol0o`L4o`[o00Co7?l01?l^o`04ocoo00CoDOl0
1?mSo`04ogGo00CoQol01?nIo`04oj_o00Co_Ol01Oo?o`03on7o00Colol01?oonP04oooX00GoomL0
0oooa@04oonc00Gooj400oooS`04oomm00;oof/01Oooool1o`00007ooooo0Oooool000[ooooo00?o
0000ooooooooool00oooool7o`3o1`Ko0?lI1_l0ob/9o`3o?@So0?m?3?l0of4>o`3oLcKo0?n53Ol0
og<?o`3oH@Go0?m?1ol0ocd6o`3o:`Ko0?lI1Ol0o`L4o`[o00Co7?l01?l^o`04ocoo00CoDOl01?mS
o`04ogGo00CoQol01?nIo`04oj_o00Co_Ol01Oo?o`03on7o00Colol01?oonP04oooX00CoomL01?oo
a@04oonc00Gooj400oooS`04oomm00?oof/01Oooool1o`00007ooooo0Oooool000[ooooo00?o0000
ooooooooool00oooool3o`[o00Ko0?l71ol0oaT6o`3o:`Wo0?lm2_l0odl<o`3oHACo0?mc8?l0ohDC
o`3oL`oo0?mQ1ol0odl9o`3o?@Ko0?l[1_l0oaT5o`3o1`Co2_l01?lLo`04obko00Co?ol01?mAo`04
of?o00CoMOl01?n7o`04oiWo00CoZol01?nmo`05oloo00?ohOl01?oco`04oooj00CoonP01?ooe`04
ooo500Cook<01?ooX@04oon?00Coogd01?ooJ`05ooooo`7o00000Oooool1ooooo`002_ooool00ol0
003oooooooooo`03ooooo`Go2_l01_l0o`L8o`3o6@Oo0?l[2_l0ocd8o`3oC`oo0?mQ>ol0og<?o`3o
H@So0?m?2Ol0ocd9o`3o:`Oo0?lI1?l0o`L4o`[o00Go7?l01?l^o`03ocoo00GoDOl01?mSo`04ogGo
00CoQol01?nIo`04oj_o00Co_Ol01?o?o`04on7o00Colol01?oonP04oooX00CoomL01?ooa@04oonc
00Cooj401?ooS`04oomm00?oof/00_ooF@05ooooo`7o00000Oooool1ooooo`002_ooool00ol0003o
ooooooooo`03ooooo`;o7?l01Ol:o`06o`3o1`Wo0?lI1ol0ob/;o`3o?@So0?m?4?l0of4ao`3oLa3o
0?mQ2?l0odl8o`3o?@_o0?l[1ol0oaT6o`3o1`Co2_l01OlLo`04obko00?o?ol01_mAo`04of?o00Co
MOl01?n7o`04oiWo00CoZol01?nmo`04oloo00CohOl01?oco`04oooj00CoonP01?ooe`04ooo500Co
ok<01?ooX@04oon?00?oogd00oooJ`03oomI00Gooooo0Ol00001ooooo`7ooooo000:ooooo`03o`00
0?oooooooooo00?ooooo1?lLo`05o`[o00Oo0?l72?l0oaT8o`3o:`_o0?lm2_l0odlDo`3oHB3o0?mc
4ol0of4:o`3oC`So0?lm2Ol0ob/8o`3o6@So0?l71?l:o`06oaco00Co;_l00oloo`06oe7o00CoHol0
0omeo`05ohOo00CoVOl01?n[o`04okgo00Cocol01?oQo`04oo?o00GoooX00oooj004oooG00CoolD0
1?oo/`04oonQ00Coohl00oooO@03oom[00CooeT01Oooool1o`00007ooooo0Oooool000[ooooo00?o
0000ooooooooool00oooool7oaco00Co2_l02?l0o`L8o`3o6@Wo0?l[3?l0ocd>o`3oCcKo0?mQ3Ol0
odl:o`3o?@Oo0?l[2_l0oaT:o`3o1`Co2_l01OlLo`05obko00?o?ol01_mAo`04of?o00?oMOl01On7
o`04oiWo00CoZol01?nmo`04oloo00CohOl01?oco`05oooj00?oonP01?ooe`04ooo500Cook<01?oo
X@03oon?00Coogd00oooJ`04oomI0003oom70?oooooooooo00?ooooo0Ol00001ooooo`7ooooo000:
ooooo`03o`000?oooooooooo00?ooooo0_l^o`07oaco00Go2_l02?l0o`L8o`3o6@[o0?l[3Ol0ocdD
o`3oCb3o0?mQ4ol0odl<o`3o?@Ko0?l[2_l0oaT;o`3o1`Ko2_l01?lLo`06obko00;o?ol01omAo`04
of?o00?oMOl01On7o`04oiWo00GoZol00onmo`04oloo00CohOl01?oco`05oooj00?oonP01?ooe`04
ooo500Cook<01?ooX@03oon?00Coogd00oooJ`04oomI00;oodL01Oooool1o`00007ooooo0Oooool0
00[ooooo00?o0000ooooooooool00oooool4obko00Oo7?l01ol:o`07o`3o1`So0?lI2_l0ob/@o`3o
?AWo0?m?2_l0of4Ho`3oC`oo0?lm1_l0ob/9o`3o6@_o0?l72?l:o`04oaco00Oo;_l00_loo`06oe7o
00GoHol00omeo`06ohOo00?oVOl01On[o`04okgo00?ocol01OoQo`03oo?o00GoooX00oooj004oooG
00CoolD01?oo/`04oonQ00?oohl01?ooO@03oom[00CooeT00oooA`05ooooo`7o00000Oooool1oooo
o`002_ooool00ol0003oooooooooo`03ooooo`Oo;_l01_lLo`08o`[o00So0?l72?l0oaT;o`3o:a3o
0?lm<Ol0odl@o`3o?@Oo0?l[2Ol0oaT;o`3o1`[o2_l01?lLo`07obko00;o?ol01OmAo`06of?o00?o
MOl01_n7o`03oiWo00GoZol01?nmo`03oloo00GohOl01?oco`04oooj00CoonP01?ooe`03ooo500Co
ok<01?ooX@03oon?00?oogd01?ooJ`03oomI00CoodL000?oocD0ooooooooool00oooool1o`00007o
oooo0Oooool000[ooooo00?o0000ooooooooool00oooool2ocoo00Oo;_l01olLo`08o`[o00So0?l7
2_l0oaT;o`3o:aCo0?lm8?l0odlCo`3o?@Wo0?l[2Ol0oaT:o`3o1`[o2_l01_lLo`07obko00?o?ol0
1OmAo`06of?o00?oMOl01On7o`05oiWo00CoZol01?nmo`04oloo00CohOl01?oco`04oooj00CoonP0
1?ooe`03ooo500Cook<01?ooX@03oon?00?oogd01?ooJ`03oomI00CoodL00_oo=@05ooooo`7o0000
0Oooool1ooooo`002_ooool00ol0003oooooooooo`03ooooo`Go?ol01_l^o`08oaco00So2_l02Ol0
o`L<o`3o6@ko0?l[=_l0ocd=o`3o:`[o0?lI2Ol0o`L9o`[o00Wo7?l01_l^o`05ocoo00CoDOl01omS
o`03ogGo00GoQol01OnIo`04oj_o00Co_Ol01?o?o`04on7o00Colol01?oonP04oooX00CoomL00ooo
a@04oonc00Cooj400oooS`03oomm00Coof/00_ooF@04oom700?oocD000?oob<0ooooooooool00ooo
ool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool2oe7o00Ko?ol01_l^o`08
oaco00So2_l02_l0o`L=o`3o6ACo0?l[8?l0ocdCo`3o:`co0?lI2Ol0o`L8o`[o00[o7?l01_l^o`06
ocoo00CoDOl01omSo`04ogGo00GoQol01OnIo`04oj_o00Co_Ol01?o?o`04on7o00Colol01?oonP04
oooX00CoomL00oooa@04oonc00Cooj400oooS`03oomm00?oof/00oooF@03oom700?oocD00ooo8`05
ooooo`7o00000Oooool1ooooo`002_ooool2o`0000Cooooo1OmAo`06ocoo00Ko;_l02?lLo`08o`[o
00[o0?l73ol0oaTJo`3o:`[o0?lm6Ol0ob/>o`3o6@Wo0?l72Ol:o`08oaco00Oo;_l01_loo`06oe7o
00GoHol01_meo`05ohOo00GoVOl01?n[o`04okgo00Cocol01?oQo`04oo?o00CoooX01?ooj003oooG
00CoolD01?oo/`03oonQ00Coohl00oooO@03oom[00?ooeT00oooA`03oole00?oob<000?ooa40oooo
ooooool00_ooool2o`0000;ooooo000:ooooo`03o`000?oooooooooo0?oooooo4Oooool1o`00007o
oooo0Oooool000[ooooo00?o0000ooooooooool0oooooolAooooo`7o00000Oooool1ooooo`002_oo
ool00ol0003oooooooooo`3ooooooa7ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool00_ooool1o`00007ooooo0Oooool000[oooooool0000Eo`00
00;ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.550592, -0.603858, 0.0340901, \
0.0340901}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[Zimmermann[x1, x2], {{x1, 2}, {x2, \ 1. }}]\)], "Input"],

Cell[BoxData[
    RowBox[{\(FindMinimum::"lstol"\), \(\(:\)\(\ \)\), "\<\"The line search \
decreased the step size to within tolerance specified by AccuracyGoal and \
PrecisionGoal but was unable to find a sufficient decrease in the function.  \
You may need more than \\!\\(MachinePrecision\\) digits of working precision \
to meet these tolerances. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"FindMinimum::lstol\\\"]\\)\"\>"}]], "Message"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.467273 0.243252 -0.224021 0.243252 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.26248 -0.0125 -3 -9 ]
[.26248 -0.0125 3 0 ]
[.50574 -0.0125 -3 -9 ]
[.50574 -0.0125 3 0 ]
[.74899 -0.0125 -3 -9 ]
[.74899 -0.0125 3 0 ]
[.99224 -0.0125 -3 -9 ]
[.99224 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .26248 -6 -4.5 ]
[-0.0125 .26248 0 4.5 ]
[-0.0125 .50574 -6 -4.5 ]
[-0.0125 .50574 0 4.5 ]
[-0.0125 .74899 -6 -4.5 ]
[-0.0125 .74899 0 4.5 ]
[-0.0125 .99224 -6 -4.5 ]
[-0.0125 .99224 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(2)] .01923 -0.0125 0 1 Mshowa
.26248 0 m
.26248 .00625 L
s
[(3)] .26248 -0.0125 0 1 Mshowa
.50574 0 m
.50574 .00625 L
s
[(4)] .50574 -0.0125 0 1 Mshowa
.74899 0 m
.74899 .00625 L
s
[(5)] .74899 -0.0125 0 1 Mshowa
.99224 0 m
.99224 .00625 L
s
[(6)] .99224 -0.0125 0 1 Mshowa
.125 Mabswid
.06788 0 m
.06788 .00375 L
s
.11653 0 m
.11653 .00375 L
s
.16518 0 m
.16518 .00375 L
s
.21383 0 m
.21383 .00375 L
s
.31113 0 m
.31113 .00375 L
s
.35978 0 m
.35978 .00375 L
s
.40843 0 m
.40843 .00375 L
s
.45708 0 m
.45708 .00375 L
s
.55439 0 m
.55439 .00375 L
s
.60304 0 m
.60304 .00375 L
s
.65169 0 m
.65169 .00375 L
s
.70034 0 m
.70034 .00375 L
s
.79764 0 m
.79764 .00375 L
s
.84629 0 m
.84629 .00375 L
s
.89494 0 m
.89494 .00375 L
s
.94359 0 m
.94359 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(1)] -0.0125 .01923 1 0 Mshowa
0 .26248 m
.00625 .26248 L
s
[(2)] -0.0125 .26248 1 0 Mshowa
0 .50574 m
.00625 .50574 L
s
[(3)] -0.0125 .50574 1 0 Mshowa
0 .74899 m
.00625 .74899 L
s
[(4)] -0.0125 .74899 1 0 Mshowa
0 .99224 m
.00625 .99224 L
s
[(5)] -0.0125 .99224 1 0 Mshowa
.125 Mabswid
0 .06788 m
.00375 .06788 L
s
0 .11653 m
.00375 .11653 L
s
0 .16518 m
.00375 .16518 L
s
0 .21383 m
.00375 .21383 L
s
0 .31113 m
.00375 .31113 L
s
0 .35978 m
.00375 .35978 L
s
0 .40843 m
.00375 .40843 L
s
0 .45708 m
.00375 .45708 L
s
0 .55439 m
.00375 .55439 L
s
0 .60304 m
.00375 .60304 L
s
0 .65169 m
.00375 .65169 L
s
0 .70034 m
.00375 .70034 L
s
0 .79764 m
.00375 .79764 L
s
0 .84629 m
.00375 .84629 L
s
0 .89494 m
.00375 .89494 L
s
0 .94359 m
.00375 .94359 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.26248 .99375 m
.26248 1 L
s
.50574 .99375 m
.50574 1 L
s
.74899 .99375 m
.74899 1 L
s
.99224 .99375 m
.99224 1 L
s
.125 Mabswid
.06788 .99625 m
.06788 1 L
s
.11653 .99625 m
.11653 1 L
s
.16518 .99625 m
.16518 1 L
s
.21383 .99625 m
.21383 1 L
s
.31113 .99625 m
.31113 1 L
s
.35978 .99625 m
.35978 1 L
s
.40843 .99625 m
.40843 1 L
s
.45708 .99625 m
.45708 1 L
s
.55439 .99625 m
.55439 1 L
s
.60304 .99625 m
.60304 1 L
s
.65169 .99625 m
.65169 1 L
s
.70034 .99625 m
.70034 1 L
s
.79764 .99625 m
.79764 1 L
s
.84629 .99625 m
.84629 1 L
s
.89494 .99625 m
.89494 1 L
s
.94359 .99625 m
.94359 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .26248 m
1 .26248 L
s
.99375 .50574 m
1 .50574 L
s
.99375 .74899 m
1 .74899 L
s
.99375 .99224 m
1 .99224 L
s
.125 Mabswid
.99625 .06788 m
1 .06788 L
s
.99625 .11653 m
1 .11653 L
s
.99625 .16518 m
1 .16518 L
s
.99625 .21383 m
1 .21383 L
s
.99625 .31113 m
1 .31113 L
s
.99625 .35978 m
1 .35978 L
s
.99625 .40843 m
1 .40843 L
s
.99625 .45708 m
1 .45708 L
s
.99625 .55439 m
1 .55439 L
s
.99625 .60304 m
1 .60304 L
s
.99625 .65169 m
1 .65169 L
s
.99625 .70034 m
1 .70034 L
s
.99625 .79764 m
1 .79764 L
s
.99625 .84629 m
1 .84629 L
s
.99625 .89494 m
1 .89494 L
s
.99625 .94359 m
1 .94359 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.925 g
.98077 .37518 m
.97256 .37859 L
.97106 .37922 L
.96134 .38333 L
.95163 .38748 L
.94972 .38831 L
.94192 .3917 L
.93221 .39597 L
.9276 .39802 L
.92249 .4003 L
.91278 .4047 L
.90615 .40773 L
.90307 .40915 L
.89336 .41367 L
.88536 .41744 L
.88364 .41826 L
.87393 .42291 L
.86518 .42716 L
.86422 .42763 L
.85451 .43242 L
.8456 .43687 L
.84479 .43728 L
.83508 .44221 L
.82659 .44658 L
.82537 .44721 L
.81566 .4523 L
.80812 .45629 L
.80594 .45745 L
.79623 .46269 L
.79016 .46601 L
.78652 .46801 L
.77681 .47342 L
.77271 .47572 L
.76709 .4789 L
.75738 .48448 L
.75574 .48543 L
.74767 .49014 L
.73922 .49514 L
.73796 .4959 L
.72824 .50175 L
.72314 .50486 L
.71853 .50769 L
.70882 .51373 L
.70749 .51457 L
.69911 .51988 L
.69224 .52428 L
.68939 .52612 L
.67968 .53247 L
.67738 .53399 L
.66997 .53894 L
.6629 .54371 L
.66026 .54551 L
.65054 .55219 L
.64878 .55342 L
.64083 .559 L
.63501 .56313 L
.63112 .56592 L
.62158 .57284 L
.62141 .57297 L
.61169 .58014 L
.60847 .58256 L
.60198 .58745 L
.59567 .59227 L
.59227 .59489 L
.58317 .60198 L
.58256 .60246 L
.57284 .61018 L
.57096 .61169 L
.56313 .61804 L
.55903 .62141 L
.55342 .62606 L
.54738 .63112 L
.54371 .63422 L
.53598 .64083 L
.53399 .64255 L
.52484 .65054 L
.52428 .65104 L
.51457 .65969 L
.51394 .66026 L
.50486 .66852 L
.50328 .66997 L
.49514 .67753 L
.49285 .67968 L
.48543 .68672 L
.48264 .68939 L
.47572 .6961 L
.47265 .69911 L
.46601 .70568 L
.46286 .70882 L
.45629 .71545 L
.45328 .71853 L
.44658 .72544 L
.44389 .72824 L
.43687 .73564 L
.43469 .73796 L
.42716 .74606 L
.42567 .74767 L
.41744 .75671 L
.41684 .75738 L
.40817 .76709 L
.40773 .76759 L
.39968 .77681 L
.39802 .77872 L
.39134 .78652 L
.38831 .79011 L
.38317 .79623 L
.37859 .80175 L
.37515 .80594 L
.36888 .81367 L
.36728 .81566 L
.35956 .82537 L
.35917 .82586 L
.35197 .83508 L
.34946 .83835 L
.34453 .84479 L
.33974 .85113 L
.33722 .85451 L
.33004 .86422 L
.33003 .86423 L
.32299 .87393 L
.32032 .87765 L
.31606 .88364 L
.31061 .8914 L
.30925 .89336 L
.30256 .90307 L
.30089 .90551 L
.29598 .91278 L
.29118 .91997 L
.28951 .92249 L
.28316 .93221 L
.28147 .93481 L
.2769 .94192 L
.27176 .95004 L
.27076 .95163 L
.26471 .96134 L
.26204 .96568 L
.25876 .97106 L
.25291 .98077 L
.98077 .98077 L
F
0 g
.98077 .37518 m
.97256 .37859 L
.97106 .37922 L
.96134 .38333 L
.95163 .38748 L
.94972 .38831 L
.94192 .3917 L
.93221 .39597 L
.9276 .39802 L
.92249 .4003 L
.91278 .4047 L
.90615 .40773 L
.90307 .40915 L
.89336 .41367 L
.88536 .41744 L
.88364 .41826 L
.87393 .42291 L
.86518 .42716 L
.86422 .42763 L
.85451 .43242 L
.8456 .43687 L
.84479 .43728 L
.83508 .44221 L
.82659 .44658 L
.82537 .44721 L
.81566 .4523 L
.80812 .45629 L
.80594 .45745 L
.79623 .46269 L
.79016 .46601 L
.78652 .46801 L
.77681 .47342 L
.77271 .47572 L
.76709 .4789 L
.75738 .48448 L
.75574 .48543 L
.74767 .49014 L
.73922 .49514 L
.73796 .4959 L
.72824 .50175 L
.72314 .50486 L
.71853 .50769 L
.70882 .51373 L
.70749 .51457 L
.69911 .51988 L
.69224 .52428 L
.68939 .52612 L
.67968 .53247 L
.67738 .53399 L
.66997 .53894 L
Mistroke
.6629 .54371 L
.66026 .54551 L
.65054 .55219 L
.64878 .55342 L
.64083 .559 L
.63501 .56313 L
.63112 .56592 L
.62158 .57284 L
.62141 .57297 L
.61169 .58014 L
.60847 .58256 L
.60198 .58745 L
.59567 .59227 L
.59227 .59489 L
.58317 .60198 L
.58256 .60246 L
.57284 .61018 L
.57096 .61169 L
.56313 .61804 L
.55903 .62141 L
.55342 .62606 L
.54738 .63112 L
.54371 .63422 L
.53598 .64083 L
.53399 .64255 L
.52484 .65054 L
.52428 .65104 L
.51457 .65969 L
.51394 .66026 L
.50486 .66852 L
.50328 .66997 L
.49514 .67753 L
.49285 .67968 L
.48543 .68672 L
.48264 .68939 L
.47572 .6961 L
.47265 .69911 L
.46601 .70568 L
.46286 .70882 L
.45629 .71545 L
.45328 .71853 L
.44658 .72544 L
.44389 .72824 L
.43687 .73564 L
.43469 .73796 L
.42716 .74606 L
.42567 .74767 L
.41744 .75671 L
.41684 .75738 L
.40817 .76709 L
Mistroke
.40773 .76759 L
.39968 .77681 L
.39802 .77872 L
.39134 .78652 L
.38831 .79011 L
.38317 .79623 L
.37859 .80175 L
.37515 .80594 L
.36888 .81367 L
.36728 .81566 L
.35956 .82537 L
.35917 .82586 L
.35197 .83508 L
.34946 .83835 L
.34453 .84479 L
.33974 .85113 L
.33722 .85451 L
.33004 .86422 L
.33003 .86423 L
.32299 .87393 L
.32032 .87765 L
.31606 .88364 L
.31061 .8914 L
.30925 .89336 L
.30256 .90307 L
.30089 .90551 L
.29598 .91278 L
.29118 .91997 L
.28951 .92249 L
.28316 .93221 L
.28147 .93481 L
.2769 .94192 L
.27176 .95004 L
.27076 .95163 L
.26471 .96134 L
.26204 .96568 L
.25876 .97106 L
.25291 .98077 L
Mfstroke
.85 g
.98077 .41192 m
.97106 .41621 L
.96829 .41744 L
.96134 .42056 L
.95163 .42497 L
.94688 .42716 L
.94192 .42945 L
.93221 .43398 L
.9261 .43687 L
.92249 .43858 L
.91278 .44324 L
.90592 .44658 L
.90307 .44797 L
.89336 .45277 L
.88631 .45629 L
.88364 .45764 L
.87393 .46257 L
.86726 .46601 L
.86422 .46758 L
.85451 .47266 L
.84873 .47572 L
.84479 .47782 L
.83508 .48305 L
.83072 .48543 L
.82537 .48837 L
.81566 .49376 L
.81319 .49514 L
.80594 .49924 L
.79623 .5048 L
.79613 .50486 L
.78652 .51044 L
.77951 .51457 L
.77681 .51618 L
.76709 .522 L
.76333 .52428 L
.75738 .52792 L
.74767 .53393 L
.74756 .53399 L
.73796 .54004 L
.73219 .54371 L
.72824 .54624 L
.71853 .55255 L
.71721 .55342 L
.70882 .55896 L
.70259 .56313 L
.69911 .56548 L
.68939 .57211 L
.68833 .57284 L
.67968 .57886 L
.67442 .58256 L
.66997 .58571 L
.66083 .59227 L
.66026 .59269 L
.65054 .59978 L
.64757 .60198 L
.64083 .607 L
.63461 .61169 L
.63112 .61435 L
.62195 .62141 L
.62141 .62183 L
.61169 .62945 L
.60958 .63112 L
.60198 .6372 L
.59749 .64083 L
.59227 .64509 L
.58567 .65054 L
.58256 .65313 L
.5741 .66026 L
.57284 .66132 L
.56313 .66967 L
.56279 .66997 L
.55342 .67817 L
.55172 .67968 L
.54371 .68684 L
.54088 .68939 L
.53399 .69568 L
.53027 .69911 L
.52428 .70469 L
.51989 .70882 L
.51457 .71387 L
.50972 .71853 L
.50486 .72324 L
.49975 .72824 L
.49514 .7328 L
.48999 .73796 L
.48543 .74256 L
.48042 .74767 L
.47572 .75251 L
.47104 .75738 L
.46601 .76268 L
.46185 .76709 L
.45629 .77305 L
.45283 .77681 L
.44658 .78365 L
.44399 .78652 L
.43687 .79447 L
.43531 .79623 L
.42716 .80553 L
.4268 .80594 L
.41845 .81566 L
.41744 .81684 L
.41025 .82537 L
.40773 .82839 L
.4022 .83508 L
.39802 .8402 L
.3943 .84479 L
.38831 .85228 L
.38654 .85451 L
.37892 .86422 L
.37859 .86464 L
.37144 .87393 L
.36888 .87729 L
.36408 .88364 L
.35917 .89023 L
.35686 .89336 L
.34975 .90307 L
.34946 .90348 L
.34277 .91278 L
.33974 .91705 L
.33591 .92249 L
.33003 .93095 L
.32916 .93221 L
.32253 .94192 L
.32032 .94519 L
.31601 .95163 L
.31061 .95979 L
.30959 .96134 L
.30327 .97106 L
.30089 .97476 L
.29706 .98077 L
.98077 .98077 L
F
0 g
.98077 .41192 m
.97106 .41621 L
.96829 .41744 L
.96134 .42056 L
.95163 .42497 L
.94688 .42716 L
.94192 .42945 L
.93221 .43398 L
.9261 .43687 L
.92249 .43858 L
.91278 .44324 L
.90592 .44658 L
.90307 .44797 L
.89336 .45277 L
.88631 .45629 L
.88364 .45764 L
.87393 .46257 L
.86726 .46601 L
.86422 .46758 L
.85451 .47266 L
.84873 .47572 L
.84479 .47782 L
.83508 .48305 L
.83072 .48543 L
.82537 .48837 L
.81566 .49376 L
.81319 .49514 L
.80594 .49924 L
.79623 .5048 L
.79613 .50486 L
.78652 .51044 L
.77951 .51457 L
.77681 .51618 L
.76709 .522 L
.76333 .52428 L
.75738 .52792 L
.74767 .53393 L
.74756 .53399 L
.73796 .54004 L
.73219 .54371 L
.72824 .54624 L
.71853 .55255 L
.71721 .55342 L
.70882 .55896 L
.70259 .56313 L
.69911 .56548 L
.68939 .57211 L
.68833 .57284 L
.67968 .57886 L
.67442 .58256 L
Mistroke
.66997 .58571 L
.66083 .59227 L
.66026 .59269 L
.65054 .59978 L
.64757 .60198 L
.64083 .607 L
.63461 .61169 L
.63112 .61435 L
.62195 .62141 L
.62141 .62183 L
.61169 .62945 L
.60958 .63112 L
.60198 .6372 L
.59749 .64083 L
.59227 .64509 L
.58567 .65054 L
.58256 .65313 L
.5741 .66026 L
.57284 .66132 L
.56313 .66967 L
.56279 .66997 L
.55342 .67817 L
.55172 .67968 L
.54371 .68684 L
.54088 .68939 L
.53399 .69568 L
.53027 .69911 L
.52428 .70469 L
.51989 .70882 L
.51457 .71387 L
.50972 .71853 L
.50486 .72324 L
.49975 .72824 L
.49514 .7328 L
.48999 .73796 L
.48543 .74256 L
.48042 .74767 L
.47572 .75251 L
.47104 .75738 L
.46601 .76268 L
.46185 .76709 L
.45629 .77305 L
.45283 .77681 L
.44658 .78365 L
.44399 .78652 L
.43687 .79447 L
.43531 .79623 L
.42716 .80553 L
.4268 .80594 L
.41845 .81566 L
Mistroke
.41744 .81684 L
.41025 .82537 L
.40773 .82839 L
.4022 .83508 L
.39802 .8402 L
.3943 .84479 L
.38831 .85228 L
.38654 .85451 L
.37892 .86422 L
.37859 .86464 L
.37144 .87393 L
.36888 .87729 L
.36408 .88364 L
.35917 .89023 L
.35686 .89336 L
.34975 .90307 L
.34946 .90348 L
.34277 .91278 L
.33974 .91705 L
.33591 .92249 L
.33003 .93095 L
.32916 .93221 L
.32253 .94192 L
.32032 .94519 L
.31601 .95163 L
.31061 .95979 L
.30959 .96134 L
.30327 .97106 L
.30089 .97476 L
.29706 .98077 L
Mfstroke
.775 g
.98077 .44865 m
.97106 .4532 L
.96451 .45629 L
.96134 .4578 L
.95163 .46247 L
.94435 .46601 L
.94192 .4672 L
.93221 .47199 L
.92476 .47572 L
.92249 .47686 L
.91278 .48179 L
.9057 .48543 L
.90307 .48679 L
.89336 .49187 L
.88716 .49514 L
.88364 .49702 L
.87393 .50224 L
.86911 .50486 L
.86422 .50753 L
.85451 .51291 L
.85154 .51457 L
.84479 .51836 L
.83508 .5239 L
.83442 .52428 L
.82537 .52952 L
.81774 .53399 L
.81566 .53523 L
.80594 .54102 L
.80148 .54371 L
.79623 .5469 L
.78652 .55287 L
.78563 .55342 L
.77681 .55894 L
.77017 .56313 L
.76709 .5651 L
.75738 .57135 L
.75509 .57284 L
.74767 .57771 L
.74037 .58256 L
.73796 .58417 L
.72824 .59074 L
.726 .59227 L
.71853 .59741 L
.71197 .60198 L
.70882 .6042 L
.69911 .61109 L
.69827 .61169 L
.68939 .61811 L
.68488 .62141 L
.67968 .62524 L
.67179 .63112 L
.66997 .63249 L
.66026 .63987 L
.659 .64083 L
.65054 .64737 L
.64649 .65054 L
.64083 .65501 L
.63426 .66026 L
.63112 .66278 L
.62229 .66997 L
.62141 .6707 L
.61169 .67875 L
.61058 .67968 L
.60198 .68695 L
.59912 .68939 L
.59227 .6953 L
.5879 .69911 L
.58256 .70381 L
.57691 .70882 L
.57284 .71247 L
.56615 .71853 L
.56313 .7213 L
.55561 .72824 L
.55342 .73029 L
.54529 .73796 L
.54371 .73946 L
.53517 .74767 L
.53399 .74881 L
.52525 .75738 L
.52428 .75834 L
.51552 .76709 L
.51457 .76805 L
.50598 .77681 L
.50486 .77797 L
.49663 .78652 L
.49514 .78808 L
.48745 .79623 L
.48543 .79839 L
.47845 .80594 L
.47572 .80893 L
.46961 .81566 L
.46601 .81968 L
.46094 .82537 L
.45629 .83065 L
.45243 .83508 L
.44658 .84186 L
.44407 .84479 L
.43687 .85331 L
.43587 .85451 L
.42781 .86422 L
.42716 .86501 L
.41989 .87393 L
.41744 .87696 L
.41211 .88364 L
.40773 .88919 L
.40446 .89336 L
.39802 .90168 L
.39695 .90307 L
.38957 .91278 L
.38831 .91446 L
.38231 .92249 L
.37859 .92753 L
.37517 .93221 L
.36888 .94091 L
.36816 .94192 L
.36125 .95163 L
.35917 .9546 L
.35447 .96134 L
.34946 .96861 L
.34779 .97106 L
.34122 .98077 L
.98077 .98077 L
F
0 g
.98077 .44865 m
.97106 .4532 L
.96451 .45629 L
.96134 .4578 L
.95163 .46247 L
.94435 .46601 L
.94192 .4672 L
.93221 .47199 L
.92476 .47572 L
.92249 .47686 L
.91278 .48179 L
.9057 .48543 L
.90307 .48679 L
.89336 .49187 L
.88716 .49514 L
.88364 .49702 L
.87393 .50224 L
.86911 .50486 L
.86422 .50753 L
.85451 .51291 L
.85154 .51457 L
.84479 .51836 L
.83508 .5239 L
.83442 .52428 L
.82537 .52952 L
.81774 .53399 L
.81566 .53523 L
.80594 .54102 L
.80148 .54371 L
.79623 .5469 L
.78652 .55287 L
.78563 .55342 L
.77681 .55894 L
.77017 .56313 L
.76709 .5651 L
.75738 .57135 L
.75509 .57284 L
.74767 .57771 L
.74037 .58256 L
.73796 .58417 L
.72824 .59074 L
.726 .59227 L
.71853 .59741 L
.71197 .60198 L
.70882 .6042 L
.69911 .61109 L
.69827 .61169 L
.68939 .61811 L
.68488 .62141 L
.67968 .62524 L
Mistroke
.67179 .63112 L
.66997 .63249 L
.66026 .63987 L
.659 .64083 L
.65054 .64737 L
.64649 .65054 L
.64083 .65501 L
.63426 .66026 L
.63112 .66278 L
.62229 .66997 L
.62141 .6707 L
.61169 .67875 L
.61058 .67968 L
.60198 .68695 L
.59912 .68939 L
.59227 .6953 L
.5879 .69911 L
.58256 .70381 L
.57691 .70882 L
.57284 .71247 L
.56615 .71853 L
.56313 .7213 L
.55561 .72824 L
.55342 .73029 L
.54529 .73796 L
.54371 .73946 L
.53517 .74767 L
.53399 .74881 L
.52525 .75738 L
.52428 .75834 L
.51552 .76709 L
.51457 .76805 L
.50598 .77681 L
.50486 .77797 L
.49663 .78652 L
.49514 .78808 L
.48745 .79623 L
.48543 .79839 L
.47845 .80594 L
.47572 .80893 L
.46961 .81566 L
.46601 .81968 L
.46094 .82537 L
.45629 .83065 L
.45243 .83508 L
.44658 .84186 L
.44407 .84479 L
.43687 .85331 L
.43587 .85451 L
.42781 .86422 L
Mistroke
.42716 .86501 L
.41989 .87393 L
.41744 .87696 L
.41211 .88364 L
.40773 .88919 L
.40446 .89336 L
.39802 .90168 L
.39695 .90307 L
.38957 .91278 L
.38831 .91446 L
.38231 .92249 L
.37859 .92753 L
.37517 .93221 L
.36888 .94091 L
.36816 .94192 L
.36125 .95163 L
.35917 .9546 L
.35447 .96134 L
.34946 .96861 L
.34779 .97106 L
.34122 .98077 L
Mfstroke
.7 g
.98077 .48539 m
.98068 .48543 L
.97106 .49018 L
.96134 .49504 L
.96113 .49514 L
.95163 .49996 L
.9421 .50486 L
.94192 .50495 L
.93221 .51001 L
.92356 .51457 L
.92249 .51514 L
.91278 .52034 L
.90551 .52428 L
.90307 .52561 L
.89336 .53097 L
.88792 .53399 L
.88364 .53639 L
.87393 .5419 L
.87078 .54371 L
.86422 .54749 L
.85451 .55316 L
.85406 .55342 L
.84479 .55891 L
.83776 .56313 L
.83508 .56475 L
.82537 .57067 L
.82185 .57284 L
.81566 .57669 L
.80633 .58256 L
.80594 .5828 L
.79623 .589 L
.79117 .59227 L
.78652 .5953 L
.77681 .6017 L
.77638 .60198 L
.76709 .60819 L
.76192 .61169 L
.75738 .61479 L
.7478 .62141 L
.74767 .6215 L
.73796 .62831 L
.734 .63112 L
.72824 .63524 L
.72051 .64083 L
.71853 .64227 L
.70882 .64943 L
.70732 .65054 L
.69911 .6567 L
.69442 .66026 L
.68939 .6641 L
.6818 .66997 L
.67968 .67162 L
.66997 .67927 L
.66945 .67968 L
.66026 .68705 L
.65736 .68939 L
.65054 .69496 L
.64553 .69911 L
.64083 .70302 L
.63394 .70882 L
.63112 .71122 L
.62259 .71853 L
.62141 .71956 L
.61169 .72805 L
.61148 .72824 L
.60198 .7367 L
.60059 .73796 L
.59227 .74551 L
.58991 .74767 L
.58256 .75448 L
.57945 .75738 L
.57284 .76362 L
.56919 .76709 L
.56313 .77292 L
.55913 .77681 L
.55342 .78241 L
.54927 .78652 L
.54371 .79208 L
.53959 .79623 L
.53399 .80194 L
.5301 .80594 L
.52428 .81199 L
.52078 .81566 L
.51457 .82223 L
.51164 .82537 L
.50486 .83269 L
.50266 .83508 L
.49514 .84335 L
.49384 .84479 L
.48543 .85423 L
.48519 .85451 L
.47669 .86422 L
.47572 .86534 L
.46834 .87393 L
.46601 .87668 L
.46013 .88364 L
.45629 .88825 L
.45207 .89336 L
.44658 .90007 L
.44415 .90307 L
.43687 .91215 L
.43636 .91278 L
.42871 .92249 L
.42716 .92448 L
.42118 .93221 L
.41744 .93709 L
.41378 .94192 L
.40773 .94998 L
.4065 .95163 L
.39934 .96134 L
.39802 .96316 L
.3923 .97106 L
.38831 .97664 L
.38537 .98077 L
.98077 .98077 L
F
0 g
.98077 .48539 m
.98068 .48543 L
.97106 .49018 L
.96134 .49504 L
.96113 .49514 L
.95163 .49996 L
.9421 .50486 L
.94192 .50495 L
.93221 .51001 L
.92356 .51457 L
.92249 .51514 L
.91278 .52034 L
.90551 .52428 L
.90307 .52561 L
.89336 .53097 L
.88792 .53399 L
.88364 .53639 L
.87393 .5419 L
.87078 .54371 L
.86422 .54749 L
.85451 .55316 L
.85406 .55342 L
.84479 .55891 L
.83776 .56313 L
.83508 .56475 L
.82537 .57067 L
.82185 .57284 L
.81566 .57669 L
.80633 .58256 L
.80594 .5828 L
.79623 .589 L
.79117 .59227 L
.78652 .5953 L
.77681 .6017 L
.77638 .60198 L
.76709 .60819 L
.76192 .61169 L
.75738 .61479 L
.7478 .62141 L
.74767 .6215 L
.73796 .62831 L
.734 .63112 L
.72824 .63524 L
.72051 .64083 L
.71853 .64227 L
.70882 .64943 L
.70732 .65054 L
.69911 .6567 L
.69442 .66026 L
.68939 .6641 L
Mistroke
.6818 .66997 L
.67968 .67162 L
.66997 .67927 L
.66945 .67968 L
.66026 .68705 L
.65736 .68939 L
.65054 .69496 L
.64553 .69911 L
.64083 .70302 L
.63394 .70882 L
.63112 .71122 L
.62259 .71853 L
.62141 .71956 L
.61169 .72805 L
.61148 .72824 L
.60198 .7367 L
.60059 .73796 L
.59227 .74551 L
.58991 .74767 L
.58256 .75448 L
.57945 .75738 L
.57284 .76362 L
.56919 .76709 L
.56313 .77292 L
.55913 .77681 L
.55342 .78241 L
.54927 .78652 L
.54371 .79208 L
.53959 .79623 L
.53399 .80194 L
.5301 .80594 L
.52428 .81199 L
.52078 .81566 L
.51457 .82223 L
.51164 .82537 L
.50486 .83269 L
.50266 .83508 L
.49514 .84335 L
.49384 .84479 L
.48543 .85423 L
.48519 .85451 L
.47669 .86422 L
.47572 .86534 L
.46834 .87393 L
.46601 .87668 L
.46013 .88364 L
.45629 .88825 L
.45207 .89336 L
.44658 .90007 L
.44415 .90307 L
Mistroke
.43687 .91215 L
.43636 .91278 L
.42871 .92249 L
.42716 .92448 L
.42118 .93221 L
.41744 .93709 L
.41378 .94192 L
.40773 .94998 L
.4065 .95163 L
.39934 .96134 L
.39802 .96316 L
.3923 .97106 L
.38831 .97664 L
.38537 .98077 L
Mfstroke
.625 g
.98077 .52213 m
.9766 .52428 L
.97106 .52717 L
.96134 .53227 L
.9581 .53399 L
.95163 .53745 L
.94192 .5427 L
.94007 .54371 L
.93221 .54802 L
.92249 .55341 L
.92249 .55342 L
.91278 .55889 L
.90534 .56313 L
.90307 .56443 L
.89336 .57006 L
.88861 .57284 L
.88364 .57577 L
.87393 .58156 L
.87228 .58256 L
.86422 .58744 L
.85634 .59227 L
.85451 .5934 L
.84479 .59945 L
.84078 .60198 L
.83508 .60559 L
.82558 .61169 L
.82537 .61183 L
.81566 .61816 L
.81072 .62141 L
.80594 .62458 L
.79623 .6311 L
.79621 .63112 L
.78652 .63773 L
.78202 .64083 L
.77681 .64446 L
.76815 .65054 L
.76709 .65129 L
.75738 .65823 L
.75458 .66026 L
.74767 .66528 L
.7413 .66997 L
.73796 .67245 L
.72831 .67968 L
.72824 .67973 L
.71853 .68714 L
.7156 .68939 L
.70882 .69466 L
.70315 .69911 L
.69911 .70231 L
.69097 .70882 L
.68939 .71009 L
.67968 .718 L
.67903 .71853 L
.66997 .72604 L
.66734 .72824 L
.66026 .73423 L
.65589 .73796 L
.65054 .74255 L
.64466 .74767 L
.64083 .75103 L
.63366 .75738 L
.63112 .75965 L
.62287 .76709 L
.62141 .76842 L
.61229 .77681 L
.61169 .77736 L
.60198 .78645 L
.60191 .78652 L
.59227 .79572 L
.59173 .79623 L
.58256 .80515 L
.58175 .80594 L
.57284 .81476 L
.57195 .81566 L
.56313 .82455 L
.56233 .82537 L
.55342 .83453 L
.55289 .83508 L
.54371 .8447 L
.54362 .84479 L
.53451 .85451 L
.53399 .85507 L
.52557 .86422 L
.52428 .86564 L
.51679 .87393 L
.51457 .87641 L
.50816 .88364 L
.50486 .88741 L
.49968 .89336 L
.49514 .89863 L
.49135 .90307 L
.48543 .91007 L
.48316 .91278 L
.47572 .92175 L
.47511 .92249 L
.46719 .93221 L
.46601 .93368 L
.45941 .94192 L
.45629 .94585 L
.45175 .95163 L
.44658 .95828 L
.44422 .96134 L
.43687 .97098 L
.43681 .97106 L
.42953 .98077 L
.98077 .98077 L
F
0 g
.98077 .52213 m
.9766 .52428 L
.97106 .52717 L
.96134 .53227 L
.9581 .53399 L
.95163 .53745 L
.94192 .5427 L
.94007 .54371 L
.93221 .54802 L
.92249 .55341 L
.92249 .55342 L
.91278 .55889 L
.90534 .56313 L
.90307 .56443 L
.89336 .57006 L
.88861 .57284 L
.88364 .57577 L
.87393 .58156 L
.87228 .58256 L
.86422 .58744 L
.85634 .59227 L
.85451 .5934 L
.84479 .59945 L
.84078 .60198 L
.83508 .60559 L
.82558 .61169 L
.82537 .61183 L
.81566 .61816 L
.81072 .62141 L
.80594 .62458 L
.79623 .6311 L
.79621 .63112 L
.78652 .63773 L
.78202 .64083 L
.77681 .64446 L
.76815 .65054 L
.76709 .65129 L
.75738 .65823 L
.75458 .66026 L
.74767 .66528 L
.7413 .66997 L
.73796 .67245 L
.72831 .67968 L
.72824 .67973 L
.71853 .68714 L
.7156 .68939 L
.70882 .69466 L
.70315 .69911 L
.69911 .70231 L
.69097 .70882 L
Mistroke
.68939 .71009 L
.67968 .718 L
.67903 .71853 L
.66997 .72604 L
.66734 .72824 L
.66026 .73423 L
.65589 .73796 L
.65054 .74255 L
.64466 .74767 L
.64083 .75103 L
.63366 .75738 L
.63112 .75965 L
.62287 .76709 L
.62141 .76842 L
.61229 .77681 L
.61169 .77736 L
.60198 .78645 L
.60191 .78652 L
.59227 .79572 L
.59173 .79623 L
.58256 .80515 L
.58175 .80594 L
.57284 .81476 L
.57195 .81566 L
.56313 .82455 L
.56233 .82537 L
.55342 .83453 L
.55289 .83508 L
.54371 .8447 L
.54362 .84479 L
.53451 .85451 L
.53399 .85507 L
.52557 .86422 L
.52428 .86564 L
.51679 .87393 L
.51457 .87641 L
.50816 .88364 L
.50486 .88741 L
.49968 .89336 L
.49514 .89863 L
.49135 .90307 L
.48543 .91007 L
.48316 .91278 L
.47572 .92175 L
.47511 .92249 L
.46719 .93221 L
.46601 .93368 L
.45941 .94192 L
.45629 .94585 L
.45175 .95163 L
Mistroke
.44658 .95828 L
.44422 .96134 L
.43687 .97098 L
.43681 .97106 L
.42953 .98077 L
Mfstroke
.55 g
.98077 .55886 m
.97292 .56313 L
.97106 .56415 L
.96134 .56951 L
.95537 .57284 L
.95163 .57494 L
.94192 .58045 L
.93824 .58256 L
.93221 .58603 L
.92249 .59169 L
.92151 .59227 L
.91278 .59743 L
.90518 .60198 L
.90307 .60325 L
.89336 .60916 L
.88923 .61169 L
.88364 .61515 L
.87393 .62123 L
.87365 .62141 L
.86422 .62739 L
.85842 .63112 L
.85451 .63365 L
.84479 .64 L
.84353 .64083 L
.83508 .64644 L
.82897 .65054 L
.82537 .65298 L
.81566 .65962 L
.81474 .66026 L
.80594 .66636 L
.80081 .66997 L
.79623 .67321 L
.78718 .67968 L
.78652 .68016 L
.77681 .68722 L
.77384 .68939 L
.76709 .69439 L
.76078 .69911 L
.75738 .70167 L
.748 .70882 L
.74767 .70907 L
.73796 .71659 L
.73547 .71853 L
.72824 .72423 L
.72321 .72824 L
.71853 .732 L
.71119 .73796 L
.70882 .73989 L
.69941 .74767 L
.69911 .74792 L
.68939 .75608 L
.68786 .75738 L
.67968 .76438 L
.67654 .76709 L
.66997 .77282 L
.66544 .77681 L
.66026 .78141 L
.65455 .78652 L
.65054 .79014 L
.64387 .79623 L
.64083 .79903 L
.6334 .80594 L
.63112 .80808 L
.62311 .81566 L
.62141 .81729 L
.61302 .82537 L
.61169 .82666 L
.60312 .83508 L
.60198 .8362 L
.59339 .84479 L
.59227 .84592 L
.58384 .85451 L
.58256 .85582 L
.57446 .86422 L
.57284 .86591 L
.56524 .87393 L
.56313 .87618 L
.55619 .88364 L
.55342 .88665 L
.54729 .89336 L
.54371 .89732 L
.53855 .90307 L
.53399 .9082 L
.52995 .91278 L
.52428 .91929 L
.52151 .92249 L
.51457 .9306 L
.5132 .93221 L
.50503 .94192 L
.50486 .94213 L
.497 .95163 L
.49514 .9539 L
.4891 .96134 L
.48543 .96591 L
.48133 .97106 L
.47572 .97816 L
.47368 .98077 L
.98077 .98077 L
F
0 g
.98077 .55886 m
.97292 .56313 L
.97106 .56415 L
.96134 .56951 L
.95537 .57284 L
.95163 .57494 L
.94192 .58045 L
.93824 .58256 L
.93221 .58603 L
.92249 .59169 L
.92151 .59227 L
.91278 .59743 L
.90518 .60198 L
.90307 .60325 L
.89336 .60916 L
.88923 .61169 L
.88364 .61515 L
.87393 .62123 L
.87365 .62141 L
.86422 .62739 L
.85842 .63112 L
.85451 .63365 L
.84479 .64 L
.84353 .64083 L
.83508 .64644 L
.82897 .65054 L
.82537 .65298 L
.81566 .65962 L
.81474 .66026 L
.80594 .66636 L
.80081 .66997 L
.79623 .67321 L
.78718 .67968 L
.78652 .68016 L
.77681 .68722 L
.77384 .68939 L
.76709 .69439 L
.76078 .69911 L
.75738 .70167 L
.748 .70882 L
.74767 .70907 L
.73796 .71659 L
.73547 .71853 L
.72824 .72423 L
.72321 .72824 L
.71853 .732 L
.71119 .73796 L
.70882 .73989 L
.69941 .74767 L
.69911 .74792 L
Mistroke
.68939 .75608 L
.68786 .75738 L
.67968 .76438 L
.67654 .76709 L
.66997 .77282 L
.66544 .77681 L
.66026 .78141 L
.65455 .78652 L
.65054 .79014 L
.64387 .79623 L
.64083 .79903 L
.6334 .80594 L
.63112 .80808 L
.62311 .81566 L
.62141 .81729 L
.61302 .82537 L
.61169 .82666 L
.60312 .83508 L
.60198 .8362 L
.59339 .84479 L
.59227 .84592 L
.58384 .85451 L
.58256 .85582 L
.57446 .86422 L
.57284 .86591 L
.56524 .87393 L
.56313 .87618 L
.55619 .88364 L
.55342 .88665 L
.54729 .89336 L
.54371 .89732 L
.53855 .90307 L
.53399 .9082 L
.52995 .91278 L
.52428 .91929 L
.52151 .92249 L
.51457 .9306 L
.5132 .93221 L
.50503 .94192 L
.50486 .94213 L
.497 .95163 L
.49514 .9539 L
.4891 .96134 L
.48543 .96591 L
.48133 .97106 L
.47572 .97816 L
.47368 .98077 L
Mfstroke
.475 g
.98077 .5956 m
.97106 .60114 L
.96958 .60198 L
.96134 .60675 L
.95289 .61169 L
.95163 .61243 L
.94192 .6182 L
.93657 .62141 L
.93221 .62404 L
.92249 .62997 L
.92063 .63112 L
.91278 .63598 L
.90504 .64083 L
.90307 .64208 L
.89336 .64826 L
.8898 .65054 L
.88364 .65453 L
.87489 .66026 L
.87393 .66089 L
.86422 .66735 L
.86031 .66997 L
.85451 .6739 L
.84604 .67968 L
.84479 .68054 L
.83508 .68729 L
.83208 .68939 L
.82537 .69414 L
.81841 .69911 L
.81566 .70109 L
.80594 .70814 L
.80502 .70882 L
.79623 .71531 L
.79191 .71853 L
.78652 .72259 L
.77907 .72824 L
.77681 .72998 L
.76709 .73748 L
.76649 .73796 L
.75738 .74511 L
.75415 .74767 L
.74767 .75286 L
.74207 .75738 L
.73796 .76073 L
.73021 .76709 L
.72824 .76873 L
.71859 .77681 L
.71853 .77686 L
.70882 .78512 L
.7072 .78652 L
.69911 .79353 L
.69602 .79623 L
.68939 .80207 L
.68505 .80594 L
.67968 .81076 L
.67428 .81566 L
.66997 .8196 L
.66372 .82537 L
.66026 .82859 L
.65334 .83508 L
.65054 .83773 L
.64316 .84479 L
.64083 .84704 L
.63316 .85451 L
.63112 .85651 L
.62334 .86422 L
.62141 .86615 L
.61369 .87393 L
.61169 .87596 L
.60421 .88364 L
.60198 .88596 L
.5949 .89336 L
.59227 .89613 L
.58575 .90307 L
.58256 .90649 L
.57675 .91278 L
.57284 .91705 L
.56791 .92249 L
.56313 .92781 L
.55921 .93221 L
.55342 .93877 L
.55066 .94192 L
.54371 .94994 L
.54225 .95163 L
.53399 .96133 L
.53398 .96134 L
.52584 .97106 L
.52428 .97294 L
.51783 .98077 L
.98077 .98077 L
F
0 g
.98077 .5956 m
.97106 .60114 L
.96958 .60198 L
.96134 .60675 L
.95289 .61169 L
.95163 .61243 L
.94192 .6182 L
.93657 .62141 L
.93221 .62404 L
.92249 .62997 L
.92063 .63112 L
.91278 .63598 L
.90504 .64083 L
.90307 .64208 L
.89336 .64826 L
.8898 .65054 L
.88364 .65453 L
.87489 .66026 L
.87393 .66089 L
.86422 .66735 L
.86031 .66997 L
.85451 .6739 L
.84604 .67968 L
.84479 .68054 L
.83508 .68729 L
.83208 .68939 L
.82537 .69414 L
.81841 .69911 L
.81566 .70109 L
.80594 .70814 L
.80502 .70882 L
.79623 .71531 L
.79191 .71853 L
.78652 .72259 L
.77907 .72824 L
.77681 .72998 L
.76709 .73748 L
.76649 .73796 L
.75738 .74511 L
.75415 .74767 L
.74767 .75286 L
.74207 .75738 L
.73796 .76073 L
.73021 .76709 L
.72824 .76873 L
.71859 .77681 L
.71853 .77686 L
.70882 .78512 L
.7072 .78652 L
.69911 .79353 L
Mistroke
.69602 .79623 L
.68939 .80207 L
.68505 .80594 L
.67968 .81076 L
.67428 .81566 L
.66997 .8196 L
.66372 .82537 L
.66026 .82859 L
.65334 .83508 L
.65054 .83773 L
.64316 .84479 L
.64083 .84704 L
.63316 .85451 L
.63112 .85651 L
.62334 .86422 L
.62141 .86615 L
.61369 .87393 L
.61169 .87596 L
.60421 .88364 L
.60198 .88596 L
.5949 .89336 L
.59227 .89613 L
.58575 .90307 L
.58256 .90649 L
.57675 .91278 L
.57284 .91705 L
.56791 .92249 L
.56313 .92781 L
.55921 .93221 L
.55342 .93877 L
.55066 .94192 L
.54371 .94994 L
.54225 .95163 L
.53399 .96133 L
.53398 .96134 L
.52584 .97106 L
.52428 .97294 L
.51783 .98077 L
Mfstroke
.4 g
.98077 .63234 m
.97106 .63812 L
.96655 .64083 L
.96134 .64398 L
.95163 .64992 L
.95063 .65054 L
.94192 .65595 L
.93505 .66026 L
.93221 .66205 L
.92249 .66825 L
.91982 .66997 L
.91278 .67453 L
.90491 .67968 L
.90307 .6809 L
.89336 .68735 L
.89032 .68939 L
.88364 .69391 L
.87604 .69911 L
.87393 .70055 L
.86422 .7073 L
.86205 .70882 L
.85451 .71414 L
.84835 .71853 L
.84479 .72109 L
.83508 .72814 L
.83493 .72824 L
.82537 .73529 L
.82179 .73796 L
.81566 .74255 L
.8089 .74767 L
.80594 .74993 L
.79627 .75738 L
.79623 .75741 L
.78652 .76501 L
.78389 .76709 L
.77681 .77274 L
.77175 .77681 L
.76709 .78058 L
.75984 .78652 L
.75738 .78855 L
.74816 .79623 L
.74767 .79664 L
.73796 .80487 L
.73669 .80594 L
.72824 .81322 L
.72545 .81566 L
.71853 .82172 L
.71441 .82537 L
.70882 .83036 L
.70357 .83508 L
.69911 .83914 L
.69293 .84479 L
.68939 .84806 L
.68248 .85451 L
.67968 .85714 L
.67222 .86422 L
.66997 .86638 L
.66214 .87393 L
.66026 .87577 L
.65224 .88364 L
.65054 .88532 L
.64251 .89336 L
.64083 .89505 L
.63295 .90307 L
.63112 .90494 L
.62355 .91278 L
.62141 .91501 L
.6143 .92249 L
.61169 .92527 L
.60522 .93221 L
.60198 .93571 L
.59628 .94192 L
.59227 .94634 L
.5875 .95163 L
.58256 .95717 L
.57886 .96134 L
.57284 .9682 L
.57035 .97106 L
.56313 .97943 L
.56199 .98077 L
.98077 .98077 L
F
0 g
.98077 .63234 m
.97106 .63812 L
.96655 .64083 L
.96134 .64398 L
.95163 .64992 L
.95063 .65054 L
.94192 .65595 L
.93505 .66026 L
.93221 .66205 L
.92249 .66825 L
.91982 .66997 L
.91278 .67453 L
.90491 .67968 L
.90307 .6809 L
.89336 .68735 L
.89032 .68939 L
.88364 .69391 L
.87604 .69911 L
.87393 .70055 L
.86422 .7073 L
.86205 .70882 L
.85451 .71414 L
.84835 .71853 L
.84479 .72109 L
.83508 .72814 L
.83493 .72824 L
.82537 .73529 L
.82179 .73796 L
.81566 .74255 L
.8089 .74767 L
.80594 .74993 L
.79627 .75738 L
.79623 .75741 L
.78652 .76501 L
.78389 .76709 L
.77681 .77274 L
.77175 .77681 L
.76709 .78058 L
.75984 .78652 L
.75738 .78855 L
.74816 .79623 L
.74767 .79664 L
.73796 .80487 L
.73669 .80594 L
.72824 .81322 L
.72545 .81566 L
.71853 .82172 L
.71441 .82537 L
.70882 .83036 L
.70357 .83508 L
Mistroke
.69911 .83914 L
.69293 .84479 L
.68939 .84806 L
.68248 .85451 L
.67968 .85714 L
.67222 .86422 L
.66997 .86638 L
.66214 .87393 L
.66026 .87577 L
.65224 .88364 L
.65054 .88532 L
.64251 .89336 L
.64083 .89505 L
.63295 .90307 L
.63112 .90494 L
.62355 .91278 L
.62141 .91501 L
.6143 .92249 L
.61169 .92527 L
.60522 .93221 L
.60198 .93571 L
.59628 .94192 L
.59227 .94634 L
.5875 .95163 L
.58256 .95717 L
.57886 .96134 L
.57284 .9682 L
.57035 .97106 L
.56313 .97943 L
.56199 .98077 L
Mfstroke
.325 g
.98077 .66908 m
.97932 .66997 L
.97106 .67511 L
.96378 .67968 L
.96134 .68122 L
.95163 .68742 L
.94856 .68939 L
.94192 .6937 L
.93366 .69911 L
.93221 .70007 L
.92249 .70652 L
.91908 .70882 L
.91278 .71307 L
.90479 .71853 L
.90307 .71972 L
.89336 .72645 L
.8908 .72824 L
.88364 .73329 L
.87708 .73796 L
.87393 .74022 L
.86422 .74725 L
.86365 .74767 L
.85451 .75439 L
.85048 .75738 L
.84479 .76163 L
.83756 .76709 L
.83508 .76898 L
.82537 .77644 L
.8249 .77681 L
.81566 .78402 L
.81248 .78652 L
.80594 .79171 L
.8003 .79623 L
.79623 .79951 L
.78834 .80594 L
.78652 .80744 L
.77681 .8155 L
.77661 .81566 L
.76709 .82368 L
.7651 .82537 L
.75738 .83198 L
.7538 .83508 L
.74767 .84043 L
.7427 .84479 L
.73796 .849 L
.73181 .85451 L
.72824 .85772 L
.72111 .86422 L
.71853 .86658 L
.71059 .87393 L
.70882 .87559 L
.70027 .88364 L
.69911 .88475 L
.69012 .89336 L
.68939 .89406 L
.68014 .90307 L
.67968 .90352 L
.67034 .91278 L
.66997 .91315 L
.6607 .92249 L
.66026 .92295 L
.65123 .93221 L
.65054 .93291 L
.64191 .94192 L
.64083 .94305 L
.63275 .95163 L
.63112 .95337 L
.62373 .96134 L
.62141 .96388 L
.61487 .97106 L
.61169 .97457 L
.60614 .98077 L
.98077 .98077 L
F
0 g
.98077 .66908 m
.97932 .66997 L
.97106 .67511 L
.96378 .67968 L
.96134 .68122 L
.95163 .68742 L
.94856 .68939 L
.94192 .6937 L
.93366 .69911 L
.93221 .70007 L
.92249 .70652 L
.91908 .70882 L
.91278 .71307 L
.90479 .71853 L
.90307 .71972 L
.89336 .72645 L
.8908 .72824 L
.88364 .73329 L
.87708 .73796 L
.87393 .74022 L
.86422 .74725 L
.86365 .74767 L
.85451 .75439 L
.85048 .75738 L
.84479 .76163 L
.83756 .76709 L
.83508 .76898 L
.82537 .77644 L
.8249 .77681 L
.81566 .78402 L
.81248 .78652 L
.80594 .79171 L
.8003 .79623 L
.79623 .79951 L
.78834 .80594 L
.78652 .80744 L
.77681 .8155 L
.77661 .81566 L
.76709 .82368 L
.7651 .82537 L
.75738 .83198 L
.7538 .83508 L
.74767 .84043 L
.7427 .84479 L
.73796 .849 L
.73181 .85451 L
.72824 .85772 L
.72111 .86422 L
.71853 .86658 L
.71059 .87393 L
Mistroke
.70882 .87559 L
.70027 .88364 L
.69911 .88475 L
.69012 .89336 L
.68939 .89406 L
.68014 .90307 L
.67968 .90352 L
.67034 .91278 L
.66997 .91315 L
.6607 .92249 L
.66026 .92295 L
.65123 .93221 L
.65054 .93291 L
.64191 .94192 L
.64083 .94305 L
.63275 .95163 L
.63112 .95337 L
.62373 .96134 L
.62141 .96388 L
.61487 .97106 L
.61169 .97457 L
.60614 .98077 L
Mfstroke
.25 g
.98077 .70581 m
.9761 .70882 L
.97106 .71209 L
.96134 .71846 L
.96123 .71853 L
.95163 .72491 L
.94666 .72824 L
.94192 .73145 L
.93238 .73796 L
.93221 .73808 L
.92249 .7448 L
.91839 .74767 L
.91278 .75162 L
.90468 .75738 L
.90307 .75854 L
.89336 .76555 L
.89124 .76709 L
.88364 .77266 L
.87805 .77681 L
.87393 .77988 L
.86512 .78652 L
.86422 .7872 L
.85451 .79464 L
.85244 .79623 L
.84479 .80218 L
.83999 .80594 L
.83508 .80983 L
.82778 .81566 L
.82537 .8176 L
.8158 .82537 L
.81566 .82548 L
.80594 .83349 L
.80403 .83508 L
.79623 .84162 L
.79248 .84479 L
.78652 .84987 L
.78113 .85451 L
.77681 .85826 L
.76999 .86422 L
.76709 .86677 L
.75904 .87393 L
.75738 .87542 L
.74829 .88364 L
.74767 .88421 L
.73796 .89314 L
.73773 .89336 L
.72824 .90222 L
.72734 .90307 L
.71853 .91144 L
.71714 .91278 L
.70882 .92082 L
.7071 .92249 L
.69911 .93035 L
.69724 .93221 L
.68939 .94005 L
.68754 .94192 L
.67968 .9499 L
.678 .95163 L
.66997 .95993 L
.66861 .96134 L
.66026 .97013 L
.65938 .97106 L
.65054 .9805 L
.6503 .98077 L
.98077 .98077 L
F
0 g
.98077 .70581 m
.9761 .70882 L
.97106 .71209 L
.96134 .71846 L
.96123 .71853 L
.95163 .72491 L
.94666 .72824 L
.94192 .73145 L
.93238 .73796 L
.93221 .73808 L
.92249 .7448 L
.91839 .74767 L
.91278 .75162 L
.90468 .75738 L
.90307 .75854 L
.89336 .76555 L
.89124 .76709 L
.88364 .77266 L
.87805 .77681 L
.87393 .77988 L
.86512 .78652 L
.86422 .7872 L
.85451 .79464 L
.85244 .79623 L
.84479 .80218 L
.83999 .80594 L
.83508 .80983 L
.82778 .81566 L
.82537 .8176 L
.8158 .82537 L
.81566 .82548 L
.80594 .83349 L
.80403 .83508 L
.79623 .84162 L
.79248 .84479 L
.78652 .84987 L
.78113 .85451 L
.77681 .85826 L
.76999 .86422 L
.76709 .86677 L
.75904 .87393 L
.75738 .87542 L
.74829 .88364 L
.74767 .88421 L
.73796 .89314 L
.73773 .89336 L
.72824 .90222 L
.72734 .90307 L
.71853 .91144 L
.71714 .91278 L
Mistroke
.70882 .92082 L
.7071 .92249 L
.69911 .93035 L
.69724 .93221 L
.68939 .94005 L
.68754 .94192 L
.67968 .9499 L
.678 .95163 L
.66997 .95993 L
.66861 .96134 L
.66026 .97013 L
.65938 .97106 L
.65054 .9805 L
.6503 .98077 L
Mfstroke
0 0 0 r
.055 w
.57308 .57308 Mdot
1 0 0 r
.0325 w
.01923 .01923 Mdot
.21154 .21154 Mdot
.98077 .98077 Mdot
.21334 .21334 Mdot
.21535 .21535 Mdot
.59806 .59806 Mdot
.33761 .33761 Mdot
.51124 .51124 Mdot
.53181 .53181 Mdot
.53251 .53251 Mdot
.56529 .56529 Mdot
.58713 .58713 Mdot
.56532 .56532 Mdot
.56535 .56535 Mdot
.57624 .57624 Mdot
.56655 .56655 Mdot
.56728 .56728 Mdot
.57176 .57176 Mdot
.57475 .57475 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57326 .57326 Mdot
.5722 .5722 Mdot
.5729 .5729 Mdot
.57291 .57291 Mdot
.57314 .57314 Mdot
.57294 .57294 Mdot
.57295 .57295 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57309 .57309 Mdot
.57305 .57305 Mdot
.57308 .57308 Mdot
.57306 .57306 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57308 .57308 Mdot
.57307 .57307 Mdot
.57308 .57308 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
0 1 0 r
.02 w
.01923 .01923 Mdot
.01923 .01923 Mdot
.01923 .01923 Mdot
.01923 .01923 Mdot
.21154 .21154 Mdot
.21154 .21154 Mdot
.21154 .21154 Mdot
.21154 .21154 Mdot
.98077 .98077 Mdot
.98077 .98077 Mdot
.98077 .98077 Mdot
.98077 .98077 Mdot
.21334 .21334 Mdot
.21334 .21334 Mdot
.21334 .21334 Mdot
.21334 .21334 Mdot
.21535 .21535 Mdot
.21535 .21535 Mdot
.21535 .21535 Mdot
.21535 .21535 Mdot
.59806 .59806 Mdot
.59806 .59806 Mdot
.59806 .59806 Mdot
.59806 .59806 Mdot
.33761 .33761 Mdot
.33761 .33761 Mdot
.33761 .33761 Mdot
.33761 .33761 Mdot
.51124 .51124 Mdot
.51124 .51124 Mdot
.51124 .51124 Mdot
.51124 .51124 Mdot
.53181 .53181 Mdot
.53181 .53181 Mdot
.53181 .53181 Mdot
.53181 .53181 Mdot
.53251 .53251 Mdot
.53251 .53251 Mdot
.53251 .53251 Mdot
.53251 .53251 Mdot
.56529 .56529 Mdot
.56529 .56529 Mdot
.56529 .56529 Mdot
.56529 .56529 Mdot
.58713 .58713 Mdot
.58713 .58713 Mdot
.58713 .58713 Mdot
.58713 .58713 Mdot
.56532 .56532 Mdot
.56532 .56532 Mdot
.56532 .56532 Mdot
.56532 .56532 Mdot
.56535 .56535 Mdot
.56535 .56535 Mdot
.56535 .56535 Mdot
.56535 .56535 Mdot
.57624 .57624 Mdot
.57624 .57624 Mdot
.57624 .57624 Mdot
.57624 .57624 Mdot
.56655 .56655 Mdot
.56655 .56655 Mdot
.56655 .56655 Mdot
.56655 .56655 Mdot
.56728 .56728 Mdot
.56728 .56728 Mdot
.56728 .56728 Mdot
.56728 .56728 Mdot
.57176 .57176 Mdot
.57176 .57176 Mdot
.57176 .57176 Mdot
.57176 .57176 Mdot
.57475 .57475 Mdot
.57475 .57475 Mdot
.57475 .57475 Mdot
.57475 .57475 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57177 .57177 Mdot
.57326 .57326 Mdot
.57326 .57326 Mdot
.57326 .57326 Mdot
.57326 .57326 Mdot
.5722 .5722 Mdot
.5722 .5722 Mdot
.5722 .5722 Mdot
.5722 .5722 Mdot
.5729 .5729 Mdot
.5729 .5729 Mdot
.5729 .5729 Mdot
.5729 .5729 Mdot
.57291 .57291 Mdot
.57291 .57291 Mdot
.57291 .57291 Mdot
.57291 .57291 Mdot
.57314 .57314 Mdot
.57314 .57314 Mdot
.57314 .57314 Mdot
.57314 .57314 Mdot
.57294 .57294 Mdot
.57294 .57294 Mdot
.57294 .57294 Mdot
.57294 .57294 Mdot
.57295 .57295 Mdot
.57295 .57295 Mdot
.57295 .57295 Mdot
.57295 .57295 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57309 .57309 Mdot
.57309 .57309 Mdot
.57309 .57309 Mdot
.57309 .57309 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57305 .57305 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57306 .57306 Mdot
.57306 .57306 Mdot
.57306 .57306 Mdot
.57306 .57306 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57307 .57307 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
.57308 .57308 Mdot
0 0 1 r
.5 Mabswid
.01923 .01923 m
.01923 .01923 L
s
.015 w
.01923 .01923 Mdot
.01923 .01923 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`003Oooool5o`0003oooooo0ol00010ooooo`?o0000?_ooool3o`0003oooooo0ol00006oooo
o`003_ooool01?l0003oooooooooool0000nooooo`05o`000?ooooooooooooooool00000@?ooool0
0ol0003oooooooooo`0looooo`05o`000?ooooooooooooooool00000?Oooool01Ol0003ooooooooo
oooooooo000000Gooooo000?ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooooooool0>ooo
ool5o`00047ooooo00?o0000ooooooooool0>oooool01Ol0003ooooooooooooooooo000000Gooooo
000@ooooo`03o`000?oooooooooo03oooooo0_l0000nooooo`04o`000?ooooooooooo`0004;ooooo
00?o0000ooooooooool0>oooool4o`0000Kooooo000=ooooo`05o`000?ooooooooooooooool00000
@_ooool00ol0003oooooooooo`0looooo`03o`000?oooooo000003kooooo1?l0000nooooo`03o`00
0?oooooooooo00Oooooo000=ooooo`05o`000?ooooooooooooooool00000?_ooool01Ol0003ooooo
oooooooooooo000003oooooo0_l0000nooooo`03o`000?oooooooooo043ooooo00?o0000oooooooo
ool01_ooool000kooooo0ol00010ooooo`?o0000@Oooool00ol0003oooooooooo`0looooo`Go0000
?oooool2o`0000Kooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo003oooooob7o
oooo003oooooob7ooooo000;oooooooo00004_l00004ooooo`002oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooo`000004
ooooo`002oooool01?l0003oooooooooooooool4ool0043ooooo00?o0000ooooooooool0?oooool0
0ol0003oooooooooo`0oooooo`03o`000?oooooooooo03oooooo00?o0000ooooool000001?ooool0
00?ooooo0ol00005ooooo`04o`000?ooooooooooool000?o0?l00_oo003oooooo`Sooooo00?o0000
ooooooooool00_ooool000Cooooo00?o0000ooooooooool01?ooool00ol0003oooooool00002o`3o
00;o003o00?o0?l0ool00?oo0000ooooool7ooooo`03o`000?oooooooooo00;ooooo0004ooooo`03
o`000?oooooooooo00Cooooo0_l000000ooo003o0?l0o`00o`03o`00o`;oo`00ooooool6ooooo`;o
00001?ooool000Cooooo00?o0000ooooooooool01?ooool01?l0003oooooool00?l0o`04o`00o`;o
o`00ooooool7ooooo`03o`000?oooooooooo00;ooooo0004ooooo`03o`000?oooooooooo00Cooooo
00Go0000oooooooo003oo`00o`3o0002o`00o`?oo`00ooooool7ooooo`03o`000?oooooooooo00;o
oooo0003ooooo`;o00001_ooool00ol0003oooooooooo`06ool00?oooooo2?ooool00ol0003ooooo
ooooo`02ooooo`001?ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooooooo`Coo`00
ooooool9ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_oo
ool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000
ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo
00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`00
2oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooo
oooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3ooooo
o`kooooo00?o0000ooooooooool00_ooool000_ooooo0_l0003oooooo`kooooo0_l00004ooooo`00
2oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooo
oooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3ooooo
o`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03
o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003ooooo
ooooo`02ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_oo
ool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;oooo
o`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003o
ooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0
ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_oo
ool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000
ooooooooool00_ooool000_ooooo0_l0003oooooo`kooooo0_l00004ooooo`002oooool00ol0003o
ooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0
ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_oo
ool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000
ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo
00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`00
2oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooo
oooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3ooooo
o`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03
o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003ooooo
ooooo`02ooooo`002oooool2o`000?oooooo3_ooool2o`0000Cooooo000;ooooo`03o`000?oooooo
oooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3ooooo
o`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03
o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003ooooo
ooooo`02ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_oo
ool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;oooo
o`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003o
ooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0
=Oooool4ool00=Cooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0=?oo
ool6ool00=?ooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0<oooool3
ool000?o0?l00_oo003Booooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo
03?ooooo0_oo0005o`3o00;oo`00dOooool00ol0003oooooooooo`02ooooo`002oooool2o`0003Co
oooo0_oo0006o`3o0003ool00?oooooooooo0<kooooo0_l00004ooooo`002oooool00ol0003ooooo
ooooo`0cooooo`;oo`001_l0o`000ooo003oooooooooo`3?ooooo`03o`000?oooooooooo00;ooooo
000;ooooo`03o`000?oooooooooo03?ooooo0ooo0005o`3o0003ool00?oooooooooo0<oooooo00?o
0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0=?ooool3ool000?o0?l000?oo`00
ooooooooool0d?ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`0eoooo
o`Goo`00doooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3oooooo`ko
oooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03o`00
0?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003ooooooooo
o`02ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool0
00_ooooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03
o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`000_ooool5o`0000Cooooo
00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo0003ooooo`04o`000?oo
ooooooooo`0000Cooooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo
0004ooooo`03o`000?oooooooooo00Cooooo0ol0003oooooo`gooooo0_l00004ooooo`001Oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02
ooooo`000_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0ooooool>
ooooo`03o`000?oooooooooo00;ooooo0002ooooo`05o`000?ooooooooooooooool000001?ooool0
0ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000?ooooo0ol00005oooo
o`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003o
ooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0
ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_oo
ool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000
ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo
00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`00
2oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooo
oooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool2o`000?oooooo3_ooool2o`00
00Cooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`00
2oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooo
oooo05Oooooo1?oo002booooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo
05Kooooo0_oo0003o`3o0003ool00?oooooooooo0:oooooo00?o0000ooooooooool00_ooool000_o
oooo00?o0000ooooooooool0EOooool2ool000Go0?l000?oo`00ooooooooool0[_ooool00ol0003o
ooooooooo`02ooooo`002oooool00ol0003oooooooooo`1Eooooo`;oo`001Ol0o`000ooo003ooooo
ooooo`2^ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo05Gooooo0_oo
0005o`3o0003ool00?oooooooooo0:kooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000
ooooooooool0EOooool3ool000?o0?l00_oo002`ooooo`03o`000?oooooooooo00;ooooo000;oooo
o`03o`000?oooooooooo05Kooooo1_oo002aooooo`03o`000?oooooooooo00;ooooo000;ooooo`03
o`000?oooooooooo05Oooooo1?oo002booooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`00
0?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02ooooo`002oooool2o`000?oooooo3_oo
ool2o`0000Cooooo000;ooooo`03o`000?oooooooooo0?oooooo3_ooool00ol0003oooooooooo`02
ooooo`002oooool00ol0003oooooooooo`3oooooo`kooooo00?o0000ooooooooool00_ooool000_o
oooo00?o0000ooooooooool0ooooool>ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`00
0?oooooooooo0?oooooo2?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0ooooool5ooooo`?o000000?ok>c/ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`002oooool00ol0003oooooooooo`3oooooo`?ooooo0_l00004onc/k0Gooooo00?o0000
ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ooooool1ooooo`;o00001_o/k>`5oooo
o`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?oooooo0_l00007onc/k0Go
oooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0oOooool2o`0000Wok>c/
1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3iooooo`Co00002oo/
k>`5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0?Oooooo0_l0000?
onc/k0Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0mOooool2o`00
017ok>c/1Oooool00ol0003oooooooooo`02ooooo`002oooool2o`000??ooooo0ol0000Conc/k0Co
oooo0_l00004ooooo`002oooool00ol0003oooooooooo`3aooooo`03o`000?o/k>cok>c/01?ok>c/
0_l00004ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0>oooooo0_l0
000Donc/k0;o000000?ofMWIooooooooool00oooool00ol0003oooooooooo`02ooooo`002oooool0
0ol0003oooooooooo`3]ooooo`;o00004oo/k>`4o`0000;ofMWI1Oooool00ol0003oooooooooo`02
ooooo`002oooool00ol0003oooooooooo`3Zooooo`?o00005?o/k>`00ol0003ofMWIomWIf@04omWI
f@Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0j?ooool2o`0001Go
k>c/0_l00007omWIf@Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0
ioooool00ol0003ok>c/onc/k00Conc/k0;o00002OoIfMT5ooooo`03o`000?oooooooooo00;ooooo
000;ooooo`03o`000?oooooooooo0>Gooooo0_l0000Conc/k0?o00002ooIfMT5ooooo`03o`000?oo
oooooooo00;ooooo000;ooooo`03o`000?oooooooooo0>;ooooo0ol0000Conc/k0;o00003_oIfMT5
ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0=oooooo0ol0000Eonc/
k003o`000?oIfMWofMWI00kofMWI1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003o
ooooooooo`3Nooooo`03o`000?o/k>cok>c/01?ok>c/0ol0000AomWIf@Gooooo00?o0000oooooooo
ool00_ooool000_ooooo00?o0000ooooooooool0gOooool2o`0001?ok>c/0_l0000ComWIf@;o0000
1?ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`3Jooooo`?o00004_o/
k>`3o`0001?ofMWI0_l000000oo6a/Koooooooooo`03ooooo`03o`000?oooooooooo00;ooooo000;
ooooo`;o0000fOooool2o`0001?ok>c/0_l0000EomWIf@04o`000?o6a/Koa/K6olK6aPCooooo0_l0
0004ooooo`002oooool00ol0003oooooooooo`3Gooooo`03o`000?o/k>cok>c/01;ok>c/00?o0000
omWIfOoIfMT04ooIfMT2o`0000Coa/K61Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0
003oooooooooo`3Eooooo`;o00004oo/k>`2o`0001?ofMWI0ol00006olK6aPGooooo00?o0000oooo
ooooool00_ooool000_ooooo00?o0000ooooooooool0doooool2o`0001?ok>c/0_l0000ComWIf@;o
00002Oo6a/H5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0=;ooooo
00?o0000onc/k?o/k>`04_o/k>`00ol0003ofMWIomWIf@0@omWIf@?o00002oo6a/H5ooooo`03o`00
0?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0<oooooo0ol0000Bonc/k0?o00004_oI
fMT00ol0003oa/K6olK6aP0<olK6aPGooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000
ooooooooool0cOooool2o`0001?ok>c/0_l0000ComWIf@;o00003oo6a/H5ooooo`03o`000?oooooo
oooo00;ooooo000;ooooo`03o`000?oooooooooo0<cooooo00?o0000onc/k?o/k>`04Oo/k>`2o`00
01?ofMWI0_l0000AolK6aPGooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000oooooooo
ool0b_ooool2o`0001?ok>c/00?o0000omWIfOoIfMT04?oIfMT3o`0001;oa/K60_l00004ooooo`03
o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo0<Sooooo0_l0000Conc/k0;o0000
4_oIfMT00ol0003oa/K6olK6aP0AolK6aP;o000000?o/k>cooooooooool00oooool00ol0003ooooo
ooooo`02ooooo`002oooool00ol0003oooooooooo`37ooooo`03o`000?o/k>cok>c/017ok>c/0_l0
000ComWIf@03o`000?o6a/Koa/K6017oa/K600Co0000ok>c/onc/k?o/k>c1Oooool00ol0003ooooo
ooooo`02ooooo`000oooool3o`0000Gooooo00?o0000ooooooooool0aOooool2o`0001?ok>c/0_l0
000AomWIf@?o00004_o6a/H2o`0000Co/k>c1Oooool00ol0003oooooooooo`02ooooo`000_ooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0Q_ooool4ool003Wooooo0_l0
000Conc/k0;o00004_oIfMT00ol0003oa/K6olK6aP0@olK6aP?o00001_nc/k<5ooooo`03o`000?oo
oooooooo00;ooooo0006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0QOooool2
ool000?o0?l000?oo`00ooooooooool0=Oooool00ol0003ok>c/onc/k00@onc/k0?o00004OoIfMT3
o`00017oa/K60_l00009ok>c/`Gooooo00?o0000ooooooooool00_ooool000Cooooo0_l00005oooo
o`?o0000Q?ooool2ool000Go0?l000?oo`00ooooooooool0<_ooool2o`0001;ok>c/00?o0000omWI
fOoIfMT04OoIfMT00ol0003oa/K6olK6aP0AolK6aP03o`000?nc/k?o/k>c00Wo/k>c1?ooool2o`00
00Cooooo0006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Q?ooool2ool000Go
0?l000?oo`00ooooooooool0<Oooool00ol0003ok>c/onc/k00@onc/k0;o00004ooIfMT00ol0003o
a/K6olK6aP0@olK6aP;o00003?nc/k<5ooooo`03o`000?oooooooooo00;ooooo0002ooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooooooo`24ooooo`;oo`001Ol0o`000ooo003o
ooooooooo`0_ooooo`;o00004Oo/k>`2o`0001;ofMWI0ol0000AolK6aP;o00003_nc/k<5ooooo`03
o`000?oooooooooo00;ooooo0003ooooo`?o00001Oooool00ol0003oooooooooo`24ooooo`?oo`00
0ol0o`02ool002oooooo0_l0000Bonc/k003o`000?oIfMWofMWI013ofMWI0_l0000ColK6aP03o`00
0?nc/k?o/k>c00ko/k>c1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003ooooooooo
o`25ooooo`Koo`0000?oooooool00?oo00000_oo000[ooooo`03o`000?o/k>cok>c/013ok>c/00?o
0000omWIfOoIfMT04?oIfMT00ol0003oa/K6olK6aP0AolK6aP;o00004Onc/k<00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo08Kooooo1?oo0000
0oooooooo`00ool00003o`3o0003ool00?oooooooooo02Gooooo0ol0000Aonc/k0;o00004OoIfMT2
o`00017oa/K60ol0000@ok>c/`?o00001Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0
003oooooooooo`2:ooooo`;oo`001Ol0o`000ooo003oooooooooo`0Sooooo`03o`000?o/k>cok>c/
013ok>c/0_l0000AomWIf@;o00004Oo6a/H2o`0001;o/k>c00Co0000oinOWonOWiooWinO1Oooool0
0ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`2:ooooo`;oo`001Ol0o`000ooo
003oooooooooo`0Rooooo`03o`000?o/k>cok>c/00ook>c/0_l0000BomWIf@03o`000?o6a/Koa/K6
013oa/K600?o0000ok>c/onc/k<03onc/k<3o`0000CoWinO1Oooool00ol0003oooooooooo`02oooo
o`002oooool00ol0003oooooooooo`2:ooooo`;oo`001Ol0o`000ooo003oooooooooo`0Qooooo`03
o`000?o/k>cok>c/00ook>c/00?o0000omWIfOoIfMT04?oIfMT2o`00017oa/K60_l0000Aok>c/`03
o`000?nOWiooWinO00GoWinO1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003ooooo
ooooo`2:ooooo`?oo`000ol0o`02ool0027ooooo0_l0000@onc/k0;o00004OoIfMT2o`00017oa/K6
0_l0000Bok>c/`03o`000?nOWiooWinO00KoWinO1Oooool00ol0003oooooooooo`02ooooo`002ooo
ool00ol0003oooooooooo`2;ooooo`Koo`007oooool3o`00017ok>c/00?o0000omWIfOoIfMT04?oI
fMT00ol0003oa/K6olK6aP0?olK6aP;o00004Onc/k<3o`0000WoWinO1Oooool00ol0003ooooooooo
o`02ooooo`002oooool00ol0003oooooooooo`2<ooooo`Coo`007oooool00ol0003ok>c/onc/k00@
onc/k0;o00004OoIfMT2o`00013oa/K60_l0000Aok>c/`;o00003?nOWil5ooooo`03o`000?oooooo
oooo00;ooooo000;ooooo`03o`000?oooooooooo09Kooooo1_l0000Booooo`03o`000?o/k>cok>c/
013ok>c/00?o0000omWIfOoIfMT03ooIfMT2o`00017oa/K600?o0000ok>c/onc/k<04?nc/k<00ol0
003oWinOoinOW`0<oinOW`Gooooo00?o0000ooooooooool00_ooool000_ooooo0_l0002Fooooo`Go
o`000ol0000@ooooo`;o00004?o/k>`2o`00017ofMWI0_l0000AolK6aP;o00004?nc/k<2o`0000oo
WinO1?ooool2o`0000Cooooo000;ooooo`03o`000?oooooooooo09Cooooo0_oo0003o`3o00;oo`00
0ol0000=ooooo`;o00004?o/k>`2o`00017ofMWI0_l0000@olK6aP?o00004?nc/k<2o`00013oWinO
0_l00004ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo09?ooooo0_oo
0005o`3o00;oo`000ol0000;ooooo`03o`000?o/k>cok>c/00ook>c/00?o0000omWIfOoIfMT04?oI
fMT00ol0003oa/K6olK6aP0?olK6aP03o`000?nc/k?o/k>c013o/k>c00?o0000oinOWonOWil03_nO
Wil2o`000003ohb<S?oooooooooo00?ooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000
ooooooooool0T_ooool00ol0003oo`00ool00006o`3o00;oo`000ol00008ooooo`;o00004Oo/k>`0
0ol0003ofMWIomWIf@0?omWIf@;o00004?o6a/H2o`00017o/k>c0_l0000@oinOW`04o`000?n<S8co
S8b<ohb<S0Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0T_ooool0
0ol0003oo`00ool00007o`3o00;oo`000_l00007ooooo`03o`000?o/k>cok>c/013ok>c/00?o0000
omWIfOoIfMT03_oIfMT2o`00017oa/K600?o0000ok>c/onc/k<03onc/k<2o`00013oWinO0_l00004
ohb<S0Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0T_ooool00ol0
003oo`00ool00008o`3o0003ool00?l0003o000000Kooooo00?o0000onc/k?o/k>`03oo/k>`2o`00
013ofMWI0_l0000@olK6aP;o00004Onc/k<00ol0003oWinOoinOW`0>oinOW`;o00001_n<S8`5oooo
o`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo09;ooooo0_l00002ool000Oo
0?l00_oo00000ol0003oooooooooo`03ooooo`03o`000?o/k>cok>c/00kok>c/0_l0000@omWIf@;o
00004?o6a/H2o`00017o/k>c0_l0000@oinOW`03o`000?n<S8coS8b<00KoS8b<1Oooool00ol0003o
ooooooooo`02ooooo`002oooool00ol0003oooooooooo`2Booooo`?o00000_oo0008o`3o0004ool0
0?ooooooooooooooo`;o00004?o/k>`00ol0003ofMWIomWIf@0?omWIf@03o`000?o6a/Koa/K600oo
a/K600?o0000ok>c/onc/k<03_nc/k<3o`0000ooWinO0ol00009ohb<S0Gooooo00?o0000oooooooo
ool00_ooool000_ooooo00?o0000ooooooooool0T_ooool4o`0000;oo`002?l0o`000ooo003ooooo
o`00000@onc/k0;o00004?oIfMT2o`00017oa/K60_l0000?ok>c/`03o`000?nOWiooWinO00koWinO
0_l0000<ohb<S0Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0Tooo
ool4o`0000Coo`001Ol0o`02ool0013ok>c/00?o0000omWIfOoIfMT03ooIfMT00ol0003oa/K6olK6
aP0?olK6aP;o00003onc/k<2o`00013oWinO00?o0000ohb<S?n<S8`03?n<S8`5ooooo`03o`000?oo
oooooooo00;ooooo000;ooooo`03o`000?oooooooooo09Cooooo1?l00003ool000Oo0?l000?oo`00
onc/k?o/k>`02oo/k>`2o`00017ofMWI00?o0000olK6a_o6a/H03_o6a/H2o`0000oo/k>c0_l0000A
oinOW`03o`000?n<S8coS8b<00goS8b<1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0
003oooooooooo`2Eooooo`Co00000ooo0007o`3o0003ool00?o/k>cok>c/00Wok>c/00?o0000omWI
fOoIfMT04?oIfMT00ol0003oa/K6olK6aP0>olK6aP03o`000?nc/k?o/k>c00ko/k>c00?o0000oinO
WonOWil04?nOWil00ol0003oS8b<ohb<S00=ohb<S0;o00001?ooool00ol0003oooooooooo`02oooo
o`002oooool00ol0003oooooooooo`2Fooooo`Co00001?oo0005o`3o0003ool00?o/k>cok>c/00So
k>c/00?o0000omWIfOoIfMT03ooIfMT2o`00013oa/K600?o0000ok>c/onc/k<03_nc/k<00ol0003o
WinOoinOW`0?oinOW`;o00003on<S8`00ol0003oNGUiooooo`04ooooo`03o`000?oooooooooo00;o
oooo000;ooooo`;o0000W?ooool3ool000Go0?l000?oo`00onc/k?o/k>`01oo/k>`00ol0003ofMWI
omWIf@0=omWIf@?o00003oo6a/H3o`0000oo/k>c0_l0000?oinOW`?o00003on<S8`2o`0000;oNGUi
1?ooool2o`0000Cooooo000;ooooo`03o`000?oooooooooo09[ooooo00?o0000onc/k?oo00000_oo
0003o`3o00;oo`001oo/k>`2o`0000oofMWI00?o0000olK6a_o6a/H03oo6a/H00ol0003o/k>cok>c
/`0>ok>c/`;o00004?nOWil00ol0003oS8b<ohb<S00>ohb<S0;o00001?miNGT5ooooo`03o`000?oo
oooooooo00;ooooo000;ooooo`03o`000?oooooooooo09Sooooo0_l00003onc/k0Koo`001oo/k>`0
0ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600koa/K60_l0000?ok>c/`;o00004?nOWil2
o`00013oS8b<00?o0000ogUiNOmiNGT01?miNGT5ooooo`03o`000?oooooooooo00;ooooo000;oooo
o`03o`000?oooooooooo09Oooooo00?o0000onc/k?o/k>`01?o/k>`4ool000Kok>c/0_l0000@omWI
f@03o`000?o6a/Koa/K600koa/K600?o0000ok>c/onc/k<03_nc/k<00ol0003oWinOoinOW`0>oinO
W`;o00004?n<S8`2o`0000OoNGUi1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003o
ooooooooo`2Fooooo`03o`000?o/k>cok>c/00kok>c/00?o0000omWIfOoIfMT03ooIfMT00ol0003o
a/K6olK6aP0>olK6aP03o`000?nc/k?o/k>c00ko/k>c00?o0000oinOWonOWil03_nOWil00ol0003o
S8b<ohb<S00>ohb<S0;o00002OmiNGT5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`00
0?oooooooooo09Gooooo00?o0000onc/k?o/k>`03_o/k>`00ol0003ofMWIomWIf@0>omWIf@;o0000
3oo6a/H2o`00013o/k>c00?o0000oinOWonOWil03OnOWil2o`00013oS8b<00?o0000ogUiNOmiNGT0
2OmiNGT5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo09Cooooo00?o
0000onc/k?o/k>`03_o/k>`00ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600koa/K600?o
0000ok>c/onc/k<03_nc/k<2o`0000ooWinO00?o0000ohb<S?n<S8`03_n<S8`2o`0000coNGUi1Ooo
ool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`2Cooooo`03o`000?o/k>co
k>c/00kok>c/00?o0000omWIfOoIfMT03_oIfMT00ol0003oa/K6olK6aP0>olK6aP03o`000?nc/k?o
/k>c00go/k>c0_l0000@oinOW`03o`000?n<S8coS8b<00goS8b<0_l0000>ogUiN@Gooooo00?o0000
ooooooooool00_ooool000_ooooo00?o0000ooooooooool0T_ooool00ol0003ok>c/onc/k00=onc/
k0;o00003ooIfMT2o`0000ooa/K60_l0000?ok>c/`;o00003_nOWil3o`0000ooS8b<0_l0000>ogUi
N@;o00001?ooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`2@ooooo`;o
00003oo/k>`00ol0003ofMWIomWIf@0>omWIf@03o`000?o6a/Koa/K600goa/K60_l0000?ok>c/`;o
00003onOWil00ol0003oS8b<ohb<S00>ohb<S0;o00003omiNGT00ol0003oIVIVooooo`04ooooo`03
o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo08oooooo00?o0000onc/k?o/k>`0
3_o/k>`00ol0003ofMWIomWIf@0=omWIf@;o00003oo6a/H00ol0003o/k>cok>c/`0>ok>c/`03o`00
0?nOWiooWinO00goWinO0_l0000@ohb<S003o`000?miNGWoNGUi00goNGUi0_l00002ofIVIPGooooo
00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0S_ooool2o`0000ook>c/00?o
0000omWIfOoIfMT03OoIfMT00ol0003oa/K6olK6aP0>olK6aP;o00003_nc/k<2o`0000ooWinO00?o
0000ohb<S?n<S8`03_n<S8`2o`0000koNGUi0_l00004ofIVIPGooooo00?o0000ooooooooool00_oo
ool000_ooooo00?o0000ooooooooool0SOooool00ol0003ok>c/onc/k00>onc/k003o`000?oIfMWo
fMWI00gofMWI00?o0000olK6a_o6a/H03_o6a/H00ol0003o/k>cok>c/`0=ok>c/`03o`000?nOWioo
WinO00koWinO00?o0000ohb<S?n<S8`03On<S8`2o`0000ooNGUi00?o0000ofIVI_mVIVH01?mVIVH5
ooooo`03o`000?oooooooooo00;ooooo000;ooooo`;o0000S?ooool2o`00013ok>c/00?o0000omWI
fOoIfMT03OoIfMT00ol0003oa/K6olK6aP0=olK6aP;o00003_nc/k<2o`00013oWinO00?o0000ohb<
S?n<S8`03On<S8`00ol0003oNGUiogUiN@0=ogUiN@;o00001omVIVH4ooooo`;o00001?ooool000_o
oooo00?o0000ooooooooool0R_ooool00ol0003ok>c/onc/k00>onc/k0;o00003ooIfMT00ol0003o
a/K6olK6aP0=olK6aP03o`000?nc/k?o/k>c00go/k>c00?o0000oinOWonOWil03_nOWil2o`0000ko
S8b<0_l0000?ogUiN@03o`000?mVIVKoIVIV00OoIVIV1Oooool00ol0003oooooooooo`02ooooo`00
2oooool00ol0003oooooooooo`29ooooo`03o`000?o/k>cok>c/00kok>c/00?o0000omWIfOoIfMT0
3_oIfMT00ol0003oa/K6olK6aP0=olK6aP03o`000?nc/k?o/k>c00go/k>c00?o0000oinOWonOWil0
3OnOWil2o`0000ooS8b<00?o0000ogUiNOmiNGT03_miNGT00ol0003oIVIVofIVIP08ofIVIPGooooo
00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0ROooool00ol0003ok>c/onc/
k00<onc/k0;o00003ooIfMT2o`0000ooa/K600?o0000ok>c/onc/k<03Onc/k<2o`0000koWinO0_l0
000>ohb<S0;o00003_miNGT3o`0000_oIVIV1Oooool00ol0003oooooooooo`02ooooo`002oooool0
0ol0003oooooooooo`28ooooo`03o`000?o/k>cok>c/00cok>c/00?o0000omWIfOoIfMT03_oIfMT0
0ol0003oa/K6olK6aP0=olK6aP;o00003_nc/k<2o`0000koWinO0_l0000?ohb<S003o`000?miNGWo
NGUi00goNGUi00?o0000ofIVI_mVIVH03?mVIVH5ooooo`03o`000?oooooooooo00;ooooo000;oooo
o`03o`000?oooooooooo08Kooooo0_l0000>onc/k003o`000?oIfMWofMWI00gofMWI0_l0000?olK6
aP03o`000?nc/k?o/k>c00go/k>c00?o0000oinOWonOWil03OnOWil00ol0003oS8b<ohb<S00=ohb<
S0;o00003omiNGT00ol0003oIVIVofIVIP0<ofIVIP;o00001?ooool00ol0003oooooooooo`02oooo
o`002oooool00ol0003oooooooooo`25ooooo`03o`000?o/k>cok>c/00kok>c/00?o0000omWIfOoI
fMT03OoIfMT00ol0003oa/K6olK6aP0=olK6aP03o`000?nc/k?o/k>c00co/k>c0_l0000>oinOW`;o
00003_n<S8`2o`00013oNGUi00?o0000ofIVI_mVIVH03?mVIVH00ol0003oDe=Cooooo`04ooooo`03
o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo08Cooooo00?o0000onc/k?o/k>`0
3_o/k>`00ol0003ofMWIomWIf@0=omWIf@03o`000?o6a/Koa/K600goa/K600?o0000ok>c/onc/k<0
3?nc/k<00ol0003oWinOoinOW`0=oinOW`03o`000?n<S8coS8b<00goS8b<00?o0000ogUiNOmiNGT0
3_miNGT2o`0000koIVIV00?o0000oe=CDomCDe<01Oooool00ol0003oooooooooo`02ooooo`002ooo
ool00ol0003oooooooooo`23ooooo`03o`000?o/k>cok>c/00gok>c/0_l0000>omWIf@;o00003_o6
a/H2o`0000ko/k>c0_l0000>oinOW`03o`000?n<S8coS8b<00coS8b<0_l0000>ogUiN@?o00003OmV
IVH3o`0000?oDe=C1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`22
ooooo`03o`000?o/k>cok>c/00gok>c/00?o0000omWIfOoIfMT03OoIfMT00ol0003oa/K6olK6aP0=
olK6aP03o`000?nc/k?o/k>c00go/k>c00?o0000oinOWonOWil03OnOWil00ol0003oS8b<ohb<S00<
ohb<S003o`000?miNGWoNGUi00goNGUi00?o0000ofIVI_mVIVH03OmVIVH00ol0003oDe=Coe=CD`04
oe=CD`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0POooool00ol0
003ok>c/onc/k00=onc/k003o`000?oIfMWofMWI00gofMWI00?o0000olK6a_o6a/H03Oo6a/H00ol0
003o/k>cok>c/`0=ok>c/`03o`000?nOWiooWinO00goWinO00?o0000ohb<S?n<S8`03?n<S8`00ol0
003oNGUiogUiN@0=ogUiN@03o`000?mVIVKoIVIV00goIVIV00?o0000oe=CDomCDe<01OmCDe<5oooo
o`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo083ooooo0_l0000>onc/k003
o`000?oIfMWofMWI00cofMWI0_l0000>olK6aP;o00003_nc/k<2o`0000koWinO0_l0000>ohb<S0;o
00003_miNGT2o`0000koIVIV00?o0000oe=CDomCDe<01_mCDe<5ooooo`03o`000?oooooooooo00;o
oooo000;ooooo`03o`000?oooooooooo07oooooo00?o0000onc/k?o/k>`03?o/k>`2o`0000kofMWI
00?o0000olK6a_o6a/H03Oo6a/H00ol0003o/k>cok>c/`0=ok>c/`03o`000?nOWiooWinO00coWinO
0_l0000>ohb<S0;o00003_miNGT2o`0000koIVIV0_l00009oe=CD`Gooooo00?o0000ooooooooool0
0_ooool000_ooooo00?o0000ooooooooool0O_ooool00ol0003ok>c/onc/k00<onc/k003o`000?oI
fMWofMWI00gofMWI00?o0000olK6a_o6a/H03Oo6a/H00ol0003o/k>cok>c/`0<ok>c/`;o00003_nO
Wil00ol0003oS8b<ohb<S00=ohb<S003o`000?miNGWoNGUi00goNGUi00?o0000ofIVI_mVIVH02omV
IVH3o`0000_oDe=C1Oooool00ol0003oooooooooo`02ooooo`002oooool2o`0007kooooo00?o0000
onc/k?o/k>`03Oo/k>`00ol0003ofMWIomWIf@0<omWIf@03o`000?o6a/Koa/K600goa/K600?o0000
ok>c/onc/k<03?nc/k<00ol0003oWinOoinOW`0=oinOW`03o`000?n<S8coS8b<00goS8b<00?o0000
ogUiNOmiNGT03?miNGT2o`0000goIVIV00?o0000oe=CDomCDe<03?mCDe<4ooooo`;o00001?ooool0
00_ooooo00?o0000ooooooooool0O?ooool00ol0003ok>c/onc/k00=onc/k003o`000?oIfMWofMWI
00cofMWI00?o0000olK6a_o6a/H03Oo6a/H00ol0003o/k>cok>c/`0<ok>c/`03o`000?nOWiooWinO
00goWinO00?o0000ohb<S?n<S8`03On<S8`00ol0003oNGUiogUiN@0;ogUiN@;o00003_mVIVH00ol0
003oDe=Coe=CD`0=oe=CD`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool000_o
oooo00?o0000ooooooooool0Noooool00ol0003ok>c/onc/k00<onc/k0;o00003_oIfMT00ol0003o
a/K6olK6aP0=olK6aP03o`000?nc/k?o/k>c00_o/k>c0_l0000>oinOW`;o00003_n<S8`2o`0000go
NGUi0_l0000>ofIVIP03o`000?mCDe?oDe=C00coDe=C0_l00005ooooo`03o`000?oooooooooo00;o
oooo000;ooooo`03o`000?oooooooooo07[ooooo00?o0000onc/k?o/k>`03?o/k>`00ol0003ofMWI
omWIf@0<omWIf@;o00003_o6a/H2o`0000go/k>c00?o0000oinOWonOWil03OnOWil00ol0003oS8b<
ohb<S00=ohb<S003o`000?miNGWoNGUi00_oNGUi0_l0000>ofIVIP;o00003OmCDe<2o`0000;o?clo
1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`1iooooo`03o`000?o/
k>cok>c/00cok>c/00?o0000omWIfOoIfMT03?oIfMT00ol0003oa/K6olK6aP0=olK6aP03o`000?nc
/k?o/k>c00co/k>c00?o0000oinOWonOWil03?nOWil2o`0000koS8b<0_l0000=ogUiN@03o`000?mV
IVKoIVIV00coIVIV0_l0000=oe=CD`;o00001?lo?cl5ooooo`03o`000?oooooooooo00;ooooo000;
ooooo`03o`000?oooooooooo07Sooooo00?o0000onc/k?o/k>`03Oo/k>`00ol0003ofMWIomWIf@0;
omWIf@03o`000?o6a/Koa/K600goa/K600?o0000ok>c/onc/k<03Onc/k<00ol0003oWinOoinOW`0;
oinOW`03o`000?n<S8coS8b<00goS8b<00?o0000ogUiNOmiNGT02omiNGT2o`0000koIVIV0_l0000=
oe=CD`03o`000?lo?coo?clo00Co?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0
003oooooooooo`1gooooo`03o`000?o/k>cok>c/00cok>c/0_l0000=omWIf@03o`000?o6a/Koa/K6
00goa/K600?o0000ok>c/onc/k<03Onc/k<00ol0003oWinOoinOW`0;oinOW`03o`000?n<S8coS8b<
00coS8b<0_l0000=ogUiN@03o`000?mVIVKoIVIV00goIVIV00?o0000oe=CDomCDe<03?mCDe<00ol0
003o?clooclo?`05oclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000oooooooo
ool0M_ooool00ol0003ok>c/onc/k00<onc/k003o`000?oIfMWofMWI00cofMWI00?o0000olK6a_o6
a/H03?o6a/H2o`0000ko/k>c0_l0000=oinOW`03o`000?n<S8coS8b<00coS8b<00?o0000ogUiNOmi
NGT03?miNGT00ol0003oIVIVofIVIP0=ofIVIP03o`000?mCDe?oDe=C00coDe=C00?o0000oclo?olo
?cl01_lo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo07Gooooo
00?o0000onc/k?o/k>`03?o/k>`00ol0003ofMWIomWIf@0=omWIf@03o`000?o6a/Koa/K600_oa/K6
00?o0000ok>c/onc/k<03Onc/k<00ol0003oWinOoinOW`0<oinOW`03o`000?n<S8coS8b<00coS8b<
0_l0000=ogUiN@03o`000?mVIVKoIVIV00goIVIV00?o0000oe=CDomCDe<02omCDe<2o`0000Wo?clo
1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`1dooooo`03o`000?o/
k>cok>c/00gok>c/00?o0000omWIfOoIfMT03?oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`000?nc
/k?o/k>c00go/k>c00?o0000oinOWonOWil03?nOWil00ol0003oS8b<ohb<S00<ohb<S003o`000?mi
NGWoNGUi00coNGUi00?o0000ofIVI_mVIVH03?mVIVH2o`0000goDe=C00?o0000oclo?olo?cl02Olo
?cl5ooooo`03o`000?oooooooooo00;ooooo0004ooooo`?o00001?ooool00ol0003oooooooooo`1c
ooooo`03o`000?o/k>cok>c/00cok>c/0_l0000=omWIf@;o00003Oo6a/H2o`0000go/k>c0_l0000=
oinOW`;o00003On<S8`2o`0000goNGUi0_l0000<ofIVIP?o00003OmCDe<2o`0000co?clo1Oooool0
0ol0003oooooooooo`02ooooo`001Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
07;ooooo00?o0000onc/k?o/k>`03?o/k>`00ol0003ofMWIomWIf@0<omWIf@03o`000?o6a/Koa/K6
00coa/K600?o0000ok>c/onc/k<03?nc/k<00ol0003oWinOoinOW`0<oinOW`03o`000?n<S8coS8b<
00coS8b<00?o0000ogUiNOmiNGT02omiNGT2o`0000goIVIV00?o0000oe=CDomCDe<03OmCDe<00ol0
003o?clooclo?`0<oclo?`Gooooo00?o0000ooooooooool00_ooool000;ooooo1Ol00004ooooo`03
o`000?oooooooooo077ooooo00?o0000onc/k?o/k>`03?o/k>`00ol0003ofMWIomWIf@0<omWIf@03
o`000?o6a/Koa/K600coa/K600?o0000ok>c/onc/k<03?nc/k<00ol0003oWinOoinOW`0;oinOW`;o
00003On<S8`2o`0000goNGUi00?o0000ofIVI_mVIVH03?mVIVH00ol0003oDe=Coe=CD`0<oe=CD`;o
00003olo?cl5ooooo`03o`000?oooooooooo00;ooooo0002ooooo`04o`000?ooooooooooo`0000Go
oooo0ol0001aooooo`03o`000?o/k>cok>c/00cok>c/00?o0000omWIfOoIfMT02ooIfMT2o`0000go
a/K600?o0000ok>c/onc/k<03?nc/k<00ol0003oWinOoinOW`0<oinOW`03o`000?n<S8coS8b<00co
S8b<00?o0000ogUiNOmiNGT02omiNGT2o`0000goIVIV00?o0000oe=CDomCDe<02omCDe<2o`00017o
?clo1?ooool2o`0000Cooooo0003ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool0
L?ooool00ol0003ok>c/onc/k00;onc/k0;o00003OoIfMT00ol0003oa/K6olK6aP0<olK6aP03o`00
0?nc/k?o/k>c00co/k>c00?o0000oinOWonOWil03?nOWil00ol0003oS8b<ohb<S00;ohb<S0;o0000
3OmiNGT00ol0003oIVIVofIVIP0<ofIVIP03o`000?mCDe?oDe=C00_oDe=C00?o0000oclo?olo?cl0
4Olo?cl5ooooo`03o`000?oooooooooo00;ooooo0004ooooo`;o00001Oooool00ol0003ooooooooo
o`1_ooooo`03o`000?o/k>cok>c/00_ok>c/00?o0000omWIfOoIfMT03?oIfMT00ol0003oa/K6olK6
aP0<olK6aP03o`000?nc/k?o/k>c00co/k>c00?o0000oinOWonOWil02onOWil2o`0000goS8b<00?o
0000ogUiNOmiNGT02omiNGT2o`0000goIVIV0_l0000<oe=CD`;o00005?lo?cl5ooooo`03o`000?oo
oooooooo00;ooooo0005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0K_ooool0
0ol0003ok>c/onc/k00<onc/k003o`000?oIfMWofMWI00_ofMWI00?o0000olK6a_o6a/H03?o6a/H0
0ol0003o/k>cok>c/`0<ok>c/`03o`000?nOWiooWinO00_oWinO00?o0000ohb<S?n<S8`03?n<S8`0
0ol0003oNGUiogUiN@0;ogUiN@03o`000?mVIVKoIVIV00coIVIV00?o0000oe=CDomCDe<02omCDe<0
0ol0003o?clooclo?`0Doclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000oooo
ooooool0KOooool00ol0003ok>c/onc/k00<onc/k003o`000?oIfMWofMWI00_ofMWI00?o0000olK6
a_o6a/H03?o6a/H00ol0003o/k>cok>c/`0<ok>c/`03o`000?nOWiooWinO00_oWinO00?o0000ohb<
S?n<S8`03?n<S8`00ol0003oNGUiogUiN@0;ogUiN@03o`000?mVIVKoIVIV00coIVIV00?o0000oe=C
DomCDe<02omCDe<00ol0003o?clooclo?`0Eoclo?`Gooooo00?o0000ooooooooool00_ooool000_o
oooo00?o0000ooooooooool0K?ooool00ol0003ok>c/onc/k00;onc/k0;o00003OoIfMT00ol0003o
a/K6olK6aP0;olK6aP;o00003Onc/k<2o`0000goWinO00?o0000ohb<S?n<S8`02on<S8`2o`0000go
NGUi0_l0000<ofIVIP;o00003OmCDe<2o`0001Oo?clo1Oooool00ol0003oooooooooo`02ooooo`00
2oooool00ol0003oooooooooo`1[ooooo`03o`000?o/k>cok>c/00_ok>c/00?o0000omWIfOoIfMT0
3?oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00co/k>c00?o0000oinOWonOWil0
2onOWil2o`0000goS8b<00?o0000ogUiNOmiNGT02omiNGT2o`0000goIVIV00?o0000oe=CDomCDe<0
2omCDe<2o`0001Wo?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003ooooooooo
o`1Zooooo`03o`000?o/k>cok>c/00_ok>c/00?o0000omWIfOoIfMT03?oIfMT00ol0003oa/K6olK6
aP0;olK6aP03o`000?nc/k?o/k>c00co/k>c00?o0000oinOWonOWil02onOWil00ol0003oS8b<ohb<
S00<ohb<S003o`000?miNGWoNGUi00_oNGUi00?o0000ofIVI_mVIVH02omVIVH2o`0000goDe=C00?o
0000oclo?olo?cl06Olo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooo
oooo06Wooooo00?o0000onc/k?o/k>`03?o/k>`00ol0003ofMWIomWIf@0;omWIf@;o00003Oo6a/H0
0ol0003o/k>cok>c/`0;ok>c/`;o00003OnOWil00ol0003oS8b<ohb<S00;ohb<S003o`000?miNGWo
NGUi00_oNGUi00?o0000ofIVI_mVIVH02omVIVH00ol0003oDe=Coe=CD`0<oe=CD`03o`000?lo?coo
?clo01[o?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`1Yoooo
o`03o`000?o/k>cok>c/00_ok>c/00?o0000omWIfOoIfMT02ooIfMT00ol0003oa/K6olK6aP0<olK6
aP03o`000?nc/k?o/k>c00_o/k>c00?o0000oinOWonOWil02onOWil2o`0000goS8b<00?o0000ogUi
NOmiNGT02omiNGT00ol0003oIVIVofIVIP0;ofIVIP03o`000?mCDe?oDe=C00coDe=C00?o0000oclo
?olo?cl06olo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo06So
oooo00?o0000onc/k?o/k>`02oo/k>`00ol0003ofMWIomWIf@0;omWIf@03o`000?o6a/Koa/K600co
a/K600?o0000ok>c/onc/k<02onc/k<00ol0003oWinOoinOW`0;oinOW`03o`000?n<S8coS8b<00_o
S8b<0_l0000=ogUiN@03o`000?mVIVKoIVIV00_oIVIV00?o0000oe=CDomCDe<02omCDe<2o`0001ko
?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`1Wooooo`03o`00
0?o/k>cok>c/00_ok>c/00?o0000omWIfOoIfMT03?oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`00
0?nc/k?o/k>c00_o/k>c00?o0000oinOWonOWil02onOWil00ol0003oS8b<ohb<S00;ohb<S003o`00
0?miNGWoNGUi00coNGUi00?o0000ofIVI_mVIVH02omVIVH00ol0003oDe=Coe=CD`0;oe=CD`03o`00
0?lo?coo?clo01ko?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003ooooooooo
o`1Vooooo`03o`000?o/k>cok>c/00_ok>c/00?o0000omWIfOoIfMT03?oIfMT00ol0003oa/K6olK6
aP0;olK6aP03o`000?nc/k?o/k>c00_o/k>c00?o0000oinOWonOWil02onOWil00ol0003oS8b<ohb<
S00;ohb<S003o`000?miNGWoNGUi00coNGUi00?o0000ofIVI_mVIVH02omVIVH00ol0003oDe=Coe=C
D`0;oe=CD`03o`000?lo?coo?clo01oo?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool2
o`0006Kooooo00?o0000onc/k?o/k>`02oo/k>`2o`0000cofMWI0_l0000=olK6aP03o`000?nc/k?o
/k>c00_o/k>c00?o0000oinOWonOWil02onOWil00ol0003oS8b<ohb<S00;ohb<S0;o00003?miNGT2
o`0000goIVIV00?o0000oe=CDomCDe<02_mCDe<2o`0002;o?clo1?ooool2o`0000Cooooo000;oooo
o`03o`000?oooooooooo06Cooooo00?o0000onc/k?o/k>`02oo/k>`00ol0003ofMWIomWIf@0;omWI
f@03o`000?o6a/Koa/K600_oa/K60_l0000=ok>c/`03o`000?nOWiooWinO00_oWinO00?o0000ohb<
S?n<S8`02on<S8`00ol0003oNGUiogUiN@0;ogUiN@03o`000?mVIVKoIVIV00_oIVIV0_l0000<oe=C
D`03o`000?lo?coo?clo02;o?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003o
ooooooooo`1Sooooo`03o`000?o/k>cok>c/00_ok>c/00?o0000omWIfOoIfMT02ooIfMT00ol0003o
a/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00co/k>c00?o0000oinOWonOWil02onOWil00ol0003o
S8b<ohb<S00;ohb<S003o`000?miNGWoNGUi00[oNGUi0_l0000=ofIVIP03o`000?mCDe?oDe=C00[o
De=C0_l0000Uoclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0
Hoooool00ol0003ok>c/onc/k00;onc/k003o`000?oIfMWofMWI00_ofMWI00?o0000olK6a_o6a/H0
2oo6a/H00ol0003o/k>cok>c/`0;ok>c/`03o`000?nOWiooWinO00_oWinO00?o0000ohb<S?n<S8`0
2on<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00coIVIV00?o0000oe=CDomCDe<0
2_mCDe<00ol0003o?clooclo?`0Uoclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0H_ooool00ol0003ok>c/onc/k00;onc/k003o`000?oIfMWofMWI00_ofMWI00?o
0000olK6a_o6a/H02oo6a/H00ol0003o/k>cok>c/`0;ok>c/`03o`000?nOWiooWinO00_oWinO00?o
0000ohb<S?n<S8`02on<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00coIVIV00?o
0000oe=CDomCDe<02_mCDe<00ol0003o?clooclo?`0Voclo?`Gooooo00?o0000ooooooooool00_oo
ool000_ooooo00?o0000ooooooooool0HOooool00ol0003ok>c/onc/k00;onc/k003o`000?oIfMWo
fMWI00_ofMWI00?o0000olK6a_o6a/H02oo6a/H00ol0003o/k>cok>c/`0:ok>c/`;o00003?nOWil2
o`0000goS8b<00?o0000ogUiNOmiNGT02omiNGT00ol0003oIVIVofIVIP0:ofIVIP;o00003?mCDe<0
0ol0003o?clooclo?`0Woclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000oooo
ooooool0HOooool00ol0003ok>c/onc/k00;onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6
a_o6a/H02oo6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00coWinO00?o0000ohb<
S?n<S8`02on<S8`00ol0003oNGUiogUiN@0;ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o0000oe=C
DomCDe<02omCDe<00ol0003o?clooclo?`0Xoclo?`Gooooo00?o0000ooooooooool00_ooool000_o
oooo00?o0000ooooooooool0H?ooool00ol0003ok>c/onc/k00;onc/k003o`000?oIfMWofMWI00_o
fMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00co
WinO00?o0000ohb<S?n<S8`02on<S8`00ol0003oNGUiogUiN@0;ogUiN@03o`000?mVIVKoIVIV00[o
IVIV00?o0000oe=CDomCDe<02omCDe<00ol0003o?clooclo?`0Yoclo?`Gooooo00?o0000oooooooo
ool00_ooool000_ooooo00?o0000ooooooooool0Goooool00ol0003ok>c/onc/k00:onc/k0;o0000
3?oIfMT2o`0000coa/K600?o0000ok>c/onc/k<02onc/k<00ol0003oWinOoinOW`0:oinOW`;o0000
3?n<S8`2o`0000coNGUi0_l0000;ofIVIP;o00003OmCDe<00ol0003o?clooclo?`0Zoclo?`Gooooo
00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0G_ooool00ol0003ok>c/onc/
k00;onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H03?o6a/H00ol0003o/k>cok>c
/`0:ok>c/`03o`000?nOWiooWinO00[oWinO00?o0000ohb<S?n<S8`02on<S8`00ol0003oNGUiogUi
N@0;ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o0000oe=CDomCDe<03?mCDe<00ol0003o?clooclo
?`0[oclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0GOooool0
0ol0003ok>c/onc/k00;onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02oo6a/H2
o`0000co/k>c00?o0000oinOWonOWil02_nOWil00ol0003oS8b<ohb<S00;ohb<S003o`000?miNGWo
NGUi00[oNGUi0_l0000<ofIVIP03o`000?mCDe?oDe=C00_oDe=C0_l0000^oclo?`Gooooo00?o0000
ooooooooool00_ooool000_ooooo00?o0000ooooooooool0G?ooool00ol0003ok>c/onc/k00;onc/
k003o`000?oIfMWofMWI00_ofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`0;ok>c
/`03o`000?nOWiooWinO00_oWinO00?o0000ohb<S?n<S8`02_n<S8`00ol0003oNGUiogUiN@0:ogUi
N@03o`000?mVIVKoIVIV00coIVIV00?o0000oe=CDomCDe<02_mCDe<00ol0003o?clooclo?`0^oclo
?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0G?ooool00ol0003o
k>c/onc/k00:onc/k003o`000?oIfMWofMWI00_ofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o
/k>cok>c/`0;ok>c/`03o`000?nOWiooWinO00_oWinO00?o0000ohb<S?n<S8`02_n<S8`00ol0003o
NGUiogUiN@0;ogUiN@03o`000?mVIVKoIVIV00[oIVIV0_l0000<oe=CD`03o`000?lo?coo?clo02oo
?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool2o`0005cooooo00?o0000onc/k?o/k>`0
2_o/k>`00ol0003ofMWIomWIf@0;omWIf@03o`000?o6a/Koa/K600[oa/K60_l0000<ok>c/`03o`00
0?nOWiooWinO00[oWinO0_l0000<ohb<S003o`000?miNGWoNGUi00_oNGUi00?o0000ofIVI_mVIVH0
2_mVIVH00ol0003oDe=Coe=CD`0:oe=CD`;o0000<_lo?cl4ooooo`;o00001?ooool000_ooooo00?o
0000ooooooooool0Foooool00ol0003ok>c/onc/k00:onc/k003o`000?oIfMWofMWI00[ofMWI00?o
0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`0<ok>c/`03o`000?nOWiooWinO00[oWinO00?o
0000ohb<S?n<S8`02on<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o
0000oe=CDomCDe<02_mCDe<00ol0003o?clooclo?`0boclo?`Gooooo00?o0000ooooooooool00_oo
ool000_ooooo00?o0000ooooooooool0F_ooool00ol0003ok>c/onc/k00:onc/k003o`000?oIfMWo
fMWI00[ofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`0<ok>c/`03o`000?nOWioo
WinO00[oWinO00?o0000ohb<S?n<S8`02on<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKo
IVIV00[oIVIV00?o0000oe=CDomCDe<02omCDe<00ol0003o?clooclo?`0boclo?`Gooooo00?o0000
ooooooooool00_ooool000_ooooo00?o0000ooooooooool0FOooool00ol0003ok>c/onc/k00:onc/
k003o`000?oIfMWofMWI00_ofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`0:ok>c
/`;o00003?nOWil00ol0003oS8b<ohb<S00:ohb<S0;o00002omiNGT2o`0000_oIVIV0_l0000=oe=C
D`03o`000?lo?coo?clo03?o?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool00ol0003o
ooooooooo`1Hooooo`03o`000?o/k>cok>c/00[ok>c/00?o0000omWIfOoIfMT02ooIfMT00ol0003o
a/K6olK6aP0:olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil02onOWil00ol0003o
S8b<ohb<S00:ohb<S003o`000?miNGWoNGUi00[oNGUi00?o0000ofIVI_mVIVH02_mVIVH00ol0003o
De=Coe=CD`0;oe=CD`;o0000=_lo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`00
0?oooooooooo05Oooooo00?o0000onc/k?o/k>`02_o/k>`00ol0003ofMWIomWIf@0:omWIf@;o0000
3?o6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00_oWinO00?o0000ohb<S?n<S8`0
2_n<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o0000oe=CDomCDe<0
2omCDe<00ol0003o?clooclo?`0foclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0Eoooool00ol0003ok>c/onc/k00:onc/k003o`000?oIfMWofMWI00[ofMWI00?o
0000olK6a_o6a/H02oo6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00[oWinO00?o
0000ohb<S?n<S8`02_n<S8`00ol0003oNGUiogUiN@0:ogUiN@;o00003?mVIVH00ol0003oDe=Coe=C
D`0:oe=CD`03o`000?lo?coo?clo03Oo?clo1Oooool00ol0003oooooooooo`02ooooo`002oooool0
0ol0003oooooooooo`1Fooooo`03o`000?o/k>cok>c/00[ok>c/00?o0000omWIfOoIfMT02_oIfMT0
0ol0003oa/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil02_nOWil0
0ol0003oS8b<ohb<S00:ohb<S003o`000?miNGWoNGUi00[oNGUi00?o0000ofIVI_mVIVH02omVIVH0
0ol0003oDe=Coe=CD`0:oe=CD`03o`000?lo?coo?clo03So?clo1Oooool00ol0003oooooooooo`02
ooooo`002oooool00ol0003oooooooooo`1Eooooo`03o`000?o/k>cok>c/00[ok>c/00?o0000omWI
fOoIfMT02_oIfMT00ol0003oa/K6olK6aP0;olK6aP03o`000?nc/k?o/k>c00Wo/k>c0_l0000;oinO
W`;o00003?n<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00[oIVIV0_l0000;oe=C
D`;o0000>olo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo05Co
oooo00?o0000onc/k?o/k>`02_o/k>`2o`0000_ofMWI0_l0000;olK6aP;o00002onc/k<00ol0003o
WinOoinOW`0;oinOW`03o`000?n<S8coS8b<00[oS8b<00?o0000ogUiNOmiNGT02_miNGT00ol0003o
IVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00[oDe=C00?o0000oclo?olo?cl0>olo?cl5ooooo`03
o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo05?ooooo00?o0000onc/k?o/k>`0
2_o/k>`00ol0003ofMWIomWIf@0:omWIf@03o`000?o6a/Koa/K600[oa/K600?o0000ok>c/onc/k<0
2_nc/k<00ol0003oWinOoinOW`0;oinOW`03o`000?n<S8coS8b<00[oS8b<00?o0000ogUiNOmiNGT0
2_miNGT00ol0003oIVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00[oDe=C00?o0000oclo?olo?cl0
??lo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo05?ooooo00?o
0000onc/k?o/k>`02_o/k>`00ol0003ofMWIomWIf@0:omWIf@03o`000?o6a/Koa/K600[oa/K600?o
0000ok>c/onc/k<02_nc/k<00ol0003oWinOoinOW`0:oinOW`03o`000?n<S8coS8b<00[oS8b<00?o
0000ogUiNOmiNGT02_miNGT00ol0003oIVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00[oDe=C0_l0
000noclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0D_ooool0
0ol0003ok>c/onc/k00:onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02_o6a/H0
0ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00[oWinO00?o0000ohb<S?n<S8`02_n<S8`0
0ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o0000oe=CDomCDe<02_mCDe<0
0ol0003o?clooclo?`0noclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000oooo
ooooool0DOooool2o`0000_ok>c/00?o0000omWIfOoIfMT02_oIfMT00ol0003oa/K6olK6aP0:olK6
aP03o`000?nc/k?o/k>c00[o/k>c00?o0000oinOWonOWil02_nOWil00ol0003oS8b<ohb<S00:ohb<
S003o`000?miNGWoNGUi00[oNGUi00?o0000ofIVI_mVIVH02_mVIVH00ol0003oDe=Coe=CD`09oe=C
D`;o0000@Olo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`;o0000D_ooool00ol0003o
k>c/onc/k00:onc/k003o`000?oIfMWofMWI00WofMWI00?o0000olK6a_o6a/H02oo6a/H00ol0003o
/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`02_n<S8`00ol0003o
NGUiogUiN@0:ogUiN@;o00002omVIVH00ol0003oDe=Coe=CD`09oe=CD`03o`000?lo?coo?clo047o
?clo1?ooool2o`0000Cooooo000;ooooo`03o`000?oooooooooo053ooooo00?o0000onc/k?o/k>`0
2_o/k>`00ol0003ofMWIomWIf@09omWIf@03o`000?o6a/Koa/K600_oa/K600?o0000ok>c/onc/k<0
2_nc/k<00ol0003oWinOoinOW`0:oinOW`03o`000?n<S8coS8b<00[oS8b<00?o0000ogUiNOmiNGT0
2OmiNGT00ol0003oIVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00WoDe=C00?o0000oclo?olo?cl0
@_lo?cl5ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo04oooooo0_l0
000;onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c
/`0:ok>c/`03o`000?nOWiooWinO00[oWinO00?o0000ohb<S?n<S8`02_n<S8`00ol0003oNGUiogUi
N@09ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o0000oe=CDomCDe<02_mCDe<00ol0003o?clooclo
?`12oclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0Coooool0
0ol0003ok>c/onc/k009onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02_o6a/H0
0ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00WoWinO0_l0000;ohb<S0;o00002omiNGT0
0ol0003oIVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00[oDe=C00?o0000oclo?olo?cl0@olo?cl5
ooooo`03o`000?oooooooooo00;ooooo000;ooooo`03o`000?oooooooooo04kooooo00?o0000onc/
k?o/k>`02Oo/k>`00ol0003ofMWIomWIf@0:omWIf@03o`000?o6a/Koa/K600[oa/K600?o0000ok>c
/onc/k<02_nc/k<00ol0003oWinOoinOW`09oinOW`03o`000?n<S8coS8b<00[oS8b<00?o0000ogUi
NOmiNGT02_miNGT00ol0003oIVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00WoDe=C0_l00016oclo
?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0COooool00ol0003o
k>c/onc/k00:onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o
/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`02_n<S8`00ol0003o
NGUiogUiN@09ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o0000oe=CDomCDe<02_mCDe<00ol0003o
?clooclo?`15oclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0
C?ooool00ol0003ok>c/onc/k00;onc/k003o`000?oIfMWofMWI00WofMWI00?o0000olK6a_o6a/H0
2_o6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`0
2_n<S8`00ol0003oNGUiogUiN@09ogUiN@03o`000?mVIVKoIVIV00[oIVIV00?o0000oe=CDomCDe<0
2_mCDe<00ol0003o?clooclo?`16oclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o
0000ooooooooool0C?ooool00ol0003ok>c/onc/k00:onc/k003o`000?oIfMWofMWI00WofMWI00?o
0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`09ok>c/`;o00002onOWil00ol0003oS8b<ohb<
S009ohb<S0;o00002omiNGT00ol0003oIVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00WoDe=C0_l0
0019oclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0C?ooool0
0ol0003ok>c/onc/k009onc/k003o`000?oIfMWofMWI00WofMWI00?o0000olK6a_o6a/H02_o6a/H0
0ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`02On<S8`0
0ol0003oNGUiogUiN@0;ogUiN@03o`000?mVIVKoIVIV00WoIVIV00?o0000oe=CDomCDe<02OmCDe<0
0ol0003o?clooclo?`19oclo?`Gooooo00?o0000ooooooooool00_ooool000_ooooo00?o0000oooo
ooooool0Boooool00ol0003ok>c/onc/k009onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6
a_o6a/H02_o6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<
S?n<S8`02_n<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00WoIVIV00?o0000oe=C
DomCDe<02OmCDe<00ol0003o?clooclo?`1:oclo?`Gooooo00?o0000ooooooooool00_ooool000_o
oooo00?o0000ooooooooool0B_ooool00ol0003ok>c/onc/k00:onc/k003o`000?oIfMWofMWI00Wo
fMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00[o
WinO00?o0000ohb<S?n<S8`02On<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00Wo
IVIV00?o0000oe=CDomCDe<02_mCDe<00ol0003o?clooclo?`1:oclo?`Gooooo00?o0000oooooooo
ool00_ooool000_ooooo00?o0000ooooooooool0B_ooool00ol0003ok>c/onc/k009onc/k003o`00
0?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02Oo6a/H00ol0003o/k>cok>c/`09ok>c/`03o`00
0?nOWiooWinO00[oWinO00?o0000ohb<S?n<S8`02On<S8`00ol0003oNGUiogUiN@09ogUiN@;o0000
2omVIVH00ol0003oDe=Coe=CD`0:oe=CD`03o`000?lo?coo?clo04_o?clo1Oooool00ol0003ooooo
ooooo`02ooooo`002oooool00ol0003oooooooooo`19ooooo`03o`000?o/k>cok>c/00Wok>c/00?o
0000omWIfOoIfMT02OoIfMT2o`0000_oa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003oWinOoinO
W`0:oinOW`03o`000?n<S8coS8b<00WoS8b<00?o0000ogUiNOmiNGT02OmiNGT00ol0003oIVIVofIV
IP0:ofIVIP03o`000?mCDe?oDe=C00WoDe=C0_l0001>oclo?`Gooooo00?o0000ooooooooool00_oo
ool000_ooooo0_l0001:ooooo`03o`000?o/k>cok>c/00Sok>c/00?o0000omWIfOoIfMT02_oIfMT0
0ol0003oa/K6olK6aP09olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000oinOWonOWil02_nOWil0
0ol0003oS8b<ohb<S009ohb<S003o`000?miNGWoNGUi00[oNGUi00?o0000ofIVI_mVIVH02OmVIVH2
o`0000[oDe=C00?o0000oclo?olo?cl0C_lo?cl4ooooo`;o00001?ooool000_ooooo00?o0000oooo
ooooool0B?ooool00ol0003ok>c/onc/k009onc/k003o`000?oIfMWofMWI00WofMWI00?o0000olK6
a_o6a/H02Oo6a/H00ol0003o/k>cok>c/`0:ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<
S?n<S8`02On<S8`00ol0003oNGUiogUiN@0:ogUiN@03o`000?mVIVKoIVIV00WoIVIV00?o0000oe=C
DomCDe<02OmCDe<00ol0003o?clooclo?`1?oclo?`Gooooo00?o0000ooooooooool00_ooool000_o
oooo00?o0000ooooooooool0Aoooool00ol0003ok>c/onc/k009onc/k003o`000?oIfMWofMWI00Wo
fMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`09ok>c/`03o`000?nOWiooWinO00Wo
WinO00?o0000ohb<S?n<S8`02_n<S8`00ol0003oNGUiogUiN@09ogUiN@03o`000?mVIVKoIVIV00Wo
IVIV00?o0000oe=CDomCDe<02_mCDe<00ol0003o?clooclo?`1?oclo?`Gooooo00?o0000oooooooo
ool00_ooool000_ooooo00?o0000ooooooooool0Aoooool00ol0003ok>c/onc/k009onc/k003o`00
0?oIfMWofMWI00WofMWI00?o0000olK6a_o6a/H02_o6a/H00ol0003o/k>cok>c/`09ok>c/`03o`00
0?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`02_n<S8`00ol0003oNGUiogUiN@08ogUiN@03o`00
0?mVIVKoIVIV00[oIVIV00?o0000oe=CDomCDe<02OmCDe<00ol0003o?clooclo?`1@oclo?`Gooooo
00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0A_ooool00ol0003ok>c/onc/
k009onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02Oo6a/H00ol0003o/k>cok>c
/`09ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`02On<S8`2o`0000_oNGUi00?o
0000ofIVI_mVIVH02OmVIVH00ol0003oDe=Coe=CD`09oe=CD`03o`000?lo?coo?clo057o?clo1Ooo
ool00ol0003oooooooooo`02ooooo`002oooool00ol0003oooooooooo`15ooooo`03o`000?o/k>co
k>c/00Wok>c/00?o0000omWIfOoIfMT02_oIfMT00ol0003oa/K6olK6aP08olK6aP;o00002onc/k<0
0ol0003oWinOoinOW`09oinOW`03o`000?n<S8coS8b<00WoS8b<0_l0000:ogUiN@;o00002_mVIVH2
o`0000_oDe=C00?o0000oclo?olo?cl0D_lo?cl5ooooo`03o`000?oooooooooo00;ooooo000;oooo
o`03o`000?oooooooooo04Cooooo00?o0000onc/k?o/k>`02_o/k>`00ol0003ofMWIomWIf@09omWI
f@03o`000?o6a/Koa/K600Woa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003oWinOoinOW`09oinO
W`03o`000?n<S8coS8b<00WoS8b<00?o0000ogUiNOmiNGT02OmiNGT00ol0003oIVIVofIVIP0:ofIV
IP03o`000?mCDe?oDe=C00WoDe=C00?o0000oclo?olo?cl0Dolo?cl5ooooo`03o`000?oooooooooo
00;ooooo000;ooooo`03o`000?oooooooooo04Cooooo00?o0000onc/k?o/k>`02Oo/k>`00ol0003o
fMWIomWIf@09omWIf@03o`000?o6a/Koa/K600Woa/K600?o0000ok>c/onc/k<02Onc/k<00ol0003o
WinOoinOW`09oinOW`03o`000?n<S8coS8b<00WoS8b<00?o0000ogUiNOmiNGT02OmiNGT00ol0003o
IVIVofIVIP0:ofIVIP03o`000?mCDe?oDe=C00WoDe=C00?o0000oclo?olo?cl0D_lo?cl4ool000?o
oooo00?o0000ooooooooool00_ooool000_ooooo00?o0000ooooooooool0A?ooool00ol0003ok>c/
onc/k008onc/k003o`000?oIfMWofMWI00[ofMWI00?o0000olK6a_o6a/H02Oo6a/H00ol0003o/k>c
ok>c/`09ok>c/`03o`000?nOWiooWinO00WoWinO00?o0000ohb<S?n<S8`02On<S8`00ol0003oNGUi
ogUiN@09ogUiN@03o`000?mVIVKoIVIV00WoIVIV00?o0000oe=CDomCDe<02OmCDe<00ol0003o?clo
oclo?`1Boclo?`;oo`000ol0o`001?oo003oooooooooool00004ooooo`002oooool00ol0003ooooo
ooooo`13ooooo`03o`000?o/k>cok>c/00Wok>c/00?o0000omWIfOoIfMT02OoIfMT00ol0003oa/K6
olK6aP09olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o0000oinOWonOWil02OnOWil00ol0003oS8b<
ohb<S009ohb<S003o`000?miNGWoNGUi00WoNGUi00?o0000ofIVI_mVIVH02OmVIVH00ol0003oDe=C
oe=CD`09oe=CD`03o`000?lo?coo?clo05;o?clo0_oo0005o`3o0003ool00?oooooo000000Cooooo
0003ooooo`?o00001Oooool00ol0003oooooooooo`12ooooo`03o`000?o/k>cok>c/00Wok>c/00?o
0000omWIfOoIfMT02OoIfMT00ol0003oa/K6olK6aP09olK6aP03o`000?nc/k?o/k>c00Wo/k>c00?o
0000oinOWonOWil02OnOWil00ol0003oS8b<ohb<S009ohb<S003o`000?miNGWoNGUi00WoNGUi00?o
0000ofIVI_mVIVH02OmVIVH00ol0003oDe=Coe=CD`09oe=CD`03o`000?lo?coo?clo05?o?clo0_oo
0005o`3o0003ool00?oooooo000000Cooooo0002ooooo`05o`000?ooooooooooooooool000001?oo
ool00ol0003oooooooooo`3oooooo`Gooooo0_oo0005o`3o0003ool00?oooooo000000Cooooo0006
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0ooooool5ooooo`?oo`000ol0o`02
ool00003ooooool0003ooooo00?ooooo0006ooooo`03o`000?oooooooooo00;ooooo0ol00002oooo
o`03o`000?oooooooooo043ooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`0ooooo
o`03o`000?oooooooooo03Wooooo1_oo0003o`0000Cooooo0002ooooo`Co00001Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01Oooool4ool00004
ooooool0003oooooo`0000Cooooo0002ooooo`03o`000?oooooooooo00Koooooool0000Bo`0000Co
oooo0002ooooo`Go0000oooooolJooooo`00oooooolQooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {1.74494, 0.733613, 0.0151023, \
0.0151023}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({1.4463351288035011`, {x1 \[Rule] 4.27683243559825`, 
            x2 \[Rule] 3.276832435598249`}}\), 
        ",", \({"Function" \[Rule] 244, "Gradient" \[Rule] 61}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[Zimmermann[x0, x1], {x0, x1}, Method -> "\<NelderMead\>", \ 
        StepMonitor \[RuleDelayed] \ Sow[{x0, x1}]]\  // \ Reap\)], "Input"],

Cell[BoxData[
    \({{8.791238501615339`*^-7, {x0 \[Rule] 6.999998783604371`, 
          x1 \[Rule] 2.0000003372717785`}}, {{{0.8623029168655965`, 
            0.2734682733530127`}, {3.838947373416694`, 
            0.09202210907595976`}, {6.154665374017035`, 
            0.22469887139250727`}, {6.154665374017035`, 
            0.22469887139250727`}, {6.154665374017035`, 
            0.22469887139250727`}, {6.278898510104389`, 
            0.3198141983304758`}, {6.278898510104389`, 
            0.3198141983304758`}, {6.278898510104389`, 
            0.3198141983304758`}, {6.278898510104389`, 
            0.3198141983304758`}, {6.498482121130294`, 
            0.28289642221743694`}, {6.622715257217648`, 
            0.3780117491554054`}, {6.622715257217648`, 
            0.3780117491554054`}, {6.622715257217648`, 
            0.3780117491554054`}, {6.672369110175747`, 
            0.4929159500693866`}, {6.672369110175747`, 
            0.4929159500693866`}, {6.672369110175747`, 
            0.4929159500693866`}, {6.675423224139575`, 
            0.5961700503000027`}, {6.8052884037246475`, 
            0.8165361692117725`}, {6.876329221444839`, 
            1.1332274291288895`}, {6.876329221444839`, 
            1.1332274291288895`}, {6.876329221444839`, 
            1.1332274291288895`}, {6.903110647928141`, 
            1.3870745981989128`}, {6.979977453899528`, 
            1.6400981653750533`}, {6.979977453899528`, 
            1.6400981653750533`}, {6.974151465648332`, 
            1.7037658581160298`}, {6.974151465648332`, 
            1.7037658581160298`}, {6.974151465648332`, 
            1.7037658581160298`}, {6.974151465648332`, 
            1.7037658581160298`}, {6.986308686254653`, 
            1.70753918843887`}, {6.980735320055423`, 
            1.8367612390822434`}, {6.992892540661743`, 
            1.8405345694050836`}, {6.987319174462512`, 
            1.9697566200484569`}, {6.999476395068832`, 
            1.9735299503712969`}, {6.999476395068832`, 
            1.9735299503712969`}, {6.999476395068832`, 
            1.9735299503712969`}, {6.999476395068832`, 
            1.9735299503712969`}, {6.9934609402786645`, 
            1.988031874685476`}, {6.9934609402786645`, 
            1.988031874685476`}, {6.9934609402786645`, 
            1.988031874685476`}, {6.9987560409765575`, 
            1.9835369856483687`}, {6.99274058618639`, 
            1.9980389099625477`}, {6.998035686884283`, 
            1.9935440209254405`}, {6.998035686884283`, 
            1.9935440209254405`}, {6.998035686884283`, 
            1.9935440209254405`}, {6.994546160425031`, 
            1.9988550853929006`}, {6.999841261122924`, 
            1.9943601963557933`}, {6.996351734663673`, 
            1.9996712608232534`}, {6.996351734663673`, 
            1.9996712608232534`}, {6.996351734663673`, 
            1.9996712608232534`}, {6.999018288452936`, 
            1.9985087249497262`}, {6.999018288452936`, 
            1.9985087249497262`}, {6.9974830690788705`, 
            2.0003441067639782`}, {6.9974830690788705`, 
            2.0003441067639782`}, {6.999200150817018`, 
            1.9993039933736516`}, {6.999200150817018`, 
            1.9993039933736516`}, {6.999200150817018`, 
            1.9993039933736516`}, {6.998757667140345`, 
            2.000307687946016`}, {6.999746258413564`, 
            1.9998220327169478`}, {6.999746258413564`, 
            1.9998220327169478`}, {6.999746258413564`, 
            1.9998220327169478`}, {6.999746258413564`, 
            1.9998220327169478`}, {6.9996323992469005`, 
            2.0000254021751744`}, {6.9996323992469005`, 
            2.0000254021751744`}, {6.999971417935195`, 
            1.9998465696439665`}, {6.999971417935195`, 
            1.9998465696439665`}, {6.999829733679789`, 
            1.9999929625058819`}, {6.999829733679789`, 
            1.9999929625058819`}, {6.999829733679789`, 
            1.9999929625058819`}, {6.999967619947641`, 
            1.9998933570498616`}, {6.999825935692233`, 
            2.0000397499117772`}, {6.999963821960085`, 
            1.9999401444557572`}, {6.999963821960085`, 
            1.9999401444557572`}, {6.999963821960085`, 
            1.9999401444557572`}, {6.99991333769062`, 
            2.000012398598554`}, {6.999990423967842`, 
            1.9999622189552797`}, {6.999990423967842`, 
            1.9999622189552797`}, {6.999945910263804`, 
            2.0000108909374967`}, {6.999945910263804`, 
            2.0000108909374967`}, {6.999995581828424`, 
            1.9999736331203053`}, {6.999995581828424`, 
            1.9999736331203053`}, {6.999995581828424`, 
            1.9999736331203053`}, {6.999982697989809`, 
            1.9999957145040486`}, {6.999982697989809`, 
            1.9999957145040486`}, {6.999982697989809`, 
            1.9999957145040486`}, {6.999982697989809`, 
            1.9999957145040486`}, {6.999990888371419`, 
            1.9999936455037917`}, {6.999990888371419`, 
            1.9999936455037917`}, {6.999985506547336`, 
            2.0000007978719108`}, {6.999999196398512`, 
            2.0000002360554565`}, {6.999999196398512`, 
            2.0000002360554565`}, {6.999999196398512`, 
            2.0000002360554565`}, {6.999999196398512`, 
            2.0000002360554565`}, {6.999999196398512`, 
            2.0000002360554565`}, {6.999999196398512`, 
            2.0000002360554565`}, {6.999999196398512`, 
            2.0000002360554565`}, {6.9999959591935905`, 
            1.9999995760821787`}, {6.99999636488015`, 
            1.9999997732928216`}, {6.9999976792176914`, 
            1.9999999553714782`}, {6.999998084904252`, 
            2.000000152582121`}, {6.999998084904252`, 
            2.000000152582121`}, {6.999998648973224`, 
            2.00000020264063`}, {6.999998783604371`, 
            2.0000003372717785`}, {6.999998783604371`, 
            2.0000003372717785`}}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[\ \((x1 - 3)\)^2\  + \ 30\ \((x2 - 2)\)^2, \ {x1, 0, 
        15}, {x2, 0, 5}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0641026 0.0192308 0.192308 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.14744 -0.0125 -3 -9 ]
[.14744 -0.0125 3 0 ]
[.27564 -0.0125 -3 -9 ]
[.27564 -0.0125 3 0 ]
[.40385 -0.0125 -3 -9 ]
[.40385 -0.0125 3 0 ]
[.53205 -0.0125 -3 -9 ]
[.53205 -0.0125 3 0 ]
[.66026 -0.0125 -6 -9 ]
[.66026 -0.0125 6 0 ]
[.78846 -0.0125 -6 -9 ]
[.78846 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .21154 -6 -4.5 ]
[-0.0125 .21154 0 4.5 ]
[-0.0125 .40385 -6 -4.5 ]
[-0.0125 .40385 0 4.5 ]
[-0.0125 .59615 -6 -4.5 ]
[-0.0125 .59615 0 4.5 ]
[-0.0125 .78846 -6 -4.5 ]
[-0.0125 .78846 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.14744 0 m
.14744 .00625 L
s
[(2)] .14744 -0.0125 0 1 Mshowa
.27564 0 m
.27564 .00625 L
s
[(4)] .27564 -0.0125 0 1 Mshowa
.40385 0 m
.40385 .00625 L
s
[(6)] .40385 -0.0125 0 1 Mshowa
.53205 0 m
.53205 .00625 L
s
[(8)] .53205 -0.0125 0 1 Mshowa
.66026 0 m
.66026 .00625 L
s
[(10)] .66026 -0.0125 0 1 Mshowa
.78846 0 m
.78846 .00625 L
s
[(12)] .78846 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(14)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05128 0 m
.05128 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.17949 0 m
.17949 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.24359 0 m
.24359 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.33974 0 m
.33974 .00375 L
s
.37179 0 m
.37179 .00375 L
s
.4359 0 m
.4359 .00375 L
s
.46795 0 m
.46795 .00375 L
s
.5 0 m
.5 .00375 L
s
.5641 0 m
.5641 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.62821 0 m
.62821 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.72436 0 m
.72436 .00375 L
s
.75641 0 m
.75641 .00375 L
s
.82051 0 m
.82051 .00375 L
s
.85256 0 m
.85256 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.94872 0 m
.94872 .00375 L
s
.98077 0 m
.98077 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .21154 m
.00625 .21154 L
s
[(1)] -0.0125 .21154 1 0 Mshowa
0 .40385 m
.00625 .40385 L
s
[(2)] -0.0125 .40385 1 0 Mshowa
0 .59615 m
.00625 .59615 L
s
[(3)] -0.0125 .59615 1 0 Mshowa
0 .78846 m
.00625 .78846 L
s
[(4)] -0.0125 .78846 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(5)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05769 m
.00375 .05769 L
s
0 .09615 m
.00375 .09615 L
s
0 .13462 m
.00375 .13462 L
s
0 .17308 m
.00375 .17308 L
s
0 .25 m
.00375 .25 L
s
0 .28846 m
.00375 .28846 L
s
0 .32692 m
.00375 .32692 L
s
0 .36538 m
.00375 .36538 L
s
0 .44231 m
.00375 .44231 L
s
0 .48077 m
.00375 .48077 L
s
0 .51923 m
.00375 .51923 L
s
0 .55769 m
.00375 .55769 L
s
0 .63462 m
.00375 .63462 L
s
0 .67308 m
.00375 .67308 L
s
0 .71154 m
.00375 .71154 L
s
0 .75 m
.00375 .75 L
s
0 .82692 m
.00375 .82692 L
s
0 .86538 m
.00375 .86538 L
s
0 .90385 m
.00375 .90385 L
s
0 .94231 m
.00375 .94231 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.14744 .99375 m
.14744 1 L
s
.27564 .99375 m
.27564 1 L
s
.40385 .99375 m
.40385 1 L
s
.53205 .99375 m
.53205 1 L
s
.66026 .99375 m
.66026 1 L
s
.78846 .99375 m
.78846 1 L
s
.91667 .99375 m
.91667 1 L
s
.125 Mabswid
.05128 .99625 m
.05128 1 L
s
.08333 .99625 m
.08333 1 L
s
.11538 .99625 m
.11538 1 L
s
.17949 .99625 m
.17949 1 L
s
.21154 .99625 m
.21154 1 L
s
.24359 .99625 m
.24359 1 L
s
.30769 .99625 m
.30769 1 L
s
.33974 .99625 m
.33974 1 L
s
.37179 .99625 m
.37179 1 L
s
.4359 .99625 m
.4359 1 L
s
.46795 .99625 m
.46795 1 L
s
.5 .99625 m
.5 1 L
s
.5641 .99625 m
.5641 1 L
s
.59615 .99625 m
.59615 1 L
s
.62821 .99625 m
.62821 1 L
s
.69231 .99625 m
.69231 1 L
s
.72436 .99625 m
.72436 1 L
s
.75641 .99625 m
.75641 1 L
s
.82051 .99625 m
.82051 1 L
s
.85256 .99625 m
.85256 1 L
s
.88462 .99625 m
.88462 1 L
s
.94872 .99625 m
.94872 1 L
s
.98077 .99625 m
.98077 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .21154 m
1 .21154 L
s
.99375 .40385 m
1 .40385 L
s
.99375 .59615 m
1 .59615 L
s
.99375 .78846 m
1 .78846 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05769 m
1 .05769 L
s
.99625 .09615 m
1 .09615 L
s
.99625 .13462 m
1 .13462 L
s
.99625 .17308 m
1 .17308 L
s
.99625 .25 m
1 .25 L
s
.99625 .28846 m
1 .28846 L
s
.99625 .32692 m
1 .32692 L
s
.99625 .36538 m
1 .36538 L
s
.99625 .44231 m
1 .44231 L
s
.99625 .48077 m
1 .48077 L
s
.99625 .51923 m
1 .51923 L
s
.99625 .55769 m
1 .55769 L
s
.99625 .63462 m
1 .63462 L
s
.99625 .67308 m
1 .67308 L
s
.99625 .71154 m
1 .71154 L
s
.99625 .75 m
1 .75 L
s
.99625 .82692 m
1 .82692 L
s
.99625 .86538 m
1 .86538 L
s
.99625 .90385 m
1 .90385 L
s
.99625 .94231 m
1 .94231 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.3 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 g
.01923 .81738 m
.04402 .82051 L
.05929 .82236 L
.09936 .82614 L
.13942 .82876 L
.17949 .83023 L
.21955 .83057 L
.25962 .82978 L
.29968 .82785 L
.33974 .82477 L
.37979 .82051 L
.37981 .82051 L
.41987 .81505 L
.45994 .80833 L
.5 .80027 L
.54006 .7908 L
.57794 .78045 L
.58013 .77981 L
.62019 .76719 L
.66026 .75272 L
.69059 .74038 L
.70032 .73617 L
.74038 .71724 L
.77192 .70032 L
.78045 .69542 L
.82051 .67005 L
.83433 .66026 L
.86058 .63999 L
.8831 .62019 L
.90064 .60308 L
.92107 .58013 L
.94071 .5544 L
.94989 .54006 L
.97061 .5 L
.98077 .47381 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .81738 m
.04402 .82051 L
.05929 .82236 L
.09936 .82614 L
.13942 .82876 L
.17949 .83023 L
.21955 .83057 L
.25962 .82978 L
.29968 .82785 L
.33974 .82477 L
.37979 .82051 L
.37981 .82051 L
.41987 .81505 L
.45994 .80833 L
.5 .80027 L
.54006 .7908 L
.57794 .78045 L
.58013 .77981 L
.62019 .76719 L
.66026 .75272 L
.69059 .74038 L
.70032 .73617 L
.74038 .71724 L
.77192 .70032 L
.78045 .69542 L
.82051 .67005 L
.83433 .66026 L
.86058 .63999 L
.8831 .62019 L
.90064 .60308 L
.92107 .58013 L
.94071 .5544 L
.94989 .54006 L
.97061 .5 L
.98077 .47381 L
s
.5 g
.01923 .8726 m
.05929 .877 L
.09936 .88035 L
.13942 .88266 L
.17949 .88397 L
.21955 .88427 L
.25962 .88357 L
.29968 .88186 L
.33974 .87913 L
.37981 .87537 L
.41987 .87054 L
.45994 .86462 L
.48372 .86058 L
.5 .85756 L
.54006 .84932 L
.58013 .83982 L
.62019 .82897 L
.64823 .82051 L
.66026 .81666 L
.70032 .80279 L
.74038 .78715 L
.75618 .78045 L
.78045 .76954 L
.82051 .74964 L
.83754 .74038 L
.86058 .72705 L
.90064 .7011 L
.90176 .70032 L
.94071 .67093 L
.95332 .66026 L
.98077 .63479 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .8726 m
.05929 .877 L
.09936 .88035 L
.13942 .88266 L
.17949 .88397 L
.21955 .88427 L
.25962 .88357 L
.29968 .88186 L
.33974 .87913 L
.37981 .87537 L
.41987 .87054 L
.45994 .86462 L
.48372 .86058 L
.5 .85756 L
.54006 .84932 L
.58013 .83982 L
.62019 .82897 L
.64823 .82051 L
.66026 .81666 L
.70032 .80279 L
.74038 .78715 L
.75618 .78045 L
.78045 .76954 L
.82051 .74964 L
.83754 .74038 L
.86058 .72705 L
.90064 .7011 L
.90176 .70032 L
.94071 .67093 L
.95332 .66026 L
.98077 .63479 L
s
.6 g
.01923 .92197 m
.05929 .92595 L
.09936 .92898 L
.13942 .93108 L
.17949 .93227 L
.21955 .93254 L
.25962 .93191 L
.29968 .93035 L
.33974 .92788 L
.37981 .92447 L
.41987 .9201 L
.45994 .91476 L
.5 .9084 L
.54006 .90099 L
.54185 .90064 L
.58013 .8925 L
.62019 .88285 L
.66026 .87197 L
.69779 .86058 L
.70032 .85977 L
.74038 .84616 L
.78045 .83098 L
.80575 .82051 L
.82051 .81407 L
.86058 .79522 L
.88905 .78045 L
.90064 .7741 L
.94071 .75031 L
.95602 .74038 L
.98077 .72328 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .92197 m
.05929 .92595 L
.09936 .92898 L
.13942 .93108 L
.17949 .93227 L
.21955 .93254 L
.25962 .93191 L
.29968 .93035 L
.33974 .92788 L
.37981 .92447 L
.41987 .9201 L
.45994 .91476 L
.5 .9084 L
.54006 .90099 L
.54185 .90064 L
.58013 .8925 L
.62019 .88285 L
.66026 .87197 L
.69779 .86058 L
.70032 .85977 L
.74038 .84616 L
.78045 .83098 L
.80575 .82051 L
.82051 .81407 L
.86058 .79522 L
.88905 .78045 L
.90064 .7741 L
.94071 .75031 L
.95602 .74038 L
.98077 .72328 L
s
.7 g
.01923 .967 m
.05929 .97067 L
.09936 .97346 L
.13942 .97541 L
.17949 .9765 L
.21955 .97676 L
.25962 .97617 L
.29968 .97473 L
.33974 .97245 L
.37981 .9693 L
.41987 .96529 L
.45994 .96038 L
.5 .95455 L
.54006 .94778 L
.57685 .94071 L
.58013 .94003 L
.62019 .93125 L
.66026 .92139 L
.70032 .91039 L
.73259 .90064 L
.74038 .89816 L
.78045 .88464 L
.82051 .86968 L
.84307 .86058 L
.86058 .85316 L
.90064 .83489 L
.9295 .82051 L
.94071 .81464 L
.98077 .79211 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .967 m
.05929 .97067 L
.09936 .97346 L
.13942 .97541 L
.17949 .9765 L
.21955 .97676 L
.25962 .97617 L
.29968 .97473 L
.33974 .97245 L
.37981 .9693 L
.41987 .96529 L
.45994 .96038 L
.5 .95455 L
.54006 .94778 L
.57685 .94071 L
.58013 .94003 L
.62019 .93125 L
.66026 .92139 L
.70032 .91039 L
.73259 .90064 L
.74038 .89816 L
.78045 .88464 L
.82051 .86968 L
.84307 .86058 L
.86058 .85316 L
.90064 .83489 L
.9295 .82051 L
.94071 .81464 L
.98077 .79211 L
s
.2 g
.01923 .75357 m
.05929 .75944 L
.09936 .76388 L
.13942 .76695 L
.17949 .76866 L
.21955 .76906 L
.25962 .76814 L
.29968 .76588 L
.33974 .76228 L
.37981 .75727 L
.41987 .7508 L
.45994 .74279 L
.47061 .74038 L
.5 .73314 L
.54006 .7217 L
.58013 .70822 L
.60096 .70032 L
.62019 .69247 L
.66026 .67404 L
.68639 .66026 L
.70032 .65232 L
.74038 .62633 L
.74876 .62019 L
.78045 .59446 L
.79553 .58013 L
.82051 .55283 L
.83023 .54006 L
.85482 .5 L
.86058 .49023 L
.87043 .45994 L
.8777 .41987 L
.8769 .37981 L
.86799 .33974 L
.86058 .31808 L
.85065 .29968 L
.82415 .25962 L
.82051 .255 L
.78722 .21955 L
.78045 .21329 L
.74038 .18138 L
.73769 .17949 L
.70032 .15536 L
.6715 .13942 L
.66026 .13367 L
.62019 .11521 L
.58013 .09949 L
.57976 .09936 L
.54006 .086 L
.5 .07454 L
.45994 .0649 L
.43276 .05929 L
.41987 .05691 L
.37981 .05047 L
.33974 .04547 L
.29968 .04187 L
.25962 .03962 L
.21955 .0387 L
.17949 .03909 L
.13942 .04081 L
.09936 .04387 L
.05929 .0483 L
.01923 .05415 L
F
0 g
.01923 .75357 m
.05929 .75944 L
.09936 .76388 L
.13942 .76695 L
.17949 .76866 L
.21955 .76906 L
.25962 .76814 L
.29968 .76588 L
.33974 .76228 L
.37981 .75727 L
.41987 .7508 L
.45994 .74279 L
.47061 .74038 L
.5 .73314 L
.54006 .7217 L
.58013 .70822 L
.60096 .70032 L
.62019 .69247 L
.66026 .67404 L
.68639 .66026 L
.70032 .65232 L
.74038 .62633 L
.74876 .62019 L
.78045 .59446 L
.79553 .58013 L
.82051 .55283 L
.83023 .54006 L
.85482 .5 L
.86058 .49023 L
.87043 .45994 L
.8777 .41987 L
.8769 .37981 L
.86799 .33974 L
.86058 .31808 L
.85065 .29968 L
.82415 .25962 L
.82051 .255 L
.78722 .21955 L
.78045 .21329 L
.74038 .18138 L
.73769 .17949 L
.70032 .15536 L
.6715 .13942 L
.66026 .13367 L
.62019 .11521 L
.58013 .09949 L
.57976 .09936 L
.54006 .086 L
.5 .07454 L
.45994 .0649 L
Mistroke
.43276 .05929 L
.41987 .05691 L
.37981 .05047 L
.33974 .04547 L
.29968 .04187 L
.25962 .03962 L
.21955 .0387 L
.17949 .03909 L
.13942 .04081 L
.09936 .04387 L
.05929 .0483 L
.01923 .05415 L
Mfstroke
.1 g
.01923 .67514 m
.05929 .68267 L
.09936 .68831 L
.13942 .69217 L
.17949 .69432 L
.21955 .69482 L
.25962 .69366 L
.29968 .69083 L
.33974 .68627 L
.37981 .67989 L
.41987 .67156 L
.45994 .66107 L
.46272 .66026 L
.5 .64826 L
.54006 .63258 L
.56684 .62019 L
.58013 .61348 L
.62019 .58987 L
.63423 .58013 L
.66026 .55988 L
.68101 .54006 L
.70032 .51851 L
.71297 .5 L
.73284 .45994 L
.74038 .43158 L
.742 .41987 L
.74099 .37981 L
.74038 .37611 L
.72976 .33974 L
.7076 .29968 L
.70032 .28946 L
.67296 .25962 L
.66026 .24789 L
.62267 .21955 L
.62019 .21789 L
.58013 .19418 L
.54986 .17949 L
.54006 .17515 L
.5 .15943 L
.45994 .14659 L
.43336 .13942 L
.41987 .13616 L
.37981 .12781 L
.33974 .12142 L
.29968 .11685 L
.25962 .11402 L
.21955 .11286 L
.17949 .11335 L
.13942 .11552 L
.09936 .11938 L
.05929 .12503 L
.01923 .13257 L
F
0 g
.01923 .67514 m
.05929 .68267 L
.09936 .68831 L
.13942 .69217 L
.17949 .69432 L
.21955 .69482 L
.25962 .69366 L
.29968 .69083 L
.33974 .68627 L
.37981 .67989 L
.41987 .67156 L
.45994 .66107 L
.46272 .66026 L
.5 .64826 L
.54006 .63258 L
.56684 .62019 L
.58013 .61348 L
.62019 .58987 L
.63423 .58013 L
.66026 .55988 L
.68101 .54006 L
.70032 .51851 L
.71297 .5 L
.73284 .45994 L
.74038 .43158 L
.742 .41987 L
.74099 .37981 L
.74038 .37611 L
.72976 .33974 L
.7076 .29968 L
.70032 .28946 L
.67296 .25962 L
.66026 .24789 L
.62267 .21955 L
.62019 .21789 L
.58013 .19418 L
.54986 .17949 L
.54006 .17515 L
.5 .15943 L
.45994 .14659 L
.43336 .13942 L
.41987 .13616 L
.37981 .12781 L
.33974 .12142 L
.29968 .11685 L
.25962 .11402 L
.21955 .11286 L
.17949 .11335 L
.13942 .11552 L
.09936 .11938 L
Mistroke
.05929 .12503 L
.01923 .13257 L
Mfstroke
.01923 .56178 m
.05929 .57428 L
.08358 .58013 L
.09936 .58327 L
.13942 .58939 L
.17949 .59276 L
.21955 .59353 L
.25962 .59173 L
.29968 .58729 L
.33915 .58013 L
.33974 .57999 L
.37981 .56977 L
.41987 .55553 L
.45243 .54006 L
.45994 .53618 L
.5 .50911 L
.50995 .5 L
.54006 .46447 L
.54225 .45994 L
.55652 .41987 L
.55497 .37981 L
.54006 .34403 L
.53737 .33974 L
.50083 .29968 L
.5 .29897 L
.45994 .2713 L
.43637 .25962 L
.41987 .25228 L
.37981 .23791 L
.33974 .22756 L
.29968 .22045 L
.29575 .21955 L
.25962 .21603 L
.21955 .21423 L
.17949 .215 L
.13942 .21837 L
.1291 .21955 L
.09936 .22436 L
.05929 .23334 L
.01923 .24598 L
F
.01923 .56178 m
.05929 .57428 L
.08358 .58013 L
.09936 .58327 L
.13942 .58939 L
.17949 .59276 L
.21955 .59353 L
.25962 .59173 L
.29968 .58729 L
.33915 .58013 L
.33974 .57999 L
.37981 .56977 L
.41987 .55553 L
.45243 .54006 L
.45994 .53618 L
.5 .50911 L
.50995 .5 L
.54006 .46447 L
.54225 .45994 L
.55652 .41987 L
.55497 .37981 L
.54006 .34403 L
.53737 .33974 L
.50083 .29968 L
.5 .29897 L
.45994 .2713 L
.43637 .25962 L
.41987 .25228 L
.37981 .23791 L
.33974 .22756 L
.29968 .22045 L
.29575 .21955 L
.25962 .21603 L
.21955 .21423 L
.17949 .215 L
.13942 .21837 L
.1291 .21955 L
.09936 .22436 L
.05929 .23334 L
.01923 .24598 L
s
.4 g
.98077 .33556 m
.96708 .29968 L
.9448 .25962 L
.94071 .25342 L
.91425 .21955 L
.90064 .20463 L
.87428 .17949 L
.86058 .16773 L
.82305 .13942 L
.82051 .13767 L
.78045 .11225 L
.75741 .09936 L
.74038 .09046 L
.70032 .07151 L
.67121 .05929 L
.66026 .055 L
.62019 .04057 L
.58013 .02793 L
.54907 .01923 L
.98077 .01923 L
F
0 g
.98077 .33556 m
.96708 .29968 L
.9448 .25962 L
.94071 .25342 L
.91425 .21955 L
.90064 .20463 L
.87428 .17949 L
.86058 .16773 L
.82305 .13942 L
.82051 .13767 L
.78045 .11225 L
.75741 .09936 L
.74038 .09046 L
.70032 .07151 L
.67121 .05929 L
.66026 .055 L
.62019 .04057 L
.58013 .02793 L
.54907 .01923 L
s
.8 g
.98077 .85045 m
.96068 .86058 L
.94071 .87018 L
.90064 .88811 L
.87023 .90064 L
.86058 .90444 L
.82051 .91933 L
.78045 .93288 L
.75545 .94071 L
.74038 .9452 L
.70032 .95637 L
.66026 .96647 L
.62019 .97556 L
.59507 .98077 L
.98077 .98077 L
F
0 g
.98077 .85045 m
.96068 .86058 L
.94071 .87018 L
.90064 .88811 L
.87023 .90064 L
.86058 .90444 L
.82051 .91933 L
.78045 .93288 L
.75545 .94071 L
.74038 .9452 L
.70032 .95637 L
.66026 .96647 L
.62019 .97556 L
.59507 .98077 L
s
.5 g
.98077 .17294 m
.94389 .13942 L
.94071 .13679 L
.90064 .10657 L
.89004 .09936 L
.86058 .08064 L
.82283 .05929 L
.82051 .05807 L
.78045 .03822 L
.74038 .02056 L
.73718 .01923 L
.98077 .01923 L
F
0 g
.98077 .17294 m
.94389 .13942 L
.94071 .13679 L
.90064 .10657 L
.89004 .09936 L
.86058 .08064 L
.82283 .05929 L
.82051 .05807 L
.78045 .03822 L
.74038 .02056 L
.73718 .01923 L
s
.9 g
.98077 .90201 m
.94071 .91978 L
.90064 .93604 L
.88846 .94071 L
.86058 .95093 L
.82051 .96457 L
.78045 .97706 L
.76785 .98077 L
.98077 .98077 L
F
0 g
.98077 .90201 m
.94071 .91978 L
.90064 .93604 L
.88846 .94071 L
.86058 .95093 L
.82051 .96457 L
.78045 .97706 L
.76785 .98077 L
s
.6 g
.98077 .08441 m
.9437 .05929 L
.94071 .0574 L
.90064 .03366 L
.87388 .01923 L
.98077 .01923 L
F
0 g
.98077 .08441 m
.9437 .05929 L
.94071 .0574 L
.90064 .03366 L
.87388 .01923 L
s
1 g
.98077 .94871 m
.94071 .96499 L
.90064 .97999 L
.89846 .98077 L
.98077 .98077 L
F
0 g
.98077 .94871 m
.94071 .96499 L
.90064 .97999 L
.89846 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`003oooool2o`0001oooooo1Ol0000Pooooo`?o00007oooool3o`00023ooooo0ol0000Noooo
o`?o00001?ooool2o`0001[ooooo0ol00002ooooo`Go00006Oooool3o`0000Cooooo0ol0000Eoooo
o`003_ooool01?l0003oooooooooool0000Oooooo`04o`000?ooooooooooo`00027ooooo00?o0000
ooooooooool07Oooool01Ol0003ooooooooooooooooo000001kooooo00Go0000oooooooooooooooo
o`00000Nooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00006_ooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0001[ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`0Dooooo`003_ooool01?l0003oooooooooool0000Pooooo`03o`000?oooooooooo
01kooooo1Ol0000Nooooo`05o`000?ooooooooooooooool000007_ooool01Ol0003ooooooooooooo
oooo000001kooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0000Jooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool06_ooool01?l0003oooooooooooooool5o`0001Go
oooo000>ooooo`04o`000?ooooooooooo`00027ooooo00?o0000ooooooooool07Oooool01?l0003o
ooooooooool0000Oooooo`Co00008?ooool3o`0001oooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool0000Jooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool06Oooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool05?ooool000kooooo00Co0000
oooooooooooo00007_ooool01Ol0003ooooooooooooooooo000001oooooo00?o0000ooooool00000
7oooool00ol0003oooooooooo`0Pooooo`05o`000?ooooooooooooooool000007_ooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0001[ooooo00Go0000ooooooooooooooooo`000003
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool00_ooool00ol0003oooooo`00000F
ooooo`003_ooool01?l0003oooooooooool0000Nooooo`05o`000?ooooooooooooooool000008?oo
ool2o`00023ooooo00?o0000ooooooooool07oooool01Ol0003ooooooooooooooooo000001gooooo
0_l00004ooooo`04o`000?ooooooooooo`0001Wooooo0_l00003ooooo`05o`000?oooooooooooooo
ool000006Oooool2o`0000Gooooo0_l0000Fooooo`003oooool2o`00023ooooo0ol0000Rooooo`03
o`000?oooooooooo01oooooo0_l0000Pooooo`?o00007oooool00ol0003oooooooooo`03ooooo`;o
00006oooool00ol0003oooooooooo`02ooooo`?o00006oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01Cooooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo003ooooo
ob7ooooo003oooooob7ooooo000:oooooooo00005Ol00002ooooo`002_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00;ooooo0Ol00001ooooo`7ooooo000:ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooo
oooo023ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooo
oooo023ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Dooooo`7o00000Oooool1
ooooo`000oooool2o`0000Gooooo00?o0000ooooooooool0oooooolAooooo`7o00000Oooool1oooo
o`000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo0?oooooo4Oooool1o`00
007ooooo0Oooool000;ooooo00Co0000oooooooooooo00001?ooool3o`0009Cooooo0ol0000aoooo
o`03o`000?oooooooooo02;ooooo0_l0000Oooooo`?o00000_ooool000;ooooo00Co0000oooooooo
oooo00001?ooool00ol0003oooooooooo`03oooooiCoC4a<0ol0000_ofIVIP;o00009?moOgl2o`00
01[oVIVI1Oooool1o`00007ooooo0Oooool000;ooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`03oooooiOoC4a<0ol0000^ofIVIP?o00008omoOgl2o`0001SoVIVI1Oooool1o`00
007ooooo0Oooool000;ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`03oooo
oi[oC4a<0ol0000^ofIVIP?o00008_moOgl2o`0001KoVIVI1Oooool1o`00007ooooo0Oooool000?o
oooo0_l00005ooooo`03o`000?oooooooooo00?oooooWOm<C4`4o`0002goIVIV0ol0000QogmoO`;o
00005?nIVIT5ooooo`7o00000Oooool1ooooo`002_ooool00ol0003oooooooooo`03oooooj7oC4a<
0ol0000]ofIVIP;o00008OmoOgl00ol0003oVIVIoiVIV@0AoiVIV@Gooooo0Ol00001ooooo`7ooooo
000:ooooo`03o`000?oooooooooo00?ooooo7?m<C4`ho`00053oC4a<0ol0000/ofIVIP;o00008?mo
Ogl2o`00017oVIVI1Oooool1o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00ooooolA
oda<C0_o0000>?lc<c<8o`0004_oC4a<0ol0000[ofIVIP;o00008?moOgl2o`0000ooVIVI1Oooool1
o`00007ooooo0Oooool000[ooooo00?o0000ooooooooool00oooool8oda<C0Wo0000Bolc<c<5o`00
04WoC4a<0ol0000ZofIVIP03o`000?moOgooOgmo01ooOgmo00?o0000oiVIVOnIVIT03?nIVIT5oooo
