/*
 * NASPRO - The NASPRO Architecture for Sound PROcessing
 * Portable runtime library
 *
 * Copyright (C) 2007-2014 Stefano D'Angelo
 *
 * See the COPYING file for license conditions.
 */

#define _POSIX_C_SOURCE	200809L

#include "internal.h"

typedef struct
  {
	void (*start_routine)(void *arg);
	void *arg;
  } thread_data_t;

static void *
thread_start(void *arg)
{
	thread_data_t *data;
	void (*sr)(void *arg);

	data = (thread_data_t *)arg;
	sr = data->start_routine;
	arg = data->arg;

	free(data);

	sr(arg);

	return NULL;
}

_NACORE_DEF int
nacore_thread_create(nacore_thread *thread, size_t stack_size,
		     void (*start_routine)(void *arg), void *arg)
{
	thread_data_t *data;
	pthread_attr_t attr;
	pthread_attr_t *attrp;
	int ret;

	data = malloc(sizeof(thread_data_t));
	if (data == NULL)
		return ENOMEM;

	data->start_routine = start_routine;
	data->arg = arg;

	attrp = NULL;
	if (stack_size != 0)
	  {
		attrp = &attr;
		if (pthread_attr_init(attrp) != 0)
		  {
			free(data);
			return ENOMEM;
		  }

		if (pthread_attr_setstacksize(attrp, stack_size) != 0)
		  {
			free(data);
			pthread_attr_destroy(attrp);
			return EINVAL;
		  }
	  }

	ret = pthread_create(thread, attrp, thread_start, data);

	if (stack_size != 0)
		pthread_attr_destroy(attrp);

	if (ret != 0)
		free(data);

	return ret;
}

_NACORE_DEF void
nacore_thread_exit()
{
	pthread_exit(NULL);
}

_NACORE_DEF nacore_thread
nacore_thread_self()
{
	return pthread_self();
}

_NACORE_DEF char
nacore_thread_equal(nacore_thread t1, nacore_thread t2)
{
	return pthread_equal(t1, t2);
}

_NACORE_DEF int
nacore_thread_join(nacore_thread thread)
{
	return pthread_join(thread, NULL);
}
