/* $Id: Packed_seqpnt.cpp 433711 2014-04-29 13:46:53Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

// generated includes
#include <ncbi_pch.hpp>
#include <objects/seqloc/Packed_seqpnt.hpp>
//#include <objects/seqloc/Seq_id.hpp>
#include <objects/general/Int_fuzz.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPacked_seqpnt::~CPacked_seqpnt(void)
{
}


bool CPacked_seqpnt::x_IsMinusStrand(void) const
{
    ENa_strand strand = eNa_strand_unknown;
    if ( IsSetStrand() ) {
        strand = GetStrand();
    }
    return (strand == eNa_strand_minus)  ||  (strand == eNa_strand_both_rev);
}


bool CPacked_seqpnt::IsPartialStart(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
        CInt_fuzz::eLim_gt : CInt_fuzz::eLim_lt;

    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}

bool CPacked_seqpnt::IsPartialStop(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
        CInt_fuzz::eLim_lt : CInt_fuzz::eLim_gt;

    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}


// set / remove e_Lim fuzz on start or stop end
void CPacked_seqpnt::SetPartialStart(bool val, ESeqLocExtremes ext)
{
    if (val == IsPartialStart(ext)) {
        return;
    }

    if (val) {
        CInt_fuzz::TLim lim = 
            (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
                CInt_fuzz::eLim_gt : CInt_fuzz::eLim_lt;

        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


void CPacked_seqpnt::SetPartialStop(bool val, ESeqLocExtremes ext)
{
    if (val == IsPartialStop(ext)) {
        return;
    }

    if (val) {
        CInt_fuzz::TLim lim = 
            (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
                CInt_fuzz::eLim_lt : CInt_fuzz::eLim_gt;

        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


bool CPacked_seqpnt::IsTruncatedStart(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
        CInt_fuzz::eLim_tr : CInt_fuzz::eLim_tl;

    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}

bool CPacked_seqpnt::IsTruncatedStop(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
        CInt_fuzz::eLim_tl : CInt_fuzz::eLim_tr;

    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}


void CPacked_seqpnt::SetTruncatedStart(bool val, ESeqLocExtremes ext)
{
    if (val == IsTruncatedStart(ext)) {
        return;
    }

    if (val) {
        CInt_fuzz::TLim lim = 
            (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
                CInt_fuzz::eLim_tr : CInt_fuzz::eLim_tl;

        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


void CPacked_seqpnt::SetTruncatedStop(bool val, ESeqLocExtremes ext)
{
    if (val == IsTruncatedStop(ext)) {
        return;
    }

    if (val) {
        CInt_fuzz::TLim lim = 
            (ext == eExtreme_Biological  &&  x_IsMinusStrand()) ?
                CInt_fuzz::eLim_tl : CInt_fuzz::eLim_tr;

        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


TSeqPos CPacked_seqpnt::GetStart(ESeqLocExtremes ext) const
{
    if (!GetPoints().empty()) {
        return (ext == eExtreme_Positional  &&  x_IsMinusStrand()) ?
            GetPoints().back() : GetPoints().front();
    }
    return kInvalidSeqPos;
}


TSeqPos CPacked_seqpnt::GetStop(ESeqLocExtremes ext) const
{
    if (!GetPoints().empty()) {
        return (ext == eExtreme_Positional  &&  x_IsMinusStrand()) ?
            GetPoints().front() : GetPoints().back();
    }
    return kInvalidSeqPos;
}


void CPacked_seqpnt::FlipStrand(void)
{
    if (IsSetStrand()) {
        SetStrand(Reverse(GetStrand()));
    } else {
        SetStrand(eNa_strand_minus);
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1898, CRC32: 2e3ddf82 */
