# mongodb

Module monitor mongodb performance and health metrics

**Requirements:**

-   `python-pymongo` package v2.4+.

You need to install it manually.

Number of charts depends on mongodb version, storage engine and other features (replication):

1.  **Read requests**:

    -   query
    -   getmore (operation the cursor executes to get additional data from query)

2.  **Write requests**:

    -   insert
    -   delete
    -   update

3.  **Active clients**:

    -   readers (number of clients with read operations in progress or queued)
    -   writers (number of clients with write operations in progress or queued)

4.  **Journal transactions**:

    -   commits (count of transactions that have been written to the journal)

5.  **Data written to the journal**:

    -   volume (volume of data)

6.  **Background flush** (MMAPv1):

    -   average ms (average time taken by flushes to execute)
    -   last ms (time taken by the last flush)

7.  **Read tickets** (WiredTiger):

    -   in use (number of read tickets in use)
    -   available (number of available read tickets remaining)

8.  **Write tickets** (WiredTiger):

    -   in use (number of write tickets in use)
    -   available (number of available write tickets remaining)

9.  **Cursors**:

-   opened (number of cursors currently opened by MongoDB for clients)
-   timedOut (number of cursors that have timed)
-   noTimeout (number of open cursors with timeout disabled)

10. **Connections**:

    -   connected (number of clients currently connected to the database server)
    -   unused (number of unused connections available for new clients)

11. **Memory usage metrics**:

    -   virtual
    -   resident (amount of memory used by the database process)
    -   mapped
    -   non mapped

12. **Page faults**:

    -   page faults (number of times MongoDB had to request from disk)

13. **Cache metrics** (WiredTiger):

    -   percentage of bytes currently in the cache (amount of space taken by cached data)
    -   percantage of tracked dirty bytes in the cache (amount of space taken by dirty data)

14. **Pages evicted from cache** (WiredTiger):

    -   modified
    -   unmodified

15. **Queued requests**:

    -   readers (number of read request currently queued)
    -   writers (number of write request currently queued)

16. **Errors**:

    -   msg (number of message assertions raised)
    -   warning (number of warning assertions raised)
    -   regular (number of regular assertions raised)
    -   user (number of assertions corresponding to errors generated by users)

17. **Storage metrics** (one chart for every database)

    -   dataSize (size of all documents + padding in the database)
    -   indexSize (size of all indexes in the database)
    -   storageSize (size of all extents in the database)

18. **Documents in the database** (one chart for all databases)

-   documents (number of objects in the database among all the collections)

19. **tcmalloc metrics**

    -   central cache free
    -   current total thread cache
    -   pageheap free
    -   pageheap unmapped
    -   thread cache free
    -   transfer cache free
    -   heap size

20. **Commands total/failed rate**

    -   count
    -   createIndex
    -   delete
    -   eval
    -   findAndModify
    -   insert

21. **Locks metrics** (acquireCount metrics - number of times the lock was acquired in the specified mode)

    -   Global lock
    -   Database lock
    -   Collection lock
    -   Metadata lock
    -   oplog lock

22. **Replica set members state**

    -   state

23. **Oplog window**

    -   window (interval of time between the oldest and the latest entries in the oplog)

24. **Replication lag**

    -   member (time when last entry from the oplog was applied for every member)

25. **Replication set member heartbeat latency**

    -   member (time when last heartbeat was received from replica set member)

## prerequisite

Create a read-only user for Netdata in the admin database.

1.  Authenticate as the admin user.

```
use admin
db.auth("admin", "<MONGODB_ADMIN_PASSWORD>")
```

2.  Create a user.

```
# MongoDB 2.x.
db.addUser("netdata", "<UNIQUE_PASSWORD>", true)

# MongoDB 3.x or higher.
db.createUser({
  "user":"netdata",
  "pwd": "<UNIQUE_PASSWORD>",
  "roles" : [
    {role: 'read', db: 'admin' },
    {role: 'clusterMonitor', db: 'admin'},
    {role: 'read', db: 'local' }
  ]
})
```

### configuration

Sample:

```yaml
local:
    name : 'local'
    authdb: 'admin'
    host : '127.0.0.1'
    port : 27017
    user : 'netdata'
    pass : 'netdata'
```

If no configuration is given, module will attempt to connect to mongodb daemon on `127.0.0.1:27017` address

---

[![analytics](https://www.google-analytics.com/collect?v=1&aip=1&t=pageview&_s=1&ds=github&dr=https%3A%2F%2Fgithub.com%2Fnetdata%2Fnetdata&dl=https%3A%2F%2Fmy-netdata.io%2Fgithub%2Fcollectors%2Fpython.d.plugin%2Fmongodb%2FREADME&_u=MAC~&cid=5792dfd7-8dc4-476b-af31-da2fdb9f93d2&tid=UA-64295674-3)](<>)
