/* pdu-mpls.c
 
   Builder for MPLS PDUs

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "pbuild-priv.h"
#include "pdu-mpls.h"

static void
build(const GNode *pdu, void *dest)
{
    uint32_t mpls_lse; /* MPLS label switch entry */

    mpls_lse  = (num_next(_pb_pdata(pdu, "label") ) << LABEL_SHIFT)
		& LSE_LABEL;
    mpls_lse |= (num_next(_pb_pdata(pdu, "experimental") )<< EXP_SHIFT)
		& LSE_EXP;
    mpls_lse |= ( (int) _pb_pdata(pdu, "s") << S_SHIFT) & LSE_S;
    mpls_lse |= num_next(_pb_pdata(pdu, "ttl") ) & LSE_TTL;
    mpls_lse = htonl(mpls_lse);

    SIVAL(dest, 0, mpls_lse);
}

#if 0
static void
pdu_mplshdr_dumper(pdu_t *p, const char *prefix)
{
    struct mplshdr_options *hdr_data;

    hdr_data = p->header_data;

    printf("%s  Parameters:\n", prefix);
    printf("%s    Label: %d\n", prefix, hdr_data->label);
    printf("%s    Experimental Bits: %d\n", prefix, hdr_data->experimental_bits);
    printf("%s    S bit: %d\n", prefix, hdr_data->s);
    printf("%s    Time to Live: %d\n", prefix, hdr_data->ttl);
}
#endif

static pdu_t pdu_mpls = {
    .name = "mpls",
    .description = "MPLS Label",
    .documented_in = "RFC 3032",
    .len = sizeof(uint32_t),
    .fields = (field_t []) {
	{.name = "label", .type = PDU_FTYPE_NUMTYPE},
	{.name = "experimental", .type = PDU_FTYPE_NUMTYPE},
	{.name = "ttl", .type = PDU_FTYPE_NUMTYPE},
	{.name = "s", .type = PDU_FTYPE_BIT},
	{.name = NULL}
    },
    .build = &build
};

void
_pb_register_mpls(void)
{
    _pb_register_protocol(&pdu_mpls);
}
