/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class NamePart
extends SystemFunction {
    public static final int NAME = 0;
    public static final int LOCAL_NAME = 1;
    public static final int NAMESPACE_URI = 2;
    public static final int GENERATE_ID = 3;
    public static final int DOCUMENT_URI = 4;
    public static final int NODE_NAME = 6;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault();
        return this.simplifyArguments(visitor);
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.operation == 3) {
            return p & 0xFFBFFFFF;
        }
        return p;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        String s2;
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(c);
        if (node == null) {
            if (this.operation == 6 || this.operation == 4) {
                return null;
            }
            if (this.operation == 2) {
                return AnyURIValue.EMPTY_URI;
            }
            return StringValue.EMPTY_STRING;
        }
        switch (this.operation) {
            case 0: {
                s2 = node.getDisplayName();
                break;
            }
            case 1: {
                s2 = node.getLocalPart();
                break;
            }
            case 2: {
                String uri = node.getURI();
                String s2 = uri == null ? "" : uri;
                return new AnyURIValue(s2);
            }
            case 3: {
                FastStringBuffer buffer = new FastStringBuffer(16);
                node.generateId(buffer);
                buffer.condense();
                return new StringValue(buffer);
            }
            case 4: {
                if (node.getNodeKind() == 9) {
                    DocumentPool pool = c.getController().getDocumentPool();
                    String docURI = pool.getDocumentURI(node);
                    if (docURI == null) {
                        docURI = node.getSystemId();
                    }
                    if (docURI == null) {
                        return null;
                    }
                    if ("".equals(docURI)) {
                        return null;
                    }
                    return new AnyURIValue(docURI);
                }
                return null;
            }
            case 6: {
                int nc = node.getNameCode();
                if (nc == -1) {
                    return null;
                }
                return new QNameValue(node.getNamePool(), nc);
            }
            default: {
                throw new UnsupportedOperationException("Unknown name operation");
            }
        }
        return new StringValue(s2);
    }

    public static boolean isGenerateIdFunction(Expression exp) {
        return exp instanceof NamePart && ((NamePart)exp).operation == 3;
    }
}

