/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceWrapper
extends Instruction {
    Expression child;

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.child = visitor.simplify(this.child);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.child = visitor.typeCheck(this.child, contextItemType);
        this.adoptChildExpression(this.child);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.child = visitor.optimize(this.child, contextItemType);
        this.adoptChildExpression(this.child);
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression newChild = this.child.promote(offer, parent);
        if (newChild != this.child) {
            this.child = newChild;
            this.adoptChildExpression(this.child);
            return this;
        }
        return this;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        TraceListener listener = controller.getTraceListener();
        if (controller.isTracing()) {
            listener.enter(this.getInstructionInfo(), context);
        }
        this.child.process(context);
        if (controller.isTracing()) {
            listener.leave(this.getInstructionInfo());
        }
        return null;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.child.getItemType(th);
    }

    @Override
    public int getCardinality() {
        return this.child.getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.child.getDependencies();
    }

    @Override
    public final boolean createsNewNodes() {
        return (this.child.getSpecialProperties() & 0x400000) == 0;
    }

    @Override
    public int computeDependencies() {
        return this.child.computeDependencies();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        Item result = this.child.evaluateItem(context);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return result;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        SequenceIterator result = this.child.iterate(context);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return result;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.child);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.child == original) {
            this.child = replacement;
            found = true;
        }
        return found;
    }

    public InstructionInfo getInstructionInfo() {
        return this.child;
    }

    @Override
    public int getInstructionNameCode() {
        if (this.child instanceof Instruction) {
            return ((Instruction)this.child).getInstructionNameCode();
        }
        return -1;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        this.child.explain(out);
    }
}

