/***************************************************************************
 *   Copyright (C) 2005-2007 by Eugene V. Lyubimkin aka jackyf             *
 *   jackyf@yfnote-debian                                                  *
 *                                                                         *
 *   This file is a part of yf-library                                     *
 *                                                                         *																*
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License for Libraries    *
 *   as published by the Free Software Foundation                          *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for Libraries for more details.            *
 *                                                                         *
 *   You should have received a copy of the GNU LGPL                       *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <yf/exception/exception.hpp>

#include <cstring>
#include <cstdio>
//---------------------------------------------------------------------------
namespace yf
{
	exception::exception(const char* who,
								error_types::error error_type,
								const char* message,
								const char* file,
								uint32 line
							)
		: __err_type( error_type )
	{
		try
		{
			#ifdef YF_INNER_DEBUG
				std::snprintf( __message, sizeof(__message), "at file %s, at line %u - %s: %s",
				file, (unsigned int)line, who, message );
			#else
				std::snprintf( __message, sizeof(__message), "%s: %s", who, message );
			#endif
		}
		catch(...)
		{
			//return "exception: unexpected error while forming the exception message!";
			throw thrown_messages::_general_fault;
		}
	}
	//------------------------------------------------------------------------------
	exception::exception( const exception& other )
	{
		std::strncpy( __message, other.__message, sizeof(__message) );
		__err_type = other.errtype();
	}
	//------------------------------------------------------------------------------
	exception::exception( const std::exception& other )
	{
		std::strncpy( __message, other.what(), sizeof(__message) );
		__err_type = error_types::undefined;
	}
	//------------------------------------------------------------------------------
	exception::~exception() throw()
	{}
	//------------------------------------------------------------------------------
	error_types::error exception::errtype() const throw()
	{
		return __err_type;
	}
	//------------------------------------------------------------------------------
	const char* exception::what() const throw()
	{
		return __message;
	}
	//------------------------------------------------------------------------------
}
