.\"
.\" %nmhwarning%
.\"
.TH ALI %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
ali \- list mail aliases
.SH SYNOPSIS
.HP 5
.na
.B ali
.RB [ \-alias
.IR aliasfile ]
.RB [ \-list " | " \-nolist ]
.RB [ \-normalize " | " \-nonormalize ]
.RB [ \-user " | " \-nouser ]
.RB [ \-version ]
.RB [ \-help ] 
.RI [ aliases " ...]"
.ad
.SH DESCRIPTION
.B Ali
searches the named mail alias files for each of the given
.IR aliases .
It creates a list of addresses for those
.IR aliases ,
and writes that list on standard output.  If no arguments are given,
.B ali
outputs all alias entries.
.PP
By default, when an aliases expands to multiple addresses, the addresses
are separated by commas and printed on as few lines as possible.  If the
.B \-list
option is specified, then when an address expands to multiple
addresses, each address will appear on a separate line.
.PP
The switch
.B \-user
directs
.B ali
to perform its processing in
an inverted fashion: instead of listing the addresses that each given
alias expands to,
.B ali
will list the aliases that expand to each
given address.  If the
.B \-normalize
switch is given,
.B ali
will
try to track down the official hostname of the address.
.PP
The files specified by the profile entry
.RI \*(lq Aliasfile \*(rq
and any additional alias files given by the
.B \-alias
.I aliasfile
switch will be read.  Each
.I alias
is processed as described in
.BR mh\-alias (5).

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^/etc/passwd~^List of users
^/etc/group~^List of groups
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Aliasfile:~^For a default alias file
.fi

.SH "SEE ALSO"
mh\-alias(5)

.SH DEFAULTS
.nf
.RB ` aliasfiles "' defaults to %etcdir%/MailAliases"
.RB ` \-nolist '
.RB ` \-nonormalize '
.RB ` \-nouser '
.fi

.SH CONTEXT
None

.SH BUGS
The
.B \-user
option with
.B \-nonormalize
is not entirely accurate, as it
does not replace local nicknames for hosts with their official site names.
