/***************************************************************************
 *   Copyright (C) 2011 by Tomasz Bojczuk  				   *
 *   tomaszbojczuk@gmail.com   						   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License	   *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/


#include "tclefview.h"
#include <QGraphicsScene>
#include <QGraphicsSimpleTextItem>
#include <QDebug>

TclefView::TclefView(TscoreWidgetSimple *parent) :
    QGraphicsView(parent)
{
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setFrameShape(QFrame::NoFrame);
    setStyleSheet(("background: transparent"));
    setRenderHint(QPainter::TextAntialiasing, true);

    m_scene = new QGraphicsScene(this);
    setScene(m_scene);

    m_clefText = new QGraphicsSimpleTextItem();
    m_clefText->setBrush(QBrush(palette().text().color()));
    m_scene->addItem(m_clefText);
    m_clefText->setText(QString(QChar(0xe1a7)));

    show();
}

void TclefView::resize(int co) {
    m_scene->setSceneRect(0, 0, width(), height());
    QFont font(QFont("nootka"));
#if defined (Q_OS_MAC)
    font.setPointSize(co * 19);
#else
    font.setPointSize(co * 14);
    QFontMetricsF fMetrics(font);
    qreal fact = (qreal)(width() - 3) / fMetrics.boundingRect(QChar(0xe1a7)).width();
//     if (fact < 1 || fact > 1.1)
      font.setPointSize(qRound(font.pointSize() * fact));
#endif
    m_clefText->setFont(font);
#if defined(Q_OS_UNIX)
    m_clefText->setPos(0, 20 * co - (0.52 * m_clefText->boundingRect().height()));
#else
    m_clefText->setPos(0, 20 * co - (0.52 * m_clefText->boundingRect().height()));
#endif
}
