# Documentation

Ntopng documentation uses read the docs and `.rst` file format.

## Requirements

On ubuntu:

```
apt-get install doxygen
pip install breathe sphinx==1.7.9
````

*Note*: newer sphinx versions (e.g. 1.8.0) have a bug with search: https://github.com/sphinx-doc/sphinx/issues/5460

## Generate

The ntopng documentation can be generated by executing `make release`.

It can be easily tested locally by running a python webserver:

```
  pushd _build/html; python -m SimpleHTTPServer 8080; popd
```

## Lua C API

The Lua C API documentation can be found inside the `api/lua_c` directory.

The functions documentation is written in `.lua` file (e.g. `api/lua_c/ntop/ntop_users.lua`).
These are the files to modify to update the api documentation.

Functions are organized in a directory structure in the form `api/lua_c/{object}/{api_group}.lua`,
where `{object}` is a C API reg (eg. `interface`) and `{api_group}` is a group of api functions
relevant to the same topic (e.g. `interface_hosts` is for api functions that work with hosts).

Only a subset of the functions defined in `src/LuaEngine.cpp` are documented as API.
They are marked with the `// ***API***` comment. Whenever an API function is modified,
the corresponding documentation file should be updated.

Here is how to perform some recurrent operations on the documentation:

  - Add/modify a function documentation: e.g. to update the `ntop.setCache` documentation,
    the file `api/lua_c/ntop/ntop_cache.lua` should be modified.

  - Add a new group of api functions for an existing C API reg: e.g. to group together all the
    host pools functions, the following modifications should be performed:
      - create `api/lua_c/interface/interface_host_pools.lua`.
      - create `api/lua_c/interface/interface_host_pools.rst`. Adapt this from an existing `.rst`.
      - edit `api/lua_c/interface/index.rst` and add `interface_host_pools` to the `toctree` section.

  - Add a new C API reg: e.g. to add a new `db` reg so that we can call `db.some_function` functions,
    it's necessary to:
      - create `api/lua_c/db/index.rst`. Adapt this from an existing `.rst`.
      - edit `api/lua_c/index.rst` and add `db/index` to the `toctree` section.
      - edit `doxygen/Doxyfile` and add `../api/lua_c/db` to the `INPUT` variable.
