/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.peer;

import com.workingdogs.village.Column;
import com.workingdogs.village.DataSet;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import com.workingdogs.village.TableDataSet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.SimpleKey;
import org.apache.turbine.om.StringKey;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.services.logging.TurbineLogging;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.StringStackBuffer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.IdGenerator;
import org.apache.turbine.util.db.Query;
import org.apache.turbine.util.db.SqlExpression;
import org.apache.turbine.util.db.adapter.DB;
import org.apache.turbine.util.db.map.ColumnMap;
import org.apache.turbine.util.db.map.DatabaseMap;
import org.apache.turbine.util.db.map.MapBuilder;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.pool.DBConnection;

public abstract class BasePeer {
    public static final String ORDER_BY = "ORDER BY";
    public static final String IGNORE_CASE = "IgNOrE cAsE";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String DEFAULT_MAP_BUILDER = "org.apache.turbine.util.db.map.TurbineMapBuilder";
    private static Hashtable mapBuilders = new Hashtable(5);

    public static byte[] hashtableToByteArray(Hashtable hash) throws Exception {
        Hashtable<String, Object> saveData = new Hashtable<String, Object>(hash.size());
        String key = null;
        Object value = null;
        byte[] byteArray = null;
        Enumeration keys = hash.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            value = hash.get(key);
            if (!(value instanceof Serializable)) continue;
            saveData.put(key, value);
        }
        ByteArrayOutputStream baos = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(baos);
            out = new ObjectOutputStream(bos);
            out.writeObject(saveData);
            out.flush();
            bos.flush();
            byteArray = baos.toByteArray();
        }
        finally {
            Object var10_9 = null;
            if (out != null) {
                out.close();
            }
            if (bos != null) {
                bos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return byteArray;
    }

    public static Schema initTableSchema(String tableName) {
        return BasePeer.initTableSchema(tableName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Schema initTableSchema(String tableName, String dbName) {
        Schema schema = null;
        DBConnection db = null;
        try {
            try {
                db = dbName == null ? TurbineDB.getConnection() : TurbineDB.getConnection(dbName);
                Connection connection = db.getConnection();
                schema = new Schema().schema(connection, tableName);
            }
            catch (Exception e) {
                Log.error(e);
                throw new Error("Error in BasePeer.initTableSchema(" + tableName + "): " + e.getMessage());
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                TurbineDB.releaseConnection(db);
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        TurbineDB.releaseConnection(db);
        return schema;
    }

    public static Column[] initTableColumns(Schema schema) {
        Column[] columns = null;
        try {
            int numberOfColumns = schema.numberOfColumns();
            columns = new Column[numberOfColumns];
            int i = 0;
            while (i < numberOfColumns) {
                columns[i] = schema.column(i + 1);
                ++i;
            }
        }
        catch (Exception e) {
            Log.error(e);
            throw new Error("Error in BasePeer.initTableColumns(): " + e.getMessage());
        }
        return columns;
    }

    public static String[] initColumnNames(Column[] columns) {
        String[] columnNames = null;
        columnNames = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            columnNames[i] = columns[i].name().toUpperCase();
            ++i;
        }
        return columnNames;
    }

    public static String[] initCriteriaKeys(String tableName, String[] columnNames) {
        String[] keys = new String[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            keys[i] = tableName + "." + columnNames[i].toUpperCase();
            ++i;
        }
        return keys;
    }

    public static DBConnection beginTransaction(String dbName) throws Exception {
        DBConnection dbCon = TurbineDB.getConnection(dbName);
        if (dbCon.getConnection().getMetaData().supportsTransactions()) {
            dbCon.setAutoCommit(false);
        }
        return dbCon;
    }

    public static void commitTransaction(DBConnection dbCon) throws Exception {
        if (dbCon.getConnection().getMetaData().supportsTransactions()) {
            dbCon.commit();
            dbCon.setAutoCommit(true);
        }
        TurbineDB.releaseConnection(dbCon);
    }

    public static void rollBackTransaction(DBConnection dbCon) throws Exception {
        if (dbCon.getConnection().getMetaData().supportsTransactions()) {
            dbCon.rollback();
            dbCon.setAutoCommit(true);
        } else {
            Log.error("An attempt was made to rollback a transaction but the database did not allow the operation to be rolled back.");
        }
        TurbineDB.releaseConnection(dbCon);
    }

    public static void deleteAll(DBConnection dbCon, String table, String column, int value) throws Exception {
        Connection conn = dbCon.getConnection();
        Statement statement = null;
        try {
            statement = conn.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("DELETE FROM ").append(table).append(" WHERE ").append(column).append(" = ").append(value);
            statement.executeUpdate(query.toString());
        }
        finally {
            Object var7_7 = null;
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static void deleteAll(String table, String column, int value) throws Exception {
        DBConnection dbCon = null;
        try {
            dbCon = TurbineDB.getConnection();
            BasePeer.deleteAll(dbCon, table, column, value);
        }
        finally {
            Object var5_4 = null;
            TurbineDB.releaseConnection(dbCon);
        }
    }

    public static void doDelete(Criteria criteria) throws Exception {
        DBConnection dbCon = null;
        try {
            dbCon = TurbineDB.getConnection(criteria.getDbName());
            BasePeer.doDelete(criteria, dbCon);
        }
        finally {
            Object var3_2 = null;
            TurbineDB.releaseConnection(dbCon);
        }
    }

    public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception {
        DB db = TurbineDB.getDB(criteria.getDbName());
        DatabaseMap dbMap = TurbineDB.getDatabaseMap(criteria.getDbName());
        Connection connection = dbCon.getConnection();
        StringStackBuffer tables = new StringStackBuffer();
        Enumeration e = criteria.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Criteria.Criterion c = criteria.getCriterion(key);
            String[] tableNames = c.getAllTables();
            int i = 0;
            while (i < tableNames.length) {
                String tableName2 = criteria.getTableForAlias(tableNames[i]);
                if (tableName2 != null) {
                    tables.add(new StringBuffer(tableNames[i].length() + tableName2.length() + 1).append(tableName2).append(' ').append(tableNames[i]).toString());
                } else {
                    tables.add(tableNames[i]);
                }
                ++i;
            }
            if (!criteria.isCascade()) continue;
            TableMap[] tableMaps = dbMap.getTables();
            int i2 = 0;
            while (i2 < tableMaps.length) {
                ColumnMap[] columnMaps = tableMaps[i2].getColumns();
                int j = 0;
                while (j < columnMaps.length) {
                    if (columnMaps[j].isForeignKey() && columnMaps[j].isPrimaryKey() && key.equals(columnMaps[j].getRelatedName())) {
                        tables.add(tableMaps[i2].getName());
                        criteria.add(columnMaps[j].getFullyQualifiedName(), criteria.getValue(key));
                    }
                    ++j;
                }
                ++i2;
            }
        }
        int i = 0;
        while (i < tables.size()) {
            KeyDef kd = new KeyDef();
            StringStackBuffer whereClause = new StringStackBuffer();
            ColumnMap[] columnMaps = dbMap.getTable(tables.get(i)).getColumns();
            int j = 0;
            while (j < columnMaps.length) {
                String key;
                ColumnMap colMap = columnMaps[j];
                if (colMap.isPrimaryKey()) {
                    kd.addAttrib(colMap.getColumnName());
                }
                if (criteria.containsKey(key = colMap.getTableName() + '.' + colMap.getColumnName())) {
                    if (criteria.getComparison(key).equals("CUSTOM")) {
                        whereClause.add(criteria.getString(key));
                    } else {
                        whereClause.add(SqlExpression.build(colMap.getColumnName(), criteria.getValue(key), criteria.getComparison(key), criteria.isIgnoreCase(), db));
                    }
                }
                ++j;
            }
            TableDataSet tds = null;
            try {
                tds = new TableDataSet(connection, tables.get(i), kd);
                String sqlSnippet = whereClause.toString(" AND ");
                TurbineLogging.getLogger("sql").debug("BasePeer.doDelete: whereClause=" + sqlSnippet);
                tds.where(sqlSnippet);
                tds.fetchRecords();
                if (tds.size() > 1 && criteria.isSingleRecord()) {
                    BasePeer.handleMultipleRecords((DataSet)tds);
                }
                int j2 = 0;
                while (j2 < tds.size()) {
                    Record rec = tds.getRecord(j2);
                    rec.markToBeDeleted();
                    rec.save();
                    ++j2;
                }
            }
            finally {
                Object var13_22 = null;
                if (tds != null) {
                    tds.close();
                }
            }
            ++i;
        }
    }

    public static ObjectKey doInsert(Criteria criteria) throws Exception {
        DBConnection dbCon = null;
        ObjectKey id = null;
        boolean doTransaction = TurbineDB.getDB(criteria.getDbName()).objectDataNeedsTrans() && criteria.containsObjectColumn(criteria.getDbName());
        try {
            dbCon = doTransaction ? BasePeer.beginTransaction(criteria.getDbName()) : TurbineDB.getConnection(criteria.getDbName());
            id = BasePeer.doInsert(criteria, dbCon);
        }
        finally {
            Object var5_4 = null;
            if (doTransaction) {
                BasePeer.commitTransaction(dbCon);
            } else {
                TurbineDB.releaseConnection(dbCon);
            }
        }
        return id;
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dbCon) throws Exception {
        SimpleKey id = null;
        String tableName = null;
        Enumeration keys = criteria.keys();
        if (!keys.hasMoreElements()) {
            throw new Exception("Database insert attempted without anything specified to insert");
        }
        tableName = criteria.getTableName((String)keys.nextElement());
        DatabaseMap dbMap = TurbineDB.getDatabaseMap(criteria.getDbName());
        TableMap tableMap = dbMap.getTable(tableName);
        Object keyInfo = tableMap.getPrimaryKeyMethodInfo();
        IdGenerator keyGen = tableMap.getIdGenerator();
        ColumnMap pk = BasePeer.getPrimaryKey(criteria);
        boolean info = false;
        if (!criteria.containsKey(pk.getFullyQualifiedName()) && keyGen.isPriorToInsert()) {
            id = pk.getType() instanceof Number ? new NumberKey(tableMap.getIdGenerator().getIdAsBigDecimal(dbCon.getConnection(), keyInfo)) : new StringKey(tableMap.getIdGenerator().getIdAsString(dbCon.getConnection(), keyInfo));
            criteria.add(pk.getFullyQualifiedName(), id);
        }
        TableDataSet tds = null;
        try {
            tds = new TableDataSet(dbCon.getConnection(), tableName);
            Record rec = tds.addRecord();
            BasePeer.insertOrUpdateRecord(rec, tableName, criteria);
        }
        finally {
            Object var13_13 = null;
            if (tds != null) {
                tds.close();
            }
        }
        if (keyGen != null && keyGen.isPostInsert()) {
            id = pk.getType() instanceof Number ? new NumberKey(tableMap.getIdGenerator().getIdAsBigDecimal(dbCon.getConnection(), keyInfo)) : new StringKey(tableMap.getIdGenerator().getIdAsString(dbCon.getConnection(), keyInfo));
        }
        return id;
    }

    private static void insertOrUpdateRecord(Record rec, String tableName, Criteria criteria) throws Exception {
        DatabaseMap dbMap = TurbineDB.getDatabaseMap(criteria.getDbName());
        ColumnMap[] columnMaps = dbMap.getTable(tableName).getColumns();
        boolean shouldSave = false;
        int j = 0;
        while (j < columnMaps.length) {
            ColumnMap colMap = columnMaps[j];
            String key = colMap.getTableName() + '.' + colMap.getColumnName();
            if (criteria.containsKey(key)) {
                Object obj = criteria.getValue(key);
                if (obj instanceof SimpleKey) {
                    obj = ((SimpleKey)obj).getValue();
                }
                if (obj == null) {
                    rec.setValueNull(colMap.getColumnName());
                } else if (obj instanceof String) {
                    rec.setValue(colMap.getColumnName(), (String)obj);
                } else if (obj instanceof Integer) {
                    rec.setValue(colMap.getColumnName(), criteria.getInt(key));
                } else if (obj instanceof BigDecimal) {
                    rec.setValue(colMap.getColumnName(), (BigDecimal)obj);
                } else if (obj instanceof Long) {
                    rec.setValue(colMap.getColumnName(), criteria.getLong(key));
                } else if (obj instanceof java.util.Date) {
                    rec.setValue(colMap.getColumnName(), (java.util.Date)obj);
                } else if (obj instanceof Float) {
                    rec.setValue(colMap.getColumnName(), criteria.getFloat(key));
                } else if (obj instanceof Double) {
                    rec.setValue(colMap.getColumnName(), criteria.getDouble(key));
                } else if (obj instanceof Hashtable) {
                    rec.setValue(colMap.getColumnName(), BasePeer.hashtableToByteArray((Hashtable)obj));
                } else if (obj instanceof byte[]) {
                    rec.setValue(colMap.getColumnName(), (byte[])obj);
                } else if (obj instanceof Boolean) {
                    rec.setValue(colMap.getColumnName(), criteria.getBoolean(key) ? 1 : 0);
                }
                shouldSave = true;
            }
            ++j;
        }
        if (!shouldSave) {
            throw new Exception("BasePeer.doInsert() - Nothing to insert");
        }
        rec.save();
    }

    public static String createQueryString(Criteria criteria) throws Exception {
        String table;
        int i;
        String table2;
        Query query = new Query();
        DB db = TurbineDB.getDB(criteria.getDbName());
        DatabaseMap dbMap = TurbineDB.getDatabaseMap(criteria.getDbName());
        StringStackBuffer selectModifiers = query.getSelectModifiers();
        StringStackBuffer selectClause = query.getSelectClause();
        StringStackBuffer fromClause = query.getFromClause();
        StringStackBuffer whereClause = query.getWhereClause();
        StringStackBuffer orderByClause = query.getOrderByClause();
        StringStackBuffer orderBy = criteria.getOrderByColumns();
        boolean ignoreCase = criteria.isIgnoreCase();
        StringStackBuffer select = criteria.getSelectColumns();
        Hashtable aliases = criteria.getAsColumns();
        StringStackBuffer modifiers = criteria.getSelectModifiers();
        int i2 = 0;
        while (i2 < modifiers.size()) {
            selectModifiers.add(modifiers.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < select.size()) {
            String columnName = select.get(i2);
            String tableName = null;
            selectClause.add(columnName);
            int parenPos = columnName.indexOf(40);
            tableName = parenPos == -1 ? columnName.substring(0, columnName.indexOf(46)) : columnName.substring(parenPos + 1, columnName.indexOf(46));
            String tableName2 = criteria.getTableForAlias(tableName);
            if (tableName2 != null) {
                fromClause.add(new StringBuffer(tableName.length() + tableName2.length() + 1).append(tableName2).append(' ').append(tableName).toString());
            } else {
                fromClause.add(tableName);
            }
            ++i2;
        }
        Iterator it = aliases.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            selectClause.add((String)aliases.get(key) + " AS " + key);
        }
        Enumeration e = criteria.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Criteria.Criterion criterion = criteria.getCriterion(key);
            Criteria.Criterion[] someCriteria = criterion.getAttachedCriterion();
            table2 = null;
            int i3 = 0;
            while (i3 < someCriteria.length) {
                String tableName = someCriteria[i3].getTable();
                table2 = criteria.getTableForAlias(tableName);
                if (table2 != null) {
                    fromClause.add(new StringBuffer(tableName.length() + table2.length() + 1).append(table2).append(' ').append(tableName).toString());
                } else {
                    fromClause.add(tableName);
                    table2 = tableName;
                }
                boolean ignorCase = criteria.isIgnoreCase() && dbMap.getTable(table2).getColumn(someCriteria[i3].getColumn()).getType() instanceof String;
                someCriteria[i3].setIgnoreCase(ignorCase);
                ++i3;
            }
            criterion.setDB(db);
            whereClause.add(criterion.toString());
        }
        List join = criteria.getJoinL();
        if (join != null) {
            i = 0;
            while (i < join.size()) {
                String join1 = (String)join.get(i);
                String join2 = (String)criteria.getJoinR().get(i);
                String tableName = join1.substring(0, join1.indexOf(46));
                table = criteria.getTableForAlias(tableName);
                if (table != null) {
                    fromClause.add(new StringBuffer(tableName.length() + table.length() + 1).append(table).append(' ').append(tableName).toString());
                } else {
                    fromClause.add(tableName);
                }
                int dot = join2.indexOf(46);
                tableName = join2.substring(0, dot);
                table = criteria.getTableForAlias(tableName);
                if (table != null) {
                    fromClause.add(new StringBuffer(tableName.length() + table.length() + 1).append(table).append(' ').append(tableName).toString());
                } else {
                    fromClause.add(tableName);
                    table = tableName;
                }
                boolean ignorCase = criteria.isIgnoreCase() && dbMap.getTable(table).getColumn(join2.substring(dot + 1, join2.length())).getType() instanceof String;
                whereClause.add(SqlExpression.buildInnerJoin(join1, join2, ignorCase, db));
                ++i;
            }
        }
        if (orderBy != null && orderBy.size() > 0) {
            i = 0;
            while (i < orderBy.size()) {
                String columnName;
                String orderByColumn = orderBy.get(i);
                table2 = orderByColumn.substring(0, orderByColumn.indexOf(46));
                int spacePos = orderByColumn.indexOf(32);
                if (spacePos == -1) {
                    table = orderByColumn.substring(orderByColumn.indexOf(46) + 1);
                } else {
                    columnName = orderByColumn.substring(orderByColumn.indexOf(46) + 1, spacePos);
                }
                ColumnMap column = dbMap.getTable(table2).getColumn(columnName);
                if (column.getType() instanceof String) {
                    if (spacePos == -1) {
                        orderByClause.add(db.ignoreCaseInOrderBy(orderByColumn));
                    } else {
                        orderByClause.add(db.ignoreCaseInOrderBy(orderByColumn.substring(0, spacePos)) + orderByColumn.substring(spacePos));
                    }
                } else {
                    orderByClause.add(orderByColumn);
                }
                ++i;
            }
        }
        int limit = criteria.getLimit();
        int offset = criteria.getOffset();
        String limitString = null;
        if (offset > 0 && db.supportsNativeOffset()) {
            switch (db.getLimitStyle()) {
                case 2: {
                    limitString = offset + ", " + limit;
                    break;
                }
                case 1: {
                    limitString = limit + ", " + offset;
                    break;
                }
            }
            criteria.setLimit(-1);
            criteria.setOffset(0);
        } else if (limit > 0 && db.supportsNativeLimit()) {
            limitString = String.valueOf(limit);
            criteria.setLimit(-1);
        }
        if (limitString != null) {
            query.setLimit(limitString);
        }
        String sql = query.toString();
        TurbineLogging.getLogger("sql").debug(sql);
        return sql;
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        Vector results = null;
        if (TurbineDB.getDB(criteria.getDbName()).objectDataNeedsTrans() && criteria.containsObjectColumn(criteria.getDbName())) {
            DBConnection dbCon = BasePeer.beginTransaction(criteria.getDbName());
            try {
                results = BasePeer.executeQuery(BasePeer.createQueryString(criteria), criteria.isSingleRecord(), dbCon);
                BasePeer.commitTransaction(dbCon);
            }
            catch (Exception e) {
                BasePeer.rollBackTransaction(dbCon);
                throw e;
            }
        } else {
            results = BasePeer.executeQuery(BasePeer.createQueryString(criteria), criteria.getDbName(), criteria.isSingleRecord());
        }
        return results;
    }

    public static Vector doSelect(Criteria criteria, DBConnection dbCon) throws Exception {
        return BasePeer.executeQuery(BasePeer.createQueryString(criteria), criteria.isSingleRecord(), dbCon);
    }

    public static Vector executeQuery(String queryString) throws Exception {
        return BasePeer.executeQuery(queryString, TurbineDB.getDefaultDB(), false);
    }

    public static Vector executeQuery(String queryString, String dbName) throws Exception {
        return BasePeer.executeQuery(queryString, dbName, false);
    }

    public static Vector executeQuery(String queryString, String dbName, boolean singleRecord) throws Exception {
        return BasePeer.executeQuery(queryString, 0, -1, dbName, singleRecord);
    }

    public static Vector executeQuery(String queryString, boolean singleRecord, DBConnection dbCon) throws Exception {
        return BasePeer.executeQuery(queryString, 0, -1, singleRecord, dbCon);
    }

    public static Vector executeQuery(String queryString, int start, int numberOfResults, String dbName, boolean singleRecord) throws Exception {
        DBConnection db = null;
        Vector results = null;
        try {
            db = TurbineDB.getConnection(dbName);
            results = BasePeer.executeQuery(queryString, start, numberOfResults, singleRecord, db);
        }
        finally {
            Object var8_7 = null;
            TurbineDB.releaseConnection(db);
        }
        return results;
    }

    public static Vector executeQuery(String queryString, int start, int numberOfResults, boolean singleRecord, DBConnection dbCon) throws Exception {
        Connection connection = dbCon.getConnection();
        QueryDataSet qds = null;
        Vector results = new Vector();
        try {
            qds = new QueryDataSet(connection, queryString);
            results = BasePeer.getSelectResults(qds, start, numberOfResults, singleRecord);
        }
        finally {
            Object var9_8 = null;
            if (qds != null) {
                qds.close();
            }
        }
        return results;
    }

    public static Vector getSelectResults(QueryDataSet qds) throws Exception {
        return BasePeer.getSelectResults(qds, 0, -1, false);
    }

    public static Vector getSelectResults(QueryDataSet qds, boolean singleRecord) throws Exception {
        return BasePeer.getSelectResults(qds, 0, -1, singleRecord);
    }

    public static Vector getSelectResults(QueryDataSet qds, int numberOfResults, boolean singleRecord) throws Exception {
        Vector results = null;
        if (numberOfResults != 0) {
            results = BasePeer.getSelectResults(qds, 0, numberOfResults, singleRecord);
        }
        return results;
    }

    public static Vector getSelectResults(QueryDataSet qds, int start, int numberOfResults, boolean singleRecord) throws Exception {
        Vector<Record> results;
        if (numberOfResults <= 0) {
            results = new Vector<Record>();
            qds.fetchRecords();
        } else {
            results = new Vector(numberOfResults);
            qds.fetchRecords(start, numberOfResults);
        }
        if (qds.size() > 1 && singleRecord) {
            BasePeer.handleMultipleRecords((DataSet)qds);
        }
        int i = 0;
        while (i < qds.size()) {
            Record rec = qds.getRecord(i);
            results.addElement(rec);
            ++i;
        }
        return results;
    }

    private static ColumnMap getPrimaryKey(Criteria criteria) throws Exception {
        String key = (String)criteria.keys().nextElement();
        String table = criteria.getTableName(key);
        ColumnMap pk = null;
        if (!table.equals("")) {
            DatabaseMap dbMap = TurbineDB.getDatabaseMap(criteria.getDbName());
            if (dbMap == null) {
                throw new Exception("dbMap is null");
            }
            if (dbMap.getTable(table) == null) {
                throw new Exception("dbMap.getTable() is null");
            }
            ColumnMap[] columns = dbMap.getTable(table).getColumns();
            int i = 0;
            while (i < columns.length) {
                if (columns[i].isPrimaryKey()) {
                    pk = columns[i];
                    break;
                }
                ++i;
            }
        }
        return pk;
    }

    public static void doUpdate(Criteria updateValues) throws Exception {
        boolean doTransaction = TurbineDB.getDB(updateValues.getDbName()).objectDataNeedsTrans() && updateValues.containsObjectColumn(updateValues.getDbName());
        DBConnection db = null;
        try {
            db = doTransaction ? BasePeer.beginTransaction(updateValues.getDbName()) : TurbineDB.getConnection(updateValues.getDbName());
            BasePeer.doUpdate(updateValues, db);
        }
        finally {
            Object var4_3 = null;
            if (doTransaction) {
                BasePeer.commitTransaction(db);
            } else {
                TurbineDB.releaseConnection(db);
            }
        }
    }

    public static void doUpdate(Criteria updateValues, DBConnection dbCon) throws Exception {
        ColumnMap pk = BasePeer.getPrimaryKey(updateValues);
        Criteria selectCriteria = null;
        if (pk == null || !updateValues.containsKey(pk.getFullyQualifiedName())) {
            throw new Exception("BasePeer.doUpdate(criteria) - no PK specified");
        }
        selectCriteria = new Criteria(2);
        selectCriteria.put(pk.getFullyQualifiedName(), updateValues.remove(pk.getFullyQualifiedName()));
        BasePeer.doUpdate(selectCriteria, updateValues, dbCon);
    }

    public static void doUpdate(Criteria selectCriteria, Criteria updateValues) throws Exception {
        boolean doTransaction = TurbineDB.getDB(updateValues.getDbName()).objectDataNeedsTrans() && updateValues.containsObjectColumn(selectCriteria.getDbName());
        DBConnection db = null;
        try {
            db = doTransaction ? BasePeer.beginTransaction(selectCriteria.getDbName()) : TurbineDB.getConnection(selectCriteria.getDbName());
            BasePeer.doUpdate(selectCriteria, updateValues, db);
        }
        finally {
            Object var5_4 = null;
            if (doTransaction) {
                BasePeer.commitTransaction(db);
            } else {
                TurbineDB.releaseConnection(db);
            }
        }
    }

    public static void doUpdate(Criteria selectCriteria, Criteria updateValues, DBConnection dbCon) throws Exception {
        DB db = TurbineDB.getDB(selectCriteria.getDbName());
        DatabaseMap dbMap = TurbineDB.getDatabaseMap(selectCriteria.getDbName());
        Connection connection = dbCon.getConnection();
        StringStackBuffer tables = new StringStackBuffer();
        Enumeration e = selectCriteria.keys();
        while (e.hasMoreElements()) {
            tables.add(selectCriteria.getTableName((String)e.nextElement()));
        }
        int i = 0;
        while (i < tables.size()) {
            KeyDef kd = new KeyDef();
            StringStackBuffer whereClause = new StringStackBuffer();
            DatabaseMap tempDbMap = dbMap;
            ColumnMap[] columnMaps = tempDbMap.getTable(tables.get(i)).getColumns();
            int j = 0;
            while (j < columnMaps.length) {
                String key;
                ColumnMap colMap = columnMaps[j];
                if (colMap.isPrimaryKey()) {
                    kd.addAttrib(colMap.getColumnName());
                }
                if (selectCriteria.containsKey(key = colMap.getTableName() + '.' + colMap.getColumnName())) {
                    if (selectCriteria.getComparison(key).equals("CUSTOM")) {
                        whereClause.add(selectCriteria.getString(key));
                    } else {
                        whereClause.add(SqlExpression.build(colMap.getColumnName(), selectCriteria.getValue(key), selectCriteria.getComparison(key), selectCriteria.isIgnoreCase(), db));
                    }
                }
                ++j;
            }
            TableDataSet tds = null;
            try {
                tds = new TableDataSet(connection, tables.get(i), kd);
                String sqlSnippet = whereClause.toString(" AND ");
                TurbineLogging.getLogger("sql").debug("BasePeer.doUpdate: whereClause=" + sqlSnippet);
                tds.where(sqlSnippet);
                tds.fetchRecords();
                if (tds.size() > 1 && selectCriteria.isSingleRecord()) {
                    BasePeer.handleMultipleRecords((DataSet)tds);
                }
                int j2 = 0;
                while (j2 < tds.size()) {
                    Record rec = tds.getRecord(j2);
                    BasePeer.insertOrUpdateRecord(rec, tables.get(i), updateValues);
                    ++j2;
                }
            }
            finally {
                Object var15_17 = null;
                if (tds != null) {
                    tds.close();
                }
            }
            ++i;
        }
    }

    public static int executeStatement(String stmt) throws Exception {
        return BasePeer.executeStatement(stmt, TurbineDB.getDefaultDB());
    }

    public static int executeStatement(String stmt, String dbName) throws Exception {
        DBConnection db = null;
        int rowCount = -1;
        try {
            db = TurbineDB.getConnection(dbName);
            rowCount = BasePeer.executeStatement(stmt, db);
        }
        finally {
            Object var5_4 = null;
            TurbineDB.releaseConnection(db);
        }
        return rowCount;
    }

    public static int executeStatement(String stmt, DBConnection dbCon) throws Exception {
        Connection con = dbCon.getConnection();
        Statement statement = null;
        int rowCount = -1;
        try {
            statement = con.createStatement();
            rowCount = statement.executeUpdate(stmt);
        }
        finally {
            Object var6_5 = null;
            if (statement != null) {
                statement.close();
            }
        }
        return rowCount;
    }

    protected static void handleMultipleRecords(DataSet ds) throws Exception {
        throw new Exception("Criteria expected single Record and Multiple Records were selected.");
    }

    protected static void handleMultiple(DataSet ds) throws Exception {
        BasePeer.handleMultipleRecords(ds);
    }

    public static MapBuilder getMapBuilder() {
        return BasePeer.getMapBuilder(TurbineResources.getString("database.maps.builder", DEFAULT_MAP_BUILDER).trim());
    }

    /*
     * WARNING - void declaration
     */
    public static MapBuilder getMapBuilder(String name) {
        try {
            void e;
            Object object;
            MapBuilder mb = (MapBuilder)mapBuilders.get(name);
            if (mb == null) {
                object = mapBuilders;
                synchronized (object) {
                    mb = (MapBuilder)mapBuilders.get(name);
                    if (mb == null) {
                        mb = (MapBuilder)Class.forName(name).newInstance();
                        mapBuilders.put(name, mb);
                    }
                }
            }
            object = mb;
            synchronized (object) {
                if (!mb.isBuilt()) {
                    mb.doBuild();
                }
            }
            return e;
        }
        catch (Exception e) {
            Log.error("BasePeer.MapBuilder failed trying to instantiate: " + name, e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector doPSSelect(Criteria criteria, DBConnection dbCon) throws Exception {
        Vector v = null;
        StringBuffer qry = new StringBuffer();
        Vector params = new Vector(criteria.size());
        BasePeer.createPreparedStatement(criteria, qry, params);
        PreparedStatement stmt = null;
        try {
            stmt = dbCon.getConnection().prepareStatement(qry.toString());
            int i = 0;
            while (i < params.size()) {
                Object param = params.get(i);
                if (param instanceof Date) {
                    stmt.setDate(i + 1, (Date)param);
                } else {
                    stmt.setString(i + 1, param.toString());
                }
                ++i;
            }
            QueryDataSet qds = null;
            try {
                qds = new QueryDataSet(stmt.executeQuery());
                v = BasePeer.getSelectResults(qds);
            }
            finally {
                Object var11_10 = null;
                if (qds != null) {
                    qds.close();
                }
            }
            Object var7_12 = null;
            if (stmt == null) return v;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return v;
    }

    public static Vector doPSSelect(Criteria criteria) throws Exception {
        DBConnection dbCon = TurbineDB.getConnection(criteria.getDbName());
        Vector v = null;
        try {
            v = BasePeer.doPSSelect(criteria, dbCon);
        }
        finally {
            Object var4_3 = null;
            TurbineDB.releaseConnection(dbCon);
        }
        return v;
    }

    public static void createPreparedStatement(Criteria criteria, StringBuffer queryString, List params) throws Exception {
        String table;
        int i;
        String table2;
        DB db = TurbineDB.getDB(criteria.getDbName());
        DatabaseMap dbMap = TurbineDB.getDatabaseMap(criteria.getDbName());
        Query query = new Query();
        StringStackBuffer selectModifiers = query.getSelectModifiers();
        StringStackBuffer selectClause = query.getSelectClause();
        StringStackBuffer fromClause = query.getFromClause();
        StringStackBuffer whereClause = query.getWhereClause();
        StringStackBuffer orderByClause = query.getOrderByClause();
        StringStackBuffer orderBy = criteria.getOrderByColumns();
        boolean ignoreCase = criteria.isIgnoreCase();
        StringStackBuffer select = criteria.getSelectColumns();
        Hashtable aliases = criteria.getAsColumns();
        StringStackBuffer modifiers = criteria.getSelectModifiers();
        int i2 = 0;
        while (i2 < modifiers.size()) {
            selectModifiers.add(modifiers.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < modifiers.size()) {
            selectModifiers.add(modifiers.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < select.size()) {
            String columnName = select.get(i2);
            String tableName = null;
            selectClause.add(columnName);
            int parenPos = columnName.indexOf(40);
            tableName = parenPos == -1 ? columnName.substring(0, columnName.indexOf(46)) : columnName.substring(parenPos + 1, columnName.indexOf(46));
            String tableName2 = criteria.getTableForAlias(tableName);
            if (tableName2 != null) {
                fromClause.add(new StringBuffer(tableName.length() + tableName2.length() + 1).append(tableName2).append(' ').append(tableName).toString());
            } else {
                fromClause.add(tableName);
            }
            ++i2;
        }
        Iterator it = aliases.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            selectClause.add((String)aliases.get(key) + " AS " + key);
        }
        Enumeration e = criteria.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Criteria.Criterion criterion = criteria.getCriterion(key);
            Criteria.Criterion[] someCriteria = criterion.getAttachedCriterion();
            table2 = null;
            int i3 = 0;
            while (i3 < someCriteria.length) {
                String tableName = someCriteria[i3].getTable();
                table2 = criteria.getTableForAlias(tableName);
                if (table2 != null) {
                    fromClause.add(new StringBuffer(tableName.length() + table2.length() + 1).append(table2).append(' ').append(tableName).toString());
                } else {
                    fromClause.add(tableName);
                    table2 = tableName;
                }
                boolean ignorCase = criteria.isIgnoreCase() && dbMap.getTable(table2).getColumn(someCriteria[i3].getColumn()).getType() instanceof String;
                someCriteria[i3].setIgnoreCase(ignorCase);
                ++i3;
            }
            criterion.setDB(db);
            StringBuffer sb = new StringBuffer();
            criterion.appendPsTo(sb, params);
            whereClause.add(sb.toString());
        }
        List join = criteria.getJoinL();
        if (join != null) {
            i = 0;
            while (i < join.size()) {
                String join1 = (String)join.get(i);
                String join2 = (String)criteria.getJoinR().get(i);
                String tableName = join1.substring(0, join1.indexOf(46));
                table = criteria.getTableForAlias(tableName);
                if (table != null) {
                    fromClause.add(new StringBuffer(tableName.length() + table.length() + 1).append(table).append(' ').append(tableName).toString());
                } else {
                    fromClause.add(tableName);
                }
                int dot = join2.indexOf(46);
                tableName = join2.substring(0, dot);
                table = criteria.getTableForAlias(tableName);
                if (table != null) {
                    fromClause.add(new StringBuffer(tableName.length() + table.length() + 1).append(table).append(' ').append(tableName).toString());
                } else {
                    fromClause.add(tableName);
                    table = tableName;
                }
                boolean ignorCase = criteria.isIgnoreCase() && dbMap.getTable(table).getColumn(join2.substring(dot + 1, join2.length())).getType() instanceof String;
                whereClause.add(SqlExpression.buildInnerJoin(join1, join2, ignorCase, db));
                ++i;
            }
        }
        if (orderBy != null && orderBy.size() > 0) {
            i = 0;
            while (i < orderBy.size()) {
                String columnName;
                String orderByColumn = orderBy.get(i);
                table2 = orderByColumn.substring(0, orderByColumn.indexOf(46));
                int spacePos = orderByColumn.indexOf(32);
                if (spacePos == -1) {
                    table = orderByColumn.substring(orderByColumn.indexOf(46) + 1);
                } else {
                    columnName = orderByColumn.substring(orderByColumn.indexOf(46) + 1, spacePos);
                }
                ColumnMap column = dbMap.getTable(table2).getColumn(columnName);
                if (column.getType() instanceof String) {
                    if (spacePos == -1) {
                        orderByClause.add(db.ignoreCaseInOrderBy(orderByColumn));
                    } else {
                        orderByClause.add(db.ignoreCaseInOrderBy(orderByColumn.substring(0, spacePos)) + orderByColumn.substring(spacePos));
                    }
                } else {
                    orderByClause.add(orderByColumn);
                }
                ++i;
            }
        }
        int limit = criteria.getLimit();
        int offset = criteria.getOffset();
        String limitString = null;
        if (offset > 0 && db.supportsNativeOffset()) {
            switch (db.getLimitStyle()) {
                case 2: {
                    limitString = offset + ", " + limit;
                    break;
                }
                case 1: {
                    limitString = limit + ", " + offset;
                    break;
                }
            }
            criteria.setLimit(-1);
            criteria.setOffset(0);
        } else if (limit > 0 && db.supportsNativeLimit()) {
            limitString = String.valueOf(limit);
            criteria.setLimit(-1);
        }
        if (limitString != null) {
            query.setLimit(limitString);
        }
        String sql = query.toString();
        TurbineLogging.getLogger("sql").debug(sql);
        queryString.append(sql);
    }
}

