/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.apache.turbine.torque.engine.database.model.ForeignKey;
import org.apache.turbine.torque.engine.database.model.Inheritance;
import org.apache.turbine.torque.engine.database.model.Table;
import org.apache.turbine.torque.engine.database.model.TypeMap;
import org.apache.velocity.util.StringUtils;
import org.xml.sax.Attributes;

public class Column {
    private String name;
    private String javaName = null;
    private boolean isNotNull = false;
    private String size;
    private String torqueType;
    private Object columnType;
    private Table parentTable;
    private int position;
    private boolean isPrimaryKey = false;
    private boolean isUnique = false;
    private boolean isAutoIncrement = false;
    private String defaultValue;
    private List referrers;
    private String inheritanceType;
    private boolean isInheritance;
    private boolean isEnumeratedClasses;
    private List inheritanceList;
    private String inputValidator = null;

    public void loadFromXML(Attributes attrib) {
        String notNull;
        this.name = attrib.getValue("name");
        this.javaName = attrib.getValue("javaName");
        String primaryKey = attrib.getValue("primaryKey");
        this.isPrimaryKey = "true".equals(primaryKey);
        if ("true".equals(primaryKey)) {
            this.isNotNull = true;
        }
        this.isNotNull = (notNull = attrib.getValue("required")) != null && "true".equals(notNull);
        String autoIncrement = attrib.getValue("autoIncrement");
        this.isAutoIncrement = "true".equals(autoIncrement);
        this.defaultValue = attrib.getValue("default");
        this.size = attrib.getValue("size");
        this.torqueType = attrib.getValue("type");
        this.inheritanceType = attrib.getValue("inheritance");
        this.isInheritance = this.inheritanceType != null && !this.inheritanceType.equals("false");
        this.inputValidator = attrib.getValue("inputValidator");
    }

    public String getFullyQualifiedName() {
        return this.parentTable.getName() + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getJavaName() {
        if (this.javaName == null) {
            return StringUtils.removeUnderScores(this.name);
        }
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int v) {
        this.position = v;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public Inheritance addInheritance(Attributes attrib) {
        Inheritance inh = new Inheritance();
        inh.loadFromXML(attrib);
        this.addInheritance(inh);
        return inh;
    }

    public void addInheritance(Inheritance inh) {
        inh.setColumn(this);
        if (this.inheritanceList == null) {
            this.inheritanceList = new ArrayList();
            this.isEnumeratedClasses = true;
        }
        this.inheritanceList.add(inh);
    }

    public List getChildren() {
        return this.inheritanceList;
    }

    public boolean isInheritance() {
        return this.isInheritance;
    }

    public boolean isEnumeratedClasses() {
        return this.isEnumeratedClasses;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    public void setNotNull(boolean status) {
        this.isNotNull = status;
    }

    public void setPrimaryKey(boolean pk) {
        this.isPrimaryKey = pk;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setUnique(boolean u) {
        this.isUnique = u;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isForeignKey() {
        return this.parentTable.getForeignKey(this.name) != null;
    }

    public boolean isMultipleFK() {
        ForeignKey fk1 = this.parentTable.getForeignKey(this.name);
        if (fk1 != null) {
            ForeignKey[] fks = this.parentTable.getForeignKeys();
            int i = 0;
            while (i < fks.length) {
                if (fks[i].getForeignTableName().equals(fk1.getForeignTableName()) && !fks[i].getLocalColumns().contains(this.name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ForeignKey getForeignKey() {
        return this.parentTable.getForeignKey(this.name);
    }

    public String getRelatedTableName() {
        ForeignKey fk = this.parentTable.getForeignKey(this.name);
        if (fk == null) {
            return null;
        }
        return fk.getForeignTableName();
    }

    public String getRelatedColumnName() {
        ForeignKey fk = this.parentTable.getForeignKey(this.name);
        if (fk == null) {
            return null;
        }
        return fk.getLocalForeignMapping().get(this.name).toString();
    }

    public void addReferrer(ForeignKey fk) {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        this.referrers.add(fk);
    }

    public List getReferrers() {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        return this.referrers;
    }

    public void setType(String torqueType) {
        this.torqueType = torqueType;
    }

    public Object getType() {
        return TypeMap.getJdbcType(this.torqueType);
    }

    public Object getTorqueType() {
        return this.torqueType;
    }

    public boolean isString() {
        return this.columnType instanceof String;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("    <column name=\"" + this.name + "\"");
        if (this.javaName != null) {
            result.append(" javaName=\"" + this.javaName + "\"");
        }
        if (this.isPrimaryKey) {
            result.append(" primaryKey=\"" + this.isPrimaryKey + "\"");
        }
        if (this.isNotNull) {
            result.append(" required=\"true\"");
        } else {
            result.append(" required=\"false\"");
        }
        result.append(" type=\"").append(this.torqueType).append("\"");
        if (this.size != null) {
            result.append(" size=\"" + this.size + "\"");
        }
        if (this.defaultValue != null) {
            result.append(" default=\"" + this.defaultValue + "\"");
        }
        if (this.isInheritance()) {
            result.append(" inheritance=\"" + this.inheritanceType + "\"");
        }
        result.append(">");
        result.append("</column>\n");
        return result.toString();
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String newSize) {
        this.size = newSize;
    }

    public String printSize() {
        if (this.size != null) {
            return "(" + this.size + ")";
        }
        return "";
    }

    public String getDefaultSetting() {
        StringBuffer dflt = new StringBuffer(0);
        if (this.defaultValue != null) {
            dflt.append("default ");
            if (TypeMap.isTextType(this.torqueType)) {
                dflt.append('\'').append(this.defaultValue).append('\'');
            } else {
                dflt.append(this.defaultValue);
            }
        }
        return dflt.toString();
    }

    public void setDefaultValue(String def) {
        this.defaultValue = def;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getInputValidator() {
        return this.inputValidator;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setAutoIncrement(boolean value) {
        this.isAutoIncrement = value;
    }

    public void setTypeFromString(String typeName, String size) {
        String tn = typeName.toUpperCase();
        this.setType(tn);
        if (this.size != null) {
            this.size = size;
        }
        if (tn.indexOf("CHAR") != -1) {
            this.torqueType = "VARCHAR";
            this.columnType = "";
        } else if (tn.indexOf("INT") != -1) {
            this.torqueType = "INTEGER";
            this.columnType = new Integer(0);
        } else if (tn.indexOf("FLOAT") != -1) {
            this.torqueType = "FLOAT";
            this.columnType = new Float(0.0f);
        } else if (tn.indexOf("DATE") != -1) {
            this.torqueType = "DATE";
            this.columnType = new Date();
        } else if (tn.indexOf("TIME") != -1) {
            this.torqueType = "TIMESTAMP";
            this.columnType = new Date();
        } else if (tn.indexOf("BINARY") != -1) {
            this.torqueType = "LONGVARBINARY";
            this.columnType = new Hashtable();
        } else {
            this.torqueType = "VARCHAR";
            this.columnType = "";
        }
    }

    public String getJavaObject() {
        return TypeMap.getJavaObject(this.torqueType);
    }

    public String getJavaNative() {
        String jtype = TypeMap.getJavaNative(this.torqueType);
        if (this.isPrimaryKey() || this.isForeignKey()) {
            if (jtype.equals("String")) {
                jtype = "StringKey";
            } else if (jtype.equals("Date")) {
                jtype = "DateKey";
            } else if (jtype.equals("short") || jtype.equals("int") || jtype.equals("long") || jtype.equals("BigDecimal") || jtype.equals("byte") || jtype.equals("float") || jtype.equals("double")) {
                jtype = "NumberKey";
            }
        }
        return jtype;
    }

    public String getVillageMethod() {
        String vmethod = TypeMap.getVillageMethod(this.torqueType);
        String jtype = TypeMap.getJavaNative(this.torqueType);
        if ((this.isPrimaryKey() || this.isForeignKey()) && (jtype.equals("short") || jtype.equals("int") || jtype.equals("long") || jtype.equals("byte") || jtype.equals("float") || jtype.equals("double"))) {
            vmethod = "asBigDecimal()";
        }
        return vmethod;
    }

    public String getParameterParserMethod() {
        return TypeMap.getPPMethod(this.torqueType);
    }

    public boolean isBooleanInt() {
        return TypeMap.isBooleanInt(this.torqueType);
    }

    public boolean isBooleanChar() {
        return TypeMap.isBooleanChar(this.torqueType);
    }

    public boolean isPrimitive() {
        String t = this.getJavaNative();
        return "boolean".equals(t) || "byte".equals(t) || "short".equals(t) || "int".equals(t) || "long".equals(t) || "float".equals(t) || "double".equals(t) || "char".equals(t);
    }

    public Column() {
    }

    public Column(String name) {
        this.name = name;
    }
}

