/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Event;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.component.BaseEventTrackingService;
import org.chefproject.util.Sql;
import org.chefproject.util.SqlReader;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;

public class ClusterEventTracking
extends BaseEventTrackingService
implements Runnable {
    protected static String m_logId = "EventTracking: ";
    protected static long PERIOD = 2000L;
    protected Thread m_thread = null;
    protected boolean m_threadStop = false;
    protected long m_lastEventSeq = 0L;
    protected boolean m_checkDb = true;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_checkDb = new Boolean(this.getProperties().getProperty("check-db", "true"));
        if (this.m_checkDb) {
            this.initLastEvent();
            this.start();
        }
    }

    public void shutdown() {
        this.stop();
        super.shutdown();
    }

    protected void postEvent(Event event) {
        String reportId = null;
        reportId = event.getSessionId() != null ? event.getSessionId() : "~" + ServerConfigurationService.getServerId() + "~" + event.getUserId();
        String statement = "insert into CHEF_EVENT (EVENT_ID,EVENT_DATE,EVENT,REF,SESSION_ID,EVENT_CODE) values ( CHEF_EVENT_SEQ.NEXTVAL, ?, ?, ?, ?, ? )";
        Object[] fields = new Object[]{new Time(), event.getEvent(), event.getResource(), reportId, event.getModify() ? "m" : "a"};
        boolean ok = Sql.dbWrite(statement, fields);
        if (!ok) {
            Log.warn("chef", this + ".postEvent(): dbWrite failed");
        }
        this.notifyObservers(event, true);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", m_logId + reportId + "@" + event);
        }
    }

    protected void start() {
        this.m_threadStop = false;
        this.m_thread = new Thread((Runnable)this, this.getClass().getName());
        this.m_thread.start();
    }

    protected void stop() {
        if (this.m_thread == null) {
            return;
        }
        this.m_threadStop = true;
        this.m_thread.interrupt();
        this.m_thread = null;
    }

    public void run() {
        while (!this.m_threadStop && !Thread.currentThread().isInterrupted()) {
            try {
                String statement = "select * from CHEF_EVENT where EVENT_ID > ?";
                Object[] fields = new Object[]{new Long(this.m_lastEventSeq)};
                List events = Sql.dbRead(statement, fields, new SqlReader(){

                    public Object readSqlResultRecord(ResultSet result) {
                        try {
                            long id = result.getLong(1);
                            Time date = new Time(result.getTimestamp(2, (Calendar)Sql.M_cal).getTime());
                            String function = result.getString(3);
                            String ref = result.getString(4);
                            String session = result.getString(5);
                            String code = result.getString(6);
                            ClusterEventTracking.this.m_lastEventSeq = id;
                            boolean nonSessionEvent = session.startsWith("~");
                            String serverId = null;
                            String userId = null;
                            boolean skipIt = false;
                            if (nonSessionEvent) {
                                String[] parts = StringUtil.split(session, "~");
                                serverId = parts[1];
                                userId = parts[2];
                                skipIt = ServerConfigurationService.getServerId().equals(serverId);
                            }
                            if (skipIt || UsageSessionService.isLocalSession(session)) {
                                return null;
                            }
                            BaseEventTrackingService.BaseEvent event = new BaseEventTrackingService.BaseEvent(id, function, ref, code.equals("m"));
                            if (nonSessionEvent) {
                                event.setUserId(userId);
                            } else {
                                event.setSessionId(session);
                            }
                            return event;
                        }
                        catch (SQLException ignore) {
                            return null;
                        }
                    }
                });
                int i = 0;
                while (i < events.size()) {
                    Event event = (Event)events.get(i);
                    this.notifyObservers(event, false);
                    ++i;
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                Thread.sleep(PERIOD);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void initLastEvent() {
        String statement = "select MAX(EVENT_ID) from CHEF_EVENT";
        Sql.dbRead(statement, null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                try {
                    ClusterEventTracking.this.m_lastEventSeq = result.getLong(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return null;
            }
        });
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + " Starting (after) Event #: " + this.m_lastEventSeq);
        }
    }
}

