/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.chefproject.convert.CalendarContextConverter;
import org.chefproject.core.Calendar;
import org.chefproject.core.CalendarEdit;
import org.chefproject.core.CalendarEvent;
import org.chefproject.core.CalendarEventEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseCalendarService;
import org.chefproject.service.component.BaseDbDoubleStorage;

public class DbCachedCalendarService
extends BaseCalendarService {
    protected String m_calendarTableName = "CALENDAR_CALENDAR";
    protected String m_eventTableName = "CALENDAR_EVENT";
    protected boolean m_locksInDb = true;
    protected static final String[] FIELDS = new String[]{"EVENT_START", "EVENT_END"};

    public void init() throws InitializationException {
        this.m_calendarTableName = this.getProperties().getProperty("calendarTable", this.m_calendarTableName);
        this.m_eventTableName = this.getProperties().getProperty("eventTable", this.m_eventTableName);
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        boolean contextConversion = new Boolean(this.getProperties().getProperty("contextConversion", "false"));
        super.init();
        if (contextConversion) {
            CalendarContextConverter.convert(this.m_calendarTableName, this.m_eventTableName, this);
        }
        Log.info("chef", this + ".init(): calendar table: " + this.m_calendarTableName + " event table: " + this.m_eventTableName);
    }

    protected BaseCalendarService.Storage newStorage() {
        return new DbStorage(this);
    }

    protected class DbStorage
    extends BaseDbDoubleStorage
    implements BaseCalendarService.Storage {
        public DbStorage(StorageUser user) {
            super(DbCachedCalendarService.this.m_calendarTableName, "CALENDAR_ID", DbCachedCalendarService.this.m_eventTableName, "EVENT_ID", "CALENDAR_ID", "EVENT_START", FIELDS, DbCachedCalendarService.this.m_locksInDb, "calendar", "event", user);
        }

        public boolean checkCalendar(String ref) {
            return super.getContainer(ref) != null;
        }

        public Calendar getCalendar(String ref) {
            return (Calendar)super.getContainer(ref);
        }

        public List getCalendars() {
            return super.getAllContainers();
        }

        public CalendarEdit putCalendar(String ref) {
            return (CalendarEdit)super.putContainer(ref);
        }

        public CalendarEdit editCalendar(String ref) {
            return (CalendarEdit)super.editContainer(ref);
        }

        public void commitCalendar(CalendarEdit edit) {
            super.commitContainer(edit);
        }

        public void cancelCalendar(CalendarEdit edit) {
            super.cancelContainer(edit);
        }

        public void removeCalendar(CalendarEdit edit) {
            super.removeContainer(edit);
        }

        public boolean checkEvent(Calendar calendar, String messageId) {
            return super.checkResource(calendar, messageId);
        }

        public CalendarEvent getEvent(Calendar calendar, String id) {
            return (CalendarEvent)super.getResource(calendar, id);
        }

        public List getEvents(Calendar calendar) {
            return super.getAllResources(calendar);
        }

        public CalendarEventEdit putEvent(Calendar calendar, String id) {
            return (CalendarEventEdit)super.putResource(calendar, id, null);
        }

        public CalendarEventEdit editEvent(Calendar calendar, String messageId) {
            return (CalendarEventEdit)super.editResource(calendar, messageId);
        }

        public void commitEvent(Calendar calendar, CalendarEventEdit edit) {
            super.commitResource(calendar, edit);
        }

        public void cancelEvent(Calendar calendar, CalendarEventEdit edit) {
            super.cancelResource(calendar, edit);
        }

        public void removeEvent(Calendar calendar, CalendarEventEdit edit) {
            super.removeResource(calendar, edit);
        }
    }
}

