/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import java.util.Vector;

public class BasisSetDescriptor {
    protected String m_url;
    protected String m_name;
    protected String m_type;
    protected String m_curationStatus;
    protected boolean m_hasEcp;
    protected boolean m_hasSpin;
    protected int m_numElts;
    protected Vector m_elts;
    protected String m_date;
    protected String m_contributionPI;
    protected String m_contributorName;
    protected String m_abstract;

    public BasisSetDescriptor(String url, String name, String type, String curationStatus, boolean hasEcp, boolean hasSpin, Vector elts, String date, String contributionPI, String contributorName, String bsAbstract) {
        this.m_url = url;
        this.m_name = name;
        this.m_type = type;
        this.m_curationStatus = curationStatus;
        this.m_hasEcp = hasEcp;
        this.m_hasSpin = hasSpin;
        this.m_elts = elts;
        this.m_numElts = this.m_elts.size();
        this.m_date = date;
        this.m_contributionPI = contributionPI;
        this.m_contributorName = contributorName;
        this.m_abstract = bsAbstract;
        if (this.m_abstract == "") {
            this.m_abstract = "N/A";
        }
        if (this.m_contributorName == "") {
            this.m_contributorName = "N/A";
        }
        if (this.m_contributionPI == "") {
            this.m_contributionPI = "N/A";
        }
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public String getWebSafeName() {
        return BasisSetDescriptor.getWebSafeString(this.m_name);
    }

    public String getCurationStatus() {
        return this.m_curationStatus;
    }

    public String getWebSafeCurationStatus() {
        return BasisSetDescriptor.getWebSafeString(this.m_curationStatus);
    }

    public boolean hasEcp() {
        return this.m_hasEcp;
    }

    public boolean hasSpinOrbitOp() {
        return this.m_hasSpin;
    }

    public int getNumElts() {
        return this.m_numElts;
    }

    public Vector getElts() {
        return this.m_elts;
    }

    public String getLastModifiedDate() {
        return this.m_date;
    }

    public String getWebSafeLastModifiedDate() {
        return BasisSetDescriptor.getWebSafeString(this.m_date);
    }

    public String getContributionPI() {
        return this.m_contributionPI;
    }

    public String getWebSafeContributionPI() {
        return BasisSetDescriptor.getWebSafeString(this.m_contributionPI);
    }

    public String getContributorName() {
        return this.m_contributorName;
    }

    public String getWebSafeContributorName() {
        return BasisSetDescriptor.getWebSafeString(this.m_contributorName);
    }

    public String getWebSafeAbstract() {
        return BasisSetDescriptor.getWebSafeString(this.m_abstract);
    }

    public String getAbstract() {
        return this.m_abstract;
    }

    public static String getWebSafeString(String original) {
        String result = original;
        if (original.indexOf("\r\n") > -1) {
            result = original.replaceAll("\n", "<br/>");
        } else if (original.indexOf("\n") > -1) {
            result = original.replaceAll("\n", "<br/>");
        }
        return result;
    }
}

