/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIPool;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.dsm.resourceobject.IServiceConnection;
import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.dsm.search.Search;
import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.dsm.util.DAVResourcePropertyVector;
import com.sourceforge.knecs.dsm.util.PedigreeUtils;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class DAVConnection
implements IServiceConnection {
    private String mUser;
    private String mAuth;
    private Logger mLog;

    private DAVConnection() {
    }

    public DAVConnection(String aProviderURL) {
        this.mLog = LoggerUtils.getLogger(this);
    }

    public void connect(String aUserID, String anAuthToken) {
        this.mUser = aUserID;
        this.mAuth = anAuthToken;
    }

    public void close() {
        this.mUser = null;
        this.mAuth = null;
        this.mLog = null;
    }

    protected DSI getDSI(String url) {
        return DSIPool.getDSIPool().getConnection(url, this.mUser, this.mAuth);
    }

    protected void releaseDSI(DSI dsi) {
        DSIPool.getDSIPool().release(dsi);
    }

    public DAVResource get(String resourcePath, Vector resourceProperties) throws Exception {
        DAVResource retVal = null;
        DSI dsi = this.getDSI(resourcePath);
        try {
            String contentLengthString;
            retVal = new DAVResource();
            Hashtable retProps = dsi.getMetaData(resourceProperties);
            if (retProps != null && !retProps.isEmpty()) {
                Iterator it = retProps.keySet().iterator();
                while (it.hasNext()) {
                    DSIProperty curProp = (DSIProperty)retProps.get(it.next());
                    retVal.putProperty(curProp);
                }
            }
            int contentLength = 0;
            DAVResourcePropertyVector contentLengthVector = retVal.getContentLength();
            if (contentLengthVector != null && contentLengthVector.size() > 0 && (contentLengthString = (String)contentLengthVector.get(0)) != null && contentLengthString.length() > 0) {
                contentLength = Integer.parseInt(contentLengthString);
            }
            if (contentLength > 1) {
                String content = dsi.getDataSetAsString();
                retVal.setContent(content);
            }
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            String stackTrace = new String(e.toString());
            for (int i = 0; i < st.length; ++i) {
                stackTrace = stackTrace + "\n     in " + st[i].getClassName() + ":" + st[i].getMethodName() + ":" + st[i].getLineNumber();
            }
            this.mLog.severe("Exception caught in getMetaData call to DSI " + stackTrace);
            retVal = null;
            throw e;
        }
        finally {
            this.releaseDSI(dsi);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector search(String resourcePath, HashSet resourceProperties, QueryPredicate[] searchFilter, int depth) throws Exception {
        Vector srchResults = null;
        StringBuffer badResults = new StringBuffer();
        int badResultsCount = 0;
        DSI dsi = this.getDSI(resourcePath);
        Hashtable<NSProperty, QueryPredicate> searchCriteria = new Hashtable<NSProperty, QueryPredicate>();
        if (searchFilter != null) {
            for (int i = 0; i < searchFilter.length; ++i) {
                searchCriteria.put(searchFilter[i].getNSProperty(), searchFilter[i]);
            }
        }
        try {
            Search srch = new Search();
            srchResults = srch.runInDsiContext(resourcePath, dsi, resourceProperties, searchCriteria, depth);
            DAVResource dr = null;
            for (int idx = 0; idx < srchResults.size(); ++idx) {
                try {
                    String contentLengthString;
                    dr = (DAVResource)srchResults.get(idx);
                    DAVResourcePropertyVector contentLengthVector = dr.getContentLength();
                    int contentLength = 0;
                    if (contentLengthVector != null && contentLengthVector.size() > 0 && (contentLengthString = (String)contentLengthVector.get(0)) != null && contentLengthString.length() > 0) {
                        contentLength = Integer.parseInt(contentLengthString);
                    }
                    if (contentLength <= true) continue;
                    dsi.setURL(dr.getURL());
                    dr.setContent(dsi.getDataSetAsString());
                    continue;
                }
                catch (StatusException se) {
                    ++badResultsCount;
                    badResults.append(dr.getURL() + "  had Exception: " + se.toString() + "\n");
                }
            }
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            String stackTrace = new String(e.toString());
            int i = 0;
            if (i < st.length) {
                stackTrace = stackTrace + "\n     in " + st[i].getClassName() + ":" + st[i].getMethodName() + ":" + st[i].getLineNumber();
                this.mLog.severe("Exception caught in search call to DSI " + stackTrace);
                throw e;
            }
        }
        finally {
            this.releaseDSI(dsi);
        }
        if (badResultsCount > 0) {
            String errStr = badResultsCount + " DAVResource objects were not retrieved in search call to DSI. Offending urls and exceptions are: " + badResults.toString();
            this.mLog.severe(errStr);
            throw new Exception(errStr);
        }
        return srchResults;
    }

    public void modify(String resourcePath, String content, Hashtable modifiedProperties, Collection propsToRemove) throws Exception {
        this.doModify(resourcePath, content, modifiedProperties);
        this.doRemoveProperties(resourcePath, propsToRemove);
    }

    protected void doRemoveProperties(String resourcePath, Collection propsToRemove) throws Exception {
        if (!propsToRemove.isEmpty()) {
            Iterator it = propsToRemove.iterator();
            Vector<NSProperty> rmProps = new Vector<NSProperty>();
            while (it.hasNext()) {
                rmProps.add(new NSProperty((String)it.next()));
            }
            DSI dsi = this.getDSI(resourcePath);
            try {
                dsi.removeMetaData(rmProps);
            }
            catch (StatusException se) {
                String errMsg = se.getStatusMessage();
                int statCode = se.getStatusCode();
                this.mLog.severe("Caught exception during resourceobject modify to remove properties " + errMsg + " status code: " + statCode);
                throw se;
            }
            finally {
                this.releaseDSI(dsi);
            }
        }
    }

    public void modify(String resourcePath, String content, Hashtable properties) throws Exception {
        this.doModify(resourcePath, content, properties);
    }

    protected void doModify(String resourcePath, String content, Hashtable theProperties) throws Exception {
        DSI dsi = this.getDSI(resourcePath);
        try {
            if (content != null) {
                dsi.putDataSet(content);
            }
            if (theProperties != null && !theProperties.isEmpty()) {
                Hashtable properties = this.convertProperties(theProperties);
                dsi.putMetaData(properties);
            }
        }
        catch (StatusException se) {
            String errMsg = se.getStatusMessage();
            int statCode = se.getStatusCode();
            this.mLog.severe("Caught exception during resourceobject modify " + errMsg + " status code: " + statCode + " URL=" + dsi.getURL());
            throw se;
        }
        finally {
            this.releaseDSI(dsi);
        }
    }

    public void save(String resourcePath, String content, Hashtable theProperties) throws Exception {
        DSI dsi = this.getDSI(resourcePath);
        try {
            dsi.putDataSet(content);
            Hashtable properties = this.convertProperties(theProperties);
            dsi.putMetaData(properties);
        }
        catch (StatusException se) {
            String errMsg = se.getStatusMessage();
            int statCode = se.getStatusCode();
            this.mLog.severe("Caught exception during resourceobject save " + errMsg + " status code: " + statCode);
            throw se;
        }
        finally {
            this.releaseDSI(dsi);
        }
    }

    private Hashtable convertProperties(Hashtable inProperties) {
        Hashtable<NSProperty, String> outProperties = null;
        if (inProperties != null) {
            outProperties = new Hashtable<NSProperty, String>(inProperties.size());
            Enumeration e = inProperties.keys();
            while (e.hasMoreElements()) {
                String propKey = (String)e.nextElement();
                NSProperty propName = new NSProperty(propKey);
                Object propValue = inProperties.get(propKey);
                Class<?> propClass = propValue.getClass();
                String propStringValue = null;
                if (propClass.isArray()) {
                    Class<?> componentClass = propClass.getComponentType();
                    if (componentClass != Byte.class && componentClass != Byte[].class) {
                        if (Array.getLength(propValue) > 0) {
                            Vector<String> propVector = new Vector<String>();
                            for (int i = 0; i < Array.getLength(propValue); ++i) {
                                String tmpStr = Array.get(propValue, i).toString();
                                if (tmpStr.length() <= 0) continue;
                                propVector.add(tmpStr);
                            }
                            if (propVector.size() > 0) {
                                propStringValue = PedigreeUtils.makeRDFBag(propVector);
                            }
                        }
                    } else {
                        this.mLog.severe("Found unexpected " + componentClass + " data type when converting properties.");
                    }
                } else {
                    propStringValue = propValue.toString();
                }
                if (propStringValue == null || propStringValue.length() <= 0) continue;
                outProperties.put(propName, propStringValue);
            }
        }
        return outProperties;
    }

    public void delete(String pathName) throws Exception {
        DSI dsi = this.getDSI(pathName);
        try {
            dsi.removeResource();
        }
        catch (Exception e) {
            this.mLog.severe("Unable to remove resource: " + pathName + " exception: " + e.getMessage());
            throw e;
        }
        finally {
            this.releaseDSI(dsi);
        }
    }

    public boolean exists(String pathName) throws Exception {
        boolean retValue = false;
        DSI dsi = this.getDSI(pathName);
        try {
            retValue = dsi.exists();
        }
        catch (StatusException se) {
            String errMsg = se.getStatusMessage();
            int statCode = se.getStatusCode();
            this.mLog.severe("Caught exception during check for resourceobject existence " + errMsg + " status code: " + statCode);
            throw se;
        }
        finally {
            this.releaseDSI(dsi);
        }
        return retValue;
    }
}

