/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util.statlog;

import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.statlog.StatXMLFormatter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class StatLogService {
    public static void initialize(String prefix) {
        CMCSProperties cmcsProp = CMCSProperties.getCMCSProperties();
        Vector logNames = CMCSProperties.getPropertyAsVector("StatisticsLoggers");
        for (String logName : logNames) {
            String logFile = prefix + cmcsProp.getProperty(logName + "LogFile");
            String style = cmcsProp.getProperty(logName + "Style");
            String append = cmcsProp.getProperty(logName + "Append");
            Logger logger = Logger.getLogger(logName);
            try {
                Formatter formatter;
                FileHandler fh = new FileHandler(logFile, append != null && append.equals("true"));
                if (style == "simple") {
                    formatter = new SimpleFormatter();
                    fh.setFormatter(formatter);
                } else {
                    formatter = new StatXMLFormatter(logFile);
                    fh.setFormatter(formatter);
                }
                logger.addHandler(fh);
                logger.setLevel(Level.INFO);
            }
            catch (IOException ex) {}
        }
    }
}

