/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.localization.LocalizationService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public abstract class Localization {
    public static String getString(String str) {
        return ((LocalizationService)TurbineServices.getInstance().getService("LocalizationService")).getBundle().getString(str);
    }

    public static String getString(RunData data, String str) {
        return ((LocalizationService)TurbineServices.getInstance().getService("LocalizationService")).getBundle(data).getString(str);
    }

    public static String getString(String str, String lang) {
        String bundleName = TurbineResources.getString("locale.default.bundle", "");
        return Localization.getBundle(bundleName, new Locale(lang, "")).getString(str);
    }

    public static ResourceBundle getBundle(String bundleName) {
        return ((LocalizationService)TurbineServices.getInstance().getService("LocalizationService")).getBundle(bundleName);
    }

    public static ResourceBundle getBundle(String bundleName, String languageHeader) {
        return ((LocalizationService)TurbineServices.getInstance().getService("LocalizationService")).getBundle(bundleName, languageHeader);
    }

    public static ResourceBundle getBundle(String bundleName, RunData data) {
        return ((LocalizationService)TurbineServices.getInstance().getService("LocalizationService")).getBundle(bundleName, data);
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale) {
        return ((LocalizationService)TurbineServices.getInstance().getService("LocalizationService")).getBundle(bundleName, locale);
    }

    public static void setBundle(String defaultBundle) {
        ((LocalizationService)TurbineServices.getInstance().getService("LocalizationService")).setBundle(defaultBundle);
    }
}

