/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.webservices.clientproxy;

import com.sourceforge.knecs.webservices.clientproxy.BaseResponseHandler;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.message.SOAPHeaderElement;

public class PollResponseHandler
extends BaseResponseHandler {
    protected String mQueryMethod;
    protected int mPollDelay = 60000;

    public PollResponseHandler(String endPoint, String namespace, String responseMethod, QName returnType, String readyMethod) {
        super(endPoint, namespace, responseMethod, returnType);
        this.mQueryMethod = readyMethod;
    }

    public PollResponseHandler(String endPoint, String namespace, String responseMethod, QName returnType, String readyMethod, int pollDelay) {
        super(endPoint, namespace, responseMethod, returnType);
        this.mQueryMethod = readyMethod;
        this.mPollDelay = pollDelay;
    }

    public void handle(Object requestResponse, String correlationId) {
        this.setCorrelationId(correlationId);
        this.getLogger().info("PollResponseHandler.handle() ");
        boolean ready = false;
        while (!ready) {
            try {
                ready = this.isReady();
                if (ready) continue;
                Thread.currentThread().join(this.mPollDelay);
            }
            catch (Exception ex) {
                this.getLogger().warning("Poll failed: \n\tCorrelation ID" + this.mCorrelationId + "\n\tmethod" + this.mQueryMethod + ex.getMessage());
                if (ready) continue;
                try {
                    Thread.currentThread().join(this.mPollDelay);
                }
                catch (Exception interrupt) {}
            }
        }
        this.getLogger().info("Yeah! is ready" + ready);
        try {
            this.processResponse();
        }
        catch (AxisFault fault) {
            this.getLogger().warning("Get response failed: \n\tCorrelation ID" + this.mCorrelationId + "\n\tmethod" + this.mOperationName + fault.getMessage() + "\n\t" + fault);
            fault.printStackTrace();
        }
    }

    public boolean isReady() throws AxisFault {
        this.getLogger().info("isReady " + this.mCorrelationId);
        boolean ret = false;
        Call query = this.constructQueryCall();
        try {
            Object queryResult = query.invoke(new Object[0]);
            if (!(queryResult instanceof String)) {
                throw new AxisFault("Unexpected return type" + queryResult);
            }
            ret = ((String)queryResult).equals("true");
        }
        catch (RemoteException rex) {
            throw AxisFault.makeFault(rex);
        }
        this.getLogger().info("isReady " + this.mCorrelationId + " " + ret);
        return ret;
    }

    public Call constructQueryCall() throws AxisFault {
        Call call = null;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(this.mEndPointUrl);
            call.setOperationName(new QName(this.mNamespace, this.mQueryMethod));
            SOAPHeaderElement cid = new SOAPHeaderElement("http://cmcs.org", "CorrelationId");
            cid.setObjectValue(this.getCorrelationId());
            call.addHeader(cid);
            call.setReturnType(XMLType.XSD_STRING);
        }
        catch (ServiceException createex) {
            throw AxisFault.makeFault(createex);
        }
        catch (SOAPException soapex) {
            throw AxisFault.makeFault(soapex);
        }
        return call;
    }

    protected void processResponse() throws AxisFault {
        Logger log = this.getLogger();
        log.info("Requesting response");
        Object response = null;
        try {
            Call call = this.constructCall();
            String[] name = (String[])call.invoke(new Object[0]);
            MessageContext messageContext = call.getMessageContext();
            Message returnedMessage = messageContext.getResponseMessage();
            log.info("Number of attachments is -> " + returnedMessage.countAttachments());
            Iterator it = returnedMessage.getAttachments();
            int idx = 0;
            while (it.hasNext()) {
                AttachmentPart attachment = (AttachmentPart)it.next();
                DataHandler dh = attachment.getDataHandler();
                log.info("Attachment size is: " + attachment.getSize());
                log.info("Attachment type is: " + attachment.getContentType());
                log.info("Attachment name is: " + name[idx]);
                ++idx;
            }
        }
        catch (RemoteException rex) {
            throw AxisFault.makeFault(rex);
        }
        catch (SOAPException sex) {
            throw AxisFault.makeFault(sex);
        }
    }
}

